/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.vcs.commit.AbstractCommitMessagePolicy;
import com.intellij.vcs.commit.CommitMessageUi;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fJ\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/commit/ChangesViewCommitMessagePolicy;", "Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy;", "project", "Lcom/intellij/openapi/project/Project;", "commitMessageUi", "Lcom/intellij/vcs/commit/CommitMessageUi;", "includedChanges", "Lkotlin/Function0;", "", "Lcom/intellij/openapi/vcs/changes/Change;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/commit/CommitMessageUi;Lkotlin/jvm/functions/Function0;)V", "init", "", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "disposable", "Lcom/intellij/openapi/Disposable;", "onChangelistChanged", "oldChangeList", "newChangeList", "onBeforeCommit", "onAfterCommit", "onDispose", "getCommitMessage", "", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nChangesViewCommitMessagePolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesViewCommitMessagePolicy.kt\ncom/intellij/vcs/commit/ChangesViewCommitMessagePolicy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,57:1\n1#2:58\n14#3:59\n*S KotlinDebug\n*F\n+ 1 ChangesViewCommitMessagePolicy.kt\ncom/intellij/vcs/commit/ChangesViewCommitMessagePolicy\n*L\n55#1:59\n*E\n"})
public final class ChangesViewCommitMessagePolicy
extends AbstractCommitMessagePolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommitMessageUi commitMessageUi;
    @NotNull
    private final Function0<List<Change>> includedChanges;
    @NotNull
    private static final Logger LOG;

    public ChangesViewCommitMessagePolicy(@NotNull Project project, @NotNull CommitMessageUi commitMessageUi, @NotNull Function0<? extends List<? extends Change>> includedChanges) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitMessageUi, (String)"commitMessageUi");
        Intrinsics.checkNotNullParameter(includedChanges, (String)"includedChanges");
        super(project);
        this.commitMessageUi = commitMessageUi;
        this.includedChanges = includedChanges;
    }

    public final void init(@NotNull LocalChangeList changeList, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.listenForDelayedProviders(this.commitMessageUi, disposable);
        this.commitMessageUi.setText(this.getCommitMessage(changeList));
    }

    public final void onChangelistChanged(@NotNull LocalChangeList oldChangeList, @NotNull LocalChangeList newChangeList) {
        Intrinsics.checkNotNullParameter((Object)oldChangeList, (String)"oldChangeList");
        Intrinsics.checkNotNullParameter((Object)newChangeList, (String)"newChangeList");
        String commitMessage = this.commitMessageUi.getText();
        this.getChangeListManager().editComment(oldChangeList.getName(), commitMessage);
        this.getVcsConfiguration().saveCommitMessage(commitMessage);
        this.commitMessageUi.setText(this.getCommitMessage(newChangeList));
    }

    public final void onBeforeCommit(@NotNull LocalChangeList changeList) {
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        String commitMessage = this.commitMessageUi.getText();
        this.getVcsConfiguration().saveCommitMessage(commitMessage);
        this.getChangeListManager().editComment(changeList.getName(), commitMessage);
    }

    public final void onAfterCommit(@NotNull LocalChangeList changeList) {
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        this.commitMessageUi.setText(this.getCommitMessage(changeList));
    }

    public final void onDispose(@NotNull LocalChangeList changeList) {
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        if (this.getChangeListManager().areChangeListsEnabled()) {
            String commitMessage = this.commitMessageUi.getText();
            this.getChangeListManager().editComment(changeList.getName(), commitMessage);
        }
    }

    private final String getCommitMessage(LocalChangeList changeList) {
        String string;
        block6: {
            block5: {
                String string2;
                if (this.getVcsConfiguration().CLEAR_INITIAL_COMMIT_MESSAGE) {
                    return "";
                }
                string = this.getCommitMessageForList(changeList);
                if (string == null) break block5;
                String it = string2 = string;
                boolean bl = false;
                string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
                if (string != null) break block6;
            }
            if ((string = this.getCommitMessageFromVcs((List)this.includedChanges.invoke())) == null && (string = this.getVcsConfiguration().LAST_COMMIT_MESSAGE) == null) {
                string = "";
            }
        }
        return string;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ChangesViewCommitMessagePolicy.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/commit/ChangesViewCommitMessagePolicy$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

