/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.diff.DiffManager;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDifferentiatedDialog;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchFile;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.ImportToShelfExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ApplyPatchUtil {
    private static final Logger LOG = Logger.getInstance(ApplyPatchUtil.class);

    public static void showApplyPatch(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ApplyPatchUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ApplyPatchUtil.$$$reportNull$$$0(1);
        }
        ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(project, new ApplyPatchDefaultExecutor(project), Collections.singletonList(new ImportToShelfExecutor(project)), ApplyPatchMode.APPLY, file);
        dialog.show();
    }

    @RequiresEdt
    public static Boolean showAndGetApplyPatch(@NotNull Project project, @NotNull File file) {
        if (project == null) {
            ApplyPatchUtil.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ApplyPatchUtil.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        String patchPath = file.getPath();
        if (vFile == null) {
            VcsNotifier.getInstance(project).notifyWeakError("vcs.patch.apply.cannot.find.patch.file", VcsBundle.message((String)"patch.apply.can.t.find.patch.file.warning", (Object[])new Object[]{HtmlChunk.text((String)patchPath)}));
            return false;
        }
        if (!PatchFileType.isPatchFile(vFile)) {
            VcsNotifier.getInstance(project).notifyWeakError("vcs.patch.apply.not.patch.type.file", VcsBundle.message((String)"patch.apply.not.patch.type.file.error", (Object[])new Object[]{HtmlChunk.text((String)vFile.getPath())}));
            return false;
        }
        return ApplyPatchUtil.showAndGetApplyPatch(project, new ApplyPatchFile(vFile));
    }

    @RequiresBackgroundThread
    @Nullable
    public static ApplyPatchFile getPatchFile(@NotNull File file) {
        if (file == null) {
            ApplyPatchUtil.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertBackgroundThread();
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        if (vFile == null || !PatchFileType.isPatchFile(vFile)) {
            return null;
        }
        return new ApplyPatchFile(vFile);
    }

    @RequiresEdt
    @NotNull
    public static Boolean showAndGetApplyPatch(@NotNull Project project, @NotNull ApplyPatchFile patchFile) {
        if (project == null) {
            ApplyPatchUtil.$$$reportNull$$$0(5);
        }
        if (patchFile == null) {
            ApplyPatchUtil.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ApplyPatchDifferentiatedDialog dialog = new ApplyPatchDifferentiatedDialog(project, new ApplyPatchDefaultExecutor(project), Collections.emptyList(), ApplyPatchMode.APPLY_PATCH_IN_MEMORY, patchFile.getFile());
        dialog.setModal(true);
        Boolean bl = dialog.showAndGet();
        if (bl == null) {
            ApplyPatchUtil.$$$reportNull$$$0(7);
        }
        return bl;
    }

    @NotNull
    public static ApplyPatchStatus applyContent(@NotNull Project project, @NotNull ApplyFilePatchBase<?> patch, @Nullable ApplyPatchContext context, @NotNull VirtualFile file, @Nullable CommitContext commitContext, boolean reverse, @Nullable String leftPanelTitle, @Nullable String rightPanelTitle) {
        ApplyPatchStatus applyPatchStatus;
        String patchedContent;
        ApplyFilePatch.Result result2;
        ApplyPatchStatus status;
        if (project == null) {
            ApplyPatchUtil.$$$reportNull$$$0(8);
        }
        if (patch == null) {
            ApplyPatchUtil.$$$reportNull$$$0(9);
        }
        if (file == null) {
            ApplyPatchUtil.$$$reportNull$$$0(10);
        }
        if (ApplyPatchStatus.ALREADY_APPLIED.equals((Object)(status = (result2 = ApplyPatchUtil.tryApplyPatch(project, patch, context, file, commitContext)).getStatus())) || ApplyPatchStatus.SUCCESS.equals((Object)status)) {
            ApplyPatchStatus applyPatchStatus2 = status;
            if (applyPatchStatus2 == null) {
                ApplyPatchUtil.$$$reportNull$$$0(11);
            }
            return applyPatchStatus2;
        }
        ApplyPatchForBaseRevisionTexts mergeData = result2.getMergeData();
        if (mergeData == null) {
            ApplyPatchStatus applyPatchStatus3 = status;
            if (applyPatchStatus3 == null) {
                ApplyPatchUtil.$$$reportNull$$$0(12);
            }
            return applyPatchStatus3;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            ApplyPatchStatus applyPatchStatus4 = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus4 == null) {
                ApplyPatchUtil.$$$reportNull$$$0(13);
            }
            return applyPatchStatus4;
        }
        if (mergeData.getBase() == null && ApplyPatchStatus.PARTIAL.equals((Object)status)) {
            WriteAction.run(() -> {
                VcsFacade.getInstance().runHeavyModificationTask(project, document, () -> document.setText((CharSequence)mergeData.getPatched()));
                FileDocumentManager.getInstance().saveDocument(document);
            });
            ApplyPatchStatus applyPatchStatus5 = status;
            if (applyPatchStatus5 == null) {
                ApplyPatchUtil.$$$reportNull$$$0(14);
            }
            return applyPatchStatus5;
        }
        String baseContent = ApplyPatchUtil.convertLineSeparators(mergeData.getBase());
        String localContent = ApplyPatchUtil.convertLineSeparators(mergeData.getLocal());
        if (localContent.equals(patchedContent = mergeData.getPatched())) {
            ApplyPatchStatus applyPatchStatus6 = ApplyPatchStatus.ALREADY_APPLIED;
            if (applyPatchStatus6 == null) {
                ApplyPatchUtil.$$$reportNull$$$0(15);
            }
            return applyPatchStatus6;
        }
        Ref applyPatchStatusReference = new Ref();
        Consumer callback = result13 -> {
            FileDocumentManager.getInstance().saveDocument(document);
            applyPatchStatusReference.setIfNull((Object)(result13 != MergeResult.CANCEL ? ApplyPatchStatus.SUCCESS : ApplyPatchStatus.FAILURE));
        };
        try {
            MergeRequest request;
            if (baseContent != null) {
                if (reverse) {
                    if (leftPanelTitle == null) {
                        leftPanelTitle = VcsBundle.message((String)"patch.apply.conflict.patched.version", (Object[])new Object[0]);
                    }
                    if (rightPanelTitle == null) {
                        rightPanelTitle = VcsBundle.message((String)"patch.apply.conflict.local.version", (Object[])new Object[0]);
                    }
                    List<String> contents = Arrays.asList(patchedContent, baseContent, localContent);
                    List<String> titles = Arrays.asList(leftPanelTitle, null, rightPanelTitle);
                    request = PatchDiffRequestFactory.createMergeRequest(project, document, file, contents, null, titles, (Consumer<? super MergeResult>)callback);
                } else {
                    request = PatchDiffRequestFactory.createMergeRequest(project, document, file, baseContent, localContent, patchedContent, (Consumer<? super MergeResult>)callback);
                }
            } else {
                TextFilePatch textPatch = (TextFilePatch)patch.getPatch();
                GenericPatchApplier applier = new GenericPatchApplier(localContent, textPatch.getHunks());
                applier.execute();
                AppliedTextPatch appliedTextPatch = AppliedTextPatch.create(applier.getAppliedInfo());
                request = PatchDiffRequestFactory.createBadMergeRequest(project, document, file, localContent, appliedTextPatch, (Consumer<? super MergeResult>)callback);
            }
            request.putUserData(DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS, result12 -> result12.equals((Object)MergeResult.CANCEL) ? VcsBundle.message((String)"patch.apply.abort.action", (Object[])new Object[0]) : null);
            request.putUserData(DiffUserDataKeysEx.MERGE_CANCEL_HANDLER, viewer -> {
                String message = VcsBundle.message((String)"patch.apply.abort.and.rollback.prompt", (Object[])new Object[0]);
                String title = VcsBundle.message((String)"patch.apply.abort.title", (Object[])new Object[0]);
                String yesText = VcsBundle.message((String)"patch.apply.abort.and.rollback.action", (Object[])new Object[0]);
                String noText = VcsBundle.message((String)"patch.apply.skip.action", (Object[])new Object[0]);
                String cancelText = VcsBundle.message((String)"patch.apply.continue.resolve.action", (Object[])new Object[0]);
                int result1 = Messages.showYesNoCancelDialog((Component)viewer.getComponent().getRootPane(), (String)message, (String)title, (String)yesText, (String)noText, (String)cancelText, (Icon)Messages.getQuestionIcon());
                if (result1 == 0) {
                    applyPatchStatusReference.set((Object)ApplyPatchStatus.ABORT);
                } else if (result1 == 1) {
                    applyPatchStatusReference.set((Object)ApplyPatchStatus.SKIP);
                }
                return result1 != 2;
            });
            DiffManager.getInstance().showMerge(project, request);
            applyPatchStatus = (ApplyPatchStatus)((Object)applyPatchStatusReference.get());
        }
        catch (InvalidDiffRequestException e) {
            LOG.warn((Throwable)e);
            ApplyPatchStatus applyPatchStatus7 = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus7 == null) {
                ApplyPatchUtil.$$$reportNull$$$0(17);
            }
            return applyPatchStatus7;
        }
        if (applyPatchStatus == null) {
            ApplyPatchUtil.$$$reportNull$$$0(16);
        }
        return applyPatchStatus;
    }

    @NotNull
    private static ApplyFilePatch.Result tryApplyPatch(@NotNull Project project, @NotNull ApplyFilePatchBase<?> patch, @Nullable ApplyPatchContext context, @NotNull VirtualFile file, @Nullable CommitContext commitContext) {
        if (project == null) {
            ApplyPatchUtil.$$$reportNull$$$0(18);
        }
        if (patch == null) {
            ApplyPatchUtil.$$$reportNull$$$0(19);
        }
        if (file == null) {
            ApplyPatchUtil.$$$reportNull$$$0(20);
        }
        Object patchBase = patch.getPatch();
        ApplyFilePatch.Result result2 = (ApplyFilePatch.Result)WriteAction.compute(() -> {
            try {
                return patch.apply(file, context, project, VcsUtil.getFilePath((VirtualFile)file), () -> {
                    String path = (String)ObjectUtils.chooseNotNull((Object)patchBase.getBeforeName(), (Object)patchBase.getAfterName());
                    return BaseRevisionTextPatchEP.getBaseContent(project, path, commitContext);
                }, commitContext);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return ApplyFilePatch.FAILURE;
            }
        });
        if (result2 == null) {
            ApplyPatchUtil.$$$reportNull$$$0(21);
        }
        return result2;
    }

    @Nullable
    private static String convertLineSeparators(@Nullable String charSequence) {
        return charSequence != null ? StringUtil.convertLineSeparators((String)charSequence) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11, 12, 13, 14, 15, 16, 17, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchFile";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchUtil";
                break;
            }
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "showAndGetApplyPatch";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "applyContent";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "tryApplyPatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showApplyPatch";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showAndGetApplyPatch";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPatchFile";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyContent";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "tryApplyPatch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11, 12, 13, 14, 15, 16, 17, 21 -> new IllegalStateException(string);
        };
    }
}

