/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.core.nio.fs;

import com.intellij.platform.core.nio.fs.CorePath;
import com.intellij.platform.core.nio.fs.CorePosixFilteringFileSystemProvider;
import com.intellij.platform.core.nio.fs.CoreRoutingFileSystem;
import com.intellij.platform.core.nio.fs.CoreRoutingFileSystemDelegate;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.Nullable;

public class CoreRoutingFileSystemProvider
extends FileSystemProvider {
    public static final String SEPARATOR = "/";
    private static final String INITIALIZATION_KEY = "CoreRoutingFSInitialization";
    private static final String INITIALIZATION_MOUNTED_FS_PROVIDER_KEY = "RoutingFilesystemInitialization_MountedFSProvider";
    private static final String PROVIDER_CLASS_NAME = "ProviderClassName";
    private static final String PATH_CLASS_NAME = "PathClassName";
    private static final String MOUNTED_FS_PREFIX = "MountedFSPrefix";
    private static final String FILESYSTEM_CLASS_NAME = "FilesystemClassName";
    private static final String ROUTING_FILESYSTEM_DELEGATE_CLASS = "RoutingFilesystemDelegateClass";
    private final Object myLock = new Object();
    private final FileSystemProvider myLocalProvider;
    private final CoreRoutingFileSystem myFileSystem;
    private final boolean myUseContextClassLoader;
    private volatile FileSystemProvider myProvider;
    private volatile String myProviderClassName;

    public CoreRoutingFileSystemProvider(FileSystemProvider localFSProvider) {
        this(localFSProvider, true);
    }

    public CoreRoutingFileSystemProvider(FileSystemProvider localFSProvider, boolean useContextClassLoader) {
        FileSystem fileSystem = localFSProvider.getFileSystem(URI.create("file:///"));
        this.myLocalProvider = fileSystem.supportedFileAttributeViews().contains("posix") ? localFSProvider : new CorePosixFilteringFileSystemProvider(localFSProvider);
        this.myFileSystem = new CoreRoutingFileSystem(this, fileSystem);
        this.myUseContextClassLoader = useContextClassLoader;
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        return this.myFileSystem;
    }

    @Override
    public String getScheme() {
        return this.getProvider().getScheme();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) {
        if (env.get(INITIALIZATION_KEY) == Boolean.TRUE) {
            CoreRoutingFileSystem.setMountedFSPrefix((String)env.get(MOUNTED_FS_PREFIX));
            CorePath.setMountedDelegateClassName((String)env.get(PATH_CLASS_NAME));
            this.myProviderClassName = (String)env.get(PROVIDER_CLASS_NAME);
            if (env.get(INITIALIZATION_MOUNTED_FS_PROVIDER_KEY) == Boolean.TRUE) {
                Object object = this.myLock;
                synchronized (object) {
                    this.myFileSystem.initialize((String)env.get(FILESYSTEM_CLASS_NAME), (Class)env.get(ROUTING_FILESYSTEM_DELEGATE_CLASS));
                    this.getMountedFSProvider();
                    return null;
                }
            }
            this.myFileSystem.initialize((String)env.get(FILESYSTEM_CLASS_NAME), (Class)env.get(ROUTING_FILESYSTEM_DELEGATE_CLASS));
            return null;
        }
        throw new IllegalStateException("File system already exists");
    }

    public static void initialize(FileSystemProvider provider, String providerClassName, String pathClassName, String mountedFSPrefix, String filesystemClassName, @Nullable Class<? extends CoreRoutingFileSystemDelegate> routingFilesystemDelegateClass, boolean initializeMountedFSProvider) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(INITIALIZATION_KEY, true);
        map.put(INITIALIZATION_MOUNTED_FS_PROVIDER_KEY, initializeMountedFSProvider);
        map.put(PROVIDER_CLASS_NAME, providerClassName);
        map.put(PATH_CLASS_NAME, pathClassName);
        map.put(MOUNTED_FS_PREFIX, mountedFSPrefix);
        map.put(FILESYSTEM_CLASS_NAME, filesystemClassName);
        map.put(ROUTING_FILESYSTEM_DELEGATE_CLASS, routingFilesystemDelegateClass);
        provider.newFileSystem(URI.create("file:///"), map);
    }

    @Override
    public Path getPath(URI uri) {
        return this.path(this.getProvider(uri).getPath(uri));
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        return this.path(this.getProvider(link).readSymbolicLink(CoreRoutingFileSystemProvider.unwrap(link)));
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.getProvider(path).newByteChannel(CoreRoutingFileSystemProvider.unwrap(path), options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        DirectoryStream.Filter<Path> wrappedFilter = filter != null ? path -> filter.accept(this.path((Path)path)) : null;
        final DirectoryStream<Path> stream = this.getProvider(dir).newDirectoryStream(CoreRoutingFileSystemProvider.unwrap(dir), wrappedFilter);
        return stream == null ? null : new DirectoryStream<Path>(){

            @Override
            public void close() throws IOException {
                stream.close();
            }

            @Override
            public Iterator<Path> iterator() {
                final Iterator iterator = stream.iterator();
                return new Iterator<Path>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Path next() {
                        return CoreRoutingFileSystemProvider.this.path((Path)iterator.next());
                    }
                };
            }
        };
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        this.getProvider(dir).createDirectory(CoreRoutingFileSystemProvider.unwrap(dir), attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        this.getProvider(path).delete(CoreRoutingFileSystemProvider.unwrap(path));
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        this.getProvider(source, target).copy(CoreRoutingFileSystemProvider.unwrap(source), CoreRoutingFileSystemProvider.unwrap(target), options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.getProvider(source, target).move(CoreRoutingFileSystemProvider.unwrap(source), CoreRoutingFileSystemProvider.unwrap(target), options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return this.getProvider(path, path2).isSameFile(CoreRoutingFileSystemProvider.unwrap(path), CoreRoutingFileSystemProvider.unwrap(path2));
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return this.getProvider(path).isHidden(CoreRoutingFileSystemProvider.unwrap(path));
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return this.getProvider(path).getFileStore(CoreRoutingFileSystemProvider.unwrap(path));
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.getProvider(path).checkAccess(CoreRoutingFileSystemProvider.unwrap(path), modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return this.getProvider(path).getFileAttributeView(CoreRoutingFileSystemProvider.unwrap(path), type, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return this.getProvider(path).readAttributes(CoreRoutingFileSystemProvider.unwrap(path), type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return this.getProvider(path).readAttributes(CoreRoutingFileSystemProvider.unwrap(path), attributes, options);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        this.getProvider(path).setAttribute(CoreRoutingFileSystemProvider.unwrap(path), attribute, value, options);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        return this.tryGetLocalProvider(path).newAsynchronousFileChannel(CoreRoutingFileSystemProvider.unwrap(path), options, executor, attrs);
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        this.tryGetLocalProvider(link).createSymbolicLink(CoreRoutingFileSystemProvider.unwrap(link), CoreRoutingFileSystemProvider.unwrap(target), attrs);
    }

    @Override
    public void createLink(Path link, Path existing) throws IOException {
        this.tryGetLocalProvider(link).createLink(CoreRoutingFileSystemProvider.unwrap(link), CoreRoutingFileSystemProvider.unwrap(existing));
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.getProvider(path).newFileChannel(CoreRoutingFileSystemProvider.unwrap(path), options, attrs);
    }

    public byte[] getSunPathForSocketFile(Path path) {
        if (this.isMountedFSPath(path)) {
            throw new IllegalArgumentException(path.toString());
        }
        String jnuEncoding = System.getProperty("sun.jnu.encoding");
        try {
            return path.toString().getBytes(jnuEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("sun.jnu.encoding=" + jnuEncoding, e);
        }
    }

    private boolean isInitialized() {
        return this.myFileSystem.isInitialized();
    }

    private FileSystemProvider tryGetLocalProvider(Path path) {
        if (this.isMountedFSPath(path)) {
            throw new UnsupportedOperationException();
        }
        return this.myLocalProvider;
    }

    private FileSystemProvider getProvider() {
        return this.isInitialized() ? this.getMountedFSProvider() : this.myLocalProvider;
    }

    private FileSystemProvider getProvider(URI uri) {
        return this.isInitialized() && CoreRoutingFileSystemProvider.isMountedFSURI(uri) ? this.getMountedFSProvider() : this.myLocalProvider;
    }

    private FileSystemProvider getProvider(Path path) {
        return this.isInitialized() && this.isMountedFSPath(path) ? this.getMountedFSProvider() : this.myLocalProvider;
    }

    private FileSystemProvider getProvider(Path ... path) {
        FileSystemProvider provider = null;
        for (Path p : path) {
            FileSystemProvider current = this.getProvider(p);
            if (provider == null) {
                provider = current;
                continue;
            }
            if (current == provider) continue;
            throw new IllegalArgumentException("Provider mismatch");
        }
        return Objects.requireNonNull(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystemProvider getMountedFSProvider() {
        if (this.myProvider == null) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myProvider == null) {
                    this.myProvider = (FileSystemProvider)this.createInstance(this.myProviderClassName, new Class[]{FileSystem.class}, this.myFileSystem);
                }
            }
        }
        return this.myProvider;
    }

    protected Path path(Path path) {
        return path == null ? null : CoreRoutingFileSystemProvider.path(this.myFileSystem, path);
    }

    public static Path path(CoreRoutingFileSystem fileSystem, Path path) {
        return path instanceof CorePath ? path : new CorePath(fileSystem, path);
    }

    protected boolean isMountedFSPath(Path path) {
        return path instanceof CorePath && this.myFileSystem.isMountedFSPath((CorePath)path);
    }

    private static boolean isMountedFSURI(URI uri) {
        return uri != null && CoreRoutingFileSystem.isMountedFSFile(uri.getPath());
    }

    public static Path unwrap(Path path) {
        return path == null ? null : ((CorePath)path).getDelegate();
    }

    public <T> T createInstance(String className, Class<?>[] paramClasses, Object ... params) {
        try {
            ClassLoader loader = this.myUseContextClassLoader ? Thread.currentThread().getContextClassLoader() : CoreRoutingFileSystemProvider.class.getClassLoader();
            String loaderName = loader.getClass().getName();
            if (!("com.intellij.util.lang.PathClassLoader".equals(loaderName) || "com.intellij.util.lang.UrlClassLoader".equals(loaderName) || "com.intellij.ide.plugins.cl.PluginClassLoader".equals(loaderName))) {
                throw new RuntimeException("Trying to initialize a mounted file system with wrong classloader: " + loader);
            }
            Class<?> loaded = loader.loadClass(className);
            return (T)loaded.getConstructor(paramClasses).newInstance(params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String normalizePath(String path) {
        return path.replace("\\", SEPARATOR);
    }
}

