/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.modelBuilder;

import com.intellij.gradle.toolingExtension.impl.modelBuilder.DefaultMessageReportBuilder;
import org.gradle.api.Project;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.internal.impldep.com.google.gson.GsonBuilder;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.MessageReportBuilder;
import org.jetbrains.plugins.gradle.tooling.MessageReporter;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class DefaultMessageReporter
implements MessageReporter {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.jetbrains.plugins.gradle.toolingExtension.modelBuilder");

    @NotNull
    public MessageReportBuilder createMessage() {
        return new DefaultMessageReportBuilder(this);
    }

    public void reportMessage(@NotNull Project project, @NotNull Message message) {
        if (project == null) {
            DefaultMessageReporter.$$$reportNull$$$0(0);
        }
        if (message == null) {
            DefaultMessageReporter.$$$reportNull$$$0(1);
        }
        try {
            if (project instanceof DefaultProject) {
                DefaultMessageReporter.reportMessageByProgressLogger((DefaultProject)project, message);
            } else {
                DefaultMessageReporter.reportMessageByGlobalLogger(message);
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed to report model builder message", e);
        }
    }

    private static void reportMessageByProgressLogger(@NotNull DefaultProject project, @NotNull Message message) {
        if (project == null) {
            DefaultMessageReporter.$$$reportNull$$$0(2);
        }
        if (message == null) {
            DefaultMessageReporter.$$$reportNull$$$0(3);
        }
        ProgressLoggerFactory progressLoggerFactory = (ProgressLoggerFactory)project.getServices().get(ProgressLoggerFactory.class);
        ProgressLogger operation = progressLoggerFactory.newOperation(ModelBuilderService.class);
        String jsonMessage = new GsonBuilder().create().toJson((Object)message);
        operation.setDescription("ModelBuilderService message: " + jsonMessage);
        operation.started();
        operation.completed();
    }

    private static void reportMessageByGlobalLogger(@NotNull Message message) {
        if (message == null) {
            DefaultMessageReporter.$$$reportNull$$$0(4);
        }
        switch (message.getKind()) {
            case ERROR: {
                LOG.error(message.getText());
                break;
            }
            case WARNING: {
                LOG.warn(message.getText());
                break;
            }
            case INFO: {
                LOG.info(message.getText());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/modelBuilder/DefaultMessageReporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reportMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportMessageByProgressLogger";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reportMessageByGlobalLogger";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

