/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal.undo;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverScope;
import androidx.compose.runtime.snapshots.SnapshotStateList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001d*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001dB/\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0013\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u000b\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u000b\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\t\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/compose/foundation/text/input/internal/undo/UndoManager;", "T", "", "initialUndoStack", "", "initialRedoStack", "capacity", "", "(Ljava/util/List;Ljava/util/List;I)V", "canRedo", "", "getCanRedo$foundation", "()Z", "canUndo", "getCanUndo$foundation", "redoStack", "Landroidx/compose/runtime/snapshots/SnapshotStateList;", "size", "getSize", "()I", "undoStack", "clearHistory", "", "record", "undoableAction", "(Ljava/lang/Object;)V", "redo", "()Ljava/lang/Object;", "undo", "Companion", "foundation"})
@StabilityInferred(parameters=0)
public final class UndoManager<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int capacity;
    @NotNull
    private SnapshotStateList<T> undoStack;
    @NotNull
    private SnapshotStateList<T> redoStack;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public UndoManager(@NotNull List<? extends T> initialUndoStack, @NotNull List<? extends T> initialRedoStack, int capacity) {
        void $this$redoStack_u24lambda_u241;
        SnapshotStateList $this$undoStack_u24lambda_u240;
        SnapshotStateList snapshotStateList;
        Intrinsics.checkNotNullParameter(initialUndoStack, (String)"initialUndoStack");
        Intrinsics.checkNotNullParameter(initialRedoStack, (String)"initialRedoStack");
        this.capacity = capacity;
        SnapshotStateList snapshotStateList2 = snapshotStateList = new SnapshotStateList();
        UndoManager undoManager = this;
        boolean bl = false;
        $this$undoStack_u24lambda_u240.addAll((Collection)initialUndoStack);
        undoManager.undoStack = snapshotStateList;
        $this$undoStack_u24lambda_u240 = snapshotStateList = new SnapshotStateList();
        undoManager = this;
        boolean bl2 = false;
        $this$redoStack_u24lambda_u241.addAll((Collection)initialRedoStack);
        undoManager.redoStack = snapshotStateList;
        if (!(this.capacity >= 0)) {
            boolean $i$a$-require-UndoManager$32 = false;
            String $i$a$-require-UndoManager$32 = "Capacity must be a positive integer";
            throw new IllegalArgumentException($i$a$-require-UndoManager$32.toString());
        }
        if (!(this.getSize() <= this.capacity)) {
            boolean bl3 = false;
            String string2 = "Initial list of undo and redo operations have a size=(" + this.getSize() + ") greater than the given capacity=(" + this.capacity + ").";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ UndoManager(List list2, List list3, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 2) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n2 & 4) != 0) {
            n = 100;
        }
        this(list2, list3, n);
    }

    public final boolean getCanUndo$foundation() {
        return !((Collection)this.undoStack).isEmpty();
    }

    public final boolean getCanRedo$foundation() {
        return !((Collection)this.redoStack).isEmpty();
    }

    public final int getSize() {
        return this.undoStack.size() + this.redoStack.size();
    }

    public final void record(T undoableAction) {
        this.redoStack.clear();
        while (this.getSize() > this.capacity - 1) {
            CollectionsKt.removeFirst((List)this.undoStack);
        }
        this.undoStack.add(undoableAction);
    }

    public final T undo() {
        if (!this.getCanUndo$foundation()) {
            boolean bl = false;
            String string2 = "It's an error to call undo while there is nothing to undo. Please first check `canUndo` value before calling the `undo` function.";
            throw new IllegalStateException(string2.toString());
        }
        Object topOperation = CollectionsKt.removeLast((List)this.undoStack);
        this.redoStack.add(topOperation);
        return (T)topOperation;
    }

    public final T redo() {
        if (!this.getCanRedo$foundation()) {
            boolean bl = false;
            String string2 = "It's an error to call redo while there is nothing to redo. Please first check `canRedo` value before calling the `redo` function.";
            throw new IllegalStateException(string2.toString());
        }
        Object topOperation = CollectionsKt.removeLast((List)this.redoStack);
        this.undoStack.add(topOperation);
        return (T)topOperation;
    }

    public final void clearHistory() {
        this.undoStack.clear();
        this.redoStack.clear();
    }

    public UndoManager() {
        this(null, null, 0, 7, null);
    }

    public static final /* synthetic */ int access$getCapacity$p(UndoManager $this) {
        return $this.capacity;
    }

    public static final /* synthetic */ SnapshotStateList access$getUndoStack$p(UndoManager $this) {
        return $this.undoStack;
    }

    public static final /* synthetic */ SnapshotStateList access$getRedoStack$p(UndoManager $this) {
        return $this.redoStack;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u0005\u0012\u0004\u0012\u00020\u00010\u0004\"\u0006\b\u0001\u0010\u0006\u0018\u00012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00010\u0004H\u0086\b\u00a8\u0006\b"}, d2={"Landroidx/compose/foundation/text/input/internal/undo/UndoManager$Companion;", "", "()V", "createSaver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/foundation/text/input/internal/undo/UndoManager;", "T", "itemSaver", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ <T> Saver<UndoManager<T>, Object> createSaver(Saver<T, Object> itemSaver) {
            Intrinsics.checkNotNullParameter(itemSaver, (String)"itemSaver");
            boolean $i$f$createSaver = false;
            Intrinsics.needClassReification();
            return new Saver<UndoManager<T>, Object>(itemSaver){
                final /* synthetic */ Saver<T, Object> $itemSaver;
                {
                    this.$itemSaver = $itemSaver;
                }

                @NotNull
                public Object save(@NotNull SaverScope $this$save, @NotNull UndoManager<T> value) {
                    E it;
                    E item$iv;
                    int index$iv;
                    List list2;
                    Intrinsics.checkNotNullParameter((Object)$this$save, (String)"<this>");
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    Saver<T, Object> saver2 = this.$itemSaver;
                    List $this$save_u24lambda_u244 = list2 = CollectionsKt.createListBuilder();
                    boolean bl = false;
                    $this$save_u24lambda_u244.add(UndoManager.access$getCapacity$p(value));
                    $this$save_u24lambda_u244.add(UndoManager.access$getUndoStack$p(value).size());
                    $this$save_u24lambda_u244.add(UndoManager.access$getRedoStack$p(value).size());
                    List $this$fastForEach$iv = UndoManager.access$getUndoStack$p(value);
                    boolean $i$f$fastForEach = false;
                    int n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        it = item$iv = $this$fastForEach$iv.get(index$iv);
                        boolean bl2 = false;
                        Saver<T, Object> $this$save_u24lambda_u244_u24lambda_u241_u24lambda_u240 = saver2;
                        boolean bl3 = false;
                        $this$save_u24lambda_u244.add($this$save_u24lambda_u244_u24lambda_u241_u24lambda_u240.save($this$save, it));
                    }
                    $this$fastForEach$iv = UndoManager.access$getRedoStack$p(value);
                    $i$f$fastForEach = false;
                    n = $this$fastForEach$iv.size();
                    for (index$iv = 0; index$iv < n; ++index$iv) {
                        it = item$iv = $this$fastForEach$iv.get(index$iv);
                        boolean bl4 = false;
                        Saver<T, Object> $this$save_u24lambda_u244_u24lambda_u243_u24lambda_u242 = saver2;
                        boolean bl5 = false;
                        $this$save_u24lambda_u244.add($this$save_u24lambda_u244_u24lambda_u243_u24lambda_u242.save($this$save, it));
                    }
                    return CollectionsKt.build((List)list2);
                }

                @NotNull
                public UndoManager<T> restore(@NotNull Object value) {
                    List list2;
                    List list3;
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    List list4 = list3 = (List)value;
                    int capacity = ((Number)list4.get(0)).intValue();
                    int undoSize = ((Number)list4.get(1)).intValue();
                    int redoSize = ((Number)list4.get(2)).intValue();
                    int i = 0;
                    Saver<T, Object> saver2 = this.$itemSaver;
                    Object object = CollectionsKt.createListBuilder();
                    List $this$restore_u24lambda_u245 = object;
                    boolean bl = false;
                    for (i = 3; i < undoSize + 3; ++i) {
                        T t = saver2.restore(list3.get(i));
                        Intrinsics.checkNotNull(t);
                        $this$restore_u24lambda_u245.add(t);
                    }
                    List undoStackItems = CollectionsKt.build((List)object);
                    object = this.$itemSaver;
                    List $this$restore_u24lambda_u246 = list2 = CollectionsKt.createListBuilder();
                    boolean bl2 = false;
                    while (i < undoSize + redoSize + 3) {
                        Original Original = object.restore(list3.get(i));
                        Intrinsics.checkNotNull(Original);
                        $this$restore_u24lambda_u246.add(Original);
                        ++i;
                    }
                    List redoStackItems = CollectionsKt.build((List)list2);
                    return new UndoManager<T>(undoStackItems, redoStackItems, capacity);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

