/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.util.SystemProperties;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\tJ\u001a\u0010\u0013\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/util/JavaParametersBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "setDefaultSdk", "", "mainClassName", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "build", "Lcom/intellij/execution/configurations/JavaParameters;", "getDefaultShortenCommandLineMethod", "Lcom/intellij/execution/ShortenCommandLine;", "rootPath", "withMainClassName", "name", "withSdkFrom", "module", "Lcom/intellij/openapi/module/Module;", "setDefault", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nrunConfigurationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 runConfigurationHelper.kt\norg/jetbrains/kotlin/idea/util/JavaParametersBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class JavaParametersBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private boolean setDefaultSdk;
    @Nullable
    private String mainClassName;
    @Nullable
    private Sdk sdk;

    public JavaParametersBuilder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final JavaParameters build() {
        JavaParameters javaParameters;
        JavaParameters $this$build_u24lambda_u240 = javaParameters = new JavaParameters();
        boolean bl = false;
        $this$build_u24lambda_u240.setMainClass(this.mainClassName);
        $this$build_u24lambda_u240.setJdk(this.sdk);
        if ($this$build_u24lambda_u240.getJdk() == null && this.setDefaultSdk) {
            $this$build_u24lambda_u240.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
        }
        Sdk sdk = $this$build_u24lambda_u240.getJdk();
        $this$build_u24lambda_u240.setShortenCommandLine(this.getDefaultShortenCommandLineMethod(sdk != null ? sdk.getHomePath() : null), this.project);
        return javaParameters;
    }

    private final ShortenCommandLine getDefaultShortenCommandLineMethod(String rootPath) {
        if (rootPath != null && JdkUtil.isModularRuntime((String)rootPath)) {
            return ShortenCommandLine.ARGS_FILE;
        }
        return JdkUtil.useClasspathJar() ? ShortenCommandLine.MANIFEST : ShortenCommandLine.CLASSPATH_FILE;
    }

    @NotNull
    public final JavaParametersBuilder withMainClassName(@Nullable String name2) {
        this.mainClassName = name2;
        return this;
    }

    @NotNull
    public final JavaParametersBuilder withSdkFrom(@Nullable Module module, boolean setDefault) {
        if (module != null) {
            Module it = module;
            boolean bl = false;
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk != null && sdk.getSdkType() instanceof JavaSdkType) {
                boolean bl2;
                String string = sdk.getHomePath();
                if (string != null) {
                    String it2 = string;
                    boolean bl3 = false;
                    Path path2 = Paths.get(it2, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    bl2 = Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    this.sdk = sdk;
                }
            }
        }
        this.setDefaultSdk = setDefault;
        return this;
    }

    public static /* synthetic */ JavaParametersBuilder withSdkFrom$default(JavaParametersBuilder javaParametersBuilder, Module module, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return javaParametersBuilder.withSdkFrom(module, bl);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/util/JavaParametersBuilder$Companion;", "", "<init>", "()V", "getModuleDependencies", "", "", "module", "Lcom/intellij/openapi/module/Module;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getModuleDependencies(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Module[] moduleArray = new Module[]{module};
            String[] stringArray = CompilerPaths.getOutputPaths((Module[])moduleArray);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getOutputPaths(...)");
            Collection collection = ArraysKt.toList((Object[])stringArray);
            List list2 = OrderEnumerator.orderEntries((Module)module).withoutSdk().recursively().getPathsList().getPathList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPathList(...)");
            return CollectionsKt.plus((Collection)collection, (Iterable)list2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

