/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.ide.util.TreeJavaClassChooserDialog;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.AbstractMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.EditorComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.core.completion.DescriptorBasedDeclarationLookupObject;
import org.jetbrains.kotlin.idea.core.completion.PackageLookupObject;
import org.jetbrains.kotlin.idea.projectView.KtClassOrObjectTreeNode;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionPanel;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionTable;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.Model;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.ModelResultWithFUSData;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui.MoveKotlinNestedClassesModel;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinTypeReferenceEditorComboWithBrowseButton;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;

public class MoveKotlinNestedClassesDialog
extends RefactoringDialog {
    private static final String RECENTS_KEY = MoveKotlinNestedClassesDialog.class.getName() + ".RECENTS_KEY";
    private final KtClassOrObject originalClass;
    private final MoveCallback moveCallback;
    private JPanel mainPanel;
    private JTextField originalClassField;
    private JPanel membersInfoPanel;
    private KotlinTypeReferenceEditorComboWithBrowseButton targetClassChooser;
    private JCheckBox openInEditorCheckBox;
    private JPanel targetClassChooserPanel;
    private KotlinMemberSelectionTable memberTable;
    private PsiElement targetClass;
    @Nullable
    private PsiDirectory targetDirectory;
    private GlobalSearchScope searchScope;
    private final int initializedCheckBoxesState;

    public MoveKotlinNestedClassesDialog(@NotNull Project project, @NotNull List<KtClassOrObject> elementsToMove, @NotNull KtClassOrObject originalClass, @NotNull KtClassOrObject targetClass, @Nullable PsiDirectory targetDirectory, @Nullable MoveCallback moveCallback) {
        Module module;
        if (project == null) {
            MoveKotlinNestedClassesDialog.$$$reportNull$$$0(0);
        }
        if (elementsToMove == null) {
            MoveKotlinNestedClassesDialog.$$$reportNull$$$0(1);
        }
        if (originalClass == null) {
            MoveKotlinNestedClassesDialog.$$$reportNull$$$0(2);
        }
        if (targetClass == null) {
            MoveKotlinNestedClassesDialog.$$$reportNull$$$0(3);
        }
        super(project, true);
        this.originalClass = originalClass;
        this.targetClass = targetClass;
        this.moveCallback = moveCallback;
        this.targetDirectory = targetDirectory;
        this.$$$setupUI$$$();
        this.searchScope = GlobalSearchScope.projectScope((Project)project);
        if (targetDirectory != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)targetDirectory)) != null) {
            this.searchScope = module.getModuleScope();
        }
        this.init();
        this.setTitle(MoveHandler.getRefactoringName());
        this.initClassChooser(targetClass);
        this.initMemberInfo(elementsToMove);
        this.validateButtons();
        this.myHelpAction.setEnabled(false);
        this.initializedCheckBoxesState = this.getCheckboxesState();
    }

    private int getCheckboxesState() {
        return this.openInEditorCheckBox.isSelected() ? 1 : 0;
    }

    private void initClassChooser(@NotNull KtClassOrObject initialTargetClass) {
        if (initialTargetClass == null) {
            MoveKotlinNestedClassesDialog.$$$reportNull$$$0(4);
        }
        this.originalClassField.setText(this.originalClass.getFqName().asString());
        this.targetClassChooser = new KotlinTypeReferenceEditorComboWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeJavaClassChooserDialog chooser2 = new TreeJavaClassChooserDialog(RefactoringBundle.message((String)"choose.destination.class"), MoveKotlinNestedClassesDialog.this.myProject, MoveKotlinNestedClassesDialog.this.searchScope, MoveKotlinNestedClassesDialog.this::classMatchesFilter, null, null, true){

                    @Nullable
                    protected PsiClass getSelectedFromTreeUserObject(DefaultMutableTreeNode node) {
                        PsiClass psiClass = super.getSelectedFromTreeUserObject(node);
                        if (psiClass != null) {
                            return psiClass;
                        }
                        Object userObject = node.getUserObject();
                        if (!(userObject instanceof KtClassOrObjectTreeNode)) {
                            return null;
                        }
                        return LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)((KtClassOrObjectTreeNode)((Object)userObject)).getValue()));
                    }
                };
                chooser2.selectDirectory((MoveKotlinNestedClassesDialog.this.targetClass != null ? MoveKotlinNestedClassesDialog.this.targetClass : MoveKotlinNestedClassesDialog.this.originalClass).getContainingFile().getContainingDirectory());
                chooser2.showDialog();
                PsiClass aClass = chooser2.getSelected();
                if (aClass instanceof KtLightClassForSourceDeclaration) {
                    MoveKotlinNestedClassesDialog.this.targetClass = ((KtLightClassForSourceDeclaration)aClass).getKotlinOrigin();
                    MoveKotlinNestedClassesDialog.this.targetClassChooser.setText(Objects.requireNonNull(aClass.getQualifiedName()));
                } else {
                    MoveKotlinNestedClassesDialog.this.targetClass = aClass;
                }
            }
        }, initialTargetClass.getFqName().asString(), (PsiElement)this.originalClass, RECENTS_KEY);
        KtTypeCodeFragment codeFragment = this.targetClassChooser.getCodeFragment();
        if (codeFragment != null) {
            CompletionUtilsKt.setExtraCompletionFilter((KtCodeFragment)codeFragment, (Function1<? super LookupElement, Boolean>)((Function1)lookupElement2 -> {
                Object lookupObject = lookupElement2.getObject();
                if (!(lookupObject instanceof DescriptorBasedDeclarationLookupObject)) {
                    return false;
                }
                PsiElement psiElement = ((DescriptorBasedDeclarationLookupObject)lookupObject).getPsiElement();
                if (lookupObject instanceof PackageLookupObject) {
                    return true;
                }
                return psiElement instanceof KtClassOrObject && KotlinCommonRefactoringUtilKt.canRefactorElement(psiElement);
            }));
        }
        ((EditorComboBox)this.targetClassChooser.getChildComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                PsiClass aClass;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                MoveKotlinNestedClassesDialog.this.targetClass = (aClass = JavaPsiFacade.getInstance((Project)MoveKotlinNestedClassesDialog.this.myProject).findClass(MoveKotlinNestedClassesDialog.this.targetClassChooser.getText(), MoveKotlinNestedClassesDialog.this.searchScope)) instanceof KtLightClassForSourceDeclaration ? ((KtLightClassForSourceDeclaration)aClass).getKotlinOrigin() : aClass;
                MoveKotlinNestedClassesDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinNestedClassesDialog$2", "documentChanged"));
            }
        });
        this.targetClassChooserPanel.add((Component)((Object)this.targetClassChooser));
    }

    private boolean classMatchesFilter(PsiClass aClass) {
        PsiPackage targetPackage;
        if (!this.searchScope.accept(aClass.getContainingFile().getVirtualFile())) {
            return false;
        }
        if (this.targetDirectory != null && (targetPackage = JavaDirectoryService.getInstance().getPackage(this.targetDirectory)) != null) {
            PsiDirectory directory = aClass.getContainingFile().getContainingDirectory();
            PsiPackage classPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (classPackage != null && !targetPackage.getQualifiedName().equals(classPackage.getQualifiedName())) {
                return false;
            }
        }
        if (!(aClass instanceof KtLightClassForSourceDeclaration)) {
            return false;
        }
        KtClassOrObject classOrObject = ((KtLightClassForSourceDeclaration)aClass).getKotlinOrigin();
        if (classOrObject instanceof KtObjectDeclaration) {
            return !((KtObjectDeclaration)classOrObject).isObjectLiteral();
        }
        if (classOrObject instanceof KtClass) {
            KtClass ktClass = (KtClass)classOrObject;
            return !ktClass.isInner() && !ktClass.isAnnotation();
        }
        return false;
    }

    private void initMemberInfo(@NotNull List<KtClassOrObject> elementsToMove) {
        if (elementsToMove == null) {
            MoveKotlinNestedClassesDialog.$$$reportNull$$$0(5);
        }
        List memberInfos = CollectionsKt.mapNotNull((Iterable)this.originalClass.getDeclarations(), declaration -> {
            if (!(declaration instanceof KtClassOrObject)) {
                return null;
            }
            KtClassOrObject classOrObject = (KtClassOrObject)declaration;
            if (classOrObject instanceof KtClass && ((KtClass)classOrObject).isInner()) {
                return null;
            }
            if (classOrObject instanceof KtObjectDeclaration && ((KtObjectDeclaration)classOrObject).isCompanion()) {
                return null;
            }
            KotlinMemberInfo memberInfo = new KotlinMemberInfo((KtNamedDeclaration)classOrObject, false);
            memberInfo.setChecked(elementsToMove.contains(declaration));
            return memberInfo;
        });
        KotlinMemberSelectionPanel selectionPanel = new KotlinMemberSelectionPanel(this.getTitle(), memberInfos, null);
        this.memberTable = selectionPanel.getTable();
        MemberInfoModelImpl memberInfoModel = new MemberInfoModelImpl();
        memberInfoModel.memberInfoChanged(new MemberInfoChange((Collection)memberInfos));
        selectionPanel.getTable().setMemberInfoModel((MemberInfoModel)memberInfoModel);
        selectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        this.membersInfoPanel.add((Component)((Object)selectionPanel), "Center");
    }

    private List<KtClassOrObject> getSelectedElementsToMove() {
        return CollectionsKt.map((Iterable)this.memberTable.getSelectedMemberInfos(), info2 -> (KtClassOrObject)info2.getMember());
    }

    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    protected String getDimensionServiceKey() {
        return "#" + ((Object)((Object)this)).getClass().getName();
    }

    private Model getModel() {
        return new MoveKotlinNestedClassesModel(this.myProject, this.openInEditorCheckBox.isSelected(), this.getSelectedElementsToMove(), this.originalClass, this.targetClass, this.moveCallback);
    }

    protected void doAction() {
        ModelResultWithFUSData modelResult;
        try {
            modelResult = this.getModel().computeModelResult();
        }
        catch (ConfigurationException e) {
            this.setErrorHtml(e.getMessageHtml());
            return;
        }
        MoveUtilKt.logFusForMoveRefactoring(modelResult.getElementsCount(), modelResult.getEntityToMove(), modelResult.getDestination(), this.getCheckboxesState() == this.initializedCheckBoxesState, () -> this.invokeRefactoring(modelResult.getProcessor()));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.targetClassChooser.getChildComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JTextField jTextField;
        JPanel jPanel3;
        this.mainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinNestedClassesDialog.class).getString("move.members.from"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.originalClassField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel4.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinNestedClassesDialog.class).getString("to.fully.qualified.name"));
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.targetClassChooserPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.openInEditorCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinNestedClassesDialog.class).getString("open.moved.members.in.editor"));
        jPanel6.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.membersInfoPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialTargetClass";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinNestedClassesDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initClassChooser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "initMemberInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MemberInfoModelImpl
    extends AbstractMemberInfoModel<KtNamedDeclaration, KotlinMemberInfo> {
        private MemberInfoModelImpl() {
        }
    }
}

