/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.createFromUsage.createCallable;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.CallableInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.CallableInfoKt;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.FunctionInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.ParameterInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.TypeInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.createCallable.CreateCallableMemberFromUsageFactory;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/createCallable/CreateBinaryOperationActionFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/createCallable/CreateCallableMemberFromUsageFactory;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "<init>", "()V", "getElementOfInterest", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "createCallableInfo", "Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/callableBuilder/CallableInfo;", "element", "kotlin.idea"})
public final class CreateBinaryOperationActionFactory
extends CreateCallableMemberFromUsageFactory<KtBinaryExpression> {
    @NotNull
    public static final CreateBinaryOperationActionFactory INSTANCE = new CreateBinaryOperationActionFactory();

    private CreateBinaryOperationActionFactory() {
        super(false, 1, null);
    }

    @Override
    @Nullable
    public KtBinaryExpression getElementOfInterest(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement = diagnostic.getPsiElement().getParent();
        return psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
    }

    @Override
    @Nullable
    protected CallableInfo createCallableInfo(@NotNull KtBinaryExpression element, @NotNull Diagnostic diagnostic) {
        TypeInfo typeInfo;
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        IElementType iElementType = element.getOperationToken();
        Intrinsics.checkNotNull((Object)iElementType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtToken");
        KtToken token = (KtToken)iElementType;
        if (Intrinsics.areEqual((Object)token, (Object)KtTokens.IDENTIFIER)) {
            string = element.getOperationReference().getReferencedName();
        } else {
            Name name2 = OperatorConventions.getNameForOperationSymbol((KtToken)token, (boolean)false, (boolean)true);
            string = name2 != null ? name2.asString() : null;
        }
        if (string == null) {
            return null;
        }
        String operationName = string;
        ImmutableSet immutableSet = OperatorConventions.IN_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"IN_OPERATIONS");
        boolean inOperation = CollectionsKt.contains((Iterable)((Iterable)immutableSet), (Object)token);
        ImmutableSet immutableSet2 = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet2, (String)"COMPARISON_OPERATIONS");
        boolean comparisonOperation = CollectionsKt.contains((Iterable)((Iterable)immutableSet2), (Object)token);
        KtExpression ktExpression = element.getLeft();
        if (ktExpression == null) {
            return null;
        }
        KtExpression leftExpr = ktExpression;
        KtExpression ktExpression2 = element.getRight();
        if (ktExpression2 == null) {
            return null;
        }
        KtExpression rightExpr = ktExpression2;
        KtExpression receiverExpr = inOperation ? rightExpr : leftExpr;
        KtExpression argumentExpr = inOperation ? leftExpr : rightExpr;
        KotlinBuiltIns builtIns = PlatformKt.getBuiltIns((KtElement)element);
        TypeInfo receiverType = CallableInfoKt.TypeInfo(receiverExpr, Variance.IN_VARIANCE);
        if (inOperation) {
            SimpleType simpleType = builtIns.getBooleanType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getBooleanType(...)");
            typeInfo = CallableInfoKt.noSubstitutions(new TypeInfo.ByType((KotlinType)simpleType, Variance.INVARIANT));
        } else if (comparisonOperation) {
            SimpleType simpleType = builtIns.getIntType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getIntType(...)");
            typeInfo = CallableInfoKt.noSubstitutions(new TypeInfo.ByType((KotlinType)simpleType, Variance.INVARIANT));
        } else {
            typeInfo = CallableInfoKt.TypeInfo((KtExpression)element, Variance.OUT_VARIANCE);
        }
        TypeInfo returnType = typeInfo;
        List<ParameterInfo> parameters2 = Collections.singletonList(new ParameterInfo(CallableInfoKt.TypeInfo(argumentExpr, Variance.IN_VARIANCE), null, 2, null));
        boolean isOperator = !Intrinsics.areEqual((Object)token, (Object)KtTokens.IDENTIFIER);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        Intrinsics.checkNotNull(parameters2);
        KtModifierKeywordToken ktModifierKeywordToken = isOperator ? KtTokens.OPERATOR_KEYWORD : KtTokens.INFIX_KEYWORD;
        Intrinsics.checkNotNull((Object)ktModifierKeywordToken);
        return new FunctionInfo(operationName, receiverType, returnType, null, parameters2, null, false, psiFactory.createModifierList(ktModifierKeywordToken), false, null, null, 1896, null);
    }
}

