/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.MoveUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00102\u00020\u0001:\u0003\u000e\u000f\u0010J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH'R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0001\u0011\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor;", "", "baseDirectory", "Lcom/intellij/psi/PsiDirectory;", "getBaseDirectory", "()Lcom/intellij/psi/PsiDirectory;", "pkgName", "Lorg/jetbrains/kotlin/name/FqName;", "getPkgName", "()Lorg/jetbrains/kotlin/name/FqName;", "getOrCreateTarget", "Lcom/intellij/psi/PsiFileSystemItem;", "dirStructureMatchesPkg", "", "Directory", "File", "Companion", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Directory;", "kotlin.refactorings.move.k2"})
public interface K2MoveTargetDescriptor {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveTargetDescriptor$Companion.$$INSTANCE;

    @NotNull
    public PsiDirectory getBaseDirectory();

    @NotNull
    public FqName getPkgName();

    @RequiresWriteLock
    @NotNull
    public PsiFileSystemItem getOrCreateTarget(boolean var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Companion;", "", "<init>", "()V", "Directory", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Directory;", "directory", "Lcom/intellij/psi/PsiDirectory;", "File", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$File;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.refactorings.move.k2"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final Directory Directory(@NotNull PsiDirectory directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            return new Directory(PackageUtilsKt.getFqNameWithImplicitPrefixOrRoot(directory), directory);
        }

        @NotNull
        public final File File(@NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PsiDirectory psiDirectory = file.getContainingDirectory();
            if (psiDirectory == null) {
                throw new IllegalStateException("No containing directory was found".toString());
            }
            PsiDirectory directory = psiDirectory;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return new File(string, file.getPackageFqName(), directory);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Directory;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor;", "pkgName", "Lorg/jetbrains/kotlin/name/FqName;", "baseDirectory", "Lcom/intellij/psi/PsiDirectory;", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/PsiDirectory;)V", "getPkgName", "()Lorg/jetbrains/kotlin/name/FqName;", "getBaseDirectory", "()Lcom/intellij/psi/PsiDirectory;", "getOrCreateTarget", "Lcom/intellij/psi/PsiFileSystemItem;", "dirStructureMatchesPkg", "", "kotlin.refactorings.move.k2"})
    public static class Directory
    implements K2MoveTargetDescriptor {
        @NotNull
        private final FqName pkgName;
        @NotNull
        private final PsiDirectory baseDirectory;

        public Directory(@NotNull FqName pkgName, @NotNull PsiDirectory baseDirectory) {
            Intrinsics.checkNotNullParameter((Object)pkgName, (String)"pkgName");
            Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
            this.pkgName = pkgName;
            this.baseDirectory = baseDirectory;
        }

        @Override
        @NotNull
        public FqName getPkgName() {
            return this.pkgName;
        }

        @Override
        @NotNull
        public PsiDirectory getBaseDirectory() {
            return this.baseDirectory;
        }

        @Override
        @NotNull
        public PsiFileSystemItem getOrCreateTarget(boolean dirStructureMatchesPkg) {
            VirtualFile file;
            if (!dirStructureMatchesPkg) {
                return (PsiFileSystemItem)this.getBaseDirectory();
            }
            FqName implicitPkgPrefix = PackageUtilsKt.getFqNameWithImplicitPrefixOrRoot(this.getBaseDirectory());
            String pkgSuffix = StringsKt.removePrefix((String)StringsKt.removePrefix((String)this.getPkgName().asString(), (CharSequence)implicitPkgPrefix.asString()), (CharSequence)".");
            VirtualFile virtualFile = file = VfsUtilCore.findRelativeFile((String)StringsKt.replace$default((String)pkgSuffix, (char)'.', (char)java.io.File.separatorChar, (boolean)false, (int)4, null), (VirtualFile)this.getBaseDirectory().getVirtualFile());
            if (virtualFile != null) {
                Project project = this.getBaseDirectory().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                PsiDirectory psiDirectory = PhysicalFileSystemUtilsKt.toPsiDirectory(virtualFile, project);
                if (psiDirectory == null) {
                    throw new IllegalStateException(("Could not find directory " + this.getPkgName()).toString());
                }
                return (PsiFileSystemItem)psiDirectory;
            }
            PsiDirectory psiDirectory = DirectoryUtil.createSubdirectories((String)pkgSuffix, (PsiDirectory)this.getBaseDirectory(), (String)".");
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"createSubdirectories(...)");
            return (PsiFileSystemItem)psiDirectory;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$File;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Directory;", "fileName", "", "pkgName", "Lorg/jetbrains/kotlin/name/FqName;", "baseDirectory", "Lcom/intellij/psi/PsiDirectory;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/PsiDirectory;)V", "getFileName", "()Ljava/lang/String;", "getOrCreateTarget", "Lorg/jetbrains/kotlin/psi/KtFile;", "dirStructureMatchesPkg", "", "kotlin.refactorings.move.k2"})
    public static final class File
    extends Directory {
        @NotNull
        private final String fileName;

        public File(@NotNull String fileName, @NotNull FqName pkgName, @NotNull PsiDirectory baseDirectory) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)pkgName, (String)"pkgName");
            Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
            super(pkgName, baseDirectory);
            this.fileName = fileName;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public KtFile getOrCreateTarget(boolean dirStructureMatchesPkg) {
            PsiFileSystemItem psiFileSystemItem = super.getOrCreateTarget(dirStructureMatchesPkg);
            Intrinsics.checkNotNull((Object)psiFileSystemItem, (String)"null cannot be cast to non-null type com.intellij.psi.PsiDirectory");
            PsiDirectory directory = (PsiDirectory)psiFileSystemItem;
            return MoveUtilKt.getOrCreateKotlinFile(this.fileName, directory, this.getPkgName().asString());
        }
    }
}

