/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.introduce.introduceVariable;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.k2.refactoring.introduce.introduceVariable.IntroduceVariableUtilKt;
import org.jetbrains.kotlin.idea.k2.refactoring.introduce.introduceVariable.K2IntroduceVariableHandler;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceRefactoringException;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.introduce.KotlinIntroduceVariableHandler;
import org.jetbrains.kotlin.idea.refactoring.introduce.KotlinIntroduceVariableHelper;
import org.jetbrains.kotlin.idea.refactoring.introduce.KotlinIntroduceVariableService;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.ElementKind;
import org.jetbrains.kotlin.idea.util.FindElementUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTypeAlias;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J2\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J2\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00182\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0012H\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0015H\u0016J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/introduce/introduceVariable/KotlinIntroduceVariableServiceK2Impl;", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/KotlinIntroduceVariableService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "findElement", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startOffset", "", "endOffset", "failOnNoExpression", "", "elementKind", "Lorg/jetbrains/kotlin/idea/util/ElementKind;", "getContainersForExpression", "", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/KotlinIntroduceVariableHelper$Containers;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "findOccurrences", "occurrenceContainer", "Lorg/jetbrains/kotlin/psi/KtElement;", "doRefactoringWithContainer", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "expressionToExtract", "container", "occurrencesToReplace", "hasUnitType", "element", "isNonExtractableQualifier", "kotlin.refactorings.k2"})
@SourceDebugExtension(value={"SMAP\nKotlinIntroduceVariableServiceK2Impl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinIntroduceVariableServiceK2Impl.kt\norg/jetbrains/kotlin/idea/k2/refactoring/introduce/introduceVariable/KotlinIntroduceVariableServiceK2Impl\n+ 2 analyzeUtils.kt\norg/jetbrains/kotlin/idea/base/analysis/api/utils/AnalyzeUtilsKt\n*L\n1#1,99:1\n25#2,7:100\n*S KotlinDebug\n*F\n+ 1 KotlinIntroduceVariableServiceK2Impl.kt\norg/jetbrains/kotlin/idea/k2/refactoring/introduce/introduceVariable/KotlinIntroduceVariableServiceK2Impl\n*L\n78#1:100,7\n*E\n"})
public final class KotlinIntroduceVariableServiceK2Impl
implements KotlinIntroduceVariableService {
    @NotNull
    private final Project project;

    public KotlinIntroduceVariableServiceK2Impl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    @Nullable
    public PsiElement findElement(@NotNull KtFile file, int startOffset, int endOffset, boolean failOnNoExpression, @NotNull ElementKind elementKind) {
        PsiElement element;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)elementKind), (String)"elementKind");
        PsiElement psiElement = FindElementUtils.findElement((PsiFile)file, startOffset, endOffset, elementKind);
        if (psiElement == null) {
            KtExpression ktExpression = IntroduceUtilsKt.findStringTemplateOrStringTemplateEntryExpression(file, startOffset, endOffset, elementKind);
            psiElement = ktExpression != null ? (PsiElement)ktExpression : (PsiElement)IntroduceVariableUtilKt.findStringTemplateFragment(file, startOffset, endOffset, elementKind);
        }
        if ((element = psiElement) instanceof KtElement && this.isNonExtractableQualifier((KtElement)element)) {
            element = null;
        }
        if (element == null) {
            if (failOnNoExpression) {
                throw new IntroduceRefactoringException(KotlinBundle.message((String)"cannot.refactor.not.expression", (Object[])new Object[0]));
            }
            return null;
        }
        return element;
    }

    @Override
    @NotNull
    public List<KotlinIntroduceVariableHelper.Containers> getContainersForExpression(@NotNull KtExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return K2IntroduceVariableHandler.INSTANCE.getCandidateContainers(expression);
    }

    @Override
    @NotNull
    public List<KtExpression> findOccurrences(@NotNull KtExpression expression, @NotNull KtElement occurrenceContainer) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)occurrenceContainer, (String)"occurrenceContainer");
        K2IntroduceVariableHandler $this$findOccurrences_u24lambda_u240 = K2IntroduceVariableHandler.INSTANCE;
        boolean bl = false;
        return $this$findOccurrences_u24lambda_u240.findOccurrences(expression, occurrenceContainer);
    }

    @Override
    public void doRefactoringWithContainer(@Nullable Editor editor, @NotNull KtExpression expressionToExtract, @NotNull KtElement container, @Nullable List<? extends KtExpression> occurrencesToReplace) {
        Intrinsics.checkNotNullParameter((Object)expressionToExtract, (String)"expressionToExtract");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        KotlinIntroduceVariableHandler.doRefactoringWithSelectedTargetContainer$default(K2IntroduceVariableHandler.INSTANCE, this.project, editor, expressionToExtract, new KotlinIntroduceVariableHelper.Containers(container, container), KotlinCommonRefactoringSettings.Companion.getInstance().getINTRODUCE_DECLARE_WITH_VAR(), null, null, 96, null);
    }

    @Override
    public boolean hasUnitType(@NotNull KtExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String windowTitle$iv = KotlinBundle.message((String)"find.usages.prepare.dialog.progress", (Object[])new Object[0]);
        boolean $i$f$analyzeInModalWindow = false;
        ThreadingAssertions.assertEventDispatchThread();
        Project project = ((KtElement)element).getProject();
        Task.WithResult<Boolean, Exception> task$iv = new Task.WithResult<Boolean, Exception>(windowTitle$iv, (KtElement)element, project, element){
            final /* synthetic */ KtElement $contextElement;
            final /* synthetic */ KtExpression $element$inlined;
            {
                this.$contextElement = $contextElement;
                this.$element$inlined = ktExpression;
                super($super_call_param$1, $windowTitle, true);
            }

            protected Boolean compute(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                return ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(this.$contextElement, this.$element$inlined){
                    final /* synthetic */ KtElement $contextElement;
                    final /* synthetic */ KtExpression $element$inlined;
                    {
                        this.$contextElement = $contextElement;
                        this.$element$inlined = ktExpression;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final Boolean invoke() {
                        Boolean bl;
                        KtElement useSiteElement$iv = this.$contextElement;
                        boolean $i$f$analyze = false;
                        Project project = useSiteElement$iv.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
                        boolean $i$f$analyze2 = false;
                        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv);
                        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv);
                        try {
                            Boolean bl2;
                            Object lock$iv$iv;
                            Object object = lock$iv$iv = new Object();
                            synchronized (object) {
                                boolean bl3 = false;
                                KaSession $this$hasUnitType_u24lambda_u241 = analysisSession$iv$iv;
                                boolean bl4 = false;
                                KaType expressionType = $this$hasUnitType_u24lambda_u241.getExpressionType(this.$element$inlined);
                                bl2 = expressionType == null || $this$hasUnitType_u24lambda_u241.isUnitType(expressionType);
                            }
                            bl = bl2;
                        }
                        finally {
                            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv);
                        }
                        return bl;
                    }
                }));
            }
        };
        task$iv.queue();
        return (Boolean)task$iv.getResult() != false || this.isNonExtractableQualifier((KtElement)element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNonExtractableQualifier(KtElement element) {
        boolean bl;
        PsiElement parent = element.getParent();
        if (parent instanceof KtDotQualifiedExpression) {
            bl = Intrinsics.areEqual((Object)((KtDotQualifiedExpression)parent).getReceiverExpression(), (Object)element);
        } else {
            if (!(parent instanceof KtDoubleColonExpression)) return false;
            bl = Intrinsics.areEqual((Object)((KtDoubleColonExpression)parent).getReceiverExpression(), (Object)element);
        }
        boolean isQualifier = bl;
        if (!isQualifier) {
            return false;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression = element instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)element : null;
        KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)(ktDotQualifiedExpression != null && (ktDotQualifiedExpression = ktDotQualifiedExpression.getSelectorExpression()) != null ? (KtElement)ktDotQualifiedExpression : element));
        PsiElement resolved = ktReference != null ? ktReference.resolve() : null;
        if (resolved instanceof PsiPackage) return true;
        if (resolved instanceof PsiClass) return true;
        if (resolved instanceof KtTypeAlias) return true;
        if (!(resolved instanceof KtClassOrObject)) return false;
        PsiElement psiElement = ((KtClassOrObject)resolved).getDeclarationKeyword();
        if (Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)KtTokens.OBJECT_KEYWORD)) return false;
        return true;
    }
}

