/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.ReplaceReadLineWithReadlnInspectionKt;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceReadLineWithReadlnInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ReplaceFix", "kotlin.idea"})
public final class ReplaceReadLineWithReadlnInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.callExpressionVisitor(arg_0 -> ReplaceReadLineWithReadlnInspection.buildVisitor$lambda$0(holder, arg_0));
    }

    private static final Unit buildVisitor$lambda$0(ProblemsHolder $holder, KtCallExpression callExpression) {
        if (LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)callExpression).getApiVersion().compareTo(ApiVersion.KOTLIN_1_6) < 0) {
            return Unit.INSTANCE;
        }
        if (!FunctionUtilsKt.isCalling$default(callExpression, ReplaceReadLineWithReadlnInspectionKt.access$getReadLineFqName$p(), null, 2, null)) {
            return Unit.INSTANCE;
        }
        KtExpression qualifiedOrCall = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis((KtExpression)((KtExpression)callExpression));
        PsiElement parent = qualifiedOrCall.getParent();
        Pair pair = parent instanceof KtPostfixExpression && Intrinsics.areEqual((Object)((KtPostfixExpression)parent).getOperationToken(), (Object)KtTokens.EXCLEXCL) ? TuplesKt.to((Object)parent, (Object)"readln") : TuplesKt.to((Object)qualifiedOrCall, (Object)"readlnOrNull");
        KtExpression targetExpression = (KtExpression)pair.component1();
        String newFunctionName = (String)pair.component2();
        Object[] objectArray = new Object[]{ReplaceReadLineWithReadlnInspectionKt.access$getReadLineFqName$p().shortName().asString(), newFunctionName};
        String string = KotlinBundle.message((String)"replace.0.with.1", (Object[])objectArray);
        objectArray = new LocalQuickFix[]{new ReplaceFix(newFunctionName)};
        $holder.registerProblem((PsiElement)targetExpression, string, (LocalQuickFix[])objectArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceReadLineWithReadlnInspection$ReplaceFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "functionName", "", "<init>", "(Ljava/lang/String;)V", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    private static final class ReplaceFix
    implements LocalQuickFix {
        @NotNull
        private final String functionName;

        public ReplaceFix(@NotNull String functionName) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            this.functionName = functionName;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.functionName};
            return KotlinBundle.message((String)"replace.with.0", (Object[])objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement replaced = descriptor2.getPsiElement().replace((PsiElement)new KtPsiFactory(project, false, 2, null).createExpression("kotlin.io." + this.functionName + "()"));
            Intrinsics.checkNotNull((Object)replaced, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)replaced, null, 2, null);
        }
    }
}

