/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.EnvironmentUtil;
import java.io.Closeable;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionLoadingKt;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradleJava.ErrorGradleScriptDefinition;
import org.jetbrains.kotlin.idea.gradleJava.GradleKotlinScriptDefinitionWrapper;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptCompilationConfigurationFromDefinitionKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.KotlinScriptDefinitionFromAnnotatedTemplate;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0001H\u0002\u001aj\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00012\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001H\u0002\u001a,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u000e\u0010\u0016\u001a\u00020\u000b*\u0004\u0018\u00010\u0004H\u0002\u001a\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00012\u0006\u0010\u0018\u001a\u00020\u000b\u001a\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00012\u0006\u0010\u0018\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u000b*\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\"\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"loadGradleDefinitions", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "workingDir", "", "gradleHome", "javaHome", "project", "Lcom/intellij/openapi/project/Project;", "findStdLibLanguageVersion", "kotlinLibsClassPath", "Ljava/nio/file/Path;", "loadGradleTemplates", "projectPath", "templateClasses", "templateClasspath", "additionalClassPath", "defaultCompilerOptions", "createHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "gradleExeSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "toGradleHomePath", "getFullDefinitionsClasspath", "gradleLibDir", "kotlinStdlibAndCompiler", "findFirst", "pattern", "kotlinDslDependencySelector", "Lkotlin/text/Regex;", "getDefinitionsTemplateClasspath", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nscriptDefinitionsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 scriptDefinitionsUtils.kt\norg/jetbrains/kotlin/idea/gradleJava/ScriptDefinitionsUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ScriptDefinition.kt\norg/jetbrains/kotlin/scripting/definitions/ScriptDefinition\n*L\n1#1,233:1\n1#2:234\n1557#3:235\n1628#3,2:236\n1630#3:239\n1557#3:240\n1628#3,3:241\n56#4:238\n*S KotlinDebug\n*F\n+ 1 scriptDefinitionsUtils.kt\norg/jetbrains/kotlin/idea/gradleJava/ScriptDefinitionsUtilsKt\n*L\n137#1:235\n137#1:236,2\n137#1:239\n203#1:240\n203#1:241,3\n138#1:238\n*E\n"})
public final class ScriptDefinitionsUtilsKt {
    @NotNull
    private static final Regex kotlinDslDependencySelector = new Regex("^gradle-(?:kotlin-dsl|core).*\\.jar$");

    @NotNull
    public static final List<ScriptDefinition> loadGradleDefinitions(@NotNull String workingDir, @Nullable String gradleHome, @Nullable String javaHome, @NotNull Project project) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            Path gradleLibDir = ScriptDefinitionsUtilsKt.toGradleHomePath(gradleHome);
            List<Path> templateClasspath = ScriptDefinitionsUtilsKt.getFullDefinitionsClasspath(gradleLibDir);
            ScriptUtilsKt.scriptingDebugLog$default(null, () -> ScriptDefinitionsUtilsKt.loadGradleDefinitions$lambda$0(templateClasspath), 1, null);
            List<Path> kotlinLibsClassPath = ScriptDefinitionsUtilsKt.kotlinStdlibAndCompiler(gradleLibDir);
            List<String> languageVersionCompilerOptions = ScriptDefinitionsUtilsKt.findStdLibLanguageVersion(kotlinLibsClassPath);
            Object[] objectArray = new String[]{"org.gradle.kotlin.dsl.KotlinInitScript", "org.gradle.kotlin.dsl.KotlinSettingsScript", "org.gradle.kotlin.dsl.KotlinBuildScript"};
            List templateClasses = CollectionsKt.listOf((Object[])objectArray);
            list2 = CollectionsKt.distinct((Iterable)ScriptDefinitionsUtilsKt.loadGradleTemplates(workingDir, templateClasses, gradleHome, javaHome, templateClasspath, kotlinLibsClassPath, project, languageVersionCompilerOptions));
        }
        catch (Throwable t) {
            if (t instanceof IllegalStateException) {
                ScriptUtilsKt.scriptingInfoLog("IllegalStateException loading gradle script templates: " + t.getMessage());
            } else {
                ScriptUtilsKt.scriptingDebugLog$default(null, () -> ScriptDefinitionsUtilsKt.loadGradleDefinitions$lambda$1(t), 1, null);
            }
            list2 = CollectionsKt.listOf((Object)((Object)new ErrorGradleScriptDefinition(project)));
        }
        List loadedDefinitions = list2;
        if (loadedDefinitions.isEmpty()) {
            return CollectionsKt.listOf((Object)((Object)new ErrorGradleScriptDefinition(project)));
        }
        return loadedDefinitions;
    }

    private static final List<String> findStdLibLanguageVersion(List<? extends Path> kotlinLibsClassPath) {
        Object object;
        block7: {
            block6: {
                if (kotlinLibsClassPath.isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                Regex kotlinStdLibSelector = new Regex("^(kotlin-compiler-embeddable|kotlin-stdlib)-(\\d+\\.\\d+).*\\.jar$");
                MatchResult matchResult = Regex.find$default((Regex)kotlinStdLibSelector, (CharSequence)PathsKt.getName((Path)((Path)CollectionsKt.first(kotlinLibsClassPath))), (int)0, (int)2, null);
                if (matchResult == null) {
                    return CollectionsKt.emptyList();
                }
                MatchResult result2 = matchResult;
                if (result2.getGroupValues().size() < 3) {
                    return CollectionsKt.emptyList();
                }
                String version = (String)result2.getGroupValues().get(2);
                object = LanguageVersion.Companion.fromVersionString(version);
                if (object == null) break block6;
                LanguageVersion it = object;
                boolean bl = false;
                Object[] objectArray = new String[]{"-language-version", it.getVersionString()};
                List list2 = CollectionsKt.listOf((Object[])objectArray);
                object = list2;
                if (list2 != null) break block7;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ScriptDefinition> loadGradleTemplates(String projectPath, List<String> templateClasses, String gradleHome, String javaHome, List<? extends Path> templateClasspath, List<? extends Path> additionalClassPath, Project project, List<String> defaultCompilerOptions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        GradleExecutionSettings gradleExeSettings = (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectPath, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        Intrinsics.checkNotNull((Object)gradleExeSettings);
        ScriptingHostConfiguration hostConfiguration = ScriptDefinitionsUtilsKt.createHostConfiguration(projectPath, gradleHome, javaHome, gradleExeSettings);
        Iterable iterable = ScriptDefinitionLoadingKt.loadDefinitionsFromTemplatesByPaths(templateClasses, templateClasspath, hostConfiguration, additionalClassPath, (Iterable<String>)defaultCompilerOptions);
        boolean $i$f$map = false;
        void var12_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ScriptDefinition scriptDefinition;
            KotlinScriptDefinition kotlinScriptDefinition;
            void it;
            ScriptDefinition scriptDefinition2 = (ScriptDefinition)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void this_$iv = it;
            boolean $i$f$asLegacyOrNull = false;
            if (this_$iv instanceof ScriptDefinition.FromLegacy) {
                KotlinScriptDefinition kotlinScriptDefinition2 = ((ScriptDefinition.FromLegacy)this_$iv).getLegacyDefinition();
                if (!(kotlinScriptDefinition2 instanceof KotlinScriptDefinitionFromAnnotatedTemplate)) {
                    kotlinScriptDefinition2 = null;
                }
                kotlinScriptDefinition = (KotlinScriptDefinitionFromAnnotatedTemplate)kotlinScriptDefinition2;
            } else {
                kotlinScriptDefinition = null;
            }
            if ((KotlinScriptDefinitionFromAnnotatedTemplate)kotlinScriptDefinition != null) {
                KotlinScriptDefinitionFromAnnotatedTemplate legacyDefinition;
                boolean bl2 = false;
                scriptDefinition = new GradleKotlinScriptDefinitionWrapper(legacyDefinition, it.getHostConfiguration(), it.getEvaluationConfiguration(), it.getDefaultCompilerOptions());
            } else {
                scriptDefinition = it;
            }
            collection.add(scriptDefinition);
        }
        return (List)destination$iv$iv;
    }

    private static final ScriptingHostConfiguration createHostConfiguration(String projectPath, String gradleHome, String javaHome, GradleExecutionSettings gradleExeSettings) {
        Map map;
        File file;
        File file2;
        String p0;
        Pair[] pairArray;
        int n;
        String string;
        Object[] objectArray;
        List list2 = gradleExeSettings.getJvmArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getJvmArguments(...)");
        List gradleJvmOptions = list2;
        Pair[] pairArray2 = objectArray = new Pair[6];
        int n2 = 0;
        String string2 = "gradleHome";
        String string3 = gradleHome;
        if (string3 != null) {
            String string4 = string3;
            string = string2;
            n = n2;
            pairArray = pairArray2;
            boolean $i$f$createHostConfiguration$stub_for_inlining = false;
            boolean bl = false;
            file2 = new File(p0);
            pairArray2 = pairArray;
            n2 = n;
            string2 = string;
            file = file2;
        } else {
            file = null;
        }
        pairArray2[n2] = TuplesKt.to((Object)string2, file);
        objectArray[1] = TuplesKt.to((Object)"gradleJavaHome", (Object)javaHome);
        p0 = projectPath;
        string = "projectRoot";
        n = 2;
        pairArray = objectArray;
        boolean $i$f$createHostConfiguration$stub_for_inlining$5 = false;
        boolean bl = false;
        file2 = new File(p0);
        pairArray[n] = TuplesKt.to((Object)string, (Object)file2);
        objectArray[3] = TuplesKt.to((Object)"gradleOptions", (Object)CollectionsKt.emptyList());
        objectArray[4] = TuplesKt.to((Object)"gradleJvmOptions", (Object)gradleJvmOptions);
        if (gradleExeSettings.isPassParentEnvs()) {
            Map map2 = EnvironmentUtil.getEnvironmentMap();
            map = map2;
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getEnvironmentMap(...)");
        } else {
            map = MapsKt.emptyMap();
        }
        objectArray[5] = TuplesKt.to((Object)"gradleEnvironmentVariables", (Object)map);
        Map environment = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new ScriptingHostConfiguration[]{JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration()};
        return new ScriptingHostConfiguration((ScriptingHostConfiguration[])objectArray, (Function1<? super ScriptingHostConfiguration.Builder, Unit>)((Function1)arg_0 -> ScriptDefinitionsUtilsKt.createHostConfiguration$lambda$7(environment, arg_0)));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final Path toGradleHomePath(String $this$toGradleHomePath) {
        if ($this$toGradleHomePath == null) {
            throw new IllegalStateException(KotlinIdeaGradleBundle.message("error.text.unable.to.get.gradle.home.directory", new Object[0]).toString());
        }
        var1_1 = new String[]{"lib"};
        v0 = Paths.get($this$toGradleHomePath, Arrays.copyOf(var1_1, var1_1.length));
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"get(...)");
        it = v0;
        $i$a$-let-ScriptDefinitionsUtilsKt$toGradleHomePath$1 = false;
        var4_4 = it;
        it = var4_4;
        $i$a$-takeIf-ScriptDefinitionsUtilsKt$toGradleHomePath$1$1 = false;
        v1 = new LinkOption[]{};
        if (!Files.exists((Path)it, Arrays.copyOf(v1, v1.length))) ** GOTO lbl-1000
        v2 = new LinkOption[]{};
        if (Files.isDirectory((Path)it, Arrays.copyOf(v2, v2.length))) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        v4 /* !! */  = v3 != false ? var4_4 : null;
        if (v4 /* !! */  == null) {
            var4_4 = new Object[]{it};
            var4_4 = KotlinIdeaGradleBundle.message("error.text.invalid.gradle.libraries.directory", (Object[])var4_4);
            throw new IllegalStateException(var4_4.toString());
        }
        return v4 /* !! */ ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> getFullDefinitionsClasspath(@NotNull Path gradleLibDir) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)gradleLibDir, (String)"gradleLibDir");
        Object object = Files.newDirectoryStream(gradleLibDir, arg_0 -> ScriptDefinitionsUtilsKt.getFullDefinitionsClasspath$lambda$11(ScriptDefinitionsUtilsKt::getFullDefinitionsClasspath$lambda$10, arg_0));
        Throwable throwable = null;
        try {
            DirectoryStream p0 = (DirectoryStream)object;
            boolean $i$f$getFullDefinitionsClasspath$stub_for_inlining$12 = false;
            boolean bl = false;
            list2 = CollectionsKt.toList((Iterable)p0);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        object = list2;
        if (object.isEmpty()) {
            boolean bl = false;
            throw new IllegalStateException(KotlinIdeaGradleBundle.message("error.text.missing.jars.in.gradle.directory", new Object[0]).toString());
        }
        List templateClasspath = (List)object;
        ScriptUtilsKt.scriptingDebugLog$default(null, () -> ScriptDefinitionsUtilsKt.getFullDefinitionsClasspath$lambda$14(templateClasspath), 1, null);
        return templateClasspath;
    }

    private static final List<Path> kotlinStdlibAndCompiler(Path gradleLibDir) {
        Path stdlibPath = ScriptDefinitionsUtilsKt.findFirst(gradleLibDir, "kotlin-stdlib-[1-9]*");
        Path compilerPath = ScriptDefinitionsUtilsKt.findFirst(gradleLibDir, "kotlin-compiler-embeddable*");
        Object[] objectArray = new Path[]{stdlibPath, compilerPath};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private static final Path findFirst(Path $this$findFirst, String pattern2) {
        DirectoryStream<Path> directoryStream = Files.newDirectoryStream($this$findFirst, pattern2);
        Intrinsics.checkNotNullExpressionValue(directoryStream, (String)"newDirectoryStream(...)");
        return (Path)CollectionsKt.firstOrNull((Iterable)directoryStream);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getDefinitionsTemplateClasspath(@Nullable String gradleHome) {
        List list2;
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ScriptDefinitionsUtilsKt.getFullDefinitionsClasspath(ScriptDefinitionsUtilsKt.toGradleHomePath(gradleHome));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path2 = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(PathsKt.getInvariantSeparatorsPathString((Path)it));
            }
            list2 = (List)destination$iv$iv;
        }
        catch (Throwable e) {
            ScriptUtilsKt.scriptingInfoLog("cannot get gradle classpath for Gradle Kotlin DSL scripts: " + e.getMessage());
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final String loadGradleDefinitions$lambda$0(List $templateClasspath) {
        return "Gradle definitions additional classpath: " + $templateClasspath;
    }

    private static final String loadGradleDefinitions$lambda$1(Throwable $t) {
        return "error loading gradle script templates " + $t.getMessage();
    }

    private static final Map createHostConfiguration$lambda$7$lambda$6(Map $environment) {
        return $environment;
    }

    private static final Unit createHostConfiguration$lambda$7(Map $environment, ScriptingHostConfiguration.Builder $this$ScriptingHostConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$ScriptingHostConfiguration, (String)"$this$ScriptingHostConfiguration");
        $this$ScriptingHostConfiguration.invoke(ScriptCompilationConfigurationFromDefinitionKt.getGetEnvironment($this$ScriptingHostConfiguration), () -> ScriptDefinitionsUtilsKt.createHostConfiguration$lambda$7$lambda$6($environment));
        return Unit.INSTANCE;
    }

    private static final boolean getFullDefinitionsClasspath$lambda$10(Path it) {
        Intrinsics.checkNotNull((Object)it);
        return kotlinDslDependencySelector.matches((CharSequence)PathsKt.getName((Path)it));
    }

    private static final boolean getFullDefinitionsClasspath$lambda$11(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String getFullDefinitionsClasspath$lambda$14(List $templateClasspath) {
        return "Gradle definitions classpath: " + $templateClasspath;
    }
}

