/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.base.KaContextReceiver;
import org.jetbrains.kotlin.analysis.api.components.KaJavaInteroperabilityComponent;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaClassType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeParameterType;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.JvmNameUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.BytecodeSignature;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.CallableMemberInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.CallableMemberInfoKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0014H\u0002\u001a$\u0010\u0015\u001a\u00020\u0011*\u00020\u00132\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a \u0010\u001a\u001a\u00020\u0006*\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u0002\u001a\u0016\u0010\u001d\u001a\u00020\u0011*\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0002\u001a\u0017\u0010\u001f\u001a\u0004\u0018\u00010\r*\u00020!H\u0002R\u00020 \u00a2\u0006\u0002\u0010\"\u001a\u001f\u0010#\u001a\u0004\u0018\u00010\r*\u00020$2\u0006\u0010%\u001a\u00020&H\u0002R\u00020 \u00a2\u0006\u0002\u0010'\u001a\f\u0010(\u001a\u00020\r*\u00020\rH\u0002\u00a8\u0006)"}, d2={"handleMangling", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/BytecodeSignature;", "methodInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;", "handleValueClassMethods", "sourceParametersCount", "", "z", "handleDefaultArgs", "handleDefaultInterfaces", "handleAccessMethods", "handleInvokeSuspend", "buildSignature", "", "originalSignature", "dropCount", "fromStart", "", "getLightClassMethod", "Lcom/intellij/psi/PsiMethod;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "matches", "className", "signature", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "increment", "", "key", "isSubClassOf", "baseInternalName", "getJvmSignature", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;)Ljava/lang/String;", "jvmName", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "element", "Lcom/intellij/psi/PsiElement;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/types/KaType;Lcom/intellij/psi/PsiElement;)Ljava/lang/String;", "internalNameToReferenceTypeName", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinSmartStepTargetFilterer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSmartStepTargetFilterer.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTargetFiltererKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,289:1\n1611#2,9:290\n1863#2:299\n1864#2:301\n1620#2:302\n1557#2:303\n1628#2,3:304\n1#3:300\n*S KotlinDebug\n*F\n+ 1 KotlinSmartStepTargetFilterer.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTargetFiltererKt\n*L\n244#1:290,9\n244#1:299\n244#1:301\n244#1:302\n248#1:303\n248#1:304,3\n244#1:300\n*E\n"})
public final class KotlinSmartStepTargetFiltererKt {
    private static final BytecodeSignature handleMangling(BytecodeSignature $this$handleMangling, CallableMemberInfo methodInfo) {
        if (!methodInfo.isNameMangledInBytecode()) {
            return $this$handleMangling;
        }
        return BytecodeSignature.copy$default($this$handleMangling, null, DebuggerUtils.INSTANCE.trimIfMangledInBytecode($this$handleMangling.getName(), true), null, 5, null);
    }

    private static final BytecodeSignature handleValueClassMethods(BytecodeSignature $this$handleValueClassMethods, CallableMemberInfo methodInfo) {
        if (!methodInfo.isInlineClassMember()) {
            return $this$handleValueClassMethods;
        }
        return BytecodeSignature.copy$default($this$handleValueClassMethods, null, null, KotlinSmartStepTargetFiltererKt.buildSignature($this$handleValueClassMethods.getSignature(), 1, true), 3, null);
    }

    private static final int sourceParametersCount(int z) {
        return z - 1 - (z - 1 + 32) / 33;
    }

    private static final BytecodeSignature handleDefaultArgs(BytecodeSignature $this$handleDefaultArgs) {
        if (!StringsKt.endsWith$default((String)$this$handleDefaultArgs.getName(), (String)"$default", (boolean)false, (int)2, null)) {
            return $this$handleDefaultArgs;
        }
        Type type2 = Type.getType((String)$this$handleDefaultArgs.getSignature());
        int parametersCount = type2.getArgumentCount();
        int sourceParametersCount = KotlinSmartStepTargetFiltererKt.sourceParametersCount(parametersCount);
        return BytecodeSignature.copy$default($this$handleDefaultArgs, null, StringsKt.substringBefore$default((String)$this$handleDefaultArgs.getName(), (String)"$default", null, (int)2, null), KotlinSmartStepTargetFiltererKt.buildSignature($this$handleDefaultArgs.getSignature(), parametersCount - sourceParametersCount, false), 1, null);
    }

    private static final BytecodeSignature handleDefaultInterfaces(BytecodeSignature $this$handleDefaultInterfaces) {
        if (!StringsKt.endsWith$default((String)$this$handleDefaultInterfaces.getOwner(), (String)"$DefaultImpls", (boolean)false, (int)2, null)) {
            return $this$handleDefaultInterfaces;
        }
        return BytecodeSignature.copy$default($this$handleDefaultInterfaces, StringsKt.removeSuffix((String)$this$handleDefaultInterfaces.getOwner(), (CharSequence)"$DefaultImpls"), null, KotlinSmartStepTargetFiltererKt.buildSignature($this$handleDefaultInterfaces.getSignature(), 1, true), 2, null);
    }

    private static final BytecodeSignature handleAccessMethods(BytecodeSignature $this$handleAccessMethods) {
        if (!StringsKt.startsWith$default((String)$this$handleAccessMethods.getName(), (String)"access$", (boolean)false, (int)2, null)) {
            return $this$handleAccessMethods;
        }
        return BytecodeSignature.copy$default($this$handleAccessMethods, null, StringsKt.removePrefix((String)$this$handleAccessMethods.getName(), (CharSequence)"access$"), null, 5, null);
    }

    private static final BytecodeSignature handleInvokeSuspend(BytecodeSignature $this$handleInvokeSuspend, CallableMemberInfo methodInfo) {
        if (!methodInfo.isSuspend() || !methodInfo.isInvoke()) {
            return $this$handleInvokeSuspend;
        }
        if (!Intrinsics.areEqual((Object)methodInfo.getName(), (Object)"invokeSuspend") || !Intrinsics.areEqual((Object)$this$handleInvokeSuspend.getName(), (Object)"invoke")) {
            return $this$handleInvokeSuspend;
        }
        return BytecodeSignature.copy$default($this$handleInvokeSuspend, null, "invokeSuspend", null, 5, null);
    }

    private static final String buildSignature(String originalSignature, int dropCount, boolean fromStart) {
        List list2;
        Type type2 = Type.getType((String)originalSignature);
        Object[] argumentTypes = type2.getArgumentTypes();
        if (fromStart) {
            Intrinsics.checkNotNull((Object)argumentTypes);
            list2 = ArraysKt.drop((Object[])argumentTypes, (int)dropCount);
        } else {
            Intrinsics.checkNotNull((Object)argumentTypes);
            list2 = ArraysKt.dropLast((Object[])argumentTypes, (int)dropCount);
        }
        List remainingArgumentTypes = list2;
        String arguments2 = CollectionsKt.joinToString$default((Iterable)remainingArgumentTypes, (CharSequence)"", null, null, (int)0, null, KotlinSmartStepTargetFiltererKt::buildSignature$lambda$0, (int)30, null);
        return "(" + arguments2 + ")" + type2.getReturnType().getDescriptor();
    }

    private static final PsiMethod getLightClassMethod(KtDeclaration $this$getLightClassMethod) {
        PsiMethod psiMethod;
        KtDeclaration ktDeclaration = $this$getLightClassMethod;
        if (ktDeclaration instanceof KtFunction) {
            psiMethod = LightClassUtil.INSTANCE.getLightClassMethod((KtFunction)$this$getLightClassMethod);
        } else if (ktDeclaration instanceof KtPropertyAccessor) {
            KtProperty ktProperty = ((KtPropertyAccessor)$this$getLightClassMethod).getProperty();
            Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"getProperty(...)");
            psiMethod = LightClassUtil.INSTANCE.getLightClassPropertyMethods(ktProperty).getGetter();
        } else {
            psiMethod = null;
        }
        return psiMethod;
    }

    private static final boolean matches(PsiMethod $this$matches, String className, String signature, DebugProcessImpl debugProcess) {
        return DebuggerUtilsEx.methodMatches((PsiMethod)$this$matches, (String)JvmNameUtilsKt.internalNameToFqn(className), null, (String)signature, (DebugProcessImpl)debugProcess);
    }

    private static final int increment(Map<String, Integer> $this$increment, String key) {
        Integer n = $this$increment.get(key);
        int newValue = (n != null ? n : 0) + 1;
        $this$increment.put(key, newValue);
        return newValue;
    }

    private static final boolean isSubClassOf(String $this$isSubClassOf, String baseInternalName) {
        if (baseInternalName == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)$this$isSubClassOf, (Object)baseInternalName)) {
            return true;
        }
        return Intrinsics.areEqual((Object)baseInternalName, (Object)"java/lang/Object") || Intrinsics.areEqual((Object)baseInternalName, (Object)"kotlin/Any");
    }

    /*
     * WARNING - void declaration
     */
    private static final String getJvmSignature(KaSession $context_receiver_0, KaCallableSymbol $this$getJvmSignature) {
        String string;
        String string2;
        boolean isSuspend;
        void $this$mapNotNullTo$iv$iv;
        PsiElement psiElement = $this$getJvmSignature.getPsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        Iterable $this$mapNotNull$iv = $this$getJvmSignature.getContextReceivers();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl4 = false;
            KaContextReceiver it = (KaContextReceiver)element$iv$iv;
            boolean bl2 = false;
            if (KotlinSmartStepTargetFiltererKt.jvmName($context_receiver_0, it.getType(), element) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        String contextReceivers = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        Object object = KaCallableSymbolKt.getReceiverType($this$getJvmSignature);
        if (object == null || (object = KotlinSmartStepTargetFiltererKt.jvmName($context_receiver_0, (KaType)object, element)) == null) {
            object = "";
        }
        Object receiver2 = object;
        boolean bl = isSuspend = $this$getJvmSignature instanceof KaFunctionSymbol && CallableMemberInfoKt.isSuspend((KaFunctionSymbol)$this$getJvmSignature);
        if ($this$getJvmSignature instanceof KaFunctionSymbol) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((KaFunctionSymbol)$this$getJvmSignature).getValueParameters();
            boolean $i$f$map = false;
            $this$forEach$iv$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String typeName;
                void it;
                KaValueParameterSymbol bl4 = (KaValueParameterSymbol)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl5 = false;
                if (KotlinSmartStepTargetFiltererKt.jvmName($context_receiver_0, it.getReturnType(), element) == null) {
                    return null;
                }
                collection.add(it.isVararg() ? "[" + typeName : typeName);
            }
            string2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        } else {
            string2 = "";
        }
        String parameterTypes = string2;
        if (isSuspend) {
            string = "Ljava/lang/Object;";
        } else {
            string = KotlinSmartStepTargetFiltererKt.jvmName($context_receiver_0, $this$getJvmSignature.getReturnType(), element);
            if (string == null) {
                return null;
            }
        }
        String returnType = string;
        String continuationParameter = isSuspend ? "Lkotlin/coroutines/Continuation;" : "";
        return "(" + contextReceivers + (String)receiver2 + parameterTypes + continuationParameter + ")" + returnType;
    }

    private static final String jvmName(KaSession $context_receiver_0, KaType $this$jvmName, PsiElement element) {
        if ($this$jvmName instanceof KaTypeParameterType) {
            return "Ljava/lang/Object;";
        }
        if (!($this$jvmName instanceof KaClassType)) {
            return null;
        }
        PsiType psiType = KaJavaInteroperabilityComponent.asPsiType$default($context_receiver_0, $this$jvmName, element, false, null, false, null, false, false, false, 252, null);
        if (psiType == null) {
            return null;
        }
        PsiType psiType2 = psiType;
        if (JvmNameUtilKt.isInlineClass($context_receiver_0, ((KaClassType)$this$jvmName).getSymbol())) {
            if (Intrinsics.areEqual((Object)psiType2.getCanonicalText(), (Object)"java.lang.Object")) {
                return "Ljava/lang/Object;";
            }
            if (psiType2 instanceof PsiPrimitiveType) {
                return ((PsiPrimitiveType)psiType2).getKind().getBinaryName();
            }
        }
        if ($context_receiver_0.isPrimitive($this$jvmName)) {
            String string;
            if (psiType2 instanceof PsiPrimitiveType) {
                string = ((PsiPrimitiveType)psiType2).getKind().getBinaryName();
            } else {
                String string2 = psiType2.getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalText(...)");
                string = KotlinSmartStepTargetFiltererKt.internalNameToReferenceTypeName(JvmNameUtilsKt.fqnToInternalName(string2));
            }
            return string;
        }
        if (Intrinsics.areEqual((Object)psiType2.getCanonicalText(), (Object)"kotlin.Unit")) {
            return "V";
        }
        String string = psiType2.getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        String psiTypeInternalName = JvmNameUtilsKt.fqnToInternalName(StringsKt.substringBefore$default((String)string, (String)"<", null, (int)2, null));
        if (StringsKt.startsWith$default((String)psiTypeInternalName, (String)"kotlin/jvm/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)psiTypeInternalName, (String)"java/", (boolean)false, (int)2, null)) {
            return KotlinSmartStepTargetFiltererKt.internalNameToReferenceTypeName(psiTypeInternalName);
        }
        String string3 = JvmClassName.internalNameByClassId((ClassId)((KaClassType)$this$jvmName).getClassId());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"internalNameByClassId(...)");
        String ktTypeInternalName = string3;
        return KotlinSmartStepTargetFiltererKt.internalNameToReferenceTypeName(ktTypeInternalName);
    }

    private static final String internalNameToReferenceTypeName(String $this$internalNameToReferenceTypeName) {
        return "L" + $this$internalNameToReferenceTypeName + ";";
    }

    private static final CharSequence buildSignature$lambda$0(Type it) {
        String string = it.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescriptor(...)");
        return string;
    }

    public static final /* synthetic */ int access$increment(Map $receiver, String key) {
        return KotlinSmartStepTargetFiltererKt.increment($receiver, key);
    }

    public static final /* synthetic */ BytecodeSignature access$handleInvokeSuspend(BytecodeSignature $receiver, CallableMemberInfo methodInfo) {
        return KotlinSmartStepTargetFiltererKt.handleInvokeSuspend($receiver, methodInfo);
    }

    public static final /* synthetic */ BytecodeSignature access$handleAccessMethods(BytecodeSignature $receiver) {
        return KotlinSmartStepTargetFiltererKt.handleAccessMethods($receiver);
    }

    public static final /* synthetic */ BytecodeSignature access$handleDefaultInterfaces(BytecodeSignature $receiver) {
        return KotlinSmartStepTargetFiltererKt.handleDefaultInterfaces($receiver);
    }

    public static final /* synthetic */ BytecodeSignature access$handleDefaultArgs(BytecodeSignature $receiver) {
        return KotlinSmartStepTargetFiltererKt.handleDefaultArgs($receiver);
    }

    public static final /* synthetic */ BytecodeSignature access$handleValueClassMethods(BytecodeSignature $receiver, CallableMemberInfo methodInfo) {
        return KotlinSmartStepTargetFiltererKt.handleValueClassMethods($receiver, methodInfo);
    }

    public static final /* synthetic */ BytecodeSignature access$handleMangling(BytecodeSignature $receiver, CallableMemberInfo methodInfo) {
        return KotlinSmartStepTargetFiltererKt.handleMangling($receiver, methodInfo);
    }

    public static final /* synthetic */ PsiMethod access$getLightClassMethod(KtDeclaration $receiver) {
        return KotlinSmartStepTargetFiltererKt.getLightClassMethod($receiver);
    }

    public static final /* synthetic */ boolean access$matches(PsiMethod $receiver, String className, String signature, DebugProcessImpl debugProcess) {
        return KotlinSmartStepTargetFiltererKt.matches($receiver, className, signature, debugProcess);
    }

    public static final /* synthetic */ String access$getJvmSignature(KaCallableSymbol $receiver, KaSession $context_receiver_0) {
        return KotlinSmartStepTargetFiltererKt.getJvmSignature($context_receiver_0, $receiver);
    }

    public static final /* synthetic */ boolean access$isSubClassOf(String $receiver, String baseInternalName) {
        return KotlinSmartStepTargetFiltererKt.isSubClassOf($receiver, baseInternalName);
    }
}

