/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.ThreadReference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineFilter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0011H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineJobInfo;", "Lcom/intellij/debugger/engine/LightOrRealThreadInfo;", "coroutineFilter", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineFilter;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineFilter;)V", "realThread", "", "getRealThread", "()Ljava/lang/Void;", "checkSameThread", "", "thread", "Lcom/sun/jdi/ThreadReference;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "filterName", "", "getFilterName", "()Ljava/lang/String;", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nCoroutineJobInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineJobInfo.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineJobInfo\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,46:1\n24#2:47\n*S KotlinDebug\n*F\n+ 1 CoroutineJobInfo.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineJobInfo\n*L\n22#1:47\n*E\n"})
public final class CoroutineJobInfo
implements LightOrRealThreadInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineFilter coroutineFilter;
    @Nullable
    private final Void realThread;

    public CoroutineJobInfo(@NotNull CoroutineFilter coroutineFilter) {
        Intrinsics.checkNotNullParameter((Object)coroutineFilter, (String)"coroutineFilter");
        this.coroutineFilter = coroutineFilter;
    }

    @Nullable
    public Void getRealThread() {
        return this.realThread;
    }

    public boolean checkSameThread(@NotNull ThreadReference thread, @NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        CoroutineFilter nextCoroutineFilter = CoroutineJobInfo.Companion.getCoroutineFilter(suspendContext);
        CoroutineJobInfo $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CoroutineJobInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Check thread filter: need " + this.coroutineFilter + ", current is " + nextCoroutineFilter);
        return nextCoroutineFilter != null && this.coroutineFilter.canRunTo(nextCoroutineFilter);
    }

    @NotNull
    public String getFilterName() {
        return this.coroutineFilter.getCoroutineFilterName();
    }

    private final CoroutineFilter component1() {
        return this.coroutineFilter;
    }

    @NotNull
    public final CoroutineJobInfo copy(@NotNull CoroutineFilter coroutineFilter) {
        Intrinsics.checkNotNullParameter((Object)coroutineFilter, (String)"coroutineFilter");
        return new CoroutineJobInfo(coroutineFilter);
    }

    public static /* synthetic */ CoroutineJobInfo copy$default(CoroutineJobInfo coroutineJobInfo, CoroutineFilter coroutineFilter, int n, Object object) {
        if ((n & 1) != 0) {
            coroutineFilter = coroutineJobInfo.coroutineFilter;
        }
        return coroutineJobInfo.copy(coroutineFilter);
    }

    @NotNull
    public String toString() {
        return "CoroutineJobInfo(coroutineFilter=" + this.coroutineFilter + ")";
    }

    public int hashCode() {
        return this.coroutineFilter.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CoroutineJobInfo)) {
            return false;
        }
        CoroutineJobInfo coroutineJobInfo = (CoroutineJobInfo)other;
        return Intrinsics.areEqual((Object)this.coroutineFilter, (Object)coroutineJobInfo.coroutineFilter);
    }

    @JvmStatic
    private static final CoroutineFilter getCoroutineFilter(SuspendContextImpl suspendContext) {
        return CoroutineJobInfo.Companion.getCoroutineFilter(suspendContext);
    }

    @JvmStatic
    @Nullable
    public static final LightOrRealThreadInfo extractJobInfo(@NotNull SuspendContextImpl suspendContext) {
        return Companion.extractJobInfo(suspendContext);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineJobInfo$Companion;", "", "<init>", "()V", "getCoroutineFilter", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineFilter;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "extractJobInfo", "Lcom/intellij/debugger/engine/LightOrRealThreadInfo;", "kotlin.jvm-debugger.core"})
    @SourceDebugExtension(value={"SMAP\nCoroutineJobInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineJobInfo.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineJobInfo$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final CoroutineFilter getCoroutineFilter(SuspendContextImpl suspendContext) {
            StackFrameInterceptor stackFrameInterceptor = StackFrameInterceptor.Companion.getInstance();
            return stackFrameInterceptor != null ? stackFrameInterceptor.extractCoroutineFilter(suspendContext) : null;
        }

        @JvmStatic
        @Nullable
        public final LightOrRealThreadInfo extractJobInfo(@NotNull SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            if (!Registry.Companion.is("debugger.filter.breakpoints.by.coroutine.id")) {
                return null;
            }
            try {
                CoroutineJobInfo coroutineJobInfo;
                CoroutineFilter coroutineFilter = this.getCoroutineFilter(suspendContext);
                if (coroutineFilter != null) {
                    CoroutineFilter it = coroutineFilter;
                    boolean bl = false;
                    coroutineJobInfo = new CoroutineJobInfo(it);
                } else {
                    coroutineJobInfo = null;
                }
                return coroutineJobInfo;
            }
            catch (Throwable e) {
                DebuggerUtilsImpl.logError((Throwable)e);
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

