/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinBreakpointFiltersPanel;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFieldBreakpoint;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFieldBreakpointPropertiesPanel;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinPropertyBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.dialog.AddFieldBreakpointDialog;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f0\nR\b\u0012\u0004\u0012\u00020\u00020\u0003H\u0014J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J0\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\"2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bH\u0002J\u001a\u0010%\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010'\u001a\u00020\bH\u0002J\b\u0010(\u001a\u00020\u0015H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020*H\u0016J\b\u0010,\u001a\u00020*H\u0016J\b\u0010-\u001a\u00020*H\u0016J\b\u0010.\u001a\u00020\u0015H\u0016J\u0016\u0010/\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\b\u00100\u001a\u00020\u0002H\u0016J\u001c\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u00103\u001a\u0004\u0018\u00010\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J \u00104\u001a\u0004\u0018\u0001052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u00107\u001a\u00020\u0015H\u0016\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpointType;", "Lcom/intellij/debugger/ui/breakpoints/JavaBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinPropertyBreakpointProperties;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointType;", "<init>", "()V", "getGeneralDescription", "", "variant", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "getPropertyXMLDescriptions", "", "createJavaBreakpoint", "Lcom/intellij/debugger/ui/breakpoints/Breakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "canPutAt", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "getPriority", "createBreakpointProperties", "addBreakpoint", "parentComponent", "Ljavax/swing/JComponent;", "createBreakpointIfPropertyExists", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "Lorg/jetbrains/kotlin/psi/KtFile;", "className", "fieldName", "reportError", "", "message", "isAddBreakpointButtonVisible", "getMutedEnabledIcon", "Ljavax/swing/Icon;", "getDisabledIcon", "getEnabledIcon", "getMutedDisabledIcon", "canBeHitInOtherPlaces", "getShortText", "createProperties", "createCustomPropertiesPanel", "Lcom/intellij/xdebugger/breakpoints/ui/XBreakpointCustomPropertiesPanel;", "getDisplayText", "getEditorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "createCustomRightPropertiesPanel", "isSuspendThreadSupported", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinFieldBreakpointType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFieldBreakpointType.kt\norg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpointType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n295#2,2:208\n*S KotlinDebug\n*F\n+ 1 KotlinFieldBreakpointType.kt\norg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpointType\n*L\n148#1:208,2\n*E\n"})
public final class KotlinFieldBreakpointType
extends XLineBreakpointType<KotlinPropertyBreakpointProperties>
implements JavaBreakpointType<KotlinPropertyBreakpointProperties>,
KotlinBreakpointType {
    public KotlinFieldBreakpointType() {
        super("kotlin-field", KotlinDebuggerCoreBundle.message("property.watchpoint.tab.title", new Object[0]));
    }

    @NotNull
    protected String getGeneralDescription(@NotNull XLineBreakpointType.XLineBreakpointVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return KotlinDebuggerCoreBundle.message("property.watchpoint.description", new Object[0]);
    }

    @NotNull
    public String getGeneralDescription(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        return KotlinDebuggerCoreBundle.message("property.watchpoint.description", new Object[0]);
    }

    @NotNull
    public List<String> getPropertyXMLDescriptions(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        SmartList res = new SmartList((Collection)super.getPropertyXMLDescriptions((XBreakpoint)breakpoint2));
        KotlinPropertyBreakpointProperties kotlinPropertyBreakpointProperties = (KotlinPropertyBreakpointProperties)breakpoint2.getProperties();
        if (kotlinPropertyBreakpointProperties == null) {
            return (List)res;
        }
        KotlinPropertyBreakpointProperties props = kotlinPropertyBreakpointProperties;
        KotlinPropertyBreakpointProperties defaults = this.createProperties();
        if (props.getWatchInitialization() != defaults.getWatchInitialization() || props.getWatchAccess() != defaults.getWatchAccess() || props.getWatchModification() != defaults.getWatchModification()) {
            res.add((Object)(KotlinDebuggerCoreBundle.message("property.watchpoint.property.name.initialization", new Object[0]) + "&nbsp;" + props.getWatchInitialization()));
            res.add((Object)(KotlinDebuggerCoreBundle.message("property.watchpoint.property.name.access", new Object[0]) + "&nbsp;" + props.getWatchAccess()));
            res.add((Object)(KotlinDebuggerCoreBundle.message("property.watchpoint.property.name.modification", new Object[0]) + "&nbsp;" + props.getWatchModification()));
        }
        return (List)res;
    }

    @NotNull
    public Breakpoint<KotlinPropertyBreakpointProperties> createJavaBreakpoint(@NotNull Project project, @NotNull XBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        return (Breakpoint)new KotlinFieldBreakpoint(project, breakpoint2);
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BreakpointTypeUtilsKt.isBreakpointApplicable(file, line, project, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)KotlinFieldBreakpointType::canPutAt$lambda$0));
    }

    public int getPriority() {
        return 120;
    }

    @NotNull
    public KotlinPropertyBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.createProperties();
    }

    @Nullable
    public XLineBreakpoint<KotlinPropertyBreakpointProperties> addBreakpoint(@NotNull Project project, @Nullable JComponent parentComponent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        AddFieldBreakpointDialog dialog2 = new AddFieldBreakpointDialog(project, this, (Ref.ObjectRef<XLineBreakpoint<KotlinPropertyBreakpointProperties>>)result2){
            final /* synthetic */ Project $project;
            final /* synthetic */ KotlinFieldBreakpointType this$0;
            final /* synthetic */ Ref.ObjectRef<XLineBreakpoint<KotlinPropertyBreakpointProperties>> $result;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$result = $result;
                super($project);
            }

            protected boolean validateData() {
                Object[] objectArray;
                String fieldName;
                String className;
                block5: {
                    Object object;
                    className = this.getClassName();
                    Intrinsics.checkNotNull((Object)className);
                    if (((CharSequence)className).length() == 0) {
                        String string = JavaDebuggerBundle.message((String)"error.field.breakpoint.class.name.not.specified", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, string);
                        return false;
                    }
                    GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.$project);
                    Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
                    Collection<Key> candidates2 = KotlinFullClassNameIndex.Helper.get(className, this.$project, globalSearchScope);
                    if (candidates2.isEmpty()) {
                        Object[] objectArray2 = new Object[]{className};
                        KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, KotlinDebuggerCoreBundle.message("property.watchpoint.error.couldnt.find.0.class", objectArray2));
                        return false;
                    }
                    fieldName = this.getFieldName();
                    Intrinsics.checkNotNull((Object)fieldName);
                    if (((CharSequence)fieldName).length() == 0) {
                        String string = JavaDebuggerBundle.message((String)"error.field.breakpoint.field.name.not.specified", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, string);
                        return false;
                    }
                    Iterable iterable = candidates2;
                    objectArray = this.this$0;
                    Ref.ObjectRef<XLineBreakpoint<KotlinPropertyBreakpointProperties>> objectRef = this.$result;
                    for (KtClassOrObject ktClassOrObject : iterable) {
                        boolean bl = false;
                        KtDeclarationContainer ktDeclarationContainer = (KtDeclarationContainer)ktClassOrObject;
                        KtFile ktFile2 = ktClassOrObject.getContainingKtFile();
                        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
                        XLineBreakpoint xLineBreakpoint = KotlinFieldBreakpointType.access$createBreakpointIfPropertyExists((KotlinFieldBreakpointType)objectArray, ktDeclarationContainer, ktFile2, className, fieldName);
                        if (xLineBreakpoint == null) continue;
                        object = xLineBreakpoint;
                        break block5;
                    }
                    object = objectRef.element = null;
                }
                if (this.$result.element == null) {
                    objectArray = new Object[]{className, fieldName, fieldName};
                    String string = JavaDebuggerBundle.message((String)"error.field.breakpoint.field.not.found", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, string);
                }
                return this.$result.element != null;
            }
        };
        dialog2.show();
        return (XLineBreakpoint)result2.element;
    }

    private final XLineBreakpoint<KotlinPropertyBreakpointProperties> createBreakpointIfPropertyExists(KtDeclarationContainer declaration, KtFile file, String className, String fieldName) {
        Object v2;
        Project project;
        block3: {
            Project project2 = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            project = project2;
            List list2 = declaration.getDeclarations();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDeclarations(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof KtProperty && Intrinsics.areEqual((Object)((KtProperty)it).getName(), (Object)fieldName))) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        KtDeclaration ktDeclaration = v2;
        if (ktDeclaration == null) {
            return null;
        }
        KtDeclaration property = ktDeclaration;
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)file);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        int line = document2.getLineNumber(property.getTextOffset());
        return (XLineBreakpoint)ActionsKt.runWriteAction(() -> KotlinFieldBreakpointType.createBreakpointIfPropertyExists$lambda$2(project, this, file, line, fieldName, className));
    }

    private final void reportError(Project project, @NlsContexts.DialogMessage String message2) {
        Messages.showMessageDialog((Project)project, (String)message2, (String)JavaDebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon2 = AllIcons.Debugger.Db_muted_field_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Db_muted_field_breakpoint");
        return icon2;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon2 = AllIcons.Debugger.Db_disabled_field_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Db_disabled_field_breakpoint");
        return icon2;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon2 = AllIcons.Debugger.Db_field_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Db_field_breakpoint");
        return icon2;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon2 = AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Db_muted_disabled_field_breakpoint");
        return icon2;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    @NotNull
    public String getShortText(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        KotlinPropertyBreakpointProperties properties = (KotlinPropertyBreakpointProperties)breakpoint2.getProperties();
        String className = properties.getMyClassName();
        return ((CharSequence)className).length() > 0 ? className + "." + properties.getMyFieldName() : properties.getMyFieldName();
    }

    @NotNull
    public KotlinPropertyBreakpointProperties createProperties() {
        return new KotlinPropertyBreakpointProperties(null, null, 3, null);
    }

    @NotNull
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<KotlinPropertyBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new KotlinFieldBreakpointPropertiesPanel();
    }

    @Nullable
    public String getDisplayText(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        Breakpoint breakpoint3 = BreakpointManager.getJavaBreakpoint((XBreakpoint)((XBreakpoint)breakpoint2));
        BreakpointWithHighlighter kotlinBreakpoint = breakpoint3 instanceof BreakpointWithHighlighter ? (BreakpointWithHighlighter)breakpoint3 : null;
        Object object = kotlinBreakpoint;
        if (object == null || (object = object.getDisplayName()) == null) {
            object = super.getDisplayText(breakpoint2);
        }
        return object;
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return null;
    }

    @NotNull
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<KotlinPropertyBreakpointProperties>> createCustomRightPropertiesPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new KotlinBreakpointFiltersPanel(project);
    }

    public boolean isSuspendThreadSupported() {
        return true;
    }

    private static final ApplicabilityResult canPutAt$lambda$0(PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        return psiElement instanceof KtProperty ? ApplicabilityResult.Companion.definitely(!((KtProperty)element).isLocal()) : (psiElement instanceof KtParameter ? ApplicabilityResult.Companion.definitely(((KtParameter)element).hasValOrVar()) : ApplicabilityResult.UNKNOWN);
    }

    private static final XLineBreakpoint createBreakpointIfPropertyExists$lambda$2(Project $project, KotlinFieldBreakpointType this$0, KtFile $file, int $line, String $fieldName, String $className) {
        return XDebuggerManager.getInstance((Project)$project).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)this$0, $file.getVirtualFile().getUrl(), $line, (XBreakpointProperties)new KotlinPropertyBreakpointProperties($fieldName, $className));
    }

    public static final /* synthetic */ void access$reportError(KotlinFieldBreakpointType $this, Project project, String message2) {
        $this.reportError(project, message2);
    }

    public static final /* synthetic */ XLineBreakpoint access$createBreakpointIfPropertyExists(KotlinFieldBreakpointType $this, KtDeclarationContainer declaration, KtFile file, String className, String fieldName) {
        return $this.createBreakpointIfPropertyExists(declaration, file, className, fieldName);
    }
}

