/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.api.graphql;

import com.intellij.collaboration.api.HttpApiHelper;
import com.intellij.collaboration.api.HttpApiHelperKt;
import com.intellij.collaboration.api.dto.GraphQLRequestDTO;
import com.intellij.collaboration.api.dto.GraphQLResponseDTO;
import com.intellij.collaboration.api.dto.GraphQLResponseDTOKt;
import com.intellij.collaboration.api.graphql.GraphQLApiHelper;
import com.intellij.collaboration.api.graphql.GraphQLDataDeserializer;
import com.intellij.collaboration.api.httpclient.ByteArrayProducingBodyPublisher;
import com.intellij.collaboration.api.httpclient.HttpClientUtil;
import com.intellij.collaboration.api.json.HttpJsonDeserializationException;
import com.intellij.collaboration.api.json.JsonDataSerializer;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Image;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016JH\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u00170\u0016\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001a2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u001c\"\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u00162\u0006\u0010\u0018\u001a\u00020\rH\u0096A\u00a2\u0006\u0002\u0010 J\u0011\u0010\u0018\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u0012H\u0096\u0001J\u0011\u0010\u0018\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0001J8\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00170\u0016\"\n\b\u0000\u0010\u0017*\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\r2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00170$H\u0096A\u00a2\u0006\u0002\u0010%J\u001e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020&0\u00162\u0006\u0010\u0018\u001a\u00020\rH\u0096A\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/collaboration/api/graphql/GraphQLApiHelperImpl;", "Lcom/intellij/collaboration/api/graphql/GraphQLApiHelper;", "Lcom/intellij/collaboration/api/HttpApiHelper;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "httpHelper", "serializer", "Lcom/intellij/collaboration/api/json/JsonDataSerializer;", "deserializer", "Lcom/intellij/collaboration/api/graphql/GraphQLDataDeserializer;", "<init>", "(Lcom/intellij/openapi/diagnostic/Logger;Lcom/intellij/collaboration/api/HttpApiHelper;Lcom/intellij/collaboration/api/json/JsonDataSerializer;Lcom/intellij/collaboration/api/graphql/GraphQLDataDeserializer;)V", "query", "Ljava/net/http/HttpRequest;", "uri", "Ljava/net/URI;", "loadQuery", "Lkotlin/Function0;", "", "variablesObject", "", "loadResponseByClass", "Ljava/net/http/HttpResponse;", "T", "request", "clazz", "Ljava/lang/Class;", "pathFromData", "", "(Ljava/net/http/HttpRequest;Ljava/lang/Class;[Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadImage", "Ljava/awt/Image;", "(Ljava/net/http/HttpRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Ljava/net/http/HttpRequest$Builder;", "sendAndAwaitCancellable", "bodyHandler", "Ljava/net/http/HttpResponse$BodyHandler;", "(Ljava/net/http/HttpRequest;Ljava/net/http/HttpResponse$BodyHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "intellij.platform.collaborationTools"})
final class GraphQLApiHelperImpl
implements GraphQLApiHelper,
HttpApiHelper {
    @NotNull
    private final Logger logger;
    @NotNull
    private final HttpApiHelper httpHelper;
    @NotNull
    private final JsonDataSerializer serializer;
    @NotNull
    private final GraphQLDataDeserializer deserializer;

    public GraphQLApiHelperImpl(@NotNull Logger logger, @NotNull HttpApiHelper httpHelper, @NotNull JsonDataSerializer serializer, @NotNull GraphQLDataDeserializer deserializer) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)httpHelper, (String)"httpHelper");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)deserializer, (String)"deserializer");
        this.logger = logger;
        this.httpHelper = httpHelper;
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    @Override
    @NotNull
    public HttpRequest query(@NotNull URI uri, @NotNull Function0<String> loadQuery, @Nullable Object variablesObject) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(loadQuery, (String)"loadQuery");
        ByteArrayProducingBodyPublisher publisher = new ByteArrayProducingBodyPublisher((Function0<byte[]>)((Function0)() -> GraphQLApiHelperImpl.query$lambda$0(this, uri, loadQuery, variablesObject)));
        HttpRequest httpRequest = this.httpHelper.request(uri).POST(publisher).header("Content-Type", "application/json").build();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"build(...)");
        return httpRequest;
    }

    @Override
    @Nullable
    public <T> Object loadResponseByClass(@NotNull HttpRequest request, @NotNull Class<T> clazz, @NotNull String[] pathFromData, @NotNull Continuation<? super HttpResponse<? extends T>> $completion) {
        HttpResponse.BodyHandler handler = HttpClientUtil.INSTANCE.inflateAndReadWithErrorHandlingAndLogging(this.logger, request, (arg_0, arg_1) -> GraphQLApiHelperImpl.loadResponseByClass$lambda$1(this, pathFromData, clazz, request, arg_0, arg_1));
        return this.httpHelper.sendAndAwaitCancellable(request, handler, $completion);
    }

    @Override
    @NotNull
    public HttpRequest.Builder request(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.httpHelper.request(uri);
    }

    @Override
    @NotNull
    public HttpRequest.Builder request(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.httpHelper.request(uri);
    }

    @Override
    @Nullable
    public <T> Object sendAndAwaitCancellable(@NotNull HttpRequest request, @NotNull HttpResponse.BodyHandler<T> bodyHandler2, @NotNull Continuation<? super HttpResponse<? extends T>> $completion) {
        return this.httpHelper.sendAndAwaitCancellable(request, bodyHandler2, $completion);
    }

    @Override
    @Nullable
    public Object sendAndAwaitCancellable(@NotNull HttpRequest request, @NotNull Continuation<? super HttpResponse<? extends Unit>> $completion) {
        return this.httpHelper.sendAndAwaitCancellable(request, $completion);
    }

    @Override
    @Nullable
    public Object loadImage(@NotNull HttpRequest request, @NotNull Continuation<? super HttpResponse<? extends Image>> $completion) {
        return this.httpHelper.loadImage(request, $completion);
    }

    private static final byte[] query$lambda$0(GraphQLApiHelperImpl this$0, URI $uri, Function0 $loadQuery, Object $variablesObject) {
        this$0.logger.debug("GraphQL request " + $uri);
        String query = (String)$loadQuery.invoke();
        GraphQLRequestDTO request = new GraphQLRequestDTO(query, $variablesObject);
        byte[] jsonBytes = this$0.serializer.toJsonBytes(request);
        if (this$0.logger.isTraceEnabled()) {
            this$0.logger.trace("GraphQL request " + $uri + " : Request body: " + new String(jsonBytes, Charsets.UTF_8));
        }
        return jsonBytes;
    }

    private static final Object loadResponseByClass$lambda$1(GraphQLApiHelperImpl this$0, String[] $pathFromData, Class $clazz, HttpRequest $request, Reader reader, HttpResponse.ResponseInfo responseInfo) {
        GraphQLResponseDTO graphQLResponseDTO;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)responseInfo, (String)"<unused var>");
        try {
            graphQLResponseDTO = this$0.deserializer.readAndMapGQLResponse(reader, $pathFromData, $clazz);
        }
        catch (Throwable e) {
            this$0.logger.warn("API response deserialization failed", e);
            throw new HttpJsonDeserializationException(HttpApiHelperKt.logName($request), e);
        }
        GraphQLResponseDTO result = graphQLResponseDTO;
        return GraphQLResponseDTOKt.getOrThrow(result);
    }
}

