/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposeNames;
import androidx.compose.compiler.plugins.kotlin.CsvBuilder;
import androidx.compose.compiler.plugins.kotlin.FeatureFlag;
import androidx.compose.compiler.plugins.kotlin.FeatureFlags;
import androidx.compose.compiler.plugins.kotlin.FunctionMetrics;
import androidx.compose.compiler.plugins.kotlin.FunctionMetricsImpl;
import androidx.compose.compiler.plugins.kotlin.JsonBuilder;
import androidx.compose.compiler.plugins.kotlin.JsonBuilderKt;
import androidx.compose.compiler.plugins.kotlin.ModuleMetrics;
import androidx.compose.compiler.plugins.kotlin.analysis.Stability;
import androidx.compose.compiler.plugins.kotlin.analysis.StabilityKt;
import androidx.compose.compiler.plugins.kotlin.lower.ComposableFunctionBodyTransformer;
import androidx.compose.compiler.plugins.kotlin.lower.IrSourcePrinterVisitor;
import java.io.File;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.types.IrType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001RB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020.H\u0016J \u00105\u001a\u0002032\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\tH\u0016J \u0010;\u001a\u0002032\u0006\u0010<\u001a\u0002092\u0006\u0010=\u001a\u0002092\u0006\u0010>\u001a\u000209H\u0016J\u001e\u0010?\u001a\u0002032\u0006\u0010@\u001a\u00020A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CH\u0016J\u0010\u0010E\u001a\u0002032\u0006\u0010F\u001a\u00020\u0003H\u0016J\u0010\u0010G\u001a\u000203*\u00060Hj\u0002`IH\u0016J\u0010\u0010J\u001a\u000203*\u00060Hj\u0002`IH\u0016J\u0010\u0010K\u001a\u000203*\u00060Hj\u0002`IH\u0016J\u0010\u0010L\u001a\u000203*\u00060Hj\u0002`IH\u0016J\u0010\u0010M\u001a\u0002032\u0006\u0010N\u001a\u00020\u0003H\u0016J\u0010\u0010O\u001a\u0002032\u0006\u0010N\u001a\u00020\u0003H\u0016J\u0010\u0010P\u001a\u00020.2\u0006\u00104\u001a\u00020QH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010/\u001a\f\u0012\b\u0012\u000600R\u00020\u00000-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u00030-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ModuleMetricsImpl;", "Landroidx/compose/compiler/plugins/kotlin/ModuleMetrics;", "name", "", "featureFlags", "Landroidx/compose/compiler/plugins/kotlin/FeatureFlags;", "stabilityOf", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Landroidx/compose/compiler/plugins/kotlin/analysis/Stability;", "<init>", "(Ljava/lang/String;Landroidx/compose/compiler/plugins/kotlin/FeatureFlags;Lkotlin/jvm/functions/Function1;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getFeatureFlags", "()Landroidx/compose/compiler/plugins/kotlin/FeatureFlags;", "getStabilityOf", "()Lkotlin/jvm/functions/Function1;", "skippableComposables", "", "restartableComposables", "readonlyComposables", "totalComposables", "restartGroups", "totalGroups", "staticArguments", "certainArguments", "knownStableArguments", "knownUnstableArguments", "unknownStableArguments", "totalArguments", "markedStableClasses", "inferredStableClasses", "inferredUnstableClasses", "inferredUncertainClasses", "effectivelyStableClasses", "totalClasses", "memoizedLambdas", "singletonLambdas", "singletonComposableLambdas", "composableLambdas", "totalLambdas", "composables", "", "Landroidx/compose/compiler/plugins/kotlin/FunctionMetrics;", "classes", "Landroidx/compose/compiler/plugins/kotlin/ModuleMetricsImpl$ClassMetrics;", "logMessages", "recordFunction", "", "function", "recordClass", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "marked", "", "stability", "recordLambda", "composable", "memoized", "singleton", "recordComposableCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "paramMeta", "", "Landroidx/compose/compiler/plugins/kotlin/lower/ComposableFunctionBodyTransformer$CallArgumentMeta;", "log", "message", "appendModuleJson", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "appendComposablesCsv", "appendComposablesTxt", "appendClassesTxt", "saveMetricsTo", "directory", "saveReportsTo", "makeFunctionMetrics", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ClassMetrics", "compiler-hosted"})
@SourceDebugExtension(value={"SMAP\nBuildMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildMetrics.kt\nandroidx/compose/compiler/plugins/kotlin/ModuleMetricsImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,610:1\n1863#2,2:611\n*S KotlinDebug\n*F\n+ 1 BuildMetrics.kt\nandroidx/compose/compiler/plugins/kotlin/ModuleMetricsImpl\n*L\n386#1:611,2\n*E\n"})
public final class ModuleMetricsImpl
implements ModuleMetrics {
    @NotNull
    private String name;
    @NotNull
    private final FeatureFlags featureFlags;
    @NotNull
    private final Function1<IrType, Stability> stabilityOf;
    private int skippableComposables;
    private int restartableComposables;
    private int readonlyComposables;
    private int totalComposables;
    private int restartGroups;
    private int totalGroups;
    private int staticArguments;
    private int certainArguments;
    private int knownStableArguments;
    private int knownUnstableArguments;
    private int unknownStableArguments;
    private int totalArguments;
    private int markedStableClasses;
    private int inferredStableClasses;
    private int inferredUnstableClasses;
    private int inferredUncertainClasses;
    private int effectivelyStableClasses;
    private int totalClasses;
    private int memoizedLambdas;
    private int singletonLambdas;
    private int singletonComposableLambdas;
    private int composableLambdas;
    private int totalLambdas;
    @NotNull
    private final List<FunctionMetrics> composables;
    @NotNull
    private final List<ClassMetrics> classes;
    @NotNull
    private final List<String> logMessages;

    public ModuleMetricsImpl(@NotNull String name, @NotNull FeatureFlags featureFlags, @NotNull Function1<? super IrType, ? extends Stability> stabilityOf) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)featureFlags, (String)"featureFlags");
        Intrinsics.checkNotNullParameter(stabilityOf, (String)"stabilityOf");
        this.name = name;
        this.featureFlags = featureFlags;
        this.stabilityOf = stabilityOf;
        this.composables = new ArrayList();
        this.classes = new ArrayList();
        this.logMessages = new ArrayList();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final FeatureFlags getFeatureFlags() {
        return this.featureFlags;
    }

    @NotNull
    public final Function1<IrType, Stability> getStabilityOf() {
        return this.stabilityOf;
    }

    @Override
    public void recordFunction(@NotNull FunctionMetrics function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (!function.getComposable()) {
            return;
        }
        int n = this.totalComposables;
        this.totalComposables = n + 1;
        if (!function.isLambda()) {
            this.composables.add(function);
        }
        if (function.getReadonly()) {
            n = this.readonlyComposables;
            this.readonlyComposables = n + 1;
        }
        if (function.getSkippable()) {
            n = this.skippableComposables;
            this.skippableComposables = n + 1;
        }
        if (function.getRestartable()) {
            n = this.restartableComposables;
            this.restartableComposables = n + 1;
            n = this.restartGroups;
            this.restartGroups = n + 1;
        }
        this.totalGroups += function.getGroups();
    }

    @Override
    public void recordClass(@NotNull IrClass declaration, boolean marked, @NotNull Stability stability) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)stability, (String)"stability");
        this.classes.add(new ClassMetrics(declaration, marked, stability));
        int n = this.totalClasses;
        this.totalClasses = n + 1;
        if (marked) {
            n = this.markedStableClasses;
            this.markedStableClasses = n + 1;
            n = this.effectivelyStableClasses;
            this.effectivelyStableClasses = n + 1;
        } else if (StabilityKt.knownStable(stability)) {
            n = this.inferredStableClasses;
            this.inferredStableClasses = n + 1;
            n = this.effectivelyStableClasses;
            this.effectivelyStableClasses = n + 1;
        } else if (StabilityKt.knownUnstable(stability)) {
            n = this.inferredUnstableClasses;
            this.inferredUnstableClasses = n + 1;
        } else {
            n = this.inferredUncertainClasses;
            this.inferredUncertainClasses = n + 1;
        }
    }

    @Override
    public void recordLambda(boolean composable, boolean memoized, boolean singleton) {
        int n = this.totalLambdas;
        this.totalLambdas = n + 1;
        if (composable) {
            n = this.composableLambdas;
            this.composableLambdas = n + 1;
        }
        if (memoized) {
            n = this.memoizedLambdas;
            this.memoizedLambdas = n + 1;
        }
        if (composable && singleton) {
            n = this.singletonComposableLambdas;
            this.singletonComposableLambdas = n + 1;
        }
        if (!composable && singleton) {
            n = this.singletonLambdas;
            this.singletonLambdas = n + 1;
        }
    }

    @Override
    public void recordComposableCall(@NotNull IrCall expression, @NotNull List<ComposableFunctionBodyTransformer.CallArgumentMeta> paramMeta) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter(paramMeta, (String)"paramMeta");
        for (ComposableFunctionBodyTransformer.CallArgumentMeta arg : paramMeta) {
            int n = this.totalArguments;
            this.totalArguments = n + 1;
            if (arg.isCertain()) {
                n = this.certainArguments;
                this.certainArguments = n + 1;
            }
            if (arg.isStatic()) {
                n = this.staticArguments;
                this.staticArguments = n + 1;
            }
            if (StabilityKt.knownStable(arg.getStability())) {
                n = this.knownStableArguments;
                this.knownStableArguments = n + 1;
                continue;
            }
            if (StabilityKt.knownUnstable(arg.getStability())) {
                n = this.knownUnstableArguments;
                this.knownUnstableArguments = n + 1;
                continue;
            }
            n = this.unknownStableArguments;
            this.unknownStableArguments = n + 1;
        }
    }

    @Override
    public void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logMessages.add(message);
    }

    @Override
    public void appendModuleJson(@NotNull Appendable $this$appendModuleJson) {
        Intrinsics.checkNotNullParameter((Object)$this$appendModuleJson, (String)"<this>");
        JsonBuilderKt.appendJson($this$appendModuleJson, (Function1<? super JsonBuilder, Unit>)((Function1)arg_0 -> ModuleMetricsImpl.appendModuleJson$lambda$2(this, arg_0)));
    }

    @Override
    public void appendComposablesCsv(@NotNull Appendable $this$appendComposablesCsv) {
        Intrinsics.checkNotNullParameter((Object)$this$appendComposablesCsv, (String)"<this>");
        JsonBuilderKt.appendCsv($this$appendComposablesCsv, (Function1<? super CsvBuilder, Unit>)((Function1)arg_0 -> ModuleMetricsImpl.appendComposablesCsv$lambda$5(this, arg_0)));
    }

    @Override
    public void appendComposablesTxt(@NotNull Appendable $this$appendComposablesTxt) {
        Intrinsics.checkNotNullParameter((Object)$this$appendComposablesTxt, (String)"<this>");
        IrSourcePrinterVisitor src = new IrSourcePrinterVisitor($this$appendComposablesTxt, null, false, 6, null);
        for (FunctionMetrics fn : this.composables) {
            fn.print($this$appendComposablesTxt, src);
        }
    }

    @Override
    public void appendClassesTxt(@NotNull Appendable $this$appendClassesTxt) {
        Intrinsics.checkNotNullParameter((Object)$this$appendClassesTxt, (String)"<this>");
        IrSourcePrinterVisitor src = new IrSourcePrinterVisitor($this$appendClassesTxt, null, false, 6, null);
        for (ClassMetrics declaration : this.classes) {
            declaration.print($this$appendClassesTxt, src);
        }
    }

    @Override
    public void saveMetricsTo(@NotNull String directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        File dir = new File(directory);
        String prefix = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)this.name, (char)'.', (char)'_', (boolean)false, (int)4, null), (String)"<", (String)"", (boolean)false, (int)4, null), (String)">", (String)"", (boolean)false, (int)4, null);
        JsonBuilderKt.write(new File(dir, prefix + "-module.json"), (Function1<? super OutputStreamWriter, Unit>)((Function1)arg_0 -> ModuleMetricsImpl.saveMetricsTo$lambda$6(this, arg_0)));
    }

    @Override
    public void saveReportsTo(@NotNull String directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        File dir = new File(directory);
        String prefix = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)this.name, (char)'.', (char)'_', (boolean)false, (int)4, null), (String)"<", (String)"", (boolean)false, (int)4, null), (String)">", (String)"", (boolean)false, (int)4, null);
        JsonBuilderKt.write(new File(dir, prefix + "-composables.csv"), (Function1<? super OutputStreamWriter, Unit>)((Function1)arg_0 -> ModuleMetricsImpl.saveReportsTo$lambda$7(this, arg_0)));
        JsonBuilderKt.write(new File(dir, prefix + "-composables.txt"), (Function1<? super OutputStreamWriter, Unit>)((Function1)arg_0 -> ModuleMetricsImpl.saveReportsTo$lambda$8(this, arg_0)));
        if (!((Collection)this.logMessages).isEmpty()) {
            JsonBuilderKt.write(new File(dir, prefix + "-composables.log"), (Function1<? super OutputStreamWriter, Unit>)((Function1)arg_0 -> ModuleMetricsImpl.saveReportsTo$lambda$9(this, arg_0)));
        }
        JsonBuilderKt.write(new File(dir, prefix + "-classes.txt"), (Function1<? super OutputStreamWriter, Unit>)((Function1)arg_0 -> ModuleMetricsImpl.saveReportsTo$lambda$10(this, arg_0)));
    }

    @Override
    @NotNull
    public FunctionMetrics makeFunctionMetrics(@NotNull IrFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return new FunctionMetricsImpl(function);
    }

    private static final Unit appendModuleJson$lambda$2$lambda$1(ModuleMetricsImpl this$0, JsonBuilder $this$entry) {
        Intrinsics.checkNotNullParameter((Object)$this$entry, (String)"$this$entry");
        Iterable $this$forEach$iv = (Iterable)FeatureFlag.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FeatureFlag flag = (FeatureFlag)((Object)element$iv);
            boolean bl = false;
            $this$entry.entry(flag.getFeatureName(), this$0.featureFlags.isEnabled(flag));
        }
        return Unit.INSTANCE;
    }

    private static final Unit appendModuleJson$lambda$2(ModuleMetricsImpl this$0, JsonBuilder $this$appendJson) {
        Intrinsics.checkNotNullParameter((Object)$this$appendJson, (String)"$this$appendJson");
        $this$appendJson.entry("skippableComposables", this$0.skippableComposables);
        $this$appendJson.entry("restartableComposables", this$0.restartableComposables);
        $this$appendJson.entry("readonlyComposables", this$0.readonlyComposables);
        $this$appendJson.entry("totalComposables", this$0.totalComposables);
        $this$appendJson.entry("restartGroups", this$0.restartGroups);
        $this$appendJson.entry("totalGroups", this$0.totalGroups);
        $this$appendJson.entry("staticArguments", this$0.staticArguments);
        $this$appendJson.entry("certainArguments", this$0.certainArguments);
        $this$appendJson.entry("knownStableArguments", this$0.knownStableArguments);
        $this$appendJson.entry("knownUnstableArguments", this$0.knownUnstableArguments);
        $this$appendJson.entry("unknownStableArguments", this$0.unknownStableArguments);
        $this$appendJson.entry("totalArguments", this$0.totalArguments);
        $this$appendJson.entry("markedStableClasses", this$0.markedStableClasses);
        $this$appendJson.entry("inferredStableClasses", this$0.inferredStableClasses);
        $this$appendJson.entry("inferredUnstableClasses", this$0.inferredUnstableClasses);
        $this$appendJson.entry("inferredUncertainClasses", this$0.inferredUncertainClasses);
        $this$appendJson.entry("effectivelyStableClasses", this$0.effectivelyStableClasses);
        $this$appendJson.entry("totalClasses", this$0.totalClasses);
        $this$appendJson.entry("memoizedLambdas", this$0.memoizedLambdas);
        $this$appendJson.entry("singletonLambdas", this$0.singletonLambdas);
        $this$appendJson.entry("singletonComposableLambdas", this$0.singletonComposableLambdas);
        $this$appendJson.entry("composableLambdas", this$0.composableLambdas);
        $this$appendJson.entry("totalLambdas", this$0.totalLambdas);
        $this$appendJson.entry("featureFlags", (Function1<? super JsonBuilder, Unit>)((Function1)arg_0 -> ModuleMetricsImpl.appendModuleJson$lambda$2$lambda$1(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit appendComposablesCsv$lambda$5$lambda$3(CsvBuilder $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.col("package");
        $this$row.col("name");
        $this$row.col("composable");
        $this$row.col("skippable");
        $this$row.col("restartable");
        $this$row.col("readonly");
        $this$row.col("inline");
        $this$row.col("isLambda");
        $this$row.col("hasDefaults");
        $this$row.col("defaultsGroup");
        $this$row.col("groups");
        $this$row.col("calls");
        return Unit.INSTANCE;
    }

    private static final Unit appendComposablesCsv$lambda$5$lambda$4(FunctionMetrics $fn, CsvBuilder $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.col($fn.getPackageName().asString());
        $this$row.col($fn.getName());
        $this$row.col($fn.getComposable());
        $this$row.col($fn.getSkippable());
        $this$row.col($fn.getRestartable());
        $this$row.col($fn.getReadonly());
        $this$row.col($fn.getInline());
        $this$row.col($fn.isLambda());
        $this$row.col($fn.getHasDefaults());
        $this$row.col($fn.getDefaultsGroup());
        $this$row.col($fn.getGroups());
        $this$row.col($fn.getCalls());
        return Unit.INSTANCE;
    }

    private static final Unit appendComposablesCsv$lambda$5(ModuleMetricsImpl this$0, CsvBuilder $this$appendCsv) {
        Intrinsics.checkNotNullParameter((Object)$this$appendCsv, (String)"$this$appendCsv");
        $this$appendCsv.row((Function1<? super CsvBuilder, Unit>)((Function1)ModuleMetricsImpl::appendComposablesCsv$lambda$5$lambda$3));
        for (FunctionMetrics fn : this$0.composables) {
            $this$appendCsv.row((Function1<? super CsvBuilder, Unit>)((Function1)arg_0 -> ModuleMetricsImpl.appendComposablesCsv$lambda$5$lambda$4(fn, arg_0)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit saveMetricsTo$lambda$6(ModuleMetricsImpl this$0, OutputStreamWriter $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        this$0.appendModuleJson($this$write);
        return Unit.INSTANCE;
    }

    private static final Unit saveReportsTo$lambda$7(ModuleMetricsImpl this$0, OutputStreamWriter $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        this$0.appendComposablesCsv($this$write);
        return Unit.INSTANCE;
    }

    private static final Unit saveReportsTo$lambda$8(ModuleMetricsImpl this$0, OutputStreamWriter $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        this$0.appendComposablesTxt($this$write);
        return Unit.INSTANCE;
    }

    private static final Unit saveReportsTo$lambda$9(ModuleMetricsImpl this$0, OutputStreamWriter $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        for (String line : this$0.logMessages) {
            ((Appendable)$this$write).append(line).append('\n');
        }
        return Unit.INSTANCE;
    }

    private static final Unit saveReportsTo$lambda$10(ModuleMetricsImpl this$0, OutputStreamWriter $this$write) {
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
        this$0.appendClassesTxt($this$write);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0007H\u0002J\u001e\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\n\u0010\u0015\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ModuleMetricsImpl$ClassMetrics;", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "marked", "", "stability", "Landroidx/compose/compiler/plugins/kotlin/analysis/Stability;", "<init>", "(Landroidx/compose/compiler/plugins/kotlin/ModuleMetricsImpl;Lorg/jetbrains/kotlin/ir/declarations/IrClass;ZLandroidx/compose/compiler/plugins/kotlin/analysis/Stability;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getMarked", "()Z", "getStability", "()Landroidx/compose/compiler/plugins/kotlin/analysis/Stability;", "simpleHumanReadable", "", "print", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "out", "src", "Landroidx/compose/compiler/plugins/kotlin/lower/IrSourcePrinterVisitor;", "compiler-hosted"})
    private final class ClassMetrics {
        @NotNull
        private final IrClass declaration;
        private final boolean marked;
        @NotNull
        private final Stability stability;

        public ClassMetrics(IrClass declaration, @NotNull boolean marked, Stability stability) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)stability, (String)"stability");
            this.declaration = declaration;
            this.marked = marked;
            this.stability = stability;
        }

        @NotNull
        public final IrClass getDeclaration() {
            return this.declaration;
        }

        public final boolean getMarked() {
            return this.marked;
        }

        @NotNull
        public final Stability getStability() {
            return this.stability;
        }

        private final String simpleHumanReadable(Stability $this$simpleHumanReadable) {
            return StabilityKt.knownStable($this$simpleHumanReadable) ? "stable" : (StabilityKt.knownUnstable($this$simpleHumanReadable) ? "unstable" : "runtime");
        }

        @NotNull
        public final Appendable print(@NotNull Appendable out, @NotNull IrSourcePrinterVisitor src) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            ModuleMetricsImpl moduleMetricsImpl = ModuleMetricsImpl.this;
            Appendable $this$print_u24lambda_u240 = out;
            boolean bl = false;
            $this$print_u24lambda_u240.append(this.simpleHumanReadable(this.stability));
            $this$print_u24lambda_u240.append(" class ");
            $this$print_u24lambda_u240.append(this.declaration.getName().asString());
            $this$print_u24lambda_u240.append(" {").append('\n');
            for (IrDeclaration decl : this.declaration.getDeclarations()) {
                IrField field;
                IrField irField;
                IrDeclaration irDeclaration = decl;
                boolean isVar = irDeclaration instanceof IrProperty ? ((IrProperty)decl).isVar() : irDeclaration instanceof IrField;
                IrDeclaration irDeclaration2 = decl;
                if (irDeclaration2 instanceof IrProperty) {
                    irField = ((IrProperty)decl).getBackingField();
                    if (irField == null) {
                        continue;
                    }
                } else {
                    if (!(irDeclaration2 instanceof IrField)) continue;
                    irField = (IrField)decl;
                }
                if (Intrinsics.areEqual((Object)(field = irField).getName(), (Object)ComposeNames.INSTANCE.getSTABILITY_FLAG())) continue;
                $this$print_u24lambda_u240.append("  ");
                Stability fieldStability = (Stability)moduleMetricsImpl.getStabilityOf().invoke((Object)field.getType());
                $this$print_u24lambda_u240.append(this.simpleHumanReadable(fieldStability));
                $this$print_u24lambda_u240.append(isVar ? " var " : " val ");
                $this$print_u24lambda_u240.append(field.getName().asString());
                $this$print_u24lambda_u240.append(": ");
                $this$print_u24lambda_u240.append(src.printType(field.getType()));
                $this$print_u24lambda_u240.append('\n');
            }
            if (!this.marked) {
                $this$print_u24lambda_u240.append("  <runtime stability> = " + this.stability).append('\n');
            }
            return $this$print_u24lambda_u240.append("}").append('\n');
        }
    }
}

