/* $NetBSD: au8522reg.h,v 1.2 2011/07/10 00:47:34 jmcneill Exp $ */

/*-
 * Copyright (c) 2010 Jared D. McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _AU8522REG_H
#define _AU8522REG_H

#define	AU8522_REG_STATUS		0x0000
#define	 AU8522_STATUS_LOCK		  0xa0
#define	AU8522_REG_INTMASK		0x0010
#define	AU8522_REG_VIDEOMODE		0x0011
#define	 AU8522_VIDEOMODE_CVBS		  0x00
#define	 AU8522_VIDEOMODE_SVIDEO	  0x04
#define	AU8522_REG_TV_PGA		0x0012
#define	 AU8522_TV_PGA_CVBS		  0x0f
#define	AU8522_REG_INPUTCTL		0x0081
#define	 AU8522_INPUTCTL_SVIDEO_CH13	  0x23
#define	 AU8522_INPUTCTL_CVBS_CH4_SIF	  0x28
#define	 AU8522_INPUTCTL_CVBS_CH1	  0xa2
#define	AU8522_REG_PGACTL		0x0082
#define	AU8522_REG_CLAMPCTL		0x0083
#define	AU8522_REG_I2C_CTL0		0x0090
#define	AU8522_REG_I2C_CTL1		0x0091
#define	AU8522_REG_MODCLKCTL		0x00a3
#define	 AU8522_MODCLKCTL_SVIDEO	  0x02
#define	 AU8522_MODCLKCTL_CVBS		  0x12
#define	AU8522_REG_SYSMODCTL0		0x00a4
#define	 AU8522_SYSMODCTL0_RESET	  0x01
#define	 AU8522_SYSMODCTL0_CVBS		  0x9d
#define	 AU8522_SYSMODCTL0_DISABLE	  0x10
#define	AU8522_REG_SYSMODCTL1		0x00a5
#define	 AU8522_SYSMODCTL1_SVIDEO	  0x04
#define	 AU8522_SYSMODCTL1_I2S		  0x09
#define	AU8522_REG_AGCRANGECTL		0x00a6
#define	AU8522_REG_SYSGAINCTL		0x00a7
#define	AU8522_REG_TUNERAGCRFSTOP	0x00a8
#define	AU8522_REG_TUNERAGCRFSTART	0x00a9
#define	AU8522_REG_TUNERAGCRFDEFAULT	0x00aa
#define	AU8522_REG_TUNERAGCIFSTOP	0x00ab
#define	AU8522_REG_TUNERAGCIFSTART	0x00ac
#define	AU8522_REG_TUNERAGCIFDEFAULT	0x00ad
#define	AU8522_REG_TUNERAGCSTEP		0x00ae
#define	AU8522_REG_TUNERGAINSTEP	0x00af
#define	AU8522_REG_GPIO_DATA		0x00e2
#define	AU8522_REG_AUDIO_MODE		0x00f1
#define	AU8522_REG_AUDIO_VOL_L		0x00f2
#define	AU8522_REG_AUDIO_VOL_R		0x00f3
#define	AU8522_REG_AUDIO_VOL		0x00f4
#define	AU8522_REG_USBEN		0x0101
#define	AU8522_REG_TUNERCTL		0x0106
#define	 AU8522_TUNERCTL_EN		  0x01
#define	AU8522_REG_I2S_CTL0		0x0110
#define	AU8522_REG_I2S_CTL1		0x0111
#define	AU8522_REG_I2S_CTL2		0x0112
#define	AU8522_REG_VFCOEF_SVIDEO	0x0413
#define	AU8522_REG_VFCOEF_CVBS		0x0415
#define	AU8522_REG_AUDIO_FREQ		0x0606
#define	AU8522_REG_LPFCOEF_BASE		0x060b
#define	AU8522_REG_SNR_QAM		0x4522
#define	AU8522_REG_SNR_VSB		0x4311

#endif /* !_AU8522REG_H */
