---
layout: page
permalink: /references/translating
title: Translating
---

myMPD has a simple translation framework integrated. It is inspired by polyglot.js.

Following translations are available and maintained:

- English (en-US) - default
- German (de-DE)

User contributed translations:

{% include_relative translating_status.md %}

Translations with more than 100 missing phrases are not included in the build.

## Translate

The translation files are imported to a public POEditor project. You can [join the project](https://poeditor.com/join/project/Z54inZwdul) and help translating.

[GitHub discussion](https://github.com/jcorporation/myMPD/discussions/803)

**Note:** There are some phrases that are only shortcuts for the full text. You can lookup the english phrase [here](https://github.com/jcorporation/myMPD/blob/master/src/i18n/json/en-US.json).

## Translation files

Translations are defined in one file per language. The translation files resides under `<srcdir>/src/i18n/json` and are named by the language code, e.g. `en-US.json`.
The perl script `translate.pl` creates the `i18n.json` from these files, do not edit this file directly.

### Syntax

- JSON key / value pairs
- key is the phrase, value the translation
- `%{smart_count}` is used for pluralization
  - `` |||| `` separates the pluralization forms
  - the phrase before is used for number one
  - the phrase after is user for numbers zero or greater than one
  - more pluralization forms can be easily added (please open an issue)
- all other `%{variables}` are replaced with values

### Example

```
"Num playlists": "%{smart_count} Playlist |||| %{smart_count} Playlists"
```

Expands to `1 Playlist` or `5 Playlists` or `0 Playlists`

### Adding missing translations

This example is for the german translation (de-DE).

1. Show missing translation phrases for one language: `./build.sh translate 2>&1 | grep "de-DE"`
2. Add translation to file: `src/i18n/json/de-DE.json`

### Adding a new language

1. Add language code and description to `src/i18n/i18n.txt`
2. Copy a existing translation to a file with the new language code
3. Translate it

You can check the translation files manually. The build process shows all missing or obsolete translations.

```
./build.sh translate
```

Debug builds should use the new translation after a successful build.

**To include it in a release build**

Add it to:
- `src/web_server/embedded_files.c`
- the struct `embedded_files` in `src/web_server/utility.c`
- `CMakeLists.txt`
- `src/compile_time.h.in`
