/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.models;

import genj.gedcom.Media;
import genj.io.InputSource;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class MultiMediaObjectsTableModel
extends AbstractTableModel {
    List<Media> multimediaObjectsRefList = new ArrayList<Media>();
    private final String[] columnsName = new String[]{NbBundle.getMessage(MultiMediaObjectsTableModel.class, (String)"MultiMediaObjectsTableModel.column.ID.title"), NbBundle.getMessage(MultiMediaObjectsTableModel.class, (String)"MultiMediaObjectsTableModel.column.title.title"), NbBundle.getMessage(MultiMediaObjectsTableModel.class, (String)"MultiMediaObjectsTableModel.column.fileName.title")};

    @Override
    public int getRowCount() {
        return this.multimediaObjectsRefList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Media media = this.multimediaObjectsRefList.get(row);
        switch (column) {
            case 0: {
                return media.getId();
            }
            case 1: {
                return media.getTitle();
            }
        }
        InputSource file = media.getFile();
        if (file != null) {
            return file.getLocation();
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public String[] getColumnsName() {
        return this.columnsName;
    }

    public void add(Media multimediaObject) {
        this.multimediaObjectsRefList.add(multimediaObject);
        this.fireTableDataChanged();
    }

    public void addAll(List<Media> multimediaObjectsList) {
        this.multimediaObjectsRefList.addAll(multimediaObjectsList);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.multimediaObjectsRefList.clear();
    }

    public Media getValueAt(int row) {
        return this.multimediaObjectsRefList.get(row);
    }
}

