/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.utils;

import java.awt.Color;
import java.util.Random;

public class ColorUtils {
    private static final Random random = new Random();

    public static Color string2color(String heaxaColor) {
        int decimalValue = Integer.parseInt(heaxaColor.substring(1), 16);
        return new Color(decimalValue);
    }

    public static String color2string(Color color) {
        String result = String.format("%06x", color.getRGB());
        return "#" + result.substring(2);
    }

    public static Color getRandomColor() {
        Color color = new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
        while (!ColorUtils.isLuma(color)) {
            color = new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
        }
        return color;
    }

    private static boolean isLuma(Color color) {
        return 0.2126 * (double)color.getRed() + 0.7152 * (double)color.getGreen() + 0.0722 * (double)color.getBlue() > 60.0;
    }
}

