/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.labelgen;

import ancestris.api.search.SearchCommunicator;
import ancestris.reports.ScopeOptions;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.report.Report;
import java.util.ArrayList;
import java.util.List;
import org.openide.util.NbBundle;

public class ScopeLabelOptions
extends ScopeOptions {
    public int scopeType = 1;
    public String[] scopeTypes = new String[]{NbBundle.getMessage(ScopeOptions.class, (String)"scope.allGedcom"), NbBundle.getMessage(ScopeOptions.class, (String)"chosen.indi.current"), NbBundle.getMessage(ScopeOptions.class, (String)"chosen.indi.on_demand"), NbBundle.getMessage(ScopeOptions.class, (String)"chosen.indi.fixed"), NbBundle.getMessage(ScopeOptions.class, (String)"scope.search")};
    public boolean displayWife = true;
    public boolean displaySiblings = false;
    public int nbGenAsc = 4;
    public int nbGenDesc = 2;
    public boolean sortBySosa = true;

    public List<Entity> getScope(Object context, Report report) {
        if (context instanceof Gedcom) {
            this.gedcom = (Gedcom)context;
        } else if (context instanceof Entity) {
            Entity entity = (Entity)context;
            this.gedcom = entity.getGedcom();
        }
        if (this.gedcom == null) {
            return null;
        }
        ArrayList<Entity> retour = new ArrayList<Entity>();
        switch (this.scopeType) {
            case 0: {
                retour.addAll(this.gedcom.getEntities("INDI"));
                retour.addAll(this.gedcom.getEntities("FAM"));
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                Indi root = this.getIndi(context, report);
                if (root == null) break;
                retour.add((Entity)root);
                break;
            }
            case 4: {
                for (Entity ent : SearchCommunicator.getResultEntities((Gedcom)this.gedcom)) {
                    if (!(ent instanceof Indi)) continue;
                    retour.add(ent);
                }
                break;
            }
        }
        return retour;
    }

    public Indi getIndi(Object context, Report report) {
        Indi indi;
        Object o = this.setRootEntity(context, "INDI", report, this.scopeType - 1);
        if (o == null) {
            return null;
        }
        Entity entity = this.getRootEntity();
        return entity instanceof Indi ? (indi = (Indi)entity) : null;
    }
}

