# Copyright (c) 2020, QuantStack and XVega Contributors
#
# Distributed under the terms of the BSD 3-Clause License.
#
# The full license is in the file LICENSE, distributed with this software.

# xvega cmake module
# This module sets the following variables in your project::
#
#   xvega_FOUND - true if xvega found on the system
#   xvega_INCLUDE_DIR - the directory containing xvega headers
#   xvega_LIBRARY - empty


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was xvegaConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)
find_dependency(nlohmann_json 3.12.0 EXACT)
find_dependency(xproperty 0.12.1)

if(NOT TARGET xvega)
    include("${CMAKE_CURRENT_LIST_DIR}/xvegaTargets.cmake")

    if (TARGET xvega AND xvega-static)
        get_target_property(xvega_INCLUDE_DIR xvega INTERFACE_INCLUDE_DIRECTORIES)
        get_target_property(xvega_LIBRARY xvega LOCATION)
        get_target_property(xvega_STATIC_LIBRARY xvega-static LOCATION)
    elseif (TARGET xvega)
        get_target_property(xvega_INCLUDE_DIR xvega INTERFACE_INCLUDE_DIRECTORIES)
        get_target_property(xvega_LIBRARY xvega LOCATION)
    elseif (TARGET xvega-static)
        get_target_property(xvega_INCLUDE_DIR xvega-static INTERFACE_INCLUDE_DIRECTORIES)
        get_target_property(xvega_STATIC_LIBRARY xvega-static LOCATION)
    endif ()

endif()

set(xvega_LIBRARY "")
