/*
 * Copyright 2008 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.gen;

/**
 * Interface to represent the constants contained in resource bundle:
 * 'com/google/gwt/i18n/client/gen/Shapes.properties'.
 */
public interface Shapes extends com.google.gwt.i18n.client.Constants {

  /**
   * Translated "a circle".
   * 
   * @return translated "a circle"
   */
  @DefaultStringValue("a circle")
  @Key("circle")
  String circle();

  /**
   * Translated "a color wheel".
   * 
   * @return translated "a color wheel"
   */
  @DefaultStringValue("a color wheel")
  @Key("shapeColor")
  String shapeColor();

  /**
   * Translated "a square\u0009".
   * 
   * @return translated "a square\u0009"
   */
  @DefaultStringValue("a square\u0009")
  @Key("square")
  String square();

  /**
   * Translated "a triangle".
   * 
   * @return translated "a triangle"
   */
  @DefaultStringValue("a triangle")
  @Key("triangle")
  String triangle();
}
