/*
 * Decompiled with CFR 0.152.
 */
package org.jpl7;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.jpl7.JPL;
import org.jpl7.JPLException;
import org.jpl7.Term;
import org.jpl7.Variable;
import org.jpl7.fli.term_t;

public class Compound
extends Term {
    protected final Term[] args;
    protected final String name;

    public Compound(String string) {
        if (string == null) {
            throw new JPLException("cannot construct with null name");
        }
        this.name = string;
        this.args = new Term[0];
    }

    protected Compound(String string, int n) {
        if (string == null) {
            throw new JPLException("cannot construct with null name");
        }
        if (n < 0) {
            throw new JPLException("cannot construct with negative arity");
        }
        this.name = string;
        this.args = new Term[n];
    }

    public Compound(String string, Term[] termArray) {
        if (string == null) {
            throw new JPLException("cannot construct with null name");
        }
        if (termArray == null) {
            throw new JPLException("cannot construct with null args");
        }
        this.name = string;
        this.args = termArray;
    }

    @Override
    public final Term arg(int n) {
        return this.args[n - 1];
    }

    @Override
    public final Term[] args() {
        return this.args;
    }

    @Override
    public final int arity() {
        return this.args.length;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Compound)) {
            return false;
        }
        Compound compound = (Compound)object;
        return Arrays.equals(this.args, compound.args) && this.name.equals(compound.name);
    }

    public int hashCode() {
        int n = Objects.hash(this.name);
        n = 31 * n + Arrays.hashCode(this.args);
        return n;
    }

    @Override
    protected final void getSubst(Map<String, Term> map, Map<term_t, Variable> map2) {
        Term.getSubsts(map, map2, this.args);
    }

    @Override
    public final boolean hasFunctor(String string, int n) {
        return string.equals(this.name) && n == this.args.length;
    }

    @Override
    public boolean isJFalse() {
        return this.hasFunctor("@", 1) && this.arg(1).isAtomOfNameType("false", "text");
    }

    @Override
    public boolean isJNull() {
        return this.equals(JPL.JNULL);
    }

    @Override
    public boolean isJTrue() {
        return this.hasFunctor("@", 1) && this.arg(1).isAtomOfNameType("true", "text");
    }

    @Override
    public boolean isJVoid() {
        return this.hasFunctor("@", 1) && this.arg(1).isAtomOfNameType("void", "text");
    }

    @Override
    public final boolean isListPair() {
        return this.hasFunctor(JPL.LIST_PAIR, 2);
    }

    @Override
    public final String name() {
        return this.name;
    }

    public void setArg(int n, Term term) {
        if (n <= 0) {
            throw new JPLException("bad (non-positive) argument index");
        }
        if (n > this.args.length) {
            throw new JPLException("bad (out-of-range) argument index");
        }
        if (term == null) {
            throw new JPLException("bad (null) argument");
        }
        this.args[n - 1] = term;
    }

    public String toString() {
        if (this.isListPair() && JPL.LIST_TOSTRING_TEXTUAL) {
            String string = this.arg(1).toString();
            if (this.arg(2).isListNil()) {
                return String.format("[%s]", string);
            }
            String string2 = this.arg(2).toString();
            StringBuilder stringBuilder = new StringBuilder(string2);
            if (this.arg(2).isListPair()) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                stringBuilder.deleteCharAt(0);
            }
            return String.format("[%s, %s]", string, stringBuilder.toString());
        }
        return JPL.quotedName(this.name) + (String)(this.args.length > 0 ? "(" + Term.toString(this.args) + ")" : "");
    }

    @Override
    public int type() {
        return 7;
    }

    @Override
    public String typeName() {
        return "Compound";
    }
}

