/* brick.c */
void rct_init_brick_struct(rct_brick_t *brick, rct_brick_type_t type);
rct_status_t rct_open_brick(rct_brick_t *brick);
rct_status_t rct_upload_file(rct_brick_t *brick, char *filename, rct_flag_t flags);
rct_status_t rct_play_sound_file(rct_brick_t *brick, rct_flag_t flags, char *filename);
rct_status_t rct_play_tone(rct_brick_t *brick, int herz, int milliseconds);
rct_status_t rct_delete_file(rct_brick_t *brick, char *filename);
rct_status_t rct_start_program(rct_brick_t *brick, char *filename);
rct_status_t rct_stop_program(rct_brick_t *brick);
rct_status_t rct_download_file(rct_brick_t *brick, char *filename);
rct_status_t rct_close_brick(rct_brick_t *brick);
rct_status_t rct_get_battery_level(rct_brick_t *brick);
rct_status_t rct_print_battery_level(rct_brick_t *brick);
rct_status_t rct_get_firmware_version(rct_brick_t *brick);
rct_status_t rct_print_firmware_version(rct_brick_t *brick);
rct_status_t rct_print_device_info(rct_brick_t *brick);
rct_status_t rct_motor_on(rct_brick_t *brick, int port, int power);
/* debug.c */
int debug_printf(char *format, ...);
/* get_home_dir.c */
char *get_home_dir(char dir[], int maxlen);
/* nxt.c */
char    *nxt_pc_to_brick_filename(char *filename_on_pc);
rct_status_t nxt_open_brick(rct_nxt_t *nxt);
rct_status_t nxt_open_brick_usb(rct_nxt_t *nxt);
rct_status_t nxt_open_brick_bluetooth(rct_nxt_t *nxt);
rct_status_t nxt_print_battery_level(rct_nxt_t *nxt);
rct_status_t nxt_print_device_info(rct_nxt_t *nxt);
rct_status_t nxt_print_firmware_version(rct_nxt_t *nxt);
int nxt_send_simple_cmd(rct_nxt_t *nxt, int cmd_type, int cmd, char *response, int response_max);
int nxt_send_cmd(rct_nxt_t *nxt, int cmd_type, int cmd, char *response, int response_max, char *format, ...);
rct_status_t nxt_send_buf(rct_nxt_t *nxt, char *buf, int len);
rct_status_t nxt_send_str(rct_nxt_t *nxt, char *str);
rct_status_t nxt_recv_buf(rct_nxt_t *nxt, char *buf, int maxlen);
rct_status_t nxt_close_brick(rct_nxt_t *nxt);
rct_status_t nxt_close_brick_usb(rct_nxt_t *nxt);
rct_status_t nxt_close_brick_bluetooth(rct_nxt_t *nxt);
rct_status_t nxt_validate_filename(char *filename, char *correct_ext, const char *caller);
rct_status_t nxt_upload_file(rct_nxt_t *nxt, char *filename, rct_flag_t flags);
void nxt_init_struct(rct_nxt_t *nxt);
short buf2short(unsigned char *buf);
void short2buf(unsigned char *buf, long val);
long buf2long(unsigned char *buf);
void long2buf(unsigned char *buf, long val);
void debug_nxt_dump_response(char *response, int bytes, char *cmd);
void debug_nxt_dump_cmd(char *cmd, int bytes, char *cmd_name);
void nxt_build_file_cmd(char *cmd, int cmd_type, int cmd_code, char *filename);
void nxt_init_buff_header(char *buff, int cmd_code, int file_handle);
nxt_connection_t nxt_connection_type(rct_nxt_t *nxt);
rct_status_t nxt_copy_text_bt_addr(rct_nxt_t *nxt, char *address);
rct_status_t nxt_copy_hostent_bt_addr(rct_nxt_t *nxt, char *addr);
rct_status_t nxt_upload_firmware(rct_nxt_t *nxt, char *file);
rct_status_t nxt_download_file(rct_nxt_t *nxt, char *file);
rct_status_t nxt_check_response(rct_nxt_t *nxt, char *response, int bytes, int expected_bytes, char *func);
void nxt_response_on(rct_nxt_t *nxt);
void nxt_response_off(rct_nxt_t *nxt);
/* nxt_direct_cmd.c */
rct_status_t nxt_start_program(rct_nxt_t *nxt, char *raw_filename);
rct_status_t nxt_stop_program(rct_nxt_t *nxt);
rct_status_t nxt_play_sound_file(rct_nxt_t *nxt, rct_flag_t flags, char *const raw_filename);
rct_status_t nxt_play_tone(rct_nxt_t *nxt, int herz, int milliseconds);
rct_status_t nxt_set_output_state(rct_nxt_t *nxt, int port, int power, nxt_output_mode_t mode, nxt_output_regulation_mode_t regulation, int ratio, nxt_output_runstate_t runstate, unsigned long tacholimit);
rct_status_t nxt_set_input_mode(rct_nxt_t *nxt);
rct_status_t nxt_get_output_state(rct_nxt_t *nxt);
rct_status_t nxt_get_input_values(rct_nxt_t *nxt);
rct_status_t nxt_reset_input_scaled_value(rct_nxt_t *nxt);
rct_status_t nxt_message_write(rct_nxt_t *nxt);
rct_status_t nxt_reset_motor_position(rct_nxt_t *nxt);
rct_status_t nxt_get_battery_level(rct_nxt_t *nxt);
rct_status_t nxt_stop_sound_playback(rct_nxt_t *nxt);
rct_status_t nxt_keep_alive(rct_nxt_t *nxt);
rct_status_t nxt_ls_get_status(rct_nxt_t *nxt);
rct_status_t nxt_ls_write(rct_nxt_t *nxt);
rct_status_t nxt_ls_read(rct_nxt_t *nxt);
rct_status_t nxt_get_current_program_name(rct_nxt_t *nxt);
rct_status_t nxt_message_read(rct_nxt_t *nxt);
/* nxt_output.c */
void nxt_output_init(nxt_output_state_t *nxt_output);
/* nxt_system_cmd.c */
rct_status_t nxt_open_file_read(rct_nxt_t *nxt);
rct_status_t nxt_open_file_write(rct_nxt_t *nxt);
rct_status_t nxt_read_file(rct_nxt_t *nxt);
rct_status_t nxt_write_file(rct_nxt_t *nxt, char *filename, int file_handle);
rct_status_t nxt_close_file(rct_nxt_t *nxt, int file_handle);
rct_status_t nxt_delete_file(rct_nxt_t *nxt, char *filename);
rct_status_t nxt_find_first(rct_nxt_t *nxt);
rct_status_t nxt_find_next(rct_nxt_t *nxt);
rct_status_t nxt_get_firmware_version(rct_nxt_t *nxt);
rct_status_t nxt_open_file_write_linear(rct_nxt_t *nxt, char *filename, size_t size);
rct_status_t nxt_open_file_read_linear(rct_nxt_t *nxt);
rct_status_t nxt_open_file_write_data(rct_nxt_t *nxt, char *filename, size_t size);
rct_status_t nxt_open_file_append_data(rct_nxt_t *nxt);
rct_status_t nxt_boot(rct_nxt_t *nxt);
rct_status_t nxt_set_brick_name(rct_nxt_t *nxt);
rct_status_t nxt_get_device_info(rct_nxt_t *nxt);
rct_status_t nxt_delete_user_flash(rct_nxt_t *nxt);
rct_status_t nxt_poll_command_length(rct_nxt_t *nxt);
rct_status_t nxt_poll(rct_nxt_t *nxt);
rct_status_t nxt_bluetooth_factory_reset(rct_nxt_t *nxt);
rct_status_t nxt_message(rct_nxt_t *nxt);
rct_status_t nxt_error_message_back_to_host(rct_nxt_t *nxt);
rct_status_t nxt_request_first_module(rct_nxt_t *nxt);
rct_status_t nxt_request_next_module(rct_nxt_t *nxt);
rct_status_t nxt_close_module_handle(rct_nxt_t *nxt);
rct_status_t nxt_read_io_map(rct_nxt_t *nxt);
rct_status_t nxt_write_io_map(rct_nxt_t *nxt);
/* pic.c */
rct_status_t pic_send_command(int fd, const char *raw_cmd, int raw_len, const char *data, int dlen, char *response, int eot);
rct_status_t pic_read_response(int fd, char *response, int eot);
void debug_hex_dump(const char *str, int len);
int memcpy_esc(char *dest, const char *src, int slen);
rct_status_t pic_erase_program_mem(rct_pic_t *pic, unsigned long start_address, unsigned long end_address);
rct_status_t pic_write_program_mem(rct_pic_t *pic, unsigned long address, unsigned int blocks, char *code);
rct_status_t pic_get_bootloader_version(rct_pic_t *pic);
rct_status_t pic_print_bootloader_version(rct_pic_t *pic);
rct_status_t pic_read_program_mem(rct_pic_t *pic, unsigned long address, unsigned int bytes);
rct_status_t pic_return_to_user_code(rct_pic_t *pic);
unsigned long hex_val(char *start, int digits);
rct_status_t pic_reset(int fd, char *response);
rct_status_t pic_open_controller(rct_pic_t *pic, char *device);
rct_status_t pic_close_controller(rct_pic_t *pic);
void pic_init_struct(rct_pic_t *pic);
int pic_valid_program_range(unsigned long start_address, unsigned long end_address, unsigned long valid_start, unsigned long valid_end, const char *caller);
/* rct.c */
int rct_find_bricks(rct_brick_list_t *bricks, char *name, unsigned int flags);
int rct_find_nxt_bricks(rct_brick_list_t *bricks, char *name);
int rct_find_nxt_usb(rct_brick_list_t *bricks);
int rct_find_nxt_bluetooth(rct_brick_list_t *bricks, char *name);
rct_brick_t *rct_get_brick_from_list(rct_brick_list_t *list, int n);
int rct_brick_count(rct_brick_list_t *bricks);
rct_status_t rct_set_count(rct_brick_list_t *bricks, int n);
rct_status_t rct_increase_count(rct_brick_list_t *bricks, int n);
/* rcx.c */
void rcx_init_struct(rct_rcx_t *rcx);
int rcx_open_brick(rct_rcx_t *rcx);
/* usb.c */
int usb_device_info(struct usb_device *dev);
/* vex.c */
rct_status_t vex_upload_program(rct_pic_t *pic, char *hexfile_name);
int vex_valid_program_range(unsigned long start_address, unsigned long end_address, char *caller);
void deassert_pin(int fd, int pin_mask);
void assert_pin(int fd, int pin_mask);
time_t difftimeofday(struct timeval *t1, struct timeval *t2);
void vex_set_program_mode(rct_pic_t *pic);
rct_status_t vex_open_controller(rct_pic_t *pic, char *device);
void vex_close_controller(rct_pic_t *pic);
void serial_eat_leftovers(int fd);

