private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule function_9_0 {
	meta:
		name = "_NF__35"
		size = 79
		refs = "0002 TlsLast 000c TlsIndex 0019 @RunError 0025 _NF__2D 0043 _NF__32 0049 _NV__33"
	strings:
		$1 = { 53 B8 ?? ?? ?? ?? 85 C0 74 43 83 3D ?? ?? ?? ?? 00 7D 0A B8 E2 00 00 00 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 40 E8 ?? ?? ?? ?? 8B D8 85 DB 75 0C B8 E2 00 00 00 E8 ?? ?? ?? ?? EB 0C 53 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_10_0 {
	meta:
		name = "_NF__36"
		size = 39
		refs = "0001 TlsLast 000a _NF__2F 000f TlsIndex 001d @RunError 0022 _NF__35"
	strings:
		$1 = { B8 ?? ?? ?? ?? 85 C0 74 1D E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 C0 7D 0A B8 E2 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_11_0 {
	meta:
		name = "_NF__37"
		size = 40
		refs = "0001 TlsLast 000b TlsIndex 0019 _NF__31 0023 _NF__2E"
	strings:
		$1 = { B8 ?? ?? ?? ?? 85 C0 74 1E 83 3D ?? ?? ?? ?? 00 7C 15 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 06 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_12_0 {
	meta:
		name = "_NF__38"
		size = 35
		refs = "0001 TlsLast 000a _NF__37 0010 TlsIndex 001e _NF__30"
	strings:
		$1 = { B8 ?? ?? ?? ?? 85 C0 74 19 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 7C 0B A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_13_0 {
	meta:
		name = "@GetTls"
		size = 67
		refs = "0002 ModuleIsLib 0008 TlsIndex 001c _NF__35 0028 _NF__31 0033 _NV__33"
	strings:
		$1 = { 8A 0D ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 84 C9 75 28 64 8B 15 2C 00 00 00 8B 04 82 C3 E8 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 01 C3 8B 05 ?? ?? ?? ?? C3 50 E8 ?? ?? ?? ?? 85 C0 74 D9 C3 }
	condition:
		$1
}

rule function_14_0 {
	meta:
		name = "_NF__3B"
		size = 75
		refs = "0012 HInstance 0018 _NF__2B 001f LoadResourceModule 0027 _NV__34 003f RegisterModule"
	strings:
		$1 = { 53 81 C4 F8 FE FF FF 68 05 01 00 00 8D 44 24 04 50 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C4 E8 ?? ?? ?? ?? 8B D8 89 1D ?? ?? ?? ?? 85 DB 75 0A A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 81 C4 08 01 00 00 5B C3 }
	condition:
		$1
}

rule function_15_0 {
	meta:
		name = "_NF__3C"
		size = 30
		refs = "0001 _NV__34 0006 UnregisterModule 0019 _NF__2A"
	strings:
		$1 = { B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 74 06 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_16_0 {
	meta:
		name = "@InitPkg"
		size = 83
		refs = "000d ModuleIsLib 0014 ModuleIsPackage 001a _NV__34 001f HInstance 0024 TlsLast 002f _NV__3A 003b _NF__3B 0046 _NF__3C"
	strings:
		$1 = { 55 8B EC 53 56 8B 5D 0C 8B 45 08 C6 05 ?? ?? ?? ?? 01 C6 05 ?? ?? ?? ?? 01 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? B8 ?? ?? ?? ?? 85 C0 74 09 8B 34 9D ?? ?? ?? ?? FF D6 83 FB 01 75 07 E8 ?? ?? ?? ?? EB 09 85 DB 75 05 E8 ?? ?? ?? ?? 83 C8 FF 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_17_0 {
	meta:
		name = "@InitLib"
		size = 56
		refs = "0001 _NV__34 000f ModuleIsLib 0019 HInstance 0021 _NF__3B 0029 DllProc 002e _NV__3A 0033 @StartLib"
	strings:
		$1 = { BA ?? ?? ?? ?? 83 7D 0C 01 75 1C 50 52 C6 05 ?? ?? ?? ?? 01 8B 4D 08 89 0D ?? ?? ?? ?? 89 4A 04 E8 ?? ?? ?? ?? 5A 58 FF 35 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_18_0 {
	meta:
		name = "@InitExe"
		size = 36
		refs = "0004 _NF__2C 0009 _NV__34 0010 HInstance 0018 _NF__3B 001f @StartExe"
	strings:
		$1 = { 50 6A 00 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 52 89 05 ?? ?? ?? ?? 89 42 04 E8 ?? ?? ?? ?? 5A 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_19_0 {
	meta:
		name = "Finalization"
		size = 46
		refs = "0007 Finalization 0013 _NV__29 0026 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_20_0 {
	meta:
		name = "SysInit"
		size = 8
		refs = "0002 _NV__29"
	strings:
		$1 = { 83 2D ?? ?? ?? ?? 01 C3 }
	condition:
		$1
}

rule function_21_0 {
	meta:
		name = "_NF__10E"
		size = 74
		refs = "0007 TInterfacedObject.QueryInterface 0011 TInterfacedObject._AddRef 001b TInterfacedObject._Release 0022 _NF__10E"
	strings:
		$1 = { CC 83 44 24 04 FC E9 ?? ?? ?? ?? 83 44 24 04 FC E9 ?? ?? ?? ?? 83 44 24 04 FC E9 ?? ?? ?? ?? CC CC CC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 00 00 00 00 00 00 00 00 00 00 00 C0 00 00 00 00 00 00 46 ?? ?? ?? ?? 04 00 00 00 }
	condition:
		$1
}

rule function_77_0 {
	meta:
		name = "_NF__196"
		size = 34
		refs = "000b _NF__179"
	strings:
		$1 = { 53 83 C4 BC BB 0A 00 00 00 54 E8 ?? ?? ?? ?? F6 44 24 2C 01 74 05 0F B7 5C 24 30 8B C3 83 C4 44 5B C3 }
	condition:
		$1
}

rule function_86_0 {
	meta:
		name = "_NF__1AC"
		size = 79
		refs = "0003 _NV__1AB 0014 _NF__19A 0024 _NV__1AA"
	strings:
		$1 = { 53 56 BE ?? ?? ?? ?? 83 3E 00 75 3A 68 44 06 00 00 6A 00 E8 ?? ?? ?? ?? 8B C8 85 C9 75 05 33 C0 5E 5B C3 A1 ?? ?? ?? ?? 89 01 89 0D ?? ?? ?? ?? 33 D2 8B C2 03 C0 8D 44 C1 04 8B 1E 89 18 89 06 42 83 FA 64 75 EC 8B 06 8B 10 89 16 5E 5B C3 }
	condition:
		$1
}

rule function_87_0 {
	meta:
		name = "_NF__1AD"
		size = 6
	strings:
		$1 = { 89 00 89 40 04 C3 }
	condition:
		$1
}

rule function_88_0 {
	meta:
		name = "_NF__1AE"
		size = 48
		refs = "0007 _NF__1AC"
	strings:
		$1 = { 53 56 8B F2 8B D8 E8 ?? ?? ?? ?? 85 C0 75 05 33 C0 5E 5B C3 8B 16 89 50 08 8B 56 04 89 50 0C 8B 13 89 10 89 58 04 89 42 04 89 03 B0 01 5E 5B C3 }
	condition:
		$1
}

rule function_89_0 {
	meta:
		name = "_NF__1AF"
		size = 24
		refs = "000c _NV__1AB"
	strings:
		$1 = { 8B 50 04 8B 08 89 0A 89 51 04 8B 15 ?? ?? ?? ?? 89 10 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_90_0 {
	meta:
		name = "_NF__1B0"
		size = 113
		refs = "002d _NF__1AF 005f _NF__1AE"
	strings:
		$1 = { 53 56 57 55 51 8B F1 89 14 24 8B E8 8B 5D 00 8B 04 24 8B 10 89 16 8B 50 04 89 56 04 8B 3B 8B 43 08 8B D0 03 53 0C 3B 16 75 14 8B C3 E8 ?? ?? ?? ?? 8B 43 08 89 06 8B 43 0C 01 46 04 EB 16 8B 16 03 56 04 3B C2 75 0D 8B C3 E8 ?? ?? ?? ?? 8B 43 0C 01 46 04 8B DF 3B EB 75 C2 8B D6 8B C5 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 89 06 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_91_0 {
	meta:
		name = "_NF__1B1"
		size = 143
		refs = "003b _NF__1AF 0070 _NF__1AE"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B D8 8B FB 8B 32 8B 43 08 3B F0 72 6C 8B CE 03 4A 04 8B E8 03 6B 0C 3B CD 77 5E 3B F0 75 1B 8B 42 04 01 43 08 8B 42 04 29 43 0C 83 7B 0C 00 75 44 8B C3 E8 ?? ?? ?? ?? EB 3B 8B 0A 8B 72 04 03 CE 8B F8 03 7B 0C 3B CF 75 05 29 73 0C EB 26 8B 0A 03 4A 04 89 0C 24 2B F9 89 7C 24 04 8B 12 2B D0 89 53 0C 8B D4 8B C3 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 0C B0 01 EB 08 8B 1B 3B FB 75 85 33 C0 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_92_0 {
	meta:
		name = "_NF__1B3"
		size = 99
		refs = "0030 _NF__19C 003f _NV__1B2 0044 _NF__1AE 0057 _NF__19D"
	strings:
		$1 = { 53 56 57 8B DA 8B F0 81 FE 00 00 10 00 7D 07 BE 00 00 10 00 EB 0C 81 C6 FF FF 00 00 81 E6 00 00 FF FF 89 73 04 6A 01 68 00 20 00 00 56 6A 00 E8 ?? ?? ?? ?? 8B F8 89 3B 85 FF 74 23 8B D3 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 13 68 00 80 00 00 6A 00 8B 03 50 E8 ?? ?? ?? ?? 33 C0 89 03 5F 5E 5B C3 }
	condition:
		$1
}

rule function_93_0 {
	meta:
		name = "_NF__1B4"
		size = 119
		refs = "001f _NF__19C 0052 _NV__1B2 0057 _NF__1AE 006a _NF__19D"
	strings:
		$1 = { 53 56 57 55 8B D9 8B F2 8B E8 C7 43 04 00 00 10 00 6A 04 68 00 20 00 00 68 00 00 10 00 55 E8 ?? ?? ?? ?? 8B F8 89 3B 85 FF 75 1F 81 C6 FF FF 00 00 81 E6 00 00 FF FF 89 73 04 6A 04 68 00 20 00 00 56 55 E8 ?? ?? ?? ?? 89 03 83 3B 00 74 23 8B D3 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 13 68 00 80 00 00 6A 00 8B 03 50 E8 ?? ?? ?? ?? 33 C0 89 03 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_94_0 {
	meta:
		name = "_NF__1B5"
		size = 184
		refs = "0029 _NV__1B2 0065 _NF__19D 006f _NV__1A4 007a _NF__1AF"
	strings:
		$1 = { 53 56 57 55 83 C4 EC 89 4C 24 04 89 14 24 C7 44 24 08 FF FF FF FF 33 D2 89 54 24 0C 8B E8 8B 04 24 03 C5 89 44 24 10 8B 1D ?? ?? ?? ?? EB 51 8B 3B 8B 73 08 3B EE 77 46 8B C6 03 43 0C 3B 44 24 10 77 3B 3B 74 24 08 73 04 89 74 24 08 8B C6 03 43 0C 3B 44 24 0C 76 04 89 44 24 0C 68 00 80 00 00 6A 00 56 E8 ?? ?? ?? ?? 85 C0 75 0A C7 05 ?? ?? ?? ?? 01 00 00 00 8B C3 E8 ?? ?? ?? ?? 8B DF 81 FB ?? ?? ?? ?? 75 A7 8B 44 24 04 33 D2 89 10 83 7C 24 0C 00 74 19 8B 44 24 04 8B 54 24 08 89 10 8B 44 24 0C 2B 44 24 08 8B 54 24 04 89 42 04 83 C4 14 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_95_0 {
	meta:
		name = "_NF__1B6"
		size = 146
		refs = "0040 _NV__1B2 006e _NF__19C"
	strings:
		$1 = { 53 56 57 55 83 C4 F4 89 4C 24 04 89 14 24 8B D0 8B EA 81 E5 00 F0 FF FF 03 14 24 81 C2 FF 0F 00 00 81 E2 00 F0 FF FF 89 54 24 08 8B 44 24 04 89 28 8B 44 24 08 2B C5 8B 54 24 04 89 42 04 8B 35 ?? ?? ?? ?? EB 3C 8B 5E 08 8B 7E 0C 03 FB 3B EB 76 02 8B DD 3B 7C 24 08 76 04 8B 7C 24 08 3B FB 76 1E 6A 04 68 00 10 00 00 2B FB 57 53 E8 ?? ?? ?? ?? 85 C0 75 0A 8B 44 24 04 33 D2 89 10 EB 0A 8B 36 81 FE ?? ?? ?? ?? 75 BC 83 C4 0C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_96_0 {
	meta:
		name = "_NF__1B7"
		size = 125
		refs = "0031 _NV__1B2 005b _NF__19D 0065 _NV__1A4"
	strings:
		$1 = { 53 56 57 55 51 8B D8 8B F3 81 C6 FF 0F 00 00 81 E6 00 F0 FF FF 89 34 24 8B EB 03 EA 81 E5 00 F0 FF FF 8B 04 24 89 01 8B C5 2B 04 24 89 41 04 8B 35 ?? ?? ?? ?? EB 38 8B 5E 08 8B 7E 0C 03 FB 3B 1C 24 73 03 8B 1C 24 3B EF 73 02 8B FD 3B FB 76 1C 68 00 40 00 00 2B FB 57 53 E8 ?? ?? ?? ?? 85 C0 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 8B 36 81 FE ?? ?? ?? ?? 75 C0 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_97_0 {
	meta:
		name = "_NF__1B9"
		size = 142
		refs = "000c _NV__1B8 002e _NF__1B6 004c _NF__1AF 005d _NF__1B3 006d _NF__1B0 007f _NF__1B5"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F2 8B F8 BD ?? ?? ?? ?? 81 C7 FF 3F 00 00 81 E7 00 C0 FF FF 8B 5D 00 EB 33 3B 7B 0C 7F 2C 8B CE 8B D7 8B 43 08 E8 ?? ?? ?? ?? 83 3E 00 74 50 8B 46 04 01 43 08 8B 46 04 29 43 0C 83 7B 0C 00 75 3E 8B C3 E8 ?? ?? ?? ?? EB 35 8B 1B 3B DD 75 C9 8B D6 8B C7 E8 ?? ?? ?? ?? 83 3E 00 74 21 8B CC 8B D6 8B C5 E8 ?? ?? ?? ?? 83 3C 24 00 75 A5 8B CC 8B 56 04 8B 06 E8 ?? ?? ?? ?? 33 C0 89 06 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_98_0 {
	meta:
		name = "_NF__1BA"
		size = 291
		refs = "000f _NV__1B8 004d _NF__1B4 0063 _NF__1B0 007b _NF__1B5 00e7 _NF__1B6 010e _NF__1AF"
	strings:
		$1 = { 53 56 57 55 83 C4 EC 89 0C 24 8B FA 8B F0 BD ?? ?? ?? ?? 81 C7 FF 3F 00 00 81 E7 00 C0 FF FF 8B 5D 00 EB 02 8B 1B 3B DD 74 05 3B 73 08 75 F5 3B 73 08 75 57 3B 7B 0C 0F 8E 96 00 00 00 8D 4C 24 04 8B D7 2B 53 0C 8B 43 08 03 43 0C E8 ?? ?? ?? ?? 83 7C 24 04 00 74 33 8D 4C 24 0C 8D 54 24 04 8B C5 E8 ?? ?? ?? ?? 83 7C 24 0C 00 75 B1 8D 4C 24 0C 8B 54 24 08 8B 44 24 04 E8 ?? ?? ?? ?? 8B 04 24 33 D2 89 10 E9 90 00 00 00 8D 4C 24 04 8B D7 8B C6 E8 ?? ?? ?? ?? 83 7C 24 04 00 74 34 8D 4C 24 0C 8D 54 24 04 8B C5 E8 ?? ?? ?? ?? 83 7C 24 0C 00 0F 85 66 FF FF FF 8D 4C 24 0C 8B 54 24 08 8B 44 24 04 E8 ?? ?? ?? ?? 8B 04 24 33 D2 89 10 EB 48 8B 6B 08 3B F5 75 3A 3B 7B 0C 7F 35 8B 0C 24 8B D7 8B C5 E8 ?? ?? ?? ?? 8B 04 24 83 38 00 74 28 8B 04 24 8B 40 04 01 43 08 8B 04 24 8B 40 04 29 43 0C 83 7B 0C 00 75 10 8B C3 E8 ?? ?? ?? ?? EB 07 8B 04 24 33 D2 89 10 83 C4 14 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_99_0 {
	meta:
		name = "_NF__1BB"
		size = 140
		refs = "002f _NF__1B7 003a _NV__1B8 003f _NF__1B0 0056 _NF__1B5 007b _NF__1B1"
	strings:
		$1 = { 53 56 57 83 C4 EC 8B F9 89 14 24 8D 98 FF 3F 00 00 81 E3 00 C0 FF FF 8B 34 24 03 F0 81 E6 00 C0 FF FF 3B DE 73 5B 8B CF 8B D6 2B D3 8B C3 E8 ?? ?? ?? ?? 8D 4C 24 04 8B D7 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5C 24 04 85 DB 74 1F 8D 4C 24 0C 8B 54 24 08 8B C3 E8 ?? ?? ?? ?? 8B 44 24 0C 89 44 24 04 8B 44 24 10 89 44 24 08 83 7C 24 04 00 74 14 8D 54 24 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 04 33 C0 89 07 83 C4 14 5F 5E 5B C3 }
	condition:
		$1
}

rule function_100_0 {
	meta:
		name = "_NF__1C7"
		size = 196
		refs = "0007 _NF__1C7 0012 _NV__1A5 0017 _NF__19E 001d IsMultiThread 002a _NF__19F 002f _NV__1B2 0034 _NF__1AD 0039 _NV__1B8 0043 _NV__1C6 0054 _NF__19A 0059 _NV__1C5 0080 _NV__1C1 008a _NV__1C2 0090 _NV__1A3 00b1 _NF__1A0 00b7 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 F8 0F 00 00 6A 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 2F B8 03 00 00 00 8B 15 ?? ?? ?? ?? 33 C9 89 4C 82 F4 40 3D 01 04 00 00 75 EC B8 ?? ?? ?? ?? 89 40 04 89 00 A3 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 01 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 A0 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule function_101_0 {
	meta:
		name = "_NF__1C8"
		size = 226
		refs = "0006 _NV__1A3 0015 _NF__1C8 0021 IsMultiThread 0029 _NV__1A5 002e _NF__19F 003a _NV__1C5 0040 _NF__19B 004d _NV__1B2 005f _NF__19D 0073 _NF__1AD 0078 _NV__1B8 0082 _NV__1C6 008c _NV__1AA 00c9 _NF__1A0 00d3 _NF__1A1 00d9 @HandleFinally"
	strings:
		$1 = { 55 8B EC 53 80 3D ?? ?? ?? ?? 00 0F 84 CE 00 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? EB 12 68 00 80 00 00 6A 00 8B 43 08 50 E8 ?? ?? ?? ?? 8B 1B 81 FB ?? ?? ?? ?? 75 E6 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 74 17 8B 10 89 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 75 E9 64 8F 05 00 00 00 00 83 C4 08 68 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB DB 5B 5D C3 }
	condition:
		$1
}

rule function_102_0 {
	meta:
		name = "_NF__1C9"
		size = 83
		refs = "0003 _NV__1C2 0028 _NV__1C5"
	strings:
		$1 = { 53 3B 05 ?? ?? ?? ?? 75 09 8B 50 04 89 15 ?? ?? ?? ?? 8B 50 04 8B 48 08 81 F9 00 10 00 00 7F 2A 3B C2 75 10 C1 E9 02 A1 ?? ?? ?? ?? 33 D2 89 54 88 F4 EB 1D C1 E9 02 8B 1D ?? ?? ?? ?? 89 54 8B F4 8B 00 89 02 89 50 04 5B C3 8B 00 89 02 89 50 04 5B C3 }
	condition:
		$1
}

rule function_103_0 {
	meta:
		name = "_NF__1CA"
		size = 47
		refs = "0002 _NV__1C6 0022 _NV__1A4"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? EB 10 8B 4A 08 3B C1 72 07 03 4A 0C 3B C1 72 16 8B 12 81 FA ?? ?? ?? ?? 75 E8 C7 05 ?? ?? ?? ?? 03 00 00 00 33 D2 8B C2 C3 }
	condition:
		$1
}

rule function_104_0 {
	meta:
		name = "_NF__1CB"
		size = 48
		refs = "0017 _NF__1D1"
	strings:
		$1 = { 53 8B CA 83 E9 04 8D 1C 01 83 FA 10 7C 0F C7 03 07 00 00 80 8B D1 E8 ?? ?? ?? ?? 5B C3 83 FA 04 7C 0C 8B CA 81 C9 02 00 00 80 89 08 89 0B 5B C3 }
	condition:
		$1
}

rule function_105_0 {
	meta:
		name = "_NF__1CC"
		size = 34
		refs = "0002 AllocMemCount 0018 AllocMemSize 001d SysFreeMem"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 8B D0 83 EA 04 8B 12 81 E2 FC FF FF 7F 83 EA 04 01 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_106_0 {
	meta:
		name = "_NF__1CD"
		size = 40
		refs = "000e _NF__1CC"
	strings:
		$1 = { 83 FA 0C 7C 0E 83 CA 02 89 10 83 C0 04 E8 ?? ?? ?? ?? C3 83 FA 04 7C 0A 8B CA 81 C9 02 00 00 80 89 08 03 C2 83 20 FE C3 }
	condition:
		$1
}

rule function_107_0 {
	meta:
		name = "_NF__1CE"
		size = 109
		refs = "001b _NV__1A4 0062 _NF__1C9"
	strings:
		$1 = { 53 56 8B D0 83 EA 04 8B 12 8B CA 81 E1 02 00 00 80 81 F9 02 00 00 80 74 0A C7 05 ?? ?? ?? ?? 04 00 00 00 8B DA 81 E3 FC FF FF 7F 2B C3 8B C8 33 11 F7 C2 FE FF FF FF 74 0A C7 05 ?? ?? ?? ?? 05 00 00 00 F6 01 01 74 20 8B D0 83 EA 0C 8B 72 08 2B C6 3B 70 08 74 0A C7 05 ?? ?? ?? ?? 06 00 00 00 E8 ?? ?? ?? ?? 03 DE 8B C3 5E 5B C3 }
	condition:
		$1
}

rule function_108_0 {
	meta:
		name = "_NF__1CF"
		size = 56
		refs = "0024 _NF__1C9"
	strings:
		$1 = { 53 56 57 8B D8 33 FF 8B 03 A9 00 00 00 80 74 0B 25 FC FF FF 7F 03 F8 03 D8 8B 03 A8 02 75 13 8B F3 8B C6 E8 ?? ?? ?? ?? 8B 46 08 03 F8 03 D8 83 23 FE 8B C7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_109_0 {
	meta:
		name = "_NF__1D0"
		size = 152
		refs = "000e _NF__1CA 0041 _NF__1BB 0068 _NF__1CB 0082 _NF__1CD 008b _NF__1B1"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B FA 8B F0 8B C6 E8 ?? ?? ?? ?? 8B D8 8B 6B 08 8B C5 03 43 0C 8B D0 8D 0C 37 2B D1 83 FA 0C 7F 04 8B F8 2B FE 8B C6 2B C5 83 F8 0C 7D 12 8B CC 8B D6 2B 53 08 03 D7 8B C5 E8 ?? ?? ?? ?? EB 0F 8B CC 8B D7 83 EA 04 8D 46 04 E8 ?? ?? ?? ?? 8B 2C 24 85 ED 75 04 33 C0 EB 30 8B D5 2B D6 8B C6 E8 ?? ?? ?? ?? 8B C5 03 44 24 04 8B 53 08 03 53 0C 3B C2 73 0A 8D 14 37 2B D0 E8 ?? ?? ?? ?? 8B D4 8B C3 E8 ?? ?? ?? ?? B0 01 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_110_0 {
	meta:
		name = "_NF__1D1"
		size = 126
		refs = "0024 _NV__1C5 005b _NF__1D0 0064 _NV__1C2"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 8B DF 89 73 08 8B C3 03 C6 83 E8 0C 89 70 08 81 FE 00 10 00 00 7F 30 8B D6 C1 EA 02 A1 ?? ?? ?? ?? 8B 44 90 F4 85 C0 75 10 A1 ?? ?? ?? ?? 89 5C 90 F4 89 5B 04 89 1B EB 3A 8B 10 89 43 04 89 13 89 18 89 5A 04 EB 2C 81 FE 00 3C 00 00 7C 0D 8B D6 8B C7 E8 ?? ?? ?? ?? 84 C0 75 17 A1 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 8B 10 89 43 04 89 13 89 18 89 5A 04 5F 5E 5B C3 }
	condition:
		$1
}

rule function_111_0 {
	meta:
		name = "_NF__1D2"
		size = 74
		refs = "0002 _NV__1C3 0014 _NV__1A4 0028 _NV__1C4 0037 _NF__1CC"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 7E 40 83 3D ?? ?? ?? ?? 0C 7D 0C C7 05 ?? ?? ?? ?? 07 00 00 00 EB 2B A1 ?? ?? ?? ?? 83 C8 02 8B 15 ?? ?? ?? ?? 89 02 A1 ?? ?? ?? ?? 83 C0 04 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_112_0 {
	meta:
		name = "_NF__1D3"
		size = 137
		refs = "0010 _NF__1D2 001b _NV__1C6 0020 _NF__1B0 0037 _NF__1CE 0050 _NF__1CF 0069 _NF__1CB 0074 _NV__1C4 007c _NV__1C3"
	strings:
		$1 = { 53 56 57 83 C4 F0 8B F0 8D 3C 24 A5 A5 8B FC E8 ?? ?? ?? ?? 8D 4C 24 08 8B D7 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5C 24 08 85 DB 75 04 33 C0 EB 52 8B 07 3B D8 73 0A E8 ?? ?? ?? ?? 29 07 01 47 04 8B 07 03 47 04 8B F3 03 74 24 0C 3B C6 73 08 E8 ?? ?? ?? ?? 01 47 04 8B 07 03 47 04 3B F0 75 11 83 E8 04 BA 04 00 00 00 E8 ?? ?? ?? ?? 83 6F 04 04 8B 07 A3 ?? ?? ?? ?? 8B 47 04 A3 ?? ?? ?? ?? B0 01 83 C4 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_113_0 {
	meta:
		name = "_NF__1D4"
		size = 43
		refs = "000c _NF__1B9 0019 _NF__1D3"
	strings:
		$1 = { 53 83 C4 F8 8B D8 8B D4 8D 43 04 E8 ?? ?? ?? ?? 83 3C 24 00 74 0B 8B C4 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 59 5A 5B C3 }
	condition:
		$1
}

rule function_114_0 {
	meta:
		name = "_NF__1D5"
		size = 49
		refs = "0011 _NF__1BA 001e _NF__1D3"
	strings:
		$1 = { 53 56 83 C4 F8 8B F2 8B D8 8B CC 8D 56 04 8B C3 E8 ?? ?? ?? ?? 83 3C 24 00 74 0B 8B C4 E8 ?? ?? ?? ?? 84 C0 75 04 33 C0 EB 02 B0 01 59 5A 5E 5B C3 }
	condition:
		$1
}

rule function_115_0 {
	meta:
		name = "_NF__1D6"
		size = 37
		refs = "000e _NV__1C5"
	strings:
		$1 = { 33 D2 C1 E8 02 3D 00 04 00 00 77 16 8B 15 ?? ?? ?? ?? 8B 54 82 F4 85 D2 75 08 40 3D 01 04 00 00 75 EA 8B C2 C3 }
	condition:
		$1
}

rule function_116_0 {
	meta:
		name = "_NF__1D7"
		size = 244
		refs = "0007 _NV__1C2 000c _NV__1C3 0012 _NV__1C1 004b _NF__1D6 0058 _NF__1D4 007e _NV__1C4 0094 AllocMemCount 009d AllocMemSize 00a6 _NF__1C9 00bc _NF__1D1"
	strings:
		$1 = { 53 56 57 55 8B F0 BF ?? ?? ?? ?? BD ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 3B 73 08 0F 8E 84 00 00 00 8B 1F 8B 43 08 3B F0 7E 7B 89 73 08 8B 5B 04 3B 73 08 7F F8 8B 17 89 42 08 3B 1F 74 04 89 1F EB 63 81 FE 00 10 00 00 7F 0D 8B C6 E8 ?? ?? ?? ?? 8B D8 85 DB 75 4E 8B C6 E8 ?? ?? ?? ?? 84 C0 75 07 33 C0 E9 88 00 00 00 3B 75 00 7F A4 29 75 00 83 7D 00 0C 7D 08 03 75 00 33 C0 89 45 00 A1 ?? ?? ?? ?? 01 35 ?? ?? ?? ?? 8B D6 83 CA 02 89 10 83 C0 04 FF 05 ?? ?? ?? ?? 83 EE 04 01 35 ?? ?? ?? ?? EB 4C 8B C3 E8 ?? ?? ?? ?? 8B 53 08 8B C2 2B C6 83 F8 0C 7C 0C 8B D3 03 D6 92 E8 ?? ?? ?? ?? EB 12 8B F2 3B 1F 75 05 8B 43 04 89 07 8B C3 03 C6 83 20 FE 8B C3 8B D6 83 CA 02 89 10 83 C0 04 FF 05 ?? ?? ?? ?? 83 EE 04 01 35 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_117_0 {
	meta:
		name = "SysGetMem"
		size = 389
		refs = "000d _NV__1A3 0015 _NF__1C7 002b SysGetMem 0037 IsMultiThread 003f _NV__1A5 0044 _NF__19F 0072 _NV__1C5 00e0 AllocMemCount 00e9 AllocMemSize 00ee @TryFinallyExit 00f9 _NV__1C3 011c _NV__1C4 014c _NF__1D7 016f _NF__1A0 0175 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 8B D8 80 3D ?? ?? ?? ?? 00 75 13 E8 ?? ?? ?? ?? 84 C0 75 0A 33 C0 89 45 FC E9 54 01 00 00 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C3 07 83 E3 FC 83 FB 0C 7D 05 BB 0C 00 00 00 81 FB 00 10 00 00 0F 8F 93 00 00 00 8B C3 85 C0 79 03 83 C0 03 C1 F8 02 8B 15 ?? ?? ?? ?? 8B 54 82 F4 85 D2 74 79 8B F2 8B C6 03 C3 83 20 FE 8B 42 04 3B D0 75 1A 8B C3 85 C0 79 03 83 C0 03 C1 F8 02 8B 0D ?? ?? ?? ?? 33 FF 89 7C 81 F4 EB 26 8B CB 85 C9 79 03 83 C1 03 C1 F9 02 8B 3D ?? ?? ?? ?? 89 44 8F F4 8B 0A 89 4D F8 8B 4D F8 89 41 04 8B 4D F8 89 08 8B C6 8B 52 08 83 CA 02 89 10 83 C0 04 89 45 FC FF 05 ?? ?? ?? ?? 83 EB 04 01 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 84 00 00 00 3B 1D ?? ?? ?? ?? 7F 4A 29 1D ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 0C 7D 0D 03 1D ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 01 1D ?? ?? ?? ?? 8B D3 83 CA 02 89 10 83 C0 04 89 45 FC FF 05 ?? ?? ?? ?? 83 EB 04 01 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 32 8B C3 E8 ?? ?? ?? ?? 89 45 FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 8B 45 FC 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_118_0 {
	meta:
		name = "SysFreeMem"
		size = 418
		refs = "000c _NV__1A4 0012 _NV__1A3 001a _NF__1C7 003c SysFreeMem 0048 IsMultiThread 0050 _NV__1A5 0055 _NF__19F 0076 AllocMemCount 0086 AllocMemSize 00d0 _NF__1C9 00e2 _NV__1C4 00f0 _NV__1C3 0101 _NF__1D2 010b @TryFinallyExit 0165 _NF__1D1 018d _NF__1A0 0193 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B D8 33 C0 A3 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 75 1F E8 ?? ?? ?? ?? 84 C0 75 16 C7 05 ?? ?? ?? ?? 08 00 00 00 C7 45 FC 08 00 00 00 E9 61 01 00 00 33 C9 55 68 ?? ?? ?? ?? 64 FF 31 64 89 21 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F3 83 EE 04 8B 1E F6 C3 02 75 0F C7 05 ?? ?? ?? ?? 09 00 00 00 E9 F5 00 00 00 FF 0D ?? ?? ?? ?? 8B C3 25 FC FF FF 7F 83 E8 04 29 05 ?? ?? ?? ?? F6 C3 01 74 45 8B C6 83 E8 0C 8B 50 08 83 FA 0C 7C 08 F7 C2 03 00 00 80 74 0F C7 05 ?? ?? ?? ?? 0A 00 00 00 E9 B6 00 00 00 8B C6 2B C2 3B 50 08 74 0F C7 05 ?? ?? ?? ?? 0A 00 00 00 E9 9E 00 00 00 03 DA 8B F0 E8 ?? ?? ?? ?? 81 E3 FC FF FF 7F 8B C6 03 C3 8B F8 3B 3D ?? ?? ?? ?? 75 2C 29 1D ?? ?? ?? ?? 01 1D ?? ?? ?? ?? 81 3D ?? ?? ?? ?? 00 3C 00 00 7E 05 E8 ?? ?? ?? ?? 33 C0 89 45 FC E8 ?? ?? ?? ?? E9 85 00 00 00 8B 10 F6 C2 02 74 1C 81 E2 FC FF FF 7F 83 FA 04 7D 0C C7 05 ?? ?? ?? ?? 0B 00 00 00 EB 37 83 08 01 EB 29 8B C7 83 78 04 00 74 0B 83 38 00 74 06 83 78 08 0C 7D 0C C7 05 ?? ?? ?? ?? 0B 00 00 00 EB 13 8B 50 08 03 DA E8 ?? ?? ?? ?? 8B D3 8B C6 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 8B 45 FC 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_119_0 {
	meta:
		name = "_NF__1DC"
		size = 463
		refs = "003e _NV__1C4 0052 _NV__1C3 008c _NF__1C9 00a8 _NF__1CC 010e AllocMemSize 0127 _NF__1D2 016f _NF__1D1 019a _NF__1D5"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B F2 83 C6 07 83 E6 FC 83 FE 0C 7D 05 BE 0C 00 00 00 8B E8 83 ED 04 8B 7D 00 81 E7 FC FF FF 7F 8B C5 03 C7 8B D8 3B FE 0F 82 83 00 00 00 8B D7 2B D6 89 14 24 3B 1D ?? ?? ?? ?? 75 38 8B 04 24 29 05 ?? ?? ?? ?? 8B 04 24 01 05 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 0C 0F 8D 4C 01 00 00 8B 04 24 01 05 ?? ?? ?? ?? 8B 04 24 29 05 ?? ?? ?? ?? 8B F7 E9 33 01 00 00 8B D8 F6 03 02 75 0D 8B C3 8B 50 08 01 14 24 E8 ?? ?? ?? ?? 83 3C 24 0C 7C 1B 8B DD 03 DE 8B 04 24 83 C8 02 89 03 8B C3 83 C0 04 E8 ?? ?? ?? ?? E9 FE 00 00 00 8B F7 E9 F7 00 00 00 8B C6 2B C7 89 44 24 04 3B 1D ?? ?? ?? ?? 75 67 A1 ?? ?? ?? ?? 3B 44 24 04 7C 53 8B 44 24 04 29 05 ?? ?? ?? ?? 8B 44 24 04 01 05 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 0C 7D 18 A1 ?? ?? ?? ?? 01 05 ?? ?? ?? ?? 03 35 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 8B C6 2B C7 01 05 ?? ?? ?? ?? 8B 45 00 25 03 00 00 80 0B F0 89 75 00 B0 01 E9 A2 00 00 00 E8 ?? ?? ?? ?? 8B DD 03 DF F6 03 02 75 4D 8B D3 8B C2 8B 48 08 89 0C 24 8B 0C 24 3B 4C 24 04 73 0E 03 14 24 8B DA 8B 04 24 29 44 24 04 EB 2C E8 ?? ?? ?? ?? 8B 44 24 04 29 04 24 83 3C 24 0C 7C 0E 8B C5 03 C6 8B 14 24 E8 ?? ?? ?? ?? EB 3A 03 34 24 8B DD 03 DE 83 23 FE EB 2E 8B 03 A9 00 00 00 80 74 21 25 FC FF FF 7F 03 C3 8B D8 8B 54 24 04 8B C3 E8 ?? ?? ?? ?? 84 C0 74 09 8B DD 03 DF E9 0D FF FF FF 33 C0 EB 19 8B C6 2B C7 01 05 ?? ?? ?? ?? 8B 45 00 25 03 00 00 80 0B F0 89 75 00 B0 01 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_120_0 {
	meta:
		name = "SysReallocMem"
		size = 193
		refs = "000d _NV__1A3 0015 _NF__1C7 002b SysReallocMem 0037 IsMultiThread 003f _NV__1A5 0044 _NF__19F 004d _NF__1DC 005d SysGetMem 0082 Move 0089 SysFreeMem 00ac _NF__1A0 00b2 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B F2 8B D8 80 3D ?? ?? ?? ?? 00 75 13 E8 ?? ?? ?? ?? 84 C0 75 0A 33 C0 89 45 FC E9 91 00 00 00 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D6 8B C3 E8 ?? ?? ?? ?? 84 C0 74 05 89 5D FC EB 36 8B C6 E8 ?? ?? ?? ?? 8B F8 8B C3 83 E8 04 8B 00 25 FC FF FF 7F 83 E8 04 3B F0 7D 02 8B C6 85 FF 74 11 8B D7 8B CB 91 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 89 7D FC 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 8B 45 FC 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_121_0 {
	meta:
		name = "_NF__1E0"
		size = 20
	strings:
		$1 = { 33 C9 8B 10 3B C2 74 09 03 4A 0C 8B 12 3B C2 75 F7 8B C1 C3 }
	condition:
		$1
}

rule function_122_0 {
	meta:
		name = "GetHeapStatus"
		size = 652
		refs = "000d _NV__1A4 0044 _NV__1A3 0053 GetHeapStatus 005f IsMultiThread 0067 _NV__1A5 006c _NF__19F 0071 _NV__1B2 0076 _NF__1E0 007d _NV__1B8 008a _NV__1C6 009e _NV__1C5 00eb _NV__1C1 0122 _NV__1C3 016e _NV__1C4 027a _NF__1A0 0280 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 8B F0 33 C0 A3 ?? ?? ?? ?? 33 C0 89 06 33 C0 89 46 04 33 C0 89 46 08 33 C0 89 46 0C 33 C0 89 46 10 33 C0 89 46 14 33 C0 89 46 18 33 C0 89 46 1C 33 C0 89 46 20 33 C0 89 46 24 80 3D ?? ?? ?? ?? 00 0F 84 37 02 00 00 33 DB 55 68 ?? ?? ?? ?? 64 FF 33 64 89 23 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 06 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 46 08 33 C9 BA 03 00 00 00 A1 ?? ?? ?? ?? 8B 44 90 F4 85 C0 74 32 03 48 08 8B 18 3B 43 04 75 0D 8B 58 04 3B 03 75 06 83 78 08 0C 7D 0C C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 0F 8B 40 04 8B 1D ?? ?? ?? ?? 3B 44 93 F4 75 CE 42 81 FA 01 04 00 00 75 B8 89 4E 14 33 C9 A1 ?? ?? ?? ?? EB 26 8B 10 3B 42 04 75 0D 8B 50 04 3B 02 75 06 83 78 08 0C 7D 0C C7 05 ?? ?? ?? ?? 0C 00 00 00 EB 0D 03 48 08 8B 40 04 3D ?? ?? ?? ?? 75 D3 89 4E 18 A1 ?? ?? ?? ?? 89 46 1C 8B 56 14 03 56 18 03 D0 89 56 10 33 C0 89 45 FC 33 C0 89 45 F8 33 C0 89 46 20 A1 ?? ?? ?? ?? 89 45 F0 33 C0 E9 DE 00 00 00 8B 55 F0 8B 52 08 8B 4D F0 8B 49 0C 03 CA 89 4D F4 3B 55 F4 0F 83 BC 00 00 00 3B 15 ?? ?? ?? ?? 75 27 83 3D ?? ?? ?? ?? 00 7E 1E 8B 0D ?? ?? ?? ?? 01 4D FC 84 C0 74 0A C7 05 ?? ?? ?? ?? 07 00 00 00 33 C0 E9 82 00 00 00 8B CA F6 01 01 0F 95 C3 3A C3 74 0A C7 05 ?? ?? ?? ?? 0B 00 00 00 8B 01 A8 02 75 2A 8B C1 8B 08 3B 41 04 75 0D 8B 48 04 3B 01 75 06 83 78 08 0C 7D 0A C7 05 ?? ?? ?? ?? 0D 00 00 00 8B 48 08 01 4D FC B0 01 EB 3C 8B C8 81 E1 FC FF FF 7F A9 00 00 00 80 74 1F 01 4E 20 8B 45 F0 3B 50 08 76 20 8D 04 11 3B 45 F4 73 18 C7 05 ?? ?? ?? ?? 09 00 00 00 EB 0C 8B C1 83 E8 04 01 45 F8 83 46 20 04 33 C0 03 D1 3B 55 F4 0F 82 44 FF FF FF 8B 55 F0 8B 12 89 55 F0 BA ?? ?? ?? ?? 3B 55 F0 0F 85 14 FF FF FF 8B 46 10 3B 45 FC 74 0A C7 05 ?? ?? ?? ?? 0E 00 00 00 8B 45 F8 89 46 0C A1 ?? ?? ?? ?? 89 46 24 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB E5 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_123_0 {
	meta:
		name = "@GetMem"
		size = 23
		refs = "0006 _NV__1E2 0012 _NF__1EB"
	strings:
		$1 = { 85 C0 74 0A FF 15 ?? ?? ?? ?? 09 C0 74 01 C3 B0 01 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_124_0 {
	meta:
		name = "@FreeMem"
		size = 23
		refs = "0006 _NV__1E2 0012 _NF__1EB"
	strings:
		$1 = { 85 C0 74 0A FF 15 ?? ?? ?? ?? 09 C0 75 01 C3 B0 02 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_125_0 {
	meta:
		name = "@ReallocMem"
		size = 77
		refs = "000f _NV__1E2 001e _NF__1EB"
	strings:
		$1 = { 8B 08 85 C9 74 32 85 D2 74 18 50 89 C8 FF 15 ?? ?? ?? ?? 59 09 C0 74 19 89 01 C3 B0 02 E9 ?? ?? ?? ?? 89 10 89 C8 FF 15 ?? ?? ?? ?? 09 C0 75 EB C3 B0 01 E9 ?? ?? ?? ?? 85 D2 74 10 50 89 D0 FF 15 ?? ?? ?? ?? 59 09 C0 74 E7 89 01 C3 }
	condition:
		$1
}

rule function_126_0 {
	meta:
		name = "GetMemoryManager"
		size = 27
		refs = "0002 _NV__1E2"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 89 10 8B 15 ?? ?? ?? ?? 89 50 04 8B 15 ?? ?? ?? ?? 89 50 08 C3 }
	condition:
		$1
}

rule function_127_0 {
	meta:
		name = "SetMemoryManager"
		size = 27
		refs = "0004 _NV__1E2"
	strings:
		$1 = { 8B 10 89 15 ?? ?? ?? ?? 8B 50 04 89 15 ?? ?? ?? ?? 8B 50 08 89 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_128_0 {
	meta:
		name = "IsMemoryManagerSet"
		size = 45
		refs = "0001 SysGetMem 0007 _NV__1E2 000e SysFreeMem 001b SysReallocMem"
	strings:
		$1 = { B8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 1D B8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 10 B8 ?? ?? ?? ?? 3B 05 ?? ?? ?? ?? 75 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_129_0 {
	meta:
		name = "_NF__1EB"
		size = 66
		refs = "0005 ErrorProc 0013 _NF__1EB 001a @GetTls 0020 InOutRes 0025 @RunError"
	strings:
		$1 = { 83 E0 7F 8B 0D ?? ?? ?? ?? 85 C9 74 03 5A FF D1 48 8A 80 ?? ?? ?? ?? 79 0B E8 ?? ?? ?? ?? 8B 80 ?? ?? ?? ?? E9 ?? ?? ?? ?? CB CC C8 C9 D7 CF C8 CD CE DB D8 CA D9 DA DC DD DE DF E0 E1 E3 00 E4 E5 C3 }
	condition:
		$1
}

rule function_130_0 {
	meta:
		name = "@_IOTest"
		size = 29
		refs = "0004 @GetTls 000a InOutRes 0018 _NF__1EB"
	strings:
		$1 = { 50 52 51 E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 59 5A 58 75 01 C3 31 C0 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_131_0 {
	meta:
		name = "_NF__1ED"
		size = 13
		refs = "0002 @GetTls 0008 InOutRes"
	strings:
		$1 = { 50 E8 ?? ?? ?? ?? 8F 80 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_133_0 {
	meta:
		name = "@ChDir"
		size = 28
		refs = "0006 @LStrToPChar 000c _NF__184 0016 _NF__1EE"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 75 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_149_0 {
	meta:
		name = "@RmDir"
		size = 28
		refs = "0006 @LStrToPChar 000c _NF__183 0016 _NF__1EE"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 75 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_134_0 {
	meta:
		name = "@Copy"
		size = 65
	strings:
		$1 = { 56 57 89 C6 8B 7C 24 0C 31 C0 0A 06 74 2B 85 D2 7E 18 39 C2 7F 1B 29 D0 40 85 C9 7C 14 39 C1 7F 14 01 D6 88 0F 47 F3 A4 EB 11 BA 01 00 00 00 EB E5 31 C9 EB EC 89 C1 EB E8 88 07 5F 5E C2 04 00 C3 }
	condition:
		$1
}

rule function_135_0 {
	meta:
		name = "@Delete"
		size = 45
	strings:
		$1 = { 56 57 89 C7 31 C0 8A 07 85 D2 7E 1E 39 C2 7F 1A 85 C9 7E 16 29 D0 40 39 C1 7E 02 89 C1 28 0F 01 D7 8D 34 0F 29 C8 89 C1 F3 A4 5F 5E C3 }
	condition:
		$1
}

rule function_136_0 {
	meta:
		name = "@LGetDir"
		size = 118
		refs = "0033 _NF__175 0039 _NF__184 0069 @LStrFromArray"
	strings:
		$1 = { 53 56 81 C4 F4 FD FF FF 8B F2 8B D8 84 DB 74 2D 33 C0 8A C3 83 C0 41 48 88 04 24 C6 44 24 01 3A C6 44 24 02 00 8D 84 24 08 01 00 00 50 68 04 01 00 00 E8 ?? ?? ?? ?? 54 E8 ?? ?? ?? ?? 8D 44 24 04 50 68 04 01 00 00 E8 ?? ?? ?? ?? 84 DB 74 0D 8D 84 24 08 01 00 00 50 E8 ?? ?? ?? ?? 8B C6 8D 54 24 04 B9 04 01 00 00 E8 ?? ?? ?? ?? 81 C4 0C 02 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_137_0 {
	meta:
		name = "@SGetDir"
		size = 116
		refs = "0018 @SGetDir 002b @LGetDir 003e @LStrToString 004d @PStrNCpy 0062 @LStrClr 0068 @HandleFinally"
	strings:
		$1 = { 55 8B EC 81 C4 FC FE FF FF 53 56 33 DB 89 5D FC 8B F1 8B DA 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8D 55 FC 25 FF 00 00 00 E8 ?? ?? ?? ?? 8D 85 FC FE FF FF 8B 55 FC B9 FF 00 00 00 E8 ?? ?? ?? ?? 8D 95 FC FE FF FF 8B C3 8B CE E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_138_0 {
	meta:
		name = "@Insert"
		size = 102
	strings:
		$1 = { 53 56 57 51 8B 4C 24 14 81 EC 00 02 00 00 89 D3 89 D6 31 D2 8A 16 46 42 85 C9 7E 32 39 D1 7F 35 4A 89 E7 49 29 CA F3 A4 96 8A 0E 46 F3 A4 89 C6 89 D1 F3 A4 29 E7 8B 8C 24 00 02 00 00 39 F9 72 02 89 F9 89 DF 89 E6 88 0F 47 F3 A4 EB 0B B9 01 00 00 00 EB CB 89 D1 EB C7 81 C4 04 02 00 00 5F 5E 5B C2 04 00 C3 }
	condition:
		$1
}

rule function_139_0 {
	meta:
		name = "IOResult"
		size = 22
		refs = "0001 @GetTls 0009 InOutRes"
	strings:
		$1 = { E8 ?? ?? ?? ?? 31 D2 8B 88 ?? ?? ?? ?? 89 90 ?? ?? ?? ?? 89 C8 C3 }
	condition:
		$1
}

rule function_140_0 {
	meta:
		name = "@MkDir"
		size = 30
		refs = "0008 @LStrToPChar 000e _NF__172 0018 _NF__1EE"
	strings:
		$1 = { 53 8B D8 6A 00 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 66 85 C0 75 05 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_141_0 {
	meta:
		name = "Move"
		size = 64
	strings:
		$1 = { 56 57 89 C6 89 D7 89 C8 39 F7 7F 13 74 2F C1 F9 02 78 2A F3 A5 89 C1 83 E1 03 F3 A4 5F 5E C3 8D 74 0E FC 8D 7C 0F FC C1 F9 02 78 11 FD F3 A5 89 C1 83 E1 03 83 C6 03 83 C7 03 F3 A4 FC 5F 5E C3 }
	condition:
		$1
}

rule function_142_0 {
	meta:
		name = "_NF__202"
		size = 106
		refs = "005b @LStrFromPCharLen"
	strings:
		$1 = { 53 56 81 C4 00 FF FF FF 8B D8 EB 01 43 8A 03 84 C0 74 04 3C 20 76 F5 80 3B 22 75 0B 80 7B 01 22 75 05 83 C3 02 EB E6 33 F6 EB 23 3C 22 75 1A 43 EB 05 88 04 34 46 43 8A 03 84 C0 74 04 3C 22 75 F1 80 3B 00 74 08 43 EB 05 88 04 34 46 43 8A 03 3C 20 77 D7 8B C2 8B D4 8B CE E8 ?? ?? ?? ?? 8B C3 81 C4 00 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_143_0 {
	meta:
		name = "ParamCount"
		size = 95
		refs = "000b ParamCount 0016 _NF__174 001e _NF__202 004c @LStrClr 0052 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 8D 55 FC E8 ?? ?? ?? ?? 8B D8 33 F6 8D 55 FC 8B C3 E8 ?? ?? ?? ?? 8B D8 83 7D FC 00 74 03 46 EB EB 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C6 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_144_0 {
	meta:
		name = "ParamStr"
		size = 87
		refs = "001e _NF__178 0029 @LStrFromPCharLen 0030 _NF__174 003b _NF__202"
	strings:
		$1 = { 53 56 57 81 C4 F8 FE FF FF 8B F2 8B D8 85 DB 75 1E 68 05 01 00 00 8D 44 24 04 50 6A 00 E8 ?? ?? ?? ?? 8B C8 8B D4 8B C6 E8 ?? ?? ?? ?? EB 1E E8 ?? ?? ?? ?? 8B F8 8B D6 8B C7 E8 ?? ?? ?? ?? 8B F8 85 DB 74 08 83 3E 00 74 03 4B EB E9 81 C4 08 01 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_145_0 {
	meta:
		name = "@Pos"
		size = 62
	strings:
		$1 = { 53 56 57 89 C6 89 D7 31 C9 8A 0F 47 57 31 D2 8A 16 46 4A 78 1B 8A 06 46 29 D1 7E 14 F2 AE 75 10 89 CB 56 57 89 D1 F3 A6 5F 5E 74 09 89 D9 EB EC 5A 31 C0 EB 05 5A 89 F8 29 D0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_147_0 {
	meta:
		name = "@SetString"
		size = 14
		refs = "0009 Move"
	strings:
		$1 = { 88 08 85 D2 74 07 92 42 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_148_0 {
	meta:
		name = "Randomize"
		size = 59
		refs = "000b _NF__164 0033 RandSeed"
	strings:
		$1 = { 55 8B EC 83 C4 E8 8D 45 E8 50 E8 ?? ?? ?? ?? 0F B7 45 F0 6B C0 3C 66 03 45 F2 6B C0 3C 31 D2 66 8B 55 F4 01 D0 69 C0 E8 03 00 00 66 8B 55 F6 01 D0 89 05 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule function_150_0 {
	meta:
		name = "UpCase"
		size = 14
	strings:
		$1 = { 80 F8 61 72 08 80 F8 7A 77 03 80 E8 20 C3 }
	condition:
		$1
}

rule function_151_0 {
	meta:
		name = "Set8087CW"
		size = 14
		refs = "0003 Default8087CW"
	strings:
		$1 = { 66 89 05 ?? ?? ?? ?? D9 2D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_152_0 {
	meta:
		name = "@COS"
		size = 13
	strings:
		$1 = { D9 FF DF E0 9E 7A 01 C3 DD D8 D9 EE C3 }
	condition:
		$1
}

rule function_153_0 {
	meta:
		name = "@EXP"
		size = 23
	strings:
		$1 = { D9 EA DE C9 D9 C0 D9 FC DC E9 D9 C9 D9 F0 D9 E8 DE C1 D9 FD DD D9 C3 }
	condition:
		$1
}

rule function_154_0 {
	meta:
		name = "@INT"
		size = 24
		refs = "000a _NV__211"
	strings:
		$1 = { 83 EC 04 9B D9 3C 24 9B D9 2D ?? ?? ?? ?? D9 FC 9B D9 2C 24 83 C4 04 C3 }
	condition:
		$1
}

rule function_155_0 {
	meta:
		name = "@SIN"
		size = 13
	strings:
		$1 = { D9 FE DF E0 9E 7A 01 C3 DD D8 D9 EE C3 }
	condition:
		$1
}

rule function_156_0 {
	meta:
		name = "@FRAC"
		size = 28
		refs = "000c _NV__211"
	strings:
		$1 = { D9 C0 83 EC 04 9B D9 3C 24 9B D9 2D ?? ?? ?? ?? D9 FC 9B D9 2C 24 83 C4 04 DE E9 C3 }
	condition:
		$1
}

rule function_157_0 {
	meta:
		name = "@ROUND"
		size = 7
	strings:
		$1 = { 50 DB 1C 24 9B 58 C3 }
	condition:
		$1
}

rule function_158_0 {
	meta:
		name = "@TRUNC"
		size = 27
		refs = "000a _NV__211"
	strings:
		$1 = { 83 EC 08 9B D9 3C 24 9B D9 2D ?? ?? ?? ?? DB 5C 24 04 9B D9 2C 24 83 C4 04 58 C3 }
	condition:
		$1
}

rule function_159_0 {
	meta:
		name = "@AbstractError"
		size = 26
		refs = "0002 AbstractErrorProc 0015 @RunError"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 06 FF 15 ?? ?? ?? ?? B8 D2 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_160_0 {
	meta:
		name = "@PStrCat"
		size = 40
	strings:
		$1 = { 56 57 89 C7 31 C0 8A 07 89 D6 31 C9 8A 0E 46 88 C2 00 CA 72 0A 88 17 47 01 C7 F3 A4 5F 5E C3 FE C2 28 D1 B2 FF EB EE C3 }
	condition:
		$1
}

rule function_161_0 {
	meta:
		name = "@PStrNCat"
		size = 48
	strings:
		$1 = { 56 57 89 C7 31 C0 8A 07 89 D6 31 D2 8A 16 46 00 D0 72 12 38 C8 77 0E 89 D1 8A 17 88 07 47 01 D7 F3 A4 5F 5E C3 88 C8 2A 0F 76 F7 88 CA EB E8 C3 }
	condition:
		$1
}

rule function_162_0 {
	meta:
		name = "@PStrCpy"
		size = 28
	strings:
		$1 = { 31 C9 56 57 8A 0A 89 C7 41 89 D6 89 C8 C1 E9 02 83 E0 03 F3 A5 89 C1 F3 A4 5F 5E C3 }
	condition:
		$1
}

rule function_163_0 {
	meta:
		name = "@PStrNCpy"
		size = 47
	strings:
		$1 = { 56 57 89 C7 31 C0 89 D6 8A 02 38 C8 77 12 40 89 C1 83 E0 03 C1 E9 02 F3 A5 89 C1 F3 A4 5F 5E C3 88 0F 46 47 81 E1 FF 00 00 00 F3 A4 5F 5E C3 }
	condition:
		$1
}

rule function_164_0 {
	meta:
		name = "@PStrCmp"
		size = 130
	strings:
		$1 = { 53 56 57 89 C6 89 D7 31 C0 31 D2 8A 06 8A 17 46 47 29 D0 77 02 01 C2 52 C1 EA 02 74 26 8B 0E 8B 1F 39 D9 75 44 4A 74 15 8B 4E 04 8B 5F 04 39 D9 75 37 83 C6 08 83 C7 08 4A 75 E2 EB 06 83 C6 04 83 C7 04 5A 83 E2 03 74 1C 8A 0E 3A 0F 75 2F 4A 74 13 8A 4E 01 3A 4F 01 75 24 4A 74 08 8A 4E 02 3A 4F 02 75 19 01 C0 EB 15 5A 38 D9 75 10 38 FD 75 0C C1 E9 10 C1 EB 10 38 D9 75 02 38 FD 5F 5E 5B C3 }
	condition:
		$1
}

rule function_165_0 {
	meta:
		name = "@AStrCmp"
		size = 111
	strings:
		$1 = { 53 56 51 89 CE C1 EE 02 74 26 8B 08 8B 1A 39 D9 75 45 4E 74 15 8B 48 04 8B 5A 04 39 D9 75 38 83 C0 08 83 C2 08 4E 75 E2 EB 06 83 C0 04 83 C2 04 5E 83 E6 03 74 36 8A 08 3A 0A 75 30 4E 74 13 8A 48 01 3A 4A 01 75 25 4E 74 08 8A 48 02 3A 4A 02 75 1A 31 C0 5E 5B C3 5E 38 D9 75 10 38 FD 75 0C C1 E9 10 C1 EB 10 38 D9 75 02 38 FD 5E 5B C3 }
	condition:
		$1
}

rule function_166_0 {
	meta:
		name = "@FillChar"
		size = 31
	strings:
		$1 = { 57 89 C7 88 CD 89 C8 C1 E0 10 66 89 C8 89 D1 C1 F9 02 78 09 F3 AB 89 D1 83 E1 03 F3 AA 5F C3 }
	condition:
		$1
}

rule function_167_0 {
	meta:
		name = "@Mark"
		size = 8
		refs = "0003 _NF__1EB"
		altNames = "@Release"
	strings:
		$1 = { B0 02 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_168_0 {
	meta:
		name = "@RandInt"
		size = 22
		refs = "0002 RandSeed"
	strings:
		$1 = { 69 15 ?? ?? ?? ?? 05 84 08 08 42 89 15 ?? ?? ?? ?? F7 E2 89 D0 C3 }
	condition:
		$1
}

rule function_169_0 {
	meta:
		name = "@RandExt"
		size = 37
		refs = "0002 RandSeed 0013 _NV__223"
	strings:
		$1 = { 69 15 ?? ?? ?? ?? 05 84 08 08 42 89 15 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 6A 00 52 DF 2C 24 83 C4 08 D9 FD DD D9 C3 }
	condition:
		$1
}

rule function_171_0 {
	meta:
		name = "@StrLong"
		size = 95
	strings:
		$1 = { 53 56 57 52 83 EC 14 89 CF 89 C6 99 31 D0 29 D0 B9 0A 00 00 00 31 DB 31 D2 F7 F1 83 C2 30 88 14 1C 43 85 C0 75 F1 85 F6 7D 05 C6 04 1C 2D 43 88 1F 47 8B 4C 24 14 81 F9 FF 00 00 00 7E 05 B9 FF 00 00 00 29 D9 7E 07 00 4F FF B0 20 F3 AA 8A 44 1C FF 88 07 47 4B 75 F6 83 C4 18 5F 5E 5B C3 }
	condition:
		$1
}

rule function_172_0 {
	meta:
		name = "@Str0Long"
		size = 10
		refs = "0005 @StrLong"
	strings:
		$1 = { 89 D1 31 D2 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_173_0 {
	meta:
		name = "@ValLong"
		size = 168
	strings:
		$1 = { 53 56 57 89 C6 50 85 C0 74 51 31 C0 31 DB BF CC CC CC 0C 8A 1E 46 80 FB 20 74 F8 B5 00 80 FB 2D 74 45 80 FB 2B 74 42 80 FB 24 74 42 84 DB 74 32 80 EB 30 80 FB 09 77 2A 39 F8 77 26 8D 04 80 01 C0 01 D8 8A 1E 46 84 DB 75 E6 FE CD 74 10 85 C0 7C 10 59 31 F6 89 32 5F 5E 5B C3 46 EB 04 F7 D8 7E F0 5B 29 DE EB EE FE C5 8A 1E 46 EB BE BF FF FF FF 0F 8A 1E 46 84 DB 74 E1 80 FB 61 72 03 80 EB 20 80 EB 30 80 FB 09 76 0B 80 EB 11 80 FB 05 77 D0 80 C3 0A 39 F8 77 C9 C1 E0 04 01 D8 8A 1E 46 84 DB 75 D5 EB AB C3 }
	condition:
		$1
}

rule function_174_0 {
	meta:
		name = "@WriteBool"
		size = 36
		refs = "0005 @WriteBool 000a @WriteString"
	strings:
		$1 = { 84 D2 74 0A BA ?? ?? ?? ?? E9 ?? ?? ?? ?? BA ?? ?? ?? ?? E9 ?? ?? ?? ?? 04 54 52 55 45 05 46 41 4C 53 45 C3 }
	condition:
		$1
}

rule function_175_0 {
	meta:
		name = "@Write0Bool"
		size = 8
		refs = "0003 @WriteBool"
	strings:
		$1 = { 31 C9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_305_0 {
	meta:
		name = "@Write0LString"
		size = 8
		refs = "0003 @WriteLString"
	strings:
		$1 = { 31 C9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_177_0 {
	meta:
		name = "@Write0Long"
		size = 8
		refs = "0003 @WriteLong"
	strings:
		$1 = { 31 C9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_176_0 {
	meta:
		name = "@WriteLong"
		size = 38
		refs = "0015 @StrLong 001e @WriteString"
	strings:
		$1 = { 83 EC 20 50 51 89 D0 31 D2 83 F9 1F 7F 02 89 CA 8D 4C 24 08 E8 ?? ?? ?? ?? 59 58 89 E2 E8 ?? ?? ?? ?? 83 C4 20 C3 }
	condition:
		$1
}

rule function_178_0 {
	meta:
		name = "@Write2Ext"
		size = 50
		refs = "001b @Str2Ext 0024 @WriteString"
	strings:
		$1 = { DB 6C 24 04 81 EC 00 01 00 00 50 52 83 EC 0C DB 3C 24 89 D0 89 CA 8D 4C 24 14 E8 ?? ?? ?? ?? 59 58 89 E2 E8 ?? ?? ?? ?? 81 C4 00 01 00 00 C2 0C 00 C3 }
	condition:
		$1
}

rule function_179_0 {
	meta:
		name = "@Write1Ext"
		size = 9
		refs = "0004 @Write2Ext"
	strings:
		$1 = { 83 C9 FF E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_180_0 {
	meta:
		name = "@Write0Ext"
		size = 14
		refs = "0009 @Write2Ext"
	strings:
		$1 = { BA 17 00 00 00 83 C9 FF E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_181_0 {
	meta:
		name = "@_CToPasStr"
		size = 23
	strings:
		$1 = { 50 B1 FF 8A 2A 42 84 ED 74 07 40 88 28 FE C9 75 F2 5A 29 D0 88 02 C3 }
	condition:
		$1
}

rule function_182_0 {
	meta:
		name = "@_CLenToPasStr"
		size = 35
	strings:
		$1 = { 53 50 81 F9 FF 00 00 00 76 05 B9 FF 00 00 00 8A 1A 42 84 DB 74 06 40 88 18 49 75 F3 5A 29 D0 88 02 5B C3 }
	condition:
		$1
}

rule function_183_0 {
	meta:
		name = "@_ArrayToPasStr"
		size = 23
		refs = "0012 Move"
	strings:
		$1 = { 92 81 F9 FF 00 00 00 76 05 B9 FF 00 00 00 88 0A 42 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_184_0 {
	meta:
		name = "@_PasToCStr"
		size = 18
	strings:
		$1 = { 56 57 89 C6 89 D7 31 C9 8A 0E 46 F3 A4 88 0F 5F 5E C3 }
	condition:
		$1
}

rule function_185_0 {
	meta:
		name = "@SetElem"
		size = 34
	strings:
		$1 = { 53 57 89 C7 31 DB 88 CB 89 D9 31 C0 F3 AA 29 DF 40 88 D1 D2 C0 C1 E9 03 39 D9 73 03 08 04 0F 5F 5B C3 }
	condition:
		$1
}

rule function_186_0 {
	meta:
		name = "@SetRange"
		size = 86
	strings:
		$1 = { 53 56 57 31 DB 88 E3 0F B6 F0 0F B6 D2 89 CF 89 D9 31 C0 F3 AA 29 DF C1 E3 03 39 DA 72 03 8D 53 FF 39 D6 77 2D 48 89 F1 80 E1 07 D2 E0 C1 EE 03 88 D1 F6 D1 80 E1 07 D2 EC C1 EA 03 01 F7 89 D1 29 F1 75 06 20 E0 88 07 EB 08 AA 49 B0 FF F3 AA 88 27 5F 5E 5B C3 }
	condition:
		$1
}

rule function_187_0 {
	meta:
		name = "@SetEq"
		size = 17
	strings:
		$1 = { 56 57 89 C6 89 D7 81 E1 FF 00 00 00 F3 A6 5F 5E C3 }
	condition:
		$1
}

rule function_188_0 {
	meta:
		name = "@SetLe"
		size = 15
	strings:
		$1 = { 8A 2A F6 D5 22 28 75 06 42 40 FE C9 75 F2 C3 }
	condition:
		$1
}

rule function_189_0 {
	meta:
		name = "@SetIntersect"
		size = 11
	strings:
		$1 = { 8A 2A 42 20 28 40 FE C9 75 F6 C3 }
	condition:
		$1
}

rule function_190_0 {
	meta:
		name = "@SetUnion"
		size = 11
	strings:
		$1 = { 8A 2A 42 08 28 40 FE C9 75 F6 C3 }
	condition:
		$1
}

rule function_191_0 {
	meta:
		name = "@SetSub"
		size = 13
	strings:
		$1 = { 8A 2A F6 D5 42 20 28 40 FE C9 75 F4 C3 }
	condition:
		$1
}

rule function_192_0 {
	meta:
		name = "@SetExpand"
		size = 31
	strings:
		$1 = { 56 57 89 C6 89 D7 89 CA 31 C9 31 C0 88 D1 F3 AA 88 F1 28 D1 F3 A4 B1 20 28 F1 F3 AA 5F 5E C3 }
	condition:
		$1
}

rule function_193_0 {
	meta:
		name = "@ObjSetup"
		size = 71
		refs = "0015 _NV__1E2"
	strings:
		$1 = { 83 FA 01 73 01 C3 51 85 C0 75 2C 8B 42 F8 85 C0 74 1E 52 FF 15 ?? ?? ?? ?? 5A 85 C0 74 0E 8B 4A FC 85 C9 7C 03 89 14 08 85 C0 59 C3 31 D2 59 C3 31 D2 83 F8 01 59 C3 8B 4A FC 85 C9 7C 03 89 14 08 31 D2 85 C0 59 C3 }
	condition:
		$1
}

rule function_194_0 {
	meta:
		name = "@ObjCopy"
		size = 35
	strings:
		$1 = { 53 56 57 89 D6 89 C7 8D 04 0F 8B 10 8B 5A F8 89 D9 C1 E9 02 F3 A5 89 D9 83 E1 03 F3 A4 89 10 5F 5E 5B C3 }
	condition:
		$1
}

rule function_195_0 {
	meta:
		name = "@Fail"
		size = 12
		refs = "0005 @FreeMem"
	strings:
		$1 = { 85 D2 74 05 E8 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule function_197_0 {
	meta:
		name = "_NF__240"
		size = 47
		refs = "0006 _NF__23F"
	strings:
		$1 = { 53 33 DB 6A 00 E8 ?? ?? ?? ?? 83 F8 07 75 1C 6A 01 E8 ?? ?? ?? ?? 25 00 FF 00 00 3D 00 0D 00 00 74 07 3D 00 04 00 00 75 02 B3 01 8B C3 5B C3 }
	condition:
		$1
}

rule function_198_0 {
	meta:
		name = "_NF__241"
		size = 196
		refs = "0009 Default8087CW 0019 _NF__241 0023 _NF__181 0056 _NF__182 006c _NF__180 0072 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F4 0F B7 05 ?? ?? ?? ?? 89 45 F8 8D 45 FC 50 6A 01 6A 00 68 ?? ?? ?? ?? 68 02 00 00 80 E8 ?? ?? ?? ?? 85 C0 75 4D 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 45 F4 04 00 00 00 8D 45 F4 50 8D 45 F8 50 6A 00 6A 00 68 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 66 A1 ?? ?? ?? ?? 66 25 C0 FF 66 8B 55 F8 66 83 E2 3F 66 0B C2 66 A3 ?? ?? ?? ?? 8B E5 5D C3 00 53 4F 46 54 57 41 52 45 5C 42 6F 72 6C 61 6E 64 5C 44 65 6C 70 68 69 5C 52 54 4C 00 46 50 55 4D 61 73 6B 56 61 6C 75 65 00 00 00 00 }
	condition:
		$1
}

rule function_199_0 {
	meta:
		name = "_NF__242"
		size = 10
		refs = "0005 Default8087CW"
	strings:
		$1 = { DB E3 9B D9 2D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_200_0 {
	meta:
		name = "@BoundErr"
		size = 8
		refs = "0003 _NF__1EB"
	strings:
		$1 = { B0 04 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_201_0 {
	meta:
		name = "@IntOver"
		size = 8
		refs = "0003 _NF__1EB"
	strings:
		$1 = { B0 05 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_203_0 {
	meta:
		name = "TObject.ClassName"
		size = 17
	strings:
		$1 = { 56 57 89 D7 8B 70 E0 31 C9 8A 0E 41 F3 A4 5F 5E C3 }
	condition:
		$1
}

rule function_204_0 {
	meta:
		name = "TObject.ClassNameIs"
		size = 39
	strings:
		$1 = { 53 31 DB 09 D2 74 1C 8B 40 E0 31 C9 8A 08 3B 4A FC 75 10 4A 8A 3C 08 32 3C 0A 80 E7 DF 75 04 49 75 F2 43 88 D8 5B C3 }
	condition:
		$1
}

rule function_205_0 {
	meta:
		name = "TObject.ClassParent"
		size = 10
	strings:
		$1 = { 8B 40 E8 85 C0 74 02 8B 00 C3 }
	condition:
		$1
}

rule function_206_0 {
	meta:
		name = "TObject.NewInstance"
		size = 18
		refs = "0005 @GetMem 000d TObject.InitInstance"
	strings:
		$1 = { 50 8B 40 E4 E8 ?? ?? ?? ?? 89 C2 58 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_207_0 {
	meta:
		name = "TObject.FreeInstance"
		size = 37
		refs = "0013 @FinalizeRecord 001e @FreeMem"
	strings:
		$1 = { 53 56 89 C3 89 C6 8B 36 8B 56 CC 8B 76 E8 85 D2 74 07 E8 ?? ?? ?? ?? 89 D8 85 F6 75 E9 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_208_0 {
	meta:
		name = "TObject.InstanceSize"
		size = 4
	strings:
		$1 = { 8B 40 E4 C3 }
	condition:
		$1
}

rule function_209_0 {
	meta:
		name = "TObject.Create"
		size = 27
		refs = "0008 @ClassCreate"
	strings:
		$1 = { 84 D2 74 08 83 C4 F0 E8 ?? ?? ?? ?? 84 D2 74 0A 64 8F 05 00 00 00 00 83 C4 0C C3 }
	condition:
		$1
}

rule function_210_0 {
	meta:
		name = "TObject.Destroy"
		size = 10
		refs = "0005 @ClassDestroy"
	strings:
		$1 = { 84 D2 74 05 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_211_0 {
	meta:
		name = "TObject.Free"
		size = 12
	strings:
		$1 = { 85 C0 74 07 8B 08 B2 01 FF 51 FC C3 }
	condition:
		$1
}

rule function_212_0 {
	meta:
		name = "TObject.InitInstance"
		size = 82
	strings:
		$1 = { 53 56 57 89 C3 89 D7 AB 8B 4B E4 31 C0 51 C1 E9 02 49 F3 AB 59 83 E1 03 F3 AA 89 D0 89 E2 8B 4B C4 85 C9 74 01 51 8B 5B E8 85 DB 74 04 8B 1B EB ED 39 D4 74 19 5B 8B 0B 83 C3 04 8B 73 10 8B 7B 14 89 34 38 83 C3 18 49 75 F1 39 D4 75 E7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_213_0 {
	meta:
		name = "TObject.CleanupInstance"
		size = 32
		refs = "0013 @FinalizeRecord"
	strings:
		$1 = { 53 56 89 C3 89 C6 8B 36 8B 56 CC 8B 76 E8 85 D2 74 07 E8 ?? ?? ?? ?? 89 D8 85 F6 75 E9 5E 5B C3 }
	condition:
		$1
}

rule function_214_0 {
	meta:
		name = "TObject.GetInterface"
		size = 44
		refs = "0009 TObject.GetInterfaceEntry"
	strings:
		$1 = { 53 56 8B F1 8B D8 8B 03 E8 ?? ?? ?? ?? 85 C0 74 12 03 58 14 89 1E 8B 06 50 8B 00 FF 50 04 B0 01 5E 5B C3 33 C0 89 06 33 C0 5E 5B C3 }
	condition:
		$1
}

rule function_215_0 {
	meta:
		name = "TObject.GetInterfaceEntry"
		size = 68
	strings:
		$1 = { 53 56 89 C3 8B 43 C4 85 C0 74 29 8B 08 83 C0 04 8B 32 3B 30 75 18 8B 72 04 3B 70 04 75 10 8B 72 08 3B 70 08 75 08 8B 72 0C 3B 70 0C 74 13 83 C0 18 49 75 DC 8B 5B E8 85 DB 74 04 8B 1B EB C5 31 C0 5E 5B C3 }
	condition:
		$1
}

rule function_216_0 {
	meta:
		name = "TObject.GetInterfaceTable"
		size = 4
	strings:
		$1 = { 8B 40 C4 C3 }
	condition:
		$1
}

rule function_217_0 {
	meta:
		name = "@IsClass"
		size = 21
	strings:
		$1 = { 85 C0 74 10 8B 00 39 D0 74 08 8B 40 E8 85 C0 75 F3 C3 B0 01 C3 }
	condition:
		$1
}

rule function_218_0 {
	meta:
		name = "@AsClass"
		size = 27
		refs = "0016 _NF__1EB"
	strings:
		$1 = { 85 C0 74 16 89 C1 8B 09 39 D1 74 0E 8B 49 E8 85 C9 75 F3 B0 0A E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_219_0 {
	meta:
		name = "_NF__26C"
		size = 46
	strings:
		$1 = { 57 93 EB 02 8B 1B 8B 7B DC 85 FF 74 0D 0F B7 0F 51 83 C7 02 66 F2 AF 74 0A 59 8B 5B E8 85 DB 75 E3 5F C3 58 01 C0 29 C8 8B 5C 47 FC 5F C3 }
	condition:
		$1
}

rule function_220_0 {
	meta:
		name = "@CallDynaInst"
		size = 22
		refs = "0005 _NF__26C 0011 @AbstractError"
	strings:
		$1 = { 50 51 8B 00 E8 ?? ?? ?? ?? 59 58 74 02 FF E3 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_221_0 {
	meta:
		name = "@CallDynaClass"
		size = 20
		refs = "0003 _NF__26C 000f @AbstractError"
	strings:
		$1 = { 50 51 E8 ?? ?? ?? ?? 59 58 74 02 FF E3 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_222_0 {
	meta:
		name = "@FindDynaInst"
		size = 22
		refs = "0006 _NF__26C 0011 @AbstractError"
	strings:
		$1 = { 53 89 D3 8B 00 E8 ?? ?? ?? ?? 89 D8 5B 75 06 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_223_0 {
	meta:
		name = "@FindDynaClass"
		size = 20
		refs = "0004 _NF__26C 000f @AbstractError"
	strings:
		$1 = { 53 89 D3 E8 ?? ?? ?? ?? 89 D8 5B 75 06 59 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_224_0 {
	meta:
		name = "TObject.InheritsFrom"
		size = 19
	strings:
		$1 = { EB 02 8B 00 39 D0 74 08 8B 40 E8 85 C0 75 F3 C3 B0 01 C3 }
	condition:
		$1
}

rule function_225_0 {
	meta:
		name = "TObject.ClassInfo"
		size = 4
	strings:
		$1 = { 8B 40 D0 C3 }
	condition:
		$1
}

rule function_226_0 {
	meta:
		name = "TObject.SafeCallException"
		size = 6
	strings:
		$1 = { B8 FF FF 00 80 C3 }
	condition:
		$1
}

rule function_228_0 {
	meta:
		name = "TObject.Dispatch"
		size = 39
		refs = "0014 _NF__26C"
	strings:
		$1 = { 53 66 8B 1A 66 09 DB 74 17 66 81 FB 00 C0 73 10 50 8B 00 E8 ?? ?? ?? ?? 58 74 05 89 D9 5B FF E1 5B 8B 08 FF 61 F0 C3 }
	condition:
		$1
}

rule function_229_0 {
	meta:
		name = "TObject.MethodAddress"
		size = 78
	strings:
		$1 = { 53 56 57 31 C9 31 FF 8A 1A EB 02 8B 00 8B 70 D8 85 F6 74 15 66 8B 3E 83 C6 02 8A 4E 06 38 D9 74 15 66 8B 0E 01 CE 4F 75 F1 8B 40 E8 85 C0 75 DB EB 18 8A 1A EB EB B5 00 8A 5C 0E 06 32 1C 0A 80 E3 DF 75 EE 49 75 F1 8B 46 02 5F 5E 5B C3 }
	condition:
		$1
}

rule function_230_0 {
	meta:
		name = "TObject.MethodName"
		size = 64
	strings:
		$1 = { 53 56 57 89 CF 31 DB 31 C9 EB 02 8B 00 8B 70 D8 85 F6 74 13 66 8B 0E 83 C6 02 3B 56 02 74 13 66 8B 1E 01 DE 49 75 F3 8B 40 E8 85 C0 75 DD 88 07 EB 0A 83 C6 06 31 C9 8A 0E 41 F3 A4 5F 5E 5B C3 }
	condition:
		$1
}

rule function_231_0 {
	meta:
		name = "TObject.FieldAddress"
		size = 80
	strings:
		$1 = { 53 56 57 31 C9 31 FF 8A 1A 50 8B 00 8B 70 D4 85 F6 74 14 66 8B 3E 83 C6 06 8A 4E 06 38 D9 74 18 8D 74 0E 07 4F 75 F2 8B 40 E8 85 C0 75 DC 5A EB 1B 8A 1A 8A 4E 06 EB E8 8A 5C 0E 06 32 1C 0A 80 E3 DF 75 ED 49 75 F1 8B 06 5A 01 D0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_232_0 {
	meta:
		name = "@ClassCreate"
		size = 60
		refs = "0017 @ClassCreate 0026 @HandleAnyException 0032 TObject.Free 0037 @RaiseAgain"
	strings:
		$1 = { 52 51 53 FF 50 F4 31 D2 8D 4C 24 10 64 8B 1A 89 19 89 69 08 C7 41 04 ?? ?? ?? ?? 89 41 0C 64 89 0A 5B 59 5A C3 E9 ?? ?? ?? ?? 8B 44 24 2C 8B 40 0C E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_233_0 {
	meta:
		name = "@ClassDestroy"
		size = 6
	strings:
		$1 = { 8B 10 FF 52 F8 C3 }
	condition:
		$1
}

rule function_234_0 {
	meta:
		name = "_NF__295"
		size = 26
		refs = "0002 DebugHook 0015 _NF__168"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 10 6A 00 6A 00 6A 00 68 DF FA ED 0E E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_235_0 {
	meta:
		name = "_NF__296"
		size = 32
		refs = "0002 DebugHook 0017 _NF__168"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 74 16 50 50 52 54 6A 02 6A 00 68 E4 FA ED 0E E8 ?? ?? ?? ?? 83 C4 08 58 C3 }
	condition:
		$1
}

rule function_236_0 {
	meta:
		name = "_NF__297"
		size = 20
		refs = "000b _NF__168"
	strings:
		$1 = { 54 6A 01 6A 00 68 E0 FA ED 0E E8 ?? ?? ?? ?? 83 C4 04 58 C3 }
	condition:
		$1
}

rule function_237_0 {
	meta:
		name = "_NF__298"
		size = 19
		refs = "0002 DebugHook 000e _NF__297"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 09 50 FF 73 04 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_238_0 {
	meta:
		name = "_NF__299"
		size = 17
		refs = "0002 DebugHook 000c _NF__297"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 07 50 53 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_239_0 {
	meta:
		name = "_NF__29A"
		size = 30
	strings:
		$1 = { 85 C9 74 19 8B 41 01 80 39 E9 74 0C 80 39 EB 75 0C 0F BE C0 41 41 EB 03 83 C1 05 01 C1 C3 }
	condition:
		$1
}

rule function_240_0 {
	meta:
		name = "_NF__29B"
		size = 38
		refs = "0002 DebugHook 000d _NF__29A 001d _NF__168"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 1C 50 52 51 E8 ?? ?? ?? ?? 51 54 6A 01 6A 00 68 E1 FA ED 0E E8 ?? ?? ?? ?? 59 59 5A 58 C3 }
	condition:
		$1
}

rule function_241_0 {
	meta:
		name = "_NF__29C"
		size = 27
		refs = "0002 DebugHook 0015 _NF__168"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 01 76 11 52 54 6A 01 6A 00 68 E2 FA ED 0E E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_242_0 {
	meta:
		name = "_NF__29D"
		size = 29
		refs = "0004 DebugHook 0016 _NF__168"
	strings:
		$1 = { 50 52 80 3D ?? ?? ?? ?? 01 76 0F 54 6A 02 6A 00 68 E3 FA ED 0E E8 ?? ?? ?? ?? 5A 58 C3 }
	condition:
		$1
}

rule function_243_0 {
	meta:
		name = "@HandleAnyException"
		size = 196
		refs = "0021 _NF__242 0027 ExceptObjProc 0042 _NF__296 0068 @HandleAnyException 006e _NF__16A 0077 @GetTls 007d RaiseList 0098 _NF__299 009f @HandleFinally 00ba TObject.Free"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 85 AD 00 00 00 81 38 DE FA ED 0E 8B 50 18 8B 48 14 74 30 FC E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 85 D2 0F 84 8B 00 00 00 FF D2 85 C0 0F 84 81 00 00 00 8B 54 24 0C E8 ?? ?? ?? ?? 89 C2 8B 44 24 04 8B 48 0C 83 48 04 02 53 31 DB 56 57 55 64 8B 1B 53 50 52 51 8B 54 24 28 6A 00 50 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 8B 7C 24 28 E8 ?? ?? ?? ?? FF B0 ?? ?? ?? ?? 89 A0 ?? ?? ?? ?? 8B 6F 08 8B 5F 04 C7 47 04 ?? ?? ?? ?? 83 C3 05 E8 ?? ?? ?? ?? FF E3 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 8B 11 89 90 ?? ?? ?? ?? 8B 41 08 E9 ?? ?? ?? ?? B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_244_0 {
	meta:
		name = "@HandleOnException"
		size = 309
		refs = "001b _NF__242 0021 ExceptClsProc 007b @AStrCmp 00ad ExceptObjProc 00b6 _NF__296 00d9 @HandleOnException 00df _NF__16A 00e9 @GetTls 00ef RaiseList 0108 _NF__298 0110 @HandleFinally 012b TObject.Free"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 0F 85 1E 01 00 00 81 38 DE FA ED 0E 74 1F FC E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 85 D2 0F 84 02 01 00 00 FF D2 85 C0 75 0A E9 F7 00 00 00 8B 40 18 8B 00 8B 54 24 08 53 56 57 55 8B 4A 04 8B 59 05 8D 71 09 89 C5 8B 06 85 C0 74 43 89 EF EB 02 8B 3F 8B 00 39 F8 74 37 8B 48 E4 3B 4F E4 75 17 8B 40 E0 8B 57 E0 31 C9 8A 08 3A 0A 75 09 40 42 E8 ?? ?? ?? ?? 74 18 8B 7F E8 8B 06 85 FF 75 D0 83 C6 08 4B 75 C0 5D 5F 5E 5B E9 96 00 00 00 8B 44 24 14 81 38 DE FA ED 0E 8B 50 18 8B 48 14 74 18 FF 15 ?? ?? ?? ?? 8B 54 24 1C E8 ?? ?? ?? ?? 89 C2 8B 44 24 14 8B 48 0C 31 DB 64 8B 1B 53 50 52 51 8B 54 24 28 83 48 04 02 56 6A 00 50 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 5B 8B 7C 24 28 E8 ?? ?? ?? ?? FF B0 ?? ?? ?? ?? 89 A0 ?? ?? ?? ?? 8B 6F 08 C7 47 04 ?? ?? ?? ?? 8B 44 24 08 E8 ?? ?? ?? ?? FF 63 04 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 88 ?? ?? ?? ?? 8B 11 89 90 ?? ?? ?? ?? 8B 41 08 E9 ?? ?? ?? ?? B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_245_0 {
	meta:
		name = "@HandleFinally"
		size = 54
		refs = "0017 @HandleFinally 0026 _NF__29B"
	strings:
		$1 = { 8B 44 24 04 8B 54 24 08 F7 40 04 06 00 00 00 74 1F 8B 4A 04 C7 42 04 ?? ?? ?? ?? 53 56 57 55 8B 6A 08 83 C1 05 E8 ?? ?? ?? ?? FF D1 5D 5F 5E 5B B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_246_0 {
	meta:
		name = "@HandleAutoException"
		size = 70
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 75 33 BB FF FF 00 80 81 38 DE FA ED 0E 75 14 8B 50 18 8B 48 14 8B 44 24 08 8B 40 0C 8B 18 FF 53 EC 89 C3 31 C0 8B 64 24 08 59 64 89 08 5A 5D 8D 52 05 59 FF E2 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_247_0 {
	meta:
		name = "@RaiseExcept"
		size = 25
		refs = "0014 _NF__168"
	strings:
		$1 = { 5A 54 55 57 56 53 50 52 54 6A 07 6A 01 68 DE FA ED 0E 52 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_248_0 {
	meta:
		name = "@RaiseAgain"
		size = 81
		refs = "0007 @RaiseAgain 000c @GetTls 0012 RaiseList 0031 TObject.Free 0036 _NF__295"
	strings:
		$1 = { 8B 44 24 30 C7 40 04 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 8B 0A 89 88 ?? ?? ?? ?? 8B 42 0C 83 60 04 FD 81 38 DE FA ED 0E 74 0D 8B 42 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 C0 83 C4 14 64 8B 10 59 8B 12 89 11 5D 5F 5E 5B B8 01 00 00 00 C3 }
	condition:
		$1
}

rule function_249_0 {
	meta:
		name = "@DoneExcept"
		size = 48
		refs = "0001 @GetTls 0007 RaiseList 0017 TObject.Free 0029 _NF__29C"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 90 ?? ?? ?? ?? 8B 0A 89 88 ?? ?? ?? ?? 8B 42 08 E8 ?? ?? ?? ?? 5A 8B 64 24 2C 31 C0 59 64 89 08 58 5D E8 ?? ?? ?? ?? FF E2 C3 }
	condition:
		$1
}

rule function_250_0 {
	meta:
		name = "@TryFinallyExit"
		size = 22
	strings:
		$1 = { 31 D2 8B 4C 24 08 8B 44 24 04 83 C1 05 64 89 02 FF D1 C2 0C 00 C3 }
	condition:
		$1
}

rule function_251_0 {
	meta:
		name = "_NF__2A9"
		size = 9
		refs = "0004 @RunError"
	strings:
		$1 = { 89 14 24 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_252_0 {
	meta:
		name = "_NF__2AA"
		size = 160
		refs = "0098 _NF__2A9"
	strings:
		$1 = { 55 8B EC 8B 55 08 8B 02 3D 92 00 00 C0 7F 2C 74 5C 3D 8E 00 00 C0 7F 15 74 57 2D 05 00 00 C0 74 5C 2D 87 00 00 00 74 3D 48 74 4E EB 60 05 71 FF FF 3F 83 E8 02 72 36 74 30 EB 52 3D 96 00 00 C0 7F 11 74 3D 2D 93 00 00 C0 74 2E 48 74 13 48 74 24 EB 3A 2D FD 00 00 C0 74 2F 83 E8 3D 74 26 EB 2C B0 C8 EB 2A B0 C9 EB 26 B0 CD EB 22 B0 CF EB 1E B0 C8 EB 1A B0 D7 EB 16 B0 CE EB 12 B0 D8 EB 0E B0 DA EB 0A B0 D9 EB 06 B0 CA EB 02 B0 FF 25 FF 00 00 00 8B 52 0C E8 ?? ?? ?? ?? 5D C2 04 00 }
	condition:
		$1
}

rule function_253_0 {
	meta:
		name = "_NF__2AB"
		size = 124
		refs = "000f _NF__242 001b _NF__2AB 0021 _NF__16A 0039 ExceptObjProc 0041 _NF__2AA 0055 _NF__29D 005b ExceptProc 0075 @RunError"
	strings:
		$1 = { 8B 44 24 04 F7 40 04 06 00 00 00 75 6C FC E8 ?? ?? ?? ?? 8B 54 24 08 6A 00 50 68 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 8B 5C 24 04 81 3B DE FA ED 0E 8B 53 14 8B 43 18 74 1D 8B 15 ?? ?? ?? ?? 85 D2 0F 84 ?? ?? ?? ?? 89 D8 FF D2 85 C0 0F 84 ?? ?? ?? ?? 8B 53 0C E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 85 C9 74 02 FF D1 8B 4C 24 04 B8 D9 00 00 00 8B 51 14 89 14 24 E9 ?? ?? ?? ?? 31 C0 C3 }
	condition:
		$1
}

rule function_254_0 {
	meta:
		name = "_NF__2AC"
		size = 30
		refs = "0010 _NF__2AB 0019 _NV__2A8"
	strings:
		$1 = { 31 D2 8D 45 F4 64 8B 0A 64 89 02 89 08 C7 40 04 ?? ?? ?? ?? 89 68 08 89 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_255_0 {
	meta:
		name = "_NF__2AD"
		size = 37
		refs = "0004 _NV__2A8"
	strings:
		$1 = { 31 D2 8B 05 ?? ?? ?? ?? 64 8B 0A 39 C8 75 08 8B 00 64 89 02 C3 8B 09 83 F9 FF 74 08 39 01 75 F5 8B 00 89 01 C3 }
	condition:
		$1
}

rule function_256_0 {
	meta:
		name = "_NF__2AE"
		size = 95
		refs = "0007 _NV__2A8 001c _NF__2AE 0047 @HandleAnyException 0051 @RaiseAgain 0056 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 BF ?? ?? ?? ?? 8B 47 08 85 C0 74 48 8B 5F 0C 8B 70 04 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 85 DB 7E 12 4B 89 5F 0C 8B 44 DE 04 85 C0 74 02 FF D0 85 DB 7F EE 33 C0 5A 59 59 64 89 10 EB 14 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_257_0 {
	meta:
		name = "_NF__2AF"
		size = 95
		refs = "0007 _NV__2A8 001a _NF__2AF 0047 @HandleAnyException 004c _NF__2AE 0051 @RaiseAgain 0056 @DoneExcept"
	strings:
		$1 = { 55 8B EC 53 56 57 A1 ?? ?? ?? ?? 85 C0 74 4B 8B 30 33 DB 8B 78 04 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 3B F3 7E 14 8B 04 DF 43 89 1D ?? ?? ?? ?? 85 C0 74 02 FF D0 3B F3 7F EC 33 C0 5A 59 59 64 89 10 EB 14 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_258_0 {
	meta:
		name = "@PackageLoad"
		size = 111
		refs = "0009 _NV__2A8 0036 @PackageLoad 0041 _NF__2AF 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 56 57 BE ?? ?? ?? ?? 8D 7D D4 B9 0B 00 00 00 F3 A5 C6 05 ?? ?? ?? ?? 00 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 8D 45 D4 A3 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 75 D4 BF ?? ?? ?? ?? B9 0B 00 00 00 F3 A5 C3 E9 ?? ?? ?? ?? EB E9 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule function_259_0 {
	meta:
		name = "@PackageUnload"
		size = 111
		refs = "0009 _NV__2A8 0036 @PackageUnload 0041 _NF__2AE 0063 @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 D4 56 57 BE ?? ?? ?? ?? 8D 7D D4 B9 0B 00 00 00 F3 A5 C6 05 ?? ?? ?? ?? 00 A3 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? 8D 45 D4 A3 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 75 D4 BF ?? ?? ?? ?? B9 0B 00 00 00 F3 A5 C3 E9 ?? ?? ?? ?? EB E9 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule function_260_0 {
	meta:
		name = "@StartExe"
		size = 47
		refs = "0002 _NV__2A8 0019 MainInstance 001e _NF__2AC 0024 IsLibrary 002a _NF__2AF"
	strings:
		$1 = { 89 05 ?? ?? ?? ?? 31 C0 89 05 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 8B 42 04 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_261_0 {
	meta:
		name = "@StartLib"
		size = 156
		refs = "0004 _NV__2A8 0050 _NF__2AC 007b MainInstance 0084 IsLibrary 008f @Halt0 0094 _NF__2AF"
	strings:
		$1 = { 51 56 57 BE ?? ?? ?? ?? 8D 7D C4 B9 0B 00 00 00 F3 A5 8F 05 ?? ?? ?? ?? 8F 05 ?? ?? ?? ?? 89 2D ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 8D 4D C4 89 0D ?? ?? ?? ?? 31 C9 83 7D 0C 00 75 02 8B 08 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 0C 40 A2 ?? ?? ?? ?? 48 59 8B 11 89 15 ?? ?? ?? ?? 74 03 FF 14 81 8B 54 24 04 85 D2 74 05 8B 45 0C FF D2 83 3D ?? ?? ?? ?? 00 75 07 C6 05 ?? ?? ?? ?? 01 8B 45 0C 48 0F 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? C2 04 00 C3 }
	condition:
		$1
}

rule function_262_0 {
	meta:
		name = "@InitResStrings"
		size = 26
		refs = "000d LoadResString"
	strings:
		$1 = { 53 56 8B 18 8D 70 04 8B 46 04 8B 16 E8 ?? ?? ?? ?? 83 C6 08 4B 75 F0 5E 5B C3 }
	condition:
		$1
}

rule function_263_0 {
	meta:
		name = "@InitResStringImports"
		size = 28
		refs = "000f LoadResString"
	strings:
		$1 = { 53 56 8B 18 8D 70 04 8B 46 04 8B 16 8B 00 E8 ?? ?? ?? ?? 83 C6 08 4B 75 EE 5E 5B C3 }
	condition:
		$1
}

rule function_264_0 {
	meta:
		name = "@InitImports"
		size = 30
	strings:
		$1 = { 53 56 8B 18 8D 70 04 8B 46 04 8B 16 8B 4E 08 8B 00 01 C8 89 02 83 C6 0C 4B 75 EC 5E 5B C3 }
	condition:
		$1
}

rule function_265_0 {
	meta:
		name = "_NF__2BC"
		size = 77
		refs = "0003 ExitCode 0008 _NV__2B9 0021 ErrorAddr 0026 FindHInstance 003f _NV__2BB"
	strings:
		$1 = { 53 8B 05 ?? ?? ?? ?? BB ?? ?? ?? ?? B9 0A 00 00 00 31 D2 F7 F1 80 C2 30 88 13 4B 85 C0 75 F2 8B 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 92 29 D0 BB ?? ?? ?? ?? 89 C2 83 E2 0F 8A 92 ?? ?? ?? ?? 88 13 4B C1 E8 04 75 ED 5B C3 }
	condition:
		$1
}

rule function_266_0 {
	meta:
		name = "_NF__2BD"
		size = 52
		refs = "0001 _NV__2A8 0026 ExitCode"
	strings:
		$1 = { BF ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 8B 2D ?? ?? ?? ?? FF 77 1C FF 77 20 8B 37 B9 0B 00 00 00 F3 A5 5F 5E 31 C0 87 05 ?? ?? ?? ?? F7 D8 19 C0 40 C9 C2 0C 00 C3 }
	condition:
		$1
}

rule function_267_0 {
	meta:
		name = "@Halt0"
		size = 278
		refs = "0005 _NV__2A8 000a ExitCode 000f ExitProc 0031 ErrorAddr 0039 _NF__2BC 003f IsConsole 0047 _NV__2B9 004c Output 0051 @Write0CString 0056 @WriteLn 005f _NV__2BA 006b _NF__171 0087 _NF__2AE 009e UnregisterModule 00af _NF__173 00b4 _NF__2AD 00c8 _NF__2BD 00d5 _NF__170"
	strings:
		$1 = { 53 56 57 55 BB ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? 80 7B 24 00 75 16 83 3F 00 74 11 8B 17 89 D0 33 D2 89 17 8B E8 FF D5 83 3F 00 75 EF 83 3D ?? ?? ?? ?? 00 74 3E E8 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? 00 74 16 BA ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 13 6A 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 E8 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 80 7B 24 02 75 0A 83 3E 00 75 05 33 C0 89 43 0C E8 ?? ?? ?? ?? 80 7B 24 01 76 05 83 3E 00 74 1D 8B 43 10 85 C0 74 16 E8 ?? ?? ?? ?? 8B 43 10 8B 50 08 3B 50 04 74 06 52 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 7B 24 01 75 03 FF 53 28 80 7B 24 00 74 05 E8 ?? ?? ?? ?? 83 3B 00 75 08 8B 06 50 E8 ?? ?? ?? ?? 8B 03 56 8B F0 8B FB B9 0B 00 00 00 F3 A5 5E EB 8C 50 6F 72 74 69 6F 6E 73 20 43 6F 70 79 72 69 67 68 74 20 28 63 29 20 31 39 38 33 2C 39 37 20 42 6F 72 6C 61 6E 64 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_268_0 {
	meta:
		name = "@Halt"
		size = 12
		refs = "0002 ExitCode 0007 @Halt0"
	strings:
		$1 = { 89 05 ?? ?? ?? ?? E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_269_0 {
	meta:
		name = "@Run0Error"
		size = 8
		refs = "0003 @RunError"
	strings:
		$1 = { 31 C0 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_270_0 {
	meta:
		name = "@RunError"
		size = 12
		refs = "0002 ErrorAddr 0007 @Halt"
	strings:
		$1 = { 8F 05 ?? ?? ?? ?? E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_271_0 {
	meta:
		name = "@Assert"
		size = 26
		refs = "0002 AssertErrorProc 0015 _NF__1EB"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 09 FF 34 24 FF 15 ?? ?? ?? ?? B0 15 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_272_0 {
	meta:
		name = "_NF__2C8"
		size = 54
		refs = "0004 _NF__242 000c _NF__2AB 0022 @FreeMem"
	strings:
		$1 = { 55 8B EC E8 ?? ?? ?? ?? 31 C9 55 68 ?? ?? ?? ?? 64 8B 11 52 8B 45 08 64 89 21 8B 48 04 8B 10 51 52 E8 ?? ?? ?? ?? 5A 58 FF D2 31 D2 59 64 89 0A 59 5D 5D C2 04 00 }
	condition:
		$1
}

rule function_273_0 {
	meta:
		name = "BeginThread"
		size = 66
		refs = "0012 @GetMem 0020 IsMultiThread 002f _NF__2C8 0037 _NF__16E"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B F2 8B D8 B8 08 00 00 00 E8 ?? ?? ?? ?? 89 38 8B 55 10 89 50 04 C6 05 ?? ?? ?? ?? 01 8B 55 08 52 8B 55 0C 52 50 B8 ?? ?? ?? ?? 50 56 53 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_275_0 {
	meta:
		name = "@LStrClr"
		size = 34
		refs = "001c @FreeMem"
	strings:
		$1 = { 8B 10 85 D2 74 1B C7 00 00 00 00 00 8B 4A F8 49 7C 0F 89 4A F8 75 0A 50 8D 42 F8 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_276_0 {
	meta:
		name = "@LStrArrayClr"
		size = 46
		refs = "0021 @FreeMem"
	strings:
		$1 = { 53 56 89 C3 89 D6 8B 13 85 D2 74 19 C7 03 00 00 00 00 8B 4A F8 49 7C 0D 89 4A F8 75 08 8D 42 F8 E8 ?? ?? ?? ?? 83 C3 04 4E 75 DB 5E 5B C3 }
	condition:
		$1
}

rule function_277_0 {
	meta:
		name = "@LStrAsg"
		size = 65
		refs = "0010 @NewAnsiString 001c Move 003c @FreeMem"
	strings:
		$1 = { 85 D2 74 23 8B 4A F8 41 7F 1A 50 52 8B 42 FC E8 ?? ?? ?? ?? 89 C2 58 52 8B 48 FC E8 ?? ?? ?? ?? 5A 58 EB 03 89 4A F8 87 10 85 D2 74 13 8B 4A F8 49 7C 0D 89 4A F8 75 08 8D 42 F8 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_278_0 {
	meta:
		name = "@LStrLAsg"
		size = 39
		refs = "0022 @FreeMem"
	strings:
		$1 = { 85 D2 74 09 8B 4A F8 41 7E 03 89 4A F8 87 10 85 D2 74 13 8B 4A F8 49 7C 0D 89 4A F8 75 08 8D 42 F8 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_279_0 {
	meta:
		name = "@NewAnsiString"
		size = 35
		refs = "0009 @GetMem"
	strings:
		$1 = { 85 C0 7E 1C 50 83 C0 09 E8 ?? ?? ?? ?? 83 C0 08 5A 89 50 FC C7 40 F8 01 00 00 00 C6 04 10 00 C3 31 C0 C3 }
	condition:
		$1
}

rule function_280_0 {
	meta:
		name = "@LStrFromPCharLen"
		size = 46
		refs = "000c @NewAnsiString 001d Move 0024 @LStrClr"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF 89 F8 E8 ?? ?? ?? ?? 89 F9 89 C7 85 F6 74 09 89 C2 89 F0 E8 ?? ?? ?? ?? 89 D8 E8 ?? ?? ?? ?? 89 3B 5F 5E 5B C3 }
	condition:
		$1
}

rule function_281_0 {
	meta:
		name = "@LStrFromPWCharLen"
		size = 143
		refs = "0017 @LStrClr 003a _NF__185 004b @LStrFromPCharLen"
	strings:
		$1 = { 53 56 57 55 81 C4 00 F8 FF FF 8B D9 8B EA 8B F8 85 DB 7F 09 8B C7 E8 ?? ?? ?? ?? EB 67 81 FB 00 04 00 00 7D 2C 6A 00 6A 00 68 00 08 00 00 8D 44 24 0C 50 53 55 6A 00 6A 00 E8 ?? ?? ?? ?? 8B F0 85 F6 7E 0D 8B D4 8B C7 8B CE E8 ?? ?? ?? ?? EB 33 6A 00 6A 00 6A 00 6A 00 53 55 6A 00 6A 00 E8 ?? ?? ?? ?? 8B F0 8B C7 8B CE 33 D2 E8 ?? ?? ?? ?? 6A 00 6A 00 56 8B 07 50 53 55 6A 00 6A 00 E8 ?? ?? ?? ?? 81 C4 00 08 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_282_0 {
	meta:
		name = "@LStrFromChar"
		size = 15
		refs = "0009 @LStrFromPCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_283_0 {
	meta:
		name = "@LStrFromWChar"
		size = 15
		refs = "0009 @LStrFromPWCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_315_0 {
	meta:
		name = "@WStrFromChar"
		size = 15
		refs = "0009 @WStrFromPCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_316_0 {
	meta:
		name = "@WStrFromWChar"
		size = 15
		refs = "0009 @WStrFromPWCharLen"
	strings:
		$1 = { 52 89 E2 B9 01 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule function_284_0 {
	meta:
		name = "@LStrFromPChar"
		size = 45
		refs = "0028 @LStrFromPCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 21 52 3A 0A 74 17 3A 4A 01 74 11 3A 4A 02 74 0B 3A 4A 03 74 05 83 C2 04 EB E8 42 42 42 89 D1 5A 29 D1 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_317_0 {
	meta:
		name = "@WStrFromPChar"
		size = 45
		refs = "0028 @WStrFromPCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 21 52 3A 0A 74 17 3A 4A 01 74 11 3A 4A 02 74 0B 3A 4A 03 74 05 83 C2 04 EB E8 42 42 42 89 D1 5A 29 D1 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_285_0 {
	meta:
		name = "@LStrFromPWChar"
		size = 57
		refs = "0034 @LStrFromPWCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 2D 52 66 3B 0A 74 20 66 3B 4A 02 74 17 66 3B 4A 04 74 0E 66 3B 4A 06 74 05 83 C2 08 EB E4 83 C2 02 83 C2 02 83 C2 02 89 D1 5A 29 D1 D1 E9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_318_0 {
	meta:
		name = "@WStrFromPWChar"
		size = 57
		refs = "0034 @WStrFromPWCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 2D 52 66 3B 0A 74 20 66 3B 4A 02 74 17 66 3B 4A 04 74 0E 66 3B 4A 06 74 05 83 C2 08 EB E4 83 C2 02 83 C2 02 83 C2 02 89 D1 5A 29 D1 D1 E9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_286_0 {
	meta:
		name = "@LStrFromString"
		size = 11
		refs = "0006 @LStrFromPCharLen"
	strings:
		$1 = { 31 C9 8A 0A 42 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_319_0 {
	meta:
		name = "@WStrFromString"
		size = 11
		refs = "0006 @WStrFromPCharLen"
	strings:
		$1 = { 31 C9 8A 0A 42 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_287_0 {
	meta:
		name = "@LStrFromArray"
		size = 24
		refs = "0013 @LStrFromPCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 F2 AE 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_320_0 {
	meta:
		name = "@WStrFromArray"
		size = 24
		refs = "0013 @WStrFromPCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 F2 AE 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_288_0 {
	meta:
		name = "@LStrFromWArray"
		size = 25
		refs = "0014 @LStrFromPWCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 66 F2 AF 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_321_0 {
	meta:
		name = "@WStrFromWArray"
		size = 25
		refs = "0014 @WStrFromPWCharLen"
	strings:
		$1 = { 57 50 51 89 D7 31 C0 66 F2 AF 75 02 F7 D1 58 01 C1 58 5F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_289_0 {
	meta:
		name = "@LStrFromWStr"
		size = 17
		refs = "000c @LStrFromPWCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 05 8B 4A FC D1 E9 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_290_0 {
	meta:
		name = "@LStrToString"
		size = 34
		refs = "0017 Move"
	strings:
		$1 = { 53 85 D2 74 18 8B 5A FC 85 DB 74 11 39 D9 7C 02 89 D9 88 08 40 92 E8 ?? ?? ?? ?? 5B C3 C6 00 00 5B C3 }
	condition:
		$1
}

rule function_291_0 {
	meta:
		name = "@LStrLen"
		size = 8
	strings:
		$1 = { 85 C0 74 03 8B 40 FC C3 }
	condition:
		$1
}

rule function_292_0 {
	meta:
		name = "@LStrCat"
		size = 68
		refs = "000a @LStrAsg 0022 @LStrSetLength 0030 Move"
	strings:
		$1 = { 85 D2 74 3F 8B 08 85 C9 0F 84 ?? ?? ?? ?? 53 56 57 89 C3 89 D6 8B 79 FC 8B 56 FC 01 FA 39 CE 74 17 E8 ?? ?? ?? ?? 89 F0 8B 4E FC 8B 13 01 FA E8 ?? ?? ?? ?? 5F 5E 5B C3 E8 ?? ?? ?? ?? 8B 03 89 F9 EB E8 C3 }
	condition:
		$1
}

rule function_293_0 {
	meta:
		name = "@LStrCat3"
		size = 116
		refs = "0008 @LStrAsg 001e @LStrCat 0031 @NewAnsiString 003f Move"
	strings:
		$1 = { 85 D2 74 61 85 C9 0F 84 ?? ?? ?? ?? 3B 10 74 5C 3B 08 74 0E 50 51 E8 ?? ?? ?? ?? 5A 58 E9 ?? ?? ?? ?? 53 56 57 89 D3 89 CE 50 8B 43 FC 03 46 FC E8 ?? ?? ?? ?? 89 C7 89 C2 89 D8 8B 4B FC E8 ?? ?? ?? ?? 89 FA 89 F0 8B 4E FC 03 53 FC E8 ?? ?? ?? ?? 58 89 FA 85 FF 74 03 FF 4F F8 E8 ?? ?? ?? ?? 5F 5E 5B C3 89 CA E9 ?? ?? ?? ?? 89 CA E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_294_0 {
	meta:
		name = "@LStrCatN"
		size = 77
		refs = "0017 @NewAnsiString 002e Move 003f @LStrAsg"
	strings:
		$1 = { 53 56 52 50 89 D3 31 C0 8B 4C 94 10 85 C9 74 03 03 41 FC 4A 75 F2 E8 ?? ?? ?? ?? 50 89 C6 8B 44 9C 14 89 F2 85 C0 74 0A 8B 48 FC 01 CE E8 ?? ?? ?? ?? 4B 75 E9 5A 58 85 D2 74 03 FF 4A F8 E8 ?? ?? ?? ?? 5A 5E 5B 58 8D 24 94 FF E0 C3 }
	condition:
		$1
}

rule function_295_0 {
	meta:
		name = "@LStrCmp"
		size = 162
	strings:
		$1 = { 53 56 57 89 C6 89 D7 39 D0 0F 84 8F 00 00 00 85 F6 74 68 85 FF 74 6B 8B 46 FC 8B 57 FC 29 D0 77 02 01 C2 52 C1 EA 02 74 26 8B 0E 8B 1F 39 D9 75 58 4A 74 15 8B 4E 04 8B 5F 04 39 D9 75 4B 83 C6 08 83 C7 08 4A 75 E2 EB 06 83 C6 04 83 C7 04 5A 83 E2 03 74 22 8B 0E 8B 1F 38 D9 75 41 4A 74 17 38 FD 75 3A 4A 74 10 81 E3 00 00 FF 00 81 E1 00 00 FF 00 39 D9 75 27 01 C0 EB 23 8B 57 FC 29 D0 EB 1C 8B 46 FC 29 D0 EB 15 5A 38 D9 75 10 38 FD 75 0C C1 E9 10 C1 EB 10 38 D9 75 02 38 FD 5F 5E 5B C3 }
	condition:
		$1
}

rule function_296_0 {
	meta:
		name = "@LStrAddRef"
		size = 14
	strings:
		$1 = { 85 C0 74 09 8B 50 F8 42 7E 03 89 50 F8 C3 }
	condition:
		$1
}

rule function_297_0 {
	meta:
		name = "@LStrToPChar"
		size = 12
		refs = "0007 @LStrToPChar"
	strings:
		$1 = { 85 C0 74 02 C3 00 B8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_298_0 {
	meta:
		name = "UniqueString"
		size = 52
		refs = "0013 @NewAnsiString 002a Move"
	strings:
		$1 = { 8B 10 85 D2 74 2B 8B 4A F8 49 74 25 53 89 C3 8B 42 FC E8 ?? ?? ?? ?? 89 C2 8B 03 89 13 8B 48 F8 49 7C 03 89 48 F8 8B 48 FC E8 ?? ?? ?? ?? 8B 13 5B 89 D0 C3 }
	condition:
		$1
}

rule function_299_0 {
	meta:
		name = "@LStrCopy"
		size = 64
		refs = "0024 @LStrFromPCharLen 0037 @LStrClr"
	strings:
		$1 = { 53 85 C0 74 2D 8B 58 FC 85 DB 74 26 4A 7C 1B 39 DA 7D 1F 29 D3 85 C9 7C 19 39 D9 7F 11 01 C2 8B 44 24 08 E8 ?? ?? ?? ?? EB 11 31 D2 EB E5 89 D9 EB EB 8B 44 24 08 E8 ?? ?? ?? ?? 5B C2 04 00 C3 }
	condition:
		$1
}

rule function_300_0 {
	meta:
		name = "@LStrDelete"
		size = 72
		refs = "000a UniqueString 0032 Move 0040 @LStrSetLength"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF E8 ?? ?? ?? ?? 8B 13 85 D2 74 30 8B 4A FC 4E 7C 2A 39 CE 7D 26 85 FF 7E 22 29 F1 39 CF 7E 02 89 CF 29 F9 01 F2 8D 04 3A E8 ?? ?? ?? ?? 8B 13 89 D8 8B 52 FC 29 FA E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_301_0 {
	meta:
		name = "@LStrInsert"
		size = 91
		refs = "002b @LStrSetLength 0045 Move"
	strings:
		$1 = { 85 C0 74 56 53 56 57 55 89 C3 89 D6 89 CF 8B 12 52 85 D2 74 03 8B 52 FC 4F 7D 02 31 FF 39 D7 7E 02 89 D7 8B 6B FC 89 F0 01 EA E8 ?? ?? ?? ?? 58 39 D8 75 02 8B 1E 8B 06 8D 14 2F 8B 48 FC 29 D1 01 C2 01 F8 E8 ?? ?? ?? ?? 89 D8 8B 16 89 E9 01 FA E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_302_0 {
	meta:
		name = "@LStrPos"
		size = 69
	strings:
		$1 = { 85 C0 74 40 85 D2 74 31 53 56 57 89 C6 89 D7 8B 4F FC 57 8B 56 FC 4A 78 1B 8A 06 46 29 D1 7E 14 F2 AE 75 10 89 CB 56 57 89 D1 F3 A6 5F 5E 74 0C 89 D9 EB EC 5A 31 C0 EB 08 31 C0 C3 5A 89 F8 29 D0 5F 5E 5B C3 }
	condition:
		$1
}

rule function_303_0 {
	meta:
		name = "@LStrSetLength"
		size = 98
		refs = "0023 @ReallocMem 0039 @NewAnsiString 0051 Move 0058 @LStrClr"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 31 FF 85 D2 74 48 8B 03 85 C0 74 23 83 78 F8 01 75 1D 83 E8 08 83 C2 09 50 89 E0 E8 ?? ?? ?? ?? 58 83 C0 08 89 03 89 70 FC C6 04 30 00 EB 28 89 D0 E8 ?? ?? ?? ?? 89 C7 8B 03 85 C0 74 10 89 FA 8B 48 FC 39 F1 7C 02 89 F1 E8 ?? ?? ?? ?? 89 D8 E8 ?? ?? ?? ?? 89 3B 5F 5E 5B C3 }
	condition:
		$1
}

rule function_304_0 {
	meta:
		name = "@LStrOfChar"
		size = 42
		refs = "000c @LStrClr 0017 @NewAnsiString 0022 @FillChar"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF 89 C8 E8 ?? ?? ?? ?? 85 F6 7E 12 89 F0 E8 ?? ?? ?? ?? 89 07 89 F2 88 D9 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_306_0 {
	meta:
		name = "@WriteLString"
		size = 32
		refs = "0012 _NF__477 001b _NF__476"
	strings:
		$1 = { 53 89 D3 89 CA 31 C9 85 DB 74 05 8B 4B FC 29 CA 51 E8 ?? ?? ?? ?? 59 89 DA 5B E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_307_0 {
	meta:
		name = "@ReadLString"
		size = 106
		refs = "0009 @LStrClr 001d @ReadString 0026 @LStrFromString 004f @LStrCat"
	strings:
		$1 = { 53 56 89 C3 89 D6 89 D0 E8 ?? ?? ?? ?? 81 EC 00 01 00 00 89 D8 89 E2 B9 FF 00 00 00 E8 ?? ?? ?? ?? 89 F0 89 E2 E8 ?? ?? ?? ?? 80 3C 24 FF 75 31 89 D8 89 E2 B9 FF 00 00 00 E8 ?? ?? ?? ?? 89 E2 6A 00 89 E0 E8 ?? ?? ?? ?? 89 F0 8B 14 24 E8 ?? ?? ?? ?? 89 E0 E8 ?? ?? ?? ?? 58 80 3C 24 FF 74 CF 81 C4 00 01 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_308_0 {
	meta:
		name = "_NF__30E"
		size = 8
		refs = "0003 _NF__1EB"
	strings:
		$1 = { B0 01 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_309_0 {
	meta:
		name = "_NF__30F"
		size = 15
		refs = "000a _NF__189"
	strings:
		$1 = { 8B 08 89 10 85 C9 74 06 51 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_310_0 {
	meta:
		name = "@WStrClr"
		size = 21
		refs = "000f _NF__189"
	strings:
		$1 = { 8B 10 85 D2 74 0E C7 00 00 00 00 00 50 52 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_311_0 {
	meta:
		name = "@WStrArrayClr"
		size = 33
		refs = "0014 _NF__189"
	strings:
		$1 = { 53 56 89 C3 89 D6 8B 03 85 C0 74 0C C7 03 00 00 00 00 50 E8 ?? ?? ?? ?? 83 C3 04 4E 75 E8 5E 5B C3 }
	condition:
		$1
}

rule function_312_0 {
	meta:
		name = "@WStrAsg"
		size = 36
		refs = "0004 @WStrClr 0017 _NF__188 001f _NF__30E"
	strings:
		$1 = { 85 D2 0F 84 ?? ?? ?? ?? 8B 4A FC D1 E9 0F 84 ?? ?? ?? ?? 51 52 50 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_313_0 {
	meta:
		name = "@WStrFromPCharLen"
		size = 131
		refs = "0017 @WStrClr 0036 _NF__17F 0047 @WStrFromPWCharLen"
	strings:
		$1 = { 53 56 57 55 81 C4 00 F8 FF FF 8B D9 8B EA 8B F8 85 DB 7F 09 8B C7 E8 ?? ?? ?? ?? EB 5B 81 FB 00 04 00 00 7D 28 68 00 04 00 00 8D 44 24 04 50 53 55 6A 00 6A 00 E8 ?? ?? ?? ?? 8B F0 85 F6 7E 0D 8B D4 8B C7 8B CE E8 ?? ?? ?? ?? EB 2B 6A 00 6A 00 53 55 6A 00 6A 00 E8 ?? ?? ?? ?? 8B F0 8B C7 8B CE 33 D2 E8 ?? ?? ?? ?? 56 8B 07 50 53 55 6A 00 6A 00 E8 ?? ?? ?? ?? 81 C4 00 08 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_314_0 {
	meta:
		name = "@WStrFromPWCharLen"
		size = 25
		refs = "0004 @WStrClr 000c _NF__188 0014 _NF__30E"
	strings:
		$1 = { 85 C9 0F 84 ?? ?? ?? ?? 51 52 50 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_322_0 {
	meta:
		name = "@WStrFromLStr"
		size = 15
		refs = "000a @WStrFromPCharLen"
	strings:
		$1 = { 31 C9 85 D2 74 03 8B 4A FC E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_323_0 {
	meta:
		name = "@WStrToString"
		size = 100
		refs = "0012 @WStrLen 003f _NF__185 0056 Move"
	strings:
		$1 = { 53 56 57 81 C4 00 FE FF FF 8B F9 8B F2 8B D8 8B C6 E8 ?? ?? ?? ?? 3D FF 00 00 00 7C 05 B8 FF 00 00 00 85 C0 75 04 33 C0 EB 1F 6A 00 6A 00 68 00 02 00 00 8D 54 24 0C 52 50 56 6A 00 6A 00 E8 ?? ?? ?? ?? 3B F8 7D 02 8B C7 88 03 85 C0 7E 0B 8D 53 01 8B CC 91 E8 ?? ?? ?? ?? 81 C4 00 02 00 00 5F 5E 5B C3 }
	condition:
		$1
}

rule function_324_0 {
	meta:
		name = "@WStrToPWChar"
		size = 14
		refs = "0009 @WStrToPWChar"
	strings:
		$1 = { 85 C0 74 04 C3 90 00 00 B8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_325_0 {
	meta:
		name = "@WStrLen"
		size = 10
	strings:
		$1 = { 85 C0 74 05 8B 40 FC D1 E8 C3 }
	condition:
		$1
}

rule function_326_0 {
	meta:
		name = "@WStrCat"
		size = 95
		refs = "000d @WStrLen 0027 @NewWideString 003d Move 0055 _NF__30F"
	strings:
		$1 = { 53 56 57 55 51 8B EA 89 04 24 8B C5 E8 ?? ?? ?? ?? 8B D8 85 DB 74 42 8B 04 24 8B 00 E8 ?? ?? ?? ?? 8B F0 8D 04 33 E8 ?? ?? ?? ?? 8B F8 85 F6 7E 10 8B CE 03 C9 8B D7 8B 04 24 8B 00 E8 ?? ?? ?? ?? 8B CB 03 C9 8D 14 77 8B C5 E8 ?? ?? ?? ?? 8B 04 24 8B D7 E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_327_0 {
	meta:
		name = "@WStrCat3"
		size = 100
		refs = "0013 @WStrLen 0030 @NewWideString 003f Move 0059 _NF__30F"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 89 4C 24 04 8B EA 89 04 24 8B C5 E8 ?? ?? ?? ?? 8B D8 8B 44 24 04 E8 ?? ?? ?? ?? 8B F0 85 DB 75 04 85 F6 74 31 8D 04 1E E8 ?? ?? ?? ?? 8B F8 8B CB 03 C9 8B D7 8B C5 E8 ?? ?? ?? ?? 8B CE 03 C9 8D 14 5F 8B 44 24 04 E8 ?? ?? ?? ?? 8B 04 24 8B D7 E8 ?? ?? ?? ?? 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_328_0 {
	meta:
		name = "@WStrCatN"
		size = 72
		refs = "0019 @NewWideString 0030 Move 003a _NF__30F"
	strings:
		$1 = { 53 56 52 50 89 D3 31 C0 8B 4C 94 10 85 C9 74 03 03 41 FC 4A 75 F2 D1 E8 E8 ?? ?? ?? ?? 50 89 C6 8B 44 9C 14 89 F2 85 C0 74 0A 8B 48 FC 01 CE E8 ?? ?? ?? ?? 4B 75 E9 5A 58 E8 ?? ?? ?? ?? 5A 5E 5B 58 8D 24 94 FF E0 C3 }
	condition:
		$1
}

rule function_329_0 {
	meta:
		name = "@WStrCmp"
		size = 129
	strings:
		$1 = { 53 56 57 89 C6 89 D7 39 D0 74 72 85 F6 74 51 85 FF 74 54 8B 46 FC 8B 57 FC 29 D0 77 02 01 C2 52 C1 EA 02 74 26 8B 0E 8B 1F 39 D9 75 41 4A 74 15 8B 4E 04 8B 5F 04 39 D9 75 34 83 C6 08 83 C7 08 4A 75 E2 EB 06 83 C6 04 83 C7 04 5A 83 E2 02 74 0B 66 8B 0E 66 8B 1F 66 39 D9 75 21 01 C0 EB 1D 8B 57 FC 29 D0 EB 16 8B 46 FC 29 D0 EB 0F 5A 66 39 D9 75 09 C1 E9 10 C1 EB 10 66 39 D9 5F 5E 5B C3 }
	condition:
		$1
}

rule function_330_0 {
	meta:
		name = "@NewWideString"
		size = 21
		refs = "0008 _NF__187 0010 _NF__30E"
	strings:
		$1 = { 85 C0 74 10 50 6A 00 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_331_0 {
	meta:
		name = "@WStrCopy"
		size = 73
		refs = "000f @WStrLen 003e @WStrFromPWCharLen"
	strings:
		$1 = { 55 8B EC 53 56 57 8B F9 8B DA 8B F0 8B C6 E8 ?? ?? ?? ?? 83 FB 01 7D 04 33 DB EB 07 4B 3B C3 7D 02 8B D8 85 FF 7D 04 33 C0 EB 08 2B C3 3B F8 7D 02 8B C7 8B D3 03 D2 03 D6 8B 4D 08 91 E8 ?? ?? ?? ?? 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule function_332_0 {
	meta:
		name = "@WStrDelete"
		size = 141
		refs = "000f @WStrLen 0048 @NewWideString 005e Move 0083 _NF__30F"
	strings:
		$1 = { 53 56 57 55 51 8B F9 8B DA 8B E8 8B 45 00 E8 ?? ?? ?? ?? 8B F0 85 F6 7E 6E 83 FB 01 7C 69 3B F3 7C 65 85 FF 7E 61 4B 8B C6 2B C3 2B C7 8B F8 85 FF 7D 02 33 FF 85 DB 75 0B 85 FF 75 07 33 C0 89 04 24 EB 39 8D 04 1F E8 ?? ?? ?? ?? 89 04 24 85 DB 7E 0F 8B CB 03 C9 8B 14 24 8B 45 00 E8 ?? ?? ?? ?? 85 FF 7E 17 2B F7 8B 45 00 8D 04 70 8B CF 03 C9 8B 14 24 8D 14 5A E8 ?? ?? ?? ?? 8B C5 8B 14 24 E8 ?? ?? ?? ?? 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_333_0 {
	meta:
		name = "@WStrInsert"
		size = 154
		refs = "0014 @WStrLen 003f @NewWideString 0056 Move 008f _NF__30F"
	strings:
		$1 = { 53 56 57 55 83 C4 F8 8B D9 89 54 24 04 89 04 24 8B 04 24 E8 ?? ?? ?? ?? 8B F0 85 F6 7E 75 8B 44 24 04 8B 00 E8 ?? ?? ?? ?? 8B F8 83 FB 01 7D 04 33 DB EB 07 4B 3B FB 7D 02 8B DF 8D 04 3E E8 ?? ?? ?? ?? 8B E8 85 DB 7E 11 8B CB 03 C9 8B D5 8B 44 24 04 8B 00 E8 ?? ?? ?? ?? 8B CE 03 C9 8D 54 5D 00 8B 04 24 E8 ?? ?? ?? ?? 3B FB 7E 1A 03 F3 8D 54 75 00 2B FB 8B CF 03 C9 8B 44 24 04 8B 00 8D 04 58 E8 ?? ?? ?? ?? 8B 44 24 04 8B D5 E8 ?? ?? ?? ?? 59 5A 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_334_0 {
	meta:
		name = "@WStrPos"
		size = 80
	strings:
		$1 = { 85 C0 74 4B 85 D2 74 3A 53 56 57 89 C6 89 D7 8B 4F FC D1 E9 57 8B 56 FC D1 EA 4A 78 20 66 8B 06 83 C6 02 29 D1 7E 16 66 F2 AF 75 11 89 CB 56 57 89 D1 66 F3 A7 5F 5E 74 0C 89 D9 EB EA 5A 31 C0 EB 0A 31 C0 C3 5A 89 F8 29 D0 D1 E8 5F 5E 5B C3 }
	condition:
		$1
}

rule function_335_0 {
	meta:
		name = "@WStrSetLength"
		size = 65
		refs = "0010 @NewWideString 0019 @WStrLen 0030 Move 0039 _NF__30F"
	strings:
		$1 = { 53 56 57 8B F2 8B F8 33 DB 85 F6 7E 27 8B C6 E8 ?? ?? ?? ?? 8B D8 8B 07 E8 ?? ?? ?? ?? 85 C0 7E 13 3B F0 7D 02 8B C6 8B C8 03 C9 8B D3 8B 07 E8 ?? ?? ?? ?? 8B C7 8B D3 E8 ?? ?? ?? ?? 5F 5E 5B C3 }
	condition:
		$1
}

rule function_336_0 {
	meta:
		name = "@WStrOfWChar"
		size = 39
		refs = "0010 @WStrFromPWCharLen"
	strings:
		$1 = { 53 56 57 8B F9 8B DA 8B F0 8B C7 8B CB 33 D2 E8 ?? ?? ?? ?? 8B 07 85 DB 7E 09 4B 66 89 34 58 85 DB 7F F7 5F 5E 5B C3 }
	condition:
		$1
}

rule function_337_0 {
	meta:
		name = "@WStrAddRef"
		size = 31
		refs = "000f _NF__187 0018 _NF__30E"
	strings:
		$1 = { 8B 10 85 D2 74 18 50 8B 4A FC D1 E9 51 52 E8 ?? ?? ?? ?? 5A 85 C0 0F 84 ?? ?? ?? ?? 89 02 C3 }
	condition:
		$1
}

rule function_338_0 {
	meta:
		name = "@InitializeRecord"
		size = 42
		refs = "001c @Initialize"
	strings:
		$1 = { 31 C9 53 8A 4A 01 56 57 89 C3 8D 74 0A 0A 8B 7C 0A 06 8B 16 8B 46 04 01 D8 8B 12 E8 ?? ?? ?? ?? 83 C6 08 4F 7F EC 5F 5E 5B C3 }
	condition:
		$1
}

rule function_344_0 {
	meta:
		name = "@AddRefRecord"
		size = 42
		refs = "001c @AddRef"
	strings:
		$1 = { 31 C9 53 8A 4A 01 56 57 89 C3 8D 74 0A 0A 8B 7C 0A 06 8B 16 8B 46 04 01 D8 8B 12 E8 ?? ?? ?? ?? 83 C6 08 4F 7F EC 5F 5E 5B C3 }
	condition:
		$1
}

rule function_339_0 {
	meta:
		name = "@InitializeArray"
		size = 141
		refs = "0036 _NF__1EB 006b @InitializeArray 0081 @InitializeRecord"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF 31 D2 8A 06 8A 56 01 31 C9 80 F8 0A 74 23 80 F8 0B 74 1E 80 F8 0C 74 23 80 F8 0D 74 31 80 F8 0E 74 4A 80 F8 0F 74 0A B0 02 5F 5E 5B E9 ?? ?? ?? ?? 89 0B 83 C3 04 4F 7F F8 EB 45 89 0B 89 4B 04 89 4B 08 89 4B 0C 83 C3 10 4F 7F EF EB 32 55 89 D5 8B 54 2E 0A 89 D8 03 5C 2E 02 8B 4C 2E 06 8B 12 E8 ?? ?? ?? ?? 4F 7F E8 5D EB 14 55 89 D5 89 D8 03 5C 2E 02 89 F2 E8 ?? ?? ?? ?? 4F 7F F0 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_340_0 {
	meta:
		name = "@Initialize"
		size = 11
		refs = "0006 @InitializeArray"
	strings:
		$1 = { B9 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_346_0 {
	meta:
		name = "@AddRef"
		size = 11
		refs = "0006 @AddRefArray"
	strings:
		$1 = { B9 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_343_0 {
	meta:
		name = "@Finalize"
		size = 11
		refs = "0006 @FinalizeArray"
	strings:
		$1 = { B9 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_396_0 {
	meta:
		name = "@VarSub"
		size = 11
		refs = "0006 _NF__3CF"
	strings:
		$1 = { B9 01 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_341_0 {
	meta:
		name = "@FinalizeRecord"
		size = 44
		refs = "001c @Finalize"
	strings:
		$1 = { 31 C9 53 8A 4A 01 56 57 89 C3 8D 74 0A 0A 8B 7C 0A 06 8B 16 8B 46 04 01 D8 8B 12 E8 ?? ?? ?? ?? 83 C6 08 4F 7F EC 89 D8 5F 5E 5B C3 }
	condition:
		$1
}

rule function_342_0 {
	meta:
		name = "@FinalizeArray"
		size = 189
		refs = "0036 _NF__1EB 0042 @LStrClr 004b @LStrArrayClr 0059 @WStrClr 0062 @WStrArrayClr 006e @VarClr 008b @FinalizeArray 00a1 @FinalizeRecord 00b1 @IntfClear"
	strings:
		$1 = { 50 53 56 57 89 C3 89 D6 89 CF 31 D2 8A 06 8A 56 01 80 F8 0A 74 24 80 F8 0B 74 36 80 F8 0C 74 48 80 F8 0D 74 52 80 F8 0E 74 6B 80 F8 0F 74 7C 5F 5E 5B 58 B0 02 E9 ?? ?? ?? ?? 83 F9 01 89 D8 7F 07 E8 ?? ?? ?? ?? EB 70 89 CA E8 ?? ?? ?? ?? EB 67 83 F9 01 89 D8 7F 07 E8 ?? ?? ?? ?? EB 59 89 CA E8 ?? ?? ?? ?? EB 50 89 D8 83 C3 10 E8 ?? ?? ?? ?? 4F 7F F3 EB 41 55 89 D5 8B 54 2E 0A 89 D8 03 5C 2E 02 8B 4C 2E 06 8B 12 E8 ?? ?? ?? ?? 4F 7F E8 5D EB 23 55 89 D5 89 D8 03 5C 2E 02 89 F2 E8 ?? ?? ?? ?? 4F 7F F0 5D EB 0D 89 D8 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 5F 5E 5B 58 C3 }
	condition:
		$1
}

rule function_345_0 {
	meta:
		name = "@AddRefArray"
		size = 170
		refs = "0034 _NF__1EB 003e @LStrAddRef 004d @WStrAddRef 005c @VarAddRef 0079 @AddRefArray 008f @AddRefRecord 009f @IntfAddRef"
	strings:
		$1 = { 53 56 57 89 C3 89 D6 89 CF 31 D2 8A 06 8A 56 01 80 F8 0A 74 23 80 F8 0B 74 2D 80 F8 0C 74 37 80 F8 0D 74 41 80 F8 0E 74 5A 80 F8 0F 74 6B B0 02 5F 5E 5B E9 ?? ?? ?? ?? 8B 03 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 EB 5F 89 D8 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 EB 50 89 D8 83 C3 10 E8 ?? ?? ?? ?? 4F 7F F3 EB 41 55 89 D5 8B 54 2E 0A 89 D8 03 5C 2E 02 8B 4C 2E 06 8B 12 E8 ?? ?? ?? ?? 4F 7F E8 5D EB 23 55 89 D5 89 D8 03 5C 2E 02 89 F2 E8 ?? ?? ?? ?? 4F 7F F0 5D EB 0D 8B 03 83 C3 04 E8 ?? ?? ?? ?? 4F 7F F3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_347_0 {
	meta:
		name = "@CopyRecord"
		size = 250
		refs = "0028 Move 005a _NF__1EB 0064 @LStrAsg 0075 @WStrAsg 0086 @VarCopy 00aa @CopyArray 00c3 @CopyRecord 00d0 @IntfCopy"
	strings:
		$1 = { 53 56 57 55 89 C3 89 D6 31 C0 8A 41 01 8D 7C 01 0A 8B 6F FC 31 C0 8B 4F F8 51 8B 4F 04 29 C1 7E 0B 89 C2 01 F0 01 DA E8 ?? ?? ?? ?? 8B 47 04 8B 17 8B 12 8A 0A 80 F9 0A 74 24 80 F9 0B 74 30 80 F9 0C 74 3C 80 F9 0D 74 48 80 F9 0E 74 63 80 F9 0F 74 77 B0 02 5D 5F 5E 5B E9 ?? ?? ?? ?? 8B 14 06 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 EB 6A 8B 14 06 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 EB 59 8D 14 06 01 D8 E8 ?? ?? ?? ?? B8 10 00 00 00 EB 48 31 C9 8A 4A 01 FF 74 0A 02 FF 74 0A 06 8B 4C 0A 0A 8B 09 8D 14 06 01 D8 E8 ?? ?? ?? ?? 58 EB 28 31 C9 8A 4A 01 8B 4C 0A 02 51 89 D1 8D 14 06 01 D8 E8 ?? ?? ?? ?? 58 EB 0F 8B 14 06 01 D8 E8 ?? ?? ?? ?? B8 04 00 00 00 03 47 04 83 C7 08 4D 0F 85 34 FF FF FF 59 29 C1 7E 0A 8D 14 03 01 F0 E8 ?? ?? ?? ?? 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_348_0 {
	meta:
		name = "@CopyObject"
		size = 21
		refs = "000a @CopyRecord"
	strings:
		$1 = { 01 C1 FF 31 51 8B 4C 24 0C E8 ?? ?? ?? ?? 59 8F 01 C2 04 00 C3 }
	condition:
		$1
}

rule function_349_0 {
	meta:
		name = "@CopyArray"
		size = 209
		refs = "0039 _NF__1EB 0042 @LStrAsg 0056 @WStrAsg 006a @VarCopy 008d @CopyArray 00a1 @CopyRecord 00bc @IntfCopy"
	strings:
		$1 = { 53 56 57 55 89 C3 89 D6 89 CF 8B 6C 24 14 8A 0F 80 F9 0A 74 28 80 F9 0B 74 37 80 F9 0C 74 46 80 F9 0D 74 55 80 F9 0E 74 71 80 F9 0F 0F 84 85 00 00 00 B0 02 5D 5F 5E 5B E9 ?? ?? ?? ?? 89 D8 8B 16 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EE EB 78 89 D8 8B 16 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EE EB 64 89 D8 89 F2 E8 ?? ?? ?? ?? 83 C3 10 83 C6 10 4D 75 EE EB 50 31 C9 8A 4F 01 8D 7C 0F 02 89 D8 89 F2 8B 4F 08 FF 77 04 E8 ?? ?? ?? ?? 03 1F 03 37 4D 75 EA EB 2F 89 D8 89 F2 89 F9 E8 ?? ?? ?? ?? 31 C0 8A 47 01 03 5C 07 02 03 74 07 02 4D 75 E5 EB 12 89 D8 8B 16 E8 ?? ?? ?? ?? 83 C3 04 83 C6 04 4D 75 EE 5D 5F 5E 5B C2 04 00 C3 }
	condition:
		$1
}

rule function_350_0 {
	meta:
		name = "@New"
		size = 19
		refs = "0002 @GetMem 000d @Initialize"
	strings:
		$1 = { 52 E8 ?? ?? ?? ?? 5A 85 C0 74 07 50 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_351_0 {
	meta:
		name = "@Dispose"
		size = 13
		refs = "0002 @Finalize 0008 @FreeMem"
	strings:
		$1 = { 50 E8 ?? ?? ?? ?? 58 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_354_0 {
	meta:
		name = "WideCharToStrVar"
		size = 20
		refs = "000f WideCharLenToStrVar"
	strings:
		$1 = { 33 C9 EB 01 41 66 83 3C 48 00 75 F8 87 D1 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_355_0 {
	meta:
		name = "WideCharLenToStrVar"
		size = 137
		refs = "0017 @LStrClr 003a _NF__185 0045 @LStrFromPCharLen"
	strings:
		$1 = { 53 56 57 55 81 C4 00 F8 FF FF 8B F1 8B DA 8B F8 85 DB 75 09 8B C6 E8 ?? ?? ?? ?? EB 61 81 FB 00 04 00 00 7D 26 6A 00 6A 00 68 00 08 00 00 8D 44 24 0C 50 53 57 6A 00 6A 00 E8 ?? ?? ?? ?? 8B C8 8B D4 8B C6 E8 ?? ?? ?? ?? EB 33 6A 00 6A 00 6A 00 6A 00 53 57 6A 00 6A 00 E8 ?? ?? ?? ?? 8B E8 8B C6 8B CD 33 D2 E8 ?? ?? ?? ?? 6A 00 6A 00 55 8B 06 50 53 57 6A 00 6A 00 E8 ?? ?? ?? ?? 81 C4 00 08 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_356_0 {
	meta:
		name = "StringToWideChar"
		size = 49
		refs = "000f @LStrLen 0017 @LStrToPChar 0021 _NF__17F"
	strings:
		$1 = { 53 56 57 8B F9 8B DA 8B F0 4F 57 53 8B C6 E8 ?? ?? ?? ?? 50 8B C6 E8 ?? ?? ?? ?? 50 6A 00 6A 00 E8 ?? ?? ?? ?? 66 C7 04 43 00 00 8B C3 5F 5E 5B C3 }
	condition:
		$1
}

rule function_358_0 {
	meta:
		name = "OleStrToStrVar"
		size = 35
		refs = "0010 _NF__18A 001b WideCharLenToStrVar"
	strings:
		$1 = { 53 56 6A 00 8B F2 8B D8 89 1C 24 8B 04 24 50 E8 ?? ?? ?? ?? 8B D0 8B CE 8B C3 E8 ?? ?? ?? ?? 5A 5E 5B C3 }
	condition:
		$1
}

rule function_359_0 {
	meta:
		name = "StringToOleStr"
		size = 131
		refs = "000f @LStrLen 0031 @LStrToPChar 003b _NF__17F 0046 _NF__187"
	strings:
		$1 = { 53 56 57 55 81 C4 00 F8 FF FF 8B D8 8B C3 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 3D 00 04 00 00 7D 2B 68 00 04 00 00 8D 44 24 04 50 56 8B C3 E8 ?? ?? ?? ?? 50 6A 00 6A 00 E8 ?? ?? ?? ?? 50 8D 44 24 04 50 E8 ?? ?? ?? ?? 8B F8 EB 28 6A 00 6A 00 56 53 6A 00 6A 00 E8 ?? ?? ?? ?? 8B E8 55 6A 00 E8 ?? ?? ?? ?? 8B F8 55 57 56 53 6A 00 6A 00 E8 ?? ?? ?? ?? 8B C7 81 C4 00 08 00 00 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_361_0 {
	meta:
		name = "@DispInvokeError"
		size = 8
		refs = "0003 _NF__1EB"
	strings:
		$1 = { B0 11 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_362_0 {
	meta:
		name = "_NF__38C"
		size = 8
		refs = "0003 _NF__1EB"
	strings:
		$1 = { B0 0F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_363_0 {
	meta:
		name = "_NF__38D"
		size = 8
		refs = "0003 _NF__1EB"
	strings:
		$1 = { B0 10 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_364_0 {
	meta:
		name = "@VarClear"
		size = 52
		refs = "0023 @LStrClr 002f _NF__18B"
	strings:
		$1 = { 31 D2 66 8B 10 F7 C2 00 40 00 00 75 1A 83 FA 08 72 15 81 FA 00 01 00 00 75 13 66 C7 00 00 00 83 C0 08 E9 ?? ?? ?? ?? 66 C7 00 00 00 C3 50 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_365_0 {
	meta:
		name = "@VarCopy"
		size = 113
		refs = "0015 _NF__18B 001f @LStrClr 0064 _NF__18C 006c _NF__38D"
	strings:
		$1 = { 39 D0 74 6C 66 83 38 08 72 1B 50 52 66 81 38 00 01 74 08 50 E8 ?? ?? ?? ?? EB 08 83 C0 08 E8 ?? ?? ?? ?? 5A 58 66 83 3A 08 73 11 8B 0A 89 08 8B 4A 08 89 48 08 8B 4A 0C 89 48 0C C3 66 81 3A 00 01 75 19 8B 52 08 09 D2 74 09 8B 4A F8 41 7E 03 89 4A F8 66 C7 00 00 01 89 50 08 C3 66 C7 00 00 00 52 50 E8 ?? ?? ?? ?? 09 C0 0F 85 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_366_0 {
	meta:
		name = "_NF__393"
		size = 112
		refs = "002a _NF__18D 0033 _NF__38C 003a @VarClear"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B F9 8B F2 8B D8 66 81 3B 00 01 75 3B 66 C7 45 F0 00 00 57 6A 00 68 00 04 00 00 56 8D 45 F0 50 E8 ?? ?? ?? ?? 85 C0 74 05 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B 45 F0 89 03 8B 45 F8 89 43 08 8B 45 FC 89 43 0C EB 18 57 6A 00 68 00 04 00 00 56 53 E8 ?? ?? ?? ?? 85 C0 74 05 E8 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_367_0 {
	meta:
		name = "_NF__394"
		size = 45
		refs = "0013 OleStrToStrVar 001a @VarClear"
	strings:
		$1 = { 55 8B EC 51 53 8B D8 33 C0 89 45 FC 8B 42 08 8D 55 FC E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 66 C7 03 00 01 8B 45 FC 89 43 08 5B 59 5D C3 }
	condition:
		$1
}

rule function_368_0 {
	meta:
		name = "_NF__395"
		size = 32
		refs = "0008 StringToOleStr 0011 @VarClear"
	strings:
		$1 = { 53 56 8B D8 8B 42 08 E8 ?? ?? ?? ?? 8B F0 8B C3 E8 ?? ?? ?? ?? 66 C7 03 08 00 89 73 08 5E 5B C3 }
	condition:
		$1
}

rule function_369_0 {
	meta:
		name = "@VarCast"
		size = 241
		refs = "0019 @VarCopy 0033 _NF__395 004e @VarCast 0061 _NF__393 0076 @VarClear 007c @HandleFinally 0093 _NF__394"
	strings:
		$1 = { 55 8B EC 83 C4 EC 53 56 89 45 EC 66 8B 32 8B D9 66 3B DE 75 0D 8B 45 EC E8 ?? ?? ?? ?? E9 C9 00 00 00 66 81 FE 00 01 75 59 66 83 FB 08 75 0D 8B 45 EC E8 ?? ?? ?? ?? E9 AF 00 00 00 66 C7 45 F0 00 00 8D 45 F0 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8B 45 EC 8B CB E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 66 81 FB 00 01 75 58 66 83 FE 08 75 0A 8B 45 EC E8 ?? ?? ?? ?? EB 52 66 C7 45 F0 00 00 8D 45 F0 66 B9 08 00 E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 55 F0 8B 45 EC E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B 45 EC 8B CB E8 ?? ?? ?? ?? 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_370_0 {
	meta:
		name = "@VarCastOle"
		size = 20
		refs = "0009 _NF__38C 000f @VarCast"
	strings:
		$1 = { 81 F9 00 01 00 00 75 06 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_371_0 {
	meta:
		name = "@VarToInt"
		size = 106
		refs = "0036 @VarCast 0055 _NV__389"
	strings:
		$1 = { 31 D2 66 8B 10 83 FA 03 74 38 83 FA 02 74 37 83 FA 11 74 37 83 FA 05 74 47 83 FA 04 74 3D 83 FA 06 74 2D 83 EC 10 66 C7 04 24 00 00 89 C2 89 E0 B9 03 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 08 83 C4 10 C3 8B 40 08 C3 0F BF 40 08 C3 0F B6 40 08 C3 DF 68 08 D8 35 ?? ?? ?? ?? EB 08 D9 40 08 EB 03 DD 40 08 50 DB 1C 24 9B 58 C3 }
	condition:
		$1
}

rule function_372_0 {
	meta:
		name = "@VarToBool"
		size = 51
		refs = "0019 @VarCast"
	strings:
		$1 = { 66 83 38 0B 74 21 83 EC 10 66 C7 04 24 00 00 89 C2 89 E0 B9 0B 00 00 00 E8 ?? ?? ?? ?? 66 8B 44 24 08 83 C4 10 EB 04 66 8B 40 08 66 F7 D8 19 C0 F7 D8 C3 }
	condition:
		$1
}

rule function_373_0 {
	meta:
		name = "@VarToReal"
		size = 92
		refs = "0036 @VarCast 004f _NV__389"
	strings:
		$1 = { 31 D2 66 8B 10 83 FA 05 74 38 83 FA 04 74 37 83 FA 06 74 36 83 FA 03 74 3B 83 FA 02 74 3A 83 FA 07 74 1F 83 EC 10 66 C7 04 24 00 00 89 C2 89 E0 B9 05 00 00 00 E8 ?? ?? ?? ?? DD 44 24 08 83 C4 10 C3 DD 40 08 C3 D9 40 08 C3 DF 68 08 D8 35 ?? ?? ?? ?? C3 DB 40 08 C3 DF 40 08 C3 }
	condition:
		$1
}

rule function_374_0 {
	meta:
		name = "@VarToCurr"
		size = 90
		refs = "0031 @VarCast 0055 _NV__389"
	strings:
		$1 = { 31 D2 66 8B 10 83 FA 06 74 33 83 FA 05 74 32 83 FA 04 74 32 83 FA 03 74 32 83 FA 02 74 32 83 EC 10 66 C7 04 24 00 00 89 C2 89 E0 B9 06 00 00 00 E8 ?? ?? ?? ?? DF 6C 24 08 83 C4 10 C3 DF 68 08 C3 DD 40 08 EB 0D D9 40 08 EB 08 DB 40 08 EB 03 DF 40 08 D8 0D ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_375_0 {
	meta:
		name = "@VarToPStr"
		size = 78
		refs = "000c @VarToPStr 001a @VarToLStr 0029 @LStrToString 003e @LStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC E8 ?? ?? ?? ?? 8B C3 8B 55 FC B9 FF 00 00 00 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5B 59 5D C3 }
	condition:
		$1
}

rule function_376_0 {
	meta:
		name = "@VarToLStr"
		size = 57
		refs = "000b @LStrAsg 0023 @VarCast 002a @LStrClr"
	strings:
		$1 = { 66 81 3A 00 01 75 08 8B 52 08 E9 ?? ?? ?? ?? 53 89 C3 83 EC 10 66 C7 04 24 00 00 89 E0 B9 00 01 00 00 E8 ?? ?? ?? ?? 89 D8 E8 ?? ?? ?? ?? 8B 44 24 08 89 03 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_377_0 {
	meta:
		name = "@VarToWStr"
		size = 54
		refs = "000a @WStrAsg 0022 @VarCast 002d _NF__30F"
	strings:
		$1 = { 66 83 3A 08 75 08 8B 52 08 E9 ?? ?? ?? ?? 53 89 C3 83 EC 10 66 C7 04 24 00 00 89 E0 B9 08 00 00 00 E8 ?? ?? ?? ?? 89 D8 8B 54 24 08 E8 ?? ?? ?? ?? 83 C4 10 5B C3 }
	condition:
		$1
}

rule function_378_0 {
	meta:
		name = "@VarToIntf"
		size = 59
		refs = "0006 @IntfClear 0024 _NF__38C 002e @IntfCopy"
	strings:
		$1 = { 66 83 3A 00 0F 84 ?? ?? ?? ?? 66 83 3A 0D 74 22 66 83 3A 09 74 1C 66 81 3A 0D 40 74 0B 66 81 3A 09 40 0F 85 ?? ?? ?? ?? 8B 52 08 8B 12 E9 ?? ?? ?? ?? 8B 52 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_379_0 {
	meta:
		name = "@VarToDisp"
		size = 46
		refs = "0006 @IntfClear 0017 _NF__38C 0021 @IntfCopy"
	strings:
		$1 = { 66 83 3A 00 0F 84 ?? ?? ?? ?? 66 83 3A 09 74 15 66 81 3A 09 40 0F 85 ?? ?? ?? ?? 8B 52 08 8B 12 E9 ?? ?? ?? ?? 8B 52 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_380_0 {
	meta:
		name = "@VarFromInt"
		size = 24
		refs = "0009 @VarClear"
	strings:
		$1 = { 66 83 38 08 72 09 50 52 E8 ?? ?? ?? ?? 5A 58 66 C7 00 03 00 89 50 08 C3 }
	condition:
		$1
}

rule function_381_0 {
	meta:
		name = "@VarFromBool"
		size = 29
		refs = "0009 @VarClear"
	strings:
		$1 = { 66 83 38 08 72 09 50 52 E8 ?? ?? ?? ?? 5A 58 66 C7 00 0B 00 F6 DA 19 D2 66 89 50 08 C3 }
	condition:
		$1
}

rule function_382_0 {
	meta:
		name = "@VarFromReal"
		size = 23
		refs = "0008 @VarClear"
	strings:
		$1 = { 66 83 38 08 72 07 50 E8 ?? ?? ?? ?? 58 66 C7 00 05 00 DD 58 08 9B C3 }
	condition:
		$1
}

rule function_383_0 {
	meta:
		name = "@VarFromTDateTime"
		size = 23
		refs = "0008 @VarClear"
	strings:
		$1 = { 66 83 38 08 72 07 50 E8 ?? ?? ?? ?? 58 66 C7 00 07 00 DD 58 08 9B C3 }
	condition:
		$1
}

rule function_384_0 {
	meta:
		name = "@VarFromCurr"
		size = 23
		refs = "0008 @VarClear"
	strings:
		$1 = { 66 83 38 08 72 07 50 E8 ?? ?? ?? ?? 58 66 C7 00 06 00 DF 78 08 9B C3 }
	condition:
		$1
}

rule function_385_0 {
	meta:
		name = "@VarFromPStr"
		size = 79
		refs = "000f @VarFromPStr 001f @LStrFromString 0029 @VarFromLStr 003e @LStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D6 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_390_0 {
	meta:
		name = "@OleVarFromPStr"
		size = 79
		refs = "000f @OleVarFromPStr 001f @LStrFromString 0029 @OleVarFromLStr 003e @LStrClr 0044 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D6 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_386_0 {
	meta:
		name = "@VarFromLStr"
		size = 63
		refs = "0009 @VarClear 0024 @NewAnsiString 0030 Move"
	strings:
		$1 = { 66 83 38 08 72 09 50 52 E8 ?? ?? ?? ?? 5A 58 85 D2 74 23 8B 4A F8 41 7E 05 89 4A F8 EB 18 50 52 8B 42 FC E8 ?? ?? ?? ?? 89 C2 58 52 8B 4A FC E8 ?? ?? ?? ?? 5A 58 66 C7 00 00 01 89 50 08 C3 }
	condition:
		$1
}

rule function_387_0 {
	meta:
		name = "@VarFromWStr"
		size = 52
		refs = "0009 @VarClear 001e _NF__187 0026 _NF__30E"
	strings:
		$1 = { 50 66 83 38 08 72 07 52 E8 ?? ?? ?? ?? 5A 31 C0 85 D2 74 16 8B 42 FC D1 E8 74 0F 50 52 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 5A 66 C7 02 08 00 89 42 08 C3 }
	condition:
		$1
}

rule function_388_0 {
	meta:
		name = "@VarFromIntf"
		size = 34
		refs = "0009 @VarClear"
	strings:
		$1 = { 66 83 38 08 72 09 50 52 E8 ?? ?? ?? ?? 5A 58 66 C7 00 0D 00 89 50 08 85 D2 74 06 52 8B 02 FF 50 04 C3 }
	condition:
		$1
}

rule function_389_0 {
	meta:
		name = "@VarFromDisp"
		size = 34
		refs = "0009 @VarClear"
	strings:
		$1 = { 66 83 38 08 72 09 50 52 E8 ?? ?? ?? ?? 5A 58 66 C7 00 09 00 89 50 08 85 D2 74 06 52 8B 02 FF 50 04 C3 }
	condition:
		$1
}

rule function_391_0 {
	meta:
		name = "@OleVarFromLStr"
		size = 33
		refs = "0009 @VarClear 001c @WStrFromLStr"
	strings:
		$1 = { 66 83 38 08 72 09 50 52 E8 ?? ?? ?? ?? 5A 58 66 C7 00 08 00 83 C0 08 31 C9 89 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_392_0 {
	meta:
		name = "@OleVarFromVar"
		size = 47
		refs = "0007 @VarCopy 0014 @VarClear 002a @WStrFromLStr"
	strings:
		$1 = { 66 81 3A 00 01 0F 85 ?? ?? ?? ?? 66 83 38 08 72 09 50 52 E8 ?? ?? ?? ?? 5A 58 66 C7 00 08 00 83 C0 08 83 C2 08 31 C9 89 08 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_393_0 {
	meta:
		name = "_NF__3CE"
		size = 110
		refs = "0011 _NF__3CE 0021 @VarToLStr 0038 @LStrCat 0042 @VarFromLStr 005c @LStrArrayClr 0062 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D3 E8 ?? ?? ?? ?? 8D 45 FC 50 8D 45 F8 8B D6 E8 ?? ?? ?? ?? 8B 55 F8 58 E8 ?? ?? ?? ?? 8B 55 FC 8B C3 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_394_0 {
	meta:
		name = "_NF__3CF"
		size = 588
		refs = "003d _NV__387 004b _NV__388 0052 _NF__3CF 007f _NF__38D 0086 @VarClear 009c @VarToInt 00b5 @VarFromInt 0124 @VarToReal 0145 @VarFromReal 015a @VarToCurr 017b @VarFromCurr 01bb _NV__389 01fc _NF__3CE 020c @VarToBool 0225 @VarFromBool"
	strings:
		$1 = { 53 56 57 89 C7 89 D6 89 CB 8B 07 8B 16 25 FF 0F 00 00 81 E2 FF 0F 00 00 83 F8 11 76 0C 3D 00 01 00 00 75 57 B8 08 00 00 00 83 FA 11 76 0D 81 FA 00 01 00 00 75 45 BA 08 00 00 00 8A 80 ?? ?? ?? ?? 8A 92 ?? ?? ?? ?? 0F B6 8C C2 ?? ?? ?? ?? FF 14 8D ?? ?? ?? ?? 5F 5E 5B C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 58 5F 5E 5B E9 ?? ?? ?? ?? 89 F8 E8 ?? ?? ?? ?? 66 C7 07 01 00 C3 80 FB 03 0F 84 88 00 00 00 89 F0 E8 ?? ?? ?? ?? 50 89 F8 E8 ?? ?? ?? ?? 5A FF 14 9D ?? ?? ?? ?? 89 C2 89 F8 E9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 D0 70 2C C3 29 D0 70 27 C3 F7 EA 70 22 C3 89 D1 99 F7 F9 C3 89 D1 99 F7 F9 89 D0 C3 89 D1 D3 E0 C3 89 D1 D3 E8 C3 21 D0 C3 09 D0 C3 31 D0 C3 58 EB 09 80 FB 04 0F 83 78 FF FF FF 89 F0 E8 ?? ?? ?? ?? 83 EC 0C DB 3C 24 89 F8 E8 ?? ?? ?? ?? DB 2C 24 83 C4 0C FF 14 9D ?? ?? ?? ?? 89 F8 E9 ?? ?? ?? ?? 80 FB 04 0F 83 47 FF FF FF 80 FB 02 73 28 89 F0 E8 ?? ?? ?? ?? 83 EC 0C DB 3C 24 89 F8 E8 ?? ?? ?? ?? DB 2C 24 83 C4 0C FF 14 9D ?? ?? ?? ?? 89 F8 E9 ?? ?? ?? ?? 80 FA 04 74 15 89 F0 E8 ?? ?? ?? ?? DF 6F 08 D9 C9 FF 14 9D ?? ?? ?? ?? EB DF 80 FB 03 74 23 80 F8 04 74 0E 89 F8 E8 ?? ?? ?? ?? DF 6E 08 DE C9 EB C7 DF 6F 08 DF 6E 08 DE C9 D8 35 ?? ?? ?? ?? EB B7 89 F8 E8 ?? ?? ?? ?? DF 6E 08 DE F9 E9 70 FF FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? DE C1 C3 DE E9 C3 DE C9 C3 DE F9 C3 80 FB 00 0F 85 21 FF FF FF 89 F8 89 F2 E9 ?? ?? ?? ?? 80 FB 08 0F 82 0F FF FF FF 89 F0 E8 ?? ?? ?? ?? 50 89 F8 E8 ?? ?? ?? ?? 5A FF 14 9D ?? ?? ?? ?? 89 C2 89 F8 E9 ?? ?? ?? ?? 80 FB 01 0F 87 E6 FE FF FF 72 0C 88 D4 66 3D 07 07 0F 84 E1 FE FF FF E8 ?? ?? ?? ?? 66 C7 07 07 00 C3 C3 }
	condition:
		$1
}

rule function_397_0 {
	meta:
		name = "@VarMul"
		size = 11
		refs = "0006 _NF__3CF"
	strings:
		$1 = { B9 02 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_398_0 {
	meta:
		name = "@VarDiv"
		size = 11
		refs = "0006 _NF__3CF"
	strings:
		$1 = { B9 04 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_399_0 {
	meta:
		name = "@VarMod"
		size = 11
		refs = "0006 _NF__3CF"
	strings:
		$1 = { B9 05 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_400_0 {
	meta:
		name = "@VarAnd"
		size = 11
		refs = "0006 _NF__3CF"
	strings:
		$1 = { B9 08 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_401_0 {
	meta:
		name = "@VarOr"
		size = 11
		refs = "0006 _NF__3CF"
	strings:
		$1 = { B9 09 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_402_0 {
	meta:
		name = "@VarXor"
		size = 11
		refs = "0006 _NF__3CF"
	strings:
		$1 = { B9 0A 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_403_0 {
	meta:
		name = "@VarShl"
		size = 11
		refs = "0006 _NF__3CF"
	strings:
		$1 = { B9 06 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_404_0 {
	meta:
		name = "@VarShr"
		size = 11
		refs = "0006 _NF__3CF"
	strings:
		$1 = { B9 07 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_405_0 {
	meta:
		name = "@VarRDiv"
		size = 11
		refs = "0006 _NF__3CF"
	strings:
		$1 = { B9 03 00 00 00 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_406_0 {
	meta:
		name = "_NF__3DB"
		size = 47
	strings:
		$1 = { 56 57 89 C6 89 D7 09 C0 74 03 8B 40 FC 09 D2 74 03 8B 52 FC 89 C1 39 D1 76 02 89 D1 39 C9 F3 A6 74 08 0F B6 46 FF 0F B6 57 FF 29 D0 5F 5E C3 }
	condition:
		$1
}

rule function_407_0 {
	meta:
		name = "_NF__3DC"
		size = 104
		refs = "0011 _NF__3DC 0021 @VarToLStr 0038 _NF__3DB 0054 @LStrArrayClr 005a @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 6A 00 53 56 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 FC 8B D6 E8 ?? ?? ?? ?? 8B 45 FC 50 8D 45 F8 8B D3 E8 ?? ?? ?? ?? 8B 45 F8 5A E8 ?? ?? ?? ?? 8B D8 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F8 BA 02 00 00 00 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EB 8B C3 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_408_0 {
	meta:
		name = "@VarCmp"
		size = 252
		refs = "003a _NV__387 0048 _NV__388 004f @VarCmp 0076 _NF__38D 0082 @VarToInt 0094 @VarToReal 00c0 @VarToCurr 00de _NF__3DC 00eb @VarToBool"
	strings:
		$1 = { 56 57 89 C7 89 D6 8B 07 8B 16 25 FF 0F 00 00 81 E2 FF 0F 00 00 83 F8 11 76 0C 3D 00 01 00 00 75 52 B8 08 00 00 00 83 FA 11 76 0D 81 FA 00 01 00 00 75 40 BA 08 00 00 00 8A 80 ?? ?? ?? ?? 8A 92 ?? ?? ?? ?? 0F B6 8C C2 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 5F 5E E9 ?? ?? ?? ?? 38 D0 5F 5E C3 89 F0 E8 ?? ?? ?? ?? 97 E8 ?? ?? ?? ?? 39 F8 5F 5E C3 89 F8 E8 ?? ?? ?? ?? 83 EC 0C DB 3C 24 89 F0 E8 ?? ?? ?? ?? DB 2C 24 83 C4 0C DE D9 DF E0 88 E0 66 25 01 40 D0 C8 08 C4 9E 5F 5E C3 89 F8 E8 ?? ?? ?? ?? 83 EC 0C DB 3C 24 89 F0 E8 ?? ?? ?? ?? DB 2C 24 83 C4 0C EB D2 89 F8 89 F2 E8 ?? ?? ?? ?? 83 F8 00 5F 5E C3 89 F0 E8 ?? ?? ?? ?? 97 E8 ?? ?? ?? ?? 89 FA 38 D0 5F 5E C3 }
	condition:
		$1
}

rule function_409_0 {
	meta:
		name = "@VarNeg"
		size = 127
		refs = "001c _NV__387 0023 @VarNeg 0048 _NF__38D 004f @VarToInt 0059 @VarFromInt 005f @VarToReal 0067 @VarFromReal"
	strings:
		$1 = { 8B 10 81 E2 FF 0F 00 00 83 FA 11 76 0D 81 FA 00 01 00 00 75 32 BA 08 00 00 00 8A 92 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? C3 50 E8 ?? ?? ?? ?? F7 D8 89 C2 58 E9 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? D9 E0 58 E9 ?? ?? ?? ?? DF 68 08 D9 E0 DF 78 08 9B C3 DD 40 08 D9 E0 DD 58 08 9B C3 }
	condition:
		$1
}

rule function_410_0 {
	meta:
		name = "@VarNot"
		size = 70
		refs = "0023 @VarToInt 002d @VarFromInt 0032 _NF__38D"
	strings:
		$1 = { 8B 10 81 E2 FF 0F 00 00 74 27 83 FA 0B 74 27 83 FA 01 74 31 83 FA 11 76 08 81 FA 00 01 00 00 75 10 50 E8 ?? ?? ?? ?? F7 D0 89 C2 58 E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? 66 8B 50 08 66 F7 DA 19 D2 F7 D2 66 89 50 08 C3 }
	condition:
		$1
}

rule function_411_0 {
	meta:
		name = "@VarClr"
		size = 8
		refs = "0002 @VarClear"
	strings:
		$1 = { 50 E8 ?? ?? ?? ?? 58 C3 }
	condition:
		$1
}

rule function_412_0 {
	meta:
		name = "@VarAddRef"
		size = 33
		refs = "0019 @VarCopy"
	strings:
		$1 = { 66 83 38 08 72 1A FF 70 0C FF 70 08 FF 70 04 FF 30 66 C7 00 00 00 89 E2 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule function_413_0 {
	meta:
		name = "VarType"
		size = 4
	strings:
		$1 = { 0F B7 00 C3 }
	condition:
		$1
}

rule function_414_0 {
	meta:
		name = "VarAsType"
		size = 9
		refs = "0004 @VarCast"
	strings:
		$1 = { 91 87 CA E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_415_0 {
	meta:
		name = "VarIsEmpty"
		size = 33
	strings:
		$1 = { 66 83 38 00 74 18 66 8B 10 66 83 FA 09 74 06 66 83 FA 0D 75 06 83 78 08 00 74 03 33 C0 C3 B0 01 C3 }
	condition:
		$1
}

rule function_416_0 {
	meta:
		name = "VarIsNull"
		size = 8
	strings:
		$1 = { 66 83 38 01 0F 94 C0 C3 }
	condition:
		$1
}

rule function_417_0 {
	meta:
		name = "VarToStr"
		size = 34
		refs = "0011 @VarToLStr 001b @LStrClr"
	strings:
		$1 = { 53 56 8B F2 8B D8 66 83 3B 01 74 0C 8B C6 8B D3 E8 ?? ?? ?? ?? 5E 5B C3 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 }
	condition:
		$1
}

rule function_418_0 {
	meta:
		name = "VarFromDateTime"
		size = 35
		refs = "0009 @VarClear"
	strings:
		$1 = { 55 8B EC 53 8B D8 8B C3 E8 ?? ?? ?? ?? 66 C7 03 07 00 8B 45 08 89 43 08 8B 45 0C 89 43 0C 5B 5D C2 08 00 }
	condition:
		$1
}

rule function_419_0 {
	meta:
		name = "VarToDateTime"
		size = 46
		refs = "0017 @VarCast"
	strings:
		$1 = { 55 8B EC 83 C4 E8 66 C7 45 F0 00 00 8B D0 8D 45 F0 B9 07 00 00 00 E8 ?? ?? ?? ?? 8B 45 F8 89 45 E8 8B 45 FC 89 45 EC DD 45 E8 8B E5 5D C3 }
	condition:
		$1
}

rule function_420_0 {
	meta:
		name = "@WriteVariant"
		size = 98
		refs = "0012 @WriteVariant 0028 @VarToLStr 0034 @WriteLString 0039 @Flush 004e @LStrClr 0054 @HandleFinally"
	strings:
		$1 = { 55 8B EC 6A 00 53 56 57 8B F9 8B F2 8B D8 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 66 83 3E 02 72 0A 8D 45 FC 8B D6 E8 ?? ?? ?? ?? 8B C3 8B CF 8B 55 FC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 FC E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 8B C3 5F 5E 5B 59 5D C3 }
	condition:
		$1
}

rule function_421_0 {
	meta:
		name = "@Write0Variant"
		size = 8
		refs = "0003 @WriteVariant"
	strings:
		$1 = { 33 C9 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_422_0 {
	meta:
		name = "VarArrayCreate"
		size = 160
		refs = "0021 _NF__1EB 006a _NF__18E 007f @VarClear"
	strings:
		$1 = { 55 8B EC 81 C4 F4 FD FF FF 53 56 57 89 4D F8 8B DA 89 45 FC F6 C3 01 74 05 83 FB 7F 7E 07 B0 12 E8 ?? ?? ?? ?? 43 D1 FB 79 03 83 D3 00 89 5D F4 8B 5D F4 4B 85 DB 7C 22 43 8D 95 F4 FD FF FF 8B 45 FC 8B CA 8B 30 89 71 04 8B 78 04 2B FE 47 89 39 83 C0 08 83 C2 08 4B 75 E8 8D 85 F4 FD FF FF 50 8B 45 F4 50 8B 45 F8 50 E8 ?? ?? ?? ?? 8B D8 85 DB 75 07 B0 12 E8 ?? ?? ?? ?? 8B 45 08 E8 ?? ?? ?? ?? 66 8B 45 F8 66 0D 00 20 8B 55 08 66 89 02 8B 45 08 89 58 08 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule function_423_0 {
	meta:
		name = "VarArrayOf"
		size = 84
		refs = "0028 VarArrayCreate 003e @VarArrayPut"
	strings:
		$1 = { 53 56 57 55 83 C4 F4 8B E9 8B DA 89 04 24 55 33 C0 89 44 24 08 89 5C 24 0C 8D 44 24 08 B9 0C 00 00 00 BA 01 00 00 00 E8 ?? ?? ?? ?? 8B F3 85 F6 7C 1A 46 33 FF 8B 1C 24 57 6A 01 53 55 E8 ?? ?? ?? ?? 83 C4 10 47 83 C3 10 4E 75 EC 83 C4 0C 5D 5F 5E 5B C3 }
	condition:
		$1
}

rule function_424_0 {
	meta:
		name = "@VarArrayRedim"
		size = 76
		refs = "001a _NF__1EB 0037 _NF__18F"
	strings:
		$1 = { 53 56 57 83 C4 F8 8B FA 8B D8 66 8B 03 66 25 00 60 66 3D 00 20 74 07 B0 13 E8 ?? ?? ?? ?? 8B 73 08 8B C6 0F B7 10 8B 54 D0 0C 89 54 24 04 2B FA 47 89 3C 24 54 56 E8 ?? ?? ?? ?? 85 C0 74 07 B0 12 E8 ?? ?? ?? ?? 59 5A 5F 5E 5B C3 }
	condition:
		$1
}

rule function_425_0 {
	meta:
		name = "_NF__402"
		size = 34
		refs = "000c _NF__1EB"
	strings:
		$1 = { 53 8B D8 F6 43 01 20 75 07 B0 13 E8 ?? ?? ?? ?? F6 43 01 40 74 07 8B 43 08 8B 00 5B C3 8B 43 08 5B C3 }
	condition:
		$1
}

rule function_426_0 {
	meta:
		name = "VarArrayDimCount"
		size = 25
		refs = "000c _NF__402"
	strings:
		$1 = { 53 8B D8 F6 43 01 20 74 0C 8B C3 E8 ?? ?? ?? ?? 0F B7 00 5B C3 33 C0 5B C3 }
	condition:
		$1
}

rule function_427_0 {
	meta:
		name = "VarArrayLowBound"
		size = 40
		refs = "000c _NF__402 0012 _NF__190 001d _NF__1EB"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 54 56 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 07 B0 14 E8 ?? ?? ?? ?? 8B 04 24 5A 5E 5B C3 }
	condition:
		$1
}

rule function_428_0 {
	meta:
		name = "VarArrayHighBound"
		size = 40
		refs = "000c _NF__402 0012 _NF__191 001d _NF__1EB"
	strings:
		$1 = { 53 56 51 8B F2 8B D8 54 56 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 07 B0 14 E8 ?? ?? ?? ?? 8B 04 24 5A 5E 5B C3 }
	condition:
		$1
}

rule function_429_0 {
	meta:
		name = "VarArrayLock"
		size = 35
		refs = "0008 _NF__402 000e _NF__192 0019 _NF__1EB"
	strings:
		$1 = { 53 51 8B D8 54 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 07 B0 13 E8 ?? ?? ?? ?? 8B 04 24 5A 5B C3 }
	condition:
		$1
}

rule function_430_0 {
	meta:
		name = "VarArrayUnlock"
		size = 29
		refs = "0006 _NF__402 000c _NF__193 0017 _NF__1EB"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 74 07 B0 13 E8 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_431_0 {
	meta:
		name = "VarArrayRef"
		size = 60
		refs = "000f _NF__1EB 0016 @VarClear"
	strings:
		$1 = { 53 56 8B F2 8B D8 F6 43 01 20 75 07 B0 13 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 66 8B 03 66 0D 00 40 66 89 06 F6 43 01 40 74 09 8B 43 08 89 46 08 5E 5B C3 8D 43 08 89 46 08 5E 5B C3 }
	condition:
		$1
}

rule function_432_0 {
	meta:
		name = "VarIsArray"
		size = 8
	strings:
		$1 = { F6 40 01 20 0F 95 C0 C3 }
	condition:
		$1
}

rule function_433_0 {
	meta:
		name = "@VarArrayGet"
		size = 130
		refs = "0015 _NF__1EB 001c _NF__402 0040 @VarClear 0050 _NF__194"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 08 8B 75 0C F6 46 01 20 75 07 B0 13 E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? 8B D8 0F B7 03 3B 45 10 74 07 B0 14 E8 ?? ?? ?? ?? 66 8B 06 66 25 FF 0F 0F B7 C0 8B F0 8B C7 E8 ?? ?? ?? ?? 83 FE 0C 75 18 57 8D 45 14 50 53 E8 ?? ?? ?? ?? 85 C0 74 25 B0 14 E8 ?? ?? ?? ?? EB 1C 8D 47 08 50 8D 45 14 50 53 E8 ?? ?? ?? ?? 85 C0 74 07 B0 14 E8 ?? ?? ?? ?? 66 89 37 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule function_434_0 {
	meta:
		name = "@VarArrayPut"
		size = 235
		refs = "0018 _NF__1EB 001f _NF__402 0053 _NF__195 0072 @VarArrayPut 0087 _NF__395 0098 @VarCast 00d8 @VarClear 00de @HandleFinally"
	strings:
		$1 = { 55 8B EC 83 C4 F0 53 56 57 8B 7D 0C 8B 5D 08 F6 43 01 20 75 07 B0 13 E8 ?? ?? ?? ?? 8B C3 E8 ?? ?? ?? ?? 8B F0 0F B7 06 3B 45 10 74 07 B0 14 E8 ?? ?? ?? ?? 66 8B 03 66 25 FF 0F 0F B7 C0 8B D8 83 FB 0C 75 23 66 81 3F 00 01 74 1C 57 8D 45 14 50 56 E8 ?? ?? ?? ?? 85 C0 0F 84 85 00 00 00 B0 14 E8 ?? ?? ?? ?? EB 7C 66 C7 45 F0 00 00 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 FB 0C 75 0F 8B D7 8D 45 F0 E8 ?? ?? ?? ?? 8D 5D F0 EB 21 8B D7 8D 45 F0 8B CB E8 ?? ?? ?? ?? 83 C3 F8 83 EB 02 72 05 83 EB 03 75 05 8B 5D F8 EB 03 8D 5D F8 53 8D 45 14 50 56 E8 ?? ?? ?? ?? 85 C0 74 07 B0 14 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 F0 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F0 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule function_435_0 {
	meta:
		name = "FindHInstance"
		size = 38
		refs = "000c _NF__186"
	strings:
		$1 = { 83 C4 E4 6A 1C 8D 54 24 04 52 50 E8 ?? ?? ?? ?? 81 7C 24 10 00 10 00 00 75 06 8B 44 24 04 EB 02 33 C0 83 C4 1C C3 }
	condition:
		$1
}

rule function_437_0 {
	meta:
		name = "FindResourceHInstance"
		size = 26
		refs = "0002 LibModuleList"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 85 D2 74 0F 3B 42 04 75 04 8B 42 08 C3 8B 12 85 D2 75 F1 C3 }
	condition:
		$1
}

rule function_438_0 {
	meta:
		name = "LoadResourceModule"
		size = 448
		refs = "001d _NF__178 0031 LoadResourceModule 003b _NF__181 0070 _NF__182 00a4 _NF__180 00aa @HandleFinally 00bc _NF__17D 00c9 _NF__17A 00cf _NF__177 00fa _NF__17E 0141 _NF__17B"
	strings:
		$1 = { 55 8B EC 81 C4 E0 FE FF FF 53 56 89 45 FC 68 05 01 00 00 8D 85 E3 FE FF FF 50 6A 00 E8 ?? ?? ?? ?? C6 45 EE 00 8D 45 F8 50 68 3F 00 0F 00 6A 00 68 ?? ?? ?? ?? 68 01 00 00 80 E8 ?? ?? ?? ?? 85 C0 75 6D 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 C7 45 E8 05 00 00 00 8D 45 E8 50 8D 45 EE 50 6A 00 6A 00 8D 85 E3 FE FF FF 50 8B 45 F8 50 E8 ?? ?? ?? ?? 85 C0 74 1A 8D 45 E8 50 8D 45 EE 50 6A 00 6A 00 68 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 F8 50 E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB EF 8B 45 FC 50 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 6A 05 8D 45 F3 50 6A 03 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 F6 80 BD E3 FE FF FF 00 0F 84 AF 00 00 00 80 7D F3 00 75 0A 80 7D EE 00 0F 84 9F 00 00 00 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 8B D8 8D 85 E3 FE FF FF 03 D8 EB 01 4B 80 3B 2E 74 0A 8D 85 E3 FE FF FF 3B D8 75 F0 8D 85 E3 FE FF FF 3B D8 74 6D 43 80 7D EE 00 74 1C 8D 45 EE 50 53 E8 ?? ?? ?? ?? 6A 02 6A 00 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 8B F0 85 F6 75 46 80 7D F3 00 74 40 8D 45 F3 50 53 E8 ?? ?? ?? ?? 6A 02 6A 00 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 8B F0 85 F6 75 20 C6 45 F5 00 8D 45 F3 50 53 E8 ?? ?? ?? ?? 6A 02 6A 00 8D 85 E3 FE FF FF 50 E8 ?? ?? ?? ?? 8B F0 8B C6 5E 5B 8B E5 5D C3 00 00 00 53 6F 66 74 77 61 72 65 5C 42 6F 72 6C 61 6E 64 5C 44 65 6C 70 68 69 5C 4C 6F 63 61 6C 65 73 00 00 00 00 00 }
	condition:
		$1
}

rule function_439_0 {
	meta:
		name = "EnumModules"
		size = 38
		refs = "0009 LibModuleList"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B 1D ?? ?? ?? ?? 85 DB 74 11 8B D7 8B 43 04 FF D6 84 C0 74 06 8B 1B 85 DB 75 EF 5F 5E 5B C3 }
	condition:
		$1
}

rule function_440_0 {
	meta:
		name = "EnumResourceModules"
		size = 38
		refs = "0009 LibModuleList"
	strings:
		$1 = { 53 56 57 8B FA 8B F0 8B 1D ?? ?? ?? ?? 85 DB 74 11 8B D7 8B 43 08 FF D6 84 C0 74 06 8B 1B 85 DB 75 EF 5F 5E 5B C3 }
	condition:
		$1
}

rule function_441_0 {
	meta:
		name = "AddModuleUnloadProc"
		size = 31
		refs = "0009 @GetMem 000f ModuleUnloadList"
	strings:
		$1 = { 53 8B D8 B8 08 00 00 00 E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 89 10 89 58 04 A3 ?? ?? ?? ?? 5B C3 }
	condition:
		$1
}

rule function_442_0 {
	meta:
		name = "RemoveModuleUnloadProc"
		size = 94
		refs = "0004 ModuleUnloadList 0027 @FreeMem"
	strings:
		$1 = { 53 56 8B 35 ?? ?? ?? ?? 85 F6 74 22 8B 56 04 3B D0 75 1B A1 ?? ?? ?? ?? 8B 00 A3 ?? ?? ?? ?? BA 08 00 00 00 8B C6 E8 ?? ?? ?? ?? 5E 5B C3 8B D6 85 D2 74 27 8B 0A 85 C9 74 1B 8B 59 04 3B D8 75 14 8B F1 8B 01 89 02 BA 08 00 00 00 8B C6 E8 ?? ?? ?? ?? EB 06 8B 12 85 D2 75 D9 5E 5B C3 }
	condition:
		$1
}

rule function_443_0 {
	meta:
		name = "_NF__42E"
		size = 90
		refs = "000d ModuleUnloadList 001e _NF__42E 003c @HandleAnyException 0041 @DoneExcept"
	strings:
		$1 = { 55 8B EC 83 C4 F8 53 56 57 89 45 FC A1 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 39 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8B 5D F8 8B 45 FC FF 53 04 33 C0 5A 59 59 64 89 10 EB 0A E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 F8 8B 00 89 45 F8 83 7D F8 00 75 C7 5F 5E 5B 59 59 5D C3 }
	condition:
		$1
}

rule function_444_0 {
	meta:
		name = "RegisterModule"
		size = 14
		refs = "0002 LibModuleList"
	strings:
		$1 = { 8B 15 ?? ?? ?? ?? 89 10 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_445_0 {
	meta:
		name = "UnregisterModule"
		size = 110
		refs = "000b UnregisterModule 001c _NF__42E 0032 LibModuleList 0065 @HandleFinally"
	strings:
		$1 = { 55 8B EC 51 89 45 FC 33 D2 55 68 ?? ?? ?? ?? 64 FF 32 64 89 22 8B 45 FC 8B 40 04 E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 FC 3B 05 ?? ?? ?? ?? 75 0C 8B 45 FC 8B 00 A3 ?? ?? ?? ?? EB 1F A1 ?? ?? ?? ?? 85 C0 74 16 8B 10 3B 55 FC 75 09 8B 55 FC 8B 12 89 10 EB 06 8B 00 85 C0 75 EA C3 E9 ?? ?? ?? ?? EB C2 59 5D C3 }
	condition:
		$1
}

rule function_446_0 {
	meta:
		name = "LoadResString"
		size = 65
		refs = "0023 FindResourceHInstance 0029 _NF__17C 0034 @LStrFromPCharLen"
	strings:
		$1 = { 53 56 81 C4 00 FC FF FF 8B F2 8B D8 85 DB 74 28 68 00 04 00 00 8D 44 24 04 50 8B 43 04 50 8B 03 8B 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B C8 8B D4 8B C6 E8 ?? ?? ?? ?? 81 C4 00 04 00 00 5E 5B C3 }
	condition:
		$1
}

rule function_447_0 {
	meta:
		name = "@IntfClear"
		size = 21
	strings:
		$1 = { 8B 10 85 D2 74 0E C7 00 00 00 00 00 50 52 8B 02 FF 50 08 58 C3 }
	condition:
		$1
}

rule function_448_0 {
	meta:
		name = "@IntfCopy"
		size = 27
	strings:
		$1 = { 8B 08 89 10 85 D2 74 08 51 52 8B 02 FF 50 04 59 85 C9 74 06 51 8B 01 FF 50 08 C3 }
	condition:
		$1
}

rule function_449_0 {
	meta:
		name = "@IntfCast"
		size = 42
		refs = "0004 @IntfClear 0025 _NF__1EB"
	strings:
		$1 = { 85 D2 0F 84 ?? ?? ?? ?? 50 51 52 8B 08 85 C9 74 09 51 8B 01 FF 50 08 8B 14 24 8B 02 FF 10 85 C0 74 07 B0 17 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_450_0 {
	meta:
		name = "@IntfAddRef"
		size = 11
	strings:
		$1 = { 85 C0 74 06 50 8B 00 FF 50 04 C3 }
	condition:
		$1
}

rule function_451_0 {
	meta:
		name = "TInterfacedObject.QueryInterface"
		size = 38
		refs = "0010 TObject.GetInterface"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 8B 4D 10 8B 55 0C 8B C3 E8 ?? ?? ?? ?? 84 C0 74 04 33 C0 EB 05 B8 02 40 00 80 5B 5D C2 0C 00 }
	condition:
		$1
}

rule function_452_0 {
	meta:
		name = "TInterfacedObject._AddRef"
		size = 16
	strings:
		$1 = { 55 8B EC 8B 45 08 FF 40 08 8B 40 08 5D C2 04 00 }
	condition:
		$1
}

rule function_453_0 {
	meta:
		name = "TInterfacedObject._Release"
		size = 33
	strings:
		$1 = { 55 8B EC 8B 45 08 FF 48 08 83 78 08 00 75 0B B2 01 8B 08 FF 51 FC 33 C0 EB 03 8B 40 08 5D C2 04 00 }
	condition:
		$1
}

rule function_454_0 {
	meta:
		name = "@CheckAutoResult"
		size = 27
		refs = "0006 SafeCallErrorProc 0016 _NF__1EB"
	strings:
		$1 = { 85 C0 79 16 8B 0D ?? ?? ?? ?? 85 C9 74 05 8B 14 24 FF D1 B0 18 E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_457_0 {
	meta:
		name = "_NF__44B"
		size = 514
		refs = "0016 _NF__169 0022 _NF__176 0049 _NF__16D 0066 _NF__160 00a6 _NF__44B 00fc _NF__161 0120 _NF__165 013c _NF__16C 0190 _NF__16B 01b0 _NF__166 01c7 _NF__163"
	strings:
		$1 = { 33 D2 89 50 10 89 50 0C 52 8D 50 10 52 FF 70 08 FF 70 14 FF 30 E8 ?? ?? ?? ?? 85 C0 74 03 33 C0 C3 E8 ?? ?? ?? ?? 83 F8 6D 74 F3 C3 33 C0 C3 51 8B 50 0C 85 D2 7E 1A 33 C9 89 48 0C 51 8D 4C 24 04 51 52 FF 70 14 FF 30 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 59 C3 E8 ?? ?? ?? ?? EB F7 FF 30 C7 40 04 B0 D7 00 00 E8 ?? ?? ?? ?? 48 75 01 C3 E8 ?? ?? ?? ?? C3 56 8B F0 33 C0 89 46 0C 89 46 10 8B 46 04 2D B1 D7 00 00 74 0B 48 74 20 48 74 2E E9 49 01 00 00 B8 00 00 00 80 BA 01 00 00 00 B9 03 00 00 00 C7 46 1C ?? ?? ?? ?? EB 27 B8 00 00 00 40 BA 01 00 00 00 B9 02 00 00 00 EB 0F B8 00 00 00 C0 BA 01 00 00 00 B9 03 00 00 00 C7 46 1C ?? ?? ?? ?? C7 46 24 ?? ?? ?? ?? C7 46 20 ?? ?? ?? ?? 80 7E 48 00 0F 84 AE 00 00 00 6A 00 68 80 00 00 00 51 6A 00 52 50 8D 46 48 50 E8 ?? ?? ?? ?? 83 F8 FF 0F 84 EB 00 00 00 89 06 81 7E 04 B3 D7 00 00 0F 85 A3 00 00 00 FF 4E 04 6A 00 FF 36 E8 ?? ?? ?? ?? 40 0F 84 C9 00 00 00 2D 81 00 00 00 73 02 33 C0 6A 00 6A 00 50 FF 36 E8 ?? ?? ?? ?? 40 0F 84 AD 00 00 00 6A 00 8B D4 6A 00 52 68 80 00 00 00 8D 96 4C 01 00 00 52 FF 36 E8 ?? ?? ?? ?? 5A 48 0F 85 8B 00 00 00 33 C0 3B C2 73 4C 80 BC 06 4C 01 00 00 1A 74 03 40 EB EF 6A 02 6A 00 2B C2 50 FF 36 E8 ?? ?? ?? ?? 40 74 67 FF 36 E8 ?? ?? ?? ?? 48 75 5D EB 22 C7 46 24 ?? ?? ?? ?? 81 7E 04 B2 D7 00 00 74 04 6A F6 EB 02 6A F5 E8 ?? ?? ?? ?? 83 F8 FF 74 3B 89 06 81 7E 04 B1 D7 00 00 74 17 FF 36 E8 ?? ?? ?? ?? 85 C0 74 10 83 F8 02 75 07 C7 46 20 ?? ?? ?? ?? 33 C0 5E C3 FF 36 E8 ?? ?? ?? ?? C7 46 04 B0 D7 00 00 B8 69 00 00 00 EB E9 C7 46 04 B0 D7 00 00 E8 ?? ?? ?? ?? EB DB }
	condition:
		$1
}

rule function_458_0 {
	meta:
		name = "@Assign"
		size = 86
		refs = "0024 _NF__44B"
	strings:
		$1 = { 8D 88 4C 01 00 00 89 48 14 33 C9 89 08 C7 40 04 B0 D7 00 00 C7 40 08 80 00 00 00 89 48 0C 89 48 10 C7 40 18 ?? ?? ?? ?? 89 48 1C 89 48 20 89 48 24 8D 40 48 85 D2 74 1B B5 82 8A 0A 42 88 08 40 84 C9 74 11 8A 0A 42 88 08 40 84 C9 74 07 FE CD 75 E8 48 88 28 C3 }
	condition:
		$1
}

rule function_459_0 {
	meta:
		name = "@_Flush"
		size = 37
		refs = "0021 _NF__1ED"
	strings:
		$1 = { 8B 50 04 81 FA B2 D7 00 00 75 08 FF 50 1C 85 C0 75 0E C3 81 FA B1 D7 00 00 74 F7 B8 67 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule function_460_0 {
	meta:
		name = "@Flush"
		size = 37
		refs = "0021 _NF__1ED"
	strings:
		$1 = { 8B 50 04 81 FA B2 D7 00 00 75 08 FF 50 20 85 C0 75 0E C3 81 FA B1 D7 00 00 74 F7 B8 67 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule function_461_0 {
	meta:
		name = "@BlockRead"
		size = 99
		refs = "0026 _NF__169 004f _NF__176 0054 _NF__1ED"
	strings:
		$1 = { 53 56 8B D8 8B F2 8B 53 04 81 EA B1 D7 00 00 83 FA 02 77 48 51 6A 00 8B C4 6A 00 50 8B 43 08 F7 E1 50 56 FF 33 E8 ?? ?? ?? ?? 48 58 59 75 1F 33 D2 F7 73 08 8B 54 24 0C 85 D2 74 07 89 02 5E 5B C2 04 00 3B C1 74 F7 B8 64 00 00 00 EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 EB E2 B8 67 00 00 00 EB F0 }
	condition:
		$1
}

rule function_462_0 {
	meta:
		name = "@BlockWrite"
		size = 98
		refs = "0025 _NF__16D 004e _NF__176 0053 _NF__1ED"
	strings:
		$1 = { 53 56 8B D8 8B F2 8B 40 04 2D B2 D7 00 00 83 F8 01 77 48 51 6A 00 8B C4 6A 00 50 8B 43 08 F7 E1 50 56 FF 33 E8 ?? ?? ?? ?? 48 58 59 75 1F 33 D2 F7 73 08 8B 54 24 0C 85 D2 74 07 89 02 5E 5B C2 04 00 3B C1 74 F7 B8 65 00 00 00 EB 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 EB E2 B8 67 00 00 00 EB F0 }
	condition:
		$1
}

rule function_463_0 {
	meta:
		name = "@Close"
		size = 58
		refs = "0026 _NF__1ED 002d Input"
	strings:
		$1 = { 53 8B D8 8B 50 04 81 EA B1 D7 00 00 74 0E 83 FA 02 77 19 FF 50 1C 85 C0 75 0B 8B C3 FF 53 24 85 C0 75 02 5B C3 E8 ?? ?? ?? ?? EB F7 3D ?? ?? ?? ?? 74 F0 B8 67 00 00 00 EB EB }
	condition:
		$1
}

rule function_464_0 {
	meta:
		name = "@EofFile"
		size = 81
		refs = "0016 _NF__165 0029 _NF__16C 003b _NF__1EE 0049 _NF__1ED"
	strings:
		$1 = { 53 8B D8 8B 53 04 81 EA B1 D7 00 00 83 FA 02 77 32 6A 00 FF 33 E8 ?? ?? ?? ?? 83 F8 FF 74 1B 50 6A 01 6A 00 6A 00 FF 33 E8 ?? ?? ?? ?? 83 F8 FF 74 08 5A 3B C2 0F 93 C0 5B C3 E8 ?? ?? ?? ?? B0 01 EB F5 B8 67 00 00 00 E8 ?? ?? ?? ?? B0 FF EB E7 }
	condition:
		$1
}

rule function_465_0 {
	meta:
		name = "@EofText"
		size = 50
		refs = "0023 @ReadChar"
	strings:
		$1 = { 81 78 04 B1 D7 00 00 75 18 8B 50 0C 3B 50 10 73 10 03 50 14 B0 00 8A 0A 80 F9 1A 74 01 C3 B0 01 C3 50 E8 ?? ?? ?? ?? 5A 3C 1A 74 F2 FF 4A 0C B0 00 C3 }
	condition:
		$1
}

rule function_466_0 {
	meta:
		name = "@Eoln"
		size = 59
		refs = "0028 @ReadChar"
	strings:
		$1 = { 81 78 04 B1 D7 00 00 75 1D 8B 50 0C 3B 50 10 73 15 03 50 14 B0 00 8A 0A 80 F9 0D 74 06 80 F9 1A 74 01 C3 B0 01 C3 50 E8 ?? ?? ?? ?? 5A 3C 1A 74 F2 FF 4A 0C 3C 0D 74 EB B0 00 C3 }
	condition:
		$1
}

rule function_467_0 {
	meta:
		name = "@Erase"
		size = 46
		refs = "0013 _NF__162 001c _NF__176 0021 _NF__1ED"
	strings:
		$1 = { 8B 50 04 81 EA B0 D7 00 00 83 FA 03 77 19 8D 40 48 50 E8 ?? ?? ?? ?? 48 75 01 C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB F3 B8 66 00 00 00 EB F2 }
	condition:
		$1
}

rule function_468_0 {
	meta:
		name = "_NF__45A"
		size = 120
		refs = "0036 TestFDIV 0044 _NF__45A"
	strings:
		$1 = { 00 01 00 00 04 00 00 07 00 00 0A 00 00 0D 00 00 00 00 70 3F 00 00 88 3F 00 00 00 5F 00 00 00 C0 7E 01 50 41 00 00 00 80 FF FF 47 41 00 00 00 00 00 00 F0 3F C6 05 ?? ?? ?? ?? 01 50 83 EC 0C DB 3C 24 DD 05 ?? ?? ?? ?? DC 35 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DC 2D ?? ?? ?? ?? DC 1D ?? ?? ?? ?? 9B DF E0 C1 E8 07 83 E0 02 48 A2 ?? ?? ?? ?? DB 2C 24 83 C4 0C 58 EB 02 }
	condition:
		$1
}

rule function_470_0 {
	meta:
		name = "@FSafeDivide"
		size = 230
		refs = "0002 TestFDIV 0040 _NF__45A"
	strings:
		$1 = { 80 3D ?? ?? ?? ?? 00 7E 03 DE F9 C3 74 AC 50 83 EC 18 DB 7C 24 0C DB 3C 24 DB 2C 24 DB 6C 24 0C 8B 44 24 10 03 C0 73 63 35 00 00 00 0E A9 00 00 00 0E 74 07 DE F9 83 C4 18 58 C3 C1 E8 1C 80 B8 ?? ?? ?? ?? 00 74 ED 8B 44 24 14 25 FF 7F 00 00 74 E2 3D FF 7F 00 00 74 DB 8B 44 24 08 25 FF 7F 00 00 83 F8 01 74 12 D8 0D ?? ?? ?? ?? D9 C9 D8 0D ?? ?? ?? ?? D9 C9 EB BB D8 0D ?? ?? ?? ?? D9 C9 D8 0D ?? ?? ?? ?? D9 C9 EB A9 8B 44 24 0C 0B 44 24 10 74 9F 8B 44 24 14 25 FF 7F 00 00 75 94 8B 44 24 08 25 FF 7F 00 00 74 15 3D FF 7F 00 00 74 82 8B 44 24 04 03 C0 0F 83 76 FF FF FF EB 0C 8B 44 24 04 03 C0 0F 82 68 FF FF FF D9 C9 DD D8 D9 C0 D8 0D ?? ?? ?? ?? DB 7C 24 0C DB 2C 24 D9 C9 E9 3A FF FF FF }
	condition:
		$1
}

rule function_471_0 {
	meta:
		name = "@FilePos"
		size = 67
		refs = "001a _NF__16C 002b _NF__1EE 003a _NF__1ED"
	strings:
		$1 = { 53 8B D8 8B 53 04 81 EA B1 D7 00 00 83 FA 02 77 23 6A 01 6A 00 6A 00 FF 33 E8 ?? ?? ?? ?? 83 F8 FF 74 07 33 D2 F7 73 08 5B C3 E8 ?? ?? ?? ?? 83 C8 FF EB F4 B8 67 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB E5 }
	condition:
		$1
}

rule function_472_0 {
	meta:
		name = "@FileSize"
		size = 63
		refs = "0016 _NF__165 0027 _NF__1EE 0036 _NF__1ED"
	strings:
		$1 = { 53 8B D8 8B 53 04 81 EA B1 D7 00 00 83 FA 02 77 1F 6A 00 FF 33 E8 ?? ?? ?? ?? 83 F8 FF 74 07 33 D2 F7 73 08 5B C3 E8 ?? ?? ?? ?? 83 C8 FF EB F4 B8 67 00 00 00 E8 ?? ?? ?? ?? 83 C8 FF EB E5 }
	condition:
		$1
}

rule function_473_0 {
	meta:
		name = "@ReadRec"
		size = 74
		refs = "0021 _NF__169 0031 _NF__176 0036 _NF__1ED"
	strings:
		$1 = { 53 8B D8 8B 4B 04 81 E9 B1 D7 00 00 74 05 83 E9 02 75 29 6A 00 8B C4 6A 00 50 FF 73 08 52 FF 33 E8 ?? ?? ?? ?? 5A 48 75 07 3B 53 08 75 15 5B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB F2 B8 67 00 00 00 EB F2 B8 64 00 00 00 EB EB }
	condition:
		$1
}

rule function_474_0 {
	meta:
		name = "@ReadChar"
		size = 115
		refs = "0024 Input 0030 _NF__1ED 0038 @ResetText"
	strings:
		$1 = { 81 78 04 B1 D7 00 00 75 1A 8B 50 0C 3B 50 10 73 3B 8B 48 14 8A 0C 11 80 F9 1A 74 04 42 89 50 0C 8A C1 C3 3D ?? ?? ?? ?? 74 0D B8 68 00 00 00 E8 ?? ?? ?? ?? B0 1A C3 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? 81 78 04 B1 D7 00 00 74 BF EB DE 50 FF 50 1C 85 C0 75 16 58 8B 50 0C 3B 50 10 72 B4 8B 48 14 C6 04 11 1A FF 40 10 B0 1A C3 E8 ?? ?? ?? ?? 58 B0 1A C3 }
	condition:
		$1
}

rule function_475_0 {
	meta:
		name = "@ReadLong"
		size = 85
		refs = "0009 @SeekEof 0018 @ReadChar 002e @ValLong 003d _NF__1ED"
	strings:
		$1 = { 53 56 57 83 EC 24 8B F0 E8 ?? ?? ?? ?? FE C8 74 40 8B FC B3 20 8B C6 E8 ?? ?? ?? ?? 3C 20 76 28 AA FE CB 75 F0 C6 07 00 8B C4 52 8B D4 E8 ?? ?? ?? ?? 5A 85 D2 74 0A B8 6A 00 00 00 E8 ?? ?? ?? ?? 83 C4 24 5F 5E 5B C3 3C 1A 74 D9 FF 4E 0C EB D4 33 C0 EB EC }
	condition:
		$1
}

rule function_476_0 {
	meta:
		name = "@ReadString"
		size = 11
	strings:
		$1 = { 52 42 E8 10 00 00 00 5A 88 0A C3 }
	condition:
		$1
}

rule function_477_0 {
	meta:
		name = "@ReadCString"
		size = 138
		refs = "0056 @ReadChar 0068 Input 0074 _NF__1ED 007b @ResetText"
	strings:
		$1 = { 52 E8 06 00 00 00 5A C6 04 0A 00 C3 53 56 57 51 8B D8 8B F1 8B FA 81 7B 04 B1 D7 00 00 75 48 85 F6 7E 26 8B 53 0C 8B 4B 10 2B CA 03 53 14 49 7C 1F 8A 02 42 3C 1A 74 11 3C 0D 74 06 AA 4E 7F EE EB 01 4A 2B 53 14 89 53 0C 59 2B CE 5F 5E 5B C3 89 53 0C 8B C3 E8 ?? ?? ?? ?? 8B 53 0C 8B 4B 10 2B CA 03 53 14 EB CD 3D ?? ?? ?? ?? 74 0C B8 68 00 00 00 E8 ?? ?? ?? ?? EB CF E8 ?? ?? ?? ?? 81 7B 04 B1 D7 00 00 74 97 EB E4 }
	condition:
		$1
}

rule function_478_0 {
	meta:
		name = "@ReadExt"
		size = 85
		refs = "0009 @SeekEof 0018 @ReadChar 002e @ValExt 003d _NF__1ED"
	strings:
		$1 = { 53 56 57 83 EC 44 8B F0 E8 ?? ?? ?? ?? FE C8 74 40 8B FC B3 40 8B C6 E8 ?? ?? ?? ?? 3C 20 76 28 AA FE CB 75 F0 C6 07 00 8B C4 52 8B D4 E8 ?? ?? ?? ?? 5A 85 D2 74 0A B8 6A 00 00 00 E8 ?? ?? ?? ?? 83 C4 44 5F 5E 5B C3 3C 1A 74 D9 FF 4E 0C EB D4 D9 EE EB EC }
	condition:
		$1
}

rule function_479_0 {
	meta:
		name = "@ReadLn"
		size = 40
		refs = "0006 @ReadChar"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 1A 74 18 3C 0D 75 F1 8B C3 E8 ?? ?? ?? ?? 3C 0A 74 07 3C 1A 74 05 FF 4B 0C 5B C3 5B C3 }
	condition:
		$1
}

rule function_480_0 {
	meta:
		name = "@Rename"
		size = 82
		refs = "000e @Rename 001a _NF__167 0041 _NF__176 0046 _NF__1ED"
	strings:
		$1 = { 81 78 04 B0 D7 00 00 75 41 85 D2 75 05 BA ?? ?? ?? ?? 8D 40 48 52 50 52 50 E8 ?? ?? ?? ?? 48 58 5A 75 1D B5 82 8A 0A 42 88 08 40 84 C9 74 10 8A 0A 42 88 08 40 84 C9 74 06 FE CD 75 E8 88 28 C3 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? B8 66 00 00 00 EB F4 00 }
	condition:
		$1
}

rule function_481_0 {
	meta:
		name = "_NF__467"
		size = 59
		refs = "0017 @Close 0028 _NF__1ED"
	strings:
		$1 = { 53 56 8B F0 8B DA 8B 56 04 81 EA B0 D7 00 00 74 0A 83 FA 03 77 19 E8 ?? ?? ?? ?? 8B C6 89 5E 04 FF 56 18 85 C0 74 05 E8 ?? ?? ?? ?? 5E 5B C3 B8 66 00 00 00 E8 ?? ?? ?? ?? EB F1 }
	condition:
		$1
}

rule function_482_0 {
	meta:
		name = "@ResetText"
		size = 7
	strings:
		$1 = { BA B1 D7 00 00 EB BE }
	condition:
		$1
}

rule function_483_0 {
	meta:
		name = "@RewritText"
		size = 7
	strings:
		$1 = { BA B2 D7 00 00 EB B7 }
	condition:
		$1
}

rule function_484_0 {
	meta:
		name = "@Append"
		size = 7
	strings:
		$1 = { BA B3 D7 00 00 EB B0 }
	condition:
		$1
}

rule function_485_0 {
	meta:
		name = "_NF__46D"
		size = 257
		refs = "0025 _NF__1ED 0036 _NF__46D 004e FileMode 009c _NF__161 00c1 _NF__166 00d6 _NF__176"
	strings:
		$1 = { 53 56 57 8B D8 8B F2 8B F9 8B 53 04 81 EA B0 D7 00 00 74 15 83 FA 03 0F 87 AA 00 00 00 FF 53 24 85 C0 74 05 E8 ?? ?? ?? ?? C7 43 04 B3 D7 00 00 89 73 08 C7 43 24 ?? ?? ?? ?? C7 43 1C ?? ?? ?? ?? 80 7B 48 00 74 67 B8 00 00 00 C0 8A 15 ?? ?? ?? ?? 83 E2 70 C1 EA 02 8B 92 ?? ?? ?? ?? B9 02 00 00 00 83 EF 03 74 23 B9 03 00 00 00 47 74 1B B8 00 00 00 40 47 C7 43 04 B2 D7 00 00 74 0C B8 00 00 00 80 C7 43 04 B1 D7 00 00 6A 00 68 80 00 00 00 51 6A 00 52 50 8D 43 48 50 E8 ?? ?? ?? ?? 83 F8 FF 74 29 89 03 5F 5E 5B C3 33 C0 C3 C7 43 24 ?? ?? ?? ?? 83 FF 03 74 04 6A F6 EB 02 6A F5 E8 ?? ?? ?? ?? EB D9 B8 66 00 00 00 EB 0C C7 43 04 B0 D7 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB C6 03 00 00 00 00 00 00 00 01 00 00 00 02 00 00 00 03 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule function_486_0 {
	meta:
		name = "@ResetFile"
		size = 23
		refs = "0004 FileMode"
	strings:
		$1 = { 33 C9 8A 0D ?? ?? ?? ?? 80 E1 03 80 F9 02 76 02 B1 02 E9 E8 FE FF FF }
	condition:
		$1
}

rule function_487_0 {
	meta:
		name = "@RewritFile"
		size = 32
		refs = "0014 _NF__160 001b _NF__1EE"
	strings:
		$1 = { B9 03 00 00 00 E9 DE FE FF FF FF 30 C7 40 04 B0 D7 00 00 E8 ?? ?? ?? ?? 48 0F 85 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule function_488_0 {
	meta:
		name = "@Seek"
		size = 50
		refs = "001c _NF__16C 0023 _NF__1EE 002e _NF__1ED"
	strings:
		$1 = { 8B C8 8B 41 04 2D B1 D7 00 00 83 F8 02 77 19 6A 00 8B 41 08 F7 E2 6A 00 50 FF 31 E8 ?? ?? ?? ?? 40 0F 84 ?? ?? ?? ?? C3 B8 67 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule function_489_0 {
	meta:
		name = "@SeekEof"
		size = 31
		refs = "0006 @ReadChar"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 20 77 06 3C 1A 74 09 EB EF FF 4B 0C 5B B0 00 C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_490_0 {
	meta:
		name = "@SeekEoln"
		size = 37
		refs = "0006 @ReadChar"
	strings:
		$1 = { 53 8B D8 8B C3 E8 ?? ?? ?? ?? 3C 20 77 0C 3C 1A 74 0F 3C 0D 75 ED B0 01 EB 02 B0 00 FF 4B 0C 5B C3 B0 01 5B C3 }
	condition:
		$1
}

rule function_491_0 {
	meta:
		name = "@SetTextBuf"
		size = 15
	strings:
		$1 = { 89 50 14 33 D2 89 48 08 89 50 0C 89 50 10 C3 }
	condition:
		$1
}

rule function_492_0 {
	meta:
		name = "@Truncate"
		size = 39
		refs = "0011 _NF__16B 0018 _NF__1EE 0023 _NF__1ED"
	strings:
		$1 = { 8B 50 04 81 EA B1 D7 00 00 83 FA 02 77 0F FF 30 E8 ?? ?? ?? ?? 48 0F 85 ?? ?? ?? ?? C3 B8 67 00 00 00 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule function_493_0 {
	meta:
		name = "@WriteRec"
		size = 73
		refs = "001e _NF__16D 0030 _NF__176 0035 _NF__1ED"
	strings:
		$1 = { 53 8B D8 8B 40 04 2D B2 D7 00 00 83 F8 01 77 2B 6A 00 8B C4 6A 00 50 FF 73 08 52 FF 33 E8 ?? ?? ?? ?? 5A 48 75 09 3B 53 08 75 17 8B C3 5B C3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB F0 B8 05 00 00 00 EB F2 B8 65 00 00 00 EB EB }
	condition:
		$1
}

rule function_494_0 {
	meta:
		name = "_NF__476"
		size = 107
		refs = "003c Output 0046 @RewritText 005c _NF__1ED"
	strings:
		$1 = { 56 57 8B F2 81 78 04 B2 D7 00 00 75 2E 8B 78 14 03 78 0C 8B 50 08 2B 50 0C 3B D1 7F 16 01 50 0C 2B CA 50 51 8B CA F3 A4 FF 50 1C 85 C0 75 33 59 58 EB DA 01 48 0C F3 A4 5F 5E C3 3D ?? ?? ?? ?? 75 14 51 52 50 E8 ?? ?? ?? ?? 58 5A 59 81 78 04 B2 D7 00 00 74 B7 B8 69 00 00 00 E8 ?? ?? ?? ?? EB D6 E8 ?? ?? ?? ?? 59 58 EB CD }
	condition:
		$1
}

rule function_495_0 {
	meta:
		name = "_NF__477"
		size = 57
		refs = "0003 _NV__47F 001c @GetTls 0022 InOutRes"
	strings:
		$1 = { 8B CA BA ?? ?? ?? ?? 83 F9 40 7E 21 83 E9 40 50 51 B9 40 00 00 00 E8 7A FF FF FF E8 ?? ?? ?? ?? 83 B8 ?? ?? ?? ?? 00 75 0D 59 58 EB D5 85 C9 0F 8F 60 FF FF FF C3 59 58 C3 }
	condition:
		$1
}

rule function_496_0 {
	meta:
		name = "@Write0String"
		size = 10
	strings:
		$1 = { 33 C9 8A 0A 42 E9 52 FF FF FF }
	condition:
		$1
}

rule function_497_0 {
	meta:
		name = "@WriteString"
		size = 29
	strings:
		$1 = { 53 33 DB 8A 1A 2B CB 7E 0B 50 52 8B D1 E8 AB FF FF FF 5A 58 8B CB 5B 42 E9 35 FF FF FF }
	condition:
		$1
}

rule function_498_0 {
	meta:
		name = "@WriteLn"
		size = 20
		refs = "0001 _NV__47F 0010 @Flush"
	strings:
		$1 = { BA ?? ?? ?? ?? B9 02 00 00 00 E8 26 FF FF FF E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule function_499_0 {
	meta:
		name = "@Write0Char"
		size = 82
		refs = "0028 Output 0031 @RewritText 0046 _NF__1ED"
	strings:
		$1 = { 81 78 04 B2 D7 00 00 75 1E 8B 48 0C 3B 48 08 7D 09 03 48 14 88 11 FF 40 0C C3 50 52 FF 50 1C 85 C0 75 27 5A 58 EB E2 3D ?? ?? ?? ?? 75 12 52 50 E8 ?? ?? ?? ?? 58 5A 81 78 04 B2 D7 00 00 74 C9 B8 69 00 00 00 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 58 C3 }
	condition:
		$1
}

rule function_500_0 {
	meta:
		name = "@WriteChar"
		size = 23
	strings:
		$1 = { 52 8D 51 FF E8 31 FF FF FF 8B D4 B9 01 00 00 00 E8 BA FE FF FF 5A C3 }
	condition:
		$1
}

rule function_501_0 {
	meta:
		name = "@Write0CString"
		size = 4
	strings:
		$1 = { 33 C9 EB 00 }
	condition:
		$1
}

rule function_502_0 {
	meta:
		name = "@WriteCString"
		size = 42
	strings:
		$1 = { 56 57 8B F0 51 8B FA 83 C9 FF B0 00 F2 AE F7 D1 49 8B FA 5A 2B D1 8B C6 51 E8 01 FF FF FF 59 8B C6 8B D7 5F 5E E9 8A FE FF FF }
	condition:
		$1
}

rule function_503_0 {
	meta:
		name = "_NF__480"
		size = 32
	strings:
		$1 = { 00 00 00 00 00 00 F0 3F 00 00 00 00 00 00 24 40 00 A0 D8 85 57 34 76 43 00 C8 4E 67 6D C1 AB 43 }
	condition:
		$1
}

rule function_504_0 {
	meta:
		name = "@Str0Ext"
		size = 12
	strings:
		$1 = { 8B C8 B8 17 00 00 00 83 CA FF EB 07 }
	condition:
		$1
}

rule function_505_0 {
	meta:
		name = "@Str1Ext"
		size = 7
	strings:
		$1 = { 8B CA 83 CA FF EB 00 }
	condition:
		$1
}

rule function_506_0 {
	meta:
		name = "@Str2Ext"
		size = 625
		refs = "00f8 _NF__480 0255 @Pow10"
	strings:
		$1 = { DB 6C 24 04 53 56 57 8B D8 8B F2 51 81 EC 00 01 00 00 81 FB FF 00 00 00 7E 05 BB FF 00 00 00 D9 C0 DB 3C 24 33 C0 66 8B 44 24 08 8B F8 C1 EF 0F 66 25 FF 7F 66 3D FF 7F 0F 84 3E 01 00 00 D9 E1 85 F6 0F 8D A1 00 00 00 E8 DE 01 00 00 8B F3 83 EE 08 83 FE 02 7D 07 BE 02 00 00 00 EB 0A 83 FE 12 7E 05 BE 12 00 00 00 8B D4 50 8B C6 E8 4F 01 00 00 8B D7 8B BC 24 04 01 00 00 88 1F 47 B0 20 8B CB 2B CE 83 E9 08 7E 02 F3 AA 28 4F FF 84 D2 74 02 B0 2D AA 58 8B CE 8B F4 80 3E 30 74 02 40 4E 46 A4 C6 07 2E 47 49 F3 A4 C6 07 45 B1 2B 85 C0 7D 04 B1 2D F7 D8 88 4F 01 33 D2 66 B9 0A 00 66 F7 F1 80 C2 30 88 57 05 33 D2 66 F7 F1 80 C2 30 88 57 04 33 D2 66 F7 F1 80 C2 30 88 57 03 04 30 88 47 02 E9 86 00 00 00 81 FE D8 00 00 00 7E 05 BE D8 00 00 00 DC 15 ?? ?? ?? ?? 9B DF E0 9E B8 00 00 00 00 72 0E E8 1F 01 00 00 83 F8 23 0F 8F 38 FF FF FF 40 8B D4 50 03 C6 E8 A1 00 00 00 58 8B D6 8B F4 80 3E 30 74 02 40 4E 46 8B C8 03 CF 85 D2 74 09 41 03 CA 3B D9 7F 02 8B D9 50 57 8B BC 24 08 01 00 00 88 1F 47 2B D9 8B CB 7E 04 B0 20 F3 AA 28 4F FF 58 59 85 C0 74 04 C6 07 2D 47 F3 A4 85 D2 74 08 C6 07 2E 47 8B CA F3 A4 81 C4 00 01 00 00 59 5F 5E 5B C2 0C 00 DD D8 81 7C 24 04 00 00 00 80 BE ?? ?? ?? ?? 75 0D 4F BE ?? ?? ?? ?? 75 05 BE ?? ?? ?? ?? 8B F9 8B CB 88 0F 47 2A 0E 76 04 B0 20 F3 AA 28 4F FF 8A 0E 46 F3 A4 EB BC 03 4E 61 6E 04 2B 49 6E 66 04 2D 49 6E 66 57 8B FA 8B C8 83 EC 0A C6 07 30 DC 0D ?? ?? ?? ?? D9 FC DC 15 ?? ?? ?? ?? 9B DF E0 9E 72 09 DC 25 ?? ?? ?? ?? C6 07 31 DF 34 24 BA 08 00 00 00 47 9B 8A 04 14 8A E0 C0 E8 04 80 E4 0F 66 05 30 30 66 AB 4A 79 EB 83 E9 12 7C 06 B0 30 F3 AA EB 14 03 F9 80 3F 35 7C 0D 4F FE 07 80 3F 39 7E 05 C6 07 30 EB F3 83 C4 0A 5F C3 53 83 EC 0C 33 DB D9 C0 DB 3C 24 66 8B 44 24 08 66 85 C0 74 22 66 2D FF 3F 66 BA 10 4D 66 F7 EA 0F BF C2 F7 D8 74 09 2B D8 E8 ?? ?? ?? ?? EB D6 83 C4 0C 8B C3 5B C3 83 7C 24 04 00 75 D7 83 3C 24 00 75 D1 EB EA }
	condition:
		$1
}

rule function_507_0 {
	meta:
		name = "@ValExt"
		size = 257
		refs = "0044 @ValExt 00d9 @Pow10"
	strings:
		$1 = { 53 56 57 8B F0 50 D9 EE 33 C0 33 DB 33 FF 53 85 F6 0F 84 DB 00 00 00 8A 1E 46 80 FB 20 74 F8 B5 00 80 FB 2D 74 07 80 FB 2B 74 04 EB 05 FE C5 8A 1E 46 84 DB 0F 84 B9 00 00 00 80 EB 30 80 FB 09 77 18 DC 0D ?? ?? ?? ?? 89 1C 24 DA 04 24 8A 1E 46 84 DB 75 E5 EB 7D 90 90 90 80 FB FE 75 25 8A 1E 46 84 DB 74 6E 80 EB 30 80 FB 09 77 16 DC 0D ?? ?? ?? ?? 89 1C 24 DA 04 24 48 8A 1E 46 84 DB 75 E4 EB 50 80 FB 15 74 05 80 FB 35 75 65 8A 1E 46 B4 00 80 FB 2D 74 07 80 FB 2B 74 04 EB 05 FE C4 8A 1E 46 80 EB 30 80 FB 09 77 47 8B FB 8A 1E 46 84 DB 74 16 80 EB 30 80 FB 09 77 36 8D 3C BF 03 FF 03 FB 8A 1E 46 84 DB 75 EA FE CC 75 02 F7 DF 0F BE C0 03 C7 52 51 E8 ?? ?? ?? ?? 59 5A FE CD 74 0B 83 C4 08 33 F6 89 32 5F 5E 5B C3 D9 E0 EB F1 46 58 5B 2B F3 EB EF 00 00 00 00 00 00 24 40 }
	condition:
		$1
}

rule function_509_0 {
	meta:
		name = "FPower10"
		size = 724
		refs = "001c @Pow10"
	strings:
		$1 = { 85 C0 7C 48 74 45 3D 00 14 00 00 0F 8D 7F 00 00 00 8B D0 83 E2 1F 8D 14 92 DB 2C 55 ?? ?? ?? ?? DE C9 C1 E8 05 74 24 8B D0 83 E2 0F 74 0C 8D 14 92 DB 2C 55 ?? ?? ?? ?? DE C9 C1 E8 04 74 0C 8D 04 80 DB 2C 45 ?? ?? ?? ?? DE C9 C3 F7 D8 3D 00 14 00 00 7D 42 8B D0 83 E2 1F 8D 14 92 DB 2C 55 ?? ?? ?? ?? DE F9 C1 E8 05 74 E0 8B D0 83 E2 0F 74 0C 8D 14 92 DB 2C 55 ?? ?? ?? ?? DE F9 C1 E8 04 74 C8 8D 04 80 DB 2C 45 ?? ?? ?? ?? DE F9 C3 DB 2D ?? ?? ?? ?? C3 D9 EE C3 00 00 00 00 00 00 00 80 FF 7F 00 00 00 00 00 00 00 80 FF 3F 00 00 00 00 00 00 00 A0 02 40 00 00 00 00 00 00 00 C8 05 40 00 00 00 00 00 00 00 FA 08 40 00 00 00 00 00 00 40 9C 0C 40 00 00 00 00 00 00 50 C3 0F 40 00 00 00 00 00 00 24 F4 12 40 00 00 00 00 00 80 96 98 16 40 00 00 00 00 00 20 BC BE 19 40 00 00 00 00 00 28 6B EE 1C 40 00 00 00 00 00 F9 02 95 20 40 00 00 00 00 40 B7 43 BA 23 40 00 00 00 00 10 A5 D4 E8 26 40 00 00 00 00 2A E7 84 91 2A 40 00 00 00 80 F4 20 E6 B5 2D 40 00 00 00 A0 31 A9 5F E3 30 40 00 00 00 04 BF C9 1B 8E 34 40 00 00 00 C5 2E BC A2 B1 37 40 00 00 40 76 3A 6B 0B DE 3A 40 00 00 E8 89 04 23 C7 8A 3E 40 00 00 62 AC C5 EB 78 AD 41 40 00 80 7A 17 B7 26 D7 D8 44 40 00 90 AC 6E 32 78 86 87 48 40 00 B4 57 0A 3F 16 68 A9 4B 40 00 A1 ED CC CE 1B C2 D3 4E 40 A0 84 14 40 61 51 59 84 52 40 C8 A5 19 90 B9 A5 6F A5 55 40 3A 0F 20 F4 27 8F CB CE 58 40 84 09 94 F8 78 39 3F 81 5C 40 E5 0B B9 36 D7 07 8F A1 5F 40 DF 4E 67 04 CD C9 F2 C9 62 40 96 22 81 45 40 7C 6F FC 65 40 9E B5 70 2B A8 AD C5 9D 69 40 D5 A6 CF FF 49 1F 78 C2 D3 40 A3 14 9B C5 16 AB B3 EF 3D 41 E0 8C E9 80 C9 47 BA 93 A8 41 AA 17 E6 7F 2B A1 16 B6 12 42 6B 55 27 39 8D F7 70 E0 7C 42 30 C9 3C E3 FF 96 52 8A E7 42 8E DE F9 9D FB EB 7E AA 51 43 8C 2F 6A 5C 19 FC 26 D2 BB 43 76 E3 CC F2 29 2F 84 81 26 44 D2 0A 90 DB 00 27 A4 9F 90 44 17 AA F8 AE 10 E3 C5 C4 FA 44 59 9C B0 E9 07 9C 8A F2 64 45 D4 F3 F7 EB E1 4A 7A 95 CF 45 62 A2 95 07 DC D8 3E B8 39 46 C7 91 0E A6 AE A0 19 E3 A3 46 17 0C 75 81 86 75 76 C9 48 4D E4 A7 93 39 3B 35 B8 B2 ED 53 E5 5D 3D C5 5D 3B 8B 9E 92 5A A6 F0 A1 20 C0 54 A5 8C 37 61 8B 5A 8B D8 25 5D 89 F9 DB 67 F8 F3 27 BF A2 C8 5D DD 80 6E 9B 97 20 8A 02 52 60 C4 25 75 F0 59 D5 6E 62 11 35 AE CA 7B }
	condition:
		$1
}

rule function_510_0 {
	meta:
		name = "@Real2Ext"
		size = 45
	strings:
		$1 = { 8A 70 05 80 E6 80 8A 10 84 D2 74 1E 66 81 C2 7E 3F 52 8B 50 02 81 CA 00 00 00 80 52 8A 50 01 C1 E2 18 52 DB 2C 24 83 C4 0C C3 D9 EE C3 }
	condition:
		$1
}

rule function_511_0 {
	meta:
		name = "@Ext2Real"
		size = 74
		refs = "0046 _NF__1EB"
	strings:
		$1 = { 53 83 EC 0C DB 3C 24 5B 5A 59 C1 EB 18 80 D3 00 83 D2 00 66 83 D1 00 70 29 03 D2 66 03 C9 D1 DA 66 D1 E9 66 81 E9 7E 3F 7E 0E 84 ED 7F 14 88 08 88 58 01 89 50 02 5B C3 33 C9 89 08 66 89 48 04 5B C3 5B B0 08 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule function_512_0 {
	meta:
		name = "Finalization"
		size = 93
		refs = "0007 Finalization 0013 _NV__15A 001a Input 001f @Close 0024 Output 002e _NF__1C8 0033 Null 0038 @VarClr 003d Unassigned 0055 @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 FF 05 ?? ?? ?? ?? 75 2D B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 }
	condition:
		$1
}

rule function_513_0 {
	meta:
		name = "System"
		size = 188
		refs = "0007 System 0013 _NV__15A 0021 ExitCode 0028 ErrorAddr 002f RandSeed 0035 FileMode 003c Test8086 0043 Test8087 004b Unassigned 0054 Null 005b _NF__240 0064 _NF__241 0069 _NF__242 006e Input 0078 @Assign 007d Output 008c _NF__174 0091 CmdLine 0096 _NF__196 009b CmdShow 00ae @HandleFinally"
	strings:
		$1 = { 55 8B EC 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 83 2D ?? ?? ?? ?? 01 0F 83 81 00 00 00 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? 33 C0 A3 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? 02 C6 05 ?? ?? ?? ?? 02 C6 05 ?? ?? ?? ?? 03 66 C7 05 ?? ?? ?? ?? 00 00 66 C7 05 ?? ?? ?? ?? 01 00 E8 ?? ?? ?? ?? 84 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? EB F8 5D C3 00 00 00 00 00 00 }
	condition:
		$1
}
