private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "ARM"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "_vsnprintf_r"
		size = 90
		refs = "0030 _svfprintf_r"
	strings:
		$1 = { 70 B5 9A B0 05 1C 14 1C 00 2A 21 DB 00 2A 1A D1 00 26 82 20 00 91 04 91 01 21 6A 46 80 00 49 42 90 81 D1 81 28 1C 1A 1C 69 46 1E 9B 02 96 05 96 ?? ?? ?? ?? 43 1C 08 DB 00 2C 02 D0 00 9B 00 22 1A 70 1A B0 70 BD 56 1E E3 E7 8B 23 2B 60 F3 E7 8B 23 03 60 01 20 40 42 F3 E7 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "_vsniprintf_r"
		size = 90
		refs = "0030 _svfiprintf_r"
	strings:
		$1 = { 70 B5 9A B0 05 1C 14 1C 00 2A 21 DB 00 2A 1A D1 00 26 82 20 00 91 04 91 01 21 6A 46 80 00 49 42 90 81 D1 81 28 1C 1A 1C 69 46 1E 9B 02 96 05 96 ?? ?? ?? ?? 43 1C 08 DB 00 2C 02 D0 00 9B 00 22 1A 70 1A B0 70 BD 56 1E E3 E7 8B 23 2B 60 F3 E7 8B 23 03 60 01 20 40 42 F3 E7 }
	condition:
		$1
}

rule file_0_1_0 {
	meta:
		name = "vsnprintf"
		size = 36
		refs = "0016 _vsnprintf_r 0020 _impure_ptr"
	strings:
		$1 = { 70 B5 14 1C 06 4A 06 1C 0D 1C 81 B0 10 68 31 1C 00 93 2A 1C 23 1C ?? ?? ?? ?? 01 B0 70 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_154_1_0 {
	meta:
		name = "fread"
		size = 36
		refs = "0016 _fread_r 0020 _impure_ptr"
	strings:
		$1 = { 70 B5 14 1C 06 4A 06 1C 0D 1C 81 B0 10 68 31 1C 00 93 2A 1C 23 1C ?? ?? ?? ?? 01 B0 70 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_390_1_0 {
	meta:
		name = "fwrite"
		size = 36
		refs = "0016 _fwrite_r 0020 _impure_ptr"
	strings:
		$1 = { 70 B5 14 1C 06 4A 06 1C 0D 1C 81 B0 10 68 31 1C 00 93 2A 1C 23 1C ?? ?? ?? ?? 01 B0 70 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_340_1_0 {
	meta:
		name = "mbrtowc"
		size = 36
		refs = "0016 _mbrtowc_r 0020 _impure_ptr"
	strings:
		$1 = { 70 B5 14 1C 06 4A 06 1C 0D 1C 81 B0 10 68 31 1C 00 93 2A 1C 23 1C ?? ?? ?? ?? 01 B0 70 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "mbsrtowcs"
		size = 36
		refs = "0016 _mbsrtowcs_r 0020 _impure_ptr"
	strings:
		$1 = { 70 B5 14 1C 06 4A 06 1C 0D 1C 81 B0 10 68 31 1C 00 93 2A 1C 23 1C ?? ?? ?? ?? 01 B0 70 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_189_1_0 {
	meta:
		name = "vasniprintf"
		size = 36
		refs = "0016 _vasniprintf_r 0020 _impure_ptr"
	strings:
		$1 = { 70 B5 14 1C 06 4A 06 1C 0D 1C 81 B0 10 68 31 1C 00 93 2A 1C 23 1C ?? ?? ?? ?? 01 B0 70 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_265_1_0 {
	meta:
		name = "vasnprintf"
		size = 36
		refs = "0016 _vasnprintf_r 0020 _impure_ptr"
	strings:
		$1 = { 70 B5 14 1C 06 4A 06 1C 0D 1C 81 B0 10 68 31 1C 00 93 2A 1C 23 1C ?? ?? ?? ?? 01 B0 70 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_135_1_0 {
	meta:
		name = "vsniprintf"
		size = 36
		refs = "0016 _vsniprintf_r 0020 _impure_ptr"
	strings:
		$1 = { 70 B5 14 1C 06 4A 06 1C 0D 1C 81 B0 10 68 31 1C 00 93 2A 1C 23 1C ?? ?? ?? ?? 01 B0 70 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_155_1_0 {
	meta:
		name = "wcsrtombs"
		size = 36
		refs = "0016 _wcsrtombs_r 0020 _impure_ptr"
	strings:
		$1 = { 70 B5 14 1C 06 4A 06 1C 0D 1C 81 B0 10 68 31 1C 00 93 2A 1C 23 1C ?? ?? ?? ?? 01 B0 70 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "scalbn"
		size = 284
		refs = "001e __muldf3 0044 copysign 00be __adddf3"
	strings:
		$1 = { 70 B5 43 00 5B 0D 14 1C 05 1C 0E 1C 02 1C 00 2B 26 D1 43 00 21 D0 28 1C 31 1C 34 4B 32 4A ?? ?? ?? ?? 33 4B 05 1C 0E 1C 9C 42 28 DB 43 00 5B 0D 36 3B 30 49 1B 19 02 1C 8B 42 18 DD 2A 1C 33 1C 2D 48 2E 49 ?? ?? ?? ?? 2B 4A 2C 4B ?? ?? ?? ?? 05 1C 0E 1C 28 1C 31 1C 70 BD 00 29 FA D0 DA E7 27 49 8B 42 27 D0 23 49 1B 19 8B 42 E6 DC 00 2B 0E DD 24 49 1B 05 0A 40 1D 1C 15 43 EA E7 28 1C 31 1C 21 4A 21 4B ?? ?? ?? ?? 05 1C 0E 1C E1 E7 19 1C 35 31 18 DA 1E 4B 9C 42 CF DC 2A 1C 33 1C 19 48 1A 49 ?? ?? ?? ?? 17 4A 18 4B ?? ?? ?? ?? 05 1C 0E 1C CE E7 28 1C 31 1C 2A 1C 33 1C ?? ?? ?? ?? 05 1C 0E 1C C5 E7 0E 49 36 33 1B 05 0A 40 1D 1C 15 43 28 1C 31 1C 0E 4A 0F 4B ?? ?? ?? ?? 05 1C 0E 1C B6 E7 C0 46 00 00 50 43 00 00 00 00 B0 3C FF FF FE 07 00 00 3C E4 37 7E 9C 75 00 88 FF 07 00 00 FF FF 0F 80 1F 6E A5 01 59 F3 F8 C2 50 C3 00 00 00 00 90 3C 00 00 00 00 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "argz_extract"
		size = 62
		refs = "0008 argz_count"
	strings:
		$1 = { F0 B5 0D 1C 06 1C 14 1C ?? ?? ?? ?? 01 2D 11 D9 AB 1E 00 2B 0E D0 01 3D 75 19 00 27 6A 1E 11 78 00 29 03 D1 01 37 C1 1B 89 00 0D 51 01 3B 15 1C 00 2B F3 D1 80 00 00 23 26 60 03 51 F0 BD }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "__hexnan"
		size = 436
		refs = "0194 __hexdig_init 01b0 __hexdig"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 83 B0 01 90 67 4C 30 23 E3 5C 0E 1C 15 1C 00 2B 00 D1 B9 E0 33 68 5A 11 92 00 1F 21 18 1C AA 18 08 40 02 90 00 D0 04 32 04 3A 01 99 00 26 93 46 00 23 00 96 13 60 D8 46 0A 68 00 27 59 46 A9 46 01 32 13 78 00 2B 32 D0 E0 5C 00 28 53 D1 20 2B 6A D8 00 9B 9F 42 F3 DD 07 2E 21 DC 41 45 1F D2 08 25 AE 1B B6 00 20 20 83 1B 9A 46 15 1C 32 1C 46 46 08 68 0B 1C 8C 46 B8 46 51 46 37 1C AA 46 5D 68 2E 1C 8E 40 30 43 18 60 28 1C D0 40 58 60 04 33 9F 42 F4 D8 3B 1C 61 46 47 46 52 46 98 46 49 45 3A D8 01 32 13 78 08 26 00 2B CC D1 4D 46 00 2F 3C D0 07 2E 01 DC 41 45 40 D3 8D 42 55 D2 2B 1C 58 46 04 C9 04 C3 88 42 FB D2 00 22 01 1C 04 C3 99 42 FC D2 0B 68 8B 46 00 2B 09 D1 5D 45 55 D0 5B 46 01 E0 9D 42 51 D0 04 3B 1A 68 00 2A F9 D0 05 20 1C E0 01 36 01 37 08 2E 06 DC 0B 68 1B 01 0F 25 28 40 18 43 08 60 99 E7 49 45 97 D9 04 39 00 23 0B 60 01 26 F3 E7 04 39 00 25 0D 60 00 97 88 46 00 26 8B E7 4D 46 29 2B 36 D0 04 20 03 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 08 23 9E 1B B6 00 20 27 0A 68 0B 1C 8C 46 BF 1B 41 46 58 68 04 1C BC 40 22 43 1A 60 02 1C F2 40 5A 60 04 33 99 42 F4 D8 61 46 8D 42 A9 D3 02 98 00 28 11 D0 02 9B 20 22 D2 1A 01 23 58 46 5B 42 D3 40 02 68 13 40 03 60 A8 E7 ?? ?? ?? ?? 42 E7 01 23 2B 60 05 20 CC E7 59 46 0B 68 9E E7 01 98 01 32 02 60 85 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "_mbsrtowcs_r"
		size = 188
		refs = "0056 _mbrtowc_r 00b8 __mb_cur_max"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 83 B0 8B 46 0C 99 15 1C 5A 46 82 46 01 93 89 46 00 2A 40 D0 01 9A 00 2A 45 D0 01 9C 00 21 5F 46 88 46 2A 68 21 4E 0B E0 2A 68 5B 46 12 18 2A 60 00 2B 20 D0 04 37 01 21 01 3C 88 44 00 2C 10 D0 49 46 33 68 50 46 00 91 39 1C ?? ?? ?? ?? 00 28 EA DC 82 1C 11 D1 2A 68 33 68 D2 18 2A 60 00 2C EE D1 01 9A 90 46 03 B0 40 46 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 27 DD E7 00 28 09 D0 00 23 49 46 0B 60 52 46 8A 23 13 60 01 23 59 42 88 46 E9 E7 28 60 E7 E7 2B 68 02 93 01 23 5B 42 01 93 02 AD 1C 1C BA E7 00 23 98 46 DC E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "_tzset_r"
		size = 872
		refs = "0010 __gettzinfo 001a _getenv_r 0026 __tz_lock 0034 strcmp 0042 free 0048 strlen 0050 _malloc_r 005c strcpy 0072 sscanf 019c strtoul 0252 __tzcalc_limits 0268 __tz_unlock 034c _tzname 0354 _timezone 0358 _daylight"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 8B B0 07 1C ?? ?? ?? ?? C9 49 06 1C 38 1C ?? ?? ?? ?? 04 1C 00 28 00 D1 6D E1 ?? ?? ?? ?? C5 4D 29 68 00 29 06 D0 20 1C ?? ?? ?? ?? 00 28 00 D1 14 E1 29 68 08 1C ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 41 1C 38 1C ?? ?? ?? ?? 28 60 00 28 02 D0 21 1C ?? ?? ?? ?? 23 78 3A 2B 00 D1 0C E1 07 AF 2A 1D 20 1C B5 49 3B 1C ?? ?? ?? ?? 00 28 00 DC F5 E0 07 9B E4 18 23 78 2D 2B 00 D1 FE E0 2B 2B 00 D1 06 E1 01 22 93 46 0A A8 26 22 2A 21 6A 44 00 23 80 46 69 44 03 80 13 80 10 1C 89 46 92 46 42 46 00 92 02 90 A5 49 20 1C 4A 46 3B 1C 01 97 03 97 ?? ?? ?? ?? 00 28 00 DC D0 E0 48 46 03 88 1A 01 D3 1A 1A 01 D3 1A 41 46 1A 01 0B 88 19 01 CB 1A 50 46 9B 00 D3 18 02 88 9B 18 19 1C 5B 46 4B 43 97 4A 33 62 2B 1D 13 60 07 9B 10 35 E4 18 93 46 20 1C 91 49 2A 1C 3B 1C ?? ?? ?? ?? 00 28 00 DC 10 E1 59 46 4D 60 07 9D 64 19 23 78 2D 2B 00 D1 BA E0 2B 2B 00 D1 B5 E0 01 25 00 23 40 46 51 46 4A 46 03 80 0B 80 13 80 07 93 00 90 02 91 20 1C 82 49 3B 1C 01 97 03 97 ?? ?? ?? ?? 00 28 00 DC AA E0 48 46 03 88 1A 01 D3 1A 1A 01 D3 1A 41 46 1A 01 0B 88 19 01 CB 1A 9B 00 50 46 D3 18 02 88 9B 18 5D 43 F5 63 07 9D 00 21 04 91 65 19 2A 78 34 1C 93 46 2C 2A 39 D0 58 46 4D 28 3C D0 59 46 4A 29 00 D1 73 E0 44 22 05 92 06 A9 28 1C 0A 22 ?? ?? ?? ?? 06 99 00 04 8B 46 00 0C AB 45 00 D1 9D E0 6B 46 14 21 CB 5C 60 61 23 72 69 46 08 84 02 23 4A 46 00 21 40 46 13 80 01 80 00 23 52 46 00 20 13 80 07 90 59 46 0B 78 2F 2B 69 D0 E1 23 00 25 5B 01 A3 61 04 9B 01 33 04 93 1C 34 02 2B 30 D0 5D 44 2A 78 93 46 2C 2A C5 D1 01 35 2B 78 9B 46 58 46 4D 28 C2 D1 22 21 69 44 08 AA 00 91 02 92 28 1C 4F 49 09 AA 3B 1C 01 97 03 97 ?? ?? ?? ?? 03 28 22 D1 68 46 83 8C 00 2B 1E D0 0C 2B 1C D8 42 8C 00 2A 19 D0 05 2A 17 D8 01 8C 06 29 14 D8 58 46 20 72 E3 60 22 61 61 61 07 9B ED 18 AB 46 B5 E7 70 68 ?? ?? ?? ?? 33 6A 3E 4A 13 60 F2 6B 9B 1A 5A 1E 93 41 3C 4A 13 60 ?? ?? ?? ?? 0B B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 4A 23 01 35 05 93 89 E7 01 34 F0 E6 01 20 41 42 01 34 8B 46 00 E7 01 34 47 E7 01 25 01 34 6D 42 44 E7 01 23 01 34 9B 46 F6 E6 33 6A 2D 4A 9B 18 F3 63 61 E7 42 46 53 46 00 92 02 93 2A 49 4A 46 3B 1C 58 46 01 97 03 97 ?? ?? ?? ?? 41 46 0B 88 48 46 02 88 19 01 CB 1A 99 00 13 01 9A 1A 13 01 9B 1A 1B 01 52 46 5B 18 11 88 07 9D 5B 18 7A E7 04 9A 00 2A 15 D1 4D 23 33 72 04 9B 03 21 02 22 F1 60 32 61 73 61 5A E7 ?? ?? ?? ?? 13 4B 1C 60 13 4B 15 4A 1C 60 0E 4B 1A 60 5A 60 ?? ?? ?? ?? A7 E7 4D 22 24 21 72 54 0B 23 01 21 00 22 B3 62 F1 62 32 63 43 E7 58 46 03 68 43 60 ?? ?? ?? ?? 97 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? F0 F1 FF FF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_1_0 {
	meta:
		name = "_vsiscanf_r"
		size = 68
		refs = "0018 strlen 0038 __ssvfiscanf_r 0040 eofread1"
	strings:
		$1 = { F0 B5 9A B0 1F 1C 81 23 06 1C 6C 46 9B 00 08 1C 15 1C A3 81 00 91 04 91 ?? ?? ?? ?? 08 4B 08 93 00 23 0C 93 11 93 01 23 5B 42 01 90 05 90 E3 81 30 1C 69 46 2A 1C 3B 1C ?? ?? ?? ?? 1A B0 F0 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_1_0 {
	meta:
		name = "_vsscanf_r"
		size = 68
		refs = "0018 strlen 0038 __ssvfscanf_r 0040 eofread1"
	strings:
		$1 = { F0 B5 9A B0 1F 1C 81 23 06 1C 6C 46 9B 00 08 1C 15 1C A3 81 00 91 04 91 ?? ?? ?? ?? 08 4B 08 93 00 23 0C 93 11 93 01 23 5B 42 01 90 05 90 E3 81 30 1C 69 46 2A 1C 3B 1C ?? ?? ?? ?? 1A B0 F0 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_2_0 {
	meta:
		name = "vsiscanf"
		size = 28
		refs = "0010 _vsiscanf_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_408_1_0 {
	meta:
		name = "__svfiscanf"
		size = 28
		refs = "0010 __svfiscanf_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_314_1_0 {
	meta:
		name = "__svfscanf"
		size = 28
		refs = "0010 __svfscanf_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "execve"
		size = 28
		refs = "0010 _execve_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_327_1_0 {
	meta:
		name = "fgets"
		size = 28
		refs = "0010 _fgets_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_239_5_0 {
	meta:
		name = "fmemopen"
		size = 28
		refs = "0010 _fmemopen_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_395_1_0 {
	meta:
		name = "freopen"
		size = 28
		refs = "0010 _freopen_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_443_1_0 {
	meta:
		name = "fseek"
		size = 28
		refs = "0010 _fseek_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "fseeko"
		size = 28
		refs = "0010 _fseek_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_400_0_0 {
	meta:
		name = "lseek"
		size = 28
		refs = "0010 _lseek_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "read"
		size = 28
		refs = "0010 _read_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "setenv"
		size = 28
		refs = "0010 _setenv_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_1_0 {
	meta:
		name = "strtol"
		size = 28
		refs = "0010 _strtol_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "strtoll"
		size = 28
		refs = "0010 _strtoll_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_424_1_0 {
	meta:
		name = "strtoul"
		size = 28
		refs = "0010 _strtoul_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "strtoull"
		size = 28
		refs = "0010 _strtoull_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_1_0 {
	meta:
		name = "vasiprintf"
		size = 28
		refs = "0010 _vasiprintf_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_123_1_0 {
	meta:
		name = "vasprintf"
		size = 28
		refs = "0010 _vasprintf_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_193_1_0 {
	meta:
		name = "vdiprintf"
		size = 28
		refs = "0010 _vdiprintf_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_206_1_0 {
	meta:
		name = "vdprintf"
		size = 28
		refs = "0010 _vdprintf_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_2_0 {
	meta:
		name = "vfiprintf"
		size = 28
		refs = "0010 _vfiprintf_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_422_2_0 {
	meta:
		name = "vfprintf"
		size = 28
		refs = "0010 _vfprintf_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_247_1_0 {
	meta:
		name = "vsiprintf"
		size = 28
		refs = "0010 _vsiprintf_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "vsprintf"
		size = 28
		refs = "0010 _vsprintf_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_2_0 {
	meta:
		name = "vsscanf"
		size = 28
		refs = "0010 _vsscanf_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_421_1_0 {
	meta:
		name = "wcrtomb"
		size = 28
		refs = "0010 _wcrtomb_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_406_1_0 {
	meta:
		name = "wcstol"
		size = 28
		refs = "0010 _wcstol_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "wcstoll"
		size = 28
		refs = "0010 _wcstoll_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_1_0 {
	meta:
		name = "wcstoul"
		size = 28
		refs = "0010 _wcstoul_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "wcstoull"
		size = 28
		refs = "0010 _wcstoull_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "write"
		size = 28
		refs = "0010 _write_r 0018 _impure_ptr"
	strings:
		$1 = { 30 B5 13 1C 04 4A 05 1C 0C 1C 10 68 29 1C 22 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__sprint_r"
		size = 304
		refs = "0048 memmove 00ae _malloc_r 00bc memcpy 00e8 _realloc_r 00f6 _free_r"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 93 68 83 B0 02 90 0C 1C 16 1C 17 68 00 2B 00 D1 83 E0 00 20 81 46 80 22 08 68 90 21 C9 00 D2 00 00 25 00 91 01 92 00 2D 16 D0 A1 68 88 46 8A 46 45 45 1C D2 A8 46 AA 46 49 46 52 46 ?? ?? ?? ?? A3 68 40 46 1B 1A A3 60 20 68 B3 68 50 44 5D 1B 20 60 B5 60 00 2D 57 D0 3B 68 7D 68 99 46 08 37 00 2D F9 D0 A1 68 88 46 8A 46 45 45 E2 D3 A3 89 00 9A 13 42 E0 D0 21 69 62 69 40 1A 83 46 50 00 82 18 D0 0F 82 18 58 46 52 10 01 30 92 46 40 19 82 45 01 D2 82 46 02 1C 01 98 03 42 1D D0 02 98 11 1C ?? ?? ?? ?? 80 46 00 28 20 D0 5A 46 21 69 ?? ?? ?? ?? A3 89 1A 4A 80 20 13 40 03 43 A3 81 42 46 51 46 40 46 22 61 5A 46 58 44 8B 1A 20 60 61 61 A8 46 A3 60 AA 46 AE E7 02 98 ?? ?? ?? ?? 80 46 00 28 EC D1 21 69 02 98 ?? ?? ?? ?? 02 99 0C 23 0B 60 A2 89 40 23 13 43 A3 81 01 20 00 23 B3 60 73 60 40 42 01 E0 75 60 00 20 03 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 53 60 00 20 F5 E7 7F FB FF FF }
	condition:
		$1
}

rule file_7_1_0 {
	meta:
		name = "_svfiprintf_r"
		size = 2344
		refs = "0342 memchr 077a __umodsi3 0788 __udivsi3 084c strlen 0890 _malloc_r"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 AA B0 03 90 99 46 8B 89 8B 46 17 1C 18 06 04 D5 0B 69 00 2B 01 D1 00 F0 33 FC 00 23 26 AC 0C A8 26 90 A3 60 63 60 0B 93 05 93 05 1C 3B 78 00 2B 1F D0 25 2B 1D D0 3E 1C 01 36 33 78 25 2B 01 D0 00 2B F9 D1 F1 1B 88 46 00 29 10 D0 A3 68 43 44 A3 60 63 68 01 33 2F 60 69 60 63 60 07 2B 00 DD 46 E3 08 35 05 9B 9C 46 C4 44 63 46 05 93 33 78 37 1C 00 2B 00 D1 C8 E2 A7 20 68 44 00 21 4A 46 01 70 82 46 02 92 01 20 00 22 41 42 80 23 06 92 00 92 88 46 01 37 10 21 40 20 9C 46 3B 78 01 37 1A 1C 20 3A 58 2A 5A D9 00 2B 00 D1 AD E2 1C AA 01 26 13 70 51 46 00 23 0B 70 01 96 04 96 08 92 00 22 07 92 00 99 02 23 19 40 0A 91 02 D0 01 9A 02 32 01 92 00 9E 84 23 1E 40 09 96 00 D0 B7 E1 06 98 01 99 46 1A 00 2E 00 DC B1 E1 10 2E 00 DC D4 E3 D3 48 10 21 2A 1C B9 46 A3 68 88 46 5D 46 07 1C 03 E0 10 3E 08 32 10 2E 16 DD 61 68 40 46 10 33 01 31 17 60 50 60 A3 60 61 60 07 29 F1 DD 03 98 29 1C 22 1C FF F7 CD FE 00 28 00 D0 52 E3 10 3E A3 68 0C AA 10 2E E8 DC AB 46 15 1C 3A 1C 4F 46 91 46 62 68 49 46 9B 19 01 32 29 60 6E 60 A3 60 62 60 07 2A 00 DD 32 E3 08 35 79 E1 B9 4E 92 00 B2 58 97 46 00 9E 10 23 1E 43 00 96 00 98 C0 06 03 D4 00 9B 5B 06 00 D5 56 E3 02 99 04 31 02 9A 01 91 16 68 32 1C 53 1E 9A 41 01 23 00 21 50 46 01 70 2A E0 00 98 10 23 18 43 00 90 00 99 C9 06 51 D4 00 9E 76 06 4E D5 02 99 02 98 0E 88 04 30 32 1C 53 1E 9A 41 01 90 00 23 E7 E7 00 98 10 23 18 43 00 90 00 99 C9 06 03 D4 00 9E 76 06 00 D5 15 E3 02 9A 04 32 01 92 02 9B 1E 68 00 2E 00 DA 17 E3 32 1C 53 1E 9A 41 01 23 40 46 00 28 03 DB 00 98 80 21 88 43 00 90 41 46 00 29 02 D1 00 2A 00 D1 E2 E1 01 2B 00 D1 A6 E2 02 2B 00 D1 C6 E2 08 94 07 22 21 1C 33 1C 13 40 01 39 30 33 F6 08 0B 70 00 2E F7 D1 00 9A 08 91 D2 07 00 D4 D6 E2 30 2B 00 D1 35 E3 08 98 01 38 30 23 21 1A 08 90 03 70 04 91 CD E1 02 9A 04 32 02 9B 01 92 1E 68 32 1C 53 1E 9A 41 00 23 98 E7 02 98 02 68 1C AB 01 26 1A 70 51 46 00 22 04 30 0A 70 02 90 01 96 04 96 08 93 23 E7 00 99 C9 06 00 D5 B2 E2 00 99 49 06 00 D4 F1 E2 02 9E 02 9A 68 46 14 21 33 68 08 5A 91 46 04 22 91 44 18 80 C6 E6 00 9E 0E 43 00 96 02 9B 02 93 F8 E6 02 9E 00 99 02 98 04 36 02 23 19 43 30 22 29 AB 01 96 06 68 1A 70 78 22 5A 70 32 1C 53 1E 9A 41 5F 4B 00 91 0B 93 02 23 5C E7 5C 4E 00 98 0B 96 C0 06 4A D5 02 99 02 9A 04 31 01 91 16 68 32 1C 51 1E 8A 41 00 2A 0C D0 00 99 C9 07 09 D5 29 AA 30 21 53 70 11 70 00 9A 02 23 1A 43 00 92 01 22 40 E7 02 23 3E E7 00 20 56 46 02 9B 30 70 19 1C 1B 68 04 31 02 91 08 93 00 2B 00 D1 C1 E2 46 46 00 2E 00 DA 86 E2 08 98 00 21 42 46 ?? ?? ?? ?? 00 28 04 D0 08 99 40 1A 04 90 40 45 01 DD 41 46 04 91 00 20 07 90 4C E1 00 9B 0B 43 00 93 02 9B 02 93 9E E6 00 9A 02 9B 02 43 00 92 02 93 98 E6 38 48 0B 90 00 98 C0 06 B4 D4 00 9E 76 06 00 D4 50 E2 02 98 02 99 04 30 01 90 0E 88 AF E7 1A 1C 00 26 30 3A B3 00 9E 19 3B 78 76 00 96 19 1A 1C 30 3A 01 37 09 2A F5 D9 06 96 7C E6 00 9B 66 46 33 43 00 93 02 9B 02 93 73 E6 3B 78 01 37 2A 2B 00 D1 94 E2 1A 1C 30 3A 09 2A 00 D9 8B E2 00 26 B3 00 9E 19 3B 78 76 00 B6 18 1A 1C 30 3A 01 37 09 2A F5 D9 00 2E B0 46 00 DB 5C E6 01 26 72 42 90 46 58 E6 02 9B 00 9E 04 22 16 43 00 96 02 93 4F E6 2B 23 52 46 13 70 02 9B 02 93 49 E6 02 9A 02 9B 12 68 04 33 06 92 00 2A 00 DB 46 E7 52 42 06 92 E8 E7 00 9E 01 23 1E 43 02 9B 00 96 02 93 37 E6 52 46 13 78 00 2B 00 D0 E1 E1 20 23 13 70 02 9B 02 93 2D E6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A3 68 56 46 32 78 00 2A 0B D0 01 22 6A 60 62 68 01 33 01 32 2E 60 A3 60 62 60 07 2A 00 DD 69 E1 08 35 0A 98 00 28 0C D0 29 AA 2A 60 02 22 6A 60 62 68 02 33 01 32 A3 60 62 60 07 2A 00 DD 4E E1 08 35 09 99 80 29 00 D1 D2 E0 07 99 04 9A 8E 1A 00 2E 3C DD 10 2E 00 DC DD E1 CC 49 10 22 89 46 90 46 59 46 92 46 BB 46 2A 1C C8 44 03 9D 0F 1C 04 E0 10 3E 08 32 10 2E 18 DD A3 68 51 46 51 60 61 68 40 46 10 33 01 31 10 60 A3 60 61 60 07 29 EF DD 28 1C 39 1C 22 1C FF F7 EC FC 00 28 00 D0 FC E0 10 3E A3 68 0C AA 10 2E E6 DC 15 1C 3A 1C 5F 46 93 46 4A 46 10 32 2A 60 62 68 9B 19 01 32 6E 60 A3 60 62 60 07 2A 00 DD FD E0 08 35 08 9A 04 9E 2A 60 62 68 9B 19 01 32 6E 60 A3 60 62 60 07 2A 00 DD C7 E0 2A 1C 08 32 00 98 40 07 34 D5 06 99 01 98 0E 1A 00 2E 00 DC E3 E0 10 2E 00 DC B7 E1 A2 48 B8 46 10 25 07 1C 04 E0 10 3E 08 32 10 2E 15 DD A3 68 61 68 10 33 01 31 17 60 55 60 A3 60 61 60 07 29 F1 DD 03 98 59 46 22 1C FF F7 A1 FC 00 28 49 D1 10 3E A3 68 0C AA 10 2E E9 DC B9 46 47 46 49 46 11 60 56 60 62 68 9B 19 01 32 A3 60 62 60 07 2A 00 DD AC E0 01 9A 06 9E B2 42 00 DA 32 1C 05 98 80 18 05 90 00 2B 00 D0 8C E0 02 9A 00 21 61 60 91 46 0C AD 2F E5 00 2B 33 D1 00 98 C0 07 30 D5 69 46 97 31 30 23 01 22 08 91 0B 70 04 92 01 98 46 46 07 96 02 90 04 99 07 9A 01 91 91 42 00 DA 01 92 56 46 33 78 00 2B 00 D1 60 E5 01 98 01 30 01 90 5C E5 A3 68 00 2B 04 D0 03 98 59 46 22 1C FF F7 55 FC 5E 46 B3 89 58 06 02 D5 01 21 49 42 05 91 05 98 2A B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 23 08 94 04 93 D1 E7 06 9A 01 98 16 1A 00 2E 00 DC FF E0 10 2E 00 DC 41 E1 62 4A 10 20 91 46 59 46 80 46 2A 1C BB 46 C8 44 82 46 03 9D 0F 1C 04 E0 10 3E 08 32 10 2E 17 DD A3 68 41 46 11 60 61 68 50 46 10 33 01 31 50 60 A3 60 61 60 07 29 EF DD 28 1C 39 1C 22 1C FF F7 18 FC 00 28 29 D1 10 3E A3 68 0C AA 10 2E E7 DC 15 1C 3A 1C 5F 46 93 46 4A 46 10 32 2A 60 62 68 9B 19 01 32 6E 60 A3 60 62 60 07 2A 00 DD C6 E0 08 35 E9 E6 03 98 59 46 22 1C FF F7 FA FB 00 28 A2 D1 A3 68 0C AA 2F E7 03 98 59 46 22 1C FF F7 F0 FB 00 28 00 D1 6A E7 96 E7 BB 46 94 E7 03 98 59 46 22 1C FF F7 E5 FB 00 28 00 D0 8C E7 0C AD AF E4 03 98 59 46 22 1C FF F7 DB FB 00 28 00 D0 82 E7 A3 68 48 E7 03 98 59 46 22 1C FF F7 D1 FB 00 28 00 D0 78 E7 A3 68 0C AD F7 E6 03 98 59 46 22 1C FF F7 C6 FB 00 28 00 D0 6D E7 A3 68 0C AD A6 E6 03 98 59 46 22 1C FF F7 BB FB 00 28 00 D0 62 E7 A3 68 0C AD 8B E6 09 2E 00 D8 BD E0 2B 1C C1 46 25 1C B8 46 1F 1C 30 1C 0A 21 ?? ?? ?? ?? 01 3D 30 30 28 70 0A 21 30 1C ?? ?? ?? ?? 06 1C 09 28 F1 D8 3B 1C 47 46 C8 46 A9 46 1D 1C 4A 46 01 3A 30 36 A3 1A 08 92 16 70 04 93 21 E7 08 94 0B 98 0F 22 23 1C 31 1C 11 40 41 5C 01 3B 36 09 19 70 00 2E F7 D1 E6 1A 08 93 04 96 11 E7 03 98 59 46 22 1C FF F7 7D FB 00 28 00 D0 24 E7 A3 68 0C AD 3D E6 AB 46 1F E7 C0 46 ?? ?? ?? ?? 63 1A 04 93 FE E6 02 9E 02 9A 33 68 05 98 91 46 04 22 91 44 18 60 FF F7 19 FC 02 9B 02 93 4D E4 02 99 0E 68 02 98 36 04 04 30 36 14 01 90 00 2E 00 DB E7 E4 2D 23 50 46 76 42 03 70 E2 E4 02 9A 02 98 04 32 01 92 06 68 5E E5 02 9E 02 98 04 36 01 96 06 88 32 1C 53 1E 9A 41 01 23 A7 E4 08 98 ?? ?? ?? ?? 00 22 04 90 07 92 CF E6 A3 68 24 E6 03 98 59 46 22 1C FF F7 35 FB 00 28 00 D0 DC E6 A3 68 0C AD 19 E6 2B 48 81 46 4B E6 02 9A 02 99 13 68 05 9E 89 46 04 21 89 44 1E 60 FF F7 D6 FB 40 21 03 98 ?? ?? ?? ?? 59 46 08 60 08 61 00 28 38 D0 40 23 5E 46 73 61 FF F7 BF FB 1D 4A A3 68 91 46 4F E4 08 9E A6 1B 04 96 9B E6 42 46 04 92 06 2A 09 D9 06 20 04 90 01 90 17 4B 08 93 FF F7 FF FB 14 49 89 46 65 E6 04 99 01 91 00 29 F4 DA 00 22 01 92 F1 E7 0F 49 89 46 E6 E6 A1 46 57 E7 00 26 B0 46 FF F7 DC FB 02 9A 02 9B 12 68 04 33 90 46 00 2A 00 DB D6 E4 01 26 72 42 90 46 02 93 FF F7 CC FB 03 9A 0C 23 13 60 01 23 5B 42 05 93 8A E6 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "wcstok"
		size = 82
	strings:
		$1 = { F0 B5 00 28 20 D0 05 1C 40 CD 0C 1C 08 CC 00 2B 03 D0 9E 42 FA D1 28 1C F5 E7 00 2E 03 D1 10 E0 00 2B 03 D1 35 1C 2E 1C 80 CE 0C 1C 08 CC 9F 42 F6 D1 00 2F 03 D0 00 23 2B 60 16 60 F0 BD 00 26 FB E7 16 60 00 20 F9 E7 10 68 00 28 DB D1 00 20 F4 E7 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "wcslcat"
		size = 100
		refs = "0052 wcslen"
	strings:
		$1 = { 70 B5 03 68 00 2B 2A D0 00 2A 20 D0 54 1E 03 1C 02 E0 00 2C 04 D0 01 3C 04 33 1E 68 00 2E F8 D1 1C 1A A4 10 15 1B 00 2D 12 D0 0A 68 00 2A 14 D0 08 1C 01 2D 01 D0 04 C3 01 3D 04 30 02 68 00 2A F7 D1 40 1A 80 10 00 22 1A 60 00 19 70 BD 00 24 08 1C ?? ?? ?? ?? 00 19 F8 E7 00 20 F3 E7 03 1C 00 24 DF E7 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "_fcntl_r"
		size = 40
		refs = "0010 _fcntl 0024 errno"
	strings:
		$1 = { 30 B5 08 4C 05 1C 00 20 20 60 08 1C 11 1C 1A 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_2_0 {
	meta:
		name = "_execve_r"
		size = 40
		refs = "0010 _execve 0024 errno"
	strings:
		$1 = { 30 B5 08 4C 05 1C 00 20 20 60 08 1C 11 1C 1A 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "_lseek_r"
		size = 40
		refs = "0010 _lseek 0024 errno"
	strings:
		$1 = { 30 B5 08 4C 05 1C 00 20 20 60 08 1C 11 1C 1A 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "_open_r"
		size = 40
		refs = "0010 _open 0024 errno"
	strings:
		$1 = { 30 B5 08 4C 05 1C 00 20 20 60 08 1C 11 1C 1A 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "_read_r"
		size = 40
		refs = "0010 _read 0024 errno"
	strings:
		$1 = { 30 B5 08 4C 05 1C 00 20 20 60 08 1C 11 1C 1A 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "_write_r"
		size = 40
		refs = "0010 _write 0024 errno"
	strings:
		$1 = { 30 B5 08 4C 05 1C 00 20 20 60 08 1C 11 1C 1A 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "iswupper"
		size = 16
		refs = "0004 towlower"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 00 1B 43 1E 98 41 10 BD }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "iswlower"
		size = 16
		refs = "0004 towupper"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 00 1B 43 1E 98 41 10 BD }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "_fscanf_r"
		size = 24
		refs = "000c __svfscanf_r"
	strings:
		$1 = { 0C B4 00 B5 81 B0 02 AB 04 CB 00 93 ?? ?? ?? ?? 01 B0 08 BC 02 B0 18 47 }
	condition:
		$1
}

rule file_245_1_0 {
	meta:
		name = "_diprintf_r"
		size = 24
		refs = "000c _vdiprintf_r"
	strings:
		$1 = { 0C B4 00 B5 81 B0 02 AB 04 CB 00 93 ?? ?? ?? ?? 01 B0 08 BC 02 B0 18 47 }
	condition:
		$1
}

rule file_101_1_0 {
	meta:
		name = "_dprintf_r"
		size = 24
		refs = "000c _vdprintf_r"
	strings:
		$1 = { 0C B4 00 B5 81 B0 02 AB 04 CB 00 93 ?? ?? ?? ?? 01 B0 08 BC 02 B0 18 47 }
	condition:
		$1
}

rule file_164_1_0 {
	meta:
		name = "_fiprintf_r"
		size = 24
		refs = "000c _vfiprintf_r"
	strings:
		$1 = { 0C B4 00 B5 81 B0 02 AB 04 CB 00 93 ?? ?? ?? ?? 01 B0 08 BC 02 B0 18 47 }
	condition:
		$1
}

rule file_468_0_0 {
	meta:
		name = "_fiscanf_r"
		size = 24
		refs = "000c __svfiscanf_r"
	strings:
		$1 = { 0C B4 00 B5 81 B0 02 AB 04 CB 00 93 ?? ?? ?? ?? 01 B0 08 BC 02 B0 18 47 }
	condition:
		$1
}

rule file_237_1_0 {
	meta:
		name = "_fprintf_r"
		size = 24
		refs = "000c _vfprintf_r"
	strings:
		$1 = { 0C B4 00 B5 81 B0 02 AB 04 CB 00 93 ?? ?? ?? ?? 01 B0 08 BC 02 B0 18 47 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "fscanf"
		size = 36
		refs = "0012 __svfscanf_r 0020 _impure_ptr"
	strings:
		$1 = { 0E B4 00 B5 81 B0 02 AB 01 1C 05 48 04 CB 00 68 00 93 ?? ?? ?? ?? 01 B0 08 BC 03 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "diprintf"
		size = 36
		refs = "0012 _vdiprintf_r 0020 _impure_ptr"
	strings:
		$1 = { 0E B4 00 B5 81 B0 02 AB 01 1C 05 48 04 CB 00 68 00 93 ?? ?? ?? ?? 01 B0 08 BC 03 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "dprintf"
		size = 36
		refs = "0012 _vdprintf_r 0020 _impure_ptr"
	strings:
		$1 = { 0E B4 00 B5 81 B0 02 AB 01 1C 05 48 04 CB 00 68 00 93 ?? ?? ?? ?? 01 B0 08 BC 03 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "fiprintf"
		size = 36
		refs = "0012 _vfiprintf_r 0020 _impure_ptr"
	strings:
		$1 = { 0E B4 00 B5 81 B0 02 AB 01 1C 05 48 04 CB 00 68 00 93 ?? ?? ?? ?? 01 B0 08 BC 03 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_468_1_0 {
	meta:
		name = "fiscanf"
		size = 36
		refs = "0012 __svfiscanf_r 0020 _impure_ptr"
	strings:
		$1 = { 0E B4 00 B5 81 B0 02 AB 01 1C 05 48 04 CB 00 68 00 93 ?? ?? ?? ?? 01 B0 08 BC 03 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "fprintf"
		size = 36
		refs = "0012 _vfprintf_r 0020 _impure_ptr"
	strings:
		$1 = { 0E B4 00 B5 81 B0 02 AB 01 1C 05 48 04 CB 00 68 00 93 ?? ?? ?? ?? 01 B0 08 BC 03 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "strspn"
		size = 54
	strings:
		$1 = { 70 B5 04 78 00 2C 14 D0 0E 78 00 2E 11 D0 05 1C B4 42 09 D0 0B 1C 01 E0 94 42 05 D0 01 33 1A 78 00 2A F9 D1 28 1A 70 BD 01 35 2C 78 00 2C EF D1 F8 E7 00 20 F7 E7 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "_pvalloc_r"
		size = 32
		refs = "0010 _memalign_r"
	strings:
		$1 = { 10 B5 05 4C 80 23 0A 19 04 4C 5B 01 22 40 19 1C ?? ?? ?? ?? 10 BD C0 46 FF 0F 00 00 00 F0 FF FF }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "iso_year_adjust"
		size = 204
		refs = "0016 __modsi3"
	strings:
		$1 = { 30 B5 44 69 05 1C A3 07 20 D1 00 2C 4E DB 64 20 40 42 00 19 64 21 ?? ?? ?? ?? 00 28 16 D0 A8 69 EA 69 40 00 12 01 01 23 80 18 C0 18 21 28 20 DD 22 4B 98 42 22 DD 22 4B 98 42 2B D0 02 33 98 42 28 D0 04 3B 98 42 25 D0 00 20 16 E0 00 2C 2B DB 64 20 40 42 C8 21 00 19 49 00 ?? ?? ?? ?? EA 69 43 42 43 41 A8 69 12 01 40 00 80 18 C0 18 21 28 DE DC 20 28 10 DB 01 20 40 42 30 BD 04 3B 98 42 08 DA 20 3B 98 42 05 D0 98 42 DD DB 0D 4B C0 18 02 28 D9 D8 01 20 F0 E7 0D 28 09 DD 10 28 D3 DB 11 28 E8 DD 1C 38 05 E0 07 48 D3 E7 06 48 B0 E7 0A 28 E0 DA 01 28 DE D9 00 20 DE E7 C6 16 00 00 D5 16 00 00 4E E9 FF FF 6C 07 00 00 }
	condition:
		$1
}

rule file_15_1_0 {
	meta:
		name = "strftime"
		size = 2356
		refs = "0094 __modsi3 009e sprintf 010c __divsi3 0172 snprintf 0236 __gettzinfo 023c __tz_lock 0252 __tz_unlock 025e labs 0316 strftime 032c _tzname 071a strlen 0896 abs"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 07 1C C7 48 84 B0 88 46 1E 1C 00 24 81 46 13 78 25 2B 19 D0 00 2B 0C D1 42 46 00 2A 01 D0 00 23 3B 55 04 B0 20 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 41 46 01 39 8C 42 00 D3 99 E0 3B 55 01 32 13 78 01 34 25 2B E5 D1 53 78 55 1C 4F 2B 48 D0 45 2B 46 D0 1A 1C 25 3A 12 06 12 0E 55 2A 3C D8 B0 49 92 00 8A 58 97 46 43 46 0B 3B 9C 42 7F D2 B0 68 0C 28 00 D1 85 E3 00 28 00 D1 82 E3 AA 4A 39 19 8B 46 0C 21 92 46 ?? ?? ?? ?? 51 46 02 1C 58 46 ?? ?? ?? ?? 02 34 3A 23 3B 55 60 1C 9B 46 72 68 51 46 38 18 ?? ?? ?? ?? E3 1C 59 46 F9 54 20 1D 32 68 38 18 51 46 ?? ?? ?? ?? A3 1D 20 22 FA 54 B2 68 E3 1D 0B 2A 00 DD 81 E3 41 22 FA 54 08 34 4D 23 3B 55 2B 78 01 34 00 2B 9C D0 6A 1C 95 E7 01 35 2B 78 B5 E7 72 69 30 1C 93 46 FF F7 1B FF 5B 46 82 46 00 2B 00 DA C3 E3 58 46 64 21 ?? ?? ?? ?? 13 30 03 90 58 46 64 21 ?? ?? ?? ?? 53 46 00 2B 00 DA 40 E3 84 4A 01 23 93 45 00 DB 00 23 52 46 00 2A 00 DC 4B E3 00 2B 00 D1 48 E3 01 23 59 42 9C 46 8A 46 51 46 0A 18 50 1C 00 D1 5F E3 64 2A 00 D1 75 E3 00 2B 00 D1 3D E3 78 4B 9A 46 43 46 19 1B 63 46 00 93 03 9B 38 19 01 93 02 92 53 46 73 4A ?? ?? ?? ?? 24 18 A0 45 22 D8 00 24 56 E7 31 69 70 4B 89 00 5A 58 00 2A AE DD 01 22 52 42 92 46 C2 44 54 45 F1 D2 38 19 83 46 00 22 03 E0 01 20 83 44 54 45 E9 D2 59 18 89 6E 89 5C 58 46 01 70 31 69 89 00 58 58 01 32 84 46 01 34 94 45 EE DC 2B 78 00 2B 90 D1 2C E7 B1 69 5D 4B 89 00 5A 18 12 6B 00 2A 88 DD 01 22 52 42 92 46 C2 44 54 45 CB D2 38 19 83 46 00 22 03 E0 01 20 83 44 A2 45 C3 D9 59 18 C9 6C 89 5C 58 46 01 70 B1 69 89 00 58 18 00 6B 01 32 84 46 01 34 94 45 ED DC 2B 78 D7 E7 43 46 01 3B 9C 42 AF D2 25 23 3B 55 01 34 2B 78 CE E7 33 6A 00 2B 00 DA 5D E7 43 46 05 3B 9C 42 A2 D2 ?? ?? ?? ?? 82 46 ?? ?? ?? ?? 33 6A 00 2B 00 DC 1E E3 3C 23 50 46 C3 58 5B 42 9A 46 ?? ?? ?? ?? 3C 21 50 46 ?? ?? ?? ?? ?? ?? ?? ?? 39 19 03 91 E1 21 83 46 09 01 50 46 ?? ?? ?? ?? 3C 21 82 46 58 46 ?? ?? ?? ?? 32 49 03 1C 52 46 03 98 ?? ?? ?? ?? 2B 78 05 34 00 2B 00 D0 2B E7 C7 E6 01 23 9A 46 70 69 27 4B 98 42 00 DB 6A E2 00 28 00 DA 0A E3 64 21 ?? ?? ?? ?? 13 30 84 46 53 46 00 2B 00 D0 5B E2 24 48 03 90 42 46 02 23 11 1B 1A 1C 53 46 D2 1A 00 92 62 46 38 19 01 92 03 9B 1E 4A ?? ?? ?? ?? 24 18 A0 45 00 D8 4C E7 2B 78 6E E7 42 46 02 3A 94 42 00 D3 45 E7 6B 2B 00 D1 55 E2 0F 49 38 19 B2 68 ?? ?? ?? ?? 2B 78 02 34 00 2B 00 D0 EF E6 8B E6 42 46 11 1B 38 19 10 4A 33 1C ?? ?? ?? ?? 00 28 00 D1 2D E7 2B 78 24 18 00 2B 00 D0 DF E6 7B E6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 94 F8 FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 46 08 3B 9C 42 00 D3 0C E7 F0 68 33 69 83 46 70 69 9A 46 00 28 00 DA A0 E2 64 21 ?? ?? ?? ?? 52 46 03 1C 00 93 38 19 5B 46 01 32 D5 49 ?? ?? ?? ?? 2B 78 08 34 00 2B 00 D0 AA E6 46 E6 43 46 02 3B 9C 42 00 D3 ED E6 B3 69 00 2B 00 D0 EA E1 06 23 38 19 83 46 CC 49 F0 69 8A 46 07 30 20 E0 43 46 02 3B 9C 42 00 D3 DC E6 30 1C FF F7 B6 FD B3 69 00 2B 00 D0 D8 E1 06 21 8A 46 F2 69 93 46 00 28 00 DC 20 E2 01 22 85 E0 43 46 02 3B 9C 42 00 D3 C7 E6 BC 48 3B 19 82 46 F0 69 9B 46 B3 69 07 30 C0 1A 07 21 ?? ?? ?? ?? 51 46 02 1C 58 46 ?? ?? ?? ?? 2B 78 02 34 00 2B 00 D0 69 E6 05 E6 43 46 08 3B 9C 42 00 D3 AC E6 31 68 38 19 73 68 00 91 B2 68 AD 49 ?? ?? ?? ?? 2B 78 08 34 00 2B 00 D0 56 E6 F2 E5 43 46 02 3B 9C 42 00 D3 99 E6 A5 4A 92 46 38 19 32 68 51 46 ?? ?? ?? ?? 2B 78 02 34 00 2B 00 D0 44 E6 E0 E5 43 46 05 3B 9C 42 00 D3 87 E6 38 19 73 68 B2 68 9D 49 ?? ?? ?? ?? 2B 78 05 34 00 2B 00 D0 33 E6 CF E5 43 46 02 3B 9C 42 00 D3 76 E6 94 4A 92 46 38 19 72 68 51 46 ?? ?? ?? ?? 2B 78 02 34 00 2B 00 D0 21 E6 BD E5 42 46 02 3A 94 42 00 D3 64 E6 B0 68 0C 28 02 D0 00 28 00 D0 92 E1 31 23 3B 55 01 34 32 23 3B 55 2B 78 01 34 00 2B 00 D0 0B E6 A7 E5 43 46 02 3B 9C 42 00 D3 4E E6 70 69 00 28 00 DA F4 E1 64 21 ?? ?? ?? ?? 02 1C 7C 4B 38 19 19 1C ?? ?? ?? ?? 2B 78 02 34 00 2B 00 D0 F3 E5 8F E5 43 46 01 3B 9C 42 00 D3 36 E6 B3 69 30 33 3B 55 2B 78 01 34 00 2B 00 D0 E5 E5 81 E5 43 46 01 3B 9C 42 00 D3 28 E6 B3 69 00 2B EF D1 37 23 3B 55 2B 78 01 34 00 2B 00 D0 D5 E5 71 E5 43 46 01 3B 9C 42 00 D3 18 E6 09 23 3B 55 2B 78 01 34 00 2B 00 D0 C8 E5 64 E5 43 46 02 3B 9C 42 00 D3 0B E6 B3 68 0B 2B 00 DD 0D E1 41 23 3B 55 01 34 B4 E5 43 46 01 3B 9C 42 00 D3 FE E5 0A 23 3B 55 2B 78 01 34 00 2B 00 D0 AE E5 4A E5 43 46 02 3B 9C 42 00 D3 F1 E5 32 69 38 19 50 49 01 32 ?? ?? ?? ?? 2B 78 02 34 00 2B 00 D0 9D E5 39 E5 43 46 03 3B 9C 42 00 D3 E0 E5 F2 69 38 19 01 32 4A 49 ?? ?? ?? ?? 2B 78 03 34 00 2B 00 D0 8C E5 28 E5 43 46 02 3B 9C 42 00 D3 CF E5 30 1C FF F7 A9 FC 83 46 70 69 00 28 00 DA 76 E1 64 21 ?? ?? ?? ?? 59 46 00 29 00 DA E1 E0 5B 46 00 2B 06 D0 72 69 3B 4B 9A 42 02 DA 01 21 4A 42 93 46 34 49 3B 19 8A 46 58 44 64 21 03 93 ?? ?? ?? ?? 64 21 64 30 ?? ?? ?? ?? 51 46 02 1C 03 98 ?? ?? ?? ?? 2B 78 02 34 00 2B 00 D0 57 E5 F3 E4 42 46 02 3A 94 42 00 D3 9A E5 64 2B 00 D1 B6 E0 29 49 38 19 F2 68 ?? ?? ?? ?? 2B 78 02 34 00 2B 00 D0 44 E5 E0 E4 42 46 11 1B 38 19 23 4A 33 1C ?? ?? ?? ?? 00 28 00 D0 54 E6 00 24 D9 E4 E1 1C 8A 46 1F 49 40 46 01 38 3A 19 00 23 8C 46 84 42 00 D3 75 E5 31 69 89 00 61 44 89 6E C9 5C 01 34 11 70 01 33 01 32 54 45 F1 D1 2B 78 8C E5 E1 1C 8A 46 13 49 40 46 01 38 3A 19 00 23 8C 46 84 42 00 D3 5D E5 B1 69 89 00 61 44 C9 6C C9 5C 01 34 11 70 01 33 01 32 54 45 F1 D1 2B 78 74 E5 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 94 F8 FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 33 6A 00 2B 00 DA F0 E4 ?? ?? ?? ?? 33 6A 00 2B 00 DC E7 E0 04 23 4A 46 D0 58 ?? ?? ?? ?? 82 46 00 28 79 DD 01 21 49 42 8C 46 C4 44 64 45 00 D3 81 E0 3A 19 00 23 0B E0 04 21 48 46 41 58 C9 5C 01 33 11 70 01 34 9A 45 66 DD 01 32 64 45 72 D2 31 6A 00 29 F0 DC 00 21 EF E7 42 46 11 1B 38 19 6C 4A 33 1C ?? ?? ?? ?? 00 28 00 D0 D8 E5 00 24 5D E4 69 49 03 91 A2 E5 00 21 8A 46 91 E5 01 3B 13 E6 01 3B 9A 46 25 E6 50 23 3B 55 01 34 A6 E4 31 23 3B 55 01 34 32 23 3B 55 60 4B 01 34 9A 46 80 E4 5F 49 A8 E5 72 69 5E 4B 9A 42 00 DB B9 E4 01 21 8C 46 8A 46 01 23 C4 E4 58 49 47 E7 72 69 58 4B 9A 42 00 DB 22 E7 01 22 93 46 1F E7 02 22 D2 1A 94 46 B6 E4 54 48 82 46 C0 E4 50 22 FA 54 08 34 7C E4 49 2B 50 D0 4D 4A 93 46 3B 19 0C 21 9A 46 ?? ?? ?? ?? 59 46 02 1C 50 46 ?? ?? ?? ?? 2B 78 02 34 00 2B 00 D0 6F E4 FF F7 0B FC 03 99 01 39 03 91 63 22 9D E4 ?? ?? ?? ?? 2B 78 62 E4 00 28 12 D1 10 1C 53 46 0A 30 C0 1A 07 21 ?? ?? ?? ?? 02 1C 5B E6 ?? ?? ?? ?? 00 24 FF F7 F7 FB 03 9A 01 32 03 92 00 22 84 E4 70 69 03 90 00 28 5A DB 65 23 5B 42 03 99 5B 18 9A 07 44 D1 00 29 56 DB 65 20 40 42 03 9B 64 21 C0 18 ?? ?? ?? ?? 00 28 39 D0 01 23 50 46 59 46 42 1A D3 1A 04 2B 40 DD 34 22 33 E6 20 23 DF E4 24 49 8B 46 AD E7 26 49 08 1C 58 44 ?? ?? ?? ?? 64 21 ?? ?? ?? ?? 03 90 70 69 00 28 00 DB 35 E4 20 4A 80 18 ?? ?? ?? ?? 30 E4 1D 49 40 18 ?? ?? ?? ?? 59 E5 1B 4A 80 18 ?? ?? ?? ?? 64 21 ?? ?? ?? ?? 84 46 F0 E4 16 4A 80 18 ?? ?? ?? ?? 05 E6 14 4B C0 18 ?? ?? ?? ?? 83 E6 00 23 16 E7 03 98 00 28 0E DB 65 20 40 42 03 99 40 18 C8 21 49 00 ?? ?? ?? ?? 43 42 43 41 B8 E7 35 22 F2 E5 09 4B A4 E7 08 48 F0 E7 07 48 A8 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 95 F8 FF FF ?? ?? ?? ?? 6C 07 00 00 6B 07 00 00 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "wmemcmp"
		size = 54
	strings:
		$1 = { 30 B5 00 2A 0E D0 05 68 0C 68 A5 42 0C D1 00 23 05 E0 04 30 04 31 05 68 0C 68 A5 42 04 D1 01 33 9A 42 F6 D8 00 20 30 BD A5 42 02 DC 01 20 40 42 F9 E7 01 20 F7 E7 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "_fclose_r"
		size = 158
		refs = "000a __sfp_lock_acquire 0024 _fflush_r 0052 _free_r 006e __sfp_lock_release 0080 __sinit"
	strings:
		$1 = { 70 B5 05 1C 0C 1C 00 29 36 D0 ?? ?? ?? ?? 00 2D 02 D0 AB 6B 00 2B 32 D0 0C 22 A3 5E 00 2B 29 D0 28 1C 21 1C ?? ?? ?? ?? E3 6A 06 1C 00 2B 05 D0 E1 69 28 1C 00 F0 3E F8 00 28 2D DB A3 89 1A 06 25 D4 21 6B 00 29 08 D0 23 1C 40 33 99 42 02 D0 28 1C ?? ?? ?? ?? 00 23 23 63 61 6C 00 29 04 D0 28 1C ?? ?? ?? ?? 00 23 63 64 00 23 A3 81 ?? ?? ?? ?? 02 E0 ?? ?? ?? ?? 00 26 30 1C 70 BD 28 1C ?? ?? ?? ?? 0C 22 A3 5E 00 2B C9 D1 F2 E7 21 69 28 1C ?? ?? ?? ?? D4 E7 01 26 76 42 CE E7 }
	condition:
		$1
}

rule file_18_1_0 {
	meta:
		name = "fclose"
		size = 20
		refs = "0008 _fclose_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_5_0 {
	meta:
		name = "__sigtramp"
		size = 20
		refs = "0008 __sigtramp_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_306_1_0 {
	meta:
		name = "__srget"
		size = 20
		refs = "0008 __srget_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "cfree"
		size = 20
		refs = "0008 _free_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "close"
		size = 20
		refs = "0008 _close_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_339_1_0 {
	meta:
		name = "erand48"
		size = 20
		refs = "0008 _erand48_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "free"
		size = 20
		refs = "0008 _free_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_270_1_0 {
	meta:
		name = "ftell"
		size = 20
		refs = "0008 _ftell_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "ftello"
		size = 20
		refs = "0008 _ftell_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_177_1_0 {
	meta:
		name = "gets"
		size = 20
		refs = "0008 _gets_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_476_1_0 {
	meta:
		name = "jrand48"
		size = 20
		refs = "0008 _jrand48_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_117_1_0 {
	meta:
		name = "malloc"
		size = 20
		refs = "0008 _malloc_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "malloc_trim"
		size = 20
		refs = "0008 _malloc_trim_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_200_0_0 {
	meta:
		name = "malloc_usable_size"
		size = 20
		refs = "0008 _malloc_usable_size_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_252_1_0 {
	meta:
		name = "mstats"
		size = 20
		refs = "0008 _mstats_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_397_1_0 {
	meta:
		name = "nrand48"
		size = 20
		refs = "0008 _nrand48_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_228_1_0 {
	meta:
		name = "perror"
		size = 20
		refs = "0008 _perror_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_142_1_0 {
	meta:
		name = "putchar_unlocked"
		size = 20
		refs = "0008 _putchar_unlocked_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "putenv"
		size = 20
		refs = "0008 _putenv_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_1_0 {
	meta:
		name = "puts"
		size = 20
		refs = "0008 _puts_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "pvalloc"
		size = 20
		refs = "0008 _pvalloc_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_1_0 {
	meta:
		name = "raise"
		size = 20
		refs = "0008 _raise_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_63_1_0 {
	meta:
		name = "remove"
		size = 20
		refs = "0008 _remove_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_1_0 {
	meta:
		name = "rewind"
		size = 20
		refs = "0008 _rewind_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "sbrk"
		size = 20
		refs = "0008 _sbrk_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_188_0_0 {
	meta:
		name = "strdup"
		size = 20
		refs = "0008 _strdup_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_436_1_0 {
	meta:
		name = "system"
		size = 20
		refs = "0008 _system_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "times"
		size = 20
		refs = "0008 _times_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_407_4_0 {
	meta:
		name = "tmpnam"
		size = 20
		refs = "0008 _tmpnam_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "unlink"
		size = 20
		refs = "0008 _unlink_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "unsetenv"
		size = 20
		refs = "0008 _unsetenv_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_309_1_0 {
	meta:
		name = "valloc"
		size = 20
		refs = "0008 _valloc_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "wait"
		size = 20
		refs = "0008 _wait_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_365_1_0 {
	meta:
		name = "wctrans"
		size = 20
		refs = "0008 _wctrans_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_236_1_0 {
	meta:
		name = "wctype"
		size = 20
		refs = "0008 _wctype_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "strerror_r"
		size = 22
		refs = "0006 strerror 0010 strncpy"
	strings:
		$1 = { 30 B5 0D 1C 14 1C ?? ?? ?? ?? 22 1C 01 1C 28 1C ?? ?? ?? ?? 30 BD }
	condition:
		$1
}

rule file_21_1_0 {
	meta:
		name = "_siscanf_r"
		size = 80
		refs = "001a strlen 003c __ssvfiscanf_r 004c eofread"
	strings:
		$1 = { 0C B4 F0 B5 9B B0 81 23 20 AD 06 1C 6C 46 9B 00 08 1C 80 CD A3 81 00 91 04 91 ?? ?? ?? ?? 0B 4B 08 93 00 23 0C 93 11 93 01 23 5B 42 01 90 05 90 E3 81 30 1C 69 46 3A 1C 2B 1C 1A 95 ?? ?? ?? ?? 1B B0 F0 BC 08 BC 02 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_1_0 {
	meta:
		name = "_sscanf_r"
		size = 80
		refs = "001a strlen 003c __ssvfscanf_r 004c eofread"
	strings:
		$1 = { 0C B4 F0 B5 9B B0 81 23 20 AD 06 1C 6C 46 9B 00 08 1C 80 CD A3 81 00 91 04 91 ?? ?? ?? ?? 0B 4B 08 93 00 23 0C 93 11 93 01 23 5B 42 01 90 05 90 E3 81 30 1C 69 46 3A 1C 2B 1C 1A 95 ?? ?? ?? ?? 1B B0 F0 BC 08 BC 02 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_2_0 {
	meta:
		name = "siscanf"
		size = 80
		refs = "0016 strlen 003a __ssvfiscanf_r 0048 eofread 004c _impure_ptr"
	strings:
		$1 = { 0E B4 70 B5 9B B0 81 23 1F AD 6C 46 9B 00 40 CD A3 81 00 90 04 90 ?? ?? ?? ?? 0B 4B 08 93 00 23 0C 93 11 93 01 23 5B 42 E3 81 08 4B 01 90 05 90 69 46 32 1C 18 68 2B 1C 1A 95 ?? ?? ?? ?? 1B B0 70 BC 08 BC 03 B0 18 47 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_167_2_0 {
	meta:
		name = "sscanf"
		size = 80
		refs = "0016 strlen 003a __ssvfscanf_r 0048 eofread 004c _impure_ptr"
	strings:
		$1 = { 0E B4 70 B5 9B B0 81 23 1F AD 6C 46 9B 00 40 CD A3 81 00 90 04 90 ?? ?? ?? ?? 0B 4B 08 93 00 23 0C 93 11 93 01 23 5B 42 E3 81 08 4B 01 90 05 90 69 46 32 1C 18 68 2B 1C 1A 95 ?? ?? ?? ?? 1B B0 70 BC 08 BC 03 B0 18 47 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "strnlen"
		size = 38
	strings:
		$1 = { 00 29 0E D0 03 78 00 2B 0B D0 01 39 03 1C 03 E0 1A 78 01 39 00 2A 02 D0 01 33 00 29 F8 D1 18 1A 70 47 00 20 FC E7 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "envz_remove"
		size = 72
		refs = "000a envz_entry 0014 strlen 002e memmove 003a realloc"
	strings:
		$1 = { F0 B5 06 1C 0D 1C 00 68 09 68 ?? ?? ?? ?? 04 1C 00 28 18 D0 ?? ?? ?? ?? 33 68 29 68 47 1C 5A 18 20 18 82 42 07 D0 12 1B E1 19 D2 1B 20 1C ?? ?? ?? ?? 33 68 29 68 C9 1B 18 1C ?? ?? ?? ?? 2B 68 DF 1B 30 60 2F 60 F0 BD }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "getchar"
		size = 20
		refs = "0008 _getc_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 18 68 41 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "getchar_unlocked"
		size = 20
		refs = "0008 _getc_unlocked_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 18 68 41 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "_vsprintf_r"
		size = 48
		refs = "001e _svfprintf_r"
	strings:
		$1 = { 30 B5 9A B0 00 91 04 91 08 49 02 91 05 91 01 21 6C 46 49 42 82 25 AD 00 E1 81 69 46 A5 81 ?? ?? ?? ?? 00 9B 00 22 1A B0 1A 70 30 BD FF FF FF 7F }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "_vsiprintf_r"
		size = 48
		refs = "001e _svfiprintf_r"
	strings:
		$1 = { 30 B5 9A B0 00 91 04 91 08 49 02 91 05 91 01 21 6C 46 49 42 82 25 AD 00 E1 81 69 46 A5 81 ?? ?? ?? ?? 00 9B 00 22 1A B0 1A 70 30 BD FF FF FF 7F }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "funreader"
		size = 60
		refs = "000a __errno"
	strings:
		$1 = { F0 B5 0C 1C 16 1C 1D 1C 07 1C ?? ?? ?? ?? 00 23 03 60 31 1C 20 68 63 68 2A 1C 00 F0 32 F8 04 1C 00 28 01 DB 20 1C F0 BD ?? ?? ?? ?? 03 68 00 2B F8 D0 ?? ?? ?? ?? 03 68 3B 60 F3 E7 }
	condition:
		$1
}

rule file_26_1_0 {
	meta:
		name = "funwriter"
		size = 60
		refs = "000a __errno"
	strings:
		$1 = { F0 B5 0C 1C 16 1C 1D 1C 07 1C ?? ?? ?? ?? 00 23 03 60 31 1C 20 68 A3 68 2A 1C 00 F0 50 F8 04 1C 00 28 01 DB 20 1C F0 BD ?? ?? ?? ?? 03 68 00 2B F8 D0 ?? ?? ?? ?? 03 68 3B 60 F3 E7 }
	condition:
		$1
}

rule file_26_2_0 {
	meta:
		name = "funseeker"
		size = 60
		refs = "000a __errno"
	strings:
		$1 = { F0 B5 0C 1C 16 1C 1D 1C 07 1C ?? ?? ?? ?? 00 23 03 60 31 1C 20 68 E3 68 2A 1C 00 F0 6E F8 04 1C 00 28 01 DB 20 1C F0 BD ?? ?? ?? ?? 03 68 00 2B F8 D0 ?? ?? ?? ?? 03 68 3B 60 F3 E7 }
	condition:
		$1
}

rule file_26_3_0 {
	meta:
		name = "funcloser"
		size = 70
		refs = "000c __errno 0026 _free_r"
	strings:
		$1 = { 70 B5 0B 69 06 1C 0C 1C 00 2B 10 D0 ?? ?? ?? ?? 00 23 03 60 20 68 23 69 00 F0 15 F8 05 1C 00 28 07 DB 30 1C 21 1C ?? ?? ?? ?? 28 1C 70 BD 00 25 F7 E7 ?? ?? ?? ?? 03 68 00 2B F2 D0 ?? ?? ?? ?? 03 68 33 60 ED E7 }
	condition:
		$1
}

rule file_26_4_0 {
	meta:
		name = "_funopen_r"
		size = 176
		refs = "0014 __sfp 0022 _malloc_r 0092 __sfp_lock_acquire 0098 __sfp_lock_release 00a0 funreader 00a4 funwriter 00a8 funseeker 00ac funcloser"
	strings:
		$1 = { F0 B5 47 46 80 B4 06 1C 88 46 17 1C 1D 1C 00 2B 2C D0 30 1C ?? ?? ?? ?? 04 1C 00 28 22 D0 30 1C 14 21 ?? ?? ?? ?? 06 1C 00 28 32 D0 01 23 5B 42 E3 81 43 46 03 60 E0 61 00 2F 1D D0 18 4B 47 60 23 62 00 2D 20 D0 10 23 A3 81 16 4B 85 60 63 62 06 9B F3 60 00 2B 00 D0 13 4B A3 62 07 9B 33 61 12 4B E3 62 20 1C 04 BC 90 46 F0 BD 00 2A D0 D1 16 23 03 60 00 24 F5 E7 08 23 A3 81 09 4B 85 60 63 62 47 60 27 62 E3 E7 04 23 A3 81 85 60 65 62 DE E7 ?? ?? ?? ?? A6 81 ?? ?? ?? ?? 00 24 E1 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_5_0 {
	meta:
		name = "funopen"
		size = 40
		refs = "001a _funopen_r 0024 _impure_ptr"
	strings:
		$1 = { 70 B5 14 1C 07 4A 82 B0 06 1C 10 68 00 93 06 9B 0D 1C 01 93 31 1C 2A 1C 23 1C ?? ?? ?? ?? 02 B0 70 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "strlen"
		size = 104
	strings:
		$1 = { 30 B5 83 07 27 D0 03 78 00 2B 26 D0 03 1C 03 21 02 E0 1A 78 00 2A 1C D0 01 33 0B 42 F9 D1 1A 68 0F 4C 11 19 0F 4C 91 43 21 42 0F D1 04 33 1A 68 0B 4D 51 19 91 43 21 42 08 D1 04 33 1A 68 08 4D 51 19 91 43 21 42 F1 D0 00 E0 01 33 1A 78 00 2A FB D1 18 1A 30 BD 03 1C E1 E7 00 20 FA E7 C0 46 FF FE FE FE 80 80 80 80 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "_strtod_r"
		size = 3720
		refs = "029e __floatunsidf 02ba __muldf3 02d0 __adddf3 0320 __mprec_tens 0328 __fixdfsi 032c __floatsidf 0338 __subdf3 0360 __ltdf2 036e _Bfree 03ee __s2b 0436 __pow5mult 0442 __multiply 045e __lshift 049e __mdiff 04b0 __mcmp 04c4 __ratio 04d0 __ledf2 0528 __fixunsdfsi 0566 __ulp 05c4 _Balloc 05d4 memcpy 05e4 __d2b 05ee __i2b 0898 __gtdf2 08e6 __gethex 0908 __copybits 0998 __mprec_bigtens 0c72 __divdf3 0ce0 __nedf2 0e38 __hexnan"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 9B B0 0A 92 BF 4B BE 4A 18 91 12 92 13 93 BE 4A 04 1C 08 1C 03 78 2D 2B 5A D9 00 25 0B 95 30 2B 00 D1 7D E0 00 22 93 46 2F 2B 01 DC 00 F0 91 FD 39 2B 01 DD 00 F0 93 FD 42 1C 00 27 00 26 00 25 8C 46 0D E0 B1 00 8E 19 76 00 F6 18 30 3E 18 92 13 78 01 35 2F 2B 12 DD 01 32 39 2B 00 DD 73 E0 08 2D EF DD 0F 2D F2 DC B9 00 CF 19 7F 00 18 92 FB 18 1F 1C 13 78 30 3F 01 35 2F 2B EC DC 61 46 90 46 AC 46 2E 2B 00 D0 80 E1 43 46 01 33 18 93 42 46 65 46 53 78 00 2D 00 D1 C2 E2 02 90 00 20 08 90 82 46 18 1C 30 38 09 28 00 D9 DE E2 08 9B 18 9A 01 33 08 93 91 46 A8 46 00 28 01 D0 00 F0 53 FD 45 46 4B 46 01 33 18 93 48 46 43 78 E9 E7 9D 00 55 59 AF 46 01 23 0B 93 01 30 18 90 03 78 00 2B 9C D1 00 22 18 91 0B 92 00 23 0A 9D 00 2D 01 D0 18 99 29 60 0B 98 00 28 02 D0 80 21 09 06 5B 18 1B B0 18 1C 11 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 22 0B 92 DF E7 01 30 18 90 79 E7 43 78 45 1C 58 2B 00 D1 CE E3 78 2B 00 D1 CB E3 18 95 2B 78 28 1C 01 35 30 2B F9 D0 00 2B 00 D1 96 E0 01 25 AB 46 6F E7 61 46 00 22 02 90 08 92 04 92 AC 46 92 46 45 2B 2B D0 65 2B 29 D0 00 20 00 2D 00 D0 87 E0 08 9D 00 2D 00 D0 80 E0 58 46 00 28 7D D1 04 9A 00 2A B4 D1 4E 2B 01 D1 00 F0 49 FD 4E 2B 01 DD 00 F0 3D FD 49 2B AA D1 18 9B 5E 48 04 78 01 30 00 2C 01 D1 00 F0 DD FD 01 33 1A 78 40 2A 02 DD 5A 2A 00 DC 20 32 A2 42 F0 D0 98 E7 00 2D 03 D1 08 9A 00 2A 00 D1 51 E2 18 99 48 1C 18 90 4B 78 2B 2B 01 D1 00 F0 DB FB 2D 2B 00 D1 C4 E2 00 20 06 90 18 1C 30 38 09 28 00 D9 6F E3 30 2B 08 D1 18 98 08 9A 01 30 18 90 03 78 01 30 30 2B FA D0 08 92 18 1C 31 38 08 28 AE D8 30 3B 98 46 18 9B 01 20 99 46 81 44 4A 46 07 93 18 92 18 1C 5B 78 2F 2B 1A DD 39 2B 18 DC 89 46 08 99 42 46 02 30 88 46 02 E0 01 30 39 2B 09 DC 91 00 8A 18 18 90 30 3B 52 00 9A 18 03 78 01 1C 2F 2B F2 DC 40 46 08 90 90 46 4A 46 89 46 11 1C 07 98 4A 46 12 1A 08 2A 03 DC 2D 48 80 45 00 DC 83 E2 2B 48 06 9A 00 2A 00 D1 79 E7 40 42 77 E7 00 23 00 22 3A E7 53 46 C3 1A 60 46 07 93 00 28 00 D0 CC E1 AB 46 A8 46 10 2D 01 DD 10 21 88 46 30 1C ?? ?? ?? ?? 42 46 12 90 13 91 09 2A 15 DD 43 46 1C 4A 09 3B DB 00 D3 18 1A 68 5B 68 ?? ?? ?? ?? 04 90 05 91 38 1C ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? 12 90 13 91 0F 2D 64 DC 07 9B 00 2B 57 D0 07 98 00 28 01 DC 00 F0 B6 FC 16 28 01 DD 00 F0 70 FC 0A 4A C3 00 D3 18 1A 68 5B 68 12 98 13 99 ?? ?? ?? ?? 03 1C 0A 1C F5 E6 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 1F 4E 00 00 ?? ?? ?? ?? 49 46 58 46 ?? ?? ?? ?? ?? ?? ?? ?? 02 1C 0B 1C 58 46 49 46 ?? ?? ?? ?? 02 90 03 91 09 99 00 29 00 D0 9A E2 13 9B 00 2B 00 D0 96 E2 04 9A 12 03 00 D0 92 E2 02 98 03 99 C9 4B C8 4A ?? ?? ?? ?? 00 28 00 DB 16 E1 20 1C 17 99 ?? ?? ?? ?? 20 1C 41 46 ?? ?? ?? ?? 20 1C 39 1C ?? ?? ?? ?? 20 1C 31 1C ?? ?? ?? ?? 20 1C 29 1C ?? ?? ?? ?? 12 9B 13 9A AF E6 02 90 00 20 65 46 08 90 82 46 04 90 DD E6 40 46 07 99 2F 1A 7F 18 00 2F 00 DC CA E3 0F 23 3B 40 0A D0 B3 4A DB 00 D3 18 12 98 13 99 1A 68 5B 68 ?? ?? ?? ?? 12 90 13 91 0F 23 9F 43 00 D0 6F E1 12 99 13 9A 04 91 05 92 00 22 06 92 2B 1C 20 1C 02 99 5A 46 00 96 ?? ?? ?? ?? 07 9D 03 1C 0C 33 6D 42 06 1C 0C 93 0D 95 DE E0 A2 4D 48 19 06 99 8A 46 CA 44 C5 18 82 44 29 1C 55 45 00 DD 51 46 99 42 00 DD 19 1C 00 29 04 DD 50 46 40 1A 6D 1A 82 46 5B 1A 99 46 00 2A 10 D0 39 1C 20 1C ?? ?? ?? ?? 07 1C 39 1C 17 9A 20 1C ?? ?? ?? ?? 17 99 02 90 20 1C ?? ?? ?? ?? 02 99 17 91 00 2D 05 DD 20 1C 17 99 2A 1C ?? ?? ?? ?? 17 90 5A 46 00 2A 04 D0 41 46 20 1C ?? ?? ?? ?? 80 46 53 46 00 2B 05 DD 41 46 20 1C 52 46 ?? ?? ?? ?? 80 46 4D 46 00 2D 05 DD 39 1C 20 1C 4A 46 ?? ?? ?? ?? 07 1C 17 99 20 1C 42 46 ?? ?? ?? ?? 05 1C C0 68 00 23 09 90 EB 60 28 1C 39 1C ?? ?? ?? ?? 00 28 00 DA A6 E2 00 28 00 D1 EE E2 28 1C 39 1C ?? ?? ?? ?? 71 4A 72 4B 02 90 03 91 ?? ?? ?? ?? 00 28 00 DD 4F E1 09 98 00 28 00 D1 A5 E1 6D 49 6D 4A 14 91 15 92 12 9A 6C 4B 00 20 08 92 9B 46 81 46 08 98 6A 49 6B 4B 08 40 82 46 9A 45 00 D1 53 E1 D4 23 DB 04 9A 45 25 D8 06 9A 00 2A 22 D0 58 46 49 46 64 4A 65 4B ?? ?? ?? ?? 00 28 13 DC 58 46 49 46 ?? ?? ?? ?? 00 28 00 D1 01 20 ?? ?? ?? ?? 09 9B 83 46 89 46 00 2B 00 D1 B0 E1 01 1C 0A 1C 4B 46 14 92 15 93 14 9B D6 21 C9 04 5B 18 52 46 9B 1A 14 93 14 98 15 99 02 90 03 91 04 98 05 99 ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 04 9A 05 9B ?? ?? ?? ?? 12 90 13 91 12 99 04 91 06 9A 00 2A 05 D1 45 4B 04 98 03 40 9A 45 00 D1 C5 E6 20 1C 17 99 ?? ?? ?? ?? 20 1C 41 46 ?? ?? ?? ?? 20 1C 39 1C ?? ?? ?? ?? 20 1C 29 1C ?? ?? ?? ?? 12 98 13 99 04 90 05 91 71 68 20 1C ?? ?? ?? ?? 32 69 02 32 92 00 0C 99 80 46 0C 30 ?? ?? ?? ?? 19 A8 04 99 05 9A 00 90 1A AB 20 1C ?? ?? ?? ?? 01 21 17 90 20 1C ?? ?? ?? ?? 07 99 07 1C 00 29 00 DA 0D E1 8B 46 89 46 00 22 00 23 1A 9D 00 2D 00 DA 01 E1 5B 19 06 98 29 1A 19 9D 27 48 02 95 6D 18 AA 46 82 45 00 DA EF E6 02 99 36 25 68 1A ED E6 E3 46 31 E6 30 2B 00 D0 44 E3 00 23 45 46 08 93 02 35 00 22 18 95 2B 78 01 32 01 35 30 2B F9 D0 08 92 1D 1C 31 3D 08 2D 00 D9 83 E0 18 9D 08 98 02 95 A9 46 82 46 00 22 01 25 18 1C 90 46 08 95 30 38 2B E5 5B 46 00 2B 00 D1 3C E5 A8 E5 01 22 04 92 71 E5 C0 46 FF FF CF 3F 95 35 A0 94 ?? ?? ?? ?? 33 04 00 00 00 00 00 40 00 00 00 00 00 00 F0 3F 00 00 00 00 00 00 F0 3F 00 00 F0 7F 00 00 E0 7F FF FF DF 41 00 00 C0 FF 03 FC FF FF 9A 22 52 00 97 42 00 DD 3D E2 3F 11 01 2F 00 DC AA E3 B3 4A 00 23 90 46 04 92 01 22 9A 46 91 46 2B 1C 22 1C 12 98 13 99 55 46 44 46 9A 46 B0 46 16 1C 4B 46 1F 42 03 D0 22 68 63 68 ?? ?? ?? ?? 7F 10 01 35 08 34 01 2F F3 DC 12 90 13 91 53 46 34 1C AA 46 46 46 1D 1C 12 9B A2 48 51 46 1B 18 04 9A 12 93 CB 00 D3 18 1A 68 5B 68 12 98 13 99 ?? ?? ?? ?? 12 90 13 91 12 9B 9B 4A 9B 49 1A 40 8A 42 00 D9 FF E1 9A 49 8A 42 00 D8 DA E2 99 4B 12 93 01 23 5B 42 13 93 12 98 13 99 04 90 05 91 00 21 06 91 42 E6 02 90 00 25 01 20 AA 46 04 90 FB E4 01 22 06 92 43 1C 18 93 43 78 36 E5 40 46 7A E5 02 98 03 99 8C 4A 8C 4B ?? ?? ?? ?? 83 46 09 98 89 46 00 28 49 D0 59 46 0A 1C 4B 46 14 92 15 93 12 9B 08 93 08 98 7F 49 85 4B 08 40 82 46 9A 45 00 D0 AB E6 04 9A 05 9B 08 98 79 49 10 92 11 93 43 18 12 93 12 98 13 99 14 9A 15 9B 04 90 05 91 02 92 03 93 ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? 12 90 13 91 12 9B 6B 49 72 4A 19 40 91 42 59 D9 10 9A 6B 4B 9A 42 00 D1 90 E1 69 4B 12 93 01 23 5B 42 13 93 C3 E6 48 46 40 1B 81 46 FA E6 0D 9A 00 25 13 1C AB 46 A9 46 EF E6 80 22 12 06 11 1C 59 44 B1 E7 13 9B 00 2B 17 D1 12 99 08 91 0B 1C 09 03 15 D1 02 98 03 99 5F 4A 5F 4B ?? ?? ?? ?? 00 28 00 DB 91 E0 5D 4A 00 20 5D 49 93 46 81 46 0A 1C 03 1C 14 92 15 93 48 E6 01 2B 28 D0 12 9B 59 49 59 4A 14 91 15 92 59 4A 08 93 00 23 93 46 99 46 3B E6 02 98 03 99 56 4A 56 4B ?? ?? ?? ?? 00 28 00 DA 6C E5 02 98 03 99 53 4A 54 4B ?? ?? ?? ?? 00 28 00 DC 7A E6 62 E5 80 20 00 06 01 1C 59 44 4A E6 D4 21 89 04 59 18 04 91 12 91 65 E6 12 9B 00 2B D4 D1 4A 4A 4B 4B 12 92 13 93 22 23 23 60 4D E5 18 91 00 20 4B E4 17 AB 47 4F 00 93 0B 9B 20 1C 01 93 18 A9 16 AB 3A 1C ?? ?? ?? ?? 07 23 06 1C 03 40 98 46 00 D1 C2 E4 40 46 06 28 00 D1 65 E1 17 9A 00 2A 07 D0 39 68 0E A8 ?? ?? ?? ?? 20 1C 17 99 ?? ?? ?? ?? 41 46 16 9B 06 29 07 D8 8A 00 36 49 8A 58 97 46 1E 4B 12 93 00 23 13 93 33 07 00 D4 2F E5 80 23 12 98 1B 06 03 43 13 9A FF F7 DC FB 0E 9B 13 93 0F 9B 12 93 F0 E7 0E 9A 13 92 2B 4A 2B 49 9B 18 0F 9A 1B 05 0A 40 13 43 12 93 E5 E7 00 23 13 93 12 93 E1 E7 26 4B 12 93 01 23 5B 42 13 93 DB E7 0E 4A 0F 4B 02 98 03 99 ?? ?? ?? ?? 80 23 1B 06 83 46 89 46 19 1C 59 44 48 46 64 E7 00 22 06 92 EB E6 C0 46 ?? ?? ?? ?? 00 00 B0 FC 00 00 F0 7F 00 00 A0 7C 00 00 90 7C FF FF EF 7F 00 00 E0 3F 00 00 00 00 00 00 E0 7F FF FF 9F 7C 00 00 F0 3F 00 00 00 00 00 00 E0 3F 00 00 E0 BF 00 00 F0 BF 00 00 00 00 00 00 F0 3F FF FF DF 3F 95 35 A0 94 00 00 E0 3F 35 E5 AF 35 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 33 04 00 00 FF FF EF FF FF FF FF 7F 09 99 00 29 6E D1 13 9B 00 2B 6B D1 12 9A 13 1C 92 46 1B 03 66 D1 C8 4A 50 46 D6 23 02 40 DB 04 9A 42 5F D9 6B 69 00 2B 02 D1 2B 69 01 2B 59 DD 29 1C 20 1C 01 22 ?? ?? ?? ?? 39 1C 05 1C ?? ?? ?? ?? 00 28 4E DD 06 9A 00 2A 00 D1 68 E1 BA 4A 53 46 1A 40 D6 23 DB 04 9A 42 00 D9 60 E1 DC 23 9B 04 9A 42 00 D8 27 E7 B4 4B 10 93 00 23 11 93 10 98 11 99 04 9A 05 9B ?? ?? ?? ?? 12 90 13 91 12 9B 00 2B 00 D0 6C E4 13 9B 00 2B 00 D0 68 E4 22 23 23 60 65 E4 09 99 00 29 00 D1 CD E0 12 99 A7 4B 0A 1C 1A 40 9A 42 25 D1 06 9A 13 9B 00 2A 00 D1 AB E1 A0 4A 08 1C 10 40 D4 22 D2 04 90 42 00 D9 A3 E1 6B 22 00 0D 10 1A 01 22 52 42 82 40 93 42 11 D1 98 4B 19 40 80 23 5B 03 C9 18 00 23 12 91 13 93 06 99 00 29 00 D1 3A E4 12 9A 13 9B 04 92 05 93 B8 E7 13 9B DA 07 F3 D5 09 9B 00 2B 00 D1 DB E0 04 98 05 99 ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? 12 90 13 91 E2 E7 11 9B 01 33 00 D0 6A E6 22 23 83 4A 23 60 00 23 12 92 13 93 FF F7 16 FC 22 23 23 60 7F 4B 00 22 FF F7 D7 FA 00 2F 00 D0 9C E0 12 9A 13 9B 04 92 05 93 00 23 06 93 42 E4 00 26 80 46 00 27 B4 46 FF F7 93 FA 00 27 00 26 00 25 FF F7 F1 FA 08 9A 92 44 01 2A 19 D0 43 46 01 33 90 44 04 93 42 46 05 E0 B5 00 AE 19 76 00 01 33 93 42 08 D0 5D 1E 08 2D F6 DD 10 2B F7 DC BD 00 EF 19 7F 00 F3 E7 08 9A 04 9D 02 3A AD 18 A8 46 45 46 42 46 01 35 08 2A 61 DC B3 00 9E 19 76 00 00 23 36 18 08 93 FF F7 83 FA 18 95 00 23 00 22 FF F7 92 FA 0F 27 7F 1B 3B 1C 07 99 16 33 99 42 01 DD FF F7 E0 FB 59 4C FB 00 E3 18 1A 68 5B 68 12 98 13 99 ?? ?? ?? ?? 07 9A D7 1B FF 00 E4 19 22 68 63 68 ?? ?? ?? ?? 03 1C 0A 1C FF F7 74 FA 69 2B 01 D1 FF F7 C1 FA 6E 2B 01 D0 FF F7 68 FA 18 9A 4B 48 04 78 01 30 00 2C 73 D0 01 32 13 78 40 2B 02 DD 5A 2B 00 DC 20 33 A3 42 F2 D0 FF F7 57 FA 12 98 01 1C 82 46 09 03 00 D0 57 E7 13 9B 00 2B 00 D0 54 E7 FA E6 07 9B 16 33 01 DA FF F7 A2 FB 07 9D 39 4A EB 00 D3 1A 1A 68 5B 68 12 98 13 99 ?? ?? ?? ?? 03 1C 0A 1C FF F7 3D FA 10 2D 34 DD 00 20 08 90 FF F7 23 FA 7F 42 0F 23 3B 40 0A D0 2E 4A DB 00 D3 18 12 98 13 99 1A 68 5B 68 ?? ?? ?? ?? 12 90 13 91 3F 11 00 2F 6D D1 12 98 13 99 04 90 05 91 00 21 06 91 FF F7 93 FB 00 22 08 92 C3 E4 04 98 05 99 ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? 1E 4A 1F 4B 12 90 13 91 ?? ?? ?? ?? 00 28 00 D0 00 E7 E9 E5 BB 00 DF 19 7F 00 00 22 3F 18 08 92 FF F7 EA F9 D4 22 92 04 9B 18 12 93 12 98 13 99 04 90 05 91 00 21 06 91 FF F7 68 FB 53 1C 18 93 53 78 28 2B 00 D1 87 E0 0E 4B 00 22 FF F7 E8 F9 05 4A 50 46 0C 49 02 40 05 4B 52 18 13 43 12 93 01 23 5B 42 13 93 D5 E6 00 00 F0 7F 00 00 50 39 FF FF 0F 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 F8 7F 00 00 F0 FF 18 93 41 49 1C 1C 08 78 01 31 00 28 53 D0 01 33 1A 78 40 2A 02 DD 5A 2A 00 DC 20 32 82 42 F2 D0 63 1C 18 93 DB E6 1F 2F 3C DC FA 06 4B D5 6A 23 06 93 00 2F 17 DD 01 23 34 4A 9A 46 12 98 13 99 23 1C A8 46 14 1C 1D 1C 52 46 17 42 03 D0 22 68 63 68 ?? ?? ?? ?? 7F 10 08 34 00 2F F4 D1 12 90 13 91 2C 1C 45 46 06 9B 00 2B 0F D0 12 99 4B 00 5B 0D 6B 22 D3 1A 00 2B 08 DD 1F 2B 35 DD 00 22 13 92 34 2B 39 DD DC 23 9B 04 12 93 12 98 13 99 1F 4A 20 4B 04 90 05 91 ?? ?? ?? ?? 00 28 01 D0 FF F7 EE FA 22 23 23 60 00 22 00 23 FF F7 72 F9 01 22 52 42 5E E6 01 33 18 93 90 E6 16 48 00 23 9A 46 04 90 72 E4 00 20 06 90 B2 E7 13 49 18 A8 14 31 0E AA ?? ?? ?? ?? 05 28 00 D0 6E E7 0F 98 0F 4B 0E 9A 03 43 FF F7 55 F9 01 22 52 42 9A 40 13 1C 13 9A 13 40 13 93 C8 E7 01 22 20 3B 52 42 9A 40 11 40 12 91 C1 E7 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 F0 7F }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "strtof"
		size = 52
		refs = "000c _strtod_r 0014 __isnand 0020 __truncdfsf2 0028 nanf 0030 _impure_ptr"
	strings:
		$1 = { 30 B5 0A 1C 0A 49 03 1C 08 68 19 1C ?? ?? ?? ?? 04 1C 0D 1C ?? ?? ?? ?? 00 28 04 D1 20 1C 29 1C ?? ?? ?? ?? 30 BD 00 20 ?? ?? ?? ?? FA E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_2_0 {
	meta:
		name = "strtod"
		size = 24
		refs = "000c _strtod_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_332_1_0 {
	meta:
		name = "__swbuf"
		size = 24
		refs = "000c __swbuf_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_378_1_0 {
	meta:
		name = "_findenv"
		size = 24
		refs = "000c _findenv_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_381_0_0 {
	meta:
		name = "calloc"
		size = 24
		refs = "000c _calloc_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_352_1_0 {
	meta:
		name = "fdopen"
		size = 24
		refs = "000c _fdopen_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_192_1_0 {
	meta:
		name = "fgetpos"
		size = 24
		refs = "000c _fgetpos_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_224_1_0 {
	meta:
		name = "fopen"
		size = 24
		refs = "000c _fopen_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_71_1_0 {
	meta:
		name = "fputs"
		size = 24
		refs = "000c _fputs_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_338_1_0 {
	meta:
		name = "fsetpos"
		size = 24
		refs = "000c _fsetpos_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "fstat"
		size = 24
		refs = "000c _fstat_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_1_0 {
	meta:
		name = "fwide"
		size = 24
		refs = "000c _fwide_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "gettimeofday"
		size = 24
		refs = "000c _gettimeofday_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_368_0_0 {
	meta:
		name = "kill"
		size = 24
		refs = "000c _kill_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "link"
		size = 24
		refs = "000c _link_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_252_3_0 {
	meta:
		name = "mallopt"
		size = 24
		refs = "000c _mallopt_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "memalign"
		size = 24
		refs = "000c _memalign_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_302_4_0 {
	meta:
		name = "open_memstream"
		size = 24
		refs = "000c _open_memstream_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "realloc"
		size = 24
		refs = "000c _realloc_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_462_1_0 {
	meta:
		name = "reallocf"
		size = 24
		refs = "000c _reallocf_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_178_0_0 {
	meta:
		name = "rename"
		size = 24
		refs = "000c _rename_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_257_4_0 {
	meta:
		name = "setlocale"
		size = 24
		refs = "000c _setlocale_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_7_0 {
	meta:
		name = "signal"
		size = 24
		refs = "000c _signal_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_412_0_0 {
	meta:
		name = "stat"
		size = 24
		refs = "000c _stat_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_288_0_0 {
	meta:
		name = "strndup"
		size = 24
		refs = "000c _strndup_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_407_2_0 {
	meta:
		name = "tempnam"
		size = 24
		refs = "000c _tempnam_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_1_0 {
	meta:
		name = "towctrans"
		size = 24
		refs = "000c _towctrans_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_98_2_0 {
	meta:
		name = "ungetc"
		size = 24
		refs = "000c _ungetc_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 03 49 03 1C 08 68 19 1C ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "argz_create_sep"
		size = 186
		refs = "0040 strdup 004c strlen 005e strsep 0068 malloc 0074 free 00a2 memcpy"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 1D 1C 82 B0 00 23 07 1C 16 1C 00 93 2B 60 00 28 02 D0 02 78 00 2A 09 D1 00 23 33 60 00 20 02 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 01 AA 11 70 53 70 92 46 ?? ?? ?? ?? 00 24 80 46 00 90 06 E0 ?? ?? ?? ?? 2B 68 01 33 18 18 28 60 01 34 68 46 51 46 ?? ?? ?? ?? 00 28 F2 D1 28 68 ?? ?? ?? ?? 30 60 00 28 21 D0 40 46 ?? ?? ?? ?? 38 1C ?? ?? ?? ?? 00 90 83 46 35 68 00 2C 11 D0 00 27 51 46 68 46 ?? ?? ?? ?? 80 46 ?? ?? ?? ?? 46 1C 41 46 28 1C 32 1C 01 37 ?? ?? ?? ?? AD 19 BC 42 EE DC 58 46 ?? ?? ?? ?? 00 20 B9 E7 0C 20 B7 E7 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "atexit"
		size = 16
		refs = "000a __register_exitproc"
	strings:
		$1 = { 00 B5 01 1C 00 22 00 20 00 23 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "print_e"
		size = 256
		refs = "0020 _dtoa_r 0094 __divsi3 00f4 strcpy"
	strings:
		$1 = { F0 B5 87 B0 0C 9F 0E 1C 11 1C 1A 1C 7B 1C 00 93 04 AB 01 93 06 AB 02 93 05 AB 03 93 02 23 0D 9D ?? ?? ?? ?? 04 9C 35 4B 2D 06 2D 0E 01 1C 9C 42 5F D0 03 78 0E 9A 33 70 73 1C 00 2A 01 D1 00 2F 11 D0 2E 20 70 70 4A 1C 49 78 01 33 00 29 0A D0 00 2F 08 DD 19 70 01 32 01 3F 01 33 11 78 00 2F 01 DD 00 29 F6 D1 67 2D 36 D0 47 2D 3F D0 00 2F 05 DD DF 19 30 22 1A 70 01 33 BB 42 FB D1 1D 70 5D 1C 01 3C 2D D4 2B 22 5A 70 01 35 20 1C 63 28 0F DD 64 21 ?? ?? ?? ?? 03 1C 30 33 2B 70 43 06 1B 1A 9B 00 1B 18 DB 00 18 1A 80 00 00 19 01 35 04 1C 0A 21 ?? ?? ?? ?? 42 07 12 1A 92 00 03 1C 10 1A 40 00 30 33 04 19 2B 70 30 34 6B 1C 00 22 6C 70 5A 70 07 B0 F0 BD 65 25 1D 70 5D 1C 01 3C D1 D5 2D 22 60 42 5A 70 01 35 04 1C CF E7 45 25 C5 E7 30 1C ?? ?? ?? ?? EC E7 C0 46 0F 27 00 00 }
	condition:
		$1
}

rule file_31_1_0 {
	meta:
		name = "_gcvt"
		size = 472
		refs = "0024 __ltdf2 003a __eqdf2 004c __ledf2 0056 _mprec_log10 008e _dtoa_r 01ac strcpy"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 87 B0 1C 1C 0F 9B 1B 06 1B 0E 80 46 0D 1C 16 1C 9A 46 08 1C 11 1C 68 4B 66 4A 0E 9F ?? ?? ?? ?? 00 28 02 DA 80 20 00 06 2D 18 28 1C 31 1C 62 4B 60 4A ?? ?? ?? ?? 00 28 00 D1 83 E0 28 1C 31 1C 5E 4A 5F 4B ?? ?? ?? ?? 00 28 69 DD 20 1C ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 00 28 60 DD 28 1C 31 1C 58 4A 58 4B ?? ?? ?? ?? 00 28 00 DA 6D E0 06 AB 01 93 05 AB 02 93 04 AB 03 93 29 1C 40 46 32 1C 02 23 00 94 ?? ?? ?? ?? 01 1C 06 9A 4F 4B 9A 42 00 D1 85 E0 08 78 00 28 00 D1 85 E0 00 2A 00 DC 84 E0 3B 1C 01 E0 00 2A 16 DD 01 3A 18 70 06 92 01 31 08 78 01 33 01 3C 00 28 F4 D1 00 2C 0B DD 00 2A 09 DD 30 20 01 3A 01 3C 18 70 01 33 06 92 00 2C 01 DD 00 2A F6 DC 10 98 00 28 02 D1 08 78 00 28 19 D0 BB 42 57 D0 2E 20 18 70 E0 17 00 1B C0 0F 01 33 00 28 01 D0 00 2A 3F DB 0A 78 00 28 39 D1 10 9A 00 2A 07 D0 00 2C 05 DD 1C 19 30 22 1A 70 01 33 A3 42 FB D1 00 22 1A 70 0B E0 10 9B 52 46 01 3C 01 92 02 93 40 46 39 1C 2A 1C 33 1C 00 94 FF F7 E0 FE 07 B0 38 1C 0C BC 90 46 9A 46 F0 BD 30 23 3B 70 78 70 F5 E7 06 AB 01 93 05 AB 02 93 04 AB 03 93 29 1C 40 46 32 1C 03 23 00 94 ?? ?? ?? ?? 01 1C 90 E7 1A 70 01 31 01 3C 01 33 0A 78 00 2C C5 DD 00 2A C3 D0 F5 E7 30 25 01 3C E0 17 00 1B 01 32 C0 0F 1D 70 01 33 06 92 00 28 B4 D0 00 2A B2 DA F2 E7 30 20 18 70 01 33 A3 E7 38 1C ?? ?? ?? ?? C6 E7 3B 1C 87 E7 3B 1C 93 E7 C0 46 00 00 00 00 00 00 00 00 E2 36 1A 3F 2D 43 1C EB 00 00 F0 3F 00 00 00 00 0F 27 00 00 }
	condition:
		$1
}

rule file_31_2_0 {
	meta:
		name = "ecvtbuf"
		size = 160
		refs = "0028 _dtoa_r 0082 _realloc_r 009c _impure_ptr"
	strings:
		$1 = { F0 B5 88 B0 0E 9D 04 90 05 91 14 1C 1E 1C 00 2D 29 D0 22 4B 18 68 0D 9B 02 93 07 AB 03 93 04 99 05 9A 02 23 00 94 01 96 ?? ?? ?? ?? 07 9B 98 42 20 D2 2B 1C 00 21 02 78 1A 70 07 9A 01 30 01 33 01 31 82 42 F7 D8 8C 42 08 DD 00 22 30 26 9E 54 01 32 50 18 84 42 FA DC 64 1A 1B 19 00 22 1A 70 28 1C 08 B0 F0 BD 0D 4F 38 68 03 6D A3 42 04 DD 45 6D D0 E7 2B 1C 00 21 E5 E7 53 1C 41 6D 1A 1C 06 93 ?? ?? ?? ?? 05 1C 00 28 04 D0 38 68 06 9B 45 65 03 65 BF E7 00 20 E3 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_3_0 {
	meta:
		name = "fcvtbuf"
		size = 276
		refs = "002a __ltdf2 003a __gtdf2 0056 _dtoa_r 00e4 _realloc_r 0100 _impure_ptr"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 86 B0 0E 1C 0F 99 05 1C 14 1C 1F 1C 88 46 00 29 4D D0 38 4B 1B 68 9A 46 28 1C 31 1C 37 4A 37 4B ?? ?? ?? ?? 00 28 07 DA 28 1C 31 1C 35 4A 35 4B ?? ?? ?? ?? 00 28 2D DC 0E 99 05 AB 02 91 03 93 50 46 29 1C 32 1C 03 23 00 94 01 97 ?? ?? ?? ?? 39 68 05 9B 49 42 98 42 36 D2 43 46 02 78 1A 70 05 9A 01 30 01 33 01 31 82 42 F7 D8 8C 42 08 DD 00 22 30 25 9D 54 01 32 50 18 84 42 FA DC 64 1A 1B 19 00 22 1A 70 40 46 06 B0 1C BC 90 46 99 46 A2 46 F0 BD 0E 9B 02 93 05 AB 03 93 50 46 29 1C 32 1C 02 23 00 94 01 97 ?? ?? ?? ?? D0 E7 11 4A 13 68 9A 46 51 46 91 46 23 1C 0A 6D 23 33 9A 42 04 DD 4A 6D 90 46 A7 E7 43 46 CF E7 23 1C 24 33 52 46 51 6D 50 46 1A 1C 04 93 ?? ?? ?? ?? 80 46 00 28 D1 D0 4B 46 1B 68 04 99 42 46 9A 46 19 65 5A 65 91 E7 C0 46 ?? ?? ?? ?? 00 00 F0 3F 00 00 00 00 00 00 F0 BF 00 00 00 00 }
	condition:
		$1
}

rule file_31_4_0 {
	meta:
		name = "_dcvt"
		size = 336
		refs = "004e _gcvt 006c _dtoa_r 013e strcpy"
	strings:
		$1 = { F0 B5 87 B0 0D 1C 0E 99 BB 26 09 06 36 06 0F 0E 89 19 09 0E 0C 9C 22 29 0C D8 4B 4E 89 00 71 58 8F 46 2B 1C 0F 9E 00 2E 4D D1 06 78 00 2E 4A D1 00 22 1A 70 07 B0 28 1C F0 BD 00 2C 00 D1 01 24 0F 99 02 91 11 1C 1A 1C 23 1C 00 95 01 97 ?? ?? ?? ?? EF E7 00 2C 5C D1 06 A9 01 91 05 A9 02 91 04 A9 03 91 11 1C 1A 1C 03 23 00 94 ?? ?? ?? ?? 06 9A 36 4B 01 1C 9A 42 60 D0 07 78 00 2F 61 D0 00 2A CE DD 2B 1C 01 E0 00 2A CB DD 01 3A 1F 70 06 92 01 30 07 78 01 33 00 2F F5 D1 00 2A C1 DD 30 27 01 3A 1F 70 01 33 06 92 00 2A F9 DC 0F 9E 00 2E 08 D1 B9 E7 0F 9E 29 1C 00 94 01 97 02 96 FF F7 58 FD B6 E7 81 42 34 D0 2E 21 19 70 E1 17 09 1B C9 0F 01 33 00 29 01 D0 00 2A 1C DB 02 78 00 29 0A D1 00 2C A3 DD 1C 19 30 22 1A 70 01 33 A3 42 FB D1 00 22 1A 70 9C E7 00 2A F2 D0 1A 70 01 30 01 3C 01 33 02 78 00 2C F6 DC 00 22 1A 70 90 E7 01 21 0F 91 9F E7 30 26 01 3C E1 17 09 1B 01 32 C9 0F 1E 70 01 33 06 92 00 29 D7 D0 00 2A D5 DA F2 E7 30 21 19 70 01 33 C6 E7 28 1C ?? ?? ?? ?? 77 E7 2B 1C A9 E7 ?? ?? ?? ?? 0F 27 00 00 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "fileno"
		size = 32
		refs = "0012 __sinit 001c _impure_ptr"
	strings:
		$1 = { 10 B5 06 4B 04 1C 18 68 00 28 04 D0 83 6B 00 2B 01 D1 ?? ?? ?? ?? 0E 23 E0 5E 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "_fcloseall_r"
		size = 16
		refs = "0004 _fwalk_reent 000c _fclose_r"
	strings:
		$1 = { 00 B5 02 49 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_9_0 {
	meta:
		name = "_cleanup_r"
		size = 16
		refs = "0004 _fwalk 000c fclose"
	strings:
		$1 = { 00 B5 02 49 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "fcloseall"
		size = 16
		refs = "0006 _fcloseall_r 000c _global_impure_ptr"
	strings:
		$1 = { 00 B5 02 4B 18 68 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_10_0 {
	meta:
		name = "_cleanup"
		size = 16
		refs = "0006 _cleanup_r 000c _global_impure_ptr"
	strings:
		$1 = { 00 B5 02 4B 18 68 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_18_0 {
	meta:
		name = "_close"
		size = 18
		refs = "0002 _swiclose"
	strings:
		$1 = { 00 B5 ?? ?? ?? ?? 43 1C 00 D0 00 BD FF F7 BE FE FB E7 }
	condition:
		$1
}

rule file_104_3_0 {
	meta:
		name = "_init_signal"
		size = 16
		refs = "0006 _init_signal_r 000c _impure_ptr"
	strings:
		$1 = { 00 B5 02 4B 18 68 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_22_0 {
	meta:
		name = "_lseek"
		size = 18
		refs = "0002 _swilseek"
	strings:
		$1 = { 00 B5 ?? ?? ?? ?? 43 1C 00 D0 00 BD FF F7 2A FE FB E7 }
	condition:
		$1
}

rule file_254_1_0 {
	meta:
		name = "drand48"
		size = 16
		refs = "0006 _drand48_r 000c _impure_ptr"
	strings:
		$1 = { 00 B5 02 4B 18 68 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_0_1 {
	meta:
		name = "fma"
		size = 16
		refs = "0002 __muldf3 000a __adddf3"
	strings:
		$1 = { 00 B5 ?? ?? ?? ?? 01 9A 02 9B ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "fork"
		size = 16
		refs = "0006 _fork_r 000c _impure_ptr"
	strings:
		$1 = { 00 B5 02 4B 18 68 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_370_0_0 {
	meta:
		name = "getpid"
		size = 16
		refs = "0006 _getpid_r 000c _impure_ptr"
	strings:
		$1 = { 00 B5 02 4B 18 68 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_277_1_0 {
	meta:
		name = "lrand48"
		size = 16
		refs = "0006 _lrand48_r 000c _impure_ptr"
	strings:
		$1 = { 00 B5 02 4B 18 68 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_252_2_0 {
	meta:
		name = "malloc_stats"
		size = 16
		refs = "0006 _malloc_stats_r 000c _impure_ptr"
	strings:
		$1 = { 00 B5 02 4B 18 68 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_1_0 {
	meta:
		name = "mrand48"
		size = 16
		refs = "0006 _mrand48_r 000c _impure_ptr"
	strings:
		$1 = { 00 B5 02 4B 18 68 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_1_0 {
	meta:
		name = "tmpfile"
		size = 16
		refs = "0006 _tmpfile_r 000c _impure_ptr"
	strings:
		$1 = { 00 B5 02 4B 18 68 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "tzset"
		size = 16
		refs = "0006 _tzset_r 000c _impure_ptr"
	strings:
		$1 = { 00 B5 02 4B 18 68 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "hsearch"
		size = 24
		refs = "000a hsearch_r"
	strings:
		$1 = { 00 B5 04 4B 82 B0 00 93 01 AB ?? ?? ?? ?? 01 98 02 B0 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "iscntrl"
		size = 20
		refs = "0010 __ctype_ptr__"
	strings:
		$1 = { 03 4B 1B 68 18 18 40 78 20 23 18 40 70 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "lldiv"
		size = 98
		refs = "0018 __divdi3 0028 __moddi3"
	strings:
		$1 = { 81 B0 F0 B5 47 46 80 B4 06 93 88 46 15 1C 04 1C 08 1C 11 1C 06 9A 07 9B ?? ?? ?? ?? 06 9A 07 9B 06 1C 0F 1C 40 46 29 1C ?? ?? ?? ?? 84 46 0B 1C 62 46 00 2D 01 DB 00 2B 0A DB 26 60 67 60 20 1C A2 60 E3 60 04 BC 90 46 F0 BC 08 BC 01 B0 18 47 01 20 00 21 36 18 4F 41 06 98 07 99 12 1A 8B 41 EB E7 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "iswalnum"
		size = 28
		refs = "0004 iswalpha 0012 iswdigit"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 00 28 01 D0 01 20 10 BD 20 1C ?? ?? ?? ?? 43 1E 98 41 F8 E7 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "_iprintf_r"
		size = 26
		refs = "000e _vfiprintf_r"
	strings:
		$1 = { 0E B4 00 B5 81 B0 02 AB 04 CB 81 68 00 93 ?? ?? ?? ?? 01 B0 08 BC 03 B0 18 47 }
	condition:
		$1
}

rule file_51_1_0 {
	meta:
		name = "_printf_r"
		size = 26
		refs = "000e _vfprintf_r"
	strings:
		$1 = { 0E B4 00 B5 81 B0 02 AB 04 CB 81 68 00 93 ?? ?? ?? ?? 01 B0 08 BC 03 B0 18 47 }
	condition:
		$1
}

rule file_38_1_0 {
	meta:
		name = "iprintf"
		size = 36
		refs = "0012 _vfiprintf_r 0020 _impure_ptr"
	strings:
		$1 = { 0F B4 00 B5 06 49 81 B0 02 AB 08 68 04 CB 81 68 00 93 ?? ?? ?? ?? 01 B0 08 BC 04 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "printf"
		size = 36
		refs = "0012 _vfprintf_r 0020 _impure_ptr"
	strings:
		$1 = { 0F B4 00 B5 06 49 81 B0 02 AB 08 68 04 CB 81 68 00 93 ?? ?? ?? ?? 01 B0 08 BC 04 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "eisinf"
		size = 40
	strings:
		$1 = { 42 8A 08 4B 1A 40 9A 42 01 D0 00 20 70 47 02 1C 12 32 03 88 02 30 00 2B F7 D1 90 42 F9 D1 01 20 F4 E7 C0 46 FF 7F 00 00 }
	condition:
		$1
}

rule file_39_1_0 {
	meta:
		name = "emovi"
		size = 148
	strings:
		$1 = { 70 B5 12 22 83 5E 05 1C 12 35 00 2B 3A DB 00 23 0B 80 02 31 1E 4C 2B 88 23 40 0B 80 0E 88 26 40 AA 1E 8B 1C A6 42 0D D0 00 20 9C 1C 48 80 23 1C 16 31 10 88 18 80 02 33 02 3A 8B 42 F9 D1 00 23 63 82 70 BD 2C 88 34 40 B4 42 0C D0 18 31 00 22 1A 80 02 33 8B 42 F4 D0 1A 80 02 33 8B 42 F7 D1 EF E7 A8 42 F2 D0 04 88 02 30 00 2C F9 D0 00 20 18 80 18 31 02 33 10 88 18 80 02 33 02 3A 8B 42 F9 D1 DE E7 01 23 5B 42 0B 80 02 31 C2 E7 C0 46 FF 7F 00 00 }
	condition:
		$1
}

rule file_39_2_0 {
	meta:
		name = "eshdn1"
		size = 64
	strings:
		$1 = { F0 B5 0E 49 05 1C 03 1D 18 35 00 22 01 24 01 27 02 20 8C 46 02 E0 52 04 12 0C 02 33 19 88 21 42 02 D0 3A 43 12 04 12 0C 49 08 19 80 02 42 02 D0 66 46 31 43 19 80 AB 42 ED D1 F0 BD 00 80 FF FF }
	condition:
		$1
}

rule file_39_3_0 {
	meta:
		name = "eshup1"
		size = 58
	strings:
		$1 = { 70 B5 03 1C 18 33 05 1D 00 22 01 26 02 24 0B E0 49 04 09 0C 19 80 22 42 01 D0 31 43 19 80 AB 42 0A D0 52 04 12 0C 02 3B 19 88 08 04 00 28 EF DA 32 43 12 04 12 0C EB E7 70 BD }
	condition:
		$1
}

rule file_39_4_0 {
	meta:
		name = "m16m"
		size = 120
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 87 B0 00 23 6E 46 00 04 18 4C 00 0C F3 82 33 83 6F 46 6B 46 84 46 16 33 16 31 05 A8 02 37 A0 46 4C 88 00 2C 0F D0 65 46 65 43 44 46 2C 40 A2 46 5C 88 2D 0C 54 44 AA 46 1D 88 5C 80 55 44 24 0C 2C 19 1C 80 24 0C 02 3B 04 80 02 39 02 38 BB 42 E6 D1 00 23 F0 18 80 88 D1 18 02 33 88 80 16 2B F8 D1 07 B0 0C BC 90 46 9A 46 F0 BD FF FF 00 00 }
	condition:
		$1
}

rule file_39_5_0 {
	meta:
		name = "edivm"
		size = 436
		refs = "011c __udivsi3"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0B 88 93 86 0D 1C 6B 88 8F B0 11 1C D3 86 03 90 13 1C 02 92 38 33 4E 31 00 22 1A 80 02 33 8B 42 FB D1 28 1C FF F7 6C FF 03 9A D2 88 2B 1D 99 46 13 04 9B 1A 04 93 18 23 5B 19 A9 1D 98 46 03 9B 05 91 00 21 00 91 18 33 49 46 06 92 6E 46 AA 1C 07 93 01 91 08 AF 92 46 22 36 01 24 01 99 05 9A 08 88 13 88 00 04 C0 18 04 9B 98 42 4F D9 4D 48 81 46 03 99 3A 1C FF F7 81 FF 00 23 FA 18 E9 18 92 88 89 88 8A 42 49 D1 02 33 16 2B F6 D1 43 46 00 21 0E AA AC 46 1D 88 10 88 28 1A 40 1A 01 0C 18 80 02 3B 21 40 02 3A 53 45 F4 D1 02 99 00 9A 8B 18 49 46 19 87 01 9B 65 46 41 46 5A 88 1A 80 02 33 8B 42 FA D1 88 46 00 99 01 9A 00 23 02 31 93 82 00 91 16 29 C1 D1 91 46 2A 1C 1A 32 00 20 4B 46 19 88 02 33 08 43 93 42 FA D1 02 99 00 23 CA 18 92 8E EA 52 02 33 1A 2B F9 D1 0F B0 43 1E 98 41 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 06 99 ?? ?? ?? ?? 00 04 00 0C 81 46 AA E7 91 42 B6 D2 4B 46 01 3B 07 99 1B 04 1B 0C 99 46 0A 1C 00 20 0E AB 8C 46 AB 46 1D 88 11 88 69 1A 09 1A 08 0C 19 80 02 3B 20 40 02 3A B3 42 F4 D1 00 23 5D 46 FA 18 E8 18 92 88 80 88 61 46 82 42 09 D1 02 33 16 2B 00 D1 93 E7 FA 18 E8 18 92 88 80 88 82 42 F5 D0 90 42 00 D3 8A E7 00 22 0E AB AC 46 1D 88 08 88 28 1A 80 1A 02 0C 18 80 02 3B 22 40 02 39 B3 42 F4 D1 4B 46 01 3B 1B 04 1B 0C 65 46 99 46 75 E7 C0 46 FF FF 00 00 }
	condition:
		$1
}

rule file_39_6_0 {
	meta:
		name = "emulm"
		size = 196
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 90 46 13 1C 0A 88 8B 46 41 46 8A 86 59 46 4A 88 34 33 5A 80 89 B0 00 22 00 24 45 46 A9 18 02 32 0C 87 16 2A FA D1 A8 46 18 22 05 1C 1C 1D 02 30 D2 18 00 21 00 90 01 94 92 46 16 35 89 46 9E 1C 01 27 68 88 00 28 22 D1 52 46 13 88 49 46 19 43 89 46 53 46 02 3B 1A 88 5A 80 A3 42 FA D1 01 9A 00 99 00 23 02 3D 13 80 8D 42 EA D1 00 23 59 46 40 46 C2 18 92 8E CA 52 02 33 1A 2B F9 D1 09 B0 48 46 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 59 46 02 AA FF F7 99 FE 53 46 00 21 08 AA A4 46 1C 88 10 88 20 18 40 18 01 0C 18 80 02 3B 39 40 02 3A B3 42 F4 D1 64 46 C7 E7 }
	condition:
		$1
}

rule file_39_7_0 {
	meta:
		name = "ecmp"
		size = 184
	strings:
		$1 = { 70 B5 42 8A 2B 4B 1A 40 8E B0 0C 1C 9A 42 1F D0 62 8A 28 4B 1A 40 9A 42 28 D0 07 AD 29 1C FF F7 EF FD 6E 46 69 46 20 1C FF F7 EA FD 29 88 33 88 8B 42 25 D0 00 23 EA 18 52 88 00 2A 2E D1 F2 18 52 88 00 2A 2A D1 02 33 16 2B F4 D1 00 20 0B E0 01 1C 12 31 03 1C 01 E0 8B 42 D9 D0 1A 88 02 33 00 2A F9 D0 02 20 40 42 0E B0 70 BD 22 1C 12 32 23 1C 19 88 02 33 00 29 F4 D1 93 42 F9 D1 CC E7 00 2B 0F D0 01 20 40 42 00 23 EA 5A F1 5A 8A 42 0A D1 02 33 18 2B F8 D1 00 20 E5 E7 00 29 06 D1 01 20 E1 E7 01 20 EF E7 91 42 DC D2 DC E7 01 20 40 42 D9 E7 FF 7F 00 00 }
	condition:
		$1
}

rule file_39_8_0 {
	meta:
		name = "eshift"
		size = 284
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 06 1C 0F 1C 00 29 31 D0 04 1C 18 34 00 29 33 DB 0F 29 0D DD 04 30 00 25 03 1C 5A 88 1A 80 02 33 A3 42 FA D1 10 39 85 82 0F 29 F5 DC 0F 23 1F 40 07 2F 13 DD BC 46 B5 1C 23 1C 00 21 1A 88 10 02 01 43 19 80 02 3B 11 0A AB 42 F7 D1 08 23 5B 42 9C 44 62 46 07 2A EF DC 07 23 1F 40 00 2F 05 DD 30 1C 01 3F FF F7 D5 FD 00 2F F9 DC 00 20 1C BC 90 46 99 46 A2 46 F0 BD 4F 42 0F 2F 47 DD 00 25 31 1D 38 1C 88 46 AC 46 23 88 1D 43 23 1C 02 3B 1A 88 5A 80 8B 42 FA D1 63 46 42 46 10 38 13 80 0F 28 F1 DC 0F 23 1F 40 07 2F 1E DD 32 1D 1A 23 91 46 9B 19 FF 22 B8 46 9C 46 92 46 23 88 52 46 13 40 1D 43 00 21 4B 46 1A 88 10 06 12 0A 11 43 19 80 02 33 01 0C 63 45 F6 D1 08 23 5B 42 98 44 42 46 07 2A EA DC 07 23 1F 40 00 2F 0B DD 01 23 98 46 23 88 42 46 13 40 30 1C 01 3F 1D 43 FF F7 68 FD 00 2F F5 DC 28 1C 43 1E 98 41 AF E7 00 25 CA E7 }
	condition:
		$1
}

rule file_39_9_0 {
	meta:
		name = "enormlz"
		size = 218
	strings:
		$1 = { F0 B5 47 46 80 B4 83 88 06 1C 05 1D 00 2B 30 D1 C3 88 1A 04 87 1D 00 2A 52 DB 01 1C 00 24 18 31 00 20 00 2B 0C D1 2B 1C 5A 88 1A 80 02 33 8B 42 FA D1 10 34 A8 82 A0 2C 2B D0 3B 88 00 2B F2 D0 FF 22 12 02 13 42 3E D1 18 23 9B 19 98 46 B5 1C 94 46 43 46 00 21 1A 88 10 02 01 43 19 80 02 3B 11 0A AB 42 F7 D1 3B 88 62 46 08 34 13 42 F0 D0 29 E0 FF 22 12 02 13 42 0F D1 00 24 00 E0 2B 88 00 2B 06 D0 30 1C 01 3C FF F7 1A FD 23 1C 90 33 F5 DA 20 1C 04 BC 90 46 F0 BD 04 1C 18 34 2A 1C 00 20 02 E0 02 32 13 88 08 1C 19 06 1B 0A 03 43 09 0C 13 80 A2 42 F5 D1 08 24 B3 88 64 42 DF E7 00 24 E6 E7 3B 88 1B 04 00 2B E2 DB 30 1C 01 34 FF F7 16 FD A0 2C F5 DD DB E7 }
	condition:
		$1
}

rule file_39_10_0 {
	meta:
		name = "emdnorm"
		size = 752
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 84 B0 1D 1C 04 1C 88 46 91 46 0E 9E FF F7 84 FF B0 4B 2D 1A 9D 42 0F DC 90 28 0D DD A3 1C 00 22 1A 34 1A 80 02 33 A3 42 FB D1 04 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 2D 00 DA AB E0 0D 9B 00 2B 18 D1 18 22 12 19 92 46 52 46 00 23 13 80 A0 4A 95 42 0A DD A0 4B 00 22 63 80 04 34 02 23 01 33 22 80 02 34 0C 2B FA D1 DE E7 00 2D 00 DA D4 E0 65 80 D9 E7 31 68 72 68 8A 42 27 D0 33 1C 30 1C 1A 33 34 30 00 21 19 80 02 33 83 42 FB D1 38 2A 00 D1 FC E0 38 2A 00 DD AD E0 18 2A 00 D1 C8 E0 35 2A 00 D1 E7 E0 0C 23 B3 60 01 23 5B 42 B3 82 8A 4B F3 82 01 23 33 83 0B 23 F3 60 0B 21 01 23 0C 31 49 00 71 18 32 60 4B 80 11 1C 00 2D 6C DD 27 1C 18 37 BA 46 B3 68 58 00 20 18 01 90 02 93 B3 8A 00 88 00 93 84 46 03 93 03 1C 00 98 03 40 8F 29 24 DC 02 98 01 30 0C 28 00 DD DE E0 41 00 09 19 8C 46 01 21 8B 46 00 21 8A 46 61 46 94 46 0A 88 00 2A 03 D0 5A 46 13 43 1B 04 1B 0C 52 46 01 30 0A 80 02 31 0D 28 F2 D1 02 99 48 00 20 18 01 90 B1 8A 00 88 03 91 62 46 BA 46 84 46 03 98 61 46 81 43 01 98 01 80 F1 8A 0B 42 49 D0 8B 42 3E D0 1A 36 B4 46 11 1C 00 23 62 46 00 20 01 26 8C 46 F9 5A 88 46 D1 18 09 8B 41 44 09 18 F9 52 02 3B 08 0C 19 1C 30 40 16 31 F2 D1 62 46 00 2D 31 DD A3 88 00 2B 00 D1 5E E7 20 1C FF F7 23 FC 01 35 59 E7 28 1C 90 30 63 DA A3 1C 00 22 1A 34 1A 80 02 33 A3 42 FB D1 3E E7 40 29 37 D0 90 29 6F D0 22 8B 01 23 13 40 40 46 18 43 80 46 20 1C FF F7 09 FC 27 1C 72 68 18 37 BA 46 11 1C 82 E7 41 46 00 29 6C D1 F3 68 5B 00 19 5B 33 8B 19 42 B7 D1 BA 46 CB E7 40 2A CB D0 90 2A C9 D0 20 1C FF F7 11 FC C5 E7 40 2A 25 D0 71 2A 00 D0 52 E7 35 4B B3 82 80 23 DB 01 F3 82 33 4B 0A 21 33 83 80 23 B1 60 F1 60 1B 02 52 E7 63 80 04 E7 B3 68 02 93 5B 00 B0 8A 1B 5B 27 1C 00 90 03 40 18 37 60 E7 04 21 FF 23 B3 82 80 23 F3 82 5B 00 B1 60 33 83 F1 60 3C E7 07 23 B3 60 01 23 5B 42 B3 82 22 4B F3 82 01 23 33 83 06 23 F3 60 06 21 01 23 2E E7 20 1C 29 1C FF F7 C8 FD 00 28 00 D1 E5 E6 01 21 88 46 E2 E6 19 4B B3 82 80 23 DB 00 F3 82 80 23 06 21 1B 01 B1 60 33 83 F1 60 18 E7 06 21 D0 E7 B0 68 40 00 20 18 01 90 B3 8A 01 88 03 93 03 98 27 1C 0B 1C 18 37 8C 46 03 40 BA 46 46 E7 4B 46 00 2B 00 D1 4C E7 BA 46 60 E7 02 99 48 00 20 18 01 90 00 99 00 88 03 91 84 46 BA 46 36 E7 C0 46 FE 7F 00 00 FF 7F 00 00 00 80 FF FF FF 07 00 00 }
	condition:
		$1
}

rule file_39_11_0 {
	meta:
		name = "eiremain"
		size = 226
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 86 B0 05 92 93 46 34 22 0C 1C 93 44 46 88 05 1C FF F7 0A FE 30 1A 02 90 20 1C 66 88 FF F7 04 FE 05 99 36 1A 4E 31 5B 46 00 22 1A 80 02 33 8B 42 FB D1 02 9B B3 42 38 DC 18 22 92 46 2B 1C 22 1C 18 33 18 32 03 93 04 92 01 23 DA 44 A7 1C 98 46 00 23 EA 18 91 88 E2 18 92 88 91 42 36 D1 02 33 16 2B F6 D1 03 9A 04 9B 00 21 A4 46 1C 88 10 88 20 1A 40 1A 01 0C 44 46 18 80 02 3B 21 40 02 3A BB 42 F3 D1 01 22 64 46 91 46 58 46 FF F7 4C FB 52 46 13 88 4A 46 13 43 52 46 13 80 20 1C FF F7 43 FB 02 9B 01 3E B3 42 D2 DD 05 9A 00 23 00 93 01 92 33 1C 20 1C 00 21 00 22 FF F7 23 FE 06 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 91 42 C9 D9 00 22 91 46 D9 E7 }
	condition:
		$1
}

rule file_39_12_0 {
	meta:
		name = "enan"
		size = 148
	strings:
		$1 = { 30 B5 40 29 3D D0 40 29 11 DD 90 29 28 D0 D0 29 15 D0 71 29 0A D1 1C 4C 08 25 18 34 00 23 00 22 E1 5A 01 32 C1 52 02 33 95 42 F9 DC 30 BD 18 29 23 D0 35 29 FA D1 14 4C 04 25 0C 34 EE E7 13 4B 82 1C 00 21 43 80 01 80 93 1C 51 80 10 4A 1A 30 5A 80 04 33 00 22 1A 80 02 33 83 42 FB D1 E5 E7 01 1C 10 31 03 1C 00 22 1A 80 02 33 8B 42 FB D1 07 4A 02 82 05 4A 5A 80 D8 E7 03 4C 02 25 14 34 CC E7 06 25 00 4C C9 E7 ?? ?? ?? ?? FF 7F 00 00 00 C0 FF FF }
	condition:
		$1
}

rule file_39_13_0 {
	meta:
		name = "emovo"
		size = 144
	strings:
		$1 = { 70 B5 02 88 0B 1C 12 33 84 1C 00 2A 15 D0 45 88 1D 4A 2A 43 4A 82 02 34 A5 1E 2D 88 1B 4E 0A 1C 10 32 B5 42 13 D0 20 1C A3 1C 14 30 19 88 02 33 11 80 02 3A 83 42 F9 D1 70 BD 42 88 02 34 4A 82 A5 1E 2D 88 11 4E 0A 1C 10 32 B5 42 EB D1 42 88 2A 40 AA 42 09 D0 00 22 0A 80 02 31 99 42 FB D1 0A 88 0A 4B 13 43 0B 80 E6 E7 06 30 03 22 04 88 00 2C 04 D1 01 32 02 30 0D 2A F8 D1 EB E7 08 1C 90 21 FF F7 73 FF D7 E7 00 80 FF FF FF 7F 00 00 }
	condition:
		$1
}

rule file_39_14_0 {
	meta:
		name = "emul"
		size = 516
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 14 1C 9A 46 42 8A 79 4B 07 1C 1A 40 91 B0 05 1C 0E 1C 12 37 9A 42 41 D0 12 22 92 19 90 46 73 4B 72 8A 1A 40 9A 42 48 D0 28 1C FF F7 FD F9 00 28 52 D1 30 1C FF F7 F8 F9 00 28 05 D0 28 1C 6C 49 FF F7 06 FC 00 28 4D D0 28 1C FF F7 ED F9 00 28 5B D0 3A 88 65 4B 11 1C 19 40 99 42 47 D0 D0 0B 43 46 1A 88 61 4B 11 1C 19 40 99 42 46 D0 D3 0B 98 42 00 D1 6E E0 5F 4B 63 82 21 1C 12 31 23 1C 00 22 1A 80 02 33 8B 42 FB D1 62 8A 57 4B 13 43 63 82 11 B0 0C BC 90 46 9A 46 F0 BD 03 1C 01 E0 BB 42 B9 D0 1A 88 02 33 00 2A F9 D0 00 23 EA 5A E2 52 02 33 14 2B FA D1 EB E7 33 1C 01 E0 43 45 B2 D0 1A 88 02 33 00 2A F9 D0 00 23 F2 5A E2 52 02 33 14 2B FA D1 DC E7 30 1C 45 49 FF F7 B8 FB 00 28 A6 D1 20 1C 90 21 FF F7 F4 FE D1 E7 2B 88 02 35 00 2B 33 D1 BD 42 F9 D1 B0 E7 33 88 02 36 00 2B 2A D1 46 45 F9 D1 B1 E7 30 1C FF F7 8C F9 00 28 9E D1 0A AF 28 1C 39 1C 03 AD FF F7 98 F9 30 1C 29 1C FF F7 94 F9 7A 88 6E 88 90 46 00 2A 17 D1 0B AB 10 A9 03 E0 1A 88 02 33 00 2A 4A D1 8B 42 F9 D1 22 1C 14 32 00 23 23 80 02 34 94 42 FB D1 9E E7 00 23 63 82 8F E7 00 23 88 E7 00 20 7E E7 33 1C 02 96 00 2B 15 D1 04 AB 09 A9 03 E0 1A 88 02 33 00 2A 09 D1 8B 42 F9 D1 22 1C 14 32 00 23 23 80 02 34 94 42 FB D1 82 E7 28 1C FF F7 49 FC 30 1A 02 90 29 1C 52 46 38 1C FF F7 F6 FA 15 4A 13 1C 02 9A 43 44 9B 18 40 22 00 92 52 46 01 1C 01 92 28 1C 00 22 FF F7 A2 FC 3A 88 2B 88 9A 42 0F D0 01 23 5B 42 2B 80 28 1C 21 1C 52 46 FF F7 CA FE 5D E7 38 1C FF F7 24 FC 40 42 80 46 6B 88 BF E7 00 23 2B 80 EF E7 C0 46 FF 7F 00 00 ?? ?? ?? ?? 00 80 FF FF 02 C0 FF FF }
	condition:
		$1
}

rule file_39_15_0 {
	meta:
		name = "e53toe"
		size = 320
	strings:
		$1 = { F0 B5 87 B0 6C 46 17 1C 0E 1C 6D 46 1A 34 6B 46 00 22 1A 80 02 33 A3 42 FB D1 03 88 00 22 2A 80 1A 04 00 2A 00 DA 74 E0 0F 22 1A 40 10 21 11 43 94 46 40 4A 09 04 09 0C 13 40 A9 80 93 42 38 D0 1B 09 00 2B 16 D0 F0 22 92 01 9B 18 6B 80 42 88 EA 80 83 1C 5A 88 2A 81 05 21 9B 88 68 46 49 42 6B 81 FF F7 53 FB 68 46 31 1C 3A 1C FF F7 7E FE 07 B0 F0 BD 10 23 99 43 F0 23 9B 01 A9 80 6B 80 42 88 EA 80 83 1C 5A 88 2A 81 05 21 9B 88 68 46 49 42 6B 81 FF F7 3A FB 68 46 FF F7 C5 FB 90 28 3B DD 6B 46 02 33 00 22 1A 80 02 33 A3 42 FB D1 D9 E7 62 46 00 2A 27 D1 43 88 00 2B 24 D1 83 88 00 2B 21 D1 C3 88 00 2B 1E D1 31 1C 14 31 33 1C 00 22 1A 80 02 33 8B 42 FB D1 32 1C 12 32 33 1C 00 21 19 80 02 33 93 42 FB D1 71 8A 12 4B 28 88 19 43 71 82 00 28 BB D0 08 1C 18 40 98 42 11 D0 0E 4B 59 40 11 80 B3 E7 30 1C 90 21 FF F7 E4 FD AE E7 01 22 52 42 2A 80 86 E7 6B 88 01 33 18 1A 68 80 A0 E7 33 88 02 36 00 2B A1 D1 B2 42 F9 D1 E6 E7 C0 46 F0 7F 00 00 FF 7F 00 00 00 80 FF FF }
	condition:
		$1
}

rule file_39_16_0 {
	meta:
		name = "ediv"
		size = 556
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 14 1C 9A 46 42 8A 82 4B 07 1C 1A 40 90 B0 05 1C 0E 1C 12 37 9A 42 43 D0 12 22 92 19 90 46 7C 4B 72 8A 1A 40 9A 42 4A D0 7B 4B 28 1C 19 1C 99 46 FF F7 43 FA 00 28 51 D0 28 1C FF F7 2A F8 00 28 04 D0 30 1C FF F7 25 F8 00 28 4D D1 30 1C FF F7 20 F8 00 28 5B D0 3A 88 6E 4B 11 1C 19 40 99 42 47 D0 D0 0B 43 46 1A 88 6A 4B 11 1C 19 40 99 42 46 D0 D3 0B 98 42 57 D0 68 4B 63 82 21 1C 12 31 23 1C 00 22 1A 80 02 33 8B 42 FB D1 62 8A 60 4B 13 43 63 82 10 B0 1C BC 90 46 99 46 A2 46 F0 BD 03 1C 01 E0 BB 42 B7 D0 1A 88 02 33 00 2A F9 D0 00 23 EA 5A E2 52 02 33 14 2B FA D1 EA E7 33 1C 01 E0 43 45 B0 D0 1A 88 02 33 00 2A F9 D0 00 23 F2 5A E2 52 02 33 14 2B FA D1 DB E7 30 1C 49 46 FF F7 EB F9 00 28 A7 D1 20 1C 90 21 FF F7 27 FD D0 E7 2B 88 02 35 00 2B 3B D1 BD 42 F9 D1 B0 E7 33 88 02 36 00 2B 32 D1 46 45 F9 D1 B1 E7 28 1C FE F7 BF FF 00 28 0A D0 22 1C 14 32 00 23 23 80 02 34 94 42 FB D1 B5 E7 00 23 63 82 A6 E7 09 AF 28 1C 39 1C 02 AD FE F7 C0 FF 30 1C 29 1C FE F7 BC FF 6A 88 7E 88 90 46 00 2A 14 D1 03 AB 08 A9 03 E0 1A 88 02 33 00 2A 4E D1 8B 42 F9 D1 22 1C 14 32 00 23 23 80 02 34 94 42 FB D1 92 E7 00 23 80 E7 00 20 76 E7 33 1C B1 46 00 2B 1C D1 0A AB 0F A9 03 E0 1A 88 02 33 00 2A 10 D1 8B 42 F9 D1 3A 88 2B 88 9A 42 36 D0 20 4B 63 82 21 1C 12 31 23 1C 00 22 1A 80 02 33 8B 42 FB D1 6E E7 38 1C FF F7 6D FA 30 1A 81 46 29 1C 52 46 38 1C FF F7 40 F8 16 4A 13 1C 43 44 4A 46 9B 1A 40 22 00 92 52 46 01 1C 01 92 28 1C 00 22 FF F7 C6 FA 3A 88 2B 88 9A 42 12 D0 01 23 5B 42 2B 80 28 1C 21 1C 52 46 FF F7 EE FC 4D E7 28 1C FF F7 48 FA 40 42 80 46 7B 88 B8 E7 00 23 63 82 C7 E7 00 23 2B 80 EC E7 FF 7F 00 00 ?? ?? ?? ?? 00 80 FF FF FF 3F 00 00 }
	condition:
		$1
}

rule file_39_17_0 {
	meta:
		name = "_ldcheck"
		size = 80
	strings:
		$1 = { 10 B5 01 23 9D B0 5B 42 00 93 90 23 01 93 03 68 44 68 1B 93 1C 94 14 AC 6A 46 1B A8 21 1C FF F7 4F FF 62 8A 09 4B 1A 40 9A 42 02 D0 00 20 1D B0 10 BD 6A 46 62 32 23 88 02 34 00 2B 03 D1 94 42 F9 D1 02 20 F3 E7 01 20 F1 E7 C0 46 FF 7F 00 00 }
	condition:
		$1
}

rule file_39_18_0 {
	meta:
		name = "_strtold"
		size = 1568
		refs = "001c strlen 0250 free 0418 calloc"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 01 23 EB B0 5B 42 40 93 90 23 05 90 07 91 41 93 ?? ?? ?? ?? 84 1C C8 2C 00 DD F5 E1 69 46 00 20 38 31 0B 90 04 91 05 98 03 78 20 2B 00 D0 56 E2 05 9B 00 22 01 33 19 78 01 32 20 29 FA D0 92 46 00 2C 00 DC 77 E2 04 98 1A 78 01 1C 02 70 01 31 00 2A 09 D0 00 22 04 E0 98 5C 08 70 01 31 00 28 02 D0 01 32 94 42 F7 DC 00 23 0B 70 41 99 D1 22 52 00 90 23 6A 44 62 AC 09 91 41 93 90 46 23 1C 00 22 1A 80 02 33 43 45 FB D1 00 20 04 9B 06 90 0A 90 0C 90 02 90 08 90 0D 90 03 90 1E 1C 32 78 17 1C 30 3F 01 25 11 1C 09 2F 10 D8 02 9B 00 2B 14 D1 03 98 00 28 11 D1 00 2F 0F D1 02 9B 03 93 01 36 32 78 17 1C 30 3F 11 1C 09 2F EE D9 7A 2A 00 D9 8A E0 BD 4B 92 00 9B 58 9F 46 03 98 03 06 00 2B 30 D0 0A 9B 00 2B 2D D1 3B 06 1B 0E 09 2B 00 D9 22 E2 33 1C 01 33 19 78 08 1C 30 38 00 06 00 0E 09 28 F7 D9 7F 20 01 40 45 29 0B D0 65 29 09 D0 0A 29 07 D0 00 29 05 D0 20 29 03 D0 0D 29 01 D0 2C 29 61 D1 01 3B 19 78 30 29 06 D1 7A 21 19 70 01 3B 1A 78 30 2A FA D0 32 78 7A 2A 00 D1 C8 E1 01 21 0A 91 A3 88 00 2B 00 D0 90 E0 03 9A 00 2A 02 D0 08 9B 01 33 08 93 20 1C FE F7 00 FF B6 20 40 00 68 44 00 23 01 1C E2 5A CA 52 02 33 18 2B FA D1 89 46 00 22 0A 83 48 46 FE F7 F0 FE 48 46 FE F7 ED FE A1 1C BB 46 00 20 68 AB 61 AA B4 46 0F 1C 1E 88 11 88 71 18 09 18 08 0C 19 80 02 3B 28 40 02 3A BB 42 F4 D1 C3 22 52 00 39 1C 66 46 5F 46 6A 44 4B 46 00 20 18 80 02 33 93 42 FA D1 4A 46 D7 82 B4 46 00 20 68 AB 61 AA 0E 1C 19 88 17 88 C9 19 09 18 08 0C 19 80 02 3B 28 40 02 3A B3 42 F4 D1 66 46 4B E0 B1 46 20 1C D0 21 FF F7 8E FB 09 99 41 91 18 23 6A 46 9A 5A 66 88 73 4B 22 80 32 1C 1A 40 9A 42 00 D1 04 E1 00 23 69 AD 2B 80 06 9B 00 2B 01 D0 6E 4B 2B 80 6E 4B 9E 42 33 D9 2A 88 6D 4B 13 43 D3 22 52 00 2B 80 6A 44 00 23 13 80 6A AA 13 80 53 80 0B 98 00 28 02 D0 04 98 ?? ?? ?? ?? 07 99 00 29 07 D0 04 98 52 46 13 1A 05 99 4B 44 07 9A CB 18 13 60 69 98 6A 99 6B B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 0C 9B 03 98 3B 43 0C 93 00 28 02 D1 08 99 01 39 08 91 02 9A 01 32 02 92 01 36 1A E7 00 2E 00 D1 D2 E0 20 1C 05 21 FF F7 55 F8 36 05 36 0C A3 88 0F 22 13 40 2A 88 33 43 13 43 2B 80 D3 23 E2 88 5B 00 6B 44 1A 80 22 89 6A AB 1A 80 62 89 5A 80 BC E7 0D 99 00 29 00 D0 8F E7 01 22 0D 92 01 36 F7 E6 B1 46 00 23 08 9A 9A 1A 93 46 00 2A 3B DD A3 88 00 2B 38 D1 B7 26 76 00 5B AD 6E 44 01 27 00 23 E2 5A EA 52 02 33 18 2B FA D1 00 23 2B 83 28 1C FE F7 2D FE 28 1C FE F7 2A FE 00 21 61 AB 68 AA AC 46 1D 88 10 88 28 18 40 18 01 0C 18 80 02 3B 39 40 02 3A B3 42 F4 D1 65 46 60 46 FE F7 17 FE AB 88 00 2B 0F D1 01 20 40 42 83 44 EA 5A E2 52 02 33 18 2B FA D1 00 21 5A 46 21 83 00 2A 02 D0 A3 88 00 2B CB D0 20 1C FF F7 81 F8 90 28 71 DD 23 1C 00 22 1A 80 02 33 43 45 FB D1 41 E7 B1 46 01 20 81 44 49 46 0A 78 2D 2A 00 D1 A2 E0 01 25 2B 2A 00 D1 AE E0 00 23 15 48 49 46 00 E0 0A 78 16 1C 30 3E 36 06 36 0E 09 2E 00 D9 A7 E0 9E 00 F3 18 5B 00 9B 18 30 3B 01 31 83 42 EF DD 89 46 01 35 00 D1 A3 E0 23 1C 00 22 1A 80 02 33 43 45 FB D1 02 4B 63 80 14 E7 C0 46 ?? ?? ?? ?? FF 7F 00 00 00 80 FF FF FE 07 00 00 F0 7F 00 00 71 13 00 00 03 9B 00 2B 00 D0 FE E6 01 20 03 90 01 36 66 E6 0D 99 00 29 00 D0 D7 E0 7B 4A 01 23 06 92 0D 93 01 36 5C E6 20 1C 01 21 ?? ?? ?? ?? 01 22 04 90 0B 92 06 E6 C7 23 5B 00 6B 44 03 E0 02 33 43 45 00 D1 F2 E6 1A 88 00 2A F8 D0 69 A8 35 21 FF F7 6D FA 01 E7 20 1C 04 21 FE F7 82 FF 2D E7 B1 46 B8 E7 6A 4B 40 22 1B 1A 40 A8 00 92 01 90 0C 99 00 22 20 1C FF F7 70 F8 61 88 5A 46 03 91 00 2A 58 D0 5B 46 00 2B 00 DA 80 E0 A8 21 49 00 01 20 69 44 08 90 5E 4E 02 91 5E 49 00 23 5B AD 2C 31 CA 5A EA 52 02 33 14 2B FA D1 8C 20 40 00 30 18 49 46 80 26 A9 46 01 27 5D 46 76 01 D3 46 0C 91 82 46 05 E0 7F 00 B7 42 47 DC 14 20 40 42 82 44 2F 42 F7 D0 50 46 49 46 4A 46 40 AB FF F7 B8 FA F0 E7 01 22 91 44 4B 46 01 25 1A 78 6D 42 56 E7 01 20 0A 90 03 90 01 36 F1 E5 00 21 03 1C 8A 46 AC E5 01 20 81 44 49 46 0A 78 4B E7 89 46 01 35 0B D1 41 4A 5B 42 93 42 00 DB EA E6 23 1C 00 22 1A 80 02 33 43 45 FB D1 72 E6 3C 4A 93 42 00 DD 50 E7 DE E6 00 21 03 98 39 4A 35 23 41 93 83 18 40 A8 40 22 00 92 01 90 00 22 20 1C FF F7 04 F8 5E E6 04 99 96 E5 33 1C E3 E5 0C 99 4D 46 28 1C 89 46 02 99 FE F7 A0 FC 08 9A DA 46 01 32 1D D0 02 9B 21 1C 18 1C 40 AA 5D 88 FE F7 33 FE 01 1C 28 48 03 9A 2B 18 D2 18 03 92 D4 E7 5A 46 52 42 80 23 93 46 5B 01 9B 45 1A DC A8 20 01 23 40 00 5B 42 68 44 08 93 1A 4E 02 90 75 E7 02 9B 21 1C 18 1C 40 AA 5D 88 FE F7 3B FD 01 1C 03 98 1A 4A 43 1B 9A 18 03 92 B6 E7 0F 48 B1 46 06 90 1B E6 0F 4E A8 21 30 1C 49 00 69 44 28 30 02 91 FE F7 63 FC 02 9A 21 1C 55 88 10 1C 40 AA FE F7 20 FD 03 98 0D 49 43 18 5D 1B 0C 4A 01 23 5B 42 03 95 93 44 08 93 48 E7 C0 46 FF FF 00 00 8E 40 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 8F EC FF FF 44 13 00 00 00 C4 FF FF 02 C0 FF FF FF 3F 00 00 00 F0 FF FF }
	condition:
		$1
}

rule file_39_19_0 {
	meta:
		name = "_ldtoa_r"
		size = 3280
		refs = "003c _Bfree 02e6 sprintf 03f8 _Balloc 0404 strcpy"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 F1 B0 08 90 6F 91 70 92 08 9A 09 93 01 23 5B 42 11 6C 0F A8 0F 93 90 23 7C 9C 80 46 43 60 00 29 0B D0 53 6C 4B 60 53 6C 01 22 9A 40 8A 60 08 98 ?? ?? ?? ?? 08 9E 00 23 33 64 6F A8 63 A9 42 46 FF F7 EA FA CF 20 40 00 68 44 01 88 C5 4B 0A 1C 1A 40 9A 42 00 D1 D4 E2 09 04 00 29 00 DA DF E2 00 23 23 60 09 99 03 29 00 D1 AD E2 09 9B 00 2B 00 D0 D8 E2 14 26 0A 96 43 46 5B 68 CF 26 0B 93 76 00 6E 44 32 88 B7 4B 1A 40 9A 42 00 D1 A4 E2 90 23 40 46 43 60 5C AC 00 23 63 A9 CA 5A E2 52 02 33 14 2B F9 D1 63 8A 1A 04 00 2A 00 DA BE E2 00 22 06 92 AA 26 76 00 AB 49 6E 44 00 23 B2 46 2C 31 CA 5A 50 46 C2 52 02 33 14 2B F9 D1 63 8A 00 2B 00 D0 A1 E1 C1 21 49 00 23 1C 69 44 1A 88 00 2A 00 D0 A2 E1 02 33 8B 42 F8 D1 00 21 05 91 47 AE 50 46 31 1C FE F7 B9 FB 00 23 F2 5A 50 46 C2 52 02 33 18 2B F9 D1 00 23 51 46 0B 83 20 1C 31 1C FE F7 AB FB 00 23 F2 5A E2 52 02 33 18 2B FA D1 00 23 23 83 42 46 50 46 21 1C FF F7 6E F8 4C 23 42 46 D3 5A 07 93 00 2B 00 D0 09 E2 00 26 8A 4B B3 46 B9 26 76 00 99 46 4E AD 6E 44 01 27 20 1C 49 46 FE F7 8A FD 00 28 00 D1 F9 E1 20 1C FE F7 EE FB 00 23 E2 5A EA 52 02 33 18 2B FA D1 58 46 28 83 28 1C FE F7 E3 FB 28 1C FE F7 E0 FB 00 21 62 AB 54 AA 18 88 84 46 10 88 60 44 40 18 01 0C 18 80 02 3B 39 40 02 3A B3 42 F3 D1 50 46 21 1C 42 46 FF F7 32 F8 05 98 41 46 4C 22 8B 5A 01 38 05 90 00 2B CB D0 06 99 00 29 00 D1 CD E1 6A 46 8C 32 06 92 06 9E 09 99 2D 22 32 70 03 29 00 D1 CC E1 0A 9A 07 92 0A 2B 00 D1 D3 E1 06 99 30 33 07 9A 4B 70 2E 23 8B 70 00 2A 00 DA 54 E2 8F 26 6E 44 B1 46 B9 26 00 20 76 00 83 46 4E AD 6E 44 01 27 20 1C FE F7 9B FB 00 23 E2 5A EA 52 02 33 18 2B FA D1 00 20 28 83 28 1C FE F7 90 FB 28 1C FE F7 8D FB 00 21 62 AB 54 AA AC 46 1D 88 10 88 28 18 40 18 01 0C 18 80 02 3B 39 40 02 3A B3 42 F4 D1 50 46 21 1C 42 46 65 46 FE F7 DE FF 41 46 4C 22 8B 5C 48 46 30 33 03 70 01 21 07 9A 8B 44 89 44 5A 45 CD DA 4C 23 46 46 F3 5A 4D 46 01 3D 04 2B 2E DD 05 2B 00 D1 F9 E2 07 98 6B 1E 1A 78 00 28 00 DA F1 E1 7F 21 0A 40 2E 2A 16 D0 01 32 1A 70 39 2A 1D DD 30 22 1A 70 01 3B 19 78 7F 22 0A 40 30 20 7F 21 07 E0 01 32 1A 70 39 2A 10 DD 18 70 01 3B 1A 78 0A 40 2E 2A F5 D1 01 3B 1A 78 01 32 1A 70 39 2A 04 DD 05 99 31 22 01 31 05 91 1A 70 28 1C 26 49 05 9A ?? ?? ?? ?? 0B 9A 05 9E 43 46 5A 60 1E 61 63 A8 FE F7 AB FA 00 28 00 D0 2A E1 CF 20 40 00 68 44 02 88 19 4B 1A 40 9A 42 00 D1 17 E1 41 46 0B 69 7B 9A 01 33 13 60 06 9E 33 78 00 2B 00 D1 21 E3 2E 2B 00 D1 F0 E0 06 9B 02 E0 2E 2A 00 D1 EC E0 01 33 1A 78 00 2A F8 D1 06 98 83 42 07 D9 06 99 01 E0 8B 42 03 D9 01 3B 1A 78 45 2A F9 D1 00 22 1A 70 06 99 0B 78 20 2B 00 D1 E6 E0 2D 2B 00 D1 E3 E0 0A 1C 06 9C 0B E0 C0 46 FF 7F 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 32 13 78 0C 1C 23 70 61 1C 00 2B F8 D1 09 9A 02 2A 00 D1 1C E1 46 46 33 69 0A 9D 9D 42 00 DA 1D 1C 63 1E 1A 78 30 2A 0F D1 06 98 22 1A 95 42 0B DA 00 24 03 E0 01 3A 95 42 05 DA 0B 1C 1C 70 59 1E 08 78 30 28 F6 D0 1C 1C 09 99 03 29 00 D1 F3 E0 7A 98 09 30 08 9A 00 23 53 64 17 28 00 D8 48 E1 00 21 04 23 5B 00 1A 1C 14 32 01 31 82 42 F9 D9 08 9B 59 64 08 98 ?? ?? ?? ?? 08 9E 06 99 30 64 05 1C ?? ?? ?? ?? 7D 98 00 28 03 D0 06 99 64 1A 2C 19 04 60 71 B0 28 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD A7 4A 93 42 00 D1 15 E1 10 21 63 5E 00 2B 00 DB 06 E1 A3 48 21 1C 2C 30 FE F7 1B FC 00 28 00 D1 57 E6 00 28 00 DA 52 E1 63 8A 00 2B 00 D0 2D E2 10 21 63 5E 00 2B 00 DA C4 E2 00 23 05 93 00 25 43 46 98 48 21 1C 22 1C FE F7 D7 FF 10 26 A3 5F 01 3D 00 2B F4 DA 05 95 47 AE 00 23 E2 5A F2 52 02 33 14 2B FA D1 8E 49 00 23 2C 31 CA 5A 50 46 C2 52 02 33 14 2B F9 D1 8A 4A 8B 49 93 46 88 4D 98 22 89 46 52 00 28 21 40 35 89 44 93 44 87 4F 1C E0 28 1C 31 1C FE F7 DC FB 00 28 0E DB 48 46 31 1C 32 1C 43 46 FE F7 A8 FF 43 46 48 46 51 46 52 46 FE F7 A2 FF 05 9B DB 19 05 93 FB 0F DF 19 7F 10 5D 45 08 D0 14 20 14 35 81 44 79 48 31 1C FE F7 BF FB 00 28 DC DC 72 49 50 46 2C 31 52 46 43 46 FF F7 54 F9 F7 E5 06 9B 01 33 19 78 5A 1E 11 70 1A 78 00 2A 00 D1 0E E7 01 33 19 78 5A 1E 11 70 1A 78 00 2A F0 D1 06 E7 06 9A 01 32 13 78 2D 2B FB D0 20 2B 00 D0 14 E7 F7 E7 01 1C 63 AB 02 E0 8B 42 00 D1 E1 E6 1A 88 02 33 00 2A F8 D0 61 4B 7B 98 03 60 FC E6 06 99 07 9B 00 29 00 D0 31 E6 68 46 09 99 8C 30 20 22 06 90 02 70 03 29 00 D0 32 E6 05 9E 0A 98 36 18 07 96 2A 2E 00 DC 2D E6 2A 21 07 91 0A 2B 00 D0 2B E6 06 9A 31 23 53 70 2E 23 93 70 07 9B 00 2B 00 DC 84 E0 07 9E 05 98 30 23 01 3E 01 30 24 A9 D3 70 07 96 05 90 89 46 23 E6 42 46 13 69 0A 9E DE 42 5F D4 7B 9E 33 68 7A 98 03 30 C0 18 02 E7 01 25 E6 E6 7A 9A 0A 92 0A 99 2A 29 00 DC 51 E5 2A 22 0A 92 4E E5 31 1C 63 AB 02 E0 8B 42 00 D1 54 E5 1A 88 02 33 00 2A F8 D0 6A 46 8C 32 10 1C 37 49 06 92 ?? ?? ?? ?? 34 4B 05 93 6D E6 CF 20 40 00 68 44 63 AB 1A 88 02 33 00 2A 00 D0 25 E5 83 42 F8 D1 09 04 00 29 00 DB 1F E5 01 23 23 60 1E E5 7A 98 01 38 0A 90 CE E7 22 4A 13 40 63 82 28 4B 06 93 3C E5 6A 46 8C 32 10 1C 26 49 06 92 ?? ?? ?? ?? 21 4B 05 93 47 E6 06 99 00 29 18 D0 6A 46 8C 32 10 1C 21 49 06 92 ?? ?? ?? ?? 1B 4B 05 93 3A E6 00 21 BE E6 31 22 1A 70 05 98 01 30 05 90 2D E6 06 98 00 23 03 70 7B 99 04 1C 0B 60 9A E7 6E 46 8C 36 30 1C 15 49 06 96 ?? ?? ?? ?? 0E 48 05 90 21 E6 8F 23 6B 44 99 46 E2 E5 05 9A 07 9B 01 32 05 92 00 2B 00 D1 9F E5 6D 46 8F 35 0E E6 C0 46 FF 7F 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 F0 FF FF ?? ?? ?? ?? 0F 27 00 00 ?? ?? ?? ?? FF FF 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 23 4E AD E2 5A EA 52 02 33 14 2B FA D1 BF 4B BF 4E 00 21 10 20 C8 36 39 AA 6B 82 0D 90 05 91 07 96 6A AF 47 AE 89 46 93 46 43 46 07 98 29 1C 52 46 FF F7 45 F8 00 23 50 46 C2 5A FA 52 02 33 14 2B F9 D1 79 8A B3 4B B3 4A 0B 40 9B 18 00 2B 52 DD 90 20 C0 1A 00 23 FA 5A F2 52 02 33 14 2B FA D1 00 28 1E DD 0F 28 00 DC 4C E1 10 38 02 09 53 00 94 46 8F 22 52 00 6A 44 0C 91 D2 18 33 1C 49 46 19 80 02 33 93 42 FA D1 62 46 12 01 0C 99 80 1A A2 4A 40 00 80 5A 1A 88 02 40 1A 80 09 04 00 29 13 DB 00 23 02 E0 02 33 12 2B 18 D0 50 46 C1 5A F2 5A 91 42 F7 D0 0D 98 07 99 98 4A 40 08 0D 90 91 42 20 D0 14 31 07 91 AE E7 00 23 F9 5A F2 5A 91 42 00 D0 D0 E0 02 33 12 2B F7 D1 E1 E7 00 23 51 46 CA 5A EA 52 02 33 14 2B F9 D1 05 9A 0D 9B D2 18 05 92 DF E7 4C AA 33 1C 48 46 18 80 02 33 93 42 FA D1 CA E7 6A 8A 63 8A 85 48 D3 18 1B 18 6B 82 00 23 EA 5A E2 52 02 33 14 2B FA D1 81 49 00 23 2C 31 CA 5A 50 46 C2 52 02 33 14 2B F9 D1 77 4F 80 21 33 1C 4A 01 28 37 16 1C 99 46 04 E0 77 48 76 08 87 42 1C D0 14 37 74 48 29 1C FE F7 18 FA 00 28 15 DC 38 1C 29 1C FE F7 12 FA 00 28 EE DC 38 1C 29 1C 2A 1C 43 46 FE F7 A8 FF 43 46 38 1C 51 46 52 46 FE F7 D8 FD 05 9B 9B 19 05 93 DE E7 4E 46 40 E4 20 1C 51 46 42 46 FE F7 85 FD 50 46 65 49 FE F7 F5 F9 00 28 00 D0 F9 E4 07 99 00 29 00 DA 21 E5 4B 46 02 3B 1A 78 2E 2A 00 D1 A4 E0 11 1C CE 07 00 D4 17 E5 F0 E4 47 AE 20 1C 31 1C FD F7 DE FF 9D 21 00 20 49 00 69 44 01 22 05 90 4E AD 89 46 93 46 00 27 33 8B 07 20 03 42 41 D1 00 23 F2 5A EA 52 02 33 18 2B FA D1 00 21 29 83 28 1C FE F7 0F F8 28 1C FE F7 0C F8 00 21 54 AB 4D AA B4 46 1E 88 10 88 30 18 40 18 01 0C 5E 46 18 80 02 3B 31 40 02 3A 4B 45 F3 D1 6B 88 03 33 6B 80 AB 88 66 46 00 2B 08 D0 28 1C FD F7 F2 FF 6B 88 01 33 6B 80 AB 88 00 2B F6 D1 2B 8B 00 2B 10 D1 38 48 6B 88 C2 8F 9A 42 0B D9 00 23 EA 5A F2 52 02 33 18 2B FA D1 01 3F 00 21 3A 1C 31 83 2B 32 B9 D1 30 1C 21 1C 42 46 05 97 FE F7 14 FD 8A E5 33 1C F2 E4 2B 48 25 49 C3 8F 0B 40 8B 42 00 D1 8A E0 73 8A 22 4A 13 40 93 42 72 D0 27 48 FD F7 62 FF 00 28 15 D0 30 1C FD F7 5D FF 00 28 10 D0 20 49 1A 4B CA 8F 19 48 13 40 83 42 53 D0 D2 0B 71 8A 16 4B 16 48 0B 40 83 42 3F D0 C9 0B 8A 42 37 D0 19 48 FD F7 47 FF 00 28 00 D1 77 E0 00 23 16 49 CA 5A F2 52 02 33 14 2B F9 D1 72 8A 0B 4B 0B 48 13 40 83 42 75 D0 11 4B 53 40 73 82 D6 E6 00 22 05 92 47 AE 46 E5 49 46 03 39 09 78 57 E7 33 1C C3 E6 C0 46 8E 40 00 00 ?? ?? ?? ?? FF 7F 00 00 02 C0 FF FF ?? ?? ?? ?? ?? ?? ?? ?? 72 BF FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 80 FF FF 30 1C 90 21 FE F7 64 FC B0 E6 97 20 40 00 68 44 33 1C 94 46 1A 88 02 33 00 2A 0C D1 83 42 F9 D1 62 46 B2 E7 9E 4B 3E 31 18 88 02 33 00 28 05 D1 8B 42 F9 D1 A2 E7 62 46 00 21 A7 E7 00 22 9E E7 97 22 52 00 6A 44 33 1C 02 E0 93 42 00 D1 84 E7 19 88 02 33 00 29 F8 D0 32 1C 14 32 33 1C 02 33 93 42 FC D1 82 E6 02 1C 3E 32 8D 4B 02 E0 93 42 00 D1 6D E7 19 88 02 33 00 29 F8 D0 00 23 88 48 C2 5A F2 52 02 33 14 2B F9 D1 6F E6 30 1C FD F7 C9 FE 00 28 11 D0 4C AA 33 1C 02 33 93 42 FC D1 64 E6 97 21 49 00 69 44 33 1C 18 88 02 33 00 28 00 D0 5B E6 8B 42 F8 D1 7D E7 79 48 40 A9 FD F7 C5 FE 30 1C 59 46 FD F7 C1 FE 40 A9 0B 88 DB 43 1B 04 1B 0C 0B 80 58 46 42 88 81 20 0C 92 40 00 68 44 01 88 89 1A 00 29 24 DD 00 22 32 AB 58 46 80 5A 98 52 02 32 18 2A F9 D1 4A 46 0C 93 1A 83 00 22 40 AB 9B 5A 58 46 83 52 02 32 18 2A F8 D1 4A 46 02 83 00 22 0C 9B 9B 5A 40 A8 83 52 02 32 18 2A F8 D1 4A 46 46 A8 02 80 5B 46 5B 88 49 42 0C 93 01 E0 00 29 38 D0 08 1C 91 30 05 DA 58 46 31 1C 42 46 FE F7 0E FC 10 E6 40 A8 FE F7 DA F8 40 AA 13 88 01 1C 58 46 02 88 9A 42 65 D0 6A 46 E6 32 00 23 03 92 0E 93 46 AA 3F AB 8C 46 10 88 19 88 09 1A 0E 98 09 1A 02 91 01 20 09 0C 08 40 0E 90 69 46 08 20 41 5A 03 98 19 80 02 3B 02 3A 83 42 EC D1 61 46 01 22 40 23 00 93 43 46 01 93 58 46 0C 9B FE F7 AA F9 C9 E7 02 92 00 21 40 A8 40 18 82 88 58 46 40 18 0E 90 80 88 94 46 84 45 0F D1 02 31 16 29 F2 D1 58 46 01 88 02 9A 99 42 49 D0 4C AA 33 1C 49 46 19 80 02 33 93 42 FA D1 C4 E5 84 45 1F D9 00 22 32 AB 58 46 81 5A 99 52 02 32 18 2A F9 D1 49 46 19 83 00 22 40 A8 81 5A 58 46 81 52 02 32 18 2A F8 D1 4A 46 59 46 0A 83 00 22 99 5A 40 A8 81 52 02 32 18 2A F9 D1 4A 46 46 A9 0A 80 03 88 00 21 95 E7 6A 46 E6 32 00 23 04 92 0E 93 46 AA 3F AB 8C 46 10 88 19 88 09 18 0E 98 09 18 02 91 01 20 09 0C 08 40 0E 90 69 46 08 20 41 5A 04 98 19 80 02 3B 02 3A 83 42 EC D1 61 46 00 22 98 E7 00 2A 07 D1 58 46 06 21 43 5E 00 2B 02 DB FD F7 54 FE 61 E7 3A AB 3F A9 00 2A 04 D1 8B 42 05 D0 1A 88 02 33 F8 E7 0C 9A 01 32 0C 92 6B 46 30 20 C0 5A 5B 46 58 80 4F E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "__sprint_r"
		size = 28
		refs = "0010 __sfvwrite_r"
	strings:
		$1 = { 10 B5 93 68 14 1C 00 2B 02 D1 53 60 00 20 10 BD ?? ?? ?? ?? 00 23 A3 60 63 60 F8 E7 }
	condition:
		$1
}

rule file_40_1_0 {
	meta:
		name = "_vfiprintf_r"
		size = 2628
		refs = "0376 memchr 0852 _vfiprintf_r 0860 _fflush_r 0880 __sinit 08bc __umodsi3 08ca __udivsi3 09a6 strlen 09fa __swsetup_r"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 C9 4C A5 44 02 90 8B 46 17 1C 99 46 00 28 04 D0 83 6B 00 2B 01 D1 00 F0 2D FC 58 46 81 89 80 22 92 01 0B 1C 11 42 08 D1 11 43 5A 46 91 81 BF 4B 52 6E 5E 46 13 40 73 66 0B 1C 18 07 01 D4 00 F0 D4 FC 5E 46 32 69 00 2A 01 D1 00 F0 CE FC 1A 22 13 40 0A 2B 00 D1 D4 E3 A0 24 93 20 E4 00 C0 00 00 23 6C 44 68 44 20 60 A3 60 63 60 0B 93 05 93 05 1C 3B 78 00 2B 1F D0 25 2B 1D D0 3E 1C 01 36 33 78 25 2B 01 D0 00 2B F9 D1 F1 1B 88 46 00 29 10 D0 A3 68 43 44 A3 60 63 68 01 33 2F 60 69 60 63 60 07 2B 00 DD 6F E3 08 35 05 9B 9C 46 C4 44 63 46 05 93 33 78 37 1C 00 2B 00 D1 E2 E2 9C 48 00 21 68 44 4A 46 01 70 82 46 03 92 01 20 00 22 41 42 80 23 06 92 00 92 88 46 01 37 10 21 40 20 9C 46 3B 78 01 37 1A 1C 20 3A 58 2A 60 D9 00 2B 00 D1 C7 E2 9B 22 D2 00 6A 44 01 26 13 70 51 46 00 23 0B 70 01 96 04 96 08 92 00 22 07 92 00 99 02 23 19 40 0A 91 02 D0 01 9A 02 32 01 92 00 9E 84 23 1E 40 09 96 00 D0 C8 E1 06 98 01 99 46 1A 00 2E 00 DC C2 E1 10 2E 01 DC 00 F0 43 FC 7D 48 10 21 2A 1C B9 46 A3 68 88 46 5D 46 07 1C 03 E0 10 3E 08 32 10 2E 19 DD 61 68 40 46 10 33 01 31 17 60 50 60 A3 60 61 60 07 29 F1 DD 02 98 29 1C 22 1C FF F7 31 FF 00 28 01 D0 00 F0 EF FB 93 22 D2 00 10 3E A3 68 6A 44 10 2E E5 DC AB 46 15 1C 3A 1C 4F 46 91 46 62 68 49 46 9B 19 01 32 29 60 6E 60 A3 60 62 60 07 2A 00 DD 9A E3 08 35 86 E1 61 4E 92 00 B2 58 97 46 00 9E 10 23 1E 43 00 96 00 98 C0 06 03 D4 00 9B 5B 06 00 D5 A3 E3 03 99 04 31 03 9A 01 91 16 68 32 1C 53 1E 9A 41 01 23 00 21 50 46 01 70 2A E0 00 98 10 23 18 43 00 90 00 99 C9 06 51 D4 00 9E 76 06 4E D5 03 99 03 98 0E 88 04 30 32 1C 53 1E 9A 41 01 90 00 23 E7 E7 00 98 10 23 18 43 00 90 00 99 C9 06 03 D4 00 9E 76 06 00 D5 81 E3 03 9A 04 32 01 92 03 9B 1E 68 00 2E 00 DA 83 E3 32 1C 53 1E 9A 41 01 23 40 46 00 28 03 DB 00 98 80 21 88 43 00 90 41 46 00 29 02 D1 00 2A 00 D1 F6 E1 01 2B 00 D1 1E E3 02 2B 00 D1 0B E3 08 94 07 22 21 1C 33 1C 13 40 01 39 30 33 F6 08 0B 70 00 2E F7 D1 00 9A 08 91 D2 07 00 D4 3B E3 30 2B 00 D1 A1 E3 08 98 01 38 30 23 21 1A 08 90 03 70 04 91 E1 E1 03 9A 04 32 03 9B 01 92 1E 68 32 1C 53 1E 9A 41 00 23 98 E7 00 9E 0E 43 00 96 03 9B 03 93 13 E7 00 99 02 23 03 9E 19 43 03 98 1D 4B 04 36 6B 44 30 22 01 96 06 68 1A 70 78 22 5A 70 32 1C 53 1E 9A 41 18 4B 00 91 0B 93 02 23 7C E7 16 4E 00 98 0B 96 C0 06 00 D4 7E E0 03 99 03 9A 04 31 01 91 16 68 32 1C 51 1E 8A 41 00 2A 0D D0 00 99 C9 07 0A D5 0B 4A 30 21 6A 44 53 70 11 70 00 9A 02 23 1A 43 00 92 01 22 5E E7 02 23 5C E7 C0 46 F0 FA FF FF FF DF FF FF 0F 05 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 0C 05 00 00 ?? ?? ?? ?? 00 20 56 46 03 9B 30 70 19 1C 1B 68 04 31 03 91 08 93 00 2B 00 D1 24 E3 46 46 00 2E 00 DA 19 E3 08 98 00 21 42 46 ?? ?? ?? ?? 00 28 04 D0 08 99 40 1A 04 90 40 45 01 DD 41 46 04 91 00 20 07 90 6F E1 00 99 C9 06 00 D5 B9 E2 00 99 49 06 00 D4 F6 E2 03 9E 03 9A 68 46 14 21 33 68 08 5A 91 46 04 22 91 44 18 80 62 E6 03 98 9B 23 02 68 DB 00 6B 44 01 26 1A 70 51 46 00 22 04 30 0A 70 03 90 01 96 04 96 08 93 9E E6 00 9B 0B 43 00 93 03 9B 03 93 84 E6 00 9A 03 9B 02 43 00 92 03 93 7E E6 C0 48 0B 90 00 98 C0 06 00 D5 80 E7 00 9E 76 06 00 D4 A7 E2 03 98 03 99 04 30 01 90 0E 88 7B E7 1A 1C 00 26 30 3A B3 00 9E 19 3B 78 76 00 96 19 1A 1C 30 3A 01 37 09 2A F5 D9 06 96 61 E6 00 9B 66 46 33 43 00 93 03 9B 03 93 58 E6 3B 78 01 37 2A 2B 00 D1 EC E2 1A 1C 30 3A 09 2A 00 D9 BB E2 00 26 B3 00 9E 19 3B 78 76 00 B6 18 1A 1C 30 3A 01 37 09 2A F5 D9 00 2E B0 46 00 DB 41 E6 01 26 72 42 90 46 3D E6 03 9B 00 9E 04 22 16 43 00 96 03 93 34 E6 2B 23 52 46 13 70 03 9B 03 93 2E E6 03 9A 03 9B 12 68 04 33 06 92 00 2A 00 DB 10 E7 52 42 06 92 E8 E7 00 9E 01 23 1E 43 03 9B 00 96 03 93 1C E6 52 46 13 78 00 2B 00 D0 50 E2 20 23 13 70 03 9B 03 93 12 E6 A3 68 56 46 32 78 00 2A 0B D0 01 22 6A 60 62 68 01 33 01 32 2E 60 A3 60 62 60 07 2A 00 DD 85 E1 08 35 0A 98 00 28 0D D0 81 4A 6A 44 2A 60 02 22 6A 60 62 68 02 33 01 32 A3 60 62 60 07 2A 00 DD 67 E1 08 35 09 99 80 29 00 D1 DA E0 07 99 04 9A 8E 1A 00 2E 3E DD 10 2E 00 DC 32 E2 75 49 10 22 89 46 90 46 59 46 92 46 BB 46 2A 1C C8 44 02 9D 0F 1C 04 E0 10 3E 08 32 10 2E 1A DD A3 68 51 46 51 60 61 68 40 46 10 33 01 31 10 60 A3 60 61 60 07 29 EF DD 28 1C 39 1C 22 1C FF F7 3F FD 00 28 00 D0 11 E1 93 22 D2 00 10 3E A3 68 6A 44 10 2E E4 DC 15 1C 3A 1C 5F 46 93 46 4A 46 10 32 2A 60 62 68 9B 19 01 32 6E 60 A3 60 62 60 07 2A 00 DD 12 E1 08 35 08 9A 04 9E 2A 60 62 68 9B 19 01 32 6E 60 A3 60 62 60 07 2A 00 DD D7 E0 2A 1C 08 32 00 98 40 07 36 D5 06 99 01 98 0E 1A 00 2E 00 DC F8 E0 10 2E 00 DC 0F E2 4A 48 B8 46 10 25 07 1C 04 E0 10 3E 08 32 10 2E 17 DD A3 68 61 68 10 33 01 31 17 60 55 60 A3 60 61 60 07 29 F1 DD 02 98 59 46 22 1C FF F7 F2 FC 00 28 4D D1 93 22 D2 00 10 3E A3 68 6A 44 10 2E E7 DC B9 46 47 46 49 46 11 60 56 60 62 68 9B 19 01 32 A3 60 62 60 07 2A 00 DD BF E0 01 9A 06 9E B2 42 00 DA 32 1C 05 98 80 18 05 90 00 2B 00 D0 9D E0 03 9A 93 25 00 21 ED 00 61 60 91 46 6D 44 15 E5 00 2B 35 D1 00 98 C0 07 32 D5 28 49 30 23 69 44 01 22 08 91 0B 70 04 92 01 98 46 46 07 96 03 90 04 99 07 9A 01 91 91 42 00 DA 01 92 56 46 33 78 00 2B 00 D1 48 E5 01 98 01 30 01 90 44 E5 A3 68 00 2B 04 D0 02 98 59 46 22 1C FF F7 A2 FC 5E 46 B3 89 58 06 02 D5 01 21 49 42 05 91 A2 23 DB 00 05 98 9D 44 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 23 08 94 04 93 CF E7 06 9A 01 98 16 1A 00 2E 00 DC 4A E1 10 2E 00 DC 9A E1 07 4A 10 20 91 46 59 46 80 46 2A 1C BB 46 C8 44 82 46 02 9D 0F 1C 0C E0 ?? ?? ?? ?? 0C 05 00 00 ?? ?? ?? ?? FF 04 00 00 10 3E 08 32 10 2E 19 DD A3 68 41 46 11 60 61 68 50 46 10 33 01 31 50 60 A3 60 61 60 07 29 EF DD 28 1C 39 1C 22 1C FF F7 5B FC 00 28 2E D1 93 22 D2 00 10 3E A3 68 6A 44 10 2E E5 DC 15 1C 3A 1C 5F 46 93 46 4A 46 10 32 2A 60 62 68 9B 19 01 32 6E 60 A3 60 62 60 07 2A 00 DD 07 E1 08 35 D7 E6 02 98 59 46 22 1C FF F7 3B FC 00 28 00 D0 95 E7 93 22 D2 00 A3 68 6A 44 1C E7 02 98 59 46 22 1C FF F7 2E FC 00 28 00 D1 59 E7 87 E7 BB 46 85 E7 02 98 59 46 22 1C FF F7 23 FC 00 28 00 D0 7D E7 93 25 ED 00 6D 44 84 E4 02 98 59 46 22 1C FF F7 17 FC 00 28 00 D0 71 E7 A3 68 35 E7 02 98 59 46 22 1C FF F7 0D FC 00 28 00 D0 67 E7 93 25 ED 00 A3 68 6D 44 E0 E6 02 98 59 46 22 1C FF F7 00 FC 00 28 00 D0 5A E7 93 25 ED 00 A3 68 6D 44 8B E6 02 98 59 46 22 1C FF F7 F3 FB 00 28 00 D0 4D E7 93 25 ED 00 A3 68 6D 44 6D E6 5A 46 0E 26 93 5F 00 2B 00 DA 24 E4 86 24 02 23 E4 00 6C 44 99 43 A1 81 D3 89 E3 81 D3 69 E3 61 53 6A 63 62 86 24 E4 00 6C 44 0C AB 23 60 23 61 80 23 DB 00 A3 60 63 61 00 23 A3 61 02 98 21 1C 3A 1C 4B 46 ?? ?? ?? ?? 05 90 00 28 06 DB 02 98 21 1C ?? ?? ?? ?? 00 28 00 D0 D6 E0 A3 89 59 06 00 D4 1D E7 5B 46 9A 89 40 23 13 43 5E 46 B3 81 16 E7 ?? ?? ?? ?? FF F7 CF FB 08 94 0B 98 0F 22 23 1C 31 1C 11 40 41 5C 01 3B 36 09 19 70 00 2E F7 D1 E6 1A 08 93 04 96 E0 E6 09 2E 00 D8 AF E0 2B 1C C1 46 25 1C B8 46 1F 1C 30 1C 0A 21 ?? ?? ?? ?? 01 3D 30 30 28 70 0A 21 30 1C ?? ?? ?? ?? 06 1C 09 28 F1 D8 3B 1C 47 46 C8 46 A9 46 1D 1C 4A 46 01 3A 30 36 A3 1A 08 92 16 70 04 93 BD E6 02 98 59 46 22 1C FF F7 76 FB 00 28 00 D0 D0 E6 93 25 ED 00 A3 68 6D 44 E0 E5 63 1A 04 93 AD E6 03 9E 03 9A 33 68 05 98 91 46 04 22 91 44 18 60 FF F7 AE FB 03 9E 03 98 04 36 01 96 06 88 32 1C 53 1E 9A 41 01 23 5A E4 03 99 0E 68 03 98 36 04 04 30 36 14 01 90 00 2E 00 DB 7B E4 2D 23 50 46 76 42 03 70 76 E4 03 9A 03 98 04 32 01 92 06 68 D3 E4 03 9B 03 93 FF F7 C3 FB AB 46 99 E6 A3 68 D1 E5 02 98 59 46 22 1C FF F7 35 FB 00 28 00 D0 8F E6 93 25 ED 00 A3 68 6D 44 C4 E5 2C 48 81 46 F8 E5 03 9A 03 99 13 68 05 9E 89 46 04 21 89 44 1E 60 FF F7 6D FB 08 98 ?? ?? ?? ?? 00 22 04 90 07 92 5F E6 42 46 04 92 06 2A 13 D9 06 20 04 90 01 90 1F 4B 08 93 FF F7 A7 FB 00 26 B0 46 FF F7 91 FB 1A 4A A3 68 91 46 FF F7 E4 FB 08 9E A6 1B 04 96 43 E6 04 99 01 91 00 29 EA DA 00 22 01 92 E7 E7 12 49 89 46 0F E6 02 98 59 46 ?? ?? ?? ?? 00 28 00 D0 51 E6 58 46 81 89 0B 1C FF F7 26 FB A1 46 65 E7 0A 49 89 46 97 E6 01 20 40 42 05 90 24 E7 03 9A 03 9B 12 68 04 33 90 46 00 2A 00 DB 48 E4 01 26 72 42 90 46 03 93 FF F7 59 FB ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "cnv"
		size = 24
		refs = "0006 strtol"
	strings:
		$1 = { 00 B5 00 21 0A 22 ?? ?? ?? ?? 43 1C 02 D0 00 06 00 0E 00 BD FF 20 FC E7 }
	condition:
		$1
}

rule file_41_1_0 {
	meta:
		name = "__get_current_monetary_locale"
		size = 24
		altNames = "__get_current_messages_locale __get_current_numeric_locale __get_current_time_locale"
	strings:
		$1 = { 03 48 03 68 00 2B 01 D1 02 48 70 47 04 30 FC E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_2_0 {
	meta:
		name = "__monetary_load_locale"
		size = 152
		refs = "001c __part_load_locale 0034 __fix_locale_grouping_str 008c __mlocale_changed"
	strings:
		$1 = { 70 B5 22 4B 22 4C 01 22 1A 60 83 B0 0F 23 00 93 01 93 23 1D 02 93 22 6C 21 1C 1E 4B ?? ?? ?? ?? 05 1C 00 28 02 D1 23 68 00 2B 02 D1 03 B0 28 1C 70 BD 60 69 ?? ?? ?? ?? 26 6A 60 61 30 1C FF F7 D3 FF 30 70 66 6A 30 1C FF F7 CE FF 30 70 A6 6A 30 1C FF F7 C9 FF 30 70 E6 6A 30 1C FF F7 C4 FF 30 70 26 6B 30 1C FF F7 BF FF 30 70 66 6B 30 1C FF F7 BA FF 30 70 A6 6B 30 1C FF F7 B5 FF 30 70 E4 6B 20 1C FF F7 B0 FF 20 70 CF E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "_vasiprintf_r"
		size = 52
		refs = "0020 _svfiprintf_r"
	strings:
		$1 = { 70 B5 9A B0 0E 1C A2 21 6C 46 89 00 A1 81 01 21 49 42 00 25 E1 81 69 46 00 95 04 95 02 95 05 95 ?? ?? ?? ?? 00 28 03 DB 00 9B 1D 70 04 9B 33 60 1A B0 70 BD }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "_vasprintf_r"
		size = 52
		refs = "0020 _svfprintf_r"
	strings:
		$1 = { 70 B5 9A B0 0E 1C A2 21 6C 46 89 00 A1 81 01 21 49 42 00 25 E1 81 69 46 00 95 04 95 02 95 05 95 ?? ?? ?? ?? 00 28 03 DB 00 9B 1D 70 04 9B 33 60 1A B0 70 BD }
	condition:
		$1
}

rule file_43_2_0 {
	meta:
		name = "std"
		size = 72
		refs = "001e memset 0038 __sread 003c __swrite 0040 __sseek 0044 __sclose"
	strings:
		$1 = { 10 B5 00 23 04 1C 03 60 43 60 83 60 81 81 43 66 C2 81 03 61 43 61 83 61 00 21 08 22 5C 30 ?? ?? ?? ?? 05 4B 23 62 05 4B 63 62 05 4B A3 62 05 4B E4 61 E3 62 10 BD C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_7_0 {
	meta:
		name = "__fp_unlock_all"
		size = 24
		refs = "0008 _fwalk 0010 _impure_ptr 0014 __fp_unlock"
	strings:
		$1 = { 00 B5 03 4B 03 49 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_8_0 {
	meta:
		name = "__fp_lock_all"
		size = 24
		refs = "0008 _fwalk 0010 _impure_ptr 0014 __fp_lock"
	strings:
		$1 = { 00 B5 03 4B 03 49 18 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_11_0 {
	meta:
		name = "__sinit"
		size = 88
		refs = "0054 _cleanup_r"
	strings:
		$1 = { 10 B5 83 6B 04 1C 00 2B 22 D1 12 4A C2 63 01 22 82 63 B8 22 92 00 83 50 B9 23 9B 00 03 22 BB 21 C2 50 89 00 BA 23 42 18 9B 00 C2 50 04 21 40 68 00 22 23 1C FF F7 C0 FF A0 68 09 21 01 22 23 1C FF F7 BA FF E0 68 12 21 02 22 23 1C FF F7 B4 FF 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_12_0 {
	meta:
		name = "__sfmoreglue"
		size = 44
		refs = "000c _malloc_r 0024 memset"
	strings:
		$1 = { 70 B5 68 25 4D 43 0E 1C 29 1C 0C 31 ?? ?? ?? ?? 04 1C 00 28 08 D0 0C 30 00 23 23 60 66 60 A0 60 00 21 2A 1C ?? ?? ?? ?? 20 1C 70 BD }
	condition:
		$1
}

rule file_43_13_0 {
	meta:
		name = "__sfp"
		size = 140
		refs = "004e memset 006a __sinit 0074 __sfmoreglue 0088 _global_impure_ptr"
	strings:
		$1 = { 70 B5 21 4B 1D 68 AB 6B 06 1C 00 2B 2C D0 B8 21 89 00 6D 18 6B 68 AC 68 01 3B 03 D5 1F E0 01 3B 1D D4 68 34 0C 21 62 5E 00 2A F8 D1 01 23 5B 42 00 25 E3 81 20 1C 01 23 A3 81 65 66 25 60 A5 60 65 60 25 61 65 61 A5 61 5C 30 00 21 08 22 ?? ?? ?? ?? 25 63 65 63 65 64 A5 64 20 1C 70 BD 28 68 00 28 05 D0 05 1C D5 E7 28 1C ?? ?? ?? ?? CE E7 30 1C 04 21 ?? ?? ?? ?? 28 60 00 28 F2 D1 0C 23 33 60 00 24 E9 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "memmove"
		size = 156
	strings:
		$1 = { F0 B5 06 1C 0D 1C 14 1C 88 42 0D D9 8B 18 98 42 0A D2 00 2A 07 D0 81 18 01 3A 01 3B 1C 78 01 39 0C 70 01 3A F9 D2 F0 BD 0F 2A 08 D8 00 2C FA D0 00 23 EA 5C F2 54 01 33 A3 42 FA D1 F3 E7 0B 1C 03 43 9F 07 F2 D1 15 1C 0C 1C 03 1C 26 68 1E 60 66 68 5E 60 A6 68 9E 60 E6 68 10 3D DE 60 10 34 10 33 0F 2D F2 D8 10 3A 13 09 5D 1C 2D 01 1B 01 46 19 4D 19 D1 1A 0C 1C 03 29 D7 D9 00 23 EA 58 F2 50 04 33 CA 1A 03 2A F9 D8 04 39 8C 08 63 1C 9B 00 A4 00 F6 18 ED 18 0C 1B C7 E7 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "_fflush_r"
		size = 272
		refs = "007a _free_r 00d4 __sinit"
	strings:
		$1 = { F0 B5 07 1C 0C 1C 00 28 02 D0 83 6B 00 2B 61 D0 A3 89 1A 04 12 14 11 07 35 D4 80 22 12 01 13 43 62 68 A3 81 00 2A 50 DD A6 6A 00 2E 50 D0 DA 04 57 D5 25 6D 59 07 06 D5 63 68 ED 1A 23 6B 00 2B 01 D0 E3 6B ED 1A E1 69 38 1C 2A 1C 00 23 00 F0 75 F8 85 42 32 D1 A2 89 2C 4B 13 40 00 22 62 60 22 69 A3 81 22 60 DA 04 39 D4 21 6B 00 29 2F D0 23 1C 40 33 99 42 02 D0 38 1C ?? ?? ?? ?? 00 23 23 63 00 20 20 E0 26 69 00 2E 21 D0 25 68 26 60 AD 1B 93 07 21 D0 00 23 A3 60 00 2D 04 DC 17 E0 2D 1A 00 2D 14 DD 36 18 62 6A E1 69 94 46 38 1C 32 1C 2B 1C 00 F0 43 F8 00 28 F1 DC A2 89 40 23 13 43 01 20 A3 81 40 42 F0 BD E2 6B 00 2A AB DC 00 20 F9 E7 ?? ?? ?? ?? 9A E7 63 69 DC E7 25 65 C3 E7 E1 69 38 1C 00 22 01 23 00 F0 27 F8 05 1C 43 1C 02 D0 A3 89 A6 6A 9C E7 3B 68 1D 2B E7 D0 A2 89 40 23 13 43 A3 81 DE E7 C0 46 FF F7 00 00 }
	condition:
		$1
}

rule file_47_1_0 {
	meta:
		name = "fflush"
		size = 44
		refs = "000c _fflush_r 0018 _fwalk_reent 0020 _impure_ptr 0024 _global_impure_ptr"
	strings:
		$1 = { 00 B5 01 1C 00 28 04 D0 05 4B 18 68 ?? ?? ?? ?? 00 BD 04 4B 04 49 18 68 ?? ?? ?? ?? F8 E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "write_char"
		size = 28
		refs = "0010 _write_r 0018 _impure_ptr"
	strings:
		$1 = { 00 B5 81 B0 04 4B 6A 46 10 70 02 21 18 68 01 23 ?? ?? ?? ?? 01 B0 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_1_0 {
	meta:
		name = "write_string"
		size = 32
		refs = "0008 strlen 0014 _write_r 001c _impure_ptr"
	strings:
		$1 = { 30 B5 06 4B 04 1C 1D 68 ?? ?? ?? ?? 02 21 03 1C 22 1C 28 1C ?? ?? ?? ?? 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_2_0 {
	meta:
		name = "print_number"
		size = 80
		refs = "001a __umodsi3 0028 __udivsi3"
	strings:
		$1 = { F0 B5 88 B0 06 1C 14 1C 00 2A 17 DB 6D 46 1F 35 00 23 2B 70 0D 4F 20 1C 31 1C ?? ?? ?? ?? 3B 5C 01 3D 20 1C 31 1C 2B 70 ?? ?? ?? ?? 04 1C 00 28 F1 D1 28 1C FF F7 D4 FF 08 B0 F0 BD 00 29 E5 D1 2D 20 FF F7 BF FF 64 42 E0 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_4_0 {
	meta:
		name = "__dprintf"
		size = 380
		refs = "0170 __unctrl"
	strings:
		$1 = { 0F B4 F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 83 B0 6A 46 0A 32 01 21 11 80 11 78 0C AB 4A 42 51 41 52 4A 40 CB 11 60 52 4A 01 93 93 46 30 78 00 28 1B D0 25 28 43 D1 01 36 31 78 25 29 3F D0 4E 29 41 D0 0B 1C 63 3B 1B 06 1B 0E 01 36 15 2B ED D8 48 4A 9B 00 D3 58 9F 46 01 9B 1A 1D 18 68 01 92 FF F7 78 FF 30 78 00 28 E3 D1 03 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BC 08 BC 04 B0 18 47 01 9B 1A 1D 01 92 10 20 1A 68 01 21 FF F7 73 FF CD E7 01 9B 1A 68 78 29 66 D0 0A 20 04 33 64 39 01 93 4B 1E 99 41 FF F7 66 FF C0 E7 01 9B 1A 1D 1B 78 01 92 2F 4A 9B 00 98 58 FF F7 4C FF B6 E7 01 36 FF F7 3A FF B2 E7 01 9B 1A 1C 08 32 1C 68 5D 68 73 1C 01 92 00 93 76 78 37 1C 63 3F B2 46 3F 06 25 4A 3F 0E 53 46 64 3B BE 00 96 19 1A 1C 53 1E 9A 41 90 46 01 3C 19 D4 15 2F 10 D8 33 68 9F 46 53 46 78 2B 2C D0 0A 22 91 46 28 1C 41 46 FF F7 59 FF 41 46 02 1C 48 46 FF F7 2C FF 04 35 00 2C E8 D0 20 20 FF F7 08 FF 01 3C E5 D5 00 9E 01 36 7C E7 01 CD FF F7 0E FF F1 E7 28 1C 01 21 FF F7 41 FF 01 21 02 1C 10 20 FF F7 14 FF 04 35 E6 E7 2B 78 5A 46 9B 00 98 58 01 35 FF F7 FB FE DE E7 10 23 99 46 D1 E7 10 20 97 E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "wcstombs"
		size = 38
	strings:
		$1 = { 10 B5 00 2A 0B D0 00 23 10 C9 24 06 24 0E C4 54 00 2C 06 D0 01 33 9A 42 F6 D1 10 1C 10 BD 00 20 FC E7 18 1C FA E7 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "hash_fd"
		size = 38
		refs = "001c __errno"
	strings:
		$1 = { 10 B5 00 28 07 D0 C2 69 8A 23 5B 00 D4 58 63 1C 04 D0 20 1C 10 BD 01 24 64 42 FA E7 ?? ?? ?? ?? 02 23 03 60 F5 E7 }
	condition:
		$1
}

rule file_50_1_0 {
	meta:
		name = "flush_meta"
		size = 616
		refs = "01ea lseek 0204 write 023c __put_page 0246 __errno"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 9A 23 5B 00 C3 58 C3 B0 04 1C 00 2B 05 D1 00 20 43 B0 0C BC 90 46 9A 46 F0 BD 8F 4B 03 60 02 23 43 60 86 23 5B 00 C3 58 0C 21 8C 48 00 F0 19 FF 8A 23 5B 00 E6 58 E3 78 02 AD 20 64 2B 70 A3 78 6B 70 63 78 AB 70 23 78 EB 70 22 1D D1 78 03 AB 19 70 91 78 59 70 52 78 9A 70 22 79 DA 70 22 1C 08 32 D1 78 04 AB 19 70 91 78 59 70 52 78 9A 70 22 7A DA 70 22 1C 0C 32 D1 78 05 AB 19 70 91 78 59 70 52 78 9A 70 22 7B DA 70 22 1C 10 32 D1 78 06 AB 19 70 91 78 59 70 52 78 9A 70 22 7C DA 70 22 1C 14 32 D1 78 07 AB 19 70 91 78 59 70 52 78 9A 70 22 7D DA 70 22 1C 18 32 D1 78 08 AB 19 70 91 78 59 70 52 78 9A 70 22 7E DA 70 22 1C 1C 32 D1 78 09 AB 19 70 91 78 59 70 52 78 9A 70 22 7F DA 70 22 1C 20 32 D1 78 0A AB 19 70 91 78 59 70 51 78 99 70 12 78 DA 70 22 1C 24 32 D1 78 0B AB 19 70 91 78 59 70 51 78 99 70 12 78 DA 70 22 1C 28 32 D1 78 0C AB 19 70 91 78 59 70 51 78 99 70 12 78 DA 70 22 1C 2C 32 D1 78 0D AB 19 70 91 78 59 70 51 78 99 70 12 78 DA 70 22 1C 30 32 D1 78 0E AB 19 70 91 78 59 70 51 78 99 70 12 78 DA 70 22 1C 34 32 D1 78 0F AB 19 70 91 78 59 70 51 78 99 70 12 78 DA 70 22 1C 38 32 D1 78 10 AB 19 70 91 78 59 70 51 78 99 70 12 78 DA 70 22 1C 3C 32 D1 78 11 AB 19 70 91 78 59 70 51 78 99 70 12 78 DA 70 22 1C 40 32 D1 78 12 AB 19 70 91 78 59 70 51 78 99 70 12 78 21 1C DA 70 C4 31 23 1C 44 33 13 AA 33 A8 8A 46 88 46 DF 78 17 70 9F 78 57 70 5F 78 97 70 1F 78 D7 70 4F 78 07 70 0F 78 04 33 47 70 04 32 02 31 02 30 43 45 ED D1 30 1C 00 21 00 22 ?? ?? ?? ?? 01 30 02 D1 01 20 40 42 0F E7 82 23 5B 00 30 1C 29 1C 1A 1C 01 93 ?? ?? ?? ?? 47 1C F2 D0 01 9B 98 42 19 D1 9C 27 DC 23 7F 00 5B 00 E5 19 56 46 E7 18 04 E0 04 35 02 36 BD 42 00 D1 F4 E6 29 68 00 29 F7 D0 01 23 32 88 20 1C 00 93 00 23 ?? ?? ?? ?? 00 28 EE D0 D5 E7 ?? ?? ?? ?? 4F 23 03 60 ?? ?? ?? ?? 96 23 02 68 5B 00 01 20 E2 50 40 42 DB E6 61 15 06 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_50_2_0 {
	meta:
		name = "hdestroy"
		size = 220
		refs = "0010 __buf_free 002c free 00a2 close 00ba __errno"
	strings:
		$1 = { F0 B5 47 46 80 B4 9A 23 5B 00 C2 58 01 21 06 1C ?? ?? ?? ?? 00 28 50 D1 00 23 98 46 EC 25 6D 00 73 59 00 2B 1D D0 84 27 18 68 7F 00 ?? ?? ?? ?? F3 59 5A 1E F2 51 00 2B 0E D0 82 24 64 00 33 59 72 59 01 3B 33 51 9B 00 98 58 ?? ?? ?? ?? F3 59 5A 1E F2 51 00 2B F2 D1 EC 23 5B 00 F0 58 ?? ?? ?? ?? 30 1C FF F7 98 FE 00 28 02 D0 43 46 00 2B 28 D0 DC 27 7F 00 F3 59 00 2B 0D DD 9C 23 5B 00 F5 18 00 24 28 68 00 28 01 D0 ?? ?? ?? ?? F3 59 01 34 04 35 A3 42 F5 DC 8A 23 5B 00 F0 58 43 1C 01 D0 ?? ?? ?? ?? 30 1C ?? ?? ?? ?? 43 46 00 2B 0D D1 00 20 04 BC 90 46 F0 BD ?? ?? ?? ?? 00 68 80 46 AB E7 ?? ?? ?? ?? 00 68 80 46 D1 E7 ?? ?? ?? ?? 43 46 03 60 01 20 40 42 EB E7 }
	condition:
		$1
}

rule file_50_3_0 {
	meta:
		name = "alloc_segs"
		size = 112
		refs = "000a calloc 0058 __errno"
	strings:
		$1 = { F0 B5 05 1C 0C 1C 40 69 04 21 ?? ?? ?? ?? EC 26 76 00 A8 51 00 28 1F D0 E8 69 23 1C 83 40 18 1C 04 21 ?? ?? ?? ?? 00 28 16 D0 00 2C 12 DD 82 23 5B 00 EB 58 EF 69 AA 59 9C 46 00 23 19 1C B9 40 89 00 41 18 01 33 02 C2 A3 42 F7 D1 82 22 52 00 63 44 AB 50 00 20 F0 BD ?? ?? ?? ?? 04 68 28 1C FF F7 60 FF ?? ?? ?? ?? 04 60 01 20 40 42 F2 E7 }
	condition:
		$1
}

rule file_50_4_0 {
	meta:
		name = "hash_close"
		size = 32
		refs = "0012 free"
	strings:
		$1 = { 30 B5 04 1C 00 28 08 D0 C0 69 FF F7 59 FC 05 1C 20 1C ?? ?? ?? ?? 28 1C 30 BD 01 25 6D 42 FA E7 }
	condition:
		$1
}

rule file_50_5_0 {
	meta:
		name = "hash_delete"
		size = 62
		refs = "0022 __errno"
	strings:
		$1 = { 10 B5 0B 1C C4 69 01 2A 0B D8 88 22 52 00 A2 58 91 07 10 D0 1A 1C 20 1C 03 21 00 23 FF F7 C0 FE 10 BD ?? ?? ?? ?? 16 22 96 23 02 60 5B 00 01 20 E2 50 40 42 F4 E7 ?? ?? ?? ?? 01 22 F4 E7 }
	condition:
		$1
}

rule file_50_6_0 {
	meta:
		name = "hash_get"
		size = 46
		refs = "001a __errno"
	strings:
		$1 = { 70 B5 0E 1C 15 1C C4 69 00 2B 06 D1 20 1C 00 21 32 1C 2B 1C FF F7 DC FE 70 BD ?? ?? ?? ?? 16 22 96 23 02 60 5B 00 01 20 E2 50 40 42 F4 E7 }
	condition:
		$1
}

rule file_50_7_0 {
	meta:
		name = "hash_put"
		size = 88
		refs = "0038 __errno"
	strings:
		$1 = { 70 B5 0E 1C 15 1C C4 69 08 2B 01 D0 00 2B 0F D1 88 22 52 00 A2 58 91 07 14 D0 08 2B 06 D0 01 21 20 1C 32 1C 2B 1C FF F7 FF FE 70 BD 02 21 F7 E7 96 23 5B 00 16 25 E5 50 ?? ?? ?? ?? 05 60 01 20 40 42 F2 E7 ?? ?? ?? ?? 01 22 96 23 02 60 5B 00 01 20 E2 50 40 42 E8 E7 }
	condition:
		$1
}

rule file_50_8_0 {
	meta:
		name = "hash_seq"
		size = 436
		refs = "0066 __get_buf 0086 __errno 01a8 __big_keydata"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 81 B0 8A 46 91 46 C4 69 03 2B 00 D1 6E E0 00 2B 32 D1 03 2B 00 D1 69 E0 92 23 5B 00 E3 58 00 2B 64 DB 90 23 5B 00 E2 58 00 23 00 2A 3C D0 13 69 94 26 76 00 A1 59 48 1C 40 00 C0 5A 00 28 27 D1 90 25 6D 00 01 27 05 E0 03 69 98 88 A7 51 01 21 00 28 1D D1 49 00 C9 5A 20 1C 00 23 ?? ?? ?? ?? 02 1C 60 51 00 28 EF D1 01 20 40 42 01 B0 1C BC 90 46 99 46 A2 46 F0 BD 07 2B CA D0 ?? ?? ?? ?? 16 22 96 23 02 60 5B 00 01 20 E2 50 40 42 ED E7 19 88 00 29 42 D1 90 22 52 00 A1 50 92 22 52 00 A1 58 01 31 A1 50 00 22 92 21 49 00 65 58 A1 6A 8D 42 28 D8 90 26 94 27 01 21 76 00 7F 00 88 46 0A E0 03 69 19 88 A0 51 00 29 1B D1 41 46 E1 51 A1 6A 01 35 A9 42 16 D3 00 22 20 1C 29 1C 00 23 ?? ?? ?? ?? 02 1C 00 28 EB D1 BD E7 92 23 5B 00 00 22 E2 50 94 23 5B 00 01 21 E1 50 90 23 5B 00 E2 50 91 E7 A1 6A 92 20 40 00 25 50 8D 42 00 DC 8E E7 01 23 5B 42 23 50 01 20 A7 E7 94 20 40 00 20 5A 45 1C 6D 00 5D 5B 03 2D 32 D9 90 22 52 00 A6 58 47 00 DA 5B 36 69 57 46 B6 18 3E 60 01 28 25 D9 46 1E 76 00 F3 5A 9B 1A 56 46 73 60 90 23 5B 00 E6 58 4F 46 52 1B 36 69 7A 60 82 1C 12 04 76 19 12 0C 3E 60 91 42 0C D2 00 22 E2 50 92 23 5B 00 E2 58 01 32 E2 50 94 23 5B 00 01 22 E2 50 00 20 73 E7 94 23 5B 00 E2 50 00 20 6E E7 E3 68 DA E7 01 23 00 93 11 1C 20 1C 52 46 4B 46 ?? ?? ?? ?? 00 28 00 D1 61 E7 5E E7 }
	condition:
		$1
}

rule file_50_9_0 {
	meta:
		name = "hash_sync"
		size = 78
		refs = "001a __errno 0034 __buf_free"
	strings:
		$1 = { 10 B5 00 29 09 D1 00 28 0E D0 C4 69 9A 23 5B 00 E3 58 00 2B 0B D1 00 20 10 BD ?? ?? ?? ?? 16 23 03 60 01 20 40 42 F7 E7 01 20 40 42 F4 E7 20 1C 00 21 01 22 ?? ?? ?? ?? 00 28 F5 D1 20 1C FF F7 FB FA 00 28 F0 D1 98 23 5B 00 E0 50 E4 E7 }
	condition:
		$1
}

rule file_50_10_0 {
	meta:
		name = "hash_access"
		size = 472
		refs = "0028 __call_hash 0034 __get_buf 008a __find_bigpair 00a0 __find_last_page 0118 memcmp 012c __delpair 013c __addel 0160 __big_return 0180 abort"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 86 B0 02 92 04 93 02 9B 82 46 1B 68 C0 68 52 68 03 91 80 46 19 1C 50 46 93 46 99 46 ?? ?? ?? ?? 00 22 01 1C 00 23 50 46 ?? ?? ?? ?? 01 90 00 28 00 D1 93 E0 02 7D 08 23 13 43 03 75 04 69 27 88 01 2F 00 DC C0 E0 42 46 02 34 01 9E 01 25 C8 46 08 E0 21 88 52 1A 5A 45 54 D0 02 35 1A 1C 04 34 BD 42 2D DA 63 88 A0 1C 81 46 03 2B F1 D8 00 2B 38 D0 58 46 00 90 2A 1C 50 46 31 1C 43 46 ?? ?? ?? ?? 05 1C 00 28 00 DD 6B E0 02 35 32 D1 05 A9 50 46 05 96 ?? ?? ?? ?? 01 1C 00 28 00 D1 74 E0 50 46 05 9A 00 23 ?? ?? ?? ?? 06 1C 00 28 63 D0 34 69 27 88 53 46 01 25 02 34 DA 68 BD 42 D1 DB 03 9B 01 3B 01 2B 2F D9 01 9A 13 7D 01 98 08 22 93 43 03 75 01 20 06 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 32 1C 21 88 50 46 ?? ?? ?? ?? 06 1C 00 28 DD D1 01 98 03 7D 08 22 93 43 03 75 01 20 40 42 E8 E7 33 69 40 46 59 18 5A 46 ?? ?? ?? ?? 00 28 26 D0 4A 46 13 88 9F E7 50 46 31 1C 2A 1C ?? ?? ?? ?? 00 28 27 D1 50 46 31 1C 02 9A 04 9B ?? ?? ?? ?? 00 28 1F D1 01 9A 13 7D 01 98 08 22 93 43 03 75 00 20 C6 E7 03 9A 50 46 00 92 31 1C 2A 1C 04 9B ?? ?? ?? ?? 00 28 ED D0 01 20 40 42 B9 E7 03 9A 01 2A D8 D0 00 2A 10 D0 02 2A 24 D0 03 2A 1A D0 ?? ?? ?? ?? 01 9A 13 7D 01 98 08 22 93 43 03 75 01 20 40 42 A5 E7 05 9E 98 E7 32 69 6B 1C 5B 00 D3 5A 03 2B D6 D9 6D 00 D1 18 AA 5A 04 98 D3 1A 01 60 43 60 C6 E7 50 46 31 1C 2A 1C ?? ?? ?? ?? 00 28 BF D0 D0 E7 01 98 03 7D 08 22 93 43 03 75 01 20 86 E7 01 9E 79 E7 }
	condition:
		$1
}

rule file_50_11_0 {
	meta:
		name = "__call_hash"
		size = 34
	strings:
		$1 = { 10 B5 86 23 5B 00 04 1C C3 58 08 1C 11 1C 00 F0 C8 FF E3 6A 18 40 A3 6A 98 42 01 DD 23 6B 18 40 10 BD }
	condition:
		$1
}

rule file_50_12_0 {
	meta:
		name = "__expand_table"
		size = 234
		refs = "003c calloc 0062 __log2 0090 __split_page 00aa malloc 00bc memmove 00cc memset 00d2 free"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 85 6A 82 23 01 35 C6 69 5B 00 01 6B 2A 1C C3 58 F2 40 04 1C 85 62 88 46 16 1C 9A 42 5D DB 43 69 9A 42 37 DA EC 23 5B 00 C3 58 9A 46 04 21 A0 69 ?? ?? ?? ?? B6 00 51 46 70 50 00 28 4A D0 84 23 5B 00 E2 58 01 32 E2 50 82 23 5B 00 E2 58 01 32 E2 50 A0 6A 01 30 ?? ?? ?? ?? 23 6A 98 42 07 DD 11 33 02 1C 9B 00 11 32 1B 59 92 00 13 51 20 62 E3 6A 9D 42 02 D9 23 63 2B 43 E3 62 41 46 29 40 20 1C 2A 1C ?? ?? ?? ?? 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 99 00 DB 00 18 1C 8B 46 99 46 ?? ?? ?? ?? 82 46 00 28 15 D0 EC 27 7F 00 E1 59 5A 46 ?? ?? ?? ?? 4B 46 59 46 50 46 5A 1A 58 44 00 21 ?? ?? ?? ?? E0 59 ?? ?? ?? ?? 52 46 4B 46 E2 51 63 61 AB E7 01 20 40 42 D6 E7 28 1C BA E7 }
	condition:
		$1
}

rule file_50_13_0 {
	meta:
		name = "__hash_open"
		size = 1524
		refs = "0026 calloc 004e __errno 006c open 00ac read 02ea close 02f0 free 031c stat 0330 fstat 0378 memset 03f4 __divsi3 0400 __log2 0426 __ibitmap 04ae __buf_init 04dc malloc 05cc __default_hash 05d4 hash_close 05d8 hash_delete 05dc hash_fd 05e0 hash_get 05e4 hash_put 05e8 hash_seq 05ec hash_sync"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 A4 B0 01 93 03 23 0B 40 00 90 0D 1C 16 1C 01 2B 00 D1 75 E1 EE 21 01 20 49 00 ?? ?? ?? ?? 04 1C 00 28 00 D1 02 E2 8A 23 01 22 5B 00 52 42 C2 50 88 23 00 9A 5B 00 C5 50 00 2A 02 D0 6B 05 00 D4 64 E1 ?? ?? ?? ?? 03 68 02 2B 00 D1 F2 E1 00 9F 00 2F 00 D1 6F E1 01 22 03 92 00 98 29 1C 32 1C ?? ?? ?? ?? 8A 23 5B 00 E0 50 43 1C 00 D1 90 E2 AF 05 00 D5 54 E1 03 9A 00 2A 00 D0 5B E1 01 9A 00 2A 00 D1 A7 E1 12 69 00 2A 00 D1 A3 E1 86 23 5B 00 E2 50 8A 23 5B 00 82 22 E0 58 21 1C 52 00 ?? ?? ?? ?? 23 68 02 90 22 93 22 A9 CB 78 23 70 8B 78 63 70 4B 78 A3 70 0B 78 E3 70 63 68 22 93 CA 78 22 71 8A 78 23 1D 5A 70 4A 78 9A 70 0A 78 DA 70 A3 68 22 93 CA 78 22 72 23 1C 8A 78 08 33 5A 70 4A 78 9A 70 0A 78 DA 70 E3 68 22 93 CA 78 23 1C 22 73 8A 78 0C 33 5A 70 4A 78 9A 70 0A 78 DA 70 23 69 22 93 CA 78 22 74 23 1C 8A 78 10 33 5A 70 4A 78 9A 70 0A 78 DA 70 63 69 22 93 CA 78 22 75 23 1C 8A 78 14 33 5A 70 4A 78 9A 70 0A 78 DA 70 A3 69 22 93 CA 78 22 76 23 1C 8A 78 18 33 5A 70 4A 78 9A 70 0A 78 DA 70 E3 69 22 93 CA 78 22 77 23 1C 8A 78 1C 33 5A 70 4A 78 9A 70 0A 78 DA 70 23 6A 22 93 23 1C CA 78 20 33 1A 70 8A 78 5A 70 4A 78 9A 70 0A 78 DA 70 63 6A 22 93 23 1C CA 78 24 33 1A 70 8A 78 5A 70 4A 78 9A 70 0A 78 DA 70 A3 6A 22 93 CA 78 23 1C 28 33 1A 70 8A 78 5A 70 4A 78 9A 70 0A 78 DA 70 E3 6A 22 93 23 1C CA 78 2C 33 1A 70 8A 78 5A 70 4A 78 9A 70 0A 78 DA 70 23 6B 22 93 23 1C CA 78 30 33 1A 70 8A 78 5A 70 4A 78 9A 70 0A 78 DA 70 63 6B 22 93 23 1C CA 78 34 33 1A 70 8A 78 5A 70 4A 78 9A 70 0A 78 DA 70 A3 6B 22 93 23 1C CA 78 38 33 1A 70 8A 78 5A 70 4A 78 9A 70 0A 78 DA 70 E3 6B 22 93 23 1C CA 78 3C 33 1A 70 8A 78 5A 70 4A 78 9A 70 0A 78 DA 70 23 6C 22 93 23 1C CA 78 40 33 1A 70 8A 78 5A 70 4A 78 9A 70 0A 78 DA 70 8B 23 6B 44 9B 46 8A 27 89 22 8F 23 25 1C 6A 44 6B 44 6F 44 6E 46 20 1C 44 35 92 46 98 46 B9 46 8E 36 C4 30 2B 1C 00 22 A4 46 10 CD 22 94 5F 46 3C 78 1C 70 4F 46 3C 78 5C 70 57 46 3C 78 9C 70 0C 78 67 46 DC 70 BC 18 C4 34 24 88 34 80 47 46 3C 78 84 54 34 78 87 18 04 33 7C 70 02 32 98 42 E3 D1 02 9A 64 46 01 32 00 D1 71 E1 82 23 02 9F 5B 00 9F 42 12 D1 22 68 C0 4B 9A 42 0E D1 63 68 01 3B 01 2B 0A D8 86 23 5B 00 E3 58 BC 48 0C 21 00 F0 EE FB 23 6C 98 42 00 D1 BA E0 4F 25 8A 23 5B 00 E0 58 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? ?? ?? ?? ?? 05 60 00 25 24 B0 28 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD ?? ?? ?? ?? 16 23 03 60 00 25 F1 E7 10 1C 13 A9 ?? ?? ?? ?? 00 28 00 D0 91 E0 00 27 03 97 9C E6 13 AD 29 1C ?? ?? ?? ?? 00 28 00 D0 A3 E6 2B 69 00 2B 00 D0 9F E6 00 23 A3 63 A0 4B A3 60 80 23 5B 01 E3 60 0C 23 23 61 80 23 5B 00 08 22 A3 61 E2 61 63 61 9A 4A 80 23 5B 02 12 68 63 63 86 23 5B 00 20 1C E2 50 00 21 80 22 44 30 ?? ?? ?? ?? 20 1C C4 30 00 21 40 22 ?? ?? ?? ?? 00 9B 00 2B 00 D0 F0 E0 01 9F 00 2F 00 D1 10 E1 01 9A 10 68 00 28 00 D0 DB E0 01 9F 7B 68 00 2B 00 D0 63 63 01 9B 1A 69 00 2A 02 D0 86 23 5B 00 E2 50 01 9F BB 68 00 2B 3C D1 01 20 01 9A 53 69 00 2B 11 D0 7E 4A 93 42 0D D0 7F 4A 93 42 0A D0 ?? ?? ?? ?? 16 23 03 60 25 E0 7A 4A 86 23 12 68 5B 00 E2 50 58 E6 A3 60 01 38 61 6B ?? ?? ?? ?? 01 30 02 28 00 DA C8 E0 ?? ?? ?? ?? 03 1C 11 33 42 1C 9B 00 1A 51 03 1C 12 33 9B 00 C1 02 1A 51 02 23 05 1C 20 62 63 62 01 31 20 1C 00 23 ?? ?? ?? ?? 00 28 71 D0 ?? ?? ?? ?? 00 24 05 68 5A E7 00 25 5F E7 18 1C C1 E7 ?? ?? ?? ?? 00 23 03 60 07 E6 ?? ?? ?? ?? 03 68 02 2B 00 D0 67 E7 FA E5 A1 69 A0 6A 08 18 ?? ?? ?? ?? 00 23 01 1C E3 51 20 1C FF F7 91 FD 00 28 E2 D1 23 6A 11 33 9B 00 E2 68 1B 59 D2 00 D2 18 23 69 01 3A 03 33 1A 41 DC 23 5B 00 E2 50 9C 23 5B 00 E0 18 92 00 00 21 ?? ?? ?? ?? 01 9F 00 2F 02 D0 F9 68 00 29 30 D1 80 21 20 1C 49 02 ?? ?? ?? ?? 98 23 03 9A 5B 00 E2 50 00 9B 00 2B 66 D0 88 23 5B 00 E2 58 92 07 D2 0F 9A 23 5B 00 E2 50 92 23 01 22 5B 00 52 42 E2 50 24 20 ?? ?? ?? ?? 05 1C 00 28 5F D0 3B 4B 43 60 3B 4B 83 60 3B 4B 03 62 3B 4B C3 60 3B 4B 03 61 3B 4B 43 61 3B 4B 83 61 01 23 C4 61 03 60 F8 E6 20 1C ?? ?? ?? ?? CF E7 01 26 33 1C AB 40 58 1E 5D 00 34 4A 23 69 DA 40 13 1C 01 33 01 3D E3 63 A1 69 20 63 A0 62 E5 62 ?? ?? ?? ?? 01 30 ?? ?? ?? ?? 31 1C 63 69 81 40 99 42 00 DD 61 61 20 1C FF F7 21 FD 00 28 00 D0 6C E7 01 27 03 97 A0 E7 ?? ?? ?? ?? 01 22 80 23 82 40 5B 02 20 61 E2 60 9A 42 00 DC 18 E7 32 E7 04 AD 18 1C 29 1C ?? ?? ?? ?? 00 28 00 D0 55 E7 E8 6A E0 60 ?? ?? ?? ?? 20 61 00 E7 00 22 9B E7 02 20 34 E7 ?? ?? ?? ?? 05 68 A2 E6 ?? ?? ?? ?? 05 68 A3 E6 ?? ?? ?? ?? 06 68 20 1C FF F7 81 FC ?? ?? ?? ?? 06 60 A0 E6 00 20 19 E7 C0 46 61 15 06 00 ?? ?? ?? ?? D2 04 00 00 ?? ?? ?? ?? E1 10 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF 01 00 00 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "_wctomb_r"
		size = 704
		refs = "000c strlen 0018 strcmp 0284 __lc_ctype"
	strings:
		$1 = { F0 B5 A0 4E 30 1C 0C 1C 15 1C 1F 1C ?? ?? ?? ?? 01 28 1C D9 30 1C 9C 49 ?? ?? ?? ?? 00 28 1D D1 00 2C 62 D0 7F 2D 5D D9 2A 1C 98 4B 80 3A 9A 42 37 D8 6A 05 40 23 D2 0E 5B 42 13 43 23 70 3F 23 1D 40 80 23 5B 42 2B 43 63 70 02 20 05 E0 00 2C 4B D0 2D 06 2B 0E 23 70 01 20 F0 BD 30 1C 8C 49 ?? ?? ?? ?? 00 28 63 D1 00 2C 3E D0 2A 04 2B 06 12 0E 1B 0E 00 2A EE D0 11 1C 20 31 09 06 09 0E 0F 29 00 D9 A6 E0 80 21 59 40 7C 29 05 D9 19 1C 40 39 09 06 09 0E 3E 29 60 D8 22 70 63 70 02 20 DB E7 7C 4B EA 18 7C 4B 9A 42 79 D9 7B 4B EA 18 7B 4B 9A 42 1B D8 EA 02 10 23 52 0F 5B 42 13 43 23 70 A9 03 80 23 5B 42 89 0E 19 43 61 70 29 05 89 0E 19 43 62 1C 51 70 3F 21 0D 40 2B 43 93 70 04 20 BA E7 25 70 01 20 B7 E7 00 20 B5 E7 6D 4B EA 18 6D 4B 9A 42 74 D8 AA 01 08 23 92 0F 5B 42 13 43 23 70 2A 02 A8 03 80 23 5B 42 92 0E 80 0E 61 1C 1A 43 18 43 62 70 48 70 4A 1C 29 05 89 0E 19 43 51 70 3F 21 0D 40 2B 43 93 70 05 20 94 E7 30 1C 5E 49 ?? ?? ?? ?? 00 28 12 D1 00 2C D4 D0 2B 06 2D 04 2D 0E 1B 0E 00 2D 00 D1 83 E7 2A 1C 5F 32 12 06 12 0E 5D 2A 00 D8 86 E0 01 20 40 42 7B E7 30 1C 52 49 ?? ?? ?? ?? 00 28 00 D0 6E E7 00 2C 00 D1 70 E7 2B 06 2D 04 2D 0E 1B 0E 00 2D 56 D1 3A 68 00 2A 22 D0 1B 22 3D 60 28 21 22 70 62 1C 61 70 42 21 94 1C 51 70 04 20 23 70 5C E7 44 4B EA 18 44 4B 9A 42 D8 D9 2A 04 20 23 12 0F 5B 42 13 43 23 70 2A 05 80 23 5B 42 92 0E 1A 43 62 70 3F 22 15 40 2B 43 A3 70 03 20 45 E7 01 20 23 70 42 E7 11 1C 7F 31 09 06 09 0E 1E 29 BD D8 51 E7 FC 23 1B 06 EA 18 34 4B 9A 42 B6 D8 6A 00 04 23 D2 0F 5B 42 13 43 23 70 A9 00 28 02 80 23 5B 42 89 0E 80 0E 62 1C 19 43 18 43 61 70 50 70 A8 03 80 0E 51 1C 18 43 48 70 4A 1C 29 05 89 0E 19 43 51 70 3F 21 0D 40 2B 43 93 70 06 20 14 E7 2A 1C 21 3A 12 06 12 0E 5D 2A 8F D8 1A 1C 21 3A 12 06 12 0E 5D 2A 89 D8 3A 68 00 2A 18 D1 01 22 3A 60 24 21 1B 22 22 70 61 70 62 1C 42 21 51 70 94 1C 05 20 25 70 63 70 F7 E6 1A 1C 5F 32 12 06 12 0E 5D 2A 00 D9 71 E7 25 70 63 70 02 20 EC E6 02 20 EF E7 ?? ?? ?? ?? ?? ?? ?? ?? 7F 07 00 00 ?? ?? ?? ?? 00 F8 FF FF FF F7 00 00 00 00 FF FF FF FF 1E 00 00 00 E0 FF FF FF DF 03 ?? ?? ?? ?? ?? ?? ?? ?? 00 28 FF FF FF 07 00 00 FF FF FF 7B }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "_wcstoul_r"
		size = 332
		refs = "001c iswspace 0048 __umodsi3 0056 __udivsi3 0062 iswdigit 0098 iswalpha 00a2 iswupper"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 84 B0 03 90 00 91 01 92 98 46 0E 1C 10 CE 20 1C ?? ?? ?? ?? 00 28 F9 D1 2D 2C 00 D1 75 E0 2B 2C 00 D1 76 E0 00 22 02 92 41 46 4B 42 4B 41 10 29 4E D0 00 2B 4C D1 01 20 40 42 41 46 ?? ?? ?? ?? C3 46 81 46 01 20 40 42 59 46 ?? ?? ?? ?? 82 46 20 1C 00 25 00 27 ?? ?? ?? ?? 00 28 15 D0 30 3C A0 45 20 DD 57 45 3F D8 00 2D 3D DB 4C 45 01 DD 57 45 39 D0 3A 1C 5F 46 57 43 E7 19 10 CE 01 25 20 1C ?? ?? ?? ?? 00 28 E9 D1 20 1C ?? ?? ?? ?? 00 28 08 D0 20 1C ?? ?? ?? ?? 00 28 28 D1 57 23 E4 1A A0 45 DE DC 6B 1C 2A D0 02 9A 00 2A 25 D1 01 9B 00 2B 04 D0 00 2D 1D D1 00 99 01 9A 11 60 04 B0 38 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 30 2C 22 D0 00 2B AE D0 30 2C 2B D0 0A 22 05 21 89 46 93 46 90 46 AD E7 01 25 6D 42 10 CE C7 E7 37 23 E4 1A D5 E7 04 3E 00 96 DE E7 7F 42 D7 E7 03 99 22 23 0B 60 2F 1C D2 E7 01 21 10 CE 02 91 8A E7 00 23 10 CE 02 93 86 E7 32 68 58 2A 01 D0 78 2A D7 D1 10 23 0F 22 74 68 91 46 08 36 9B 46 98 46 87 E7 08 21 07 23 99 46 8B 46 88 46 81 E7 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__tzcalc_limits"
		size = 384
		refs = "0010 __gettzinfo 0030 __divsi3 0058 __modsi3"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 83 B0 04 1C ?? ?? ?? ?? 54 4B 06 1C 9C 42 00 DC 83 E0 53 49 53 4B 54 4A 65 18 64 21 44 60 49 42 E0 18 A7 18 ?? ?? ?? ?? EB 00 5B 19 4F 49 DB 00 BF 10 3F 18 5D 19 60 18 C8 21 AB 00 49 00 ED 18 ?? ?? ?? ?? 7F 19 3F 18 64 21 20 1C ?? ?? ?? ?? C8 21 01 90 49 00 20 1C ?? ?? ?? ?? 43 42 43 41 5A 00 D3 18 1B 01 02 93 03 23 1C 40 BA 46 83 46 35 1C 00 27 A1 46 2B 7A 4A 2B 50 D0 44 2B 63 D0 4B 46 00 2B 44 D0 02 9B 39 4A E8 68 D2 18 90 46 01 28 5E DD 54 46 01 23 02 CA 01 33 64 18 83 42 FA D1 01 3B 9B 00 00 93 20 1D 07 21 ?? ?? ?? ?? 6B 69 18 1A 4B D4 2B 69 01 3B DA 00 D3 1A 00 9A 41 46 C0 18 8B 58 98 42 02 DB 07 38 98 42 FC DA 00 19 44 00 20 18 2A 6A AB 69 04 01 20 1A D3 18 02 01 10 1A C0 01 18 18 01 37 E8 61 1C 35 02 2F C1 D1 F1 69 B2 6B 01 23 91 42 00 DB 00 23 33 60 01 20 03 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 01 99 00 29 B7 D0 30 23 B6 E7 00 20 F1 E7 4A 46 6B 69 00 2A 09 D1 01 99 00 29 06 D0 01 20 3B 2B 00 DC 00 20 53 44 18 18 CB E7 5A 46 00 2A F8 D1 01 20 3B 2B F6 DC F4 E7 68 69 50 44 C1 E7 07 30 B1 E7 00 23 54 46 00 93 A6 E7 C0 46 B1 07 00 00 4E F8 FF FF 93 F8 FF FF 4F F8 FF FF BF F9 FF FF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "_mktm_r"
		size = 804
		refs = "0012 __gettzinfo 0020 __divsi3 002a __modsi3 0116 __tz_lock 01c6 __tz_unlock 0218 __tzcalc_limits 031c _daylight"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 93 46 82 46 0E 1C ?? ?? ?? ?? 81 46 50 46 05 68 B9 49 28 1C ?? ?? ?? ?? B7 49 04 1C 28 1C ?? ?? ?? ?? 05 1C 00 28 03 DA B3 49 01 3C 6D 18 FB D4 B2 4B 9D 42 04 DD B2 4A AD 18 01 34 9D 42 FA DC E1 21 28 1C 09 01 ?? ?? ?? ?? E1 21 B0 60 09 01 28 1C ?? ?? ?? ?? 3C 21 05 1C ?? ?? ?? ?? 3C 21 70 60 28 1C ?? ?? ?? ?? 07 21 30 60 20 1D ?? ?? ?? ?? B0 61 00 28 00 DA C0 E0 00 2C 00 DA 9F E0 03 23 A0 4D A0 4F 98 46 0D E0 28 1C 64 21 ?? ?? ?? ?? 00 28 0A D0 01 20 83 00 FB 18 1B 6E 9C 42 10 DB 01 35 E4 1A 40 46 05 42 EE D0 C8 21 28 1C 49 00 ?? ?? ?? ?? 43 42 58 41 83 00 FB 18 1B 6E 9C 42 EE DA 91 49 6B 18 73 61 43 00 18 18 00 01 00 23 F4 61 3F 18 33 61 3B 68 9C 42 07 DB 39 1D 01 22 32 61 E4 1A 08 C9 01 32 A3 42 F9 DD 01 34 5A 46 F4 60 00 2A 08 D0 00 23 33 62 30 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD ?? ?? ?? ?? 80 4B 1B 68 00 2B 75 D1 5A 46 32 62 48 46 00 6A 80 46 E1 21 09 01 40 46 ?? ?? ?? ?? 3C 21 04 1C ?? ?? ?? ?? 35 68 2D 1A 3C 21 20 1C 35 60 ?? ?? ?? ?? 74 68 E1 21 24 1A 74 60 40 46 09 01 ?? ?? ?? ?? B3 68 1B 1A B3 60 3B 2D 00 DC 90 E0 01 34 3C 3D 74 60 35 60 3B 2C 00 DC 81 E0 72 68 01 33 3C 3A B3 60 72 60 17 2B 5F DD F3 69 01 33 F3 61 B3 69 01 33 B3 61 06 2B 01 DD 00 23 B3 61 B2 68 F3 68 18 3A B2 60 32 69 01 33 F3 60 91 00 C9 59 8B 42 0B DD 5B 1A 01 32 F3 60 32 61 0C 2A 05 D1 72 69 00 23 01 32 33 61 72 61 F3 61 ?? ?? ?? ?? 9D E7 03 21 50 4D 50 4F 88 46 0C E0 28 1C 64 21 ?? ?? ?? ?? 00 28 0A D0 01 20 83 00 FB 18 1B 6E E4 18 00 D4 6F E7 01 3D 42 46 15 42 EE D0 C8 21 28 1C 49 00 ?? ?? ?? ?? 43 42 58 41 ED E7 07 30 B0 61 3B E7 48 46 43 68 AB 42 04 D0 28 1C ?? ?? ?? ?? 00 28 4B D0 49 46 0B 68 00 2B 38 D0 52 46 13 68 CA 69 93 42 46 DB 8A 6B 93 42 43 DA 01 23 33 62 4B 46 DB 6B 98 46 73 E7 00 2B BE DA F3 69 01 3B F3 61 B3 69 01 3B B3 61 00 2B 36 DB F3 68 B2 68 01 3B 18 32 F3 60 B2 60 00 2B AE D1 33 69 01 3B 33 61 00 2B 2C DB 9B 00 FB 58 F3 60 A5 E7 00 2C 80 DA 72 68 01 3B 3C 32 B3 60 72 60 7A E7 00 2D 00 DB 6F E7 01 3C 3C 35 74 60 35 60 6A E7 50 46 49 46 03 68 CA 69 93 42 C8 DA 89 6B 01 22 8B 42 00 DB 00 22 32 62 01 2A C2 D0 36 E7 01 23 5B 42 33 62 32 E7 00 23 33 62 2F E7 06 23 B3 61 C5 E7 74 69 0B 23 01 3C 33 61 74 61 A1 07 0A D1 20 1C 64 21 ?? ?? ?? ?? 00 28 04 D0 B7 23 5B 00 F3 61 2C 23 C1 E7 C8 21 20 1C 49 00 ?? ?? ?? ?? 09 4A 43 42 43 41 9B 18 F2 E7 80 51 01 00 7F 51 01 00 80 AE FE FF B2 07 00 00 ?? ?? ?? ?? 94 F8 FF FF ?? ?? ?? ?? 6D 01 00 00 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "strcasecmp"
		size = 132
		refs = "0080 __ctype_ptr__"
	strings:
		$1 = { F0 B5 47 46 80 B4 02 78 00 2A 2D D0 1C 4B 01 24 1D 68 0D E0 0B 78 5E 1C AE 5D 94 46 26 42 14 D1 1F 1C BC 45 15 D1 01 30 02 78 01 31 00 2A 1D D0 AB 18 5B 78 23 40 98 46 EC D0 20 23 9B 18 9C 46 0B 78 5E 1C AE 5D 26 42 EA D0 1F 1C 20 37 BC 45 E9 D0 41 46 00 29 00 D0 20 32 F1 07 00 D5 20 33 D0 1A 04 BC 90 46 F0 BD 05 4B 1D 68 6A 78 01 23 1A 40 0B 78 5E 1C 90 46 AE 5D 00 22 E9 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "putwchar"
		size = 20
		refs = "0008 fputwc 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 1B 68 99 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "_putwchar_r"
		size = 20
		refs = "0008 _fputwc_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 1B 68 9A 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "ldexpf"
		size = 76
		refs = "0006 finitef 0012 __eqsf2 0022 scalbnf 003c __errno"
	strings:
		$1 = { 30 B5 04 1C 0D 1C ?? ?? ?? ?? 00 28 05 D0 20 1C 0D 49 ?? ?? ?? ?? 00 28 01 D1 20 1C 30 BD 20 1C 29 1C ?? ?? ?? ?? 04 1C ?? ?? ?? ?? 00 28 05 D0 20 1C 05 49 ?? ?? ?? ?? 00 28 EE D1 ?? ?? ?? ?? 22 23 03 60 E9 E7 C0 46 00 00 00 00 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "argz_add_sep"
		size = 74
		refs = "0018 argz_create_sep 0030 realloc 0040 memcpy"
	strings:
		$1 = { 70 B5 82 B0 0C 1C 00 21 01 91 00 91 05 1C 19 1C 10 1C 6B 46 01 AA 26 68 ?? ?? ?? ?? 00 9B 00 2B 02 D1 00 20 02 B0 70 BD 21 68 59 18 21 60 28 68 ?? ?? ?? ?? 28 60 00 28 05 D0 80 19 01 99 00 9A ?? ?? ?? ?? ED E7 0C 20 EC E7 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "argz_delete"
		size = 78
		refs = "000e strlen 0020 memmove 002c realloc 0040 free"
	strings:
		$1 = { F0 B5 06 1C 0D 1C 14 1C 00 2A 17 D0 10 1C ?? ?? ?? ?? 2B 68 32 68 47 1C E1 19 D2 18 52 1A 20 1C ?? ?? ?? ?? 29 68 C9 1B 29 60 30 68 ?? ?? ?? ?? 30 60 00 28 09 D0 2C 68 00 2C 01 D0 00 20 F0 BD ?? ?? ?? ?? 34 60 00 20 F9 E7 0C 20 F7 E7 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "_malloc_r"
		size = 1304
		refs = "003a __malloc_lock 006e __malloc_unlock 0286 _sbrk_r 04d2 _free_r"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0C 1C 0B 34 81 B0 06 1C 16 2C 2F D8 00 23 10 24 8C 42 09 D2 0C 23 33 60 00 20 01 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 2B F3 D1 30 1C ?? ?? ?? ?? D1 4B 9C 42 1D D8 E2 08 D0 4F D3 00 FB 18 DD 68 9D 42 00 D1 A5 E1 6B 68 03 22 A9 68 93 43 EA 68 EB 18 CA 60 91 60 59 68 01 22 0A 43 30 1C 5A 60 ?? ?? ?? ?? 28 1C 08 30 D6 E7 07 23 9C 43 E3 0F CD E7 63 0A 00 2B 00 D1 8D E0 04 2B 00 D9 63 E1 A3 09 38 33 98 46 D9 00 BC 4F 79 18 CD 68 A9 42 17 D0 6A 68 03 23 9A 43 13 1B 0F 2B 00 DD C4 E0 00 2B 00 DB C5 E0 03 20 08 E0 6A 68 82 43 13 1B 0F 2B 00 DD B9 E0 00 2B 00 DB BA E0 ED 68 A9 42 F3 D1 01 25 A8 44 39 1C 08 31 8D 68 A9 42 00 D1 89 E0 6A 68 03 23 9A 43 13 1B 93 46 0F 2B 00 DD 3B E1 C9 60 89 60 00 2B 00 DB B1 E0 A4 4B 9B 45 55 D8 D2 08 93 10 01 20 98 40 D2 00 7B 68 BA 18 03 43 90 68 EA 60 A8 60 C5 60 95 60 45 46 AA 10 01 20 90 40 7B 60 98 42 6C D8 03 42 0C D1 03 22 95 43 2A 1C 04 32 40 00 90 46 03 42 04 D1 04 22 40 00 90 44 18 42 FA D0 03 23 9A 46 45 46 EB 00 DB 19 9B 46 9C 46 C1 46 62 46 D5 68 AC 45 07 D1 08 E1 00 2B 00 DB 25 E1 ED 68 AC 45 00 D1 01 E1 6A 68 53 46 9A 43 13 1B 0F 2B F2 DD 01 20 2A 19 04 43 AF 68 6C 60 EC 68 FC 60 A7 60 18 43 CA 60 8A 60 50 60 D1 60 30 1C 91 60 D3 50 ?? ?? ?? ?? 28 1C 08 30 40 E7 E0 08 80 46 C1 00 74 E7 53 0A 04 2B 00 D9 11 E1 93 09 38 33 9A 46 D8 00 C0 19 83 68 84 46 63 45 00 D1 32 E1 5A 68 03 20 82 43 93 45 0B D2 03 22 92 46 05 E0 58 68 02 1C 50 46 82 43 93 45 02 D2 9B 68 9C 45 F6 D1 DA 68 EA 60 AB 60 DD 60 95 60 45 46 AA 10 01 20 7B 68 90 40 98 42 92 D9 B8 68 43 68 03 22 93 43 99 46 1B 1B 82 46 0F 2B 26 DD 4C 45 24 D8 80 46 01 22 21 1C 11 43 44 44 13 43 45 46 69 60 30 1C BC 60 63 60 ?? ?? ?? ?? 40 46 08 30 F6 E6 01 23 5B 42 98 44 47 E7 EB 68 A9 68 CB 60 99 60 AA 18 51 68 01 23 0B 43 30 1C 53 60 ?? ?? ?? ?? 28 1C 08 30 E3 E6 AA 18 F3 E7 4B 4D 2B 68 4B 49 10 33 1B 19 9B 46 8B 68 88 46 01 33 05 D0 48 4B 1A 1C 48 4B 5A 44 1A 40 93 46 30 1C 59 46 ?? ?? ?? ?? 00 90 41 1C 00 D1 C6 E0 52 46 4A 44 82 42 00 D9 A3 E0 6B 68 5B 44 6B 60 82 42 00 D1 05 E1 41 46 89 68 01 31 00 D1 18 E1 C3 18 9A 1A 6A 60 07 23 03 40 00 D0 A7 E0 80 23 5B 01 00 9A 11 1C 33 4A 59 44 0A 40 9A 1A 30 1C 11 1C 90 46 ?? ?? ?? ?? 43 1C 00 D1 FD E0 00 9A 80 1A 40 44 01 23 18 43 6B 68 00 99 43 44 6B 60 88 46 B9 60 48 60 BA 45 00 D1 E4 E0 4A 46 0F 2A 00 D8 AC E0 4A 46 07 21 0C 3A 8A 43 50 46 81 18 05 20 48 60 88 60 51 46 48 68 01 21 01 40 11 43 50 46 41 60 0F 2A 00 D9 CF E0 00 9A E9 6A 8B 42 00 D9 EB 62 29 6B 8B 42 72 D9 2B 63 90 46 52 68 03 23 9A 43 13 1B 0F 2B 54 DC 30 1C ?? ?? ?? ?? 00 20 67 E6 14 2B 3A D9 54 2B 4F D8 23 0B 6E 33 98 46 D9 00 96 E6 01 20 2A 19 04 43 6C 60 0B E7 01 22 91 44 4B 46 52 46 13 42 74 D0 08 35 AC 46 E8 E6 F7 01 00 00 ?? ?? ?? ?? FF 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? FF 0F 00 00 00 F0 FF FF 2B 1C 08 33 DD 68 AB 42 00 D0 53 E6 02 32 90 46 90 E6 AA 18 51 68 01 23 0B 43 53 60 EB 68 AA 68 30 1C D3 60 9A 60 ?? ?? ?? ?? 28 1C 08 30 2A E6 5B 33 98 46 D9 00 5E E6 14 2B 3A D8 5B 33 9A 46 D8 00 EB E6 BA 45 00 D1 58 E7 BD 68 6A 68 03 23 A8 46 9A 43 A7 E7 94 42 00 D8 0E E7 A6 E7 AA 22 52 00 93 42 1D D8 E3 0B 77 33 98 46 D9 00 42 E6 08 22 D3 1A C0 18 00 90 80 20 40 01 1B 18 51 E7 BA 68 53 68 90 46 03 22 93 43 1A 1C 8B E7 50 46 82 10 01 20 90 40 02 1C 78 68 02 43 7A 60 1A 1C D4 E6 34 4A 93 42 27 D9 FC 21 7E 22 89 00 90 46 21 E6 54 2B 25 D8 13 0B 6E 33 9A 46 D8 00 AD E6 01 23 4B 60 00 22 6E E7 5B 46 45 46 00 E0 01 3D 52 46 15 42 41 D0 1A 1C 08 3A 93 68 93 42 F6 D0 7B 68 40 00 98 42 00 D9 BB E6 00 28 00 D1 B8 E6 18 42 36 D0 C8 46 58 E6 A3 0C 7C 33 98 46 D9 00 F9 E5 AA 20 40 00 83 42 1F D8 D3 0B 77 33 9A 46 D8 00 83 E6 11 05 00 D0 F6 E6 58 46 BA 68 48 44 01 21 01 43 51 60 32 E7 0A 1C 30 E7 51 46 08 31 30 1C ?? ?? ?? ?? 6B 68 BA 68 28 E7 00 21 01 20 88 46 02 E7 42 46 90 60 E6 E6 0A 48 83 42 0C D9 FC 20 7E 22 80 00 92 46 60 E6 7B 68 83 43 7B 60 BF E7 04 25 A9 44 40 00 C2 E7 93 0C 7C 33 9A 46 D8 00 53 E6 54 05 00 00 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "tdelete"
		size = 132
		refs = "0072 free"
	strings:
		$1 = { F0 B5 07 1C 16 1C 0C 1E 01 D1 00 20 F0 BD 25 68 00 2D FA D0 2B 1C 05 E0 2C 1C AB 68 08 34 00 2B F3 D0 23 68 19 68 38 1C 00 F0 2C F8 00 28 05 D0 25 68 00 28 F0 DA 2C 1D 6B 68 F0 E7 20 68 46 68 81 68 00 2E 1C D0 00 29 13 D0 4B 68 00 2B 15 D0 1E 1C 01 E0 1E 1C 11 1C 73 68 32 1C 00 2B F9 D1 B3 68 4B 60 23 68 5B 68 73 60 23 68 9B 68 B3 60 20 68 ?? ?? ?? ?? 26 60 28 1C C7 E7 4E 60 20 68 0E 1C F6 E7 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "iswspace"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { FF 28 06 D8 04 4B 1B 68 18 18 40 78 08 23 18 40 70 47 00 20 FC E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "__adjust"
		size = 132
		refs = "003a __exp10 0046 __muldf3 006e __divdf3"
	strings:
		$1 = { 30 B5 9A 24 64 00 A2 42 08 DD 22 22 02 60 00 2B 23 D1 19 4C 00 25 29 1C 20 1C 30 BD 17 4C A2 42 16 DB 0C 68 4D 68 00 2B 02 D0 80 23 1B 06 E4 18 00 2A F0 D0 00 2A 13 DB 10 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C E2 E7 22 23 03 60 00 24 00 25 DD E7 09 4C 00 25 DA E7 50 42 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C CE E7 00 00 F0 7F CC FE FF FF 00 00 F0 FF }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "_mblen_r"
		size = 28
	strings:
		$1 = { 00 29 02 D0 0B 78 00 2B 01 D1 00 20 70 47 00 2A 01 D0 01 20 FA E7 01 20 40 42 F7 E7 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "_fputs_r"
		size = 88
		refs = "000c strlen 0042 __sfvwrite_r 004c __sinit"
	strings:
		$1 = { 70 B5 85 B0 05 1C 08 1C 14 1C 03 91 ?? ?? ?? ?? 03 AB 00 93 01 23 02 90 04 90 01 93 00 2D 02 D0 AB 6B 00 2B 11 D0 80 23 A2 89 9B 01 1A 42 05 D1 13 43 A3 81 62 6E 07 4B 13 40 63 66 28 1C 6A 46 21 1C ?? ?? ?? ?? 05 B0 70 BD 28 1C ?? ?? ?? ?? E9 E7 C0 46 FF DF FF FF }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "_findenv_r"
		size = 144
		refs = "0010 __env_lock 0046 strncmp 0062 __env_unlock 008c environ"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 91 46 82 46 0E 1C ?? ?? ?? ?? 1D 4A 14 68 90 46 00 2C 20 D0 33 78 3D 2B 31 D0 00 2B 2F D0 35 1C 01 35 2B 78 3D 2B 16 D0 00 2B F9 D1 3D 2B 12 D0 20 68 00 28 0F D0 AD 1B 31 1C 2A 1C ?? ?? ?? ?? 00 28 04 D1 27 68 7F 19 3B 78 3D 2B 0C D0 04 34 20 68 00 28 F0 D1 50 46 ?? ?? ?? ?? 00 20 1C BC 90 46 99 46 A2 46 F0 BD 42 46 13 68 E4 1A A4 10 4B 46 50 46 1C 60 ?? ?? ?? ?? 78 1C EF E7 35 1C D4 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "__register_exitproc"
		size = 176
		refs = "007a malloc 00ac _global_impure_ptr"
	strings:
		$1 = { F0 B5 47 46 80 B4 1F 1C 28 4B 1B 68 98 46 A4 23 0D 1C 5B 00 41 46 04 1C C8 58 16 1C 00 28 24 D0 43 68 1F 2B 27 DC 00 2C 08 D1 9A 1C 92 00 01 33 15 50 43 60 00 20 04 BC 90 46 F0 BD 22 33 9B 00 C4 22 52 00 1E 50 43 68 86 58 01 21 99 40 0E 43 86 50 1A 1C 42 32 92 00 17 50 02 2C E5 D1 C6 22 52 00 84 58 21 43 81 50 DF E7 A6 22 52 00 10 1C 40 44 C8 50 D4 E7 C8 20 40 00 ?? ?? ?? ?? 00 28 10 D0 A4 23 5B 00 41 46 C9 58 01 60 41 46 C8 50 C4 23 00 22 5B 00 C2 50 C6 23 5B 00 C2 50 42 60 00 23 C0 E7 01 20 40 42 C5 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "argz_insert"
		size = 160
		refs = "0040 strlen 004c realloc 0066 memmove 0072 memcpy 0094 argz_add"
	strings:
		$1 = { F0 B5 47 46 80 B4 04 1C 0D 1C 1F 1C 00 2A 40 D0 00 68 82 42 34 D3 0B 68 C3 18 9A 42 30 D2 82 42 0B D0 53 1E 19 78 00 29 05 D1 36 E0 5A 1E 11 78 00 29 29 D0 13 1C 98 42 F8 D1 00 20 80 46 38 1C ?? ?? ?? ?? 29 68 46 1C 71 18 20 68 ?? ?? ?? ?? 20 60 00 28 1B D0 42 46 81 18 93 19 2A 68 C3 18 40 46 12 1A 18 1C ?? ?? ?? ?? 20 68 32 1C 40 44 39 1C ?? ?? ?? ?? 2B 68 9E 19 2E 60 00 20 00 E0 16 20 04 BC 90 46 F0 BD 18 1A 80 46 D7 E7 0C 20 F7 E7 1A 1C ?? ?? ?? ?? F3 E7 12 1A 90 46 CE E7 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "ctime_r"
		size = 22
		refs = "0008 localtime_r 000e asctime_r"
	strings:
		$1 = { 10 B5 89 B0 0C 1C 69 46 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 09 B0 10 BD }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "btowc"
		size = 64
		refs = "0014 memset 0024 _mbtowc_r 003c _impure_ptr"
	strings:
		$1 = { 70 B5 85 B0 6C 46 13 34 01 AD 20 70 00 21 08 22 06 1C 28 1C ?? ?? ?? ?? 08 4B 03 A9 18 68 22 1C 01 23 00 95 ?? ?? ?? ?? 01 28 03 D0 01 20 40 42 05 B0 70 BD 01 36 F9 D0 03 98 F9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "argz_stringify"
		size = 30
	strings:
		$1 = { 10 B5 01 29 0A D9 01 39 00 29 07 D0 00 23 C4 5C 00 2C 00 D1 C2 54 01 33 8B 42 F8 D3 10 BD }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "strerror"
		size = 744
		refs = "0006 _user_strerror"
	strings:
		$1 = { 00 B5 8E 28 05 D9 ?? ?? ?? ?? 00 28 00 D1 B4 E0 00 BD 5B 4A 83 00 D3 58 9F 46 5A 48 F8 E7 5A 48 F6 E7 5A 48 F4 E7 5A 48 F2 E7 5A 48 F0 E7 5A 48 EE E7 5A 48 EC E7 5A 48 EA E7 5A 48 E8 E7 5A 48 E6 E7 5A 48 E4 E7 5A 48 E2 E7 5A 48 E0 E7 5A 48 DE E7 5A 48 DC E7 5A 48 DA E7 5A 48 D8 E7 5A 48 D6 E7 5A 48 D4 E7 5A 48 D2 E7 5A 48 D0 E7 5A 48 CE E7 5A 48 CC E7 5A 48 CA E7 5A 48 C8 E7 5A 48 C6 E7 5A 48 C4 E7 5A 48 C2 E7 5A 48 C0 E7 5A 48 BE E7 5A 48 BC E7 5A 48 BA E7 5A 48 B8 E7 5A 48 B6 E7 5A 48 B4 E7 5A 48 B2 E7 5A 48 B0 E7 5A 48 AE E7 5A 48 AC E7 5A 48 AA E7 5A 48 A8 E7 5A 48 A6 E7 5A 48 A4 E7 5A 48 A2 E7 5A 48 A0 E7 5A 48 9E E7 5A 48 9C E7 5A 48 9A E7 5A 48 98 E7 5A 48 96 E7 5A 48 94 E7 5A 48 92 E7 5A 48 90 E7 5A 48 8E E7 5A 48 8C E7 5A 48 8A E7 5A 48 88 E7 5A 48 86 E7 5A 48 84 E7 5A 48 82 E7 5A 48 80 E7 5A 48 7E E7 5A 48 7C E7 5A 48 7A E7 5A 48 78 E7 5A 48 76 E7 5A 48 74 E7 5A 48 72 E7 5A 48 70 E7 5A 48 6E E7 5A 48 6C E7 5A 48 6A E7 5A 48 68 E7 5A 48 66 E7 5A 48 64 E7 5A 48 62 E7 5A 48 60 E7 5A 48 5E E7 5A 48 5C E7 5A 48 5A E7 5A 48 58 E7 5A 48 56 E7 5A 48 54 E7 5A 48 52 E7 5A 48 50 E7 5A 48 4E E7 5A 48 4C E7 5A 48 4A E7 5A 48 48 E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "_tmpfile_r"
		size = 128
		refs = "0012 _tmpnam_r 0026 _open_r 004c _fdopen_r 005e _remove_r 006c _close_r"
	strings:
		$1 = { F0 B5 47 46 80 B4 1B 4C A5 44 6F 46 04 1C 20 1C 39 1C ?? ?? ?? ?? 05 1C 00 28 0C D0 C0 23 20 1C 29 1C 15 4A 5B 00 ?? ?? ?? ?? 06 1C 00 28 0A DA 23 68 11 2B EB D0 00 27 80 23 DB 00 9D 44 38 1C 04 BC 90 46 F0 BD 20 1C 31 1C 0C 4A ?? ?? ?? ?? 23 68 07 1C 98 46 00 28 06 D0 20 1C 29 1C ?? ?? ?? ?? 43 46 23 60 E7 E7 20 1C 31 1C ?? ?? ?? ?? F3 E7 C0 46 00 FC FF FF 02 0A 01 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "asctime"
		size = 20
		refs = "0008 asctime_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 19 68 60 31 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "_strtol_r"
		size = 364
		refs = "0056 __umodsi3 0060 __udivsi3 0164 __ctype_ptr__"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 1F 1C 55 4B 85 B0 04 90 01 91 1E 68 03 92 0C 1C 08 22 25 78 73 19 5B 78 01 34 13 42 F9 D1 2D 2D 00 D1 75 E0 2B 2D 00 D1 7F E0 00 22 02 92 7B 42 7B 41 10 2F 54 D0 00 2B 52 D1 BA 46 02 9B 00 2B 5A D1 46 49 89 46 48 46 51 46 ?? ?? ?? ?? 51 46 80 46 48 46 ?? ?? ?? ?? 04 22 94 46 03 22 91 46 01 22 00 23 00 21 93 46 00 97 12 E0 00 9A 30 3D AA 42 1E DD 81 42 43 D8 00 2B 41 DB 45 45 01 DD 81 42 3D D0 0B 1C 51 46 59 43 01 23 69 18 25 78 01 34 72 19 52 78 67 46 3A 42 E7 D1 4F 46 3A 42 07 D0 5F 46 3A 42 2E D1 57 22 AD 1A 00 9A AA 42 E0 DC 5F 1C 31 D0 02 9A 00 2A 27 D1 08 1C 03 9F 00 2F 06 D0 00 2B 01 D0 01 3C 01 94 01 99 03 9A 11 60 05 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 30 2D 27 D0 00 2B A8 D0 30 2D 30 D0 02 9B 0A 21 8A 46 0A 27 00 2B A4 D0 80 22 13 06 99 46 A2 E7 01 23 5B 42 C3 E7 37 22 AD 1A CF E7 48 42 D6 E7 01 21 25 78 01 34 02 91 89 E7 02 99 00 29 13 D1 0E 48 04 9F 22 22 3A 60 C9 E7 00 23 25 78 01 34 02 93 7C E7 22 78 58 2A 01 D0 78 2A D2 D1 10 27 65 78 BA 46 02 34 79 E7 80 20 00 06 E9 E7 08 22 92 46 08 27 72 E7 C0 46 ?? ?? ?? ?? FF FF FF 7F }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "error"
		size = 28
		refs = "0004 __errno"
	strings:
		$1 = { F0 B5 07 1C ?? ?? ?? ?? 00 26 04 1C 13 25 28 1C 31 1C AB DF 05 1C 38 1C 25 60 F0 BD }
	condition:
		$1
}

rule file_86_1_0 {
	meta:
		name = "remap_handle"
		size = 68
		refs = "002a __sinit 003c _impure_ptr"
	strings:
		$1 = { 10 B5 0E 4B 04 1C 18 68 00 28 02 D0 83 6B 00 2B 0B D0 00 2C 06 D0 01 2C 0A D0 02 2C 0B D0 20 1C 20 38 10 BD 06 4B 18 68 FB E7 ?? ?? ?? ?? F0 E7 03 4B 98 68 F5 E7 02 4B 58 68 F2 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_2_0 {
	meta:
		name = "initialise_monitor_handles"
		size = 116
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 18 4B 83 B0 00 93 98 46 03 23 02 93 9A 46 00 23 01 93 6D 46 01 26 30 1C 29 1C AB DF 07 1C 43 46 00 93 11 4C 53 46 02 93 04 23 27 60 01 93 30 1C 29 1C AB DF 05 1C 01 22 23 1C 21 1C 65 60 A5 60 0C 33 AC 31 52 42 1A 60 08 33 8B 42 FB D1 23 68 03 B0 E3 60 00 23 65 61 23 61 A3 61 0C BC 90 46 9A 46 F0 BD ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_3_0 {
	meta:
		name = "_kill"
		size = 44
	strings:
		$1 = { 30 B5 06 29 07 D0 07 4D 18 24 20 1C 29 1C AB DF 04 1C 20 1C 30 BD 04 4D 18 24 20 1C 29 1C AB DF 04 1C F6 E7 26 00 02 00 23 00 02 00 }
	condition:
		$1
}

rule file_86_4_0 {
	meta:
		name = "_exit"
		size = 20
	strings:
		$1 = { 30 B5 03 4D 18 24 20 1C 29 1C AB DF 04 1C 30 BD 26 00 02 00 }
	condition:
		$1
}

rule file_86_8_0 {
	meta:
		name = "_gettimeofday"
		size = 40
	strings:
		$1 = { F0 B5 05 1C 0C 1C 00 28 07 D0 00 27 11 26 30 1C 39 1C AB DF 06 1C 2E 60 6F 60 00 2C 02 D0 00 23 23 60 63 60 00 20 F0 BD }
	condition:
		$1
}

rule file_86_9_0 {
	meta:
		name = "_times"
		size = 32
	strings:
		$1 = { 70 B5 04 1C 00 25 10 26 30 1C 29 1C AB DF 06 1C 00 2C 03 D0 26 60 65 60 A5 60 E5 60 30 1C 70 BD }
	condition:
		$1
}

rule file_86_10_0 {
	meta:
		name = "_rename"
		size = 66
		refs = "000a strlen"
	strings:
		$1 = { 30 B5 84 B0 0D 1C 6C 46 00 90 ?? ?? ?? ?? 01 90 28 1C 02 95 ?? ?? ?? ?? 0F 25 03 90 28 1C 21 1C AB DF 04 1C 63 1C 07 D0 00 2C 02 D1 00 20 04 B0 30 BD 01 20 40 42 FA E7 20 1C FF F7 D3 FF 04 1C F2 E7 }
	condition:
		$1
}

rule file_86_11_0 {
	meta:
		name = "_system"
		size = 80
		refs = "000a strlen"
	strings:
		$1 = { 30 B5 82 B0 00 28 1C D0 00 90 ?? ?? ?? ?? 12 24 01 90 6D 46 20 1C 29 1C AB DF 04 1C 63 1C 12 D0 FF 2C 0B D8 00 2C 09 D0 20 1C FF 22 40 00 00 28 05 D0 03 12 13 40 A3 42 F8 D1 00 E0 20 1C 02 B0 30 BD 01 20 FB E7 20 1C FF F7 AA FF 04 1C E7 E7 }
	condition:
		$1
}

rule file_86_12_0 {
	meta:
		name = "_unlink"
		size = 54
		refs = "0006 strlen"
	strings:
		$1 = { 30 B5 82 B0 00 90 ?? ?? ?? ?? 0E 24 01 90 6D 46 20 1C 29 1C AB DF 04 1C 63 1C 07 D0 00 2C 02 D1 00 20 02 B0 30 BD 01 20 40 42 FA E7 20 1C FF F7 8F FF 04 1C F2 E7 }
	condition:
		$1
}

rule file_86_13_0 {
	meta:
		name = "_swiopen"
		size = 136
		refs = "004e strlen"
	strings:
		$1 = { F0 B5 20 4F 3B 1C 83 B0 0C 33 00 24 1A 68 01 32 07 D0 01 34 08 33 14 2C F8 D1 01 20 40 42 03 B0 F0 BD CD 03 02 23 ED 0F 19 42 00 D0 1D 43 8B 05 01 D5 04 23 1D 43 4B 05 01 D5 04 23 1D 43 08 23 19 42 02 D0 04 22 95 43 1D 43 6E 46 00 90 ?? ?? ?? ?? 01 95 02 90 01 25 28 1C 31 1C AB DF 06 1C 00 2E 0A DB E3 00 E4 00 FB 18 04 34 DE 60 3F 19 00 23 30 1C FB 60 20 30 D1 E7 30 1C FF F7 4C FF CD E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_14_0 {
	meta:
		name = "_open"
		size = 26
		refs = "0006 _swiopen"
	strings:
		$1 = { 0E B4 00 B5 01 99 ?? ?? ?? ?? 43 1C 02 D0 08 BC 03 B0 18 47 FF F7 3C FF F9 E7 }
	condition:
		$1
}

rule file_86_15_0 {
	meta:
		name = "_sbrk"
		size = 52
		refs = "0018 __errno 0030 end"
	strings:
		$1 = { 00 B5 0A 4A D3 6A 00 2B 0D D0 18 18 69 46 88 42 02 D8 D0 62 18 1C 00 BD ?? ?? ?? ?? 0C 23 03 60 01 23 5B 42 F6 E7 02 4B D3 62 EE E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_16_0 {
	meta:
		name = "_isatty"
		size = 42
	strings:
		$1 = { 30 B5 81 B0 FF F7 DA FF 09 24 00 90 6D 46 20 1C 29 1C AB DF 04 1C 63 1C 02 D0 01 B0 20 1C 30 BD 20 1C FF F7 EB FE 04 1C F7 E7 }
	condition:
		$1
}

rule file_86_17_0 {
	meta:
		name = "_swiclose"
		size = 68
	strings:
		$1 = { 30 B5 81 B0 FF F7 C4 FF 0D 4C 23 1C 0C 33 00 22 19 68 88 42 0D D0 01 32 08 33 14 2A F8 D1 00 90 6D 46 02 24 20 1C 29 1C AB DF 04 1C 01 B0 20 1C 30 BD D2 00 01 23 A4 18 5B 42 E3 60 EF E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_19_0 {
	meta:
		name = "_swiwrite"
		size = 36
	strings:
		$1 = { 70 B5 83 B0 15 1C 0E 1C FF F7 96 FF 02 95 00 90 01 96 6C 46 05 25 28 1C 21 1C AB DF 04 1C 03 B0 20 1C 70 BD }
	condition:
		$1
}

rule file_86_20_0 {
	meta:
		name = "_write"
		size = 96
		refs = "002c _swiwrite"
	strings:
		$1 = { F0 B5 47 46 80 B4 06 1C 88 46 15 1C FF F7 82 FF 12 4F 3B 1C 0C 33 00 24 1A 68 90 42 03 D0 01 34 08 33 14 2C F8 D1 30 1C 41 46 2A 1C ?? ?? ?? ?? 85 42 0E D0 43 1C 0C D0 14 2C 06 D0 E4 00 04 34 3F 19 FB 68 EB 18 1B 1A FB 60 28 1A 04 BC 90 46 F0 BD 01 20 40 42 FF F7 7D FE F7 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_21_0 {
	meta:
		name = "_swilseek"
		size = 144
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 82 B0 80 46 0D 1C 16 1C FF F7 50 FF 1D 4B 00 24 9A 46 0C 33 1A 68 90 42 03 D0 01 34 08 33 14 2C F8 D1 01 2E 25 D0 02 2E 1A D0 6F 46 40 46 FF F7 3D FF 0A 26 00 90 01 95 30 1C 39 1C AB DF 06 1C 00 2E 07 D0 01 25 6D 42 02 B0 28 1C 0C BC 90 46 9A 46 F0 BD 14 2C F7 D0 E4 00 54 44 25 61 F3 E7 00 90 6F 46 0C 26 30 1C 39 1C AB DF 06 1C AD 19 DC E7 14 2C E6 D0 E3 00 53 44 1B 69 6F 46 ED 18 D4 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_23_0 {
	meta:
		name = "_swiread"
		size = 36
	strings:
		$1 = { 70 B5 83 B0 15 1C 0E 1C FF F7 02 FF 02 95 00 90 01 96 6C 46 06 25 28 1C 21 1C AB DF 04 1C 03 B0 20 1C 70 BD }
	condition:
		$1
}

rule file_86_24_0 {
	meta:
		name = "_read"
		size = 92
		refs = "002c _swiread"
	strings:
		$1 = { F0 B5 47 46 80 B4 06 1C 88 46 15 1C FF F7 EE FE 11 4F 3B 1C 0C 33 00 24 1A 68 90 42 03 D0 01 34 08 33 14 2C F8 D1 30 1C 41 46 2A 1C ?? ?? ?? ?? 00 28 0C DB 14 2C 06 D0 E4 00 04 34 3F 19 FB 68 EB 18 1B 1A FB 60 28 1A 04 BC 90 46 F0 BD 01 20 40 42 FF F7 EB FD F7 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_25_0 {
	meta:
		name = "_stat"
		size = 54
		refs = "0006 _open 0016 memset 0028 _swiclose"
	strings:
		$1 = { 30 B5 0C 1C 00 21 ?? ?? ?? ?? 05 1C 00 28 0F DB 20 1C 00 21 3C 22 ?? ?? ?? ?? 81 23 1B 02 63 60 80 23 DB 00 E3 62 28 1C ?? ?? ?? ?? 00 20 30 BD 01 20 40 42 FB E7 }
	condition:
		$1
}

rule file_86_26_0 {
	meta:
		name = "_fstat"
		size = 30
		refs = "000a memset"
	strings:
		$1 = { 10 B5 0C 1C 08 1C 3C 22 00 21 ?? ?? ?? ?? 80 23 9B 01 63 60 80 23 DB 00 00 20 E3 62 10 BD }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "strlcpy"
		size = 64
	strings:
		$1 = { 10 B5 00 2A 07 D1 0B 1C 1A 78 01 33 00 2A FB D1 C9 43 58 18 10 BD 01 3A 00 2A 0D D0 0B 1C 02 E0 01 3A 00 2A 09 D0 1C 78 01 33 04 70 01 30 00 2C F6 D1 00 2A EC D1 00 E0 0B 1C 00 22 02 70 E3 E7 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "wcslcpy"
		size = 60
	strings:
		$1 = { 10 B5 00 2A 07 D1 0B 1C 04 CB 00 2A FC D1 58 1A 80 10 01 38 10 BD 01 3A 00 2A 0B D0 0B 1C 02 E0 01 3A 00 2A 07 D0 10 CB 10 C0 00 2C F8 D1 00 2A ED D1 00 E0 0B 1C 00 22 02 60 E5 E7 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "clearerr"
		size = 36
		refs = "0012 __sinit 0020 _impure_ptr"
	strings:
		$1 = { 10 B5 07 4B 04 1C 18 68 00 28 04 D0 83 6B 00 2B 01 D1 ?? ?? ?? ?? A3 89 60 22 93 43 A3 81 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "wcsstr"
		size = 88
		refs = "0010 wcslen"
	strings:
		$1 = { 70 B5 0B 68 04 1C 0D 1C 00 2B 01 D1 20 1C 70 BD ?? ?? ?? ?? 06 1C 28 1C ?? ?? ?? ?? 86 42 01 D2 00 24 F3 E7 23 68 00 2B FA D0 2E 68 00 2E ED D0 22 1C 13 68 9E 42 08 D1 2B 1C 04 33 19 68 00 29 E4 D0 04 32 10 68 81 42 F7 D0 04 34 23 68 22 1C 00 2B EE D1 00 24 D9 E7 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "__assert_func"
		size = 60
		refs = "001e fiprintf 0022 abort 002c _impure_ptr"
	strings:
		$1 = { 30 B5 04 1C 09 48 00 68 83 B0 C0 68 00 2A 0A D0 07 4D 00 91 02 92 07 49 1A 1C 23 1C 01 95 ?? ?? ?? ?? ?? ?? ?? ?? 04 4D 2A 1C F2 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "sprintf"
		size = 68
		refs = "0028 _svfprintf_r 0040 _impure_ptr"
	strings:
		$1 = { 0E B4 10 B5 9B B0 00 90 04 90 0C 48 02 90 05 90 01 20 69 46 40 42 1D AB C8 81 82 24 08 48 04 CB A4 00 8C 81 00 68 1A 93 ?? ?? ?? ?? 00 9B 00 22 1B B0 1A 70 10 BC 08 BC 03 B0 18 47 FF FF FF 7F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_465_0_0 {
	meta:
		name = "siprintf"
		size = 68
		refs = "0028 _svfiprintf_r 0040 _impure_ptr"
	strings:
		$1 = { 0E B4 10 B5 9B B0 00 90 04 90 0C 48 02 90 05 90 01 20 69 46 40 42 1D AB C8 81 82 24 08 48 04 CB A4 00 8C 81 00 68 1A 93 ?? ?? ?? ?? 00 9B 00 22 1B B0 1A 70 10 BC 08 BC 03 B0 18 47 FF FF FF 7F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "_sprintf_r"
		size = 64
		refs = "0026 _svfprintf_r"
	strings:
		$1 = { 0C B4 30 B5 9B B0 82 24 0D 1C A4 00 69 46 8C 81 0A 4C 1E AB 02 94 05 94 01 24 04 CB 64 42 CC 81 00 95 04 95 1A 93 ?? ?? ?? ?? 00 9B 00 22 1B B0 1A 70 30 BC 08 BC 02 B0 18 47 C0 46 FF FF FF 7F }
	condition:
		$1
}

rule file_465_1_0 {
	meta:
		name = "_siprintf_r"
		size = 64
		refs = "0026 _svfiprintf_r"
	strings:
		$1 = { 0C B4 30 B5 9B B0 82 24 0D 1C A4 00 69 46 8C 81 0A 4C 1E AB 02 94 05 94 01 24 04 CB 64 42 CC 81 00 95 04 95 1A 93 ?? ?? ?? ?? 00 9B 00 22 1B B0 1A 70 30 BC 08 BC 02 B0 18 47 C0 46 FF FF FF 7F }
	condition:
		$1
}

rule file_94_0_0 {
	meta:
		name = "_toupper"
		size = 20
		refs = "0010 __ctype_ptr__"
		altNames = "toupper"
	strings:
		$1 = { 03 4B 1B 68 1B 18 5B 78 9A 07 00 D5 20 38 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "modf"
		size = 156
		refs = "0078 __subdf3"
	strings:
		$1 = { F0 B5 47 46 80 B4 47 00 7F 0D B8 46 20 4F 3B 1C 43 44 82 B0 06 1C 13 2B 15 DC 00 2B 2F DB 1D 4C 27 1C 1F 41 07 42 1D D1 00 29 1B D1 10 60 51 60 80 22 12 06 13 1C 03 40 00 24 18 1C 21 1C 02 B0 04 BC 90 46 F0 BD 33 2B F0 DC 13 4E 01 23 37 1C 47 44 5B 42 FB 40 0B 42 E8 D0 0F 1C 9F 43 00 90 01 97 03 E0 BE 43 00 24 00 96 01 94 00 9B 01 9C 13 60 54 60 1A 1C 23 1C ?? ?? ?? ?? DF E7 80 27 3F 06 03 1C 3B 40 00 24 13 60 54 60 D7 E7 C0 46 01 FC FF FF FF FF 0F 00 ED FB FF FF }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "nan"
		size = 16
	strings:
		$1 = { 02 49 01 48 70 47 C0 46 00 00 F8 7F 00 00 00 00 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "__submore"
		size = 120
		refs = "001a _realloc_r 002c memcpy 004c _malloc_r"
	strings:
		$1 = { F0 B5 47 46 80 B4 0C 1C 23 1C 09 6B 40 33 99 42 19 D0 67 6B 7B 00 1A 1C 98 46 ?? ?? ?? ?? 05 1C 00 28 0D D0 C6 19 30 1C 29 1C 3A 1C ?? ?? ?? ?? 43 46 26 60 25 63 63 63 00 20 04 BC 90 46 F0 BD 01 20 40 42 F9 E7 80 25 ED 00 29 1C ?? ?? ?? ?? 00 28 F5 D0 07 4B 20 63 65 63 C0 18 42 23 E3 5C 83 70 41 23 E3 5C 43 70 40 23 E3 5C 03 70 20 60 00 20 E2 E7 FD 03 00 00 }
	condition:
		$1
}

rule file_98_1_0 {
	meta:
		name = "_ungetc_r"
		size = 260
		refs = "0064 __sinit 00ca __submore 00e0 _fflush_r"
	strings:
		$1 = { F0 B5 0D 1C 06 1C 14 1C 69 1C 21 D0 00 28 02 D0 83 6B 00 2B 26 D0 A3 89 80 22 92 01 19 04 13 42 18 D0 35 4A 0B 0C 13 40 A3 81 59 07 43 D5 23 6B 2D 06 2F 0E 00 2B 1E D0 62 68 63 6B 9A 42 42 DA 23 68 01 3B 23 60 1F 70 63 68 01 33 63 60 3D 1C 28 1C F0 BD 13 43 61 6E 28 4A 0A 40 A3 81 62 66 19 04 DE E7 ?? ?? ?? ?? A3 89 80 22 92 01 19 04 13 42 D6 D1 EE E7 22 69 00 2A 2D D0 23 68 9A 42 03 D2 5A 1E 15 78 BD 42 10 D0 A3 63 23 1C 40 33 23 63 03 23 63 63 42 23 E7 54 23 1C 62 68 42 33 23 60 01 23 E2 63 63 60 3D 1C D1 E7 63 68 01 33 22 60 63 60 CC E7 D9 06 0B D5 19 07 0E D4 04 22 13 43 A3 81 B3 E7 30 1C 21 1C ?? ?? ?? ?? 00 28 B6 D0 01 25 6D 42 BB E7 23 68 D6 E7 30 1C 21 1C ?? ?? ?? ?? 00 28 F4 D1 A2 89 05 4B 13 40 A3 81 A0 60 A0 61 E3 E7 C0 46 DF FF 00 00 FF DF FF FF F7 FF 00 00 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "time"
		size = 48
		refs = "000e _gettimeofday_r 002c _impure_ptr"
	strings:
		$1 = { 10 B5 0A 4B 82 B0 04 1C 69 46 18 68 00 22 ?? ?? ?? ?? 00 28 05 DB 00 2C 06 D0 00 98 20 60 02 B0 10 BD 01 20 40 42 FA E7 00 98 F8 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "isgraph"
		size = 20
		refs = "0010 __ctype_ptr__"
	strings:
		$1 = { 03 4B 1B 68 18 18 40 78 17 23 18 40 70 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_102_1_0 {
	meta:
		name = "isprint"
		size = 20
		refs = "0010 __ctype_ptr__"
	strings:
		$1 = { 03 4B 1B 68 18 18 40 78 97 23 18 40 70 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "getc_unlocked"
		size = 40
		refs = "001c __srget_r 0024 _impure_ptr"
	strings:
		$1 = { 00 B5 43 68 01 3B 01 1C 43 60 00 2B 04 DB 03 68 18 78 01 33 0B 60 00 BD 02 4B 18 68 ?? ?? ?? ?? F9 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_103_1_0 {
	meta:
		name = "_getc_unlocked_r"
		size = 28
		refs = "0016 __srget_r"
	strings:
		$1 = { 00 B5 4B 68 01 3B 4B 60 00 2B 04 DB 0B 68 18 78 01 33 0B 60 00 BD ?? ?? ?? ?? FB E7 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "_raise_r"
		size = 88
		refs = "003e _getpid_r 0048 _kill_r"
	strings:
		$1 = { 30 B5 05 1C 0C 1C 1F 29 21 D8 B7 23 9B 00 C3 58 00 2B 13 D0 8A 00 9A 18 13 68 00 2B 0E D0 01 2B 06 D0 59 1C 06 D0 00 21 11 60 20 1C 00 F0 9E F8 00 20 30 BD 16 23 03 60 01 20 FA E7 28 1C ?? ?? ?? ?? 22 1C 01 1C 28 1C ?? ?? ?? ?? F1 E7 16 23 03 60 01 20 40 42 EC E7 }
	condition:
		$1
}

rule file_104_2_0 {
	meta:
		name = "_init_signal_r"
		size = 50
		refs = "0014 _malloc_r"
	strings:
		$1 = { 30 B5 B7 24 A4 00 03 59 05 1C 00 2B 01 D0 00 20 30 BD 80 21 ?? ?? ?? ?? 28 51 00 28 06 D0 02 1C 80 32 00 23 08 C0 90 42 FC D1 F0 E7 01 20 40 42 EE E7 }
	condition:
		$1
}

rule file_104_4_0 {
	meta:
		name = "__sigtramp_r"
		size = 82
		refs = "0046 _init_signal_r"
	strings:
		$1 = { 70 B5 06 1C 0C 1C 1F 29 14 D8 B7 25 AD 00 43 59 00 2B 18 D0 A2 00 9A 18 13 68 00 2B 0F D0 59 1C 0F D0 01 2B 09 D0 00 21 20 1C 11 60 00 F0 46 F8 00 20 70 BD 01 20 40 42 FB E7 03 20 F9 E7 01 20 F7 E7 02 20 F5 E7 ?? ?? ?? ?? 00 28 F2 D1 73 59 E0 E7 }
	condition:
		$1
}

rule file_104_6_0 {
	meta:
		name = "_signal_r"
		size = 60
		refs = "002a _init_signal_r"
	strings:
		$1 = { F0 B5 05 1C 0C 1C 16 1C 1F 29 09 D8 B7 27 BF 00 C3 59 00 2B 09 D0 A4 00 1B 19 18 68 1E 60 F0 BD 16 23 03 60 01 20 40 42 F9 E7 ?? ?? ?? ?? 00 28 01 D1 EB 59 EF E7 01 20 40 42 F0 E7 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "_rewind_r"
		size = 22
		refs = "0008 _fseek_r"
	strings:
		$1 = { 10 B5 0C 1C 00 22 00 23 ?? ?? ?? ?? A3 89 60 22 93 43 A3 81 10 BD }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "wcscspn"
		size = 54
	strings:
		$1 = { 70 B5 04 68 00 2C 14 D0 0E 68 05 1C 00 2E 09 D0 B4 42 0B D0 0B 1C 01 E0 94 42 07 D0 04 33 1A 68 00 2A F9 D1 04 35 2C 68 00 2C EF D1 28 1A 80 10 70 BD 00 20 FC E7 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "_mrand48_r"
		size = 26
		refs = "0008 __dorand48"
	strings:
		$1 = { 10 B5 01 1C AC 31 04 1C ?? ?? ?? ?? B0 23 E0 5A AE 23 E3 5A 00 04 C0 18 10 BD }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "argz_replace"
		size = 308
		refs = "001a strlen 004e _buf_findstr 0080 malloc 00c0 memcpy 00ca realloc 00ea free"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 86 B0 80 46 10 1C 89 46 14 1C 02 93 0F 9F ?? ?? ?? ?? 00 90 02 98 ?? ?? ?? ?? 00 9A 81 1A 8B 46 41 46 0B 68 4A 46 05 93 13 68 00 22 01 90 04 93 3A 60 9A 46 05 AE 04 AD 00 2B 09 D0 20 1C 31 1C 2A 1C ?? ?? ?? ?? 00 28 0D D1 04 9B 00 2B F5 D1 3B 68 00 2B 0D D1 00 20 06 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 3B 68 01 33 3B 60 DA 44 04 9B EC E7 50 46 ?? ?? ?? ?? 43 46 49 46 1E 68 0B 68 03 90 05 96 04 93 83 46 05 AD 04 AF 00 2B 09 D0 20 1C 29 1C 3A 1C ?? ?? ?? ?? 00 28 22 D1 04 9B 00 2B F5 D1 43 46 49 46 1A 68 0B 68 D2 18 92 1B 31 1C 58 46 ?? ?? ?? ?? 42 46 10 68 51 46 ?? ?? ?? ?? 43 46 18 60 00 28 2C D0 03 99 52 46 ?? ?? ?? ?? 51 46 4A 46 11 60 00 29 1B D0 03 98 ?? ?? ?? ?? B8 E7 05 9A 00 9B 92 1B D2 1A 31 1C 58 46 ?? ?? ?? ?? 05 9B 00 99 9E 1B 76 1A 5E 44 30 1C 01 9A 02 99 ?? ?? ?? ?? 01 9A 92 19 93 46 05 9E 04 9B C5 E7 43 46 18 68 ?? ?? ?? ?? 51 46 42 46 11 60 DB E7 0C 20 97 E7 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "setjmp"
		size = 24
	strings:
		$1 = { 78 47 C0 46 F0 7F A0 E8 00 00 A0 E3 01 00 1E E3 0E F0 A0 01 1E FF 2F E1 }
	condition:
		$1
}

rule file_109_1_0 {
	meta:
		name = "longjmp"
		size = 28
	strings:
		$1 = { 78 47 C0 46 F0 7F B0 E8 01 00 B0 E1 01 00 A0 03 01 00 1E E3 0E F0 A0 01 1E FF 2F E1 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "hsearch_r"
		size = 140
		refs = "0012 strlen 0040 strcmp 0066 malloc 0088 __default_hash"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 07 9C 05 1C 8A 46 90 46 1F 1C ?? ?? ?? ?? 1C 4B 01 1C 1B 68 28 1C 00 F0 7B F8 66 68 01 3E 23 68 06 40 B6 00 9E 19 34 68 00 2C 03 D1 0F E0 24 68 00 2C 0C D0 60 68 29 1C ?? ?? ?? ?? 00 28 F6 D1 04 34 3C 60 01 20 0C BC 90 46 9A 46 F0 BD 43 46 00 2B 03 D1 43 46 3B 60 00 20 F4 E7 0C 20 ?? ?? ?? ?? 00 28 09 D0 53 46 83 60 33 68 45 60 03 60 30 60 04 30 38 60 01 20 E5 E7 38 60 E3 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_112_1_0 {
	meta:
		name = "hdestroy_r"
		size = 20
		refs = "000a free"
	strings:
		$1 = { 10 B5 04 1C 00 68 00 28 03 D0 ?? ?? ?? ?? 00 23 23 60 10 BD }
	condition:
		$1
}

rule file_112_2_0 {
	meta:
		name = "hcreate_r"
		size = 120
		refs = "000a __errno 0022 malloc"
	strings:
		$1 = { 10 B5 0B 68 0C 1C 00 2B 05 D0 ?? ?? ?? ?? 16 23 03 60 00 20 10 BD 0F 28 14 D8 40 23 10 20 60 60 18 1C ?? ?? ?? ?? 20 60 00 28 13 D0 61 68 00 29 06 D0 00 23 00 24 9A 00 01 33 84 50 8B 42 FA D3 01 20 E7 E7 80 22 D2 04 90 42 09 D9 80 23 5B 05 10 1C E4 E7 ?? ?? ?? ?? 0C 23 03 60 00 20 D9 E7 43 1E 03 42 06 D0 00 23 40 08 01 33 00 28 FB D1 01 20 98 40 83 00 D2 E7 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "strcspn"
		size = 52
	strings:
		$1 = { 70 B5 04 78 00 2C 13 D0 0E 78 05 1C 00 2E 09 D0 B4 42 0B D0 0B 1C 01 E0 94 42 07 D0 01 33 1A 78 00 2A F9 D1 01 35 2C 78 00 2C EF D1 28 1A 70 BD 00 20 FC E7 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "_wcstombs_r"
		size = 180
		refs = "0030 _wctomb_r"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 82 B0 16 1C 0B 9A 80 46 89 46 9B 46 92 46 00 29 39 D0 00 2B 46 D0 1F 1C 32 68 53 46 40 46 69 46 4C 46 6D 46 ?? ?? ?? ?? 43 1C 1B D0 01 1C B8 42 00 D9 39 1C 00 29 06 DD 00 23 EA 5C E2 54 01 33 99 42 FA D1 64 18 33 68 00 2B 14 D0 7F 1A 00 2F 17 D0 04 36 53 46 32 68 40 46 69 46 ?? ?? ?? ?? 43 1C E3 D1 04 1C 02 B0 20 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 4A 46 A4 1A 87 42 5B 41 E4 1A F1 E7 5C 46 EF E7 32 68 00 2A 0B D0 00 24 40 46 69 46 53 46 ?? ?? ?? ?? 04 36 32 68 24 18 00 2A F5 D1 E0 E7 00 24 DE E7 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "putc"
		size = 96
		refs = "0044 __swbuf_r 004a __sinit 005c _impure_ptr"
	strings:
		$1 = { 70 B5 16 4D 06 1C 28 68 0C 1C 00 28 02 D0 83 6B 00 2B 1A D0 A3 68 01 3B A3 60 00 2B 06 DB 23 68 1E 70 23 68 18 78 01 33 23 60 70 BD A2 69 93 42 0E DB 23 68 1E 70 23 68 18 78 0A 28 F3 D1 28 68 0A 21 22 1C ?? ?? ?? ?? EF E7 ?? ?? ?? ?? E1 E7 28 68 31 1C 22 1C ?? ?? ?? ?? E6 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_118_1_0 {
	meta:
		name = "_putc_r"
		size = 90
		refs = "0042 __swbuf_r 0048 __sinit"
	strings:
		$1 = { 70 B5 05 1C 0E 1C 14 1C 00 28 02 D0 83 6B 00 2B 1A D0 A3 68 01 3B A3 60 00 2B 06 DB 23 68 1E 70 23 68 18 78 01 33 23 60 70 BD A2 69 93 42 0E DB 23 68 1E 70 23 68 18 78 0A 28 F3 D1 28 1C 0A 21 22 1C ?? ?? ?? ?? EF E7 ?? ?? ?? ?? E1 E7 28 1C 31 1C 22 1C ?? ?? ?? ?? E6 E7 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "iswxdigit"
		size = 32
	strings:
		$1 = { 03 1C 61 3B 05 2B 01 D8 01 20 08 E0 31 33 09 2B FA D9 03 1C 41 3B 00 20 05 22 9A 42 40 41 70 47 }
	condition:
		$1
}

rule file_125_0_0 {
	meta:
		name = "strrchr"
		size = 42
		refs = "0012 strchr"
	strings:
		$1 = { 30 B5 0C 1C 00 29 0B D0 00 25 01 E0 58 1C 1D 1C 21 1C ?? ?? ?? ?? 03 1C 00 28 F7 D1 28 1C 30 BD 00 21 ?? ?? ?? ?? 05 1C F8 E7 }
	condition:
		$1
}

rule file_127_0_0 {
	meta:
		name = "__strtok_r"
		size = 96
	strings:
		$1 = { F0 B5 00 28 27 D0 07 78 46 1C 0C 1C 25 78 01 34 00 2D 05 D0 AF 42 F9 D1 00 2B 16 D0 30 1C F2 E7 00 2F 03 D1 14 E0 00 2C 03 D1 3E 1C 35 78 77 1C 0B 1C 1C 78 01 33 A5 42 F5 D1 00 2D 03 D0 00 23 33 70 17 60 F0 BD 00 27 FB E7 16 60 03 70 F9 E7 17 60 00 20 F6 E7 10 68 00 28 D4 D1 00 20 F1 E7 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "memcpy"
		size = 124
	strings:
		$1 = { F0 B5 06 1C 0D 1C 14 1C 0F 2A 03 D9 0B 1C 03 43 9F 07 08 D0 00 2C 05 D0 00 23 EA 5C F2 54 01 33 A3 42 FA D1 F0 BD 15 1C 0C 1C 03 1C 26 68 1E 60 66 68 5E 60 A6 68 9E 60 E6 68 10 3D DE 60 10 34 10 33 0F 2D F2 D8 10 3A 13 09 5D 1C 2D 01 1B 01 46 19 4D 19 D1 1A 0C 1C 03 29 DB D9 00 23 EA 58 F2 50 04 33 CA 1A 03 2A F9 D8 04 39 8C 08 63 1C 9B 00 A4 00 F6 18 ED 18 0C 1B CB E7 }
	condition:
		$1
}

rule file_130_1_0 {
	meta:
		name = "__time_load_locale"
		size = 44
		refs = "0016 __part_load_locale"
	strings:
		$1 = { 00 B5 07 4B 07 49 83 B0 DA 6E 3A 23 00 93 01 93 0B 1D 02 93 04 4B ?? ?? ?? ?? 03 B0 00 BD C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "asiprintf"
		size = 76
		refs = "002c _svfiprintf_r 0048 _impure_ptr"
	strings:
		$1 = { 0E B4 70 B5 9B B0 A2 21 6C 46 89 00 A1 81 01 21 49 42 1F AB E1 81 0C 49 04 CB 00 25 06 1C 08 68 69 46 00 95 04 95 02 95 05 95 1A 93 ?? ?? ?? ?? 00 28 03 DB 00 9B 1D 70 04 9B 33 60 1B B0 70 BC 08 BC 03 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "asprintf"
		size = 76
		refs = "002c _svfprintf_r 0048 _impure_ptr"
	strings:
		$1 = { 0E B4 70 B5 9B B0 A2 21 6C 46 89 00 A1 81 01 21 49 42 1F AB E1 81 0C 49 04 CB 00 25 06 1C 08 68 69 46 00 95 04 95 02 95 05 95 1A 93 ?? ?? ?? ?? 00 28 03 DB 00 9B 1D 70 04 9B 33 60 1B B0 70 BC 08 BC 03 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_131_1_0 {
	meta:
		name = "_asiprintf_r"
		size = 66
		refs = "0028 _svfiprintf_r"
	strings:
		$1 = { 0C B4 70 B5 9B B0 0E 1C A2 21 6C 46 89 00 1F AB A1 81 01 21 49 42 04 CB 00 25 E1 81 69 46 00 95 04 95 02 95 05 95 1A 93 ?? ?? ?? ?? 00 28 03 DB 00 9B 1D 70 04 9B 33 60 1B B0 70 BC 08 BC 02 B0 18 47 }
	condition:
		$1
}

rule file_202_1_0 {
	meta:
		name = "_asprintf_r"
		size = 66
		refs = "0028 _svfprintf_r"
	strings:
		$1 = { 0C B4 70 B5 9B B0 0E 1C A2 21 6C 46 89 00 1F AB A1 81 01 21 49 42 04 CB 00 25 E1 81 69 46 00 95 04 95 02 95 05 95 1A 93 ?? ?? ?? ?? 00 28 03 DB 00 9B 1D 70 04 9B 33 60 1B B0 70 BC 08 BC 02 B0 18 47 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "_wcstoll_r"
		size = 500
		refs = "001c iswspace 0066 __umoddi3 0074 __udivdi3 0088 iswdigit 00b6 __muldi3 00e0 iswalpha 00ea iswupper"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 89 B0 08 90 06 91 93 46 98 46 0E 1C 10 CE 20 1C ?? ?? ?? ?? 00 28 F9 D1 2D 2C 00 D1 AE E0 2B 2C 00 D1 B8 E0 00 21 07 91 40 46 43 42 43 41 10 28 00 D1 78 E0 00 2B 00 D0 75 E0 42 46 D2 17 04 90 05 92 07 9A 00 2A 00 D0 7D E0 64 49 62 48 00 90 01 91 00 98 01 99 04 9A 05 9B ?? ?? ?? ?? 04 9A 05 9B 82 46 00 98 01 99 ?? ?? ?? ?? 00 22 00 23 81 46 20 1C 0F 1C 00 25 00 92 01 93 ?? ?? ?? ?? 00 28 26 D0 30 3C A0 45 31 DD 01 9B 9F 42 62 D3 9F 42 5D D0 00 2D 5E DB 54 45 02 DD 00 99 89 45 60 D0 04 9A 05 9B 00 98 01 99 ?? ?? ?? ?? 02 94 E4 17 03 94 02 1C 0B 1C 02 98 03 99 80 18 59 41 00 90 01 91 10 CE 01 25 20 1C ?? ?? ?? ?? 00 28 D8 D1 20 1C ?? ?? ?? ?? 00 28 08 D0 20 1C ?? ?? ?? ?? 00 28 3B D1 57 23 E4 1A A0 45 CD DC 69 1C 48 D0 07 99 00 29 3B D1 00 99 01 9A 0B 1C 14 1C 59 46 00 29 06 D0 00 2D 01 D0 04 3E 06 96 06 9A 58 46 02 60 09 B0 18 1C 21 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 30 2C 39 D0 00 2B 4F D0 30 2C 46 D0 0A 22 00 23 04 92 05 93 07 9A 0A 23 98 46 00 2A 00 D1 81 E7 26 49 26 4A 00 91 01 92 80 E7 00 98 81 45 9E D2 01 25 6D 42 10 CE B4 E7 37 23 E4 1A C2 E7 01 9A 97 42 9B D1 01 25 6D 42 F4 E7 00 98 01 99 00 24 43 42 8C 41 C1 E7 01 20 10 CE 07 90 51 E7 07 9A 00 2A 17 D1 14 4C 12 4B 08 98 22 22 02 60 B4 E7 00 22 10 CE 07 92 44 E7 32 68 58 2A 01 D0 78 2A C0 D1 10 21 00 22 04 91 05 92 10 22 74 68 90 46 08 36 43 E7 09 4B 09 4C E6 E7 08 20 00 21 04 90 05 91 08 21 88 46 39 E7 41 46 04 91 C9 17 05 91 34 E7 FF FF FF FF FF FF FF 7F 00 00 00 00 00 00 00 80 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "mempcpy"
		size = 122
	strings:
		$1 = { F0 B5 03 1C 0E 1C 15 1C 0F 2A 03 D9 0C 1C 1C 43 A7 07 09 D0 00 2D 06 D0 00 22 B4 5C 84 54 01 32 AA 42 FA D1 80 18 F0 BD 0C 1C 26 68 06 60 66 68 46 60 A6 68 86 60 E6 68 10 3D C6 60 10 34 10 30 0F 2D F2 D8 10 3A 14 09 66 1C 36 01 98 19 23 01 D3 1A 8E 19 1D 1C 03 2B DC D9 00 22 B4 58 84 50 04 32 9C 1A 03 2C F9 D8 04 3B 9D 08 6A 1C 92 00 AD 00 80 18 B6 18 5D 1B CC E7 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "fcreader"
		size = 60
		refs = "000a __errno"
	strings:
		$1 = { F0 B5 0C 1C 16 1C 1D 1C 07 1C ?? ?? ?? ?? 00 23 03 60 31 1C 20 68 A3 68 2A 1C 00 F0 32 F8 04 1C 00 28 01 DB 20 1C F0 BD ?? ?? ?? ?? 03 68 00 2B F8 D0 ?? ?? ?? ?? 03 68 3B 60 F3 E7 }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "fcwriter"
		size = 86
		refs = "0024 __errno"
	strings:
		$1 = { F0 B5 1D 1C 4B 68 16 1C 9A 89 07 1C 0C 1C D1 05 08 D5 9B 6A 9C 46 00 2B 04 D0 21 1C 00 22 02 23 00 F0 5C F8 ?? ?? ?? ?? 00 23 03 60 31 1C 20 68 E3 68 2A 1C 00 F0 51 F8 04 1C 00 28 01 DB 20 1C F0 BD ?? ?? ?? ?? 03 68 00 2B F8 D0 ?? ?? ?? ?? 03 68 3B 60 F3 E7 }
	condition:
		$1
}

rule file_134_2_0 {
	meta:
		name = "fcseeker"
		size = 62
		refs = "000c __errno"
	strings:
		$1 = { 70 B5 81 B0 0C 1C 1D 1C 00 92 06 1C ?? ?? ?? ?? 00 23 03 60 69 46 20 68 23 69 2A 1C 00 F0 7D F8 00 28 02 DB 00 98 01 B0 70 BD ?? ?? ?? ?? 03 68 00 2B F7 D0 ?? ?? ?? ?? 03 68 33 60 F2 E7 }
	condition:
		$1
}

rule file_134_3_0 {
	meta:
		name = "fccloser"
		size = 70
		refs = "000c __errno 0026 _free_r"
	strings:
		$1 = { 70 B5 4B 69 06 1C 0C 1C 00 2B 10 D0 ?? ?? ?? ?? 00 23 03 60 20 68 63 69 00 F0 15 F8 05 1C 00 28 07 DB 30 1C 21 1C ?? ?? ?? ?? 28 1C 70 BD 00 25 F7 E7 ?? ?? ?? ?? 03 68 00 2B F2 D0 ?? ?? ?? ?? 03 68 33 60 ED E7 }
	condition:
		$1
}

rule file_134_4_0 {
	meta:
		name = "_fopencookie_r"
		size = 208
		refs = "0026 __sflags 0042 __sfp 0050 _malloc_r 00b0 __sfp_lock_acquire 00b6 __sfp_lock_release 00c0 fcreader 00c4 fcwriter 00c8 fcseeker 00cc fccloser"
	strings:
		$1 = { 81 B0 F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 81 B0 0A 93 9A 46 0C 9B 98 46 0D 9B 89 46 11 1C 6A 46 05 1C 0B 9F 9B 46 ?? ?? ?? ?? 06 1C 00 28 3D D0 14 23 18 42 35 D1 18 23 1E 42 01 D0 00 2F 33 D0 28 1C ?? ?? ?? ?? 04 1C 00 28 1F D0 28 1C 18 21 ?? ?? ?? ?? 05 1C 00 28 2A D0 01 23 5B 42 E3 81 4B 46 03 60 53 46 83 60 15 4B 23 62 15 4B 63 62 43 46 A6 81 44 60 E0 61 C7 60 03 61 00 2B 00 D0 11 4B A3 62 5B 46 6B 61 10 4B E3 62 01 B0 20 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BC 08 BC 01 B0 18 47 53 46 00 2B C6 D1 16 23 2B 60 00 24 ED E7 ?? ?? ?? ?? A5 81 ?? ?? ?? ?? 00 24 E6 E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_5_0 {
	meta:
		name = "fopencookie"
		size = 60
		refs = "0026 _fopencookie_r 0038 _impure_ptr"
	strings:
		$1 = { 82 B0 F0 B5 47 46 80 B4 83 B0 09 92 0A 93 0A 4B 05 1C 90 46 0C 1C 6A 46 0A A9 18 68 C8 C9 C8 C2 43 46 29 1C 22 1C ?? ?? ?? ?? 03 B0 04 BC 90 46 F0 BC 08 BC 02 B0 18 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "swab"
		size = 52
	strings:
		$1 = { 70 B5 01 2A 14 DD 00 24 01 23 05 5D C6 5C 0E 55 CD 54 02 33 02 34 9A 42 F7 DC 93 1E 5B 08 5B 00 03 33 93 42 03 D1 CB 18 01 3B 00 22 1A 70 70 BD 01 23 F6 E7 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "iswalpha"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { FF 28 06 D8 04 4B 1B 68 18 18 40 78 03 23 18 40 70 47 00 20 FC E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "envz_strip"
		size = 106
		refs = "0014 strchr 0022 argz_next 0034 realloc 003e strlen 005a memmove"
	strings:
		$1 = { F0 B5 06 1C 0D 1C 00 27 09 68 00 24 00 68 07 E0 20 1C 3D 21 ?? ?? ?? ?? 00 28 0F D0 29 68 30 68 22 1C ?? ?? ?? ?? 04 1C 00 28 F1 D1 00 2F 04 D0 30 68 29 68 ?? ?? ?? ?? 30 60 F0 BD 20 1C ?? ?? ?? ?? 29 68 03 1C 47 1C 30 68 E3 18 42 18 9A 42 07 D0 12 1B E1 19 D2 1B 20 1C ?? ?? ?? ?? 29 68 30 68 C9 1B 29 60 01 27 DA E7 }
	condition:
		$1
}

rule file_141_0_0 {
	meta:
		name = "nl_langinfo"
		size = 612
		refs = "0016 __get_current_messages_locale 0022 setlocale 002e strchr 0042 strncmp 004e strlen 0058 realloc 0066 strcpy 006e strcat 0076 __get_current_time_locale 00ec __get_current_monetary_locale 00fa localeconv 0150 __get_current_numeric_locale 016c strcmp 01b4 strstr 01de free"
	strings:
		$1 = { 70 B5 04 1C 39 28 02 D9 86 4C 20 1C 70 BD 86 4A 83 00 D3 58 9F 46 ?? ?? ?? ?? 44 68 F5 E7 02 20 00 21 ?? ?? ?? ?? 05 1C 00 28 ED D0 2E 21 ?? ?? ?? ?? 06 1C 00 28 00 D1 AE E0 44 1C 20 1C 7B 49 04 22 ?? ?? ?? ?? 00 28 00 D0 8D E0 20 1C ?? ?? ?? ?? 77 4D 01 1C 28 68 ?? ?? ?? ?? 00 28 00 D1 BA E0 74 49 28 60 ?? ?? ?? ?? 28 68 71 1D ?? ?? ?? ?? 2C 68 C9 E7 ?? ?? ?? ?? A0 23 C4 58 C4 E7 ?? ?? ?? ?? 9C 23 C4 58 BF E7 ?? ?? ?? ?? 98 23 C4 58 BA E7 ?? ?? ?? ?? E4 23 C4 58 B5 E7 ?? ?? ?? ?? A4 23 C4 58 B0 E7 ?? ?? ?? ?? A8 23 C4 58 AB E7 ?? ?? ?? ?? 18 34 A4 00 24 58 A5 E7 ?? ?? ?? ?? 0A 34 A4 00 24 58 9F E7 ?? ?? ?? ?? 09 3C A4 00 24 58 99 E7 ?? ?? ?? ?? 21 3C A4 00 24 58 93 E7 ?? ?? ?? ?? E0 23 C4 58 8E E7 ?? ?? ?? ?? 44 68 23 78 00 2B 00 D1 86 E7 ?? ?? ?? ?? 2A 23 C5 5C ?? ?? ?? ?? 2C 23 C3 5C AB 42 00 D0 7B E7 FF 2B 74 D0 00 2B 5D D1 2B 26 20 1C ?? ?? ?? ?? 43 4D 6B 68 81 1C 18 1C ?? ?? ?? ?? 00 28 71 D0 68 60 21 1C 06 70 01 30 ?? ?? ?? ?? 6C 68 64 E7 ?? ?? ?? ?? C4 68 60 E7 ?? ?? ?? ?? 84 68 5C E7 ?? ?? ?? ?? 04 68 58 E7 ?? ?? ?? ?? 44 68 54 E7 ?? ?? ?? ?? 04 68 50 E7 20 1C 33 49 ?? ?? ?? ?? 00 28 08 D1 28 1C 31 49 05 22 ?? ?? ?? ?? 00 28 1F D1 2F 4C 41 E7 20 1C 2E 49 ?? ?? ?? ?? 00 28 00 D0 3A E7 2C 4C 38 E7 28 1C 2C 49 ?? ?? ?? ?? 00 28 F7 D0 28 1C 2A 49 ?? ?? ?? ?? 00 28 F1 D0 28 1C 24 49 ?? ?? ?? ?? 00 28 00 D1 24 E7 22 4C 23 E7 28 1C 23 49 05 22 ?? ?? ?? ?? 00 28 0C D1 21 4C 1A E7 2D 26 A0 E7 28 68 00 28 01 D0 ?? ?? ?? ?? 00 23 2B 60 0F 4C 0F E7 28 1C 1B 49 05 22 ?? ?? ?? ?? 00 28 00 D0 07 E7 19 4C 05 E7 ?? ?? ?? ?? 81 68 20 1C ?? ?? ?? ?? 00 28 00 D0 FB E6 2E 26 82 E7 68 68 00 28 01 D0 ?? ?? ?? ?? 00 23 6B 60 F1 E6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "mblen"
		size = 28
	strings:
		$1 = { 00 28 02 D0 03 78 00 2B 01 D1 00 20 70 47 00 29 01 D0 01 20 FA E7 01 20 40 42 F7 E7 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "scalbnf"
		size = 208
		refs = "0036 __addsf3 0042 __mulsf3 0068 copysignf"
	strings:
		$1 = { 10 B5 0C 1C 28 49 03 1C 02 1C 01 40 0F D0 27 48 81 42 0E D8 26 48 81 42 11 D9 C9 0D 09 19 FE 29 29 DC 00 29 18 DD CB 05 22 49 0A 40 13 43 18 1C 10 BD 18 1C 19 1C ?? ?? ?? ?? 03 1C F7 E7 18 1C 1D 49 ?? ?? ?? ?? 1D 4A 03 1C 94 42 1C DB 41 00 09 0E 02 1C 19 39 E1 E7 08 1C 16 30 19 DA 18 4A 94 42 08 DC 19 1C 17 48 ?? ?? ?? ?? 15 49 ?? ?? ?? ?? 03 1C DB E7 19 1C 13 48 ?? ?? ?? ?? 12 49 ?? ?? ?? ?? 03 1C D2 E7 0E 49 ?? ?? ?? ?? 03 1C CD E7 08 4B 08 1C 19 30 1A 40 C0 05 10 43 0B 49 ?? ?? ?? ?? 03 1C C2 E7 FF FF FF 7F FF FF 7F 7F FF FF 7F 00 FF FF 7F 80 00 00 00 4C B0 3C FF FF 50 C3 00 00 60 42 A2 0D CA F2 49 71 00 00 00 33 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "argz_next"
		size = 38
	strings:
		$1 = { 03 1C 00 2A 01 D1 0A E0 01 32 10 78 00 28 FB D1 01 32 5B 18 9A 42 00 D3 00 22 10 1C 70 47 00 29 FB D0 02 1C F9 E7 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "__ssrefill_r"
		size = 64
		refs = "0012 _free_r"
	strings:
		$1 = { 10 B5 0C 1C 09 6B 00 29 0F D0 23 1C 40 33 99 42 01 D0 ?? ?? ?? ?? 00 23 23 63 E3 6B 63 60 00 2B 03 D0 A3 6B 23 60 00 20 10 BD 23 69 A2 89 23 60 00 23 63 60 20 23 13 43 01 20 A3 81 40 42 F3 E7 }
	condition:
		$1
}

rule file_146_1_0 {
	meta:
		name = "_sungetc_r"
		size = 138
		refs = "007c __submore"
	strings:
		$1 = { 30 B5 14 1C 4B 1C 14 D0 93 89 20 22 93 43 A3 81 23 6B 0D 06 2D 0E 00 2B 0D D0 62 68 63 6B 9A 42 2B DA 23 68 01 3B 23 60 1D 70 63 68 01 33 63 60 29 1C 08 1C 30 BD 22 69 00 2A 1C D0 23 68 9A 42 03 D2 5A 1E 11 78 A9 42 10 D0 A3 63 23 1C 40 33 23 63 03 23 63 63 42 23 E5 54 23 1C 62 68 42 33 23 60 01 23 E2 63 63 60 29 1C E2 E7 63 68 01 33 22 60 63 60 DD E7 23 68 E7 E7 21 1C ?? ?? ?? ?? 00 28 CE D0 01 21 49 42 D3 E7 }
	condition:
		$1
}

rule file_146_2_0 {
	meta:
		name = "__ssvfscanf_r"
		size = 3604
		refs = "01d4 memset 01e6 _mbrtowc_r 0320 __ctype_ptr__ 0324 _strtol_r 032c _strtoul_r 0330 __mb_cur_max 03cc _strtod_r 084c __sccl 096e iswspace 0ab6 memcpy 0cb4 sprintf 0cdc __isnand 0cea __truncdfsf2 0dfe nanf"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 C2 4C 99 46 A5 44 80 23 0C 1C 89 89 9B 01 82 46 19 42 05 D1 0B 43 A3 81 61 6E BD 4B 0B 40 63 66 00 20 07 90 05 90 04 90 90 46 00 25 41 46 0A 78 AD 92 00 2A 24 D0 B7 4E 01 23 98 44 33 68 99 18 49 78 0F 07 26 D5 63 68 08 27 0C E0 22 68 31 68 13 78 CB 18 5B 78 3B 42 E8 D0 63 68 01 32 01 3B 63 60 22 60 01 35 00 2B F0 DC 50 46 21 1C FF F7 5B FF 00 28 EA D0 41 46 0A 78 AD 92 00 2A DA D1 04 98 AE 23 9B 00 9D 44 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 25 2A 1F D0 63 68 00 2B 0D DD 23 68 42 46 01 3A 19 78 12 78 91 42 E9 D1 62 68 01 33 01 3A 62 60 23 60 01 35 B8 E7 50 46 21 1C FF F7 33 FF 00 28 EB D0 04 98 00 28 02 D0 A3 89 5F 06 D7 D5 01 20 40 42 D4 E7 00 20 01 90 47 46 9C 46 3A 78 01 37 78 2A 11 D9 63 46 9B 18 5B 78 B8 46 01 27 83 46 3B 42 01 D0 38 43 83 46 86 49 0A 22 03 23 07 91 01 9F 05 92 03 93 0C E0 83 49 93 00 CB 58 9F 46 82 4A 83 46 0A 23 03 20 B8 46 07 92 01 9F 05 93 03 90 63 68 00 2B 00 DC C4 E3 58 46 40 06 16 D4 23 68 31 68 1A 78 8A 18 52 78 08 21 0A 42 0E D0 62 68 01 3A 62 60 00 2A 61 DD 01 33 23 60 01 35 31 68 1A 78 8A 18 52 78 08 21 0A 42 F0 D1 03 9A 02 2A 00 D1 B5 E3 02 2A 5B DC 01 2A 00 D1 3E E1 01 98 00 28 00 D1 01 27 59 46 01 22 11 42 01 D1 00 F0 86 FC 10 23 19 40 01 91 01 D0 00 F0 7C FC 48 46 00 68 04 21 83 46 89 44 43 46 00 26 A8 46 5D 46 9B 46 5E 4A 13 68 9E 42 8A D0 23 68 1A 78 13 A8 82 55 62 68 01 33 01 3A 62 60 23 60 00 21 08 22 AB A8 ?? ?? ?? ?? 01 36 AB A9 00 91 13 AA 50 46 29 1C 33 1C ?? ?? ?? ?? 42 1C 00 D1 70 E7 00 28 00 D0 D6 E3 01 9B 00 2B 00 D1 2B 60 01 98 B0 44 01 3F 00 28 00 D1 04 35 00 26 63 68 00 2B 00 DC D9 E3 00 2F CD D1 45 46 D8 46 E1 E3 50 46 21 1C FF F7 87 FE 00 28 00 D0 52 E7 23 68 01 35 96 E7 03 9B 03 2B 00 D1 6D E1 04 2B A0 D1 01 9A AE 23 01 3A 5B 00 9A 42 00 D9 17 E3 00 21 0B 91 F0 26 58 46 F6 00 6A 46 E0 23 00 21 4C 32 DB 00 06 43 A0 20 93 46 C0 00 08 91 03 91 09 91 0E 91 06 91 0F 91 01 92 0A 93 80 21 80 22 C0 23 10 90 C9 00 40 46 92 00 5B 00 12 90 0C 91 00 20 0D 92 11 93 A8 46 5D 46 CB 46 D1 46 82 46 22 68 13 78 4E 2B 00 D1 DD E2 4E 2B 00 D9 0E E1 39 2B 00 D9 21 E1 31 2B 01 D3 00 F0 5D FC 2E 2B 01 D1 00 F0 4F FC 2E 2B 01 D9 00 F0 38 FC 2B 2B 00 D1 BE E1 2D 2B 00 D1 BB E1 12 98 06 99 57 46 08 97 CA 46 D9 46 AB 46 45 46 80 46 00 29 01 D0 11 4B 1E 40 03 9B 01 3B 01 2B 01 D8 00 F0 54 FD 08 9B 01 3B 06 2B 2E D8 08 9A 02 2A 01 D8 00 F0 3E FD 5B 46 17 1C 03 93 1B E0 C0 46 48 FD FF FF FF DF FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FE FF FF 03 98 01 38 03 90 22 1C 01 78 50 46 FF F7 16 FE 01 3F 3F 06 3F 0E 03 2F F2 D1 08 9B 03 3B 1B 06 1B 0E 59 46 C9 1A ED 1A 8B 46 F3 05 1B D5 77 05 01 D5 00 F0 3A FD 01 21 49 42 8B 44 5A 46 11 78 01 3D 45 29 0B D0 65 29 09 D0 50 46 22 1C FF F7 F5 FD 01 23 5B 42 9B 44 5F 46 39 78 ED 18 50 46 22 1C FF F7 EB FD 10 23 33 40 00 D0 48 E6 58 46 C0 22 03 70 D2 00 80 23 32 40 DB 00 9A 42 01 D1 00 F0 80 FC 0E 98 00 28 01 D0 00 F0 63 FC 50 46 01 99 00 22 ?? ?? ?? ?? 01 90 02 91 01 21 0E 42 04 D1 02 21 0E 42 01 D1 00 F0 76 FC 4A 46 13 68 01 98 02 99 18 60 59 60 4E 46 04 36 04 9A 01 32 04 92 B1 46 1C E6 01 98 00 28 01 D1 01 27 7F 42 59 46 C9 06 33 D5 D6 22 52 00 6A 44 23 68 03 92 00 26 1A 78 03 98 82 5C 00 2A 01 D1 00 F0 9B FC 62 68 01 33 01 3A 01 36 62 60 23 60 B7 42 1C D0 00 2A EE DC 50 46 21 1C FF F7 78 FD 00 28 14 D1 23 68 E6 E7 2B 1C 35 1C 5E 46 9B 46 5E 45 00 D1 3B E6 59 46 8E 1B 00 2E 00 D1 13 E6 00 23 0B 70 04 9B 01 33 04 22 04 93 91 44 AD 19 E0 E5 49 46 D6 22 0E 68 52 00 6A 44 B3 46 23 68 03 92 2E 1C 5D 46 1B 78 03 98 C3 5C 00 2B 01 D1 00 F0 54 FC 63 68 01 3B 63 60 23 68 1A 78 01 3F 01 33 2A 70 01 35 23 60 00 2F 01 D1 00 F0 46 FC 62 68 00 2A E7 DC 50 46 21 1C FF F7 39 FD 00 28 C2 D1 23 68 DF E7 66 2B 00 D1 74 E3 66 2B 00 D9 67 E3 59 2B 00 D1 5C E3 59 2B 00 D9 E5 E0 54 2B 00 D0 F6 E6 50 46 06 28 00 D0 F2 E6 07 21 8A 46 B0 E0 45 2B 00 D1 DE E0 45 2B 00 D9 C1 E0 41 2B 00 D0 E6 E6 03 98 01 28 00 D0 E2 E6 02 21 03 91 A0 E0 01 9A AE 23 01 3A 5B 00 9A 42 00 D9 F9 E0 00 22 03 92 D8 26 6A 46 58 46 4C 32 00 21 36 01 C0 23 93 46 DB 00 06 43 08 91 01 92 80 20 A0 21 80 22 09 93 80 00 2B 1C C9 00 12 01 5D 46 06 90 0A 91 0B 92 9B 46 19 E0 38 2B 3C D3 05 98 41 00 C8 48 09 5A 09 04 09 14 05 91 08 29 1C DD C6 49 0E 40 2B 70 01 35 63 68 01 3B 63 60 00 2B 00 DC CE E0 01 32 22 60 01 3F 00 2F 0D D0 22 68 13 78 39 2B E1 D9 58 2B 4C D0 58 2B 44 D8 19 1C 41 39 09 06 09 0E 05 29 23 D9 5B 46 AB 46 1D 1C F2 05 07 D5 01 9B 9B 45 00 D9 AE E3 01 99 8B 45 00 D1 62 E5 10 23 33 40 00 D1 92 E3 01 9F 08 98 ED 1B 2D 18 5D 44 2E E5 30 2B 18 D0 30 2B 0C D8 2B 2B 01 D0 2D 2B E0 D1 80 21 0E 42 DD D0 8E 43 C0 E7 05 98 0A 28 BB DC D7 E7 05 99 48 00 A1 49 41 5A A1 48 09 04 09 14 05 91 06 40 B2 E7 0B 98 06 42 AF D0 05 99 00 29 00 D1 CF E3 70 05 00 D4 D1 E3 9A 49 0E 40 A5 E7 61 2B BE D3 66 2B E0 D9 78 2B BA D1 09 99 06 98 31 40 81 42 B5 D1 94 49 0A 98 0E 40 10 21 06 43 05 91 93 E7 80 21 0E 42 00 D1 3F E6 8E 43 2B 70 01 35 01 23 98 44 63 68 01 3B 63 60 00 2B 06 DD 01 32 22 60 01 3F 00 2F 00 D0 12 E6 2E E6 48 46 21 1C FF F7 5A FC 00 28 F4 D0 27 E6 46 2B 00 D1 96 E2 49 2B 00 D0 21 E6 50 46 00 28 33 D1 0A 99 0A 98 31 40 81 42 00 D0 18 E6 7C 49 01 20 0E 40 82 46 D4 E7 61 2B 00 D1 29 E7 65 2B 00 D0 0D E6 10 99 0C 98 31 40 81 42 05 D0 06 42 00 D1 05 E6 06 99 00 29 0E D0 0D 98 06 42 04 D1 06 99 0F 98 09 1A 0E 91 09 95 6D 49 11 98 0E 40 00 21 06 43 06 91 B4 E7 12 98 52 46 08 92 CA 46 D9 46 AB 46 45 46 80 46 F7 E5 51 46 05 29 02 D0 03 29 00 D0 E4 E5 51 46 01 31 09 06 09 0E 8A 46 9F E7 60 4F 01 9B DF 19 03 97 5F 4F 01 E7 50 46 21 1C FF F7 04 FC 00 28 00 D1 2B E7 3B E7 10 21 08 43 D8 E4 02 1C 01 23 1A 43 B8 46 93 46 57 4F 0A 20 03 21 07 97 05 90 01 9F 03 91 EE E4 01 99 8B 00 5B 18 5B 00 30 3A D2 18 01 92 C3 E4 80 23 9B 00 02 1C 1A 43 4E 4B 10 20 03 21 B8 46 93 46 01 9F 07 93 05 90 03 91 D8 E4 01 1C 01 22 11 43 48 4B 8B 46 08 20 03 21 B8 46 07 93 01 9F 05 90 03 91 CB E4 02 23 18 43 A5 E4 04 22 B8 46 83 46 01 9F 03 92 C2 E4 88 23 B8 46 9B 00 07 1C 3C 48 1F 43 10 21 03 22 BB 46 07 90 01 9F 05 91 03 92 B4 E4 37 49 08 22 03 23 B8 46 83 46 01 9F 07 91 05 92 03 93 AA E4 03 1C 83 46 B8 46 DB 06 00 D5 27 E4 07 1C 04 20 07 42 00 D0 39 E2 5A 46 01 23 1A 42 00 D1 3A E2 4F 46 3B 68 04 20 1D 60 81 44 FF F7 17 FC 01 22 10 43 6D E4 24 4A 83 46 00 23 03 20 B8 46 07 92 01 9F 05 93 03 90 86 E4 04 21 08 43 60 E4 40 23 02 1C 1A 43 00 23 B8 46 93 46 01 9F 03 93 7A E4 B8 46 D6 27 7F 00 6F 44 83 46 41 46 38 1C 03 97 ?? ?? ?? ?? 40 23 80 46 58 46 18 43 01 21 83 46 01 9F 03 91 67 E4 03 99 00 29 21 D1 0A 99 0A 98 31 40 81 42 20 D1 09 49 01 20 0E 40 03 90 ED E6 07 4B 01 9A D3 18 0B 93 06 4F E3 E4 ?? ?? ?? ?? 7F F4 FF FF 7F FA FF FF FF FD FF FF 7F F8 FF FF A3 FE FF FF 5D 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 03 99 02 29 00 D1 5E E2 51 46 04 29 00 D1 27 E7 01 29 00 D0 09 E5 23 E7 50 46 21 1C FF F7 34 FB 00 28 00 D1 33 E4 FF F7 FE FB 02 23 B8 46 83 46 01 9F 03 93 27 E4 01 98 00 28 01 D1 01 27 7F 42 59 46 01 22 11 42 00 D1 84 E0 10 23 19 40 03 91 7B D1 48 46 00 68 04 21 01 90 89 44 43 46 00 22 A8 46 9B 46 15 1C 22 68 13 78 00 2F 48 D0 31 68 C9 18 49 78 08 20 01 42 42 D1 D6 48 01 68 8D 42 01 D1 FF F7 D0 FB 13 A9 4B 55 63 68 01 32 01 3B 63 60 22 60 00 21 08 22 AB A8 ?? ?? ?? ?? 01 35 AB AA 00 92 2B 1C 50 46 01 99 13 AA ?? ?? ?? ?? 43 1C 01 D1 FF F7 B7 FB 00 28 00 D0 78 E1 01 99 08 60 ?? ?? ?? ?? 00 28 00 D1 53 E1 5B 46 AB 46 45 46 98 46 5B 46 00 2B 14 D0 5E 46 01 3E 13 A8 87 19 00 E0 01 3E 39 78 50 46 22 1C FF F7 EC FA 01 3F 00 2E F6 D1 05 E0 02 30 00 D1 30 E4 28 E4 45 46 D8 46 03 99 00 29 01 D0 FF F7 3F FB 04 9B 01 9A 01 33 11 60 04 93 FF F7 38 FB 50 46 21 1C FF F7 B2 FA 00 28 00 D1 1E E4 45 46 D8 46 00 2E 01 D0 FF F7 78 FB 01 99 00 29 01 D0 FF F7 26 FB 04 9A 01 32 04 92 FF F7 21 FB AD 23 9B 00 6B 44 01 93 83 E7 58 46 C0 06 27 D4 49 46 09 68 2A 1C 01 91 23 68 0D 1C 93 46 32 68 1B 78 D3 18 5B 78 08 22 13 42 00 D0 ED E0 63 68 01 3B 63 60 23 68 1A 78 01 3F 01 33 2A 70 01 35 23 60 00 2F 00 D1 E0 E0 62 68 00 2A E7 DC 50 46 21 1C FF F7 74 FA 00 28 00 D0 D6 E0 23 68 DE E7 2A 1C 00 21 23 68 0D 1C 93 46 1A 78 31 68 8A 18 52 78 08 20 02 42 00 D0 C1 E0 62 68 01 33 01 3A 01 35 62 60 23 60 AF 42 00 D1 B8 E0 00 2A EC DC 50 46 21 1C FF F7 53 FA 00 28 00 D0 AF E0 23 68 E3 E7 00 23 9B 46 FF F7 85 FB 5B 46 DB 06 2B D4 49 46 09 68 3E 1C 01 91 16 E0 21 68 5A 46 01 98 ?? ?? ?? ?? 23 68 00 22 5B 44 23 60 62 60 5B 46 50 46 21 1C F6 1A FF F7 32 FA 00 28 00 D0 81 E0 01 98 01 1C 59 44 01 91 62 68 93 46 5E 45 E4 D8 32 1C 21 68 01 98 ?? ?? ?? ?? 63 68 9B 1B 63 60 23 68 9E 19 26 60 72 E0 00 26 AB 46 0A E0 23 68 5B 19 23 60 50 46 21 1C 76 19 FF F7 10 FA 00 28 58 D1 7F 1B 65 68 BD 42 F1 DB 5B 46 AB 46 58 46 1D 1C C3 1B 63 60 23 68 F6 19 DF 19 27 60 AD 19 FF F7 7F FA 30 2B 01 D0 FF F7 CA FB F1 05 16 D5 80 23 9E 43 06 9B 0B 98 01 33 06 93 00 28 00 D1 81 E5 01 38 0B 90 01 37 7D E5 0D 98 06 42 01 D1 FF F7 B6 FB 46 49 0E 40 06 99 0F 91 71 E5 03 98 01 1C 51 44 00 29 01 D0 FF F7 AA FB 41 49 0E 40 67 E5 74 2B 00 D1 AC E4 79 2B 01 D0 FF F7 A0 FB 50 46 07 28 01 D0 FF F7 9B FB 08 21 8A 46 58 E5 6E 2B 00 D1 5A E6 6E 2B EB D8 69 2B 01 D0 FF F7 8F FB 6B E5 50 46 02 28 01 D0 FF F7 89 FB 03 21 8A 46 46 E5 5D 46 00 2E 01 D1 FF F7 7F FA AD 19 FF F7 2F FA BF 1B 00 2F 01 D1 FF F7 77 FA 7D 19 04 9F 04 23 01 37 99 44 04 97 FF F7 22 FA 5B 46 AB 46 1D 1C 5D 44 FF F7 1C FA 5B 46 AB 46 1D 1C 04 23 99 44 5F 46 00 23 3B 70 04 99 01 98 01 31 2D 1A 5D 44 04 91 FF F7 0C FA 03 99 A8 44 01 3F 00 29 02 D1 01 9A 04 32 01 92 00 25 63 68 00 2B 00 DD 6B E6 50 46 21 1C FF F7 79 F9 00 28 00 D1 64 E6 5B 46 AB 46 45 46 98 46 5B 46 00 2B 01 D0 FF F7 3C FA A9 E6 02 30 E8 D0 01 9A 10 68 83 E6 49 46 0B 68 81 44 1D 80 FF F7 E3 F9 49 46 0B 68 04 22 1D 60 91 44 FF F7 DC F9 ?? ?? ?? ?? 7F FD FF FF 7F FE FF FF 09 99 00 22 01 31 50 46 0A 23 ?? ?? ?? ?? 0E 99 42 1A 5A 4B 09 9F 6B 44 9F 42 03 D3 CF 20 40 00 68 44 09 90 09 98 56 49 ?? ?? ?? ?? FF F7 85 FB 06 99 0F 9B CA 1A 00 2A 01 D1 FF F7 7E FB 52 42 09 90 E6 E7 49 46 4E 46 0F 68 01 98 02 99 04 36 ?? ?? ?? ?? 00 28 00 D0 8A E0 01 98 02 99 ?? ?? ?? ?? 38 60 FF F7 80 FB 5A 46 13 70 01 99 50 46 00 22 05 9B 07 9F 00 F0 87 F8 B1 06 12 D5 4A 46 13 68 18 60 04 23 99 44 04 9B 01 33 04 93 58 E4 01 27 7F 42 BB 44 58 46 01 78 22 1C 50 46 FF F7 23 F9 46 E4 04 27 3E 42 0A D0 49 46 0B 68 B9 44 18 80 E9 E7 2B 1C 35 1C 5E 46 9B 46 FF F7 87 FB 01 22 16 42 15 D0 4F 46 3B 68 18 60 04 20 81 44 DA E7 00 2E 01 D1 FF F7 93 F9 AD 19 FF F7 66 F9 B8 46 FF F7 99 F9 03 20 03 90 6F E4 83 46 B8 46 E2 E4 49 46 0B 68 04 22 18 60 91 44 C4 E7 5D 46 01 9A 95 42 01 D8 FF F7 7B F9 01 3D 29 78 50 46 22 1C FF F7 E9 F8 F3 E7 5D 46 01 99 8D 42 01 D8 FF F7 6E F9 01 3D 29 78 50 46 22 1C FF F7 DC F8 F3 E7 06 98 08 21 06 43 05 91 2A E4 03 99 00 29 02 D0 01 39 03 91 01 37 0E 4B 1E 40 08 9B 01 33 08 93 FF F7 CC FB 5D 46 01 98 85 42 01 D8 FF F7 4F F9 01 3D 29 78 50 46 22 1C FF F7 BD F8 F3 E7 00 20 ?? ?? ?? ?? 38 60 FF F7 F6 FA 9F 01 00 00 ?? ?? ?? ?? 7F FC FF FF }
	condition:
		$1
}

rule file_147_1_0 {
	meta:
		name = "_svfprintf_r"
		size = 4876
		refs = "0016 _localeconv_r 04e2 __isinfd 04f6 __ltdf2 068a memchr 0708 __eqdf2 0908 __nedf2 0a7a __umodsi3 0a88 __udivsi3 0d66 __isnand 0dde _dtoa_r 0ec8 _malloc_r 0f72 strlen 1170 __modsi3 117e __divsi3"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 BE B0 8B 46 99 46 06 90 17 1C ?? ?? ?? ?? 00 68 16 90 58 46 83 89 19 06 04 D5 03 69 00 2B 01 D1 00 F0 4A FF 00 23 31 AC 17 AA 31 92 A3 60 63 60 12 93 13 93 11 93 15 93 14 93 0A 93 15 1C 3B 78 00 2B 1E D0 25 2B 1C D0 3E 1C 01 36 33 78 25 2B 01 D0 00 2B F9 D1 F3 1B 98 46 00 2B 0F D0 6B 60 A3 68 43 44 A3 60 63 68 01 33 2F 60 63 60 07 2B 00 DD 51 E1 08 35 0A 99 0A 1C 42 44 0A 92 33 78 37 1C 00 2B 00 D1 27 E3 48 46 F7 23 6B 44 00 22 00 26 07 90 01 20 41 42 9A 46 1E 70 0B 92 08 23 05 92 88 46 01 37 10 21 40 20 9C 46 3B 78 01 37 1A 1C 20 3A 58 2A 00 D8 2A E1 10 93 00 2B 00 D1 0A E3 10 A9 09 78 27 AB 01 20 00 26 52 46 19 70 16 70 08 90 09 90 0D 93 00 23 0F 93 05 9A 02 23 1A 40 0E 92 02 D0 08 9B 02 33 08 93 05 9E 84 23 1E 40 0C 96 40 D1 0B 98 08 99 46 1A 00 2E 3B DD 10 2E 01 DC 00 F0 3C FF BF 4B 99 46 4A 46 10 20 2B 1C B9 46 80 46 5D 46 17 1C 03 E0 10 3E 08 33 10 2E 16 DD A2 68 10 32 A2 60 62 68 41 46 01 32 1F 60 59 60 62 60 07 2A F0 DD 06 98 29 1C 22 1C FF F7 C0 FE 00 28 00 D0 EF E0 10 3E 17 AB 10 2E E8 DC AB 46 1D 1C 3B 1C 4F 46 99 46 A3 68 F3 18 A3 60 63 68 4A 46 01 33 2A 60 6E 60 63 60 07 2B 01 DD 00 F0 94 FC 08 35 56 46 33 78 00 2B 0C D0 01 23 6B 60 A3 68 01 33 A3 60 63 68 01 33 2E 60 63 60 07 2B 00 DD D7 E3 08 35 0E 98 00 28 0D D0 3D AB 2B 60 02 23 6B 60 A3 68 02 33 A3 60 63 68 01 33 63 60 07 2B 00 DD D1 E3 08 35 0C 99 80 29 00 D1 00 E3 0F 9A 09 9B D6 1A 00 2E 3D DD 10 2E 01 DC 00 F0 59 FD 8C 49 10 22 90 46 89 46 92 46 5A 46 2B 1C BB 46 C8 44 06 9D 17 1C 03 E0 10 3E 08 33 10 2E 17 DD A2 68 10 32 A2 60 62 68 40 46 51 46 01 32 18 60 59 60 62 60 07 2A EF DD 28 1C 39 1C 22 1C FF F7 56 FE 00 28 00 D0 26 E3 10 3E 17 AB 10 2E E7 DC 1D 1C 3B 1C 5F 46 9B 46 4B 46 10 33 2B 60 A3 68 6E 60 F6 18 63 68 01 33 A6 60 63 60 07 2B 00 DD 75 E3 08 35 05 9A D2 05 00 D5 4C E2 0D 9B 09 9E 2B 60 A3 68 6E 60 F3 18 A3 60 63 68 01 33 63 60 07 2B 00 DD 10 E3 2B 1C 08 33 05 99 49 07 3A D5 0B 9A 08 98 16 1A 00 2E 35 DD 10 2E 01 DC 00 F0 97 FE 5F 4A B8 46 10 25 17 1C 03 E0 10 3E 08 33 10 2E 14 DD A2 68 10 32 A2 60 62 68 01 32 1F 60 5D 60 62 60 07 2A F1 DD 06 98 59 46 22 1C FF F7 06 FE 00 28 37 D1 10 3E 17 AB 10 2E EA DC B9 46 47 46 48 46 5E 60 18 60 A3 68 F6 18 63 68 01 33 A6 60 63 60 07 2B 07 DD 06 98 59 46 22 1C FF F7 EE FD 00 28 1F D1 A6 68 08 9B 0B 99 8B 42 00 DA 0B 1C 0A 9A D2 18 0A 92 00 2E 00 D0 CE E2 07 9E 00 23 63 60 B1 46 17 AD 96 E6 3E 4E 92 00 B2 58 97 46 06 98 59 46 22 1C FF F7 D1 FD 00 28 02 D1 17 AD A5 E6 AB 46 58 46 83 89 59 06 02 D5 01 22 52 42 0A 92 0A 98 3E B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 52 46 13 78 00 2B 01 D0 00 F0 33 FC 20 23 13 70 07 9B 07 93 A5 E6 07 9A 07 9B 12 68 04 33 0B 92 00 2A F6 DA 52 42 0B 92 05 9E 04 22 16 43 05 96 07 93 96 E6 2B 23 52 46 13 70 07 9B 07 93 90 E6 07 9B F1 E7 3B 78 01 37 2A 2B 01 D1 00 F0 3D FF 1A 1C 30 3A 09 2A 01 D9 00 F0 AC FE 00 26 B3 00 9E 19 3B 78 76 00 B6 18 1A 1C 30 3A 01 37 09 2A F5 D9 00 2E B0 46 00 DB 75 E6 01 26 72 42 90 46 71 E6 05 9E 01 23 1E 43 07 9B 05 96 07 93 68 E6 05 9E 80 23 1E 43 07 9B 05 96 07 93 61 E6 1A 1C 00 26 30 3A B3 00 9E 19 3B 78 76 00 96 19 1A 1C 30 3A 01 37 09 2A F5 D9 0B 96 54 E6 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? 05 9E 10 93 10 23 1E 43 05 96 05 98 C0 06 00 D5 A7 E2 05 9B 5B 06 00 D4 A3 E2 07 9E 07 98 04 36 0C 96 06 68 36 04 36 14 00 2E 00 DA A1 E2 32 1C 53 1E 9A 41 01 23 40 46 00 28 03 DB 05 98 80 21 88 43 05 90 41 46 00 29 02 D1 00 2A 00 D1 A1 E1 01 2B 00 D1 FA E2 02 2B 00 D1 E7 E2 0D 94 07 22 21 1C 33 1C 13 40 01 39 30 33 F6 08 0B 70 00 2E F7 D1 05 9A 0D 91 D2 07 00 D5 8C E3 63 1A 09 93 09 9E 08 96 46 45 01 DA 40 46 08 90 50 46 03 78 0C 98 41 46 0F 91 07 90 00 2B 00 D1 16 E6 08 99 01 31 08 91 12 E6 05 99 10 93 07 9B 09 07 00 D4 80 E3 1A 1C 1E 68 5B 68 08 32 07 92 12 96 13 93 99 46 30 1C 49 46 ?? ?? ?? ?? 00 28 01 D1 00 F0 3A FC 30 1C 49 46 DB 4B D9 4A ?? ?? ?? ?? 00 28 00 DA D0 E3 50 46 03 78 10 9A 47 2A 00 DD C7 E3 D5 4E 0D 96 05 99 80 22 91 43 00 26 03 22 05 91 08 92 09 92 0F 96 C7 E7 05 9A 63 46 1A 43 07 9B 05 92 07 93 C2 E5 05 98 10 93 10 23 18 43 05 90 05 99 C9 06 00 D5 29 E2 05 9E 76 06 00 D4 25 E2 07 99 07 98 0E 88 04 30 32 1C 0C 90 53 1E 9A 41 00 23 00 21 50 46 01 70 75 E7 05 98 10 93 10 23 18 43 05 90 05 99 C9 06 00 D5 19 E2 05 9E 76 06 00 D4 15 E2 07 99 07 98 0E 88 04 30 32 1C 53 1E 9A 41 0C 90 01 23 E4 E7 B4 48 15 90 05 98 10 93 C0 06 00 D5 8E E0 05 9B 5B 06 00 D4 8A E0 07 9E 07 98 04 36 0C 96 06 88 32 1C 53 1E 9A 41 00 2A 0E D0 05 9B DB 07 0B D5 10 A8 00 78 3D AB 30 22 05 99 1A 70 58 70 02 23 19 43 05 91 01 22 C0 E7 02 23 BE E7 07 9E 32 68 10 93 27 AB 1A 70 00 21 01 22 50 46 04 36 01 70 07 96 08 92 09 92 0D 93 72 E5 05 9E 07 9B 06 43 05 96 07 93 56 E5 05 9A 07 9B 0A 43 05 92 07 93 50 E5 05 99 C9 06 00 D4 E1 E2 07 9E 07 9A 33 68 0A 98 91 46 04 22 91 44 18 60 0C E5 07 9E 07 98 05 99 04 36 02 23 19 43 30 22 3D AB 0C 96 06 68 1A 70 78 22 5A 70 32 1C 53 1E 9A 41 86 4B 78 20 15 93 05 91 02 23 10 90 7F E7 00 22 51 46 10 93 0A 70 07 9B 1E 1C 1B 68 04 36 07 96 0D 93 00 2B 01 D1 00 F0 92 FC 46 46 00 2E 01 DA 00 F0 76 FC 0D 98 00 21 42 46 ?? ?? ?? ?? 00 28 01 D1 00 F0 D3 FC 0D 9B C0 1A 09 90 40 45 00 DC F1 E3 46 46 50 46 00 21 08 96 03 78 09 96 0F 91 00 E7 6E 4E 05 98 10 93 15 96 C0 06 00 D4 70 E7 07 99 04 31 0C 91 07 9A 16 68 73 E7 05 9B 0B 43 05 93 07 9B 07 93 EF E4 10 93 A4 E6 10 93 2D E7 10 93 45 E7 A3 68 00 2B 00 D1 25 E6 06 98 59 46 22 1C FF F7 ED FB 1F E6 10 98 65 28 00 DC DF E0 12 98 13 99 56 4B 55 4A ?? ?? ?? ?? 00 28 00 D0 56 E1 57 4B 2B 60 01 23 6B 60 A3 68 01 33 A3 60 63 68 01 33 63 60 07 2B 00 DD BE E2 2B 1C 08 33 3C 9A 11 99 8A 42 03 DB 05 9A D2 07 00 D4 9D E5 01 22 5A 60 A2 68 01 32 A2 60 62 68 16 9E 01 32 1E 60 62 60 07 2A 00 DD 9F E3 08 33 11 9E 01 3E 00 2E 00 DC 8A E5 10 2E 01 DC 00 F0 50 FD 41 49 10 22 0D 1C BA 46 89 46 10 35 90 46 5F 46 03 E0 08 33 10 3E 10 2E 79 DD A2 68 10 32 A2 60 62 68 40 46 01 32 1D 60 58 60 62 60 07 2A F0 DD 06 98 39 1C 22 1C FF F7 94 FB 00 28 65 D1 17 AB E8 E7 00 2B 0A D1 05 98 C0 07 07 D5 69 46 C3 31 30 23 01 22 0D 91 0B 70 09 92 68 E6 00 23 0D 94 09 93 64 E6 0B 9A 08 9B D6 1A 00 2E 00 DC F8 E4 10 2E 01 DC 00 F0 25 FC 23 49 10 22 90 46 89 46 92 46 5A 46 2B 1C BB 46 C8 44 06 9D 17 1C 03 E0 10 3E 08 33 10 2E 16 DD A2 68 10 32 A2 60 62 68 40 46 51 46 01 32 18 60 59 60 62 60 07 2A EF DD 28 1C 39 1C 22 1C FF F7 54 FB 00 28 25 D1 10 3E 17 AB 10 2E E8 DC 1D 1C 3B 1C 5F 46 9B 46 4B 46 10 33 2B 60 A3 68 F3 18 A3 60 63 68 01 33 6E 60 63 60 07 2B 00 DD A1 E1 08 35 BA E4 C0 46 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? BB 46 5D E5 BB 46 57 46 4A 46 10 32 1A 60 A2 68 5E 60 B2 18 A2 60 62 68 01 32 62 60 07 2A 00 DC EF E4 06 98 59 46 22 1C FF F7 16 FB 00 28 00 D0 46 E5 17 AB E6 E4 06 98 59 46 22 1C FF F7 0C FB 00 28 00 D1 28 E5 3B E5 11 9A 01 2A 00 DC 47 E1 01 23 6B 60 A3 68 01 33 A3 60 63 68 0D 98 01 33 28 60 63 60 07 2B 00 DD 45 E1 08 35 01 23 6B 60 A3 68 01 33 A3 60 63 68 16 99 01 33 29 60 63 60 07 2B 00 DD 42 E1 08 35 12 98 13 99 E1 4B E0 4A ?? ?? ?? ?? 00 28 00 D1 D6 E0 0D 9B 01 33 2B 60 11 9B A2 68 01 3B 6B 60 9B 18 A3 60 63 68 01 33 63 60 07 2B 00 DD 08 E1 08 35 38 AB 14 98 2B 60 A3 68 68 60 C3 18 94 E4 06 98 59 46 22 1C FF F7 C3 FA 00 28 00 D0 F3 E4 17 AD 80 E4 06 98 59 46 22 1C FF F7 B9 FA 00 28 00 D0 E9 E4 17 AD FF F7 1E FC 06 98 59 46 22 1C FF F7 AE FA 00 28 00 D0 DE E4 17 AD 24 E4 07 99 04 31 0C 91 07 9A 16 68 00 2E 00 DB 5D E5 2D 23 50 46 76 42 03 70 58 E5 07 9A 04 32 07 9B 0C 92 1E 68 32 1C 53 1E 9A 41 00 23 D8 E5 07 9A 04 32 07 9B 0C 92 1E 68 32 1C 53 1E 9A 41 01 23 CE E5 3C 9E 00 2E 00 DC 7B E1 11 98 86 42 00 DA 18 E1 A3 68 C3 18 A3 60 63 68 0D 99 01 33 29 60 68 60 63 60 07 2B 00 DD 08 E3 2B 1C 08 33 11 9A B6 1A 00 2E 00 DC 3C E1 10 2E 01 DC 00 F0 20 FC A4 49 06 98 0D 1C 10 22 BA 46 89 46 5F 46 10 35 90 46 83 46 04 E0 08 33 10 3E 10 2E 00 DC 18 E1 A2 68 10 32 A2 60 62 68 41 46 01 32 1D 60 59 60 62 60 07 2A EF DD 58 46 39 1C 22 1C FF F7 49 FA 00 28 00 D0 19 E7 17 AB E6 E7 0D 94 15 98 0F 22 23 1C 31 1C 11 40 41 5C 01 3B 36 09 19 70 00 2E F7 D1 E6 1A 0D 93 09 96 19 E5 09 2E 00 D8 E4 E2 2B 1C B9 46 25 1C 1F 1C 30 1C 0A 21 ?? ?? ?? ?? 01 3D 30 30 28 70 0A 21 30 1C ?? ?? ?? ?? 06 1C 09 28 F1 D8 3B 1C 4F 46 A9 46 1D 1C 4A 46 01 3A 30 36 A3 1A 0D 92 16 70 09 93 F8 E4 06 98 59 46 22 1C FF F7 0E FA 00 28 00 D0 3E E4 17 AD FF F7 62 FB 11 9E 01 3E 00 2E 00 DC 33 E7 10 2E 00 DC 7F E3 6F 4B 10 20 99 46 5A 46 80 46 2B 1C BB 46 C8 44 82 46 06 9D 17 1C 03 E0 10 3E 08 33 10 2E 17 DD 52 46 5A 60 A2 68 10 32 A2 60 62 68 41 46 01 32 19 60 62 60 07 2A EF DD 28 1C 39 1C 22 1C FF F7 DF F9 00 28 00 D0 AF E6 10 3E 17 AB 10 2E E7 DC 1D 1C 3B 1C 5F 46 9B 46 4B 46 10 33 2B 60 A3 68 F3 18 A3 60 63 68 01 33 6E 60 63 60 07 2B 00 DC F6 E6 06 98 59 46 22 1C FF F7 C2 F9 00 28 01 D0 FF F7 F2 FB 17 AD EC E6 05 9E 01 23 1E 42 00 D0 B2 E6 0D 9E 6B 60 A3 68 2E 60 01 33 D9 E6 06 98 59 46 22 1C FF F7 AC F9 00 28 01 D0 FF F7 DC FB 17 AD AF E6 06 98 59 46 22 1C FF F7 A1 F9 00 28 01 D0 FF F7 D1 FB 17 AD B2 E6 06 98 59 46 22 1C FF F7 96 F9 00 28 01 D0 FF F7 C6 FB 17 AD FF F7 0F FB 30 2B 00 D1 ED E1 0D 98 01 38 30 23 21 1A 0D 90 03 70 09 91 69 E4 07 9B 07 93 FF F7 74 FA 07 98 1E 68 5B 68 08 30 07 90 99 46 12 96 13 93 7D E4 05 99 49 06 00 D4 62 E1 07 9E 07 9A 68 46 28 21 33 68 08 5A 91 46 04 22 91 44 18 80 FF F7 24 FA A3 68 F3 18 A3 60 63 68 0D 99 01 33 29 60 6E 60 63 60 07 2B 00 DD D7 E1 2B 1C 08 33 16 9A 1A 60 01 22 5A 60 A2 68 01 32 A2 60 62 68 01 32 35 1C 62 60 07 2A 00 DD D3 E1 08 33 11 99 8A 1B 0D 98 5A 60 A2 68 45 19 92 1B 1D 60 52 18 1D E6 BB 46 57 46 4A 46 10 32 1A 60 A2 68 B2 18 A2 60 62 68 01 32 5E 60 62 60 07 2A 00 DD 5E E2 08 33 05 9E 01 22 16 42 01 D1 FF F7 00 FB 16 98 5A 60 A2 68 18 60 01 32 01 E6 00 00 00 00 00 00 00 00 ?? ?? ?? ?? DF 48 81 46 FF F7 CF FA DE 48 0D 90 36 E4 2D 23 51 46 0B 70 2C E4 06 98 59 46 22 1C FF F7 0E F9 00 28 01 D0 FF F7 3E FB 17 AB 37 E5 D6 4B 2B 60 01 23 6B 60 A3 68 01 33 A3 60 63 68 01 33 63 60 07 2B 00 DD 16 E1 2B 1C 08 33 00 2E 07 D1 11 99 00 29 04 D1 05 9A D2 07 01 D4 FF F7 C5 FA 01 22 5A 60 A2 68 01 32 A2 60 62 68 16 98 01 32 18 60 62 60 07 2A 00 DD B2 E1 08 33 76 42 00 2E 00 DC 25 E1 10 2E 00 DC A8 E2 BD 4A 10 20 15 1C BA 46 91 46 10 35 80 46 5F 46 04 E0 08 33 10 3E 10 2E 00 DC 04 E1 A2 68 10 32 A2 60 62 68 41 46 01 32 1D 60 59 60 62 60 07 2A EF DD 06 98 39 1C 22 1C FF F7 BC F8 00 28 00 D0 8C E5 17 AB E6 E7 30 1C 49 46 ?? ?? ?? ?? 00 28 00 D0 B8 E0 43 46 01 33 00 D1 EE E1 10 99 47 29 00 D1 E3 E1 67 29 00 D1 E0 E1 05 98 80 23 5B 00 18 43 32 1C 4B 46 34 92 35 93 34 9B 05 90 00 2B 00 DA 1A E2 00 21 0C 91 10 9B 46 3B 59 42 59 41 10 9B 66 3B 5A 42 53 41 08 1C 18 43 0E 90 00 D1 4D E1 41 46 03 20 09 91 84 46 09 9B 00 93 3C AB 01 93 3B AB 02 93 3A AB 03 93 06 98 31 1C 4A 46 63 46 ?? ?? ?? ?? 0D 90 10 98 47 28 00 D1 2F E1 67 28 00 D1 2C E1 0D 9B 09 98 0E 99 1B 18 08 93 00 29 08 D0 0D 9A 13 78 30 2B 00 D1 8D E0 3C 9B 08 99 C9 18 08 91 30 1C 49 46 82 4A 82 4B ?? ?? ?? ?? 00 28 00 D0 76 E1 08 9A 3A 92 08 98 0D 99 10 9A 40 1A 11 90 47 2A 00 D1 30 E1 67 2A 00 D1 2D E1 10 99 65 29 00 DC DA E1 10 9E 66 2E 00 D1 03 E2 3C 98 09 90 11 9B 09 9E B3 42 00 DD C2 E1 05 98 C0 07 00 D5 EF E1 08 96 00 2E 00 DA 18 E2 67 22 10 92 0C 9A 00 2A 00 D1 08 E1 2D 23 56 46 00 20 33 70 0F 90 FF F7 1A FB 09 9A 08 92 00 2A 48 DB 56 46 00 20 33 78 0F 90 FF F7 0D FB 06 98 59 46 22 1C FF F7 16 F8 00 28 01 D0 FF F7 46 FA 17 AB 55 E4 07 9A 07 99 13 68 0A 9E 89 46 04 21 89 44 1E 60 FF F7 C3 F8 06 98 40 21 ?? ?? ?? ?? 5A 46 10 60 10 61 00 28 00 D1 E8 E1 40 23 59 46 4B 61 FF F7 A7 F8 10 98 47 28 00 DD 0C E1 4F 49 0D 91 05 9E 80 23 9E 43 03 21 50 46 00 22 05 96 03 78 08 91 09 91 0F 92 FF F7 D6 FA 06 98 59 46 22 1C FE F7 DF FF 00 28 01 D0 FF F7 0F FA 17 AB 3C 9E DE E6 00 23 08 93 B3 E7 30 1C 49 46 3D 4A 3D 4B ?? ?? ?? ?? 00 28 00 D1 68 E7 09 98 01 23 1B 1A 3C 93 64 E7 BB 46 57 46 4A 46 10 32 1A 60 A2 68 B2 18 A2 60 62 68 01 32 5E 60 62 60 07 2A 00 DD 2C E1 08 33 0D 9A 11 9E 1A 60 A2 68 5E 60 B2 18 8D E4 0D 98 ?? ?? ?? ?? 09 90 08 90 00 28 00 DA E0 E0 52 46 00 26 13 78 0F 96 FF F7 94 FA 21 4A 91 46 FF F7 EA F8 0D 9E A6 1B 09 96 FF F7 7F FA 40 46 09 90 06 28 06 D9 06 20 09 90 08 90 1F 4B 0D 93 FF F7 98 F8 09 99 08 91 00 29 F7 DA 00 22 08 92 F4 E7 14 49 89 46 FF F7 85 F9 06 98 59 46 22 1C FE F7 7E FF 00 28 01 D0 FF F7 AE F9 17 AB 3C 9E 1D E6 06 98 59 46 22 1C FE F7 72 FF 00 28 01 D0 FF F7 A2 F9 17 AB 3C 9E 20 E6 06 98 59 46 22 1C }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "_realloc_r"
		size = 848
		refs = "001e __malloc_lock 0160 __malloc_unlock 01a2 _free_r 01ac _malloc_r 0280 memmove 034c __malloc_av_"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 82 B0 80 46 0E 1C 17 1C 00 29 00 D1 09 E1 34 1C 08 3C ?? ?? ?? ?? 3D 1C 63 68 0B 35 1A 1C 16 2D 11 D8 10 21 10 25 00 20 00 91 BD 42 11 D2 0C 23 42 46 13 60 00 27 02 B0 38 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 07 21 8D 43 00 95 E8 0F BD 42 ED D3 00 28 EB D1 18 1C 03 21 88 43 81 46 00 98 81 45 66 DA B6 48 80 68 49 46 62 18 84 46 94 45 00 D1 E0 E0 51 68 01 20 01 91 81 43 8B 46 93 44 59 46 49 68 01 42 68 D0 00 20 00 22 D9 07 00 D5 84 E0 23 68 E3 1A 9B 46 5B 68 9A 46 51 46 03 23 99 43 0B 1C 00 2A 00 D1 EF E0 62 45 00 D1 EF E0 4B 44 C0 18 00 99 82 46 8A 45 00 DB B6 E0 9A 46 00 99 8A 45 6A DB 5A 46 D3 68 92 68 D3 60 9A 60 4A 46 5F 46 04 3A 08 37 24 2A 00 D9 CD E0 39 1C 13 2A 1A D9 33 1C 02 CB 58 46 81 60 71 68 C1 60 59 46 10 31 1E 1D 1B 2A 0F D9 5B 68 03 61 71 68 33 1D 41 61 59 46 18 31 1E 1D 24 2A 05 D1 5B 68 83 61 73 68 C3 61 08 31 08 36 32 1C 01 CA 0B 1C 01 C3 70 68 48 60 52 68 5A 60 59 46 4A 68 5C 46 02 E0 27 1C 08 37 CA 46 50 46 43 1B 0F 2B 1C D8 01 23 1A 40 51 46 0A 43 62 60 54 44 62 68 13 43 63 60 40 46 ?? ?? ?? ?? 6D E7 01 98 03 21 88 43 82 46 00 99 CA 44 8A 45 90 DB D1 68 92 68 27 1C D1 60 8A 60 08 37 1A 1C DE E7 01 20 02 40 61 19 15 43 1A 1C 02 43 65 60 4A 60 CB 18 5A 68 10 43 58 60 08 31 40 46 ?? ?? ?? ?? DA E7 39 1C 40 46 ?? ?? ?? ?? 07 1C 00 28 D3 D0 62 68 03 1C 01 21 10 1C 88 43 08 3B 21 18 8B 42 00 D1 B3 E0 4A 46 04 3A 24 2A 54 D8 31 1C 3B 1C 13 2A 19 D9 34 1C 08 CC 38 1C 08 C0 73 68 21 1D 7B 60 03 1D 1B 2A 0F D9 64 68 44 60 0C 1D 49 68 18 1D 59 60 03 1D 21 1D 24 2A 05 D1 62 68 42 60 4A 68 08 31 5A 60 08 33 08 1C 10 C8 1A 1C 10 C2 49 68 59 60 43 68 53 60 40 46 31 1C ?? ?? ?? ?? 40 46 ?? ?? ?? ?? 09 E7 11 1C ?? ?? ?? ?? 07 1C 04 E7 D3 68 92 68 D3 60 9A 60 47 E7 42 68 03 21 10 1C 88 43 49 46 42 18 10 21 49 19 8A 46 52 45 01 DA 62 46 1D E7 3B 4B 61 19 99 60 52 1B 01 23 1A 43 4A 60 62 68 13 40 1D 43 65 60 40 46 ?? ?? ?? ?? 37 1C E2 E6 38 1C 31 1C ?? ?? ?? ?? CB E7 38 1C 31 1C ?? ?? ?? ?? 5B 46 5A 68 5C 46 56 E7 8A 46 CA 44 17 E7 8A 46 CA 44 2B 1C 50 44 10 33 01 90 98 42 00 DA 0E E7 58 46 82 68 C3 68 D3 60 9A 60 4A 46 5F 46 04 3A 08 37 24 2A 3E D8 39 1C 13 2A 19 D9 33 1C 02 CB 81 60 71 68 C1 60 59 46 10 31 1E 1D 1B 2A 0F D9 5B 68 03 61 71 68 33 1D 41 61 59 46 18 31 1E 1D 24 2A 05 D1 5B 68 83 61 73 68 C3 61 08 31 08 36 32 1C 01 CA 0B 1C 01 C3 70 68 48 60 52 68 5A 60 59 46 4A 19 0E 4B 01 99 9A 60 48 1B 01 23 18 43 50 60 58 46 42 68 13 40 1D 43 45 60 40 46 ?? ?? ?? ?? 87 E6 5B 68 03 21 8B 43 9A 46 27 1C CA 44 08 37 00 E7 38 1C 31 1C ?? ?? ?? ?? E0 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_149_0_0 {
	meta:
		name = "_stat_r"
		size = 40
		refs = "000e _stat 0024 errno"
	strings:
		$1 = { 30 B5 08 4C 00 23 05 1C 23 60 08 1C 11 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "_fstat_r"
		size = 40
		refs = "000e _fstat 0024 errno"
	strings:
		$1 = { 30 B5 08 4C 00 23 05 1C 23 60 08 1C 11 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_435_0_0 {
	meta:
		name = "_gettimeofday_r"
		size = 40
		refs = "000e _gettimeofday 0024 errno"
	strings:
		$1 = { 30 B5 08 4C 00 23 05 1C 23 60 08 1C 11 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_275_1_0 {
	meta:
		name = "_kill_r"
		size = 40
		refs = "000e _kill 0024 errno"
	strings:
		$1 = { 30 B5 08 4C 00 23 05 1C 23 60 08 1C 11 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "_link_r"
		size = 40
		refs = "000e _link 0024 errno"
	strings:
		$1 = { 30 B5 08 4C 00 23 05 1C 23 60 08 1C 11 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "argz_count"
		size = 36
	strings:
		$1 = { 10 B5 03 1C 00 29 0B D0 00 24 00 20 00 22 1C 5D 00 2C 00 D1 01 30 01 32 14 1C 8A 42 F7 D1 10 BD 00 20 FC E7 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "_fgetws_r"
		size = 272
		refs = "004a memchr 0064 _mbsrtowcs_r 00b4 __srefill_r 00e4 mbsinit 0102 __errno"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 83 B0 01 91 17 1C 1C 1C 9A 89 80 23 9B 01 80 46 1A 42 04 D1 1A 43 A2 81 62 6E 13 43 63 66 00 2F 69 DD 62 68 00 2A 5E DD 5C 23 1B 19 9A 46 02 AB 99 46 20 68 01 23 01 9E 9B 46 0A 21 02 90 ?? ?? ?? ?? 00 28 3C D0 23 68 5A 46 D3 1A C3 18 52 46 00 92 40 46 31 1C 4A 46 ?? ?? ?? ?? 05 1C 43 1C 14 D0 02 98 00 28 2D D0 23 68 62 68 9A 18 12 1A 7F 1B AD 00 62 60 76 19 33 1F 1B 68 20 60 0A 2B 01 D0 01 2F 0C DC 01 9A 96 42 24 D1 00 23 01 93 01 98 03 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 2A CA DC 40 46 21 1C ?? ?? ?? ?? 00 28 EA D1 20 68 62 68 0A 21 02 90 ?? ?? ?? ?? 00 28 C2 D1 63 68 C4 E7 20 68 62 68 00 21 ?? ?? ?? ?? 01 30 01 35 02 90 C8 E7 50 46 ?? ?? ?? ?? 00 28 D5 D0 00 23 33 60 D4 E7 40 46 21 1C ?? ?? ?? ?? 00 28 CC D1 62 68 98 E7 ?? ?? ?? ?? 16 23 00 22 03 60 01 92 C5 E7 }
	condition:
		$1
}

rule file_152_1_0 {
	meta:
		name = "fgetws"
		size = 44
		refs = "0016 __sinit 0022 _fgetws_r 0028 _impure_ptr"
	strings:
		$1 = { F0 B5 09 4C 06 1C 20 68 0D 1C 17 1C 00 28 05 D0 83 6B 00 2B 02 D1 ?? ?? ?? ?? 20 68 31 1C 2A 1C 3B 1C ?? ?? ?? ?? F0 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_408_3_0 {
	meta:
		name = "vfiscanf"
		size = 44
		refs = "0016 __sinit 0022 __svfiscanf_r 0028 _impure_ptr"
	strings:
		$1 = { F0 B5 09 4C 06 1C 20 68 0D 1C 17 1C 00 28 05 D0 83 6B 00 2B 02 D1 ?? ?? ?? ?? 20 68 31 1C 2A 1C 3B 1C ?? ?? ?? ?? F0 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_314_3_0 {
	meta:
		name = "vfscanf"
		size = 44
		refs = "0016 __sinit 0022 __svfscanf_r 0028 _impure_ptr"
	strings:
		$1 = { F0 B5 09 4C 06 1C 20 68 0D 1C 17 1C 00 28 05 D0 83 6B 00 2B 02 D1 ?? ?? ?? ?? 20 68 31 1C 2A 1C 3B 1C ?? ?? ?? ?? F0 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_153_1_0 {
	meta:
		name = "__numeric_load_locale"
		size = 72
		refs = "001c __part_load_locale 0034 __fix_locale_grouping_str 003c __nlocale_changed"
	strings:
		$1 = { 30 B5 0E 4B 0E 4C 01 22 1A 60 83 B0 03 23 00 93 01 93 23 1D 02 93 22 69 21 1C 0A 4B ?? ?? ?? ?? 05 1C 00 28 02 D1 23 68 00 2B 02 D1 03 B0 28 1C 30 BD E0 68 ?? ?? ?? ?? E0 60 F7 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "_fread_r"
		size = 368
		refs = "0068 memcpy 0078 __srefill_r 0086 __udivsi3 00ec _free_r 0140 __sinit"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 93 46 0E 1C 59 46 59 43 82 B0 07 1C 9A 46 0B 9C 89 46 00 29 3C D0 00 28 03 D0 83 6B 00 2B 00 D1 88 E0 80 23 A2 89 9B 01 1A 42 06 D1 13 43 A3 81 62 6E 4B 4B 13 40 63 66 A2 89 65 68 00 2D 2A DB 2B 1C B0 46 91 07 2C D4 4E 46 01 E0 A8 44 65 68 AE 42 00 D8 77 E0 21 68 40 46 2A 1C ?? ?? ?? ?? 23 68 5B 19 23 60 38 1C 21 1C 76 1B ?? ?? ?? ?? 00 28 EB D0 4A 46 90 1B 59 46 ?? ?? ?? ?? 82 46 02 B0 50 46 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 22 92 46 F4 E7 00 23 63 60 00 25 B0 46 91 07 D2 D5 00 93 4B 45 01 D9 4A 46 00 92 21 68 00 9A 30 1C ?? ?? ?? ?? 21 68 00 9A 88 46 90 44 43 46 23 60 63 68 49 46 9B 1A 8D 1A 63 60 21 6B 00 2D D6 D0 00 29 0A D0 23 1C 40 33 99 42 04 D0 38 1C ?? ?? ?? ?? 22 68 90 46 00 23 23 63 00 9B 21 69 62 69 F6 18 00 91 01 92 01 E0 00 2D C0 D0 26 61 65 61 26 60 21 1C 38 1C ?? ?? ?? ?? 00 9B 23 61 63 68 01 99 42 46 ED 1A F6 18 00 23 61 61 22 60 63 60 00 28 E9 D0 49 46 48 1B 59 46 ?? ?? ?? ?? 82 46 A5 E7 ?? ?? ?? ?? 80 23 A2 89 9B 01 1A 42 00 D0 7A E7 72 E7 32 1C 21 68 40 46 ?? ?? ?? ?? 63 68 9B 1B 63 60 23 68 9E 19 26 60 90 E7 C0 46 FF DF FF FF }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "_wcsrtombs_r"
		size = 194
		refs = "003a _wcrtomb_r"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 86 B0 02 90 01 91 90 46 99 46 0F 9D 00 29 4B D0 16 68 00 2B 4D D0 00 21 01 9F 8A 46 03 AC 29 68 6A 68 8B 46 00 92 2B 1C 32 68 02 98 21 1C ?? ?? ?? ?? 43 1C 28 D0 52 46 13 18 4B 45 17 D8 01 99 00 29 0C D0 00 28 06 DD 00 22 A1 5C B9 54 01 32 90 42 FA D1 3F 18 41 46 0A 68 04 32 0A 60 32 68 00 2A 18 D0 4B 45 07 D2 04 36 9A 46 D7 E7 00 9B 5A 46 2A 60 6B 60 53 46 06 B0 18 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 02 99 8A 23 0B 60 00 23 2B 60 03 1C F0 E7 01 99 00 29 01 D0 41 46 0A 60 00 22 2A 60 01 3B E7 E7 16 68 01 22 53 42 99 46 B1 E7 00 23 E0 E7 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "_rename_r"
		size = 36
		refs = "0006 _link_r 0018 _unlink_r"
	strings:
		$1 = { 30 B5 05 1C 0C 1C ?? ?? ?? ?? 01 30 02 D1 01 20 40 42 30 BD 28 1C 21 1C ?? ?? ?? ?? 01 30 F6 D0 00 20 F6 E7 }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "modff"
		size = 64
		refs = "0020 __subsf3"
	strings:
		$1 = { 10 B5 42 00 12 0E 7F 3A 03 1C 16 2A 0B DC 00 2A 0E DB 0A 4C 14 41 04 42 05 D0 A3 43 0B 60 19 1C ?? ?? ?? ?? 03 E0 08 60 80 20 00 06 18 40 10 BD 80 22 12 06 13 40 0B 60 F9 E7 C0 46 FF FF 7F 00 }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "_tolower"
		size = 20
		refs = "0010 __ctype_ptr__"
		altNames = "tolower"
	strings:
		$1 = { 03 4B 1B 68 1B 18 5B 78 DA 07 00 D5 20 30 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "critical_factorization"
		size = 200
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 01 24 00 25 90 46 63 19 01 22 94 46 52 42 8B 42 0B D2 06 19 C7 5C B6 5C B7 42 31 D2 9C 1A A4 46 1D 1C 01 24 63 19 8B 42 F3 D3 63 46 44 46 23 60 01 24 63 42 00 25 01 26 9A 46 63 19 B1 46 99 42 0E D9 06 19 56 44 36 78 C7 5C B3 46 5F 45 26 D9 54 46 1C 1B A1 46 1D 1C 01 24 63 19 99 42 F0 D8 53 46 01 33 50 1C 83 42 01 D3 CC 46 18 1C 43 46 62 46 1A 60 3C BC 90 46 99 46 A2 46 AB 46 F0 BD B7 42 06 D0 01 26 6B 1C 2A 1C B4 46 01 24 1D 1C C8 E7 64 45 FA D0 2B 1C 01 34 1D 1C C2 E7 5F 45 06 D0 01 26 6B 1C AA 46 B1 46 01 24 1D 1C D4 E7 4C 45 FA D0 2B 1C 01 34 1D 1C CE E7 }
	condition:
		$1
}

rule file_159_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 676
		refs = "005c memcmp 009c memchr"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 A3 4C 83 25 A5 44 ED 00 6D 44 00 92 07 1C 89 46 10 1C 19 1C 2A 1C 1C 1C FF F7 88 FF 06 AB 83 46 10 C3 9D 42 FC D1 00 2C 0A D0 00 98 62 1E 00 23 C1 5C 06 AD 89 00 01 33 6A 50 01 3A 9C 42 F7 D8 83 20 C0 00 68 44 00 9A 01 68 10 1C 51 18 5A 46 ?? ?? ?? ?? 00 28 00 D0 8E E0 5B 46 01 3B F8 18 01 93 03 90 59 46 00 9A 01 23 58 46 02 39 18 1A 52 18 00 25 02 91 05 90 66 1E 04 92 A2 46 4A 46 2C 1C B8 46 53 46 41 46 E7 18 88 18 BA 1A 00 21 ?? ?? ?? ?? 00 28 58 D1 00 2F 56 D0 41 46 CB 19 01 3B 1B 78 06 AA 9B 00 D3 58 00 2B 56 D1 2B 1C 5D 45 00 D2 5B 46 B3 42 14 D2 00 9A D1 18 08 78 1A 19 42 44 84 46 10 78 84 45 38 D1 AC 46 05 E0 4D 78 50 78 01 31 01 32 85 42 30 D1 01 33 B3 42 F6 D3 65 46 5D 45 00 D3 C7 E0 00 9A 01 9B 03 98 D1 5C 02 5D 91 42 00 D0 BF E0 02 98 22 18 B1 46 04 99 42 44 A4 46 2E 1C 07 E0 0C 78 10 78 5D 1E 01 39 01 3A 84 42 02 D1 2B 1C 9E 42 F5 D3 35 1C 01 35 64 46 4E 46 9D 42 00 D9 AB E0 83 21 C9 00 69 44 0D 68 52 46 64 19 55 1B 3A 1C A2 E7 05 9D 2C 19 E4 18 00 25 3A 1C 9C E7 00 20 51 4B 9D 44 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 2D 08 D0 83 20 C0 00 68 44 02 68 93 42 02 D2 51 46 8B 1A 00 25 E4 18 3A 1C 85 E7 5A 46 A3 1A 5B 45 7A D3 01 20 40 42 83 25 82 46 ED 00 01 33 6D 44 DA 44 2B 60 5A 46 51 46 00 9B 00 98 02 3A 79 18 9B 18 02 91 01 1C 59 44 01 92 03 93 5A 46 01 23 9A 1A 05 91 04 92 5E 46 00 25 4A 46 A0 46 8B 46 41 46 6C 18 B8 18 00 21 A2 1A ?? ?? ?? ?? 00 28 BC D1 00 2C BA D0 3B 19 01 3B 1B 78 06 A8 9B 00 C3 58 00 2B 3E D1 01 21 49 42 89 46 C1 44 4E 45 18 D2 AA 19 5B 46 BA 18 19 78 13 78 99 42 45 D1 28 1C 59 46 4D 46 33 1C A4 46 81 46 05 E0 4C 78 50 78 01 31 01 32 84 42 27 D1 01 33 AB 42 F6 D3 64 46 4D 46 50 46 53 46 01 30 14 D0 00 9A 50 46 11 5C 02 98 42 5D 91 42 10 D1 01 98 2A 18 03 99 BA 18 A4 46 05 E0 0C 78 10 78 01 39 01 3A 84 42 03 D1 01 3B F7 D2 78 19 79 E7 64 46 83 22 D2 00 6A 44 13 68 ED 18 22 1C AA E7 64 46 4D 46 04 98 45 19 ED 18 22 1C A3 E7 5B 46 82 E7 5B 46 01 35 9D 42 00 D8 53 E7 47 46 38 19 60 E7 33 1C EE E7 C0 46 E4 FB FF FF 1C 04 00 00 }
	condition:
		$1
}

rule file_159_2_0 {
	meta:
		name = "strstr"
		size = 628
		refs = "0060 strchr 00ac memcmp 00e4 memchr"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 03 78 86 B0 05 1C 0E 1C 00 2B 00 D1 1E E1 0A 78 00 2A 13 D0 0C 1C 01 1C 01 20 02 E0 22 78 00 2A 14 D0 9B 1A 5A 42 53 41 01 31 18 40 0B 78 01 34 00 2B F3 D1 23 78 00 2B 08 D0 00 25 06 B0 28 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 28 F5 D1 68 1C 31 78 ?? ?? ?? ?? A4 1B 07 1C 00 28 10 D0 01 2C 0E D0 2D 19 A8 42 0D D9 01 20 80 46 1F 2C 0C D9 38 1C 41 46 32 1C 23 1C FF F7 69 FE 05 1C DC E7 3D 1C DA E7 2D 1A A8 46 F0 E7 21 1C 05 AA 30 1C FF F7 F9 FD 05 99 81 46 71 18 30 1C 4A 46 ?? ?? ?? ?? 00 28 62 D1 4A 46 01 3A 48 46 BB 18 02 38 00 92 02 93 32 18 01 90 01 23 48 46 18 1A 00 25 04 90 03 92 B3 46 42 46 2E 1C BA 46 37 19 53 46 98 18 00 21 BA 1A ?? ?? ?? ?? 00 28 AC D1 00 2F AA D0 2B 1C 4D 45 00 D2 4B 46 9C 42 16 D9 5A 46 D1 18 08 78 9A 19 52 44 84 46 10 78 84 45 00 D0 91 E0 AC 46 06 E0 4D 78 50 78 01 31 01 32 85 42 00 D0 88 E0 01 33 9C 42 F5 D8 65 46 A9 45 00 D8 96 E0 00 9B 58 46 C1 5C 02 98 82 5D 91 42 00 D0 8E E0 01 98 32 18 B4 46 03 99 52 44 2E 1C A0 46 07 E0 0C 78 10 78 5D 1E 01 39 01 3A 84 42 02 D1 2B 1C 9E 42 F5 D3 35 1C 44 46 66 46 01 35 9D 42 7E D8 05 9D 3A 1C 76 19 65 1B AF E7 48 46 23 1A 4B 45 00 D2 4B 46 01 33 05 93 48 46 01 23 18 1A 4B 46 02 3B 01 22 52 42 03 90 F0 18 93 46 B2 46 00 93 02 90 01 96 00 25 CA 44 CB 44 42 46 2E 19 B8 18 00 21 B2 1A ?? ?? ?? ?? 00 28 00 D0 43 E7 00 2E 00 D1 40 E7 4C 45 17 D9 4B 46 EA 18 BA 18 50 46 01 78 13 78 99 42 44 D1 AC 46 51 46 4B 46 25 1C 05 E0 4C 78 50 78 01 31 01 32 84 42 28 D1 01 33 9D 42 F6 D8 2C 1C 65 46 58 46 5B 46 01 30 32 D0 7A 19 01 98 90 46 5A 46 81 5C 40 46 58 44 02 78 91 42 1D D1 00 98 42 19 02 99 BA 18 A4 46 05 E0 0C 78 10 78 01 39 01 3A 84 42 10 D1 01 3B F7 D2 45 46 09 E7 04 9A 96 19 F6 18 00 25 3A 1C 4C E7 2C 1C 65 46 03 9A 55 19 ED 18 32 1C AE E7 64 46 05 9B 32 1C ED 18 A9 E7 0C 1C 01 20 F0 E6 4B 46 83 E7 4B 46 EE E7 7F 19 B8 46 45 46 EC E6 57 46 BD 19 E9 E6 }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "isnan"
		size = 28
		altNames = "__isnand"
	strings:
		$1 = { 4B 42 04 4A 0B 43 DB 0F 10 40 18 43 02 4B 18 1A C0 0F 70 47 FF FF FF 7F 00 00 F0 7F }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "asctime_r"
		size = 76
		refs = "0036 sprintf"
	strings:
		$1 = { 30 B5 82 69 0C 1C 51 00 8A 18 01 69 0C 4B 4D 00 69 18 9A 18 18 33 5B 18 C1 68 85 B0 00 91 81 68 01 91 41 68 02 91 01 68 03 91 41 69 05 48 09 18 04 91 20 1C 04 49 ?? ?? ?? ?? 05 B0 20 1C 30 BD ?? ?? ?? ?? 6C 07 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "wcschr"
		size = 18
	strings:
		$1 = { 03 68 8B 42 04 D0 00 2B 01 D0 04 30 F8 E7 00 20 70 47 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "_fputwc_r"
		size = 220
		refs = "003c _wcrtomb_r 00ba __swbuf_r 00d8 __mb_cur_max"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 14 1C 80 23 92 89 9B 01 81 B0 82 46 88 46 1A 42 04 D1 1A 43 A2 81 62 6E 13 43 63 66 43 46 00 2B 03 DD 2B 4B 1B 68 01 2B 32 D0 23 1C 5C 33 50 46 69 46 42 46 ?? ?? ?? ?? 6E 46 07 1C 43 1C 2E D0 00 28 31 D0 00 25 08 E0 23 68 72 5D 1A 70 23 68 01 33 23 60 01 35 BD 42 26 D2 A3 68 01 3B A3 60 00 2B F1 DA A2 69 93 42 20 DB 23 68 72 5D 1A 70 23 68 1A 78 0A 2A 22 D0 01 33 23 60 00 22 00 2A E8 D0 01 20 40 42 01 B0 0C BC 90 46 9A 46 F0 BD 43 46 FF 2B C9 DC 6E 46 33 70 01 27 D2 E7 A2 89 40 23 13 43 A3 81 EE E7 40 46 EC E7 22 1C 71 5D 50 46 ?? ?? ?? ?? 42 1C 53 42 5A 41 DF E7 22 1C 50 46 0A 21 ?? ?? ?? ?? 42 1C 53 42 5A 41 D6 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_168_1_0 {
	meta:
		name = "fputwc"
		size = 40
		refs = "0014 __sinit 001e _fputwc_r 0024 _impure_ptr"
	strings:
		$1 = { 70 B5 08 4C 06 1C 20 68 0D 1C 00 28 05 D0 83 6B 00 2B 02 D1 ?? ?? ?? ?? 20 68 31 1C 2A 1C ?? ?? ?? ?? 70 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_432_0_0 {
	meta:
		name = "fputc"
		size = 40
		refs = "0014 __sinit 001e _putc_r 0024 _impure_ptr"
	strings:
		$1 = { 70 B5 08 4C 06 1C 20 68 0D 1C 00 28 05 D0 83 6B 00 2B 02 D1 ?? ?? ?? ?? 20 68 31 1C 2A 1C ?? ?? ?? ?? 70 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_187_1_0 {
	meta:
		name = "fputws"
		size = 40
		refs = "0014 __sinit 001e _fputws_r 0024 _impure_ptr"
	strings:
		$1 = { 70 B5 08 4C 06 1C 20 68 0D 1C 00 28 05 D0 83 6B 00 2B 02 D1 ?? ?? ?? ?? 20 68 31 1C 2A 1C ?? ?? ?? ?? 70 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_383_1_0 {
	meta:
		name = "ungetwc"
		size = 40
		refs = "0014 __sinit 001e _ungetwc_r 0024 _impure_ptr"
	strings:
		$1 = { 70 B5 08 4C 06 1C 20 68 0D 1C 00 28 05 D0 83 6B 00 2B 02 D1 ?? ?? ?? ?? 20 68 31 1C 2A 1C ?? ?? ?? ?? 70 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "_viprintf_r"
		size = 16
		refs = "000a _vfiprintf_r"
	strings:
		$1 = { 10 B5 0C 1C 13 1C 81 68 22 1C ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_423_0_0 {
	meta:
		name = "_vprintf_r"
		size = 16
		refs = "000a _vfprintf_r"
	strings:
		$1 = { 10 B5 0C 1C 13 1C 81 68 22 1C ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_170_1_0 {
	meta:
		name = "viprintf"
		size = 24
		refs = "000c _vfiprintf_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0B 1C 03 49 02 1C 08 68 81 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_423_1_0 {
	meta:
		name = "vprintf"
		size = 24
		refs = "000c _vfprintf_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0B 1C 03 49 02 1C 08 68 81 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "__call_exitprocs"
		size = 248
		refs = "006e free 00f4 _global_impure_ptr"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 39 4B 83 B0 1B 68 02 90 A4 20 40 00 0F 1C 18 18 C4 21 4A 00 00 93 01 90 92 46 A4 23 00 98 5B 00 C5 58 00 2D 4B D0 01 99 C6 22 53 00 8B 46 98 46 6A 68 56 1E 0D D4 14 1C 21 34 A4 00 2C 19 00 2F 17 D0 23 1C 80 33 1B 68 BB 42 12 D0 04 3C 01 3E F5 D5 00 2A 44 D1 2B 68 00 2B 42 D0 5A 46 13 60 28 1C ?? ?? ?? ?? 58 46 03 68 00 2B 27 D0 1D 1C DE E7 21 1C 80 39 50 1E 0B 68 B0 42 29 D0 00 20 08 60 00 2B E2 D0 50 46 91 46 29 58 01 22 B2 40 0A 42 1B D0 40 46 29 58 0A 42 1D D1 21 68 02 98 00 F0 24 F8 6A 68 4A 45 B7 D1 59 46 0B 68 AB 42 CC D0 A4 23 00 98 5B 00 C5 58 00 2D B3 D1 03 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 F0 0E F8 E8 E7 6E 60 32 1C D4 E7 20 68 00 F0 07 F8 E1 E7 2B 68 AB 46 C1 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "wcscat"
		size = 40
	strings:
		$1 = { 03 68 00 2B 0E D0 03 1C 04 33 1A 68 00 2A FB D1 1A 1C 01 E0 08 C2 04 31 0B 68 00 2B FA D1 00 23 13 60 70 47 02 1C F7 E7 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "access"
		size = 42
		refs = "0008 stat"
	strings:
		$1 = { 30 B5 8F B0 0D 1C 69 46 ?? ?? ?? ?? 00 28 09 D1 01 9B 5A 04 03 D4 AA 07 01 D5 1A 06 02 D5 00 20 0F B0 30 BD 01 20 40 42 FA E7 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "_strtoull_r"
		size = 488
		refs = "005e __umoddi3 006e __udivdi3 00b8 __muldi3 01e4 __ctype_ptr__"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 98 46 75 4B 8C B0 0B 90 08 91 1E 68 09 92 0C 1C 08 22 25 78 73 19 5B 78 01 34 13 42 F9 D1 2D 2D 00 D1 A9 E0 2B 2D 00 D1 AB E0 00 21 0A 91 40 46 43 42 43 41 10 28 00 D1 6F E0 00 2B 00 D0 6C E0 43 46 DB 17 05 90 06 93 01 20 40 42 C1 17 05 9A 06 9B ?? ?? ?? ?? 04 90 05 9A 06 9B 01 20 40 42 C1 17 ?? ?? ?? ?? 07 90 04 20 82 46 03 20 00 22 00 23 81 46 01 20 0F 1C 83 46 00 21 00 92 01 93 24 E0 30 3D 45 45 30 DA 01 9B 9F 42 58 D3 9F 42 52 D0 00 29 54 DB 04 9B 9D 42 03 DD 07 98 00 99 88 42 53 D0 05 9A 06 9B 00 98 01 99 ?? ?? ?? ?? 02 95 ED 17 03 95 02 1C 0B 1C 02 98 03 99 80 18 59 41 00 90 01 91 01 21 25 78 01 34 73 19 5B 78 52 46 13 42 D5 D1 48 46 03 42 06 D0 5A 46 13 42 31 D1 57 23 ED 1A 45 45 CE DB 00 9A 01 9B 4D 1C 3B D0 0A 98 00 28 32 D1 09 9E 00 2E 04 D0 00 29 2A D1 08 98 09 99 08 60 0C B0 10 1C 19 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 30 2D 36 D0 00 2B 4D D0 30 2D 42 D0 0A 20 00 21 05 22 05 90 06 91 0A 21 04 92 88 46 8F E7 07 98 00 9A 90 42 A8 D2 01 21 49 42 C0 E7 37 23 ED 1A CC E7 01 9A 97 42 A8 D1 01 21 49 42 B7 E7 01 3C 08 94 D1 E7 15 1C 1E 1C 00 23 6A 42 B3 41 C6 E7 0B 9E 22 23 33 60 01 22 52 42 D3 17 BF E7 01 20 25 78 01 34 0A 90 55 E7 00 22 25 78 01 34 0A 92 50 E7 22 78 58 2A 01 D0 78 2A C3 D1 10 22 00 23 65 78 0F 21 05 92 06 93 10 23 02 34 04 91 98 46 55 E7 08 20 00 21 07 22 05 90 06 91 08 21 04 92 88 46 4C E7 41 46 05 91 C9 17 06 91 05 9A 06 9B 01 20 40 42 C1 17 ?? ?? ?? ?? 04 90 3F E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_177_0_0 {
	meta:
		name = "_gets_r"
		size = 76
		refs = "0030 __srget_r 0048 _impure_ptr"
	strings:
		$1 = { F0 B5 07 1C 0E 1C 0C 1C 0F 4D 09 E0 0B 68 18 78 01 33 0B 60 0A 28 0F D0 43 1C 11 D0 20 70 01 34 2B 68 59 68 4B 68 01 3B 4B 60 00 2B EE DA 38 1C ?? ?? ?? ?? 0A 28 EF D1 00 23 23 70 30 1C F0 BD B4 42 F9 D1 00 26 F9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_180_0_0 {
	meta:
		name = "_memalign_r"
		size = 232
		refs = "0048 _malloc_r 0054 __malloc_lock 0060 __umodsi3 00a0 _free_r 00b4 __malloc_unlock"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 05 1C 0C 1C 08 29 56 D9 0F 29 00 D8 10 24 17 1C 0B 37 16 2F 0C D8 00 23 10 27 97 42 01 D3 00 2B 0A D0 0C 23 2B 60 00 20 0C BC 90 46 9A 46 F0 BD 07 23 9F 43 FB 0F F0 E7 21 1C 10 31 C9 19 28 1C ?? ?? ?? ?? 80 46 00 28 EE D0 28 1C ?? ?? ?? ?? 46 46 40 46 21 1C 08 3E ?? ?? ?? ?? 00 28 1E D0 63 1E 43 44 62 42 13 40 08 3B 9A 46 9B 1B 0F 2B 32 DD 71 68 03 22 91 43 C9 1A 01 22 08 1C 10 43 54 46 60 60 51 44 48 68 10 43 48 60 71 68 0A 40 13 43 73 60 28 1C 41 46 ?? ?? ?? ?? 56 46 73 68 03 22 93 43 DB 1B 0F 2B 09 DC 28 1C ?? ?? ?? ?? 30 1C 08 30 B8 E7 11 1C ?? ?? ?? ?? B4 E7 01 22 F1 19 13 43 4B 60 73 68 1A 40 17 43 77 60 08 31 28 1C ?? ?? ?? ?? E8 E7 A2 44 52 46 93 1B C8 E7 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "hash4"
		size = 160
	strings:
		$1 = { 00 29 08 D0 03 1C 07 20 CA 1D 01 40 23 48 89 00 41 58 D2 08 8F 46 00 20 70 47 19 78 00 20 08 18 41 01 01 33 08 18 19 78 08 18 41 01 01 33 08 18 19 78 08 18 41 01 01 33 08 18 19 78 08 18 41 01 01 33 08 18 19 78 08 18 41 01 01 33 08 18 19 78 01 3A 08 18 00 2A DF D0 41 01 01 33 08 18 19 78 08 18 41 01 01 33 08 18 19 78 08 18 01 33 41 01 08 18 19 78 08 18 41 01 01 33 08 18 D3 E7 00 20 F2 E7 00 20 EB E7 00 20 E1 E7 00 20 DA E7 00 20 D3 E7 00 20 CC E7 00 20 C5 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_182_0_0 {
	meta:
		name = "envz_add"
		size = 130
		refs = "0012 envz_remove 001c strlen 002e malloc 003c memcpy 0058 argz_add 0060 free"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 1F 1C 80 46 8A 46 16 1C ?? ?? ?? ?? 00 2F 2C D0 30 1C ?? ?? ?? ?? 05 1C 38 1C ?? ?? ?? ?? 81 46 28 18 02 30 ?? ?? ?? ?? 04 1C 00 28 1B D0 2A 1C 31 1C ?? ?? ?? ?? 3D 23 63 55 4A 46 01 35 60 19 01 32 39 1C ?? ?? ?? ?? 40 46 51 46 22 1C ?? ?? ?? ?? 05 1C 20 1C ?? ?? ?? ?? 28 1C 1C BC 90 46 99 46 A2 46 F0 BD 0C 25 F7 E7 40 46 51 46 32 1C ?? ?? ?? ?? 05 1C F0 E7 }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "isblank"
		size = 20
	strings:
		$1 = { 02 1C 09 3A 53 42 5A 41 20 38 43 42 43 41 10 1C 18 43 70 47 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "wcpncpy"
		size = 68
	strings:
		$1 = { 30 B5 00 2A 1B D0 0B 68 54 1E 02 1C 08 C2 00 2B 08 D0 04 31 10 1C 00 2C 11 D0 0B 68 01 3C 08 C2 00 2B F6 D1 00 2C 08 D0 23 1C 11 1C 00 25 01 3B 20 C1 00 2B FB D1 A4 00 12 19 00 28 00 D0 30 BD 10 1C FC E7 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "wcsncmp"
		size = 36
	strings:
		$1 = { 30 B5 00 2A 0A D0 00 23 C4 58 CD 58 AC 42 07 D1 00 2C 03 D0 01 3A 04 33 00 2A F5 D1 00 20 30 BD 60 1B FC E7 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "_fputws_r"
		size = 180
		refs = "0062 _wcsrtombs_r 007a __sfvwrite_r 008e __swsetup_r"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 27 4C A5 44 01 91 80 23 91 89 9B 01 14 1C 07 1C 0A 1C 19 42 04 D1 61 6E 1A 43 0B 43 A2 81 63 66 13 07 2E D5 23 69 00 2B 2B D0 81 25 1D 4B ED 00 6B 44 6D 44 2B 60 01 23 6B 60 1A 4B 02 AE 6B 44 5C 22 1E 60 12 19 01 AB 90 46 9A 46 42 46 80 23 00 92 DB 00 38 1C 31 1C 52 46 ?? ?? ?? ?? 43 1C 15 D0 83 22 D2 00 6A 44 10 60 A8 60 21 1C 38 1C 2A 1C ?? ?? ?? ?? 00 28 09 D1 01 9B 00 2B E5 D1 07 E0 38 1C 21 1C ?? ?? ?? ?? 00 28 CD D0 01 20 40 42 05 4B 9D 44 0C BC 90 46 9A 46 F0 BD C0 46 E4 FB FF FF 14 04 00 00 1C 04 00 00 }
	condition:
		$1
}

rule file_189_0_0 {
	meta:
		name = "_vasniprintf_r"
		size = 98
		refs = "003c _svfiprintf_r"
	strings:
		$1 = { 70 B5 15 1C 12 68 9A B0 00 2A 08 D0 00 29 06 D0 00 2A 1F DA 8B 23 03 60 00 20 1A B0 70 BD A2 22 92 00 6C 46 A2 81 00 22 00 92 04 92 A2 60 62 61 01 22 52 42 E2 81 69 46 1A 1C 1E 9B ?? ?? ?? ?? 00 28 05 DB 00 9B 00 22 28 60 1A 70 20 69 E4 E7 00 20 E2 E7 C1 26 6C 46 F6 00 A6 81 00 91 04 91 E4 E7 }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "_vasnprintf_r"
		size = 98
		refs = "003c _svfprintf_r"
	strings:
		$1 = { 70 B5 15 1C 12 68 9A B0 00 2A 08 D0 00 29 06 D0 00 2A 1F DA 8B 23 03 60 00 20 1A B0 70 BD A2 22 92 00 6C 46 A2 81 00 22 00 92 04 92 A2 60 62 61 01 22 52 42 E2 81 69 46 1A 1C 1E 9B ?? ?? ?? ?? 00 28 05 DB 00 9B 00 22 28 60 1A 70 20 69 E4 E7 00 20 E2 E7 C1 26 6C 46 F6 00 A6 81 00 91 04 91 E4 E7 }
	condition:
		$1
}

rule file_190_0_0 {
	meta:
		name = "memccpy"
		size = 140
	strings:
		$1 = { F0 B5 47 46 80 B4 12 06 04 1C 0D 1C 12 0E 03 2B 2B D9 0E 1C 06 43 B7 07 27 D1 17 02 BF 18 3F 02 BF 18 3F 02 BF 18 0D 68 3C 1C 16 4E 6C 40 B8 46 A7 19 15 4E A7 43 37 42 10 D1 B4 46 09 E0 0D 68 46 46 10 4F 6E 40 F4 19 B4 43 26 1C 64 46 26 42 04 D1 04 3B 20 C0 04 31 03 2B F0 D8 04 1C 0D 1C 00 2B 04 D1 00 20 09 E0 01 35 00 2B FA D0 28 78 01 3B 20 70 01 34 82 42 F6 D1 20 1C 04 BC 90 46 F0 BD C0 46 FF FE FE FE 80 80 80 80 }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "_fgetpos_r"
		size = 18
		refs = "0004 _ftell_r"
	strings:
		$1 = { 10 B5 14 1C ?? ?? ?? ?? 20 60 01 30 43 42 58 41 10 BD }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "_vdiprintf_r"
		size = 84
		refs = "001c _vasniprintf_r 002e _write_r 003c _free_r"
	strings:
		$1 = { F0 B5 13 4C A5 44 14 1C 80 22 92 00 01 AE 81 92 00 93 0F 1C 23 1C 31 1C 81 AA 05 1C ?? ?? ?? ?? 04 1C 00 28 11 D0 28 1C 39 1C 22 1C 81 9B ?? ?? ?? ?? 81 90 B4 42 04 D0 28 1C 21 1C ?? ?? ?? ?? 81 98 82 23 9B 00 9D 44 F0 BD 01 20 40 42 F8 E7 F8 FD FF FF }
	condition:
		$1
}

rule file_206_0_0 {
	meta:
		name = "_vdprintf_r"
		size = 84
		refs = "001c _vasnprintf_r 002e _write_r 003c _free_r"
	strings:
		$1 = { F0 B5 13 4C A5 44 14 1C 80 22 92 00 01 AE 81 92 00 93 0F 1C 23 1C 31 1C 81 AA 05 1C ?? ?? ?? ?? 04 1C 00 28 11 D0 28 1C 39 1C 22 1C 81 9B ?? ?? ?? ?? 81 90 B4 42 04 D0 28 1C 21 1C ?? ?? ?? ?? 81 98 82 23 9B 00 9D 44 F0 BD 01 20 40 42 F8 E7 F8 FD FF FF }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "_buf_findstr"
		size = 142
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 92 46 12 68 90 46 00 2A 31 D0 03 78 01 30 9C 46 0A 68 00 23 00 27 81 46 03 E0 01 37 3B 1C 47 45 21 D2 D3 5C 63 45 F8 D1 63 46 00 2B 28 D0 D3 5D 63 45 F2 D1 4B 46 D4 19 3D 1C 04 E0 66 78 01 33 01 34 B0 42 E9 D1 18 78 01 35 00 28 F6 D1 52 19 0A 60 42 46 55 1B 53 46 1D 60 01 20 1C BC 90 46 99 46 A2 46 F0 BD 47 45 03 D0 00 20 F6 E7 0A 68 00 23 D3 18 0B 60 52 46 00 23 13 60 00 20 ED E7 3D 1C E4 E7 }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "strpbrk"
		size = 64
	strings:
		$1 = { 30 B5 04 78 00 2C 13 D0 0D 78 00 2D 12 D0 A5 42 0C D0 0B 1C 01 E0 94 42 08 D0 01 33 1A 78 00 2A F9 D1 01 30 04 78 00 2C EF D1 1C 78 00 2C 00 D1 00 20 30 BD 01 30 04 78 0B 1C 00 2C E5 D1 F4 E7 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "collect_data"
		size = 268
		refs = "0034 __get_buf 005e free 0064 malloc 00b4 memmove 00ce __errno"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0D 69 90 46 99 46 C2 68 6B 88 D2 1A 92 46 AB 88 CA 68 04 1C 0E 1C 93 46 03 2B 13 D0 2B 88 01 3B 5B 00 59 5B 32 1C 00 23 ?? ?? ?? ?? 01 1C 00 28 3D D1 01 27 7F 42 38 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 8C 23 5B 00 C0 58 57 46 47 44 00 28 01 D0 ?? ?? ?? ?? 38 1C ?? ?? ?? ?? 8C 23 5B 00 E0 50 00 28 E5 D0 4A 46 00 2A 0F D0 94 23 5B 00 01 22 E2 50 2B 88 02 2B 2A D1 90 23 5B 00 00 22 E2 50 92 23 5B 00 E2 58 01 32 E2 50 5A 46 13 04 F2 68 1B 0C 9A 42 14 D1 8C 23 5B 00 E0 58 31 69 6B 88 40 44 C9 18 52 46 ?? ?? ?? ?? C3 E7 52 46 42 44 20 1C 4B 46 FF F7 9D FF 07 1C 00 28 E5 DC B7 E7 ?? ?? ?? ?? 01 27 16 23 03 60 7F 42 B2 E7 01 3B 5B 00 59 5B 20 1C 00 23 32 1C ?? ?? ?? ?? 90 23 5B 00 E0 50 00 28 A3 D0 02 69 12 88 00 2A CC D1 92 21 49 00 60 58 01 30 60 50 E2 50 C5 E7 }
	condition:
		$1
}

rule file_196_1_0 {
	meta:
		name = "collect_key"
		size = 214
		refs = "0040 __get_buf 0068 free 006e malloc 0088 __big_return 00c2 memmove 00c8 __errno"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0F 69 90 46 99 46 C2 68 7B 88 D2 1A BB 88 02 3B 92 46 1B 04 CA 68 54 46 1B 0C 81 B0 06 1C 0D 1C 93 46 44 44 01 2B 14 D9 3B 88 01 3B 5B 00 D9 5B 2A 1C 00 23 ?? ?? ?? ?? 01 1C 00 28 23 D1 01 24 64 42 01 B0 20 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 8E 23 5B 00 C0 58 00 28 01 D0 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 8E 23 5B 00 F0 50 00 28 E6 D0 0A 9A 30 1C 00 92 29 1C 01 22 4B 46 ?? ?? ?? ?? 00 28 0A D0 DB E7 0A 9B 22 1C 00 93 30 1C 4B 46 FF F7 B0 FF 04 1C 00 28 D1 DD 5A 46 13 04 EA 68 1B 0C 9A 42 0A D1 8E 23 5B 00 F0 58 29 69 7B 88 40 44 C9 18 52 46 ?? ?? ?? ?? C2 E7 ?? ?? ?? ?? 01 24 16 23 03 60 64 42 BB E7 }
	condition:
		$1
}

rule file_196_2_0 {
	meta:
		name = "__find_last_page"
		size = 74
		refs = "0032 __get_buf"
	strings:
		$1 = { 30 B5 0A 68 04 1C 0D 1C 13 69 98 88 19 88 03 28 0A D1 02 29 14 D0 48 00 C0 5A 00 28 10 D0 48 1C 40 00 C0 5A 00 28 0B D1 01 39 49 00 C9 5A 20 1C 00 23 ?? ?? ?? ?? 02 1C 00 28 E5 D1 00 20 30 BD 2A 60 02 29 FA D9 D8 88 F9 E7 }
	condition:
		$1
}

rule file_196_3_0 {
	meta:
		name = "__big_return"
		size = 362
		refs = "0030 __get_buf 0124 memmove 015c __errno"
	strings:
		$1 = { F0 B5 1E 1C 01 32 0B 69 52 00 D2 5A 83 B0 05 1C 0C 1C 08 9F 01 2A 04 D0 13 E0 03 69 9A 88 01 2A 0F D1 1A 88 01 3A 52 00 D1 5A 28 1C 22 1C 00 23 ?? ?? ?? ?? 04 1C 00 28 EF D1 01 20 40 42 03 B0 F0 BD 02 2A 74 D0 1A 88 51 1C 49 00 C9 5A 00 29 38 D0 51 00 C9 5A 58 18 30 60 58 88 41 1A 71 60 00 2F 10 D0 02 2A 10 D1 90 23 5B 00 00 22 EA 50 92 23 5B 00 EA 58 01 32 EA 50 94 23 5B 00 01 22 EA 50 00 20 DB E7 00 20 D9 E7 01 3A 52 00 D1 5A 28 1C 00 23 22 1C ?? ?? ?? ?? 90 23 5B 00 E8 50 00 28 CA D0 94 22 52 00 01 21 A9 50 02 69 11 88 00 29 E8 D1 92 22 52 00 A8 58 01 30 A8 50 E9 50 00 20 BC E7 51 00 C9 5A E0 68 02 91 01 3A 59 88 52 00 00 91 01 90 D1 5A 28 1C 22 1C 00 23 ?? ?? ?? ?? 01 1C 00 28 A8 D0 00 9A 02 98 13 1A 1B 04 01 9A 1B 0C 00 93 13 04 1B 0C 01 93 00 9A 28 1C 3B 1C FF F7 F7 FE 70 60 01 30 00 D1 95 E7 E3 68 01 98 83 42 22 D1 02 9A 21 69 8C 27 7F 00 89 18 E8 59 00 9A ?? ?? ?? ?? EB 59 00 20 33 60 86 E7 1A 88 01 3A 52 00 D1 5A 28 1C 22 1C 00 23 ?? ?? ?? ?? 01 1C 00 28 00 D1 77 E7 0B 69 80 89 5B 88 00 22 01 90 02 93 0C 1C 00 92 D0 E7 ?? ?? ?? ?? 16 23 03 60 01 20 40 42 69 E7 }
	condition:
		$1
}

rule file_196_4_0 {
	meta:
		name = "__big_keydata"
		size = 38
	strings:
		$1 = { 30 B5 81 B0 14 1C 04 9A 00 92 00 22 05 1C FF F7 8B FF 60 60 43 1C 04 D0 8E 23 5B 00 EB 58 23 60 00 20 01 B0 30 BD }
	condition:
		$1
}

rule file_196_5_0 {
	meta:
		name = "__big_split"
		size = 304
		refs = "0024 __big_keydata 0044 __call_hash 004e __find_last_page 010e __add_ovflpage 0124 __get_buf"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 87 B0 1E 1C 02 93 00 23 88 46 17 1C 00 93 31 1C 05 AA 03 AB 05 1C 12 9C ?? ?? ?? ?? 00 28 08 D0 01 20 40 42 07 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 05 99 06 9A 28 1C ?? ?? ?? ?? 02 A9 82 46 28 1C ?? ?? ?? ?? 01 1C A0 81 00 28 61 D1 A0 60 11 9B 51 46 CB 1A 1A 1C 53 1E 9A 41 92 46 00 2A 36 D1 43 46 1A 7D 01 20 02 43 1A 75 9E 60 1B 69 1A 88 91 1C 49 00 C9 5A 01 32 8B 46 51 00 12 04 C9 5A 12 0C 56 00 01 32 01 91 12 04 10 99 12 0C F1 52 56 00 00 21 F1 52 1A 80 02 32 52 00 5E 46 D6 52 1A 88 01 99 01 32 04 39 52 00 D1 52 41 46 27 60 61 60 02 99 0B 7D 18 43 0E 69 08 75 33 88 02 2B 0A D8 52 46 00 2A 04 D1 61 60 00 20 A9 E7 3B 1C C7 E7 21 60 00 20 A4 E7 5A 1C 52 00 90 5B 9A 1C 02 3B 1B 04 1B 0C 52 00 92 5B 33 80 01 33 5B 00 04 30 37 89 98 53 33 88 02 33 5B 00 9A 53 28 1C ?? ?? ?? ?? 01 1C 00 28 00 D1 88 E7 37 81 D8 E7 28 1C 02 9A 00 23 ?? ?? ?? ?? A0 60 00 28 96 D1 7D E7 }
	condition:
		$1
}

rule file_196_6_0 {
	meta:
		name = "__find_bigpair"
		size = 200
		refs = "004c __get_buf 007e memcmp"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0D 1C 81 B0 2C 69 06 1C 00 92 91 46 52 00 10 5B F7 68 0A 99 3F 1A 3F 04 8B 46 3F 0C BB 45 2C DB 4A 46 01 32 52 00 12 5B 01 2A 44 D1 98 46 8A 46 1C E0 4B 46 02 33 5B 00 E1 5A 2A 1C 30 1C 00 23 ?? ?? ?? ?? 05 1C 00 28 31 D0 04 69 53 46 DB 1B B8 44 60 88 F7 68 3F 1A 3F 04 3F 0C 9A 46 BB 45 16 DB A3 88 01 21 89 46 01 2B 11 D1 20 18 41 46 3A 1C ?? ?? ?? ?? 00 28 DB D0 02 22 52 42 00 92 00 98 01 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 01 22 00 92 BA 45 F0 D1 00 99 4B 00 E0 5A 41 46 20 18 52 46 ?? ?? ?? ?? 00 28 E9 D0 E5 E7 03 22 52 42 00 92 E4 E7 98 46 8A 46 EB E7 }
	condition:
		$1
}

rule file_196_7_0 {
	meta:
		name = "__big_delete"
		size = 260
		refs = "003a __get_buf 0048 __free_ovflpage"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 0B 69 9A 88 8A 46 0C 1C 01 21 88 46 91 1E 09 04 09 0C 06 1C 00 27 00 25 01 29 21 D9 1A 88 01 3A 52 00 D1 5A 23 7D 42 46 13 43 23 75 22 1C 30 1C 00 23 ?? ?? ?? ?? 04 1C 00 2D 03 D0 30 1C 29 1C ?? ?? ?? ?? 00 2C 53 D0 23 69 00 2F 13 D0 9A 88 03 2A 13 D0 25 1C 91 1E 09 04 09 0C 01 29 DD D8 03 2A 48 D1 1A 88 51 1C 49 00 C9 5A 10 1C 00 29 06 D1 01 27 D3 E7 9A 88 25 1C EC E7 18 88 25 1C 42 1E 52 00 51 46 D2 5A 0B 69 02 28 2A DC 00 22 51 46 8A 60 82 1E 12 04 12 0C 1A 80 01 32 51 00 01 30 F2 68 40 00 10 1A C8 52 19 88 02 31 49 00 01 3A CA 52 53 46 1A 7D 01 23 51 46 13 43 0B 75 30 1C 21 1C ?? ?? ?? ?? A5 42 03 D0 30 1C 29 1C ?? ?? ?? ?? B3 6B 01 3B B3 63 00 20 0C BC 90 46 9A 46 F0 BD 5A 80 00 22 9A 80 A2 68 8A 60 D1 E7 01 20 40 42 F2 E7 1A 88 01 27 90 E7 }
	condition:
		$1
}

rule file_196_8_0 {
	meta:
		name = "__big_insert"
		size = 544
		refs = "0042 MIN 005e memmove 0090 __add_ovflpage"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 9B 46 0C 69 13 68 52 68 92 46 22 88 01 32 52 00 82 B0 17 5B 01 90 58 46 00 68 08 3F 0D 1C 3F 04 59 46 52 46 00 90 4E 68 3F 0C 00 2A 4E D0 99 46 38 1C B0 46 51 46 ?? ?? ?? ?? 23 88 02 33 5B 00 E6 5A 07 04 3F 0C F6 1B 36 04 36 0C 49 46 3A 1C A0 19 ?? ?? ?? ?? 22 88 53 1C 59 00 01 33 66 52 19 04 09 0C 05 32 21 80 52 00 01 31 49 00 B2 1A 62 52 22 88 02 32 52 00 5B 00 01 20 A6 52 29 1C E0 52 01 98 ?? ?? ?? ?? B9 44 05 1C 00 28 00 D1 BD E0 51 46 C9 1B 8A 46 27 88 00 29 56 D1 7B 1C 5B 00 E0 5A 46 46 00 28 00 D0 66 E0 02 3F 7F 00 02 23 E3 53 2A 7D 01 23 13 43 2C 69 2B 75 23 88 01 33 5B 00 1F 5B 08 3F 3F 04 3F 0C 00 2E 35 D0 02 23 01 20 9A 46 81 46 38 1C 31 1C ?? ?? ?? ?? 00 04 00 0C 80 46 BE 42 3D D0 23 88 02 33 5B 00 E7 5A 42 46 BF 1A 3F 04 3F 0C 00 99 E0 19 ?? ?? ?? ?? 43 46 F6 1A 23 88 59 1C 4A 00 01 31 A7 52 0A 04 12 0C 05 33 22 80 5B 00 01 32 FB 1A 52 00 A3 52 23 88 02 33 5B 00 E7 52 00 2E 54 D1 03 23 49 00 63 52 2A 7D 01 23 13 43 2B 75 00 20 02 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 03 7D 01 22 13 43 04 69 03 75 23 88 01 33 5B 00 18 5B 08 38 00 04 00 0C 66 E7 59 46 4B 68 9E 42 BD D1 03 1C 01 3B 1B 04 1B 0C 98 46 B7 E7 41 46 ?? ?? ?? ?? 23 88 02 33 5B 00 E3 5A 00 04 00 0C 1B 1A 1B 04 1B 0C 9A 46 52 46 7B 00 80 46 E2 52 53 46 E0 18 00 99 42 46 02 3F ?? ?? ?? ?? 7F 00 03 23 E3 53 23 88 01 33 5B 00 00 98 E3 18 42 46 B6 1A 1A 88 01 1C 40 46 12 1A 1A 80 23 88 41 44 02 33 00 91 5B 00 51 46 E1 52 6D E7 49 00 52 46 62 52 01 98 29 1C ?? ?? ?? ?? 05 1C 00 28 10 D0 00 9B 18 1C 40 44 00 90 2B 7D 49 46 0B 43 2C 69 2B 75 23 88 01 33 5B 00 1F 5B 08 3F 3F 04 3F 0C 64 E7 01 20 40 42 94 E7 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "__libc_fini_array"
		size = 44
		refs = "001c _fini 0024 __fini_array_start 0028 __fini_array_end"
	strings:
		$1 = { 70 B5 08 4D 08 4E 76 1B B6 10 00 2E 06 D0 00 24 08 CD 01 34 00 F0 30 F8 A6 42 F9 D8 ?? ?? ?? ?? 70 BD C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_197_1_0 {
	meta:
		name = "__libc_init_array"
		size = 76
		refs = "001c _init 003c __preinit_array_start 0040 __preinit_array_end 0044 __init_array_start 0048 __init_array_end"
	strings:
		$1 = { 70 B5 0E 4D 0E 4E 76 1B B6 10 00 2E 06 D0 00 24 08 CD 01 34 00 F0 1A F8 A6 42 F9 D8 ?? ?? ?? ?? 08 4D 09 4E 76 1B B6 10 00 2E 06 D0 00 24 08 CD 01 34 00 F0 0B F8 A6 42 F9 D8 70 BD ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "fcntl"
		size = 16
		refs = "0002 __errno"
	strings:
		$1 = { 00 B5 ?? ?? ?? ?? 58 23 03 60 01 20 40 42 00 BD }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "wcwidth"
		size = 40
		refs = "0004 iswprint 0012 iswcntrl"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 00 28 01 D0 01 20 10 BD 20 1C ?? ?? ?? ?? 00 28 01 D1 00 2C 01 D1 00 20 F5 E7 01 20 40 42 F2 E7 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "iswctype"
		size = 96
		refs = "0012 iswalnum 0018 iswalpha 001e iswblank 0024 iswcntrl 002a iswdigit 0030 iswgraph 0036 iswlower 003c iswprint 0042 iswpunct 0048 iswspace 004e iswupper 0054 iswxdigit"
	strings:
		$1 = { 00 B5 0C 29 01 D9 00 20 00 BD 14 4B 89 00 5B 58 9F 46 ?? ?? ?? ?? F7 E7 ?? ?? ?? ?? F4 E7 ?? ?? ?? ?? F1 E7 ?? ?? ?? ?? EE E7 ?? ?? ?? ?? EB E7 ?? ?? ?? ?? E8 E7 ?? ?? ?? ?? E5 E7 ?? ?? ?? ?? E2 E7 ?? ?? ?? ?? DF E7 ?? ?? ?? ?? DC E7 ?? ?? ?? ?? D9 E7 ?? ?? ?? ?? D6 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "argz_create"
		size = 114
		refs = "001e strlen 0034 malloc 0056 memcpy"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 07 1C 00 68 00 23 8A 46 16 1C 13 60 00 28 2A D0 00 24 3D 1D A0 46 ?? ?? ?? ?? 04 19 01 CD 01 34 01 23 34 60 98 44 00 28 F5 D1 20 1C ?? ?? ?? ?? 53 46 04 1C 18 60 00 28 13 D0 3E 1C 00 25 30 68 ?? ?? ?? ?? 47 1C 02 CE 20 1C 3A 1C 01 35 ?? ?? ?? ?? E4 19 A8 45 F2 DC 00 20 0C BC 90 46 9A 46 F0 BD 0C 20 F9 E7 08 60 F7 E7 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "wcsncat"
		size = 46
	strings:
		$1 = { 10 B5 03 68 00 2B 10 D0 03 1C 04 33 1C 68 00 2C FB D1 0C 68 00 2A 02 D1 00 22 1A 60 10 BD 00 2C FA D0 10 C3 04 31 01 3A F3 E7 03 1C F1 E7 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "wcsspn"
		size = 56
	strings:
		$1 = { 70 B5 04 68 00 2C 15 D0 0E 68 00 2E 12 D0 05 1C B4 42 0A D0 0B 1C 01 E0 94 42 06 D0 04 33 1A 68 00 2A F9 D1 28 1A 80 10 70 BD 04 35 2C 68 00 2C EE D1 F7 E7 00 20 F7 E7 }
	condition:
		$1
}

rule file_210_0_0 {
	meta:
		name = "_mbstowcs_r"
		size = 120
		refs = "0042 _mbtowc_r 0074 __mb_cur_max"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 81 B0 99 46 0A 9B 9A 46 4B 46 80 46 8B 46 00 2B 27 D0 15 1C 0C 1C 4F 46 13 4E 06 E0 00 28 1A D0 01 3F 00 2F 1B D0 2D 18 04 34 52 46 33 68 40 46 00 92 21 1C 2A 1C ?? ?? ?? ?? 00 28 EE DA 00 23 52 46 01 20 13 60 40 42 01 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 5B 46 E0 1A 80 10 F4 E7 48 46 F2 E7 00 20 F0 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "finite"
		size = 20
	strings:
		$1 = { 02 4B 18 40 02 4B C0 18 C0 0F 70 47 FF FF FF 7F 00 00 10 80 }
	condition:
		$1
}

rule file_212_0_0 {
	meta:
		name = "_strndup_r"
		size = 70
		refs = "0026 _malloc_r 0034 memcpy"
	strings:
		$1 = { 70 B5 0D 1C 00 2A 1B D0 0B 78 00 2B 18 D0 01 3A 0E 1C 03 E0 33 78 01 3A 00 2B 02 D0 01 36 00 2A F8 D1 76 1B 71 1C ?? ?? ?? ?? 04 1C 00 28 05 D0 29 1C 32 1C ?? ?? ?? ?? 00 23 A3 55 20 1C 70 BD 01 21 00 26 EF E7 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "isinff"
		size = 24
		altNames = "__isinff"
	strings:
		$1 = { 03 4B 18 40 03 4B C0 18 43 42 58 41 70 47 C0 46 FF FF FF 7F 00 00 80 80 }
	condition:
		$1
}

rule file_215_0_0 {
	meta:
		name = "wcscpy"
		size = 32
	strings:
		$1 = { 00 23 03 60 0B 68 00 2B 08 D0 02 1C 08 C2 04 31 0B 68 00 2B FA D1 00 23 13 60 70 47 02 1C FA E7 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "gcvt"
		size = 88
		refs = "0010 __ltdf2 002e _gcvt 0054 _impure_ptr"
	strings:
		$1 = { F0 B5 17 1C 1C 1C 83 B0 11 4B 10 4A 05 1C 0E 1C ?? ?? ?? ?? 00 28 11 DB 23 1C 0E 4A 10 68 00 93 67 23 01 93 00 23 02 93 29 1C 32 1C 3B 1C ?? ?? ?? ?? 00 28 07 D0 20 1C 03 B0 F0 BD 2D 23 23 70 01 3F 63 1C E9 E7 00 20 F6 E7 C0 46 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_216_1_0 {
	meta:
		name = "gcvtf"
		size = 20
		refs = "0006 __extendsfdf2 000e gcvt"
	strings:
		$1 = { 30 B5 0D 1C 14 1C ?? ?? ?? ?? 2A 1C 23 1C ?? ?? ?? ?? 30 BD }
	condition:
		$1
}

rule file_216_2_0 {
	meta:
		name = "ecvt"
		size = 20
		refs = "000c ecvtbuf"
	strings:
		$1 = { 10 B5 82 B0 04 9C 00 94 00 24 01 94 ?? ?? ?? ?? 02 B0 10 BD }
	condition:
		$1
}

rule file_216_4_0 {
	meta:
		name = "fcvt"
		size = 20
		refs = "000c fcvtbuf"
	strings:
		$1 = { 10 B5 82 B0 04 9C 00 94 00 24 01 94 ?? ?? ?? ?? 02 B0 10 BD }
	condition:
		$1
}

rule file_216_3_0 {
	meta:
		name = "ecvtf"
		size = 28
		refs = "000a __extendsfdf2 0014 ecvt"
	strings:
		$1 = { 70 B5 81 B0 0D 1C 14 1C 1E 1C ?? ?? ?? ?? 2A 1C 23 1C 00 96 ?? ?? ?? ?? 01 B0 70 BD }
	condition:
		$1
}

rule file_216_5_0 {
	meta:
		name = "fcvtf"
		size = 28
		refs = "000a __extendsfdf2 0014 fcvt"
	strings:
		$1 = { 70 B5 81 B0 0D 1C 14 1C 1E 1C ?? ?? ?? ?? 2A 1C 23 1C 00 96 ?? ?? ?? ?? 01 B0 70 BD }
	condition:
		$1
}

rule file_217_0_0 {
	meta:
		name = "__log2"
		size = 24
	strings:
		$1 = { 01 28 07 D9 00 22 01 23 5B 00 01 32 98 42 FB D8 10 1C 70 47 00 22 FB E7 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "iswgraph"
		size = 26
		refs = "0004 iswprint 0010 iswspace"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 00 28 00 D1 10 BD 20 1C ?? ?? ?? ?? 43 42 58 41 F8 E7 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "_fgetwc_r"
		size = 184
		refs = "0038 _mbrtowc_r 006c __srefill_r 0094 __errno 00b4 __mb_cur_max"
	strings:
		$1 = { F0 B5 80 23 8A 89 9B 01 82 B0 05 1C 0C 1C 1A 42 04 D1 1A 43 8A 81 4A 6E 13 43 4B 66 63 68 00 2B 22 DD 24 4A 12 68 01 2A 29 D0 26 1C 5C 36 01 AF 22 68 28 1C 39 1C 00 96 ?? ?? ?? ?? 43 1C 25 D0 83 1C 2E D0 00 28 08 D0 23 68 1B 18 23 60 63 68 18 1A 60 60 01 98 02 B0 F0 BD 23 68 01 33 23 60 63 68 01 3B 63 60 F6 E7 28 1C 21 1C ?? ?? ?? ?? 00 28 13 D1 0F 4A 12 68 63 68 01 2A D5 D1 22 68 01 3B 10 78 01 32 22 60 63 60 E4 E7 A2 89 40 23 13 43 A3 81 ?? ?? ?? ?? 8A 23 03 60 01 20 40 42 D9 E7 28 1C 21 1C ?? ?? ?? ?? 00 28 EE D1 63 68 BE E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "fgetwc"
		size = 36
		refs = "0012 __sinit 001a _fgetwc_r 0020 _impure_ptr"
	strings:
		$1 = { 30 B5 07 4C 05 1C 20 68 00 28 05 D0 83 6B 00 2B 02 D1 ?? ?? ?? ?? 20 68 29 1C ?? ?? ?? ?? 30 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "_fopen_r"
		size = 136
		refs = "000c __sflags 0020 __sfp 0034 _open_r 0062 _fseek_r 0068 __sfp_lock_acquire 0070 __sfp_lock_release 0078 __sread 007c __swrite 0080 __sseek 0084 __sclose"
	strings:
		$1 = { F0 B5 81 B0 0F 1C 11 1C 6A 46 05 1C ?? ?? ?? ?? 06 1C 00 28 03 D1 00 24 01 B0 20 1C F0 BD 28 1C ?? ?? ?? ?? 04 1C 00 28 F6 D0 DB 23 28 1C 39 1C 00 9A 5B 00 ?? ?? ?? ?? 00 28 15 DB 0E 4B 23 62 0E 4B 63 62 0E 4B 36 04 A3 62 0E 4B 36 0C E0 81 A6 81 E4 61 E3 62 F3 05 DE D5 28 1C 21 1C 00 22 02 23 ?? ?? ?? ?? D7 E7 ?? ?? ?? ?? 00 23 A3 81 ?? ?? ?? ?? CF E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_225_0_0 {
	meta:
		name = "strcmp"
		size = 88
	strings:
		$1 = { 30 B5 0B 1C 03 43 9A 07 1B D1 03 68 0A 68 93 42 17 D1 0F 4C 1A 19 0F 4C 9A 43 22 42 0A D1 04 30 04 31 03 68 0A 68 93 42 0B D1 09 4D 5A 19 9A 43 22 42 F4 D0 00 20 09 E0 0A 78 93 42 05 D1 01 30 01 31 03 78 00 2B F7 D1 0A 78 98 1A 30 BD C0 46 FF FE FE FE 80 80 80 80 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "_srand48_r"
		size = 56
	strings:
		$1 = { 0A 4A AC 23 C2 52 AE 23 C1 52 09 4A 09 0C B0 23 C1 52 B2 23 C2 52 07 4A B4 23 C2 52 05 22 B6 23 C2 52 0B 22 B8 23 C2 52 70 47 C0 46 0E 33 00 00 6D E6 FF FF EC DE FF FF }
	condition:
		$1
}

rule file_226_1_0 {
	meta:
		name = "srand48"
		size = 64
		refs = "0030 _impure_ptr"
	strings:
		$1 = { 0B 4B 0C 49 1B 68 AC 22 99 52 AE 22 98 52 0A 49 00 0C B0 22 98 52 B2 22 99 52 08 49 B4 22 99 52 05 21 B6 22 99 52 0B 21 B8 22 99 52 70 47 C0 46 ?? ?? ?? ?? 0E 33 00 00 6D E6 FF FF EC DE FF FF }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "__ten_mul"
		size = 56
		refs = "000e __muldf3 0018 __floatsidf 0024 __adddf3"
	strings:
		$1 = { F0 B5 0F 1C 0B 4B 0A 4A 04 1C 41 68 00 68 ?? ?? ?? ?? 05 1C 38 1C 0E 1C ?? ?? ?? ?? 02 1C 0B 1C 28 1C 31 1C ?? ?? ?? ?? 20 60 61 60 00 20 F0 BD 00 00 24 40 00 00 00 00 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "_perror_r"
		size = 64
		refs = "0010 strerror 001a fputs 0022 fputc"
	strings:
		$1 = { 10 B5 04 1C 00 29 02 D0 0B 78 00 2B 0C D1 20 68 ?? ?? ?? ?? 00 28 02 D0 E1 68 ?? ?? ?? ?? E1 68 0A 20 ?? ?? ?? ?? 10 BD C3 68 08 1C 19 1C ?? ?? ?? ?? E1 68 01 48 ?? ?? ?? ?? E8 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "__part_load_locale"
		size = 516
		refs = "003a strcmp 0080 strlen 00b0 strcpy 00b8 strcat 00d8 open 00ec fstat 0112 realloc 0136 read 0144 close 0166 strchr 01b4 free 01d0 malloc 01f4 _PathLocale"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 74 4C 17 1C 8D 22 A5 44 D2 00 6A 44 12 68 98 46 8E 23 DB 00 6B 44 93 46 0A 68 1C 68 00 23 05 1C 0E 1C 91 46 0B 60 00 28 00 D1 C2 E0 6A 49 ?? ?? ?? ?? 00 28 08 D1 00 20 68 4B 9D 44 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 28 1C 65 49 ?? ?? ?? ?? 00 28 F0 D0 00 2F 19 D0 28 1C 39 1C ?? ?? ?? ?? 00 28 13 D1 5F 4B 1B 68 98 46 00 2B 0A DD 3D 1C 00 27 28 1C ?? ?? ?? ?? 01 30 2D 18 01 37 20 C4 B8 45 F6 DC 01 23 33 60 00 20 D5 E7 28 1C ?? ?? ?? ?? 55 4B 19 68 01 90 00 29 00 D1 89 E0 02 AB 9A 46 18 1C ?? ?? ?? ?? 50 49 50 46 ?? ?? ?? ?? 29 1C 50 46 ?? ?? ?? ?? 4C 49 50 46 ?? ?? ?? ?? 41 46 50 46 ?? ?? ?? ?? 50 46 00 21 ?? ?? ?? ?? 00 90 00 28 6D DB 81 22 D2 00 6A 44 11 1C 90 46 ?? ?? ?? ?? 00 28 61 D1 43 46 19 69 00 29 5D DD 01 9A 92 46 01 22 92 44 51 44 00 2F 61 D0 3C 4B 9F 42 5E D0 38 1C ?? ?? ?? ?? 00 28 4B D0 07 1C 00 2F 4B D0 29 1C 38 1C ?? ?? ?? ?? 53 46 42 46 FD 18 12 69 00 98 29 1C 92 46 ?? ?? ?? ?? 42 46 13 69 98 42 37 D1 00 98 ?? ?? ?? ?? 00 28 32 D1 AA 44 53 46 01 3B 1B 78 0A 2B 2C D1 55 45 3D D2 00 22 90 46 91 46 28 1C 0A 21 ?? ?? ?? ?? 4B 46 01 22 45 1C 03 70 90 44 AA 45 F4 D8 1D 4B 42 46 1A 60 C3 45 22 DD 1F 4A 6A 44 12 68 42 45 10 DC 1A 60 93 46 5A 46 00 2A 00 DC 7B E7 00 25 38 1C ?? ?? ?? ?? 01 30 3F 18 01 35 80 C4 AB 45 F6 DC 70 E7 00 23 99 46 38 1C ?? ?? ?? ?? 00 98 ?? ?? ?? ?? 4A 46 01 20 32 60 40 42 3D E7 5A 46 1A 60 E0 E7 08 1C ?? ?? ?? ?? 07 1C A1 E7 00 23 98 46 CC E7 C0 46 BC FB FF FF ?? ?? ?? ?? 44 04 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6C 04 00 00 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "__sccl"
		size = 114
	strings:
		$1 = { 70 B5 0D 78 03 1C 48 1C 5E 2D 2B D0 00 24 00 26 80 21 00 22 49 00 9C 54 01 32 8A 42 FB D1 00 2D 11 D0 01 24 A4 1B 24 06 24 0E 5C 55 02 1C 11 78 50 1C 2D 29 09 D0 5D 29 02 D0 00 29 01 D1 10 1C 70 BD 0D 1C F1 E7 01 38 FA E7 56 78 AE 42 0E DB 5D 2E 0C D0 59 19 01 35 4C 70 01 31 AE 42 FA DC 02 32 E4 E7 4D 78 01 30 01 24 01 26 D0 E7 2D 25 DB E7 }
	condition:
		$1
}

rule file_233_0_0 {
	meta:
		name = "memchr"
		size = 124
	strings:
		$1 = { F0 B5 09 06 09 0E 83 07 10 D0 00 2A 1E D0 03 78 8B 42 1C D0 01 3A 03 24 05 E0 00 2A 16 D0 03 78 8B 42 14 D0 01 3A 01 30 20 42 F6 D1 03 2A 0F D8 00 2A 0B D0 03 78 8B 42 09 D0 01 3A 04 E0 01 30 03 78 01 3A 8B 42 02 D0 00 2A F8 D1 00 20 F0 BD 0E 02 0E 43 33 04 07 4D 1E 43 03 68 06 4F 73 40 DC 19 9C 43 2C 42 E3 D1 04 3A 04 30 03 2A F4 D8 DE E7 C0 46 80 80 80 80 FF FE FE FE }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "__swsetup_r"
		size = 204
		refs = "0054 __sinit 0074 __smakebuf_r 00a4 _free_r 00c4 _impure_ptr"
	strings:
		$1 = { 70 B5 30 4B 05 1C 18 68 0C 1C 00 28 02 D0 83 6B 00 2B 1F D0 A2 89 10 04 03 0C 11 1C 1E 07 2E D5 22 69 00 2A 1C D0 D9 07 08 D5 00 23 A3 60 63 69 5B 42 A3 61 00 2A 07 D0 00 20 70 BD 9E 07 0C D5 00 23 A3 60 00 2A F7 D1 A3 89 19 06 F4 D5 01 20 40 42 F2 E7 ?? ?? ?? ?? DC E7 63 69 A3 60 F1 E7 A0 21 89 00 18 1C 08 40 80 21 89 00 88 42 DA D0 28 1C 21 1C ?? ?? ?? ?? A3 89 22 69 D3 E7 DE 06 E5 D5 5E 07 06 D4 22 69 08 23 19 43 0B 04 1B 0C A3 81 C6 E7 21 6B 00 29 0A D0 23 1C 40 33 99 42 03 D0 28 1C ?? ?? ?? ?? A2 89 00 23 23 63 10 04 05 4B 01 0C 22 69 19 40 00 23 A1 81 63 60 22 60 E2 E7 C0 46 ?? ?? ?? ?? DB FF 00 00 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "stpncpy"
		size = 112
	strings:
		$1 = { 70 B5 0B 1C 03 43 9C 07 01 D1 03 2A 1D D8 00 2A 1A D0 0B 78 54 1E 03 70 42 1C 00 2B 09 D0 01 31 10 1C 00 2C 10 D0 0B 78 01 3C 13 70 01 32 00 2B F5 D1 00 2C 06 D0 00 23 00 21 D1 54 01 33 9C 42 FB D1 12 19 00 28 0D D0 70 BD 07 4D 0B 68 07 4E 9C 19 9C 43 2C 42 DA D1 04 3A 08 C0 04 31 03 2A F4 D8 D4 E7 10 1C EF E7 80 80 80 80 FF FE FE FE }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "_wctype_r"
		size = 280
		refs = "001e strcmp"
	strings:
		$1 = { 30 B5 0B 78 61 3B 1B 06 1B 0E 05 1C 0C 1C 17 2B 09 D8 34 4A 9B 00 D3 58 9F 46 08 1C 32 49 ?? ?? ?? ?? 00 28 5B D0 16 23 2B 60 00 20 30 BD 08 1C 2E 49 ?? ?? ?? ?? 00 28 F5 D1 0C 20 F6 E7 08 1C 2B 49 ?? ?? ?? ?? 00 28 39 D1 01 20 EE E7 08 1C 28 49 ?? ?? ?? ?? 00 28 E5 D1 04 20 E6 E7 08 1C 25 49 ?? ?? ?? ?? 00 28 DD D1 05 20 DE E7 08 1C 22 49 ?? ?? ?? ?? 00 28 D5 D1 06 20 D6 E7 08 1C 1F 49 ?? ?? ?? ?? 00 28 CD D1 07 20 CE E7 08 1C 1C 49 ?? ?? ?? ?? 00 28 19 D1 08 20 C6 E7 08 1C 19 49 ?? ?? ?? ?? 00 28 BD D1 0A 20 BE E7 08 1C 16 49 ?? ?? ?? ?? 00 28 B5 D1 0B 20 B6 E7 20 1C 13 49 ?? ?? ?? ?? 00 28 AD D1 02 20 AE E7 20 1C 10 49 ?? ?? ?? ?? 00 28 A5 D1 09 20 A6 E7 03 20 A4 E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "__isinfd"
		size = 36
		altNames = "isinf"
	strings:
		$1 = { 4B 42 06 4A 0B 43 DB 0F 10 40 18 43 04 4B 18 1A 43 42 18 43 C0 17 01 30 70 47 C0 46 FF FF FF 7F 00 00 F0 7F }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "fmemseeker"
		size = 106
	strings:
		$1 = { 10 B5 04 1C 01 2B 20 D0 02 2B 21 D0 10 1C 00 28 26 DB 0B 69 98 42 1E D8 4B 7D 00 2B 09 D0 8A 68 CC 68 A2 42 05 D2 4B 68 8C 7D 9C 54 00 23 8B 75 4B 7D 88 60 00 2B 07 D0 CB 68 98 42 04 D2 4B 68 1A 5C 8A 75 00 22 1A 54 10 BD 88 68 10 18 DE E7 C8 68 10 18 DB E7 1C 23 01 20 23 60 40 42 F3 E7 16 23 01 20 23 60 40 42 EE E7 }
	condition:
		$1
}

rule file_239_2_0 {
	meta:
		name = "fmemreader"
		size = 54
		refs = "001e memcpy"
	strings:
		$1 = { 70 B5 0C 1C 1D 1C 8B 68 C9 68 8B 42 11 D8 C9 1A 2E 1C 8D 42 0A D2 61 68 10 1C C9 18 32 1C ?? ?? ?? ?? A3 68 9E 19 A6 60 28 1C 70 BD 0D 1C 0E 1C F1 E7 00 25 F8 E7 }
	condition:
		$1
}

rule file_239_3_0 {
	meta:
		name = "fmemwriter"
		size = 198
		refs = "0054 memcpy 0076 memset"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 1D 1C 0B 7D 82 46 0C 1C 16 1C 00 2B 25 D0 CB 68 8B 60 98 46 27 69 61 7D 58 19 7A 1A BC 46 90 42 31 D8 00 22 80 45 33 D2 E0 60 80 1A 60 45 43 D2 61 68 00 23 0B 54 A0 68 A3 75 28 18 A0 60 95 42 2B D0 63 68 40 1B 18 18 AA 1A 31 1C ?? ?? ?? ?? 28 1C 0C BC 90 46 9A 46 F0 BD C8 68 8B 68 80 46 43 45 D7 D9 48 68 41 46 5A 1A 40 44 00 21 ?? ?? ?? ?? E2 68 27 69 A3 68 61 7D 90 46 58 19 7A 1A BC 46 90 42 CD D9 FD 1A E8 18 0A 1C 80 45 CB D3 00 29 D3 D0 00 2D 06 D1 A0 60 1C 23 51 46 01 25 0B 60 6D 42 D4 E7 63 68 80 1A 19 5C A1 75 A1 68 69 18 89 1A 00 20 58 54 A0 68 28 18 BE E7 }
	condition:
		$1
}

rule file_239_4_0 {
	meta:
		name = "_fmemopen_r"
		size = 316
		refs = "0016 __sflags 0042 __sfp 0054 _malloc_r 0086 abort 00ce memchr 011e __sfp_lock_acquire 0124 __sfp_lock_release 012c fmemseeker 0130 fmemcloser 0134 fmemreader 0138 fmemwriter"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 81 B0 0F 1C 92 46 19 1C 6A 46 06 1C 98 46 ?? ?? ?? ?? 05 1C 00 28 08 D0 51 46 00 29 03 D0 00 2F 0A D1 C3 05 08 D4 16 23 33 60 00 24 01 B0 20 1C 0C BC 90 46 9A 46 F0 BD 30 1C ?? ?? ?? ?? 04 1C 00 28 F3 D0 00 2F 4E D0 18 21 30 1C ?? ?? ?? ?? 06 1C 00 28 5F D0 EB 08 01 22 13 40 51 46 43 75 00 23 30 60 01 61 83 75 00 2F 3F D0 47 60 41 46 0A 78 72 2A 05 D0 77 2A 30 D0 61 2A 20 D0 ?? ?? ?? ?? 03 75 83 60 53 46 C3 60 01 23 5B 42 E3 81 14 23 A5 81 E6 61 1D 42 0B D1 00 23 23 62 18 23 1D 42 0B D1 00 23 63 62 1E 4B A3 62 1E 4B E3 62 BC E7 1E 4B 23 62 18 23 1D 42 F3 D0 1C 4B F2 E7 38 1C 00 21 52 46 ?? ?? ?? ?? 00 28 18 D0 73 68 C0 1A B0 60 F0 60 01 23 33 75 D6 E7 C3 60 03 75 83 60 3B 70 D1 E7 51 46 18 31 AE E7 03 1C 18 33 43 60 2B 0A 1A 40 3F 70 C7 60 87 60 02 75 C4 E7 73 7D 51 46 B1 60 F1 60 00 2B E4 D0 73 68 53 44 01 3B 18 70 DF E7 ?? ?? ?? ?? A6 81 ?? ?? ?? ?? 00 24 83 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "_Bfree"
		size = 18
	strings:
		$1 = { 00 29 05 D0 4A 68 C3 6C 92 00 D0 58 08 60 D1 50 70 47 }
	condition:
		$1
}

rule file_240_1_0 {
	meta:
		name = "__hi0bits"
		size = 72
	strings:
		$1 = { 10 4A 03 1C 10 42 18 D0 00 20 FF 22 12 06 13 42 01 D1 08 30 1B 02 F0 22 12 06 13 42 01 D1 04 30 1B 01 C0 22 12 06 13 42 01 D1 02 30 9B 00 00 2B 02 DB 5A 00 04 D5 01 30 70 47 03 04 10 20 E4 E7 20 20 F9 E7 00 00 FF FF }
	condition:
		$1
}

rule file_240_2_0 {
	meta:
		name = "__lo0bits"
		size = 100
	strings:
		$1 = { 03 68 59 07 08 D0 DA 07 22 D4 99 07 24 D4 9B 08 03 60 02 22 10 1C 70 47 11 4A 13 42 15 D0 00 22 FF 21 0B 42 01 D1 08 32 1B 0A 19 07 01 D1 04 32 1B 09 99 07 01 D1 02 32 9B 08 D9 07 03 D4 5B 08 00 2B 07 D0 01 32 03 60 E4 E7 1B 0C 10 22 E7 E7 00 22 DF E7 20 22 DD E7 5B 08 03 60 01 22 D9 E7 FF FF 00 00 }
	condition:
		$1
}

rule file_240_3_0 {
	meta:
		name = "__mcmp"
		size = 58
	strings:
		$1 = { 30 B5 03 1C 0A 69 00 69 80 1A 00 28 0D D1 05 32 1D 1C 92 00 14 35 9B 18 89 18 04 3B 04 39 1C 68 0A 68 94 42 02 D1 9D 42 F7 D3 30 BD 94 42 01 D3 01 20 FA E7 01 20 40 42 F7 E7 }
	condition:
		$1
}

rule file_240_4_0 {
	meta:
		name = "__ulp"
		size = 80
	strings:
		$1 = { 10 B5 11 4A 03 1C 13 40 10 4A 9B 18 00 2B 02 DD 18 1C 00 21 10 BD 5B 42 1B 15 13 2B 0D DD 14 3B 1E 2B 04 DD 01 23 00 20 00 21 19 1C F2 E7 1F 22 D3 1A 01 22 9A 40 13 1C F5 E7 80 22 12 03 10 1C 18 41 00 21 E6 E7 C0 46 00 00 F0 7F 00 00 C0 FC }
	condition:
		$1
}

rule file_240_5_0 {
	meta:
		name = "__b2d"
		size = 168
		refs = "001c __hi0bits"
	strings:
		$1 = { F0 B5 47 46 80 B4 07 69 05 37 BF 00 C7 19 3C 1F 25 68 14 23 1B 18 28 1C 0E 1C 98 46 ?? ?? ?? ?? 20 23 1B 1A 33 60 0A 28 14 DC 0B 23 1B 1A A0 45 33 D2 08 3F 3A 68 DA 40 2E 1C DE 40 19 49 15 30 33 1C 85 40 14 1C 0B 43 2C 43 18 1C 21 1C 04 BC 90 46 F0 BD A0 45 15 D3 0B 38 00 22 00 28 17 D0 20 23 1B 1A 44 45 1A D9 04 3C 26 68 DE 40 0D 49 85 40 0D 43 11 1C D9 40 82 40 2B 1C 34 1C 0B 43 14 43 E2 E7 3C 1C 08 3C 0B 38 22 68 00 28 E7 D1 04 49 2B 1C 0B 43 14 1C D7 E7 00 22 CC E7 00 26 E5 E7 C0 46 00 00 F0 3F }
	condition:
		$1
}

rule file_240_6_0 {
	meta:
		name = "__ratio"
		size = 96
		refs = "000a __b2d 004a __divdf3"
	strings:
		$1 = { F0 B5 86 B0 0F 1C 05 A9 06 1C ?? ?? ?? ?? 04 1C 0D 1C 38 1C 04 A9 00 94 01 95 ?? ?? ?? ?? 02 1C 0B 1C 05 98 04 99 36 69 41 1A 38 69 30 1A 40 01 09 18 02 92 03 93 00 29 0B DD 00 98 09 05 09 18 00 91 00 9C 01 9D 29 1C 20 1C ?? ?? ?? ?? 06 B0 F0 BD 02 9B 09 05 59 1A 02 91 02 9A 03 9B F2 E7 }
	condition:
		$1
}

rule file_240_7_0 {
	meta:
		name = "_mprec_log10"
		size = 60
		refs = "0012 __muldf3"
	strings:
		$1 = { 10 B5 04 1C 17 28 09 DD 08 49 07 48 08 4A 09 4B 01 3C ?? ?? ?? ?? 00 2C F8 D1 10 BD 06 4B C4 00 1C 19 20 68 61 68 F8 E7 00 00 F0 3F 00 00 00 00 00 00 24 40 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_240_8_0 {
	meta:
		name = "__copybits"
		size = 66
	strings:
		$1 = { 70 B5 14 69 4D 1E 6D 11 05 34 01 35 16 1C A4 00 AD 00 14 36 14 19 45 19 A6 42 0B D2 01 1C 33 1C 04 CB 04 C1 9C 42 FB D8 F3 43 1B 19 9B 08 01 33 9B 00 C0 18 85 42 03 D9 00 23 08 C0 85 42 FC D8 70 BD }
	condition:
		$1
}

rule file_240_9_0 {
	meta:
		name = "__any_on"
		size = 70
	strings:
		$1 = { 10 B5 02 69 4B 11 9A 42 0D DA 13 1C 05 33 02 1C 9B 00 14 32 C0 18 82 42 13 D2 04 38 03 68 00 2B F9 D0 01 20 10 BD 9A 42 F0 DD 1F 22 11 40 ED D0 5A 1D 92 00 12 58 14 1C CC 40 8C 40 94 42 F0 D1 E4 E7 00 20 EE E7 }
	condition:
		$1
}

rule file_240_10_0 {
	meta:
		name = "_Balloc"
		size = 78
		refs = "0028 _calloc_r"
	strings:
		$1 = { 70 B5 04 1C C0 6C 0D 1C 00 28 0A D0 AB 00 C3 18 18 68 00 28 0E D0 02 68 1A 60 00 23 03 61 C3 60 70 BD 20 1C 04 21 10 22 ?? ?? ?? ?? E0 64 00 28 EC D1 F5 E7 01 26 AE 40 72 1D 92 00 20 1C 01 21 ?? ?? ?? ?? 00 28 EB D0 45 60 86 60 E5 E7 }
	condition:
		$1
}

rule file_240_11_0 {
	meta:
		name = "__d2b"
		size = 220
		refs = "0016 _Balloc 003e __lo0bits 0068 __hi0bits"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 82 B0 98 46 09 9B 0E 1C 01 21 9A 46 17 1C ?? ?? ?? ?? 2C 49 33 1C 2C 4A 0B 40 32 40 1D 0D 04 1C 00 92 00 2D 03 D0 80 21 49 03 0A 43 00 92 00 2F 1D D0 01 A8 01 97 ?? ?? ?? ?? 00 28 31 D1 01 9B 63 61 00 9B A3 61 00 2B 39 D1 01 26 26 61 00 2D 18 D1 1E 49 43 46 40 18 18 60 33 1D 9B 00 18 59 ?? ?? ?? ?? 76 01 36 1A 51 46 0E 60 13 E0 68 46 ?? ?? ?? ?? 00 9B 63 61 01 23 23 61 20 30 01 26 00 2D E6 D0 12 4B ED 18 35 23 2D 18 41 46 18 1A 53 46 0D 60 18 60 02 B0 20 1C 0C BC 90 46 9A 46 F0 BD 00 9B 20 22 12 1A 19 1C 91 40 0A 1C 01 99 C3 40 0A 43 62 61 00 93 A3 61 00 2B C5 D0 02 26 26 61 C4 E7 FF FF FF 7F FF FF 0F 00 CE FB FF FF CD FB FF FF }
	condition:
		$1
}

rule file_240_12_0 {
	meta:
		name = "__mdiff"
		size = 272
		refs = "0028 _Balloc"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 15 1C 0F 69 12 69 BF 1A 82 B0 0C 1C 00 2F 4E D0 00 2F 6D DB 0E 1C 00 27 14 36 61 68 ?? ?? ?? ?? 84 46 C7 60 20 69 43 1D 9B 00 E4 18 2B 69 05 33 9B 00 2F 1C 32 49 ED 18 63 46 A0 46 14 37 A9 46 14 33 00 22 10 CE 20 CF A2 46 00 95 0C 40 0D 40 64 1B 55 46 A4 18 2D 0C 00 9A AA 46 15 0C 52 46 55 1B 22 14 AD 18 2A 14 0C 40 2D 04 2C 43 10 C3 B9 45 E7 D8 46 45 13 D2 21 4C 80 CE 39 1C 21 40 51 18 0D 14 3F 0C ED 19 2A 14 21 40 2D 04 29 43 02 C3 B0 45 F1 D8 04 3B 1A 68 00 2A 04 D1 01 38 04 3B 1A 68 00 2A FA D0 63 46 18 61 16 E0 05 32 92 00 0E 1C 8B 18 14 36 AA 18 04 3B 19 68 04 3A 8C 46 11 68 8C 45 11 D1 9E 42 F6 D3 00 21 ?? ?? ?? ?? 01 23 03 61 00 23 43 61 84 46 02 B0 60 46 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 8C 45 94 D2 23 1C 2C 1C 26 1C 1D 1C 01 27 14 36 8D E7 C0 46 FF FF 00 00 }
	condition:
		$1
}

rule file_240_13_0 {
	meta:
		name = "__lshift"
		size = 188
		refs = "002c _Balloc"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0E 1C 34 69 55 11 01 34 B3 68 64 19 83 46 90 46 49 68 9C 42 03 DD 5B 00 01 31 9C 42 FB DC 58 46 ?? ?? ?? ?? 03 1C 81 46 14 33 00 2D 08 DD 00 22 00 21 01 32 02 C3 AA 42 FB D1 53 1D 9B 00 4B 44 35 69 05 35 32 1C AD 00 1F 20 41 46 14 32 75 19 01 40 88 46 23 D0 20 20 47 46 C7 1B BA 46 00 21 10 68 07 1C 40 46 87 40 39 43 02 C3 02 CA 57 46 F9 40 95 42 F4 D8 19 60 00 29 00 D0 01 34 59 46 72 68 CB 6C 92 00 D1 58 48 46 01 3C 31 60 D6 50 04 61 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 02 CA 02 C3 95 42 EB D9 02 CA 02 C3 95 42 F7 D8 E6 E7 }
	condition:
		$1
}

rule file_240_14_0 {
	meta:
		name = "__multiply"
		size = 348
		refs = "0032 _Balloc"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0D 1C 09 69 16 69 88 46 84 B0 17 1C B0 45 00 DA 97 E0 33 1C 98 46 0E 1C 42 46 AB 68 94 19 69 68 9C 42 00 DD 01 31 ?? ?? ?? ?? 63 1D 02 1C 9B 00 C3 18 14 32 02 90 03 93 9A 42 05 D2 03 98 13 1C 00 21 02 C3 98 42 FC D8 2B 1C 14 33 05 36 B6 00 01 93 43 46 AD 19 05 33 14 26 F6 19 9B 00 FB 18 B1 46 00 93 99 45 57 D2 38 4B A2 46 93 46 2C 1C 48 46 02 68 17 1C 1F 40 1F D0 01 99 5A 46 00 26 A0 46 20 C9 2C 1C 1C 40 38 1C 60 43 2D 0C 7D 43 14 68 84 46 1C 40 64 44 A4 19 16 68 30 0C 28 18 26 0C 80 19 06 0C 1C 40 00 04 20 43 01 C2 88 45 E7 D8 16 60 48 46 02 68 44 46 17 0C 00 2F 23 D0 5A 46 11 68 01 9A 0D 1C 58 46 00 26 A0 46 14 68 1C 40 A4 46 64 46 7C 43 A4 46 66 44 2D 0C 76 19 35 04 19 40 29 43 02 C0 02 CA 09 0C 0C 1C 7C 43 05 68 29 1C A4 46 19 40 36 0C 61 44 89 19 0E 0C 90 45 E4 D8 01 60 44 46 04 26 00 98 B1 44 48 45 01 D9 B3 44 AC E7 54 46 00 2C 08 DD 03 9B 02 E0 01 3C 00 2C 03 D0 04 3B 1A 68 00 2A F8 D0 02 99 04 B0 08 1C 0C 61 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 2B 1C 1F 1C 15 1C 66 E7 C0 46 FF FF 00 00 }
	condition:
		$1
}

rule file_240_15_0 {
	meta:
		name = "__i2b"
		size = 18
		refs = "0006 _Balloc"
	strings:
		$1 = { 10 B5 0C 1C 01 21 ?? ?? ?? ?? 01 23 44 61 03 61 10 BD }
	condition:
		$1
}

rule file_240_16_0 {
	meta:
		name = "__multadd"
		size = 156
		refs = "0070 _Balloc 0082 memcpy"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 81 46 22 48 0E 1C 1C 1C 0D 69 00 23 14 31 82 46 0F 68 B8 46 38 1C 57 46 38 40 50 43 20 18 04 0C 47 46 A4 46 3C 0C 54 43 A4 44 67 46 3C 0C 3F 04 BC 46 57 46 38 40 60 44 01 33 01 C1 9D 42 E7 DC 00 2C 07 D0 B3 68 9D 42 0A DA 6B 1D 9B 00 01 35 9C 51 35 61 30 1C 1C BC 90 46 99 46 A2 46 F0 BD 71 68 48 46 01 31 ?? ?? ?? ?? 32 69 31 1C 02 32 80 46 0C 31 92 00 0C 30 ?? ?? ?? ?? 72 68 48 46 C3 6C 92 00 D1 58 31 60 D6 50 46 46 DD E7 FF FF 00 00 }
	condition:
		$1
}

rule file_240_17_0 {
	meta:
		name = "__pow5mult"
		size = 180
		refs = "0048 __multiply 008e __multadd 009a __i2b"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 03 23 80 46 0E 1C 14 1C 13 40 36 D1 A4 10 00 2C 25 D0 42 46 95 6C 00 2D 39 D0 01 22 92 46 53 46 1C 42 0A D1 64 10 00 2C 19 D0 2F 68 00 2F 1B D0 38 1C 05 1C 53 46 1C 42 F4 D0 40 46 31 1C 2A 1C ?? ?? ?? ?? 00 2E 06 D0 42 46 D3 6C 72 68 92 00 D1 58 31 60 D6 50 64 10 06 1C 00 2C E5 D1 30 1C 0C BC 90 46 9A 46 F0 BD 29 1C 2A 1C 40 46 ?? ?? ?? ?? 28 60 07 60 05 1C DC E7 0A 4A 01 3B 9B 00 D3 18 9A 6C 00 23 ?? ?? ?? ?? 06 1C BE E7 40 46 05 49 ?? ?? ?? ?? 43 46 98 64 00 23 05 1C 03 60 BB E7 C0 46 ?? ?? ?? ?? 71 02 00 00 }
	condition:
		$1
}

rule file_240_18_0 {
	meta:
		name = "__s2b"
		size = 152
		refs = "0016 __divsi3 002c _Balloc 0050 __multadd"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 05 1C 18 1C 88 46 08 30 09 21 17 1C 1E 1C ?? ?? ?? ?? 01 28 3A DD 01 23 00 21 5B 00 01 31 98 42 FB DC 28 1C ?? ?? ?? ?? 07 9B 43 61 01 23 01 1C 03 61 09 2F 26 DD 09 22 92 46 C2 44 09 24 42 46 13 5D 28 1C 30 3B 0A 22 ?? ?? ?? ?? 01 34 01 1C A7 42 F4 DC 52 46 D3 19 08 3B 98 46 BE 42 0C DD 00 24 42 46 13 5D 28 1C 30 3B 0A 22 ?? ?? ?? ?? 01 34 E3 19 01 1C 9E 42 F3 DC 08 1C 0C BC 90 46 9A 46 F0 BD 0A 23 98 44 09 27 E7 E7 00 21 C8 E7 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "putchar"
		size = 20
		refs = "000a _putc_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 01 1C 18 68 82 68 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "_scanf_r"
		size = 26
		refs = "000e __svfscanf_r"
	strings:
		$1 = { 0E B4 00 B5 81 B0 02 AB 04 CB 41 68 00 93 ?? ?? ?? ?? 01 B0 08 BC 03 B0 18 47 }
	condition:
		$1
}

rule file_448_0_0 {
	meta:
		name = "_iscanf_r"
		size = 26
		refs = "000e __svfiscanf_r"
	strings:
		$1 = { 0E B4 00 B5 81 B0 02 AB 04 CB 41 68 00 93 ?? ?? ?? ?? 01 B0 08 BC 03 B0 18 47 }
	condition:
		$1
}

rule file_242_1_0 {
	meta:
		name = "scanf"
		size = 36
		refs = "0012 __svfscanf_r 0020 _impure_ptr"
	strings:
		$1 = { 0F B4 00 B5 06 49 81 B0 02 AB 08 68 04 CB 41 68 00 93 ?? ?? ?? ?? 01 B0 08 BC 04 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_448_1_0 {
	meta:
		name = "iscanf"
		size = 36
		refs = "0012 __svfiscanf_r 0020 _impure_ptr"
	strings:
		$1 = { 0F B4 00 B5 06 49 81 B0 02 AB 08 68 04 CB 41 68 00 93 ?? ?? ?? ?? 01 B0 08 BC 04 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "memcmp"
		size = 84
	strings:
		$1 = { 70 B5 04 1C 0B 1C 03 2A 1F D9 0D 1C 05 43 AE 07 10 D0 20 78 19 78 88 42 1A D1 01 3A 06 E0 01 34 01 33 20 78 19 78 01 3A 88 42 11 D1 00 2A F6 D1 00 20 70 BD 04 68 0B 68 9C 42 04 D1 04 3A 04 30 04 31 03 2A F6 D8 04 1C 0B 1C 00 2A E1 D1 EF E7 40 1A EE E7 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "strchr"
		size = 208
	strings:
		$1 = { 70 B5 09 06 09 0E 00 29 39 D0 82 07 0E D0 03 78 00 2B 57 D0 99 42 31 D0 03 22 04 E0 03 78 00 2B 50 D0 99 42 2A D0 01 30 10 42 F7 D1 0D 02 0D 43 2B 04 25 4A 1D 43 03 68 9C 18 24 4A 9C 43 14 42 12 D1 21 4E 6B 40 9C 19 9C 43 14 42 05 D0 0B E0 6B 40 9C 19 9C 43 14 42 06 D1 04 30 03 68 1A 4E 9C 19 9C 43 14 42 F3 D0 03 78 00 2B 04 D1 29 E0 01 30 03 78 00 2B 25 D0 99 42 F9 D1 70 BD 83 07 0A D0 03 78 00 2B F9 D0 03 22 02 E0 03 78 00 2B F4 D0 01 30 10 42 F9 D1 03 68 0B 4C 0B 49 1A 19 9A 43 0A 42 06 D1 04 30 03 68 07 4E 9A 19 9A 43 0A 42 F8 D0 03 78 00 2B E0 D0 01 30 03 78 00 2B FB D1 DB E7 00 20 D9 E7 FF FE FE FE 80 80 80 80 }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "ferror"
		size = 36
		refs = "0012 __sinit 0020 _impure_ptr"
	strings:
		$1 = { 10 B5 07 4B 04 1C 18 68 00 28 04 D0 83 6B 00 2B 01 D1 ?? ?? ?? ?? A0 89 40 06 C0 0F 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "__eprintf"
		size = 36
		refs = "0018 fiprintf 001c abort 0020 _impure_ptr"
	strings:
		$1 = { 70 B5 14 1C 06 4A 12 68 81 B0 06 1C 0D 1C D0 68 31 1C 00 93 2A 1C 23 1C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "_unlink_r"
		size = 36
		refs = "000c _unlink 0020 errno"
	strings:
		$1 = { 30 B5 07 4C 00 23 05 1C 23 60 08 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "_close_r"
		size = 36
		refs = "000c _close 0020 errno"
	strings:
		$1 = { 30 B5 07 4C 00 23 05 1C 23 60 08 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_433_0_0 {
	meta:
		name = "_isatty_r"
		size = 36
		refs = "000c _isatty 0020 errno"
	strings:
		$1 = { 30 B5 07 4C 00 23 05 1C 23 60 08 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_473_0_0 {
	meta:
		name = "_sbrk_r"
		size = 36
		refs = "000c _sbrk 0020 errno"
	strings:
		$1 = { 30 B5 07 4C 00 23 05 1C 23 60 08 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "_wait_r"
		size = 36
		refs = "000c _wait 0020 errno"
	strings:
		$1 = { 30 B5 07 4C 00 23 05 1C 23 60 08 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "fgetc"
		size = 60
		refs = "0026 __sinit 0030 __srget_r 0038 _impure_ptr"
		altNames = "getc"
	strings:
		$1 = { 30 B5 0D 4D 04 1C 28 68 00 28 02 D0 83 6B 00 2B 09 D0 63 68 01 3B 63 60 00 2B 07 DB 23 68 18 78 01 33 23 60 30 BD ?? ?? ?? ?? F2 E7 28 68 21 1C ?? ?? ?? ?? F6 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_250_1_0 {
	meta:
		name = "_fgetc_r"
		size = 52
		refs = "0024 __sinit 002e __srget_r"
		altNames = "_getc_r"
	strings:
		$1 = { 30 B5 05 1C 0C 1C 00 28 02 D0 83 6B 00 2B 09 D0 63 68 01 3B 63 60 00 2B 07 DB 23 68 18 78 01 33 23 60 30 BD ?? ?? ?? ?? F2 E7 28 1C 21 1C ?? ?? ?? ?? F6 E7 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "_mstats_r"
		size = 28
		refs = "000a fiprintf 0010 _malloc_stats_r"
	strings:
		$1 = { 10 B5 0A 1C 04 1C 04 49 C0 68 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_252_4_0 {
	meta:
		name = "mallinfo"
		size = 20
		refs = "0008 _mallinfo_r 0010 _impure_ptr"
	strings:
		$1 = { 10 B5 03 4B 04 1C 19 68 ?? ?? ?? ?? 20 1C 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_253_0_0 {
	meta:
		name = "tsearch"
		size = 78
		refs = "002e malloc"
	strings:
		$1 = { F0 B5 06 1C 17 1C 0D 1C 00 29 1E D0 2C 68 00 2C 0C D0 21 68 30 1C 00 F0 1A F8 00 28 13 D0 00 28 0E DB 2D 68 08 35 2C 68 00 2C F2 D1 0C 20 ?? ?? ?? ?? 00 28 03 D0 28 60 06 60 84 60 44 60 F0 BD 2D 68 04 35 E2 E7 28 68 F9 E7 00 20 F7 E7 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "towupper"
		size = 24
		refs = "0014 __ctype_ptr__"
	strings:
		$1 = { FE 28 06 D8 03 4B 1B 68 1B 18 5B 78 9A 07 00 D5 20 38 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "strncmp"
		size = 168
	strings:
		$1 = { 70 B5 00 2A 43 D0 0B 1C 03 43 9C 07 25 D1 04 1C 0D 1C 03 2A 3D D9 03 68 09 68 8B 42 39 D1 04 3A 00 2A 34 D0 1E 4E 1F 48 99 19 99 43 01 42 0C D0 2D E0 23 68 29 68 8B 42 2B D1 04 3A 00 2A 26 D0 17 4E 99 19 99 43 01 42 21 D1 04 34 04 35 03 2A EF D8 20 1C 29 1C 00 2A 1E D0 04 78 0D 78 01 3A AC 42 12 D1 00 2A 12 D0 00 2C 10 D0 01 3A 00 23 05 E0 00 2A 0B D0 01 33 00 2C 08 D0 01 3A C4 18 CD 18 64 78 6D 78 AC 42 F3 D0 60 1B 00 E0 00 20 70 BD 20 1C 29 1C E0 E7 24 78 2D 78 60 1B F7 E7 FF FE FE FE 80 80 80 80 }
	condition:
		$1
}

rule file_257_3_0 {
	meta:
		name = "_setlocale_r"
		size = 64
		refs = "0012 strcmp"
	strings:
		$1 = { F0 B5 05 1C 0F 1C 14 1C 00 2A 0A D0 0A 4E 10 1C 31 1C ?? ?? ?? ?? 00 28 05 D1 2F 63 6C 63 30 1C F0 BD 05 48 FC E7 20 1C 04 49 ?? ?? ?? ?? 00 28 F3 D0 00 20 F4 E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "exit"
		size = 36
		refs = "0006 __call_exitprocs 001a _exit 0020 _global_impure_ptr"
	strings:
		$1 = { 10 B5 00 21 04 1C ?? ?? ?? ?? 05 4B 18 68 C3 6B 00 2B 01 D0 00 F0 06 F8 20 1C ?? ?? ?? ?? C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "isnanf"
		size = 24
		altNames = "__isnanf"
	strings:
		$1 = { 04 4B 02 1C 1A 40 FF 23 DB 05 01 20 9A 42 00 DC 00 20 70 47 FF FF FF 7F }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "rshift"
		size = 158
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 06 1C 04 69 14 36 4A 11 33 1C A2 42 18 DA 05 32 92 00 85 18 05 34 A4 00 AA 46 1F 25 04 19 29 40 8C 46 17 D1 54 45 0B D9 52 46 02 CA 02 C3 94 42 FB D8 52 46 D3 43 1B 19 9B 08 06 33 9B 00 C3 18 9B 1B 9B 10 03 61 00 2B 00 D1 43 61 0C BC 90 46 9A 46 F0 BD 20 21 67 46 CF 1B 11 58 62 46 D1 40 52 46 04 32 B8 46 94 42 10 D9 15 68 47 46 BD 40 29 43 02 C3 02 CA 65 46 E9 40 94 42 F5 D8 57 46 E3 1B 05 3B 9B 08 06 33 9B 00 C3 18 19 60 00 29 D6 D0 04 33 D4 E7 }
	condition:
		$1
}

rule file_263_1_0 {
	meta:
		name = "__hexdig_init"
		size = 88
		refs = "0048 .LC8 004c __hexdig 0050 .LC5 0054 .LC0"
	strings:
		$1 = { 11 48 12 4B 10 21 30 22 99 54 01 31 02 78 09 06 09 0E 01 30 00 2A F7 D1 0D 48 1A 21 61 22 99 54 01 31 02 78 09 06 09 0E 01 30 00 2A F7 D1 09 48 1A 21 41 22 99 54 01 31 02 78 09 06 09 0E 01 30 00 2A F7 D1 70 47 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_263_2_0 {
	meta:
		name = "__gethex"
		size = 1184
		refs = "0122 _Balloc 017c __hi0bits 01e2 __hexdig_init 0272 _Bfree 02ec __lshift 0318 __hexdig 0322 __any_on 0490 memcpy"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 84 B0 03 93 C1 4D 30 23 EB 5C 81 46 0F 1C 90 46 00 2B 00 D1 DF E0 3A 68 91 78 94 1C 30 29 00 D0 84 E1 03 32 00 23 11 78 14 1C 01 33 01 32 30 29 F9 D0 6A 5C 00 2A 29 D0 00 20 22 1C 83 46 21 78 01 E0 01 32 11 78 6E 5C 00 2E FA D1 2E 29 00 D1 10 E1 16 1C 00 28 00 D1 4B E1 80 1B 80 00 32 78 82 46 50 2A 1D D0 70 2A 1B D0 32 1C 3A 60 5A 46 00 2A 45 D0 00 2B 00 D0 3E E1 06 24 04 B0 20 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 2E 29 00 D1 01 E1 22 78 00 21 01 20 26 1C 8A 46 83 46 50 2A E1 D1 72 78 71 1C 2B 2A 00 D1 2C E1 2D 2A 00 D1 24 E1 00 20 02 90 A8 5C 00 28 D6 D0 19 28 D4 DC 4A 1C 49 78 69 5C 10 38 00 29 10 D0 19 29 0E DC 9C 46 01 E0 19 29 09 DC 83 00 01 32 18 18 13 78 10 39 40 00 08 18 E9 5C 00 29 F3 D1 63 46 02 99 00 29 00 D0 40 42 3A 60 5A 46 82 44 00 2A B9 D1 73 1E 1B 1B 07 2B 00 DC 84 E1 00 21 5B 10 01 31 07 2B FB DC 48 46 ?? ?? ?? ?? 03 1C 14 33 07 1C 02 93 B4 42 00 D3 77 E1 0F 21 52 46 01 93 00 20 00 23 8B 46 00 92 BC 46 0A E0 20 2B 43 D0 19 1D AA 5C 5F 46 3A 40 9A 40 10 43 B4 42 07 D2 0B 1C 01 3E 32 78 2E 2A F0 D1 19 1C B4 42 F7 D3 00 99 67 46 8A 46 01 9C 02 9A 01 C4 A4 1A A4 10 3C 61 ?? ?? ?? ?? 43 46 64 01 1D 68 24 1A AC 42 00 DD C6 E0 AC 42 00 DA A7 E0 00 26 41 46 8B 68 9A 45 67 DC 40 46 43 68 9A 45 00 DA 85 E0 01 24 00 2E 0B D0 42 46 D3 68 02 2B 00 D1 3E E1 03 2B 00 D1 36 E1 01 2B 12 D0 10 23 1C 43 0D 9B 1F 60 03 9F 56 46 3E 60 5A E7 01 99 01 C1 01 91 00 20 32 78 04 21 00 23 B4 E7 ?? ?? ?? ?? 1C E7 B0 07 EA D5 02 99 0A 68 16 43 1E 42 E5 D0 3B 69 9B 46 58 46 05 30 80 00 02 9B 38 18 00 21 1A 68 56 1C 00 D0 31 E1 02 C3 98 42 F8 D8 BA 68 5B 46 93 45 00 DB 2C E1 3E 1C 5A 1D 92 00 01 21 01 33 91 51 33 61 37 1C 02 2C 00 D1 E4 E0 3B 69 9B 45 0E DB 1F 23 1D 40 00 D1 EC E0 5B 46 04 33 9B 00 D8 59 ?? ?? ?? ?? 20 23 5D 1B A8 42 00 DB E1 E0 01 21 38 1C FF F7 80 FE 42 46 01 21 93 68 8A 44 9A 45 00 DC D6 E0 48 46 39 1C ?? ?? ?? ?? 0D 9A 00 23 13 60 A3 24 03 E7 00 28 00 D0 EB E6 56 1C 52 78 AA 5C 00 2A 00 D1 D7 E0 32 1C 01 32 11 78 69 5C 00 29 FA D1 30 1C DD E6 62 78 A9 5C 66 1C 00 29 5D D1 01 20 8A 46 83 46 DC E6 51 46 5C 1A A5 42 64 DC 46 46 F2 68 02 2A 00 D1 8D E0 03 2A 00 D1 CB E0 01 2A 00 D1 B9 E0 48 46 39 1C ?? ?? ?? ?? 0D 9A 00 23 13 60 50 24 D1 E6 2C 1B 39 1C 48 46 22 1C ?? ?? ?? ?? 56 46 07 1C 36 1B 14 30 B2 46 02 90 4A E7 32 78 82 46 B4 E6 00 24 BF E6 01 20 02 90 01 31 0A 78 D7 E6 00 22 02 92 F9 E7 ?? ?? ?? ?? 64 1B 38 1C 21 1C ?? ?? ?? ?? 00 28 08 D1 00 26 38 1C 21 1C FF F7 16 FE A2 44 2E E7 00 23 80 E6 63 1E 1F 21 19 40 01 22 8A 40 11 1C 5A 11 05 32 92 00 D2 59 11 42 3A D0 01 2B 72 DD A1 1E 38 1C ?? ?? ?? ?? 00 28 6C D0 03 26 E1 E7 30 2A 32 D1 32 1C 01 32 11 78 30 29 FB D0 6B 5C 00 2B 2C D1 01 23 14 1C 30 1C 9B 46 65 E6 63 1E 9A 46 00 2E 1F D1 00 2B 04 DD 38 1C 19 1C ?? ?? ?? ?? 06 1C 51 46 4B 11 02 98 9B 00 1F 22 0A 40 C3 58 01 21 91 40 19 42 01 D0 02 23 1E 43 21 1C 38 1C FF F7 D1 FD 41 46 49 68 2D 1B 8A 46 02 24 EF E6 01 26 AE E7 01 26 E4 E7 31 78 32 1C 30 1C 00 26 14 1C B3 46 01 23 37 E6 0E 99 00 29 00 D0 73 E7 03 9E 02 98 0D 99 33 60 01 23 3B 61 03 60 0F 60 62 24 44 E6 40 46 03 68 01 3B AB 42 32 D1 1F 23 2B 40 01 22 9A 40 6B 11 05 33 9B 00 DB 59 1A 42 28 D0 21 24 D2 E6 00 21 7D E6 02 98 01 90 00 20 A1 E6 0E 9B 00 2B 00 D0 E0 E6 C5 E6 0E 9A 01 23 9B 1A F7 E7 02 26 74 E7 30 1C 0C E6 AC 42 00 D0 42 E7 01 2D CC DD 69 1E 38 1C ?? ?? ?? ?? 00 28 00 D1 39 E7 40 46 43 68 C2 E7 0E 9A 00 2A 00 D1 32 E7 BD E7 22 24 A9 E6 01 32 1A 60 DA E6 79 68 48 46 01 31 ?? ?? ?? ?? 3A 69 39 1C 02 32 06 1C 0C 31 92 00 0C 30 ?? ?? ?? ?? 48 46 39 1C ?? ?? ?? ?? 33 69 BF E6 }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "__sflags"
		size = 108
	strings:
		$1 = { 70 B5 0B 78 72 2B 21 D0 77 2B 1A D0 61 2B 03 D0 16 23 03 60 00 20 70 BD 82 23 84 20 9B 00 01 25 40 00 4C 78 00 2C 09 D0 2B 2C 19 D0 8E 78 2B 2E 16 D0 62 2C 0E D0 89 78 62 29 0B D0 2B 43 13 60 E9 E7 C0 23 DB 00 01 25 08 20 EA E7 00 23 00 25 04 20 E6 E7 80 21 49 02 0D 43 2B 43 13 60 DA E7 1C 25 A8 43 10 25 28 43 02 25 E2 E7 }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "ldexp"
		size = 96
		refs = "0008 finite 0018 __eqdf2 002c scalbn 004c __errno"
	strings:
		$1 = { 70 B5 04 1C 0D 1C 16 1C ?? ?? ?? ?? 00 28 07 D0 20 1C 29 1C 11 4B 10 4A ?? ?? ?? ?? 00 28 02 D1 29 1C 20 1C 70 BD 20 1C 29 1C 32 1C ?? ?? ?? ?? 04 1C 0D 1C ?? ?? ?? ?? 00 28 07 D0 20 1C 29 1C 06 4B 05 4A ?? ?? ?? ?? 00 28 E9 D1 ?? ?? ?? ?? 22 23 03 60 E4 E7 C0 46 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "towlower"
		size = 24
		refs = "0014 __ctype_ptr__"
	strings:
		$1 = { FE 28 06 D8 03 4B 1B 68 1B 18 5B 78 DA 07 00 D5 20 30 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "gmtime"
		size = 20
		refs = "0008 gmtime_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 19 68 7C 31 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_379_0_0 {
	meta:
		name = "localtime"
		size = 20
		refs = "0008 localtime_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 19 68 7C 31 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_269_0_0 {
	meta:
		name = "_putenv_r"
		size = 66
		refs = "0004 _strdup_r 0010 index 0024 _setenv_r 002e _free_r"
	strings:
		$1 = { 70 B5 05 1C ?? ?? ?? ?? 04 1C 00 28 17 D0 3D 21 ?? ?? ?? ?? 00 28 0E D0 00 23 03 70 42 1C 21 1C 28 1C 01 23 ?? ?? ?? ?? 21 1C 06 1C 28 1C ?? ?? ?? ?? 30 1C 70 BD 28 1C 21 1C ?? ?? ?? ?? 01 26 F7 E7 }
	condition:
		$1
}

rule file_270_0_0 {
	meta:
		name = "_ftell_r"
		size = 122
		refs = "0062 _fflush_r 006a __sinit"
	strings:
		$1 = { 70 B5 05 1C 0C 1C 00 28 02 D0 83 6B 00 2B 2C D0 A3 6A 00 2B 2C D0 A3 89 1A 07 20 D4 DA 04 13 D5 20 6D 5A 07 07 D5 63 68 C0 1A 23 6B 00 2B 01 D0 E3 6B C0 1A 70 BD 1A 07 FC D5 23 68 00 2B F9 D0 22 69 9B 1A C0 18 F5 E7 01 23 E1 69 A6 6A 28 1C 00 22 00 F0 1D F8 43 1C EC D0 A3 89 E1 E7 28 1C 21 1C ?? ?? ?? ?? A3 89 D8 E7 ?? ?? ?? ?? CF E7 1D 23 01 20 2B 60 40 42 DC E7 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "__sfvwrite_r"
		size = 800
		refs = "007e __swsetup_r 00d0 memmove 00de _fflush_r 0122 _realloc_r 0132 _free_r 0262 memchr 02c2 _malloc_r 02d2 memcpy"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 93 68 84 B0 01 90 0C 1C 16 1C 00 2B 27 D0 8B 89 1A 1C 18 07 2B D5 09 69 00 29 28 D0 35 68 90 07 31 D5 80 22 00 21 D3 00 88 46 00 27 9A 46 00 2F 6B D0 E1 69 3B 1C 57 45 01 D9 80 23 DB 00 62 6A 01 98 94 46 42 46 00 F0 65 F9 00 28 00 DC 6F E0 B3 68 80 44 3F 1A 18 1A B0 60 00 28 E7 D1 00 20 04 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 01 98 21 1C ?? ?? ?? ?? 00 28 00 D0 3E E1 A3 89 1A 1C 35 68 90 07 CD D4 D0 07 59 D5 00 21 00 91 8A 46 8B 46 0F 1C 00 2F 31 D0 00 9B 00 2B 00 D1 D7 E0 D1 46 BA 45 00 D9 B9 46 63 69 A2 68 D2 18 90 46 20 68 91 45 00 DC 8E E0 22 69 90 42 00 D8 8A E0 59 46 42 46 ?? ?? ?? ?? 23 68 43 44 23 60 01 98 21 1C ?? ?? ?? ?? 00 28 2A D1 51 46 42 46 89 1A 8A 46 00 29 00 D1 89 E0 B3 68 40 46 1B 1A C3 44 3F 1A B3 60 00 2B B2 D0 00 2F CD D1 29 68 00 22 6F 68 8B 46 08 35 00 92 C4 E7 28 68 6F 68 80 46 08 35 8C E7 01 98 ?? ?? ?? ?? 80 46 00 28 00 D0 D9 E0 21 69 01 98 ?? ?? ?? ?? 01 99 0C 23 0B 60 A2 89 40 23 13 43 01 20 A3 81 40 42 90 E7 00 22 80 20 92 46 90 22 81 00 D2 00 C0 00 02 92 03 90 00 27 8B 46 00 2F 24 D0 A1 68 5A 46 88 46 13 42 24 D0 89 46 47 45 61 D2 20 68 B8 46 B9 46 4A 46 51 46 ?? ?? ?? ?? A3 68 40 46 1B 1A A3 60 23 68 4B 44 23 60 B8 46 B9 46 4B 46 FF 1A B3 68 40 46 1B 1A CA 44 B3 60 00 2B 00 D1 60 E7 A3 89 00 2F DA D1 28 68 6F 68 82 46 08 35 D3 E7 20 68 89 46 B8 45 2C D2 23 69 98 42 29 D9 51 46 42 46 ?? ?? ?? ?? 23 68 43 44 23 60 01 98 21 1C ?? ?? ?? ?? 00 28 D9 D0 AC E7 99 45 2D DB 62 6A E1 69 94 46 01 98 5A 46 00 F0 96 F8 80 46 00 28 A0 DD 51 46 42 46 89 1A 8A 46 00 29 00 D0 75 E7 01 98 21 1C ?? ?? ?? ?? 00 28 93 D1 00 23 00 93 6C E7 63 69 9F 42 2B D3 62 6A E1 69 94 46 01 98 52 46 00 F0 79 F8 80 46 00 28 83 DD 81 46 AD E7 02 98 03 42 29 D1 20 68 9B E7 59 46 4A 46 ?? ?? ?? ?? A3 68 48 46 1B 1A A3 60 23 68 4B 44 23 60 C8 46 44 E7 58 46 0A 21 3A 1C ?? ?? ?? ?? 00 28 48 D0 01 30 59 46 41 1A 01 22 8A 46 00 92 19 E7 51 46 3A 1C ?? ?? ?? ?? A3 68 DB 1B A3 60 23 68 DB 19 B8 46 23 60 B9 46 80 E7 21 69 22 68 52 1A 00 92 62 69 50 00 82 18 D0 0F 82 18 00 98 52 10 01 30 91 46 C0 19 81 45 01 D2 81 46 02 1C 03 98 03 42 00 D1 30 E7 01 98 11 1C ?? ?? ?? ?? 80 46 00 28 00 D1 33 E7 00 9A 21 69 ?? ?? ?? ?? A3 89 10 4A 80 20 13 40 03 43 A3 81 00 9B 49 46 18 1C 42 46 40 44 CB 1A 22 61 20 60 61 61 B8 46 A3 60 B9 46 3E E7 7B 1C 01 20 9A 46 00 90 D2 E6 A2 89 40 23 13 43 01 99 A3 81 01 20 09 23 0B 60 40 42 A8 E6 C0 46 7F FB FF FF }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "argz_add"
		size = 68
		refs = "0016 strlen 0024 realloc 0034 memcpy"
	strings:
		$1 = { F0 B5 47 46 80 B4 0B 68 06 1C 0C 1C 15 1C 98 46 00 2A 11 D0 10 1C ?? ?? ?? ?? 21 68 47 1C 79 18 21 60 30 68 ?? ?? ?? ?? 30 60 00 28 08 D0 40 44 29 1C 3A 1C ?? ?? ?? ?? 00 20 04 BC 90 46 F0 BD 0C 20 FA E7 }
	condition:
		$1
}

rule file_276_0_0 {
	meta:
		name = "isspace"
		size = 20
		refs = "0010 __ctype_ptr__"
	strings:
		$1 = { 03 4B 1B 68 18 18 40 78 08 23 18 40 70 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "_lrand48_r"
		size = 28
		refs = "0008 __dorand48"
	strings:
		$1 = { 10 B5 01 1C AC 31 04 1C ?? ?? ?? ?? AE 23 E0 5A B0 23 E3 5A 40 08 DB 03 C0 18 10 BD }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "wcsnlen"
		size = 40
	strings:
		$1 = { 03 68 00 2B 0E D0 00 29 0C D0 01 39 03 1C 02 E0 00 29 04 D0 01 39 04 33 1A 68 00 2A F8 D1 18 1A 80 10 70 47 00 20 FC E7 }
	condition:
		$1
}

rule file_279_0_0 {
	meta:
		name = "copysign"
		size = 24
	strings:
		$1 = { F0 B5 80 23 1B 06 13 40 02 4A 04 1C 14 40 18 1C 20 43 F0 BD FF FF FF 7F }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "l64a"
		size = 84
		refs = "004c _impure_ptr"
	strings:
		$1 = { 70 B5 12 4B 19 68 02 1C 08 1C D4 30 00 2A 1A D0 0F 4C 3F 23 13 40 E5 5C D4 23 CD 54 0E 1C 0B 1C 92 09 D5 33 D9 36 3F 25 00 2A 09 D0 11 1C 29 40 61 5C 19 70 B3 42 05 D0 92 09 01 33 00 2A F5 D1 00 22 1A 70 70 BD 03 1C FA E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_280_1_0 {
	meta:
		name = "_l64a_r"
		size = 76
	strings:
		$1 = { F0 B5 07 1C D4 37 00 29 1B D0 0F 4C 3F 23 0B 40 E2 5C D4 23 C2 54 06 1C 03 1C 89 09 D5 33 D9 36 3F 25 00 29 09 D0 0A 1C 2A 40 A2 5C 1A 70 B3 42 05 D0 89 09 01 33 00 29 F5 D1 00 22 1A 70 38 1C F0 BD 3B 1C F9 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "isalnum"
		size = 20
		refs = "0010 __ctype_ptr__"
	strings:
		$1 = { 03 4B 1B 68 18 18 40 78 07 23 18 40 70 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "_wcstoull_r"
		size = 506
		refs = "002e iswspace 007e __udivdi3 0098 iswdigit 00c6 __muldi3 00f0 iswalpha 00fa iswupper 0190 __umoddi3"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 89 B0 83 46 06 91 07 92 1F 1C 01 2B 00 D1 8D E0 00 2B 00 DA 8A E0 24 2B 00 DD 87 E0 06 9E 10 CE 20 1C ?? ?? ?? ?? 00 28 F9 D1 2D 2C 00 D1 AD E0 2B 2C 00 D1 8A E0 00 23 08 93 7B 42 7B 41 10 2F 02 D0 00 2B 00 D1 95 E0 30 2C 00 D1 B3 E0 00 2B 00 D1 C0 E0 30 2C 00 D1 A5 E0 0A 20 00 21 04 90 05 91 05 22 92 46 0A 27 04 9A 05 9B 01 20 40 42 C1 17 ?? ?? ?? ?? 88 46 81 46 00 20 00 21 43 46 00 90 01 91 20 1C B8 46 00 25 1F 1C ?? ?? ?? ?? 00 28 26 D0 30 3C A0 45 31 DD 01 99 8F 42 5C D3 8F 42 57 D0 00 2D 58 DB 54 45 02 DD 00 9B 99 45 5A D0 04 9A 05 9B 00 98 01 99 ?? ?? ?? ?? 02 94 E4 17 03 94 02 1C 0B 1C 02 98 03 99 80 18 59 41 00 90 01 91 10 CE 01 25 20 1C ?? ?? ?? ?? 00 28 D8 D1 20 1C ?? ?? ?? ?? 00 28 08 D0 20 1C ?? ?? ?? ?? 00 28 35 D1 57 23 E4 1A A0 45 CD DC 00 2D 48 DB 08 9B 00 2B 06 D0 00 9A 01 9B 00 21 50 42 99 41 00 90 01 91 07 9B 00 2B 0E D0 00 2D 01 D0 04 3E 06 96 06 9C 07 98 04 60 06 E0 00 21 00 22 16 23 58 46 00 91 01 92 03 60 00 98 01 99 09 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 20 10 CE 08 90 72 E7 00 9A 91 45 A4 D2 01 25 6D 42 10 CE BA E7 37 23 E4 1A C8 E7 01 98 87 42 A1 D1 01 25 6D 42 F4 E7 FA 17 04 97 05 92 01 20 40 42 C1 17 04 9A 05 9B ?? ?? ?? ?? 82 46 6D E7 01 22 10 CE 08 92 52 E7 22 23 59 46 0B 60 01 22 52 42 D3 17 00 92 01 93 B7 E7 07 21 08 22 00 23 8A 46 04 92 05 93 08 27 58 E7 32 68 58 2A 02 D0 78 2A 00 D0 45 E7 0F 21 10 22 00 23 74 68 8A 46 08 36 04 92 05 93 10 27 48 E7 F9 17 05 91 04 97 01 20 40 42 C1 17 04 9A 05 9B ?? ?? ?? ?? 82 46 3C E7 }
	condition:
		$1
}

rule file_286_0_0 {
	meta:
		name = "_strdup_r"
		size = 40
		refs = "0008 strlen 0012 _malloc_r 0020 memcpy"
	strings:
		$1 = { 70 B5 04 1C 08 1C 0E 1C ?? ?? ?? ?? 45 1C 29 1C 20 1C ?? ?? ?? ?? 04 1C 00 28 03 D0 31 1C 2A 1C ?? ?? ?? ?? 20 1C 70 BD }
	condition:
		$1
}

rule file_287_0_0 {
	meta:
		name = "stpcpy"
		size = 68
	strings:
		$1 = { 30 B5 0B 1C 03 43 9A 07 0E D1 0B 68 0B 4C 1A 19 0B 4C 9A 43 22 42 07 D1 08 C0 04 31 0B 68 07 4D 5A 19 9A 43 22 42 F7 D0 0B 78 02 1C 03 70 01 31 01 30 00 2B F8 D1 10 1C 30 BD C0 46 FF FE FE FE 80 80 80 80 }
	condition:
		$1
}

rule file_289_0_0 {
	meta:
		name = "_fwalk_reent"
		size = 96
		refs = "000c __sfp_lock_acquire 004e __sfp_lock_release"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 80 46 8A 46 ?? ?? ?? ?? B8 22 92 00 16 1C 46 44 00 2E 1F D0 00 27 75 68 B4 68 01 3D 01 D5 0F E0 68 34 0C 22 A3 5E 00 2B 08 D0 0E 22 A3 5E 01 33 04 D0 40 46 21 1C 00 F0 3C F8 07 43 01 3D EF D5 36 68 00 2E E7 D1 ?? ?? ?? ?? 38 1C 0C BC 90 46 9A 46 F0 BD 00 27 F6 E7 }
	condition:
		$1
}

rule file_289_1_0 {
	meta:
		name = "_fwalk"
		size = 88
		refs = "000a __sfp_lock_acquire 0048 __sfp_lock_release"
	strings:
		$1 = { F0 B5 47 46 80 B4 06 1C 88 46 ?? ?? ?? ?? B8 22 92 00 B6 18 00 2E 1D D0 00 27 75 68 B4 68 01 3D 01 D5 0E E0 68 34 0C 22 A3 5E 00 2B 07 D0 0E 22 A3 5E 01 33 03 D0 20 1C 00 F0 0E F8 07 43 01 3D F0 D5 36 68 00 2E E8 D1 ?? ?? ?? ?? 38 1C 04 BC 90 46 F0 BD 00 27 F7 E7 }
	condition:
		$1
}

rule file_290_0_0 {
	meta:
		name = "wcscmp"
		size = 26
	strings:
		$1 = { 10 B5 00 23 C2 58 CC 58 A2 42 04 D1 04 33 00 2A F8 D1 00 20 10 BD 10 1B FC E7 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "__exp10"
		size = 68
		refs = "000c __exp10 0014 __muldf3"
	strings:
		$1 = { 00 B5 04 28 11 D9 C3 07 07 D4 40 08 ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? 00 BD 01 38 ?? ?? ?? ?? 06 4B 05 4A ?? ?? ?? ?? F6 E7 05 4B C0 00 18 18 41 68 00 68 F0 E7 C0 46 00 00 24 40 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "lflush"
		size = 22
		refs = "0010 fflush"
	strings:
		$1 = { 00 B5 82 89 09 23 13 40 09 2B 01 D0 00 20 00 BD ?? ?? ?? ?? FB E7 }
	condition:
		$1
}

rule file_292_1_0 {
	meta:
		name = "__srefill_r"
		size = 264
		refs = "0078 _free_r 0096 __sinit 00b4 _fwalk 00d0 __smakebuf_r 00e0 _fflush_r 00fc _global_impure_ptr 0100 lflush"
	strings:
		$1 = { 70 B5 05 1C 0C 1C 00 28 02 D0 83 6B 00 2B 42 D0 80 23 A2 89 9B 01 1A 42 06 D1 13 43 A3 81 62 6E 35 4B 13 40 63 66 A2 89 00 23 63 60 93 06 2F D4 53 07 19 D4 D3 06 4E D5 13 07 4F D4 04 23 1A 43 A2 81 23 69 00 2B 41 D0 A3 89 9A 07 2F D1 22 69 E1 69 22 60 63 69 26 6A 28 1C 00 F0 60 F8 60 60 00 28 1B DD 00 20 70 BD 21 6B 00 29 E9 D0 23 1C 40 33 99 42 02 D0 28 1C ?? ?? ?? ?? 00 23 23 63 E3 6B 63 60 00 2B DC D0 A3 6B 00 20 23 60 EA E7 01 20 40 42 E7 E7 ?? ?? ?? ?? B9 E7 00 28 0C D1 A2 89 20 23 13 43 01 20 A3 81 40 42 DB E7 13 4B 13 49 18 68 ?? ?? ?? ?? C9 E7 00 23 63 60 A2 89 40 23 13 43 01 20 A3 81 40 42 CC E7 28 1C 21 1C ?? ?? ?? ?? B8 E7 09 23 2B 60 F0 E7 28 1C 21 1C ?? ?? ?? ?? 00 28 D3 D1 A2 89 06 4B 1A 40 A2 81 A0 60 A0 61 A2 E7 C0 46 FF DF FF FF ?? ?? ?? ?? ?? ?? ?? ?? F7 FF 00 00 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "ffs"
		size = 26
	strings:
		$1 = { 00 28 08 D0 00 23 01 21 02 1C 1A 41 01 33 0A 42 FA D0 18 1C 70 47 00 23 FB E7 }
	condition:
		$1
}

rule file_296_0_0 {
	meta:
		name = "strncpy"
		size = 96
	strings:
		$1 = { F0 B5 0B 1C 03 43 9C 07 01 D1 03 2A 15 D8 04 1C 00 2A 03 D1 10 E0 01 31 00 2A 0D D0 0B 78 01 3A 23 70 01 34 00 2B F6 D1 00 2A 05 D0 00 23 00 21 E1 54 01 33 93 42 FB D1 F0 BD 07 4E 04 1C 0B 68 06 4F DD 19 9D 43 35 42 E2 D1 04 3A 08 C4 04 31 03 2A F4 D8 DC E7 C0 46 80 80 80 80 FF FE FE FE }
	condition:
		$1
}

rule file_301_0_0 {
	meta:
		name = "wcsncpy"
		size = 46
	strings:
		$1 = { 10 B5 00 23 03 60 00 2A 0F D0 0B 68 00 2B 0C D0 04 1C 03 E0 04 31 0B 68 00 2B 03 D0 01 3A 08 C4 00 2A F7 D1 00 23 23 60 10 BD 04 1C FA E7 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "memseeker"
		size = 102
	strings:
		$1 = { 10 B5 04 1C 01 2B 23 D0 02 2B 24 D0 10 1C 00 28 24 DB CA 68 0B 69 9A 42 05 D3 C8 60 98 42 0C D3 8A 68 13 60 10 BD 4B 68 0C 7E 1B 68 9C 54 00 23 0B 76 0B 69 C8 60 98 42 F2 D2 4B 68 1A 68 12 5C 0A 76 1B 68 00 22 1A 54 8B 68 CA 68 1A 60 E9 E7 C8 68 10 18 DB E7 08 69 10 18 D8 E7 16 23 01 20 23 60 40 42 DE E7 }
	condition:
		$1
}

rule file_302_1_0 {
	meta:
		name = "memwriter"
		size = 158
		refs = "0028 memcpy 005c memset 0078 _realloc_r"
	strings:
		$1 = { F0 B5 47 46 80 B4 17 1C 1D 1C CA 68 4B 68 0C 1C 1E 68 A9 18 3B D4 63 69 99 42 23 D2 23 69 93 42 19 D3 B0 18 39 1C 2A 1C ?? ?? ?? ?? E3 68 22 69 EB 18 E3 60 93 42 0B D8 F6 18 33 78 23 76 00 23 33 70 A3 68 E2 68 1A 60 28 1C 04 BC 90 46 F0 BD 23 61 F6 18 F3 E7 D2 1A F0 18 00 21 ?? ?? ?? ?? E2 68 DE E7 5A 00 D3 18 01 31 5B 08 88 46 98 45 00 D2 98 46 31 1C 42 46 ?? ?? ?? ?? 06 1C 00 28 0A D0 63 68 18 60 43 46 63 61 E2 68 C6 E7 1B 23 01 25 03 60 6D 42 D7 E7 01 25 6D 42 D4 E7 }
	condition:
		$1
}

rule file_302_2_0 {
	meta:
		name = "memcloser"
		size = 40
		refs = "0010 _realloc_r 0020 _free_r"
	strings:
		$1 = { 30 B5 4B 68 0C 1C 19 68 A3 68 1A 68 01 32 05 1C ?? ?? ?? ?? 00 28 01 D0 63 68 18 60 28 1C 21 68 ?? ?? ?? ?? 00 20 30 BD }
	condition:
		$1
}

rule file_302_3_0 {
	meta:
		name = "_open_memstream_r"
		size = 216
		refs = "0018 __sfp 0026 _malloc_r 00a8 __sfp_lock_acquire 00ae __sfp_lock_release 00b6 _free_r 00cc memwriter 00d0 memseeker 00d4 memcloser"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 07 1C 8A 46 90 46 00 2A 42 D0 00 29 40 D0 ?? ?? ?? ?? 04 1C 00 28 35 D0 38 1C 1C 21 ?? ?? ?? ?? 05 1C 00 28 46 D0 42 46 13 68 43 61 3F 2B 33 D9 80 22 52 02 93 42 00 D9 42 61 00 23 42 46 13 60 38 1C 69 69 99 46 ?? ?? ?? ?? 53 46 06 1C 18 60 00 28 24 D0 4A 46 53 46 02 70 6B 60 4B 46 2B 76 2B 61 01 23 5B 42 E3 81 08 23 A3 81 15 4B 63 62 15 4B 42 46 A3 62 14 4B AA 60 4A 46 2D 60 22 62 E5 61 E3 62 20 1C 1C BC 90 46 99 46 A2 46 F0 BD 16 23 3B 60 00 24 F5 E7 40 23 43 61 CD E7 ?? ?? ?? ?? A6 81 ?? ?? ?? ?? 38 1C 29 1C ?? ?? ?? ?? 00 24 E7 E7 ?? ?? ?? ?? A5 81 ?? ?? ?? ?? 00 24 E0 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_303_0_0 {
	meta:
		name = "strncasecmp"
		size = 156
		refs = "0098 __ctype_ptr__"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 8B 46 00 2A 40 D0 21 4B 1B 68 57 1E 9C 46 00 25 01 23 13 E0 5E 46 74 5D 61 46 0E 19 76 78 90 46 1E 40 B1 46 1C D1 26 1C 46 45 1D D1 00 2F 1B D0 00 2A 19 D0 01 35 00 2C 16 D0 01 3F 42 5D 61 46 8C 18 64 78 1C 40 A2 46 E4 D0 20 24 A4 18 5E 46 A0 46 74 5D 61 46 0E 19 76 78 1E 40 B1 46 E2 D0 26 1C 20 36 46 45 E1 D0 53 46 00 2B 00 D0 20 32 4E 46 00 2E 06 D1 10 1B 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 20 34 F6 E7 00 20 F5 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "getsubopt"
		size = 200
		refs = "0092 strcmp 00c4 suboptarg"
	strings:
		$1 = { 70 B5 30 4E 00 23 13 60 0D 1C 33 60 00 28 03 D1 01 24 64 42 20 1C 70 BD 03 68 00 2B F8 D0 19 78 00 29 09 D0 20 29 03 D0 2C 29 01 D0 09 29 07 D1 01 33 19 78 00 29 F5 D1 01 24 03 60 64 42 E9 E7 33 60 01 33 19 78 00 29 17 D0 2C 29 05 D0 3D 29 24 D0 20 29 01 D0 09 29 F3 D1 00 22 1A 70 01 33 1A 78 00 2A 09 D0 20 2A 03 D0 2C 2A 01 D0 09 2A 03 D1 01 33 1A 78 00 2A F5 D1 03 60 29 68 00 29 C6 D0 00 24 04 E0 04 35 29 68 00 29 C0 D0 01 34 30 68 ?? ?? ?? ?? 00 28 F5 D1 BB E7 00 21 19 70 01 33 13 60 1A 78 2C 2A 09 D0 00 2A D9 D0 20 2A D3 D0 09 2A D1 D0 01 33 1A 78 2C 2A F5 D1 00 2A CB D1 CE E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "__srget_r"
		size = 56
		refs = "0014 __srefill_r 0032 __sinit"
	strings:
		$1 = { 30 B5 05 1C 0C 1C 00 28 02 D0 83 6B 00 2B 10 D0 28 1C 21 1C ?? ?? ?? ?? 00 28 07 D1 63 68 01 3B 63 60 23 68 18 78 01 33 23 60 30 BD 01 20 40 42 FB E7 ?? ?? ?? ?? EB E7 }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "_malloc_trim_r"
		size = 160
		refs = "0006 __malloc_lock 002a _sbrk_r 0038 __malloc_unlock 008c __malloc_av_ 0098 __malloc_current_mallinfo 009c __malloc_sbrk_base"
	strings:
		$1 = { F0 B5 0F 1C 04 1C ?? ?? ?? ?? 20 4D AB 68 5E 68 1F 4A 03 23 9E 43 B3 18 DF 1B 3F 0B 01 3F 1D 4B 3F 03 9F 42 07 DD 20 1C 00 21 ?? ?? ?? ?? AB 68 9B 19 98 42 04 D0 20 1C ?? ?? ?? ?? 00 20 F0 BD 79 42 20 1C ?? ?? ?? ?? 01 30 0D D0 AB 68 F6 1B 01 22 16 43 5E 60 10 4B 1A 68 D7 1B 20 1C 1F 60 ?? ?? ?? ?? 01 20 EA E7 20 1C 00 21 ?? ?? ?? ?? AB 68 C2 1A 0F 2A DE DD 08 49 09 68 40 1A 06 49 08 60 01 21 0A 43 5A 60 D5 E7 C0 46 ?? ?? ?? ?? EF 0F 00 00 FF 0F 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_310_1_0 {
	meta:
		name = "_free_r"
		size = 424
		refs = "0012 __malloc_lock 00c4 __malloc_unlock 0134 _malloc_trim_r 0190 __malloc_av_ 019c __malloc_trim_threshold 01a0 __malloc_top_pad"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 05 1C 0C 1C 00 29 5B D0 08 3C ?? ?? ?? ?? 67 68 01 20 3B 1C 83 43 E2 18 80 46 50 68 03 21 88 43 59 49 8E 68 B4 46 94 45 6A D0 46 46 50 60 37 42 0B D1 26 68 A4 1B 9B 19 0F 1C A6 68 08 37 BE 42 00 D1 76 E0 E7 68 F7 60 BE 60 00 27 BA 46 17 18 7F 68 01 26 B0 46 37 42 07 D1 57 46 1B 18 00 2F 32 D0 90 68 D2 68 C2 60 90 60 01 22 18 1C 10 43 57 46 60 60 E3 50 00 2F 1F D1 44 48 83 42 31 D9 5A 0A 04 2A 58 D8 9E 09 38 36 F0 00 08 18 82 68 82 42 57 D0 51 68 03 26 B1 43 8B 42 08 D2 03 26 03 E0 51 68 B1 43 8B 42 02 D2 92 68 90 42 F8 D1 D3 68 E3 60 A2 60 D4 60 9C 60 28 1C ?? ?? ?? ?? 0C BC 90 46 9A 46 F0 BD 31 4E 90 68 B4 46 60 45 C8 D1 47 46 1F 43 C4 60 84 60 E0 60 A0 60 67 60 E3 50 EA E7 DB 08 98 10 82 40 48 68 DB 00 02 43 4A 60 C9 18 8B 68 E1 60 A3 60 DC 60 8C 60 DC E7 C3 18 40 46 07 42 06 D1 22 68 A4 1A A0 68 9B 18 E2 68 C2 60 90 60 01 22 1A 43 62 60 1D 4A 12 68 8C 60 93 42 C9 D3 1C 4B 28 1C 19 68 ?? ?? ?? ?? C3 E7 01 26 B2 46 8A E7 14 2A 0C D8 16 1C 5B 36 F0 00 A3 E7 B6 10 01 23 B3 40 1E 1C 4B 68 1E 43 4E 60 13 1C AD E7 54 2A 03 D8 1E 0B 6E 36 F0 00 94 E7 AA 20 40 00 82 42 03 D8 DE 0B 77 36 F0 00 8C E7 0A 48 82 42 03 D9 FC 20 80 00 7E 26 85 E7 9E 0C 7C 36 F0 00 81 E7 ?? ?? ?? ?? FF 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 54 05 00 00 }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "envz_merge"
		size = 180
		refs = "0022 argz_next 0038 strdup 0040 strchr 0052 envz_entry 005c free 009a envz_add 00ac argz_add"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 9B 46 09 9B 06 1C 0D 1C 91 46 9A 46 00 27 00 24 22 1C 48 46 59 46 ?? ?? ?? ?? 04 1C 00 28 21 D0 00 2F 1F D1 53 46 00 2B 23 D1 20 1C ?? ?? ?? ?? 3D 21 80 46 ?? ?? ?? ?? 00 28 01 D0 53 46 03 70 30 68 29 68 42 46 ?? ?? ?? ?? 00 28 25 D0 40 46 ?? ?? ?? ?? 22 1C 48 46 59 46 ?? ?? ?? ?? 04 1C 00 28 DD D1 38 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 20 1C ?? ?? ?? ?? 3D 21 80 46 ?? ?? ?? ?? 00 28 08 D0 07 70 43 1C 30 1C 29 1C 42 46 ?? ?? ?? ?? 07 1C BC E7 00 23 F6 E7 30 1C 29 1C 22 1C ?? ?? ?? ?? 07 1C D2 E7 }
	condition:
		$1
}

rule file_312_1_0 {
	meta:
		name = "_fork_r"
		size = 36
		refs = "000a _fork 0020 errno"
	strings:
		$1 = { 30 B5 07 4C 00 23 23 60 05 1C ?? ?? ?? ?? 43 1C 00 D0 30 BD 23 68 00 2B FB D0 2B 60 F9 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "__buf_init"
		size = 44
	strings:
		$1 = { 10 B5 E0 23 5B 00 C2 18 C3 68 04 69 01 3B 59 18 21 41 DE 23 5B 00 06 29 00 DA 06 21 C1 50 E2 23 5B 00 C2 50 E0 23 5B 00 C2 50 10 BD }
	condition:
		$1
}

rule file_313_1_0 {
	meta:
		name = "__reclaim_buf"
		size = 42
	strings:
		$1 = { 10 B5 00 23 4A 68 8B 60 CB 60 0B 75 0B 68 5A 60 4A 68 13 60 E0 23 5B 00 C2 58 0A 60 54 68 C3 58 4C 60 59 60 4B 68 19 60 10 BD }
	condition:
		$1
}

rule file_313_2_0 {
	meta:
		name = "__buf_free"
		size = 164
		refs = "0058 free 0096 __put_page"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 E0 23 5B 00 C4 58 81 B0 80 46 0E 1C 17 1C 00 2C 2B D0 E0 20 40 00 05 1C 01 21 04 22 45 44 8B 46 92 46 99 46 A5 42 20 D0 E2 68 00 2A 03 D1 23 7D 50 46 03 42 05 D0 00 2F 03 D0 23 7D 59 46 0B 42 1D D1 00 2E 19 D0 20 69 00 28 01 D0 ?? ?? ?? ?? 23 68 62 68 5A 60 62 68 20 1C 13 60 ?? ?? ?? ?? 41 46 49 44 0C 68 A5 42 DE D1 00 20 01 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 24 68 D2 E7 50 46 03 40 00 20 21 69 00 90 40 46 ?? ?? ?? ?? 00 28 D7 D0 01 20 40 42 E9 E7 }
	condition:
		$1
}

rule file_313_3_0 {
	meta:
		name = "__get_buf"
		size = 716
		refs = "01dc __put_page 01ea malloc 0246 __get_page 02c4 free"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 87 B0 04 1C 0F 1C 15 1C 00 2A 2A D0 96 68 00 2E 03 D0 F2 68 BA 42 00 D0 00 26 00 2B 1C D0 00 22 92 46 91 46 00 2E 40 D0 33 68 72 68 5A 60 72 68 13 60 E2 23 5B 00 E2 58 72 60 E6 50 E0 20 40 00 73 68 22 18 32 60 1E 60 07 B0 30 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 02 20 00 21 82 46 89 46 E0 E7 83 69 01 3B 0B 40 C2 69 9B 46 0B 1C D3 40 1A 1C EC 23 5B 00 C3 58 92 00 D2 58 58 46 83 00 9B 58 03 26 19 1C 02 92 B1 43 02 22 0E 1C 13 40 99 46 04 D1 98 23 5B 00 E3 58 00 2B 02 D1 01 23 9A 46 BF E7 00 22 92 46 BC E7 E0 23 5B 00 E6 58 DE 23 5B 00 E3 58 00 2B 00 D0 8F E0 33 7D 18 07 00 D5 8B E0 33 68 72 68 5A 60 72 68 13 60 F2 68 00 2A 00 D1 BF E0 30 7D 04 23 03 40 98 46 31 69 0B 88 9C 46 00 2B 05 D0 01 23 5B 42 9C 44 63 46 5B 00 5B 5A 04 93 C3 07 00 D5 CF E0 41 46 00 29 1C D0 A2 69 F3 68 E1 69 01 3A 1A 40 CB 40 19 1C EC 23 5B 00 E3 58 89 00 C9 58 98 23 5B 00 E3 58 00 2B 00 D1 A6 E0 C3 07 00 D5 B4 E0 93 00 CB 18 1A 68 90 07 00 D4 9F E0 02 22 1A 60 B1 68 88 46 00 29 5F D0 00 23 B3 60 0B 7D 5A 07 5A D4 C8 68 04 99 84 46 61 45 55 D1 E0 21 49 00 02 1C 58 46 03 91 05 90 29 1C 50 46 CB 46 BA 46 B1 46 45 46 06 90 04 9F 03 9E 88 46 1D E0 2B 68 6A 68 5A 60 6A 68 13 60 A3 59 2B 60 5A 68 A3 59 6A 60 5D 60 A9 68 6B 68 00 20 E8 60 28 75 1D 60 00 29 60 D0 00 22 AA 60 0B 7D 04 20 03 42 68 D1 C8 68 3A 1C 87 42 56 D1 0D 1C 29 69 08 88 00 28 02 D0 01 38 40 00 47 5A 01 20 03 42 D7 D0 00 23 20 1C 00 93 ?? ?? ?? ?? 00 28 D0 D0 00 26 35 E7 18 20 ?? ?? ?? ?? 06 1C 00 28 00 D1 2E E7 E0 68 ?? ?? ?? ?? 30 61 00 28 5F D0 DE 23 5B 00 E2 58 00 2A 01 D0 01 3A E2 50 00 23 F7 60 B3 60 00 2D 40 D0 AE 60 33 75 E2 23 5B 00 E2 58 72 60 E6 50 E0 20 73 68 40 00 22 18 32 60 1E 60 6B 42 6B 41 52 46 31 69 00 92 00 22 01 92 20 1C 3A 1C ?? ?? ?? ?? 00 28 CA D1 00 2D 00 D0 FF E6 58 46 4A 46 02 99 83 00 32 43 5A 50 F8 E6 30 7D 04 23 03 40 98 46 D1 D0 3D E7 05 99 06 9A 4E 46 57 46 D9 46 92 46 8B 46 45 46 C7 E7 93 00 CB 18 00 22 1A 60 5E E7 05 9B 06 98 4E 46 57 46 D9 46 82 46 9B 46 45 46 B9 E7 04 23 33 75 BD E7 93 00 CB 18 4D E7 00 20 00 90 43 46 20 1C ?? ?? ?? ?? 00 28 95 D1 30 7D 04 23 03 40 98 46 22 E7 30 1C ?? ?? ?? ?? 00 26 C3 E6 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "__svfscanf_r"
		size = 3532
		refs = "007a __srefill_r 01d4 memset 01e6 _mbrtowc_r 0320 __ctype_ptr__ 0324 _strtol_r 032c _strtoul_r 0330 __mb_cur_max 0344 _ungetc_r 03cc _strtod_r 084c __sccl 096e iswspace 0b8e _fread_r 0c5e sprintf 0c86 __isnand 0c94 __truncdfsf2 0dbe nanf"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 C2 4C 99 46 A5 44 80 23 0C 1C 89 89 9B 01 82 46 19 42 05 D1 0B 43 A3 81 61 6E BD 4B 0B 40 63 66 00 20 04 90 07 90 05 90 90 46 00 25 41 46 0A 78 AD 92 00 2A 24 D0 B7 4E 01 23 98 44 33 68 99 18 49 78 0F 07 26 D5 63 68 08 27 0C E0 22 68 31 68 13 78 CB 18 5B 78 3B 42 E8 D0 63 68 01 32 01 3B 63 60 22 60 01 35 00 2B F0 DC 50 46 21 1C ?? ?? ?? ?? 00 28 EA D0 41 46 0A 78 AD 92 00 2A DA D1 04 98 AE 23 9B 00 9D 44 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 25 2A 1F D0 63 68 00 2B 0D DD 23 68 42 46 01 3A 19 78 12 78 91 42 E9 D1 62 68 01 33 01 3A 62 60 23 60 01 35 B8 E7 50 46 21 1C ?? ?? ?? ?? 00 28 EB D0 04 98 00 28 02 D0 A3 89 5F 06 D7 D5 01 20 40 42 D4 E7 00 20 01 90 47 46 9C 46 3A 78 01 37 78 2A 11 D9 63 46 9B 18 5B 78 B8 46 01 27 83 46 3B 42 01 D0 38 43 83 46 86 49 0A 22 03 23 07 91 01 9F 05 92 03 93 0C E0 83 49 93 00 CB 58 9F 46 82 4A 83 46 0A 23 03 20 B8 46 07 92 01 9F 05 93 03 90 63 68 00 2B 00 DC C4 E3 58 46 40 06 16 D4 23 68 31 68 1A 78 8A 18 52 78 08 21 0A 42 0E D0 62 68 01 3A 62 60 00 2A 61 DD 01 33 23 60 01 35 31 68 1A 78 8A 18 52 78 08 21 0A 42 F0 D1 03 9A 02 2A 00 D1 B5 E3 02 2A 5B DC 01 2A 00 D1 3E E1 01 98 00 28 00 D1 01 27 59 46 01 22 11 42 01 D1 00 F0 86 FC 10 23 19 40 01 91 01 D0 00 F0 7C FC 48 46 00 68 04 21 83 46 89 44 43 46 00 26 A8 46 5D 46 9B 46 5E 4A 13 68 9E 42 8A D0 23 68 1A 78 13 A8 82 55 62 68 01 33 01 3A 62 60 23 60 00 21 08 22 AB A8 ?? ?? ?? ?? 01 36 AB A9 00 91 13 AA 50 46 29 1C 33 1C ?? ?? ?? ?? 42 1C 00 D1 70 E7 00 28 00 D0 D6 E3 01 9B 00 2B 00 D1 2B 60 01 98 B0 44 01 3F 00 28 00 D1 04 35 00 26 63 68 00 2B 00 DC D9 E3 00 2F CD D1 45 46 D8 46 E1 E3 50 46 21 1C ?? ?? ?? ?? 00 28 00 D0 52 E7 23 68 01 35 96 E7 03 9B 03 2B 00 D1 6D E1 04 2B A0 D1 01 9A AE 23 01 3A 5B 00 9A 42 00 D9 17 E3 00 21 0B 91 F0 26 58 46 F6 00 6A 46 E0 23 00 21 4C 32 DB 00 06 43 A0 20 93 46 C0 00 08 91 03 91 09 91 0E 91 06 91 0F 91 01 92 0A 93 80 21 80 22 C0 23 10 90 C9 00 40 46 92 00 5B 00 12 90 0C 91 00 20 0D 92 11 93 A8 46 5D 46 CB 46 D1 46 82 46 22 68 13 78 4E 2B 00 D1 DD E2 4E 2B 00 D9 0E E1 39 2B 00 D9 21 E1 31 2B 01 D3 00 F0 31 FC 2E 2B 01 D1 00 F0 23 FC 2E 2B 01 D9 00 F0 0C FC 2B 2B 00 D1 BE E1 2D 2B 00 D1 BB E1 12 98 06 99 57 46 08 97 CA 46 D9 46 AB 46 45 46 80 46 00 29 01 D0 11 4B 1E 40 03 9B 01 3B 01 2B 01 D8 00 F0 34 FD 08 9B 01 3B 06 2B 2E D8 08 9A 02 2A 01 D8 00 F0 1E FD 5B 46 17 1C 03 93 1B E0 C0 46 48 FD FF FF FF DF FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FE FF FF 03 98 01 38 03 90 22 1C 01 78 50 46 ?? ?? ?? ?? 01 3F 3F 06 3F 0E 03 2F F2 D1 08 9B 03 3B 1B 06 1B 0E 59 46 C9 1A 8B 46 ED 1A F3 05 1B D5 77 05 01 D5 00 F0 1A FD 01 21 49 42 8B 44 5A 46 11 78 01 3D 45 29 0B D0 65 29 09 D0 50 46 22 1C ?? ?? ?? ?? 01 23 5B 42 9B 44 5F 46 39 78 ED 18 50 46 22 1C ?? ?? ?? ?? 10 23 33 40 00 D0 48 E6 58 46 C0 22 03 70 D2 00 80 23 32 40 DB 00 9A 42 01 D1 00 F0 55 FC 0E 98 00 28 01 D0 00 F0 38 FC 50 46 01 99 00 22 ?? ?? ?? ?? 01 90 02 91 01 21 0E 42 04 D1 02 21 0E 42 01 D1 00 F0 4B FC 4A 46 13 68 01 98 02 99 18 60 59 60 4E 46 04 36 04 9A 01 32 04 92 B1 46 1C E6 01 98 00 28 01 D1 01 27 7F 42 59 46 C9 06 33 D5 D6 22 52 00 6A 44 23 68 03 92 00 26 1A 78 03 98 82 5C 00 2A 01 D1 00 F0 7B FC 62 68 01 33 01 3A 01 36 62 60 23 60 B7 42 1C D0 00 2A EE DC 50 46 21 1C ?? ?? ?? ?? 00 28 14 D1 23 68 E6 E7 2B 1C 35 1C 5E 46 9B 46 5E 45 00 D1 3B E6 59 46 8E 1B 00 2E 00 D1 13 E6 00 23 0B 70 04 9B 01 33 04 22 04 93 91 44 AD 19 E0 E5 49 46 D6 22 0E 68 52 00 6A 44 B3 46 23 68 03 92 2E 1C 5D 46 1B 78 03 98 C3 5C 00 2B 01 D1 00 F0 34 FC 63 68 01 3B 63 60 23 68 1A 78 01 3F 01 33 2A 70 01 35 23 60 00 2F 01 D1 00 F0 26 FC 62 68 00 2A E7 DC 50 46 21 1C ?? ?? ?? ?? 00 28 C2 D1 23 68 DF E7 66 2B 00 D1 48 E3 66 2B 00 D9 3B E3 59 2B 00 D1 30 E3 59 2B 00 D9 E5 E0 54 2B 00 D0 F6 E6 50 46 06 28 00 D0 F2 E6 07 21 8A 46 B0 E0 45 2B 00 D1 DE E0 45 2B 00 D9 C1 E0 41 2B 00 D0 E6 E6 03 98 01 28 00 D0 E2 E6 02 21 03 91 A0 E0 01 9A AE 23 01 3A 5B 00 9A 42 00 D9 F9 E0 00 22 03 92 D8 26 6A 46 58 46 4C 32 00 21 36 01 C0 23 93 46 DB 00 06 43 08 91 01 92 80 20 A0 21 80 22 09 93 80 00 2B 1C C9 00 12 01 5D 46 06 90 0A 91 0B 92 9B 46 19 E0 38 2B 3C D3 05 98 41 00 C8 48 09 5A 09 04 09 14 05 91 08 29 1C DD C6 49 0E 40 2B 70 01 35 63 68 01 3B 63 60 00 2B 00 DC CE E0 01 32 22 60 01 3F 00 2F 0D D0 22 68 13 78 39 2B E1 D9 58 2B 4C D0 58 2B 44 D8 19 1C 41 39 09 06 09 0E 05 29 23 D9 5B 46 AB 46 1D 1C F2 05 07 D5 01 9B 9B 45 00 D9 8E E3 01 99 8B 45 00 D1 62 E5 10 23 33 40 00 D1 72 E3 01 9F 08 98 ED 1B 2D 18 5D 44 2E E5 30 2B 18 D0 30 2B 0C D8 2B 2B 01 D0 2D 2B E0 D1 80 21 0E 42 DD D0 8E 43 C0 E7 05 98 0A 28 BB DC D7 E7 05 99 48 00 A1 49 41 5A A1 48 09 04 09 14 05 91 06 40 B2 E7 0B 98 06 42 AF D0 05 99 00 29 00 D1 AF E3 70 05 00 D4 B1 E3 9A 49 0E 40 A5 E7 61 2B BE D3 66 2B E0 D9 78 2B BA D1 09 99 06 98 31 40 81 42 B5 D1 94 49 0A 98 0E 40 10 21 06 43 05 91 93 E7 80 21 0E 42 00 D1 3F E6 8E 43 2B 70 01 35 01 23 98 44 63 68 01 3B 63 60 00 2B 06 DD 01 32 22 60 01 3F 00 2F 00 D0 12 E6 2E E6 48 46 21 1C ?? ?? ?? ?? 00 28 F4 D0 27 E6 46 2B 00 D1 6A E2 49 2B 00 D0 21 E6 50 46 00 28 33 D1 0A 99 0A 98 31 40 81 42 00 D0 18 E6 7C 49 01 20 0E 40 82 46 D4 E7 61 2B 00 D1 29 E7 65 2B 00 D0 0D E6 10 99 0C 98 31 40 81 42 05 D0 06 42 00 D1 05 E6 06 99 00 29 0E D0 0D 98 06 42 04 D1 06 99 0F 98 09 1A 0E 91 09 95 6D 49 11 98 0E 40 00 21 06 43 06 91 B4 E7 12 98 52 46 08 92 CA 46 D9 46 AB 46 45 46 80 46 F7 E5 51 46 05 29 02 D0 03 29 00 D0 E4 E5 51 46 01 31 09 06 09 0E 8A 46 9F E7 60 4F 01 9B DF 19 03 97 5F 4F 01 E7 50 46 21 1C ?? ?? ?? ?? 00 28 00 D1 2B E7 3B E7 10 21 08 43 D8 E4 02 1C 01 23 1A 43 B8 46 93 46 57 4F 0A 20 03 21 07 97 05 90 01 9F 03 91 EE E4 01 99 8B 00 5B 18 5B 00 30 3A D2 18 01 92 C3 E4 80 23 9B 00 02 1C 1A 43 4E 4B 10 20 03 21 B8 46 93 46 01 9F 07 93 05 90 03 91 D8 E4 01 1C 01 22 11 43 48 4B 8B 46 08 20 03 21 B8 46 07 93 01 9F 05 90 03 91 CB E4 02 23 18 43 A5 E4 04 22 B8 46 83 46 01 9F 03 92 C2 E4 88 23 B8 46 9B 00 07 1C 3C 48 1F 43 10 21 03 22 BB 46 07 90 01 9F 05 91 03 92 B4 E4 37 49 08 22 03 23 B8 46 83 46 01 9F 07 91 05 92 03 93 AA E4 03 1C 83 46 B8 46 DB 06 00 D5 27 E4 07 1C 04 20 07 42 00 D0 14 E2 5A 46 01 23 1A 42 00 D1 15 E2 4F 46 3B 68 04 20 1D 60 81 44 FF F7 17 FC 01 22 10 43 6D E4 24 4A 83 46 00 23 03 20 B8 46 07 92 01 9F 05 93 03 90 86 E4 04 21 08 43 60 E4 40 23 02 1C 1A 43 00 23 B8 46 93 46 01 9F 03 93 7A E4 B8 46 D6 27 7F 00 6F 44 83 46 41 46 38 1C 03 97 ?? ?? ?? ?? 40 23 80 46 58 46 18 43 01 21 83 46 01 9F 03 91 67 E4 03 99 00 29 21 D1 0A 99 0A 98 31 40 81 42 20 D1 09 49 01 20 0E 40 03 90 ED E6 07 4B 01 9A D3 18 0B 93 06 4F E3 E4 ?? ?? ?? ?? 7F F4 FF FF 7F FA FF FF FF FD FF FF 7F F8 FF FF A3 FE FF FF 5D 01 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 03 99 02 29 00 D1 3E E2 51 46 04 29 00 D1 27 E7 01 29 00 D0 09 E5 23 E7 50 46 21 1C ?? ?? ?? ?? 00 28 00 D1 33 E4 FF F7 FE FB 02 23 B8 46 83 46 01 9F 03 93 27 E4 01 98 00 28 01 D1 01 27 7F 42 59 46 01 22 11 42 00 D1 84 E0 10 23 19 40 03 91 7B D1 48 46 00 68 04 21 01 90 89 44 43 46 00 22 A8 46 9B 46 15 1C 22 68 13 78 00 2F 48 D0 31 68 C9 18 49 78 08 20 01 42 42 D1 DE 48 01 68 8D 42 01 D1 FF F7 D0 FB 13 A9 4B 55 63 68 01 32 01 3B 63 60 22 60 00 21 08 22 AB A8 ?? ?? ?? ?? 01 35 AB AA 00 92 2B 1C 50 46 01 99 13 AA ?? ?? ?? ?? 43 1C 01 D1 FF F7 B7 FB 00 28 00 D0 53 E1 01 99 08 60 ?? ?? ?? ?? 00 28 00 D1 2E E1 5B 46 AB 46 45 46 98 46 5B 46 00 2B 14 D0 5E 46 01 3E 13 A8 87 19 00 E0 01 3E 39 78 50 46 22 1C ?? ?? ?? ?? 01 3F 00 2E F6 D1 05 E0 02 30 00 D1 30 E4 28 E4 45 46 D8 46 03 99 00 29 01 D0 FF F7 3F FB 04 9B 01 9A 01 33 11 60 04 93 FF F7 38 FB 50 46 21 1C ?? ?? ?? ?? 00 28 00 D1 1E E4 45 46 D8 46 00 2E 01 D0 FF F7 78 FB 01 99 00 29 01 D0 FF F7 26 FB 04 9A 01 32 04 92 FF F7 21 FB AD 23 9B 00 6B 44 01 93 83 E7 58 46 C0 06 27 D4 49 46 09 68 2A 1C 01 91 23 68 0D 1C 93 46 32 68 1B 78 D3 18 5B 78 08 22 13 42 00 D0 C8 E0 63 68 01 3B 63 60 23 68 1A 78 01 3F 01 33 2A 70 01 35 23 60 00 2F 00 D1 BB E0 62 68 00 2A E7 DC 50 46 21 1C ?? ?? ?? ?? 00 28 00 D0 B1 E0 23 68 DE E7 2A 1C 00 21 23 68 0D 1C 93 46 1A 78 31 68 8A 18 52 78 08 20 02 42 00 D0 9C E0 62 68 01 33 01 3A 01 35 62 60 23 60 AF 42 00 D1 93 E0 00 2A EC DC 50 46 21 1C ?? ?? ?? ?? 00 28 00 D0 8A E0 23 68 E3 E7 00 23 9B 46 FF F7 85 FB 5B 46 DB 06 6D D5 00 26 AB 46 0A E0 23 68 5B 19 23 60 50 46 21 1C 76 19 ?? ?? ?? ?? 00 28 58 D1 7F 1B 65 68 BD 42 F1 DB 5B 46 AB 46 58 46 1D 1C C3 1B 63 60 23 68 F6 19 DF 19 27 60 AD 19 FF F7 AB FA 30 2B 01 D0 FF F7 F6 FB F1 05 16 D5 80 23 9E 43 06 9B 0B 98 01 33 06 93 00 28 00 D1 AD E5 01 38 0B 90 01 37 A9 E5 0D 98 06 42 01 D1 FF F7 E2 FB 64 49 0E 40 06 99 0F 91 9D E5 03 98 01 1C 51 44 00 29 01 D0 FF F7 D6 FB 5F 49 0E 40 93 E5 74 2B 00 D1 D8 E4 79 2B 01 D0 FF F7 CC FB 50 46 07 28 01 D0 FF F7 C7 FB 08 21 8A 46 84 E5 6E 2B 00 D1 86 E6 6E 2B EB D8 69 2B 01 D0 FF F7 BB FB 97 E5 50 46 02 28 01 D0 FF F7 B5 FB 03 21 8A 46 72 E5 5D 46 00 2E 01 D1 FF F7 AB FA AD 19 FF F7 5B FA 4A 46 11 68 50 46 01 22 3B 1C 00 94 ?? ?? ?? ?? 00 28 01 D1 FF F7 9C FA 04 9F 04 23 01 37 99 44 45 19 04 97 FF F7 47 FA 5B 46 AB 46 1D 1C 5D 44 FF F7 41 FA 5B 46 AB 46 1D 1C 04 23 99 44 5F 46 00 23 3B 70 04 99 01 98 01 31 2D 1A 5D 44 04 91 FF F7 31 FA 03 99 A8 44 01 3F 00 29 02 D1 01 9A 04 32 01 92 00 25 63 68 00 2B 00 DD 90 E6 50 46 21 1C ?? ?? ?? ?? 00 28 00 D1 89 E6 5B 46 AB 46 45 46 98 46 5B 46 00 2B 01 D0 FF F7 61 FA CE E6 02 30 E8 D0 01 9A 10 68 A8 E6 49 46 0B 68 81 44 1D 80 FF F7 08 FA 49 46 0B 68 04 22 1D 60 91 44 FF F7 01 FA 09 99 00 22 01 31 50 46 0A 23 ?? ?? ?? ?? 0E 99 42 1A 18 4B 09 9F 6B 44 9F 42 03 D3 CF 20 40 00 68 44 09 90 09 98 14 49 ?? ?? ?? ?? FF F7 B0 FB 06 99 0F 9B CA 1A 00 2A 01 D1 FF F7 A9 FB 52 42 09 90 E6 E7 49 46 4E 46 0F 68 01 98 02 99 04 36 ?? ?? ?? ?? 00 28 00 D0 95 E0 01 98 02 99 ?? ?? ?? ?? 38 60 FF F7 AB FB C0 46 ?? ?? ?? ?? 7F FD FF FF 7F FE FF FF 9F 01 00 00 ?? ?? ?? ?? 5A 46 13 70 01 99 50 46 00 22 05 9B 07 9F 00 F0 BB F8 B1 06 12 D5 4A 46 13 68 18 60 04 23 99 44 04 9B 01 33 04 93 78 E4 01 27 7F 42 BB 44 58 46 01 78 22 1C 50 46 ?? ?? ?? ?? 66 E4 04 27 3E 42 0A D0 49 46 0B 68 B9 44 18 80 E9 E7 2B 1C 35 1C 5E 46 9B 46 FF F7 A7 FB 01 22 16 42 15 D0 4F 46 3B 68 18 60 04 20 81 44 DA E7 00 2E 01 D1 FF F7 B3 F9 AD 19 FF F7 86 F9 B8 46 FF F7 B9 F9 03 20 03 90 8F E4 83 46 B8 46 02 E5 49 46 0B 68 04 22 18 60 91 44 C4 E7 5D 46 01 9A 95 42 01 D8 FF F7 9B F9 01 3D 29 78 50 46 22 1C ?? ?? ?? ?? F3 E7 5D 46 01 99 8D 42 01 D8 FF F7 8E F9 01 3D 29 78 50 46 22 1C ?? ?? ?? ?? F3 E7 06 98 08 21 06 43 05 91 4A E4 03 99 00 29 02 D0 01 39 03 91 01 37 0C 4B 1E 40 08 9B 01 33 08 93 FF F7 EC FB 5D 46 01 98 85 42 01 D8 FF F7 6F F9 01 3D 29 78 50 46 22 1C ?? ?? ?? ?? F3 E7 00 20 ?? ?? ?? ?? 38 60 FF F7 16 FB 7F FC FF FF }
	condition:
		$1
}

rule file_314_2_0 {
	meta:
		name = "_vfscanf_r"
		size = 38
		refs = "0014 __sinit 0020 __svfscanf_r"
	strings:
		$1 = { F0 B5 04 1C 0E 1C 15 1C 1F 1C 00 28 04 D0 83 6B 00 2B 01 D1 ?? ?? ?? ?? 31 1C 2A 1C 3B 1C 20 1C ?? ?? ?? ?? F0 BD }
	condition:
		$1
}

rule file_408_2_0 {
	meta:
		name = "_vfiscanf_r"
		size = 38
		refs = "0014 __sinit 0020 __svfiscanf_r"
	strings:
		$1 = { F0 B5 04 1C 0E 1C 15 1C 1F 1C 00 28 04 D0 83 6B 00 2B 01 D1 ?? ?? ?? ?? 31 1C 2A 1C 3B 1C 20 1C ?? ?? ?? ?? F0 BD }
	condition:
		$1
}

rule file_315_2_0 {
	meta:
		name = "__ssvfiscanf_r"
		size = 2388
		refs = "01ce memset 01e0 _mbrtowc_r 0334 __ctype_ptr__ 0338 _strtol_r 0340 _strtoul_r 0344 __mb_cur_max 034e memcpy 0598 iswspace 06e2 __sccl"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0C 1C 99 46 89 89 80 23 9B 01 D8 B0 82 46 19 42 05 D1 0B 43 A3 81 61 6E C2 4B 0B 40 63 66 00 25 06 95 04 95 05 95 90 46 40 46 02 78 57 92 00 2A 24 D0 BD 4E 33 68 01 21 88 44 99 18 49 78 0F 07 24 D5 63 68 08 27 0C E0 22 68 31 68 13 78 CB 18 5B 78 3B 42 E8 D0 63 68 01 32 01 3B 63 60 22 60 01 35 00 2B F0 DC 50 46 21 1C FF F7 5D FF 00 28 EA D0 40 46 02 78 57 92 00 2A DA D1 05 98 58 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 25 2A 1F D0 63 68 00 2B 0D DD 23 68 42 46 01 3A 19 78 12 78 91 42 EB D1 62 68 01 33 01 3A 62 60 23 60 01 35 BA E7 50 46 21 1C FF F7 37 FF 00 28 EB D0 05 98 00 28 02 D0 A3 89 59 06 D9 D5 01 20 40 42 D6 E7 00 20 02 90 47 46 9C 46 3A 78 01 37 78 2A 11 D9 63 46 9B 18 5B 78 B8 46 01 27 83 46 3B 42 01 D0 38 43 83 46 8D 49 0A 22 03 23 06 91 02 9F 04 92 03 93 0F E0 8A 49 93 00 CB 58 9F 46 10 21 08 43 E2 E7 88 4A 83 46 0A 23 03 20 B8 46 06 92 02 9F 04 93 03 90 63 68 00 2B 00 DC B1 E2 58 46 40 06 15 D4 23 68 31 68 1A 78 8A 18 52 78 08 20 02 42 0D D0 62 68 01 3A 62 60 00 2A 5D DD 01 33 23 60 01 35 1A 78 8A 18 52 78 08 20 02 42 F1 D1 03 99 02 29 00 D1 CF E1 03 29 00 D1 2C E1 01 29 56 D0 02 9A 00 2A 00 D1 01 27 5B 46 01 20 03 42 00 D1 C7 E0 10 23 59 46 19 40 02 91 00 D0 BE E0 4B 46 1B 68 04 20 9B 46 81 44 43 46 00 26 A8 46 5D 46 9B 46 65 49 0B 68 9E 42 89 D0 23 68 1A 78 4B A8 82 55 62 68 01 33 01 3A 62 60 23 60 00 21 08 22 55 A8 ?? ?? ?? ?? 01 36 55 A9 00 91 4B AA 50 46 29 1C 33 1C ?? ?? ?? ?? 42 1C 00 D1 6F E7 00 28 7E D1 02 9B 00 2B 00 D1 2B 60 02 98 B0 44 01 3F 00 28 00 D1 04 35 00 26 63 68 00 2B 73 DD 00 2F CF D1 45 46 D8 46 79 E0 50 46 21 1C FF F7 8C FE 00 28 00 D0 53 E7 31 68 23 68 01 35 99 E7 02 98 00 28 01 D1 01 27 7F 42 59 46 C9 06 31 D5 6A 46 2C 32 23 68 03 92 00 26 1A 78 03 98 82 5C 00 2A 00 D1 04 E3 62 68 01 33 01 3A 01 36 62 60 23 60 B7 42 1C D0 00 2A EF DC 50 46 21 1C FF F7 64 FE 00 28 14 D1 23 68 E7 E7 2B 1C 35 1C 5E 46 9B 46 5E 45 00 D1 23 E7 59 46 8E 1B 00 2E 00 D1 FD E6 00 23 0B 70 05 9B 01 33 04 22 05 93 91 44 AD 19 CA E6 49 46 0E 68 6A 46 2C 32 B3 46 23 68 03 92 2E 1C 5D 46 1B 78 03 98 C3 5C 00 2B 00 D1 C9 E2 63 68 01 3B 63 60 23 68 1A 78 01 3F 01 33 2A 70 01 35 23 60 00 2F 00 D1 BC E2 62 68 00 2A E9 DC 50 46 21 1C FF F7 28 FE 00 28 C5 D1 23 68 E1 E7 02 30 89 D0 81 E7 50 46 21 1C FF F7 1D FE 00 28 85 D0 45 46 D8 46 00 2E 00 D0 E0 E6 02 99 00 29 00 D0 91 E6 05 9A 01 32 05 92 8D E6 00 22 93 46 42 E7 5B 46 DB 06 38 D4 49 46 09 68 3E 1C 02 91 23 E0 C0 46 FF DF FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 21 68 5A 46 02 98 ?? ?? ?? ?? 23 68 00 22 5B 44 23 60 62 60 5B 46 50 46 21 1C F6 1A FF F7 E6 FD 00 28 00 D0 64 E2 02 98 01 1C 59 44 02 91 62 68 93 46 5E 45 E4 D8 32 1C 21 68 02 98 ?? ?? ?? ?? 63 68 9B 1B 63 60 23 68 9E 19 26 60 54 E2 00 26 AB 46 0B E0 23 68 5B 19 23 60 50 46 21 1C 76 19 FF F7 C4 FD 00 28 00 D0 83 E2 7F 1B 65 68 BD 42 F0 DB 5B 46 AB 46 58 46 1D 1C C3 1B 63 60 23 68 F6 19 DF 19 27 60 AD 19 30 E6 02 9B 01 3B 26 2B 00 D9 95 E0 00 22 02 92 96 21 00 23 D8 26 49 00 58 46 69 44 36 01 07 93 80 23 8B 46 1B 01 06 43 01 91 C0 20 80 21 A0 22 C0 00 89 00 D2 00 0A 93 2B 1C 08 90 5D 46 03 91 09 92 9B 46 19 E0 38 2B 4E D3 04 98 41 00 C8 48 09 5A 09 04 09 14 04 91 08 29 1C DD C5 49 0E 40 2B 70 01 35 63 68 01 3B 63 60 00 2B 00 DC C6 E0 01 32 22 60 01 3F 00 2F 0D D0 22 68 13 78 39 2B E1 D9 58 2B 24 D0 58 2B 1C D8 19 1C 41 39 09 06 09 0E 05 29 35 D9 5B 46 AB 46 1D 1C F2 05 07 D5 01 9B 9B 45 00 D9 0E E2 01 99 8B 45 00 D1 03 E6 10 23 33 40 00 D1 F2 E1 01 9F 07 98 ED 1B 2D 18 5D 44 CF E5 61 2B E6 D3 66 2B 1A D9 78 2B E2 D1 08 99 03 98 31 40 81 42 DD D1 A7 49 09 98 0E 40 10 21 06 43 04 91 BB E7 30 2B 18 D0 30 2B 0C D8 2B 2B 01 D0 2D 2B CE D1 80 21 0E 42 CB D0 8E 43 AE E7 04 98 0A 28 A9 DC C5 E7 04 99 48 00 98 49 41 5A 98 48 09 04 09 14 04 91 06 40 A0 E7 0A 98 06 42 9D D0 04 99 00 29 00 D1 98 E1 70 05 00 D4 0A E2 92 49 0E 40 93 E7 02 9B 27 3B 02 93 27 27 66 E7 02 98 00 28 01 D1 01 27 7F 42 59 46 01 22 11 42 6D D0 10 23 19 40 03 91 64 D1 48 46 00 68 04 21 02 90 89 44 43 46 00 22 A8 46 9B 46 15 1C 22 68 13 78 00 2F 4A D0 31 68 C9 18 49 78 08 20 01 42 44 D1 7E 48 01 68 8D 42 00 D1 B5 E5 4B A9 4B 55 63 68 01 32 01 3B 63 60 22 60 00 21 08 22 55 A8 ?? ?? ?? ?? 01 35 55 AA 00 92 2B 1C 50 46 02 99 4B AA ?? ?? ?? ?? 43 1C 00 D1 9D E5 00 28 00 D0 CD E1 02 99 08 60 ?? ?? ?? ?? 00 28 00 D1 9C E1 5B 46 AB 46 5E 46 45 46 01 3E 98 46 4B AB 2F 1C 9E 19 5D 46 06 E0 31 78 50 46 22 1C FF F7 D9 FC 01 3D 01 3E 00 2D F6 D1 3D 1C 09 E0 50 46 21 1C FF F7 AF FC 00 28 00 D1 33 E7 43 E7 45 46 D8 46 03 99 00 29 00 D0 24 E5 05 9B 02 9A 01 33 11 60 05 93 1E E5 AE 23 5B 00 6B 44 02 93 9A E7 58 46 C0 06 27 D4 49 46 09 68 2A 1C 02 91 23 68 0D 1C 93 46 32 68 1B 78 D3 18 5B 78 08 22 13 42 00 D0 F4 E0 63 68 01 3B 63 60 23 68 1A 78 01 3F 01 33 2A 70 01 35 23 60 00 2F 00 D1 E7 E0 62 68 00 2A E7 DC 50 46 21 1C FF F7 74 FC 00 28 00 D0 DD E0 23 68 DE E7 00 21 8B 46 32 68 29 1C 23 68 5D 46 8B 46 19 78 51 18 49 78 08 20 01 42 00 D0 C0 E0 61 68 01 33 01 39 01 35 61 60 23 60 AF 42 00 D1 B7 E0 00 29 ED DC 50 46 21 1C FF F7 52 FC 00 28 00 D0 AE E0 32 68 23 68 E3 E7 50 46 21 1C FF F7 48 FC 00 28 00 D1 46 E5 0E E5 02 1C 01 23 1A 43 B8 46 93 46 27 4F 0A 20 03 21 06 97 04 90 02 9F 03 91 34 E5 02 99 8B 00 5B 18 5B 00 30 3A D2 18 02 92 06 E5 6B 46 2C 33 83 46 39 1C 18 1C 03 93 ?? ?? ?? ?? 5F 46 40 23 1F 43 80 46 01 20 BB 46 03 90 02 9F 1B E5 80 23 9B 00 02 1C 1A 43 15 4B 10 20 03 21 B8 46 93 46 02 9F 06 93 04 90 03 91 0D E5 01 1C 01 22 11 43 0F 4B 8B 46 08 20 03 21 B8 46 06 93 02 9F 04 90 03 91 00 E5 02 23 18 43 D7 E4 02 22 B8 46 83 46 02 9F 03 92 F7 E4 ?? ?? ?? ?? 7F F4 FF FF FF FD FF FF 7F FA FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 88 23 B8 46 9B 00 07 1C 78 48 1F 43 10 21 03 22 BB 46 06 90 02 9F 04 91 03 92 DB E4 73 49 08 22 03 23 B8 46 83 46 02 9F 06 91 04 92 03 93 D1 E4 03 1C 83 46 B8 46 DB 06 00 D5 4D E4 07 1C 04 20 07 42 24 D1 5A 46 01 23 1A 42 2B D0 4F 46 3B 68 04 20 1D 60 81 44 3F E4 01 22 10 43 94 E4 64 4A 83 46 00 23 03 20 B8 46 06 92 02 9F 04 93 03 90 B0 E4 04 21 08 43 87 E4 40 23 01 1C 19 43 00 22 B8 46 8B 46 02 9F 03 92 A4 E4 B8 46 58 E4 49 46 0B 68 81 44 1D 80 1F E4 5B 46 AB 46 1D 1C 5D 44 FF F7 1A FC 49 46 0B 68 04 22 1D 60 91 44 FF F7 13 FC 5B 46 AB 46 1D 1C 04 23 99 44 5F 46 00 23 3B 70 05 99 02 98 01 31 2D 1A 5D 44 05 91 FF F7 03 FC 03 98 08 21 06 43 04 91 61 E6 BF 1B 00 2F 00 D1 44 E4 7D 19 05 9F 04 23 01 37 99 44 05 97 FF F7 F2 FB 2B 1C 35 1C 5E 46 9B 46 13 E5 00 2E 01 D1 FF F7 13 FC AD 19 FF F7 E6 FB 83 46 B8 46 23 E7 5A 46 13 70 4B A9 50 46 00 22 04 9B 06 9F 00 F0 6A F8 B1 06 12 D5 4A 46 13 68 18 60 04 23 99 44 05 9B 01 33 05 93 F8 E5 01 27 7F 42 BB 44 58 46 01 78 22 1C 50 46 FF F7 66 FB E6 E5 04 27 3E 42 0C D0 49 46 0B 68 B9 44 18 80 E9 E7 5D 46 00 2E 01 D1 FF F7 03 FC AD 19 FF F7 B5 FB 01 22 16 42 34 D0 4F 46 3B 68 18 60 04 20 81 44 D8 E7 03 98 A8 44 01 3F 00 28 02 D1 02 99 04 31 02 91 00 25 63 68 00 2B 00 DD 24 E6 50 46 21 1C FF F7 1B FB 00 28 00 D1 1D E6 5B 46 AB 46 5A 46 45 46 98 46 00 2A 01 D0 FF F7 DA FB 64 E6 02 99 00 29 02 D0 01 39 02 91 01 37 0A 4B 1E 40 07 9B 01 33 07 93 81 E5 02 30 DC D0 02 9A 10 68 2E E6 49 46 0B 68 04 22 18 60 91 44 A3 E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? 7F FC FF FF }
	condition:
		$1
}

rule file_316_0_0 {
	meta:
		name = "envz_entry"
		size = 84
		refs = "0018 _buf_findstr"
	strings:
		$1 = { F0 B5 82 B0 07 1C 16 1C 01 90 00 91 01 AD 00 29 09 D0 30 1C 29 1C 6A 46 ?? ?? ?? ?? 00 28 06 D1 00 99 00 29 F5 D1 00 27 02 B0 38 1C F0 BD 01 9B 00 2B F5 D0 1A 78 00 2A 05 D0 3D 2A 03 D0 00 99 EF E7 9F 42 F0 D0 01 3B 01 93 1A 78 00 2A F8 D1 5F 1C E9 E7 }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "mbtowc"
		size = 34
	strings:
		$1 = { 00 29 01 D1 00 20 70 47 00 2A 07 D0 00 28 01 D0 0B 78 03 60 08 78 43 1E 98 41 F4 E7 01 20 40 42 F1 E7 }
	condition:
		$1
}

rule file_318_0_0 {
	meta:
		name = "wctob"
		size = 60
		refs = "000c memset 001e _wctomb_r 0038 _impure_ptr"
	strings:
		$1 = { 70 B5 83 B0 06 1C 00 21 08 22 68 46 ?? ?? ?? ?? 6D 46 09 4B 0B 35 18 68 29 1C 32 1C 6B 46 ?? ?? ?? ?? 01 28 03 D0 01 20 40 42 03 B0 70 BD 01 36 F9 D0 28 78 F9 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_319_0_0 {
	meta:
		name = "strxfrm"
		size = 56
	strings:
		$1 = { 10 B5 03 1C 00 2A 15 D0 08 78 18 70 00 28 10 D0 01 31 00 20 04 E0 0C 78 1C 54 00 2C 09 D0 01 31 01 30 82 42 F7 D1 01 E0 01 31 01 30 0B 78 00 2B FA D1 10 BD 00 20 F9 E7 }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "envz_get"
		size = 62
		refs = "0016 _buf_findstr"
	strings:
		$1 = { 70 B5 82 B0 16 1C 01 90 00 91 01 AD 00 29 09 D0 30 1C 29 1C 6A 46 ?? ?? ?? ?? 00 28 05 D1 00 99 00 29 F5 D1 00 20 02 B0 70 BD 01 98 03 78 3D 2B 03 D0 00 2B F6 D0 00 99 F2 E7 01 30 F3 E7 }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "__cxa_atexit"
		size = 20
		refs = "000e __register_exitproc"
	strings:
		$1 = { 30 B5 05 1C 0C 1C 13 1C 29 1C 22 1C 02 20 ?? ?? ?? ?? 30 BD }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "putw"
		size = 34
		refs = "000e fwrite"
	strings:
		$1 = { 00 B5 81 B0 00 90 0B 1C 68 46 04 21 01 22 ?? ?? ?? ?? 01 28 03 D0 01 20 40 42 01 B0 00 BD 00 20 FB E7 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "setbuf"
		size = 22
		refs = "000c setvbuf"
	strings:
		$1 = { 00 B5 00 29 05 D0 00 22 80 23 DB 00 ?? ?? ?? ?? 00 BD 02 22 F8 E7 }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "wcsrchr"
		size = 42
	strings:
		$1 = { 02 68 03 1C 00 2A 05 D0 04 30 02 68 00 2A FB D1 83 42 08 D8 00 29 03 D1 06 E0 02 68 8A 42 03 D0 04 38 83 42 F9 D9 00 20 70 47 }
	condition:
		$1
}

rule file_327_0_0 {
	meta:
		name = "_fgets_r"
		size = 176
		refs = "0036 memchr 0052 memcpy 0066 __srefill_r 0086 __sinit"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 82 46 89 46 16 1C 1D 1C 01 2A 3A DD 00 28 02 D0 83 6B 00 2B 32 D0 01 3E 4F 46 1A E0 2A 68 90 46 B4 42 00 D9 34 1C 40 46 0A 21 22 1C ?? ?? ?? ?? 00 28 29 D1 6B 68 1B 1B 6B 60 2B 68 1B 19 38 1C 2B 60 41 46 22 1C 36 1B ?? ?? ?? ?? 3F 19 00 2E 0C D0 6C 68 00 2C E1 D1 50 46 29 1C ?? ?? ?? ?? 00 28 01 D1 6C 68 D9 E7 4F 45 0A D0 00 23 3B 70 48 46 1C BC 90 46 99 46 A2 46 F0 BD ?? ?? ?? ?? C9 E7 00 22 91 46 F3 E7 01 30 43 46 C4 1A 6B 68 1B 1B 6B 60 28 60 41 46 38 1C 22 1C ?? ?? ?? ?? 00 23 3B 55 E4 E7 }
	condition:
		$1
}

rule file_328_0_0 {
	meta:
		name = "snprintf"
		size = 104
		refs = "0034 _svfprintf_r 0064 _impure_ptr"
	strings:
		$1 = { 0C B4 30 B5 17 4B 9B B0 0C 1C 1D 68 00 29 24 DB 00 29 1D D1 00 22 82 23 69 46 9B 00 8B 81 01 23 5B 42 00 90 04 90 02 92 05 92 CB 81 28 1C 1F AB 1E 9A 1A 93 ?? ?? ?? ?? 43 1C 0B DB 00 2C 02 D0 00 9B 00 22 1A 70 1B B0 30 BC 08 BC 02 B0 18 47 4A 1E E0 E7 8B 23 2B 60 F0 E7 8B 23 01 20 2B 60 40 42 F0 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_479_0_0 {
	meta:
		name = "sniprintf"
		size = 104
		refs = "0034 _svfiprintf_r 0064 _impure_ptr"
	strings:
		$1 = { 0C B4 30 B5 17 4B 9B B0 0C 1C 1D 68 00 29 24 DB 00 29 1D D1 00 22 82 23 69 46 9B 00 8B 81 01 23 5B 42 00 90 04 90 02 92 05 92 CB 81 28 1C 1F AB 1E 9A 1A 93 ?? ?? ?? ?? 43 1C 0B DB 00 2C 02 D0 00 9B 00 22 1A 70 1B B0 30 BC 08 BC 02 B0 18 47 4A 1E E0 E7 8B 23 2B 60 F0 E7 8B 23 01 20 2B 60 40 42 F0 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_328_1_0 {
	meta:
		name = "_snprintf_r"
		size = 100
		refs = "0034 _svfprintf_r"
	strings:
		$1 = { 08 B4 30 B5 9B B0 05 1C 14 1C 00 2A 25 DB 00 2A 1E D1 00 20 82 23 6A 46 9B 00 93 81 01 23 5B 42 D3 81 00 91 1F AB 04 91 02 90 05 90 69 46 28 1C 1E 9A 1A 93 ?? ?? ?? ?? 43 1C 0B DB 00 2C 02 D0 00 9B 00 22 1A 70 1B B0 30 BC 08 BC 01 B0 18 47 50 1E DF E7 8B 23 2B 60 F0 E7 8B 23 03 60 01 20 40 42 F0 E7 }
	condition:
		$1
}

rule file_479_1_0 {
	meta:
		name = "_sniprintf_r"
		size = 100
		refs = "0034 _svfiprintf_r"
	strings:
		$1 = { 08 B4 30 B5 9B B0 05 1C 14 1C 00 2A 25 DB 00 2A 1E D1 00 20 82 23 6A 46 9B 00 93 81 01 23 5B 42 D3 81 00 91 1F AB 04 91 02 90 05 90 69 46 28 1C 1E 9A 1A 93 ?? ?? ?? ?? 43 1C 0B DB 00 2C 02 D0 00 9B 00 22 1A 70 1B B0 30 BC 08 BC 01 B0 18 47 50 1E DF E7 8B 23 2B 60 F0 E7 8B 23 03 60 01 20 40 42 F0 E7 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "frexp"
		size = 116
		refs = "003c __muldf3"
	strings:
		$1 = { 70 B5 14 1C 12 4B 00 22 22 60 12 4A 03 40 05 1C 93 42 0D DC 00 2B 0C D0 0F 4A 93 42 0C DD 0F 4A 1B 15 9B 18 23 60 0E 4B 1D 40 0E 4B 28 1C 18 43 70 BD 00 29 FC D0 EF E7 0B 4A 0C 4B ?? ?? ?? ?? 03 4B 36 22 52 42 22 60 05 1C 03 40 08 4A E7 E7 FF FF FF 7F FF FF EF 7F FF FF 0F 00 02 FC FF FF FF FF 0F 80 00 00 E0 3F 00 00 50 43 00 00 00 00 CC FB FF FF }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "rand_r"
		size = 84
		refs = "0016 __divsi3"
	strings:
		$1 = { 30 B5 05 68 04 1C 00 2D 03 D1 0C 48 05 1C 25 60 30 BD 28 1C 0A 49 ?? ?? ?? ?? 0A 4B 43 43 5D 19 09 4B 5D 43 09 4B 58 43 2D 18 04 D5 08 4B ED 18 18 1C 28 40 EB E7 06 48 28 40 E8 E7 67 B7 E1 2A 1D F3 01 00 E3 0C FE FF A7 41 00 00 EC F4 FF FF FF FF FF 7F }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "mbstowcs"
		size = 34
	strings:
		$1 = { 10 B5 00 2A 09 D0 00 23 CC 5C 10 C0 00 2C 06 D0 01 33 9A 42 F8 D1 10 1C 10 BD 00 20 FC E7 18 1C FA E7 }
	condition:
		$1
}

rule file_332_0_0 {
	meta:
		name = "__swbuf_r"
		size = 192
		refs = "0068 __swsetup_r 0082 _fflush_r 0090 __sinit"
	strings:
		$1 = { 70 B5 06 1C 0D 1C 14 1C 00 28 02 D0 83 6B 00 2B 3E D0 A3 69 A1 89 A3 60 0A 1C 0B 07 22 D5 20 69 00 28 1F D0 80 23 9B 01 1A 42 14 D0 23 68 61 69 1A 1A 8A 42 2F DA 01 32 A1 68 2D 06 2D 0E 01 39 A1 60 1D 70 01 33 23 60 63 69 93 42 17 D0 0A 2D 12 D0 28 1C 70 BD 0B 43 62 6E A3 81 17 4B 13 40 63 66 E3 E7 30 1C 21 1C ?? ?? ?? ?? 00 28 1B D1 A1 89 20 69 0A 1C D5 E7 A3 89 DA 07 E9 D5 30 1C 21 1C ?? ?? ?? ?? 00 28 E3 D0 01 25 6D 42 E0 E7 ?? ?? ?? ?? BD E7 30 1C 21 1C ?? ?? ?? ?? 00 28 F3 D1 01 22 23 68 C7 E7 A2 89 40 23 13 43 A3 81 01 25 09 23 33 60 6D 42 CB E7 C0 46 FF DF FF FF }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "bzero"
		size = 18
	strings:
		$1 = { 00 29 05 D0 00 23 00 22 C2 54 01 33 8B 42 FB D1 70 47 }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "strcat"
		size = 76
		refs = "003c strcpy"
	strings:
		$1 = { 70 B5 04 1C 83 07 16 D1 23 68 0E 4D 5A 19 0E 4D 9A 43 2A 42 0F D1 04 30 03 68 0A 4E 9A 19 9A 43 2A 42 08 D1 04 30 03 68 06 4E 9A 19 9A 43 2A 42 F1 D0 00 E0 01 30 03 78 00 2B FB D1 ?? ?? ?? ?? 20 1C 70 BD FF FE FE FE 80 80 80 80 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "llabs"
		size = 24
	strings:
		$1 = { 70 B5 CD 17 2B 1C 2C 1C 2E 1C 43 40 4C 40 5B 1B B4 41 18 1C 21 1C 70 BD }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "wmemchr"
		size = 34
	strings:
		$1 = { 10 B5 00 2A 0B D0 03 68 8B 42 09 D0 00 23 03 E0 04 30 04 68 8C 42 03 D0 01 33 9A 42 F8 D8 00 20 10 BD }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "putc_unlocked"
		size = 76
		refs = "0036 __swbuf_r 0048 _impure_ptr"
	strings:
		$1 = { 00 B5 0A 1C 89 68 01 39 03 1C 91 60 00 29 06 DB 11 68 08 70 13 68 18 78 01 33 13 60 00 BD 90 69 81 42 0B DB 11 68 0B 70 13 68 18 78 0A 28 F3 D1 05 4B 0A 21 18 68 ?? ?? ?? ?? EF E7 02 49 08 68 19 1C ?? ?? ?? ?? E9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_337_1_0 {
	meta:
		name = "_putc_unlocked_r"
		size = 66
		refs = "0034 __swbuf_r"
	strings:
		$1 = { 10 B5 93 68 01 3B 93 60 00 2B 06 DB 13 68 19 70 13 68 18 78 01 33 13 60 10 BD 94 69 A3 42 09 DB 13 68 19 70 13 68 19 78 0A 29 06 D0 01 33 08 1C 13 60 F1 E7 ?? ?? ?? ?? EE E7 0A 21 ?? ?? ?? ?? EA E7 }
	condition:
		$1
}

rule file_338_0_0 {
	meta:
		name = "_fsetpos_r"
		size = 16
		refs = "0006 _fseek_r"
	strings:
		$1 = { 00 B5 00 23 12 68 ?? ?? ?? ?? 43 1E 98 41 00 BD }
	condition:
		$1
}

rule file_339_0_0 {
	meta:
		name = "_erand48_r"
		size = 88
		refs = "0006 __dorand48 000c __floatunsidf 0014 ldexp 0048 __adddf3"
	strings:
		$1 = { F0 B5 82 B0 0E 1C ?? ?? ?? ?? 30 88 ?? ?? ?? ?? 30 22 52 42 ?? ?? ?? ?? 04 1C 70 88 0D 1C ?? ?? ?? ?? 20 22 52 42 ?? ?? ?? ?? 00 90 01 91 B0 88 ?? ?? ?? ?? 10 22 52 42 ?? ?? ?? ?? 00 9A 01 9B 06 1C 0F 1C 20 1C 29 1C ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 02 B0 F0 BD }
	condition:
		$1
}

rule file_340_0_0 {
	meta:
		name = "_mbrtowc_r"
		size = 52
		refs = "000e _mbtowc_r"
	strings:
		$1 = { 30 B5 81 B0 04 1C 04 9D 00 2A 0A D0 00 95 ?? ?? ?? ?? 43 1C 03 D1 00 23 2B 60 8A 23 23 60 01 B0 30 BD 00 21 02 4A 01 23 00 95 ?? ?? ?? ?? F0 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_342_0_0 {
	meta:
		name = "setvbuf"
		size = 264
		refs = "002c _fflush_r 0084 __sinit 008e _free_r 00ca malloc 00fc _impure_ptr 0104 _cleanup_r"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 3C 4E 04 1C 30 68 88 46 17 1C 1D 1C 00 28 02 D0 83 6B 00 2B 32 D0 AA 46 00 2D 29 DB 02 2F 27 D8 30 68 21 1C ?? ?? ?? ?? 00 23 63 60 A3 61 A3 89 1A 04 19 06 25 D4 30 4B 12 0C 1A 40 A2 81 02 2F 2D D0 42 46 00 2A 37 D0 01 2F 21 D0 33 68 2B 4A DA 63 43 46 23 60 23 61 A3 89 65 61 19 07 05 D5 9A 07 01 D0 00 23 9A 46 51 46 A1 60 00 20 01 E0 01 20 40 42 0C BC 90 46 9A 46 F0 BD ?? ?? ?? ?? C9 E7 30 68 21 69 ?? ?? ?? ?? A3 89 1A 04 D2 E7 A2 89 01 23 13 43 A3 81 6B 42 A3 61 D6 E7 00 20 02 23 1A 43 00 23 A3 60 23 1C 43 33 23 60 23 61 01 23 A2 81 63 61 DD E7 00 2D 01 D1 80 25 ED 00 28 1C ?? ?? ?? ?? 80 46 00 28 05 D0 A2 89 80 23 13 43 A3 81 AA 46 B7 E7 80 20 C0 00 ?? ?? ?? ?? 80 46 00 28 03 D1 01 20 A2 89 40 42 D8 E7 80 25 ED 00 EB E7 ?? ?? ?? ?? 7C FF 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_343_0_0 {
	meta:
		name = "strncat"
		size = 108
	strings:
		$1 = { F0 B5 83 07 16 D0 03 1C 1C 78 00 2C 03 D0 01 33 1C 78 00 2C FB D1 00 2A 0B D0 0C 78 1C 70 00 2C 07 D0 01 3A 01 33 00 2A 00 D1 1A 70 01 31 00 2A F3 D1 F0 BD 04 68 0B 4E A5 19 0B 4E A5 43 03 1C 35 42 E1 D1 04 33 1C 68 06 4F E5 19 A5 43 35 42 DA D1 04 33 1C 68 03 4F E5 19 A5 43 35 42 F1 D0 D2 E7 C0 46 FF FE FE FE 80 80 80 80 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "bsearch"
		size = 90
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 98 46 09 9B 9B 46 43 46 81 46 8A 46 00 2B 16 D0 00 2A 14 D0 16 1C 00 27 00 E0 2E 1C BE 42 0E D9 F5 19 6D 08 44 46 6C 43 54 44 48 46 21 1C 00 F0 0E F8 00 28 F1 DB 00 28 02 D0 6F 1C EE E7 00 24 20 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD }
	condition:
		$1
}

rule file_347_0_0 {
	meta:
		name = "on_exit"
		size = 18
		refs = "000c __register_exitproc"
	strings:
		$1 = { 00 B5 03 1C 0A 1C 01 20 19 1C 00 23 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "permute"
		size = 102
	strings:
		$1 = { F0 B5 4B 10 9C 46 00 2B 0C DD 4B 1E 9B 00 05 1C C3 18 00 24 1F 68 2E 68 01 34 80 C5 1E 60 04 3B 64 45 F7 D1 51 18 4F 10 00 2F 0C DD 01 39 89 00 04 1C 41 18 00 23 0E 68 25 68 01 33 40 C4 0D 60 04 39 BB 42 F7 D1 55 10 00 2D 0B DD 53 1E 9B 00 C3 18 00 22 1C 68 01 68 01 32 10 C0 19 60 04 3B AA 42 F7 D1 F0 BD }
	condition:
		$1
}

rule file_348_1_0 {
	meta:
		name = "getopt_internal"
		size = 1316
		refs = "0040 strcmp 0074 getenv 00a2 memcmp 00e0 strchr 0250 fprintf 031c _impure_ptr 0494 strlen"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 87 B0 05 1C 0C 1C 17 1C 1E 1C 00 29 00 D1 AC E0 00 28 00 D1 A9 E0 00 2B 00 D1 AF E0 12 98 43 68 9D 42 00 DC A1 E0 9B 00 18 59 00 28 00 D1 9C E0 B5 49 8A 46 ?? ?? ?? ?? 00 28 00 D1 1A E2 12 98 43 68 00 2B 02 D1 01 23 03 61 43 60 00 2F 0A D0 3A 78 13 1C 2D 3B 59 42 4B 41 2B 2A 00 D1 04 E2 00 2B 00 D0 FD E1 A9 48 ?? ?? ?? ?? 00 28 00 D1 AF E1 02 20 03 90 12 99 0B 69 01 2B 00 D1 51 E1 00 23 04 93 06 93 00 2E 15 D0 12 98 43 68 9B 00 18 59 51 46 02 22 ?? ?? ?? ?? 00 28 00 D1 9B E1 11 99 00 29 07 D0 12 9A 53 68 9B 00 1B 59 1B 78 2B 2B 00 D1 90 E1 01 23 5B 42 00 22 98 46 92 46 00 2F 00 D1 1E E1 12 98 43 68 9B 00 1A 59 03 69 38 1C D1 5C ?? ?? ?? ?? 07 1C 00 28 00 D1 A2 E0 43 78 3A 2B 00 D1 99 E0 00 23 12 9A 51 68 12 69 89 00 09 59 01 32 89 18 12 98 3A 78 C2 60 8A 46 01 2B 00 D1 79 E0 02 2B 64 D0 42 46 01 32 54 D0 12 98 01 23 03 61 12 99 00 22 0A 60 00 25 03 9A 00 2A 42 D1 01 2B 30 D0 45 46 01 35 2A D0 10 98 00 28 01 D0 41 46 01 60 42 46 13 01 F6 18 B3 68 00 2B 00 D1 9D E1 F2 68 00 20 1A 60 0F E0 12 99 4B 68 9B 00 1B 59 00 2B 92 D0 1B 78 2D 2B 8F D0 11 9A 00 2A 01 D0 2B 2B 8A D0 01 20 40 42 07 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 2A 00 D0 4C E7 F2 E7 12 9B D8 68 F1 E7 04 9B 00 2B 0E D0 06 99 88 00 6A 1C 19 1C 20 18 FF F7 F7 FE 06 9B 12 9A 01 33 5D 19 55 60 BE E7 01 2B BC D1 12 9C 63 68 01 33 5D 19 65 60 B6 E7 12 9D 2B 69 6A 68 01 33 92 00 2B 61 12 59 D2 5C 00 2A A3 D1 01 23 2B 61 A0 E7 51 46 0B 78 3D 2B 03 D1 01 22 92 44 55 46 2B 78 00 2B 01 D1 00 20 82 46 12 9A 51 46 01 23 11 60 13 61 00 25 91 E7 50 46 03 78 3D 2B 03 D1 01 21 8A 44 52 46 13 78 00 2B 2F D0 12 9D 53 46 2B 60 01 23 2B 61 00 25 80 E7 83 78 3A 2B 33 D0 01 23 61 E7 12 99 8B 68 00 2B 0C D0 38 4B 1B 68 D8 68 4B 68 12 9D 9B 00 19 59 2B 69 22 68 CB 5C 34 49 ?? ?? ?? ?? 12 98 02 69 43 68 01 32 99 00 02 61 09 59 8A 5C 00 2A 03 D1 01 33 43 60 01 23 03 61 12 99 3F 23 CB 60 3F 20 7F E7 12 98 43 68 01 33 9D 42 20 DC 82 68 00 2A 07 D1 12 98 43 60 3A 23 C3 60 3A 20 71 E7 02 23 2D E7 20 4D 2B 68 21 49 D8 68 22 68 ?? ?? ?? ?? 41 46 01 31 13 D0 2B 68 42 46 D8 68 13 01 9A 59 1B 49 ?? ?? ?? ?? 12 9C 63 68 01 33 E1 E7 9B 00 1B 59 12 99 0B 60 01 23 0B 61 01 25 29 E7 2B 68 3A 78 D8 68 13 49 ?? ?? ?? ?? 12 9D 6B 68 01 33 CF E7 46 46 B8 46 41 46 57 46 4D 46 DA 46 01 31 00 D1 0C E1 42 46 13 01 9B 19 9B 46 58 46 41 46 43 68 00 29 00 DA DD E6 00 27 FB E6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 03 9A 01 2A 3A D0 02 2A 00 D1 0E E7 4B 68 58 1C 9A 00 83 46 01 1C 12 19 00 20 06 93 91 46 80 46 9C 46 10 68 00 28 23 D0 03 78 02 93 2D 2B 0C D0 11 9B 00 2B 02 D0 02 9B 2B 2B 06 D0 12 98 01 23 41 60 98 44 01 31 04 32 EB E7 41 46 04 91 51 46 ?? ?? ?? ?? 00 28 00 D0 83 E6 48 46 41 46 01 22 FF F7 02 FE 12 99 58 46 48 60 01 20 40 42 EC E6 12 9D 63 46 01 20 6B 60 40 42 E6 E6 12 9B 5A 68 93 00 1B 59 00 2B 00 D1 68 E6 19 78 2D 29 00 D1 64 E6 11 98 00 28 02 D0 2B 29 00 D1 5E E6 12 9C 01 32 23 60 01 23 62 60 E3 60 01 20 CD E6 00 23 03 93 4E E6 12 98 03 69 01 2B 00 D0 69 E6 43 68 9B 00 18 59 51 46 02 22 ?? ?? ?? ?? 00 28 7E D0 12 99 0B 69 12 98 42 68 92 00 10 59 3D 21 C0 18 ?? ?? ?? ?? 82 46 00 28 61 D0 12 98 43 68 9B 00 1A 59 51 46 03 69 8A 1A D3 1A 05 93 01 22 53 42 00 20 98 46 02 90 2B 1C D3 46 35 1C BA 46 99 46 47 46 B0 46 29 68 2E 1C 00 29 00 D1 4D E7 12 9A 53 68 9B 00 18 59 13 69 05 9A C0 18 ?? ?? ?? ?? 00 28 16 D0 02 98 01 30 02 90 10 35 EA E7 01 22 03 92 01 37 05 E6 00 2B F9 D1 02 21 03 91 F8 E7 12 9A 53 68 01 20 01 33 53 60 40 42 75 E6 F0 68 73 E6 30 68 ?? ?? ?? ?? 05 9B 98 42 33 D0 79 1C 01 D1 02 9F DE E7 12 9A 93 68 A9 46 46 46 00 2B 10 D0 1A 4B 12 9D 1B 68 39 01 D8 68 6B 68 89 59 9B 00 22 68 1B 59 00 91 4C 46 21 68 01 91 14 49 ?? ?? ?? ?? 12 9D 3F 23 EB 60 3F 20 4D E6 12 99 4B 68 9B 00 18 59 ?? ?? ?? ?? 12 9A 53 68 9B 00 1B 59 1B 18 9A 46 13 69 C3 1A 05 93 96 E7 12 9A 02 23 13 61 7E E7 02 98 57 46 4D 46 DA 46 B3 46 46 46 80 46 F6 E6 43 46 D8 E5 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_348_2_0 {
	meta:
		name = "__getopt_long_only_r"
		size = 24
	strings:
		$1 = { 10 B5 83 B0 05 9C 00 94 01 24 01 94 06 9C 02 94 FF F7 64 FD 03 B0 10 BD }
	condition:
		$1
}

rule file_348_3_0 {
	meta:
		name = "__getopt_long_r"
		size = 24
	strings:
		$1 = { 10 B5 83 B0 05 9C 00 94 00 24 01 94 06 9C 02 94 FF F7 58 FD 03 B0 10 BD }
	condition:
		$1
}

rule file_348_4_0 {
	meta:
		name = "__getopt_r"
		size = 22
	strings:
		$1 = { 10 B5 83 B0 00 24 02 93 00 23 00 94 01 94 FF F7 4D FD 03 B0 10 BD }
	condition:
		$1
}

rule file_348_5_0 {
	meta:
		name = "getopt_long_only"
		size = 76
	strings:
		$1 = { F0 B5 10 4D 2E 68 88 B0 03 96 6E 68 03 AC 66 60 0D 4E 37 68 A7 60 77 68 E7 60 AF 68 27 61 0D 9F 00 97 01 27 01 97 02 94 FF F7 34 FD 03 9B 2B 60 63 68 6B 60 A3 68 33 60 E3 68 73 60 23 69 08 B0 AB 60 F0 BD ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_348_6_0 {
	meta:
		name = "getopt_long"
		size = 76
	strings:
		$1 = { F0 B5 10 4D 2E 68 88 B0 03 96 6E 68 03 AC 66 60 0D 4E 37 68 A7 60 77 68 E7 60 AF 68 27 61 0D 9F 00 97 00 27 01 97 02 94 FF F7 0E FD 03 9B 2B 60 63 68 6B 60 A3 68 33 60 E3 68 73 60 23 69 08 B0 AB 60 F0 BD ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_348_7_0 {
	meta:
		name = "getopt"
		size = 76
	strings:
		$1 = { 70 B5 10 4D 2B 68 88 B0 0F 4E 03 93 6B 68 03 AC 63 60 33 68 A3 60 73 68 E3 60 AB 68 23 61 00 23 00 93 01 93 02 94 FF F7 E9 FC 03 9B 2B 60 63 68 6B 60 A3 68 33 60 E3 68 73 60 23 69 08 B0 AB 60 70 BD C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "isdigit"
		size = 20
		refs = "0010 __ctype_ptr__"
	strings:
		$1 = { 03 4B 1B 68 18 18 40 78 04 23 18 40 70 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "__malloc_update_mallinfo"
		size = 96
		refs = "0054 __malloc_av_ 005c __malloc_current_mallinfo"
	strings:
		$1 = { 70 B5 14 4B 9B 68 5B 68 03 22 19 1C 91 43 0A 1C 9C 46 01 21 0F 2A 00 DC 00 21 0F 4C FE 23 9B 00 E6 18 03 25 E3 68 A3 42 06 D0 58 68 DB 68 A8 43 12 18 01 31 A3 42 F8 D1 08 34 B4 42 F2 D1 07 4B 59 60 19 68 89 1A D9 61 1A 62 61 46 03 22 91 43 59 62 70 BD ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_350_1_0 {
	meta:
		name = "_mallinfo_r"
		size = 56
		refs = "000a __malloc_lock 000e __malloc_update_mallinfo 0028 __malloc_unlock 0034 __malloc_current_mallinfo"
	strings:
		$1 = { 70 B5 8A B0 04 1C 08 1C 0D 1C ?? ?? ?? ?? ?? ?? ?? ?? 08 4A 23 1C 43 CA 43 C3 43 CA 43 C3 43 CA 43 C3 12 68 28 1C 1A 60 ?? ?? ?? ?? 0A B0 20 1C 70 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_351_0_0 {
	meta:
		name = "quorem"
		size = 348
		refs = "0036 __udivsi3 00c6 __mcmp"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0B 69 02 69 83 B0 06 1C 88 46 93 42 00 DD 9B E0 5D 1E 04 33 9B 00 C8 18 0C 1C 31 1C 14 31 42 46 01 91 99 58 00 90 01 31 98 59 ?? ?? ?? ?? 14 34 07 1C 00 28 3F D0 00 23 99 46 9A 46 01 9A 43 4B 02 94 B3 46 21 1C 4E 46 A9 46 10 C9 25 1C 1D 40 7D 43 20 0C 78 43 14 68 1C 40 A4 46 75 19 E2 44 2E 0C 54 46 1D 40 65 1B 14 68 30 18 24 0C 06 0C 18 40 20 1A 2C 14 00 19 04 14 1D 40 00 04 28 43 01 C2 00 98 A2 46 88 42 DF D2 4D 46 6B 1D 5E 46 9B 00 9A 59 02 9C 00 2A 0D D1 F3 18 01 99 04 3B 99 42 04 D3 06 E0 04 3B 01 3D 99 42 02 D2 1A 68 00 2A F8 D0 35 61 30 1C 41 46 ?? ?? ?? ?? 00 28 3A DB 01 37 00 23 BC 46 00 9F 98 46 01 9A 1F 4B B2 46 BB 46 46 46 A8 46 15 68 01 CC 29 1C 19 40 89 46 01 1C 19 40 4F 46 79 1A 89 19 2D 0C 00 0C 0E 14 28 1A 80 19 06 14 19 40 00 04 01 43 02 C2 A3 45 E9 D2 45 46 6B 1D 56 46 9B 00 9A 59 67 46 00 2A 11 D1 F3 18 01 98 04 3B 98 42 0B D2 1A 68 00 2A 08 D1 01 1C 02 E0 1A 68 00 2A 03 D1 04 3B 01 3D 99 42 F8 D3 35 61 38 1C 03 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 20 F6 E7 FF FF 00 00 }
	condition:
		$1
}

rule file_351_1_0 {
	meta:
		name = "_dtoa_r"
		size = 3784
		refs = "0032 _Bfree 005a __nedf2 00c4 __d2b 00f2 __subdf3 00fa __muldf3 0102 __adddf3 010c __floatsidf 0128 __fixdfsi 0136 __ltdf2 020c _Balloc 0248 __divdf3 0330 __eqdf2 0384 .LC9 03c0 __mprec_tens 03f4 __floatunsidf 04f2 __gtdf2 05b8 __mprec_bigtens 0612 __i2b 0652 __pow5mult 065e __multiply 06d4 __lshift 073c __mcmp 0748 __mdiff 07ae __multadd 0880 __gedf2 0b46 __hi0bits 0dee memcpy"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 9C B0 04 1C 99 46 27 98 28 9B 0E 1C 21 6C 80 46 9A 46 17 1C 00 29 0A D0 63 6C 4B 60 63 6C 01 22 9A 40 8A 60 20 1C ?? ?? ?? ?? 00 23 23 64 35 1E 35 DB 00 23 41 46 0B 60 CC 4B 2A 1C 1A 40 9A 42 1B D0 30 1C 39 1C CA 4A CA 4B 01 96 02 97 ?? ?? ?? ?? 00 28 2A D1 26 98 01 23 51 46 03 60 00 29 00 D1 CB E1 C4 48 52 46 10 60 01 38 1C B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD C0 4B 26 9A 13 60 00 2F 00 D1 6D E1 BE 48 51 46 00 29 EE D0 C2 78 C3 1C 00 2A 00 D0 05 33 52 46 13 60 E6 E7 01 23 40 46 03 60 B7 4B 1D 40 2E 1C C5 E7 1B AB 00 93 20 1C 1A AB 01 99 02 9A ?? ?? ?? ?? 6B 00 5B 0D 08 90 00 2B 00 D1 7D E1 01 98 02 99 AE 4D AF 4A 05 40 28 1C 10 43 AE 4A 9D 18 1B 9B 00 22 16 92 9B 46 AC 4A AC 4B ?? ?? ?? ?? AC 4A AC 4B ?? ?? ?? ?? AC 4A AC 4B ?? ?? ?? ?? 05 90 06 91 28 1C ?? ?? ?? ?? A9 4A AA 4B ?? ?? ?? ?? 02 1C 0B 1C 05 98 06 99 ?? ?? ?? ?? 05 90 06 91 ?? ?? ?? ?? 93 4A 94 4B 80 46 05 98 06 99 ?? ?? ?? ?? 00 28 0B DA 40 46 ?? ?? ?? ?? 05 9A 06 9B ?? ?? ?? ?? 00 28 02 D0 01 23 5B 42 98 44 40 46 16 28 00 D8 0F E2 01 21 15 91 5B 46 01 3B 5D 1B 00 D5 3F E3 00 22 09 95 0B 92 40 46 00 28 00 DA 2F E3 09 99 0A 1C 42 44 13 90 00 20 09 92 12 90 48 46 09 28 00 D9 3D E1 05 28 01 DC 00 F0 82 FE 04 22 52 42 00 23 91 44 9C 46 48 46 03 28 01 D1 00 F0 B0 FC 03 28 00 DC 3A E3 49 46 04 29 01 D1 00 F0 B5 FC 05 29 00 D0 35 E3 01 20 14 90 25 99 0A 1C 42 44 10 1C 01 30 0C 92 00 28 01 DC 00 F0 E7 FC 00 25 05 90 65 64 17 28 01 D8 00 F0 4A FE 01 22 04 23 5B 00 1D 1C 14 35 11 1C 01 32 85 42 F8 D9 05 98 0E 23 00 25 83 42 6D 41 62 46 61 64 20 1C 15 40 ?? ?? ?? ?? 0A 90 20 64 00 2D 00 D0 0B E1 40 46 1A 9B 0E 28 00 DD D9 E1 00 2B 00 DA D6 E1 65 4A C3 00 D3 18 19 68 5A 68 01 91 02 92 05 9A 00 2A 00 DC 0F E3 01 9A 02 9B 30 1C 39 1C ?? ?? ?? ?? ?? ?? ?? ?? 81 46 ?? ?? ?? ?? 01 9A 02 9B ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 06 1C 0F 1C 02 1C 0B 1C 0A 98 49 46 30 31 01 70 05 99 05 1C 01 35 01 29 43 D0 30 1C 39 1C 4E 4A 4F 4B ?? ?? ?? ?? 3A 4A 3B 4B 06 1C 0F 1C ?? ?? ?? ?? 00 28 00 D1 D5 E2 01 23 9B 46 23 1C 5C 46 C3 46 98 46 0C E0 44 4A 45 4B ?? ?? ?? ?? 30 4A 31 4B 06 1C 0F 1C ?? ?? ?? ?? 00 28 00 D1 BF E2 01 9A 02 9B 30 1C 39 1C ?? ?? ?? ?? ?? ?? ?? ?? 81 46 ?? ?? ?? ?? 01 9A 02 9B ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 4B 46 30 33 2B 70 05 9A 01 34 01 35 A2 42 D5 D1 44 46 02 1C 0B 1C D8 46 10 1C 19 1C ?? ?? ?? ?? 06 1C 0F 1C 32 1C 01 98 02 99 3B 1C ?? ?? ?? ?? 00 28 0C DB 01 98 02 99 32 1C 3B 1C ?? ?? ?? ?? 00 28 00 D0 89 E2 48 46 C0 07 00 D4 85 E2 0A 99 00 E0 1D 1C 6B 1E 1A 78 39 2A 01 D0 00 F0 18 FD 8B 42 F6 D1 0A 9A 30 23 13 70 01 21 0A 9B 88 44 31 22 40 46 1A 70 0D 90 F6 E0 2B 03 00 D0 8E E6 15 48 8D E6 00 00 F0 7F 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 0F 27 00 00 ?? ?? ?? ?? FF FF FF 7F FF FF 0F 00 00 00 F0 3F 01 FC FF FF 00 00 F8 3F 00 00 00 00 A7 87 D2 3F 61 43 6F 63 28 8A C6 3F B3 C8 60 8B 13 44 D3 3F FB 79 9F 50 ?? ?? ?? ?? 00 00 24 40 00 00 00 00 ?? ?? ?? ?? 1B 9B 9B 46 1A 9B 72 48 5B 44 C0 18 80 46 20 28 00 DC 08 E2 6F 49 40 22 12 1A 5B 18 38 1C 95 40 D8 40 28 43 ?? ?? ?? ?? 6B 4A 6C 4B 80 18 1D 1C 01 22 45 44 16 92 72 E6 69 48 35 E6 01 23 00 25 14 93 5B 42 0C 93 05 93 25 95 A9 46 00 23 63 64 00 21 20 1C ?? ?? ?? ?? 0A 90 20 64 00 2D 00 D1 F3 E6 43 46 00 2B 00 DC EA E2 0F 23 42 46 5D 49 1A 40 D2 00 8A 18 10 68 51 68 03 90 04 91 41 46 0D 11 EA 06 00 D5 DB E1 01 98 02 99 0D 90 0E 91 02 27 00 2D 12 D0 01 21 8B 46 53 4E 03 98 04 99 5A 46 15 42 04 D0 32 68 73 68 01 37 ?? ?? ?? ?? 6D 10 08 36 00 2D F3 D1 03 90 04 91 0D 98 0E 99 03 9A 04 9B ?? ?? ?? ?? 0F 90 10 91 15 9B 00 2B 09 D0 0F 98 10 99 45 4A 45 4B ?? ?? ?? ?? 00 28 01 DA 00 F0 31 FC 38 1C ?? ?? ?? ?? 0F 9A 10 9B ?? ?? ?? ?? 3F 4A 40 4B ?? ?? ?? ?? 0E 1C 3F 49 05 1C 05 9A 6F 18 3D 1C 00 2A 00 D0 04 E2 3C 4A 3C 4B 0F 98 10 99 ?? ?? ?? ?? 3A 1C 33 1C 03 90 04 91 ?? ?? ?? ?? 00 28 00 DD C6 E1 80 23 1B 06 FB 18 03 98 04 99 03 93 04 96 03 9A 04 9B ?? ?? ?? ?? 00 28 00 DB DB E1 00 23 03 93 9B 46 25 98 59 46 C0 43 80 46 0A 9D 00 20 01 91 83 46 03 99 20 1C ?? ?? ?? ?? 01 99 00 29 00 D1 87 E1 8B 45 06 D0 5A 46 00 2A 03 D0 20 1C 59 46 ?? ?? ?? ?? 20 1C 01 99 ?? ?? ?? ?? 43 46 0D 93 20 1C 08 99 ?? ?? ?? ?? 00 23 2B 70 0D 9B 26 98 01 33 51 46 03 60 00 29 01 D0 52 46 15 60 0A 98 7C E5 42 46 D3 00 0C 4A D3 18 01 98 02 99 1A 68 5B 68 ?? ?? ?? ?? 00 28 00 DA 35 E1 00 23 15 93 E1 E5 C0 46 32 04 00 00 12 04 00 00 00 00 10 FE CD FB FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 F0 3F 00 00 00 00 00 00 1C 40 00 00 00 00 00 00 C0 FC 00 00 14 40 00 00 00 00 14 98 00 28 00 D1 2E E1 48 46 01 28 00 DC C4 E3 05 9A 12 9B 01 3A 93 42 00 DA 87 E3 9A 1A 01 92 05 9B 00 2B 00 DA C6 E3 0B 9D 09 98 0B 9A C0 18 D2 18 09 90 01 21 20 1C 0B 92 ?? ?? ?? ?? 83 46 09 99 00 29 0C DD 00 2D 0A DD 0B 1C A9 42 00 DD 2B 1C 0B 9A 09 98 D2 1A C0 1A 0B 92 09 90 ED 1A 12 99 00 29 1E DD 14 9A 00 2A 00 D1 1A E3 01 9B 00 2B 11 DD 1A 1C 59 46 20 1C ?? ?? ?? ?? 83 46 59 46 08 9A 20 1C ?? ?? ?? ?? 08 99 03 90 20 1C ?? ?? ?? ?? 03 98 08 90 12 99 01 9B CA 1A 00 2A 00 D0 74 E3 20 1C 01 21 ?? ?? ?? ?? 03 90 13 98 00 28 05 DD 20 1C 03 99 13 9A ?? ?? ?? ?? 03 90 49 46 01 29 00 DC 94 E2 00 23 01 93 13 98 00 28 00 D0 47 E2 01 23 09 98 1A 18 1F 23 1A 40 00 D0 F6 E0 1C 23 0B 98 09 99 C0 18 C9 18 0B 90 09 91 ED 18 0B 9A 00 2A 04 DD 20 1C 08 99 ?? ?? ?? ?? 08 90 09 9B 00 2B 05 DD 20 1C 03 99 1A 1C ?? ?? ?? ?? 03 90 15 98 00 28 00 D0 41 E2 05 99 00 29 00 DC C6 E2 14 99 00 29 00 D1 75 E2 00 2D 05 DD 59 46 20 1C 2A 1C ?? ?? ?? ?? 83 46 01 9A 00 2A 00 D0 5B E3 5B 46 01 93 01 23 3B 40 0B 93 0A 9D 5F 46 C3 46 03 99 08 98 FF F7 B8 FB 30 30 09 90 39 1C 08 98 ?? ?? ?? ?? 03 99 07 90 01 9A 20 1C ?? ?? ?? ?? C3 68 80 46 00 2B 00 D1 7E E0 01 26 20 1C 41 46 ?? ?? ?? ?? 00 2E 06 D1 48 46 00 28 03 D1 0B 99 00 29 00 D1 61 E3 07 99 00 29 00 DA 0E E3 00 29 06 D1 4A 46 00 2A 03 D1 0B 9B 00 2B 00 D1 05 E3 00 2E 00 DD 41 E3 09 A8 00 78 28 70 0A 99 01 35 05 9A 6B 1A 93 42 00 D1 34 E3 00 23 20 1C 08 99 0A 22 ?? ?? ?? ?? 01 9B 08 90 9F 42 00 D1 8C E0 39 1C 0A 22 00 23 20 1C ?? ?? ?? ?? 01 99 07 1C 0A 22 20 1C 00 23 ?? ?? ?? ?? 01 90 A8 E7 0B 99 42 46 89 1A 00 23 52 42 0B 91 12 92 13 93 CD E4 6D 42 00 23 0B 95 09 93 BD E4 20 20 42 46 80 1A 3B 1C 83 40 18 1C F7 E5 01 20 40 42 00 21 80 44 15 91 A8 E4 1D 40 CF 4B 01 98 02 99 1A 6A 5B 6A ?? ?? ?? ?? 03 27 0D 90 0E 91 1C E6 02 28 00 D1 72 E1 01 22 00 25 14 92 52 42 0C 92 05 92 25 95 EE E5 12 99 00 22 01 91 0B 9D 93 46 E6 E6 44 46 D8 46 40 46 0D 90 83 E6 08 98 41 46 ?? ?? ?? ?? 06 1C 7B E7 25 9B 00 2B 00 DB EB E4 05 9A 00 2A 00 D0 53 E6 B8 4A B9 4B 01 98 02 99 ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 00 28 00 DB 46 E6 00 21 03 91 8B 46 0A 9A 58 46 31 23 13 70 15 1C 01 23 01 90 00 20 01 35 98 44 83 46 42 E6 20 23 9B 1A 04 2B 00 DC ED E2 0B 99 09 9A 04 3B C9 18 D2 18 0B 91 ED 18 09 92 02 E7 17 9A 18 9B 0F 9C 90 46 99 46 DA 46 01 9E 02 9F A1 E4 39 1C 20 1C 0A 22 00 23 ?? ?? ?? ?? 07 1C 01 90 21 E7 40 46 0D 90 05 98 11 90 14 99 00 29 00 D1 96 E0 11 9B 01 3B DA 00 97 4B 9B 18 1A 68 5B 68 96 48 96 49 ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 03 90 04 91 0F 98 10 99 ?? ?? ?? ?? 05 1C ?? ?? ?? ?? 02 1C 0B 1C 0F 98 10 99 ?? ?? ?? ?? 0A 9A 2B 1C 30 33 13 70 06 1C 0F 1C 15 1C 03 98 04 99 32 1C 3B 1C 01 35 ?? ?? ?? ?? 00 28 00 DD 02 E6 32 1C 3B 1C 83 48 83 49 ?? ?? ?? ?? 02 1C 0B 1C 03 98 04 99 ?? ?? ?? ?? 00 28 00 DD DE E0 11 9B 01 2B AA DD 01 20 83 46 41 46 48 46 17 91 D9 46 A8 46 0F 94 18 90 D3 46 12 E0 32 1C 3B 1C 74 48 75 49 ?? ?? ?? ?? 03 9A 04 9B ?? ?? ?? ?? 00 28 00 DA C0 E0 01 20 11 99 81 44 89 45 00 DB 86 E7 03 98 04 99 6D 4A 6D 4B ?? ?? ?? ?? 6B 4A 6B 4B 03 90 04 91 30 1C 39 1C ?? ?? ?? ?? 0D 1C 04 1C ?? ?? ?? ?? 82 46 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 53 46 42 46 30 33 13 70 01 23 98 44 03 9A 04 9B 06 1C 0F 1C ?? ?? ?? ?? 00 28 C3 DA 45 46 0F 9C DA 46 A5 E5 43 46 5D 42 00 2D 00 D0 4D E1 01 98 02 99 02 27 0F 90 10 91 3A E5 11 98 4C 4B 01 38 C2 00 9B 18 17 90 2A 1C 18 68 59 68 33 1C ?? ?? ?? ?? 18 90 19 91 0F 98 10 99 ?? ?? ?? ?? 05 1C ?? ?? ?? ?? 02 1C 0B 1C 0F 98 10 99 ?? ?? ?? ?? 2B 1C 03 90 04 91 0A 99 30 33 0B 70 11 9A 0D 1C 01 35 01 2A 28 D0 0A 9B 42 46 9B 46 11 9B 03 98 04 99 0F 95 11 92 9B 44 2E 1C A0 46 39 4A 3A 4B ?? ?? ?? ?? 0D 1C 04 1C ?? ?? ?? ?? 07 1C ?? ?? ?? ?? 30 37 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 37 70 01 36 5E 45 E9 D1 03 90 04 91 0F 9D 11 98 17 99 44 46 6D 18 80 46 26 4A 27 4B 18 98 19 99 ?? ?? ?? ?? 02 1C 0B 1C 03 98 04 99 ?? ?? ?? ?? 00 28 28 DC 18 9A 19 9B 1E 48 1F 49 ?? ?? ?? ?? 02 1C 0B 1C 03 98 04 99 ?? ?? ?? ?? 00 28 00 DB E8 E6 00 E0 1D 1C 6B 1E 1A 78 30 2A FA D0 27 E5 00 20 14 90 FF F7 59 FB 00 23 14 93 25 9A 00 2A 4E DD 25 98 0C 90 FF F7 5A FB 01 21 14 91 F5 E7 0F 9C 45 46 DA 46 0D 9B 0A 99 98 46 FF F7 06 FC 03 99 0B 69 04 33 9B 00 58 58 ?? ?? ?? ?? 20 23 1B 1A AE E5 ?? ?? ?? ?? 00 00 14 40 00 00 00 00 ?? ?? ?? ?? 00 00 E0 3F 00 00 00 00 00 00 F0 3F 00 00 00 00 00 00 24 40 00 00 00 00 08 98 03 99 ?? ?? ?? ?? 00 28 00 DB B6 E5 01 21 49 42 0A 22 88 44 20 1C 08 99 00 23 ?? ?? ?? ?? 14 9A 08 90 00 2A 00 D0 62 E1 0C 9B 05 93 A5 E5 0E 25 00 23 85 42 5B 41 1D 1C 63 46 1D 40 05 90 FF F7 30 FC 01 23 65 46 0C 93 05 93 25 93 FF F7 29 FC 00 2F 00 D0 67 E5 33 03 00 D0 64 E5 B3 4B 1E 42 00 D1 60 E5 0B 98 09 99 01 30 01 31 01 22 0B 90 09 91 01 92 59 E5 05 98 27 1C 0A 9D 01 26 81 46 08 9C 07 E0 21 1C 38 1C 0A 22 00 23 ?? ?? ?? ?? 01 36 04 1C 20 1C 03 99 FF F7 47 F9 30 30 28 70 01 35 4E 45 EE DB 59 46 09 90 01 91 00 20 08 94 83 46 3C 1C 08 99 20 1C 01 22 ?? ?? ?? ?? 03 99 08 90 ?? ?? ?? ?? 00 28 0F DD 0A 99 00 E0 1D 1C 6B 1E 1A 78 39 2A 00 D0 BB E0 8B 42 F7 D1 0A 98 01 22 31 23 90 44 03 70 64 E4 00 28 04 D1 09 99 C9 07 EA D4 00 E0 1D 1C 6B 1E 1A 78 30 2A FA D0 58 E4 20 1C 08 99 12 9A ?? ?? ?? ?? 08 90 F8 E4 4A 46 02 2A 00 DC 34 E5 00 29 00 D0 42 E4 03 99 20 1C 05 22 00 23 ?? ?? ?? ?? 03 90 03 99 08 98 ?? ?? ?? ?? 00 28 00 DD ED E5 33 E4 0F 23 2B 40 DA 00 7A 4B 9B 18 01 98 02 99 1A 68 5B 68 ?? ?? ?? ?? 2D 11 0F 90 10 91 00 2D 00 D1 BE E0 01 21 8B 46 73 4E 0F 98 10 99 02 27 5A 46 15 42 04 D0 32 68 73 68 01 37 ?? ?? ?? ?? 6D 10 08 36 00 2D F3 D1 0F 90 10 91 FF F7 CC FB 12 98 13 99 12 1A 89 18 80 18 00 22 13 91 12 90 01 92 6F E4 05 98 00 28 01 DC FF F7 CA FB 0C 99 00 29 00 DC D2 E5 42 46 01 3A 0D 92 0F 98 10 99 5E 4A 5F 4B ?? ?? ?? ?? 0F 90 10 91 78 1C ?? ?? ?? ?? 02 1C 0B 1C 0F 98 10 99 ?? ?? ?? ?? 59 4A 59 4B ?? ?? ?? ?? 59 4B C5 18 0C 98 0E 1C 11 90 C4 E5 20 1C 08 99 ?? ?? ?? ?? 08 90 84 E4 16 99 00 29 43 D0 52 4A 12 98 9B 18 01 90 0B 9D 3E E4 01 32 12 06 12 0E FF F7 EC FA 0B 98 05 99 00 23 45 1A 34 E4 D8 46 BB 46 00 2E 0F DD 08 99 20 1C 01 22 ?? ?? ?? ?? 03 99 08 90 ?? ?? ?? ?? 00 28 52 DD 09 99 39 29 37 D0 01 31 09 91 09 AA 12 78 2A 70 01 35 FF F7 B1 FB 01 32 1A 70 FF F7 AD FB 58 46 41 68 20 1C ?? ?? ?? ?? 5B 46 1A 69 59 46 02 32 05 1C 0C 31 92 00 0C 30 ?? ?? ?? ?? 20 1C 29 1C 01 22 ?? ?? ?? ?? 01 90 8F E4 1B 9A 12 99 36 23 9B 1A 01 91 0B 9D FF F7 F9 FB D8 46 BB 46 0B E7 09 9B D8 46 BB 46 39 2B 05 D0 09 9B 01 33 2B 70 01 35 FF F7 81 FB 39 23 2B 70 0A 99 01 35 09 E7 09 9A D8 46 BB 46 39 2A F5 D0 07 9B 00 2B 01 DD 01 32 09 92 09 A8 00 78 28 70 01 35 FF F7 6C FB 02 27 FF F7 20 FB 00 28 AF D1 09 98 C0 07 AC D5 A6 E7 59 46 20 1C 0A 22 00 23 ?? ?? ?? ?? 83 46 0C 98 05 90 3B E4 05 99 0E 23 8B 42 6D 41 62 46 15 40 00 21 FF F7 CA FA 04 2B 01 D1 FF F7 1A FC 1C 33 FF F7 10 FC 01 21 8C 46 FF F7 7F F9 00 00 F0 7F ?? ?? ?? ?? ?? ?? ?? ?? 00 00 24 40 00 00 00 00 00 00 1C 40 00 00 00 00 00 00 C0 FC 33 04 00 00 }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "_fdopen_r"
		size = 80
		refs = "000c __sflags 001e __sfp 0040 __sread 0044 __swrite 0048 __sseek 004c __sclose"
	strings:
		$1 = { 70 B5 81 B0 0E 1C 11 1C 6A 46 04 1C ?? ?? ?? ?? 05 1C 00 28 02 D1 00 20 01 B0 70 BD 20 1C ?? ?? ?? ?? 00 28 F8 D0 06 4B 03 62 06 4B 43 62 06 4B 83 62 06 4B 85 81 C6 81 C0 61 C3 62 EC E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_353_0_0 {
	meta:
		name = "validate_structure"
		size = 504
		refs = "0038 __modsi3 0136 div"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 01 68 82 B0 06 1C 3B 29 00 D9 C3 E0 41 68 3B 29 00 D9 AD E0 B1 68 17 29 00 D9 97 E0 34 69 0B 2C 00 DD 80 E0 75 69 A9 07 34 D1 28 1C 64 21 ?? ?? ?? ?? 00 28 26 D0 F5 68 1D 22 00 2D 2E DC 03 21 88 46 66 4F 0B E0 01 2C 00 D1 B5 E0 21 1C 13 1C 89 00 CA 59 AD 18 00 2D 00 DD B2 E0 1A 1C 01 3C F1 D2 74 69 43 46 60 1E 70 61 18 42 00 D0 B4 E0 64 21 ?? ?? ?? ?? 00 28 00 D1 A5 E0 1D 23 0B 24 0B 21 E5 E7 57 4B C8 21 E8 18 49 00 ?? ?? ?? ?? 00 28 D0 D0 F5 68 1C 22 00 2D D0 DD 50 4F 00 21 03 23 B8 46 8A 46 99 46 0F E0 A3 00 DB 59 AB 42 10 DA 01 2C 14 D0 A4 00 41 46 63 58 34 69 ED 1A 01 34 F5 60 34 61 0C 2C 12 D0 01 2C ED D1 13 1C AB 42 EE DB 02 B0 1C BC 90 46 99 46 A2 46 F0 BD 34 69 13 1C ED 1A 01 34 F5 60 34 61 0C 2C EC D1 74 69 53 46 60 1C 49 46 70 61 33 61 08 42 0F D1 64 21 ?? ?? ?? ?? 00 28 07 D1 36 4B C8 21 E0 18 49 00 ?? ?? ?? ?? 00 28 02 D1 1D 22 00 24 C4 E7 1C 22 00 24 C1 E7 21 1C 68 46 0C 22 ?? ?? ?? ?? 75 69 00 9B 01 9C ED 18 75 61 34 61 00 2C 00 DB 71 E7 0C 34 01 3D 34 61 75 61 6C E7 18 22 68 46 ?? ?? ?? ?? F2 68 00 9B 01 9C D3 18 F3 60 B4 60 00 2C 00 DB 5A E7 18 34 01 3B B4 60 F3 60 55 E7 68 46 3C 22 ?? ?? ?? ?? B1 68 00 9B 01 9C C9 18 B1 60 74 60 00 2C 00 DB 45 E7 3C 34 01 39 74 60 B1 60 40 E7 68 46 3C 22 ?? ?? ?? ?? 71 68 00 9B 01 9C C9 18 71 60 34 60 00 2C 00 DB 2F E7 3C 34 01 39 34 60 71 60 2A E7 AD 18 13 1C 00 2D 00 DC 4C E7 34 61 F5 60 85 E7 08 49 60 18 C8 21 49 00 ?? ?? ?? ?? 00 28 00 D1 50 E7 1C 23 4F E7 ?? ?? ?? ?? 6C 07 00 00 6D 07 00 00 6B 07 00 00 }
	condition:
		$1
}

rule file_353_1_0 {
	meta:
		name = "mktime"
		size = 660
		refs = "0010 __gettzinfo 0064 __modsi3 00f0 __tzcalc_limits 0290 _daylight"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 81 B0 06 1C ?? ?? ?? ?? 80 46 30 1C FF F7 F6 FE B1 68 72 68 33 69 89 46 95 49 93 46 9A 00 F5 68 8A 18 30 68 12 6B 01 3D 00 90 AD 18 01 2B 00 DC E8 E0 77 69 BB 07 68 D0 8E 4B FA 18 8E 4B F5 61 9A 42 00 D9 6F E0 46 2F 00 DC 6F E0 03 20 46 24 82 46 13 E0 20 1C 64 21 ?? ?? ?? ?? 00 28 07 D1 86 4A C8 21 A0 18 49 00 ?? ?? ?? ?? 00 28 08 D1 B7 23 5B 00 01 34 ED 18 BC 42 07 D0 51 46 0C 42 E8 D0 7F 4B 01 34 ED 18 BC 42 F7 D1 28 1D 07 21 ?? ?? ?? ?? B0 61 00 28 00 DA 7F E0 48 46 03 01 1B 1A 1A 01 59 46 D3 1A 0A 01 52 1A 92 00 1B 01 9B 18 00 9A 9B 18 6A 00 55 19 2A 01 55 1B 2A 01 55 1B ED 01 34 6A 5B 19 9A 46 00 2C 00 DD 01 24 6C 4B 1B 68 00 2B 09 D0 68 4B 45 46 F8 18 6B 68 83 42 5E D0 ?? ?? ?? ?? 00 28 5A D1 25 1C 01 2D 00 D1 98 E0 42 46 10 6A 50 44 35 62 01 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 38 1C 64 21 ?? ?? ?? ?? 00 28 78 D0 01 35 56 4B FA 18 56 4B F5 61 9A 42 00 D8 8F E7 01 20 40 42 E7 E7 46 2F AD D0 45 2F 00 D1 83 E0 03 23 45 24 9A 46 13 E0 20 1C 64 21 ?? ?? ?? ?? 00 28 07 D1 4C 49 60 18 C8 21 49 00 ?? ?? ?? ?? 00 28 08 D1 B7 23 5B 00 01 3C ED 1A BC 42 07 D0 50 46 04 42 E8 D0 44 4B 01 3C ED 1A BC 42 F7 D1 BA 07 61 D1 38 1C 64 21 ?? ?? ?? ?? 00 28 53 D0 B7 23 5B 00 ED 1A 28 1D 07 21 ?? ?? ?? ?? B0 61 00 28 00 DB 7F E7 07 30 B0 61 7C E7 47 46 BB 6B FA 6B 39 6A 58 1A 9B 1A FD 69 9A 45 34 DB AD 1A 43 46 AB 46 1D 68 00 2D 41 D0 01 25 00 95 82 45 4D DA 50 46 5B 46 55 46 C0 17 DB 0F 5F 46 BD 42 58 41 05 1C 00 98 05 40 00 2C 00 DA 84 E7 6C 40 01 2C 00 D0 80 E7 8C 1A 00 2D 00 D1 64 42 33 68 1B 19 33 60 30 1C FF F7 FE FD A2 44 74 E7 77 69 17 E7 1C 49 78 18 C8 21 49 00 ?? ?? ?? ?? 00 28 00 D0 0E E7 01 35 7C E7 82 45 00 DB 63 E7 C6 E7 41 46 C8 6B 50 44 65 E7 13 4B C8 21 F8 18 49 00 ?? ?? ?? ?? 00 28 A3 D0 10 4B ED 1A A3 E7 01 23 00 93 82 45 0E DA 57 46 58 46 5D 46 FF 17 C0 0F 53 46 AB 42 47 41 3D 1C 00 9F 3D 43 BC E7 00 27 00 97 AE E7 00 25 00 95 ED E7 ?? ?? ?? ?? 10 27 00 00 20 4E 00 00 6C 07 00 00 6D 01 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 620
		refs = "0060 memcmp"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 95 4C 85 25 A5 44 ED 00 6D 44 00 90 02 91 10 1C 19 1C 17 1C 2A 1C 1C 1C FF F7 88 FF 06 1C 0A A8 80 46 03 1C 10 C3 9D 42 FC D1 00 2C 00 D1 11 E1 65 1E 2A 1C 00 23 F9 5C 40 46 89 00 01 33 42 50 01 3A 9C 42 F7 D8 85 22 D2 00 6A 44 11 68 38 1C 79 18 32 1C ?? ?? ?? ?? 00 28 00 D0 80 E0 85 23 DB 00 6B 44 1B 68 E0 1A 06 90 00 9A 00 98 00 21 04 93 73 1E 8B 46 52 19 B1 1E C0 18 01 93 01 23 9B 1B 03 92 7A 18 07 90 05 91 08 92 09 93 B4 46 BA 46 5E 46 A1 46 2F 1C 03 9C 58 46 23 5C 41 46 9B 00 CB 58 00 2B 52 D1 33 1C 66 45 00 D2 63 46 BB 42 13 D2 54 46 E1 18 58 46 00 9C 1A 18 A2 18 10 78 0C 78 84 42 06 D0 3A E0 4C 78 50 78 01 31 01 32 84 42 34 D1 01 33 BB 42 F6 D3 66 45 00 D3 AD E0 01 9B 50 46 07 9C C1 5C 58 46 22 5C 91 42 00 D0 A4 E0 05 9C 00 98 22 1C 5A 44 08 99 82 18 07 E0 0C 78 10 78 5D 1E 01 39 01 3A 84 42 02 D1 2B 1C 9E 42 F5 D3 01 36 9E 42 00 D9 94 E0 04 9A 06 9E 93 44 02 9C 48 46 23 1A 5B 45 B4 D2 00 20 4A 4B 9D 44 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 09 9C 22 1C 5A 44 D2 18 93 46 00 26 EA E7 00 2E 04 D0 04 9A 93 42 01 D2 06 9B 00 26 9B 44 E1 E7 A3 1B B3 42 69 D3 85 21 C9 00 01 33 69 44 00 9A 0B 60 06 93 00 99 73 1E 9C 46 52 19 B3 1E 01 92 03 93 0A 1C F9 18 01 23 62 44 9B 1B 04 92 05 91 BA 19 07 93 BA 46 00 20 67 46 A4 46 14 1C 01 99 0B 5C 42 46 9B 00 D3 58 00 2B 39 D1 AE 42 16 D2 00 9B 82 19 9A 18 21 78 13 78 99 42 48 D1 21 1C 33 1C 81 46 A3 46 05 E0 4C 78 50 78 01 31 01 32 84 42 2C D1 01 33 AB 42 F6 D3 48 46 5C 46 79 1C 18 D0 04 99 52 46 D3 5D 0A 5C 93 42 17 D1 03 9A 00 9B 12 18 91 46 1A 1C 4A 44 05 99 3B 1C A9 46 A3 46 05 E0 0D 78 14 78 01 39 01 3A A5 42 04 D1 01 3B F7 D2 00 9C 20 18 8A E7 4D 46 5C 46 06 9B C0 18 02 99 62 46 8B 1A 98 42 B8 D9 7F E7 48 46 5C 46 07 99 08 18 C0 18 F3 E7 33 1C 93 E7 63 46 01 36 9E 42 00 D8 6A E7 00 99 08 1C 58 44 6F E7 33 1C EE E7 65 1E F6 E6 D4 FB FF FF 2C 04 00 00 }
	condition:
		$1
}

rule file_354_2_0 {
	meta:
		name = "memmem"
		size = 496
		refs = "0034 memchr 006a memcmp"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 88 B0 05 1C 0E 1C 17 1C 1C 1C 00 2B 06 D1 08 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD B3 42 0F D8 1F 2B 0F D8 11 78 32 1C ?? ?? ?? ?? 80 46 00 28 62 D0 01 2C 60 D0 2D 1A AD 19 00 95 AC 42 04 D9 00 20 E4 E7 FF F7 A0 FE E1 E7 21 1C 07 AA 38 1C FF F7 36 FE 07 99 06 1C 79 18 38 1C 32 1C ?? ?? ?? ?? 00 28 57 D0 A3 1B B3 42 00 D2 33 1C 01 33 03 93 07 93 01 23 9B 1B 00 20 04 93 B3 1E 84 46 F8 18 B9 19 72 1E 01 93 02 90 33 1C BA 46 66 46 8B 46 17 1C 9C 46 64 45 13 D9 63 46 F2 18 42 44 58 46 01 78 13 78 99 42 30 D1 59 46 63 46 05 E0 4D 78 50 78 01 31 01 32 85 42 28 D1 01 33 9C 42 F6 D8 3B 1C 7A 1C 00 D1 87 E0 B1 46 C1 44 52 46 48 46 D1 5D C2 5D 91 42 10 D1 01 98 32 18 02 99 42 44 05 E0 0D 78 10 78 01 39 01 3A 85 42 05 D1 01 3B F7 D2 48 46 8A E7 40 46 88 E7 03 99 76 18 00 99 0B 1B B3 42 C6 D2 00 20 80 E7 63 46 04 99 8E 19 F6 18 F4 E7 07 99 00 23 70 1E 62 1A 99 46 B3 1E 83 46 03 92 F8 18 42 46 02 93 01 23 9B 1B 5A 44 01 91 04 92 05 90 06 93 B4 46 BA 46 4E 46 27 1C 33 1C 66 45 00 D2 63 46 9F 42 12 D9 52 46 4C 46 D1 18 1A 19 42 44 0C 78 10 78 84 42 06 D0 2F E0 4C 78 50 78 01 31 01 32 84 42 29 D1 01 33 9F 42 F6 D8 B4 45 2B D9 52 46 04 9C 5A 44 48 46 11 78 22 5C 5B 46 91 42 22 D1 02 9C 22 1C 4A 44 05 99 42 44 07 E0 0C 78 10 78 5D 1E 01 39 01 3A 84 42 02 D1 2B 1C 9E 42 F5 D3 01 36 9E 42 11 D8 01 9A 03 9E 91 44 00 9C E3 1B 4B 45 C1 D2 00 20 25 E7 06 98 02 1C 4A 44 D2 18 91 46 00 26 F2 E7 63 46 EA E7 40 46 48 44 19 E7 B4 46 C1 46 E1 44 48 46 14 E7 }
	condition:
		$1
}

rule file_358_0_0 {
	meta:
		name = "tfind"
		size = 66
	strings:
		$1 = { 70 B5 05 1C 16 1C 0C 1E 03 D1 00 20 70 BD 24 68 04 34 23 68 00 2B F8 D0 19 68 28 1C 00 F0 11 F8 00 28 0C D0 00 28 F2 DB 24 68 08 34 23 68 00 2B EB D0 19 68 28 1C 00 F0 04 F8 00 28 F2 D1 20 68 E4 E7 }
	condition:
		$1
}

rule file_360_0_0 {
	meta:
		name = "_viscanf_r"
		size = 16
		refs = "000a __svfiscanf_r"
	strings:
		$1 = { 10 B5 0C 1C 13 1C 41 68 22 1C ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_417_0_0 {
	meta:
		name = "_vscanf_r"
		size = 16
		refs = "000a __svfscanf_r"
	strings:
		$1 = { 10 B5 0C 1C 13 1C 41 68 22 1C ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_360_1_0 {
	meta:
		name = "viscanf"
		size = 24
		refs = "000c __svfiscanf_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0B 1C 03 49 02 1C 08 68 41 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_417_1_0 {
	meta:
		name = "vscanf"
		size = 24
		refs = "000c __svfscanf_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 0B 1C 03 49 02 1C 08 68 41 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_362_0_0 {
	meta:
		name = "_fwide_r"
		size = 92
		refs = "0048 __sinit"
	strings:
		$1 = { 30 B5 0C 1C 15 1C 00 28 02 D0 83 6B 00 2B 1B D0 00 2D 04 D1 A2 89 93 04 06 D4 00 20 30 BD 80 23 A2 89 9B 01 1A 42 07 D0 63 6E 9A 04 01 D5 01 20 F4 E7 01 20 40 42 F1 E7 1A 43 A2 81 00 2D 06 DD 61 6E 0B 43 63 66 E6 E7 ?? ?? ?? ?? E0 E7 61 6E 01 4B 0B 40 63 66 DE E7 FF DF FF FF }
	condition:
		$1
}

rule file_363_0_0 {
	meta:
		name = "trecurse"
		size = 42
		refs = "0024 free"
	strings:
		$1 = { 30 B5 04 1C 40 68 0D 1C 00 28 01 D0 FF F7 F8 FF A0 68 00 28 02 D0 29 1C FF F7 F2 FF 20 68 00 F0 0B F8 20 1C ?? ?? ?? ?? 30 BD }
	condition:
		$1
}

rule file_364_0_0 {
	meta:
		name = "fetch_bitmap"
		size = 82
		refs = "001a malloc 003c __get_page 004a free"
	strings:
		$1 = { 70 B5 DC 23 5B 00 C3 58 0D 1C 82 B0 04 1C AB 42 02 DC 00 20 02 B0 70 BD C0 68 ?? ?? ?? ?? 2E 1C 4E 36 B6 00 01 1C 30 51 00 28 F2 D0 62 35 01 23 6D 00 00 93 01 93 2A 5B 20 1C 00 23 ?? ?? ?? ?? 00 28 01 D1 30 59 E5 E7 30 59 ?? ?? ?? ?? 00 20 E0 E7 }
	condition:
		$1
}

rule file_364_1_0 {
	meta:
		name = "putpair"
		size = 88
		refs = "001e memmove"
	strings:
		$1 = { F0 B5 07 88 BB 1C 5B 00 16 1C 1D 5A 4A 68 AD 1A 2D 04 2D 0C 01 37 04 1C 09 68 40 19 3F 04 ?? ?? ?? ?? 3F 0C 72 68 7B 00 1D 53 AD 1A 2D 04 01 37 2D 0C 3F 04 3F 0C 60 19 31 68 ?? ?? ?? ?? 7B 00 FA 1C 1D 53 52 00 27 80 7B 1C 02 37 AA 1A 7F 00 5B 00 1A 53 3D 53 F0 BD }
	condition:
		$1
}

rule file_364_2_0 {
	meta:
		name = "__ibitmap"
		size = 130
		refs = "0014 malloc 0038 memset"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 05 1C C0 68 89 46 17 1C 98 46 ?? ?? ?? ?? 04 1C 00 28 2F D0 DC 23 5B 00 EA 58 01 32 EA 50 7B 1E 5B 11 1E 1C 01 36 B6 00 00 21 32 1C 9A 46 ?? ?? ?? ?? EA 68 A0 19 92 1B FF 21 ?? ?? ?? ?? 53 46 9A 00 1F 23 1F 40 01 23 5B 42 BB 40 13 51 22 68 01 23 13 43 23 60 43 46 62 33 5B 00 4A 46 5A 53 43 46 4E 33 9B 00 5C 51 00 20 1C BC 90 46 99 46 A2 46 F0 BD 01 20 F8 E7 }
	condition:
		$1
}

rule file_364_3_0 {
	meta:
		name = "__put_page"
		size = 400
		refs = "00a6 lseek 0108 __log2 011e sigprocmask 0128 mkstemp 0134 unlink 0164 write 0176 __errno"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 8A 25 6D 00 17 1C 46 59 C2 68 86 B0 04 1C 8A 46 98 46 01 92 73 1C 00 D1 76 E0 A2 68 56 4B 9A 42 25 D0 0F 9B 00 2B 4C D0 E0 68 80 10 00 28 1E DD 04 AA 93 46 13 23 12 22 6B 44 6A 44 6D 46 00 94 99 46 94 46 11 35 53 46 00 22 19 68 04 91 4C 46 21 78 19 70 64 46 21 78 59 70 29 78 99 70 5C 46 21 78 01 32 D9 70 04 33 82 42 EE D1 00 9C 43 46 00 2B 1F D1 FB 0A 01 25 E2 6B 9D 40 90 46 01 2D 3B D1 00 23 41 46 01 39 4D 19 3C 49 ED 18 0F 40 E9 19 23 69 30 1C 99 40 00 22 ?? ?? ?? ?? 01 30 57 D1 01 20 40 42 06 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD E5 6B 00 2F 44 D1 00 21 7F 19 79 18 E7 E7 52 46 13 88 02 33 9C 46 20 1C 69 46 6D 46 64 46 16 31 17 35 53 46 00 22 84 46 18 88 08 80 28 78 18 70 08 78 01 32 58 70 02 33 94 42 F5 DA 43 46 64 46 00 2B BD D0 DC E7 28 1C ?? ?? ?? ?? 10 30 80 00 03 59 BD E7 03 96 02 AE 03 A9 32 1C 01 20 ?? ?? ?? ?? 1A 4A 10 1C 91 46 ?? ?? ?? ?? 60 51 01 30 02 D0 48 46 ?? ?? ?? ?? 31 1C 00 20 00 22 ?? ?? ?? ?? 8A 23 5B 00 E6 58 73 1C 00 D0 6B E7 AE E7 78 1C ?? ?? ?? ?? 10 30 80 00 01 59 B4 E7 30 1C 51 46 01 9A ?? ?? ?? ?? 43 1C A0 D0 01 9C 84 42 01 D1 00 20 9D E7 ?? ?? ?? ?? 4F 23 03 60 01 20 40 42 96 E7 D2 04 00 00 FF 07 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_364_4_0 {
	meta:
		name = "__get_page"
		size = 372
		refs = "0042 lseek 008e __log2 00b2 read 0116 __errno"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 17 1C 8A 22 52 00 82 58 82 B0 90 46 0A 9A 05 1C 0C 1C C6 68 00 2A 16 D0 42 46 01 32 13 D0 00 2B 1D D0 C3 6B 9A 46 00 2F 33 D1 00 21 57 44 79 18 2B 69 40 46 99 40 00 22 ?? ?? ?? ?? 01 30 30 D1 01 20 40 42 05 E0 00 23 23 80 B3 1F 63 80 A6 80 00 20 02 B0 1C BC 90 46 99 46 A2 46 F0 BD FB 0A 01 22 9A 40 92 46 C2 6B 53 46 91 46 01 2B 08 D1 00 21 4B 46 01 3B 53 44 5B 18 39 49 0F 40 D9 19 D6 E7 50 46 ?? ?? ?? ?? 03 1C 10 33 9B 00 59 59 EF E7 78 1C ?? ?? ?? ?? 03 1C 10 33 9B 00 59 59 C4 E7 32 1C 40 46 21 1C ?? ?? ?? ?? 42 1C C7 D0 00 28 29 D1 20 80 0B 9B 00 2B 02 D1 23 88 00 2B 45 D0 AA 68 28 4B 9A 42 1C D0 0B 9B 00 2B 24 D0 E9 68 89 10 00 29 15 DD 6E 46 6D 46 68 46 6F 46 03 36 02 35 01 30 00 23 22 68 00 92 32 78 22 70 2A 78 62 70 02 78 A2 70 3A 78 01 33 E2 70 04 34 8B 42 F1 D1 00 20 A4 E7 86 42 D4 D0 ?? ?? ?? ?? 4F 23 03 60 01 20 40 42 9B E7 23 88 6A 46 06 32 13 80 53 78 23 70 13 78 63 70 25 88 68 46 02 35 07 30 02 34 01 23 21 88 11 80 01 78 21 70 11 78 01 33 61 70 02 34 9D 42 F5 DA 00 20 81 E7 2C 23 6A 46 9A 5A EB 68 22 80 9A 1F 62 80 A3 80 00 20 77 E7 FF 07 00 00 D2 04 00 00 }
	condition:
		$1
}

rule file_364_5_0 {
	meta:
		name = "__free_ovflpage"
		size = 120
		refs = "0066 __reclaim_buf"
	strings:
		$1 = { 70 B5 CA 68 12 04 16 0C D2 0E 04 1C 0D 1C 00 2A 02 D0 10 32 92 00 12 58 16 4B 33 40 01 3B 9B 18 62 6A 93 42 00 DA 63 62 21 69 E6 68 03 31 1A 1C F6 00 0A 41 01 3E 1E 40 13 1C 4E 33 9B 00 18 59 11 1C 00 28 12 D0 F3 17 DB 0E 9E 19 72 11 92 00 80 18 1F 22 16 40 F3 1A 01 26 9E 40 03 68 B3 43 03 60 29 1C 20 1C ?? ?? ?? ?? 70 BD 20 1C FF F7 9D FF E8 E7 FF 07 00 00 }
	condition:
		$1
}

rule file_364_6_0 {
	meta:
		name = "__add_ovflpage"
		size = 732
		refs = "0202 __get_buf 0286 __ibitmap 02c6 write"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 04 1C 80 23 08 69 62 6B 84 B0 5B 02 8A 46 03 90 9A 42 00 D1 D7 E0 51 46 0A 7D 01 23 13 43 0B 75 25 6A 11 22 52 19 93 00 E0 68 19 59 C0 00 23 69 93 46 01 38 4A 1E 03 33 17 1C 10 40 62 6A 1F 41 1A 41 B9 46 02 90 90 46 91 45 00 DA F7 E0 17 1C 4E 37 BF 00 E7 19 16 1C 39 68 8C 46 00 29 00 D1 BA E0 B1 45 00 D1 A9 E0 E0 68 C0 00 01 38 B0 45 00 D1 96 E0 00 22 00 92 00 23 98 42 13 DB 00 9A 61 46 92 00 51 58 01 91 01 31 43 D1 00 99 01 31 89 00 61 44 01 97 02 E0 04 C9 57 1C 3B D1 20 33 83 42 F9 DD 01 9F 01 36 04 37 B1 45 D4 DA 58 46 83 00 19 59 61 62 59 46 8A 00 13 59 01 33 13 51 00 2D 00 D0 CC E0 00 27 7E 4A DF 1B 97 42 00 DD B8 E0 2E 1C E3 68 02 98 DB 00 01 3B 98 42 00 D1 C3 E0 02 99 01 31 CA 17 D2 0E 51 18 1F 20 4B 11 01 40 8A 1A 9B 00 01 21 63 44 91 40 0A 1C 19 68 0A 43 1A 60 3F 04 3F 0C 33 1C DD 02 7D 19 2D 04 2D 0C 3C E0 01 9A 00 21 01 20 03 E0 01 31 20 29 02 D0 40 00 10 42 F9 D1 C9 18 CA 17 D2 0E 50 18 1F 27 43 11 38 40 82 1A 9B 00 01 20 63 44 90 40 02 1C 18 68 02 43 1A 60 E3 68 DB 00 73 43 62 6A 01 33 5B 18 93 42 33 DA 00 2D 46 DD 62 6C 9A 42 43 DA 27 1C 48 37 00 20 03 E0 02 CF 8B 42 03 DD 10 1C 42 1C 95 42 F8 DC 11 30 80 00 01 59 5B 1A 51 49 8B 42 05 DC D5 02 ED 18 2D 04 2D 0C 00 2D 2D D1 00 20 04 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD E2 68 63 6A D2 00 01 3A 13 40 D9 17 C9 0E C9 18 49 11 00 91 1F 21 8B 43 5E E7 02 98 56 E7 5A 1E 62 62 C8 E7 03 88 5B 08 63 63 03 2B 00 DD 21 E7 04 23 63 63 1E E7 20 1C 31 1C FF F7 A4 FE 84 46 00 28 00 D0 3C E7 D3 E7 00 22 C8 E7 29 1C 20 1C 52 46 01 23 ?? ?? ?? ?? 51 46 88 60 00 28 C7 D0 02 7D 01 23 13 43 03 75 03 9A 13 88 03 9C 9A 1C 51 00 61 18 0E 88 03 9F 1C 1D 64 00 E6 53 3E 88 01 36 76 00 F6 5B DC 1C 01 33 5B 00 64 00 04 3E E6 53 DD 53 00 23 0B 80 3A 80 AA E7 00 20 84 46 37 E7 6E 1C 1F 2E 34 DC 12 35 AD 00 2B 51 5A 46 93 00 1A 59 01 3A 26 62 1A 51 01 27 39 E7 2A 1C 10 32 92 00 17 59 2E E7 4B 46 01 33 1F 2B 20 DC F1 02 C9 19 20 1C 01 22 ?? ?? ?? ?? 00 28 00 D0 86 E7 32 1C 11 32 92 00 11 59 80 23 01 31 01 37 1B 01 11 51 9F 42 00 D0 33 E7 73 1C 1F 2B 08 DC 12 36 B6 00 31 51 11 59 01 39 23 62 11 51 00 27 2A E7 02 20 05 49 31 22 ?? ?? ?? ?? 00 20 68 E7 C0 46 FF 07 00 00 FE 07 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_364_7_0 {
	meta:
		name = "__addel"
		size = 418
		refs = "004a __get_buf 00b0 __divsi3 00be __expand_table 00f2 memmove 0146 __big_insert 0162 __add_ovflpage"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 82 B0 83 46 0D 1C 17 1C 1E 1C 0C 69 1E E0 59 00 62 5A 88 46 03 2A 00 D9 98 E0 5A 1C 52 00 12 19 11 88 92 46 89 46 7A 68 71 68 51 18 04 31 89 45 48 D8 01 3B 5B 00 E1 5A 2A 1C 58 46 00 23 ?? ?? ?? ?? 05 1C 00 28 00 D1 7B E0 04 69 23 88 00 2B 0D D0 A2 88 03 2A DA D8 03 2A 02 D1 02 2B 00 D1 77 E0 58 00 22 5A 80 46 00 2A D6 D0 E1 E7 A3 88 03 2B 00 D8 6D E0 02 23 79 68 72 68 E3 5A 8A 18 08 32 9A 42 65 D8 20 1C 39 1C 32 1C FF F7 86 FF 2A 7D 01 23 13 43 2B 75 5A 46 90 6B 91 6A 01 30 01 31 90 63 ?? ?? ?? ?? 59 46 4B 6B 98 42 4B DD 58 46 ?? ?? ?? ?? 02 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 98 1C 41 00 61 18 0D 88 01 3B 5B 00 E3 18 AD 1A 00 91 2D 04 19 88 2D 0C 1D 80 83 46 01 91 60 19 39 68 ?? ?? ?? ?? 72 68 AD 1A 2D 04 2D 0C 43 46 E5 52 31 68 60 19 ?? ?? ?? ?? 69 46 58 46 0A 1D 20 80 12 88 00 98 51 46 00 23 0A 80 03 80 71 68 7A 68 23 88 49 42 8A 1A 01 33 04 3A 5B 00 4A 44 E2 52 23 88 02 33 5B 00 E5 52 00 20 C1 E7 58 46 21 1C 3A 1C 33 1C ?? ?? ?? ?? 00 28 20 D0 01 20 40 42 B6 E7 00 20 B4 E7 01 33 5B 00 92 E7 58 46 29 1C ?? ?? ?? ?? 04 1C 00 28 F0 D0 00 69 83 88 03 2B E4 D9 73 68 7A 68 D2 18 03 88 01 33 5B 00 1B 5A 08 32 9A 42 DA D8 39 1C 32 1C FF F7 0C FF 22 7D 01 23 13 43 23 75 5A 46 93 6B 01 33 93 63 8C E7 }
	condition:
		$1
}

rule file_364_8_0 {
	meta:
		name = "__split_page"
		size = 944
		refs = "001a __get_buf 00d2 __call_hash 0114 memmove 0290 __add_ovflpage 02de __free_ovflpage 0364 __big_split"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 97 B0 14 1C 00 23 00 22 81 46 8B 46 C5 68 ?? ?? ?? ?? 04 90 00 28 08 D1 01 20 40 42 17 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 48 46 21 1C 00 22 00 23 ?? ?? ?? ?? 08 90 00 28 ED D0 2D 04 2D 0C 05 95 04 98 02 7D 09 23 1A 43 02 75 08 99 0A 7D 13 43 0B 75 04 69 0A 69 23 88 06 92 1A 1C 01 2B 66 DD A3 88 21 1D 03 2B 00 D8 8F E1 05 9F 26 1C 01 23 00 22 B8 46 08 36 03 93 01 25 07 92 0F 1C 17 E0 05 98 41 46 43 1A 1B 04 1B 0C 00 2B 32 D1 3F 88 05 97 3B 1C 03 9A 02 32 03 92 98 46 23 88 02 35 AB 42 46 DD 32 88 37 1C 2B 1C 04 36 03 2A 5F D9 5B 00 1B 19 1A 88 9A 46 43 46 A1 18 48 46 9A 1A 15 91 16 92 ?? ?? ?? ?? 58 45 D9 D0 3B 88 50 46 E2 18 13 92 02 88 15 A9 D3 1A 06 98 13 AA 14 93 FF F7 89 FE 07 9B 02 33 1B 04 3F 88 1B 0C 07 93 B8 46 D3 E7 3A 88 D3 18 1B 04 1B 0C 05 93 E0 18 43 46 A1 18 9A 1A ?? ?? ?? ?? 03 98 3A 88 05 99 43 00 50 46 8A 1A 01 88 52 18 1A 53 03 9B 69 46 14 22 01 33 51 5A 5B 00 19 53 3B 88 B2 E7 00 20 07 90 07 99 5B 1A 1B 04 1B 0C 23 80 05 98 5A 1C 03 33 5B 00 C3 1A 52 00 13 53 23 88 14 22 69 46 51 5A 02 33 5B 00 19 53 04 9B 1A 7D 04 98 08 23 9A 43 02 75 08 99 0A 7D 9A 43 0A 75 00 20 54 E7 04 98 08 99 04 69 09 69 22 88 06 91 04 98 55 1E 08 9B 00 21 06 9F 2D 04 03 90 06 94 09 90 0A 91 2D 0C 9A 46 95 42 00 D3 95 E0 A3 88 01 3B 1B 04 1B 0C 02 2B 00 D8 CB E0 6B 1C 5B 00 1B 5B 00 2B 00 D1 91 E0 4B 46 9B 89 98 46 01 2A 00 D8 80 E0 A6 88 03 2E 00 D8 7C E0 06 98 42 46 01 21 01 25 80 46 24 E0 BB 88 03 2B 51 D9 10 9B 12 9A D2 18 3B 88 01 33 5B 00 DB 5B 08 32 9A 42 47 D8 38 1C 0F AA 11 A9 FF F7 FF FD 52 46 13 7D 01 20 03 43 13 75 02 35 2D 04 22 88 2D 0C AA 42 34 D9 6B 1C 5B 00 1B 5B 29 1C 03 2B 44 D9 32 1C 1E 1C 49 00 0B 5B A0 19 E1 18 D2 1A 0F 90 9B 1B 48 46 11 91 12 92 10 93 ?? ?? ?? ?? 83 45 CB D1 41 46 8B 88 03 2B 25 D9 10 9B 12 9A D2 18 0B 88 01 33 5B 00 5B 5A 08 32 9A 42 1B D8 40 46 11 A9 0F AA FF F7 CA FD 03 98 03 7D 01 21 0B 43 03 75 02 35 2D 04 22 88 2D 0C AA 42 CA D8 41 46 06 91 8A E7 51 46 48 46 ?? ?? ?? ?? 82 46 00 28 0E D0 07 69 AE E7 48 46 03 99 ?? ?? ?? ?? 03 90 00 28 05 D0 02 69 90 46 D9 E7 40 46 06 90 74 E7 01 20 40 42 04 99 0A 7D 08 23 9A 43 0A 75 08 99 0A 7D 9A 43 0A 75 AB E6 01 25 66 E7 0A 98 00 28 61 D0 48 46 0A 99 ?? ?? ?? ?? 00 20 EA E7 07 98 93 1E 1B 1A 1B 04 1B 0C 6D 00 29 5B 05 98 23 80 5A 1C 03 33 5B 00 C3 1A 52 00 13 53 23 88 14 20 6A 46 82 5A 02 33 5B 00 1A 53 48 46 09 9A 00 23 ?? ?? ?? ?? 09 90 00 28 CA D0 4B 46 04 69 9B 89 0A 98 98 46 00 28 38 D0 48 46 0A 99 ?? ?? ?? ?? 48 46 43 46 80 89 09 99 05 93 00 23 22 88 80 46 0A 91 07 93 3C E7 09 9A D3 68 0B A8 00 93 5B 46 01 93 02 90 03 99 48 46 52 46 09 9B ?? ?? ?? ?? 00 28 A5 D1 0C 99 03 91 00 29 A1 D0 0B 9A 0B 69 92 46 00 2A 9C D0 0D 98 17 69 09 90 00 28 0A D0 49 46 04 69 89 89 06 93 22 88 88 46 0A 90 17 E7 00 23 07 93 F5 E6 00 20 8C E7 09 98 00 21 22 88 05 93 0A 90 07 91 0B E7 }
	condition:
		$1
}

rule file_364_9_0 {
	meta:
		name = "__delpair"
		size = 272
		refs = "0050 memmove 010a __big_delete"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 13 1C 0C 69 01 33 5B 00 1B 19 9B 46 1B 88 81 B0 00 90 8A 46 90 46 25 88 03 2B 00 D8 6F E0 01 2A 00 D1 69 E0 01 3A 52 00 16 5B F6 1A 6F 1E 36 04 B9 46 36 0C C1 45 3C D0 AA 1C 52 00 A2 5A A1 18 88 19 9A 1A ?? ?? ?? ?? 42 46 02 32 95 42 2E DB 51 00 09 19 43 46 03 33 8C 46 41 46 48 00 5B 00 E3 18 20 18 59 46 0C E0 67 46 3F 88 07 80 1F 88 02 32 0F 80 04 27 04 33 BC 44 04 30 04 31 95 42 15 DB 1F 88 00 2F EF D0 67 46 3F 88 B8 46 B0 44 47 46 07 80 1F 88 B8 46 B0 44 47 46 0F 80 02 32 04 27 04 33 BC 44 04 30 04 31 95 42 E9 DA 22 88 00 E0 2A 1C 02 32 52 00 A2 5A 6B 00 B2 18 E2 52 6A 1C 52 00 A2 5A 04 32 B6 18 49 46 00 9A 4B 00 E6 52 93 6B 02 3D 01 3B 93 63 25 80 53 46 1A 7D 01 23 13 43 57 46 3B 75 00 20 01 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 9A 96 89 95 E7 ?? ?? ?? ?? F2 E7 }
	condition:
		$1
}

rule file_365_0_0 {
	meta:
		name = "_wctrans_r"
		size = 56
		refs = "000a strcmp"
	strings:
		$1 = { 30 B5 05 1C 0C 1C 08 1C 09 49 ?? ?? ?? ?? 00 28 01 D1 01 20 30 BD 20 1C 06 49 ?? ?? ?? ?? 00 28 03 D0 16 23 2B 60 00 20 F4 E7 02 20 F2 E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_367_0_0 {
	meta:
		name = "wmemset"
		size = 20
	strings:
		$1 = { 10 B5 00 2A 05 D0 04 1C 00 23 01 33 02 C4 9A 42 FB D8 10 BD }
	condition:
		$1
}

rule file_369_0_0 {
	meta:
		name = "frexpf"
		size = 100
		refs = "0038 __mulsf3"
	strings:
		$1 = { 30 B5 00 22 12 4C 0A 60 02 1C 0D 1C 03 1C 22 40 02 D0 10 49 8A 42 00 DD 30 BD 0F 49 8A 42 0A DD 7E 21 49 42 D2 15 0D 48 51 18 FC 22 18 40 92 05 29 60 10 43 F0 E7 0A 49 ?? ?? ?? ?? 19 21 49 42 02 1C 29 60 97 21 03 1C 22 40 49 42 EA E7 C0 46 FF FF FF 7F FF FF 7F 7F FF FF 7F 00 FF FF 7F 80 00 00 00 4C }
	condition:
		$1
}

rule file_372_0_0 {
	meta:
		name = "iswpunct"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { FF 28 06 D8 04 4B 1B 68 18 18 40 78 10 23 18 40 70 47 00 20 FC E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "iswcntrl"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { FF 28 06 D8 04 4B 1B 68 18 18 40 78 20 23 18 40 70 47 00 20 FC E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_0_0 {
	meta:
		name = "_towctrans_r"
		size = 32
		refs = "0014 towlower 001a towupper"
	strings:
		$1 = { 00 B5 03 1C 08 1C 01 2A 04 D0 02 2A 05 D0 16 22 1A 60 00 BD ?? ?? ?? ?? FB E7 ?? ?? ?? ?? F8 E7 }
	condition:
		$1
}

rule file_375_0_0 {
	meta:
		name = "asniprintf"
		size = 120
		refs = "004c _svfiprintf_r 0074 _impure_ptr"
	strings:
		$1 = { 0C B4 30 B5 1B 4A 0B 68 9B B0 0D 1C 12 68 00 2B 0B D0 00 28 09 D0 00 2B 24 DA 8B 23 13 60 00 20 1B B0 30 BC 08 BC 02 B0 18 47 A2 23 9B 00 6C 46 A3 81 00 23 00 93 04 93 A3 60 63 61 01 23 5B 42 E3 81 10 1C 1F AB 69 46 1E 9A 1A 93 ?? ?? ?? ?? 00 28 05 DB 00 9B 00 22 28 60 1A 70 20 69 DF E7 00 20 DD E7 C1 21 6C 46 C9 00 A1 81 00 90 04 90 E2 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_458_0_0 {
	meta:
		name = "asnprintf"
		size = 120
		refs = "004c _svfprintf_r 0074 _impure_ptr"
	strings:
		$1 = { 0C B4 30 B5 1B 4A 0B 68 9B B0 0D 1C 12 68 00 2B 0B D0 00 28 09 D0 00 2B 24 DA 8B 23 13 60 00 20 1B B0 30 BC 08 BC 02 B0 18 47 A2 23 9B 00 6C 46 A3 81 00 23 00 93 04 93 A3 60 63 61 01 23 5B 42 E3 81 10 1C 1F AB 69 46 1E 9A 1A 93 ?? ?? ?? ?? 00 28 05 DB 00 9B 00 22 28 60 1A 70 20 69 DF E7 00 20 DD E7 C1 21 6C 46 C9 00 A1 81 00 90 04 90 E2 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_375_1_0 {
	meta:
		name = "_asniprintf_r"
		size = 108
		refs = "0046 _svfiprintf_r"
	strings:
		$1 = { 08 B4 30 B5 13 68 9B B0 15 1C 00 2B 0B D0 00 29 09 D0 00 2B 23 DA 8B 23 03 60 00 20 1B B0 30 BC 08 BC 01 B0 18 47 A2 23 9B 00 6C 46 A3 81 00 23 00 93 04 93 A3 60 63 61 01 23 5B 42 E3 81 69 46 1F AB 1E 9A 1A 93 ?? ?? ?? ?? 00 28 05 DB 00 9B 00 22 28 60 1A 70 20 69 E0 E7 00 20 DE E7 C1 22 6C 46 D2 00 A2 81 00 91 04 91 E3 E7 }
	condition:
		$1
}

rule file_458_1_0 {
	meta:
		name = "_asnprintf_r"
		size = 108
		refs = "0046 _svfprintf_r"
	strings:
		$1 = { 08 B4 30 B5 13 68 9B B0 15 1C 00 2B 0B D0 00 29 09 D0 00 2B 23 DA 8B 23 03 60 00 20 1B B0 30 BC 08 BC 01 B0 18 47 A2 23 9B 00 6C 46 A3 81 00 23 00 93 04 93 A3 60 63 61 01 23 5B 42 E3 81 69 46 1F AB 1E 9A 1A 93 ?? ?? ?? ?? 00 28 05 DB 00 9B 00 22 28 60 1A 70 20 69 E0 E7 00 20 DE E7 C1 22 6C 46 D2 00 A2 81 00 91 04 91 E3 E7 }
	condition:
		$1
}

rule file_376_0_0 {
	meta:
		name = "getw"
		size = 32
		refs = "000c fread"
	strings:
		$1 = { 00 B5 81 B0 03 1C 04 21 68 46 01 22 ?? ?? ?? ?? 01 28 03 D0 01 20 40 42 01 B0 00 BD 00 98 FB E7 }
	condition:
		$1
}

rule file_377_0_0 {
	meta:
		name = "_strtoll_r"
		size = 492
		refs = "006c __umoddi3 007a __udivdi3 00ba __muldi3 01d8 __ctype_ptr__"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 98 46 72 4B 8C B0 0B 90 08 91 1E 68 0A 92 0C 1C 08 22 25 78 73 19 5B 78 01 34 13 42 F9 D1 2D 2D 00 D1 A7 E0 2B 2D 00 D1 B2 E0 00 21 09 91 40 46 43 42 43 41 10 28 00 D1 72 E0 00 2B 00 D0 6F E0 41 46 06 91 C9 17 07 91 09 9A 00 2A 00 D0 78 E0 5F 48 60 49 03 90 04 91 03 98 04 99 06 9A 07 9B ?? ?? ?? ?? 06 9A 07 9B 05 90 03 98 04 99 ?? ?? ?? ?? 04 22 92 46 03 22 91 46 01 22 03 90 0F 1C 00 23 00 20 00 21 93 46 00 96 1E E0 30 3D A8 45 2B DD 8F 42 5D D3 8F 42 58 D0 00 2B 59 DB 05 9B 9D 42 02 DD 03 9E 86 42 59 D0 06 9A 07 9B ?? ?? ?? ?? 01 95 ED 17 02 95 0B 1C 02 1C 01 98 02 99 80 18 59 41 01 23 25 78 01 34 00 9E 72 19 52 78 56 46 32 42 DA D1 4E 46 32 42 06 D0 5E 46 32 42 3A D1 57 22 AD 1A A8 45 D3 DC 5A 1C 47 D0 09 9A 00 2A 39 D1 0D 1C 2A 1C 01 1C 0A 9E 00 2E 06 D0 00 2B 01 D0 01 3C 08 94 08 98 0A 9B 18 60 0C B0 08 1C 11 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 30 2D 3A D0 00 2B 00 D1 8A E7 30 2D 46 D0 0A 22 00 23 06 92 07 93 09 9A 0A 23 98 46 00 2A 00 D1 86 E7 25 49 25 4A 03 91 04 92 85 E7 03 9A 82 42 A3 D2 01 23 5B 42 B6 E7 37 22 AD 1A C3 E7 8F 42 A3 D1 01 23 5B 42 AE E7 05 1C 0E 1C 00 22 69 42 B2 41 C2 E7 01 20 25 78 01 34 09 90 57 E7 09 9D 00 2D 18 D1 12 49 13 4A 0B 9E 22 20 30 60 B4 E7 00 22 25 78 01 34 09 92 49 E7 22 78 58 2A 01 D0 78 2A BF D1 10 21 00 22 65 78 06 91 07 92 10 22 02 34 90 46 48 E7 08 49 08 4A E5 E7 08 20 00 21 06 90 07 91 08 21 88 46 3E E7 C0 46 ?? ?? ?? ?? FF FF FF FF FF FF FF 7F 00 00 00 00 00 00 00 80 }
	condition:
		$1
}

rule file_378_0_0 {
	meta:
		name = "getenv"
		size = 24
		refs = "000c _findenv_r 0014 _impure_ptr"
	strings:
		$1 = { 00 B5 04 4B 81 B0 01 1C 6A 46 18 68 ?? ?? ?? ?? 01 B0 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_380_0_0 {
	meta:
		name = "strtok"
		size = 20
		refs = "000a __strtok_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 1A 68 01 23 5C 32 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_383_0_0 {
	meta:
		name = "_ungetwc_r"
		size = 110
		refs = "0030 _wcrtomb_r 004a _ungetc_r"
	strings:
		$1 = { F0 B5 47 46 80 B4 15 1C 80 23 92 89 9B 01 81 B0 80 46 0F 1C 1A 42 04 D1 1A 43 AA 81 6A 6E 13 43 6B 66 7B 1C 18 D0 2B 1C 5C 33 40 46 69 46 3A 1C ?? ?? ?? ?? 6E 46 04 1C 43 1C 12 D0 43 1E F6 18 00 2C 09 D0 31 78 40 46 2A 1C ?? ?? ?? ?? 01 3C 01 3E 43 1C F4 D1 07 1C 01 B0 38 1C 04 BC 90 46 F0 BD AA 89 40 23 13 43 AB 81 07 1C F4 E7 }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "critical_factorization"
		size = 312
		refs = "0134 __ctype_ptr__"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 49 4B 84 B0 01 25 03 92 00 26 1A 68 01 23 5C 42 9B 46 8C 46 AB 19 A9 46 02 94 63 45 1E D2 C4 5C 11 19 4F 78 49 46 0F 42 00 D0 20 34 24 06 24 0E 02 9F A0 46 44 19 E4 5D 11 19 4F 78 49 46 0F 42 00 D0 20 34 24 06 24 0E A0 45 4D D2 02 9C 1C 1B A3 46 01 25 1E 1C AB 19 63 45 E0 D3 02 99 63 46 03 9C 01 25 8C 46 19 1C 5B 46 23 60 00 26 6B 42 01 27 98 46 89 46 AB 19 02 97 AA 46 00 92 99 45 1F D9 C7 5C 00 9C E1 19 49 78 52 46 11 42 00 D0 20 37 41 46 44 19 00 9A 64 5C 11 19 49 78 3F 06 52 46 3F 0E 11 42 00 D0 20 34 24 06 24 0E A7 42 29 D9 44 46 1C 1B 02 94 01 25 1E 1C AB 19 99 45 DF D8 43 46 60 46 01 33 01 30 83 42 02 D3 02 9A 18 1C 93 46 03 9C 5B 46 04 B0 23 60 3C BC 90 46 99 46 A2 46 AB 46 F0 BD A0 45 06 D0 01 27 02 96 73 1C BB 46 01 25 1E 1C AD E7 5D 45 FA D0 33 1C 01 35 1E 1C A7 E7 A7 42 06 D0 01 21 02 91 73 1C B0 46 01 25 1E 1C D1 E7 02 9F BD 42 F9 D0 33 1C 01 35 1E 1C CA E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_384_1_0 {
	meta:
		name = "two_way_long_needle"
		size = 878
		refs = "0068 strncasecmp 00a2 memchr 0334 __ctype_ptr__"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 C7 4C A5 44 C7 4C 6C 44 02 92 80 46 8A 46 10 1C 19 1C 22 1C 1D 1C FF F7 51 FF 01 90 07 AB 20 C3 9C 42 FC D1 00 2D 12 D0 BF 4B 02 9F 1E 68 69 1E 00 23 01 24 FA 5C B0 18 40 78 20 42 00 D0 20 32 92 00 07 A8 01 33 81 50 01 39 9D 42 F2 D8 B5 4A 6A 44 11 68 02 9B 01 9A 59 18 18 1C ?? ?? ?? ?? 00 28 00 D0 CC E0 01 98 02 99 01 38 01 9A 43 46 01 24 09 18 A2 1A 00 26 04 90 05 91 00 93 03 95 06 92 6F 1E B0 46 52 46 03 9B 00 99 1D 1C 45 44 88 18 AA 1A 00 21 ?? ?? ?? ?? 00 28 00 D0 90 E0 00 2D 00 D1 8D E0 00 98 9F 49 43 19 01 3B 1A 78 0B 68 99 18 49 78 21 42 00 D0 20 32 92 00 07 A8 82 58 00 2A 00 D0 86 E0 01 99 30 1C 8E 42 00 D2 08 1C B8 42 28 D2 02 9A 41 46 12 18 92 46 42 18 00 99 89 18 B1 46 BC 46 1E 1C 53 46 AA 46 05 1C 08 1C 04 E0 01 35 01 33 01 30 65 45 4D D2 19 78 72 18 52 78 22 42 00 D0 20 31 02 78 B7 18 7F 78 27 42 00 D0 20 32 91 42 EC D0 28 1C 33 1C 55 46 4E 46 67 46 60 45 63 D3 01 9A 96 42 3C D2 05 99 04 98 8A 46 02 1C 00 99 42 44 89 18 01 9A 8C 46 93 46 19 1C 52 46 63 46 AA 46 B4 46 B9 46 0E 1C 15 1C 05 E0 01 3D 01 3B 84 45 2E D2 83 46 01 38 29 78 72 18 52 78 22 42 00 D0 20 31 1A 78 B7 18 7F 78 27 42 00 D0 20 32 91 42 EB D0 55 46 66 46 4F 46 58 46 01 36 86 42 12 D8 66 4A 6A 44 16 68 03 9B B0 44 2A 1C 9E 1B 76 E7 01 9A 33 1C 4E 46 55 46 67 46 96 42 C2 D3 10 1C 01 36 86 42 EC D9 00 9B C1 46 18 1C 48 44 04 E0 55 46 66 46 4F 46 E0 E7 00 20 84 23 DB 00 9D 44 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 2E 07 D0 52 49 69 44 0B 68 9A 42 02 D2 03 98 00 26 C2 1A 90 44 2A 1C 4B E7 06 99 0B 1C 43 44 1B 18 98 46 00 26 2A 1C 43 E7 01 9A AB 1A 93 42 00 D2 A9 E0 46 48 01 33 68 44 00 21 01 9A 89 46 03 60 01 99 02 9B 02 98 01 3A 9B 18 40 18 04 93 03 90 6E 1E 00 92 02 95 01 24 4D 46 47 46 52 46 89 46 02 9B 5B 19 B8 18 00 21 9A 1A 98 46 ?? ?? ?? ?? 00 28 BA D1 40 46 00 28 B7 D0 42 46 BB 18 34 48 01 3B 1A 78 03 68 99 18 49 78 21 42 00 D0 20 32 92 00 07 A9 8A 58 00 2A 6C D1 B1 45 28 D2 03 9A 48 46 92 46 2A 18 D2 19 94 46 32 1C 60 46 1E 1C BB 46 53 46 94 46 AA 46 4D 46 04 E0 01 35 01 33 01 30 65 45 46 D2 19 78 72 18 52 78 22 42 00 D0 20 31 02 78 B7 18 7F 78 27 42 00 D0 20 32 91 42 EC D0 28 1C 33 1C 55 46 5F 46 66 46 60 45 44 D3 00 99 8A 46 01 31 35 D0 04 9A 51 46 94 46 68 18 2A 1C B3 46 1D 1C 56 46 63 46 38 18 BA 46 94 46 03 E0 01 3B 01 38 01 3E 27 D3 19 78 6A 18 52 78 22 42 00 D0 20 31 02 78 AF 18 7F 78 27 42 00 D0 20 32 91 42 ED D0 05 49 69 44 0B 68 65 46 57 46 5E 46 ED 18 42 46 8B E7 E0 FB FF FF 1C 04 00 00 ?? ?? ?? ?? 00 99 33 1C 55 46 5F 46 66 46 8A 46 01 31 C9 D1 A9 46 B8 46 01 E0 E1 46 D0 46 40 46 48 44 3B E7 AD 18 42 46 72 E7 49 46 63 1A 5D 19 2D 18 42 46 6C E7 13 1C 53 E7 }
	condition:
		$1
}

rule file_384_2_0 {
	meta:
		name = "strcasestr"
		size = 788
		refs = "00b2 strncasecmp 00e8 memchr 0310 __ctype_ptr__"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 88 B0 00 91 02 78 07 1C 00 2A 00 D1 6E E1 0B 78 00 2B 22 D0 BB 49 00 9D 0E 68 01 24 01 1C B8 46 01 20 02 E0 2B 78 00 2B 1F D0 B7 18 7F 78 01 31 27 42 00 D0 20 32 F7 18 7F 78 01 35 27 42 00 D0 20 33 D3 1A 5A 42 53 41 0A 78 18 40 00 2A E9 D1 47 46 2B 78 00 2B 09 D0 00 27 08 B0 38 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 47 46 00 28 F4 D1 00 99 6D 1A 7A 1C 6B 1E 03 92 9A 46 1F 2D 07 D9 19 1C 03 98 00 9A 2B 1C FF F7 FC FD 07 1C E4 E7 08 1C 07 AA 29 1C FF F7 59 FD 00 9A 07 99 80 46 51 18 10 1C 42 46 ?? ?? ?? ?? 00 28 00 D0 92 E0 43 46 00 99 01 3B 42 46 C9 18 01 24 A2 1A 00 26 04 93 05 91 06 92 02 97 52 46 47 46 B0 46 03 99 43 46 5B 19 88 18 9A 1A 00 21 01 93 ?? ?? ?? ?? 00 28 B9 D1 01 9A 00 2A B6 D0 31 1C BE 42 00 D2 39 1C 8D 42 2A D9 83 4B 00 9A 1B 68 52 18 9A 46 94 46 43 46 02 9A C8 18 2B 1C B1 46 0D 1C 56 46 61 46 10 18 BA 46 9C 46 04 E0 01 35 01 31 01 30 AC 45 48 D9 0A 78 B3 18 5B 78 23 42 00 D0 20 32 43 78 F7 18 7F 78 27 42 00 D0 20 33 9A 42 EC D0 29 1C 65 46 57 46 4E 46 8D 42 3C D8 B7 42 00 D8 D1 E0 6C 4B 05 9A 1B 68 94 46 9A 46 02 9A 43 46 D8 19 A9 46 04 99 65 46 10 18 B4 46 BB 46 56 46 BA 46 05 E0 01 3D 01 38 8C 45 20 D2 8B 46 01 39 2A 78 B3 18 5B 78 23 42 00 D0 20 32 03 78 F7 18 7F 78 27 42 00 D0 20 33 9A 42 EB D0 57 46 66 46 4D 46 59 46 01 36 8E 42 00 D9 A6 E0 07 9E 01 9A B0 44 AE 1B 8B E7 57 46 4E 46 65 46 C6 E7 57 46 66 46 4D 46 EE E7 06 9A 13 1C 43 44 5B 18 98 46 00 26 01 9A 7B E7 41 46 6B 1A 43 45 00 D2 83 E0 01 33 07 93 00 9B 19 1C 41 44 02 91 43 46 00 99 00 22 01 3B 91 46 01 24 42 46 C9 18 A2 1A 01 93 00 91 04 92 4E 46 52 46 B9 46 03 9B 77 19 98 18 00 21 BA 1A ?? ?? ?? ?? 00 28 00 D0 1C E7 00 2F 00 D1 19 E7 45 45 27 D9 36 49 09 68 43 46 02 9A 8A 46 F0 18 2B 1C B3 46 48 44 56 46 45 46 BA 46 11 1C 9C 46 04 E0 01 35 01 31 01 30 AC 45 3D D9 0A 78 B3 18 5B 78 23 42 00 D0 20 32 43 78 F7 18 7F 78 27 42 00 D0 20 33 9A 42 EC D0 29 1C 65 46 57 46 5E 46 8D 42 32 D8 01 9A 94 46 01 32 38 D0 20 4B 1B 68 9A 46 43 46 F1 18 AB 46 00 98 65 46 49 44 BC 46 57 46 B2 46 03 E0 01 38 01 39 01 3D 18 D3 02 78 BB 18 5B 78 23 42 00 D0 20 32 0B 78 FE 18 76 78 26 42 00 D0 20 33 9A 42 ED D0 07 9B 67 46 56 46 5D 46 F6 18 3A 1C 9E E7 57 46 5E 46 65 46 D1 E7 D1 46 03 99 0F 1C 4F 44 BD E6 04 9A 96 19 76 18 3A 1C 90 E7 43 46 79 E7 00 9D 01 20 AF E6 B1 46 EF E7 39 1C 54 E7 03 9B 1F 1C 47 44 AB E6 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_385_0_0 {
	meta:
		name = "srand"
		size = 20
		refs = "0010 _impure_ptr"
	strings:
		$1 = { 03 4B 1B 68 00 22 A4 33 18 60 5A 60 70 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_385_1_0 {
	meta:
		name = "rand"
		size = 56
		refs = "0010 __muldi3 0028 _impure_ptr"
	strings:
		$1 = { 10 B5 09 4B 1C 68 A4 34 20 68 61 68 07 4A 08 4B ?? ?? ?? ?? 01 22 00 23 12 18 4B 41 05 48 22 60 63 60 18 40 10 BD C0 46 ?? ?? ?? ?? 2D 7F 95 4C 2D F4 51 58 FF FF FF 7F }
	condition:
		$1
}

rule file_386_0_0 {
	meta:
		name = "copysignf"
		size = 20
	strings:
		$1 = { 03 4A 80 23 1B 06 0B 40 10 40 18 43 70 47 C0 46 FF FF FF 7F }
	condition:
		$1
}

rule file_387_0_0 {
	meta:
		name = "mbsinit"
		size = 16
	strings:
		$1 = { 00 28 03 D0 00 68 43 42 58 41 70 47 01 20 FC E7 }
	condition:
		$1
}

rule file_389_0_0 {
	meta:
		name = "strlwr"
		size = 44
		refs = "0028 __ctype_ptr__"
	strings:
		$1 = { 30 B5 03 78 00 2B 0D D0 07 4D 02 1C 01 24 29 68 C9 18 49 78 21 42 01 D0 20 33 13 70 01 32 13 78 00 2B F4 D1 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_390_0_0 {
	meta:
		name = "_fwrite_r"
		size = 120
		refs = "004c __sfvwrite_r 005a __udivsi3 006c __sinit"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 92 46 57 46 5F 43 85 B0 98 46 03 AB 00 93 01 23 06 1C 0C 9D 03 91 04 97 6C 46 02 97 01 93 00 28 02 D0 83 6B 00 2B 1D D0 80 23 AA 89 9B 01 1A 42 05 D1 13 43 AB 81 6A 6E 0C 4B 13 40 6B 66 30 1C 29 1C 6A 46 ?? ?? ?? ?? 00 28 05 D0 A0 68 51 46 38 1A ?? ?? ?? ?? 80 46 05 B0 40 46 0C BC 90 46 9A 46 F0 BD ?? ?? ?? ?? DE E7 C0 46 FF DF FF FF }
	condition:
		$1
}

rule file_391_0_0 {
	meta:
		name = "__smakebuf_r"
		size = 224
		refs = "001c _fstat_r 004e _malloc_r 00a8 _isatty_r 00d8 _cleanup_r 00dc __sseek"
	strings:
		$1 = { F0 B5 8B 89 8F B0 05 1C 0C 1C 1A 1C 99 07 41 D4 E1 89 09 04 09 14 00 29 2C DB 6A 46 ?? ?? ?? ?? 00 28 25 DB F0 23 01 9A 1B 02 1A 40 29 4B D7 18 7B 42 5F 41 80 23 1B 02 9A 42 40 D0 A2 89 80 23 1B 01 13 43 80 26 A3 81 F6 00 28 1C 31 1C ?? ?? ?? ?? 00 28 18 D0 20 4B EB 63 A2 89 80 23 13 43 A3 81 20 60 20 61 66 61 00 2F 1A D1 0F B0 F0 BD A3 89 1A 1C 11 06 20 D4 80 26 F6 00 80 22 12 01 13 43 A3 81 00 27 E0 E7 A3 89 99 05 EE D4 02 22 13 43 A3 81 23 1C 43 33 23 60 23 61 01 23 63 61 E4 E7 0E 22 A1 5E 28 1C ?? ?? ?? ?? 00 28 DD D0 A2 89 01 23 13 43 A3 81 D8 E7 40 26 DE E7 A2 6A 06 4B 9A 42 BA D1 A3 89 80 26 F6 00 33 43 A3 81 E6 64 BA E7 00 E0 FF FF ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_392_1_0 {
	meta:
		name = "__messages_load_locale"
		size = 48
		refs = "001c __part_load_locale"
	strings:
		$1 = { 00 B5 08 49 08 4B 83 B0 CB 60 0B 61 04 23 00 93 02 23 01 93 0B 1D 02 93 4A 69 04 4B ?? ?? ?? ?? 03 B0 00 BD ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_395_0_0 {
	meta:
		name = "_freopen_r"
		size = 352
		refs = "0012 __sfp_lock_acquire 0028 __sflags 0060 _open_r 008e _free_r 00b6 memset 00d6 __sfp_lock_release 0116 __sinit 0120 _fflush_r 0134 _fclose_r 0150 __sread 0154 __swrite 0158 __sseek 015c __sclose"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 05 1C 81 B0 0E 1C 17 1C 1C 1C ?? ?? ?? ?? 00 2D 03 D0 AB 6B 00 2B 00 D1 78 E0 28 1C 39 1C 6A 46 ?? ?? ?? ?? 80 46 00 28 00 D1 7D E0 A3 89 00 2B 55 D0 1A 07 00 D5 6D E0 E3 6A 00 2E 54 D0 00 2B 03 D0 E1 69 28 1C 00 F0 95 F8 00 2E 4B D0 DB 23 31 1C 5B 00 28 1C 00 9A ?? ?? ?? ?? 2B 68 06 1C 9A 46 A3 89 1A 06 4C D4 21 6B 00 23 A3 60 63 60 23 60 23 61 63 61 A3 61 00 29 08 D0 23 1C 40 33 99 42 02 D0 28 1C ?? ?? ?? ?? 00 23 23 63 61 6C 00 27 67 63 00 29 03 D0 28 1C ?? ?? ?? ?? 67 64 00 27 20 1C A7 64 67 66 5C 30 00 21 08 22 ?? ?? ?? ?? 00 2E 40 DB 24 4B 23 62 24 4B 63 62 24 4B A3 62 24 4B 42 46 A2 81 E6 81 E4 61 E3 62 ?? ?? ?? ?? 01 B0 20 1C 0C BC 90 46 9A 46 F0 BD 20 23 A3 81 00 2E B3 D1 E3 6A 00 2B 18 D0 E1 69 28 1C 00 F0 40 F8 09 23 9A 46 A3 89 01 26 76 42 1A 06 B2 D5 21 69 28 1C ?? ?? ?? ?? AD E7 28 1C ?? ?? ?? ?? 82 E7 28 1C 21 1C ?? ?? ?? ?? 8C E7 09 22 01 26 92 46 76 42 9C E7 21 1C 28 1C ?? ?? ?? ?? 00 24 ?? ?? ?? ?? CC E7 53 46 A7 81 2B 60 ?? ?? ?? ?? 00 24 C5 E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_396_0_0 {
	meta:
		name = "wcslen"
		size = 26
	strings:
		$1 = { 03 68 00 2B 07 D0 03 1C 04 33 1A 68 00 2A FB D1 18 1A 80 10 70 47 00 20 FC E7 }
	condition:
		$1
}

rule file_397_0_0 {
	meta:
		name = "_nrand48_r"
		size = 20
		refs = "0004 __dorand48"
	strings:
		$1 = { 10 B5 0C 1C ?? ?? ?? ?? 60 88 A3 88 40 08 DB 03 C0 18 10 BD }
	condition:
		$1
}

rule file_398_0_0 {
	meta:
		name = "_lcong48_r"
		size = 44
	strings:
		$1 = { 0A 88 AC 23 C2 52 4A 88 AE 23 C2 52 8A 88 B0 23 C2 52 CA 88 B2 23 C2 52 0A 89 B4 23 C2 52 4A 89 B6 23 C2 52 8A 89 B8 23 C2 52 70 47 }
	condition:
		$1
}

rule file_398_1_0 {
	meta:
		name = "lcong48"
		size = 52
		refs = "0030 _impure_ptr"
	strings:
		$1 = { 0B 4B 01 88 1B 68 AC 22 99 52 41 88 AE 22 99 52 81 88 B0 22 99 52 C1 88 B2 22 99 52 01 89 B4 22 99 52 41 89 B6 22 99 52 81 89 B8 22 99 52 70 47 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_399_0_0 {
	meta:
		name = "mbrlen"
		size = 20
		refs = "000e mbrtowc"
	strings:
		$1 = { 30 B5 05 1C 0C 1C 13 1C 29 1C 22 1C 00 20 ?? ?? ?? ?? 30 BD }
	condition:
		$1
}

rule file_405_0_0 {
	meta:
		name = "strlcat"
		size = 100
		refs = "0050 strlen"
	strings:
		$1 = { 70 B5 00 2A 22 D0 03 78 00 2B 27 D0 54 1E 03 1C 03 E0 1E 78 01 3C 00 2E 02 D0 01 33 00 2C F8 D1 1C 1A 15 1B 00 2D 12 D0 0A 78 00 2A 14 D0 08 1C 01 2D 02 D0 1A 70 01 3D 01 33 01 30 02 78 00 2A F6 D1 40 1A 00 22 1A 70 00 19 70 BD 00 24 08 1C ?? ?? ?? ?? 00 19 F8 E7 00 20 F3 E7 03 1C 15 1C 00 24 E1 E7 }
	condition:
		$1
}

rule file_406_0_0 {
	meta:
		name = "_wcstol_r"
		size = 348
		refs = "001c iswspace 0050 __umodsi3 005a __udivsi3 0066 iswdigit 009c iswalpha 00a6 iswupper"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 84 B0 03 90 00 91 02 92 9A 46 0E 1C 10 CE 20 1C ?? ?? ?? ?? 00 28 F9 D1 2D 2C 00 D1 74 E0 2B 2C 00 D1 7D E0 00 22 01 92 51 46 4B 42 4B 41 10 29 52 D0 00 2B 50 D1 D3 46 01 9A 00 2A 58 D1 43 4D 28 1C 59 46 ?? ?? ?? ?? 59 46 81 46 28 1C ?? ?? ?? ?? 80 46 20 1C 00 25 00 27 ?? ?? ?? ?? 00 28 15 D0 30 3C A2 45 20 DD 47 45 44 D8 00 2D 42 DB 4C 45 01 DD 47 45 3E D0 3B 1C 5F 46 5F 43 E7 19 10 CE 01 25 20 1C ?? ?? ?? ?? 00 28 E9 D1 20 1C ?? ?? ?? ?? 00 28 08 D0 20 1C ?? ?? ?? ?? 00 28 2D D1 57 23 E4 1A A2 45 DE DC 69 1C 30 D0 01 9A 00 2A 27 D1 38 1C 02 9B 00 2B 06 D0 00 2D 01 D0 04 3E 00 96 00 99 02 9A 11 60 04 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 30 2C 25 D0 00 2B AA D0 30 2C 2F D0 01 9A 0A 23 9B 46 9A 46 00 2A A6 D0 80 25 2D 06 A4 E7 01 25 6D 42 10 CE C2 E7 37 23 E4 1A D0 E7 78 42 D6 E7 01 21 10 CE 01 91 8B E7 01 9A 00 2A 13 D1 0D 48 03 99 22 23 0B 60 CA E7 00 23 10 CE 01 93 7F E7 32 68 58 2A 01 D0 78 2A D4 D1 10 22 74 68 93 46 08 36 92 46 7C E7 80 20 00 06 E9 E7 08 21 8B 46 8A 46 75 E7 FF FF FF 7F }
	condition:
		$1
}

rule file_407_0_0 {
	meta:
		name = "worker"
		size = 120
		refs = "0022 _close_r 003a _sprintf_r 004c _open_r"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 83 B0 98 46 0B 9B 99 46 18 4B 04 1C 0E 1C 17 1C 0C 9D 9A 46 02 E0 20 1C ?? ?? ?? ?? 43 46 00 93 4B 46 01 93 2B 68 31 1C 02 93 52 46 3B 1C 20 1C ?? ?? ?? ?? 2B 68 01 33 2B 60 31 1C 20 1C 00 22 00 23 ?? ?? ?? ?? 01 1C 43 1C E4 D1 23 68 58 2B 06 D0 01 20 03 B0 1C BC 90 46 99 46 A2 46 F0 BD 00 23 33 70 00 20 F5 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_407_1_0 {
	meta:
		name = "_tempnam_r"
		size = 124
		refs = "0014 strlen 0028 _malloc_r 003a _getpid_r 0062 getenv"
	strings:
		$1 = { F0 B5 82 B0 06 1C 0C 1C 00 2A 27 D0 17 1C 00 2C 26 D0 20 1C ?? ?? ?? ?? 05 1C 38 1C ?? ?? ?? ?? 2D 18 29 1C 13 31 30 1C ?? ?? ?? ?? 05 1C 00 28 02 D1 02 B0 28 1C F0 BD 30 1C ?? ?? ?? ?? 33 1C 70 40 10 33 00 90 01 93 30 1C 29 1C 22 1C 3B 1C FF F7 9A FF 00 28 EC D1 00 25 EA E7 04 4F D6 E7 04 48 ?? ?? ?? ?? 04 1C 00 28 D2 D1 02 4C D0 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_407_3_0 {
	meta:
		name = "_tmpnam_r"
		size = 72
		refs = "000e _getpid_r"
	strings:
		$1 = { 30 B5 82 B0 04 1C 00 29 17 D0 0D 1C 20 1C ?? ?? ?? ?? 23 1C 10 33 00 90 01 93 20 1C 29 1C 08 4A 08 4B FF F7 67 FF 00 28 05 D0 23 69 01 33 23 61 02 B0 28 1C 30 BD 00 25 FA E7 05 1C 14 35 E5 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_408_0_0 {
	meta:
		name = "__svfiscanf_r"
		size = 2296
		refs = "0078 __srefill_r 01ce memset 01e0 _mbrtowc_r 0330 __ctype_ptr__ 0334 _strtol_r 033c _strtoul_r 0340 __mb_cur_max 0540 iswspace 0566 _ungetc_r 068a __sccl 08b2 _fread_r"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0C 1C 99 46 89 89 80 23 9B 01 D8 B0 82 46 19 42 05 D1 0B 43 A3 81 61 6E C1 4B 0B 40 63 66 00 25 00 20 04 90 05 95 06 95 90 46 41 46 0A 78 00 2A 24 D0 BC 4E 01 23 98 44 33 68 57 92 99 18 49 78 0F 07 23 D5 63 68 08 27 0C E0 22 68 31 68 13 78 CB 18 5B 78 3B 42 E8 D0 63 68 01 32 01 3B 63 60 22 60 01 35 00 2B F0 DC 50 46 21 1C ?? ?? ?? ?? 00 28 EA D0 41 46 0A 78 00 2A DA D1 05 98 58 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 25 2A 1F D0 63 68 00 2B 0D DD 23 68 42 46 01 3A 19 78 12 78 91 42 EB D1 62 68 01 33 01 3A 62 60 23 60 01 35 BB E7 50 46 21 1C ?? ?? ?? ?? 00 28 EB D0 05 98 00 28 02 D0 A3 89 59 06 D9 D5 01 20 40 42 D6 E7 00 20 02 90 47 46 9C 46 3A 78 01 37 78 2A 11 D9 63 46 9B 18 5B 78 B8 46 01 27 83 46 3B 42 01 D0 38 43 83 46 8C 49 0A 22 03 23 06 91 02 9F 04 92 03 93 0F E0 89 49 93 00 CB 58 9F 46 10 21 08 43 E2 E7 83 46 86 48 0A 22 03 23 B8 46 04 92 02 9F 03 93 06 90 63 68 00 2B 00 DC 85 E2 58 46 40 06 15 D4 23 68 31 68 1A 78 8A 18 52 78 08 20 02 42 0D D0 62 68 01 3A 62 60 00 2A 5D DD 01 33 23 60 01 35 1A 78 8A 18 52 78 08 20 02 42 F1 D1 03 99 02 29 00 D1 A3 E1 03 29 00 D1 00 E1 01 29 56 D0 02 9A 00 2A 00 D1 01 27 5B 46 01 20 03 42 00 D1 C7 E0 10 23 59 46 19 40 02 91 00 D0 BE E0 4B 46 1B 68 04 20 9B 46 81 44 43 46 00 26 A8 46 5D 46 9B 46 64 49 0B 68 9E 42 89 D0 23 68 1A 78 4B A8 82 55 62 68 01 33 01 3A 62 60 23 60 00 21 08 22 55 A8 ?? ?? ?? ?? 01 36 55 A9 00 91 4B AA 50 46 29 1C 33 1C ?? ?? ?? ?? 42 1C 00 D1 6F E7 00 28 7E D1 02 9B 00 2B 00 D1 2B 60 02 98 B0 44 01 3F 00 28 00 D1 04 35 00 26 63 68 00 2B 73 DD 00 2F CF D1 45 46 D8 46 79 E0 50 46 21 1C ?? ?? ?? ?? 00 28 00 D0 53 E7 31 68 23 68 01 35 99 E7 02 98 00 28 01 D1 01 27 7F 42 59 46 C9 06 31 D5 6A 46 2C 32 23 68 03 92 00 26 1A 78 03 98 82 5C 00 2A 00 D1 20 E3 62 68 01 33 01 3A 01 36 62 60 23 60 B7 42 1C D0 00 2A EF DC 50 46 21 1C ?? ?? ?? ?? 00 28 14 D1 23 68 E7 E7 2B 1C 35 1C 5E 46 9B 46 5E 45 00 D1 23 E7 59 46 8E 1B 00 2E 00 D1 FD E6 00 23 0B 70 05 9B 01 33 04 22 05 93 91 44 AD 19 CB E6 49 46 0E 68 6A 46 2C 32 B3 46 23 68 03 92 2E 1C 5D 46 1B 78 03 98 C3 5C 00 2B 00 D1 E5 E2 63 68 01 3B 63 60 23 68 1A 78 01 3F 01 33 2A 70 01 35 23 60 00 2F 00 D1 D8 E2 62 68 00 2A E9 DC 50 46 21 1C ?? ?? ?? ?? 00 28 C5 D1 23 68 E1 E7 02 30 89 D0 81 E7 50 46 21 1C ?? ?? ?? ?? 00 28 85 D0 45 46 D8 46 00 2E 00 D0 E0 E6 02 99 00 29 00 D0 92 E6 05 9A 01 32 05 92 8E E6 00 22 93 46 42 E7 5B 46 DB 06 00 D4 BF E2 00 26 AB 46 17 E0 FF DF FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 23 68 5B 19 23 60 50 46 21 1C 76 19 ?? ?? ?? ?? 00 28 00 D0 87 E2 7F 1B 65 68 BD 42 F0 DB 5B 46 AB 46 58 46 1D 1C C3 1B 63 60 23 68 F6 19 DF 19 27 60 AD 19 5D E6 02 9B 01 3B 26 2B 00 D9 95 E0 00 22 02 92 96 21 00 23 D8 26 49 00 58 46 69 44 36 01 07 93 80 23 8B 46 1B 01 06 43 01 91 C0 20 80 21 A0 22 C0 00 89 00 D2 00 0A 93 2B 1C 08 90 5D 46 03 91 09 92 9B 46 19 E0 38 2B 4E D3 04 98 41 00 CD 48 09 5A 09 04 09 14 04 91 08 29 1C DD CA 49 0E 40 2B 70 01 35 63 68 01 3B 63 60 00 2B 00 DC C6 E0 01 32 22 60 01 3F 00 2F 0D D0 22 68 13 78 39 2B E1 D9 58 2B 24 D0 58 2B 1C D8 19 1C 41 39 09 06 09 0E 05 29 35 D9 5B 46 AB 46 1D 1C F2 05 07 D5 01 9B 9B 45 00 D9 1A E2 01 99 8B 45 00 D1 2F E6 10 23 33 40 00 D1 FE E1 01 9F 07 98 ED 1B 2D 18 5D 44 FC E5 61 2B E6 D3 66 2B 1A D9 78 2B E2 D1 08 99 03 98 31 40 81 42 DD D1 AC 49 09 98 0E 40 10 21 06 43 04 91 BB E7 30 2B 18 D0 30 2B 0C D8 2B 2B 01 D0 2D 2B CE D1 80 21 0E 42 CB D0 8E 43 AE E7 04 98 0A 28 A9 DC C5 E7 04 99 48 00 9D 49 41 5A 9D 48 09 04 09 14 04 91 06 40 A0 E7 0A 98 06 42 9D D0 04 99 00 29 00 D1 BF E1 70 05 00 D4 8E E1 97 49 0E 40 93 E7 02 9B 27 3B 02 93 27 27 66 E7 02 98 00 28 01 D1 01 27 7F 42 59 46 01 22 11 42 6D D0 10 23 19 40 03 91 64 D1 48 46 00 68 04 21 02 90 89 44 43 46 00 22 A8 46 9B 46 15 1C 22 68 13 78 00 2F 4A D0 31 68 C9 18 49 78 08 20 01 42 44 D1 83 48 01 68 8D 42 00 D1 E1 E5 4B A9 4B 55 63 68 01 32 01 3B 63 60 22 60 00 21 08 22 55 A8 ?? ?? ?? ?? 01 35 55 AA 00 92 2B 1C 50 46 02 99 4B AA ?? ?? ?? ?? 43 1C 00 D1 C9 E5 00 28 00 D0 6E E1 02 99 08 60 ?? ?? ?? ?? 00 28 00 D1 4A E1 5B 46 AB 46 5E 46 45 46 01 3E 98 46 4B AB 2F 1C 9E 19 5D 46 06 E0 31 78 50 46 22 1C ?? ?? ?? ?? 01 3D 01 3E 00 2D F6 D1 3D 1C 09 E0 50 46 21 1C ?? ?? ?? ?? 00 28 00 D1 33 E7 43 E7 45 46 D8 46 03 99 00 29 00 D0 51 E5 05 9B 02 9A 01 33 11 60 05 93 4B E5 AE 23 5B 00 6B 44 02 93 9A E7 58 46 C0 06 27 D4 49 46 09 68 2A 1C 02 91 23 68 0D 1C 93 46 32 68 1B 78 D3 18 5B 78 08 22 13 42 00 D0 EE E0 63 68 01 3B 63 60 23 68 1A 78 01 3F 01 33 2A 70 01 35 23 60 00 2F 00 D1 E1 E0 62 68 00 2A E7 DC 50 46 21 1C ?? ?? ?? ?? 00 28 00 D0 D7 E0 23 68 DE E7 00 21 8B 46 32 68 29 1C 23 68 5D 46 8B 46 19 78 51 18 49 78 08 20 01 42 00 D0 C2 E0 61 68 01 33 01 39 01 35 61 60 23 60 AF 42 00 D1 B9 E0 00 29 ED DC 50 46 21 1C ?? ?? ?? ?? 00 28 00 D0 B0 E0 32 68 23 68 E3 E7 50 46 21 1C ?? ?? ?? ?? 00 28 00 D1 72 E5 3A E5 02 1C 01 23 1A 43 B8 46 93 46 2C 4F 0A 20 03 21 06 97 04 90 02 9F 03 91 60 E5 02 99 8B 00 5B 18 5B 00 30 3A D2 18 02 92 32 E5 6B 46 2C 33 83 46 39 1C 18 1C 03 93 ?? ?? ?? ?? 5F 46 40 23 1F 43 80 46 01 20 BB 46 03 90 02 9F 47 E5 80 23 9B 00 02 1C 1A 43 B8 46 02 9F 93 46 10 23 18 49 03 20 04 93 03 90 06 91 39 E5 01 1C 01 22 11 43 B8 46 8B 46 02 9F 08 23 F1 E7 02 23 18 43 08 E5 02 22 B8 46 83 46 02 9F 03 92 28 E5 88 23 B8 46 9B 00 07 1C 0B 4A 1F 43 10 20 03 21 BB 46 04 90 02 9F 03 91 06 92 1A E5 C0 46 ?? ?? ?? ?? 7F F4 FF FF FF FD FF FF 7F FA FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 74 4B 08 21 03 22 B8 46 83 46 02 9F 04 91 03 92 06 93 01 E5 03 1C 83 46 B8 46 DB 06 00 D5 7E E4 07 1C 04 20 07 42 24 D1 5A 46 01 23 1A 42 25 D0 4F 46 3B 68 04 20 1D 60 81 44 70 E4 01 22 10 43 C4 E4 65 4A 83 46 00 23 03 20 B8 46 06 92 02 9F 04 93 03 90 E0 E4 04 21 08 43 B7 E4 40 23 01 1C 19 43 00 22 B8 46 8B 46 02 9F 03 92 D4 E4 B8 46 88 E4 49 46 0B 68 81 44 1D 80 50 E4 49 46 0B 68 04 22 1D 60 91 44 4A E4 5B 46 AB 46 1D 1C 5D 44 45 E4 5B 46 AB 46 1D 1C 04 23 99 44 5F 46 00 23 3B 70 05 99 02 98 01 31 2D 1A 5D 44 05 91 36 E4 02 99 00 29 02 D0 01 39 02 91 01 37 47 4B 1E 40 07 9B 01 33 07 93 FD E5 03 98 A8 44 01 3F 00 28 02 D1 02 99 04 31 02 91 00 25 63 68 00 2B 00 DD 76 E6 50 46 21 1C ?? ?? ?? ?? 00 28 00 D1 6F E6 5B 46 AB 46 5A 46 45 46 98 46 00 2A 00 D0 58 E4 B7 E6 02 30 E9 D0 02 9A 10 68 8D E6 03 98 08 21 06 43 04 91 3A E6 5A 46 13 70 4B A9 50 46 00 22 04 9B 06 9F 00 F0 94 F8 B1 06 19 D5 4A 46 13 68 18 60 04 23 99 44 05 9B 01 33 05 93 EC E5 01 27 7F 42 BB 44 58 46 01 78 22 1C 50 46 ?? ?? ?? ?? DA E5 5D 46 00 2E 00 D1 2B E4 AD 19 FF F7 DF FB 04 27 3E 42 27 D0 49 46 0B 68 B9 44 18 80 E2 E7 2B 1C 35 1C 5E 46 9B 46 F7 E4 00 2E 01 D1 FF F7 F7 FB AD 19 FF F7 CB FB 83 46 B8 46 DB E6 4A 46 11 68 50 46 01 22 3B 1C 00 94 ?? ?? ?? ?? 00 28 01 D1 FF F7 06 FC 05 9F 04 23 01 37 99 44 45 19 05 97 FF F7 B4 FB 01 22 16 42 05 D0 4F 46 3B 68 18 60 04 20 81 44 B6 E7 49 46 0B 68 04 22 18 60 91 44 B0 E7 ?? ?? ?? ?? ?? ?? ?? ?? 7F FC FF FF }
	condition:
		$1
}

rule file_410_0_0 {
	meta:
		name = "argz_append"
		size = 52
		refs = "001a realloc 002a memcpy"
	strings:
		$1 = { F0 B5 05 1C 16 1C 1C 1C 00 2B 01 D1 00 20 F0 BD 0F 68 DB 19 0B 60 00 68 19 1C ?? ?? ?? ?? 28 60 00 28 05 D0 C0 19 31 1C 22 1C ?? ?? ?? ?? ED E7 0C 20 EC E7 }
	condition:
		$1
}

rule file_411_0_0 {
	meta:
		name = "strupr"
		size = 44
		refs = "0028 __ctype_ptr__"
	strings:
		$1 = { 30 B5 03 78 00 2B 0D D0 07 4D 02 1C 02 24 29 68 C9 18 49 78 21 42 01 D0 20 3B 13 70 01 32 13 78 00 2B F4 D1 30 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_414_1_0 {
	meta:
		name = "__sseek"
		size = 44
		refs = "0008 _lseek_r"
	strings:
		$1 = { 30 B5 0C 1C 0E 25 49 5F ?? ?? ?? ?? 43 1C 06 D0 A2 89 80 23 5B 01 13 43 A3 81 20 65 30 BD A2 89 01 4B 13 40 A3 81 F9 E7 FF EF FF FF }
	condition:
		$1
}

rule file_414_2_0 {
	meta:
		name = "__swrite"
		size = 56
		refs = "0018 _lseek_r 002e _write_r"
	strings:
		$1 = { F0 B5 1F 1C 8B 89 05 1C 0C 1C 16 1C DA 05 06 D5 0E 23 C9 5E 00 22 02 23 ?? ?? ?? ?? A3 89 05 4A 13 40 A3 81 0E 22 A1 5E 28 1C 32 1C 3B 1C ?? ?? ?? ?? F0 BD FF EF FF FF }
	condition:
		$1
}

rule file_414_3_0 {
	meta:
		name = "__sread"
		size = 40
		refs = "0008 _read_r"
	strings:
		$1 = { 30 B5 0C 1C 0E 25 49 5F ?? ?? ?? ?? 00 28 03 DB 23 6D 1B 18 23 65 30 BD A2 89 02 4B 13 40 A3 81 F9 E7 C0 46 FF EF FF FF }
	condition:
		$1
}

rule file_416_0_0 {
	meta:
		name = "ispunct"
		size = 20
		refs = "0010 __ctype_ptr__"
	strings:
		$1 = { 03 4B 1B 68 18 18 40 78 10 23 18 40 70 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_418_0_0 {
	meta:
		name = "wcpcpy"
		size = 20
	strings:
		$1 = { 10 B5 03 1C 10 C9 1A 1C 10 C2 18 1C 13 1C 00 2C F8 D1 10 BD }
	condition:
		$1
}

rule file_419_0_0 {
	meta:
		name = "__dtoa"
		size = 48
		refs = "0022 _dtoa_r 002c _impure_ptr"
	strings:
		$1 = { 70 B5 14 1C 09 4A 84 B0 05 1C 10 68 00 93 08 9B 01 93 09 9B 02 93 0A 9B 0E 1C 03 93 29 1C 32 1C 23 1C ?? ?? ?? ?? 04 B0 70 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_420_0_0 {
	meta:
		name = "_seed48_r"
		size = 76
	strings:
		$1 = { 70 B5 03 1C AC 25 5A 5B 0D 48 02 80 AE 24 1A 5B 42 80 B0 22 9E 5A 86 80 0E 88 5E 53 4D 88 1D 53 89 88 99 52 07 49 B2 22 99 52 07 49 B4 22 99 52 05 21 B6 22 99 52 0B 21 B8 22 99 52 70 BD C0 46 ?? ?? ?? ?? 6D E6 FF FF EC DE FF FF }
	condition:
		$1
}

rule file_420_1_0 {
	meta:
		name = "seed48"
		size = 84
		refs = "0044 _impure_ptr"
	strings:
		$1 = { 70 B5 10 4B 1B 68 AC 25 59 5B 0F 4A 11 80 AE 24 19 5B 51 80 B0 21 5E 5A 96 80 06 88 5E 53 45 88 1D 53 80 88 58 52 09 48 B2 21 58 52 08 48 B4 21 58 52 05 20 B6 21 58 52 0B 20 B8 21 58 52 10 1C 70 BD C0 46 ?? ?? ?? ?? ?? ?? ?? ?? 6D E6 FF FF EC DE FF FF }
	condition:
		$1
}

rule file_421_0_0 {
	meta:
		name = "_wcrtomb_r"
		size = 42
		refs = "000c _wctomb_r"
	strings:
		$1 = { 30 B5 83 B0 04 1C 1D 1C 00 29 09 D0 ?? ?? ?? ?? 43 1C 03 D1 00 23 2B 60 8A 23 23 60 03 B0 30 BD 69 46 00 22 ?? ?? ?? ?? F2 E7 }
	condition:
		$1
}

rule file_422_1_0 {
	meta:
		name = "_vfprintf_r"
		size = 5352
		refs = "0018 _localeconv_r 0410 _vfprintf_r 041e _fflush_r 043e __sinit 05c6 __isinfd 05da __ltdf2 0796 memchr 081c __eqdf2 0a0a __nedf2 0b86 __umodsi3 0b94 __udivsi3 0ea0 __isnand 0f28 _dtoa_r 1098 strlen 10f4 __swsetup_r 1304 __modsi3 1312 __divsi3"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 D8 4C A5 44 06 90 8B 46 17 1C 99 46 ?? ?? ?? ?? 00 68 16 90 06 98 00 28 03 D0 83 6B 00 2B 00 D1 07 E2 5A 46 91 89 80 22 92 01 0B 1C 11 42 08 D1 11 43 5B 46 5A 6E 99 81 CB 4B 5E 46 13 40 73 66 0B 1C 18 07 01 D4 01 F0 4D F8 5E 46 32 69 00 2A 01 D1 01 F0 47 F8 1A 22 13 40 0A 2B 00 D1 B1 E1 C2 4C C3 48 00 23 6C 44 68 44 20 60 A3 60 63 60 12 93 13 93 11 93 15 93 14 93 0A 93 05 1C 3B 78 00 2B 1F D0 25 2B 1D D0 3E 1C 01 36 33 78 25 2B 01 D0 00 2B F9 D1 F1 1B 88 46 00 29 10 D0 A3 68 43 44 A3 60 63 68 01 33 2F 60 69 60 63 60 07 2B 00 DD 6B E1 08 35 0A 9B 9C 46 C4 44 63 46 0A 93 33 78 37 1C 00 2B 00 D1 90 E3 AA 48 00 21 68 44 4A 46 01 70 82 46 07 92 01 20 00 22 41 42 08 23 0B 92 05 92 88 46 01 37 10 21 40 20 9C 46 3B 78 01 37 1A 1C 20 3A 58 2A 00 D8 43 E1 10 93 00 2B 00 D1 73 E3 9C 4B 10 A9 09 78 6B 44 01 20 00 26 52 46 19 70 16 70 08 90 09 90 0D 93 00 22 0F 92 05 9A 02 23 1A 40 0E 92 02 D0 08 9B 02 33 08 93 05 9E 84 23 1E 40 0C 96 41 D1 0B 98 08 99 46 1A 00 2E 3C DD 10 2E 01 DC 00 F0 AD FF 8B 4B 99 46 4A 46 10 20 2B 1C B9 46 80 46 5D 46 17 1C 03 E0 10 3E 08 33 10 2E 17 DD A2 68 10 32 A2 60 62 68 41 46 01 32 1F 60 59 60 62 60 07 2A F0 DD 06 98 29 1C 22 1C FF F7 28 FF 00 28 00 D0 08 E1 78 4B 10 3E 6B 44 10 2E E7 DC AB 46 1D 1C 3B 1C 4F 46 99 46 A3 68 F3 18 A3 60 63 68 4A 46 01 33 2A 60 6E 60 63 60 07 2B 01 DD 00 F0 07 FD 08 35 56 46 33 78 00 2B 0D D0 01 23 6B 60 A3 68 01 33 A3 60 63 68 01 33 2E 60 63 60 07 2B 01 DD 00 F0 4A FC 08 35 0E 98 00 28 0F D0 65 4B 6B 44 2B 60 02 23 6B 60 A3 68 02 33 A3 60 63 68 01 33 63 60 07 2B 01 DD 00 F0 43 FC 08 35 0C 99 80 29 00 D1 68 E3 0F 9A 09 9B D6 1A 00 2E 3E DD 10 2E 01 DC 00 F0 C7 FD 56 49 10 22 90 46 89 46 92 46 5A 46 2B 1C BB 46 C8 44 06 9D 17 1C 03 E0 10 3E 08 33 10 2E 18 DD A2 68 10 32 A2 60 62 68 40 46 51 46 01 32 18 60 59 60 62 60 07 2A EF DD 28 1C 39 1C 22 1C FF F7 BA FE 00 28 00 D0 80 E3 41 4B 10 3E 6B 44 10 2E E6 DC 1D 1C 3B 1C 5F 46 9B 46 4B 46 10 33 2B 60 A3 68 6E 60 F6 18 63 68 01 33 A6 60 63 60 07 2B 00 DD D1 E3 08 35 05 9A D2 05 00 D5 AF E2 0D 9B 09 9E 2B 60 6E 60 A3 68 F3 18 A3 60 63 68 01 33 63 60 07 2B 00 DD 69 E3 2B 1C 08 33 05 98 40 07 3B D5 0B 99 08 9A 8E 1A 00 2E 36 DD 10 2E 01 DC 00 F0 F1 FE 29 49 B8 46 10 25 0F 1C 03 E0 10 3E 08 33 10 2E 15 DD A2 68 10 32 A2 60 62 68 01 32 1F 60 5D 60 62 60 07 2A F1 DD 06 98 59 46 22 1C FF F7 69 FE 00 28 4B D1 19 4B 10 3E 6B 44 10 2E E9 DC B9 46 47 46 4A 46 5E 60 1A 60 A3 68 F6 18 63 68 01 33 A6 60 63 60 07 2B 07 DD 06 98 59 46 22 1C FF F7 50 FE 00 28 32 D1 A6 68 08 9B 0B 98 83 42 00 DA 03 1C 0A 99 C9 18 0A 91 00 2E 00 D0 27 E3 07 9B 06 4D 00 22 62 60 99 46 6D 44 8D E6 C0 46 A8 FA FF FF FF DF FF FF 2C 05 00 00 C4 04 00 00 57 05 00 00 04 05 00 00 ?? ?? ?? ?? 54 05 00 00 CD 4E 92 00 B2 58 97 46 06 98 59 46 22 1C FF F7 21 FE 00 28 03 D1 C9 4D 6D 44 8A E6 AB 46 5E 46 B3 89 58 06 02 D5 01 21 49 42 0A 91 AB 23 DB 00 0A 98 9D 44 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 5A 46 0E 26 93 5F 00 2B 00 DA 47 E6 BC 4C 02 23 6C 44 99 43 A1 81 D3 89 E3 81 D3 69 E3 61 53 6A 63 62 B7 4C 17 AB 6C 44 23 60 23 61 80 23 DB 00 A3 60 63 61 00 23 A3 61 06 98 21 1C 3A 1C 4B 46 ?? ?? ?? ?? 0A 90 00 28 07 DB 06 98 21 1C ?? ?? ?? ?? 00 28 01 D0 01 F0 00 F8 A3 89 59 06 C5 D5 5B 46 9A 89 40 23 13 43 5E 46 B3 81 BE E7 ?? ?? ?? ?? F4 E5 52 46 13 78 00 2B 01 D0 00 F0 56 FC 20 23 13 70 07 9B 07 93 4F E6 05 9E 01 23 1E 43 07 9B 05 96 07 93 48 E6 07 9A 07 9B 12 68 04 33 0B 92 00 2A EF DA 52 42 0B 92 06 E0 2B 23 52 46 13 70 07 9B 07 93 38 E6 07 9B 05 9E 04 22 16 43 05 96 07 93 31 E6 3B 78 01 37 2A 2B 01 D1 00 F0 D0 FF 1A 1C 30 3A 09 2A 01 D9 00 F0 EE FE 00 26 B3 00 9E 19 3B 78 76 00 B6 18 1A 1C 30 3A 01 37 09 2A F5 D9 00 2E B0 46 00 DB 18 E6 01 26 72 42 90 46 14 E6 05 9E 80 23 1E 43 07 9B 05 96 07 93 0B E6 1A 1C 00 26 30 3A B3 00 9E 19 3B 78 76 00 96 19 1A 1C 30 3A 01 37 09 2A F5 D9 0B 96 FE E5 05 9E 10 93 10 23 1E 43 05 96 05 98 C0 06 00 D5 CE E2 05 9B 5B 06 00 D4 CA E2 07 9E 07 98 04 36 0C 96 06 68 36 04 36 14 00 2E 00 DA D6 E3 32 1C 53 1E 9A 41 01 23 40 46 00 28 03 DB 05 98 80 21 88 43 05 90 41 46 00 29 02 D1 00 2A 00 D1 BD E1 01 2B 00 D1 0E E3 02 2B 00 D1 2C E3 0D 94 07 22 21 1C 33 1C 13 40 01 39 30 33 F6 08 0B 70 00 2E F7 D1 05 9A 0D 91 D2 07 00 D5 A4 E3 63 1A 09 93 09 9E 08 96 46 45 01 DA 40 46 08 90 50 46 03 78 0C 98 41 46 0F 91 07 90 00 2B 00 D1 C6 E5 08 99 01 31 08 91 C2 E5 05 99 10 93 07 9B 09 07 00 D4 B8 E3 1A 1C 1E 68 5B 68 08 32 07 92 12 96 13 93 99 46 30 1C 49 46 ?? ?? ?? ?? 00 28 01 D1 00 F0 65 FC 30 1C 49 46 3F 4A 3F 4B ?? ?? ?? ?? 00 28 00 DA F2 E3 50 46 03 78 10 9A 47 2A 00 DD E9 E3 3A 4E 0D 96 05 99 80 22 91 43 00 26 03 22 05 91 08 92 09 92 0F 96 C7 E7 05 9A 63 46 1A 43 07 9B 05 92 07 93 71 E5 05 98 10 93 10 23 18 43 05 90 05 99 C9 06 00 D5 49 E2 05 9E 76 06 00 D4 45 E2 07 99 07 98 0E 88 04 30 32 1C 0C 90 53 1E 9A 41 00 23 00 21 50 46 01 70 75 E7 05 98 10 93 10 23 18 43 05 90 05 99 C9 06 00 D5 39 E2 05 9E 76 06 00 D4 35 E2 07 99 07 98 0E 88 04 30 32 1C 53 1E 9A 41 0C 90 01 23 E4 E7 19 48 15 90 05 98 10 93 C0 06 00 D5 A6 E0 05 9B 5B 06 00 D4 A2 E0 07 9E 07 98 04 36 0C 96 06 88 32 1C 53 1E 9A 41 00 2A 0F D0 05 9B DB 07 0C D5 0E 4B 10 A8 00 78 6B 44 30 22 05 99 1A 70 58 70 02 23 19 43 05 91 01 22 BF E7 02 23 BD E7 C0 46 ?? ?? ?? ?? C4 04 00 00 5C 04 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 54 05 00 00 07 9E 10 93 DB 4B 32 68 6B 44 1A 70 00 21 01 22 50 46 04 36 01 70 07 96 08 92 09 92 0D 93 0F E5 05 9E 07 9B 06 43 05 96 07 93 F2 E4 05 9A 07 9B 0A 43 05 92 07 93 EC E4 05 99 C9 06 00 D4 ED E2 07 9E 07 9A 33 68 0A 98 91 46 04 22 91 44 18 60 A7 E4 05 99 02 23 07 9E 07 98 19 43 C6 4B 04 36 6B 44 30 22 0C 96 06 68 1A 70 78 22 5A 70 32 1C 53 1E 9A 41 C1 4B 78 20 15 93 05 91 02 23 10 90 6B E7 00 22 51 46 10 93 0A 70 07 9B 1E 1C 1B 68 04 36 07 96 0D 93 00 2B 01 D1 00 F0 A3 FC 46 46 00 2E 01 DA 00 F0 83 FC 0D 98 00 21 42 46 ?? ?? ?? ?? 00 28 01 D1 00 F0 E8 FC 0D 9B C0 1A 09 90 40 45 01 DD 00 F0 19 FC 09 9A 08 92 00 2A 01 DA 00 F0 7E FD 56 46 00 20 33 78 0F 90 E8 E6 A7 4E 05 98 10 93 15 96 C0 06 00 D4 58 E7 07 99 04 31 0C 91 07 9A 16 68 5B E7 05 9B 0B 43 05 93 07 9B 07 93 86 E4 10 93 8C E6 10 93 15 E7 10 93 2D E7 A3 68 00 2B 00 D1 D6 E5 06 98 59 46 22 1C FF F7 ED FB D0 E5 10 98 65 28 00 DC D6 E0 12 98 13 99 93 4A 94 4B ?? ?? ?? ?? 00 28 00 D0 5E E1 92 4B 2B 60 01 23 6B 60 A3 68 01 33 A3 60 63 68 01 33 63 60 07 2B 00 DD C9 E2 2B 1C 08 33 AA 21 C9 00 69 44 0A 68 11 9E B2 42 03 DB 05 98 C0 07 00 D4 37 E5 01 22 5A 60 A2 68 01 32 A2 60 62 68 16 99 01 32 19 60 62 60 07 2A 00 DD EC E3 08 33 11 9E 01 3E 00 2E 00 DC 24 E5 10 2E 01 DC 00 F0 8A FD 7A 48 10 21 05 1C BA 46 81 46 10 35 88 46 5F 46 03 E0 08 33 10 3E 10 2E 6C DD 42 46 5A 60 A2 68 10 32 A2 60 62 68 01 32 1D 60 62 60 07 2A F0 DD 06 98 39 1C 22 1C FF F7 91 FB 00 28 58 D1 6C 4B 6B 44 E7 E7 00 2B 0A D1 05 98 C0 07 07 D5 69 49 30 23 69 44 01 22 0D 91 0B 70 09 92 4C E6 00 23 0D 94 09 93 48 E6 0B 9A 08 9B D6 1A 00 2E 00 DC 90 E4 10 2E 01 DC 00 F0 34 FC 5C 49 10 22 90 46 89 46 92 46 5A 46 2B 1C BB 46 C8 44 06 9D 17 1C 03 E0 10 3E 08 33 10 2E 17 DD A2 68 10 32 A2 60 62 68 40 46 51 46 01 32 18 60 59 60 62 60 07 2A EF DD 28 1C 39 1C 22 1C FF F7 50 FB 00 28 17 D1 4B 4B 10 3E 6B 44 10 2E E7 DC 1D 1C 3B 1C 5F 46 9B 46 4B 46 10 33 2B 60 A3 68 F3 18 A3 60 63 68 01 33 6E 60 63 60 07 2B 00 DD 9B E1 08 35 51 E4 BB 46 18 E5 BB 46 57 46 4A 46 10 32 1A 60 A2 68 5E 60 B2 18 A2 60 62 68 01 32 62 60 07 2A 00 DC 96 E4 06 98 59 46 22 1C FF F7 20 FB 00 28 00 D0 01 E5 33 4B 6B 44 8C E4 06 98 59 46 22 1C FF F7 15 FB 00 28 00 D1 CF E4 F5 E4 11 99 01 29 00 DC 41 E1 0D 9B 2B 60 01 23 6B 60 A3 68 01 33 A3 60 63 68 01 33 63 60 07 2B 00 DD 3F E1 08 35 01 23 6B 60 A3 68 01 33 A3 60 63 68 16 9E 01 33 2E 60 63 60 07 2B 00 DD 3D E1 08 35 12 98 13 99 18 4A 18 4B ?? ?? ?? ?? 00 28 00 D1 ED E0 0D 9B 01 33 2B 60 11 9B A2 68 01 3B 6B 60 9B 18 A3 60 63 68 01 33 63 60 07 2B 00 DD 30 E1 08 35 A8 23 DB 00 6B 44 2B 60 14 9B 14 9E 6B 60 A3 68 37 E4 06 98 59 46 22 1C FF F7 CA FA 00 28 00 D0 AB E4 08 4D 6D 44 23 E4 04 05 00 00 54 05 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? C4 04 00 00 2B 05 00 00 06 98 59 46 22 1C FF F7 AD FA 00 28 00 D0 8E E4 D6 4D 6D 44 FF F7 AB FB 06 98 59 46 22 1C FF F7 A1 FA 00 28 00 D0 82 E4 D0 4D 6D 44 FF F7 B2 FB 07 99 04 31 0C 91 07 9A 16 68 35 E5 07 9A 04 32 07 9B 0C 92 1E 68 32 1C 53 1E 9A 41 00 23 B8 E5 07 9A 04 32 07 9B 0C 92 1E 68 32 1C 53 1E 9A 41 01 23 AE E5 AA 23 DB 00 6B 44 1E 68 00 2E 00 DC 82 E1 11 99 8E 42 00 DA 1D E1 A3 68 CB 18 A3 60 63 68 0D 9A 01 33 2A 60 69 60 63 60 07 2B 00 DD 0B E3 2B 1C 08 33 11 99 76 1A 00 2E 00 DC 41 E1 10 2E 01 DC 00 F0 7E FC B1 48 06 9A 05 1C 10 21 BA 46 81 46 5F 46 10 35 88 46 93 46 04 E0 08 33 10 3E 10 2E 00 DC 1D E1 A2 68 10 32 A2 60 62 68 40 46 01 32 1D 60 58 60 62 60 07 2A EF DD 58 46 39 1C 22 1C FF F7 3E FA 00 28 00 D0 04 E7 9F 4B 6B 44 E5 E7 09 2E 00 D8 03 E3 2B 1C B9 46 25 1C 1F 1C 30 1C 0A 21 ?? ?? ?? ?? 01 3D 30 30 28 70 0A 21 30 1C ?? ?? ?? ?? 06 1C 09 28 F1 D8 3B 1C 4F 46 A9 46 1D 1C 4A 46 01 3A 30 36 A3 1A 0D 92 16 70 09 93 E4 E4 0D 94 15 98 0F 22 23 1C 31 1C 11 40 41 5C 01 3B 36 09 19 70 00 2E F7 D1 E6 1A 0D 93 09 96 D4 E4 06 98 59 46 22 1C FF F7 02 FA 00 28 01 D0 FF F7 E3 FB 80 4D 6D 44 FF F7 ED FA 11 9E 01 3E 00 2E 00 DC 1C E7 10 2E 00 DC D1 E3 7B 49 10 22 90 46 89 46 92 46 5A 46 2B 1C BB 46 C8 44 06 9D 17 1C 03 E0 08 33 10 3E 10 2E 62 DD A2 68 10 32 A2 60 62 68 40 46 51 46 01 32 18 60 59 60 62 60 07 2A EF DD 28 1C 39 1C 22 1C FF F7 D1 F9 00 28 00 D0 97 E6 68 4B 6B 44 E5 E7 05 9A 01 23 1A 42 00 D0 B8 E6 0D 9A 6B 60 A3 68 2A 60 01 33 DF E6 06 98 59 46 22 1C FF F7 BB F9 00 28 01 D0 FF F7 9C FB 5D 4D 6D 44 B4 E6 06 98 59 46 22 1C FF F7 AF F9 00 28 01 D0 FF F7 90 FB 57 4D 6D 44 B6 E6 06 98 59 46 22 1C FF F7 A3 F9 00 28 01 D0 FF F7 84 FB 51 4D 6D 44 C3 E6 06 98 59 46 22 1C FF F7 97 F9 00 28 01 D0 FF F7 78 FB 4B 4D 6D 44 FF F7 AB FA 30 2B 00 D1 F6 E1 0D 98 01 38 30 23 21 1A 0D 90 03 70 09 91 51 E4 2D 23 50 46 76 42 03 70 23 E4 1D 1C 3B 1C 5F 46 9B 46 4B 46 10 33 2B 60 A3 68 6E 60 F3 18 93 E6 07 9B 07 93 FF F7 FB F9 05 99 49 06 00 D4 73 E1 07 9E 07 9A 68 46 28 21 33 68 08 5A 91 46 04 22 91 44 18 80 FF F7 B3 F9 07 98 1E 68 5B 68 08 30 07 90 99 46 12 96 13 93 45 E4 A3 68 F3 18 A3 60 63 68 0D 98 01 33 28 60 6E 60 63 60 07 2B 00 DD FD E1 2B 1C 08 33 16 9A 1A 60 01 22 5A 60 A2 68 01 32 A2 60 62 68 01 32 35 1C 62 60 07 2A 00 DD CD E1 08 33 11 98 82 1B 0D 99 5A 60 A2 68 4D 19 92 1B 1D 60 12 18 03 E6 BB 46 57 46 4A 46 10 32 1A 60 A2 68 B2 18 A2 60 62 68 01 32 5E 60 62 60 07 2A 00 DD 8E E2 08 33 05 99 01 22 11 42 01 D1 FF F7 8D FA 16 9E 5A 60 A2 68 1E 60 01 32 E7 E5 0C 48 81 46 FF F7 62 FA 0B 48 0D 90 14 E4 2D 23 51 46 0B 70 FF F7 0A FC 06 98 59 46 22 1C FF F7 03 F9 00 28 01 D0 FF F7 E4 FA 01 4B 6B 44 2B E5 C4 04 00 00 ?? ?? ?? ?? ?? ?? ?? ?? E4 4B 2B 60 01 23 6B 60 A3 68 01 33 A3 60 63 68 01 33 63 60 07 2B 00 DD 0D E1 2B 1C 08 33 00 2E 07 D1 11 99 00 29 04 D1 05 9A D2 07 01 D4 FF F7 50 FA 01 22 5A 60 A2 68 01 32 A2 60 62 68 16 98 01 32 18 60 62 60 07 2A 00 DD CB E1 08 33 76 42 00 2E 00 DC 1C E1 10 2E 00 DC EF E2 CE 48 10 21 05 1C BA 46 81 46 10 35 88 46 5F 46 04 E0 08 33 10 3E 10 2E 00 DC FB E0 42 46 5A 60 A2 68 10 32 A2 60 62 68 01 32 1D 60 62 60 07 2A EF DD 06 98 39 1C 22 1C FF F7 AA F8 00 28 00 D0 70 E5 BF 4B 6B 44 E5 E7 30 1C 49 46 ?? ?? ?? ?? 00 28 00 D0 AE E0 43 46 01 33 00 D1 58 E2 10 99 47 29 00 D1 4D E2 67 29 00 D1 4A E2 05 98 80 23 A7 21 5B 00 C9 00 18 43 69 44 4B 46 32 1C 0A 60 4B 60 0B 68 05 90 00 2B 00 DA 44 E2 00 22 0C 92 10 9B 46 3B 59 42 59 41 10 9B 66 3B 5A 42 53 41 0A 1C 1A 43 0E 92 00 D1 62 E1 43 46 03 20 09 93 84 46 09 9B 00 93 AA 23 DB 00 6B 44 01 93 A1 4B 6B 44 02 93 A9 23 DB 00 6B 44 03 93 06 98 31 1C 4A 46 63 46 ?? ?? ?? ?? 0D 90 10 98 47 28 00 D1 3C E1 67 28 00 D1 39 E1 0D 9B 09 98 0E 99 1B 18 08 93 00 29 0B D0 0D 9A 13 78 30 2B 00 D1 30 E2 AA 20 C0 00 68 44 03 68 08 99 C9 18 08 91 30 1C 49 46 8D 4A 8D 4B ?? ?? ?? ?? 00 28 00 D0 8E E1 A9 23 08 9A DB 00 6B 44 1A 60 08 98 0D 99 10 9A 40 1A 11 90 47 2A 00 D1 40 E1 67 2A 00 D1 3D E1 10 99 65 29 00 DC EC E1 10 9E 66 2E 00 D1 18 E2 AA 20 C0 00 68 44 00 68 09 90 11 9B 09 9E B3 42 00 DD E4 E1 05 98 C0 07 00 D5 28 E2 08 96 00 2E 00 DA 7D E2 67 22 10 92 0C 9A 00 2A 00 D1 13 E1 2D 23 56 46 00 20 33 70 0F 90 FF F7 DE FA 46 46 50 46 00 21 08 96 03 78 09 96 0F 91 FF F7 D2 FA 07 9A 07 99 13 68 0A 9E 89 46 04 21 }
	condition:
		$1
}

rule file_424_0_0 {
	meta:
		name = "_strtoul_r"
		size = 344
		refs = "004c __umodsi3 005a __udivsi3 0154 __ctype_ptr__"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 1F 1C 51 4B 85 B0 04 90 01 91 1E 68 02 92 0C 1C 08 22 25 78 73 19 5B 78 01 34 13 42 F9 D1 2D 2D 00 D1 74 E0 2B 2D 00 D1 76 E0 00 22 03 92 7B 42 7B 41 10 2F 4F D0 00 2B 4D D1 01 20 40 42 39 1C ?? ?? ?? ?? BA 46 80 46 01 20 51 46 40 42 ?? ?? ?? ?? 04 22 94 46 03 22 91 46 01 22 01 1C 00 23 00 20 93 46 00 97 12 E0 00 9A 30 3D 95 42 1E DA 88 42 3C D8 00 2B 3A DB 45 45 01 DD 88 42 36 D0 03 1C 50 46 58 43 01 23 28 18 25 78 01 34 72 19 52 78 67 46 3A 42 E7 D1 4F 46 3A 42 07 D0 5F 46 3A 42 27 D1 57 22 AD 1A 00 9A 95 42 E0 DB 5F 1C 28 D0 03 9A 00 2A 23 D1 02 9F 00 2F 04 D0 00 2B 1B D1 01 99 02 9A 11 60 05 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 30 2D 23 D0 00 2B AD D0 30 2D 2C D0 05 22 0A 23 90 46 9A 46 0A 27 AC E7 01 23 5B 42 CA E7 37 22 AD 1A D6 E7 01 3C 01 94 E0 E7 40 42 D9 E7 04 99 22 22 0A 60 18 1C D4 E7 01 21 25 78 01 34 03 91 8A E7 00 23 25 78 01 34 03 93 85 E7 22 78 58 2A 01 D0 78 2A D6 D1 0F 27 10 21 65 78 B8 46 02 34 8A 46 10 27 85 E7 07 27 08 21 B8 46 8A 46 08 27 7F E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_425_0_0 {
	meta:
		name = "ldiv"
		size = 58
		refs = "000c __divsi3 0016 __modsi3"
		altNames = "div"
	strings:
		$1 = { F0 B5 0D 1C 04 1C 08 1C 11 1C 16 1C ?? ?? ?? ?? 31 1C 07 1C 28 1C ?? ?? ?? ?? 00 2D 05 DB 00 28 08 DB 60 60 27 60 20 1C F0 BD 00 28 F9 DD 01 3F 80 19 F6 E7 01 37 80 1B F3 E7 }
	condition:
		$1
}

rule file_426_0_0 {
	meta:
		name = "_wrapup_reent"
		size = 72
		refs = "0044 _impure_ptr"
	strings:
		$1 = { F0 B5 07 1C 00 28 1A D0 A4 23 5B 00 FE 58 00 2E 0E D0 73 68 5C 1E 08 D4 5D 1C AD 00 75 19 2B 68 00 F0 6C F8 04 3D 01 3C F9 D5 36 68 00 2E F0 D1 FB 6B 00 2B 02 D0 38 1C 00 F0 60 F8 F0 BD 01 4B 1F 68 E1 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_426_1_0 {
	meta:
		name = "cleanup_glue"
		size = 26
		refs = "000c cleanup_glue 0014 _free_r"
	strings:
		$1 = { 30 B5 0C 1C 09 68 05 1C 00 29 01 D0 ?? ?? ?? ?? 28 1C 21 1C ?? ?? ?? ?? 30 BD }
	condition:
		$1
}

rule file_426_2_0 {
	meta:
		name = "_reclaim_reent"
		size = 152
		refs = "001e _free_r 008e cleanup_glue 0094 _impure_ptr"
	strings:
		$1 = { 70 B5 24 4B 1B 68 05 1C 98 42 35 D0 C3 6C 00 2B 11 D0 00 26 99 59 00 29 06 D0 0C 68 28 1C ?? ?? ?? ?? 21 1E F9 D1 EB 6C 04 36 3C 2E F2 D1 28 1C 19 1C ?? ?? ?? ?? 29 6C 00 29 02 D0 28 1C ?? ?? ?? ?? A4 23 5B 00 E9 58 00 29 0C D0 A6 23 5B 00 EE 18 B1 42 01 D1 06 E0 21 1C 0C 68 28 1C ?? ?? ?? ?? A6 42 F8 D1 69 6D 00 29 02 D0 28 1C ?? ?? ?? ?? AB 6B 00 2B 00 D1 70 BD EB 6B 28 1C 00 F0 0B F8 B8 23 9B 00 E9 58 00 29 F5 D0 28 1C ?? ?? ?? ?? F1 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_427_0_0 {
	meta:
		name = "wcswidth"
		size = 56
		refs = "0024 wcwidth"
	strings:
		$1 = { 70 B5 06 1C 0C 1C 00 29 13 D0 00 28 11 D0 00 25 07 E0 33 68 2D 18 00 2B 0C D0 01 3C 00 2C 09 D0 04 36 30 68 ?? ?? ?? ?? 00 28 F2 DA 01 25 6D 42 00 E0 00 25 28 1C 70 BD }
	condition:
		$1
}

rule file_428_0_0 {
	meta:
		name = "isxdigit"
		size = 20
		refs = "0010 __ctype_ptr__"
	strings:
		$1 = { 03 4B 1B 68 18 18 40 78 44 23 18 40 70 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_0_0 {
	meta:
		name = "finitef"
		size = 28
	strings:
		$1 = { 04 4A 03 1C 13 40 04 4A D8 0F 00 21 9A 42 48 41 70 47 C0 46 FF FF FF 7F FF FF 7F 7F }
	condition:
		$1
}

rule file_430_0_0 {
	meta:
		name = "__fix_locale_grouping_str"
		size = 164
		refs = "009c __ctype_ptr__"
	strings:
		$1 = { F0 B5 47 46 80 B4 00 28 35 D0 03 78 00 2B 32 D0 22 4A 94 46 01 22 52 42 04 1C 01 1C 04 27 90 46 08 E0 0A 1C 23 70 00 2B 23 D0 01 34 53 78 51 1C 00 2B 29 D0 3B 2B 22 D0 2D 2B 27 D0 62 46 15 68 EA 18 52 78 3A 42 16 D0 4E 78 AD 19 30 3B 6D 78 1B 06 1B 0E 4A 1C 3D 42 E3 D0 99 00 CB 18 5B 00 F3 18 D0 21 1B 06 09 06 5B 18 1B 0E 23 70 00 2B DB D1 84 42 00 D1 0A 48 04 BC 90 46 F0 BD 0A 1C 53 78 51 1C 00 2B D5 D1 23 70 F5 E7 4D 78 4A 1C 31 2D D3 D1 43 46 23 70 01 34 C7 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_431_0_0 {
	meta:
		name = "a64l"
		size = 108
	strings:
		$1 = { 10 B5 00 28 23 D0 03 1C 00 22 19 78 00 29 00 D0 01 33 01 32 06 2A F8 D1 98 42 25 D2 00 21 06 E0 41 2A 17 D3 35 3A 89 01 51 18 98 42 0E D2 01 3B 1A 78 5A 2A F4 D9 14 1C 61 3C 24 06 24 0E 19 2C 06 D9 00 22 89 01 51 18 98 42 F0 D3 08 1C 10 BD 1B 3A E8 E7 2F 2A 05 D0 2F 2A F2 D3 39 2A F0 D8 2E 3A E0 E7 01 22 DE E7 00 20 F0 E7 }
	condition:
		$1
}

rule file_432_1_0 {
	meta:
		name = "_fputc_r"
		size = 34
		refs = "0012 __sinit 001c _putc_r"
	strings:
		$1 = { 70 B5 04 1C 0E 1C 15 1C 00 28 04 D0 83 6B 00 2B 01 D1 ?? ?? ?? ?? 31 1C 2A 1C 20 1C ?? ?? ?? ?? 70 BD }
	condition:
		$1
}

rule file_436_0_0 {
	meta:
		name = "_system_r"
		size = 24
		refs = "000a __errno"
	strings:
		$1 = { 00 B5 00 29 01 D1 00 20 00 BD ?? ?? ?? ?? 58 23 03 60 01 20 40 42 F7 E7 }
	condition:
		$1
}

rule file_437_0_0 {
	meta:
		name = "qsort"
		size = 1456
		refs = "0128 __udivsi3 0350 qsort"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 89 B0 92 46 99 46 03 23 01 91 91 08 1A 40 53 46 04 3B 03 91 19 1C 4B 1E 99 41 80 46 06 92 08 91 52 46 43 46 03 21 57 42 0B 42 7E D1 06 9A 00 2A 7B D1 08 9B 01 9A 9B 46 06 2A 7B D9 01 9B 5D 08 29 1C 55 46 4D 43 45 44 07 2B 00 D0 30 E1 2C 1C 06 26 59 46 00 29 00 D0 5A E1 42 46 13 68 22 68 41 46 0A 60 23 60 55 46 75 43 C4 46 D4 44 63 46 00 21 45 44 04 93 02 93 00 91 2C 1C 66 46 A6 42 00 D8 A1 E0 00 9A 00 2A 00 D1 28 E2 01 99 53 46 4B 43 43 44 01 93 02 9B 02 9A F3 1A 00 93 43 46 D1 1A 00 9A 91 42 00 DD 11 1C 00 29 13 DD 5B 46 72 1A 02 2B 00 D0 9F E1 40 46 00 23 A8 46 A4 46 0D 1C C1 5C D4 5C C4 54 D1 54 01 33 9D 42 F8 D1 45 46 64 46 80 46 01 99 2C 1B 52 46 4D 1B AD 1A A5 42 00 D9 25 1C 00 2D 0D DD 01 9B 59 46 5A 1B 02 29 00 D0 8E E1 00 23 F1 5C D0 5C F0 54 D1 54 01 33 AB 42 F8 D1 00 9A 92 45 00 D2 12 E1 A2 45 53 D2 01 9B 51 46 1B 1B 20 1C 98 46 ?? ?? ?? ?? 43 46 03 21 01 90 0B 42 80 D0 01 9A 02 21 8B 46 06 2A 83 D8 53 46 53 43 46 46 43 44 56 44 01 93 9E 42 3A D2 52 46 B2 18 53 46 00 92 5F 42 B0 45 29 D2 F4 19 25 1C 0A E0 E3 1B 1A 68 29 68 19 60 2A 60 ED 19 EB 1B 98 45 1D D2 26 1C E4 19 20 1C 31 1C 00 F0 17 FA 00 28 15 DD 59 46 00 29 EB D0 5A 46 01 2A 00 D1 F9 E1 00 23 50 46 F2 5C E1 5C F1 54 E2 54 01 33 C2 1A 00 2A F7 DC ED 19 EB 1B 82 46 98 45 E1 D3 00 9E B4 46 D4 44 63 46 51 46 01 9A 00 93 5B 1A 9A 42 C9 D8 09 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 30 1C 41 46 00 F0 EA F9 00 28 0B DC 4D E0 23 68 2A 68 22 60 2B 60 01 21 00 91 ED 19 E4 19 A6 42 00 D9 4B E7 20 1C 41 46 00 F0 D8 F9 00 28 13 DB 00 28 F3 D1 5A 46 00 2A E9 D0 5B 46 01 2B 1A D0 00 23 50 46 E2 5C E9 5C E1 54 EA 54 01 33 C2 1A 00 2A F7 DC 82 46 DE E7 A6 42 00 D9 2E E7 5A 46 00 2A 13 D1 33 68 22 68 32 60 23 60 01 21 56 44 E4 19 00 91 1F E7 03 9A 00 23 E1 58 E8 58 01 3A E0 50 E9 50 04 33 00 2A F7 DC C4 E7 5B 46 01 2B 1F D0 00 23 50 46 F2 5C E1 5C F1 54 E2 54 01 33 C2 1A 00 2A F7 DC 82 46 E0 E7 00 28 0F D1 5A 46 00 2A 00 D0 AA E0 02 99 32 68 0B 68 0A 60 33 60 02 9B 9C 46 D4 44 63 46 01 21 02 93 00 91 56 44 F1 E6 03 9A 00 23 F1 58 E0 58 01 3A F0 50 E1 50 04 33 00 2A F7 DC C1 E7 01 9E 01 3E 53 46 73 43 43 44 00 93 01 9B 28 2B 43 D8 41 46 02 91 2C 1C 02 98 21 1C 00 F0 6A F9 00 28 0E DB 20 1C 00 99 00 F0 64 F9 00 28 00 DD B7 E6 02 98 00 99 00 F0 5D F9 00 28 0E DB 00 9C AF E6 20 1C 00 99 00 F0 55 F9 00 28 00 DA A8 E6 02 98 00 99 00 F0 4E F9 00 28 F0 DB 02 9C A0 E6 5A 46 01 2A 00 D1 88 E0 00 23 42 46 55 46 D1 5C E0 5C D0 54 E1 54 01 33 E9 1A 00 29 F7 DC 90 46 AA 46 98 E6 51 46 10 1C ?? ?? ?? ?? 52 46 01 1C 4B 46 40 46 ?? ?? ?? ?? E1 E6 01 99 CB 08 52 46 5A 43 14 1C 44 44 53 00 43 44 40 46 21 1C 05 92 02 93 00 F0 1F F9 00 28 6C DB 20 1C 02 99 00 F0 19 F9 00 28 00 DC AA E0 02 94 05 99 05 9A 49 42 6C 18 07 91 AA 18 20 1C 29 1C 04 92 00 F0 0A F9 00 28 00 DA 82 E0 28 1C 04 99 00 F0 03 F9 00 28 00 DC 8B E0 2C 1C 05 9B 00 99 07 9A 5D 00 4D 1B 8A 18 28 1C 11 1C 04 92 00 F0 F4 F8 00 28 50 DB 04 98 00 99 00 F0 EE F8 00 28 00 DC E1 E0 04 9B 00 93 79 E7 5A 46 01 2A 52 D0 02 9A A4 46 00 23 54 46 D1 5C F0 5C D0 54 F1 54 01 33 E1 1A 00 29 F7 DC A2 46 64 46 47 E7 40 46 89 08 00 23 A4 46 A8 46 C4 58 D5 58 01 39 C5 50 D4 50 04 33 00 29 F7 DC 5D E6 AD 08 00 23 F1 58 D0 58 01 3D F0 50 D1 50 04 33 00 2D F7 DC 6D E6 03 9A 00 23 41 46 C8 58 E5 58 01 3A CD 50 E0 50 04 33 00 2A F7 DC 88 46 10 E6 20 1C 02 99 00 F0 AC F8 00 28 93 DB 40 46 02 99 00 F0 A6 F8 00 28 8E DB 42 46 02 92 8B E7 04 98 00 99 00 F0 9D F8 00 28 AF DB 28 1C 00 99 00 F0 97 F8 00 28 00 DA 25 E7 00 95 23 E7 03 9A 02 99 00 23 A4 46 C8 58 F4 58 01 3A CC 50 F0 50 04 33 00 2A F7 DC 64 46 F5 E6 28 1C 04 99 00 F0 80 F8 00 28 00 DA 7C E7 20 1C 04 99 00 F0 79 F8 00 28 00 DB 76 E7 04 9C 74 E7 20 1C 04 99 00 F0 70 F8 00 28 00 DA 6D E7 04 9C 6B E7 40 46 02 99 00 F0 67 F8 00 28 00 DB 4E E7 BE E7 01 99 53 46 4B 43 04 99 43 44 01 93 99 42 00 D3 64 E6 51 44 53 46 00 91 04 9E 5F 42 B0 45 28 D2 F4 19 25 1C 0A E0 E3 1B 1A 68 29 68 19 60 2A 60 ED 19 EB 1B 98 45 1C D2 26 1C E4 19 20 1C 31 1C 00 F0 41 F8 00 28 14 DD 59 46 00 29 EB D0 5A 46 01 2A 19 D0 00 23 50 46 F2 5C E1 5C F1 54 E2 54 01 33 C2 1A 00 2A F7 DC ED 19 EB 1B 82 46 98 45 E2 D3 00 9E B4 46 D4 44 63 46 51 46 01 9A 00 93 5B 1A 9A 42 CA D8 29 E6 03 9A 00 23 F1 58 E0 58 01 3A F0 50 E1 50 04 33 00 2A F7 DC C8 E7 03 9A 00 23 F1 58 E0 58 01 3A F0 50 E1 50 04 33 00 2A F7 DC E7 E5 28 1C 00 99 00 F0 05 F8 00 28 00 DB 93 E6 00 95 91 E6 }
	condition:
		$1
}

rule file_439_0_0 {
	meta:
		name = "_mallopt_r"
		size = 100
		refs = "0008 __malloc_lock 001a __malloc_unlock 005c __malloc_trim_threshold 0060 __malloc_top_pad"
	strings:
		$1 = { 70 B5 0C 1C 05 1C 16 1C ?? ?? ?? ?? E3 1C 1A D0 E3 1C 06 DC 04 34 1B D0 28 1C ?? ?? ?? ?? 00 20 70 BD A3 1C 08 D0 01 34 F6 D1 0C 4B 28 1C 1E 60 ?? ?? ?? ?? 01 20 F3 E7 09 4B 28 1C 1E 60 ?? ?? ?? ?? 01 20 EC E7 28 1C ?? ?? ?? ?? 01 20 E7 E7 28 1C ?? ?? ?? ?? 70 42 70 41 E1 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_440_0_0 {
	meta:
		name = "iswprint"
		size = 28
		refs = "0018 __ctype_ptr__"
	strings:
		$1 = { FF 28 06 D8 04 4B 1B 68 18 18 40 78 97 23 18 40 70 47 00 20 FC E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_441_0_0 {
	meta:
		name = "open"
		size = 40
		refs = "0016 _open_r 0024 _impure_ptr"
	strings:
		$1 = { 0E B4 00 B5 81 B0 02 AB 04 CB 01 1C 05 48 04 33 00 93 00 68 03 9B ?? ?? ?? ?? 01 B0 08 BC 03 B0 18 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_442_0_0 {
	meta:
		name = "iswblank"
		size = 16
		refs = "000a isblank"
	strings:
		$1 = { 00 B5 FF 28 01 D9 00 20 00 BD ?? ?? ?? ?? FB E7 }
	condition:
		$1
}

rule file_443_0_0 {
	meta:
		name = "_fseek_r"
		size = 776
		refs = "007e _fstat_r 00ee _fflush_r 017e _free_r 019a __srefill_r 01ba memset 01c2 __sinit 0298 __smakebuf_r 0300 __sseek"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 90 B0 05 1C 0C 1C 91 46 1E 1C 00 28 03 D0 83 6B 00 2B 00 D1 CF E0 A2 89 84 23 5B 00 1A 40 9A 42 00 D1 D1 E0 A0 6A 82 46 00 28 00 D1 31 E1 01 2E 55 D0 02 2E 01 D0 00 2E 46 D1 00 22 23 69 93 46 90 46 00 2B 00 D1 1F E1 A2 89 A9 49 0A 42 00 D0 F2 E0 80 27 FF 00 3A 42 1D D1 A6 4B 9A 45 00 D0 00 E1 E1 89 09 04 09 14 00 29 00 DA FA E0 28 1C 01 AA ?? ?? ?? ?? 00 28 00 D0 F2 E0 F0 23 02 9A 1B 02 1A 40 80 23 1B 02 9A 42 00 D0 E9 E0 A3 89 E7 64 1F 43 A7 81 00 2E 00 D0 D6 E0 4F 46 58 46 00 28 38 D1 A3 89 DA 04 00 D4 BB E0 23 6D 62 68 21 6B 00 92 9A 1A 90 46 00 29 00 D1 D9 E0 E3 6B D2 1A 9B 46 90 46 2E E0 16 23 01 20 2B 60 40 42 10 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 28 1C 21 1C ?? ?? ?? ?? A3 89 DA 04 00 D4 D6 E0 20 6D 80 46 58 07 00 D5 89 E0 1A 07 00 D4 90 E0 22 68 00 2A 00 D1 8C E0 23 69 D2 1A 90 44 01 20 C1 44 83 46 00 26 95 E7 21 6B 00 29 00 D1 A7 E0 62 68 E3 6B 00 92 9B 46 20 69 00 9B A2 6B 84 46 12 1A 18 1C 40 44 83 1A 5A 44 9F 42 02 DB 98 18 87 42 47 D3 E3 6C 5B 42 3B 40 98 46 1A 1C E1 69 28 1C 00 23 00 F0 E1 F8 01 30 6E D0 00 23 63 60 21 6B 23 69 23 60 00 29 08 D0 23 1C 40 33 99 42 02 D0 28 1C ?? ?? ?? ?? 00 23 23 63 A3 89 20 22 93 43 42 46 BF 1A A3 81 00 2F 0D D0 28 1C 21 1C ?? ?? ?? ?? 00 28 50 D1 63 68 9F 42 4D D8 22 68 D2 19 DF 1B 22 60 67 60 20 1C 5C 30 00 21 08 22 ?? ?? ?? ?? 00 20 8C E7 ?? ?? ?? ?? A2 89 84 23 5B 00 1A 40 9A 42 00 D0 2D E7 28 1C 21 1C ?? ?? ?? ?? 28 E7 FF 1A 60 46 C3 19 D2 1B 23 60 62 60 00 29 08 D0 23 1C 40 33 99 42 02 D0 28 1C ?? ?? ?? ?? 00 23 23 63 A3 89 20 22 93 43 20 1C A3 81 5C 30 00 21 08 22 ?? ?? ?? ?? 00 20 61 E7 63 68 42 46 D2 1A 23 6B 90 46 00 2B 02 D0 E3 6B D0 1A 80 46 23 69 73 E7 01 23 E1 69 28 1C 00 22 00 F0 74 F8 03 1C 58 1C 00 D0 3A E7 28 1C 21 1C ?? ?? ?? ?? 00 28 37 D0 01 20 40 42 42 E7 01 AF 0E 23 E1 5E 28 1C 3A 1C ?? ?? ?? ?? 00 28 ED D1 3F 69 4F 44 1D E7 A2 89 80 23 1B 01 1A 43 A2 81 E4 E7 60 68 00 90 20 69 22 68 84 46 13 1A 40 46 9B 46 C3 1A 00 98 02 1C 5A 44 57 E7 28 1C 21 1C ?? ?? ?? ?? DA E6 1D 23 01 20 2B 60 40 42 19 E7 00 22 E1 69 28 1C 01 23 00 F0 38 F8 02 1C 80 46 01 32 C9 D0 A3 89 1E E7 E1 69 28 1C 4A 46 33 1C 00 F0 2C F8 01 30 BF D0 21 6B 00 29 08 D0 23 1C 40 33 99 42 02 D0 28 1C ?? ?? ?? ?? 00 23 23 63 23 69 23 60 00 23 A2 89 63 60 04 4B 13 40 A3 81 5B E7 C0 46 1A 08 00 00 ?? ?? ?? ?? DF F7 FF FF }
	condition:
		$1
}

rule file_444_0_0 {
	meta:
		name = "isupper"
		size = 20
		refs = "0010 __ctype_ptr__"
	strings:
		$1 = { 03 4B 1B 68 18 18 40 78 01 23 18 40 70 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_445_0_0 {
	meta:
		name = "getwchar"
		size = 20
		refs = "0008 fgetwc 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 1B 68 58 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_445_1_0 {
	meta:
		name = "_getwchar_r"
		size = 20
		refs = "0008 _fgetwc_r 0010 _impure_ptr"
	strings:
		$1 = { 00 B5 03 4B 1B 68 59 68 ?? ?? ?? ?? 00 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_446_0_0 {
	meta:
		name = "_puts_r"
		size = 104
		refs = "000a strlen 0048 __sfvwrite_r 005c _impure_ptr"
	strings:
		$1 = { 70 B5 87 B0 04 1C 08 1C 0D 1C ?? ?? ?? ?? 13 4B 1B 68 9A 68 80 23 91 89 9B 01 19 42 05 D1 0B 43 93 81 51 6E 0E 4B 0B 40 53 66 43 1C 01 90 0D 48 04 AA 02 26 02 90 01 20 93 60 03 90 6B 46 A1 68 56 60 20 1C 04 93 00 95 ?? ?? ?? ?? 00 28 02 D1 0A 20 07 B0 70 BD 01 20 40 42 FA E7 ?? ?? ?? ?? FF DF FF FF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_449_0_0 {
	meta:
		name = "strcpy"
		size = 72
	strings:
		$1 = { 70 B5 0B 1C 03 43 9A 07 07 D0 04 1C 00 23 CA 5C E2 54 01 33 00 2A FA D1 70 BD 0B 68 08 4D 5C 19 08 4D 9C 43 02 1C 2C 42 07 D1 08 C2 04 31 0B 68 03 4E 9C 19 9C 43 2C 42 F7 D0 14 1C E6 E7 C0 46 FF FE FE FE 80 80 80 80 }
	condition:
		$1
}

rule file_450_0_0 {
	meta:
		name = "isalpha"
		size = 20
		refs = "0010 __ctype_ptr__"
	strings:
		$1 = { 03 4B 1B 68 18 18 40 78 03 23 18 40 70 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_452_0_0 {
	meta:
		name = "first_day"
		size = 20
	strings:
		$1 = { 03 4B 98 42 01 DD 01 20 70 47 04 20 FC E7 C0 46 B2 07 00 00 }
	condition:
		$1
}

rule file_452_1_0 {
	meta:
		name = "match_string"
		size = 72
		refs = "0020 strlen 002c strncasecmp"
	strings:
		$1 = { F0 B5 47 46 80 B4 06 1C 08 68 0D 1C 00 28 15 D0 0C 1D 00 27 04 E0 25 1C 01 CC 01 37 00 28 0D D0 ?? ?? ?? ?? 80 46 29 68 30 68 42 46 ?? ?? ?? ?? 00 28 F0 D1 33 68 43 44 33 60 01 E0 01 27 7F 42 38 1C 04 BC 90 46 F0 BD }
	condition:
		$1
}

rule file_452_2_0 {
	meta:
		name = "strptime"
		size = 1068
		refs = "00a8 strtol 00c8 strptime 021a __modsi3 0310 __ctype_ptr__"
	strings:
		$1 = { F0 B5 84 B0 02 90 0B 78 16 1C 00 2B 1C D0 BF 4F BF 4D 28 37 28 68 C2 18 54 78 08 22 14 42 16 D0 02 9B 1C 78 04 19 64 78 14 42 08 D0 01 33 08 24 02 93 1A 78 82 18 52 78 01 33 22 42 F8 D1 0C 1C 63 78 61 1C 00 2B E5 D1 02 98 04 B0 F0 BD 25 2B 1F D1 4A 78 4C 1C 00 2A 1B D0 4F 2A 16 D0 45 2A 14 D0 79 2A 07 D9 02 9B 19 78 25 29 00 D0 C3 E1 01 33 02 93 E4 E7 A7 49 93 00 CB 58 9F 46 01 3C 02 9B 1A 78 25 2A F3 D0 00 20 DE E7 01 34 22 78 E7 E7 02 9A 10 78 98 42 F6 D1 01 32 02 92 0C 1C CE E7 0A 22 02 98 03 A9 ?? ?? ?? ?? 03 9B 02 9A 93 42 E9 D0 45 28 00 DD 98 E1 64 30 70 61 02 93 BE E7 02 98 94 49 32 1C ?? ?? ?? ?? 00 28 DB D0 03 90 02 90 B4 E7 0A 22 02 98 03 A9 ?? ?? ?? ?? 03 9B 02 9A 93 42 CF D0 B0 61 02 93 A8 E7 0A 22 02 98 03 A9 ?? ?? ?? ?? 03 9B 02 9A 93 42 C3 D0 01 38 B0 61 02 93 9B E7 02 9B 1A 78 09 2A BB D1 01 33 02 93 94 E7 02 98 80 49 32 1C ?? ?? ?? ?? 00 28 D5 D1 00 20 90 E7 02 A8 39 1C FF F7 44 FF 00 28 A9 DB B3 68 00 2B 00 D0 5A E1 01 28 00 D0 7E E7 0C 23 B3 60 7B E7 02 9B 1A 78 0A 2A 9B D1 01 33 8E E7 02 98 72 49 32 1C ?? ?? ?? ?? 00 28 B6 D1 00 20 71 E7 02 A8 6E 49 FF F7 25 FF 00 28 8A DB 30 61 64 E7 02 A8 6B 49 FF F7 1D FF 00 28 82 DB B0 61 5C E7 0A 22 02 98 03 A9 ?? ?? ?? ?? 03 9B 02 9A 93 42 00 D1 76 E7 64 4A 80 18 70 61 02 93 4D E7 0A 22 02 98 03 A9 ?? ?? ?? ?? 03 9B 02 9A 93 42 00 D1 67 E7 01 38 F0 61 02 93 3F E7 0A 22 02 98 03 A9 ?? ?? ?? ?? 03 9B 02 9A 93 42 00 D1 59 E7 F0 60 02 93 32 E7 0A 22 02 98 03 A9 ?? ?? ?? ?? 03 9B 02 9A 93 42 00 D1 4C E7 01 38 30 61 02 93 24 E7 0A 22 02 98 03 A9 ?? ?? ?? ?? 02 9B 03 9A 00 90 9A 42 00 D1 3D E7 48 4B 70 69 C0 18 FF F7 C7 FE 07 21 06 30 ?? ?? ?? ?? 01 90 00 98 C3 00 1B 1A B0 69 07 21 06 30 00 93 ?? ?? ?? ?? 00 9A 13 18 01 98 1B 1A F3 61 00 2B 00 DA E6 E0 03 9B 02 93 FB E6 0A 22 02 98 03 A9 ?? ?? ?? ?? 02 9B 03 9A 00 90 9A 42 00 D1 14 E7 70 69 33 4A 80 18 FF F7 9E FE 07 21 06 30 ?? ?? ?? ?? 03 28 00 DD B8 E0 07 22 00 9B 01 3B D9 00 CB 1A B1 69 5B 18 1B 1A 9B 18 F3 61 00 2B D9 DA 00 23 B0 61 F3 61 D5 E7 0A 22 02 98 03 A9 ?? ?? ?? ?? 02 9B 03 9A 00 90 9A 42 00 D1 ED E6 20 4B 70 69 C0 18 FF F7 77 FE 00 9B DA 00 D2 1A B3 69 D3 18 1B 1A F3 61 00 2B BC DA E1 E7 02 98 19 49 32 1C ?? ?? ?? ?? 00 28 00 D0 FA E6 00 20 B5 E6 0A 22 02 98 03 A9 ?? ?? ?? ?? 03 9B 02 9A 93 42 00 D1 CA E6 B0 60 02 93 A3 E6 02 98 0F 49 32 1C ?? ?? ?? ?? 00 28 00 D0 E3 E6 00 20 9E E6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 94 F8 FF FF 6C 07 00 00 ?? ?? ?? ?? ?? ?? ?? ?? 0A 22 02 98 03 A9 ?? ?? ?? ?? 03 9B 02 9A 93 42 00 D1 9B E6 64 22 50 43 31 4A 80 18 70 61 02 93 70 E6 02 A8 2F 49 FF F7 29 FE 00 28 00 DA 8D E6 30 61 67 E6 02 A8 2C 49 FF F7 20 FE 00 28 00 DA 84 E6 B0 61 5E E6 0A 22 02 98 03 A9 ?? ?? ?? ?? 03 9B 02 9A 93 42 00 D1 78 E6 30 60 02 93 51 E6 02 98 22 49 32 1C ?? ?? ?? ?? 00 28 00 D0 91 E6 00 20 4C E6 0A 22 02 98 03 A9 ?? ?? ?? ?? 03 9B 02 9A 93 42 00 D1 61 E6 70 60 02 93 3A E6 0A 22 02 98 03 A9 ?? ?? ?? ?? 03 9B 02 9A 93 42 00 D1 54 E6 0C 28 12 D0 B0 60 02 93 2B E6 00 22 45 E7 70 61 02 93 26 E6 0C 33 B3 60 23 E6 01 33 02 93 19 78 91 42 00 D0 41 E6 01 33 34 E6 00 22 B2 60 02 93 17 E6 07 21 01 30 ?? ?? ?? ?? 39 E7 C0 46 94 F8 FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_453_0_0 {
	meta:
		name = "_gettemp"
		size = 304
		refs = "0014 _getpid_r 0032 __umodsi3 003e __udivsi3 0078 _open_r 00d4 _stat_r 0128 __ctype_ptr__"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0E 1C 8F B0 80 46 92 46 ?? ?? ?? ?? 33 78 00 2B 64 D1 37 1C 7C 1E 23 78 58 2B 19 D1 05 1C 00 E0 1C 1C 28 1C 0A 21 ?? ?? ?? ?? 30 30 20 70 0A 21 28 1C ?? ?? ?? ?? 63 1E 1A 78 05 1C 58 2A EF D0 27 1C 1C 1C A6 42 05 D2 23 78 2F 2B 4F D0 01 3C A6 42 F9 D3 04 20 31 4D 61 24 81 46 52 46 00 2A 2F D0 C0 23 5B 00 40 46 31 1C 2D 4A ?? ?? ?? ?? 53 46 18 60 00 28 4E DA 40 46 03 68 11 2B 0D D1 3A 78 00 2A 0A D0 7A 2A 10 D1 3B 1C 01 E0 7A 2A 0D D1 1C 70 01 33 1A 78 00 2A F8 D1 00 20 0F B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 3B 1C 29 68 89 18 49 78 48 46 01 42 16 D0 52 46 1C 70 00 2A CF D1 40 46 31 1C 6A 46 ?? ?? ?? ?? 00 28 D7 D0 42 46 10 68 02 38 43 42 58 41 E0 E7 37 1C 01 37 3B 78 00 2B FB D1 95 E7 01 32 1A 70 B6 E7 00 23 23 70 40 46 31 1C 6A 46 ?? ?? ?? ?? 00 28 CD D1 01 9B 58 04 02 D5 2F 23 23 70 A3 E7 14 23 42 46 13 60 00 20 C3 E7 01 20 C1 E7 C0 46 ?? ?? ?? ?? 02 0A 00 00 }
	condition:
		$1
}

rule file_453_1_0 {
	meta:
		name = "mktemp"
		size = 32
		refs = "001c _impure_ptr"
	strings:
		$1 = { 10 B5 06 4B 04 1C 21 1C 18 68 00 22 FF F7 60 FF 00 28 00 D1 00 24 20 1C 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_453_2_0 {
	meta:
		name = "mkstemp"
		size = 36
		refs = "0020 _impure_ptr"
	strings:
		$1 = { 00 B5 07 4B 81 B0 01 1C 6A 46 18 68 FF F7 50 FF 00 28 02 D0 00 98 01 B0 00 BD 01 20 40 42 FA E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_453_3_0 {
	meta:
		name = "_mktemp_r"
		size = 20
	strings:
		$1 = { 10 B5 00 22 0C 1C FF F7 41 FF 00 28 00 D1 00 24 20 1C 10 BD }
	condition:
		$1
}

rule file_453_4_0 {
	meta:
		name = "_mkstemp_r"
		size = 26
	strings:
		$1 = { 00 B5 81 B0 6A 46 FF F7 37 FF 00 28 02 D0 00 98 01 B0 00 BD 01 20 40 42 FA E7 }
	condition:
		$1
}

rule file_454_0_0 {
	meta:
		name = "setbuffer"
		size = 20
		refs = "000a setvbuf"
	strings:
		$1 = { 00 B5 13 1C 00 29 03 D0 00 22 ?? ?? ?? ?? 00 BD 02 22 FA E7 }
	condition:
		$1
}

rule file_455_0_0 {
	meta:
		name = "wcspbrk"
		size = 46
	strings:
		$1 = { 30 B5 04 68 00 2C 10 D0 0D 68 00 2D 09 D0 A5 42 0C D0 0B 1C 01 E0 94 42 08 D0 04 33 1A 68 00 2A F9 D1 04 30 04 68 00 2C EF D1 00 20 30 BD }
	condition:
		$1
}

rule file_456_0_0 {
	meta:
		name = "_calloc_r"
		size = 88
		refs = "0004 _malloc_r 0052 memset"
	strings:
		$1 = { 10 B5 51 43 ?? ?? ?? ?? 04 1C 00 28 1E D0 03 1C 08 3B 5A 68 03 23 9A 43 04 3A 24 2A 18 D8 03 1C 13 2A 0E D9 00 21 02 C0 61 60 03 1D 1B 2A 08 D9 41 60 18 1D 59 60 03 1D 24 2A 02 D1 41 60 59 60 08 33 00 21 1A 1C 02 C2 59 60 51 60 20 1C 10 BD 00 21 ?? ?? ?? ?? F9 E7 }
	condition:
		$1
}

rule file_457_0_0 {
	meta:
		name = "_malloc_stats_r"
		size = 116
		refs = "000a __malloc_lock 000e __malloc_update_mallinfo 0032 __malloc_unlock 003e fiprintf 0060 __malloc_current_mallinfo 0064 __malloc_max_total_mem"
	strings:
		$1 = { F0 B5 47 46 80 B4 8A B0 04 1C ?? ?? ?? ?? ?? ?? ?? ?? 13 4A 13 4B 10 68 1E 68 6B 46 80 46 A1 CA A1 C3 A1 CA A1 C3 A1 CA A1 C3 12 68 20 1C 1A 60 07 9F ?? ?? ?? ?? E4 68 32 1C 20 1C 0A 49 ?? ?? ?? ?? 42 46 20 1C 09 49 ?? ?? ?? ?? 3A 1C 20 1C 07 49 ?? ?? ?? ?? 0A B0 04 BC 90 46 F0 BD C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_460_0_0 {
	meta:
		name = "__dorand48"
		size = 96
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 B2 23 C2 5A 0B 88 15 1C 5D 43 B8 24 04 5B 4E 88 2D 19 2C 0C A2 46 14 1C 74 43 B4 27 C7 5B A0 46 3C 1C 5C 43 A4 46 C4 44 E2 44 54 46 24 0C A4 46 8C 88 A0 46 14 1C 7E 43 42 46 62 43 92 19 B6 26 86 5B 73 43 D3 18 63 44 52 46 0D 80 4A 80 8B 80 0C BC 90 46 9A 46 F0 BD }
	condition:
		$1
}

rule file_461_0_0 {
	meta:
		name = "clock"
		size = 40
		refs = "000a _times_r 0024 _impure_ptr"
	strings:
		$1 = { 10 B5 08 4B 84 B0 18 68 69 46 ?? ?? ?? ?? 43 1C 06 D0 00 9B 01 98 C0 18 02 9B C0 18 03 9B C0 18 04 B0 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_462_0_0 {
	meta:
		name = "_reallocf_r"
		size = 34
		refs = "0006 _realloc_r 001c _free_r"
	strings:
		$1 = { 70 B5 06 1C 0D 1C ?? ?? ?? ?? 04 1C 00 28 01 D0 20 1C 70 BD 00 2D FB D0 30 1C 29 1C ?? ?? ?? ?? F6 E7 }
	condition:
		$1
}

rule file_464_0_0 {
	meta:
		name = "trecurse"
		size = 88
	strings:
		$1 = { 70 B5 43 68 04 1C 0D 1C 16 1C 00 2B 1D D0 20 1C 00 21 32 1C 00 F0 29 F8 60 68 00 28 03 D0 72 1C 29 1C FF F7 ED FF 20 1C 01 21 32 1C 00 F0 1D F8 A0 68 00 28 03 D0 72 1C 29 1C FF F7 E1 FF 20 1C 02 21 32 1C 00 F0 11 F8 70 BD 83 68 00 2B DE D1 03 21 00 F0 0A F8 F7 E7 }
	condition:
		$1
}

rule file_464_1_0 {
	meta:
		name = "twalk"
		size = 18
	strings:
		$1 = { 00 B5 00 29 04 D0 00 28 02 D0 00 22 FF F7 CC FF 00 BD }
	condition:
		$1
}

rule file_466_0_0 {
	meta:
		name = "_unsetenv_r"
		size = 100
		refs = "0016 strchr 0020 __env_lock 003e _findenv_r 0048 __env_unlock 0052 __errno 0060 environ"
	strings:
		$1 = { F0 B5 81 B0 05 1C 0C 1C 00 29 22 D0 0B 78 00 2B 1F D0 08 1C 3D 21 ?? ?? ?? ?? 00 28 19 D1 28 1C ?? ?? ?? ?? 0E 4E 07 E0 00 9B 32 68 9B 00 D3 18 5A 68 04 C3 00 2A FB D1 28 1C 21 1C 6A 46 ?? ?? ?? ?? 00 28 F0 D1 28 1C ?? ?? ?? ?? 00 20 01 B0 F0 BD ?? ?? ?? ?? 16 23 03 60 01 20 40 42 F6 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_466_1_0 {
	meta:
		name = "_setenv_r"
		size = 468
		refs = "001a strchr 0026 __env_lock 002c strlen 0038 _findenv_r 0084 _malloc_r 00d0 __env_unlock 00e0 strncmp 0118 strcmp 0120 tzset 0128 __errno 0162 _realloc_r 01a4 bcopy 01c4 environ"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 06 1C 0D 1C 08 1C 81 B0 3D 21 14 1C 98 46 ?? ?? ?? ?? 00 28 00 D0 81 E0 30 1C ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 29 1C 82 46 6A 46 30 1C ?? ?? ?? ?? 07 1C 00 28 00 D1 78 E0 41 46 00 29 50 D0 ?? ?? ?? ?? 82 45 57 D9 5C 4F 00 9B 3A 68 9B 00 91 46 9B 46 2B 78 3D 2B 00 D1 A3 E0 00 2B 00 D1 A0 E0 2B 1C 01 33 1A 78 3D 2A 01 D0 00 2A F9 D1 52 46 51 1B 02 31 59 18 30 1C ?? ?? ?? ?? 4B 46 5B 44 18 60 00 28 00 D1 91 E0 00 9A 3B 68 92 00 D3 58 2A 78 1A 70 00 2A 0B D0 3D 2A 09 D0 01 35 01 E0 3D 2A 05 D0 2A 78 01 33 1A 70 01 35 00 2A F7 D1 3D 22 1A 70 00 22 A1 5C 98 18 41 70 01 32 00 29 F9 D1 30 1C ?? ?? ?? ?? 00 9A 3B 68 92 00 D0 58 3A 49 03 22 ?? ?? ?? ?? 00 28 1B D0 00 20 03 E0 30 1C ?? ?? ?? ?? 00 20 01 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 23 E2 5C FA 54 01 33 00 2A FA D1 30 1C ?? ?? ?? ?? 28 1C 2D 49 ?? ?? ?? ?? 00 28 E3 D1 ?? ?? ?? ?? 00 20 E5 E7 ?? ?? ?? ?? 16 23 03 60 01 20 40 42 DE E7 23 4F 39 68 0B 68 00 2B 38 D0 00 22 0B 1C 90 46 01 22 04 33 90 44 1A 68 00 2A F9 D1 42 46 02 32 92 00 1D 4B 18 68 00 28 12 D0 30 1C ?? ?? ?? ?? 81 46 38 60 00 28 24 D0 43 46 9B 00 9B 46 43 46 01 33 00 22 9B 00 49 46 5A 50 42 46 00 92 6B E7 01 21 19 60 30 1C 11 1C ?? ?? ?? ?? 81 46 00 28 0F D0 41 46 89 00 8B 46 5A 46 38 68 49 46 ?? ?? ?? ?? 4A 46 3A 60 E2 E7 2B 1C 63 E7 08 22 98 46 CF E7 30 1C ?? ?? ?? ?? 01 20 40 42 97 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_469_0_0 {
	meta:
		name = "__getdelim"
		size = 208
		refs = "0034 realloc 006a getc_unlocked 00b8 __sinit 00be __errno 00cc _impure_ptr"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 81 46 88 46 17 1C 1E 1C 00 2B 53 D0 00 28 51 D0 00 29 4F D0 4A 46 12 68 92 46 00 2A 03 D0 42 46 13 68 03 2B 0E D8 50 46 80 21 ?? ?? ?? ?? 82 46 00 28 02 D1 01 20 40 42 20 E0 4B 46 18 60 42 46 80 23 13 60 1F 4B 18 68 00 28 02 D0 83 6B 00 2B 2D D0 43 46 1C 68 55 46 01 3C 00 2C 13 D0 30 1C ?? ?? ?? ?? 42 1C 03 D0 28 70 01 35 B8 42 F3 D1 53 46 9D 42 DE D0 00 22 2A 70 E8 1A 1C BC 90 46 99 46 A2 46 F0 BD 43 46 1C 68 64 00 50 46 21 1C ?? ?? ?? ?? 03 1C 00 28 EB D0 42 46 4B 46 14 60 52 46 18 60 AB 1A C5 18 E4 1A 82 46 D4 E7 ?? ?? ?? ?? CE E7 ?? ?? ?? ?? 16 23 03 60 01 20 40 42 DC E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_470_0_0 {
	meta:
		name = "_mbtowc_r"
		size = 46
	strings:
		$1 = { 81 B0 00 29 11 D0 00 2B 04 D1 00 2A 0B D0 02 20 40 42 06 E0 00 2A 06 D0 13 78 0B 60 10 78 43 1E 98 41 01 B0 70 47 00 20 FB E7 69 46 EB E7 }
	condition:
		$1
}

rule file_471_0_0 {
	meta:
		name = "memset"
		size = 144
	strings:
		$1 = { 70 B5 03 1C 84 07 0D D0 00 2A 40 D0 0D 06 01 3A 2D 0E 03 24 02 E0 00 2A 39 D0 01 3A 1D 70 01 33 23 42 F8 D1 03 2A 29 D9 FF 25 0D 40 2C 02 25 43 2C 04 1E 1C 25 43 0F 2A 12 D9 16 1C 1C 1C 10 3E 25 60 65 60 A5 60 E5 60 10 34 0F 2E F7 D8 10 3A 16 09 01 36 36 01 9E 19 0F 23 1A 40 03 2A 0C D9 00 23 F5 50 04 33 D4 1A 03 2C FA D8 04 3A 93 08 01 33 9B 00 F6 18 03 23 1A 40 33 1C 00 2A 06 D0 09 06 0C 0E 00 21 5C 54 01 31 8A 42 FB D1 70 BD }
	condition:
		$1
}

rule file_476_0_0 {
	meta:
		name = "_jrand48_r"
		size = 18
		refs = "0004 __dorand48"
	strings:
		$1 = { 10 B5 0C 1C ?? ?? ?? ?? A0 88 63 88 00 04 C0 18 10 BD }
	condition:
		$1
}

rule file_477_0_0 {
	meta:
		name = "feof"
		size = 36
		refs = "0012 __sinit 0020 _impure_ptr"
	strings:
		$1 = { 10 B5 07 4B 04 1C 18 68 00 28 04 D0 83 6B 00 2B 01 D1 ?? ?? ?? ?? A0 89 80 06 C0 0F 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_478_0_0 {
	meta:
		name = "_malloc_usable_size_r"
		size = 48
	strings:
		$1 = { 00 29 13 D0 08 39 4B 68 9A 07 0A D4 01 22 18 1C 90 43 09 18 49 68 11 42 08 D0 03 20 83 43 18 1F 03 E0 03 20 83 43 18 1C 08 38 70 47 00 20 FC E7 }
	condition:
		$1
}

rule file_480_0_0 {
	meta:
		name = "islower"
		size = 20
		refs = "0010 __ctype_ptr__"
	strings:
		$1 = { 03 4B 1B 68 18 18 40 78 02 23 18 40 70 47 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_0_0_1 {
	meta:
		name = "infinity"
		size = 16
	strings:
		$1 = { 02 49 01 48 70 47 C0 46 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_2_0_1 {
	meta:
		name = "erfcf"
		size = 1288
		refs = "0040 __mulsf3 004e __subsf3 0072 __addsf3 00ba __divsf3 00e2 __floatunsisf 010c fabsf 01f0 __ieee754_expf"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 C3 4C C3 4B 04 40 06 1C 05 1C 9C 42 62 DC C1 4B 9C 42 0C DD C1 4B 9C 42 00 DC 1A E1 C0 4B 9C 42 00 DC 6E E0 00 28 00 DC 6F E1 BD 48 5F E0 BD 4B 9C 42 61 DD 31 1C ?? ?? ?? ?? BB 49 04 1C ?? ?? ?? ?? BA 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? B8 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? B6 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? B4 49 ?? ?? ?? ?? B4 49 07 1C 20 1C ?? ?? ?? ?? B2 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? B0 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? AE 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? AC 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? AA 49 ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? A8 4B 01 1C 9E 42 00 DD B9 E0 30 1C ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 01 1C A1 48 ?? ?? ?? ?? 0C E0 C5 0F 68 00 ?? ?? ?? ?? 31 1C 04 1C 9C 48 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 1C BC 90 46 99 46 A2 46 F0 BD 31 1C 95 48 ?? ?? ?? ?? F5 E7 ?? ?? ?? ?? 07 1C 39 1C ?? ?? ?? ?? 01 1C 90 48 ?? ?? ?? ?? 90 4B 06 1C 9C 42 00 DC 60 E1 8F 4B 9C 42 02 DD 00 2D 00 DA EE E0 8D 49 30 1C ?? ?? ?? ?? 8C 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 8A 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 88 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 86 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 84 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 82 49 ?? ?? ?? ?? 81 49 81 46 30 1C ?? ?? ?? ?? 80 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 7E 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 7C 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 7A 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 78 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 76 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 62 49 ?? ?? ?? ?? 72 4C 80 23 1B 06 3C 40 21 1C 80 46 E0 18 ?? ?? ?? ?? 6F 49 ?? ?? ?? ?? ?? ?? ?? ?? 39 1C 82 46 20 1C ?? ?? ?? ?? 21 1C 06 1C 38 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 41 46 04 1C 48 46 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? ?? ?? ?? ?? 01 1C 50 46 ?? ?? ?? ?? 00 2D 00 DC 3A E1 39 1C ?? ?? ?? ?? 5D E7 30 1C ?? ?? ?? ?? 5A 49 04 1C 30 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 01 1C 55 48 ?? ?? ?? ?? 4D E7 ?? ?? ?? ?? 3E 49 ?? ?? ?? ?? 52 49 04 1C ?? ?? ?? ?? 51 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 4F 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 4D 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 4B 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 49 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 47 49 ?? ?? ?? ?? 46 49 06 1C 20 1C ?? ?? ?? ?? 45 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 43 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 41 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 3F 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 3D 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 19 49 ?? ?? ?? ?? 01 1C 00 2D 00 DA C8 E0 30 1C ?? ?? ?? ?? 01 1C 35 48 ?? ?? ?? ?? F1 E6 34 48 EF E6 FF FF FF 7F FF FF 7F 7F FF FF 57 3F FF FF 9F 3F FF FF DF 41 00 00 00 00 FF FF 7F 23 B1 56 C7 B7 89 14 BD 3B 8F 52 E9 3C EB 6B A6 3E D4 75 03 3E 1A E2 84 B6 49 EE 0A 39 16 81 A6 3B 63 2A 85 3D CE BB CB 3E 00 00 80 3F FF FF 7F 3E 6C DB 36 40 FF FF BF 40 75 C2 F1 C3 0B 23 80 44 41 64 1F 44 EA A2 20 43 4B 10 8E 41 D4 9D 4C 3F 92 A0 21 3C 12 87 B3 C1 A7 43 ED 43 CE 90 1F 45 BB FD 47 45 59 17 C0 44 71 E5 A2 43 59 B4 F2 41 00 F0 FF FF 00 00 10 3F 00 00 00 3F C0 F9 0D BB B3 51 11 3D C2 1C E3 3D 54 FE A2 3E 08 92 BE 3E 05 68 D4 3E C6 CD 1A 3B A3 5A 44 3C 13 6E 5F 3C 07 33 01 3E E7 1A 93 3D 85 57 0A 3F 31 F3 D9 3D D4 A7 1E 3E 00 00 00 40 33 49 ?? ?? ?? ?? 33 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 31 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 2F 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 2D 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 2B 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 29 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 27 49 ?? ?? ?? ?? 26 49 81 46 30 1C ?? ?? ?? ?? 25 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 23 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 21 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 1F 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 1D 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 1B 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 19 49 98 E6 30 1C ?? ?? ?? ?? 17 49 ?? ?? ?? ?? 17 49 ?? ?? ?? ?? 26 E6 39 1C ?? ?? ?? ?? 01 1C 14 48 ?? ?? ?? ?? 1E E6 C0 46 7E 07 1D C1 2B 93 A2 42 E7 9A 38 43 8C 65 22 43 57 80 79 42 22 F0 28 41 B7 A0 31 3F 93 A0 21 3C 97 7F 77 BD 7C 3F D2 40 1F 45 D9 42 0B 81 D6 43 C9 58 21 44 6F 48 D9 43 63 A8 09 43 CE 35 9D 41 0B 56 58 3F 00 00 80 3F 00 00 00 40 }
	condition:
		$1
}

rule file_2_1_1 {
	meta:
		name = "erff"
		size = 1268
		refs = "0048 __mulsf3 005a __addsf3 006e __floatsisf 0078 __divsf3 009e __subsf3 011e fabsf 01f4 __ieee754_expf"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 C0 4C C0 4B 04 40 06 1C 05 1C 9C 42 26 DC BE 4B 9C 42 0C DD BE 4B 9C 42 00 DC 17 E1 BD 4B 9C 42 00 DC 77 E0 00 28 00 DA 28 E2 BA 48 25 E0 BA 4B 9C 42 27 DC BA 4B 9C 42 00 DD 00 E1 B9 49 ?? ?? ?? ?? B8 49 04 1C 30 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? B5 49 ?? ?? ?? ?? 0E E0 C5 0F 6D 00 01 20 40 1B ?? ?? ?? ?? 31 1C 04 1C AA 48 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 1C BC 90 46 99 46 A2 46 F0 BD 31 1C ?? ?? ?? ?? A8 49 04 1C ?? ?? ?? ?? A7 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? A5 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? A3 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? A1 49 ?? ?? ?? ?? A1 49 05 1C 20 1C ?? ?? ?? ?? 9F 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 9D 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 9B 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 99 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 87 49 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 31 1C ?? ?? ?? ?? B2 E7 ?? ?? ?? ?? 07 1C 39 1C ?? ?? ?? ?? 01 1C 7C 48 ?? ?? ?? ?? 8B 4B 06 1C 9C 42 00 DC 4F E1 89 49 ?? ?? ?? ?? 89 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 87 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 85 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 83 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 81 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 7F 49 ?? ?? ?? ?? 7E 49 81 46 30 1C ?? ?? ?? ?? 7D 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 7B 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 79 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 77 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 75 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 73 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 52 49 ?? ?? ?? ?? 6F 4C 80 23 1B 06 3C 40 21 1C 80 46 E0 18 ?? ?? ?? ?? 6C 49 ?? ?? ?? ?? ?? ?? ?? ?? 39 1C 82 46 20 1C ?? ?? ?? ?? 21 1C 06 1C 38 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 41 46 04 1C 48 46 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? ?? ?? ?? ?? 01 1C 50 46 ?? ?? ?? ?? 00 2D 00 DA 30 E1 39 1C ?? ?? ?? ?? 01 1C 37 48 ?? ?? ?? ?? 1D E7 3F 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 16 E7 ?? ?? ?? ?? 31 49 ?? ?? ?? ?? 50 49 04 1C ?? ?? ?? ?? 4F 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 4D 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 4B 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 49 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 47 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 45 49 ?? ?? ?? ?? 45 49 06 1C 20 1C ?? ?? ?? ?? 43 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 41 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 3F 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 3D 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 3B 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 0B 49 ?? ?? ?? ?? 01 1C 00 2D 00 DA C5 E0 30 1C ?? ?? ?? ?? 34 49 ?? ?? ?? ?? BB E6 FF FF FF 7F FF FF 7F 7F FF FF 57 3F FF FF 9F 3F FF FF BF 40 00 00 80 3F FF FF 7F 31 FF FF FF 03 00 00 00 41 D4 75 83 3F 00 00 00 3E B1 56 C7 B7 89 14 BD 3B 8F 52 E9 3C EB 6B A6 3E D4 75 03 3E 1A E2 84 B6 49 EE 0A 39 16 81 A6 3B 63 2A 85 3D CE BB CB 3E 6D DB 36 40 75 C2 F1 C3 0B 23 80 44 41 64 1F 44 EA A2 20 43 4B 10 8E 41 D4 9D 4C 3F 92 A0 21 3C 12 87 B3 C1 A7 43 ED 43 CE 90 1F 45 BB FD 47 45 59 17 C0 44 71 E5 A2 43 59 B4 F2 41 00 F0 FF FF 00 00 10 3F C0 F9 0D BB B3 51 11 3D C2 1C E3 3D 54 FE A2 3E 08 92 BE 3E 05 68 D4 3E C6 CD 1A 3B A3 5A 44 3C 13 6E 5F 3C 07 33 01 3E E7 1A 93 3D 85 57 0A 3F 31 F3 D9 3D 0B 56 58 3F 32 49 ?? ?? ?? ?? 32 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 30 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 2E 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 2C 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 2A 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 28 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 26 49 ?? ?? ?? ?? 25 49 81 46 30 1C ?? ?? ?? ?? 24 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 22 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 20 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 1E 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 1C 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 1A 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 18 49 A2 E6 18 48 FC E5 30 1C ?? ?? ?? ?? 01 1C 16 48 ?? ?? ?? ?? F4 E5 39 1C ?? ?? ?? ?? 13 49 ?? ?? ?? ?? ED E5 7E 07 1D C1 2B 93 A2 42 E7 9A 38 43 8C 65 22 43 57 80 79 42 22 F0 28 41 B7 A0 31 3F 93 A0 21 3C 97 7F 77 BD 7C 3F D2 40 1F 45 D9 42 0B 81 D6 43 C9 58 21 44 6F 48 D9 43 63 A8 09 43 CE 35 9D 41 00 00 80 BF 0B 56 58 BF 00 00 80 3F }
	condition:
		$1
}

rule file_3_0_1 {
	meta:
		name = "__kernel_cos"
		size = 576
		refs = "001c __fixdfsi 002e __muldf3 0042 __adddf3 0052 __subdf3"
	strings:
		$1 = { F0 B5 47 46 80 B4 88 B0 02 92 03 93 75 4A 76 4B 02 40 90 46 06 1C 0F 1C 98 45 63 DC ?? ?? ?? ?? 00 28 00 D1 DB E0 32 1C 3B 1C 30 1C 39 1C ?? ?? ?? ?? 6E 4A 6E 4B 04 1C 0D 1C ?? ?? ?? ?? 6D 4A 6D 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 6B 4A 6B 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 69 4A 69 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 67 4A 67 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 65 4A 65 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 04 90 05 91 20 1C 29 1C 61 4A 61 4B ?? ?? ?? ?? 04 9A 05 9B 00 90 01 91 20 1C 29 1C ?? ?? ?? ?? 02 9A 03 9B 04 1C 0D 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 52 48 52 49 ?? ?? ?? ?? 71 E0 32 1C 3B 1C ?? ?? ?? ?? 3F 4A 40 4B 04 1C 0D 1C ?? ?? ?? ?? 3E 4A 3F 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 3C 4A 3D 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 3A 4A 3B 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 38 4A 39 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 36 4A 37 4B ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 38 4B 04 90 05 91 98 45 9F DD 37 4B 98 45 3B DD 36 49 37 4A 00 91 01 92 00 9A 01 9B 2F 48 30 49 ?? ?? ?? ?? 2B 4A 2C 4B 06 90 07 91 20 1C 29 1C ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 04 9A 05 9B 00 90 01 91 20 1C 29 1C ?? ?? ?? ?? 02 9A 03 9B 04 1C 0D 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 06 98 07 99 ?? ?? ?? ?? 08 B0 04 BC 90 46 F0 BD 1A 49 0A 1C 42 44 00 23 00 92 01 93 C0 E7 11 48 11 49 F1 E7 FF FF FF 7F FF FF 3F 3E E9 FA A8 BD D4 38 88 BE 9E EE 21 3E C4 B1 B4 BD 4F 7E 92 3E AD 52 9C 80 A0 01 FA 3E 90 15 CB 19 6C C1 56 3F 77 51 C1 16 55 55 A5 3F 4C 55 55 55 00 00 E0 3F 00 00 00 00 00 00 F0 3F 00 00 00 00 32 33 D3 3F 00 00 E9 3F 00 00 D2 3F 00 00 00 00 00 00 E0 FF }
	condition:
		$1
}

rule file_4_0_1 {
	meta:
		name = "fmodf"
		size = 212
		refs = "000c __ieee754_fmodf 001c isnanf 003e __eqsf2 0056 __extendsfdf2 007a __divdf3 0086 __errno 0098 __truncdfsf2 00aa matherr 00c0 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8B B0 05 1C 0C 1C ?? ?? ?? ?? 2B 4E 33 68 07 1C 01 33 04 D0 20 1C ?? ?? ?? ?? 00 28 04 D0 0B B0 38 1C 04 BC 90 46 F0 BD 28 1C ?? ?? ?? ?? 80 46 00 28 F4 D1 20 1C 21 49 ?? ?? ?? ?? 00 28 EE D1 01 23 02 93 1F 4B 02 AF 42 46 7B 60 3A 62 28 1C ?? ?? ?? ?? 00 90 01 91 B8 60 F9 60 20 1C ?? ?? ?? ?? 34 68 38 61 79 61 00 2C 16 D0 16 48 16 49 02 1C 0B 1C ?? ?? ?? ?? B8 61 F9 61 02 2C 10 D1 ?? ?? ?? ?? 21 23 03 60 3B 6A 00 2B 0F D1 B8 69 F9 69 ?? ?? ?? ?? 07 1C C1 E7 00 9B 01 9C BB 61 FC 61 38 1C ?? ?? ?? ?? 00 28 ED D1 E8 E7 ?? ?? ?? ?? 3B 6A 03 60 EA E7 C0 46 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_5_0_1 {
	meta:
		name = "ilogb"
		size = 112
	strings:
		$1 = { 30 B5 0A 1C 01 1C 14 48 14 4C 03 1C 0B 40 A3 42 06 DD 13 4A 93 42 02 DC 18 15 12 4B C0 18 30 BD 00 2B 08 D0 DB 02 00 2B 11 DD 0F 48 5B 00 01 38 00 2B FB DC F3 E7 00 2A 07 D0 00 2A 09 DD 0B 48 52 00 01 38 00 2A FB DC E9 E7 02 30 E7 E7 06 48 E5 E7 06 48 E3 E7 C0 46 FF FF FF 7F FF FF 0F 00 FF FF EF 7F 01 FC FF FF 02 FC FF FF ED FB FF FF }
	condition:
		$1
}

rule file_6_0_1 {
	meta:
		name = "__ieee754_rem_pio2"
		size = 1084
		refs = "0032 __subdf3 0094 __fixdfsi 0098 __floatsidf 00b4 __muldf3 00ec __eqdf2 0118 __kernel_rem_pio2 01a0 fabs 01b4 __adddf3"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 C6 4C C7 4B 90 B0 04 40 02 90 03 91 15 1C 07 1C 9C 42 00 DC 8B E0 C3 4B 9C 42 22 DC 00 28 00 DC 5B E1 C1 4A C1 4B 02 98 03 99 ?? ?? ?? ?? C0 4B 06 1C 0F 1C 9C 42 00 D1 92 E0 BE 4A BE 4B ?? ?? ?? ?? 02 1C 0B 1C 2A 60 6B 60 30 1C 39 1C ?? ?? ?? ?? B8 4A B8 4B ?? ?? ?? ?? 01 26 A8 60 E9 60 6C E0 B6 4B 9C 42 00 DC 94 E0 B5 4B 9C 42 00 DD 6A E0 02 98 03 99 B3 48 0B 1C 21 15 40 18 01 05 62 1A 82 46 19 1C 10 1C 02 92 03 93 ?? ?? ?? ?? ?? ?? ?? ?? 0B 1C 0A A9 02 1C 88 46 02 98 03 99 0A 92 0B 93 ?? ?? ?? ?? A7 4A A8 4B ?? ?? ?? ?? 02 90 03 91 ?? ?? ?? ?? ?? ?? ?? ?? 44 46 02 1C 0B 1C A2 60 E3 60 02 98 03 99 ?? ?? ?? ?? 9E 4A 9E 4B ?? ?? ?? ?? 42 46 10 61 51 61 9C 4A 9D 4B 0C AC 03 26 ?? ?? ?? ?? 00 28 09 D1 20 68 61 68 97 4A 98 4B 01 3E 08 3C ?? ?? ?? ?? 00 28 F5 D0 02 23 00 93 94 4B 40 46 01 93 29 1C 33 1C 52 46 ?? ?? ?? ?? 06 1C 00 2F 10 DA 2B 68 80 24 24 06 1B 19 2B 60 AB 68 1B 19 AB 60 46 42 06 E0 88 4B 88 4C 10 60 51 60 93 60 D4 60 00 26 10 B0 30 1C 0C BC 90 46 9A 46 F0 BD 02 98 03 99 02 1C 0B 1C ?? ?? ?? ?? 00 26 A8 60 E9 60 28 60 69 60 ED E7 7E 4A 7F 4B ?? ?? ?? ?? 7E 4A 7F 4B 06 1C 0F 1C ?? ?? ?? ?? 02 1C 0B 1C 2A 60 6B 60 30 1C 39 1C ?? ?? ?? ?? 77 4A 78 4B ?? ?? ?? ?? 01 26 A8 60 E9 60 D3 E7 02 98 03 99 ?? ?? ?? ?? 73 4A 74 4B 02 90 03 91 ?? ?? ?? ?? 72 4A 73 4B ?? ?? ?? ?? ?? ?? ?? ?? 06 1C ?? ?? ?? ?? 70 4A 70 4B 06 90 07 91 ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 58 4A 58 4B 02 90 03 91 06 98 07 99 ?? ?? ?? ?? 04 90 05 91 1F 2E 26 DC 72 1E 65 4B 92 00 D3 58 A3 42 20 D0 04 9A 05 9B 02 98 03 99 ?? ?? ?? ?? 02 1C 0B 1C 2A 60 6B 60 02 98 03 99 ?? ?? ?? ?? 04 9A 05 9B ?? ?? ?? ?? A8 60 E9 60 00 2F 00 DB 8B E7 2B 68 80 21 09 06 5B 18 2B 60 AB 68 5B 18 AB 60 76 42 81 E7 04 9A 05 9B 02 98 03 99 ?? ?? ?? ?? 24 15 A0 46 4F 4C 02 1C 00 0D 0B 1C 20 40 41 46 08 1A 2A 60 6B 60 10 28 D5 DD 3F 4A 3F 4B 06 98 07 99 ?? ?? ?? ?? 04 90 05 91 04 9A 05 9B 02 98 03 99 ?? ?? ?? ?? 08 90 09 91 08 9A 09 9B 02 98 03 99 ?? ?? ?? ?? 04 9A 05 9B ?? ?? ?? ?? 34 4A 34 4B 02 90 03 91 06 98 07 99 ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 04 90 05 91 04 9A 05 9B 08 98 09 99 ?? ?? ?? ?? 02 1C 00 0D 0B 1C 20 40 41 46 0C 1A 2A 60 6B 60 31 2C 00 DD 78 E0 08 98 09 99 02 90 03 91 97 E7 13 4A 13 4B 02 98 03 99 ?? ?? ?? ?? 12 4B 06 1C 0F 1C 9C 42 4D D0 10 4A 11 4B ?? ?? ?? ?? 02 1C 0B 1C 2A 60 6B 60 30 1C 39 1C ?? ?? ?? ?? 0A 4A 0B 4B ?? ?? ?? ?? 01 26 A8 60 E9 60 76 42 10 E7 C0 46 FF FF FF 7F FB 21 E9 3F 7B D9 02 40 FB 21 F9 3F 00 00 40 54 FB 21 F9 3F 61 B4 D0 3D 31 63 62 1A FB 21 39 41 FF FF EF 7F EA FB FF FF 00 00 70 41 00 00 00 00 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 61 B4 D0 3D 00 00 60 1A 8A 19 A3 3B 73 70 03 2E 30 5F E4 3F 83 C8 C9 6D 00 00 E0 3F 00 00 00 00 FB 21 F9 BF 00 00 40 54 ?? ?? ?? ?? FF 07 00 00 22 4B 21 4A ?? ?? ?? ?? 21 4A 22 4B 06 1C 0F 1C ?? ?? ?? ?? 02 1C 0B 1C 2A 60 6B 60 30 1C 39 1C ?? ?? ?? ?? 1A 4A 1B 4B ?? ?? ?? ?? 01 26 A8 60 E9 60 76 42 BC E6 18 4A 18 4B 06 98 07 99 ?? ?? ?? ?? 04 90 05 91 04 9A 05 9B 08 98 09 99 ?? ?? ?? ?? 02 90 03 91 02 9A 03 9B 08 98 09 99 ?? ?? ?? ?? 04 9A 05 9B ?? ?? ?? ?? 0D 4A 0D 4B 04 90 05 91 06 98 07 99 ?? ?? ?? ?? 04 9A 05 9B ?? ?? ?? ?? 04 90 05 91 F0 E6 61 B4 D0 3D 00 00 60 1A 8A 19 A3 3B 73 70 03 2E 8A 19 A3 3B 00 00 00 2E 9A 83 7B 39 C1 49 20 25 }
	condition:
		$1
}

rule file_9_0_1 {
	meta:
		name = "yn"
		size = 292
		refs = "0010 __ieee754_yn 0024 __isnand 0036 __ledf2 0046 __gtdf2 005e __floatsidf 007a matherr 0088 __errno 00fc __fdlib_version"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 8B B0 80 46 0E 1C 17 1C ?? ?? ?? ?? 39 4D 2B 68 00 90 01 91 01 33 3B D0 30 1C 39 1C ?? ?? ?? ?? 82 46 00 28 34 D1 30 1C 39 1C 33 4A 33 4B ?? ?? ?? ?? 00 28 33 DD 30 1C 39 1C 31 4A 31 4B ?? ?? ?? ?? 00 28 24 DD 05 23 02 93 2F 4B 02 AC 63 60 40 46 53 46 23 62 ?? ?? ?? ?? 27 4A 27 4B A2 61 E3 61 2B 68 A0 60 E1 60 26 61 67 61 02 2B 3C D0 20 1C ?? ?? ?? ?? 00 28 37 D0 23 6A 00 2B 03 D0 ?? ?? ?? ?? 23 6A 03 60 A2 69 E3 69 00 92 01 93 00 98 01 99 0B B0 0C BC 90 46 9A 46 F0 BD 01 23 02 93 19 4B 02 AC 52 46 40 46 63 60 22 62 ?? ?? ?? ?? 2B 68 A0 60 E1 60 26 61 67 61 00 2B 0D D1 12 4A 13 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 D3 D1 ?? ?? ?? ?? 21 23 03 60 CE E7 0D 49 0E 4A A1 61 E2 61 02 2B F4 D0 EE E7 ?? ?? ?? ?? 22 23 03 60 C2 E7 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 FB 21 49 43 18 2D 44 54 ?? ?? ?? ?? FF FF EF C7 00 00 00 E0 00 00 F0 FF 00 00 00 00 }
	condition:
		$1
}

rule file_9_1_1 {
	meta:
		name = "jn"
		size = 192
		refs = "0010 __ieee754_jn 0024 __isnand 0040 fabs 0048 __gtdf2 0060 __floatsidf 007c matherr 0094 __errno 00a8 __fdlib_version"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 8B B0 80 46 0C 1C 15 1C ?? ?? ?? ?? 24 4E 33 68 00 90 01 91 01 33 06 D0 20 1C 29 1C ?? ?? ?? ?? 82 46 00 28 06 D0 00 98 01 99 0B B0 0C BC 90 46 9A 46 F0 BD 20 1C 29 1C ?? ?? ?? ?? 19 4A 1A 4B ?? ?? ?? ?? 00 28 EE DD 05 23 02 93 17 4B 02 AF 7B 60 53 46 3B 62 40 46 ?? ?? ?? ?? 3C 61 7D 61 13 4B 14 4C BB 61 FC 61 33 68 B8 60 F9 60 02 2B 0C D0 38 1C ?? ?? ?? ?? 00 28 07 D0 3B 6A 00 2B 09 D1 BB 69 FC 69 00 93 01 94 CC E7 ?? ?? ?? ?? 22 23 03 60 F2 E7 ?? ?? ?? ?? 3B 6A 03 60 F0 E7 ?? ?? ?? ?? FB 21 49 43 18 2D 44 54 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_10_0_1 {
	meta:
		name = "__ieee754_powf"
		size = 1880
		refs = "0036 nanf 0084 fabsf 00b8 __subsf3 00be __divsf3 012a __ieee754_sqrtf 0160 __mulsf3 020a __addsf3 0384 __floatsisf 0612 __gtsf2 067e __gesf2 071a scalbnf"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 62 4B 0F 1C 86 B0 06 1C 0C 1C 0D 1C 1F 40 10 D0 01 1C 19 40 FF 23 DB 05 80 46 8A 46 9F 42 11 DD FE 23 9B 05 9A 45 04 D0 59 48 ?? ?? ?? ?? 04 1C 00 E0 58 4C 06 B0 20 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 9A 45 EB DC 00 28 4B DB 00 22 91 46 FF 23 DB 05 9F 42 30 D0 FE 23 9B 05 9F 42 36 D0 80 23 DB 05 9D 42 73 D0 FC 23 9B 05 9D 42 02 D1 41 46 00 29 52 DA 30 1C ?? ?? ?? ?? 52 46 01 1C 00 2A 28 D0 FF 23 DB 05 9A 45 24 D0 FE 23 9B 05 9A 45 20 D0 42 46 D3 0F 01 3B 01 93 4B 46 00 2B 5C D1 01 9A 00 2A 59 D1 30 1C 31 1C ?? ?? ?? ?? 01 1C ?? ?? ?? ?? 04 1C BC E7 FE 23 9B 05 9A 45 B7 D0 9A 45 24 DD 00 2D B4 DA 33 4C B2 E7 00 2D 38 DB 34 1C AE E7 00 2D 2F DB 43 46 00 2B 22 DB 0C 1C A7 E7 2D 4B 9F 42 0F DC 2D 4B 9F 42 09 DD 96 22 FB 15 D3 1A 3A 1C 1A 41 11 1C 99 40 B9 42 00 D1 20 E2 00 21 89 46 A6 E7 02 23 99 46 9F E7 00 2D DA DA 80 23 1B 06 E4 18 8B E7 30 1C ?? ?? ?? ?? 04 1C 86 E7 4A 46 00 2A 27 D1 1D 4A 13 1C 53 44 00 2B D4 D1 08 1C B8 E7 16 48 ?? ?? ?? ?? 01 1C CA E7 13 48 31 1C ?? ?? ?? ?? 04 1C 71 E7 30 1C 31 1C ?? ?? ?? ?? 04 1C 6B E7 9A 23 DB 05 9F 42 25 DD 10 4B 9A 45 00 DD FA E1 00 2D AC DA 0E 48 01 1C ?? ?? ?? ?? 04 1C 5B E7 4B 46 01 2B AE D1 80 22 12 06 8C 18 54 E7 C0 46 FF FF FF 7F ?? ?? ?? ?? 00 00 80 3F 00 00 00 00 FF FF 7F 4B FF FF 7F 3F 00 00 80 C0 F7 FF 7F 3F CA F2 49 71 F0 4B 9A 45 00 DC CC E1 7F 23 5B 42 51 46 CA 15 D2 18 05 92 EB 4A FE 23 0A 40 9B 05 13 43 9B 46 E9 4B 9A 42 00 DC AE E1 E8 4B 9A 42 00 DD A5 E1 90 21 8A 03 92 46 01 23 E5 49 9B 00 59 58 58 46 04 93 00 91 ?? ?? ?? ?? 59 46 02 90 00 98 ?? ?? ?? ?? 01 1C DF 48 ?? ?? ?? ?? 03 90 03 99 02 98 ?? ?? ?? ?? DC 4A 5B 46 02 40 17 1C 5A 10 80 23 9B 05 13 43 9A 44 80 46 51 46 38 1C ?? ?? ?? ?? 01 1C 02 98 ?? ?? ?? ?? 5E 46 00 99 83 46 50 46 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 01 1C 58 46 ?? ?? ?? ?? 03 99 ?? ?? ?? ?? 41 46 02 90 40 46 ?? ?? ?? ?? 06 1C 31 1C ?? ?? ?? ?? C6 49 82 46 30 1C ?? ?? ?? ?? C4 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? C2 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? C0 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? BE 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? BC 49 ?? ?? ?? ?? 01 1C 50 46 ?? ?? ?? ?? 39 1C 06 1C 40 46 ?? ?? ?? ?? 02 99 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 39 1C 83 46 38 1C ?? ?? ?? ?? B2 49 82 46 ?? ?? ?? ?? 59 46 ?? ?? ?? ?? A7 49 06 1C 0E 40 31 1C 38 1C ?? ?? ?? ?? 31 1C 03 90 02 98 ?? ?? ?? ?? A8 49 07 1C 30 1C ?? ?? ?? ?? 51 46 ?? ?? ?? ?? 01 1C 58 46 ?? ?? ?? ?? 41 46 ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 07 1C 39 1C 03 98 ?? ?? ?? ?? 95 4A 06 1C 16 40 30 1C 9B 49 ?? ?? ?? ?? 9B 49 83 46 30 1C ?? ?? ?? ?? 03 99 80 46 30 1C ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 95 49 ?? ?? ?? ?? 01 1C 40 46 ?? ?? ?? ?? 85 4B 04 99 5E 18 B1 68 ?? ?? ?? ?? 82 46 05 98 ?? ?? ?? ?? 37 69 80 46 51 46 58 46 ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 41 46 ?? ?? ?? ?? 7C 4A 06 1C 16 40 41 46 30 1C ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 59 46 ?? ?? ?? ?? 01 1C 50 46 ?? ?? ?? ?? 80 46 4B 46 01 2B 03 D1 01 99 00 29 00 D1 BC E0 6F 4A 91 46 6F 4B 1D 40 29 1C 20 1C ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 41 46 07 1C 20 1C ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 29 1C 80 46 30 1C ?? ?? ?? ?? 05 1C 82 46 29 1C 40 46 ?? ?? ?? ?? 6B 4E 07 1C 04 1C 06 40 00 28 00 DC 25 E1 86 23 DB 05 9E 42 00 DD F8 E0 9E 42 00 D1 E6 E0 FC 23 9B 05 9E 42 00 DD F9 E0 00 21 01 91 8B 46 51 46 40 46 ?? ?? ?? ?? 53 4C 04 40 20 1C 5D 49 ?? ?? ?? ?? 51 46 05 1C 20 1C ?? ?? ?? ?? 01 1C 40 46 ?? ?? ?? ?? 58 49 ?? ?? ?? ?? 58 49 06 1C 20 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 06 1C 31 1C 28 1C ?? ?? ?? ?? 29 1C 04 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 21 1C 05 1C 20 1C ?? ?? ?? ?? 4B 49 06 1C ?? ?? ?? ?? 4A 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 48 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 46 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 44 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 06 1C 31 1C 20 1C ?? ?? ?? ?? 3E 49 07 1C 30 1C ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 29 1C 06 1C 20 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 01 1C 1C 48 ?? ?? ?? ?? 01 1C 59 44 CB 15 00 2B 00 DC F4 E0 48 46 ?? ?? ?? ?? 04 1C 83 E5 05 9B 2B 49 01 33 05 93 8B 44 80 22 D3 02 9A 46 00 23 53 E6 27 4B 99 46 41 E7 01 23 1A 40 02 23 9B 1A 99 46 82 E5 08 1C 23 49 ?? ?? ?? ?? 97 23 82 46 5B 42 2C E6 21 4B 9A 45 00 DC 90 E0 00 2D 00 DD FF E5 1E 4C 5F E5 FF FF 7F 00 71 C4 1C 00 D6 B3 5D 00 ?? ?? ?? ?? 00 00 80 3F 00 F0 FF FF 42 F1 53 3E 55 32 6C 3E 05 A3 8B 3E AB AA AA 3E B7 6D DB 3E 9A 99 19 3F 00 00 40 40 00 38 76 3F A0 C3 9D 36 4F 38 76 3F FF FF FF 7F 00 72 31 3F 18 72 31 3F 8C BE BF 35 4C BB 31 33 0E EA DD 35 55 B3 8A 38 61 0B 36 3B AB AA 2A 3E 00 00 00 40 00 00 80 FF 00 00 80 BF 00 00 80 4B 07 00 80 3F 00 00 00 00 49 49 40 46 ?? ?? ?? ?? 29 1C 82 46 38 1C ?? ?? ?? ?? 01 1C 50 46 ?? ?? ?? ?? 00 28 08 DD 43 49 48 46 ?? ?? ?? ?? 41 49 ?? ?? ?? ?? 04 1C 09 E5 F6 15 80 23 1B 04 7F 3E 71 1C 1A 1C 0A 41 11 19 3B 48 4A 00 08 40 12 0E 03 43 7F 3A 17 20 80 1A 03 41 01 93 00 2C 5E DB 35 4B 13 41 99 43 28 1C ?? ?? ?? ?? 01 9B DB 05 82 46 9B 46 E9 E6 31 4B 9E 42 0A DC 9E 42 00 D0 DB E6 29 1C ?? ?? ?? ?? 41 46 ?? ?? ?? ?? 00 28 D2 DB 2B 49 48 46 ?? ?? ?? ?? 29 49 ?? ?? ?? ?? 04 1C D3 E4 08 1C 27 49 ?? ?? ?? ?? 26 49 06 1C ?? ?? ?? ?? 25 49 80 46 30 1C ?? ?? ?? ?? 31 1C 82 46 30 1C ?? ?? ?? ?? 21 49 07 1C 30 1C ?? ?? ?? ?? 20 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 01 1C 1D 48 ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 1B 49 ?? ?? ?? ?? 01 1C 50 46 ?? ?? ?? ?? 07 1C 39 1C 40 46 ?? ?? ?? ?? 16 4E 06 40 41 46 30 1C ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 80 46 58 E6 5B 42 01 93 9D E7 01 99 ?? ?? ?? ?? 01 1C 05 E7 C0 46 3C AA 38 33 CA F2 49 71 FF FF 7F 00 00 00 16 43 60 42 A2 0D 00 00 80 3F 00 AA B8 3F 70 A5 EC 36 00 00 80 BE AB AA AA 3E 00 00 00 3F 3B AA B8 BF 00 F0 FF FF }
	condition:
		$1
}

rule file_11_0_1 {
	meta:
		name = "__ieee754_sqrtf"
		size = 188
		refs = "0086 __mulsf3 008e __addsf3 009c __subsf3 00a2 __divsf3"
	strings:
		$1 = { 70 B5 2B 4A 2B 4B 02 40 04 1C 9A 42 3A D8 00 2A 36 D0 03 1C 00 28 40 DB 27 49 C6 15 8A 42 0A D8 80 21 09 04 08 42 40 D1 00 22 5B 00 01 32 0B 42 FB D0 01 36 B6 1A 20 49 0B 40 80 21 09 04 7F 3E 19 43 F3 07 27 D4 80 23 4A 00 00 25 00 21 00 24 5B 04 E0 18 90 42 02 DC C4 18 12 1A ED 18 01 31 52 00 5B 08 19 29 F4 D1 00 2A 02 D0 01 23 2B 40 5D 19 74 10 FC 23 E4 05 9B 05 E4 18 6D 10 64 19 20 1C 70 BD 21 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 04 1C F4 E7 49 00 D5 E7 21 1C ?? ?? ?? ?? 01 1C ?? ?? ?? ?? 04 1C EA E7 00 22 C1 E7 C0 46 FF FF FF 7F FF FF 7F 7F FF FF 7F 00 }
	condition:
		$1
}

rule file_12_0_1 {
	meta:
		name = "tanh"
		size = 260
		refs = "001e __divdf3 0026 __adddf3 004e fabs 005a expm1 008c __subdf3 009e __muldf3"
	strings:
		$1 = { 70 B5 34 4B 34 4A 03 40 05 1C 0E 1C 04 1C 93 42 0C DD 00 28 32 DB 2A 1C 33 1C 30 48 30 49 ?? ?? ?? ?? 2E 4A 2E 4B ?? ?? ?? ?? 70 BD 2D 4A 93 42 07 DD 2D 48 00 21 00 2C F7 DA 80 23 1B 06 C0 18 F3 E7 2A 4A 93 42 24 DD 29 4A 93 42 2A DD ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? ?? ?? ?? ?? 25 4A 25 4B ?? ?? ?? ?? 02 1C 0B 1C 24 48 24 49 ?? ?? ?? ?? 1A 4A 1A 4B ?? ?? ?? ?? DC E7 2A 1C 33 1C 16 48 17 49 ?? ?? ?? ?? 14 4A 15 4B ?? ?? ?? ?? CB E7 12 4A 12 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? C2 E7 ?? ?? ?? ?? 14 4A 15 4B ?? ?? ?? ?? ?? ?? ?? ?? 80 23 1B 06 C6 18 0E 4A 0E 4B 0D 1C ?? ?? ?? ?? 02 1C 0B 1C 30 1C 29 1C ?? ?? ?? ?? B1 E7 C0 46 FF FF FF 7F FF FF EF 7F 00 00 F0 3F 00 00 00 00 FF FF 35 40 00 00 F0 3F FF FF 7F 3C FF FF EF 3F 00 00 00 40 00 00 00 00 00 00 00 C0 00 00 00 00 }
	condition:
		$1
}

rule file_13_0_1 {
	meta:
		name = "__ieee754_acosf"
		size = 736
		refs = "002a __subsf3 0030 __divsf3 0050 __mulsf3 0056 __ieee754_sqrtf 006a __addsf3"
	strings:
		$1 = { F0 B5 A1 4A FE 23 02 40 9B 05 04 1C 9A 42 12 D0 9A 42 09 DC 9D 4B 9A 42 12 DC 8C 23 9B 05 9A 42 00 DD 7E E0 9A 48 05 E0 21 1C ?? ?? ?? ?? 01 1C ?? ?? ?? ?? F0 BD 00 28 00 DC C6 E0 95 48 F9 E7 00 28 00 DA C3 E0 21 1C 93 48 ?? ?? ?? ?? 93 49 ?? ?? ?? ?? 04 1C ?? ?? ?? ?? 91 4D 06 1C 05 40 90 49 20 1C ?? ?? ?? ?? 8F 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 8D 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 8B 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 89 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 87 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 85 49 07 1C 20 1C ?? ?? ?? ?? 84 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 82 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 80 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 71 49 ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 29 1C 07 1C 28 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 29 1C 04 1C 30 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 01 1C ?? ?? ?? ?? 88 E7 21 1C ?? ?? ?? ?? 5E 49 05 1C ?? ?? ?? ?? 5D 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 5B 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 59 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 57 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 55 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 53 49 06 1C 28 1C ?? ?? ?? ?? 52 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 50 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 4E 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 3F 49 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 01 1C 46 48 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 01 1C 43 48 ?? ?? ?? ?? 34 E7 42 48 32 E7 32 49 ?? ?? ?? ?? 31 49 ?? ?? ?? ?? 04 1C ?? ?? ?? ?? 30 49 05 1C 20 1C ?? ?? ?? ?? 2F 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 2D 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 2B 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 29 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 27 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 25 49 06 1C 20 1C ?? ?? ?? ?? 23 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 21 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 1F 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 10 49 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 18 49 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 17 49 ?? ?? ?? ?? 17 49 ?? ?? ?? ?? D6 E6 C0 46 FF FF FF 7F FF FF FF 3E DB 0F C9 3F 00 00 00 00 00 00 80 3F 00 00 00 3F 00 F0 FF FF 08 EF 11 38 04 7F 4F 3A 46 11 24 3D A8 0A 4E 3E 90 B0 A6 3E AB AA 2A 3E 2E C6 9D 3D 61 33 30 3F 2D 57 01 40 39 D1 19 40 68 21 A2 33 DA 0F C9 3F DB 0F 49 40 00 00 00 C0 DA 0F 49 40 }
	condition:
		$1
}

rule file_14_0_1 {
	meta:
		name = "__ieee754_atanh"
		size = 324
		refs = "0030 __adddf3 0038 __gtdf2 005a __muldf3 006a __subdf3 0076 __divdf3 0082 log1p"
	strings:
		$1 = { F0 B5 0C 1C 49 42 43 4E 0A 1C 22 43 06 40 D2 0F 41 4B 32 43 84 B0 05 1C 07 1C 9A 42 41 D8 9E 42 00 D1 6F E0 3D 4B 9E 42 47 DC 3D 4A 3D 4B 21 1C ?? ?? ?? ?? 3C 4A 3D 4B ?? ?? ?? ?? 00 28 2C DC 23 1C 1D 1C 34 1C 22 1C 20 1C 2B 1C 29 1C ?? ?? ?? ?? 22 1C 2B 1C 00 90 01 91 ?? ?? ?? ?? 22 1C 02 90 03 91 2B 1C 32 48 32 49 ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? ?? ?? ?? ?? 2C 4A 2C 4B ?? ?? ?? ?? 0C 1C 00 2F 35 DA 80 23 1B 06 C5 18 04 B0 28 1C 21 1C F0 BD 2A 1C 23 1C 21 1C ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? 05 1C 0C 1C EF E7 23 1C 1D 1C 20 4B 34 1C 9E 42 BF DD 32 1C 2B 1C 30 1C 29 1C ?? ?? ?? ?? 32 1C 00 90 01 91 2B 1C 15 48 15 49 ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? ?? ?? ?? ?? 11 4A 11 4B ?? ?? ?? ?? 0C 1C 00 2F C9 DB 05 1C CA E7 21 1C 08 4A 08 4B ?? ?? ?? ?? 05 1C 0C 1C C2 E7 FF FF FF 7F 00 00 F0 3F FF FF 2F 3E 3C E4 37 7E 9C 75 00 88 00 00 00 00 00 00 00 00 00 00 F0 3F 00 00 00 00 00 00 E0 3F 00 00 00 00 FF FF DF 3F }
	condition:
		$1
}

rule file_15_0_1 {
	meta:
		name = "tanhf"
		size = 204
		refs = "0018 __divsf3 001e __addsf3 0044 fabsf 004e expm1f 0072 __subsf3 0080 __mulsf3"
	strings:
		$1 = { 30 B5 2A 4B 2A 4A 03 40 05 1C 04 1C 93 42 09 DD 00 28 29 DB 29 1C 27 48 ?? ?? ?? ?? 25 49 ?? ?? ?? ?? 30 BD 24 4A 93 42 06 DD 22 48 00 2C F8 DA 80 23 1B 06 C0 18 F4 E7 20 4A 93 42 1C DD 20 4A 93 42 20 DD ?? ?? ?? ?? 01 1C ?? ?? ?? ?? ?? ?? ?? ?? 1C 49 ?? ?? ?? ?? 01 1C 1B 48 ?? ?? ?? ?? 14 49 ?? ?? ?? ?? E1 E7 29 1C 12 48 ?? ?? ?? ?? 10 49 ?? ?? ?? ?? D4 E7 0E 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? CD E7 ?? ?? ?? ?? 0F 49 ?? ?? ?? ?? ?? ?? ?? ?? 80 23 1B 06 0A 49 C5 18 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? C0 E7 C0 46 FF FF FF 7F FF FF 7F 7F 00 00 80 3F FF FF AF 41 FF FF FF 23 FF FF 7F 3F 00 00 00 40 00 00 00 C0 }
	condition:
		$1
}

rule file_16_0_1 {
	meta:
		name = "powf"
		size = 860
		refs = "000e __ieee754_powf 001e isnanf 0044 __eqsf2 005a __extendsfdf2 0082 matherr 0092 __errno 00f0 __truncdfsf2 00fa finitef 017c __ltsf2 021c __divdf3 02ba __mulsf3 02c6 rint 02d2 __nedf2 031c __fdlib_version"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 89 B0 05 1C 0C 1C ?? ?? ?? ?? C2 4E 33 68 07 1C 01 33 05 D0 20 1C ?? ?? ?? ?? 80 46 00 28 05 D0 09 B0 38 1C 0C BC 90 46 9A 46 F0 BD 28 1C ?? ?? ?? ?? 82 46 00 28 2D D0 20 1C B7 49 ?? ?? ?? ?? 00 28 ED D1 01 23 00 93 B4 4B 28 1C 01 93 43 46 08 93 ?? ?? ?? ?? 6F 46 B8 60 F9 60 20 1C ?? ?? ?? ?? AF 4B AF 4C BB 61 FC 61 33 68 38 61 79 61 02 2B 33 D0 01 33 31 D0 68 46 ?? ?? ?? ?? 00 28 00 D1 9B E0 3B 6A 00 2B 2C D0 ?? ?? ?? ?? 3B 6A 03 60 27 E0 28 1C A0 49 ?? ?? ?? ?? 00 28 27 D1 20 1C 9D 49 ?? ?? ?? ?? 00 28 5B D1 01 23 00 93 9A 4B 28 1C 01 93 53 46 08 93 ?? ?? ?? ?? 6F 46 B8 60 F9 60 20 1C ?? ?? ?? ?? 97 4B 97 4C BB 61 FC 61 33 68 38 61 79 61 00 2B CD D0 90 4B 91 4C BB 61 FC 61 B8 69 F9 69 ?? ?? ?? ?? 07 1C 97 E7 38 1C ?? ?? ?? ?? 80 46 00 28 64 D0 38 1C 86 49 ?? ?? ?? ?? 00 28 00 D0 8A E7 28 1C ?? ?? ?? ?? 00 28 00 D1 84 E7 20 1C ?? ?? ?? ?? 00 28 00 D1 7E E7 04 23 00 93 7D 4B 28 1C 01 93 00 23 08 93 ?? ?? ?? ?? 6F 46 B8 60 F9 60 20 1C ?? ?? ?? ?? 79 4B 7A 4C BB 61 FC 61 33 68 38 61 79 61 02 2B 71 D0 68 46 ?? ?? ?? ?? 00 28 6C D0 3B 6A 00 2B C0 D0 92 E7 20 1C ?? ?? ?? ?? 00 28 00 D1 57 E7 20 1C 69 49 ?? ?? ?? ?? 00 28 00 DB 50 E7 01 23 00 93 66 4B 28 1C 01 93 53 46 08 93 ?? ?? ?? ?? 6F 46 B8 60 F9 60 20 1C ?? ?? ?? ?? 33 68 38 61 79 61 00 2B 42 D0 62 49 62 4A B9 61 FA 61 02 2B 36 D1 ?? ?? ?? ?? 21 23 03 60 CF E7 ?? ?? ?? ?? 21 23 03 60 5E E7 28 1C ?? ?? ?? ?? 00 28 95 D0 20 1C ?? ?? ?? ?? 00 28 90 D0 38 1C ?? ?? ?? ?? 00 28 2D D0 01 23 00 93 4C 4B 28 1C 01 93 43 46 08 93 ?? ?? ?? ?? 6F 46 B8 60 F9 60 20 1C ?? ?? ?? ?? 34 68 38 61 79 61 00 2C 0F D0 46 48 47 49 02 1C 0B 1C ?? ?? ?? ?? B8 61 F9 61 02 2C C8 D0 68 46 ?? ?? ?? ?? 00 28 98 D1 C2 E7 3E 4B 3F 4C BB 61 FC 61 F4 E7 ?? ?? ?? ?? 22 23 03 60 8D E7 03 23 00 93 35 4B 08 90 28 1C 01 93 ?? ?? ?? ?? 6F 46 B8 60 F9 60 20 1C ?? ?? ?? ?? 33 68 38 61 79 61 98 46 00 2B 14 D1 33 4A 34 4B 28 1C BA 61 FB 61 29 49 ?? ?? ?? ?? 00 28 18 DB 68 46 ?? ?? ?? ?? 00 28 00 D0 FD E6 ?? ?? ?? ?? 22 23 03 60 F8 E6 2B 4A 2B 4B 28 1C BA 61 FB 61 1E 49 ?? ?? ?? ?? 00 28 1C DB 43 46 02 2B E7 D1 EC E7 20 1C 25 49 ?? ?? ?? ?? ?? ?? ?? ?? 04 1C 0D 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 00 28 1C D0 1E 4B 1E 4C 36 68 BB 61 FC 61 B0 46 E2 E7 20 1C 19 49 ?? ?? ?? ?? ?? ?? ?? ?? 04 1C 0D 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 00 28 03 D0 0A 4B 0B 4C BB 61 FC 61 36 68 B0 46 C9 E7 C0 46 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 F0 3F 00 00 00 00 00 00 00 00 00 00 00 00 00 00 F0 FF 00 00 00 00 FF FF EF 47 00 00 00 E0 00 00 F0 7F 00 00 00 00 00 00 00 3F FF FF EF C7 00 00 00 E0 }
	condition:
		$1
}

rule file_17_0_1 {
	meta:
		name = "__ieee754_sinhf"
		size = 308
		refs = "0024 __addsf3 002a __gtsf2 0034 fabsf 0038 expm1f 004c __mulsf3 005e __divsf3 0066 __subsf3 00a8 __ieee754_expf"
	strings:
		$1 = { F0 B5 41 4E 41 4A 06 40 04 1C 96 42 33 DC 00 28 42 DB 3F 4D 3F 4B 9E 42 32 DC 3F 4B 9E 42 50 DC 3E 49 20 1C ?? ?? ?? ?? 3D 49 ?? ?? ?? ?? 00 28 1F DC 20 1C ?? ?? ?? ?? ?? ?? ?? ?? 04 1C 21 1C 20 1C ?? ?? ?? ?? 21 1C 07 1C 20 1C ?? ?? ?? ?? 33 49 06 1C 20 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 04 1C 20 1C F0 BD 21 1C ?? ?? ?? ?? 04 1C F8 E7 28 4B 9E 42 36 DD 28 4B 9E 42 07 DD 20 1C 23 49 ?? ?? ?? ?? 04 1C EC E7 24 4D BB E7 20 1C ?? ?? ?? ?? 1B 49 ?? ?? ?? ?? ?? ?? ?? ?? 04 1C 21 1C 28 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 04 1C D7 E7 20 1C ?? ?? ?? ?? ?? ?? ?? ?? 18 4B 04 1C 9E 42 B4 DD 12 49 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 04 1C BE E7 20 1C ?? ?? ?? ?? ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 04 1C B4 E7 FF FF FF 7F FF FF 7F 7F 00 00 00 3F FF FF AF 41 FF FF 7F 31 C2 BD F0 7C 00 00 80 3F 17 72 B1 42 FC D4 B2 42 00 00 00 BF FF FF 7F 3F }
	condition:
		$1
}

rule file_18_0_1 {
	meta:
		name = "atan"
		size = 840
		refs = "0054 __muldf3 0074 __adddf3 00d4 __subdf3 018e __gtdf2 019c fabs 01d8 __divdf3"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 A3 4E A4 4B 06 40 82 B0 05 1C 0C 1C 80 46 9E 42 0D DD A1 4B 9E 42 00 DD 9F E0 9E 42 00 D1 99 E0 41 46 00 29 00 DC DA E0 9C 4D 9D 4C 9D E0 9D 4B 9E 42 00 DD AD E0 9C 4B 9E 42 00 DC 9C E0 01 20 41 42 8A 46 2A 1C 23 1C 28 1C 21 1C ?? ?? ?? ?? 02 1C 0B 1C 00 90 01 91 ?? ?? ?? ?? 93 4A 94 4B 06 1C 0F 1C ?? ?? ?? ?? 92 4A 93 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 90 4A 91 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 8E 4A 8F 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 8C 4A 8D 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 8A 4A 8B 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 88 4A 89 4B 00 90 01 91 30 1C 39 1C ?? ?? ?? ?? 86 4A 87 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 84 4A 85 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 82 4A 83 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 80 4A 81 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 02 1C 50 46 0B 1C 01 30 00 D1 6B E0 50 46 7B 4E C1 00 76 18 00 98 01 99 ?? ?? ?? ?? 23 1C 2A 1C ?? ?? ?? ?? 32 6A 73 6A ?? ?? ?? ?? 23 1C 2A 1C ?? ?? ?? ?? 02 1C 0B 1C 30 68 71 68 ?? ?? ?? ?? 0C 1C 41 46 00 29 49 DB 05 1C 0A E0 00 29 00 D1 62 E7 28 1C 21 1C 2A 1C 23 1C ?? ?? ?? ?? 05 1C 0C 1C 02 B0 28 1C 21 1C 0C BC 90 46 9A 46 F0 BD 63 4A 64 4B 28 1C ?? ?? ?? ?? 63 4A 63 4B ?? ?? ?? ?? 00 28 00 DC 56 E7 EB E7 28 1C ?? ?? ?? ?? 5F 4B 04 1C 0D 1C 9E 42 35 DC 5E 4B 9E 42 5B DC 22 1C 2B 1C ?? ?? ?? ?? 57 4A 58 4B ?? ?? ?? ?? 59 4A 5A 4B 06 1C 0F 1C 20 1C 29 1C ?? ?? ?? ?? 0B 1C 02 1C 39 1C 30 1C ?? ?? ?? ?? 00 23 05 1C 0C 1C 9A 46 32 E7 52 4D 2F 4C C2 E7 80 23 1B 06 C5 18 BE E7 00 98 01 99 ?? ?? ?? ?? 2A 1C 23 1C ?? ?? ?? ?? 02 1C 0B 1C 28 1C 21 1C ?? ?? ?? ?? 05 1C 0C 1C AD E7 47 4B 9E 42 1A DC 46 4A 47 4B ?? ?? ?? ?? 44 4A 45 4B 06 1C 0F 1C 20 1C 29 1C ?? ?? ?? ?? 38 4A 39 4B ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 0C 1C 02 21 05 1C 8A 46 FC E6 2B 1C 22 1C 3A 48 3A 49 ?? ?? ?? ?? 03 23 05 1C 0C 1C 9A 46 F1 E6 2B 4A 2C 4B ?? ?? ?? ?? 29 4A 2A 4B 06 1C 0F 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 05 1C 01 20 0C 1C 82 46 DA E6 C0 46 FF FF FF 7F FF FF 0F 44 00 00 F0 7F FB 21 F9 3F 18 2D 44 54 FF FF DB 3F FF FF 1F 3E 3A AD 90 3F 11 DA 22 E3 4B 7B A9 3F EB 0D 76 24 66 0D B1 3F 51 3D D0 A0 CD 45 B7 3F 6E 20 4C C5 24 49 C2 3F FF 83 00 92 55 55 D5 3F 0D 55 55 55 44 B4 A2 BF 2F 6C 6A 2C 2D DE AD 3F 9A FD DE 52 F2 B0 B3 3F 6D 9A 74 AF C6 71 BC 3F 71 16 23 FE 99 99 C9 3F C4 EB 98 99 ?? ?? ?? ?? 3C E4 37 7E 9C 75 00 88 00 00 F0 3F 00 00 00 00 FF FF F2 3F FF FF E5 3F 00 00 00 40 00 00 00 00 FB 21 F9 BF FF 7F 03 40 00 00 F8 3F 00 00 00 00 00 00 F0 BF 00 00 00 00 }
	condition:
		$1
}

rule file_19_0_1 {
	meta:
		name = "exp2"
		size = 24
		refs = "000a pow"
	strings:
		$1 = { 00 B5 02 1C 0B 1C 03 49 01 48 ?? ?? ?? ?? 00 BD 00 00 00 40 00 00 00 00 }
	condition:
		$1
}

rule file_20_0_1 {
	meta:
		name = "pzerof"
		size = 244
		refs = "0024 __mulsf3 002c __divsf3 003a __addsf3"
		altNames = "ponef"
	strings:
		$1 = { 70 B5 35 4B 35 4A 03 40 01 1C 93 42 5C DC 34 4A 93 42 54 DC 33 4A 93 42 5A DC 33 4D 2E 1C 58 36 6C 35 08 1C ?? ?? ?? ?? 01 1C 30 48 ?? ?? ?? ?? 69 69 04 1C ?? ?? ?? ?? 29 69 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? E9 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? A9 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 69 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 29 68 ?? ?? ?? ?? 31 69 05 1C 20 1C ?? ?? ?? ?? F1 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? B1 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 71 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 31 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 10 49 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 0D 49 ?? ?? ?? ?? 70 BD 0A 4D 2E 1C 2C 36 40 35 AC E7 07 4E 35 1C 14 35 A8 E7 07 4D 2E 1D 18 35 A4 E7 FF FF FF 7F FF FF FF 40 57 1C F7 40 67 DB 36 40 ?? ?? ?? ?? 00 00 80 3F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_1_1 {
	meta:
		name = "qzerof"
		size = 272
		refs = "0026 __mulsf3 002e __divsf3 003c __addsf3 00c6 __subsf3"
	strings:
		$1 = { F0 B5 3B 4B 3B 4A 03 40 07 1C 93 42 66 DC 3A 4A 93 42 5E DC 39 4A 93 42 65 DC 39 4E 35 1C 10 35 28 36 39 1C 38 1C ?? ?? ?? ?? 01 1C 35 48 ?? ?? ?? ?? 71 69 04 1C ?? ?? ?? ?? 31 69 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? F1 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? B1 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 71 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 31 68 ?? ?? ?? ?? 69 69 06 1C 20 1C ?? ?? ?? ?? 29 69 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? E9 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? A9 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 69 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 29 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 13 49 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 10 49 ?? ?? ?? ?? 39 1C ?? ?? ?? ?? F0 BD 0E 4E 35 1C 60 35 78 36 A2 E7 0B 4E 35 1C 30 35 48 36 9D E7 06 4E 35 1C 40 35 58 36 98 E7 FF FF FF 7F FF FF FF 40 57 1C F7 40 67 DB 36 40 ?? ?? ?? ?? 00 00 80 3F 00 00 00 3E ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_2_1 {
	meta:
		name = "__ieee754_j0f"
		size = 564
		refs = "0014 __mulsf3 001c __divsf3 0028 fabsf 003c __addsf3 0042 __gtsf2 0074 __subsf3 011e sinf 0126 cosf 0158 __ieee754_sqrtf 01ba __ltsf2"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 74 4C 75 4B 04 40 01 1C 9C 42 09 DD ?? ?? ?? ?? 01 1C 72 48 ?? ?? ?? ?? 0C BC 90 46 9A 46 F0 BD ?? ?? ?? ?? 6E 4B 06 1C 9C 42 74 DC 6D 4B 9C 42 0D DC 6D 49 ?? ?? ?? ?? 68 49 ?? ?? ?? ?? 00 28 05 DD 6A 4B 9C 42 00 DD 99 E0 64 48 E4 E7 31 1C 30 1C ?? ?? ?? ?? 66 49 05 1C ?? ?? ?? ?? 65 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 63 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 61 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 5F 49 07 1C 28 1C ?? ?? ?? ?? 5D 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 5B 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 59 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 4A 49 ?? ?? ?? ?? 56 4B 80 46 9C 42 1D DD 30 1C 54 49 ?? ?? ?? ?? 41 46 04 1C 38 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 41 49 05 1C 20 1C ?? ?? ?? ?? 21 1C 06 1C 3D 48 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 8E E7 41 46 38 1C ?? ?? ?? ?? 45 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 33 49 ?? ?? ?? ?? 80 E7 ?? ?? ?? ?? 05 1C 30 1C ?? ?? ?? ?? 07 1C 39 1C 28 1C ?? ?? ?? ?? 39 1C 82 46 28 1C ?? ?? ?? ?? 39 4B 80 46 9C 42 2B DD 30 1C FF F7 58 FE 05 1C 30 1C FF F7 CE FE 04 1C 30 1C ?? ?? ?? ?? 29 1C 06 1C 40 46 ?? ?? ?? ?? 21 1C 05 1C 50 46 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 2B 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 4C E7 30 1C 28 49 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 13 49 ?? ?? ?? ?? 40 E7 31 1C 30 1C ?? ?? ?? ?? ?? ?? ?? ?? 80 23 1B 06 C4 18 39 1C 28 1C ?? ?? ?? ?? 1D 49 ?? ?? ?? ?? 00 28 05 DA 20 1C 51 46 ?? ?? ?? ?? 80 46 BB E7 20 1C 41 46 ?? ?? ?? ?? 82 46 B5 E7 C0 46 FF FF FF 7F FF FF 7F 7F 00 00 80 3F FF FF FF 3F FF FF FF 38 CA F2 49 71 FF FF FF 31 3C AF 9E B1 88 8E F5 35 2E 35 47 39 00 00 80 3C E8 45 A0 30 A6 DA 09 35 97 36 F5 38 44 E7 7F 3C FF FF 7F 3F 00 00 00 3F 00 00 80 3E FF FF FF 7E BB 6E 10 3F 00 00 80 BE 00 00 00 00 }
	condition:
		$1
}

rule file_20_3_1 {
	meta:
		name = "__ieee754_y0f"
		size = 540
		refs = "0034 __mulsf3 0042 __addsf3 004e __subsf3 00ba __divsf3 00c2 __ieee754_j0f 00ca __ieee754_logf 011e sinf 0126 cosf 0158 __ieee754_sqrtf 01ac __ltsf2"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 70 4D 71 4A 05 40 04 1C 95 42 00 DD 6F E0 00 2D 65 D0 00 28 00 DA B2 E0 6C 4B 9D 42 00 DD 7A E0 C8 23 9B 05 9D 42 00 DC 6C E0 21 1C ?? ?? ?? ?? 67 49 05 1C ?? ?? ?? ?? 66 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 64 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 62 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 60 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 5E 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 5C 49 ?? ?? ?? ?? 5C 49 06 1C 28 1C ?? ?? ?? ?? 5A 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 58 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 56 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 54 49 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 05 1C 20 1C ?? ?? ?? ?? 06 1C 20 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 4C 49 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 03 E0 49 48 49 49 ?? ?? ?? ?? 0C BC 90 46 9A 46 F0 BD 21 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 01 1C 3F 48 ?? ?? ?? ?? F0 E7 ?? ?? ?? ?? 3D 49 ?? ?? ?? ?? 36 49 ?? ?? ?? ?? E7 E7 ?? ?? ?? ?? 06 1C 20 1C ?? ?? ?? ?? 07 1C 39 1C 30 1C ?? ?? ?? ?? 39 1C 80 46 30 1C ?? ?? ?? ?? 35 4B 82 46 9D 42 24 DD 20 1C FF F7 3E FD 06 1C 20 1C FF F7 B4 FD 05 1C 20 1C ?? ?? ?? ?? 31 1C 04 1C 40 46 ?? ?? ?? ?? 29 1C 06 1C 50 46 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 27 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? B3 E7 22 48 01 1C ?? ?? ?? ?? AE E7 21 1C 20 1C ?? ?? ?? ?? ?? ?? ?? ?? 80 23 1B 06 C5 18 39 1C 30 1C ?? ?? ?? ?? 19 49 ?? ?? ?? ?? 00 28 05 DA 28 1C 41 46 ?? ?? ?? ?? 82 46 C2 E7 28 1C 51 46 ?? ?? ?? ?? 80 46 BC E7 FF FF FF 7F FF FF 7F 7F FF FF FF 3F EB 21 2F AE BA 02 A8 32 3C F5 7F 36 69 2A B6 39 46 67 62 3C 0D E8 34 3E B5 26 97 3D C2 80 F2 2F 6C 21 8B 34 E0 65 9F 38 85 93 50 3C 00 00 80 3F 83 F9 22 3F 00 00 80 BF 00 00 00 00 FF FF FF 7E BB 6E 10 3F }
	condition:
		$1
}

rule file_21_0_1 {
	meta:
		name = "y1"
		size = 276
		refs = "000c __ieee754_y1 0020 __isnand 0032 __ledf2 0042 __gtdf2 0070 matherr 007e __errno 00ec __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8B B0 06 1C 0F 1C ?? ?? ?? ?? 36 4D 2B 68 00 90 01 91 01 33 38 D0 30 1C 39 1C ?? ?? ?? ?? 80 46 00 28 31 D1 30 1C 39 1C 30 4A 30 4B ?? ?? ?? ?? 00 28 2F DD 30 1C 39 1C 2E 4A 2E 4B ?? ?? ?? ?? 00 28 21 DD 05 23 02 93 2C 4B 02 AC 63 60 43 46 23 62 25 4A 26 4B A2 61 E3 61 2B 68 26 61 67 61 A6 60 E7 60 02 2B 38 D0 20 1C ?? ?? ?? ?? 00 28 33 D0 23 6A 00 2B 03 D0 ?? ?? ?? ?? 23 6A 03 60 A2 69 E3 69 00 92 01 93 00 98 01 99 0B B0 04 BC 90 46 F0 BD 01 23 02 93 18 4B 02 AC 63 60 2B 68 42 46 22 62 26 61 67 61 A6 60 E7 60 00 2B 0D D1 13 4A 13 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 D7 D1 ?? ?? ?? ?? 21 23 03 60 D2 E7 0E 49 0E 4A A1 61 E2 61 02 2B F4 D0 EE E7 ?? ?? ?? ?? 22 23 03 60 C6 E7 C0 46 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 FB 21 49 43 18 2D 44 54 ?? ?? ?? ?? FF FF EF C7 00 00 00 E0 00 00 F0 FF 00 00 00 00 }
	condition:
		$1
}

rule file_182_0_1 {
	meta:
		name = "y0"
		size = 276
		refs = "000c __ieee754_y0 0020 __isnand 0032 __ledf2 0042 __gtdf2 0070 matherr 007e __errno 00ec __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8B B0 06 1C 0F 1C ?? ?? ?? ?? 36 4D 2B 68 00 90 01 91 01 33 38 D0 30 1C 39 1C ?? ?? ?? ?? 80 46 00 28 31 D1 30 1C 39 1C 30 4A 30 4B ?? ?? ?? ?? 00 28 2F DD 30 1C 39 1C 2E 4A 2E 4B ?? ?? ?? ?? 00 28 21 DD 05 23 02 93 2C 4B 02 AC 63 60 43 46 23 62 25 4A 26 4B A2 61 E3 61 2B 68 26 61 67 61 A6 60 E7 60 02 2B 38 D0 20 1C ?? ?? ?? ?? 00 28 33 D0 23 6A 00 2B 03 D0 ?? ?? ?? ?? 23 6A 03 60 A2 69 E3 69 00 92 01 93 00 98 01 99 0B B0 04 BC 90 46 F0 BD 01 23 02 93 18 4B 02 AC 63 60 2B 68 42 46 22 62 26 61 67 61 A6 60 E7 60 00 2B 0D D1 13 4A 13 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 D7 D1 ?? ?? ?? ?? 21 23 03 60 D2 E7 0E 49 0E 4A A1 61 E2 61 02 2B F4 D0 EE E7 ?? ?? ?? ?? 22 23 03 60 C6 E7 C0 46 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 FB 21 49 43 18 2D 44 54 ?? ?? ?? ?? FF FF EF C7 00 00 00 E0 00 00 F0 FF 00 00 00 00 }
	condition:
		$1
}

rule file_21_1_1 {
	meta:
		name = "j1"
		size = 180
		refs = "000c __ieee754_j1 0020 __isnand 003a fabs 0042 __gtdf2 0070 matherr 0088 __errno 009c __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8B B0 04 1C 0D 1C ?? ?? ?? ?? 22 4E 33 68 00 90 01 91 01 33 06 D0 20 1C 29 1C ?? ?? ?? ?? 80 46 00 28 05 D0 00 98 01 99 0B B0 04 BC 90 46 F0 BD 20 1C 29 1C ?? ?? ?? ?? 18 4A 18 4B ?? ?? ?? ?? 00 28 EF DD 05 23 02 93 16 4B 02 AF 7B 60 43 46 3B 62 3C 61 7D 61 BC 60 FD 60 12 4B 13 4C BB 61 FC 61 33 68 02 2B 0C D0 38 1C ?? ?? ?? ?? 00 28 07 D0 3B 6A 00 2B 09 D1 BB 69 FC 69 00 93 01 94 D0 E7 ?? ?? ?? ?? 22 23 03 60 F2 E7 ?? ?? ?? ?? 3B 6A 03 60 F0 E7 ?? ?? ?? ?? FB 21 49 43 18 2D 44 54 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_182_1_1 {
	meta:
		name = "j0"
		size = 180
		refs = "000c __ieee754_j0 0020 __isnand 003a fabs 0042 __gtdf2 0070 matherr 0088 __errno 009c __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8B B0 04 1C 0D 1C ?? ?? ?? ?? 22 4E 33 68 00 90 01 91 01 33 06 D0 20 1C 29 1C ?? ?? ?? ?? 80 46 00 28 05 D0 00 98 01 99 0B B0 04 BC 90 46 F0 BD 20 1C 29 1C ?? ?? ?? ?? 18 4A 18 4B ?? ?? ?? ?? 00 28 EF DD 05 23 02 93 16 4B 02 AF 7B 60 43 46 3B 62 3C 61 7D 61 BC 60 FD 60 12 4B 13 4C BB 61 FC 61 33 68 02 2B 0C D0 38 1C ?? ?? ?? ?? 00 28 07 D0 3B 6A 00 2B 09 D1 BB 69 FC 69 00 93 01 94 D0 E7 ?? ?? ?? ?? 22 23 03 60 F2 E7 ?? ?? ?? ?? 3B 6A 03 60 F0 E7 ?? ?? ?? ?? FB 21 49 43 18 2D 44 54 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_22_0_1 {
	meta:
		name = "atanh"
		size = 252
		refs = "000c __ieee754_atanh 0020 __isnand 003a fabs 0046 __gedf2 0056 __gtdf2 007c __divdf3 008c matherr 00d0 __errno 00e4 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8D B0 04 1C 0D 1C ?? ?? ?? ?? 34 4E 33 68 00 90 01 91 01 33 06 D0 20 1C 29 1C ?? ?? ?? ?? 80 46 00 28 05 D0 00 98 01 99 0D B0 04 BC 90 46 F0 BD 20 1C 29 1C ?? ?? ?? ?? 2A 4A 2A 4B 02 90 03 91 ?? ?? ?? ?? 00 28 ED DB 02 98 03 99 25 4A 25 4B ?? ?? ?? ?? 00 28 22 DD 01 23 04 93 23 4B 04 AF 23 48 23 49 7B 60 43 46 3B 62 3C 61 7D 61 0B 1C BC 60 FD 60 02 1C ?? ?? ?? ?? 33 68 B8 61 F9 61 02 2B 22 D0 38 1C ?? ?? ?? ?? 00 28 1D D0 3B 6A 00 2B 1F D1 BB 69 FC 69 00 93 01 94 C2 E7 02 23 04 93 11 4B 04 AF 7B 60 43 46 3B 62 3C 61 7D 61 0F 4A 0F 4B BC 60 FD 60 20 1C 29 1C ?? ?? ?? ?? 33 68 B8 61 F9 61 02 2B DC D1 ?? ?? ?? ?? 21 23 03 60 DC E7 ?? ?? ?? ?? 3B 6A 03 60 DA E7 ?? ?? ?? ?? 00 00 F0 3F 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_24_0_1 {
	meta:
		name = "ceilf"
		size = 140
		refs = "0020 __addsf3 0026 __gtsf2"
	strings:
		$1 = { 70 B5 1D 4D 05 40 EC 0D 7F 3C 01 1C 06 1C 16 2C 17 DC 00 2C 1C DB 19 4D 25 41 05 42 0F D0 18 49 ?? ?? ?? ?? 17 49 ?? ?? ?? ?? 00 28 06 DD 00 2E 03 DD 80 23 1B 04 23 41 F6 18 AE 43 31 1C 08 1C 70 BD 11 4B 9D 42 FA D9 ?? ?? ?? ?? 01 1C F6 E7 0B 49 ?? ?? ?? ?? 0B 49 ?? ?? ?? ?? 00 28 ED DD 00 2E 05 DB 00 2D E9 D0 FE 26 B6 05 31 1C E6 E7 80 26 36 06 31 1C E2 E7 FF FF FF 7F FF FF 7F 00 CA F2 49 71 00 00 00 00 FF FF 7F 7F }
	condition:
		$1
}

rule file_25_0_1 {
	meta:
		name = "fmaf"
		size = 16
		refs = "0004 __mulsf3 000a __addsf3"
	strings:
		$1 = { 10 B5 14 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_40_3_2 {
	meta:
		name = "_ZNKSt5ctypeIcE8do_widenEPKcS2_Pc"
		size = 16
		refs = "0008 memcpy"
	strings:
		$1 = { 10 B5 14 1C 18 1C 52 1A ?? ?? ?? ?? 20 1C 10 BD }
	condition:
		$1
}

rule file_40_2_2 {
	meta:
		name = "_ZNKSt5ctypeIcE9do_narrowEPKcS2_cPc"
		size = 16
		refs = "0008 memcpy"
	strings:
		$1 = { 10 B5 14 1C 02 98 52 1A ?? ?? ?? ?? 20 1C 10 BD }
	condition:
		$1
}

rule file_26_0_1 {
	meta:
		name = "__ieee754_acoshf"
		size = 212
		refs = "0018 __addsf3 0030 __subsf3 0042 __mulsf3 004e __ieee754_sqrtf 0058 log1pf 0066 __divsf3 00a0 __ieee754_logf"
	strings:
		$1 = { 70 B5 2D 4A 04 1C 90 42 29 DD 2C 4A 90 42 06 DD 2B 4A 90 42 47 DD 21 1C ?? ?? ?? ?? 70 BD FE 22 92 05 90 42 45 D0 80 22 D2 05 90 42 1E DC 25 49 ?? ?? ?? ?? 04 1C 21 1C ?? ?? ?? ?? 21 1C 05 1C 20 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? ?? ?? ?? ?? 21 1C ?? ?? ?? ?? ?? ?? ?? ?? DE E7 21 1C ?? ?? ?? ?? 01 1C ?? ?? ?? ?? D7 E7 21 1C ?? ?? ?? ?? 14 49 ?? ?? ?? ?? ?? ?? ?? ?? 21 1C 06 1C 20 1C ?? ?? ?? ?? 21 1C 05 1C 30 1C ?? ?? ?? ?? 01 1C 0D 48 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? ?? ?? ?? ?? BA E7 ?? ?? ?? ?? 08 49 ?? ?? ?? ?? B4 E7 07 48 B2 E7 C0 46 FF FF 7F 3F FF FF 7F 4D FF FF 7F 7F 00 00 80 3F 00 00 80 BF 18 72 31 3F 00 00 00 00 }
	condition:
		$1
}

rule file_27_0_1 {
	meta:
		name = "lrint"
		size = 220
		refs = "002c __adddf3 003c __subdf3 00bc __fixdfsi"
	strings:
		$1 = { F0 B5 30 4C 0B 1C 01 1C 02 1C C5 0F 21 40 2E 48 09 15 09 18 82 B0 13 29 25 DC 01 31 4A DB 2B 48 E9 00 41 18 0E 68 4F 68 30 1C 39 1C ?? ?? ?? ?? 00 90 01 91 3B 1C 00 98 01 99 32 1C ?? ?? ?? ?? 03 1C 42 00 36 D0 22 48 80 22 18 40 52 03 02 43 23 40 20 48 1B 15 C3 1A 10 1C 18 41 00 2D 00 D0 40 42 02 B0 F0 BD 1E 29 26 DC 18 48 E9 00 41 18 0E 68 4F 68 30 1C 39 1C ?? ?? ?? ?? 00 90 01 91 32 1C 3B 1C 00 98 01 99 ?? ?? ?? ?? 0A 1C 04 40 01 1C 0D 48 24 15 26 18 0D 48 80 23 08 40 5B 03 03 43 0D 48 24 18 18 1C 34 23 9B 1B A0 40 DA 40 10 43 D3 E7 00 20 D4 E7 10 1C 19 1C ?? ?? ?? ?? CF E7 C0 46 00 00 F0 7F 01 FC FF FF ?? ?? ?? ?? FF FF 0F 00 13 04 00 00 ED FB FF FF }
	condition:
		$1
}

rule file_28_0_1 {
	meta:
		name = "hypot"
		size = 192
		refs = "000c __ieee754_hypot 001c finite 0074 __errno 0092 matherr 00a8 __fdlib_version"
	strings:
		$1 = { F0 B5 8D B0 02 92 03 93 00 90 01 91 ?? ?? ?? ?? 25 4E 33 68 04 1C 0D 1C 01 33 04 D0 ?? ?? ?? ?? 07 1C 00 28 03 D0 0D B0 29 1C 20 1C F0 BD 00 98 01 99 ?? ?? ?? ?? 00 28 F5 D0 02 98 03 99 ?? ?? ?? ?? 00 28 EF D0 03 23 04 93 18 4B 04 AC 63 60 00 9A 01 9B A2 60 E3 60 02 9A 03 9B 22 61 63 61 33 68 27 62 00 2B 0F D0 11 49 12 4A A1 61 E2 61 02 2B 0D D1 ?? ?? ?? ?? 22 23 03 60 23 6A 00 2B 0C D1 E5 69 A4 69 CE E7 0B 4A 0C 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 F0 D1 EB E7 ?? ?? ?? ?? 23 6A 03 60 ED E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 F0 7F 00 00 00 00 FF FF EF 47 00 00 00 E0 }
	condition:
		$1
}

rule file_29_0_1 {
	meta:
		name = "__ieee754_fmod"
		size = 636
		refs = "003a __muldf3 0042 __divdf3"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 84 B0 00 90 01 91 80 26 00 9F 36 06 37 40 BB 46 00 9F B7 43 8C 4E 02 92 03 93 B9 46 37 1C 02 9E 01 9C 03 9D 37 40 BC 46 0E D1 00 2D 0C D1 ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? 04 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 80 4F B9 45 EF DC 6E 42 2E 43 F6 0F 67 46 3E 43 B2 46 7D 4E B2 45 E6 D8 E1 45 05 DC E1 45 E8 DB AC 42 E6 D3 AC 42 37 D0 78 4B 99 45 3C DD 4F 46 77 48 39 15 09 18 75 4B 9C 45 7B DC 62 46 00 2A 00 D0 A1 E0 2B 1C 00 2D 00 DC D6 E0 71 48 5B 00 01 38 00 2B FB DC 70 4A 91 42 72 DB 6B 4A 4E 46 16 40 80 23 5B 03 32 1C 1A 43 6B 4E B0 42 75 DB 66 4E 67 46 80 23 3E 40 5B 03 1E 43 09 1A 00 29 26 D0 93 1B AC 42 00 D2 01 3B 00 2B 44 DB 64 1B 00 2B 16 D1 00 2C 14 D1 58 46 C7 0F 5F 4B FF 00 DB 19 18 68 59 68 A4 E7 4A 46 00 2A 62 D1 23 1C 00 2C 00 DC 9F E0 57 49 5B 00 01 39 00 2B FB DC B9 E7 E2 0F 5B 00 9A 18 64 00 01 39 00 29 D8 D1 96 1B A5 42 00 D9 01 3E 00 2E 01 DB 64 1B 32 1C 00 2A 01 D1 00 2C 1D D0 48 4B 9A 42 06 DC E1 0F 52 00 52 18 64 00 01 38 9A 42 F8 DD 46 4B 98 42 58 DB 47 4B 47 4E D2 18 5F 46 83 19 17 43 1B 05 38 1C 18 43 21 1C 6C E7 E3 0F 52 00 D2 18 64 00 01 39 D3 E7 5A 46 D7 0F 3C 4B FF 00 DB 19 18 68 59 68 5E E7 36 4A 67 46 38 15 80 18 36 4A 91 42 8C DA 53 1A 1F 2B 2F DC 20 22 D2 1A 26 1C D6 40 32 1C 4E 46 9E 40 32 43 9C 40 86 E7 33 1A 1F 2B 1C DC 20 26 F6 1A 2F 1C F7 40 66 46 9E 40 3E 43 9D 40 83 E7 4E 46 F3 02 00 2B 3A DD 26 49 5B 00 01 39 00 2B FB DC 56 E7 66 46 F3 02 00 2B 2E DD 21 48 5B 00 01 38 00 2B FB DC 5C E7 1E 1C 20 3E B5 40 2E 1C 00 25 69 E7 1A 1C 20 3A 94 40 22 1C 00 24 5A E7 1B 1A 14 2B 0B DD 1F 2B 12 DC 20 21 DC 40 CB 1A 9A 40 14 43 5B 46 58 46 18 43 21 1C 0F E7 20 21 C9 1A 17 1C DC 40 8F 40 1A 41 3C 43 13 1C F2 E7 20 3B 14 1C 1C 41 5B 46 ED E7 0A 48 31 E7 09 49 1F E7 07 49 1D E7 06 48 2B E7 C0 46 FF FF FF 7F FF FF EF 7F 00 00 F0 7F FF FF 0F 00 01 FC FF FF ED FB FF FF 02 FC FF FF ?? ?? ?? ?? 00 00 F0 FF FF 03 00 00 }
	condition:
		$1
}

rule file_30_0_1 {
	meta:
		name = "__ieee754_remainderf"
		size = 256
		refs = "0024 __mulsf3 002a __divsf3 0048 fabsf 0060 __addsf3 0068 __ltsf2 0074 __subsf3 0084 __lesf2 00ac __gtsf2 00c0 __gesf2 00de __ieee754_fmodf"
	strings:
		$1 = { F0 B5 47 46 80 B4 38 4B 02 1C 1A 40 0E 1C 04 1C 0D 1C 07 1C 90 46 1E 40 02 D0 34 4B 98 45 09 DD 29 1C 20 1C ?? ?? ?? ?? 01 1C ?? ?? ?? ?? 04 BC 90 46 F0 BD FF 23 DB 05 9E 42 F1 DC 2C 4B 9E 42 48 DD B0 45 41 D0 20 1C ?? ?? ?? ?? 04 1C 28 1C ?? ?? ?? ?? 27 4B 05 1C 9E 42 21 DC 21 1C 20 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 00 28 12 DA 20 1C 29 1C ?? ?? ?? ?? 04 1C 21 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 00 28 04 DC 20 1C 29 1C ?? ?? ?? ?? 04 1C 80 20 00 06 38 40 60 40 C6 E7 15 49 ?? ?? ?? ?? 06 1C 31 1C 20 1C ?? ?? ?? ?? 00 28 F0 DD 20 1C 29 1C ?? ?? ?? ?? 31 1C 04 1C ?? ?? ?? ?? 00 28 E6 DB E0 E7 20 1C 0B 49 ?? ?? ?? ?? AC E7 08 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 04 1C AD E7 C0 46 FF FF FF 7F FF FF 7F 7F FF FF FF 7E FF FF FF 00 00 00 00 3F 00 00 00 00 }
	condition:
		$1
}

rule file_31_0_1 {
	meta:
		name = "pzero"
		size = 324
		refs = "0032 __muldf3 003e __divdf3 0052 __adddf3"
		altNames = "pone"
	strings:
		$1 = { F0 B5 47 4C 0B 1C 21 1C 02 1C 01 40 45 48 82 B0 81 42 00 DD 7B E0 44 48 81 42 00 DD 73 E0 43 48 81 42 00 DD 77 E0 42 4E 37 1C 30 37 58 36 10 1C 19 1C ?? ?? ?? ?? 02 1C 0B 1C 3E 48 3E 49 ?? ?? ?? ?? B2 6A F3 6A 0D 1C 04 1C ?? ?? ?? ?? 32 6A 73 6A ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? B2 69 F3 69 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 32 69 73 69 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? B2 68 F3 68 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 32 68 73 68 ?? ?? ?? ?? 3A 6A 7B 6A 00 90 01 91 29 1C 20 1C ?? ?? ?? ?? BA 69 FB 69 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 3A 69 7B 69 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? BA 68 FB 68 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 3A 68 7B 68 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 13 4A 13 4B ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 0E 4A 0E 4B ?? ?? ?? ?? 02 B0 F0 BD 0D 4F 09 4E 58 37 8F E7 0B 4F 3E 1C 28 36 8B E7 0A 4E 37 1C 08 37 30 36 86 E7 FF FF FF 7F FF FF 1F 40 8A 2E 12 40 6C DB 06 40 ?? ?? ?? ?? 00 00 F0 3F 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_1_1 {
	meta:
		name = "qzero"
		size = 368
		refs = "0036 __muldf3 0042 __divdf3 0056 __adddf3 0112 __subdf3"
	strings:
		$1 = { F0 B5 4F 4A 03 1C 13 40 4E 4A 84 B0 00 90 01 91 93 42 00 DD 8A E0 4C 4A 93 42 00 DD 81 E0 4B 4A 93 42 00 DD 87 E0 4A 4F 3E 1C 20 36 50 37 00 98 01 99 02 1C 0B 1C ?? ?? ?? ?? 02 1C 0B 1C 45 48 45 49 ?? ?? ?? ?? BA 6A FB 6A 0D 1C 04 1C ?? ?? ?? ?? 3A 6A 7B 6A ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? BA 69 FB 69 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 3A 69 7B 69 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? BA 68 FB 68 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 3A 68 7B 68 ?? ?? ?? ?? B2 6A F3 6A 02 90 03 91 29 1C 20 1C ?? ?? ?? ?? 32 6A 73 6A ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? B2 69 F3 69 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 32 69 73 69 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? B2 68 F3 68 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 32 68 73 68 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 16 4A 16 4B ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 13 4A 13 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 04 B0 F0 BD 10 4F 3E 1C 40 36 70 37 80 E7 0E 4E 0D 4F 60 36 10 37 7B E7 0D 4E 37 1C 30 37 77 E7 C0 46 FF FF FF 7F FF FF 1F 40 8A 2E 12 40 6C DB 06 40 ?? ?? ?? ?? 00 00 F0 3F 00 00 00 00 00 00 C0 3F 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_2_1 {
	meta:
		name = "__ieee754_j0"
		size = 856
		refs = "001a __muldf3 0026 __divdf3 0036 fabs 0054 __adddf3 005c __gtdf2 009e __subdf3 018c sin 0198 cos 01ba __ieee754_sqrt 0222 __ltdf2"
	strings:
		$1 = { F0 B5 47 46 80 B4 AF 4C 0B 1C AF 49 04 40 88 B0 02 1C 8C 42 0D DD 10 1C 19 1C ?? ?? ?? ?? 02 1C 0B 1C AA 48 AA 49 ?? ?? ?? ?? 08 B0 04 BC 90 46 F0 BD 19 1C 10 1C ?? ?? ?? ?? A6 4B 00 90 01 91 9C 42 00 DD A2 E0 A4 4B 9C 42 12 DC A3 4A A4 4B 00 98 01 99 ?? ?? ?? ?? 9C 4A 9D 4B ?? ?? ?? ?? 00 28 06 DD 9F 4B 9C 42 00 DD B5 E0 97 48 98 49 DB E7 00 98 01 99 02 1C 0B 1C ?? ?? ?? ?? 9A 4A 9A 4B 05 1C 0E 1C ?? ?? ?? ?? 99 4A 99 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 97 4A 97 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 95 4A 95 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 93 4A 93 4B 02 90 03 91 28 1C 31 1C ?? ?? ?? ?? 91 4A 91 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 8F 4A 8F 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 8D 4A 8D 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 74 4A 74 4B ?? ?? ?? ?? 89 4B 04 90 05 91 9C 42 2C DD 00 98 01 99 86 4A 87 4B ?? ?? ?? ?? 04 9A 05 9B 00 90 01 91 02 98 03 99 ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 66 4A 67 4B 06 1C 0F 1C 00 98 01 99 ?? ?? ?? ?? 00 9A 01 9B 04 1C 0D 1C 60 48 61 49 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 61 E7 04 9A 05 9B 02 98 03 99 ?? ?? ?? ?? 70 4A 70 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 52 4A 52 4B ?? ?? ?? ?? 4E E7 ?? ?? ?? ?? 05 1C 0E 1C 00 98 01 99 ?? ?? ?? ?? 02 90 03 91 02 9A 03 9B 28 1C 31 1C ?? ?? ?? ?? 63 4B 04 90 05 91 9C 42 21 DD 00 98 01 99 ?? ?? ?? ?? 60 4A 60 4B 04 1C 0D 1C 04 98 05 99 ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 28 E7 5B 4A 5C 4B 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 36 4A 37 4B ?? ?? ?? ?? 17 E7 00 98 01 99 02 1C 0B 1C ?? ?? ?? ?? ?? ?? ?? ?? 80 23 1B 06 C7 18 88 46 02 9A 03 9B 28 1C 31 1C ?? ?? ?? ?? 4C 4A 4C 4B ?? ?? ?? ?? 00 28 42 DA 02 9A 03 9B 28 1C 31 1C ?? ?? ?? ?? 06 90 07 91 06 9A 07 9B 38 1C 41 46 ?? ?? ?? ?? 04 90 05 91 90 23 DB 05 9C 42 B1 DC 00 98 01 99 FF F7 79 FD 04 1C 0D 1C 00 98 01 99 FF F7 15 FE 02 90 03 91 00 98 01 99 ?? ?? ?? ?? 22 1C 06 1C 0F 1C 2B 1C 04 98 05 99 ?? ?? ?? ?? 02 9A 03 9B 04 1C 0D 1C 06 98 07 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 28 4A 28 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? BC E6 38 1C 41 46 04 9A 05 9B ?? ?? ?? ?? 06 90 07 91 C3 E7 C0 46 FF FF FF 7F FF FF EF 7F 00 00 F0 3F 00 00 00 00 FF FF FF 3F FF FF 1F 3F 3C E4 37 7E 9C 75 00 88 FF FF 3F 3E E7 D5 33 BE CE 3F D6 73 D1 B1 BE 3E 19 39 50 0C A5 E6 28 3F E9 C6 1A B6 FF FF 8F 3F FD FF FF FF BC 08 14 3E 8F 5D 74 F4 54 3B A1 3E A9 D5 84 CE D2 A6 1E 3F F4 DB 57 DD E8 FC 8F 3F A4 C2 C8 82 FF FF EF 3F 00 00 E0 3F 00 00 00 00 00 00 D0 3F 00 00 00 00 FF FF DF 7F D7 0D E2 3F 6D 9B 42 50 00 00 D0 BF 00 00 00 00 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_31_3_1 {
	meta:
		name = "__ieee754_y0"
		size = 832
		refs = "0040 __muldf3 0054 __adddf3 0064 __subdf3 00f8 __divdf3 0104 __ieee754_j0 0110 __ieee754_log 018e sin 019a cos 01bc __ieee754_sqrt 0210 __ltdf2"
	strings:
		$1 = { F0 B5 47 46 80 B4 AA 4E AA 4B 06 40 0D 1C 88 B0 04 1C 01 1C 9E 42 00 DD 9A E0 00 2E 00 D1 8A E0 00 29 00 DA D9 E0 A4 4B 9E 42 00 DD AD E0 F9 23 9B 05 9E 42 00 DC 9B E0 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 9D 4A 9E 4B 06 1C 0F 1C ?? ?? ?? ?? 9C 4A 9D 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 9A 4A 9B 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 98 4A 99 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 96 4A 97 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 94 4A 95 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 92 4A 93 4B ?? ?? ?? ?? 92 4A 93 4B 00 90 01 91 30 1C 39 1C ?? ?? ?? ?? 90 4A 91 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 8E 4A 8F 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 8C 4A 8D 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 8A 4A 8B 4B ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 00 90 01 91 20 1C 29 1C ?? ?? ?? ?? 06 1C 0F 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 7E 4A 7F 4B ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 08 E0 00 2D 00 D0 71 E7 79 48 7A 49 7A 4A 7B 4B ?? ?? ?? ?? 08 B0 04 BC 90 46 F0 BD 22 1C 2B 1C 29 1C ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 02 1C 0B 1C 6B 48 6B 49 ?? ?? ?? ?? EB E7 20 1C 29 1C ?? ?? ?? ?? 68 4A 69 4B ?? ?? ?? ?? 5A 4A 5B 4B ?? ?? ?? ?? DE E7 20 1C 29 1C ?? ?? ?? ?? 02 90 03 91 20 1C 29 1C ?? ?? ?? ?? 00 90 01 91 00 9A 01 9B 02 98 03 99 ?? ?? ?? ?? 61 4B 04 90 05 91 9E 42 17 DD 20 1C 29 1C ?? ?? ?? ?? 5D 4A 5E 4B 04 1C 0D 1C 04 98 05 99 ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? B6 E7 54 48 54 49 02 1C 0B 1C ?? ?? ?? ?? AF E7 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? ?? ?? ?? ?? 80 23 1B 06 C7 18 88 46 00 9A 01 9B 02 98 03 99 ?? ?? ?? ?? 47 4A 48 4B ?? ?? ?? ?? 00 28 3A DA 38 1C 41 46 04 9A 05 9B ?? ?? ?? ?? 06 90 07 91 90 23 DB 05 9E 42 C3 DC 20 1C 29 1C FF F7 DE FB 06 1C 0F 1C 20 1C 29 1C FF F7 7A FC 00 90 01 91 20 1C 29 1C ?? ?? ?? ?? 32 1C 02 90 03 91 3B 1C 04 98 05 99 ?? ?? ?? ?? 00 9A 01 9B 04 1C 0D 1C 06 98 07 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 2E 4A 2F 4B ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 5C E7 00 9A 01 9B 02 98 03 99 ?? ?? ?? ?? 06 90 07 91 06 9A 07 9B 38 1C 41 46 ?? ?? ?? ?? 04 90 05 91 BB E7 FF FF FF 7F FF FF EF 7F FF FF FF 3F 3D E4 C5 BD C8 B3 3F 69 57 00 55 3E D4 AB 4E 3B A7 FE CF 3E AD 5C D2 73 4D C5 36 3F 6B 9B B2 20 E8 4C 8C 3F 97 FA 6C B1 01 9D C6 3F FC E3 E9 9D D6 E4 B2 3F 1F D0 CB 99 18 50 FE 3D EF D9 D6 3B 2D 64 91 3E FD 02 F2 7F BB EC 13 3F C1 C6 78 F5 70 12 8A 3F 1A C7 C9 91 00 00 F0 3F 00 00 00 00 30 5F E4 3F 83 C8 C9 6D 00 00 F0 BF 00 00 00 00 00 00 00 00 00 00 00 00 FF FF DF 7F D7 0D E2 3F 6D 9B 42 50 }
	condition:
		$1
}

rule file_32_0_1 {
	meta:
		name = "fabs"
		size = 16
	strings:
		$1 = { 10 B5 02 4A 03 1C 10 1C 18 40 10 BD FF FF FF 7F }
	condition:
		$1
}

rule file_33_0_1 {
	meta:
		name = "remquo"
		size = 86
		refs = "0024 __divdf3 0028 fabs 002c lrint 0046 remainder"
	strings:
		$1 = { F0 B5 47 46 80 B4 16 1C 04 1C 1F 1C E2 0F F3 0F 0D 1C 9A 42 1C D0 01 23 5B 42 98 46 32 1C 3B 1C 29 1C 20 1C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 7F 23 18 40 03 1C 40 46 58 43 06 9B 29 1C 18 60 32 1C 3B 1C 20 1C ?? ?? ?? ?? 04 BC 90 46 F0 BD 01 23 98 46 E2 E7 }
	condition:
		$1
}

rule file_34_0_1 {
	meta:
		name = "pow10"
		size = 24
		refs = "000a pow"
		altNames = "exp10"
	strings:
		$1 = { 00 B5 02 1C 0B 1C 03 49 01 48 ?? ?? ?? ?? 00 BD 00 00 24 40 00 00 00 00 }
	condition:
		$1
}

rule file_35_0_1 {
	meta:
		name = "log10"
		size = 256
		refs = "000c __ieee754_log10 0020 __isnand 0032 __ledf2 0062 __eqdf2 0074 matherr 00b4 nan 00be __errno 00dc __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8B B0 04 1C 0D 1C ?? ?? ?? ?? 32 4E 33 68 00 90 01 91 01 33 36 D0 20 1C 29 1C ?? ?? ?? ?? 80 46 00 28 2F D1 20 1C 29 1C 2C 4A 2C 4B ?? ?? ?? ?? 00 28 27 DC 2B 4B 02 AF 36 68 7B 60 43 46 3B 62 BC 60 FD 60 3C 61 7D 61 00 2E 21 D0 26 4A 26 4B BA 61 FB 61 20 1C 29 1C 20 4A 20 4B ?? ?? ?? ?? 00 28 1A D1 02 23 02 93 02 2E 2A D0 38 1C ?? ?? ?? ?? 00 28 25 D0 3B 6A 00 2B 1D D1 BB 69 FC 69 00 93 01 94 00 98 01 99 0B B0 04 BC 90 46 F0 BD 17 4A 17 4B BA 61 FB 61 DC E7 01 23 02 93 02 2E 14 D0 38 1C ?? ?? ?? ?? 00 28 0F D0 12 48 ?? ?? ?? ?? B8 61 F9 61 DE E7 ?? ?? ?? ?? 3B 6A 03 60 DC E7 ?? ?? ?? ?? 22 23 03 60 D4 E7 ?? ?? ?? ?? 21 23 03 60 EA E7 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 F0 FF 00 00 00 00 FF FF EF C7 00 00 00 E0 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_81_0_1 {
	meta:
		name = "log"
		size = 256
		refs = "000c __ieee754_log 0020 __isnand 0032 __gtdf2 0062 __eqdf2 0074 matherr 00b4 nan 00be __errno 00dc __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8B B0 04 1C 0D 1C ?? ?? ?? ?? 32 4E 33 68 00 90 01 91 01 33 36 D0 20 1C 29 1C ?? ?? ?? ?? 80 46 00 28 2F D1 20 1C 29 1C 2C 4A 2C 4B ?? ?? ?? ?? 00 28 27 DC 2B 4B 02 AF 36 68 7B 60 43 46 3B 62 BC 60 FD 60 3C 61 7D 61 00 2E 21 D0 26 4A 26 4B BA 61 FB 61 20 1C 29 1C 20 4A 20 4B ?? ?? ?? ?? 00 28 1A D1 02 23 02 93 02 2E 2A D0 38 1C ?? ?? ?? ?? 00 28 25 D0 3B 6A 00 2B 1D D1 BB 69 FC 69 00 93 01 94 00 98 01 99 0B B0 04 BC 90 46 F0 BD 17 4A 17 4B BA 61 FB 61 DC E7 01 23 02 93 02 2E 14 D0 38 1C ?? ?? ?? ?? 00 28 0F D0 12 48 ?? ?? ?? ?? B8 61 F9 61 DE E7 ?? ?? ?? ?? 3B 6A 03 60 DC E7 ?? ?? ?? ?? 22 23 03 60 D4 E7 ?? ?? ?? ?? 21 23 03 60 EA E7 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 F0 FF 00 00 00 00 FF FF EF C7 00 00 00 E0 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_37_0_1 {
	meta:
		name = "ynf"
		size = 288
		refs = "000c __ieee754_ynf 001c isnanf 002a __lesf2 0036 __gtsf2 004c __floatsidf 0058 __extendsfdf2 0070 matherr 007e __errno 008a __truncdfsf2 00f8 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 89 B0 07 1C 0C 1C ?? ?? ?? ?? 39 4E 33 68 05 1C 01 33 3A D0 20 1C ?? ?? ?? ?? 80 46 00 28 34 D1 20 1C 34 49 ?? ?? ?? ?? 00 28 33 DD 20 1C 32 49 ?? ?? ?? ?? 00 28 28 DD 05 23 00 93 30 4B 38 1C 01 93 43 46 08 93 ?? ?? ?? ?? 6D 46 A8 60 E9 60 20 1C ?? ?? ?? ?? 2A 4B 2B 4C AB 61 EC 61 33 68 28 61 69 61 02 2B 3E D0 68 46 ?? ?? ?? ?? 00 28 39 D0 2B 6A 00 2B 03 D0 ?? ?? ?? ?? 2B 6A 03 60 A8 69 E9 69 ?? ?? ?? ?? 05 1C 09 B0 28 1C 04 BC 90 46 F0 BD 01 23 00 93 19 4B 38 1C 01 93 43 46 08 93 ?? ?? ?? ?? 6D 46 A8 60 E9 60 20 1C ?? ?? ?? ?? 33 68 28 61 69 61 00 2B 0D D1 13 4B 13 4C AB 61 EC 61 68 46 ?? ?? ?? ?? 00 28 D1 D1 ?? ?? ?? ?? 21 23 03 60 CC E7 0E 49 0E 4A A9 61 EA 61 02 2B F4 D0 EE E7 ?? ?? ?? ?? 22 23 03 60 C0 E7 C0 46 ?? ?? ?? ?? 00 00 00 00 DB 0F 49 5A ?? ?? ?? ?? 00 00 00 00 00 00 00 00 FF FF EF C7 00 00 00 E0 00 00 F0 FF 00 00 00 00 }
	condition:
		$1
}

rule file_37_1_1 {
	meta:
		name = "jnf"
		size = 180
		refs = "000c __ieee754_jnf 001c isnanf 0032 fabsf 0038 __gtsf2 004e __floatsidf 005a __extendsfdf2 0072 matherr 0084 __truncdfsf2 008c __errno 00a0 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 89 B0 07 1C 0C 1C ?? ?? ?? ?? 23 4E 33 68 05 1C 01 33 05 D0 20 1C ?? ?? ?? ?? 80 46 00 28 04 D0 09 B0 28 1C 04 BC 90 46 F0 BD 20 1C ?? ?? ?? ?? 1B 49 ?? ?? ?? ?? 00 28 F2 DD 05 23 00 93 18 4B 38 1C 01 93 43 46 08 93 ?? ?? ?? ?? 6D 46 A8 60 E9 60 20 1C ?? ?? ?? ?? 13 4B 13 4C AB 61 EC 61 33 68 28 61 69 61 02 2B 0D D0 68 46 ?? ?? ?? ?? 00 28 08 D0 2B 6A 00 2B 0A D1 A8 69 E9 69 ?? ?? ?? ?? 05 1C CC E7 ?? ?? ?? ?? 22 23 03 60 F1 E7 ?? ?? ?? ?? 2B 6A 03 60 EF E7 ?? ?? ?? ?? DB 0F 49 5A ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_38_0_1 {
	meta:
		name = "gammaf_r"
		size = 236
		refs = "0006 __ieee754_gammaf_r 0014 finitef 0036 __extendsfdf2 0054 floorf 005a __eqsf2 0066 __lesf2 007a matherr 008c __truncdfsf2 009e __errno 00d0 __fdlib_version"
	strings:
		$1 = { F0 B5 89 B0 05 1C ?? ?? ?? ?? 31 4E 33 68 04 1C 01 33 04 D0 ?? ?? ?? ?? 07 1C 00 28 02 D0 09 B0 20 1C F0 BD 28 1C ?? ?? ?? ?? 00 28 F7 D0 29 4B 28 1C 01 93 08 97 ?? ?? ?? ?? 33 68 6C 46 20 61 61 61 A0 60 E1 60 00 2B 24 D1 23 4A 23 4B A2 61 E3 61 28 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 00 28 05 D1 28 1C 1E 49 ?? ?? ?? ?? 00 28 1C DD 03 23 00 93 33 68 02 2B 12 D0 68 46 ?? ?? ?? ?? 00 28 0D D0 23 6A 00 2B 1E D1 A0 69 E1 69 ?? ?? ?? ?? 04 1C C4 E7 13 4A 14 4B A2 61 E3 61 D9 E7 ?? ?? ?? ?? 22 23 03 60 EC E7 02 23 00 93 33 68 02 2B 04 D0 68 46 ?? ?? ?? ?? 00 28 E2 D1 ?? ?? ?? ?? 21 23 03 60 DD E7 ?? ?? ?? ?? 23 6A 03 60 DB E7 ?? ?? ?? ?? ?? ?? ?? ?? FF FF EF 47 00 00 00 E0 00 00 00 00 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_116_0_1 {
	meta:
		name = "lgammaf_r"
		size = 236
		refs = "0006 __ieee754_lgammaf_r 0014 finitef 0036 __extendsfdf2 0054 floorf 005a __eqsf2 0066 __lesf2 007a matherr 008c __truncdfsf2 009e __errno 00d0 __fdlib_version"
	strings:
		$1 = { F0 B5 89 B0 05 1C ?? ?? ?? ?? 31 4E 33 68 04 1C 01 33 04 D0 ?? ?? ?? ?? 07 1C 00 28 02 D0 09 B0 20 1C F0 BD 28 1C ?? ?? ?? ?? 00 28 F7 D0 29 4B 28 1C 01 93 08 97 ?? ?? ?? ?? 33 68 6C 46 20 61 61 61 A0 60 E1 60 00 2B 24 D1 23 4A 23 4B A2 61 E3 61 28 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 00 28 05 D1 28 1C 1E 49 ?? ?? ?? ?? 00 28 1C DD 03 23 00 93 33 68 02 2B 12 D0 68 46 ?? ?? ?? ?? 00 28 0D D0 23 6A 00 2B 1E D1 A0 69 E1 69 ?? ?? ?? ?? 04 1C C4 E7 13 4A 14 4B A2 61 E3 61 D9 E7 ?? ?? ?? ?? 22 23 03 60 EC E7 02 23 00 93 33 68 02 2B 04 D0 68 46 ?? ?? ?? ?? 00 28 E2 D1 ?? ?? ?? ?? 21 23 03 60 DD E7 ?? ?? ?? ?? 23 6A 03 60 DB E7 ?? ?? ?? ?? ?? ?? ?? ?? FF FF EF 47 00 00 00 E0 00 00 00 00 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_39_0_1 {
	meta:
		name = "pow"
		size = 920
		refs = "0012 __ieee754_pow 0026 __isnand 0054 __eqdf2 008a matherr 009a __errno 0130 finite 01b8 __ltdf2 0244 __divdf3 02f4 __fdlib_version 032c __muldf3 0334 rint 033c __nedf2"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 8D B0 1D 1C 00 90 01 91 14 1C ?? ?? ?? ?? B7 4E 33 68 02 90 03 91 01 33 06 D0 20 1C 29 1C ?? ?? ?? ?? 80 46 00 28 06 D0 02 98 03 99 0D B0 0C BC 90 46 9A 46 F0 BD 00 98 01 99 ?? ?? ?? ?? 82 46 00 28 2B D0 20 1C 29 1C A9 4A AA 4B ?? ?? ?? ?? 00 28 E9 D1 01 23 04 93 A7 4B 04 AF 42 46 7B 60 3A 62 00 9A 01 9B 3C 61 7D 61 BA 60 FB 60 A3 4B A3 4C BB 61 FC 61 33 68 02 2B 3C D0 01 33 3A D0 38 1C ?? ?? ?? ?? 00 28 00 D1 E3 E0 3B 6A 00 2B 35 D0 ?? ?? ?? ?? 3B 6A 03 60 30 E0 00 98 01 99 93 4A 94 4B ?? ?? ?? ?? 00 28 3B D1 20 1C 29 1C 8F 4A 90 4B ?? ?? ?? ?? 00 28 6E D1 01 23 04 93 8D 4B 04 AF 52 46 7B 60 3A 62 00 9A 01 9B 3C 61 7D 61 BA 60 FB 60 86 4B 86 4C BB 61 FC 61 33 68 00 2B 11 D0 85 4B 86 4C BB 61 FC 61 BA 69 FB 69 02 92 03 93 98 E7 81 4B 81 4C BB 61 FC 61 BB 69 FC 69 02 93 03 94 8F E7 38 1C ?? ?? ?? ?? 00 28 00 D1 A4 E0 3B 6A 00 2B E8 D0 ?? ?? ?? ?? 3B 6A 03 60 E3 E7 02 98 03 99 ?? ?? ?? ?? 80 46 00 28 5E D0 02 98 03 99 6E 4A 6E 4B ?? ?? ?? ?? 00 28 00 D0 71 E7 00 98 01 99 ?? ?? ?? ?? 00 28 00 D1 6A E7 20 1C 29 1C ?? ?? ?? ?? 00 28 00 D1 63 E7 04 23 04 93 64 4B 04 AF 7B 60 00 23 3B 62 00 9A 01 9B 3C 61 7D 61 BA 60 FB 60 5D 4B 5D 4C BB 61 FC 61 33 68 02 2B 74 D0 38 1C ?? ?? ?? ?? 00 28 6F D0 3B 6A 00 2B A9 D0 BF E7 20 1C 29 1C ?? ?? ?? ?? 00 28 00 D1 3F E7 20 1C 29 1C 50 4A 51 4B ?? ?? ?? ?? 00 28 00 DB 36 E7 01 23 04 93 4E 4B 04 AF 7B 60 53 46 3B 62 00 9A 01 9B BA 60 FB 60 33 68 3C 61 7D 61 00 2B 46 D0 4A 49 4A 4A B9 61 FA 61 02 2B 30 D1 ?? ?? ?? ?? 21 23 03 60 D0 E7 00 98 01 99 ?? ?? ?? ?? 00 28 9A D0 20 1C 29 1C ?? ?? ?? ?? 00 28 94 D0 02 98 03 99 ?? ?? ?? ?? 00 28 33 D0 01 23 04 93 37 4B 04 AF 7B 60 43 46 3B 62 3C 61 7D 61 00 9A 01 9B 34 68 BA 60 FB 60 00 2C 19 D0 2E 48 2F 49 02 1C 0B 1C ?? ?? ?? ?? B8 61 F9 61 02 2C CE D0 38 1C ?? ?? ?? ?? 00 28 9F D1 C8 E7 ?? ?? ?? ?? 21 23 03 60 16 E7 ?? ?? ?? ?? 21 23 03 60 55 E7 21 4B 22 4C BB 61 FC 61 EA E7 ?? ?? ?? ?? 22 23 03 60 8A E7 03 23 04 93 1D 4B 04 AF 7B 60 00 9A 01 9B BA 60 FB 60 33 68 38 62 3C 61 7D 61 98 46 00 2B 16 D1 1B 4A 1C 4B 00 98 01 99 BA 61 FB 61 11 4A 12 4B ?? ?? ?? ?? 00 28 33 DB 38 1C ?? ?? ?? ?? 00 28 00 D0 29 E7 ?? ?? ?? ?? 22 23 03 60 24 E7 12 4A 12 4B 00 98 01 99 BA 61 FB 61 06 4A 06 4B ?? ?? ?? ?? 00 28 33 DB 44 46 02 2C E5 D1 EA E7 C0 46 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 F0 3F 00 00 00 00 00 00 F0 FF 00 00 00 00 FF FF EF 47 00 00 00 E0 00 00 F0 7F 00 00 00 00 17 4B 16 4A 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 00 28 1A D0 10 4B 11 4C 36 68 BB 61 FC 61 B0 46 CB E7 0C 4B 0A 4A 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 00 28 03 D0 07 4B 07 4C BB 61 FC 61 36 68 B0 46 B4 E7 00 00 E0 3F 00 00 00 00 FF FF EF C7 00 00 00 E0 00 00 F0 FF 00 00 00 00 }
	condition:
		$1
}

rule file_42_0_1 {
	meta:
		name = "expf"
		size = 244
		refs = "0006 __ieee754_expf 0016 finitef 0022 __gtsf2 002e __ltsf2 0044 __extendsfdf2 0062 matherr 0070 __errno 007c __truncdfsf2 00cc __fdlib_version"
	strings:
		$1 = { 70 B5 89 B0 04 1C ?? ?? ?? ?? 30 4E 33 68 05 1C 01 33 36 D0 20 1C ?? ?? ?? ?? 00 28 31 D0 20 1C 2B 49 ?? ?? ?? ?? 00 28 2E DC 20 1C 29 49 ?? ?? ?? ?? 00 28 25 DA 04 23 00 93 27 4B 20 1C 01 93 00 23 08 93 ?? ?? ?? ?? 24 4B 25 4C 6D 46 AB 61 EC 61 33 68 28 61 69 61 A8 60 E9 60 02 2B 2F D0 68 46 ?? ?? ?? ?? 00 28 2A D0 2B 6A 00 2B 03 D0 ?? ?? ?? ?? 2B 6A 03 60 A8 69 E9 69 ?? ?? ?? ?? 05 1C 09 B0 28 1C 70 BD 03 23 00 93 12 4B 20 1C 01 93 00 23 08 93 ?? ?? ?? ?? 33 68 6D 46 28 61 69 61 A8 60 E9 60 00 2B 04 D1 0E 4B 0E 4C AB 61 EC 61 D5 E7 0D 49 0E 4A A9 61 EA 61 02 2B CF D1 ?? ?? ?? ?? 22 23 03 60 CF E7 C0 46 ?? ?? ?? ?? 80 71 B1 42 B5 F1 CF C2 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 FF FF EF 47 00 00 00 E0 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_43_0_1 {
	meta:
		name = "expm1f"
		size = 780
		refs = "0034 __addsf3 003a __ltsf2 0064 __mulsf3 0088 __subsf3 00e0 __divsf3 0186 __fixsfsi 018c __floatsisf"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 A5 4A 03 1C 80 25 13 40 A4 4A 2D 06 04 1C 05 40 93 42 18 D9 FF 22 D2 05 93 42 00 D9 8F E0 93 42 00 D1 D2 E0 00 2D 00 D1 9E E0 9D 49 ?? ?? ?? ?? 9C 49 ?? ?? ?? ?? 00 28 00 DA C8 E0 00 2D 00 D1 95 E0 99 4D 94 E0 99 4A 93 42 00 D9 C1 E0 98 4A 93 42 00 D8 7C E0 00 26 96 49 20 1C ?? ?? ?? ?? 80 46 41 46 20 1C ?? ?? ?? ?? 93 49 05 1C ?? ?? ?? ?? 92 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 90 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 8E 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 8C 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 8A 49 ?? ?? ?? ?? 41 46 07 1C ?? ?? ?? ?? 01 1C 87 48 ?? ?? ?? ?? 80 46 41 46 38 1C ?? ?? ?? ?? 41 46 07 1C 20 1C ?? ?? ?? ?? 01 1C 81 48 ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 01 1C 00 2E 00 D1 80 E0 51 46 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 51 46 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 05 1C 73 1C 00 D1 9E E0 01 2E 00 D1 88 E0 73 1C 39 2B 00 D9 76 E0 16 2E 00 DD A0 E0 80 27 7F 04 FE 23 9B 05 21 1C 37 41 DF 1B ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? F4 05 24 18 03 E0 21 1C ?? ?? ?? ?? 04 1C 20 1C 0C BC 90 46 9A 46 F0 BD 61 49 ?? ?? ?? ?? 01 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 04 1C EE E7 5C 4A 93 42 27 D8 51 4D 5B 49 20 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? ?? ?? ?? ?? 06 1C ?? ?? ?? ?? 56 49 07 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 54 49 05 1C 38 1C ?? ?? ?? ?? 07 1C 39 1C 28 1C ?? ?? ?? ?? 04 1C 21 1C 28 1C ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 82 46 4C E7 46 48 01 1C ?? ?? ?? ?? 04 1C BD E7 00 2D BB D0 47 4C B9 E7 47 4A 93 42 00 D9 30 E7 00 2D 0B D1 45 49 ?? ?? ?? ?? 01 26 05 1C 3F 4F DA E7 20 1C ?? ?? ?? ?? 29 1C B0 E7 3F 49 ?? ?? ?? ?? 01 26 05 1C 76 42 3D 4F CD E7 21 1C ?? ?? ?? ?? 01 1C 2F 48 ?? ?? ?? ?? F6 05 30 18 2C 49 ?? ?? ?? ?? 04 1C 91 E7 20 1C 35 49 ?? ?? ?? ?? 00 28 27 DA 20 1C 20 49 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 30 49 ?? ?? ?? ?? 04 1C 7E E7 20 1C 29 1C ?? ?? ?? ?? 18 49 ?? ?? ?? ?? 17 49 ?? ?? ?? ?? 04 1C 72 E7 7F 21 89 1B C9 05 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 16 49 ?? ?? ?? ?? F4 05 24 18 63 E7 20 1C 29 1C ?? ?? ?? ?? 01 1C ?? ?? ?? ?? 0F 49 ?? ?? ?? ?? 04 1C 57 E7 C0 46 FF FF FF 7F 43 B8 95 41 60 42 A2 0D 00 00 00 00 00 00 00 BF 18 72 B1 3E FF FF FF 32 00 00 00 3F BB ED 57 B4 54 7E 86 36 CD 70 A6 38 01 0D D0 3A 89 88 08 3D 00 00 80 3F 00 00 40 40 00 00 C0 40 CA F2 49 71 17 72 B1 42 3B AA B8 3F 80 71 31 BF D1 F7 17 37 00 00 80 BF 91 15 85 3F 80 71 31 3F D1 F7 17 B7 00 00 80 BE 00 00 00 C0 }
	condition:
		$1
}

rule file_44_0_1 {
	meta:
		name = "fdim"
		size = 76
		refs = "000a __fpclassifyd 001a __gtdf2 0030 __subdf3"
	strings:
		$1 = { F0 B5 04 1C 0D 1C 16 1C 1F 1C ?? ?? ?? ?? 01 28 11 D9 20 1C 29 1C 32 1C 3B 1C ?? ?? ?? ?? 00 28 02 DC 07 49 05 48 F0 BD 20 1C 29 1C 32 1C 3B 1C ?? ?? ?? ?? F7 E7 03 48 03 49 F4 E7 00 00 00 00 00 00 00 00 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_45_0_1 {
	meta:
		name = "rint"
		size = 312
		refs = "0096 __adddf3 00a6 __subdf3"
	strings:
		$1 = { F0 B5 47 46 80 B4 05 1C 6F 00 45 4C 02 1C 0B 1C 06 1C 7F 0D 08 1C E9 0F 88 46 39 19 82 B0 13 29 14 DC 00 29 47 DB 3F 4F 0F 41 2F 42 40 D0 7F 08 2F 42 01 D1 00 28 24 D0 13 29 00 D1 6D E0 80 23 BD 43 9B 02 0B 41 2E 1C 1E 43 1A E0 33 29 09 DD 80 20 C0 00 81 42 59 D0 02 B0 10 1C 19 1C 04 BC 90 46 F0 BD 30 4D 01 21 7F 19 49 42 F9 40 01 42 F2 D0 49 08 01 42 04 D0 80 23 DB 05 88 43 3B 41 18 43 03 1C 29 49 40 46 C4 00 0C 19 65 68 24 68 32 1C 20 1C 29 1C ?? ?? ?? ?? 00 90 01 91 22 1C 2B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C D3 E7 00 28 D1 D0 BB E7 69 00 01 D1 00 28 CC D0 19 49 0D 40 28 43 41 42 08 43 80 21 00 0B 09 03 01 40 17 4D 44 46 15 48 0A 1C E1 00 41 18 2E 40 32 43 0D 68 4E 68 28 1C 31 1C ?? ?? ?? ?? 00 90 01 91 2A 1C 33 1C 00 98 01 99 ?? ?? ?? ?? 0D 4D 0B 1C E4 07 29 1C 01 40 22 1C 0A 43 A5 E7 10 1C 19 1C ?? ?? ?? ?? 02 1C 0B 1C 9E E7 80 20 C0 05 B0 E7 01 FC FF FF FF FF 0F 00 ED FB FF FF ?? ?? ?? ?? 00 00 FE FF FF FF FF 7F }
	condition:
		$1
}

rule file_46_0_1 {
	meta:
		name = "scalblnf"
		size = 184
		refs = "001e __mulsf3 0036 copysignf 004c __addsf3"
	strings:
		$1 = { 30 B5 FF 24 0D 1C E4 05 01 1C 21 40 C9 15 03 1C 02 1C 00 29 17 D1 58 00 13 D0 18 1C 1F 49 ?? ?? ?? ?? 04 40 E1 15 03 1C 02 1C 19 39 49 19 FE 29 10 DD 19 1C 1A 48 ?? ?? ?? ?? 19 49 ?? ?? ?? ?? 03 1C 18 1C 30 BD FF 29 F0 D1 19 1C ?? ?? ?? ?? 03 1C F6 E7 13 48 85 42 EB DC 13 48 85 42 13 DB 00 29 04 DD CB 05 11 49 0A 40 13 43 E9 E7 08 1C 18 30 09 DB 0D 4B 19 31 1A 40 C8 05 10 43 0C 49 ?? ?? ?? ?? 03 1C DC E7 19 1C 0A 48 ?? ?? ?? ?? 08 49 ?? ?? ?? ?? 03 1C D3 E7 C0 46 00 00 00 4C CA F2 49 71 50 C3 00 00 B0 3C FF FF FF FF 7F 80 00 00 00 33 60 42 A2 0D }
	condition:
		$1
}

rule file_47_0_1 {
	meta:
		name = "lroundf"
		size = 92
		refs = "0030 __fixsfsi"
	strings:
		$1 = { 00 B5 43 00 1B 0E 01 1C 7F 3B 00 28 14 DB 01 22 1E 2B 0D DC 00 2B 1A DB 0F 48 01 40 80 20 00 04 01 43 16 2B 0B DD 17 3B 99 40 4A 43 10 1C 00 BD ?? ?? ?? ?? 02 1C F9 E7 01 22 52 42 E8 E7 80 20 C0 03 18 41 41 18 17 20 C3 1A D9 40 ED E7 01 33 EC D0 00 22 EA E7 C0 46 FF FF 7F 00 }
	condition:
		$1
}

rule file_48_0_1 {
	meta:
		name = "fmod"
		size = 208
		refs = "0010 __ieee754_fmod 0024 __isnand 004e __eqdf2 007e __divdf3 008a __errno 00ac matherr 00c0 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8D B0 1D 1C 00 90 01 91 14 1C ?? ?? ?? ?? 2A 4E 33 68 02 90 03 91 01 33 05 D0 20 1C 29 1C ?? ?? ?? ?? 00 28 05 D0 02 98 03 99 0D B0 04 BC 90 46 F0 BD 00 98 01 99 ?? ?? ?? ?? 80 46 00 28 F2 D1 20 1C 29 1C 1E 4A 1E 4B ?? ?? ?? ?? 00 28 EA D1 01 23 04 93 1C 4B 04 AF 7B 60 00 9A 01 9B 3C 61 7D 61 34 68 BA 60 FB 60 43 46 3B 62 00 2C 15 D0 13 48 13 49 02 1C 0B 1C ?? ?? ?? ?? B8 61 F9 61 02 2C 0F D1 ?? ?? ?? ?? 21 23 03 60 3B 6A 00 2B 0E D1 BB 69 FC 69 02 93 03 94 C4 E7 00 9A 01 9B BA 61 FB 61 38 1C ?? ?? ?? ?? 00 28 EE D1 E9 E7 ?? ?? ?? ?? 3B 6A 03 60 EB E7 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_0_1 {
	meta:
		name = "exp2f"
		size = 16
		refs = "0006 powf"
	strings:
		$1 = { 00 B5 01 1C 01 48 ?? ?? ?? ?? 00 BD 00 00 00 40 }
	condition:
		$1
}

rule file_50_0_1 {
	meta:
		name = "coshf"
		size = 184
		refs = "0006 __ieee754_coshf 0016 isnanf 0028 fabsf 002e __gtsf2 0042 __extendsfdf2 0060 matherr 0072 __truncdfsf2 0086 __errno 009c __fdlib_version"
	strings:
		$1 = { F0 B5 89 B0 04 1C ?? ?? ?? ?? 24 4E 33 68 05 1C 01 33 05 D0 20 1C ?? ?? ?? ?? 07 1C 00 28 02 D0 09 B0 28 1C F0 BD 20 1C ?? ?? ?? ?? 1C 49 ?? ?? ?? ?? 00 28 F4 DD 03 23 00 93 1A 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 33 68 6D 46 28 61 69 61 A8 60 E9 60 00 2B 11 D1 14 4B 14 4C AB 61 EC 61 68 46 ?? ?? ?? ?? 00 28 0E D0 2B 6A 00 2B 10 D1 A8 69 E9 69 ?? ?? ?? ?? 05 1C D2 E7 0D 49 0D 4A A9 61 EA 61 02 2B EB D1 ?? ?? ?? ?? 22 23 03 60 EB E7 ?? ?? ?? ?? 2B 6A 03 60 E9 E7 C0 46 ?? ?? ?? ?? FC D4 B2 42 ?? ?? ?? ?? FF FF EF 47 00 00 00 E0 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_51_0_1 {
	meta:
		name = "gamma_r"
		size = 260
		refs = "000c __ieee754_gamma_r 001c finite 0062 floor 006a __eqdf2 007a __ledf2 008e matherr 00b0 __errno 00e4 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8B B0 04 1C 0D 1C ?? ?? ?? ?? 34 4E 33 68 00 90 01 91 01 33 04 D0 ?? ?? ?? ?? 80 46 00 28 05 D0 00 98 01 99 0B B0 04 BC 90 46 F0 BD 20 1C 29 1C ?? ?? ?? ?? 00 28 F3 D0 2A 4B 02 AF 7B 60 43 46 3B 62 33 68 3C 61 7D 61 BC 60 FD 60 00 2B 27 D1 25 4A 25 4B BA 61 FB 61 20 1C 29 1C ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 00 28 07 D1 20 1C 29 1C 1F 4A 1F 4B ?? ?? ?? ?? 00 28 1B DD 03 23 02 93 33 68 02 2B 11 D0 38 1C ?? ?? ?? ?? 00 28 0C D0 3B 6A 00 2B 1D D1 BB 69 FC 69 00 93 01 94 BF E7 15 4A 15 4B BA 61 FB 61 D6 E7 ?? ?? ?? ?? 22 23 03 60 ED E7 02 23 02 93 33 68 02 2B 04 D0 38 1C ?? ?? ?? ?? 00 28 E3 D1 ?? ?? ?? ?? 21 23 03 60 DE E7 ?? ?? ?? ?? 3B 6A 03 60 DC E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? FF FF EF 47 00 00 00 E0 00 00 00 00 00 00 00 00 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_175_0_1 {
	meta:
		name = "lgamma_r"
		size = 260
		refs = "000c __ieee754_lgamma_r 001c finite 0062 floor 006a __eqdf2 007a __ledf2 008e matherr 00b0 __errno 00e4 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8B B0 04 1C 0D 1C ?? ?? ?? ?? 34 4E 33 68 00 90 01 91 01 33 04 D0 ?? ?? ?? ?? 80 46 00 28 05 D0 00 98 01 99 0B B0 04 BC 90 46 F0 BD 20 1C 29 1C ?? ?? ?? ?? 00 28 F3 D0 2A 4B 02 AF 7B 60 43 46 3B 62 33 68 3C 61 7D 61 BC 60 FD 60 00 2B 27 D1 25 4A 25 4B BA 61 FB 61 20 1C 29 1C ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 00 28 07 D1 20 1C 29 1C 1F 4A 1F 4B ?? ?? ?? ?? 00 28 1B DD 03 23 02 93 33 68 02 2B 11 D0 38 1C ?? ?? ?? ?? 00 28 0C D0 3B 6A 00 2B 1D D1 BB 69 FC 69 00 93 01 94 BF E7 15 4A 15 4B BA 61 FB 61 D6 E7 ?? ?? ?? ?? 22 23 03 60 ED E7 02 23 02 93 33 68 02 2B 04 D0 38 1C ?? ?? ?? ?? 00 28 E3 D1 ?? ?? ?? ?? 21 23 03 60 DE E7 ?? ?? ?? ?? 3B 6A 03 60 DC E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? FF FF EF 47 00 00 00 E0 00 00 00 00 00 00 00 00 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_52_0_1 {
	meta:
		name = "significandf"
		size = 24
		refs = "0004 ilogbf 000a __floatsisf 0012 __ieee754_scalbf"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 40 42 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 10 BD }
	condition:
		$1
}

rule file_53_0_1 {
	meta:
		name = "lround"
		size = 156
		refs = "006c __fixdfsi"
	strings:
		$1 = { F0 B5 02 1C 04 1C 0D 1C 0F 1C 00 2A 29 DB 01 20 51 00 1E 4E 49 0D 8B 19 1D 4E 16 40 80 22 52 03 32 43 13 2B 0A DC 00 2B 2B DB 80 26 36 03 1E 41 14 27 B2 18 FB 1A DA 40 50 43 F0 BD 1E 2B 13 D8 33 2B 16 DC 13 4E 80 24 89 19 24 06 CC 40 E4 19 A7 42 00 D9 01 32 8A 40 34 21 CB 1A DC 40 22 43 EA E7 01 20 40 42 D3 E7 20 1C 29 1C ?? ?? ?? ?? E3 E7 08 4B 08 4C CE 18 09 19 B2 40 8F 40 3A 43 DA E7 01 33 D9 D0 00 20 D7 E7 C0 46 01 FC FF FF FF FF 0F 00 ED FB FF FF CD FB FF FF }
	condition:
		$1
}

rule file_54_0_1 {
	meta:
		name = "__ieee754_log10f"
		size = 188
		refs = "0028 __floatsisf 0038 __ieee754_logf 0042 __mulsf3 005e __addsf3 0070 __divsf3 0086 __subsf3"
	strings:
		$1 = { 70 B5 01 1C 43 00 31 D0 00 28 3B DB 23 4B 98 42 3F DC 23 4B 98 42 2E DD 7F 23 5B 42 C2 15 D3 18 1F 4E DD 0F 06 40 E8 18 ?? ?? ?? ?? 7F 23 5D 1B ED 05 2E 43 04 1C 30 1C ?? ?? ?? ?? 19 49 06 1C 20 1C ?? ?? ?? ?? 18 49 05 1C 20 1C ?? ?? ?? ?? 16 49 04 1C 30 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 03 E0 10 48 11 49 ?? ?? ?? ?? 70 BD 08 1C 0F 49 ?? ?? ?? ?? 98 23 5B 42 CB E7 08 1C ?? ?? ?? ?? 0A 49 ?? ?? ?? ?? F0 E7 08 1C ?? ?? ?? ?? EC E7 C0 46 FF FF 7F 7F FF FF 7F 00 80 20 9A 3E DB 27 54 35 D9 5B DE 3E 00 00 00 CC 00 00 00 00 00 00 00 4C }
	condition:
		$1
}

rule file_56_0_1 {
	meta:
		name = "fminf"
		size = 44
		refs = "0006 __fpclassifyf 0020 __ltsf2"
	strings:
		$1 = { 30 B5 05 1C 0C 1C ?? ?? ?? ?? 00 28 01 D1 20 1C 30 BD 20 1C ?? ?? ?? ?? 00 28 05 D0 28 1C 21 1C ?? ?? ?? ?? 00 28 F2 DA 2C 1C F0 E7 }
	condition:
		$1
}

rule file_57_0_1 {
	meta:
		name = "logbf"
		size = 72
		refs = "001a __floatsisf 0020 __mulsf3 0026 fabsf 002e __divsf3"
	strings:
		$1 = { 00 B5 0D 4B 01 1C 03 40 0D D0 0C 4A 93 42 07 DC DB 15 00 2B 0E D0 18 1C 7F 38 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? FB E7 ?? ?? ?? ?? 01 1C 04 48 ?? ?? ?? ?? F4 E7 03 48 F2 E7 FF FF FF 7F FF FF 7F 7F 00 00 80 BF 00 00 FC C2 }
	condition:
		$1
}

rule file_58_0_1 {
	meta:
		name = "__ieee754_log10"
		size = 316
		refs = "0026 __adddf3 0046 __muldf3 0070 __floatsidf 0086 __ieee754_log 00e0 __divdf3 00ee __subdf3"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 3C 4B 82 46 84 B0 04 1C 0D 1C 9A 45 0E DD 3A 4B 00 20 9A 45 1D DD 20 1C 29 1C 22 1C 2B 1C ?? ?? ?? ?? 04 B0 0C BC 90 46 9A 46 F0 BD 43 00 4D D0 52 46 00 2A 53 DB 20 1C 29 1C 30 4A 30 4B ?? ?? ?? ?? 2D 4B 04 1C 82 46 36 20 0D 1C 40 42 9A 45 E1 DC 2C 4B 52 46 C0 18 13 15 C0 18 C3 0F 98 46 24 4B 40 44 1A 40 92 46 ?? ?? ?? ?? 26 4B 42 46 9B 1A 06 1C 1B 05 50 46 0F 1C 18 43 29 1C ?? ?? ?? ?? 22 4A 22 4B 00 90 01 91 30 1C 39 1C ?? ?? ?? ?? 20 4A 20 4B 02 90 03 91 30 1C 39 1C ?? ?? ?? ?? 1E 4A 1E 4B 04 1C 0D 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? AA E7 00 2D AF D1 14 4A 15 4B 15 48 16 49 ?? ?? ?? ?? A1 E7 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 0E 4A 0E 4B ?? ?? ?? ?? 96 E7 FF FF 0F 00 FF FF EF 7F 00 00 50 43 00 00 00 00 01 FC FF FF FF 03 00 00 13 44 D3 3F 00 60 9F 50 F3 FE 59 3D 36 2B F1 11 7B CB DB 3F 0E E5 26 15 00 00 00 00 00 00 00 00 00 00 50 C3 00 00 00 00 }
	condition:
		$1
}

rule file_59_0_1 {
	meta:
		name = "erfc"
		size = 1864
		refs = "004a __muldf3 005e __subdf3 008e __adddf3 00f2 __divdf3 0124 __floatunsidf 015a fabs 028a __ieee754_exp"
	strings:
		$1 = { F0 B5 47 46 80 B4 C8 4C C8 4B 04 40 88 B0 05 1C 0E 1C 07 1C 80 46 9C 42 00 DD 81 E0 C4 4B 9C 42 0D DD C4 4B 9C 42 00 DC 00 E2 C3 4B 9C 42 00 DC 93 E0 00 28 00 DC 75 E2 C0 48 C1 49 82 E0 C1 4B 9C 42 00 DC 82 E0 2A 1C 33 1C ?? ?? ?? ?? BE 4A BE 4B 00 90 01 91 ?? ?? ?? ?? BD 4A BD 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? BB 4A BB 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? B9 4A B9 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? B7 4A B7 4B ?? ?? ?? ?? B7 4A B7 4B 02 90 03 91 00 98 01 99 ?? ?? ?? ?? B5 4A B5 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? B3 4A B3 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? B1 4A B1 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? AF 4A AF 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? AD 4A AD 4B ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 0B 1C A9 49 02 1C 8D 42 00 DD FA E0 28 1C 31 1C ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 02 1C 0B 1C A0 48 A0 49 ?? ?? ?? ?? 11 E0 C7 0F 78 00 ?? ?? ?? ?? 2A 1C 00 90 01 91 33 1C 99 48 9A 49 ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 08 B0 04 BC 90 46 F0 BD 2A 1C 33 1C 91 48 92 49 ?? ?? ?? ?? F4 E7 ?? ?? ?? ?? 02 1C 0B 1C 00 90 01 91 ?? ?? ?? ?? 0B 1C 02 1C 8A 48 8A 49 ?? ?? ?? ?? 8B 4B 05 1C 0E 1C 9C 42 00 DC D3 E1 89 4B 9C 42 02 DD 00 2F 00 DA CA E1 87 4A 87 4B 28 1C 31 1C ?? ?? ?? ?? 86 4A 86 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 84 4A 84 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 82 4A 82 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 80 4A 80 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 7E 4A 7E 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 7C 4A 7C 4B ?? ?? ?? ?? 7C 4A 7C 4B 04 90 05 91 28 1C 31 1C ?? ?? ?? ?? 7A 4A 7A 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 78 4A 78 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 76 4A 76 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 74 4A 74 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 72 4A 72 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 70 4A 70 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 4D 4A 4D 4B ?? ?? ?? ?? 00 9C 01 9D 80 23 1B 06 02 90 03 91 22 1C E0 18 00 21 00 23 ?? ?? ?? ?? 66 4A 66 4B ?? ?? ?? ?? ?? ?? ?? ?? 00 9A 01 9B 06 90 07 91 20 1C 00 21 ?? ?? ?? ?? 22 1C 06 1C 0F 1C 00 23 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 02 9A 03 9B 04 1C 0D 1C 04 98 05 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? ?? ?? ?? ?? 0B 1C 02 1C 06 98 07 99 ?? ?? ?? ?? 43 46 00 2B 00 DC 9D E1 00 9A 01 9B ?? ?? ?? ?? 25 E7 28 1C 31 1C ?? ?? ?? ?? 48 4A 49 4B 00 90 01 91 28 1C 31 1C ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 02 1C 0B 1C 41 48 42 49 ?? ?? ?? ?? 0E E7 C0 46 FF FF FF 7F FF FF EF 7F FF FF EA 3F FF FF F3 3F FF FF 3B 40 00 00 00 00 00 00 00 00 FF FF 6F 3C D6 EA F8 BE AC 16 00 12 91 A2 77 3F E4 68 66 23 51 2A 9D 3F 4F 19 D7 DB 7D CD D4 3F 13 B9 1C 69 BA 6E C0 3F 68 DB 14 82 43 9C D0 BE 20 61 A2 42 C9 5D 21 3F 10 1A 1C 22 22 D0 74 3F 0F 6B D3 C4 4C A5 B0 3F BA CE 36 55 79 77 D9 3F 09 DC DA CD 00 00 F0 3F 00 00 00 00 FF FF CF 3F 6C DB 06 40 FF FF 17 40 4E 38 7E C0 3F 38 DC 9B 61 04 90 40 92 59 2E 6A 88 EC 83 40 28 F2 75 13 5D 14 64 40 98 ED C5 43 09 C2 31 40 5A 99 5F 55 BA 93 E9 3F DE 85 C2 70 12 34 84 3F 4A 6F E8 39 E2 70 36 C0 62 2D 71 42 74 A8 7D 40 63 E7 9F E7 19 F2 A3 40 E6 3B DF CE B7 FF A8 40 6A 24 8C 68 EB 02 98 40 18 51 9D 18 AE 5C 74 40 0A 9F 1B 22 8B 56 3E 40 90 51 1D 26 00 00 E2 3F 00 00 00 00 00 00 E0 3F 00 00 00 00 ?? ?? ?? ?? 84 4B 83 4A ?? ?? ?? ?? 83 4A 84 4B 04 1C 0D 1C ?? ?? ?? ?? 82 4A 83 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 80 4A 81 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 7E 4A 7F 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 7C 4A 7D 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 7A 4A 7B 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 78 4A 79 4B ?? ?? ?? ?? 78 4A 79 4B 00 90 01 91 20 1C 29 1C ?? ?? ?? ?? 76 4A 77 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 74 4A 75 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 72 4A 73 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 70 4A 71 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 6E 4A 6F 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 51 4B 50 4A ?? ?? ?? ?? 02 1C 0B 1C 00 2F 00 DA 80 E0 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 65 48 65 49 ?? ?? ?? ?? 0F E6 64 48 65 49 0C E6 65 4A 65 4B ?? ?? ?? ?? 65 4A 65 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 63 4A 63 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 61 4A 61 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 5F 4A 5F 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 5D 4A 5D 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 5B 4A 5B 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 59 4A 59 4B ?? ?? ?? ?? 59 4A 59 4B 04 90 05 91 28 1C 31 1C ?? ?? ?? ?? 57 4A 57 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 55 4A 55 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 53 4A 53 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 51 4A 51 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 4F 4A 4F 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 4D 4A 4D 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 4B 4A 4B 4B 22 E6 00 98 01 99 ?? ?? ?? ?? 49 4A 4A 4B ?? ?? ?? ?? 08 4B 07 4A ?? ?? ?? ?? 8C E5 00 9A 01 9B ?? ?? ?? ?? 02 1C 0B 1C 20 48 20 49 ?? ?? ?? ?? 81 E5 00 00 F0 3F 00 00 00 00 38 BF 61 BF 3F 07 96 0A 36 2A A2 3F EB 95 97 59 98 63 BC 3F EC 28 3E 3D CA 5F D4 3F E4 20 51 80 40 D2 D7 3F F1 C3 B8 FB 00 8D DA 3F 4D B3 92 AD B8 59 63 3F 38 75 F7 BE 54 8B 88 3F 1D 15 35 57 C2 ED 8B 3F 1C DD 51 6B 60 26 C0 3F 1F 35 63 E7 5C 63 B2 3F A7 E9 9F D9 F0 4A E1 3F 33 6F EB 92 66 3E BB 3F 23 E3 EE 18 FA D4 C3 3F 00 00 00 80 00 00 00 40 00 00 00 00 EF A0 23 C0 5C C2 9A C6 65 52 54 40 F2 D2 E4 57 5C 13 67 40 B2 AB CC EB B1 4C 64 40 66 22 28 84 0A 30 4F 40 8D A3 CB E4 04 1E 25 40 26 E7 B0 41 16 34 E6 3F 60 73 BA E4 12 34 84 3F 35 64 0D 60 F2 EF AE BF 62 9A 74 EE EF 47 1A 40 93 4A 48 8E A3 28 5B 40 2C AE 48 EE 21 D0 7A 40 14 03 70 57 19 2B 84 40 68 28 EC 21 0D 29 7B 40 71 1A 8A D5 0C 35 61 40 21 E7 6A 52 B9 A6 33 40 87 76 70 BD C1 0A EB 3F 00 00 00 60 }
	condition:
		$1
}

rule file_59_1_1 {
	meta:
		name = "erf"
		size = 1852
		refs = "004e __muldf3 006a __adddf3 0080 __floatsidf 0090 __divdf3 00c0 __subdf3 016e fabs 028e __ieee754_exp"
	strings:
		$1 = { F0 B5 47 46 80 B4 C5 4C C5 4B 04 40 88 B0 05 1C 0E 1C 07 1C 80 46 9C 42 2E DC C2 4B 9C 42 0D DD C1 4B 9C 42 00 DC 01 E2 C0 4B 9C 42 00 DC 9E E0 00 28 00 DA E7 E2 BE 48 BE 49 31 E0 BE 4B 9C 42 32 DC BE 4B 9C 42 00 DD 5E E1 BD 4A BD 4B ?? ?? ?? ?? BD 4A BD 4B 00 90 01 91 28 1C 31 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? B8 4A B8 4B ?? ?? ?? ?? 13 E0 C7 0F 7F 00 01 20 C0 1B ?? ?? ?? ?? 2A 1C 00 90 01 91 33 1C A8 48 A9 49 ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 08 B0 04 BC 90 46 F0 BD 2A 1C 33 1C ?? ?? ?? ?? A9 4A AA 4B 00 90 01 91 ?? ?? ?? ?? A8 4A A9 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? A6 4A A7 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? A4 4A A5 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? A2 4A A3 4B ?? ?? ?? ?? A2 4A A3 4B 02 90 03 91 00 98 01 99 ?? ?? ?? ?? A0 4A A1 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 9E 4A 9F 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 9C 4A 9D 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 9A 4A 9B 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 7A 4A 7B 4B ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 02 1C 0B 1C 28 1C 31 1C ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 98 E7 ?? ?? ?? ?? 02 1C 0B 1C 00 90 01 91 ?? ?? ?? ?? 0B 1C 02 1C 6B 48 6B 49 ?? ?? ?? ?? 87 4B 05 1C 0E 1C 9C 42 00 DC C4 E1 85 4A 85 4B ?? ?? ?? ?? 85 4A 85 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 83 4A 83 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 81 4A 81 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 7F 4A 7F 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 7D 4A 7D 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 7B 4A 7B 4B ?? ?? ?? ?? 7B 4A 7B 4B 04 90 05 91 28 1C 31 1C ?? ?? ?? ?? 79 4A 79 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 77 4A 77 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 75 4A 75 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 73 4A 73 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 71 4A 71 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 6F 4A 6F 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 32 4A 32 4B ?? ?? ?? ?? 00 9C 01 9D 80 23 1B 06 02 90 03 91 22 1C E0 18 00 21 00 23 ?? ?? ?? ?? 65 4A 65 4B ?? ?? ?? ?? ?? ?? ?? ?? 00 9A 01 9B 06 90 07 91 20 1C 00 21 ?? ?? ?? ?? 22 1C 06 1C 0F 1C 00 23 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 02 9A 03 9B 04 1C 0D 1C 04 98 05 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? ?? ?? ?? ?? 0B 1C 02 1C 06 98 07 99 ?? ?? ?? ?? 43 46 00 2B 00 DA 97 E1 00 9A 01 9B ?? ?? ?? ?? 02 1C 0B 1C 0C 48 0C 49 ?? ?? ?? ?? CB E6 46 4A 47 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? C2 E6 C0 46 FF FF FF 7F FF FF EF 7F FF FF EA 3F FF FF F3 3F FF FF 17 40 00 00 F0 3F 00 00 00 00 FF FF 2F 3E FF FF 7F 00 00 00 20 40 00 00 00 00 BA 6E F0 3F 69 DB 14 82 00 00 C0 3F 00 00 00 00 D6 EA F8 BE AC 16 00 12 91 A2 77 3F E4 68 66 23 51 2A 9D 3F 4F 19 D7 DB 7D CD D4 3F 13 B9 1C 69 BA 6E C0 3F 68 DB 14 82 43 9C D0 BE 20 61 A2 42 C9 5D 21 3F 10 1A 1C 22 22 D0 74 3F 0F 6B D3 C4 4C A5 B0 3F BA CE 36 55 79 77 D9 3F 09 DC DA CD 6D DB 06 40 4E 38 7E C0 3F 38 DC 9B 61 04 90 40 92 59 2E 6A 88 EC 83 40 28 F2 75 13 5D 14 64 40 98 ED C5 43 09 C2 31 40 5A 99 5F 55 BA 93 E9 3F DE 85 C2 70 12 34 84 3F 4A 6F E8 39 E2 70 36 C0 62 2D 71 42 74 A8 7D 40 63 E7 9F E7 19 F2 A3 40 E6 3B DF CE B7 FF A8 40 6A 24 8C 68 EB 02 98 40 18 51 9D 18 AE 5C 74 40 0A 9F 1B 22 8B 56 3E 40 90 51 1D 26 00 00 E2 3F 00 00 00 00 BA 6E C0 3F 69 DB 14 82 ?? ?? ?? ?? 81 4B 80 4A ?? ?? ?? ?? 80 4A 81 4B 04 1C 0D 1C ?? ?? ?? ?? 7F 4A 80 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 7D 4A 7E 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 7B 4A 7C 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 79 4A 7A 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 77 4A 78 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 75 4A 76 4B ?? ?? ?? ?? 75 4A 76 4B 00 90 01 91 20 1C 29 1C ?? ?? ?? ?? 73 4A 74 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 71 4A 72 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 6F 4A 70 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 6D 4A 6E 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 6B 4A 6C 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 4E 4B 4D 4A ?? ?? ?? ?? 02 1C 0B 1C 00 2F 00 DA 7E E0 00 98 01 99 ?? ?? ?? ?? 63 4A 63 4B ?? ?? ?? ?? BF E5 62 4A 63 4B ?? ?? ?? ?? 62 4A 63 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 60 4A 61 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 5E 4A 5F 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 5C 4A 5D 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 5A 4A 5B 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 58 4A 59 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 56 4A 57 4B ?? ?? ?? ?? 56 4A 57 4B 04 90 05 91 28 1C 31 1C ?? ?? ?? ?? 54 4A 55 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 52 4A 53 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 50 4A 51 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 4E 4A 4F 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 4C 4A 4D 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 4A 4A 4B 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 48 4A 49 4B 29 E6 49 48 49 49 49 E5 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 46 48 47 49 ?? ?? ?? ?? 3E E5 00 9A 01 9B ?? ?? ?? ?? 03 4B 01 4A ?? ?? ?? ?? 35 E5 00 00 F0 3F 00 00 00 00 38 BF 61 BF 3F 07 96 0A 36 2A A2 3F EB 95 97 59 98 63 BC 3F EC 28 3E 3D CA 5F D4 3F E4 20 51 80 40 D2 D7 3F F1 C3 B8 FB 00 8D DA 3F 4D B3 92 AD B8 59 63 3F 38 75 F7 BE 54 8B 88 3F 1D 15 35 57 C2 ED 8B 3F 1C DD 51 6B 60 26 C0 3F 1F 35 63 E7 5C 63 B2 3F A7 E9 9F D9 F0 4A E1 3F 33 6F EB 92 66 3E BB 3F 23 E3 EE 18 C1 0A EB 3F 00 00 00 60 EF A0 23 C0 5C C2 9A C6 65 52 54 40 F2 D2 E4 57 5C 13 67 40 B2 AB CC EB B1 4C 64 40 66 22 28 84 0A 30 4F 40 8D A3 CB E4 04 1E 25 40 26 E7 B0 41 16 34 E6 3F 60 73 BA E4 12 34 84 3F 35 64 0D 60 F2 EF AE BF 62 9A 74 EE EF 47 1A 40 93 4A 48 8E A3 28 5B 40 2C AE 48 EE 21 D0 7A 40 14 03 70 57 19 2B 84 40 68 28 EC 21 0D 29 7B 40 71 1A 8A D5 0C 35 61 40 21 E7 6A 52 B9 A6 33 40 87 76 70 BD 00 00 F0 BF 00 00 00 00 C1 0A EB BF 00 00 00 60 }
	condition:
		$1
}

rule file_60_0_1 {
	meta:
		name = "asinh"
		size = 336
		refs = "0020 __adddf3 0028 __gtdf2 0038 __muldf3 0044 fabs 0058 __ieee754_sqrt 006c __divdf3 007c log1p 00f6 __ieee754_log"
	strings:
		$1 = { F0 B5 49 4B 49 4A 03 40 84 B0 05 1C 0C 1C 06 1C 93 42 00 DD 78 E0 46 4A 93 42 39 DC 45 4A 46 4B ?? ?? ?? ?? 45 4A 46 4B ?? ?? ?? ?? 00 28 2B DC 2A 1C 23 1C 28 1C 21 1C ?? ?? ?? ?? 00 90 01 91 28 1C 21 1C ?? ?? ?? ?? 3C 4A 3D 4B 04 1C 0D 1C 00 98 01 99 ?? ?? ?? ?? ?? ?? ?? ?? 37 4A 38 4B ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? ?? ?? ?? ?? 00 2E 3C DD 05 1C 0C 1C 04 B0 28 1C 21 1C F0 BD 2C 4A 93 42 3F DC 80 22 D2 05 93 42 C8 DD ?? ?? ?? ?? 2A 1C 00 90 01 91 23 1C 28 1C 21 1C ?? ?? ?? ?? 22 4A 22 4B ?? ?? ?? ?? ?? ?? ?? ?? 04 1C 0D 1C 00 98 01 99 02 1C 0B 1C ?? ?? ?? ?? 22 1C 02 90 03 91 2B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 16 48 16 49 ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? ?? ?? ?? ?? 00 2E C2 DC 80 23 1B 06 C5 18 0C 1C BF E7 2A 1C 23 1C ?? ?? ?? ?? 05 1C 0C 1C B8 E7 ?? ?? ?? ?? ?? ?? ?? ?? 0A 4A 0A 4B ?? ?? ?? ?? AB E7 FF FF FF 7F FF FF EF 7F FF FF 2F 3E 3C E4 37 7E 9C 75 00 88 00 00 F0 3F 00 00 00 00 00 00 B0 41 42 2E E6 3F EF 39 FA FE }
	condition:
		$1
}

rule file_61_0_1 {
	meta:
		name = "sincosf"
		size = 24
		refs = "0008 sinf 0010 cosf"
	strings:
		$1 = { 70 B5 0E 1C 15 1C 04 1C ?? ?? ?? ?? 30 60 20 1C ?? ?? ?? ?? 28 60 70 BD }
	condition:
		$1
}

rule file_62_0_1 {
	meta:
		name = "atanf"
		size = 564
		refs = "0042 __mulsf3 0058 __addsf3 009e __subsf3 0112 __gtsf2 011c fabsf 0148 __divsf3"
	strings:
		$1 = { F0 B5 47 46 80 B4 71 4D 71 4B 05 40 04 1C 06 1C 9D 42 0C DD FF 23 DB 05 9D 42 00 DD 70 E0 00 28 00 DC A6 E0 6B 4C 20 1C 04 BC 90 46 F0 BD 6A 4B 9D 42 73 DC 69 4B 9D 42 67 DD 01 27 7F 42 21 1C 20 1C ?? ?? ?? ?? 80 46 41 46 ?? ?? ?? ?? 64 49 05 1C ?? ?? ?? ?? 63 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 61 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 5F 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 5D 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 5B 49 ?? ?? ?? ?? 41 46 ?? ?? ?? ?? 59 49 80 46 28 1C ?? ?? ?? ?? 57 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 55 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 53 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 51 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 01 1C 7B 1C 43 D0 4E 4D 40 46 ?? ?? ?? ?? BF 00 21 1C ?? ?? ?? ?? EB 19 19 69 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 01 1C 78 59 ?? ?? ?? ?? 00 2E 2A DB 04 1C 92 E7 21 1C ?? ?? ?? ?? 04 1C 8D E7 41 49 ?? ?? ?? ?? 40 49 ?? ?? ?? ?? 00 28 8F DD 84 E7 ?? ?? ?? ?? 3D 4B 04 1C 9D 42 26 DC 3C 4B 9D 42 3F DC 21 1C ?? ?? ?? ?? 37 49 ?? ?? ?? ?? 39 49 05 1C 20 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 00 27 04 1C 75 E7 80 23 1B 06 C4 18 65 E7 40 46 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 04 1C 59 E7 2C 4C 57 E7 2C 4B 9D 42 11 DC 2B 49 ?? ?? ?? ?? 2A 49 05 1C 20 1C ?? ?? ?? ?? 21 49 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 02 27 04 1C 4E E7 21 1C 23 48 ?? ?? ?? ?? 03 27 04 1C 47 E7 19 49 ?? ?? ?? ?? 17 49 05 1C 20 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 01 27 04 1C 38 E7 FF FF FF 7F FF FF 7F 50 DB 0F C9 3F FF FF DF 3E FF FF FF 30 D7 69 85 3C 59 DA 4B 3D 35 6B 88 3D 6E 2E BA 3D 25 49 12 3E AB AA AA 3E 21 A2 15 BD 6B F1 6E 3D 95 87 9D 3D 38 8E E3 3D CD CC 4C 3E ?? ?? ?? ?? CA F2 49 71 00 00 80 3F FF FF 97 3F FF FF 2F 3F 00 00 00 40 DB 0F C9 BF FF FF 1B 40 00 00 C0 3F 00 00 80 BF }
	condition:
		$1
}

rule file_64_0_1 {
	meta:
		name = "cosh"
		size = 200
		refs = "000c __ieee754_cosh 0020 __isnand 003a fabs 0042 __gtdf2 0070 matherr 0094 __errno 00a8 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8B B0 04 1C 0D 1C ?? ?? ?? ?? 25 4E 33 68 00 90 01 91 01 33 06 D0 20 1C 29 1C ?? ?? ?? ?? 80 46 00 28 05 D0 00 98 01 99 0B B0 04 BC 90 46 F0 BD 20 1C 29 1C ?? ?? ?? ?? 1B 4A 1B 4B ?? ?? ?? ?? 00 28 EF DD 03 23 02 93 19 4B 02 AF 7B 60 43 46 3B 62 33 68 3C 61 7D 61 BC 60 FD 60 00 2B 10 D1 14 4B 14 4C BB 61 FC 61 38 1C ?? ?? ?? ?? 00 28 0D D0 3B 6A 00 2B 0F D1 BB 69 FC 69 00 93 01 94 D0 E7 0D 49 0E 4A B9 61 FA 61 02 2B EC D1 ?? ?? ?? ?? 22 23 03 60 EC E7 ?? ?? ?? ?? 3B 6A 03 60 EA E7 ?? ?? ?? ?? CE 33 86 40 7D F8 B9 8F ?? ?? ?? ?? FF FF EF 47 00 00 00 E0 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_65_0_1 {
	meta:
		name = "__ieee754_atanhf"
		size = 216
		refs = "001e __addsf3 0024 __gtsf2 003a __mulsf3 0044 __subsf3 004c __divsf3 0056 log1pf"
	strings:
		$1 = { F0 B5 2E 4E FE 23 06 40 9B 05 05 1C 04 1C 9E 42 2D DC 9E 42 4D D0 2A 4B 9E 42 30 DC 29 49 ?? ?? ?? ?? 29 49 ?? ?? ?? ?? 00 28 1E DC 35 1C 29 1C 28 1C ?? ?? ?? ?? 29 1C 06 1C ?? ?? ?? ?? 29 1C 07 1C 22 48 ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 31 1C ?? ?? ?? ?? ?? ?? ?? ?? 1D 49 ?? ?? ?? ?? 00 2C 24 DA 80 23 1B 06 C5 18 28 1C F0 BD 29 1C ?? ?? ?? ?? 01 1C ?? ?? ?? ?? 05 1C F5 E7 15 4B 35 1C 9E 42 D3 DD 31 1C 30 1C ?? ?? ?? ?? 29 1C 06 1C 0E 48 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? ?? ?? ?? ?? 0A 49 ?? ?? ?? ?? 00 2C DA DB 05 1C DB E7 05 49 ?? ?? ?? ?? 05 1C D6 E7 FF FF FF 7F FF FF 7F 31 CA F2 49 71 00 00 00 00 00 00 80 3F 00 00 00 3F FF FF FF 3E }
	condition:
		$1
}

rule file_67_0_1 {
	meta:
		name = "acoshf"
		size = 164
		refs = "0006 __ieee754_acoshf 0016 isnanf 0024 __ltsf2 0038 __extendsfdf2 004e __divdf3 005e matherr 0070 __truncdfsf2 007c __errno 0090 __fdlib_version"
	strings:
		$1 = { F0 B5 89 B0 04 1C ?? ?? ?? ?? 21 4E 33 68 05 1C 01 33 30 D0 20 1C ?? ?? ?? ?? 07 1C 00 28 2A D1 20 1C 1C 49 ?? ?? ?? ?? 00 28 24 DA 01 23 00 93 19 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 6D 46 28 61 69 61 A8 60 E9 60 15 48 15 49 0B 1C 02 1C ?? ?? ?? ?? 33 68 A8 61 E9 61 02 2B 0F D0 68 46 ?? ?? ?? ?? 00 28 0A D0 2B 6A 00 2B 0C D1 A8 69 E9 69 ?? ?? ?? ?? 05 1C 09 B0 28 1C F0 BD ?? ?? ?? ?? 21 23 03 60 EF E7 ?? ?? ?? ?? 2B 6A 03 60 ED E7 ?? ?? ?? ?? 00 00 80 3F ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_68_0_1 {
	meta:
		name = "gammaf"
		size = 288
		refs = "000c __ieee754_gammaf_r 001a finitef 0036 floorf 003c __eqsf2 0048 __lesf2 005c __extendsfdf2 007a matherr 008c __truncdfsf2 00d6 __errno 0100 _impure_ptr 0104 __fdlib_version"
	strings:
		$1 = { F0 B5 3F 4B 19 68 89 B0 A0 31 05 1C ?? ?? ?? ?? 3C 4E 33 68 04 1C 01 33 04 D0 ?? ?? ?? ?? 07 1C 00 28 02 D0 09 B0 20 1C F0 BD 28 1C ?? ?? ?? ?? 00 28 F7 D0 28 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 00 28 27 D1 28 1C 30 49 ?? ?? ?? ?? 00 28 21 DC 02 23 00 93 2D 4B 28 1C 01 93 08 97 ?? ?? ?? ?? 33 68 6C 46 20 61 61 61 A0 60 E1 60 00 2B 3C D1 27 4A 28 4B A2 61 E3 61 68 46 ?? ?? ?? ?? 00 28 39 D0 23 6A 00 2B 2B D1 A0 69 E1 69 ?? ?? ?? ?? 04 1C C7 E7 03 23 00 93 1C 4B 28 1C 01 93 00 23 08 93 ?? ?? ?? ?? 33 68 6C 46 20 61 61 61 A0 60 E1 60 00 2B 09 D1 16 4A 16 4B A2 61 E3 61 68 46 ?? ?? ?? ?? 00 28 DC D1 05 E0 13 49 13 4A A1 61 E2 61 02 2B F3 D1 ?? ?? ?? ?? 22 23 03 60 D0 E7 ?? ?? ?? ?? 23 6A 03 60 CE E7 0B 49 0B 4A A1 61 E2 61 02 2B C0 D1 ?? ?? ?? ?? 21 23 03 60 C0 E7 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? FF FF EF 47 00 00 00 E0 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_71_0_1 {
	meta:
		name = "scalbln"
		size = 256
		refs = "001e __muldf3 003e copysign 005c __adddf3"
	strings:
		$1 = { 70 B5 14 1C 42 00 52 0D 05 1C 0E 1C 03 1C 00 2A 1E D1 42 00 37 D0 2E 4B 2C 4A 28 1C 31 1C ?? ?? ?? ?? 42 00 52 0D 05 1C 0E 1C 03 1C 36 3A 29 49 12 19 8A 42 17 DD 2A 1C 33 1C 27 48 27 49 ?? ?? ?? ?? 25 4A 25 4B ?? ?? ?? ?? 05 1C 0E 1C 17 E0 23 49 8A 42 EB D1 31 1C 2A 1C 33 1C ?? ?? ?? ?? 05 1C 0E 1C 0C E0 1F 49 8C 42 E4 DC 1E 49 8C 42 1E DB 00 2A 0A DD 1D 49 12 05 0B 40 15 1C 1D 43 28 1C 31 1C 70 BD 00 2E FA D0 C4 E7 11 1C 35 31 0E DB 16 49 36 32 12 05 0B 40 15 1C 1D 43 28 1C 31 1C 13 4A 13 4B ?? ?? ?? ?? 05 1C 0E 1C E7 E7 2A 1C 33 1C 10 48 11 49 ?? ?? ?? ?? 0E 4A 0F 4B ?? ?? ?? ?? 05 1C 0E 1C DA E7 C0 46 00 00 50 43 00 00 00 00 FE 07 00 00 3C E4 37 7E 9C 75 00 88 FF 07 00 00 50 C3 00 00 B0 3C FF FF FF FF 0F 80 00 00 90 3C 00 00 00 00 1F 6E A5 01 59 F3 F8 C2 }
	condition:
		$1
}

rule file_72_0_1 {
	meta:
		name = "lgammaf"
		size = 248
		refs = "000c __ieee754_lgammaf_r 001a finitef 003c __extendsfdf2 005a floorf 0060 __eqsf2 006c __lesf2 0080 matherr 0092 __truncdfsf2 00a4 __errno 00d8 _impure_ptr 00dc __fdlib_version"
	strings:
		$1 = { F0 B5 35 4B 19 68 89 B0 A0 31 05 1C ?? ?? ?? ?? 32 4E 33 68 04 1C 01 33 04 D0 ?? ?? ?? ?? 07 1C 00 28 02 D0 09 B0 20 1C F0 BD 28 1C ?? ?? ?? ?? 00 28 F7 D0 2A 4B 28 1C 01 93 08 97 ?? ?? ?? ?? 33 68 6C 46 20 61 61 61 A0 60 E1 60 00 2B 24 D1 24 4A 25 4B A2 61 E3 61 28 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 00 28 05 D1 28 1C 20 49 ?? ?? ?? ?? 00 28 1C DD 03 23 00 93 33 68 02 2B 12 D0 68 46 ?? ?? ?? ?? 00 28 0D D0 23 6A 00 2B 1E D1 A0 69 E1 69 ?? ?? ?? ?? 04 1C C4 E7 15 4A 15 4B A2 61 E3 61 D9 E7 ?? ?? ?? ?? 22 23 03 60 EC E7 02 23 00 93 33 68 02 2B 04 D0 68 46 ?? ?? ?? ?? 00 28 E2 D1 ?? ?? ?? ?? 21 23 03 60 DD E7 ?? ?? ?? ?? 23 6A 03 60 DB E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF EF 47 00 00 00 E0 00 00 00 00 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_73_0_1 {
	meta:
		name = "scalb"
		size = 312
		refs = "000c __ieee754_scalb 001c finite 002c __eqdf2 003c __nedf2 0058 __errno 0066 __isnand 0082 __gtdf2 00e6 copysign 00f6 matherr 0118 __fdlib_version"
	strings:
		$1 = { 70 B5 8D B0 02 92 03 93 00 90 01 91 ?? ?? ?? ?? 41 4E 33 68 04 1C 0D 1C 01 33 19 D0 ?? ?? ?? ?? 00 28 1E D0 20 1C 29 1C 3C 4A 3D 4B ?? ?? ?? ?? 00 28 07 D1 00 98 01 99 22 1C 2B 1C ?? ?? ?? ?? 00 28 3D D1 02 98 03 99 ?? ?? ?? ?? 00 28 03 D0 0D B0 29 1C 20 1C 70 BD ?? ?? ?? ?? 22 23 03 60 F6 E7 20 1C 29 1C ?? ?? ?? ?? 00 28 DA D1 00 98 01 99 ?? ?? ?? ?? 00 28 D4 D0 00 98 01 99 27 4A 27 4B ?? ?? ?? ?? 00 28 43 DC 26 4A 26 4B 03 21 04 91 26 49 04 AC 61 60 00 21 21 62 00 98 01 99 A2 61 E3 61 A0 60 E1 60 33 68 02 98 03 99 20 61 61 61 02 2B 1E D1 ?? ?? ?? ?? 22 23 03 60 1E E0 04 23 04 93 19 4B 04 AC 00 99 01 9A 63 60 00 23 A1 60 E2 60 23 62 02 9A 03 9B 10 48 10 49 22 61 63 61 00 9A 01 9B ?? ?? ?? ?? 33 68 A0 61 E1 61 02 2B E0 D0 20 1C ?? ?? ?? ?? 00 28 DB D0 23 6A 00 2B 03 D0 ?? ?? ?? ?? 23 6A 03 60 E5 69 A4 69 9E E7 07 4A 07 4B BA E7 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 F0 FF 00 00 00 00 ?? ?? ?? ?? 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_74_0_1 {
	meta:
		name = "sinh"
		size = 240
		refs = "0008 __ieee754_sinh 0018 finite 005c __gtdf2 006e matherr 0094 __errno 00c0 __fdlib_version"
	strings:
		$1 = { F0 B5 8B B0 00 90 01 91 ?? ?? ?? ?? 2C 4E 33 68 04 1C 0D 1C 01 33 04 D0 ?? ?? ?? ?? 07 1C 00 28 03 D0 0B B0 29 1C 20 1C F0 BD 00 98 01 99 ?? ?? ?? ?? 00 28 F5 D0 03 23 02 93 22 4B 02 AC 63 60 36 68 00 9A 01 9B 27 62 22 61 63 61 A2 60 E3 60 00 2E 11 D1 10 1C 19 1C 1B 4A 1C 4B ?? ?? ?? ?? 00 28 24 DC 1A 4A 1B 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 12 D1 0D E0 00 98 01 99 12 4A 13 4B ?? ?? ?? ?? 00 28 0F DC 13 4A 14 4B A2 61 E3 61 02 2E EB D1 ?? ?? ?? ?? 22 23 03 60 23 6A 00 2B 08 D1 E5 69 A4 69 BC E7 0D 4A 0E 4B EE E7 0E 4A 0E 4B D9 E7 ?? ?? ?? ?? 23 6A 03 60 F1 E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 FF FF EF C7 00 00 00 E0 00 00 F0 FF 00 00 00 00 00 00 F0 7F 00 00 00 00 FF FF EF 47 00 00 00 E0 }
	condition:
		$1
}

rule file_75_0_1 {
	meta:
		name = "__ieee754_hypot"
		size = 660
		refs = "00b0 __subdf3 00bc __gtdf2 00d6 __muldf3 00fc __adddf3 0134 __ieee754_sqrt"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 92 4C 05 1C 25 40 14 40 86 B0 A5 42 22 DB 00 92 01 93 0F 1C 00 9A 01 9B F0 21 28 1B 89 04 2E 1C A2 46 98 46 88 42 00 DD 92 E0 89 49 8D 42 18 DC 00 21 89 46 87 4B 9C 42 30 DC 87 4B 9C 42 25 DC 43 46 00 2C 00 D0 EA E0 00 2B 00 D0 E7 E0 30 1C 39 1C 76 E0 2E 1C 00 90 01 91 25 1C 19 1C 34 1C D7 E7 7E 49 8D 42 00 DC C8 E0 29 03 00 D0 CF E0 00 2F 00 D0 CC E0 28 1C 39 1C 79 4B 46 46 9C 42 5F D1 00 2E 5D D1 20 1C 41 46 5A E0 96 22 92 05 74 4B AD 18 A4 18 99 44 2E 1C A2 46 52 46 43 46 30 1C 39 1C ?? ?? ?? ?? 52 46 43 46 83 46 00 91 ?? ?? ?? ?? 00 28 51 DD 6B 4B 6C 4C 2B 1C 25 1C 1A 1C 1C 1C 18 1C 29 1C 2B 1C ?? ?? ?? ?? 80 22 12 06 00 90 01 91 10 1C 43 46 52 46 50 44 41 46 ?? ?? ?? ?? 22 1C 02 90 03 91 2B 1C 30 1C 39 1C ?? ?? ?? ?? 22 1C 04 90 05 91 2B 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? ?? ?? ?? ?? 4B 46 00 2B 07 D0 4D 46 2C 05 4E 4D 4E 4A 4F 4B 62 19 ?? ?? ?? ?? 06 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 28 1C 39 1C 22 1C ?? ?? ?? ?? F2 E7 42 4A 43 4B 22 1C 02 92 03 93 80 21 3F 4B 40 4C 49 03 6B 18 25 1C 18 1C 1C 1C 29 1C 02 9A 03 9B ?? ?? ?? ?? 80 22 12 06 04 90 05 91 10 1C 00 9B 00 99 5A 46 58 44 ?? ?? ?? ?? 02 9A 03 9B 00 90 01 91 50 46 41 46 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 32 1C 02 90 03 91 3B 1C 30 1C 39 1C ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 52 46 43 46 ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? ?? ?? ?? ?? 97 E7 1F 49 96 22 6D 18 64 18 98 46 93 00 2E 1C A2 46 99 46 11 E7 30 1C 39 1C 22 1C 43 46 ?? ?? ?? ?? 2D E7 12 4A 12 4B 17 4A 41 46 20 1C 00 92 01 93 ?? ?? ?? ?? 00 9A 01 9B 82 46 88 46 30 1C 39 1C ?? ?? ?? ?? 0F 1C 10 49 06 1C 89 44 28 E7 C0 46 FF FF FF 7F 00 00 30 5F FF FF AF 20 FF FF 0F 00 FF FF EF 7F 00 00 F0 7F A8 FD FF FF 00 00 00 00 00 00 00 00 00 00 F0 3F 00 00 F0 3F 00 00 00 00 00 00 80 DA 00 00 D0 7F 02 FC FF FF }
	condition:
		$1
}

rule file_76_0_1 {
	meta:
		name = "cbrt"
		size = 404
		refs = "0038 __divsi3 004c __muldf3 0054 __divdf3 0064 __adddf3 00d0 __subdf3 0144 __udivsi3"
	strings:
		$1 = { F0 B5 47 46 80 B4 0B 1C 80 21 09 06 02 1C 08 1C 10 40 80 46 10 1C 88 43 4D 49 84 B0 88 42 00 DD 80 E0 00 28 00 D1 7A E0 02 1C 00 92 01 93 49 4B 98 42 00 DC 7D E0 03 21 ?? ?? ?? ?? 46 4B 47 4C 47 4D C4 18 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 40 4A 41 4B ?? ?? ?? ?? 40 4A 41 4B 06 1C 0F 1C ?? ?? ?? ?? 32 1C 3B 1C 02 90 03 91 3D 48 3E 49 ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 02 1C 0B 1C 39 48 3A 49 ?? ?? ?? ?? 39 4A 3A 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 00 25 44 1C 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 22 1C 2B 1C 06 1C 0F 1C ?? ?? ?? ?? 22 1C 00 90 01 91 2B 1C 20 1C 29 1C ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 42 46 0B 1C 02 43 04 B0 10 1C 19 1C 04 BC 90 46 F0 BD 00 2B F7 D0 81 E7 10 1C 19 1C ?? ?? ?? ?? 02 1C 0B 1C EF E7 00 9A 01 9B 09 48 09 49 14 48 ?? ?? ?? ?? 0D 1C 03 21 ?? ?? ?? ?? 11 4B C4 18 7A E7 C0 46 FF FF EF 7F FF FF 0F 00 93 78 9F 2A 00 00 00 00 00 00 00 00 15 5F E1 3F F1 15 5F F1 EA A0 F6 3F 0F EA A0 0E DE 91 E6 BF 34 C8 32 25 DB B6 F9 3F 6E DB B6 6D 6D DB D6 3F B7 6D DB B6 00 00 50 43 93 78 7F 29 }
	condition:
		$1
}

rule file_78_0_1 {
	meta:
		name = "ceil"
		size = 332
		refs = "0038 __adddf3 0040 __gtdf2"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 02 1C 0B 1C 04 1C 0D 1C 80 46 8A 46 89 46 41 00 44 48 49 0D 0E 18 13 2E 24 DC 00 2E 58 DB 41 4C 34 41 14 42 51 D0 10 1C 19 1C 3F 4A 40 4B ?? ?? ?? ?? 3F 4A 40 4B ?? ?? ?? ?? 00 28 5D DD 43 46 00 2B 03 DD 80 23 5B 03 33 41 98 44 41 46 A1 43 00 27 0A 1C 3B 1C 10 1C 19 1C 1C BC 90 46 99 46 A2 46 F0 BD 33 2E 0A DD 80 21 C9 00 8E 42 F2 D1 10 1C 19 1C ?? ?? ?? ?? 02 1C 0B 1C EB E7 2E 48 0F 18 01 20 40 42 F8 40 07 1C 18 42 E3 D0 10 1C 19 1C 25 4A 26 4B ?? ?? ?? ?? 25 4A 26 4B ?? ?? ?? ?? 00 28 2E DD 00 2C 35 DD 14 2E 31 D0 34 23 9E 1B 01 23 B3 40 1E 1C 56 44 B2 45 01 D9 01 21 88 44 BE 43 41 46 37 1C 19 E0 00 2B C3 D0 AA E7 10 1C 19 1C 15 4A 15 4B ?? ?? ?? ?? 15 4A 15 4B ?? ?? ?? ?? 00 28 0D DD 00 2C 0E DB 00 2D 01 D1 00 2C 12 D0 00 27 11 49 01 E0 41 46 4F 46 0A 1C 3B 1C A8 E7 21 1C 2F 1C F9 E7 80 21 00 27 09 06 F5 E7 01 20 80 44 2E 1C D3 E7 00 27 00 21 EE E7 C0 46 01 FC FF FF FF FF 0F 00 3C E4 37 7E 9C 75 00 88 00 00 00 00 00 00 00 00 ED FB FF FF 00 00 F0 3F }
	condition:
		$1
}

rule file_79_0_1 {
	meta:
		name = "hypotf"
		size = 200
		refs = "000c __ieee754_hypotf 001a finitef 0050 __extendsfdf2 0076 __errno 0088 __truncdfsf2 009a matherr 00b0 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 89 B0 05 1C 0F 1C ?? ?? ?? ?? 27 4E 33 68 04 1C 01 33 04 D0 ?? ?? ?? ?? 80 46 00 28 04 D0 09 B0 20 1C 04 BC 90 46 F0 BD 28 1C ?? ?? ?? ?? 00 28 F5 D0 38 1C ?? ?? ?? ?? 00 28 F0 D0 03 23 00 93 1B 4B 28 1C 01 93 43 46 08 93 ?? ?? ?? ?? 6C 46 A0 60 E1 60 38 1C ?? ?? ?? ?? 33 68 20 61 61 61 00 2B 12 D0 13 49 13 4A A1 61 E2 61 02 2B 10 D1 ?? ?? ?? ?? 22 23 03 60 23 6A 00 2B 0F D1 A0 69 E1 69 ?? ?? ?? ?? 04 1C C9 E7 0B 4A 0C 4B A2 61 E3 61 68 46 ?? ?? ?? ?? 00 28 ED D1 E8 E7 ?? ?? ?? ?? 23 6A 03 60 EA E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 F0 7F 00 00 00 00 FF FF EF 47 00 00 00 E0 }
	condition:
		$1
}

rule file_80_0_1 {
	meta:
		name = "fmin"
		size = 58
		refs = "000a __fpclassifyd 002c __ltdf2"
	strings:
		$1 = { F0 B5 06 1C 0F 1C 14 1C 1D 1C ?? ?? ?? ?? 00 28 02 D1 29 1C 20 1C F0 BD 20 1C 29 1C ?? ?? ?? ?? 00 28 07 D0 30 1C 39 1C 22 1C 2B 1C ?? ?? ?? ?? 00 28 EE DA 34 1C 3D 1C EB E7 }
	condition:
		$1
}

rule file_82_0_1 {
	meta:
		name = "lgamma"
		size = 268
		refs = "0012 __ieee754_lgamma_r 0022 finite 0068 floor 0070 __eqdf2 0080 __ledf2 0094 matherr 00b6 __errno 00e8 _impure_ptr 00ec __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 38 4B 1A 68 8B B0 A0 32 04 1C 0D 1C ?? ?? ?? ?? 35 4E 33 68 00 90 01 91 01 33 04 D0 ?? ?? ?? ?? 80 46 00 28 05 D0 00 98 01 99 0B B0 04 BC 90 46 F0 BD 20 1C 29 1C ?? ?? ?? ?? 00 28 F3 D0 2A 4B 02 AF 7B 60 43 46 3B 62 33 68 BC 60 FD 60 3C 61 7D 61 00 2B 27 D1 25 4A 26 4B BA 61 FB 61 20 1C 29 1C ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 00 28 07 D1 20 1C 29 1C 1F 4A 20 4B ?? ?? ?? ?? 00 28 1B DD 03 23 02 93 33 68 02 2B 11 D0 38 1C ?? ?? ?? ?? 00 28 0C D0 3B 6A 00 2B 1D D1 BB 69 FC 69 00 93 01 94 BF E7 15 4A 16 4B BA 61 FB 61 D6 E7 ?? ?? ?? ?? 22 23 03 60 ED E7 02 23 02 93 33 68 02 2B 04 D0 38 1C ?? ?? ?? ?? 00 28 E3 D1 ?? ?? ?? ?? 21 23 03 60 DE E7 ?? ?? ?? ?? 3B 6A 03 60 DC E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF EF 47 00 00 00 E0 00 00 00 00 00 00 00 00 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_83_0_1 {
	meta:
		name = "__ieee754_ynf"
		size = 264
		refs = "003c __ieee754_y0f 0044 __ieee754_y1f 005c __floatsisf 0062 __divsf3 0068 __mulsf3 006e __subsf3 00a8 __addsf3"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 3B 4A FF 23 0A 40 DB 05 07 1C 0E 1C 9A 42 44 DC 00 2A 37 D0 00 29 57 DB 00 28 4D DB 00 28 44 D0 01 23 99 46 01 2F 55 D0 FF 23 DB 05 9A 42 41 D0 30 1C ?? ?? ?? ?? 80 46 30 1C ?? ?? ?? ?? 80 22 12 04 83 18 04 1C 00 2B 15 D0 29 4B 01 25 9A 46 68 00 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 41 46 ?? ?? ?? ?? 01 35 A0 46 50 45 01 D0 AF 42 18 DC 04 1C 4A 46 00 2A 08 DC 80 23 1B 06 E4 18 04 E0 1C 48 1C 49 ?? ?? ?? ?? 04 1C 20 1C 1C BC 90 46 99 46 A2 46 F0 BD 30 1C 31 1C ?? ?? ?? ?? 04 1C F3 E7 04 1C D2 E7 30 1C ?? ?? ?? ?? 04 1C EC E7 11 4C EA E7 47 42 01 23 39 1C 19 40 49 00 59 1A 89 46 AD E7 0C 48 01 1C ?? ?? ?? ?? 04 1C DC E7 30 1C ?? ?? ?? ?? 04 1C 48 46 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 04 1C D0 E7 C0 46 FF FF FF 7F 00 00 80 FF 00 00 80 BF 00 00 00 00 }
	condition:
		$1
}

rule file_83_1_1 {
	meta:
		name = "__ieee754_jnf"
		size = 716
		refs = "002c fabsf 0062 __addsf3 0076 __floatsisf 0080 __gesf2 0098 __mulsf3 00c6 __divsf3 00ce __ieee754_j0f 00d6 __ieee754_j1f 010c __subsf3 0114 __ltsf2 0186 __ieee754_logf 01e6 __gtsf2"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 A6 4D FF 23 0D 40 DB 05 82 B0 04 1C 88 46 9D 42 20 DC 00 28 22 DB 00 28 52 D0 01 2C 54 D0 08 1C ?? ?? ?? ?? FF 23 DB 05 06 1C 9D 42 01 D0 00 2D 1A D1 9B 48 01 23 42 46 1C 40 D3 17 1C 42 02 D0 80 23 1B 06 C0 18 02 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 08 1C ?? ?? ?? ?? F4 E7 80 23 1B 06 44 42 C9 18 98 44 D8 E7 20 1C ?? ?? ?? ?? 01 90 01 99 30 1C ?? ?? ?? ?? 00 28 00 DB BD E0 89 4B 9D 42 25 DC 21 2C D4 DC 30 1C 87 49 ?? ?? ?? ?? 86 4F 82 46 06 1C 02 25 28 1C ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 51 46 07 1C 30 1C ?? ?? ?? ?? 01 35 06 1C A5 42 EF DD 39 1C ?? ?? ?? ?? B9 E7 08 1C ?? ?? ?? ?? BE E7 08 1C ?? ?? ?? ?? BA E7 62 00 10 1C 93 46 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 31 1C 81 46 72 48 ?? ?? ?? ?? 00 90 00 99 48 46 ?? ?? ?? ?? 07 1C 39 1C 48 46 ?? ?? ?? ?? 6B 49 ?? ?? ?? ?? 6B 49 05 1C ?? ?? ?? ?? 00 28 00 DB C1 E0 01 22 92 46 01 23 38 1C 00 99 9A 44 ?? ?? ?? ?? 29 1C 07 1C ?? ?? ?? ?? 49 46 ?? ?? ?? ?? 60 49 A9 46 05 1C ?? ?? ?? ?? 00 28 EB DB 52 46 15 19 6D 00 AB 45 00 DD A3 E0 55 4F 28 1C ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 01 1C 52 48 ?? ?? ?? ?? 02 3D 07 1C AB 45 EE DD 00 99 01 98 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 1C 01 98 ?? ?? ?? ?? 4C 49 ?? ?? ?? ?? 00 28 51 DB 63 1E 58 00 9A 46 ?? ?? ?? ?? 44 4A 81 46 00 97 93 46 08 E0 5A 46 00 92 01 23 5B 42 9A 44 52 46 00 2A 64 D0 AB 46 49 46 58 46 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 00 99 ?? ?? ?? ?? 39 49 05 1C 48 46 ?? ?? ?? ?? 39 49 81 46 28 1C ?? ?? ?? ?? 00 28 E0 DD 29 1C 58 46 ?? ?? ?? ?? 29 1C 00 90 38 1C ?? ?? ?? ?? 2D 4D 07 1C D6 E7 30 1C ?? ?? ?? ?? 82 46 30 1C ?? ?? ?? ?? 01 25 07 1C 00 E0 1F 1C 68 00 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 51 46 ?? ?? ?? ?? 01 35 03 1C BA 46 A5 42 ED DB FF E6 63 1E 58 00 9A 46 ?? ?? ?? ?? 1B 4A 81 46 01 97 93 46 01 E0 00 9D AB 46 49 46 58 46 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 01 99 ?? ?? ?? ?? 13 49 00 90 05 1C 48 46 ?? ?? ?? ?? 01 23 5B 42 9A 44 52 46 5B 46 81 46 01 93 00 2A E4 D1 30 1C ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? D0 E6 03 4F 6B E7 01 23 9A 46 50 E7 FF FF FF 7F 00 00 00 00 FF FF 7F 30 00 00 00 3F 00 00 80 3F 00 00 00 40 28 6B 6E 4E 80 71 B1 42 F9 02 15 50 }
	condition:
		$1
}

rule file_85_0_1 {
	meta:
		name = "nextafterf"
		size = 168
		refs = "001c __addsf3 002a __eqsf2 0056 __mulsf3 005c __nesf2"
	strings:
		$1 = { F0 B5 27 4B 07 1C 0A 1C 1F 40 1A 40 FF 23 DB 05 04 1C 05 1C 0E 1C 9A 42 05 DD 20 1C ?? ?? ?? ?? 04 1C 20 1C F0 BD 9F 42 F7 DC ?? ?? ?? ?? 00 28 F7 D0 00 2F 16 D0 00 2C 25 DB B4 42 27 DC 01 35 FF 23 DB 05 2A 1C 1A 40 9A 42 22 D0 15 4B 9A 42 06 DC 21 1C 20 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 2C 1C DE E7 80 24 24 06 01 23 34 40 1C 43 21 1C 20 1C ?? ?? ?? ?? 21 1C 05 1C ?? ?? ?? ?? 00 28 CF D1 2C 1C CD E7 B4 42 01 DC 00 2E D7 DB 01 3D D6 E7 20 1C 21 1C ?? ?? ?? ?? 04 1C C1 E7 C0 46 FF FF FF 7F FF FF 7F 00 }
	condition:
		$1
}

rule file_86_0_1 {
	meta:
		name = "asinhf"
		size = 248
		refs = "0018 __addsf3 001e __gtsf2 002a __mulsf3 0032 fabsf 0040 __ieee754_sqrtf 004e __divsf3 005a log1pf 00b4 __ieee754_logf"
	strings:
		$1 = { F0 B5 37 4B 37 4A 03 40 06 1C 04 1C 93 42 59 DC 35 4A 93 42 28 DC 35 49 ?? ?? ?? ?? 34 49 ?? ?? ?? ?? 00 28 1E DC 31 1C 30 1C ?? ?? ?? ?? 05 1C 30 1C ?? ?? ?? ?? 2E 49 06 1C 28 1C ?? ?? ?? ?? ?? ?? ?? ?? 2A 49 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? ?? ?? ?? ?? 00 2C 2C DD 06 1C 30 1C F0 BD 9B 22 D2 05 93 42 2E DC 80 22 D2 05 93 42 D6 DD ?? ?? ?? ?? 31 1C 05 1C 30 1C ?? ?? ?? ?? 1A 49 ?? ?? ?? ?? ?? ?? ?? ?? 29 1C 06 1C 28 1C ?? ?? ?? ?? 31 1C 07 1C 28 1C ?? ?? ?? ?? 01 1C 12 48 ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? ?? ?? ?? ?? 00 2C D2 DC 80 23 1B 06 C6 18 CF E7 31 1C ?? ?? ?? ?? 06 1C CA E7 ?? ?? ?? ?? ?? ?? ?? ?? 07 49 ?? ?? ?? ?? BF E7 C0 46 FF FF FF 7F FF FF 7F 7F FF FF 7F 31 CA F2 49 71 00 00 80 3F 18 72 31 3F }
	condition:
		$1
}

rule file_87_0_1 {
	meta:
		name = "ilogbf"
		size = 76
	strings:
		$1 = { 0E 4A 10 40 12 D0 0E 4B 98 42 05 DD 0D 4B 98 42 0E DC C0 15 7F 38 70 47 03 02 00 2B 0A DD 7E 20 40 42 5B 00 01 38 00 2B FB DC F4 E7 06 48 F2 E7 10 1C F0 E7 7E 20 40 42 ED E7 C0 46 FF FF FF 7F FF FF 7F 00 FF FF 7F 7F 01 00 00 80 }
	condition:
		$1
}

rule file_89_0_1 {
	meta:
		name = "cos"
		size = 176
		refs = "001e __subdf3 002e __ieee754_rem_pio2 004a __kernel_cos 007c __kernel_sin"
	strings:
		$1 = { 10 B5 26 4C 0B 1C 21 1C 02 1C 01 40 24 48 85 B0 81 42 1D DD 23 48 81 42 05 DD 10 1C 19 1C ?? ?? ?? ?? 05 B0 10 BD 01 AC 10 1C 19 1C 22 1C ?? ?? ?? ?? 03 23 18 40 01 28 1B D0 02 28 0F D0 00 28 22 D1 20 68 61 68 A2 68 E3 68 ?? ?? ?? ?? E8 E7 10 1C 19 1C 14 4A 15 4B ?? ?? ?? ?? E1 E7 A2 68 E3 68 20 68 61 68 ?? ?? ?? ?? 80 23 1B 06 C0 18 D7 E7 A2 68 E3 68 00 90 01 98 02 99 ?? ?? ?? ?? 80 23 1B 06 C0 18 CC E7 A2 68 E3 68 20 68 61 68 01 24 00 94 ?? ?? ?? ?? C3 E7 C0 46 FF FF FF 7F FB 21 E9 3F FF FF EF 7F 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_90_0_1 {
	meta:
		name = "tan"
		size = 112
		refs = "001e __subdf3 002e __ieee754_rem_pio2 0044 __kernel_tan"
	strings:
		$1 = { 10 B5 16 4C 0B 1C 21 1C 02 1C 01 40 14 48 85 B0 81 42 1A DD 13 48 81 42 05 DD 10 1C 19 1C ?? ?? ?? ?? 05 B0 10 BD 01 AC 19 1C 10 1C 22 1C ?? ?? ?? ?? 01 21 08 40 40 00 09 1A A2 68 E3 68 00 91 01 98 02 99 ?? ?? ?? ?? EB E7 01 21 00 91 10 1C 19 1C 05 4A 05 4B ?? ?? ?? ?? E2 E7 FF FF FF 7F FB 21 E9 3F FF FF EF 7F 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_91_0_1 {
	meta:
		name = "roundf"
		size = 76
		refs = "002e __addsf3"
	strings:
		$1 = { 00 B5 43 00 1B 0E 7F 3B 01 1C 02 1C 16 2B 0C DC 00 2B 10 DB 0C 48 18 41 08 42 04 D0 80 21 C9 03 19 41 89 18 81 43 08 1C 00 BD 80 2B FB D1 ?? ?? ?? ?? 01 1C F7 E7 80 21 09 06 01 40 01 33 F2 D1 FE 23 9B 05 19 43 EE E7 FF FF 7F 00 }
	condition:
		$1
}

rule file_92_0_1 {
	meta:
		name = "__ieee754_yn"
		size = 612
		refs = "0076 sin 0082 cos 008e __subdf3 009a __ieee754_sqrt 00aa __muldf3 00b2 __divdf3 00f6 __adddf3 0104 __ieee754_y0 0140 __ieee754_y1 0176 __floatsidf"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 16 1C 74 42 8A 4A 34 43 80 46 0A 40 E4 0F 89 48 14 43 87 B0 0D 1C 84 42 63 D8 00 2A 4E D0 00 29 00 DA 76 E0 41 46 00 29 00 DA 6A E0 43 46 00 2B 60 D0 01 24 02 94 41 46 01 29 00 D1 E7 E0 7D 4B 9A 42 00 D1 C2 E0 7C 4B 9A 42 00 DC 6A E0 03 23 42 46 13 40 02 2B 00 D1 CE E0 03 2B 00 D1 B8 E0 01 2B 00 D1 9C E0 28 1C 31 1C ?? ?? ?? ?? 00 90 01 91 28 1C 31 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 00 90 01 91 28 1C 31 1C ?? ?? ?? ?? 6A 4A 6A 4B 04 1C 0D 1C 00 98 01 99 ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 04 1C 0F 1C 02 9A 00 2A 0D DC 80 23 1B 06 E4 18 09 E0 00 2E AE D1 60 48 61 49 61 4A 62 4B ?? ?? ?? ?? 04 1C 0F 1C 07 B0 39 1C 20 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 28 1C 31 1C 2A 1C 33 1C ?? ?? ?? ?? 04 1C 0F 1C ED E7 28 1C 31 1C ?? ?? ?? ?? 04 1C 0F 1C E6 E7 49 42 01 23 88 46 19 40 49 00 59 1A 02 91 91 E7 4E 48 4E 49 02 1C 0B 1C ?? ?? ?? ?? 04 1C 0F 1C D5 E7 28 1C 31 1C ?? ?? ?? ?? 83 46 89 46 28 1C 31 1C ?? ?? ?? ?? 0F 1C 80 21 04 1C 49 03 63 18 00 2B B3 D0 01 22 00 95 01 96 03 94 4E 46 04 97 C1 46 15 1C A2 46 B8 46 05 E0 05 9B 3D 49 8B 42 A4 D0 A2 46 B8 46 68 00 ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 22 1C 3B 1C ?? ?? ?? ?? 5A 46 33 1C ?? ?? ?? ?? 01 35 02 1C 0B 1C 04 1C 0F 1C 05 92 06 93 D3 46 46 46 4D 45 00 DB 87 E7 DD E7 28 1C 31 1C ?? ?? ?? ?? 80 46 0F 1C 28 1C 31 1C ?? ?? ?? ?? 80 24 24 06 02 1C 20 1C 0B 1C 40 44 39 1C ?? ?? ?? ?? 00 90 01 91 5E E7 00 24 00 27 7E E7 28 1C 31 1C ?? ?? ?? ?? 00 90 01 91 28 1C 31 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 00 90 01 91 48 E7 28 1C 31 1C ?? ?? ?? ?? 00 90 01 91 28 1C 31 1C ?? ?? ?? ?? 35 E7 28 1C 31 1C ?? ?? ?? ?? 04 1C 0D 1C 02 98 ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 04 1C 0F 1C 50 E7 C0 46 FF FF FF 7F 00 00 F0 7F FF FF CF 52 D7 0D E2 3F 6D 9B 42 50 00 00 F0 BF 00 00 00 00 00 00 00 00 00 00 00 00 00 00 F0 FF }
	condition:
		$1
}

rule file_92_1_1 {
	meta:
		name = "__ieee754_jn"
		size = 1312
		refs = "003a fabs 0074 __adddf3 008e __floatsidf 009e __gedf2 00c8 cos 00d4 sin 00ec __ieee754_sqrt 00fc __muldf3 0104 __divdf3 010e __ieee754_j0 0184 __ieee754_j1 01d0 __subdf3 01dc __ltdf2 0290 __ieee754_log 0480 __gtdf2"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 04 1C B2 4E 50 42 0B 1C 10 43 1E 40 C0 0F B0 49 30 43 8C B0 1F 1C 15 1C 88 42 22 D8 00 2C 2A DB 00 2C 00 D1 6C E0 01 2C 00 D1 A4 E0 18 1C 11 1C ?? ?? ?? ?? 02 90 03 91 00 2E 19 D0 A6 4B 9E 42 1F DD 00 20 00 21 01 23 1C 40 FF 17 3C 42 02 D0 80 22 12 06 80 18 0C B0 1C BC 90 46 99 46 A2 46 F0 BD 11 1C 18 1C 1A 1C 0B 1C ?? ?? ?? ?? F2 E7 00 2D E6 D0 E2 E7 80 21 09 06 64 42 5B 18 7F 18 D1 E7 20 1C ?? ?? ?? ?? 08 90 09 91 08 9A 09 9B 02 98 03 99 ?? ?? ?? ?? 00 28 36 DB 8F 4B 9E 42 00 DC 84 E1 03 23 23 40 02 2B 00 D1 69 E1 03 2B 00 D1 0D E2 01 2B 00 D1 F7 E1 02 98 03 99 ?? ?? ?? ?? 05 1C 0E 1C 02 98 03 99 ?? ?? ?? ?? 02 1C 0B 1C 28 1C 31 1C ?? ?? ?? ?? 00 90 01 91 02 98 03 99 ?? ?? ?? ?? 7D 4A 7E 4B 05 1C 0E 1C 00 98 01 99 ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? A2 E7 18 1C 11 1C ?? ?? ?? ?? A5 E7 76 4B 9E 42 37 DC 21 2C 00 DD 95 E7 02 98 03 99 73 4A 74 4B ?? ?? ?? ?? 00 90 01 91 02 90 03 91 71 49 72 4A 04 91 05 92 B8 46 02 25 0E 1C 17 1C 28 1C ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 00 9A 01 9B 06 1C 0F 1C 02 98 03 99 ?? ?? ?? ?? 01 35 02 90 03 91 A5 42 E9 DD 04 96 05 97 04 9A 05 9B 47 46 ?? ?? ?? ?? 67 E7 18 1C 11 1C ?? ?? ?? ?? 6A E7 62 00 10 1C 92 46 ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 02 9A 03 9B 04 90 05 91 57 48 58 49 ?? ?? ?? ?? 06 90 07 91 06 9A 07 9B 04 98 05 99 ?? ?? ?? ?? 00 90 01 91 00 9A 01 9B 04 98 05 99 ?? ?? ?? ?? 4B 4A 4C 4B ?? ?? ?? ?? 4D 4A 4E 4B 05 1C 0E 1C ?? ?? ?? ?? 00 28 00 DB 84 E1 23 1C 01 21 B8 46 0C 1C 1F 1C 06 9A 07 9B 00 98 01 99 ?? ?? ?? ?? 2A 1C 33 1C 00 90 01 91 ?? ?? ?? ?? 04 9A 05 9B ?? ?? ?? ?? 3E 4A 3F 4B 04 95 05 96 01 34 05 1C 0E 1C ?? ?? ?? ?? 00 28 E4 DB 3B 1C 47 46 A0 46 1C 1C 42 46 15 19 6D 00 AA 45 00 DD 5D E1 36 4A 36 4B 0A 92 0B 93 A0 46 16 1C 54 46 BA 46 1F 1C 28 1C ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 02 1C 0B 1C 25 48 25 49 ?? ?? ?? ?? 02 3D 06 1C 0F 1C AC 42 E9 DD 0A 96 0B 97 44 46 57 46 06 9A 07 9B 08 98 09 99 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 1C 0B 1C 08 98 09 99 ?? ?? ?? ?? 1E 4A 1F 4B ?? ?? ?? ?? 00 28 00 DB AF E0 63 1E 58 00 98 46 ?? ?? ?? ?? 00 90 01 91 0A 99 0B 9A 06 91 07 92 0D 4A 0E 4B 04 92 05 93 23 1C 44 46 B8 46 1F 1C 28 E0 C0 46 FF FF FF 7F 00 00 F0 7F FF FF EF 7F FF FF CF 52 D7 0D E2 3F 6D 9B 42 50 FF FF 0F 3E 00 00 E0 3F 00 00 00 00 00 00 F0 3F 00 00 00 00 00 00 00 40 00 00 00 00 65 CD CD 41 00 00 00 00 00 00 00 00 00 00 00 00 42 2E 86 40 EF 39 FA FE 04 95 05 96 00 9A 01 9B 04 98 05 99 ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 06 9A 07 9B ?? ?? ?? ?? 6F 4B 6E 4A 05 1C 0E 1C 00 98 01 99 08 95 09 96 ?? ?? ?? ?? 00 90 01 91 04 99 05 9A 01 3C 06 91 07 92 00 2C DC D1 08 9D 09 9E 3C 1C 47 46 02 98 03 99 ?? ?? ?? ?? 0A 9A 0B 9B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 61 E6 02 98 03 99 ?? ?? ?? ?? 80 46 0E 1C 02 98 03 99 ?? ?? ?? ?? 80 25 2D 06 02 1C 28 1C 0B 1C 40 44 31 1C ?? ?? ?? ?? 00 90 01 91 97 E6 02 98 03 99 ?? ?? ?? ?? 89 46 82 46 02 98 03 99 ?? ?? ?? ?? 4A 46 A0 46 B9 46 06 1C 01 25 17 1C 0C 1C 01 E0 06 1C 0C 1C 68 00 ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 32 1C 23 1C ?? ?? ?? ?? 01 35 52 46 3B 1C ?? ?? ?? ?? B2 46 27 1C 45 45 E9 DB 4F 46 44 46 20 E6 62 1E 50 00 90 46 ?? ?? ?? ?? 00 90 01 91 0A 99 0B 9A 06 91 07 92 38 4A 39 4B 04 92 05 93 23 1C 44 46 B8 46 1F 1C 08 E0 04 99 05 9A 06 91 07 92 01 3C 00 2C 34 D0 04 95 05 96 00 9A 01 9B 04 98 05 99 ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 06 9A 07 9B ?? ?? ?? ?? 27 4B 26 4A 05 1C 0E 1C 00 98 01 99 ?? ?? ?? ?? 26 4A 27 4B 00 90 01 91 28 1C 31 1C ?? ?? ?? ?? 00 28 D6 DD 2A 1C 33 1C 04 98 05 99 ?? ?? ?? ?? 2A 1C 06 90 07 91 33 1C 0A 98 0B 99 ?? ?? ?? ?? 18 4D 19 4E 0A 90 0B 91 C7 E7 3C 1C 47 46 5E E7 02 98 03 99 ?? ?? ?? ?? 05 1C 0E 1C 02 98 03 99 ?? ?? ?? ?? 02 1C 0B 1C 28 1C 31 1C ?? ?? ?? ?? 00 90 01 91 06 E6 02 98 03 99 ?? ?? ?? ?? 05 1C 0E 1C 02 98 03 99 ?? ?? ?? ?? EB E7 01 23 98 46 9B E6 08 49 08 4A 0A 91 0B 92 BF E6 00 00 00 40 00 00 00 00 00 00 F0 3F 00 00 00 00 AD 49 B2 54 7D C3 94 25 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_93_0_1 {
	meta:
		name = "acosh"
		size = 184
		refs = "000c __ieee754_acosh 0020 __isnand 0032 __ltdf2 0058 __divdf3 0068 matherr 008a __errno 00a0 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8B B0 04 1C 0D 1C ?? ?? ?? ?? 23 4E 33 68 00 90 01 91 01 33 30 D0 20 1C 29 1C ?? ?? ?? ?? 80 46 00 28 29 D1 20 1C 29 1C 1D 4A 1D 4B ?? ?? ?? ?? 00 28 21 DA 01 23 02 93 1B 4B 02 AF 1B 48 1B 49 7B 60 43 46 3B 62 3C 61 7D 61 0B 1C BC 60 FD 60 02 1C ?? ?? ?? ?? 33 68 B8 61 F9 61 02 2B 11 D0 38 1C ?? ?? ?? ?? 00 28 0C D0 3B 6A 00 2B 0E D1 BB 69 FC 69 00 93 01 94 00 98 01 99 0B B0 04 BC 90 46 F0 BD ?? ?? ?? ?? 21 23 03 60 ED E7 ?? ?? ?? ?? 3B 6A 03 60 EB E7 C0 46 ?? ?? ?? ?? 00 00 F0 3F 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_94_0_1 {
	meta:
		name = "__fpclassifyd"
		size = 128
	strings:
		$1 = { 10 B5 03 1C 08 1E 03 D1 00 2B 01 D1 02 20 10 BD 42 42 42 41 00 2A 06 D1 14 49 58 18 14 49 88 42 0A D8 04 20 F3 E7 80 21 09 06 8B 42 EE D0 0F 49 58 18 0F 49 88 42 F4 D9 0E 4C 18 19 88 42 F0 D9 80 21 09 06 58 18 0C 49 88 42 01 D8 03 20 DE E7 8B 42 FB D9 80 24 64 03 18 19 41 42 48 41 07 49 5B 18 59 42 4B 41 18 43 10 40 D0 E7 00 00 F0 7F FF FF DF 7F 00 00 F0 FF FF FF 0F 00 00 00 10 80 }
	condition:
		$1
}

rule file_95_0_1 {
	meta:
		name = "__ieee754_fmodf"
		size = 300
		refs = "001e __mulsf3 0024 __divsf3"
	strings:
		$1 = { 70 B5 80 22 12 06 06 1C 16 40 43 4A 0C 1C 03 1C 14 40 42 4A 73 40 93 42 01 DC 00 2C 05 D1 ?? ?? ?? ?? 01 1C ?? ?? ?? ?? 70 BD FF 22 D2 05 94 42 F5 DC A3 42 F8 DB A3 42 48 D0 39 4A 93 42 4D DC 19 02 00 29 64 DD 7E 22 52 42 49 00 01 3A 00 29 FB DC 33 49 8C 42 4E DC 21 02 00 29 55 DB 7E 25 6D 42 49 00 01 3D 00 29 FB DA 11 1C 7E 31 3D DB 2B 48 80 21 03 40 09 04 0B 43 29 1C 7E 31 30 DB 27 49 0C 40 80 21 09 04 0C 43 52 1B 00 2A 07 D0 19 1B 20 D4 00 29 19 D0 4B 00 01 3A 00 2A F7 D1 1C 1B 00 D4 23 1C 00 2B 10 D0 1D 4A 93 42 03 DC 5B 00 01 3D 93 42 FB DD 2A 1C 7E 32 1E DB 19 49 7F 35 58 18 30 43 ED 05 28 43 AD E7 F6 0F 16 4B B6 00 F0 58 A8 E7 5B 00 01 3A DF E7 DA 15 7F 3A B7 E7 7E 21 49 42 49 1B 8C 40 CE E7 7E 21 49 42 89 1A 8B 40 C1 E7 E5 15 7F 3D B6 E7 7E 22 52 42 50 1B 03 41 18 1C 30 43 8E E7 7E 25 6D 42 AC E7 7E 22 52 42 9D E7 C0 46 FF FF FF 7F FF FF 7F 7F FF FF 7F 00 00 00 80 FF ?? ?? ?? ?? }
	condition:
		$1
}

rule file_96_0_1 {
	meta:
		name = "__ieee754_cosh"
		size = 376
		refs = "003c __muldf3 005e fabs 0062 expm1 006e __adddf3 00a0 __divdf3 00c8 __ieee754_exp"
	strings:
		$1 = { F0 B5 4F 4C 0B 1C 4F 49 04 40 82 B0 02 1C 8C 42 19 DC 4D 49 8C 42 20 DD 4C 49 8C 42 00 DC 64 E0 4B 49 8C 42 00 DC 7D E0 4A 49 8C 42 44 DD 01 31 8C 42 3E D0 48 48 49 49 02 1C 0B 1C ?? ?? ?? ?? 05 1C 0E 1C 05 E0 10 1C 19 1C ?? ?? ?? ?? 05 1C 0E 1C 02 B0 28 1C 31 1C F0 BD 10 1C 19 1C ?? ?? ?? ?? ?? ?? ?? ?? 3E 4A 3E 4B 00 90 01 91 ?? ?? ?? ?? 3D 4B 05 1C 0E 1C 9C 42 EA DD 00 98 01 99 02 1C 0B 1C ?? ?? ?? ?? 2A 1C 00 90 01 91 33 1C 28 1C 31 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 2E 4A 2F 4B ?? ?? ?? ?? 05 1C 0E 1C CF E7 2E 49 8B 42 BD D8 10 1C 19 1C ?? ?? ?? ?? 2B 4A 2C 4B ?? ?? ?? ?? ?? ?? ?? ?? 28 4A 29 4B 0D 1C 04 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 05 1C 0E 1C B3 E7 10 1C 19 1C ?? ?? ?? ?? ?? ?? ?? ?? 1E 4A 1E 4B 0D 1C 04 1C ?? ?? ?? ?? 2B 1C 06 1C 0F 1C 22 1C 19 48 19 49 ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 05 1C 0E 1C 96 E7 10 1C 19 1C ?? ?? ?? ?? ?? ?? ?? ?? 0F 4A 10 4B ?? ?? ?? ?? 05 1C 0E 1C 89 E7 C0 46 FF FF FF 7F FF FF EF 7F 42 2E D6 3F FF FF 35 40 41 2E 86 40 CD 33 86 40 3C E4 37 7E 9C 75 00 88 00 00 F0 3F 00 00 00 00 FF FF 7F 3C 7D F8 B9 8F 00 00 E0 3F 00 00 00 00 }
	condition:
		$1
}

rule file_97_0_1 {
	meta:
		name = "atanhf"
		size = 236
		refs = "000a __ieee754_atanhf 001a isnanf 0030 fabsf 0038 __gesf2 0044 __gtsf2 0058 __extendsfdf2 006e __divdf3 007e matherr 0090 __truncdfsf2 00c4 __errno 00d8 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 89 B0 04 1C ?? ?? ?? ?? 32 4E 33 68 05 1C 01 33 05 D0 20 1C ?? ?? ?? ?? 07 1C 00 28 04 D0 09 B0 28 1C 04 BC 90 46 F0 BD 20 1C ?? ?? ?? ?? 29 49 80 46 ?? ?? ?? ?? 00 28 F1 DB 40 46 26 49 ?? ?? ?? ?? 00 28 25 DD 01 23 00 93 23 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 6D 46 28 61 69 61 A8 60 E9 60 1F 48 1F 49 0B 1C 02 1C ?? ?? ?? ?? 33 68 A8 61 E9 61 02 2B 23 D0 68 46 ?? ?? ?? ?? 00 28 1E D0 2B 6A 00 2B 20 D1 A8 69 E9 69 ?? ?? ?? ?? 05 1C C5 E7 02 23 00 93 10 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 6D 46 0E 4A 0E 4B 28 61 69 61 A8 60 E9 60 ?? ?? ?? ?? 33 68 A8 61 E9 61 02 2B DB D1 ?? ?? ?? ?? 21 23 03 60 DB E7 ?? ?? ?? ?? 2B 6A 03 60 D9 E7 ?? ?? ?? ?? 00 00 80 3F ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_98_0_1 {
	meta:
		name = "sqrtf"
		size = 176
		refs = "0006 __ieee754_sqrtf 0016 isnanf 0024 __ltsf2 0038 __extendsfdf2 0054 __divdf3 0060 __errno 0072 __truncdfsf2 0088 matherr 009c __fdlib_version"
	strings:
		$1 = { F0 B5 89 B0 04 1C ?? ?? ?? ?? 24 4E 33 68 05 1C 01 33 31 D0 20 1C ?? ?? ?? ?? 07 1C 00 28 2B D1 20 1C 1F 49 ?? ?? ?? ?? 00 28 25 DA 01 23 00 93 1C 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 34 68 6D 46 28 61 69 61 A8 60 E9 60 00 2C 18 D0 16 48 17 49 02 1C 0B 1C ?? ?? ?? ?? A8 61 E9 61 02 2C 12 D1 ?? ?? ?? ?? 21 23 03 60 2B 6A 00 2B 11 D1 A8 69 E9 69 ?? ?? ?? ?? 05 1C 09 B0 28 1C F0 BD 0A 4B 0A 4C AB 61 EC 61 68 46 ?? ?? ?? ?? 00 28 EB D1 E6 E7 ?? ?? ?? ?? 2B 6A 03 60 E8 E7 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_102_0_1 {
	meta:
		name = "tanf"
		size = 84
		refs = "0016 __subsf3 0020 __ieee754_rem_pio2f 0032 __kernel_tanf"
	strings:
		$1 = { 00 B5 10 4B 10 4A 03 40 82 B0 01 1C 93 42 13 DD 0E 4A 93 42 03 DD ?? ?? ?? ?? 02 B0 00 BD 69 46 ?? ?? ?? ?? 01 23 02 1C 1A 40 52 00 9A 1A 00 98 01 99 ?? ?? ?? ?? F0 E7 05 49 01 22 ?? ?? ?? ?? EB E7 C0 46 FF FF FF 7F DA 0F 49 3F FF FF 7F 7F 00 00 00 00 }
	condition:
		$1
}

rule file_104_0_1 {
	meta:
		name = "remainder"
		size = 184
		refs = "0010 __ieee754_remainder 0024 __isnand 0036 __eqdf2 0060 __divdf3 0070 matherr 0092 __errno 00a8 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8D B0 1D 1C 02 90 03 91 14 1C ?? ?? ?? ?? 24 4E 33 68 00 90 01 91 01 33 32 D0 20 1C 29 1C ?? ?? ?? ?? 80 46 00 28 2B D1 20 1C 29 1C 1E 4A 1E 4B ?? ?? ?? ?? 00 28 23 D1 01 23 04 93 1C 4B 04 AF 42 46 18 48 19 49 7B 60 3A 62 02 9A 03 9B 3C 61 7D 61 BA 60 FB 60 0B 1C 02 1C ?? ?? ?? ?? 33 68 B8 61 F9 61 02 2B 11 D0 38 1C ?? ?? ?? ?? 00 28 0C D0 3B 6A 00 2B 0E D1 BB 69 FC 69 00 93 01 94 00 98 01 99 0D B0 04 BC 90 46 F0 BD ?? ?? ?? ?? 21 23 03 60 ED E7 ?? ?? ?? ?? 3B 6A 03 60 EB E7 C0 46 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_0_1 {
	meta:
		name = "__fpclassifyf"
		size = 104
	strings:
		$1 = { 80 23 1B 06 98 42 01 D0 00 28 01 D1 02 20 70 47 FF 21 C9 05 0F 4B 42 18 9A 42 01 D8 04 20 F6 E7 0D 49 42 18 9A 42 F9 D9 0C 4B C2 18 0C 4B 9A 42 01 D8 03 20 EB E7 42 1E 9A 42 FA D9 80 21 09 04 42 18 53 42 5A 41 07 4B C0 18 43 42 43 41 10 1C 18 43 DC E7 FF FF FF 7E 00 00 80 FF FF FF FF 7F FE FF 7F 00 00 00 80 80 }
	condition:
		$1
}

rule file_106_0_1 {
	meta:
		name = "__ieee754_exp"
		size = 776
		refs = "0032 __adddf3 0058 __gtdf2 0088 __ltdf2 009a __muldf3 00ac __fixdfsi 00b2 __floatsidf 00ca __subdf3 0184 __divdf3"
	strings:
		$1 = { F0 B5 47 46 80 B4 9A 4A 03 1C 13 40 99 4A 84 B0 04 1C 0D 1C C6 0F 93 42 10 D9 97 4A 93 42 28 D9 18 03 02 D1 00 29 00 D1 16 E1 20 1C 29 1C 22 1C 2B 1C ?? ?? ?? ?? 04 1C 0D 1C C4 E0 8F 4A 93 42 00 D9 C6 E0 8E 4A 93 42 00 D9 D8 E0 8D 4A 8E 4B ?? ?? ?? ?? 8D 4A 8E 4B ?? ?? ?? ?? 00 28 48 DD 20 1C 29 1C 89 4A 8A 4B ?? ?? ?? ?? 04 1C 0D 1C A9 E0 88 4A 88 4B ?? ?? ?? ?? 00 28 00 DD C1 E0 20 1C 29 1C 85 4A 86 4B ?? ?? ?? ?? 00 28 00 DA E4 E0 84 4A 84 4B 20 1C 29 1C ?? ?? ?? ?? 83 4B F6 00 9E 19 32 6A 73 6A ?? ?? ?? ?? ?? ?? ?? ?? 80 46 ?? ?? ?? ?? 7E 4A 7E 4B 06 1C 0F 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 7A 4A 7A 4B 02 90 03 91 30 1C 39 1C ?? ?? ?? ?? 00 90 01 91 02 98 03 99 00 9A 01 9B ?? ?? ?? ?? 04 1C 0D 1C 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 70 4A 70 4B 06 1C 0F 1C ?? ?? ?? ?? 6F 4A 6F 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 6D 4A 6D 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 6B 4A 6B 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 69 4A 69 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 0B 1C 02 1C 29 1C 20 1C ?? ?? ?? ?? 43 46 06 1C 0F 1C 00 2B 5A D0 20 1C 29 1C 32 1C 3B 1C ?? ?? ?? ?? 32 1C 04 1C 0D 1C 3B 1C 5C 48 5D 49 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 0B 1C 02 1C 3A 48 3B 49 ?? ?? ?? ?? 51 4B 98 45 59 DA FA 22 92 00 16 1C 46 44 36 05 30 18 4E 4A 4E 4B ?? ?? ?? ?? 04 1C 0D 1C 04 B0 29 1C 20 1C 04 BC 90 46 F0 BD 4A 4A 93 42 00 D9 5B E7 34 4F F3 00 FF 18 3A 68 7B 68 ?? ?? ?? ?? 73 42 02 90 03 91 9E 1B 39 69 7A 69 01 36 00 91 01 92 B0 46 71 E7 00 22 90 46 76 E7 1F 48 20 49 02 1C 0B 1C ?? ?? ?? ?? 04 1C 0D 1C D7 E7 20 1C 29 1C 32 1C 3B 1C ?? ?? ?? ?? 31 4A 31 4B 00 90 01 91 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 02 1C 0B 1C 10 48 10 49 ?? ?? ?? ?? 04 1C 0D 1C B6 E7 00 2E B4 D0 28 4C 29 4D B1 E7 02 1C 40 46 06 05 0D 1C B4 18 AB E7 C0 46 FF FF FF 7F 41 2E 86 40 FF FF EF 7F 42 2E D6 3F FF FF 2F 3E 3C E4 37 7E 9C 75 00 88 00 00 F0 3F 00 00 00 00 42 2E 86 40 EF 39 FA FE 10 49 87 C0 51 30 2D D5 47 15 F7 3F FE 82 2B 65 ?? ?? ?? ?? 42 2E E6 3F 00 00 E0 FE EF 39 EA 3D 76 3C 79 35 69 37 66 3E D0 A4 BE 72 41 BD BB 3E F1 6B D2 C5 6A 56 11 3F 2C DE 25 AF 6C C1 66 3F 93 BD BE 16 55 55 C5 3F 3E 55 55 55 00 00 00 40 00 00 00 00 03 FC FF FF 00 00 70 01 00 00 00 00 B1 A2 F0 3F 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_108_0_1 {
	meta:
		name = "sqrt"
		size = 188
		refs = "000c __ieee754_sqrt 0020 __isnand 0032 __ltdf2 005e __divdf3 006a __errno 0096 matherr 00ac __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8B B0 04 1C 0D 1C ?? ?? ?? ?? 26 4E 33 68 00 90 01 91 01 33 31 D0 20 1C 29 1C ?? ?? ?? ?? 80 46 00 28 2A D1 20 1C 29 1C 20 4A 20 4B ?? ?? ?? ?? 00 28 22 DA 01 23 02 AF 02 93 1D 4B 3C 61 7D 61 BC 60 FD 60 34 68 7B 60 43 46 3B 62 00 2C 1A D0 16 48 16 49 02 1C 0B 1C ?? ?? ?? ?? B8 61 F9 61 02 2C 14 D1 ?? ?? ?? ?? 21 23 03 60 3B 6A 00 2B 13 D1 BB 69 FC 69 00 93 01 94 00 98 01 99 0B B0 04 BC 90 46 F0 BD 08 4B 09 4C BB 61 FC 61 38 1C ?? ?? ?? ?? 00 28 E9 D1 E4 E7 ?? ?? ?? ?? 3B 6A 03 60 E6 E7 C0 46 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_109_0_1 {
	meta:
		name = "sinhf"
		size = 228
		refs = "0006 __ieee754_sinhf 0014 finitef 003a __extendsfdf2 0052 __gtsf2 0064 matherr 0086 __errno 0098 __truncdfsf2 00b8 __fdlib_version"
	strings:
		$1 = { F0 B5 89 B0 05 1C ?? ?? ?? ?? 2B 4E 33 68 04 1C 01 33 04 D0 ?? ?? ?? ?? 07 1C 00 28 02 D0 09 B0 20 1C F0 BD 28 1C ?? ?? ?? ?? 00 28 F7 D0 03 23 00 93 22 4B 28 1C 01 93 08 97 ?? ?? ?? ?? 36 68 6C 46 20 61 61 61 A0 60 E1 60 00 2E 0F D1 28 1C 1B 49 ?? ?? ?? ?? 00 28 25 DC 1A 4A 1A 4B A2 61 E3 61 68 46 ?? ?? ?? ?? 00 28 10 D1 0B E0 28 1C 13 49 ?? ?? ?? ?? 00 28 12 DC 14 4A 14 4B A2 61 E3 61 02 2E ED D1 ?? ?? ?? ?? 22 23 03 60 23 6A 00 2B 0B D1 A0 69 E1 69 ?? ?? ?? ?? 04 1C BE E7 0C 4A 0D 4B EB E7 0D 4A 0D 4B D8 E7 ?? ?? ?? ?? 23 6A 03 60 EE E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 FF FF EF C7 00 00 00 E0 00 00 F0 FF 00 00 00 00 00 00 F0 7F 00 00 00 00 FF FF EF 47 00 00 00 E0 }
	condition:
		$1
}

rule file_110_1_1 {
	meta:
		name = "qonef"
		size = 232
		refs = "001c __mulsf3 0024 __divsf3 0032 __addsf3"
	strings:
		$1 = { F0 B5 34 4B 02 1C 1A 40 33 4B 07 1C 9A 42 5B DC 32 4E 35 1C 30 35 48 36 39 1C 38 1C ?? ?? ?? ?? 01 1C 2F 48 ?? ?? ?? ?? 71 69 04 1C ?? ?? ?? ?? 31 69 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? F1 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? B1 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 71 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 31 68 ?? ?? ?? ?? 69 69 06 1C 20 1C ?? ?? ?? ?? 29 69 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? E9 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? A9 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 69 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 29 68 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 0C 49 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 0A 49 ?? ?? ?? ?? 39 1C ?? ?? ?? ?? F0 BD 04 4E 35 1C 60 35 78 36 A2 E7 C0 46 FF FF FF 7F FF FF 1F 40 ?? ?? ?? ?? 00 00 80 3F 00 00 C0 3E }
	condition:
		$1
}

rule file_110_2_1 {
	meta:
		name = "__ieee754_j1f"
		size = 488
		refs = "001c __divsf3 002a fabsf 0040 __addsf3 0046 __gtsf2 0052 __mulsf3 006a __subsf3 00ec sinf 00f4 cosf 012a __ieee754_sqrtf"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 64 4D 64 4B 05 40 04 1C 06 1C 9D 42 08 DD 62 48 21 1C ?? ?? ?? ?? 1C BC 90 46 99 46 A2 46 F0 BD ?? ?? ?? ?? 5E 4B 07 1C 9D 42 5A DC 5D 4B 9D 42 0D DC 5C 49 20 1C ?? ?? ?? ?? 57 49 ?? ?? ?? ?? 00 28 04 DD 20 1C 58 49 ?? ?? ?? ?? E3 E7 21 1C 20 1C ?? ?? ?? ?? 55 49 05 1C ?? ?? ?? ?? 54 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 52 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 50 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 4D 49 06 1C 28 1C ?? ?? ?? ?? 4B 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 49 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 47 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 45 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 35 49 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 36 49 05 1C 20 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 99 E7 ?? ?? ?? ?? 04 1C 38 1C ?? ?? ?? ?? 80 23 1B 06 80 46 41 46 E0 18 ?? ?? ?? ?? 41 46 81 46 20 1C ?? ?? ?? ?? 32 4B 82 46 9D 42 25 DD 38 1C FF F7 83 FE 04 1C 38 1C FF F7 F9 FE 80 46 38 1C ?? ?? ?? ?? 21 1C 05 1C 50 46 ?? ?? ?? ?? 41 46 04 1C 48 46 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 25 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 00 2E 00 DB 61 E7 80 23 1B 06 C0 18 5D E7 39 1C 38 1C ?? ?? ?? ?? ?? ?? ?? ?? 41 46 05 1C 20 1C ?? ?? ?? ?? 1A 49 ?? ?? ?? ?? 00 28 05 DD 28 1C 49 46 ?? ?? ?? ?? 82 46 C3 E7 28 1C 51 46 ?? ?? ?? ?? 81 46 BD E7 FF FF FF 7F FF FF 7F 7F 00 00 80 3F FF FF FF 3F FF FF FF 31 CA F2 49 71 00 00 00 3F D2 57 55 33 36 2E 86 37 FD 6C B8 3A 00 00 80 3D 7E 56 59 2D 46 64 AD 31 C2 FF 9D 35 B6 FA 42 39 59 E8 9C 3C FF FF FF 7E BB 6E 10 3F 00 00 00 00 }
	condition:
		$1
}

rule file_110_3_1 {
	meta:
		name = "__ieee754_y1f"
		size = 572
		refs = "0032 __divsf3 004a __mulsf3 0050 __addsf3 007a __subsf3 00e8 __ieee754_j1f 00f0 __ieee754_logf 011e sinf 0126 cosf 0142 __ieee754_sqrtf 017a __gtsf2"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 78 4D 79 4A 05 40 04 1C 95 42 19 DC 00 2D 0F D0 00 28 00 DA 9C E0 75 4B 9D 42 00 DD 7B E0 92 23 9B 05 9D 42 17 DC 21 1C 71 48 ?? ?? ?? ?? 03 E0 70 48 71 49 ?? ?? ?? ?? 0C BC 90 46 9A 46 F0 BD 21 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 01 1C 6B 48 ?? ?? ?? ?? F0 E7 21 1C ?? ?? ?? ?? 68 49 05 1C ?? ?? ?? ?? 67 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 65 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 63 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 61 49 ?? ?? ?? ?? 61 49 06 1C 28 1C ?? ?? ?? ?? 5F 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 5D 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 5B 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 59 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 4C 49 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 05 1C 20 1C ?? ?? ?? ?? 06 1C 20 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 21 1C 06 1C 3E 48 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 48 49 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 90 E7 ?? ?? ?? ?? 06 1C 20 1C ?? ?? ?? ?? 80 23 1B 06 07 1C 39 1C F0 18 ?? ?? ?? ?? 3E 4B 80 46 9D 42 10 DD 20 1C ?? ?? ?? ?? 3C 49 04 1C 40 46 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 73 E7 29 48 01 1C ?? ?? ?? ?? 6E E7 21 1C 20 1C ?? ?? ?? ?? ?? ?? ?? ?? 39 1C 82 46 30 1C ?? ?? ?? ?? 21 49 ?? ?? ?? ?? 00 28 28 DD 50 46 41 46 ?? ?? ?? ?? 07 1C 90 23 DB 05 9D 42 D5 DC 20 1C FF F7 51 FD 05 1C 20 1C FF F7 C7 FD 06 1C 20 1C ?? ?? ?? ?? 29 1C 04 1C 40 46 ?? ?? ?? ?? 31 1C 05 1C 38 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 1C 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 35 E7 39 1C 30 1C ?? ?? ?? ?? 07 1C 39 1C 50 46 ?? ?? ?? ?? 80 46 D0 E7 C0 46 FF FF FF 7F FF FF 7F 7F FF FF FF 3F 83 F9 22 BF 00 00 80 BF 00 00 00 00 00 00 80 3F 03 60 C5 B3 1C 58 C5 37 2A AF FA 3A 3C 9E 4E 3D 31 C3 48 3E CF 81 92 2D EB F8 D5 31 D4 02 B6 35 4B 64 54 39 6A 28 A3 3C 83 F9 22 3F FF FF FF 7E BB 6E 10 3F }
	condition:
		$1
}

rule file_111_0_1 {
	meta:
		name = "__ieee754_acos"
		size = 1176
		refs = "0024 __subdf3 002c __divdf3 0050 __muldf3 0058 __ieee754_sqrt 0072 __adddf3"
	strings:
		$1 = { F0 B5 A2 4B 0D 1C A2 49 03 40 84 B0 04 1C 8B 42 0F DD A0 4E 9B 19 00 2B 00 D1 B5 E0 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? A2 E0 99 49 8B 42 00 DC A0 E0 00 28 00 DA 6F E1 22 1C 2B 1C 95 48 96 49 ?? ?? ?? ?? 95 4A 96 4B ?? ?? ?? ?? 04 1C 0D 1C ?? ?? ?? ?? 93 4A 94 4B 06 1C 00 90 01 91 20 1C 29 1C ?? ?? ?? ?? 91 4A 91 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 8F 4A 8F 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 8D 4A 8D 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 8B 4A 8B 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 89 4A 89 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 87 4A 87 4B 02 90 03 91 20 1C 29 1C ?? ?? ?? ?? 85 4A 85 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 83 4A 83 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 81 4A 81 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 67 4A 67 4B ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 00 27 02 90 03 91 32 1C 3B 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 32 1C 04 1C 0D 1C 3B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? 04 B0 F0 BD 5F 4A 93 42 0B DC 5F 48 5F 49 F7 E7 00 2D 00 D0 46 E7 00 2C 00 DC 78 E0 5C 48 5D 49 EE E7 22 1C 2B 1C 29 1C ?? ?? ?? ?? 41 4A 42 4B 06 1C 0F 1C ?? ?? ?? ?? 40 4A 41 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 3E 4A 3F 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 3C 4A 3D 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 3A 4A 3B 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 38 4A 39 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 36 4A 37 4B 00 90 01 91 30 1C 39 1C ?? ?? ?? ?? 34 4A 35 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 32 4A 33 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 30 4A 31 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 16 4A 17 4B ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 2A 48 2B 49 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 20 48 21 49 ?? ?? ?? ?? 78 E7 24 48 24 49 75 E7 FF FF FF 7F FF FF EF 3F 00 00 10 C0 FF FF DF 3F 00 00 F0 3F 00 00 00 00 00 00 E0 3F 00 00 00 00 E1 3D 02 3F 09 F7 FD 0D E0 EF 49 3F 88 B2 01 75 28 82 A4 3F 3B 8F 68 B5 55 C1 C9 3F 55 44 88 0E 12 D6 D4 3F 7D 6F EB 03 55 55 C5 3F 55 55 55 55 C5 B8 B3 3F 82 92 2E B1 6C 06 E6 3F 59 01 8D 1B E5 2A 00 40 C8 8A 59 9C 27 3A 03 40 4B 2D 8A 1C 00 00 60 3C FB 21 F9 3F 18 2D 44 54 00 00 00 00 00 00 00 00 26 A6 91 3C 07 5C 14 33 FB 21 09 40 18 2D 44 54 29 1C 40 4B 3E 4A ?? ?? ?? ?? 3F 4A 3F 4B ?? ?? ?? ?? 04 1C 0D 1C ?? ?? ?? ?? 3D 4A 3D 4B 06 1C 0F 1C 20 1C 29 1C ?? ?? ?? ?? 3B 4A 3B 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 39 4A 39 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 37 4A 37 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 35 4A 35 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 33 4A 33 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 31 4A 31 4B 00 90 01 91 20 1C 29 1C ?? ?? ?? ?? 2F 4A 2F 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 2D 4A 2D 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 2B 4A 2B 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 12 4B 10 4A ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 21 4A 21 4B ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 1E 4A 1E 4B ?? ?? ?? ?? 1E 4A 1E 4B ?? ?? ?? ?? AB E6 00 00 F0 3F 00 00 00 00 00 00 E0 3F 00 00 00 00 E1 3D 02 3F 09 F7 FD 0D E0 EF 49 3F 88 B2 01 75 28 82 A4 3F 3B 8F 68 B5 55 C1 C9 3F 55 44 88 0E 12 D6 D4 3F 7D 6F EB 03 55 55 C5 3F 55 55 55 55 C5 B8 B3 3F 82 92 2E B1 6C 06 E6 3F 59 01 8D 1B E5 2A 00 40 C8 8A 59 9C 27 3A 03 40 4B 2D 8A 1C 26 A6 91 3C 07 5C 14 33 00 00 00 C0 00 00 00 00 FB 21 09 40 18 2D 44 54 }
	condition:
		$1
}

rule file_113_0_1 {
	meta:
		name = "__ieee754_rem_pio2f"
		size = 768
		refs = "002c __subsf3 0074 __fixsfsi 0078 __floatsisf 008c __mulsf3 00b6 __eqsf2 00de __kernel_rem_pio2f 0146 fabsf 0154 __addsf3"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 A9 4C AA 4A 04 40 86 B0 03 1C 0D 1C 07 1C 94 42 6E DD A7 4A 94 42 1A DC 00 28 00 DC FD E0 A5 49 ?? ?? ?? ?? 0F 23 9C 43 A3 4B 06 1C 9C 42 00 D1 71 E0 A2 49 ?? ?? ?? ?? 01 1C 28 60 30 1C ?? ?? ?? ?? 9E 49 ?? ?? ?? ?? 01 26 68 60 54 E0 9C 4A 94 42 00 DC 71 E0 9B 4A 94 42 55 DC E3 15 86 3B 9A 46 DB 05 E4 1A 20 1C ?? ?? ?? ?? ?? ?? ?? ?? 03 AB 01 1C 03 90 20 1C 98 46 ?? ?? ?? ?? 92 49 ?? ?? ?? ?? 04 1C ?? ?? ?? ?? ?? ?? ?? ?? 42 46 01 1C 50 60 20 1C ?? ?? ?? ?? 8B 49 ?? ?? ?? ?? 43 46 98 60 89 49 04 AC 03 26 ?? ?? ?? ?? 00 28 07 D1 20 68 85 49 01 3E 04 3C ?? ?? ?? ?? 00 28 F7 D0 02 23 00 93 82 4B 40 46 01 93 29 1C 33 1C 52 46 ?? ?? ?? ?? 06 1C 00 2F 0D DA 2B 68 80 22 12 06 9B 18 2B 60 6B 68 9B 18 6B 60 76 42 03 E0 76 4B 28 60 4B 60 00 26 06 B0 30 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 19 1C ?? ?? ?? ?? 00 26 68 60 28 60 F0 E7 6F 49 ?? ?? ?? ?? 6E 49 04 1C ?? ?? ?? ?? 01 1C 28 60 20 1C ?? ?? ?? ?? 6A 49 ?? ?? ?? ?? 01 26 68 60 DE E7 ?? ?? ?? ?? 67 49 80 46 ?? ?? ?? ?? 66 49 ?? ?? ?? ?? ?? ?? ?? ?? 06 1C ?? ?? ?? ?? 63 49 81 46 ?? ?? ?? ?? 01 1C 40 46 ?? ?? ?? ?? 55 49 80 46 48 46 ?? ?? ?? ?? 82 46 1F 2E 19 DC FF 22 23 1C 93 43 1A 1C 71 1E 59 4B 89 00 CB 58 9A 42 0F D0 51 46 40 46 ?? ?? ?? ?? 28 60 01 1C 40 46 ?? ?? ?? ?? 51 46 ?? ?? ?? ?? 68 60 00 2F A7 DA 98 E7 51 46 40 46 ?? ?? ?? ?? E4 15 A3 46 C3 0D FF 24 23 40 5A 46 D3 1A 01 1C 28 60 08 2B E6 DD 42 49 48 46 ?? ?? ?? ?? 82 46 51 46 40 46 ?? ?? ?? ?? 02 90 02 99 40 46 ?? ?? ?? ?? 51 46 ?? ?? ?? ?? 3B 49 80 46 48 46 ?? ?? ?? ?? 41 46 ?? ?? ?? ?? 82 46 51 46 02 98 ?? ?? ?? ?? C3 0D 1C 40 5B 46 1C 1B 01 1C 28 60 19 2C 2D DC 02 9A 90 46 BD E7 26 49 ?? ?? ?? ?? 0F 23 9C 43 24 4B 06 1C 9C 42 0E D0 23 49 ?? ?? ?? ?? 01 1C 28 60 30 1C ?? ?? ?? ?? 1F 49 ?? ?? ?? ?? 01 26 68 60 76 42 56 E7 22 49 ?? ?? ?? ?? 21 49 04 1C ?? ?? ?? ?? 01 1C 28 60 20 1C ?? ?? ?? ?? 1D 49 ?? ?? ?? ?? 01 26 68 60 76 42 43 E7 1E 49 48 46 ?? ?? ?? ?? 04 1C 21 1C 02 98 ?? ?? ?? ?? 80 46 41 46 02 98 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 17 49 04 1C 48 46 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 82 46 71 E7 C0 46 FF FF FF 7F D8 0F 49 3F E3 CB 16 40 80 0F C9 3F D0 0F C9 3F 43 44 35 37 80 0F 49 43 FF FF 7F 7F 00 00 80 43 00 00 00 00 ?? ?? ?? ?? 00 44 35 37 08 A3 85 2E 84 F9 22 3F 00 00 00 3F 80 0F C9 BF ?? ?? ?? ?? 00 A3 85 2E 32 31 8D 24 }
	condition:
		$1
}

rule file_115_0_1 {
	meta:
		name = "__kernel_rem_pio2"
		size = 2070
		refs = "002c __divsi3 005e __floatsidf 00c0 __muldf3 00cc __adddf3 011c __fixdfsi 015a scalbn 016a floor 0198 __subdf3 0244 __eqdf2 03e4 __gedf2"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 CF 4C A5 44 80 46 A1 98 09 93 08 91 CD 49 14 1C 83 00 09 9A CB 58 01 3A E0 1E 18 21 06 93 03 92 ?? ?? ?? ?? 0B 90 00 28 00 DA 9F E3 0B 98 C3 43 5A 00 D3 18 DB 00 06 99 03 9A 1B 19 05 93 8F 18 16 D4 84 1A A2 9B A5 00 5C AE 5D 19 E7 19 07 E0 28 68 ?? ?? ?? ?? 04 35 03 C6 BC 42 08 D0 01 34 00 2C F5 DA B8 48 B9 49 04 35 03 C6 BC 42 F6 D1 06 9C 00 2C 01 DA 00 F0 C4 FB 09 9C 06 9B 69 46 30 31 1B 19 03 9A E4 00 07 91 00 93 8B 46 91 46 A2 46 03 9C 00 2C 00 DA A5 E1 48 46 C5 00 5C A9 A9 4E AA 4F 4D 19 00 24 40 46 03 19 18 68 59 68 2A 68 6B 68 ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 08 34 06 1C 0F 1C 08 3D 54 45 EB D1 59 46 08 31 01 22 00 9B 8B 46 91 44 08 39 C0 C1 99 45 D6 D1 06 9A 93 46 5C 46 07 98 E3 00 C3 18 1E 68 5F 68 00 2C 27 DD 01 3C E4 00 0A A9 84 AD 04 19 8A 46 92 4A 93 4B 30 1C 39 1C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8F 4A 90 4B 00 90 01 91 ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? ?? ?? ?? ?? 22 68 63 68 01 C5 00 98 01 99 ?? ?? ?? ?? 08 3C 06 1C 0F 1C 54 45 DD D1 30 1C 39 1C 05 9A ?? ?? ?? ?? 83 4A 83 4B 04 1C 0D 1C ?? ?? ?? ?? ?? ?? ?? ?? 81 4A 81 4B ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 0D 1C 04 1C ?? ?? ?? ?? 07 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 05 9A 05 1C 0E 1C 00 2A 00 DC 06 E1 5B 46 01 3B 9B 00 84 AC E2 58 05 98 18 21 09 1A 10 1C 08 41 3F 18 88 40 11 1A 05 9A E1 50 17 23 9B 1A 19 41 02 91 02 9A 00 2A 33 DD 5B 46 01 37 00 2B 00 DC C8 E2 5C 46 A1 00 84 AB 80 20 59 18 00 24 40 04 07 E0 00 2A 02 D0 82 1A 1A 60 01 24 04 33 8B 42 09 D0 1A 68 00 2C F4 D0 5D 4C A2 1A 1A 60 04 33 01 24 8B 42 F5 D1 05 98 00 28 0D DD 01 28 00 D1 D6 E0 02 28 08 D1 5B 46 01 3B 9B 00 84 AA D1 58 54 4A 84 A8 0A 40 C2 50 02 99 02 29 00 D1 A3 E0 28 1C 31 1C 44 4A 45 4B ?? ?? ?? ?? 00 28 00 D0 B5 E1 5C 46 06 9A 01 3C A2 42 0E DC 84 A8 A5 00 92 00 43 19 83 A8 80 18 00 22 19 68 04 3B 0A 43 83 42 FA D1 00 2A 00 D0 C3 E0 06 9B 01 3B 9B 00 84 A9 CB 58 00 2B 00 D0 72 E2 06 9B 02 3B 9B 00 84 AA D3 18 01 21 1A 68 01 31 04 3B 00 2A FA D0 5A 46 59 44 01 32 0A 91 8A 42 4A DC 0B 9B 01 33 5B 44 09 98 A2 9C 9B 00 E4 18 03 1C 07 98 5B 44 D2 00 D9 00 82 18 A1 46 5C AC 64 18 02 92 0A 99 09 9A 89 18 00 94 D2 00 04 91 9B 46 92 46 4B 46 18 68 ?? ?? ?? ?? 00 9C 20 60 61 60 03 98 00 28 2A DB 59 46 CD 00 5C AA 17 4E 18 4F 55 19 00 24 40 46 03 19 18 68 59 68 2A 68 6B 68 ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 08 34 06 1C 0F 1C 08 3D 54 45 EB D1 02 99 00 9B C0 C1 01 24 04 98 04 22 08 33 A3 44 02 91 91 44 00 93 83 45 CD D1 0A 99 8B 46 D7 E6 03 4E 04 4F EC E7 C0 46 A0 FD FF FF ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 70 3E 00 00 00 00 00 00 70 C1 00 00 00 00 00 00 C0 3F 00 00 00 00 00 00 20 C0 00 00 00 00 FF FF FF 00 FF FF 3F 00 2A 1C 33 1C AB 49 AA 48 ?? ?? ?? ?? 05 1C 0E 1C 00 2C 00 D1 50 E7 05 9A A6 49 A5 48 ?? ?? ?? ?? 02 1C 0B 1C 28 1C 31 1C ?? ?? ?? ?? 05 1C 0E 1C 42 E7 05 9B 00 2B 11 D1 5B 46 01 3B 9B 00 84 AC E3 58 DB 15 02 93 00 E7 5B 46 01 3B 9B 00 84 AA D1 58 99 4A 84 A8 0A 40 C2 50 29 E7 97 4A 98 4B ?? ?? ?? ?? 00 28 05 DA 00 20 02 90 24 E7 95 4E 95 4F 71 E6 02 21 02 91 EA E6 05 98 84 A9 4B 59 18 38 04 97 05 90 00 2B 00 D0 FC E1 63 1E 84 AA 9B 00 D3 18 05 9A 21 1C 18 68 01 39 18 3A 04 3B 00 28 F9 D0 05 92 8B 46 82 49 81 48 05 9A ?? ?? ?? ?? 5C 46 06 1C 0F 1C 00 2C 5B DB 07 99 A5 00 84 A8 E4 00 0A AA 45 19 0C 19 90 46 28 68 ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 7C 4A 7C 4B 20 60 61 60 30 1C 39 1C ?? ?? ?? ?? 08 3C 06 1C 0F 1C 04 3D 44 45 EA D1 77 48 01 23 9A 46 DA 44 81 46 10 20 51 46 81 44 06 98 34 AC 03 91 00 27 A2 46 80 46 5B 46 44 46 DE 1B 00 2C 00 DA 77 E0 00 2F 70 DB 68 4B 68 4C 07 9A F6 00 00 93 01 94 4D 46 96 19 00 24 03 E0 08 35 08 36 BC 42 10 DC 32 68 73 68 28 68 69 68 ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 01 34 00 90 01 91 A0 45 EA DA FB 00 00 99 01 9A 53 44 19 60 5A 60 03 9A 01 37 97 42 CE D1 A1 9C 02 2C 4E DC 00 2C 00 DC 5F E1 5B 46 00 2B 00 DA 56 E1 34 A9 5A 46 88 46 D4 00 00 23 44 44 32 AD 00 26 18 1C 31 1C 22 68 63 68 ?? ?? ?? ?? 08 3C 0E 1C AC 42 F6 D1 03 1C 02 9C 00 2C 00 D1 1C E1 80 21 09 06 58 18 08 9C 01 1C 32 1C 21 60 62 60 34 98 35 99 1A 1C 33 1C ?? ?? ?? ?? 5A 46 00 2A 09 DD 44 46 D5 00 65 19 A2 68 E3 68 08 34 ?? ?? ?? ?? AC 42 F8 D1 02 9B 00 2B 02 D0 80 24 24 06 00 19 03 1C 08 98 0C 1C 83 60 C4 60 0C E0 2F 49 30 4A 00 91 01 92 A8 E7 2D 48 2D 49 00 90 01 91 A3 E7 A1 98 03 28 64 D0 98 23 04 9C 9B 00 9D 44 07 20 20 40 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 05 9B 28 1C 5A 42 31 1C 04 97 ?? ?? ?? ?? 24 4A 25 4B 04 1C 0D 1C ?? ?? ?? ?? 00 28 00 DA D1 E0 1D 4A 1D 4B 20 1C 29 1C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 5B 46 9B 00 98 46 1B 4A 1C 4B 06 1C 0F 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? ?? ?? ?? ?? 01 22 84 AC 41 46 93 44 05 9B 60 50 58 46 18 33 84 00 39 1C 30 1C 05 93 ?? ?? ?? ?? 84 A9 08 51 FC E6 C0 46 00 00 F0 3F 00 00 00 00 FF FF 7F 00 00 00 E0 3F 00 00 00 00 00 00 00 00 00 00 00 00 00 00 70 3E 00 00 00 00 ?? ?? ?? ?? 00 00 70 41 00 00 00 00 00 00 70 C1 00 00 00 00 59 46 00 29 00 DC 9D E0 5A 46 34 A9 D2 00 0B 1C 92 46 53 44 5C 46 88 46 01 3C 18 68 59 68 E4 00 00 90 01 91 44 44 32 A9 89 46 25 1C 00 9A 01 9B 28 68 69 68 ?? ?? ?? ?? 06 1C 0F 1C 32 1C 28 68 69 68 3B 1C ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 2E 60 6F 60 A8 60 E9 60 08 3D 00 96 01 97 4D 45 E4 D1 5A 46 01 2A 6F DD 43 46 53 44 19 68 5A 68 00 91 01 92 22 68 63 68 00 98 01 99 ?? ?? ?? ?? 05 1C 0E 1C 2A 1C 20 68 61 68 33 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 25 60 66 60 A0 60 E1 60 08 3C 00 95 01 96 A0 45 E2 D1 44 46 45 46 54 44 08 35 00 20 00 21 22 68 63 68 08 3C ?? ?? ?? ?? AC 42 F8 D1 02 9B 00 2B 2A D0 34 9B 80 22 08 9C 12 06 9B 18 23 60 42 46 53 68 63 60 80 24 93 68 24 06 08 9A 1B 19 93 60 44 46 E3 68 D3 60 80 22 08 9B 12 06 80 18 18 61 59 61 1A E7 01 21 95 E5 00 24 4E E5 18 1C E3 E6 00 23 0B 93 5C E4 5A 46 20 1C 29 1C 96 00 ?? ?? ?? ?? 84 AB 98 51 4D E6 34 9B 35 9C 08 9A 13 60 54 60 42 46 93 68 D4 68 08 9A 93 60 D4 60 03 1C 0C 1C 13 61 54 61 F8 E6 34 AA 90 46 00 20 00 21 BC E7 34 AC 00 23 00 26 A0 46 B6 E6 00 2C 00 D0 EB E6 58 46 00 28 19 DB 59 46 CB 00 34 AC E4 18 32 AD 00 20 00 21 22 68 63 68 08 3C ?? ?? ?? ?? AC 42 F8 D1 02 9A 00 2A 02 D0 80 23 1B 06 C0 18 03 1C 08 98 0C 1C 03 60 44 60 CE E6 00 20 00 21 F0 E7 A3 46 0E E6 68 46 30 30 07 90 6C E4 }
	condition:
		$1
}

rule file_118_0_1 {
	meta:
		name = "__ieee754_pow"
		size = 2916
		refs = "005c nan 00c6 fabs 0102 __subdf3 010a __divdf3 0162 __muldf3 02a2 __adddf3 04be __floatsidf 0654 __gtdf2 07ea __ieee754_sqrt 0840 __gedf2 0b14 scalbn"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 14 1C 81 4A 07 1C 1D 1C 81 46 8F B0 20 1C 0E 1C 8B 46 2B 1C A2 46 10 40 02 90 0C D1 00 2D 0A D1 7A 4C 00 25 0F B0 29 1C 20 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 74 4A 49 46 11 40 74 4A 88 46 90 45 0A DD 73 4A 13 1C 43 44 00 2B 5C D0 72 48 ?? ?? ?? ?? 04 1C 0D 1C E4 E7 70 48 02 1C 42 44 51 42 51 41 04 91 00 29 02 D0 5A 46 00 2A E9 D1 67 4A 02 98 90 42 E5 DC 68 49 42 18 51 42 4A 41 00 2A 01 D0 00 2B DD D1 48 46 00 28 46 DB 00 20 06 90 00 2B 0F D1 00 2A 62 D1 5C 4B 02 98 98 42 00 D1 8C E0 80 23 DB 05 9A 45 00 D1 9D E3 5C 4B 9A 45 00 D1 8D E3 38 1C 31 1C ?? ?? ?? ?? 03 1C 58 46 0A 1C 00 28 08 D1 41 46 00 29 5C D0 04 98 00 28 59 D1 4D 49 88 45 56 D0 48 46 C1 0F 01 39 89 46 06 99 00 29 20 D1 48 46 00 28 1D D1 38 1C 31 1C 3A 1C 33 1C ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? 04 1C 0D 1C 8D E7 5B 46 00 2B 00 D1 87 E7 41 48 ?? ?? ?? ?? 04 1C 0D 1C 83 E7 41 49 02 98 88 42 54 DD 02 21 06 91 B3 E7 3F 49 02 9E 8E 42 00 DC 85 E0 3D 49 8E 42 01 DC 00 F0 C6 FB 3C 4B 98 45 01 DC 00 F0 14 FC 50 46 00 28 19 DD 39 48 39 49 02 1C 0B 1C ?? ?? ?? ?? 04 1C 0D 1C 61 E7 2C 49 0B 1C 43 44 00 2B 03 D1 5A 46 00 2A 00 D1 56 E7 2F 4B 98 45 00 DC 8C E3 53 46 00 2B 00 DB 50 E7 00 24 00 25 4D E7 51 46 00 29 01 DA 00 F0 A6 FB 1C 1C 15 1C 4A 46 00 2A 00 DB 42 E7 06 9B 00 2B 01 D0 00 F0 DA FB 1A 4E 33 1C 43 44 00 2B 00 D0 37 E7 20 1C 29 1C 22 1C 2B 1C 9B E7 51 46 00 29 01 DA 00 F0 A4 FB 3C 1C 35 1C 2A E7 18 49 02 98 88 42 00 DC 5A E7 18 49 00 15 40 18 14 28 01 DC 00 F0 AA FB 34 21 09 1A 18 1C C8 40 06 90 88 40 84 46 9C 45 00 D0 49 E7 06 98 01 21 08 40 02 21 09 1A 06 91 44 E7 FF FF FF 7F 00 00 F0 3F 00 00 F0 7F 00 00 10 C0 ?? ?? ?? ?? 00 00 10 80 00 00 E0 3F FF FF 3F 43 00 00 E0 41 00 00 F0 43 FF FF EF 3F 3C E4 37 7E 9C 75 00 88 01 FC FF FF DC 49 88 45 00 DC 36 E3 DB 49 46 46 30 15 40 18 D8 49 0E 90 D9 48 31 40 08 43 82 46 D8 48 81 42 00 DD 20 E3 80 27 38 03 80 46 00 21 D5 4B C9 00 5B 18 9B 46 17 1C 56 46 11 1C 50 46 1A 68 5B 68 00 96 01 97 ?? ?? ?? ?? 5F 46 3A 68 7B 68 08 90 09 91 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C CA 48 CA 49 ?? ?? ?? ?? 0C 90 0D 91 0C 9A 0D 9B 08 98 09 99 ?? ?? ?? ?? 04 90 05 91 80 21 02 1C 00 23 70 10 89 05 02 92 03 93 01 43 C1 4A C1 4B 40 46 0A 18 02 98 03 99 16 1C 1F 1C ?? ?? ?? ?? 02 1C 0B 1C 08 98 09 99 ?? ?? ?? ?? 08 90 09 91 30 1C 5E 46 32 68 73 68 39 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 02 1C 0B 1C 08 98 09 99 ?? ?? ?? ?? 0C 9A 0D 9B ?? ?? ?? ?? 0A 90 0B 91 04 98 05 99 02 1C 0B 1C ?? ?? ?? ?? 06 1C 0F 1C 32 1C 3B 1C ?? ?? ?? ?? A4 4A A5 4B 08 90 09 91 30 1C 39 1C ?? ?? ?? ?? A2 4A A3 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? A0 4A A1 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 9E 4A 9F 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 9C 4A 9D 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 9A 4A 9B 4B ?? ?? ?? ?? 02 1C 0B 1C 08 98 09 99 ?? ?? ?? ?? 04 9A 05 9B 06 1C 0F 1C 02 98 03 99 ?? ?? ?? ?? 0A 9A 0B 9B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 08 90 09 91 02 98 03 99 02 1C 0B 1C ?? ?? ?? ?? 8B 4A 8C 4B 0C 90 0D 91 ?? ?? ?? ?? 08 9A 09 9B ?? ?? ?? ?? 00 27 06 1C 32 1C 02 98 03 99 3B 1C ?? ?? ?? ?? 32 1C 3B 1C 02 90 03 91 0A 98 0B 99 ?? ?? ?? ?? 7E 4A 7F 4B 0A 90 0B 91 30 1C 39 1C ?? ?? ?? ?? 0C 9A 0D 9B ?? ?? ?? ?? 02 1C 0B 1C 08 98 09 99 ?? ?? ?? ?? 04 9A 05 9B ?? ?? ?? ?? 02 1C 0B 1C 0A 98 0B 99 ?? ?? ?? ?? 04 90 05 91 04 9A 05 9B 02 98 03 99 ?? ?? ?? ?? 00 27 39 1C 6D 4A 6E 4B 06 1C ?? ?? ?? ?? 6D 4A 6D 4B 0A 90 0B 91 30 1C 39 1C ?? ?? ?? ?? 02 9A 03 9B 08 90 09 91 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? 64 4A 64 4B ?? ?? ?? ?? 5F 46 02 1C 0B 1C 08 98 09 99 ?? ?? ?? ?? 3A 69 7B 69 ?? ?? ?? ?? 04 90 05 91 0E 98 ?? ?? ?? ?? 08 90 09 91 59 46 08 6A 49 6A 04 9A 05 9B 02 90 03 91 0A 98 0B 99 ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 08 9A 09 9B ?? ?? ?? ?? 00 27 08 9A 09 9B 39 1C 06 1C ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 0A 9A 0B 9B ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? 06 9A 02 90 03 91 01 2A 03 D1 4B 46 00 2B 00 D1 70 E1 2A 48 2B 49 06 90 07 91 22 1C 00 23 20 1C 29 1C 04 92 05 93 ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 02 9A 03 9B 0A 90 0B 91 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 0A 98 0B 99 ?? ?? ?? ?? 32 1C 02 90 03 91 3B 1C 04 98 05 99 ?? ?? ?? ?? 04 1C 0D 1C 22 1C 2B 1C 02 98 03 99 ?? ?? ?? ?? 0B 1C 02 1C 16 1C 1A 1C 29 4B 04 90 05 91 01 1C 9E 42 00 DC 3C E1 27 4F F3 19 00 2B 00 D0 AD E1 00 2A 00 D0 AA E1 24 4A 24 4B 02 98 03 99 ?? ?? ?? ?? 22 1C 0A 90 0B 91 2B 1C 41 E0 FF FF 0F 00 01 FC FF FF 00 00 F0 3F 8E 98 03 00 ?? ?? ?? ?? 00 00 F0 3F 00 00 00 00 00 00 00 00 00 00 00 00 28 7E CA 3F EF 4E 45 4A 4A 86 CD 3F 65 DB C9 93 60 74 D1 3F 01 41 1D A9 55 55 D5 3F 4D 26 8F 51 B6 6D DB 3F FF AB 6F DB 33 33 E3 3F 03 33 33 33 00 00 08 40 00 00 00 00 09 C7 EE 3F 00 00 00 E0 E0 2F 3E BE F5 01 5B 14 09 C7 EE 3F FD 03 3A DC FF FF 8F 40 00 00 70 BF 47 15 97 3C FE 82 2B 65 04 98 05 99 ?? ?? ?? ?? 02 1C 0B 1C 0A 98 0B 99 ?? ?? ?? ?? 00 28 00 DD 50 E1 D9 4F 37 40 D9 4B 9F 42 00 DD EF E0 00 21 8A 46 88 46 22 1C 2B 1C 02 98 03 99 ?? ?? ?? ?? 00 27 D3 4A D3 4B 39 1C 06 1C ?? ?? ?? ?? 22 1C 04 90 05 91 2B 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? CB 4A CB 4B ?? ?? ?? ?? CB 4A CB 4B 04 1C 0D 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 06 1C 0F 1C 32 1C 3B 1C 04 98 05 99 ?? ?? ?? ?? 04 9A 05 9B 04 1C 0D 1C ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 22 1C 02 90 03 91 2B 1C 20 1C 29 1C ?? ?? ?? ?? B8 4A B8 4B 06 1C 0F 1C ?? ?? ?? ?? B7 4A B7 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? B5 4A B5 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? B3 4A B3 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? B1 4A B1 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 06 1C 0F 1C 32 1C 3B 1C 20 1C 29 1C ?? ?? ?? ?? A8 4A A8 4B 04 90 05 91 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? 02 9A 03 9B 06 1C 0F 1C 20 1C 29 1C ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 02 1C 0B 1C 97 48 97 49 ?? ?? ?? ?? 82 44 52 46 13 15 00 2B 00 DC A3 E1 0B 1C 52 46 06 98 07 99 ?? ?? ?? ?? 04 1C 0D 1C FF F7 29 FC 4A 46 00 2A 00 DA 6D E4 38 1C 31 1C ?? ?? ?? ?? 04 1C 0D 1C FF F7 1D FC 38 1C 31 1C 3A 1C 33 1C ?? ?? ?? ?? 04 1C 0D 1C FF F7 13 FC 84 49 84 4A 06 91 07 92 8D E6 6B 4F 83 4B 07 40 9F 42 00 DC 20 E7 81 48 09 18 00 29 00 D0 B9 E0 00 2A 00 D0 B6 E0 22 1C 2B 1C 04 98 05 99 ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 00 28 00 DB A9 E0 78 4A 80 21 38 15 49 03 80 18 0B 1C 03 41 98 19 43 00 74 4F 80 46 5B 0D 74 48 FF 18 81 46 73 4A 74 4B 38 41 42 46 BA 46 82 43 4F 46 40 46 38 40 01 43 57 46 14 20 C0 1B 01 41 88 46 00 2E 00 DA 3F E1 20 1C 29 1C ?? ?? ?? ?? 04 1C 40 46 00 05 0D 1C 82 46 E7 E6 56 46 00 2E 00 DB 72 E4 80 27 3F 06 E4 19 FF F7 BF FB 63 48 81 42 68 DC C0 21 0E 03 B0 46 01 21 DA E4 18 1C 11 1C 5F 4A 5F 4B ?? ?? ?? ?? 0A 1C 80 46 5E 49 BF E4 5E 49 88 45 29 DC 51 46 00 29 01 DB FF F7 54 FC FF F7 38 FC 15 1C 49 48 4A 49 1A 1C 2B 1C ?? ?? ?? ?? 04 1C 0D 1C FF F7 51 FC 54 4A 55 4B 06 98 07 99 ?? ?? ?? ?? 51 4A 52 4B ?? ?? ?? ?? 04 1C 0D 1C FF F7 8A FB 3D 48 3E 49 3A 1C 33 1C ?? ?? ?? ?? 04 1C 0D 1C FF F7 80 FB 4A 49 88 45 00 DC 99 E0 52 46 00 2A 01 DD FF F7 0C FC FF F7 24 FC 00 2B 37 D1 14 23 18 1A 02 9B 03 41 19 1C 81 40 08 1C 02 99 88 42 00 D1 DE E0 00 23 06 93 FF F7 9D FB 06 9F 01 2F 01 D0 FF F7 5F FB 80 20 00 06 24 18 FF F7 5A FB 57 46 00 2F 01 DB FF F7 04 FC FF F7 E8 FB 0E 9F 80 21 34 48 0E 03 01 37 0E 97 82 44 B0 46 00 21 6C E4 31 4A 31 4B 06 98 07 99 ?? ?? ?? ?? 2E 4A 2E 4B ?? ?? ?? ?? 04 1C 0D 1C FF F7 3B FB 00 23 06 93 FF F7 80 FB C0 46 FF FF FF 7F 00 00 E0 3F 43 2E E6 3F 00 00 00 00 42 2E E6 3F EF 39 FA FE 61 5C 20 BE 39 6C A8 0C 69 37 66 3E D0 A4 BE 72 41 BD BB 3E F1 6B D2 C5 6A 56 11 3F 2C DE 25 AF 6C C1 66 3F 93 BD BE 16 55 55 C5 3F 3E 55 55 55 00 00 00 40 00 00 00 00 00 00 F0 3F 00 00 00 00 00 00 F0 BF 00 00 00 00 FF CB 90 40 00 34 6F 3F 02 FC FF FF 01 FC FF FF FF FF 0F 00 00 00 00 00 00 00 00 00 79 B6 0B 00 00 00 40 43 00 00 00 00 CC FB FF FF FE FF EF 3F 3C E4 37 7E 9C 75 00 88 00 00 F0 3F 00 00 F0 FF 1F 6E A5 01 59 F3 F8 C2 18 1C 11 1C 2F 4B 2E 4A ?? ?? ?? ?? 2E 4A 2F 4B 06 1C 0F 1C ?? ?? ?? ?? 2D 4A 2E 4B 02 90 03 91 30 1C 39 1C ?? ?? ?? ?? 32 1C 04 90 05 91 3B 1C 30 1C 39 1C ?? ?? ?? ?? 27 4A 28 4B 0A 90 0B 91 30 1C 39 1C ?? ?? ?? ?? 25 4A 26 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 02 1C 0B 1C 22 48 23 49 ?? ?? ?? ?? 02 1C 0B 1C 0A 98 0B 99 ?? ?? ?? ?? 1F 4A 20 4B ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? 04 90 05 91 04 9A 05 9B 02 98 03 99 ?? ?? ?? ?? 00 27 06 1C 39 1C 02 9A 03 9B FC E4 49 42 88 46 BC E6 42 46 ?? ?? ?? ?? 02 1C 0B 1C 57 E6 01 21 0B 40 02 21 C9 1A 06 91 FF F7 BB FA 00 00 F0 3F 00 00 00 00 47 15 F7 3F 00 00 00 60 0B AE 54 3E 44 DF 5D F8 00 00 D0 BF 00 00 00 00 55 55 D5 3F 55 55 55 55 00 00 E0 3F 00 00 00 00 47 15 F7 BF FE 82 2B 65 }
	condition:
		$1
}

rule file_119_0_1 {
	meta:
		name = "truncf"
		size = 36
	strings:
		$1 = { 42 00 12 0E 7F 3A 03 1C 16 2A 08 DC 80 20 00 06 18 40 00 2A 03 DB 02 49 11 41 8B 43 18 43 70 47 FF FF 7F 00 }
	condition:
		$1
}

rule file_120_0_1 {
	meta:
		name = "rintf"
		size = 180
		refs = "0042 __addsf3 004c __subsf3"
	strings:
		$1 = { 70 B5 27 4C 02 1C 22 40 D6 0D 7F 3E 81 B0 01 1C 16 2E 21 DC 00 2A 1C D0 03 1C C5 0F 00 2E 23 DB 20 4A 32 41 02 42 14 D0 52 08 02 42 04 D0 80 21 49 03 93 43 31 41 0B 43 1B 4A AD 00 54 59 19 1C 20 1C ?? ?? ?? ?? 00 90 21 1C 00 98 ?? ?? ?? ?? 01 1C 01 B0 08 1C 70 BD 14 4B 9A 42 F9 D9 08 1C ?? ?? ?? ?? 01 1C F4 E7 0E 4B 0F 49 AA 00 03 40 8E 58 59 42 0B 43 80 21 5B 0A C9 03 19 40 0C 4B 18 40 01 43 30 1C ?? ?? ?? ?? 00 90 31 1C 00 98 ?? ?? ?? ?? 04 40 ED 07 21 1C 29 43 D9 E7 C0 46 FF FF FF 7F FF FF 7F 00 ?? ?? ?? ?? FF FF 7F 7F 00 00 F0 FF }
	condition:
		$1
}

rule file_121_0_1 {
	meta:
		name = "exp10f"
		size = 16
		refs = "0006 powf"
		altNames = "pow10f"
	strings:
		$1 = { 00 B5 01 1C 01 48 ?? ?? ?? ?? 00 BD 00 00 20 41 }
	condition:
		$1
}

rule file_123_0_1 {
	meta:
		name = "__ieee754_remainder"
		size = 404
		refs = "002e __muldf3 0036 __divdf3 0068 __adddf3 0074 __ieee754_fmod 0084 fabs 00b2 __ltdf2 00c2 __subdf3 00da __ledf2 0138 __gtdf2 0154 __gedf2"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 82 B0 0D 1C 00 91 57 49 1F 1C 16 1C 04 1C 82 46 32 1C 3B 1C B9 46 31 40 88 46 0F D1 00 2F 0D D1 29 1C ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? 02 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 49 4B 50 46 18 40 49 4B 83 46 9B 45 57 DC 98 45 4D DC 47 4B 98 45 0D DC 32 1C 3B 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C C3 45 47 D0 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C 30 1C 39 1C ?? ?? ?? ?? 39 4B 06 1C 0F 1C 98 45 42 DC 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 00 28 13 DA 20 1C 29 1C 32 1C 3B 1C ?? ?? ?? ?? 04 1C 0D 1C 22 1C 2B 1C ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 00 28 3C DD 80 23 50 46 1B 06 03 40 21 1C 1C 1C 4C 40 20 1C 29 1C A1 E7 22 4A 13 1C 43 44 00 2B 02 D1 4B 46 00 2B BA D0 20 1C 29 1C 32 1C 3B 1C 8E E7 00 98 48 45 B4 D1 20 1C 29 1C 1A 4A 1A 4B ?? ?? ?? ?? 8A E7 19 4A 1A 4B ?? ?? ?? ?? 00 90 01 91 00 9A 01 9B 20 1C 29 1C ?? ?? ?? ?? 00 28 D0 DD 20 1C 29 1C 32 1C 3B 1C ?? ?? ?? ?? 00 9A 01 9B 04 1C 0D 1C ?? ?? ?? ?? 00 28 C2 DB 20 1C 29 1C 32 1C 3B 1C ?? ?? ?? ?? 04 1C 0D 1C B9 E7 C0 46 FF FF FF 7F FF FF EF 7F FF FF DF 7F FF FF 1F 00 00 00 10 80 00 00 00 00 00 00 00 00 00 00 E0 3F 00 00 00 00 }
	condition:
		$1
}

rule file_124_0_1 {
	meta:
		name = "__ieee754_lgammaf_r"
		size = 2036
		refs = "0062 __subsf3 006e __mulsf3 0088 __addsf3 0130 __divsf3 014e __ieee754_logf 018e __fixsfsi 0194 __floatsisf 027a floorf 0282 __nesf2 02be __kernel_sinf 02ce __eqsf2 02e0 fabsf 02f6 __ltsf2 06ca __kernel_cosf"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 01 23 DB 4C 98 46 0B 60 DA 4B 04 40 05 1C 0E 1C 07 1C 9C 42 00 DD 8F E0 00 2C 00 D1 82 E0 D6 4B 9C 42 00 DC 8D E0 00 28 78 DB 80 23 DB 05 9C 42 00 D1 8E E0 FE 23 9B 05 9C 42 00 D1 89 E0 CF 4B 9C 42 00 DD 9A E0 CE 4B 9C 42 00 DC B2 E2 CD 4B 9C 42 00 DC 30 E2 29 1C CB 48 ?? ?? ?? ?? CB 4E 05 1C 29 1C 28 1C ?? ?? ?? ?? C9 49 04 1C 28 1C ?? ?? ?? ?? C7 49 80 46 20 1C ?? ?? ?? ?? C6 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? C4 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? C2 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? C0 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? BE 49 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? BB 49 05 1C 20 1C ?? ?? ?? ?? BA 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? B8 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? B6 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? B4 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? B2 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 01 1C 40 46 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 04 1C 1B E0 A9 4B 9C 42 00 DC 9D E0 A8 48 99 49 ?? ?? ?? ?? 04 1C 20 1C 0C BC 90 46 9A 46 F0 BD 29 1C ?? ?? ?? ?? 04 1C F5 E7 00 28 0E DB ?? ?? ?? ?? 80 23 1B 06 C4 18 ED E7 8E 4C 00 2F EA DA 21 1C 50 46 ?? ?? ?? ?? 04 1C E4 E7 01 23 5B 42 0B 60 80 23 1B 06 C0 18 ?? ?? ?? ?? 80 23 1B 06 C4 18 D8 E7 93 4B 9C 42 00 DD 4F E1 28 1C ?? ?? ?? ?? 06 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 8D 49 05 1C ?? ?? ?? ?? 8C 49 80 46 28 1C ?? ?? ?? ?? 8B 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 89 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 87 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 85 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 83 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 70 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 7E 49 04 1C 28 1C ?? ?? ?? ?? 7C 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 7A 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 78 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 76 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 74 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 63 49 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 01 1C 40 46 ?? ?? ?? ?? 03 3E 04 1C 04 2E 00 D9 7D E7 6A 4B B6 00 9B 59 9F 46 69 4B 9C 42 00 DC C0 E1 80 23 1B 06 1B 18 18 1C 9A 46 ?? ?? ?? ?? 01 1C 50 46 ?? ?? ?? ?? 00 28 00 D0 3C E2 50 46 61 49 ?? ?? ?? ?? 43 46 03 40 18 1C 98 46 ?? ?? ?? ?? 43 46 82 46 98 00 06 28 00 D8 FD E1 50 46 38 49 ?? ?? ?? ?? 58 49 ?? ?? ?? ?? 36 49 00 22 ?? ?? ?? ?? 80 23 1B 06 1B 18 98 46 40 46 31 49 ?? ?? ?? ?? 00 28 00 D1 29 E7 41 46 28 1C ?? ?? ?? ?? ?? ?? ?? ?? 01 1C 4C 48 ?? ?? ?? ?? ?? ?? ?? ?? 28 49 82 46 40 46 ?? ?? ?? ?? 00 28 00 DB 00 E2 01 23 5B 42 33 60 80 23 1B 06 ED 18 91 E6 30 4E 42 49 28 1C ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 06 1C 3F 49 28 1C ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 06 1C 3C 49 28 1C ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 06 1C 13 49 28 1C ?? ?? ?? ?? 31 1C ?? ?? ?? ?? ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 04 1C FE E6 1C 4E DE E7 1B 4E E4 E7 1A 4E EA E7 28 1C 2E 49 ?? ?? ?? ?? 06 1C CC E7 C0 46 FF FF FF 7F FF FF 7F 7F FF FF 7F 1C FF FF FF 3F 66 66 66 3F 17 A6 DD 3F 00 00 00 40 00 00 00 00 00 00 00 BF A2 83 D3 37 67 97 67 39 A1 54 9C 3A 7E 02 F2 3B 01 F0 89 3D 3F 23 9E 3D 75 2C 3C 38 45 84 E2 38 34 B6 05 3A C6 6E 3D 3B 15 99 A8 3C 66 1A A5 3E FF FF FF 4A 00 00 80 3F FF FF FF 40 00 00 00 3F 67 FF 05 38 B4 35 F1 3A E4 40 DA 3C E6 DC 15 3E 7A CC A6 3E 5A 24 5C 3E BD D7 F5 36 D6 EE 4B 3A 54 BF 98 3C 6E 0F 30 3E C5 D0 38 3F 3B 2D B2 3F ?? ?? ?? ?? FF FF 7F 3E 00 00 00 4B DB 0F 49 40 00 00 A0 40 00 00 80 40 00 00 40 40 00 00 C0 40 C0 4B 9C 42 00 DD D3 E0 28 1C ?? ?? ?? ?? 29 1C 80 46 BD 48 ?? ?? ?? ?? 06 1C 31 1C ?? ?? ?? ?? BA 49 04 1C 28 1C ?? ?? ?? ?? B7 49 05 1C 40 46 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? B4 49 05 1C 20 1C ?? ?? ?? ?? B3 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? B1 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? AF 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? AD 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? AB 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? A9 49 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 04 1C 4D E6 A5 4B 9C 42 00 DC 9D E0 28 1C A4 49 ?? ?? ?? ?? A3 4E 05 1C 29 1C 28 1C ?? ?? ?? ?? 29 1C 80 46 ?? ?? ?? ?? 9F 49 04 1C ?? ?? ?? ?? 9E 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 9C 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 9A 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 98 49 ?? ?? ?? ?? 01 1C 40 46 ?? ?? ?? ?? 96 49 80 46 20 1C ?? ?? ?? ?? 94 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 92 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 90 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 8E 49 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 8C 49 05 1C 20 1C ?? ?? ?? ?? 8A 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 88 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 86 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 84 49 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 01 1C 80 48 ?? ?? ?? ?? 01 1C 40 46 ?? ?? ?? ?? 7D 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 04 1C CF E5 28 1C ?? ?? ?? ?? 80 23 1B 06 C6 18 77 4B 9C 42 00 DC 8F E0 29 1C 58 48 ?? ?? ?? ?? 05 1C 46 E5 28 1C ?? ?? ?? ?? 54 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 04 1C B4 E5 6E 49 ?? ?? ?? ?? 59 49 00 22 ?? ?? ?? ?? 80 46 62 E6 28 1C 4B 49 ?? ?? ?? ?? 54 4E 05 1C 28 1C 67 49 ?? ?? ?? ?? 66 49 80 46 28 1C ?? ?? ?? ?? 65 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 63 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 61 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 5F 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 5D 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 5B 49 04 1C 28 1C ?? ?? ?? ?? 59 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 57 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 55 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 53 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 26 49 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 34 E5 4D 4B 80 00 1B 58 9F 46 51 46 20 48 ?? ?? ?? ?? FC E5 51 46 1E 48 ?? ?? ?? ?? 3A 49 ?? ?? ?? ?? 25 49 ?? ?? ?? ?? F8 E5 50 46 EF E5 43 49 50 46 ?? ?? ?? ?? 33 49 ?? ?? ?? ?? 1F 49 ?? ?? ?? ?? 80 23 1B 06 C0 18 E8 E5 3D 4B 9C 42 8C DD 28 1C 3C 49 ?? ?? ?? ?? 05 1C E8 E6 33 68 FE E5 0C 49 50 46 ?? ?? ?? ?? 80 46 ?? ?? ?? ?? 01 1C 40 46 ?? ?? ?? ?? 01 1C ?? ?? ?? ?? 33 49 82 46 ?? ?? ?? ?? ?? ?? ?? ?? BA E5 FF FF 7F 5C 00 00 80 3F 00 00 00 3F E8 C4 D5 BA D2 3D 5B 3A 5C 06 1C 3A FD 0C 50 3A 61 0B 36 3B AB AA AA 3D 1D 7F D6 3E 1F A6 9D 3F C3 16 BB 3F 00 00 00 00 6B 7B A5 39 76 F4 B7 3A 07 E7 C7 3B 47 4D 06 3D 5E B9 F7 3E F7 E9 AF 39 85 30 0D 3A 99 16 14 3B FE FC 28 3C 15 5A 84 3D 27 F9 A3 B9 67 F8 66 3A FE 77 71 3B 3D 37 93 3C 3C 21 17 3E 52 1C E6 31 CD CD F8 3D 1F 4A 3B 3F DB 0F 49 40 00 00 00 BF 5E 3C 5B 3C 78 75 6A 3E B2 4B 7A 3F E7 3A BA 3F F4 00 22 3F 3F 23 9E 3D DB D5 52 3B AF 72 D5 3D DF EF 44 3F 2D 39 08 40 BE 2E 1D 40 ?? ?? ?? ?? 00 00 C0 3F 07 33 6D 3E 0C 5B EC 3E 00 00 80 40 }
	condition:
		$1
}

rule file_125_0_1 {
	meta:
		name = "trunc"
		size = 116
		refs = "0044 __adddf3"
	strings:
		$1 = { F0 B5 46 00 18 4F 76 0D 0B 1C 0D 1C F1 19 02 1C 04 1C 13 29 0E DC 80 23 1B 06 04 1C 1C 40 00 29 1E DB 12 4B 0B 41 98 43 02 1C 22 43 00 23 10 1C 19 1C F0 BD 33 29 0A DD 80 20 C0 00 81 42 F6 D1 10 1C 19 1C ?? ?? ?? ?? 02 1C 0B 1C EF E7 08 49 76 18 01 21 49 42 F1 40 2B 1C 22 1C 8B 43 E6 E7 22 1C 00 23 E3 E7 C0 46 01 FC FF FF FF FF 0F 00 ED FB FF FF }
	condition:
		$1
}

rule file_126_0_1 {
	meta:
		name = "__ieee754_scalb"
		size = 240
		refs = "000a __isnand 001a __muldf3 0030 finite 0040 __gtdf2 0054 __divdf3 005e rint 0066 __nedf2 0086 __ltdf2 0092 __fixdfsi 009c scalbn 00aa __subdf3"
	strings:
		$1 = { F0 B5 04 1C 0D 1C 16 1C 1F 1C ?? ?? ?? ?? 00 28 06 D0 20 1C 29 1C 32 1C 3B 1C ?? ?? ?? ?? F0 BD 30 1C 39 1C ?? ?? ?? ?? 00 28 F2 D1 30 1C 39 1C ?? ?? ?? ?? 00 28 10 D1 30 1C 39 1C 25 4B 24 4A ?? ?? ?? ?? 00 28 E4 DC 20 1C 80 24 24 06 29 1C 32 19 3B 1C ?? ?? ?? ?? E1 E7 30 1C 39 1C ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 00 28 19 D1 30 1C 39 1C 19 4A 19 4B ?? ?? ?? ?? 00 28 22 DC 30 1C 39 1C 17 4A 17 4B ?? ?? ?? ?? 00 28 14 DB 39 1C 30 1C ?? ?? ?? ?? 29 1C 02 1C 20 1C ?? ?? ?? ?? BD E7 32 1C 3B 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? B2 E7 20 1C 29 1C 0A 4A ?? ?? ?? ?? AC E7 20 1C 29 1C 08 4A ?? ?? ?? ?? A6 E7 00 00 00 00 00 00 00 00 00 BD EF 40 00 00 00 00 00 BD EF C0 00 00 00 00 18 02 FF FF E8 FD 00 00 }
	condition:
		$1
}

rule file_127_0_1 {
	meta:
		name = "asinf"
		size = 160
		refs = "0006 __ieee754_asinf 0016 isnanf 0028 fabsf 002e __gtsf2 0042 __extendsfdf2 0052 nan 0062 matherr 0074 __truncdfsf2 007c __errno 0090 __fdlib_version"
	strings:
		$1 = { F0 B5 89 B0 04 1C ?? ?? ?? ?? 21 4E 33 68 05 1C 01 33 05 D0 20 1C ?? ?? ?? ?? 07 1C 00 28 02 D0 09 B0 28 1C F0 BD 20 1C ?? ?? ?? ?? 19 49 ?? ?? ?? ?? 00 28 F4 DD 01 23 00 93 17 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 6D 46 28 61 69 61 A8 60 E9 60 12 48 ?? ?? ?? ?? 33 68 A8 61 E9 61 02 2B 0D D0 68 46 ?? ?? ?? ?? 00 28 08 D0 2B 6A 00 2B 0A D1 A8 69 E9 69 ?? ?? ?? ?? 05 1C D1 E7 ?? ?? ?? ?? 21 23 03 60 F1 E7 ?? ?? ?? ?? 2B 6A 03 60 EF E7 ?? ?? ?? ?? 00 00 80 3F ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_132_0_1 {
	meta:
		name = "acosf"
		size = 160
		refs = "0006 __ieee754_acosf 0016 isnanf 0028 fabsf 002e __gtsf2 0042 __extendsfdf2 0052 nan 0062 matherr 0074 __truncdfsf2 007c __errno 0090 __fdlib_version"
	strings:
		$1 = { F0 B5 89 B0 04 1C ?? ?? ?? ?? 21 4E 33 68 05 1C 01 33 05 D0 20 1C ?? ?? ?? ?? 07 1C 00 28 02 D0 09 B0 28 1C F0 BD 20 1C ?? ?? ?? ?? 19 49 ?? ?? ?? ?? 00 28 F4 DD 01 23 00 93 17 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 6D 46 28 61 69 61 A8 60 E9 60 12 48 ?? ?? ?? ?? 33 68 A8 61 E9 61 02 2B 0D D0 68 46 ?? ?? ?? ?? 00 28 08 D0 2B 6A 00 2B 0A D1 A8 69 E9 69 ?? ?? ?? ?? 05 1C D1 E7 ?? ?? ?? ?? 21 23 03 60 F1 E7 ?? ?? ?? ?? 2B 6A 03 60 EF E7 ?? ?? ?? ?? 00 00 80 3F ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_128_0_1 {
	meta:
		name = "cabs"
		size = 30
		refs = "0016 hypot"
	strings:
		$1 = { 10 B5 84 B0 02 92 03 93 6C 46 00 90 01 91 A2 68 E3 68 00 98 01 99 ?? ?? ?? ?? 04 B0 10 BD }
	condition:
		$1
}

rule file_129_0_1 {
	meta:
		name = "__kernel_tanf"
		size = 672
		refs = "0024 __fixsfsi 0040 __divsf3 0058 __subsf3 006a __addsf3 0076 __mulsf3 01c2 __floatsisf 0222 fabsf"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 8D 4B 93 46 02 1C 1A 40 8C 4B 90 46 81 B0 04 1C 0F 1C 82 46 98 45 11 DC ?? ?? ?? ?? 00 28 22 D1 5B 46 01 33 00 D1 F1 E0 5B 46 01 2B 00 D1 B9 E0 21 1C 83 48 ?? ?? ?? ?? 04 1C B3 E0 81 4B 98 45 11 DD 00 28 00 DA EE E0 21 1C 7F 48 ?? ?? ?? ?? 39 1C 04 1C 7D 48 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 7B 4F 04 1C 21 1C 20 1C ?? ?? ?? ?? 06 1C 31 1C ?? ?? ?? ?? 21 1C 05 1C 30 1C ?? ?? ?? ?? 74 49 81 46 28 1C ?? ?? ?? ?? 73 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 71 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 6F 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 6D 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 6B 49 ?? ?? ?? ?? 6A 49 00 90 28 1C ?? ?? ?? ?? 69 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 67 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 65 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 63 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 61 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 01 1C 00 98 ?? ?? ?? ?? 49 46 ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 57 49 05 1C 48 46 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 06 1C 31 1C 20 1C ?? ?? ?? ?? 40 4B 05 1C 98 45 35 DC 5B 46 01 2B 00 D1 70 E0 4D 4F 03 1C 3B 40 29 1C 39 48 98 46 ?? ?? ?? ?? 03 1C 3B 40 21 1C 05 1C 40 46 1F 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 39 1C 04 1C 40 46 ?? ?? ?? ?? 40 49 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 04 1C 01 B0 20 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 58 46 ?? ?? ?? ?? 29 1C 07 1C 28 1C ?? ?? ?? ?? 39 1C 80 46 28 1C ?? ?? ?? ?? 01 1C 40 46 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 2A 49 ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 52 46 04 1C 02 23 90 17 18 40 01 23 18 1A ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 04 1C CB E7 42 46 00 2A 00 D0 09 E7 20 1C ?? ?? ?? ?? 01 1C 1B 48 ?? ?? ?? ?? 04 1C BE E7 80 23 1B 06 C4 18 CB 18 1F 1C 0A E7 04 1C B6 E7 C0 46 FF FF FF 7F FF FF 7F 31 00 00 80 BF 3F A1 2C 3F DA 0F 49 3F 68 21 22 33 00 00 00 00 5F AE 9B B7 45 F4 A3 38 C8 26 1A 3A 16 69 6B 3B A4 27 B3 3C 89 88 08 3E 84 53 D9 37 7A C0 95 38 B9 37 81 39 48 DE BE 3A 1F 37 11 3C D1 0D 5D 3D AB AA AA 3E 00 F0 FF FF 00 00 80 3F 00 00 00 C0 }
	condition:
		$1
}

rule file_131_0_1 {
	meta:
		name = "__kernel_sin"
		size = 360
		refs = "001a __fixdfsi 002a __muldf3 004e __subdf3 005e __adddf3"
	strings:
		$1 = { F0 B5 88 B0 0D 1C 48 49 02 92 03 93 02 1C 47 4B 0A 40 04 1C 9A 42 04 DC 29 1C ?? ?? ?? ?? 00 28 66 D0 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 22 1C 2B 1C 06 1C 0F 1C ?? ?? ?? ?? 3D 4A 3D 4B 00 90 01 91 30 1C 39 1C ?? ?? ?? ?? 3B 4A 3B 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 39 4A 39 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 37 4A 37 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 35 4A 35 4B ?? ?? ?? ?? 0D 9B 04 90 05 91 00 2B 35 D0 32 4A 33 4B 02 98 03 99 ?? ?? ?? ?? 04 9A 05 9B 06 90 07 91 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 06 98 07 99 ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 26 4A 27 4B 06 1C 0F 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C 08 B0 29 1C 20 1C F0 BD 04 9A 05 9B 30 1C 39 1C ?? ?? ?? ?? 16 4A 17 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C E4 E7 C0 46 FF FF FF 7F FF FF 3F 3E 3A D9 E5 3D 7C D5 CF 5A E6 E5 5A 3E EB 9C 2B 8A E3 1D C7 3E 7D FE B1 57 A0 01 2A 3F D5 61 C1 19 11 11 81 3F A6 F8 10 11 00 00 E0 3F 00 00 00 00 55 55 C5 3F 49 55 55 55 }
	condition:
		$1
}

rule file_133_0_1 {
	meta:
		name = "sincos"
		size = 32
		refs = "000a sin 0016 cos"
	strings:
		$1 = { F0 B5 16 1C 1F 1C 0D 1C 04 1C ?? ?? ?? ?? 30 60 71 60 29 1C 20 1C ?? ?? ?? ?? 38 60 79 60 F0 BD }
	condition:
		$1
}

rule file_134_1_1 {
	meta:
		name = "qone"
		size = 368
		refs = "0036 __muldf3 0042 __divdf3 0056 __adddf3"
	strings:
		$1 = { F0 B5 4F 4A 03 1C 13 40 4E 4A 84 B0 00 90 01 91 93 42 00 DD 8A E0 4C 4A 93 42 00 DD 81 E0 4B 4A 93 42 00 DD 87 E0 4A 4F 3E 1C 20 36 50 37 00 98 01 99 02 1C 0B 1C ?? ?? ?? ?? 02 1C 0B 1C 45 48 45 49 ?? ?? ?? ?? BA 6A FB 6A 0D 1C 04 1C ?? ?? ?? ?? 3A 6A 7B 6A ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? BA 69 FB 69 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 3A 69 7B 69 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? BA 68 FB 68 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 3A 68 7B 68 ?? ?? ?? ?? B2 6A F3 6A 02 90 03 91 29 1C 20 1C ?? ?? ?? ?? 32 6A 73 6A ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? B2 69 F3 69 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 32 69 73 69 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? B2 68 F3 68 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 32 68 73 68 ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 16 4A 16 4B ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 13 4A 13 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 04 B0 F0 BD 10 4F 3E 1C 40 36 70 37 80 E7 0E 4E 0D 4F 60 36 10 37 7B E7 0D 4E 37 1C 30 37 77 E7 C0 46 FF FF FF 7F FF FF 1F 40 8A 2E 12 40 6C DB 06 40 ?? ?? ?? ?? 00 00 F0 3F 00 00 00 00 00 00 D8 3F 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_134_2_1 {
	meta:
		name = "__ieee754_j1"
		size = 736
		refs = "0022 __divdf3 0030 fabs 004e __adddf3 0056 __gtdf2 0066 __muldf3 0088 __subdf3 013a sin 0146 cos 0168 __ieee754_sqrt"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 94 4E 95 4B 06 40 88 B0 04 1C 0D 1C 07 1C 9E 42 0A DD 92 48 92 49 22 1C 2B 1C ?? ?? ?? ?? 08 B0 0C BC 90 46 9A 46 F0 BD ?? ?? ?? ?? 8D 4B 00 90 01 91 9E 42 00 DD 7C E0 8B 4B 9E 42 12 DC 8B 4A 8B 4B 20 1C 29 1C ?? ?? ?? ?? 84 4A 84 4B ?? ?? ?? ?? 00 28 06 DD 20 1C 29 1C 86 4A 86 4B ?? ?? ?? ?? DC E7 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 82 4A 83 4B 06 1C 0F 1C ?? ?? ?? ?? 81 4A 82 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 7F 4A 80 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 7D 4A 7E 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 79 4A 7A 4B 00 90 01 91 30 1C 39 1C ?? ?? ?? ?? 77 4A 78 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 75 4A 76 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 73 4A 74 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 71 4A 72 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 55 4A 56 4B ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 56 4A 57 4B 06 1C 0F 1C 20 1C 29 1C ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 75 E7 ?? ?? ?? ?? 80 46 8A 46 00 98 01 99 ?? ?? ?? ?? 04 1C 0D 1C 2B 1C 40 46 51 46 22 1C ?? ?? ?? ?? 5C 4B 02 90 03 91 9E 42 16 DD 00 98 01 99 ?? ?? ?? ?? 58 4A 59 4B 04 1C 0D 1C 02 98 03 99 ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 00 2F 00 DB 4D E7 80 23 1B 06 C0 18 49 E7 00 98 01 99 02 1C 0B 1C ?? ?? ?? ?? ?? ?? ?? ?? 22 1C 04 90 05 91 2B 1C 40 46 51 46 ?? ?? ?? ?? 49 4A 49 4B ?? ?? ?? ?? 00 28 45 DD 80 23 1B 06 18 1C 22 1C 2B 1C 40 44 51 46 ?? ?? ?? ?? 06 90 07 91 06 9A 07 9B 04 98 05 99 ?? ?? ?? ?? 02 90 03 91 90 23 DB 05 9E 42 BB DC 00 98 01 99 FF F7 AC FD 04 1C 0D 1C 00 98 01 99 FF F7 48 FE 04 90 05 91 00 98 01 99 ?? ?? ?? ?? 22 1C 00 90 01 91 2B 1C 02 98 03 99 ?? ?? ?? ?? 04 9A 05 9B 04 1C 0D 1C 06 98 07 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 25 4A 26 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 9C E7 04 98 05 99 02 9A 03 9B ?? ?? ?? ?? 06 90 07 91 C3 E7 FF FF FF 7F FF FF EF 7F 00 00 F0 3F 00 00 00 00 FF FF FF 3F FF FF 3F 3E 3C E4 37 7E 9C 75 00 88 00 00 E0 3F 00 00 00 00 FA AA 6A 3E D9 0B CA 46 C6 C5 F0 3E 68 96 16 BA 9F 0D 57 3F 61 2C 47 98 00 00 B0 3F 00 00 00 00 CF 2A AB 3D D8 7E B9 CF 88 AC 35 3E 2C FF 7D C9 F8 BF B3 3E 98 84 3F 33 56 5F 28 3F 64 F6 CD B9 0B 9D 93 3F 53 7E 63 12 FF FF DF 7F D7 0D E2 3F 6D 9B 42 50 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_134_3_1 {
	meta:
		name = "__ieee754_y1"
		size = 836
		refs = "0038 __divdf3 005c __muldf3 0064 __adddf3 00a2 __subdf3 013a __ieee754_j1 0146 __ieee754_log 018c sin 0198 cos 01be __ieee754_sqrt 020e __gtdf2"
	strings:
		$1 = { F0 B5 47 46 80 B4 AA 4E AA 4B 06 40 0D 1C 88 B0 04 1C 01 1C 9E 42 1E DC 00 2E 10 D0 00 29 00 DA DC E0 A5 4B 9E 42 00 DD AE E0 A4 4B 9E 42 22 DC 22 1C 2B 1C A2 48 A3 49 ?? ?? ?? ?? 07 E0 00 2D EC D1 A1 48 A1 49 A2 4A A2 4B ?? ?? ?? ?? 08 B0 04 BC 90 46 F0 BD 22 1C 2B 1C 29 1C ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 02 1C 0B 1C 9A 48 9B 49 ?? ?? ?? ?? EB E7 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 97 4A 97 4B 06 1C 0F 1C ?? ?? ?? ?? 96 4A 96 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 94 4A 94 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 92 4A 92 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 90 4A 90 4B ?? ?? ?? ?? 90 4A 90 4B 00 90 01 91 30 1C 39 1C ?? ?? ?? ?? 8E 4A 8E 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 8C 4A 8C 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 8A 4A 8A 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 88 4A 88 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 70 4A 70 4B ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 00 90 01 91 20 1C 29 1C ?? ?? ?? ?? 06 1C 0F 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 22 1C 06 1C 0F 1C 2B 1C 5A 48 5A 49 ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 6F 4A 6F 4B ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 62 E7 20 1C 29 1C ?? ?? ?? ?? 07 1C 88 46 20 1C 29 1C ?? ?? ?? ?? 80 23 00 90 01 91 1B 06 F8 18 41 46 00 9A 01 9B ?? ?? ?? ?? 61 4B 02 90 03 91 9E 42 17 DD 20 1C 29 1C ?? ?? ?? ?? 5E 4A 5E 4B 04 1C 0D 1C 02 98 03 99 ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 38 E7 3C 48 3D 49 02 1C 0B 1C ?? ?? ?? ?? 31 E7 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? ?? ?? ?? ?? 00 9A 01 9B 04 90 05 91 38 1C 41 46 ?? ?? ?? ?? 31 4A 31 4B ?? ?? ?? ?? 00 28 3A DD 04 98 05 99 02 9A 03 9B ?? ?? ?? ?? 06 90 07 91 90 23 DB 05 9E 42 C5 DC 20 1C 29 1C FF F7 1B FC 06 1C 0F 1C 20 1C 29 1C FF F7 B7 FC 00 90 01 91 20 1C 29 1C ?? ?? ?? ?? 32 1C 04 90 05 91 3B 1C 02 98 03 99 ?? ?? ?? ?? 00 9A 01 9B 04 1C 0D 1C 06 98 07 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 30 4A 30 4B ?? ?? ?? ?? 04 9A 05 9B ?? ?? ?? ?? E0 E6 00 9A 01 9B 38 1C 41 46 ?? ?? ?? ?? 06 90 07 91 06 9A 07 9B 04 98 05 99 ?? ?? ?? ?? 02 90 03 91 BB E7 C0 46 FF FF FF 7F FF FF EF 7F FF FF FF 3F 00 00 90 3C 30 5F E4 BF 83 C8 C9 6D 00 00 F0 BF 00 00 00 00 00 00 00 00 00 00 00 00 00 00 F0 3F 00 00 00 00 00 AC 78 BE B8 05 91 56 03 AB F8 3E 8E B8 A6 8F E5 55 5F 3F 0F F5 44 48 C7 D3 A9 3F D1 2C 29 76 66 18 C9 3F 8A BC 3C 14 39 50 B2 3D 2A 77 CA DA 1D BF 3A 3E 86 9A A6 5B 5A C0 B6 3E A6 8C 4E 89 89 8C 2A 3F 64 77 25 6C 0D 65 94 3F F0 A9 4D 3F 30 5F E4 3F 83 C8 C9 6D FF FF DF 7F D7 0D E2 3F 6D 9B 42 50 }
	condition:
		$1
}

rule file_136_0_1 {
	meta:
		name = "cbrtf"
		size = 188
		refs = "0020 __divsi3 002c __mulsf3 0032 __divsf3 003e __addsf3 008a __udivsi3"
	strings:
		$1 = { F0 B5 80 24 24 06 04 40 22 4B 01 1C 60 40 98 42 32 DC 00 28 2E D0 20 4B 06 1C 98 42 31 DD 03 21 ?? ?? ?? ?? 1D 4B C5 18 29 1C 28 1C ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 18 49 ?? ?? ?? ?? 18 49 06 1C ?? ?? ?? ?? 31 1C 07 1C 16 48 ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 01 1C 13 48 ?? ?? ?? ?? 12 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 21 1C 01 43 08 1C F0 BD 08 1C ?? ?? ?? ?? 01 1C F8 E7 0C 49 ?? ?? ?? ?? 03 21 ?? ?? ?? ?? 0A 4B C5 18 C9 E7 FF FF 7F 7F FF FF 7F 00 F2 19 51 2A B0 F8 0A 3F 50 07 B5 3F F1 8E 34 BF DB B6 CD 3F 6E DB B6 3E 00 00 80 4B F2 19 51 26 }
	condition:
		$1
}

rule file_137_0_1 {
	meta:
		name = "__ieee754_lgamma_r"
		size = 3096
		refs = "0058 __subdf3 006e __divdf3 0090 __muldf3 00a6 __ieee754_log 0124 __adddf3 023a floor 024a __nedf2 0278 __kernel_sin 028e __eqdf2 02a4 fabs 02c4 __ltdf2 0398 __fixdfsi 039e __floatsidf 0966 __kernel_cos"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0C 1C 16 1C 01 21 B2 4F 05 1C 31 60 B1 49 2F 40 87 B0 80 46 8F 42 31 DC A2 46 00 2F 1B D0 AE 4B 9F 42 34 DD 41 46 00 29 00 DA EE E0 AB 49 7B 18 00 2B 39 D1 52 46 00 2A 36 D1 00 25 00 24 43 46 00 2B 12 DA 2A 1C 23 1C 03 98 04 99 ?? ?? ?? ?? 05 1C 0C 1C 09 E0 00 2C E1 D1 A1 48 A1 49 A2 4A A2 4B ?? ?? ?? ?? 05 1C 0C 1C 07 B0 28 1C 21 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 28 1C 21 1C 2A 1C 23 1C ?? ?? ?? ?? 05 1C 0C 1C ED E7 42 46 00 2A 00 DA AB E0 28 1C 21 1C ?? ?? ?? ?? 80 23 1B 06 C5 18 0C 1C E0 E7 C0 21 09 06 7B 18 00 2B 02 D1 52 46 00 2A C0 D0 8D 4B 9F 42 00 DD 5F E1 8C 4B 9F 42 01 DC 00 F0 E9 FB 8B 4B 9F 42 00 DC 38 E3 8A 48 8A 49 2A 1C 23 1C ?? ?? ?? ?? 0F 1C 00 21 06 1C 8A 46 89 46 32 1C 3B 1C 30 1C 39 1C ?? ?? ?? ?? 83 4A 84 4B 04 1C 0D 1C 30 1C 39 1C ?? ?? ?? ?? 81 4A 82 4B 01 90 02 91 20 1C 29 1C ?? ?? ?? ?? 7F 4A 80 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 7D 4A 7E 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 7B 4A 7C 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 79 4A 7A 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 77 4A 78 4B ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 74 4A 75 4B 06 1C 0F 1C 20 1C 29 1C ?? ?? ?? ?? 72 4A 73 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 70 4A 71 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 6E 4A 6F 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 6C 4A 6D 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 6A 4A 6B 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 01 98 02 99 ?? ?? ?? ?? 52 46 4B 46 ?? ?? ?? ?? 05 1C 0C 1C 27 E7 01 23 5B 42 33 60 80 23 1B 06 E8 18 21 1C ?? ?? ?? ?? 80 22 12 06 85 18 0C 1C 2F E7 58 4A 91 46 4F 45 00 DD 22 E7 2E 49 56 4B 29 40 8B 46 9B 45 00 DC 06 E2 80 23 1B 06 EB 18 18 1C 21 1C 03 93 ?? ?? ?? ?? 01 90 02 91 01 9A 02 9B 03 98 21 1C ?? ?? ?? ?? 00 28 00 D0 9D E3 4A 4B 9B 45 00 DC 4C E3 25 49 26 4A 03 91 04 92 03 98 04 99 46 4A 47 4B ?? ?? ?? ?? 00 23 00 93 1F 4A 20 4B ?? ?? ?? ?? 80 22 12 06 12 18 91 46 8B 46 48 46 59 46 1A 4A 1A 4B ?? ?? ?? ?? 00 28 00 D1 E6 E6 4A 46 5B 46 28 1C 21 1C ?? ?? ?? ?? ?? ?? ?? ?? 02 1C 0B 1C 35 48 36 49 ?? ?? ?? ?? ?? ?? ?? ?? 0E 4A 0F 4B 03 90 04 91 48 46 59 46 ?? ?? ?? ?? 00 28 00 DB 32 E3 01 23 5B 42 33 60 80 23 1B 06 ED 18 AD E6 FF FF FF 7F FF FF EF 7F FF FF 8F 3B 00 00 10 C0 00 00 F0 3F 00 00 00 00 00 00 00 00 00 00 00 00 FF FF FF 3F CC CC EC 3F C2 B4 FB 3F 00 00 00 40 00 00 00 00 00 00 E0 BF 00 00 00 00 74 70 FA 3E 52 FA 8C 42 EC F2 2C 3F 4D E5 10 ED 94 8A 53 3F 5D 3F 6F 11 4F 40 7E 3F E8 EF 8F B6 00 3E B1 3F A7 62 55 1A 67 C4 B3 3F C8 B0 7D E3 8E 85 07 3F 37 58 A4 90 88 50 1C 3F 07 FB 7D 98 C6 B6 40 3F 00 9C B9 89 D8 AD 67 3F 6B 92 B7 CC 22 13 95 3F 7B 54 92 AC 4C A3 D4 3F AD 0F A6 C4 FF FF 2F 43 FF FF CF 3F FF FF 3F 43 FB 21 09 40 18 2D 44 54 B3 4B 9F 42 00 DD EA E0 21 1C 28 1C ?? ?? ?? ?? 82 46 ?? ?? ?? ?? 02 1C 0B 1C 28 1C 21 1C ?? ?? ?? ?? AC 4A AC 4B 06 1C 0F 1C ?? ?? ?? ?? AB 4A AB 4B 01 90 02 91 30 1C 39 1C ?? ?? ?? ?? A9 4A A9 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? A7 4A A7 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? A5 4A A5 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? A3 4A A3 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? A1 4A A1 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 9F 4A 9F 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 9D 4A 9D 4B 04 1C 0D 1C 30 1C 39 1C ?? ?? ?? ?? 9B 4A 9B 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 99 4A 99 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 97 4A 97 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 95 4A 95 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 93 4A 93 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 91 4A 91 4B ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 0B 1C 02 1C 01 98 02 99 ?? ?? ?? ?? 53 46 03 3B 05 1C 0C 1C 04 2B 00 D9 C8 E5 87 4A 9B 00 D3 58 9F 46 83 4A 84 4B 01 92 02 93 84 4A 85 4B 30 1C 39 1C ?? ?? ?? ?? 01 9A 02 9B ?? ?? ?? ?? 01 90 02 91 80 4A 81 4B 30 1C 39 1C ?? ?? ?? ?? 01 9A 02 9B ?? ?? ?? ?? 01 90 02 91 7C 4A 7D 4B 30 1C 39 1C ?? ?? ?? ?? 01 9A 02 9B ?? ?? ?? ?? 01 90 02 91 78 4A 79 4B 30 1C 39 1C ?? ?? ?? ?? 01 9A 02 9B ?? ?? ?? ?? ?? ?? ?? ?? 02 1C 0B 1C 28 1C 21 1C ?? ?? ?? ?? 05 1C 0C 1C 87 E5 65 49 65 4A 01 91 02 92 CD E7 62 4A 63 4B 01 92 02 93 D4 E7 60 49 60 4A 01 91 02 92 DB E7 30 1C 39 1C 67 4A 68 4B ?? ?? ?? ?? 01 90 02 91 AE E7 66 4B 9F 42 00 DD B1 E1 28 1C 21 1C ?? ?? ?? ?? 2A 1C 23 1C 05 90 06 91 53 48 53 49 ?? ?? ?? ?? 02 1C 0B 1C 01 90 02 91 ?? ?? ?? ?? 32 4A 32 4B 06 1C 0F 1C 28 1C 21 1C ?? ?? ?? ?? 4A 4A 4A 4B 04 1C 0D 1C 05 98 06 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 51 4A 51 4B 04 1C 0D 1C 30 1C 39 1C ?? ?? ?? ?? 4F 4A 4F 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 4D 4A 4D 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 4B 4A 4B 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 49 4A 49 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 47 4A 47 4B ?? ?? ?? ?? 01 9A 02 9B ?? ?? ?? ?? 45 4A 45 4B ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 05 1C 0C 1C 06 E5 40 4A 41 4B 28 1C 21 1C ?? ?? ?? ?? 00 23 00 93 3E 4A 3F 4B ?? ?? ?? ?? 81 46 8B 46 15 E6 C0 46 FF FF 1F 40 00 00 E0 3F 00 00 00 00 EC BF 00 3F 45 E9 17 DD B6 26 5E 3F 39 F2 68 73 1C 48 9B 3F 61 99 93 7E 9C BB C2 3F F7 F2 E5 BE 8F D9 D4 3F 59 9F 13 4F 8B 84 CB 3F 78 08 E2 36 67 C4 B3 3F C8 B0 7D E3 F7 BA DE 3E 40 81 B3 A5 DA 7D 49 3F 5B A9 41 CA EA 17 93 3F 75 D4 2E 74 ED 01 C6 3F 27 DF FB CC 18 1A E7 3F DC DC D3 93 A7 45 F6 3F 74 AB C4 62 00 00 F0 3F 00 00 00 00 ?? ?? ?? ?? 00 00 14 40 00 00 00 00 00 00 10 40 00 00 00 00 00 00 08 40 00 00 00 00 00 00 00 40 00 00 00 00 00 00 18 40 00 00 00 00 FF FF 8F 43 9D B8 5A BF E4 43 9E 0B BA 67 4B 3F D1 D5 DA 4C CB 80 43 3F 41 E7 0F 8C 9F 01 4A 3F B6 38 CF 98 6C C1 66 3F 5C 2E B0 16 55 55 B5 3F 3B 55 55 55 E3 CF DA 3F 69 7D C9 90 FB 21 09 40 18 2D 44 54 00 00 00 00 00 00 00 00 D8 4B 9F 42 00 DC 38 E1 D7 4A D8 4B 28 1C 21 1C ?? ?? ?? ?? 00 22 06 1C 0F 1C 92 46 91 46 32 1C 3B 1C 30 1C 39 1C ?? ?? ?? ?? 32 1C 3B 1C 01 90 02 91 ?? ?? ?? ?? CE 4A CE 4B 04 1C 0D 1C ?? ?? ?? ?? CD 4A CD 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? CB 4A CB 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? C9 4A C9 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? C7 4A C7 4B ?? ?? ?? ?? 02 1C 0B 1C 01 98 02 99 ?? ?? ?? ?? C4 4A C4 4B 01 90 02 91 20 1C 29 1C ?? ?? ?? ?? C2 4A C2 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? C0 4A C0 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? BE 4A BE 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? BC 4A BC 4B ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? B9 4A B9 4B 06 1C 0F 1C 20 1C 29 1C ?? ?? ?? ?? B7 4A B7 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? B5 4A B5 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? B3 4A B3 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? B1 4A B1 4B ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 02 1C 0B 1C AB 48 AB 49 ?? ?? ?? ?? 02 1C 0B 1C 01 98 02 99 ?? ?? ?? ?? A8 4A A8 4B ?? ?? ?? ?? A1 E4 28 1C 21 1C ?? ?? ?? ?? 80 23 1B 06 1B 18 9A 46 A3 4B 89 46 9F 42 00 DC 96 E1 A2 48 A2 49 2A 1C 23 1C ?? ?? ?? ?? 06 1C 0F 1C FF F7 0F FC 28 1C 21 1C ?? ?? ?? ?? 9B 4A 9B 4B ?? ?? ?? ?? 2A 1C 23 1C ?? ?? ?? ?? 05 1C 0C 1C FF F7 AA FB CB 45 07 DC 03 98 21 1C 95 4A 95 4B ?? ?? ?? ?? 01 90 02 91 01 9A 02 9B 01 21 19 40 08 1C 89 46 ?? ?? ?? ?? 4A 46 03 90 04 91 90 00 06 28 08 D9 03 98 04 99 8C 4A 8C 4B ?? ?? ?? ?? 99 E4 33 68 CC E4 8A 4B 80 00 1B 58 9F 46 03 9A 04 9B 81 48 82 49 ?? ?? ?? ?? 8C E4 03 9A 04 9B 85 48 85 49 ?? ?? ?? ?? 85 4A 85 4B ?? ?? ?? ?? 85 4A 85 4B ?? ?? ?? ?? 87 E4 03 98 04 99 83 4A 84 4B ?? ?? ?? ?? 7D 4A 7E 4B ?? ?? ?? ?? 7D 4A 7E 4B ?? ?? ?? ?? 80 23 1B 06 C0 18 75 E4 03 98 75 4A 75 4B 21 1C ?? ?? ?? ?? 03 90 04 91 ?? ?? ?? ?? 02 1C 0B 1C 03 98 04 99 ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? 73 4A 74 4B 03 90 04 91 ?? ?? ?? ?? ?? ?? ?? ?? AB E7 28 1C 21 1C 5F 4A 5F 4B ?? ?? ?? ?? 00 23 05 1C 0C 1C 9A 46 99 46 28 1C 21 1C 6A 4A 6B 4B ?? ?? ?? ?? 6A 4A 6B 4B 01 90 02 91 28 1C 21 1C ?? ?? ?? ?? 68 4A 69 4B ?? ?? ?? ?? 2A 1C 23 1C ?? ?? ?? ?? 66 4A 67 4B ?? ?? ?? ?? 2A 1C 23 1C ?? ?? ?? ?? 64 4A 65 4B ?? ?? ?? ?? 2A 1C 23 1C ?? ?? ?? ?? 62 4A 63 4B ?? ?? ?? ?? 2A 1C 23 1C ?? ?? ?? ?? 60 4A 61 4B ?? ?? ?? ?? 2A 1C 23 1C ?? ?? ?? ?? 5E 4A 5F 4B 06 1C 0F 1C 28 1C 21 1C ?? ?? ?? ?? 5C 4A 5D 4B ?? ?? ?? ?? 2A 1C 23 1C ?? ?? ?? ?? 5A 4A 5B 4B ?? ?? ?? ?? 2A 1C 23 1C ?? ?? ?? ?? 58 4A 59 4B ?? ?? ?? ?? 2A 1C 23 1C ?? ?? ?? ?? 56 4A 57 4B ?? ?? ?? ?? 2A 1C 23 1C ?? ?? ?? ?? 2B 4A 2C 4B ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? FF F7 96 FB C3 B4 F3 3F D8 62 F7 3F 3F BE 56 63 6D AF 34 3F F7 BB 0E 6C 8E FE 56 3F F1 1A 2D BF E0 FC 78 3F 44 E3 70 E3 A8 C9 A0 3F 13 B7 35 DF 2B F7 DE 3F A2 38 EE C8 3E FD 35 3F F4 D3 C2 E8 10 A6 41 3F EC E0 73 9C D3 82 62 3F 15 C9 15 2E 9F 1F 85 3F 6A EC 91 BA 42 8B B0 3F 9B 41 D5 94 24 7F 34 BF 38 8C C3 EC 0C DF 4C 3F E9 A8 61 EF FF 2E 6E 3F D7 14 E9 B3 E7 66 92 3F EC F9 0A 97 27 E4 C2 3F 09 C5 C6 8D CA C7 50 BC 1F 97 8A A4 B9 19 BF 3F 42 8A C3 BC 43 69 E7 3F 00 00 F0 3F 00 00 00 00 00 00 30 43 00 00 00 00 00 00 00 40 00 00 00 00 ?? ?? ?? ?? 00 00 E0 3F 00 00 00 00 FB 21 09 40 18 2D 44 54 00 00 00 00 00 00 00 00 00 00 F8 3F 00 00 00 00 00 00 10 40 00 00 00 00 00 00 E0 BF 00 00 00 00 8B 67 8B 3F 09 AB 2B BF AE 4E CD 3F 24 09 01 F6 76 49 EF 3F 50 84 EA 44 5C 47 F7 3F 6F BD 19 D1 1E 40 E4 3F FF 5D 00 8B 67 C4 B3 3F C8 B0 7D E3 BB 5A 6A 3F 61 CF D0 57 55 AE BA 3F 88 7C 53 D6 FB 9D E8 3F AF 50 50 E4 25 07 01 40 F5 18 2B A4 D7 A5 03 40 9C 61 BD C2 06 4B 9F 42 00 DC F3 E6 28 1C 21 1C 04 4A 05 4B ?? ?? ?? ?? 06 1C 0F 1C B1 E5 C0 46 60 A6 CD 3F 61 8B DD 3F FC F8 5A 8D }
	condition:
		$1
}

rule file_138_0_1 {
	meta:
		name = "logf"
		size = 244
		refs = "0006 __ieee754_logf 0016 isnanf 0024 __gtsf2 0034 __extendsfdf2 0054 __eqsf2 0066 matherr 0078 __truncdfsf2 00ac nan 00b6 __errno 00d4 __fdlib_version"
	strings:
		$1 = { F0 B5 89 B0 04 1C ?? ?? ?? ?? 32 4E 33 68 05 1C 01 33 34 D0 20 1C ?? ?? ?? ?? 07 1C 00 28 2E D1 20 1C 2D 49 ?? ?? ?? ?? 00 28 28 DC 2B 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 36 68 6D 46 28 61 69 61 A8 60 E9 60 00 2E 1D D0 25 4A 26 4B 20 1C AA 61 EB 61 21 49 ?? ?? ?? ?? 00 28 1D D1 02 23 00 93 02 2E 2D D0 68 46 ?? ?? ?? ?? 00 28 28 D0 2B 6A 00 2B 20 D1 A8 69 E9 69 ?? ?? ?? ?? 05 1C 09 B0 28 1C F0 BD 18 4A 19 4B 20 1C AA 61 EB 61 12 49 ?? ?? ?? ?? 00 28 E1 D0 01 23 00 93 02 2E 14 D0 68 46 ?? ?? ?? ?? 00 28 0F D0 11 48 ?? ?? ?? ?? A8 61 E9 61 DB E7 ?? ?? ?? ?? 2B 6A 03 60 D9 E7 ?? ?? ?? ?? 22 23 03 60 D1 E7 ?? ?? ?? ?? 21 23 03 60 EA E7 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 F0 FF 00 00 00 00 FF FF EF C7 00 00 00 E0 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_140_0_1 {
	meta:
		name = "log10f"
		size = 244
		refs = "0006 __ieee754_log10f 0016 isnanf 0024 __lesf2 0034 __extendsfdf2 0054 __eqsf2 0066 matherr 0078 __truncdfsf2 00ac nan 00b6 __errno 00d4 __fdlib_version"
	strings:
		$1 = { F0 B5 89 B0 04 1C ?? ?? ?? ?? 32 4E 33 68 05 1C 01 33 34 D0 20 1C ?? ?? ?? ?? 07 1C 00 28 2E D1 20 1C 2D 49 ?? ?? ?? ?? 00 28 28 DC 2B 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 36 68 6D 46 28 61 69 61 A8 60 E9 60 00 2E 1D D0 25 4A 26 4B 20 1C AA 61 EB 61 21 49 ?? ?? ?? ?? 00 28 1D D1 02 23 00 93 02 2E 2D D0 68 46 ?? ?? ?? ?? 00 28 28 D0 2B 6A 00 2B 20 D1 A8 69 E9 69 ?? ?? ?? ?? 05 1C 09 B0 28 1C F0 BD 18 4A 19 4B 20 1C AA 61 EB 61 12 49 ?? ?? ?? ?? 00 28 E1 D0 01 23 00 93 02 2E 14 D0 68 46 ?? ?? ?? ?? 00 28 0F D0 11 48 ?? ?? ?? ?? A8 61 E9 61 DB E7 ?? ?? ?? ?? 2B 6A 03 60 D9 E7 ?? ?? ?? ?? 22 23 03 60 D1 E7 ?? ?? ?? ?? 21 23 03 60 EA E7 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 F0 FF 00 00 00 00 FF FF EF C7 00 00 00 E0 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_139_0_1 {
	meta:
		name = "round"
		size = 160
		refs = "0046 __adddf3"
	strings:
		$1 = { 70 B5 44 00 22 4E 64 0D 0B 1C 0D 1C A1 19 02 1C 13 29 10 DC 00 29 2F DB 1E 4C 0C 41 04 42 28 D0 80 23 1B 03 0B 41 18 18 A0 43 00 21 02 1C 0B 1C 10 1C 19 1C 70 BD 33 29 0A DD 80 20 C0 00 81 42 F6 D1 10 1C 19 1C ?? ?? ?? ?? 02 1C 0B 1C EF E7 11 4E A4 19 01 26 76 42 E6 40 1E 42 E8 D0 33 23 59 1A 01 23 8B 40 59 19 8D 42 00 D9 01 30 B1 43 DC E7 00 2B DC D0 D3 E7 80 23 1B 06 18 40 01 31 01 D0 00 21 D2 E7 05 4B 00 21 18 43 CE E7 C0 46 01 FC FF FF FF FF 0F 00 ED FB FF FF 00 00 F0 3F }
	condition:
		$1
}

rule file_141_0_1 {
	meta:
		name = "fdimf"
		size = 52
		refs = "0006 __fpclassifyf 0012 __gtsf2 0022 __subsf3"
	strings:
		$1 = { 30 B5 04 1C 0D 1C ?? ?? ?? ?? 01 28 0C D9 20 1C 29 1C ?? ?? ?? ?? 00 28 01 DC 04 48 30 BD 20 1C 29 1C ?? ?? ?? ?? F9 E7 01 48 F7 E7 00 00 00 00 00 00 80 7F }
	condition:
		$1
}

rule file_142_0_1 {
	meta:
		name = "__ieee754_atan2"
		size = 508
		refs = "0062 atan 0068 __adddf3 00cc __divdf3 00d0 fabs 00e8 __subdf3"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 83 B0 62 4C 00 92 01 93 00 9E 25 1C 01 9F 35 40 01 9E 7F 42 37 43 A9 46 FF 0F 4E 46 3E 43 5C 4F B3 46 A0 46 02 90 04 1C 8A 46 BC 46 BB 45 15 D8 46 46 05 1C 35 40 A8 46 4D 42 0D 43 ED 0F 46 46 35 43 65 45 0A D8 00 9F 52 4E BD 19 00 2D 0E D1 01 9F 00 2F 0B D1 ?? ?? ?? ?? 01 E0 ?? ?? ?? ?? 03 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 9D AD 17 AC 46 02 9F 02 25 66 46 2E 40 FD 0F 35 43 46 46 00 2E 08 D1 57 46 00 2F 05 D1 02 2D 39 D0 02 2D 2F DC 00 2D E3 DA 4E 46 00 2E 02 D1 01 9F 00 2F 22 D0 3A 4E B1 45 2F D0 39 4E B0 45 1C D0 46 46 4F 46 F4 1B 24 15 3C 2C 20 DC 3C 34 36 DB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 01 2D 2A D0 02 2D 32 D0 00 2D C3 D0 2F 4A 30 4B ?? ?? ?? ?? 2F 4A 30 4B ?? ?? ?? ?? BA E7 00 2C 18 DB 2E 48 2E 49 B5 E7 03 2D CF D1 2D 48 2E 49 B0 E7 2A 48 2A 49 E3 E7 26 48 27 49 AA E7 C8 45 20 D0 01 2D 29 D0 01 2D 2A DD 02 2D F4 D0 03 2D C5 D1 EB E7 25 48 26 49 9C E7 80 25 2D 06 40 19 98 E7 00 9C 00 2C C5 DA 22 48 23 49 C8 E7 17 4A 17 4B ?? ?? ?? ?? 02 1C 0B 1C 16 48 16 49 ?? ?? ?? ?? 87 E7 01 2D 13 D0 01 2D 14 DD 02 2D 0C D0 03 2D C4 D1 19 48 1A 49 7C E7 1A 48 1A 49 79 E7 00 2D 9C D1 13 48 14 49 74 E7 18 48 18 49 71 E7 18 48 19 49 6E E7 00 2D B1 D1 18 48 18 49 69 E7 FF FF FF 7F 00 00 F0 7F 00 00 10 C0 26 A6 A1 3C 07 5C 14 33 FB 21 09 40 18 2D 44 54 FB 21 F9 3F 18 2D 44 54 FB 21 09 C0 18 2D 44 54 FB 21 F9 BF 18 2D 44 54 00 00 00 00 00 00 00 00 7C D9 02 C0 D2 21 33 7F 00 00 00 80 00 00 00 00 7C D9 02 40 D2 21 33 7F FB 21 E9 BF 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 }
	condition:
		$1
}

rule file_143_0_1 {
	meta:
		name = "__kernel_cosf"
		size = 396
		refs = "0018 __fixsfsi 0026 __mulsf3 0034 __addsf3 0040 __subsf3"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 53 4B 06 1C 1E 40 53 4B 05 1C 0F 1C 9E 42 46 DC ?? ?? ?? ?? 00 28 00 D1 98 E0 29 1C 28 1C ?? ?? ?? ?? 4D 49 04 1C ?? ?? ?? ?? 4C 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 4A 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 48 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 46 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 44 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 80 46 20 1C 41 49 ?? ?? ?? ?? 41 46 06 1C 20 1C ?? ?? ?? ?? 39 1C 04 1C 28 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 01 1C 37 48 ?? ?? ?? ?? 4E E0 29 1C ?? ?? ?? ?? 2C 49 04 1C ?? ?? ?? ?? 2B 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 29 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 27 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 25 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 23 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 23 4B 80 46 9E 42 BB DD 22 4B 9E 42 26 DD 22 4E 31 1C 1E 48 ?? ?? ?? ?? 1B 49 82 46 20 1C ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 41 46 06 1C 20 1C ?? ?? ?? ?? 39 1C 04 1C 28 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 01 1C 50 46 ?? ?? ?? ?? 0C BC 90 46 9A 46 F0 BD FF 23 1B 06 F6 18 D5 E7 09 48 F5 E7 FF FF FF 7F FF FF FF 31 4E D7 47 AD F6 74 0F 31 7C F2 93 34 01 0D D0 37 61 0B B6 3A AB AA 2A 3D 00 00 00 3F 00 00 80 3F 99 99 99 3E 00 00 48 3F 00 00 90 3E }
	condition:
		$1
}

rule file_144_0_1 {
	meta:
		name = "cosf"
		size = 132
		refs = "0016 __subsf3 0020 __ieee754_rem_pio2f 0038 __kernel_cosf 005c __kernel_sinf"
	strings:
		$1 = { 00 B5 1C 4B 1C 4A 03 40 82 B0 01 1C 93 42 16 DD 1A 4A 93 42 03 DD ?? ?? ?? ?? 02 B0 00 BD 69 46 ?? ?? ?? ?? 03 23 18 40 01 28 14 D0 02 28 0A D0 00 28 19 D1 00 98 01 99 ?? ?? ?? ?? ED E7 10 49 ?? ?? ?? ?? E9 E7 00 98 01 99 ?? ?? ?? ?? 80 23 1B 06 C0 18 E1 E7 00 98 01 99 01 22 ?? ?? ?? ?? 80 23 1B 06 C0 18 D8 E7 00 98 01 99 01 22 ?? ?? ?? ?? D2 E7 FF FF FF 7F D8 0F 49 3F FF FF 7F 7F 00 00 00 00 }
	condition:
		$1
}

rule file_145_0_1 {
	meta:
		name = "__kernel_rem_pio2f"
		size = 1712
		refs = "0060 __floatsisf 00b6 __mulsf3 00be __addsf3 0112 __fixsfsi 0148 scalbnf 0154 floorf 0176 __subsf3 0218 __eqsf2 0356 __gesf2"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 DB B0 07 1C 64 98 07 91 D4 49 08 93 83 00 CB 58 05 93 08 9B 01 3B 02 93 D3 1E D9 17 49 0F CB 18 DB 10 0A 93 00 2B 00 DA F2 E2 0A 98 C3 43 DB 00 9B 18 05 99 02 9A 04 93 8B 18 1A D4 84 1A 1B 19 65 98 98 46 A5 00 3B 1C 33 AE 47 46 45 19 98 46 07 E0 28 68 ?? ?? ?? ?? 04 35 01 C6 BC 42 07 D0 01 34 00 2C F5 DA BE 48 04 35 01 C6 BC 42 F7 D1 47 46 05 99 00 29 00 DA 03 E3 05 98 6B 46 83 46 08 98 2C 33 02 9C 81 00 06 93 99 46 A2 46 83 44 88 46 02 9C 00 2C 00 DA 19 E2 50 46 85 00 33 A9 AF 4E 4D 19 00 24 29 68 38 59 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 04 34 06 1C 04 3D 44 45 F2 D1 4A 46 04 32 01 23 91 46 9A 44 04 3A 40 C2 DA 45 DF D1 05 9A 91 46 4B 46 06 9C 9B 00 1C 59 48 46 9B 46 A0 46 00 28 27 DD 4C 46 01 3C 06 99 3B 1C A4 00 0A AA 47 46 47 AD 0C 19 92 46 98 46 99 49 38 1C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 96 49 06 1C ?? ?? ?? ?? 39 1C ?? ?? ?? ?? ?? ?? ?? ?? 21 68 01 C5 30 1C ?? ?? ?? ?? 04 3C 07 1C 54 45 E5 D1 43 46 1F 1C 80 46 04 99 40 46 ?? ?? ?? ?? 8A 49 04 1C ?? ?? ?? ?? ?? ?? ?? ?? 88 49 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 04 1C ?? ?? ?? ?? 06 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 04 9B 05 1C 00 2B 00 DC D2 E0 4B 46 01 3B 9B 00 47 AC E2 58 04 98 08 21 09 1A 10 1C 08 41 36 18 88 40 11 1A 04 9A E1 50 07 23 9B 1A 19 41 01 91 01 9A 00 2A 31 DD 4B 46 01 36 00 2B 00 DC C0 E1 47 AB 19 1C 80 20 59 44 00 24 40 00 07 E0 00 2A 02 D0 82 1A 1A 60 01 24 04 33 8B 42 09 D0 1A 68 00 2C F4 D0 FF 24 A2 1A 1A 60 04 33 01 24 8B 42 F5 D1 04 98 00 28 0D DD 01 28 00 D1 A3 E0 02 28 08 D1 4B 46 01 3B 9B 00 47 AA D1 58 3F 22 0A 40 47 A8 C2 50 01 99 02 29 78 D0 28 1C 55 49 ?? ?? ?? ?? 00 28 00 D0 5D E1 4C 46 05 9A 01 3C A2 42 0E DC 47 A8 A5 00 92 00 43 19 46 A8 80 18 00 22 19 68 04 3B 0A 43 83 42 FA D1 00 2A 00 D0 9E E0 05 9B 01 3B 9B 00 47 A9 CB 58 00 2B 00 D0 7F E1 05 9B 02 3B 9B 00 47 AA D3 18 01 21 1A 68 01 31 04 3B 00 2A FA D0 4A 46 49 44 01 32 09 91 8A 42 3F DC 0A 9B 01 33 4B 44 08 98 65 9C 9B 00 E4 18 03 1C 06 98 4B 44 92 00 99 00 82 18 A2 46 33 AC 64 18 01 92 09 99 08 9A 89 18 03 91 92 00 A3 46 99 46 90 46 53 46 18 68 ?? ?? ?? ?? 5C 46 20 60 02 98 00 28 20 DB 49 46 8D 00 33 AA 29 4E 55 19 00 24 29 68 38 59 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 04 34 06 1C 04 3D 44 45 F2 D1 01 9B 01 20 40 C3 03 99 04 24 81 44 01 93 A2 44 A3 44 89 45 D8 D1 09 9A 91 46 EF E6 1A 4E EF E7 29 1C 1D 48 ?? ?? ?? ?? 05 1C 00 2C 00 D1 7E E7 04 99 19 48 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 05 1C 74 E7 04 9B 00 2B 11 D1 4B 46 01 3B 9B 00 47 AC E3 58 1B 12 01 93 34 E7 4B 46 01 3B 9B 00 47 AA D1 58 7F 22 0A 40 47 A8 C2 50 5C E7 0B 49 ?? ?? ?? ?? 00 28 00 DB B9 E0 00 20 01 90 56 E7 C0 46 ?? ?? ?? ?? 00 00 00 00 00 00 80 3B 00 00 80 C3 00 00 00 3E 00 00 00 C1 00 00 80 3F 00 00 00 3F 04 98 47 A9 4B 59 08 38 03 96 04 90 00 2B 00 D0 77 E1 63 1E 47 AA 9B 00 D3 18 04 9A 21 1C 18 68 01 39 08 3A 04 3B 00 28 F9 D0 04 92 89 46 B8 48 04 99 ?? ?? ?? ?? 4A 46 05 1C 00 2A 4B DB 06 98 96 00 47 AB 9C 19 46 AF 86 19 20 68 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? AF 49 30 60 28 1C ?? ?? ?? ?? 04 3C 05 1C 04 3E BC 42 EF D1 01 21 8B 46 CB 44 5C 46 05 98 00 22 1F AB 02 94 CB 46 90 46 99 46 82 46 58 46 41 46 52 46 45 1A 00 2A 5C DB 43 46 00 2B 59 DB 06 9C AD 00 65 19 9F 4E 9F 4F 00 24 03 E0 04 36 04 35 44 45 0B DC 29 68 30 68 ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 01 34 07 1C A2 45 EF DA 41 46 8B 00 4A 46 D7 50 02 9C 01 23 98 44 A0 45 D6 D1 D9 46 64 98 02 28 6D DC 00 28 00 DC F2 E0 4C 46 00 2C 00 DA EA E0 1F AA 4B 46 8B 49 92 46 9C 00 54 44 1E AD 08 1C 21 68 04 3C ?? ?? ?? ?? AC 42 F9 D1 01 1C 01 9C 00 2C 63 D0 80 20 00 06 0B 18 07 9A 13 60 1F 98 ?? ?? ?? ?? 4B 46 00 2B 08 DD 54 46 9D 00 65 19 61 68 04 34 ?? ?? ?? ?? AC 42 F9 D1 01 9C 00 2C 02 D0 80 21 09 06 40 18 07 9A 50 60 3A E0 74 4F BA E7 02 21 01 91 6A E6 72 4E F6 E5 04 9B 28 1C 59 42 03 96 ?? ?? ?? ?? 6F 49 04 1C ?? ?? ?? ?? 00 28 00 DA 94 E0 68 49 20 1C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 68 49 05 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? ?? ?? ?? ?? 5C 46 47 AB 18 51 04 99 01 20 81 44 08 31 4A 46 28 1C 94 00 04 91 ?? ?? ?? ?? 47 AB 18 51 3C E7 00 24 55 E6 64 99 03 29 0D D0 03 9A 07 20 5B B0 10 40 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 01 21 88 E6 0B 1C 9C E7 4A 46 00 2A 6B DD 4C 46 A4 00 1F AB A3 46 4C 46 18 1C 01 3C 69 46 9A 46 58 44 A4 00 78 31 54 44 07 68 00 91 25 1C 2A 68 39 1C 10 1C 90 46 ?? ?? ?? ?? 06 1C 31 1C 40 46 ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 00 9B 68 60 2E 60 04 3D 37 1C 9D 42 EA D1 48 46 01 28 45 DD 51 46 59 44 0E 68 27 68 30 1C 39 1C ?? ?? ?? ?? 05 1C 29 1C 38 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 25 60 60 60 04 3C 2E 1C A2 45 EB D1 54 46 55 46 2E 48 5C 44 04 35 21 68 04 3C ?? ?? ?? ?? AC 42 F9 D1 01 9B 00 2B 16 D0 1F 9B 80 22 12 06 07 9C 9B 18 23 60 51 46 4B 68 80 18 9B 18 63 60 A0 60 94 E7 00 24 0A 94 09 E5 20 1C ?? ?? ?? ?? 47 AC 59 46 60 50 C2 E6 1F 9B 07 9C 23 60 51 46 4B 68 A0 60 63 60 82 E7 1F AB 9A 46 17 48 D9 E7 1F A8 16 49 82 46 1F E7 00 28 00 D0 77 E7 49 46 00 29 14 DB 4A 46 93 00 1F AC 10 48 E4 18 1E AD 21 68 04 3C ?? ?? ?? ?? AC 42 F9 D1 01 9B 00 2B 02 D0 80 24 24 06 00 19 07 99 08 60 5F E7 07 48 F4 E7 A1 46 93 E6 6A 46 2C 32 06 92 23 E5 C0 46 00 00 80 3F 00 00 80 3B ?? ?? ?? ?? 00 00 00 00 00 00 80 43 00 00 80 C3 }
	condition:
		$1
}

rule file_146_0_1 {
	meta:
		name = "fmax"
		size = 58
		refs = "000a __fpclassifyd 002c __gtdf2"
	strings:
		$1 = { F0 B5 06 1C 0F 1C 14 1C 1D 1C ?? ?? ?? ?? 00 28 02 D1 29 1C 20 1C F0 BD 20 1C 29 1C ?? ?? ?? ?? 00 28 07 D0 30 1C 39 1C 22 1C 2B 1C ?? ?? ?? ?? 00 28 EE DD 34 1C 3D 1C EB E7 }
	condition:
		$1
}

rule file_147_0_1 {
	meta:
		name = "__ieee754_expf"
		size = 508
		refs = "0038 __mulsf3 0044 __addsf3 0048 __fixsfsi 004e __floatsisf 005e __subsf3 0112 __divsf3 014c __gtsf2"
	strings:
		$1 = { F0 B5 47 46 80 B4 69 4A FF 23 02 40 DB 05 04 1C 9A 42 32 D8 C5 0F 9A 42 37 D0 65 4B 98 42 3C DC 64 4B 9A 42 35 D8 64 4B 9A 42 3C D9 63 4B 9A 42 00 D8 95 E0 62 49 20 1C ?? ?? ?? ?? 61 4B AD 00 5D 19 29 69 ?? ?? ?? ?? ?? ?? ?? ?? 06 1C ?? ?? ?? ?? 5D 49 05 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 5A 49 80 46 28 1C ?? ?? ?? ?? 07 1C 40 46 39 1C ?? ?? ?? ?? 04 1C 19 E0 21 1C ?? ?? ?? ?? 04 1C 20 1C 04 BC 90 46 F0 BD 00 2D F9 D0 50 4C F7 E7 00 28 C7 DA 4E 4C F3 E7 4E 48 01 1C ?? ?? ?? ?? 04 1C ED E7 4C 4B 9A 42 4A D9 00 26 21 1C 20 1C ?? ?? ?? ?? 49 49 05 1C ?? ?? ?? ?? 48 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 46 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 44 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 42 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 05 1C 00 2E 3E D0 20 1C 29 1C ?? ?? ?? ?? 29 1C 04 1C 39 48 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 41 46 ?? ?? ?? ?? 01 1C 33 48 ?? ?? ?? ?? 33 1C 7D 33 39 DA 64 36 F6 05 30 18 2F 49 ?? ?? ?? ?? 04 1C 9F E7 24 49 20 1C ?? ?? ?? ?? 2A 49 ?? ?? ?? ?? 00 28 AC DD 20 1C 27 49 ?? ?? ?? ?? 04 1C 90 E7 18 4E AB 00 F6 18 31 68 20 1C ?? ?? ?? ?? B7 68 6E 42 75 1B 80 46 6E 1C 79 E7 20 1C 29 1C ?? ?? ?? ?? 1B 49 06 1C 28 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 01 1C 15 48 ?? ?? ?? ?? 04 1C 6D E7 F4 05 24 18 6A E7 FF FF FF 7F 17 72 B1 42 B5 F1 CF 42 18 72 B1 3E 91 15 85 3F 3B AA B8 3F ?? ?? ?? ?? 80 71 31 3F D1 F7 17 37 00 00 00 00 CA F2 49 71 FF FF 7F 31 4C BB 31 33 0E EA DD 35 55 B3 8A 38 61 0B 36 3B AB AA 2A 3E 00 00 00 40 00 00 80 3F 00 00 80 0D }
	condition:
		$1
}

rule file_148_0_1 {
	meta:
		name = "__ieee754_asinf"
		size = 704
		refs = "0032 __addsf3 0038 __gtsf2 0044 fabsf 004c __subsf3 0052 __mulsf3 00d2 __ieee754_sqrtf 00ee __divsf3"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 96 4C FE 23 04 40 9B 05 05 1C 06 1C 9C 42 00 D1 C3 E0 9C 42 00 DD 9C E0 91 4B 9C 42 0C DC 90 4B 9C 42 00 DD C7 E0 8F 49 ?? ?? ?? ?? 8F 49 ?? ?? ?? ?? 00 28 00 DD 93 E0 28 1C ?? ?? ?? ?? 01 1C 8A 48 ?? ?? ?? ?? 89 49 ?? ?? ?? ?? 89 49 05 1C ?? ?? ?? ?? 88 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 86 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 84 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 82 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 80 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 7E 49 80 46 28 1C ?? ?? ?? ?? 7C 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 7A 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 78 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 6A 49 ?? ?? ?? ?? 82 46 28 1C ?? ?? ?? ?? 73 4B 07 1C 9C 42 4B DC 72 4C 39 1C 04 40 ?? ?? ?? ?? 51 46 81 46 40 46 ?? ?? ?? ?? 01 1C 48 46 ?? ?? ?? ?? 21 1C 80 46 20 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 21 1C 05 1C 38 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 63 49 ?? ?? ?? ?? 62 49 ?? ?? ?? ?? 01 1C 40 46 ?? ?? ?? ?? 5E 49 05 1C 20 1C ?? ?? ?? ?? 5D 49 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 01 1C 59 48 ?? ?? ?? ?? 00 2E 00 DC 80 E0 05 1C 06 E0 29 1C ?? ?? ?? ?? 01 1C ?? ?? ?? ?? 05 1C 28 1C 1C BC 90 46 99 46 A2 46 F0 BD 51 46 40 46 ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 01 1C ?? ?? ?? ?? 46 49 ?? ?? ?? ?? 01 1C 46 48 ?? ?? ?? ?? D6 E7 44 49 ?? ?? ?? ?? 44 49 04 1C 28 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 05 1C D4 E7 29 1C ?? ?? ?? ?? 2D 49 04 1C ?? ?? ?? ?? 2C 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 2A 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 28 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 26 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 24 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 22 49 06 1C 20 1C ?? ?? ?? ?? 20 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 1E 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 1C 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 0E 49 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 05 1C 87 E7 80 23 1B 06 C5 18 83 E7 C0 46 FF FF FF 7F FF FF FF 3E FF FF FF 31 CA F2 49 71 00 00 80 3F 00 00 00 3F 08 EF 11 38 04 7F 4F 3A 46 11 24 3D A8 0A 4E 3E 90 B0 A6 3E AB AA 2A 3E 2E C6 9D 3D 61 33 30 3F 2D 57 01 40 39 D1 19 40 99 99 79 3F 00 F0 FF FF 00 00 00 C0 2E BD 3B 33 DB 0F 49 3F DB 0F C9 3F 2E BD 3B B3 }
	condition:
		$1
}

rule file_149_0_1 {
	meta:
		name = "__ieee754_scalbf"
		size = 184
		refs = "0006 isnanf 0012 __mulsf3 0024 finitef 0030 __gtsf2 0040 __divsf3 0048 rintf 004e __nesf2 0066 __ltsf2 0070 __fixsfsi 0078 scalbnf 0082 __subsf3"
	strings:
		$1 = { 30 B5 04 1C 0D 1C ?? ?? ?? ?? 00 28 04 D0 20 1C 29 1C ?? ?? ?? ?? 30 BD 28 1C ?? ?? ?? ?? 00 28 F5 D1 28 1C ?? ?? ?? ?? 00 28 0C D1 28 1C 1D 49 ?? ?? ?? ?? 00 28 EA DC 80 23 1B 06 E9 18 20 1C ?? ?? ?? ?? E7 E7 28 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 00 28 13 D1 28 1C 13 49 ?? ?? ?? ?? 00 28 1A DC 28 1C 11 49 ?? ?? ?? ?? 00 28 0F DB 28 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? CB E7 29 1C 28 1C ?? ?? ?? ?? 01 1C ?? ?? ?? ?? C3 E7 20 1C 07 49 ?? ?? ?? ?? BE E7 20 1C 06 49 ?? ?? ?? ?? B9 E7 C0 46 00 00 00 00 00 E8 7D 47 00 E8 7D C7 18 02 FF FF E8 FD 00 00 }
	condition:
		$1
}

rule file_150_0_1 {
	meta:
		name = "tgamma"
		size = 148
		refs = "000a __ieee754_gamma_r 0024 finite 0044 floor 004c __eqdf2 005c __ledf2 0070 __kernel_standard 0088 __fdlib_version"
	strings:
		$1 = { F0 B5 82 B0 01 AA 05 1C 0E 1C ?? ?? ?? ?? 01 9B 04 1C 0F 1C 00 2B 30 DB 1B 4B 1B 68 01 33 05 D0 20 1C 39 1C ?? ?? ?? ?? 00 28 03 D0 02 B0 39 1C 20 1C F0 BD 28 1C 31 1C ?? ?? ?? ?? 00 28 F5 D0 28 1C 31 1C ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 00 28 07 D1 28 1C 31 1C 0C 4A 0D 4B ?? ?? ?? ?? 00 28 0E DD 28 23 00 93 28 1C 31 1C 2A 1C 33 1C ?? ?? ?? ?? 04 1C 0F 1C D8 E7 80 23 1B 06 C4 18 CA E7 29 23 EF E7 C0 46 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_151_0_1 {
	meta:
		name = "exp"
		size = 252
		refs = "0008 __ieee754_exp 001c finite 002c __gtdf2 003c __ltdf2 006a matherr 0078 __errno 00cc __fdlib_version"
	strings:
		$1 = { F0 B5 8B B0 06 1C 0F 1C ?? ?? ?? ?? 2F 4D 2B 68 00 90 01 91 01 33 37 D0 30 1C 39 1C ?? ?? ?? ?? 00 28 31 D0 30 1C 39 1C 29 4A 2A 4B ?? ?? ?? ?? 00 28 2D DC 30 1C 39 1C 27 4A 28 4B ?? ?? ?? ?? 00 28 21 DA 04 23 02 93 25 4B 02 AC 63 60 00 23 23 62 24 4A 24 4B A2 61 E3 61 2B 68 26 61 67 61 A6 60 E7 60 02 2B 2C D0 20 1C ?? ?? ?? ?? 00 28 27 D0 23 6A 00 2B 03 D0 ?? ?? ?? ?? 23 6A 03 60 A2 69 E3 69 00 92 01 93 00 98 01 99 0B B0 F0 BD 03 23 02 93 12 4B 02 AC 63 60 00 23 23 62 2B 68 26 61 67 61 A6 60 E7 60 00 2B 04 D1 0F 4A 10 4B A2 61 E3 61 D8 E7 0F 49 0F 4A A1 61 E2 61 02 2B D2 D1 ?? ?? ?? ?? 22 23 03 60 D2 E7 ?? ?? ?? ?? 42 2E 86 40 EF 39 FA FE 10 49 87 C0 51 30 2D D5 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 FF FF EF 47 00 00 00 E0 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_153_0_1 {
	meta:
		name = "y0f"
		size = 260
		refs = "0006 __ieee754_y0f 0016 isnanf 0024 __lesf2 0030 __gtsf2 0044 __extendsfdf2 0062 matherr 0070 __errno 007c __truncdfsf2 00dc __fdlib_version"
	strings:
		$1 = { F0 B5 89 B0 04 1C ?? ?? ?? ?? 34 4E 33 68 05 1C 01 33 36 D0 20 1C ?? ?? ?? ?? 07 1C 00 28 30 D1 20 1C 2F 49 ?? ?? ?? ?? 00 28 2D DD 20 1C 2D 49 ?? ?? ?? ?? 00 28 24 DD 05 23 00 93 2A 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 28 4B 29 4C 6D 46 AB 61 EC 61 33 68 28 61 69 61 A8 60 E9 60 02 2B 38 D0 68 46 ?? ?? ?? ?? 00 28 33 D0 2B 6A 00 2B 03 D0 ?? ?? ?? ?? 2B 6A 03 60 A8 69 E9 69 ?? ?? ?? ?? 05 1C 09 B0 28 1C F0 BD 01 23 00 93 16 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 33 68 6D 46 28 61 69 61 A8 60 E9 60 00 2B 0D D1 12 4B 13 4C AB 61 EC 61 68 46 ?? ?? ?? ?? 00 28 D7 D1 ?? ?? ?? ?? 21 23 03 60 D2 E7 0D 49 0E 4A A9 61 EA 61 02 2B F4 D0 EE E7 ?? ?? ?? ?? 22 23 03 60 C6 E7 ?? ?? ?? ?? 00 00 00 00 DB 0F 49 5A ?? ?? ?? ?? 00 00 00 00 00 00 00 00 FF FF EF C7 00 00 00 E0 00 00 F0 FF 00 00 00 00 }
	condition:
		$1
}

rule file_190_0_1 {
	meta:
		name = "y1f"
		size = 260
		refs = "0006 __ieee754_y1f 0016 isnanf 0024 __lesf2 0030 __gtsf2 0044 __extendsfdf2 0062 matherr 0070 __errno 007c __truncdfsf2 00dc __fdlib_version"
	strings:
		$1 = { F0 B5 89 B0 04 1C ?? ?? ?? ?? 34 4E 33 68 05 1C 01 33 36 D0 20 1C ?? ?? ?? ?? 07 1C 00 28 30 D1 20 1C 2F 49 ?? ?? ?? ?? 00 28 2D DD 20 1C 2D 49 ?? ?? ?? ?? 00 28 24 DD 05 23 00 93 2A 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 28 4B 29 4C 6D 46 AB 61 EC 61 33 68 28 61 69 61 A8 60 E9 60 02 2B 38 D0 68 46 ?? ?? ?? ?? 00 28 33 D0 2B 6A 00 2B 03 D0 ?? ?? ?? ?? 2B 6A 03 60 A8 69 E9 69 ?? ?? ?? ?? 05 1C 09 B0 28 1C F0 BD 01 23 00 93 16 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 33 68 6D 46 28 61 69 61 A8 60 E9 60 00 2B 0D D1 12 4B 13 4C AB 61 EC 61 68 46 ?? ?? ?? ?? 00 28 D7 D1 ?? ?? ?? ?? 21 23 03 60 D2 E7 0D 49 0E 4A A9 61 EA 61 02 2B F4 D0 EE E7 ?? ?? ?? ?? 22 23 03 60 C6 E7 ?? ?? ?? ?? 00 00 00 00 DB 0F 49 5A ?? ?? ?? ?? 00 00 00 00 00 00 00 00 FF FF EF C7 00 00 00 E0 00 00 F0 FF 00 00 00 00 }
	condition:
		$1
}

rule file_153_1_1 {
	meta:
		name = "j0f"
		size = 164
		refs = "0006 __ieee754_j0f 0016 isnanf 0028 fabsf 002e __gtsf2 0042 __extendsfdf2 0060 matherr 0072 __truncdfsf2 007a __errno 0090 __fdlib_version"
	strings:
		$1 = { F0 B5 89 B0 04 1C ?? ?? ?? ?? 21 4E 33 68 05 1C 01 33 05 D0 20 1C ?? ?? ?? ?? 07 1C 00 28 02 D0 09 B0 28 1C F0 BD 20 1C ?? ?? ?? ?? 19 49 ?? ?? ?? ?? 00 28 F4 DD 05 23 00 93 17 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 15 4B 15 4C 6D 46 AB 61 EC 61 33 68 28 61 69 61 A8 60 E9 60 02 2B 0D D0 68 46 ?? ?? ?? ?? 00 28 08 D0 2B 6A 00 2B 0A D1 A8 69 E9 69 ?? ?? ?? ?? 05 1C D2 E7 ?? ?? ?? ?? 22 23 03 60 F1 E7 ?? ?? ?? ?? 2B 6A 03 60 EF E7 C0 46 ?? ?? ?? ?? DB 0F 49 5A ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_190_1_1 {
	meta:
		name = "j1f"
		size = 164
		refs = "0006 __ieee754_j1f 0016 isnanf 0028 fabsf 002e __gtsf2 0042 __extendsfdf2 0060 matherr 0072 __truncdfsf2 007a __errno 0090 __fdlib_version"
	strings:
		$1 = { F0 B5 89 B0 04 1C ?? ?? ?? ?? 21 4E 33 68 05 1C 01 33 05 D0 20 1C ?? ?? ?? ?? 07 1C 00 28 02 D0 09 B0 28 1C F0 BD 20 1C ?? ?? ?? ?? 19 49 ?? ?? ?? ?? 00 28 F4 DD 05 23 00 93 17 4B 20 1C 01 93 08 97 ?? ?? ?? ?? 15 4B 15 4C 6D 46 AB 61 EC 61 33 68 28 61 69 61 A8 60 E9 60 02 2B 0D D0 68 46 ?? ?? ?? ?? 00 28 08 D0 2B 6A 00 2B 0A D1 A8 69 E9 69 ?? ?? ?? ?? 05 1C D2 E7 ?? ?? ?? ?? 22 23 03 60 F1 E7 ?? ?? ?? ?? 2B 6A 03 60 EF E7 C0 46 ?? ?? ?? ?? DB 0F 49 5A ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_156_0_1 {
	meta:
		name = "sin"
		size = 180
		refs = "001e __subdf3 002e __ieee754_rem_pio2 004e __kernel_sin 0086 __kernel_cos"
	strings:
		$1 = { 10 B5 27 4C 0B 1C 21 1C 02 1C 01 40 25 48 85 B0 81 42 1F DD 24 48 81 42 05 DD 10 1C 19 1C ?? ?? ?? ?? 05 B0 10 BD 01 AC 10 1C 19 1C 22 1C ?? ?? ?? ?? 03 23 18 40 01 28 21 D0 02 28 13 D0 00 28 24 D1 A2 68 E3 68 20 68 61 68 01 24 00 94 ?? ?? ?? ?? E6 E7 00 21 00 91 10 1C 19 1C 13 4A 14 4B ?? ?? ?? ?? DD E7 A2 68 E3 68 20 68 61 68 01 24 00 94 ?? ?? ?? ?? 80 23 1B 06 C0 18 D1 E7 A2 68 E3 68 01 98 02 99 ?? ?? ?? ?? CA E7 A2 68 E3 68 20 68 61 68 ?? ?? ?? ?? 80 23 1B 06 C0 18 C0 E7 FF FF FF 7F FB 21 E9 3F FF FF EF 7F 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_157_0_1 {
	meta:
		name = "__ieee754_log"
		size = 1064
		refs = "004c __subdf3 0060 __eqdf2 008a __muldf3 00a2 __adddf3 00ba __divdf3 00da __floatsidf"
	strings:
		$1 = { F0 B5 47 46 80 B4 02 1C 0B 1C 05 1C 04 1C 08 1C C6 49 8A B0 8D 42 2F DD C5 48 00 21 84 42 3E DC C4 48 C2 4F 09 18 20 15 08 18 C3 49 3C 40 65 18 80 21 49 03 29 40 C1 4D 4D 40 2A 1C 09 15 40 18 22 43 19 1C 80 46 10 1C BD 4A BE 4B ?? ?? ?? ?? A3 1C 1F 40 05 1C 0E 1C 02 2F 31 DC BA 4A BB 4B ?? ?? ?? ?? 00 28 00 D0 B2 E0 43 46 00 2B 00 D0 AE E1 B5 48 B5 49 16 E0 69 00 18 D0 00 2C 00 DA 2B E1 10 1C 19 1C B2 4A B2 4B ?? ?? ?? ?? 02 1C 04 1C A7 48 0B 1C 36 21 49 42 84 42 C0 DD 10 1C 19 1C ?? ?? ?? ?? 0A B0 04 BC 90 46 F0 BD 00 28 E4 D1 A5 4A A5 4B A8 48 A8 49 ?? ?? ?? ?? F2 E7 A7 4A A8 4B ?? ?? ?? ?? 02 1C 0B 1C 28 1C 31 1C ?? ?? ?? ?? 04 90 05 91 40 46 ?? ?? ?? ?? 06 90 07 91 04 98 05 99 02 1C 0B 1C ?? ?? ?? ?? 02 90 03 91 9D 49 67 18 02 98 03 99 02 1C 0B 1C ?? ?? ?? ?? 9A 4A 9A 4B 00 90 01 91 ?? ?? ?? ?? 99 4A 99 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 97 4A 97 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 95 4A 95 4B ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 93 4A 93 4B 02 90 03 91 00 98 01 99 ?? ?? ?? ?? 91 4A 91 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 8F 4A 8F 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 0B 1C 02 1C 02 98 03 99 ?? ?? ?? ?? 8A 4B 1C 1B 27 43 02 90 03 91 00 2F 48 DD 87 4A 88 4B 28 1C 31 1C ?? ?? ?? ?? 33 1C 2A 1C ?? ?? ?? ?? 43 46 00 90 01 91 00 2B 68 D1 02 9A 03 9B ?? ?? ?? ?? 04 9A 05 9B ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 28 1C 31 1C ?? ?? ?? ?? 6A E7 2A 1C 33 1C 28 1C 31 1C ?? ?? ?? ?? 74 4A 75 4B 00 90 01 91 28 1C 31 1C ?? ?? ?? ?? 6E 4A 6F 4B ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 00 90 01 91 40 46 00 28 00 D0 6F E0 28 1C 31 1C 00 9A 01 9B ?? ?? ?? ?? 45 E7 40 46 00 28 00 D1 EE E0 06 98 07 99 64 4A 64 4B ?? ?? ?? ?? 02 9A 03 9B 00 90 01 91 28 1C 31 1C ?? ?? ?? ?? 04 9A 05 9B ?? ?? ?? ?? 5E 4A 5E 4B 04 90 05 91 06 98 07 99 ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 16 E7 06 98 07 99 4E 4A 4F 4B ?? ?? ?? ?? 02 9A 03 9B 08 90 09 91 00 98 01 99 ?? ?? ?? ?? 04 9A 05 9B ?? ?? ?? ?? 4A 4A 4B 4B 04 90 05 91 06 98 07 99 ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 02 1C 0B 1C 08 98 09 99 ?? ?? ?? ?? E5 E6 10 1C 19 1C ?? ?? ?? ?? 19 4A 19 4B ?? ?? ?? ?? DC E6 40 46 ?? ?? ?? ?? 31 4A 31 4B 04 90 05 91 ?? ?? ?? ?? 30 4A 30 4B 02 90 03 91 04 98 05 99 ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? BC E6 FF FF 0F 00 FF FF EF 7F 01 FC FF FF 64 5F 09 00 00 00 F0 3F 00 00 F0 3F 00 00 00 00 00 00 00 00 00 00 00 00 00 00 50 43 00 00 00 00 00 00 50 C3 00 00 00 00 00 00 00 40 00 00 00 00 86 EB F9 FF 12 F1 C2 3F 44 52 3E DF 64 46 C7 3F DE 03 CB 96 24 49 D2 3F 59 93 22 94 55 55 E5 3F 93 55 55 55 09 9A C3 3F 9F C6 78 D0 C5 71 CC 3F AF 78 8E 1D 99 99 D9 3F 04 FA 97 99 51 B8 06 00 00 00 E0 3F 00 00 00 00 55 55 D5 BF 55 55 55 55 42 2E E6 3F 00 00 E0 FE EF 39 EA BD 76 3C 79 35 EF 39 EA 3D 76 3C 79 35 40 46 ?? ?? ?? ?? 11 4B 0F 4A 04 1C 0D 1C ?? ?? ?? ?? 0F 4A 0F 4B 06 1C 0F 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 52 E6 02 9A 03 9B 28 1C 31 1C ?? ?? ?? ?? 04 9A 05 9B ?? ?? ?? ?? D5 E6 C0 46 42 2E E6 3F 00 00 E0 FE EF 39 EA 3D 76 3C 79 35 }
	condition:
		$1
}

rule file_158_0_1 {
	meta:
		name = "floor"
		size = 332
		refs = "0038 __adddf3 0040 __gtdf2"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 02 1C 0B 1C 04 1C 0D 1C 80 46 89 46 8A 46 41 00 44 48 49 0D 0E 18 13 2E 20 DC 00 2E 49 DB 41 4C 34 41 14 42 42 D0 10 1C 19 1C 3F 4A 40 4B ?? ?? ?? ?? 3F 4A 40 4B ?? ?? ?? ?? 00 28 4A DD 42 46 00 2A 62 DB 41 46 A1 43 00 27 0A 1C 3B 1C 10 1C 19 1C 1C BC 90 46 99 46 A2 46 F0 BD 33 2E 0A DD 80 21 C9 00 8E 42 F2 D1 10 1C 19 1C ?? ?? ?? ?? 02 1C 0B 1C EB E7 30 48 0F 18 01 20 40 42 F8 40 07 1C 18 42 E3 D0 10 1C 19 1C 27 4A 28 4B ?? ?? ?? ?? 27 4A 28 4B ?? ?? ?? ?? 00 28 1F DD 00 2C 20 DB 2B 1C BB 43 41 46 1F 1C 15 E0 00 2B CE D0 B9 E7 10 1C 19 1C 1C 4A 1D 4B ?? ?? ?? ?? 1C 4A 1D 4B ?? ?? ?? ?? 00 28 09 DD 00 2C 16 DB 00 27 00 21 01 E0 41 46 57 46 0A 1C 3B 1C B7 E7 21 1C 2F 1C F9 E7 14 2E 18 D0 34 23 9E 1B 01 23 B3 40 4B 44 99 45 D6 D9 01 20 80 44 D3 E7 61 00 01 D1 00 2D 07 D0 00 27 0D 49 E6 E7 80 23 5B 03 33 41 98 44 97 E7 21 1C 00 27 DE E7 01 23 98 44 C0 E7 C0 46 01 FC FF FF FF FF 0F 00 3C E4 37 7E 9C 75 00 88 00 00 00 00 00 00 00 00 ED FB FF FF 00 00 F0 BF }
	condition:
		$1
}

rule file_159_0_1 {
	meta:
		name = "remainderf"
		size = 184
		refs = "000c __ieee754_remainderf 001c isnanf 002a __eqsf2 0040 __extendsfdf2 005c __divdf3 006c matherr 007e __truncdfsf2 008e __errno 00a4 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 89 B0 07 1C 0C 1C ?? ?? ?? ?? 24 4E 33 68 05 1C 01 33 34 D0 20 1C ?? ?? ?? ?? 80 46 00 28 2E D1 20 1C 1F 49 ?? ?? ?? ?? 00 28 28 D1 01 23 00 93 1D 4B 38 1C 01 93 43 46 08 93 ?? ?? ?? ?? 6D 46 A8 60 E9 60 20 1C ?? ?? ?? ?? 28 61 69 61 16 48 17 49 0B 1C 02 1C ?? ?? ?? ?? 33 68 A8 61 E9 61 02 2B 11 D0 68 46 ?? ?? ?? ?? 00 28 0C D0 2B 6A 00 2B 0E D1 A8 69 E9 69 ?? ?? ?? ?? 05 1C 09 B0 28 1C 04 BC 90 46 F0 BD ?? ?? ?? ?? 21 23 03 60 ED E7 ?? ?? ?? ?? 2B 6A 03 60 EB E7 C0 46 ?? ?? ?? ?? 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_162_0_1 {
	meta:
		name = "asin"
		size = 180
		refs = "000c __ieee754_asin 0020 __isnand 003a fabs 0042 __gtdf2 0062 nan 0072 matherr 008a __errno 00a0 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8B B0 04 1C 0D 1C ?? ?? ?? ?? 23 4E 33 68 00 90 01 91 01 33 06 D0 20 1C 29 1C ?? ?? ?? ?? 80 46 00 28 05 D0 00 98 01 99 0B B0 04 BC 90 46 F0 BD 20 1C 29 1C ?? ?? ?? ?? 19 4A 19 4B ?? ?? ?? ?? 00 28 EF DD 01 23 02 93 17 4B 02 AF 7B 60 43 46 3B 62 3C 61 7D 61 BC 60 FD 60 13 48 ?? ?? ?? ?? 33 68 B8 61 F9 61 02 2B 0C D0 38 1C ?? ?? ?? ?? 00 28 07 D0 3B 6A 00 2B 09 D1 BB 69 FC 69 00 93 01 94 CF E7 ?? ?? ?? ?? 21 23 03 60 F2 E7 ?? ?? ?? ?? 3B 6A 03 60 F0 E7 C0 46 ?? ?? ?? ?? 00 00 F0 3F 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_166_0_1 {
	meta:
		name = "acos"
		size = 180
		refs = "000c __ieee754_acos 0020 __isnand 003a fabs 0042 __gtdf2 0062 nan 0072 matherr 008a __errno 00a0 __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 8B B0 04 1C 0D 1C ?? ?? ?? ?? 23 4E 33 68 00 90 01 91 01 33 06 D0 20 1C 29 1C ?? ?? ?? ?? 80 46 00 28 05 D0 00 98 01 99 0B B0 04 BC 90 46 F0 BD 20 1C 29 1C ?? ?? ?? ?? 19 4A 19 4B ?? ?? ?? ?? 00 28 EF DD 01 23 02 93 17 4B 02 AF 7B 60 43 46 3B 62 3C 61 7D 61 BC 60 FD 60 13 48 ?? ?? ?? ?? 33 68 B8 61 F9 61 02 2B 0C D0 38 1C ?? ?? ?? ?? 00 28 07 D0 3B 6A 00 2B 09 D1 BB 69 FC 69 00 93 01 94 CF E7 ?? ?? ?? ?? 21 23 03 60 F2 E7 ?? ?? ?? ?? 3B 6A 03 60 F0 E7 C0 46 ?? ?? ?? ?? 00 00 F0 3F 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_164_0_1 {
	meta:
		name = "log1pf"
		size = 812
		refs = "0028 __eqsf2 0036 __divsf3 0060 __subsf3 006a __mulsf3 0098 __addsf3 00c0 __gtsf2 019a __floatsisf"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 AB 4B 07 1C 06 1C 98 42 3F DC AA 4B 98 42 10 DC A9 4B AA 4A 03 40 93 42 42 DD A9 49 ?? ?? ?? ?? 00 28 00 D0 F6 E0 A7 48 A7 49 ?? ?? ?? ?? 07 1C 2F E0 A6 4B 98 42 52 DD A3 4B C5 15 7F 3D 99 46 A3 4B 1E 40 A3 4B 9E 42 00 DD C7 E0 FE 20 80 05 30 43 A1 49 ?? ?? ?? ?? A0 49 04 1C 07 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 80 46 82 46 00 2E 55 D1 20 1C 94 49 ?? ?? ?? ?? 00 28 00 D0 B6 E0 00 2D 00 D0 F6 E0 90 4F 03 E0 39 1C ?? ?? ?? ?? 07 1C 38 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 8F 4A 93 42 17 DC 8F 4A 93 42 07 DC 8E 49 ?? ?? ?? ?? 85 49 ?? ?? ?? ?? 00 28 EA DC 39 1C 38 1C ?? ?? ?? ?? 89 49 ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 07 1C DD E7 86 4B C6 18 9E 42 16 D8 38 1C 7D 49 ?? ?? ?? ?? C5 15 7F 3D 04 1C 06 1C 00 2D 00 DC D5 E0 39 1C ?? ?? ?? ?? 01 1C 76 48 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 81 46 99 E7 73 49 ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 00 25 82 46 75 49 38 1C ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 06 1C 31 1C ?? ?? ?? ?? 70 49 04 1C ?? ?? ?? ?? 6F 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 6D 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 6B 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 69 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 67 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 65 49 ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 80 46 00 2D 4C D0 28 1C ?? ?? ?? ?? 60 49 04 1C ?? ?? ?? ?? 41 46 83 46 50 46 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 5B 49 05 1C 20 1C ?? ?? ?? ?? 49 46 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 01 1C 50 46 ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 01 1C 58 46 ?? ?? ?? ?? 07 1C 5A E7 FC 20 80 23 80 05 1B 04 30 43 9E 1B 01 35 B6 10 31 E7 4B 49 20 1C ?? ?? ?? ?? 38 49 ?? ?? ?? ?? 41 46 ?? ?? ?? ?? 06 1C 00 2D 1F D1 20 1C 31 1C ?? ?? ?? ?? 07 1C 3E E7 39 1C 38 1C ?? ?? ?? ?? 01 1C ?? ?? ?? ?? 07 1C 35 E7 41 46 50 46 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 01 1C 50 46 ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 07 1C 24 E7 28 1C ?? ?? ?? ?? 31 49 05 1C ?? ?? ?? ?? 30 49 07 1C 28 1C ?? ?? ?? ?? 01 1C 48 46 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 21 1C E1 E7 28 1C ?? ?? ?? ?? 26 49 04 1C ?? ?? ?? ?? 25 49 05 1C 20 1C ?? ?? ?? ?? 01 1C 48 46 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 07 1C F8 E6 0D 49 ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 28 E7 FF FF 7F 7F D6 13 D4 3E FF FF FF 7F FF FF 7F 3F 00 00 80 BF 00 00 00 CC 00 00 00 00 FF FF FF 59 FF FF 7F 00 F6 04 35 00 00 00 80 3F 00 00 00 3F FF FF FF 30 FF FF 7F 24 00 00 00 4C 00 00 00 BF E0 09 6A 41 00 00 00 40 97 88 17 3E 4F D0 1C 3E 25 33 3A 3E 29 8E 63 3E 25 49 92 3E CD CC CC 3E AB AA 2A 3F 80 71 31 3F D1 F7 17 37 AB AA 2A BF }
	condition:
		$1
}

rule file_165_0_1 {
	meta:
		name = "expm1"
		size = 1204
		refs = "003c __adddf3 0062 __muldf3 0096 __subdf3 0116 __divdf3 01b2 __gtdf2 01d0 __ltdf2 01f2 __fixdfsi 01f8 __floatsidf"
	strings:
		$1 = { F0 B5 47 46 80 B4 C2 4A 03 1C 80 26 13 40 C1 4A 36 06 86 B0 04 1C 0D 1C 06 40 93 42 13 D9 BE 4A 93 42 00 D8 CA E0 BD 4A 93 42 00 D8 BF E0 18 03 00 D1 64 E1 20 1C 29 1C 22 1C 2B 1C ?? ?? ?? ?? 04 1C 0D 1C 13 E1 B6 4A 93 42 00 D9 1A E1 B5 4A 93 42 00 D8 3E E1 00 21 88 46 B3 4A B3 4B 20 1C 29 1C ?? ?? ?? ?? 00 90 01 91 00 9A 01 9B 20 1C 29 1C ?? ?? ?? ?? AE 4A AE 4B 06 1C 0F 1C ?? ?? ?? ?? AD 4A AD 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? AB 4A AB 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? A9 4A A9 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? A7 4A A7 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? A5 4A A5 4B ?? ?? ?? ?? 00 9A 01 9B 02 90 03 91 ?? ?? ?? ?? 02 1C 0B 1C A1 48 A1 49 ?? ?? ?? ?? 00 90 01 91 00 9A 01 9B 02 98 03 99 ?? ?? ?? ?? 00 9A 01 9B 02 90 03 91 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 98 48 98 49 ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 02 1C 40 46 0B 1C 00 28 00 D1 8F E0 10 1C 04 9A 05 9B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 04 9A 05 9B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 0F 1C 41 46 06 1C 01 31 00 D1 54 E1 42 46 01 2A 00 D1 35 E1 43 46 01 33 39 2B 00 D9 9C E0 40 46 13 28 00 DD 58 E1 78 49 78 4A 80 23 00 91 01 92 9B 03 7B 4A 03 41 D2 1A 00 92 2B 1C 22 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 04 1C 40 46 0D 1C 01 05 0C 19 5F E0 71 4A 71 4B ?? ?? ?? ?? 00 28 00 DD 4A E1 00 2E 5E D0 6E 4A 6F 4B 20 1C 29 1C ?? ?? ?? ?? 6D 4A 6E 4B ?? ?? ?? ?? 00 28 00 DA 96 E0 6C 4E 6C 4F 6D 4A 6D 4B 20 1C 29 1C ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? ?? ?? ?? ?? 80 46 ?? ?? ?? ?? 67 4A 68 4B 00 90 01 91 ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 64 4A 65 4B 06 1C 0F 1C 00 98 01 99 ?? ?? ?? ?? 00 90 01 91 00 9A 01 9B 30 1C 39 1C ?? ?? ?? ?? 04 1C 0D 1C 22 1C 2B 1C 30 1C 39 1C ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 04 90 05 91 05 E7 20 1C 29 1C ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C 06 B0 29 1C 20 1C 04 BC 90 46 F0 BD 00 2E AD D1 2A 4E 2A 4F AC E7 49 4A 93 42 F7 D8 00 2E 29 D1 48 4A 48 4B ?? ?? ?? ?? 43 4A 43 4B 0F 1C 01 21 06 1C 88 46 00 92 01 93 BD E7 22 1C 2B 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 27 48 28 49 ?? ?? ?? ?? 45 46 2A 05 10 18 24 4A 24 4B ?? ?? ?? ?? 04 1C 0D 1C CC E7 38 4A 39 4B ?? ?? ?? ?? 02 1C 0B 1C BB E7 33 4A 33 4B ?? ?? ?? ?? 01 23 06 1C 0F 1C 33 48 34 49 5C 42 A0 46 00 90 01 91 92 E7 00 29 00 D0 97 E6 00 2E B2 D0 2F 4C 30 4D AF E7 C0 46 FF FF FF 7F 79 68 43 40 41 2E 86 40 FF FF EF 7F 42 2E D6 3F FF FF 8F 3C 00 00 E0 3F 00 00 00 00 B7 FD 8A BE 2D C3 09 6E CA CF D0 3E 39 52 E6 86 19 CE 14 3F B7 DB AA 9E A0 01 5A 3F 85 55 FE 19 11 11 A1 3F F4 10 11 11 00 00 F0 3F 00 00 00 00 00 00 08 40 00 00 00 00 00 00 18 40 00 00 00 00 00 00 F0 3F 42 2E 86 40 EF 39 FA FE 1F 6E A5 01 59 F3 F8 C2 00 00 00 00 00 00 00 00 00 00 E0 BF 00 00 00 00 47 15 F7 3F FE 82 2B 65 42 2E E6 BF 00 00 E0 FE EF 39 EA 3D 76 3C 79 35 B1 A2 F0 3F 42 2E E6 3F 00 00 E0 FE 3C E4 37 7E 9C 75 00 88 EF 39 EA BD 76 3C 79 35 00 00 F0 BF 00 00 00 00 20 1C 29 1C 2D 4B 2C 4A ?? ?? ?? ?? 00 28 41 DA 2B 4A 2C 4B 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 27 4A 28 4B ?? ?? ?? ?? 04 1C 0D 1C 33 E7 20 1C 29 1C 32 1C 3B 1C ?? ?? ?? ?? 1F 4A 1F 4B ?? ?? ?? ?? 1D 4A 1D 4B ?? ?? ?? ?? 04 1C 0D 1C 22 E7 1D 49 40 46 09 1A 1D 4A 1D 4B 30 1C 0A 05 39 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 16 4A 17 4B ?? ?? ?? ?? A7 E6 16 48 16 49 02 1C 0B 1C ?? ?? ?? ?? 04 1C 0D 1C 04 E7 20 1C 29 1C 32 1C 3B 1C ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? 0A 4A 0B 4B ?? ?? ?? ?? 04 1C 0D 1C F3 E6 C0 46 00 00 D0 BF 00 00 00 00 00 00 E0 3F 00 00 00 00 00 00 00 C0 00 00 00 00 FF 03 00 00 00 00 F0 3F 00 00 00 00 3C E4 37 7E 9C 75 00 88 }
	condition:
		$1
}

rule file_168_0_1 {
	meta:
		name = "__ieee754_hypotf"
		size = 436
		refs = "0052 __mulsf3 006c __subsf3 0074 __gtsf2 00b4 __addsf3 00dc __ieee754_sqrtf"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 64 4B 04 1C 0D 1C 1C 40 1D 40 AC 42 02 DA 23 1C 2C 1C 1D 1C F0 23 62 1B 1B 05 20 1C 2E 1C 9A 42 73 DC B1 23 DB 05 9C 42 5F DC 00 23 27 1C 98 46 59 4B 9D 42 13 DC 00 2D 00 D1 9D E0 57 4B 9D 42 00 DD 9B E0 30 1C 55 49 ?? ?? ?? ?? 54 49 06 1C 38 1C ?? ?? ?? ?? 7E 23 5B 42 07 1C 98 44 31 1C 38 1C ?? ?? ?? ?? 31 1C 82 46 ?? ?? ?? ?? 00 28 53 DC 4B 4B 1D 40 80 23 1B 04 E4 18 28 1C 21 1C ?? ?? ?? ?? 80 23 1B 06 81 46 18 1C 51 46 50 44 ?? ?? ?? ?? 29 1C 82 46 30 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 39 1C 05 1C 38 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 01 1C 50 46 ?? ?? ?? ?? 01 1C 48 46 ?? ?? ?? ?? ?? ?? ?? ?? 43 46 00 2B 19 D0 D9 05 FE 23 9B 05 C9 18 ?? ?? ?? ?? 12 E0 2E 4B 9C 42 3A DD FF 23 DB 05 9C 42 02 D0 29 1C ?? ?? ?? ?? FF 23 DB 05 9D 42 04 D1 30 1C 02 E0 29 1C ?? ?? ?? ?? 1C BC 90 46 99 46 A2 46 F0 BD 21 4B 1C 40 21 1C 20 1C ?? ?? ?? ?? 80 23 1B 06 82 46 31 1C F0 18 ?? ?? ?? ?? 21 1C 06 1C 38 1C ?? ?? ?? ?? 21 1C 05 1C 38 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 01 1C 50 46 ?? ?? ?? ?? ?? ?? ?? ?? B7 E7 DE 23 1B 06 E4 18 ED 18 44 23 27 1C 2E 1C 98 46 5B E7 38 1C C9 E7 88 23 9B 05 E4 18 ED 18 44 23 5B 42 98 44 27 1C 2E 1C 66 E7 C0 46 FF FF FF 7F FF FF 7F 26 FF FF 7F 00 00 00 80 7E 00 F0 FF FF FF FF 7F 7F }
	condition:
		$1
}

rule file_169_0_1 {
	meta:
		name = "scalbf"
		size = 320
		refs = "0008 __ieee754_scalbf 0016 finitef 0022 __eqsf2 002e __nesf2 0046 __errno 0052 isnanf 0068 __gtsf2 0088 __extendsfdf2 00e0 copysign 00f0 matherr 010a __truncdfsf2 011c __fdlib_version"
	strings:
		$1 = { F0 B5 8B B0 05 1C 0F 1C ?? ?? ?? ?? 43 4E 33 68 04 1C 01 33 14 D0 ?? ?? ?? ?? 00 28 18 D0 20 1C 3F 49 ?? ?? ?? ?? 00 28 05 D1 28 1C 21 1C ?? ?? ?? ?? 00 28 3D D1 38 1C ?? ?? ?? ?? 00 28 02 D0 0B B0 20 1C F0 BD ?? ?? ?? ?? 22 23 03 60 F7 E7 20 1C ?? ?? ?? ?? 00 28 E1 D1 28 1C ?? ?? ?? ?? 00 28 DC D0 28 1C 2E 49 ?? ?? ?? ?? 00 28 50 DC 2C 4A 2D 4B 00 92 01 93 03 23 02 93 2B 4B 02 AC 63 60 00 23 23 62 28 1C ?? ?? ?? ?? A0 60 E1 60 38 1C ?? ?? ?? ?? 00 9A 01 9B A2 61 E3 61 33 68 20 61 61 61 02 2B 22 D1 ?? ?? ?? ?? 22 23 03 60 22 E0 04 23 02 93 1D 4B 02 AC 63 60 00 23 23 62 28 1C ?? ?? ?? ?? 00 90 01 91 A0 60 E1 60 38 1C ?? ?? ?? ?? 00 9A 01 9B 20 61 61 61 14 48 15 49 ?? ?? ?? ?? 33 68 A0 61 E1 61 02 2B DC D0 20 1C ?? ?? ?? ?? 00 28 D7 D0 23 6A 00 2B 03 D0 ?? ?? ?? ?? 23 6A 03 60 A0 69 E1 69 ?? ?? ?? ?? 04 1C 96 E7 09 4B 09 4C 00 93 01 94 AD E7 ?? ?? ?? ?? 00 00 00 00 00 00 F0 FF 00 00 00 00 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_173_0_1 {
	meta:
		name = "__ieee754_sinh"
		size = 456
		refs = "0036 __adddf3 003e __gtdf2 004a fabs 004e expm1 006e __muldf3 008a __divdf3 0096 __subdf3 0100 __ieee754_exp"
	strings:
		$1 = { F0 B5 61 4E 61 4A 06 40 84 B0 04 1C 0D 1C 96 42 4D DC 00 28 00 DA 63 E0 5D 4A 5E 4B 00 92 01 93 5D 4B 9E 42 4A DC 5D 4B 9E 42 00 DD 7B E0 5C 4A 5C 4B 20 1C 29 1C ?? ?? ?? ?? 5B 4A 5B 4B ?? ?? ?? ?? 00 28 2F DC 20 1C 29 1C ?? ?? ?? ?? ?? ?? ?? ?? 04 1C 0D 1C 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 22 1C 02 90 03 91 2B 1C 20 1C 29 1C ?? ?? ?? ?? 4D 4A 4D 4B 06 1C 0F 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 04 1C 0D 1C 04 B0 29 1C 20 1C F0 BD 22 1C 2B 1C ?? ?? ?? ?? 04 1C 0D 1C F4 E7 3C 4B 9E 42 54 DD 3C 4B 9E 42 13 DD 01 33 9E 42 0D D0 20 1C 29 1C 33 4A 33 4B ?? ?? ?? ?? 04 1C 0D 1C E2 E7 35 4A 36 4B 00 92 01 93 9A E7 35 4B 9D 42 EE D8 20 1C 29 1C ?? ?? ?? ?? 25 4A 26 4B ?? ?? ?? ?? ?? ?? ?? ?? 04 1C 0D 1C 22 1C 2B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C BF E7 20 1C 29 1C ?? ?? ?? ?? ?? ?? ?? ?? 24 4B 04 1C 0D 1C 9E 42 00 DC 8B E7 1A 4A 1A 4B ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 04 1C 0D 1C 9C E7 20 1C 29 1C ?? ?? ?? ?? ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 04 1C 0D 1C 8F E7 C0 46 FF FF FF 7F FF FF EF 7F 00 00 E0 3F 00 00 00 00 FF FF 35 40 FF FF 2F 3E 1F 7B AC 7F 33 74 AC 3C 00 00 F0 3F 00 00 00 00 41 2E 86 40 CD 33 86 40 00 00 E0 BF 00 00 00 00 7D F8 B9 8F FF FF EF 3F }
	condition:
		$1
}

rule file_174_0_1 {
	meta:
		name = "__ieee754_atan2f"
		size = 316
		refs = "001c __addsf3 0086 __subsf3 0098 atanf 00a2 __divsf3 00a6 fabsf"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 40 4B 0E 1C 1E 40 03 40 9A 46 FF 23 DB 05 05 1C 9E 42 05 DD ?? ?? ?? ?? 0C BC 90 46 9A 46 F0 BD 9A 45 F7 DC FE 24 A4 05 A1 42 31 D0 02 27 8C 17 3C 40 A4 46 67 46 C4 0F 3C 43 A0 46 54 46 00 2C 06 D1 47 46 02 2F 21 D0 03 2F E5 D1 2E 48 E3 E7 00 2E 17 D0 9E 42 29 D0 9A 45 13 D0 57 46 BE 1B F6 15 3C 2E 17 DD 29 48 43 46 01 2B 35 D0 02 2B 2B D0 00 2B D0 D0 26 49 ?? ?? ?? ?? 25 49 ?? ?? ?? ?? C9 E7 00 2D 0F DB 20 48 C5 E7 21 48 C3 E7 ?? ?? ?? ?? C0 E7 3C 36 13 DB ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? DF E7 1B 48 B5 E7 B2 45 18 D0 44 46 02 2C EA D0 03 2C C8 D0 01 2C 1A D0 17 48 AA E7 00 29 E9 DA 15 48 CE E7 11 49 ?? ?? ?? ?? 01 1C 10 48 ?? ?? ?? ?? 9E E7 80 24 24 06 00 19 9A E7 43 46 02 2B 0B D0 03 2B 07 D0 01 2B 03 D0 0B 48 91 E7 0B 48 8F E7 0B 48 8D E7 0B 48 8B E7 0B 48 89 E7 FF FF FF 7F DB 0F 49 C0 DB 0F C9 3F 2E BD BB 33 DB 0F 49 40 DB 0F C9 BF 00 00 00 00 DB 0F 49 3F 00 00 00 80 DB 0F 49 BF E4 CB 16 C0 E4 CB 16 40 }
	condition:
		$1
}

rule file_176_0_1 {
	meta:
		name = "tgammaf"
		size = 144
		refs = "0008 __ieee754_gammaf_r 001e finitef 0038 floorf 003e __eqsf2 004a __lesf2 0054 __extendsfdf2 0064 __kernel_standard 0068 __truncdfsf2 0088 __fdlib_version"
	strings:
		$1 = { 30 B5 82 B0 01 A9 05 1C ?? ?? ?? ?? 01 9B 04 1C 00 2B 2D DB 1C 4B 1B 68 01 33 04 D0 20 1C ?? ?? ?? ?? 00 28 02 D0 02 B0 20 1C 30 BD 28 1C ?? ?? ?? ?? 00 28 F7 D0 28 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 00 28 05 D1 28 1C 10 49 ?? ?? ?? ?? 00 28 12 DD 28 1C ?? ?? ?? ?? 0B 1C 02 1C 8C 21 00 91 10 1C 19 1C ?? ?? ?? ?? ?? ?? ?? ?? 04 1C DA E7 80 23 1B 06 C4 18 CD E7 28 1C ?? ?? ?? ?? 0B 1C 02 1C 8D 21 EB E7 C0 46 ?? ?? ?? ?? 00 00 00 00 }
	condition:
		$1
}

rule file_177_0_1 {
	meta:
		name = "nextafter"
		size = 312
		refs = "002c __adddf3 0066 __eqdf2 009e __muldf3 00a6 __nedf2"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 46 4F 0D 1C 06 1C 8A 46 45 49 37 40 04 1C 90 46 99 46 8F 42 13 DD 42 48 39 18 00 29 0C D0 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C 29 1C 20 1C 1C BC 90 46 99 46 A2 46 F0 BD 51 46 00 29 EF D1 36 49 40 46 01 40 36 48 81 42 06 DD 35 48 09 18 00 29 E5 D1 49 46 00 29 E2 D1 20 1C 29 1C ?? ?? ?? ?? 00 28 E2 D0 00 2F 1C D0 00 2E 45 DB 46 45 33 DC 46 45 2F D0 57 46 01 37 00 2F 4B D0 2A 4B 32 1C 1A 40 9A 42 2F D0 28 4B 9A 42 20 DC 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 15 E0 53 46 00 2B DF D1 80 23 1B 06 44 46 1C 40 01 25 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 22 1C 2B 1C 06 1C 0F 1C ?? ?? ?? ?? 00 28 AD D1 34 1C 3D 1C AA E7 CA 45 CD D9 50 46 00 28 00 D1 01 3E 57 46 01 3F CA E7 20 1C 29 1C 22 1C 2B 1C ?? ?? ?? ?? 04 1C 0D 1C 98 E7 46 45 06 DC 41 46 00 29 03 DA 46 45 B6 D1 CA 45 B4 D9 53 46 00 2B E7 D1 01 3E E5 E7 01 36 B1 E7 C0 46 FF FF FF 7F FF FF EF 7F 00 00 10 80 00 00 F0 7F FF FF 0F 00 }
	condition:
		$1
}

rule file_179_0_1 {
	meta:
		name = "__ieee754_logf"
		size = 696
		refs = "0048 __subsf3 005a __eqsf2 0072 __divsf3 0084 __mulsf3 009c __addsf3 00b4 __floatsisf"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 01 1C 04 1C 43 00 2C D0 00 28 3B DB 91 4B 98 42 3E DC 91 4B 98 42 2E DD 7F 23 5B 42 E7 15 8E 4E FF 18 8E 4B 34 40 E0 18 80 23 1B 04 18 40 FE 23 9B 05 C2 15 58 40 20 43 89 49 BF 18 ?? ?? ?? ?? 23 1C 0F 33 1E 40 05 1C 0F 2E 24 DC 85 49 ?? ?? ?? ?? 00 28 00 D0 80 E0 00 2F 00 D0 C6 E0 81 48 03 E0 81 48 7F 49 ?? ?? ?? ?? 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 7D 49 ?? ?? ?? ?? 98 23 04 1C 5B 42 CB E7 ?? ?? ?? ?? 76 49 ?? ?? ?? ?? EC E7 ?? ?? ?? ?? E9 E7 76 49 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 82 46 38 1C ?? ?? ?? ?? 51 46 83 46 50 46 ?? ?? ?? ?? 6F 4B 80 46 1B 19 41 46 99 46 ?? ?? ?? ?? 6C 49 06 1C ?? ?? ?? ?? 6B 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 69 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 67 49 ?? ?? ?? ?? 41 46 ?? ?? ?? ?? 65 49 80 46 30 1C ?? ?? ?? ?? 64 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 62 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 01 1C 40 46 ?? ?? ?? ?? 5E 4B 1C 1B 4B 46 1C 43 06 1C 00 2C 72 DD 5B 49 28 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 04 1C 00 2F 31 D1 31 1C ?? ?? ?? ?? 51 46 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 87 E7 29 1C 28 1C ?? ?? ?? ?? 4E 49 04 1C 28 1C ?? ?? ?? ?? 4A 49 ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 04 1C 00 2F 30 D0 38 1C ?? ?? ?? ?? 46 49 06 1C ?? ?? ?? ?? 45 49 07 1C 30 1C ?? ?? ?? ?? 21 1C ?? ?? ?? ?? 18 E0 3F 49 58 46 ?? ?? ?? ?? 31 1C 07 1C 20 1C ?? ?? ?? ?? 51 46 ?? ?? ?? ?? 3B 49 06 1C 58 46 ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 01 1C 38 1C ?? ?? ?? ?? 43 E7 28 1C 21 1C ?? ?? ?? ?? 3E E7 38 1C ?? ?? ?? ?? 2B 49 04 1C ?? ?? ?? ?? 2B 49 05 1C 20 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 2D E7 00 2F 13 D0 23 49 58 46 ?? ?? ?? ?? 31 1C 07 1C 28 1C ?? ?? ?? ?? 51 46 ?? ?? ?? ?? 1E 49 04 1C 58 46 ?? ?? ?? ?? 01 1C 20 1C AF E7 31 1C 28 1C ?? ?? ?? ?? 51 46 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 0B E7 C0 46 FF FF 7F 7F FF FF 7F 00 20 FB 4A 00 00 00 80 3F 00 00 00 00 00 00 00 CC 00 00 00 4C 00 00 00 40 30 5C CF FF 97 88 17 3E 25 33 3A 3E 25 49 92 3E AB AA 2A 3F 4F D0 1C 3E 29 8E 63 3E CD CC CC 3E 88 C2 35 00 00 00 00 3F AB AA AA BE 80 71 31 3F D1 F7 17 B7 D1 F7 17 37 }
	condition:
		$1
}

rule file_180_0_1 {
	meta:
		name = "remquof"
		size = 58
		refs = "0018 __divsf3 001c fabsf 0020 lrintf 0030 remainderf"
	strings:
		$1 = { F0 B5 17 1C CB 0F C2 0F 05 1C 0C 1C 9A 42 12 D0 01 26 76 42 21 1C 28 1C ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 7F 23 18 40 46 43 21 1C 3E 60 28 1C ?? ?? ?? ?? F0 BD 01 26 EC E7 }
	condition:
		$1
}

rule file_183_0_1 {
	meta:
		name = "sinf"
		size = 136
		refs = "0016 __subsf3 0020 __ieee754_rem_pio2f 003a __kernel_sinf 0060 __kernel_cosf"
	strings:
		$1 = { 00 B5 1D 4B 1D 4A 03 40 82 B0 01 1C 93 42 17 DD 1B 4A 93 42 03 DD ?? ?? ?? ?? 02 B0 00 BD 69 46 ?? ?? ?? ?? 03 23 18 40 01 28 17 D0 02 28 0C D0 00 28 18 D1 00 98 01 99 01 22 ?? ?? ?? ?? EC E7 10 49 00 22 ?? ?? ?? ?? E7 E7 00 98 01 99 01 22 ?? ?? ?? ?? 80 23 1B 06 C0 18 DE E7 00 98 01 99 ?? ?? ?? ?? D9 E7 00 98 01 99 ?? ?? ?? ?? 80 23 1B 06 C0 18 D1 E7 C0 46 FF FF FF 7F D8 0F 49 3F FF FF 7F 7F 00 00 00 00 }
	condition:
		$1
}

rule file_184_0_1 {
	meta:
		name = "__kernel_standard"
		size = 4636
		refs = "0056 matherr 0068 __errno 01d4 copysign 0278 __gtdf2 02c8 __divdf3 039c __fdlib_version 04b4 __ltdf2 0bb6 __muldf3 0bbe rint 0bc6 __nedf2"
	strings:
		$1 = { F0 B5 8B B0 1E 1C 10 9B 02 AC 15 1C 00 22 00 90 01 91 A0 60 E1 60 25 61 66 61 22 62 8E 2B 27 D8 DC 49 9A 00 8A 58 97 46 63 2B 01 DC 00 F0 1C FD D9 4A 01 23 02 93 62 60 00 9A 01 9B A2 61 E3 61 D6 4B 1B 68 02 2B 01 D1 00 F0 C4 FB 01 33 01 D1 00 F0 C0 FB 20 1C ?? ?? ?? ?? 00 28 01 D1 01 F0 BE F8 23 6A 00 2B 03 D0 ?? ?? ?? ?? 23 6A 03 60 0B B0 A0 69 E1 69 F0 BD 63 2B 01 DC 00 F0 09 FD C7 4A 02 23 02 93 C5 4B 1B 68 62 60 00 2B 01 D0 00 F0 1B FD C3 4A C4 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 B0 FF 23 6A DA E7 63 2B 01 DC 00 F0 DC FC BA 4A 03 23 02 93 B7 4B 1B 68 62 60 00 2B 01 D0 00 F0 F1 FC B6 4A B6 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 87 FF 23 6A BF E7 63 2B 01 DC 00 F0 C4 FC AF 4A 05 23 02 93 62 60 AE 4A AF 4B A2 61 E3 61 A7 4B 1B 68 02 2B 01 D1 00 F0 26 FF 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 73 FF 23 6A A4 E7 63 2B 01 DC 00 F0 98 FC A5 4A 05 23 02 93 62 60 A1 4A A1 4B A2 61 E3 61 9A 4B 1B 68 02 2B 01 D1 00 F0 C3 FE 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 DD FF 23 6A 89 E7 63 2B 01 DC 00 F0 9A FC 98 4A 05 23 02 93 62 60 93 4A 94 4B A2 61 E3 61 8C 4B 1B 68 02 2B 01 D1 00 F0 AF FE 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 1A FF 23 6A 6E E7 63 2B 01 DC 00 F0 7C FC 8C 4A 05 23 02 93 62 60 86 4A 86 4B A2 61 E3 61 7F 4B 1B 68 02 2B 01 D1 00 F0 B7 FE 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 06 FF 23 6A 53 E7 63 2B 01 DC 00 F0 5B FC 7F 4A 04 23 02 93 62 60 78 48 79 49 00 9A 01 9B ?? ?? ?? ?? 70 4B 1B 68 A0 61 E1 61 02 2B 01 D1 00 F0 BD FE 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 11 FF 23 6A 34 E7 63 2B 01 DC 00 F0 3F FC 71 4A 05 23 02 93 62 60 69 4A 69 4B A2 61 E3 61 62 4B 1B 68 02 2B 01 D1 00 F0 76 FE 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 74 FF 23 6A 19 E7 63 2B 01 DC 00 F0 DC FB 64 4A 05 23 02 93 62 60 5B 4A 5C 4B A2 61 E3 61 54 4B 1B 68 02 2B 01 D1 00 F0 0E FE 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 8A FF 23 6A FE E6 63 2B 01 DC 00 F0 19 FC 55 4D 00 98 01 99 4E 4A 4F 4B ?? ?? ?? ?? 00 28 01 DD 00 F0 0A FC 52 49 53 4A 03 23 02 93 43 4B 1B 68 65 60 A1 61 E2 61 02 2B 01 D1 00 F0 2F FE 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 93 FE 23 6A D9 E6 63 2B 01 DC 00 F0 F7 FB 47 4A 3D 48 3D 49 01 23 02 93 62 60 0B 1C 02 1C ?? ?? ?? ?? 33 4B 1B 68 A0 61 E1 61 02 2B 01 D1 00 F0 25 FE 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 7B FE 23 6A BA E6 63 2B 00 DC 80 E3 39 4A 2E 48 2E 49 01 23 02 93 62 60 0B 1C 02 1C ?? ?? ?? ?? 24 4B 1B 68 A0 61 E1 61 02 2B 01 D1 00 F0 B3 FD 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 C6 FE 23 6A 9C E6 63 2B 00 DC 93 E3 2B 4A 02 23 02 93 19 4B 1B 68 62 60 00 2B 01 D0 00 F0 E6 FC 27 4A 28 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 74 FE 23 6A 82 E6 63 2B 00 DC 7B E3 21 4A 03 23 02 93 0C 4B 1B 68 62 60 00 2B 01 D0 00 F0 DB FC 0A 4A 0B 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 61 FE 23 6A 68 E6 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF EF 47 00 00 00 E0 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 F0 FF 00 00 00 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF EF C7 00 00 00 E0 ?? ?? ?? ?? 63 2B 00 DC 01 E3 DD 4A 01 23 02 93 DC 4B 1B 68 62 60 00 2B 01 D0 00 F0 66 FC DA 4A DA 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 81 FE 23 6A 1F E6 63 2B 00 DC 0D E3 D4 4A 01 23 02 93 CF 4B 1D 68 62 60 00 2D 01 D0 00 F0 87 FC D0 4A D0 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 A3 FD 23 6A 05 E6 63 2B 00 DC 00 E3 C7 4A 04 23 02 93 62 60 C6 4A C6 4B A2 61 E3 61 C0 4B 1B 68 02 2B 01 D1 00 F0 10 FD 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 90 FD 23 6A EB E5 63 2B 00 DC C7 E2 BA 4A B6 4F 03 23 02 93 3B 68 62 60 00 2B 00 D0 77 E3 B8 4A B9 4B 00 98 01 99 A2 61 E3 61 B3 4A B4 4B ?? ?? ?? ?? 00 28 01 DA 00 F0 77 FE 3B 68 02 2B 01 D1 00 F0 12 FD 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 5D FE 23 6A C3 E5 63 2B 00 DC AB E2 AB 4A 01 23 02 93 A1 4B 1B 68 62 60 00 2B 01 D0 00 F0 97 FC 9F 4A 9F 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 EF FD 23 6A A9 E5 63 2B 00 DC 99 E2 9F 4A 03 23 02 93 94 4B 1B 68 62 60 00 2B 01 D0 00 F0 24 FC 97 4A 97 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 9D FD 23 6A 8F E5 63 2B 00 DC 81 E2 93 4A 01 23 02 93 62 60 8B 4A 8B 4B A2 61 E3 61 85 4B 1B 68 02 2B 01 D1 00 F0 A8 FC 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 8A FD 23 6A 75 E5 63 2B 00 DC 72 E2 87 4A 01 23 02 93 62 60 7E 4A 7E 4B A2 61 E3 61 78 4B 1B 68 02 2B 01 D1 00 F0 87 FC 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 A8 FD 23 6A 5B E5 63 2B 00 DC 18 E2 7B 4A 01 23 02 93 62 60 71 4A 71 4B A2 61 E3 61 6B 4B 00 98 01 99 1B 68 A5 60 E6 60 20 61 61 61 02 2B 01 D1 00 F0 59 FC 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 B9 FD 23 6A 3B E5 63 2B 00 DC 25 E2 6C 4A 62 48 63 49 01 23 02 93 62 60 0B 1C 02 1C ?? ?? ?? ?? 5A 4B 1B 68 A0 61 E1 61 02 2B 01 D1 00 F0 1F FC 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 AD FC 23 6A 1D E5 63 2B 00 DC 09 E2 5E 4A 01 23 02 93 4E 4B 1D 68 62 60 00 2D 01 D0 00 F0 CC FB 4F 4A 4F 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 9A FC 23 6A 03 E5 63 2B 00 DC DB E1 52 4A 03 23 02 93 41 4B 1D 68 62 60 00 2D 00 D0 9B E3 00 98 01 99 41 4A 42 4B ?? ?? ?? ?? 00 28 01 DD 00 F0 74 FC 3A 4A 3B 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 E7 FC 23 6A E0 E4 63 2B 00 DC B2 E1 30 4A 01 23 02 93 30 4B 1B 68 62 60 00 2B 00 D0 D5 E2 2E 4A 2E 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 C7 FC 23 6A C7 E4 63 2B 00 DC 9B E1 35 4A 01 23 02 93 23 4B 1B 68 62 60 00 2B 00 D0 CA E2 21 4A 22 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 CA FC 23 6A AE E4 63 2B 00 DC 84 E1 28 4A 01 23 02 93 17 4B 1B 68 62 60 00 2B 00 D0 38 E3 15 4A 15 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 B8 FC 23 6A 95 E4 63 2B 00 DC 54 E1 14 4A 01 23 02 93 0A 4B 1B 68 62 60 00 2B 00 D0 D1 E2 08 4A 09 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 B4 FC 23 6A 7C E4 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? FF FF EF C7 00 00 00 E0 ?? ?? ?? ?? 00 00 00 00 00 00 00 00 FF FF EF 47 00 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 63 2B 00 DC 27 E1 CB 4A 01 23 02 93 62 60 CA 4A CA 4B A2 61 E3 61 CA 4B 1B 68 00 2B 00 D1 36 E3 C8 4A C9 4B A2 61 E3 61 48 E4 63 2B 00 DC 10 E1 C6 4A 02 23 02 93 C2 4B 1B 68 62 60 00 2B 00 D0 53 E2 C3 4A C3 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 0D FC 23 6A FF F7 29 FC 63 2B 00 DC F2 E0 BC 4A 01 23 02 93 B5 4B 1B 68 62 60 00 2B 00 D0 01 E2 B6 4A B6 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 7F FC 23 6A FF F7 0F FC 63 2B 00 DC DA E0 B0 4A 03 23 02 93 A8 4B 1B 68 62 60 00 2B 00 D0 F5 E1 AD 4A AD 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 96 FC 23 6A FF F7 F5 FB 63 2B 00 DC D4 E0 A3 4A 04 23 02 93 62 60 98 4A 99 4B A2 61 E3 61 98 4B 1B 68 02 2B 00 D1 E3 E2 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 6E FC 23 6A FF F7 DB FB 63 2B 00 DC B4 E0 99 4A 02 23 02 93 62 60 00 98 01 99 8A 4A 8B 4B ?? ?? ?? ?? 8A 4B 1B 68 A0 61 E1 61 02 2B 00 D1 04 E3 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 EE FB 23 6A FF F7 BD FB 63 2B 00 DC A0 E0 8B 4A 02 23 02 93 7F 4B 1B 68 62 60 00 2B 00 D0 79 E1 84 4A 84 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 0C FC 23 6A FF F7 A3 FB 63 2B 00 DC 80 E0 70 4A 01 23 02 93 72 4B 1B 68 62 60 00 2B 00 D0 6D E1 6D 4A 6D 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 00 FC 23 6A FF F7 89 FB 63 2B 6B DD 73 4A 03 23 02 93 65 4B 1B 68 62 60 00 2B 00 D0 38 E1 6A 4A 6B 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 01 D1 00 F0 F5 FB 23 6A FF F7 70 FB 63 2B 56 DD 67 4A 01 23 02 93 59 4B 1D 68 62 60 00 2D 00 D0 32 E2 00 99 01 9A A1 61 E2 61 20 1C ?? ?? ?? ?? 00 28 00 D1 96 E3 23 6A FF F7 58 FB 63 2B 19 DD 51 4A 01 23 02 93 4D 4B 1B 68 62 60 00 2B 00 D0 77 E1 4E 4A 4E 4B A2 61 E3 61 20 1C ?? ?? ?? ?? 00 28 00 D1 2A E3 23 6A FF F7 40 FB 51 4A E5 E5 51 4A A9 E6 51 4A E4 E7 4F 4A FF F7 22 FC 50 4A 7D E4 50 4A FC E4 50 4A 0B E7 50 4A 23 E7 4B 4A ED E6 4F 4A D6 E6 4B 4A 4B E6 4E 4A 62 E6 4D 4A 79 E6 4D 4A 22 E6 4D 4A 49 E7 49 4A 36 E5 48 4A 7D E7 46 4A 29 E7 4A 4A 92 E7 4A 4A 5D E7 4A 4A A7 E7 3D 4A 52 E5 49 4A D8 E5 49 4A F4 E5 40 4A F0 E4 48 4A 64 E5 48 4A 7C E5 3E 4A FF F7 66 FB 39 4A 6A E4 3F 4A 82 E4 39 4A FD E4 43 4A 8B E5 37 4A FF F7 E2 FA 42 4A FF F7 22 FB 41 4A FF F7 3A FB 41 4A FF F7 A3 FB 2E 4A FF F7 BF FB 3F 4A FF F7 82 FB 3E 4A FF F7 64 FB 39 4A FF F7 F5 FA 3C 49 3D 4A FF F7 F4 FB 37 4D FF F7 E5 FB 2B 4A FF F7 07 FC 37 49 38 4A A1 61 E2 61 02 2B 01 D0 FF F7 0B FB ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 CD FA 30 49 30 4A A1 61 E2 61 02 2B 01 D0 FF F7 E1 FA ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 BE FA ?? ?? ?? ?? 00 00 00 00 00 00 00 00 ?? ?? ?? ?? 00 00 F0 3F 00 00 00 00 ?? ?? ?? ?? FF FF EF C7 00 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? FF FF EF 47 00 00 00 E0 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 F0 7F 00 00 00 00 E8 4B E7 4A 00 98 01 99 A2 61 E3 61 E6 4A E7 4B ?? ?? ?? ?? 00 28 00 DB 88 E4 E5 4A E5 4B 28 1C 31 1C ?? ?? ?? ?? 05 1C 0E 1C ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 00 28 00 D1 77 E4 DE 4A DF 4B A2 61 E3 61 72 E4 D7 4A D5 49 A1 61 E2 61 02 2B 00 D0 C3 E6 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 37 FA D0 4A CE 49 A1 61 E2 61 02 2B 00 D0 82 E6 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 29 FA CE 49 CE 4A A1 61 E2 61 02 2B 00 D0 8E E6 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 1B FA C7 49 C7 4A A1 61 E2 61 02 2B 00 D0 FA E5 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 0D FA BB 4A B9 49 A1 61 E2 61 02 2B 00 D0 06 E6 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 FF F9 B9 49 B9 4A A1 61 E2 61 02 2B 00 D0 26 E5 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 F1 F9 B2 49 B2 4A A1 61 E2 61 02 2B 00 D0 31 E5 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 E3 F9 AB 49 AB 4A A1 61 E2 61 02 2B 00 D0 A8 E5 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 D5 F9 A4 49 A4 4A A1 61 E2 61 02 2B 00 D0 84 E6 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 C7 F9 9D 49 9D 4A A1 61 E2 61 02 2B 01 D0 FF F7 96 FB ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 B8 F9 95 49 96 4A A1 61 E2 61 02 2B 00 D0 2A E5 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 AA F9 8E 49 8F 4A A1 61 E2 61 02 2B 01 D0 FF F7 16 FB ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 9B F9 82 4A 80 49 A1 61 E2 61 02 2B 01 D0 FF F7 21 FB ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 8C F9 7B 48 7C 49 02 1C 0B 1C ?? ?? ?? ?? A0 61 E1 61 02 2D 01 D0 FF F7 71 FB ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 79 F9 71 4A 6F 49 A1 61 E2 61 02 2B 01 D0 FF F7 D8 FB ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 6A F9 6E 49 6F 4A A1 61 E2 61 02 2B 00 D0 C3 E4 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 5C F9 00 98 01 99 62 4A 63 4B ?? ?? ?? ?? 00 28 00 DD DC E0 63 4A 63 4B A2 61 E3 61 02 2D 00 D0 61 E4 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 45 F9 58 48 58 49 02 1C 0B 1C ?? ?? ?? ?? A0 61 E1 61 02 2D 01 D0 FF F7 2C FC ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 32 F9 4E 48 4F 49 02 1C 0B 1C ?? ?? ?? ?? A0 61 E1 61 02 2D 00 D0 C5 E5 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 20 F9 49 49 4A 4A A1 61 E2 61 02 2B 01 D0 FF F7 65 FB ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 11 F9 20 1C ?? ?? ?? ?? 00 28 00 D1 CE E1 23 6A FF F7 08 F9 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 01 F9 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 FA F8 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 F3 F8 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 EC F8 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 E5 F8 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 DE F8 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 D7 F8 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 D0 F8 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 C9 F8 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 C2 F8 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 BB F8 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 B4 F8 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 AD F8 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 A6 F8 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 9F F8 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 98 F8 00 00 F0 7F 00 00 00 00 00 00 00 00 00 00 00 00 00 00 E0 3F 00 00 00 00 00 00 F0 FF 00 00 00 00 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 81 F8 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 7A F8 A3 4B A2 4A FF F7 8A FB A2 4A A3 4B 21 E7 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 6C F8 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 65 F8 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 5E F8 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 57 F8 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 50 F8 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 49 F8 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 42 F8 ?? ?? ?? ?? 21 23 03 60 23 6A FF F7 3B F8 ?? ?? ?? ?? 22 23 03 60 23 6A FF F7 34 F8 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_186_0_1 {
	meta:
		name = "__ieee754_coshf"
		size = 252
		refs = "002c __mulsf3 003e fabsf 0042 expm1f 004a __addsf3 006c __divsf3 007e __ieee754_expf"
	strings:
		$1 = { 70 B5 34 4B 04 1C 1C 40 33 4B 01 1C 9C 42 12 DC 32 4B 9C 42 13 DD 32 4B 9C 42 2E DD 31 4B 9C 42 3E DD 31 4B 9C 42 44 DD 30 48 01 1C ?? ?? ?? ?? 05 1C 28 1C 70 BD ?? ?? ?? ?? 05 1C F9 E7 ?? ?? ?? ?? ?? ?? ?? ?? 2A 49 06 1C ?? ?? ?? ?? 29 4B 05 1C 9C 42 ED DD 31 1C 30 1C ?? ?? ?? ?? 29 1C 04 1C 28 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 1F 49 ?? ?? ?? ?? 05 1C DB E7 ?? ?? ?? ?? ?? ?? ?? ?? 1D 49 04 1C ?? ?? ?? ?? 21 1C 05 1C 1A 48 ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 05 1C C8 E7 ?? ?? ?? ?? ?? ?? ?? ?? 13 49 ?? ?? ?? ?? 05 1C BF E7 ?? ?? ?? ?? 10 49 ?? ?? ?? ?? ?? ?? ?? ?? 0D 49 04 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 05 1C AE E7 FF FF FF 7F FF FF 7F 7F 17 72 B1 3E FF FF AF 41 17 72 B1 42 FC D4 B2 42 CA F2 49 71 00 00 80 3F FF FF FF 23 00 00 00 3F }
	condition:
		$1
}

rule file_187_0_1 {
	meta:
		name = "lrintf"
		size = 128
		refs = "0040 __addsf3 004a __subsf3 0058 __fixsfsi"
	strings:
		$1 = { 30 B5 45 00 2D 0E 2B 1C 7F 3B 81 B0 01 1C 02 1C 1E 2B 21 DC 58 1C 1D DB CC 0F 16 2B 0C DD 16 4B 1A 40 80 23 1B 04 13 43 96 3D 18 1C A8 40 00 2C 00 D0 40 42 01 B0 30 BD 10 4A A3 00 D5 58 28 1C ?? ?? ?? ?? 00 90 00 98 29 1C ?? ?? ?? ?? 03 1C 42 00 04 D1 00 20 ED E7 ?? ?? ?? ?? EA E7 06 48 80 22 18 40 12 04 5B 00 02 43 1B 0E 96 20 C3 1A 10 1C D8 40 DB E7 C0 46 FF FF 7F 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_188_0_1 {
	meta:
		name = "logb"
		size = 100
		refs = "0010 fabs 001c __divdf3 0032 __floatsidf 003c __muldf3"
	strings:
		$1 = { 10 B5 11 4C 02 1C 0B 1C 04 40 0A D1 00 29 08 D1 ?? ?? ?? ?? 02 1C 0B 1C 0C 48 0D 49 ?? ?? ?? ?? 09 E0 0C 49 8C 42 07 DC 24 15 00 2C 09 D0 0A 4B E0 18 ?? ?? ?? ?? 10 BD 10 1C 19 1C ?? ?? ?? ?? F9 E7 06 48 06 49 F6 E7 FF FF FF 7F 00 00 F0 BF 00 00 00 00 FF FF EF 7F 01 FC FF FF 00 F0 8F C0 00 00 00 00 }
	condition:
		$1
}

rule file_189_0_1 {
	meta:
		name = "__ieee754_sqrt"
		size = 460
		refs = "017e __muldf3 018a __adddf3 01aa __subdf3 01b2 __divdf3"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0D 1C 6B 49 04 1C 03 1C 08 40 81 B0 2A 1C 88 42 00 D1 AA E0 00 2C 00 DC 89 E0 26 15 00 2E 00 D1 91 E0 64 49 64 4F 0B 40 80 21 F7 19 49 03 00 97 19 43 FF 07 00 D5 75 E0 D0 0F 49 00 0B 18 00 24 80 21 52 00 A3 46 00 20 89 03 45 18 9D 42 02 DC 68 18 5B 1B 8B 44 D5 0F 5B 00 01 34 5B 19 52 00 49 08 16 2C F1 D1 00 25 AC 46 80 21 09 06 66 46 A9 46 8A 46 8C 19 98 42 11 DB 94 42 01 D8 83 42 0D D0 80 46 5B 00 D0 0F 01 35 1B 18 52 00 49 08 20 2D 1A D0 66 46 40 46 8C 19 98 42 ED DA 56 46 26 40 67 18 B0 46 BC 46 D0 45 30 D0 80 46 1B 1A 94 42 00 D9 01 3B 12 1B D0 0F 5B 00 01 35 89 44 1B 18 52 00 49 08 20 2D E4 D1 00 2B 25 D0 4A 46 01 32 59 D0 01 23 4C 46 23 40 4B 44 5B 08 5E 46 F6 07 02 D5 80 22 12 06 13 43 00 9F 33 49 7E 10 36 05 5A 46 76 18 57 10 F4 19 1D 1C 01 B0 29 1C 20 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 56 46 37 42 CB D1 47 1C B8 46 C9 E7 00 2A D7 D1 49 46 4B 08 DC E7 D0 0F 49 00 09 18 52 00 84 E7 61 00 01 D1 00 2D E2 D0 00 2B 2D D1 00 26 D3 0A 15 3E 52 05 00 2B FA D0 80 20 40 03 03 42 20 D1 00 21 5B 00 01 31 03 42 FB D0 20 20 40 1A 14 1C 01 36 C4 40 76 1A 23 43 8A 40 5B E7 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C B9 E7 01 23 9B 44 00 23 A6 E7 20 20 00 21 E2 E7 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? 04 1C 0D 1C A5 E7 00 00 F0 7F FF FF 0F 00 01 FC FF FF 00 00 E0 3F }
	condition:
		$1
}

rule file_191_0_1 {
	meta:
		name = "gamma"
		size = 268
		refs = "0012 __ieee754_gamma_r 0022 finite 0068 floor 0070 __eqdf2 0080 __ledf2 0094 matherr 00b6 __errno 00e8 _impure_ptr 00ec __fdlib_version"
	strings:
		$1 = { F0 B5 47 46 80 B4 38 4B 1A 68 8B B0 A0 32 04 1C 0D 1C ?? ?? ?? ?? 35 4E 33 68 00 90 01 91 01 33 04 D0 ?? ?? ?? ?? 80 46 00 28 05 D0 00 98 01 99 0B B0 04 BC 90 46 F0 BD 20 1C 29 1C ?? ?? ?? ?? 00 28 F3 D0 2A 4B 02 AF 7B 60 43 46 3B 62 33 68 3C 61 7D 61 BC 60 FD 60 00 2B 27 D1 25 4A 26 4B BA 61 FB 61 20 1C 29 1C ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 00 28 07 D1 20 1C 29 1C 1F 4A 20 4B ?? ?? ?? ?? 00 28 1B DD 03 23 02 93 33 68 02 2B 11 D0 38 1C ?? ?? ?? ?? 00 28 0C D0 3B 6A 00 2B 1D D1 BB 69 FC 69 00 93 01 94 BF E7 15 4A 16 4B BA 61 FB 61 D6 E7 ?? ?? ?? ?? 22 23 03 60 ED E7 02 23 02 93 33 68 02 2B 04 D0 38 1C ?? ?? ?? ?? 00 28 E3 D1 ?? ?? ?? ?? 21 23 03 60 DE E7 ?? ?? ?? ?? 3B 6A 03 60 DC E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF FF EF 47 00 00 00 E0 00 00 00 00 00 00 00 00 00 00 F0 7F 00 00 00 00 }
	condition:
		$1
}

rule file_192_0_1 {
	meta:
		name = "fmaxf"
		size = 44
		refs = "0006 __fpclassifyf 0020 __gtsf2"
	strings:
		$1 = { 30 B5 05 1C 0C 1C ?? ?? ?? ?? 00 28 01 D1 20 1C 30 BD 20 1C ?? ?? ?? ?? 00 28 05 D0 28 1C 21 1C ?? ?? ?? ?? 00 28 F2 DD 2C 1C F0 E7 }
	condition:
		$1
}

rule file_193_0_1 {
	meta:
		name = "log1p"
		size = 1228
		refs = "0022 __eqdf2 0034 __divdf3 0056 __adddf3 0072 __subdf3 00ba __muldf3 01c4 __floatsidf 0276 __gtdf2"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 CE 4A 8A B0 04 1C 0D 1C 90 42 14 DC CC 4E CD 4A 06 40 96 42 6B DD CC 4A CC 4B ?? ?? ?? ?? 00 28 00 D0 11 E1 CA 48 CB 49 CB 4A CC 4B ?? ?? ?? ?? 04 1C 0D 1C 01 E1 CA 4A 90 42 00 DD F7 E0 C9 4A 90 42 00 DD 39 E1 C8 4A C8 4B 20 1C 29 1C ?? ?? ?? ?? C7 4A 03 15 D2 18 06 1C 0F 1C 82 46 90 46 00 2A 00 DC 16 E2 22 1C 2B 1C ?? ?? ?? ?? 02 1C 0B 1C BD 48 BD 49 ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 06 90 07 91 BB 4C 52 46 BB 4B 14 40 9C 42 00 DD 06 E1 B9 4B 26 1C 1E 43 30 1C 39 1C B2 4A B2 4B ?? ?? ?? ?? B6 4A B6 4B 06 1C 0F 1C 00 96 01 97 ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 02 90 03 91 04 90 05 91 00 2C 27 D1 30 1C 39 1C A1 4A A1 4B ?? ?? ?? ?? 00 28 00 D0 F7 E0 44 46 00 2C 00 D0 B5 E1 9B 4C 9C 4D A5 E0 A6 4A 96 42 00 DC B5 E0 A5 4A 83 18 93 42 A3 D9 A0 4A A0 4B ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 04 90 05 91 00 94 01 95 00 24 A0 46 9C 4A 9C 4B 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 06 1C 0F 1C 32 1C 3B 1C ?? ?? ?? ?? 95 4A 95 4B 04 1C 0D 1C ?? ?? ?? ?? 94 4A 94 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 92 4A 92 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 90 4A 90 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 8E 4A 8E 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 8C 4A 8C 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 8A 4A 8A 4B ?? ?? ?? ?? 2B 1C 22 1C ?? ?? ?? ?? 43 46 04 1C 0D 1C 00 2B 00 D1 A7 E0 40 46 ?? ?? ?? ?? 83 4A 84 4B 02 90 03 91 ?? ?? ?? ?? 22 1C 2B 1C 08 90 09 91 04 98 05 99 ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 7C 4A 7D 4B 04 1C 0D 1C 02 98 03 99 ?? ?? ?? ?? 06 9A 07 9B ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 02 1C 0B 1C 08 98 09 99 ?? ?? ?? ?? 04 1C 0D 1C 05 E0 22 1C 2B 1C ?? ?? ?? ?? 04 1C 0D 1C 0A B0 29 1C 20 1C 0C BC 90 46 9A 46 F0 BD 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? 04 1C 0D 1C EB E7 5F 4A 5F 4B ?? ?? ?? ?? 3B 4A 3B 4B ?? ?? ?? ?? 00 28 02 DD 5C 4B 9E 42 DE DD 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 58 4A 59 4B ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C CB E7 01 23 98 44 53 4B 26 1C 1E 43 80 23 5B 03 1C 1B 30 1C 39 1C A4 10 F1 E6 2D 4A 03 15 D2 18 25 4B 26 4C 82 46 90 46 0F 1C 06 93 07 94 DA E6 49 4A 4A 4B 30 1C 39 1C ?? ?? ?? ?? 22 4A 23 4B ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 42 46 04 1C 0D 1C 00 2A 00 D0 83 E0 22 1C 2B 1C 30 1C 39 1C ?? ?? ?? ?? 04 1C 0D 1C 97 E7 22 1C 2B 1C 04 98 05 99 ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 04 1C 0D 1C 7E E7 79 82 DA 3F FF FF FF 7F FF FF EF 3F 00 00 F0 BF 00 00 00 00 00 00 50 C3 00 00 00 00 00 00 00 00 00 00 00 00 FF FF EF 7F FF FF 3F 43 00 00 F0 3F 00 00 00 00 01 FC FF FF FF FF 0F 00 9D A0 06 00 00 00 F0 3F 00 00 E0 3F 00 00 00 00 FF FF 1F 3E 3C 41 2D 40 00 00 00 40 00 00 00 00 12 F1 C2 3F 44 52 3E DF 09 9A C3 3F 9F C6 78 D0 64 46 C7 3F DE 03 CB 96 C5 71 CC 3F AF 78 8E 1D 24 49 D2 3F 59 93 22 94 99 99 D9 3F 04 FA 97 99 55 55 E5 3F 93 55 55 55 42 2E E6 3F 00 00 E0 FE EF 39 EA 3D 76 3C 79 35 00 00 50 43 00 00 00 00 FF FF 8F 3C 00 00 E0 BF 00 00 00 00 00 00 E0 3F 55 55 E5 BF 55 55 55 55 40 46 ?? ?? ?? ?? 2A 4B 28 4A 00 90 01 91 ?? ?? ?? ?? 28 4A 28 4B 04 90 05 91 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 06 98 07 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 02 1C 0B 1C 04 98 05 99 ?? ?? ?? ?? 04 1C 0D 1C F2 E6 40 46 ?? ?? ?? ?? 15 4B 13 4A 04 1C 0D 1C ?? ?? ?? ?? 13 4A 13 4B 06 1C 0F 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 06 98 07 99 ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 04 1C 0D 1C D2 E6 09 4A 0A 4B ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? E7 E5 C0 46 42 2E E6 3F 00 00 E0 FE EF 39 EA 3D 76 3C 79 35 00 00 F0 3F 00 00 00 00 }
	condition:
		$1
}

rule file_194_0_1 {
	meta:
		name = "__ieee754_asin"
		size = 1096
		refs = "0026 __subdf3 002e __divdf3 0050 __adddf3 0058 __gtdf2 0064 fabs 0078 __muldf3 0128 __ieee754_sqrt"
	strings:
		$1 = { F0 B5 9D 4E 9D 4B 06 40 8A B0 05 1C 0C 1C 07 1C 9E 42 14 DD 9A 49 76 18 00 2E 00 D1 EC E0 2A 1C 23 1C 28 1C 21 1C ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? 05 1C 0C 1C 0A B0 28 1C 21 1C F0 BD 91 4B 9E 42 0D DC 90 4B 9E 42 00 DD 65 E1 8F 4A 90 4B ?? ?? ?? ?? 8F 4A 90 4B ?? ?? ?? ?? 00 28 EA DC 28 1C 21 1C ?? ?? ?? ?? 02 1C 0B 1C 89 48 8A 49 ?? ?? ?? ?? 89 4A 8A 4B ?? ?? ?? ?? 89 4A 8A 4B 04 1C 0D 1C ?? ?? ?? ?? 88 4A 89 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 86 4A 87 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 84 4A 85 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 82 4A 83 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 80 4A 81 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 7E 4A 7F 4B 02 90 03 91 20 1C 29 1C ?? ?? ?? ?? 7C 4A 7D 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 7A 4A 7B 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 78 4A 79 4B ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 5E 4A 5F 4B ?? ?? ?? ?? 06 90 07 91 20 1C 29 1C ?? ?? ?? ?? 71 4B 00 90 01 91 9E 42 00 DD 78 E0 00 9A 01 9B 00 98 01 99 00 23 04 92 05 93 02 1C 0B 1C ?? ?? ?? ?? 06 9A 07 9B 08 90 09 91 02 98 03 99 ?? ?? ?? ?? 02 1C 0B 1C 08 98 09 99 ?? ?? ?? ?? 02 90 03 91 04 98 05 99 02 1C 0B 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 04 9A 05 9B 04 1C 0D 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 55 4A 55 4B ?? ?? ?? ?? 55 4A 55 4B ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 4E 4A 4E 4B 04 1C 0D 1C 04 98 05 99 ?? ?? ?? ?? 4E 4A 4E 4B ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 48 48 48 49 ?? ?? ?? ?? 0C 1C 00 2F 3D DD 05 1C 1E E7 00 2C 00 D0 0F E7 21 1C 43 4A 44 4B ?? ?? ?? ?? 3D 4A 3E 4B 06 1C 0F 1C 28 1C 21 1C ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? 05 1C 0C 1C 05 E7 06 9A 07 9B 02 98 03 99 ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? 2A 4A 2A 4B ?? ?? ?? ?? 02 1C 0B 1C 2B 48 2B 49 ?? ?? ?? ?? 0C 1C 00 2F C1 DC 80 23 1B 06 C5 18 DE E6 FF FF FF 7F FF FF EF 3F 00 00 10 C0 FF FF DF 3F FF FF 3F 3E 3C E4 37 7E 9C 75 00 88 00 00 F0 3F 00 00 00 00 00 00 E0 3F 00 00 00 00 E1 3D 02 3F 09 F7 FD 0D E0 EF 49 3F 88 B2 01 75 28 82 A4 3F 3B 8F 68 B5 55 C1 C9 3F 55 44 88 0E 12 D6 D4 3F 7D 6F EB 03 55 55 C5 3F 55 55 55 55 C5 B8 B3 3F 82 92 2E B1 6C 06 E6 3F 59 01 8D 1B E5 2A 00 40 C8 8A 59 9C 27 3A 03 40 4B 2D 8A 1C 32 33 EF 3F 00 00 00 C0 00 00 00 00 26 A6 91 3C 07 5C 14 33 FB 21 E9 3F 18 2D 44 54 FB 21 F9 3F 18 2D 44 54 2A 1C 23 1C ?? ?? ?? ?? 34 4B 33 4A 06 1C 0F 1C ?? ?? ?? ?? 32 4A 33 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 30 4A 31 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 2E 4A 2F 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 2C 4A 2D 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 2A 4A 2B 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 28 4A 29 4B 00 90 01 91 30 1C 39 1C ?? ?? ?? ?? 26 4A 27 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 24 4A 25 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 22 4A 23 4B ?? ?? ?? ?? 32 1C 3B 1C ?? ?? ?? ?? 20 4A 21 4B ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 02 1C 0B 1C 28 1C 21 1C ?? ?? ?? ?? 02 1C 0B 1C 28 1C 21 1C ?? ?? ?? ?? 05 1C 0C 1C 23 E6 C0 46 E1 3D 02 3F 09 F7 FD 0D E0 EF 49 3F 88 B2 01 75 28 82 A4 3F 3B 8F 68 B5 55 C1 C9 3F 55 44 88 0E 12 D6 D4 3F 7D 6F EB 03 55 55 C5 3F 55 55 55 55 C5 B8 B3 3F 82 92 2E B1 6C 06 E6 3F 59 01 8D 1B E5 2A 00 40 C8 8A 59 9C 27 3A 03 40 4B 2D 8A 1C 00 00 F0 3F 00 00 00 00 }
	condition:
		$1
}

rule file_195_0_1 {
	meta:
		name = "significand"
		size = 30
		refs = "0006 ilogb 000c __floatsidf 0018 __ieee754_scalb"
	strings:
		$1 = { 30 B5 0D 1C 04 1C ?? ?? ?? ?? 40 42 ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 30 BD }
	condition:
		$1
}

rule file_196_0_1 {
	meta:
		name = "__kernel_sinf"
		size = 256
		refs = "001a __fixsfsi 0026 __mulsf3 003e __subsf3 004a __addsf3"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 34 4B 90 46 02 1C 1A 40 33 4B 04 1C 0F 1C 9A 42 03 DC ?? ?? ?? ?? 00 28 46 D0 21 1C 20 1C ?? ?? ?? ?? 21 1C 05 1C ?? ?? ?? ?? 2C 49 06 1C 28 1C ?? ?? ?? ?? 2A 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 28 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 26 49 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 24 49 ?? ?? ?? ?? 43 46 82 46 00 2B 25 D0 22 49 38 1C ?? ?? ?? ?? 51 46 80 46 30 1C ?? ?? ?? ?? 01 1C 40 46 ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 39 1C ?? ?? ?? ?? 19 49 05 1C 30 1C ?? ?? ?? ?? 01 1C 28 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 04 1C 20 1C 0C BC 90 46 9A 46 F0 BD 51 46 28 1C ?? ?? ?? ?? 0E 49 ?? ?? ?? ?? 31 1C ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 04 1C EA E7 C0 46 FF FF FF 7F FF FF FF 31 D3 C9 2E 2F 34 2F D7 32 1B EF 38 36 01 0D 50 39 89 88 08 3C 00 00 00 3F AB AA 2A 3E }
	condition:
		$1
}

rule file_197_0_1 {
	meta:
		name = "__kernel_tan"
		size = 944
		refs = "0028 __fixdfsi 0048 __divdf3 0066 __subdf3 0082 __adddf3 0098 __muldf3 0266 __floatsidf 02ee fabs"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 9A 46 C1 4B 0F 1C 01 1C 19 40 C0 4B 89 46 88 B0 04 1C 90 46 83 46 99 45 15 DC 39 1C ?? ?? ?? ?? 00 28 2F D1 49 46 00 29 00 D1 51 E1 11 9B 01 2B 00 D1 08 E1 22 1C 3B 1C B5 48 B6 49 ?? ?? ?? ?? 04 1C 0F 1C FF E0 B4 4B 99 45 1B DD 00 28 00 DA 52 E1 22 1C 3B 1C B1 48 B1 49 ?? ?? ?? ?? 42 46 04 1C 53 46 0D 1C AF 48 AF 49 ?? ?? ?? ?? 0B 1C 02 1C 29 1C 20 1C ?? ?? ?? ?? 00 23 04 1C 0F 1C 98 46 9A 46 22 1C 3B 1C 20 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 00 90 01 91 ?? ?? ?? ?? 22 1C 05 1C 0E 1C 3B 1C 00 98 01 99 ?? ?? ?? ?? 9F 4A A0 4B 02 90 03 91 28 1C 31 1C ?? ?? ?? ?? 9D 4A 9E 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 9B 4A 9C 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 99 4A 9A 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 97 4A 98 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 95 4A 96 4B ?? ?? ?? ?? 95 4A 96 4B 06 90 07 91 28 1C 31 1C ?? ?? ?? ?? 93 4A 94 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 91 4A 92 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 8F 4A 90 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 8D 4A 8E 4B ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 8B 4A 8C 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 02 1C 0B 1C 06 98 07 99 ?? ?? ?? ?? 02 9A 03 9B ?? ?? ?? ?? 42 46 53 46 ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 42 46 53 46 ?? ?? ?? ?? 7E 4A 7F 4B 05 1C 0E 1C 02 98 03 99 ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 05 1C 0E 1C 33 1C 20 1C 39 1C 2A 1C ?? ?? ?? ?? 57 4B 80 46 8A 46 99 45 4A DC 11 9A 01 2A 00 D1 9B E0 02 1C 00 23 02 92 03 93 4F 48 4F 49 42 46 53 46 ?? ?? ?? ?? 00 23 02 1C 00 92 01 93 04 90 05 91 22 1C 3B 1C 02 98 03 99 ?? ?? ?? ?? 02 1C 0B 1C 28 1C 31 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? 02 9A 03 9B 04 1C 0D 1C 00 98 01 99 ?? ?? ?? ?? 5D 4A 5D 4B ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 04 9A 05 9B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 04 1C 0F 1C 08 B0 39 1C 20 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 11 98 ?? ?? ?? ?? 42 46 00 90 01 91 53 46 40 46 51 46 ?? ?? ?? ?? 00 9A 01 9B 02 90 03 91 40 46 51 46 ?? ?? ?? ?? 02 1C 0B 1C 02 98 03 99 ?? ?? ?? ?? 2A 1C 33 1C ?? ?? ?? ?? 02 1C 0B 1C 20 1C 39 1C ?? ?? ?? ?? 3F 4A 3F 4B ?? ?? ?? ?? 00 9A 01 9B ?? ?? ?? ?? 0D 1C 59 46 04 1C 02 23 88 17 18 40 01 23 18 1A ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? 04 1C 0F 1C BA E7 00 2F 00 D0 AA E6 11 9A 01 32 00 D0 A6 E6 20 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 2A 48 2A 49 ?? ?? ?? ?? 04 1C 0F 1C A6 E7 80 22 12 06 84 18 90 44 A7 E6 04 1C 0F 1C 9E E7 FF FF FF 7F FF FF 2F 3E 00 00 F0 BF 00 00 00 00 27 94 E5 3F FB 21 E9 3F 18 2D 44 54 26 A6 81 3C 07 5C 14 33 CB 75 F3 BE 73 53 60 DB 88 7E 14 3F A6 92 37 A0 D8 44 43 3F 01 65 F2 F2 22 6D 6D 3F 28 03 56 C9 F4 64 96 3F 37 D6 06 84 11 11 C1 3F 7A FE 10 11 70 2A FB 3E D4 7A BF 74 0F B8 12 3F E9 A7 F0 32 F7 26 30 3F 68 10 8D 1A C8 DB 57 3F 15 83 E0 FE E3 26 82 3F 93 84 6E E9 BA A1 AB 3F FE 41 B3 1B 55 55 D5 3F 63 55 55 55 00 00 F0 3F 00 00 00 00 00 00 00 C0 00 00 00 00 }
	condition:
		$1
}

rule file_198_0_1 {
	meta:
		name = "__ieee754_acosh"
		size = 308
		refs = "0022 __adddf3 0042 __subdf3 005e __muldf3 006e __ieee754_sqrt 007a log1p 008e __divdf3 00a0 __ieee754_log"
	strings:
		$1 = { F0 B5 40 4A 82 B0 04 1C 0D 1C 03 1C 90 42 37 DD 3D 4A 90 42 09 DD 3D 4A 90 42 40 DD 29 1C 22 1C 2B 1C ?? ?? ?? ?? 02 B0 F0 BD 39 48 22 18 00 2A 30 D0 80 22 D2 05 93 42 39 DC 36 4A 36 4B 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C 22 1C 2B 1C ?? ?? ?? ?? 22 1C 06 1C 0F 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C 30 1C 39 1C ?? ?? ?? ?? ?? ?? ?? ?? 22 1C 2B 1C ?? ?? ?? ?? ?? ?? ?? ?? D2 E7 22 1C 2B 1C 29 1C ?? ?? ?? ?? 02 1C 0B 1C ?? ?? ?? ?? C8 E7 00 2D CC D1 20 48 21 49 C3 E7 29 1C ?? ?? ?? ?? 1F 4A 20 4B ?? ?? ?? ?? BB E7 22 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 16 4A 16 4B ?? ?? ?? ?? ?? ?? ?? ?? 22 1C 06 1C 0F 1C 2B 1C 20 1C 29 1C ?? ?? ?? ?? 22 1C 00 90 01 91 2B 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 10 48 10 49 ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? ?? ?? ?? ?? 90 E7 FF FF EF 3F FF FF AF 41 FF FF EF 7F 00 00 10 C0 00 00 F0 3F 00 00 00 00 00 00 00 00 00 00 00 00 42 2E E6 3F EF 39 FA FE 00 00 F0 BF 00 00 00 00 }
	condition:
		$1
}

rule file_200_0_1 {
	meta:
		name = "floorf"
		size = 144
		refs = "0020 __addsf3 0026 __gtsf2"
	strings:
		$1 = { 70 B5 1D 4D 05 40 EC 0D 7F 3C 01 1C 06 1C 16 2C 13 DC 00 2C 18 DB 19 4D 25 41 05 42 0B D0 18 49 ?? ?? ?? ?? 17 49 ?? ?? ?? ?? 00 28 02 DD 00 2E 17 DB AE 43 31 1C 08 1C 70 BD 13 4B 9D 42 FA D9 ?? ?? ?? ?? 01 1C F6 E7 0D 49 ?? ?? ?? ?? 0D 49 ?? ?? ?? ?? 00 28 ED DD 00 2E 08 DB 00 26 31 1C E9 E7 80 23 1B 04 23 41 F6 18 AE 43 E2 E7 00 2D E0 D0 06 4E 31 1C DE E7 FF FF FF 7F FF FF 7F 00 CA F2 49 71 00 00 00 00 FF FF 7F 7F 00 00 80 BF }
	condition:
		$1
}

rule file_0_0_2 {
	meta:
		name = "__cxa_current_exception_type"
		size = 32
		refs = "0002 __cxa_get_globals"
	strings:
		$1 = { 00 B5 ?? ?? ?? ?? 03 68 00 2B 07 D0 DA 6A D1 07 01 D4 18 68 00 BD 5B 68 40 3B FA E7 00 20 F9 E7 }
	condition:
		$1
}

rule file_1_0_2 {
	meta:
		name = "__cxa_pure_virtual"
		size = 20
		refs = "0008 write 000c _ZSt9terminatev"
	strings:
		$1 = { 00 B5 03 49 1B 22 02 20 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_1_2 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EED1Ev"
		size = 138
		refs = "0026 _Unwind_SjLj_Register 004a _ZNSt6locale5facetD2Ev 0052 _Unwind_SjLj_Unregister 0074 _Unwind_SjLj_Resume 0078 __gxx_personality_sj0 0084 _ZTVSt10moneypunctIcLb0EE"
		altNames = "_ZNSt10moneypunctIcLb0EED2Ev"
	strings:
		$1 = { 80 B5 8F B0 1C 4B 00 AF 3B 62 3C 22 1B 4B D2 19 7B 62 BA 62 3B 1C 1A 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 ?? ?? ?? ?? 7A 68 15 4B 90 68 13 60 00 28 05 D0 03 68 01 22 5B 68 FA 60 00 F0 23 F8 01 23 5B 42 78 68 FB 60 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 3B 69 78 68 3B 60 00 23 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_3_3_2 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EED1Ev"
		size = 138
		refs = "0026 _Unwind_SjLj_Register 004a _ZNSt6locale5facetD2Ev 0052 _Unwind_SjLj_Unregister 0074 _Unwind_SjLj_Resume 0078 __gxx_personality_sj0 0084 _ZTVSt10moneypunctIcLb1EE"
	strings:
		$1 = { 80 B5 8F B0 1C 4B 00 AF 3B 62 3C 22 1B 4B D2 19 7B 62 BA 62 3B 1C 1A 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 ?? ?? ?? ?? 7A 68 15 4B 90 68 13 60 00 28 05 D0 03 68 01 22 5B 68 FA 60 00 F0 23 F8 01 23 5B 42 78 68 FB 60 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 3B 69 78 68 3B 60 00 23 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_3_4_2 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EED2Ev"
		size = 138
		refs = "0026 _Unwind_SjLj_Register 004a _ZNSt6locale5facetD2Ev 0052 _Unwind_SjLj_Unregister 0074 _Unwind_SjLj_Resume 0078 __gxx_personality_sj0 0084 _ZTVSt10moneypunctIcLb1EE"
	strings:
		$1 = { 80 B5 8F B0 1C 4B 00 AF 3B 62 3C 22 1B 4B D2 19 7B 62 BA 62 3B 1C 1A 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 ?? ?? ?? ?? 7A 68 15 4B 90 68 13 60 00 28 05 D0 03 68 01 22 5B 68 FA 60 00 F0 23 F8 01 23 5B 42 78 68 FB 60 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 3B 69 78 68 3B 60 00 23 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_54_0_2 {
	meta:
		name = "_ZNSt8numpunctIcED1Ev"
		size = 138
		refs = "0026 _Unwind_SjLj_Register 004a _ZNSt6locale5facetD2Ev 0052 _Unwind_SjLj_Unregister 0074 _Unwind_SjLj_Resume 0078 __gxx_personality_sj0 0084 _ZTVSt8numpunctIcE"
	strings:
		$1 = { 80 B5 8F B0 1C 4B 00 AF 3B 62 3C 22 1B 4B D2 19 7B 62 BA 62 3B 1C 1A 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 ?? ?? ?? ?? 7A 68 15 4B 90 68 13 60 00 28 05 D0 03 68 01 22 5B 68 FA 60 00 F0 23 F8 01 23 5B 42 78 68 FB 60 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 3B 69 78 68 3B 60 00 23 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_54_1_2 {
	meta:
		name = "_ZNSt8numpunctIcED2Ev"
		size = 138
		refs = "0026 _Unwind_SjLj_Register 004a _ZNSt6locale5facetD2Ev 0052 _Unwind_SjLj_Unregister 0074 _Unwind_SjLj_Resume 0078 __gxx_personality_sj0 0084 _ZTVSt8numpunctIcE"
	strings:
		$1 = { 80 B5 8F B0 1C 4B 00 AF 3B 62 3C 22 1B 4B D2 19 7B 62 BA 62 3B 1C 1A 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 ?? ?? ?? ?? 7A 68 15 4B 90 68 13 60 00 28 05 D0 03 68 01 22 5B 68 FA 60 00 F0 23 F8 01 23 5B 42 78 68 FB 60 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 3B 69 78 68 3B 60 00 23 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_3_5_2 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EED0Ev"
		size = 146
		refs = "0026 _Unwind_SjLj_Register 004a _ZNSt6locale5facetD2Ev 0050 _ZdlPv 0058 _Unwind_SjLj_Unregister 007a _Unwind_SjLj_Resume 0080 __gxx_personality_sj0 008c _ZTVSt10moneypunctIcLb0EE"
	strings:
		$1 = { 80 B5 8F B0 1E 4B 00 AF 3B 62 3C 22 1D 4B D2 19 7B 62 BA 62 3B 1C 1C 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 ?? ?? ?? ?? 7A 68 17 4B 90 68 13 60 00 28 05 D0 03 68 01 22 5B 68 FA 60 00 F0 27 F8 01 23 5B 42 78 68 FB 60 ?? ?? ?? ?? 78 68 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 3B 69 78 68 3B 60 00 23 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_3_6_2 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EED0Ev"
		size = 146
		refs = "0026 _Unwind_SjLj_Register 004a _ZNSt6locale5facetD2Ev 0050 _ZdlPv 0058 _Unwind_SjLj_Unregister 007a _Unwind_SjLj_Resume 0080 __gxx_personality_sj0 008c _ZTVSt10moneypunctIcLb1EE"
	strings:
		$1 = { 80 B5 8F B0 1E 4B 00 AF 3B 62 3C 22 1D 4B D2 19 7B 62 BA 62 3B 1C 1C 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 ?? ?? ?? ?? 7A 68 17 4B 90 68 13 60 00 28 05 D0 03 68 01 22 5B 68 FA 60 00 F0 27 F8 01 23 5B 42 78 68 FB 60 ?? ?? ?? ?? 78 68 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 3B 69 78 68 3B 60 00 23 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_54_2_2 {
	meta:
		name = "_ZNSt8numpunctIcED0Ev"
		size = 146
		refs = "0026 _Unwind_SjLj_Register 004a _ZNSt6locale5facetD2Ev 0050 _ZdlPv 0058 _Unwind_SjLj_Unregister 007a _Unwind_SjLj_Resume 0080 __gxx_personality_sj0 008c _ZTVSt8numpunctIcE"
	strings:
		$1 = { 80 B5 8F B0 1E 4B 00 AF 3B 62 3C 22 1D 4B D2 19 7B 62 BA 62 3B 1C 1C 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 ?? ?? ?? ?? 7A 68 17 4B 90 68 13 60 00 28 05 D0 03 68 01 22 5B 68 FA 60 00 F0 27 F8 01 23 5B 42 78 68 FB 60 ?? ?? ?? ?? 78 68 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 3B 69 78 68 3B 60 00 23 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_3_7_2 {
	meta:
		name = "_ZNSt10moneypunctIcLb0EE24_M_initialize_moneypunctEPiPKc"
		size = 172
		refs = "0050 _Znwm 009c _ZNSt10money_base18_S_default_patternE 00a4 _ZNSt10money_base8_S_atomsE 00a8 _ZTVSt18__moneypunct_cacheIcLb0EE"
	strings:
		$1 = { 10 B5 04 1C 80 68 00 28 21 D0 2E 23 43 74 A3 68 2C 22 9A 74 A3 68 00 22 DA 60 9A 61 1A 62 9A 62 DA 62 1E 4A 12 68 1E 49 1A 63 99 60 59 61 D9 61 59 62 A3 68 5A 63 1B 4B 18 68 00 23 A2 68 C1 5C D2 18 38 32 01 33 11 70 0B 2B F7 D1 10 BD 44 20 ?? ?? ?? ?? 14 4A 00 23 02 60 30 22 83 54 31 22 83 54 32 22 83 54 33 22 83 54 34 22 83 54 35 22 83 54 36 22 83 54 37 22 83 54 43 22 43 74 83 74 43 60 83 60 C3 60 03 74 43 61 83 61 C3 61 03 62 43 62 83 62 C3 62 83 54 A0 60 B6 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_3_8_2 {
	meta:
		name = "_ZNSt10moneypunctIcLb1EE24_M_initialize_moneypunctEPiPKc"
		size = 172
		refs = "0050 _Znwm 009c _ZNSt10money_base18_S_default_patternE 00a4 _ZNSt10money_base8_S_atomsE 00a8 _ZTVSt18__moneypunct_cacheIcLb1EE"
	strings:
		$1 = { 10 B5 04 1C 80 68 00 28 21 D0 2E 23 43 74 A3 68 2C 22 9A 74 A3 68 00 22 DA 60 9A 61 1A 62 9A 62 DA 62 1E 4A 12 68 1E 49 1A 63 99 60 59 61 D9 61 59 62 A3 68 5A 63 1B 4B 18 68 00 23 A2 68 C1 5C D2 18 38 32 01 33 11 70 0B 2B F7 D1 10 BD 44 20 ?? ?? ?? ?? 14 4A 00 23 02 60 30 22 83 54 31 22 83 54 32 22 83 54 33 22 83 54 34 22 83 54 35 22 83 54 36 22 83 54 37 22 83 54 43 22 43 74 83 74 43 60 83 60 C3 60 03 74 43 61 83 61 C3 61 03 62 43 62 83 62 C3 62 83 54 A0 60 B6 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_0_2 {
	meta:
		name = "_ZNSt6__norm15_List_node_base4swapERS0_S1_"
		size = 80
		altNames = "_ZNSt15_List_node_base4swapERS_S0_"
	strings:
		$1 = { 03 68 83 42 11 D0 0A 68 8A 42 19 D0 02 60 0B 60 4A 68 43 68 42 60 4B 60 03 68 42 68 58 60 10 60 4A 68 0B 68 11 60 59 60 70 47 0A 68 8A 42 FB D0 48 68 1A 60 58 60 03 60 53 60 09 60 49 60 F3 E7 41 68 13 60 51 60 0A 60 5A 60 00 60 40 60 EB E7 }
	condition:
		$1
}

rule file_6_1_2 {
	meta:
		name = "_ZNSt6__norm15_List_node_base8transferEPS0_S1_"
		size = 28
		altNames = "_ZNSt15_List_node_base8transferEPS_S0_"
	strings:
		$1 = { 10 B5 90 42 09 D0 4B 68 54 68 20 60 1A 60 43 68 44 60 48 68 19 60 50 60 4B 60 10 BD }
	condition:
		$1
}

rule file_6_2_2 {
	meta:
		name = "_ZNSt6__norm15_List_node_base7reverseEv"
		size = 20
		altNames = "_ZNSt15_List_node_base7reverseEv"
	strings:
		$1 = { 03 1C 00 E0 13 1C 1A 68 59 68 5A 60 19 60 90 42 F8 D1 70 47 }
	condition:
		$1
}

rule file_7_0_2 {
	meta:
		name = "_ZNK10__cxxabiv129__pointer_to_member_type_info15__pointer_catchEPKNS_17__pbase_type_infoEPPvj"
		size = 36
	strings:
		$1 = { 30 B5 05 69 0C 69 6D 68 64 68 A5 42 01 D0 00 20 30 BD C0 68 04 68 C9 68 02 33 24 69 00 F0 01 F8 F6 E7 20 47 }
	condition:
		$1
}

rule file_7_1_2 {
	meta:
		name = "_ZN10__cxxabiv129__pointer_to_member_type_infoD1Ev"
		size = 16
		refs = "0006 _ZN10__cxxabiv117__pbase_type_infoD2Ev 000c _ZTVN10__cxxabiv129__pointer_to_member_type_infoE"
		altNames = "_ZN10__cxxabiv129__pointer_to_member_type_infoD2Ev"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_11_2 {
	meta:
		name = "_ZN10__cxxabiv115__forced_unwindD0Ev"
		size = 16
		refs = "0006 _ZdlPv 000c _ZTVN10__cxxabiv115__forced_unwindE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_0_2 {
	meta:
		name = "_ZN10__cxxabiv116__enum_type_infoD1Ev"
		size = 16
		refs = "0006 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv116__enum_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_1_2 {
	meta:
		name = "_ZN10__cxxabiv116__enum_type_infoD2Ev"
		size = 16
		refs = "0006 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv116__enum_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_0_2 {
	meta:
		name = "_ZN10__cxxabiv117__array_type_infoD1Ev"
		size = 16
		refs = "0006 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv117__array_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_1_2 {
	meta:
		name = "_ZN10__cxxabiv117__array_type_infoD2Ev"
		size = 16
		refs = "0006 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv117__array_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_5_2 {
	meta:
		name = "_ZN10__cxxabiv117__class_type_infoD1Ev"
		size = 16
		refs = "0006 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv117__class_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_6_2 {
	meta:
		name = "_ZN10__cxxabiv117__class_type_infoD2Ev"
		size = 16
		refs = "0006 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv117__class_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_2_2 {
	meta:
		name = "_ZN10__cxxabiv117__pbase_type_infoD1Ev"
		size = 16
		refs = "0006 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv117__pbase_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_3_2 {
	meta:
		name = "_ZN10__cxxabiv117__pbase_type_infoD2Ev"
		size = 16
		refs = "0006 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv117__pbase_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_10_2 {
	meta:
		name = "_ZN10__cxxabiv119__foreign_exceptionD0Ev"
		size = 16
		refs = "0006 _ZdlPv 000c _ZTVN10__cxxabiv119__foreign_exceptionE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_2_2 {
	meta:
		name = "_ZN10__cxxabiv119__pointer_type_infoD1Ev"
		size = 16
		refs = "0006 _ZN10__cxxabiv117__pbase_type_infoD2Ev 000c _ZTVN10__cxxabiv119__pointer_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_3_2 {
	meta:
		name = "_ZN10__cxxabiv119__pointer_type_infoD2Ev"
		size = 16
		refs = "0006 _ZN10__cxxabiv117__pbase_type_infoD2Ev 000c _ZTVN10__cxxabiv119__pointer_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_1_2 {
	meta:
		name = "_ZN10__cxxabiv120__function_type_infoD1Ev"
		size = 16
		refs = "0006 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv120__function_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_2_2 {
	meta:
		name = "_ZN10__cxxabiv120__function_type_infoD2Ev"
		size = 16
		refs = "0006 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv120__function_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_3_2 {
	meta:
		name = "_ZN10__cxxabiv120__si_class_type_infoD1Ev"
		size = 16
		refs = "0006 _ZN10__cxxabiv117__class_type_infoD2Ev 000c _ZTVN10__cxxabiv120__si_class_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_4_2 {
	meta:
		name = "_ZN10__cxxabiv120__si_class_type_infoD2Ev"
		size = 16
		refs = "0006 _ZN10__cxxabiv117__class_type_infoD2Ev 000c _ZTVN10__cxxabiv120__si_class_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_3_2 {
	meta:
		name = "_ZN10__cxxabiv121__vmi_class_type_infoD1Ev"
		size = 16
		refs = "0006 _ZN10__cxxabiv117__class_type_infoD2Ev 000c _ZTVN10__cxxabiv121__vmi_class_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_4_2 {
	meta:
		name = "_ZN10__cxxabiv121__vmi_class_type_infoD2Ev"
		size = 16
		refs = "0006 _ZN10__cxxabiv117__class_type_infoD2Ev 000c _ZTVN10__cxxabiv121__vmi_class_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_0_2 {
	meta:
		name = "_ZN10__cxxabiv123__fundamental_type_infoD1Ev"
		size = 16
		refs = "0006 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv123__fundamental_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_1_2 {
	meta:
		name = "_ZN10__cxxabiv123__fundamental_type_infoD2Ev"
		size = 16
		refs = "0006 _ZNSt9type_infoD2Ev 000c _ZTVN10__cxxabiv123__fundamental_type_infoE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_13_2 {
	meta:
		name = "_ZN12_GLOBAL__N_121system_error_categoryD0Ev"
		size = 16
		refs = "0006 _ZdlPv 000c _ZTVSt14error_category"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_12_2 {
	meta:
		name = "_ZN12_GLOBAL__N_122generic_error_categoryD0Ev"
		size = 16
		refs = "0006 _ZdlPv 000c _ZTVSt14error_category"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_3_2 {
	meta:
		name = "_ZN9__gnu_cxx20recursive_init_errorD1Ev"
		size = 16
		refs = "0006 _ZNSt9exceptionD2Ev 000c _ZTVN9__gnu_cxx20recursive_init_errorE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_4_2 {
	meta:
		name = "_ZN9__gnu_cxx20recursive_init_errorD2Ev"
		size = 16
		refs = "0006 _ZNSt9exceptionD2Ev 000c _ZTVN9__gnu_cxx20recursive_init_errorE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_1_2 {
	meta:
		name = "_ZNSt10bad_typeidD1Ev"
		size = 16
		refs = "0006 _ZNSt9exceptionD2Ev 000c _ZTVSt10bad_typeid"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_2_2 {
	meta:
		name = "_ZNSt10bad_typeidD2Ev"
		size = 16
		refs = "0006 _ZNSt9exceptionD2Ev 000c _ZTVSt10bad_typeid"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_37_2 {
	meta:
		name = "_ZNSt11range_errorD1Ev"
		size = 16
		refs = "0006 _ZNSt13runtime_errorD2Ev 000c _ZTVSt11range_error"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_4_2 {
	meta:
		name = "_ZNSt12ctype_bynameIcED1Ev"
		size = 16
		refs = "0006 _ZNSt5ctypeIcED2Ev 000c _ZTVSt12ctype_bynameIcE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_5_2 {
	meta:
		name = "_ZNSt12ctype_bynameIcED2Ev"
		size = 16
		refs = "0006 _ZNSt5ctypeIcED2Ev 000c _ZTVSt12ctype_bynameIcE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_10_2 {
	meta:
		name = "_ZNSt12domain_errorD1Ev"
		size = 16
		refs = "0006 _ZNSt11logic_errorD2Ev 000c _ZTVSt12domain_error"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_6_2 {
	meta:
		name = "_ZNSt12length_errorD1Ev"
		size = 16
		refs = "0006 _ZNSt11logic_errorD2Ev 000c _ZTVSt12length_error"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_4_2 {
	meta:
		name = "_ZNSt12out_of_rangeD1Ev"
		size = 16
		refs = "0006 _ZNSt11logic_errorD2Ev 000c _ZTVSt12out_of_range"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_18_2 {
	meta:
		name = "_ZNSt12system_errorD1Ev"
		size = 16
		refs = "0006 _ZNSt13runtime_errorD2Ev 000c _ZTVSt12system_error"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_19_2 {
	meta:
		name = "_ZNSt12system_errorD2Ev"
		size = 16
		refs = "0006 _ZNSt13runtime_errorD2Ev 000c _ZTVSt12system_error"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_13_2 {
	meta:
		name = "_ZNSt13bad_exceptionD0Ev"
		size = 16
		refs = "0006 _ZdlPv 000c _ZTVSt9exception"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_202_2 {
	meta:
		name = "_ZNSt14codecvt_bynameIcc10_mbstate_tED1Ev"
		size = 16
		refs = "0006 _ZNSt7codecvtIcc10_mbstate_tED2Ev 000c _ZTVSt14codecvt_bynameIcc10_mbstate_tE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_203_2 {
	meta:
		name = "_ZNSt14codecvt_bynameIcc10_mbstate_tED2Ev"
		size = 16
		refs = "0006 _ZNSt7codecvtIcc10_mbstate_tED2Ev 000c _ZTVSt14codecvt_bynameIcc10_mbstate_tE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_11_2 {
	meta:
		name = "_ZNSt14error_categoryD0Ev"
		size = 16
		refs = "0006 _ZdlPv 000c _ZTVSt14error_category"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_35_2 {
	meta:
		name = "_ZNSt14overflow_errorD1Ev"
		size = 16
		refs = "0006 _ZNSt13runtime_errorD2Ev 000c _ZTVSt14overflow_error"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_180_2 {
	meta:
		name = "_ZNSt15messages_bynameIcED1Ev"
		size = 16
		refs = "0006 _ZNSt8messagesIcED2Ev 000c _ZTVSt15messages_bynameIcE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_181_2 {
	meta:
		name = "_ZNSt15messages_bynameIcED2Ev"
		size = 16
		refs = "0006 _ZNSt8messagesIcED2Ev 000c _ZTVSt15messages_bynameIcE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_217_2 {
	meta:
		name = "_ZNSt15numpunct_bynameIcED1Ev"
		size = 16
		refs = "0006 _ZNSt8numpunctIcED2Ev 000c _ZTVSt15numpunct_bynameIcE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_218_2 {
	meta:
		name = "_ZNSt15numpunct_bynameIcED2Ev"
		size = 16
		refs = "0006 _ZNSt8numpunctIcED2Ev 000c _ZTVSt15numpunct_bynameIcE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_258_2 {
	meta:
		name = "_ZNSt15time_get_bynameIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_259_2 {
	meta:
		name = "_ZNSt15time_get_bynameIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_255_2 {
	meta:
		name = "_ZNSt15time_put_bynameIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_256_2 {
	meta:
		name = "_ZNSt15time_put_bynameIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_4_2 {
	meta:
		name = "_ZNSt15underflow_errorD1Ev"
		size = 16
		refs = "0006 _ZNSt13runtime_errorD2Ev 000c _ZTVSt15underflow_error"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_14_2 {
	meta:
		name = "_ZNSt16invalid_argumentD1Ev"
		size = 16
		refs = "0006 _ZNSt11logic_errorD2Ev 000c _ZTVSt16invalid_argument"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_120_2 {
	meta:
		name = "_ZNSt17__timepunct_cacheIcED1Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt17__timepunct_cacheIcE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_121_2 {
	meta:
		name = "_ZNSt17__timepunct_cacheIcED2Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt17__timepunct_cacheIcE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_246_2 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb0EED1Ev"
		size = 16
		refs = "0006 _ZNSt10moneypunctIcLb0EED2Ev 000c _ZTVSt17moneypunct_bynameIcLb0EE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_247_2 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb0EED2Ev"
		size = 16
		refs = "0006 _ZNSt10moneypunctIcLb0EED2Ev 000c _ZTVSt17moneypunct_bynameIcLb0EE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_237_2 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb1EED1Ev"
		size = 16
		refs = "0006 _ZNSt10moneypunctIcLb1EED2Ev 000c _ZTVSt17moneypunct_bynameIcLb1EE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_238_2 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb1EED2Ev"
		size = 16
		refs = "0006 _ZNSt10moneypunctIcLb1EED2Ev 000c _ZTVSt17moneypunct_bynameIcLb1EE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_115_2 {
	meta:
		name = "_ZNSt21__ctype_abstract_baseIcED1Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt21__ctype_abstract_baseIcE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_114_2 {
	meta:
		name = "_ZNSt23__codecvt_abstract_baseIcc10_mbstate_tED1Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt23__codecvt_abstract_baseIcc10_mbstate_tE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_11_2 {
	meta:
		name = "_ZNSt6locale5facetD0Ev"
		size = 16
		refs = "0006 _ZdlPv 000c _ZTVNSt6locale5facetE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_124_2 {
	meta:
		name = "_ZNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_125_2 {
	meta:
		name = "_ZNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_122_2 {
	meta:
		name = "_ZNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_123_2 {
	meta:
		name = "_ZNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_1_2 {
	meta:
		name = "_ZNSt8bad_castD1Ev"
		size = 16
		refs = "0006 _ZNSt9exceptionD2Ev 000c _ZTVSt8bad_cast"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_2_2 {
	meta:
		name = "_ZNSt8bad_castD2Ev"
		size = 16
		refs = "0006 _ZNSt9exceptionD2Ev 000c _ZTVSt8bad_cast"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_116_2 {
	meta:
		name = "_ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_117_2 {
	meta:
		name = "_ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_118_2 {
	meta:
		name = "_ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_119_2 {
	meta:
		name = "_ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_2_2 {
	meta:
		name = "_ZNSt9bad_allocD1Ev"
		size = 16
		refs = "0006 _ZNSt9exceptionD2Ev 000c _ZTVSt9bad_alloc"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_3_2 {
	meta:
		name = "_ZNSt9bad_allocD2Ev"
		size = 16
		refs = "0006 _ZNSt9exceptionD2Ev 000c _ZTVSt9bad_alloc"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_18_2 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEED1Ev"
		size = 16
		refs = "0006 _ZNSt8ios_baseD2Ev 000c _ZTVSt9basic_iosIcSt11char_traitsIcEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_19_2 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEED2Ev"
		size = 16
		refs = "0006 _ZNSt8ios_baseD2Ev 000c _ZTVSt9basic_iosIcSt11char_traitsIcEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_28_12_2 {
	meta:
		name = "_ZNSt9exceptionD0Ev"
		size = 16
		refs = "0006 _ZdlPv 000c _ZTVSt9exception"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_128_2 {
	meta:
		name = "_ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_129_2 {
	meta:
		name = "_ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_126_2 {
	meta:
		name = "_ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED1Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_127_2 {
	meta:
		name = "_ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED2Ev"
		size = 16
		refs = "0006 _ZNSt6locale5facetD2Ev 000c _ZTVSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_6_2 {
	meta:
		name = "_ZNSt9type_infoD0Ev"
		size = 16
		refs = "0006 _ZdlPv 000c _ZTVSt9type_info"
	strings:
		$1 = { 00 B5 02 4B 03 60 ?? ?? ?? ?? 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_7_3_2 {
	meta:
		name = "_ZN10__cxxabiv129__pointer_to_member_type_infoD0Ev"
		size = 24
		refs = "0008 _ZN10__cxxabiv117__pbase_type_infoD2Ev 000e _ZdlPv 0014 _ZTVN10__cxxabiv129__pointer_to_member_type_infoE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_70_2_2 {
	meta:
		name = "_ZN10__cxxabiv116__enum_type_infoD0Ev"
		size = 24
		refs = "0008 _ZNSt9type_infoD2Ev 000e _ZdlPv 0014 _ZTVN10__cxxabiv116__enum_type_infoE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_2_2 {
	meta:
		name = "_ZN10__cxxabiv117__array_type_infoD0Ev"
		size = 24
		refs = "0008 _ZNSt9type_infoD2Ev 000e _ZdlPv 0014 _ZTVN10__cxxabiv117__array_type_infoE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_7_2 {
	meta:
		name = "_ZN10__cxxabiv117__class_type_infoD0Ev"
		size = 24
		refs = "0008 _ZNSt9type_infoD2Ev 000e _ZdlPv 0014 _ZTVN10__cxxabiv117__class_type_infoE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_72_4_2 {
	meta:
		name = "_ZN10__cxxabiv117__pbase_type_infoD0Ev"
		size = 24
		refs = "0008 _ZNSt9type_infoD2Ev 000e _ZdlPv 0014 _ZTVN10__cxxabiv117__pbase_type_infoE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_4_2 {
	meta:
		name = "_ZN10__cxxabiv119__pointer_type_infoD0Ev"
		size = 24
		refs = "0008 _ZN10__cxxabiv117__pbase_type_infoD2Ev 000e _ZdlPv 0014 _ZTVN10__cxxabiv119__pointer_type_infoE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_3_2 {
	meta:
		name = "_ZN10__cxxabiv120__function_type_infoD0Ev"
		size = 24
		refs = "0008 _ZNSt9type_infoD2Ev 000e _ZdlPv 0014 _ZTVN10__cxxabiv120__function_type_infoE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_69_5_2 {
	meta:
		name = "_ZN10__cxxabiv120__si_class_type_infoD0Ev"
		size = 24
		refs = "0008 _ZN10__cxxabiv117__class_type_infoD2Ev 000e _ZdlPv 0014 _ZTVN10__cxxabiv120__si_class_type_infoE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_5_2 {
	meta:
		name = "_ZN10__cxxabiv121__vmi_class_type_infoD0Ev"
		size = 24
		refs = "0008 _ZN10__cxxabiv117__class_type_infoD2Ev 000e _ZdlPv 0014 _ZTVN10__cxxabiv121__vmi_class_type_infoE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_92_2_2 {
	meta:
		name = "_ZN10__cxxabiv123__fundamental_type_infoD0Ev"
		size = 24
		refs = "0008 _ZNSt9type_infoD2Ev 000e _ZdlPv 0014 _ZTVN10__cxxabiv123__fundamental_type_infoE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_5_2 {
	meta:
		name = "_ZN9__gnu_cxx20recursive_init_errorD0Ev"
		size = 24
		refs = "0008 _ZNSt9exceptionD2Ev 000e _ZdlPv 0014 _ZTVN9__gnu_cxx20recursive_init_errorE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_43_3_2 {
	meta:
		name = "_ZNSt10bad_typeidD0Ev"
		size = 24
		refs = "0008 _ZNSt9exceptionD2Ev 000e _ZdlPv 0014 _ZTVSt10bad_typeid"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_9_2 {
	meta:
		name = "_ZNSt11range_errorD0Ev"
		size = 24
		refs = "0008 _ZNSt13runtime_errorD2Ev 000e _ZdlPv 0014 _ZTVSt11range_error"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_40_6_2 {
	meta:
		name = "_ZNSt12ctype_bynameIcED0Ev"
		size = 24
		refs = "0008 _ZNSt5ctypeIcED2Ev 000e _ZdlPv 0014 _ZTVSt12ctype_bynameIcE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_9_2 {
	meta:
		name = "_ZNSt12domain_errorD0Ev"
		size = 24
		refs = "0008 _ZNSt11logic_errorD2Ev 000e _ZdlPv 0014 _ZTVSt12domain_error"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_5_2 {
	meta:
		name = "_ZNSt12length_errorD0Ev"
		size = 24
		refs = "0008 _ZNSt11logic_errorD2Ev 000e _ZdlPv 0014 _ZTVSt12length_error"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_3_2 {
	meta:
		name = "_ZNSt12out_of_rangeD0Ev"
		size = 24
		refs = "0008 _ZNSt11logic_errorD2Ev 000e _ZdlPv 0014 _ZTVSt12out_of_range"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_17_2 {
	meta:
		name = "_ZNSt12system_errorD0Ev"
		size = 24
		refs = "0008 _ZNSt13runtime_errorD2Ev 000e _ZdlPv 0014 _ZTVSt12system_error"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_201_2 {
	meta:
		name = "_ZNSt14codecvt_bynameIcc10_mbstate_tED0Ev"
		size = 24
		refs = "0008 _ZNSt7codecvtIcc10_mbstate_tED2Ev 000e _ZdlPv 0014 _ZTVSt14codecvt_bynameIcc10_mbstate_tE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_8_2 {
	meta:
		name = "_ZNSt14overflow_errorD0Ev"
		size = 24
		refs = "0008 _ZNSt13runtime_errorD2Ev 000e _ZdlPv 0014 _ZTVSt14overflow_error"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_179_2 {
	meta:
		name = "_ZNSt15messages_bynameIcED0Ev"
		size = 24
		refs = "0008 _ZNSt8messagesIcED2Ev 000e _ZdlPv 0014 _ZTVSt15messages_bynameIcE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_216_2 {
	meta:
		name = "_ZNSt15numpunct_bynameIcED0Ev"
		size = 24
		refs = "0008 _ZNSt8numpunctIcED2Ev 000e _ZdlPv 0014 _ZTVSt15numpunct_bynameIcE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_257_2 {
	meta:
		name = "_ZNSt15time_get_bynameIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 24
		refs = "0008 _ZNSt6locale5facetD2Ev 000e _ZdlPv 0014 _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_254_2 {
	meta:
		name = "_ZNSt15time_put_bynameIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 24
		refs = "0008 _ZNSt6locale5facetD2Ev 000e _ZdlPv 0014 _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_7_2 {
	meta:
		name = "_ZNSt15underflow_errorD0Ev"
		size = 24
		refs = "0008 _ZNSt13runtime_errorD2Ev 000e _ZdlPv 0014 _ZTVSt15underflow_error"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_7_2 {
	meta:
		name = "_ZNSt16invalid_argumentD0Ev"
		size = 24
		refs = "0008 _ZNSt11logic_errorD2Ev 000e _ZdlPv 0014 _ZTVSt16invalid_argument"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_134_2 {
	meta:
		name = "_ZNSt17__timepunct_cacheIcED0Ev"
		size = 24
		refs = "0008 _ZNSt6locale5facetD2Ev 000e _ZdlPv 0014 _ZTVSt17__timepunct_cacheIcE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_245_2 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb0EED0Ev"
		size = 24
		refs = "0008 _ZNSt10moneypunctIcLb0EED2Ev 000e _ZdlPv 0014 _ZTVSt17moneypunct_bynameIcLb0EE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_236_2 {
	meta:
		name = "_ZNSt17moneypunct_bynameIcLb1EED0Ev"
		size = 24
		refs = "0008 _ZNSt10moneypunctIcLb1EED2Ev 000e _ZdlPv 0014 _ZTVSt17moneypunct_bynameIcLb1EE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_131_2 {
	meta:
		name = "_ZNSt21__ctype_abstract_baseIcED0Ev"
		size = 24
		refs = "0008 _ZNSt6locale5facetD2Ev 000e _ZdlPv 0014 _ZTVSt21__ctype_abstract_baseIcE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_130_2 {
	meta:
		name = "_ZNSt23__codecvt_abstract_baseIcc10_mbstate_tED0Ev"
		size = 24
		refs = "0008 _ZNSt6locale5facetD2Ev 000e _ZdlPv 0014 _ZTVSt23__codecvt_abstract_baseIcc10_mbstate_tE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_136_2 {
	meta:
		name = "_ZNSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 24
		refs = "0008 _ZNSt6locale5facetD2Ev 000e _ZdlPv 0014 _ZTVSt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_135_2 {
	meta:
		name = "_ZNSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 24
		refs = "0008 _ZNSt6locale5facetD2Ev 000e _ZdlPv 0014 _ZTVSt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_3_2 {
	meta:
		name = "_ZNSt8bad_castD0Ev"
		size = 24
		refs = "0008 _ZNSt9exceptionD2Ev 000e _ZdlPv 0014 _ZTVSt8bad_cast"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_132_2 {
	meta:
		name = "_ZNSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 24
		refs = "0008 _ZNSt6locale5facetD2Ev 000e _ZdlPv 0014 _ZTVSt8time_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_133_2 {
	meta:
		name = "_ZNSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 24
		refs = "0008 _ZNSt6locale5facetD2Ev 000e _ZdlPv 0014 _ZTVSt8time_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_4_2 {
	meta:
		name = "_ZNSt9bad_allocD0Ev"
		size = 24
		refs = "0008 _ZNSt9exceptionD2Ev 000e _ZdlPv 0014 _ZTVSt9bad_alloc"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_20_2 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEED0Ev"
		size = 24
		refs = "0008 _ZNSt8ios_baseD2Ev 000e _ZdlPv 0014 _ZTVSt9basic_iosIcSt11char_traitsIcEE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_138_2 {
	meta:
		name = "_ZNSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 24
		refs = "0008 _ZNSt6locale5facetD2Ev 000e _ZdlPv 0014 _ZTVSt9money_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_49_137_2 {
	meta:
		name = "_ZNSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEED0Ev"
		size = 24
		refs = "0008 _ZNSt6locale5facetD2Ev 000e _ZdlPv 0014 _ZTVSt9money_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEE"
	strings:
		$1 = { 10 B5 04 4B 04 1C 03 60 ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_8_0_2 {
	meta:
		name = "_ZNSt8ios_base5imbueERKSt6locale"
		size = 38
		refs = "000e _ZNSt6localeC1ERKS_ 0016 _ZNSt6localeaSERKS_ 001e _ZNSt8ios_base17_M_call_callbacksENS_5eventE"
	strings:
		$1 = { F0 B5 0E 1C 6C 36 17 1C 0D 1C 31 1C 04 1C ?? ?? ?? ?? 39 1C 30 1C ?? ?? ?? ?? 28 1C 01 21 ?? ?? ?? ?? 20 1C F0 BD }
	condition:
		$1
}

rule file_8_1_2 {
	meta:
		name = "_ZNSt8ios_base7_M_initEv"
		size = 48
		refs = "0014 _ZNSt6localeC1Ev 001e _ZNSt6localeaSERKS_ 0024 _ZNSt6localeD1Ev"
	strings:
		$1 = { 30 B5 06 23 43 60 00 23 83 60 08 4B 81 B0 C3 60 04 1C 68 46 ?? ?? ?? ?? 20 1C 69 46 6C 30 ?? ?? ?? ?? 68 46 ?? ?? ?? ?? 01 B0 30 BD 02 10 00 00 }
	condition:
		$1
}

rule file_9_0_2 {
	meta:
		name = "_ZSt18__throw_bad_typeidv"
		size = 32
		refs = "0004 __cxa_allocate_exception 0010 __cxa_throw 0014 _ZTVSt10bad_typeid 0018 _ZTISt10bad_typeid 001c _ZNSt10bad_typeidD1Ev"
		altNames = "__cxa_bad_typeid"
	strings:
		$1 = { 00 B5 04 20 ?? ?? ?? ?? 02 4B 03 49 03 60 03 4A ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_1_2 {
	meta:
		name = "_ZSt16__throw_bad_castv"
		size = 32
		refs = "0004 __cxa_allocate_exception 0010 __cxa_throw 0014 _ZTVSt8bad_cast 0018 _ZTISt8bad_cast 001c _ZNSt8bad_castD1Ev"
	strings:
		$1 = { 00 B5 04 20 ?? ?? ?? ?? 02 4B 03 49 03 60 03 4A ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_2_2 {
	meta:
		name = "_ZSt17__throw_bad_allocv"
		size = 32
		refs = "0004 __cxa_allocate_exception 0010 __cxa_throw 0014 _ZTVSt9bad_alloc 0018 _ZTISt9bad_alloc 001c _ZNSt9bad_allocD1Ev"
	strings:
		$1 = { 00 B5 04 20 ?? ?? ?? ?? 02 4B 03 49 03 60 03 4A ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_3_2 {
	meta:
		name = "_ZSt21__throw_bad_exceptionv"
		size = 32
		refs = "0004 __cxa_allocate_exception 0010 __cxa_throw 0014 _ZTVSt13bad_exception 0018 _ZTISt13bad_exception 001c _ZNSt13bad_exceptionD1Ev"
	strings:
		$1 = { 00 B5 04 20 ?? ?? ?? ?? 02 4B 03 49 03 60 03 4A ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_14_1_2 {
	meta:
		name = "__cxa_bad_cast"
		size = 32
		refs = "0004 __cxa_allocate_exception 0010 __cxa_throw 0014 _ZTVSt8bad_cast 0018 _ZTISt8bad_cast 001c _ZNSt8bad_castD1Ev"
	strings:
		$1 = { 00 B5 04 20 ?? ?? ?? ?? 02 4B 03 49 03 60 03 4A ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_18_2 {
	meta:
		name = "_ZSt20__throw_system_errori"
		size = 228
		refs = "0026 _Unwind_SjLj_Register 0030 _ZSt16generic_categoryv 0038 __cxa_allocate_exception 004c _ZNSsC1EPKcRKSaIcE 005a _ZNSt13runtime_errorC2ERKSs 0082 __cxa_throw 0094 _ZNSs4_Rep10_M_destroyERKSaIcE 00ae _ZNSsD1Ev 00b4 __cxa_free_exception 00c0 _Unwind_SjLj_Resume 00c4 __gxx_personality_sj0 00d4 _ZNSs4_Rep20_S_empty_rep_storageE 00d8 _ZTVSt12system_error 00dc _ZTISt12system_error 00e0 _ZNSt12system_errorD1Ev"
	strings:
		$1 = { 80 B5 93 B0 2F 4B 00 AF 7B 62 4C 22 2E 4B D2 19 BB 62 FA 62 3B 1C 2D 4A 2C 33 5A 60 38 60 6A 46 38 1C 9A 60 0C 30 ?? ?? ?? ?? 01 23 5B 42 3B 61 ?? ?? ?? ?? 78 60 10 20 ?? ?? ?? ?? 3A 1C B8 60 38 1C 02 23 44 30 22 49 48 32 3B 61 ?? ?? ?? ?? 39 1C 01 23 B8 68 44 31 3B 61 ?? ?? ?? ?? 78 6C 1C 4B 0C 38 98 42 0E D1 BA 68 1B 4B 13 60 7B 68 D3 60 3B 68 93 60 01 23 5B 42 10 1C 17 49 18 4A 3B 61 ?? ?? ?? ?? 83 68 5A 1E 82 60 00 2B EB DC 39 1C 40 31 ?? ?? ?? ?? E6 E7 4C 3F 7B 69 7B 60 3B 69 01 2B 05 D0 38 1C 00 23 44 30 3B 61 ?? ?? ?? ?? B8 68 ?? ?? ?? ?? 01 23 5B 42 78 68 3B 61 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_19_2 {
	meta:
		name = "_ZSt19__throw_ios_failurePKc"
		size = 160
		refs = "0024 _Unwind_SjLj_Register 0036 _ZNSsC1EPKcRKSaIcE 003c __cxa_allocate_exception 0046 _ZNSt8ios_base7failureC1ERKSs 0060 __cxa_throw 0072 _ZNSs4_Rep10_M_destroyERKSaIcE 0082 _Unwind_SjLj_Resume 0088 __gxx_personality_sj0 0094 _ZNSs4_Rep20_S_empty_rep_storageE 0098 _ZTINSt8ios_base7failureE 009c _ZNSt8ios_base7failureD1Ev"
	strings:
		$1 = { 80 B5 91 B0 20 4B 00 AF FB 61 44 22 1F 4B D2 19 3B 62 7A 62 3B 1C 1E 4A 24 33 5A 60 6A 46 9A 60 38 60 38 1D ?? ?? ?? ?? 38 1C 3A 1C 01 23 3C 30 39 68 40 32 BB 60 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 39 1C 3C 31 38 60 ?? ?? ?? ?? F8 6B 11 4B 0C 38 98 42 07 D1 01 23 5B 42 38 68 0F 49 0F 4A BB 60 ?? ?? ?? ?? 83 68 5A 1E 82 60 00 2B F2 DC 39 1C 38 31 ?? ?? ?? ?? ED E7 44 3F 01 23 5B 42 F8 68 BB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_20_2 {
	meta:
		name = "_ZSt23__throw_underflow_errorPKc"
		size = 212
		refs = "0026 _Unwind_SjLj_Register 0038 _ZNSsC1EPKcRKSaIcE 003e __cxa_allocate_exception 004c _ZNSt15underflow_errorC1ERKSs 0066 __cxa_throw 0078 _ZNSs4_Rep10_M_destroyERKSaIcE 009e _Unwind_SjLj_Resume 00a4 __cxa_free_exception 00b0 _ZNSsD1Ev 00b6 _ZSt9terminatev 00bc __gxx_personality_sj0 00c8 _ZNSs4_Rep20_S_empty_rep_storageE 00cc _ZTISt15underflow_error 00d0 _ZNSt15underflow_errorD1Ev"
	strings:
		$1 = { 80 B5 93 B0 2D 4B 00 AF 7B 62 4C 22 2C 4B D2 19 BB 62 FA 62 3B 1C 2B 4A 2C 33 5A 60 78 60 6A 46 38 1C 9A 60 0C 30 ?? ?? ?? ?? 38 1C 3A 1C 03 23 44 30 79 68 48 32 3B 61 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 39 1C 02 23 44 31 B8 60 3B 61 ?? ?? ?? ?? 78 6C 1D 4B 0C 38 98 42 07 D1 01 23 5B 42 B8 68 1A 49 1B 4A 3B 61 ?? ?? ?? ?? 83 68 5A 1E 82 60 00 2B F2 DC 39 1C 40 31 ?? ?? ?? ?? ED E7 4C 3F 7B 69 3A 69 3B 60 7A 60 BB 69 01 2A 09 D0 02 2A 01 D0 01 33 0F D0 01 23 5B 42 38 68 3B 61 ?? ?? ?? ?? B8 68 ?? ?? ?? ?? 7B 68 38 1C 44 30 3B 61 ?? ?? ?? ?? EF E7 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_28_2 {
	meta:
		name = "_ZSt19__throw_logic_errorPKc"
		size = 212
		refs = "0026 _Unwind_SjLj_Register 0038 _ZNSsC1EPKcRKSaIcE 003e __cxa_allocate_exception 004c _ZNSt11logic_errorC1ERKSs 0066 __cxa_throw 0078 _ZNSs4_Rep10_M_destroyERKSaIcE 009e _Unwind_SjLj_Resume 00a4 __cxa_free_exception 00b0 _ZNSsD1Ev 00b6 _ZSt9terminatev 00bc __gxx_personality_sj0 00c8 _ZNSs4_Rep20_S_empty_rep_storageE 00cc _ZTISt11logic_error 00d0 _ZNSt11logic_errorD1Ev"
	strings:
		$1 = { 80 B5 93 B0 2D 4B 00 AF 7B 62 4C 22 2C 4B D2 19 BB 62 FA 62 3B 1C 2B 4A 2C 33 5A 60 78 60 6A 46 38 1C 9A 60 0C 30 ?? ?? ?? ?? 38 1C 3A 1C 03 23 44 30 79 68 48 32 3B 61 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 39 1C 02 23 44 31 B8 60 3B 61 ?? ?? ?? ?? 78 6C 1D 4B 0C 38 98 42 07 D1 01 23 5B 42 B8 68 1A 49 1B 4A 3B 61 ?? ?? ?? ?? 83 68 5A 1E 82 60 00 2B F2 DC 39 1C 40 31 ?? ?? ?? ?? ED E7 4C 3F 7B 69 3A 69 3B 60 7A 60 BB 69 01 2A 09 D0 02 2A 01 D0 01 33 0F D0 01 23 5B 42 38 68 3B 61 ?? ?? ?? ?? B8 68 ?? ?? ?? ?? 7B 68 38 1C 44 30 3B 61 ?? ?? ?? ?? EF E7 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_22_2 {
	meta:
		name = "_ZSt19__throw_range_errorPKc"
		size = 212
		refs = "0026 _Unwind_SjLj_Register 0038 _ZNSsC1EPKcRKSaIcE 003e __cxa_allocate_exception 004c _ZNSt11range_errorC1ERKSs 0066 __cxa_throw 0078 _ZNSs4_Rep10_M_destroyERKSaIcE 009e _Unwind_SjLj_Resume 00a4 __cxa_free_exception 00b0 _ZNSsD1Ev 00b6 _ZSt9terminatev 00bc __gxx_personality_sj0 00c8 _ZNSs4_Rep20_S_empty_rep_storageE 00cc _ZTISt11range_error 00d0 _ZNSt11range_errorD1Ev"
	strings:
		$1 = { 80 B5 93 B0 2D 4B 00 AF 7B 62 4C 22 2C 4B D2 19 BB 62 FA 62 3B 1C 2B 4A 2C 33 5A 60 78 60 6A 46 38 1C 9A 60 0C 30 ?? ?? ?? ?? 38 1C 3A 1C 03 23 44 30 79 68 48 32 3B 61 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 39 1C 02 23 44 31 B8 60 3B 61 ?? ?? ?? ?? 78 6C 1D 4B 0C 38 98 42 07 D1 01 23 5B 42 B8 68 1A 49 1B 4A 3B 61 ?? ?? ?? ?? 83 68 5A 1E 82 60 00 2B F2 DC 39 1C 40 31 ?? ?? ?? ?? ED E7 4C 3F 7B 69 3A 69 3B 60 7A 60 BB 69 01 2A 09 D0 02 2A 01 D0 01 33 0F D0 01 23 5B 42 38 68 3B 61 ?? ?? ?? ?? B8 68 ?? ?? ?? ?? 7B 68 38 1C 44 30 3B 61 ?? ?? ?? ?? EF E7 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_27_2 {
	meta:
		name = "_ZSt20__throw_domain_errorPKc"
		size = 212
		refs = "0026 _Unwind_SjLj_Register 0038 _ZNSsC1EPKcRKSaIcE 003e __cxa_allocate_exception 004c _ZNSt12domain_errorC1ERKSs 0066 __cxa_throw 0078 _ZNSs4_Rep10_M_destroyERKSaIcE 009e _Unwind_SjLj_Resume 00a4 __cxa_free_exception 00b0 _ZNSsD1Ev 00b6 _ZSt9terminatev 00bc __gxx_personality_sj0 00c8 _ZNSs4_Rep20_S_empty_rep_storageE 00cc _ZTISt12domain_error 00d0 _ZNSt12domain_errorD1Ev"
	strings:
		$1 = { 80 B5 93 B0 2D 4B 00 AF 7B 62 4C 22 2C 4B D2 19 BB 62 FA 62 3B 1C 2B 4A 2C 33 5A 60 78 60 6A 46 38 1C 9A 60 0C 30 ?? ?? ?? ?? 38 1C 3A 1C 03 23 44 30 79 68 48 32 3B 61 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 39 1C 02 23 44 31 B8 60 3B 61 ?? ?? ?? ?? 78 6C 1D 4B 0C 38 98 42 07 D1 01 23 5B 42 B8 68 1A 49 1B 4A 3B 61 ?? ?? ?? ?? 83 68 5A 1E 82 60 00 2B F2 DC 39 1C 40 31 ?? ?? ?? ?? ED E7 4C 3F 7B 69 3A 69 3B 60 7A 60 BB 69 01 2A 09 D0 02 2A 01 D0 01 33 0F D0 01 23 5B 42 38 68 3B 61 ?? ?? ?? ?? B8 68 ?? ?? ?? ?? 7B 68 38 1C 44 30 3B 61 ?? ?? ?? ?? EF E7 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_25_2 {
	meta:
		name = "_ZSt20__throw_length_errorPKc"
		size = 212
		refs = "0026 _Unwind_SjLj_Register 0038 _ZNSsC1EPKcRKSaIcE 003e __cxa_allocate_exception 004c _ZNSt12length_errorC1ERKSs 0066 __cxa_throw 0078 _ZNSs4_Rep10_M_destroyERKSaIcE 009e _Unwind_SjLj_Resume 00a4 __cxa_free_exception 00b0 _ZNSsD1Ev 00b6 _ZSt9terminatev 00bc __gxx_personality_sj0 00c8 _ZNSs4_Rep20_S_empty_rep_storageE 00cc _ZTISt12length_error 00d0 _ZNSt12length_errorD1Ev"
	strings:
		$1 = { 80 B5 93 B0 2D 4B 00 AF 7B 62 4C 22 2C 4B D2 19 BB 62 FA 62 3B 1C 2B 4A 2C 33 5A 60 78 60 6A 46 38 1C 9A 60 0C 30 ?? ?? ?? ?? 38 1C 3A 1C 03 23 44 30 79 68 48 32 3B 61 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 39 1C 02 23 44 31 B8 60 3B 61 ?? ?? ?? ?? 78 6C 1D 4B 0C 38 98 42 07 D1 01 23 5B 42 B8 68 1A 49 1B 4A 3B 61 ?? ?? ?? ?? 83 68 5A 1E 82 60 00 2B F2 DC 39 1C 40 31 ?? ?? ?? ?? ED E7 4C 3F 7B 69 3A 69 3B 60 7A 60 BB 69 01 2A 09 D0 02 2A 01 D0 01 33 0F D0 01 23 5B 42 38 68 3B 61 ?? ?? ?? ?? B8 68 ?? ?? ?? ?? 7B 68 38 1C 44 30 3B 61 ?? ?? ?? ?? EF E7 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_24_2 {
	meta:
		name = "_ZSt20__throw_out_of_rangePKc"
		size = 212
		refs = "0026 _Unwind_SjLj_Register 0038 _ZNSsC1EPKcRKSaIcE 003e __cxa_allocate_exception 004c _ZNSt12out_of_rangeC1ERKSs 0066 __cxa_throw 0078 _ZNSs4_Rep10_M_destroyERKSaIcE 009e _Unwind_SjLj_Resume 00a4 __cxa_free_exception 00b0 _ZNSsD1Ev 00b6 _ZSt9terminatev 00bc __gxx_personality_sj0 00c8 _ZNSs4_Rep20_S_empty_rep_storageE 00cc _ZTISt12out_of_range 00d0 _ZNSt12out_of_rangeD1Ev"
	strings:
		$1 = { 80 B5 93 B0 2D 4B 00 AF 7B 62 4C 22 2C 4B D2 19 BB 62 FA 62 3B 1C 2B 4A 2C 33 5A 60 78 60 6A 46 38 1C 9A 60 0C 30 ?? ?? ?? ?? 38 1C 3A 1C 03 23 44 30 79 68 48 32 3B 61 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 39 1C 02 23 44 31 B8 60 3B 61 ?? ?? ?? ?? 78 6C 1D 4B 0C 38 98 42 07 D1 01 23 5B 42 B8 68 1A 49 1B 4A 3B 61 ?? ?? ?? ?? 83 68 5A 1E 82 60 00 2B F2 DC 39 1C 40 31 ?? ?? ?? ?? ED E7 4C 3F 7B 69 3A 69 3B 60 7A 60 BB 69 01 2A 09 D0 02 2A 01 D0 01 33 0F D0 01 23 5B 42 38 68 3B 61 ?? ?? ?? ?? B8 68 ?? ?? ?? ?? 7B 68 38 1C 44 30 3B 61 ?? ?? ?? ?? EF E7 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_23_2 {
	meta:
		name = "_ZSt21__throw_runtime_errorPKc"
		size = 212
		refs = "0026 _Unwind_SjLj_Register 0038 _ZNSsC1EPKcRKSaIcE 003e __cxa_allocate_exception 004c _ZNSt13runtime_errorC1ERKSs 0066 __cxa_throw 0078 _ZNSs4_Rep10_M_destroyERKSaIcE 009e _Unwind_SjLj_Resume 00a4 __cxa_free_exception 00b0 _ZNSsD1Ev 00b6 _ZSt9terminatev 00bc __gxx_personality_sj0 00c8 _ZNSs4_Rep20_S_empty_rep_storageE 00cc _ZTISt13runtime_error 00d0 _ZNSt13runtime_errorD1Ev"
	strings:
		$1 = { 80 B5 93 B0 2D 4B 00 AF 7B 62 4C 22 2C 4B D2 19 BB 62 FA 62 3B 1C 2B 4A 2C 33 5A 60 78 60 6A 46 38 1C 9A 60 0C 30 ?? ?? ?? ?? 38 1C 3A 1C 03 23 44 30 79 68 48 32 3B 61 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 39 1C 02 23 44 31 B8 60 3B 61 ?? ?? ?? ?? 78 6C 1D 4B 0C 38 98 42 07 D1 01 23 5B 42 B8 68 1A 49 1B 4A 3B 61 ?? ?? ?? ?? 83 68 5A 1E 82 60 00 2B F2 DC 39 1C 40 31 ?? ?? ?? ?? ED E7 4C 3F 7B 69 3A 69 3B 60 7A 60 BB 69 01 2A 09 D0 02 2A 01 D0 01 33 0F D0 01 23 5B 42 38 68 3B 61 ?? ?? ?? ?? B8 68 ?? ?? ?? ?? 7B 68 38 1C 44 30 3B 61 ?? ?? ?? ?? EF E7 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_21_2 {
	meta:
		name = "_ZSt22__throw_overflow_errorPKc"
		size = 212
		refs = "0026 _Unwind_SjLj_Register 0038 _ZNSsC1EPKcRKSaIcE 003e __cxa_allocate_exception 004c _ZNSt14overflow_errorC1ERKSs 0066 __cxa_throw 0078 _ZNSs4_Rep10_M_destroyERKSaIcE 009e _Unwind_SjLj_Resume 00a4 __cxa_free_exception 00b0 _ZNSsD1Ev 00b6 _ZSt9terminatev 00bc __gxx_personality_sj0 00c8 _ZNSs4_Rep20_S_empty_rep_storageE 00cc _ZTISt14overflow_error 00d0 _ZNSt14overflow_errorD1Ev"
	strings:
		$1 = { 80 B5 93 B0 2D 4B 00 AF 7B 62 4C 22 2C 4B D2 19 BB 62 FA 62 3B 1C 2B 4A 2C 33 5A 60 78 60 6A 46 38 1C 9A 60 0C 30 ?? ?? ?? ?? 38 1C 3A 1C 03 23 44 30 79 68 48 32 3B 61 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 39 1C 02 23 44 31 B8 60 3B 61 ?? ?? ?? ?? 78 6C 1D 4B 0C 38 98 42 07 D1 01 23 5B 42 B8 68 1A 49 1B 4A 3B 61 ?? ?? ?? ?? 83 68 5A 1E 82 60 00 2B F2 DC 39 1C 40 31 ?? ?? ?? ?? ED E7 4C 3F 7B 69 3A 69 3B 60 7A 60 BB 69 01 2A 09 D0 02 2A 01 D0 01 33 0F D0 01 23 5B 42 38 68 3B 61 ?? ?? ?? ?? B8 68 ?? ?? ?? ?? 7B 68 38 1C 44 30 3B 61 ?? ?? ?? ?? EF E7 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_9_26_2 {
	meta:
		name = "_ZSt24__throw_invalid_argumentPKc"
		size = 212
		refs = "0026 _Unwind_SjLj_Register 0038 _ZNSsC1EPKcRKSaIcE 003e __cxa_allocate_exception 004c _ZNSt16invalid_argumentC1ERKSs 0066 __cxa_throw 0078 _ZNSs4_Rep10_M_destroyERKSaIcE 009e _Unwind_SjLj_Resume 00a4 __cxa_free_exception 00b0 _ZNSsD1Ev 00b6 _ZSt9terminatev 00bc __gxx_personality_sj0 00c8 _ZNSs4_Rep20_S_empty_rep_storageE 00cc _ZTISt16invalid_argument 00d0 _ZNSt16invalid_argumentD1Ev"
	strings:
		$1 = { 80 B5 93 B0 2D 4B 00 AF 7B 62 4C 22 2C 4B D2 19 BB 62 FA 62 3B 1C 2B 4A 2C 33 5A 60 78 60 6A 46 38 1C 9A 60 0C 30 ?? ?? ?? ?? 38 1C 3A 1C 03 23 44 30 79 68 48 32 3B 61 ?? ?? ?? ?? 08 20 ?? ?? ?? ?? 39 1C 02 23 44 31 B8 60 3B 61 ?? ?? ?? ?? 78 6C 1D 4B 0C 38 98 42 07 D1 01 23 5B 42 B8 68 1A 49 1B 4A 3B 61 ?? ?? ?? ?? 83 68 5A 1E 82 60 00 2B F2 DC 39 1C 40 31 ?? ?? ?? ?? ED E7 4C 3F 7B 69 3A 69 3B 60 7A 60 BB 69 01 2A 09 D0 02 2A 01 D0 01 33 0F D0 01 23 5B 42 38 68 3B 61 ?? ?? ?? ?? B8 68 ?? ?? ?? ?? 7B 68 38 1C 44 30 3B 61 ?? ?? ?? ?? EF E7 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_10_0_2 {
	meta:
		name = "_ZSt21__copy_streambufs_eofIcSt11char_traitsIcEElPSt15basic_streambufIT_T0_ES6_Rb"
		size = 210
	strings:
		$1 = { F0 B5 47 46 80 B4 0E 1C C5 68 81 68 01 23 04 1C 90 46 13 70 A9 42 50 D2 08 78 00 27 14 E0 33 68 30 1C 1B 6B 2A 1C 00 F0 53 F8 A3 68 1B 18 A3 60 3F 18 85 42 2C DC 23 68 20 1C 5B 6A 00 F0 48 F8 42 1C 1A D0 A1 68 E5 68 6D 1A 01 2D E7 DC 73 69 B2 69 01 06 09 0E 93 42 13 D2 19 70 73 69 01 33 73 61 A3 68 E5 68 AB 42 1D D2 01 33 A3 60 AB 42 12 D2 18 78 01 37 42 1C E4 D1 38 1C 04 BC 90 46 F0 BD 33 68 30 1C 5B 6B 00 F0 22 F8 01 30 E8 D1 00 23 42 46 13 70 F0 E7 23 68 20 1C 5B 6A 00 F0 17 F8 01 37 E7 E7 23 68 20 1C 9B 6A 00 F0 10 F8 43 1C DF D0 A3 68 E5 68 D9 E7 03 68 5B 6A 00 F0 07 F8 42 1C 01 D1 00 27 D7 E7 A1 68 E5 68 A4 E7 18 47 }
	condition:
		$1
}

rule file_11_0_2 {
	meta:
		name = "_ZNSt10__num_base15_S_format_floatERKSt8ios_basePcc"
		size = 112
	strings:
		$1 = { 10 B5 C0 68 25 23 12 06 0B 70 12 0E 4B 1C 04 05 02 D5 2B 24 4C 70 01 33 41 05 02 D5 23 21 19 70 01 33 2E 21 19 70 5C 1C 2A 21 59 70 61 1C 00 2A 01 D0 62 70 01 31 82 23 5B 00 03 40 04 2B 13 D0 80 22 52 00 93 42 09 D0 44 04 05 D4 67 23 0B 70 01 31 00 23 0B 70 10 BD 47 23 F8 E7 43 04 01 D4 65 23 F4 E7 45 23 F2 E7 66 23 0B 70 01 31 F0 E7 }
	condition:
		$1
}

rule file_11_1_2 {
	meta:
		name = "_ZSt17__verify_groupingPKcmRKSs"
		size = 104
	strings:
		$1 = { 70 B5 15 68 2A 1C 0C 3A 12 68 01 39 01 3A 03 1C 91 42 00 D9 11 1C 00 29 0E D1 01 20 00 2A 01 D0 00 28 16 D1 5B 5C 1A 06 00 2A 04 DD 29 78 00 22 8B 42 52 41 10 40 70 BD 00 24 AE 5C 18 5D 01 34 30 1A 46 42 70 41 01 3A 8C 42 E7 D2 00 28 E5 D0 F3 E7 5B 5C A8 5C 01 3A C0 1A 41 42 48 41 00 2A E1 D0 00 28 DF D0 F5 E7 }
	condition:
		$1
}

rule file_12_0_2 {
	meta:
		name = "_Znwm"
		size = 178
		refs = "0026 _Unwind_SjLj_Register 0048 malloc 0056 _Unwind_SjLj_Unregister 0064 __cxa_allocate_exception 0074 __cxa_throw 0088 _Unwind_SjLj_Resume 008e __cxa_call_unexpected 0094 __gxx_personality_sj0 00a0 __new_handler 00a4 _ZTVSt9bad_alloc 00a8 _ZTISt9bad_alloc 00ac _ZNSt9bad_allocD1Ev"
	strings:
		$1 = { 80 B5 8F B0 23 4B 00 AF 3B 62 3C 22 22 4B D2 19 7B 62 BA 62 3B 1C 21 4A 28 33 5A 60 38 60 6A 46 38 1C 9A 60 08 30 ?? ?? ?? ?? 3B 68 00 2B 0A D1 01 22 3A 60 07 E0 1A 4A 13 68 00 2B 11 D0 01 22 FA 60 00 F0 35 F8 38 68 ?? ?? ?? ?? 78 60 00 28 F1 D0 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 78 68 80 BD 04 20 ?? ?? ?? ?? 0E 4B 0F 49 03 60 0F 4A 01 23 FB 60 ?? ?? ?? ?? 3C 3F 7B 69 38 69 5A 1C 04 D0 01 23 5B 42 FB 60 ?? ?? ?? ?? FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_16_2_2 {
	meta:
		name = "__cxa_end_catch"
		size = 108
		refs = "0002 __cxa_get_globals_fast 0024 _Unwind_DeleteException 005e _ZSt9terminatev"
	strings:
		$1 = { 30 B5 ?? ?? ?? ?? 03 68 00 2B 0D D0 D9 6A 1A 6B 15 4D 14 4C 09 19 6A 41 00 2A 06 D0 00 22 02 60 18 1C 2C 30 ?? ?? ?? ?? 30 BD 01 29 F6 D8 5A 69 00 2A 06 DB 01 3A 00 2A 0A D0 51 1C 0F D0 5A 61 F2 E7 01 32 00 2A FA D1 19 69 5A 61 01 60 EB E7 1A 69 02 60 18 1C 2C 30 ?? ?? ?? ?? E4 E7 ?? ?? ?? ?? C0 46 00 D5 D4 BC BC AA B1 B8 }
	condition:
		$1
}

rule file_16_3_2 {
	meta:
		name = "__cxa_begin_catch"
		size = 184
		refs = "0024 _Unwind_SjLj_Register 0028 __cxa_get_globals 0052 _Unwind_SjLj_Unregister 0086 _ZSt9terminatev 009a _Unwind_SjLj_Resume 00a0 __cxa_call_unexpected 00a4 __gxx_personality_sj0"
	strings:
		$1 = { F0 B5 8E B0 27 4B 00 AF FB 61 38 22 26 4B D2 19 3B 62 7A 62 3B 1C 25 4A 24 33 5A 60 6A 46 9A 60 38 60 38 1D ?? ?? ?? ?? ?? ?? ?? ?? 3B 68 2C 3B D9 6A 1A 6B 1E 4D 1F 4E 49 19 72 41 04 68 00 2A 01 D1 01 29 0B D9 00 2C 1B D1 03 60 00 23 3B 60 38 1D ?? ?? ?? ?? BD 46 0E B0 38 68 F0 BD 5A 69 00 2A 0B DB 01 32 5A 61 42 68 01 3A 42 60 9C 42 01 D0 1C 61 03 60 9B 6A 3B 60 E9 E7 01 21 8A 1A F1 E7 01 23 BB 60 ?? ?? ?? ?? 38 3F 3B 69 F8 68 5A 1C 04 D0 01 23 5B 42 BB 60 ?? ?? ?? ?? BB 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 D5 D4 BC BC AA B1 B8 }
	condition:
		$1
}

rule file_19_5_2 {
	meta:
		name = "_ZN12_GLOBAL__N_1L6xwriteEiPKcl"
		size = 60
		refs = "0010 write 002e __errno"
	strings:
		$1 = { F0 B5 06 1C 0D 1C 17 1C 14 1C 30 1C 29 1C 22 1C ?? ?? ?? ?? 43 1C 0A D0 24 1A 00 2C 0C D0 2D 18 29 1C 30 1C 22 1C ?? ?? ?? ?? 43 1C F4 D1 ?? ?? ?? ?? 03 68 04 2B E8 D0 38 1B F0 BD }
	condition:
		$1
}

rule file_19_6_2 {
	meta:
		name = "_ZNSt12__basic_fileIcE8sys_openEP7__sFILESt13_Ios_Openmode"
		size = 56
		refs = "0014 __errno 001c fflush"
	strings:
		$1 = { 70 B5 05 68 04 1C 0E 1C 00 2D 01 D0 00 20 70 BD 00 29 FB D0 ?? ?? ?? ?? 05 60 20 68 ?? ?? ?? ?? 00 28 03 D1 20 71 26 60 20 1C F0 E7 ?? ?? ?? ?? 03 68 04 2B EA D1 F0 E7 }
	condition:
		$1
}

rule file_19_7_2 {
	meta:
		name = "_ZNSt12__basic_fileIcE5closeEv"
		size = 66
		refs = "0018 __errno 0022 fclose"
	strings:
		$1 = { 10 B5 03 68 04 1C 00 2B 01 D1 00 20 10 BD 03 79 00 2B 01 D1 03 60 F9 E7 ?? ?? ?? ?? 00 23 03 60 20 68 ?? ?? ?? ?? 00 28 02 D1 20 60 20 1C ED E7 ?? ?? ?? ?? 03 68 04 2B F2 D0 00 23 23 60 00 20 E4 E7 }
	condition:
		$1
}

rule file_19_11_2 {
	meta:
		name = "_ZNSt12__basic_fileIcE9showmanycEv"
		size = 64
		refs = "0008 fileno 000e fstat 0038 lseek"
	strings:
		$1 = { 30 B5 8F B0 05 1C 00 68 ?? ?? ?? ?? 69 46 ?? ?? ?? ?? 00 28 07 D1 F0 23 01 9A 1B 02 1A 40 80 23 1B 02 9A 42 02 D0 00 20 0F B0 30 BD 28 68 04 9C ?? ?? ?? ?? 00 21 01 22 ?? ?? ?? ?? 20 1A F3 E7 }
	condition:
		$1
}

rule file_19_12_2 {
	meta:
		name = "_ZNSt12__basic_fileIcE7seekoffExSt12_Ios_Seekdir"
		size = 66
		refs = "0024 fileno 002c lseek"
	strings:
		$1 = { 30 B5 0C 1C 1D 1C 00 2A 05 DD 01 23 5B 42 DC 17 18 1C 21 1C 30 BD 00 2A 0D D0 53 1C F5 DB 01 32 0C D0 00 68 ?? ?? ?? ?? 21 1C 2A 1C ?? ?? ?? ?? 03 1C C4 17 EC E7 00 29 E7 DB F2 E7 00 29 F0 DB E3 E7 }
	condition:
		$1
}

rule file_19_13_2 {
	meta:
		name = "_ZNSt12__basic_fileIcE8xsputn_2EPKclS2_l"
		size = 52
		refs = "0010 fileno 0018 _ZN12_GLOBAL__N_1L6xwriteEiPKcl"
	strings:
		$1 = { F0 B5 05 1C 0E 1C 14 1C 1F 1C 00 2A 08 D1 28 68 ?? ?? ?? ?? 39 1C 05 9A ?? ?? ?? ?? 00 19 F0 BD 00 68 ?? ?? ?? ?? 31 1C 22 1C ?? ?? ?? ?? 84 42 F5 D1 EC E7 }
	condition:
		$1
}

rule file_19_14_2 {
	meta:
		name = "_ZNSt12__basic_fileIcE6xsputnEPKcl"
		size = 22
		refs = "0008 fileno 0010 _ZN12_GLOBAL__N_1L6xwriteEiPKcl"
	strings:
		$1 = { 30 B5 0D 1C 14 1C 00 68 ?? ?? ?? ?? 29 1C 22 1C ?? ?? ?? ?? 30 BD }
	condition:
		$1
}

rule file_19_15_2 {
	meta:
		name = "_ZNSt12__basic_fileIcE6xsgetnEPcl"
		size = 44
		refs = "000a fileno 0012 read 0020 __errno"
	strings:
		$1 = { F0 B5 06 1C 0D 1C 17 1C 30 68 ?? ?? ?? ?? 29 1C 3A 1C ?? ?? ?? ?? 04 1C 43 1C 01 D0 20 1C F0 BD ?? ?? ?? ?? 03 68 04 2B F8 D1 ED E7 }
	condition:
		$1
}

rule file_19_16_2 {
	meta:
		name = "_ZNSt12__basic_fileIcE4openEPKcSt13_Ios_Openmodei"
		size = 60
		refs = "0026 fopen"
	strings:
		$1 = { 10 B5 3D 23 1A 40 01 3A 04 1C 3B 2A 07 D8 0A 4B 92 00 D3 58 00 2B 02 D0 02 68 00 2A 01 D0 00 20 10 BD 08 1C 19 1C ?? ?? ?? ?? 20 60 00 28 F6 D0 01 23 23 71 20 1C F3 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_19_17_2 {
	meta:
		name = "_ZNSt12__basic_fileIcE8sys_openEiSt13_Ios_Openmode"
		size = 80
		refs = "0026 fdopen 0042 setvbuf"
	strings:
		$1 = { 30 B5 3D 23 1A 40 01 3A 04 1C 0D 1C 3B 2A 07 D8 0E 4B 92 00 D1 58 00 29 02 D0 03 68 00 2B 01 D0 00 20 30 BD 28 1C ?? ?? ?? ?? 20 60 00 28 F7 D0 01 23 23 71 00 2D 01 D0 20 1C F2 E7 00 21 02 22 00 23 ?? ?? ?? ?? 20 1C EB E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_20_0_2 {
	meta:
		name = "fabsl"
		size = 16
	strings:
		$1 = { 10 B5 02 4A 13 1C 03 40 18 1C 10 BD FF FF FF 7F }
	condition:
		$1
}

rule file_20_6_2 {
	meta:
		name = "modfl"
		size = 24
		refs = "0008 modf"
	strings:
		$1 = { 10 B5 82 B0 14 1C 6A 46 ?? ?? ?? ?? 00 9A 01 9B 02 B0 22 60 63 60 10 BD }
	condition:
		$1
}

rule file_20_11_2 {
	meta:
		name = "hypotl"
		size = 164
		refs = "001a __adddf3 0026 __eqdf2 0036 __divdf3 0056 __muldf3 0076 sqrt"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 23 4C 06 1C 20 1C 82 B0 90 46 30 40 22 40 9A 46 0F 1C ?? ?? ?? ?? 1F 4A 1F 4B 04 1C 0D 1C ?? ?? ?? ?? 00 28 2D D0 22 1C 2B 1C 30 1C 39 1C ?? ?? ?? ?? 22 1C 00 90 01 91 2B 1C 40 46 51 46 ?? ?? ?? ?? 06 1C 0F 1C 00 98 01 99 02 1C 0B 1C ?? ?? ?? ?? 32 1C 00 90 01 91 3B 1C 30 1C 39 1C ?? ?? ?? ?? 02 1C 0B 1C 00 98 01 99 ?? ?? ?? ?? ?? ?? ?? ?? 02 1C 0B 1C 20 1C 29 1C ?? ?? ?? ?? 04 1C 0D 1C 02 B0 29 1C 20 1C 0C BC 90 46 9A 46 F0 BD FF FF FF 7F 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_21_11_2 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEE15_M_cache_localeERKSt6locale"
		size = 82
		refs = "0008 _ZSt9has_facetISt5ctypeIcEEbRKSt6locale 0012 _ZSt9use_facetISt5ctypeIcEERKT_RKSt6locale 001a _ZSt9has_facetISt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEEbRKSt6locale 0024 _ZSt9use_facetISt7num_putIcSt19ostreambuf_iteratorIcSt11char_traitsIcEEEERKT_RKSt6locale 002e _ZSt9has_facetISt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEEbRKSt6locale 0038 _ZSt9use_facetISt7num_getIcSt19istreambuf_iteratorIcSt11char_traitsIcEEEERKT_RKSt6locale"
	strings:
		$1 = { 30 B5 05 1C 08 1C 0C 1C ?? ?? ?? ?? 00 28 18 D0 20 1C ?? ?? ?? ?? E8 67 20 1C ?? ?? ?? ?? 00 28 14 D0 20 1C ?? ?? ?? ?? 80 23 E8 50 20 1C ?? ?? ?? ?? 00 28 07 D0 20 1C ?? ?? ?? ?? 84 23 E8 50 30 BD E8 67 E8 E7 84 23 E8 50 F9 E7 80 23 E8 50 EC E7 }
	condition:
		$1
}

rule file_21_12_2 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E"
		size = 44
		refs = "0006 _ZNSt8ios_base7_M_initEv 0010 _ZNSt9basic_iosIcSt11char_traitsIcEE15_M_cache_localeERKSt6locale"
	strings:
		$1 = { 30 B5 04 1C 0D 1C ?? ?? ?? ?? 21 1C 6C 31 20 1C ?? ?? ?? ?? 00 23 74 22 A3 54 75 22 A5 67 A3 54 23 67 23 61 6B 42 6B 41 63 61 30 BD }
	condition:
		$1
}

rule file_21_13_2 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEEC1Ev"
		size = 44
		refs = "0004 _ZNSt8ios_baseC2Ev 0028 _ZTVSt9basic_iosIcSt11char_traitsIcEE"
		altNames = "_ZNSt9basic_iosIcSt11char_traitsIcEEC2Ev"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 07 4B 74 22 23 60 00 23 A3 54 75 22 A3 54 80 22 A3 50 84 22 23 67 A3 67 E3 67 A3 50 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_15_2 {
	meta:
		name = "_ZNKSt9basic_iosIcSt11char_traitsIcEE6narrowEcc"
		size = 62
		refs = "0038 _ZSt16__throw_bad_castv"
	strings:
		$1 = { 30 B5 C0 6F 09 06 14 06 09 0E 24 0E 00 28 13 D0 8E 23 5B 00 45 18 ED 18 6B 78 00 2B 02 D0 1C 1C 20 1C 30 BD 03 68 22 1C 1B 6A 00 F0 07 F8 84 42 F6 D0 68 70 04 1C F3 E7 ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_21_16_2 {
	meta:
		name = "_ZNKSt9basic_iosIcSt11char_traitsIcEE5widenEc"
		size = 50
		refs = "001a _ZNKSt5ctypeIcE13_M_widen_initEv 002c _ZSt16__throw_bad_castv"
	strings:
		$1 = { 30 B5 C4 6F 0D 06 2D 0E 00 2C 0F D0 23 7F 00 2B 02 D0 64 19 60 7F 30 BD 20 1C ?? ?? ?? ?? 23 68 20 1C 9B 69 29 1C 00 F0 03 F8 F4 E7 ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_21_17_2 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEE5imbueERKSt6locale"
		size = 214
		refs = "002a _Unwind_SjLj_Register 0034 _ZNSt6localeC1ERKS_ 0044 _ZNSt8ios_base5imbueERKSt6locale 004c _ZNSt6localeD1Ev 0054 _ZNSt9basic_iosIcSt11char_traitsIcEE15_M_cache_localeERKSt6locale 0086 _ZNSt6localeaSERKS_ 0096 _Unwind_SjLj_Unregister 00c4 _Unwind_SjLj_Resume 00c8 __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 93 B0 30 4B 00 AF BB 62 BA 60 2F 4B 4C 22 D2 19 FB 62 3A 63 3B 1C 2D 4A 30 33 5A 60 78 60 6A 46 38 1C 9A 60 10 30 F9 60 ?? ?? ?? ?? F9 68 78 68 6C 31 ?? ?? ?? ?? 38 1C 02 23 48 30 F9 68 BA 68 7B 61 ?? ?? ?? ?? 38 1C 48 30 ?? ?? ?? ?? F8 68 B9 68 ?? ?? ?? ?? FB 68 9B 6F FB 60 00 2B 17 D0 1C 33 38 1C 19 1C 44 30 3B 60 ?? ?? ?? ?? FA 68 13 68 01 22 9B 68 F8 68 7A 61 B9 68 00 F0 29 F8 38 68 B9 68 ?? ?? ?? ?? 38 1C 44 30 ?? ?? ?? ?? 38 1C 10 30 ?? ?? ?? ?? BD 46 13 B0 78 68 80 BD 4C 3F BB 69 FB 60 7B 69 01 2B 03 D0 38 1C 44 30 ?? ?? ?? ?? 78 68 ?? ?? ?? ?? 01 23 5B 42 F8 68 7B 61 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_21_21_2 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEEC1EPSt15basic_streambufIcS1_E"
		size = 156
		refs = "0028 _Unwind_SjLj_Register 0034 _ZNSt8ios_baseC2Ev 005e _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 0066 _Unwind_SjLj_Unregister 007c _ZNSt8ios_baseD2Ev 0088 _Unwind_SjLj_Resume 008c __gxx_personality_sj0 0098 _ZTVSt9basic_iosIcSt11char_traitsIcEE"
		altNames = "_ZNSt9basic_iosIcSt11char_traitsIcEEC2EPSt15basic_streambufIcS1_E"
	strings:
		$1 = { 80 B5 8F B0 21 4B 00 AF 3B 62 21 4B 21 4A 7B 62 39 60 3B 1C 3C 21 28 33 C9 19 B9 62 78 60 5A 60 38 1C 6A 46 9A 60 08 30 ?? ?? ?? ?? 01 23 5B 42 78 68 FB 60 ?? ?? ?? ?? 79 68 17 4B 74 22 0B 60 00 23 8B 54 75 22 8B 54 80 22 8B 50 84 22 0B 67 8B 67 CB 67 8B 50 78 68 01 23 39 68 FB 60 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 3A 69 00 23 78 68 FB 60 3A 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_23_2 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEE11_M_setstateESt12_Ios_Iostate"
		size = 20
		refs = "0010 __cxa_rethrow"
	strings:
		$1 = { 00 B5 43 69 0B 43 43 61 03 69 19 42 00 D1 00 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_24_2 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEE5clearESt12_Ios_Iostate"
		size = 36
		refs = "001a _ZSt19__throw_ios_failurePKc"
	strings:
		$1 = { 00 B5 83 6F 00 2B 04 D0 03 69 41 61 19 42 03 D1 00 BD 01 23 19 43 F7 E7 01 48 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_21_25_2 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEE5rdbufEPSt15basic_streambufIcS1_E"
		size = 16
		refs = "0008 _ZNSt9basic_iosIcSt11char_traitsIcEE5clearESt12_Ios_Iostate"
	strings:
		$1 = { 10 B5 84 6F 81 67 00 21 ?? ?? ?? ?? 20 1C 10 BD }
	condition:
		$1
}

rule file_21_28_2 {
	meta:
		name = "_ZNKSt9basic_iosIcSt11char_traitsIcEE4fillEv"
		size = 72
		refs = "0030 _ZNKSt5ctypeIcE13_M_widen_initEv 0042 _ZSt16__throw_bad_castv"
	strings:
		$1 = { 30 B5 75 23 C3 5C 04 1C 00 2B 02 D0 74 23 C0 5C 30 BD C5 6F 00 2D 14 D0 2B 7F 00 2B 07 D0 3D 23 E8 5C 74 23 E0 54 01 22 75 23 E2 54 F0 E7 28 1C ?? ?? ?? ?? 2B 68 28 1C 9B 69 20 21 00 F0 03 F8 EF E7 ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_21_29_2 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEE4fillEc"
		size = 80
		refs = "0038 _ZNKSt5ctypeIcE13_M_widen_initEv 004a _ZSt16__throw_bad_castv"
	strings:
		$1 = { 70 B5 75 23 C3 5C 0D 06 04 1C 2D 0E 00 2B 04 D0 74 23 C0 5C 74 23 E5 54 70 BD C6 6F 00 2E 14 D0 33 7F 00 2B 07 D0 3D 23 F0 5C 74 23 E0 54 01 22 75 23 E2 54 EE E7 30 1C ?? ?? ?? ?? 33 68 30 1C 9B 69 20 21 00 F0 03 F8 EF E7 ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_21_30_2 {
	meta:
		name = "_ZNSt9basic_iosIcSt11char_traitsIcEE7copyfmtERKS2_"
		size = 376
		refs = "0030 _ZNSt8ios_base17_M_call_callbacksENS_5eventE 003e _ZdaPv 0048 _ZNSt8ios_base20_M_dispose_callbacksEv 00a2 _ZNSt6localeC1ERKS_ 00aa _ZNSt6localeaSERKS_ 00b0 _ZNSt6localeD1Ev 00b8 _ZNSt9basic_iosIcSt11char_traitsIcEE15_M_cache_localeERKSt6locale 00cc _ZNSt9basic_iosIcSt11char_traitsIcEE5clearESt12_Ios_Iostate 011a _Znam 0142 _ZNKSt5ctypeIcE13_M_widen_initEv 0172 _ZSt16__throw_bad_castv"
	strings:
		$1 = { F0 B5 47 46 80 B4 0D 1C 81 B0 04 1C A8 42 5F D0 48 6E 08 28 00 DD 7F E0 24 21 09 19 88 46 0F 1C AE 69 00 2E 02 D0 F3 68 01 33 F3 60 20 1C 00 21 ?? ?? ?? ?? A0 6E 40 45 05 D0 00 28 01 D0 ?? ?? ?? ?? 00 23 A3 66 20 1C ?? ?? ?? ?? A6 61 6E 6E 00 2E 0B DD A9 6E 3A 1C 00 23 8C 46 D9 00 61 44 08 68 49 68 01 33 03 C2 9E 42 F7 DC EB 68 E3 60 AB 68 A3 60 6B 68 63 60 2B 6F A7 66 23 67 66 66 75 23 EB 5C 00 2B 28 D0 74 23 EE 5C 75 23 E3 5C 00 2B 33 D0 74 23 27 1C 29 1C E6 54 6C 37 6C 31 68 46 ?? ?? ?? ?? 69 46 38 1C ?? ?? ?? ?? 68 46 ?? ?? ?? ?? 20 1C 39 1C ?? ?? ?? ?? 20 1C 02 21 ?? ?? ?? ?? 2B 69 61 69 23 61 20 1C ?? ?? ?? ?? 01 B0 20 1C 04 BC 90 46 F0 BD EE 6F 00 2E 48 D0 33 7F 00 2B 2C D0 3D 23 F6 5C 74 23 EE 54 01 22 75 23 EA 54 75 23 E3 5C 00 2B CB D1 E7 6F 00 2F 37 D0 3B 7F 00 2B 26 D0 3D 23 F8 5C 74 23 E0 54 01 22 75 23 E2 54 BD E7 C0 00 ?? ?? ?? ?? 07 1C 68 6E 00 28 21 D0 3B 1C 00 22 00 21 01 32 19 60 59 60 08 33 90 42 F9 D1 24 21 09 19 88 46 6F E7 30 1C ?? ?? ?? ?? 33 68 30 1C 9B 69 20 21 00 F0 12 F8 06 1C C9 E7 38 1C ?? ?? ?? ?? 3B 68 38 1C 9B 69 20 21 00 F0 07 F8 D0 E7 24 23 1B 19 98 46 56 E7 ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_22_3_2 {
	meta:
		name = "_ZNSt8valarrayImEC2Em"
		size = 26
		refs = "000a _Znwm 0014 memset"
		altNames = "_ZNSt8valarrayImEC1Em"
	strings:
		$1 = { 30 B5 8C 00 05 1C 01 60 20 1C ?? ?? ?? ?? 22 1C 68 60 00 21 ?? ?? ?? ?? 30 BD }
	condition:
		$1
}

rule file_22_4_2 {
	meta:
		name = "_ZSt15__valarray_copyImEvPKT_mPS0_"
		size = 16
		refs = "000a memcpy"
	strings:
		$1 = { 00 B5 03 1C 10 1C 8A 00 19 1C ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_22_5_2 {
	meta:
		name = "_ZNSt8valarrayImEC1ERKS0_"
		size = 32
		refs = "000e _Znwm 001a memcpy"
		altNames = "_ZNSt8valarrayImEC2ERKS0_"
	strings:
		$1 = { 30 B5 0B 68 03 60 04 1C 08 68 80 00 0D 1C ?? ?? ?? ?? 22 68 60 60 92 00 69 68 ?? ?? ?? ?? 30 BD }
	condition:
		$1
}

rule file_22_10_2 {
	meta:
		name = "_ZSt17__gslice_to_indexmRKSt8valarrayImES2_RS0_"
		size = 206
		refs = "001e _Znwm 002a memcpy 00b6 _ZdlPv"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0F 68 90 46 BA 00 85 B0 04 1C 10 1C 1E 1C 04 91 03 92 ?? ?? ?? ?? 04 9B 03 9A 59 68 05 1C ?? ?? ?? ?? 32 68 01 92 00 2A 3E D0 01 3F 76 68 BB 00 EA 18 9B 46 02 96 03 9B 46 46 76 68 04 3B B0 46 03 93 B9 46 92 46 C3 44 00 27 02 9E BB 00 9C 51 52 46 13 68 01 3B 13 60 5E 46 31 68 4A 46 64 18 00 2A 1D D0 00 2B 1B D1 04 9B 5B 68 3A 1C 9C 46 03 9B 67 46 48 46 94 46 FA 58 0E 1C 56 43 EA 50 04 3B E9 18 0A 68 01 3A 0A 60 00 96 46 46 F1 58 00 9E 01 38 8E 1B 00 96 A4 19 00 28 0E D1 67 46 01 9A 01 37 97 42 D0 D3 28 1C ?? ?? ?? ?? 05 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 2A EE D1 DA E7 }
	condition:
		$1
}

rule file_22_11_2 {
	meta:
		name = "_ZNSt6gslice8_IndexerC1EmRKSt8valarrayImES4_"
		size = 308
		refs = "002c _Unwind_SjLj_Register 004e _Znwm 005e memcpy 00ac memset 00be _ZSt17__gslice_to_indexmRKSt8valarrayImES2_RS0_ 00c6 _Unwind_SjLj_Unregister 0108 _ZdlPv 0124 _Unwind_SjLj_Resume 0128 __gxx_personality_sj0"
		altNames = "_ZNSt6gslice8_IndexerC2EmRKSt8valarrayImES4_"
	strings:
		$1 = { 80 B5 92 B0 00 AF BB 60 47 4B FA 60 FB 62 48 22 46 4B D2 19 3B 63 7A 63 3B 1C 45 4A 34 33 5A 60 38 61 6A 46 38 1C 9A 60 14 30 79 60 ?? ?? ?? ?? 3A 69 01 23 13 60 7B 68 53 60 FA 68 13 68 3A 69 93 60 FB 68 18 68 01 23 5B 42 80 00 BB 61 ?? ?? ?? ?? 3A 69 FB 68 D0 60 92 68 59 68 92 00 ?? ?? ?? ?? BA 68 13 68 3A 69 13 61 BB 68 18 68 03 23 80 00 BB 61 ?? ?? ?? ?? 3A 69 BB 68 50 61 12 69 59 68 92 00 ?? ?? ?? ?? FA 68 10 68 00 28 1F D1 00 23 3B 60 00 22 3B 69 38 68 9A 61 02 23 BB 61 ?? ?? ?? ?? 3A 69 00 21 D0 61 3A 68 ?? ?? ?? ?? 3B 69 01 22 BA 61 18 33 78 68 F9 68 BA 68 ?? ?? ?? ?? 38 1C 14 30 ?? ?? ?? ?? BD 46 12 B0 80 BD FA 68 53 68 80 00 18 18 83 42 07 D0 01 22 02 CB 4A 43 98 42 FB D1 93 00 3B 60 D4 E7 04 23 3B 60 01 22 D0 E7 48 3F FA 69 BB 69 FA 60 01 2B 05 D0 02 2B 07 D0 3B 69 D8 69 ?? ?? ?? ?? 3A 69 50 69 ?? ?? ?? ?? 3B 69 D8 68 ?? ?? ?? ?? 01 23 5B 42 F8 68 BB 61 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_0_2 {
	meta:
		name = "d_make_comp"
		size = 80
	strings:
		$1 = { 70 B5 04 1C 3A 29 01 D9 00 20 70 BD 0F 4D 88 00 28 58 87 46 00 2B F7 D0 65 69 A0 69 85 42 F3 DA 68 00 40 19 26 69 80 00 01 35 30 18 65 61 00 28 EB D0 01 60 42 60 83 60 E7 E7 00 2B E4 D0 00 2A E2 D0 65 69 A0 69 85 42 DE DA E9 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_1_2 {
	meta:
		name = "d_make_name"
		size = 54
	strings:
		$1 = { 30 B5 03 1C 44 69 80 69 84 42 0A DA 60 00 00 19 1D 69 80 00 01 34 28 18 5C 61 43 42 43 41 00 2B 01 D0 00 20 30 BD 00 29 FB D0 00 2A F9 D0 03 60 41 60 82 60 F6 E7 }
	condition:
		$1
}

rule file_23_2_2 {
	meta:
		name = "d_number"
		size = 84
	strings:
		$1 = { 30 B5 C3 68 1A 78 04 1C 6E 2A 1C D0 00 25 13 1C 30 3B 1B 06 1B 0E 09 2B 1A D8 E3 68 00 20 01 33 81 00 09 18 49 00 E3 60 8A 18 10 1C 1A 78 11 1C 30 39 09 06 09 0E 30 38 01 33 09 29 F0 D9 00 2D 00 D0 40 42 30 BD 5A 1C C2 60 01 25 5A 78 DE E7 00 20 F4 E7 }
	condition:
		$1
}

rule file_23_3_2 {
	meta:
		name = "d_call_offset"
		size = 72
	strings:
		$1 = { 10 B5 04 1C 00 29 07 D1 C3 68 19 78 00 29 01 D1 00 20 10 BD 01 33 C3 60 68 29 0A D0 76 29 F7 D1 20 1C FF F7 C3 FF E3 68 1A 78 5F 2A F0 D1 01 33 E3 60 20 1C FF F7 BA FF E3 68 1A 78 5F 2A E7 D1 01 33 E3 60 01 20 E4 E7 }
	condition:
		$1
}

rule file_23_4_2 {
	meta:
		name = "d_cv_qualifiers"
		size = 146
	strings:
		$1 = { F0 B5 16 1C C2 68 04 1C 0D 1C 13 78 14 E0 01 32 E2 60 00 28 35 D0 00 2E 31 D1 17 21 23 6B 09 33 23 63 20 1C 00 22 00 23 FF F7 58 FF 28 60 00 28 20 D0 E2 68 13 78 05 1D 19 1C 72 39 48 42 48 41 19 1C 56 39 4F 42 79 41 00 29 E0 D1 00 28 DE D1 4B 2B 10 D1 01 32 E2 60 00 2E 0E D1 19 21 23 6B 06 33 23 63 20 1C 00 22 00 23 FF F7 37 FF 28 60 00 28 DE D1 00 25 28 1C F0 BD 1C 21 EF E7 1A 21 CC E7 00 29 E8 D0 00 2E 01 D1 18 21 C6 E7 1B 21 C4 E7 }
	condition:
		$1
}

rule file_23_5_2 {
	meta:
		name = "d_template_param"
		size = 92
	strings:
		$1 = { 10 B5 C3 68 1A 78 04 1C 54 2A 01 D0 00 20 10 BD 5A 1C C2 60 5B 78 5F 2B 09 D0 FF F7 59 FF 00 28 F4 DB E2 68 13 78 5F 2B F0 D1 41 1C 00 E0 00 21 A3 6A 01 32 01 33 E2 60 A3 62 A2 69 63 69 93 42 E4 DA 58 00 C0 18 22 69 80 00 01 33 10 18 63 61 00 28 DC D0 05 23 03 60 41 60 D8 E7 }
	condition:
		$1
}

rule file_23_6_2 {
	meta:
		name = "d_substitution"
		size = 348
	strings:
		$1 = { F0 B5 C2 68 03 1C 10 78 53 28 01 D0 00 20 F0 BD 50 1C D8 60 52 78 00 2A 1D D1 9D 68 01 20 ED 08 05 40 00 29 08 D0 00 2D 06 D1 D9 68 09 78 43 39 09 06 09 0E 88 42 6D 41 47 49 0C 1C C4 34 A1 42 E4 D2 74 2A 03 D1 4B E0 08 78 90 42 48 D0 1C 31 A1 42 F9 D1 DA E7 01 30 D8 60 10 1C 30 38 04 06 24 0E 09 2C 2D D9 5F 2A 2D D0 14 1C 41 3C 24 06 24 0E 19 2C D1 D8 00 21 12 E0 C8 00 40 18 80 00 82 18 10 1C 30 38 81 42 C0 D8 D9 68 0A 78 00 2A 03 D0 01 31 D9 60 5F 2A 17 D0 01 1C 10 1C 30 38 00 06 00 0E 09 28 E8 D9 10 1C 41 38 00 06 00 0E 19 28 AB D8 C8 00 40 18 80 00 82 18 10 1C 37 38 E1 E7 5F 2A D7 D1 00 20 00 E0 01 30 1A 6A 90 42 9C D2 9A 6A 01 32 9A 62 DB 69 80 00 C0 58 96 E7 4E 69 00 2E 34 D0 8A 69 98 69 94 46 5A 69 82 42 1D DB 00 24 DC 62 00 2D 16 D0 CC 68 09 69 1D 6B 6D 18 1D 63 82 42 00 DB 80 E7 50 00 80 18 1D 69 80 00 01 32 28 18 5A 61 00 28 00 D1 77 E7 16 23 03 60 44 60 81 60 72 E7 4C 68 89 68 E7 E7 54 00 A4 18 1F 69 A4 00 01 32 3C 19 5A 61 00 2C D9 D0 16 22 22 60 62 46 66 60 A2 60 5A 69 98 69 D1 E7 5A 69 98 69 CF E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_7_2 {
	meta:
		name = "d_append_char"
		size = 76
	strings:
		$1 = { F0 B5 82 25 6D 00 43 59 0E 06 04 1C 36 0E FF 2B 09 D0 5A 1C E3 18 1E 71 82 23 5B 00 E2 50 84 23 5B 00 E6 54 F0 BD 08 4B 00 27 E7 54 88 22 86 23 5B 00 52 00 A2 58 E3 58 04 30 FF 21 02 F0 66 FD 67 51 01 22 00 23 E5 E7 03 01 00 00 }
	condition:
		$1
}

rule file_23_8_2 {
	meta:
		name = "d_find_pack"
		size = 128
	strings:
		$1 = { 70 B5 06 1C 0C 1C 00 29 0C D0 1C 4D 23 68 3A 2B 0A D9 61 68 30 1C FF F7 F3 FF 00 28 03 D1 A4 68 00 2C F3 D1 00 20 70 BD 9B 00 EB 58 9F 46 8A 23 5B 00 F3 58 00 2B 1A D0 5B 68 9B 68 62 68 00 2B 06 D1 EF E7 00 2A 07 DD 9B 68 01 3A 00 2B E9 D0 19 68 2A 29 F6 D0 E5 E7 00 2B E3 D0 00 2A E1 D1 58 68 00 28 DF D0 03 68 2A 2B DB D1 DB E7 8E 23 5B 00 01 22 F2 50 00 20 D5 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_9_2 {
	meta:
		name = "d_source_name"
		size = 140
		refs = "0032 memcmp"
	strings:
		$1 = { 70 B5 04 1C FF F7 22 FE 05 1C 00 28 37 DD E6 68 63 68 9B 1B 98 42 20 DC A2 68 33 18 E3 60 51 07 02 D5 1A 78 24 2A 1A D0 09 2D 0F DD 30 1C 15 49 08 22 ?? ?? ?? ?? 00 28 08 D1 33 7A 32 1C 08 32 5F 2B 0F D0 2E 2B 0D D0 24 2B 0B D0 20 1C 31 1C 2A 1C FF F7 DF FD E0 62 70 BD 00 20 FB E7 01 33 E3 60 E1 E7 53 78 4E 2B F0 D1 23 6B 16 33 5D 1B 25 63 20 1C 04 49 15 22 FF F7 CC FD EB E7 00 20 EA E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_10_2 {
	meta:
		name = "d_expression"
		size = 568
		refs = "00f8 strcmp"
	strings:
		$1 = { F0 B5 C2 68 13 78 04 1C 4C 2B 68 D0 54 2B 00 D1 81 E0 73 2B 37 D0 66 2B 11 D0 30 3B 1B 06 1B 0E 09 2B 35 D8 20 1C 00 F0 7B FC 05 1C 00 28 04 D0 E3 68 1B 78 49 2B 00 D1 96 E0 28 1C F0 BD 51 78 70 29 EA D1 93 1C C3 60 92 78 5F 2A 7C D0 FF F7 B7 FD 00 28 41 DB E3 68 1A 78 5F 2A 3D D1 02 30 01 33 E3 60 A2 69 63 69 93 42 36 DA 5A 00 D2 18 25 69 92 00 01 33 AD 18 63 61 00 2D DD D0 06 23 2B 60 68 60 D9 E7 53 78 72 2B 48 D0 70 2B 5F D0 20 1C 00 F0 D1 FB 05 1C 00 28 1E D0 03 68 2B 2B 21 D0 2C 2B 52 D0 2D 2B 0D D0 2B 2B 15 D1 46 68 F2 68 2B 23 02 2A 00 D1 80 E0 03 2A 5F D0 01 2A 0B D1 2D 2B 04 D1 E3 68 1A 78 5F 2A 00 D1 A7 E0 20 1C FF F7 95 FF 03 1C 16 E0 00 25 AD E7 00 F0 B9 FC 05 1C A9 E7 43 68 22 6B 9B 68 D3 18 02 3B 23 63 46 68 4E 49 30 68 ?? ?? ?? ?? 00 28 D7 D1 20 1C 00 F0 99 F8 03 1C 2A 1C 20 1C 2E 21 FF F7 13 FD 05 1C 91 E7 FF F7 EB FD 05 1C 8D E7 02 32 C2 60 00 F0 89 F8 05 1C 20 1C 00 F0 F9 FB E3 68 1B 78 06 1C 49 2B 62 D0 2A 1C 20 1C 01 21 33 1C FF F7 FA FC 05 1C 78 E7 01 20 89 E7 42 68 B1 E7 02 32 C2 60 FF F7 54 FF 3A 21 02 1C 00 23 20 1C FF F7 EA FC 05 1C 68 E7 20 1C 00 F0 D7 FC 2A 1C 03 1C 04 21 20 1C FF F7 DF FC 05 1C 5D E7 20 1C FF F7 3E FF 07 1C 20 1C FF F7 3A FF 06 1C 20 1C FF F7 36 FF 33 21 03 1C 32 1C 20 1C FF F7 CC FC 32 21 03 1C 3A 1C 20 1C FF F7 C6 FC 2A 1C 03 1C 31 21 20 1C FF F7 C0 FC 05 1C 3E E7 20 1C FF F7 1F FF 6B 68 06 1C 1B 49 18 68 ?? ?? ?? ?? 00 28 10 D1 20 1C 00 F0 D0 FF 03 1C 30 21 32 1C 20 1C FF F7 AA FC 2A 1C 03 1C 2F 21 20 1C FF F7 A4 FC 05 1C 22 E7 20 1C FF F7 03 FF 03 1C ED E7 20 1C 00 F0 8C FC 04 21 03 1C 32 1C 20 1C FF F7 94 FC 2A 1C 03 1C 01 21 20 1C FF F7 8E FC 05 1C 0C E7 01 33 E3 60 20 1C 00 F0 A7 FF 03 1C 6C E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_11_2 {
	meta:
		name = "d_unqualified_name"
		size = 306
	strings:
		$1 = { 30 B5 C2 68 13 78 19 1C 30 39 09 06 09 0E 04 1C 09 29 2A D9 19 1C 61 39 09 06 09 0E 19 29 16 D9 19 1C 43 39 09 06 09 0E 01 29 43 D8 C1 6A 00 29 07 D0 08 68 00 28 1B D1 20 6B 8B 68 C3 18 23 63 13 78 43 2B 18 D0 44 2B 43 D0 00 20 30 BD FF F7 63 FF 00 28 FA D0 03 68 2B 2B F7 D1 43 68 22 6B 9B 68 D3 18 07 33 23 63 F0 E7 FF F7 F3 FA ED E7 16 28 E1 D0 43 2B E6 D1 53 78 32 2B 57 D0 33 2B 53 D0 31 2B E1 D1 01 25 02 32 E2 60 63 69 A2 69 93 42 DA DA 58 00 C0 18 22 69 80 00 01 33 10 18 63 61 00 28 D1 D0 00 29 CF D0 07 23 03 60 45 60 81 60 CB E7 4C 2B C8 D1 01 32 C2 60 FF F7 CA FA 05 1C 00 28 C1 D0 E3 68 1A 78 5F 2A 1F D0 28 1C BC E7 53 78 31 2B 26 D0 32 2B 22 D0 30 2B B4 D1 01 25 02 32 E2 60 63 69 A2 69 93 42 AD DA 58 00 C0 18 22 69 80 00 01 33 10 18 63 61 00 28 A4 D0 00 29 A2 D0 08 23 03 60 45 60 81 60 9E E7 01 33 E3 60 20 1C FF F7 C4 F8 00 28 00 DA 95 E7 28 1C 94 E7 03 25 DD E7 02 25 DB E7 03 25 AC E7 02 25 AA E7 }
	condition:
		$1
}

rule file_23_12_2 {
	meta:
		name = "d_operator_name"
		size = 232
	strings:
		$1 = { F0 B5 47 46 80 B4 C3 68 1F 78 04 1C 00 2F 27 D0 5A 1C C2 60 5B 78 9C 46 00 2B 01 D0 01 32 C2 60 76 2F 3F D1 65 46 30 3D 2B 06 1B 0E 09 2B 19 D8 20 1C FF F7 83 FB 63 69 A2 69 01 1C 93 42 29 DA 5A 00 D2 18 20 69 92 00 01 33 80 18 63 61 00 28 21 D0 00 29 1E D0 2C 23 03 60 45 60 81 60 1A E0 00 23 9C 46 1F 4A 44 32 34 20 00 23 90 46 C2 1A D1 0F 8A 18 52 10 D2 18 16 01 46 44 31 68 0D 78 AF 42 0B D1 49 78 8C 45 1B D0 8C 45 08 D2 10 1C 83 42 EC D1 00 20 04 BC 90 46 F0 BD BD 42 F6 D8 53 1C F5 E7 63 46 76 2B DC D1 63 2F DA D1 20 1C FF F7 A6 FC 2D 21 02 1C 00 23 20 1C FF F7 20 F9 E9 E7 63 69 A2 69 93 42 E4 DA 5A 00 D2 18 20 69 92 00 01 33 80 18 63 61 00 28 DC D0 2B 23 03 60 46 60 D8 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_13_2 {
	meta:
		name = "d_expr_primary"
		size = 198
	strings:
		$1 = { 70 B5 C3 68 1A 78 04 1C 4C 2A 01 D0 00 20 70 BD 5A 1C C2 60 5B 78 19 1C 5F 39 48 42 41 41 5A 2B 0C D0 00 29 17 D0 01 32 E2 60 13 78 5A 2B 07 D0 00 20 45 2B EA D1 01 32 E2 60 E8 E7 00 29 F2 D1 01 32 E2 60 20 1C 00 21 00 F0 A6 F9 E2 68 13 78 45 2B DB D1 EF E7 20 1C FF F7 C4 FB 05 1C 00 28 D4 D0 03 68 23 2B 1E D0 E1 68 0B 78 6E 2B 23 D0 34 26 45 2B 25 D0 00 2B C8 D0 0A 1C 01 E0 00 2B C4 D0 01 32 E2 60 13 78 45 2B F8 D1 52 1A 20 1C FF F7 50 F8 2A 1C 03 1C 31 1C 20 1C FF F7 22 F8 E2 68 13 78 C5 E7 43 68 1A 69 00 2A DC D0 22 6B 5B 68 D3 1A 23 63 D7 E7 01 31 E1 60 35 26 0B 78 D7 E7 00 22 E3 E7 }
	condition:
		$1
}

rule file_23_14_2 {
	meta:
		name = "d_type"
		size = 1384
	strings:
		$1 = { F0 B5 C2 68 13 78 82 B0 04 1C 56 2B 11 D0 72 2B 0F D0 4B 2B 0D D0 19 1C 30 39 09 06 09 0E 4A 29 03 D9 00 25 02 B0 28 1C F0 BD D7 48 89 00 41 58 8F 46 20 1C 01 A9 00 22 FF F7 F4 FC 05 1C 00 28 EF D0 20 1C FF F7 DC FF 28 60 00 28 E9 D0 01 9A 00 2A E6 D0 23 6A 61 6A 8B 42 E2 DA E1 69 98 00 42 50 01 33 23 62 01 9D DC E7 20 1C 00 F0 8E FC 01 90 05 1C 00 2D D5 D0 23 6A 62 6A 93 42 D0 DA E2 69 99 00 8D 50 01 33 23 62 01 9D CA E7 01 32 E2 60 20 1C FF F7 B4 FF 21 21 02 1C 00 23 20 1C FF F7 2E FC 05 1C 01 90 E4 E7 51 1C E1 60 53 78 00 2B B6 D0 46 3B 1B 06 01 31 1B 0E E1 60 2E 2B AF D8 B2 4A 9B 00 D3 58 9F 46 01 32 E2 60 20 1C FF F7 96 FF 22 21 02 1C 00 23 20 1C FF F7 10 FC 05 1C 01 90 C6 E7 01 32 E2 60 20 1C FF F7 88 FF 20 21 02 1C 00 23 20 1C FF F7 02 FC 05 1C 01 90 B8 E7 01 32 E2 60 20 1C FF F7 7A FF 1E 21 02 1C 00 23 20 1C FF F7 F4 FB 05 1C 01 90 AA E7 01 32 E2 60 20 1C FF F7 6C FF 1F 21 02 1C 00 23 20 1C FF F7 E6 FB 05 1C 01 90 9C E7 53 78 1A 1C 30 3A 12 06 12 0E 09 2A 07 D9 5F 2B 05 D0 41 3B 1B 06 1B 0E 19 2B 00 D9 C9 E1 20 1C 00 21 FF F7 DA FC E3 68 01 90 1B 78 05 1C 49 2B 00 D0 5A E7 20 1C 00 F0 B8 FB 2A 1C 03 1C 04 21 20 1C FF F7 C0 FB 05 1C 01 90 76 E7 20 1C FF F7 96 FC E3 68 01 90 1B 78 05 1C 49 2B 00 D0 6C E7 00 28 00 D1 41 E7 23 6A 62 6A 93 42 00 DB 3B E7 E2 69 99 00 01 33 88 50 23 62 20 1C 01 9D 00 F0 94 FB 2A 1C 03 1C 04 21 20 1C FF F7 9C FB 05 1C 01 95 52 E7 01 32 E2 60 20 1C FF F7 B2 FD 01 90 20 1C FF F7 10 FF 1D 21 02 1C 01 9B 20 1C FF F7 8A FB 05 1C 01 95 40 E7 99 00 CB 18 66 49 9B 00 CB 18 65 49 5B 18 00 2B 05 D0 61 69 A0 69 81 42 00 DA 5C E1 00 23 5B 68 00 25 21 6B 5B 68 01 32 CB 18 23 63 E2 60 00 E7 01 32 E2 60 20 1C FF F7 88 FD 24 21 02 1C 00 23 20 1C FF F7 64 FB 05 1C 01 90 1A E7 01 32 E2 60 20 1C FF F7 DC FE 69 46 07 1C 01 22 20 1C FF F7 E8 FB 6E 46 05 1C 00 28 43 D1 00 25 01 95 08 E7 51 1C E1 60 53 78 5F 2B 00 D1 64 E1 30 3B 1B 06 1B 0E 09 2B 00 D9 45 E1 0A 1C 01 32 E2 60 13 78 30 3B 1B 06 1B 0E 09 2B F7 D9 52 1A 20 1C FF F7 5E FB 05 1C 00 28 E0 D0 E1 68 0B 78 5F 2B DC D1 01 31 E1 60 20 1C FF F7 AA FE 2A 1C 03 1C 26 21 20 1C FF F7 24 FB 05 1C 01 95 DA E6 53 1C E3 60 52 78 59 2A 00 D1 33 E1 20 1C 01 21 00 F0 4B F9 E3 68 1A 78 05 1C 45 2A BF D1 01 33 E3 60 01 95 C7 E6 20 1C FF F7 8B FE 28 60 00 28 B5 D0 B5 42 03 D0 03 68 25 2B 00 D0 1F E1 20 1C 27 21 3A 1C 00 9B FF F7 FC FA 05 1C 01 95 B2 E6 63 69 A2 69 93 42 00 DB E5 E0 5A 00 D2 18 25 69 92 00 01 33 AD 18 63 61 00 2D 00 D1 16 E1 23 23 2B 60 A7 22 17 4B 92 00 9B 18 6B 60 22 6B 5B 68 D3 18 23 63 6F E6 20 1C FF F7 5B FE 3A 21 02 1C 00 23 20 1C FF F7 D5 FA 05 1C 64 E6 63 69 A2 69 93 42 00 DB BF E0 5A 00 D2 18 25 69 92 00 01 33 AD 18 63 61 00 2D 00 D1 F0 E0 23 23 2B 60 AC 21 04 4B 89 00 5B 18 6B 60 D8 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B0 F8 FF FF 63 69 A2 69 93 42 00 DB A0 E0 5A 00 D2 18 25 69 92 00 01 33 AD 18 63 61 00 2D 00 D1 D1 E0 23 23 2B 60 9D 22 69 4B 92 00 9B 18 6B 60 B9 E7 63 69 A2 69 93 42 00 DB 89 E0 5A 00 D2 18 25 69 92 00 01 33 AD 18 63 61 00 2D 00 D1 BA E0 23 23 2B 60 98 21 5E 4B 89 00 5B 18 6B 60 A2 E7 20 1C FF F7 E7 FC 39 21 02 1C 00 23 20 1C FF F7 7D FA 05 1C 01 90 00 28 00 D1 09 E6 E2 68 13 78 00 2B 00 D1 03 E6 01 32 E2 60 45 2B 00 D0 FE E5 FE E5 63 69 A2 69 93 42 74 DB 00 25 28 23 01 95 2B 60 E3 68 1A 78 30 3A 12 06 12 0E 00 23 09 21 91 42 5B 41 2B 81 00 2B 6C D1 20 1C FF F7 D6 FD 68 60 20 1C FF F7 96 FA E2 68 13 78 00 2B 04 D0 01 32 73 3B E2 60 5A 42 53 41 01 9D 6B 81 D7 E5 63 69 A2 69 93 42 33 DA 5A 00 D2 18 25 69 92 00 01 33 AD 18 63 61 00 2D 65 D0 23 23 2B 60 A2 21 33 4B 89 00 5B 18 6B 60 4D E7 63 69 A2 69 93 42 1E DA 5A 00 D2 18 25 69 92 00 01 33 AD 18 63 61 00 2D 50 D0 23 23 2B 60 93 22 29 4B 92 00 9B 18 6B 60 38 E7 48 00 40 18 25 69 80 00 01 31 2D 18 61 61 00 2D 41 D0 6B 60 23 22 2A 60 E2 68 97 E6 00 23 5B 68 00 25 26 E7 20 1C 00 F0 4D FA 05 1C 00 28 00 D1 94 E5 03 68 01 90 16 2B 00 D0 B9 E5 8E E5 20 1C FF F7 5E FC 05 1C 00 28 00 D0 C2 E6 00 25 A2 E6 5A 00 D2 18 25 69 92 00 01 33 AD 18 63 61 83 E7 20 1C FF F7 2D FA 01 9D 8D E7 01 33 E3 60 C8 E6 00 25 B2 E6 00 9A 00 2A 00 D1 8B E6 23 6A 61 6A 8B 42 00 DB 86 E6 E1 69 98 00 01 33 42 50 23 62 D0 E6 6B 68 ED E6 6B 68 58 E6 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_15_2 {
	meta:
		name = "d_template_args"
		size = 166
	strings:
		$1 = { 70 B5 C3 68 1A 78 81 B0 04 1C C6 6A 49 2A 02 D0 00 20 01 B0 70 BD 5A 1C C2 60 59 78 45 29 07 D1 01 32 C2 60 2A 21 00 22 00 23 FE F7 F7 FF F0 E7 00 21 00 91 6D 46 5B 78 17 E0 58 2B 21 D0 49 2B 1A D0 20 1C FF F7 6A FB 02 1C 00 2A E0 D0 20 1C 2A 21 00 23 FE F7 E2 FF 28 60 00 28 D8 D0 E2 68 13 78 45 2B 1A D0 05 1C 08 35 4C 2B E5 D1 20 1C FF F7 62 FF 02 1C E8 E7 20 1C FF F7 C1 FF 02 1C E3 E7 01 32 E2 60 20 1C FF F7 2C FA E3 68 19 78 02 1C 45 29 BC D1 01 33 E3 60 D6 E7 01 32 E2 60 E6 62 00 98 B5 E7 }
	condition:
		$1
}

rule file_23_16_2 {
	meta:
		name = "d_exprlist"
		size = 92
	strings:
		$1 = { 30 B5 00 23 81 B0 00 93 C3 68 1A 78 04 1C 45 2A 08 D1 01 33 C3 60 29 21 00 22 00 23 FE F7 D0 FC 01 B0 30 BD 6D 46 01 E0 05 1C 08 35 20 1C FE F7 2B FF 02 1C 00 28 0F D0 20 1C 29 21 00 23 FE F7 BF FC 28 60 00 28 07 D0 E3 68 1A 78 45 2A EB D1 01 33 E3 60 00 98 E3 E7 00 20 E1 E7 }
	condition:
		$1
}

rule file_23_17_2 {
	meta:
		name = "d_name"
		size = 552
	strings:
		$1 = { F0 B5 C2 68 13 78 81 B0 04 1C 4E 2B 5D D0 4E 2B 12 D9 53 2B 2A D0 5A 2B 10 D1 01 32 C2 60 00 21 00 F0 02 F9 E3 68 1A 78 05 1C 45 2A 00 D1 8E E0 00 25 01 B0 28 1C F0 BD 4C 2B 13 D0 20 1C FF F7 8D FE E3 68 1B 78 05 1C 49 2B F2 D1 00 2D F0 D0 23 6A 62 6A 93 42 EB DA E2 69 99 00 01 33 8D 50 23 62 11 E0 FF F7 7A FE 05 1C E2 E7 53 78 74 2B 15 D0 00 21 FF F7 88 F8 01 22 05 1C E3 68 1B 78 49 2B D6 D1 00 2A E1 D0 20 1C FF F7 65 FF 2A 1C 03 1C 04 21 20 1C FE F7 6D FF 05 1C C9 E7 02 32 5F 49 C2 60 03 22 FE F7 8D FF 05 1C 20 1C FF F7 55 FE 2A 1C 03 1C 01 21 20 1C FE F7 5B FF 23 6B 03 33 05 1C 23 63 00 22 D8 E7 01 32 C2 60 69 46 01 22 FE F7 E1 FF 07 1C 00 28 A9 D0 E2 68 15 78 00 26 00 2D 2F D0 2B 1C 61 3B 1B 06 1B 0E 19 2B 44 D9 2B 1C 30 3B 1B 06 1B 0E 09 2B 3E D9 44 2D 3C D0 43 2D 3A D0 4C 2D 38 D0 53 2D 4A D0 49 2D 4E D0 54 2D 54 D1 20 1C FF F7 08 F8 03 1C 00 2E 05 D0 01 21 20 1C 32 1C FE F7 24 FF 03 1C 53 2D 34 D0 E2 68 11 78 45 29 2D D0 00 2B 03 D0 21 6A 60 6A 81 42 1F DB 00 23 3B 60 00 25 71 E7 5A 1C E2 60 5B 78 73 2B 41 D1 53 1C E3 60 52 78 5F 2A 55 D0 30 49 0E 22 20 1C FE F7 2C FF 2A 1C 03 1C 02 21 20 1C FE F7 FE FE 05 1C 5A E7 20 1C FF F7 ED FD 03 1C CB E7 E0 69 8D 00 01 31 2B 50 21 62 1E 1C 15 78 A5 E7 45 25 1E 1C A2 E7 E2 68 1E 1C 15 78 9E E7 20 1C 01 21 FE F7 EE FF 03 1C B6 E7 00 2E C8 D0 20 1C FF F7 CF FE 04 21 03 1C B1 E7 45 2D C0 D1 3E 60 00 2E 00 D1 31 E7 13 78 45 2B 00 D0 2D E7 01 32 E2 60 00 9D 2A E7 20 1C FF F7 0F FF E3 68 1A 78 06 1C 5F 2A 07 D0 2A 1C 20 1C 02 21 33 1C FE F7 BE FE 05 1C 1A E7 01 33 E3 60 20 1C FE F7 FB FE 00 28 F0 DA 00 25 11 E7 01 33 E3 60 20 1C FE F7 F2 FE 00 28 A2 DA 00 25 08 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_18_2 {
	meta:
		name = "d_bare_function_type"
		size = 150
	strings:
		$1 = { F0 B5 C3 68 1A 78 81 B0 04 1C 0D 1C 4A 2A 2F D0 00 22 00 92 6F 46 00 26 1B 78 45 2B 01 D0 00 2B 0E D1 00 9B 00 2B 08 D0 9A 68 00 2A 24 D0 20 1C 25 21 32 1C FF F7 B0 F9 00 E0 00 20 01 B0 F0 BD 20 1C FF F7 29 FD 02 1C 00 28 F6 D0 00 2D 03 D0 E3 68 00 25 06 1C DF E7 20 1C 29 21 00 23 FF F7 9B F9 38 60 00 28 E8 D0 07 1C 08 37 E3 68 D3 E7 01 33 C3 60 01 25 CB E7 59 68 08 68 23 28 D6 D1 49 68 08 69 09 28 D2 D1 20 6B 4B 68 C3 1A 23 63 00 92 00 23 CB E7 }
	condition:
		$1
}

rule file_23_19_2 {
	meta:
		name = "d_encoding"
		size = 908
	strings:
		$1 = { F0 B5 C3 68 1A 78 81 B0 04 1C 0E 1C 54 2A 40 D0 47 2A 3E D0 FF F7 E0 FE 05 1C 00 28 01 D0 00 2E 1B D1 E3 68 1B 78 00 2D 14 D0 00 2B 12 D0 45 2B 10 D0 2A 1C 13 68 04 2B 67 D0 04 2B 33 D2 00 21 20 1C FF F7 B7 FC 2A 1C 03 1C 03 21 20 1C FE F7 7D FE 05 1C 01 B0 28 1C F0 BD A3 68 DA 07 E0 D4 2B 68 1A 1C 1A 3A 02 2A 05 D8 6D 68 2B 68 1A 1C 1A 3A 02 2A F9 D9 02 2B EC D1 AB 68 1A 68 1A 3A 02 2A 04 D8 5B 68 1A 68 1A 3A 02 2A FA D9 AB 60 E0 E7 21 6B 14 31 21 63 1A 78 54 2A 25 D0 47 2A 08 D0 00 25 D6 E7 1A 3B 02 2B C8 D8 52 68 00 2A C0 D1 C4 E7 5A 1C E2 60 5B 78 00 2B F1 D0 01 32 E2 60 52 2B 00 D1 D2 E0 52 2B 00 D9 DA E0 41 2B E7 D1 00 21 20 1C FF F7 93 FF 15 21 02 1C 00 23 20 1C FE F7 33 FE 05 1C B4 E7 5A 1C E2 60 5B 78 00 2B D6 D0 43 3B 1B 06 01 32 1B 0E E2 60 33 2B CF D8 A0 4A 9B 00 D3 58 9F 46 53 68 00 2B 03 D0 9D 49 1A 68 2D 2A 01 D9 01 21 91 E7 92 00 8A 58 97 46 9B 68 00 2B F4 D1 01 21 89 E7 20 1C 76 21 FE F7 7A FE 00 28 B4 D0 00 21 20 1C FF F7 60 FF 10 21 02 1C 00 23 20 1C FE F7 00 FE 05 1C 81 E7 20 1C 68 21 FE F7 68 FE 00 28 A2 D0 00 21 20 1C FF F7 4E FF 0F 21 02 1C 00 23 20 1C FE F7 EE FD 05 1C 6F E7 20 1C 00 21 FE F7 56 FE 00 28 90 D0 20 1C 00 21 FE F7 50 FE 00 28 8A D0 00 21 20 1C FF F7 36 FF 11 21 02 1C 00 23 20 1C FE F7 D6 FD 05 1C 57 E7 05 39 21 63 20 1C FF F7 4F F9 09 21 02 1C 00 23 20 1C FE F7 C9 FD 05 1C 4A E7 0A 39 21 63 20 1C FF F7 42 F9 0A 21 02 1C 00 23 20 1C FE F7 BC FD 05 1C 3D E7 20 1C FF F7 37 F9 0D 21 02 1C 00 23 20 1C FE F7 B1 FD 05 1C 32 E7 20 1C FF F7 2C F9 12 21 02 1C 00 23 20 1C FE F7 A6 FD 05 1C 27 E7 20 1C FF F7 21 F9 0C 21 02 1C 00 23 20 1C FE F7 9B FD 05 1C 1C E7 20 1C FF F7 16 F9 0E 21 02 1C 00 23 20 1C FE F7 90 FD 05 1C 11 E7 20 1C FF F7 0B F9 05 1C 20 1C FE F7 CB FD 00 28 00 DA 2E E7 E3 68 1A 78 5F 2A 00 D0 29 E7 01 33 E3 60 20 1C FF F7 FA F8 23 6B 05 33 02 1C 23 63 20 1C 2B 1C 0B 21 FE F7 71 FD 05 1C F2 E6 20 1C FF F7 B2 FD 14 21 02 1C 00 23 20 1C FE F7 66 FD 05 1C E7 E6 56 2B 39 D0 72 2B 00 D0 09 E7 20 1C FE F7 A0 FD 01 28 00 DC 03 E7 E5 68 2B 78 00 2B 00 D1 FE E6 01 35 E5 60 5F 2B 00 D0 F9 E6 00 22 00 92 47 1E 2B 78 00 2B 00 D1 F2 E6 24 2B 28 D0 00 26 04 E0 AB 5D 00 2B 04 D0 24 2B 02 D0 01 36 BE 42 F7 DB 29 1C 20 1C 32 1C FE F7 5F FD E5 68 AD 19 03 1C E5 60 00 28 00 D1 DA E6 BF 1B 00 9A 00 2A 34 D1 00 2F 2A DD 00 93 DB E7 20 1C FF F7 6B FD 13 21 02 1C 00 23 20 1C FE F7 1F FD 05 1C A0 E6 6B 78 53 2B 32 D0 5F 2B 2E D0 24 2B 00 D0 BF E6 24 21 62 69 A3 69 9A 42 21 DA 53 00 9B 18 20 69 9B 00 01 32 C3 18 62 61 00 2B 18 D0 59 60 E5 68 38 22 02 35 1A 60 E5 60 02 3F CF E7 1A 1C 20 1C 36 21 00 23 FE F7 F9 FC 05 1C 7A E6 20 1C 37 21 FE F7 F3 FC 03 1C 00 28 C3 D1 00 25 71 E6 E3 68 02 33 E3 60 00 25 6C E6 2E 21 D2 E7 2F 21 D0 E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_20_2 {
	meta:
		name = "d_growable_string_callback_adapter"
		size = 134
		refs = "002e memcpy 005c realloc 0074 free"
	strings:
		$1 = { F0 B5 47 46 80 B4 53 68 94 68 01 33 5B 18 07 1C 0E 1C 15 1C A3 42 14 D8 EC 68 00 2C 02 D0 04 BC 90 46 F0 BD 6B 68 28 68 32 1C C0 18 39 1C ?? ?? ?? ?? 2A 68 6B 68 92 19 D4 54 6B 68 9E 19 6E 60 ED E7 D2 68 00 2A EA D1 00 2C 02 D1 02 2B 0E D9 02 24 64 00 A3 42 FC D8 28 68 21 1C ?? ?? ?? ?? 80 46 00 28 05 D0 43 46 2B 60 AC 60 D4 E7 02 24 F2 E7 28 68 ?? ?? ?? ?? 43 46 2B 60 6B 60 AB 60 01 23 EB 60 CB E7 }
	condition:
		$1
}

rule file_23_21_2 {
	meta:
		name = "d_append_buffer"
		size = 148
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 82 B0 04 1C 89 46 92 46 00 2A 34 D0 82 27 7F 00 86 22 C3 59 04 30 01 90 50 00 88 22 52 00 83 46 84 20 00 92 42 00 00 25 90 46 09 E0 5A 1C E3 18 1E 71 01 35 43 46 E2 51 E6 54 AA 45 1B D9 13 1C 48 46 46 5D FF 2B F1 D1 00 98 0E 4A 00 23 A3 54 22 58 58 46 23 58 E1 59 01 98 01 F0 77 FB 00 23 00 22 E3 18 E2 51 1E 71 01 22 43 46 01 35 E2 51 E6 54 AA 45 E3 D8 02 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 03 01 00 00 }
	condition:
		$1
}

rule file_23_22_2 {
	meta:
		name = "d_append_string"
		size = 156
		refs = "0014 strlen"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 82 B0 04 1C 08 1C 89 46 ?? ?? ?? ?? 82 46 00 28 34 D0 20 1D 86 22 01 90 50 00 88 22 52 00 82 27 83 46 84 20 7F 00 00 92 42 00 E3 59 00 25 90 46 09 E0 5A 1C E3 18 1E 71 01 35 43 46 E2 51 E6 54 AA 45 1B D9 13 1C 48 46 46 5D FF 2B F1 D1 00 98 0E 4A 00 23 A3 54 22 58 58 46 23 58 E1 59 01 98 01 F0 2A FB 00 23 00 22 E3 18 E2 51 1E 71 01 22 43 46 01 35 E2 51 E6 54 AA 45 E3 D8 02 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD C0 46 03 01 00 00 }
	condition:
		$1
}

rule file_23_23_2 {
	meta:
		name = "d_print_array_type"
		size = 500
		refs = "01ec .LC31"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 83 B0 04 1C 8B 46 90 46 00 2A 0F D0 93 68 00 2B 45 D0 13 1C 02 E0 9A 68 00 2A 41 D0 1B 68 00 2B F9 D1 20 1C 41 46 00 22 00 F0 DE F8 82 23 5B 00 E3 58 FF 2B 00 D1 7E E0 5A 1C E3 18 20 21 19 71 82 23 5B 00 E2 50 84 23 5B 00 E1 54 FF 2A 00 D1 A8 E0 53 1C 5B 21 A2 18 11 71 82 25 84 22 6D 00 52 00 63 51 A1 54 58 46 41 68 00 29 03 D0 20 1C 00 F0 4E FA 63 59 FF 2B 00 D1 80 E0 59 1C E3 18 5D 22 1A 71 82 23 5B 00 E1 50 84 23 5B 00 03 B0 E2 54 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 13 1C 5B 68 1B 68 26 2B 00 D1 8F E0 82 23 5B 00 21 1D 86 20 40 00 E2 58 02 91 9A 46 88 21 84 23 00 90 49 00 58 00 45 4D 01 91 06 1C 0C E0 51 1C A2 18 17 71 43 4A 82 23 50 46 01 35 5B 00 21 50 A7 55 95 42 14 D0 0A 1C 2F 78 FF 2A EF D1 01 98 3D 49 00 22 62 54 22 58 00 98 53 46 E1 58 23 58 02 98 01 F0 8C FA 51 46 00 22 62 50 01 21 DF E7 1E 1C 00 22 20 1C 41 46 00 F0 67 F8 A2 59 FF 2A 1D D0 53 1C A2 18 29 21 11 71 82 22 52 00 A3 50 84 22 52 00 A1 54 7D E7 2B 4B 00 26 E6 54 82 25 86 23 88 22 6D 00 5B 00 52 00 A2 58 E3 58 20 1D 61 59 01 F0 64 FA 66 51 01 22 00 23 6E E7 21 4B 00 25 E5 54 88 22 86 23 5B 00 52 00 A2 58 E3 58 02 98 FF 21 01 F0 53 FA A5 51 01 23 00 22 D1 E7 19 4B 00 26 E6 54 82 25 86 23 88 22 6D 00 5B 00 52 00 61 59 E3 58 20 1D A2 58 01 F0 40 FA 66 51 01 21 00 23 6C E7 0F 4B 00 26 E6 54 82 25 86 23 88 22 6D 00 5B 00 52 00 A2 58 E3 58 20 1D 61 59 01 F0 2D FA 66 51 01 23 00 22 44 E7 00 22 20 1C 41 46 00 F0 0A F8 82 23 5B 00 E2 58 37 E7 ?? ?? ?? ?? ?? ?? ?? ?? 03 01 00 00 }
	condition:
		$1
}

rule file_23_24_2 {
	meta:
		name = "d_print_mod_list"
		size = 256
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 05 1C 0C 1C 91 46 00 29 33 D0 8E 26 76 00 83 59 00 2B 2E D1 01 22 8A 27 93 46 7F 00 1B E0 61 68 5A 46 8A 23 A2 60 5A 00 EB 59 9A 46 E3 68 EB 51 0B 68 90 46 25 2B 22 D0 26 2B 28 D0 02 2B 2E D0 28 1C 01 F0 73 F8 53 46 EB 51 24 68 00 2C 10 D0 AB 59 00 2B 0D D1 A3 68 00 2B F6 D1 4B 46 00 2B DD D1 61 68 0B 68 1A 3B 02 2B D9 D8 24 68 00 2C EE D1 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 22 68 28 1C 00 F0 37 F8 53 46 42 46 AB 50 F1 E7 22 68 28 1C FF F7 B5 FE 53 46 42 46 AB 50 E9 E7 8C 26 76 00 00 23 AF 59 AB 51 28 1C 49 68 00 F0 36 F9 2B 68 AF 51 5A 07 16 D4 28 1C 0D 49 FF F7 52 FE 63 68 99 68 0B 68 1A 3B 02 2B 04 D8 49 68 0B 68 1A 3B 02 2B FA D9 28 1C 00 F0 20 F9 8A 23 5B 00 52 46 EA 50 C5 E7 28 1C 2E 21 FE F7 17 FC E7 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_25_2 {
	meta:
		name = "d_print_comp"
		size = 2928
		refs = "0108 sprintf 04d2 strcmp 0a86 strncmp"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 98 B0 04 1C 0D 1C 00 29 2B D0 8E 23 5B 00 C2 58 00 2A 04 D1 0A 68 3A 2A 08 D9 01 22 E2 50 18 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD D6 49 93 00 CB 58 9F 46 5C 46 8E 23 5B 00 01 22 E2 50 EE E7 69 68 FF F7 D7 FF 23 68 5A 07 01 D5 00 F0 4B FC 20 1C CE 49 FF F7 F2 FC A9 68 20 1C FF F7 CA FF DD E7 8E 23 5B 00 01 22 E2 50 D8 E7 C8 49 FF F7 E5 FC 69 68 20 1C FF F7 BD FF D0 E7 69 68 AA 68 20 1C FF F7 91 FC CA E7 03 68 58 07 F6 D5 6F 68 AE 68 BE 19 B7 42 0B D3 C1 E7 39 78 5F 29 00 D1 E2 E3 7D 1C 20 1C FE F7 A5 FA B5 42 B7 D2 2F 1C F3 1B 03 2B F1 DC 7D 1C 39 78 F3 E7 8A 23 5B 00 C6 58 00 2E 01 D1 00 F0 AC FC 73 68 9B 68 6A 68 00 2B 08 D1 AF E7 00 2A 01 DC 00 F0 21 FC 9B 68 01 3A 00 2B A7 D0 19 68 2A 29 F4 D0 A3 E7 06 AE A8 49 FF F7 A3 FC 6A 68 30 1C A7 49 ?? ?? ?? ?? 20 1C 31 1C FF F7 9A FC 89 E7 A4 49 FF F7 96 FC 69 68 20 1C FF F7 6E FF 20 1C A1 49 FF F7 8E FC A9 68 20 1C FF F7 66 FF 79 E7 9E 49 FF F7 86 FC 69 68 20 1C FF F7 5E FF 71 E7 8C 21 49 00 43 58 05 93 00 23 43 50 6F 68 00 2F 8A D0 06 AE 06 93 46 50 8A 20 40 00 B3 60 3A 68 23 58 F3 60 13 1C 1A 3B 77 60 02 2B 01 D9 00 F0 C1 FC 01 22 90 46 00 22 84 46 0A AB 40 46 92 46 A8 46 7F 68 00 2F 00 D1 6E E7 04 28 00 D1 55 E7 62 58 55 46 9D 60 65 46 1A 60 62 59 DA 60 3A 68 15 1C 1A 3D 63 50 5F 60 01 30 10 33 02 2D E8 D9 45 46 80 46 04 2A 01 D1 00 F0 80 FC 02 2A 4D D1 B9 68 0B 68 1A 3B 02 2B 48 D8 42 46 03 2A 00 D9 34 E7 42 46 10 01 01 3A 12 01 92 19 01 92 8C 22 52 00 03 1C 04 92 8A 22 30 18 10 3B 52 00 AA 46 45 46 F3 18 B1 46 93 46 02 90 00 95 B8 46 26 1C 0B E0 01 9C 02 9D 00 98 10 34 10 35 03 9B 01 94 02 95 03 28 01 D9 00 F0 5A FC 18 1C 10 30 03 90 07 1C 1A 1C 31 CA 31 C7 12 68 3A 60 01 9C 04 9D 02 98 1C 61 70 51 5C 46 00 9D 37 59 00 22 01 35 59 60 9A 60 DF 60 00 95 49 68 0B 68 1A 3B 02 2B D7 D9 47 46 34 1C A8 46 4E 46 55 46 A9 68 20 1C FF F7 CB FE 3B 68 04 2B 01 D1 00 F0 3D FC 40 46 00 28 0B D0 03 01 0C 3B F6 18 45 46 73 68 01 3D 00 2B 00 D1 7D E3 10 3E 00 2D F7 D1 8C 23 05 9A 5B 00 E2 50 C6 E6 8C 23 5B 00 00 22 C7 58 C2 50 03 68 6E 68 58 07 06 D5 33 68 00 2B 03 D1 B3 68 06 2B 00 D1 E1 E3 20 1C 31 1C FF F7 9E FE 84 23 5B 00 E3 5C 3C 2B 00 D1 B9 E3 20 1C 3C 21 FE F7 94 F9 A9 68 20 1C FF F7 90 FE 84 23 5B 00 E3 5C 3E 2B 00 D1 A6 E3 20 1C 3E 21 FE F7 86 F9 8C 23 5B 00 E7 50 96 E6 69 68 FE F7 A5 F9 00 28 00 D1 E8 E3 03 68 2A 2B 00 D0 8C E6 43 68 00 2B 00 D1 88 E6 00 27 06 E0 03 68 2A 2B 07 D1 43 68 00 2B 04 D0 17 1C 80 68 7A 1C 00 28 F4 D1 6D 68 1F 48 90 26 AA 46 90 46 00 25 76 00 81 46 03 E0 01 35 A8 45 00 DC 6E E6 A5 51 20 1C 51 46 FF F7 55 FE BD 42 F4 DA 20 1C 49 46 FF F7 73 FB EF E7 14 49 FF F7 6F FB 69 68 20 1C FF F7 47 FE 5A E6 11 49 FF F7 67 FB 69 68 20 1C FF F7 3F FE 52 E6 0E 49 FF F7 5F FB 69 68 20 1C FF F7 37 FE 4A E6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? DB 49 FF F7 3F FB 69 68 20 1C FF F7 17 FE 2A E6 D8 49 FF F7 37 FB 69 68 20 1C FF F7 0F FE 22 E6 D5 49 FF F7 2F FB 69 68 20 1C FF F7 07 FE 1A E6 D2 49 FF F7 27 FB 69 68 20 1C FF F7 FF FD 12 E6 CF 49 FF F7 1F FB 69 68 20 1C FF F7 F7 FD 0A E6 69 68 00 29 01 D0 FF F7 F1 FD AB 68 00 2B 00 D1 01 E6 20 1C C7 49 82 26 FF F7 0C FB 76 00 A9 68 20 1C A7 59 FF F7 E2 FD A3 59 BB 42 00 D0 F2 E5 02 3B A3 51 EF E5 C0 49 FF F7 FC FA 6B 68 59 68 0A 78 61 3A 12 06 12 0E 19 2A 05 D8 20 21 20 1C FE F7 CC F8 6B 68 59 68 9A 68 20 1C FF F7 A0 FA D9 E5 B6 49 FF F7 E6 FA A9 68 20 1C FF F7 BE FD D1 E5 B2 49 FF F7 DE FA 20 1C 29 1C 00 F0 1E FD C9 E5 69 68 0B 68 2D 2B 00 D1 39 E2 00 F0 96 FD A9 68 20 1C 00 F0 DE FD BD E5 AB 68 1A 68 30 2A 00 D0 C4 E5 6A 68 11 68 2B 29 00 D1 CF E2 59 68 20 1C 00 F0 CF FD 6E 68 73 68 A1 49 18 68 ?? ?? ?? ?? 00 28 00 D0 BD E2 AB 68 20 1C 99 68 00 F0 C1 FD 6B 68 1A 68 2B 2A 00 D0 9C E5 5B 68 9A 68 01 2A 00 D0 97 E5 5B 68 1B 78 3E 2B 00 D0 92 E5 20 1C 29 21 FE F7 7A F8 8D E5 AB 68 1A 68 32 2A 00 D0 94 E5 9A 68 12 68 33 2A 00 D0 8F E5 59 68 00 F0 A0 FD 69 68 20 1C 00 F0 50 FD AB 68 9B 68 20 1C 59 68 00 F0 96 FD 20 1C 86 49 FF F7 82 FA AB 68 9B 68 20 1C 99 68 00 F0 8C FD 6B E5 29 79 FE F7 54 F8 67 E5 80 49 FF F7 74 FA 69 68 20 1C FF F7 4C FD 5F E5 8C 23 5B 00 C2 58 06 AE 06 92 C6 50 00 23 B3 60 8A 23 5B 00 C3 58 75 60 F3 60 A9 68 FF F7 3B FD B3 68 00 2B 0B D1 20 1C 20 21 FE F7 34 F8 69 68 20 1C FF F7 30 FD 20 1C 6F 49 FF F7 50 FA 8C 23 06 9A 5B 00 E2 50 3B E5 0A 22 AB 5E 00 2B 00 D0 A7 E1 69 68 69 4B 4A 68 E4 33 9A 42 06 D0 20 1C FF F7 19 FD 20 1C 20 21 FE F7 15 F8 08 26 AB 5F 00 2B 00 D1 82 E1 20 1C 61 49 FF F7 30 FA 1F E5 8C 23 5B 00 C7 58 00 2F 13 D0 3B 1C 99 68 00 29 08 D1 59 68 09 68 08 1C 17 38 02 28 09 D8 8A 42 00 D1 37 E5 1B 68 00 2B F0 D1 02 E0 8C 23 5B 00 C7 58 8C 23 06 AE 5B 00 06 97 E6 50 00 23 B3 60 8A 23 5B 00 E3 58 75 60 F3 60 20 1C 69 68 FF F7 E2 FC B3 68 00 2B B2 D1 20 1C 29 1C 00 F0 E3 FB AD E7 03 68 5A 07 00 D5 41 E1 6B 68 19 68 5A 68 FF F7 AB F9 E4 E4 7E 21 FD F7 CD FF FD E4 40 49 FF F7 ED F9 69 68 20 1C FF F7 C5 FC D8 E4 3D 49 FF F7 E5 F9 69 68 20 1C FF F7 BD FC D0 E4 69 68 FF F7 B9 FC E9 E4 03 68 9E 06 00 D5 32 E1 6B 68 00 2B 1E D0 8C 27 7F 00 E3 59 06 AE 06 93 00 23 B3 60 8A 23 5B 00 E3 58 E6 51 F3 60 75 60 20 1C 69 68 FF F7 A0 FC 06 9B E3 51 B3 68 00 2B 00 D0 AE E4 23 68 98 06 00 D5 AA E4 20 1C 20 21 FD F7 92 FF 23 68 9A 06 00 D5 A2 E4 8C 23 5B 00 E2 58 20 1C 29 1C FF F7 73 FB 9A E4 8C 20 40 00 23 58 06 AE 98 46 06 93 00 23 B3 60 8A 23 5B 00 E3 58 42 46 26 50 75 60 F3 60 00 2A 00 D1 D2 E1 53 68 1B 68 17 3B 02 2B 00 D9 CC E1 01 27 43 46 BC 46 A3 46 04 95 B1 46 25 E0 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 5A 68 12 68 17 3A 02 2A 1B D8 9A 68 00 2A 15 D1 03 2F 00 D9 5A E4 39 01 4C 46 62 18 1D 1C 51 CD 51 C2 2D 68 8C 20 15 60 5E 46 40 00 32 58 4C 46 62 50 65 46 49 44 31 50 9D 60 01 37 1B 68 00 2B DE D1 04 9D 5C 46 4E 46 20 1C A9 68 FF F7 1E FC 8C 23 5B 00 40 46 E0 50 B3 68 00 2B 00 D0 2A E4 01 2F 0E D0 3B 01 0C 3B F6 18 31 68 20 1C 01 3F 00 F0 14 FB 10 3E 01 2F F7 D8 8C 23 5B 00 E3 58 98 46 20 1C 29 1C 42 46 FF F7 72 F9 FF F7 13 FC CE 49 FF F7 1F F9 69 68 20 1C FF F7 F7 FB 77 E6 6B 68 19 68 23 29 5B D1 5B 68 1E 69 00 2E 05 D0 06 2E 00 D8 D0 E0 07 2E 00 D1 B4 E0 20 1C 28 21 FD F7 E4 FE 69 68 20 1C FF F7 E0 FB 20 1C 29 21 FD F7 DC FE 2B 68 35 2B 00 D1 FE E0 08 2E 01 D0 FF F7 06 FC 20 1C 5B 21 FD F7 D0 FE A9 68 20 1C FF F7 CC FB 20 1C 5D 21 FD F7 C8 FE FF F7 DB FB 7B 78 7D 1C 5F 2B 00 D0 18 E4 BB 78 55 2B 00 D0 14 E4 03 37 BE 42 00 D8 10 E4 00 22 90 46 09 E0 1A 1C 37 3A 01 37 BE 42 00 D8 07 E4 43 46 18 01 12 18 90 46 3B 78 1A 1C 30 3A 10 06 00 0E 09 28 F0 D9 11 3A 12 06 12 0E 05 2A E9 D9 1A 1C 61 3A 12 06 12 0E 05 2A 00 D9 19 E1 1A 1C 57 3A E1 E7 00 26 AB E7 6B 68 99 68 DA 68 FF F7 69 F8 FF F7 A2 FB 20 1C 96 49 FF F7 AD F8 FF F7 9C FB 20 1C 2E 21 FD F7 83 FE FF F7 B3 FB 8C 23 5B 00 C2 58 29 1C FF F7 67 FA C5 E6 8E 49 FF F7 9B F8 53 E6 28 21 FD F7 73 FE 69 68 20 1C 00 F0 D7 FA 20 1C 29 21 FD F7 6B FE BB E5 00 2B 01 D1 FF F7 87 FB 00 2A 01 D0 FF F7 83 FB 59 68 00 29 01 D1 FF F7 7E FB 0B 68 2A 2B 09 D0 33 68 8A 25 6D 00 63 51 20 1C FF F7 53 FB 66 51 FF F7 65 FB 90 23 5B 00 E3 58 00 2B 08 DC 9A E0 0A 68 2A 2A 01 D0 FF F7 66 FB 00 2B 00 DC 92 E0 89 68 01 3B 00 29 F3 D1 FF F7 5D FB 20 1C 20 21 FD F7 38 FE 31 68 20 1C 00 F0 3C FA 78 E4 AB 68 19 68 00 29 00 D0 45 E7 99 68 01 29 00 D0 41 E7 34 2A 00 D0 3E E7 5B 68 1B 78 30 2B 00 D1 BC E0 31 2B 00 D0 36 E7 62 49 FF F7 40 F8 FF F7 2F FB A9 68 0B 68 00 2B 00 D0 2C E7 35 2A 00 D1 A7 E0 20 1C FF F7 0F FB 06 2E 01 D9 FF F7 20 FB 59 4B B6 00 9B 59 9F 46 20 1C 57 49 FF F7 27 F8 FF F7 16 FB 20 1C 55 49 FF F7 21 F8 FF F7 10 FB 20 1C 53 49 FF F7 1B F8 FF F7 0A FB 20 1C 6C 21 FD F7 F1 FD FF F7 04 FB 20 1C 75 21 FD F7 EB FD FF F7 FE FA 8E 23 5B 00 01 22 C2 50 FF F7 04 FB 20 1C 20 21 FD F7 DF FD 53 E4 20 1C 20 21 FD F7 DA FD 40 E4 20 1C 2D 21 FD F7 D5 FD FB E6 20 1C 31 1C 00 F0 B8 FA 3C E5 52 68 91 68 01 29 00 D0 2A E5 52 68 12 78 3E 2A 00 D0 25 E5 28 21 FD F7 C2 FD AB 68 20 E5 70 68 37 49 06 22 ?? ?? ?? ?? 00 28 00 D0 15 E4 A9 68 20 1C FF F7 B4 FA 20 1C 32 49 FE F7 D4 FF 28 E4 00 29 01 D1 FF F7 CC FA 00 2B 01 D0 FF F7 C8 FA 49 68 00 29 00 D0 48 E7 FF F7 C2 FA 01 27 7C E6 8A 23 5B 00 E2 58 16 92 16 AA E2 50 17 97 FF F7 C7 FB 34 1C FF F7 B4 FA 69 68 20 1C 00 F0 C3 FA 20 1C 20 49 FE F7 AF FF FF F7 9E FA 8A 23 16 9A 5B 00 E2 50 FF F7 BD FB 01 20 80 46 FF F7 5C FB B7 42 01 D3 FF F7 D3 FA 40 46 FF 28 01 D9 FF F7 CE FA 5F 2B 01 D0 FF F7 CA FA 01 06 09 0E 20 1C FD F7 6D FD 7D 1C FF F7 C5 FA 2D 21 FD F7 67 FD A9 68 52 E7 0D 49 FE F7 86 FF FF F7 75 FA ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_26_2 {
	meta:
		name = "d_print_mod"
		size = 192
	strings:
		$1 = { 30 B5 0B 68 03 3B 05 1C 0C 1C 24 2B 04 D9 28 1C 21 1C FF F7 ED F8 30 BD 21 4A 9B 00 D3 58 9F 46 84 23 5B 00 C3 5C 28 2B 02 D0 20 21 FD F7 E0 FB 61 68 28 1C FF F7 DC F8 28 1C 1A 49 FE F7 FC FD E9 E7 49 68 FF F7 D4 F8 E5 E7 17 49 FE F7 F4 FD E1 E7 16 49 FE F7 F0 FD DD E7 15 49 FE F7 EC FD D9 E7 20 21 FD F7 C4 FB A1 68 28 1C FF F7 C0 F8 D1 E7 03 68 5A 07 CE D4 2A 21 FD F7 B9 FB CA E7 26 21 FD F7 B5 FB C6 E7 0A 49 FE F7 D5 FD C2 E7 09 49 FE F7 D1 FD BE E7 08 49 FE F7 CD FD BA E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_27_2 {
	meta:
		name = "d_print_function_type"
		size = 552
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 04 1C 89 46 15 1C 00 2A 00 D1 DA E0 93 68 00 2B 00 D0 D6 E0 E0 26 7F 49 13 1C 01 20 B6 00 5A 68 12 68 17 3A 10 2A 32 D8 07 1C 97 40 0F 42 00 D1 6E E0 84 23 5B 00 E3 5C 20 2B 00 D1 72 E0 82 26 76 00 A2 59 FF 2A 00 D1 D2 E0 53 1C A2 18 20 21 11 71 82 22 52 00 A3 50 84 22 52 00 A1 54 FF 2B 65 D1 00 23 98 46 6C 4B 47 46 E7 54 82 26 86 23 88 22 76 00 5B 00 52 00 A1 59 A2 58 E3 58 20 1D 01 F0 53 F9 42 46 A2 51 01 21 00 23 50 E0 1B 68 00 2B 02 D0 9A 68 00 2A C1 D0 8C 23 5B 00 00 22 E7 58 20 1C E2 50 29 1C FF F7 25 FF 82 23 5B 00 E2 58 B8 46 FF 2A 5E D0 53 1C 28 21 A2 18 11 71 82 26 84 22 76 00 52 00 A3 51 A1 54 4F 46 B9 68 00 29 03 D0 20 1C 00 F0 A2 F8 A3 59 FF 2B 5D D0 59 1C E3 18 29 22 1A 71 82 23 5B 00 E1 50 84 23 5B 00 E2 54 29 1C 20 1C 01 22 FF F7 FC FE 8C 23 47 46 5B 00 E7 50 1C BC 90 46 99 46 A2 46 F0 BD 37 42 BC D0 84 23 5B 00 E3 5C 28 2B 02 D0 2A 2B 00 D0 89 E7 82 23 5B 00 E3 58 FF 2B 99 D0 59 1C 28 22 E3 18 1A 71 84 23 5B 00 E2 54 82 26 8C 23 5B 00 00 22 76 00 E7 58 A1 51 E2 50 20 1C 29 1C 92 46 FF F7 D0 FE A3 59 B8 46 FF 2B 36 D0 5A 1C E3 18 29 21 19 71 82 23 5B 00 E2 50 84 23 5B 00 E1 54 FF 2A A0 D1 28 4B 00 27 E7 54 82 26 86 23 88 22 76 00 5B 00 52 00 A2 58 E3 58 20 1D A1 59 01 F0 CB F8 A7 51 01 23 00 22 8E E7 1F 4B 00 27 E7 54 82 26 86 23 88 22 76 00 5B 00 52 00 A1 59 E3 58 20 1D A2 58 01 F0 B8 F8 A7 51 01 21 00 23 8F E7 4A 46 53 68 00 2B A4 D1 66 E7 13 4B 52 46 E2 54 86 23 88 22 5B 00 52 00 A2 58 E3 58 20 1D FF 21 01 F0 A2 F8 53 46 A3 51 01 22 00 23 B7 E7 00 23 98 46 09 4B 47 46 E7 54 88 22 86 23 5B 00 52 00 A2 58 E3 58 20 1D FF 21 01 F0 8E F8 42 46 A2 51 01 23 1A E7 47 0C 01 00 03 01 00 00 }
	condition:
		$1
}

rule file_23_28_2 {
	meta:
		name = "d_print_cast"
		size = 256
	strings:
		$1 = { F0 B5 47 46 80 B4 0D 1C 49 68 0B 68 82 B0 04 1C 04 2B 05 D0 FF F7 8C F8 02 B0 04 BC 90 46 F0 BD 8C 23 8A 26 5B 00 76 00 00 22 C7 58 C2 50 83 59 00 93 6B 46 83 51 6B 68 01 93 59 68 FF F7 78 F8 00 9B A3 51 84 23 5B 00 E3 5C 3C 2B 4C D0 82 26 76 00 A3 59 FF 2B 24 D0 59 1C 3C 22 E3 18 1A 71 84 26 82 23 5B 00 76 00 E1 50 A2 55 6B 68 20 1C 99 68 FF F7 5D F8 A3 5D 3E 2B 3A D0 82 25 6D 00 63 59 FF 2B 1F D0 59 1C E3 18 3E 22 1A 71 82 23 5B 00 E1 50 84 23 5B 00 E2 54 8C 23 5B 00 E7 50 BA E7 16 4B 00 22 E2 54 90 46 86 23 88 22 5B 00 52 00 E3 58 FF 21 20 1D A2 58 00 F0 BF F8 43 46 A3 51 01 21 C9 E7 0D 4B 00 26 E6 54 88 22 86 23 5B 00 52 00 E3 58 FF 21 20 1D A2 58 00 F0 AE F8 66 51 01 21 00 23 CF E7 20 1C 20 21 FD F7 20 FB AD E7 20 1C 20 21 FD F7 1B FB BF E7 03 01 00 00 }
	condition:
		$1
}

rule file_23_29_2 {
	meta:
		name = "d_print_expr_op"
		size = 152
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 0B 68 82 B0 04 1C 2B 2B 08 D0 FF F7 0B F8 02 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 4B 68 58 68 9B 68 81 46 9A 46 00 2B F1 D0 22 1D 86 20 01 92 42 00 88 20 40 00 82 27 93 46 84 22 7F 00 00 90 50 00 E3 59 00 25 80 46 09 E0 5A 1C E3 18 1E 71 01 35 43 46 E2 51 E6 54 AA 45 D8 D9 13 1C 4A 46 56 5D FF 2B F1 D1 08 4B 00 20 E0 54 00 9B 58 46 E2 58 E1 59 23 58 01 98 00 F0 5A F8 00 22 E2 51 00 23 01 22 E2 E7 C0 46 03 01 00 00 }
	condition:
		$1
}

rule file_23_30_2 {
	meta:
		name = "d_print_subexpr"
		size = 164
	strings:
		$1 = { F0 B5 0B 68 04 1C 0D 1C 06 2B 01 D0 00 2B 04 D1 20 1C 29 1C FE F7 C0 FF F0 BD 82 26 76 00 83 59 FF 2B 1B D0 59 1C 28 22 E3 18 1A 71 82 26 84 23 5B 00 76 00 A1 51 E2 54 20 1C 29 1C FE F7 AC FF A3 59 FF 2B 1B D0 59 1C E3 18 29 22 1A 71 82 23 5B 00 E1 50 84 23 5B 00 E2 54 DD E7 10 4B 00 27 E7 54 88 22 86 23 5B 00 52 00 E3 58 FF 21 04 30 A2 58 00 F0 17 F8 A7 51 01 21 00 23 D3 E7 08 4B 00 25 E5 54 88 22 86 23 5B 00 52 00 E3 58 FF 21 20 1D A2 58 00 F0 06 F8 A5 51 01 21 00 23 D3 E7 03 01 00 00 }
	condition:
		$1
}

rule file_23_31_2 {
	meta:
		name = "d_demangle_callback"
		size = 440
		refs = "0028 strncmp 0050 strlen"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 05 1C 00 78 D7 B0 00 AF 0E 1C 91 46 9B 46 80 46 5F 28 00 D1 A0 E0 28 1C 61 49 08 22 ?? ?? ?? ?? 00 28 09 D1 2B 7A 5F 2B 00 D1 76 E0 2E 2B 00 D1 73 E0 24 2B 00 D1 70 E0 F3 06 00 D4 8A E0 01 20 82 46 28 1C ?? ?? ?? ?? 94 22 52 00 BC 18 2B 18 42 00 60 62 80 00 A2 61 82 18 63 60 92 00 00 23 04 32 63 61 23 62 A3 62 E3 62 23 63 6B 46 3B 60 9B 1A 9D 46 6A 46 04 30 12 1A 23 61 53 46 25 60 A6 60 E5 60 95 46 E2 61 00 2B 6C D1 40 46 5F 28 00 D1 73 E0 00 21 F2 07 03 D5 E3 68 1B 78 00 2B 66 D1 00 29 64 D0 84 23 3C 1D 00 25 5B 00 E5 54 8A 23 5B 00 E5 50 8C 23 5B 00 E5 50 86 23 58 00 4A 46 88 23 22 50 7E 60 5A 46 82 46 82 26 58 00 8E 23 76 00 22 50 80 46 58 00 81 46 25 50 A5 51 20 1C FF F7 CF F9 A1 59 63 18 1D 71 50 46 43 46 E2 58 23 58 38 1C 08 30 00 F0 4A FA 4A 46 A0 58 A5 51 43 42 58 41 3B 68 9D 46 BD 46 57 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 6B 7A 1A 1C 49 3A 51 42 4A 41 00 2A 25 D0 AB 7A 5F 2B 00 D0 83 E7 00 2A 31 D1 1B 48 1C 21 5A 46 0B 35 00 F0 29 FA 28 1C ?? ?? ?? ?? 5A 46 01 1C 28 1C 00 F0 21 FA 01 20 DA E7 00 20 D8 E7 6B 78 5A 2B 00 D0 5A E7 00 22 92 46 6D E7 20 1C FD F7 54 FE 01 1C 92 E7 00 20 C8 E7 44 2B 00 D0 5E E7 D5 E7 6B 1C E3 60 6A 78 5A 2A 00 D0 85 E7 01 33 01 21 E3 60 20 1C FE F7 1A FC 01 1C 7E E7 1D 21 03 48 CC E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_23_32_2 {
	meta:
		name = "__gcclibcxx_demangle_callback"
		size = 42
	strings:
		$1 = { 10 B5 0C 1C 13 1C 00 29 09 D0 00 28 07 D0 11 21 22 1C FF F7 19 FF 00 28 04 D0 00 20 01 E0 03 20 40 42 10 BD 02 20 40 42 FB E7 }
	condition:
		$1
}

rule file_23_33_2 {
	meta:
		name = "__cxa_demangle"
		size = 188
		refs = "0046 strlen 0052 free 0070 strcpy 00b8 d_growable_string_callback_adapter"
	strings:
		$1 = { F0 B5 47 46 80 B4 84 B0 0F 1C 15 1C 1E 1C 00 28 37 D0 00 2A 33 D0 00 23 00 93 01 93 02 93 03 93 11 21 25 4A 6B 46 FF F7 F9 FE 00 28 2D D0 03 9B 00 9C 1A 1C 53 1E 9A 41 90 46 13 1C 00 2C 28 D0 00 2F 34 D0 20 1C ?? ?? ?? ?? 2B 68 98 42 0D D3 38 1C ?? ?? ?? ?? 42 46 2A 60 00 2E 01 D0 00 23 33 60 04 B0 20 1C 04 BC 90 46 F0 BD 21 1C 38 1C ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 3C 1C ED E7 00 29 C9 D0 00 2E 0E D1 00 24 EB E7 00 98 ?? ?? ?? ?? 00 23 00 2E F7 D0 01 2B 00 D0 02 23 5B 42 33 60 00 24 DE E7 03 23 5B 42 33 60 00 24 D9 E7 00 2D D3 D0 2A 60 D1 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_0_2 {
	meta:
		name = "_ZN10__cxxabiv112_GLOBAL__N_117uncatch_exceptionC1Ev"
		size = 34
		refs = "0008 __cxa_get_globals_fast"
	strings:
		$1 = { 10 B5 00 23 03 60 04 1C ?? ?? ?? ?? 03 68 5A 69 23 60 01 3A 5A 61 1B 69 03 60 43 68 01 33 43 60 10 BD }
	condition:
		$1
}

rule file_26_1_2 {
	meta:
		name = "__cxa_vec_cleanup"
		size = 182
		refs = "002c _Unwind_SjLj_Register 006e _Unwind_SjLj_Unregister 008a __cxa_end_catch 0096 _Unwind_SjLj_Resume 009c __cxa_begin_catch 00a4 _ZSt9terminatev 00a8 __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 91 B0 00 AF 3B 60 27 4B BB 62 27 4B F9 60 FB 62 7A 60 3B 1C 26 4A 44 21 30 33 C9 19 39 63 B8 60 5A 60 38 1C 6A 46 9A 60 10 30 ?? ?? ?? ?? 3B 68 00 2B 19 D0 7A 68 F9 68 0B 1C 53 43 B9 68 52 42 CB 18 BB 60 7A 60 0C E0 BB 68 79 68 02 22 5B 18 BB 60 18 1C 7A 61 3B 68 00 F0 2B F8 F9 68 01 39 F9 60 FA 68 00 2A EF D1 38 1C 10 30 ?? ?? ?? ?? BD 46 11 B0 80 BD 44 3F 79 69 BA 69 B9 60 FA 60 01 29 09 D0 00 23 7B 61 ?? ?? ?? ?? 01 23 5B 42 F8 68 7B 61 ?? ?? ?? ?? F8 68 ?? ?? ?? ?? BB 68 7B 61 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_26_2_2 {
	meta:
		name = "__cxa_vec_dtor"
		size = 222
		refs = "002c _Unwind_SjLj_Register 006a _Unwind_SjLj_Unregister 0088 __cxa_begin_catch 0090 __cxa_end_catch 009c _Unwind_SjLj_Resume 00aa _ZN10__cxxabiv112_GLOBAL__N_117uncatch_exceptionC1Ev 00ba __cxa_vec_cleanup 00ca __cxa_rethrow 00d0 __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 94 B0 00 AF FB 60 31 4B 3B 63 31 4B 79 61 7B 63 7A 60 3B 1C 30 4A 50 21 38 33 C9 19 B9 63 38 60 5A 60 38 1C 6A 46 9A 60 18 30 ?? ?? ?? ?? FB 68 00 2B 17 D0 79 69 7A 68 0B 1C 53 43 39 68 52 42 CB 18 3B 61 BA 60 09 E0 3B 69 B9 68 03 22 5B 18 3B 61 18 1C FA 61 FB 68 00 F0 3F F8 79 69 01 39 79 61 F1 D2 38 1C 18 30 ?? ?? ?? ?? BD 46 14 B0 80 BD 50 3F 3A 6A FB 69 3A 61 01 2B 05 D0 02 2B 0D D0 F8 6C 2C 30 ?? ?? ?? ?? 00 23 FB 61 ?? ?? ?? ?? 01 23 5B 42 38 69 FB 61 ?? ?? ?? ?? 38 69 ?? ?? ?? ?? 38 1C 4C 30 ?? ?? ?? ?? 01 23 FB 61 38 68 79 69 7A 68 FB 68 ?? ?? ?? ?? F8 6C 2C 30 ?? ?? ?? ?? 02 23 FB 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_26_3_2 {
	meta:
		name = "__cxa_vec_delete3"
		size = 240
		refs = "002c _Unwind_SjLj_Register 0056 _Unwind_SjLj_Unregister 0080 __cxa_vec_dtor 009a __cxa_begin_catch 00a2 __cxa_end_catch 00ae _Unwind_SjLj_Resume 00bc _ZN10__cxxabiv112_GLOBAL__N_117uncatch_exceptionC1Ev 00da __cxa_rethrow 00e0 __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 93 B0 00 AF 3B 60 35 4B 3A 61 FB 62 4C 22 34 4B D2 19 3B 63 7A 63 3B 1C 33 4A 34 33 5A 60 F8 60 6A 46 38 1C 9A 60 14 30 79 60 ?? ?? ?? ?? FB 68 00 2B 0D D0 3A 69 BB 60 00 2A 10 D1 00 23 3B 61 01 23 5B 42 BB 61 B8 68 39 69 7A 6D 00 F0 4D F8 38 1C 14 30 ?? ?? ?? ?? BD 46 13 B0 80 BD 04 3B 19 68 BB 68 9B 1A 7A 68 BB 60 13 1C 4B 43 3A 69 9B 18 3B 61 03 23 BB 61 F8 68 7A 68 3B 68 ?? ?? ?? ?? DD E7 4C 3F FA 69 BB 69 FA 60 01 2B 05 D0 02 2B 0D D0 B8 6C 2C 30 ?? ?? ?? ?? 00 23 BB 61 ?? ?? ?? ?? 01 23 5B 42 F8 68 BB 61 ?? ?? ?? ?? F8 68 ?? ?? ?? ?? 38 1C 48 30 ?? ?? ?? ?? 01 23 BB 61 B8 68 39 69 7B 6D 00 F0 10 F8 B8 6C 2C 30 ?? ?? ?? ?? 02 23 BB 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 10 47 18 47 }
	condition:
		$1
}

rule file_26_4_2 {
	meta:
		name = "__cxa_vec_delete2"
		size = 220
		refs = "002c _Unwind_SjLj_Register 0050 _Unwind_SjLj_Unregister 006e __cxa_vec_dtor 0088 __cxa_begin_catch 0090 __cxa_end_catch 009c _Unwind_SjLj_Resume 00aa _ZN10__cxxabiv112_GLOBAL__N_117uncatch_exceptionC1Ev 00c6 __cxa_rethrow 00cc __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 93 B0 00 AF 3B 60 30 4B BA 60 FB 62 4C 22 2F 4B D2 19 3B 63 7A 63 3B 1C 2E 4A 34 33 5A 60 38 61 6A 46 38 1C 9A 60 14 30 79 60 ?? ?? ?? ?? 3B 69 00 2B 0A D0 BA 68 FB 60 00 2A 0D D1 01 23 5B 42 BB 61 F8 68 7B 6D 00 F0 47 F8 38 1C 14 30 ?? ?? ?? ?? BD 46 13 B0 80 BD 04 3B 19 68 FB 68 9B 1A FB 60 03 23 BB 61 38 69 7A 68 3B 68 ?? ?? ?? ?? E4 E7 4C 3F FA 69 BB 69 3A 61 01 2B 05 D0 02 2B 0D D0 B8 6C 2C 30 ?? ?? ?? ?? 00 23 BB 61 ?? ?? ?? ?? 01 23 5B 42 38 69 BB 61 ?? ?? ?? ?? 38 69 ?? ?? ?? ?? 38 1C 48 30 ?? ?? ?? ?? 01 23 BB 61 F8 68 7A 6D 00 F0 0F F8 B8 6C 2C 30 ?? ?? ?? ?? 02 23 BB 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 10 47 18 47 }
	condition:
		$1
}

rule file_26_5_2 {
	meta:
		name = "__cxa_vec_delete"
		size = 20
		refs = "0008 __cxa_vec_delete2 0010 _ZdaPv"
	strings:
		$1 = { 10 B5 03 4C 81 B0 00 94 ?? ?? ?? ?? 01 B0 10 BD ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_6_2 {
	meta:
		name = "__cxa_vec_cctor"
		size = 238
		refs = "002c _Unwind_SjLj_Register 007a _Unwind_SjLj_Unregister 0098 __cxa_begin_catch 00a0 __cxa_end_catch 00ac _Unwind_SjLj_Resume 00ba _ZN10__cxxabiv112_GLOBAL__N_117uncatch_exceptionC1Ev 00ca __cxa_vec_cleanup 00da __cxa_rethrow 00e0 __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 95 B0 00 AF FB 60 35 4B BA 60 7B 63 54 22 34 4B D2 19 BB 63 FA 63 3B 1C 33 4A 3C 33 5A 60 38 60 6A 46 38 1C 9A 60 1C 30 79 61 ?? ?? ?? ?? FB 6D 00 2B 1F D0 BA 68 00 2A 1C D0 3B 68 01 22 3B 61 00 23 BA 61 7B 60 09 E0 FB 68 7A 69 D2 18 7A 61 3A 69 D2 18 BB 69 01 33 3A 61 BB 61 03 22 3A 62 38 69 79 69 FB 6D 00 F0 40 F8 BA 69 BB 68 7A 60 9A 42 E9 D1 38 1C 1C 30 ?? ?? ?? ?? BD 46 15 B0 80 BD 54 3F 7A 6A 3B 6A BA 61 01 2B 05 D0 02 2B 0D D0 38 6D 2C 30 ?? ?? ?? ?? 00 23 3B 62 ?? ?? ?? ?? 01 23 5B 42 B8 69 3B 62 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 38 1C 50 30 ?? ?? ?? ?? 01 23 3B 62 38 68 79 68 FA 68 3B 6E ?? ?? ?? ?? 38 6D 2C 30 ?? ?? ?? ?? 02 23 3B 62 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_26_7_2 {
	meta:
		name = "__cxa_vec_ctor"
		size = 230
		refs = "002c _Unwind_SjLj_Register 0072 _Unwind_SjLj_Unregister 0090 __cxa_begin_catch 0098 __cxa_end_catch 00a4 _Unwind_SjLj_Resume 00b2 _ZN10__cxxabiv112_GLOBAL__N_117uncatch_exceptionC1Ev 00c2 __cxa_vec_cleanup 00d2 __cxa_rethrow 00d8 __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 95 B0 00 AF 3B 61 33 4B 7A 60 7B 63 54 22 32 4B D2 19 BB 63 FA 63 3B 1C 31 4A 3C 33 5A 60 38 60 6A 46 38 1C 9A 60 1C 30 F9 60 ?? ?? ?? ?? 3B 69 00 2B 1B D0 FA 68 00 2A 18 D0 3B 68 01 22 7B 61 00 23 BA 61 BB 60 06 E0 7A 69 7B 68 D2 18 7A 61 BA 69 01 32 BA 61 03 22 3A 62 78 69 3B 69 00 F0 40 F8 BA 69 FB 68 BA 60 9A 42 ED D1 38 1C 1C 30 ?? ?? ?? ?? BD 46 15 B0 80 BD 54 3F 7A 6A 3B 6A BA 61 01 2B 05 D0 02 2B 0D D0 38 6D 2C 30 ?? ?? ?? ?? 00 23 3B 62 ?? ?? ?? ?? 01 23 5B 42 B8 69 3B 62 ?? ?? ?? ?? B8 69 ?? ?? ?? ?? 38 1C 50 30 ?? ?? ?? ?? 01 23 3B 62 38 68 B9 68 7A 68 FB 6D ?? ?? ?? ?? 38 6D 2C 30 ?? ?? ?? ?? 02 23 3B 62 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_26_8_2 {
	meta:
		name = "__cxa_vec_new3"
		size = 256
		refs = "002c _Unwind_SjLj_Register 0068 __cxa_vec_ctor 0070 _Unwind_SjLj_Unregister 00a6 __cxa_begin_catch 00ae __cxa_end_catch 00ba _Unwind_SjLj_Resume 00c8 _ZN10__cxxabiv112_GLOBAL__N_117uncatch_exceptionC1Ev 00ea __cxa_rethrow 00f0 __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 95 B0 01 AF 3B 60 39 4B 3B 63 39 4B B9 60 7B 63 FA 60 3B 1C 38 4A 50 21 38 33 C9 19 B9 63 38 61 5A 60 38 1C 6A 46 9A 60 18 30 ?? ?? ?? ?? 39 69 BA 68 0B 1C 53 43 F9 68 CB 18 7B 60 01 23 5B 42 FB 61 78 68 FB 6D 00 F0 59 F8 78 61 00 28 1C D0 FB 68 00 2B 11 D1 BB 6D 00 93 03 23 FB 61 78 69 39 69 BA 68 3B 68 ?? ?? ?? ?? 38 1C 18 30 ?? ?? ?? ?? BD 46 14 B0 78 69 80 BD 79 69 C9 18 0B 1C 3A 69 04 3B 79 61 1A 60 E5 E7 00 22 7A 61 EC E7 50 3F 39 6A FB 69 39 61 01 2B 05 D0 02 2B 0D D0 F8 6C 2C 30 ?? ?? ?? ?? 00 23 FB 61 ?? ?? ?? ?? 01 23 5B 42 38 69 FB 61 ?? ?? ?? ?? 38 69 ?? ?? ?? ?? 38 1C 4C 30 ?? ?? ?? ?? 7B 69 F9 68 58 1A 01 23 FB 61 79 68 3A 6E 00 F0 0F F8 F8 6C 2C 30 ?? ?? ?? ?? 02 23 FB 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 10 47 18 47 }
	condition:
		$1
}

rule file_26_9_2 {
	meta:
		name = "__cxa_vec_new2"
		size = 246
		refs = "002c _Unwind_SjLj_Register 0064 __cxa_vec_ctor 006c _Unwind_SjLj_Unregister 00a2 __cxa_begin_catch 00aa __cxa_end_catch 00b6 _Unwind_SjLj_Resume 00c4 _ZN10__cxxabiv112_GLOBAL__N_117uncatch_exceptionC1Ev 00e4 __cxa_rethrow 00e8 __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 94 B0 01 AF 3B 60 37 4B BA 60 FB 62 4C 22 36 4B D2 19 3B 63 7A 63 3B 1C 35 4A 34 33 5A 60 F8 60 6A 46 38 1C 9A 60 14 30 79 60 ?? ?? ?? ?? FB 68 7A 68 18 1C 50 43 BB 68 18 18 01 23 5B 42 BB 61 BB 6D 00 F0 56 F8 38 61 00 28 1C D0 BB 68 00 2B 11 D1 7B 6D 00 93 03 23 BB 61 38 69 F9 68 7A 68 3B 68 ?? ?? ?? ?? 38 1C 14 30 ?? ?? ?? ?? BD 46 13 B0 38 69 80 BD 3A 69 D2 18 13 1C 3A 61 FA 68 04 3B 1A 60 E5 E7 00 22 3A 61 EC E7 4C 3F FA 69 BB 69 FA 60 01 2B 05 D0 02 2B 0D D0 B8 6C 2C 30 ?? ?? ?? ?? 00 23 BB 61 ?? ?? ?? ?? 01 23 5B 42 F8 68 BB 61 ?? ?? ?? ?? F8 68 ?? ?? ?? ?? 38 1C 48 30 ?? ?? ?? ?? 3B 69 BA 68 98 1A 01 23 BB 61 FB 6D 00 F0 0E F8 B8 6C 2C 30 ?? ?? ?? ?? 02 23 BB 61 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_26_10_2 {
	meta:
		name = "__cxa_vec_new"
		size = 32
		refs = "0010 __cxa_vec_new2 0018 _Znam 001c _ZdaPv"
	strings:
		$1 = { 10 B5 83 B0 05 9C 00 94 03 4C 01 94 03 4C 02 94 ?? ?? ?? ?? 03 B0 10 BD ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_1_2 {
	meta:
		name = "_ZNK10__cxxabiv119__pointer_type_info15__pointer_catchEPKNS_17__pbase_type_infoEPPvj"
		size = 64
		refs = "0038 _ZTIv"
	strings:
		$1 = { 30 B5 01 2B 07 D9 C0 68 04 68 C9 68 02 33 24 69 00 F0 15 F8 30 BD C0 68 07 4C 45 68 64 68 A5 42 F2 D1 C8 68 03 68 DB 68 00 F0 08 F8 01 23 58 40 00 06 00 0E EE E7 C0 46 ?? ?? ?? ?? 18 47 20 47 }
	condition:
		$1
}

rule file_32_0_2 {
	meta:
		name = "_ZnwmRKSt9nothrow_t"
		size = 206
		refs = "0030 _Unwind_SjLj_Register 0040 malloc 0074 _Unwind_SjLj_Unregister 00a4 _Unwind_SjLj_Resume 00a8 __cxa_begin_catch 00b0 __cxa_end_catch 00b8 __cxa_call_unexpected 00bc __gxx_personality_sj0 00c8 __new_handler"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 8F B0 2B 4B 00 AF 3B 62 3C 22 2A 4B D2 19 7B 62 BA 62 3B 1C 28 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 ?? ?? ?? ?? 7B 68 00 2B 01 D1 01 22 7A 60 78 68 ?? ?? ?? ?? 38 60 00 28 12 D1 1F 4A 13 68 00 2B 04 D1 0D E0 1C 4A 13 68 00 2B 08 D0 01 22 FA 60 00 F0 34 F8 78 68 ?? ?? ?? ?? 00 28 F2 D0 38 60 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 38 68 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 3C 3F FA 68 38 69 7B 69 01 2A 01 D0 01 2B 06 D0 5A 1C 0B D0 01 23 5B 42 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? 00 23 FB 60 ?? ?? ?? ?? DC E7 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_34_0_2 {
	meta:
		name = "_ZNSt11__timepunctIcE23_M_initialize_timepunctEPi"
		size = 548
		refs = "00e4 _Znwm 0220 _ZTVSt17__timepunct_cacheIcE"
	strings:
		$1 = { 10 B5 04 1C 80 68 00 28 00 D1 6A E0 5A 4B 83 60 C3 60 5A 4B 03 61 43 61 59 4B 83 61 C3 61 83 62 58 4B C3 62 58 4B 03 63 58 4B 43 63 58 4B 83 63 58 4B C3 63 58 4B 03 64 58 4B 43 64 58 4B 59 4A 83 64 59 4B 02 62 C3 64 58 4A 59 4B 42 62 03 65 58 4B 43 65 58 4B 59 4A 83 65 59 4B 82 67 59 4A C3 65 59 49 59 4B C2 67 80 22 81 50 03 66 58 49 58 4B 84 22 81 50 43 66 57 49 58 4B 88 22 81 50 83 66 57 49 57 4B 8C 22 81 50 C3 66 56 49 57 4B 90 22 81 50 03 67 56 49 56 4B 94 22 43 67 81 50 55 49 98 22 81 50 55 49 9C 22 81 50 54 49 A0 22 81 50 A4 22 83 50 53 4A A8 23 C2 50 52 4A AC 23 C2 50 52 4A B0 23 C2 50 51 4A B4 23 C2 50 51 4A B8 23 C2 50 50 4A BC 23 C2 50 50 4A C0 23 C2 50 10 BD C8 20 ?? ?? ?? ?? 4D 4A 00 23 02 60 80 22 43 60 83 60 C3 60 03 61 43 61 83 61 C3 61 03 62 43 62 83 62 C3 62 03 63 43 63 83 63 C3 63 03 64 43 64 83 64 C3 64 03 65 43 65 83 65 C3 65 03 66 43 66 83 66 C3 66 03 67 43 67 83 67 C3 67 83 50 84 22 83 50 88 22 83 50 8C 22 83 50 90 22 83 50 94 22 83 50 98 22 83 50 9C 22 83 50 A0 22 83 50 A4 22 83 50 A8 22 83 50 AC 22 83 50 B0 22 83 50 B4 22 83 50 B8 22 83 50 BC 22 83 50 C0 22 83 50 C4 22 83 54 A0 60 49 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_34_1_2 {
	meta:
		name = "_ZNKSt11__timepunctIcE6_M_putEPcmPKcPK2tm"
		size = 108
		refs = "0016 setlocale 001c strlen 0024 _Znam 002e memcpy 0042 strftime 0056 _ZdaPv"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 07 1C 88 46 00 20 00 21 99 46 92 46 ?? ?? ?? ?? 06 1C ?? ?? ?? ?? 45 1C 28 1C ?? ?? ?? ?? 2A 1C 31 1C 04 1C ?? ?? ?? ?? 39 69 00 20 ?? ?? ?? ?? 51 46 40 46 4A 46 08 9B ?? ?? ?? ?? 21 1C 05 1C 00 20 ?? ?? ?? ?? 00 2C 02 D0 20 1C ?? ?? ?? ?? 00 2D 01 D1 43 46 1D 70 1C BC 90 46 99 46 A2 46 F0 BD }
	condition:
		$1
}

rule file_35_0_2 {
	meta:
		name = "_ZN9__gnu_cxx4ropeIcSaIcEE8_S_fetchEPNS_13_Rope_RopeRepIcS1_EEm"
		size = 72
	strings:
		$1 = { 30 B5 03 69 81 B0 00 2B 09 D0 58 5C 01 B0 30 BD 03 1C 80 69 02 68 8A 42 01 D8 D8 69 89 1A 03 7B 01 2B F5 D0 00 2B 0C D0 03 2B F9 D8 80 69 6C 46 03 68 03 34 9D 68 01 22 23 1C 00 F0 04 F8 20 78 E4 E7 83 69 E1 E7 28 47 }
	condition:
		$1
}

rule file_35_3_2 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEEC1Ev"
		size = 20
		refs = "0004 _ZNSt13basic_filebufIcSt11char_traitsIcEEC2Ev 0010 _ZTVN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEEE"
		altNames = "_ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEEC2Ev"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_17_2 {
	meta:
		name = "_ZNSt11range_errorC1ERKSs"
		size = 20
		refs = "0004 _ZNSt13runtime_errorC2ERKSs 0010 _ZTVSt11range_error"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_18_2 {
	meta:
		name = "_ZNSt11range_errorC2ERKSs"
		size = 20
		refs = "0004 _ZNSt13runtime_errorC2ERKSs 0010 _ZTVSt11range_error"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_27_2 {
	meta:
		name = "_ZNSt12domain_errorC1ERKSs"
		size = 20
		refs = "0004 _ZNSt11logic_errorC2ERKSs 0010 _ZTVSt12domain_error"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_28_2 {
	meta:
		name = "_ZNSt12domain_errorC2ERKSs"
		size = 20
		refs = "0004 _ZNSt11logic_errorC2ERKSs 0010 _ZTVSt12domain_error"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_23_2 {
	meta:
		name = "_ZNSt12length_errorC1ERKSs"
		size = 20
		refs = "0004 _ZNSt11logic_errorC2ERKSs 0010 _ZTVSt12length_error"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_24_2 {
	meta:
		name = "_ZNSt12length_errorC2ERKSs"
		size = 20
		refs = "0004 _ZNSt11logic_errorC2ERKSs 0010 _ZTVSt12length_error"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_21_2 {
	meta:
		name = "_ZNSt12out_of_rangeC1ERKSs"
		size = 20
		refs = "0004 _ZNSt11logic_errorC2ERKSs 0010 _ZTVSt12out_of_range"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_22_2 {
	meta:
		name = "_ZNSt12out_of_rangeC2ERKSs"
		size = 20
		refs = "0004 _ZNSt11logic_errorC2ERKSs 0010 _ZTVSt12out_of_range"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_15_2 {
	meta:
		name = "_ZNSt14overflow_errorC1ERKSs"
		size = 20
		refs = "0004 _ZNSt13runtime_errorC2ERKSs 0010 _ZTVSt14overflow_error"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_16_2 {
	meta:
		name = "_ZNSt14overflow_errorC2ERKSs"
		size = 20
		refs = "0004 _ZNSt13runtime_errorC2ERKSs 0010 _ZTVSt14overflow_error"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_13_2 {
	meta:
		name = "_ZNSt15underflow_errorC1ERKSs"
		size = 20
		refs = "0004 _ZNSt13runtime_errorC2ERKSs 0010 _ZTVSt15underflow_error"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_14_2 {
	meta:
		name = "_ZNSt15underflow_errorC2ERKSs"
		size = 20
		refs = "0004 _ZNSt13runtime_errorC2ERKSs 0010 _ZTVSt15underflow_error"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_25_2 {
	meta:
		name = "_ZNSt16invalid_argumentC1ERKSs"
		size = 20
		refs = "0004 _ZNSt11logic_errorC2ERKSs 0010 _ZTVSt16invalid_argument"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_26_2 {
	meta:
		name = "_ZNSt16invalid_argumentC2ERKSs"
		size = 20
		refs = "0004 _ZNSt11logic_errorC2ERKSs 0010 _ZTVSt16invalid_argument"
	strings:
		$1 = { 10 B5 04 1C ?? ?? ?? ?? 01 4B 23 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_5_2 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEEC1EP7__sFILESt13_Ios_Openmodem"
		size = 228
		refs = "002c _Unwind_SjLj_Register 0038 _ZNSt13basic_filebufIcSt11char_traitsIcEEC2Ev 0050 _ZNSt12__basic_fileIcE8sys_openEP7__sFILESt13_Ios_Openmode 005a _ZNKSt12__basic_fileIcE7is_openEv 0066 _Unwind_SjLj_Unregister 0080 _ZNSt13basic_filebufIcSt11char_traitsIcEE27_M_allocate_internal_bufferEv 00ba _Unwind_SjLj_Resume 00c4 _ZNSt13basic_filebufIcSt11char_traitsIcEED2Ev 00ce __cxa_call_unexpected 00d4 __gxx_personality_sj0 00e0 _ZTVN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEEE"
		altNames = "_ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEEC2EP7__sFILESt13_Ios_Openmodem"
	strings:
		$1 = { 80 B5 92 B0 00 AF 3B 60 32 4B FB 62 32 4B 79 60 3B 63 BA 60 3B 1C 31 4A 48 21 34 33 C9 19 79 63 38 61 5A 60 38 1C 6A 46 9A 60 14 30 ?? ?? ?? ?? 01 23 5B 42 38 69 BB 61 ?? ?? ?? ?? 28 4B 39 69 0B 60 24 31 F9 60 02 23 08 1C BA 68 79 68 BB 61 ?? ?? ?? ?? 01 23 F8 68 BB 61 ?? ?? ?? ?? 00 28 06 D1 38 1C 14 30 ?? ?? ?? ?? BD 46 12 B0 80 BD 3B 69 BA 68 39 68 DA 62 D9 64 38 69 02 23 BB 61 ?? ?? ?? ?? 39 69 00 23 51 22 8B 54 52 22 8B 54 8A 6C 4B 61 4A 60 8A 60 CA 60 0B 61 8B 61 E0 E7 48 3F FA 69 FA 60 BA 69 3B 6A 01 2A 07 D0 59 1C 0B D0 01 23 5B 42 F8 68 BB 61 ?? ?? ?? ?? 00 23 38 69 BB 61 ?? ?? ?? ?? F3 E7 F8 68 BB 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_7_2 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEEC1EiSt13_Ios_Openmodem"
		size = 228
		refs = "002c _Unwind_SjLj_Register 0038 _ZNSt13basic_filebufIcSt11char_traitsIcEEC2Ev 0050 _ZNSt12__basic_fileIcE8sys_openEiSt13_Ios_Openmode 005a _ZNKSt12__basic_fileIcE7is_openEv 0066 _Unwind_SjLj_Unregister 0080 _ZNSt13basic_filebufIcSt11char_traitsIcEE27_M_allocate_internal_bufferEv 00ba _Unwind_SjLj_Resume 00c4 _ZNSt13basic_filebufIcSt11char_traitsIcEED2Ev 00ce __cxa_call_unexpected 00d4 __gxx_personality_sj0 00e0 _ZTVN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEEE"
	strings:
		$1 = { 80 B5 92 B0 00 AF 3B 60 32 4B FB 62 32 4B 79 60 3B 63 BA 60 3B 1C 31 4A 48 21 34 33 C9 19 79 63 38 61 5A 60 38 1C 6A 46 9A 60 14 30 ?? ?? ?? ?? 01 23 5B 42 38 69 BB 61 ?? ?? ?? ?? 28 4B 39 69 0B 60 24 31 F9 60 02 23 08 1C BA 68 79 68 BB 61 ?? ?? ?? ?? 01 23 F8 68 BB 61 ?? ?? ?? ?? 00 28 06 D1 38 1C 14 30 ?? ?? ?? ?? BD 46 12 B0 80 BD 3B 69 BA 68 39 68 DA 62 D9 64 38 69 02 23 BB 61 ?? ?? ?? ?? 39 69 00 23 51 22 8B 54 52 22 8B 54 8A 6C 4B 61 4A 60 8A 60 CA 60 0B 61 8B 61 E0 E7 48 3F FA 69 FA 60 BA 69 3B 6A 01 2A 07 D0 59 1C 0B D0 01 23 5B 42 F8 68 BB 61 ?? ?? ?? ?? 00 23 38 69 BB 61 ?? ?? ?? ?? F3 E7 F8 68 BB 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_6_2 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEEC2EiSt13_Ios_Openmodem"
		size = 228
		refs = "002c _Unwind_SjLj_Register 0038 _ZNSt13basic_filebufIcSt11char_traitsIcEEC2Ev 0050 _ZNSt12__basic_fileIcE8sys_openEiSt13_Ios_Openmode 005a _ZNKSt12__basic_fileIcE7is_openEv 0066 _Unwind_SjLj_Unregister 0080 _ZNSt13basic_filebufIcSt11char_traitsIcEE27_M_allocate_internal_bufferEv 00ba _Unwind_SjLj_Resume 00c4 _ZNSt13basic_filebufIcSt11char_traitsIcEED2Ev 00ce __cxa_call_unexpected 00d4 __gxx_personality_sj0 00e0 _ZTVN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEEE"
	strings:
		$1 = { 80 B5 92 B0 00 AF 3B 60 32 4B FB 62 32 4B 79 60 3B 63 BA 60 3B 1C 31 4A 48 21 34 33 C9 19 79 63 38 61 5A 60 38 1C 6A 46 9A 60 14 30 ?? ?? ?? ?? 01 23 5B 42 38 69 BB 61 ?? ?? ?? ?? 28 4B 39 69 0B 60 24 31 F9 60 02 23 08 1C BA 68 79 68 BB 61 ?? ?? ?? ?? 01 23 F8 68 BB 61 ?? ?? ?? ?? 00 28 06 D1 38 1C 14 30 ?? ?? ?? ?? BD 46 12 B0 80 BD 3B 69 BA 68 39 68 DA 62 D9 64 38 69 02 23 BB 61 ?? ?? ?? ?? 39 69 00 23 51 22 8B 54 52 22 8B 54 8A 6C 4B 61 4A 60 8A 60 CA 60 0B 61 8B 61 E0 E7 48 3F FA 69 FA 60 BA 69 3B 6A 01 2A 07 D0 59 1C 0B D0 01 23 5B 42 F8 68 BB 61 ?? ?? ?? ?? 00 23 38 69 BB 61 ?? ?? ?? ?? F3 E7 F8 68 BB 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_9_2 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEED0Ev"
		size = 172
		refs = "0026 _Unwind_SjLj_Register 0036 _ZNSt13basic_filebufIcSt11char_traitsIcEE5closeEv 0042 _ZNSt12__basic_fileIcED1Ev 0050 _ZNSt6localeD1Ev 0056 _ZdlPv 005e _Unwind_SjLj_Unregister 0086 _ZNSt15basic_streambufIcSt11char_traitsIcEED2Ev 0092 _Unwind_SjLj_Resume 0098 __gxx_personality_sj0 00a4 _ZTVSt13basic_filebufIcSt11char_traitsIcEE 00a8 _ZTVSt15basic_streambufIcSt11char_traitsIcEE"
		altNames = "_ZNSt13basic_filebufIcSt11char_traitsIcEED0Ev"
	strings:
		$1 = { 80 B5 8F B0 24 4B 00 AF 3B 62 3C 22 23 4B D2 19 7B 62 BA 62 3B 1C 22 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 ?? ?? ?? ?? 1E 4B 7A 68 13 60 10 1C 01 23 FB 60 ?? ?? ?? ?? 78 68 02 23 24 30 FB 60 ?? ?? ?? ?? 7A 68 17 4B 10 1C 13 60 1C 30 ?? ?? ?? ?? 78 68 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 3B 69 3B 60 FB 68 01 2B 05 D0 78 68 00 23 24 30 FB 60 ?? ?? ?? ?? 00 23 78 68 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_10_2 {
	meta:
		name = "_ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEED1Ev"
		size = 164
		refs = "0026 _Unwind_SjLj_Register 0036 _ZNSt13basic_filebufIcSt11char_traitsIcEE5closeEv 0042 _ZNSt12__basic_fileIcED1Ev 0050 _ZNSt6localeD1Ev 0058 _Unwind_SjLj_Unregister 0080 _ZNSt15basic_streambufIcSt11char_traitsIcEED2Ev 008c _Unwind_SjLj_Resume 0090 __gxx_personality_sj0 009c _ZTVSt13basic_filebufIcSt11char_traitsIcEE 00a0 _ZTVSt15basic_streambufIcSt11char_traitsIcEE"
		altNames = "_ZN9__gnu_cxx13stdio_filebufIcSt11char_traitsIcEED2Ev _ZNSt13basic_filebufIcSt11char_traitsIcEED1Ev _ZNSt13basic_filebufIcSt11char_traitsIcEED2Ev"
	strings:
		$1 = { 80 B5 8F B0 22 4B 00 AF 3B 62 3C 22 21 4B D2 19 7B 62 BA 62 3B 1C 20 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 ?? ?? ?? ?? 1C 4B 7A 68 13 60 10 1C 01 23 FB 60 ?? ?? ?? ?? 78 68 02 23 24 30 FB 60 ?? ?? ?? ?? 7A 68 15 4B 10 1C 13 60 1C 30 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 3B 69 3B 60 FB 68 01 2B 05 D0 78 68 00 23 24 30 FB 60 ?? ?? ?? ?? 00 23 78 68 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_36_0_2 {
	meta:
		name = "_ZNK10__cxxabiv121__vmi_class_type_info20__do_find_public_srcElPKvPKNS_17__class_type_infoES2_"
		size = 156
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 83 B0 88 46 0C 99 8B 46 16 1C 99 46 5A 45 38 D0 C5 68 6C 1C 4B 46 E4 00 01 21 C1 46 04 19 02 27 8A 46 01 93 B0 46 00 2D 1D D0 63 68 01 3D 3B 42 16 D0 51 46 1A 12 19 40 02 91 05 D0 4B 46 03 33 0E D0 41 46 0B 68 9A 58 20 68 59 46 03 68 00 91 42 44 1E 6A 49 46 01 9B 00 F0 19 F8 03 28 0A DC 08 3C 00 2D E1 D1 01 20 03 B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 02 9B 00 2B F5 D0 01 23 18 43 F2 E7 42 68 5B 68 9A 42 C2 D1 06 20 EC E7 30 47 }
	condition:
		$1
}

rule file_36_1_2 {
	meta:
		name = "_ZNK10__cxxabiv121__vmi_class_type_info12__do_dyncastElNS_17__class_type_info10__sub_kindEPKS1_PKvS4_S6_RNS1_16__dyncast_resultE"
		size = 850
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 91 B0 1D 9D 0A 90 08 93 1A 98 2B 69 05 91 09 92 83 46 D9 06 02 D5 0A 9A 93 68 2B 61 1C 9B 9B 45 00 D1 40 E1 0A 98 43 68 08 99 4A 68 93 42 00 D1 F7 E0 0A 9A D2 68 16 1C 0A 9B 01 36 09 99 91 46 F6 00 01 22 9E 19 00 20 11 43 4B 46 07 90 0C AC 00 27 0B 91 00 2B 6F D0 01 23 5B 42 28 69 99 44 73 68 01 22 80 46 27 60 67 60 A7 60 E7 60 20 61 19 12 13 42 62 D1 09 9A 02 20 03 42 05 D1 05 9B 02 33 00 D1 94 E0 02 20 82 43 30 68 59 44 03 68 00 91 1B 99 01 91 1C 99 03 94 02 91 DB 69 05 99 9C 46 08 9B 00 F0 4E F9 A2 68 AB 68 13 43 E2 68 82 46 AB 60 90 46 02 2A 00 D1 FF E0 06 2A 00 D1 FC E0 07 99 00 29 3E D1 2A 68 00 2A 00 D1 D2 E0 21 68 8A 42 00 D1 89 E0 00 29 00 D1 8B E0 E8 68 04 90 03 2B 39 DD 01 21 0B 42 75 D1 04 99 00 29 79 D0 43 46 00 2B 6B D1 04 98 01 21 06 90 8A 46 88 46 06 9B 50 46 43 40 03 2B 45 DD 03 28 56 DC 06 99 8A 46 04 99 52 46 02 23 E9 60 1A 42 00 D0 8F E0 01 20 02 42 00 D1 8B E0 AB 68 04 2B 03 D0 08 3E 4B 46 00 2B 8F D1 07 99 83 E0 58 46 00 68 0B 9A 41 58 98 E7 2A 68 00 2A C1 D1 21 68 00 29 EC D0 E8 68 04 90 03 2B C5 DC 04 9B 06 93 00 2B 4D DD C2 46 43 46 00 2B CB DC 06 98 03 28 00 DD 70 E0 05 99 22 68 00 29 00 DA A7 E0 05 99 53 18 1C 9A 9A 42 00 D1 C8 E0 01 22 92 46 06 9B 50 46 43 40 90 46 03 2B B9 DC 06 9B 51 46 0B 40 03 2B 00 DD C3 E0 01 22 2F 60 EA 60 AB 68 07 92 BD E7 40 46 03 23 18 42 00 D0 65 E7 08 3E B9 E7 23 68 2B 60 63 68 42 46 00 20 6B 60 04 92 07 90 A1 E7 04 9A C2 46 06 92 94 E7 2B 69 02 20 03 42 BC D1 04 99 00 29 85 D1 01 22 04 92 82 E7 69 68 62 68 0A 43 6A 60 9A E7 00 28 00 D0 70 E7 96 E7 43 46 C2 46 03 2B 30 DC 05 98 00 28 00 DA 70 E0 05 99 1C 9B 52 18 93 42 00 D1 7B E0 01 22 06 92 04 92 A0 E7 09 98 05 99 5B 46 2B 60 68 60 00 29 00 DA 82 E0 0B 1C 1C 98 5B 44 98 42 00 D1 71 E0 01 23 EB 60 00 21 11 B0 08 1C 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 01 21 08 42 96 D0 0A 9A 93 68 02 20 03 42 00 D1 90 E7 84 E7 01 20 03 42 15 D1 01 21 06 91 04 91 45 E7 22 68 61 68 2A 60 69 60 00 2A 06 D0 00 2B 06 D0 0A 9A 92 68 01 21 0A 42 4B D0 07 90 4B E7 07 90 08 3E 4B E7 0A 99 8B 68 02 20 03 42 E4 D0 AF E7 0A 98 1B 99 43 68 4A 68 93 42 00 D0 B9 E6 09 9A 00 21 AA 60 C3 E7 0C 9B 2B 60 63 68 6B 60 E3 68 51 46 EB 60 BB E7 05 98 02 30 00 D1 59 E7 08 99 1C 98 0B 68 00 90 1B 6A 08 1C 9C 46 05 99 1B 9B 00 F0 2D F8 80 46 82 46 08 E7 05 99 02 31 00 D1 90 E7 1C 99 08 98 03 68 00 91 1B 6A 05 99 9C 46 1B 9B 00 F0 1C F8 04 90 06 90 28 E7 06 20 06 90 04 90 24 E7 06 23 9A 46 98 46 EF E6 06 23 EB 60 8C E7 01 1C 8B E7 00 23 2B 60 02 23 EB 60 01 21 85 E7 05 99 02 31 00 D0 80 E7 01 23 7D E7 60 47 }
	condition:
		$1
}

rule file_36_2_2 {
	meta:
		name = "_ZNK10__cxxabiv121__vmi_class_type_info11__do_upcastEPKNS_17__class_type_infoEPKvRNS1_15__upcast_resultE"
		size = 362
		refs = "0016 _ZNK10__cxxabiv117__class_type_info11__do_upcastEPKS0_PKvRNS0_15__upcast_resultE"
	strings:
		$1 = { F0 B5 5F 46 56 46 4D 46 44 46 F0 B4 8A B0 05 90 03 91 92 46 1E 1C ?? ?? ?? ?? 00 28 00 D0 80 E0 B0 68 02 90 C0 06 00 D5 94 E0 05 9A D7 68 02 99 7D 1C 00 23 01 20 D3 46 BA 46 ED 00 98 46 01 40 53 46 55 19 06 AC 81 46 04 91 37 1C 00 2B 45 D0 01 22 52 42 92 44 6A 68 43 46 02 9E 23 60 63 60 E3 60 48 46 53 08 A6 60 18 40 01 90 02 D1 04 99 00 29 2F D0 4B 46 13 40 5E 46 00 93 00 2E 37 D0 00 98 12 12 00 28 02 D0 59 46 0B 68 9A 58 5A 44 28 68 03 68 03 99 9E 69 23 1C 00 F0 65 F8 00 28 18 D0 E3 68 08 2B 25 D0 63 68 03 2B 05 DD 01 9E 00 2E 02 D1 02 20 83 43 63 60 FA 68 00 2A 1F D0 3B 68 21 68 8B 42 49 D1 00 2B 2C D0 7A 68 63 68 13 43 7B 60 08 3D 53 46 00 2B B9 D1 78 68 43 1E 98 41 0A B0 3C BC 90 46 99 46 A2 46 AB 46 F0 BD 00 22 CD E7 00 9A 00 2A D6 D0 2B 68 E3 60 D3 E7 3B 1C 22 1C 43 CA 43 C3 12 68 1A 60 7B 68 03 2B 07 DD 02 21 0B 42 13 D0 05 9A 93 68 4E 46 33 42 D8 D1 01 20 DD E7 E3 68 08 2B 05 D0 08 2A 03 D0 5B 68 52 68 93 42 C9 D0 02 23 7B 60 01 20 D0 E7 48 46 03 42 ED D0 05 99 8B 68 02 22 13 42 E8 D0 08 3D C0 E7 05 99 89 68 02 91 66 E7 00 23 3B 60 02 23 7B 60 01 20 BC E7 30 47 }
	condition:
		$1
}

rule file_37_0_2 {
	meta:
		name = "__cxa_call_terminate"
		size = 52
		refs = "0008 __cxa_begin_catch 001c _ZSt9terminatev 0028 _ZN10__cxxabiv111__terminateEPFvvE"
	strings:
		$1 = { 10 B5 04 1C 00 28 09 D0 ?? ?? ?? ?? 22 68 63 68 07 49 06 48 12 18 4B 41 00 2B 01 D0 ?? ?? ?? ?? 01 2A FB D8 2C 3C E0 68 ?? ?? ?? ?? 00 D5 D4 BC BC AA B1 B8 }
	condition:
		$1
}

rule file_38_0_2 {
	meta:
		name = "hypotf"
		size = 100
		refs = "000c __addsf3 0014 __eqsf2 0020 __divsf3 0034 __mulsf3 004a sqrtf"
	strings:
		$1 = { 70 B5 16 4B 06 1C 0D 1C 18 40 19 40 ?? ?? ?? ?? 13 49 04 1C ?? ?? ?? ?? 00 28 1D D0 21 1C 30 1C ?? ?? ?? ?? 21 1C 06 1C 28 1C ?? ?? ?? ?? 31 1C 05 1C 30 1C ?? ?? ?? ?? 29 1C 06 1C 28 1C ?? ?? ?? ?? 01 1C 30 1C ?? ?? ?? ?? ?? ?? ?? ?? 01 1C 20 1C ?? ?? ?? ?? 04 1C 20 1C 70 BD FF FF FF 7F 00 00 00 00 }
	condition:
		$1
}

rule file_39_0_2 {
	meta:
		name = "_ZStrsIecSt11char_traitsIcEERSt13basic_istreamIT0_T1_ES6_RSt7complexIT_E"
		size = 152
		refs = "000e _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_RS3_ 001a _ZNSi7putbackEc 0022 _ZNSi10_M_extractIeEERSiRT_ 0062 _ZNSt9basic_iosIcSt11char_traitsIcEE5clearESt12_Ios_Iostate"
	strings:
		$1 = { 70 B5 85 B0 6D 46 13 35 0E 1C 29 1C 04 1C ?? ?? ?? ?? 29 78 28 29 11 D0 20 1C ?? ?? ?? ?? 20 1C 02 A9 ?? ?? ?? ?? 02 9A 03 9B 32 60 73 60 19 4B 17 4A B2 60 F3 60 05 B0 20 1C 70 BD 02 A9 20 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 2B 78 2C 2B 0B D0 29 2B E8 D0 23 68 0C 3B 18 68 20 18 43 69 04 21 19 43 ?? ?? ?? ?? E6 E7 69 46 20 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 2B 78 29 2B EB D1 00 9A 01 9B B2 60 F3 60 02 9A 03 9B 32 60 73 60 D3 E7 C0 46 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_39_3_2 {
	meta:
		name = "_ZStrsIdcSt11char_traitsIcEERSt13basic_istreamIT0_T1_ES6_RSt7complexIT_E"
		size = 152
		refs = "000e _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_RS3_ 001a _ZNSi7putbackEc 0022 _ZNSi10_M_extractIdEERSiRT_ 0062 _ZNSt9basic_iosIcSt11char_traitsIcEE5clearESt12_Ios_Iostate"
	strings:
		$1 = { 70 B5 85 B0 6D 46 13 35 0E 1C 29 1C 04 1C ?? ?? ?? ?? 29 78 28 29 11 D0 20 1C ?? ?? ?? ?? 20 1C 02 A9 ?? ?? ?? ?? 02 9A 03 9B 32 60 73 60 19 4B 17 4A B2 60 F3 60 05 B0 20 1C 70 BD 02 A9 20 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 2B 78 2C 2B 0B D0 29 2B E8 D0 23 68 0C 3B 18 68 20 18 43 69 04 21 19 43 ?? ?? ?? ?? E6 E7 69 46 20 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 2B 78 29 2B EB D1 00 9A 01 9B B2 60 F3 60 02 9A 03 9B 32 60 73 60 D3 E7 C0 46 00 00 00 00 00 00 00 00 }
	condition:
		$1
}

rule file_39_1_2 {
	meta:
		name = "_ZNSt15basic_stringbufIcSt11char_traitsIcESaIcEED1Ev"
		size = 68
		refs = "001c _ZNSt6localeD1Ev 0030 _ZNSs4_Rep10_M_destroyERKSaIcE 0038 _ZTVSt15basic_stringbufIcSt11char_traitsIcESaIcEE 003c _ZNSs4_Rep20_S_empty_rep_storageE 0040 _ZTVSt15basic_streambufIcSt11char_traitsIcEE"
	strings:
		$1 = { 10 B5 0D 4B 04 1C 03 60 40 6A 0C 4B 0C 38 81 B0 98 42 07 D1 0A 4B 20 1C 23 60 1C 30 ?? ?? ?? ?? 01 B0 10 BD 83 68 5A 1E 82 60 00 2B F2 DC 69 46 ?? ?? ?? ?? EE E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_2_2 {
	meta:
		name = "_ZStlsIecSt11char_traitsIcEERSt13basic_ostreamIT0_T1_ES6_RKSt7complexIT_E"
		size = 954
		refs = "002a _Unwind_SjLj_Register 0038 _ZNSt8ios_baseC2Ev 008a _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 00ac _ZNSt6localeC1Ev 00e4 _ZNSt6localeC1ERKS_ 00fc _ZNSt9basic_iosIcSt11char_traitsIcEE5imbueERKSt6locale 0104 _ZNSt6localeD1Ev 012e _ZSt16__ostream_insertIcSt11char_traitsIcEERSt13basic_ostreamIT_T0_ES6_PKS3_l 0138 _ZNSo9_M_insertIeEERSoT_ 0192 _ZNSsC1IPcEET_S1_RKSaIcE 01a6 _ZNSs6assignERKSs 0224 _ZNSt8ios_baseD2Ev 022c _Unwind_SjLj_Unregister 027c _ZNSs4_Rep10_M_destroyERKSaIcE 030e _ZNSsD1Ev 0328 _ZNSt19basic_ostringstreamIcSt11char_traitsIcESaIcEED1Ev 0334 _Unwind_SjLj_Resume 0354 __gxx_personality_sj0 0360 _ZTVSt9basic_iosIcSt11char_traitsIcEE 0364 _ZTTSt19basic_ostringstreamIcSt11char_traitsIcESaIcEE 0368 _ZTVSt19basic_ostringstreamIcSt11char_traitsIcESaIcEE 036c _ZTVSt15basic_streambufIcSt11char_traitsIcEE 0370 _ZTVSt15basic_stringbufIcSt11char_traitsIcESaIcEE 0374 _ZNSs4_Rep20_S_empty_rep_storageE 0388 _ZNSt15basic_stringbufIcSt11char_traitsIcESaIcEED1Ev 03a4 _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev"
	strings:
		$1 = { 90 B5 CB B0 D3 4B 00 AF FB 62 D3 4B 39 60 96 21 3B 63 D2 4A 3B 1C 49 00 34 33 C9 19 79 63 38 61 5A 60 38 1C 6A 46 9A 60 14 30 ?? ?? ?? ?? 01 23 38 1C 5B 42 74 30 BB 61 ?? ?? ?? ?? C8 4B 48 24 E4 19 7B 67 9C 22 00 23 A3 50 A0 22 A3 54 A1 22 A3 54 A4 22 A3 50 A8 22 A3 50 AC 22 A3 50 B0 22 A3 50 C0 4B 59 68 9B 68 B9 64 BB 60 F9 60 0C 39 0B 68 BC 68 48 22 D2 19 D4 50 BB 6C 0C 3B 18 68 79 60 06 23 10 18 00 21 BB 61 ?? ?? ?? ?? B6 4B BB 64 14 33 7B 67 B5 4B 38 1C FB 64 68 30 00 23 3B 65 7B 65 BB 65 FB 65 3B 66 7B 66 ?? ?? ?? ?? AF 4B B0 4A FB 64 38 1C 10 23 39 1C FB 66 74 30 07 23 4C 31 3A 67 BB 61 ?? ?? ?? ?? 3C 69 23 68 0C 3B 19 68 61 18 CB 68 80 22 D3 51 92 23 5B 00 F8 18 6C 31 ?? ?? ?? ?? 09 23 BB 61 90 24 92 23 64 00 39 1C 5B 00 38 19 74 31 FA 18 ?? ?? ?? ?? 38 19 04 34 ?? ?? ?? ?? 38 19 ?? ?? ?? ?? 39 69 0B 68 0C 3B 1B 68 CB 18 5B 68 97 4A 38 1C 48 30 03 63 B9 18 28 23 0B 70 01 22 0A 23 BB 61 ?? ?? ?? ?? 3B 68 19 68 5A 68 ?? ?? ?? ?? 07 34 2C 23 39 19 0B 70 01 22 0A 23 BB 61 ?? ?? ?? ?? 3B 68 99 68 DA 68 ?? ?? ?? ?? 87 4C 29 23 39 19 0B 70 01 22 ?? ?? ?? ?? 83 49 8E 22 52 00 D1 51 39 1C 48 31 8B 69 00 2B 00 D1 83 E0 0A 69 93 42 5B D8 02 23 49 69 8C 24 BB 61 8A 23 5B 00 64 00 F8 18 3B 19 ?? ?? ?? ?? 8E 21 8A 22 49 00 52 00 01 23 78 18 B9 18 BB 61 ?? ?? ?? ?? 8A 23 5B 00 D8 59 72 4B 0C 38 98 42 00 D0 82 E0 8E 22 52 00 D1 59 0B 1C 0C 3B 1A 68 38 69 08 23 BB 61 ?? ?? ?? ?? 8E 23 5B 00 38 61 D8 59 68 4C 0C 38 A0 42 5A D1 61 4A 3B 1C 48 33 BA 64 98 6A 14 32 DA 62 63 4C 5F 4A 0C 38 5A 60 84 42 58 D1 5C 4B 38 1C 68 30 FB 64 ?? ?? ?? ?? F9 68 7A 68 B9 64 13 68 B9 68 48 24 E4 19 E1 50 52 4B 38 1C 7B 67 01 23 5B 42 74 30 BB 61 ?? ?? ?? ?? 38 1C 14 30 ?? ?? ?? ?? BD 46 4B B0 38 69 90 BD 1F 3C 04 22 38 19 04 34 49 69 BA 61 1A 1C 3B 19 ?? ?? ?? ?? 8E 21 86 22 49 00 52 00 03 23 78 18 B9 18 BB 61 ?? ?? ?? ?? 86 23 5B 00 D8 59 45 4B 0C 38 98 42 A5 D0 83 68 5A 1E 82 60 00 2B A0 DC 08 3C 39 19 ?? ?? ?? ?? 9B E7 8E 24 64 00 39 1C 05 23 38 19 70 31 BB 61 ?? ?? ?? ?? 91 E7 83 68 5A 1E 82 60 00 2B 9F DC 80 22 52 00 B9 18 ?? ?? ?? ?? 99 E7 83 68 5A 1E 82 60 00 2B A1 DC 39 1C FC 31 ?? ?? ?? ?? 9C E7 83 68 5A 1E 82 60 00 2B 00 DD 76 E7 14 3C 39 19 ?? ?? ?? ?? 71 E7 2A 49 7F 18 FA 69 BB 69 3A 61 01 2B 16 D0 02 2B 60 D0 03 2B 12 D0 04 2B 10 D0 05 2B 53 D0 06 2B 45 D0 07 2B 23 D0 08 2B 1B D0 09 2B 0D D0 00 23 BB 61 8A 23 5B 00 F8 18 ?? ?? ?? ?? 8E 21 49 00 00 23 78 18 BB 61 ?? ?? ?? ?? 38 1C 00 23 48 30 BB 61 ?? ?? ?? ?? 01 23 5B 42 38 69 BB 61 ?? ?? ?? ?? 92 21 49 00 78 18 ?? ?? ?? ?? ED E7 00 23 BB 61 8E 23 5B 00 F8 18 ?? ?? ?? ?? E5 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2B 01 00 00 ?? ?? ?? ?? D4 FE FF FF 38 1C 4C 30 ?? ?? ?? ?? FB 68 7C 68 BB 64 BA 68 23 68 48 21 C9 19 CA 50 38 1C 00 23 74 30 BB 61 ?? ?? ?? ?? C0 E7 86 21 49 00 00 23 78 18 BB 61 ?? ?? ?? ?? AB E7 }
	condition:
		$1
}

rule file_39_5_2 {
	meta:
		name = "_ZStlsIdcSt11char_traitsIcEERSt13basic_ostreamIT0_T1_ES6_RKSt7complexIT_E"
		size = 954
		refs = "002a _Unwind_SjLj_Register 0038 _ZNSt8ios_baseC2Ev 008a _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 00ac _ZNSt6localeC1Ev 00e4 _ZNSt6localeC1ERKS_ 00fc _ZNSt9basic_iosIcSt11char_traitsIcEE5imbueERKSt6locale 0104 _ZNSt6localeD1Ev 012e _ZSt16__ostream_insertIcSt11char_traitsIcEERSt13basic_ostreamIT_T0_ES6_PKS3_l 0138 _ZNSo9_M_insertIdEERSoT_ 0192 _ZNSsC1IPcEET_S1_RKSaIcE 01a6 _ZNSs6assignERKSs 0224 _ZNSt8ios_baseD2Ev 022c _Unwind_SjLj_Unregister 027c _ZNSs4_Rep10_M_destroyERKSaIcE 030e _ZNSsD1Ev 0328 _ZNSt19basic_ostringstreamIcSt11char_traitsIcESaIcEED1Ev 0334 _Unwind_SjLj_Resume 0354 __gxx_personality_sj0 0360 _ZTVSt9basic_iosIcSt11char_traitsIcEE 0364 _ZTTSt19basic_ostringstreamIcSt11char_traitsIcESaIcEE 0368 _ZTVSt19basic_ostringstreamIcSt11char_traitsIcESaIcEE 036c _ZTVSt15basic_streambufIcSt11char_traitsIcEE 0370 _ZTVSt15basic_stringbufIcSt11char_traitsIcESaIcEE 0374 _ZNSs4_Rep20_S_empty_rep_storageE 0388 _ZNSt15basic_stringbufIcSt11char_traitsIcESaIcEED1Ev 03a4 _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev"
	strings:
		$1 = { 90 B5 CB B0 D3 4B 00 AF FB 62 D3 4B 39 60 96 21 3B 63 D2 4A 3B 1C 49 00 34 33 C9 19 79 63 38 61 5A 60 38 1C 6A 46 9A 60 14 30 ?? ?? ?? ?? 01 23 38 1C 5B 42 74 30 BB 61 ?? ?? ?? ?? C8 4B 48 24 E4 19 7B 67 9C 22 00 23 A3 50 A0 22 A3 54 A1 22 A3 54 A4 22 A3 50 A8 22 A3 50 AC 22 A3 50 B0 22 A3 50 C0 4B 59 68 9B 68 B9 64 BB 60 F9 60 0C 39 0B 68 BC 68 48 22 D2 19 D4 50 BB 6C 0C 3B 18 68 79 60 06 23 10 18 00 21 BB 61 ?? ?? ?? ?? B6 4B BB 64 14 33 7B 67 B5 4B 38 1C FB 64 68 30 00 23 3B 65 7B 65 BB 65 FB 65 3B 66 7B 66 ?? ?? ?? ?? AF 4B B0 4A FB 64 38 1C 10 23 39 1C FB 66 74 30 07 23 4C 31 3A 67 BB 61 ?? ?? ?? ?? 3C 69 23 68 0C 3B 19 68 61 18 CB 68 80 22 D3 51 92 23 5B 00 F8 18 6C 31 ?? ?? ?? ?? 09 23 BB 61 90 24 92 23 64 00 39 1C 5B 00 38 19 74 31 FA 18 ?? ?? ?? ?? 38 19 04 34 ?? ?? ?? ?? 38 19 ?? ?? ?? ?? 39 69 0B 68 0C 3B 1B 68 CB 18 5B 68 97 4A 38 1C 48 30 03 63 B9 18 28 23 0B 70 01 22 0A 23 BB 61 ?? ?? ?? ?? 3B 68 19 68 5A 68 ?? ?? ?? ?? 07 34 2C 23 39 19 0B 70 01 22 0A 23 BB 61 ?? ?? ?? ?? 3B 68 99 68 DA 68 ?? ?? ?? ?? 87 4C 29 23 39 19 0B 70 01 22 ?? ?? ?? ?? 83 49 8E 22 52 00 D1 51 39 1C 48 31 8B 69 00 2B 00 D1 83 E0 0A 69 93 42 5B D8 02 23 49 69 8C 24 BB 61 8A 23 5B 00 64 00 F8 18 3B 19 ?? ?? ?? ?? 8E 21 8A 22 49 00 52 00 01 23 78 18 B9 18 BB 61 ?? ?? ?? ?? 8A 23 5B 00 D8 59 72 4B 0C 38 98 42 00 D0 82 E0 8E 22 52 00 D1 59 0B 1C 0C 3B 1A 68 38 69 08 23 BB 61 ?? ?? ?? ?? 8E 23 5B 00 38 61 D8 59 68 4C 0C 38 A0 42 5A D1 61 4A 3B 1C 48 33 BA 64 98 6A 14 32 DA 62 63 4C 5F 4A 0C 38 5A 60 84 42 58 D1 5C 4B 38 1C 68 30 FB 64 ?? ?? ?? ?? F9 68 7A 68 B9 64 13 68 B9 68 48 24 E4 19 E1 50 52 4B 38 1C 7B 67 01 23 5B 42 74 30 BB 61 ?? ?? ?? ?? 38 1C 14 30 ?? ?? ?? ?? BD 46 4B B0 38 69 90 BD 1F 3C 04 22 38 19 04 34 49 69 BA 61 1A 1C 3B 19 ?? ?? ?? ?? 8E 21 86 22 49 00 52 00 03 23 78 18 B9 18 BB 61 ?? ?? ?? ?? 86 23 5B 00 D8 59 45 4B 0C 38 98 42 A5 D0 83 68 5A 1E 82 60 00 2B A0 DC 08 3C 39 19 ?? ?? ?? ?? 9B E7 8E 24 64 00 39 1C 05 23 38 19 70 31 BB 61 ?? ?? ?? ?? 91 E7 83 68 5A 1E 82 60 00 2B 9F DC 80 22 52 00 B9 18 ?? ?? ?? ?? 99 E7 83 68 5A 1E 82 60 00 2B A1 DC 39 1C FC 31 ?? ?? ?? ?? 9C E7 83 68 5A 1E 82 60 00 2B 00 DD 76 E7 14 3C 39 19 ?? ?? ?? ?? 71 E7 2A 49 7F 18 FA 69 BB 69 3A 61 01 2B 16 D0 02 2B 60 D0 03 2B 12 D0 04 2B 10 D0 05 2B 53 D0 06 2B 45 D0 07 2B 23 D0 08 2B 1B D0 09 2B 0D D0 00 23 BB 61 8A 23 5B 00 F8 18 ?? ?? ?? ?? 8E 21 49 00 00 23 78 18 BB 61 ?? ?? ?? ?? 38 1C 00 23 48 30 BB 61 ?? ?? ?? ?? 01 23 5B 42 38 69 BB 61 ?? ?? ?? ?? 92 21 49 00 78 18 ?? ?? ?? ?? ED E7 00 23 BB 61 8E 23 5B 00 F8 18 ?? ?? ?? ?? E5 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2B 01 00 00 ?? ?? ?? ?? D4 FE FF FF 38 1C 4C 30 ?? ?? ?? ?? FB 68 7C 68 BB 64 BA 68 23 68 48 21 C9 19 CA 50 38 1C 00 23 74 30 BB 61 ?? ?? ?? ?? C0 E7 86 21 49 00 00 23 78 18 BB 61 ?? ?? ?? ?? AB E7 }
	condition:
		$1
}

rule file_39_4_2 {
	meta:
		name = "_ZStrsIfcSt11char_traitsIcEERSt13basic_istreamIT0_T1_ES6_RSt7complexIT_E"
		size = 132
		refs = "000e _ZStrsIcSt11char_traitsIcEERSt13basic_istreamIT_T0_ES6_RS3_ 001a _ZNSi7putbackEc 0022 _ZNSi10_M_extractIfEERSiRT_ 005a _ZNSt9basic_iosIcSt11char_traitsIcEE5clearESt12_Ios_Iostate"
	strings:
		$1 = { 70 B5 83 B0 6D 46 0B 35 0E 1C 29 1C 04 1C ?? ?? ?? ?? 29 78 28 29 0D D0 20 1C ?? ?? ?? ?? 20 1C 01 A9 ?? ?? ?? ?? 01 9B 33 60 15 4B 73 60 03 B0 20 1C 70 BD 01 A9 20 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 2B 78 2C 2B 0B D0 29 2B EC D0 23 68 0C 3B 18 68 20 18 43 69 04 21 19 43 ?? ?? ?? ?? E6 E7 69 46 20 1C ?? ?? ?? ?? 29 1C ?? ?? ?? ?? 2B 78 29 2B EB D1 00 9B 73 60 01 9B 33 60 D7 E7 C0 46 00 00 00 00 }
	condition:
		$1
}

rule file_39_6_2 {
	meta:
		name = "_ZStlsIfcSt11char_traitsIcEERSt13basic_ostreamIT0_T1_ES6_RKSt7complexIT_E"
		size = 982
		refs = "002a _Unwind_SjLj_Register 0038 _ZNSt8ios_baseC2Ev 008a _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 00ac _ZNSt6localeC1Ev 00e4 _ZNSt6localeC1ERKS_ 00fc _ZNSt9basic_iosIcSt11char_traitsIcEE5imbueERKSt6locale 0104 _ZNSt6localeD1Ev 012e _ZSt16__ostream_insertIcSt11char_traitsIcEERSt13basic_ostreamIT_T0_ES6_PKS3_l 0138 __extendsfdf2 0142 _ZNSo9_M_insertIdEERSoT_ 01a6 _ZNSsC1IPcEET_S1_RKSaIcE 01ba _ZNSs6assignERKSs 0238 _ZNSt8ios_baseD2Ev 0240 _Unwind_SjLj_Unregister 0294 _ZNSs4_Rep10_M_destroyERKSaIcE 0328 _ZNSsD1Ev 0342 _ZNSt19basic_ostringstreamIcSt11char_traitsIcESaIcEED1Ev 034e _Unwind_SjLj_Resume 0370 __gxx_personality_sj0 037c _ZTVSt9basic_iosIcSt11char_traitsIcEE 0380 _ZTTSt19basic_ostringstreamIcSt11char_traitsIcESaIcEE 0384 _ZTVSt19basic_ostringstreamIcSt11char_traitsIcESaIcEE 0388 _ZTVSt15basic_streambufIcSt11char_traitsIcEE 038c _ZTVSt15basic_stringbufIcSt11char_traitsIcESaIcEE 0390 _ZNSs4_Rep20_S_empty_rep_storageE 03a4 _ZNSt15basic_stringbufIcSt11char_traitsIcESaIcEED1Ev 03c0 _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev"
	strings:
		$1 = { 90 B5 CC B0 DA 4B 00 AF 3B 63 DA 4B 39 60 98 21 7B 63 D9 4A 3B 1C 49 00 38 33 C9 19 B9 63 78 61 5A 60 38 1C 6A 46 9A 60 18 30 ?? ?? ?? ?? 01 23 38 1C 5B 42 78 30 FB 61 ?? ?? ?? ?? CF 4B 4C 24 E4 19 BB 67 9C 22 00 23 A3 50 A0 22 A3 54 A1 22 A3 54 A4 22 A3 50 A8 22 A3 50 AC 22 A3 50 B0 22 A3 50 C7 4B 59 68 9B 68 F9 64 BB 60 39 61 0C 39 0B 68 BC 68 4C 22 D2 19 D4 50 FB 6C 0C 3B 18 68 79 60 06 23 10 18 00 21 FB 61 ?? ?? ?? ?? BD 4B FB 64 14 33 BB 67 BC 4B 38 1C 3B 65 6C 30 00 23 7B 65 BB 65 FB 65 3B 66 7B 66 BB 66 ?? ?? ?? ?? B6 4B B7 4A 3B 65 38 1C 10 23 39 1C 3B 67 78 30 07 23 50 31 7A 67 FB 61 ?? ?? ?? ?? 7C 69 23 68 0C 3B 19 68 61 18 CB 68 84 22 D3 51 94 23 5B 00 F8 18 6C 31 ?? ?? ?? ?? 09 23 FB 61 92 24 94 23 64 00 39 1C 5B 00 38 19 78 31 FA 18 ?? ?? ?? ?? 38 19 04 34 ?? ?? ?? ?? 38 19 ?? ?? ?? ?? 79 69 0B 68 0C 3B 1B 68 CB 18 5B 68 9E 4A 38 1C 4C 30 03 63 B9 18 28 23 0B 70 01 22 0A 23 FB 61 ?? ?? ?? ?? 3B 68 F8 60 18 68 ?? ?? ?? ?? 0A 1C 01 1C F8 68 ?? ?? ?? ?? 07 34 2C 23 39 19 0B 70 01 22 0A 23 FB 61 ?? ?? ?? ?? 3A 68 F8 60 50 68 ?? ?? ?? ?? 0A 1C 01 1C F8 68 ?? ?? ?? ?? 89 4B F9 18 29 23 0B 70 01 22 ?? ?? ?? ?? 85 4C 90 21 49 00 CC 51 39 1C 4C 31 8B 69 00 2B 00 D1 85 E0 0A 69 93 42 5B D8 02 23 49 69 8E 24 FB 61 8C 23 5B 00 64 00 F8 18 3B 19 ?? ?? ?? ?? 90 21 8C 22 49 00 52 00 01 23 78 18 B9 18 FB 61 ?? ?? ?? ?? 8C 23 5B 00 D8 59 74 4B 0C 38 98 42 00 D0 85 E0 90 22 52 00 D1 59 0B 1C 0C 3B 1A 68 78 69 08 23 FB 61 ?? ?? ?? ?? 90 23 5B 00 78 61 D8 59 6A 4C 0C 38 A0 42 5C D1 63 4A 3B 1C 4C 33 FA 64 98 6A 14 32 DA 62 65 4C 61 4A 0C 38 5A 60 84 42 5A D1 5E 4B 38 1C 6C 30 3B 65 ?? ?? ?? ?? 3B 69 7C 68 FB 64 BA 68 23 68 4C 21 C9 19 CA 50 54 4B 38 1C BB 67 01 23 5B 42 78 30 FB 61 ?? ?? ?? ?? 38 1C 18 30 ?? ?? ?? ?? BD 46 4C B0 78 69 90 BD 04 22 49 69 8A 24 FA 61 88 22 52 00 64 00 B8 18 1A 1C 3B 19 ?? ?? ?? ?? 90 21 88 22 49 00 52 00 03 23 78 18 B9 18 FB 61 ?? ?? ?? ?? 88 23 5B 00 D8 59 46 4B 0C 38 98 42 A3 D0 83 68 5A 1E 82 60 00 2B 9E DC 08 3C 39 19 ?? ?? ?? ?? 99 E7 90 24 64 00 39 1C 05 23 38 19 74 31 FB 61 ?? ?? ?? ?? 8F E7 83 68 5A 1E 82 60 00 2B 9D DC 82 22 52 00 B9 18 ?? ?? ?? ?? 97 E7 83 68 5A 1E 82 60 00 2B 9F DC 80 22 52 00 B9 18 ?? ?? ?? ?? 99 E7 83 68 5A 1E 82 60 00 2B 00 DD 73 E7 14 3C 39 19 ?? ?? ?? ?? 6E E7 2A 49 7F 18 3A 6A FB 69 7A 61 01 2B 16 D0 02 2B 61 D0 03 2B 12 D0 04 2B 10 D0 05 2B 54 D0 06 2B 46 D0 07 2B 23 D0 08 2B 1B D0 09 2B 0D D0 00 23 FB 61 8C 23 5B 00 F8 18 ?? ?? ?? ?? 90 21 49 00 00 23 78 18 FB 61 ?? ?? ?? ?? 38 1C 00 23 4C 30 FB 61 ?? ?? ?? ?? 01 23 5B 42 78 69 FB 61 ?? ?? ?? ?? 94 21 49 00 78 18 ?? ?? ?? ?? ED E7 00 23 FB 61 90 23 5B 00 F8 18 ?? ?? ?? ?? E5 E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2F 01 00 00 ?? ?? ?? ?? D0 FE FF FF 38 1C 50 30 ?? ?? ?? ?? 3B 69 7C 68 FB 64 BA 68 23 68 4C 21 C9 19 CA 50 38 1C 00 23 78 30 FB 61 ?? ?? ?? ?? BF E7 88 21 49 00 00 23 78 18 FB 61 ?? ?? ?? ?? AA E7 }
	condition:
		$1
}

rule file_40_7_2 {
	meta:
		name = "_ZNSt12ctype_bynameIcEC1EPKcm"
		size = 188
		refs = "002a _Unwind_SjLj_Register 003c _ZNSt5ctypeIcEC2EPKcbm 004a strcmp 0062 _Unwind_SjLj_Unregister 0078 _ZNSt6locale5facet19_S_destroy_c_localeERPi 0082 _ZNSt6locale5facet18_S_create_c_localeERPiPKcS1_ 0094 _ZNSt5ctypeIcED2Ev 00a0 _Unwind_SjLj_Resume 00a4 __gxx_personality_sj0 00b0 _ZTVSt12ctype_bynameIcE"
		altNames = "_ZNSt12ctype_bynameIcEC2EPKcm"
	strings:
		$1 = { 80 B5 90 B0 27 4B 00 AF 7B 62 3A 60 26 4B 40 22 D2 19 BB 62 FA 62 3B 1C 24 4A 2C 33 5A 60 B8 60 6A 46 38 1C 9A 60 0C 30 79 60 ?? ?? ?? ?? 01 23 5B 42 3B 61 B8 68 00 21 00 22 3B 68 ?? ?? ?? ?? 1B 4B BA 68 78 68 13 60 1A 49 ?? ?? ?? ?? 00 28 05 D0 78 68 18 49 ?? ?? ?? ?? 00 28 06 D1 38 1C 0C 30 ?? ?? ?? ?? BD 46 10 B0 80 BD BB 68 08 33 3B 60 38 68 01 23 3B 61 ?? ?? ?? ?? 38 68 79 68 00 22 ?? ?? ?? ?? EA E7 40 3F 7A 69 00 23 B8 68 3B 61 7A 60 ?? ?? ?? ?? 01 23 5B 42 78 68 3B 61 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_41_0_2 {
	meta:
		name = "_ZN9__gnu_cxx27__verbose_terminate_handlerEv"
		size = 402
		refs = "0024 _Unwind_SjLj_Register 0042 fwrite 0046 abort 0054 __cxa_current_exception_type 006c __cxa_demangle 0090 fputs 00b4 __cxa_rethrow 00ea free 0106 __cxa_end_catch 0112 _Unwind_SjLj_Resume 011c __cxa_begin_catch 0162 fputc 0168 __gxx_personality_sj0 0178 _impure_ptr"
	strings:
		$1 = { 80 B5 91 B0 58 4B 00 AF 7B 62 44 22 57 4B D2 19 BB 62 FA 62 3B 1C 56 4A 2C 33 5A 60 38 1C 6A 46 9A 60 0C 30 ?? ?? ?? ?? 52 4B 1A 78 00 2A 0C D0 51 4B 01 22 1B 68 52 42 DB 68 01 21 3A 61 4F 48 1D 22 ?? ?? ?? ?? ?? ?? ?? ?? 01 22 1A 70 52 42 BA 60 3A 61 ?? ?? ?? ?? 00 28 36 D0 BB 68 40 68 3B 64 3B 1C 00 21 00 22 40 33 78 60 ?? ?? ?? ?? 41 4A 13 68 38 60 DB 68 41 48 01 21 30 22 ?? ?? ?? ?? 3B 6C 00 2B 17 D1 3B 4A 13 68 38 68 D9 68 ?? ?? ?? ?? 38 4B 01 22 1B 68 52 42 DB 68 39 48 3A 61 01 21 02 22 ?? ?? ?? ?? 3B 6C 00 2B 1B D0 02 23 3B 61 ?? ?? ?? ?? 2F 4A 13 68 D9 68 BB 68 78 68 3B 61 ?? ?? ?? ?? E4 E7 2B 4B BA 68 1B 68 2D 48 DB 68 01 21 3A 61 2D 22 ?? ?? ?? ?? 01 23 5B 42 3B 61 ?? ?? ?? ?? 38 68 ?? ?? ?? ?? DF E7 44 3F 3B 69 7A 69 7B 60 BA 60 7A 68 BB 69 01 2A 09 D0 00 23 3B 61 ?? ?? ?? ?? 01 23 5B 42 B8 68 3B 61 ?? ?? ?? ?? 02 2B 07 D0 B8 68 ?? ?? ?? ?? 00 23 3B 61 ?? ?? ?? ?? D9 E7 B8 68 ?? ?? ?? ?? 7A 68 03 68 9B 68 3A 61 00 F0 2A F8 0E 4B 1B 68 B8 60 DB 68 11 48 01 21 0B 22 ?? ?? ?? ?? 0A 4B 1B 68 B8 68 D9 68 ?? ?? ?? ?? 07 4B 1B 68 0A 20 D9 68 ?? ?? ?? ?? DB E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 18 47 }
	condition:
		$1
}

rule file_42_1_2 {
	meta:
		name = "_ZNSt8ios_base7failureC1ERKSs"
		size = 136
		refs = "0028 _Unwind_SjLj_Register 0038 _ZNSsC1ERKSs 0040 _Unwind_SjLj_Unregister 0056 _ZNSt9exceptionD2Ev 0068 _Unwind_SjLj_Resume 0072 __cxa_call_unexpected 0078 __gxx_personality_sj0 0084 _ZTVNSt8ios_base7failureE"
		altNames = "_ZNSt8ios_base7failureC2ERKSs"
	strings:
		$1 = { 80 B5 90 B0 1C 4B 00 AF 7B 62 40 22 1B 4B D2 19 BB 62 FA 62 3B 1C 1A 4A 2C 33 5A 60 78 60 6A 46 38 1C 9A 60 0C 30 B9 60 ?? ?? ?? ?? 15 4B 78 68 B9 68 08 C0 01 23 3B 61 ?? ?? ?? ?? 38 1C 0C 30 ?? ?? ?? ?? BD 46 10 B0 80 BD 40 3F 7B 69 BA 69 78 68 BB 60 3A 60 ?? ?? ?? ?? 3B 68 01 33 05 D0 01 23 5B 42 B8 68 3B 61 ?? ?? ?? ?? 3A 68 B8 68 3A 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_3_2 {
	meta:
		name = "_ZNSt8ios_base7failureD0Ev"
		size = 64
		refs = "0016 _ZNSt9exceptionD2Ev 001c _ZdlPv 0030 _ZNSs4_Rep10_M_destroyERKSaIcE 0038 _ZTVNSt8ios_base7failureE 003c _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 10 B5 0D 4B 04 1C 03 60 40 68 0C 4B 0C 38 81 B0 98 42 07 D1 20 1C ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 01 B0 10 BD 83 68 5A 1E 82 60 00 2B F2 DC 69 46 ?? ?? ?? ?? EE E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_38_2 {
	meta:
		name = "_ZNSt11logic_errorD0Ev"
		size = 64
		refs = "0016 _ZNSt9exceptionD2Ev 001c _ZdlPv 0030 _ZNSs4_Rep10_M_destroyERKSaIcE 0038 _ZTVSt11logic_error 003c _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 10 B5 0D 4B 04 1C 03 60 40 68 0C 4B 0C 38 81 B0 98 42 07 D1 20 1C ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 01 B0 10 BD 83 68 5A 1E 82 60 00 2B F2 DC 69 46 ?? ?? ?? ?? EE E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_29_2 {
	meta:
		name = "_ZNSt13runtime_errorD0Ev"
		size = 64
		refs = "0016 _ZNSt9exceptionD2Ev 001c _ZdlPv 0030 _ZNSs4_Rep10_M_destroyERKSaIcE 0038 _ZTVSt13runtime_error 003c _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 10 B5 0D 4B 04 1C 03 60 40 68 0C 4B 0C 38 81 B0 98 42 07 D1 20 1C ?? ?? ?? ?? 20 1C ?? ?? ?? ?? 01 B0 10 BD 83 68 5A 1E 82 60 00 2B F2 DC 69 46 ?? ?? ?? ?? EE E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_42_4_2 {
	meta:
		name = "_ZNSt8ios_base7failureD1Ev"
		size = 56
		refs = "0016 _ZNSt9exceptionD2Ev 002a _ZNSs4_Rep10_M_destroyERKSaIcE 0030 _ZTVNSt8ios_base7failureE 0034 _ZNSs4_Rep20_S_empty_rep_storageE"
		altNames = "_ZNSt8ios_base7failureD2Ev"
	strings:
		$1 = { 10 B5 0B 4B 04 1C 03 60 40 68 0A 4B 0C 38 81 B0 98 42 04 D1 20 1C ?? ?? ?? ?? 01 B0 10 BD 83 68 5A 1E 82 60 00 2B F5 DC 69 46 ?? ?? ?? ?? F1 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_39_2 {
	meta:
		name = "_ZNSt11logic_errorD1Ev"
		size = 56
		refs = "0016 _ZNSt9exceptionD2Ev 002a _ZNSs4_Rep10_M_destroyERKSaIcE 0030 _ZTVSt11logic_error 0034 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 10 B5 0B 4B 04 1C 03 60 40 68 0A 4B 0C 38 81 B0 98 42 04 D1 20 1C ?? ?? ?? ?? 01 B0 10 BD 83 68 5A 1E 82 60 00 2B F5 DC 69 46 ?? ?? ?? ?? F1 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_2_2 {
	meta:
		name = "_ZNSt11logic_errorD2Ev"
		size = 56
		refs = "0016 _ZNSt9exceptionD2Ev 002a _ZNSs4_Rep10_M_destroyERKSaIcE 0030 _ZTVSt11logic_error 0034 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 10 B5 0B 4B 04 1C 03 60 40 68 0A 4B 0C 38 81 B0 98 42 04 D1 20 1C ?? ?? ?? ?? 01 B0 10 BD 83 68 5A 1E 82 60 00 2B F5 DC 69 46 ?? ?? ?? ?? F1 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_30_2 {
	meta:
		name = "_ZNSt13runtime_errorD1Ev"
		size = 56
		refs = "0016 _ZNSt9exceptionD2Ev 002a _ZNSs4_Rep10_M_destroyERKSaIcE 0030 _ZTVSt13runtime_error 0034 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 10 B5 0B 4B 04 1C 03 60 40 68 0A 4B 0C 38 81 B0 98 42 04 D1 20 1C ?? ?? ?? ?? 01 B0 10 BD 83 68 5A 1E 82 60 00 2B F5 DC 69 46 ?? ?? ?? ?? F1 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_82_31_2 {
	meta:
		name = "_ZNSt13runtime_errorD2Ev"
		size = 56
		refs = "0016 _ZNSt9exceptionD2Ev 002a _ZNSs4_Rep10_M_destroyERKSaIcE 0030 _ZTVSt13runtime_error 0034 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 10 B5 0B 4B 04 1C 03 60 40 68 0A 4B 0C 38 81 B0 98 42 04 D1 20 1C ?? ?? ?? ?? 01 B0 10 BD 83 68 5A 1E 82 60 00 2B F5 DC 69 46 ?? ?? ?? ?? F1 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_45_0_2 {
	meta:
		name = "_ZL16get_adjusted_ptrPKSt9type_infoS1_PPv"
		size = 68
	strings:
		$1 = { F0 B5 13 68 81 B0 00 93 0B 68 05 1C 9B 68 08 1C 0C 1C 16 1C 00 F0 14 F8 00 28 02 D0 00 9B 1B 68 00 93 2B 68 28 1C 1F 69 21 1C 6A 46 01 23 00 F0 08 F8 00 28 02 D0 00 9B 33 60 01 20 01 B0 F0 BD 18 47 38 47 }
	condition:
		$1
}

rule file_45_1_2 {
	meta:
		name = "_ZL21base_of_encoded_valuehP15_Unwind_Context"
		size = 76
		refs = "0022 abort 0036 _Unwind_GetRegionStart 003e _Unwind_GetTextRelBase 0046 _Unwind_GetDataRelBase"
	strings:
		$1 = { 00 B5 03 06 1B 0E FF 2B 0F D0 70 22 13 40 20 2B 14 D0 20 2B 07 DD 40 2B 0C D0 50 2B 05 D0 30 2B 10 D0 ?? ?? ?? ?? 00 2B 01 D1 00 20 00 BD 10 2B F7 D1 FA E7 08 1C ?? ?? ?? ?? F7 E7 08 1C ?? ?? ?? ?? F3 E7 08 1C ?? ?? ?? ?? EF E7 }
	condition:
		$1
}

rule file_45_2_2 {
	meta:
		name = "_ZL28read_encoded_value_with_basehjPKhPj"
		size = 236
		refs = "0018 abort"
	strings:
		$1 = { F0 B5 47 46 80 B4 00 06 00 0E 50 28 65 D0 0F 24 04 40 94 46 0C 2C 01 D9 ?? ?? ?? ?? 32 4D A4 00 2C 59 A7 46 54 78 15 78 24 02 2C 43 95 78 2D 04 2C 43 D5 78 2D 06 2C 43 04 32 00 2C 08 D0 70 25 05 40 10 2D 4E D0 00 06 64 18 00 28 00 DA 24 68 10 1C 1C 60 04 BC 90 46 F0 BD 54 78 15 78 24 02 2C 43 95 78 2D 04 2C 43 D5 78 2D 06 2C 43 08 32 E3 E7 7F 27 00 24 00 25 B8 46 16 78 47 46 37 40 AF 40 3C 43 37 06 01 32 07 35 00 2F F5 DB 1F 2D D3 D8 77 06 D1 D5 01 26 AE 40 75 42 2C 43 CC E7 7F 26 00 24 00 25 B0 46 16 78 47 46 37 40 AF 40 36 06 01 32 3C 43 07 35 00 2E F5 DB BD E7 54 78 15 78 24 02 2C 43 24 04 24 14 02 32 B5 E7 54 78 15 78 24 02 2C 43 02 32 AF E7 03 32 03 21 8A 43 10 CA B5 E7 61 46 AE E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_45_3_2 {
	meta:
		name = "_ZL17parse_lsda_headerP15_Unwind_ContextPKhP16lsda_header_info"
		size = 148
		refs = "000c _Unwind_GetRegionStart 001e _ZL21base_of_encoded_valuehP15_Unwind_Context 002a _ZL28read_encoded_value_with_basehjPKhPj"
	strings:
		$1 = { F0 B5 06 1C 0D 1C 14 1C 00 28 41 D0 ?? ?? ?? ?? 20 60 2F 78 01 35 FF 2F 31 D0 31 1C 38 1C ?? ?? ?? ?? 23 1D 01 1C 2A 1C 38 1C ?? ?? ?? ?? 05 1C 2B 78 01 35 23 75 FF 2B 27 D0 00 21 00 23 7F 26 2A 78 10 1C 30 40 98 40 12 06 01 35 01 43 07 33 00 2A F5 DB 69 18 E1 60 2B 78 68 1C 63 75 00 21 00 23 7F 26 02 78 15 1C 35 40 9D 40 12 06 01 30 29 43 07 33 00 2A F5 DB 41 18 21 61 F0 BD 60 60 2B 78 01 35 23 75 FF 2B D7 D1 00 23 E3 60 E3 E7 00 20 BD E7 }
	condition:
		$1
}

rule file_45_4_2 {
	meta:
		name = "_ZL15get_ttype_entryP16lsda_header_infom"
		size = 78
		refs = "001e abort 0034 _ZL28read_encoded_value_with_basehjPKhPj"
	strings:
		$1 = { 10 B5 03 7D 81 B0 FF 2B 1F D0 07 24 1C 40 02 2C 18 D0 02 2C 05 DD 03 2C 05 D0 04 2C 0F D0 ?? ?? ?? ?? 00 2C FB D1 8A 00 52 42 81 68 C0 68 82 18 18 1C 6B 46 ?? ?? ?? ?? 00 98 01 B0 10 BD CA 00 52 42 F2 E7 4A 00 52 42 EF E7 00 22 ED E7 }
	condition:
		$1
}

rule file_45_5_2 {
	meta:
		name = "_ZL20check_exception_specP16lsda_header_infoPKSt9type_infoPvl"
		size = 90
		refs = "0032 _ZL15get_ttype_entryP16lsda_header_infom 003a _ZL16get_adjusted_ptrPKSt9type_infoS1_PPv"
	strings:
		$1 = { F0 B5 47 46 80 B4 C4 68 81 B0 DB 43 0F 1C 00 92 06 1C E4 18 00 21 00 22 7F 25 23 78 18 1C 28 40 90 40 1B 06 01 34 01 43 00 2B 0D DB 00 29 0D D0 30 1C ?? ?? ?? ?? 39 1C 6A 46 ?? ?? ?? ?? 00 28 09 D1 00 21 00 22 E8 E7 07 32 E6 E7 00 20 01 B0 04 BC 90 46 F0 BD 01 20 F9 E7 }
	condition:
		$1
}

rule file_45_6_2 {
	meta:
		name = "__cxa_call_unexpected"
		size = 268
		refs = "0026 _Unwind_SjLj_Register 002c __cxa_begin_catch 004a _ZN10__cxxabiv112__unexpectedEPFvvE 0060 __cxa_end_catch 0074 _Unwind_SjLj_Resume 007e __cxa_get_globals_fast 009c _ZL17parse_lsda_headerP15_Unwind_ContextPKhP16lsda_header_info 00ae _ZL20check_exception_specP16lsda_header_infoPKSt9type_infoPvl 00b6 __cxa_rethrow 00d8 __cxa_allocate_exception 00e4 __cxa_throw 00ee _ZN10__cxxabiv111__terminateEPFvvE 00f4 __gxx_personality_sj0 0100 _ZTISt13bad_exception 0104 _ZTVSt13bad_exception 0108 _ZNSt13bad_exceptionD1Ev"
	strings:
		$1 = { 80 B5 98 B0 3B 4B 00 AF FB 62 3B 4B 3B 4A 3B 63 60 21 3B 1C 34 33 C9 19 79 63 38 61 5A 60 38 1C 6A 46 9A 60 14 30 ?? ?? ?? ?? 38 69 ?? ?? ?? ?? 3B 69 2C 3B 9A 69 19 6A 3A 61 B9 60 5A 6A D9 68 98 68 02 23 F9 60 3A 65 BB 61 ?? ?? ?? ?? 60 3F BA 69 FB 69 3A 60 7B 60 01 2A 0D D0 00 21 B9 61 ?? ?? ?? ?? 00 22 BA 61 ?? ?? ?? ?? 01 23 5B 42 78 68 BB 61 ?? ?? ?? ?? 78 68 ?? ?? ?? ?? ?? ?? ?? ?? 03 68 39 68 DA 6A 0A 42 16 D0 5B 68 7B 60 3A 1C 01 23 00 20 B9 68 48 32 BB 61 ?? ?? ?? ?? 7B 68 38 1C 40 3B 19 68 48 30 7A 68 3B 69 ?? ?? ?? ?? 00 28 04 D0 ?? ?? ?? ?? 40 33 7B 60 E7 E7 01 23 38 1C BB 61 48 30 0D 49 00 22 3B 69 ?? ?? ?? ?? 00 28 08 D0 04 20 ?? ?? ?? ?? 09 4B 08 49 03 60 09 4A ?? ?? ?? ?? 01 23 F8 68 BB 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_45_7_2 {
	meta:
		name = "__gxx_personality_sj0"
		size = 1008
		refs = "002e _Unwind_SjLj_Register 0040 _Unwind_SjLj_Unregister 008c _Unwind_GetLanguageSpecificData 00a0 _ZL17parse_lsda_headerP15_Unwind_ContextPKhP16lsda_header_info 00ac _ZL21base_of_encoded_valuehP15_Unwind_Context 00ba _Unwind_GetIPInfo 0102 _Unwind_SetGR 011a _Unwind_SetIP 014e __cxa_call_terminate 027c _ZL15get_ttype_entryP16lsda_header_infom 0290 _ZL16get_adjusted_ptrPKSt9type_infoS1_PPv 0314 __gxx_personality_sj0 0328 _ZTIN10__cxxabiv115__forced_unwindE 033c _ZL20check_exception_specP16lsda_header_infoPKSt9type_infoPvl 03ae _ZSt9terminatev 03b6 _ZSt10unexpectedv 03cc __cxa_end_catch 03d8 _Unwind_SjLj_Resume 03de __cxa_begin_catch 03ec _ZTIN10__cxxabiv119__foreign_exceptionE"
	strings:
		$1 = { F0 B5 47 46 80 B4 A3 B0 00 AF FA 62 3B 63 C1 4B 3B 65 C1 4B C1 4A 7B 65 78 63 3B 1C 8C 20 58 33 C0 19 B8 65 5A 60 6A 46 9A 60 54 38 39 62 ?? ?? ?? ?? 7B 6B 01 2B 0B D0 03 24 7C 63 38 1C 38 30 ?? ?? ?? ?? BD 46 23 B0 78 6B 04 BC 90 46 F0 BD 00 23 88 25 84 20 EB 51 C3 51 A4 23 DA 59 2C 3A BA 61 FC 6A 3D 6B AE 49 AE 4A 09 19 6A 41 00 23 00 2A 56 D0 01 23 1B 06 3D 6A 1B 0E 7B 61 06 2D 52 D0 01 23 5B 42 FB 63 A8 24 E0 59 ?? ?? ?? ?? F8 61 00 28 66 D0 E5 19 3A 1C 28 68 F9 69 6C 32 ?? ?? ?? ?? 78 63 80 22 29 68 D0 5D ?? ?? ?? ?? 39 1C 78 67 84 31 28 68 84 25 ?? ?? ?? ?? EB 59 00 2B 00 D1 01 38 00 28 4C DB 00 28 4D D1 F8 62 38 61 B8 62 01 23 3C 6A E4 07 3A D4 3D 6A 2D 07 00 D4 F9 E0 01 2B 00 D1 5F E1 FA 6A 00 2A 00 DA 5F E1 01 23 5B 42 FB 63 A8 24 A4 25 E0 59 00 21 EA 59 ?? ?? ?? ?? E2 19 10 68 01 21 FA 6A ?? ?? ?? ?? E3 19 18 68 39 69 07 24 ?? ?? ?? ?? 7C 63 8C E7 01 29 A7 D9 A5 E7 00 2B AA D1 B8 69 BA 69 BB 69 80 69 12 6A 5B 6A F8 62 FA 61 3B 61 00 2B 00 D0 8D E0 01 23 5B 42 FB 63 A4 22 D0 59 ?? ?? ?? ?? 02 2B 06 D0 7D 69 00 2D 00 D1 FD E0 06 20 78 63 6B E7 08 25 7D 63 68 E7 00 22 7B 6B 94 46 7F 25 80 46 64 46 62 46 19 78 08 1C 28 40 90 40 09 06 01 33 04 43 07 32 00 29 F5 DB 61 46 62 46 18 78 06 1C 2E 40 96 40 00 06 01 33 31 43 07 32 00 28 F5 DB 01 20 40 42 80 44 42 46 00 2A E1 D1 01 34 3C 61 00 29 55 D1 00 23 BB 62 3C 69 00 2C D0 D0 BD 6A 00 2D 00 D1 C3 E0 38 6A 08 23 18 40 38 60 00 D1 D1 E0 54 4A FA 60 01 22 00 20 52 42 B8 60 7A 60 BB 6A 00 21 00 22 18 78 7F 24 04 40 94 40 21 43 04 06 01 33 07 32 00 2C F5 DB 7B 62 1F 2A 06 D8 40 24 20 42 03 D0 01 25 95 40 6A 42 11 43 00 20 F9 62 78 63 00 22 00 24 18 78 7F 25 05 40 95 40 2C 43 05 06 01 33 07 32 00 2D F5 DB 7C 63 1F 2A 08 D8 40 23 18 42 05 D0 01 24 7D 6B 94 40 62 42 15 43 7D 63 F8 6A 00 28 0F D1 01 22 BA 60 78 6B 00 28 78 D0 7A 6A 12 18 BA 62 C1 E7 03 23 3B E7 FB 6F 01 39 5B 18 BB 62 A6 E7 FB 6A 00 2B 13 DD 7C 68 38 1C 6C 30 FC 63 ?? ?? ?? ?? 00 28 09 D0 FD 68 00 2D E3 D0 3A 1C 29 1C 88 32 ?? ?? ?? ?? 00 28 DC D0 03 23 1C E7 F8 68 00 28 05 D0 3A 68 00 2A 02 D1 7B 69 00 2B 3E D0 BB 6F C9 43 59 18 00 20 00 23 0A 78 7F 24 14 40 9C 40 12 06 01 31 20 43 07 33 00 2A F5 DB 43 42 43 41 00 2B BE D0 03 23 FE E6 78 69 00 28 00 D0 01 E7 01 2B 00 D1 2E E7 FB 6A 00 2B 00 DB 01 E7 01 23 5B 42 FB 63 A8 24 3A 1C F9 69 6C 32 E0 59 ?? ?? ?? ?? 80 25 E2 19 E8 5D 11 68 ?? ?? ?? ?? BB 69 58 62 EE E6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 D5 D4 BC BC AA B1 B8 ?? ?? ?? ?? 7C 68 38 1C FC 63 88 25 FB 6A 6C 30 F9 68 EA 59 ?? ?? ?? ?? 01 23 43 40 1B 06 1B 0E C2 E7 B8 68 00 28 00 D1 08 E7 00 23 FB 62 02 23 BD E6 BB 69 FA 6A BC 6A FD 69 88 20 9A 61 DC 61 BA 69 1D 62 C3 59 93 62 3B 69 06 24 53 62 7C 63 60 E6 7B 69 00 2B 02 D0 1A 4C FC 60 29 E7 A4 25 ED 59 2B 68 D8 07 08 D5 2B 1C 28 3B 1B 68 88 25 EB 51 40 3B 1B 68 FB 60 1B E7 A4 24 E3 59 14 33 F5 E7 5B 42 FB 63 ?? ?? ?? ?? 02 23 FB 63 ?? ?? ?? ?? 8C 3F FC 6B 3D 6C FC 62 7D 63 01 2C 09 D0 00 23 FB 63 ?? ?? ?? ?? 01 23 5B 42 78 6B FB 63 ?? ?? ?? ?? 78 6B ?? ?? ?? ?? FB 6A FB 63 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_0_2 {
	meta:
		name = "_ZNSt12strstreambuf6freezeEb"
		size = 36
	strings:
		$1 = { 10 B5 28 23 C2 5C D4 07 E4 0F 09 06 24 06 09 0E 00 2C 06 D0 01 24 21 40 02 24 49 00 A2 43 0A 43 C2 54 10 BD }
	condition:
		$1
}

rule file_46_1_2 {
	meta:
		name = "_ZNSt12strstreambuf3strEv"
		size = 24
	strings:
		$1 = { 28 23 C2 5C D1 07 C9 0F 09 06 00 29 02 D0 02 21 0A 43 C2 54 40 68 70 47 }
	condition:
		$1
}

rule file_46_2_2 {
	meta:
		name = "_ZNKSt12strstreambuf6pcountEv"
		size = 16
	strings:
		$1 = { 43 69 00 2B 02 D0 00 69 18 1A 70 47 00 20 FC E7 }
	condition:
		$1
}

rule file_46_3_2 {
	meta:
		name = "_ZNSt12strstreambuf9pbackfailEi"
		size = 58
	strings:
		$1 = { 10 B5 03 1C 82 68 40 68 82 42 10 D0 48 1C 06 D0 01 3A 10 78 81 42 06 D1 9A 60 08 1C 10 BD 01 3A 9A 60 00 21 F9 E7 28 20 18 5C 44 07 02 D5 01 21 49 42 F2 E7 9A 60 11 70 EF E7 }
	condition:
		$1
}

rule file_46_4_2 {
	meta:
		name = "_ZNSt12strstreambuf9underflowEv"
		size = 32
	strings:
		$1 = { 83 68 C2 68 93 42 01 D0 18 78 70 47 42 69 00 2A 03 D0 93 42 01 D2 C2 60 F6 E7 01 20 40 42 F4 E7 }
	condition:
		$1
}

rule file_46_6_2 {
	meta:
		name = "_ZNSt12strstreambuf7seekoffExSt12_Ios_SeekdirSt13_Ios_Openmode"
		size = 344
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 84 B0 02 92 03 93 0C 9B 18 25 1D 40 0B 9C 18 2D 5D D0 1D 07 4B D5 01 26 00 27 B0 46 8B 68 00 2B 47 D0 4A 68 8E 69 92 46 00 2E 00 D1 6D E0 B4 46 01 2C 61 D0 02 2C 58 D0 00 2C 3A D1 00 24 00 25 00 94 01 95 00 9A 01 9B 02 9C 03 9D 12 19 6B 41 00 2B 2E DB 65 46 54 46 2D 1B EC 17 AC 46 A3 42 27 DC A3 42 00 D1 6F E0 00 2F 07 D0 55 46 0C 69 AF 18 BC 42 62 D9 0D 61 8E 61 4F 61 44 46 00 2C 0C D0 CC 68 55 46 67 1B FE 17 B3 42 45 DC B3 42 41 D0 56 46 B5 18 4E 60 8D 60 CC 60 00 9A 01 9B 02 60 43 60 00 23 00 24 83 60 C4 60 0A E0 DD 06 18 D4 01 23 5B 42 DC 17 03 60 44 60 00 23 00 24 83 60 C4 60 04 B0 0C BC 90 46 9A 46 F0 BD 02 2C 01 D0 00 2C 9D D1 01 22 90 46 4B 69 00 2B E8 D0 01 27 9B E7 00 26 B0 46 F7 E7 63 46 54 46 1D 1B 00 95 ED 17 01 95 A5 E7 00 2F 09 D0 4B 69 54 46 1A 1B 00 92 D2 17 01 92 9C E7 CA 68 94 46 8F E7 55 46 5A 1B F5 E7 BA 42 BB D9 4C 69 55 46 67 1B FE 17 B3 42 03 DC B3 42 B3 D1 BA 42 B1 D9 55 46 8C 69 4D 60 AD 18 8D 60 CC 60 AF E7 8E 61 56 46 0C 61 B4 18 4C 61 99 E7 62 45 00 D8 8C E7 B0 E7 }
	condition:
		$1
}

rule file_46_7_2 {
	meta:
		name = "_ZNSt12strstreambuf7seekposESt4fposI10_mbstate_tESt13_Ios_Openmode"
		size = 46
		altNames = "_ZN9__gnu_cxx18stdio_sync_filebufIcSt11char_traitsIcEE7seekposESt4fposI10_mbstate_tESt13_Ios_Openmode"
	strings:
		$1 = { 82 B0 30 B5 82 B0 05 92 00 22 00 92 09 9A 06 93 01 92 0B 68 1D 69 05 9A 06 9B 04 1C 00 F0 06 F8 02 B0 20 1C 30 BC 08 BC 02 B0 18 47 28 47 }
	condition:
		$1
}

rule file_46_9_2 {
	meta:
		name = "_ZNSt10istrstream3strEv"
		size = 24
	strings:
		$1 = { 30 23 C2 5C D1 07 C9 0F 09 06 00 29 02 D0 02 21 0A 43 C2 54 C0 68 70 47 }
	condition:
		$1
}

rule file_46_11_2 {
	meta:
		name = "_ZNSt10ostrstream6freezeEb"
		size = 36
	strings:
		$1 = { 10 B5 2C 23 C2 5C D4 07 E4 0F 09 06 24 06 09 0E 00 2C 06 D0 01 24 21 40 02 24 49 00 A2 43 0A 43 C2 54 10 BD }
	condition:
		$1
}

rule file_46_12_2 {
	meta:
		name = "_ZNSt10ostrstream3strEv"
		size = 24
	strings:
		$1 = { 2C 23 C2 5C D1 07 C9 0F 09 06 00 29 02 D0 02 21 0A 43 C2 54 80 68 70 47 }
	condition:
		$1
}

rule file_46_13_2 {
	meta:
		name = "_ZNKSt10ostrstream6pcountEv"
		size = 16
	strings:
		$1 = { 83 69 00 2B 02 D0 40 69 18 1A 70 47 00 20 FC E7 }
	condition:
		$1
}

rule file_46_15_2 {
	meta:
		name = "_ZNSt9strstream6freezeEb"
		size = 36
	strings:
		$1 = { 10 B5 34 23 C2 5C D4 07 E4 0F 09 06 24 06 09 0E 00 2C 06 D0 01 24 21 40 02 24 49 00 A2 43 0A 43 C2 54 10 BD }
	condition:
		$1
}

rule file_46_16_2 {
	meta:
		name = "_ZNKSt9strstream6pcountEv"
		size = 16
	strings:
		$1 = { 03 6A 00 2B 02 D0 C0 69 18 1A 70 47 00 20 FC E7 }
	condition:
		$1
}

rule file_46_17_2 {
	meta:
		name = "_ZNSt9strstream3strEv"
		size = 24
	strings:
		$1 = { 34 23 C2 5C D1 07 C9 0F 09 06 00 29 02 D0 02 21 0A 43 C2 54 00 69 70 47 }
	condition:
		$1
}

rule file_46_18_2 {
	meta:
		name = "_ZNSt12strstreambuf8_M_setupEPcS0_l"
		size = 72
		refs = "002a strlen"
	strings:
		$1 = { 70 B5 04 1C 0E 1C 15 1C 00 29 0A D0 00 2B 09 DD 00 2D 0F D0 EB 18 66 60 A6 60 E5 60 65 61 25 61 A3 61 70 BD 00 2B 0A D1 08 1C ?? ?? ?? ?? 03 1C 00 2D EF D1 F3 18 66 60 A6 60 E3 60 F1 E7 01 4B E6 E7 C0 46 FF FF FF 7F }
	condition:
		$1
}

rule file_46_19_2 {
	meta:
		name = "_ZNSt12strstreambuf7_M_freeEPc"
		size = 30
		refs = "0016 _ZdaPv"
	strings:
		$1 = { 00 B5 00 29 05 D0 43 6A 00 2B 03 D0 08 1C 00 F0 05 F8 00 BD 08 1C ?? ?? ?? ?? FA E7 18 47 }
	condition:
		$1
}

rule file_46_20_2 {
	meta:
		name = "_ZNSt12strstreambuf8_M_allocEm"
		size = 26
		refs = "0012 _Znam"
	strings:
		$1 = { 00 B5 03 6A 00 2B 03 D0 08 1C 00 F0 05 F8 00 BD 08 1C ?? ?? ?? ?? FA E7 18 47 }
	condition:
		$1
}

rule file_46_21_2 {
	meta:
		name = "_ZNSt12strstreambuf8overflowEi"
		size = 178
		refs = "0052 _ZNSt12strstreambuf8_M_allocEm 0060 memcpy 008e _ZNSt12strstreambuf7_M_freeEPc"
	strings:
		$1 = { F0 B5 47 46 80 B4 05 1C 0C 1C 48 1C 04 D1 00 24 20 1C 04 BC 90 46 F0 BD 6B 69 AA 69 93 42 04 D0 1C 70 6B 69 01 33 6B 61 F2 E7 28 22 AA 5C D1 07 C9 0F 09 06 00 29 30 D0 91 07 2E D4 50 07 2C D4 2F 69 DF 1B 7B 00 00 2B 31 DC 01 21 88 46 28 1C 41 46 ?? ?? ?? ?? 06 1C 00 28 1A D0 29 69 3A 1C ?? ?? ?? ?? AB 68 29 69 00 2B 19 D0 6A 68 40 46 9B 1A 32 18 AA 61 F2 19 6A 61 F2 18 2E 61 6E 60 AA 60 BB 42 00 DA 3B 1C F3 18 EB 60 28 1C ?? ?? ?? ?? 6B 69 AA 69 93 42 C2 D1 01 24 64 42 B7 E7 42 46 B3 18 2E 61 F6 19 AB 61 6E 61 EE E7 98 46 CD E7 }
	condition:
		$1
}

rule file_46_22_2 {
	meta:
		name = "_ZNSt12strstreambufC1EPKcl"
		size = 88
		refs = "001c _ZNSt6localeC1Ev 004a _ZNSt12strstreambuf8_M_setupEPcS0_l 0050 _ZTVSt15basic_streambufIcSt11char_traitsIcEE 0054 _ZTVSt12strstreambuf"
		altNames = "_ZNSt12strstreambufC1EPKal _ZNSt12strstreambufC1EPKhl _ZNSt12strstreambufC2EPKal _ZNSt12strstreambufC2EPKcl _ZNSt12strstreambufC2EPKhl"
	strings:
		$1 = { F0 B5 13 4B 00 25 04 1C 45 60 85 60 C5 60 05 61 45 61 85 61 03 60 1C 30 0E 1C 17 1C ?? ?? ?? ?? 0C 4B 25 62 23 60 65 62 28 23 E2 5C 01 21 8A 43 E2 54 E2 5C 02 21 8A 43 E2 54 E1 5C 04 22 0A 43 E2 54 31 1C 3B 1C 20 1C 00 22 ?? ?? ?? ?? F0 BD ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_23_2 {
	meta:
		name = "_ZNSt12strstreambufD2Ev"
		size = 160
		refs = "0026 _Unwind_SjLj_Register 004c _ZNSt6localeD1Ev 0054 _Unwind_SjLj_Unregister 0068 _ZNSt12strstreambuf7_M_freeEPc 007a _ZNSt15basic_streambufIcSt11char_traitsIcEED2Ev 0086 _Unwind_SjLj_Resume 008c __gxx_personality_sj0 0098 _ZTVSt12strstreambuf 009c _ZTVSt15basic_streambufIcSt11char_traitsIcEE"
		altNames = "_ZNSt12strstreambufD1Ev"
	strings:
		$1 = { 80 B5 8F B0 21 4B 00 AF 3B 62 3C 22 20 4B D2 19 7B 62 BA 62 3B 1C 1F 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 ?? ?? ?? ?? 7A 68 1A 4B 13 60 28 23 D3 5C DA 07 D2 0F 12 06 00 2A 01 D0 9A 07 0D D5 7A 68 15 4B 10 1C 13 60 1C 30 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 7B 68 78 68 59 68 01 23 FB 60 ?? ?? ?? ?? E9 E7 3C 3F 3A 69 00 23 78 68 FB 60 3A 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_24_2 {
	meta:
		name = "_ZNSt12strstreambufD0Ev"
		size = 164
		refs = "0026 _Unwind_SjLj_Register 004c _ZNSt6localeD1Ev 0052 _ZdlPv 005a _Unwind_SjLj_Unregister 006e _ZNSt12strstreambuf7_M_freeEPc 0080 _ZNSt15basic_streambufIcSt11char_traitsIcEED2Ev 008c _Unwind_SjLj_Resume 0090 __gxx_personality_sj0 009c _ZTVSt12strstreambuf 00a0 _ZTVSt15basic_streambufIcSt11char_traitsIcEE"
	strings:
		$1 = { 80 B5 8F B0 22 4B 00 AF 3B 62 3C 22 21 4B D2 19 7B 62 BA 62 3B 1C 20 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 ?? ?? ?? ?? 7A 68 1B 4B 13 60 28 23 D3 5C DA 07 D2 0F 12 06 00 2A 01 D0 9A 07 10 D5 7A 68 16 4B 10 1C 13 60 1C 30 ?? ?? ?? ?? 78 68 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 7B 68 78 68 59 68 01 23 FB 60 ?? ?? ?? ?? E6 E7 3C 3F 3A 69 00 23 78 68 FB 60 3A 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_26_2 {
	meta:
		name = "_ZNSt10ostrstreamD2Ev"
		size = 152
		refs = "0028 _Unwind_SjLj_Register 0046 _ZNSt12strstreambufD1Ev 0060 _Unwind_SjLj_Unregister 0086 _Unwind_SjLj_Resume 008c __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 8F B0 21 4B 00 AF 3B 62 21 4B 21 4A 7B 62 39 60 3B 1C 3C 21 28 33 C9 19 B9 62 78 60 5A 60 38 1C 6A 46 9A 60 08 30 ?? ?? ?? ?? 39 68 7A 68 0B 68 13 60 CA 68 0C 3B 79 68 1B 68 08 1C CA 50 04 30 01 23 FB 60 ?? ?? ?? ?? 3A 68 79 68 53 68 0B 60 0C 3B 1B 68 92 68 79 68 38 1C CA 50 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 3A 68 79 68 53 68 38 69 0B 60 0C 3B 1B 68 92 68 79 68 CA 50 01 23 5B 42 FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_27_2 {
	meta:
		name = "_ZNSt10istrstreamD2Ev"
		size = 160
		refs = "0028 _Unwind_SjLj_Register 0046 _ZNSt12strstreambufD1Ev 0064 _Unwind_SjLj_Unregister 008e _Unwind_SjLj_Resume 0094 __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 8F B0 23 4B 00 AF 3B 62 23 4B 23 4A 7B 62 39 60 3B 1C 3C 21 28 33 C9 19 B9 62 78 60 5A 60 38 1C 6A 46 9A 60 08 30 ?? ?? ?? ?? 39 68 7A 68 0B 68 13 60 CA 68 0C 3B 79 68 1B 68 08 1C CA 50 08 30 01 23 FB 60 ?? ?? ?? ?? 3A 68 79 68 53 68 0B 60 0C 3B 1B 68 79 68 92 68 38 1C CA 50 00 23 4B 60 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 3A 68 79 68 53 68 38 69 0B 60 0C 3B 1B 68 92 68 79 68 CA 50 00 23 4B 60 01 23 5B 42 FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_28_2 {
	meta:
		name = ".LTHUNK0"
		size = 188
		refs = "0026 _Unwind_SjLj_Register 003c _ZNSt12strstreambufD1Ev 005e _ZNSt8ios_baseD2Ev 0064 _ZdlPv 006c _Unwind_SjLj_Unregister 0094 _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev 00a0 _Unwind_SjLj_Resume 00a4 __gxx_personality_sj0 00b0 _ZTVSt10ostrstream 00b4 _ZTTSt10ostrstream 00b8 _ZTVSt9basic_iosIcSt11char_traitsIcEE"
	strings:
		$1 = { 80 B5 8F B0 27 4B 00 AF 3B 62 27 4B 27 4A 7B 62 3C 21 3B 1C 28 33 C9 19 B9 62 78 60 5A 60 38 1C 6A 46 9A 60 08 30 ?? ?? ?? ?? 79 68 20 4B 08 1C 0B 60 14 33 0B 63 04 30 01 23 FB 60 ?? ?? ?? ?? 1C 4B 79 68 5A 68 0A 60 0C 3A 12 68 9B 68 8B 50 19 4B 08 1C 0B 63 01 23 5B 42 30 30 FB 60 ?? ?? ?? ?? 78 68 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 0E 4B 3A 69 79 68 3A 60 5A 68 0A 60 0C 3A 12 68 9B 68 08 1C 8B 50 30 30 00 23 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_29_2 {
	meta:
		name = ".LTHUNK1"
		size = 184
		refs = "0026 _Unwind_SjLj_Register 003c _ZNSt12strstreambufD1Ev 005e _ZNSt8ios_baseD2Ev 0066 _Unwind_SjLj_Unregister 008e _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev 009a _Unwind_SjLj_Resume 00a0 __gxx_personality_sj0 00ac _ZTVSt10ostrstream 00b0 _ZTTSt10ostrstream 00b4 _ZTVSt9basic_iosIcSt11char_traitsIcEE"
	strings:
		$1 = { 80 B5 8F B0 26 4B 00 AF 3B 62 26 4B 26 4A 7B 62 3C 21 3B 1C 28 33 C9 19 B9 62 78 60 5A 60 38 1C 6A 46 9A 60 08 30 ?? ?? ?? ?? 79 68 1F 4B 08 1C 0B 60 14 33 0B 63 04 30 01 23 FB 60 ?? ?? ?? ?? 1B 4B 79 68 5A 68 0A 60 0C 3A 12 68 9B 68 8B 50 18 4B 08 1C 0B 63 01 23 5B 42 30 30 FB 60 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 0F 4B 3A 69 79 68 3A 60 5A 68 0A 60 0C 3A 12 68 9B 68 08 1C 8B 50 30 30 00 23 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_30_2 {
	meta:
		name = ".LTHUNK2"
		size = 196
		refs = "0026 _Unwind_SjLj_Register 003c _ZNSt12strstreambufD1Ev 0062 _ZNSt8ios_baseD2Ev 0068 _ZdlPv 0070 _Unwind_SjLj_Unregister 009a _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev 00a6 _Unwind_SjLj_Resume 00ac __gxx_personality_sj0 00b8 _ZTVSt10istrstream 00bc _ZTTSt10istrstream 00c0 _ZTVSt9basic_iosIcSt11char_traitsIcEE"
	strings:
		$1 = { 80 B5 8F B0 29 4B 00 AF 3B 62 29 4B 29 4A 7B 62 3C 21 3B 1C 28 33 C9 19 B9 62 78 60 5A 60 38 1C 6A 46 9A 60 08 30 ?? ?? ?? ?? 79 68 22 4B 08 1C 0B 60 14 33 4B 63 08 30 01 23 FB 60 ?? ?? ?? ?? 1E 4B 79 68 5A 68 0A 60 0C 3A 12 68 9B 68 8B 50 00 23 4B 60 1A 4B 08 1C 4B 63 01 23 5B 42 34 30 FB 60 ?? ?? ?? ?? 78 68 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 0F 4B 3A 69 79 68 3A 60 5A 68 0A 60 0C 3A 12 68 9B 68 08 1C 8B 50 00 23 4B 60 34 30 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_31_2 {
	meta:
		name = ".LTHUNK3"
		size = 188
		refs = "0026 _Unwind_SjLj_Register 003c _ZNSt12strstreambufD1Ev 0062 _ZNSt8ios_baseD2Ev 006a _Unwind_SjLj_Unregister 0094 _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev 00a0 _Unwind_SjLj_Resume 00a4 __gxx_personality_sj0 00b0 _ZTVSt10istrstream 00b4 _ZTTSt10istrstream 00b8 _ZTVSt9basic_iosIcSt11char_traitsIcEE"
	strings:
		$1 = { 80 B5 8F B0 27 4B 00 AF 3B 62 27 4B 27 4A 7B 62 3C 21 3B 1C 28 33 C9 19 B9 62 78 60 5A 60 38 1C 6A 46 9A 60 08 30 ?? ?? ?? ?? 79 68 20 4B 08 1C 0B 60 14 33 4B 63 08 30 01 23 FB 60 ?? ?? ?? ?? 1C 4B 79 68 5A 68 0A 60 0C 3A 12 68 9B 68 8B 50 00 23 4B 60 18 4B 08 1C 4B 63 01 23 5B 42 34 30 FB 60 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 0F 4B 3A 69 79 68 3A 60 5A 68 0A 60 0C 3A 12 68 9B 68 08 1C 8B 50 00 23 4B 60 34 30 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_32_2 {
	meta:
		name = "_ZThn8_NSt9strstreamD0Ev"
		size = 16
		refs = "000c .LTHUNK5"
	strings:
		$1 = { 04 C0 9F E5 08 00 40 E2 1C FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_8_2 {
	meta:
		name = "_ZThn8_NSdD0Ev"
		size = 16
		refs = "000c .LTHUNK3"
	strings:
		$1 = { 04 C0 9F E5 08 00 40 E2 1C FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_91_4_2 {
	meta:
		name = "_ZThn8_NSdD1Ev"
		size = 16
		refs = "000c .LTHUNK1"
	strings:
		$1 = { 04 C0 9F E5 08 00 40 E2 1C FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_64_2 {
	meta:
		name = "_ZThn8_NSt13basic_fstreamIcSt11char_traitsIcEED0Ev"
		size = 16
		refs = "000c .LTHUNK4"
	strings:
		$1 = { 04 C0 9F E5 08 00 40 E2 1C FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_99_68_2 {
	meta:
		name = "_ZThn8_NSt13basic_fstreamIcSt11char_traitsIcEED1Ev"
		size = 16
		refs = "000c .LTHUNK6"
	strings:
		$1 = { 04 C0 9F E5 08 00 40 E2 1C FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_37_2 {
	meta:
		name = "_ZThn8_NSt18basic_stringstreamIcSt11char_traitsIcESaIcEED0Ev"
		size = 16
		refs = "000c .LTHUNK1"
	strings:
		$1 = { 04 C0 9F E5 08 00 40 E2 1C FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_41_2 {
	meta:
		name = "_ZThn8_NSt18basic_stringstreamIcSt11char_traitsIcESaIcEED1Ev"
		size = 16
		refs = "000c .LTHUNK3"
	strings:
		$1 = { 04 C0 9F E5 08 00 40 E2 1C FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_34_2 {
	meta:
		name = "_ZThn8_NSt9strstreamD1Ev"
		size = 16
		refs = "000c .LTHUNK7"
	strings:
		$1 = { 04 C0 9F E5 08 00 40 E2 1C FF 2F E1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_33_2 {
	meta:
		name = ".LTHUNK4"
		size = 220
		refs = "0024 _Unwind_SjLj_Register 0040 _ZNSt12strstreambufD1Ev 007c _ZNSt8ios_baseD2Ev 0082 _ZdlPv 008a _Unwind_SjLj_Unregister 00a2 _ZNSdD2Ev 00ae _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev 00ba _Unwind_SjLj_Resume 00c0 __gxx_personality_sj0 00cc _ZTVSt9strstream 00d0 _ZTTSt9strstream 00d4 _ZTVSt9basic_iosIcSt11char_traitsIcEE"
	strings:
		$1 = { 80 B5 8F B0 2E 4B 00 AF 3B 62 2E 4B 2E 4A 7B 62 78 60 3B 1C 3C 20 28 33 C0 19 69 46 B8 62 5A 60 99 60 34 38 ?? ?? ?? ?? 28 4B 7A 68 78 68 13 60 1A 1C 28 32 14 33 83 60 82 63 01 23 0C 30 FB 60 ?? ?? ?? ?? 22 4B 5A 68 0C 3A 78 68 12 68 99 69 81 50 1A 69 82 60 0C 3A 12 68 59 69 82 18 91 60 9A 68 02 60 0C 3A 12 68 DB 68 83 50 00 23 43 60 18 4B 83 63 01 23 5B 42 38 30 FB 60 ?? ?? ?? ?? 78 68 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 39 69 00 22 39 60 78 68 0E 49 FA 60 ?? ?? ?? ?? 78 68 00 23 38 30 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_35_2 {
	meta:
		name = ".LTHUNK6"
		size = 212
		refs = "0024 _Unwind_SjLj_Register 0040 _ZNSt12strstreambufD1Ev 007c _ZNSt8ios_baseD2Ev 0084 _Unwind_SjLj_Unregister 009c _ZNSdD2Ev 00a8 _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev 00b4 _Unwind_SjLj_Resume 00b8 __gxx_personality_sj0 00c4 _ZTVSt9strstream 00c8 _ZTTSt9strstream 00cc _ZTVSt9basic_iosIcSt11char_traitsIcEE"
	strings:
		$1 = { 80 B5 8F B0 2C 4B 00 AF 3B 62 2C 4B 2C 4A 7B 62 78 60 3B 1C 3C 20 28 33 C0 19 69 46 B8 62 5A 60 99 60 34 38 ?? ?? ?? ?? 26 4B 7A 68 78 68 13 60 1A 1C 28 32 14 33 83 60 82 63 01 23 0C 30 FB 60 ?? ?? ?? ?? 20 4B 5A 68 0C 3A 78 68 12 68 99 69 81 50 1A 69 82 60 0C 3A 12 68 59 69 82 18 91 60 9A 68 02 60 0C 3A 12 68 DB 68 83 50 00 23 43 60 16 4B 83 63 01 23 5B 42 38 30 FB 60 ?? ?? ?? ?? 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 39 69 00 22 39 60 78 68 0D 49 FA 60 ?? ?? ?? ?? 78 68 00 23 38 30 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_36_2 {
	meta:
		name = "_ZNSt9strstreamD2Ev"
		size = 184
		refs = "0026 _Unwind_SjLj_Register 0046 _ZNSt12strstreambufD1Ev 0082 _Unwind_SjLj_Unregister 009c _ZNSdD2Ev 00a8 _Unwind_SjLj_Resume 00ac __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 90 B0 29 4B 00 AF 7B 62 29 4B 29 4A BB 62 B8 60 3B 1C 40 20 2C 33 79 60 C0 19 69 46 F8 62 5A 60 99 60 34 38 ?? ?? ?? ?? 7A 68 B8 68 13 68 03 60 0C 3B 1B 68 11 1C 12 6A C2 50 4B 6A 83 60 01 23 0C 30 3B 61 ?? ?? ?? ?? 78 68 7B 68 42 68 04 33 0C 3A B8 68 12 68 59 69 81 50 79 68 0A 69 82 60 0C 3A 12 68 49 69 82 18 91 60 B9 68 5A 68 0A 60 0C 3A 12 68 9B 68 38 1C 8B 50 00 23 4B 60 0C 30 ?? ?? ?? ?? BD 46 10 B0 80 BD 40 3F 79 68 7A 69 00 23 B8 68 04 31 3B 61 3A 60 ?? ?? ?? ?? 01 23 5B 42 38 68 3B 61 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_37_2 {
	meta:
		name = "_ZNSt10istrstreamC2EPKc"
		size = 232
		refs = "002a _Unwind_SjLj_Register 005a _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 007a _ZNSt12strstreambufC1EPKcl 0096 _Unwind_SjLj_Unregister 00b2 _ZNSt12strstreambufD1Ev 00d6 _Unwind_SjLj_Resume 00dc __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 92 B0 35 4B 00 AF FB 62 35 4B F9 60 3B 63 7A 60 3B 1C 33 4A 48 21 34 33 C9 19 79 63 38 61 5A 60 38 1C 6A 46 9A 60 14 30 ?? ?? ?? ?? FB 68 F9 68 04 33 3B 60 3A 69 4B 68 39 68 13 60 0C 3B 1B 68 4A 68 39 69 CA 50 00 23 4B 60 0B 68 0C 3B 18 68 01 23 08 18 00 21 BB 61 ?? ?? ?? ?? F9 68 3A 69 0B 68 13 60 0C 3B CA 68 1B 68 39 69 CA 50 08 31 08 1C B9 60 00 22 79 68 ?? ?? ?? ?? 3A 69 13 68 0C 3B 18 68 B9 68 02 23 10 18 BB 61 ?? ?? ?? ?? 38 1C 14 30 ?? ?? ?? ?? BD 46 12 B0 80 BD 48 3F FA 69 BB 69 7A 60 01 2B 10 D1 00 23 B8 68 BB 61 ?? ?? ?? ?? F9 68 3A 69 4B 68 39 68 13 60 0C 3B 4A 68 1B 68 39 69 CA 50 00 22 4A 60 01 23 5B 42 78 68 BB 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_38_2 {
	meta:
		name = "_ZNSt10istrstreamC1EPKc"
		size = 284
		refs = "0026 _Unwind_SjLj_Register 0034 _ZNSt8ios_baseC2Ev 0086 _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 00a4 _ZNSt12strstreambufC1EPKcl 00b8 _Unwind_SjLj_Unregister 00d4 _ZNSt12strstreambufD1Ev 00f2 _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev 00fe _Unwind_SjLj_Resume 0104 __gxx_personality_sj0 0110 _ZTVSt9basic_iosIcSt11char_traitsIcEE 0114 _ZTTSt10istrstream 0118 _ZTVSt10istrstream"
	strings:
		$1 = { 80 B5 94 B0 3F 4B 00 AF 7B 63 3F 4B 3F 4A BB 63 B8 61 3B 1C 50 20 3C 33 39 60 C0 19 69 46 F8 63 5A 60 99 60 34 38 ?? ?? ?? ?? B8 69 01 23 5B 42 34 30 3B 62 ?? ?? ?? ?? BA 69 35 4B B8 69 53 63 00 23 A4 22 83 50 A8 22 83 54 A9 22 83 54 AC 22 83 50 B0 22 83 50 B4 22 83 50 B8 22 83 50 2D 4A 51 68 92 68 01 60 BA 60 79 61 0C 39 0A 68 79 60 B9 68 81 50 43 60 03 68 0C 3B 18 68 BA 69 01 23 10 18 00 21 3B 62 ?? ?? ?? ?? 23 4B B8 69 B9 69 03 60 14 33 4B 63 34 30 08 31 F8 60 39 61 08 1C 00 22 39 68 ?? ?? ?? ?? 02 23 F8 68 39 69 3B 62 ?? ?? ?? ?? 38 1C 1C 30 ?? ?? ?? ?? BD 46 14 B0 80 BD 50 3F 7B 6A FB 60 3B 6A 01 2B 0D D1 00 22 38 69 3A 62 ?? ?? ?? ?? B8 69 7B 69 79 68 03 60 BA 68 0B 68 C2 50 00 23 43 60 B8 69 00 23 34 30 3B 62 ?? ?? ?? ?? 01 23 5B 42 F8 68 3B 62 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_39_2 {
	meta:
		name = "_ZNSt10istrstreamC2EPKcl"
		size = 232
		refs = "002c _Unwind_SjLj_Register 005c _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 007c _ZNSt12strstreambufC1EPKcl 0098 _Unwind_SjLj_Unregister 00b4 _ZNSt12strstreambufD1Ev 00d8 _Unwind_SjLj_Resume 00dc __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 93 B0 00 AF 3B 60 34 4B 3B 63 34 4B 39 61 7B 63 BA 60 3B 1C 33 4A 4C 21 38 33 C9 19 B9 63 78 61 5A 60 38 1C 6A 46 9A 60 18 30 ?? ?? ?? ?? 3B 69 39 69 04 33 7B 60 7A 69 4B 68 79 68 13 60 0C 3B 1B 68 4A 68 79 69 CA 50 00 23 4B 60 0B 68 0C 3B 18 68 01 23 08 18 00 21 FB 61 ?? ?? ?? ?? 39 69 7A 69 0B 68 13 60 0C 3B CA 68 1B 68 79 69 CA 50 08 31 08 1C F9 60 3A 68 B9 68 ?? ?? ?? ?? 7A 69 13 68 0C 3B 18 68 F9 68 02 23 10 18 FB 61 ?? ?? ?? ?? 38 1C 18 30 ?? ?? ?? ?? BD 46 13 B0 80 BD 4C 3F 3A 6A FB 69 BA 60 01 2B 10 D1 00 23 F8 68 FB 61 ?? ?? ?? ?? 39 69 7A 69 4B 68 79 68 13 60 0C 3B 4A 68 1B 68 79 69 CA 50 00 22 4A 60 01 23 5B 42 B8 68 FB 61 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_40_2 {
	meta:
		name = "_ZNSt10istrstreamC1EPKcl"
		size = 284
		refs = "0028 _Unwind_SjLj_Register 0036 _ZNSt8ios_baseC2Ev 0088 _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 00a6 _ZNSt12strstreambufC1EPKcl 00ba _Unwind_SjLj_Unregister 00d6 _ZNSt12strstreambufD1Ev 00f4 _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev 0100 _Unwind_SjLj_Resume 0104 __gxx_personality_sj0 0110 _ZTVSt9basic_iosIcSt11char_traitsIcEE 0114 _ZTTSt10istrstream 0118 _ZTVSt10istrstream"
	strings:
		$1 = { 80 B5 95 B0 3F 4B 00 AF BB 63 3F 4B F8 61 FB 63 3A 60 3B 1C 3D 4A 54 20 40 33 79 60 C0 19 69 46 38 64 5A 60 99 60 34 38 ?? ?? ?? ?? F8 69 01 23 5B 42 34 30 7B 62 ?? ?? ?? ?? FA 69 34 4B F8 69 53 63 00 23 A4 22 83 50 A8 22 83 54 A9 22 83 54 AC 22 83 50 B0 22 83 50 B4 22 83 50 B8 22 83 50 2C 4A 51 68 92 68 01 60 FA 60 B9 61 0C 39 0A 68 B9 60 F9 68 81 50 43 60 03 68 0C 3B 18 68 FA 69 01 23 10 18 00 21 7B 62 ?? ?? ?? ?? 22 4B F8 69 F9 69 03 60 14 33 4B 63 34 30 08 31 38 61 79 61 08 1C 3A 68 79 68 ?? ?? ?? ?? 02 23 38 69 79 69 7B 62 ?? ?? ?? ?? 38 1C 20 30 ?? ?? ?? ?? BD 46 15 B0 80 BD 54 3F BB 6A 3B 61 7B 6A 01 2B 0D D1 00 22 78 69 7A 62 ?? ?? ?? ?? F8 69 BB 69 B9 68 03 60 FA 68 0B 68 C2 50 00 23 43 60 F8 69 00 23 34 30 7B 62 ?? ?? ?? ?? 01 23 5B 42 38 69 7B 62 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_41_2 {
	meta:
		name = "_ZNSt12strstreambufC2EPFPvmEPFvS0_E"
		size = 216
		refs = "002a _Unwind_SjLj_Register 0046 _ZNSt6localeC1Ev 0080 _ZNSt12strstreambuf8_M_allocEm 009e _Unwind_SjLj_Unregister 00b4 _ZNSt15basic_streambufIcSt11char_traitsIcEED2Ev 00c0 _Unwind_SjLj_Resume 00c4 __gxx_personality_sj0 00d0 _ZTVSt15basic_streambufIcSt11char_traitsIcEE 00d4 _ZTVSt12strstreambuf"
		altNames = "_ZNSt12strstreambufC1EPFPvmEPFvS0_E"
	strings:
		$1 = { 80 B5 90 B0 2F 4B 00 AF 7B 62 2F 4B 79 60 BB 62 3A 60 3B 1C 2D 4A 40 21 2C 33 C9 19 F9 62 B8 60 5A 60 38 1C 6A 46 9A 60 0C 30 ?? ?? ?? ?? B9 68 27 4B 08 1C 0B 60 00 23 4B 60 8B 60 CB 60 0B 61 4B 61 8B 61 1C 30 ?? ?? ?? ?? BA 68 21 4B 39 68 13 60 7B 68 51 62 13 62 28 23 D1 5C 01 22 0A 43 B9 68 CA 54 CA 5C 02 21 8A 43 B9 68 CA 54 CA 5C 04 21 8A 43 B9 68 CA 54 B8 68 01 23 10 21 3B 61 ?? ?? ?? ?? 00 28 08 D0 BA 68 03 1C 10 33 50 61 10 61 93 61 50 60 90 60 D0 60 38 1C 0C 30 ?? ?? ?? ?? BD 46 10 B0 80 BD 40 3F 7B 69 B8 68 7B 60 00 23 3B 61 ?? ?? ?? ?? 01 23 5B 42 78 68 3B 61 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_42_2 {
	meta:
		name = "_ZNSt12strstreambufC1El"
		size = 224
		refs = "0028 _Unwind_SjLj_Register 0044 _ZNSt6localeC1Ev 0086 _ZNSt12strstreambuf8_M_allocEm 00a4 _Unwind_SjLj_Unregister 00ba _ZNSt15basic_streambufIcSt11char_traitsIcEED2Ev 00c6 _Unwind_SjLj_Resume 00cc __gxx_personality_sj0 00d8 _ZTVSt15basic_streambufIcSt11char_traitsIcEE 00dc _ZTVSt12strstreambuf"
		altNames = "_ZNSt12strstreambufC2El"
	strings:
		$1 = { 80 B5 8F B0 31 4B 00 AF 3B 62 31 4B 31 4A 7B 62 39 60 3B 1C 3C 21 28 33 C9 19 B9 62 78 60 5A 60 38 1C 6A 46 9A 60 08 30 ?? ?? ?? ?? 79 68 2A 4B 00 22 08 1C 0B 60 4A 60 8A 60 CA 60 0A 61 4A 61 8A 61 1C 30 ?? ?? ?? ?? 79 68 24 4B 00 22 0B 60 0A 62 4A 62 28 23 C9 5C 01 22 0A 43 79 68 CA 54 CA 5C 02 21 8A 43 79 68 CA 54 CA 5C 04 21 8A 43 79 68 CA 54 3A 68 0F 2A 01 DC 10 23 3B 60 01 23 78 68 39 68 FB 60 ?? ?? ?? ?? 00 28 08 D0 3A 68 79 68 83 18 48 61 08 61 8B 61 48 60 88 60 C8 60 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 80 BD 3C 3F 3B 69 78 68 3B 60 00 23 FB 60 ?? ?? ?? ?? 01 23 5B 42 38 68 FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_43_2 {
	meta:
		name = "_ZNSt9strstreamC2Ev"
		size = 304
		refs = "0026 _Unwind_SjLj_Register 0056 _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 00ac _ZNSt12strstreambufC1El 00ca _Unwind_SjLj_Unregister 0106 _Unwind_SjLj_Resume 0110 _ZNSt12strstreambufD1Ev 011c _ZNSdD2Ev 0124 __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 92 B0 47 4B 00 AF FB 62 47 4B 47 4A 3B 63 38 61 3B 1C 48 20 34 33 B9 60 C0 19 69 46 78 63 5A 60 99 60 34 38 ?? ?? ?? ?? BA 68 04 32 FA 60 F8 68 39 69 43 68 04 32 0B 60 0C 3B 1B 68 7A 60 52 68 CA 50 00 23 4B 60 0B 68 0C 3B 18 68 02 23 08 18 00 21 BB 61 ?? ?? ?? ?? F9 68 3B 69 CA 68 9A 60 0C 3A 12 68 09 69 08 33 99 50 39 69 8A 68 0C 3A 10 68 00 21 18 18 01 23 BB 61 ?? ?? ?? ?? B8 68 43 68 F9 68 0C 3B 38 69 4A 69 1B 68 B9 68 C2 50 0B 68 03 60 0C 3B 1B 68 0A 6A C2 50 4B 6A 00 21 83 60 0C 30 04 23 38 60 BB 61 ?? ?? ?? ?? 3A 69 13 68 0C 3B 18 68 11 1C 03 23 10 18 0C 31 BB 61 ?? ?? ?? ?? 38 1C 14 30 ?? ?? ?? ?? BD 46 12 B0 80 BD 48 3F FA 69 BB 69 BA 60 01 2B 0E D0 02 2B 12 D0 03 2B 15 D0 FA 68 38 69 53 68 79 68 03 60 0C 3B 1B 68 4A 68 C2 50 00 23 43 60 01 23 5B 42 B8 68 BB 61 ?? ?? ?? ?? 00 23 38 68 BB 61 ?? ?? ?? ?? 00 23 38 69 F9 68 BB 61 ?? ?? ?? ?? ED E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_44_2 {
	meta:
		name = "_ZNSt10ostrstreamC1Ev"
		size = 284
		refs = "0026 _Unwind_SjLj_Register 0034 _ZNSt8ios_baseC2Ev 0080 _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 00a0 _ZNSt12strstreambufC1El 00b6 _Unwind_SjLj_Unregister 00d8 _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev 00e4 _Unwind_SjLj_Resume 00ee _ZNSt12strstreambufD1Ev 0104 __gxx_personality_sj0 0110 _ZTVSt9basic_iosIcSt11char_traitsIcEE 0114 _ZTTSt10ostrstream 0118 _ZTVSt10ostrstream"
	strings:
		$1 = { 80 B5 93 B0 3F 4B 00 AF 3B 63 3F 4B 3F 4A 7B 63 4C 21 3B 1C 38 33 C9 19 B9 63 78 61 5A 60 38 1C 6A 46 9A 60 18 30 ?? ?? ?? ?? 78 69 01 23 5B 42 30 30 FB 61 ?? ?? ?? ?? 79 69 35 4B A0 22 0B 63 00 23 8B 50 A4 22 8B 54 A5 22 8B 54 A8 22 8B 50 AC 22 8B 50 B0 22 8B 50 B4 22 8B 50 2D 4B 5A 68 9B 68 0A 60 BB 60 3A 61 0C 3A 13 68 7A 60 BA 68 CA 50 0B 68 0C 3B 18 68 01 23 08 18 00 21 FB 61 ?? ?? ?? ?? 24 4B 7A 69 79 69 13 60 14 33 0B 63 04 31 30 32 39 60 03 23 08 1C 00 21 FA 60 FB 61 ?? ?? ?? ?? 79 69 02 23 04 31 F8 68 FB 61 ?? ?? ?? ?? 38 1C 18 30 ?? ?? ?? ?? BD 46 13 B0 80 BD 4C 3F 39 6A FB 69 F9 60 01 2B 0D D0 02 2B 10 D0 78 69 00 23 30 30 FB 61 ?? ?? ?? ?? 01 23 5B 42 F8 68 FB 61 ?? ?? ?? ?? 00 23 38 68 FB 61 ?? ?? ?? ?? 3A 69 7B 69 79 68 1A 60 0B 68 7A 69 B9 68 D1 50 E5 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_45_2 {
	meta:
		name = "_ZNSt10ostrstreamC2Ev"
		size = 232
		refs = "0028 _Unwind_SjLj_Register 0054 _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 0076 _ZNSt12strstreambufC1El 0094 _Unwind_SjLj_Unregister 00b6 _Unwind_SjLj_Resume 00c0 _ZNSt12strstreambufD1Ev 00dc __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 92 B0 35 4B 00 AF FB 62 35 4B 35 4A 3B 63 F9 60 3B 1C 48 21 34 33 C9 19 79 63 38 61 5A 60 38 1C 6A 46 9A 60 14 30 ?? ?? ?? ?? FB 68 F9 68 04 33 7B 60 3A 69 4B 68 79 68 13 60 0C 3B 1B 68 4A 68 39 69 CA 50 0B 68 0C 3B 18 68 01 23 08 18 00 21 BB 61 ?? ?? ?? ?? F9 68 3A 69 0B 68 13 60 0C 3B 1B 68 CA 68 39 69 CA 50 04 31 B9 60 03 23 08 1C 00 21 BB 61 ?? ?? ?? ?? 3A 69 13 68 0C 3B 18 68 11 1C 02 23 10 18 04 31 BB 61 ?? ?? ?? ?? 38 1C 14 30 ?? ?? ?? ?? BD 46 12 B0 80 BD 48 3F FA 69 BB 69 3A 60 01 2B 07 D0 02 2B 0A D0 01 23 5B 42 38 68 BB 61 ?? ?? ?? ?? 00 23 B8 68 BB 61 ?? ?? ?? ?? F9 68 3A 69 4B 68 79 68 13 60 0C 3B 4A 68 1B 68 39 69 CA 50 E9 E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_48_2 {
	meta:
		name = "_ZNSt12strstreambufC1EPhlS0_"
		size = 100
		refs = "0022 _ZNSt6localeC1Ev 0050 _ZNSt12strstreambuf8_M_setupEPcS0_l 005c _ZTVSt15basic_streambufIcSt11char_traitsIcEE 0060 _ZTVSt12strstreambuf"
		altNames = "_ZNSt12strstreambufC1EPalS0_ _ZNSt12strstreambufC1EPclS0_ _ZNSt12strstreambufC2EPalS0_ _ZNSt12strstreambufC2EPclS0_ _ZNSt12strstreambufC2EPhlS0_"
	strings:
		$1 = { F0 B5 47 46 80 B4 1F 1C 14 4B 00 25 04 1C 45 60 85 60 C5 60 05 61 45 61 85 61 03 60 1C 30 0E 1C 90 46 ?? ?? ?? ?? 0E 4B 25 62 23 60 65 62 28 23 E2 5C 01 21 8A 43 E2 54 E2 5C 02 21 8A 43 E2 54 E2 5C 04 21 8A 43 E2 54 31 1C 3A 1C 43 46 20 1C ?? ?? ?? ?? 04 BC 90 46 F0 BD C0 46 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_53_2 {
	meta:
		name = "_ZNSt10ostrstreamC1EPciSt13_Ios_Openmode"
		size = 304
		refs = "002c _Unwind_SjLj_Register 003a _ZNSt8ios_baseC2Ev 0086 _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 00ac _ZNSt12strstreambufC1EPclS0_ 00c2 _Unwind_SjLj_Unregister 00ce strlen 00ea _ZNSt12strstreambufD1Ev 0106 _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev 0112 _Unwind_SjLj_Resume 0118 __gxx_personality_sj0 0124 _ZTVSt9basic_iosIcSt11char_traitsIcEE 0128 _ZTTSt10ostrstream 012c _ZTVSt10ostrstream"
	strings:
		$1 = { 80 B5 96 B0 00 AF 3B 60 43 4B FB 63 43 4B F9 61 3B 64 7A 60 3B 1C 42 4A 58 21 44 33 C9 19 79 64 38 62 5A 60 38 1C 6A 46 9A 60 24 30 ?? ?? ?? ?? 38 6A 01 23 5B 42 30 30 BB 62 ?? ?? ?? ?? 39 6A 38 4B A0 22 0B 63 00 23 8B 50 A4 22 8B 54 A5 22 8B 54 A8 22 8B 50 AC 22 8B 50 B0 22 8B 50 B4 22 8B 50 31 4B 5A 68 9B 68 0A 60 7B 61 BA 61 0C 3A 13 68 3A 61 7A 69 CA 50 0B 68 0C 3B 18 68 01 23 08 18 00 21 BB 62 ?? ?? ?? ?? 28 4B 39 6A 3A 6A 0B 60 14 33 13 63 3B 68 30 31 04 32 B9 60 FA 60 DB 07 13 D4 FB 69 F8 68 F9 69 7A 68 ?? ?? ?? ?? 39 6A 02 23 04 31 B8 68 BB 62 ?? ?? ?? ?? 38 1C 24 30 ?? ?? ?? ?? BD 46 16 B0 80 BD F8 69 ?? ?? ?? ?? F9 69 0B 18 E6 E7 58 3F FB 6A FB 61 BB 6A 01 2B 0C D1 00 23 F8 68 BB 62 ?? ?? ?? ?? BA 69 3B 6A 39 69 1A 60 0B 68 3A 6A 79 69 D1 50 38 6A 00 23 30 30 BB 62 ?? ?? ?? ?? 01 23 5B 42 F8 69 BB 62 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_54_2 {
	meta:
		name = "_ZNSt10ostrstreamC2EPciSt13_Ios_Openmode"
		size = 248
		refs = "002c _Unwind_SjLj_Register 0058 _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 0080 _ZNSt12strstreambufC1EPclS0_ 009e _Unwind_SjLj_Unregister 00aa strlen 00c6 _ZNSt12strstreambufD1Ev 00e6 _Unwind_SjLj_Resume 00ec __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 93 B0 00 AF 3B 60 38 4B 3B 63 38 4B 39 61 7B 63 FA 60 3B 1C 37 4A 4C 21 38 33 C9 19 B9 63 78 61 5A 60 38 1C 6A 46 9A 60 18 30 ?? ?? ?? ?? 3B 69 39 69 04 33 7B 60 7A 69 4B 68 79 68 13 60 0C 3B 1B 68 4A 68 79 69 CA 50 0B 68 0C 3B 18 68 01 23 08 18 00 21 FB 61 ?? ?? ?? ?? 39 69 7A 69 0B 68 13 60 0C 3B 1B 68 CA 68 79 69 CA 50 7B 6D 04 31 B9 60 DA 07 17 D4 FB 68 B8 68 F9 68 3A 68 ?? ?? ?? ?? 7A 69 13 68 0C 3B 18 68 11 1C 02 23 10 18 04 31 FB 61 ?? ?? ?? ?? 38 1C 18 30 ?? ?? ?? ?? BD 46 13 B0 80 BD F8 68 ?? ?? ?? ?? F9 68 0B 18 E2 E7 4C 3F 3A 6A FB 69 FA 60 01 2B 0E D1 00 23 B8 68 FB 61 ?? ?? ?? ?? 39 69 7A 69 4B 68 79 68 13 60 0C 3B 4A 68 1B 68 79 69 CA 50 01 23 5B 42 F8 68 FB 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_55_2 {
	meta:
		name = "_ZNSt10istrstreamC1EPcl"
		size = 288
		refs = "0028 _Unwind_SjLj_Register 0036 _ZNSt8ios_baseC2Ev 0088 _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 00a8 _ZNSt12strstreambufC1EPclS0_ 00bc _Unwind_SjLj_Unregister 00d8 _ZNSt12strstreambufD1Ev 00f6 _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev 0102 _Unwind_SjLj_Resume 0108 __gxx_personality_sj0 0114 _ZTVSt9basic_iosIcSt11char_traitsIcEE 0118 _ZTTSt10istrstream 011c _ZTVSt10istrstream"
	strings:
		$1 = { 80 B5 95 B0 40 4B 00 AF BB 63 40 4B F8 61 FB 63 3A 60 3B 1C 3E 4A 54 20 40 33 79 60 C0 19 69 46 38 64 5A 60 99 60 34 38 ?? ?? ?? ?? F8 69 01 23 5B 42 34 30 7B 62 ?? ?? ?? ?? FA 69 35 4B F8 69 53 63 00 23 A4 22 83 50 A8 22 83 54 A9 22 83 54 AC 22 83 50 B0 22 83 50 B4 22 83 50 B8 22 83 50 2D 4A 51 68 92 68 01 60 FA 60 B9 61 0C 39 0A 68 B9 60 F9 68 81 50 43 60 03 68 0C 3B 18 68 FA 69 01 23 10 18 00 21 7B 62 ?? ?? ?? ?? 23 4B F8 69 F9 69 03 60 14 33 4B 63 34 30 08 31 38 61 79 61 08 1C 00 23 79 68 3A 68 ?? ?? ?? ?? 02 23 38 69 79 69 7B 62 ?? ?? ?? ?? 38 1C 20 30 ?? ?? ?? ?? BD 46 15 B0 80 BD 54 3F BB 6A 3B 61 7B 6A 01 2B 0D D1 00 22 78 69 7A 62 ?? ?? ?? ?? F8 69 BB 69 B9 68 03 60 FA 68 0B 68 C2 50 00 23 43 60 F8 69 00 23 34 30 7B 62 ?? ?? ?? ?? 01 23 5B 42 38 69 7B 62 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_56_2 {
	meta:
		name = "_ZNSt10istrstreamC2EPcl"
		size = 236
		refs = "002c _Unwind_SjLj_Register 005c _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 007e _ZNSt12strstreambufC1EPclS0_ 009a _Unwind_SjLj_Unregister 00b6 _ZNSt12strstreambufD1Ev 00da _Unwind_SjLj_Resume 00e0 __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 93 B0 00 AF 3B 60 35 4B 3B 63 35 4B 39 61 7B 63 BA 60 3B 1C 34 4A 4C 21 38 33 C9 19 B9 63 78 61 5A 60 38 1C 6A 46 9A 60 18 30 ?? ?? ?? ?? 3B 69 39 69 04 33 7B 60 7A 69 4B 68 79 68 13 60 0C 3B 1B 68 4A 68 79 69 CA 50 00 23 4B 60 0B 68 0C 3B 18 68 01 23 08 18 00 21 FB 61 ?? ?? ?? ?? 39 69 7A 69 0B 68 13 60 0C 3B CA 68 1B 68 79 69 CA 50 08 31 08 1C F9 60 3A 68 B9 68 00 23 ?? ?? ?? ?? 7A 69 13 68 0C 3B 18 68 F9 68 02 23 10 18 FB 61 ?? ?? ?? ?? 38 1C 18 30 ?? ?? ?? ?? BD 46 13 B0 80 BD 4C 3F 3A 6A FB 69 BA 60 01 2B 10 D1 00 23 F8 68 FB 61 ?? ?? ?? ?? 39 69 7A 69 4B 68 79 68 13 60 0C 3B 4A 68 1B 68 79 69 CA 50 00 22 4A 60 01 23 5B 42 B8 68 FB 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_57_2 {
	meta:
		name = "_ZNSt10istrstreamC1EPc"
		size = 284
		refs = "0026 _Unwind_SjLj_Register 0034 _ZNSt8ios_baseC2Ev 0086 _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 00a6 _ZNSt12strstreambufC1EPclS0_ 00ba _Unwind_SjLj_Unregister 00d6 _ZNSt12strstreambufD1Ev 00f4 _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev 0100 _Unwind_SjLj_Resume 0104 __gxx_personality_sj0 0110 _ZTVSt9basic_iosIcSt11char_traitsIcEE 0114 _ZTTSt10istrstream 0118 _ZTVSt10istrstream"
	strings:
		$1 = { 80 B5 94 B0 3F 4B 00 AF 7B 63 3F 4B 3F 4A BB 63 B8 61 3B 1C 50 20 3C 33 39 60 C0 19 69 46 F8 63 5A 60 99 60 34 38 ?? ?? ?? ?? B8 69 01 23 5B 42 34 30 3B 62 ?? ?? ?? ?? BA 69 35 4B B8 69 53 63 00 23 A4 22 83 50 A8 22 83 54 A9 22 83 54 AC 22 83 50 B0 22 83 50 B4 22 83 50 B8 22 83 50 2D 4A 51 68 92 68 01 60 BA 60 79 61 0C 39 0A 68 79 60 B9 68 81 50 43 60 03 68 0C 3B 18 68 BA 69 01 23 10 18 00 21 3B 62 ?? ?? ?? ?? 23 4B B8 69 B9 69 03 60 14 33 4B 63 34 30 08 31 F8 60 39 61 08 1C 00 23 39 68 00 22 ?? ?? ?? ?? 02 23 F8 68 39 69 3B 62 ?? ?? ?? ?? 38 1C 1C 30 ?? ?? ?? ?? BD 46 14 B0 80 BD 50 3F 7B 6A FB 60 3B 6A 01 2B 0D D1 00 22 38 69 3A 62 ?? ?? ?? ?? B8 69 7B 69 79 68 03 60 BA 68 0B 68 C2 50 00 23 43 60 B8 69 00 23 34 30 3B 62 ?? ?? ?? ?? 01 23 5B 42 F8 68 3B 62 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_58_2 {
	meta:
		name = "_ZNSt10istrstreamC2EPc"
		size = 232
		refs = "002a _Unwind_SjLj_Register 005a _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 007c _ZNSt12strstreambufC1EPclS0_ 0098 _Unwind_SjLj_Unregister 00b4 _ZNSt12strstreambufD1Ev 00d8 _Unwind_SjLj_Resume 00dc __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 92 B0 35 4B 00 AF FB 62 35 4B F9 60 3B 63 7A 60 3B 1C 33 4A 48 21 34 33 C9 19 79 63 38 61 5A 60 38 1C 6A 46 9A 60 14 30 ?? ?? ?? ?? FB 68 F9 68 04 33 3B 60 3A 69 4B 68 39 68 13 60 0C 3B 1B 68 4A 68 39 69 CA 50 00 23 4B 60 0B 68 0C 3B 18 68 01 23 08 18 00 21 BB 61 ?? ?? ?? ?? F9 68 3A 69 0B 68 13 60 0C 3B CA 68 1B 68 39 69 CA 50 08 31 08 1C B9 60 00 22 79 68 00 23 ?? ?? ?? ?? 3A 69 13 68 0C 3B 18 68 B9 68 02 23 10 18 BB 61 ?? ?? ?? ?? 38 1C 14 30 ?? ?? ?? ?? BD 46 12 B0 80 BD 48 3F FA 69 BB 69 7A 60 01 2B 10 D1 00 23 B8 68 BB 61 ?? ?? ?? ?? F9 68 3A 69 4B 68 39 68 13 60 0C 3B 4A 68 1B 68 39 69 CA 50 00 22 4A 60 01 23 5B 42 78 68 BB 61 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_65_2 {
	meta:
		name = "_ZNSt9strstreamC1EPciSt13_Ios_Openmode"
		size = 388
		refs = "002a _Unwind_SjLj_Register 0038 _ZNSt8ios_baseC2Ev 008a _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 00e8 _ZNSt12strstreambufC1EPclS0_ 00fe _Unwind_SjLj_Unregister 010a strlen 013e _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev 014a _Unwind_SjLj_Resume 0154 _ZNSt12strstreambufD1Ev 0160 _ZNSdD2Ev 0168 __gxx_personality_sj0 0174 _ZTVSt9basic_iosIcSt11char_traitsIcEE 0178 _ZTTSt9strstream 017c _ZTVSt9strstream"
	strings:
		$1 = { 80 B5 96 B0 00 AF 3B 60 57 4B FB 63 57 4B 38 62 3B 64 7A 60 3B 1C 56 4A 58 20 44 33 F9 61 C0 19 69 46 78 64 5A 60 99 60 34 38 ?? ?? ?? ?? 38 6A 01 23 5B 42 38 30 BB 62 ?? ?? ?? ?? 3A 6A 4D 4B 38 6A 93 63 00 23 A8 22 83 50 AC 22 83 54 AD 22 83 54 B0 22 83 50 B4 22 83 50 B8 22 83 50 BC 22 83 50 45 4A 91 68 D2 68 01 60 7A 61 B9 61 0C 39 0A 68 39 61 79 69 81 50 43 60 03 68 0C 3B 18 68 3A 6A 02 23 10 18 00 21 BB 62 ?? ?? ?? ?? 3A 4A 3B 6A 11 69 99 60 0C 39 09 68 52 69 08 33 5A 50 38 6A 82 68 0C 3A 10 68 00 21 18 18 01 23 BB 62 ?? ?? ?? ?? 30 4B 5A 68 0C 3A 38 6A 12 68 9B 69 83 50 2E 4B 39 6A 1A 1C 28 32 03 60 8A 63 14 33 3A 68 38 30 8B 60 0C 31 B8 60 F9 60 D2 07 13 D4 FB 69 F8 68 F9 69 7A 68 ?? ?? ?? ?? 39 6A 03 23 0C 31 B8 68 BB 62 ?? ?? ?? ?? 38 1C 24 30 ?? ?? ?? ?? BD 46 16 B0 80 BD F8 69 ?? ?? ?? ?? F9 69 0B 18 E6 E7 58 3F F9 6A BB 6A F9 61 01 2B 0A D0 02 2B 14 D0 38 6A BB 69 39 69 03 60 7A 69 0B 68 C2 50 00 23 43 60 38 6A 00 23 38 30 BB 62 ?? ?? ?? ?? 01 23 5B 42 F8 69 BB 62 ?? ?? ?? ?? 00 22 F8 68 BA 62 ?? ?? ?? ?? 00 23 38 6A 08 49 BB 62 ?? ?? ?? ?? E7 E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_66_2 {
	meta:
		name = "_ZNSt9strstreamC1Ev"
		size = 368
		refs = "0024 _Unwind_SjLj_Register 0032 _ZNSt8ios_baseC2Ev 0084 _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 00dc _ZNSt12strstreambufC1El 00f2 _Unwind_SjLj_Unregister 012c _ZNSt9basic_iosIcSt11char_traitsIcEED2Ev 0138 _Unwind_SjLj_Resume 0142 _ZNSt12strstreambufD1Ev 014e _ZNSdD2Ev 0154 __gxx_personality_sj0 0160 _ZTVSt9basic_iosIcSt11char_traitsIcEE 0164 _ZTTSt9strstream 0168 _ZTVSt9strstream"
	strings:
		$1 = { 80 B5 93 B0 53 4B 00 AF 3B 63 53 4B 53 4A 7B 63 78 61 3B 1C 4C 20 38 33 69 46 C0 19 B8 63 5A 60 99 60 34 38 ?? ?? ?? ?? 78 69 01 23 5B 42 38 30 FB 61 ?? ?? ?? ?? 7A 69 49 4B 78 69 93 63 00 23 A8 22 83 50 AC 22 83 54 AD 22 83 54 B0 22 83 50 B4 22 83 50 B8 22 83 50 BC 22 83 50 41 4A 91 68 D2 68 01 60 BA 60 39 61 0C 39 0A 68 79 60 B9 68 81 50 43 60 03 68 0C 3B 18 68 7A 69 02 23 10 18 00 21 FB 61 ?? ?? ?? ?? 36 4A 7B 69 11 69 99 60 0C 39 09 68 52 69 08 33 5A 50 78 69 82 68 0C 3A 10 68 00 21 18 18 01 23 FB 61 ?? ?? ?? ?? 2D 4B 5A 68 0C 3A 12 68 78 69 9B 69 83 50 2A 4B 79 69 1A 1C 03 60 28 32 14 33 8B 60 38 30 8A 63 0C 31 F8 60 39 60 04 23 08 1C 00 21 FB 61 ?? ?? ?? ?? 79 69 03 23 0C 31 F8 68 FB 61 ?? ?? ?? ?? 38 1C 18 30 ?? ?? ?? ?? BD 46 13 B0 80 BD 4C 3F 39 6A FB 69 F9 60 01 2B 0D D0 02 2B 17 D0 03 2B 1A D0 3A 69 7B 69 78 68 1A 60 79 69 03 68 BA 68 CA 50 00 23 4B 60 78 69 00 23 38 30 FB 61 ?? ?? ?? ?? 01 23 5B 42 F8 68 FB 61 ?? ?? ?? ?? 00 23 38 68 FB 61 ?? ?? ?? ?? 00 23 78 69 08 49 FB 61 ?? ?? ?? ?? E7 E7 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_67_2 {
	meta:
		name = "_ZNSt9strstreamC2EPciSt13_Ios_Openmode"
		size = 324
		refs = "002a _Unwind_SjLj_Register 005a _ZNSt9basic_iosIcSt11char_traitsIcEE4initEPSt15basic_streambufIcS1_E 00b8 _ZNSt12strstreambufC1EPclS0_ 00d6 _Unwind_SjLj_Unregister 00e2 strlen 011a _Unwind_SjLj_Resume 0124 _ZNSt12strstreambufD1Ev 0130 _ZNSdD2Ev 0138 __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 94 B0 00 AF 3B 60 4B 4B 7B 63 4B 4B B8 61 BB 63 FA 60 3B 1C 4A 4A 50 20 3C 33 39 61 C0 19 69 46 F8 63 5A 60 99 60 34 38 ?? ?? ?? ?? 3A 69 04 32 7A 61 78 69 B9 69 43 68 04 32 0B 60 0C 3B 1B 68 BA 60 52 68 CA 50 00 23 4B 60 0B 68 0C 3B 18 68 02 23 08 18 00 21 3B 62 ?? ?? ?? ?? 79 69 BB 69 CA 68 9A 60 0C 3A 12 68 09 69 08 33 99 50 B9 69 8A 68 0C 3A 10 68 00 21 18 18 01 23 3B 62 ?? ?? ?? ?? 38 69 43 68 79 69 0C 3B B8 69 4A 69 1B 68 39 69 C2 50 0B 68 03 60 0C 3B 1B 68 0A 6A C2 50 4B 6A 83 60 BB 6D 0C 30 78 60 DA 07 17 D4 FB 68 78 68 F9 68 3A 68 ?? ?? ?? ?? BA 69 13 68 0C 3B 18 68 11 1C 03 23 10 18 0C 31 3B 62 ?? ?? ?? ?? 38 1C 1C 30 ?? ?? ?? ?? BD 46 14 B0 80 BD F8 68 ?? ?? ?? ?? F9 68 0B 18 E2 E7 50 3F 7A 6A 3B 6A 3A 61 01 2B 0C D0 02 2B 10 D0 78 69 B9 69 43 68 B8 68 0B 60 0C 3B 1B 68 42 68 CA 50 00 23 4B 60 01 23 5B 42 38 69 3B 62 ?? ?? ?? ?? 00 23 78 68 3B 62 ?? ?? ?? ?? 00 20 38 62 79 69 B8 69 ?? ?? ?? ?? ED E7 C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_46_68_2 {
	meta:
		name = "_ZTv0_n12_NSt9strstreamD1Ev"
		size = 16
		refs = "000a .LTHUNK6"
		altNames = "_ZTv0_n12_NSdD0Ev _ZTv0_n12_NSdD1Ev _ZTv0_n12_NSiD0Ev _ZTv0_n12_NSiD1Ev _ZTv0_n12_NSoD0Ev _ZTv0_n12_NSoD1Ev _ZTv0_n12_NSt13basic_fstreamIcSt11char_traitsIcEED0Ev _ZTv0_n12_NSt13basic_fstreamIcSt11char_traitsIcEED1Ev _ZTv0_n12_NSt14basic_ifstreamIcSt11char_traitsIcEED0Ev _ZTv0_n12_NSt14basic_ifstreamIcSt11char_traitsIcEED1Ev _ZTv0_n12_NSt14basic_ofstreamIcSt11char_traitsIcEED0Ev _ZTv0_n12_NSt14basic_ofstreamIcSt11char_traitsIcEED1Ev _ZTv0_n12_NSt18basic_stringstreamIcSt11char_traitsIcESaIcEED0Ev _ZTv0_n12_NSt18basic_stringstreamIcSt11char_traitsIcESaIcEED1Ev _ZTv0_n12_NSt19basic_istringstreamIcSt11char_traitsIcESaIcEED0Ev _ZTv0_n12_NSt19basic_istringstreamIcSt11char_traitsIcESaIcEED1Ev _ZTv0_n12_NSt19basic_ostringstreamIcSt11char_traitsIcESaIcEED0Ev _ZTv0_n12_NSt19basic_ostringstreamIcSt11char_traitsIcESaIcEED1Ev"
	strings:
		$1 = { 00 B5 03 68 0C 3B 1B 68 C0 18 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_46_71_2 {
	meta:
		name = "_ZTv0_n12_NSt10istrstreamD0Ev"
		size = 16
		refs = "000a .LTHUNK2"
	strings:
		$1 = { 00 B5 03 68 0C 3B 1B 68 C0 18 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_46_70_2 {
	meta:
		name = "_ZTv0_n12_NSt10istrstreamD1Ev"
		size = 16
		refs = "000a .LTHUNK3"
	strings:
		$1 = { 00 B5 03 68 0C 3B 1B 68 C0 18 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_46_73_2 {
	meta:
		name = "_ZTv0_n12_NSt10ostrstreamD0Ev"
		size = 16
		refs = "000a .LTHUNK0"
	strings:
		$1 = { 00 B5 03 68 0C 3B 1B 68 C0 18 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_46_72_2 {
	meta:
		name = "_ZTv0_n12_NSt10ostrstreamD1Ev"
		size = 16
		refs = "000a .LTHUNK1"
	strings:
		$1 = { 00 B5 03 68 0C 3B 1B 68 C0 18 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_46_69_2 {
	meta:
		name = "_ZTv0_n12_NSt9strstreamD0Ev"
		size = 16
		refs = "000a .LTHUNK4"
	strings:
		$1 = { 00 B5 03 68 0C 3B 1B 68 C0 18 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_48_5_2 {
	meta:
		name = "_ZNKSs8_M_limitEmm"
		size = 18
	strings:
		$1 = { 03 68 0C 3B 1B 68 59 1A 10 1C 8A 42 00 D9 08 1C 70 47 }
	condition:
		$1
}

rule file_48_6_2 {
	meta:
		name = "_ZNKSs11_M_disjunctEPKc"
		size = 26
	strings:
		$1 = { 03 68 8B 42 07 D8 1A 1C 0C 3A 10 68 1B 18 8B 42 89 41 48 42 70 47 01 20 FC E7 }
	condition:
		$1
}

rule file_48_21_2 {
	meta:
		name = "_ZNSs4swapERSs"
		size = 42
	strings:
		$1 = { 30 B5 03 68 1A 1C 0C 3A 94 68 00 2C 0A DB 0A 68 14 1C 0C 3C A5 68 00 2D 01 DA 00 25 A5 60 02 60 0B 60 30 BD 00 24 94 60 F1 E7 }
	condition:
		$1
}

rule file_48_25_2 {
	meta:
		name = "_ZNKSs5rfindEcm"
		size = 52
	strings:
		$1 = { 03 68 18 1C 0C 38 00 68 09 06 09 0E 00 28 0E D0 01 38 82 42 09 D8 50 1C 9A 18 00 28 07 D0 13 78 01 38 01 3A 99 42 F8 D1 70 47 02 1C F3 E7 01 20 40 42 F9 E7 }
	condition:
		$1
}

rule file_48_27_2 {
	meta:
		name = "_ZNKSs17find_first_not_ofEcm"
		size = 50
	strings:
		$1 = { 10 B5 03 68 09 06 0C 0E 19 1C 0C 39 09 68 8A 42 0B D2 9B 18 18 78 A0 42 04 D0 08 E0 58 78 01 33 84 42 04 D1 01 32 8A 42 F8 D3 01 22 52 42 10 1C 10 BD }
	condition:
		$1
}

rule file_48_28_2 {
	meta:
		name = "_ZNKSs16find_last_not_ofEcm"
		size = 54
	strings:
		$1 = { 10 B5 03 68 1C 1C 0C 3C 24 68 09 06 09 0E 00 2C 0C D0 01 3C 10 1C A2 42 0B D8 1B 18 00 E0 01 38 1A 78 8A 42 04 D1 01 3B 00 28 F8 D1 01 20 40 42 10 BD 20 1C F1 E7 }
	condition:
		$1
}

rule file_48_40_2 {
	meta:
		name = "_ZNSs4_Rep10_M_refcopyEv"
		size = 24
		refs = "0014 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 04 4B 98 42 01 D1 0C 30 70 47 83 68 01 33 83 60 F9 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_42_2 {
	meta:
		name = "_ZNSs4_Rep10_M_disposeERKSaIcE"
		size = 32
		refs = "0014 _ZNSs4_Rep10_M_destroyERKSaIcE 001c _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 00 B5 06 4B 98 42 00 D1 00 BD 83 68 5A 1E 82 60 00 2B F9 DC ?? ?? ?? ?? F6 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_43_2 {
	meta:
		name = "_ZNKSs15_M_check_lengthEmmPKc"
		size = 32
		refs = "0016 _ZSt20__throw_length_errorPKc"
	strings:
		$1 = { 00 B5 00 68 0C 38 00 68 09 1A 04 48 09 18 91 42 00 D3 00 BD 18 1C ?? ?? ?? ?? C0 46 FC FF FF 3F }
	condition:
		$1
}

rule file_48_44_2 {
	meta:
		name = "_ZNSs4_Rep9_S_createEmmRKSaIcE"
		size = 204
		refs = "0026 _Unwind_SjLj_Register 007a _Znwm 008c _Unwind_SjLj_Unregister 00a0 _ZSt20__throw_length_errorPKc 00ae _Unwind_SjLj_Resume 00b4 __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 8F B0 2B 4B 00 AF 3B 62 2B 4B 2B 4A 7B 62 78 60 3B 1C 3C 20 28 33 39 60 C0 19 69 46 B8 62 5A 60 99 60 34 38 ?? ?? ?? ?? 25 4B 7A 68 9A 42 32 D8 7B 68 38 68 83 42 1B D9 79 68 43 00 99 42 00 D2 7B 60 7A 68 78 68 80 23 1D 32 5B 01 0D 30 9A 42 10 D9 3B 68 79 68 8B 42 0C D2 80 20 40 01 0B 18 18 49 0A 40 9A 1A 15 4B 7A 60 9A 42 00 D9 7B 60 78 68 0D 30 01 23 FB 60 ?? ?? ?? ?? 79 68 00 23 38 60 41 60 83 60 38 1C 08 30 ?? ?? ?? ?? BD 46 0F B0 38 68 80 BD 01 23 5B 42 0A 48 FB 60 ?? ?? ?? ?? 3C 3F 01 23 5B 42 38 69 FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FC FF FF 3F FF 0F 00 00 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_45_2 {
	meta:
		name = "_ZNKSs4findEPKcmm"
		size = 100
		refs = "0046 memcmp"
	strings:
		$1 = { F0 B5 57 46 4E 46 45 46 E0 B4 06 68 14 1C 32 1C 0C 3A 17 68 00 2B 20 D0 BB 42 20 D8 FF 1A A7 42 1D D3 0A 78 01 3B 01 31 90 46 8A 46 99 46 03 E0 65 1C AF 42 13 D3 2C 1C 33 5D 43 45 F8 D1 65 1C 70 19 51 46 4A 46 ?? ?? ?? ?? 00 28 F1 D1 20 1C 1C BC 90 46 99 46 A2 46 F0 BD BC 42 F7 D9 01 24 64 42 F4 E7 }
	condition:
		$1
}

rule file_48_46_2 {
	meta:
		name = "_ZNKSs4findERKSsm"
		size = 16
		refs = "000a _ZNKSs4findEPKcmm"
	strings:
		$1 = { 00 B5 09 68 0B 1C 0C 3B 1B 68 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_48_59_2 {
	meta:
		name = "_ZNKSs12find_last_ofERKSsm"
		size = 16
		refs = "000a _ZNKSs12find_last_ofEPKcmm"
	strings:
		$1 = { 00 B5 09 68 0B 1C 0C 3B 1B 68 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_48_61_2 {
	meta:
		name = "_ZNKSs13find_first_ofERKSsm"
		size = 16
		refs = "000a _ZNKSs13find_first_ofEPKcmm"
	strings:
		$1 = { 00 B5 09 68 0B 1C 0C 3B 1B 68 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_48_55_2 {
	meta:
		name = "_ZNKSs16find_last_not_ofERKSsm"
		size = 16
		refs = "000a _ZNKSs16find_last_not_ofEPKcmm"
	strings:
		$1 = { 00 B5 09 68 0B 1C 0C 3B 1B 68 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_48_57_2 {
	meta:
		name = "_ZNKSs17find_first_not_ofERKSsm"
		size = 16
		refs = "000a _ZNKSs17find_first_not_ofEPKcmm"
	strings:
		$1 = { 00 B5 09 68 0B 1C 0C 3B 1B 68 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_48_63_2 {
	meta:
		name = "_ZNKSs5rfindERKSsm"
		size = 16
		refs = "000a _ZNKSs5rfindEPKcmm"
	strings:
		$1 = { 00 B5 09 68 0B 1C 0C 3B 1B 68 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_48_47_2 {
	meta:
		name = "_ZNKSs4findEcm"
		size = 40
		refs = "001c memchr"
	strings:
		$1 = { 10 B5 04 68 23 1C 0C 3B 1B 68 09 06 09 0E 9A 42 02 D3 01 20 40 42 10 BD A0 18 9A 1A ?? ?? ?? ?? 00 28 F6 D0 00 1B F6 E7 }
	condition:
		$1
}

rule file_48_49_2 {
	meta:
		name = "_ZNKSs2atEm"
		size = 28
		refs = "0014 _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { 00 B5 00 68 03 1C 0C 3B 1B 68 99 42 01 D2 40 18 00 BD 01 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_50_2 {
	meta:
		name = "_ZNKSs8_M_checkEmPKc"
		size = 22
		refs = "0012 _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { 00 B5 03 68 0C 3B 1B 68 99 42 01 D8 08 1C 00 BD 10 1C ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_51_2 {
	meta:
		name = "_ZNSs9_M_assignEPcmc"
		size = 24
		refs = "000e memset"
	strings:
		$1 = { 00 B5 0B 1C 11 06 09 0E 01 2B 03 D0 1A 1C ?? ?? ?? ?? 00 BD 01 70 FC E7 }
	condition:
		$1
}

rule file_48_52_2 {
	meta:
		name = "_ZNSs7_M_moveEPcPKcm"
		size = 18
		refs = "0006 memmove"
	strings:
		$1 = { 00 B5 01 2A 02 D0 ?? ?? ?? ?? 00 BD 0B 78 03 70 FB E7 }
	condition:
		$1
}

rule file_48_53_2 {
	meta:
		name = "_ZNSs7_M_copyEPcPKcm"
		size = 18
		refs = "0006 memcpy"
	strings:
		$1 = { 00 B5 01 2A 02 D0 ?? ?? ?? ?? 00 BD 0B 78 03 70 FB E7 }
	condition:
		$1
}

rule file_48_54_2 {
	meta:
		name = "_ZNKSs16find_last_not_ofEPKcmm"
		size = 64
		refs = "0026 memchr"
	strings:
		$1 = { F0 B5 05 68 1E 1C 2B 1C 0C 3B 1B 68 0F 1C 00 2B 10 D0 01 3B 14 1C 9A 42 10 D8 2D 19 00 E0 01 3C 29 78 38 1C 32 1C ?? ?? ?? ?? 00 28 04 D0 01 3D 00 2C F4 D1 01 24 64 42 20 1C F0 BD 1C 1C EC E7 }
	condition:
		$1
}

rule file_48_56_2 {
	meta:
		name = "_ZNKSs17find_first_not_ofEPKcmm"
		size = 64
		refs = "002a memchr"
	strings:
		$1 = { F0 B5 47 46 80 B4 05 68 1F 1C 2B 1C 0C 3B 1E 68 88 46 14 1C B2 42 10 D2 AD 18 03 E0 01 34 01 35 B4 42 0A D2 29 78 40 46 3A 1C ?? ?? ?? ?? 00 28 F4 D1 20 1C 04 BC 90 46 F0 BD 01 24 64 42 F8 E7 }
	condition:
		$1
}

rule file_48_58_2 {
	meta:
		name = "_ZNKSs12find_last_ofEPKcmm"
		size = 70
		refs = "0032 memchr"
	strings:
		$1 = { F0 B5 05 68 1E 1C 2B 1C 0C 3B 0F 1C 1B 68 00 2E 01 D0 00 2B 03 D1 01 24 64 42 20 1C F0 BD 01 3B 14 1C 9A 42 0D D8 2D 19 00 E0 01 3C 29 78 38 1C 32 1C ?? ?? ?? ?? 00 28 EF D1 01 3D 00 2C F4 D1 E9 E7 1C 1C EF E7 }
	condition:
		$1
}

rule file_48_60_2 {
	meta:
		name = "_ZNKSs13find_first_ofEPKcmm"
		size = 64
		refs = "0024 memchr"
	strings:
		$1 = { F0 B5 47 46 80 B4 88 46 14 1C 1F 1C 00 2B 11 D0 05 68 2B 1C 0C 3B 1E 68 B2 42 0B D2 AD 18 29 78 40 46 3A 1C ?? ?? ?? ?? 00 28 05 D1 01 34 01 35 B4 42 F4 D3 01 24 64 42 20 1C 04 BC 90 46 F0 BD }
	condition:
		$1
}

rule file_48_62_2 {
	meta:
		name = "_ZNKSs5rfindEPKcmm"
		size = 62
		refs = "0024 memcmp"
	strings:
		$1 = { F0 B5 05 68 1E 1C 2B 1C 0C 3B 1C 68 0F 1C A6 42 0F D8 A4 1B 94 42 10 D8 2D 19 00 E0 01 3C 28 1C 39 1C 32 1C ?? ?? ?? ?? 00 28 04 D0 01 3D 00 2C F4 D1 01 24 64 42 20 1C F0 BD 14 1C EC E7 }
	condition:
		$1
}

rule file_48_64_2 {
	meta:
		name = "_ZNKSs7compareEmmPKcm"
		size = 72
		refs = "0022 memcmp 0040 _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { 70 B5 00 68 04 1C 0C 3C 24 68 04 9D A1 42 16 D8 66 1A 14 1C B2 42 0C D8 40 18 2A 1C A5 42 06 D8 19 1C ?? ?? ?? ?? 00 28 00 D1 60 1B 70 BD 22 1C F6 E7 34 1C 40 18 2A 1C A5 42 F1 D9 F7 E7 01 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_65_2 {
	meta:
		name = "_ZNKSs7compareEmmRKSsmm"
		size = 108
		refs = "0036 memcmp 0062 _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { F0 B5 00 68 04 1C 0C 3C 24 68 05 9E A1 42 27 D8 1B 68 1D 1C 0C 3D 2F 68 BE 42 21 D8 64 1A 15 1C A2 42 17 D8 06 9C BF 1B BC 42 0C D8 40 18 22 1C 99 19 AC 42 05 D8 ?? ?? ?? ?? 00 28 00 D1 28 1B F0 BD 2A 1C F7 E7 3C 1C 40 18 22 1C 99 19 AC 42 F1 D9 F6 E7 25 1C 06 9C BF 1B BC 42 E6 D9 F2 E7 01 48 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_66_2 {
	meta:
		name = "_ZNKSs7compareEmmRKSs"
		size = 88
		refs = "0028 memcmp 004e _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { 30 B5 00 68 04 1C 0C 3C 24 68 A1 42 1E D8 65 1A 14 1C AA 42 10 D8 1B 68 1A 1C 0C 3A 15 68 40 18 22 1C AC 42 06 D8 19 1C ?? ?? ?? ?? 00 28 00 D1 60 1B 30 BD 2A 1C F6 E7 1B 68 1A 1C 0C 3A 2C 1C 15 68 40 18 22 1C AC 42 ED D9 F3 E7 01 48 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_67_2 {
	meta:
		name = "_ZNKSs7compareERKSs"
		size = 38
		refs = "001a memcmp"
	strings:
		$1 = { 30 B5 00 68 09 68 03 1C 0C 3B 1D 68 0B 1C 0C 3B 1C 68 22 1C AC 42 00 D9 2A 1C ?? ?? ?? ?? 00 28 00 D1 28 1B 30 BD }
	condition:
		$1
}

rule file_48_68_2 {
	meta:
		name = "_ZNKSs7compareEPKc"
		size = 44
		refs = "000e strlen 0020 memcmp"
	strings:
		$1 = { F0 B5 06 68 33 1C 0C 3B 08 1C 0F 1C 1D 68 ?? ?? ?? ?? 04 1C 02 1C A8 42 00 D9 2A 1C 30 1C 39 1C ?? ?? ?? ?? 00 28 00 D1 28 1B F0 BD }
	condition:
		$1
}

rule file_48_69_2 {
	meta:
		name = "_ZNKSs5rfindEPKcm"
		size = 28
		refs = "000a strlen 0016 _ZNKSs5rfindEPKcmm"
	strings:
		$1 = { 70 B5 06 1C 08 1C 15 1C 0C 1C ?? ?? ?? ?? 2A 1C 03 1C 21 1C 30 1C ?? ?? ?? ?? 70 BD }
	condition:
		$1
}

rule file_48_73_2 {
	meta:
		name = "_ZNKSs12find_last_ofEPKcm"
		size = 28
		refs = "000a strlen 0016 _ZNKSs12find_last_ofEPKcmm"
	strings:
		$1 = { 70 B5 06 1C 08 1C 15 1C 0C 1C ?? ?? ?? ?? 2A 1C 03 1C 21 1C 30 1C ?? ?? ?? ?? 70 BD }
	condition:
		$1
}

rule file_48_74_2 {
	meta:
		name = "_ZNKSs13find_first_ofEPKcm"
		size = 28
		refs = "000a strlen 0016 _ZNKSs13find_first_ofEPKcmm"
	strings:
		$1 = { 70 B5 06 1C 08 1C 15 1C 0C 1C ?? ?? ?? ?? 2A 1C 03 1C 21 1C 30 1C ?? ?? ?? ?? 70 BD }
	condition:
		$1
}

rule file_48_71_2 {
	meta:
		name = "_ZNKSs16find_last_not_ofEPKcm"
		size = 28
		refs = "000a strlen 0016 _ZNKSs16find_last_not_ofEPKcmm"
	strings:
		$1 = { 70 B5 06 1C 08 1C 15 1C 0C 1C ?? ?? ?? ?? 2A 1C 03 1C 21 1C 30 1C ?? ?? ?? ?? 70 BD }
	condition:
		$1
}

rule file_48_72_2 {
	meta:
		name = "_ZNKSs17find_first_not_ofEPKcm"
		size = 28
		refs = "000a strlen 0016 _ZNKSs17find_first_not_ofEPKcmm"
	strings:
		$1 = { 70 B5 06 1C 08 1C 15 1C 0C 1C ?? ?? ?? ?? 2A 1C 03 1C 21 1C 30 1C ?? ?? ?? ?? 70 BD }
	condition:
		$1
}

rule file_48_70_2 {
	meta:
		name = "_ZNKSs4findEPKcm"
		size = 28
		refs = "000a strlen 0016 _ZNKSs4findEPKcmm"
	strings:
		$1 = { 70 B5 06 1C 08 1C 15 1C 0C 1C ?? ?? ?? ?? 2A 1C 03 1C 21 1C 30 1C ?? ?? ?? ?? 70 BD }
	condition:
		$1
}

rule file_48_75_2 {
	meta:
		name = "_ZNKSs7compareEmmPKc"
		size = 100
		refs = "0020 strlen 0030 memcmp 005a _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { F0 B5 47 46 80 B4 07 68 98 46 3B 1C 0C 3B 1B 68 0D 1C 99 42 20 D8 5B 1A 14 1C 9A 42 12 D8 40 46 ?? ?? ?? ?? 06 1C 32 1C 78 19 A6 42 08 D8 41 46 ?? ?? ?? ?? 00 28 00 D1 A0 1B 04 BC 90 46 F0 BD 22 1C F4 E7 40 46 1C 1C ?? ?? ?? ?? 06 1C 32 1C 78 19 A6 42 EB D9 F3 E7 01 48 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_76_2 {
	meta:
		name = "_ZNSsD1Ev"
		size = 40
		refs = "001e _ZNSs4_Rep10_M_destroyERKSaIcE 0024 _ZNSs4_Rep20_S_empty_rep_storageE"
		altNames = "_ZNSsD2Ev"
	strings:
		$1 = { 00 B5 00 68 07 4B 0C 38 81 B0 98 42 01 D1 01 B0 00 BD 83 68 5A 1E 82 60 00 2B F8 DC 69 46 ?? ?? ?? ?? F4 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_78_2 {
	meta:
		name = "_ZNSs13_S_copy_charsEPcS_S_"
		size = 20
		refs = "0008 memcpy"
		altNames = "_ZNSs13_S_copy_charsEPcN9__gnu_cxx17__normal_iteratorIPKcSsEES4_ _ZNSs13_S_copy_charsEPcN9__gnu_cxx17__normal_iteratorIS_SsEES2_ _ZNSs13_S_copy_charsEPcPKcS1_"
	strings:
		$1 = { 00 B5 52 1A 01 2A 02 D0 ?? ?? ?? ?? 00 BD 0B 78 03 70 FB E7 }
	condition:
		$1
}

rule file_48_82_2 {
	meta:
		name = "_ZNKSs4copyEPcmm"
		size = 68
		refs = "002e memcpy 003c _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { 10 B5 00 68 04 1C 0C 3C 24 68 A3 42 15 D8 E4 1A 94 42 03 D8 00 2C 04 D1 20 1C 10 BD 14 1C 00 2C FA D0 C3 18 01 2C 05 D0 08 1C 22 1C 19 1C ?? ?? ?? ?? F1 E7 1B 78 0B 70 EE E7 01 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_83_2 {
	meta:
		name = "_ZNSs4_Rep8_M_cloneERKSaIcEm"
		size = 72
		refs = "000e _ZNSs4_Rep9_S_createEmmRKSaIcE 0038 memcpy"
	strings:
		$1 = { 70 B5 0B 1C 01 68 04 1C 50 18 1A 1C 61 68 ?? ?? ?? ?? 22 68 05 1C 00 2A 07 D1 06 1C 0C 36 00 23 AB 60 2A 60 30 1C B3 54 70 BD 06 1C 21 1C 0C 36 0C 31 01 2A 04 D0 30 1C ?? ?? ?? ?? 22 68 EE E7 23 7B 03 73 22 68 EA E7 }
	condition:
		$1
}

rule file_48_84_2 {
	meta:
		name = "_ZNSs4_Rep7_M_grabERKSaIcES2_"
		size = 36
		refs = "0014 _ZNSs4_Rep8_M_cloneERKSaIcEm 0020 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 00 B5 83 68 00 2B 04 DB 05 4A 90 42 05 D1 0C 30 00 BD 00 22 ?? ?? ?? ?? FA E7 01 33 83 60 F6 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_85_2 {
	meta:
		name = "_ZNSs7reserveEm"
		size = 184
		refs = "0028 _Unwind_SjLj_Register 004c _ZNSs4_Rep8_M_cloneERKSaIcEm 0068 _Unwind_SjLj_Unregister 0092 _ZNSs4_Rep10_M_destroyERKSaIcE 00a2 _Unwind_SjLj_Resume 00a8 __gxx_personality_sj0 00b4 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 80 B5 90 B0 28 4B 00 AF 3B 62 40 22 27 4B D2 19 7B 62 BA 62 3B 1C 26 4A 28 33 5A 60 38 60 6A 46 38 1C 9A 60 08 30 79 60 ?? ?? ?? ?? 3B 68 18 68 0C 38 43 68 7A 68 9A 42 1B D0 03 68 7A 68 9A 42 1E D3 39 1C D2 1A 3C 31 01 23 FB 60 ?? ?? ?? ?? 3B 68 78 60 18 68 17 4B 0C 38 98 42 12 D1 7A 68 3B 68 1A 60 38 1C 08 30 ?? ?? ?? ?? BD 46 10 B0 80 BD 83 68 00 2B F5 DD 03 68 7A 68 9A 42 E0 D2 1A 1C DE E7 83 68 5A 1E 82 60 00 2B E7 DC 39 1C 3C 31 ?? ?? ?? ?? E2 E7 40 3F 01 23 5B 42 38 69 FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_86_2 {
	meta:
		name = "_ZNSs9push_backEc"
		size = 66
		refs = "001c _ZNSs7reserveEm"
	strings:
		$1 = { 70 B5 03 68 1A 1C 0C 3A 0E 06 11 68 05 1C 50 68 4C 1C 36 0E 84 42 10 D9 21 1C 28 1C ?? ?? ?? ?? 2B 68 1A 1C 0C 3A 11 68 5E 54 2B 68 0C 3B 00 22 1C 60 1C 19 9A 60 22 73 70 BD 92 68 00 2A EB DC F2 E7 }
	condition:
		$1
}

rule file_48_87_2 {
	meta:
		name = "_ZNSs6appendEmc"
		size = 116
		refs = "0036 _ZNSs7reserveEm 004c memset 0066 _ZSt20__throw_length_errorPKc"
	strings:
		$1 = { F0 B5 17 06 05 1C 0C 1C 3F 0E 00 29 01 D1 28 1C F0 BD 00 68 02 1C 0C 3A 13 68 14 4E 59 42 89 19 8C 42 1F D8 51 68 E6 18 8E 42 02 D8 92 68 00 2A 07 DD 28 1C 31 1C ?? ?? ?? ?? 28 68 03 1C 0C 3B 1B 68 C0 18 01 2C 0B D0 39 1C 22 1C ?? ?? ?? ?? 2B 68 0C 3B 00 22 1E 60 9E 19 9A 60 32 73 D6 E7 07 70 F5 E7 02 48 ?? ?? ?? ?? C0 46 FC FF FF 3F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_88_2 {
	meta:
		name = "_ZNSs6appendEPKcm"
		size = 148
		refs = "003e _ZNSs7reserveEm 0054 memcpy 0086 _ZSt20__throw_length_errorPKc"
	strings:
		$1 = { F0 B5 05 1C 0E 1C 14 1C 00 2A 01 D1 28 1C F0 BD 00 68 02 1C 0C 3A 13 68 1C 4F 59 42 C9 19 8C 42 30 D8 51 68 E7 18 8F 42 02 D8 92 68 00 2A 0C DD 86 42 02 D3 C3 18 9E 42 19 D9 28 1C 39 1C ?? ?? ?? ?? 28 68 03 1C 0C 3B 1B 68 C0 18 01 2C 0B D0 31 1C 22 1C ?? ?? ?? ?? 2B 68 0C 3B 00 22 1F 60 DF 19 9A 60 3A 73 D1 E7 33 78 03 70 F4 E7 36 1A 39 1C 28 1C ?? ?? ?? ?? 28 68 03 1C 0C 3B 86 19 1B 68 E2 E7 02 48 ?? ?? ?? ?? C0 46 FC FF FF 3F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_89_2 {
	meta:
		name = "_ZNSs6appendEPKc"
		size = 24
		refs = "0008 strlen 0012 _ZNSs6appendEPKcm"
		altNames = "_ZNSspLEPKc"
	strings:
		$1 = { 30 B5 05 1C 08 1C 0C 1C ?? ?? ?? ?? 21 1C 02 1C 28 1C ?? ?? ?? ?? 30 BD }
	condition:
		$1
}

rule file_48_130_2 {
	meta:
		name = "_ZNSs6assignEPKc"
		size = 24
		refs = "0008 strlen 0012 _ZNSs6assignEPKcm"
	strings:
		$1 = { 30 B5 05 1C 08 1C 0C 1C ?? ?? ?? ?? 21 1C 02 1C 28 1C ?? ?? ?? ?? 30 BD }
	condition:
		$1
}

rule file_48_132_2 {
	meta:
		name = "_ZNSsaSEPKc"
		size = 24
		refs = "0008 strlen 0012 _ZNSs6assignEPKcm"
	strings:
		$1 = { 30 B5 05 1C 08 1C 0C 1C ?? ?? ?? ?? 21 1C 02 1C 28 1C ?? ?? ?? ?? 30 BD }
	condition:
		$1
}

rule file_48_91_2 {
	meta:
		name = "_ZNSs6appendERKSsmm"
		size = 144
		refs = "0042 _ZNSs7reserveEm 005e memcpy 0088 _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { F0 B5 57 46 46 46 C0 B4 0F 1C 09 68 16 1C 0A 1C 0C 3A 14 68 05 1C A6 42 35 D8 A4 1B 9C 42 2D D8 00 2C 26 D0 2B 68 1A 1C 0C 3A 10 68 A0 46 82 46 50 68 D0 44 80 45 02 D8 92 68 00 2A 09 DD 41 46 28 1C ?? ?? ?? ?? 2B 68 1A 1C 0C 3A 12 68 39 68 92 46 52 46 98 18 89 19 01 2C 11 D0 22 1C ?? ?? ?? ?? 2B 68 00 22 0C 3B 40 46 9A 60 18 60 43 44 1A 73 28 1C 0C BC 90 46 9A 46 F0 BD 1C 1C CF E7 0B 78 03 70 ED E7 01 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_92_2 {
	meta:
		name = "_ZNSs6appendERKSs"
		size = 110
		refs = "0034 _ZNSs7reserveEm 004e memcpy"
	strings:
		$1 = { F0 B5 47 46 80 B4 0E 1C 09 68 0B 1C 0C 3B 1D 68 04 1C 00 2D 24 D0 03 68 1A 1C 0C 3A 10 68 80 46 47 19 50 68 84 46 67 45 02 D8 92 68 00 2A 09 DD 39 1C 20 1C ?? ?? ?? ?? 23 68 1A 1C 0C 3A 12 68 31 68 90 46 42 46 98 18 01 2D 0D D0 2A 1C ?? ?? ?? ?? 23 68 0C 3B 00 22 1F 60 DF 19 9A 60 3A 73 20 1C 04 BC 90 46 F0 BD 0B 78 03 70 F1 E7 }
	condition:
		$1
}

rule file_48_94_2 {
	meta:
		name = "_ZStplIcSt11char_traitsIcESaIcEESbIT_T0_T1_ES3_RKS6_"
		size = 156
		refs = "002e _Unwind_SjLj_Register 0048 _ZNSs7reserveEm 0052 _ZNSs6appendEmc 005a _ZNSs6appendERKSs 0062 _Unwind_SjLj_Unregister 007a _ZNSsD1Ev 0086 _Unwind_SjLj_Resume 008c __gxx_personality_sj0 0098 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 80 B5 90 B0 21 4B 00 AF 7B 62 7A 60 20 4B 40 22 D2 19 BB 62 FA 62 3B 1C 1E 4A 2C 33 5A 60 B8 60 6A 46 09 06 38 1C 09 0E 9A 60 0C 30 39 60 ?? ?? ?? ?? 19 4B BA 68 13 60 7A 68 13 68 0C 3B 19 68 B8 68 01 23 01 31 3B 61 ?? ?? ?? ?? B8 68 01 21 3A 68 ?? ?? ?? ?? B8 68 79 68 ?? ?? ?? ?? 38 1C 0C 30 ?? ?? ?? ?? BD 46 10 B0 B8 68 80 BD 40 3F 7B 69 B8 68 7B 60 00 23 3B 61 ?? ?? ?? ?? 01 23 5B 42 78 68 3B 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_95_2 {
	meta:
		name = "_ZStplIcSt11char_traitsIcESaIcEESbIT_T0_T1_EPKS3_RKS6_"
		size = 160
		refs = "002a _Unwind_SjLj_Register 0030 strlen 004c _ZNSs7reserveEm 0056 _ZNSs6appendEPKcm 005e _ZNSs6appendERKSs 0066 _Unwind_SjLj_Unregister 007e _ZNSsD1Ev 008a _Unwind_SjLj_Resume 0090 __gxx_personality_sj0 009c _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 80 B5 91 B0 22 4B 00 AF BB 62 7A 60 21 4B 44 22 D2 19 FB 62 3A 63 3B 1C 1F 4A 30 33 5A 60 F8 60 6A 46 38 1C 9A 60 10 30 B9 60 ?? ?? ?? ?? B8 68 ?? ?? ?? ?? 19 4B FA 68 13 60 7A 68 13 68 0C 3B 19 68 38 60 41 18 01 23 F8 68 7B 61 ?? ?? ?? ?? F8 68 B9 68 3A 68 ?? ?? ?? ?? F8 68 79 68 ?? ?? ?? ?? 38 1C 10 30 ?? ?? ?? ?? BD 46 11 B0 F8 68 80 BD 44 3F BA 69 00 23 F8 68 7B 61 BA 60 ?? ?? ?? ?? 01 23 5B 42 B8 68 7B 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_96_2 {
	meta:
		name = "_ZNSspLEc"
		size = 66
		refs = "0022 _ZNSs7reserveEm"
	strings:
		$1 = { 70 B5 03 68 0E 06 19 1C 0C 39 0A 68 04 1C 48 68 55 1C 36 0E 85 42 02 D8 89 68 00 29 07 DD 20 1C 29 1C ?? ?? ?? ?? 23 68 1A 1C 0C 3A 12 68 9E 54 23 68 0C 3B 00 22 1D 60 5D 19 9A 60 20 1C 2A 73 70 BD }
	condition:
		$1
}

rule file_48_97_2 {
	meta:
		name = "_ZNSsC1ERKSs"
		size = 136
		refs = "0028 _Unwind_SjLj_Register 0048 _Unwind_SjLj_Unregister 005c _ZNSs4_Rep8_M_cloneERKSaIcEm 0072 _Unwind_SjLj_Resume 0078 __gxx_personality_sj0 0084 _ZNSs4_Rep20_S_empty_rep_storageE"
		altNames = "_ZNSsC2ERKSs"
	strings:
		$1 = { 80 B5 90 B0 1C 4B 00 AF 3B 62 40 22 1B 4B D2 19 7B 62 BA 62 3B 1C 1A 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 39 60 ?? ?? ?? ?? 3B 68 18 68 0C 38 83 68 00 2B 0C DB 12 4A 90 42 11 D1 0C 30 7A 68 10 60 38 1C 08 30 ?? ?? ?? ?? BD 46 10 B0 80 BD 39 1C 01 23 3C 31 00 22 FB 60 ?? ?? ?? ?? EE E7 01 33 83 60 EA E7 40 3F 01 23 5B 42 38 69 FB 60 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_98_2 {
	meta:
		name = "_ZStplIcSt11char_traitsIcESaIcEESbIT_T0_T1_ERKS6_S8_"
		size = 128
		refs = "002a _Unwind_SjLj_Register 0038 _ZNSsC1ERKSs 0044 _ZNSs6appendERKSs 004c _Unwind_SjLj_Unregister 0064 _ZNSsD1Ev 0070 _Unwind_SjLj_Resume 0074 __gxx_personality_sj0"
	strings:
		$1 = { 80 B5 90 B0 1B 4B 00 AF 7B 62 3A 60 1A 4B 40 22 D2 19 BB 62 FA 62 3B 1C 18 4A 2C 33 5A 60 B8 60 6A 46 38 1C 9A 60 0C 30 79 60 ?? ?? ?? ?? 01 23 5B 42 B8 68 79 68 3B 61 ?? ?? ?? ?? 01 23 B8 68 39 68 3B 61 ?? ?? ?? ?? 38 1C 0C 30 ?? ?? ?? ?? BD 46 10 B0 B8 68 80 BD 40 3F 7B 69 B8 68 7B 60 00 23 3B 61 ?? ?? ?? ?? 01 23 5B 42 78 68 3B 61 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_100_2 {
	meta:
		name = "_ZNSs6assignERKSs"
		size = 184
		refs = "0028 _Unwind_SjLj_Register 005a _Unwind_SjLj_Unregister 0070 _ZNSs4_Rep8_M_cloneERKSaIcEm 0094 _ZNSs4_Rep10_M_destroyERKSaIcE 00a4 _Unwind_SjLj_Resume 00a8 __gxx_personality_sj0 00b4 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 80 B5 90 B0 28 4B 00 AF 3B 62 40 22 27 4B D2 19 7B 62 BA 62 3B 1C 26 4A 28 33 5A 60 78 60 6A 46 38 1C 9A 60 08 30 39 60 ?? ?? ?? ?? 7A 68 13 68 3A 68 10 68 83 42 0E D0 0C 38 81 68 00 29 12 DB 1C 4A 90 42 1B D1 0C 30 38 60 0C 3B 93 42 19 D1 3B 68 7A 68 13 60 38 1C 08 30 ?? ?? ?? ?? BD 46 10 B0 78 68 80 BD 39 1C 01 23 3C 31 00 22 FB 60 ?? ?? ?? ?? 7A 68 38 60 13 68 0E 4A E5 E7 01 31 81 60 E0 E7 9A 68 51 1E 99 60 00 2A E0 DC 39 1C 18 1C 3C 31 ?? ?? ?? ?? DA E7 40 3F 01 23 5B 42 38 69 FB 60 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_102_2 {
	meta:
		name = "_ZNSs12_S_constructIPKcEEPcT_S3_RKSaIcESt20forward_iterator_tag"
		size = 100
		refs = "0012 _ZNSs4_Rep9_S_createEmmRKSaIcE 0026 memcpy 0046 _ZSt19__throw_logic_errorPKc 005c _ZNSs4_Rep20_S_empty_rep_storageE"
		altNames = "_ZNSs12_S_constructIPcEES0_T_S1_RKSaIcESt20forward_iterator_tag"
	strings:
		$1 = { F0 B5 04 1C 88 42 19 D0 00 28 19 D0 0D 1A 28 1C 00 21 ?? ?? ?? ?? 07 1C 06 1C 0C 37 01 2D 0A D0 38 1C 21 1C 2A 1C ?? ?? ?? ?? 00 23 B3 60 35 60 7B 55 38 1C F0 BD 23 78 33 73 F6 E7 07 4F F8 E7 00 29 02 D0 06 48 ?? ?? ?? ?? 00 20 00 21 ?? ?? ?? ?? 07 1C 06 1C 0C 37 00 25 E1 E7 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_103_2 {
	meta:
		name = "_ZNSsC1IPKcEET_S2_RKSaIcE"
		size = 20
		refs = "000c _ZNSs12_S_constructIPKcEEPcT_S3_RKSaIcESt20forward_iterator_tag"
		altNames = "_ZNSsC2IPKcEET_S2_RKSaIcE"
	strings:
		$1 = { 10 B5 04 1C 08 1C 11 1C 1A 1C 00 23 ?? ?? ?? ?? 20 60 10 BD }
	condition:
		$1
}

rule file_48_125_2 {
	meta:
		name = "_ZNSsC1IN9__gnu_cxx17__normal_iteratorIPcSsEEEET_S4_RKSaIcE"
		size = 20
		refs = "000c _ZNSs12_S_constructIN9__gnu_cxx17__normal_iteratorIPcSsEEEES2_T_S4_RKSaIcESt20forward_iterator_tag"
	strings:
		$1 = { 10 B5 04 1C 08 1C 11 1C 1A 1C 00 23 ?? ?? ?? ?? 20 60 10 BD }
	condition:
		$1
}

rule file_48_112_2 {
	meta:
		name = "_ZNSsC1IPcEET_S1_RKSaIcE"
		size = 20
		refs = "000c _ZNSs12_S_constructIPcEES0_T_S1_RKSaIcESt20forward_iterator_tag"
	strings:
		$1 = { 10 B5 04 1C 08 1C 11 1C 1A 1C 00 23 ?? ?? ?? ?? 20 60 10 BD }
	condition:
		$1
}

rule file_48_126_2 {
	meta:
		name = "_ZNSsC2IN9__gnu_cxx17__normal_iteratorIPcSsEEEET_S4_RKSaIcE"
		size = 20
		refs = "000c _ZNSs12_S_constructIN9__gnu_cxx17__normal_iteratorIPcSsEEEES2_T_S4_RKSaIcESt20forward_iterator_tag"
	strings:
		$1 = { 10 B5 04 1C 08 1C 11 1C 1A 1C 00 23 ?? ?? ?? ?? 20 60 10 BD }
	condition:
		$1
}

rule file_48_113_2 {
	meta:
		name = "_ZNSsC2IPcEET_S1_RKSaIcE"
		size = 20
		refs = "000c _ZNSs12_S_constructIPcEES0_T_S1_RKSaIcESt20forward_iterator_tag"
	strings:
		$1 = { 10 B5 04 1C 08 1C 11 1C 1A 1C 00 23 ?? ?? ?? ?? 20 60 10 BD }
	condition:
		$1
}

rule file_48_105_2 {
	meta:
		name = "_ZNSsC1ESt16initializer_listIcERKSaIcE"
		size = 20
		refs = "000c _ZNSs12_S_constructIPKcEEPcT_S3_RKSaIcESt20forward_iterator_tag"
		altNames = "_ZNSsC1EPKcmRKSaIcE _ZNSsC2EPKcmRKSaIcE _ZNSsC2ESt16initializer_listIcERKSaIcE"
	strings:
		$1 = { 10 B5 04 1C 08 1C 89 18 1A 1C 00 23 ?? ?? ?? ?? 20 60 10 BD }
	condition:
		$1
}

rule file_48_107_2 {
	meta:
		name = "_ZNSsC1EPKcRKSaIcE"
		size = 40
		refs = "000e strlen 001a _ZNSs12_S_constructIPKcEEPcT_S3_RKSaIcESt20forward_iterator_tag"
		altNames = "_ZNSsC2EPKcRKSaIcE"
	strings:
		$1 = { 70 B5 05 1C 0C 1C 16 1C 00 29 0A D0 08 1C ?? ?? ?? ?? 21 18 32 1C 20 1C 00 23 ?? ?? ?? ?? 28 60 70 BD 01 21 49 42 F5 E7 }
	condition:
		$1
}

rule file_48_114_2 {
	meta:
		name = "_ZNSsC1ERKSsmmRKSaIcE"
		size = 56
		refs = "0020 _ZNSs12_S_constructIPcEES0_T_S1_RKSaIcESt20forward_iterator_tag 002e _ZSt20__throw_out_of_rangePKc"
		altNames = "_ZNSsC2ERKSsmmRKSaIcE"
	strings:
		$1 = { 30 B5 0D 68 29 1C 0C 39 09 68 04 1C 8A 42 0D D8 89 1A A8 18 99 42 07 D8 89 18 69 18 03 9A 00 23 ?? ?? ?? ?? 20 60 30 BD 19 1C F5 E7 01 48 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_116_2 {
	meta:
		name = "_ZNSsC1ERKSsmm"
		size = 160
		refs = "002c _Unwind_SjLj_Register 005c _ZNSs12_S_constructIPcEES0_T_S1_RKSaIcESt20forward_iterator_tag 0068 _Unwind_SjLj_Unregister 007e _ZSt20__throw_out_of_rangePKc 008c _Unwind_SjLj_Resume 0090 __gxx_personality_sj0"
		altNames = "_ZNSsC2ERKSsmm"
	strings:
		$1 = { 80 B5 92 B0 00 AF BB 60 21 4B FA 60 BB 62 48 22 20 4B D2 19 FB 62 3A 63 3B 1C 1F 4A 30 33 5A 60 38 60 6A 46 38 1C 9A 60 10 30 79 60 ?? ?? ?? ?? 7A 68 13 68 1A 1C 0C 3A 11 68 FA 68 8A 42 1A D8 FA 68 98 18 89 1A BA 68 91 42 12 D8 FA 68 89 18 59 18 3A 1C 01 23 7B 61 44 32 00 23 ?? ?? ?? ?? 3B 68 18 60 38 1C 10 30 ?? ?? ?? ?? BD 46 12 B0 80 BD 11 1C EA E7 01 23 5B 42 08 48 7B 61 ?? ?? ?? ?? 48 3F 01 23 5B 42 B8 69 7B 61 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_117_2 {
	meta:
		name = "_ZNKSs6substrEmm"
		size = 36
		refs = "0010 _ZNSsC1ERKSsmm 001a _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { 10 B5 04 1C 08 68 0C 38 00 68 82 42 04 D8 20 1C ?? ?? ?? ?? 20 1C 10 BD 01 48 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_119_2 {
	meta:
		name = "_ZNSs12_S_constructEmcRKSaIcE"
		size = 64
		refs = "0014 _ZNSs4_Rep9_S_createEmmRKSaIcE 0028 memset 003c _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { F0 B5 0F 06 04 1C 3F 0E 00 28 02 D1 0B 4D 28 1C F0 BD 00 21 ?? ?? ?? ?? 05 1C 06 1C 0C 35 01 2C 09 D0 28 1C 39 1C 22 1C ?? ?? ?? ?? 00 23 B3 60 34 60 2B 55 EB E7 37 73 F8 E7 C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_120_2 {
	meta:
		name = "_ZNSsC1EmcRKSaIcE"
		size = 20
		refs = "000c _ZNSs12_S_constructEmcRKSaIcE"
		altNames = "_ZNSsC2EmcRKSaIcE"
	strings:
		$1 = { 10 B5 04 1C 08 1C 11 06 09 0E 1A 1C ?? ?? ?? ?? 20 60 10 BD }
	condition:
		$1
}

rule file_48_122_2 {
	meta:
		name = "_ZNSsC1ERKSaIcE"
		size = 18
		refs = "000a _ZNSs12_S_constructEmcRKSaIcE"
		altNames = "_ZNSsC2ERKSaIcE"
	strings:
		$1 = { 10 B5 04 1C 0A 1C 00 20 00 21 ?? ?? ?? ?? 20 60 10 BD }
	condition:
		$1
}

rule file_48_124_2 {
	meta:
		name = "_ZNSs12_S_constructIN9__gnu_cxx17__normal_iteratorIPcSsEEEES2_T_S4_RKSaIcESt20forward_iterator_tag"
		size = 64
		refs = "000e _ZNSs4_Rep9_S_createEmmRKSaIcE 0022 memcpy 003c _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { F0 B5 07 1C B9 42 14 D0 0C 1A 20 1C 00 21 ?? ?? ?? ?? 05 1C 06 1C 0C 35 01 2C 0C D0 28 1C 39 1C 22 1C ?? ?? ?? ?? 00 23 B3 60 34 60 2B 55 28 1C F0 BD 02 4D FB E7 3B 78 33 73 F4 E7 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_127_2 {
	meta:
		name = "_ZNSs9_M_mutateEmmm"
		size = 332
		refs = "002a _Unwind_SjLj_Register 005c _ZNSs4_Rep9_S_createEmmRKSaIcE 0094 _Unwind_SjLj_Unregister 00c8 memmove 00f2 memcpy 0100 _ZNSs7_M_copyEPcPKcm 0126 _ZNSs4_Rep10_M_destroyERKSaIcE 0136 _Unwind_SjLj_Resume 013c __gxx_personality_sj0 0148 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { B0 B5 95 B0 00 AF BB 60 4C 4B 7B 63 4C 4B F8 60 BB 63 7A 61 3B 1C 4B 4A 54 20 3C 33 39 61 C0 19 69 46 F8 63 5A 60 99 60 38 38 ?? ?? ?? ?? FA 68 14 68 23 1C 0C 3B 78 69 BD 68 1A 68 29 1A 89 18 B9 61 39 69 52 1A 12 1A 7A 60 59 68 BA 69 8A 42 25 D9 3A 1C 01 23 B8 69 50 32 3B 62 ?? ?? ?? ?? 3B 69 38 60 00 2B 47 D1 78 68 00 28 32 D1 FD 68 28 68 35 4B 0C 38 98 42 4E D1 3B 68 F8 68 0C 33 03 60 3B 68 BD 69 00 22 1D 60 9A 60 38 1C 5B 19 1A 73 1C 30 ?? ?? ?? ?? BD 46 15 B0 B0 BD 9A 68 00 2A D6 DC 78 69 B9 68 88 42 EB D0 7A 68 00 2A E8 D0 B9 68 3A 69 7B 69 7D 68 88 18 99 18 20 18 61 18 01 2D 1F D0 7A 68 ?? ?? ?? ?? F9 68 0B 68 0C 3B D7 E7 3A 69 B9 68 38 68 7D 69 8B 18 0C 30 C0 18 AB 18 FA 68 11 68 C9 18 7B 68 01 2B 10 D0 7A 68 ?? ?? ?? ?? BA E7 FD 68 0C 30 29 68 1A 1C ?? ?? ?? ?? B0 E7 0B 78 03 70 F8 68 03 68 0C 3B B8 E7 0B 78 03 70 AA E7 83 68 5A 1E 82 60 00 2B AB DC 39 1C 50 31 ?? ?? ?? ?? A6 E7 54 3F 01 23 5B 42 78 6A 3B 62 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_128_2 {
	meta:
		name = "_ZNSs15_M_replace_safeEmmPKcm"
		size = 48
		refs = "000c _ZNSs9_M_mutateEmmm 0024 memcpy"
	strings:
		$1 = { F0 B5 05 9C 1F 1C 23 1C 05 1C 0E 1C ?? ?? ?? ?? 00 2C 01 D1 28 1C F0 BD 28 68 80 19 01 2C 04 D0 39 1C 22 1C ?? ?? ?? ?? F4 E7 3B 78 03 70 F1 E7 }
	condition:
		$1
}

rule file_48_129_2 {
	meta:
		name = "_ZNSs6assignEPKcm"
		size = 140
		refs = "0022 _ZNSs15_M_replace_safeEmmPKcm 0058 memcpy 006a memmove 0080 _ZSt20__throw_length_errorPKc"
	strings:
		$1 = { 70 B5 05 1C 00 68 0B 1C 1E 4E 01 1C 14 1C 0C 39 81 B0 0A 68 B4 42 32 D8 83 42 08 D2 28 1C 00 21 00 94 ?? ?? ?? ?? 05 1C 01 B0 28 1C 70 BD 86 18 B3 42 F3 D8 8E 68 00 2E F0 DC 1A 1A 94 42 07 D9 00 2A 0E D1 00 23 0C 60 0C 19 8B 60 23 73 EB E7 01 2C 0F D0 19 1C 22 1C ?? ?? ?? ?? 29 68 0C 39 F0 E7 01 2C 06 D0 19 1C 22 1C ?? ?? ?? ?? 29 68 0C 39 E7 E7 1B 78 03 70 29 68 0C 39 E2 E7 02 48 ?? ?? ?? ?? FC FF FF 3F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_131_2 {
	meta:
		name = "_ZNSs6assignERKSsmm"
		size = 44
		refs = "0016 _ZNSs6assignEPKcm 0022 _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { 10 B5 09 68 0C 1C 0C 3C 24 68 A2 42 08 D8 89 18 A2 1A 9A 42 02 D8 ?? ?? ?? ?? 10 BD 1A 1C FA E7 01 48 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_133_2 {
	meta:
		name = "_ZNSs14_M_replace_auxEmmmc"
		size = 84
		refs = "0022 _ZNSs9_M_mutateEmmm 003a memset 0046 _ZSt20__throw_length_errorPKc"
	strings:
		$1 = { F0 B5 1C 1C 03 68 0C 3B 1B 68 0E 1C 05 9F 0F 49 D3 1A 3F 06 5B 18 05 1C 3F 0E 9C 42 12 D8 31 1C 23 1C ?? ?? ?? ?? 00 2C 01 D1 28 1C F0 BD 28 68 80 19 01 2C 04 D0 39 1C 22 1C ?? ?? ?? ?? F4 E7 07 70 F2 E7 02 48 ?? ?? ?? ?? C0 46 FC FF FF 3F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_134_2 {
	meta:
		name = "_ZNSs7replaceEN9__gnu_cxx17__normal_iteratorIPcSsEES2_mc"
		size = 28
		refs = "0014 _ZNSs14_M_replace_auxEmmmc"
	strings:
		$1 = { 30 B5 81 B0 04 9D 0C 1C 01 68 2D 06 2D 0E 61 1A 12 1B 00 95 ?? ?? ?? ?? 01 B0 30 BD }
	condition:
		$1
}

rule file_48_135_2 {
	meta:
		name = "_ZNSs7replaceEmmmc"
		size = 52
		refs = "001e _ZNSs14_M_replace_auxEmmmc 002c _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { 30 B5 81 B0 14 1C 04 9A 12 06 15 0E 02 68 0C 3A 12 68 91 42 09 D8 52 1A A2 42 04 D8 00 95 ?? ?? ?? ?? 01 B0 30 BD 22 1C F8 E7 01 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_136_2 {
	meta:
		name = "_ZNSs6insertEN9__gnu_cxx17__normal_iteratorIPcSsEEc"
		size = 44
		refs = "0016 _ZNSs14_M_replace_auxEmmmc"
	strings:
		$1 = { 30 B5 05 68 12 06 4D 1B 81 B0 12 0E 04 1C 00 92 29 1C 00 22 01 23 ?? ?? ?? ?? 20 68 01 23 02 1C 0C 3A 5B 42 01 B0 40 19 93 60 30 BD }
	condition:
		$1
}

rule file_48_137_2 {
	meta:
		name = "_ZNSs6insertEmmc"
		size = 44
		refs = "001a _ZNSs14_M_replace_auxEmmmc 0024 _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { 10 B5 14 1C 02 68 0C 3A 12 68 1B 06 81 B0 1B 0E 91 42 06 D8 00 93 00 22 23 1C ?? ?? ?? ?? 01 B0 10 BD 01 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_138_2 {
	meta:
		name = "_ZNSs6assignEmc"
		size = 28
		refs = "0014 _ZNSs14_M_replace_auxEmmmc"
	strings:
		$1 = { 00 B5 0B 1C 11 06 02 68 81 B0 09 0E 0C 3A 12 68 00 91 00 21 ?? ?? ?? ?? 01 B0 00 BD }
	condition:
		$1
}

rule file_48_139_2 {
	meta:
		name = "_ZNSs6insertEN9__gnu_cxx17__normal_iteratorIPcSsEEmc"
		size = 28
		refs = "0014 _ZNSs14_M_replace_auxEmmmc"
	strings:
		$1 = { 10 B5 14 1C 1B 06 02 68 81 B0 1B 0E 89 1A 00 93 00 22 23 1C ?? ?? ?? ?? 01 B0 10 BD }
	condition:
		$1
}

rule file_48_140_2 {
	meta:
		name = "_ZNSsaSEc"
		size = 32
		refs = "0016 _ZNSs14_M_replace_auxEmmmc"
	strings:
		$1 = { 10 B5 03 68 09 06 81 B0 09 0E 0C 3B 1A 68 00 91 01 23 00 21 04 1C ?? ?? ?? ?? 01 B0 20 1C 10 BD }
	condition:
		$1
}

rule file_48_141_2 {
	meta:
		name = "_ZNSs5eraseEN9__gnu_cxx17__normal_iteratorIPcSsEES2_"
		size = 34
		refs = "000e _ZNSs9_M_mutateEmmm"
	strings:
		$1 = { 30 B5 05 68 4D 1B 04 1C 52 1A 00 23 29 1C ?? ?? ?? ?? 20 68 01 23 02 1C 0C 3A 5B 42 40 19 93 60 30 BD }
	condition:
		$1
}

rule file_48_142_2 {
	meta:
		name = "_ZNSs5eraseEN9__gnu_cxx17__normal_iteratorIPcSsEE"
		size = 34
		refs = "000e _ZNSs9_M_mutateEmmm"
	strings:
		$1 = { 30 B5 03 68 CD 1A 04 1C 29 1C 01 22 00 23 ?? ?? ?? ?? 20 68 01 23 02 1C 0C 3A 5B 42 40 19 93 60 30 BD }
	condition:
		$1
}

rule file_48_143_2 {
	meta:
		name = "_ZNSs5eraseEmm"
		size = 48
		refs = "001a _ZNSs9_M_mutateEmmm 0028 _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { 10 B5 04 1C 23 68 0C 3B 1B 68 10 1C 99 42 0A D8 5A 1A 82 42 05 D8 20 1C 00 23 ?? ?? ?? ?? 20 1C 10 BD 02 1C F7 E7 01 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_144_2 {
	meta:
		name = "_ZNSs5clearEv"
		size = 18
		refs = "000c _ZNSs9_M_mutateEmmm"
	strings:
		$1 = { 00 B5 03 68 0C 3B 1A 68 00 21 00 23 ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_48_145_2 {
	meta:
		name = "_ZNSs12_M_leak_hardEv"
		size = 48
		refs = "001a _ZNSs9_M_mutateEmmm 002c _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 10 B5 03 68 09 4A 0C 3B 04 1C 93 42 0C D0 9A 68 00 2A 06 DD 00 23 00 21 00 22 ?? ?? ?? ?? 23 68 0C 3B 01 22 52 42 9A 60 10 BD C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_146_2 {
	meta:
		name = "_ZNSs7_M_leakEv"
		size = 18
		refs = "000c _ZNSs12_M_leak_hardEv"
	strings:
		$1 = { 00 B5 03 68 0C 3B 9B 68 00 2B 01 DB ?? ?? ?? ?? 00 BD }
	condition:
		$1
}

rule file_48_147_2 {
	meta:
		name = "_ZNSs2atEm"
		size = 48
		refs = "001a _ZNSs12_M_leak_hardEv 0026 _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { 30 B5 04 1C 00 68 03 1C 0C 3B 1A 68 0D 1C 91 42 08 D2 9B 68 00 2B 03 DB 20 1C ?? ?? ?? ?? 20 68 40 19 30 BD 01 48 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_148_2 {
	meta:
		name = "_ZNSsixEm"
		size = 30
		refs = "0014 _ZNSs12_M_leak_hardEv"
	strings:
		$1 = { 30 B5 04 1C 00 68 03 1C 0C 3B 9B 68 0D 1C 00 2B 03 DB 20 1C ?? ?? ?? ?? 20 68 40 19 30 BD }
	condition:
		$1
}

rule file_48_149_2 {
	meta:
		name = "_ZNSs3endEv"
		size = 32
		refs = "0010 _ZNSs12_M_leak_hardEv"
	strings:
		$1 = { 10 B5 03 68 1A 1C 0C 3A 91 68 04 1C 00 29 04 DB ?? ?? ?? ?? 23 68 1A 1C 0C 3A 10 68 18 18 10 BD }
	condition:
		$1
}

rule file_48_150_2 {
	meta:
		name = "_ZNSs5beginEv"
		size = 26
		refs = "0012 _ZNSs12_M_leak_hardEv"
	strings:
		$1 = { 10 B5 04 1C 00 68 03 1C 0C 3B 9B 68 00 2B 03 DB 20 1C ?? ?? ?? ?? 20 68 10 BD }
	condition:
		$1
}

rule file_48_151_2 {
	meta:
		name = "_ZNSs4rendEv"
		size = 32
		refs = "0014 _ZNSs12_M_leak_hardEv"
	strings:
		$1 = { 30 B5 0B 68 1A 1C 0C 3A 92 68 05 1C 0C 1C 00 2A 03 DB 08 1C ?? ?? ?? ?? 23 68 28 1C 2B 60 30 BD }
	condition:
		$1
}

rule file_48_152_2 {
	meta:
		name = "_ZNSs6rbeginEv"
		size = 40
		refs = "0014 _ZNSs12_M_leak_hardEv"
	strings:
		$1 = { 30 B5 0B 68 1A 1C 0C 3A 0C 1C 91 68 05 1C 00 29 05 DB 20 1C ?? ?? ?? ?? 23 68 1A 1C 0C 3A 12 68 9B 18 28 1C 2B 60 30 BD }
	condition:
		$1
}

rule file_48_153_2 {
	meta:
		name = "_ZNSs7replaceEmmPKcm"
		size = 408
		refs = "002a _Unwind_SjLj_Register 0074 _ZNSs15_M_replace_safeEmmPKcm 007e _Unwind_SjLj_Unregister 00bc _ZNSs9_M_mutateEmmm 00d4 memcpy 010a _ZNSsC1EPKcmRKSaIcE 013c _ZNSs4_Rep10_M_destroyERKSaIcE 014a _ZSt20__throw_out_of_rangePKc 0156 _ZSt20__throw_length_errorPKc 016e _ZNSsD1Ev 017a _Unwind_SjLj_Resume 0180 __gxx_personality_sj0 0190 _ZNSs4_Rep20_S_empty_rep_storageE"
	strings:
		$1 = { 90 B5 96 B0 01 AF 7B 60 5D 4B FB 62 5D 4B 38 61 3B 63 3A 60 3B 1C 5C 4A 54 20 34 33 F9 60 C0 19 69 46 78 63 5A 60 99 60 40 38 ?? ?? ?? ?? 3B 69 1A 68 11 1C 0C 39 0B 68 FC 68 9C 42 00 D9 80 E0 F8 68 3C 68 18 1A B8 60 A0 42 1E D8 BC 68 E0 1A 4E 4C 00 19 3C 6E 84 42 00 D9 78 E0 78 68 90 42 15 D2 39 6E 01 23 5B 42 00 91 BB 61 38 69 F9 68 BA 68 7B 68 ?? ?? ?? ?? 38 61 38 1C 14 30 ?? ?? ?? ?? BD 46 15 B0 38 69 90 BD BC 60 DE E7 D3 18 98 42 E6 D8 8B 68 00 2B E3 DC 7B 68 3C 6E F8 68 19 19 13 18 99 42 18 D8 79 68 8A 1A 7A 60 01 23 5B 42 BB 61 38 69 F9 68 BA 68 3B 6E ?? ?? ?? ?? 3A 69 FB 68 11 68 7C 68 3A 6E C8 18 09 19 01 2A 10 D0 3A 6E ?? ?? ?? ?? CF E7 BC 68 F8 68 79 68 23 18 D3 18 99 42 08 D3 38 6E 8A 1A 03 1B 9B 18 7B 60 DC E7 0B 78 03 70 BF E7 02 23 BB 61 38 1C 3B 1C 50 30 79 68 3A 6E 4C 33 ?? ?? ?? ?? 01 22 3C 6E BA 61 3B 6D 38 69 F9 68 BA 68 00 94 ?? ?? ?? ?? 38 61 38 6D 1A 4B 0C 38 98 42 A5 D0 83 68 5A 1E 82 60 00 2B A0 DC 39 1C 48 31 ?? ?? ?? ?? 9B E7 01 23 5B 42 13 48 BB 61 ?? ?? ?? ?? 01 23 5B 42 10 48 BB 61 ?? ?? ?? ?? 54 3F F8 69 BB 69 38 61 01 2B 05 D0 38 1C 00 23 50 30 BB 61 ?? ?? ?? ?? 01 23 5B 42 38 69 BB 61 ?? ?? ?? ?? C0 46 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FC FF FF 3F ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_154_2 {
	meta:
		name = "_ZNSs7replaceEN9__gnu_cxx17__normal_iteratorIPcSsEES2_NS0_IPKcSsEES5_"
		size = 26
		refs = "0012 _ZNSs7replaceEmmPKcm"
		altNames = "_ZNSs7replaceEN9__gnu_cxx17__normal_iteratorIPcSsEES2_PKcS4_ _ZNSs7replaceEN9__gnu_cxx17__normal_iteratorIPcSsEES2_S1_S1_ _ZNSs7replaceEN9__gnu_cxx17__normal_iteratorIPcSsEES2_S2_S2_"
	strings:
		$1 = { 10 B5 0C 1C 01 68 81 B0 61 1A 12 1B 03 9C E4 1A 00 94 ?? ?? ?? ?? 01 B0 10 BD }
	condition:
		$1
}

rule file_48_158_2 {
	meta:
		name = "_ZNSs7replaceEN9__gnu_cxx17__normal_iteratorIPcSsEES2_PKcm"
		size = 24
		refs = "0010 _ZNSs7replaceEmmPKcm"
	strings:
		$1 = { 10 B5 0C 1C 01 68 81 B0 61 1A 12 1B 03 9C 00 94 ?? ?? ?? ?? 01 B0 10 BD }
	condition:
		$1
}

rule file_48_159_2 {
	meta:
		name = "_ZNSs7replaceEmmPKc"
		size = 36
		refs = "000e strlen 001c _ZNSs7replaceEmmPKcm"
	strings:
		$1 = { F0 B5 81 B0 06 1C 18 1C 0D 1C 17 1C 1C 1C ?? ?? ?? ?? 29 1C 00 90 3A 1C 30 1C 23 1C ?? ?? ?? ?? 01 B0 F0 BD }
	condition:
		$1
}

rule file_48_160_2 {
	meta:
		name = "_ZNSs7replaceEmmRKSsmm"
		size = 52
		refs = "001e _ZNSs7replaceEmmPKcm 002c _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { 70 B5 1B 68 1D 1C 81 B0 0C 3D 05 9C 2D 68 06 9E AC 42 0A D8 1B 19 2C 1B B4 42 04 D8 00 94 ?? ?? ?? ?? 01 B0 70 BD 34 1C F8 E7 01 48 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_161_2 {
	meta:
		name = "_ZNSs7replaceEmmRKSs"
		size = 22
		refs = "000e _ZNSs7replaceEmmPKcm"
	strings:
		$1 = { 10 B5 1B 68 1C 1C 0C 3C 24 68 81 B0 00 94 ?? ?? ?? ?? 01 B0 10 BD }
	condition:
		$1
}

rule file_48_162_2 {
	meta:
		name = "_ZNSs7replaceEN9__gnu_cxx17__normal_iteratorIPcSsEES2_PKc"
		size = 38
		refs = "000e strlen 001e _ZNSs7replaceEmmPKcm"
	strings:
		$1 = { F0 B5 05 1C 81 B0 18 1C 0E 1C 17 1C 1C 1C ?? ?? ?? ?? 29 68 BA 1B 71 1A 00 90 23 1C 28 1C ?? ?? ?? ?? 01 B0 F0 BD }
	condition:
		$1
}

rule file_48_163_2 {
	meta:
		name = "_ZNSs7replaceEN9__gnu_cxx17__normal_iteratorIPcSsEES2_RKSs"
		size = 30
		refs = "0016 _ZNSs7replaceEmmPKcm"
	strings:
		$1 = { 10 B5 0C 1C 1B 68 01 68 12 1B 61 1A 1C 1C 0C 3C 24 68 81 B0 00 94 ?? ?? ?? ?? 01 B0 10 BD }
	condition:
		$1
}

rule file_48_164_2 {
	meta:
		name = "_ZNSs7replaceEN9__gnu_cxx17__normal_iteratorIPcSsEES2_St16initializer_listIcE"
		size = 34
		refs = "0014 _ZNSs7replaceEmmPKcm"
	strings:
		$1 = { 81 B0 10 B5 81 B0 03 93 0C 1C 01 68 12 1B 61 1A 04 9C 00 94 ?? ?? ?? ?? 01 B0 10 BC 08 BC 01 B0 18 47 }
	condition:
		$1
}

rule file_48_165_2 {
	meta:
		name = "_ZNSs6insertEN9__gnu_cxx17__normal_iteratorIPcSsEESt16initializer_listIcE"
		size = 24
		refs = "0010 _ZNSs7replaceEmmPKcm"
	strings:
		$1 = { 10 B5 14 1C 02 68 81 B0 89 1A 00 93 00 22 23 1C ?? ?? ?? ?? 01 B0 10 BD }
	condition:
		$1
}

rule file_48_166_2 {
	meta:
		name = "_ZNSs6assignESt16initializer_listIcE"
		size = 26
		refs = "0012 _ZNSs7replaceEmmPKcm"
	strings:
		$1 = { 00 B5 0B 1C 11 1C 02 68 81 B0 0C 3A 12 68 00 91 00 21 ?? ?? ?? ?? 01 B0 00 BD }
	condition:
		$1
}

rule file_48_167_2 {
	meta:
		name = "_ZNSsaSESt16initializer_listIcE"
		size = 30
		refs = "0014 _ZNSs7replaceEmmPKcm"
	strings:
		$1 = { 10 B5 0B 1C 11 1C 02 68 81 B0 0C 3A 12 68 00 91 00 21 04 1C ?? ?? ?? ?? 01 B0 20 1C 10 BD }
	condition:
		$1
}

rule file_48_168_2 {
	meta:
		name = "_ZNSs6appendESt16initializer_listIcE"
		size = 24
		refs = "0010 _ZNSs7replaceEmmPKcm"
		altNames = "_ZNSspLESt16initializer_listIcE"
	strings:
		$1 = { 00 B5 0B 1C 01 68 81 B0 0C 39 09 68 00 92 00 22 ?? ?? ?? ?? 01 B0 00 BD }
	condition:
		$1
}

rule file_48_170_2 {
	meta:
		name = "_ZNSs6resizeEmc"
		size = 60
		refs = "0020 _ZNSs9_M_mutateEmmm 0028 _ZNSs6appendEmc 0030 _ZSt20__throw_length_errorPKc"
	strings:
		$1 = { 10 B5 03 68 0B 4C 12 06 0C 3B 12 0E 1B 68 A1 42 0D D8 99 42 07 D8 99 42 00 D3 10 BD 5A 1A 00 23 ?? ?? ?? ?? F9 E7 C9 1A ?? ?? ?? ?? F5 E7 02 48 ?? ?? ?? ?? FC FF FF 3F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_172_2 {
	meta:
		name = "_ZNSs6insertEmPKcm"
		size = 208
		refs = "0032 _ZNSs15_M_replace_safeEmmPKcm 0054 _ZNSs9_M_mutateEmmm 0072 memcpy 00be _ZSt20__throw_length_errorPKc 00c4 _ZSt20__throw_out_of_rangePKc"
	strings:
		$1 = { F0 B5 1D 1C 03 68 0E 1C 19 1C 0C 39 17 1C 0A 68 81 B0 04 1C 96 42 54 D8 50 42 84 46 2A 48 84 44 65 45 4B D8 9F 42 0A D2 20 1C 31 1C 00 22 3B 1C 00 95 ?? ?? ?? ?? 04 1C 01 B0 20 1C F0 BD 9A 18 97 42 F1 D8 8A 68 00 2A EE DC 31 1C FF 1A 20 1C 2B 1C 00 22 ?? ?? ?? ?? 23 68 D9 19 9E 19 4B 19 9E 42 18 D2 B1 42 0E D2 77 1A 01 2F 1D D0 30 1C 3A 1C ?? ?? ?? ?? EA 1B F0 19 71 19 01 2A 11 D0 ?? ?? ?? ?? D8 E7 01 2D 12 D0 30 1C 19 1C 2A 1C ?? ?? ?? ?? D0 E7 01 2D 0D D0 30 1C 2A 1C ?? ?? ?? ?? C9 E7 0B 78 03 70 C6 E7 0B 78 33 70 E2 E7 1B 78 33 70 C0 E7 0B 78 33 70 BD E7 03 48 ?? ?? ?? ?? 02 48 ?? ?? ?? ?? FC FF FF 3F ?? ?? ?? ?? }
	condition:
		$1
}

rule file_48_173_2 {
	meta:
		name = "_ZNSs6insertEmPKc"
	