private rule architecture {
	meta:
		bits = 64
		endianness = "little"
		architecture = "x64"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "_clrfp"
		size = 38
		refs = "0005 _get_fpsr 0019 _fclrf"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 89 44 24 20 8B 44 24 20 83 E0 3F 89 44 24 20 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_0_1_0 {
	meta:
		name = "_ctrlfp"
		size = 174
		refs = "000f _get_fpsr 0055 ?dazSupported@?1??_ctrlfp@@9@9 006d _set_fpsr"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 E8 ?? ?? ?? ?? 89 44 24 24 48 8B 44 24 58 48 8B 4C 24 50 48 23 C8 48 8B C1 48 8B 4C 24 58 48 F7 D1 8B 54 24 24 23 D1 8B CA 0B C1 89 44 24 20 8B 44 24 24 25 7F 80 FF FF 8B 4C 24 20 0B C8 8B C1 89 44 24 20 0F BE 05 ?? ?? ?? ?? 85 C0 74 34 8B 44 24 20 83 E0 40 85 C0 74 29 8B 4C 24 20 E8 ?? ?? ?? ?? EB 1C C6 05 ?? ?? ?? ?? 00 8B 44 24 20 83 E0 BF 89 44 24 20 8B 4C 24 20 E8 ?? ?? ?? ?? 90 EB 14 8B 44 24 20 83 E0 BF 89 44 24 20 8B 4C 24 20 E8 ?? ?? ?? ?? 8B 44 24 24 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_0_2_0 {
	meta:
		name = "_ctrlfp$filt$0"
		size = 71
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 89 4D 30 48 8B 45 30 48 8B 00 8B 00 89 45 28 8B 45 28 3D 05 00 00 C0 74 13 8B 45 28 3D 1D 00 00 C0 74 09 C7 45 2C 00 00 00 00 EB 07 C7 45 2C 01 00 00 00 8B 45 2C 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_0_3_0 {
	meta:
		name = "_set_statfp"
		size = 55
		refs = "000a _get_fpsr 002e _set_fpsr"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 E8 ?? ?? ?? ?? 89 44 24 20 48 8B 44 24 40 48 83 E0 3F 8B 4C 24 20 48 0B C8 48 8B C1 89 44 24 20 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_0_4_0 {
	meta:
		name = "_statfp"
		size = 33
		refs = "0005 _get_fpsr"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 89 44 24 20 8B 44 24 20 83 E0 3F 89 44 24 20 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "_LCmulcc"
		size = 288
		refs = "0035 creall 005c cimagl 00f8 _LCbuild"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC 98 00 00 00 48 8D 44 24 40 48 8B F8 48 8B B4 24 B8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 40 E8 ?? ?? ?? ?? F2 0F 11 44 24 30 48 8D 44 24 70 48 8B F8 48 8B B4 24 B8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 70 E8 ?? ?? ?? ?? F2 0F 11 44 24 28 48 8D 44 24 50 48 8B F8 48 8B B4 24 C0 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 50 E8 ?? ?? ?? ?? F2 0F 11 44 24 20 48 8D 44 24 60 48 8B F8 48 8B B4 24 C0 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 60 E8 ?? ?? ?? ?? F2 0F 11 44 24 38 F2 0F 10 44 24 30 F2 0F 59 44 24 38 F2 0F 10 4C 24 28 F2 0F 59 4C 24 20 F2 0F 58 C1 F2 0F 10 4C 24 30 F2 0F 59 4C 24 20 F2 0F 10 54 24 28 F2 0F 59 54 24 38 F2 0F 5C CA 0F 28 D0 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 B0 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 B0 00 00 00 48 81 C4 98 00 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_888_0_0 {
	meta:
		name = "_Cmulcc"
		size = 288
		refs = "0035 creal 005c cimag 00f8 _Cbuild"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC 98 00 00 00 48 8D 44 24 40 48 8B F8 48 8B B4 24 B8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 40 E8 ?? ?? ?? ?? F2 0F 11 44 24 30 48 8D 44 24 70 48 8B F8 48 8B B4 24 B8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 70 E8 ?? ?? ?? ?? F2 0F 11 44 24 28 48 8D 44 24 50 48 8B F8 48 8B B4 24 C0 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 50 E8 ?? ?? ?? ?? F2 0F 11 44 24 20 48 8D 44 24 60 48 8B F8 48 8B B4 24 C0 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 60 E8 ?? ?? ?? ?? F2 0F 11 44 24 38 F2 0F 10 44 24 30 F2 0F 59 44 24 38 F2 0F 10 4C 24 28 F2 0F 59 4C 24 20 F2 0F 58 C1 F2 0F 10 4C 24 30 F2 0F 59 4C 24 20 F2 0F 10 54 24 28 F2 0F 59 54 24 38 F2 0F 5C CA 0F 28 D0 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 B0 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 B0 00 00 00 48 81 C4 98 00 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_1_1_0 {
	meta:
		name = "_LCmulcr"
		size = 167
		refs = "0033 cimagl 0063 creall 0082 _LCbuild"
	strings:
		$1 = { F2 0F 11 54 24 18 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 68 48 8D 44 24 30 48 8B F8 48 8B B4 24 88 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 30 E8 ?? ?? ?? ?? F2 0F 59 84 24 90 00 00 00 F2 0F 11 44 24 20 48 8D 44 24 40 48 8B F8 48 8B B4 24 88 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 40 E8 ?? ?? ?? ?? F2 0F 59 84 24 90 00 00 00 F2 0F 10 4C 24 20 0F 28 D1 0F 28 C8 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8B BC 24 80 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 80 00 00 00 48 83 C4 68 5F 5E C3 }
	condition:
		$1
}

rule file_888_1_0 {
	meta:
		name = "_Cmulcr"
		size = 167
		refs = "0033 cimag 0063 creal 0082 _Cbuild"
	strings:
		$1 = { F2 0F 11 54 24 18 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 68 48 8D 44 24 30 48 8B F8 48 8B B4 24 88 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 30 E8 ?? ?? ?? ?? F2 0F 59 84 24 90 00 00 00 F2 0F 11 44 24 20 48 8D 44 24 40 48 8B F8 48 8B B4 24 88 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 40 E8 ?? ?? ?? ?? F2 0F 59 84 24 90 00 00 00 F2 0F 10 4C 24 20 0F 28 D1 0F 28 C8 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8B BC 24 80 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 80 00 00 00 48 83 C4 68 5F 5E C3 }
	condition:
		$1
}

rule file_1_2_0 {
	meta:
		name = "cpowl"
		size = 627
		refs = "003b cimagl 0043 __real@0000000000000000 007a clogl 00c0 _LCmulcc 00ea cexpl 016c creall 0171 logl 019d _LCmulcr 0238 powl 024b _LCbuild"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC 48 01 00 00 48 8D 84 24 C0 00 00 00 48 8B F8 48 8B B4 24 68 01 00 00 B9 10 00 00 00 F3 A4 48 8D 8C 24 C0 00 00 00 E8 ?? ?? ?? ?? 66 0F 2E 05 ?? ?? ?? ?? 7A 06 0F 84 C3 00 00 00 48 8D 84 24 90 00 00 00 48 8B F8 48 8B B4 24 68 01 00 00 B9 10 00 00 00 F3 A4 48 8D 94 24 90 00 00 00 48 8D 8C 24 E0 00 00 00 E8 ?? ?? ?? ?? 48 8D 4C 24 60 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 84 24 B0 00 00 00 48 8B F8 48 8B B4 24 70 01 00 00 B9 10 00 00 00 F3 A4 4C 8D 44 24 60 48 8D 94 24 B0 00 00 00 48 8D 8C 24 00 01 00 00 E8 ?? ?? ?? ?? 48 8D 8C 24 80 00 00 00 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 94 24 80 00 00 00 48 8D 8C 24 20 01 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 60 01 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 60 01 00 00 E9 5C 01 00 00 E9 57 01 00 00 48 8D 84 24 D0 00 00 00 48 8B F8 48 8B B4 24 70 01 00 00 B9 10 00 00 00 F3 A4 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 66 0F 2E 05 ?? ?? ?? ?? 7A 06 0F 84 A0 00 00 00 48 8D 84 24 A0 00 00 00 48 8B F8 48 8B B4 24 68 01 00 00 B9 10 00 00 00 F3 A4 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 44 24 30 48 8B F8 48 8B B4 24 70 01 00 00 B9 10 00 00 00 F3 A4 0F 28 D0 48 8D 54 24 30 48 8D 8C 24 F0 00 00 00 E8 ?? ?? ?? ?? 48 8D 4C 24 40 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 54 24 40 48 8D 8C 24 10 01 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 60 01 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 60 01 00 00 E9 85 00 00 00 E9 80 00 00 00 48 8D 44 24 50 48 8B F8 48 8B B4 24 70 01 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 50 E8 ?? ?? ?? ?? F2 0F 11 44 24 20 48 8D 44 24 70 48 8B F8 48 8B B4 24 68 01 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 70 E8 ?? ?? ?? ?? F2 0F 10 4C 24 20 E8 ?? ?? ?? ?? 0F 57 D2 0F 28 C8 48 8D 8C 24 30 01 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 60 01 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 60 01 00 00 48 81 C4 48 01 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_888_2_0 {
	meta:
		name = "cpow"
		size = 627
		refs = "003b cimag 0043 __real@0000000000000000 007a clog 00c0 _Cmulcc 00ea cexp 016c creal 0171 log 019d _Cmulcr 0238 pow 024b _Cbuild"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC 48 01 00 00 48 8D 84 24 C0 00 00 00 48 8B F8 48 8B B4 24 68 01 00 00 B9 10 00 00 00 F3 A4 48 8D 8C 24 C0 00 00 00 E8 ?? ?? ?? ?? 66 0F 2E 05 ?? ?? ?? ?? 7A 06 0F 84 C3 00 00 00 48 8D 84 24 90 00 00 00 48 8B F8 48 8B B4 24 68 01 00 00 B9 10 00 00 00 F3 A4 48 8D 94 24 90 00 00 00 48 8D 8C 24 E0 00 00 00 E8 ?? ?? ?? ?? 48 8D 4C 24 60 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 84 24 B0 00 00 00 48 8B F8 48 8B B4 24 70 01 00 00 B9 10 00 00 00 F3 A4 4C 8D 44 24 60 48 8D 94 24 B0 00 00 00 48 8D 8C 24 00 01 00 00 E8 ?? ?? ?? ?? 48 8D 8C 24 80 00 00 00 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 94 24 80 00 00 00 48 8D 8C 24 20 01 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 60 01 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 60 01 00 00 E9 5C 01 00 00 E9 57 01 00 00 48 8D 84 24 D0 00 00 00 48 8B F8 48 8B B4 24 70 01 00 00 B9 10 00 00 00 F3 A4 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? 66 0F 2E 05 ?? ?? ?? ?? 7A 06 0F 84 A0 00 00 00 48 8D 84 24 A0 00 00 00 48 8B F8 48 8B B4 24 68 01 00 00 B9 10 00 00 00 F3 A4 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 44 24 30 48 8B F8 48 8B B4 24 70 01 00 00 B9 10 00 00 00 F3 A4 0F 28 D0 48 8D 54 24 30 48 8D 8C 24 F0 00 00 00 E8 ?? ?? ?? ?? 48 8D 4C 24 40 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 54 24 40 48 8D 8C 24 10 01 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 60 01 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 60 01 00 00 E9 85 00 00 00 E9 80 00 00 00 48 8D 44 24 50 48 8B F8 48 8B B4 24 70 01 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 50 E8 ?? ?? ?? ?? F2 0F 11 44 24 20 48 8D 44 24 70 48 8B F8 48 8B B4 24 68 01 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 70 E8 ?? ?? ?? ?? F2 0F 10 4C 24 20 E8 ?? ?? ?? ?? 0F 57 D2 0F 28 C8 48 8D 8C 24 30 01 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 60 01 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 60 01 00 00 48 81 C4 48 01 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_1_3_0 {
	meta:
		name = "logl"
		size = 26
		refs = "0011 log"
		altNames = "?log@@YAOO@Z"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_568_61_0 {
	meta:
		name = "?abs@@YANN@Z"
		size = 26
		refs = "0011 fabs"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_667_1_0 {
	meta:
		name = "cosl"
		size = 26
		refs = "0011 cos"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_482_2_0 {
	meta:
		name = "expl"
		size = 26
		refs = "0011 exp"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1033_1_0 {
	meta:
		name = "sinhl"
		size = 26
		refs = "0011 sinh"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_667_2_0 {
	meta:
		name = "sinl"
		size = 26
		refs = "0011 sin"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_90_13_3 {
	meta:
		name = "sqrtl"
		size = 26
		refs = "0011 sqrt"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1033_3_0 {
	meta:
		name = "tanl"
		size = 26
		refs = "0011 tan"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_4_0 {
	meta:
		name = "powl"
		size = 38
		refs = "001d pow"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 4C 24 38 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "atan2l"
		size = 38
		refs = "001d atan2"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 4C 24 38 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1309_3_0 {
	meta:
		name = "fmodl"
		size = 38
		refs = "001d fmod"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 4C 24 38 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_110_466_1 {
	meta:
		name = "hypot"
		size = 38
		refs = "001d _hypot"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 4C 24 38 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1290_1_0 {
	meta:
		name = "hypotl"
		size = 38
		refs = "001d _hypot"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 4C 24 38 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "nextafter"
		size = 38
		refs = "001d nexttoward"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 4C 24 38 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1155_0_0 {
	meta:
		name = "nextafterl"
		size = 38
		refs = "001d nexttowardl"
	strings:
		$1 = { F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 28 F2 0F 10 4C 24 38 F2 0F 10 44 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "_CrtDefaultAllocHook"
		size = 25
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "scalbnl"
		size = 104
		refs = "001b _ldtest 002e _ldscale 004d _fperrraise"
		altNames = "scalblnl"
	strings:
		$1 = { 89 54 24 10 F2 0F 11 44 24 08 48 83 EC 38 83 7C 24 48 00 74 48 48 8D 4C 24 40 E8 ?? ?? ?? ?? 98 85 C0 7D 39 8B 54 24 48 48 8D 4C 24 40 E8 ?? ?? ?? ?? 98 89 44 24 20 83 7C 24 20 00 74 09 83 7C 24 20 01 74 0E EB 16 B9 10 00 00 00 E8 ?? ?? ?? ?? EB 0A B9 08 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1151_0_0 {
	meta:
		name = "scalbln"
		size = 104
		refs = "001b _dtest 002e _dscale 004d _fperrraise"
	strings:
		$1 = { 89 54 24 10 F2 0F 11 44 24 08 48 83 EC 38 83 7C 24 48 00 74 48 48 8D 4C 24 40 E8 ?? ?? ?? ?? 98 85 C0 7D 39 8B 54 24 48 48 8D 4C 24 40 E8 ?? ?? ?? ?? 98 89 44 24 20 83 7C 24 20 00 74 09 83 7C 24 20 01 74 0E EB 16 B9 10 00 00 00 E8 ?? ?? ?? ?? EB 0A B9 08 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_621_0_0 {
	meta:
		name = "scalbn"
		size = 104
		refs = "001b _dtest 002e _dscale 004d _fperrraise"
	strings:
		$1 = { 89 54 24 10 F2 0F 11 44 24 08 48 83 EC 38 83 7C 24 48 00 74 48 48 8D 4C 24 40 E8 ?? ?? ?? ?? 98 85 C0 7D 39 8B 54 24 48 48 8D 4C 24 40 E8 ?? ?? ?? ?? 98 89 44 24 20 83 7C 24 20 00 74 09 83 7C 24 20 01 74 0E EB 16 B9 10 00 00 00 E8 ?? ?? ?? ?? EB 0A B9 08 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "remquo"
		size = 798
		refs = "001b _dtest 00a5 _fperrraise 00ad _Nan_C 00dc __xmm@80000000000000008000000000000000 0154 _dunscale 01d4 _dscale 0238 __real@0000000000000000 0242 __real@3fe0000000000000"
	strings:
		$1 = { 4C 89 44 24 18 F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 68 48 8D 4C 24 70 E8 ?? ?? ?? ?? 66 89 44 24 2C 48 8D 4C 24 78 E8 ?? ?? ?? ?? 66 89 44 24 28 48 83 BC 24 80 00 00 00 00 74 0E 48 8B 84 24 80 00 00 00 C7 00 00 00 00 00 0F BF 44 24 2C 85 C0 7D 09 0F BF 44 24 28 85 C0 7C 6A 0F BF 44 24 2C 83 F8 02 75 0D F2 0F 10 44 24 70 E9 A6 02 00 00 EB 4E 0F BF 44 24 28 83 F8 02 75 0D F2 0F 10 44 24 78 E9 8F 02 00 00 EB 37 0F BF 44 24 2C 83 F8 01 74 09 0F BF 44 24 28 85 C0 75 19 B9 01 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? E9 63 02 00 00 EB 0B F2 0F 10 44 24 70 E9 56 02 00 00 E9 51 02 00 00 0F 57 C0 66 0F 2F 44 24 78 76 1F F2 0F 10 44 24 78 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 78 B8 01 00 00 00 66 89 44 24 24 EB 07 33 C0 66 89 44 24 24 0F 57 C0 66 0F 2F 44 24 70 76 32 F2 0F 10 44 24 70 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 70 B8 01 00 00 00 66 89 44 24 34 0F BF 44 24 24 B9 01 00 00 00 2B C8 8B C1 66 89 44 24 24 EB 07 33 C0 66 89 44 24 34 F2 0F 10 44 24 78 F2 0F 11 44 24 38 48 8D 54 24 38 48 8D 4C 24 44 E8 ?? ?? ?? ?? C7 44 24 20 00 00 00 00 C7 44 24 30 00 00 00 00 F2 0F 10 44 24 70 F2 0F 11 44 24 38 83 7C 24 20 00 7C 2B 48 8D 54 24 38 48 8D 4C 24 40 E8 ?? ?? ?? ?? 98 85 C0 74 17 0F BF 44 24 40 0F BF 4C 24 44 2B C1 89 44 24 20 83 7C 24 20 00 7D 05 E9 83 00 00 00 EB 0A 8B 44 24 20 FF C8 89 44 24 20 83 7C 24 20 00 7C 6B F2 0F 10 44 24 78 F2 0F 11 44 24 38 8B 54 24 20 48 8D 4C 24 38 E8 ?? ?? ?? ?? F2 0F 10 44 24 70 66 0F 2F 44 24 38 72 41 F2 0F 10 44 24 70 F2 0F 5C 44 24 38 F2 0F 11 44 24 70 48 63 44 24 20 48 83 F8 20 73 22 8B 44 24 20 B9 01 00 00 00 89 4C 24 50 0F B6 C8 8B 44 24 50 D3 E0 8B 4C 24 30 03 C8 8B C1 89 44 24 30 EB 02 EB 84 E9 3A FF FF FF F2 0F 10 44 24 70 66 0F 2F 05 ?? ?? ?? ?? 76 69 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 44 24 78 F2 0F 11 44 24 38 F2 0F 10 44 24 70 66 0F 2F 44 24 38 76 10 F2 0F 10 44 24 38 66 0F 2F 05 ?? ?? ?? ?? 77 1B F2 0F 10 44 24 38 66 0F 2E 44 24 70 7A 29 75 27 8B 44 24 30 83 E0 01 85 C0 74 1C F2 0F 10 44 24 70 F2 0F 5C 44 24 78 F2 0F 11 44 24 70 8B 44 24 30 FF C0 89 44 24 30 48 83 BC 24 80 00 00 00 00 74 37 8B 44 24 30 0F BA F0 1F 89 44 24 48 0F BF 44 24 24 85 C0 74 0C 8B 44 24 48 F7 D8 89 44 24 4C EB 08 8B 44 24 48 89 44 24 4C 48 8B 84 24 80 00 00 00 8B 4C 24 4C 89 08 0F BF 44 24 34 85 C0 74 15 F2 0F 10 44 24 70 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 58 EB 0C F2 0F 10 44 24 70 F2 0F 11 44 24 58 F2 0F 10 44 24 58 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_1102_0_0 {
	meta:
		name = "remquol"
		size = 798
		refs = "001b _ldtest 00a5 _fperrraise 00ad _LNan_C 00dc __xmm@80000000000000008000000000000000 0154 _ldunscale 01d4 _ldscale 0238 __real@0000000000000000 0242 __real@3fe0000000000000"
	strings:
		$1 = { 4C 89 44 24 18 F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 83 EC 68 48 8D 4C 24 70 E8 ?? ?? ?? ?? 66 89 44 24 2C 48 8D 4C 24 78 E8 ?? ?? ?? ?? 66 89 44 24 28 48 83 BC 24 80 00 00 00 00 74 0E 48 8B 84 24 80 00 00 00 C7 00 00 00 00 00 0F BF 44 24 2C 85 C0 7D 09 0F BF 44 24 28 85 C0 7C 6A 0F BF 44 24 2C 83 F8 02 75 0D F2 0F 10 44 24 70 E9 A6 02 00 00 EB 4E 0F BF 44 24 28 83 F8 02 75 0D F2 0F 10 44 24 78 E9 8F 02 00 00 EB 37 0F BF 44 24 2C 83 F8 01 74 09 0F BF 44 24 28 85 C0 75 19 B9 01 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? E9 63 02 00 00 EB 0B F2 0F 10 44 24 70 E9 56 02 00 00 E9 51 02 00 00 0F 57 C0 66 0F 2F 44 24 78 76 1F F2 0F 10 44 24 78 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 78 B8 01 00 00 00 66 89 44 24 24 EB 07 33 C0 66 89 44 24 24 0F 57 C0 66 0F 2F 44 24 70 76 32 F2 0F 10 44 24 70 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 70 B8 01 00 00 00 66 89 44 24 34 0F BF 44 24 24 B9 01 00 00 00 2B C8 8B C1 66 89 44 24 24 EB 07 33 C0 66 89 44 24 34 F2 0F 10 44 24 78 F2 0F 11 44 24 38 48 8D 54 24 38 48 8D 4C 24 44 E8 ?? ?? ?? ?? C7 44 24 20 00 00 00 00 C7 44 24 30 00 00 00 00 F2 0F 10 44 24 70 F2 0F 11 44 24 38 83 7C 24 20 00 7C 2B 48 8D 54 24 38 48 8D 4C 24 40 E8 ?? ?? ?? ?? 98 85 C0 74 17 0F BF 44 24 40 0F BF 4C 24 44 2B C1 89 44 24 20 83 7C 24 20 00 7D 05 E9 83 00 00 00 EB 0A 8B 44 24 20 FF C8 89 44 24 20 83 7C 24 20 00 7C 6B F2 0F 10 44 24 78 F2 0F 11 44 24 38 8B 54 24 20 48 8D 4C 24 38 E8 ?? ?? ?? ?? F2 0F 10 44 24 70 66 0F 2F 44 24 38 72 41 F2 0F 10 44 24 70 F2 0F 5C 44 24 38 F2 0F 11 44 24 70 48 63 44 24 20 48 83 F8 20 73 22 8B 44 24 20 B9 01 00 00 00 89 4C 24 50 0F B6 C8 8B 44 24 50 D3 E0 8B 4C 24 30 03 C8 8B C1 89 44 24 30 EB 02 EB 84 E9 3A FF FF FF F2 0F 10 44 24 70 66 0F 2F 05 ?? ?? ?? ?? 76 69 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 44 24 78 F2 0F 11 44 24 38 F2 0F 10 44 24 70 66 0F 2F 44 24 38 76 10 F2 0F 10 44 24 38 66 0F 2F 05 ?? ?? ?? ?? 77 1B F2 0F 10 44 24 38 66 0F 2E 44 24 70 7A 29 75 27 8B 44 24 30 83 E0 01 85 C0 74 1C F2 0F 10 44 24 70 F2 0F 5C 44 24 78 F2 0F 11 44 24 70 8B 44 24 30 FF C0 89 44 24 30 48 83 BC 24 80 00 00 00 00 74 37 8B 44 24 30 0F BA F0 1F 89 44 24 48 0F BF 44 24 24 85 C0 74 0C 8B 44 24 48 F7 D8 89 44 24 4C EB 08 8B 44 24 48 89 44 24 4C 48 8B 84 24 80 00 00 00 8B 4C 24 4C 89 08 0F BF 44 24 34 85 C0 74 15 F2 0F 10 44 24 70 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 58 EB 0C F2 0F 10 44 24 70 F2 0F 11 44 24 58 F2 0F 10 44 24 58 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_6_6_0 {
	meta:
		name = "??$swap@PEAU_Node@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@@std@@YAXAEAPEAU_Node@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@0@Z"
		size = 79
		refs = "0014 ??$_Move@AEAPEAU_Node@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@@std@@YA$$QEAPEAU_Node@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@AEAPEAU12345@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 89 44 24 20 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B 00 48 89 01 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 89 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_58_363_3 {
	meta:
		name = "??$swap@PEAU?$_Task_impl@E@details@Concurrency@@@std@@YAXAEAPEAU?$_Task_impl@E@details@Concurrency@@0@Z"
		size = 79
		refs = "0014 ??$_Move@AEAPEAU?$_Task_impl@E@details@Concurrency@@@std@@YA$$QEAPEAU?$_Task_impl@E@details@Concurrency@@AEAPEAU123@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 89 44 24 20 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B 00 48 89 01 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 89 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_58_364_3 {
	meta:
		name = "??$swap@PEAU?$_Task_impl@_N@details@Concurrency@@@std@@YAXAEAPEAU?$_Task_impl@_N@details@Concurrency@@0@Z"
		size = 79
		refs = "0014 ??$_Move@AEAPEAU?$_Task_impl@_N@details@Concurrency@@@std@@YA$$QEAPEAU?$_Task_impl@_N@details@Concurrency@@AEAPEAU123@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 89 44 24 20 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B 00 48 89 01 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 89 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_62_356_2 {
	meta:
		name = "??$swap@PEAU_Container_proxy@std@@@std@@YAXAEAPEAU_Container_proxy@0@0@Z"
		size = 79
		refs = "0014 ??$_Move@AEAPEAU_Container_proxy@std@@@std@@YA$$QEAPEAU_Container_proxy@0@AEAPEAU10@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 89 44 24 20 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B 00 48 89 01 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 89 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_108_339_1 {
	meta:
		name = "??$swap@PEAU_ExceptionHolder@details@Concurrency@@@std@@YAXAEAPEAU_ExceptionHolder@details@Concurrency@@0@Z"
		size = 79
		refs = "0014 ??$_Move@AEAPEAU_ExceptionHolder@details@Concurrency@@@std@@YA$$QEAPEAU_ExceptionHolder@details@Concurrency@@AEAPEAU123@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 89 44 24 20 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B 00 48 89 01 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 89 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_108_341_1 {
	meta:
		name = "??$swap@PEAUscheduler_interface@Concurrency@@@std@@YAXAEAPEAUscheduler_interface@Concurrency@@0@Z"
		size = 79
		refs = "0014 ??$_Move@AEAPEAUscheduler_interface@Concurrency@@@std@@YA$$QEAPEAUscheduler_interface@Concurrency@@AEAPEAU12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 89 44 24 20 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B 00 48 89 01 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 89 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_108_342_1 {
	meta:
		name = "??$swap@PEAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@YAXAEAPEAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@0@Z"
		size = 79
		refs = "0014 ??$_Move@AEAPEAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@YA$$QEAPEAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@0@AEAPEAV10@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 89 44 24 20 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B 00 48 89 01 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 89 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_108_343_1 {
	meta:
		name = "??$swap@PEAV?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@YAXAEAPEAV?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@0@Z"
		size = 79
		refs = "0014 ??$_Move@AEAPEAV?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@YA$$QEAPEAV?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@0@AEAPEAV10@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 89 44 24 20 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B 00 48 89 01 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 89 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_71_16_3 {
	meta:
		name = "??$swap@PEAV_Concurrent_queue_rep@details@Concurrency@@@std@@YAXAEAPEAV_Concurrent_queue_rep@details@Concurrency@@0@Z"
		size = 79
		refs = "0014 ??$_Move@AEAPEAV_Concurrent_queue_rep@details@Concurrency@@@std@@YA$$QEAPEAV_Concurrent_queue_rep@details@Concurrency@@AEAPEAV123@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 89 44 24 20 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B 00 48 89 01 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 89 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_62_362_2 {
	meta:
		name = "??$swap@PEAV_Ref_count_base@std@@@std@@YAXAEAPEAV_Ref_count_base@0@0@Z"
		size = 79
		refs = "0014 ??$_Move@AEAPEAV_Ref_count_base@std@@@std@@YA$$QEAPEAV_Ref_count_base@0@AEAPEAV10@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 89 44 24 20 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B 00 48 89 01 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 89 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_934_26_0 {
	meta:
		name = "??$swap@PEAV__ExceptionPtr@@@std@@YAXAEAPEAV__ExceptionPtr@@0@Z"
		size = 79
		refs = "0014 ??$_Move@AEAPEAV__ExceptionPtr@@@std@@YA$$QEAPEAV__ExceptionPtr@@AEAPEAV1@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 00 48 89 44 24 20 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B 00 48 89 01 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 00 48 89 01 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_6_8_0 {
	meta:
		name = "??0SchedulerPolicy@Concurrency@@QEAA@AEBV01@@Z"
		size = 104
		refs = "0029 ??_C@_0DI@PPADFCII@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0038 ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 0059 ?_Assign@SchedulerPolicy@Concurrency@@AEAAXAEBV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 57 48 83 EC 30 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 41 B9 80 00 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 20 B9 28 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8B 44 24 40 48 8B 4C 24 28 48 89 08 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 30 5F C3 }
	condition:
		$1
}

rule file_6_9_0 {
	meta:
		name = "??0SchedulerPolicy@Concurrency@@QEAA@XZ"
		size = 34
		refs = "0014 ?_Initialize@SchedulerPolicy@Concurrency@@AEAAX_KPEAPEAD@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 45 33 C0 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_10_0 {
	meta:
		name = "??0SchedulerPolicy@Concurrency@@QEAA@_KZZ"
		size = 64
		refs = "0032 ?_Initialize@SchedulerPolicy@Concurrency@@AEAAX_KPEAPEAD@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8D 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_6_11_0 {
	meta:
		name = "??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
		size = 36
		altNames = "??0?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QEAA@XZ ??0?$_Ptr_base@U?$_Task_impl@_N@details@Concurrency@@@std@@QEAA@XZ ??0?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QEAA@XZ ??0?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QEAA@XZ ??0?$_Ptr_base@Uscheduler_interface@Concurrency@@@std@@QEAA@XZ ??0?$_Ptr_base@V__ExceptionPtr@@@std@@QEAA@XZ ??0_Container_proxy@std@@QEAA@XZ ??0_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 C7 00 00 00 00 00 48 8B 44 24 08 48 C7 40 08 00 00 00 00 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_6_12_0 {
	meta:
		name = "??0cancellation_token_source@Concurrency@@QEAA@AEBV01@@Z"
		size = 42
		refs = "001c ?_Assign@cancellation_token_source@Concurrency@@AEAAXPEAV_CancellationTokenState@details@2@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 38 48 8B 10 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_600_1 {
	meta:
		name = "??0cancellation_token@Concurrency@@QEAA@AEBV01@@Z"
		size = 42
		refs = "001c ?_Assign@cancellation_token@Concurrency@@AEAAXPEAV_CancellationTokenState@details@2@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 38 48 8B 10 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_13_0 {
	meta:
		name = "??0invalid_scheduler_policy_key@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_scheduler_policy_key@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_869_23_0 {
	meta:
		name = "??0_Interruption_exception@details@Concurrency@@QEAA@AEBV012@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7_Interruption_exception@details@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_912_0_0 {
	meta:
		name = "??0__non_rtti_object@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0bad_typeid@std@@QEAA@AEBV01@@Z 0025 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_912_1_0 {
	meta:
		name = "??0__non_rtti_object@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0bad_typeid@std@@QEAA@PEBD@Z 0025 ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1205_12_0 {
	meta:
		name = "??0bad_alloc@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_912_2_0 {
	meta:
		name = "??0bad_cast@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_586_1_0 {
	meta:
		name = "??0bad_exception@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_21_1 {
	meta:
		name = "??0bad_function_call@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_function_call@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_422_1 {
	meta:
		name = "??0bad_target@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_target@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_912_4_0 {
	meta:
		name = "??0bad_typeid@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_634_2 {
	meta:
		name = "??0bad_weak_ptr@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7bad_weak_ptr@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_14_79_2 {
	meta:
		name = "??0codecvt_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7codecvt_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_916_16_0 {
	meta:
		name = "??0context_self_unblock@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7context_self_unblock@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_916_17_0 {
	meta:
		name = "??0context_unblock_unbalanced@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7context_unblock_unbalanced@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_65_64_1 {
	meta:
		name = "??0ctype_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7ctype_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_74_0 {
	meta:
		name = "??0default_scheduler_exists@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7default_scheduler_exists@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_86_2 {
	meta:
		name = "??0failure@ios_base@std@@QEAA@AEBV012@@Z"
		size = 54
		refs = "0019 ??0system_error@std@@QEAA@AEBV01@@Z 0025 ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_133_28_0 {
	meta:
		name = "??0improper_lock@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7improper_lock@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_75_0 {
	meta:
		name = "??0improper_scheduler_attach@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7improper_scheduler_attach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_76_0 {
	meta:
		name = "??0improper_scheduler_detach@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7improper_scheduler_detach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_77_0 {
	meta:
		name = "??0improper_scheduler_reference@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7improper_scheduler_reference@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_897_11_0 {
	meta:
		name = "??0invalid_argument@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_241_33_0 {
	meta:
		name = "??0invalid_argument@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@PEBD@Z 0025 ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_426_3 {
	meta:
		name = "??0invalid_link_target@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_link_target@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_869_39_0 {
	meta:
		name = "??0invalid_multiple_scheduling@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_multiple_scheduling@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_609_1 {
	meta:
		name = "??0invalid_operation@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_operation@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_916_18_0 {
	meta:
		name = "??0invalid_oversubscribe_operation@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_oversubscribe_operation@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_14_0 {
	meta:
		name = "??0invalid_scheduler_policy_thread_specification@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_scheduler_policy_thread_specification@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_15_0 {
	meta:
		name = "??0invalid_scheduler_policy_value@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7invalid_scheduler_policy_value@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_104_56_2 {
	meta:
		name = "??0length_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@AEBV01@@Z 0025 ??_7length_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_104_57_2 {
	meta:
		name = "??0length_error@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@PEBD@Z 0025 ??_7length_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_21_1 {
	meta:
		name = "??0lock_error@threads@stdext@@QEAA@AEBV012@@Z"
		size = 54
		refs = "0019 ??0runtime_error@std@@QEAA@AEBV01@@Z 0025 ??_7lock_error@threads@stdext@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_688_24_0 {
	meta:
		name = "??0logic_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7logic_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_430_3 {
	meta:
		name = "??0message_not_found@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7message_not_found@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_254_1 {
	meta:
		name = "??0messages_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7messages_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_678_18_0 {
	meta:
		name = "??0missing_wait@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7missing_wait@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_310_2 {
	meta:
		name = "??0money_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7money_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_688_26_0 {
	meta:
		name = "??0nested_scheduler_missing_detach@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7nested_scheduler_missing_detach@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_431_1 {
	meta:
		name = "??0operation_timed_out@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7operation_timed_out@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_104_60_2 {
	meta:
		name = "??0out_of_range@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@AEBV01@@Z 0025 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_123_51_1 {
	meta:
		name = "??0out_of_range@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0logic_error@std@@QEAA@PEBD@Z 0025 ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_86_44_2 {
	meta:
		name = "??0overflow_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0runtime_error@std@@QEAA@AEBV01@@Z 0025 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_35_1 {
	meta:
		name = "??0overflow_error@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0runtime_error@std@@QEAA@PEBD@Z 0025 ??_7overflow_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_63_3 {
	meta:
		name = "??0range_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0runtime_error@std@@QEAA@AEBV01@@Z 0025 ??_7range_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_123_53_1 {
	meta:
		name = "??0range_error@std@@QEAA@PEBD@Z"
		size = 54
		refs = "0019 ??0runtime_error@std@@QEAA@PEBD@Z 0025 ??_7range_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_345_3 {
	meta:
		name = "??0runtime_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7runtime_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_198_11_0 {
	meta:
		name = "??0scheduler_not_attached@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7scheduler_not_attached@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_350_14_0 {
	meta:
		name = "??0scheduler_worker_creation_error@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@AEBV01@@Z 0025 ??_7scheduler_worker_creation_error@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_124_111_3 {
	meta:
		name = "??0system_error@std@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0_System_error@std@@QEAA@AEBV01@@Z 0025 ??_7system_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_121_35_2 {
	meta:
		name = "??0thread_resource_error@threads@stdext@@QEAA@AEBV012@@Z"
		size = 54
		refs = "0019 ??0runtime_error@std@@QEAA@AEBV01@@Z 0025 ??_7thread_resource_error@threads@stdext@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_98_157_3 {
	meta:
		name = "??0time_base@std@@QEAA@_K@Z"
		size = 54
		refs = "0019 ??0facet@locale@std@@IEAA@_K@Z 0025 ??_7time_base@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_241_38_0 {
	meta:
		name = "??0unsupported_os@Concurrency@@QEAA@AEBV01@@Z"
		size = 54
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7unsupported_os@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_16_0 {
	meta:
		name = "??1GlobalCore@details@Concurrency@@QEAA@XZ"
		size = 38
		refs = "001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 40 28 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_6_17_0 {
	meta:
		name = "??1SchedulerPolicy@Concurrency@@QEAA@XZ"
		size = 37
		refs = "001c ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 00 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_630_35_0 {
	meta:
		name = "??1CancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QEAA@XZ"
		size = 37
		refs = "001c ??_V@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 00 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_6_18_0 {
	meta:
		name = "??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
		size = 71
		refs = "003c free"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 8B 00 48 89 44 24 20 48 83 7C 24 20 00 74 24 48 8B 44 24 20 48 89 44 24 28 48 8B 44 24 20 48 8B 40 08 48 89 44 24 20 48 8B 4C 24 28 E8 ?? ?? ?? ?? EB D4 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_6_19_0 {
	meta:
		name = "??1invalid_scheduler_policy_key@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1exception@std@@UEAA@XZ"
		altNames = "??1_Interruption_exception@details@Concurrency@@UEAA@XZ ??1bad_function_call@std@@UEAA@XZ ??1bad_target@Concurrency@@UEAA@XZ ??1bad_weak_ptr@std@@UEAA@XZ ??1context_self_unblock@Concurrency@@UEAA@XZ ??1context_unblock_unbalanced@Concurrency@@UEAA@XZ ??1default_scheduler_exists@Concurrency@@UEAA@XZ ??1improper_lock@Concurrency@@UEAA@XZ ??1improper_scheduler_attach@Concurrency@@UEAA@XZ ??1improper_scheduler_detach@Concurrency@@UEAA@XZ ??1improper_scheduler_reference@Concurrency@@UEAA@XZ ??1invalid_link_target@Concurrency@@UEAA@XZ ??1invalid_multiple_scheduling@Concurrency@@UEAA@XZ ??1invalid_operation@Concurrency@@UEAA@XZ ??1invalid_oversubscribe_operation@Concurrency@@UEAA@XZ ??1invalid_scheduler_policy_thread_specification@Concurrency@@UEAA@XZ ??1invalid_scheduler_policy_value@Concurrency@@UEAA@XZ ??1logic_error@std@@UEAA@XZ ??1message_not_found@Concurrency@@UEAA@XZ ??1missing_wait@Concurrency@@UEAA@XZ ??1nested_scheduler_missing_detach@Concurrency@@UEAA@XZ ??1operation_timed_out@Concurrency@@UEAA@XZ ??1runtime_error@std@@UEAA@XZ ??1scheduler_not_attached@Concurrency@@UEAA@XZ ??1scheduler_resource_allocation_error@Concurrency@@UEAA@XZ ??1task_canceled@Concurrency@@UEAA@XZ ??1unsupported_os@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_440_1 {
	meta:
		name = "??1?$_Dynamic_array@PEAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000f ?_Clear@?$_Dynamic_array@PEAV?$ISource@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_441_1 {
	meta:
		name = "??1?$_Dynamic_array@PEAV?$ISource@_K@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000f ?_Clear@?$_Dynamic_array@PEAV?$ISource@_K@Concurrency@@@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_442_1 {
	meta:
		name = "??1?$_Dynamic_array@PEAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000f ?_Clear@?$_Dynamic_array@PEAV?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_443_1 {
	meta:
		name = "??1?$_Dynamic_array@PEAV?$ITarget@_K@Concurrency@@@details@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000f ?_Clear@?$_Dynamic_array@PEAV?$ITarget@_K@Concurrency@@@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_681_2 {
	meta:
		name = "??1?$_Func_class@EV?$task@_N@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@EV?$task@_N@Concurrency@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_682_2 {
	meta:
		name = "??1?$_Func_class@V?$task@_N@Concurrency@@$$$V@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@V?$task@_N@Concurrency@@$$$V@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_683_2 {
	meta:
		name = "??1?$_Func_class@V?$task@_N@Concurrency@@_N@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@V?$task@_N@Concurrency@@_N@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_448_1 {
	meta:
		name = "??1?$_Func_class@X$$$V@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@X$$$V@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_449_1 {
	meta:
		name = "??1?$_Func_class@XAEB_K@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@XAEB_K@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_685_2 {
	meta:
		name = "??1?$_Func_class@XE@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@XE@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_450_3 {
	meta:
		name = "??1?$_Func_class@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_451_3 {
	meta:
		name = "??1?$_Func_class@XPEAV?$message@_K@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@XPEAV?$message@_K@Concurrency@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_686_2 {
	meta:
		name = "??1?$_Func_class@XU?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@XU?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_696_3 {
	meta:
		name = "??1?$_Func_class@XV?$task@X@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@XV?$task@X@Concurrency@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_697_3 {
	meta:
		name = "??1?$_Func_class@XV?$task@_N@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@XV?$task@_N@Concurrency@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_452_3 {
	meta:
		name = "??1?$_Func_class@_NAEBW4agent_status@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@_NAEBW4agent_status@Concurrency@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_453_2 {
	meta:
		name = "??1?$_Func_class@_NAEB_K@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Func_class@_NAEB_K@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_98_97_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_314_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_696_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@PEAX_JPEBQEAXAEBQEAXU_Iterator_base12@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_697_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@_JPEBV32@AEBV32@U_Iterator_base12@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_707_3 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@_JPEBV32@AEBV32@U_Iterator_base12@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_57_2 {
	meta:
		name = "??1?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Iterator_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_934_53_0 {
	meta:
		name = "??1?$_Ref_count@V__ExceptionPtr@@@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Ref_count_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_664_1 {
	meta:
		name = "??1?$_Ref_count_obj@U?$_Task_impl@E@details@Concurrency@@@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Ref_count_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_706_2 {
	meta:
		name = "??1?$_Ref_count_obj@U?$_Task_impl@_N@details@Concurrency@@@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Ref_count_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_707_2 {
	meta:
		name = "??1?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Ref_count_base@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_99_2 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_355_3 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_356_3 {
	meta:
		name = "??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_26_149_2 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_323_2 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_324_2 {
	meta:
		name = "??1?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_29_101_2 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@D@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_326_2 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@G@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_361_3 {
	meta:
		name = "??1?$_String_val@U?$_Simple_types@_W@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_721_2 {
	meta:
		name = "??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@PEAX@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Iterator012@Urandom_access_iterator_tag@std@@PEAX_JPEBQEAXAEBQEAXU_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_722_2 {
	meta:
		name = "??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@_JPEBV32@AEBV32@U_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_723_2 {
	meta:
		name = "??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Iterator012@Urandom_access_iterator_tag@std@@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@_JPEBV32@AEBV32@U_Iterator_base12@2@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_724_2 {
	meta:
		name = "??1?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_725_2 {
	meta:
		name = "??1?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_726_2 {
	meta:
		name = "??1?$_Vector_val@U?$_Simple_types@PEAX@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_727_2 {
	meta:
		name = "??1?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_737_3 {
	meta:
		name = "??1?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ??1_Container_base12@std@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_119_3 {
	meta:
		name = "??1?$_Yarn@D@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Yarn@D@std@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_20_102_3 {
	meta:
		name = "??1?$_Yarn@_W@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$_Yarn@_W@std@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_681_1 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_745_3 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_completion_event_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@U?$_Task_completion_event_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_746_3 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_684_1 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_685_1 {
	meta:
		name = "??1?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@U?$_Task_impl@_N@details@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_686_1 {
	meta:
		name = "??1?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_741_2 {
	meta:
		name = "??1?$shared_ptr@U_Task_impl_base@details@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_688_1 {
	meta:
		name = "??1?$shared_ptr@Uscheduler_interface@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@Uscheduler_interface@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_934_56_0 {
	meta:
		name = "??1?$shared_ptr@V__ExceptionPtr@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decref@?$_Ptr_base@V__ExceptionPtr@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_694_1 {
	meta:
		name = "??1?$vector@PEAXV?$allocator@PEAX@std@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$vector@PEAXV?$allocator@PEAX@std@@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_695_1 {
	meta:
		name = "??1?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_696_1 {
	meta:
		name = "??1?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Tidy@?$vector@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@2@@std@@IEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_697_1 {
	meta:
		name = "??1?$weak_ptr@U_Task_impl_base@details@Concurrency@@@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Decwref@?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_89_0 {
	meta:
		name = "??1CacheLocalScheduleGroup@details@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1ScheduleGroupBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_90_0 {
	meta:
		name = "??1CacheLocalScheduleGroupSegment@details@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1ScheduleGroupSegmentBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_678_19_0 {
	meta:
		name = "??1CancellationTokenRegistration_TaskProc@details@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1_CancellationTokenRegistration@details@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_91_0 {
	meta:
		name = "??1FairScheduleGroup@details@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1ScheduleGroupBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_92_0 {
	meta:
		name = "??1FairScheduleGroupSegment@details@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1ScheduleGroupSegmentBase@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1332_20_0 {
	meta:
		name = "??1FreeVirtualProcessorRoot@details@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1VirtualProcessorRoot@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_97_0 {
	meta:
		name = "??1RealizedChore@details@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Chore@details@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1205_16_0 {
	meta:
		name = "??1TimerObj@?6??wait@Concurrency@@YAXI@Z@UEAA@XZ"
		size = 24
		refs = "000f ??1_Timer@details@Concurrency@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_111_2 {
	meta:
		name = "??1_Container_base12@std@@QEAA@XZ"
		size = 24
		refs = "000f ?_Orphan_all@_Container_base12@std@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_705_1 {
	meta:
		name = "??1_Future_error_category@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Generic_error_category@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_90_35_2 {
	meta:
		name = "??1_Generic_error_category@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1error_category@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_38_23_1 {
	meta:
		name = "??1_Iostream_error_category@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Generic_error_category@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_51_59_3 {
	meta:
		name = "??1_System_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_46_45_1 {
	meta:
		name = "??1_System_error_category@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_Generic_error_category@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_729_1 {
	meta:
		name = "??1cancellation_token@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000f ?_Clear@cancellation_token@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_730_1 {
	meta:
		name = "??1cancellation_token_registration@Concurrency@@QEAA@XZ"
		size = 24
		refs = "000f ?_Clear@cancellation_token_registration@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_733_1 {
	meta:
		name = "??1exception_ptr@std@@QEAA@XZ"
		size = 24
		refs = "000f ?__ExceptionPtrDestroy@@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_14_123_2 {
	meta:
		name = "??1failure@ios_base@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1system_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_790_2 {
	meta:
		name = "??1future_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1logic_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_46_1 {
	meta:
		name = "??1invalid_argument@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1logic_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_57_61_3 {
	meta:
		name = "??1length_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1logic_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_121_44_2 {
	meta:
		name = "??1lock_error@threads@stdext@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_303_1 {
	meta:
		name = "??1messages_base@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_98_189_3 {
	meta:
		name = "??1money_base@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1facet@locale@std@@MEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_86_62_2 {
	meta:
		name = "??1out_of_range@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1logic_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_57_64_3 {
	meta:
		name = "??1overflow_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_123_67_1 {
	meta:
		name = "??1range_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_51_1 {
	meta:
		name = "??1regex_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_790_84_0 {
	meta:
		name = "??1scheduler_worker_creation_error@Concurrency@@UEAA@XZ"
		size = 24
		refs = "000f ??1scheduler_resource_allocation_error@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_124_144_3 {
	meta:
		name = "??1system_error@std@@UEAA@XZ"
		size = 24
		refs = "000f ??1_System_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_33_1 {
	meta:
		name = "??1thread_resource_error@threads@stdext@@UEAA@XZ"
		size = 24
		refs = "000f ??1runtime_error@std@@UEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_807_3 {
	meta:
		name = "??2_AllocBase@details@Concurrency@@SAPEAX_K@Z"
		size = 24
		refs = "000f ?Alloc@Concurrency@@YAPEAX_K@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_589_2 {
	meta:
		name = "??3_AllocBase@details@Concurrency@@SAXPEAX@Z"
		size = 24
		refs = "000f ?Free@Concurrency@@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_844_3 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QEBAPEAU?$_Task_completion_event_impl@E@details@Concurrency@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@U?$_Task_completion_event_impl@E@details@Concurrency@@@std@@QEBAPEAU?$_Task_completion_event_impl@E@details@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_845_3 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_completion_event_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEBAPEAU?$_Task_completion_event_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@U?$_Task_completion_event_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEBAPEAU?$_Task_completion_event_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_846_3 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QEBAPEAU?$_Task_impl@E@details@Concurrency@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@U?$_Task_impl@E@details@Concurrency@@@std@@QEBAPEAU?$_Task_impl@E@details@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_847_3 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEBAPEAU?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEBAPEAU?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_848_3 {
	meta:
		name = "??C?$shared_ptr@U?$_Task_impl@_N@details@Concurrency@@@std@@QEBAPEAU?$_Task_impl@_N@details@Concurrency@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@U?$_Task_impl@_N@details@Concurrency@@@std@@QEBAPEAU?$_Task_impl@_N@details@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_849_3 {
	meta:
		name = "??C?$shared_ptr@U_Task_impl_base@details@Concurrency@@@std@@QEBAPEAU_Task_impl_base@details@Concurrency@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QEBAPEAU_Task_impl_base@details@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_934_68_0 {
	meta:
		name = "??C?$shared_ptr@V__ExceptionPtr@@@std@@QEBAPEAV__ExceptionPtr@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QEBAPEAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_850_3 {
	meta:
		name = "??Cscheduler_ptr@Concurrency@@QEBAPEAUscheduler_interface@1@XZ"
		size = 24
		refs = "000f ?get@scheduler_ptr@Concurrency@@QEBAPEAUscheduler_interface@2@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_113_1 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBAAEADXZ"
		size = 24
		refs = "000f ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBAAEBDXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_407_2 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBAAEAGXZ"
		size = 24
		refs = "000f ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBAAEBGXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_334_1 {
	meta:
		name = "??D?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBAAEA_WXZ"
		size = 24
		refs = "000f ??D?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBAAEB_WXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_786_1 {
	meta:
		name = "??D?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEBAAEAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@XZ"
		size = 24
		refs = "000f ??D?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEBAAEBV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@1@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_787_1 {
	meta:
		name = "??D?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEBAAEAV?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@XZ"
		size = 24
		refs = "000f ??D?$_Vector_const_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEBAAEBV?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@1@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_35_0_3 {
	meta:
		name = "??_U@YAPEAX_K@Z"
		size = 24
		refs = "000f ??2@YAPEAX_K@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "??_V@YAXPEAX@Z"
		size = 24
		refs = "000f ??3@YAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_372_119_0 {
	meta:
		name = "?CheckForDeletionBridge@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?CheckForDeletion@?$ListArray@U?$ListArrayInlineLink@VWorkQueue@details@Concurrency@@@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_196_0 {
	meta:
		name = "?CheckForDeletionBridge@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?CheckForDeletion@?$ListArray@VExternalStatistics@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_197_0 {
	meta:
		name = "?CheckForDeletionBridge@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?CheckForDeletion@?$ListArray@VScheduleGroupBase@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1105_41_0 {
	meta:
		name = "?CheckForDeletionBridge@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?CheckForDeletion@?$ListArray@VScheduleGroupSegmentBase@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_502_59_0 {
	meta:
		name = "?CheckForDeletionBridge@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?CheckForDeletion@?$ListArray@VVirtualProcessor@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_372_120_0 {
	meta:
		name = "?CheckForDeletionBridge@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?CheckForDeletion@?$ListArray@VWorkQueue@details@Concurrency@@@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_241_94_0 {
	meta:
		name = "?Count@?$List@VExecutionResource@details@Concurrency@@VCount@CollectionTypes@23@@details@Concurrency@@QEBAHXZ"
		size = 24
		refs = "000f ?Value@Count@CollectionTypes@details@Concurrency@@QEBAHXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_606_32_0 {
	meta:
		name = "?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
		size = 24
		refs = "000f ?EncodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_417_65_0 {
	meta:
		name = "?Destroy@WaitAllBlock@details@Concurrency@@UEAAXXZ"
		size = 24
		refs = "000f ?NotifyCompletedNode@MultiWaitBlock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_856_74_0 {
	meta:
		name = "?FromUMSContext@UMSFreeThreadProxy@details@Concurrency@@SAPEAV123@PEAX@Z"
		size = 24
		refs = "000f ?FromUMSContext@UMSThreadProxy@details@Concurrency@@SAPEAV123@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_333_0 {
	meta:
		name = "?InitializeSchedulerEventHandlers@SchedulerBase@details@Concurrency@@MEAAXXZ"
		size = 24
		refs = "000f ?IncrementInternalContextCount@SchedulerBase@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_630_159_0 {
	meta:
		name = "?InternalSignal@CancellationBeacon@ContextBase@details@Concurrency@@QEAAXXZ"
		size = 24
		refs = "000f ?Raise@CancellationBeacon@ContextBase@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_372_198_0 {
	meta:
		name = "?Reference@ScheduleGroupBase@details@Concurrency@@UEAAIXZ"
		size = 24
		refs = "000f ?InternalReference@ScheduleGroupBase@details@Concurrency@@IEAAJXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_395_0 {
	meta:
		name = "?Release@ScheduleGroupBase@details@Concurrency@@UEAAIXZ"
		size = 24
		refs = "000f ?InternalRelease@ScheduleGroupBase@details@Concurrency@@IEAAJXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_430_0 {
	meta:
		name = "?SetDefaultSchedulerPolicy@Scheduler@Concurrency@@SAXAEBVSchedulerPolicy@2@@Z"
		size = 24
		refs = "000f ?SetDefaultSchedulerPolicy@SchedulerBase@details@Concurrency@@SAXAEBVSchedulerPolicy@3@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_767_37_0 {
	meta:
		name = "?_Acquire@_NonReentrantLock@details@Concurrency@@QEAAXXZ"
		size = 24
		refs = "000f ?_DebugAcquire@_NonReentrantLock@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_978_2 {
	meta:
		name = "?_Cancel@?$task_completion_event@E@Concurrency@@QEBA_NXZ"
		size = 24
		refs = "000f ?_CancelInternal@?$task_completion_event@E@Concurrency@@AEBA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_918_1 {
	meta:
		name = "?_Cancel@?$task_completion_event@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@QEBA_NXZ"
		size = 24
		refs = "000f ?_CancelInternal@?$task_completion_event@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@AEBA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_869_153_0 {
	meta:
		name = "?_CancelViaToken@_StructuredTaskCollection@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?_Cancel@_StructuredTaskCollection@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_869_154_0 {
	meta:
		name = "?_CancelViaToken@_TaskCollection@details@Concurrency@@CAXPEAV123@@Z"
		size = 24
		refs = "000f ?_Cancel@_TaskCollection@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_869_197_0 {
	meta:
		name = "?_NotificationHandler@_AsyncTaskCollection@details@Concurrency@@AEAAXXZ"
		size = 24
		refs = "000f ?_Release@_RefCounterBase@details@Concurrency@@QEAAJXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_711_53_0 {
	meta:
		name = "?_RethrowException@exception_ptr@std@@QEBAXXZ"
		size = 24
		refs = "000f ?__ExceptionPtrRethrow@@YAXPEBX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_606_71_0 {
	meta:
		name = "?_TryAcquire@_NonReentrantLock@details@Concurrency@@QEAA_NXZ"
		size = 24
		refs = "000f ?_DebugTryAcquire@_NonReentrantLock@details@Concurrency@@AEAA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_290_7_0 {
	meta:
		name = "?_type_info_dtor_internal_method@type_info@@QEAAXXZ"
		size = 24
		refs = "000f ?_Type_info_dtor_internal@type_info@@CAXPEAV1@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_7_254_2 {
	meta:
		name = "?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAPEBDXZ"
		size = 24
		refs = "000f ?_Myptr@?$_String_val@U?$_Simple_types@D@std@@@std@@QEBAPEBDXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_833_1 {
	meta:
		name = "?c_str@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEBAPEBGXZ"
		size = 24
		refs = "000f ?_Myptr@?$_String_val@U?$_Simple_types@G@std@@@std@@QEBAPEBGXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_834_1 {
	meta:
		name = "?c_str@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEBAPEB_WXZ"
		size = 24
		refs = "000f ?_Myptr@?$_String_val@U?$_Simple_types@_W@std@@@std@@QEBAPEB_WXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_1039_1 {
	meta:
		name = "?count@?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA_KXZ"
		size = 24
		refs = "000f ?_Count@?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@AEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_1040_3 {
	meta:
		name = "?count@?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@UEAA_KXZ"
		size = 24
		refs = "000f ?_Count@?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@AEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_1041_2 {
	meta:
		name = "?count@?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA_KXZ"
		size = 24
		refs = "000f ?_Count@?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@AEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_1042_2 {
	meta:
		name = "?count@?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAA_KXZ"
		size = 24
		refs = "000f ?_Count@?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@AEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_1061_2 {
	meta:
		name = "?empty@?$concurrent_queue@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@QEBA_NXZ"
		size = 24
		refs = "000f ?_Internal_empty@_Concurrent_queue_base_v4@details@Concurrency@@IEBA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_1062_3 {
	meta:
		name = "?empty@?$concurrent_queue@PEAV?$message@_K@Concurrency@@V?$allocator@PEAV?$message@_K@Concurrency@@@std@@@Concurrency@@QEBA_NXZ"
		size = 24
		refs = "000f ?_Internal_empty@_Concurrent_queue_base_v4@details@Concurrency@@IEBA_NXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_1406_2 {
	meta:
		name = "?get@?$shared_ptr@U_ExceptionHolder@details@Concurrency@@@std@@QEBAPEAU_ExceptionHolder@details@Concurrency@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@U_ExceptionHolder@details@Concurrency@@@std@@QEBAPEAU_ExceptionHolder@details@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_1425_3 {
	meta:
		name = "?get@?$shared_ptr@U_Task_impl_base@details@Concurrency@@@std@@QEBAPEAU_Task_impl_base@details@Concurrency@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@U_Task_impl_base@details@Concurrency@@@std@@QEBAPEAU_Task_impl_base@details@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_1408_2 {
	meta:
		name = "?get@?$shared_ptr@Uscheduler_interface@Concurrency@@@std@@QEBAPEAUscheduler_interface@Concurrency@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@Uscheduler_interface@Concurrency@@@std@@QEBAPEAUscheduler_interface@Concurrency@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_934_146_0 {
	meta:
		name = "?get@?$shared_ptr@V__ExceptionPtr@@@std@@QEBAPEAV__ExceptionPtr@@XZ"
		size = 24
		refs = "000f ?_Get@?$_Ptr_base@V__ExceptionPtr@@@std@@QEBAPEAV__ExceptionPtr@@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_104_280_1 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEBA_KXZ"
		size = 24
		refs = "000f ?max_size@?$allocator_traits@V?$allocator@D@std@@@std@@SA_KAEBV?$allocator@D@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_1100_1 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEBA_KXZ"
		size = 24
		refs = "000f ?max_size@?$allocator_traits@V?$allocator@G@std@@@std@@SA_KAEBV?$allocator@G@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_1361_1 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@PEAX@std@@@std@@QEBA_KXZ"
		size = 24
		refs = "000f ?max_size@?$allocator_traits@V?$allocator@PEAX@std@@@std@@SA_KAEBV?$allocator@PEAX@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_1237_2 {
	meta:
		name = "?max_size@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEBA_KXZ"
		size = 24
		refs = "000f ?max_size@?$allocator_traits@V?$allocator@_W@std@@@std@@SA_KAEBV?$allocator@_W@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_34_315_3 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@D@std@@@std@@SA_KAEBV?$allocator@D@2@@Z"
		size = 24
		refs = "000f ?max_size@?$allocator@D@std@@QEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_1280_3 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@G@std@@@std@@SA_KAEBV?$allocator@G@2@@Z"
		size = 24
		refs = "000f ?max_size@?$allocator@G@std@@QEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_1457_3 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@PEAX@std@@@std@@SA_KAEBV?$allocator@PEAX@2@@Z"
		size = 24
		refs = "000f ?max_size@?$allocator@PEAX@std@@QEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_1281_3 {
	meta:
		name = "?max_size@?$allocator_traits@V?$allocator@_W@std@@@std@@SA_KAEBV?$allocator@_W@2@@Z"
		size = 24
		refs = "000f ?max_size@?$allocator@_W@std@@QEBA_KXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_241_258_0 {
	meta:
		name = "?set_task_execution_resources@Concurrency@@YAX_K@Z"
		size = 24
		refs = "000f ?SetTaskExecutionResources@ResourceManager@details@Concurrency@@SAX_K@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_102_0_3 {
	meta:
		name = "_LDtest"
		size = 24
		refs = "000f _Dtest"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_363_6_0 {
	meta:
		name = "__free_locale"
		size = 24
		refs = "000f _free_locale"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_35_0 {
	meta:
		name = "_aligned_free"
		size = 24
		refs = "000f _aligned_free_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1131_0_0 {
	meta:
		name = "_ftime32"
		size = 24
		refs = "000f _ftime32_s"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "_ftime64"
		size = 24
		refs = "000f _ftime64_s"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_584_6_0 {
	meta:
		name = "_inc"
		size = 24
		refs = "000f _fgetwc_nolock"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_6_0 {
	meta:
		name = "_ldtest"
		size = 24
		refs = "000f _dtest"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "_unlink"
		size = 24
		refs = "000f remove"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_758_0_0 {
	meta:
		name = "_wtoi"
		size = 24
		refs = "000f _wtol"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_546_1_0 {
	meta:
		name = "_wunlink"
		size = 24
		refs = "000f _wremove"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_596_5_0 {
	meta:
		name = "atoi"
		size = 24
		refs = "000f atol"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_287_0_0 {
	meta:
		name = "clearerr"
		size = 24
		refs = "000f clearerr_s"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_423_3_0 {
	meta:
		name = "getwc"
		size = 24
		refs = "000f fgetwc"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_22_0 {
	meta:
		name = "??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z"
		size = 53
		refs = "002c ??2@YAPEAX_KHPEBDH@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 88 54 24 10 48 89 4C 24 08 48 83 EC 28 44 8B 4C 24 48 4C 8B 44 24 40 BA 02 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_869_86_0 {
	meta:
		name = "??_U@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z"
		size = 53
		refs = "002c ??_U@YAPEAX_KHPEBDH@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 88 54 24 10 48 89 4C 24 08 48 83 EC 28 44 8B 4C 24 48 4C 8B 44 24 40 BA 02 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_23_0 {
	meta:
		name = "??4SchedulerPolicy@Concurrency@@QEAAAEAV01@AEBV01@@Z"
		size = 39
		refs = "0019 ?_Assign@SchedulerPolicy@Concurrency@@AEAAXAEBV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_26_68_2 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAA@AEBU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_163_2 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAA@AEBU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_477_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@PEAX_JPEBQEAXAEBQEAXU_Iterator_base12@2@@std@@QEAA@AEBU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_38_27_3 {
	meta:
		name = "??0?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAA@AEBU01@@Z"
		size = 39
		refs = "0019 ??0_Iterator_base12@std@@QEAA@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_26_78_2 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_185_2 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_38_36_3 {
	meta:
		name = "??0?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_67_19_2 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAA@AEBV?$allocator@D@1@@Z"
		size = 39
		refs = "0019 ??0?$allocator@D@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_227_3 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEAA@AEBV?$allocator@G@1@@Z"
		size = 39
		refs = "0019 ??0?$allocator@G@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_509_2 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@PEAX@std@@@std@@QEAA@AEBV?$allocator@PEAX@1@@Z"
		size = 39
		refs = "0019 ??0?$allocator@PEAX@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_229_3 {
	meta:
		name = "??0?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEAA@AEBV?$allocator@_W@1@@Z"
		size = 39
		refs = "0019 ??0?$allocator@_W@std@@QEAA@AEBV01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_643_2 {
	meta:
		name = "??0exception_ptr@std@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ?__ExceptionPtrCopy@@YAXPEAXPEBX@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1153_13_0 {
	meta:
		name = "??0location@Concurrency@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ?_Assign@location@Concurrency@@QEAAXAEBV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_653_2 {
	meta:
		name = "??0task_continuation_context@Concurrency@@QEAA@AEBV01@@Z"
		size = 39
		refs = "0019 ??0_ContextCallback@details@Concurrency@@QEAA@AEBV012@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_98_194_3 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@D_JPEBDAEBDU_Iterator_base12@2@@std@@QEAAAEAU01@AEBU01@@Z"
		size = 39
		refs = "0019 ??4_Iterator_base12@std@@QEAAAEAU01@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_412_3 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@G_JPEBGAEBGU_Iterator_base12@2@@std@@QEAAAEAU01@AEBU01@@Z"
		size = 39
		refs = "0019 ??4_Iterator_base12@std@@QEAAAEAU01@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_413_3 {
	meta:
		name = "??4?$_Iterator012@Urandom_access_iterator_tag@std@@_W_JPEB_WAEB_WU_Iterator_base12@2@@std@@QEAAAEAU01@AEBU01@@Z"
		size = 39
		refs = "0019 ??4_Iterator_base12@std@@QEAAAEAU01@AEBU01@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_372_82_0 {
	meta:
		name = "??4QuickBitSet@details@Concurrency@@QEAAAEAV012@AEBV012@@Z"
		size = 39
		refs = "0019 ?CopyFrom@QuickBitSet@details@Concurrency@@IEAAXAEBV123@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_372_83_0 {
	meta:
		name = "??4location@Concurrency@@QEAAAEAV01@AEBV01@@Z"
		size = 39
		refs = "0019 ?_Assign@location@Concurrency@@QEAAXAEBV12@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_823_3 {
	meta:
		name = "??4task_continuation_context@Concurrency@@QEAAAEAV01@AEBV01@@Z"
		size = 39
		refs = "0019 ??4_ContextCallback@details@Concurrency@@QEAAAEAV012@AEBV012@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_26_211_2 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 39
		refs = "0019 ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_472_3 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 39
		refs = "0019 ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_358_1 {
	meta:
		name = "??Y?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAAAEAV01@_J@Z"
		size = 39
		refs = "0019 ??Y?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAAAEAV01@_J@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_316_124_0 {
	meta:
		name = "?getVbTableType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
		size = 39
		refs = "0019 ?getVfTableType@UnDecorator@@CA?AVDName@@AEBV2@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_31_0 {
	meta:
		name = "??_EGlobalCore@details@Concurrency@@QEAAPEAXI@Z"
		size = 135
		refs = "001b ??1GlobalCore@details@Concurrency@@QEAA@XZ 0033 ??_M@YAXPEAX_KHP6AX0@Z@Z 004f ??_V@YAXPEAX@Z 0079 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 8B 44 24 38 83 E0 02 85 C0 74 46 4C 8D 0D ?? ?? ?? ?? 48 8B 44 24 30 44 8B 40 F8 BA 30 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 11 48 8B 44 24 30 48 83 E8 08 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 E8 08 EB 24 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_32_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_key@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_scheduler_policy_key@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_647_1 {
	meta:
		name = "??_G?$ISource@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ISource@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_648_1 {
	meta:
		name = "??_G?$ISource@_K@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ISource@_K@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_649_3 {
	meta:
		name = "??_G?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ITarget@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_650_2 {
	meta:
		name = "??_G?$ITarget@_K@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ITarget@_K@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1117_55_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ThreadProxyFactory@VFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1117_56_0 {
	meta:
		name = "??_G?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ThreadProxyFactory@VUMSFreeThreadProxy@details@Concurrency@@@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_651_3 {
	meta:
		name = "??_G?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_652_1 {
	meta:
		name = "??_G?$_AnonymousOriginator@_K@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_AnonymousOriginator@_K@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_901_2 {
	meta:
		name = "??_G?$_Func_base@EV?$task@_N@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_base@EV?$task@_N@Concurrency@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_912_3 {
	meta:
		name = "??_G?$_Func_base@V?$task@_N@Concurrency@@_N@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_base@V?$task@_N@Concurrency@@_N@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_913_3 {
	meta:
		name = "??_G?$_Func_base@X$$$V@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_base@X$$$V@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_653_1 {
	meta:
		name = "??_G?$_Func_base@XAEB_K@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_base@XAEB_K@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_654_3 {
	meta:
		name = "??_G?$_Func_base@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_base@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_655_2 {
	meta:
		name = "??_G?$_Func_base@XPEAV?$message@_K@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_base@XPEAV?$message@_K@Concurrency@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_847_1 {
	meta:
		name = "??_G?$_Func_base@XV?$task@_N@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_base@XV?$task@_N@Concurrency@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_656_3 {
	meta:
		name = "??_G?$_Func_base@_NAEBW4agent_status@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_base@_NAEBW4agent_status@Concurrency@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_657_2 {
	meta:
		name = "??_G?$_Func_impl@U?$_Callable_obj@P6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NAEBW4agent_status@Concurrency@@@std@@@2@_NAEBW4agent_status@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Func_impl@U?$_Callable_obj@P6A_NAEBW4agent_status@Concurrency@@@Z$0A@@std@@V?$allocator@V?$_Func_class@_NAEBW4agent_status@Concurrency@@@std@@@2@_NAEBW4agent_status@Concurrency@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_664_1 {
	meta:
		name = "??_G?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_417_54_0 {
	meta:
		name = "??_G?$_MallocaArrayHolder@PEAVContext@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_MallocaArrayHolder@PEAVContext@Concurrency@@@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_869_72_0 {
	meta:
		name = "??_G?$_MallocaArrayHolder@PEAVevent@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_MallocaArrayHolder@PEAVevent@Concurrency@@@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_98_228_3 {
	meta:
		name = "??_G?$_Mpunct@D@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Mpunct@D@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_366_1 {
	meta:
		name = "??_G?$_Mpunct@G@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Mpunct@G@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_367_1 {
	meta:
		name = "??_G?$_Mpunct@_W@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Mpunct@_W@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_665_3 {
	meta:
		name = "??_G?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Order_node_base@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_934_69_0 {
	meta:
		name = "??_G?$_Ref_count@V__ExceptionPtr@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Ref_count@V__ExceptionPtr@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_934_70_0 {
	meta:
		name = "??_G?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_857_1 {
	meta:
		name = "??_G?$_Ref_count_obj@U?$_Task_impl@E@details@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Ref_count_obj@U?$_Task_impl@E@details@Concurrency@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_858_1 {
	meta:
		name = "??_G?$_Ref_count_obj@U?$_Task_impl@_N@details@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Ref_count_obj@U?$_Task_impl@_N@details@Concurrency@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_859_1 {
	meta:
		name = "??_G?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Ref_count_obj@U_ExceptionHolder@details@Concurrency@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_927_3 {
	meta:
		name = "??_G?$_RunAllParam@E@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_RunAllParam@E@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_928_3 {
	meta:
		name = "??_G?$_RunAnyParam@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_RunAnyParam@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_666_1 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_667_2 {
	meta:
		name = "??_G?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_668_2 {
	meta:
		name = "??_G?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_SyncOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_669_3 {
	meta:
		name = "??_G?$_SyncOriginator@_K@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_SyncOriginator@_K@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_862_1 {
	meta:
		name = "??_G?$_Task_impl@E@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Task_impl@E@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_863_1 {
	meta:
		name = "??_G?$_Task_impl@_N@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$_Task_impl@_N@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_101_144_3 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_98_138_2 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_65_115_1 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_8_140_2 {
	meta:
		name = "??_G?$basic_ios@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_ios@DU?$char_traits@D@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_106_116_1 {
	meta:
		name = "??_G?$basic_ios@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_ios@GU?$char_traits@G@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_139_2 {
	meta:
		name = "??_G?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_ios@_WU?$char_traits@_W@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_105_147_3 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_158_3 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_16_118_1 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_670_2 {
	meta:
		name = "??_G?$call@_KV?$function@$$A6AXAEB_K@Z@std@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$call@_KV?$function@$$A6AXAEB_K@Z@std@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_128_2 {
	meta:
		name = "??_G?$codecvt@DDH@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$codecvt@DDH@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_14_142_2 {
	meta:
		name = "??_G?$codecvt@GDH@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$codecvt@GDH@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_85_159_3 {
	meta:
		name = "??_G?$codecvt@_WDH@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$codecvt@_WDH@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_98_229_3 {
	meta:
		name = "??_G?$collate@D@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$collate@D@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_485_3 {
	meta:
		name = "??_G?$collate@G@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$collate@G@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_451_2 {
	meta:
		name = "??_G?$collate@_W@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$collate@_W@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_671_3 {
	meta:
		name = "??_G?$concurrent_queue@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$concurrent_queue@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@V?$allocator@PEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_672_2 {
	meta:
		name = "??_G?$concurrent_queue@PEAV?$message@_K@Concurrency@@V?$allocator@PEAV?$message@_K@Concurrency@@@std@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$concurrent_queue@PEAV?$message@_K@Concurrency@@V?$allocator@PEAV?$message@_K@Concurrency@@@std@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_34_149_3 {
	meta:
		name = "??_G?$ctype@D@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ctype@D@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_160_3 {
	meta:
		name = "??_G?$ctype@G@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ctype@G@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_160_3 {
	meta:
		name = "??_G?$ctype@_W@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ctype@_W@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_673_3 {
	meta:
		name = "??_G?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_674_3 {
	meta:
		name = "??_G?$function@$$A6A_NAEB_K@Z@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$function@$$A6A_NAEB_K@Z@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_675_3 {
	meta:
		name = "??_G?$message@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$message@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3_AllocBase@details@Concurrency@@SAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_676_3 {
	meta:
		name = "??_G?$message@_K@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$message@_K@Concurrency@@UEAA@XZ 0028 ??3_AllocBase@details@Concurrency@@SAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_110_173_1 {
	meta:
		name = "??_G?$messages@D@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$messages@D@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_374_1 {
	meta:
		name = "??_G?$messages@G@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$messages@G@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_375_1 {
	meta:
		name = "??_G?$messages@_W@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$messages@_W@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_110_174_1 {
	meta:
		name = "??_G?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$money_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_376_1 {
	meta:
		name = "??_G?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$money_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_457_2 {
	meta:
		name = "??_G?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$money_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_98_233_3 {
	meta:
		name = "??_G?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$money_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_458_2 {
	meta:
		name = "??_G?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$money_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_459_2 {
	meta:
		name = "??_G?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$money_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_110_176_1 {
	meta:
		name = "??_G?$moneypunct@D$00@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$moneypunct@D$00@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_110_177_1 {
	meta:
		name = "??_G?$moneypunct@D$0A@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$moneypunct@D$0A@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_495_3 {
	meta:
		name = "??_G?$moneypunct@G$00@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$moneypunct@G$00@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_381_1 {
	meta:
		name = "??_G?$moneypunct@G$0A@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$moneypunct@G$0A@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_382_1 {
	meta:
		name = "??_G?$moneypunct@_W$00@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$moneypunct@_W$00@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_498_3 {
	meta:
		name = "??_G?$moneypunct@_W$0A@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$moneypunct@_W$0A@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_677_2 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_678_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_679_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_680_1 {
	meta:
		name = "??_G?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_71_115_1 {
	meta:
		name = "??_G?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$num_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_499_3 {
	meta:
		name = "??_G?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$num_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_500_3 {
	meta:
		name = "??_G?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$num_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_71_116_1 {
	meta:
		name = "??_G?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$num_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_501_3 {
	meta:
		name = "??_G?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$num_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_467_2 {
	meta:
		name = "??_G?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$num_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1_132_2 {
	meta:
		name = "??_G?$numpunct@D@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$numpunct@D@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_388_1 {
	meta:
		name = "??_G?$numpunct@G@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$numpunct@G@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_389_1 {
	meta:
		name = "??_G?$numpunct@_W@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$numpunct@_W@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_681_2 {
	meta:
		name = "??_G?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_682_2 {
	meta:
		name = "??_G?$ordered_message_processor@_K@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$ordered_message_processor@_K@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_683_3 {
	meta:
		name = "??_G?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$overwrite_buffer@W4agent_status@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_684_3 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_685_3 {
	meta:
		name = "??_G?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$propagator_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_686_3 {
	meta:
		name = "??_G?$propagator_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$propagator_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@2@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_931_3 {
	meta:
		name = "??_G?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_932_3 {
	meta:
		name = "??_G?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_934_71_0 {
	meta:
		name = "??_G?$shared_ptr@V__ExceptionPtr@@@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$shared_ptr@V__ExceptionPtr@@@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_687_2 {
	meta:
		name = "??_G?$single_assignment@_K@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$single_assignment@_K@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_688_1 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$single_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_689_3 {
	meta:
		name = "??_G?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_690_3 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_691_3 {
	meta:
		name = "??_G?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_692_1 {
	meta:
		name = "??_G?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_693_1 {
	meta:
		name = "??_G?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_110_178_1 {
	meta:
		name = "??_G?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_505_3 {
	meta:
		name = "??_G?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_391_1 {
	meta:
		name = "??_G?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_26_223_2 {
	meta:
		name = "??_G?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_392_1 {
	meta:
		name = "??_G?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_393_1 {
	meta:
		name = "??_G?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_241_66_0 {
	meta:
		name = "??_GAffinityRestriction@ResourceManager@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1AffinityRestriction@ResourceManager@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_145_0 {
	meta:
		name = "??_GCacheLocalScheduleGroup@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1CacheLocalScheduleGroup@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_146_0 {
	meta:
		name = "??_GCacheLocalScheduleGroupSegment@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1CacheLocalScheduleGroupSegment@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_630_65_0 {
	meta:
		name = "??_GCancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1CancellationBeaconNode@CancellationBeaconStack@ContextBase@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_869_73_0 {
	meta:
		name = "??_GCancellationTokenRegistration_TaskProc@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1CancellationTokenRegistration_TaskProc@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_630_66_0 {
	meta:
		name = "??_GContext@Concurrency@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1Context@Concurrency@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_630_67_0 {
	meta:
		name = "??_GContextBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ContextBase@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_989_39_0 {
	meta:
		name = "??_GExecutionResource@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ExecutionResource@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_916_47_0 {
	meta:
		name = "??_GExternalContextBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ExternalContextBase@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_147_0 {
	meta:
		name = "??_GFairScheduleGroup@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1FairScheduleGroup@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_148_0 {
	meta:
		name = "??_GFairScheduleGroupSegment@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1FairScheduleGroupSegment@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1117_57_0 {
	meta:
		name = "??_GFreeThreadProxy@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1FreeThreadProxy@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1117_58_0 {
	meta:
		name = "??_GFreeThreadProxyFactory@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1FreeThreadProxyFactory@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1332_38_0 {
	meta:
		name = "??_GFreeVirtualProcessorRoot@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1FreeVirtualProcessorRoot@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1117_59_0 {
	meta:
		name = "??_GIThreadProxyFactory@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1IThreadProxyFactory@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_688_59_0 {
	meta:
		name = "??_GInternalContextBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1InternalContextBase@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_149_0 {
	meta:
		name = "??_GRealizedChore@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1RealizedChore@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_241_67_0 {
	meta:
		name = "??_GResourceManager@details@Concurrency@@AEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ResourceManager@details@Concurrency@@AEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_372_95_0 {
	meta:
		name = "??_GScheduleGroup@Concurrency@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ScheduleGroup@Concurrency@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_151_0 {
	meta:
		name = "??_GScheduleGroupBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ScheduleGroupBase@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_372_97_0 {
	meta:
		name = "??_GScheduleGroupSegmentBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ScheduleGroupSegmentBase@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_152_0 {
	meta:
		name = "??_GScheduler@Concurrency@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1Scheduler@Concurrency@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_153_0 {
	meta:
		name = "??_GSchedulerBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1SchedulerBase@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_154_0 {
	meta:
		name = "??_GSchedulerPolicy@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1SchedulerPolicy@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_989_40_0 {
	meta:
		name = "??_GSchedulerProxy@details@Concurrency@@IEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1SchedulerProxy@details@Concurrency@@IEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_155_0 {
	meta:
		name = "??_GSchedulingNode@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1SchedulingNode@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_156_0 {
	meta:
		name = "??_GSchedulingRing@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1SchedulingRing@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_393_46_0 {
	meta:
		name = "??_GSegment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1Segment@?$Mailbox@VInternalContextBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_967_36_0 {
	meta:
		name = "??_GSegment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1Segment@?$Mailbox@V_UnrealizedChore@details@Concurrency@@@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_157_0 {
	meta:
		name = "??_GSubAllocator@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1SubAllocator@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_869_74_0 {
	meta:
		name = "??_GTaskStack@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1TaskStack@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1140_32_0 {
	meta:
		name = "??_GThreadInternalContext@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ThreadInternalContext@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_350_28_0 {
	meta:
		name = "??_GThreadProxy@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ThreadProxy@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1140_33_0 {
	meta:
		name = "??_GThreadScheduler@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ThreadScheduler@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1172_23_0 {
	meta:
		name = "??_GThreadVirtualProcessor@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ThreadVirtualProcessor@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1205_28_0 {
	meta:
		name = "??_GTimerObj@?6??wait@Concurrency@@YAXI@Z@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1TimerObj@?6??wait@Concurrency@@YAXI@Z@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1352_33_0 {
	meta:
		name = "??_GTransmogrifiedPrimary@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1TransmogrifiedPrimary@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1117_60_0 {
	meta:
		name = "??_GUMSFreeThreadProxy@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSFreeThreadProxy@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1117_61_0 {
	meta:
		name = "??_GUMSFreeThreadProxyFactory@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSFreeThreadProxyFactory@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_856_49_0 {
	meta:
		name = "??_GUMSFreeVirtualProcessorRoot@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSFreeVirtualProcessorRoot@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_478_35_0 {
	meta:
		name = "??_GUMSSchedulerProxy@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSSchedulerProxy@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1081_29_0 {
	meta:
		name = "??_GUMSSchedulingContext@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSSchedulingContext@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_937_27_0 {
	meta:
		name = "??_GUMSThreadInternalContext@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSThreadInternalContext@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_205_31_0 {
	meta:
		name = "??_GUMSThreadProxy@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSThreadProxy@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1153_32_0 {
	meta:
		name = "??_GUMSThreadScheduler@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSThreadScheduler@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1081_30_0 {
	meta:
		name = "??_GUMSThreadVirtualProcessor@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1UMSThreadVirtualProcessor@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_502_47_0 {
	meta:
		name = "??_GVirtualProcessor@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1VirtualProcessor@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1332_39_0 {
	meta:
		name = "??_GVirtualProcessorRoot@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1VirtualProcessorRoot@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1013_29_0 {
	meta:
		name = "??_GWaiterThreadPool@platform@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1WaiterThreadPool@platform@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_630_69_0 {
	meta:
		name = "??_GWorkQueue@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1WorkQueue@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_869_75_0 {
	meta:
		name = "??_G_AsyncTaskCollection@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_AsyncTaskCollection@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_694_2 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PEAV?$ISource@W4agent_status@Concurrency@@@1@IPEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@@Z@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PEAV?$ISource@W4agent_status@Concurrency@@@1@IPEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@@Z@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_695_1 {
	meta:
		name = "??_G_Blocking_recipient@?1???$_Receive_impl@_K@Concurrency@@YA_KPEAV?$ISource@_K@1@IPEBV?$function@$$A6A_NAEB_K@Z@std@@@Z@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Blocking_recipient@?1???$_Receive_impl@_K@Concurrency@@YA_KPEAV?$ISource@_K@1@IPEBV?$function@$$A6A_NAEB_K@Z@std@@@Z@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_923_2 {
	meta:
		name = "??_G_CancellationTokenRegistration@details@Concurrency@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_CancellationTokenRegistration@details@Concurrency@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_924_2 {
	meta:
		name = "??_G_Chore@details@Concurrency@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Chore@details@Concurrency@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_20_56_1 {
	meta:
		name = "??_G_Concurrent_queue_base_v4@details@Concurrency@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Concurrent_queue_base_v4@details@Concurrency@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_55_1_3 {
	meta:
		name = "??_G_Condition_variable@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Condition_variable@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_868_1 {
	meta:
		name = "??_G_ContinuationTaskHandleBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_ContinuationTaskHandleBase@details@Concurrency@@UEAA@XZ 0028 ??3_AllocBase@details@Concurrency@@SAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_869_1 {
	meta:
		name = "??_G_ExceptionHolder@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_ExceptionHolder@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_65_3 {
	meta:
		name = "??_G_Fac_node@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Fac_node@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_101_150_3 {
	meta:
		name = "??_G_Facet_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Facet_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_927_2 {
	meta:
		name = "??_G_Future_error_category@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Future_error_category@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_51_72_3 {
	meta:
		name = "??_G_Generic_error_category@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Generic_error_category@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_790_95_0 {
	meta:
		name = "??_G_Interruption_exception@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Interruption_exception@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_10_42_2 {
	meta:
		name = "??_G_Iostream_error_category@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Iostream_error_category@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_55_1 {
	meta:
		name = "??_G_Locimp@locale@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Locimp@locale@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_873_1 {
	meta:
		name = "??_G_RefCounter@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_RefCounter@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_869_79_0 {
	meta:
		name = "??_G_RefCounterBase@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_RefCounterBase@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_934_72_0 {
	meta:
		name = "??_G_Ref_count_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Ref_count_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_67_64_2 {
	meta:
		name = "??_G_System_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_System_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_59_1 {
	meta:
		name = "??_G_System_error_category@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_System_error_category@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_630_70_0 {
	meta:
		name = "??_G_TaskCollection@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_TaskCollection@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_943_3 {
	meta:
		name = "??_G_TaskProcHandle@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_TaskProcHandle@details@Concurrency@@UEAA@XZ 0028 ??3_AllocBase@details@Concurrency@@SAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_108_877_1 {
	meta:
		name = "??_G_TaskProcThunk@details@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_TaskProcThunk@details@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_935_2 {
	meta:
		name = "??_G_Task_impl_base@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Task_impl_base@details@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1205_29_0 {
	meta:
		name = "??_G_Timer@details@Concurrency@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_Timer@details@Concurrency@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_946_3 {
	meta:
		name = "??_G_UnrealizedChore@details@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1_UnrealizedChore@details@Concurrency@@UEAA@XZ 0028 ??3_AllocBase@details@Concurrency@@SAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_934_73_0 {
	meta:
		name = "??_G__ExceptionPtr@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1__ExceptionPtr@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_912_15_0 {
	meta:
		name = "??_G__non_rtti_object@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1__non_rtti_object@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_696_2 {
	meta:
		name = "??_Gagent@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1agent@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_81_57_2 {
	meta:
		name = "??_Gbad_alloc@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1bad_alloc@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_912_16_0 {
	meta:
		name = "??_Gbad_cast@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1bad_cast@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_586_4_0 {
	meta:
		name = "??_Gbad_exception@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1bad_exception@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_61_1 {
	meta:
		name = "??_Gbad_function_call@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1bad_function_call@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_790_96_0 {
	meta:
		name = "??_Gbad_target@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1bad_target@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_912_17_0 {
	meta:
		name = "??_Gbad_typeid@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1bad_typeid@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_938_2 {
	meta:
		name = "??_Gbad_weak_ptr@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1bad_weak_ptr@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_14_149_2 {
	meta:
		name = "??_Gcodecvt_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1codecvt_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_790_97_0 {
	meta:
		name = "??_Gcontext_self_unblock@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1context_self_unblock@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_790_98_0 {
	meta:
		name = "??_Gcontext_unblock_unbalanced@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1context_unblock_unbalanced@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_52_1 {
	meta:
		name = "??_Gcritical_section@Concurrency@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1critical_section@Concurrency@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_26_228_2 {
	meta:
		name = "??_Gctype_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ctype_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_790_99_0 {
	meta:
		name = "??_Gdefault_scheduler_exists@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1default_scheduler_exists@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_20_148_3 {
	meta:
		name = "??_Gerror_category@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1error_category@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_912_18_0 {
	meta:
		name = "??_Gexception@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1exception@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_869_82_0 {
	meta:
		name = "??_Gexception_ptr@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1exception_ptr@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_89_129_1 {
	meta:
		name = "??_Gfacet@locale@std@@MEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1facet@locale@std@@MEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_72_170_3 {
	meta:
		name = "??_Gfailure@ios_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1failure@ios_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_940_2 {
	meta:
		name = "??_Gfuture_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1future_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_133_60_0 {
	meta:
		name = "??_Gimproper_lock@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1improper_lock@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_160_0 {
	meta:
		name = "??_Gimproper_scheduler_attach@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1improper_scheduler_attach@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_790_102_0 {
	meta:
		name = "??_Gimproper_scheduler_detach@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1improper_scheduler_detach@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_790_103_0 {
	meta:
		name = "??_Gimproper_scheduler_reference@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1improper_scheduler_reference@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_698_2 {
	meta:
		name = "??_Ginvalid_argument@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_argument@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_699_1 {
	meta:
		name = "??_Ginvalid_link_target@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_link_target@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_790_105_0 {
	meta:
		name = "??_Ginvalid_multiple_scheduling@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_multiple_scheduling@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_951_3 {
	meta:
		name = "??_Ginvalid_operation@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_operation@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_688_63_0 {
	meta:
		name = "??_Ginvalid_oversubscribe_operation@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_oversubscribe_operation@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_790_109_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_thread_specification@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_scheduler_policy_thread_specification@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_34_0 {
	meta:
		name = "??_Ginvalid_scheduler_policy_value@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1invalid_scheduler_policy_value@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_104_131_1 {
	meta:
		name = "??_Gios_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1ios_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_934_76_0 {
	meta:
		name = "??_Glength_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1length_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_16_132_1 {
	meta:
		name = "??_Glocale@std@@QEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1locale@std@@QEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_42_1 {
	meta:
		name = "??_Glock_error@threads@stdext@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1lock_error@threads@stdext@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_952_3 {
	meta:
		name = "??_Glogic_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1logic_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_702_1 {
	meta:
		name = "??_Gmessage_not_found@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1message_not_found@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_98_245_3 {
	meta:
		name = "??_Gmessages_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1messages_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_790_112_0 {
	meta:
		name = "??_Gmissing_wait@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1missing_wait@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_110_188_1 {
	meta:
		name = "??_Gmoney_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1money_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_790_113_0 {
	meta:
		name = "??_Gnested_scheduler_missing_detach@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1nested_scheduler_missing_detach@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_122_703_3 {
	meta:
		name = "??_Goperation_timed_out@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1operation_timed_out@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_123_93_1 {
	meta:
		name = "??_Gout_of_range@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1out_of_range@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_57_81_3 {
	meta:
		name = "??_Goverflow_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1overflow_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_123_94_1 {
	meta:
		name = "??_Grange_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1range_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_86_81_2 {
	meta:
		name = "??_Gregex_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1regex_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_156_2 {
	meta:
		name = "??_Gruntime_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1runtime_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_790_115_0 {
	meta:
		name = "??_Gscheduler_not_attached@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1scheduler_not_attached@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1153_33_0 {
	meta:
		name = "??_Gscheduler_resource_allocation_error@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1scheduler_resource_allocation_error@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_205_33_0 {
	meta:
		name = "??_Gscheduler_worker_creation_error@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1scheduler_worker_creation_error@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_44_135_1 {
	meta:
		name = "??_Gsystem_error@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1system_error@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_790_118_0 {
	meta:
		name = "??_Gtask_canceled@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1task_canceled@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_44_1 {
	meta:
		name = "??_Gthread_resource_error@threads@stdext@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1thread_resource_error@threads@stdext@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_26_234_2 {
	meta:
		name = "??_Gtime_base@std@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1time_base@std@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_290_5_0 {
	meta:
		name = "??_Gtype_info@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1type_info@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_241_73_0 {
	meta:
		name = "??_Gunsupported_os@Concurrency@@UEAAPEAXI@Z"
		size = 54
		refs = "0013 ??1unsupported_os@Concurrency@@UEAA@XZ 0028 ??3@YAXPEAX@Z"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 38 83 E0 01 85 C0 74 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_35_0 {
	meta:
		name = "??_H@YAXPEAX_KHP6APEAX0@Z@Z"
		size = 78
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 8B 44 24 40 FF C8 89 44 24 40 83 7C 24 40 00 7C 20 48 8B 4C 24 30 FF 54 24 48 48 8B 44 24 38 48 8B 4C 24 30 48 03 C8 48 8B C1 48 89 44 24 30 EB CF 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_36_0 {
	meta:
		name = "??__Eallocator_arg@std@@YAXXZ"
		size = 28
		altNames = "??__E_10@placeholders@std@@YAXXZ ??__E_11@placeholders@std@@YAXXZ ??__E_12@placeholders@std@@YAXXZ ??__E_13@placeholders@std@@YAXXZ ??__E_14@placeholders@std@@YAXXZ ??__E_15@placeholders@std@@YAXXZ ??__E_16@placeholders@std@@YAXXZ ??__E_17@placeholders@std@@YAXXZ ??__E_18@placeholders@std@@YAXXZ ??__E_19@placeholders@std@@YAXXZ ??__E_1@placeholders@std@@YAXXZ ??__E_20@placeholders@std@@YAXXZ ??__E_2@placeholders@std@@YAXXZ ??__E_3@placeholders@std@@YAXXZ ??__E_4@placeholders@std@@YAXXZ ??__E_5@placeholders@std@@YAXXZ ??__E_6@placeholders@std@@YAXXZ ??__E_7@placeholders@std@@YAXXZ ??__E_8@placeholders@std@@YAXXZ ??__E_9@placeholders@std@@YAXXZ ??__E_Tuple_alloc@std@@YAXXZ ??__Eadopt_lock@std@@YAXXZ ??__Edefer_lock@std@@YAXXZ ??__Enothrow@std@@YAXXZ ??__Epiecewise_construct@std@@YAXXZ ??__Etry_to_lock@std@@YAXXZ"
	strings:
		$1 = { 40 57 48 83 EC 10 48 8D 04 24 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 83 C4 10 5F C3 }
	condition:
		$1
}

rule file_6_38_0 {
	meta:
		name = "?GetPolicyValue@SchedulerPolicy@Concurrency@@QEBAIW4PolicyElementKey@2@@Z"
		size = 89
		refs = "0012 ?_ValidPolicyKey@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@@Z 0022 ?_StringFromPolicyKey@SchedulerPolicy@Concurrency@@CAPEADI@Z 002f ??0invalid_scheduler_policy_key@Concurrency@@QEAA@PEBD@Z 0036 _TI2?AVinvalid_scheduler_policy_key@Concurrency@@ 0040 _CxxThrowException"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 48 8B 4C 24 58 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 27 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 00 48 63 4C 24 58 8B 04 88 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_6_39_0 {
	meta:
		name = "?SetConcurrencyLimits@SchedulerPolicy@Concurrency@@QEAAXII@Z"
		size = 330
		refs = "0022 ?_ValidPolicyValue@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@I@Z 0033 ?_StringFromPolicyKey@SchedulerPolicy@Concurrency@@CAPEADI@Z 0040 ??0invalid_scheduler_policy_value@Concurrency@@QEAA@PEBD@Z 0047 _TI2?AVinvalid_scheduler_policy_value@Concurrency@@ 0051 _CxxThrowException 00a4 ?_AreConcurrencyLimitsValid@SchedulerPolicy@Concurrency@@CA_NII@Z 00b5 ??0invalid_scheduler_policy_thread_specification@Concurrency@@QEAA@XZ 00bc _TI2?AVinvalid_scheduler_policy_thread_specification@Concurrency@@ 00d3 ?_ArePolicyCombinationsValid@SchedulerPolicy@Concurrency@@AEBA_NXZ 00e4 ??0invalid_scheduler_policy_value@Concurrency@@QEAA@XZ 013e ?_ResolvePolicyValues@SchedulerPolicy@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 44 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 81 EC 88 00 00 00 8B 94 24 A0 00 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 28 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 20 E8 ?? ?? ?? ?? 8B 94 24 98 00 00 00 B9 02 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 38 E8 ?? ?? ?? ?? 8B 94 24 A0 00 00 00 8B 8C 24 98 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 1B 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 1B 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 8B 00 B9 04 00 00 00 48 6B C9 01 8B 94 24 A0 00 00 00 89 14 08 48 8B 84 24 90 00 00 00 48 8B 00 B9 04 00 00 00 48 6B C9 02 8B 94 24 98 00 00 00 89 14 08 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_6_40_0 {
	meta:
		name = "?SetPolicyValue@SchedulerPolicy@Concurrency@@QEAAIW4PolicyElementKey@2@I@Z"
		size = 209
		refs = "0017 ?_ValidPolicyKey@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@@Z 0035 ?_StringFromPolicyKey@SchedulerPolicy@Concurrency@@CAPEADI@Z 0042 ??0invalid_scheduler_policy_key@Concurrency@@QEAA@PEBD@Z 0049 _TI2?AVinvalid_scheduler_policy_key@Concurrency@@ 0053 _CxxThrowException 0063 ?_ValidPolicyValue@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@I@Z 0080 ??0invalid_scheduler_policy_value@Concurrency@@QEAA@PEBD@Z 0087 _TI2?AVinvalid_scheduler_policy_value@Concurrency@@ 009f ?GetPolicyValue@SchedulerPolicy@Concurrency@@QEBAIW4PolicyElementKey@2@@Z 00c4 ?_ResolvePolicyValues@SchedulerPolicy@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 44 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 68 8B 4C 24 78 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 0E 83 7C 24 78 02 74 07 83 7C 24 78 01 75 27 8B 4C 24 78 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 8B 94 24 80 00 00 00 8B 4C 24 78 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 27 8B 4C 24 78 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 40 E8 ?? ?? ?? ?? 8B 54 24 78 48 8B 4C 24 70 E8 ?? ?? ?? ?? 89 44 24 20 48 8B 44 24 70 48 8B 00 48 63 4C 24 78 8B 94 24 80 00 00 00 89 14 88 48 8B 4C 24 70 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_6_41_0 {
	meta:
		name = "?_AreConcurrencyLimitsValid@SchedulerPolicy@Concurrency@@AEBA_NXZ"
		size = 61
		refs = "0014 ?GetPolicyValue@SchedulerPolicy@Concurrency@@QEBAIW4PolicyElementKey@2@@Z 0034 ?_AreConcurrencyLimitsValid@SchedulerPolicy@Concurrency@@CA_NII@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 BA 01 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 20 BA 02 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 8B 4C 24 20 8B D1 8B C8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_6_42_0 {
	meta:
		name = "?_AreConcurrencyLimitsValid@SchedulerPolicy@Concurrency@@CA_NII@Z"
		size = 39
	strings:
		$1 = { 89 54 24 10 89 4C 24 08 83 7C 24 10 FF 74 15 83 7C 24 08 FF 74 0E 8B 44 24 08 39 44 24 10 73 04 32 C0 EB 02 B0 01 C3 }
	condition:
		$1
}

rule file_6_44_0 {
	meta:
		name = "?_Assign@SchedulerPolicy@Concurrency@@AEAAXAEBV12@@Z"
		size = 57
		refs = "0030 memcpy"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 28 00 00 00 48 8B 44 24 48 48 8B 00 48 8B 4C 24 40 48 8B 09 4C 8B 44 24 20 48 8B D0 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_6_45_0 {
	meta:
		name = "?_Assign@cancellation_token_source@Concurrency@@AEAAXPEAV_CancellationTokenState@details@2@@Z"
		size = 50
		refs = "001c ?_Reference@_RefCounter@details@Concurrency@@QEAAJXZ"
		altNames = "?_Assign@cancellation_token@Concurrency@@AEAAXPEAV_CancellationTokenState@details@2@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 83 7C 24 38 00 74 0A 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_46_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_4f309ec3f1591cc309f87a3a1238f559>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_4f309ec3f1591cc309f87a3a1238f559>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1205_37_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_af546d3a72174e50889cf57d5b8ef1a7>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_af546d3a72174e50889cf57d5b8ef1a7>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_99_68_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_9019455767b65677490b1d7ba55f2ec7>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9019455767b65677490b1d7ba55f2ec7>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_92_65_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_0aa3eeb7fc6a1a7ab2bd619ed42cef02>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_0aa3eeb7fc6a1a7ab2bd619ed42cef02>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_74_24_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_8ee961418814d5bf472957f658b2a085>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_8ee961418814d5bf472957f658b2a085>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_20_64_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_9d91f4c20d4b84890709d629e3eda655>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9d91f4c20d4b84890709d629e3eda655>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_15_720_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_a0f18cf06b229bd63c2fac3645485d8c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_a0f18cf06b229bd63c2fac3645485d8c>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1352_65_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_349d5681a8333e5bd10da4776df83714>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_349d5681a8333e5bd10da4776df83714>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1332_73_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_21ed68d291bc97f6ce40664916d565c4>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_21ed68d291bc97f6ce40664916d565c4>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1328_45_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_26da27b0aac018e5d14f38d73214e9c2>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_26da27b0aac018e5d14f38d73214e9c2>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1210_160_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_d4b5ea99cdfdbe00970f3567e0471f71>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_d4b5ea99cdfdbe00970f3567e0471f71>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_108_920_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_4b4f7bbdf60ea0fcc31469056233f33d>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_4b4f7bbdf60ea0fcc31469056233f33d>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1200_24_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_294bcb8bc95793505f0ce7948783cc2d>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_294bcb8bc95793505f0ce7948783cc2d>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1172_30_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_6e36059cbffeaeca4a48396da8c676a3>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_6e36059cbffeaeca4a48396da8c676a3>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1153_73_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_3fdf5a3bf3c558fb7d020342b3e3ecc4>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_3fdf5a3bf3c558fb7d020342b3e3ecc4>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1140_73_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_7c3f04af9f99d98b77477e35fe019769>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_7c3f04af9f99d98b77477e35fe019769>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1117_132_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_df5da3f88215411accbf3d551e9f2f37>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_df5da3f88215411accbf3d551e9f2f37>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1105_49_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_e08ea6f40b15185036d0953e08feec00>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_e08ea6f40b15185036d0953e08feec00>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1081_50_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_84facb30090f515e7b1bbafb4c9a7a16>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_84facb30090f515e7b1bbafb4c9a7a16>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_1013_41_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_464601bb309619f9e38e1053581c8b2f>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_464601bb309619f9e38e1053581c8b2f>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_989_127_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_1e66f546d77ed469181b8bd5fdb0dcbc>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_1e66f546d77ed469181b8bd5fdb0dcbc>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_93_79_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_0aa3eeb7fc6a1a7ab2bd619ed42cef02>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_0aa3eeb7fc6a1a7ab2bd619ed42cef02>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_122_720_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_a0f18cf06b229bd63c2fac3645485d8c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_a0f18cf06b229bd63c2fac3645485d8c>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_115_31_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_789e7dbf30254e9f4e5c9f04cb8ae4bf>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_789e7dbf30254e9f4e5c9f04cb8ae4bf>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_108_80_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_0aa3eeb7fc6a1a7ab2bd619ed42cef02>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_0aa3eeb7fc6a1a7ab2bd619ed42cef02>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_100_83_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_9019455767b65677490b1d7ba55f2ec7>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9019455767b65677490b1d7ba55f2ec7>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_87_24_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_8ee961418814d5bf472957f658b2a085>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_8ee961418814d5bf472957f658b2a085>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_71_64_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_9d91f4c20d4b84890709d629e3eda655>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9d91f4c20d4b84890709d629e3eda655>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_58_993_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_4b4f7bbdf60ea0fcc31469056233f33d>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_4b4f7bbdf60ea0fcc31469056233f33d>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_54_121_3 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_9382d68b9a24ce66c7928ba5a7172089>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9382d68b9a24ce66c7928ba5a7172089>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_978_480_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_6a4a14dee8e1b31efd89026e5270571c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_6a4a14dee8e1b31efd89026e5270571c>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_81_64_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_9d91f4c20d4b84890709d629e3eda655>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9d91f4c20d4b84890709d629e3eda655>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_75_24_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_8ee961418814d5bf472957f658b2a085>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_8ee961418814d5bf472957f658b2a085>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_72_31_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_789e7dbf30254e9f4e5c9f04cb8ae4bf>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_789e7dbf30254e9f4e5c9f04cb8ae4bf>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_65_82_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_9019455767b65677490b1d7ba55f2ec7>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9019455767b65677490b1d7ba55f2ec7>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_62_981_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_4b4f7bbdf60ea0fcc31469056233f33d>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_4b4f7bbdf60ea0fcc31469056233f33d>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_18_720_2 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_a0f18cf06b229bd63c2fac3645485d8c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_a0f18cf06b229bd63c2fac3645485d8c>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_123_106_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_9382d68b9a24ce66c7928ba5a7172089>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9382d68b9a24ce66c7928ba5a7172089>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_116_31_1 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_789e7dbf30254e9f4e5c9f04cb8ae4bf>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_789e7dbf30254e9f4e5c9f04cb8ae4bf>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_288_44_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_172be19dea7500ca6c398fe3625e7d6f>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_172be19dea7500ca6c398fe3625e7d6f>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_563_65_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_210e261af42dd89513ab9b87d35dcdae>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_210e261af42dd89513ab9b87d35dcdae>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_562_37_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_86065f47d7bd75fa202583640c2daf5c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_86065f47d7bd75fa202583640c2daf5c>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_502_130_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_81be46b36946dea1582ccc149adc898b>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_81be46b36946dea1582ccc149adc898b>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_478_61_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_de335a338d31a18b265829348f9c173a>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_de335a338d31a18b265829348f9c173a>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_455_56_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_31a06f7a109cabeff6d2606ba0fb4709>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_31a06f7a109cabeff6d2606ba0fb4709>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_417_100_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_e295ff122d0cb08069f1941b9918174e>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_e295ff122d0cb08069f1941b9918174e>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_393_96_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_d706c475399fb4da4ce69251d1ecf59e>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_d706c475399fb4da4ce69251d1ecf59e>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_372_222_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_d70fd5481fe106e846cf3419378f032d>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_d70fd5481fe106e846cf3419378f032d>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_350_43_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_618abf99f167c7a97575a06b06227e91>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_618abf99f167c7a97575a06b06227e91>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_568_55_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_227f2a6d2f0fd793a6959dc5f99010cf>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_227f2a6d2f0fd793a6959dc5f99010cf>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_272_40_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_22a3e8643a03ea7327c3b0e02a63c323>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_22a3e8643a03ea7327c3b0e02a63c323>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_241_248_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_715586d55be594d0e9637c8c1c3755ee>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_715586d55be594d0e9637c8c1c3755ee>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_223_63_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_cb8f2bcadd1f7763372fe4e4aa50437f>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_cb8f2bcadd1f7763372fe4e4aa50437f>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_205_71_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_a82b98f7e2c6043eed4851637b7cc3e6>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_a82b98f7e2c6043eed4851637b7cc3e6>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_198_40_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_069e32e6c00f5d305ada4a80e39380a3>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_069e32e6c00f5d305ada4a80e39380a3>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_159_25_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_877e36a9b8f2beec69b03ec0697600b5>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_877e36a9b8f2beec69b03ec0697600b5>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_133_96_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_e13791f8e805bf75ac0524a1f9b3f99c>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_e13791f8e805bf75ac0524a1f9b3f99c>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_68_50_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_20f446c26f46874b82540befc88a529a>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_20f446c26f46874b82540befc88a529a>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_767_39_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_2835475992419787e20c95841abbc371>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_2835475992419787e20c95841abbc371>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_967_78_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_c80257f86a38a015eb1e9cb0825778f2>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_c80257f86a38a015eb1e9cb0825778f2>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_952_46_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_d9d7bd5f35fe0d976683ca071d74f79e>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_d9d7bd5f35fe0d976683ca071d74f79e>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_937_60_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_9474bfb0de79727fb4f6d2a6e115fd83>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9474bfb0de79727fb4f6d2a6e115fd83>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_916_90_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_5a630fb471fdfbbc6a947cc3c61ce21b>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_5a630fb471fdfbbc6a947cc3c61ce21b>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_897_44_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_26a068338f0cda3166f22367ebccaf09>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_26a068338f0cda3166f22367ebccaf09>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_869_141_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_a089b1c204f74f21f85c3e9ff2c574c1>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_a089b1c204f74f21f85c3e9ff2c574c1>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_856_120_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_cdfc667e9119b7a203a9991a55b8dd61>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_cdfc667e9119b7a203a9991a55b8dd61>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_816_49_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_9fce432520bfa06a9827a71bd2f8eca3>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9fce432520bfa06a9827a71bd2f8eca3>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_790_124_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_641203ede6f833c1db99207d0b358097>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_641203ede6f833c1db99207d0b358097>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_63_31_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_037bc7ce6502ec890500c5533fbc3dfc>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_037bc7ce6502ec890500c5533fbc3dfc>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_725_36_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_492bc47d8aa9efc8d9d8aa9c5b0056e7>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_492bc47d8aa9efc8d9d8aa9c5b0056e7>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_711_30_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_b27592a6f7dba7f6725788fb5a9e6656>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_b27592a6f7dba7f6725788fb5a9e6656>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_688_182_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_491a9a05af435afb7f83e67bc1a93029>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_491a9a05af435afb7f83e67bc1a93029>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_678_66_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_65768df68addf95c6fb1a2e153ca26af>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_65768df68addf95c6fb1a2e153ca26af>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_671_32_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_36f990409ada6d03288478c172d2c439>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_36f990409ada6d03288478c172d2c439>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_630_242_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_b983c5cc1c0237b64124564f0b2924e5>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_b983c5cc1c0237b64124564f0b2924e5>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_606_50_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_8df48103692e73c34f0dca9919093edb>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_8df48103692e73c34f0dca9919093edb>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_599_57_0 {
	meta:
		name = "?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
		size = 195
		refs = "002a ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 003c ??0TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ 0056 ??0scoped_lock@critical_section@Concurrency@@QEAA@AEAV12@@Z 0072 ?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z 007d ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ 008c ??$for_each@V<lambda_9feb76b72e25345552edb63bc7288f00>@@@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXV<lambda_9feb76b72e25345552edb63bc7288f00>@@@Z 00af ?set@event@Concurrency@@QEAAXXZ 00ba ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 28 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 10 45 33 C0 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 88 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 83 C0 60 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 84 24 80 00 00 00 48 05 98 00 00 00 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F B6 54 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 10 02 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 18 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_6_47_0 {
	meta:
		name = "?dtor$0@?0??_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ@4HA"
		size = 24
		refs = "000e ??1TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_122_94_3 {
	meta:
		name = "?dtor$0@?0???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@0@PEAV?$ISource@W4agent_status@Concurrency@@@0@IPEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@@Z@4HA"
		size = 24
		refs = "000e ??1_Blocking_recipient@?1???$_Receive_impl@W4agent_status@Concurrency@@@Concurrency@@YA?AW4agent_status@1@PEAV?$ISource@W4agent_status@Concurrency@@@1@IPEBV?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@@Z@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_122_140_3 {
	meta:
		name = "?dtor$0@?0???$_send@W4agent_status@Concurrency@@@_Originator@details@Concurrency@@SA_NPEAV?$ITarget@W4agent_status@Concurrency@@@2@AEBW4agent_status@2@@Z@4HA"
		size = 24
		refs = "000e ??1?$_AnonymousOriginator@W4agent_status@Concurrency@@@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_122_143_3 {
	meta:
		name = "?dtor$0@?0???$_send@_K@_Originator@details@Concurrency@@SA_NPEAV?$ITarget@_K@2@AEB_K@Z@4HA"
		size = 24
		refs = "000e ??1?$_AnonymousOriginator@_K@details@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_71_36_3 {
	meta:
		name = "?dtor$0@?0???1_Pop_finalizer@_Micro_queue@details@Concurrency@@QEAA@XZ@4HA"
		size = 24
		refs = "000e ??1_SpinLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_98_219_3 {
	meta:
		name = "?dtor$0@?0???G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBA?AV01@_J@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_88_424_2 {
	meta:
		name = "?dtor$0@?0???G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBA?AV01@_J@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_38_82_3 {
	meta:
		name = "?dtor$0@?0???G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBA?AV01@_J@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_98_223_3 {
	meta:
		name = "?dtor$0@?0???H?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBA?AV01@_J@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_88_432_2 {
	meta:
		name = "?dtor$0@?0???H?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBA?AV01@_J@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_33_469_3 {
	meta:
		name = "?dtor$0@?0???H?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBA?AV01@_J@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1140_45_0 {
	meta:
		name = "?dtor$0@?0??CreateScheduleGroup@SchedulerBase@details@Concurrency@@UEAAPEAVScheduleGroup@3@XZ@4HA"
		size = 24
		refs = "000e ??1location@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_978_349_0 {
	meta:
		name = "?dtor$0@?0??IsAvailableLocation@SchedulerBase@details@Concurrency@@UEBA_NAEBVlocation@3@@Z@4HA"
		size = 24
		refs = "000e ??1QuickBitSet@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_967_70_0 {
	meta:
		name = "?dtor$0@?0??Sweep@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@QEAAXP6A_NPEAV_UnrealizedChore@23@PEAX@Z12@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_630_226_0 {
	meta:
		name = "?dtor$0@?0??SyncPop@?$WorkStealingQueue@V_UnrealizedChore@details@Concurrency@@V_CriticalNonReentrantLock@23@@details@Concurrency@@AEAAPEAV_UnrealizedChore@23@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_62_1008_2 {
	meta:
		name = "?dtor$0@?0??_CaptureMultiFramesCallstack@_TaskCreationCallstack@details@Concurrency@@SA?AV123@_K@Z@4HA"
		size = 24
		refs = "000e ??1_TaskCreationCallstack@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_58_1060_3 {
	meta:
		name = "?dtor$0@?0??_Current_exception@exception_ptr@std@@SA?AV12@XZ@4HA"
		size = 24
		refs = "000e ??1exception_ptr@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_26_354_2 {
	meta:
		name = "?dtor$0@?0??_Init@?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z@4HA"
		size = 24
		refs = "000e ??1_Timevec@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_88_793_2 {
	meta:
		name = "?dtor$0@?0??_Init@?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z@4HA"
		size = 24
		refs = "000e ??1_Timevec@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_33_832_3 {
	meta:
		name = "?dtor$0@?0??_Init@?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@IEAAXAEBV_Locinfo@2@@Z@4HA"
		size = 24
		refs = "000e ??1_Timevec@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_934_123_0 {
	meta:
		name = "?dtor$0@?0??_InitBadAllocException@__ExceptionPtr@@CA?AV?$shared_ptr@V__ExceptionPtr@@@std@@XZ@4HA"
		size = 24
		refs = "000e ??1bad_alloc@std@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_20_240_3 {
	meta:
		name = "?dtor$0@?0??_Locimp_Addfac@_Locimp@locale@std@@CAXPEAV123@PEAVfacet@23@_K@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_678_90_0 {
	meta:
		name = "?dtor$0@?0??_RegisterCallback@_CancellationTokenState@details@Concurrency@@QEAAXPEAV_CancellationTokenRegistration@23@@Z@4HA"
		size = 24
		refs = "000e ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_108_1198_1 {
	meta:
		name = "?dtor$0@?0??_ScheduleContinuationTask@_Task_impl_base@details@Concurrency@@QEAAXPEAU_ContinuationTaskHandleBase@23@@Z@4HA"
		size = 24
		refs = "000e ??1?$function@$$A6AXXZ@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_18_987_2 {
	meta:
		name = "?dtor$0@?0??add@?$source_link_manager@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QEAAXPEAV?$ISource@W4agent_status@Concurrency@@@2@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_122_989_3 {
	meta:
		name = "?dtor$0@?0??add@?$source_link_manager@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@QEAAXPEAV?$ISource@_K@2@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_18_1072_2 {
	meta:
		name = "?dtor$0@?0??initialize_source@?$source_block@V?$multi_link_registry@V?$ITarget@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@V?$ordered_message_processor@W4agent_status@Concurrency@@@2@@Concurrency@@IEAAXPEAVScheduler@2@PEAVScheduleGroup@2@@Z@4HA"
		size = 24
		refs = "000e ??1?$function@$$A6AXPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@Z@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_18_1074_2 {
	meta:
		name = "?dtor$0@?0??initialize_source@?$source_block@V?$multi_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@IEAAXPEAVScheduler@2@PEAVScheduleGroup@2@@Z@4HA"
		size = 24
		refs = "000e ??1?$function@$$A6AXPEAV?$message@_K@Concurrency@@@Z@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_18_1076_2 {
	meta:
		name = "?dtor$0@?0??initialize_source@?$source_block@V?$single_link_registry@V?$ITarget@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@IEAAXPEAVScheduler@2@PEAVScheduleGroup@2@@Z@4HA"
		size = 24
		refs = "000e ??1?$function@$$A6AXPEAV?$message@_K@Concurrency@@@Z@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_18_1081_2 {
	meta:
		name = "?dtor$0@?0??initialize_target@?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@IEAAXPEAVScheduler@2@PEAVScheduleGroup@2@@Z@4HA"
		size = 24
		refs = "000e ??1?$function@$$A6AXPEAV?$message@_K@Concurrency@@@Z@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_108_1390_1 {
	meta:
		name = "?dtor$0@?0??set@?$task_completion_event@E@Concurrency@@QEBA_NE@Z@4HA"
		size = 24
		refs = "000e ??1?$vector@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_122_1254_3 {
	meta:
		name = "?dtor$0@?0??unlink_sources@?$target_block@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@V?$ordered_message_processor@_K@2@@Concurrency@@MEAAXXZ@4HA"
		size = 24
		refs = "000e ??1?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_417_135_0 {
	meta:
		name = "?dtor$0@?0??wait@_Condition_variable@details@Concurrency@@QEAAXAEAVcritical_section@3@@Z@4HA"
		size = 24
		refs = "000e ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_57_367_2 {
	meta:
		name = "?dtor$0@?0??widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QEBADD@Z@4HA"
		size = 24
		refs = "000e ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_84_395_3 {
	meta:
		name = "?dtor$0@?0??widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QEBAGD@Z@4HA"
		size = 24
		refs = "000e ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_85_395_3 {
	meta:
		name = "?dtor$0@?0??widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QEBA_WD@Z@4HA"
		size = 24
		refs = "000e ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_978_271_0 {
	meta:
		name = "?dtor$1@?0??GetDefaultScheduler@SchedulerBase@details@Concurrency@@CAPEAV123@XZ@4HA"
		size = 24
		refs = "000e ??1SchedulerPolicy@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1_234_2 {
	meta:
		name = "?dtor$1@?0??_Locimp_ctor@_Locimp@locale@std@@CAXPEAV123@AEBV123@@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_108_1320_1 {
	meta:
		name = "?dtor$1@?0??do_while@details@Concurrency@@YA?AV?$task@_N@2@V?$function@$$A6A?AV?$task@_N@Concurrency@@XZ@std@@@Z@4HA"
		size = 24
		refs = "000e ??1?$task@_N@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_71_332_1 {
	meta:
		name = "?dtor$1@?0??global@locale@std@@SA?AV12@AEBV12@@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_18_1300_2 {
	meta:
		name = "?dtor$1@?0??wait_for_one@agent@Concurrency@@SAX_KPEAPEAV12@AEAW4agent_status@2@AEA_KI@Z@4HA"
		size = 24
		refs = "000e ??1?$_OrderBlock@V?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 30 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_6_48_0 {
	meta:
		name = "?dtor$1@?0??_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ@4HA"
		size = 24
		refs = "000e ??1scoped_lock@critical_section@Concurrency@@QEAA@XZ"
		altNames = "?dtor$0@?0??_TransitionedToStarted@?$_Task_impl@E@details@Concurrency@@QEAA_NXZ@4HA ?dtor$0@?0??_TransitionedToStarted@?$_Task_impl@_N@details@Concurrency@@QEAA_NXZ@4HA ?dtor$0@?0??notify_one@_Condition_variable@details@Concurrency@@QEAAXXZ@4HA ?dtor$0@?0??reset@event@Concurrency@@QEAAXXZ@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_62_139_2 {
	meta:
		name = "?dtor$0@?0???$_MakeTToUnitFunc@V?$task@_N@Concurrency@@@details@Concurrency@@YA?AV?$function@$$A6AEV?$task@_N@Concurrency@@@Z@std@@AEBV?$function@$$A6AXV?$task@_N@Concurrency@@@Z@3@@Z@4HA"
		size = 24
		refs = "000e ??1<lambda_485a9cdc6cbb81f288aeb937516efb58>@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_122_97_3 {
	meta:
		name = "?dtor$0@?0???$_Receive_impl@_K@Concurrency@@YA_KPEAV?$ISource@_K@0@IPEBV?$function@$$A6A_NAEB_K@Z@std@@@Z@4HA"
		size = 24
		refs = "000e ??1_Blocking_recipient@?1???$_Receive_impl@_K@Concurrency@@YA_KPEAV?$ISource@_K@1@IPEBV?$function@$$A6A_NAEB_K@Z@std@@@Z@UEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_98_221_3 {
	meta:
		name = "?dtor$0@?0???G?$_String_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEBA_JAEBV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_33_461_3 {
	meta:
		name = "?dtor$0@?0???G?$_String_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEBA_JAEBV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_33_465_3 {
	meta:
		name = "?dtor$0@?0???G?$_String_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEBA_JAEBV?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_856_67_0 {
	meta:
		name = "?dtor$0@?0??CreatePrimary@UMSFreeVirtualProcessorRoot@details@Concurrency@@AEAAXXZ@4HA"
		size = 24
		refs = "000e ??1InitialThreadParam@UMSFreeVirtualProcessorRoot@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_241_109_0 {
	meta:
		name = "?dtor$0@?0??CurrentSubscriptionLevel@ResourceManager@details@Concurrency@@QEAAIII@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_989_75_0 {
	meta:
		name = "?dtor$0@?0??DestroyVirtualProcessorRoot@SchedulerProxy@details@Concurrency@@QEAAXPEAVVirtualProcessorRoot@23@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_978_270_0 {
	meta:
		name = "?dtor$0@?0??GetDefaultScheduler@SchedulerBase@details@Concurrency@@CAPEAV123@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_372_170_0 {
	meta:
		name = "?dtor$0@?0??Initialize@ScheduleGroupSegmentBase@details@Concurrency@@IEAAXPEAVScheduleGroupBase@23@PEAVSchedulingRing@23@PEAVlocation@3@@Z@4HA"
		size = 24
		refs = "000e ??1QuickBitSet@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_562_34_0 {
	meta:
		name = "?dtor$0@?0??LocateSegment@FairScheduleGroup@details@Concurrency@@UEAAPEAVScheduleGroupSegmentBase@23@PEAVlocation@3@_N@Z@4HA"
		size = 24
		refs = "000e ??1location@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_241_204_0 {
	meta:
		name = "?dtor$0@?0??Release@ResourceManager@details@Concurrency@@UEAAIXZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_241_209_0 {
	meta:
		name = "?dtor$0@?0??RemoveExecutionResource@ResourceManager@details@Concurrency@@QEAAXPEAVExecutionResource@23@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_241_211_0 {
	meta:
		name = "?dtor$0@?0??RequestInitialVirtualProcessors@ResourceManager@details@Concurrency@@QEAAPEAUIExecutionResource@3@PEAVSchedulerProxy@23@_N@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_978_449_0 {
	meta:
		name = "?dtor$0@?0??StaticDestruction@SchedulerBase@details@Concurrency@@CAXXZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_869_152_0 {
	meta:
		name = "?dtor$0@?0??_CancelStolenContexts@_TaskCollection@details@Concurrency@@AEAAX_N0@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_81_86_2 {
	meta:
		name = "?dtor$0@?0??_Push@_Micro_queue@details@Concurrency@@QEAAXPEAX_KAEAV_Concurrent_queue_base_v4@23@P8423@EAAXAEAU_Page@423@10@Z@Z@4HA"
		size = 24
		refs = "000e ??1_SpinLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_62_1316_2 {
	meta:
		name = "?dtor$0@?0??_Throw_future_error@std@@YAXAEBVerror_code@1@@Z@4HA"
		size = 24
		refs = "000e ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_184_4_0 {
	meta:
		name = "?dtor$0@?0??_mbrtowc_s_l@@YAHPEAHPEA_WPEBD_K0PEAUlocaleinfo_struct@@@Z@4HA"
		size = 24
		refs = "000e ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_122_1060_3 {
	meta:
		name = "?dtor$0@?0??done@agent@Concurrency@@IEAA_NXZ@4HA"
		size = 24
		refs = "000e ??1?$function@$$A6A_NAEBW4agent_status@Concurrency@@@Z@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_574_6_0 {
	meta:
		name = "?dtor$0@?0??getSystemCP@@YAHH@Z@4HA"
		size = 24
		refs = "000e ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_20_360_3 {
	meta:
		name = "?dtor$0@?0??global@locale@std@@SA?AV12@AEBV12@@Z@4HA"
		size = 24
		refs = "000e ??1locale@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_122_1125_3 {
	meta:
		name = "?dtor$0@?0??propagate_message@?$_Greedy_node@W4agent_status@Concurrency@@@Concurrency@@MEAA?AW4message_status@2@PEAV?$message@W4agent_status@Concurrency@@@2@PEAV?$ISource@W4agent_status@Concurrency@@@2@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_122_1129_3 {
	meta:
		name = "?dtor$0@?0??propagate_message@?$single_assignment@_K@Concurrency@@MEAA?AW4message_status@2@PEAV?$message@_K@2@PEAV?$ISource@_K@2@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_15_1221_1 {
	meta:
		name = "?dtor$0@?0??send_message@?$single_assignment@_K@Concurrency@@MEAA?AW4message_status@2@PEAV?$message@_K@2@PEAV?$ISource@_K@2@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_122_1287_3 {
	meta:
		name = "?dtor$0@?0??wait@?$ordered_message_processor@W4agent_status@Concurrency@@@Concurrency@@UEAAXXZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_122_1289_3 {
	meta:
		name = "?dtor$0@?0??wait@?$ordered_message_processor@_K@Concurrency@@UEAAXXZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_62_1176_2 {
	meta:
		name = "?dtor$1@?0??_JoinAllTokens_Add@details@Concurrency@@YAXAEBVcancellation_token_source@2@PEAV_CancellationTokenState@12@@Z@4HA"
		size = 24
		refs = "000e ??1<lambda_e53710ce91a9b2753e1b6043516fc25a>@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_76_241_3 {
	meta:
		name = "?dtor$1@?0??_Makestr@_System_error@std@@CA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@Verror_code@2@V32@@Z@4HA"
		size = 24
		refs = "000e ??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_62_995_2 {
	meta:
		name = "?dtor$2@?0??_CancelInternal@?$task_completion_event@E@Concurrency@@AEBA_NXZ@4HA"
		size = 24
		refs = "000e ??1?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_62_1000_2 {
	meta:
		name = "?dtor$2@?0??_CancelInternal@?$task_completion_event@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@Concurrency@@AEBA_NXZ@4HA"
		size = 24
		refs = "000e ??1?$_Vector_iterator@V?$_Vector_val@U?$_Simple_types@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_6_49_0 {
	meta:
		name = "?_Initialize@SchedulerPolicy@Concurrency@@AEAAX_KPEAPEAD@Z"
		size = 710
		refs = "0043 ??_C@_0DI@PPADFCII@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0052 ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 0082 ?PolicyDefaults@details@Concurrency@@3PAIA 008a memcpy 0194 ?_ValidPolicyKey@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@@Z 01aa ?_StringFromPolicyKey@SchedulerPolicy@Concurrency@@CAPEADI@Z 01c1 ??0invalid_scheduler_policy_key@Concurrency@@QEAA@PEBD@Z 01c8 _TI2?AVinvalid_scheduler_policy_key@Concurrency@@ 01d5 _CxxThrowException 01e2 ?_ValidPolicyValue@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@I@Z 020c ??0invalid_scheduler_policy_value@Concurrency@@QEAA@PEBD@Z 0213 _TI2?AVinvalid_scheduler_policy_value@Concurrency@@ 0240 ?_AreConcurrencyLimitsValid@SchedulerPolicy@Concurrency@@AEBA_NXZ 025a ??0invalid_scheduler_policy_thread_specification@Concurrency@@QEAA@XZ 0261 _TI2?AVinvalid_scheduler_policy_thread_specification@Concurrency@@ 027b ?_ArePolicyCombinationsValid@SchedulerPolicy@Concurrency@@AEBA_NXZ 0295 ??0invalid_scheduler_policy_value@Concurrency@@QEAA@XZ 02b6 ?_ResolvePolicyValues@SchedulerPolicy@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 57 48 81 EC E0 00 00 00 48 C7 44 24 70 FE FF FF FF 48 C7 44 24 60 28 00 00 00 48 8D 44 24 24 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 41 B9 50 00 00 00 4C 8D 05 ?? ?? ?? ?? 0F B6 54 24 24 B9 28 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 68 48 8B 44 24 68 48 89 44 24 38 48 8B 84 24 F0 00 00 00 48 8B 4C 24 38 48 89 08 48 8B 44 24 38 4C 8B 44 24 60 48 8D 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 C7 44 24 40 00 00 00 00 EB 0D 48 8B 44 24 40 48 FF C0 48 89 44 24 40 48 8B 84 24 F8 00 00 00 48 39 44 24 40 0F 83 7E 01 00 00 33 C0 85 C0 74 31 48 8B 84 24 00 01 00 00 48 8B 00 48 83 C0 08 48 8B 8C 24 00 01 00 00 48 89 01 48 8B 84 24 00 01 00 00 48 8B 00 48 8B 40 F8 8B 00 89 44 24 34 EB 2C 48 8B 84 24 00 01 00 00 48 8B 00 48 83 C0 08 48 8B 8C 24 00 01 00 00 48 89 01 48 8B 84 24 00 01 00 00 48 8B 00 8B 40 F8 89 44 24 34 8B 44 24 34 89 44 24 28 33 C0 85 C0 74 31 48 8B 84 24 00 01 00 00 48 8B 00 48 83 C0 08 48 8B 8C 24 00 01 00 00 48 89 01 48 8B 84 24 00 01 00 00 48 8B 00 48 8B 40 F8 8B 00 89 44 24 2C EB 2C 48 8B 84 24 00 01 00 00 48 8B 00 48 83 C0 08 48 8B 8C 24 00 01 00 00 48 89 01 48 8B 84 24 00 01 00 00 48 8B 00 8B 40 F8 89 44 24 2C 8B 44 24 2C 89 44 24 30 8B 4C 24 28 E8 ?? ?? ?? ?? 88 44 24 23 0F B6 44 24 23 85 C0 75 34 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 50 48 8B 54 24 50 48 8D 8C 24 A8 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 A8 00 00 00 E8 ?? ?? ?? ?? 8B 54 24 30 8B 4C 24 28 E8 ?? ?? ?? ?? 88 44 24 21 0F B6 44 24 21 85 C0 75 2E 8B 4C 24 28 E8 ?? ?? ?? ?? 48 89 44 24 58 48 8B 54 24 58 48 8D 4C 24 78 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 78 E8 ?? ?? ?? ?? 48 63 44 24 28 48 8B 4C 24 38 8B 54 24 30 89 14 81 E9 62 FE FF FF 48 8B 8C 24 F0 00 00 00 E8 ?? ?? ?? ?? 88 44 24 22 0F B6 44 24 22 85 C0 75 21 48 8D 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 F0 00 00 00 E8 ?? ?? ?? ?? 88 44 24 20 0F B6 44 24 20 85 C0 75 21 48 8D 8C 24 C0 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 C0 00 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 F0 00 00 00 E8 ?? ?? ?? ?? 90 EB 00 48 81 C4 E0 00 00 00 5F C3 }
	condition:
		$1
}

rule file_6_51_0 {
	meta:
		name = "__catch$?_Initialize@SchedulerPolicy@Concurrency@@AEAAX_KPEAPEAD@Z$0"
		size = 41
		refs = "000d ??3@YAXPEAX@Z 0016 _CxxThrowException 001e $LN18"
	strings:
		$1 = { 48 8B 45 38 48 89 45 48 48 8B 4D 48 E8 ?? ?? ?? ?? 33 D2 33 C9 E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_6_52_0 {
	meta:
		name = "?_Invoke@_CancellationTokenRegistration@details@Concurrency@@AEAAXXZ"
		size = 205
		refs = "000a ?GetCurrentThreadId@platform@details@Concurrency@@YAJXZ 0020 ??_C@_1CC@DDKOAOPH@?$AA?$CI?$AAt?$AAi?$AAd?$AA?5?$AA?$CG?$AA?5?$AA0?$AAx?$AA3?$AA?$CJ?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 002c ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0041 ??_C@_1GG@BBNGEAJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAp?$AAp?$AAl?$AAc?$AAa@ 004b _CrtDbgReportW 006b ?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z 00ba ?set@event@Concurrency@@QEAAXXZ 00c4 ?_Release@_RefCounter@details@Concurrency@@QEAAJXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 E8 ?? ?? ?? ?? 89 44 24 30 8B 44 24 30 83 E0 03 85 C0 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 8F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 50 48 83 C0 10 45 33 C0 8B 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 34 83 7C 24 34 00 75 44 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 FF 50 10 48 8B 44 24 50 48 83 C0 10 44 8B 44 24 30 BA 03 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 34 83 7C 24 34 02 75 0E 48 8B 44 24 50 48 8B 48 18 E8 ?? ?? ?? ?? 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_6_53_0 {
	meta:
		name = "?_Reference@_RefCounter@details@Concurrency@@QEAAJXZ"
		size = 109
		refs = "002d ??_C@_1BM@LPMPGBJF@?$AA_?$AAR?$AAe?$AAf?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA1?$AA?$AA@ 0039 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 004e ??_C@_1GG@BBNGEAJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAp?$AAp?$AAl?$AAc?$AAa@ 0058 _CrtDbgReportW"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 83 C0 08 B9 01 00 00 00 F0 0F C1 08 FF C1 8B C1 89 44 24 30 83 7C 24 30 01 7F 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 41 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_6_54_0 {
	meta:
		name = "?_Release@_RefCounter@details@Concurrency@@QEAAJXZ"
		size = 132
		refs = "002d ??_C@_1BO@OJJMJNDL@?$AA_?$AAR?$AAe?$AAf?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0039 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 004e ??_C@_1GG@BBNGEAJH@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAp?$AAp?$AAl?$AAc?$AAa@ 0058 _CrtDbgReportW"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 83 C0 08 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 89 44 24 30 83 7C 24 30 00 7D 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 4A 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 30 00 75 10 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 FF 50 08 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_6_55_0 {
	meta:
		name = "?_ResolvePolicyValues@SchedulerPolicy@Concurrency@@AEAAXXZ"
		size = 572
		refs = "0022 ?GetProcessorCount@Concurrency@@YAIXZ 003e ??_C@_1FK@IPKDCJGJ@?$AA?$CI?$AAc?$AAo?$AAr?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAc?$AAo?$AAr?$AAe?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN@ 004a ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 005f ??_C@_1HA@CDMOKMEB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0069 _CrtDbgReportW 01ec ??_C@_1BGA@LBCCHDAG@?$AA_?$AAM?$AA_?$AAp?$AAP?$AAo?$AAl?$AAi?$AAc?$AAy?$AAB?$AAa?$AAg?$AA?9?$AA?$DO?$AA_?$AAM?$AA_?$AAv?$AAa?$AAl?$AAu?$AAe?$AAs?$AA?4?$AA_?$AAM?$AA_?$AAp?$AAP?$AAo?$AAl@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 00 C7 04 08 00 00 00 00 E8 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 00 76 0A 81 7C 24 30 FF FF FF 7F 76 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 06 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 AF 33 C0 85 C0 75 A9 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 02 83 3C 08 FF 0F 85 9F 00 00 00 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 01 83 3C 08 FF 75 32 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 01 8B 54 24 30 89 14 08 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 02 8B 54 24 30 89 14 08 EB 54 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 01 8B 54 24 30 39 14 08 73 1A 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 01 8B 04 08 89 44 24 34 EB 08 8B 44 24 30 89 44 24 34 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 02 8B 54 24 34 89 14 08 EB 6B 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 01 83 3C 08 FF 75 54 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 02 8B 54 24 30 39 14 08 76 1A 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 02 8B 04 08 89 44 24 38 EB 08 8B 44 24 30 89 44 24 38 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 01 8B 54 24 38 89 14 08 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 02 83 3C 08 00 72 2C 48 8B 44 24 50 48 8B 00 B9 04 00 00 00 48 6B C9 01 48 8B 54 24 50 48 8B 12 41 B8 04 00 00 00 4D 6B C0 02 42 8B 14 02 39 14 08 73 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 1D 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 0F 85 79 FF FF FF 33 C0 85 C0 0F 85 6F FF FF FF 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_6_56_0 {
	meta:
		name = "?_StringFromPolicyKey@SchedulerPolicy@Concurrency@@CAPEADI@Z"
		size = 35
		refs = "001a ?PolicyElementKeyStrings@details@Concurrency@@3PAPEADA"
	strings:
		$1 = { 89 4C 24 08 83 7C 24 08 0A 76 08 C7 44 24 08 0A 00 00 00 8B 44 24 08 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 C3 }
	condition:
		$1
}

rule file_6_57_0 {
	meta:
		name = "?_ValidPolicyKey@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@@Z"
		size = 47
	strings:
		$1 = { 89 4C 24 08 48 83 EC 18 83 7C 24 20 00 7C 10 83 7C 24 20 0A 7D 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 0F B6 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_6_58_0 {
	meta:
		name = "?_ValidPolicyValue@SchedulerPolicy@Concurrency@@CA_NW4PolicyElementKey@2@I@Z"
		size = 436
		refs = "002c __ImageBase 0033 $LN35 013c ??_C@_1M@HLGKFCJM@?$AAf?$AAa?$AAl?$AAs?$AAe?$AA?$AA@ 0148 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 015d ??_C@_1HA@CDMOKMEB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0167 _CrtDbgReportW 018c $LN29 0190 $LN22 0194 $LN19 0198 $LN14 019c $LN16 01a4 $LN27 01a8 $LN24 01ac $LN11 01b0 $LN9"
	strings:
		$1 = { 89 54 24 10 89 4C 24 08 48 83 EC 48 C6 44 24 30 01 8B 44 24 50 89 44 24 38 83 7C 24 38 09 0F 87 13 01 00 00 48 63 44 24 38 48 8D 0D ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 83 7C 24 58 00 74 05 C6 44 24 30 00 E9 32 01 00 00 8B 44 24 58 89 44 24 34 83 7C 24 34 F9 7C 07 83 7C 24 34 07 7C 1D 83 7C 24 34 0F 74 16 83 7C 24 34 F1 74 0F 81 7C 24 34 00 F0 00 00 74 05 C6 44 24 30 00 E9 FA 00 00 00 83 7C 24 58 00 74 0C 83 7C 24 58 01 74 05 C6 44 24 30 00 E9 E2 00 00 00 83 7C 24 58 00 76 0A 81 7C 24 58 FF FF FF 7F 76 0C 83 7C 24 58 FF 74 05 C6 44 24 30 00 E9 C0 00 00 00 83 7C 24 58 00 72 0A 81 7C 24 58 FF FF FF 7F 76 0C 83 7C 24 58 FF 74 05 C6 44 24 30 00 E9 9E 00 00 00 81 7C 24 58 FF FF FF 7F 76 05 C6 44 24 30 00 E9 8A 00 00 00 83 7C 24 58 00 76 0A 81 7C 24 58 FF FF FF 7F 76 05 C6 44 24 30 00 EB 72 83 7C 24 58 01 74 0C 83 7C 24 58 00 74 05 C6 44 24 30 00 EB 5D 83 7C 24 58 00 74 0C 83 7C 24 58 01 74 05 C6 44 24 30 00 EB 48 33 C0 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 7C 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? CC 33 C0 33 C0 85 C0 75 C3 33 C0 85 C0 75 BD C6 44 24 30 00 0F B6 44 24 30 48 83 C4 48 C3 0F 1F 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_6_59_0 {
	meta:
		name = "?_ValidateConcRTPolicy@SchedulerPolicy@Concurrency@@QEBAXXZ"
		size = 146
		refs = "0014 ?GetPolicyValue@SchedulerPolicy@Concurrency@@QEBAIW4PolicyElementKey@2@@Z 0029 ?_StringFromPolicyKey@SchedulerPolicy@Concurrency@@CAPEADI@Z 0036 ??0invalid_scheduler_policy_value@Concurrency@@QEAA@PEBD@Z 003d _TI2?AVinvalid_scheduler_policy_value@Concurrency@@ 0047 _CxxThrowException"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 68 BA 02 00 00 00 48 8B 4C 24 70 E8 ?? ?? ?? ?? 89 44 24 20 83 7C 24 20 00 75 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? BA 08 00 00 00 48 8B 4C 24 70 E8 ?? ?? ?? ?? 89 44 24 24 83 7C 24 24 00 75 28 B9 08 00 00 00 E8 ?? ?? ?? ?? 48 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_6_60_0 {
	meta:
		name = "?atomic_compare_exchange@details@Concurrency@@YAJAECJJJ@Z"
		size = 46
	strings:
		$1 = { 44 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 18 8B 44 24 28 89 04 24 48 8B 4C 24 20 8B 44 24 30 8B 14 24 F0 0F B1 11 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_6_61_0 {
	meta:
		name = "?cancel@cancellation_token_source@Concurrency@@QEBAXXZ"
		size = 27
		refs = "0012 ?_Cancel@_CancellationTokenState@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_688_37_0 {
	meta:
		name = "??1ScopedCriticalRegion@ContextBase@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?ExitCriticalRegion@ContextBase@details@Concurrency@@QEAAHXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_816_19_0 {
	meta:
		name = "??1_Scoped_lock@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?ReleaseWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEBAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_967_27_0 {
	meta:
		name = "??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_Release@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_372_75_0 {
	meta:
		name = "??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_Release@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_241_46_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_Release@_NonReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_241_47_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_Release@_NonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_133_40_0 {
	meta:
		name = "??1_Scoped_lock@_NonReentrantPPLLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_Release@_NonReentrantPPLLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_678_25_0 {
	meta:
		name = "??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_ReleaseWrite@_ReaderWriterLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_989_26_0 {
	meta:
		name = "??1_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_Release@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_133_41_0 {
	meta:
		name = "??1_Scoped_lock@_ReentrantPPLLock@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?_Release@_ReentrantPPLLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_630_50_0 {
	meta:
		name = "??1_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?ReleaseRead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEBAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_110_132_1 {
	meta:
		name = "??1_Timevec@std@@QEAA@XZ"
		size = 27
		refs = "0012 free"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_133_46_0 {
	meta:
		name = "??1scoped_lock@critical_section@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?unlock@critical_section@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_133_47_0 {
	meta:
		name = "??1scoped_lock@reader_writer_lock@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?unlock@reader_writer_lock@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_133_48_0 {
	meta:
		name = "??1scoped_lock_read@reader_writer_lock@Concurrency@@QEAA@XZ"
		size = 27
		refs = "0012 ?unlock@reader_writer_lock@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_363_0 {
	meta:
		name = "?Next@?$LockFreePushStack@VContextNode@SchedulerBase@details@Concurrency@@@details@Concurrency@@SAPEAVContextNode@SchedulerBase@23@PEAV4523@@Z"
		size = 27
		refs = "0012 ?Delta@?$LockFreePushStack@VContextNode@SchedulerBase@details@Concurrency@@@details@Concurrency@@CAPEAVContextNode@SchedulerBase@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_469_0 {
	meta:
		name = "?Unsafe_Top@?$LockFreePushStack@VContextNode@SchedulerBase@details@Concurrency@@@details@Concurrency@@QEAAPEAVContextNode@SchedulerBase@23@XZ"
		size = 27
		refs = "0012 ?Delta@?$LockFreePushStack@VContextNode@SchedulerBase@details@Concurrency@@@details@Concurrency@@CAPEAVContextNode@SchedulerBase@23@PEAX@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_6_62_0 {
	meta:
		name = "?swap@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@QEAAXAEAV1234@@Z"
		size = 63
		refs = "001c ??$swap@PEAU_Node@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@@std@@YAXAEAPEAU_Node@TokenRegistrationContainer@_CancellationTokenState@details@Concurrency@@0@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 8B D0 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C0 08 48 8B 4C 24 38 48 83 C1 08 48 8B D0 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "casin"
		size = 317
		refs = "0030 creal 0057 cimag 005e __xmm@80000000000000008000000000000000 0077 _Cbuild 009b casinh"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC B8 00 00 00 48 8D 44 24 70 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 70 E8 ?? ?? ?? ?? F2 0F 11 44 24 20 48 8D 44 24 50 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 50 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 10 4C 24 20 0F 28 D1 0F 28 C8 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 54 24 30 48 8D 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D8 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 44 24 60 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 60 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 28 48 8D 44 24 40 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 40 E8 ?? ?? ?? ?? F2 0F 10 4C 24 28 0F 28 D1 0F 28 C8 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D0 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 D0 00 00 00 48 81 C4 B8 00 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_1005_0_0 {
	meta:
		name = "casinl"
		size = 317
		refs = "0030 creall 0057 cimagl 005e __xmm@80000000000000008000000000000000 0077 _LCbuild 009b casinhl"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC B8 00 00 00 48 8D 44 24 70 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 70 E8 ?? ?? ?? ?? F2 0F 11 44 24 20 48 8D 44 24 50 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 50 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 10 4C 24 20 0F 28 D1 0F 28 C8 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 54 24 30 48 8D 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D8 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 44 24 60 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 60 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 28 48 8D 44 24 40 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 40 E8 ?? ?? ?? ?? F2 0F 10 4C 24 28 0F 28 D1 0F 28 C8 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D0 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 D0 00 00 00 48 81 C4 B8 00 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_472_0_0 {
	meta:
		name = "catan"
		size = 317
		refs = "0030 creal 0057 cimag 005e __xmm@80000000000000008000000000000000 0077 _Cbuild 009b catanh"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC B8 00 00 00 48 8D 44 24 70 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 70 E8 ?? ?? ?? ?? F2 0F 11 44 24 20 48 8D 44 24 50 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 50 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 10 4C 24 20 0F 28 D1 0F 28 C8 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 54 24 30 48 8D 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D8 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 44 24 60 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 60 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 28 48 8D 44 24 40 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 40 E8 ?? ?? ?? ?? F2 0F 10 4C 24 28 0F 28 D1 0F 28 C8 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D0 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 D0 00 00 00 48 81 C4 B8 00 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_367_0_0 {
	meta:
		name = "catanl"
		size = 317
		refs = "0030 creall 0057 cimagl 005e __xmm@80000000000000008000000000000000 0077 _LCbuild 009b catanhl"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC B8 00 00 00 48 8D 44 24 70 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 70 E8 ?? ?? ?? ?? F2 0F 11 44 24 20 48 8D 44 24 50 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 50 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 10 4C 24 20 0F 28 D1 0F 28 C8 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 54 24 30 48 8D 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D8 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 44 24 60 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 60 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 28 48 8D 44 24 40 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 40 E8 ?? ?? ?? ?? F2 0F 10 4C 24 28 0F 28 D1 0F 28 C8 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D0 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 D0 00 00 00 48 81 C4 B8 00 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_1221_0_0 {
	meta:
		name = "csin"
		size = 317
		refs = "0030 creal 0057 cimag 005e __xmm@80000000000000008000000000000000 0077 _Cbuild 009b csinh"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC B8 00 00 00 48 8D 44 24 70 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 70 E8 ?? ?? ?? ?? F2 0F 11 44 24 20 48 8D 44 24 50 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 50 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 10 4C 24 20 0F 28 D1 0F 28 C8 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 54 24 30 48 8D 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D8 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 44 24 60 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 60 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 28 48 8D 44 24 40 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 40 E8 ?? ?? ?? ?? F2 0F 10 4C 24 28 0F 28 D1 0F 28 C8 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D0 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 D0 00 00 00 48 81 C4 B8 00 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_1038_0_0 {
	meta:
		name = "csinl"
		size = 317
		refs = "0030 creall 0057 cimagl 005e __xmm@80000000000000008000000000000000 0077 _LCbuild 009b csinhl"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC B8 00 00 00 48 8D 44 24 70 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 70 E8 ?? ?? ?? ?? F2 0F 11 44 24 20 48 8D 44 24 50 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 50 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 10 4C 24 20 0F 28 D1 0F 28 C8 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 54 24 30 48 8D 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D8 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 44 24 60 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 60 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 28 48 8D 44 24 40 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 40 E8 ?? ?? ?? ?? F2 0F 10 4C 24 28 0F 28 D1 0F 28 C8 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D0 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 D0 00 00 00 48 81 C4 B8 00 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_427_0_0 {
	meta:
		name = "ctan"
		size = 317
		refs = "0030 creal 0057 cimag 005e __xmm@80000000000000008000000000000000 0077 _Cbuild 009b ctanh"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC B8 00 00 00 48 8D 44 24 70 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 70 E8 ?? ?? ?? ?? F2 0F 11 44 24 20 48 8D 44 24 50 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 50 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 10 4C 24 20 0F 28 D1 0F 28 C8 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 54 24 30 48 8D 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D8 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 44 24 60 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 60 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 28 48 8D 44 24 40 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 40 E8 ?? ?? ?? ?? F2 0F 10 4C 24 28 0F 28 D1 0F 28 C8 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D0 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 D0 00 00 00 48 81 C4 B8 00 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "ctanl"
		size = 317
		refs = "0030 creall 0057 cimagl 005e __xmm@80000000000000008000000000000000 0077 _LCbuild 009b ctanhl"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC B8 00 00 00 48 8D 44 24 70 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 70 E8 ?? ?? ?? ?? F2 0F 11 44 24 20 48 8D 44 24 50 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 50 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 10 4C 24 20 0F 28 D1 0F 28 C8 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8D 4C 24 30 48 8B F9 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 54 24 30 48 8D 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D8 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8D 44 24 60 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 60 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 28 48 8D 44 24 40 48 8B F8 48 8B B4 24 D8 00 00 00 B9 10 00 00 00 F3 A4 48 8D 4C 24 40 E8 ?? ?? ?? ?? F2 0F 10 4C 24 28 0F 28 D1 0F 28 C8 48 8D 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 D0 00 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 D0 00 00 00 48 81 C4 B8 00 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "fgetpos"
		size = 392
		refs = "003a ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0046 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 005b ??_C@_1FC@FANBFHPM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAi?$AAo?$AA?2?$AAf@ 0065 _CrtDbgReportW 0079 _errno 009c ??_C@_1BA@PDKPGILH@?$AAf?$AAg?$AAe?$AAt?$AAp?$AAo?$AAs?$AA?$AA@ 00a8 _invalid_parameter 00e2 ??_C@_1BM@IMKAODOM@?$AA?$CI?$AAp?$AAo?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0161 _ftelli64"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 50 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 2D 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 2D 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 CD 00 00 00 48 83 7C 24 58 00 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 2E 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 2E 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF EB 28 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 4C 24 58 48 89 01 48 8B 44 24 58 48 83 38 FF 74 06 33 C0 EB 07 EB 05 B8 FF FF FF FF 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z"
		size = 311
		refs = "0026 _getptd 006c __ptlocinfo 0080 __globallocalestatus 0091 __updatetlocinfo 00a5 __ptmbcinfo 00cb __updatetmbcinfo"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 28 48 8B 44 24 40 C6 40 18 00 48 83 7C 24 48 00 0F 85 F5 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 89 41 10 48 8B 44 24 40 48 8B 40 10 48 8B 4C 24 40 48 8B 80 C0 00 00 00 48 89 01 48 8B 44 24 40 48 8B 40 10 48 8B 4C 24 40 48 8B 80 B8 00 00 00 48 89 41 08 48 8B 44 24 40 48 8B 0D ?? ?? ?? ?? 48 39 08 74 28 48 8B 44 24 40 48 8B 40 10 8B 0D ?? ?? ?? ?? 8B 80 C8 00 00 00 23 C1 85 C0 75 0D E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 89 01 48 8B 44 24 40 48 8B 0D ?? ?? ?? ?? 48 39 48 08 74 29 48 8B 44 24 40 48 8B 40 10 8B 0D ?? ?? ?? ?? 8B 80 C8 00 00 00 23 C1 85 C0 75 0E E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 89 41 08 48 8B 44 24 40 48 8B 40 10 8B 80 C8 00 00 00 83 E0 02 85 C0 75 2A 48 8B 44 24 40 48 8B 40 10 8B 80 C8 00 00 00 83 C8 02 48 8B 4C 24 40 48 8B 49 10 89 81 C8 00 00 00 48 8B 44 24 40 C6 40 18 01 EB 11 48 8B 7C 24 40 48 8B 74 24 48 B9 10 00 00 00 F3 A4 48 8B 44 24 40 48 83 C4 28 5F 5E C3 }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "??1_LocaleUpdate@@QEAA@XZ"
		size = 52
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 0F B6 40 18 85 C0 74 21 48 8B 44 24 08 48 8B 40 10 8B 80 C8 00 00 00 83 E0 FD 48 8B 4C 24 08 48 8B 49 10 89 81 C8 00 00 00 C3 }
	condition:
		$1
}

rule file_9_3_0 {
	meta:
		name = "_mbsicoll"
		size = 37
		refs = "001c _mbsicoll_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_869_94_0 {
	meta:
		name = "?Delete@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAA_NAEBQEAV_TaskCollection@23@@Z"
		size = 37
		refs = "001c ?FindAndDelete@?$Hash@PEAV_TaskCollection@details@Concurrency@@PEAV123@@details@Concurrency@@QEAA_NAEBQEAV_TaskCollection@23@PEAPEAV423@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_98_547_3 {
	meta:
		name = "?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_K@Z"
		size = 37
		refs = "001c ?resize@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAX_KD@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_1333_3 {
	meta:
		name = "?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_K@Z"
		size = 37
		refs = "001c ?resize@?$basic_string@GU?$char_traits@G@std@@V?$allocator@G@2@@std@@QEAAX_KG@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_1297_2 {
	meta:
		name = "?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_K@Z"
		size = 37
		refs = "001c ?resize@?$basic_string@_WU?$char_traits@_W@std@@V?$allocator@_W@2@@std@@QEAAX_K_W@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_39_9_1 {
	meta:
		name = "_Cnd_wait"
		size = 37
		refs = "001c ?do_wait@@YAHPEAPEAU_Cnd_internal_imp_t@@PEAPEAU_Mtx_internal_imp_t@@PEBUxtime@@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_458_1_0 {
	meta:
		name = "_aligned_malloc_base"
		size = 37
		refs = "001c _aligned_offset_malloc_base"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_283_4_0 {
	meta:
		name = "_atodbl"
		size = 37
		refs = "001c _atodbl_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_283_6_0 {
	meta:
		name = "_atoflt"
		size = 37
		refs = "001c _atoflt_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_283_8_0 {
	meta:
		name = "_atoldbl"
		size = 37
		refs = "001c _atoldbl_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_491_0_0 {
	meta:
		name = "_execvp"
		size = 37
		refs = "001c _execvpe"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1091_3_0 {
	meta:
		name = "_getws_s"
		size = 37
		refs = "001c _getws_helper"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1027_3_0 {
	meta:
		name = "_ismbslead"
		size = 37
		refs = "001c _ismbslead_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_980_3_0 {
	meta:
		name = "_ismbstrail"
		size = 37
		refs = "001c _ismbstrail_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_602_3_0 {
	meta:
		name = "_mbsbtype"
		size = 37
		refs = "001c _mbsbtype_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_861_3_0 {
	meta:
		name = "_mbscmp"
		size = 37
		refs = "001c _mbscmp_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1320_3_0 {
	meta:
		name = "_mbscoll"
		size = 37
		refs = "001c _mbscoll_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_975_3_0 {
	meta:
		name = "_mbscspn"
		size = 37
		refs = "001c _mbscspn_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_647_3_0 {
	meta:
		name = "_mbsdec"
		size = 37
		refs = "001c _mbsdec_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_99_3_0 {
	meta:
		name = "_mbsicmp"
		size = 37
		refs = "001c _mbsicmp_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_479_5_0 {
	meta:
		name = "_mbslwr_s"
		size = 37
		refs = "001c _mbslwr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1314_3_0 {
	meta:
		name = "_mbsnbcnt"
		size = 37
		refs = "001c _mbsnbcnt_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1074_3_0 {
	meta:
		name = "_mbsnccnt"
		size = 37
		refs = "001c _mbsnccnt_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_531_0_0 {
	meta:
		name = "_mbsninc"
		size = 37
		refs = "001c _mbsninc_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_815_3_0 {
	meta:
		name = "_mbsnlen"
		size = 37
		refs = "001c _mbsnlen_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_312_3_0 {
	meta:
		name = "_mbspbrk"
		size = 37
		refs = "001c _mbspbrk_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1231_3_0 {
	meta:
		name = "_mbsspn"
		size = 37
		refs = "001c _mbsspn_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1090_3_0 {
	meta:
		name = "_mbsspnp"
		size = 37
		refs = "001c _mbsspnp_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1093_3_0 {
	meta:
		name = "_mbsstr"
		size = 37
		refs = "001c _mbsstr_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_186_0_0 {
	meta:
		name = "_mbstok"
		size = 37
		refs = "001c _mbstok_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_848_3_0 {
	meta:
		name = "_mbstrnlen"
		size = 37
		refs = "001c _mbstrnlen_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1031_5_0 {
	meta:
		name = "_mbsupr_s"
		size = 37
		refs = "001c _mbsupr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1058_9_0 {
	meta:
		name = "_strlwr_s"
		size = 37
		refs = "001c _strlwr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_498_9_0 {
	meta:
		name = "_strupr_s"
		size = 37
		refs = "001c _strupr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1184_9_0 {
	meta:
		name = "_wcslwr_s"
		size = 37
		refs = "001c _wcslwr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_29_9_0 {
	meta:
		name = "_wcsupr_s"
		size = 37
		refs = "001c _wcsupr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1036_0_0 {
	meta:
		name = "_wexecvp"
		size = 37
		refs = "001c _wexecvpe"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_366_3_0 {
	meta:
		name = "gets_s"
		size = 37
		refs = "001c _gets_helper"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_908_4_0 {
	meta:
		name = "strcoll"
		size = 37
		refs = "001c _strcoll_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_249_4_0 {
	meta:
		name = "strtod"
		size = 37
		refs = "001c _strtod_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_715_4_0 {
	meta:
		name = "wcstod"
		size = 37
		refs = "001c _wcstod_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_703_14_0 {
	meta:
		name = "wcstof"
		size = 37
		refs = "001c _wcstof_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C0 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_9_4_0 {
	meta:
		name = "_mbsicoll_l"
		size = 702
		refs = "0024 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0057 ??_C@_1BG@MODEICJK@?$AAs?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0063 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0078 ??_C@_1FK@NAKOIJGB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAb?$AAs?$AAt?$AAr?$AAi?$AAn@ 0082 _CrtDbgReportW 0096 _errno 00b9 ??_C@_1BI@BOFEGNKA@?$AA_?$AAm?$AAb?$AAs?$AAi?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 00c5 _invalid_parameter 00d7 ??1_LocaleUpdate@@QEAA@XZ 0113 ??_C@_1BG@GBJNMPFA@?$AAs?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01a6 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 01cd _stricoll_l 026b __crtCompareStringA"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC A8 00 00 00 48 8B 94 24 C0 00 00 00 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 83 BC 24 B0 00 00 00 00 74 0A C7 44 24 44 01 00 00 00 EB 08 C7 44 24 44 00 00 00 00 8B 44 24 44 89 44 24 4C 83 7C 24 4C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 36 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 4C 00 75 4F E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 36 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 5C FF FF FF 7F 48 8D 4C 24 68 E8 ?? ?? ?? ?? 8B 44 24 5C E9 D2 01 00 00 48 83 BC 24 B8 00 00 00 00 74 0A C7 44 24 40 01 00 00 00 EB 08 C7 44 24 40 00 00 00 00 8B 44 24 40 89 44 24 48 83 7C 24 48 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 37 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 48 00 75 4F E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 37 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 54 FF FF FF 7F 48 8D 4C 24 68 E8 ?? ?? ?? ?? 8B 44 24 54 E9 16 01 00 00 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B 40 08 83 78 08 00 75 34 4C 8B 84 24 C0 00 00 00 48 8B 94 24 B8 00 00 00 48 8B 8C 24 B0 00 00 00 E8 ?? ?? ?? ?? 89 44 24 60 48 8D 4C 24 68 E8 ?? ?? ?? ?? 8B 44 24 60 E9 CE 00 00 00 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B 40 08 48 89 84 24 88 00 00 00 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B 40 08 48 89 84 24 90 00 00 00 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B 8C 24 88 00 00 00 8B 49 04 89 4C 24 38 C7 44 24 30 FF FF FF FF 48 8B 8C 24 B8 00 00 00 48 89 4C 24 28 C7 44 24 20 FF FF FF FF 4C 8B 8C 24 B0 00 00 00 41 B8 01 10 00 00 48 8B 8C 24 90 00 00 00 48 8B 91 20 02 00 00 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 50 83 7C 24 50 00 75 23 E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 44 24 64 FF FF FF 7F 48 8D 4C 24 68 E8 ?? ?? ?? ?? 8B 44 24 64 EB 19 8B 44 24 50 83 E8 02 89 44 24 58 48 8D 4C 24 68 E8 ?? ?? ?? ?? 8B 44 24 58 48 81 C4 A8 00 00 00 C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "__static_scalar_tan"
		size = 1408
		refs = "000c __spec_table"
	strings:
		$1 = { 53 56 57 41 54 48 83 EC 58 48 8D 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 48 89 44 24 40 0F 29 74 24 30 0F 29 7C 24 20 F2 0F 10 84 24 80 00 00 00 4C 8B 64 24 40 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 0F 84 0E 05 00 00 8B C8 81 E9 60 3F 00 00 C1 E9 07 81 E1 FC FF 00 00 4D 8D 9C 24 40 01 00 00 49 03 CB 66 48 0F 7E C0 44 8B 51 14 44 8B 41 18 8B D0 48 C1 E8 15 0D 00 00 00 80 C1 E8 0B 45 8B CA 4C 0F AF D2 4C 0F AF C8 4C 0F AF C0 8B 71 10 8B 79 0C 45 8B DA 49 C1 EA 20 4D 03 CA 4D 03 D8 45 8B C3 49 C1 EB 20 4D 03 CB 44 8B D6 48 0F AF F2 4C 0F AF D0 44 8B DF 48 0F AF FA 8B DE 48 C1 EE 20 4C 03 CB 41 8B D9 49 C1 E9 20 4C 03 D6 4D 03 D1 48 C1 E3 20 4C 0B C3 4C 0F AF D8 44 8B 49 08 8B 71 04 8B DF 48 C1 EF 20 4C 03 D3 41 8B DA 49 C1 EA 20 4C 03 DF 4D 03 DA 49 8B F9 4C 0F AF CA 48 0F AF F8 45 8B D1 49 C1 E9 20 4D 03 DA 45 8B D3 49 C1 EB 20 49 03 F9 49 03 FB 4C 8B CE 48 0F AF F2 4C 0F AF C8 49 C1 E2 20 4C 0B D3 8B 01 44 8B DE 48 C1 EE 20 49 03 FB 44 8B DF 48 C1 EF 20 4C 03 CE 4C 03 CF 48 0F AF D0 66 0F C5 D8 03 49 8D BC 24 40 01 00 00 48 2B CF 03 C9 03 C9 03 C9 83 C1 13 BE 00 80 00 00 23 F3 C1 EB 04 81 E3 FF 07 00 00 81 EB FF 03 00 00 2B CB 4C 03 CA 8B D1 83 C2 20 83 F9 00 0F 8C 16 03 00 00 F7 D9 83 C1 1D 41 D3 E1 41 8B F9 41 81 E1 FF FF FF 3F 41 F7 C1 00 00 00 20 0F 85 20 03 00 00 41 D3 E9 BB 00 00 00 00 49 C1 E1 20 4D 0B CB 49 83 F9 00 0F 84 89 02 00 00 4D 0F BD D9 B9 1D 00 00 00 41 2B CB 0F 8E A9 02 00 00 49 D3 E1 49 8B C2 49 D3 E2 03 D1 F7 D9 83 C1 40 48 D3 E8 49 D3 E8 4C 0B C8 4D 0B D0 F2 49 0F 2A C1 49 D1 EA F2 49 0F 2A DA 66 0F 57 E4 C1 E2 04 F7 DA 81 C2 F0 3F 00 00 0B D6 33 D3 66 0F C4 E2 03 F3 41 0F 7E 54 24 60 F3 41 0F 7E 7C 24 68 66 0F 57 ED 81 EA F0 03 00 00 66 0F C4 EA 03 F2 0F 59 C4 C1 E6 10 C1 FE 1F F2 0F 59 DD F3 0F 7E C8 F2 0F 59 C2 C1 EF 1E F2 0F 58 CB F2 0F 59 DA 03 FE 33 FE F2 0F 59 F9 8B C7 F2 0F 58 FB F3 0F 7E D0 F2 0F 58 C7 F2 0F 5C D0 F2 0F 58 FA 66 41 0F 28 0C 24 F2 0F 12 C0 66 0F 59 C8 F2 0F 12 FF F2 0F 2D D1 66 41 0F 28 54 24 10 66 0F 58 CA 66 41 0F 28 5C 24 20 66 0F 5C CA F3 41 0F 7E AC 24 80 00 00 00 C1 E0 04 81 C2 00 29 07 00 66 41 0F 28 64 24 30 66 0F 59 D9 03 D0 83 E2 1F F2 0F 59 E9 8B CA 66 0F 59 E1 D1 E1 66 0F 5C C3 66 41 0F 59 4C 24 40 03 D1 C1 E1 02 03 D1 F2 0F 58 E8 66 0F 28 D0 66 0F 5C C4 F3 41 0F 7E B4 24 90 00 00 00 C1 E2 04 49 8D 84 24 F0 01 00 00 66 41 0F 54 6C 24 50 66 0F 28 D8 48 03 C2 66 0F 5C D0 66 0F 15 C0 F2 0F 5E F5 66 0F 5C D4 F2 0F 5C DD 66 0F 5C D1 66 0F 28 48 30 66 0F 58 D7 66 0F 28 78 10 66 0F 59 F8 66 0F 28 60 60 66 0F 59 C8 66 0F 59 E0 F2 0F 58 D3 66 0F 28 D8 66 0F 59 C0 66 0F 58 38 66 0F 58 48 20 66 0F 59 C8 66 0F 58 60 50 66 0F 58 F9 66 0F 28 48 70 66 0F 59 C8 66 0F 59 C0 66 0F 58 E1 66 0F 28 48 40 66 0F 59 C8 66 0F 58 F9 66 0F 28 CB 66 0F 59 D8 F2 0F 59 C0 66 0F 59 88 90 00 00 00 66 0F 59 E3 F3 0F 7E D9 66 0F 58 FC F3 0F 7E E1 F2 0F 59 C7 66 0F 15 FF F2 0F 58 C7 66 0F 15 C9 F2 0F 58 D9 F2 0F 5C E3 F2 0F 58 CC F3 0F 7E E2 F3 0F 7E B8 90 00 00 00 66 0F 15 D2 F2 0F 58 B8 98 00 00 00 F2 0F 59 FA F2 0F 58 B8 88 00 00 00 F2 0F 58 F9 F2 0F 58 C7 F3 41 0F 7E BC 24 90 00 00 00 F2 0F 59 E6 F3 0F 7E 90 A8 00 00 00 66 0F 54 D6 F2 0F 59 EA F2 0F 59 B0 A0 00 00 00 F2 0F 5C FD F2 0F 5C 90 80 00 00 00 F2 0F 5C FC F2 0F 59 FE F3 0F 7E E3 F2 0F 5C DA F2 0F 58 D3 F2 0F 5C E2 F2 0F 58 C4 F2 0F 5C C7 F2 0F 58 C3 E9 0B 01 00 00 83 C2 40 4D 8B CA 4D 8B D0 49 C7 C0 00 00 00 00 49 83 F9 00 0F 85 5D FD FF FF 83 C2 40 4D 8B CA 4D 8B D0 49 83 F9 00 0F 85 4A FD FF FF E9 73 FD FF FF 0F 84 6D FD FF FF F7 D9 49 D3 EA 49 8B C1 49 D3 E9 2B D1 F7 D9 83 C1 40 48 D3 E0 4C 0B D0 E9 50 FD FF FF F7 D1 49 C1 E1 20 4D 0B CB 49 D3 E1 49 8B F9 41 F7 C1 00 00 00 80 75 56 41 D3 E9 BB 00 00 00 00 48 C1 EF 02 E9 EF FC FF FF 41 D3 E9 BB 00 00 00 40 D3 EB 49 C1 E1 20 4D 0B CB 48 C1 E3 20 81 C7 00 00 00 40 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 E9 AA FC FF FF 41 D3 E9 48 BB 00 00 00 00 01 00 00 00 48 D3 EB 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 48 C1 EF 02 81 C7 00 00 00 40 E9 66 FC FF FF F2 0F 5C C0 F2 0F 11 44 24 48 0F 28 74 24 30 0F 28 7C 24 20 F2 0F 10 44 24 48 48 83 C4 58 41 5C 5F 5E 5B C3 0F 1F 00 }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "__sse2_tan2"
		size = 1712
		refs = "001b MMDRSHIFT 002b MMDPI1 0033 MMDPI2 003b MMIABSMASK 0043 MMDINVPI2 0057 MMDPI3 006b MMDHUGE 007f MMDPI4 00ba MMDP3 00c2 MMDQ3 00ca MMDP0 00d2 MMDQ0 00de MMDP2 00ea MMDQ2 00f6 MMDP1 0102 MMDQ1 016e MMISIGNMASK 0193 TWO_POW_30 01a5 flAllOnes 020f THE_PI04_INV 0224 MMI_ONE 022c MSK_LOW_BIT 0234 RS 0248 PI04C_0 0254 PI04C_1 0264 PI04C_2 0295 PI04C_3 02c1 PI04C_4"
	strings:
		$1 = { 48 81 EC D8 00 00 00 0F 29 BC 24 C0 00 00 00 0F 29 B4 24 B0 00 00 00 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 F8 66 0F 28 D0 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F 59 05 ?? ?? ?? ?? 66 0F 58 C6 66 0F 28 D8 66 0F 5C C6 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 66 3D ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 E7 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 F8 66 0F 28 C3 66 0F 73 F3 3E 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 57 C9 66 0F C2 D9 04 66 0F 73 F0 3F 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 E6 66 0F 59 EA 66 0F 58 EF 66 0F 59 E1 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 C7 44 24 20 00 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F DB CA 66 0F 29 54 24 30 66 0F 70 FF F5 66 0F DB 15 ?? ?? ?? ?? 66 0F 29 4C 24 40 66 0F 28 0D ?? ?? ?? ?? 66 0F 66 CA 66 0F 29 7C 24 50 66 0F 57 3D ?? ?? ?? ?? 66 0F 50 D1 66 0F 29 54 24 60 66 0F 29 7C 24 70 66 0F 28 3D ?? ?? ?? ?? 83 F2 03 0F 85 6C 03 00 00 83 F8 03 74 3C 66 0F 59 F8 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 57 C9 66 0F 5C D7 66 0F 54 5C 24 70 66 0F 54 54 24 70 66 0F 29 9C 24 80 00 00 00 66 0F 29 94 24 90 00 00 00 66 0F 28 54 24 60 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DA 66 0F E6 DB 66 0F 70 DB 10 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 C3 66 0F 5C 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E0 66 0F 5C D1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 CA 66 0F 5C D4 66 0F 5C CA 66 0F 28 F2 66 0F 5C CC 66 0F 5C D5 66 0F 72 E3 01 66 0F 5C F2 66 0F 28 FA 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 D1 66 0F 59 E0 66 0F 5C FA 66 0F 28 EA 66 0F 5C D4 66 0F 58 CF 66 0F 5C EA 66 0F 59 05 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C C8 66 0F 58 D1 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 F2 66 0F 59 D2 83 F8 03 74 1E 66 0F 54 5C 24 50 66 0F 54 4C 24 50 66 0F 56 9C 24 80 00 00 00 66 0F 56 8C 24 90 00 00 00 66 0F 28 C3 66 0F 73 F3 3E 66 0F 73 F0 3F 66 0F 59 E2 66 0F 59 EA 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F EF 44 24 40 66 0F 59 E2 66 0F 59 EA 66 0F EF C9 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 59 EA 66 0F C2 D9 04 66 0F 58 25 ?? ?? ?? ?? 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E6 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 E9 A6 02 00 00 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DA 66 0F E6 DB 66 0F 70 DB 10 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 C3 66 0F 5C 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E0 66 0F 5C D1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 CA 66 0F 5C D4 66 0F 5C CA 66 0F 28 F2 66 0F 5C CC 66 0F 5C D5 66 0F 72 E3 01 66 0F 5C F2 66 0F 28 FA 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 D1 66 0F 59 E0 66 0F 5C FA 66 0F 28 EA 66 0F 5C D4 66 0F 58 CF 66 0F 5C EA 66 0F 59 05 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C C8 66 0F 58 D1 66 0F 28 C3 66 0F 73 F0 3F 66 0F EF 44 24 40 66 0F 73 F3 3E 66 0F EF C9 66 0F C2 D9 04 66 0F 28 CA 66 0F 59 D2 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 E6 66 0F 59 EA 66 0F 58 EF 66 0F 59 E1 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 E9 1E 01 00 00 89 44 24 20 83 F8 03 0F 84 F4 00 00 00 66 0F 28 54 24 30 66 0F 59 F8 66 0F 5C D4 66 0F EF E4 66 0F 5C D5 66 0F 5C D6 66 0F 57 C9 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 29 8C 24 A0 00 00 00 66 0F 28 C3 66 0F 73 F0 3F 66 0F EF C4 66 0F 73 F3 3E 66 0F EF C9 66 0F C2 D9 04 66 0F 28 8C 24 A0 00 00 00 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 25 ?? ?? ?? ?? 66 0F 59 EA 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 E2 66 0F 58 E6 66 0F 59 EA 66 0F 58 EF 66 0F 59 E1 66 0F 28 CB 66 0F 54 CC 66 0F 28 D3 66 0F 55 D5 66 0F 56 CA 66 0F 28 F3 66 0F 55 F4 66 0F 28 FB 66 0F 54 FD 66 0F 56 F7 66 0F 5E F1 66 0F 57 C6 66 0F 29 84 24 A0 00 00 00 8B 44 24 20 A8 01 75 4B D1 F8 A8 01 75 27 D1 F8 89 44 24 20 66 0F 28 84 24 A0 00 00 00 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 F2 0F 10 44 24 38 89 44 24 20 E8 05 F4 FF FF F2 0F 11 84 24 A8 00 00 00 8B 44 24 20 EB BB F2 0F 10 44 24 30 E8 EB F3 FF FF F2 0F 11 84 24 A0 00 00 00 8B 44 24 20 EB 9B 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "_fstat64i32"
		size = 2352
		refs = "0013 __security_cookie 0059 ??_C@_1BM@KFJLMBPG@?$AA?$CI?$AAb?$AAu?$AAf?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0065 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 007a ??_C@_1FC@OJLJOFCB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAl?$AAo?$AAw?$AAi?$AAo?$AA?2?$AAf@ 0084 _CrtDbgReportW 0098 __doserrno 00a3 _errno 00c6 ??_C@_1BI@JNJJGKPB@?$AA_?$AAf?$AAs?$AAt?$AAa?$AAt?$AA6?$AA4?$AAi?$AA3?$AA2?$AA?$AA@ 00d2 _invalid_parameter 00f1 memset 012f _nhandle 0160 ??_C@_1GO@IHCMJFJC@?$AA?$CI?$AAf?$AAi?$AAl?$AAd?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAi?$AAl?$AAd?$AAe?$AAs@ 01f6 __pioinfo 023f ??_C@_1DE@GMHIHBND@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAi?$AAl?$AAd?$AAe?$AAs?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 02ce __lock_fhandle 0323 ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 038d __imp_GetFileType 04e3 __imp_PeekNamedPipe 053c __imp_GetLastError 0543 _dosmaperr 05e3 __imp_GetFileInformationByHandle 0676 __imp_FileTimeToLocalFileTime 068d __imp_FileTimeToSystemTime 06f7 __loctotime64_t 0910 _unlock_fhandle 0924 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 81 EC E8 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 D8 00 00 00 C7 44 24 40 00 00 00 00 48 83 BC 24 F8 00 00 00 00 74 0A C7 44 24 68 01 00 00 00 EB 08 C7 44 24 68 00 00 00 00 8B 44 24 68 89 44 24 64 83 7C 24 64 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 5F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 64 00 75 49 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 5F 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 38 08 00 00 41 B8 30 00 00 00 33 D2 48 8B 8C 24 F8 00 00 00 E8 ?? ?? ?? ?? 48 63 84 24 F0 00 00 00 48 83 F8 FE 75 20 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 B8 FF FF FF FF E9 F5 07 00 00 83 BC 24 F0 00 00 00 00 7C 19 8B 05 ?? ?? ?? ?? 39 84 24 F0 00 00 00 73 0A C7 44 24 48 01 00 00 00 EB 08 C7 44 24 48 00 00 00 00 8B 44 24 48 89 44 24 4C 83 7C 24 4C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 63 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 4C 00 75 49 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 63 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 31 07 00 00 8B 84 24 F0 00 00 00 C1 F8 05 48 98 48 8D 0D ?? ?? ?? ?? 8B 94 24 F0 00 00 00 83 E2 1F 48 63 D2 48 6B D2 58 48 8B 04 C1 0F BE 44 10 08 83 E0 01 85 C0 74 0A C7 44 24 50 01 00 00 00 EB 08 C7 44 24 50 00 00 00 00 8B 44 24 50 89 44 24 60 83 7C 24 60 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 64 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 60 00 75 49 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 64 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 52 06 00 00 8B 8C 24 F0 00 00 00 E8 ?? ?? ?? ?? 90 8B 84 24 F0 00 00 00 C1 F8 05 48 98 48 8D 0D ?? ?? ?? ?? 8B 94 24 F0 00 00 00 83 E2 1F 48 63 D2 48 6B D2 58 48 8B 04 C1 0F BE 44 10 08 83 E0 01 85 C0 75 58 E8 ?? ?? ?? ?? C7 00 09 00 00 00 C7 44 24 40 FF FF FF FF 33 C0 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 6C 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 E9 A9 05 00 00 8B 84 24 F0 00 00 00 C1 F8 05 48 98 48 8D 0D ?? ?? ?? ?? 8B 94 24 F0 00 00 00 83 E2 1F 48 63 D2 48 6B D2 58 48 8B 04 C1 48 8B 0C 10 FF 15 ?? ?? ?? ?? 0F BA F0 0F 89 44 24 44 83 7C 24 44 01 0F 84 B0 01 00 00 83 7C 24 44 02 74 0B 83 7C 24 44 03 0F 85 63 01 00 00 83 7C 24 44 02 75 13 B8 00 20 00 00 48 8B 8C 24 F8 00 00 00 66 89 41 06 EB 11 B8 00 10 00 00 48 8B 8C 24 F8 00 00 00 66 89 41 06 48 8B 84 24 F8 00 00 00 8B 8C 24 F0 00 00 00 89 08 48 8B 84 24 F8 00 00 00 8B 8C 24 F0 00 00 00 89 48 10 B8 01 00 00 00 48 8B 8C 24 F8 00 00 00 66 89 41 08 33 C0 48 8B 8C 24 F8 00 00 00 66 89 41 04 33 C0 48 8B 8C 24 F8 00 00 00 66 89 41 0C 33 C0 48 8B 8C 24 F8 00 00 00 66 89 41 0A 48 8B 84 24 F8 00 00 00 48 C7 40 28 00 00 00 00 48 8B 84 24 F8 00 00 00 48 C7 40 20 00 00 00 00 48 8B 84 24 F8 00 00 00 48 C7 40 18 00 00 00 00 83 7C 24 44 02 75 14 48 8B 84 24 F8 00 00 00 C7 40 14 00 00 00 00 E9 88 00 00 00 8B 84 24 F0 00 00 00 C1 F8 05 48 98 48 8D 0D ?? ?? ?? ?? 8B 94 24 F0 00 00 00 83 E2 1F 48 63 D2 48 6B D2 58 48 89 94 24 80 00 00 00 48 8B 04 C1 48 C7 44 24 28 00 00 00 00 48 8D 4C 24 70 48 89 4C 24 20 45 33 C9 45 33 C0 33 D2 48 8B 8C 24 80 00 00 00 48 8B 0C 08 FF 15 ?? ?? ?? ?? 89 44 24 6C 83 7C 24 6C 00 74 11 48 8B 84 24 F8 00 00 00 8B 4C 24 70 89 48 14 EB 0F 48 8B 84 24 F8 00 00 00 C7 40 14 00 00 00 00 E9 F1 03 00 00 EB 3B 83 7C 24 44 00 75 1A E8 ?? ?? ?? ?? C7 00 09 00 00 00 C7 44 24 40 FF FF FF FF E9 D0 03 00 00 EB 1A FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? C7 44 24 40 FF FF FF FF E9 B4 03 00 00 33 C0 48 8B 8C 24 F8 00 00 00 66 89 41 06 33 C0 48 8B 8C 24 F8 00 00 00 66 89 41 0C 33 C0 48 8B 8C 24 F8 00 00 00 66 89 41 0A 33 C0 48 8B 8C 24 F8 00 00 00 66 89 41 04 B8 01 00 00 00 48 8B 8C 24 F8 00 00 00 66 89 41 08 8B 84 24 F0 00 00 00 C1 F8 05 48 98 48 8D 0D ?? ?? ?? ?? 8B 94 24 F0 00 00 00 83 E2 1F 48 63 D2 48 6B D2 58 48 89 94 24 88 00 00 00 48 8B 04 C1 48 8D 94 24 A0 00 00 00 48 8B 8C 24 88 00 00 00 48 8B 0C 08 FF 15 ?? ?? ?? ?? 85 C0 75 1A FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? C7 44 24 40 FF FF FF FF E9 03 03 00 00 8B 84 24 A0 00 00 00 83 E0 01 85 C0 74 1F 48 8B 84 24 F8 00 00 00 0F B7 40 06 0D 24 01 00 00 48 8B 8C 24 F8 00 00 00 66 89 41 06 EB 1D 48 8B 84 24 F8 00 00 00 0F B7 40 06 0D B6 01 00 00 48 8B 8C 24 F8 00 00 00 66 89 41 06 83 BC 24 B4 00 00 00 00 75 0E 83 BC 24 B8 00 00 00 00 0F 84 A2 00 00 00 48 8D 54 24 58 48 8D 8C 24 B4 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 17 48 8D 94 24 90 00 00 00 48 8D 4C 24 58 FF 15 ?? ?? ?? ?? 85 C0 75 0D C7 44 24 40 FF FF FF FF E9 66 02 00 00 0F B7 84 24 9C 00 00 00 0F B7 8C 24 9A 00 00 00 0F B7 94 24 98 00 00 00 44 0F B7 84 24 96 00 00 00 44 0F B7 8C 24 92 00 00 00 44 89 4C 24 7C 44 0F B7 94 24 90 00 00 00 C7 44 24 30 FF FF FF FF 89 44 24 28 89 4C 24 20 44 8B CA 8B 44 24 7C 8B D0 41 8B CA E8 ?? ?? ?? ?? 48 8B 8C 24 F8 00 00 00 48 89 41 20 EB 10 48 8B 84 24 F8 00 00 00 48 C7 40 20 00 00 00 00 83 BC 24 AC 00 00 00 00 75 0E 83 BC 24 B0 00 00 00 00 0F 84 A2 00 00 00 48 8D 54 24 58 48 8D 8C 24 AC 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 17 48 8D 94 24 90 00 00 00 48 8D 4C 24 58 FF 15 ?? ?? ?? ?? 85 C0 75 0D C7 44 24 40 FF FF FF FF E9 9C 01 00 00 0F B7 84 24 9C 00 00 00 0F B7 8C 24 9A 00 00 00 0F B7 94 24 98 00 00 00 44 0F B7 84 24 96 00 00 00 44 0F B7 8C 24 92 00 00 00 44 89 4C 24 78 44 0F B7 94 24 90 00 00 00 C7 44 24 30 FF FF FF FF 89 44 24 28 89 4C 24 20 44 8B CA 8B 44 24 78 8B D0 41 8B CA E8 ?? ?? ?? ?? 48 8B 8C 24 F8 00 00 00 48 89 41 18 EB 18 48 8B 84 24 F8 00 00 00 48 8B 8C 24 F8 00 00 00 48 8B 49 20 48 89 48 18 83 BC 24 A4 00 00 00 00 75 0E 83 BC 24 A8 00 00 00 00 0F 84 A2 00 00 00 48 8D 54 24 58 48 8D 8C 24 A4 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 17 48 8D 94 24 90 00 00 00 48 8D 4C 24 58 FF 15 ?? ?? ?? ?? 85 C0 75 0D C7 44 24 40 FF FF FF FF E9 CA 00 00 00 0F B7 84 24 9C 00 00 00 0F B7 8C 24 9A 00 00 00 0F B7 94 24 98 00 00 00 44 0F B7 84 24 96 00 00 00 44 0F B7 8C 24 92 00 00 00 44 89 4C 24 74 44 0F B7 94 24 90 00 00 00 C7 44 24 30 FF FF FF FF 89 44 24 28 89 4C 24 20 44 8B CA 8B 44 24 74 8B D0 41 8B CA E8 ?? ?? ?? ?? 48 8B 8C 24 F8 00 00 00 48 89 41 28 EB 18 48 8B 84 24 F8 00 00 00 48 8B 8C 24 F8 00 00 00 48 8B 49 20 48 89 48 28 48 8B 84 24 F8 00 00 00 8B 8C 24 C4 00 00 00 89 48 14 48 8B 84 24 F8 00 00 00 0F B7 40 06 0F BA E8 0F 48 8B 8C 24 F8 00 00 00 66 89 41 06 48 8B 84 24 F8 00 00 00 C7 00 00 00 00 00 48 8B 84 24 F8 00 00 00 C7 40 10 00 00 00 00 8B 8C 24 F0 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 40 48 8B 8C 24 D8 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 E8 00 00 00 C3 }
	condition:
		$1
}

rule file_11_1_0 {
	meta:
		name = "_fstat64i32$fin$0"
		size = 28
		refs = "0010 _unlock_fhandle"
		altNames = "_fstat32$fin$0 _fstat32i64$fin$0 _fstat64$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 40 48 8B EA 8B 8D F0 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 40 5D C3 CC }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "strpbrk"
		size = 302
		refs = "0011 __security_cookie 0067 __report_rangecheckfailure 0125 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 78 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 60 48 8B 84 24 80 00 00 00 48 89 44 24 28 48 8B 84 24 88 00 00 00 48 89 44 24 30 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 83 7C 24 20 20 7D 25 48 63 44 24 20 48 89 44 24 38 48 83 7C 24 38 20 73 02 EB 05 E8 ?? ?? ?? ?? 48 8B 44 24 38 C6 44 04 40 00 EB CA 48 8B 44 24 30 0F B6 00 85 C0 74 49 48 8B 44 24 30 0F B6 00 C1 F8 03 48 98 48 8B 4C 24 30 0F B6 09 83 E1 07 BA 01 00 00 00 D3 E2 8B CA 0F B6 44 04 40 0B C1 48 8B 4C 24 30 0F B6 09 C1 F9 03 48 63 C9 88 44 0C 40 48 8B 44 24 30 48 FF C0 48 89 44 24 30 EB AB 48 8B 44 24 28 0F B6 00 85 C0 74 42 48 8B 44 24 28 0F B6 00 C1 F8 03 48 98 0F B6 44 04 40 48 8B 4C 24 28 0F B6 09 83 E1 07 BA 01 00 00 00 D3 E2 8B CA 23 C1 85 C0 74 07 48 8B 44 24 28 EB 11 48 8B 44 24 28 48 FF C0 48 89 44 24 28 EB B2 33 C0 48 8B 4C 24 60 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "_wfopen"
		size = 40
		refs = "001f _wfsopen"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 41 B8 40 00 00 00 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_690_2_0 {
	meta:
		name = "fopen"
		size = 40
		refs = "001f _fsopen"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 41 B8 40 00 00 00 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_13_1_0 {
	meta:
		name = "_wfopen_s"
		size = 240
		refs = "003f ??_C@_1CA@LLJLFCDN@?$AA?$CI?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0060 ??_C@_1EO@HOHPPGLK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAi?$AAo?$AA?2?$AAf@ 006a _CrtDbgReportW 007e _errno 00a1 ??_C@_1BE@JDODBHOJ@?$AA_?$AAw?$AAf?$AAo?$AAp?$AAe?$AAn?$AA_?$AAs?$AA?$AA@ 00ad _invalid_parameter 00c9 _wfsopen"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 50 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 9F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 9F 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 EB 33 41 B8 80 00 00 00 48 8B 54 24 60 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 4C 24 50 48 89 01 48 8B 44 24 50 48 83 38 00 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_690_3_0 {
	meta:
		name = "fopen_s"
		size = 240
		refs = "003f ??_C@_1CA@LLJLFCDN@?$AA?$CI?$AAp?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0060 ??_C@_1EO@HOHPPGLK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAi?$AAo?$AA?2?$AAf@ 006a _CrtDbgReportW 007e _errno 00a1 ??_C@_1BA@PBGKCCAP@?$AAf?$AAo?$AAp?$AAe?$AAn?$AA_?$AAs?$AA?$AA@ 00ad _invalid_parameter 00c9 _fsopen"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 50 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 9F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 9F 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 EB 33 41 B8 80 00 00 00 48 8B 54 24 60 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 4C 24 50 48 89 01 48 8B 44 24 50 48 83 38 00 74 04 33 C0 EB 07 E8 ?? ?? ?? ?? 8B 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_13_2_0 {
	meta:
		name = "_wfsopen"
		size = 701
		refs = "0059 ??_C@_1BO@CLGIAEOJ@?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0065 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 007a ??_C@_1EO@HOHPPGLK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAi?$AAo?$AA?2?$AAf@ 0084 _CrtDbgReportW 0098 _errno 00bb ??_C@_1BC@PAJNLEOB@?$AA_?$AAw?$AAf?$AAs?$AAo?$AAp?$AAe?$AAn?$AA?$AA@ 00c7 _invalid_parameter 0101 ??_C@_1BO@MJMKAKCJ@?$AA?$CI?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 01ad ??_C@_1CI@HBNALCBB@?$AA?$CI?$AA?$CK?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0227 _getstream 0277 _local_unwind 0299 _wopenfile 02a8 _unlock_file"
	strings:
		$1 = { 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 78 48 89 64 24 68 48 C7 44 24 40 00 00 00 00 48 C7 44 24 58 00 00 00 00 48 83 BC 24 80 00 00 00 00 74 0A C7 44 24 50 01 00 00 00 EB 08 C7 44 24 50 00 00 00 00 8B 44 24 50 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 36 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 36 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 E6 01 00 00 48 83 BC 24 88 00 00 00 00 74 0A C7 44 24 4C 01 00 00 00 EB 08 C7 44 24 4C 00 00 00 00 8B 44 24 4C 89 44 24 48 83 7C 24 48 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 37 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 48 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 37 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 3E 01 00 00 48 8B 84 24 88 00 00 00 0F B7 00 85 C0 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 38 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 38 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 92 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 75 0F E8 ?? ?? ?? ?? C7 00 18 00 00 00 33 C0 EB 71 48 8B 84 24 80 00 00 00 0F B7 00 85 C0 75 25 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 60 00 00 00 00 48 8D 15 42 00 00 00 48 8B 4C 24 68 E8 ?? ?? ?? ?? 4C 8B 4C 24 40 44 8B 84 24 90 00 00 00 48 8B 94 24 88 00 00 00 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 58 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 58 EB 05 48 8B 44 24 60 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_13_3_0 {
	meta:
		name = "_wfsopen$fin$0"
		size = 26
		refs = "000e _unlock_file"
		altNames = "_fsopen$fin$0 fputwc$fin$0 rewind$fin$0 vprintf_helper$fin$0 vwprintf_helper$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "__loctotime64_t"
		size = 1155
		refs = "001c __security_cookie 0068 _errno 0156 _days 0329 __tzset 0333 _get_daylight 034b ??_C@_1FC@HJMIPFDO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAd?$AAt@ 0352 ??_C@_1CA@BCKHBOCK@?$AA_?$AA_?$AAl?$AAo?$AAc?$AAt?$AAo?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA_?$AAt?$AA?$AA@ 0359 ??_C@_1DC@MEHEMOPB@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAd?$AAa?$AAy?$AAl?$AAi?$AAg?$AAh?$AAt?$AA?$CI?$AA?$CG?$AAd?$AAa?$AAy?$AAl?$AAi?$AAg?$AAh?$AAt?$AA?$CJ?$AA?$AA@ 0360 _invoke_watson_if_error 036a _get_dstbias 0390 ??_C@_1CO@IMMOMMCB@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAd?$AAs?$AAt?$AAb?$AAi?$AAa?$AAs?$AA?$CI?$AA?$CG?$AAd?$AAs?$AAt?$AAb?$AAi?$AAa?$AAs?$AA?$CJ?$AA?$AA@ 03a1 _get_timezone 03c7 ??_C@_1DC@CMKCHHFC@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CI?$AA?$CG?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CJ?$AA?$AA@ 0449 _isindst 0477 __security_check_cookie"
	strings:
		$1 = { 44 89 4C 24 20 44 89 44 24 18 89 54 24 10 89 4C 24 08 48 81 EC 98 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 88 00 00 00 C7 44 24 40 00 00 00 00 C7 44 24 44 00 00 00 00 C7 44 24 48 00 00 00 00 8B 84 24 A0 00 00 00 2D 6C 07 00 00 83 F8 46 7C 13 8B 84 24 A0 00 00 00 2D 6C 07 00 00 3D 4C 04 00 00 7E 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 C0 FF FF FF FF E9 ED 03 00 00 8B 84 24 A0 00 00 00 2D 6C 07 00 00 89 84 24 A0 00 00 00 83 BC 24 A8 00 00 00 01 7C 0A 83 BC 24 A8 00 00 00 0C 7E 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 C0 FF FF FF FF E9 AF 03 00 00 83 BC 24 B8 00 00 00 00 7C 0A 83 BC 24 B8 00 00 00 17 7E 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 C0 FF FF FF FF E9 84 03 00 00 83 BC 24 C0 00 00 00 00 7C 0A 83 BC 24 C0 00 00 00 3B 7E 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 C0 FF FF FF FF E9 59 03 00 00 83 BC 24 C8 00 00 00 00 7C 0A 83 BC 24 C8 00 00 00 3B 7E 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 C0 FF FF FF FF E9 2E 03 00 00 83 BC 24 B0 00 00 00 01 0F 8C 8D 00 00 00 48 63 84 24 A8 00 00 00 48 8D 0D ?? ?? ?? ?? 8B 94 24 A8 00 00 00 FF CA 48 63 D2 4C 8D 05 ?? ?? ?? ?? 41 8B 14 90 8B 04 81 2B C2 3B 84 24 B0 00 00 00 7D 70 8B 84 24 A0 00 00 00 99 83 E2 03 03 C2 83 E0 03 2B C2 85 C0 75 15 8B 84 24 A0 00 00 00 99 B9 64 00 00 00 F7 F9 8B C2 85 C0 75 1A 8B 84 24 A0 00 00 00 05 6C 07 00 00 99 B9 90 01 00 00 F7 F9 8B C2 85 C0 75 14 83 BC 24 A8 00 00 00 02 75 0A 83 BC 24 B0 00 00 00 1D 7E 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 C0 FF FF FF FF E9 7C 02 00 00 8B 84 24 A8 00 00 00 FF C8 48 98 48 8D 0D ?? ?? ?? ?? 8B 04 81 8B 8C 24 B0 00 00 00 03 C8 8B C1 89 44 24 30 8B 84 24 A0 00 00 00 99 83 E2 03 03 C2 83 E0 03 2B C2 85 C0 75 15 8B 84 24 A0 00 00 00 99 B9 64 00 00 00 F7 F9 8B C2 85 C0 75 1A 8B 84 24 A0 00 00 00 05 6C 07 00 00 99 B9 90 01 00 00 F7 F9 8B C2 85 C0 75 14 83 BC 24 A8 00 00 00 02 7E 0A 8B 44 24 30 FF C0 89 44 24 30 48 63 84 24 A0 00 00 00 48 83 E8 46 48 69 C0 6D 01 00 00 48 89 44 24 58 8B 8C 24 A0 00 00 00 FF C9 8B C1 99 83 E2 03 03 C2 C1 F8 02 89 44 24 4C 8B 8C 24 A0 00 00 00 FF C9 8B C1 99 B9 64 00 00 00 F7 F9 8B 4C 24 4C 2B C8 8B C1 89 44 24 50 8B 8C 24 A0 00 00 00 81 C1 2B 01 00 00 8B C1 99 B9 90 01 00 00 F7 F9 8B 4C 24 50 8D 44 01 EF 48 98 48 8B 4C 24 58 48 03 C8 48 8B C1 48 63 4C 24 30 48 03 C1 48 6B C0 18 48 63 8C 24 B8 00 00 00 48 03 C1 48 89 44 24 38 48 6B 44 24 38 3C 48 63 8C 24 C0 00 00 00 48 03 C1 48 6B C0 3C 48 63 8C 24 C8 00 00 00 48 03 C1 48 89 44 24 38 E8 ?? ?? ?? ?? 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 87 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8D 4C 24 44 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 88 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8D 4C 24 48 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 89 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 63 44 24 48 48 8B 4C 24 38 48 03 C8 48 8B C1 48 89 44 24 38 8B 44 24 30 89 44 24 7C 8B 84 24 A0 00 00 00 89 44 24 74 8B 84 24 A8 00 00 00 FF C8 89 44 24 70 8B 84 24 B8 00 00 00 89 44 24 68 8B 84 24 C0 00 00 00 89 44 24 64 8B 84 24 C8 00 00 00 89 44 24 60 83 BC 24 D0 00 00 00 01 74 1F 83 BC 24 D0 00 00 00 FF 75 2A 83 7C 24 40 00 74 23 48 8D 4C 24 60 E8 ?? ?? ?? ?? 85 C0 74 15 48 63 44 24 44 48 8B 4C 24 38 48 03 C8 48 8B C1 48 89 44 24 38 48 8B 44 24 38 48 8B 8C 24 88 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_14_1_0 {
	meta:
		name = "_invoke_watson_if_error"
		size = 72
		refs = "003f _invoke_watson"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 38 83 7C 24 40 00 75 02 EB 23 48 8B 44 24 68 48 89 44 24 20 44 8B 4C 24 60 4C 8B 44 24 58 48 8B 54 24 50 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "_tell"
		size = 30
		refs = "0015 _lseek"
		altNames = "_telli64"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 41 B8 01 00 00 00 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "_loaddll"
		size = 43
		refs = "000a __crtIsPackagedApp 0022 __imp_LoadLibraryExA"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 E8 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 10 45 33 C0 33 D2 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_1_0 {
	meta:
		name = "_unloaddll"
		size = 39
		refs = "0010 __imp_FreeLibrary 001a __imp_GetLastError"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "__avx_logf8"
		size = 544
		refs = "003f __common_slog_data 0217 __common_slog_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 C5 7C 11 B4 24 F0 01 00 00 C5 7C 11 A4 24 D0 01 00 00 C5 7C 11 9C 24 B0 01 00 00 C5 7C 11 8C 24 90 01 00 00 4C 89 AC 24 10 02 00 00 4C 8D AC 24 2F 01 00 00 C5 F8 10 25 ?? ?? ?? ?? 49 83 E5 C0 C5 F8 10 2D ?? ?? ?? ?? C5 F8 10 0D ?? ?? ?? ?? C5 F8 10 15 ?? ?? ?? ?? C5 79 FA F4 C4 E3 7D 19 C3 01 C4 C1 21 72 E6 17 C5 61 FA E4 C5 09 DB F5 C4 C1 31 72 E4 17 C5 99 DB ED C5 09 FE F4 C5 D1 FE E4 C5 F9 FE E9 C5 E1 FE C9 C5 E9 66 D9 C5 F1 EF C9 C4 43 25 18 C9 01 C4 41 7C 5B D9 C5 69 66 CD C5 B1 6B D3 C5 E9 63 D9 C5 F9 D7 D3 C5 24 59 1D ?? ?? ?? ?? C4 E3 0D 18 E4 01 C5 DC 5C 15 ?? ?? ?? ?? C5 EC 59 25 ?? ?? ?? ?? C5 DC 58 2D ?? ?? ?? ?? C5 54 59 CA C5 34 58 25 ?? ?? ?? ?? C5 1C 59 F2 C5 8C 58 0D ?? ?? ?? ?? C5 F4 59 DA C5 E4 58 25 ?? ?? ?? ?? C5 DC 59 EA C5 54 58 0D ?? ?? ?? ?? C5 34 59 E2 C5 1C 58 35 ?? ?? ?? ?? C5 8C 59 CA C5 F4 59 DA C5 E4 58 D2 C5 A4 58 CA 84 D2 75 38 C5 7C 10 8C 24 90 01 00 00 C5 7C 10 9C 24 B0 01 00 00 C5 7C 10 A4 24 D0 01 00 00 C5 7C 10 B4 24 F0 01 00 00 4C 8B AC 24 10 02 00 00 C5 FC 28 C1 48 81 C4 18 02 00 00 C3 C4 C1 7C 11 45 00 C4 C1 7C 11 4D 40 85 D2 74 B8 33 C0 C5 FC 11 B4 24 C0 00 00 00 C5 FC 11 BC 24 A0 00 00 00 C5 7C 11 84 24 80 00 00 00 C5 7C 11 54 24 60 C5 7C 11 6C 24 40 C5 7C 11 7C 24 20 48 89 9C 24 E8 00 00 00 8B D8 48 89 B4 24 E0 00 00 00 8B F2 0F A3 DE 72 4F FF C3 83 FB 20 7C F4 C5 FC 10 B4 24 C0 00 00 00 C5 FC 10 BC 24 A0 00 00 00 C5 7C 10 84 24 80 00 00 00 C5 7C 10 54 24 60 C5 7C 10 6C 24 40 C5 7C 10 7C 24 20 C4 C1 7C 10 4D 40 48 8B 9C 24 E8 00 00 00 48 8B B4 24 E0 00 00 00 E9 21 FF FF FF C5 F8 77 49 8D 4C 9D 00 49 8D 54 9D 40 E8 ?? ?? ?? ?? EB 9D 0F 1F 00 }
	condition:
		$1
}

rule file_21_0_0 {
	meta:
		name = "logb"
		size = 125
		refs = "0015 _dunscale 0043 _fperrraise 004b _Inf_C 0052 __xmm@80000000000000008000000000000000"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 38 48 8D 54 24 40 48 8D 4C 24 20 E8 ?? ?? ?? ?? 98 89 44 24 24 83 7C 24 24 00 74 18 83 7C 24 24 01 74 2C 83 7C 24 24 02 74 02 EB 2D F2 0F 10 44 24 40 EB 3B B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? EB 20 F2 0F 10 05 ?? ?? ?? ?? EB 16 0F B7 44 24 20 66 FF C8 66 89 44 24 20 0F BF 44 24 20 F2 0F 2A C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1330_0_0 {
	meta:
		name = "logbl"
		size = 125
		refs = "0015 _ldunscale 0043 _fperrraise 004b _LInf_C 0052 __xmm@80000000000000008000000000000000"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 38 48 8D 54 24 40 48 8D 4C 24 20 E8 ?? ?? ?? ?? 98 89 44 24 24 83 7C 24 24 00 74 18 83 7C 24 24 01 74 2C 83 7C 24 24 02 74 02 EB 2D F2 0F 10 44 24 40 EB 3B B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? EB 20 F2 0F 10 05 ?? ?? ?? ?? EB 16 0F B7 44 24 20 66 FF C8 66 89 44 24 20 0F BF 44 24 20 F2 0F 2A C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "?_CrtDbgReportW@@YAHHPEBGH00ZZ"
		size = 118
		refs = "005c _CrtDbgReportWV"
		altNames = "_CrtDbgReportW"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 58 48 8D 84 24 88 00 00 00 48 89 44 24 48 48 8B 44 24 58 48 8B 4C 24 48 48 89 4C 24 30 48 8B 8C 24 80 00 00 00 48 89 4C 24 28 48 8B 4C 24 78 48 89 4C 24 20 44 8B 4C 24 70 4C 8B 44 24 68 48 8B D0 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 40 48 C7 44 24 48 00 00 00 00 8B 44 24 40 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_594_0_0 {
	meta:
		name = "_CrtDbgReport"
		size = 118
		refs = "005c _CrtDbgReportV"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 58 48 8D 84 24 88 00 00 00 48 89 44 24 48 48 8B 44 24 58 48 8B 4C 24 48 48 89 4C 24 30 48 8B 8C 24 80 00 00 00 48 89 4C 24 28 48 8B 4C 24 78 48 89 4C 24 20 44 8B 4C 24 70 4C 8B 44 24 68 48 8B D0 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 40 48 C7 44 24 48 00 00 00 00 8B 44 24 40 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_22_2_0 {
	meta:
		name = "_CrtDbgReportWV"
		size = 85
		refs = "004c _VCrtDbgReportW"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 48 48 8B 84 24 80 00 00 00 48 89 44 24 30 48 8B 44 24 78 48 89 44 24 28 48 8B 44 24 70 48 89 44 24 20 44 8B 4C 24 68 4C 8B 44 24 60 48 8B 54 24 58 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_594_1_0 {
	meta:
		name = "_CrtDbgReportV"
		size = 85
		refs = "004c _VCrtDbgReportA"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 48 48 8B 84 24 80 00 00 00 48 89 44 24 30 48 8B 44 24 78 48 89 44 24 28 48 8B 44 24 70 48 89 44 24 20 44 8B 4C 24 68 4C 8B 44 24 60 48 8B 54 24 58 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_22_3_0 {
	meta:
		name = "_CrtSetReportHookW2"
		size = 1034
		refs = "0047 ??_C@_1HI@OFEHGPPC@?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAC?$AAR?$AAT?$AA_?$AAR?$AAP?$AAT?$AAH?$AAO?$AAO?$AAK?$AA_?$AAI?$AAN?$AAS?$AAT?$AAA?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0053 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0068 ??_C@_1EO@JACJHHCK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 0072 _CrtDbgReportW 0086 _errno 00a9 ??_C@_1CI@IIHEAKEI@?$AA_?$AAC?$AAr?$AAt?$AAS?$AAe?$AAt?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AAH?$AAo?$AAo?$AAk?$AAW?$AA2?$AA?$AA@ 00b5 _invalid_parameter 00ef ??_C@_1CG@JBJEFOCM@?$AAp?$AAf?$AAn?$AAN?$AAe?$AAw?$AAH?$AAo?$AAo?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0171 _lock 0179 _pReportHookListW 024b _free_dbg 025a ??_C@_1FI@PHIAFFHM@?$AA?$CI?$AA?$CC?$AAT?$AAh?$AAe?$AA?5?$AAh?$AAo?$AAo?$AAk?$AA?5?$AAf?$AAu?$AAn?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAi?$AAn?$AA?5?$AAt?$AAh@ 035f ??_C@_0CH@BBGAHGHC@f?3?2dd?2vctools?2crt?2crtw32?2misc?2db@ 036e _malloc_dbg 03fd _unlock"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 83 EC 68 C7 44 24 30 00 00 00 00 83 7C 24 70 00 74 11 83 7C 24 70 01 74 0A C7 44 24 34 00 00 00 00 EB 08 C7 44 24 34 01 00 00 00 8B 44 24 34 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 74 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 74 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 42 03 00 00 48 83 7C 24 78 00 74 0A C7 44 24 3C 01 00 00 00 EB 08 C7 44 24 3C 00 00 00 00 8B 44 24 3C 89 44 24 40 83 7C 24 40 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 75 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 40 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 75 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 9A 02 00 00 B9 0F 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 50 EB 0E 48 8B 44 24 50 48 8B 40 08 48 89 44 24 50 48 83 7C 24 50 00 74 14 48 8B 44 24 50 48 8B 4C 24 78 48 39 48 18 75 02 EB 02 EB D6 83 7C 24 70 01 0F 85 F0 00 00 00 48 83 7C 24 50 00 0F 84 8C 00 00 00 48 8B 44 24 50 8B 40 10 FF C8 89 44 24 44 48 8B 44 24 50 8B 4C 24 44 89 48 10 8B 44 24 44 89 44 24 30 83 7C 24 30 00 75 61 48 8B 44 24 50 48 83 78 08 00 74 14 48 8B 44 24 50 48 8B 40 08 48 8B 4C 24 50 48 8B 09 48 89 08 48 8B 44 24 50 48 83 38 00 74 17 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 48 8B 49 08 48 89 48 08 EB 10 48 8B 44 24 50 48 8B 40 08 48 89 05 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? EB 53 33 C0 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 92 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 C7 44 24 30 FF FF FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 4E 01 00 00 48 83 7C 24 50 00 0F 84 A1 00 00 00 48 8B 44 24 50 8B 40 10 FF C0 89 44 24 48 48 8B 44 24 50 8B 4C 24 48 89 48 10 8B 44 24 48 89 44 24 30 48 8B 05 ?? ?? ?? ?? 48 39 44 24 50 74 6C 48 8B 44 24 50 48 83 78 08 00 74 14 48 8B 44 24 50 48 8B 40 08 48 8B 4C 24 50 48 8B 09 48 89 08 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 48 8B 49 08 48 89 48 08 48 8B 44 24 50 48 C7 00 00 00 00 00 48 8B 44 24 50 48 8B 0D ?? ?? ?? ?? 48 89 48 08 48 8B 05 ?? ?? ?? ?? 48 8B 4C 24 50 48 89 08 48 8B 44 24 50 48 89 05 ?? ?? ?? ?? E9 A1 00 00 00 41 B9 AC 00 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 B9 20 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 50 48 83 7C 24 50 00 75 15 C7 44 24 30 FF FF FF FF E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 63 48 8B 44 24 50 48 C7 00 00 00 00 00 48 8B 44 24 50 48 8B 0D ?? ?? ?? ?? 48 89 48 08 48 83 3D ?? ?? ?? ?? 00 74 0F 48 8B 05 ?? ?? ?? ?? 48 8B 4C 24 50 48 89 08 48 8B 44 24 50 C7 40 10 01 00 00 00 C7 44 24 30 01 00 00 00 48 8B 44 24 50 48 8B 4C 24 78 48 89 48 18 48 8B 44 24 50 48 89 05 ?? ?? ?? ?? B9 0F 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 30 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_594_2_0 {
	meta:
		name = "_CrtSetReportHook2"
		size = 1034
		refs = "0047 ??_C@_1HI@OFEHGPPC@?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAC?$AAR?$AAT?$AA_?$AAR?$AAP?$AAT?$AAH?$AAO?$AAO?$AAK?$AA_?$AAI?$AAN?$AAS?$AAT?$AAA?$AAL?$AAL?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0053 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0068 ??_C@_1EO@JACJHHCK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 0072 _CrtDbgReportW 0086 _errno 00a9 ??_C@_1CG@GNMJDMIO@?$AA_?$AAC?$AAr?$AAt?$AAS?$AAe?$AAt?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AAH?$AAo?$AAo?$AAk?$AA2?$AA?$AA@ 00b5 _invalid_parameter 00ef ??_C@_1CG@JBJEFOCM@?$AAp?$AAf?$AAn?$AAN?$AAe?$AAw?$AAH?$AAo?$AAo?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0171 _lock 0179 _pReportHookList 024b _free_dbg 025a ??_C@_1FI@PHIAFFHM@?$AA?$CI?$AA?$CC?$AAT?$AAh?$AAe?$AA?5?$AAh?$AAo?$AAo?$AAk?$AA?5?$AAf?$AAu?$AAn?$AAc?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAi?$AAn?$AA?5?$AAt?$AAh@ 035f ??_C@_0CH@BBGAHGHC@f?3?2dd?2vctools?2crt?2crtw32?2misc?2db@ 036e _malloc_dbg 03fd _unlock"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 83 EC 68 C7 44 24 30 00 00 00 00 83 7C 24 70 00 74 11 83 7C 24 70 01 74 0A C7 44 24 34 00 00 00 00 EB 08 C7 44 24 34 01 00 00 00 8B 44 24 34 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 74 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 74 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 42 03 00 00 48 83 7C 24 78 00 74 0A C7 44 24 3C 01 00 00 00 EB 08 C7 44 24 3C 00 00 00 00 8B 44 24 3C 89 44 24 40 83 7C 24 40 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 75 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 40 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 75 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 9A 02 00 00 B9 0F 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 50 EB 0E 48 8B 44 24 50 48 8B 40 08 48 89 44 24 50 48 83 7C 24 50 00 74 14 48 8B 44 24 50 48 8B 4C 24 78 48 39 48 18 75 02 EB 02 EB D6 83 7C 24 70 01 0F 85 F0 00 00 00 48 83 7C 24 50 00 0F 84 8C 00 00 00 48 8B 44 24 50 8B 40 10 FF C8 89 44 24 44 48 8B 44 24 50 8B 4C 24 44 89 48 10 8B 44 24 44 89 44 24 30 83 7C 24 30 00 75 61 48 8B 44 24 50 48 83 78 08 00 74 14 48 8B 44 24 50 48 8B 40 08 48 8B 4C 24 50 48 8B 09 48 89 08 48 8B 44 24 50 48 83 38 00 74 17 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 48 8B 49 08 48 89 48 08 EB 10 48 8B 44 24 50 48 8B 40 08 48 89 05 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? EB 53 33 C0 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 92 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 C7 44 24 30 FF FF FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 4E 01 00 00 48 83 7C 24 50 00 0F 84 A1 00 00 00 48 8B 44 24 50 8B 40 10 FF C0 89 44 24 48 48 8B 44 24 50 8B 4C 24 48 89 48 10 8B 44 24 48 89 44 24 30 48 8B 05 ?? ?? ?? ?? 48 39 44 24 50 74 6C 48 8B 44 24 50 48 83 78 08 00 74 14 48 8B 44 24 50 48 8B 40 08 48 8B 4C 24 50 48 8B 09 48 89 08 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 48 8B 49 08 48 89 48 08 48 8B 44 24 50 48 C7 00 00 00 00 00 48 8B 44 24 50 48 8B 0D ?? ?? ?? ?? 48 89 48 08 48 8B 05 ?? ?? ?? ?? 48 8B 4C 24 50 48 89 08 48 8B 44 24 50 48 89 05 ?? ?? ?? ?? E9 A1 00 00 00 41 B9 AC 00 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 B9 20 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 50 48 83 7C 24 50 00 75 15 C7 44 24 30 FF FF FF FF E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 63 48 8B 44 24 50 48 C7 00 00 00 00 00 48 8B 44 24 50 48 8B 0D ?? ?? ?? ?? 48 89 48 08 48 83 3D ?? ?? ?? ?? 00 74 0F 48 8B 05 ?? ?? ?? ?? 48 8B 4C 24 50 48 89 08 48 8B 44 24 50 C7 40 10 01 00 00 00 C7 44 24 30 01 00 00 00 48 8B 44 24 50 48 8B 4C 24 78 48 89 48 18 48 8B 44 24 50 48 89 05 ?? ?? ?? ?? B9 0F 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 30 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_22_4_0 {
	meta:
		name = "_CrtSetReportHookW2$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_CrtSetReportHook2$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA B9 0F 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_22_5_0 {
	meta:
		name = "__crtMessageWindowW"
		size = 1660
		refs = "0019 __chkstk 0023 __security_cookie 0081 __imp_GetModuleHandleExW 00ba __report_rangecheckfailure 00e8 __imp_GetModuleFileNameW 00f3 ??_C@_1CO@EAEJAADC@?$AA?$DM?$AAp?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?5?$AAn?$AAa?$AAm?$AAe?$AA?5?$AAu?$AAn?$AAk?$AAn?$AAo?$AAw?$AAn?$AA?$DO?$AA?$AA@ 0105 wcscpy_s 011d ??_C@_1EO@JACJHHCK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 0124 ??_C@_1CI@PGJIFDEK@?$AA_?$AA_?$AAc?$AAr?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AAW?$AAi?$AAn?$AAd?$AAo?$AAw?$AAW?$AA?$AA@ 012b ??_C@_1GI@DEDNNLCI@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAE?$AAx?$AAe?$AAN?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA2?$AA6?$AA0?$AA?0?$AA?5?$AAL?$AA?$CC?$AA?$DM?$AAp?$AAr?$AAo?$AAg@ 0132 _invoke_watson_if_error 014f wcslen 01af dotdotdot 01bf memcpy_s 01e5 ??_C@_1NO@LECLLHOL@?$AAm?$AAe?$AAm?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAS?$AAh?$AAo?$AAr?$AAt?$AAP?$AAr?$AAo?$AAg?$AAN?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf@ 0231 _errno 0256 ??_C@_1OG@PMPPFHAF@?$AA?6?$AA?6?$AAF?$AAo?$AAr?$AA?5?$AAi?$AAn?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAo?$AAn?$AA?5?$AAh?$AAo?$AAw?$AA?5?$AAy?$AAo?$AAu?$AAr?$AA?5?$AAp?$AAr@ 0267 ??_C@_11LOCGONAA@?$AA?$AA@ 02d3 ??_C@_1BK@PEDCIPMA@?$AAE?$AAx?$AAp?$AAr?$AAe?$AAs?$AAs?$AAi?$AAo?$AAn?$AA?3?$AA?5?$AA?$AA@ 030c ??_C@_15IABLJNFO@?$AA?6?$AA?6?$AA?$AA@ 0363 ??_C@_1BA@GLLGCPCK@?$AA?6?$AAL?$AAi?$AAn?$AAe?$AA?3?$AA?5?$AA?$AA@ 03ba ??_C@_1BA@LNHECFIM@?$AA?6?$AAF?$AAi?$AAl?$AAe?$AA?3?$AA?5?$AA?$AA@ 043e ??_C@_17LGKOMLJ@?$AA?4?$AA?4?$AA?4?$AA?$AA@ 0469 ??_C@_1BE@CGCJKGHI@?$AA?6?$AAM?$AAo?$AAd?$AAu?$AAl?$AAe?$AA?3?$AA?5?$AA?$AA@ 0491 _CrtDbgModeMsg 0540 ??_C@_1KM@HNMIBKJH@?$AAD?$AAe?$AAb?$AAu?$AAg?$AA?5?$AA?$CF?$AAs?$AA?$CB?$AA?6?$AA?6?$AAP?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?3?$AA?5?$AA?$CF?$AAs?$AA?$CF?$AAs?$AA?$CF?$AAs?$AA?$CF?$AAs?$AA?$CF?$AAs?$AA?$CF?$AAs@ 0558 _snwprintf_s 059e ??_C@_1BI@KALLJECN@?$AA?$CI?$AA?$CK?$AA_?$AAe?$AAr?$AAr?$AAn?$AAo?$AA?$CI?$AA?$CJ?$AA?$CJ?$AA?$AA@ 05b0 _invoke_watson_if_oneof 05cf ??_C@_1FG@BBOLDHGF@?$AA_?$AAC?$AAr?$AAt?$AAD?$AAb?$AAg?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AA?3?$AA?5?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAl?$AAo?$AAn?$AAg?$AA?5?$AAo@ 0607 ??_C@_1JI@EACPGHID@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAL?$AA?$CC?$AA_@ 061b ??_C@_1EK@MBDPDCGA@?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?5?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAL?$AAi?$AAb@ 0628 __crtMessageBoxW 0643 raise 064d _exit 0670 __security_check_cookie"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 B8 48 23 00 00 E8 ?? ?? ?? ?? 48 2B E0 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 30 23 00 00 48 C7 84 24 A0 00 00 00 00 00 00 00 C7 84 24 98 00 00 00 00 00 00 00 48 C7 84 24 B0 00 00 00 00 00 00 00 48 83 BC 24 78 23 00 00 00 75 0A B8 01 00 00 00 E9 FA 05 00 00 4C 8D 84 24 B0 00 00 00 48 8B 94 24 58 23 00 00 B9 06 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 0C 48 C7 84 24 B0 00 00 00 00 00 00 00 B8 02 00 00 00 48 69 C0 04 01 00 00 48 89 84 24 E0 00 00 00 48 81 BC 24 E0 00 00 00 0A 02 00 00 73 02 EB 05 E8 ?? ?? ?? ?? 33 C0 48 8B 8C 24 E0 00 00 00 66 89 84 0C 20 01 00 00 41 B8 04 01 00 00 48 8D 94 24 20 01 00 00 48 8B 8C 24 B0 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 46 4C 8D 05 ?? ?? ?? ?? BA 04 01 00 00 48 8D 8C 24 20 01 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 5F 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8D 84 24 20 01 00 00 48 89 84 24 90 00 00 00 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 83 F8 40 0F 86 93 00 00 00 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 90 00 00 00 48 8D 44 41 80 48 89 84 24 90 00 00 00 48 8D 84 24 20 01 00 00 48 8B 8C 24 90 00 00 00 48 2B C8 48 8B C1 48 D1 F8 B9 04 01 00 00 48 2B C8 48 8B C1 48 D1 E0 41 B9 06 00 00 00 4C 8B 05 ?? ?? ?? ?? 48 8B D0 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 68 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 83 BC 24 70 23 00 00 00 74 35 48 8B 8C 24 70 23 00 00 E8 ?? ?? ?? ?? 48 83 F8 40 76 22 48 8B 8C 24 70 23 00 00 E8 ?? ?? ?? ?? 48 8B 8C 24 70 23 00 00 48 8D 44 41 86 48 89 84 24 A0 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 84 24 A8 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 83 BC 24 50 23 00 00 02 75 11 48 8D 05 ?? ?? ?? ?? 48 89 84 24 D0 00 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 D0 00 00 00 B8 02 00 00 00 48 6B C0 00 48 8B 8C 24 78 23 00 00 0F B7 04 01 85 C0 74 12 48 8B 84 24 78 23 00 00 48 89 84 24 00 01 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 00 01 00 00 B8 02 00 00 00 48 6B C0 00 48 8B 8C 24 78 23 00 00 0F B7 04 01 85 C0 74 1B 83 BC 24 50 23 00 00 02 75 11 48 8D 05 ?? ?? ?? ?? 48 89 84 24 B8 00 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 B8 00 00 00 B8 02 00 00 00 48 6B C0 00 48 8B 8C 24 78 23 00 00 0F B7 04 01 85 C0 74 11 48 8D 05 ?? ?? ?? ?? 48 89 84 24 18 01 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 18 01 00 00 48 83 BC 24 68 23 00 00 00 74 12 48 8B 84 24 68 23 00 00 48 89 84 24 F0 00 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 F0 00 00 00 48 83 BC 24 68 23 00 00 00 74 11 48 8D 05 ?? ?? ?? ?? 48 89 84 24 C0 00 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 C0 00 00 00 48 83 BC 24 60 23 00 00 00 74 12 48 8B 84 24 60 23 00 00 48 89 84 24 C8 00 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 C8 00 00 00 48 83 BC 24 60 23 00 00 00 74 11 48 8D 05 ?? ?? ?? ?? 48 89 84 24 D8 00 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 D8 00 00 00 48 83 BC 24 A0 00 00 00 00 74 12 48 8B 84 24 A0 00 00 00 48 89 84 24 E8 00 00 00 EB 3C 48 83 BC 24 70 23 00 00 00 74 12 48 8B 84 24 70 23 00 00 48 89 84 24 10 01 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 10 01 00 00 48 8B 84 24 10 01 00 00 48 89 84 24 E8 00 00 00 48 83 BC 24 A0 00 00 00 00 74 11 48 8D 05 ?? ?? ?? ?? 48 89 84 24 F8 00 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 F8 00 00 00 48 83 BC 24 70 23 00 00 00 74 11 48 8D 05 ?? ?? ?? ?? 48 89 84 24 08 01 00 00 EB 0F 48 8D 05 ?? ?? ?? ?? 48 89 84 24 08 01 00 00 48 63 84 24 50 23 00 00 48 8D 0D ?? ?? ?? ?? 48 8B 94 24 D0 00 00 00 48 89 94 24 80 00 00 00 48 8B 94 24 00 01 00 00 48 89 54 24 78 48 8B 94 24 B8 00 00 00 48 89 54 24 70 48 8B 94 24 18 01 00 00 48 89 54 24 68 48 8B 94 24 F0 00 00 00 48 89 54 24 60 48 8B 94 24 C0 00 00 00 48 89 54 24 58 48 8B 94 24 C8 00 00 00 48 89 54 24 50 48 8B 94 24 D8 00 00 00 48 89 54 24 48 48 8B 94 24 E8 00 00 00 48 89 54 24 40 48 8B 94 24 F8 00 00 00 48 89 54 24 38 48 8B 94 24 08 01 00 00 48 89 54 24 30 48 8B 94 24 90 00 00 00 48 89 54 24 28 48 8B 04 C1 48 89 44 24 20 4C 8D 0D ?? ?? ?? ?? 41 B8 FF 0F 00 00 BA 00 10 00 00 48 8D 8C 24 30 03 00 00 E8 ?? ?? ?? ?? 89 84 24 98 00 00 00 83 BC 24 98 00 00 00 00 7D 47 E8 ?? ?? ?? ?? 48 C7 44 24 38 00 00 00 00 C7 44 24 30 7F 01 00 00 48 8D 0D ?? ?? ?? ?? 48 89 4C 24 28 48 8D 0D ?? ?? ?? ?? 48 89 4C 24 20 4C 8D 0D ?? ?? ?? ?? 41 B8 22 00 00 00 BA 16 00 00 00 8B 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 8C 24 A8 00 00 00 89 08 83 BC 24 98 00 00 00 00 7D 46 4C 8D 05 ?? ?? ?? ?? BA 00 10 00 00 48 8D 8C 24 30 03 00 00 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 82 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 41 B8 12 20 01 00 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 30 03 00 00 E8 ?? ?? ?? ?? 89 84 24 9C 00 00 00 83 BC 24 9C 00 00 00 03 75 14 B9 16 00 00 00 E8 ?? ?? ?? ?? B9 03 00 00 00 E8 ?? ?? ?? ?? 83 BC 24 9C 00 00 00 04 75 07 B8 01 00 00 00 EB 02 33 C0 48 8B 8C 24 30 23 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 48 23 00 00 C3 }
	condition:
		$1
}

rule file_22_7_0 {
	meta:
		name = "_invoke_watson_if_oneof"
		size = 99
		refs = "0056 _invoke_watson"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 89 54 24 10 89 4C 24 08 48 83 EC 38 83 7C 24 40 00 74 14 8B 44 24 48 39 44 24 40 74 10 8B 44 24 50 39 44 24 40 74 06 8B 44 24 40 EB 27 48 8B 44 24 78 48 89 44 24 20 44 8B 4C 24 70 4C 8B 44 24 68 48 8B 54 24 60 48 8B 4C 24 58 E8 ?? ?? ?? ?? 8B 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_23_3_0 {
	meta:
		name = "_mbslen"
		size = 26
		refs = "0011 _mbslen_l"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_614_2 {
	meta:
		name = "??D?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@QEAAAEBQEAV?$ISource@W4agent_status@Concurrency@@@1@XZ"
		size = 26
		refs = "0011 ?_Get@?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@W4agent_status@Concurrency@@@Concurrency@@@Concurrency@@@Concurrency@@AEBAAEBQEAV?$ISource@W4agent_status@Concurrency@@@2@_K@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_615_2 {
	meta:
		name = "??D?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@QEAAAEBQEAV?$ISource@_K@1@XZ"
		size = 26
		refs = "0011 ?_Get@?$_Source_link_iterator@V?$multi_link_registry@V?$ISource@_K@Concurrency@@@Concurrency@@@Concurrency@@AEBAAEBQEAV?$ISource@_K@2@_K@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_18_889_2 {
	meta:
		name = "?_Reset@?$_Func_class@X$$$V@std@@IEAAXXZ"
		size = 26
		refs = "0011 ?_Set@?$_Func_class@X$$$V@std@@AEAAXPEAV?$_Func_base@X$$$V@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_892_1 {
	meta:
		name = "?_Reset@?$_Func_class@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@IEAAXXZ"
		size = 26
		refs = "0011 ?_Set@?$_Func_class@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@std@@AEAAXPEAV?$_Func_base@XPEAV?$message@W4agent_status@Concurrency@@@Concurrency@@@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_15_894_1 {
	meta:
		name = "?_Reset@?$_Func_class@XPEAV?$message@_K@Concurrency@@@std@@IEAAXXZ"
		size = 26
		refs = "0011 ?_Set@?$_Func_class@XPEAV?$message@_K@Concurrency@@@std@@AEAAXPEAV?$_Func_base@XPEAV?$message@_K@Concurrency@@@2@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_678_109_0 {
	meta:
		name = "?_Wait@_TaskCollection@details@Concurrency@@QEAA?AW4_TaskCollectionStatus@23@XZ"
		size = 26
		refs = "0011 ?_RunAndWait@_TaskCollection@details@Concurrency@@QEAA?AW4_TaskCollectionStatus@23@PEAV_UnrealizedChore@23@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_934_136_0 {
	meta:
		name = "?__ExceptionPtrDestroy@@YAXPEAX@Z"
		size = 26
		refs = "0011 ??_G?$shared_ptr@V__ExceptionPtr@@@std@@QEAAPEAXI@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_55_7_3 {
	meta:
		name = "_Cnd_signal"
		size = 26
		refs = "0011 ?do_signal@@YAHPEAPEAU_Cnd_internal_imp_t@@H@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_92_128_1 {
	meta:
		name = "_Mtx_lock"
		size = 26
		refs = "0011 ?mtx_do_lock@@YAHPEAPEAU_Mtx_internal_imp_t@@PEBUxtime@@@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1358_16_0 {
	meta:
		name = "_cropzeros"
		size = 26
		refs = "0011 _cropzeros_l"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1358_20_0 {
	meta:
		name = "_forcdecpt"
		size = 26
		refs = "0011 _forcdecpt_l"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_813_3_0 {
	meta:
		name = "_mbsnextc"
		size = 26
		refs = "0011 _mbsnextc_l"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_723_3_0 {
	meta:
		name = "_mbsrev"
		size = 26
		refs = "0011 _mbsrev_l"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_242_2_0 {
	meta:
		name = "_mkgmtime32"
		size = 26
		refs = "0011 _make__time32_t"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_270_2_0 {
	meta:
		name = "_mkgmtime64"
		size = 26
		refs = "0011 _make__time64_t"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_635_5_0 {
	meta:
		name = "_wtof"
		size = 26
		refs = "0011 _wtof_l"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1063_6_0 {
	meta:
		name = "atof"
		size = 26
		refs = "0011 _atof_l"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_23_4_0 {
	meta:
		name = "_mbslen_l"
		size = 222
		refs = "0019 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0023 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 0037 strlen 0046 ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 68 48 8B 54 24 78 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8B 40 08 83 78 08 00 75 23 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 28 E9 85 00 00 00 C7 44 24 20 00 00 00 00 EB 17 8B 44 24 20 FF C0 89 44 24 20 48 8B 44 24 70 48 FF C0 48 89 44 24 70 48 8B 44 24 70 0F B6 00 85 C0 74 3F 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8B 40 08 48 8B 4C 24 70 0F B6 09 0F B6 44 08 19 83 E0 04 85 C0 74 1B 48 8B 44 24 70 48 FF C0 48 89 44 24 70 48 8B 44 24 70 0F B6 00 85 C0 75 02 EB 02 EB 9E 48 63 44 24 20 48 89 44 24 30 48 8D 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "roundf"
		size = 142
		refs = "0014 _fd_int 0063 __real@3f800000"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 38 66 BA 01 00 48 8D 4C 24 40 E8 ?? ?? ?? ?? 98 89 44 24 20 83 7C 24 20 00 7E 0B 83 7C 24 20 02 7E 02 EB 02 EB 54 33 D2 48 8D 4C 24 40 E8 ?? ?? ?? ?? 98 85 C0 75 02 EB 41 B8 02 00 00 00 48 6B C0 01 0F B7 44 04 40 25 00 80 00 00 85 C0 74 16 F3 0F 10 44 24 40 F3 0F 5C 05 ?? ?? ?? ?? F3 0F 11 44 24 40 EB 14 F3 0F 10 44 24 40 F3 0F 58 05 ?? ?? ?? ?? F3 0F 11 44 24 40 F3 0F 10 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "__WSTRINGTOLD_L"
		size = 170
		refs = "001b __security_cookie 0067 __wstrgtold12_l 007a _ld12told 00a1 __security_check_cookie"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 68 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 58 48 8B 84 24 90 00 00 00 48 89 44 24 38 C7 44 24 30 00 00 00 00 C7 44 24 28 00 00 00 00 C7 44 24 20 00 00 00 00 44 8B 8C 24 88 00 00 00 4C 8B 84 24 80 00 00 00 48 8B 54 24 78 48 8D 4C 24 48 E8 ?? ?? ?? ?? 89 44 24 40 48 8B 54 24 70 48 8D 4C 24 48 E8 ?? ?? ?? ?? 89 44 24 44 83 7C 24 44 01 75 0B 8B 44 24 40 83 C8 02 89 44 24 40 8B 44 24 40 48 8B 4C 24 58 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_889_0_0 {
	meta:
		name = "__STRINGTOLD_L"
		size = 170
		refs = "001b __security_cookie 0067 __strgtold12_l 007a _ld12told 00a1 __security_check_cookie"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 68 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 58 48 8B 84 24 90 00 00 00 48 89 44 24 38 C7 44 24 30 00 00 00 00 C7 44 24 28 00 00 00 00 C7 44 24 20 00 00 00 00 44 8B 8C 24 88 00 00 00 4C 8B 84 24 80 00 00 00 48 8B 54 24 78 48 8D 4C 24 48 E8 ?? ?? ?? ?? 89 44 24 40 48 8B 54 24 70 48 8D 4C 24 48 E8 ?? ?? ?? ?? 89 44 24 44 83 7C 24 44 01 75 0B 8B 44 24 40 83 C8 02 89 44 24 40 8B 44 24 40 48 8B 4C 24 58 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "__addl"
		size = 87
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 89 4C 24 08 48 83 EC 18 C7 44 24 04 00 00 00 00 8B 44 24 28 8B 4C 24 20 03 C8 8B C1 89 04 24 8B 44 24 20 39 04 24 72 09 8B 44 24 28 39 04 24 73 0A 8B 44 24 04 FF C0 89 44 24 04 48 8B 44 24 30 8B 0C 24 89 08 8B 44 24 04 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_25_2_0 {
	meta:
		name = "__ld12mul"
		size = 1381
		refs = "0014 __security_cookie 02fc __addl 03aa __shl_12 03f8 __shr_12 0559 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 81 EC 98 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 88 00 00 00 33 C0 66 89 44 24 2C C7 44 24 38 00 00 00 00 C7 44 24 78 00 00 00 00 C7 44 24 7C 00 00 00 00 C7 84 24 80 00 00 00 00 00 00 00 48 8B 84 24 A0 00 00 00 0F B7 40 0A 66 89 44 24 28 48 8B 84 24 A8 00 00 00 0F B7 40 0A 66 89 44 24 24 0F B7 44 24 28 0F B7 4C 24 24 33 C1 25 00 80 00 00 66 89 44 24 2C 0F B7 44 24 28 25 FF 7F 00 00 66 89 44 24 28 0F B7 44 24 24 25 FF 7F 00 00 66 89 44 24 24 0F B7 44 24 28 0F B7 4C 24 24 03 C1 66 89 44 24 20 0F B7 44 24 28 3D FF 7F 00 00 7D 18 0F B7 44 24 24 3D FF 7F 00 00 7D 0C 0F B7 44 24 20 3D FD BF 00 00 7E 4C 0F B7 44 24 2C 85 C0 74 0A C7 44 24 4C 00 80 FF FF EB 08 C7 44 24 4C 00 80 FF 7F 48 8B 84 24 A0 00 00 00 8B 4C 24 4C 89 48 08 48 8B 84 24 A0 00 00 00 C7 40 04 00 00 00 00 48 8B 84 24 A0 00 00 00 C7 00 00 00 00 00 E9 29 04 00 00 0F B7 44 24 20 3D BF 3F 00 00 7F 31 48 8B 84 24 A0 00 00 00 C7 40 08 00 00 00 00 48 8B 84 24 A0 00 00 00 C7 40 04 00 00 00 00 48 8B 84 24 A0 00 00 00 C7 00 00 00 00 00 E9 EC 03 00 00 0F B7 44 24 28 85 C0 75 4E 0F B7 44 24 20 66 FF C0 66 89 44 24 20 48 8B 84 24 A0 00 00 00 8B 40 08 0F BA F0 1F 85 C0 75 2E 48 8B 84 24 A0 00 00 00 83 78 04 00 75 20 48 8B 84 24 A0 00 00 00 83 38 00 75 13 33 C0 48 8B 8C 24 A0 00 00 00 66 89 41 0A E9 95 03 00 00 0F B7 44 24 24 85 C0 75 6C 0F B7 44 24 20 66 FF C0 66 89 44 24 20 48 8B 84 24 A8 00 00 00 8B 40 08 0F BA F0 1F 85 C0 75 4C 48 8B 84 24 A8 00 00 00 83 78 04 00 75 3E 48 8B 84 24 A8 00 00 00 83 38 00 75 31 48 8B 84 24 A0 00 00 00 C7 40 08 00 00 00 00 48 8B 84 24 A0 00 00 00 C7 40 04 00 00 00 00 48 8B 84 24 A0 00 00 00 C7 00 00 00 00 00 E9 20 03 00 00 C7 44 24 34 00 00 00 00 C7 44 24 30 00 00 00 00 EB 0A 8B 44 24 30 FF C0 89 44 24 30 83 7C 24 30 05 0F 8D 28 01 00 00 8B 44 24 30 D1 E0 89 44 24 40 C7 44 24 3C 08 00 00 00 B8 05 00 00 00 2B 44 24 30 89 44 24 44 EB 0A 8B 44 24 44 FF C8 89 44 24 44 83 7C 24 44 00 0F 8E E2 00 00 00 48 63 44 24 40 48 8B 8C 24 A0 00 00 00 48 03 C8 48 8B C1 48 89 44 24 70 48 63 44 24 3C 48 8B 8C 24 A8 00 00 00 48 03 C8 48 8B C1 48 89 44 24 68 48 63 44 24 34 48 8D 44 04 78 48 89 44 24 58 48 8B 44 24 70 0F B7 00 48 8B 4C 24 68 0F B7 09 0F AF C1 89 44 24 54 8B 44 24 30 83 E0 01 85 C0 74 26 4C 8D 44 24 60 8B 54 24 54 48 8B 44 24 58 8B 08 E8 ?? ?? ?? ?? 89 44 24 48 48 8B 44 24 58 8B 4C 24 60 89 08 EB 19 4C 8B 44 24 58 8B 54 24 54 48 8B 44 24 58 8B 08 E8 ?? ?? ?? ?? 89 44 24 48 83 7C 24 48 00 74 20 8B 44 24 34 83 C0 04 48 98 0F B7 44 04 78 66 FF C0 8B 4C 24 34 83 C1 04 48 63 C9 66 89 44 0C 78 8B 44 24 40 83 C0 02 89 44 24 40 8B 44 24 3C 83 E8 02 89 44 24 3C E9 09 FF FF FF 8B 44 24 34 83 C0 02 89 44 24 34 E9 C3 FE FF FF 0F B7 44 24 20 2D FE 3F 00 00 66 89 44 24 20 0F BF 44 24 20 85 C0 7E 29 8B 84 24 80 00 00 00 25 00 00 00 80 85 C0 75 19 48 8D 4C 24 78 E8 ?? ?? ?? ?? 0F B7 44 24 20 66 FF C8 66 89 44 24 20 EB CE 0F BF 44 24 20 85 C0 7F 59 0F B7 44 24 20 66 FF C8 66 89 44 24 20 0F BF 44 24 20 85 C0 7D 2F 0F B7 44 24 78 83 E0 01 85 C0 74 0A 8B 44 24 38 FF C0 89 44 24 38 48 8D 4C 24 78 E8 ?? ?? ?? ?? 0F B7 44 24 20 66 FF C0 66 89 44 24 20 EB C8 83 7C 24 38 00 74 0D 0F B7 44 24 78 83 C8 01 66 89 44 24 78 0F B7 44 24 78 3D 00 80 00 00 7F 10 8B 44 24 78 25 FF FF 01 00 3D 00 80 01 00 75 74 83 7C 24 7A FF 75 63 C7 44 24 7A 00 00 00 00 83 7C 24 7E FF 75 48 C7 44 24 7E 00 00 00 00 0F B7 84 24 82 00 00 00 3D FF FF 00 00 75 1C B8 00 80 00 00 66 89 84 24 82 00 00 00 0F B7 44 24 20 66 FF C0 66 89 44 24 20 EB 13 0F B7 84 24 82 00 00 00 66 FF C0 66 89 84 24 82 00 00 00 EB 0A 8B 44 24 7E FF C0 89 44 24 7E EB 0A 8B 44 24 7A FF C0 89 44 24 7A 0F B7 44 24 20 3D FF 7F 00 00 7C 49 0F B7 44 24 2C 85 C0 74 0A C7 44 24 50 00 80 FF FF EB 08 C7 44 24 50 00 80 FF 7F 48 8B 84 24 A0 00 00 00 8B 4C 24 50 89 48 08 48 8B 84 24 A0 00 00 00 C7 40 04 00 00 00 00 48 8B 84 24 A0 00 00 00 C7 00 00 00 00 00 EB 49 48 8B 84 24 A0 00 00 00 0F B7 4C 24 7A 66 89 08 48 8B 84 24 A0 00 00 00 8B 4C 24 7C 89 48 02 48 8B 84 24 A0 00 00 00 8B 8C 24 80 00 00 00 89 48 06 0F B7 44 24 20 0F B7 4C 24 2C 0B C1 48 8B 8C 24 A0 00 00 00 66 89 41 0A 48 8B 8C 24 88 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_25_3_0 {
	meta:
		name = "__multtenpow12"
		size = 292
		refs = "0017 __security_cookie 0026 _pow10pos 0053 _pow10neg 0107 __ld12mul 0119 __security_check_cookie"
	strings:
		$1 = { 44 89 44 24 18 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 58 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 48 48 8D 05 ?? ?? ?? ?? 48 83 E8 60 48 89 44 24 28 83 7C 24 78 00 75 05 E9 D1 00 00 00 83 7C 24 78 00 7D 1A 8B 44 24 78 F7 D8 89 44 24 78 48 8D 05 ?? ?? ?? ?? 48 83 E8 60 48 89 44 24 28 83 BC 24 80 00 00 00 00 75 0A 33 C0 48 8B 4C 24 70 66 89 01 83 7C 24 78 00 0F 84 91 00 00 00 48 8B 44 24 28 48 83 C0 54 48 89 44 24 28 8B 44 24 78 83 E0 07 89 44 24 20 8B 44 24 78 C1 F8 03 89 44 24 78 83 7C 24 20 00 75 02 EB C8 48 63 44 24 20 48 6B C0 0C 48 8B 4C 24 28 48 03 C8 48 8B C1 48 89 44 24 30 48 8B 44 24 30 0F B7 00 3D 00 80 00 00 7C 28 48 8D 44 24 38 48 8B F8 48 8B 74 24 30 B9 0C 00 00 00 F3 A4 8B 44 24 3A FF C8 89 44 24 3A 48 8D 44 24 38 48 89 44 24 30 48 8B 54 24 30 48 8B 4C 24 70 E8 ?? ?? ?? ?? E9 64 FF FF FF 48 8B 4C 24 48 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 58 5F 5E C3 }
	condition:
		$1
}

rule file_25_4_0 {
	meta:
		name = "__shl_12"
		size = 156
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 8B 00 25 00 00 00 80 85 C0 74 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 8B 04 24 89 44 24 08 48 8B 44 24 20 8B 40 04 25 00 00 00 80 85 C0 74 0A C7 44 24 04 01 00 00 00 EB 08 C7 44 24 04 00 00 00 00 8B 44 24 04 89 44 24 0C 48 8B 44 24 20 8B 00 D1 E0 48 8B 4C 24 20 89 01 48 8B 44 24 20 8B 40 04 D1 E0 0B 44 24 08 48 8B 4C 24 20 89 41 04 48 8B 44 24 20 8B 40 08 D1 E0 0B 44 24 0C 48 8B 4C 24 20 89 41 08 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_25_5_0 {
	meta:
		name = "__shr_12"
		size = 153
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 8B 40 08 83 E0 01 85 C0 74 09 C7 04 24 00 00 00 80 EB 07 C7 04 24 00 00 00 00 8B 04 24 89 44 24 08 48 8B 44 24 20 8B 40 04 83 E0 01 85 C0 74 0A C7 44 24 04 00 00 00 80 EB 08 C7 44 24 04 00 00 00 00 8B 44 24 04 89 44 24 0C 48 8B 44 24 20 8B 40 08 D1 E8 48 8B 4C 24 20 89 41 08 48 8B 44 24 20 8B 40 04 D1 E8 0B 44 24 08 48 8B 4C 24 20 89 41 04 48 8B 44 24 20 8B 00 D1 E8 0B 44 24 0C 48 8B 4C 24 20 89 01 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_25_6_0 {
	meta:
		name = "__wstrgtold12_l"
		size = 3587
		refs = "001e __security_cookie 0104 ??_C@_1CA@MBDBOHIB@?$AA_?$AAL?$AAo?$AAc?$AAa?$AAl?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0110 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0125 ??_C@_1FO@OFJNJPKB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAf?$AAp?$AAw?$AA3?$AA2?$AA?2?$AAi?$AAn?$AAc?$AAl?$AAu?$AAd?$AAe?$AA?2@ 012f _CrtDbgReportW 0146 _errno 0169 ??_C@_1CA@JGBKKNCE@?$AA_?$AA_?$AAw?$AAs?$AAt?$AAr?$AAg?$AAt?$AAo?$AAl?$AAd?$AA1?$AA2?$AA_?$AAl?$AA?$AA@ 0175 _invalid_parameter 022a __ImageBase 0231 $LN140 0397 $LN138 039e $LN139 054b $LN136 0552 $LN137 0689 $LN134 0690 $LN135 0afa __mtold12 0b9f __multtenpow12 0ce9 __security_check_cookie 0cf8 $LN119 0cfc $LN108 0d00 $LN97 0d04 $LN88 0d08 $LN75 0d0c $LN61 0d10 $LN58 0d14 $LN43 0d18 $LN49 0d1c $LN36 0d20 $LN120 0d24 $LN28 0d28 $LN99 0d2c $LN101 0d30 $LN100 0d34 $LN98 0d74 $LN77 0d78 $LN78 0d7c $LN76 0dbc $LN63 0dc0 $LN64 0dc4 $LN62"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 08 01 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 F8 00 00 00 48 8D 84 24 D8 00 00 00 48 89 44 24 68 33 C0 66 89 44 24 5C C7 84 24 A8 00 00 00 01 00 00 00 C7 44 24 44 00 00 00 00 C7 44 24 74 00 00 00 00 C7 84 24 A4 00 00 00 00 00 00 00 C7 84 24 98 00 00 00 00 00 00 00 C7 84 24 9C 00 00 00 00 00 00 00 C7 84 24 88 00 00 00 00 00 00 00 C7 44 24 4C 00 00 00 00 C7 44 24 50 00 00 00 00 C7 44 24 60 00 00 00 00 C7 44 24 54 00 00 00 00 33 C0 66 89 44 24 48 33 C0 66 89 44 24 40 C7 44 24 58 00 00 00 00 C7 44 24 34 00 00 00 00 48 83 BC 24 48 01 00 00 00 74 0D C7 84 24 B4 00 00 00 01 00 00 00 EB 0B C7 84 24 B4 00 00 00 00 00 00 00 8B 84 24 B4 00 00 00 89 84 24 B8 00 00 00 83 BC 24 B8 00 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 7E 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 B8 00 00 00 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 7E 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 5D 0B 00 00 48 8B 84 24 20 01 00 00 48 89 44 24 38 48 8B 44 24 38 48 89 84 24 90 00 00 00 EB 0E 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 48 8B 44 24 38 0F B7 00 83 F8 20 74 27 48 8B 44 24 38 0F B7 00 83 F8 09 74 1A 48 8B 44 24 38 0F B7 00 83 F8 0A 74 0D 48 8B 44 24 38 0F B7 00 83 F8 0D 75 02 EB BC 83 7C 24 34 0A 0F 84 1B 08 00 00 48 8B 44 24 38 0F B7 00 66 89 44 24 30 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 8B 44 24 34 89 84 24 B0 00 00 00 83 BC 24 B0 00 00 00 0B 0F 87 E2 07 00 00 48 63 84 24 B0 00 00 00 48 8D 0D ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 0F B7 44 24 30 83 F8 31 7C 25 0F B7 44 24 30 83 F8 39 7F 1B C7 44 24 34 03 00 00 00 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 E9 9C 00 00 00 0F B7 44 24 30 48 8B 8C 24 48 01 00 00 48 8B 09 48 8B 89 F0 00 00 00 48 8B 09 0F BE 09 3B C1 75 0A C7 44 24 34 05 00 00 00 EB 71 0F B7 44 24 30 89 84 24 84 00 00 00 83 BC 24 84 00 00 00 2B 74 20 83 BC 24 84 00 00 00 2D 74 27 83 BC 24 84 00 00 00 30 74 02 EB 2F C7 44 24 34 01 00 00 00 EB 3B C7 44 24 34 02 00 00 00 33 C0 66 89 44 24 5C EB 2A C7 44 24 34 02 00 00 00 B8 00 80 00 00 66 89 44 24 5C EB 16 C7 44 24 34 0A 00 00 00 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 E9 F7 06 00 00 C7 44 24 74 01 00 00 00 0F B7 44 24 30 83 F8 31 7C 25 0F B7 44 24 30 83 F8 39 7F 1B C7 44 24 34 03 00 00 00 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 E9 A8 00 00 00 0F B7 44 24 30 48 8B 8C 24 48 01 00 00 48 8B 09 48 8B 89 F0 00 00 00 48 8B 09 0F BE 09 3B C1 75 0A C7 44 24 34 04 00 00 00 EB 7D 0F B7 44 24 30 89 44 24 78 8B 44 24 78 83 E8 2B 89 44 24 78 83 7C 24 78 3A 77 4C 48 63 44 24 78 48 8D 0D ?? ?? ?? ?? 0F B6 84 01 ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 C7 44 24 34 01 00 00 00 EB 38 C7 44 24 34 06 00 00 00 EB 2E 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 C7 44 24 34 0B 00 00 00 EB 16 C7 44 24 34 0A 00 00 00 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 E9 13 06 00 00 0F B7 44 24 30 83 F8 31 7C 22 0F B7 44 24 30 83 F8 39 7F 18 C7 44 24 34 03 00 00 00 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 EB 62 0F B7 44 24 30 48 8B 8C 24 48 01 00 00 48 8B 09 48 8B 89 F0 00 00 00 48 8B 09 0F BE 09 3B C1 75 0A C7 44 24 34 05 00 00 00 EB 37 0F B7 44 24 30 89 84 24 BC 00 00 00 83 BC 24 BC 00 00 00 30 74 02 EB 0A C7 44 24 34 01 00 00 00 EB 15 C7 44 24 34 0A 00 00 00 48 8B 84 24 90 00 00 00 48 89 44 24 38 E9 80 05 00 00 C7 44 24 74 01 00 00 00 EB 1B 48 8B 44 24 38 0F B7 00 66 89 44 24 30 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 0F B7 44 24 30 83 F8 30 7C 45 0F B7 44 24 30 83 F8 39 7F 3B 83 7C 24 44 19 73 28 8B 44 24 44 FF C0 89 44 24 44 0F B7 44 24 30 83 E8 30 48 8B 4C 24 68 88 01 48 8B 44 24 68 48 FF C0 48 89 44 24 68 EB 0A 8B 44 24 50 FF C0 89 44 24 50 EB 96 0F B7 44 24 30 48 8B 8C 24 48 01 00 00 48 8B 09 48 8B 89 F0 00 00 00 48 8B 09 0F BE 09 3B C1 75 0A C7 44 24 34 04 00 00 00 EB 73 0F B7 44 24 30 89 44 24 7C 8B 44 24 7C 83 E8 2B 89 44 24 7C 83 7C 24 7C 3A 77 42 48 63 44 24 7C 48 8D 0D ?? ?? ?? ?? 0F B6 84 01 ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 C7 44 24 34 06 00 00 00 EB 2E 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 C7 44 24 34 0B 00 00 00 EB 16 C7 44 24 34 0A 00 00 00 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 E9 69 04 00 00 C7 44 24 74 01 00 00 00 C7 84 24 A4 00 00 00 01 00 00 00 83 7C 24 44 00 75 33 EB 1B 48 8B 44 24 38 0F B7 00 66 89 44 24 30 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 0F B7 44 24 30 83 F8 30 75 0C 8B 44 24 50 FF C8 89 44 24 50 EB CF EB 1B 48 8B 44 24 38 0F B7 00 66 89 44 24 30 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 0F B7 44 24 30 83 F8 30 7C 43 0F B7 44 24 30 83 F8 39 7F 39 83 7C 24 44 19 73 30 8B 44 24 44 FF C0 89 44 24 44 0F B7 44 24 30 83 E8 30 48 8B 4C 24 68 88 01 48 8B 44 24 68 48 FF C0 48 89 44 24 68 8B 44 24 50 FF C8 89 44 24 50 EB 98 0F B7 44 24 30 89 84 24 80 00 00 00 8B 84 24 80 00 00 00 83 E8 2B 89 84 24 80 00 00 00 83 BC 24 80 00 00 00 3A 77 45 48 63 84 24 80 00 00 00 48 8D 0D ?? ?? ?? ?? 0F B6 84 01 ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 C7 44 24 34 06 00 00 00 EB 2E 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 C7 44 24 34 0B 00 00 00 EB 16 C7 44 24 34 0A 00 00 00 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 E9 2B 03 00 00 C7 84 24 A4 00 00 00 01 00 00 00 0F B7 44 24 30 83 F8 30 7C 22 0F B7 44 24 30 83 F8 39 7F 18 C7 44 24 34 04 00 00 00 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 EB 15 C7 44 24 34 0A 00 00 00 48 8B 84 24 90 00 00 00 48 89 44 24 38 E9 DA 02 00 00 48 8B 44 24 38 48 83 E8 04 48 89 84 24 90 00 00 00 0F B7 44 24 30 83 F8 31 7C 22 0F B7 44 24 30 83 F8 39 7F 18 C7 44 24 34 09 00 00 00 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 EB 6A 0F B7 44 24 30 89 84 24 A0 00 00 00 83 BC 24 A0 00 00 00 2B 74 35 83 BC 24 A0 00 00 00 2D 74 16 83 BC 24 A0 00 00 00 30 74 02 EB 29 C7 44 24 34 08 00 00 00 EB 34 C7 44 24 34 07 00 00 00 C7 84 24 A8 00 00 00 FF FF FF FF EB 1F C7 44 24 34 07 00 00 00 EB 15 C7 44 24 34 0A 00 00 00 48 8B 84 24 90 00 00 00 48 89 44 24 38 E9 2E 02 00 00 C7 84 24 98 00 00 00 01 00 00 00 EB 1B 48 8B 44 24 38 0F B7 00 66 89 44 24 30 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 0F B7 44 24 30 83 F8 30 75 02 EB D9 0F B7 44 24 30 83 F8 31 7C 22 0F B7 44 24 30 83 F8 39 7F 18 C7 44 24 34 09 00 00 00 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 EB 16 C7 44 24 34 0A 00 00 00 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 E9 B3 01 00 00 0F B7 44 24 30 83 F8 31 7C 22 0F B7 44 24 30 83 F8 39 7F 18 C7 44 24 34 09 00 00 00 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 EB 37 0F B7 44 24 30 89 84 24 C0 00 00 00 83 BC 24 C0 00 00 00 30 74 02 EB 0A C7 44 24 34 08 00 00 00 EB 15 C7 44 24 34 0A 00 00 00 48 8B 84 24 90 00 00 00 48 89 44 24 38 E9 4B 01 00 00 C7 84 24 98 00 00 00 01 00 00 00 C7 44 24 70 00 00 00 00 EB 1B 48 8B 44 24 38 0F B7 00 66 89 44 24 30 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 0F B7 44 24 30 83 F8 30 7C 32 0F B7 44 24 30 83 F8 39 7F 28 6B 44 24 70 0A 0F B7 4C 24 30 8D 44 08 D0 89 44 24 70 81 7C 24 70 50 14 00 00 7E 0A C7 44 24 70 51 14 00 00 EB 02 EB A9 8B 44 24 70 89 44 24 4C EB 1B 48 8B 44 24 38 0F B7 00 66 89 44 24 30 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 0F B7 44 24 30 83 F8 30 7C 0C 0F B7 44 24 30 83 F8 39 7F 02 EB CF C7 44 24 34 0A 00 00 00 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 E9 89 00 00 00 83 BC 24 40 01 00 00 00 74 69 48 8B 44 24 38 48 83 E8 02 48 89 84 24 90 00 00 00 0F B7 44 24 30 89 84 24 AC 00 00 00 83 BC 24 AC 00 00 00 2B 74 21 83 BC 24 AC 00 00 00 2D 74 02 EB 1F C7 44 24 34 07 00 00 00 C7 84 24 A8 00 00 00 FF FF FF FF EB 1F C7 44 24 34 07 00 00 00 EB 15 C7 44 24 34 0A 00 00 00 48 8B 84 24 90 00 00 00 48 89 44 24 38 EB 16 C7 44 24 34 0A 00 00 00 48 8B 44 24 38 48 83 E8 02 48 89 44 24 38 E9 DA F7 FF FF 48 8B 84 24 18 01 00 00 48 8B 4C 24 38 48 89 08 83 7C 24 74 00 0F 84 D3 01 00 00 83 BC 24 9C 00 00 00 00 0F 85 C5 01 00 00 83 BC 24 88 00 00 00 00 0F 85 B7 01 00 00 83 7C 24 44 18 76 58 B8 01 00 00 00 48 6B C0 17 0F BE 84 04 D8 00 00 00 83 F8 05 7C 23 B8 01 00 00 00 48 6B C0 17 0F B6 84 04 D8 00 00 00 FE C0 B9 01 00 00 00 48 6B C9 17 88 84 0C D8 00 00 00 C7 44 24 44 18 00 00 00 48 8B 44 24 68 48 FF C8 48 89 44 24 68 8B 44 24 50 FF C0 89 44 24 50 83 7C 24 44 00 0F 86 2E 01 00 00 48 8B 44 24 68 48 FF C8 48 89 44 24 68 EB 0D 48 8B 44 24 68 48 FF C8 48 89 44 24 68 48 8B 44 24 68 0F BE 00 85 C0 75 16 8B 44 24 44 FF C8 89 44 24 44 8B 44 24 50 FF C0 89 44 24 50 EB D1 4C 8D 84 24 C8 00 00 00 8B 54 24 44 48 8D 8C 24 D8 00 00 00 E8 ?? ?? ?? ?? 83 BC 24 A8 00 00 00 00 7D 0A 8B 44 24 4C F7 D8 89 44 24 4C 8B 44 24 50 8B 4C 24 4C 03 C8 8B C1 89 44 24 4C 83 BC 24 98 00 00 00 00 75 13 8B 84 24 30 01 00 00 8B 4C 24 4C 03 C8 8B C1 89 44 24 4C 83 BC 24 A4 00 00 00 00 75 13 8B 84 24 38 01 00 00 8B 4C 24 4C 2B C8 8B C1 89 44 24 4C 81 7C 24 4C 50 14 00 00 7E 0D C7 84 24 9C 00 00 00 01 00 00 00 EB 60 81 7C 24 4C B0 EB FF FF 7D 0D C7 84 24 88 00 00 00 01 00 00 00 EB 49 44 8B 84 24 28 01 00 00 8B 54 24 4C 48 8D 8C 24 C8 00 00 00 E8 ?? ?? ?? ?? 0F B7 84 24 C8 00 00 00 66 89 44 24 48 8B 84 24 CA 00 00 00 89 44 24 60 8B 84 24 CE 00 00 00 89 44 24 54 0F B7 84 24 D2 00 00 00 66 89 44 24 40 EB 1F 33 C0 66 89 44 24 48 33 C0 66 89 44 24 40 0F B7 44 24 40 89 44 24 54 8B 44 24 54 89 44 24 60 83 7C 24 74 00 75 2C 33 C0 66 89 44 24 48 33 C0 66 89 44 24 40 0F B7 44 24 40 89 44 24 54 8B 44 24 54 89 44 24 60 8B 44 24 58 83 C8 04 89 44 24 58 EB 6C 83 BC 24 9C 00 00 00 00 74 2E B8 FF 7F 00 00 66 89 44 24 40 C7 44 24 54 00 00 00 80 C7 44 24 60 00 00 00 00 33 C0 66 89 44 24 48 8B 44 24 58 83 C8 02 89 44 24 58 EB 34 83 BC 24 88 00 00 00 00 74 2A 33 C0 66 89 44 24 48 33 C0 66 89 44 24 40 0F B7 44 24 40 89 44 24 54 8B 44 24 54 89 44 24 60 8B 44 24 58 83 C8 01 89 44 24 58 48 8B 84 24 10 01 00 00 0F B7 4C 24 48 66 89 08 48 8B 84 24 10 01 00 00 8B 4C 24 60 89 48 02 48 8B 84 24 10 01 00 00 8B 4C 24 54 89 48 06 0F B7 44 24 40 0F B7 4C 24 5C 0B C1 48 8B 8C 24 10 01 00 00 66 89 41 0A 8B 44 24 58 48 8B 8C 24 F8 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 08 01 00 00 C3 0F 1F 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 03 00 03 03 01 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 02 02 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 02 02 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 02 00 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 01 01 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 01 01 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 02 00 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 01 01 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 02 01 01 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "_fgetchar"
		size = 34
		refs = "0005 __iob_func 0019 getc"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 00 48 03 C1 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "_fgetwchar"
		size = 34
		refs = "0005 __iob_func 0019 fgetwc"
	strings:
		$1 = { 48 83 EC 28 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 00 48 03 C1 48 8B C8 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_27_0_0 {
	meta:
		name = "__common_dsinh_cout_rare"
		size = 2096
		refs = "006d _vmldSinhHATab 015a _2il0floatpacket_88"
	strings:
		$1 = { 41 54 48 81 EC E0 00 00 00 33 C0 4C 8B 09 4D 8B C1 49 C1 E8 30 F2 0F 10 11 41 81 E0 F0 7F 00 00 41 C1 E8 04 44 0F 29 7C 24 50 41 81 F8 FF 07 00 00 44 0F 29 74 24 60 44 0F 29 6C 24 70 44 0F 29 A4 24 80 00 00 00 44 0F 29 9C 24 90 00 00 00 44 0F 29 94 24 A0 00 00 00 44 0F 29 8C 24 B0 00 00 00 44 0F 29 84 24 C0 00 00 00 4C 8B 25 ?? ?? ?? ?? 4C 89 8C 24 D0 00 00 00 0F 84 A1 07 00 00 45 85 C0 0F 8E 6C 07 00 00 49 8B C9 48 C1 E9 38 4C 89 4C 24 38 83 E1 7F 88 4C 24 3F 41 81 F8 C9 03 00 00 0F 8E EB 06 00 00 F2 0F 10 44 24 38 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 BC 06 00 00 F2 0F 10 0D ?? ?? ?? ?? 66 0F 2F C8 0F 86 49 05 00 00 66 0F 2F 05 ?? ?? ?? ?? 0F 82 CE 04 00 00 F2 44 0F 10 2D ?? ?? ?? ?? 4C 8D 1D ?? ?? ?? ?? F2 44 0F 59 E8 F2 44 0F 10 25 ?? ?? ?? ?? F2 0F 10 25 ?? ?? ?? ?? 4C 89 64 24 48 49 C1 EC 30 F2 44 0F 58 2D ?? ?? ?? ?? F2 44 0F 11 6C 24 30 41 81 E4 0F 80 FF FF F2 44 0F 10 74 24 30 44 8B 44 24 30 45 8B D0 41 C1 EA 06 41 83 E0 3F 49 C1 E9 38 F2 44 0F 5C 35 ?? ?? ?? ?? F2 45 0F 59 E6 41 8D 8A FF 03 00 00 44 0F 57 35 ?? ?? ?? ?? 41 81 C2 FE 03 00 00 F2 44 0F 59 35 ?? ?? ?? ?? F2 41 0F 5C C4 44 0F 28 C8 0F 28 E8 41 81 E2 FF 07 00 00 F7 D9 41 C1 E2 04 83 C1 FC 45 0B E2 47 8D 14 00 81 E1 FF 07 00 00 66 44 89 64 24 4E 41 81 E4 0F 80 FF FF C1 E1 04 47 8D 44 00 01 44 0B E1 41 80 E1 80 F2 45 0F 58 CE F2 44 0F 11 4C 24 40 F2 44 0F 10 54 24 40 F2 41 0F 5C EA F2 0F 11 6C 24 20 F2 44 0F 10 5C 24 40 F2 44 0F 10 44 24 20 F2 45 0F 58 D8 F2 44 0F 11 5C 24 28 F2 44 0F 10 7C 24 20 F2 45 0F 58 F7 F2 44 0F 10 7C 24 48 F2 44 0F 11 74 24 20 F2 44 0F 10 5C 24 28 66 44 89 64 24 4E 4D 8B E3 F2 41 0F 5C C3 F2 0F 11 44 24 28 F2 44 0F 10 64 24 20 F2 44 0F 10 6C 24 28 F2 45 0F 58 E5 F2 44 0F 11 64 24 28 F2 0F 10 6C 24 40 0F 28 D5 44 0F 28 DD F2 0F 59 D4 0F 28 CD F2 44 0F 59 DD F2 44 0F 10 44 24 28 F2 0F 11 54 24 40 F2 44 0F 10 4C 24 40 F2 43 0F 10 14 C3 4D 8B C3 F2 41 0F 59 D7 F2 44 0F 5C CD F2 44 0F 11 4C 24 20 F2 44 0F 10 0D ?? ?? ?? ?? F2 45 0F 59 CB F2 0F 10 5C 24 40 F2 44 0F 10 54 24 20 F2 41 0F 5C DA F2 44 0F 10 15 ?? ?? ?? ?? F2 45 0F 59 D3 F2 44 0F 58 0D ?? ?? ?? ?? F2 0F 11 5C 24 40 F2 0F 10 44 24 40 F2 45 0F 59 CB F2 0F 5C C8 F2 44 0F 58 15 ?? ?? ?? ?? F2 44 0F 58 0D ?? ?? ?? ?? F2 45 0F 59 D3 F2 45 0F 59 CB F2 44 0F 59 D5 F2 43 0F 10 04 D3 41 F7 DA F2 0F 11 4C 24 20 F2 41 0F 59 C7 F2 44 0F 10 5C 24 48 41 8D 8A 80 00 00 00 41 81 C2 81 00 00 00 44 0F 28 F0 F2 44 0F 10 6C 24 40 F2 41 0F 10 0C CC F2 44 0F 10 64 24 20 F2 41 0F 59 CB F2 43 0F 10 1C D0 F2 44 0F 5C F1 F2 41 0F 59 DB F2 44 0F 11 74 24 40 44 0F 28 D8 F2 44 0F 10 7C 24 40 F2 45 0F 5C DF F2 44 0F 5C D9 F2 44 0F 11 5C 24 20 F2 44 0F 10 5C 24 40 F2 44 0F 10 74 24 20 45 0F 28 FB F2 44 0F 5C F3 F2 44 0F 58 F2 F2 0F 58 D3 F2 45 0F 58 FE F2 44 0F 11 7C 24 40 F2 44 0F 10 7C 24 40 F2 45 0F 5C DF 44 0F 28 F8 F2 44 0F 58 F9 F2 45 0F 58 DE F2 44 0F 11 5C 24 20 F2 44 0F 10 74 24 40 F2 44 0F 10 5C 24 20 F2 44 0F 11 7C 24 40 F2 44 0F 10 7C 24 40 F2 41 0F 5C C7 F2 0F 58 C1 F2 0F 11 44 24 20 F2 0F 10 4C 24 40 F2 0F 10 44 24 20 0F 28 D9 F2 0F 58 D0 F2 0F 58 DA F2 0F 11 5C 24 40 F2 0F 10 44 24 40 F2 0F 5C C8 F2 0F 58 CA F2 0F 11 4C 24 20 F2 0F 10 44 24 40 F2 0F 59 E0 0F 28 C8 F2 0F 10 5C 24 20 F2 0F 11 64 24 40 F2 0F 10 64 24 40 F2 0F 59 EB F2 0F 5C E0 F2 0F 11 64 24 20 F2 44 0F 10 7C 24 40 F2 0F 10 54 24 20 F2 44 0F 5C FA F2 44 0F 11 7C 24 40 45 0F 28 F8 F2 0F 10 64 24 40 F2 44 0F 59 FB F2 0F 5C CC F2 44 0F 59 C0 F2 0F 11 4C 24 20 0F 28 CB F2 41 0F 59 CA F2 44 0F 59 D0 F2 44 0F 58 F9 41 0F 28 CB F2 41 0F 59 C9 F2 45 0F 59 CE F2 44 0F 58 F9 F2 0F 10 54 24 40 41 0F 28 CC F2 0F 10 64 24 20 F2 44 0F 58 FD F2 0F 59 CC F2 41 0F 59 E5 F2 44 0F 59 EA F2 45 0F 58 F8 F2 44 0F 59 E2 F2 45 0F 58 DF 41 0F 28 EA 41 0F 28 D5 F2 41 0F 58 E9 F2 0F 11 6C 24 40 F2 44 0F 10 44 24 40 F2 45 0F 5C D0 F2 45 0F 58 D1 45 0F 28 CE F2 44 0F 11 54 24 20 F2 0F 10 5C 24 40 F2 0F 10 44 24 20 F2 0F 58 D3 F2 44 0F 58 D8 F2 0F 11 54 24 40 F2 44 0F 58 D9 F2 44 0F 58 DC F2 0F 10 64 24 40 F2 44 0F 5C EC F2 45 0F 58 DC F2 44 0F 58 EB F2 44 0F 11 6C 24 20 F2 44 0F 10 54 24 40 F2 0F 10 6C 24 20 F2 45 0F 58 CA F2 44 0F 58 DD F2 44 0F 11 4C 24 40 F2 44 0F 10 44 24 40 F2 45 0F 5C F0 F2 45 0F 58 F2 F2 44 0F 11 74 24 20 F2 44 0F 10 6C 24 40 F2 44 0F 10 64 24 20 F2 45 0F 58 DC F2 45 0F 58 DD F2 44 0F 11 5C 24 38 44 8A 5C 24 3F 41 80 E3 7F 45 0A D9 44 88 5C 24 3F 48 8B 4C 24 38 48 89 0A E9 FD 01 00 00 0F 28 D0 F2 0F 59 D0 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 CA 8A 8C 24 D7 00 00 00 80 E1 80 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 CA F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D0 F2 0F 58 C2 F2 0F 11 44 24 38 44 8A 44 24 3F 41 80 E0 7F 44 0A C1 44 88 44 24 3F 4C 8B 4C 24 38 4C 89 0A E9 90 01 00 00 F2 0F 10 0D ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 10 1D ?? ?? ?? ?? 4C 89 64 24 48 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 30 F2 0F 10 64 24 30 F2 0F 10 0D ?? ?? ?? ?? 8B 4C 24 30 44 8B D1 41 83 E2 3F F2 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D4 47 8D 04 12 F2 0F 59 E3 F2 0F 5C C2 47 8D 5C 12 01 F2 0F 5C C4 F2 0F 59 C8 C1 E9 06 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 C1 FE 03 00 00 81 E1 FF 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 81 F9 FE 07 00 00 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 59 C8 F2 0F 58 C8 F2 43 0F 10 04 C1 F2 0F 59 C8 4D 8B C1 F2 43 0F 58 0C D8 F2 0F 58 C8 77 29 49 C1 EC 30 C1 E1 04 41 81 E4 0F 80 FF FF 44 0B E1 66 44 89 64 24 4E F2 0F 10 44 24 48 F2 0F 59 C8 F2 0F 11 4C 24 38 EB 39 FF C9 81 E1 FF 07 00 00 44 0F B7 44 24 4E C1 E1 04 41 81 E0 0F 80 FF FF 44 0B C1 66 44 89 44 24 4E F2 0F 10 44 24 48 F2 0F 59 C8 F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 38 44 8A 44 24 3F 8A 8C 24 D7 00 00 00 41 80 E0 7F 80 E1 80 44 0A C1 44 88 44 24 3F 4C 8B 4C 24 38 4C 89 0A EB 2F F2 0F 10 05 ?? ?? ?? ?? B8 03 00 00 00 F2 0F 59 C2 F2 0F 11 02 EB 18 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 C2 F2 0F 11 02 44 0F 28 84 24 C0 00 00 00 44 0F 28 8C 24 B0 00 00 00 44 0F 28 94 24 A0 00 00 00 44 0F 28 9C 24 90 00 00 00 44 0F 28 A4 24 80 00 00 00 44 0F 28 6C 24 70 44 0F 28 74 24 60 44 0F 28 7C 24 50 48 81 C4 E0 00 00 00 41 5C C3 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 D0 F2 0F 11 54 24 40 F2 0F 10 4C 24 40 4C 89 64 24 48 F2 0F 58 8C 24 D0 00 00 00 F2 0F 11 0A EB 8B F2 0F 58 D2 F2 0F 11 12 EB 81 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "__remainder_piby2f"
		size = 1202
		refs = "0019 __security_cookie 00df ?pibits@?1??__remainder_piby2f@@9@9 048a ?piby2@?1??__remainder_piby2f@@9@9 04a6 __security_check_cookie"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC C8 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 B0 00 00 00 48 B8 00 00 00 00 00 00 F0 7F 48 8B 8C 24 D0 00 00 00 48 23 C8 48 8B C1 48 C1 E8 34 48 2D FF 03 00 00 89 44 24 40 48 B8 FF FF FF FF FF FF 0F 00 48 8B 8C 24 D0 00 00 00 48 23 C8 48 8B C1 48 B9 00 00 00 00 00 00 10 00 48 0B C1 48 C1 E8 1D 48 89 84 24 D0 00 00 00 48 C7 44 24 20 01 00 00 00 48 8B 44 24 20 48 C1 E0 24 48 FF C8 48 89 44 24 20 8B 44 24 40 99 B9 24 00 00 00 F7 F9 89 44 24 2C 6B 44 24 2C 24 8B 4C 24 40 2B C8 8B C1 89 44 24 18 8B 44 24 2C 83 C0 03 89 44 24 30 B8 08 00 00 00 48 6B C0 04 48 C7 44 04 60 00 00 00 00 48 63 44 24 30 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 0F AF 84 24 D0 00 00 00 48 89 44 24 10 48 8B 44 24 20 48 8B 4C 24 10 48 23 C8 48 8B C1 B9 08 00 00 00 48 6B C9 03 48 89 44 0C 60 48 8B 44 24 10 48 C1 E8 24 48 89 44 24 38 8B 44 24 30 FF C8 48 98 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 0F AF 84 24 D0 00 00 00 48 03 44 24 38 48 89 44 24 10 48 8B 44 24 20 48 8B 4C 24 10 48 23 C8 48 8B C1 B9 08 00 00 00 48 6B C9 02 48 89 44 0C 60 48 8B 44 24 10 48 C1 E8 24 48 89 44 24 38 8B 44 24 30 83 E8 02 48 98 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 0F AF 84 24 D0 00 00 00 48 03 44 24 38 48 89 44 24 10 48 8B 44 24 20 48 8B 4C 24 10 48 23 C8 48 8B C1 B9 08 00 00 00 48 6B C9 01 48 89 44 0C 60 48 8B 44 24 10 48 C1 E8 24 48 89 44 24 38 48 63 44 24 2C 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 0F AF 84 24 D0 00 00 00 48 03 44 24 38 48 89 44 24 10 48 8B 44 24 20 48 8B 4C 24 10 48 23 C8 48 8B C1 B9 08 00 00 00 48 6B C9 00 48 89 44 0C 60 B8 08 00 00 00 48 6B C0 00 48 8B 44 04 60 48 C1 E0 24 B9 08 00 00 00 48 6B C9 01 48 0B 44 0C 60 B9 23 00 00 00 2B 4C 24 18 48 D3 E8 48 83 E0 07 89 44 24 28 8B 44 24 28 83 E0 01 89 44 24 34 C7 44 24 08 01 00 00 00 83 7C 24 34 00 0F 84 A1 00 00 00 8B 44 24 28 D1 F8 FF C0 83 E0 03 48 8B 8C 24 E0 00 00 00 89 01 48 C7 04 24 01 00 00 00 B8 08 00 00 00 48 6B C0 01 48 8B 44 04 60 48 F7 D0 B9 24 00 00 00 2B 4C 24 18 48 8B 14 24 48 D3 E2 48 8B CA 48 FF C9 48 23 C1 48 89 04 24 48 81 3C 24 00 00 01 00 73 2D 8B 44 24 08 FF C0 89 44 24 08 48 8B 04 24 48 C1 E0 24 48 63 4C 24 08 48 8B 4C CC 60 48 F7 D1 48 23 4C 24 20 48 0B C1 48 89 04 24 EB C9 8B 44 24 08 FF C0 48 98 48 8B 44 C4 60 48 F7 D0 48 23 44 24 20 48 89 44 24 48 E9 81 00 00 00 8B 44 24 28 D1 F8 48 8B 8C 24 E0 00 00 00 89 01 48 C7 04 24 01 00 00 00 B8 08 00 00 00 48 6B C0 01 B9 24 00 00 00 2B 4C 24 18 48 8B 14 24 48 D3 E2 48 8B CA 48 FF C9 48 8B 44 04 60 48 23 C1 48 89 04 24 48 81 3C 24 00 00 01 00 73 22 8B 44 24 08 FF C0 89 44 24 08 48 8B 04 24 48 C1 E0 24 48 63 4C 24 08 48 0B 44 CC 60 48 89 04 24 EB D4 8B 44 24 08 FF C0 48 98 48 8B 44 C4 60 48 89 44 24 48 C7 44 24 0C 00 00 00 00 48 B8 00 00 00 00 00 40 00 00 48 39 04 24 73 19 8B 44 24 0C 83 C0 06 89 44 24 0C 48 8B 04 24 48 C1 E0 06 48 89 04 24 EB D7 48 B8 00 00 00 00 00 00 10 00 48 39 04 24 73 17 8B 44 24 0C FF C0 89 44 24 0C 48 8B 04 24 48 D1 E0 48 89 04 24 EB D9 B8 24 00 00 00 2B 44 24 0C 0F B6 C8 48 8B 44 24 48 48 D3 E8 48 8B 0C 24 48 0B C8 48 8B C1 48 89 04 24 8B 44 24 18 83 C0 34 2B 44 24 0C 6B 4C 24 08 24 2B C1 89 44 24 44 48 63 44 24 44 48 05 FF 03 00 00 48 C1 E0 34 48 89 44 24 10 48 B8 FF FF FF FF FF FF 0F 00 48 8B 0C 24 48 23 C8 48 8B C1 48 0B 44 24 10 48 89 84 24 D0 00 00 00 83 7C 24 34 00 74 20 48 B8 00 00 00 00 00 00 00 80 48 8B 8C 24 D0 00 00 00 48 0B C8 48 8B C1 48 89 84 24 D0 00 00 00 48 8B 84 24 D0 00 00 00 48 89 44 24 50 F2 0F 10 44 24 50 F2 0F 11 44 24 58 F2 0F 10 44 24 58 F2 0F 59 05 ?? ?? ?? ?? 48 8B 84 24 D8 00 00 00 F2 0F 11 00 48 8B 8C 24 B0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 C8 00 00 00 C3 }
	condition:
		$1
}

rule file_29_3_0 {
	meta:
		name = "?_wcsupr_s_l_stat@@YAHPEA_W_KPEAUlocaleinfo_struct@@@Z"
		size = 1631
		refs = "004d ??_C@_1BK@HMILBCB@?$AAw?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0059 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006e ??_C@_1FC@FJDINHEA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?2@ 0078 _CrtDbgReportW 008c _errno 00af ??_C@_1CC@GAIHKOIP@?$AA_?$AAw?$AAc?$AAs?$AAu?$AAp?$AAr?$AA_?$AAs?$AA_?$AAl?$AA_?$AAs?$AAt?$AAa?$AAt?$AA?$AA@ 00bb _invalid_parameter 00da wcsnlen 0135 __crtDebugFillThreshold 017f memset 0186 ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 01b9 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 039f __crtLCMapStringW 045f ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 0492 ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 054e _MallocaIsSizeInRange 0564 malloc 0571 _MarkAllocaS 062c wcscpy_s 064f _freea"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC A8 00 00 00 C7 44 24 40 00 00 00 00 48 83 BC 24 B0 00 00 00 00 74 0A C7 44 24 64 01 00 00 00 EB 08 C7 44 24 64 00 00 00 00 8B 44 24 64 89 44 24 5C 83 7C 24 5C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 73 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 5C 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 73 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 8E 05 00 00 48 8B 94 24 B8 00 00 00 48 8B 8C 24 B0 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 84 24 B8 00 00 00 48 39 44 24 48 0F 82 3F 01 00 00 33 C0 48 8B 8C 24 B0 00 00 00 66 89 01 48 83 BC 24 B8 00 00 00 FF 74 75 48 81 BC 24 B8 00 00 00 FF FF FF 7F 74 67 48 83 BC 24 B8 00 00 00 01 76 5C 48 8B 84 24 B8 00 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 11 48 8B 05 ?? ?? ?? ?? 48 89 84 24 90 00 00 00 EB 13 48 8B 84 24 B8 00 00 00 48 FF C8 48 89 84 24 90 00 00 00 48 8B 84 24 90 00 00 00 48 D1 E0 48 8B 8C 24 B0 00 00 00 48 83 C1 02 4C 8B C0 BA FE 00 00 00 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 10 33 C0 85 C0 74 0A C7 44 24 60 01 00 00 00 EB 08 C7 44 24 60 00 00 00 00 8B 44 24 60 89 44 24 58 83 7C 24 58 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 78 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 58 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 78 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 22 04 00 00 48 83 BC 24 B8 00 00 00 FF 0F 84 9C 00 00 00 48 81 BC 24 B8 00 00 00 FF FF FF 7F 0F 84 8A 00 00 00 48 8B 44 24 48 48 FF C0 48 3B 84 24 B8 00 00 00 73 78 48 8B 44 24 48 48 FF C0 48 8B 8C 24 B8 00 00 00 48 2B C8 48 8B C1 48 39 05 ?? ?? ?? ?? 73 11 48 8B 05 ?? ?? ?? ?? 48 89 84 24 80 00 00 00 EB 1E 48 8B 44 24 48 48 FF C0 48 8B 8C 24 B8 00 00 00 48 2B C8 48 8B C1 48 89 84 24 80 00 00 00 48 8B 84 24 80 00 00 00 48 D1 E0 48 8B 8C 24 B0 00 00 00 48 8B 54 24 48 48 8D 4C 51 02 4C 8B C0 BA FE 00 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 C0 00 00 00 48 8B 00 B9 08 00 00 00 48 6B C9 02 48 83 BC 08 28 01 00 00 00 75 5F 48 8B 84 24 B0 00 00 00 48 89 44 24 38 EB 0E 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 48 8B 44 24 38 0F B7 00 85 C0 74 2F 48 8B 44 24 38 0F B7 00 83 F8 61 7C 20 48 8B 44 24 38 0F B7 00 83 F8 7A 7F 13 48 8B 44 24 38 0F B7 00 83 E8 20 48 8B 4C 24 38 66 89 01 EB B7 33 C0 E9 F9 02 00 00 48 8B 84 24 C0 00 00 00 48 8B 00 B9 08 00 00 00 48 6B C9 02 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 FF FF FF FF 4C 8B 84 24 B0 00 00 00 BA 00 02 00 00 48 8B 8C 08 28 01 00 00 E8 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 00 75 17 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 92 02 00 00 48 63 44 24 30 48 39 84 24 B8 00 00 00 0F 83 36 01 00 00 33 C0 48 8B 8C 24 B0 00 00 00 66 89 01 48 83 BC 24 B8 00 00 00 FF 74 6C 48 81 BC 24 B8 00 00 00 FF FF FF 7F 74 5E 48 83 BC 24 B8 00 00 00 01 76 53 48 8B 84 24 B8 00 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 0E 48 8B 05 ?? ?? ?? ?? 48 89 44 24 70 EB 10 48 8B 84 24 B8 00 00 00 48 FF C8 48 89 44 24 70 48 8B 44 24 70 48 D1 E0 48 8B 8C 24 B0 00 00 00 48 83 C1 02 4C 8B C0 BA FE 00 00 00 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 10 33 C0 85 C0 74 0A C7 44 24 50 01 00 00 00 EB 08 C7 44 24 50 00 00 00 00 8B 44 24 50 89 44 24 54 83 7C 24 54 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 97 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 54 00 75 3E E8 ?? ?? ?? ?? C7 00 22 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 97 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 22 00 00 00 E9 49 01 00 00 83 7C 24 30 00 7E 7F 33 C0 85 C0 75 79 48 63 44 24 30 48 89 84 24 98 00 00 00 33 D2 48 C7 C0 E0 FF FF FF 48 8B 8C 24 98 00 00 00 48 F7 F1 48 83 F8 02 72 52 48 63 44 24 30 48 D1 E0 48 8B C8 E8 ?? ?? ?? ?? 85 C0 74 26 48 63 44 24 30 48 8D 44 00 10 48 8B C8 E8 ?? ?? ?? ?? BA DD DD 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 78 EB 09 48 C7 44 24 78 00 00 00 00 48 8B 44 24 78 48 89 84 24 88 00 00 00 EB 0C 48 C7 84 24 88 00 00 00 00 00 00 00 48 8B 84 24 88 00 00 00 48 89 44 24 68 48 83 7C 24 68 00 75 17 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 8B 00 00 00 48 8B 84 24 C0 00 00 00 48 8B 00 B9 08 00 00 00 48 6B C9 02 8B 54 24 30 89 54 24 28 48 8B 54 24 68 48 89 54 24 20 41 B9 FF FF FF FF 4C 8B 84 24 B0 00 00 00 BA 00 02 00 00 48 8B 8C 08 28 01 00 00 E8 ?? ?? ?? ?? 85 C0 74 20 4C 8B 44 24 68 48 8B 94 24 B8 00 00 00 48 8B 8C 24 B0 00 00 00 E8 ?? ?? ?? ?? 89 44 24 40 EB 13 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 44 24 40 2A 00 00 00 48 8B 4C 24 68 E8 ?? ?? ?? ?? 8B 44 24 40 48 81 C4 A8 00 00 00 C3 }
	condition:
		$1
}

rule file_29_4_0 {
	meta:
		name = "_MallocaIsSizeInRange"
		size = 49
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 83 C0 10 48 3B 44 24 20 76 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_29_5_0 {
	meta:
		name = "_MarkAllocaS"
		size = 48
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 7C 24 08 00 74 19 48 8B 44 24 08 8B 4C 24 10 89 08 48 8B 44 24 08 48 83 C0 10 48 89 44 24 08 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_29_6_0 {
	meta:
		name = "_freea"
		size = 67
		refs = "003a free"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 83 7C 24 40 00 74 2D 48 8B 44 24 40 48 83 E8 10 48 89 44 24 40 48 8B 44 24 40 8B 00 89 44 24 20 81 7C 24 20 DD DD 00 00 75 0A 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_29_7_0 {
	meta:
		name = "_wcsupr"
		size = 310
		refs = "000b __locale_changed 0042 ??_C@_1BK@HMILBCB@?$AAw?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0063 ??_C@_1FC@FJDINHEA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?2@ 006d _CrtDbgReportW 0081 _errno 00a4 ??_C@_1BA@LGEDHIDA@?$AA_?$AAw?$AAc?$AAs?$AAu?$AAp?$AAr?$AA?$AA@ 00b0 _invalid_parameter 0128 _wcsupr_s_l"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 83 3D ?? ?? ?? ?? 00 0F 85 02 01 00 00 48 83 7C 24 50 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 40 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 40 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 EB 79 48 8B 44 24 50 48 89 44 24 38 EB 0E 48 8B 44 24 38 48 83 C0 02 48 89 44 24 38 48 8B 44 24 38 0F B7 00 85 C0 74 31 48 8B 44 24 38 0F B7 00 83 F8 61 7C 22 48 8B 44 24 38 0F B7 00 83 F8 7A 7F 15 48 8B 44 24 38 0F B7 00 05 E0 FF 00 00 48 8B 4C 24 38 66 89 01 EB B5 48 8B 44 24 50 EB 1B EB 19 45 33 C0 48 C7 C2 FF FF FF FF 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_29_8_0 {
	meta:
		name = "_wcsupr_l"
		size = 46
		refs = "0020 _wcsupr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 48 C7 C2 FF FF FF FF 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1058_8_0 {
	meta:
		name = "_strlwr_l"
		size = 46
		refs = "0020 _strlwr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 48 C7 C2 FF FF FF FF 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_498_8_0 {
	meta:
		name = "_strupr_l"
		size = 46
		refs = "0020 _strupr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 48 C7 C2 FF FF FF FF 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1184_8_0 {
	meta:
		name = "_wcslwr_l"
		size = 46
		refs = "0020 _wcslwr_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 48 C7 C2 FF FF FF FF 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_29_10_0 {
	meta:
		name = "_wcsupr_s_l"
		size = 85
		refs = "001e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0028 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 003a ?_wcsupr_s_l_stat@@YAHPEA_W_KPEAUlocaleinfo_struct@@@Z 0048 ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 54 24 70 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 68 48 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 20 48 8D 4C 24 28 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_1058_10_0 {
	meta:
		name = "_strlwr_s_l"
		size = 85
		refs = "001e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0028 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 003a ?_strlwr_s_l_stat@@YAHPEAD_KPEAUlocaleinfo_struct@@@Z 0048 ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 54 24 70 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 68 48 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 20 48 8D 4C 24 28 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_498_10_0 {
	meta:
		name = "_strupr_s_l"
		size = 85
		refs = "001e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0028 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 003a ?_strupr_s_l_stat@@YAHPEAD_KPEAUlocaleinfo_struct@@@Z 0048 ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 54 24 70 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 68 48 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 20 48 8D 4C 24 28 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_1184_10_0 {
	meta:
		name = "_wcslwr_s_l"
		size = 85
		refs = "001e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0028 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 003a ?_wcslwr_s_l_stat@@YAHPEA_W_KPEAUlocaleinfo_struct@@@Z 0048 ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 54 24 70 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 54 24 68 48 8B 4C 24 60 E8 ?? ?? ?? ?? 89 44 24 20 48 8D 4C 24 28 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_30_3_0 {
	meta:
		name = "?_CrtMemDumpAllObjectsSince_stat@@YAXPEBU_CrtMemState@@PEAUlocaleinfo_struct@@@Z"
		size = 918
		refs = "001d _lock 0025 ??_C@_0BE@KCIPKCIA@Dumping?5objects?5?9?$DO?6?$AA@ 0031 ??_C@_02DKCKIIND@?$CFs?$AA@ 0045 _CrtDbgReport 0069 _pFirstBlock 00d4 _crtDbgFlag 0106 _CrtIsValidPointer 011d ?__crtIsBadReadPtr@@YAHPEBX_K@Z 0134 ??_C@_0BE@OIEFNFL@?$CDFile?5Error?$CD?$CI?$CFd?$CJ?5?3?5?$AA@ 0173 ??_C@_0L@JMEFFCCJ@?$CFhs?$CI?$CFd?$CJ?5?3?5?$AA@ 01a2 ??_C@_06PKLGBFGM@?$HL?$CFld?$HN?5?$AA@ 020b ??_C@_0DD@GHNAAKBB@client?5block?5at?50x?$CFp?0?5subtype?5?$CFx@ 022e ?_pfnDumpClient@@3P6AXPEAX_K@ZEA 027b _printMemBlockData 02ae ??_C@_0CH@FAGDDGPN@normal?5block?5at?50x?$CFp?0?5?$CFIu?5bytes?5@ 0324 ??_C@_0DA@MDLBNIBM@crt?5block?5at?50x?$CFp?0?5subtype?5?$CFx?0?5?$CF@ 035e _unlock 0365 ??_C@_0BH@GFGKJDCO@Object?5dump?5complete?4?6?$AA@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 C7 44 24 48 00 00 00 00 B9 04 00 00 00 E8 ?? ?? ?? ?? 90 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 83 7C 24 60 00 74 0D 48 8B 44 24 60 48 8B 00 48 89 44 24 48 48 8B 05 ?? ?? ?? ?? 48 89 44 24 40 EB 0D 48 8B 44 24 40 48 8B 00 48 89 44 24 40 48 83 7C 24 40 00 0F 84 CB 02 00 00 48 8B 44 24 48 48 39 44 24 40 0F 84 BB 02 00 00 48 8B 44 24 40 8B 40 1C 25 FF FF 00 00 83 F8 03 74 30 48 8B 44 24 40 8B 40 1C 25 FF FF 00 00 85 C0 74 1F 48 8B 44 24 40 8B 40 1C 25 FF FF 00 00 83 F8 02 75 12 8B 05 ?? ?? ?? ?? 83 E0 10 85 C0 75 05 E9 6F 02 00 00 48 8B 44 24 40 48 83 78 10 00 0F 84 9F 00 00 00 45 33 C0 BA 01 00 00 00 48 8B 44 24 40 48 8B 48 10 E8 ?? ?? ?? ?? 85 C0 74 17 BA 01 00 00 00 48 8B 44 24 40 48 8B 48 10 E8 ?? ?? ?? ?? 85 C0 74 31 48 8B 44 24 40 8B 40 18 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 3D 48 8B 44 24 40 8B 40 18 89 44 24 30 48 8B 44 24 40 48 8B 40 10 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 40 8B 40 28 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 40 8B 40 1C 25 FF FF 00 00 83 F8 04 0F 85 AC 00 00 00 48 8B 44 24 40 8B 40 1C C1 F8 10 25 FF FF 00 00 48 8B 4C 24 40 48 83 C1 30 48 8B 54 24 40 48 8B 52 20 48 89 54 24 38 89 44 24 30 48 89 4C 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 83 3D ?? ?? ?? ?? 00 74 3B 48 8B 44 24 40 48 83 C0 30 48 8B 4C 24 40 48 8B 51 20 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 1D 48 8B 44 24 40 48 83 C0 30 48 8B 4C 24 40 48 8B 51 20 48 8B C8 FF 15 ?? ?? ?? ?? EB 0F 48 8B 54 24 40 48 8B 4C 24 68 E8 ?? ?? ?? ?? E9 CF 00 00 00 48 8B 44 24 40 83 78 1C 01 75 50 48 8B 44 24 40 48 83 C0 30 48 8B 4C 24 40 48 8B 49 20 48 89 4C 24 30 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 54 24 40 48 8B 4C 24 68 E8 ?? ?? ?? ?? EB 74 48 8B 44 24 40 8B 40 1C 25 FF FF 00 00 83 F8 02 75 62 48 8B 44 24 40 8B 40 1C C1 F8 10 25 FF FF 00 00 48 8B 4C 24 40 48 83 C1 30 48 8B 54 24 40 48 8B 52 20 48 89 54 24 38 89 44 24 30 48 89 4C 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 54 24 40 48 8B 4C 24 68 E8 ?? ?? ?? ?? E9 1C FD FF FF B9 04 00 00 00 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_30_4_0 {
	meta:
		name = "?fin$0@?0??_CrtMemDumpAllObjectsSince_stat@@YAXPEBU_CrtMemState@@PEAUlocaleinfo_struct@@@Z@4HA"
		size = 27
		refs = "000f _unlock"
		altNames = "_CrtMemCheckpoint$fin$0 _heap_alloc_dbg_impl$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 40 48 8B EA B9 04 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 40 5D C3 CC }
	condition:
		$1
}

rule file_30_5_0 {
	meta:
		name = "?__crtIsBadReadPtr@@YAHPEBX_K@Z"
		size = 279
		refs = "002f __imp_GetSystemInfo"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 57 48 83 EC 70 C7 44 24 38 00 00 00 00 48 8D 44 24 3C 48 8B F8 33 C0 B9 2C 00 00 00 F3 AA 48 8D 4C 24 38 FF 15 ?? ?? ?? ?? 8B 44 24 3C 89 44 24 24 48 83 BC 24 88 00 00 00 00 0F 84 C5 00 00 00 48 83 BC 24 80 00 00 00 00 75 0A B8 01 00 00 00 E9 B2 00 00 00 48 8B 84 24 80 00 00 00 48 89 44 24 28 48 8B 44 24 28 48 8B 8C 24 88 00 00 00 48 8D 44 08 FF 48 89 44 24 30 48 8B 44 24 28 48 39 44 24 30 73 09 B8 01 00 00 00 EB 7B EB 77 48 8B 44 24 28 0F B6 00 88 44 24 20 8B 44 24 24 FF C8 F7 D0 48 98 48 8B 4C 24 28 48 23 C8 48 8B C1 48 89 44 24 28 8B 44 24 24 FF C8 F7 D0 48 98 48 8B 4C 24 30 48 23 C8 48 8B C1 48 89 44 24 30 48 8B 44 24 30 48 39 44 24 28 74 22 8B 44 24 24 48 8B 4C 24 28 48 03 C8 48 8B C1 48 89 44 24 28 48 8B 44 24 28 0F B6 00 88 44 24 21 EB D2 EB 07 B8 01 00 00 00 EB 02 33 C0 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_30_6_0 {
	meta:
		name = "?filt$0@?0??__crtIsBadReadPtr@@YAHPEBX_K@Z@4HA"
		size = 21
		altNames = "?filt$0@?0??_inconsistency@@YAXXZ@4HA ?filt$0@?0??terminate@@YAXXZ@4HA __BuildCatchObject$filt$0 __BuildCatchObjectHelper$filt$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B8 01 00 00 00 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_30_7_0 {
	meta:
		name = "CheckBytes"
		size = 107
	strings:
		$1 = { 4C 89 44 24 18 88 54 24 10 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 30 48 89 44 24 08 48 8B 44 24 30 48 FF C8 48 89 44 24 30 48 83 7C 24 08 00 74 30 48 8B 44 24 20 0F B6 00 89 44 24 04 0F B6 44 24 28 89 04 24 48 8B 44 24 20 48 FF C0 48 89 44 24 20 8B 04 24 39 44 24 04 74 04 33 C0 EB 07 EB B1 B8 01 00 00 00 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_30_8_0 {
	meta:
		name = "_CrtCheckMemory"
		size = 1431
		refs = "000e _crtDbgFlag 0029 _lock 002f _heapchk 007d ??_C@_0CE@MKKHMBMK@_heapchk?5fails?5with?5_HEAPBADBEGI@ 0089 ??_C@_02DKCKIIND@?$CFs?$AA@ 009d _CrtDbgReport 00b1 ??_C@_0CD@CPKEAPBD@_heapchk?5fails?5with?5_HEAPBADNODE@ 00e5 ??_C@_0CC@MJGLGBDG@_heapchk?5fails?5with?5_HEAPBADEND?4@ 0116 ??_C@_0CC@MFFCHFHO@_heapchk?5fails?5with?5_HEAPBADPTR?4@ 0147 ??_C@_0CL@HNNNMKMJ@_heapchk?5fails?5with?5unknown?5retu@ 0183 _pFirstBlock 01fb szBlockUseName 020d ??_C@_07OHKEFPKJ@DAMAGED?$AA@ 0228 _bNoMansLandFill 0230 CheckBytes 0289 ??_C@_0KI@JGFOHMEB@HEAP?5CORRUPTION?5DETECTED?3?5before@ 02d2 ??_C@_0IK@PJCGLBOB@HEAP?5CORRUPTION?5DETECTED?3?5before@ 0377 ??_C@_0KE@MBMNHHHN@HEAP?5CORRUPTION?5DETECTED?3?5after?5@ 03c0 ??_C@_0IG@LEMBDCJK@HEAP?5CORRUPTION?5DETECTED?3?5after?5@ 040c _bDeadLandFill 0457 ??_C@_0KA@IHNJJKPL@HEAP?5CORRUPTION?5DETECTED?3?5on?5top@ 048a ??_C@_0IC@BBJIOOJH@HEAP?5CORRUPTION?5DETECTED?3?5on?5top@ 050c ??_C@_0EG@DGJMPDBH@?$CFhs?5located?5at?50x?$CFp?5is?5?$CFIu?5bytes@ 0557 ??_C@_0CI@JMLBEDHJ@?$CFhs?5located?5at?50x?$CFp?5is?5?$CFIu?5bytes@ 058a _unlock"
	strings:
		$1 = { 48 83 EC 78 C7 44 24 5C 01 00 00 00 8B 05 ?? ?? ?? ?? 83 E0 01 85 C0 75 0A B8 01 00 00 00 E9 6F 05 00 00 B9 04 00 00 00 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 89 44 24 58 83 7C 24 58 FF 0F 84 3E 01 00 00 83 7C 24 58 FE 0F 84 33 01 00 00 8B 44 24 58 89 44 24 50 83 7C 24 50 FA 0F 84 B3 00 00 00 83 7C 24 50 FB 74 7B 83 7C 24 50 FC 74 40 83 7C 24 50 FD 74 05 E9 CA 00 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 E9 C5 00 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 E9 91 00 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 60 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 2F 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 C7 44 24 5C 00 00 00 00 E9 04 04 00 00 48 8B 05 ?? ?? ?? ?? 48 89 44 24 60 EB 0D 48 8B 44 24 60 48 8B 00 48 89 44 24 60 48 83 7C 24 60 00 0F 84 DD 03 00 00 C7 44 24 54 01 00 00 00 48 8B 44 24 60 8B 40 1C 25 FF FF 00 00 83 F8 04 74 28 48 8B 44 24 60 83 78 1C 01 74 1D 48 8B 44 24 60 8B 40 1C 25 FF FF 00 00 83 F8 02 74 0B 48 8B 44 24 60 83 78 1C 03 75 21 48 8B 44 24 60 8B 40 1C 25 FF FF 00 00 48 98 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 89 44 24 68 EB 0C 48 8D 05 ?? ?? ?? ?? 48 89 44 24 68 48 8B 44 24 60 48 83 C0 2C 41 B8 04 00 00 00 0F B6 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 BE 00 00 00 48 8B 44 24 60 48 83 78 10 00 74 63 48 8B 44 24 60 48 83 C0 30 48 8B 4C 24 60 8B 49 18 89 4C 24 48 48 8B 4C 24 60 48 8B 49 10 48 89 4C 24 40 48 89 44 24 38 48 8B 44 24 60 8B 40 28 89 44 24 30 48 8B 44 24 68 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 47 48 8B 44 24 60 48 83 C0 30 48 89 44 24 38 48 8B 44 24 60 8B 40 28 89 44 24 30 48 8B 44 24 68 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 C7 44 24 54 00 00 00 00 48 8B 44 24 60 48 8B 40 20 48 8B 4C 24 60 48 8D 44 01 30 41 B8 04 00 00 00 0F B6 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 BE 00 00 00 48 8B 44 24 60 48 83 78 10 00 74 63 48 8B 44 24 60 48 83 C0 30 48 8B 4C 24 60 8B 49 18 89 4C 24 48 48 8B 4C 24 60 48 8B 49 10 48 89 4C 24 40 48 89 44 24 38 48 8B 44 24 60 8B 40 28 89 44 24 30 48 8B 44 24 68 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 47 48 8B 44 24 60 48 83 C0 30 48 89 44 24 38 48 8B 44 24 60 8B 40 28 89 44 24 30 48 8B 44 24 68 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 C7 44 24 54 00 00 00 00 48 8B 44 24 60 83 78 1C 00 0F 85 BB 00 00 00 48 8B 44 24 60 48 83 C0 30 48 8B 4C 24 60 4C 8B 41 20 0F B6 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 92 00 00 00 48 8B 44 24 60 48 83 78 10 00 74 4D 48 8B 44 24 60 48 83 C0 30 48 8B 4C 24 60 8B 49 18 89 4C 24 38 48 8B 4C 24 60 48 8B 49 10 48 89 4C 24 30 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 31 48 8B 44 24 60 48 83 C0 30 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 C7 44 24 54 00 00 00 00 83 7C 24 54 00 0F 85 C2 00 00 00 48 8B 44 24 60 48 83 78 10 00 74 65 48 8B 44 24 60 48 83 C0 30 48 8B 4C 24 60 8B 49 18 89 4C 24 48 48 8B 4C 24 60 48 8B 49 10 48 89 4C 24 40 48 8B 4C 24 60 48 8B 49 20 48 89 4C 24 38 48 89 44 24 30 48 8B 44 24 68 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 49 48 8B 44 24 60 48 83 C0 30 48 8B 4C 24 60 48 8B 49 20 48 89 4C 24 38 48 89 44 24 30 48 8B 44 24 68 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 C7 44 24 5C 00 00 00 00 E9 0A FC FF FF B9 04 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 5C 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_30_9_0 {
	meta:
		name = "_CrtCheckMemory$fin$0"
		size = 27
		refs = "000f _unlock"
	strings:
		$1 = { 40 55 48 83 EC 50 48 8B EA B9 04 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 50 5D C3 CC }
	condition:
		$1
}

rule file_30_10_0 {
	meta:
		name = "_CrtDoForAllClientObjects"
		size = 291
		refs = "003a ??_C@_1BI@CJGCEEDL@?$AAp?$AAf?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0046 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 005b ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 0065 _CrtDbgReportW 0079 _errno 009c ??_C@_1DE@GJCKCKEC@?$AA_?$AAC?$AAr?$AAt?$AAD?$AAo?$AAF?$AAo?$AAr?$AAA?$AAl?$AAl?$AAC?$AAl?$AAi?$AAe?$AAn?$AAt?$AAO?$AAb?$AAj?$AAe?$AAc?$AAt?$AAs?$AA?$AA@ 00a8 _invalid_parameter 00b0 _crtDbgFlag 00c3 _lock 00cb _pFirstBlock 011a _unlock"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 50 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 AB 07 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 36 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 AB 07 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 70 8B 05 ?? ?? ?? ?? 83 E0 01 85 C0 75 02 EB 61 B9 04 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 05 ?? ?? ?? ?? 48 89 44 24 38 EB 0D 48 8B 44 24 38 48 8B 00 48 89 44 24 38 48 83 7C 24 38 00 74 29 48 8B 44 24 38 8B 40 1C 25 FF FF 00 00 83 F8 04 75 15 48 8B 44 24 38 48 83 C0 30 48 8B 54 24 58 48 8B C8 FF 54 24 50 EB C2 B9 04 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_11_0 {
	meta:
		name = "_CrtDoForAllClientObjects$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "?fin$0@?0???3@YAXPEAX@Z@4HA _CrtSetDbgBlockType$fin$0 _CrtSetDbgFlag$fin$0 _expand_dbg$fin$0 _msize_dbg$fin$0 _realloc_dbg$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA B9 04 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_30_12_0 {
	meta:
		name = "_CrtDumpMemoryLeaks"
		size = 186
		refs = "000a __security_cookie 001f _CrtMemCheckpoint 0047 _crtDbgFlag 0066 ??_C@_0BI@JBFPOEJA@Detected?5memory?5leaks?$CB?6?$AA@ 0072 ??_C@_02DKCKIIND@?$CFs?$AA@ 0086 _CrtDbgReport 0095 _CrtMemDumpAllObjectsSince 00ae __security_check_cookie"
	strings:
		$1 = { 48 81 EC B8 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 A0 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? B8 08 00 00 00 48 6B C0 04 48 83 7C 04 38 00 75 2F B8 08 00 00 00 48 6B C0 01 48 83 7C 04 38 00 75 1E 8B 05 ?? ?? ?? ?? 83 E0 10 85 C0 74 4E B8 08 00 00 00 48 6B C0 02 48 83 7C 04 38 00 74 3D 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C9 E8 ?? ?? ?? ?? B8 01 00 00 00 EB 02 33 C0 48 8B 8C 24 A0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 B8 00 00 00 C3 }
	condition:
		$1
}

rule file_30_16_0 {
	meta:
		name = "_CrtIsMemoryBlock"
		size = 369
		refs = "0068 _CrtIsValidHeapPointer 007d _lock 00de _CrtIsValidPointer 00fc _lRequestCurr 0164 _unlock"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 00 00 00 00 C7 44 24 20 00 00 00 00 48 83 7C 24 50 00 74 0B 48 8B 44 24 50 C7 00 00 00 00 00 48 83 7C 24 58 00 74 0C 48 8B 44 24 58 48 C7 00 00 00 00 00 48 83 7C 24 60 00 74 0B 48 8B 44 24 60 C7 00 00 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 F5 00 00 00 B9 04 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 44 24 40 48 83 E8 30 48 89 44 24 28 48 8B 44 24 28 8B 40 1C 25 FF FF 00 00 83 F8 04 74 2C 48 8B 44 24 28 83 78 1C 01 74 21 48 8B 44 24 28 8B 40 1C 25 FF FF 00 00 83 F8 02 74 0F 48 8B 44 24 28 83 78 1C 03 0F 85 88 00 00 00 41 B8 01 00 00 00 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 85 C0 74 70 8B 44 24 48 48 8B 4C 24 28 48 39 41 20 75 61 48 8B 44 24 28 8B 0D ?? ?? ?? ?? 39 48 28 7F 51 48 83 7C 24 50 00 74 0F 48 8B 44 24 50 48 8B 4C 24 28 8B 49 28 89 08 48 83 7C 24 58 00 74 11 48 8B 44 24 58 48 8B 4C 24 28 48 8B 49 10 48 89 08 48 83 7C 24 60 00 74 0F 48 8B 44 24 60 48 8B 4C 24 28 8B 49 18 89 08 C7 44 24 20 01 00 00 00 EB 08 C7 44 24 20 00 00 00 00 B9 04 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_30_17_0 {
	meta:
		name = "_CrtIsMemoryBlock$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_free_dbg$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 04 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_30_18_0 {
	meta:
		name = "_CrtIsValidHeapPointer"
		size = 86
		refs = "002a _CrtIsValidPointer 0047 _crtheap 004d __imp_HeapValidate"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 83 7C 24 30 00 75 04 33 C0 EB 3C 48 8B 44 24 30 48 83 E8 30 45 33 C0 BA 30 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 1B 48 8B 44 24 30 48 83 E8 30 4C 8B C0 33 D2 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_19_0 {
	meta:
		name = "_CrtIsValidPointer"
		size = 50
	strings:
		$1 = { 44 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 18 48 83 7C 24 20 00 74 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_30_20_0 {
	meta:
		name = "_CrtMemCheckpoint"
		size = 646
		refs = "0035 ??_C@_1BM@MIMANDHC@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0041 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0056 ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 0060 _CrtDbgReportW 0074 _errno 0097 ??_C@_1CE@NJJKELF@?$AA_?$AAC?$AAr?$AAt?$AAM?$AAe?$AAm?$AAC?$AAh?$AAe?$AAc?$AAk?$AAp?$AAo?$AAi?$AAn?$AAt?$AA?$AA@ 00a3 _invalid_parameter 00b2 _lock 00bf _pFirstBlock 0203 ??_C@_0DP@LEFMFBOD@Bad?5memory?5block?5found?5at?50x?$CFp?4?6@ 0217 _CrtDbgReport 0232 ??_C@_0CB@EAAIGELO@Bad?5memory?5block?5found?5at?50x?$CFp?4?6@ 025f _lMaxAlloc 026f _lTotalAlloc 027d _unlock"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 68 48 83 7C 24 70 00 74 0A C7 44 24 44 01 00 00 00 EB 08 C7 44 24 44 00 00 00 00 8B 44 24 44 89 44 24 48 83 7C 24 48 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 AB 08 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 48 00 75 39 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 AB 08 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 D5 01 00 00 B9 04 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 44 24 70 48 8B 0D ?? ?? ?? ?? 48 89 08 C7 44 24 40 00 00 00 00 EB 0A 8B 44 24 40 FF C0 89 44 24 40 83 7C 24 40 05 7D 28 48 63 44 24 40 48 8B 4C 24 70 48 C7 44 C1 30 00 00 00 00 48 63 44 24 40 48 8B 4C 24 70 48 C7 44 C1 08 00 00 00 00 EB C7 48 8B 05 ?? ?? ?? ?? 48 89 44 24 50 EB 0D 48 8B 44 24 50 48 8B 00 48 89 44 24 50 48 83 7C 24 50 00 0F 84 27 01 00 00 48 8B 44 24 50 8B 40 1C 25 FF FF 00 00 85 C0 0F 8C 8B 00 00 00 48 8B 44 24 50 8B 40 1C 25 FF FF 00 00 83 F8 05 7D 79 48 8B 44 24 50 8B 40 1C 25 FF FF 00 00 48 98 48 8B 4C 24 70 48 8B 44 C1 08 48 FF C0 48 8B 4C 24 50 8B 49 1C 81 E1 FF FF 00 00 48 63 C9 48 8B 54 24 70 48 89 44 CA 08 48 8B 44 24 50 8B 40 1C 25 FF FF 00 00 48 98 48 8B 4C 24 70 48 8B 44 C1 30 48 8B 4C 24 50 48 03 41 20 48 8B 4C 24 50 8B 49 1C 81 E1 FF FF 00 00 48 63 C9 48 8B 54 24 70 48 89 44 CA 30 E9 82 00 00 00 48 8B 44 24 50 48 83 78 10 00 74 49 48 8B 44 24 50 8B 40 18 89 44 24 38 48 8B 44 24 50 48 8B 40 10 48 89 44 24 30 48 8B 44 24 50 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 2D 48 8B 44 24 50 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 E9 C0 FE FF FF 48 8B 44 24 70 48 8B 0D ?? ?? ?? ?? 48 89 48 58 48 8B 44 24 70 48 8B 0D ?? ?? ?? ?? 48 89 48 60 B9 04 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_30_22_0 {
	meta:
		name = "_CrtMemDifference"
		size = 813
		refs = "0047 ??_C@_1BM@MIMANDHC@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0053 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0068 ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 0072 _CrtDbgReportW 0086 _errno 00a9 ??_C@_1CE@PDIENACM@?$AA_?$AAC?$AAr?$AAt?$AAM?$AAe?$AAm?$AAD?$AAi?$AAf?$AAf?$AAe?$AAr?$AAe?$AAn?$AAc?$AAe?$AA?$AA@ 00b5 _invalid_parameter 00ec ??_C@_1CC@DHPFEMMN@?$AAo?$AAl?$AAd?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0191 ??_C@_1CC@DFPEDFBP@?$AAn?$AAe?$AAw?$AAS?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 02c4 _crtDbgFlag"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 C7 44 24 4C 00 00 00 00 48 83 7C 24 60 00 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 F2 08 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 F2 08 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 68 02 00 00 48 83 7C 24 68 00 74 0A C7 44 24 3C 01 00 00 00 EB 08 C7 44 24 3C 00 00 00 00 8B 44 24 3C 89 44 24 40 83 7C 24 40 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 F3 08 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 40 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 F3 08 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 C3 01 00 00 48 83 7C 24 70 00 74 0A C7 44 24 44 01 00 00 00 EB 08 C7 44 24 44 00 00 00 00 8B 44 24 44 89 44 24 48 83 7C 24 48 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 F4 08 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 48 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 F4 08 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 1E 01 00 00 C7 44 24 30 00 00 00 00 EB 0A 8B 44 24 30 FF C0 89 44 24 30 83 7C 24 30 05 0F 8D B3 00 00 00 48 63 44 24 30 48 63 4C 24 30 48 8B 54 24 70 4C 8B 44 24 68 49 8B 4C C8 30 48 8B 44 C2 30 48 2B C1 48 63 4C 24 30 48 8B 54 24 60 48 89 44 CA 30 48 63 44 24 30 48 63 4C 24 30 48 8B 54 24 70 4C 8B 44 24 68 49 8B 4C C8 08 48 8B 44 C2 08 48 2B C1 48 63 4C 24 30 48 8B 54 24 60 48 89 44 CA 08 48 63 44 24 30 48 8B 4C 24 60 48 83 7C C1 30 00 75 12 48 63 44 24 30 48 8B 4C 24 60 48 83 7C C1 08 00 74 2A 83 7C 24 30 00 74 23 83 7C 24 30 02 75 14 83 7C 24 30 02 75 15 8B 05 ?? ?? ?? ?? 83 E0 10 85 C0 74 08 C7 44 24 4C 01 00 00 00 E9 38 FF FF FF 48 8B 44 24 70 48 8B 4C 24 68 48 8B 49 58 48 8B 40 58 48 2B C1 48 8B 4C 24 60 48 89 41 58 48 8B 44 24 70 48 8B 4C 24 68 48 8B 49 60 48 8B 40 60 48 2B C1 48 8B 4C 24 60 48 89 41 60 48 8B 44 24 60 48 C7 00 00 00 00 00 8B 44 24 4C 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_30_23_0 {
	meta:
		name = "_CrtMemDumpAllObjectsSince"
		size = 71
		refs = "001d ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0027 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 0034 ?_CrtMemDumpAllObjectsSince_stat@@YAXPEBU_CrtMemState@@PEAUlocaleinfo_struct@@@Z 003e ??1_LocaleUpdate@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 58 48 C7 44 24 20 00 00 00 00 48 8B 54 24 20 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 8D 4C 24 28 E8 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_30_24_0 {
	meta:
		name = "_CrtMemDumpStatistics"
		size = 400
		refs = "0035 ??_C@_1BM@MIMANDHC@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0041 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0056 ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 0060 _CrtDbgReportW 0074 _errno 0097 ??_C@_1CM@MPNIBKGK@?$AA_?$AAC?$AAr?$AAt?$AAM?$AAe?$AAm?$AAD?$AAu?$AAm?$AAp?$AAS?$AAt?$AAa?$AAt?$AAi?$AAs?$AAt?$AAi?$AAc?$AAs?$AA?$AA@ 00a3 _invalid_parameter 00cf szBlockUseName 0107 ??_C@_0BO@DACNIABB@?$CFId?5bytes?5in?5?$CFId?5?$CFhs?5Blocks?4?6?$AA@ 011b _CrtDbgReport 013a ??_C@_0CB@BLHDAFNE@Largest?5number?5used?3?5?$CFId?5bytes?4?6@ 016b ??_C@_0BP@DEDHGGGI@Total?5allocations?3?5?$CFId?5bytes?4?6?$AA@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 58 48 83 7C 24 60 00 74 0A C7 44 24 44 01 00 00 00 EB 08 C7 44 24 44 00 00 00 00 8B 44 24 44 89 44 24 48 83 7C 24 48 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 1A 0A 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 48 00 75 39 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 1A 0A 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 DF 00 00 00 C7 44 24 40 00 00 00 00 EB 0A 8B 44 24 40 FF C0 89 44 24 40 83 7C 24 40 05 7D 62 48 63 44 24 40 48 8D 0D ?? ?? ?? ?? 48 63 54 24 40 4C 63 44 24 40 48 8B 04 C1 48 89 44 24 38 48 8B 44 24 60 48 8B 44 D0 08 48 89 44 24 30 48 8B 44 24 60 4A 8B 44 C0 30 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 8D 48 8B 44 24 60 48 8B 40 58 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 60 48 8B 40 60 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_30_25_0 {
	meta:
		name = "_CrtReportBlockType"
		size = 57
		refs = "000f _CrtIsValidHeapPointer"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? 85 C0 75 07 B8 FF FF FF FF EB 16 48 8B 44 24 40 48 83 E8 30 48 89 44 24 20 48 8B 44 24 20 8B 40 1C 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_30_26_0 {
	meta:
		name = "_CrtSetAllocHook"
		size = 41
		refs = "000c _pfnAllocHook"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 05 ?? ?? ?? ?? 48 89 04 24 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_30_33_0 {
	meta:
		name = "_CrtSetDebugFillThreshold"
		size = 41
		refs = "000c __crtDebugFillThreshold"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 05 ?? ?? ?? ?? 48 89 04 24 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_30_34_0 {
	meta:
		name = "_CrtSetDumpClient"
		size = 41
		refs = "000c ?_pfnDumpClient@@3P6AXPEAX_K@ZEA"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 05 ?? ?? ?? ?? 48 89 04 24 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1166_3_0 {
	meta:
		name = "_CrtSetReportHook"
		size = 41
		refs = "000c _pfnReportHook"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 05 ?? ?? ?? ?? 48 89 04 24 48 8B 44 24 20 48 89 05 ?? ?? ?? ?? 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_30_27_0 {
	meta:
		name = "_CrtSetBreakAlloc"
		size = 35
		refs = "000a _crtBreakAlloc"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 18 8B 05 ?? ?? ?? ?? 89 04 24 8B 44 24 20 89 05 ?? ?? ?? ?? 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_1313_1_0 {
	meta:
		name = "__setfflag"
		size = 35
		refs = "000a __fastflag"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 18 8B 05 ?? ?? ?? ?? 89 04 24 8B 44 24 20 89 05 ?? ?? ?? ?? 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_627_4_0 {
	meta:
		name = "_set_malloc_crt_max_wait"
		size = 35
		refs = "000a _maxwait"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 18 8B 05 ?? ?? ?? ?? 89 04 24 8B 44 24 20 89 05 ?? ?? ?? ?? 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_30_28_0 {
	meta:
		name = "_CrtSetCheckCount"
		size = 25
		refs = "000a __crtDebugCheckCount"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 18 8B 05 ?? ?? ?? ?? 89 04 24 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_30_29_0 {
	meta:
		name = "_CrtSetDbgBlockType"
		size = 199
		refs = "0013 _lock 001e _CrtIsValidHeapPointer 0075 ??_C@_1EO@LHDAJOCM@?$AA_?$AAB?$AAL?$AAO?$AAC?$AAK?$AA_?$AAT?$AAY?$AAP?$AAE?$AA_?$AAI?$AAS?$AA_?$AAV?$AAA?$AAL?$AAI?$AAD?$AA?$CI?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?9?$AA?$DO?$AAn?$AAB?$AAl?$AAo@ 0081 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0096 ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 00a0 _CrtDbgReportW 00be _unlock"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 48 B9 04 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 4C 24 50 E8 ?? ?? ?? ?? 85 C0 0F 84 8E 00 00 00 48 8B 44 24 50 48 83 E8 30 48 89 44 24 30 48 8B 44 24 30 8B 40 1C 25 FF FF 00 00 83 F8 04 74 62 48 8B 44 24 30 83 78 1C 01 74 57 48 8B 44 24 30 8B 40 1C 25 FF FF 00 00 83 F8 02 74 45 48 8B 44 24 30 83 78 1C 03 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3F 06 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 30 8B 4C 24 58 89 48 1C B9 04 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_31_0 {
	meta:
		name = "_CrtSetDbgFlag"
		size = 307
		refs = "000a _crtDbgFlag 004d ??_C@_1BHO@NNANJNF@?$AA?$CI?$AAf?$AAN?$AAe?$AAw?$AAB?$AAi?$AAt?$AAs?$AA?$DN?$AA?$DN?$AA_?$AAC?$AAR?$AAT?$AAD?$AAB?$AAG?$AA_?$AAR?$AAE?$AAP?$AAO?$AAR?$AAT?$AA_?$AAF?$AAL?$AAA?$AAG?$AA?$CJ?$AA?5@ 0059 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006e ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 0078 _CrtDbgReportW 008c _errno 00af ??_C@_1BO@GJFDNMNF@?$AA_?$AAC?$AAr?$AAt?$AAS?$AAe?$AAt?$AAD?$AAb?$AAg?$AAF?$AAl?$AAa?$AAg?$AA?$AA@ 00bb _invalid_parameter 00cd _lock 00f0 check_frequency 010e check_counter 0126 _unlock"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 48 8B 05 ?? ?? ?? ?? 89 44 24 38 83 7C 24 50 FF 74 1A 8B 44 24 50 25 FF FF 00 00 83 E0 C8 85 C0 74 0A C7 44 24 30 00 00 00 00 EB 08 C7 44 24 30 01 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 77 07 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3C E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 77 07 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? EB 67 B9 04 00 00 00 E8 ?? ?? ?? ?? 90 8B 05 ?? ?? ?? ?? 89 44 24 38 83 7C 24 50 FF 74 3D 8B 44 24 50 83 E0 04 85 C0 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 12 8B 44 24 50 C1 F8 10 25 FF FF 00 00 89 05 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 00 00 00 00 8B 44 24 50 89 05 ?? ?? ?? ?? B9 04 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 38 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_36_0 {
	meta:
		name = "_aligned_free_dbg"
		size = 229
		refs = "003a _bNoMansLandFill 0042 CheckBytes 0057 ??_C@_0EF@PGELACII@The?5block?5at?50x?$CFp?5was?5not?5alloca@ 006e _CrtDbgReport 008e _bAlignLandFill 00ab ??_C@_0DL@PGHMMKNE@Damage?5before?50x?$CFp?5which?5was?5all@ 00dc _free_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 50 00 75 05 E9 CA 00 00 00 48 8B 44 24 50 48 83 E0 F8 48 83 E8 10 48 89 44 24 30 48 8B 44 24 50 48 83 E8 04 41 B8 04 00 00 00 0F B6 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 85 C0 74 32 48 8B 44 24 50 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 64 48 8B 44 24 30 48 83 C0 08 41 B8 08 00 00 00 0F B6 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 30 48 8B 44 24 50 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 BA 01 00 00 00 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_37_0 {
	meta:
		name = "_aligned_malloc"
		size = 48
		refs = "0027 _aligned_offset_malloc_dbg"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 45 33 C9 45 33 C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_30_38_0 {
	meta:
		name = "_aligned_malloc_dbg"
		size = 60
		refs = "0033 _aligned_offset_malloc_dbg"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 8B 44 24 58 89 44 24 20 4C 8B 4C 24 50 45 33 C0 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_30_39_0 {
	meta:
		name = "_aligned_msize"
		size = 44
		refs = "0023 _aligned_msize_dbg"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_554_3 {
	meta:
		name = "?_Addfac@_Locimp@locale@std@@AEAAXPEAVfacet@23@_K@Z"
		size = 44
		refs = "0023 ?_Locimp_Addfac@_Locimp@locale@std@@CAXPEAV123@PEAVfacet@23@_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_84_284_3 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@D@std@@@std@@QEAAXPEAD_K@Z"
		size = 44
		refs = "0023 ?deallocate@?$allocator@D@std@@QEAAXPEAD_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_1013_3 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@G@std@@@std@@QEAAXPEAG_K@Z"
		size = 44
		refs = "0023 ?deallocate@?$allocator@G@std@@QEAAXPEAG_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_1374_2 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@PEAX@std@@@std@@QEAAXPEAPEAX_K@Z"
		size = 44
		refs = "0023 ?deallocate@?$allocator@PEAX@std@@QEAAXPEAPEAX_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_1375_2 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@U_Container_proxy@std@@@std@@@std@@QEAAXPEAU_Container_proxy@2@_K@Z"
		size = 44
		refs = "0023 ?deallocate@?$allocator@U_Container_proxy@std@@@std@@QEAAXPEAU_Container_proxy@2@_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_58_1394_3 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@@std@@QEAAXPEAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@_K@Z"
		size = 44
		refs = "0023 ?deallocate@?$allocator@V?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@std@@@std@@QEAAXPEAV?$shared_ptr@U?$_Task_impl@E@details@Concurrency@@@2@_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_62_1377_2 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@@std@@QEAAXPEAV?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@_K@Z"
		size = 44
		refs = "0023 ?deallocate@?$allocator@V?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@std@@@std@@QEAAXPEAV?$shared_ptr@U?$_Task_impl@U?$pair@EPEAV_CancellationTokenState@details@Concurrency@@@std@@@details@Concurrency@@@2@_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_38_210_3 {
	meta:
		name = "?deallocate@?$_Wrap_alloc@V?$allocator@_W@std@@@std@@QEAAXPEA_W_K@Z"
		size = 44
		refs = "0023 ?deallocate@?$allocator@_W@std@@QEAAXPEA_W_K@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_55_8_3 {
	meta:
		name = "_Cnd_timedwait"
		size = 44
		refs = "0023 ?do_wait@@YAHPEAPEAU_Cnd_internal_imp_t@@PEAPEAU_Mtx_internal_imp_t@@PEBUxtime@@@Z"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1300_9_0 {
	meta:
		name = "_strtold_l"
		size = 44
		refs = "0023 _strtod_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_703_8_0 {
	meta:
		name = "_wcstold_l"
		size = 44
		refs = "0023 _wcstod_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_40_0 {
	meta:
		name = "_aligned_msize_dbg"
		size = 446
		refs = "006f ??_C@_1CC@MOBIKHH@?$AAm?$AAe?$AAm?$AAb?$AAl?$AAo?$AAc?$AAk?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 007b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0090 ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 009a _CrtDbgReportW 00ae _errno 00d1 ??_C@_1CG@CEGMHIMN@?$AA_?$AAa?$AAl?$AAi?$AAg?$AAn?$AAe?$AAd?$AA_?$AAm?$AAs?$AAi?$AAz?$AAe?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 00dd _invalid_parameter 0114 _msize"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 78 48 C7 44 24 40 00 00 00 00 48 C7 44 24 58 00 00 00 00 48 C7 44 24 50 00 00 00 00 48 C7 44 24 68 00 00 00 00 48 C7 44 24 60 00 00 00 00 48 83 BC 24 80 00 00 00 00 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 30 83 7C 24 30 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 03 0D 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 30 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 03 0D 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 CC 00 00 00 48 C7 44 24 38 00 00 00 00 48 8B 84 24 80 00 00 00 48 83 E0 F8 48 83 E8 10 48 89 44 24 38 48 8B 44 24 38 48 8B 08 E8 ?? ?? ?? ?? 48 89 44 24 50 48 8B 44 24 38 48 8B 00 48 8B 8C 24 80 00 00 00 48 2B C8 48 8B C1 48 89 44 24 40 33 C0 48 2B 84 24 90 00 00 00 48 83 E0 07 48 89 44 24 60 48 83 BC 24 88 00 00 00 08 76 0F 48 8B 84 24 88 00 00 00 48 89 44 24 48 EB 09 48 C7 44 24 48 08 00 00 00 48 8B 44 24 48 48 FF C8 48 89 84 24 88 00 00 00 48 8B 44 24 60 48 8B 8C 24 88 00 00 00 48 8D 44 08 10 48 2B 44 24 40 48 89 44 24 58 48 8B 44 24 40 48 8B 4C 24 50 48 2B C8 48 8B C1 48 2B 44 24 58 48 89 44 24 68 48 8B 44 24 68 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_30_41_0 {
	meta:
		name = "_aligned_offset_malloc"
		size = 55
		refs = "002e _aligned_offset_malloc_dbg"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 45 33 C9 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_30_42_0 {
	meta:
		name = "_aligned_offset_malloc_dbg"
		size = 729
		refs = "005d ??_C@_1CE@NPMGPNNP@?$AAI?$AAS?$AA_?$AA2?$AA_?$AAP?$AAO?$AAW?$AA_?$AAN?$AA?$CI?$AAa?$AAl?$AAi?$AAg?$AAn?$AA?$CJ?$AA?$AA@ 0069 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 007e ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 0088 _CrtDbgReportW 009c _errno 00bf ??_C@_1DG@DONCJBBJ@?$AA_?$AAa?$AAl?$AAi?$AAg?$AAn?$AAe?$AAd?$AA_?$AAo?$AAf?$AAf?$AAs?$AAe?$AAt?$AA_?$AAm?$AAa?$AAl?$AAl?$AAo?$AAc?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 00cb _invalid_parameter 0117 ??_C@_1DK@LFLKFPDA@?$AAo?$AAf?$AAf?$AAs?$AAe?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAo?$AAf?$AAf?$AAs?$AAe?$AAt?$AA?5?$AA?$DM?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 0241 _malloc_dbg 02a5 _bAlignLandFill 02bb memset"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 88 00 00 00 48 8B 84 24 98 00 00 00 48 FF C8 48 8B 8C 24 98 00 00 00 48 23 C8 48 8B C1 48 85 C0 75 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 40 0B 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 40 0B 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 FB 01 00 00 48 83 BC 24 A0 00 00 00 00 74 1C 48 8B 84 24 90 00 00 00 48 39 84 24 A0 00 00 00 72 0A C7 44 24 30 00 00 00 00 EB 08 C7 44 24 30 01 00 00 00 8B 44 24 30 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 41 0B 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 41 0B 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 41 01 00 00 48 83 BC 24 98 00 00 00 08 76 0F 48 8B 84 24 98 00 00 00 48 89 44 24 48 EB 09 48 C7 44 24 48 08 00 00 00 48 8B 44 24 48 48 FF C8 48 89 84 24 98 00 00 00 33 C0 48 2B 84 24 A0 00 00 00 48 83 E0 07 48 89 44 24 50 48 8B 44 24 50 48 8B 8C 24 98 00 00 00 48 8D 44 08 10 48 89 44 24 68 48 8B 44 24 68 48 8B 8C 24 90 00 00 00 48 03 C8 48 8B C1 48 89 44 24 58 48 8B 44 24 58 48 39 84 24 90 00 00 00 76 12 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 AB 00 00 00 44 8B 8C 24 B0 00 00 00 4C 8B 84 24 A8 00 00 00 BA 01 00 00 00 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 75 04 33 C0 EB 7B 48 8B 44 24 68 48 8B 4C 24 40 48 03 C8 48 8B C1 48 03 84 24 A0 00 00 00 48 8B 8C 24 98 00 00 00 48 F7 D1 48 23 C1 48 2B 84 24 A0 00 00 00 48 89 44 24 70 48 8B 44 24 50 48 8B 4C 24 70 48 2B C8 48 8B C1 48 83 E8 10 48 89 44 24 60 0F B6 05 ?? ?? ?? ?? 48 8B 4C 24 60 48 83 C1 08 41 B8 08 00 00 00 8B D0 E8 ?? ?? ?? ?? 48 8B 44 24 60 48 8B 4C 24 40 48 89 08 48 8B 44 24 70 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_30_43_0 {
	meta:
		name = "_aligned_offset_realloc"
		size = 71
		refs = "003e _aligned_offset_realloc_dbg"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 4C 8B 4C 24 58 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_30_44_0 {
	meta:
		name = "_aligned_offset_realloc_dbg"
		size = 1181
		refs = "0052 _aligned_offset_malloc_dbg 006f _aligned_free_dbg 00a4 _bNoMansLandFill 00ac CheckBytes 00c4 ??_C@_0EI@NDNJMAJK@The?5block?5at?50x?$CFp?5was?5not?5alloca@ 00db _CrtDbgReport 00e8 _errno 010b _bAlignLandFill 012b ??_C@_0DL@PGHMMKNE@Damage?5before?50x?$CFp?5which?5was?5all@ 0190 ??_C@_1CE@NPMGPNNP@?$AAI?$AAS?$AA_?$AA2?$AA_?$AAP?$AAO?$AAW?$AA_?$AAN?$AA?$CI?$AAa?$AAl?$AAi?$AAg?$AAn?$AA?$CJ?$AA?$AA@ 019c ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 01b1 ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 01bb _CrtDbgReportW 01f2 ??_C@_1DI@NINIKFFK@?$AA_?$AAa?$AAl?$AAi?$AAg?$AAn?$AAe?$AAd?$AA_?$AAo?$AAf?$AAf?$AAs?$AAe?$AAt?$AA_?$AAr?$AAe?$AAa?$AAl?$AAl?$AAo?$AAc?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 01fe _invalid_parameter 024a ??_C@_1DK@LFLKFPDA@?$AAo?$AAf?$AAf?$AAs?$AAe?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAo?$AAf?$AAf?$AAs?$AAe?$AAt?$AA?5?$AA?$DM?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?$AA@ 02cc _msize 03a8 _malloc_dbg 0425 memset 047a memcpy 048c _free_dbg"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 98 00 00 00 48 83 BC 24 A0 00 00 00 00 75 35 8B 84 24 C8 00 00 00 89 44 24 20 4C 8B 8C 24 C0 00 00 00 4C 8B 84 24 B8 00 00 00 48 8B 94 24 B0 00 00 00 48 8B 8C 24 A8 00 00 00 E8 ?? ?? ?? ?? E9 3A 04 00 00 48 83 BC 24 A8 00 00 00 00 75 14 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 1B 04 00 00 48 8B 84 24 A0 00 00 00 48 83 E0 F8 48 83 E8 10 48 89 44 24 40 48 8B 84 24 A0 00 00 00 48 83 E8 04 41 B8 04 00 00 00 0F B6 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 85 C0 74 45 48 8B 84 24 A0 00 00 00 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 9C 03 00 00 48 8B 44 24 40 48 83 C0 08 41 B8 08 00 00 00 0F B6 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 33 48 8B 84 24 A0 00 00 00 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 84 24 B0 00 00 00 48 FF C8 48 8B 8C 24 B0 00 00 00 48 23 C8 48 8B C1 48 85 C0 75 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 E5 0B 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 E5 0B 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 8C 02 00 00 48 83 BC 24 B8 00 00 00 00 74 1C 48 8B 84 24 A8 00 00 00 48 39 84 24 B8 00 00 00 72 0A C7 44 24 30 00 00 00 00 EB 08 C7 44 24 30 01 00 00 00 8B 44 24 30 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 E6 0B 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 E6 0B 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 D2 01 00 00 48 8B 44 24 40 48 8B 08 E8 ?? ?? ?? ?? 48 8B 4C 24 40 48 8B 09 48 8B 94 24 A0 00 00 00 48 2B D1 48 8B CA 48 2B C1 48 89 44 24 78 48 83 BC 24 B0 00 00 00 08 76 0F 48 8B 84 24 B0 00 00 00 48 89 44 24 70 EB 09 48 C7 44 24 70 08 00 00 00 48 8B 44 24 70 48 FF C8 48 89 84 24 B0 00 00 00 33 C0 48 2B 84 24 B8 00 00 00 48 83 E0 07 48 89 44 24 60 48 8B 44 24 60 48 8B 8C 24 B0 00 00 00 48 8D 44 08 10 48 89 44 24 58 48 8B 44 24 58 48 8B 8C 24 A8 00 00 00 48 03 C8 48 8B C1 48 89 84 24 80 00 00 00 48 8B 84 24 80 00 00 00 48 39 84 24 A8 00 00 00 76 12 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 0B 01 00 00 44 8B 8C 24 C8 00 00 00 4C 8B 84 24 C0 00 00 00 BA 01 00 00 00 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 50 48 83 7C 24 50 00 75 07 33 C0 E9 D5 00 00 00 48 8B 44 24 58 48 8B 4C 24 50 48 03 C8 48 8B C1 48 03 84 24 B8 00 00 00 48 8B 8C 24 B0 00 00 00 48 F7 D1 48 23 C1 48 2B 84 24 B8 00 00 00 48 89 44 24 48 48 8B 44 24 60 48 8B 4C 24 48 48 2B C8 48 8B C1 48 83 E8 10 48 89 44 24 68 0F B6 05 ?? ?? ?? ?? 48 8B 4C 24 68 48 83 C1 08 41 B8 08 00 00 00 8B D0 E8 ?? ?? ?? ?? 48 8B 44 24 68 48 8B 4C 24 50 48 89 08 48 8B 84 24 A8 00 00 00 48 39 44 24 78 76 12 48 8B 84 24 A8 00 00 00 48 89 84 24 88 00 00 00 EB 0D 48 8B 44 24 78 48 89 84 24 88 00 00 00 4C 8B 84 24 88 00 00 00 48 8B 94 24 A0 00 00 00 48 8B 4C 24 48 E8 ?? ?? ?? ?? BA 01 00 00 00 48 8B 44 24 40 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_30_45_0 {
	meta:
		name = "_aligned_offset_recalloc"
		size = 81
		refs = "0048 _aligned_offset_recalloc_dbg"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 30 00 00 00 00 48 C7 44 24 28 00 00 00 00 48 8B 44 24 70 48 89 44 24 20 4C 8B 4C 24 68 4C 8B 44 24 60 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_46_0 {
	meta:
		name = "_aligned_offset_recalloc_dbg"
		size = 279
		refs = "0051 _errno 008d _aligned_msize 00c6 _aligned_offset_realloc_dbg 0109 memset"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 C7 44 24 30 00 00 00 00 48 C7 44 24 38 00 00 00 00 48 C7 44 24 40 00 00 00 00 48 83 7C 24 68 00 76 27 33 D2 48 C7 C0 E0 FF FF FF 48 F7 74 24 68 48 3B 44 24 70 73 12 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 B0 00 00 00 48 8B 44 24 70 48 0F AF 44 24 68 48 89 44 24 30 48 83 7C 24 60 00 74 1C 4C 8B 84 24 80 00 00 00 48 8B 54 24 78 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 89 44 24 38 8B 84 24 90 00 00 00 89 44 24 28 48 8B 84 24 88 00 00 00 48 89 44 24 20 4C 8B 8C 24 80 00 00 00 4C 8B 44 24 78 48 8B 54 24 30 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 74 36 48 8B 44 24 30 48 39 44 24 38 73 2A 48 8B 44 24 38 48 8B 4C 24 30 48 2B C8 48 8B C1 48 8B 4C 24 38 48 8B 54 24 40 48 03 D1 48 8B CA 4C 8B C0 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_30_47_0 {
	meta:
		name = "_aligned_realloc"
		size = 64
		refs = "0037 _aligned_offset_realloc_dbg"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 45 33 C9 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_30_48_0 {
	meta:
		name = "_aligned_realloc_dbg"
		size = 70
		refs = "003d _aligned_offset_realloc_dbg"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 8B 44 24 60 89 44 24 28 48 8B 44 24 58 48 89 44 24 20 45 33 C9 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_30_49_0 {
	meta:
		name = "_aligned_recalloc"
		size = 80
		refs = "0047 _aligned_offset_recalloc_dbg"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 30 00 00 00 00 48 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 4C 8B 4C 24 68 4C 8B 44 24 60 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_50_0 {
	meta:
		name = "_aligned_recalloc_dbg"
		size = 81
		refs = "0048 _aligned_offset_recalloc_dbg"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 8B 44 24 78 89 44 24 30 48 8B 44 24 70 48 89 44 24 28 48 C7 44 24 20 00 00 00 00 4C 8B 4C 24 68 4C 8B 44 24 60 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_51_0 {
	meta:
		name = "_calloc_dbg"
		size = 126
		refs = "0047 _calloc_dbg_impl 0060 _errno"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 30 00 00 00 00 48 8D 44 24 30 48 89 44 24 28 8B 44 24 70 89 44 24 20 4C 8B 4C 24 68 44 8B 44 24 60 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 75 1C 83 7C 24 30 00 74 15 E8 ?? ?? ?? ?? 48 85 C0 74 0B E8 ?? ?? ?? ?? 8B 4C 24 30 89 08 48 8B 44 24 38 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_52_0 {
	meta:
		name = "_calloc_dbg_impl"
		size = 168
		refs = "0036 _errno 0072 _newmode 007c _nh_malloc_dbg_impl 009a memset"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 50 00 76 24 33 D2 48 C7 C0 E0 FF FF FF 48 F7 74 24 50 48 3B 44 24 58 73 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 5F 48 8B 44 24 58 48 0F AF 44 24 50 48 89 44 24 58 48 8B 44 24 78 48 89 44 24 28 8B 44 24 70 89 44 24 20 4C 8B 4C 24 68 44 8B 44 24 60 8B 15 ?? ?? ?? ?? 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 74 11 4C 8B 44 24 58 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_53_0 {
	meta:
		name = "_expand"
		size = 61
		refs = "002a _expand_dbg"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 20 00 00 00 00 45 33 C9 41 B8 01 00 00 00 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_741_0_0 {
	meta:
		name = "calloc"
		size = 61
		refs = "002a _calloc_dbg"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 20 00 00 00 00 45 33 C9 41 B8 01 00 00 00 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1294_0_0 {
	meta:
		name = "realloc"
		size = 61
		refs = "002a _realloc_dbg"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 20 00 00 00 00 45 33 C9 41 B8 01 00 00 00 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_54_0 {
	meta:
		name = "_expand_dbg"
		size = 295
		refs = "004d ??_C@_1CE@CJACEFBA@?$AAp?$AAU?$AAs?$AAe?$AAr?$AAD?$AAa?$AAt?$AAa?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0059 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006e ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 0078 _CrtDbgReportW 008c _errno 00af ??_C@_1BI@HAPNGHDP@?$AA_?$AAe?$AAx?$AAp?$AAa?$AAn?$AAd?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 00bb _invalid_parameter 00e0 _lock 010a realloc_help 0119 _unlock"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 38 00 00 00 00 48 83 7C 24 50 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 AF 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 AF 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 EB 5F 48 83 7C 24 58 AC 76 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 48 B9 04 00 00 00 E8 ?? ?? ?? ?? 90 C7 44 24 28 00 00 00 00 8B 44 24 70 89 44 24 20 4C 8B 4C 24 68 44 8B 44 24 60 48 8D 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 38 B9 04 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 38 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_56_0 {
	meta:
		name = "_free_dbg"
		size = 54
		refs = "0013 _lock 0022 _free_dbg_nolock 002d _unlock"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 B9 04 00 00 00 E8 ?? ?? ?? ?? 90 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 90 B9 04 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_58_0 {
	meta:
		name = "_free_dbg_nolock"
		size = 1776
		refs = "000f check_frequency 0020 check_counter 0027 _CrtCheckMemory 0032 ??_C@_1CE@LJFEPPMP@?$AA_?$AAC?$AAr?$AAt?$AAC?$AAh?$AAe?$AAc?$AAk?$AAM?$AAe?$AAm?$AAo?$AAr?$AAy?$AA?$CI?$AA?$CJ?$AA?$AA@ 003e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0053 ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 005d _CrtDbgReportW 00ad _bAlignLandFill 00b5 CheckBytes 00ca ??_C@_0EJ@HEIBCIMJ@The?5Block?5at?50x?$CFp?5was?5allocated?5@ 00e1 _CrtDbgReport 00ee _errno 0100 _pfnAllocHook 013f ??_C@_0BL@KEIPLFAC@Client?5hook?5free?5failure?4?6?$AA@ 014b ??_C@_02DKCKIIND@?$CFs?$AA@ 0176 _CrtIsValidHeapPointer 0181 ??_C@_1EE@GFOPCECE@?$AA_?$AAC?$AAr?$AAt?$AAI?$AAs?$AAV?$AAa?$AAl?$AAi?$AAd?$AAH?$AAe?$AAa?$AAp?$AAP?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr?$AA?$CI?$AAp?$AAU?$AAs?$AAe?$AAr?$AAD?$AAa?$AAt?$AAa@ 0203 ??_C@_1EO@LHDAJOCM@?$AA_?$AAB?$AAL?$AAO?$AAC?$AAK?$AA_?$AAT?$AAY?$AAP?$AAE?$AA_?$AAI?$AAS?$AA_?$AAV?$AAA?$AAL?$AAI?$AAD?$AA?$CI?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?9?$AA?$DO?$AAn?$AAB?$AAl?$AAo@ 023c _crtDbgFlag 025d _bNoMansLandFill 029a szBlockUseName 02d7 ??_C@_0KI@JGFOHMEB@HEAP?5CORRUPTION?5DETECTED?3?5before@ 033a ??_C@_0IK@PJCGLBOB@HEAP?5CORRUPTION?5DETECTED?3?5before@ 03f3 ??_C@_0KE@MBMNHHHN@HEAP?5CORRUPTION?5DETECTED?3?5after?5@ 0456 ??_C@_0IG@LEMBDCJK@HEAP?5CORRUPTION?5DETECTED?3?5after?5@ 04a4 ??_C@_1HK@HPCBMDFG@?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?9?$AA?$DO?$AAn?$AAL?$AAi?$AAn?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAI?$AAG?$AAN?$AAO?$AAR?$AAE?$AA_?$AAL?$AAI?$AAN?$AAE?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAp@ 04eb _bDeadLandFill 04fa memset 0504 _free_base 0538 ??_C@_1DM@ODCJIDCP@?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?9?$AA?$DO?$AAn?$AAB?$AAl?$AAo?$AAc?$AAk?$AAU?$AAs?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAn?$AAB?$AAl?$AAo?$AAc?$AAk?$AAU?$AAs?$AAe?$AA?$AA@ 057b _lCurAlloc 05c7 _pLastBlock 05d0 ??_C@_1CK@DMAGEMBG@?$AA_?$AAp?$AAL?$AAa?$AAs?$AAt?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?$AA@ 0641 _pFirstBlock 064a ??_C@_1CM@MMAADDMD@?$AA_?$AAp?$AAF?$AAi?$AAr?$AAs?$AAt?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?$AA@"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 68 83 3D ?? ?? ?? ?? 00 76 6D 8B 05 ?? ?? ?? ?? FF C8 39 05 ?? ?? ?? ?? 75 4F E8 ?? ?? ?? ?? 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 08 05 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 C7 05 ?? ?? ?? ?? 00 00 00 00 EB 0E 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 48 83 7C 24 70 00 75 05 E9 5B 06 00 00 83 7C 24 78 01 75 66 48 8B 44 24 70 48 83 E0 F8 48 83 E8 08 41 B8 08 00 00 00 0F B6 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 85 C0 74 40 48 8B 44 24 70 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 EE 05 00 00 48 83 3D ?? ?? ?? ?? 00 74 69 C7 44 24 30 00 00 00 00 48 C7 44 24 28 00 00 00 00 C7 44 24 20 00 00 00 00 44 8B 4C 24 78 45 33 C0 48 8B 54 24 70 B9 03 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 34 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 E9 7B 05 00 00 48 8B 4C 24 70 E8 ?? ?? ?? ?? 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 2A 05 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 70 48 83 E8 30 48 89 44 24 50 48 8B 44 24 50 8B 40 1C 25 FF FF 00 00 83 F8 04 74 62 48 8B 44 24 50 83 78 1C 01 74 57 48 8B 44 24 50 8B 40 1C 25 FF FF 00 00 83 F8 02 74 45 48 8B 44 24 50 83 78 1C 03 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 30 05 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 8B 05 ?? ?? ?? ?? 83 E0 04 85 C0 0F 85 2E 02 00 00 48 8B 44 24 50 48 83 C0 2C 41 B8 04 00 00 00 0F B6 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 EC 00 00 00 48 8B 44 24 50 48 83 78 10 00 74 7F 48 8B 44 24 50 48 83 C0 30 48 8B 4C 24 50 8B 49 1C 81 E1 FF FF 00 00 48 63 C9 48 8D 15 ?? ?? ?? ?? 4C 8B 44 24 50 45 8B 40 18 44 89 44 24 48 4C 8B 44 24 50 4D 8B 40 10 4C 89 44 24 40 48 89 44 24 38 48 8B 44 24 50 8B 40 28 89 44 24 30 48 8B 04 CA 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 61 48 8B 44 24 50 48 83 C0 30 48 8B 4C 24 50 8B 49 1C 81 E1 FF FF 00 00 48 63 C9 48 8D 15 ?? ?? ?? ?? 48 89 44 24 38 48 8B 44 24 50 8B 40 28 89 44 24 30 48 8B 04 CA 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 50 48 8B 40 20 48 8B 4C 24 50 48 8D 44 01 30 41 B8 04 00 00 00 0F B6 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 85 C0 0F 85 EC 00 00 00 48 8B 44 24 50 48 83 78 10 00 74 7F 48 8B 44 24 50 48 83 C0 30 48 8B 4C 24 50 8B 49 1C 81 E1 FF FF 00 00 48 63 C9 48 8D 15 ?? ?? ?? ?? 4C 8B 44 24 50 45 8B 40 18 44 89 44 24 48 4C 8B 44 24 50 4D 8B 40 10 4C 89 44 24 40 48 89 44 24 38 48 8B 44 24 50 8B 40 28 89 44 24 30 48 8B 04 CA 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 61 48 8B 44 24 50 48 83 C0 30 48 8B 4C 24 50 8B 49 1C 81 E1 FF FF 00 00 48 63 C9 48 8D 15 ?? ?? ?? ?? 48 89 44 24 38 48 8B 44 24 50 8B 40 28 89 44 24 30 48 8B 04 CA 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 50 83 78 1C 03 0F 85 85 00 00 00 48 8B 44 24 50 81 78 18 BC BA DC FE 75 0B 48 8B 44 24 50 83 78 28 00 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 69 05 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 50 48 8B 40 20 48 83 C0 34 0F B6 0D ?? ?? ?? ?? 4C 8B C0 8B D1 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 4C 24 50 E8 ?? ?? ?? ?? E9 DE 01 00 00 48 8B 44 24 50 83 78 1C 02 75 0F 83 7C 24 78 01 75 08 C7 44 24 78 02 00 00 00 48 8B 44 24 50 8B 4C 24 78 39 48 1C 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 77 05 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 50 48 8B 40 20 48 8B 0D ?? ?? ?? ?? 48 2B C8 48 8B C1 48 89 05 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 83 E0 02 85 C0 0F 85 22 01 00 00 48 8B 44 24 50 48 83 38 00 74 17 48 8B 44 24 50 48 8B 00 48 8B 4C 24 50 48 8B 49 08 48 89 48 08 EB 58 48 8B 44 24 50 48 39 05 ?? ?? ?? ?? 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 86 05 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 50 48 8B 40 08 48 89 05 ?? ?? ?? ?? 48 8B 44 24 50 48 83 78 08 00 74 16 48 8B 44 24 50 48 8B 40 08 48 8B 4C 24 50 48 8B 09 48 89 08 EB 57 48 8B 44 24 50 48 39 05 ?? ?? ?? ?? 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 90 05 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 50 48 8B 00 48 89 05 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 40 20 48 83 C0 34 0F B6 0D ?? ?? ?? ?? 4C 8B C0 8B D1 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 8B 4C 24 50 E8 ?? ?? ?? ?? EB 2C 48 8B 44 24 50 C7 40 1C 00 00 00 00 0F B6 05 ?? ?? ?? ?? 48 8B 4C 24 50 48 83 C1 30 48 8B 54 24 50 4C 8B 42 20 8B D0 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_30_59_0 {
	meta:
		name = "_free_nolock"
		size = 29
		refs = "0014 _free_dbg_nolock"
		altNames = "free"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 BA 01 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_39_4_1 {
	meta:
		name = "_Cnd_broadcast"
		size = 29
		refs = "0014 ?do_signal@@YAHPEAPEAU_Cnd_internal_imp_t@@H@Z"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 BA 01 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_242_3_0 {
	meta:
		name = "_mktime32"
		size = 29
		refs = "0014 _make__time32_t"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 BA 01 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_270_3_0 {
	meta:
		name = "_mktime64"
		size = 29
		refs = "0014 _make__time64_t"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 BA 01 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_66_0 {
	meta:
		name = "_msize"
		size = 29
		refs = "0014 _msize_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 BA 01 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_60_0 {
	meta:
		name = "_heap_alloc"
		size = 35
		refs = "001a _heap_alloc_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 45 33 C9 45 33 C0 BA 01 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_564_1_0 {
	meta:
		name = "_strdup"
		size = 35
		refs = "001a _strdup_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 45 33 C9 45 33 C0 BA 01 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_280_1_0 {
	meta:
		name = "_wcsdup"
		size = 35
		refs = "001a _wcsdup_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 45 33 C9 45 33 C0 BA 01 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_61_0 {
	meta:
		name = "_heap_alloc_dbg"
		size = 116
		refs = "003d _heap_alloc_dbg_impl 0056 _errno"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 30 00 00 00 00 48 8D 44 24 30 48 89 44 24 20 44 8B 4C 24 68 4C 8B 44 24 60 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 75 1C 83 7C 24 30 00 74 15 E8 ?? ?? ?? ?? 48 85 C0 74 0B E8 ?? ?? ?? ?? 8B 4C 24 30 89 08 48 8B 44 24 38 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_62_0 {
	meta:
		name = "_heap_alloc_dbg_impl"
		size = 1182
		refs = "002e _lock 0035 check_frequency 0046 check_counter 004d _CrtCheckMemory 0058 ??_C@_1CE@LJFEPPMP@?$AA_?$AAC?$AAr?$AAt?$AAC?$AAh?$AAe?$AAc?$AAk?$AAM?$AAe?$AAm?$AAo?$AAr?$AAy?$AA?$CI?$AA?$CJ?$AA?$AA@ 0064 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0079 ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 0083 _CrtDbgReportW 00ab _lRequestCurr 00b5 _crtBreakAlloc 00cc _pfnAllocHook 0138 ??_C@_0DF@BBEGIFEK@Client?5hook?5allocation?5failure?5a@ 014c _CrtDbgReport 015d ??_C@_0CB@CCLOLAHO@Client?5hook?5allocation?5failure?4?6@ 0169 ??_C@_02DKCKIIND@?$CFs?$AA@ 019e _crtDbgFlag 01c6 ??_C@_0CF@BICKFLAF@Invalid?5allocation?5size?3?5?$CFIu?5byt@ 0234 ??_C@_0DC@JEMAGEKG@Error?3?5memory?5allocation?3?5bad?5me@ 0277 _heap_alloc_base 0322 _lTotalAlloc 035b _lCurAlloc 036f _lMaxAlloc 038d _pFirstBlock 03ae _pLastBlock 0423 _bNoMansLandFill 0439 memset 0463 _bCleanLandFill 0490 _unlock"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 68 C7 44 24 44 00 00 00 00 48 C7 44 24 50 00 00 00 00 B9 04 00 00 00 E8 ?? ?? ?? ?? 90 83 3D ?? ?? ?? ?? 00 76 6D 8B 05 ?? ?? ?? ?? FF C8 39 05 ?? ?? ?? ?? 75 4F E8 ?? ?? ?? ?? 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 7F 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 C7 05 ?? ?? ?? ?? 00 00 00 00 EB 0E 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 89 44 24 40 83 3D ?? ?? ?? ?? FF 74 0D 8B 05 ?? ?? ?? ?? 39 44 24 40 75 01 CC 48 83 3D ?? ?? ?? ?? 00 0F 84 B7 00 00 00 8B 84 24 88 00 00 00 89 44 24 30 48 8B 84 24 80 00 00 00 48 89 44 24 28 8B 44 24 40 89 44 24 20 44 8B 4C 24 78 4C 8B 44 24 70 33 D2 B9 01 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 7C 48 83 BC 24 80 00 00 00 00 74 3D 8B 84 24 88 00 00 00 89 44 24 30 48 8B 84 24 80 00 00 00 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 2F 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 E9 FC 02 00 00 8B 44 24 78 25 FF FF 00 00 83 F8 02 74 15 8B 05 ?? ?? ?? ?? 83 E0 01 85 C0 75 08 C7 44 24 44 01 00 00 00 48 83 7C 24 70 AC 76 4E 48 8B 44 24 70 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 83 BC 24 90 00 00 00 00 74 0E 48 8B 84 24 90 00 00 00 C7 00 0C 00 00 00 E9 83 02 00 00 8B 44 24 78 25 FF FF 00 00 83 F8 04 74 4E 83 7C 24 78 01 74 47 8B 44 24 78 25 FF FF 00 00 83 F8 02 74 39 83 7C 24 78 03 74 32 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 70 48 83 C0 34 48 89 44 24 58 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 89 44 24 48 48 83 7C 24 48 00 75 1E 48 83 BC 24 90 00 00 00 00 74 0E 48 8B 84 24 90 00 00 00 C7 00 0C 00 00 00 E9 E4 01 00 00 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 83 7C 24 44 00 74 5D 48 8B 44 24 48 48 C7 00 00 00 00 00 48 8B 44 24 48 48 C7 40 08 00 00 00 00 48 8B 44 24 48 48 C7 40 10 00 00 00 00 48 8B 44 24 48 C7 40 18 BC BA DC FE 48 8B 44 24 48 48 8B 4C 24 70 48 89 48 20 48 8B 44 24 48 C7 40 1C 03 00 00 00 48 8B 44 24 48 C7 40 28 00 00 00 00 E9 08 01 00 00 48 C7 C0 FF FF FF FF 48 2B 05 ?? ?? ?? ?? 48 3B 44 24 70 76 1B 48 8B 44 24 70 48 8B 0D ?? ?? ?? ?? 48 03 C8 48 8B C1 48 89 05 ?? ?? ?? ?? EB 0B 48 C7 05 ?? ?? ?? ?? FF FF FF FF 48 8B 44 24 70 48 8B 0D ?? ?? ?? ?? 48 03 C8 48 8B C1 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 39 05 ?? ?? ?? ?? 76 0E 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 74 12 48 8B 05 ?? ?? ?? ?? 48 8B 4C 24 48 48 89 48 08 EB 0C 48 8B 44 24 48 48 89 05 ?? ?? ?? ?? 48 8B 44 24 48 48 8B 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 48 48 C7 40 08 00 00 00 00 48 8B 44 24 48 48 8B 8C 24 80 00 00 00 48 89 48 10 48 8B 44 24 48 8B 8C 24 88 00 00 00 89 48 18 48 8B 44 24 48 48 8B 4C 24 70 48 89 48 20 48 8B 44 24 48 8B 4C 24 78 89 48 1C 48 8B 44 24 48 8B 4C 24 40 89 48 28 48 8B 44 24 48 48 89 05 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? 48 8B 4C 24 48 48 83 C1 2C 41 B8 04 00 00 00 8B D0 E8 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? 48 8B 4C 24 48 48 8B 54 24 70 48 8D 4C 11 30 41 B8 04 00 00 00 8B D0 E8 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? 48 8B 4C 24 48 48 83 C1 30 4C 8B 44 24 70 8B D0 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 83 C0 30 48 89 44 24 50 B9 04 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_30_65_0 {
	meta:
		name = "_malloc_dbg"
		size = 72
		refs = "002b _newmode 0035 _nh_malloc_dbg"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 48 8B 44 24 68 89 44 24 20 4C 8B 4C 24 60 44 8B 44 24 58 8B 15 ?? ?? ?? ?? 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_67_0 {
	meta:
		name = "_msize_dbg"
		size = 583
		refs = "0042 ??_C@_1CE@CJACEFBA@?$AAp?$AAU?$AAs?$AAe?$AAr?$AAD?$AAa?$AAt?$AAa?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0063 ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 006d _CrtDbgReportW 0081 _errno 00a4 ??_C@_1BG@MBKOGDLD@?$AA_?$AAm?$AAs?$AAi?$AAz?$AAe?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 00b0 _invalid_parameter 00c2 check_frequency 00d3 check_counter 00da _CrtCheckMemory 00e5 ??_C@_1CE@LJFEPPMP@?$AA_?$AAC?$AAr?$AAt?$AAC?$AAh?$AAe?$AAc?$AAk?$AAM?$AAe?$AAm?$AAo?$AAr?$AAy?$AA?$CI?$AA?$CJ?$AA?$AA@ 013c _lock 0147 _CrtIsValidHeapPointer 0152 ??_C@_1EE@GFOPCECE@?$AA_?$AAC?$AAr?$AAt?$AAI?$AAs?$AAV?$AAa?$AAl?$AAi?$AAd?$AAH?$AAe?$AAa?$AAp?$AAP?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr?$AA?$CI?$AAp?$AAU?$AAs?$AAe?$AAr?$AAD?$AAa?$AAt?$AAa@ 01d4 ??_C@_1EO@LHDAJOCM@?$AA_?$AAB?$AAL?$AAO?$AAC?$AAK?$AA_?$AAT?$AAY?$AAP?$AAE?$AA_?$AAI?$AAS?$AA_?$AAV?$AAA?$AAL?$AAI?$AAD?$AA?$CI?$AAp?$AAH?$AAe?$AAa?$AAd?$AA?9?$AA?$DO?$AAn?$AAB?$AAl?$AAo@ 0239 _unlock"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 C7 44 24 40 00 00 00 00 48 83 7C 24 60 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 D8 05 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 D8 05 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 82 01 00 00 83 3D ?? ?? ?? ?? 00 76 6D 8B 05 ?? ?? ?? ?? FF C8 39 05 ?? ?? ?? ?? 75 4F E8 ?? ?? ?? ?? 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 DE 05 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 C7 05 ?? ?? ?? ?? 00 00 00 00 EB 0E 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? B9 04 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 4C 24 60 E8 ?? ?? ?? ?? 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 EC 05 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 60 48 83 E8 30 48 89 44 24 38 48 8B 44 24 38 8B 40 1C 25 FF FF 00 00 83 F8 04 74 62 48 8B 44 24 38 83 78 1C 01 74 57 48 8B 44 24 38 8B 40 1C 25 FF FF 00 00 83 F8 02 74 45 48 8B 44 24 38 83 78 1C 03 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 F2 05 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 38 83 78 1C 02 75 0F 83 7C 24 68 01 75 08 C7 44 24 68 02 00 00 00 48 8B 44 24 38 48 8B 40 20 48 89 44 24 40 B9 04 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_30_69_0 {
	meta:
		name = "_nh_malloc"
		size = 49
		refs = "0028 _nh_malloc_dbg"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 45 33 C9 41 B8 01 00 00 00 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_30_70_0 {
	meta:
		name = "_nh_malloc_dbg"
		size = 124
		refs = "0045 _nh_malloc_dbg_impl 005e _errno"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 30 00 00 00 00 48 8D 44 24 30 48 89 44 24 28 8B 44 24 70 89 44 24 20 4C 8B 4C 24 68 44 8B 44 24 60 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 75 1C 83 7C 24 30 00 74 15 E8 ?? ?? ?? ?? 48 85 C0 74 0B E8 ?? ?? ?? ?? 8B 4C 24 30 89 08 48 8B 44 24 38 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_71_0 {
	meta:
		name = "_nh_malloc_dbg_impl"
		size = 154
		refs = "0035 _heap_alloc_dbg_impl 0074 _callnewh"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 78 48 89 44 24 20 44 8B 4C 24 70 4C 8B 44 24 68 8B 54 24 60 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 74 07 48 8B 44 24 30 EB 48 83 7C 24 58 00 75 1A 48 83 7C 24 78 00 74 0B 48 8B 44 24 78 C7 00 0C 00 00 00 48 8B 44 24 30 EB 27 48 8B 4C 24 50 E8 ?? ?? ?? ?? 85 C0 75 17 48 83 7C 24 78 00 74 0B 48 8B 44 24 78 C7 00 0C 00 00 00 33 C0 EB 02 EB 82 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_72_0 {
	meta:
		name = "_printMemBlockData"
		size = 622
		refs = "0014 __security_cookie 0031 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 009a ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 00d1 _isctype_l 00fe _chvalidator_l 0132 _errno 017a ??_C@_05MKKEDADM@?$CF?42X?5?$AA@ 018a sprintf_s 01ab ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 01b7 ??_C@_1CG@LPFIACGM@?$AA_?$AAp?$AAr?$AAi?$AAn?$AAt?$AAM?$AAe?$AAm?$AAB?$AAl?$AAo?$AAc?$AAk?$AAD?$AAa?$AAt?$AAa?$AA?$AA@ 01c3 ??_C@_1BI@KALLJECN@?$AA?$CI?$AA?$CK?$AA_?$AAe?$AAr?$AAr?$AAn?$AAo?$AA?$CI?$AA?$CJ?$AA?$CJ?$AA?$AA@ 01d5 _invoke_watson_if_oneof 01fe __report_rangecheckfailure 022c ??_C@_0BA@HJBKCELP@?5Data?3?5?$DM?$CFs?$DO?5?$CFs?6?$AA@ 0240 _CrtDbgReport 0252 ??1_LocaleUpdate@@QEAA@XZ 0262 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 81 EC F8 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 E0 00 00 00 48 8B 94 24 00 01 00 00 48 8D 4C 24 70 E8 ?? ?? ?? ?? C7 44 24 44 00 00 00 00 EB 0A 8B 44 24 44 FF C0 89 44 24 44 48 8B 84 24 08 01 00 00 83 78 20 10 7D 11 48 8B 84 24 08 01 00 00 8B 40 20 89 44 24 48 EB 08 C7 44 24 48 10 00 00 00 8B 44 24 48 39 44 24 44 0F 8D 6B 01 00 00 48 63 44 24 44 48 8B 8C 24 08 01 00 00 0F B6 44 01 30 88 44 24 40 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 85 C0 74 38 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 8B 00 83 B8 D4 00 00 00 01 7E 22 48 8D 4C 24 70 E8 ?? ?? ?? ?? 0F B6 4C 24 40 4C 8B C0 BA 57 01 00 00 E8 ?? ?? ?? ?? 89 44 24 4C EB 2B 0F B6 44 24 40 89 44 24 54 48 8D 4C 24 70 E8 ?? ?? ?? ?? 41 B8 57 01 00 00 8B 4C 24 54 8B D1 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 4C 83 7C 24 4C 00 74 0B 0F B6 44 24 40 89 44 24 50 EB 08 C7 44 24 50 20 00 00 00 48 63 44 24 44 0F B6 4C 24 50 88 8C 04 90 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 44 24 58 E8 ?? ?? ?? ?? C7 00 00 00 00 00 0F B6 44 24 40 6B 4C 24 44 03 48 63 C9 BA 31 00 00 00 48 2B D1 48 8B CA 6B 54 24 44 03 48 63 D2 48 8D 94 14 A8 00 00 00 48 89 54 24 68 44 8B C8 4C 8D 05 ?? ?? ?? ?? 48 8B D1 48 8B 44 24 68 48 8B C8 E8 ?? ?? ?? ?? 85 C0 7D 47 E8 ?? ?? ?? ?? 48 C7 44 24 38 00 00 00 00 C7 44 24 30 1A 09 00 00 48 8D 0D ?? ?? ?? ?? 48 89 4C 24 28 48 8D 0D ?? ?? ?? ?? 48 89 4C 24 20 4C 8D 0D ?? ?? ?? ?? 41 B8 22 00 00 00 BA 16 00 00 00 8B 08 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4C 24 58 89 08 E9 56 FE FF FF 48 63 44 24 44 48 89 44 24 60 48 83 7C 24 60 11 73 02 EB 05 E8 ?? ?? ?? ?? 48 8B 44 24 60 C6 84 04 90 00 00 00 00 48 8D 84 24 A8 00 00 00 48 89 44 24 30 48 8D 84 24 90 00 00 00 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 8B 8C 24 E0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 F8 00 00 00 C3 }
	condition:
		$1
}

rule file_30_73_0 {
	meta:
		name = "_realloc_dbg"
		size = 110
		refs = "0027 _lock 0051 realloc_help 0060 _unlock"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 30 00 00 00 00 B9 04 00 00 00 E8 ?? ?? ?? ?? 90 C7 44 24 28 01 00 00 00 8B 44 24 70 89 44 24 20 4C 8B 4C 24 68 44 8B 44 24 60 48 8D 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 30 B9 04 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_75_0 {
	meta:
		name = "_recalloc"
		size = 77
		refs = "003a _recalloc_dbg"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 01 00 00 00 4C 8B 44 24 60 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 30 48 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_30_76_0 {
	meta:
		name = "_recalloc_dbg"
		size = 253
		refs = "0051 _errno 0080 _msize 00ac _realloc_dbg 00ef memset"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 C7 44 24 30 00 00 00 00 48 C7 44 24 38 00 00 00 00 48 C7 44 24 40 00 00 00 00 48 83 7C 24 68 00 76 27 33 D2 48 C7 C0 E0 FF FF FF 48 F7 74 24 68 48 3B 44 24 70 73 12 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 96 00 00 00 48 8B 44 24 70 48 0F AF 44 24 68 48 89 44 24 30 48 83 7C 24 60 00 74 0F 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 89 44 24 38 8B 84 24 88 00 00 00 89 44 24 20 4C 8B 8C 24 80 00 00 00 44 8B 44 24 78 48 8B 54 24 30 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 74 36 48 8B 44 24 30 48 39 44 24 38 73 2A 48 8B 44 24 38 48 8B 4C 24 30 48 2B C8 48 8B C1 48 8B 4C 24 38 48 8B 54 24 40 48 03 D1 48 8B CA 4C 8B C0 33 D2 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_30_77_0 {
	meta:
		name = "realloc_help"
		size = 2298
		refs = "0058 _malloc_dbg 0083 _free_dbg 0090 check_frequency 00a1 check_counter 00a8 _CrtCheckMemory 00b3 ??_C@_1CE@LJFEPPMP@?$AA_?$AAC?$AAr?$AAt?$AAC?$AAh?$AAe?$AAc?$AAk?$AAM?$AAe?$AAm?$AAo?$AAr?$AAy?$AA?$CI?$AA?$CJ?$AA?$AA@ 00bf ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00d4 ??_C@_1FA@JKEKCOIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAd?$AAb@ 00de _CrtDbgReportW 0106 _lRequestCurr 0110 _crtBreakAlloc 0127 _pfnAllocHook 019c ??_C@_0DI@KKJPDPGM@Client?5hook?5re?9allocation?5failur@ 01b0 _CrtDbgReport 01c1 ??_C@_0CE@DOFMDOL@Client?5hook?5re?9allocation?5failur@ 01cd ??_C@_02DKCKIIND@?$CFs?$AA@ 0230 ??_C@_0ED@GPCPBAGP@Invalid?5allocation?5size?3?5?$CFIu?5byt@ 0262 ??_C@_0CF@BICKFLAF@Invalid?5allocation?5size?3?5?$CFIu?5byt@ 0286 _errno 02f1 ??_C@_0FA@EFEIGJKG@Error?3?5memory?5allocation?3?5bad?5me@ 0319 ??_C@_0DC@JEMAGEKG@Error?3?5memory?5allocation?3?5bad?5me@ 0363 _bAlignLandFill 036b CheckBytes 0383 ??_C@_0EM@LGFLMAGJ@The?5Block?5at?50x?$CFp?5was?5allocated?5@ 03c1 _CrtIsValidHeapPointer 03cc ??_C@_1EE@GFOPCECE@?$AA_?$AAC?$AAr?$AAt?$AAI?$AAs?$AAV?$AAa?$AAl?$AAi?$AAd?$AAH?$AAe?$AAa?$AAp?$AAP?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr?$AA?$CI?$AAp?$AAU?$AAs?$AAe?$AAr?$AAD?$AAa?$AAt?$AAa@ 044a ??_C@_1IK@DCPKDGNH@?$AAp?$AAO?$AAl?$AAd?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?9?$AA?$DO?$AAn?$AAL?$AAi?$AAn?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAI?$AAG?$AAN?$AAO?$AAR?$AAE?$AA_?$AAL?$AAI?$AAN?$AAE?$AA?5@ 04c0 _lTotalAlloc 04d6 ??_C@_0DA@HFBKENN@Error?3?5possible?5heap?5corruption?5@ 0527 _realloc_base 0553 _expand_base 0575 _crtheap 057b __imp_HeapSize 0625 _lCurAlloc 0652 _lMaxAlloc 06a2 _bCleanLandFill 06cd memset 06d4 _bNoMansLandFill 0759 ??_C@_1GE@PCKLOLAO@?$AAf?$AAR?$AAe?$AAa?$AAl?$AAl?$AAo?$AAc?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AA?$CB?$AAf?$AAR?$AAe?$AAa?$AAl?$AAl?$AAo?$AAc?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAp?$AAN?$AAe?$AAw?$AAB?$AAl@ 07d7 _pLastBlock 07e0 ??_C@_1DC@GEFKNOOL@?$AA_?$AAp?$AAL?$AAa?$AAs?$AAt?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAO?$AAl?$AAd?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 0851 _pFirstBlock 085a ??_C@_1DE@KOOKLFBB@?$AA_?$AAp?$AAF?$AAi?$AAr?$AAs?$AAt?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAp?$AAO?$AAl?$AAd?$AAB?$AAl?$AAo?$AAc?$AAk?$AA?$AA@"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 78 C7 44 24 40 00 00 00 00 48 8B 84 24 88 00 00 00 48 8B 00 48 89 44 24 50 48 83 BC 24 80 00 00 00 00 75 26 44 8B 8C 24 A0 00 00 00 4C 8B 84 24 98 00 00 00 8B 94 24 90 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? E9 94 08 00 00 83 BC 24 A8 00 00 00 00 74 23 48 83 7C 24 50 00 75 1B 8B 94 24 90 00 00 00 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 33 C0 E9 67 08 00 00 83 3D ?? ?? ?? ?? 00 76 6D 8B 05 ?? ?? ?? ?? FF C8 39 05 ?? ?? ?? ?? 75 4F E8 ?? ?? ?? ?? 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 D2 02 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 C7 05 ?? ?? ?? ?? 00 00 00 00 EB 0E 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 89 44 24 44 83 3D ?? ?? ?? ?? FF 74 0D 8B 05 ?? ?? ?? ?? 39 44 24 44 75 01 CC 48 83 3D ?? ?? ?? ?? 00 0F 84 C2 00 00 00 8B 84 24 A0 00 00 00 89 44 24 30 48 8B 84 24 98 00 00 00 48 89 44 24 28 8B 44 24 44 89 44 24 20 44 8B 8C 24 90 00 00 00 4C 8B 44 24 50 48 8B 94 24 80 00 00 00 B9 02 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 7E 48 83 BC 24 98 00 00 00 00 74 3D 8B 84 24 A0 00 00 00 89 44 24 30 48 8B 84 24 98 00 00 00 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 2F 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 E9 01 07 00 00 48 83 7C 24 50 AC 0F 86 97 00 00 00 48 83 BC 24 98 00 00 00 00 74 4A 8B 84 24 A0 00 00 00 89 44 24 38 48 8B 84 24 98 00 00 00 48 89 44 24 30 48 8B 44 24 50 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 30 48 8B 44 24 50 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E9 5E 06 00 00 83 BC 24 90 00 00 00 01 0F 84 A5 00 00 00 8B 84 24 90 00 00 00 25 FF FF 00 00 83 F8 04 0F 84 90 00 00 00 8B 84 24 90 00 00 00 25 FF FF 00 00 83 F8 02 74 7F 48 83 BC 24 98 00 00 00 00 74 40 8B 84 24 A0 00 00 00 89 44 24 30 48 8B 84 24 98 00 00 00 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 32 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 EB 6E 48 8B 84 24 80 00 00 00 48 83 E0 F8 48 83 E8 08 41 B8 08 00 00 00 0F B6 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 85 C0 74 45 48 8B 84 24 80 00 00 00 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 3D 05 00 00 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 19 03 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 84 24 80 00 00 00 48 83 E8 30 48 89 44 24 58 48 8B 44 24 58 83 78 1C 03 75 08 C7 44 24 40 01 00 00 00 83 7C 24 40 00 74 58 48 8B 44 24 58 81 78 18 BC BA DC FE 75 0B 48 8B 44 24 58 83 78 28 00 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 23 03 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 E9 85 00 00 00 48 8B 44 24 58 8B 40 1C 25 FF FF 00 00 83 F8 02 75 1C 8B 84 24 90 00 00 00 25 FF FF 00 00 83 F8 01 75 0B C7 84 24 90 00 00 00 02 00 00 00 48 8B 44 24 58 48 8B 40 20 48 39 05 ?? ?? ?? ?? 73 45 48 8B 84 24 80 00 00 00 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 45 33 C0 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 EA 03 00 00 83 BC 24 A8 00 00 00 00 74 2C 48 8B 44 24 50 48 83 C0 34 48 8B D0 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 89 44 24 48 48 83 7C 24 48 00 75 07 33 C0 E9 B6 03 00 00 EB 5D 48 8B 44 24 50 48 83 C0 34 48 8B D0 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 89 44 24 48 48 83 7C 24 48 00 75 07 33 C0 E9 8A 03 00 00 4C 8B 44 24 48 33 D2 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 83 E8 34 48 8B 8C 24 88 00 00 00 48 89 01 48 8B 84 24 88 00 00 00 48 8B 00 48 89 44 24 50 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 83 7C 24 40 00 0F 85 B6 00 00 00 48 83 3D ?? ?? ?? ?? FF 73 58 48 8B 44 24 48 48 8B 40 20 48 8B 0D ?? ?? ?? ?? 48 2B C8 48 8B C1 48 89 05 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF 48 2B 05 ?? ?? ?? ?? 48 3B 44 24 50 76 1B 48 8B 44 24 50 48 8B 0D ?? ?? ?? ?? 48 03 C8 48 8B C1 48 89 05 ?? ?? ?? ?? EB 0B 48 C7 05 ?? ?? ?? ?? FF FF FF FF 48 8B 44 24 48 48 8B 40 20 48 8B 0D ?? ?? ?? ?? 48 2B C8 48 8B C1 48 89 05 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 0D ?? ?? ?? ?? 48 03 C8 48 8B C1 48 89 05 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 39 05 ?? ?? ?? ?? 76 0E 48 8B 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8B 44 24 48 48 83 C0 30 48 89 44 24 60 48 8B 44 24 48 48 8B 40 20 48 39 44 24 50 76 46 48 8B 44 24 48 48 8B 40 20 48 8B 4C 24 50 48 2B C8 48 8B C1 0F B6 0D ?? ?? ?? ?? 48 8B 54 24 48 48 8B 52 20 4C 8B 44 24 60 4C 03 C2 49 8B D0 48 89 54 24 68 4C 8B C0 8B D1 48 8B 44 24 68 48 8B C8 E8 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? 48 8B 4C 24 50 48 8B 54 24 60 48 03 D1 48 8B CA 41 B8 04 00 00 00 8B D0 E8 ?? ?? ?? ?? 83 7C 24 40 00 75 2C 48 8B 44 24 48 48 8B 8C 24 98 00 00 00 48 89 48 10 48 8B 44 24 48 8B 8C 24 A0 00 00 00 89 48 18 48 8B 44 24 48 8B 4C 24 44 89 48 28 48 8B 44 24 48 48 8B 4C 24 50 48 89 48 20 83 BC 24 A8 00 00 00 00 75 50 83 BC 24 A8 00 00 00 00 75 0C 48 8B 44 24 58 48 39 44 24 48 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 8B 03 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 58 48 39 44 24 48 74 07 83 7C 24 40 00 74 0A 48 8B 44 24 60 E9 48 01 00 00 48 8B 44 24 48 48 83 38 00 74 17 48 8B 44 24 48 48 8B 00 48 8B 4C 24 48 48 8B 49 08 48 89 48 08 EB 58 48 8B 44 24 58 48 39 05 ?? ?? ?? ?? 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 9C 03 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 48 48 8B 40 08 48 89 05 ?? ?? ?? ?? 48 8B 44 24 48 48 83 78 08 00 74 16 48 8B 44 24 48 48 8B 40 08 48 8B 4C 24 48 48 8B 09 48 89 08 EB 57 48 8B 44 24 58 48 39 05 ?? ?? ?? ?? 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 A7 03 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 48 48 8B 00 48 89 05 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 74 12 48 8B 05 ?? ?? ?? ?? 48 8B 4C 24 48 48 89 48 08 EB 0C 48 8B 44 24 48 48 89 05 ?? ?? ?? ?? 48 8B 44 24 48 48 8B 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 48 48 C7 40 08 00 00 00 00 48 8B 44 24 48 48 89 05 ?? ?? ?? ?? 48 8B 44 24 60 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "_CopyMan"
		size = 106
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 38 48 89 44 24 10 48 8B 44 24 30 48 89 44 24 08 C7 04 24 00 00 00 00 EB 08 8B 04 24 FF C0 89 04 24 83 3C 24 03 7D 2C 48 8B 44 24 08 48 8B 4C 24 10 8B 09 89 08 48 8B 44 24 08 48 83 C0 04 48 89 44 24 08 48 8B 44 24 10 48 83 C0 04 48 89 44 24 10 EB C6 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "_FillZeroMan"
		size = 55
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 C7 04 24 00 00 00 00 EB 08 8B 04 24 FF C0 89 04 24 83 3C 24 03 7D 12 48 63 04 24 48 8B 4C 24 20 C7 04 81 00 00 00 00 EB E0 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_33_2_0 {
	meta:
		name = "_IncMan"
		size = 218
		refs = "0077 __addl"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 48 8B 44 24 58 99 83 E2 1F 03 C2 C1 F8 05 89 44 24 20 8B 44 24 58 99 83 E2 1F 03 C2 83 E0 1F 2B C2 B9 1F 00 00 00 2B C8 8B C1 89 44 24 28 8B 44 24 28 B9 01 00 00 00 89 4C 24 2C 0F B6 C8 8B 44 24 2C D3 E0 89 44 24 30 48 63 44 24 20 48 8B 4C 24 50 48 8D 04 81 48 63 4C 24 20 4C 8B C0 8B 54 24 30 48 8B 44 24 50 8B 0C 88 E8 ?? ?? ?? ?? 89 44 24 24 8B 44 24 20 FF C8 89 44 24 20 EB 0A 8B 44 24 20 FF C8 89 44 24 20 83 7C 24 20 00 7C 35 83 7C 24 24 00 74 2E 48 63 44 24 20 48 8B 4C 24 50 48 8D 04 81 48 63 4C 24 20 4C 8B C0 BA 01 00 00 00 48 8B 44 24 50 8B 0C 88 E8 ?? ?? ?? ?? 89 44 24 24 EB BA 8B 44 24 24 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_33_3_0 {
	meta:
		name = "_IsZeroMan"
		size = 63
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 C7 04 24 00 00 00 00 EB 08 8B 04 24 FF C0 89 04 24 83 3C 24 03 7D 15 48 63 04 24 48 8B 4C 24 20 83 3C 81 00 74 04 33 C0 EB 07 EB DD B8 01 00 00 00 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_33_4_0 {
	meta:
		name = "_RoundMan"
		size = 269
		refs = "0091 _ZeroTail 00a3 _IncMan"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 34 00 00 00 00 8B 44 24 58 FF C8 89 44 24 2C 8B 44 24 2C FF C0 89 44 24 28 8B 44 24 28 99 83 E2 1F 03 C2 C1 F8 05 89 44 24 20 8B 44 24 28 99 83 E2 1F 03 C2 83 E0 1F 2B C2 B9 1F 00 00 00 2B C8 8B C1 89 44 24 30 8B 44 24 30 B9 01 00 00 00 89 4C 24 38 0F B6 C8 8B 44 24 38 D3 E0 89 44 24 3C 48 63 44 24 20 48 8B 4C 24 50 8B 54 24 3C 8B 04 81 23 C2 85 C0 74 24 8B 54 24 28 48 8B 4C 24 50 E8 ?? ?? ?? ?? 85 C0 75 12 8B 54 24 2C 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 34 48 63 44 24 20 8B 4C 24 30 BA FF FF FF FF D3 E2 8B CA 48 8B 54 24 50 8B 04 82 23 C1 48 63 4C 24 20 48 8B 54 24 50 89 04 8A 8B 44 24 20 FF C0 89 44 24 24 EB 0A 8B 44 24 24 FF C0 89 44 24 24 83 7C 24 24 03 7D 13 48 63 44 24 24 48 8B 4C 24 50 C7 04 81 00 00 00 00 EB DC 8B 44 24 34 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_33_5_0 {
	meta:
		name = "_ShrMan"
		size = 305
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 28 8B 44 24 38 99 83 E2 1F 03 C2 C1 F8 05 89 44 24 0C 8B 44 24 38 99 83 E2 1F 03 C2 83 E0 1F 2B C2 89 44 24 04 8B 44 24 04 B9 FF FF FF FF 89 4C 24 10 0F B6 C8 8B 44 24 10 D3 E0 F7 D0 89 44 24 14 C7 44 24 08 00 00 00 00 C7 04 24 00 00 00 00 EB 08 8B 04 24 FF C0 89 04 24 83 3C 24 03 7D 6A 48 63 04 24 48 8B 4C 24 30 8B 54 24 14 8B 04 81 23 C2 89 44 24 18 48 63 04 24 8B 4C 24 04 48 8B 54 24 30 8B 04 82 D3 E8 48 63 0C 24 48 8B 54 24 30 89 04 8A 48 63 04 24 48 8B 4C 24 30 8B 54 24 08 8B 04 81 0B C2 48 63 0C 24 48 8B 54 24 30 89 04 8A B8 20 00 00 00 2B 44 24 04 0F B6 C8 8B 44 24 18 D3 E0 89 44 24 08 EB 88 C7 04 24 02 00 00 00 EB 08 8B 04 24 FF C8 89 04 24 83 3C 24 00 7C 3F 8B 44 24 0C 39 04 24 7C 24 8B 44 24 0C 8B 0C 24 2B C8 8B C1 48 98 48 63 0C 24 48 8B 54 24 30 4C 8B 44 24 30 41 8B 04 80 89 04 8A EB 10 48 63 04 24 48 8B 4C 24 30 C7 04 81 00 00 00 00 EB B3 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_6_0 {
	meta:
		name = "_ZeroTail"
		size = 166
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 18 8B 44 24 28 99 83 E2 1F 03 C2 C1 F8 05 89 04 24 8B 44 24 28 99 83 E2 1F 03 C2 83 E0 1F 2B C2 B9 1F 00 00 00 2B C8 8B C1 89 44 24 04 8B 44 24 04 B9 FF FF FF FF 89 4C 24 08 0F B6 C8 8B 44 24 08 D3 E0 F7 D0 89 44 24 0C 48 63 04 24 48 8B 4C 24 20 8B 54 24 0C 8B 04 81 23 C2 85 C0 74 04 33 C0 EB 32 8B 04 24 FF C0 89 04 24 EB 08 8B 04 24 FF C0 89 04 24 83 3C 24 03 7D 15 48 63 04 24 48 8B 4C 24 20 83 3C 81 00 74 04 33 C0 EB 07 EB DD B8 01 00 00 00 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_33_8_0 {
	meta:
		name = "_ld12cvt"
		size = 870
		refs = "0016 __security_cookie 00b4 _IsZeroMan 00cc _FillZeroMan 00e8 _CopyMan 0105 _RoundMan 019b _ShrMan 035d __security_check_cookie"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 78 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 68 48 8B 84 24 80 00 00 00 0F B7 40 0A 25 FF 7F 00 00 2D FF 3F 00 00 89 44 24 20 48 8B 84 24 80 00 00 00 0F B7 40 0A 25 00 80 00 00 89 44 24 40 B8 04 00 00 00 48 6B C0 00 48 8B 8C 24 80 00 00 00 8B 49 06 89 4C 04 48 B8 04 00 00 00 48 6B C0 01 48 8B 8C 24 80 00 00 00 8B 49 02 89 4C 04 48 48 8B 84 24 80 00 00 00 0F B7 00 C1 E0 10 B9 04 00 00 00 48 6B C9 02 89 44 0C 48 81 7C 24 20 01 C0 FF FF 75 37 C7 44 24 28 00 00 00 00 48 8D 4C 24 48 E8 ?? ?? ?? ?? 85 C0 74 0A C7 44 24 24 00 00 00 00 EB 12 48 8D 4C 24 48 E8 ?? ?? ?? ?? C7 44 24 24 02 00 00 00 E9 CB 01 00 00 48 8D 54 24 48 48 8D 4C 24 58 E8 ?? ?? ?? ?? 8B 44 24 20 89 44 24 34 48 8B 84 24 90 00 00 00 8B 50 08 48 8D 4C 24 48 E8 ?? ?? ?? ?? 85 C0 74 0A 8B 44 24 20 FF C0 89 44 24 20 48 8B 84 24 90 00 00 00 48 8B 8C 24 90 00 00 00 8B 49 08 8B 40 04 2B C1 39 44 24 20 7D 1F 48 8D 4C 24 48 E8 ?? ?? ?? ?? C7 44 24 28 00 00 00 00 C7 44 24 24 02 00 00 00 E9 54 01 00 00 48 8B 84 24 90 00 00 00 8B 40 04 39 44 24 20 7F 7D 48 8D 54 24 58 48 8D 4C 24 48 E8 ?? ?? ?? ?? 8B 44 24 34 89 44 24 20 48 8B 84 24 90 00 00 00 8B 4C 24 20 8B 40 04 2B C1 89 44 24 3C 8B 54 24 3C 48 8D 4C 24 48 E8 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 8B 50 08 48 8D 4C 24 48 E8 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 8B 40 0C FF C0 8B D0 48 8D 4C 24 48 E8 ?? ?? ?? ?? C7 44 24 28 00 00 00 00 C7 44 24 24 02 00 00 00 E9 C6 00 00 00 48 8B 84 24 90 00 00 00 8B 00 39 44 24 20 7C 62 48 8D 4C 24 48 E8 ?? ?? ?? ?? B8 04 00 00 00 48 6B C0 00 8B 44 04 48 0F BA E8 1F B9 04 00 00 00 48 6B C9 00 89 44 0C 48 48 8B 84 24 90 00 00 00 8B 40 0C 8B D0 48 8D 4C 24 48 E8 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 8B 00 48 8B 8C 24 90 00 00 00 03 41 14 89 44 24 28 C7 44 24 24 01 00 00 00 EB 54 48 8B 84 24 90 00 00 00 8B 40 14 8B 4C 24 20 03 C8 8B C1 89 44 24 28 B8 04 00 00 00 48 6B C0 00 8B 44 04 48 0F BA F0 1F B9 04 00 00 00 48 6B C9 00 89 44 0C 48 48 8B 84 24 90 00 00 00 8B 40 0C 8B D0 48 8D 4C 24 48 E8 ?? ?? ?? ?? C7 44 24 24 00 00 00 00 48 8B 84 24 90 00 00 00 8B 40 0C FF C0 B9 20 00 00 00 2B C8 8B C1 89 44 24 38 83 7C 24 40 00 74 0A C7 44 24 2C 00 00 00 80 EB 08 C7 44 24 2C 00 00 00 00 B8 04 00 00 00 48 6B C0 00 8B 4C 24 38 8B 54 24 28 D3 E2 8B CA 8B 44 04 48 0B C1 0B 44 24 2C 89 44 24 30 48 8B 84 24 90 00 00 00 83 78 10 40 75 28 48 8B 84 24 88 00 00 00 8B 4C 24 30 89 48 04 B8 04 00 00 00 48 6B C0 01 48 8B 8C 24 88 00 00 00 8B 44 04 48 89 01 EB 1C 48 8B 84 24 90 00 00 00 83 78 10 20 75 0E 48 8B 84 24 88 00 00 00 8B 4C 24 30 89 08 8B 44 24 24 48 8B 4C 24 68 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_33_9_0 {
	meta:
		name = "_ld12tod"
		size = 41
		refs = "0011 DoubleFormat 0020 _ld12cvt"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8D 05 ?? ?? ?? ?? 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_10_0 {
	meta:
		name = "_ld12tof"
		size = 41
		refs = "0011 FloatFormat 0020 _ld12cvt"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8D 05 ?? ?? ?? ?? 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_33_11_0 {
	meta:
		name = "_ld12told"
		size = 294
		refs = "0011 __security_cookie 0098 _RoundMan 011d __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 40 C7 44 24 28 00 00 00 00 48 8B 44 24 60 0F B7 40 0A 25 FF 7F 00 00 66 89 44 24 20 48 8B 44 24 60 0F B7 40 0A 25 00 80 00 00 66 89 44 24 24 B8 04 00 00 00 48 6B C0 00 48 8B 4C 24 60 8B 49 06 89 4C 04 30 B8 04 00 00 00 48 6B C0 01 48 8B 4C 24 60 8B 49 02 89 4C 04 30 48 8B 44 24 60 0F B7 00 C1 E0 10 B9 04 00 00 00 48 6B C9 02 89 44 0C 30 BA 40 00 00 00 48 8D 4C 24 30 E8 ?? ?? ?? ?? 85 C0 74 1E B8 04 00 00 00 48 6B C0 00 C7 44 04 30 00 00 00 80 0F B7 44 24 20 66 FF C0 66 89 44 24 20 0F B7 44 24 20 3D FF 7F 00 00 75 08 C7 44 24 28 01 00 00 00 B8 04 00 00 00 48 6B C0 00 48 8B 4C 24 68 8B 44 04 30 89 41 04 B8 04 00 00 00 48 6B C0 01 48 8B 4C 24 68 8B 44 04 30 89 01 0F B7 44 24 24 0F B7 4C 24 20 0B C1 48 8B 4C 24 68 66 89 41 08 8B 44 24 28 48 8B 4C 24 40 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "__avx_tanh4"
		size = 832
		refs = "000a __common_dtanh_data 0334 __common_dtanh_cout_rare"
	strings:
		$1 = { 48 81 EC 18 02 00 00 48 8D 15 ?? ?? ?? ?? C5 7C 11 BC 24 D0 00 00 00 C5 7C 11 B4 24 F0 01 00 00 C5 7C 11 AC 24 D0 01 00 00 C4 41 09 EF F6 C5 7C 11 A4 24 B0 01 00 00 C5 7C 11 9C 24 90 01 00 00 C5 7C 11 94 24 70 01 00 00 C5 7C 11 8C 24 50 01 00 00 C5 7C 11 84 24 30 01 00 00 C5 FC 11 BC 24 10 01 00 00 C5 FC 11 B4 24 F0 00 00 00 4C 89 AC 24 10 02 00 00 4C 8D 6C 24 6F 49 83 E5 C0 C4 C1 7D 11 45 20 C5 78 10 15 ?? ?? ?? ?? C5 F8 10 1D ?? ?? ?? ?? C5 FD 54 0D ?? ?? ?? ?? C5 7D 54 0D ?? ?? ?? ?? C4 E3 7D 19 C5 01 C5 F8 C6 E5 DD C5 59 DB 2D ?? ?? ?? ?? C5 91 FA 05 ?? ?? ?? ?? C4 41 61 66 C5 C4 41 79 66 FE C4 C1 79 66 E2 C4 C1 79 DB EF C4 43 51 4A D2 40 C5 91 66 15 ?? ?? ?? ?? C4 C1 61 72 D2 0A C4 41 69 EB E0 C5 F9 7E D9 C4 41 78 50 C4 C4 E3 79 16 D8 01 48 63 C9 48 63 C0 C4 C3 79 16 D9 02 C4 C3 79 16 DA 03 4D 63 C9 4D 63 D2 C5 F9 10 14 11 C5 79 10 1C 10 C5 79 10 64 10 10 C5 F9 10 44 10 20 C5 79 10 44 11 10 C5 79 10 7C 11 20 C5 F9 10 5C 11 30 C4 C3 6D 18 34 11 01 C4 43 25 18 14 12 01 C5 F9 10 54 10 30 C4 41 4D 15 D2 C5 F9 10 74 11 40 C4 43 3D 18 6C 11 10 01 C4 C3 05 18 6C 11 20 01 C4 43 65 18 5C 11 30 01 C4 43 1D 18 74 12 10 01 C4 C3 7D 18 64 12 20 01 C4 C3 6D 18 7C 12 30 01 C5 79 10 44 10 40 C4 41 15 14 E6 C4 41 15 15 EE C5 55 14 F4 C5 55 15 FC C5 A5 14 C7 C5 A5 15 EF C5 79 10 5C 11 50 C5 F9 10 7C 10 50 C4 C3 3D 18 54 12 40 01 C4 43 25 18 44 11 50 01 C4 C3 4D 18 5C 11 40 01 C5 E5 14 E2 C5 E5 15 DA C5 F9 10 74 11 60 C4 43 45 18 5C 12 50 01 C4 C1 3D 14 D3 C4 41 3D 15 DB C5 79 10 44 10 60 C4 C3 4D 18 74 11 60 01 C4 43 3D 18 44 12 60 01 C4 C1 4D 14 F8 C5 75 58 C7 C4 C1 25 59 C8 C5 F5 58 CA C4 C1 75 59 D0 C5 ED 58 DB C4 C1 65 59 F0 C5 CD 58 E4 C4 C1 5D 59 F8 C5 C5 58 ED C4 41 55 59 D8 C5 A5 58 C0 C4 C1 7D 59 C0 C4 41 7D 58 FF C4 C1 05 59 C0 C4 41 7D 58 F6 C4 C1 0D 59 C0 C4 41 7D 58 ED C4 C1 15 59 C0 C4 41 7D 58 E4 C4 41 1D 59 C0 C4 41 3D 58 D2 C4 C1 2D 56 C1 45 85 C0 75 6A C5 FC 10 B4 24 F0 00 00 00 C5 FC 10 BC 24 10 01 00 00 C5 7C 10 84 24 30 01 00 00 C5 7C 10 8C 24 50 01 00 00 C5 7C 10 94 24 70 01 00 00 C5 7C 10 9C 24 90 01 00 00 C5 7C 10 A4 24 B0 01 00 00 C5 7C 10 AC 24 D0 01 00 00 C5 7C 10 B4 24 F0 01 00 00 C5 7C 10 BC 24 D0 00 00 00 4C 8B AC 24 10 02 00 00 48 81 C4 18 02 00 00 C3 C4 C1 7D 10 4D 20 C4 C1 7D 11 45 40 C4 C1 7D 11 4D 00 74 82 33 C0 48 89 5C 24 28 8B D8 48 89 74 24 20 41 8B F0 0F A3 DE 72 1C FF C3 83 FB 20 7C F4 48 8B 5C 24 28 48 8B 74 24 20 C4 C1 7D 10 45 40 E9 50 FF FF FF C5 F8 77 49 8D 4C DD 00 49 8D 54 DD 40 E8 ?? ?? ?? ?? EB D0 66 0F 1F 44 00 00 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "_wutime64"
		size = 305
		refs = "0042 ??_C@_1CE@COJNHJPA@?$AA?$CI?$AA?5?$AAf?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 004e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0063 ??_C@_1FA@GJGIKPLC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAu?$AAt@ 006d _CrtDbgReportW 0081 _errno 00a4 ??_C@_1BE@IDLCCPNN@?$AA_?$AAw?$AAu?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA?$AA@ 00b0 _invalid_parameter 00da _wsopen_s 00f3 _futime64 0112 _close"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 C7 44 24 40 00 00 00 00 48 83 7C 24 60 00 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3A 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3A 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF EB 71 C7 44 24 20 00 00 00 00 41 B9 40 00 00 00 41 B8 02 80 00 00 48 8B 54 24 60 48 8D 4C 24 3C E8 ?? ?? ?? ?? 85 C0 74 07 B8 FF FF FF FF EB 43 48 8B 54 24 68 8B 4C 24 3C E8 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 FF 75 0B E8 ?? ?? ?? ?? 8B 00 89 44 24 40 8B 4C 24 3C E8 ?? ?? ?? ?? 83 7C 24 30 FF 75 0B E8 ?? ?? ?? ?? 8B 4C 24 40 89 08 8B 44 24 30 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_387_1_0 {
	meta:
		name = "_utime32"
		size = 305
		refs = "0042 ??_C@_1CE@COJNHJPA@?$AA?$CI?$AA?5?$AAf?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 004e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0063 ??_C@_1EM@MKFIIHPJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAu?$AAt@ 006d _CrtDbgReportW 0081 _errno 00a4 ??_C@_1BC@HNGMNIFM@?$AA_?$AAu?$AAt?$AAi?$AAm?$AAe?$AA3?$AA2?$AA?$AA@ 00b0 _invalid_parameter 00da _sopen_s 00f3 _futime32 0112 _close"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 C7 44 24 40 00 00 00 00 48 83 7C 24 60 00 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3A 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3A 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF EB 71 C7 44 24 20 00 00 00 00 41 B9 40 00 00 00 41 B8 02 80 00 00 48 8B 54 24 60 48 8D 4C 24 3C E8 ?? ?? ?? ?? 85 C0 74 07 B8 FF FF FF FF EB 43 48 8B 54 24 68 8B 4C 24 3C E8 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 FF 75 0B E8 ?? ?? ?? ?? 8B 00 89 44 24 40 8B 4C 24 3C E8 ?? ?? ?? ?? 83 7C 24 30 FF 75 0B E8 ?? ?? ?? ?? 8B 4C 24 40 89 08 8B 44 24 30 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_72_1_0 {
	meta:
		name = "_utime64"
		size = 305
		refs = "0042 ??_C@_1CE@COJNHJPA@?$AA?$CI?$AA?5?$AAf?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 004e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0063 ??_C@_1FA@GJGIKPLC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAu?$AAt@ 006d _CrtDbgReportW 0081 _errno 00a4 ??_C@_1BC@IMKBGDD@?$AA_?$AAu?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA?$AA@ 00b0 _invalid_parameter 00da _sopen_s 00f3 _futime64 0112 _close"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 C7 44 24 40 00 00 00 00 48 83 7C 24 60 00 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3A 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3A 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF EB 71 C7 44 24 20 00 00 00 00 41 B9 40 00 00 00 41 B8 02 80 00 00 48 8B 54 24 60 48 8D 4C 24 3C E8 ?? ?? ?? ?? 85 C0 74 07 B8 FF FF FF FF EB 43 48 8B 54 24 68 8B 4C 24 3C E8 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 FF 75 0B E8 ?? ?? ?? ?? 8B 00 89 44 24 40 8B 4C 24 3C E8 ?? ?? ?? ?? 83 7C 24 30 FF 75 0B E8 ?? ?? ?? ?? 8B 4C 24 40 89 08 8B 44 24 30 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_1307_0_0 {
	meta:
		name = "_wutime32"
		size = 305
		refs = "0042 ??_C@_1CE@COJNHJPA@?$AA?$CI?$AA?5?$AAf?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 004e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0063 ??_C@_1EM@MKFIIHPJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAu?$AAt@ 006d _CrtDbgReportW 0081 _errno 00a4 ??_C@_1BE@PGBEOBLC@?$AA_?$AAw?$AAu?$AAt?$AAi?$AAm?$AAe?$AA3?$AA2?$AA?$AA@ 00b0 _invalid_parameter 00da _wsopen_s 00f3 _futime32 0112 _close"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 C7 44 24 40 00 00 00 00 48 83 7C 24 60 00 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3A 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3A 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF EB 71 C7 44 24 20 00 00 00 00 41 B9 40 00 00 00 41 B8 02 80 00 00 48 8B 54 24 60 48 8D 4C 24 3C E8 ?? ?? ?? ?? 85 C0 74 07 B8 FF FF FF FF EB 43 48 8B 54 24 68 8B 4C 24 3C E8 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 FF 75 0B E8 ?? ?? ?? ?? 8B 00 89 44 24 40 8B 4C 24 3C E8 ?? ?? ?? ?? 83 7C 24 30 FF 75 0B E8 ?? ?? ?? ?? 8B 4C 24 40 89 08 8B 44 24 30 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_36_0_0 {
	meta:
		name = "conjl"
		size = 151
		refs = "002a creall 0057 cimagl 005e __xmm@80000000000000008000000000000000"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 58 48 8D 44 24 30 48 8B F8 48 8B 74 24 78 B9 10 00 00 00 F3 A4 48 8D 4C 24 30 E8 ?? ?? ?? ?? B8 08 00 00 00 48 6B C0 00 F2 0F 11 44 04 20 48 8D 44 24 40 48 8B F8 48 8B 74 24 78 B9 10 00 00 00 F3 A4 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? B8 08 00 00 00 48 6B C0 01 F2 0F 11 44 04 20 B8 08 00 00 00 48 6B C0 00 48 8B 7C 24 70 48 8D 74 04 20 B9 10 00 00 00 F3 A4 48 8B 44 24 70 48 83 C4 58 5F 5E C3 }
	condition:
		$1
}

rule file_382_0_0 {
	meta:
		name = "conj"
		size = 151
		refs = "002a creal 0057 cimag 005e __xmm@80000000000000008000000000000000"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 83 EC 58 48 8D 44 24 30 48 8B F8 48 8B 74 24 78 B9 10 00 00 00 F3 A4 48 8D 4C 24 30 E8 ?? ?? ?? ?? B8 08 00 00 00 48 6B C0 00 F2 0F 11 44 04 20 48 8D 44 24 40 48 8B F8 48 8B 74 24 78 B9 10 00 00 00 F3 A4 48 8D 4C 24 40 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? B8 08 00 00 00 48 6B C0 01 F2 0F 11 44 04 20 B8 08 00 00 00 48 6B C0 00 48 8B 7C 24 70 48 8D 74 04 20 B9 10 00 00 00 F3 A4 48 8B 44 24 70 48 83 C4 58 5F 5E C3 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "_fptrap"
		size = 19
		refs = "000a _amsg_exit"
	strings:
		$1 = { 48 83 EC 28 B9 02 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_43_1_0 {
	meta:
		name = "_wdupenv_s"
		size = 67
		refs = "003a _wdupenv_s_dbg"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 01 00 00 00 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1222_0_0 {
	meta:
		name = "_dupenv_s"
		size = 67
		refs = "003a _dupenv_s_dbg"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 01 00 00 00 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_666_0_0 {
	meta:
		name = "_fullpath"
		size = 67
		refs = "003a _fullpath_dbg"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 01 00 00 00 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_784_0_0 {
	meta:
		name = "_wfullpath"
		size = 67
		refs = "003a _wfullpath_dbg"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 01 00 00 00 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_43_2_0 {
	meta:
		name = "_wdupenv_s_dbg"
		size = 109
		refs = "0026 _lock 0052 _wdupenv_s_helper 0060 _unlock"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 30 00 00 00 00 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 8B 44 24 78 89 44 24 28 48 8B 44 24 70 48 89 44 24 20 44 8B 4C 24 68 4C 8B 44 24 60 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 30 B9 07 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1222_1_0 {
	meta:
		name = "_dupenv_s_dbg"
		size = 109
		refs = "0026 _lock 0052 _dupenv_s_helper 0060 _unlock"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 C7 44 24 30 00 00 00 00 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 8B 44 24 78 89 44 24 28 48 8B 44 24 70 48 89 44 24 20 44 8B 4C 24 68 4C 8B 44 24 60 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 30 B9 07 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_43_3_0 {
	meta:
		name = "_wdupenv_s_dbg$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_dupenv_s_dbg$fin$0 _putenv_s$fin$0 _wgetenv$fin$0 _wputenv_s$fin$0 getenv$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_43_4_0 {
	meta:
		name = "_wdupenv_s_helper"
		size = 614
		refs = "0044 ??_C@_1CA@FHNFMDOJ@?$AAp?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0050 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0065 ??_C@_1EO@JOEHPJNP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAg?$AAe@ 006f _CrtDbgReportW 0083 _errno 00a6 ??_C@_1CE@MOMAOPON@?$AA_?$AAw?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 00b2 _invalid_parameter 010c ??_C@_1CA@GDBKELOE@?$AAv?$AAa?$AAr?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 018e _wgetenv_helper_nolock 01ac wcslen 01db _calloc_dbg 0219 wcscpy_s 023f ??_C@_1DM@LFOGKHPJ@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?$CK?$AAp?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AAs?$AAt?$AAr?$AA?$CJ?$AA?$AA@ 0246 _invoke_watson_if_error"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 83 7C 24 60 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 58 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 58 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 A1 01 00 00 48 8B 44 24 60 48 C7 00 00 00 00 00 48 83 7C 24 68 00 74 0C 48 8B 44 24 68 48 C7 00 00 00 00 00 48 83 7C 24 70 00 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 5E 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 5E 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 D9 00 00 00 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 75 07 33 C0 E9 BB 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 FF C0 48 89 44 24 48 8B 84 24 88 00 00 00 89 44 24 20 4C 8B 8C 24 80 00 00 00 44 8B 44 24 78 BA 02 00 00 00 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 4C 24 60 48 89 01 48 8B 44 24 60 48 83 38 00 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 5B 4C 8B 44 24 40 48 8B 54 24 48 48 8B 44 24 60 48 8B 08 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 72 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 83 7C 24 68 00 74 0D 48 8B 44 24 68 48 8B 4C 24 48 48 89 08 33 C0 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_43_5_0 {
	meta:
		name = "_wgetenv"
		size = 406
		refs = "003e ??_C@_1CC@FKAOHHLO@?$AA?$CI?$AAo?$AAp?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004a ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 005f ??_C@_1EO@JOEHPJNP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAg?$AAe@ 0069 _CrtDbgReportW 007d _errno 00a0 ??_C@_1BC@JKMINHGI@?$AA_?$AAw?$AAg?$AAe?$AAt?$AAe?$AAn?$AAv?$AA?$AA@ 00ac _invalid_parameter 00c2 wcsnlen 00f2 ??_C@_1FA@HILOOCMA@?$AA?$CI?$AA_?$AAt?$AAc?$AAs?$AAn?$AAl?$AAe?$AAn?$AA?$CI?$AAo?$AAp?$AAt?$AAi?$AAo?$AAn?$AA?0?$AA?5?$AA_?$AAM?$AAA?$AAX?$AA_?$AAE?$AAN?$AAV?$AA?$CJ?$AA?5?$AA?$DM?$AA?5?$AA_?$AAM@ 016e _lock 0179 _wgetenv_helper_nolock 0188 _unlock"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 58 48 C7 44 24 40 00 00 00 00 48 83 7C 24 60 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 4E 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 4E 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 DA 00 00 00 BA FF 7F 00 00 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 3D FF 7F 00 00 73 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 4F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 4F 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 EB 29 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 89 44 24 40 B9 07 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_1222_7_0 {
	meta:
		name = "getenv"
		size = 406
		refs = "003e ??_C@_1CC@FKAOHHLO@?$AA?$CI?$AAo?$AAp?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004a ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 005f ??_C@_1EO@JOEHPJNP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAg?$AAe@ 0069 _CrtDbgReportW 007d _errno 00a0 ??_C@_1O@GMKGKCJO@?$AAg?$AAe?$AAt?$AAe?$AAn?$AAv?$AA?$AA@ 00ac _invalid_parameter 00c2 strnlen 00f2 ??_C@_1FA@HILOOCMA@?$AA?$CI?$AA_?$AAt?$AAc?$AAs?$AAn?$AAl?$AAe?$AAn?$AA?$CI?$AAo?$AAp?$AAt?$AAi?$AAo?$AAn?$AA?0?$AA?5?$AA_?$AAM?$AAA?$AAX?$AA_?$AAE?$AAN?$AAV?$AA?$CJ?$AA?5?$AA?$DM?$AA?5?$AA_?$AAM@ 016e _lock 0179 _getenv_helper_nolock 0188 _unlock"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 58 48 C7 44 24 40 00 00 00 00 48 83 7C 24 60 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 4E 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 4E 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 DA 00 00 00 BA FF 7F 00 00 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 3D FF 7F 00 00 73 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 4F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 4F 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 EB 29 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 89 44 24 40 B9 07 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_43_7_0 {
	meta:
		name = "_wgetenv_helper_nolock"
		size = 378
		refs = "000c _wenviron 0017 __env_initialized 0030 _environ 0038 __crtGetEnvironmentStringsW 003f _wenvptr 0044 _wsetenvp 004d __mbtow_environ 0086 wcslen 00e3 _wcsnicoll 0106 wcsnlen 0115 ??_C@_1GI@JBIFPFJH@?$AA_?$AAt?$AAc?$AAs?$AAn?$AAl?$AAe?$AAn?$AA?$CI?$AA?$CK?$AAs?$AAe?$AAa?$AAr?$AAc?$AAh?$AA?5?$AA?$CL?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?0?$AA?5?$AA_@ 0121 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0136 ??_C@_1EO@JOEHPJNP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAg?$AAe@ 0140 _CrtDbgReportW"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 05 ?? ?? ?? ?? 48 89 44 24 30 83 3D ?? ?? ?? ?? 00 75 07 33 C0 E9 50 01 00 00 48 83 7C 24 30 00 75 3B 48 83 3D ?? ?? ?? ?? 00 74 31 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 10 E8 ?? ?? ?? ?? 85 C0 74 07 33 C0 E9 19 01 00 00 48 8B 05 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 0F 84 FF 00 00 00 48 83 7C 24 50 00 0F 84 F3 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 38 48 8B 44 24 30 48 83 38 00 0F 84 D5 00 00 00 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 3B 44 24 38 0F 86 AA 00 00 00 48 8B 44 24 30 48 8B 00 48 8B 4C 24 38 0F B7 04 48 83 F8 3D 0F 85 90 00 00 00 4C 8B 44 24 38 48 8B 54 24 50 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 85 C0 75 75 48 8B 44 24 30 48 8B 00 48 8B 4C 24 38 48 8D 44 48 02 BA FF 7F 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 3D FF 7F 00 00 72 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 9F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 30 48 8B 00 48 8B 4C 24 38 48 8D 44 48 02 EB 15 48 8B 44 24 30 48 83 C0 08 48 89 44 24 30 E9 1C FF FF FF 33 C0 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_43_8_0 {
	meta:
		name = "_wgetenv_s"
		size = 91
		refs = "0026 _lock 0040 _wgetenv_s_helper 004e _unlock"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 4C 8B 4C 24 58 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 20 B9 07 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1222_9_0 {
	meta:
		name = "getenv_s"
		size = 91
		refs = "0026 _lock 0040 _getenv_s_helper 004e _unlock"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 4C 8B 4C 24 58 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 20 B9 07 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_43_9_0 {
	meta:
		name = "_wgetenv_s$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_putenv$fin$0 _wputenv$fin$0 getenv_s$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_43_10_0 {
	meta:
		name = "_wgetenv_s_helper"
		size = 568
		refs = "0044 ??_C@_1CK@PIKDAOCL@?$AAp?$AAR?$AAe?$AAt?$AAu?$AAr?$AAn?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0050 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0065 ??_C@_1EO@JOEHPJNP@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAg?$AAe@ 006f _CrtDbgReportW 0083 _errno 00a6 ??_C@_1CE@HBOECPCE@?$AA_?$AAw?$AAg?$AAe?$AAt?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAh?$AAe?$AAl?$AAp?$AAe?$AAr?$AA?$AA@ 00b2 _invalid_parameter 0110 ??_C@_1JM@NLPGJJPH@?$AA?$CI?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?5@ 01a4 _wgetenv_helper_nolock 01bf wcslen 0200 wcscpy_s 0226 ??_C@_1EI@EBFBEMM@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAT?$AAC?$AAh?$AAa?$AAr?$AAs?$AA?0?$AA?5?$AAs@ 022d _invoke_watson_if_error"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 83 7C 24 60 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 E0 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 E0 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 73 01 00 00 48 8B 44 24 60 48 C7 00 00 00 00 00 48 83 7C 24 68 00 74 08 48 83 7C 24 70 00 77 1A 48 83 7C 24 68 00 75 08 48 83 7C 24 70 00 74 0A C7 44 24 38 00 00 00 00 EB 08 C7 44 24 38 01 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 E2 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 E2 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 A7 00 00 00 48 83 7C 24 68 00 74 0A 33 C0 48 8B 4C 24 68 66 89 01 48 8B 4C 24 78 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 75 04 33 C0 EB 7A 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 FF C0 48 8B 4C 24 60 48 89 01 48 83 7C 24 70 00 75 04 33 C0 EB 59 48 8B 44 24 60 48 8B 4C 24 70 48 39 08 76 07 B8 22 00 00 00 EB 43 4C 8B 44 24 40 48 8B 54 24 70 48 8B 4C 24 68 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 FE 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 33 C0 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "wcschr"
		size = 337
	strings:
		$1 = { 66 89 54 24 10 48 89 4C 24 08 48 83 EC 48 0F B7 44 24 58 66 0F 6E C0 66 0F 7F 44 24 20 F2 0F 70 44 24 20 00 66 0F 7F 44 24 20 66 0F 6F 44 24 20 66 0F 70 C0 00 66 0F 7F 44 24 20 48 8B 44 24 50 48 25 FF 0F 00 00 48 3D F0 0F 00 00 0F 87 BF 00 00 00 48 8B 44 24 50 F3 0F 6F 00 66 0F 7F 44 24 30 66 0F 6F 44 24 10 66 0F EF 44 24 10 66 0F 7F 44 24 10 66 0F 6F 44 24 10 66 0F 75 44 24 30 66 0F 7F 44 24 10 66 0F 6F 44 24 30 66 0F 75 44 24 20 66 0F 7F 44 24 30 66 0F 6F 44 24 10 66 0F EB 44 24 30 66 0F 7F 44 24 10 66 0F 6F 44 24 10 66 0F D7 C0 89 04 24 83 3C 24 00 74 45 8B 04 24 0F BC C0 89 44 24 04 8B 44 24 04 48 03 44 24 50 48 89 44 24 50 48 8B 44 24 50 0F B7 00 0F B7 4C 24 58 3B C1 75 0C 48 8B 44 24 50 48 89 44 24 08 EB 09 48 C7 44 24 08 00 00 00 00 48 8B 44 24 08 EB 4B 48 8B 44 24 50 48 83 C0 10 48 89 44 24 50 EB 36 48 8B 44 24 50 0F B7 00 0F B7 4C 24 58 3B C1 75 07 48 8B 44 24 50 EB 23 48 8B 44 24 50 0F B7 00 85 C0 75 04 33 C0 EB 13 48 8B 44 24 50 48 83 C0 02 48 89 44 24 50 E9 EF FE FF FF 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_45_1_0 {
	meta:
		name = "catanhl"
		size = 1649
		refs = "0036 creall 0063 cimagl 0073 _ldtest 00df piby2 00e6 __xmm@80000000000000008000000000000000 0170 _LZero_C 0301 big 0324 __real@3ff0000000000000 047e __real@4010000000000000 04a2 log1pl 04aa __real@3fd0000000000000 04e3 __real@4000000000000000 0503 atan2l 050b __real@3fe0000000000000 052b __real@0000000000000000 0539 _fperrraise 0541 _LInf_C 0578 sqrtl 05a6 logl 0649 _LCbuild"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC 08 01 00 00 48 8D 84 24 D0 00 00 00 48 8B F8 48 8B B4 24 28 01 00 00 B9 10 00 00 00 F3 A4 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? F2 0F 11 44 24 30 48 8D 84 24 E0 00 00 00 48 8B F8 48 8B B4 24 28 01 00 00 B9 10 00 00 00 F3 A4 48 8D 8C 24 E0 00 00 00 E8 ?? ?? ?? ?? F2 0F 11 44 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 89 44 24 28 48 8D 4C 24 20 E8 ?? ?? ?? ?? 66 89 44 24 38 0F BF 44 24 28 83 F8 02 0F 85 9B 00 00 00 0F BF 44 24 38 83 F8 02 75 1A F2 0F 10 44 24 30 F2 0F 11 44 24 48 F2 0F 10 44 24 20 F2 0F 11 44 24 40 EB 72 0F BF 44 24 38 83 F8 01 75 50 0F 57 C0 F2 0F 11 44 24 48 0F 57 C0 66 0F 2F 44 24 20 76 1A F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 EB 11 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 F2 0F 10 84 24 80 00 00 00 F2 0F 11 44 24 40 EB 18 F2 0F 10 44 24 30 F2 0F 11 44 24 48 F2 0F 10 44 24 30 F2 0F 11 44 24 40 E9 00 05 00 00 0F BF 44 24 38 83 F8 02 0F 85 81 00 00 00 0F BF 44 24 28 83 F8 01 74 09 0F BF 44 24 28 85 C0 75 51 B8 02 00 00 00 48 6B C0 03 0F B7 44 04 30 25 00 80 00 00 85 C0 74 17 F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 70 EB 09 0F 57 C0 F2 0F 11 44 24 70 F2 0F 10 44 24 70 F2 0F 11 44 24 48 F2 0F 10 44 24 20 F2 0F 11 44 24 40 EB 18 F2 0F 10 44 24 20 F2 0F 11 44 24 48 F2 0F 10 44 24 20 F2 0F 11 44 24 40 E9 71 04 00 00 0F BF 44 24 28 83 F8 01 0F 85 96 00 00 00 0F 57 C0 66 0F 2F 44 24 30 76 1A F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 84 24 A0 00 00 00 EB 0C 0F 57 C0 F2 0F 11 84 24 A0 00 00 00 F2 0F 10 84 24 A0 00 00 00 F2 0F 11 44 24 48 B8 02 00 00 00 48 6B C0 03 0F B7 44 04 20 25 00 80 00 00 85 C0 74 1A F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 84 24 90 00 00 00 EB 11 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 84 24 90 00 00 00 F2 0F 10 84 24 90 00 00 00 F2 0F 11 44 24 40 E9 CD 03 00 00 B8 02 00 00 00 48 6B C0 03 0F B7 44 04 20 25 00 80 00 00 85 C0 74 18 F2 0F 10 44 24 20 0F 57 05 ?? ?? ?? ?? F2 0F 11 84 24 B0 00 00 00 EB 0F F2 0F 10 44 24 20 F2 0F 11 84 24 B0 00 00 00 F2 0F 10 84 24 B0 00 00 00 F2 0F 11 44 24 50 0F 57 C0 66 0F 2F 44 24 30 76 1D C7 44 24 58 01 00 00 00 F2 0F 10 44 24 30 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 30 EB 1B C7 44 24 58 00 00 00 00 F2 0F 10 44 24 20 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 20 F2 0F 10 44 24 30 66 0F 2F 05 ?? ?? ?? ?? 0F 86 98 00 00 00 F2 0F 10 44 24 20 F2 0F 5E 44 24 30 F2 0F 11 84 24 A8 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5E 44 24 30 F2 0F 10 8C 24 A8 00 00 00 F2 0F 59 8C 24 A8 00 00 00 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 5E C1 F2 0F 11 44 24 48 0F 57 C0 66 0F 2F 44 24 20 76 1A F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 84 24 98 00 00 00 EB 11 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 84 24 98 00 00 00 F2 0F 10 84 24 98 00 00 00 F2 0F 11 44 24 40 E9 62 02 00 00 F2 0F 10 44 24 50 66 0F 2F 05 ?? ?? ?? ?? 0F 86 84 00 00 00 F2 0F 10 44 24 30 F2 0F 5E 44 24 20 F2 0F 11 44 24 60 F2 0F 10 44 24 60 F2 0F 5E 44 24 20 F2 0F 10 4C 24 60 F2 0F 59 4C 24 60 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 5E C1 F2 0F 11 44 24 48 0F 57 C0 66 0F 2F 44 24 20 76 17 F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 78 EB 0E F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 44 24 78 F2 0F 10 44 24 78 F2 0F 11 44 24 40 E9 CA 01 00 00 F2 0F 10 44 24 30 66 0F 2E 05 ?? ?? ?? ?? 7A 06 0F 84 D0 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5C 44 24 30 F2 0F 11 44 24 68 F2 0F 10 44 24 50 F2 0F 59 44 24 50 F2 0F 11 84 24 88 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 44 24 30 F2 0F 10 4C 24 68 F2 0F 59 4C 24 68 F2 0F 58 8C 24 88 00 00 00 F2 0F 5E C1 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C1 F2 0F 11 44 24 48 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 44 24 30 F2 0F 10 4C 24 68 F2 0F 59 C8 0F 28 C1 F2 0F 5C 84 24 88 00 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 4C 24 20 F2 0F 11 8C 24 B8 00 00 00 0F 28 C8 F2 0F 10 84 24 B8 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C1 F2 0F 11 44 24 40 E9 E4 00 00 00 F2 0F 10 44 24 20 66 0F 2E 05 ?? ?? ?? ?? 7A 2B 75 29 B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 44 24 48 F2 0F 10 44 24 20 F2 0F 11 44 24 40 E9 A9 00 00 00 F2 0F 10 44 24 20 F2 0F 59 44 24 20 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C8 0F 28 C1 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? F2 0F 11 84 24 C0 00 00 00 F2 0F 10 44 24 50 E8 ?? ?? ?? ?? F2 0F 10 8C 24 C0 00 00 00 F2 0F 5E C8 0F 28 C1 E8 ?? ?? ?? ?? F2 0F 11 44 24 48 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 44 24 50 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C8 0F 28 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C1 F2 0F 11 44 24 40 0F 57 C0 66 0F 2F 44 24 20 76 13 F2 0F 10 44 24 40 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 40 83 7C 24 58 00 74 15 F2 0F 10 44 24 48 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 48 EB 13 F2 0F 10 44 24 40 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 40 F2 0F 10 54 24 40 F2 0F 10 4C 24 48 48 8D 8C 24 F0 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 20 01 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 20 01 00 00 48 81 C4 08 01 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_1301_0_0 {
	meta:
		name = "catanh"
		size = 1649
		refs = "0036 creal 0063 cimag 0073 _dtest 00df piby2 00e6 __xmm@80000000000000008000000000000000 0170 _Zero_C 0301 big 0324 __real@3ff0000000000000 047e __real@4010000000000000 04a2 log1p 04aa __real@3fd0000000000000 04e3 __real@4000000000000000 0503 atan2 050b __real@3fe0000000000000 052b __real@0000000000000000 0539 _fperrraise 0541 _Inf_C 0578 sqrt 05a6 log 0649 _Cbuild"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC 08 01 00 00 48 8D 84 24 D0 00 00 00 48 8B F8 48 8B B4 24 28 01 00 00 B9 10 00 00 00 F3 A4 48 8D 8C 24 D0 00 00 00 E8 ?? ?? ?? ?? F2 0F 11 44 24 30 48 8D 84 24 E0 00 00 00 48 8B F8 48 8B B4 24 28 01 00 00 B9 10 00 00 00 F3 A4 48 8D 8C 24 E0 00 00 00 E8 ?? ?? ?? ?? F2 0F 11 44 24 20 48 8D 4C 24 30 E8 ?? ?? ?? ?? 66 89 44 24 28 48 8D 4C 24 20 E8 ?? ?? ?? ?? 66 89 44 24 38 0F BF 44 24 28 83 F8 02 0F 85 9B 00 00 00 0F BF 44 24 38 83 F8 02 75 1A F2 0F 10 44 24 30 F2 0F 11 44 24 48 F2 0F 10 44 24 20 F2 0F 11 44 24 40 EB 72 0F BF 44 24 38 83 F8 01 75 50 0F 57 C0 F2 0F 11 44 24 48 0F 57 C0 66 0F 2F 44 24 20 76 1A F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 EB 11 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 F2 0F 10 84 24 80 00 00 00 F2 0F 11 44 24 40 EB 18 F2 0F 10 44 24 30 F2 0F 11 44 24 48 F2 0F 10 44 24 30 F2 0F 11 44 24 40 E9 00 05 00 00 0F BF 44 24 38 83 F8 02 0F 85 81 00 00 00 0F BF 44 24 28 83 F8 01 74 09 0F BF 44 24 28 85 C0 75 51 B8 02 00 00 00 48 6B C0 03 0F B7 44 04 30 25 00 80 00 00 85 C0 74 17 F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 70 EB 09 0F 57 C0 F2 0F 11 44 24 70 F2 0F 10 44 24 70 F2 0F 11 44 24 48 F2 0F 10 44 24 20 F2 0F 11 44 24 40 EB 18 F2 0F 10 44 24 20 F2 0F 11 44 24 48 F2 0F 10 44 24 20 F2 0F 11 44 24 40 E9 71 04 00 00 0F BF 44 24 28 83 F8 01 0F 85 96 00 00 00 0F 57 C0 66 0F 2F 44 24 30 76 1A F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 84 24 A0 00 00 00 EB 0C 0F 57 C0 F2 0F 11 84 24 A0 00 00 00 F2 0F 10 84 24 A0 00 00 00 F2 0F 11 44 24 48 B8 02 00 00 00 48 6B C0 03 0F B7 44 04 20 25 00 80 00 00 85 C0 74 1A F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 84 24 90 00 00 00 EB 11 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 84 24 90 00 00 00 F2 0F 10 84 24 90 00 00 00 F2 0F 11 44 24 40 E9 CD 03 00 00 B8 02 00 00 00 48 6B C0 03 0F B7 44 04 20 25 00 80 00 00 85 C0 74 18 F2 0F 10 44 24 20 0F 57 05 ?? ?? ?? ?? F2 0F 11 84 24 B0 00 00 00 EB 0F F2 0F 10 44 24 20 F2 0F 11 84 24 B0 00 00 00 F2 0F 10 84 24 B0 00 00 00 F2 0F 11 44 24 50 0F 57 C0 66 0F 2F 44 24 30 76 1D C7 44 24 58 01 00 00 00 F2 0F 10 44 24 30 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 30 EB 1B C7 44 24 58 00 00 00 00 F2 0F 10 44 24 20 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 20 F2 0F 10 44 24 30 66 0F 2F 05 ?? ?? ?? ?? 0F 86 98 00 00 00 F2 0F 10 44 24 20 F2 0F 5E 44 24 30 F2 0F 11 84 24 A8 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5E 44 24 30 F2 0F 10 8C 24 A8 00 00 00 F2 0F 59 8C 24 A8 00 00 00 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 5E C1 F2 0F 11 44 24 48 0F 57 C0 66 0F 2F 44 24 20 76 1A F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 84 24 98 00 00 00 EB 11 F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 84 24 98 00 00 00 F2 0F 10 84 24 98 00 00 00 F2 0F 11 44 24 40 E9 62 02 00 00 F2 0F 10 44 24 50 66 0F 2F 05 ?? ?? ?? ?? 0F 86 84 00 00 00 F2 0F 10 44 24 30 F2 0F 5E 44 24 20 F2 0F 11 44 24 60 F2 0F 10 44 24 60 F2 0F 5E 44 24 20 F2 0F 10 4C 24 60 F2 0F 59 4C 24 60 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 D1 0F 28 CA F2 0F 5E C1 F2 0F 11 44 24 48 0F 57 C0 66 0F 2F 44 24 20 76 17 F2 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 78 EB 0E F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 44 24 78 F2 0F 10 44 24 78 F2 0F 11 44 24 40 E9 CA 01 00 00 F2 0F 10 44 24 30 66 0F 2E 05 ?? ?? ?? ?? 7A 06 0F 84 D0 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5C 44 24 30 F2 0F 11 44 24 68 F2 0F 10 44 24 50 F2 0F 59 44 24 50 F2 0F 11 84 24 88 00 00 00 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 44 24 30 F2 0F 10 4C 24 68 F2 0F 59 4C 24 68 F2 0F 58 8C 24 88 00 00 00 F2 0F 5E C1 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C1 F2 0F 11 44 24 48 F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 44 24 30 F2 0F 10 4C 24 68 F2 0F 59 C8 0F 28 C1 F2 0F 5C 84 24 88 00 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 4C 24 20 F2 0F 11 8C 24 B8 00 00 00 0F 28 C8 F2 0F 10 84 24 B8 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C1 F2 0F 11 44 24 40 E9 E4 00 00 00 F2 0F 10 44 24 20 66 0F 2E 05 ?? ?? ?? ?? 7A 2B 75 29 B9 04 00 00 00 E8 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 0F 11 44 24 48 F2 0F 10 44 24 20 F2 0F 11 44 24 40 E9 A9 00 00 00 F2 0F 10 44 24 20 F2 0F 59 44 24 20 F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C8 0F 28 C1 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? F2 0F 11 84 24 C0 00 00 00 F2 0F 10 44 24 50 E8 ?? ?? ?? ?? F2 0F 10 8C 24 C0 00 00 00 F2 0F 5E C8 0F 28 C1 E8 ?? ?? ?? ?? F2 0F 11 44 24 48 F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 44 24 50 E8 ?? ?? ?? ?? F2 0F 10 0D ?? ?? ?? ?? F2 0F 58 C8 0F 28 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C1 F2 0F 11 44 24 40 0F 57 C0 66 0F 2F 44 24 20 76 13 F2 0F 10 44 24 40 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 40 83 7C 24 58 00 74 15 F2 0F 10 44 24 48 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 48 EB 13 F2 0F 10 44 24 40 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 40 F2 0F 10 54 24 40 F2 0F 10 4C 24 48 48 8D 8C 24 F0 00 00 00 E8 ?? ?? ?? ?? 48 8B BC 24 20 01 00 00 48 8B F0 B9 10 00 00 00 F3 A4 48 8B 84 24 20 01 00 00 48 81 C4 08 01 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "_wprintf_l"
		size = 59
		refs = "0032 _vwprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_825_4_0 {
	meta:
		name = "_cprintf_l"
		size = 59
		refs = "0032 _vcprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_110_4_0 {
	meta:
		name = "_cprintf_p_l"
		size = 59
		refs = "0032 _vcprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_763_4_0 {
	meta:
		name = "_cprintf_s_l"
		size = 59
		refs = "0032 _vcprintf_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_432_7_0 {
	meta:
		name = "_cscanf_l"
		size = 59
		refs = "0032 _cprinput_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_292_7_0 {
	meta:
		name = "_cscanf_s_l"
		size = 59
		refs = "0032 _cprinput_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_706_4_0 {
	meta:
		name = "_cwprintf_l"
		size = 59
		refs = "0032 _vcwprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1054_4_0 {
	meta:
		name = "_cwprintf_p_l"
		size = 59
		refs = "0032 _vcwprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_653_4_0 {
	meta:
		name = "_cwprintf_s_l"
		size = 59
		refs = "0032 _vcwprintf_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_160_7_0 {
	meta:
		name = "_cwscanf_l"
		size = 59
		refs = "0032 _cprinput_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_655_7_0 {
	meta:
		name = "_cwscanf_s_l"
		size = 59
		refs = "0032 _cprinput_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1229_1_0 {
	meta:
		name = "_printf_l"
		size = 59
		refs = "0032 _vprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1229_3_0 {
	meta:
		name = "_printf_p_l"
		size = 59
		refs = "0032 _vprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1229_4_0 {
	meta:
		name = "_printf_s_l"
		size = 59
		refs = "0032 _vprintf_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_391_1_0 {
	meta:
		name = "_scprintf_l"
		size = 59
		refs = "0032 _vscprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_391_3_0 {
	meta:
		name = "_scprintf_p_l"
		size = 59
		refs = "0032 _vscprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1277_2_0 {
	meta:
		name = "_scwprintf_l"
		size = 59
		refs = "0032 _vscwprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1277_4_0 {
	meta:
		name = "_scwprintf_p_l"
		size = 59
		refs = "0032 _vscwprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_47_2_0 {
	meta:
		name = "_wprintf_p_l"
		size = 59
		refs = "0032 _vwprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_47_3_0 {
	meta:
		name = "_wprintf_s_l"
		size = 59
		refs = "0032 _vwprintf_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 50 48 89 44 24 20 4C 8B 44 24 20 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_47_1_0 {
	meta:
		name = "_wprintf_p"
		size = 56
		refs = "002f _vwprintf_p_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_825_3_0 {
	meta:
		name = "_cprintf"
		size = 56
		refs = "002f _vcprintf_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_110_3_0 {
	meta:
		name = "_cprintf_p"
		size = 56
		refs = "002f _vcprintf_p_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_763_3_0 {
	meta:
		name = "_cprintf_s"
		size = 56
		refs = "002f _vcprintf_s_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_432_6_0 {
	meta:
		name = "_cscanf"
		size = 56
		refs = "002f _cprinput_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_292_6_0 {
	meta:
		name = "_cscanf_s"
		size = 56
		refs = "002f _cprinput_s_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_706_3_0 {
	meta:
		name = "_cwprintf"
		size = 56
		refs = "002f _vcwprintf_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1054_3_0 {
	meta:
		name = "_cwprintf_p"
		size = 56
		refs = "002f _vcwprintf_p_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_653_3_0 {
	meta:
		name = "_cwprintf_s"
		size = 56
		refs = "002f _vcwprintf_s_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_160_6_0 {
	meta:
		name = "_cwscanf"
		size = 56
		refs = "002f _cprinput_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_655_6_0 {
	meta:
		name = "_cwscanf_s"
		size = 56
		refs = "002f _cprinput_s_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1229_2_0 {
	meta:
		name = "_printf_p"
		size = 56
		refs = "002f _vprintf_p_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1229_8_0 {
	meta:
		name = "printf_s"
		size = 56
		refs = "002f _vprintf_s_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_47_6_0 {
	meta:
		name = "wprintf_s"
		size = 56
		refs = "002f _vwprintf_s_l"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 38 48 8D 44 24 48 48 89 44 24 20 4C 8B 44 24 20 33 D2 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_47_4_0 {
	meta:
		name = "wprintf"
		size = 381
		refs = "004c ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0058 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006d ??_C@_1FC@NOFHGAIN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAi?$AAo?$AA?2?$AAw@ 0077 _CrtDbgReportW 008b _errno 00ae ??_C@_1BA@HFKICJND@?$AAw?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?$AA@ 00ba _invalid_parameter 00d3 __iob_func 00ec _lock_file2 0106 _stbuf 0130 _woutput_l 0151 _ftbuf 0170 _unlock_file2"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 58 C7 44 24 38 00 00 00 00 48 83 7C 24 60 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 36 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 36 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 B0 00 00 00 48 8D 44 24 68 48 89 44 24 40 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 01 48 03 C1 48 8B D0 B9 01 00 00 00 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 01 48 03 C1 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 3C E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 01 48 03 C1 4C 8B 4C 24 40 45 33 C0 48 8B 54 24 60 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 38 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 01 48 03 C1 48 8B D0 8B 4C 24 3C E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 01 48 03 C1 48 8B D0 B9 01 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 38 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_1229_6_0 {
	meta:
		name = "printf"
		size = 381
		refs = "004c ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0058 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006d ??_C@_1FA@GMJBBNDK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAi?$AAo?$AA?2?$AAp@ 0077 _CrtDbgReportW 008b _errno 00ae ??_C@_1O@GKDHFACN@?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA?$AA@ 00ba _invalid_parameter 00d3 __iob_func 00ec _lock_file2 0106 _stbuf 0130 _output_l 0151 _ftbuf 0170 _unlock_file2"
	strings:
		$1 = { 48 89 4C 24 08 48 89 54 24 10 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 58 C7 44 24 38 00 00 00 00 48 83 7C 24 60 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 36 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 36 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 B0 00 00 00 48 8D 44 24 68 48 89 44 24 40 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 01 48 03 C1 48 8B D0 B9 01 00 00 00 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 01 48 03 C1 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 3C E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 01 48 03 C1 4C 8B 4C 24 40 45 33 C0 48 8B 54 24 60 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 38 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 01 48 03 C1 48 8B D0 8B 4C 24 3C E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? B9 30 00 00 00 48 6B C9 01 48 03 C1 48 8B D0 B9 01 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 38 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_47_5_0 {
	meta:
		name = "wprintf$fin$0"
		size = 48
		refs = "000a __iob_func 0024 _unlock_file2"
		altNames = "_putws$fin$0 printf$fin$0 puts$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA E8 ?? ?? ?? ?? 90 B9 30 00 00 00 48 6B C9 01 48 03 C1 48 8B D0 B9 01 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "_getw"
		size = 446
		refs = "0052 ??_C@_1BM@JMKHIAHP@?$AA?$CI?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 005e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0073 ??_C@_1EM@IDFILPKE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAi?$AAo?$AA?2?$AAg@ 007d _CrtDbgReportW 0091 _errno 00b4 ??_C@_1M@HKOJKMJ@?$AA_?$AAg?$AAe?$AAt?$AAw?$AA?$AA@ 00c0 _invalid_parameter 00e1 _lock_file 014f _filbuf 017b feof 0189 ferror 01b1 _unlock_file"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 C7 44 24 38 04 00 00 00 48 8D 44 24 58 48 89 44 24 60 C7 44 24 40 00 00 00 00 48 83 BC 24 80 00 00 00 00 74 0A C7 44 24 44 01 00 00 00 EB 08 C7 44 24 44 00 00 00 00 8B 44 24 44 89 44 24 4C 83 7C 24 4C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 30 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 4C 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 30 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 EB 00 00 00 48 8B 84 24 80 00 00 00 48 89 44 24 30 48 8B 4C 24 30 E8 ?? ?? ?? ?? 90 8B 44 24 38 89 44 24 54 8B 44 24 38 FF C8 89 44 24 38 83 7C 24 54 00 74 76 48 8B 44 24 30 8B 40 08 FF C8 89 44 24 48 48 8B 44 24 30 8B 4C 24 48 89 48 08 83 7C 24 48 00 7C 29 48 8B 44 24 30 48 8B 00 0F BE 00 25 FF 00 00 00 89 44 24 50 48 8B 44 24 30 48 8B 00 48 FF C0 48 8B 4C 24 30 48 89 01 EB 0E 48 8B 4C 24 30 E8 ?? ?? ?? ?? 89 44 24 50 48 8B 44 24 60 0F B6 4C 24 50 88 08 48 8B 44 24 60 48 FF C0 48 89 44 24 60 E9 71 FF FF FF 48 8B 4C 24 30 E8 ?? ?? ?? ?? 85 C0 75 18 48 8B 4C 24 30 E8 ?? ?? ?? ?? 85 C0 75 0A 8B 44 24 58 89 44 24 3C EB 08 C7 44 24 3C FF FF FF FF 8B 44 24 3C 89 44 24 40 48 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 44 24 40 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_48_1_0 {
	meta:
		name = "_getw$fin$0"
		size = 26
		refs = "000e _unlock_file"
		altNames = "_freopen_helper$fin$0 _putw$fin$0 _wfreopen_helper$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 48 8B 4D 30 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "cbrt"
		size = 496
		refs = "0015 _dunscale 0086 _dscale 00bc __xmm@80000000000000008000000000000000 00ca __real@3fcf3482be8bc16a 00d8 __real@3feea8826aa8eb46 00e6 __real@3fb43419e30014f9 00f4 __real@3fd1e54b48d3ae68 0106 __real@3ff8000000000000 0120 __real@3fe0000000000000"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 48 48 8D 54 24 50 48 8D 4C 24 20 E8 ?? ?? ?? ?? 98 89 44 24 28 83 7C 24 28 00 7C 14 83 7C 24 28 02 7E 02 EB 0B F2 0F 10 44 24 50 E9 B2 01 00 00 C7 44 24 24 00 00 00 00 EB 0D 0F B7 44 24 20 66 FF C0 66 89 44 24 20 0F BF 44 24 20 99 B9 03 00 00 00 F7 F9 6B C0 03 0F BF 4C 24 20 3B C1 74 0C 8B 44 24 24 FF C8 89 44 24 24 EB CE 83 7C 24 24 00 7D 0E 8B 54 24 24 48 8D 4C 24 50 E8 ?? ?? ?? ?? B8 02 00 00 00 48 6B C0 03 0F B7 44 04 50 25 00 80 00 00 85 C0 75 0A C7 44 24 24 00 00 00 00 EB 1B C7 44 24 24 01 00 00 00 F2 0F 10 44 24 50 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 50 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 44 24 50 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 44 24 50 F2 0F 58 05 ?? ?? ?? ?? F2 0F 10 4C 24 50 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5E C1 F2 0F 11 44 24 30 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 44 24 50 F2 0F 10 4C 24 30 F2 0F 59 4C 24 30 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 54 24 50 F2 0F 5E 54 24 30 F2 0F 58 CA F2 0F 5E C1 F2 0F 10 4C 24 30 F2 0F 58 C8 0F 28 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C1 F2 0F 11 44 24 30 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 44 24 50 F2 0F 10 4C 24 30 F2 0F 59 4C 24 30 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 54 24 50 F2 0F 5E 54 24 30 F2 0F 58 CA F2 0F 5E C1 F2 0F 10 4C 24 30 F2 0F 58 C8 0F 28 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C1 F2 0F 11 44 24 30 83 7C 24 24 00 74 13 F2 0F 10 44 24 30 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 30 0F BF 44 24 20 99 B9 03 00 00 00 F7 F9 8B D0 48 8D 4C 24 30 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_1359_0_0 {
	meta:
		name = "cbrtl"
		size = 496
		refs = "0015 _ldunscale 0086 _ldscale 00bc __xmm@80000000000000008000000000000000 00ca __real@3fcf3482be8bc16a 00d8 __real@3feea8826aa8eb46 00e6 __real@3fb43419e30014f9 00f4 __real@3fd1e54b48d3ae68 0106 __real@3ff8000000000000 0120 __real@3fe0000000000000"
	strings:
		$1 = { F2 0F 11 44 24 08 48 83 EC 48 48 8D 54 24 50 48 8D 4C 24 20 E8 ?? ?? ?? ?? 98 89 44 24 28 83 7C 24 28 00 7C 14 83 7C 24 28 02 7E 02 EB 0B F2 0F 10 44 24 50 E9 B2 01 00 00 C7 44 24 24 00 00 00 00 EB 0D 0F B7 44 24 20 66 FF C0 66 89 44 24 20 0F BF 44 24 20 99 B9 03 00 00 00 F7 F9 6B C0 03 0F BF 4C 24 20 3B C1 74 0C 8B 44 24 24 FF C8 89 44 24 24 EB CE 83 7C 24 24 00 7D 0E 8B 54 24 24 48 8D 4C 24 50 E8 ?? ?? ?? ?? B8 02 00 00 00 48 6B C0 03 0F B7 44 04 50 25 00 80 00 00 85 C0 75 0A C7 44 24 24 00 00 00 00 EB 1B C7 44 24 24 01 00 00 00 F2 0F 10 44 24 50 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 50 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 44 24 50 F2 0F 58 05 ?? ?? ?? ?? F2 0F 59 44 24 50 F2 0F 58 05 ?? ?? ?? ?? F2 0F 10 4C 24 50 F2 0F 58 0D ?? ?? ?? ?? F2 0F 5E C1 F2 0F 11 44 24 30 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 44 24 50 F2 0F 10 4C 24 30 F2 0F 59 4C 24 30 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 54 24 50 F2 0F 5E 54 24 30 F2 0F 58 CA F2 0F 5E C1 F2 0F 10 4C 24 30 F2 0F 58 C8 0F 28 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C1 F2 0F 11 44 24 30 F2 0F 10 05 ?? ?? ?? ?? F2 0F 59 44 24 50 F2 0F 10 4C 24 30 F2 0F 59 4C 24 30 F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 54 24 50 F2 0F 5E 54 24 30 F2 0F 58 CA F2 0F 5E C1 F2 0F 10 4C 24 30 F2 0F 58 C8 0F 28 C1 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 0F 28 C1 F2 0F 11 44 24 30 83 7C 24 24 00 74 13 F2 0F 10 44 24 30 0F 57 05 ?? ?? ?? ?? F2 0F 11 44 24 30 0F BF 44 24 20 99 B9 03 00 00 00 F7 F9 8B D0 48 8D 4C 24 30 E8 ?? ?? ?? ?? F2 0F 10 44 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "_mbctohira"
		size = 24
		refs = "000f _mbctohira_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1152_15_0 {
	meta:
		name = "_ismbbkana"
		size = 24
		refs = "000f _ismbbkana_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_998_3_0 {
	meta:
		name = "_ismbcalnum"
		size = 24
		refs = "000f _ismbcalnum_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_230_3_0 {
	meta:
		name = "_ismbcalpha"
		size = 24
		refs = "000f _ismbcalpha_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1295_3_0 {
	meta:
		name = "_ismbcblank"
		size = 24
		refs = "000f _ismbcblank_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_95_3_0 {
	meta:
		name = "_ismbcdigit"
		size = 24
		refs = "000f _ismbcdigit_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1245_3_0 {
	meta:
		name = "_ismbcgraph"
		size = 24
		refs = "000f _ismbcgraph_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_150_3_0 {
	meta:
		name = "_ismbchira"
		size = 24
		refs = "000f _ismbchira_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_150_5_0 {
	meta:
		name = "_ismbckata"
		size = 24
		refs = "000f _ismbckata_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_750_3_0 {
	meta:
		name = "_ismbcl0"
		size = 24
		refs = "000f _ismbcl0_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_750_5_0 {
	meta:
		name = "_ismbcl1"
		size = 24
		refs = "000f _ismbcl1_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_750_7_0 {
	meta:
		name = "_ismbcl2"
		size = 24
		refs = "000f _ismbcl2_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_232_3_0 {
	meta:
		name = "_ismbclegal"
		size = 24
		refs = "000f _ismbclegal_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1124_3_0 {
	meta:
		name = "_ismbclower"
		size = 24
		refs = "000f _ismbclower_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_863_3_0 {
	meta:
		name = "_ismbcprint"
		size = 24
		refs = "000f _ismbcprint_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1295_5_0 {
	meta:
		name = "_ismbcpunct"
		size = 24
		refs = "000f _ismbcpunct_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1161_3_0 {
	meta:
		name = "_ismbcspace"
		size = 24
		refs = "000f _ismbcspace_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_150_7_0 {
	meta:
		name = "_ismbcsymbol"
		size = 24
		refs = "000f _ismbcsymbol_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1232_3_0 {
	meta:
		name = "_ismbcupper"
		size = 24
		refs = "000f _ismbcupper_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_513_3_0 {
	meta:
		name = "_mbbtombc"
		size = 24
		refs = "000f _mbbtombc_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_898_3_0 {
	meta:
		name = "_mbcjistojms"
		size = 24
		refs = "000f _mbcjistojms_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_898_5_0 {
	meta:
		name = "_mbcjmstojis"
		size = 24
		refs = "000f _mbcjmstojis_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_965_0_0 {
	meta:
		name = "_mbctokata"
		size = 24
		refs = "000f _mbctokata_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_111_3_0 {
	meta:
		name = "_mbctolower"
		size = 24
		refs = "000f _mbctolower_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_513_5_0 {
	meta:
		name = "_mbctombb"
		size = 24
		refs = "000f _mbctombb_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_255_3_0 {
	meta:
		name = "_mbctoupper"
		size = 24
		refs = "000f _mbctoupper_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1185_20_0 {
	meta:
		name = "isleadbyte"
		size = 24
		refs = "000f _isleadbyte_l"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_51_1_0 {
	meta:
		name = "_mbctohira_l"
		size = 88
		refs = "0017 _ismbckata_l"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 8B 4C 24 30 E8 ?? ?? ?? ?? 85 C0 74 30 81 7C 24 30 93 83 00 00 77 26 81 7C 24 30 7F 83 00 00 73 0F 8B 44 24 30 2D A1 00 00 00 89 44 24 30 EB 0D 8B 44 24 30 2D A2 00 00 00 89 44 24 30 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_52_1_0 {
	meta:
		name = "remove"
		size = 90
		refs = "0025 __copy_path_to_wide_string 003a _wremove 004d _free_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 00 00 00 00 48 83 7C 24 40 00 74 1A 48 8D 54 24 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 85 C0 75 07 B8 FF FF FF FF EB 21 48 8B 4C 24 28 E8 ?? ?? ?? ?? 89 44 24 20 BA 02 00 00 00 48 8B 4C 24 28 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "_mkdir"
		size = 90
		refs = "0025 __copy_path_to_wide_string 003a _wmkdir 004d _free_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 00 00 00 00 48 83 7C 24 40 00 74 1A 48 8D 54 24 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 85 C0 75 07 B8 FF FF FF FF EB 21 48 8B 4C 24 28 E8 ?? ?? ?? ?? 89 44 24 20 BA 02 00 00 00 48 8B 4C 24 28 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_847_0_0 {
	meta:
		name = "_rmdir"
		size = 90
		refs = "0025 __copy_path_to_wide_string 003a _wrmdir 004d _free_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 00 00 00 00 48 83 7C 24 40 00 74 1A 48 8D 54 24 28 48 8B 4C 24 40 E8 ?? ?? ?? ?? 85 C0 75 07 B8 FF FF FF FF EB 21 48 8B 4C 24 28 E8 ?? ?? ?? ?? 89 44 24 20 BA 02 00 00 00 48 8B 4C 24 28 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "asinf"
		size = 1127
		refs = "00e9 ??_C@_05ECHIKDO@asinf?$AA@ 00ee _handle_errorf 0112 valf_with_flags 0137 __real@3f800000 0148 ?piby2@?1??asinf@@9@9 0167 __real@bf800000 017a __xmm@80000000800000008000000080000000 0249 __real@3f000000 0294 __real@3b81ce6b 02a2 __real@bc5b3fe1 02b7 __real@bd678bdd 02cc __real@3e3c94dc 02e8 __real@3f561f0d 02f6 __real@3f8d6fa5 038b __real@40000000 03b0 ?piby2_tail@?1??asinf@@9@9 03da ?hpiby2_head@?1??asinf@@9@9"
	strings:
		$1 = { F3 0F 11 44 24 08 48 81 EC B8 00 00 00 0F 57 C0 F3 0F 11 44 24 58 C7 44 24 68 00 00 00 00 F3 0F 10 84 24 C0 00 00 00 F3 0F 11 84 24 90 00 00 00 8B 84 24 90 00 00 00 89 44 24 5C 8B 44 24 5C 0F BA F0 1F 89 84 24 88 00 00 00 8B 44 24 5C 25 00 00 00 80 89 44 24 7C 81 BC 24 88 00 00 00 00 00 80 7F 76 0A C7 44 24 74 01 00 00 00 EB 08 C7 44 24 74 00 00 00 00 8B 44 24 74 89 84 24 98 00 00 00 8B 44 24 5C 25 00 00 80 7F C1 E8 17 83 E8 7F 89 44 24 64 83 BC 24 98 00 00 00 00 74 5E 8B 44 24 5C 0F BA E8 16 8B C0 C7 44 24 40 01 00 00 00 0F 57 C0 F3 0F 11 44 24 38 F3 0F 10 84 24 C0 00 00 00 F3 0F 11 44 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 00 00 00 00 41 B9 01 00 00 00 44 8B C0 BA 0E 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 68 03 00 00 E9 E5 00 00 00 83 7C 24 64 F2 7D 1D BA 10 00 00 00 F3 0F 10 84 24 C0 00 00 00 E8 ?? ?? ?? ?? E9 44 03 00 00 E9 C1 00 00 00 83 7C 24 64 00 0F 8C B6 00 00 00 F3 0F 10 84 24 C0 00 00 00 0F 2E 05 ?? ?? ?? ?? 7A 1E 75 1C BA 10 00 00 00 F3 0F 10 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 09 03 00 00 E9 86 00 00 00 F3 0F 10 84 24 C0 00 00 00 0F 2E 05 ?? ?? ?? ?? 7A 22 75 20 F3 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? BA 10 00 00 00 E8 ?? ?? ?? ?? E9 D2 02 00 00 EB 52 C7 44 24 40 01 00 00 00 0F 57 C0 F3 0F 11 44 24 38 F3 0F 10 84 24 C0 00 00 00 F3 0F 11 44 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 08 00 00 00 41 B9 01 00 00 00 41 B8 00 00 C0 FF BA 0E 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 7E 02 00 00 83 7C 24 7C 00 74 18 F3 0F 10 84 24 C0 00 00 00 0F 57 05 ?? ?? ?? ?? F3 0F 11 44 24 54 EB 0F F3 0F 10 84 24 C0 00 00 00 F3 0F 11 44 24 54 83 7C 24 64 FF 7C 0A C7 44 24 78 01 00 00 00 EB 08 C7 44 24 78 00 00 00 00 8B 44 24 78 89 44 24 68 83 7C 24 68 00 74 47 F3 0F 10 05 ?? ?? ?? ?? F3 0F 5C 44 24 54 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 0F 28 C1 F3 0F 11 44 24 50 48 8D 44 24 50 F3 0F 10 00 F3 0F 51 C0 48 8D 44 24 58 F3 0F 11 00 F3 0F 10 44 24 58 F3 0F 11 44 24 54 EB 12 F3 0F 10 44 24 54 F3 0F 59 44 24 54 F3 0F 11 44 24 50 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 44 24 50 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5C C8 0F 28 C1 F3 0F 59 44 24 50 F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 C8 0F 28 C1 F3 0F 59 44 24 50 F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 C8 0F 28 C1 F3 0F 10 4C 24 50 F3 0F 59 C8 0F 28 C1 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 4C 24 50 F3 0F 10 15 ?? ?? ?? ?? F3 0F 5C D1 0F 28 CA F3 0F 5E C1 F3 0F 11 44 24 70 83 7C 24 68 00 0F 84 01 01 00 00 F3 0F 10 44 24 58 F3 0F 11 84 24 80 00 00 00 8B 84 24 80 00 00 00 89 84 24 A0 00 00 00 8B 84 24 A0 00 00 00 25 00 00 FF FF 89 84 24 84 00 00 00 F3 0F 10 84 24 84 00 00 00 F3 0F 11 44 24 60 F3 0F 10 44 24 60 F3 0F 59 44 24 60 F3 0F 10 4C 24 50 F3 0F 5C C8 0F 28 C1 F3 0F 10 4C 24 58 F3 0F 58 4C 24 60 F3 0F 5E C1 F3 0F 11 84 24 8C 00 00 00 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 44 24 58 F3 0F 59 44 24 70 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 8C 24 8C 00 00 00 F3 0F 10 15 ?? ?? ?? ?? F3 0F 5C D1 0F 28 CA F3 0F 5C C1 F3 0F 11 84 24 94 00 00 00 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 44 24 60 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5C C8 0F 28 C1 F3 0F 11 84 24 9C 00 00 00 F3 0F 10 84 24 94 00 00 00 F3 0F 5C 84 24 9C 00 00 00 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5C C8 0F 28 C1 F3 0F 11 44 24 6C EB 2A F3 0F 10 44 24 54 F3 0F 59 44 24 70 F3 0F 11 84 24 A4 00 00 00 F3 0F 10 44 24 54 F3 0F 58 84 24 A4 00 00 00 F3 0F 11 44 24 6C 83 7C 24 7C 00 74 11 F3 0F 10 44 24 6C 0F 57 05 ?? ?? ?? ?? EB 08 EB 06 F3 0F 10 44 24 6C 48 81 C4 B8 00 00 00 C3 }
	condition:
		$1
}

rule file_53_1_0 {
	meta:
		name = "raise_fpsw_flags"
		size = 142
		refs = "0085 _set_statfp"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 8B 44 24 40 83 E0 01 85 C0 74 0B 8B 44 24 20 83 C8 08 89 44 24 20 8B 44 24 40 83 E0 02 85 C0 74 0B 8B 44 24 20 83 C8 10 89 44 24 20 8B 44 24 40 83 E0 04 85 C0 74 0B 8B 44 24 20 83 C8 04 89 44 24 20 8B 44 24 40 83 E0 08 85 C0 74 0B 8B 44 24 20 83 C8 01 89 44 24 20 8B 44 24 40 83 E0 10 85 C0 74 0B 8B 44 24 20 83 C8 20 89 44 24 20 8B 44 24 20 8B C8 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_53_2_0 {
	meta:
		name = "valf_with_flags"
		size = 34
		refs = "0013 raise_fpsw_flags"
	strings:
		$1 = { 89 54 24 10 F3 0F 11 44 24 08 48 83 EC 28 8B 4C 24 38 E8 ?? ?? ?? ?? F3 0F 10 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__timet_from_ft"
		size = 199
		refs = "000c __security_cookie 0049 __imp_FileTimeToSystemTime 005f __imp_SystemTimeToTzSpecificLocalTime 00b1 __loctotime32_t 00be __security_check_cookie"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 68 48 8B 84 24 80 00 00 00 83 38 00 75 15 48 8B 84 24 80 00 00 00 83 78 04 00 75 07 B8 FF FF FF FF EB 7B 48 8D 54 24 58 48 8B 8C 24 80 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 74 16 4C 8D 44 24 48 48 8D 54 24 58 33 C9 FF 15 ?? ?? ?? ?? 85 C0 75 07 B8 FF FF FF FF EB 47 0F B7 44 24 54 0F B7 4C 24 52 0F B7 54 24 50 44 0F B7 44 24 4E 44 0F B7 4C 24 4A 44 89 4C 24 40 44 0F B7 54 24 48 C7 44 24 30 FF FF FF FF 89 44 24 28 89 4C 24 20 44 8B CA 8B 44 24 40 8B D0 41 8B CA E8 ?? ?? ?? ?? 48 8B 4C 24 68 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "_copyfinddata32"
		size = 231
		refs = "0029 __copy_to_char 004f strcpy_s 0067 ??_C@_1FG@ILAKEHFA@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAd?$AAi?$AAr?$AAe?$AAc?$AAt?$AA?2@ 006e ??_C@_1CA@MGCFKOFO@?$AA_?$AAc?$AAo?$AAp?$AAy?$AAf?$AAi?$AAn?$AAd?$AAd?$AAa?$AAt?$AAa?$AA3?$AA2?$AA?$AA@ 0075 ??_C@_1IM@HKOAPJL@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAf?$AAd?$AA?9?$AA?$DO?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AA?$CI?$AAs?$AAi?$AAz?$AAe?$AAo?$AAf?$AA?$CI?$AAp?$AAf?$AAd?$AA?9@ 007c _invoke_watson_if_error 008b _free_dbg"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 30 00 00 00 00 48 8B 44 24 58 48 83 C0 14 48 8D 54 24 30 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 AA 00 00 00 48 8B 44 24 50 48 83 C0 14 4C 8B 44 24 30 BA 04 01 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 38 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 4C 24 58 8B 09 89 08 48 8B 44 24 50 48 8B 4C 24 58 8B 49 04 89 48 04 48 8B 44 24 50 48 8B 4C 24 58 8B 49 08 89 48 08 48 8B 44 24 50 48 8B 4C 24 58 8B 49 0C 89 48 0C 48 8B 44 24 50 48 8B 4C 24 58 8B 49 10 89 48 10 B8 01 00 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_54_2_0 {
	meta:
		name = "_findclose"
		size = 49
		refs = "0010 __imp_FindClose 0019 _errno"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 FF 15 ?? ?? ?? ?? 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF FF EB 02 33 C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_54_3_0 {
	meta:
		name = "_findfirst32"
		size = 187
		refs = "0014 __security_cookie 0043 __copy_path_to_wide_string 005f _wfindfirst32 0073 _free_dbg 008d _copyfinddata32 00af __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 81 EC 78 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 60 02 00 00 48 C7 44 24 20 00 00 00 00 48 C7 44 24 30 00 00 00 00 48 8D 54 24 20 48 8B 8C 24 80 02 00 00 E8 ?? ?? ?? ?? 85 C0 75 09 48 C7 C0 FF FF FF FF EB 4F 48 8D 54 24 40 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 28 BA 02 00 00 00 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 7C 24 28 FF 74 1F 48 8D 54 24 40 48 8B 8C 24 88 02 00 00 E8 ?? ?? ?? ?? 85 C0 75 09 48 C7 C0 FF FF FF FF EB 05 48 8B 44 24 28 48 8B 8C 24 60 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 78 02 00 00 C3 }
	condition:
		$1
}

rule file_729_1_0 {
	meta:
		name = "_findfirst32i64"
		size = 187
		refs = "0014 __security_cookie 0043 __copy_path_to_wide_string 005f _wfindfirst32i64 0073 _free_dbg 008d _copyfinddata32i64 00af __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 81 EC 78 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 60 02 00 00 48 C7 44 24 20 00 00 00 00 48 C7 44 24 30 00 00 00 00 48 8D 54 24 20 48 8B 8C 24 80 02 00 00 E8 ?? ?? ?? ?? 85 C0 75 09 48 C7 C0 FF FF FF FF EB 4F 48 8D 54 24 40 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 89 44 24 28 BA 02 00 00 00 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 7C 24 28 FF 74 1F 48 8D 54 24 40 48 8B 8C 24 88 02 00 00 E8 ?? ?? ?? ?? 85 C0 75 09 48 C7 C0 FF FF FF FF EB 05 48 8B 44 24 28 48 8B 8C 24 60 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 78 02 00 00 C3 }
	condition:
		$1
}

rule file_54_4_0 {
	meta:
		name = "_findnext32"
		size = 121
		refs = "0014 __security_cookie 0031 _wfindnext32 004e _copyfinddata32 006d __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 81 EC 68 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 50 02 00 00 48 8D 54 24 30 48 8B 8C 24 70 02 00 00 E8 ?? ?? ?? ?? 89 44 24 20 83 7C 24 20 FF 74 1D 48 8D 54 24 30 48 8B 8C 24 78 02 00 00 E8 ?? ?? ?? ?? 85 C0 75 07 B8 FF FF FF FF EB 04 8B 44 24 20 48 8B 8C 24 50 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 68 02 00 00 C3 }
	condition:
		$1
}

rule file_729_2_0 {
	meta:
		name = "_findnext32i64"
		size = 121
		refs = "0014 __security_cookie 0031 _wfindnext32i64 004e _copyfinddata32i64 006d __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 81 EC 68 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 50 02 00 00 48 8D 54 24 30 48 8B 8C 24 70 02 00 00 E8 ?? ?? ?? ?? 89 44 24 20 83 7C 24 20 FF 74 1D 48 8D 54 24 30 48 8B 8C 24 78 02 00 00 E8 ?? ?? ?? ?? 85 C0 75 07 B8 FF FF FF FF EB 04 8B 44 24 20 48 8B 8C 24 50 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 68 02 00 00 C3 }
	condition:
		$1
}

rule file_59_3_0 {
	meta:
		name = "_wcsicoll"
		size = 587
		refs = "0010 __locale_changed 0047 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0053 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0068 ??_C@_1FG@IIMBMPEK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?2@ 0072 _CrtDbgReportW 0086 _errno 00a9 ??_C@_1BE@HPGMPCMA@?$AA_?$AAw?$AAc?$AAs?$AAi?$AAc?$AAo?$AAl?$AAl?$AA?$AA@ 00b5 _invalid_parameter 00ef ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0242 _wcsicoll_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 83 3D ?? ?? ?? ?? 00 0F 85 19 02 00 00 48 83 7C 24 60 00 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 65 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 65 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF 7F E9 83 01 00 00 48 83 7C 24 68 00 74 0A C7 44 24 40 01 00 00 00 EB 08 C7 44 24 40 00 00 00 00 8B 44 24 40 89 44 24 44 83 7C 24 44 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 66 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 44 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 66 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF 7F E9 DB 00 00 00 48 8B 44 24 60 0F B7 00 83 F8 41 7C 1E 48 8B 44 24 60 0F B7 00 83 F8 5A 7F 11 48 8B 44 24 60 0F B7 00 83 C0 20 89 44 24 48 EB 0C 48 8B 44 24 60 0F B7 00 89 44 24 48 0F B7 44 24 48 66 89 44 24 30 48 8B 44 24 68 0F B7 00 83 F8 41 7C 1E 48 8B 44 24 68 0F B7 00 83 F8 5A 7F 11 48 8B 44 24 68 0F B7 00 83 C0 20 89 44 24 4C EB 0C 48 8B 44 24 68 0F B7 00 89 44 24 4C 0F B7 44 24 4C 66 89 44 24 34 48 8B 44 24 60 48 83 C0 02 48 89 44 24 60 48 8B 44 24 68 48 83 C0 02 48 89 44 24 68 0F B7 44 24 30 85 C0 74 12 0F B7 44 24 30 0F B7 4C 24 34 3B C1 0F 84 47 FF FF FF 0F B7 44 24 30 0F B7 4C 24 34 2B C1 EB 14 EB 12 45 33 C0 48 8B 54 24 68 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_59_4_0 {
	meta:
		name = "_wcsicoll_l"
		size = 863
		refs = "0024 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0057 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0063 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0078 ??_C@_1FG@IIMBMPEK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?2@ 0082 _CrtDbgReportW 0096 _errno 00b9 ??_C@_1BI@EFNHPDCH@?$AA_?$AAw?$AAc?$AAs?$AAi?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 00c5 _invalid_parameter 00d7 ??1_LocaleUpdate@@QEAA@XZ 0113 ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01a6 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 030c __crtCompareStringW"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 98 00 00 00 48 8B 94 24 B0 00 00 00 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 83 BC 24 A0 00 00 00 00 74 0A C7 44 24 48 01 00 00 00 EB 08 C7 44 24 48 00 00 00 00 8B 44 24 48 89 44 24 50 83 7C 24 50 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3B 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 50 00 75 4F E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3B 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 54 FF FF FF 7F 48 8D 4C 24 68 E8 ?? ?? ?? ?? 8B 44 24 54 E9 73 02 00 00 48 83 BC 24 A8 00 00 00 00 74 0A C7 44 24 44 01 00 00 00 EB 08 C7 44 24 44 00 00 00 00 8B 44 24 44 89 44 24 4C 83 7C 24 4C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3C 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 4C 00 75 4F E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3C 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 5C FF FF FF 7F 48 8D 4C 24 68 E8 ?? ?? ?? ?? 8B 44 24 5C E9 B7 01 00 00 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B 00 B9 08 00 00 00 48 6B C9 01 48 83 BC 08 28 01 00 00 00 0F 85 00 01 00 00 48 8B 84 24 A0 00 00 00 0F B7 00 83 F8 41 7C 24 48 8B 84 24 A0 00 00 00 0F B7 00 83 F8 5A 7F 14 48 8B 84 24 A0 00 00 00 0F B7 00 83 C0 20 89 44 24 40 EB 0F 48 8B 84 24 A0 00 00 00 0F B7 00 89 44 24 40 0F B7 44 24 40 66 89 44 24 30 48 8B 84 24 A8 00 00 00 0F B7 00 83 F8 41 7C 24 48 8B 84 24 A8 00 00 00 0F B7 00 83 F8 5A 7F 14 48 8B 84 24 A8 00 00 00 0F B7 00 83 C0 20 89 44 24 38 EB 0F 48 8B 84 24 A8 00 00 00 0F B7 00 89 44 24 38 0F B7 44 24 38 66 89 44 24 34 48 8B 84 24 A0 00 00 00 48 83 C0 02 48 89 84 24 A0 00 00 00 48 8B 84 24 A8 00 00 00 48 83 C0 02 48 89 84 24 A8 00 00 00 0F B7 44 24 30 85 C0 74 12 0F B7 44 24 30 0F B7 4C 24 34 3B C1 0F 84 23 FF FF FF 0F B7 44 24 30 0F B7 4C 24 34 2B C1 89 44 24 64 48 8D 4C 24 68 E8 ?? ?? ?? ?? 8B 44 24 64 E9 92 00 00 00 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 8B 00 B9 08 00 00 00 48 6B C9 01 C7 44 24 28 FF FF FF FF 48 8B 94 24 A8 00 00 00 48 89 54 24 20 41 B9 FF FF FF FF 4C 8B 84 24 A0 00 00 00 BA 01 10 00 00 48 8B 8C 08 28 01 00 00 E8 ?? ?? ?? ?? 89 44 24 3C 83 7C 24 3C 00 75 23 E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 44 24 58 FF FF FF 7F 48 8D 4C 24 68 E8 ?? ?? ?? ?? 8B 44 24 58 EB 19 8B 44 24 3C 83 E8 02 89 44 24 60 48 8D 4C 24 68 E8 ?? ?? ?? ?? 8B 44 24 60 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "strcpy_s"
		size = 1179
		refs = "0050 ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 005c ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0071 ??_C@_1FA@ILDLFIFE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAt?$AAc?$AAs?$AAc?$AAp@ 007b _CrtDbgReportW 008f _errno 00b2 ??_C@_1BC@CFJEPFGF@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$AA@ 00be _invalid_parameter 0118 __crtDebugFillThreshold 0155 memset 0188 ??_C@_1CG@OFBJMIGJ@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAr?$AAc?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0307 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 033a ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 88 00 00 00 48 83 BC 24 90 00 00 00 00 74 15 48 83 BC 24 98 00 00 00 00 76 0A C7 44 24 40 01 00 00 00 EB 08 C7 44 24 40 00 00 00 00 8B 44 24 40 89 44 24 4C 83 7C 24 4C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 12 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 4C 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 12 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 C7 03 00 00 48 83 BC 24 A0 00 00 00 00 0F 85 29 01 00 00 48 8B 84 24 90 00 00 00 C6 00 00 48 83 BC 24 98 00 00 00 FF 74 68 48 81 BC 24 98 00 00 00 FF FF FF 7F 74 5A 48 83 BC 24 98 00 00 00 01 76 4F 48 8B 84 24 98 00 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 0E 48 8B 05 ?? ?? ?? ?? 48 89 44 24 68 EB 10 48 8B 84 24 98 00 00 00 48 FF C8 48 89 44 24 68 48 8B 84 24 90 00 00 00 48 FF C0 4C 8B 44 24 68 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 83 BC 24 A0 00 00 00 00 74 0A C7 44 24 48 01 00 00 00 EB 08 C7 44 24 48 00 00 00 00 8B 44 24 48 89 44 24 44 83 7C 24 44 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 13 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 44 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 13 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 8F 02 00 00 48 8B 84 24 90 00 00 00 48 89 44 24 50 48 8B 84 24 98 00 00 00 48 89 44 24 30 48 8B 44 24 50 48 8B 8C 24 A0 00 00 00 0F B6 09 88 08 48 8B 44 24 50 0F BE 00 89 44 24 58 48 8B 44 24 50 48 FF C0 48 89 44 24 50 48 8B 84 24 A0 00 00 00 48 FF C0 48 89 84 24 A0 00 00 00 83 7C 24 58 00 74 17 48 8B 44 24 30 48 FF C8 48 89 44 24 30 48 83 7C 24 30 00 76 02 EB A4 48 83 7C 24 30 00 0F 85 30 01 00 00 48 8B 84 24 90 00 00 00 C6 00 00 48 83 BC 24 98 00 00 00 FF 74 68 48 81 BC 24 98 00 00 00 FF FF FF 7F 74 5A 48 83 BC 24 98 00 00 00 01 76 4F 48 8B 84 24 98 00 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 0E 48 8B 05 ?? ?? ?? ?? 48 89 44 24 60 EB 10 48 8B 84 24 98 00 00 00 48 FF C8 48 89 44 24 60 48 8B 84 24 90 00 00 00 48 FF C0 4C 8B 44 24 60 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 10 33 C0 85 C0 74 0A C7 44 24 3C 01 00 00 00 EB 08 C7 44 24 3C 00 00 00 00 8B 44 24 3C 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 1E 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3E E8 ?? ?? ?? ?? C7 00 22 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 1E 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 22 00 00 00 E9 DD 00 00 00 48 83 BC 24 98 00 00 00 FF 0F 84 CC 00 00 00 48 81 BC 24 98 00 00 00 FF FF FF 7F 0F 84 BA 00 00 00 48 8B 44 24 30 48 8B 8C 24 98 00 00 00 48 2B C8 48 8B C1 48 FF C0 48 3B 84 24 98 00 00 00 0F 83 96 00 00 00 48 8B 44 24 30 48 8B 8C 24 98 00 00 00 48 2B C8 48 8B C1 48 FF C0 48 8B 8C 24 98 00 00 00 48 2B C8 48 8B C1 48 39 05 ?? ?? ?? ?? 73 0E 48 8B 05 ?? ?? ?? ?? 48 89 44 24 70 EB 29 48 8B 44 24 30 48 8B 8C 24 98 00 00 00 48 2B C8 48 8B C1 48 FF C0 48 8B 8C 24 98 00 00 00 48 2B C8 48 8B C1 48 89 44 24 70 48 8B 44 24 30 48 8B 8C 24 98 00 00 00 48 2B C8 48 8B C1 48 8B 8C 24 90 00 00 00 48 8D 44 01 01 4C 8B 44 24 70 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 33 C0 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "__sse2_atan22"
		size = 736
		refs = "0027 iSignMask 005c dbPio2hi 00b8 iAbsMask 00d8 iMinWorkNum 00e1 iMaxWorkNum 012c dbPi 0158 dbA19 0160 dbA18 0168 dbA17 0170 dbA16 0193 dbA15 019b dbA14 01a3 dbA13 01ab dbA12 01c3 dbA11 01cb dbA10 01d3 dbA09 01db dbA08 01f3 dbA07 01fb dbA06 0203 dbA05 020b dbA04 0223 dbA03 022b dbA02 0233 dbA01 023b dbA00"
	strings:
		$1 = { 48 81 EC A8 00 00 00 0F 29 B4 24 90 00 00 00 0F 29 BC 24 80 00 00 00 66 0F 29 44 24 60 66 0F 29 4C 24 70 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 54 D0 66 0F 54 D9 66 0F 29 54 24 20 66 0F 29 5C 24 30 66 0F 57 C2 66 0F 57 CB 66 0F 28 D0 66 0F C2 D1 05 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 E2 66 0F 54 DA 66 0F 54 25 ?? ?? ?? ?? 66 0F 56 CC 66 0F 28 E2 66 0F 28 E8 66 0F 28 F1 66 0F 54 C2 66 0F 54 CA 66 0F 55 D6 66 0F 55 E5 66 0F 56 CC 66 0F 56 D0 66 0F 5E CA 66 0F 28 64 24 60 66 0F 28 6C 24 60 66 0F 28 74 24 70 66 0F 28 7C 24 70 66 0F 54 25 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 54 35 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F C2 25 ?? ?? ?? ?? 06 66 0F C2 2D ?? ?? ?? ?? 01 66 0F C2 35 ?? ?? ?? ?? 06 66 0F C2 3D ?? ?? ?? ?? 01 66 0F 54 E5 66 0F 54 F7 66 0F 54 E6 66 0F 50 C4 83 F8 03 89 84 24 A0 00 00 00 0F 8C 63 01 00 00 66 0F 28 64 24 30 66 0F 72 E4 1F 66 0F 70 E4 F5 66 0F 54 25 ?? ?? ?? ?? 66 0F 29 64 24 40 66 0F 29 5C 24 50 66 0F 28 E1 66 0F 59 C9 66 0F 28 E9 66 0F 59 C9 66 0F 28 C1 66 0F 59 C9 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 C7 84 24 A0 00 00 00 03 00 00 00 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D1 66 0F 59 D9 66 0F 59 F1 66 0F 59 F9 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 3D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 D5 66 0F 59 D8 66 0F 59 F5 66 0F 58 D3 66 0F 58 F7 66 0F 58 F2 66 0F 59 F4 66 0F 58 74 24 50 66 0F 56 74 24 30 66 0F 58 74 24 40 66 0F 56 74 24 20 66 0F 28 C6 0F 28 B4 24 90 00 00 00 0F 28 BC 24 80 00 00 00 83 BC 24 A0 00 00 00 03 7D 34 F2 0F 10 44 24 60 F2 0F 10 4C 24 70 E8 3A 00 00 00 F2 0F 11 44 24 60 F2 0F 10 44 24 68 F2 0F 10 4C 24 78 E8 23 00 00 00 F2 0F 11 44 24 68 66 0F 28 44 24 60 48 81 C4 A8 00 00 00 C3 66 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "__common_atan2_sd"
		size = 944
		refs = "0027 iSignMask 005c dbPio2hi 00b8 iAbsMask 00d8 iMinWorkNum 00e1 iMaxWorkNum 0125 dbPi 0151 dbA19 0159 dbA18 0161 dbA17 0169 dbA16 0181 dbA15 0189 dbA14 0191 dbA13 0199 dbA12 01b1 dbA11 01b9 dbA10 01c1 dbA09 01c9 dbA08 01e1 dbA07 01e9 dbA06 01f1 dbA05 01f9 dbA04 0211 dbA03 0219 dbA02 0221 dbA01 0229 dbA00 027e dbZero 0336 db3Pio4hi 0348 dbPio4hi"
	strings:
		$1 = { 48 81 EC A8 00 00 00 0F 29 B4 24 90 00 00 00 0F 29 BC 24 80 00 00 00 66 0F D6 44 24 20 66 0F D6 4C 24 30 F3 0F 7E 15 ?? ?? ?? ?? F3 0F 7E 1D ?? ?? ?? ?? 66 0F 54 D0 66 0F 54 D9 66 0F D6 54 24 40 66 0F D6 5C 24 50 66 0F 57 C2 66 0F 57 CB F3 0F 7E D0 F2 0F C2 D1 05 F3 0F 7E 1D ?? ?? ?? ?? F3 0F 7E E2 66 0F 54 DA 66 0F 54 25 ?? ?? ?? ?? 66 0F 56 CC F3 0F 7E E2 F3 0F 7E E8 F3 0F 7E F1 66 0F 54 C2 66 0F 54 CA 66 0F 55 D6 66 0F 55 E5 66 0F 56 CC 66 0F 56 D0 F2 0F 5E CA F3 0F 7E 64 24 20 F3 0F 7E 6C 24 20 F3 0F 7E 74 24 30 F3 0F 7E 7C 24 30 66 0F 54 25 ?? ?? ?? ?? 66 0F 54 2D ?? ?? ?? ?? 66 0F 54 35 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? F2 0F C2 25 ?? ?? ?? ?? 06 F2 0F C2 2D ?? ?? ?? ?? 01 F2 0F C2 35 ?? ?? ?? ?? 06 F2 0F C2 3D ?? ?? ?? ?? 01 66 0F 54 E5 66 0F 54 F7 66 0F 54 E6 66 0F 50 D4 83 E2 01 0F 84 5D 01 00 00 F3 0F 7E 64 24 50 66 0F 72 E4 1F 66 0F 70 E4 F5 66 0F 54 25 ?? ?? ?? ?? 66 0F D6 64 24 60 66 0F D6 5C 24 70 F3 0F 7E E1 F2 0F 59 C9 F3 0F 7E E9 F2 0F 59 C9 F3 0F 7E C1 F2 0F 59 C9 F3 0F 7E 15 ?? ?? ?? ?? F3 0F 7E 1D ?? ?? ?? ?? F3 0F 7E 35 ?? ?? ?? ?? F3 0F 7E 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D1 F2 0F 59 D9 F2 0F 59 F1 F2 0F 59 F9 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? F2 0F 58 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 D0 F2 0F 59 D5 F2 0F 59 D8 F2 0F 59 F5 F2 0F 58 D3 F2 0F 58 F7 F2 0F 58 F2 F2 0F 59 F4 F2 0F 58 74 24 70 66 0F 56 74 24 50 F2 0F 58 74 24 60 66 0F 56 74 24 40 F3 0F 7E C6 E9 10 01 00 00 F3 0F 7E 54 24 20 F3 0F 7E 5C 24 30 F2 0F 58 15 ?? ?? ?? ?? F2 0F 58 1D ?? ?? ?? ?? 66 0F EB 54 24 40 66 0F EB 5C 24 50 66 0F D6 54 24 20 66 0F D6 5C 24 30 F3 0F 7E 44 24 20 48 8B 44 24 20 48 8B 54 24 30 48 23 05 ?? ?? ?? ?? 48 23 15 ?? ?? ?? ?? 48 3B 05 ?? ?? ?? ?? 0F 8F A5 00 00 00 74 42 48 3B 15 ?? ?? ?? ?? 0F 8F 96 00 00 00 48 23 D2 74 1B 48 8B 54 24 30 48 23 15 ?? ?? ?? ?? 75 71 66 0F 54 05 ?? ?? ?? ?? E9 82 00 00 00 48 23 C0 75 4D 48 8B 54 24 30 48 23 15 ?? ?? ?? ?? 75 51 EB DE 48 3B 15 ?? ?? ?? ?? 7F 58 7C 32 48 8B 54 24 30 48 23 15 ?? ?? ?? ?? 74 12 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 42 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 30 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 1E 66 0F 54 05 ?? ?? ?? ?? 66 0F 56 05 ?? ?? ?? ?? EB 0C F3 0F 7E 44 24 20 F2 0F 59 44 24 30 F2 0F 11 84 24 A0 00 00 00 0F 28 B4 24 90 00 00 00 0F 28 BC 24 80 00 00 00 F2 0F 10 84 24 A0 00 00 00 48 81 C4 A8 00 00 00 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_63_10_0 {
	meta:
		name = "??0scheduler_resource_allocation_error@Concurrency@@QEAA@AEBV01@@Z"
		size = 70
		refs = "0019 ??0exception@std@@QEAA@AEBV01@@Z 0025 ??_7scheduler_resource_allocation_error@Concurrency@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 8B 4C 24 38 8B 49 18 89 48 18 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_30_36_1 {
	meta:
		name = "??0regex_error@std@@QEAA@AEBV01@@Z"
		size = 70
		refs = "0019 ??0runtime_error@std@@QEAA@AEBV01@@Z 0025 ??_7regex_error@std@@6B@"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 30 48 8B 4C 24 38 8B 49 18 89 48 18 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_63_26_0 {
	meta:
		name = "?Initialize@WinRT@details@Concurrency@@SAXXZ"
		size = 398
		refs = "0012 ??_C@_1BI@IDAOOPDH@?$AAc?$AAo?$AAm?$AAb?$AAa?$AAs?$AAe?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0018 __imp_LoadLibraryExW 001f ?m_hModule@WinRT@details@Concurrency@@0PEAUHINSTANCE__@@EA 002f __imp_GetLastError 003b ??_C@_1CM@INEAJNJO@?$AAG?$AAe?$AAt?$AAL?$AAa?$AAs?$AAt?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?$CI?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA8?$AA7?$AAL?$AA?$AA@ 0047 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 005c ??_C@_1GC@OBJNJGOC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0066 _CrtDbgReportW 0087 HRESULT_FROM_WIN32 0093 ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 009a _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 00a4 _CxxThrowException 00b1 __imp_GetModuleHandleW 00b8 ??_C@_0N@PPOMPGGK@RoInitialize?$AA@ 00c1 __imp_GetProcAddress 0102 ?EncodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z 0109 ?s_pfn_RoInitialize@WinRT@details@Concurrency@@0P6AJW4RO_INIT_TYPE@@@ZEA 011d ??_C@_0P@LLFHBIJD@RoUninitialize?$AA@ 0174 ?s_pfn_RoUninitialize@WinRT@details@Concurrency@@0P6AXXZEA 0180 ?s_fInitialized@WinRT@details@Concurrency@@0JC"
	strings:
		$1 = { 48 81 EC A8 00 00 00 41 B8 00 08 00 00 33 D2 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 75 7B FF 15 ?? ?? ?? ?? 83 F8 57 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 29 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B5 33 C0 85 C0 75 AF FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 75 2A FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 75 30 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? B8 01 00 00 00 48 8D 0D ?? ?? ?? ?? 87 01 48 81 C4 A8 00 00 00 C3 }
	condition:
		$1
}

rule file_63_27_0 {
	meta:
		name = "?Initialized@WinRT@details@Concurrency@@SA_NXZ"
		size = 39
		refs = "0006 ?s_fInitialized@WinRT@details@Concurrency@@0JC"
	strings:
		$1 = { 48 83 EC 18 8B 05 ?? ?? ?? ?? 85 C0 74 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 0F B6 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_952_40_0 {
	meta:
		name = "?Initialized@UMS@details@Concurrency@@SA_NXZ"
		size = 39
		refs = "0006 ?s_fInitialized@UMS@details@Concurrency@@0JC"
	strings:
		$1 = { 48 83 EC 18 8B 05 ?? ?? ?? ?? 85 C0 74 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 00 00 00 00 0F B6 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_63_28_0 {
	meta:
		name = "?RoInitialize@WinRT@details@Concurrency@@SAJW4RO_INIT_TYPE@@@Z"
		size = 116
		refs = "000b ?s_pfn_RoInitialize@WinRT@details@Concurrency@@0P6AJW4RO_INIT_TYPE@@@ZEA 0010 ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z 0024 ??_C@_1BC@CNPLJCBN@?$AAp?$AAf?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0030 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0045 ??_C@_1GC@OBJNJGOC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 004f _CrtDbgReportW"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 48 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3D 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B8 33 C0 85 C0 75 B2 8B 4C 24 50 FF 54 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_63_29_0 {
	meta:
		name = "?RoUninitialize@WinRT@details@Concurrency@@SAXXZ"
		size = 108
		refs = "0007 ?s_pfn_RoUninitialize@WinRT@details@Concurrency@@0P6AXXZEA 000c ?DecodePointer@Security@details@Concurrency@@SAPEAXPEAX@Z 0020 ??_C@_1BC@CNPLJCBN@?$AAp?$AAf?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 002c ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0041 ??_C@_1GC@OBJNJGOC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 004b _CrtDbgReportW"
	strings:
		$1 = { 48 83 EC 48 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3E 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B8 33 C0 85 C0 75 B2 FF 54 24 30 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_63_40_0 {
	meta:
		name = "HRESULT_FROM_WIN32"
		size = 53
	strings:
		$1 = { 89 4C 24 08 48 83 EC 18 83 7C 24 20 00 7F 09 8B 44 24 20 89 04 24 EB 15 8B 44 24 20 25 FF FF 00 00 0D 00 00 07 00 0F BA E8 1F 89 04 24 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_65_3_0 {
	meta:
		name = "_mbsset_s_l"
		size = 1540
		refs = "005d ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@ 0069 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 007e ??_C@_1FA@DBKNDJKD@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAm?$AAb?$AAs?$AAs?$AAe@ 0088 _CrtDbgReportW 009c _errno 00bf ??_C@_1BI@KPNHPBOK@?$AA_?$AAm?$AAb?$AAs?$AAs?$AAe?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 00cb _invalid_parameter 00ea ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 00f7 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 011e _strset_s 012f ??1_LocaleUpdate@@QEAA@XZ 019c _ismbblead_l 0210 __crtDebugFillThreshold 024d memset 0407 ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 043a ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@"
	strings:
		$1 = { 4C 89 4C 24 20 44 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC B8 00 00 00 C7 44 24 4C 00 00 00 00 48 83 BC 24 C0 00 00 00 00 74 15 48 83 BC 24 C8 00 00 00 00 76 0A C7 44 24 58 01 00 00 00 EB 08 C7 44 24 58 00 00 00 00 8B 44 24 58 89 44 24 50 83 7C 24 50 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 18 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 50 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 18 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 23 05 00 00 48 8B 94 24 D8 00 00 00 48 8D 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 48 8D 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 48 8B 40 08 83 78 08 00 75 37 44 8B 84 24 D0 00 00 00 48 8B 94 24 C8 00 00 00 48 8B 8C 24 C0 00 00 00 E8 ?? ?? ?? ?? 89 44 24 64 48 8D 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 64 E9 C0 04 00 00 48 8B 84 24 C0 00 00 00 48 89 44 24 40 48 8B 84 24 C8 00 00 00 48 89 44 24 38 8B 84 24 D0 00 00 00 C1 E8 08 88 44 24 30 8B 84 24 D0 00 00 00 25 FF 00 00 00 88 44 24 31 0F B6 44 24 30 85 C0 74 27 0F B6 44 24 31 85 C0 74 4D 48 8D 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 0F B6 4C 24 30 48 8B D0 E8 ?? ?? ?? ?? 85 C0 74 2F 0F B6 44 24 30 85 C0 0F 85 C9 00 00 00 48 8D 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 0F B6 4C 24 31 48 8B D0 E8 ?? ?? ?? ?? 85 C0 0F 84 A7 00 00 00 48 8B 84 24 C0 00 00 00 C6 00 00 48 83 BC 24 C8 00 00 00 FF 74 68 48 81 BC 24 C8 00 00 00 FF FF FF 7F 74 5A 48 83 BC 24 C8 00 00 00 01 76 4F 48 8B 84 24 C8 00 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 0E 48 8B 05 ?? ?? ?? ?? 48 89 44 24 70 EB 10 48 8B 84 24 C8 00 00 00 48 FF C8 48 89 44 24 70 48 8B 84 24 C0 00 00 00 48 FF C0 4C 8B 44 24 70 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 44 24 5C 2A 00 00 00 48 8D 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 5C E9 82 03 00 00 0F B6 44 24 30 85 C0 0F 84 AE 00 00 00 48 8B 44 24 40 0F B6 00 85 C0 0F 84 9C 00 00 00 48 8B 44 24 38 48 FF C8 48 89 44 24 38 48 83 7C 24 38 00 0F 86 83 00 00 00 B8 01 00 00 00 48 6B C0 01 48 8B 4C 24 40 0F B6 04 01 85 C0 75 1F 48 8B 44 24 40 C6 00 00 48 8B 44 24 38 48 FF C0 48 89 44 24 38 C7 44 24 4C 01 00 00 00 EB 4E 48 8B 44 24 40 0F B6 4C 24 30 88 08 48 8B 44 24 40 48 FF C0 48 89 44 24 40 48 8B 44 24 38 48 FF C8 48 89 44 24 38 48 83 7C 24 38 00 75 02 EB 1E 48 8B 44 24 40 0F B6 4C 24 31 88 08 48 8B 44 24 40 48 FF C0 48 89 44 24 40 E9 54 FF FF FF EB 3C 48 8B 44 24 40 0F B6 00 85 C0 74 30 48 8B 44 24 38 48 FF C8 48 89 44 24 38 48 83 7C 24 38 00 76 1B 48 8B 44 24 40 0F B6 4C 24 31 88 08 48 8B 44 24 40 48 FF C0 48 89 44 24 40 EB C4 48 83 7C 24 38 00 0F 85 4D 01 00 00 48 8B 84 24 C0 00 00 00 C6 00 00 48 83 BC 24 C8 00 00 00 FF 74 71 48 81 BC 24 C8 00 00 00 FF FF FF 7F 74 63 48 83 BC 24 C8 00 00 00 01 76 58 48 8B 84 24 C8 00 00 00 48 FF C8 48 39 05 ?? ?? ?? ?? 73 11 48 8B 05 ?? ?? ?? ?? 48 89 84 24 80 00 00 00 EB 13 48 8B 84 24 C8 00 00 00 48 FF C8 48 89 84 24 80 00 00 00 48 8B 84 24 C0 00 00 00 48 FF C0 4C 8B 84 24 80 00 00 00 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 85 C0 74 10 33 C0 85 C0 74 0A C7 44 24 48 01 00 00 00 EB 08 C7 44 24 48 00 00 00 00 8B 44 24 48 89 44 24 54 83 7C 24 54 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 4E 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 54 00 75 52 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 4E 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 60 16 00 00 00 48 8D 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 60 E9 32 01 00 00 48 83 BC 24 C8 00 00 00 FF 0F 84 CC 00 00 00 48 81 BC 24 C8 00 00 00 FF FF FF 7F 0F 84 BA 00 00 00 48 8B 44 24 38 48 8B 8C 24 C8 00 00 00 48 2B C8 48 8B C1 48 FF C0 48 3B 84 24 C8 00 00 00 0F 83 96 00 00 00 48 8B 44 24 38 48 8B 8C 24 C8 00 00 00 48 2B C8 48 8B C1 48 FF C0 48 8B 8C 24 C8 00 00 00 48 2B C8 48 8B C1 48 39 05 ?? ?? ?? ?? 73 0E 48 8B 05 ?? ?? ?? ?? 48 89 44 24 78 EB 29 48 8B 44 24 38 48 8B 8C 24 C8 00 00 00 48 2B C8 48 8B C1 48 FF C0 48 8B 8C 24 C8 00 00 00 48 2B C8 48 8B C1 48 89 44 24 78 48 8B 44 24 38 48 8B 8C 24 C8 00 00 00 48 2B C8 48 8B C1 48 8B 8C 24 C0 00 00 00 48 8D 44 01 01 4C 8B 44 24 78 BA FE 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 83 7C 24 4C 00 74 28 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 44 24 6C 2A 00 00 00 48 8D 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 6C EB 2A EB 1B C7 44 24 68 00 00 00 00 48 8D 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 68 EB 0D 48 8D 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 B8 00 00 00 C3 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "wcscmp"
		size = 126
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 18 C7 04 24 00 00 00 00 48 8B 44 24 20 0F B7 00 48 8B 4C 24 28 0F B7 09 2B C1 89 04 24 83 3C 24 00 75 2A 48 8B 44 24 28 0F B7 00 85 C0 74 1E 48 8B 44 24 20 48 83 C0 02 48 89 44 24 20 48 8B 44 24 28 48 83 C0 02 48 89 44 24 28 EB BB 83 3C 24 00 7D 09 C7 04 24 FF FF FF FF EB 0D 83 3C 24 00 7E 07 C7 04 24 01 00 00 00 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_68_8_0 {
	meta:
		name = "??0?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QEAA@XZ"
		size = 23
		altNames = "??0?$List@UBoostedObject@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QEAA@XZ ??0?$List@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@@details@Concurrency@@QEAA@XZ ??0?$LockFreePushStack@VContextNode@SchedulerBase@details@Concurrency@@@details@Concurrency@@QEAA@XZ ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@D@std@@@std@@@std@@QEAA@XZ ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@G@std@@@std@@@std@@QEAA@XZ ??0?$_String_const_iterator@V?$_String_val@U?$_Simple_types@_W@std@@@std@@@std@@QEAA@XZ ??0Block@_HeapManager@@QEAA@XZ ??0StructuredEvent@details@Concurrency@@QEAA@XZ ??0_Container_base12@std@@QEAA@XZ ??0cancellation_token@Concurrency@@AEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 8B 44 24 08 48 C7 00 00 00 00 00 48 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_68_9_0 {
	meta:
		name = "??0?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@XZ"
		size = 46
		refs = "000f ??0?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QEAA@XZ 0020 ??0_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C0 08 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_25_0 {
	meta:
		name = "??0?$SafeRWList@UBoostedObject@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@XZ"
		size = 46
		refs = "000f ??0?$List@UBoostedObject@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QEAA@XZ 0020 ??0_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C0 08 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_978_26_0 {
	meta:
		name = "??0?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QEAA@XZ"
		size = 46
		refs = "000f ??0?$List@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@@details@Concurrency@@QEAA@XZ 0020 ??0_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C0 08 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_68_11_0 {
	meta:
		name = "??0Transmogrificator@details@Concurrency@@QEAA@XZ"
		size = 320
		refs = "0048 ??0?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@XZ 0067 __imp_CreateEventW 0088 __imp_GetLastError 008f HRESULT_FROM_WIN32 009b ??0scheduler_resource_allocation_error@Concurrency@@QEAA@J@Z 00a2 _TI2?AVscheduler_resource_allocation_error@Concurrency@@ 00ac _CxxThrowException 00c1 __imp_InitializeSListHead 00ec ?TransmogrificationHandler@Transmogrificator@details@Concurrency@@CAXPEAXE@Z 0101 __imp_RegisterWaitForSingleObject"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 78 48 8B 84 24 80 00 00 00 48 C7 40 08 00 00 00 00 48 8B 84 24 80 00 00 00 48 C7 40 10 00 00 00 00 48 8B 84 24 80 00 00 00 C7 40 18 00 00 00 00 48 8B 84 24 80 00 00 00 48 83 C0 20 48 8B C8 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 C7 40 30 00 00 00 00 45 33 C9 45 33 C0 33 D2 33 C9 FF 15 ?? ?? ?? ?? 48 8B 8C 24 80 00 00 00 48 89 41 10 48 8B 84 24 80 00 00 00 48 83 78 10 00 75 2A FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 48 83 C0 40 48 8B C8 FF 15 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 48 83 C0 08 C7 44 24 28 00 00 00 00 C7 44 24 20 FF FF FF FF 4C 8B 8C 24 80 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 8C 24 80 00 00 00 48 8B 51 10 48 8B C8 FF 15 ?? ?? ?? ?? 85 C0 75 2A FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 50 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_68_12_0 {
	meta:
		name = "??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?_AcquireWrite@_ReaderWriterLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_688_12_0 {
	meta:
		name = "??0ScopedCriticalRegion@ContextBase@details@Concurrency@@QEAA@PEAV123@@Z"
		size = 50
		refs = "0024 ?EnterCriticalRegion@ContextBase@details@Concurrency@@QEAAHXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_816_12_0 {
	meta:
		name = "??0_Scoped_lock@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?AcquireWrite@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEBAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_372_44_0 {
	meta:
		name = "??0_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?_Acquire@_CriticalNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1210_19_0 {
	meta:
		name = "??0_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?_Acquire@_HyperNonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_241_27_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?_Acquire@_NonReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_767_10_0 {
	meta:
		name = "??0_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?_Acquire@_NonReentrantLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_989_15_0 {
	meta:
		name = "??0_Scoped_lock@_ReentrantBlockingLock@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?_Acquire@_ReentrantBlockingLock@details@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_869_26_0 {
	meta:
		name = "??0_Scoped_lock_read@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAA@AEAV123@@Z"
		size = 50
		refs = "0024 ?AcquireRead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEBAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_133_35_0 {
	meta:
		name = "??0scoped_lock_read@reader_writer_lock@Concurrency@@QEAA@AEAV12@@Z"
		size = 50
		refs = "0024 ?lock_read@reader_writer_lock@Concurrency@@QEAAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 4C 24 38 48 89 08 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_68_17_0 {
	meta:
		name = "??1Transmogrificator@details@Concurrency@@QEAA@XZ"
		size = 227
		refs = "0018 ??_C@_1DA@BMMAOIN@?$AAm?$AA_?$AAq?$AAu?$AAe?$AAu?$AAe?$AAd?$AAP?$AAr?$AAo?$AAx?$AAy?$AAC?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0024 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0039 ??_C@_1GM@IJBOIHFN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0043 _CrtDbgReportW 0069 __imp_InterlockedFlushSList 009d ?Shutdown@TransmogrifiedPrimary@details@Concurrency@@QEAAXXZ 00cb __imp_UnregisterWaitEx 00da __imp_CloseHandle"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 58 48 8B 44 24 60 8B 40 18 85 C0 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3E 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B4 33 C0 85 C0 75 AE 48 8B 44 24 60 48 83 C0 40 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 74 33 48 8B 44 24 30 48 8B 00 48 89 44 24 40 48 8B 44 24 30 48 2D 80 00 00 00 48 89 44 24 38 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 89 44 24 30 EB C5 48 8B 44 24 60 48 83 78 08 00 74 16 48 C7 C2 FF FF FF FF 48 8B 44 24 60 48 8B 48 08 FF 15 ?? ?? ?? ?? 48 8B 44 24 60 48 8B 48 10 FF 15 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_68_21_0 {
	meta:
		name = "??3@YAXPEAXV_ConcRTNewMoniker@@PEBDH@Z"
		size = 38
		refs = "001d ??3@YAXPEAX@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_241_76_0 {
	meta:
		name = "??_V@YAXPEAXV_ConcRTNewMoniker@@PEBDH@Z"
		size = 38
		refs = "001d ??_V@YAXPEAX@Z"
	strings:
		$1 = { 44 89 4C 24 20 4C 89 44 24 18 88 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_68_34_0 {
	meta:
		name = "?AddTail@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QEAAXPEAUListEntry@23@@Z"
		size = 229
		refs = "0019 ??_C@_1BG@DFKLBKHK@?$AAp?$AAN?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0025 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 003a ??_C@_1FM@JENKPLPC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAc?$AAo?$AAn?$AAc?$AAr?$AAt?$AA?2@ 0044 _CrtDbgReportW 00dc ?Increment@NoCount@CollectionTypes@details@Concurrency@@SAXXZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 83 7C 24 48 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 8B 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 33 C0 85 C0 75 B8 33 C0 85 C0 75 B2 48 8B 44 24 40 48 83 38 00 75 1D 48 8B 44 24 48 48 8B 4C 24 48 48 89 48 08 48 8B 44 24 48 48 8B 4C 24 48 48 89 08 EB 4A 48 8B 44 24 40 48 8B 00 48 8B 4C 24 48 48 8B 40 08 48 89 41 08 48 8B 44 24 48 48 8B 4C 24 40 48 8B 09 48 89 08 48 8B 44 24 40 48 8B 00 48 8B 40 08 48 8B 4C 24 48 48 89 08 48 8B 44 24 40 48 8B 00 48 8B 4C 24 48 48 89 48 08 48 8B 44 24 40 48 8B 4C 24 48 48 89 08 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_68_35_0 {
	meta:
		name = "?AddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAAXPEAUListEntry@23@@Z"
		size = 77
		refs = "0029 ??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@AEAV123@@Z 0039 ?AddTail@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QEAAXPEAUListEntry@23@@Z 0044 ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 FE FF FF FF 48 8B 44 24 40 48 83 C0 08 48 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 90 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_978_180_0 {
	meta:
		name = "?AddTail@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QEAAXPEAVWaitNode@SchedulerBase@23@@Z"
		size = 77
		refs = "0029 ??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@AEAV123@@Z 0039 ?AddTail@?$List@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@@details@Concurrency@@QEAAXPEAVWaitNode@SchedulerBase@23@@Z 0044 ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 FE FF FF FF 48 8B 44 24 40 48 83 C0 08 48 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 90 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_630_210_0 {
	meta:
		name = "?Remove@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAAXPEAUListEntry@23@@Z"
		size = 77
		refs = "0029 ??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@AEAV123@@Z 0039 ?Remove@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QEAAXPEAUListEntry@23@@Z 0044 ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 28 FE FF FF FF 48 8B 44 24 40 48 83 C0 08 48 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 90 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_68_36_0 {
	meta:
		name = "?dtor$0@?0??AddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAAXPEAUListEntry@23@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
		altNames = "?dtor$0@?0??AddTail@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QEAAXPEAVWaitNode@SchedulerBase@23@@Z@4HA ?dtor$0@?0??Remove@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAAXPEAUListEntry@23@@Z@4HA ?dtor$0@?0??RemoveHead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAAPEAUListEntry@23@XZ@4HA ?dtor$0@?0??RemoveHead@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QEAAPEAVWaitNode@SchedulerBase@23@XZ@4HA"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_33_425_3 {
	meta:
		name = "?dtor$0@?0???4_Iterator_base12@std@@QEAAAEAU01@AEBU01@@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_978_200_0 {
	meta:
		name = "?dtor$0@?0??CheckStaticConstruction@SchedulerBase@details@Concurrency@@CAXXZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_978_235_0 {
	meta:
		name = "?dtor$0@?0??Dequeue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVInternalContextBase@23@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_372_133_0 {
	meta:
		name = "?dtor$0@?0??Dequeue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVRealizedChore@23@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1352_42_0 {
	meta:
		name = "?dtor$0@?0??Dequeue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QEAAPEAVUMSThreadProxy@23@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_562_30_0 {
	meta:
		name = "?dtor$0@?0??Enqueue@?$SafeSQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAXPEAVInternalContextBase@23@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_372_141_0 {
	meta:
		name = "?dtor$0@?0??Enqueue@?$SafeSQueue@VRealizedChore@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAXPEAVRealizedChore@23@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1352_45_0 {
	meta:
		name = "?dtor$0@?0??Enqueue@?$SafeSQueue@VUMSThreadProxy@details@Concurrency@@V_NonReentrantLock@23@@details@Concurrency@@QEAAXPEAVUMSThreadProxy@23@@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_241_135_0 {
	meta:
		name = "?dtor$0@?0??GetCoreCount@ResourceManager@details@Concurrency@@SAIXZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1117_94_0 {
	meta:
		name = "?dtor$0@?0??GetFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QEAAPEAVFreeThreadProxyFactory@23@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_241_152_0 {
	meta:
		name = "?dtor$0@?0??GetNodeCount@ResourceManager@details@Concurrency@@SAIXZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1117_101_0 {
	meta:
		name = "?dtor$0@?0??GetUMSFreeThreadProxyFactory@ThreadProxyFactoryManager@details@Concurrency@@QEAAPEAVUMSFreeThreadProxyFactory@23@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantBlockingLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_1210_150_0 {
	meta:
		name = "?dtor$0@?0??Steal@?$StructuredWorkStealingQueue@VInternalContextBase@details@Concurrency@@V_HyperNonReentrantLock@23@@details@Concurrency@@QEAAPEAVInternalContextBase@23@_N@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_HyperNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_967_68_0 {
	meta:
		name = "?dtor$0@?0??Steal@WorkQueue@details@Concurrency@@QEAAPEAV_UnrealizedChore@23@_N@Z@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_CriticalNonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_241_244_0 {
	meta:
		name = "?dtor$0@?0??Version@ResourceManager@details@Concurrency@@SA?AW4OSVersion@IResourceManager@3@XZ@4HA"
		size = 24
		refs = "000e ??1_Scoped_lock@_NonReentrantLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_124_191_3 {
	meta:
		name = "?dtor$0@?0??_Adopt@_Iterator_base12@std@@QEAAXPEBU_Container_base12@2@@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_934_110_0 {
	meta:
		name = "?dtor$0@?0??_DeleteExceptionPtr@@YAXQEAV__ExceptionPtr@@@Z@4HA"
		size = 24
		refs = "000e ??1?$_DebugMallocator@V__ExceptionPtr@@@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_934_113_0 {
	meta:
		name = "?dtor$0@?0??_Delete_this@?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@std@@EEAAXXZ@4HA"
		size = 24
		refs = "000e ??1?$_DebugMallocator@V?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@std@@@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_76_96_1 {
	meta:
		name = "?dtor$0@?0??_Init@locale@std@@CAPEAV_Locimp@12@_N@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_62_1175_2 {
	meta:
		name = "?dtor$0@?0??_JoinAllTokens_Add@details@Concurrency@@YAXAEBVcancellation_token_source@2@PEAV_CancellationTokenState@12@@Z@4HA"
		size = 24
		refs = "000e ??1cancellation_token@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_63_117_3 {
	meta:
		name = "?dtor$0@?0??_Locimp_dtor@_Locimp@locale@std@@CAXPEAV123@@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_58_1229_3 {
	meta:
		name = "?dtor$0@?0??_Orphan_range@?$vector@PEAXV?$allocator@PEAX@std@@@std@@IEBAXPEAPEAX0@Z@4HA"
		size = 24
		refs = "000e ??1_Lockit@std@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_108_1190_1 {
	meta:
		name = "?dtor$0@?0??_RunTask@_TaskCollectionImpl@details@Concurrency@@SAXP6AXPEAX@Z0W4_TaskInliningMode@23@@Z@4HA"
		size = 24
		refs = "000e ??1_StackGuard@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_934_15_0 {
	meta:
		name = "?dtor$1@?0???$_Resetp@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@?$shared_ptr@V__ExceptionPtr@@@std@@AEAAXPEAV__ExceptionPtr@@P6AX0@ZV?$_DebugMallocator@H@@@Z@4HA"
		size = 24
		refs = "000e ??1?$_DebugMallocator@V?$_Ref_count_del_alloc@V__ExceptionPtr@@P6AXPEAV1@@ZV?$_DebugMallocator@H@@@std@@@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_934_90_0 {
	meta:
		name = "?dtor$2@?0??_CopyException@__ExceptionPtr@@SA?AV?$shared_ptr@V__ExceptionPtr@@@std@@PEBXPEBU_s_ThrowInfo@@_N@Z@4HA"
		size = 24
		refs = "000e ??1?$_DebugMallocator@V__ExceptionPtr@@@@QEAA@XZ"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8D 4D 20 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_68_37_0 {
	meta:
		name = "?BeginTransmogrifying@Transmogrificator@details@Concurrency@@AEAAXXZ"
		size = 265
		refs = "0023 ?RemoveHead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAAPEAUListEntry@23@XZ 0060 ??_C@_0DG@PJMFFMJF@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0072 ??2@YAPEAX_KV_ConcRTNewMoniker@@PEBDH@Z 0091 ??0CachedTransmogrifiedPrimary@details@Concurrency@@QEAA@PEAVTransmogrificator@12@@Z 00de ?QueueToCompletion@TransmogrifiedPrimary@details@Concurrency@@QEAAXPEAVUMSThreadProxy@23@@Z"
	strings:
		$1 = { 48 89 4C 24 08 57 48 83 EC 70 48 C7 44 24 60 FE FF FF FF 48 8B 84 24 80 00 00 00 48 83 C0 20 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 48 48 8B 44 24 48 48 2D D0 00 00 00 48 89 44 24 30 48 8D 44 24 20 48 8B F8 33 C0 B9 01 00 00 00 F3 AA 48 8D 44 24 20 48 89 44 24 58 41 B9 A3 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 44 24 58 0F B6 10 B9 A0 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 74 19 48 8B 94 24 80 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 38 EB 09 48 C7 44 24 38 00 00 00 00 48 8B 44 24 38 48 89 44 24 50 48 8B 44 24 50 48 89 44 24 28 48 8B 44 24 30 48 83 C0 68 48 8B 4C 24 28 48 87 08 48 8B C1 48 83 F8 01 75 0F 48 8B 54 24 30 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 8B 84 24 80 00 00 00 48 83 C0 18 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 85 C0 0F 8F 10 FF FF FF 48 83 C4 70 5F C3 }
	condition:
		$1
}

rule file_68_38_0 {
	meta:
		name = "?dtor$0@?0??BeginTransmogrifying@Transmogrificator@details@Concurrency@@AEAAXXZ@4HA"
		size = 44
		refs = "0012 ??_C@_0DG@PJMFFMJF@f?3?2dd?2vctools?2crt?2crtw32?2concrt?2@ 0022 ??3@YAXPEAXV_ConcRTNewMoniker@@PEBDH@Z"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 41 B9 A3 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 45 58 0F B6 10 48 8B 4D 40 E8 ?? ?? ?? ?? 48 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_68_41_0 {
	meta:
		name = "?PerformTransmogrification@Transmogrificator@details@Concurrency@@QEAAXPEAVUMSThreadProxy@23@@Z"
		size = 154
		refs = "001c __imp_InterlockedPopEntrySList 0067 ?AddTail@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAAXPEAUListEntry@23@@Z 0091 __imp_SetEvent"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 C0 40 48 8B C8 FF 15 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 22 48 8B 44 24 40 48 83 C0 30 F0 FF 08 48 8B 44 24 20 48 2D 80 00 00 00 48 8B 4C 24 48 48 89 41 68 EB 46 48 8B 44 24 48 48 05 D0 00 00 00 48 8B 4C 24 40 48 83 C1 20 48 8B D0 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C0 18 B9 01 00 00 00 F0 0F C1 08 FF C1 8B C1 83 F8 01 75 0F 48 8B 44 24 40 48 8B 48 10 FF 15 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_68_42_0 {
	meta:
		name = "?RemoveHead@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QEAAPEAUListEntry@23@XZ"
		size = 126
		refs = "0019 ?Decrement@NoCount@CollectionTypes@details@Concurrency@@SAXXZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 83 38 00 75 04 33 C0 EB 61 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 8B 00 48 8B 40 08 48 89 44 24 20 48 8B 44 24 40 48 8B 4C 24 20 48 39 08 75 0E 48 8B 44 24 40 48 C7 00 00 00 00 00 EB 29 48 8B 44 24 20 48 8B 40 08 48 8B 4C 24 40 48 8B 09 48 89 08 48 8B 44 24 40 48 8B 00 48 8B 4C 24 20 48 8B 49 08 48 89 48 08 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_68_43_0 {
	meta:
		name = "?RemoveHead@?$SafeRWList@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@V_ReaderWriterLock@23@@details@Concurrency@@QEAAPEAUListEntry@23@XZ"
		size = 76
		refs = "0024 ??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@AEAV123@@Z 002f ?RemoveHead@?$List@UListEntry@details@Concurrency@@VNoCount@CollectionTypes@23@@details@Concurrency@@QEAAPEAUListEntry@23@XZ 003e ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 30 FE FF FF FF 48 8B 44 24 50 48 83 C0 08 48 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 90 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_978_411_0 {
	meta:
		name = "?RemoveHead@?$SafeRWList@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@V_ReaderWriterLock@34@@details@Concurrency@@QEAAPEAVWaitNode@SchedulerBase@23@XZ"
		size = 76
		refs = "0024 ??0_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@AEAV123@@Z 002f ?RemoveHead@?$List@VWaitNode@SchedulerBase@details@Concurrency@@VNoCount@CollectionTypes@34@@details@Concurrency@@QEAAPEAVWaitNode@SchedulerBase@23@XZ 003e ??1_Scoped_lock@_ReaderWriterLock@details@Concurrency@@QEAA@XZ"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 C7 44 24 30 FE FF FF FF 48 8B 44 24 50 48 83 C0 08 48 8B D0 48 8D 4C 24 20 E8 ?? ?? ?? ?? 90 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8D 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 28 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_68_45_0 {
	meta:
		name = "?ReturnToCache@Transmogrificator@details@Concurrency@@QEAAXPEAVCachedTransmogrifiedPrimary@23@@Z"
		size = 85
		refs = "0021 ?Shutdown@TransmogrifiedPrimary@details@Concurrency@@QEAAXXZ 004c __imp_InterlockedPushEntrySList"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 8B 40 30 83 F8 08 7C 0C 48 8B 4C 24 38 E8 ?? ?? ?? ?? EB 29 48 8B 44 24 30 48 83 C0 30 F0 FF 00 48 8B 44 24 38 48 05 80 00 00 00 48 8B 4C 24 30 48 83 C1 40 48 8B D0 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_68_46_0 {
	meta:
		name = "?Shutdown@TransmogrifiedPrimary@details@Concurrency@@QEAAXXZ"
		size = 29
		refs = "0014 __imp_SetEvent"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8B 48 28 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_68_47_0 {
	meta:
		name = "?TransmogrificationHandler@Transmogrificator@details@Concurrency@@CAXPEAXE@Z"
		size = 38
		refs = "001d ?BeginTransmogrifying@Transmogrificator@details@Concurrency@@AEAAXXZ"
	strings:
		$1 = { 88 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 40 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_68_48_0 {
	meta:
		name = "?UnblockTransmogrification@Transmogrificator@details@Concurrency@@QEAAXPEAVUMSThreadProxy@23@@Z"
		size = 83
		refs = "004a ?QueueToCompletion@TransmogrifiedPrimary@details@Concurrency@@QEAAXPEAVUMSThreadProxy@23@@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 48 48 83 C0 68 B9 01 00 00 00 48 89 44 24 20 33 C0 48 8B 54 24 20 48 8B 54 24 20 F0 48 0F B1 0A 48 89 44 24 28 48 83 7C 24 28 00 74 0F 48 8B 54 24 48 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_69_0_0 {
	meta:
		name = "__sse4_expf4"
		size = 624
		refs = "0003 s_dwExp2_Table 000a s_dwInvLn 0014 s_dwLnHi 001b s_dwBias 0026 flAbsMask 0032 flBound1 0059 s_dwLnLo 00a4 flTwo 0165 flBound2 018e s_dwNegRS 01f2 flInf 0256 flOne"
	strings:
		$1 = { 4C 8D 05 ?? ?? ?? ?? 0F 28 1D ?? ?? ?? ?? 0F 59 D8 0F 28 25 ?? ?? ?? ?? 0F 28 0D ?? ?? ?? ?? 66 0F 5B D3 0F 28 2D ?? ?? ?? ?? 66 0F DB E8 66 0F 66 2D ?? ?? ?? ?? 0F 50 CD 23 C9 0F 85 7F 00 00 00 0F 28 E8 66 0F 3A 08 DB 00 66 0F 7E D0 0F 59 E3 66 0F C5 D2 02 0F 59 1D ?? ?? ?? ?? 83 E0 3F 83 E2 3F 66 0F FE CA 0F 5C C4 F3 41 0F 7E 24 C0 66 0F C5 C2 04 41 0F 16 24 D0 66 0F C5 D2 06 0F 5C C3 83 E0 3F 83 E2 3F 66 0F 72 D1 06 F3 41 0F 7E 14 C0 41 0F 16 14 D0 0F 28 D8 0F 58 C0 0F 59 DB 0F 58 05 ?? ?? ?? ?? 0F C6 E2 88 66 0F 72 F1 17 0F 58 C3 66 0F EB CC 0F 59 C1 C3 0F 1F 40 00 0F 28 E8 66 0F 3A 08 DB 00 66 0F 7E D1 0F 59 E3 66 44 0F C5 CA 02 0F 59 1D ?? ?? ?? ?? 83 E1 3F 41 83 E1 3F 66 0F FE CA 0F 5C C4 F3 41 0F 7E 24 C8 66 44 0F C5 D2 04 43 0F 16 24 C8 66 44 0F C5 DA 06 0F 5C C3 41 83 E2 3F 41 83 E3 3F 66 0F 72 D1 06 F3 43 0F 7E 1C D0 43 0F 16 1C D8 0F C6 E3 88 0F 28 D8 0F 58 C0 0F 59 DB 0F 58 05 ?? ?? ?? ?? 66 0F 72 F1 17 0F 58 C3 66 0F EB CC 0F 59 C8 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 01 66 0F DF DA 66 0F DB C3 0F 50 D5 B8 03 00 00 00 23 C2 83 E2 0C 03 C0 0F 28 15 ?? ?? ?? ?? 0F 59 D5 0F 5C 15 ?? ?? ?? ?? 66 0F DB D3 66 0F DB E3 66 0F FE 15 ?? ?? ?? ?? 66 0F 72 D2 06 41 0F 28 9C C0 40 02 00 00 41 0F C6 9C 90 40 02 00 00 88 66 0F FE D3 66 0F 72 F2 17 66 0F EB D4 0F 59 C2 41 0F 28 9C C0 00 02 00 00 41 0F C6 9C 90 00 02 00 00 88 0F 59 C3 66 0F EB C1 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 0F C2 1D ?? ?? ?? ?? 01 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 01 66 0F DF D3 41 0F 28 8C C0 80 02 00 00 41 0F C6 8C 90 80 02 00 00 88 66 0F DB CA 0F 28 15 ?? ?? ?? ?? 66 0F DB D5 0F C2 15 ?? ?? ?? ?? 00 41 0F 28 9C C0 C0 02 00 00 41 0F C6 9C 90 C0 02 00 00 88 66 0F DB D3 66 0F EB CA 0F 28 15 ?? ?? ?? ?? 0F C2 D5 03 66 0F DB EA 66 0F EB CD 0F 59 C9 66 0F EB C1 C3 66 90 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "_capture_argv"
		size = 311
		refs = "0066 ??_C@_0CI@GEDFEEKK@f?3?2dd?2vctools?2crt?2crtw32?2exec?2ce@ 007b _calloc_dbg 00b1 _recalloc_dbg"
		altNames = "_wcapture_argv"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 44 24 68 48 89 44 24 48 48 8B 44 24 70 48 89 44 24 30 48 8B 44 24 78 48 89 44 24 38 48 C7 44 24 40 00 00 00 00 48 8B 44 24 38 48 39 44 24 40 0F 82 8A 00 00 00 48 8B 44 24 70 48 39 44 24 30 75 2B C7 44 24 20 7D 01 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 10 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 89 44 24 30 EB 34 C7 44 24 28 81 01 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 41 B9 02 00 00 00 41 B8 10 00 00 00 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 75 02 EB 69 48 8B 44 24 38 48 8B 4C 24 38 48 03 C8 48 8B C1 48 89 44 24 38 48 8B 44 24 30 48 8B 4C 24 40 48 8B 54 24 48 48 89 14 C8 48 8B 44 24 40 48 FF C0 48 89 44 24 40 48 83 7C 24 48 00 75 02 EB 2A 48 8B 44 24 60 48 8B 00 48 83 C0 08 48 8B 4C 24 60 48 89 01 48 8B 44 24 60 48 8B 00 48 8B 40 F8 48 89 44 24 48 E9 12 FF FF FF 48 8B 44 24 30 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_70_1_0 {
	meta:
		name = "_cenvarg"
		size = 2414
		refs = "0020 __security_cookie 005a ??_C@_0L@NKOGAPMJ@SystemRoot?$AA@ 00b4 strlen 00f6 ??_C@_0CI@GEDFEEKK@f?3?2dd?2vctools?2crt?2crtw32?2exec?2ce@ 0108 _calloc_dbg 0135 _errno 0140 __doserrno 017e _dupenv_s_dbg 0196 ??_C@_1FA@OEIDGIOE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAe?$AAx?$AAe?$AAc?$AA?2?$AAc?$AAe@ 01a2 ??_C@_1BC@CECMOJAP@?$AA_?$AAc?$AAe?$AAn?$AAv?$AAa?$AAr?$AAg?$AA?$AA@ 01ae ??_C@_1MK@IPOCIHON@?$AA_?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAd?$AAb?$AAg?$AA?$CI?$AA?$CG?$AAe?$AAn?$AAv?$AAb?$AAu?$AAf?$AA?0?$AA?5?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ@ 01c0 _invoke_watson_if_oneof 0297 _aenvptr 029f __crtGetEnvironmentStringsA 041b _mbsnicmp 0495 _free_dbg 0533 strcpy_s 0559 ??_C@_1GA@DPBIEIFG@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAc?$AAp?$AAt?$AAr?$AA?0?$AA?5?$AAa?$AAr?$AAg?$AA_?$AAl?$AAe?$AAn?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAc?$AAp?$AAt?$AAr?$AA?5?$AA?9@ 0560 _invoke_watson_if_error 06cd memcpy 075f ??_C@_1GA@IPGEADAE@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAc?$AAp?$AAt?$AAr?$AA?0?$AA?5?$AAe?$AAn?$AAv?$AA_?$AAl?$AAe?$AAn?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAc?$AAp?$AAt?$AAr?$AA?5?$AA?9@ 07f5 ??_C@_1EA@IKKOENFK@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAc?$AAp?$AAt?$AAr?$AA?0?$AA?5?$AAe?$AAn?$AAv?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AAe?$AAn?$AAv?$AAp?$AAf?$AAx?$AA?$CJ?$AA?$AA@ 0808 ??_C@_01NEMOKFLO@?$DN?$AA@ 0815 strcat_s 083b ??_C@_1DK@EIJJPLHB@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAc?$AAp?$AAt?$AAr?$AA?0?$AA?5?$AAe?$AAn?$AAv?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AA?$CC?$AA?$DN?$AA?$CC?$AA?$CJ?$AA?$AA@ 0887 ??_C@_1EA@HHLGCDJE@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAc?$AAp?$AAt?$AAr?$AA?0?$AA?5?$AAe?$AAn?$AAv?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AAe?$AAn?$AAv?$AAb?$AAu?$AAf?$AA?$CJ?$AA?$AA@ 0960 __security_check_cookie"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 56 57 48 81 EC C8 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 B8 00 00 00 C7 44 24 74 00 00 00 00 C7 44 24 60 00 00 00 00 C7 44 24 58 00 00 00 00 C7 44 24 54 00 00 00 00 48 8D 84 24 A8 00 00 00 48 8D 0D ?? ?? ?? ?? 48 8B F8 48 8B F1 B9 0B 00 00 00 F3 A4 48 C7 44 24 68 00 00 00 00 C7 44 24 5C 00 00 00 00 C7 44 24 64 00 00 00 00 48 8B 84 24 E0 00 00 00 48 89 44 24 48 C7 44 24 50 02 00 00 00 EB 37 48 8B 44 24 48 48 8B 00 48 89 84 24 A0 00 00 00 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 8B 4C 24 50 8D 44 01 01 89 44 24 50 48 8B 44 24 48 48 83 C0 08 48 89 44 24 48 48 8B 44 24 48 48 83 38 00 74 02 EB BC 8B 44 24 50 89 44 24 70 8B 44 24 50 C7 44 24 20 65 00 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 01 00 00 00 8B C8 E8 ?? ?? ?? ?? 48 8B 8C 24 F0 00 00 00 48 89 01 48 8B 84 24 F0 00 00 00 48 83 38 00 75 2F 48 8B 84 24 F8 00 00 00 48 C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 B8 FF FF FF FF E9 00 08 00 00 C7 44 24 28 6D 00 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 41 B9 02 00 00 00 4C 8D 84 24 A8 00 00 00 33 D2 48 8D 4C 24 68 E8 ?? ?? ?? ?? 48 C7 44 24 38 00 00 00 00 C7 44 24 30 6D 00 00 00 48 8D 0D ?? ?? ?? ?? 48 89 4C 24 28 48 8D 0D ?? ?? ?? ?? 48 89 4C 24 20 4C 8D 0D ?? ?? ?? ?? 41 B8 16 00 00 00 BA 16 00 00 00 8B C8 E8 ?? ?? ?? ?? 85 C0 74 0D C7 44 24 60 FF FF FF FF E9 0B 07 00 00 48 8D 8C 24 A8 00 00 00 E8 ?? ?? ?? ?? 83 C0 02 89 44 24 5C 48 83 7C 24 68 00 74 16 48 8B 4C 24 68 E8 ?? ?? ?? ?? 8B 4C 24 5C 03 C8 8B C1 89 44 24 5C 48 83 BC 24 E8 00 00 00 00 74 5B 48 8B 84 24 E8 00 00 00 48 89 44 24 48 C7 44 24 50 02 00 00 00 EB 37 48 8B 44 24 48 48 8B 00 48 89 84 24 90 00 00 00 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 8B 4C 24 50 8D 44 01 01 89 44 24 50 48 8B 44 24 48 48 83 C0 08 48 89 44 24 48 48 8B 44 24 48 48 83 38 00 74 02 EB BC C7 44 24 78 00 00 00 00 48 83 BC 24 E8 00 00 00 00 75 14 48 8B 84 24 F8 00 00 00 48 C7 00 00 00 00 00 E9 37 02 00 00 48 83 3D ?? ?? ?? ?? 00 75 23 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 75 0D C7 44 24 60 FF FF FF FF E9 1F 06 00 00 C7 44 24 58 00 00 00 00 EB 26 48 63 44 24 58 48 8B 0D ?? ?? ?? ?? 48 03 C8 48 8B C1 48 8B C8 E8 ?? ?? ?? ?? 8B 4C 24 58 8D 44 01 01 89 44 24 58 48 63 44 24 58 48 8B 0D ?? ?? ?? ?? 0F BE 04 01 85 C0 74 17 48 63 44 24 58 48 8B 0D ?? ?? ?? ?? 0F BE 04 01 83 F8 3D 74 02 EB AF 8B 44 24 58 89 44 24 54 8B 44 24 54 48 98 48 8B 0D ?? ?? ?? ?? 0F BE 04 01 83 F8 3D 75 78 8B 44 24 54 FF C0 48 98 48 8B 0D ?? ?? ?? ?? 0F BE 04 01 85 C0 74 61 8B 44 24 54 83 C0 02 48 98 48 8B 0D ?? ?? ?? ?? 0F BE 04 01 83 F8 3A 75 48 8B 44 24 54 83 C0 03 48 98 48 8B 0D ?? ?? ?? ?? 0F BE 04 01 83 F8 3D 75 2F 8B 44 24 54 83 C0 04 48 98 48 8B 0D ?? ?? ?? ?? 48 03 C8 48 8B C1 48 8B C8 E8 ?? ?? ?? ?? 8B 4C 24 54 8D 44 01 05 89 44 24 54 E9 72 FF FF FF 8B 44 24 58 8B 4C 24 54 2B C8 8B C1 8B 4C 24 50 03 C8 8B C1 89 44 24 50 8B 44 24 50 89 44 24 74 48 8B 84 24 E8 00 00 00 48 89 44 24 48 EB 0E 48 8B 44 24 48 48 83 C0 08 48 89 44 24 48 48 8B 44 24 48 48 83 38 00 74 35 48 8D 8C 24 A8 00 00 00 E8 ?? ?? ?? ?? 4C 8B C0 48 8D 94 24 A8 00 00 00 48 8B 44 24 48 48 8B 08 E8 ?? ?? ?? ?? 85 C0 75 0A C7 44 24 64 01 00 00 00 EB 02 EB B2 83 7C 24 64 00 75 10 8B 44 24 5C 8B 4C 24 50 03 C8 8B C1 89 44 24 50 8B 44 24 50 C7 44 24 20 CF 00 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 01 00 00 00 8B C8 E8 ?? ?? ?? ?? 48 8B 8C 24 F8 00 00 00 48 89 01 48 8B 84 24 F8 00 00 00 48 83 38 00 75 47 BA 02 00 00 00 48 8B 84 24 F0 00 00 00 48 8B 08 E8 ?? ?? ?? ?? 48 8B 84 24 F0 00 00 00 48 C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 C7 44 24 60 FF FF FF FF E9 48 04 00 00 48 8B 84 24 F0 00 00 00 48 8B 00 48 89 44 24 40 48 8B 84 24 E0 00 00 00 48 89 44 24 48 48 8B 44 24 48 48 83 38 00 75 12 48 8B 44 24 40 48 FF C0 48 89 44 24 40 E9 9E 00 00 00 8B 44 24 70 48 8B 8C 24 F0 00 00 00 48 8B 09 48 8B 54 24 40 48 2B D1 48 8B CA 48 2B C1 48 8B 4C 24 48 4C 8B 01 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 E6 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 8B 00 48 89 84 24 80 00 00 00 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? FF C0 48 98 48 8B 4C 24 40 48 03 C8 48 8B C1 48 89 44 24 40 48 8B 44 24 48 48 83 C0 08 48 89 44 24 48 48 8B 44 24 48 48 83 38 00 0F 84 B6 00 00 00 8B 44 24 70 48 8B 8C 24 F0 00 00 00 48 8B 09 48 8B 54 24 40 48 2B D1 48 8B CA 48 2B C1 48 8B 4C 24 48 4C 8B 01 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 EB 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 8B 00 48 89 84 24 88 00 00 00 48 8B 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 48 98 48 8B 4C 24 40 48 03 C8 48 8B C1 48 89 44 24 40 48 8B 44 24 48 48 83 C0 08 48 89 44 24 48 48 8B 44 24 40 C6 00 20 48 8B 44 24 40 48 FF C0 48 89 44 24 40 E9 3B FF FF FF B8 01 00 00 00 48 6B C0 FF 48 8B 4C 24 40 C6 04 01 00 48 8B 44 24 40 C6 00 00 48 8B 84 24 F8 00 00 00 48 8B 00 48 89 44 24 40 48 83 BC 24 E8 00 00 00 00 0F 84 06 02 00 00 8B 44 24 58 8B 4C 24 54 2B C8 8B C1 48 98 48 63 4C 24 58 48 8B 15 ?? ?? ?? ?? 48 03 D1 48 8B CA 4C 8B C0 48 8B D1 48 8B 4C 24 40 E8 ?? ?? ?? ?? 8B 44 24 58 8B 4C 24 54 2B C8 8B C1 48 98 48 8B 4C 24 40 48 03 C8 48 8B C1 48 89 44 24 40 48 8B 84 24 E8 00 00 00 48 89 44 24 48 48 8B 44 24 48 48 83 38 00 0F 84 A3 00 00 00 8B 44 24 74 48 8B 8C 24 F8 00 00 00 48 8B 09 48 8B 54 24 40 48 2B D1 48 8B CA 48 2B C1 48 8B 4C 24 48 4C 8B 01 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 05 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 8B 00 48 89 84 24 98 00 00 00 48 8B 8C 24 98 00 00 00 E8 ?? ?? ?? ?? FF C0 48 98 48 8B 4C 24 40 48 03 C8 48 8B C1 48 89 44 24 40 48 8B 44 24 48 48 83 C0 08 48 89 44 24 48 E9 4E FF FF FF 83 7C 24 64 00 0F 85 EE 00 00 00 48 63 44 24 5C 4C 8D 84 24 A8 00 00 00 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 0D 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 63 44 24 5C 4C 8D 05 ?? ?? ?? ?? 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 0E 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 83 7C 24 68 00 74 44 48 63 44 24 5C 4C 8B 44 24 68 48 8B D0 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 11 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 63 44 24 5C 48 8B 4C 24 40 48 03 C8 48 8B C1 48 89 44 24 40 48 83 7C 24 40 00 74 2F 48 8B 84 24 F8 00 00 00 48 8B 00 48 39 44 24 40 75 15 48 8B 44 24 40 C6 00 00 48 8B 44 24 40 48 FF C0 48 89 44 24 40 48 8B 44 24 40 C6 00 00 EB 33 BA 02 00 00 00 48 8B 84 24 F0 00 00 00 48 8B 08 E8 ?? ?? ?? ?? 48 8B 84 24 F0 00 00 00 48 C7 00 00 00 00 00 48 8B 84 24 F8 00 00 00 48 C7 00 00 00 00 00 48 83 3D ?? ?? ?? ?? 00 74 11 BA 02 00 00 00 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 83 7C 24 68 00 74 0F BA 02 00 00 00 48 8B 4C 24 68 E8 ?? ?? ?? ?? 8B 44 24 60 48 8B 8C 24 B8 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 C8 00 00 00 5F 5E C3 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "strcspn"
		size = 334
		refs = "0011 __security_cookie 0067 __report_rangecheckfailure 0145 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 78 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 60 48 8B 84 24 80 00 00 00 48 89 44 24 30 48 8B 84 24 88 00 00 00 48 89 44 24 28 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 83 7C 24 20 20 7D 25 48 63 44 24 20 48 89 44 24 38 48 83 7C 24 38 20 73 02 EB 05 E8 ?? ?? ?? ?? 48 8B 44 24 38 C6 44 04 40 00 EB CA 48 8B 44 24 28 0F B6 00 85 C0 74 49 48 8B 44 24 28 0F B6 00 C1 F8 03 48 98 48 8B 4C 24 28 0F B6 09 83 E1 07 BA 01 00 00 00 D3 E2 8B CA 0F B6 44 04 40 0B C1 48 8B 4C 24 28 0F B6 09 C1 F9 03 48 63 C9 88 44 0C 40 48 8B 44 24 28 48 FF C0 48 89 44 24 28 EB AB C7 44 24 20 00 00 00 00 B8 01 00 00 00 48 6B C0 00 0F B6 44 04 40 83 C8 01 B9 01 00 00 00 48 6B C9 00 88 44 0C 40 48 8B 44 24 30 0F B6 00 C1 F8 03 48 98 0F B6 44 04 40 48 8B 4C 24 30 0F B6 09 83 E1 07 BA 01 00 00 00 D3 E2 8B CA 23 C1 85 C0 75 19 8B 44 24 20 FF C0 89 44 24 20 48 8B 44 24 30 48 FF C0 48 89 44 24 30 EB BB 48 63 44 24 20 48 8B 4C 24 60 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_72_0_0 {
	meta:
		name = "_futime64"
		size = 962
		refs = "0013 __security_cookie 0031 _errno 0051 _nhandle 0082 ??_C@_1FO@LPCLHKGE@?$AA?$CI?$AAf?$AAh?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAh?$AA?5?$AA?$DM?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi@ 008e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00a3 ??_C@_1FA@GJGIKPLC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAu?$AAt@ 00ad _CrtDbgReportW 00e4 ??_C@_1BE@ECEDMFCE@?$AA_?$AAf?$AAu?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA?$AA@ 00f0 _invalid_parameter 010d __pioinfo 0156 ??_C@_1CM@OKGMMMDH@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 01e6 _time64 021f _localtime64_s 0290 __imp_SystemTimeToFileTime 02a4 __imp_LocalFileTimeToFileTime 0379 _get_osfhandle 038e __imp_SetFileTime 03b6 __security_check_cookie"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 81 EC B8 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 A0 00 00 00 48 63 84 24 C0 00 00 00 48 83 F8 FE 75 15 E8 ?? ?? ?? ?? C7 00 09 00 00 00 B8 FF FF FF FF E9 65 03 00 00 83 BC 24 C0 00 00 00 00 7C 19 8B 05 ?? ?? ?? ?? 39 84 24 C0 00 00 00 73 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 30 83 7C 24 30 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 7F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 30 00 75 3E E8 ?? ?? ?? ?? C7 00 09 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 7F 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 AC 02 00 00 8B 84 24 C0 00 00 00 C1 F8 05 48 98 48 8D 0D ?? ?? ?? ?? 8B 94 24 C0 00 00 00 83 E2 1F 48 63 D2 48 6B D2 58 48 8B 04 C1 0F BE 44 10 08 83 E0 01 85 C0 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 80 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3E E8 ?? ?? ?? ?? C7 00 09 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 80 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 D8 01 00 00 48 83 BC 24 C8 00 00 00 00 75 2D 48 8D 8C 24 98 00 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 98 00 00 00 48 89 84 24 90 00 00 00 48 8D 84 24 90 00 00 00 48 89 84 24 C8 00 00 00 48 8B 84 24 C8 00 00 00 48 83 C0 08 48 8B D0 48 8D 4C 24 68 E8 ?? ?? ?? ?? 85 C0 74 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF FF E9 6E 01 00 00 8B 44 24 7C 05 6C 07 00 00 66 89 44 24 58 8B 44 24 78 FF C0 66 89 44 24 5A 0F B7 44 24 74 66 89 44 24 5E 0F B7 44 24 70 66 89 44 24 60 0F B7 44 24 6C 66 89 44 24 62 0F B7 44 24 68 66 89 44 24 64 33 C0 66 89 44 24 66 48 8D 54 24 40 48 8D 4C 24 58 FF 15 ?? ?? ?? ?? 85 C0 74 14 48 8D 54 24 48 48 8D 4C 24 40 FF 15 ?? ?? ?? ?? 85 C0 75 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF FF E9 E9 00 00 00 48 8B 84 24 C8 00 00 00 48 8B D0 48 8D 4C 24 68 E8 ?? ?? ?? ?? 85 C0 74 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF FF E9 BB 00 00 00 8B 44 24 7C 05 6C 07 00 00 66 89 44 24 58 8B 44 24 78 FF C0 66 89 44 24 5A 0F B7 44 24 74 66 89 44 24 5E 0F B7 44 24 70 66 89 44 24 60 0F B7 44 24 6C 66 89 44 24 62 0F B7 44 24 68 66 89 44 24 64 33 C0 66 89 44 24 66 48 8D 54 24 40 48 8D 4C 24 58 FF 15 ?? ?? ?? ?? 85 C0 74 14 48 8D 54 24 50 48 8D 4C 24 40 FF 15 ?? ?? ?? ?? 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF FF EB 39 8B 8C 24 C0 00 00 00 E8 ?? ?? ?? ?? 4C 8D 4C 24 48 4C 8D 44 24 50 33 D2 48 8B C8 FF 15 ?? ?? ?? ?? 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 FF FF FF FF EB 02 33 C0 48 8B 8C 24 A0 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 B8 00 00 00 C3 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "?_vswprintf_l@@YAHPEAG_KPEBGPEAUlocaleinfo_struct@@PEAD@Z"
		size = 64
		refs = "0037 ?_vswprintf_l@@YAHPEA_W_KPEB_WPEAUlocaleinfo_struct@@PEAD@Z"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 60 48 89 44 24 20 4C 8B 4C 24 58 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_110_15_1 {
	meta:
		name = "??$_LStrcoll@D@std@@YAHPEBD000PEBU_Collvec@@@Z"
		size = 64
		refs = "0037 _Strcoll"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 60 48 89 44 24 20 4C 8B 4C 24 58 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_111_38_1 {
	meta:
		name = "??$_LStrcoll@_W@std@@YAHPEB_W000PEBU_Collvec@@@Z"
		size = 64
		refs = "0037 _Wcscoll"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 60 48 89 44 24 20 4C 8B 4C 24 58 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_110_16_1 {
	meta:
		name = "??$_LStrxfrm@D@std@@YA_KPEAD0PEBD1PEBU_Collvec@@@Z"
		size = 64
		refs = "0037 _Strxfrm"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 60 48 89 44 24 20 4C 8B 4C 24 58 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_111_40_1 {
	meta:
		name = "??$_LStrxfrm@_W@std@@YA_KPEA_W0PEB_W1PEBU_Collvec@@@Z"
		size = 64
		refs = "0037 _Wcsxfrm"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 60 48 89 44 24 20 4C 8B 4C 24 58 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_73_1_0 {
	meta:
		name = "?_vswprintf_l@@YAHPEA_W_KPEB_WPEAUlocaleinfo_struct@@PEAD@Z"
		size = 529
		refs = "004e ??_C@_1BO@JIBAMMGI@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 005a ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006f ??_C@_1FI@INBBJHMC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAi?$AAo?$AA?2?$AAv@ 0079 _CrtDbgReportW 0093 ??_C@_1BO@MLMCMBKN@?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0144 _woutput_l 01a0 _flsbuf"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 57 48 81 EC 80 00 00 00 48 C7 44 24 50 00 00 00 00 48 8D 44 24 58 48 8B F8 33 C0 B9 28 00 00 00 F3 AA 48 8D 44 24 50 48 89 44 24 30 48 83 BC 24 90 00 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 56 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 83 BC 24 A0 00 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 57 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 44 24 30 C7 40 18 42 00 00 00 48 8B 44 24 30 48 8B 8C 24 90 00 00 00 48 89 48 10 48 8B 44 24 30 48 8B 8C 24 90 00 00 00 48 89 08 48 81 BC 24 98 00 00 00 FF FF FF 3F 76 0E 48 8B 44 24 30 C7 40 08 FF FF FF 7F EB 13 48 8B 84 24 98 00 00 00 48 D1 E0 48 8B 4C 24 30 89 41 08 4C 8B 8C 24 B0 00 00 00 4C 8B 84 24 A8 00 00 00 48 8B 94 24 A0 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 89 44 24 48 48 8B 44 24 30 8B 40 08 FF C8 89 44 24 3C 48 8B 44 24 30 8B 4C 24 3C 89 48 08 83 7C 24 3C 00 7C 2B 48 8B 44 24 30 48 8B 00 C6 00 00 33 C0 25 FF 00 00 00 89 44 24 44 48 8B 44 24 30 48 8B 00 48 FF C0 48 8B 4C 24 30 48 89 01 EB 10 48 8B 54 24 30 33 C9 E8 ?? ?? ?? ?? 89 44 24 44 48 8B 44 24 30 8B 40 08 FF C8 89 44 24 38 48 8B 44 24 30 8B 4C 24 38 89 48 08 83 7C 24 38 00 7C 2B 48 8B 44 24 30 48 8B 00 C6 00 00 33 C0 25 FF 00 00 00 89 44 24 40 48 8B 44 24 30 48 8B 00 48 FF C0 48 8B 4C 24 30 48 89 01 EB 10 48 8B 54 24 30 33 C9 E8 ?? ?? ?? ?? 89 44 24 40 8B 44 24 48 48 81 C4 80 00 00 00 5F C3 }
	condition:
		$1
}

rule file_73_2_0 {
	meta:
		name = "?vswprintf@@YAHPEAG_KPEBGPEAD@Z"
		size = 62
		refs = "0035 ?_vswprintf_l@@YAHPEA_W_KPEB_WPEAUlocaleinfo_struct@@PEAD@Z"
		altNames = "?vswprintf@@YAHPEA_W_KPEB_WPEAD@Z"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 58 48 89 44 24 20 45 33 C9 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_789_0_0 {
	meta:
		name = "_vsnprintf"
		size = 62
		refs = "0035 _vsnprintf_l"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 58 48 89 44 24 20 45 33 C9 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "_vsnwprintf"
		size = 62
		refs = "0035 _vsnwprintf_l"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 58 48 89 44 24 20 45 33 C9 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_381_8_0 {
	meta:
		name = "vsprintf_s"
		size = 62
		refs = "0035 _vsprintf_s_l"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 58 48 89 44 24 20 45 33 C9 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_911_8_0 {
	meta:
		name = "vswprintf_s"
		size = 62
		refs = "0035 _vswprintf_s_l"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 58 48 89 44 24 20 45 33 C9 4C 8B 44 24 50 48 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "casinf"
		size = 115
		refs = "000f crealf 001f cimagf 0026 __xmm@80000000800000008000000080000000 0031 _FCbuild 0039 casinhf"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? F3 0F 11 44 24 20 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F3 0F 10 4C 24 20 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F3 0F 11 44 24 24 48 8B 4C 24 40 E8 ?? ?? ?? ?? F3 0F 10 4C 24 24 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "catanf"
		size = 115
		refs = "000f crealf 001f cimagf 0026 __xmm@80000000800000008000000080000000 0031 _FCbuild 0039 catanhf"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? F3 0F 11 44 24 20 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F3 0F 10 4C 24 20 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F3 0F 11 44 24 24 48 8B 4C 24 40 E8 ?? ?? ?? ?? F3 0F 10 4C 24 24 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_547_0_0 {
	meta:
		name = "csinf"
		size = 115
		refs = "000f crealf 001f cimagf 0026 __xmm@80000000800000008000000080000000 0031 _FCbuild 0039 csinhf"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? F3 0F 11 44 24 20 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F3 0F 10 4C 24 20 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F3 0F 11 44 24 24 48 8B 4C 24 40 E8 ?? ?? ?? ?? F3 0F 10 4C 24 24 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_356_0_0 {
	meta:
		name = "ctanf"
		size = 115
		refs = "000f crealf 001f cimagf 0026 __xmm@80000000800000008000000080000000 0031 _FCbuild 0039 ctanhf"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? F3 0F 11 44 24 20 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F3 0F 10 4C 24 20 E8 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F3 0F 11 44 24 24 48 8B 4C 24 40 E8 ?? ?? ?? ?? F3 0F 10 4C 24 24 E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "__sse4_exp2"
		size = 720
		refs = "0012 s_dwInvLn 001a s_dwNegRS 002b s_dwLnHi 0033 s_dwBias 0062 s_dwLnLo 0076 s_dwExp2 0094 s_dwA4 00b3 s_dwA5 00d6 s_dwA3 00de s_dwA2 00f6 s_dwOne 01a2 iAbsMask 01ae dbB1 01c7 dbB2 024a dbInf"
	strings:
		$1 = { 48 83 EC 48 0F 29 7C 24 20 0F 29 74 24 30 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D8 66 0F C5 C8 03 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 58 D3 66 0F 3A 09 DB 00 66 0F 28 E8 66 0F 7E D0 81 E1 FF 7F 00 00 66 0F 59 E3 66 0F C5 D2 04 81 F9 86 40 00 00 66 0F 59 1D ?? ?? ?? ?? 66 0F FE CA 66 0F C5 C8 07 66 0F 5C C4 4C 8D 05 ?? ?? ?? ?? 0F 8D A0 00 00 00 81 E1 FF 7F 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 41 0F 7E 24 C0 81 F9 86 40 00 00 0F 8D 91 00 00 00 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 E8 66 0F 59 C0 66 0F 73 F1 34 66 41 0F 16 24 D0 66 0F 59 D0 66 0F 59 D8 66 0F 58 15 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 D0 66 0F 59 C3 66 0F 59 D5 66 0F 58 C5 66 0F 58 15 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C2 66 0F 59 C1 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 48 C3 66 66 66 0F 1F 84 00 00 00 00 00 83 E0 3F 83 E2 3F 66 0F 5C C3 66 0F 28 1D ?? ?? ?? ?? 66 0F 73 D1 06 F3 41 0F 7E 24 C0 0F 1F 00 4C 8D 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 F8 66 0F 59 C0 66 0F 73 F1 34 66 41 0F 16 24 D0 66 0F 59 F0 66 0F 59 D8 66 0F 58 35 ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 F0 66 0F 59 C3 66 0F 59 F7 66 0F 58 C7 66 0F 58 35 ?? ?? ?? ?? 66 0F EB CC 66 0F 58 C6 66 0F 59 C8 66 0F 28 1D ?? ?? ?? ?? 66 0F DB DD 66 0F C2 1D ?? ?? ?? ?? 01 66 0F DB CB 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 01 66 0F DF DE 66 0F DB C3 66 0F DB D3 66 0F DB E3 66 0F C5 C5 03 66 0F C5 D5 07 C1 E8 0F C1 EA 0F 66 0F FE 15 ?? ?? ?? ?? 66 0F 73 D2 06 F3 41 0F 7E BC C0 00 02 00 00 66 41 0F 16 BC D0 00 02 00 00 66 0F FE D7 66 0F 73 F2 34 66 0F EB D4 66 0F 59 C2 F3 41 0F 7E BC C0 10 02 00 00 66 41 0F 16 BC D0 10 02 00 00 66 0F 59 C7 66 0F EB C1 66 0F 28 3D ?? ?? ?? ?? 66 0F DB FD 66 0F C2 3D ?? ?? ?? ?? 01 66 0F DF F7 F3 41 0F 7E 8C C0 20 02 00 00 66 41 0F 16 8C D0 20 02 00 00 66 0F DB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F DB F5 66 0F C2 35 ?? ?? ?? ?? 00 F3 41 0F 7E BC C0 30 02 00 00 66 41 0F 16 BC D0 30 02 00 00 66 0F DB F7 66 0F EB CE 66 0F 28 35 ?? ?? ?? ?? 66 0F C2 F5 03 66 0F DB EE 66 0F EB CD 66 0F 59 C9 66 0F EB C1 0F 28 74 24 30 0F 28 7C 24 20 48 83 C4 48 C3 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "_d_int"
		size = 814
		refs = "01d2 ?mask@?3??_d_int@@9@9 01f3 ?sub@?3??_d_int@@9@9"
	strings:
		$1 = { 66 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 89 44 24 18 B8 02 00 00 00 48 6B C0 03 48 8B 4C 24 18 0F B7 04 01 25 F0 7F 00 00 C1 F8 04 66 89 04 24 0F BF 04 24 3D FF 07 00 00 75 79 B8 02 00 00 00 48 6B C0 03 48 8B 4C 24 18 0F B7 04 01 83 E0 0F 85 C0 75 4C B8 02 00 00 00 48 6B C0 02 48 8B 4C 24 18 0F B7 04 01 85 C0 75 36 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 18 0F B7 04 01 85 C0 75 20 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 18 0F B7 04 01 85 C0 75 0A C7 44 24 0C 01 00 00 00 EB 08 C7 44 24 0C 02 00 00 00 0F B7 44 24 0C E9 71 02 00 00 EB 63 B8 02 00 00 00 48 6B C0 03 48 8B 4C 24 18 0F B7 04 01 0F BA F0 0F 85 C0 75 49 B8 02 00 00 00 48 6B C0 02 48 8B 4C 24 18 0F B7 04 01 85 C0 75 33 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 18 0F B7 04 01 85 C0 75 1D B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 18 0F B7 04 01 85 C0 75 07 33 C0 E9 0C 02 00 00 0F BF 04 24 B9 33 04 00 00 2B C8 8B C1 0F BF 4C 24 38 2B C1 66 89 04 24 0F BF 04 24 85 C0 7F 0C 33 C0 E9 E5 01 00 00 E9 E0 01 00 00 0F BF 04 24 83 F8 35 7C 74 B8 02 00 00 00 48 6B C0 03 48 8B 4C 24 18 0F B7 04 01 25 00 80 00 00 B9 02 00 00 00 48 6B C9 03 48 8B 54 24 18 66 89 04 0A B8 02 00 00 00 48 6B C0 02 33 C9 48 8B 54 24 18 66 89 0C 02 B8 02 00 00 00 48 6B C0 01 33 C9 48 8B 54 24 18 66 89 0C 02 B8 02 00 00 00 48 6B C0 00 33 C9 48 8B 54 24 18 66 89 0C 02 B8 FF FF FF FF E9 68 01 00 00 E9 63 01 00 00 0F BF 04 24 83 E0 0F 48 98 48 8D 0D ?? ?? ?? ?? 0F B7 04 41 66 89 44 24 04 0F B7 04 24 66 C1 F8 04 66 89 04 24 48 0F BF 04 24 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 8B 4C 24 18 0F B7 04 41 0F B7 4C 24 04 23 C8 8B C1 66 89 44 24 04 48 0F BF 04 24 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 0F B7 4C 24 04 48 8B 54 24 18 0F B7 04 42 33 C1 48 0F BF 0C 24 48 8D 15 ?? ?? ?? ?? 48 8B 0C CA 48 8B 54 24 18 66 89 04 4A 0F BF 04 24 89 44 24 08 83 7C 24 08 01 74 7B 83 7C 24 08 02 74 40 83 7C 24 08 03 74 05 E9 9C 00 00 00 B8 02 00 00 00 48 6B C0 02 48 8B 4C 24 18 0F B7 04 01 0F B7 4C 24 04 0B C8 8B C1 66 89 44 24 04 B8 02 00 00 00 48 6B C0 02 33 C9 48 8B 54 24 18 66 89 0C 02 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 18 0F B7 04 01 0F B7 4C 24 04 0B C8 8B C1 66 89 44 24 04 B8 02 00 00 00 48 6B C0 01 33 C9 48 8B 54 24 18 66 89 0C 02 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 18 0F B7 04 01 0F B7 4C 24 04 0B C8 8B C1 66 89 44 24 04 B8 02 00 00 00 48 6B C0 00 33 C9 48 8B 54 24 18 66 89 0C 02 0F B7 44 24 04 85 C0 74 0A C7 44 24 10 FF FF FF FF EB 08 C7 44 24 10 00 00 00 00 0F B7 44 24 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_121_0_1 {
	meta:
		name = "_Dint"
		size = 814
		refs = "01d2 ?mask@?3??_Dint@@9@9 01f3 ?sub@?3??_Dint@@9@9"
	strings:
		$1 = { 66 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 89 44 24 18 B8 02 00 00 00 48 6B C0 03 48 8B 4C 24 18 0F B7 04 01 25 F0 7F 00 00 C1 F8 04 66 89 04 24 0F BF 04 24 3D FF 07 00 00 75 79 B8 02 00 00 00 48 6B C0 03 48 8B 4C 24 18 0F B7 04 01 83 E0 0F 85 C0 75 4C B8 02 00 00 00 48 6B C0 02 48 8B 4C 24 18 0F B7 04 01 85 C0 75 36 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 18 0F B7 04 01 85 C0 75 20 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 18 0F B7 04 01 85 C0 75 0A C7 44 24 0C 01 00 00 00 EB 08 C7 44 24 0C 02 00 00 00 0F B7 44 24 0C E9 71 02 00 00 EB 63 B8 02 00 00 00 48 6B C0 03 48 8B 4C 24 18 0F B7 04 01 0F BA F0 0F 85 C0 75 49 B8 02 00 00 00 48 6B C0 02 48 8B 4C 24 18 0F B7 04 01 85 C0 75 33 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 18 0F B7 04 01 85 C0 75 1D B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 18 0F B7 04 01 85 C0 75 07 33 C0 E9 0C 02 00 00 0F BF 04 24 B9 33 04 00 00 2B C8 8B C1 0F BF 4C 24 38 2B C1 66 89 04 24 0F BF 04 24 85 C0 7F 0C 33 C0 E9 E5 01 00 00 E9 E0 01 00 00 0F BF 04 24 83 F8 35 7C 74 B8 02 00 00 00 48 6B C0 03 48 8B 4C 24 18 0F B7 04 01 25 00 80 00 00 B9 02 00 00 00 48 6B C9 03 48 8B 54 24 18 66 89 04 0A B8 02 00 00 00 48 6B C0 02 33 C9 48 8B 54 24 18 66 89 0C 02 B8 02 00 00 00 48 6B C0 01 33 C9 48 8B 54 24 18 66 89 0C 02 B8 02 00 00 00 48 6B C0 00 33 C9 48 8B 54 24 18 66 89 0C 02 B8 FF FF FF FF E9 68 01 00 00 E9 63 01 00 00 0F BF 04 24 83 E0 0F 48 98 48 8D 0D ?? ?? ?? ?? 0F B7 04 41 66 89 44 24 04 0F B7 04 24 66 C1 F8 04 66 89 04 24 48 0F BF 04 24 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 8B 4C 24 18 0F B7 04 41 0F B7 4C 24 04 23 C8 8B C1 66 89 44 24 04 48 0F BF 04 24 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 0F B7 4C 24 04 48 8B 54 24 18 0F B7 04 42 33 C1 48 0F BF 0C 24 48 8D 15 ?? ?? ?? ?? 48 8B 0C CA 48 8B 54 24 18 66 89 04 4A 0F BF 04 24 89 44 24 08 83 7C 24 08 01 74 7B 83 7C 24 08 02 74 40 83 7C 24 08 03 74 05 E9 9C 00 00 00 B8 02 00 00 00 48 6B C0 02 48 8B 4C 24 18 0F B7 04 01 0F B7 4C 24 04 0B C8 8B C1 66 89 44 24 04 B8 02 00 00 00 48 6B C0 02 33 C9 48 8B 54 24 18 66 89 0C 02 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 18 0F B7 04 01 0F B7 4C 24 04 0B C8 8B C1 66 89 44 24 04 B8 02 00 00 00 48 6B C0 01 33 C9 48 8B 54 24 18 66 89 0C 02 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 18 0F B7 04 01 0F B7 4C 24 04 0B C8 8B C1 66 89 44 24 04 B8 02 00 00 00 48 6B C0 00 33 C9 48 8B 54 24 18 66 89 0C 02 0F B7 44 24 04 85 C0 74 0A C7 44 24 10 FF FF FF FF EB 08 C7 44 24 10 00 00 00 00 0F B7 44 24 10 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_1_0 {
	meta:
		name = "_dtest"
		size = 323
		altNames = "_Dtest"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 89 44 24 08 B8 02 00 00 00 48 6B C0 03 48 8B 4C 24 08 0F B7 04 01 25 F0 7F 00 00 3D F0 7F 00 00 75 79 B8 02 00 00 00 48 6B C0 03 48 8B 4C 24 08 0F B7 04 01 83 E0 0F 85 C0 75 4B B8 02 00 00 00 48 6B C0 02 48 8B 4C 24 08 0F B7 04 01 85 C0 75 35 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 08 0F B7 04 01 85 C0 75 1F B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 08 0F B7 04 01 85 C0 75 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 02 00 00 00 0F B7 04 24 E9 99 00 00 00 E9 94 00 00 00 B8 02 00 00 00 48 6B C0 03 48 8B 4C 24 08 0F B7 04 01 0F BA F0 0F 85 C0 75 42 B8 02 00 00 00 48 6B C0 02 48 8B 4C 24 08 0F B7 04 01 85 C0 75 2C B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 08 0F B7 04 01 85 C0 75 16 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 08 0F B7 04 01 85 C0 74 36 B8 02 00 00 00 48 6B C0 03 48 8B 4C 24 08 0F B7 04 01 25 F0 7F 00 00 85 C0 75 0A C7 44 24 04 FE FF FF FF EB 08 C7 44 24 04 FF FF FF FF 0F B7 44 24 04 EB 04 EB 02 33 C0 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_76_2_0 {
	meta:
		name = "_fd_int"
		size = 556
		refs = "0152 ?mask@?3??_fd_int@@9@9 0173 ?sub@?3??_fd_int@@9@9"
	strings:
		$1 = { 66 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 89 44 24 10 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 10 0F B7 04 01 25 80 7F 00 00 C1 F8 07 66 89 04 24 0F BF 04 24 3D FF 00 00 00 75 4D B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 10 0F B7 04 01 83 E0 7F 85 C0 75 20 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 10 0F B7 04 01 85 C0 75 0A C7 44 24 08 01 00 00 00 EB 08 C7 44 24 08 02 00 00 00 0F B7 44 24 08 E9 9B 01 00 00 EB 37 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 10 0F B7 04 01 0F BA F0 0F 85 C0 75 1D B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 10 0F B7 04 01 85 C0 75 07 33 C0 E9 62 01 00 00 0F BF 04 24 B9 96 00 00 00 2B C8 8B C1 0F BF 4C 24 38 2B C1 66 89 04 24 0F BF 04 24 85 C0 7F 0C 33 C0 E9 3B 01 00 00 E9 36 01 00 00 0F BF 04 24 83 F8 18 7C 4C B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 10 0F B7 04 01 25 00 80 00 00 B9 02 00 00 00 48 6B C9 01 48 8B 54 24 10 66 89 04 0A B8 02 00 00 00 48 6B C0 00 33 C9 48 8B 54 24 10 66 89 0C 02 B8 FF FF FF FF E9 E6 00 00 00 E9 E1 00 00 00 0F BF 04 24 83 E0 0F 48 98 48 8D 0D ?? ?? ?? ?? 0F B7 04 41 66 89 44 24 04 0F B7 04 24 66 C1 F8 04 66 89 04 24 48 0F BF 04 24 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 8B 4C 24 10 0F B7 04 41 0F B7 4C 24 04 23 C8 8B C1 66 89 44 24 04 48 0F BF 04 24 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 0F B7 4C 24 04 48 8B 54 24 10 0F B7 04 42 33 C1 48 0F BF 0C 24 48 8D 15 ?? ?? ?? ?? 48 8B 0C CA 48 8B 54 24 10 66 89 04 4A 0F BF 04 24 85 C0 7E 34 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 10 0F B7 04 01 0F B7 4C 24 04 0B C8 8B C1 66 89 44 24 04 B8 02 00 00 00 48 6B C0 00 33 C9 48 8B 54 24 10 66 89 0C 02 0F B7 44 24 04 85 C0 74 0A C7 44 24 0C FF FF FF FF EB 08 C7 44 24 0C 00 00 00 00 0F B7 44 24 0C 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_0_1 {
	meta:
		name = "_FDint"
		size = 556
		refs = "0152 ?mask@?3??_FDint@@9@9 0173 ?sub@?3??_FDint@@9@9"
	strings:
		$1 = { 66 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 89 44 24 10 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 10 0F B7 04 01 25 80 7F 00 00 C1 F8 07 66 89 04 24 0F BF 04 24 3D FF 00 00 00 75 4D B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 10 0F B7 04 01 83 E0 7F 85 C0 75 20 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 10 0F B7 04 01 85 C0 75 0A C7 44 24 08 01 00 00 00 EB 08 C7 44 24 08 02 00 00 00 0F B7 44 24 08 E9 9B 01 00 00 EB 37 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 10 0F B7 04 01 0F BA F0 0F 85 C0 75 1D B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 10 0F B7 04 01 85 C0 75 07 33 C0 E9 62 01 00 00 0F BF 04 24 B9 96 00 00 00 2B C8 8B C1 0F BF 4C 24 38 2B C1 66 89 04 24 0F BF 04 24 85 C0 7F 0C 33 C0 E9 3B 01 00 00 E9 36 01 00 00 0F BF 04 24 83 F8 18 7C 4C B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 10 0F B7 04 01 25 00 80 00 00 B9 02 00 00 00 48 6B C9 01 48 8B 54 24 10 66 89 04 0A B8 02 00 00 00 48 6B C0 00 33 C9 48 8B 54 24 10 66 89 0C 02 B8 FF FF FF FF E9 E6 00 00 00 E9 E1 00 00 00 0F BF 04 24 83 E0 0F 48 98 48 8D 0D ?? ?? ?? ?? 0F B7 04 41 66 89 44 24 04 0F B7 04 24 66 C1 F8 04 66 89 04 24 48 0F BF 04 24 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 48 8B 4C 24 10 0F B7 04 41 0F B7 4C 24 04 23 C8 8B C1 66 89 44 24 04 48 0F BF 04 24 48 8D 0D ?? ?? ?? ?? 48 8B 04 C1 0F B7 4C 24 04 48 8B 54 24 10 0F B7 04 42 33 C1 48 0F BF 0C 24 48 8D 15 ?? ?? ?? ?? 48 8B 0C CA 48 8B 54 24 10 66 89 04 4A 0F BF 04 24 85 C0 7E 34 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 10 0F B7 04 01 0F B7 4C 24 04 0B C8 8B C1 66 89 44 24 04 B8 02 00 00 00 48 6B C0 00 33 C9 48 8B 54 24 10 66 89 0C 02 0F B7 44 24 04 85 C0 74 0A C7 44 24 0C FF FF FF FF EB 08 C7 44 24 0C 00 00 00 00 0F B7 44 24 0C 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_76_3_0 {
	meta:
		name = "_fdtest"
		size = 229
		altNames = "_FDtest"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 48 89 44 24 08 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 08 0F B7 04 01 25 80 7F 00 00 3D 80 7F 00 00 75 47 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 08 0F B7 04 01 83 E0 7F 85 C0 75 1F B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 08 0F B7 04 01 85 C0 75 09 C7 04 24 01 00 00 00 EB 07 C7 04 24 02 00 00 00 0F B7 04 24 EB 6A EB 68 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 08 0F B7 04 01 0F BA F0 0F 85 C0 75 16 B8 02 00 00 00 48 6B C0 00 48 8B 4C 24 08 0F B7 04 01 85 C0 74 36 B8 02 00 00 00 48 6B C0 01 48 8B 4C 24 08 0F B7 04 01 25 80 7F 00 00 85 C0 75 0A C7 44 24 04 FE FF FF FF EB 08 C7 44 24 04 FF FF FF FF 0F B7 44 24 04 EB 04 EB 02 33 C0 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_76_4_0 {
	meta:
		name = "_fperrraise"
		size = 248
		refs = "00b6 fesetexceptflag 00d1 _errno"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 38 C7 44 24 24 03 00 00 00 8B 44 24 24 83 E0 02 85 C0 0F 84 9B 00 00 00 C7 44 24 20 00 00 00 00 8B 44 24 40 83 E0 18 85 C0 74 0B 8B 44 24 40 83 C8 20 89 44 24 40 8B 44 24 40 83 E0 20 85 C0 74 0B 8B 44 24 20 83 C8 01 89 44 24 20 8B 44 24 40 83 E0 10 85 C0 74 0B 8B 44 24 20 83 C8 02 89 44 24 20 8B 44 24 40 83 E0 08 85 C0 74 0B 8B 44 24 20 83 C8 04 89 44 24 20 8B 44 24 40 83 E0 04 85 C0 74 0B 8B 44 24 20 83 C8 08 89 44 24 20 8B 44 24 40 83 E0 01 85 C0 74 0B 8B 44 24 20 83 C8 10 89 44 24 20 BA 1F 00 00 00 48 8D 4C 24 20 E8 ?? ?? ?? ?? 8B 44 24 24 83 E0 01 85 C0 74 2E 8B 44 24 40 83 E0 01 85 C0 74 0D E8 ?? ?? ?? ?? C7 00 21 00 00 00 EB 16 8B 44 24 40 83 E0 1C 85 C0 74 0B E8 ?? ?? ?? ?? C7 00 22 00 00 00 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_76_5_0 {
	meta:
		name = "_ld_int"
		size = 34
		refs = "0019 _d_int"
	strings:
		$1 = { 66 89 54 24 10 48 89 4C 24 08 48 83 EC 28 0F B7 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_9_0_1 {
	meta:
		name = "_LDint"
		size = 34
		refs = "0019 _Dint"
	strings:
		$1 = { 66 89 54 24 10 48 89 4C 24 08 48 83 EC 28 0F B7 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_77_1_0 {
	meta:
		name = "_wspawnve"
		size = 1853
		refs = "005e ??_C@_1BK@EILABNJE@?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 006a ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 007f ??_C@_1FA@OEKDEAAE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAe?$AAx?$AAe?$AAc?$AA?2?$AAs?$AAp@ 0089 _CrtDbgReportW 009d _errno 00c0 ??_C@_1BE@NOIMNAAA@?$AA_?$AAw?$AAs?$AAp?$AAa?$AAw?$AAn?$AAv?$AAe?$AA?$AA@ 00cc _invalid_parameter 010f ??_C@_1CE@CONABGGG@?$AA?$CK?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 01bc ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 026c ??_C@_1BM@CNLEOMNN@?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0320 ??_C@_1CG@JGBGIIEL@?$AA?$CK?$AA?$CK?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 03a8 wcsrchr 03e6 wcschr 0401 wcslen 041c ??_C@_0CI@HEEEAHPK@f?3?2dd?2vctools?2crt?2crtw32?2exec?2sp@ 0434 _calloc_dbg 0454 ??_C@_15PCEAIKAA@?$AA?4?$AA?2?$AA?$AA@ 0466 wcscpy_s 048c ??_C@_1FE@EDEBHNHE@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA_?$AAs?$AAi?$AAz?$AAe@ 0493 _invoke_watson_if_error 04ad wcscat_s 04d3 ??_C@_1FA@KFCDCBOG@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?0?$AA?5?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA_?$AAs?$AAi?$AAz?$AAe@ 053b _waccess_s 0560 wcomexecmd 0600 ??_C@_1DI@MLPIPGLK@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AAp?$AAa?$AAt?$AAh?$AAn?$AAa?$AAm?$AAe?$AA?$CJ?$AA?$AA@ 0655 ext_strings 06aa ??_C@_1GA@NDGMJEBK@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAe?$AAx?$AAt?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAe?$AAx?$AAt?$AA?5?$AA?9?$AA?5?$AAp?$AA?$CJ?$AA?0?$AA?5@ 070b _free_dbg"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 81 EC A8 00 00 00 48 8B 84 24 B8 00 00 00 48 89 44 24 38 C7 44 24 48 00 00 00 00 48 83 BC 24 B8 00 00 00 00 74 0A C7 44 24 6C 01 00 00 00 EB 08 C7 44 24 6C 00 00 00 00 8B 44 24 6C 89 44 24 50 83 7C 24 50 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 DC 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 50 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 DC 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 59 06 00 00 48 8B 84 24 B8 00 00 00 0F B7 00 85 C0 74 0A C7 44 24 58 01 00 00 00 EB 08 C7 44 24 58 00 00 00 00 8B 44 24 58 89 44 24 4C 83 7C 24 4C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 DD 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 4C 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 DD 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 A8 05 00 00 48 83 BC 24 C0 00 00 00 00 74 0A C7 44 24 60 01 00 00 00 EB 08 C7 44 24 60 00 00 00 00 8B 44 24 60 89 44 24 54 83 7C 24 54 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 DE 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 54 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 DE 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 FB 04 00 00 48 8B 84 24 C0 00 00 00 48 83 38 00 74 0A C7 44 24 64 01 00 00 00 EB 08 C7 44 24 64 00 00 00 00 8B 44 24 64 89 44 24 5C 83 7C 24 5C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 DF 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 5C 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 DF 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 4B 04 00 00 48 8B 84 24 C0 00 00 00 48 8B 00 0F B7 00 85 C0 74 0A C7 44 24 44 01 00 00 00 EB 08 C7 44 24 44 00 00 00 00 8B 44 24 44 89 44 24 68 83 7C 24 68 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 E0 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 68 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 E0 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 97 03 00 00 66 BA 5C 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 89 44 24 30 66 BA 2F 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 89 44 24 78 48 83 7C 24 78 00 0F 85 1E 01 00 00 48 83 7C 24 30 00 0F 85 10 01 00 00 66 BA 3A 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 0F 85 F1 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C0 03 48 89 84 24 88 00 00 00 C7 44 24 20 F3 00 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 02 00 00 00 48 8B 8C 24 88 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 75 0C 48 C7 C0 FF FF FF FF E9 E4 02 00 00 4C 8D 05 ?? ?? ?? ?? 48 8B 94 24 88 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 F6 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 4C 8B 84 24 B8 00 00 00 48 8B 94 24 88 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 F7 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 38 48 83 C0 04 48 89 44 24 30 EB 1E 48 83 7C 24 30 00 74 0C 48 8B 44 24 30 48 39 44 24 78 76 0A 48 8B 44 24 78 48 89 44 24 30 48 C7 84 24 90 00 00 00 FF FF FF FF 66 BA 2E 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 89 44 24 70 48 83 7C 24 70 00 74 3E 33 D2 48 8B 4C 24 38 E8 ?? ?? ?? ?? 85 C0 75 29 4C 8B 8C 24 C8 00 00 00 4C 8B 84 24 C0 00 00 00 48 8B 54 24 38 8B 8C 24 B0 00 00 00 E8 ?? ?? ?? ?? 48 89 84 24 90 00 00 00 E9 9E 01 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 83 C0 05 48 89 84 24 80 00 00 00 C7 44 24 20 25 01 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 02 00 00 00 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 75 0C 48 C7 C0 FF FF FF FF E9 6E 01 00 00 4C 8B 44 24 38 48 8B 94 24 80 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 28 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 4C 24 30 48 8D 04 41 48 89 44 24 70 E8 ?? ?? ?? ?? 8B 00 89 44 24 48 C7 44 24 40 03 00 00 00 EB 0A 8B 44 24 40 FF C8 89 44 24 40 83 7C 24 40 00 0F 8C B3 00 00 00 48 63 44 24 40 48 8D 0D ?? ?? ?? ?? 48 8B 54 24 30 4C 8B 44 24 70 4C 2B C2 49 8B D0 48 D1 FA 4C 8B 84 24 80 00 00 00 4C 2B C2 49 8B D0 4C 8B 04 C1 48 8B 4C 24 70 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 2D 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 85 C0 75 36 E8 ?? ?? ?? ?? 8B 4C 24 48 89 08 4C 8B 8C 24 C8 00 00 00 4C 8B 84 24 C0 00 00 00 48 8B 54 24 30 8B 8C 24 B0 00 00 00 E8 ?? ?? ?? ?? 48 89 84 24 90 00 00 00 EB 05 E9 38 FF FF FF BA 02 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 84 24 B8 00 00 00 48 39 44 24 38 74 0F BA 02 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 81 C4 A8 00 00 00 C3 }
	condition:
		$1
}

rule file_77_2_0 {
	meta:
		name = "wcomexecmd"
		size = 487
		refs = "0043 ??_C@_1BK@EILABNJE@?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0064 ??_C@_1FA@OEKDEAAE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAe?$AAx?$AAe?$AAc?$AA?2?$AAs?$AAp@ 006e _CrtDbgReportW 0082 _errno 00a5 ??_C@_1BG@DLIHJHNJ@?$AAw?$AAc?$AAo?$AAm?$AAe?$AAx?$AAe?$AAc?$AAm?$AAd?$AA?$AA@ 00b1 _invalid_parameter 00f0 ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0190 _wcenvarg 01b6 _wdospawn 01ca _free_dbg"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 68 48 83 7C 24 78 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 70 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 70 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 21 01 00 00 48 83 BC 24 80 00 00 00 00 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 71 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 71 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF EB 77 48 8B 44 24 78 48 89 44 24 20 4C 8D 4C 24 48 4C 8D 44 24 40 48 8B 94 24 88 00 00 00 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 75 09 48 C7 C0 FF FF FF FF EB 40 4C 8B 4C 24 48 4C 8B 44 24 40 48 8B 54 24 78 8B 4C 24 70 E8 ?? ?? ?? ?? 48 89 44 24 50 BA 02 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_604_2_0 {
	meta:
		name = "comexecmd"
		size = 487
		refs = "0043 ??_C@_1BK@EILABNJE@?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0064 ??_C@_1FA@OEKDEAAE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAe?$AAx?$AAe?$AAc?$AA?2?$AAs?$AAp@ 006e _CrtDbgReportW 0082 _errno 00a5 ??_C@_1BE@BCIEHILB@?$AAc?$AAo?$AAm?$AAe?$AAx?$AAe?$AAc?$AAm?$AAd?$AA?$AA@ 00b1 _invalid_parameter 00f0 ??_C@_1BK@DKFDJEHE@?$AAa?$AAr?$AAg?$AAv?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0190 _cenvarg 01b6 _dospawn 01ca _free_dbg"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 48 83 EC 68 48 83 7C 24 78 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 70 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 70 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 21 01 00 00 48 83 BC 24 80 00 00 00 00 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 71 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 71 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF EB 77 48 8B 44 24 78 48 89 44 24 20 4C 8D 4C 24 48 4C 8D 44 24 40 48 8B 94 24 88 00 00 00 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 83 F8 FF 75 09 48 C7 C0 FF FF FF FF EB 40 4C 8B 4C 24 48 4C 8B 44 24 40 48 8B 54 24 78 8B 4C 24 70 E8 ?? ?? ?? ?? 48 89 44 24 50 BA 02 00 00 00 48 8B 4C 24 40 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "_vacopy"
		size = 24
		altNames = "??$_StoreWithRelease@PEAU_Page@_Concurrent_queue_base_v4@details@Concurrency@@@?$_Subatomic_impl@$07@details@Concurrency@@SAXAECREAU_Page@_Concurrent_queue_base_v4@12@PEAU3412@@Z ??$_StoreWithRelease@PEAU_Segment_t@_Concurrent_vector_base_v4@details@Concurrency@@@?$_Subatomic_impl@$07@details@Concurrency@@SAXAECREAU_Segment_t@_Concurrent_vector_base_v4@12@PEAU3412@@Z ??$_StoreWithRelease@PEAX@?$_Subatomic_impl@$07@details@Concurrency@@SAXAECREAXPEAX@Z ??$_StoreWithRelease@_K@?$_Subatomic_impl@$07@details@Concurrency@@SAXAEC_K_K@Z"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 8B 44 24 08 48 8B 4C 24 10 48 89 08 C3 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "_swscanf_l"
		size = 76
		refs = "003e _winput_l 0043 vscan_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 68 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 4C 8B 4C 24 60 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_925_0_0 {
	meta:
		name = "_fscanf_l"
		size = 76
		refs = "003e _input_l 0043 vfscanf_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 68 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 4C 8B 4C 24 60 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_925_1_0 {
	meta:
		name = "_fscanf_s_l"
		size = 76
		refs = "003e _input_s_l 0043 vfscanf_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 68 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 4C 8B 4C 24 60 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_565_0_0 {
	meta:
		name = "_fwscanf_l"
		size = 76
		refs = "003e _winput_l 0043 vfwscanf_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 68 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 4C 8B 4C 24 60 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_565_1_0 {
	meta:
		name = "_fwscanf_s_l"
		size = 76
		refs = "003e _winput_s_l 0043 vfwscanf_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 68 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 4C 8B 4C 24 60 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_494_0_0 {
	meta:
		name = "_sscanf_l"
		size = 76
		refs = "003e _input_l 0043 vscan_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 68 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 4C 8B 4C 24 60 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_494_1_0 {
	meta:
		name = "_sscanf_s_l"
		size = 76
		refs = "003e _input_s_l 0043 vscan_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 68 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 4C 8B 4C 24 60 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_80_1_0 {
	meta:
		name = "_swscanf_s_l"
		size = 76
		refs = "003e _winput_s_l 0043 vscan_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 68 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 4C 8B 4C 24 60 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_80_2_0 {
	meta:
		name = "swscanf"
		size = 74
		refs = "003c _winput_l 0041 vscan_fn"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 60 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 45 33 C9 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_925_2_0 {
	meta:
		name = "fscanf"
		size = 74
		refs = "003c _input_l 0041 vfscanf_fn"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 60 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 45 33 C9 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_925_3_0 {
	meta:
		name = "fscanf_s"
		size = 74
		refs = "003c _input_s_l 0041 vfscanf_fn"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 60 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 45 33 C9 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_565_2_0 {
	meta:
		name = "fwscanf"
		size = 74
		refs = "003c _winput_l 0041 vfwscanf_fn"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 60 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 45 33 C9 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_565_3_0 {
	meta:
		name = "fwscanf_s"
		size = 74
		refs = "003c _winput_s_l 0041 vfwscanf_fn"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 60 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 45 33 C9 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_494_2_0 {
	meta:
		name = "sscanf"
		size = 74
		refs = "003c _input_l 0041 vscan_fn"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 60 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 45 33 C9 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_494_3_0 {
	meta:
		name = "sscanf_s"
		size = 74
		refs = "003c _input_s_l 0041 vscan_fn"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 60 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 45 33 C9 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_80_3_0 {
	meta:
		name = "swscanf_s"
		size = 74
		refs = "003c _winput_s_l 0041 vscan_fn"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 4C 89 44 24 18 4C 89 4C 24 20 48 83 EC 48 48 8D 44 24 60 48 89 44 24 30 48 8B 44 24 30 48 89 44 24 20 45 33 C9 4C 8B 44 24 58 48 8B 54 24 50 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_80_4_0 {
	meta:
		name = "vscan_fn"
		size = 563
		refs = "006f ??_C@_1CC@OLIJCKA@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 007b ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0090 ??_C@_1FA@LIFAAFAC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAi?$AAo?$AA?2?$AAs@ 009a _CrtDbgReportW 00ae _errno 00d1 ??_C@_1BC@KMGJCMNP@?$AAv?$AAs?$AAc?$AAa?$AAn?$AA_?$AAf?$AAn?$AA?$AA@ 00dd _invalid_parameter 011a ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 019f wcslen"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 57 48 81 EC 90 00 00 00 48 C7 44 24 58 00 00 00 00 48 8D 44 24 60 48 8B F8 33 C0 B9 28 00 00 00 F3 AA 48 8D 44 24 58 48 89 44 24 30 48 83 BC 24 A8 00 00 00 00 74 0A C7 44 24 3C 01 00 00 00 EB 08 C7 44 24 3C 00 00 00 00 8B 44 24 3C 89 44 24 40 83 7C 24 40 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 32 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 40 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 32 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 3F 01 00 00 48 83 BC 24 B0 00 00 00 00 74 0A C7 44 24 44 01 00 00 00 EB 08 C7 44 24 44 00 00 00 00 8B 44 24 44 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 33 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 33 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 94 00 00 00 48 8B 8C 24 A8 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 50 48 8B 44 24 30 C7 40 18 49 00 00 00 48 8B 44 24 30 48 8B 8C 24 A8 00 00 00 48 89 48 10 48 8B 44 24 30 48 8B 8C 24 A8 00 00 00 48 89 08 48 81 7C 24 50 FF FF FF 3F 76 0E 48 8B 44 24 30 C7 40 08 FF FF FF 7F EB 10 48 63 44 24 50 48 D1 E0 48 8B 4C 24 30 89 41 08 4C 8B 8C 24 C0 00 00 00 4C 8B 84 24 B8 00 00 00 48 8B 94 24 B0 00 00 00 48 8B 4C 24 30 FF 94 24 A0 00 00 00 89 44 24 48 8B 44 24 48 48 81 C4 90 00 00 00 5F C3 }
	condition:
		$1
}

rule file_80_5_0 {
	meta:
		name = "vswscanf"
		size = 59
		refs = "002d _winput_l 0032 vscan_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 48 89 44 24 20 45 33 C9 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_806_1_0 {
	meta:
		name = "_vfprintf_p"
		size = 59
		refs = "002d _output_p_l 0032 vfprintf_helper"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 48 89 44 24 20 45 33 C9 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_279_1_0 {
	meta:
		name = "_vfwprintf_p"
		size = 59
		refs = "002d _woutput_p_l 0032 vfwprintf_helper"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 48 89 44 24 20 45 33 C9 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_806_4_0 {
	meta:
		name = "vfprintf"
		size = 59
		refs = "002d _output_l 0032 vfprintf_helper"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 48 89 44 24 20 45 33 C9 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_806_7_0 {
	meta:
		name = "vfprintf_s"
		size = 59
		refs = "002d _output_s_l 0032 vfprintf_helper"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 48 89 44 24 20 45 33 C9 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_925_4_0 {
	meta:
		name = "vfscanf"
		size = 59
		refs = "002d _input_l 0032 vfscanf_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 48 89 44 24 20 45 33 C9 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_925_7_0 {
	meta:
		name = "vfscanf_s"
		size = 59
		refs = "002d _input_s_l 0032 vfscanf_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 48 89 44 24 20 45 33 C9 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_279_4_0 {
	meta:
		name = "vfwprintf"
		size = 59
		refs = "002d _woutput_l 0032 vfwprintf_helper"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 48 89 44 24 20 45 33 C9 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_279_7_0 {
	meta:
		name = "vfwprintf_s"
		size = 59
		refs = "002d _woutput_s_l 0032 vfwprintf_helper"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 48 89 44 24 20 45 33 C9 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_565_4_0 {
	meta:
		name = "vfwscanf"
		size = 59
		refs = "002d _winput_l 0032 vfwscanf_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 48 89 44 24 20 45 33 C9 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_565_7_0 {
	meta:
		name = "vfwscanf_s"
		size = 59
		refs = "002d _winput_s_l 0032 vfwscanf_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 48 89 44 24 20 45 33 C9 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_494_5_0 {
	meta:
		name = "vsscanf"
		size = 59
		refs = "002d _input_l 0032 vscan_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 48 89 44 24 20 45 33 C9 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_494_6_0 {
	meta:
		name = "vsscanf_s"
		size = 59
		refs = "002d _input_s_l 0032 vscan_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 48 89 44 24 20 45 33 C9 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_80_6_0 {
	meta:
		name = "vswscanf_s"
		size = 59
		refs = "002d _winput_s_l 0032 vscan_fn"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 50 48 89 44 24 20 45 33 C9 4C 8B 44 24 48 48 8B 54 24 40 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_81_1_0 {
	meta:
		name = "scaleFloat_2"
		size = 115
	strings:
		$1 = { 89 54 24 10 F3 0F 11 44 24 08 48 83 EC 28 8B 44 24 38 99 2B C2 D1 F8 89 04 24 8B 04 24 8B 4C 24 38 2B C8 8B C1 89 44 24 08 8B 04 24 83 C0 7F C1 E0 17 89 44 24 04 F3 0F 10 44 24 04 F3 0F 11 44 24 10 8B 44 24 08 83 C0 7F C1 E0 17 89 44 24 0C F3 0F 10 44 24 0C F3 0F 11 44 24 14 F3 0F 10 44 24 30 F3 0F 59 44 24 10 F3 0F 59 44 24 14 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_81_2_0 {
	meta:
		name = "splitexpf"
		size = 428
		refs = "0035 __real@00000000 0044 __real@3f000000 00af ?two_to_jby32_lead_table@?1??splitexpf@@9@9 00c6 ?two_to_jby32_trail_table@?1??splitexpf@@9@9 0139 __real@3e2aaaab"
	strings:
		$1 = { F3 0F 11 5C 24 20 F3 0F 11 54 24 18 F3 0F 11 4C 24 10 F3 0F 11 44 24 08 48 83 EC 28 F3 0F 10 44 24 30 F3 0F 59 44 24 40 F3 0F 11 04 24 F3 0F 10 04 24 0F 2F 05 ?? ?? ?? ?? 76 17 F3 0F 10 04 24 F3 0F 58 05 ?? ?? ?? ?? F3 0F 2C C0 89 44 24 04 EB 15 F3 0F 10 04 24 F3 0F 5C 05 ?? ?? ?? ?? F3 0F 2C C0 89 44 24 04 F3 0F 2A 44 24 04 F3 0F 59 44 24 48 F3 0F 10 4C 24 30 F3 0F 5C C8 0F 28 C1 F3 0F 11 44 24 0C 8B 44 24 04 F7 D8 F3 0F 2A C0 F3 0F 59 44 24 50 F3 0F 11 44 24 08 8B 44 24 04 83 E0 1F 89 44 24 10 48 63 44 24 10 48 8D 0D ?? ?? ?? ?? F3 0F 10 04 81 F3 0F 11 44 24 14 48 63 44 24 10 48 8D 0D ?? ?? ?? ?? F3 0F 10 04 81 F3 0F 11 44 24 18 8B 44 24 10 8B 4C 24 04 2B C8 8B C1 99 83 E2 1F 03 C2 C1 F8 05 48 8B 4C 24 58 89 01 F3 0F 10 44 24 0C F3 0F 59 44 24 38 F3 0F 11 44 24 0C F3 0F 10 44 24 08 F3 0F 59 44 24 38 F3 0F 11 44 24 08 F3 0F 10 44 24 0C F3 0F 58 44 24 08 F3 0F 11 04 24 F3 0F 10 04 24 F3 0F 59 04 24 F3 0F 10 0C 24 F3 0F 59 0D ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? F3 0F 58 D1 0F 28 CA F3 0F 59 C1 F3 0F 10 4C 24 08 F3 0F 58 C8 0F 28 C1 F3 0F 10 4C 24 0C F3 0F 58 C8 0F 28 C1 F3 0F 11 44 24 1C 48 8B 44 24 60 F3 0F 10 44 24 14 F3 0F 11 00 F3 0F 10 44 24 14 F3 0F 58 44 24 18 F3 0F 59 44 24 1C F3 0F 10 4C 24 18 F3 0F 58 C8 0F 28 C1 48 8B 44 24 68 F3 0F 11 00 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_81_3_0 {
	meta:
		name = "tanhf"
		size = 841
		refs = "0060 valf_with_flags 00e0 ??_C@_05NEEGJJPP@tanhf?$AA@ 00e5 _handle_errorf 0114 __real@40000000 0123 __real@3f800000 0152 ?large_threshold@?1??tanhf@@9@9 0194 __real@3f666666 01af __real@384d2b7d 01bd __real@babfbc9e 01d2 __real@be9058e0 01e5 __real@3eaf769c 01f3 __real@3f588550 0227 __real@382089d8 0235 __real@baa18e00 024a __real@be7679b1 025d __real@3e95c65f 026b __real@3f38db60 02c2 ?log2_by_32_tail@?1??tanhf@@9@9 02d0 ?log2_by_32_lead@?1??tanhf@@9@9 02d8 ?thirtytwo_by_log2@?1??tanhf@@9@9 02e5 splitexpf 02fa scaleFloat_2"
	strings:
		$1 = { F3 0F 11 44 24 08 48 81 EC 98 00 00 00 F3 0F 10 84 24 A0 00 00 00 F3 0F 11 44 24 78 8B 44 24 78 89 44 24 68 8B 44 24 68 0F BA F0 1F 89 44 24 58 81 7C 24 58 00 00 00 39 73 34 83 7C 24 58 00 75 10 F3 0F 10 84 24 A0 00 00 00 E9 F2 02 00 00 EB 18 BA 10 00 00 00 F3 0F 10 84 24 A0 00 00 00 E8 ?? ?? ?? ?? E9 D8 02 00 00 E9 80 00 00 00 81 7C 24 58 00 00 80 7F 76 76 F3 0F 10 84 24 A0 00 00 00 F3 0F 11 84 24 80 00 00 00 8B 84 24 80 00 00 00 89 44 24 6C 8B 44 24 6C 0F BA E8 16 8B C0 C7 44 24 40 01 00 00 00 0F 57 C0 F3 0F 11 44 24 38 F3 0F 10 84 24 A0 00 00 00 F3 0F 11 44 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 00 00 00 00 41 B9 01 00 00 00 44 8B C0 BA 21 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 53 02 00 00 8B 44 24 68 39 44 24 58 74 0A C7 44 24 64 01 00 00 00 EB 08 C7 44 24 64 00 00 00 00 F3 0F 2A 44 24 64 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 0F 28 C1 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5C C8 0F 28 C1 F3 0F 11 44 24 60 F3 0F 10 44 24 60 F3 0F 59 84 24 A0 00 00 00 F3 0F 11 44 24 50 F3 0F 10 44 24 50 0F 2F 05 ?? ?? ?? ?? 76 13 F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 44 24 5C E9 CA 01 00 00 F3 0F 10 05 ?? ?? ?? ?? 0F 2F 44 24 50 0F 82 14 01 00 00 F3 0F 10 44 24 50 F3 0F 59 44 24 50 F3 0F 11 44 24 54 F3 0F 10 05 ?? ?? ?? ?? 0F 2F 44 24 50 76 78 F3 0F 10 44 24 50 F3 0F 59 44 24 54 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 4C 24 54 F3 0F 10 15 ?? ?? ?? ?? F3 0F 58 D1 0F 28 CA F3 0F 59 4C 24 54 F3 0F 10 15 ?? ?? ?? ?? F3 0F 58 D1 0F 28 CA F3 0F 59 C1 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 4C 24 54 F3 0F 10 15 ?? ?? ?? ?? F3 0F 58 D1 0F 28 CA F3 0F 5E C1 F3 0F 10 4C 24 50 F3 0F 58 C8 0F 28 C1 F3 0F 11 44 24 5C EB 76 F3 0F 10 44 24 50 F3 0F 59 44 24 54 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 4C 24 54 F3 0F 10 15 ?? ?? ?? ?? F3 0F 58 D1 0F 28 CA F3 0F 59 4C 24 54 F3 0F 10 15 ?? ?? ?? ?? F3 0F 58 D1 0F 28 CA F3 0F 59 C1 F3 0F 10 0D ?? ?? ?? ?? F3 0F 59 4C 24 54 F3 0F 10 15 ?? ?? ?? ?? F3 0F 58 D1 0F 28 CA F3 0F 5E C1 F3 0F 10 4C 24 50 F3 0F 58 C8 0F 28 C1 F3 0F 11 44 24 5C E9 A3 00 00 00 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 44 24 50 48 8D 44 24 74 48 89 44 24 38 48 8D 44 24 70 48 89 44 24 30 48 8D 44 24 7C 48 89 44 24 28 F3 0F 10 0D ?? ?? ?? ?? F3 0F 11 4C 24 20 F3 0F 10 1D ?? ?? ?? ?? F3 0F 10 15 ?? ?? ?? ?? F3 0F 10 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? F3 0F 10 44 24 70 F3 0F 58 44 24 74 8B 54 24 7C E8 ?? ?? ?? ?? F3 0F 58 05 ?? ?? ?? ?? F3 0F 11 84 24 84 00 00 00 F3 0F 10 05 ?? ?? ?? ?? F3 0F 5E 84 24 84 00 00 00 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5C C8 0F 28 C1 F3 0F 11 44 24 5C F3 0F 10 44 24 60 F3 0F 59 44 24 5C 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "_fflush_nolock"
		size = 116
		refs = "0014 flsall 0020 _flush 0046 _fileno 004d _commit"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 83 7C 24 40 00 75 09 33 C9 E8 ?? ?? ?? ?? EB 55 48 8B 4C 24 40 E8 ?? ?? ?? ?? 85 C0 74 07 B8 FF FF FF FF EB 40 48 8B 44 24 40 8B 40 18 25 00 40 00 00 85 C0 74 2D 48 8B 4C 24 40 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 85 C0 74 0A C7 44 24 20 FF FF FF FF EB 08 C7 44 24 20 00 00 00 00 8B 44 24 20 EB 02 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_82_1_0 {
	meta:
		name = "_flush"
		size = 239
		refs = "0069 _fileno 007e _write"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 C7 44 24 24 00 00 00 00 48 8B 44 24 40 48 89 44 24 28 48 8B 44 24 28 8B 40 18 83 E0 03 83 F8 02 0F 85 9A 00 00 00 48 8B 44 24 28 8B 40 18 25 08 01 00 00 85 C0 0F 84 85 00 00 00 48 8B 44 24 28 48 8B 4C 24 28 48 8B 49 10 48 8B 00 48 2B C1 89 44 24 20 83 7C 24 20 00 7E 66 48 8B 4C 24 28 E8 ?? ?? ?? ?? 44 8B 44 24 20 48 8B 4C 24 28 48 8B 51 10 8B C8 E8 ?? ?? ?? ?? 3B 44 24 20 75 26 48 8B 44 24 28 8B 40 18 25 80 00 00 00 85 C0 74 13 48 8B 44 24 28 8B 40 18 83 E0 FD 48 8B 4C 24 28 89 41 18 EB 1B 48 8B 44 24 28 8B 40 18 83 C8 20 48 8B 4C 24 28 89 41 18 C7 44 24 24 FF FF FF FF 48 8B 44 24 28 48 8B 4C 24 28 48 8B 49 10 48 89 08 48 8B 44 24 28 C7 40 08 00 00 00 00 8B 44 24 24 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_82_2_0 {
	meta:
		name = "_flushall"
		size = 19
		refs = "000a flsall"
	strings:
		$1 = { 48 83 EC 28 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_82_3_0 {
	meta:
		name = "fflush"
		size = 78
		refs = "001c flsall 0028 _lock_file 0033 _fflush_nolock 0041 _unlock_file"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 48 83 7C 24 40 00 75 09 33 C9 E8 ?? ?? ?? ?? EB 27 48 8B 4C 24 40 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 20 48 8B 4C 24 40 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_82_4_0 {
	meta:
		name = "fflush$fin$0"
		size = 26
		refs = "000e _unlock_file"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 8B 4D 40 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_82_5_0 {
	meta:
		name = "flsall"
		size = 356
		refs = "001e _lock 0039 _nstream 004f __piob 0093 _lock_file2 00cc _fflush_nolock 0139 _unlock_file2 0148 _unlock"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 38 C7 44 24 24 00 00 00 00 C7 44 24 28 00 00 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 90 C7 44 24 20 00 00 00 00 EB 0A 8B 44 24 20 FF C0 89 44 24 20 8B 05 ?? ?? ?? ?? 39 44 24 20 0F 8D FB 00 00 00 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 83 3C C1 00 0F 84 DF 00 00 00 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 04 C1 8B 40 18 25 83 00 00 00 85 C0 0F 84 BF 00 00 00 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 14 C1 8B 4C 24 20 E8 ?? ?? ?? ?? 90 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 04 C1 8B 40 18 25 83 00 00 00 85 C0 74 70 83 7C 24 40 01 75 26 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 0C C1 E8 ?? ?? ?? ?? 83 F8 FF 74 0A 8B 44 24 24 FF C0 89 44 24 24 EB 43 83 7C 24 40 00 75 3C 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 04 C1 8B 40 18 83 E0 02 85 C0 74 22 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 0C C1 E8 ?? ?? ?? ?? 83 F8 FF 75 08 C7 44 24 28 FF FF FF FF 48 63 44 24 20 48 8B 0D ?? ?? ?? ?? 48 8B 14 C1 8B 4C 24 20 E8 ?? ?? ?? ?? E9 EB FE FF FF B9 01 00 00 00 E8 ?? ?? ?? ?? 83 7C 24 40 01 75 08 8B 44 24 24 EB 06 EB 04 8B 44 24 28 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_82_6_0 {
	meta:
		name = "flsall$fin$0"
		size = 40
		refs = "0010 __piob 001c _unlock_file2"
		altNames = "_rmtmp$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 48 63 45 20 48 8B 0D ?? ?? ?? ?? 48 8B 14 C1 8B 4D 20 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_82_7_0 {
	meta:
		name = "flsall$fin$1"
		size = 27
		refs = "000f _unlock"
		altNames = "_fcloseall$fin$0 _getstream$fin$0 _rmtmp$fin$1"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 01 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "_pow_special"
		size = 564
		refs = "0021 __security_cookie 0055 __ImageBase 005c $LN9 00bd ??_C@_03JGHBODFD@pow?$AA@ 00c2 _handle_error 0207 __security_check_cookie 0214 $LN4 0218 $LN3 0228 $LN2 0230 $LN1"
	strings:
		$1 = { 44 89 4C 24 20 F2 0F 11 54 24 18 F2 0F 11 4C 24 10 F2 0F 11 44 24 08 48 81 EC 88 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 78 8B 84 24 A8 00 00 00 89 44 24 50 8B 44 24 50 83 E8 02 89 44 24 50 83 7C 24 50 07 0F 87 A7 01 00 00 8B 44 24 50 48 8D 0D ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 F2 0F 10 84 24 A0 00 00 00 F2 0F 11 44 24 68 C7 44 24 40 02 00 00 00 F2 0F 10 84 24 98 00 00 00 F2 0F 11 44 24 38 F2 0F 10 84 24 90 00 00 00 F2 0F 11 44 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 04 00 00 00 41 B9 02 00 00 00 4C 8B 44 24 68 BA 1D 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 2A 01 00 00 F2 0F 10 84 24 A0 00 00 00 F2 0F 11 44 24 58 C7 44 24 40 02 00 00 00 F2 0F 10 84 24 98 00 00 00 F2 0F 11 44 24 38 F2 0F 10 84 24 90 00 00 00 F2 0F 11 44 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 08 00 00 00 41 B9 01 00 00 00 4C 8B 44 24 58 BA 1D 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 C4 00 00 00 F2 0F 10 84 24 A0 00 00 00 F2 0F 11 44 24 60 C7 44 24 40 02 00 00 00 F2 0F 10 84 24 98 00 00 00 F2 0F 11 44 24 38 F2 0F 10 84 24 90 00 00 00 F2 0F 11 44 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 12 00 00 00 41 B9 04 00 00 00 4C 8B 44 24 60 BA 1D 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 61 F2 0F 10 84 24 A0 00 00 00 F2 0F 11 44 24 70 C7 44 24 40 02 00 00 00 F2 0F 10 84 24 98 00 00 00 F2 0F 11 44 24 38 F2 0F 10 84 24 90 00 00 00 F2 0F 11 44 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 11 00 00 00 41 B9 03 00 00 00 4C 8B 44 24 70 BA 1D 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? F2 0F 10 84 24 A0 00 00 00 48 8B 4C 24 78 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 00 00 00 C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_1_0 {
	meta:
		name = "_powf_special"
		size = 764
		refs = "0021 __security_cookie 0057 __ImageBase 005e $LN10 00ce ??_C@_04MBFDLNIM@powf?$AA@ 00d3 _handle_errorf 02c9 __security_check_cookie 02d8 $LN5 02dc $LN4 02e0 $LN3 02f0 $LN2 02f4 $LN6 02f8 $LN1"
	strings:
		$1 = { 44 89 4C 24 20 F3 0F 11 54 24 18 F3 0F 11 4C 24 10 F3 0F 11 44 24 08 48 81 EC 98 00 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 80 00 00 00 8B 84 24 B8 00 00 00 89 44 24 50 8B 44 24 50 FF C8 89 44 24 50 83 7C 24 50 08 0F 87 64 02 00 00 8B 44 24 50 48 8D 0D ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 48 C7 44 24 70 00 00 00 00 B8 04 00 00 00 48 6B C0 00 F3 0F 10 84 24 B0 00 00 00 F3 0F 11 44 04 70 C7 44 24 40 02 00 00 00 F3 0F 10 84 24 A8 00 00 00 F3 0F 11 44 24 38 F3 0F 10 84 24 A0 00 00 00 F3 0F 11 44 24 30 C7 44 24 28 00 00 00 00 C7 44 24 20 08 00 00 00 45 33 C9 4C 8B 44 24 70 BA 1D 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 D8 01 00 00 48 C7 44 24 58 00 00 00 00 B8 04 00 00 00 48 6B C0 00 F3 0F 10 84 24 B0 00 00 00 F3 0F 11 44 04 58 C7 44 24 40 02 00 00 00 F3 0F 10 84 24 A8 00 00 00 F3 0F 11 44 24 38 F3 0F 10 84 24 A0 00 00 00 F3 0F 11 44 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 04 00 00 00 41 B9 02 00 00 00 4C 8B 44 24 58 BA 1D 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 60 01 00 00 48 C7 44 24 60 00 00 00 00 B8 04 00 00 00 48 6B C0 00 F3 0F 10 84 24 B0 00 00 00 F3 0F 11 44 04 60 C7 44 24 40 02 00 00 00 F3 0F 10 84 24 A8 00 00 00 F3 0F 11 44 24 38 F3 0F 10 84 24 A0 00 00 00 F3 0F 11 44 24 30 C7 44 24 28 21 00 00 00 C7 44 24 20 08 00 00 00 41 B9 01 00 00 00 4C 8B 44 24 60 BA 1D 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 E8 00 00 00 48 C7 44 24 68 00 00 00 00 B8 04 00 00 00 48 6B C0 00 F3 0F 10 84 24 B0 00 00 00 F3 0F 11 44 04 68 C7 44 24 40 02 00 00 00 F3 0F 10 84 24 A8 00 00 00 F3 0F 11 44 24 38 F3 0F 10 84 24 A0 00 00 00 F3 0F 11 44 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 12 00 00 00 41 B9 04 00 00 00 4C 8B 44 24 68 BA 1D 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 73 48 C7 44 24 78 00 00 00 00 B8 04 00 00 00 48 6B C0 00 F3 0F 10 84 24 B0 00 00 00 F3 0F 11 44 04 78 C7 44 24 40 02 00 00 00 F3 0F 10 84 24 A8 00 00 00 F3 0F 11 44 24 38 F3 0F 10 84 24 A0 00 00 00 F3 0F 11 44 24 30 C7 44 24 28 22 00 00 00 C7 44 24 20 11 00 00 00 41 B9 03 00 00 00 4C 8B 44 24 78 BA 1D 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? F3 0F 10 84 24 B0 00 00 00 48 8B 8C 24 80 00 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 98 00 00 00 C3 0F 1F 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "fminf"
		size = 140
		refs = "0016 _fdtest"
	strings:
		$1 = { F3 0F 11 4C 24 10 F3 0F 11 44 24 08 48 83 EC 28 48 8D 4C 24 30 E8 ?? ?? ?? ?? 98 83 F8 02 75 0A F3 0F 10 44 24 38 EB 5F EB 5D 48 8D 4C 24 38 E8 ?? ?? ?? ?? 98 83 F8 02 75 0A F3 0F 10 44 24 30 EB 45 EB 43 F3 0F 10 44 24 38 0F 2F 44 24 30 77 26 F3 0F 10 44 24 30 0F 2E 44 24 38 7A 23 75 21 B8 02 00 00 00 48 6B C0 01 0F B7 44 04 30 25 00 80 00 00 85 C0 74 0A F3 0F 10 44 24 30 EB 08 EB 06 F3 0F 10 44 24 38 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "_waccess"
		size = 65
		refs = "0017 _waccess_s"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 38 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 24 83 7C 24 24 00 74 0A C7 44 24 20 FF FF FF FF EB 08 C7 44 24 20 00 00 00 00 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1080_0_0 {
	meta:
		name = "_access"
		size = 65
		refs = "0017 _access_s"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 38 8B 54 24 48 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 24 83 7C 24 24 00 74 0A C7 44 24 20 FF FF FF FF EB 08 C7 44 24 20 00 00 00 00 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_86_1_0 {
	meta:
		name = "_waccess_s"
		size = 532
		refs = "0010 __security_cookie 004b ??_C@_1BO@DPAOGEII@?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0057 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006c ??_C@_1EM@MKIAKJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAd?$AAo?$AAs?$AA?2?$AAa?$AAc?$AAc@ 0076 _CrtDbgReportW 008a __doserrno 0095 _errno 00b8 ??_C@_1BG@CFNNCJOE@?$AA_?$AAw?$AAa?$AAc?$AAc?$AAe?$AAs?$AAs?$AA_?$AAs?$AA?$AA@ 00c4 _invalid_parameter 0104 ??_C@_1CM@DCGCAFIP@?$AA?$CI?$AA?$CI?$AAa?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CG?$AA?5?$AA?$CI?$AA?$HO?$AA6?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0199 __imp_GetFileAttributesExW 01a3 __imp_GetLastError 01aa _dosmaperr 020b __security_check_cookie"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 78 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 44 24 68 48 83 BC 24 80 00 00 00 00 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 6B 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 49 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 6B 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 30 01 00 00 8B 84 24 88 00 00 00 83 E0 F9 85 C0 75 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 6C 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 46 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 6C 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 EB 7A 4C 8D 44 24 40 33 D2 48 8B 8C 24 80 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 16 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 00 EB 4B 8B 44 24 40 83 E0 10 85 C0 74 04 33 C0 EB 3C 8B 44 24 40 83 E0 01 85 C0 74 2F 8B 84 24 88 00 00 00 83 E0 02 85 C0 74 21 E8 ?? ?? ?? ?? C7 00 05 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 04 EB 02 33 C0 48 8B 4C 24 68 48 33 CC E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_87_0_0 {
	meta:
		name = "_time64"
		size = 113
		refs = "0010 __imp_GetSystemTimeAsFileTime"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8D 4C 24 28 FF 15 ?? ?? ?? ?? 48 B8 00 80 3E D5 DE B1 9D 01 48 8B 4C 24 28 48 2B C8 48 8B C1 33 D2 B9 80 96 98 00 48 F7 F1 48 89 44 24 20 48 B8 FF 6F 40 93 07 00 00 00 48 39 44 24 20 7E 09 48 C7 44 24 20 FF FF FF FF 48 83 7C 24 40 00 74 0D 48 8B 44 24 40 48 8B 4C 24 20 48 89 08 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_88_3_0 {
	meta:
		name = "_freefls"
		size = 520
		refs = "003a _free_dbg 0101 _XcptActTab 012f _lock 0166 __initialmbcinfo 0187 _unlock 01b5 __removelocaleref 01bc __ptlocinfo 01ca __initiallocinfo 01e5 __freetlocinfo"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 89 44 24 20 48 83 7C 24 20 00 0F 84 E4 01 00 00 48 8B 44 24 20 48 83 78 38 00 74 13 BA 02 00 00 00 48 8B 44 24 20 48 8B 48 38 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 83 78 48 00 74 13 BA 02 00 00 00 48 8B 44 24 20 48 8B 48 48 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 83 78 58 00 74 13 BA 02 00 00 00 48 8B 44 24 20 48 8B 48 58 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 83 78 68 00 74 13 BA 02 00 00 00 48 8B 44 24 20 48 8B 48 68 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 83 78 70 00 74 13 BA 02 00 00 00 48 8B 44 24 20 48 8B 48 70 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 83 78 78 00 74 13 BA 02 00 00 00 48 8B 44 24 20 48 8B 48 78 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 83 B8 80 00 00 00 00 74 16 BA 02 00 00 00 48 8B 44 24 20 48 8B 88 80 00 00 00 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8B 4C 24 20 48 39 81 A0 00 00 00 74 16 BA 02 00 00 00 48 8B 44 24 20 48 8B 88 A0 00 00 00 E8 ?? ?? ?? ?? B9 0D 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 44 24 20 48 8B 80 B8 00 00 00 48 89 44 24 30 48 83 7C 24 30 00 74 34 48 8B 44 24 30 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 85 C0 75 1E 48 8D 05 ?? ?? ?? ?? 48 39 44 24 30 74 10 BA 02 00 00 00 48 8B 4C 24 30 E8 ?? ?? ?? ?? 90 B9 0D 00 00 00 E8 ?? ?? ?? ?? B9 0C 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 44 24 20 48 8B 80 C0 00 00 00 48 89 44 24 28 48 83 7C 24 28 00 74 3B 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 39 44 24 28 74 23 48 8D 05 ?? ?? ?? ?? 48 39 44 24 28 74 15 48 8B 44 24 28 83 38 00 75 0B 48 8B 4C 24 28 E8 ?? ?? ?? ?? 90 B9 0C 00 00 00 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_88_4_0 {
	meta:
		name = "_freefls$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "__updatetmbcinfo$fin$0 _free_locale$fin$0 _initptd$fin$0 _setmbcp$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 0D 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_88_5_0 {
	meta:
		name = "_freefls$fin$1"
		size = 27
		refs = "000f _unlock"
		altNames = "__updatetlocinfo$fin$0 _free_locale$fin$1 _initptd$fin$1 _locterm$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 0C 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_88_6_0 {
	meta:
		name = "_freeptd"
		size = 70
		refs = "000b __flsindex 0021 __crtFlsGetValue 0033 __crtFlsSetValue 003d _freefls"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 83 3D ?? ?? ?? ?? FF 74 2F 48 83 7C 24 30 00 75 10 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 30 33 D2 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_7_0 {
	meta:
		name = "_getptd"
		size = 42
		refs = "0005 _getptd_noexit 001c _amsg_exit"
	strings:
		$1 = { 48 83 EC 38 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 75 0A B9 10 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_88_8_0 {
	meta:
		name = "_getptd_noexit"
		size = 204
		refs = "0006 __imp_GetLastError 0010 __flsindex 0015 __crtFlsGetValue 003e ??_C@_0CM@KPPOKOAI@f?3?2dd?2vctools?2crt?2crtw32?2startup@ 0053 _calloc_dbg_impl 0070 __crtFlsSetValue 0080 _initptd 0086 __imp_GetCurrentThreadId 00ab _free_dbg 00be __imp_SetLastError"
	strings:
		$1 = { 48 83 EC 48 FF 15 ?? ?? ?? ?? 89 44 24 30 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 0F 85 8E 00 00 00 48 C7 44 24 28 00 00 00 00 C7 44 24 20 1C 01 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 78 04 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 74 54 48 8B 54 24 38 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 28 33 D2 48 8B 4C 24 38 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B 4C 24 38 89 01 48 8B 44 24 38 48 C7 40 08 FF FF FF FF EB 18 BA 02 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? 48 C7 44 24 38 00 00 00 00 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 8B 44 24 38 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_88_9_0 {
	meta:
		name = "_initptd"
		size = 292
		refs = "0016 _XcptActTab 0086 __initialmbcinfo 00a7 _lock 00c1 _unlock 00f8 __ptlocinfo 0110 __addlocaleref"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 88 A0 00 00 00 48 8B 44 24 30 C7 40 10 00 00 00 00 48 8B 44 24 30 C7 40 1C 01 00 00 00 48 8B 44 24 30 C7 80 C8 00 00 00 01 00 00 00 B8 02 00 00 00 48 6B C0 00 B9 43 00 00 00 48 8B 54 24 30 66 89 8C 02 64 01 00 00 B8 02 00 00 00 48 6B C0 00 B9 43 00 00 00 48 8B 54 24 30 66 89 8C 02 6A 02 00 00 48 8B 44 24 30 48 8D 0D ?? ?? ?? ?? 48 89 88 B8 00 00 00 48 8B 44 24 30 48 C7 80 70 04 00 00 00 00 00 00 B9 0D 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 44 24 30 48 8B 80 B8 00 00 00 F0 FF 00 B9 0D 00 00 00 E8 ?? ?? ?? ?? B9 0C 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 44 24 30 48 8B 4C 24 38 48 89 88 C0 00 00 00 48 8B 44 24 30 48 83 B8 C0 00 00 00 00 75 13 48 8B 44 24 30 48 8B 0D ?? ?? ?? ?? 48 89 88 C0 00 00 00 48 8B 44 24 30 48 8B 88 C0 00 00 00 E8 ?? ?? ?? ?? 90 B9 0C 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_88_12_0 {
	meta:
		name = "_mtinit"
		size = 192
		refs = "0005 _init_pointers 000a _mtinitlocks 0013 _mtterm 0021 _freefls 0026 __crtFlsAlloc 002c __flsindex 004d ??_C@_0CM@KPPOKOAI@f?3?2dd?2vctools?2crt?2crtw32?2startup@ 0062 _calloc_dbg 007f __crtFlsSetValue 0098 _initptd 009e __imp_GetCurrentThreadId"
	strings:
		$1 = { 48 83 EC 48 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 0C E8 ?? ?? ?? ?? 33 C0 E9 9D 00 00 00 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? FF 75 09 E8 ?? ?? ?? ?? 33 C0 EB 79 C7 44 24 20 72 00 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 78 04 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 30 48 83 7C 24 30 00 74 14 48 8B 54 24 30 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 09 E8 ?? ?? ?? ?? 33 C0 EB 2B 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B 4C 24 30 89 01 48 8B 44 24 30 48 C7 40 08 FF FF FF FF B8 01 00 00 00 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_88_13_0 {
	meta:
		name = "_mtterm"
		size = 44
		refs = "0006 __flsindex 0014 __crtFlsFree 0023 _mtdeletelocks"
	strings:
		$1 = { 48 83 EC 28 83 3D ?? ?? ?? ?? FF 74 15 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? FF FF FF FF E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "conjf"
		size = 85
		refs = "000f crealf 0028 cimagf 002f __xmm@80000000800000008000000080000000"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 8B 4C 24 40 E8 ?? ?? ?? ?? B8 04 00 00 00 48 6B C0 00 F3 0F 11 44 04 20 48 8B 4C 24 40 E8 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? B8 04 00 00 00 48 6B C0 01 F3 0F 11 44 04 20 B8 04 00 00 00 48 6B C0 00 48 8B 44 04 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "__sse2_acos2"
		size = 480
		refs = "000b iSignMask 004a dbOneHalf 0053 dbOne 00b0 dbTwo 00d7 dbPio2hi 00df dbPi 0101 dbA10 010d dbA09 0115 dbA08 011d dbA07 0136 dbA06 0142 dbA05 0158 dbA04 0160 dbA03 0170 dbA02 0178 dbA01 0190 dbA00"
	strings:
		$1 = { 48 81 EC A8 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F C2 D0 05 66 0F 29 54 24 20 66 0F 54 C8 66 0F 28 D8 66 0F 55 1D ?? ?? ?? ?? 66 0F 29 5C 24 30 66 0F 29 4C 24 40 66 0F 55 C8 66 0F 28 E1 66 0F C2 25 ?? ?? ?? ?? 05 66 0F 28 2D ?? ?? ?? ?? 66 0F 29 4C 24 50 66 0F 5C E9 66 0F 59 C9 66 0F 59 2D ?? ?? ?? ?? 66 0F 28 D4 66 0F 54 EC 66 0F 55 D1 66 0F 56 D5 66 0F 51 ED 66 0F 28 D9 66 0F 29 54 24 60 66 0F 59 D2 66 0F C2 1D ?? ?? ?? ?? 00 66 0F 29 5C 24 70 66 0F 28 0D ?? ?? ?? ?? 66 0F 56 4C 24 30 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 44 24 40 66 0F 28 DC 66 0F 54 C4 66 0F 55 E1 66 0F 56 C4 66 0F 29 84 24 80 00 00 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 54 44 24 20 66 0F 28 E3 66 0F 54 C3 66 0F 55 D9 66 0F 28 CA 66 0F 56 C3 66 0F 59 0D ?? ?? ?? ?? 66 0F 28 DA 66 0F 59 1D ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 29 84 24 90 00 00 00 66 0F 59 CA 66 0F 59 DA 66 0F 58 0D ?? ?? ?? ?? 66 0F 54 EC 66 0F 58 1D ?? ?? ?? ?? 66 0F 55 64 24 50 66 0F 59 CA 66 0F 59 DA 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 CA 66 0F 59 DA 66 0F 58 0D ?? ?? ?? ?? 66 0F 58 1D ?? ?? ?? ?? 66 0F 59 CA 66 0F 59 DA 66 0F 28 15 ?? ?? ?? ?? 66 0F 58 0D ?? ?? ?? ?? 66 0F 54 54 24 20 66 0F 59 4C 24 60 66 0F 56 EC 66 0F 58 CB 66 0F 59 CD 66 0F 28 44 24 70 66 0F 58 CD 66 0F 59 8C 24 80 00 00 00 66 0F 54 54 24 70 66 0F 58 8C 24 90 00 00 00 66 0F 55 C1 66 0F 56 C2 48 81 C4 A8 00 00 00 C3 66 90 }
	condition:
		$1
}

rule file_92_3_0 {
	meta:
		name = "_wcscoll_l"
		size = 647
		refs = "0024 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0057 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0063 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0078 ??_C@_1FE@MALIGBIJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?2@ 0082 _CrtDbgReportW 0096 _errno 00b9 ??_C@_1BG@FHFNCKLD@?$AA_?$AAw?$AAc?$AAs?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 00c5 _invalid_parameter 00d7 ??1_LocaleUpdate@@QEAA@XZ 0113 ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01a6 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 01d2 wcscmp 0234 __crtCompareStringW"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 88 00 00 00 48 8B 94 24 A0 00 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 83 BC 24 90 00 00 00 00 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 38 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 4F E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 38 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 44 FF FF FF 7F 48 8D 4C 24 58 E8 ?? ?? ?? ?? 8B 44 24 44 E9 9B 01 00 00 48 83 BC 24 98 00 00 00 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 39 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 4F E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 39 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 4C FF FF FF 7F 48 8D 4C 24 58 E8 ?? ?? ?? ?? 8B 44 24 4C E9 DF 00 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B 00 B9 08 00 00 00 48 6B C9 01 48 83 BC 08 28 01 00 00 00 75 2C 48 8B 94 24 98 00 00 00 48 8B 8C 24 90 00 00 00 E8 ?? ?? ?? ?? 89 44 24 54 48 8D 4C 24 58 E8 ?? ?? ?? ?? 8B 44 24 54 E9 92 00 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 8B 00 B9 08 00 00 00 48 6B C9 01 C7 44 24 28 FF FF FF FF 48 8B 94 24 98 00 00 00 48 89 54 24 20 41 B9 FF FF FF FF 4C 8B 84 24 90 00 00 00 BA 00 10 00 00 48 8B 8C 08 28 01 00 00 E8 ?? ?? ?? ?? 89 44 24 40 83 7C 24 40 00 75 23 E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 44 24 48 FF FF FF 7F 48 8D 4C 24 58 E8 ?? ?? ?? ?? 8B 44 24 48 EB 19 8B 44 24 40 83 E8 02 89 44 24 50 48 8D 4C 24 58 E8 ?? ?? ?? ?? 8B 44 24 50 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_92_4_0 {
	meta:
		name = "wcscoll"
		size = 402
		refs = "0010 __locale_changed 0047 ??_C@_1CC@ICKKAGJA@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0053 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0068 ??_C@_1FE@MALIGBIJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?2@ 0072 _CrtDbgReportW 0086 _errno 00a9 ??_C@_1BA@KPGOIMMO@?$AAw?$AAc?$AAs?$AAc?$AAo?$AAl?$AAl?$AA?$AA@ 00b5 _invalid_parameter 00ef ??_C@_1CC@CNADELFK@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0173 wcscmp 0189 _wcscoll_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 48 83 3D ?? ?? ?? ?? 00 0F 85 60 01 00 00 48 83 7C 24 50 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 56 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 56 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF 7F E9 CA 00 00 00 48 83 7C 24 58 00 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 57 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 57 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF 7F EB 25 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? EB 14 EB 12 45 33 C0 48 8B 54 24 58 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_93_0_0 {
	meta:
		name = "_ungetc_nolock"
		size = 771
		refs = "0033 _fileno 0055 __pioinfo 0078 __badioinfo 0115 ??_C@_1BAA@ODEGEDCK@?$AA?$CI?$AA?5?$AA?$CI?$AA_?$AAS?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?9?$AA?$DO?$AA_?$AAf?$AAl?$AAa?$AAg?$AA?5?$AA?$CG?$AA?5?$AA_?$AAI?$AAO?$AAS?$AAT?$AAR?$AAG?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0121 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0136 ??_C@_1FK@GNHGKPOM@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAh?$AA?2?$AAu?$AAn?$AAg?$AAe?$AAt@ 0140 _CrtDbgReportW 0154 _errno 0177 ??_C@_1BO@OLMLKKEA@?$AA_?$AAu?$AAn?$AAg?$AAe?$AAt?$AAc?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 0183 _invalid_parameter 01f3 _getbuf"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 83 EC 78 48 8B 84 24 88 00 00 00 48 89 44 24 48 48 8B 44 24 48 8B 40 18 83 E0 40 85 C0 0F 85 CE 00 00 00 48 8B 4C 24 48 E8 ?? ?? ?? ?? 89 44 24 38 83 7C 24 38 FF 74 33 83 7C 24 38 FE 74 2C 8B 44 24 38 C1 F8 05 48 98 48 8D 0D ?? ?? ?? ?? 8B 54 24 38 83 E2 1F 48 63 D2 48 6B D2 58 48 03 14 C1 48 8B C2 48 89 44 24 60 EB 0C 48 8D 05 ?? ?? ?? ?? 48 89 44 24 60 48 8B 44 24 60 0F B6 40 38 D0 E0 D0 F8 0F BE C0 85 C0 75 5C 83 7C 24 38 FF 74 33 83 7C 24 38 FE 74 2C 8B 44 24 38 C1 F8 05 48 98 48 8D 0D ?? ?? ?? ?? 8B 54 24 38 83 E2 1F 48 63 D2 48 6B D2 58 48 03 14 C1 48 8B C2 48 89 44 24 50 EB 0C 48 8D 05 ?? ?? ?? ?? 48 89 44 24 50 48 8B 44 24 50 0F B6 40 38 C0 E0 00 C0 F8 07 0F BE C0 85 C0 74 0A C7 44 24 3C 00 00 00 00 EB 08 C7 44 24 3C 01 00 00 00 8B 44 24 3C 89 44 24 40 83 7C 24 40 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 23 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 40 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 23 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF E9 6D 01 00 00 48 8B 84 24 88 00 00 00 48 89 44 24 30 83 BC 24 80 00 00 00 FF 74 2F 48 8B 44 24 30 8B 40 18 83 E0 01 85 C0 75 2A 48 8B 44 24 30 8B 40 18 25 80 00 00 00 85 C0 74 0F 48 8B 44 24 30 8B 40 18 83 E0 02 85 C0 74 0A B8 FF FF FF FF E9 1D 01 00 00 48 8B 44 24 30 48 83 78 10 00 75 0A 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 4C 24 30 48 8B 49 10 48 39 08 75 28 48 8B 44 24 30 83 78 08 00 74 0A B8 FF FF FF FF E9 DF 00 00 00 48 8B 44 24 30 48 8B 00 48 FF C0 48 8B 4C 24 30 48 89 01 48 8B 44 24 30 8B 40 18 83 E0 40 85 C0 74 4D 48 8B 44 24 30 48 8B 00 48 FF C8 48 89 44 24 58 48 8B 44 24 30 48 8B 4C 24 58 48 89 08 48 8B 44 24 58 0F BE 00 0F BE 8C 24 80 00 00 00 3B C1 74 1A 48 8B 44 24 30 48 8B 00 48 FF C0 48 8B 4C 24 30 48 89 01 B8 FF FF FF FF EB 72 EB 2C 48 8B 44 24 30 48 8B 00 48 FF C8 48 89 44 24 68 48 8B 44 24 30 48 8B 4C 24 68 48 89 08 48 8B 44 24 68 0F B6 8C 24 80 00 00 00 88 08 48 8B 44 24 30 8B 40 08 FF C0 48 8B 4C 24 30 89 41 08 48 8B 44 24 30 8B 40 18 83 E0 EF 48 8B 4C 24 30 89 41 18 48 8B 44 24 30 8B 40 18 83 C8 01 48 8B 4C 24 30 89 41 18 8B 84 24 80 00 00 00 25 FF 00 00 00 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "ungetc"
		size = 234
		refs = "0041 ??_C@_1CC@FADMNIL@?$AA?$CI?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 004d ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0062 ??_C@_1FA@DLIHGOGB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAi?$AAo?$AA?2?$AAu@ 006c _CrtDbgReportW 0080 _errno 00a3 ??_C@_1O@JDPLECOK@?$AAu?$AAn?$AAg?$AAe?$AAt?$AAc?$AA?$AA@ 00af _invalid_parameter 00c0 _lock_file 00cf _ungetc_nolock 00dd _unlock_file"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 83 EC 48 C7 44 24 38 00 00 00 00 48 83 7C 24 58 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 2F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 2F 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF FF EB 2B 48 8B 4C 24 58 E8 ?? ?? ?? ?? 90 48 8B 54 24 58 8B 4C 24 50 E8 ?? ?? ?? ?? 89 44 24 38 48 8B 4C 24 58 E8 ?? ?? ?? ?? 8B 44 24 38 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_93_2_0 {
	meta:
		name = "ungetc$fin$0"
		size = 26
		refs = "000e _unlock_file"
		altNames = "fgetws$fin$0 ungetwc$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 30 48 8B EA 48 8B 4D 58 E8 ?? ?? ?? ?? 90 48 83 C4 30 5D C3 CC }
	condition:
		$1
}

rule file_95_4_0 {
	meta:
		name = "_ismbcdigit_l"
		size = 536
		refs = "001f ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 0087 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 00a3 ??1_LocaleUpdate@@QEAA@XZ 0105 __crtGetStringTypeA 01c0 _isctype_l 01e5 _chvalidator_l"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 57 48 81 EC 90 00 00 00 48 8B 94 24 A8 00 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 81 BC 24 A0 00 00 00 FF 00 00 00 0F 86 4D 01 00 00 33 C0 66 89 44 24 44 48 8D 44 24 46 48 8B F8 33 C0 B9 02 00 00 00 F3 AA 8B 84 24 A0 00 00 00 C1 E8 08 25 FF 00 00 00 B9 01 00 00 00 48 6B C9 00 88 44 0C 40 8B 84 24 A0 00 00 00 25 FF 00 00 00 B9 01 00 00 00 48 6B C9 01 88 44 0C 40 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 40 08 83 78 08 00 75 1B C7 44 24 50 00 00 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 8B 44 24 50 E9 5F 01 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 40 08 48 89 84 24 80 00 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? C7 44 24 30 01 00 00 00 48 8B 8C 24 80 00 00 00 8B 49 04 89 4C 24 28 48 8D 4C 24 44 48 89 4C 24 20 41 B9 02 00 00 00 4C 8D 44 24 40 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 1B C7 44 24 58 00 00 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 8B 44 24 58 E9 E7 00 00 00 B8 02 00 00 00 48 6B C0 01 0F B7 44 04 44 85 C0 75 1F B8 02 00 00 00 48 6B C0 00 0F B7 44 04 44 83 E0 04 85 C0 74 0A C7 44 24 48 01 00 00 00 EB 08 C7 44 24 48 00 00 00 00 8B 44 24 48 89 44 24 5C 48 8D 4C 24 60 E8 ?? ?? ?? ?? 8B 44 24 5C E9 93 00 00 00 E9 84 00 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 85 C0 74 3A 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 8B 00 83 B8 D4 00 00 00 01 7E 24 48 8D 4C 24 60 E8 ?? ?? ?? ?? 4C 8B C0 BA 04 00 00 00 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 89 44 24 4C EB 23 48 8D 4C 24 60 E8 ?? ?? ?? ?? 41 B8 04 00 00 00 8B 94 24 A0 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 4C 8B 44 24 4C 89 44 24 54 48 8D 4C 24 60 E8 ?? ?? ?? ?? 8B 44 24 54 EB 0A 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 81 C4 90 00 00 00 5F C3 }
	condition:
		$1
}

rule file_96_0_0 {
	meta:
		name = "__common_dasin_cout_rare"
		size = 2752
		refs = "0070 _vmldASinHATab"
	strings:
		$1 = { 56 48 81 EC D0 00 00 00 33 C0 44 0F B7 41 06 41 81 E0 F0 7F 00 00 F2 0F 10 01 41 81 F8 F0 7F 00 00 48 8B 31 44 0F 29 BC 24 A0 00 00 00 44 0F 29 B4 24 B0 00 00 00 44 0F 29 5C 24 60 44 0F 29 54 24 70 44 0F 29 8C 24 80 00 00 00 44 0F 29 84 24 90 00 00 00 0F 29 BC 24 C0 00 00 00 0F 84 3E 0A 00 00 48 89 74 24 38 48 C1 EE 38 F2 44 0F 10 1D ?? ?? ?? ?? 83 E6 7F 40 88 74 24 3F F2 44 0F 10 4C 24 38 4C 8B 0D ?? ?? ?? ?? 66 45 0F 2F D9 0F 82 B9 09 00 00 F2 0F 10 05 ?? ?? ?? ?? 66 41 0F 2F C1 0F 86 1A 04 00 00 66 44 0F 2F 0D ?? ?? ?? ?? 0F 86 7C 03 00 00 F2 44 0F 10 35 ?? ?? ?? ?? 41 0F 28 E1 F2 41 0F 59 E6 45 0F 28 C1 F2 0F 11 64 24 28 45 0F 28 D1 F2 44 0F 10 5C 24 28 41 0F 28 DE F2 44 0F 5C 5C 24 38 F2 44 0F 11 5C 24 20 F2 0F 10 7C 24 28 F2 0F 10 4C 24 20 F2 0F 5C F9 F2 0F 11 7C 24 28 F2 0F 10 54 24 28 F2 44 0F 5C C2 F2 44 0F 11 44 24 20 F2 0F 10 6C 24 28 0F 28 D5 F2 44 0F 58 D5 F2 0F 59 D5 F2 44 0F 10 7C 24 20 0F 28 C2 F2 45 0F 59 D7 F2 0F 59 DA F2 41 0F 58 C2 F2 44 0F 10 05 ?? ?? ?? ?? F2 44 0F 59 C0 F2 0F 11 5C 24 28 F2 0F 10 64 24 28 F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 5C E2 F2 44 0F 59 C0 F2 0F 11 64 24 20 F2 0F 10 4C 24 28 F2 44 0F 10 5C 24 20 F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 5C CB F2 44 0F 59 C0 F2 0F 11 4C 24 28 F2 0F 10 7C 24 28 F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 5C D7 F2 44 0F 59 C0 F2 0F 11 54 24 20 41 0F 28 F9 F2 0F 10 64 24 28 F2 0F 10 5C 24 20 F2 44 0F 59 FC F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 58 D3 F2 0F 59 EC F2 44 0F 59 C0 F2 41 0F 59 FA F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 58 FF F2 44 0F 59 C0 45 0F 28 FE F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 59 FD F2 44 0F 59 C0 F2 44 0F 11 7C 24 28 F2 44 0F 10 5C 24 28 F2 44 0F 5C DD F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 11 5C 24 20 44 0F 28 DD F2 0F 10 54 24 28 F2 0F 58 EF F2 44 0F 59 C0 F2 44 0F 59 D5 F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 10 4C 24 20 F2 44 0F 59 C0 F2 0F 5C D1 F2 0F 11 54 24 28 F2 0F 10 5C 24 28 F2 44 0F 5C DB 0F 28 DC F2 44 0F 58 05 ?? ?? ?? ?? F2 44 0F 11 5C 24 20 F2 0F 10 4C 24 28 F2 0F 10 54 24 20 44 0F 28 FA F2 0F 59 D9 F2 44 0F 58 FF F2 44 0F 59 C0 F2 41 0F 59 E7 F2 44 0F 59 F3 F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 58 E2 F2 44 0F 59 C0 F2 44 0F 11 74 24 28 44 0F 28 DB F2 44 0F 10 54 24 28 F2 44 0F 5C D3 F2 0F 58 DC F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 59 C3 F2 44 0F 11 54 24 20 F2 44 0F 10 54 24 28 F2 44 0F 10 74 24 20 F2 44 0F 59 C0 F2 45 0F 5C D6 F2 44 0F 11 54 24 28 F2 44 0F 10 15 ?? ?? ?? ?? F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 59 D5 F2 0F 59 C3 F2 0F 10 2D ?? ?? ?? ?? F2 44 0F 58 D0 F2 0F 59 CD F2 0F 59 FD F2 0F 59 D5 F2 45 0F 58 D0 F2 44 0F 10 74 24 28 41 0F 28 C1 F2 45 0F 5C DE F2 0F 58 C1 F2 44 0F 58 D7 F2 44 0F 11 5C 24 20 F2 44 0F 58 D2 F2 44 0F 10 74 24 28 F2 44 0F 10 5C 24 20 F2 0F 11 44 24 28 F2 0F 10 54 24 28 F2 0F 10 05 ?? ?? ?? ?? F2 44 0F 5C CA F2 0F 59 E0 F2 44 0F 59 F0 F2 41 0F 59 C3 F2 44 0F 58 C9 F2 44 0F 11 4C 24 20 F2 0F 10 4C 24 28 F2 44 0F 10 4C 24 20 F2 45 0F 58 D1 F2 44 0F 58 D4 0F 28 E1 F2 41 0F 58 E6 F2 44 0F 58 D0 F2 0F 11 64 24 28 F2 44 0F 10 4C 24 28 F2 41 0F 5C C9 F2 41 0F 58 CE F2 0F 11 4C 24 20 F2 0F 10 5C 24 28 F2 0F 10 54 24 20 8A 49 07 F2 44 0F 58 D2 80 E1 80 F2 44 0F 58 D3 F2 44 0F 11 54 24 30 40 8A 74 24 37 40 80 E6 7F 40 0A F1 40 88 74 24 37 4C 8B 44 24 30 4C 89 02 E9 2C 06 00 00 66 44 0F 2F 0D ?? ?? ?? ?? 72 42 F2 45 0F 58 CB F2 44 0F 11 4C 24 28 F2 0F 10 44 24 28 F2 0F 59 44 24 38 F2 0F 11 44 24 30 40 8A 74 24 37 8A 49 07 40 80 E6 7F 80 E1 80 40 0A F1 40 88 74 24 37 4C 8B 44 24 30 4C 89 02 E9 DF 05 00 00 F2 45 0F 59 C9 F2 44 0F 11 4C 24 28 F2 0F 10 44 24 28 8A 49 07 80 E1 80 F2 0F 58 44 24 38 F2 0F 11 44 24 30 40 8A 74 24 37 40 80 E6 7F 40 0A F1 40 88 74 24 37 4C 8B 44 24 30 4C 89 02 E9 9D 05 00 00 4D 8B D1 F2 45 0F 5C D9 F2 41 0F 59 C3 F2 0F 11 44 24 38 44 0F B7 44 24 3E 41 81 E0 F0 7F 00 00 41 C1 E8 04 41 81 C0 01 FC FF FF 45 8B D8 41 8B F0 41 F7 DB 41 81 C3 FF 03 00 00 49 C1 EA 30 41 81 E3 FF 07 00 00 41 C1 E3 04 41 81 E2 0F 80 FF FF 4C 89 4C 24 40 45 0B D3 66 44 89 54 24 46 83 E6 01 F2 0F 10 7C 24 40 44 8B DE F2 0F 59 C7 0F 28 E8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 58 E8 F2 44 0F 10 0D ?? ?? ?? ?? 75 03 0F 28 E8 F2 44 0F 59 CD F2 0F 58 C2 F2 0F 11 44 24 48 45 0F 28 C1 44 8B 54 24 48 44 2B C6 41 C1 E3 08 41 81 E2 FF 01 00 00 45 03 D3 F2 44 0F 5C C5 4C 8D 1D ?? ?? ?? ?? F2 44 0F 11 44 24 20 44 0F 28 C5 F2 0F 10 5C 24 20 F2 0F 10 3D ?? ?? ?? ?? F2 44 0F 5C CB F2 43 0F 10 04 D3 41 0F 28 C9 0F 28 E0 F2 45 0F 5C C1 F2 0F 59 E0 F2 44 0F 59 C8 F2 0F 59 CC F2 41 0F 59 E0 F2 0F 5C 0D ?? ?? ?? ?? 41 D1 E8 F2 0F 58 CC F2 0F 59 F9 41 81 C0 FF 03 00 00 4C 89 4C 24 50 41 81 E0 FF 07 00 00 49 C1 E9 30 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 41 81 E1 0F 80 FF FF 41 C1 E0 04 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 45 0B C8 66 44 89 4C 24 56 F2 0F 10 5C 24 50 F2 44 0F 59 CB F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 44 0F 10 35 ?? ?? ?? ?? F2 0F 58 3D ?? ?? ?? ?? F2 44 0F 58 35 ?? ?? ?? ?? F2 0F 59 F9 F2 45 0F 59 F3 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 58 3D ?? ?? ?? ?? F2 0F 59 F9 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 F8 F2 41 0F 59 C0 F2 0F 59 FD 44 0F 28 C1 F2 0F 58 F8 F2 45 0F 59 C1 F2 0F 59 FB F2 44 0F 11 44 24 28 F2 44 0F 10 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 0F 10 54 24 28 F2 0F 10 1D ?? ?? ?? ?? F2 41 0F 5C D1 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 0F 11 54 24 20 0F 28 D3 F2 0F 10 6C 24 28 F2 0F 10 64 24 20 F2 0F 10 05 ?? ?? ?? ?? F2 0F 5C EC F2 44 0F 58 05 ?? ?? ?? ?? F2 0F 58 15 ?? ?? ?? ?? F2 45 0F 59 C3 F2 41 0F 58 D6 F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 59 D3 F2 45 0F 59 C3 F2 0F 11 6C 24 28 0F 28 E9 F2 44 0F 10 54 24 28 0F 28 E0 F2 41 0F 59 EB F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 5C CA F2 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 C3 F2 0F 58 E2 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 44 0F 11 4C 24 20 F2 44 0F 10 4C 24 28 F2 44 0F 10 7C 24 20 F2 0F 11 6C 24 28 F2 41 0F 58 FF F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 44 0F 10 54 24 28 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 5C D3 F2 45 0F 59 C3 F2 44 0F 11 54 24 20 44 0F 28 D1 F2 0F 10 54 24 28 F2 44 0F 10 7C 24 20 F2 44 0F 58 05 ?? ?? ?? ?? F2 41 0F 5C D7 F2 45 0F 59 C3 F2 0F 11 54 24 28 F2 44 0F 10 74 24 28 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 44 0F 58 05 ?? ?? ?? ?? F2 45 0F 59 C3 F2 45 0F 59 C3 F2 45 0F 59 C3 F2 41 0F 58 E0 F2 0F 59 FC 41 0F 28 E3 F2 41 0F 5C E6 F2 0F 11 64 24 20 F2 44 0F 10 74 24 28 41 0F 28 EE 41 0F 28 E6 F2 41 0F 59 EE F2 41 0F 58 E3 F2 44 0F 59 F3 F2 44 0F 59 D5 F2 0F 10 54 24 20 F2 44 0F 11 54 24 28 F2 44 0F 10 7C 24 28 F2 0F 59 E2 F2 44 0F 5C FD F2 0F 59 DA F2 44 0F 11 7C 24 20 F2 44 0F 10 7C 24 28 F2 44 0F 10 54 24 20 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 5C FA F2 41 0F 59 D3 F2 44 0F 11 7C 24 28 45 0F 28 FE F2 44 0F 10 54 24 28 F2 41 0F 5C EA F2 0F 58 15 ?? ?? ?? ?? F2 0F 11 6C 24 20 F2 44 0F 10 54 24 28 F2 44 0F 59 15 ?? ?? ?? ?? F2 41 0F 59 D3 F2 45 0F 58 FA F2 0F 58 15 ?? ?? ?? ?? F2 0F 10 6C 24 20 F2 41 0F 58 D0 F2 0F 58 EC F2 41 0F 59 D1 F2 0F 59 2D ?? ?? ?? ?? F2 44 0F 11 7C 24 28 F2 44 0F 10 7C 24 28 F2 44 0F 11 54 24 48 F2 45 0F 5C F7 F2 45 0F 58 F2 F2 44 0F 11 74 24 20 44 0F 28 F0 F2 44 0F 10 7C 24 28 F2 44 0F 10 54 24 20 F2 45 0F 58 F7 F2 44 0F 11 74 24 28 F2 44 0F 10 74 24 28 F2 41 0F 5C C6 F2 41 0F 58 C7 F2 0F 11 44 24 20 F2 44 0F 10 74 24 28 F2 41 0F 59 CE F2 44 0F 10 7C 24 20 F2 0F 11 4C 24 28 F2 0F 10 4C 24 28 F2 41 0F 5C CE F2 0F 11 4C 24 20 F2 0F 10 4C 24 28 F2 0F 10 44 24 20 F2 0F 5C C8 F2 0F 11 4C 24 28 F2 0F 10 44 24 28 F2 44 0F 5C F0 F2 44 0F 11 74 24 20 F2 0F 10 44 24 28 F2 44 0F 10 74 24 20 F2 45 0F 58 F2 F2 45 0F 58 F7 F2 44 0F 58 F3 F2 44 0F 58 F5 F2 45 0F 59 F1 F2 44 0F 59 C8 F2 41 0F 58 FE F2 0F 10 05 ?? ?? ?? ?? F2 0F 58 FA 44 0F 28 D8 F2 0F 10 15 ?? ?? ?? ?? F2 45 0F 5C D9 F2 0F 5C D7 F2 44 0F 11 5C 24 28 F2 44 0F 10 5C 24 28 F2 41 0F 5C C3 F2 41 0F 5C C1 F2 0F 11 44 24 20 F2 0F 10 5C 24 28 F2 0F 10 4C 24 20 8A 49 07 F2 0F 58 D1 80 E1 80 F2 0F 58 DA F2 0F 11 5C 24 30 40 8A 74 24 37 40 80 E6 7F 40 0A F1 40 88 74 24 37 48 8B 4C 24 30 48 89 0A EB 11 B8 01 00 00 00 F2 0F 5C C0 F2 0F 5E C0 F2 0F 11 02 0F 28 BC 24 C0 00 00 00 44 0F 28 84 24 90 00 00 00 44 0F 28 8C 24 80 00 00 00 44 0F 28 54 24 70 44 0F 28 5C 24 60 44 0F 28 B4 24 B0 00 00 00 44 0F 28 BC 24 A0 00 00 00 48 81 C4 D0 00 00 00 5E C3 F2 0F 5E C0 F2 0F 11 02 F7 41 04 FF FF 0F 00 75 AE BA 01 00 00 00 33 C0 83 39 00 0F 44 C2 EB 9F }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "__tzset"
		size = 67
		refs = "0006 ?first_time@?1??__tzset@@9@9 0013 _lock 0022 _tzset_nolock 003a _unlock"
	strings:
		$1 = { 48 83 EC 28 83 3D ?? ?? ?? ?? 00 75 31 B9 06 00 00 00 E8 ?? ?? ?? ?? 90 83 3D ?? ?? ?? ?? 00 75 13 E8 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? B9 06 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_97_1_0 {
	meta:
		name = "__tzset$fin$0"
		size = 27
		refs = "000f _unlock"
		altNames = "_isindst$fin$0 _tzset$fin$0"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA B9 06 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_97_3_0 {
	meta:
		name = "_isindst"
		size = 61
		refs = "0017 _lock 0022 _isindst_nolock 0030 _unlock"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 B9 06 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 4C 24 40 E8 ?? ?? ?? ?? 89 44 24 20 B9 06 00 00 00 E8 ?? ?? ?? ?? 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_97_5_0 {
	meta:
		name = "_isindst_nolock"
		size = 1205
		refs = "001a _get_daylight 0032 ??_C@_1EM@OKECDHDE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAt?$AAz@ 0039 ??_C@_1CA@GOLIIEDM@?$AA_?$AAi?$AAs?$AAi?$AAn?$AAd?$AAs?$AAt?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 0040 ??_C@_1DC@MEHEMOPB@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAd?$AAa?$AAy?$AAl?$AAi?$AAg?$AAh?$AAt?$AA?$CI?$AA?$CG?$AAd?$AAa?$AAy?$AAl?$AAi?$AAg?$AAh?$AAt?$AA?$CJ?$AA?$AA@ 0047 _invoke_watson_if_error 0063 dststart 0076 dstend 0085 tzapiused 0093 tzinfo 010d cvtdate"
	strings:
		$1 = { 48 89 4C 24 08 48 81 EC 88 00 00 00 C7 44 24 60 00 00 00 00 48 8D 4C 24 60 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 39 02 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 83 7C 24 60 00 75 07 33 C0 E9 54 04 00 00 48 8B 84 24 90 00 00 00 8B 0D ?? ?? ?? ?? 39 48 14 75 17 48 8B 84 24 90 00 00 00 8B 0D ?? ?? ?? ?? 39 48 14 0F 84 E9 02 00 00 83 3D ?? ?? ?? ?? 00 0F 84 E1 01 00 00 0F B7 05 ?? ?? ?? ?? 85 C0 75 78 0F B7 05 ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? 0F B7 15 ?? ?? ?? ?? 44 0F B7 05 ?? ?? ?? ?? 44 0F B7 0D ?? ?? ?? ?? 44 0F B7 15 ?? ?? ?? ?? 44 0F B7 1D ?? ?? ?? ?? 89 44 24 50 89 4C 24 48 89 54 24 40 44 89 44 24 38 C7 44 24 30 00 00 00 00 44 89 4C 24 28 44 89 54 24 20 45 8B CB 48 8B 84 24 90 00 00 00 44 8B 40 14 BA 01 00 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? EB 6E 0F B7 05 ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? 0F B7 15 ?? ?? ?? ?? 44 0F B7 05 ?? ?? ?? ?? 44 0F B7 0D ?? ?? ?? ?? 44 0F B7 15 ?? ?? ?? ?? 89 44 24 50 89 4C 24 48 89 54 24 40 44 89 44 24 38 44 89 4C 24 30 C7 44 24 28 00 00 00 00 C7 44 24 20 00 00 00 00 45 8B CA 48 8B 84 24 90 00 00 00 44 8B 40 14 33 D2 B9 01 00 00 00 E8 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 85 C0 75 75 0F B7 05 ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? 0F B7 15 ?? ?? ?? ?? 44 0F B7 05 ?? ?? ?? ?? 44 0F B7 0D ?? ?? ?? ?? 44 0F B7 15 ?? ?? ?? ?? 44 0F B7 1D ?? ?? ?? ?? 89 44 24 50 89 4C 24 48 89 54 24 40 44 89 44 24 38 C7 44 24 30 00 00 00 00 44 89 4C 24 28 44 89 54 24 20 45 8B CB 48 8B 84 24 90 00 00 00 44 8B 40 14 BA 01 00 00 00 33 C9 E8 ?? ?? ?? ?? EB 6B 0F B7 05 ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? 0F B7 15 ?? ?? ?? ?? 44 0F B7 05 ?? ?? ?? ?? 44 0F B7 0D ?? ?? ?? ?? 44 0F B7 15 ?? ?? ?? ?? 89 44 24 50 89 4C 24 48 89 54 24 40 44 89 44 24 38 44 89 4C 24 30 C7 44 24 28 00 00 00 00 C7 44 24 20 00 00 00 00 45 8B CA 48 8B 84 24 90 00 00 00 44 8B 40 14 33 D2 33 C9 E8 ?? ?? ?? ?? E9 FB 00 00 00 C7 44 24 68 03 00 00 00 C7 44 24 64 02 00 00 00 C7 44 24 70 0B 00 00 00 C7 44 24 6C 01 00 00 00 48 8B 84 24 90 00 00 00 83 78 14 6B 7D 20 C7 44 24 68 04 00 00 00 C7 44 24 64 01 00 00 00 C7 44 24 70 0A 00 00 00 C7 44 24 6C 05 00 00 00 C7 44 24 50 00 00 00 00 C7 44 24 48 00 00 00 00 C7 44 24 40 00 00 00 00 C7 44 24 38 02 00 00 00 C7 44 24 30 00 00 00 00 C7 44 24 28 00 00 00 00 8B 44 24 64 89 44 24 20 44 8B 4C 24 68 48 8B 84 24 90 00 00 00 44 8B 40 14 BA 01 00 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? C7 44 24 50 00 00 00 00 C7 44 24 48 00 00 00 00 C7 44 24 40 00 00 00 00 C7 44 24 38 02 00 00 00 C7 44 24 30 00 00 00 00 C7 44 24 28 00 00 00 00 8B 44 24 6C 89 44 24 20 44 8B 4C 24 70 48 8B 84 24 90 00 00 00 44 8B 40 14 BA 01 00 00 00 33 C9 E8 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 39 05 ?? ?? ?? ?? 7D 5F 48 8B 84 24 90 00 00 00 8B 0D ?? ?? ?? ?? 39 48 1C 7C 13 48 8B 84 24 90 00 00 00 8B 0D ?? ?? ?? ?? 39 48 1C 7E 07 33 C0 E9 06 01 00 00 48 8B 84 24 90 00 00 00 8B 0D ?? ?? ?? ?? 39 48 1C 7E 1D 48 8B 84 24 90 00 00 00 8B 0D ?? ?? ?? ?? 39 48 1C 7D 0A B8 01 00 00 00 E9 D6 00 00 00 EB 5A 48 8B 84 24 90 00 00 00 8B 0D ?? ?? ?? ?? 39 48 1C 7C 13 48 8B 84 24 90 00 00 00 8B 0D ?? ?? ?? ?? 39 48 1C 7E 0A B8 01 00 00 00 E9 A4 00 00 00 48 8B 84 24 90 00 00 00 8B 0D ?? ?? ?? ?? 39 48 1C 7E 17 48 8B 84 24 90 00 00 00 8B 0D ?? ?? ?? ?? 39 48 1C 7D 04 33 C0 EB 7A 48 8B 84 24 90 00 00 00 6B 40 04 3C 48 8B 8C 24 90 00 00 00 8B 09 03 C8 8B C1 48 8B 8C 24 90 00 00 00 69 49 08 10 0E 00 00 03 C1 69 C0 E8 03 00 00 89 44 24 74 48 8B 84 24 90 00 00 00 8B 0D ?? ?? ?? ?? 39 48 1C 75 1B 8B 05 ?? ?? ?? ?? 39 44 24 74 7C 09 B8 01 00 00 00 EB 1F EB 04 33 C0 EB 19 EB 17 8B 05 ?? ?? ?? ?? 39 44 24 74 7D 09 B8 01 00 00 00 EB 04 EB 02 33 C0 48 81 C4 88 00 00 00 C3 }
	condition:
		$1
}

rule file_97_6_0 {
	meta:
		name = "_set_daylight"
		size = 24
		refs = "0009 __daylight"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 E8 ?? ?? ?? ?? 8B 4C 24 30 89 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_97_7_0 {
	meta:
		name = "_set_dstbias"
		size = 24
		refs = "0009 __dstbias"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 E8 ?? ?? ?? ?? 8B 4C 24 30 89 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_97_8_0 {
	meta:
		name = "_set_timezone"
		size = 24
		refs = "0009 __timezone"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 E8 ?? ?? ?? ?? 8B 4C 24 30 89 08 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_97_9_0 {
	meta:
		name = "_tzset"
		size = 36
		refs = "000a _lock 0010 _tzset_nolock 001b _unlock"
	strings:
		$1 = { 48 83 EC 28 B9 06 00 00 00 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 90 B9 06 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_97_11_0 {
	meta:
		name = "_tzset_nolock"
		size = 1664
		refs = "0044 _lock 004a __tzname 0059 _get_timezone 0071 ??_C@_1EM@OKECDHDE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAt?$AAz@ 0078 ??_C@_1BM@IIODHMJC@?$AA_?$AAt?$AAz?$AAs?$AAe?$AAt?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 007f ??_C@_1DC@CMKCHHFC@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CI?$AA?$CG?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CJ?$AA?$AA@ 0086 _invoke_watson_if_error 0090 _get_daylight 00b6 ??_C@_1DC@MEHEMOPB@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAd?$AAa?$AAy?$AAl?$AAi?$AAg?$AAh?$AAt?$AA?$CI?$AA?$CG?$AAd?$AAa?$AAy?$AAl?$AAi?$AAg?$AAh?$AAt?$AA?$CJ?$AA?$AA@ 00c7 _get_dstbias 00ed ??_C@_1CO@IMMOMMCB@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAd?$AAs?$AAt?$AAb?$AAi?$AAa?$AAs?$AA?$CI?$AA?$CG?$AAd?$AAs?$AAt?$AAb?$AAi?$AAa?$AAs?$AA?$CJ?$AA?$AA@ 00f9 ___lc_codepage_func 0103 tzapiused 010d dstend 011d dststart 0124 ??_C@_02CLFPBFFP@TZ?$AA@ 0129 _getenv_helper_nolock 014d lastTZ 0161 _free_dbg 0173 tzinfo 0179 __imp_GetTimeZoneInformation 0245 __imp_WideCharToMultiByte 034e strcmp 0384 strlen 0394 ??_C@_0CG@LOFJMIGF@f?3?2dd?2vctools?2crt?2crtw32?2time?2tz@ 03a1 _malloc_dbg 03dd strcpy_s 0403 ??_C@_1EK@MCAIMDPB@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAl?$AAa?$AAs?$AAt?$AAT?$AAZ?$AA?0?$AA?5?$AAs?$AAt?$AAr?$AAl?$AAe?$AAn?$AA?$CI?$AAT?$AAZ?$AA?$CJ?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?0@ 0413 _set_timezone 041c _set_daylight 0425 _set_dstbias 0430 _unlock 0462 strncpy_s 0488 ??_C@_1EA@FIJBKALB@?$AAs?$AAt?$AAr?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAt?$AAz?$AAn?$AAa?$AAm?$AAe?$AA?$FL?$AA0?$AA?$FN?$AA?0?$AA?5?$AA6?$AA4?$AA?0?$AA?5?$AAT?$AAZ?$AA?0?$AA?5?$AA3?$AA?$CJ?$AA?$AA@ 04cb atol 0647 ??_C@_1EA@GEPBEDLJ@?$AAs?$AAt?$AAr?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAt?$AAz?$AAn?$AAa?$AAm?$AAe?$AA?$FL?$AA1?$AA?$FN?$AA?0?$AA?5?$AA6?$AA4?$AA?0?$AA?5?$AAT?$AAZ?$AA?0?$AA?5?$AA3?$AA?$CJ?$AA?$AA@"
	strings:
		$1 = { 48 83 EC 78 C7 44 24 48 00 00 00 00 C7 44 24 4C 00 00 00 00 C7 44 24 58 00 00 00 00 48 C7 44 24 50 00 00 00 00 C7 44 24 5C 00 00 00 00 C7 44 24 64 00 00 00 00 48 C7 44 24 40 00 00 00 00 B9 07 00 00 00 E8 ?? ?? ?? ?? 90 E8 ?? ?? ?? ?? 48 89 44 24 50 48 8D 4C 24 48 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 90 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8D 4C 24 4C E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 91 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8D 4C 24 58 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 92 00 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 68 C7 05 ?? ?? ?? ?? 00 00 00 00 C7 05 ?? ?? ?? ?? FF FF FF FF 8B 05 ?? ?? ?? ?? 89 05 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 74 10 48 8B 44 24 40 0F BE 00 85 C0 0F 85 ED 01 00 00 48 83 3D ?? ?? ?? ?? 00 74 1C BA 02 00 00 00 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 8D 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 FF 0F 84 A4 01 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 6B 05 ?? ?? ?? ?? 3C 89 44 24 48 0F B7 05 ?? ?? ?? ?? 85 C0 74 13 6B 05 ?? ?? ?? ?? 3C 8B 4C 24 48 03 C8 8B C1 89 44 24 48 0F B7 05 ?? ?? ?? ?? 85 C0 74 2A 83 3D ?? ?? ?? ?? 00 74 21 C7 44 24 4C 01 00 00 00 8B 05 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 2B C8 8B C1 6B C0 3C 89 44 24 58 EB 10 C7 44 24 4C 00 00 00 00 C7 44 24 58 00 00 00 00 B8 08 00 00 00 48 6B C0 00 48 8D 4C 24 60 48 89 4C 24 38 48 C7 44 24 30 00 00 00 00 C7 44 24 28 3F 00 00 00 48 8B 4C 24 50 48 8B 04 01 48 89 44 24 20 41 B9 FF FF FF FF 4C 8D 05 ?? ?? ?? ?? 33 D2 8B 4C 24 68 FF 15 ?? ?? ?? ?? 85 C0 74 28 83 7C 24 60 00 75 21 B8 08 00 00 00 48 6B C0 00 B9 01 00 00 00 48 6B C9 3F 48 8B 54 24 50 48 8B 04 02 C6 04 01 00 EB 1F B8 08 00 00 00 48 6B C0 00 B9 01 00 00 00 48 6B C9 00 48 8B 54 24 50 48 8B 04 02 C6 04 01 00 B8 08 00 00 00 48 6B C0 01 48 8D 4C 24 60 48 89 4C 24 38 48 C7 44 24 30 00 00 00 00 C7 44 24 28 3F 00 00 00 48 8B 4C 24 50 48 8B 04 01 48 89 44 24 20 41 B9 FF FF FF FF 4C 8D 05 ?? ?? ?? ?? 33 D2 8B 4C 24 68 FF 15 ?? ?? ?? ?? 85 C0 74 28 83 7C 24 60 00 75 21 B8 08 00 00 00 48 6B C0 01 B9 01 00 00 00 48 6B C9 3F 48 8B 54 24 50 48 8B 04 02 C6 04 01 00 EB 1F B8 08 00 00 00 48 6B C0 01 B9 01 00 00 00 48 6B C9 00 48 8B 54 24 50 48 8B 04 02 C6 04 01 00 C7 44 24 5C 01 00 00 00 E9 D7 00 00 00 48 83 3D ?? ?? ?? ?? 00 74 22 48 8B 15 ?? ?? ?? ?? 48 8B 4C 24 40 E8 ?? ?? ?? ?? 85 C0 75 0D C7 44 24 5C 01 00 00 00 E9 AB 00 00 00 48 83 3D ?? ?? ?? ?? 00 74 11 BA 02 00 00 00 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 FF C0 41 B9 1A 01 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 75 0A C7 44 24 5C 01 00 00 00 EB 4E 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 FF C0 4C 8B 44 24 40 48 8B D0 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 20 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 4C 24 48 E8 ?? ?? ?? ?? 8B 4C 24 4C E8 ?? ?? ?? ?? 8B 4C 24 58 E8 ?? ?? ?? ?? 90 B9 07 00 00 00 E8 ?? ?? ?? ?? 83 7C 24 5C 00 0F 85 3C 02 00 00 B8 08 00 00 00 48 6B C0 00 41 B9 03 00 00 00 4C 8B 44 24 40 BA 40 00 00 00 48 8B 4C 24 50 48 8B 0C 01 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 33 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 83 C0 03 48 89 44 24 40 48 8B 44 24 40 0F BE 00 83 F8 2D 75 17 8B 44 24 64 FF C0 89 44 24 64 48 8B 44 24 40 48 FF C0 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 69 C0 10 0E 00 00 89 44 24 48 48 8B 44 24 40 0F BE 00 83 F8 2B 74 1A 48 8B 44 24 40 0F BE 00 83 F8 30 7C 1C 48 8B 44 24 40 0F BE 00 83 F8 39 7F 0F 48 8B 44 24 40 48 FF C0 48 89 44 24 40 EB CA 48 8B 44 24 40 0F BE 00 83 F8 3A 0F 85 A8 00 00 00 48 8B 44 24 40 48 FF C0 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 6B C0 3C 8B 4C 24 48 03 C8 8B C1 89 44 24 48 48 8B 44 24 40 0F BE 00 83 F8 30 7C 1C 48 8B 44 24 40 0F BE 00 83 F8 39 7F 0F 48 8B 44 24 40 48 FF C0 48 89 44 24 40 EB D7 48 8B 44 24 40 0F BE 00 83 F8 3A 75 4C 48 8B 44 24 40 48 FF C0 48 89 44 24 40 48 8B 4C 24 40 E8 ?? ?? ?? ?? 8B 4C 24 48 03 C8 8B C1 89 44 24 48 48 8B 44 24 40 0F BE 00 83 F8 30 7C 1C 48 8B 44 24 40 0F BE 00 83 F8 39 7F 0F 48 8B 44 24 40 48 FF C0 48 89 44 24 40 EB D7 83 7C 24 64 00 74 0A 8B 44 24 48 F7 D8 89 44 24 48 48 8B 44 24 40 0F BE 00 85 C0 74 0A C7 44 24 4C 01 00 00 00 EB 08 C7 44 24 4C 00 00 00 00 83 7C 24 4C 00 74 56 B8 08 00 00 00 48 6B C0 01 41 B9 03 00 00 00 4C 8B 44 24 40 BA 40 00 00 00 48 8B 4C 24 50 48 8B 0C 01 E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 6A 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 15 B8 08 00 00 00 48 6B C0 01 48 8B 4C 24 50 48 8B 04 01 C6 00 00 8B 4C 24 48 E8 ?? ?? ?? ?? 8B 4C 24 4C E8 ?? ?? ?? ?? 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_97_12_0 {
	meta:
		name = "_tzset_nolock$fin$0"
		size = 27
		refs = "000f _unlock"
	strings:
		$1 = { 40 55 48 83 EC 40 48 8B EA B9 07 00 00 00 E8 ?? ?? ?? ?? 90 48 83 C4 40 5D C3 CC }
	condition:
		$1
}

rule file_97_13_0 {
	meta:
		name = "cvtdate"
		size = 1039
		refs = "007c _days 0097 _lpdays 02c9 dststart 031d dstend 035f _get_dstbias 0377 ??_C@_1EM@OKECDHDE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAt?$AAz@ 037e ??_C@_1BA@GOCKIDGO@?$AAc?$AAv?$AAt?$AAd?$AAa?$AAt?$AAe?$AA?$AA@ 0385 ??_C@_1CO@IMMOMMCB@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAd?$AAs?$AAt?$AAb?$AAi?$AAa?$AAs?$AA?$CI?$AA?$CG?$AAd?$AAs?$AAt?$AAb?$AAi?$AAa?$AAs?$AA?$CJ?$AA?$AA@ 038c _invoke_watson_if_error"
	strings:
		$1 = { 44 89 4C 24 20 44 89 44 24 18 89 54 24 10 89 4C 24 08 48 83 EC 68 C7 44 24 3C 00 00 00 00 83 7C 24 78 01 0F 85 FF 01 00 00 8B 84 24 80 00 00 00 99 83 E2 03 03 C2 83 E0 03 2B C2 85 C0 75 15 8B 84 24 80 00 00 00 99 B9 64 00 00 00 F7 F9 8B C2 85 C0 75 35 8B 84 24 80 00 00 00 05 6C 07 00 00 99 B9 90 01 00 00 F7 F9 8B C2 85 C0 74 1B 8B 84 24 88 00 00 00 FF C8 48 98 48 8D 0D ?? ?? ?? ?? 8B 04 81 89 44 24 40 EB 19 8B 84 24 88 00 00 00 FF C8 48 98 48 8D 0D ?? ?? ?? ?? 8B 04 81 89 44 24 40 8B 44 24 40 FF C0 89 44 24 30 8B 84 24 80 00 00 00 83 E8 46 69 C0 6D 01 00 00 8B 4C 24 30 03 C8 8B C1 89 44 24 50 8B 8C 24 80 00 00 00 FF C9 8B C1 99 83 E2 03 03 C2 C1 F8 02 89 44 24 48 8B 8C 24 80 00 00 00 FF C9 8B C1 99 B9 64 00 00 00 F7 F9 8B 4C 24 48 2B C8 8B C1 89 44 24 4C 8B 8C 24 80 00 00 00 81 C1 2B 01 00 00 8B C1 99 B9 90 01 00 00 F7 F9 8B 4C 24 4C 03 C8 8B C1 8B 4C 24 50 8D 44 01 F3 99 B9 07 00 00 00 F7 F9 8B C2 89 44 24 34 8B 84 24 98 00 00 00 39 44 24 34 7F 29 8B 44 24 34 8B 8C 24 98 00 00 00 2B C8 8B C1 8B 8C 24 90 00 00 00 FF C9 6B C9 07 03 4C 24 30 03 C8 8B C1 89 44 24 30 EB 23 8B 44 24 34 8B 8C 24 98 00 00 00 2B C8 8B C1 6B 8C 24 90 00 00 00 07 03 4C 24 30 03 C8 8B C1 89 44 24 30 83 BC 24 90 00 00 00 05 0F 85 88 00 00 00 8B 84 24 80 00 00 00 99 83 E2 03 03 C2 83 E0 03 2B C2 85 C0 75 15 8B 84 24 80 00 00 00 99 B9 64 00 00 00 F7 F9 8B C2 85 C0 75 32 8B 84 24 80 00 00 00 05 6C 07 00 00 99 B9 90 01 00 00 F7 F9 8B C2 85 C0 74 18 48 63 84 24 88 00 00 00 48 8D 0D ?? ?? ?? ?? 8B 04 81 89 44 24 44 EB 16 48 63 84 24 88 00 00 00 48 8D 0D ?? ?? ?? ?? 8B 04 81 89 44 24 44 8B 44 24 44 39 44 24 30 7E 0B 8B 44 24 30 83 E8 07 89 44 24 30 E9 94 00 00 00 8B 84 24 80 00 00 00 99 83 E2 03 03 C2 83 E0 03 2B C2 85 C0 75 15 8B 84 24 80 00 00 00 99 B9 64 00 00 00 F7 F9 8B C2 85 C0 75 35 8B 84 24 80 00 00 00 05 6C 07 00 00 99 B9 90 01 00 00 F7 F9 8B C2 85 C0 74 1B 8B 84 24 88 00 00 00 FF C8 48 98 48 8D 0D ?? ?? ?? ?? 8B 04 81 89 44 24 38 EB 19 8B 84 24 88 00 00 00 FF C8 48 98 48 8D 0D ?? ?? ?? ?? 8B 04 81 89 44 24 38 8B 44 24 38 89 44 24 30 8B 84 24 A0 00 00 00 8B 4C 24 30 03 C8 8B C1 89 44 24 30 83 7C 24 70 01 75 54 8B 44 24 30 89 05 ?? ?? ?? ?? 6B 84 24 A8 00 00 00 3C 8B 8C 24 B0 00 00 00 03 C8 8B C1 6B C0 3C 8B 8C 24 B8 00 00 00 03 C8 8B C1 69 C0 E8 03 00 00 8B 8C 24 C0 00 00 00 03 C8 8B C1 89 05 ?? ?? ?? ?? 8B 84 24 80 00 00 00 89 05 ?? ?? ?? ?? E9 F3 00 00 00 8B 44 24 30 89 05 ?? ?? ?? ?? 6B 84 24 A8 00 00 00 3C 8B 8C 24 B0 00 00 00 03 C8 8B C1 6B C0 3C 8B 8C 24 B8 00 00 00 03 C8 8B C1 69 C0 E8 03 00 00 8B 8C 24 C0 00 00 00 03 C8 8B C1 89 05 ?? ?? ?? ?? 48 8D 4C 24 3C E8 ?? ?? ?? ?? 48 C7 44 24 28 00 00 00 00 C7 44 24 20 F0 01 00 00 4C 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 69 44 24 3C E8 03 00 00 8B 0D ?? ?? ?? ?? 03 C8 8B C1 89 05 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 7D 21 8B 05 ?? ?? ?? ?? 05 00 5C 26 05 89 05 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? FF C8 89 05 ?? ?? ?? ?? EB 2B 81 3D ?? ?? ?? ?? 00 5C 26 05 7C 1F 8B 05 ?? ?? ?? ?? 2D 00 5C 26 05 89 05 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? FF C0 89 05 ?? ?? ?? ?? 8B 84 24 80 00 00 00 89 05 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "memmove_s"
		size = 571
		refs = "0053 ??_C@_1BI@GKKCBDMD@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 005f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0074 ??_C@_1FI@NAKKKGCB@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?2@ 007e _CrtDbgReportW 0092 _errno 00b5 ??_C@_1BE@NMKKBGPA@?$AAm?$AAe?$AAm?$AAm?$AAo?$AAv?$AAe?$AA_?$AAs?$AA?$AA@ 00c1 _invalid_parameter 00fb ??_C@_1BI@DCHLDCPP@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01a7 ??_C@_1CK@DDKKOLAN@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?$AA@ 0230 memmove"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 83 7C 24 78 00 75 07 33 C0 E9 0F 02 00 00 48 83 7C 24 60 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 36 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 36 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 67 01 00 00 48 83 7C 24 70 00 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 37 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 37 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 BF 00 00 00 48 8B 44 24 78 48 39 44 24 68 72 0A C7 44 24 40 01 00 00 00 EB 08 C7 44 24 40 00 00 00 00 8B 44 24 40 89 44 24 44 83 7C 24 44 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 38 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 44 00 75 3B E8 ?? ?? ?? ?? C7 00 22 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 38 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 22 00 00 00 EB 16 4C 8B 44 24 78 48 8B 54 24 70 48 8B 4C 24 60 E8 ?? ?? ?? ?? 33 C0 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_1353_1_0 {
	meta:
		name = "wmemmove_s"
		size = 571
		refs = "0053 ??_C@_1BI@GKKCBDMD@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 005f ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0074 ??_C@_1FK@OJAHDMIG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?2@ 007e _CrtDbgReportW 0092 _errno 00b5 ??_C@_1BG@PFKJPJJI@?$AAw?$AAm?$AAe?$AAm?$AAm?$AAo?$AAv?$AAe?$AA_?$AAs?$AA?$AA@ 00c1 _invalid_parameter 00fb ??_C@_1BI@DCHLDCPP@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01a7 ??_C@_1DA@PPKHDFMB@?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAW?$AAc?$AAh?$AAa?$AAr?$AA_?$AAt?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?$AA@ 0230 wmemmove"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 48 83 7C 24 78 00 75 07 33 C0 E9 0F 02 00 00 48 83 7C 24 60 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 36 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 36 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 67 01 00 00 48 83 7C 24 70 00 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 37 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 37 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 BF 00 00 00 48 8B 44 24 78 48 39 44 24 68 72 0A C7 44 24 40 01 00 00 00 EB 08 C7 44 24 40 00 00 00 00 8B 44 24 40 89 44 24 44 83 7C 24 44 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 38 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 44 00 75 3B E8 ?? ?? ?? ?? C7 00 22 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 38 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 22 00 00 00 EB 16 4C 8B 44 24 78 48 8B 54 24 70 48 8B 4C 24 60 E8 ?? ?? ?? ?? 33 C0 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_99_4_0 {
	meta:
		name = "_mbsicmp_l"
		size = 1702
		refs = "0027 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 005a ??_C@_1BG@MODEICJK@?$AAs?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0066 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 007b ??_C@_1FI@LEKNJNMN@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAb?$AAs?$AAt?$AAr?$AAi?$AAn@ 0085 _CrtDbgReportW 0099 _errno 00bc ??_C@_1BG@BMDHEPAJ@?$AA_?$AAm?$AAb?$AAs?$AAi?$AAc?$AAm?$AAp?$AA_?$AAl?$AA?$AA@ 00c8 _invalid_parameter 00e0 ??1_LocaleUpdate@@QEAA@XZ 011f ??_C@_1BG@GBJNMPFA@?$AAs?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01be ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 01ed _stricmp_l 031c __crtLCMapStringA"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC F8 00 00 00 48 8B 94 24 10 01 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 83 BC 24 00 01 00 00 00 74 0A C7 44 24 6C 01 00 00 00 EB 08 C7 44 24 6C 00 00 00 00 8B 44 24 6C 89 44 24 60 83 7C 24 60 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 39 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 60 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 39 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 B4 00 00 00 FF FF FF 7F 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 B4 00 00 00 E9 AE 05 00 00 48 83 BC 24 08 01 00 00 00 74 0A C7 44 24 68 01 00 00 00 EB 08 C7 44 24 68 00 00 00 00 8B 44 24 68 89 44 24 74 83 7C 24 74 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3A 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 74 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3A 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 A0 00 00 00 FF FF FF 7F 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 A0 00 00 00 E9 E9 04 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 40 08 83 78 08 00 75 45 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 4C 8B C0 48 8B 94 24 08 01 00 00 48 8B 8C 24 00 01 00 00 E8 ?? ?? ?? ?? 89 84 24 B8 00 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 B8 00 00 00 E9 8D 04 00 00 48 8B 84 24 00 01 00 00 0F B6 00 66 89 44 24 50 48 8B 84 24 00 01 00 00 48 FF C0 48 89 84 24 00 01 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 40 08 0F B6 4C 24 50 0F B6 44 08 19 83 E0 04 85 C0 0F 84 59 01 00 00 48 8B 84 24 00 01 00 00 0F B6 00 85 C0 75 0C 33 C0 66 89 44 24 50 E9 3C 01 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 40 08 48 89 84 24 C0 00 00 00 48 8B 8C 24 00 01 00 00 48 FF C9 48 89 8C 24 E8 00 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 40 08 48 89 84 24 D0 00 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? C7 44 24 40 01 00 00 00 48 8B 8C 24 C0 00 00 00 8B 49 04 89 4C 24 38 C7 44 24 30 02 00 00 00 48 8D 4C 24 58 48 89 4C 24 28 C7 44 24 20 02 00 00 00 48 8B 8C 24 E8 00 00 00 4C 8B C9 41 B8 00 02 00 00 48 8B 8C 24 D0 00 00 00 48 8B 91 20 02 00 00 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 5C 83 7C 24 5C 01 75 15 B8 01 00 00 00 48 6B C0 00 0F B6 44 04 58 66 89 44 24 50 EB 5E 83 7C 24 5C 02 75 28 B8 01 00 00 00 48 6B C0 00 0F B6 44 04 58 C1 E0 08 B9 01 00 00 00 48 6B C9 01 0F B6 4C 0C 58 03 C1 66 89 44 24 50 EB 2F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 84 24 AC 00 00 00 FF FF FF 7F 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 AC 00 00 00 E9 00 03 00 00 48 8B 84 24 00 01 00 00 48 FF C0 48 89 84 24 00 01 00 00 EB 5F 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 40 08 0F B7 4C 24 50 FF C1 48 63 C9 0F B6 44 08 18 83 E0 10 83 F8 10 75 24 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 40 08 0F B7 4C 24 50 0F B6 84 08 19 01 00 00 89 44 24 64 EB 09 0F B7 44 24 50 89 44 24 64 0F B7 44 24 64 66 89 44 24 50 48 8B 84 24 08 01 00 00 0F B6 00 66 89 44 24 54 48 8B 84 24 08 01 00 00 48 FF C0 48 89 84 24 08 01 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 40 08 0F B6 4C 24 54 0F B6 44 08 19 83 E0 04 85 C0 0F 84 59 01 00 00 48 8B 84 24 08 01 00 00 0F B6 00 85 C0 75 0C 33 C0 66 89 44 24 54 E9 3C 01 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 40 08 48 89 84 24 E0 00 00 00 48 8B 8C 24 08 01 00 00 48 FF C9 48 89 8C 24 C8 00 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 40 08 48 89 84 24 D8 00 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? C7 44 24 40 01 00 00 00 48 8B 8C 24 E0 00 00 00 8B 49 04 89 4C 24 38 C7 44 24 30 02 00 00 00 48 8D 4C 24 58 48 89 4C 24 28 C7 44 24 20 02 00 00 00 48 8B 8C 24 C8 00 00 00 4C 8B C9 41 B8 00 02 00 00 48 8B 8C 24 D8 00 00 00 48 8B 91 20 02 00 00 48 8B C8 E8 ?? ?? ?? ?? 89 44 24 5C 83 7C 24 5C 01 75 15 B8 01 00 00 00 48 6B C0 00 0F B6 44 04 58 66 89 44 24 54 EB 5E 83 7C 24 5C 02 75 28 B8 01 00 00 00 48 6B C0 00 0F B6 44 04 58 C1 E0 08 B9 01 00 00 00 48 6B C9 01 0F B6 4C 0C 58 03 C1 66 89 44 24 54 EB 2F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 84 24 A4 00 00 00 FF FF FF 7F 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 A4 00 00 00 E9 FF 00 00 00 48 8B 84 24 08 01 00 00 48 FF C0 48 89 84 24 08 01 00 00 EB 5F 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 40 08 0F B7 4C 24 54 FF C1 48 63 C9 0F B6 44 08 18 83 E0 10 83 F8 10 75 24 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 8B 40 08 0F B7 4C 24 54 0F B6 84 08 19 01 00 00 89 44 24 70 EB 09 0F B7 44 24 54 89 44 24 70 0F B7 44 24 70 66 89 44 24 54 0F B7 44 24 50 0F B7 4C 24 54 3B C1 74 41 0F B7 44 24 50 0F B7 4C 24 54 3B C1 7E 0A C7 44 24 78 01 00 00 00 EB 08 C7 44 24 78 FF FF FF FF 8B 44 24 78 89 84 24 A8 00 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 A8 00 00 00 EB 3C 0F B7 44 24 50 85 C0 75 21 C7 84 24 B0 00 00 00 00 00 00 00 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 B0 00 00 00 EB 12 E9 80 FB FF FF 48 8D 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 81 C4 F8 00 00 00 C3 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "_gmtime64"
		size = 71
		refs = "000a __getgmtimebuf 002a _gmtime64_s"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 75 04 33 C0 EB 23 48 8B 54 24 40 48 8B 4C 24 28 E8 ?? ?? ?? ?? 89 44 24 20 83 7C 24 20 00 74 04 33 C0 EB 05 48 8B 44 24 28 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_665_1_0 {
	meta:
		name = "_gmtime32"
		size = 71
		refs = "000a __getgmtimebuf 002a _gmtime32_s"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 75 04 33 C0 EB 23 48 8B 54 24 40 48 8B 4C 24 28 E8 ?? ?? ?? ?? 89 44 24 20 83 7C 24 20 00 74 04 33 C0 EB 05 48 8B 44 24 28 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_173_1_0 {
	meta:
		name = "_localtime32"
		size = 71
		refs = "000a __getgmtimebuf 002a _localtime32_s"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 75 04 33 C0 EB 23 48 8B 54 24 40 48 8B 4C 24 28 E8 ?? ?? ?? ?? 89 44 24 20 83 7C 24 20 00 74 04 33 C0 EB 05 48 8B 44 24 28 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_1356_1_0 {
	meta:
		name = "_localtime64"
		size = 71
		refs = "000a __getgmtimebuf 002a _localtime64_s"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 E8 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 75 04 33 C0 EB 23 48 8B 54 24 40 48 8B 4C 24 28 E8 ?? ?? ?? ?? 89 44 24 20 83 7C 24 20 00 74 04 33 C0 EB 05 48 8B 44 24 28 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_100_1_0 {
	meta:
		name = "_gmtime64_s"
		size = 1201
		refs = "0052 ??_C@_1CA@NJFECEIO@?$AA?$CI?$AA?5?$AAp?$AAt?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 005e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0073 ??_C@_1FC@NBJCLAE@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAg?$AAm@ 007d _CrtDbgReportW 0091 _errno 00b4 ??_C@_1BI@BFNFPMLP@?$AA_?$AAg?$AAm?$AAt?$AAi?$AAm?$AAe?$AA6?$AA4?$AA_?$AAs?$AA?$AA@ 00c0 _invalid_parameter 00e2 memset 0115 ??_C@_1CC@FPMHPAM@?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CJ?$AA?$AA@ 038e _lpdays 039c _days"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 78 C7 44 24 48 00 00 00 00 48 8B 84 24 80 00 00 00 48 89 44 24 40 48 83 BC 24 80 00 00 00 00 74 0A C7 44 24 50 01 00 00 00 EB 08 C7 44 24 50 00 00 00 00 8B 44 24 50 89 44 24 58 83 7C 24 58 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 36 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 58 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 36 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 DE 03 00 00 41 B8 24 00 00 00 BA FF 00 00 00 48 8B 8C 24 80 00 00 00 E8 ?? ?? ?? ?? 48 83 BC 24 88 00 00 00 00 74 0A C7 44 24 54 01 00 00 00 EB 08 C7 44 24 54 00 00 00 00 8B 44 24 54 89 44 24 4C 83 7C 24 4C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3A 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 4C 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3A 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 1B 03 00 00 48 8B 84 24 88 00 00 00 48 8B 00 48 89 44 24 38 48 81 7C 24 38 40 57 FF FF 7D 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 16 00 00 00 E9 EB 02 00 00 48 B8 CF 26 41 93 07 00 00 00 48 39 44 24 38 7E 15 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B8 16 00 00 00 E9 C5 02 00 00 48 8B 44 24 38 48 99 B9 80 33 E1 01 48 F7 F9 83 C0 46 89 44 24 30 8B 44 24 30 83 E8 46 48 98 48 69 C0 80 33 E1 01 48 8B 4C 24 38 48 2B C8 48 8B C1 48 89 44 24 38 8B 44 24 30 FF C8 99 83 E2 03 03 C2 C1 F8 02 89 44 24 60 8B 4C 24 30 FF C9 8B C1 99 B9 64 00 00 00 F7 F9 8B 4C 24 60 2B C8 8B C1 89 44 24 5C 8B 4C 24 30 81 C1 2B 01 00 00 8B C1 99 B9 90 01 00 00 F7 F9 8B 4C 24 5C 8D 44 01 EF 48 98 48 69 C0 80 51 01 00 48 8B 4C 24 38 48 2B C8 48 8B C1 48 89 44 24 38 48 83 7C 24 38 00 7D 72 48 8B 44 24 38 48 05 80 33 E1 01 48 89 44 24 38 8B 44 24 30 FF C8 89 44 24 30 8B 44 24 30 99 83 E2 03 03 C2 83 E0 03 2B C2 85 C0 75 12 8B 44 24 30 99 B9 64 00 00 00 F7 F9 8B C2 85 C0 75 17 8B 44 24 30 05 6C 07 00 00 99 B9 90 01 00 00 F7 F9 8B C2 85 C0 75 1A 48 8B 44 24 38 48 05 80 51 01 00 48 89 44 24 38 8B 44 24 48 FF C0 89 44 24 48 EB 46 8B 44 24 30 99 83 E2 03 03 C2 83 E0 03 2B C2 85 C0 75 12 8B 44 24 30 99 B9 64 00 00 00 F7 F9 8B C2 85 C0 75 17 8B 44 24 30 05 6C 07 00 00 99 B9 90 01 00 00 F7 F9 8B C2 85 C0 75 0A 8B 44 24 48 FF C0 89 44 24 48 48 8B 44 24 40 8B 4C 24 30 89 48 14 48 8B 44 24 38 48 99 B9 80 51 01 00 48 F7 F9 48 8B 4C 24 40 89 41 1C 48 8B 44 24 40 48 63 40 1C 48 69 C0 80 51 01 00 48 8B 4C 24 38 48 2B C8 48 8B C1 48 89 44 24 38 83 7C 24 48 00 74 0E 48 8D 05 ?? ?? ?? ?? 48 89 44 24 68 EB 0C 48 8D 05 ?? ?? ?? ?? 48 89 44 24 68 C7 44 24 30 01 00 00 00 EB 0A 8B 44 24 30 FF C0 89 44 24 30 48 63 44 24 30 48 8B 4C 24 68 48 8B 54 24 40 8B 52 1C 39 14 81 7D 02 EB DD 8B 44 24 30 FF C8 89 44 24 30 48 8B 44 24 40 8B 4C 24 30 89 48 10 48 63 44 24 30 48 8B 4C 24 40 48 8B 54 24 68 8B 04 82 8B 49 1C 2B C8 8B C1 48 8B 4C 24 40 89 41 0C 48 8B 84 24 88 00 00 00 48 8B 00 48 99 B9 80 51 01 00 48 F7 F9 83 C0 04 99 B9 07 00 00 00 F7 F9 8B C2 48 8B 4C 24 40 89 41 18 48 8B 44 24 38 48 99 B9 10 0E 00 00 48 F7 F9 48 8B 4C 24 40 89 41 08 48 8B 44 24 40 48 63 40 08 48 69 C0 10 0E 00 00 48 8B 4C 24 38 48 2B C8 48 8B C1 48 89 44 24 38 48 8B 44 24 38 48 99 B9 3C 00 00 00 48 F7 F9 48 8B 4C 24 40 89 41 04 48 8B 44 24 40 6B 40 04 3C 48 98 48 8B 4C 24 38 48 2B C8 48 8B C1 48 8B 4C 24 40 89 01 48 8B 44 24 40 C7 40 20 00 00 00 00 33 C0 48 83 C4 78 C3 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "_heap_alloc_base"
		size = 98
		refs = "000c _crtheap 0014 _FF_MSGBANNER 001e _NMSG_WRITE 0028 __crtExitProcess 0059 __imp_HeapAlloc"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 83 3D ?? ?? ?? ?? 00 75 19 E8 ?? ?? ?? ?? B9 1E 00 00 00 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? 48 83 7C 24 40 00 74 0C 48 8B 44 24 40 48 89 44 24 20 EB 09 48 C7 44 24 20 01 00 00 00 4C 8B 44 24 20 33 D2 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_101_1_0 {
	meta:
		name = "_malloc_base"
		size = 147
		refs = "0020 _heap_alloc_base 0035 _newmode 003d _errno 004f _callnewh"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 38 48 C7 44 24 20 00 00 00 00 48 83 7C 24 40 E0 77 43 48 8B 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 02 EB 28 83 3D ?? ?? ?? ?? 00 75 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 12 48 8B 4C 24 40 E8 ?? ?? ?? ?? 85 C0 75 02 EB 02 EB BF EB 19 48 8B 4C 24 40 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 18 48 83 7C 24 20 00 75 0B E8 ?? ?? ?? ?? C7 00 0C 00 00 00 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "__copy_path_to_wide_string"
		size = 630
		refs = "0042 ??_C@_1BK@DJNILIMN@?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0063 ??_C@_1FG@MHCBBJEK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAa?$AAr?$AAt?$AAu?$AAp@ 006d _CrtDbgReportW 0081 _errno 00a4 ??_C@_1DG@KANBJOCK@?$AA_?$AA_?$AAc?$AAo?$AAp?$AAy?$AA_?$AAp?$AAa?$AAt?$AAh?$AA_?$AAt?$AAo?$AA_?$AAw?$AAi?$AAd?$AAe?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?$AA@ 00b0 _invalid_parameter 00ea ??_C@_1CA@BGODLPHH@?$AAo?$AAu?$AAt?$AAP?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0167 __crtIsPackagedApp 0171 __imp_AreFileApisANSI 01b1 __imp_MultiByteToWideChar 01c2 __imp_GetLastError 01c9 _dosmaperr 01e5 ??_C@_0CL@LMMOJFEN@f?3?2dd?2vctools?2crt?2crtw32?2startup@ 01f2 _malloc_dbg 0258 _free_dbg"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 C7 44 24 34 00 00 00 00 48 83 7C 24 60 00 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 4A 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 4A 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 B3 01 00 00 48 83 7C 24 68 00 74 0A C7 44 24 40 01 00 00 00 EB 08 C7 44 24 40 00 00 00 00 8B 44 24 40 89 44 24 44 83 7C 24 44 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 4B 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 44 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 4B 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 0B 01 00 00 E8 ?? ?? ?? ?? 85 C0 75 12 FF 15 ?? ?? ?? ?? 85 C0 75 08 C7 44 24 34 01 00 00 00 48 8B 44 24 68 48 C7 00 00 00 00 00 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 FF FF FF FF 4C 8B 44 24 60 33 D2 8B 4C 24 34 FF 15 ?? ?? ?? ?? 89 44 24 30 83 7C 24 30 00 75 14 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 33 C0 E9 9D 00 00 00 48 63 44 24 30 48 D1 E0 41 B9 5C 04 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 68 48 89 01 48 8B 44 24 68 48 83 38 00 75 04 33 C0 EB 64 8B 44 24 30 89 44 24 28 48 8B 44 24 68 48 8B 00 48 89 44 24 20 41 B9 FF FF FF FF 4C 8B 44 24 60 33 D2 8B 4C 24 34 FF 15 ?? ?? ?? ?? 85 C0 75 2F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 44 24 68 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 68 48 C7 00 00 00 00 00 33 C0 EB 05 B8 01 00 00 00 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_102_1_0 {
	meta:
		name = "__copy_to_char"
		size = 663
		refs = "0042 ??_C@_1CC@NLGECIOD@?$AAi?$AAn?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 004e ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0063 ??_C@_1FG@MHCBBJEK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAa?$AAr?$AAt?$AAu?$AAp@ 006d _CrtDbgReportW 0081 _errno 00a4 ??_C@_1BO@PNPLHAEP@?$AA_?$AA_?$AAc?$AAo?$AAp?$AAy?$AA_?$AAt?$AAo?$AA_?$AAc?$AAh?$AAa?$AAr?$AA?$AA@ 00b0 _invalid_parameter 00ea ??_C@_1CE@HIPDKGHC@?$AAo?$AAu?$AAt?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0167 __crtIsPackagedApp 0171 __imp_AreFileApisANSI 01c3 __imp_WideCharToMultiByte 01d4 __imp_GetLastError 01db _dosmaperr 01f4 ??_C@_0CL@LMMOJFEN@f?3?2dd?2vctools?2crt?2crtw32?2startup@ 0201 _malloc_dbg 0279 _free_dbg"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 68 C7 44 24 44 00 00 00 00 48 83 7C 24 70 00 74 0A C7 44 24 48 01 00 00 00 EB 08 C7 44 24 48 00 00 00 00 8B 44 24 48 89 44 24 4C 83 7C 24 4C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 83 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 4C 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 83 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 D4 01 00 00 48 83 7C 24 78 00 74 0A C7 44 24 50 01 00 00 00 EB 08 C7 44 24 50 00 00 00 00 8B 44 24 50 89 44 24 54 83 7C 24 54 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 84 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 54 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 84 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 2C 01 00 00 E8 ?? ?? ?? ?? 85 C0 75 12 FF 15 ?? ?? ?? ?? 85 C0 75 08 C7 44 24 44 01 00 00 00 48 8B 44 24 78 48 C7 00 00 00 00 00 48 C7 44 24 38 00 00 00 00 48 C7 44 24 30 00 00 00 00 C7 44 24 28 00 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 FF FF FF FF 4C 8B 44 24 70 33 D2 8B 4C 24 44 FF 15 ?? ?? ?? ?? 89 44 24 40 83 7C 24 40 00 75 14 FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 33 C0 E9 AC 00 00 00 48 63 44 24 40 41 B9 95 04 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24 78 48 89 01 48 8B 44 24 78 48 83 38 00 75 04 33 C0 EB 76 48 C7 44 24 38 00 00 00 00 48 C7 44 24 30 00 00 00 00 8B 44 24 40 89 44 24 28 48 8B 44 24 78 48 8B 00 48 89 44 24 20 41 B9 FF FF FF FF 4C 8B 44 24 70 33 D2 8B 4C 24 44 FF 15 ?? ?? ?? ?? 85 C0 75 2F FF 15 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 44 24 78 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 78 48 C7 00 00 00 00 00 33 C0 EB 05 B8 01 00 00 00 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_102_2_0 {
	meta:
		name = "__crtCorExitProcess"
		size = 76
		refs = "0010 ??_C@_1BI@BGOHAHKC@?$AAm?$AAs?$AAc?$AAo?$AAr?$AAe?$AAe?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0018 __imp_GetModuleHandleExW 0023 ??_C@_0P@MIGLKIOC@CorExitProcess?$AA@ 002e __imp_GetProcAddress"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 38 4C 8D 44 24 28 48 8D 15 ?? ?? ?? ?? 33 C9 FF 15 ?? ?? ?? ?? 85 C0 74 27 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 28 FF 15 ?? ?? ?? ?? 48 89 44 24 20 48 83 7C 24 20 00 74 08 8B 4C 24 40 FF 54 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_102_3_0 {
	meta:
		name = "__crtExitProcess"
		size = 32
		refs = "000d __crtCorExitProcess 0017 __imp_ExitProcess"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 8B 4C 24 30 E8 ?? ?? ?? ?? 8B 4C 24 30 FF 15 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_102_4_0 {
	meta:
		name = "__freeCrtMemory"
		size = 551
		refs = "0007 __onexitbegin 000d __imp_DecodePointer 0019 _wenviron 0053 _free_dbg 0078 _environ 00dc __wargv 00ed __argv 0136 __imp_EncodePointer 014d _stdbuf 01de __ptmbcinfo 01f6 __initialmbcinfo"
	strings:
		$1 = { 48 83 EC 38 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 44 24 28 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 EB 0E 48 8B 44 24 20 48 83 C0 08 48 89 44 24 20 48 83 7C 24 20 00 74 1F 48 8B 44 24 20 48 83 38 00 74 14 BA 02 00 00 00 48 8B 44 24 20 48 8B 08 E8 ?? ?? ?? ?? EB CB BA 02 00 00 00 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 8B 05 ?? ?? ?? ?? 48 89 44 24 20 EB 0E 48 8B 44 24 20 48 83 C0 08 48 89 44 24 20 48 83 7C 24 20 00 74 1F 48 8B 44 24 20 48 83 38 00 74 14 BA 02 00 00 00 48 8B 44 24 20 48 8B 08 E8 ?? ?? ?? ?? EB CB BA 02 00 00 00 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 BA 02 00 00 00 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 C7 05 ?? ?? ?? ?? 00 00 00 00 48 83 7C 24 28 FF 74 19 48 83 3D ?? ?? ?? ?? 00 74 0F BA 02 00 00 00 48 8B 4C 24 28 E8 ?? ?? ?? ?? 48 C7 C1 FF FF FF FF FF 15 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? B8 08 00 00 00 48 6B C0 00 48 8D 0D ?? ?? ?? ?? 48 83 3C 01 00 74 36 B8 08 00 00 00 48 6B C0 00 48 8D 0D ?? ?? ?? ?? BA 02 00 00 00 48 8B 0C 01 E8 ?? ?? ?? ?? B8 08 00 00 00 48 6B C0 00 48 8D 0D ?? ?? ?? ?? 48 C7 04 01 00 00 00 00 B8 08 00 00 00 48 6B C0 01 48 8D 0D ?? ?? ?? ?? 48 83 3C 01 00 74 36 B8 08 00 00 00 48 6B C0 01 48 8D 0D ?? ?? ?? ?? BA 02 00 00 00 48 8B 0C 01 E8 ?? ?? ?? ?? B8 08 00 00 00 48 6B C0 01 48 8D 0D ?? ?? ?? ?? 48 C7 04 01 00 00 00 00 48 8B 05 ?? ?? ?? ?? B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 85 C0 75 2F 48 8D 05 ?? ?? ?? ?? 48 39 05 ?? ?? ?? ?? 74 1F BA 02 00 00 00 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 89 05 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_102_5_0 {
	meta:
		name = "_amsg_exit"
		size = 37
		refs = "0009 _FF_MSGBANNER 0012 _NMSG_WRITE 001c _exit"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 E8 ?? ?? ?? ?? 8B 4C 24 30 E8 ?? ?? ?? ?? B9 FF 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_102_6_0 {
	meta:
		name = "_c_exit"
		size = 27
		refs = "0012 doexit"
	strings:
		$1 = { 48 83 EC 28 41 B8 01 00 00 00 BA 01 00 00 00 33 C9 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_102_7_0 {
	meta:
		name = "_cexit"
		size = 24
		refs = "000f doexit"
	strings:
		$1 = { 48 83 EC 28 41 B8 01 00 00 00 33 D2 33 C9 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_102_8_0 {
	meta:
		name = "_cinit"
		size = 165
		refs = "000b _FPinit 001a _IsNonwritableInCurrentImage 002d _initp_misc_cfltcvt_tab 0034 __xi_z 003b __xi_a 0040 _initterm_e 0058 _RTC_Terminate 005d atexit 0064 __xc_z 006b __xc_a 0070 _initterm 0077 __dyn_tls_init_callback"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 38 48 83 3D ?? ?? ?? ?? 00 74 1A 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A 8B 4C 24 40 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 44 24 20 83 7C 24 20 00 74 06 8B 44 24 20 EB 4B 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 3D ?? ?? ?? ?? 00 74 20 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 10 45 33 C0 BA 02 00 00 00 33 C9 FF 15 ?? ?? ?? ?? 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_102_9_0 {
	meta:
		name = "_exit"
		size = 30
		refs = "0015 doexit"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 45 33 C0 BA 01 00 00 00 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_102_10_0 {
	meta:
		name = "_exit_app"
		size = 21
		refs = "000c doexit"
	strings:
		$1 = { 48 83 EC 28 45 33 C0 33 D2 33 C9 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_102_11_0 {
	meta:
		name = "_get_pgmptr"
		size = 366
		refs = "0035 ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0041 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0056 ??_C@_1FG@MHCBBJEK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAa?$AAr?$AAt?$AAu?$AAp@ 0060 _CrtDbgReportW 0074 _errno 0097 ??_C@_1BI@COAAPHJK@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?$AA@ 00a3 _invalid_parameter 00b4 _pgmptr 00df ??_C@_1CA@BBNAFCKO@?$AA_?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 50 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 25 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 25 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 B8 00 00 00 48 83 3D ?? ?? ?? ?? 00 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 29 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 29 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 EB 11 48 8B 44 24 50 48 8B 0D ?? ?? ?? ?? 48 89 08 33 C0 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_102_12_0 {
	meta:
		name = "_get_wpgmptr"
		size = 366
		refs = "0035 ??_C@_1BO@LKEBEKJP@?$AAp?$AAV?$AAa?$AAl?$AAu?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0041 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 0056 ??_C@_1FG@MHCBBJEK@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAa?$AAr?$AAt?$AAu?$AAp@ 0060 _CrtDbgReportW 0074 _errno 0097 ??_C@_1BK@PNLDCCDP@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAw?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?$AA@ 00a3 _invalid_parameter 00b4 _wpgmptr 00df ??_C@_1CC@CDIPMFPD@?$AA_?$AAw?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 83 7C 24 50 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 07 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 07 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 E9 B8 00 00 00 48 83 3D ?? ?? ?? ?? 00 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 0B 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 0B 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 16 00 00 00 EB 11 48 8B 44 24 50 48 8B 0D ?? ?? ?? ?? 48 89 08 33 C0 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_102_13_0 {
	meta:
		name = "_init_pointers"
		size = 87
		refs = "0008 __imp_EncodePointer 0017 _initp_heap_handler 0021 _initp_misc_invarg 002b _initp_misc_purevirt 0035 _initp_misc_winsig 003f _initp_eh_hooks 0049 _initp_misc_rand_s 004e __crtLoadWinApiPointers"
	strings:
		$1 = { 48 83 EC 38 33 C9 FF 15 ?? ?? ?? ?? 48 89 44 24 20 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 8B 4C 24 20 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_102_14_0 {
	meta:
		name = "_initterm"
		size = 65
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 8B 44 24 38 48 39 44 24 30 73 22 48 8B 44 24 30 48 83 38 00 74 07 48 8B 44 24 30 FF 10 48 8B 44 24 30 48 83 C0 08 48 89 44 24 30 EB D2 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_102_15_0 {
	meta:
		name = "_initterm_e"
		size = 88
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 48 8B 44 24 48 48 39 44 24 40 73 2D 83 7C 24 20 00 75 26 48 8B 44 24 40 48 83 38 00 74 0B 48 8B 44 24 40 FF 10 89 44 24 20 48 8B 44 24 40 48 83 C0 08 48 89 44 24 40 EB C7 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_102_16_0 {
	meta:
		name = "_lockexit"
		size = 19
		refs = "000a _lock"
	strings:
		$1 = { 48 83 EC 28 B9 08 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_885_2_0 {
	meta:
		name = "__report_rangecheckfailure"
		size = 19
		refs = "000a __report_securityfailure"
	strings:
		$1 = { 48 83 EC 28 B9 08 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_102_17_0 {
	meta:
		name = "_unlockexit"
		size = 19
		refs = "000a _unlock"
	strings:
		$1 = { 48 83 EC 28 B9 08 00 00 00 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_102_18_0 {
	meta:
		name = "doexit"
		size = 516
		refs = "0012 _lockexit 0019 _C_Exit_Done 0026 _C_Termination_Done 0038 _exitflag 004a __onexitbegin 0050 __imp_DecodePointer 0068 __onexitend 00cf __imp_EncodePointer 0183 __xp_z 018a __xp_a 018f _initterm 0196 __xt_z 019d __xt_a 01b6 _CrtSetDbgFlag 01c2 __freeCrtMemory 01c7 _CrtDumpMemoryLeaks 01d7 _unlockexit 01fb __crtExitProcess"
	strings:
		$1 = { 44 89 44 24 18 89 54 24 10 89 4C 24 08 48 83 EC 68 E8 ?? ?? ?? ?? 90 83 3D ?? ?? ?? ?? 01 0F 84 A8 01 00 00 C7 05 ?? ?? ?? ?? 01 00 00 00 0F B6 84 24 80 00 00 00 88 05 ?? ?? ?? ?? 83 7C 24 78 00 0F 85 4C 01 00 00 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 44 24 28 48 83 7C 24 28 00 0F 84 1B 01 00 00 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 44 24 20 48 C7 44 24 50 00 00 00 00 48 8B 44 24 28 48 89 44 24 38 48 8B 44 24 20 48 89 44 24 48 33 C0 83 F8 01 0F 84 E1 00 00 00 48 C7 44 24 30 00 00 00 00 48 C7 44 24 40 00 00 00 00 48 8B 44 24 20 48 83 E8 08 48 89 44 24 20 48 8B 44 24 28 48 39 44 24 20 72 14 33 C9 FF 15 ?? ?? ?? ?? 48 8B 4C 24 20 48 39 01 75 02 EB D2 48 8B 44 24 28 48 39 44 24 20 73 05 E9 90 00 00 00 48 8B 44 24 20 48 8B 08 FF 15 ?? ?? ?? ?? 48 89 44 24 50 33 C9 FF 15 ?? ?? ?? ?? 48 8B 4C 24 20 48 89 01 FF 54 24 50 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 44 24 30 48 8B 0D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 89 44 24 40 48 8B 44 24 30 48 39 44 24 38 75 0C 48 8B 44 24 40 48 39 44 24 48 74 28 48 8B 44 24 30 48 89 44 24 38 48 8B 44 24 38 48 89 44 24 28 48 8B 44 24 40 48 89 44 24 48 48 8B 44 24 48 48 89 44 24 20 E9 14 FF FF FF 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 BC 24 80 00 00 00 00 75 1C B9 FF FF FF FF E8 ?? ?? ?? ?? 83 E0 20 85 C0 74 0B E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 83 BC 24 80 00 00 00 00 74 05 E8 ?? ?? ?? ?? 83 BC 24 80 00 00 00 00 74 02 EB 18 C7 05 ?? ?? ?? ?? 01 00 00 00 E8 ?? ?? ?? ?? 8B 4C 24 70 E8 ?? ?? ?? ?? 48 83 C4 68 C3 }
	condition:
		$1
}

rule file_102_19_0 {
	meta:
		name = "doexit$fin$0"
		size = 31
		refs = "0013 _unlockexit"
	strings:
		$1 = { 40 55 48 83 EC 20 48 8B EA 83 BD 80 00 00 00 00 74 06 E8 ?? ?? ?? ?? 90 48 83 C4 20 5D C3 CC }
	condition:
		$1
}

rule file_102_20_0 {
	meta:
		name = "exit"
		size = 27
		refs = "0012 doexit"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 28 45 33 C0 33 D2 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "__common_dpow_cout_rare"
		size = 2896
		refs = "01a0 _vmldPowHATab"
	strings:
		$1 = { 53 56 57 41 54 41 55 41 56 41 57 55 48 81 EC C8 00 00 00 33 C0 4C 8B 31 4D 8B EE 48 8B 1A 4D 8B E6 F2 0F 10 12 48 8B D3 48 89 5C 24 68 4D 8B CE 48 C1 EB 38 49 C1 ED 30 48 C1 EA 30 49 C1 EC 38 41 81 E5 F0 7F 00 00 49 C1 E9 20 81 E2 F0 7F 00 00 41 81 E4 80 00 00 00 80 E3 80 41 C1 ED 04 C1 EA 04 41 C1 EC 07 C0 EB 07 44 0F 29 BC 24 80 00 00 00 44 0F 29 74 24 70 44 0F 29 A4 24 90 00 00 00 44 0F 29 8C 24 A0 00 00 00 0F 29 BC 24 B0 00 00 00 F2 0F 10 09 41 8B CE 41 F7 C1 FF FF 0F 00 75 0F 85 C9 75 0B 41 BA 01 00 00 00 45 8B DA EB 09 45 33 D2 41 BB 01 00 00 00 8B 4C 24 6C 8B 7C 24 68 81 E1 FF FF 0F 00 75 09 85 FF 75 05 45 8B CB EB 03 45 33 C9 8B F2 33 ED 81 FA FF 07 00 00 41 0F 45 EB C1 E6 14 0B F1 8B CF 0B CE 74 6A 81 FA FF 03 00 00 8D 8A 01 FC FF FF 7C 18 85 ED 74 14 83 F9 14 7F 2A 44 8B FE 41 D3 E7 41 C1 E7 0C 44 0B FF 74 04 33 F6 EB 45 8D 8A 0C FC FF FF D3 E6 F7 D6 81 E6 00 00 00 80 C1 EE 1F FF C6 EB 2E 83 F9 35 7D 24 8D 8A 0C FC FF FF D3 E7 F7 C7 FF FF FF 7F 74 04 33 F6 EB 15 F7 D7 81 E7 00 00 00 80 C1 EF 1F 8D 77 01 EB 05 BE 02 00 00 00 45 85 E4 75 0D 41 81 FD FF 03 00 00 0F 84 CB 09 00 00 85 D2 75 09 45 85 C9 0F 85 DC 03 00 00 33 FF 41 81 FD FF 07 00 00 41 0F 45 FB 44 0B D7 0F 84 BD 03 00 00 44 0B CD 0F 84 B4 03 00 00 F2 0F 10 05 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? 66 0F 2E C8 7A 06 0F 84 41 09 00 00 66 0F 2E 0D ?? ?? ?? ?? 7A 06 0F 84 0D 09 00 00 85 FF 0F 84 2E 03 00 00 85 ED 0F 84 26 03 00 00 66 0F 2F C8 77 08 85 F6 0F 84 EF 02 00 00 41 23 F4 48 8D 0D ?? ?? ?? ?? 4C 89 74 24 30 49 C1 EE 38 41 83 E6 7F F2 0F 10 84 F1 A8 1A 00 00 33 C9 44 88 74 24 37 45 85 ED 75 1B F2 0F 10 4C 24 30 B9 38 FF FF FF F2 0F 59 0D ?? ?? ?? ?? F2 0F 11 4C 24 30 EB 06 F2 0F 10 4C 24 30 0F B7 6C 24 36 4C 8D 0D ?? ?? ?? ?? 81 E5 F0 7F 00 00 4D 8B D1 C1 ED 04 4D 8B E9 8B 7C 24 34 4D 8B F9 C1 E5 14 81 E7 FF FF 0F 00 F2 0F 11 4C 24 40 0B EF 0F B7 74 24 46 81 C5 00 40 18 C0 81 E6 0F 80 FF FF 4D 8B E1 81 CE F0 3F FF FF 49 8B F9 66 89 74 24 46 49 8B F1 C1 FD 14 03 E9 8B 4C 24 44 81 E1 00 C0 0F 00 81 C1 00 40 00 00 C1 E9 0F F2 0F 10 54 24 40 0F 28 DA F2 0F 2A FD F2 41 0F 10 2C C9 03 C9 44 0F 28 E5 49 8B E9 F2 44 0F 59 E2 F2 44 0F 11 64 24 48 44 8B 5C 24 4C 41 81 E3 00 FC 00 00 41 81 C3 00 04 00 00 41 C1 EB 0B F2 43 0F 10 8C DA 18 03 00 00 45 03 DB F2 44 0F 59 E1 F2 41 0F 58 BC CF 08 01 00 00 F2 0F 59 E9 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 D9 F2 44 0F 11 64 24 50 44 8B 74 24 54 41 81 E6 F0 0F 00 00 F2 0F 11 5C 24 58 41 83 C6 10 F2 0F 10 64 24 58 41 C1 EE 05 F2 0F 5C 64 24 40 F2 0F 11 64 24 60 F2 0F 10 5C 24 58 F2 47 0F 10 BC F5 30 06 00 00 45 03 F6 F2 45 0F 59 E7 F2 41 0F 59 EF F2 42 0F 58 BC DD 20 04 00 00 F2 44 0F 10 7C 24 60 45 0F 28 F4 F2 41 0F 5C DF F2 44 0F 5C 35 ?? ?? ?? ?? F2 43 0F 58 BC F7 38 0A 00 00 F2 0F 11 5C 24 58 F2 0F 10 64 24 58 F2 47 0F 10 8C DC 28 04 00 00 F2 0F 5C D4 F2 46 0F 58 8C F6 40 0A 00 00 F2 0F 11 54 24 60 0F 28 D5 F2 0F 59 D1 F2 44 0F 58 8C CF 10 01 00 00 F2 0F 10 5C 24 58 F2 0F 10 64 24 60 F2 0F 11 54 24 58 F2 44 0F 10 7C 24 58 F2 44 0F 5C FD F2 44 0F 11 7C 24 60 F2 44 0F 10 7C 24 58 F2 0F 10 54 24 60 F2 44 0F 5C FA F2 44 0F 11 7C 24 58 F2 0F 10 54 24 58 F2 0F 5C EA 0F 28 D3 F2 0F 11 6C 24 60 F2 0F 10 6C 24 58 F2 0F 59 D5 F2 0F 59 EC F2 41 0F 5C D4 44 0F 28 E7 F2 0F 58 D5 F2 45 0F 58 E6 F2 44 0F 10 7C 24 60 F2 41 0F 59 DF F2 41 0F 59 E7 F2 0F 58 D3 F2 44 0F 11 64 24 58 F2 0F 58 D4 F2 0F 10 5C 24 58 F2 0F 5C FB F2 41 0F 58 FE F2 0F 11 7C 24 60 F2 0F 10 64 24 58 F2 0F 11 64 24 38 0F B7 4C 24 3E 81 E1 F0 7F 00 00 C1 E9 04 03 D1 F2 0F 10 5C 24 60 81 FA 09 08 00 00 0F 8D 0C 06 00 00 81 FA C0 07 00 00 0F 8F 30 01 00 00 48 8B 15 ?? ?? ?? ?? 48 89 54 24 58 F2 0F 10 4C 24 58 F2 0F 58 0D ?? ?? ?? ?? F2 0F 11 4C 24 58 F2 0F 10 54 24 58 F2 0F 59 C2 E9 BF 00 00 00 48 89 4C 24 58 41 8B C3 F2 0F 10 4C 24 58 F2 0F 10 44 24 58 F2 0F 5E C8 F2 0F 11 4C 24 58 F2 0F 10 44 24 58 E9 96 00 00 00 41 81 FD FF 03 00 00 7D 11 84 DB 0F 84 85 00 00 00 0F 28 C2 F2 0F 59 C2 EB 7C 84 DB 74 15 41 23 F4 48 8D 15 ?? ?? ?? ?? F2 0F 59 84 F2 A8 1A 00 00 EB 63 F2 0F 59 C9 41 23 F4 F2 0F 59 D1 48 8D 15 ?? ?? ?? ?? 0F 28 C2 F2 0F 59 84 F2 A8 1A 00 00 EB 43 0F 28 C1 F2 0F 58 C2 EB 3A 48 8B 15 ?? ?? ?? ?? F2 0F 58 CA F2 0F 11 4C 24 58 48 89 54 24 60 8A 4C 24 5F 8A 5C 24 67 80 E1 80 80 E3 7F 0A D9 88 5C 24 67 F2 0F 10 44 24 60 F2 0F 10 4C 24 60 F2 0F 59 C1 0F 28 BC 24 B0 00 00 00 44 0F 28 8C 24 A0 00 00 00 44 0F 28 A4 24 90 00 00 00 44 0F 28 74 24 70 44 0F 28 BC 24 80 00 00 00 F2 41 0F 11 00 48 81 C4 C8 00 00 00 5D 41 5F 41 5E 41 5D 41 5C 5F 5E 5B C3 F2 44 0F 10 25 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? F2 44 0F 10 7C 24 38 48 8B D9 F2 44 0F 58 F2 F2 0F 58 D3 F2 45 0F 59 E6 F2 44 0F 58 CA F2 44 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 E6 41 0F 28 F9 F2 44 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 E6 F2 44 0F 58 25 ?? ?? ?? ?? F2 45 0F 59 E6 F2 41 0F 58 E4 F2 0F 11 64 24 58 F2 44 0F 10 74 24 58 F2 45 0F 5C FE F2 45 0F 58 FC F2 44 0F 11 7C 24 60 F2 0F 10 5C 24 58 F2 0F 10 64 24 60 F2 0F 58 FB F2 0F 11 7C 24 58 F2 0F 10 54 24 58 F2 0F 5C DA F2 41 0F 58 D9 44 0F 28 C9 F2 0F 11 5C 24 60 F2 44 0F 10 64 24 58 F2 45 0F 59 CC F2 0F 10 7C 24 60 F2 44 0F 11 4C 24 58 F2 0F 58 FC F2 0F 10 54 24 58 F2 0F 59 7C 24 68 F2 41 0F 5C D4 F2 0F 11 54 24 60 F2 0F 10 64 24 58 F2 0F 10 5C 24 60 F2 0F 5C E3 F2 0F 11 64 24 58 F2 0F 10 6C 24 58 F2 44 0F 5C E5 F2 44 0F 11 64 24 60 F2 44 0F 10 64 24 68 45 0F 28 F4 F2 44 0F 59 35 ?? ?? ?? ?? F2 0F 10 64 24 58 F2 0F 10 6C 24 60 F2 44 0F 11 74 24 58 F2 44 0F 10 7C 24 58 F2 44 0F 5C 7C 24 68 F2 44 0F 11 7C 24 60 F2 0F 10 54 24 58 F2 44 0F 10 4C 24 60 F2 41 0F 5C D1 F2 0F 11 54 24 58 F2 0F 10 5C 24 58 F2 44 0F 5C E3 F2 44 0F 11 64 24 60 F2 44 0F 10 74 24 58 F2 44 0F 10 4C 24 60 41 0F 28 D6 41 0F 28 D9 F2 0F 59 DD F2 44 0F 59 F5 F2 0F 59 D4 F2 41 0F 59 E1 F2 41 0F 58 DE F2 0F 58 DC F2 0F 10 25 ?? ?? ?? ?? F2 0F 58 E2 F2 0F 58 FB F2 0F 11 64 24 58 F2 0F 10 6C 24 58 8B 54 24 58 8B F2 83 E2 7F F2 0F 5C 2D ?? ?? ?? ?? F2 0F 11 6C 24 20 03 D2 F2 44 0F 10 7C 24 20 F2 41 0F 5C D7 F2 0F 11 54 24 28 F2 0F 10 54 24 28 F2 0F 10 A4 D1 48 12 00 00 F2 0F 58 FA F2 0F 10 15 ?? ?? ?? ?? F2 0F 59 D7 C1 FE 07 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D7 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D7 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D7 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D7 F2 0F 59 D4 F2 0F 58 94 D3 50 12 00 00 0F 28 DA F2 0F 58 DC F2 0F 11 5C 24 30 0F B7 54 24 36 8B EA 81 E5 F0 7F 00 00 C1 ED 04 8D 8C 2E 01 FC FF FF 81 F9 00 04 00 00 0F 8D 23 02 00 00 81 F9 02 FC FF FF 7C 31 81 C1 FF 03 00 00 81 E2 0F 80 FF FF 81 E1 FF 07 00 00 C1 E1 04 0B D1 66 89 54 24 36 F2 0F 10 4C 24 30 F2 0F 59 C1 F2 0F 11 44 24 30 E9 0F FD FF FF 81 F9 F8 FB FF FF 0F 8C 22 01 00 00 F2 0F 11 5C 24 58 81 C6 C8 00 00 00 F2 0F 10 5C 24 58 81 C6 FF 03 00 00 48 8B 15 ?? ?? ?? ?? 81 E6 FF 07 00 00 48 89 54 24 38 F2 0F 5C E3 48 C1 EA 30 F2 0F 58 E2 F2 0F 11 64 24 60 81 E2 0F 80 FF FF F2 44 0F 10 4C 24 58 F2 41 0F 59 C9 F2 0F 10 54 24 60 F2 0F 11 4C 24 58 F2 0F 10 4C 24 58 C1 E6 04 F2 41 0F 5C C9 F2 0F 11 4C 24 60 0B D6 F2 0F 10 6C 24 58 F2 0F 10 64 24 60 66 89 54 24 3E F2 0F 5C EC F2 0F 11 6C 24 58 F2 0F 10 7C 24 58 F2 44 0F 10 7C 24 38 F2 44 0F 5C CF F2 44 0F 11 4C 24 60 F2 0F 10 4C 24 58 F2 44 0F 10 64 24 60 F2 44 0F 10 35 ?? ?? ?? ?? F2 41 0F 58 D4 F2 41 0F 59 C6 F2 41 0F 59 CF F2 41 0F 59 D7 F2 0F 59 C8 F2 0F 59 C2 F2 0F 11 44 24 58 48 8B 0D ?? ?? ?? ?? F2 0F 10 44 24 58 48 89 4C 24 58 F2 0F 58 C8 F2 0F 10 54 24 58 F2 0F 10 44 24 58 F2 0F 59 D0 F2 0F 11 54 24 58 F2 44 0F 10 64 24 58 F2 41 0F 58 CC 0F 28 C1 F2 0F 11 44 24 30 E9 E1 FB FF FF 81 F9 C4 FB FF FF 7C 7D 48 8B 15 ?? ?? ?? ?? 81 C6 C7 04 00 00 48 89 54 24 38 81 E6 FF 07 00 00 48 C1 EA 30 C1 E6 04 81 E2 0F 80 FF FF 0B D6 66 89 54 24 3E F2 0F 10 0D ?? ?? ?? ?? F2 0F 10 54 24 38 F2 0F 59 C1 F2 0F 59 DA 48 8B 0D ?? ?? ?? ?? 48 89 4C 24 58 F2 0F 59 C3 F2 0F 10 5C 24 58 F2 0F 10 64 24 58 F2 0F 59 E3 F2 0F 11 64 24 58 F2 0F 10 6C 24 58 F2 0F 58 C5 F2 0F 11 44 24 30 E9 5C FB FF FF 48 8B 15 ?? ?? ?? ?? 48 89 54 24 58 F2 0F 10 4C 24 58 F2 0F 10 54 24 58 F2 0F 59 D1 F2 0F 11 54 24 58 F2 0F 10 5C 24 58 F2 0F 59 C3 F2 0F 11 44 24 30 E9 25 FB FF FF 48 8B 15 ?? ?? ?? ?? 48 89 54 24 58 F2 0F 10 54 24 58 F2 0F 10 4C 24 58 F2 0F 59 D1 F2 0F 11 54 24 58 F2 0F 10 5C 24 58 F2 0F 59 C3 F2 0F 11 44 24 30 E9 EE FA FF FF 8A 54 24 3F 48 8D 0D ?? ?? ?? ?? 80 E2 80 C0 EA 07 32 DA 0F B6 DB F2 0F 10 8C D9 90 1A 00 00 F2 0F 59 C9 F2 0F 59 C8 0F 28 C1 E9 BF FA FF FF 85 F6 75 08 85 ED 0F 85 E7 F6 FF FF 83 E6 01 48 8D 15 ?? ?? ?? ?? F2 0F 10 84 F2 A8 1A 00 00 E9 9B FA FF FF F2 0F 59 C9 84 DB 74 1F 41 23 F4 48 8D 05 ?? ?? ?? ?? F2 0F 10 84 F0 A8 1A 00 00 41 8B C3 F2 0F 5E C1 E9 74 FA FF FF 41 23 F4 48 8D 15 ?? ?? ?? ?? F2 0F 10 84 F2 A8 1A 00 00 F2 0F 59 C1 E9 58 FA FF FF 45 85 D2 0F 84 2C F6 FF FF E9 10 FA FF FF 0F 1F 80 00 00 00 00 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "_iswctype_l"
		size = 39
		refs = "001e iswctype"
	strings:
		$1 = { 4C 89 44 24 18 66 89 54 24 10 66 89 4C 24 08 48 83 EC 28 0F B7 54 24 38 0F B7 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_104_1_0 {
	meta:
		name = "is_wctype"
		size = 34
		refs = "0019 iswctype"
	strings:
		$1 = { 66 89 54 24 10 66 89 4C 24 08 48 83 EC 28 0F B7 54 24 38 0F B7 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_104_2_0 {
	meta:
		name = "iswctype"
		size = 122
		refs = "0032 _pwctype 005a __imp_GetStringTypeW"
	strings:
		$1 = { 66 89 54 24 10 66 89 4C 24 08 48 83 EC 38 0F B7 44 24 40 3D FF FF 00 00 75 04 33 C0 EB 57 0F B7 44 24 40 3D 00 01 00 00 7D 19 0F B7 44 24 40 48 8B 0D ?? ?? ?? ?? 0F B7 04 41 0F B7 4C 24 48 23 C1 EB 32 4C 8D 4C 24 20 41 B8 01 00 00 00 48 8D 54 24 40 B9 01 00 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 66 89 44 24 20 0F B7 44 24 20 0F B7 4C 24 48 23 C1 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "_mbscat_s"
		size = 47
		refs = "0026 _mbscat_s_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_458_6_0 {
	meta:
		name = "_aligned_realloc_base"
		size = 47
		refs = "0026 _aligned_offset_realloc_base"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_283_7_0 {
	meta:
		name = "_atoflt_l"
		size = 47
		refs = "0026 __crt_atoflt_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1355_0_0 {
	meta:
		name = "_mbscpy_s"
		size = 47
		refs = "0026 _mbscpy_s_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_410_3_0 {
	meta:
		name = "_mbsnbcat"
		size = 47
		refs = "0026 _mbsnbcat_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_473_3_0 {
	meta:
		name = "_mbsnbcmp"
		size = 47
		refs = "0026 _mbsnbcmp_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_955_3_0 {
	meta:
		name = "_mbsnbcoll"
		size = 47
		refs = "0026 _mbsnbcoll_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_304_3_0 {
	meta:
		name = "_mbsnbcpy"
		size = 47
		refs = "0026 _mbsnbcpy_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_397_3_0 {
	meta:
		name = "_mbsnbicmp"
		size = 47
		refs = "0026 _mbsnbicmp_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_430_3_0 {
	meta:
		name = "_mbsnbicoll"
		size = 47
		refs = "0026 _mbsnbicoll_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_262_3_0 {
	meta:
		name = "_mbsncat"
		size = 47
		refs = "0026 _mbsncat_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_144_3_0 {
	meta:
		name = "_mbsncmp"
		size = 47
		refs = "0026 _mbsncmp_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_297_3_0 {
	meta:
		name = "_mbsncoll"
		size = 47
		refs = "0026 _mbsncoll_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_917_3_0 {
	meta:
		name = "_mbsncpy"
		size = 47
		refs = "0026 _mbsncpy_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_218_3_0 {
	meta:
		name = "_mbsnicmp"
		size = 47
		refs = "0026 _mbsnicmp_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_664_3_0 {
	meta:
		name = "_mbsnicoll"
		size = 47
		refs = "0026 _mbsnicoll_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_781_3_0 {
	meta:
		name = "_mbstok_s"
		size = 47
		refs = "0026 _mbstok_s_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1345_4_0 {
	meta:
		name = "mbtowc"
		size = 47
		refs = "0026 _mbtowc_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_544_4_0 {
	meta:
		name = "strxfrm"
		size = 47
		refs = "0026 _strxfrm_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_979_7_0 {
	meta:
		name = "wcstombs"
		size = 47
		refs = "0026 _wcstombs_l_helper"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_352_4_0 {
	meta:
		name = "wcsxfrm"
		size = 47
		refs = "0026 _wcsxfrm_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 45 33 C9 4C 8B 44 24 40 48 8B 54 24 38 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__addlocaleref"
		size = 327
		refs = "00af __wclocalestr"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 F0 FF 00 48 8B 44 24 20 48 83 B8 D8 00 00 00 00 74 0F 48 8B 44 24 20 48 8B 80 D8 00 00 00 F0 FF 00 48 8B 44 24 20 48 83 B8 E8 00 00 00 00 74 0F 48 8B 44 24 20 48 8B 80 E8 00 00 00 F0 FF 00 48 8B 44 24 20 48 83 B8 E0 00 00 00 00 74 0F 48 8B 44 24 20 48 8B 80 E0 00 00 00 F0 FF 00 48 8B 44 24 20 48 83 B8 F8 00 00 00 00 74 0F 48 8B 44 24 20 48 8B 80 F8 00 00 00 F0 FF 00 C7 04 24 00 00 00 00 EB 08 8B 04 24 FF C0 89 04 24 83 3C 24 05 0F 8F 89 00 00 00 48 63 04 24 48 6B C0 20 48 8D 0D ?? ?? ?? ?? 48 8B 54 24 20 48 39 4C 02 18 74 2A 48 63 04 24 48 6B C0 20 48 8B 4C 24 20 48 83 7C 01 28 00 74 15 48 63 04 24 48 6B C0 20 48 8B 4C 24 20 48 8B 44 01 28 F0 FF 00 48 63 04 24 48 6B C0 20 48 8B 4C 24 20 48 83 7C 01 10 00 74 2A 48 63 04 24 48 6B C0 20 48 8B 4C 24 20 48 83 7C 01 20 00 74 15 48 63 04 24 48 6B C0 20 48 8B 4C 24 20 48 8B 44 01 20 F0 FF 00 E9 65 FF FF FF 48 8B 44 24 20 48 8B 80 20 01 00 00 48 05 5C 01 00 00 F0 FF 00 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_106_1_0 {
	meta:
		name = "__freetlocinfo"
		size = 941
		refs = "001f __lconv_c 008f _free_dbg 00a0 __free_lconv_mon 00e7 __free_lconv_num 01b1 __lc_time_c 01e5 __free_lc_time 022a __wclocalestr 02fc ??_C@_1BJK@FEBNHLFF@?$AA?$CI?$AA?$CI?$AAp?$AAt?$AAl?$AAo?$AAc?$AAi?$AA?9?$AA?$DO?$AAl?$AAc?$AA_?$AAc?$AAa?$AAt?$AAe?$AAg?$AAo?$AAr?$AAy?$AA?$FL?$AAc?$AAa?$AAt?$AAe?$AAg?$AAo?$AAr?$AAy?$AA?$FN?$AA?4@ 0308 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 031d ??_C@_1FC@HINIIGNO@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAl?$AAo@ 0327 _CrtDbgReportW"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 48 48 8B 44 24 50 48 83 B8 F0 00 00 00 00 0F 84 FB 00 00 00 48 8D 05 ?? ?? ?? ?? 48 8B 4C 24 50 48 39 81 F0 00 00 00 0F 84 E2 00 00 00 48 8B 44 24 50 48 83 B8 D8 00 00 00 00 0F 84 CF 00 00 00 48 8B 44 24 50 48 8B 80 D8 00 00 00 83 38 00 0F 85 BA 00 00 00 48 8B 44 24 50 48 83 B8 E8 00 00 00 00 74 38 48 8B 44 24 50 48 8B 80 E8 00 00 00 83 38 00 75 27 BA 02 00 00 00 48 8B 44 24 50 48 8B 88 E8 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 88 F0 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 83 B8 E0 00 00 00 00 74 38 48 8B 44 24 50 48 8B 80 E0 00 00 00 83 38 00 75 27 BA 02 00 00 00 48 8B 44 24 50 48 8B 88 E0 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 88 F0 00 00 00 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 44 24 50 48 8B 88 D8 00 00 00 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 44 24 50 48 8B 88 F0 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 83 B8 F8 00 00 00 00 0F 84 84 00 00 00 48 8B 44 24 50 48 8B 80 F8 00 00 00 83 38 00 75 73 48 8B 44 24 50 48 8B 80 00 01 00 00 48 2D FE 00 00 00 BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 80 10 01 00 00 48 2D 80 00 00 00 BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 48 8B 44 24 50 48 8B 80 18 01 00 00 48 2D 80 00 00 00 BA 02 00 00 00 48 8B C8 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 44 24 50 48 8B 88 F8 00 00 00 E8 ?? ?? ?? ?? 48 8D 05 ?? ?? ?? ?? 48 8B 4C 24 50 48 39 81 20 01 00 00 74 3C 48 8B 44 24 50 48 8B 80 20 01 00 00 83 B8 5C 01 00 00 00 75 27 48 8B 44 24 50 48 8B 88 20 01 00 00 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 44 24 50 48 8B 88 20 01 00 00 E8 ?? ?? ?? ?? C7 44 24 30 00 00 00 00 EB 0A 8B 44 24 30 FF C0 89 44 24 30 83 7C 24 30 05 0F 8F 7B 01 00 00 48 63 44 24 30 48 6B C0 20 48 8D 0D ?? ?? ?? ?? 48 8B 54 24 50 48 39 4C 02 18 74 67 48 63 44 24 30 48 6B C0 20 48 8B 4C 24 50 48 83 7C 01 28 00 74 51 48 63 44 24 30 48 6B C0 20 48 8B 4C 24 50 48 8B 44 01 28 83 38 00 75 39 48 63 44 24 30 48 6B C0 20 BA 02 00 00 00 48 8B 4C 24 50 48 8B 4C 01 28 E8 ?? ?? ?? ?? 48 63 44 24 30 BA 02 00 00 00 48 8B 4C 24 50 48 8B 8C C1 28 01 00 00 E8 ?? ?? ?? ?? 48 63 44 24 30 48 6B C0 20 48 8B 4C 24 50 48 83 7C 01 10 00 74 16 48 63 44 24 30 48 6B C0 20 48 8B 4C 24 50 48 83 7C 01 20 00 75 66 48 63 44 24 30 48 6B C0 20 48 8B 4C 24 50 48 83 7C 01 10 00 75 16 48 63 44 24 30 48 6B C0 20 48 8B 4C 24 50 48 83 7C 01 20 00 74 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 BD 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 63 44 24 30 48 6B C0 20 48 8B 4C 24 50 48 83 7C 01 10 00 74 4B 48 63 44 24 30 48 6B C0 20 48 8B 4C 24 50 48 83 7C 01 20 00 74 35 48 63 44 24 30 48 6B C0 20 48 8B 4C 24 50 48 8B 44 01 20 83 38 00 75 1D 48 63 44 24 30 48 6B C0 20 BA 02 00 00 00 48 8B 4C 24 50 48 8B 4C 01 20 E8 ?? ?? ?? ?? E9 70 FE FF FF BA 02 00 00 00 48 8B 4C 24 50 E8 ?? ?? ?? ?? 48 83 C4 48 C3 }
	condition:
		$1
}

rule file_106_2_0 {
	meta:
		name = "__removelocaleref"
		size = 344
		refs = "00bb __wclocalestr"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 83 7C 24 20 00 0F 84 39 01 00 00 48 8B 44 24 20 F0 FF 08 48 8B 44 24 20 48 83 B8 D8 00 00 00 00 74 0F 48 8B 44 24 20 48 8B 80 D8 00 00 00 F0 FF 08 48 8B 44 24 20 48 83 B8 E8 00 00 00 00 74 0F 48 8B 44 24 20 48 8B 80 E8 00 00 00 F0 FF 08 48 8B 44 24 20 48 83 B8 E0 00 00 00 00 74 0F 48 8B 44 24 20 48 8B 80 E0 00 00 00 F0 FF 08 48 8B 44 24 20 48 83 B8 F8 00 00 00 00 74 0F 48 8B 44 24 20 48 8B 80 F8 00 00 00 F0 FF 08 C7 04 24 00 00 00 00 EB 08 8B 04 24 FF C0 89 04 24 83 3C 24 05 0F 8F 89 00 00 00 48 63 04 24 48 6B C0 20 48 8D 0D ?? ?? ?? ?? 48 8B 54 24 20 48 39 4C 02 18 74 2A 48 63 04 24 48 6B C0 20 48 8B 4C 24 20 48 83 7C 01 28 00 74 15 48 63 04 24 48 6B C0 20 48 8B 4C 24 20 48 8B 44 01 28 F0 FF 08 48 63 04 24 48 6B C0 20 48 8B 4C 24 20 48 83 7C 01 10 00 74 2A 48 63 04 24 48 6B C0 20 48 8B 4C 24 20 48 83 7C 01 20 00 74 15 48 63 04 24 48 6B C0 20 48 8B 4C 24 20 48 8B 44 01 20 F0 FF 08 E9 65 FF FF FF 48 8B 44 24 20 48 8B 80 20 01 00 00 48 05 5C 01 00 00 F0 FF 08 48 8B 44 24 20 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_106_3_0 {
	meta:
		name = "__updatetlocinfo"
		size = 160
		refs = "000e _getptd 001e __globallocalestatus 0043 _lock 0056 __ptlocinfo 005e _updatetlocinfoEx_nolock 006d _unlock 0092 _amsg_exit"
	strings:
		$1 = { 48 83 EC 38 48 C7 44 24 20 00 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 28 48 8B 44 24 28 8B 0D ?? ?? ?? ?? 8B 80 C8 00 00 00 23 C1 85 C0 74 0F 48 8B 44 24 28 48 83 B8 C0 00 00 00 00 75 36 B9 0C 00 00 00 E8 ?? ?? ?? ?? 90 48 8B 44 24 28 48 05 C0 00 00 00 48 8B 15 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 48 89 44 24 20 B9 0C 00 00 00 E8 ?? ?? ?? ?? EB 11 E8 ?? ?? ?? ?? 48 8B 80 C0 00 00 00 48 89 44 24 20 48 83 7C 24 20 00 75 0A B9 20 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 20 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_106_5_0 {
	meta:
		name = "_updatetlocinfoEx_nolock"
		size = 152
		refs = "004e __addlocaleref 0060 __removelocaleref 0079 __initiallocinfo 008a __freetlocinfo"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 83 7C 24 48 00 74 08 48 83 7C 24 40 00 75 04 33 C0 EB 71 48 8B 44 24 40 48 8B 00 48 89 44 24 20 48 8B 44 24 48 48 39 44 24 20 74 53 48 8B 44 24 40 48 8B 4C 24 48 48 89 08 48 8B 4C 24 48 E8 ?? ?? ?? ?? 48 83 7C 24 20 00 74 0A 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 83 7C 24 20 00 74 22 48 8B 44 24 20 83 38 00 75 18 48 8D 05 ?? ?? ?? ?? 48 39 44 24 20 74 0A 48 8B 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 48 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "_wspawnlpe"
		size = 927
		refs = "001d __security_cookie 005b ??_C@_1CC@JBMDNKJP@?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0067 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 007c ??_C@_1FC@NLLKLAOC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAe?$AAx?$AAe?$AAc?$AA?2?$AAs?$AAp@ 0086 _CrtDbgReportW 009a _errno 00bd ??_C@_1BG@DEELLFKC@?$AA_?$AAw?$AAs?$AAp?$AAa?$AAw?$AAn?$AAl?$AAp?$AAe?$AA?$AA@ 00c9 _invalid_parameter 010c ??_C@_1CM@DMCMCPME@?$AA?$CK?$AAf?$AAi?$AAl?$AAe?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 01b9 ??_C@_1CA@MOAFCHEI@?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 026a ??_C@_1CK@PKCLGCC@?$AA?$CK?$AAa?$AAr?$AAg?$AAl?$AAi?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$AA@ 030e _wcapture_argv 0356 _wspawnvpe 037e _free_dbg 0393 __security_check_cookie"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 89 4C 24 08 4C 89 4C 24 20 48 81 EC 88 02 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 70 02 00 00 48 83 BC 24 98 02 00 00 00 74 0A C7 44 24 34 01 00 00 00 EB 08 C7 44 24 34 00 00 00 00 8B 44 24 34 89 44 24 50 83 7C 24 50 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 4F 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 50 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 4F 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 AE 02 00 00 48 8B 84 24 98 02 00 00 0F B7 00 85 C0 74 0A C7 44 24 3C 01 00 00 00 EB 08 C7 44 24 3C 00 00 00 00 8B 44 24 3C 89 44 24 4C 83 7C 24 4C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 50 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 4C 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 50 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 FD 01 00 00 48 83 BC 24 A0 02 00 00 00 74 0A C7 44 24 48 01 00 00 00 EB 08 C7 44 24 48 00 00 00 00 8B 44 24 48 89 44 24 54 83 7C 24 54 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 51 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 54 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 51 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 50 01 00 00 48 8B 84 24 A0 02 00 00 0F B7 00 85 C0 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 52 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 52 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 C7 C0 FF FF FF FF E9 9F 00 00 00 48 8D 84 24 A8 02 00 00 48 89 44 24 40 41 B9 40 00 00 00 4C 8D 44 24 70 48 8B 94 24 A0 02 00 00 48 8D 4C 24 40 E8 ?? ?? ?? ?? 48 89 44 24 58 48 8B 44 24 40 48 83 C0 08 48 89 44 24 40 48 8B 44 24 40 48 8B 40 F8 48 89 44 24 68 48 C7 44 24 40 00 00 00 00 4C 8B 4C 24 68 4C 8B 44 24 58 48 8B 94 24 98 02 00 00 8B 8C 24 90 02 00 00 E8 ?? ?? ?? ?? 48 89 44 24 60 48 83 7C 24 58 00 74 1B 48 8D 44 24 70 48 39 44 24 58 74 0F BA 02 00 00 00 48 8B 4C 24 58 E8 ?? ?? ?? ?? 48 8B 44 24 60 48 8B 8C 24 70 02 00 00 48 33 CC E8 ?? ?? ?? ?? 48 81 C4 88 02 00 00 C3 }
	condition:
		$1
}

rule file_110_5_0 {
	meta:
		name = "_vcprintf_p"
		size = 36
		refs = "001b _vcprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_825_5_0 {
	meta:
		name = "_vcprintf"
		size = 36
		refs = "001b _vcprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_763_5_0 {
	meta:
		name = "_vcprintf_s"
		size = 36
		refs = "001b _vcprintf_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_706_5_0 {
	meta:
		name = "_vcwprintf"
		size = 36
		refs = "001b _vcwprintf_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_1054_5_0 {
	meta:
		name = "_vcwprintf_p"
		size = 36
		refs = "001b _vcwprintf_p_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_653_5_0 {
	meta:
		name = "_vcwprintf_s"
		size = 36
		refs = "001b _vcwprintf_s_l"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 4C 8B 44 24 38 33 D2 48 8B 4C 24 30 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_110_6_0 {
	meta:
		name = "_vcprintf_p_l"
		size = 16836
		refs = "0019 __security_cookie 008e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 00f2 _errno 013c ??_C@_1CC@MGIEJOME@?$AA?$CI?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$CJ?$AA?$AA@ 0148 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 015d ??_C@_1FA@KMIJDCIC@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAd?$AAi?$AAo?$AA?2?$AAo@ 0167 _CrtDbgReportW 01a1 ??_C@_1BM@OKHEMPJL@?$AA_?$AAv?$AAc?$AAp?$AAr?$AAi?$AAn?$AAt?$AAf?$AA_?$AAp?$AA_?$AAl?$AA?$AA@ 01ad _invalid_parameter 01c5 ??1_LocaleUpdate@@QEAA@XZ 02f9 __lookuptable_s 038c strtol 03bc memset 046d ??_C@_1JC@PFJNKEIO@?$AA?$CI?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DN?$AA?$DN@ 057f ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@ 063f __ImageBase 0646 $LN414 0684 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 0691 _isleadbyte_l 06a8 write_char 070a ??_C@_1CC@IFFHEMNF@?$AA?$CI?$AAc?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA_?$AAT?$AA?$CI?$AA?8?$AA?2?$AA0?$AA?8?$AA?$CJ?$AA?$CJ?$AA?$AA@ 08a6 get_int_arg 0943 ??_C@_1JE@NMBHOLFI@?$AA?$CI?$AA?$CI?$AAw?$AAi?$AAd?$AAt?$AAh?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DN@ 0a83 _validate_param_reuseA 0abe ??_C@_1II@PIPIMLPF@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 0c85 ??_C@_1JG@JBJBOCFB@?$AA?$CI?$AA?$CI?$AAp?$AAr?$AAe?$AAc?$AAi?$AAs?$AA_?$AAp?$AAo?$AAs?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CK?$AAe?$AAn?$AAd?$AA_?$AAp?$AAo?$AAs?$AA?5@ 0e00 ??_C@_1IK@EIEPDKHJ@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 10e5 $LN412 10ec $LN413 113a get_short_arg 118c ??_C@_1EM@BNPHBBIA@?$AA?$CI?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?$DO?$AA?$DN?$AA0?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAt?$AAy?$AAp?$AAe?$AA_?$AAp?$AAo?$AAs?$AA?$DM?$AA_?$AAA?$AAR?$AAG@ 12e5 ??_C@_1IK@MHEDJAMK@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 13d0 wctomb_s 15b0 ??_C@_1IG@FDCPLALG@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 16c0 get_int64_arg 186b ??_C@_1IG@HJIMKDHC@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 1956 __nullstring 1965 strlen 1cc3 __wnullstring 2063 _get_printf_count_output 20a8 ??_C@_1EK@PNGFDECN@?$AA?$CI?$AA?$CC?$AA?8?$AAn?$AA?8?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAd?$AAi?$AAs?$AAa?$AAb?$AAl?$AAe?$AAd?$AA?$CC@ 2348 ??_C@_1IM@DNGHAPLB@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 245a ??_C@_0CI@CMOPBIOD@f?3?2dd?2vctools?2crt?2crtw32?2stdio?2o@ 2467 _malloc_dbg 2614 ??_C@_1DG@GOHGNKHE@?$AAp?$AAa?$AAs?$AAs?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAF?$AAO?$AAR?$AAM?$AAA?$AAT?$AA_?$AAO?$AAU?$AAT?$AAP?$AAU?$AAT?$AA_?$AAP?$AAA?$AAS?$AAS?$AA?$AA@ 271d _cfltcvt_tab 2727 __imp_DecodePointer 2ae3 ??_C@_1IK@NBGDDCBN@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 2d82 ??_C@_1JC@OACKELNN@?$AA_?$AAt?$AAv?$AAa?$AAl?$AAi?$AAd?$AAa?$AAt?$AAe?$AA_?$AAp?$AAa?$AAr?$AAa?$AAm?$AA_?$AAr?$AAe?$AAu?$AAs?$AAe?$AA?$CI?$AA?$CG?$AAp?$AAo?$AAs?$AA_?$AAv?$AAa?$AAl?$AAu@ 3bac write_multi_char 3bc7 write_string 3d4d _free_dbg 3da9 ??_C@_1FK@LNCFKALM@?$AA?$CI?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAS?$AAT?$AA_?$AAN?$AAO?$AAR?$AAM?$AAA?$AAL?$AA?$CJ?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AA?$CI?$AAs?$AAt?$AAa?$AAt?$AAe?$AA?5@ 3ec1 $LN411 3fee get_crtdouble_arg 4038 ??_C@_1FK@BCPANIEK@?$AA?$CI?$AA?$CC?$AAM?$AAi?$AAs?$AAs?$AAi?$AAn?$AAg?$AA?5?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAi?$AAn?$AA?5?$AAt?$AAh?$AAe?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt@ 4103 __security_check_cookie 4110 $LN265 4114 $LN259 4118 $LN258 411c $LN250 4120 $LN238 4124 $LN237 4128 $LN225 412c $LN209 4130 $LN138 4134 $LN206 4138 $LN170 413c $LN112 4140 $LN184 4144 $LN137 4148 $LN204 414c $LN117 4150 $LN151 4154 $LN107 4158 $LN113 415c $LN168 4160 $LN115 4164 $LN110 4168 $LN207 41a4 $LN9 41a8 $LN8 41ac $LN7 41b0 $LN6 41b4 $LN5 41b8 $LN4 41bc $LN2 41c0 $LN3"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC A8 0F 00 00 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 98 0F 00 00 C7 84 24 EC 00 00 00 00 00 00 00 C7 44 24 48 00 00 00 00 C7 44 24 6C 00 00 00 00 C7 44 24 4C 00 00 00 00 C7 44 24 7C 00 00 00 00 C7 84 24 E8 00 00 00 00 00 00 00 C7 84 24 9C 00 00 00 00 00 00 00 48 C7 44 24 58 00 00 00 00 C7 84 24 90 00 00 00 00 00 00 00 48 8B 94 24 B8 0F 00 00 48 8D 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 48 C7 84 24 50 03 00 00 00 00 00 00 48 C7 84 24 A8 00 00 00 00 00 00 00 C7 44 24 50 00 00 00 00 C7 84 24 D0 03 00 00 00 00 00 00 C7 44 24 68 FF FF FF FF C7 44 24 44 FF FF FF FF C7 44 24 70 FF FF FF FF C7 44 24 78 FF FF FF FF C7 44 24 54 FF FF FF FF 48 C7 84 24 10 01 00 00 00 00 00 00 E8 ?? ?? ?? ?? 48 89 84 24 D8 02 00 00 48 83 BC 24 B0 0F 00 00 00 74 0D C7 84 24 B8 01 00 00 01 00 00 00 EB 0B C7 84 24 B8 01 00 00 00 00 00 00 8B 84 24 B8 01 00 00 89 84 24 30 02 00 00 83 BC 24 30 02 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 0C 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 30 02 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 0C 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 A0 02 00 00 FF FF FF FF 48 8D 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 A0 02 00 00 E9 22 3F 00 00 C7 44 24 64 00 00 00 00 48 8B 84 24 B0 0F 00 00 48 89 84 24 50 03 00 00 C7 44 24 50 00 00 00 00 EB 0A 8B 44 24 50 FF C0 89 44 24 50 83 7C 24 50 02 0F 8D CC 3E 00 00 83 7C 24 50 01 75 0C 83 7C 24 54 00 75 05 E9 B9 3E 00 00 C7 44 24 60 00 00 00 00 C7 84 24 80 00 00 00 00 00 00 00 48 C7 84 24 10 01 00 00 00 00 00 00 C7 84 24 08 01 00 00 00 00 00 00 C7 44 24 68 FF FF FF FF C7 44 24 6C 00 00 00 00 C7 44 24 4C 00 00 00 00 48 8B 84 24 50 03 00 00 48 89 84 24 B0 0F 00 00 C7 44 24 44 FF FF FF FF C7 44 24 70 FF FF FF FF C7 44 24 78 FF FF FF FF C7 44 24 54 FF FF FF FF 48 8B 84 24 B0 0F 00 00 0F B6 00 88 44 24 40 0F BE 44 24 40 89 84 24 EC 02 00 00 48 8B 84 24 B0 0F 00 00 48 FF C0 48 89 84 24 B0 0F 00 00 83 BC 24 EC 02 00 00 00 0F 84 95 3A 00 00 83 7C 24 64 00 0F 8C 8A 3A 00 00 0F BE 44 24 40 83 F8 20 7C 2B 0F BE 44 24 40 83 F8 78 7F 21 0F BE 44 24 40 83 E8 20 48 98 48 8D 0D ?? ?? ?? ?? 0F B6 04 01 83 E0 0F 89 84 24 38 02 00 00 EB 0B C7 84 24 38 02 00 00 00 00 00 00 8B 84 24 38 02 00 00 89 84 24 F4 02 00 00 6B 84 24 F4 02 00 00 09 03 84 24 80 00 00 00 48 98 48 8D 0D ?? ?? ?? ?? 0F B6 04 01 C1 F8 04 89 84 24 80 00 00 00 83 BC 24 80 00 00 00 01 0F 85 DE 01 00 00 48 8B 84 24 B0 0F 00 00 0F BE 00 83 F8 25 0F 84 CA 01 00 00 83 7C 24 54 FF 75 5D 41 B8 0A 00 00 00 48 8D 94 24 A8 00 00 00 48 8B 8C 24 B0 0F 00 00 E8 ?? ?? ?? ?? 85 C0 7E 36 48 8B 84 24 A8 00 00 00 0F BE 00 83 F8 24 75 26 83 7C 24 50 00 75 15 41 B8 60 09 00 00 33 D2 48 8D 8C 24 30 06 00 00 E8 ?? ?? ?? ?? C7 44 24 54 01 00 00 00 EB 08 C7 44 24 54 00 00 00 00 83 7C 24 54 01 0F 85 56 01 00 00 41 B8 0A 00 00 00 48 8D 94 24 A8 00 00 00 48 8B 8C 24 B0 0F 00 00 E8 ?? ?? ?? ?? FF C8 89 44 24 44 48 8B 84 24 A8 00 00 00 48 FF C0 48 89 84 24 B0 0F 00 00 83 7C 24 50 00 0F 85 17 01 00 00 83 7C 24 44 00 7C 24 48 8B 84 24 A8 00 00 00 0F BE 00 83 F8 24 75 14 83 7C 24 44 64 7D 0D C7 84 24 40 02 00 00 01 00 00 00 EB 0B C7 84 24 40 02 00 00 00 00 00 00 8B 84 24 40 02 00 00 89 84 24 48 02 00 00 83 BC 24 48 02 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 55 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 48 02 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 55 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 84 02 00 00 FF FF FF FF 48 8D 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 84 02 00 00 E9 F1 3B 00 00 8B 44 24 68 39 44 24 44 7E 0D 8B 44 24 44 89 84 24 50 02 00 00 EB 0B 8B 44 24 68 89 84 24 50 02 00 00 8B 84 24 50 02 00 00 89 44 24 68 E9 E0 00 00 00 83 BC 24 80 00 00 00 08 0F 85 D2 00 00 00 33 C0 85 C0 74 0D C7 84 24 58 02 00 00 01 00 00 00 EB 0B C7 84 24 58 02 00 00 00 00 00 00 8B 84 24 58 02 00 00 89 84 24 60 02 00 00 83 BC 24 60 02 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 61 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 60 02 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 61 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 88 02 00 00 FF FF FF FF 48 8D 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 88 02 00 00 E9 DF 3A 00 00 8B 84 24 80 00 00 00 89 84 24 5C 02 00 00 83 BC 24 5C 02 00 00 07 0F 87 29 37 00 00 48 63 84 24 5C 02 00 00 48 8D 0D ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 83 7C 24 50 00 75 07 83 7C 24 54 01 74 0E 83 7C 24 50 01 75 0C 83 7C 24 54 FF 75 05 E9 ED 36 00 00 C7 84 24 90 00 00 00 00 00 00 00 48 8D 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 0F B6 4C 24 40 48 8B D0 E8 ?? ?? ?? ?? 85 C0 0F 84 06 01 00 00 48 8D 54 24 64 0F B6 4C 24 40 E8 ?? ?? ?? ?? 48 8B 84 24 B0 0F 00 00 0F B6 00 88 44 24 40 48 8B 84 24 B0 0F 00 00 48 FF C0 48 89 84 24 B0 0F 00 00 0F BE 44 24 40 85 C0 74 0D C7 84 24 28 02 00 00 01 00 00 00 EB 0B C7 84 24 28 02 00 00 00 00 00 00 8B 84 24 28 02 00 00 89 84 24 34 01 00 00 83 BC 24 34 01 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 8B 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 34 01 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 8B 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 90 02 00 00 FF FF FF FF 48 8D 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 90 02 00 00 E9 54 39 00 00 48 8D 54 24 64 0F B6 4C 24 40 E8 ?? ?? ?? ?? E9 A6 35 00 00 C7 84 24 E8 00 00 00 00 00 00 00 8B 84 24 E8 00 00 00 89 84 24 9C 00 00 00 8B 84 24 9C 00 00 00 89 44 24 6C 8B 44 24 6C 89 44 24 7C C7 44 24 48 00 00 00 00 C7 44 24 4C FF FF FF FF C7 84 24 90 00 00 00 00 00 00 00 E9 5A 35 00 00 0F B6 44 24 40 88 84 24 A0 00 00 00 80 BC 24 A0 00 00 00 20 74 44 80 BC 24 A0 00 00 00 23 74 47 80 BC 24 A0 00 00 00 2B 74 23 80 BC 24 A0 00 00 00 2D 74 0C 80 BC 24 A0 00 00 00 30 74 37 EB 40 8B 44 24 48 83 C8 04 89 44 24 48 EB 33 8B 44 24 48 83 C8 01 89 44 24 48 EB 26 8B 44 24 48 83 C8 02 89 44 24 48 EB 19 8B 44 24 48 0F BA E8 07 89 44 24 48 EB 0B 8B 44 24 48 83 C8 08 89 44 24 48 E9 D5 34 00 00 0F BE 44 24 40 83 F8 2A 0F 85 10 03 00 00 83 7C 24 54 00 75 16 48 8D 8C 24 C0 0F 00 00 E8 ?? ?? ?? ?? 89 44 24 6C E9 D5 02 00 00 41 B8 0A 00 00 00 48 8D 94 24 A8 00 00 00 48 8B 8C 24 B0 0F 00 00 E8 ?? ?? ?? ?? FF C8 89 44 24 70 48 8B 84 24 A8 00 00 00 48 FF C0 48 89 84 24 B0 0F 00 00 83 7C 24 50 00 0F 85 6C 02 00 00 83 7C 24 70 00 7C 24 48 8B 84 24 A8 00 00 00 0F BE 00 83 F8 24 75 14 83 7C 24 44 64 7D 0D C7 84 24 D4 01 00 00 01 00 00 00 EB 0B C7 84 24 D4 01 00 00 00 00 00 00 8B 84 24 D4 01 00 00 89 84 24 3C 01 00 00 83 BC 24 3C 01 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 C0 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 3C 01 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 C0 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 98 02 00 00 FF FF FF FF 48 8D 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 98 02 00 00 E9 1B 37 00 00 8B 44 24 68 39 44 24 70 7E 0D 8B 44 24 70 89 84 24 24 02 00 00 EB 0B 8B 44 24 68 89 84 24 24 02 00 00 8B 84 24 24 02 00 00 89 44 24 68 48 63 44 24 70 48 6B C0 18 83 BC 04 30 06 00 00 00 75 42 48 63 44 24 70 48 6B C0 18 C7 84 04 30 06 00 00 01 00 00 00 48 63 44 24 70 48 6B C0 18 0F B6 4C 24 40 88 8C 04 40 06 00 00 48 63 44 24 70 48 6B C0 18 8B 4C 24 48 89 8C 04 44 06 00 00 E9 F9 00 00 00 48 63 44 24 70 48 6B C0 18 48 8D 84 04 30 06 00 00 44 8B 4C 24 48 44 0F B6 44 24 40 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 74 0D C7 84 24 44 01 00 00 01 00 00 00 EB 0B C7 84 24 44 01 00 00 00 00 00 00 8B 84 24 44 01 00 00 89 84 24 DC 01 00 00 83 BC 24 DC 01 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 C5 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 DC 01 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 C5 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 80 02 00 00 FF FF FF FF 48 8D 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 80 02 00 00 E9 A0 35 00 00 E9 01 32 00 00 EB 2A 48 63 44 24 70 48 6B C0 18 48 8B 84 04 38 06 00 00 48 89 84 24 80 03 00 00 48 8D 8C 24 80 03 00 00 E8 ?? ?? ?? ?? 89 44 24 6C 83 7C 24 6C 00 7D 15 8B 44 24 48 83 C8 04 89 44 24 48 8B 44 24 6C F7 D8 89 44 24 6C EB 12 6B 44 24 6C 0A 0F BE 4C 24 40 8D 44 08 D0 89 44 24 6C E9 A0 31 00 00 C7 44 24 4C 00 00 00 00 E9 93 31 00 00 0F BE 44 24 40 83 F8 2A 0F 85 03 03 00 00 83 7C 24 54 00 75 16 48 8D 8C 24 C0 0F 00 00 E8 ?? ?? ?? ?? 89 44 24 4C E9 D5 02 00 00 41 B8 0A 00 00 00 48 8D 94 24 A8 00 00 00 48 8B 8C 24 B0 0F 00 00 E8 ?? ?? ?? ?? FF C8 89 44 24 78 48 8B 84 24 A8 00 00 00 48 FF C0 48 89 84 24 B0 0F 00 00 83 7C 24 50 00 0F 85 6C 02 00 00 83 7C 24 78 00 7C 24 48 8B 84 24 A8 00 00 00 0F BE 00 83 F8 24 75 14 83 7C 24 44 64 7D 0D C7 84 24 4C 01 00 00 01 00 00 00 EB 0B C7 84 24 4C 01 00 00 00 00 00 00 8B 84 24 4C 01 00 00 89 84 24 4C 02 00 00 83 BC 24 4C 02 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 F5 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 4C 02 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 F5 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 A8 02 00 00 FF FF FF FF 48 8D 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 A8 02 00 00 E9 D9 33 00 00 8B 44 24 68 39 44 24 78 7E 0D 8B 44 24 78 89 84 24 54 01 00 00 EB 0B 8B 44 24 68 89 84 24 54 01 00 00 8B 84 24 54 01 00 00 89 44 24 68 48 63 44 24 78 48 6B C0 18 83 BC 04 30 06 00 00 00 75 42 48 63 44 24 78 48 6B C0 18 C7 84 04 30 06 00 00 01 00 00 00 48 63 44 24 78 48 6B C0 18 0F B6 4C 24 40 88 8C 04 40 06 00 00 48 63 44 24 78 48 6B C0 18 8B 4C 24 48 89 8C 04 44 06 00 00 E9 F9 00 00 00 48 63 44 24 78 48 6B C0 18 48 8D 84 04 30 06 00 00 44 8B 4C 24 48 44 0F B6 44 24 40 BA 01 00 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 74 0D C7 84 24 E4 01 00 00 01 00 00 00 EB 0B C7 84 24 E4 01 00 00 00 00 00 00 8B 84 24 E4 01 00 00 89 84 24 5C 01 00 00 83 BC 24 5C 01 00 00 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 FA 04 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 BC 24 5C 01 00 00 00 75 58 E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 FA 04 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 84 24 B0 02 00 00 FF FF FF FF 48 8D 8C 24 B8 00 00 00 E8 ?? ?? ?? ?? 8B 84 24 B0 02 00 00 E9 5E 32 00 00 E9 BF 2E 00 00 EB 2A 48 63 44 24 78 48 6B C0 18 48 8B 84 04 38 06 00 00 48 89 84 24 E0 03 00 00 48 8D 8C 24 E0 03 00 00 E8 ?? ?? ?? ?? 89 44 24 4C 83 7C 24 4C 00 7D 08 C7 44 24 4C FF FF FF FF EB 12 6B 44 24 4C 0A 0F BE 4C 24 40 8D 44 08 D0 89 44 24 4C E9 6B 2E 00 00 0F B6 44 24 40 88 84 24 E4 00 00 00 80 BC 24 E4 00 00 00 49 74 6C 80 BC 24 E4 00 00 00 68 0F 84 73 01 00 00 80 BC 24 E4 00 00 00 6C 74 13 80 BC 24 E4 00 00 00 77 0F 84 68 01 00 00 E9 6F 01 00 00 48 8B 84 24 B0 0F 00 00 0F BE 00 83 F8 6C 75 21 48 8B 84 24 B0 0F 00 00 48 FF C0 48 89 84 24 B0 0F 00 00 8B 44 24 48 0F BA E8 0C 89 44 24 48 EB 0B 8B 44 24 48 83 C8 10 89 44 24 48 E9 2E 01 00 00 8B 44 24 48 0F BA E8 0F 89 44 24 48 48 8B 84 24 B0 0F 00 00 0F BE 00 83 F8 36 75 36 48 8B 84 24 B0 0F 00 00 0F BE 40 01 83 F8 34 75 25 48 8B 84 24 B0 0F 00 00 48 83 C0 02 48 89 84 24 B0 0F 00 00 8B 44 24 48 0F BA E8 0F 89 44 24 48 E9 C1 00 00 00 48 8B 84 24 B0 0F 00 00 0F BE 00 83 F8 33 75 33 48 8B 84 24 B0 0F 00 00 0F BE 40 01 83 F8 32 75 22 48 8B 84 24 B0 0F 00 00 48 83 C0 02 48 89 84 24 B0 0F 00 00 8B 44 24 48 0F }
	condition:
		$1
}

rule file_110_7_0 {
	meta:
		name = "get_crtdouble_arg"
		size = 101
		altNames = "get_int64_arg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 33 C0 85 C0 74 29 48 8B 44 24 20 48 8B 00 48 83 C0 08 48 8B 4C 24 20 48 89 01 48 8B 44 24 20 48 8B 00 48 8B 40 F8 48 8B 00 48 89 04 24 EB 24 48 8B 44 24 20 48 8B 00 48 83 C0 08 48 8B 4C 24 20 48 89 01 48 8B 44 24 20 48 8B 00 48 8B 40 F8 48 89 04 24 48 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_110_9_0 {
	meta:
		name = "get_int_arg"
		size = 96
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 33 C0 85 C0 74 27 48 8B 44 24 20 48 8B 00 48 83 C0 08 48 8B 4C 24 20 48 89 01 48 8B 44 24 20 48 8B 00 48 8B 40 F8 8B 00 89 04 24 EB 22 48 8B 44 24 20 48 8B 00 48 83 C0 08 48 8B 4C 24 20 48 89 01 48 8B 44 24 20 48 8B 00 8B 40 F8 89 04 24 8B 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_110_10_0 {
	meta:
		name = "get_short_arg"
		size = 101
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 33 C0 85 C0 74 29 48 8B 44 24 20 48 8B 00 48 83 C0 08 48 8B 4C 24 20 48 89 01 48 8B 44 24 20 48 8B 00 48 8B 40 F8 0F B7 00 66 89 04 24 EB 24 48 8B 44 24 20 48 8B 00 48 83 C0 08 48 8B 4C 24 20 48 89 01 48 8B 44 24 20 48 8B 00 0F B7 40 F8 66 89 04 24 0F B7 04 24 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_110_11_0 {
	meta:
		name = "write_char"
		size = 64
		refs = "0015 _putch_nolock"
	strings:
		$1 = { 48 89 54 24 10 88 4C 24 08 48 83 EC 28 0F BE 44 24 30 8B C8 E8 ?? ?? ?? ?? 83 F8 FF 75 0D 48 8B 44 24 38 C7 00 FF FF FF FF EB 10 48 8B 44 24 38 8B 00 FF C0 48 8B 4C 24 38 89 01 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_110_12_0 {
	meta:
		name = "write_multi_char"
		size = 76
		refs = "0035 write_char"
	strings:
		$1 = { 4C 89 44 24 18 89 54 24 10 88 4C 24 08 48 83 EC 38 8B 44 24 48 89 44 24 20 8B 44 24 48 FF C8 89 44 24 48 83 7C 24 20 00 7E 1D 48 8B 54 24 50 0F B6 4C 24 40 E8 ?? ?? ?? ?? 48 8B 44 24 50 83 38 FF 75 02 EB 02 EB CA 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_110_13_0 {
	meta:
		name = "write_string"
		size = 174
		refs = "005d write_char"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 89 54 24 10 48 89 4C 24 08 48 83 EC 38 48 8B 44 24 58 8B 00 89 44 24 28 48 8B 44 24 58 C7 00 00 00 00 00 8B 44 24 48 89 44 24 24 8B 44 24 48 FF C8 89 44 24 48 83 7C 24 24 00 7E 4E 48 8B 44 24 40 0F B6 00 88 44 24 20 48 8B 54 24 50 0F B6 4C 24 20 E8 ?? ?? ?? ?? 48 8B 44 24 40 48 FF C0 48 89 44 24 40 48 8B 44 24 50 83 38 FF 75 1A 48 8B 44 24 58 83 38 2A 75 0E 48 8B 54 24 50 B1 3F E8 ?? ?? ?? ?? EB 02 EB 02 EB 99 48 8B 44 24 58 83 38 00 75 0B 48 8B 44 24 58 8B 4C 24 28 89 08 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_111_4_0 {
	meta:
		name = "_mbctolower_l"
		size = 558
		refs = "001e ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 006e ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 00a1 ??1_LocaleUpdate@@QEAA@XZ 0133 __crtLCMapStringA"
	strings:
		$1 = { 48 89 54 24 10 89 4C 24 08 48 81 EC A8 00 00 00 48 8B 94 24 B8 00 00 00 48 8D 4C 24 70 E8 ?? ?? ?? ?? 81 BC 24 B0 00 00 00 FF 00 00 00 0F 86 7B 01 00 00 8B 84 24 B0 00 00 00 C1 E8 08 25 FF 00 00 00 B9 01 00 00 00 48 6B C9 00 88 44 0C 50 8B 84 24 B0 00 00 00 25 FF 00 00 00 B9 01 00 00 00 48 6B C9 01 88 44 0C 50 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 8B 40 08 B9 01 00 00 00 48 6B C9 00 0F B6 4C 0C 50 0F B6 44 08 19 83 E0 04 85 C0 75 1E 8B 84 24 B0 00 00 00 89 44 24 64 48 8D 4C 24 70 E8 ?? ?? ?? ?? 8B 44 24 64 E9 78 01 00 00 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 8B 40 08 48 89 84 24 90 00 00 00 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 8B 40 08 48 89 84 24 98 00 00 00 48 8D 4C 24 70 E8 ?? ?? ?? ?? C7 44 24 40 01 00 00 00 48 8B 8C 24 90 00 00 00 8B 49 04 89 4C 24 38 C7 44 24 30 02 00 00 00 48 8D 4C 24 54 48 89 4C 24 28 C7 44 24 20 02 00 00 00 4C 8D 4C 24 50 41 B8 00 01 00 00 48 8B 8C 24 98 00 00 00 48 8B 91 20 02 00 00 48 8B C8 E8 ?? ?? ?? ?? 85 C0 75 1E 8B 84 24 B0 00 00 00 89 44 24 5C 48 8D 4C 24 70 E8 ?? ?? ?? ?? 8B 44 24 5C E9 CD 00 00 00 B8 01 00 00 00 48 6B C0 01 0F B6 44 04 54 89 84 24 B0 00 00 00 B8 01 00 00 00 48 6B C0 00 0F B6 44 04 54 C1 E0 08 8B 8C 24 B0 00 00 00 03 C8 8B C1 89 84 24 B0 00 00 00 8B 84 24 B0 00 00 00 89 44 24 68 48 8D 4C 24 70 E8 ?? ?? ?? ?? 8B 44 24 68 EB 7A EB 6E 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 8B 40 08 8B 8C 24 B0 00 00 00 FF C1 48 63 C9 0F B6 44 08 18 83 E0 10 83 F8 10 75 24 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 8B 40 08 48 63 8C 24 B0 00 00 00 0F B6 84 08 19 01 00 00 89 44 24 58 EB 0B 8B 84 24 B0 00 00 00 89 44 24 58 8B 44 24 58 89 44 24 60 48 8D 4C 24 70 E8 ?? ?? ?? ?? 8B 44 24 60 EB 0A 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 81 C4 A8 00 00 00 C3 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "_difftime64"
		size = 72
		refs = "001f _errno"
	strings:
		$1 = { 48 89 54 24 10 48 89 4C 24 08 48 83 EC 28 48 83 7C 24 38 00 7C 08 48 83 7C 24 30 00 7D 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 0F 57 C0 EB 15 48 8B 44 24 38 48 8B 4C 24 30 48 2B C8 48 8B C1 F2 48 0F 2A C0 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_114_0_0 {
	meta:
		name = "fesetexceptflag"
		size = 126
		refs = "0025 _getfpstatusword 005d _setfpstatusword 0066 fetestexcept"
	strings:
		$1 = { 89 54 24 10 48 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 8B 44 24 48 83 E0 1F 85 C0 75 04 33 C0 EB 55 E8 ?? ?? ?? ?? 89 44 24 20 8B 44 24 48 F7 D0 8B 4C 24 20 23 C8 8B C1 89 44 24 20 48 8B 44 24 40 8B 4C 24 48 8B 00 23 C1 8B 4C 24 20 0B C8 8B C1 89 44 24 20 8B 4C 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 E8 ?? ?? ?? ?? 3B 44 24 20 74 07 B8 01 00 00 00 EB 02 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_116_3_0 {
	meta:
		name = "__ascii_strnicmp"
		size = 219
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 18 48 83 7C 24 30 00 0F 84 B5 00 00 00 C7 04 24 00 00 00 00 C7 44 24 04 00 00 00 00 48 8B 44 24 20 0F B6 00 89 04 24 8B 04 24 89 44 24 08 48 8B 44 24 20 48 FF C0 48 89 44 24 20 83 7C 24 08 41 7C 0F 83 3C 24 5A 7F 09 8B 04 24 83 C0 20 89 04 24 48 8B 44 24 28 0F B6 00 89 44 24 04 8B 44 24 04 89 44 24 0C 48 8B 44 24 28 48 FF C0 48 89 44 24 28 83 7C 24 0C 41 7C 12 83 7C 24 04 5A 7F 0B 8B 44 24 04 83 C0 20 89 44 24 04 48 8B 44 24 30 48 FF C8 48 89 44 24 30 48 83 7C 24 30 00 74 13 83 3C 24 00 74 0D 8B 44 24 04 39 04 24 0F 84 69 FF FF FF 8B 44 24 04 8B 0C 24 2B C8 8B C1 EB 04 EB 02 33 C0 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_116_4_0 {
	meta:
		name = "_strnicmp"
		size = 588
		refs = "0015 __locale_changed 004c ??_C@_1BI@GKKCBDMD@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0058 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 006d ??_C@_1FG@NEKCMHCI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?2@ 0077 _CrtDbgReportW 008b _errno 00ae ??_C@_1BE@BHJDFFNA@?$AA_?$AAs?$AAt?$AAr?$AAn?$AAi?$AAc?$AAm?$AAp?$AA?$AA@ 00ba _invalid_parameter 00f4 ??_C@_1BI@DCHLDCPP@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 019f ??_C@_1CC@JLPHKJPH@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 0228 __ascii_strnicmp 0243 _strnicmp_l"
	strings:
		$1 = { 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 83 EC 58 83 3D ?? ?? ?? ?? 00 0F 85 10 02 00 00 48 83 7C 24 60 00 74 0A C7 44 24 30 01 00 00 00 EB 08 C7 44 24 30 00 00 00 00 8B 44 24 30 89 44 24 34 83 7C 24 34 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 82 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 34 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 82 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF 7F E9 7F 01 00 00 48 83 7C 24 68 00 74 0A C7 44 24 38 01 00 00 00 EB 08 C7 44 24 38 00 00 00 00 8B 44 24 38 89 44 24 3C 83 7C 24 3C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 83 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 3C 00 75 3E E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 83 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF 7F E9 D7 00 00 00 48 81 7C 24 70 FF FF FF 7F 77 0A C7 44 24 40 01 00 00 00 EB 08 C7 44 24 40 00 00 00 00 8B 44 24 40 89 44 24 44 83 7C 24 44 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 84 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 44 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 84 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? B8 FF FF FF 7F EB 2F 4C 8B 44 24 70 48 8B 54 24 68 48 8B 4C 24 60 E8 ?? ?? ?? ?? EB 19 EB 17 45 33 C9 4C 8B 44 24 70 48 8B 54 24 68 48 8B 4C 24 60 E8 ?? ?? ?? ?? 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_116_5_0 {
	meta:
		name = "_strnicmp_l"
		size = 930
		refs = "0038 ??0_LocaleUpdate@@QEAA@PEAUlocaleinfo_struct@@@Z 006b ??_C@_1BI@GKKCBDMD@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0077 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 008c ??_C@_1FG@NEKCMHCI@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?2@ 0096 _CrtDbgReportW 00aa _errno 00cd ??_C@_1BI@BJLEPLEF@?$AA_?$AAs?$AAt?$AAr?$AAn?$AAi?$AAc?$AAm?$AAp?$AA_?$AAl?$AA?$AA@ 00d9 _invalid_parameter 00eb ??1_LocaleUpdate@@QEAA@XZ 0127 ??_C@_1BI@DCHLDCPP@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 01e6 ??_C@_1CC@JLPHKJPH@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 0279 ?GetLocaleT@_LocaleUpdate@@QEAAPEAUlocaleinfo_struct@@XZ 02ad __ascii_strnicmp 02ee _tolower_l"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 48 89 54 24 10 48 89 4C 24 08 48 81 EC 98 00 00 00 48 83 BC 24 B0 00 00 00 00 0F 84 6E 03 00 00 48 8B 94 24 B8 00 00 00 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 83 BC 24 A0 00 00 00 00 74 0A C7 44 24 4C 01 00 00 00 EB 08 C7 44 24 4C 00 00 00 00 8B 44 24 4C 89 44 24 48 83 7C 24 48 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3B 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 48 00 75 4F E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3B 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 50 FF FF FF 7F 48 8D 4C 24 70 E8 ?? ?? ?? ?? 8B 44 24 50 E9 A2 02 00 00 48 83 BC 24 A8 00 00 00 00 74 0A C7 44 24 40 01 00 00 00 EB 08 C7 44 24 40 00 00 00 00 8B 44 24 40 89 44 24 38 83 7C 24 38 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3C 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 38 00 75 4F E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3C 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 58 FF FF FF 7F 48 8D 4C 24 70 E8 ?? ?? ?? ?? 8B 44 24 58 E9 E6 01 00 00 48 81 BC 24 B0 00 00 00 FF FF FF 7F 77 0A C7 44 24 3C 01 00 00 00 EB 08 C7 44 24 3C 00 00 00 00 8B 44 24 3C 89 44 24 44 83 7C 24 44 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 3D 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 44 00 75 4F E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 3D 00 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 68 FF FF FF 7F 48 8D 4C 24 70 E8 ?? ?? ?? ?? 8B 44 24 68 E9 27 01 00 00 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 8B 00 B9 08 00 00 00 48 6B C9 02 48 83 BC 08 28 01 00 00 00 75 39 4C 8B 84 24 B0 00 00 00 48 8B 94 24 A8 00 00 00 48 8B 8C 24 A0 00 00 00 E8 ?? ?? ?? ?? 89 44 24 60 48 8D 4C 24 70 E8 ?? ?? ?? ?? 8B 44 24 60 E9 D2 00 00 00 E9 AB 00 00 00 48 8B 84 24 A0 00 00 00 0F B6 00 89 44 24 54 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 8B D0 8B 4C 24 54 E8 ?? ?? ?? ?? 89 44 24 30 48 8B 84 24 A0 00 00 00 48 FF C0 48 89 84 24 A0 00 00 00 48 8B 84 24 A8 00 00 00 0F B6 00 89 44 24 5C 48 8D 4C 24 70 E8 ?? ?? ?? ?? 48 8B D0 8B 4C 24 5C E8 ?? ?? ?? ?? 89 44 24 34 48 8B 84 24 A8 00 00 00 48 FF C0 48 89 84 24 A8 00 00 00 48 8B 84 24 B0 00 00 00 48 FF C8 48 89 84 24 B0 00 00 00 48 83 BC 24 B0 00 00 00 00 74 15 83 7C 24 30 00 74 0E 8B 44 24 34 39 44 24 30 0F 84 55 FF FF FF 8B 44 24 34 8B 4C 24 30 2B C8 8B C1 89 44 24 64 48 8D 4C 24 70 E8 ?? ?? ?? ?? 8B 44 24 64 EB 02 33 C0 48 81 C4 98 00 00 00 C3 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "__static_scalar_sin"
		size = 1264
		refs = "000c __spec_table"
	strings:
		$1 = { 53 56 57 41 54 48 83 EC 58 48 8D 05 ?? ?? ?? ?? F2 0F 11 84 24 80 00 00 00 48 89 44 24 40 0F 29 74 24 30 0F 29 7C 24 20 F2 0F 10 84 24 80 00 00 00 4C 8B 64 24 40 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 0F 84 81 04 00 00 8B C8 81 E9 60 3F 00 00 C1 E9 07 81 E1 FC FF 00 00 4D 8D 9C 24 E0 00 00 00 49 03 CB 66 48 0F 7E C0 44 8B 51 14 44 8B 41 18 8B D0 48 C1 E8 15 0D 00 00 00 80 C1 E8 0B 45 8B CA 4C 0F AF D2 4C 0F AF C8 4C 0F AF C0 8B 71 10 8B 79 0C 45 8B DA 49 C1 EA 20 4D 03 CA 4D 03 D8 45 8B C3 49 C1 EB 20 4D 03 CB 44 8B D6 48 0F AF F2 4C 0F AF D0 44 8B DF 48 0F AF FA 8B DE 48 C1 EE 20 4C 03 CB 41 8B D9 49 C1 E9 20 4C 03 D6 4D 03 D1 48 C1 E3 20 4C 0B C3 4C 0F AF D8 44 8B 49 08 8B 71 04 8B DF 48 C1 EF 20 4C 03 D3 41 8B DA 49 C1 EA 20 4C 03 DF 4D 03 DA 49 8B F9 4C 0F AF CA 48 0F AF F8 45 8B D1 49 C1 E9 20 4D 03 DA 45 8B D3 49 C1 EB 20 49 03 F9 49 03 FB 4C 8B CE 48 0F AF F2 4C 0F AF C8 49 C1 E2 20 4C 0B D3 8B 01 44 8B DE 48 C1 EE 20 49 03 FB 44 8B DF 48 C1 EF 20 4C 03 CE 4C 03 CF 48 0F AF D0 66 0F C5 D8 03 49 8D BC 24 E0 00 00 00 48 2B CF 03 C9 03 C9 03 C9 83 C1 13 BE 00 80 00 00 23 F3 C1 EB 04 81 E3 FF 07 00 00 81 EB FF 03 00 00 2B CB 4C 03 CA 8B D1 83 C2 20 83 F9 01 0F 8C 89 02 00 00 F7 D9 83 C1 1D 41 D3 E1 41 8B F9 41 81 E1 FF FF FF 1F 41 F7 C1 00 00 00 10 0F 85 93 02 00 00 41 D3 E9 BB 00 00 00 00 49 C1 E1 20 4D 0B CB 49 83 F9 00 0F 84 F4 01 00 00 4D 0F BD D9 B9 1D 00 00 00 41 2B CB 0F 8E 1C 02 00 00 49 D3 E1 49 8B C2 49 D3 E2 03 D1 F7 D9 83 C1 40 48 D3 E8 49 D3 E8 4C 0B C8 4D 0B D0 F2 49 0F 2A C1 49 D1 EA F2 49 0F 2A DA 66 0F 57 E4 C1 E2 04 F7 DA 81 C2 F0 3F 00 00 0B D6 33 D3 66 0F C4 E2 03 F3 41 0F 7E 94 24 D0 00 00 00 F3 41 0F 7E B4 24 D8 00 00 00 66 0F 57 ED 81 EA F0 03 00 00 66 0F C4 EA 03 F2 0F 59 C4 C1 E6 10 C1 FE 1F F2 0F 59 DD F3 0F 7E C8 F2 0F 59 C2 C1 EF 1D F2 0F 58 CB F2 0F 59 DA 03 FE 33 FE F2 0F 59 F1 8B C7 F2 0F 58 F3 F3 0F 7E D0 F2 0F 58 C6 F2 0F 5C D0 F2 0F 58 F2 F3 41 0F 7E 4C 24 70 F2 0F 59 C8 F3 41 0F 7E 94 24 80 00 00 00 F2 0F 2D D1 F2 0F 58 CA F3 41 0F 7E 5C 24 50 F2 0F 5C CA 66 41 0F 28 54 24 40 F2 0F 59 D9 66 0F 14 C9 C1 E0 03 81 C2 00 76 1C 00 F3 0F 7E E0 03 D0 83 E2 3F 66 41 0F 28 6C 24 30 49 8D 84 24 90 01 00 00 C1 E2 05 48 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 41 0F 59 4C 24 60 F2 0F 5C E3 F3 0F 7E 78 08 66 0F 14 C0 F3 0F 7E DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F3 0F 7E 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 5C CE 66 41 0F 28 74 24 10 F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 41 0F 58 6C 24 20 F2 0F 59 20 66 41 0F 58 34 24 66 0F 59 E8 F3 0F 7E C3 F2 0F 58 58 08 66 0F 59 CF F3 0F 7E FC F2 0F 58 E3 66 0F 58 F5 F3 0F 7E 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F3 0F 7E C4 F2 0F 58 CE F2 0F 58 C1 E9 13 01 00 00 83 C2 40 4D 8B CA 4D 8B D0 49 C7 C0 00 00 00 00 49 83 F9 00 0F 85 F2 FD FF FF 83 C2 40 4D 8B CA 4D 8B D0 49 83 F9 00 0F 85 DF FD FF FF 66 0F 57 C0 66 0F 57 F6 E9 87 FE FF FF 0F 84 FA FD FF FF F7 D9 49 D3 EA 49 8B C1 49 D3 E9 2B D1 F7 D9 83 C1 40 48 D3 E0 4C 0B D0 E9 DD FD FF FF F7 D9 49 C1 E1 20 4D 0B CB 49 D3 E1 49 8B F9 41 F7 C1 00 00 00 80 75 56 41 D3 E9 BB 00 00 00 00 48 C1 EF 03 E9 7C FD FF FF 41 D3 E9 BB 00 00 00 20 D3 EB 49 C1 E1 20 4D 0B CB 48 C1 E3 20 81 C7 00 00 00 20 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 E9 37 FD FF FF 41 D3 E9 48 BB 00 00 00 00 01 00 00 00 48 D3 EB 48 C7 C1 00 00 00 00 49 C7 C3 00 00 00 00 49 2B C8 4D 1B DA 49 1B D9 4C 8B C1 4D 8B D3 4C 8B CB BB 00 80 00 00 48 C1 EF 03 81 C7 00 00 00 20 E9 F3 FC FF FF F2 0F 5C C0 F2 0F 11 44 24 48 0F 28 74 24 30 0F 28 7C 24 20 F2 0F 10 44 24 48 48 83 C4 58 41 5C 5F 5E 5B C3 }
	condition:
		$1
}

rule file_117_1_0 {
	meta:
		name = "__sse2_sin2"
		size = 1216
		refs = "001f MMDPI1 002b MMDINVPI 0033 MMIABSMASK 003b MMDPI2 0043 MMDPI3 004b MMDRSHIFT 005f MMDHUGE 0073 MMDPI4 00a8 MMDA8 00b0 MMDA7 00cc MMDA6 00d4 MMDA5 00e4 MMDA4 00ec MMDA3 00fc MMDA2 0104 MMDA1 014f flAllOnes 015d MMISIGNMASK 0177 TWO_POW_30 01f8 THE_PI02_INV 020d MMI_ONE 0215 MSK_LOW_BIT 021d RS 0231 PI02C_0 023d PI02C_1 024d PI02C_2 027e PI02C_3 02aa PI02C_4"
	strings:
		$1 = { 48 81 EC D8 00 00 00 0F 29 BC 24 C0 00 00 00 0F 29 B4 24 B0 00 00 00 66 0F 28 F8 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 D0 66 0F 59 05 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 58 05 ?? ?? ?? ?? 66 0F 28 D8 66 0F 5C 05 ?? ?? ?? ?? 66 0F 66 3D ?? ?? ?? ?? 66 0F 50 C7 0B C0 0F 85 C9 00 00 00 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F 57 C3 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 C7 44 24 20 00 00 00 00 66 0F 70 FF F5 66 0F 29 7C 24 30 66 0F 57 3D ?? ?? ?? ?? 66 0F 29 7C 24 40 66 0F 28 3D ?? ?? ?? ?? 66 0F 54 FA 66 0F 29 54 24 50 66 0F 54 15 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 66 CA 66 0F 50 D1 66 0F 29 7C 24 60 66 0F 29 54 24 70 83 F2 03 0F 85 E0 01 00 00 83 F8 03 74 57 66 0F 28 54 24 50 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 54 5C 24 40 66 0F 5C D7 66 0F 54 54 24 40 66 0F 29 9C 24 80 00 00 00 66 0F 29 94 24 90 00 00 00 66 0F 28 54 24 70 66 0F 28 1D ?? ?? ?? ?? 66 0F 59 DA 66 0F E6 DB 66 0F 70 DB 10 66 0F FE 1D ?? ?? ?? ?? 66 0F DB 1D ?? ?? ?? ?? 66 0F 28 05 ?? ?? ?? ?? 66 0F 56 C3 66 0F 5C 05 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 E0 66 0F 5C D1 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 CA 66 0F 5C D4 66 0F 5C CA 66 0F 28 F2 66 0F 5C CC 66 0F 5C D5 66 0F 73 F3 3E 66 0F 5C F2 66 0F 28 FA 66 0F 28 25 ?? ?? ?? ?? 66 0F 5C F5 66 0F 58 CE 66 0F 58 D1 66 0F 59 E0 66 0F 5C FA 66 0F 28 EA 66 0F 5C D4 66 0F 58 CF 66 0F 5C EA 66 0F 59 05 ?? ?? ?? ?? 66 0F 5C EC 66 0F 58 CD 66 0F 5C C8 66 0F DB 1D ?? ?? ?? ?? 66 0F 58 D1 66 0F 57 5C 24 60 83 F8 03 74 1E 66 0F 54 54 24 30 66 0F 56 94 24 90 00 00 00 66 0F 54 5C 24 30 66 0F 56 9C 24 80 00 00 00 66 0F 28 CA 66 0F 59 D2 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F 57 C3 E9 EA 00 00 00 89 44 24 20 83 F8 03 0F 84 C0 00 00 00 66 0F 28 54 24 50 66 0F 28 3D ?? ?? ?? ?? 66 0F 59 E0 66 0F 59 E8 66 0F 59 F0 66 0F 59 F8 66 0F 73 F3 3F 66 0F 5C D4 66 0F 5C D5 66 0F 5C D6 66 0F 28 CA 66 0F 59 D2 66 0F 5C CF 66 0F 28 05 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 E2 66 0F 59 E4 66 0F 59 D1 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F4 66 0F 58 05 ?? ?? ?? ?? 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 C4 66 0F 59 F2 66 0F 59 C1 66 0F 58 F1 66 0F 58 C6 66 0F 57 C3 66 0F 29 84 24 A0 00 00 00 8B 44 24 20 A8 01 75 4B D1 F8 A8 01 75 27 D1 F8 89 44 24 20 66 0F 28 84 24 A0 00 00 00 0F 28 B4 24 B0 00 00 00 0F 28 BC 24 C0 00 00 00 48 81 C4 D8 00 00 00 C3 F2 0F 10 44 24 58 89 44 24 20 E8 87 F6 FF FF F2 0F 11 84 24 A8 00 00 00 8B 44 24 20 EB BB F2 0F 10 44 24 50 E8 6D F6 FF FF F2 0F 11 84 24 A0 00 00 00 8B 44 24 20 EB 9B 66 66 66 66 66 66 0F 1F 84 00 00 00 00 00 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "_fdexp"
		size = 1145
		refs = "001a _fdtest 009e _FInf_C 00c4 _fperrraise 00d1 _FNan_C 00fd __xmm@80000000800000008000000080000000 0178 _fdscale 0216 hugexp 0298 invln2 02b0 __real@bf000000 02c0 __real@3f000000 02f4 c1 0312 c23 0324 _FEps_C 037b c 03a3 s 03ea __real@3f800000"
	strings:
		$1 = { 44 89 44 24 18 F3 0F 11 4C 24 10 48 89 4C 24 08 48 83 EC 58 48 8B 4C 24 60 E8 ?? ?? ?? ?? 66 89 44 24 20 48 8D 4C 24 68 E8 ?? ?? ?? ?? 66 89 44 24 28 0F BF 44 24 20 85 C0 7D 0D 0F BF 44 24 28 85 C0 0F 8C CA 01 00 00 0F BF 44 24 20 83 F8 02 75 0F B8 02 00 00 00 E9 18 04 00 00 E9 AC 01 00 00 0F BF 44 24 28 83 F8 02 75 1E 48 8B 44 24 60 F3 0F 10 44 24 68 F3 0F 11 00 B8 02 00 00 00 E9 F0 03 00 00 E9 84 01 00 00 0F BF 44 24 28 85 C0 75 56 48 8B 44 24 60 F3 0F 10 00 0F 2E 05 ?? ?? ?? ?? 7A 02 74 18 48 8B 44 24 60 F3 0F 10 44 24 68 F3 0F 11 00 33 C0 E9 B8 03 00 00 EB 25 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 60 F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 00 B8 02 00 00 00 E9 91 03 00 00 E9 25 01 00 00 0F BF 44 24 28 83 F8 01 75 64 F3 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 48 8B 44 24 60 F3 0F 10 08 0F 2E C8 7A 02 74 1B 48 8B 44 24 60 F3 0F 10 44 24 68 F3 0F 11 00 B8 01 00 00 00 E9 4A 03 00 00 EB 25 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 8B 44 24 60 F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 00 B8 02 00 00 00 E9 23 03 00 00 E9 B7 00 00 00 0F BF 44 24 20 85 C0 75 5D 48 8B 44 24 60 F3 0F 10 44 24 68 F3 0F 11 00 8B 54 24 70 48 8B 4C 24 60 E8 ?? ?? ?? ?? 66 89 44 24 20 0F BF 44 24 20 89 44 24 40 83 7C 24 40 00 74 09 83 7C 24 40 01 74 0E EB 16 B9 10 00 00 00 E8 ?? ?? ?? ?? EB 0A B9 08 00 00 00 E8 ?? ?? ?? ?? 0F B7 44 24 20 E9 BA 02 00 00 EB 51 48 8B 44 24 60 F3 0F 10 00 0F 2E 05 ?? ?? ?? ?? 7A 26 75 24 48 8B 44 24 60 F3 0F 10 00 F3 0F 59 44 24 68 48 8B 44 24 60 F3 0F 11 00 B8 01 00 00 00 E9 82 02 00 00 EB 19 0F 57 C0 F3 0F 59 44 24 68 48 8B 44 24 60 F3 0F 11 00 33 C0 E9 67 02 00 00 E9 62 02 00 00 F3 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? 48 8B 44 24 60 0F 2F 00 76 1E 0F 57 C0 F3 0F 59 44 24 68 48 8B 44 24 60 F3 0F 11 00 33 C0 E9 30 02 00 00 E9 2B 02 00 00 48 8B 44 24 60 F3 0F 10 00 0F 2F 05 ?? ?? ?? ?? 76 30 F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 44 24 68 48 8B 44 24 60 F3 0F 11 00 B9 08 00 00 00 E8 ?? ?? ?? ?? B8 01 00 00 00 E9 EE 01 00 00 E9 E9 01 00 00 48 8B 44 24 60 F3 0F 10 00 F3 0F 59 05 ?? ?? ?? ?? F3 0F 11 44 24 24 0F 57 C0 0F 2F 44 24 24 76 10 F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 44 24 2C EB 0E F3 0F 10 05 ?? ?? ?? ?? F3 0F 11 44 24 2C F3 0F 10 44 24 24 F3 0F 58 44 24 2C F3 0F 2C C0 89 44 24 3C F3 0F 2A 44 24 3C F3 0F 11 44 24 24 F3 0F 10 44 24 24 F3 0F 59 05 ?? ?? ?? ?? 48 8B 44 24 60 F3 0F 10 08 F3 0F 5C C8 0F 28 C1 F3 0F 10 4C 24 24 F3 0F 59 0D ?? ?? ?? ?? F3 0F 5C C1 F3 0F 11 44 24 24 F3 0F 10 05 ?? ?? ?? ?? 0F 57 05 ?? ?? ?? ?? F3 0F 10 4C 24 24 0F 2F C8 76 23 F3 0F 10 05 ?? ?? ?? ?? 0F 2F 44 24 24 76 14 48 8B 44 24 60 F3 0F 10 44 24 68 F3 0F 11 00 E9 C6 00 00 00 F3 0F 10 44 24 24 F3 0F 59 44 24 24 F3 0F 11 44 24 38 B8 04 00 00 00 48 6B C0 00 48 8D 0D ?? ?? ?? ?? F3 0F 10 04 01 F3 0F 10 4C 24 38 F3 0F 59 C8 0F 28 C1 F3 0F 11 44 24 30 B8 04 00 00 00 48 6B C0 00 48 8D 0D ?? ?? ?? ?? F3 0F 10 04 01 F3 0F 59 44 24 38 B8 04 00 00 00 48 6B C0 01 48 8D 0D ?? ?? ?? ?? F3 0F 58 04 01 F3 0F 10 4C 24 24 F3 0F 59 C8 0F 28 C1 F3 0F 11 44 24 34 F3 0F 10 44 24 30 F3 0F 58 44 24 34 F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 C8 0F 28 C1 F3 0F 10 4C 24 30 F3 0F 5C 4C 24 34 F3 0F 10 15 ?? ?? ?? ?? F3 0F 58 D1 0F 28 CA F3 0F 5E C1 F3 0F 59 44 24 68 48 8B 44 24 60 F3 0F 11 00 8B 44 24 70 8B 4C 24 3C 03 C8 8B C1 8B D0 48 8B 4C 24 60 E8 ?? ?? ?? ?? 66 89 44 24 20 0F BF 44 24 20 89 44 24 44 83 7C 24 44 00 74 09 83 7C 24 44 01 74 0E EB 16 B9 10 00 00 00 E8 ?? ?? ?? ?? EB 0A B9 08 00 00 00 E8 ?? ?? ?? ?? 0F B7 44 24 20 48 83 C4 58 C3 }
	condition:
		$1
}

rule file_118_1_0 {
	meta:
		name = "exp2f"
		size = 371
		refs = "0010 _fdtest 0078 __real@3f800000 0085 __real@cf000000 0099 __real@4f000000 00c0 _fd_int 00ea __real@3f000000 0114 __real@bf000000 0147 ln2 0164 _fdexp"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 38 48 8D 4C 24 40 E8 ?? ?? ?? ?? 98 89 44 24 24 83 7C 24 24 00 74 54 83 7C 24 24 01 74 14 83 7C 24 24 02 74 02 EB 51 F3 0F 10 44 24 40 E9 33 01 00 00 B8 02 00 00 00 48 6B C0 01 0F B7 44 04 40 25 00 80 00 00 85 C0 74 0B 0F 57 C0 F3 0F 11 44 24 2C EB 0C F3 0F 10 44 24 40 F3 0F 11 44 24 2C F3 0F 10 44 24 2C E9 FA 00 00 00 F3 0F 10 05 ?? ?? ?? ?? E9 ED 00 00 00 F3 0F 10 05 ?? ?? ?? ?? 0F 2F 44 24 40 73 0F F3 0F 10 44 24 40 0F 2F 05 ?? ?? ?? ?? 72 0D C7 44 24 20 00 00 00 00 E9 91 00 00 00 F3 0F 10 44 24 40 F3 0F 11 44 24 28 33 D2 48 8D 4C 24 28 E8 ?? ?? ?? ?? F3 0F 2C 44 24 28 98 89 44 24 20 F3 0F 10 44 24 40 F3 0F 5C 44 24 28 F3 0F 11 44 24 40 F3 0F 10 44 24 40 0F 2F 05 ?? ?? ?? ?? 76 20 F3 0F 10 44 24 40 F3 0F 5C 05 ?? ?? ?? ?? F3 0F 11 44 24 40 8B 44 24 20 FF C0 89 44 24 20 EB 2D F3 0F 10 05 ?? ?? ?? ?? 0F 2F 44 24 40 76 1E F3 0F 10 44 24 40 F3 0F 58 05 ?? ?? ?? ?? F3 0F 11 44 24 40 8B 44 24 20 FF C8 89 44 24 20 F3 0F 10 44 24 40 F3 0F 59 05 ?? ?? ?? ?? F3 0F 11 44 24 40 44 8B 44 24 20 F3 0F 10 0D ?? ?? ?? ?? 48 8D 4C 24 40 E8 ?? ?? ?? ?? F3 0F 10 44 24 40 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_120_0_0 {
	meta:
		name = "llroundf"
		size = 119
		refs = "0010 _fdtest 0035 roundf 0048 __real@df000000 0052 __real@5f000000 006c _fperrraise"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 38 48 8D 4C 24 40 E8 ?? ?? ?? ?? 98 89 44 24 20 83 7C 24 20 00 74 50 83 7C 24 20 00 7E 07 83 7C 24 20 02 7E 38 F3 0F 10 44 24 40 E8 ?? ?? ?? ?? F3 0F 11 44 24 40 F3 0F 10 44 24 40 0F 2F 05 ?? ?? ?? ?? 72 18 F3 0F 10 05 ?? ?? ?? ?? 0F 2F 44 24 40 72 09 F3 48 0F 2C 44 24 40 EB 0C B9 01 00 00 00 E8 ?? ?? ?? ?? 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "__free_lconv_num"
		size = 210
		refs = "001e __lconv_c 0035 _free_dbg"
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 28 48 83 7C 24 30 00 75 05 E9 B7 00 00 00 48 8B 44 24 30 48 8B 0D ?? ?? ?? ?? 48 39 08 74 12 BA 02 00 00 00 48 8B 44 24 30 48 8B 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 0D ?? ?? ?? ?? 48 39 48 08 74 13 BA 02 00 00 00 48 8B 44 24 30 48 8B 48 08 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 0D ?? ?? ?? ?? 48 39 48 10 74 13 BA 02 00 00 00 48 8B 44 24 30 48 8B 48 10 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 0D ?? ?? ?? ?? 48 39 48 58 74 13 BA 02 00 00 00 48 8B 44 24 30 48 8B 48 58 E8 ?? ?? ?? ?? 48 8B 44 24 30 48 8B 0D ?? ?? ?? ?? 48 39 48 60 74 13 BA 02 00 00 00 48 8B 44 24 30 48 8B 48 60 E8 ?? ?? ?? ?? 48 83 C4 28 C3 }
	condition:
		$1
}

rule file_121_1_0 {
	meta:
		name = "__init_numeric"
		size = 1204
		refs = "0079 ??_C@_0CI@GAAFLELF@f?3?2dd?2vctools?2crt?2crtw32?2misc?2in@ 008e _calloc_dbg 00df _malloc_dbg 00fb _free_dbg 01ce __getlocaleinfo 02bb __free_lconv_num 02f1 fix_grouping 0308 __lconv_c 03d4 ??_C@_1DM@IFKAINNE@?$AAp?$AAl?$AAo?$AAc?$AAi?$AA?9?$AA?$DO?$AAl?$AAc?$AAo?$AAn?$AAv?$AA_?$AAn?$AAu?$AAm?$AA_?$AAr?$AAe?$AAf?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 03e0 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 03f5 ??_C@_1FA@OEEOKLKJ@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAm?$AAi?$AAs?$AAc?$AA?2?$AAi?$AAn@ 03ff _CrtDbgReportW"
	strings:
		$1 = { 48 89 4C 24 08 56 57 48 83 EC 78 C7 44 24 30 00 00 00 00 48 C7 44 24 40 00 00 00 00 48 8B 84 24 90 00 00 00 48 89 44 24 58 48 C7 44 24 60 00 00 00 00 B8 08 00 00 00 48 6B C0 04 48 8B 8C 24 90 00 00 00 48 83 BC 01 28 01 00 00 00 75 20 B8 08 00 00 00 48 6B C0 03 48 8B 8C 24 90 00 00 00 48 83 BC 01 28 01 00 00 00 0F 84 01 03 00 00 C7 44 24 20 65 00 00 00 4C 8D 0D ?? ?? ?? ?? 41 B8 02 00 00 00 BA 98 00 00 00 B9 01 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 38 48 83 7C 24 38 00 75 0A B8 01 00 00 00 E9 04 04 00 00 48 8B 84 24 90 00 00 00 48 8B 80 F0 00 00 00 48 8B 7C 24 38 48 8B F0 B9 98 00 00 00 F3 A4 41 B9 71 00 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 B9 04 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 48 48 83 7C 24 48 00 75 19 BA 02 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? B8 01 00 00 00 E9 A4 03 00 00 48 8B 44 24 48 C7 00 00 00 00 00 B8 08 00 00 00 48 6B C0 04 48 8B 8C 24 90 00 00 00 48 83 BC 01 28 01 00 00 00 0F 84 C3 01 00 00 41 B9 7D 00 00 00 4C 8D 05 ?? ?? ?? ?? BA 02 00 00 00 B9 04 00 00 00 E8 ?? ?? ?? ?? 48 89 44 24 40 48 83 7C 24 40 00 75 28 BA 02 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 48 E8 ?? ?? ?? ?? B8 01 00 00 00 E9 28 03 00 00 48 8B 44 24 40 C7 00 00 00 00 00 B8 08 00 00 00 48 6B C0 04 48 8B 8C 24 90 00 00 00 48 8B 84 01 28 01 00 00 48 89 44 24 50 48 8B 44 24 38 48 89 44 24 20 41 B9 0E 00 00 00 4C 8B 44 24 50 BA 01 00 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 8B 4C 24 30 0B C8 8B C1 89 44 24 30 48 8B 44 24 38 48 83 C0 08 48 89 44 24 20 41 B9 0F 00 00 00 4C 8B 44 24 50 BA 01 00 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 8B 4C 24 30 0B C8 8B C1 89 44 24 30 48 8B 44 24 38 48 83 C0 10 48 89 44 24 20 41 B9 10 00 00 00 4C 8B 44 24 50 BA 01 00 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 8B 4C 24 30 0B C8 8B C1 89 44 24 30 48 8B 44 24 38 48 83 C0 58 48 89 44 24 20 41 B9 0E 00 00 00 4C 8B 44 24 50 BA 02 00 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 8B 4C 24 30 0B C8 8B C1 89 44 24 30 48 8B 44 24 38 48 83 C0 60 48 89 44 24 20 41 B9 0F 00 00 00 4C 8B 44 24 50 BA 02 00 00 00 48 8D 4C 24 58 E8 ?? ?? ?? ?? 8B 4C 24 30 0B C8 8B C1 89 44 24 30 83 7C 24 30 00 74 32 48 8B 4C 24 38 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 38 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 4C 24 48 E8 ?? ?? ?? ?? B8 FF FF FF FF E9 C6 01 00 00 48 8B 44 24 38 48 8B 48 10 E8 ?? ?? ?? ?? EB 58 48 C7 44 24 40 00 00 00 00 48 8B 44 24 38 48 8B 0D ?? ?? ?? ?? 48 89 08 48 8B 44 24 38 48 8B 0D ?? ?? ?? ?? 48 89 48 08 48 8B 44 24 38 48 8B 0D ?? ?? ?? ?? 48 89 48 10 48 8B 44 24 38 48 8B 0D ?? ?? ?? ?? 48 89 48 58 48 8B 44 24 38 48 8B 0D ?? ?? ?? ?? 48 89 48 60 48 8B 44 24 48 C7 00 01 00 00 00 48 83 7C 24 40 00 74 0B 48 8B 44 24 40 C7 00 01 00 00 00 EB 1E 48 C7 44 24 40 00 00 00 00 48 C7 44 24 48 00 00 00 00 48 8D 05 ?? ?? ?? ?? 48 89 44 24 38 48 8B 84 24 90 00 00 00 48 83 B8 E0 00 00 00 00 74 6C 48 8B 84 24 90 00 00 00 48 8B 80 E0 00 00 00 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 85 C0 75 4C 48 8B 84 24 90 00 00 00 48 83 B8 E0 00 00 00 00 77 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 C2 00 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 48 8B 84 24 90 00 00 00 48 83 B8 D8 00 00 00 00 74 52 48 8B 84 24 90 00 00 00 48 8B 80 D8 00 00 00 B9 FF FF FF FF F0 0F C1 08 FF C9 8B C1 85 C0 75 32 BA 02 00 00 00 48 8B 84 24 90 00 00 00 48 8B 88 D8 00 00 00 E8 ?? ?? ?? ?? BA 02 00 00 00 48 8B 84 24 90 00 00 00 48 8B 88 F0 00 00 00 E8 ?? ?? ?? ?? 48 8B 84 24 90 00 00 00 48 8B 4C 24 40 48 89 88 E0 00 00 00 48 8B 84 24 90 00 00 00 48 8B 4C 24 48 48 89 88 D8 00 00 00 48 8B 84 24 90 00 00 00 48 8B 4C 24 38 48 89 88 F0 00 00 00 33 C0 48 83 C4 78 5F 5E C3 }
	condition:
		$1
}

rule file_121_2_0 {
	meta:
		name = "fix_grouping"
		size = 167
	strings:
		$1 = { 48 89 4C 24 08 48 83 EC 18 48 8B 44 24 20 0F BE 00 85 C0 0F 84 89 00 00 00 48 8B 44 24 20 0F BE 00 83 F8 30 7C 2E 48 8B 44 24 20 0F BE 00 83 F8 39 7F 21 48 8B 44 24 20 0F BE 00 83 E8 30 48 8B 4C 24 20 88 01 48 8B 44 24 20 48 FF C0 48 89 44 24 20 EB 49 48 8B 44 24 20 0F BE 00 83 F8 3B 75 2F 48 8B 44 24 20 48 89 04 24 48 8B 04 24 48 8B 0C 24 0F B6 49 01 88 08 48 8B 04 24 48 FF C0 48 89 04 24 48 8B 04 24 0F BE 00 85 C0 75 DC EB 0D 48 8B 44 24 20 48 FF C0 48 89 44 24 20 E9 67 FF FF FF 48 83 C4 18 C3 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "acoshf"
		size = 274
		refs = "0010 _fdtest 005a __real@3f800000 006b _fperrraise 0073 _FNan_C 009d __real@40000000 00a5 _FEps_C 00e0 sqrtf 00f2 log1pf 0101 logf 0109 ln2"
	strings:
		$1 = { F3 0F 11 44 24 08 48 83 EC 38 48 8D 4C 24 40 E8 ?? ?? ?? ?? 98 89 44 24 20 83 7C 24 20 01 74 14 83 7C 24 20 02 74 02 EB 2D F3 0F 10 44 24 40 E9 D9 00 00 00 B8 02 00 00 00 48 6B C0 01 0F B7 44 04 40 25 00 80 00 00 85 C0 75 0B F3 0F 10 44 24 40 E9 B7 00 00 00 F3 0F 10 05 ?? ?? ?? ?? 0F 2F 44 24 40 76 1C B9 01 00 00 00 E8 ?? ?? ?? ?? F3 0F 10 05 ?? ?? ?? ?? E9 91 00 00 00 E9 8C 00 00 00 F3 0F 10 44 24 40 0F 2E 05 ?? ?? ?? ?? 7A 09 75 07 0F 57 C0 EB 76 EB 74 F3 0F 10 05 ?? ?? ?? ?? F3 0F 5E 05 ?? ?? ?? ?? 0F 2F 44 24 40 76 4A F3 0F 10 44 24 40 F3 0F 5C 05 ?? ?? ?? ?? F3 0F 11 44 24 24 F3 0F 10 44 24 40 F3 0F 58 05 ?? ?? ?? ?? F3 0F 10 4C 24 24 F3 0F 59 C8 0F 28 C1 E8 ?? ?? ?? ?? F3 0F 10 4C 24 24 F3 0F 58 C8 0F 28 C1 E8 ?? ?? ?? ?? EB 15 EB 13 F3 0F 10 44 24 40 E8 ?? ?? ?? ?? F3 0F 58 05 ?? ?? ?? ?? 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "feclearexcept"
		size = 123
		refs = "0027 _getfpstatusword 005a _setfpstatusword 0063 fetestexcept"
	strings:
		$1 = { 89 4C 24 08 48 83 EC 38 C7 44 24 20 00 00 00 00 8B 44 24 40 83 E0 1F 89 44 24 40 83 7C 24 40 00 75 04 33 C0 EB 50 E8 ?? ?? ?? ?? 89 44 24 20 8B 44 24 40 8B 4C 24 20 23 C8 8B C1 85 C0 75 04 33 C0 EB 33 8B 44 24 40 F7 D0 8B 4C 24 20 23 C8 8B C1 89 44 24 20 8B 4C 24 20 E8 ?? ?? ?? ?? 8B 4C 24 20 E8 ?? ?? ?? ?? 3B 44 24 20 74 07 B8 01 00 00 00 EB 02 33 C0 48 83 C4 38 C3 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "_setjmpex"
		size = 144
	strings:
		$1 = { 48 89 11 48 89 59 08 48 89 69 18 48 89 71 20 48 89 79 28 4C 89 61 30 4C 89 69 38 4C 89 71 40 4C 89 79 48 4C 8D 44 24 08 4C 89 41 10 4C 8B 04 24 4C 89 41 50 0F AE 59 58 D9 79 5C 66 0F 7F 71 60 66 0F 7F 79 70 66 44 0F 7F 81 80 00 00 00 66 44 0F 7F 89 90 00 00 00 66 44 0F 7F 91 A0 00 00 00 66 44 0F 7F 99 B0 00 00 00 66 44 0F 7F A1 C0 00 00 00 66 44 0F 7F A9 D0 00 00 00 66 44 0F 7F B1 E0 00 00 00 66 44 0F 7F B9 F0 00 00 00 33 C0 C3 }
	condition:
		$1
}

rule file_125_3_0 {
	meta:
		name = "?_W_expandtime@@YAHPEAUlocaleinfo_struct@@_WPEBUtm@@PEAPEA_WPEA_KPEAU__lc_time_data@@I@Z"
		size = 6203
		refs = "0045 __ImageBase 004d $LN128 0054 $LN129 00a6 ??_C@_1HE@BFLEOKFO@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAw?$AAd?$AAa?$AAy?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5@ 00b2 ??_C@_15GANGMFKL@?$AA?$CF?$AAs?$AA?$AA@ 00c7 ??_C@_1FC@MHEEEHDG@?$AAf?$AA?3?$AA?2?$AAd?$AAd?$AA?2?$AAv?$AAc?$AAt?$AAo?$AAo?$AAl?$AAs?$AA?2?$AAc?$AAr?$AAt?$AA?2?$AAc?$AAr?$AAt?$AAw?$AA3?$AA2?$AA?2?$AAt?$AAi?$AAm?$AAe?$AA?2?$AAw?$AAc@ 00d1 _CrtDbgReportW 00e5 _errno 0108 ??_C@_1BM@ONGGIHAI@?$AA_?$AAW?$AA_?$AAe?$AAx?$AAp?$AAa?$AAn?$AAd?$AAt?$AAi?$AAm?$AAe?$AA?$AA@ 0114 _invalid_parameter 014c ?_W_store_str@@YAXPEA_WPEAPEA_WPEA_K@Z 0296 ??_C@_1HC@OOAMILFB@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAm?$AAo?$AAn?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAt@ 0483 ?_W_store_winword@@YAHPEAUlocaleinfo_struct@@HPEBUtm@@PEAPEA_WPEA_KPEAU__lc_time_data@@@Z 066d ??_C@_1HG@NFHHOAD@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAm?$AAd?$AAa?$AAy?$AA?5?$AA?$DO?$AA?$DN?$AA1?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5@ 0712 ?_W_store_num@@YAXHHPEAPEA_WPEA_KI@Z 0764 ??_C@_1HG@KCGGFLNI@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAh?$AAo?$AAu?$AAr?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5@ 0985 ??_C@_1HI@HHCJCPE@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAy?$AAd?$AAa?$AAy?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5@ 0b84 ??_C@_1HC@IGKDPPHL@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAm?$AAi?$AAn?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAt@ 0d9d ??_C@_1HC@HLKHIKOB@?$AA?$CI?$AA?5?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAs?$AAe?$AAc?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?5?$AAt@ 138c ??_C@_1DC@NMCFBMJP@?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAy?$AAe?$AAa?$AAr?$AA?5?$AA?$DO?$AA?$DN?$AA0?$AA?5?$AA?$CJ?$AA?$AA@ 14a4 ??_C@_1HM@LBNGKIAD@?$AA?$CI?$AA?5?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?9?$AA?$DO?$AAt?$AAm?$AA_?$AAy?$AAe?$AAa?$AAr?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA?9?$AA1?$AA9?$AA0?$AA0?$AA?5?$AA?$CJ?$AA?5?$AA?$CG?$AA?$CG@ 1593 __tzset 15ca __tzname 160f _mbstowcs_s_l 163f ??_C@_1MM@JAKLBNNP@?$AA_?$AAm?$AAb?$AAs?$AAt?$AAo?$AAw?$AAc?$AAs?$AA_?$AAs?$AA_?$AAl?$AA?$CI?$AA?$CG?$AAw?$AAn?$AAu?$AAm?$AA?0?$AA?5?$AA?$CK?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?0?$AA?5?$AA?$CK?$AAl@ 1651 _invoke_watson_if_oneof 1719 ??_C@_1EG@JNJKHKFI@?$AA?$CI?$AA?5?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAd?$AAi?$AAr?$AAe?$AAc?$AAt?$AAi?$AAv?$AAe?$AA?$CC?$AA?5?$AA?0?$AA?5?$AA0@ 1764 $LN2 1768 $LN3 176c $LN64 1770 $LN60 1774 $LN47 1778 $LN45 177c $LN38 1780 $LN32 1784 $LN30 1788 $LN25 178c $LN12 1790 $LN8 1794 $LN6 1798 $LN66 179c $LN62 17a0 $LN58 17a4 $LN49 17a8 $LN42 17ac $LN40 17b0 $LN36 17b4 $LN27 17b8 $LN17 17bc $LN10 17c0 $LN1"
	strings:
		$1 = { 4C 89 4C 24 20 4C 89 44 24 18 66 89 54 24 10 48 89 4C 24 08 48 81 EC F8 00 00 00 0F B7 84 24 08 01 00 00 89 44 24 44 8B 44 24 44 83 E8 04 89 44 24 44 83 7C 24 44 76 0F 87 D3 16 00 00 48 63 44 24 44 48 8D 0D ?? ?? ?? ?? 0F B6 84 01 ?? ?? ?? ?? 8B 84 81 ?? ?? ?? ?? 48 03 C1 FF E0 48 8B 84 24 10 01 00 00 83 78 18 00 7C 1B 48 8B 84 24 10 01 00 00 83 78 18 06 7F 0D C7 84 24 D4 00 00 00 01 00 00 00 EB 0B C7 84 24 D4 00 00 00 00 00 00 00 8B 84 24 D4 00 00 00 89 44 24 54 83 7C 24 54 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 D0 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 54 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 D0 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 3A 16 00 00 48 8B 84 24 10 01 00 00 48 63 40 18 4C 8B 84 24 20 01 00 00 48 8B 94 24 18 01 00 00 48 8B 8C 24 28 01 00 00 48 8B 8C C1 60 01 00 00 E8 ?? ?? ?? ?? E9 FF 15 00 00 48 8B 84 24 10 01 00 00 83 78 18 00 7C 1B 48 8B 84 24 10 01 00 00 83 78 18 06 7F 0D C7 84 24 C4 00 00 00 01 00 00 00 EB 0B C7 84 24 C4 00 00 00 00 00 00 00 8B 84 24 C4 00 00 00 89 44 24 5C 83 7C 24 5C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 D9 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 5C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 D9 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 42 15 00 00 48 8B 84 24 10 01 00 00 48 63 40 18 4C 8B 84 24 20 01 00 00 48 8B 94 24 18 01 00 00 48 8B 8C 24 28 01 00 00 48 8B 8C C1 98 01 00 00 E8 ?? ?? ?? ?? E9 07 15 00 00 48 8B 84 24 10 01 00 00 83 78 10 00 7C 1B 48 8B 84 24 10 01 00 00 83 78 10 0B 7F 0D C7 84 24 A4 00 00 00 01 00 00 00 EB 0B C7 84 24 A4 00 00 00 00 00 00 00 8B 84 24 A4 00 00 00 89 44 24 64 83 7C 24 64 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 E1 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 64 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 E1 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 4A 14 00 00 48 8B 84 24 10 01 00 00 48 63 40 10 4C 8B 84 24 20 01 00 00 48 8B 94 24 18 01 00 00 48 8B 8C 24 28 01 00 00 48 8B 8C C1 D0 01 00 00 E8 ?? ?? ?? ?? E9 0F 14 00 00 48 8B 84 24 10 01 00 00 83 78 10 00 7C 1B 48 8B 84 24 10 01 00 00 83 78 10 0B 7F 0D C7 84 24 DC 00 00 00 01 00 00 00 EB 0B C7 84 24 DC 00 00 00 00 00 00 00 8B 84 24 DC 00 00 00 89 44 24 6C 83 7C 24 6C 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 45 33 C9 41 B8 E9 01 00 00 48 8D 15 ?? ?? ?? ?? B9 02 00 00 00 E8 ?? ?? ?? ?? 83 F8 01 75 03 CC 33 C0 83 7C 24 6C 00 75 3B E8 ?? ?? ?? ?? C7 00 16 00 00 00 48 C7 44 24 20 00 00 00 00 41 B9 E9 01 00 00 4C 8D 05 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 E9 52 13 00 00 48 8B 84 24 10 01 00 00 48 63 40 10 4C 8B 84 24 20 01 00 00 48 8B 94 24 18 01 00 00 48 8B 8C 24 28 01 00 00 48 8B 8C C1 30 02 00 00 E8 ?? ?? ?? ?? E9 17 13 00 00 83 BC 24 30 01 00 00 00 0F 84 EE 00 00 00 48 8B 84 24 28 01 00 00 48 89 44 24 28 48 8B 84 24 20 01 00 00 48 89 44 24 20 4C 8B 8C 24 18 01 00 00 4C 8B 84 24 10 01 00 00 BA 01 00 00 00 48 8B 8C 24 00 01 00 00 E8 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 C7 12 00 00 48 8B 84 24 20 01 00 00 48 83 38 00 75 07 33 C0 E9 B2 12 00 00 48 8B 84 24 18 01 00 00 48 8B 00 B9 20 00 00 00 66 89 08 48 8B 84 24 18 01 00 00 48 8B 00 48 83 C0 02 48 8B 8C 24 18 01 00 00 48 89 01 48 8B 84 24 20 01 00 00 48 8B 00 48 FF C8 48 8B 8C 24 20 01 00 00 48 89 01 48 8B 84 24 28 01 00 00 48 89 44 24 28 48 8B 84 24 20 01 00 00 48 89 44 24 20 4C 8B 8C 24 18 01 00 00 4C 8B 84 24 10 01 00 00 BA 02 00 00 00 48 8B 8C 24 00 01 00 00 E8 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 25 12 00 00 E9 E6 00 00 00 48 8B 84 24 28 01 00 00 48 89 44 24 28 48 8B 84 24 20 01 00 00 48 89 44 24 20 4C 8B 8C 24 18 01 00 00 4C 8B 84 24 10 01 00 00 33 D2 48 8B 8C 24 00 01 00 00 E8 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 DC 11 00 00 48 8B 84 24 20 01 00 00 48 83 38 00 75 07 33 C0 E9 C7 11 00 00 48 8B 84 24 18 01 00 00 48 8B 00 B9 20 00 00 00 66 89 08 48 8B 84 24 18 01 00 00 48 8B 00 48 83 C0 02 48 8B 8C 24 18 01 00 00 48 89 01 48 8B 84 24 20 01 00 00 48 8B 00 48 FF C8 48 8B 8C 24 20 01 00 00 48 89 01 48 8B 84 24 28 01 00 00 48 89 44 24 28 48 8B 84 24 20 01 00 00 48 89 44 24 20 4C 8B 8C 24 18 01 00 00 4C 8B 84 24 10 01 00 00 BA 02 00 00 00 48 8B 8C 24 00 01 00 00 E8 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 3A 11 00 00 E9 30 11 00 00 48 8B 84 24 10 01 00 00 83 78 0C 01 7C 1B 48 8B 84 24 10 01 00 00 83 78 0C 1F 7F 0D C7 84 24 AC 00 00 00 01 00 00 00 EB 0B C7 84 24 AC 00 00 00 00 00 00 00 8B 84 24 AC 00 00 00 89 44 24 74 83 7C 24 74 00 75 3A 48 8D 05 ?? ?? ?? ?? 48 89 44 24 28 48 8D 05 ?? ?? ?? ?? 48 89 44 24 20 