private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "_llrintf"
		size = 147
		refs = "000d __fdtest 0034 _nearbyintf 0050 __fperrraise 005c __real@c3e0000000000000 006c __real@43e0000000000000 007b __ftol2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D F8 83 7D F8 00 74 6B 83 7D F8 00 7E 06 83 7D F8 02 7E 55 51 D9 45 08 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D9 5D FC D9 45 FC D9 45 08 DA E9 DF E0 F6 C4 44 7B 0A 6A 20 E8 ?? ?? ?? ?? 83 C4 04 D9 45 FC DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 1A D9 45 FC DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 7A 0A D9 45 FC E8 ?? ?? ?? ?? EB 0E 6A 01 E8 ?? ?? ?? ?? 83 C4 04 33 C0 33 D2 8B E5 5D C3 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "_fetestexcept"
		size = 39
		refs = "0016 _fegetexceptflag"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 8B 45 08 50 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 8B 45 FC 83 E0 1F 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "??$cleanup_after_error@D@@YAHQADI@Z"
		size = 231
		refs = "0024 __CrtGetDebugFillThreshold 0058 _memset 0060 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 0089 ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 008e ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0097 ??_C@_1GO@CPMBDHKK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAf@ 009e __CrtDbgReportW 00b2 __errno 00c6 ??_C@_1CI@KGHCCPCN@?$AAc?$AAl?$AAe?$AAa?$AAn?$AAu?$AAp?$AA_?$AAa?$AAf?$AAt?$AAe?$AAr?$AA_?$AAe?$AAr?$AAr?$AAo?$AAr?$AA?$AA@ 00d0 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 45 08 C6 00 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C E8 ?? ?? ?? ?? 89 45 FC 8B 4D 0C 83 E9 01 39 4D FC 73 08 8B 55 FC 89 55 F8 EB 09 8B 45 0C 83 E8 01 89 45 F8 8B 4D F8 51 68 FE 00 00 00 8B 55 08 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 0C B8 ?? ?? ?? ?? 85 C0 74 0D 33 C9 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 55 F4 89 55 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 25 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 25 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 05 B8 16 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_1_0 {
	meta:
		name = "??$cleanup_after_error@_W@@YAHQA_WI@Z"
		size = 235
		refs = "0026 __CrtGetDebugFillThreshold 005c _memset 0064 ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 008d ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0092 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 009b ??_C@_1GO@CPMBDHKK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAf@ 00a2 __CrtDbgReportW 00b6 __errno 00ca ??_C@_1CI@KGHCCPCN@?$AAc?$AAl?$AAe?$AAa?$AAn?$AAu?$AAp?$AA_?$AAa?$AAf?$AAt?$AAe?$AAr?$AA_?$AAe?$AAr?$AAr?$AAo?$AAr?$AA?$AA@ 00d4 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 33 C0 8B 4D 08 66 89 01 83 7D 0C FF 74 4D 81 7D 0C FF FF FF 7F 74 44 83 7D 0C 01 76 3E E8 ?? ?? ?? ?? 89 45 FC 8B 55 0C 83 EA 01 39 55 FC 73 08 8B 45 FC 89 45 F8 EB 09 8B 4D 0C 83 E9 01 89 4D F8 8B 55 F8 D1 E2 52 68 FE 00 00 00 8B 45 08 83 C0 02 50 E8 ?? ?? ?? ?? 83 C4 0C B9 ?? ?? ?? ?? 85 C9 74 0D 33 D2 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 25 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 25 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 05 B8 16 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_2_0 {
	meta:
		name = "??$common_makepath_s@D@@YAHQADIQBD111@Z"
		size = 888
		refs = "0031 ??_C@_1GE@IHIGNC@?$AA?$CI?$AA?$CI?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AAr@ 0036 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 003f ??_C@_1GO@CPMBDHKK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAf@ 0046 __CrtDbgReportW 005a __errno 006e ??_C@_1CE@GNNMAAIL@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAm?$AAa?$AAk?$AAe?$AAp?$AAa?$AAt?$AAh?$AA_?$AAs?$AA?$AA@ 0078 __invalid_parameter 00e0 ??$cleanup_after_error@D@@YAHQADI@Z 0189 ?previous_character@@YAPBDQBD0@Z 0330 __CrtGetDebugFillThreshold 036b _memset"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 45 E8 89 45 E4 83 7D E4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 3E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 EB 02 00 00 8B 55 08 89 55 FC 83 7D 0C FF 74 0B 8B 45 08 03 45 0C 89 45 E0 EB 07 C7 45 E0 00 00 00 00 8B 4D E0 89 4D F8 83 7D 10 00 74 5B BA 01 00 00 00 6B C2 00 8B 4D 10 0F BE 14 01 85 D2 74 48 83 7D F8 00 74 20 8B 45 F8 2B 45 FC 83 F8 02 7D 15 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 E9 88 02 00 00 8B 45 FC 8B 4D 10 8A 11 88 10 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC C6 01 3A 8B 55 FC 83 C2 01 89 55 FC 83 7D 14 00 0F 84 C3 00 00 00 B8 01 00 00 00 6B C8 00 8B 55 14 0F BE 04 0A 85 C0 0F 84 AC 00 00 00 8B 4D 14 89 4D F4 8B 55 F4 0F BE 02 85 C0 74 41 83 7D F8 00 74 1D 8B 4D FC 3B 4D F8 72 15 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 E9 12 02 00 00 8B 4D FC 8B 55 F4 8A 02 88 01 8B 4D FC 83 C1 01 89 4D FC 8B 55 F4 83 C2 01 89 55 F4 EB B5 8B 45 F4 50 8B 4D 14 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 8B 55 F4 0F BE 02 83 F8 2F 74 3D 8B 4D F4 0F BE 11 83 FA 5C 74 32 83 7D F8 00 74 1D 8B 45 FC 3B 45 F8 72 15 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 E9 A8 01 00 00 8B 45 FC C6 00 5C 8B 4D FC 83 C1 01 89 4D FC 83 7D 18 00 74 51 8B 55 18 89 55 F0 8B 45 F0 0F BE 08 85 C9 74 41 83 7D F8 00 74 1D 8B 55 FC 3B 55 F8 72 15 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 E9 60 01 00 00 8B 55 FC 8B 45 F0 8A 08 88 0A 8B 55 FC 83 C2 01 89 55 FC 8B 45 F0 83 C0 01 89 45 F0 EB B5 83 7D 1C 00 0F 84 AA 00 00 00 B9 01 00 00 00 6B D1 00 8B 45 1C 0F BE 0C 10 85 C9 74 46 BA 01 00 00 00 6B C2 00 8B 4D 1C 0F BE 14 01 83 FA 2E 74 32 83 7D F8 00 74 1D 8B 45 FC 3B 45 F8 72 15 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 E9 EE 00 00 00 8B 45 FC C6 00 2E 8B 4D FC 83 C1 01 89 4D FC 8B 55 1C 89 55 EC 8B 45 EC 0F BE 08 85 C9 74 41 83 7D F8 00 74 1D 8B 55 FC 3B 55 F8 72 15 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 E9 AC 00 00 00 8B 55 FC 8B 45 EC 8A 08 88 0A 8B 55 FC 83 C2 01 89 55 FC 8B 45 EC 83 C0 01 89 45 EC EB B5 83 7D F8 00 74 1A 8B 4D FC 3B 4D F8 72 12 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 EB 6E 8B 4D FC C6 01 00 8B 55 FC 83 C2 01 89 55 FC 83 7D 0C FF 74 57 81 7D 0C FF FF FF 7F 74 4E 8B 45 FC 2B 45 08 3B 45 0C 73 43 E8 ?? ?? ?? ?? 89 45 DC 8B 4D FC 2B 4D 08 8B 55 0C 2B D1 39 55 DC 73 08 8B 45 DC 89 45 D8 EB 0E 8B 4D FC 2B 4D 08 8B 55 0C 2B D1 89 55 D8 8B 45 D8 50 68 FE 00 00 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_3_0 {
	meta:
		name = "??$common_makepath_s@_W@@YAHQA_WIQB_W111@Z"
		size = 940
		refs = "0031 ??_C@_1GE@IHIGNC@?$AA?$CI?$AA?$CI?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AAr@ 0036 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 003f ??_C@_1GO@CPMBDHKK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAf@ 0046 __CrtDbgReportW 005a __errno 006e ??_C@_1CE@GNNMAAIL@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAm?$AAa?$AAk?$AAe?$AAp?$AAa?$AAt?$AAh?$AA_?$AAs?$AA?$AA@ 0078 __invalid_parameter 00e5 ??$cleanup_after_error@_W@@YAHQA_WI@Z 0197 ?previous_character@@YAPB_WPB_WQB_W@Z 0353 __CrtGetDebugFillThreshold 039f _memset"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 45 E8 89 45 E4 83 7D E4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 3E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 1F 03 00 00 8B 55 08 89 55 FC 83 7D 0C FF 74 0E 8B 45 0C 8B 4D 08 8D 14 41 89 55 E0 EB 07 C7 45 E0 00 00 00 00 8B 45 E0 89 45 F8 83 7D 10 00 74 64 B9 02 00 00 00 6B D1 00 8B 45 10 0F B7 0C 10 85 C9 74 51 83 7D F8 00 74 22 8B 55 F8 2B 55 FC D1 FA 83 FA 02 7D 15 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 E9 B7 02 00 00 8B 55 FC 8B 45 10 66 8B 08 66 89 0A 8B 55 FC 83 C2 02 89 55 FC B8 3A 00 00 00 8B 4D FC 66 89 01 8B 55 FC 83 C2 02 89 55 FC 83 7D 14 00 0F 84 CA 00 00 00 B8 02 00 00 00 6B C8 00 8B 55 14 0F B7 04 0A 85 C0 0F 84 B3 00 00 00 8B 4D 14 89 4D F4 8B 55 F4 0F B7 02 85 C0 74 43 83 7D F8 00 74 1D 8B 4D FC 3B 4D F8 72 15 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 E9 3A 02 00 00 8B 4D FC 8B 55 F4 66 8B 02 66 89 01 8B 4D FC 83 C1 02 89 4D FC 8B 55 F4 83 C2 02 89 55 F4 EB B3 8B 45 F4 50 8B 4D 14 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 8B 55 F4 0F B7 02 83 F8 2F 74 42 8B 4D F4 0F B7 11 83 FA 5C 74 37 83 7D F8 00 74 1D 8B 45 FC 3B 45 F8 72 15 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 E9 CE 01 00 00 B8 5C 00 00 00 8B 4D FC 66 89 01 8B 55 FC 83 C2 02 89 55 FC 83 7D 18 00 74 53 8B 45 18 89 45 F0 8B 4D F0 0F B7 11 85 D2 74 43 83 7D F8 00 74 1D 8B 45 FC 3B 45 F8 72 15 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 E9 81 01 00 00 8B 45 FC 8B 4D F0 66 8B 11 66 89 10 8B 45 FC 83 C0 02 89 45 FC 8B 4D F0 83 C1 02 89 4D F0 EB B3 83 7D 1C 00 0F 84 B1 00 00 00 BA 02 00 00 00 6B C2 00 8B 4D 1C 0F B7 14 01 85 D2 74 4B B8 02 00 00 00 6B C8 00 8B 55 1C 0F B7 04 0A 83 F8 2E 74 37 83 7D F8 00 74 1D 8B 4D FC 3B 4D F8 72 15 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 E9 0D 01 00 00 B9 2E 00 00 00 8B 55 FC 66 89 0A 8B 45 FC 83 C0 02 89 45 FC 8B 4D 1C 89 4D EC 8B 55 EC 0F B7 02 85 C0 74 43 83 7D F8 00 74 1D 8B 4D FC 3B 4D F8 72 15 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 E9 C6 00 00 00 8B 4D FC 8B 55 EC 66 8B 02 66 89 01 8B 4D FC 83 C1 02 89 4D FC 8B 55 EC 83 C2 02 89 55 EC EB B3 83 7D F8 00 74 1D 8B 45 FC 3B 45 F8 72 15 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 E9 83 00 00 00 33 C0 8B 4D FC 66 89 01 8B 55 FC 83 C2 02 89 55 FC 83 7D 0C FF 74 6A 81 7D 0C FF FF FF 7F 74 61 8B 45 FC 2B 45 08 D1 F8 3B 45 0C 73 54 E8 ?? ?? ?? ?? 89 45 DC 8B 4D FC 2B 4D 08 D1 F9 8B 55 0C 2B D1 39 55 DC 73 08 8B 45 DC 89 45 D8 EB 10 8B 4D FC 2B 4D 08 D1 F9 8B 55 0C 2B D1 89 55 D8 8B 45 D8 D1 E0 50 68 FE 00 00 00 8B 4D FC 2B 4D 08 D1 F9 8B 55 08 8D 04 4A 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_2_4_0 {
	meta:
		name = "?previous_character@@YAPBDQBD0@Z"
		size = 23
		refs = "000e __mbsdec"
		altNames = "?previous_character@@YAPADQAD0@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_210_27_2 {
	meta:
		name = "?expand_argv_wildcards@@YAHQAPADQAPAPAD@Z"
		size = 23
		refs = "000e ___acrt_expand_narrow_argv_wildcards"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_210_28_3 {
	meta:
		name = "?expand_argv_wildcards@@YAHQAPA_WQAPAPA_W@Z"
		size = 23
		refs = "000e ___acrt_expand_wide_argv_wildcards"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_222_3_3 {
	meta:
		name = "?fast_check@@YAHHH@Z"
		size = 23
		refs = "000e __chvalidator"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_424_86_3 {
	meta:
		name = "?strpbrk@@YAPADQADQBD@Z"
		size = 23
		refs = "000e _strpbrk"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_348_53_4 {
	meta:
		name = "?strrchr@@YAPADQADH@Z"
		size = 23
		refs = "000e _strrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_424_87_0 {
	meta:
		name = "?wcspbrk@@YAPA_WPA_WPB_W@Z"
		size = 23
		refs = "000e _wcspbrk"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_643_54_2 {
	meta:
		name = "__CrtSetReportHook2"
		size = 23
		refs = "000e ??$common_set_report_hook@DP6AHHPADPAH@Z@@YAHHQ6AHHPADPAH@Z@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_643_55_4 {
	meta:
		name = "__CrtSetReportHookW2"
		size = 23
		refs = "000e ??$common_set_report_hook@_WP6AHHPA_WPAH@Z@@YAHHQ6AHHPA_WPAH@Z@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_424_88_3 {
	meta:
		name = "___acrt_expand_narrow_argv_wildcards"
		size = 23
		refs = "000e ??$common_expand_argv_wildcards@D@@YAHQAPADQAPAPAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_424_89_0 {
	meta:
		name = "___acrt_expand_wide_argv_wildcards"
		size = 23
		refs = "000e ??$common_expand_argv_wildcards@_W@@YAHQAPA_WQAPAPA_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_511_117_3 {
	meta:
		name = "__atof_l"
		size = 23
		refs = "000e ??$common_atof_l@D@@YANQBDQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_376_4_4 {
	meta:
		name = "__creat"
		size = 23
		refs = "000e ??$common_creat@D@@YAHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_10_2_3 {
	meta:
		name = "__difftime32"
		size = 23
		refs = "000e ??$common_difftime@J@@YANJJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_195_27_3 {
	meta:
		name = "__fdopen"
		size = 23
		refs = "000e ??$common_fdopen@D@@YAPAU_iobuf@@HQBD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_33_3 {
	meta:
		name = "__findfirst32"
		size = 23
		refs = "000e ??$common_find_first_narrow@U_wfinddata32_t@@U_finddata32_t@@@@YAHQBDQAU_finddata32_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_34_3 {
	meta:
		name = "__findfirst32i64"
		size = 23
		refs = "000e ??$common_find_first_narrow@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YAHQBDQAU_finddata32i64_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_35_3 {
	meta:
		name = "__findfirst64"
		size = 23
		refs = "000e ??$common_find_first_narrow@U_wfinddata64_t@@U__finddata64_t@@@@YAHQBDQAU__finddata64_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_36_4 {
	meta:
		name = "__findfirst64i32"
		size = 23
		refs = "000e ??$common_find_first_narrow@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YAHQBDQAU_finddata64i32_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_37_2 {
	meta:
		name = "__findnext32"
		size = 23
		refs = "000e ??$common_find_next_narrow@U_wfinddata32_t@@U_finddata32_t@@@@YAHHQAU_finddata32_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_38_0 {
	meta:
		name = "__findnext32i64"
		size = 23
		refs = "000e ??$common_find_next_narrow@U_wfinddata32i64_t@@U_finddata32i64_t@@@@YAHHQAU_finddata32i64_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_39_0 {
	meta:
		name = "__findnext64"
		size = 23
		refs = "000e ??$common_find_next_narrow@U_wfinddata64_t@@U__finddata64_t@@@@YAHHQAU__finddata64_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_40_0 {
	meta:
		name = "__findnext64i32"
		size = 23
		refs = "000e ??$common_find_next_narrow@U_wfinddata64i32_t@@U_finddata64i32_t@@@@YAHHQAU_finddata64i32_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_571_87_2 {
	meta:
		name = "__fstat32"
		size = 23
		refs = "000e ??$common_fstat@U_stat32@@@@YAHHQAU_stat32@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_571_88_3 {
	meta:
		name = "__fstat32i64"
		size = 23
		refs = "000e ??$common_fstat@U_stat32i64@@@@YAHHQAU_stat32i64@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_571_89_0 {
	meta:
		name = "__fstat64"
		size = 23
		refs = "000e ??$common_fstat@U_stat64@@@@YAHHQAU_stat64@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_571_90_4 {
	meta:
		name = "__fstat64i32"
		size = 23
		refs = "000e ??$common_fstat@U_stat64i32@@@@YAHHQAU_stat64i32@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_214_14_4 {
	meta:
		name = "__futime32"
		size = 23
		refs = "000e ??$common_futime@JU__utimbuf32@@@@YAHHPAU__utimbuf32@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_214_15_0 {
	meta:
		name = "__futime64"
		size = 23
		refs = "000e ??$common_futime@_JU__utimbuf64@@@@YAHHPAU__utimbuf64@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_550_15_0 {
	meta:
		name = "__gmtime32_s"
		size = 23
		refs = "000e ??$common_gmtime_s@J@@YAHQAUtm@@QBJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_550_17_4 {
	meta:
		name = "__gmtime64_s"
		size = 23
		refs = "000e ??$common_gmtime_s@_J@@YAHQAUtm@@QB_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_471_2_3 {
	meta:
		name = "__ldscale"
		size = 23
		refs = "000e __dscale"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_557_2_3 {
	meta:
		name = "__ldunscale"
		size = 23
		refs = "000e __dunscale"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_323_12_4 {
	meta:
		name = "__localtime32_s"
		size = 23
		refs = "000e ??$common_localtime_s@J@@YAHQAUtm@@QBJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_323_14_3 {
	meta:
		name = "__localtime64_s"
		size = 23
		refs = "000e ??$common_localtime_s@_J@@YAHQAUtm@@QB_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_469_13_3 {
	meta:
		name = "__mktemp_s"
		size = 23
		refs = "000e ??$common_mktemp_s@D@@YAHQADI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_460_9_2 {
	meta:
		name = "__putc_nolock"
		size = 23
		refs = "000e __fputc_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_571_91_2 {
	meta:
		name = "__stat32"
		size = 23
		refs = "000e ??$common_stat@U_stat32@@@@YAHQBDQAU_stat32@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_571_92_3 {
	meta:
		name = "__stat32i64"
		size = 23
		refs = "000e ??$common_stat@U_stat32i64@@@@YAHQBDQAU_stat32i64@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_571_93_0 {
	meta:
		name = "__stat64"
		size = 23
		refs = "000e ??$common_stat@U_stat64@@@@YAHQBDQAU_stat64@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_571_94_4 {
	meta:
		name = "__stat64i32"
		size = 23
		refs = "000e ??$common_stat@U_stat64i32@@@@YAHQBDQAU_stat64i32@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_252_5_0 {
	meta:
		name = "__strdate_s"
		size = 23
		refs = "000e ??$common_strdate_s@D@@YAHQADI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_569_5_0 {
	meta:
		name = "__strtime_s"
		size = 23
		refs = "000e ??$common_strtime_s@D@@YAHQADI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_490_6_3 {
	meta:
		name = "__timespec32_get"
		size = 23
		refs = "000e ??$common_timespec_get@U_timespec32@@@@YAHQAU_timespec32@@H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_490_7_4 {
	meta:
		name = "__timespec64_get"
		size = 23
		refs = "000e ??$common_timespec_get@U_timespec64@@@@YAHQAU_timespec64@@H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_214_16_0 {
	meta:
		name = "__utime32"
		size = 23
		refs = "000e ??$common_utime@JDU__utimbuf32@@@@YAHQBDQAU__utimbuf32@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_214_17_2 {
	meta:
		name = "__utime64"
		size = 23
		refs = "000e ??$common_utime@_JDU__utimbuf64@@@@YAHQBDQAU__utimbuf64@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_376_5_4 {
	meta:
		name = "__wcreat"
		size = 23
		refs = "000e ??$common_creat@_W@@YAHQB_WH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_195_28_3 {
	meta:
		name = "__wfdopen"
		size = 23
		refs = "000e ??$common_fdopen@_W@@YAPAU_iobuf@@HQB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_42_0 {
	meta:
		name = "__wfindfirst32"
		size = 23
		refs = "000e ??$common_find_first_wide@U_wfinddata32_t@@@@YAHQB_WQAU_wfinddata32_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_43_4 {
	meta:
		name = "__wfindfirst32i64"
		size = 23
		refs = "000e ??$common_find_first_wide@U_wfinddata32i64_t@@@@YAHQB_WQAU_wfinddata32i64_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_44_3 {
	meta:
		name = "__wfindfirst64"
		size = 23
		refs = "000e ??$common_find_first_wide@U_wfinddata64_t@@@@YAHQB_WQAU_wfinddata64_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_45_2 {
	meta:
		name = "__wfindfirst64i32"
		size = 23
		refs = "000e ??$common_find_first_wide@U_wfinddata64i32_t@@@@YAHQB_WQAU_wfinddata64i32_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_46_2 {
	meta:
		name = "__wfindnext32"
		size = 23
		refs = "000e ??$common_find_next_wide@U_wfinddata32_t@@@@YAHHQAU_wfinddata32_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_47_3 {
	meta:
		name = "__wfindnext32i64"
		size = 23
		refs = "000e ??$common_find_next_wide@U_wfinddata32i64_t@@@@YAHHQAU_wfinddata32i64_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_48_4 {
	meta:
		name = "__wfindnext64"
		size = 23
		refs = "000e ??$common_find_next_wide@U_wfinddata64_t@@@@YAHHQAU_wfinddata64_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_239_49_0 {
	meta:
		name = "__wfindnext64i32"
		size = 23
		refs = "000e ??$common_find_next_wide@U_wfinddata64i32_t@@@@YAHHQAU_wfinddata64i32_t@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_469_15_2 {
	meta:
		name = "__wmktemp_s"
		size = 23
		refs = "000e ??$common_mktemp_s@_W@@YAHQA_WI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_571_95_2 {
	meta:
		name = "__wstat32"
		size = 23
		refs = "000e ??$common_stat@U_stat32@@@@YAHQB_WQAU_stat32@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_571_96_4 {
	meta:
		name = "__wstat32i64"
		size = 23
		refs = "000e ??$common_stat@U_stat32i64@@@@YAHQB_WQAU_stat32i64@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_571_97_4 {
	meta:
		name = "__wstat64"
		size = 23
		refs = "000e ??$common_stat@U_stat64@@@@YAHQB_WQAU_stat64@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_571_98_0 {
	meta:
		name = "__wstat64i32"
		size = 23
		refs = "000e ??$common_stat@U_stat64i32@@@@YAHQB_WQAU_stat64i32@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_252_7_2 {
	meta:
		name = "__wstrdate_s"
		size = 23
		refs = "000e ??$common_strdate_s@_W@@YAHQA_WI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_569_7_0 {
	meta:
		name = "__wstrtime_s"
		size = 23
		refs = "000e ??$common_strtime_s@_W@@YAHQA_WI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_511_123_3 {
	meta:
		name = "__wtof_l"
		size = 23
		refs = "000e ??$common_atof_l@_W@@YANQB_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_214_18_0 {
	meta:
		name = "__wutime32"
		size = 23
		refs = "000e ??$common_utime@J_WU__utimbuf32@@@@YAHQB_WQAU__utimbuf32@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_214_19_4 {
	meta:
		name = "__wutime64"
		size = 23
		refs = "000e ??$common_utime@_J_WU__utimbuf64@@@@YAHQB_WQAU__utimbuf64@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_460_11_3 {
	meta:
		name = "_putc"
		size = 23
		refs = "000e _fputc"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_268_24_4 {
	meta:
		name = "_strnlen"
		size = 23
		refs = "000e ??$common_strnlen@$0A@E@@YAIQBEI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_268_26_2 {
	meta:
		name = "_wcsnlen"
		size = 23
		refs = "000e ??$common_strnlen@$0A@G@@YAIQBGI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_2_6_0 {
	meta:
		name = "__makepath"
		size = 37
		refs = "001c __makepath_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_2_8_0 {
	meta:
		name = "__wmakepath"
		size = 37
		refs = "001c __wmakepath_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_2_7_0 {
	meta:
		name = "__makepath_s"
		size = 39
		refs = "001e ??$common_makepath_s@D@@YAHQADIQBD111@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_643_56_3 {
	meta:
		name = "___acrt_MessageWindowA"
		size = 39
		refs = "001e ??$common_message_window@D@@YAHHQAXQBD111@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_643_57_4 {
	meta:
		name = "___acrt_MessageWindowW"
		size = 39
		refs = "001e ??$common_message_window@_W@@YAHHQAXQB_W111@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_584_945_3 {
	meta:
		name = "___stdio_common_vfprintf"
		size = 39
		refs = "001e ??$common_vfprintf@Vstandard_base@__crt_stdio_output@@D@@YAH_KQAU_iobuf@@QBDQAU__crt_locale_pointers@@QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_584_946_3 {
	meta:
		name = "___stdio_common_vfprintf_p"
		size = 39
		refs = "001e ??$common_vfprintf@Vpositional_parameter_base@__crt_stdio_output@@D@@YAH_KQAU_iobuf@@QBDQAU__crt_locale_pointers@@QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_584_947_4 {
	meta:
		name = "___stdio_common_vfprintf_s"
		size = 39
		refs = "001e ??$common_vfprintf@Vformat_validation_base@__crt_stdio_output@@D@@YAH_KQAU_iobuf@@QBDQAU__crt_locale_pointers@@QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_224_409_0 {
	meta:
		name = "___stdio_common_vfscanf"
		size = 39
		refs = "001e ??$common_vfscanf@D@@YAH_KQAU_iobuf@@QBDQAU__crt_locale_pointers@@QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_584_948_2 {
	meta:
		name = "___stdio_common_vfwprintf"
		size = 39
		refs = "001e ??$common_vfprintf@Vstandard_base@__crt_stdio_output@@_W@@YAH_KQAU_iobuf@@QB_WQAU__crt_locale_pointers@@QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_584_949_4 {
	meta:
		name = "___stdio_common_vfwprintf_p"
		size = 39
		refs = "001e ??$common_vfprintf@Vpositional_parameter_base@__crt_stdio_output@@_W@@YAH_KQAU_iobuf@@QB_WQAU__crt_locale_pointers@@QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_584_950_4 {
	meta:
		name = "___stdio_common_vfwprintf_s"
		size = 39
		refs = "001e ??$common_vfprintf@Vformat_validation_base@__crt_stdio_output@@_W@@YAH_KQAU_iobuf@@QB_WQAU__crt_locale_pointers@@QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_224_410_3 {
	meta:
		name = "___stdio_common_vfwscanf"
		size = 39
		refs = "001e ??$common_vfscanf@_W@@YAH_KQAU_iobuf@@QB_WQAU__crt_locale_pointers@@QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_368_27_4 {
	meta:
		name = "__fullpath_dbg"
		size = 39
		refs = "001e ??$common_fullpath@D@@YAPADQADQBDIH1H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_720_24_3 {
	meta:
		name = "__sopen_dispatch"
		size = 39
		refs = "001e ??$common_sopen_dispatch@D@@YAHQBDHHHQAHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_368_29_0 {
	meta:
		name = "__wfullpath_dbg"
		size = 39
		refs = "001e ??$common_fullpath@_W@@YAPA_WQA_WQB_WIHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_2_9_3 {
	meta:
		name = "__wmakepath_s"
		size = 39
		refs = "001e ??$common_makepath_s@_W@@YAHQA_WIQB_W111@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_720_29_3 {
	meta:
		name = "__wsopen_dispatch"
		size = 39
		refs = "001e ??$common_sopen_dispatch@_W@@YAHQB_WHHHQAHH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_3_0_0 {
	meta:
		name = "_llrint"
		size = 149
		refs = "000d __dtest 0036 _nearbyint 0052 __fperrraise 005e __real@c3e0000000000000 006b __real@43e0000000000000 007d __ftol2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 74 6D 83 7D FC 00 7E 06 83 7D FC 02 7E 57 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F4 DD 45 F4 DD 45 08 DA E9 DF E0 F6 C4 44 7B 0A 6A 20 E8 ?? ?? ?? ?? 83 C4 04 DD 45 F4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 1A DD 05 ?? ?? ?? ?? DC 5D F4 DF E0 F6 C4 01 75 0A DD 45 F4 E8 ?? ?? ?? ?? EB 0E 6A 01 E8 ?? ?? ?? ?? 83 C4 04 33 C0 33 D2 8B E5 5D C3 }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "_llrintl"
		size = 149
		refs = "000d __ldtest 0036 _nearbyintl 0052 __fperrraise 005e __real@c3e0000000000000 006b __real@43e0000000000000 007d __ftol2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 74 6D 83 7D FC 00 7E 06 83 7D FC 02 7E 57 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F4 DD 45 F4 DD 45 08 DA E9 DF E0 F6 C4 44 7B 0A 6A 20 E8 ?? ?? ?? ?? 83 C4 04 DD 45 F4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 1A DD 05 ?? ?? ?? ?? DC 5D F4 DF E0 F6 C4 01 75 0A DD 45 F4 E8 ?? ?? ?? ?? EB 0E 6A 01 E8 ?? ?? ?? ?? 83 C4 04 33 C0 33 D2 8B E5 5D C3 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "_strspn"
		size = 70
	strings:
		$1 = { 55 8B EC 56 33 C0 50 50 50 50 50 50 50 50 8B 55 0C 8D 49 00 8A 02 0A C0 74 09 83 C2 01 0F AB 04 24 EB F1 8B 75 08 83 C9 FF 8D 49 00 83 C1 01 8A 06 0A C0 74 09 83 C6 01 0F A3 04 24 72 EE 8B C1 83 C4 20 5E C9 C3 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "_round"
		size = 116
		refs = "000d __d_int 0058 __real@3ff0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 89 4D FC 83 7D FC 00 7E 0A 83 7D FC 02 7E 02 EB 02 EB 43 6A 00 8D 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 98 85 C0 75 02 EB 2E B9 02 00 00 00 6B D1 03 0F B7 44 15 08 25 00 80 00 00 74 0E DD 45 08 DC 25 ?? ?? ?? ?? DD 5D 08 EB 0C DD 45 08 DC 05 ?? ?? ?? ?? DD 5D 08 DD 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "_roundl"
		size = 116
		refs = "000d __ld_int 0058 __real@3ff0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 51 6A 01 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 89 4D FC 83 7D FC 00 7E 0A 83 7D FC 02 7E 02 EB 02 EB 43 6A 00 8D 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 98 85 C0 75 02 EB 2E B9 02 00 00 00 6B D1 03 0F B7 44 15 08 25 00 80 00 00 74 0E DD 45 08 DC 25 ?? ?? ?? ?? DD 5D 08 EB 0C DD 45 08 DC 05 ?? ?? ?? ?? DD 5D 08 DD 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "___acrt_GetTempPathA"
		size = 243
		refs = "000c ___security_cookie 0024 _memset 0039 __imp__GetTempPathW@8 0054 ___acrt_AreFileApisANSI@0 00c5 __imp__WideCharToMultiByte@32 00eb @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 24 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 68 0A 02 00 00 6A 00 8D 85 F0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 8D F0 FD FF FF 51 68 05 01 00 00 FF 15 ?? ?? ?? ?? 89 85 E0 FD FF FF 83 BD E0 FD FF FF 00 75 07 33 C0 E9 92 00 00 00 E8 ?? ?? ?? ?? 85 C0 75 09 C6 85 EF FD FF FF 01 EB 07 C6 85 EF FD FF FF 00 8A 95 EF FD FF FF 88 95 EE FD FF FF 0F B6 85 EE FD FF FF 85 C0 74 0C C7 85 E8 FD FF FF 01 00 00 00 EB 0A C7 85 E8 FD FF FF 00 00 00 00 8B 8D E8 FD FF FF 89 8D DC FD FF FF 6A 00 6A 00 8B 55 08 52 8B 45 0C 50 6A FF 8D 8D F0 FD FF FF 51 6A 00 8B 95 DC FD FF FF 52 FF 15 ?? ?? ?? ?? 89 85 E4 FD FF FF 83 BD E4 FD FF FF 00 75 04 33 C0 EB 09 8B 85 E4 FD FF FF 83 E8 01 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "__CIsqrt"
		size = 186
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 0031 __load_CW 0040 ___fastflag 0047 __fast_exit 0052 _NAME_ 0057 __math_exit 0073 __convertTOStoQNaN 0092 __indefinite 00b4 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 8B 44 24 0C 74 51 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? A9 00 00 00 80 75 1F D9 FA 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? A9 00 00 F0 7F 75 2C A9 FF FF 0F 00 75 25 83 7C 24 08 00 75 1E EB CC E8 ?? ?? ?? ?? EB 22 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB 25 00 00 00 80 74 B0 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__mbccpy"
		size = 27
		refs = "0012 __mbccpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C 6A 00 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_8_1_0 {
	meta:
		name = "__mbccpy_l"
		size = 28
		refs = "0013 __mbccpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C 6A 00 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__ldpow"
		size = 2841
		refs = "000c ___security_cookie 003f __ldunscale 0057 __ld_int 00a8 __real@3fe0000000000000 00c6 __real@bfe0000000000000 0171 __LInf_C 0211 __LZero_C 032c __fperrraise 03c0 __LNan_C 03ce __real@0000000000000000 0412 ?rthalf@?1??_ldpow@@9@9 0441 _scale 044c __ftol2_sse 0491 _lnbias 04e0 __ldlogpoly 04fa __real@4000000000000000 0517 ?ln2@?1??_ldpow@@9@9 056e ?maxexp@?1??_ldpow@@9@9 0597 __real@c02e000000000000 05a8 __real@402e000000000000 05c2 __real@c044000000000000 05d3 __real@4044000000000000 0761 __ldxp_setw 0792 __ldxp_addx 07ce _log2e 07d7 _memcpy 07f7 __ldxp_mulh 08d3 __ldxp_addh 0a0e __ldxp_getw 0a84 __ldexp 0b11 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 98 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 DD 45 10 DD 9D 30 FF FF FF C7 85 44 FF FF FF 00 00 00 00 C7 85 40 FF FF FF 00 00 00 00 8D 45 08 50 8D 8D 50 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 85 58 FF FF FF 6A 00 8D 95 30 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 66 89 85 54 FF FF FF 83 7D 18 00 74 08 33 C0 8B 4D 18 66 89 01 0F BF 95 54 FF FF FF 85 D2 75 0E DD 45 10 D9 EE DA E9 DF E0 F6 C4 44 7B 47 0F BF 85 58 FF FF FF 85 C0 7D 48 0F BF 8D 50 FF FF FF 83 F9 01 75 3C DD 45 08 DD 05 ?? ?? ?? ?? DA E9 DF E0 F6 C4 44 7B 1E 0F BF 95 54 FF FF FF 83 FA 01 75 1E DD 45 08 DD 05 ?? ?? ?? ?? DA E9 DF E0 F6 C4 44 7A 0C D9 E8 E9 30 0A 00 00 E9 EA 02 00 00 0F BF 85 58 FF FF FF 85 C0 7D 0F 0F BF 8D 54 FF FF FF 85 C9 0F 8E 9B 02 00 00 0F BF 95 58 FF FF FF 83 FA 02 75 0D DD 45 08 E9 FD 09 00 00 E9 80 02 00 00 0F BF 85 54 FF FF FF 83 F8 02 75 0D DD 45 10 E9 E4 09 00 00 E9 67 02 00 00 0F BF 8D 58 FF FF FF 83 F9 01 0F 85 FC 00 00 00 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 75 3B BA 02 00 00 00 6B C2 03 0F B7 4C 05 10 81 E1 00 80 00 00 74 0A D9 EE DD 9D C8 FE FF FF EB 0C DD 05 ?? ?? ?? ?? DD 9D C8 FE FF FF DD 85 C8 FE FF FF E9 84 09 00 00 E9 A7 00 00 00 BA 02 00 00 00 6B C2 03 0F B7 4C 05 10 81 E1 00 80 00 00 75 4C 0F BF 95 54 FF FF FF 85 D2 75 28 6A FF 8D 85 30 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 85 C9 7D 10 DD 05 ?? ?? ?? ?? D9 E0 DD 9D D0 FE FF FF EB 0C DD 05 ?? ?? ?? ?? DD 9D D0 FE FF FF DD 85 D0 FE FF FF E9 20 09 00 00 EB 46 0F BF 95 54 FF FF FF 85 D2 75 28 6A FF 8D 85 30 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 85 C9 7D 10 DD 05 ?? ?? ?? ?? D9 E0 DD 9D B0 FE FF FF EB 08 D9 EE DD 9D B0 FE FF FF DD 85 B0 FE FF FF E9 D8 08 00 00 E9 5B 01 00 00 0F BF 95 54 FF FF FF 83 FA 01 75 74 B8 02 00 00 00 6B C8 03 0F B7 54 0D 10 81 E2 00 80 00 00 75 2E 0F BF 85 50 FF FF FF 85 C0 7F 0A D9 EE DD 9D C0 FE FF FF EB 0C DD 05 ?? ?? ?? ?? DD 9D C0 FE FF FF DD 85 C0 FE FF FF E9 86 08 00 00 EB 2C 0F BF 8D 50 FF FF FF 85 C9 7F 0E DD 05 ?? ?? ?? ?? DD 9D B8 FE FF FF EB 08 D9 EE DD 9D B8 FE FF FF DD 85 B8 FE FF FF E9 58 08 00 00 E9 DB 00 00 00 BA 02 00 00 00 6B C2 03 0F B7 4C 05 10 81 E1 00 80 00 00 75 5D 0F BF 95 54 FF FF FF 85 D2 75 3D 6A FF 8D 85 30 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 85 C9 7D 25 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 74 10 DD 05 ?? ?? ?? ?? D9 E0 DD 9D F8 FE FF FF EB 08 D9 EE DD 9D F8 FE FF FF DD 85 F8 FE FF FF E9 E3 07 00 00 EB 69 6A 04 E8 ?? ?? ?? ?? 83 C4 04 0F BF 95 54 FF FF FF 85 D2 75 3D 6A FF 8D 85 30 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 85 C9 7D 25 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 74 10 DD 05 ?? ?? ?? ?? D9 E0 DD 9D F0 FE FF FF EB 0C DD 05 ?? ?? ?? ?? DD 9D F0 FE FF FF DD 85 F0 FE FF FF E9 78 07 00 00 EB 35 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 74 20 0F BF 95 54 FF FF FF 85 D2 7D 15 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? E9 41 07 00 00 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 0B 33 C0 66 89 85 3C FF FF FF EB 20 DD 45 08 D9 E0 DD 5D 08 6A FF 8D 8D 30 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 85 3C FF FF FF 0F BF 95 50 FF FF FF 83 FA 01 75 2C DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 1C C7 85 2C FF FF FF 00 00 00 00 D9 E8 DD 9D 20 FF FF FF DD 45 08 DC C0 DD 5D 08 EB 41 DD 45 08 DC 0D ?? ?? ?? ?? DC 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E8 20 89 85 2C FF FF FF DB 85 2C FF FF FF DD 9D 98 FE FF FF DD 85 98 FE FF FF DC 35 ?? ?? ?? ?? DC 05 ?? ?? ?? ?? DD 9D 20 FF FF FF 8B 85 2C FF FF FF C1 E0 05 B9 08 00 00 00 6B D1 00 8D 84 10 ?? ?? ?? ?? 89 85 44 FF FF FF DD 45 08 DC A5 20 FF FF FF DD 45 08 DC 85 20 FF FF FF DE F9 DD 9D 00 FF FF FF DD 85 00 FF FF FF DC 8D 00 FF FF FF DD 9D E8 FE FF FF DD 45 08 DC A5 20 FF FF FF DD 5D 08 83 EC 08 DD 85 E8 FE FF FF DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 8D E8 FE FF FF DC 65 08 D9 E8 DC A5 20 FF FF FF DC 0D ?? ?? ?? ?? DE C1 DC 8D 00 FF FF FF DD 9D 08 FF FF FF DD 45 08 DC 85 08 FF FF FF DC 35 ?? ?? ?? ?? DD 9D 30 FF FF FF B9 08 00 00 00 6B D1 00 0F BF 85 50 FF FF FF 89 85 1C FF FF FF DB 85 1C FF FF FF DD 9D 90 FE FF FF DD 85 90 FE FF FF 8B 8D 44 FF FF FF DC 04 11 DC 85 30 FF FF FF DD 9D 30 FF FF FF DD 45 10 DC 8D 30 FF FF FF DD 9D 48 FF FF FF DD 05 ?? ?? ?? ?? D9 E0 DC 9D 48 FF FF FF DF E0 F6 C4 41 75 0E 33 D2 66 89 95 58 FF FF FF E9 B6 04 00 00 DD 85 48 FF FF FF DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 0F 85 87 01 00 00 DD 05 ?? ?? ?? ?? DC 9D 48 FF FF FF DF E0 F6 C4 01 0F 85 70 01 00 00 DD 45 10 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 0F 85 5C 01 00 00 DD 05 ?? ?? ?? ?? DC 5D 10 DF E0 F6 C4 41 0F 85 48 01 00 00 D9 EE DC 9D 48 FF FF FF DF E0 F6 C4 41 75 14 DD 85 48 FF FF FF DC 25 ?? ?? ?? ?? DD 9D E0 FE FF FF EB 12 DD 85 48 FF FF FF DC 05 ?? ?? ?? ?? DD 9D E0 FE FF FF DD 85 E0 FE FF FF E8 ?? ?? ?? ?? 89 85 40 FF FF FF DD 45 08 DC 85 08 FF FF FF DC 4D 10 DD 9D 48 FF FF FF 83 BD 44 FF FF FF 00 75 4B 0F BF 85 50 FF FF FF 89 85 18 FF FF FF DB 85 18 FF FF FF DD 9D 88 FE FF FF DD 85 88 FE FF FF DC 4D 10 DB 85 40 FF FF FF DD 9D 80 FE FF FF DC A5 80 FE FF FF DC 0D ?? ?? ?? ?? DC 85 48 FF FF FF DD 9D 48 FF FF FF E9 8D 00 00 00 B9 08 00 00 00 C1 E1 00 BA 08 00 00 00 D1 E2 8B 85 44 FF FF FF 8B B5 44 FF FF FF DD 04 08 DC 04 16 DC 4D 10 DC 0D ?? ?? ?? ?? DC 85 48 FF FF FF DD 9D 48 FF FF FF 0F BF 8D 50 FF FF FF 89 8D 14 FF FF FF DB 85 14 FF FF FF DD 9D 78 FE FF FF DD 85 78 FE FF FF BA 08 00 00 00 6B C2 00 8B 8D 44 FF FF FF DC 04 01 DC 4D 10 DB 85 40 FF FF FF DD 9D A8 FE FF FF DC A5 A8 FE FF FF DC 0D ?? ?? ?? ?? DC 85 48 FF FF FF DD 9D 48 FF FF FF 83 CA FF 66 89 95 58 FF FF FF E9 18 03 00 00 DD 85 48 FF FF FF DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 11 B8 01 00 00 00 66 89 85 58 FF FF FF E9 F4 02 00 00 83 EC 08 DD 45 08 DD 1C 24 6A 04 8D 4D BC 51 E8 ?? ?? ?? ?? 83 C4 08 DD 85 08 FF FF FF DD 1C 24 6A 02 8D 95 68 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 6A 02 8D 85 68 FE FF FF 50 6A 04 8D 4D BC 51 E8 ?? ?? ?? ?? 83 C4 10 BA 08 00 00 00 6B C2 00 DD 44 05 BC D9 EE DA E9 DF E0 F6 C4 44 7A 1B 83 EC 08 D9 EE DD 1C 24 6A 04 8D 4D 9C 51 E8 ?? ?? ?? ?? 83 C4 10 E9 BC 00 00 00 6A 20 68 ?? ?? ?? ?? 8D 55 9C 52 E8 ?? ?? ?? ?? 83 C4 0C B8 08 00 00 00 6B C8 00 83 EC 08 DD 44 0D BC DD 1C 24 6A 04 8D 55 9C 52 E8 ?? ?? ?? ?? 83 C4 10 C7 85 38 FF FF FF 01 00 00 00 EB 0F 8B 85 38 FF FF FF 83 C0 01 89 85 38 FF FF FF 83 BD 38 FF FF FF 04 7D 65 8B 8D 38 FF FF FF DD 44 CD BC D9 EE DA E9 DF E0 F6 C4 44 7B 50 6A 20 68 ?? ?? ?? ?? 8D 95 5C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 38 FF FF FF 83 EC 08 DD 44 C5 BC DD 1C 24 6A 04 8D 8D 5C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 6A 04 8D 95 5C FF FF FF 52 6A 04 8D 45 9C 50 E8 ?? ?? ?? ?? 83 C4 10 EB 83 83 BD 44 FF FF FF 00 74 17 6A 03 8B 8D 44 FF FF FF 51 6A 04 8D 55 9C 52 E8 ?? ?? ?? ?? 83 C4 10 0F BF 85 50 FF FF FF 89 85 10 FF FF FF DB 85 10 FF FF FF DD 9D A0 FE FF FF DD 85 A0 FE FF FF 83 EC 08 DD 1C 24 6A 04 8D 4D 9C 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 10 DD 1C 24 6A 02 8D 55 BC 52 E8 ?? ?? ?? ?? 83 C4 10 6A 20 8D 45 9C 50 8D 4D DC 51 E8 ?? ?? ?? ?? 83 C4 0C BA 08 00 00 00 6B C2 00 83 EC 08 DD 44 05 BC DD 1C 24 6A 04 8D 4D DC 51 E8 ?? ?? ?? ?? 83 C4 10 BA 08 00 00 00 C1 E2 00 DD 44 15 BC D9 EE DA E9 DF E0 F6 C4 44 7B 4F 6A 20 8D 45 9C 50 8D 8D 7C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C BA 08 00 00 00 C1 E2 00 83 EC 08 DD 44 15 BC DD 1C 24 6A 04 8D 85 7C FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 6A 04 8D 8D 7C FF FF FF 51 6A 04 8D 55 DC 52 E8 ?? ?? ?? ?? 83 C4 10 B8 08 00 00 00 6B C8 00 DD 44 0D DC DD 5D 08 BA 08 00 00 00 6B C2 00 DD 44 05 DC D9 EE DA E9 DF E0 F6 C4 44 7B 34 B9 08 00 00 00 C1 E1 00 DD 44 0D DC D9 EE DA E9 DF E0 F6 C4 44 7B 1D BA 08 00 00 00 C1 E2 00 B8 08 00 00 00 D1 E0 DD 44 15 DC DC 44 05 DC DC 45 08 DD 5D 08 6A 00 8D 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 D9 E0 83 EC 08 DD 1C 24 6A 04 8D 55 DC 52 E8 ?? ?? ?? ?? 83 C4 10 6A 04 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 08 DD 9D 48 FF FF FF DD 85 48 FF FF FF DC 0D ?? ?? ?? ?? DD 9D 48 FF FF FF DD 45 08 E8 ?? ?? ?? ?? 89 85 40 FF FF FF 83 C9 FF 66 89 8D 58 FF FF FF 0F BF 95 58 FF FF FF 85 D2 7D 42 83 7D 18 00 74 17 8B 45 18 66 8B 8D 40 FF FF FF 66 89 08 C7 85 40 FF FF FF 00 00 00 00 8B 95 40 FF FF FF 52 83 EC 08 D9 E8 DD 1C 24 8D 85 48 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 66 89 85 58 FF FF FF 0F BF 8D 58 FF FF FF 89 8D 28 FF FF FF 83 BD 28 FF FF FF 00 74 0B 83 BD 28 FF FF FF 01 74 16 EB 2A D9 EE DD 9D 48 FF FF FF 6A 10 E8 ?? ?? ?? ?? 83 C4 04 EB 16 DD 05 ?? ?? ?? ?? DD 9D 48 FF FF FF 6A 08 E8 ?? ?? ?? ?? 83 C4 04 0F BF 95 3C FF FF FF 85 D2 74 10 DD 85 48 FF FF FF D9 E0 DD 9D D8 FE FF FF EB 0C DD 85 48 FF FF FF DD 9D D8 FE FF FF DD 85 D8 FE FF FF 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_479_0_0 {
	meta:
		name = "__dpow"
		size = 2841
		refs = "000c ___security_cookie 003f __dunscale 0057 __d_int 00a8 __real@3fe0000000000000 00c6 __real@bfe0000000000000 0171 __Inf_C 0211 __Zero_C 032c __fperrraise 03c0 __Nan_C 03ce __real@0000000000000000 0412 ?rthalf@?1??_dpow@@9@9 0441 _scale 044c __ftol2_sse 0491 _lnbias 04e0 __dlogpoly 04fa __real@4000000000000000 0517 ?ln2@?1??_dpow@@9@9 056e ?maxexp@?1??_dpow@@9@9 0597 __real@c02e000000000000 05a8 __real@402e000000000000 05c2 __real@c044000000000000 05d3 __real@4044000000000000 0761 __dxp_setw 0792 __dxp_addx 07ce _log2e 07d7 _memcpy 07f7 __dxp_mulh 08d3 __dxp_addh 0a0e __dxp_getw 0a84 __dexp 0b11 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 98 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 DD 45 10 DD 9D 30 FF FF FF C7 85 44 FF FF FF 00 00 00 00 C7 85 40 FF FF FF 00 00 00 00 8D 45 08 50 8D 8D 50 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 85 58 FF FF FF 6A 00 8D 95 30 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 66 89 85 54 FF FF FF 83 7D 18 00 74 08 33 C0 8B 4D 18 66 89 01 0F BF 95 54 FF FF FF 85 D2 75 0E DD 45 10 D9 EE DA E9 DF E0 F6 C4 44 7B 47 0F BF 85 58 FF FF FF 85 C0 7D 48 0F BF 8D 50 FF FF FF 83 F9 01 75 3C DD 45 08 DD 05 ?? ?? ?? ?? DA E9 DF E0 F6 C4 44 7B 1E 0F BF 95 54 FF FF FF 83 FA 01 75 1E DD 45 08 DD 05 ?? ?? ?? ?? DA E9 DF E0 F6 C4 44 7A 0C D9 E8 E9 30 0A 00 00 E9 EA 02 00 00 0F BF 85 58 FF FF FF 85 C0 7D 0F 0F BF 8D 54 FF FF FF 85 C9 0F 8E 9B 02 00 00 0F BF 95 58 FF FF FF 83 FA 02 75 0D DD 45 08 E9 FD 09 00 00 E9 80 02 00 00 0F BF 85 54 FF FF FF 83 F8 02 75 0D DD 45 10 E9 E4 09 00 00 E9 67 02 00 00 0F BF 8D 58 FF FF FF 83 F9 01 0F 85 FC 00 00 00 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 75 3B BA 02 00 00 00 6B C2 03 0F B7 4C 05 10 81 E1 00 80 00 00 74 0A D9 EE DD 9D C8 FE FF FF EB 0C DD 05 ?? ?? ?? ?? DD 9D C8 FE FF FF DD 85 C8 FE FF FF E9 84 09 00 00 E9 A7 00 00 00 BA 02 00 00 00 6B C2 03 0F B7 4C 05 10 81 E1 00 80 00 00 75 4C 0F BF 95 54 FF FF FF 85 D2 75 28 6A FF 8D 85 30 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 85 C9 7D 10 DD 05 ?? ?? ?? ?? D9 E0 DD 9D D0 FE FF FF EB 0C DD 05 ?? ?? ?? ?? DD 9D D0 FE FF FF DD 85 D0 FE FF FF E9 20 09 00 00 EB 46 0F BF 95 54 FF FF FF 85 D2 75 28 6A FF 8D 85 30 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 85 C9 7D 10 DD 05 ?? ?? ?? ?? D9 E0 DD 9D B0 FE FF FF EB 08 D9 EE DD 9D B0 FE FF FF DD 85 B0 FE FF FF E9 D8 08 00 00 E9 5B 01 00 00 0F BF 95 54 FF FF FF 83 FA 01 75 74 B8 02 00 00 00 6B C8 03 0F B7 54 0D 10 81 E2 00 80 00 00 75 2E 0F BF 85 50 FF FF FF 85 C0 7F 0A D9 EE DD 9D C0 FE FF FF EB 0C DD 05 ?? ?? ?? ?? DD 9D C0 FE FF FF DD 85 C0 FE FF FF E9 86 08 00 00 EB 2C 0F BF 8D 50 FF FF FF 85 C9 7F 0E DD 05 ?? ?? ?? ?? DD 9D B8 FE FF FF EB 08 D9 EE DD 9D B8 FE FF FF DD 85 B8 FE FF FF E9 58 08 00 00 E9 DB 00 00 00 BA 02 00 00 00 6B C2 03 0F B7 4C 05 10 81 E1 00 80 00 00 75 5D 0F BF 95 54 FF FF FF 85 D2 75 3D 6A FF 8D 85 30 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 85 C9 7D 25 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 74 10 DD 05 ?? ?? ?? ?? D9 E0 DD 9D F8 FE FF FF EB 08 D9 EE DD 9D F8 FE FF FF DD 85 F8 FE FF FF E9 E3 07 00 00 EB 69 6A 04 E8 ?? ?? ?? ?? 83 C4 04 0F BF 95 54 FF FF FF 85 D2 75 3D 6A FF 8D 85 30 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 85 C9 7D 25 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 74 10 DD 05 ?? ?? ?? ?? D9 E0 DD 9D F0 FE FF FF EB 0C DD 05 ?? ?? ?? ?? DD 9D F0 FE FF FF DD 85 F0 FE FF FF E9 78 07 00 00 EB 35 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 74 20 0F BF 95 54 FF FF FF 85 D2 7D 15 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? E9 41 07 00 00 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 0B 33 C0 66 89 85 3C FF FF FF EB 20 DD 45 08 D9 E0 DD 5D 08 6A FF 8D 8D 30 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 85 3C FF FF FF 0F BF 95 50 FF FF FF 83 FA 01 75 2C DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 1C C7 85 2C FF FF FF 00 00 00 00 D9 E8 DD 9D 20 FF FF FF DD 45 08 DC C0 DD 5D 08 EB 41 DD 45 08 DC 0D ?? ?? ?? ?? DC 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E8 20 89 85 2C FF FF FF DB 85 2C FF FF FF DD 9D 98 FE FF FF DD 85 98 FE FF FF DC 35 ?? ?? ?? ?? DC 05 ?? ?? ?? ?? DD 9D 20 FF FF FF 8B 85 2C FF FF FF C1 E0 05 B9 08 00 00 00 6B D1 00 8D 84 10 ?? ?? ?? ?? 89 85 44 FF FF FF DD 45 08 DC A5 20 FF FF FF DD 45 08 DC 85 20 FF FF FF DE F9 DD 9D 00 FF FF FF DD 85 00 FF FF FF DC 8D 00 FF FF FF DD 9D E8 FE FF FF DD 45 08 DC A5 20 FF FF FF DD 5D 08 83 EC 08 DD 85 E8 FE FF FF DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 8D E8 FE FF FF DC 65 08 D9 E8 DC A5 20 FF FF FF DC 0D ?? ?? ?? ?? DE C1 DC 8D 00 FF FF FF DD 9D 08 FF FF FF DD 45 08 DC 85 08 FF FF FF DC 35 ?? ?? ?? ?? DD 9D 30 FF FF FF B9 08 00 00 00 6B D1 00 0F BF 85 50 FF FF FF 89 85 1C FF FF FF DB 85 1C FF FF FF DD 9D 90 FE FF FF DD 85 90 FE FF FF 8B 8D 44 FF FF FF DC 04 11 DC 85 30 FF FF FF DD 9D 30 FF FF FF DD 45 10 DC 8D 30 FF FF FF DD 9D 48 FF FF FF DD 05 ?? ?? ?? ?? D9 E0 DC 9D 48 FF FF FF DF E0 F6 C4 41 75 0E 33 D2 66 89 95 58 FF FF FF E9 B6 04 00 00 DD 85 48 FF FF FF DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 0F 85 87 01 00 00 DD 05 ?? ?? ?? ?? DC 9D 48 FF FF FF DF E0 F6 C4 01 0F 85 70 01 00 00 DD 45 10 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 0F 85 5C 01 00 00 DD 05 ?? ?? ?? ?? DC 5D 10 DF E0 F6 C4 41 0F 85 48 01 00 00 D9 EE DC 9D 48 FF FF FF DF E0 F6 C4 41 75 14 DD 85 48 FF FF FF DC 25 ?? ?? ?? ?? DD 9D E0 FE FF FF EB 12 DD 85 48 FF FF FF DC 05 ?? ?? ?? ?? DD 9D E0 FE FF FF DD 85 E0 FE FF FF E8 ?? ?? ?? ?? 89 85 40 FF FF FF DD 45 08 DC 85 08 FF FF FF DC 4D 10 DD 9D 48 FF FF FF 83 BD 44 FF FF FF 00 75 4B 0F BF 85 50 FF FF FF 89 85 18 FF FF FF DB 85 18 FF FF FF DD 9D 88 FE FF FF DD 85 88 FE FF FF DC 4D 10 DB 85 40 FF FF FF DD 9D 80 FE FF FF DC A5 80 FE FF FF DC 0D ?? ?? ?? ?? DC 85 48 FF FF FF DD 9D 48 FF FF FF E9 8D 00 00 00 B9 08 00 00 00 C1 E1 00 BA 08 00 00 00 D1 E2 8B 85 44 FF FF FF 8B B5 44 FF FF FF DD 04 08 DC 04 16 DC 4D 10 DC 0D ?? ?? ?? ?? DC 85 48 FF FF FF DD 9D 48 FF FF FF 0F BF 8D 50 FF FF FF 89 8D 14 FF FF FF DB 85 14 FF FF FF DD 9D 78 FE FF FF DD 85 78 FE FF FF BA 08 00 00 00 6B C2 00 8B 8D 44 FF FF FF DC 04 01 DC 4D 10 DB 85 40 FF FF FF DD 9D A8 FE FF FF DC A5 A8 FE FF FF DC 0D ?? ?? ?? ?? DC 85 48 FF FF FF DD 9D 48 FF FF FF 83 CA FF 66 89 95 58 FF FF FF E9 18 03 00 00 DD 85 48 FF FF FF DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 11 B8 01 00 00 00 66 89 85 58 FF FF FF E9 F4 02 00 00 83 EC 08 DD 45 08 DD 1C 24 6A 04 8D 4D BC 51 E8 ?? ?? ?? ?? 83 C4 08 DD 85 08 FF FF FF DD 1C 24 6A 02 8D 95 68 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 6A 02 8D 85 68 FE FF FF 50 6A 04 8D 4D BC 51 E8 ?? ?? ?? ?? 83 C4 10 BA 08 00 00 00 6B C2 00 DD 44 05 BC D9 EE DA E9 DF E0 F6 C4 44 7A 1B 83 EC 08 D9 EE DD 1C 24 6A 04 8D 4D 9C 51 E8 ?? ?? ?? ?? 83 C4 10 E9 BC 00 00 00 6A 20 68 ?? ?? ?? ?? 8D 55 9C 52 E8 ?? ?? ?? ?? 83 C4 0C B8 08 00 00 00 6B C8 00 83 EC 08 DD 44 0D BC DD 1C 24 6A 04 8D 55 9C 52 E8 ?? ?? ?? ?? 83 C4 10 C7 85 38 FF FF FF 01 00 00 00 EB 0F 8B 85 38 FF FF FF 83 C0 01 89 85 38 FF FF FF 83 BD 38 FF FF FF 04 7D 65 8B 8D 38 FF FF FF DD 44 CD BC D9 EE DA E9 DF E0 F6 C4 44 7B 50 6A 20 68 ?? ?? ?? ?? 8D 95 5C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 38 FF FF FF 83 EC 08 DD 44 C5 BC DD 1C 24 6A 04 8D 8D 5C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 10 6A 04 8D 95 5C FF FF FF 52 6A 04 8D 45 9C 50 E8 ?? ?? ?? ?? 83 C4 10 EB 83 83 BD 44 FF FF FF 00 74 17 6A 03 8B 8D 44 FF FF FF 51 6A 04 8D 55 9C 52 E8 ?? ?? ?? ?? 83 C4 10 0F BF 85 50 FF FF FF 89 85 10 FF FF FF DB 85 10 FF FF FF DD 9D A0 FE FF FF DD 85 A0 FE FF FF 83 EC 08 DD 1C 24 6A 04 8D 4D 9C 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 10 DD 1C 24 6A 02 8D 55 BC 52 E8 ?? ?? ?? ?? 83 C4 10 6A 20 8D 45 9C 50 8D 4D DC 51 E8 ?? ?? ?? ?? 83 C4 0C BA 08 00 00 00 6B C2 00 83 EC 08 DD 44 05 BC DD 1C 24 6A 04 8D 4D DC 51 E8 ?? ?? ?? ?? 83 C4 10 BA 08 00 00 00 C1 E2 00 DD 44 15 BC D9 EE DA E9 DF E0 F6 C4 44 7B 4F 6A 20 8D 45 9C 50 8D 8D 7C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C BA 08 00 00 00 C1 E2 00 83 EC 08 DD 44 15 BC DD 1C 24 6A 04 8D 85 7C FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 6A 04 8D 8D 7C FF FF FF 51 6A 04 8D 55 DC 52 E8 ?? ?? ?? ?? 83 C4 10 B8 08 00 00 00 6B C8 00 DD 44 0D DC DD 5D 08 BA 08 00 00 00 6B C2 00 DD 44 05 DC D9 EE DA E9 DF E0 F6 C4 44 7B 34 B9 08 00 00 00 C1 E1 00 DD 44 0D DC D9 EE DA E9 DF E0 F6 C4 44 7B 1D BA 08 00 00 00 C1 E2 00 B8 08 00 00 00 D1 E0 DD 44 15 DC DC 44 05 DC DC 45 08 DD 5D 08 6A 00 8D 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 D9 E0 83 EC 08 DD 1C 24 6A 04 8D 55 DC 52 E8 ?? ?? ?? ?? 83 C4 10 6A 04 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 08 DD 9D 48 FF FF FF DD 85 48 FF FF FF DC 0D ?? ?? ?? ?? DD 9D 48 FF FF FF DD 45 08 E8 ?? ?? ?? ?? 89 85 40 FF FF FF 83 C9 FF 66 89 8D 58 FF FF FF 0F BF 95 58 FF FF FF 85 D2 7D 42 83 7D 18 00 74 17 8B 45 18 66 8B 8D 40 FF FF FF 66 89 08 C7 85 40 FF FF FF 00 00 00 00 8B 95 40 FF FF FF 52 83 EC 08 D9 E8 DD 1C 24 8D 85 48 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 10 66 89 85 58 FF FF FF 0F BF 8D 58 FF FF FF 89 8D 28 FF FF FF 83 BD 28 FF FF FF 00 74 0B 83 BD 28 FF FF FF 01 74 16 EB 2A D9 EE DD 9D 48 FF FF FF 6A 10 E8 ?? ?? ?? ?? 83 C4 04 EB 16 DD 05 ?? ?? ?? ?? DD 9D 48 FF FF FF 6A 08 E8 ?? ?? ?? ?? 83 C4 04 0F BF 95 3C FF FF FF 85 D2 74 10 DD 85 48 FF FF FF D9 E0 DD 9D D8 FE FF FF EB 0C DD 85 48 FF FF FF DD 9D D8 FE FF FF DD 85 D8 FE FF FF 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "__ldtgamma"
		size = 433
		refs = "0015 __real@404b000000000000 0029 _stirling 003c __real@bfe0000000000000 0056 __real@3ff0000000000000 006b __real@3fe0000000000000 008f __ldunscale 00cd __real@3ff8000000000000 00f9 __real@4004000000000000 0111 __real@4000000000000000 0177 _s 0185 __ldpoly 018f _c"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8B 45 08 DD 00 DD 5D F8 DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 1A 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 E9 78 01 00 00 E9 73 01 00 00 DD 05 ?? ?? ?? ?? DC 5D F8 DF E0 F6 C4 41 75 51 D9 E8 DD 5D F0 EB 0C DD 45 F8 DC 05 ?? ?? ?? ?? DD 5D F8 DD 45 F0 DC 4D F8 DD 5D F0 DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 02 EB 02 EB D7 DD 45 F8 DC 25 ?? ?? ?? ?? DD 5D F8 8D 45 F0 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 E9 D1 00 00 00 DD 05 ?? ?? ?? ?? DC 5D F8 DF E0 F6 C4 41 75 20 D9 E8 DC 45 F8 DC 4D F8 DD 5D F0 8D 55 F0 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 E9 A1 00 00 00 DD 05 ?? ?? ?? ?? DC 5D F8 DF E0 F6 C4 41 75 1C DD 45 F8 DD 5D F0 DD 45 F8 DC 25 ?? ?? ?? ?? DD 5D F8 33 C9 8B 55 0C 66 89 0A EB 75 DD 05 ?? ?? ?? ?? DC 5D F8 DF E0 F6 C4 41 75 1B D9 E8 DD 5D F0 DD 45 F8 DC 25 ?? ?? ?? ?? DD 5D F8 33 C0 8B 4D 0C 66 89 01 EB 4A D9 E8 DD 5D F0 EB 09 DD 45 F0 DC 75 F8 DD 5D F0 DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 0E DD 45 F8 DC 25 ?? ?? ?? ?? DD 5D F8 EB D9 DD 45 F8 DC 25 ?? ?? ?? ?? DD 5D F8 8D 55 F0 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 DD 45 F0 DD 19 6A 07 68 ?? ?? ?? ?? 83 EC 08 DD 45 F8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 6A 06 68 ?? ?? ?? ?? 83 EC 08 DD 45 F8 DD 1C 24 DD 5D E8 E8 ?? ?? ?? ?? 83 C4 10 DC 7D E8 DC 4D F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_479_1_0 {
	meta:
		name = "__dtgamma"
		size = 433
		refs = "0015 __real@404b000000000000 0029 _stirling 003c __real@bfe0000000000000 0056 __real@3ff0000000000000 006b __real@3fe0000000000000 008f __dunscale 00cd __real@3ff8000000000000 00f9 __real@4004000000000000 0111 __real@4000000000000000 0177 _s 0185 __dpoly 018f _c"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8B 45 08 DD 00 DD 5D F8 DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 1A 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 E9 78 01 00 00 E9 73 01 00 00 DD 05 ?? ?? ?? ?? DC 5D F8 DF E0 F6 C4 41 75 51 D9 E8 DD 5D F0 EB 0C DD 45 F8 DC 05 ?? ?? ?? ?? DD 5D F8 DD 45 F0 DC 4D F8 DD 5D F0 DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 02 EB 02 EB D7 DD 45 F8 DC 25 ?? ?? ?? ?? DD 5D F8 8D 45 F0 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 E9 D1 00 00 00 DD 05 ?? ?? ?? ?? DC 5D F8 DF E0 F6 C4 41 75 20 D9 E8 DC 45 F8 DC 4D F8 DD 5D F0 8D 55 F0 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 E9 A1 00 00 00 DD 05 ?? ?? ?? ?? DC 5D F8 DF E0 F6 C4 41 75 1C DD 45 F8 DD 5D F0 DD 45 F8 DC 25 ?? ?? ?? ?? DD 5D F8 33 C9 8B 55 0C 66 89 0A EB 75 DD 05 ?? ?? ?? ?? DC 5D F8 DF E0 F6 C4 41 75 1B D9 E8 DD 5D F0 DD 45 F8 DC 25 ?? ?? ?? ?? DD 5D F8 33 C0 8B 4D 0C 66 89 01 EB 4A D9 E8 DD 5D F0 EB 09 DD 45 F0 DC 75 F8 DD 5D F0 DD 45 F8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 0E DD 45 F8 DC 25 ?? ?? ?? ?? DD 5D F8 EB D9 DD 45 F8 DC 25 ?? ?? ?? ?? DD 5D F8 8D 55 F0 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 DD 45 F0 DD 19 6A 07 68 ?? ?? ?? ?? 83 EC 08 DD 45 F8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 6A 06 68 ?? ?? ?? ?? 83 EC 08 DD 45 F8 DD 1C 24 DD 5D E8 E8 ?? ?? ?? ?? 83 C4 10 DC 7D E8 DC 4D F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_2_0 {
	meta:
		name = "_expl"
		size = 24
		refs = "000f _exp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_44_1_0 {
	meta:
		name = "_cosl"
		size = 24
		refs = "000f _cos"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_303_1_2 {
	meta:
		name = "_logl"
		size = 24
		refs = "000f _log"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_740_1_2 {
	meta:
		name = "_sinhl"
		size = 24
		refs = "000f _sinh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_123_3_2 {
	meta:
		name = "_sinl"
		size = 24
		refs = "000f _sin"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_20_3_3 {
	meta:
		name = "_sqrtl"
		size = 24
		refs = "000f _sqrt"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_740_3_4 {
	meta:
		name = "_tanl"
		size = 24
		refs = "000f _tan"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_9_3_0 {
	meta:
		name = "_stirling"
		size = 274
		refs = "0019 __real@3fe0000000000000 002d __ldpow 0065 _approx0 00af __ldpoly 00f8 _expl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 8B 45 08 DD 00 DD 5D F4 8B 4D 0C 51 DD 45 F4 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 83 EC 08 DD 45 F4 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 14 DD 5D DC 8B 55 0C 0F BF 02 F7 D8 8B 4D 0C 66 89 01 C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 83 7D FC 00 73 1A 8B 45 FC C1 E0 05 DD 80 ?? ?? ?? ?? DC 5D F4 DF E0 F6 C4 41 75 02 EB 02 EB D7 D9 E8 DC 75 F4 8B 4D FC C1 E1 05 DC A1 ?? ?? ?? ?? DD 5D EC 8B 55 FC C1 E2 05 8B 82 ?? ?? ?? ?? 50 8B 4D FC C1 E1 05 8B 91 ?? ?? ?? ?? 52 83 EC 08 DD 45 EC DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 8B 45 FC C1 E0 05 8B 88 ?? ?? ?? ?? 51 8B 55 FC C1 E2 05 8B 82 ?? ?? ?? ?? 50 83 EC 08 DD 45 EC DD 1C 24 DD 5D E4 E8 ?? ?? ?? ?? 83 C4 10 DC 7D E4 8B 4D 08 DD 19 DD 45 F4 D9 E0 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 4D DC 8B 55 08 DC 3A 8B 45 08 DD 18 D9 EE 8B E5 5D C3 }
	condition:
		$1
}

rule file_479_2_0 {
	meta:
		name = "_stirling"
		size = 274
		refs = "0019 __real@3fe0000000000000 002d __dpow 0065 _approx0 00af __dpoly 00f8 _exp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 8B 45 08 DD 00 DD 5D F4 8B 4D 0C 51 DD 45 F4 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 83 EC 08 DD 45 F4 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 14 DD 5D DC 8B 55 0C 0F BF 02 F7 D8 8B 4D 0C 66 89 01 C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 83 7D FC 00 73 1A 8B 45 FC C1 E0 05 DD 80 ?? ?? ?? ?? DC 5D F4 DF E0 F6 C4 41 75 02 EB 02 EB D7 D9 E8 DC 75 F4 8B 4D FC C1 E1 05 DC A1 ?? ?? ?? ?? DD 5D EC 8B 55 FC C1 E2 05 8B 82 ?? ?? ?? ?? 50 8B 4D FC C1 E1 05 8B 91 ?? ?? ?? ?? 52 83 EC 08 DD 45 EC DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 8B 45 FC C1 E0 05 8B 88 ?? ?? ?? ?? 51 8B 55 FC C1 E2 05 8B 82 ?? ?? ?? ?? 50 83 EC 08 DD 45 EC DD 1C 24 DD 5D E4 E8 ?? ?? ?? ?? 83 C4 10 DC 7D E4 8B 4D 08 DD 19 DD 45 F4 D9 E0 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 4D DC 8B 55 08 DC 3A 8B 45 08 DD 18 D9 EE 8B E5 5D C3 }
	condition:
		$1
}

rule file_9_4_0 {
	meta:
		name = "_tgammal"
		size = 654
		refs = "0015 __ld_int 0063 __fperrraise 006c __LNan_C 00a4 __LInf_C 00e5 __real@c065c00000000000 010b __ldgamma_big 012c __real@3ff0000000000000 0152 __real@bff0000000000000 016e _pi 017f __ldsin 01a8 __ldtgamma 01cc __ldscale 020c __real@4065c00000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 3C DD 45 08 DD 5D DC 6A 00 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 89 4D F4 83 7D F4 00 74 4D 83 7D F4 01 74 13 83 7D F4 02 74 05 E9 AA 00 00 00 DD 45 08 E9 49 02 00 00 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 75 0A DD 45 08 E9 2C 02 00 00 EB 15 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? E9 15 02 00 00 DD 45 08 D9 EE DA E9 DF E0 F6 C4 44 7A 3F 6A 04 E8 ?? ?? ?? ?? 83 C4 04 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 74 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D D4 EB 09 DD 05 ?? ?? ?? ?? DD 5D D4 DD 45 D4 E9 CA 01 00 00 EB 21 D9 EE DC 5D 08 DF E0 F6 C4 41 75 15 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? E9 A7 01 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 01 75 16 6A 10 E8 ?? ?? ?? ?? 83 C4 04 D9 EE E9 86 01 00 00 E9 81 01 00 00 DD 05 ?? ?? ?? ?? D9 E0 DC 5D 08 DF E0 F6 C4 41 0F 85 EB 00 00 00 DD 45 08 DD 5D E4 DD 45 08 D9 E0 DC 25 ?? ?? ?? ?? DD 5D CC DD 45 08 DC 65 DC DD 5D DC 6A FF 8D 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 DC 65 E4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 08 DD 45 DC D9 E0 DD 5D DC DD 45 08 D9 E0 6A 00 DD 05 ?? ?? ?? ?? DC 4D DC 83 EC 08 DD 1C 24 DD 5D C4 E8 ?? ?? ?? ?? 83 C4 0C DC 4D C4 DD 45 08 D9 E0 DC 25 ?? ?? ?? ?? DE C9 DC 3D ?? ?? ?? ?? DD 5D E4 8D 45 FC 50 8D 4D CC 51 E8 ?? ?? ?? ?? 83 C4 08 D9 E8 DE C1 DC 7D E4 DD 5D E4 DD 45 E4 DC 4D CC DD 5D E4 0F BF 55 FC 52 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 89 4D F0 83 7D F0 00 74 08 83 7D F0 01 74 0E EB 16 6A 10 E8 ?? ?? ?? ?? 83 C4 04 EB 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 DD 45 E4 E9 85 00 00 00 E9 80 00 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 01 75 60 8D 55 F8 52 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 DD 5D DC D9 E8 DC 45 DC DC 75 08 DD 5D 08 0F BF 4D F8 F7 D9 51 8D 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 98 89 45 EC 83 7D EC 00 74 08 83 7D EC 01 74 0E EB 16 6A 10 E8 ?? ?? ?? ?? 83 C4 04 EB 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 DD 45 08 EB 12 EB 10 6A 08 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_479_3_0 {
	meta:
		name = "_tgamma"
		size = 654
		refs = "0015 __d_int 0063 __fperrraise 006c __Nan_C 00a4 __Inf_C 00e5 __real@c065c00000000000 010b __dgamma_big 012c __real@3ff0000000000000 0152 __real@bff0000000000000 016e _pi 017f __dsin 01a8 __dtgamma 01cc __dscale 020c __real@4065c00000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 3C DD 45 08 DD 5D DC 6A 00 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 89 4D F4 83 7D F4 00 74 4D 83 7D F4 01 74 13 83 7D F4 02 74 05 E9 AA 00 00 00 DD 45 08 E9 49 02 00 00 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 75 0A DD 45 08 E9 2C 02 00 00 EB 15 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? E9 15 02 00 00 DD 45 08 D9 EE DA E9 DF E0 F6 C4 44 7A 3F 6A 04 E8 ?? ?? ?? ?? 83 C4 04 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 74 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D D4 EB 09 DD 05 ?? ?? ?? ?? DD 5D D4 DD 45 D4 E9 CA 01 00 00 EB 21 D9 EE DC 5D 08 DF E0 F6 C4 41 75 15 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? E9 A7 01 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 01 75 16 6A 10 E8 ?? ?? ?? ?? 83 C4 04 D9 EE E9 86 01 00 00 E9 81 01 00 00 DD 05 ?? ?? ?? ?? D9 E0 DC 5D 08 DF E0 F6 C4 41 0F 85 EB 00 00 00 DD 45 08 DD 5D E4 DD 45 08 D9 E0 DC 25 ?? ?? ?? ?? DD 5D CC DD 45 08 DC 65 DC DD 5D DC 6A FF 8D 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 DC 65 E4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 08 DD 45 DC D9 E0 DD 5D DC DD 45 08 D9 E0 6A 00 DD 05 ?? ?? ?? ?? DC 4D DC 83 EC 08 DD 1C 24 DD 5D C4 E8 ?? ?? ?? ?? 83 C4 0C DC 4D C4 DD 45 08 D9 E0 DC 25 ?? ?? ?? ?? DE C9 DC 3D ?? ?? ?? ?? DD 5D E4 8D 45 FC 50 8D 4D CC 51 E8 ?? ?? ?? ?? 83 C4 08 D9 E8 DE C1 DC 7D E4 DD 5D E4 DD 45 E4 DC 4D CC DD 5D E4 0F BF 55 FC 52 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 89 4D F0 83 7D F0 00 74 08 83 7D F0 01 74 0E EB 16 6A 10 E8 ?? ?? ?? ?? 83 C4 04 EB 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 DD 45 E4 E9 85 00 00 00 E9 80 00 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 01 75 60 8D 55 F8 52 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 DD 5D DC D9 E8 DC 45 DC DC 75 08 DD 5D 08 0F BF 4D F8 F7 D9 51 8D 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 98 89 45 EC 83 7D EC 00 74 08 83 7D EC 01 74 0E EB 16 6A 10 E8 ?? ?? ?? ?? 83 C4 04 EB 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 DD 45 08 EB 12 EB 10 6A 08 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "??$common_difftime@J@@YANJJ@Z"
		size = 57
		refs = "0015 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 83 7D 0C 00 7C 06 83 7D 08 00 7D 0F E8 ?? ?? ?? ?? C7 00 16 00 00 00 D9 EE EB 12 8B 45 08 2B 45 0C 89 45 FC DB 45 FC DD 5D F4 DD 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "??$common_difftime@_J@@YAN_J0@Z"
		size = 82
		refs = "0025 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 7D 14 00 7C 16 7F 06 83 7D 10 00 72 0E 83 7D 0C 00 7F 17 7C 06 83 7D 08 00 73 0F E8 ?? ?? ?? ?? C7 00 16 00 00 00 D9 EE EB 1B 8B 45 08 2B 45 10 8B 4D 0C 1B 4D 14 89 45 F8 89 4D FC DF 6D F8 DD 5D F0 DD 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_10_3_0 {
	meta:
		name = "__difftime64"
		size = 31
		refs = "0016 ??$common_difftime@_J@@YAN_J0@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_632_8_4 {
	meta:
		name = "__lseeki64"
		size = 31
		refs = "0016 ??$common_lseek@_J@@YA_JH_JH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_632_9_4 {
	meta:
		name = "__lseeki64_nolock"
		size = 31
		refs = "0016 ??$common_lseek_nolock@_J@@YA_JH_JH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_185_55_0 {
	meta:
		name = "__malloc_dbg"
		size = 31
		refs = "0016 ?heap_alloc_dbg@@YAPAXIHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_536_5_4 {
	meta:
		name = "__mbstowcs_l"
		size = 31
		refs = "0016 ?_mbstowcs_l_helper@@YAIPA_WPBDIPAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_47_4 {
	meta:
		name = "__strtoi64_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@_JDPAPAD@__crt_strtox@@YA_JQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_48_0 {
	meta:
		name = "__strtoimax_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@_JDPAPAD@__crt_strtox@@YA_JQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_49_0 {
	meta:
		name = "__strtol_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@JDPAPAD@__crt_strtox@@YAJQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_50_4 {
	meta:
		name = "__strtoll_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@_JDPAPAD@__crt_strtox@@YA_JQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_52_0 {
	meta:
		name = "__strtoui64_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@_KDPAPAD@__crt_strtox@@YA_KQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_53_0 {
	meta:
		name = "__strtoul_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@KDPAPAD@__crt_strtox@@YAKQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_54_0 {
	meta:
		name = "__strtoull_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@_KDPAPAD@__crt_strtox@@YA_KQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_55_3 {
	meta:
		name = "__strtoumax_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@_KDPAPAD@__crt_strtox@@YA_KQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_57_3 {
	meta:
		name = "__wcstoi64_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@_J_WPAPA_W@__crt_strtox@@YA_JQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_58_0 {
	meta:
		name = "__wcstoimax_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@_J_WPAPA_W@__crt_strtox@@YA_JQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_59_3 {
	meta:
		name = "__wcstol_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@J_WPAPA_W@__crt_strtox@@YAJQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_60_3 {
	meta:
		name = "__wcstoll_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@_J_WPAPA_W@__crt_strtox@@YA_JQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_332_8_0 {
	meta:
		name = "__wcstombs_l"
		size = 31
		refs = "0016 ?_wcstombs_l_helper@@YAIPADPB_WIPAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_62_4 {
	meta:
		name = "__wcstoui64_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@_K_WPAPA_W@__crt_strtox@@YA_KQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_63_4 {
	meta:
		name = "__wcstoul_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@K_WPAPA_W@__crt_strtox@@YAKQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_64_2 {
	meta:
		name = "__wcstoull_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@_K_WPAPA_W@__crt_strtox@@YA_KQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_65_3 {
	meta:
		name = "__wcstoumax_l"
		size = 31
		refs = "0016 ??$parse_integer_from_string@_K_WPAPA_W@__crt_strtox@@YA_KQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_294_9_0 {
	meta:
		name = "_mbsrtowcs"
		size = 31
		refs = "0016 ?_mbsrtowcs_helper@@YAIPA_WPAPBDIPAU_Mbstatet@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_719_1_4 {
	meta:
		name = "_strncat_s"
		size = 31
		refs = "0016 ??$common_tcsncat_s@D@@YAHQADIQBDI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_371_1_4 {
	meta:
		name = "_strncpy_s"
		size = 31
		refs = "0016 ??$common_tcsncpy_s@D@@YAHQADIQBDI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_519_1_3 {
	meta:
		name = "_wcsncat_s"
		size = 31
		refs = "0016 ??$common_tcsncat_s@_W@@YAHQA_WIQB_WI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_241_1_3 {
	meta:
		name = "_wcsncpy_s"
		size = 31
		refs = "0016 ??$common_tcsncpy_s@_W@@YAHQA_WIQB_WI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_37_9_3 {
	meta:
		name = "_wcsrtombs"
		size = 31
		refs = "0016 _internal_wcsrtombs"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_11_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z"
		size = 219
		refs = "002d ___acrt_locale_changed 003d ___acrt_initial_locale_pointers 0053 ___acrt_getptd 0086 ___acrt_update_locale_info 009b ___acrt_update_multibyte_info"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C6 40 0C 00 83 7D 08 00 74 16 8B 4D 08 8B 11 8B 41 04 8B 4D FC 89 51 04 89 41 08 E9 A6 00 00 00 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 1A 8B 45 FC 8B 0D ?? ?? ?? ?? 89 48 04 8B 15 ?? ?? ?? ?? 89 50 08 E9 80 00 00 00 E8 ?? ?? ?? ?? 8B 4D FC 89 01 8B 55 FC 8B 02 8B 4D FC 8B 50 4C 89 51 04 8B 45 FC 8B 08 8B 55 FC 8B 41 48 89 42 08 8B 4D FC 83 C1 04 51 8B 55 FC 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D FC 83 C1 08 51 8B 55 FC 8B 02 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D FC 8B 11 8B 82 50 03 00 00 83 E0 02 75 20 8B 4D FC 8B 11 8B 82 50 03 00 00 83 C8 02 8B 4D FC 8B 11 89 82 50 03 00 00 8B 45 FC C6 40 0C 01 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_11_1_0 {
	meta:
		name = "??1_LocaleUpdate@@QAE@XZ"
		size = 49
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 0F B6 48 0C 85 C9 74 19 8B 55 FC 8B 02 8B 88 50 03 00 00 83 E1 FD 8B 55 FC 8B 02 89 88 50 03 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_2_0 {
	meta:
		name = "?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ"
		size = 19
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 83 C0 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_3_0 {
	meta:
		name = "___acrt_locale_changed"
		size = 38
		refs = "0008 ___acrt_locale_changed_data"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 3D ?? ?? ?? ?? 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_4_0 {
	meta:
		name = "__towupper_l"
		size = 329
		refs = "0024 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 002c ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0074 ??1_LocaleUpdate@@QAE@XZ 0094 _iswctype 0110 ___acrt_LCMapStringW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 0F B7 45 08 3D FF FF 00 00 75 09 66 8B 45 08 E9 29 01 00 00 8B 4D 0C 51 8D 4D DC E8 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 8B 10 B8 04 00 00 00 D1 E0 83 BC 02 A0 00 00 00 00 75 3E 0F B7 4D 08 83 F9 61 7C 15 0F B7 55 08 83 FA 7A 7F 0C 0F B7 45 08 83 E8 20 89 45 EC EB 07 0F B7 4D 08 89 4D EC 66 8B 55 EC 66 89 55 FE 8D 4D DC E8 ?? ?? ?? ?? 66 8B 45 FE E9 C4 00 00 00 0F B7 45 08 3D 00 01 00 00 7D 59 6A 02 0F B7 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 1B 66 8B 55 08 66 89 55 FC 8D 4D DC E8 ?? ?? ?? ?? 66 8B 45 FC E9 8D 00 00 00 EB 2B 8D 4D DC E8 ?? ?? ?? ?? 8B 00 0F B7 4D 08 8B 90 98 00 00 00 66 0F B6 04 0A 66 89 45 FA 8D 4D DC E8 ?? ?? ?? ?? 66 8B 45 FA EB 60 6A 01 8D 4D F4 51 6A 01 8D 55 08 52 68 00 02 00 00 8D 4D DC E8 ?? ?? ?? ?? 8B 00 B9 04 00 00 00 D1 E1 8B 94 08 A0 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 16 66 8B 45 08 66 89 45 F8 8D 4D DC E8 ?? ?? ?? ?? 66 8B 45 F8 EB 14 66 8B 4D F4 66 89 4D F2 8D 4D DC E8 ?? ?? ?? ?? 66 8B 45 F2 8B E5 5D C3 }
	condition:
		$1
}

rule file_11_5_0 {
	meta:
		name = "_towupper"
		size = 22
		refs = "000d __towupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 0F B7 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_190_5_0 {
	meta:
		name = "_towlower"
		size = 22
		refs = "000d __towlower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 0F B7 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "_atan2f"
		size = 42
		refs = "0019 _atan2"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 0C 83 EC 08 DD 1C 24 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_281_3_0 {
	meta:
		name = "_fmodf"
		size = 42
		refs = "0019 _fmod"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 0C 83 EC 08 DD 1C 24 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_630_3_0 {
	meta:
		name = "_powf"
		size = 42
		refs = "0019 _pow"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 0C 83 EC 08 DD 1C 24 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "_casinhf"
		size = 939
		refs = "0009 ___security_cookie 001b _crealf 002e _cimagf 003d __fdtest 00f6 __real@0000000000000000 0103 _piby4 013b __FZero_C 0177 _piby2 01af __FCbuild 01b9 _csqrtf 025f _big 02fa _asinhf 032c _logf 0361 __FCmulcc 037d _atan2f 03a3 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 58 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 D9 5D DC 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 D9 5D E0 8D 4D DC 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 D0 8D 55 E0 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 E4 0F BF 45 D0 83 F8 02 75 47 0F BF 4D E4 83 F9 02 74 08 0F BF 55 E4 85 D2 75 0E D9 45 DC D9 5D E8 D9 45 E0 D9 5D D4 EB 23 0F BF 45 E4 83 F8 01 75 0E D9 45 E0 D9 5D E8 D9 45 DC D9 5D D4 EB 0C D9 45 DC D9 5D E8 D9 45 DC D9 5D D4 E9 DF 02 00 00 0F BF 4D E4 83 F9 02 75 28 0F BF 55 D0 83 FA 01 75 0E D9 45 DC D9 5D E8 D9 45 E0 D9 5D D4 EB 0C D9 45 E0 D9 5D E8 D9 45 E0 D9 5D D4 E9 AE 02 00 00 0F BF 45 D0 83 F8 01 75 74 0F BF 4D E4 83 F9 01 75 34 D9 45 DC D9 5D E8 D9 45 E0 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 0D D9 05 ?? ?? ?? ?? D9 E0 D9 5D B8 EB 09 D9 05 ?? ?? ?? ?? D9 5D B8 D9 45 B8 D9 5D D4 EB 32 D9 45 DC D9 5D E8 BA 02 00 00 00 C1 E2 00 0F B7 44 15 E0 25 00 80 00 00 74 0D D9 05 ?? ?? ?? ?? D9 E0 D9 5D B4 EB 05 D9 EE D9 5D B4 D9 45 B4 D9 5D D4 E9 31 02 00 00 0F BF 4D E4 83 F9 01 75 37 D9 45 E0 D9 5D E8 D9 45 E0 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 0D D9 05 ?? ?? ?? ?? D9 E0 D9 5D B0 EB 09 D9 05 ?? ?? ?? ?? D9 5D B0 D9 45 B0 D9 5D D4 E9 F1 01 00 00 51 D9 45 DC D9 1C 24 D9 45 E0 D9 E8 DE E1 D9 5D AC D9 45 AC 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 52 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC 89 55 F0 D9 45 DC D9 E0 51 D9 1C 24 D9 45 E0 D9 E8 DE C1 D9 5D A8 D9 45 A8 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 52 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 89 55 F8 D9 45 DC D9 EE DA E9 DF E0 F6 C4 44 7A 0B D9 45 DC D9 5D E8 E9 3F 01 00 00 8B 55 F0 52 8B 45 EC 50 E8 ?? ?? ?? ?? 83 C4 08 D9 5D C8 8B 4D F0 51 8B 55 EC 52 E8 ?? ?? ?? ?? 83 C4 08 D9 5D CC 8B 45 F8 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 D9 5D C4 8B 55 F8 52 8B 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 D9 5D C0 D9 05 ?? ?? ?? ?? D9 45 C8 DE D9 DF E0 F6 C4 41 75 17 D9 45 C8 D9 5D D8 D9 45 C4 D8 75 D8 D8 4D CC D8 65 C0 D9 5D BC EB 6C D9 05 ?? ?? ?? ?? D9 45 CC DE D9 DF E0 F6 C4 41 75 17 D9 45 CC D9 5D D8 D9 45 C0 D8 75 D8 D8 4D C8 D8 6D C4 D9 5D BC EB 43 D9 45 CC D9 E0 D9 05 ?? ?? ?? ?? DE D9 DF E0 F6 C4 05 7A 19 D9 45 CC D9 E0 D9 5D D8 D9 45 C0 D8 75 D8 D8 4D C8 D8 6D C4 D9 5D BC EB 16 D9 EE D9 5D D8 D9 45 CC D8 4D C4 D9 45 C8 D8 4D C0 DE E9 D9 5D BC 51 D9 45 BC D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D9 5D E8 D9 45 D8 D9 EE DA E9 DF E0 F6 C4 44 7A 02 EB 3C D9 45 E8 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 17 51 D9 45 D8 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D8 45 E8 D9 5D E8 EB 15 51 D9 45 D8 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D8 6D E8 D9 5D E8 8B 4D F8 51 8B 55 F4 52 8B 45 F0 50 8B 4D EC 51 E8 ?? ?? ?? ?? 83 C4 10 52 50 E8 ?? ?? ?? ?? 83 C4 04 D9 1C 24 51 D9 45 E0 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D D4 51 D9 45 D4 D9 1C 24 51 D9 45 E8 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_12_2_0 {
	meta:
		name = "_logf"
		size = 33
		refs = "0010 _log"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_649_1_3 {
	meta:
		name = "_cosf"
		size = 33
		refs = "0010 _cos"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_61_0_3 {
	meta:
		name = "_expf"
		size = 33
		refs = "0010 _exp"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_3_3 {
	meta:
		name = "_sinf"
		size = 33
		refs = "0010 _sin"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_529_1_3 {
	meta:
		name = "_sinhf"
		size = 33
		refs = "0010 _sinh"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_14_0 {
	meta:
		name = "_sqrtf"
		size = 33
		refs = "0010 _sqrt"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_529_3_2 {
	meta:
		name = "_tanf"
		size = 33
		refs = "0010 _tan"
	strings:
		$1 = { 8B FF 55 8B EC 51 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "__dlog"
		size = 515
		refs = "0011 __dunscale 003d __fperrraise 0046 __Inf_C 008f __Nan_C 009f _rthalf 00c7 __real@3ff0000000000000 00f0 _p 017a _loge2lo 0189 _loge2hi 019f _logxehi 01a8 _logxelo 01b1 _logxe 01ba _logx2lo 01c9 _logx2hi 01d9 _log2ehi 01e2 _log2elo 01eb _log2e"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 8D 45 08 50 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 0F BF D0 89 55 F8 83 7D F8 00 74 16 83 7D F8 01 74 27 83 7D F8 02 74 02 EB 3C DD 45 08 E9 C5 01 00 00 6A 04 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? D9 E0 E9 AE 01 00 00 B8 02 00 00 00 6B C8 03 0F B7 54 0D 08 81 E2 00 80 00 00 75 08 DD 45 08 E9 91 01 00 00 B8 02 00 00 00 6B C8 03 0F B7 54 0D 08 81 E2 00 80 00 00 74 1A 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? E9 67 01 00 00 E9 62 01 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 15 DD 45 08 DC 45 08 DD 5D 08 66 8B 45 FC 66 83 E8 01 66 89 45 FC DD 45 08 DC 25 ?? ?? ?? ?? DD 5D DC DD 45 08 DC 05 ?? ?? ?? ?? DC 7D DC DD 5D E4 DD 45 E4 DC 4D E4 DD 5D EC B9 08 00 00 00 6B D1 00 DD 82 ?? ?? ?? ?? DC 4D EC B8 08 00 00 00 C1 E0 00 DC 80 ?? ?? ?? ?? DC 4D EC B9 08 00 00 00 D1 E1 DC 81 ?? ?? ?? ?? DC 4D EC BA 08 00 00 00 6B C2 03 DC 80 ?? ?? ?? ?? DC 4D EC B9 08 00 00 00 C1 E1 02 DC 81 ?? ?? ?? ?? DC 4D EC BA 08 00 00 00 6B C2 05 DC 80 ?? ?? ?? ?? DC 4D EC B9 08 00 00 00 6B D1 06 DC 82 ?? ?? ?? ?? DC 4D EC DC 6D DC DC 4D E4 DD 5D E4 0F BF 45 FC 89 45 F4 DB 45 F4 DD 5D EC 83 7D 10 00 75 1F DD 05 ?? ?? ?? ?? DC 4D EC DC 6D E4 DC 6D DC DD 05 ?? ?? ?? ?? DC 4D EC DE C1 DD 5D E4 EB 65 83 7D 10 00 7E 3A DD 05 ?? ?? ?? ?? DC 4D DC DD 05 ?? ?? ?? ?? DC 4D DC DD 05 ?? ?? ?? ?? DC 4D E4 DD 05 ?? ?? ?? ?? DC 4D EC DE E9 DE E9 DE C1 DD 05 ?? ?? ?? ?? DC 4D EC DE C1 DD 5D E4 EB 25 DD 05 ?? ?? ?? ?? DC 4D DC DD 05 ?? ?? ?? ?? DC 4D DC DD 05 ?? ?? ?? ?? DC 4D E4 DE E9 DE C1 DC 45 EC DD 5D E4 DD 45 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_410_0_0 {
	meta:
		name = "__ldlog"
		size = 515
		refs = "0011 __ldunscale 003d __fperrraise 0046 __LInf_C 008f __LNan_C 009f _rthalf 00c7 __real@3ff0000000000000 00f0 _p 017a _loge2lo 0189 _loge2hi 019f _logxehi 01a8 _logxelo 01b1 _logxe 01ba _logx2lo 01c9 _logx2hi 01d9 _log2ehi 01e2 _log2elo 01eb _log2e"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 8D 45 08 50 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 0F BF D0 89 55 F8 83 7D F8 00 74 16 83 7D F8 01 74 27 83 7D F8 02 74 02 EB 3C DD 45 08 E9 C5 01 00 00 6A 04 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? D9 E0 E9 AE 01 00 00 B8 02 00 00 00 6B C8 03 0F B7 54 0D 08 81 E2 00 80 00 00 75 08 DD 45 08 E9 91 01 00 00 B8 02 00 00 00 6B C8 03 0F B7 54 0D 08 81 E2 00 80 00 00 74 1A 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? E9 67 01 00 00 E9 62 01 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 15 DD 45 08 DC 45 08 DD 5D 08 66 8B 45 FC 66 83 E8 01 66 89 45 FC DD 45 08 DC 25 ?? ?? ?? ?? DD 5D DC DD 45 08 DC 05 ?? ?? ?? ?? DC 7D DC DD 5D E4 DD 45 E4 DC 4D E4 DD 5D EC B9 08 00 00 00 6B D1 00 DD 82 ?? ?? ?? ?? DC 4D EC B8 08 00 00 00 C1 E0 00 DC 80 ?? ?? ?? ?? DC 4D EC B9 08 00 00 00 D1 E1 DC 81 ?? ?? ?? ?? DC 4D EC BA 08 00 00 00 6B C2 03 DC 80 ?? ?? ?? ?? DC 4D EC B9 08 00 00 00 C1 E1 02 DC 81 ?? ?? ?? ?? DC 4D EC BA 08 00 00 00 6B C2 05 DC 80 ?? ?? ?? ?? DC 4D EC B9 08 00 00 00 6B D1 06 DC 82 ?? ?? ?? ?? DC 4D EC DC 6D DC DC 4D E4 DD 5D E4 0F BF 45 FC 89 45 F4 DB 45 F4 DD 5D EC 83 7D 10 00 75 1F DD 05 ?? ?? ?? ?? DC 4D EC DC 6D E4 DC 6D DC DD 05 ?? ?? ?? ?? DC 4D EC DE C1 DD 5D E4 EB 65 83 7D 10 00 7E 3A DD 05 ?? ?? ?? ?? DC 4D DC DD 05 ?? ?? ?? ?? DC 4D DC DD 05 ?? ?? ?? ?? DC 4D E4 DD 05 ?? ?? ?? ?? DC 4D EC DE E9 DE E9 DE C1 DD 05 ?? ?? ?? ?? DC 4D EC DE C1 DD 5D E4 EB 25 DD 05 ?? ?? ?? ?? DC 4D DC DD 05 ?? ?? ?? ?? DC 4D DC DD 05 ?? ?? ?? ?? DC 4D E4 DE E9 DE C1 DC 45 EC DD 5D E4 DD 45 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_13_1_0 {
	meta:
		name = "__dlogpoly"
		size = 122
		refs = "000f _p"
		altNames = "__ldlogpoly"
	strings:
		$1 = { 8B FF 55 8B EC B8 08 00 00 00 6B C8 00 DD 81 ?? ?? ?? ?? DC 4D 08 BA 08 00 00 00 C1 E2 00 DC 82 ?? ?? ?? ?? DC 4D 08 B8 08 00 00 00 D1 E0 DC 80 ?? ?? ?? ?? DC 4D 08 B9 08 00 00 00 6B D1 03 DC 82 ?? ?? ?? ?? DC 4D 08 B8 08 00 00 00 C1 E0 02 DC 80 ?? ?? ?? ?? DC 4D 08 B9 08 00 00 00 6B D1 05 DC 82 ?? ?? ?? ?? DC 4D 08 B8 08 00 00 00 6B C8 06 DC 81 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_13_2_0 {
	meta:
		name = "_log2"
		size = 26
		refs = "0011 __dlog"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_410_2_0 {
	meta:
		name = "_log2l"
		size = 26
		refs = "0011 __ldlog"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "_norml"
		size = 104
		refs = "0025 _creall 004c _cimagl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F8 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F0 DD 45 F8 DC 4D F8 DD 45 F0 DC 4D F0 DE C1 8B E5 5D C3 }
	condition:
		$1
}

rule file_590_0_0 {
	meta:
		name = "_norm"
		size = 104
		refs = "0025 _creal 004c _cimag"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F8 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F0 DD 45 F8 DC 4D F8 DD 45 F0 DC 4D F0 DE C1 8B E5 5D C3 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z"
		size = 131
		refs = "001f ___acrt_locale_changed_data 0027 ___acrt_initial_locale_pointers 003a ___acrt_getptd 0053 ___acrt_update_locale_info 005b ___acrt_update_multibyte_info"
	strings:
		$1 = { 8B FF 55 8B EC 57 8B F9 8B 4D 08 C6 47 0C 00 85 C9 74 0A 8B 01 89 47 04 8B 41 04 EB 16 83 3D ?? ?? ?? ?? 00 75 12 A1 ?? ?? ?? ?? 89 47 04 A1 ?? ?? ?? ?? 89 47 08 EB 44 56 E8 ?? ?? ?? ?? 8D 57 04 89 07 52 8D 77 08 8B 48 4C 89 0A 8B 48 48 50 89 0E E8 ?? ?? ?? ?? 56 FF 37 E8 ?? ?? ?? ?? 8B 0F 83 C4 10 8B 81 50 03 00 00 5E A8 02 75 0D 83 C8 02 89 81 50 03 00 00 C6 47 0C 01 8B C7 5F 5D C2 04 00 }
	condition:
		$1
}

rule file_16_1_0 {
	meta:
		name = "??1_LocaleUpdate@@QAE@XZ"
		size = 16
	strings:
		$1 = { 80 79 0C 00 74 09 8B 01 83 A0 50 03 00 00 FD C3 }
	condition:
		$1
}

rule file_16_4_0 {
	meta:
		name = "__mbsncpy"
		size = 26
		refs = "0011 __mbsncpy_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_142_0_3 {
	meta:
		name = "__mbscat_s"
		size = 26
		refs = "0011 __mbscat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_69_0_2 {
	meta:
		name = "__mbscpy_s"
		size = 26
		refs = "0011 __mbscpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_605_4_2 {
	meta:
		name = "__mbsnbcat"
		size = 26
		refs = "0011 __mbsnbcat_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_655_4_2 {
	meta:
		name = "__mbsnbcmp"
		size = 26
		refs = "0011 __mbsnbcmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_449_4_0 {
	meta:
		name = "__mbsnbcoll"
		size = 26
		refs = "0011 __mbsnbcoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_704_4_2 {
	meta:
		name = "__mbsnbcpy"
		size = 26
		refs = "0011 __mbsnbcpy_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_601_4_3 {
	meta:
		name = "__mbsnbicmp"
		size = 26
		refs = "0011 __mbsnbicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_594_4_3 {
	meta:
		name = "__mbsnbicoll"
		size = 26
		refs = "0011 __mbsnbicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_51_4_0 {
	meta:
		name = "__mbsnbset"
		size = 26
		refs = "0011 __mbsnbset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_521_4_0 {
	meta:
		name = "__mbsncat"
		size = 26
		refs = "0011 __mbsncat_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_282_4_2 {
	meta:
		name = "__mbsncmp"
		size = 26
		refs = "0011 __mbsncmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_644_4_4 {
	meta:
		name = "__mbsncoll"
		size = 26
		refs = "0011 __mbsncoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_343_4_2 {
	meta:
		name = "__mbsnicmp"
		size = 26
		refs = "0011 __mbsnicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_86_4_3 {
	meta:
		name = "__mbsnicoll"
		size = 26
		refs = "0011 __mbsnicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_156_4_4 {
	meta:
		name = "__mbsnset"
		size = 26
		refs = "0011 __mbsnset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_391_0_3 {
	meta:
		name = "__mbsset_s"
		size = 26
		refs = "0011 __mbsset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_485_4_4 {
	meta:
		name = "__mbstok_s"
		size = 26
		refs = "0011 __mbstok_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_678_79_4 {
	meta:
		name = "__spawnv"
		size = 26
		refs = "0011 ??$common_spawnv@D@@YAHHQBDQBQBD1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_54_52_4 {
	meta:
		name = "__spawnvp"
		size = 26
		refs = "0011 ??$common_spawnvp@D@@YAHHQBDQBQBD1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_678_83_3 {
	meta:
		name = "__wspawnv"
		size = 26
		refs = "0011 ??$common_spawnv@_W@@YAHHQB_WQBQB_W1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_54_56_4 {
	meta:
		name = "__wspawnvp"
		size = 26
		refs = "0011 ??$common_spawnvp@_W@@YAHHQB_WQBQB_W1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_16_5_0 {
	meta:
		name = "__mbsncpy_l"
		size = 281
		refs = "0018 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0028 ??_C@_1DG@BFFILGID@?$AAd?$AAs?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAc?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0030 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0038 ??_C@_1HA@OMDLJNFM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0040 __CrtDbgReportW 004e __errno 0063 ??_C@_1DG@GGOPHOOE@?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAc?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0092 ??_C@_1BG@LEOFPELK@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAc?$AAp?$AAy?$AA_?$AAl?$AA?$AA@ 009e __invalid_parameter 00b5 _strncpy 00ea _memset"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 56 8B 75 08 8D 4D E8 57 FF 75 14 89 75 F8 E8 ?? ?? ?? ?? 8B 4D 10 85 F6 75 34 85 C9 74 30 BF ?? ?? ?? ?? 33 DB 57 68 ?? ?? ?? ?? 53 6A 36 BE ?? ?? ?? ?? 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 6A 36 EB 39 8B 55 0C 85 D2 75 49 85 C9 74 45 BF ?? ?? ?? ?? 33 DB 57 68 ?? ?? ?? ?? 53 6A 37 BE ?? ?? ?? ?? 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 6A 37 56 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 4D 8B 7D F0 33 DB 39 5F 08 75 62 51 52 56 E8 ?? ?? ?? ?? 83 C4 0C 8B D8 EB 34 0F B6 02 49 F6 44 38 19 04 8A 02 88 06 74 3E 8A 42 01 83 C2 02 88 46 01 83 C6 02 84 C0 75 34 88 5E FE 85 C9 74 0B 51 53 56 E8 ?? ?? ?? ?? 83 C4 0C 8B 5D F8 80 7D F4 00 74 0A 8B 4D E8 83 A1 50 03 00 00 FD 5F 5E 8B C3 5B 8B E5 5D C3 46 42 84 C0 74 CF 85 C9 75 A9 EB D8 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "??$convert_to_fos_high_precision@N@@YAXNIQAHQADI@Z"
		size = 1585
		refs = "000c ___security_cookie 001c ??_C@_1DE@KHKADFOO@?$AAm?$AAa?$AAn?$AAt?$AAi?$AAs?$AAs?$AAa?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0021 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002a ??_C@_1GC@DDAKNBNC@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0031 __CrtDbgReportW 0055 __aullshr 0170 _log10 0178 _ceil 0180 __ftol2_sse 01a7 ??_C@_1FI@LFKLOPAC@?$AA?$CI?$AA?$CC?$AAu?$AAn?$AAe?$AAx?$AAp?$AAe?$AAc?$AAt?$AAe?$AAd?$AA?5?$AAi?$AAn?$AAp?$AAu?$AAt?$AA?5?$AAv?$AAa?$AAl?$AAu?$AAe?$AA?$DL?$AA?5?$AAl?$AAo?$AAg?$AA1?$AA0?$AA?5@ 01e9 ?make_big_integer@__crt_strtox@@YA?AUbig_integer@1@_K@Z 01f7 ??0big_integer@__crt_strtox@@QAE@XZ 0212 ?make_big_integer_power_of_two@__crt_strtox@@YA?AUbig_integer@1@I@Z 0222 ??9__crt_strtox@@YA_NABUbig_integer@0@0@Z 0242 ?shift_left@__crt_strtox@@YA_NAAUbig_integer@1@I@Z 0264 ??4big_integer@__crt_strtox@@QAEAAU01@ABU01@@Z 0365 ?multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@1@I@Z 0399 ?multiply@__crt_strtox@@YA_NAAUbig_integer@1@I@Z 03af ?divide@__crt_strtox@@YA_KAAUbig_integer@1@ABU21@@Z 04ce ?is_zero@__crt_strtox@@YA_NABUbig_integer@1@@Z 0532 ??_C@_1FG@MLHBDPBG@?$AAq?$AAu?$AAo?$AAt?$AAi?$AAe?$AAn?$AAt?$AA?5?$AA?$DM?$AA?5?$AAd?$AAi?$AAg?$AAi?$AAt?$AAs?$AA_?$AAp?$AAe?$AAr?$AA_?$AAi?$AAt?$AAe?$AAr?$AAa?$AAt?$AAi?$AAo?$AAn?$AA_@ 0629 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC E8 0E 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 1C 00 77 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 59 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8D 4D 08 89 8D 5C F1 FF FF 8B 95 5C F1 FF FF 8B 02 8B 52 04 B1 34 E8 ?? ?? ?? ?? 25 FF 07 00 00 83 E2 00 89 85 30 F1 FF FF 89 95 34 F1 FF FF 8B 85 30 F1 FF FF 0B 85 34 F1 FF FF 75 09 C6 85 73 F1 FF FF 01 EB 07 C6 85 73 F1 FF FF 00 8A 8D 73 F1 FF FF 88 8D 72 F1 FF FF 0F B6 95 72 F1 FF FF 85 D2 74 16 C7 85 3C F1 FF FF 00 00 00 00 C7 85 40 F1 FF FF 00 00 00 00 EB 14 C7 85 3C F1 FF FF 00 00 00 00 C7 85 40 F1 FF FF 00 00 10 00 8B 85 3C F1 FF FF 89 85 28 F1 FF FF 8B 8D 40 F1 FF FF 89 8D 2C F1 FF FF 0F B6 95 72 F1 FF FF 85 D2 74 0C C7 85 54 F1 FF FF 02 00 00 00 EB 0A C7 85 54 F1 FF FF 01 00 00 00 8B 85 54 F1 FF FF 89 85 38 F1 FF FF 8B 8D 5C F1 FF FF 8B 11 8B 41 04 25 FF FF 0F 00 03 95 28 F1 FF FF 13 85 2C F1 FF FF 89 95 20 F1 FF FF 89 85 24 F1 FF FF 8B 8D 5C F1 FF FF 8B 01 8B 51 04 B1 34 E8 ?? ?? ?? ?? 25 FF 07 00 00 83 E2 00 8B 95 38 F1 FF FF 8D 84 10 CC FB FF FF 89 85 6C F1 FF FF 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E8 ?? ?? ?? ?? 89 85 74 F1 FF FF 81 BD 74 F1 FF FF FF FF FF 7F 74 0C 81 BD 74 F1 FF FF 00 00 00 80 75 31 33 C9 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 7E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 85 74 F1 FF FF 00 00 00 00 8B 85 24 F1 FF FF 50 8B 8D 20 F1 FF FF 51 8D 95 2C FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8D 8D 5C FC FF FF E8 ?? ?? ?? ?? 83 BD 6C F1 FF FF 00 0F 8C 9F 00 00 00 6A 34 8D 85 8C FA FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 50 8D 8D 2C FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 74 3A 8B 85 6C F1 FF FF 83 C0 01 50 8D 8D 2C FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 6A 00 6A 02 8D 95 BC F8 FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 8D 5C FC FF FF E8 ?? ?? ?? ?? EB 38 8B 85 6C F1 FF FF 83 C0 02 50 8D 8D 2C FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 6A 00 6A 04 8D 95 EC F6 FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 8D 5C FC FF FF E8 ?? ?? ?? ?? E9 A6 00 00 00 81 BD 6C F1 FF FF 02 FC FF FF 74 28 6A 34 8D 85 1C F5 FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 50 8D 8D 2C FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 74 3A 6A 01 8D 85 2C FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 8B 8D 6C F1 FF FF F7 D9 83 C1 01 51 8D 95 4C F3 FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 50 8D 8D 5C FC FF FF E8 ?? ?? ?? ?? EB 38 6A 02 8D 85 2C FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 8B 8D 6C F1 FF FF F7 D9 83 C1 02 51 8D 95 7C F1 FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 50 8D 8D 5C FC FF FF E8 ?? ?? ?? ?? 83 BD 74 F1 FF FF 00 7C 18 8B 85 74 F1 FF FF 50 8D 8D 5C FC FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 EB 18 8B 95 74 F1 FF FF F7 DA 52 8D 85 2C FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 18 89 8D 78 F1 FF FF 6A 0A 8D 95 2C FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 8D 85 5C FC FF FF 50 8D 8D 2C FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 89 85 58 F1 FF FF 83 BD 58 F1 FF FF 0A 75 3A 8B 95 74 F1 FF FF 83 C2 01 89 95 74 F1 FF FF 8B 85 78 F1 FF FF C6 00 31 8B 8D 78 F1 FF FF 83 C1 01 89 8D 78 F1 FF FF 6A 0A 8D 95 5C FC FF FF 52 E8 ?? ?? ?? ?? 83 C4 08 EB 3A 83 BD 58 F1 FF FF 00 75 11 8B 85 74 F1 FF FF 83 E8 01 89 85 74 F1 FF FF EB 20 8B 8D 58 F1 FF FF 83 C1 30 8B 95 78 F1 FF FF 88 0A 8B 85 78 F1 FF FF 83 C0 01 89 85 78 F1 FF FF 8B 4D 14 8B 95 74 F1 FF FF 89 11 83 BD 74 F1 FF FF 00 7C 1A 81 7D 10 FF FF FF 7F 77 11 8B 85 74 F1 FF FF 03 45 10 89 85 50 F1 FF FF EB 09 8B 4D 10 89 8D 50 F1 FF FF 8B 95 50 F1 FF FF 89 95 4C F1 FF FF 8B 45 1C 83 E8 01 3B 85 4C F1 FF FF 73 0E 8B 4D 1C 83 E9 01 89 8D 48 F1 FF FF EB 0C 8B 95 4C F1 FF FF 89 95 48 F1 FF FF 8B 45 18 03 85 48 F1 FF FF 89 85 60 F1 FF FF 8B 8D 78 F1 FF FF 3B 8D 60 F1 FF FF 75 05 E9 54 01 00 00 8D 95 2C FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 0F B6 C0 85 C0 74 05 E9 39 01 00 00 C7 85 1C F1 FF FF 09 00 00 00 C7 85 18 F1 FF FF 00 CA 9A 3B 68 00 CA 9A 3B 8D 8D 2C FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 08 8D 95 5C FC FF FF 52 8D 85 2C FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 08 89 85 64 F1 FF FF 81 BD 64 F1 FF FF 00 CA 9A 3B 72 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 EA 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 85 68 F1 FF FF 08 00 00 00 EB 0F 8B 95 68 F1 FF FF 83 EA 01 89 95 68 F1 FF FF 83 BD 68 F1 FF FF FF 74 59 8B 85 64 F1 FF FF 33 D2 B9 0A 00 00 00 F7 F1 83 C2 30 88 95 71 F1 FF FF 8B 85 64 F1 FF FF 33 D2 B9 0A 00 00 00 F7 F1 89 85 64 F1 FF FF 8B 95 60 F1 FF FF 2B 95 78 F1 FF FF 3B 95 68 F1 FF FF 73 02 EB A5 8B 85 78 F1 FF FF 03 85 68 F1 FF FF 8A 8D 71 F1 FF FF 88 08 EB 8F 8B 95 60 F1 FF FF 2B 95 78 F1 FF FF 83 FA 09 76 0C C7 85 44 F1 FF FF 09 00 00 00 EB 12 8B 85 60 F1 FF FF 2B 85 78 F1 FF FF 89 85 44 F1 FF FF 8B 8D 78 F1 FF FF 03 8D 44 F1 FF FF 89 8D 78 F1 FF FF E9 99 FE FF FF 8B 95 78 F1 FF FF C6 02 00 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_1_0 {
	meta:
		name = "??0big_integer@__crt_strtox@@QAE@ABU01@@Z"
		size = 64
		refs = "0030 _memcpy_s"
		altNames = "??4big_integer@__crt_strtox@@QAEAAU01@ABU01@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 8B 11 89 10 8B 45 08 8B 08 C1 E1 02 51 8B 55 08 83 C2 04 52 68 CC 01 00 00 8B 45 FC 83 C0 04 50 E8 ?? ?? ?? ?? 83 C4 10 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_17_2_0 {
	meta:
		name = "??0big_integer@__crt_strtox@@QAE@XZ"
		size = 50
		refs = "0024 _memset"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 68 CC 01 00 00 68 CC 00 00 00 8B 4D FC 83 C1 04 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_3_0 {
	meta:
		name = "??0scoped_fp_state_reset@?A0x71ca7cfb@@QAE@XZ"
		size = 69
		refs = "000e _fegetenv 0030 _feholdexcept"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D FC 8B 11 83 E2 1F 83 FA 1F 75 09 8B 45 FC C6 40 08 00 EB 13 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 FC C6 42 08 01 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_4_0 {
	meta:
		name = "??1scoped_fp_state_reset@?A0x71ca7cfb@@QAE@XZ"
		size = 36
		refs = "0019 _fesetenv"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 0F B6 48 08 85 C9 74 0C 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_6_0 {
	meta:
		name = "??8__crt_strtox@@YA_NABUbig_integer@0@0@Z"
		size = 86
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8B 45 08 8B 4D 0C 8B 10 3B 11 74 04 32 C0 EB 3A C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D 08 8B 55 FC 3B 11 74 1C 8B 45 FC 8B 4D 08 8B 55 FC 8B 75 0C 8B 44 81 04 3B 44 96 04 74 04 32 C0 EB 04 EB D1 B0 01 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_7_0 {
	meta:
		name = "??9__crt_strtox@@YA_NABUbig_integer@0@0@Z"
		size = 52
		refs = "000f ??8__crt_strtox@@YA_NABUbig_integer@0@0@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_8_0 {
	meta:
		name = "?__acrt_fp_classify@@YA?AW4__acrt_fp_class@@ABN@Z"
		size = 274
		refs = "0019 __aullshr"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 8B 45 08 89 45 F8 8B 4D F8 8B 01 8B 51 04 B1 34 E8 ?? ?? ?? ?? 25 FF 07 00 00 83 E2 00 89 45 F0 89 55 F4 81 7D F0 FF 07 00 00 75 0C 83 7D F4 00 75 06 C6 45 FF 01 EB 04 C6 45 FF 00 8A 55 FF 88 55 FE 0F B6 45 FE 85 C0 75 0C 33 C0 E9 B5 00 00 00 E9 B0 00 00 00 8B 4D F8 8B 11 8B 41 04 25 FF FF 0F 00 89 55 E8 89 45 EC 8B 4D E8 0B 4D EC 75 0F B8 01 00 00 00 E9 8B 00 00 00 E9 86 00 00 00 8B 55 F8 8B 02 8B 52 04 B1 3F E8 ?? ?? ?? ?? 83 E0 01 83 E2 00 89 45 E0 89 55 E4 83 7D E0 01 75 32 83 7D E4 00 75 2C 8B 45 F8 8B 08 8B 50 04 81 E2 FF FF 0F 00 89 4D D8 89 55 DC 83 7D D8 00 75 12 81 7D DC 00 00 08 00 75 09 B8 04 00 00 00 EB 35 EB 33 8B 45 F8 8B 08 8B 50 04 81 E2 FF FF 0F 00 83 E1 00 81 E2 00 00 08 00 89 4D D0 89 55 D4 8B 45 D0 0B 45 D4 74 09 B8 02 00 00 00 EB 07 EB 05 B8 03 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_9_0 {
	meta:
		name = "?add_carry@__crt_strtox@@YAIAAIII@Z"
		size = 60
		refs = "0034 __aullshr"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 08 8B 08 33 D2 33 C0 03 4D 0C 13 D0 33 C0 03 4D 10 13 D0 89 4D F8 89 55 FC 8B 4D F8 8B 55 08 89 0A 8B 45 F8 8B 55 FC B1 20 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_10_0 {
	meta:
		name = "?add_multiply_carry@__crt_strtox@@YAIAAIIII@Z"
		size = 62
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 56 8B 45 0C F7 65 10 8B 4D 08 33 F6 03 01 13 D6 33 C9 03 45 14 13 D1 89 45 F8 89 55 FC 8B 55 F8 8B 45 08 89 10 B9 04 00 00 00 C1 E1 00 8B 44 0D F8 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_11_0 {
	meta:
		name = "?bit_scan_reverse@__crt_strtox@@YAII@Z"
		size = 44
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 0F BD 45 08 89 45 FC 0F 95 C1 0F B6 D1 85 D2 74 08 8B 45 FC 83 C0 01 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_12_0 {
	meta:
		name = "?count_sequential_high_zeroes@__crt_strtox@@YAII@Z"
		size = 52
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 0F BD 45 08 89 45 F8 0F 95 C1 0F B6 D1 85 D2 74 0D B8 1F 00 00 00 2B 45 F8 89 45 FC EB 07 C7 45 FC 20 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_13_0 {
	meta:
		name = "?divide@__crt_strtox@@YA_KAAUbig_integer@1@ABU21@@Z"
		size = 2676
		refs = "000c ___security_cookie 0035 ??_C@_1DI@GICAMMFM@?$AA?$CI?$AA?$CC?$AAD?$AAi?$AAv?$AAi?$AAs?$AAi?$AAo?$AAn?$AA?5?$AAb?$AAy?$AA?5?$AAz?$AAe?$AAr?$AAo?$AA?$CC?$AA?0?$AA?5?$AAf?$AAa?$AAl?$AAs?$AAe?$AA?$CJ?$AA?$AA@ 003a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0046 ??_C@_1GO@BFGDDONN@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 004d __CrtDbgReportW 00bf ??0big_integer@__crt_strtox@@QAE@XZ 00c8 ??4big_integer@__crt_strtox@@QAEAAU01@ABU01@@Z 01d5 __allshl 0226 __aulldiv 0255 __aullrem 028d __aullshr 0412 ?count_sequential_high_zeroes@__crt_strtox@@YAII@Z 0678 __allmul 07ef ?multiply_64_32@__crt_strtox@@YA_K_KI@Z 0a6c @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 30 06 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 8B 45 08 83 38 00 75 09 33 C0 33 D2 E9 3C 0A 00 00 8B 4D 0C 83 39 00 75 33 33 D2 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 DA 02 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 33 D2 E9 01 0A 00 00 8B 4D 08 8B 11 83 EA 01 89 95 78 FA FF FF 8B 45 0C 8B 08 83 E9 01 89 8D 2C FA FF FF 0F 85 74 02 00 00 BA 04 00 00 00 6B C2 00 8B 4D 0C 8B 54 01 04 89 95 3C FA FF FF 83 BD 3C FA FF FF 01 75 36 B8 04 00 00 00 6B C8 00 8B 55 08 8B 44 0A 04 89 85 D8 F9 FF FF 8D 8D 8C FA FF FF E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 33 D2 8B 85 D8 F9 FF FF E9 8B 09 00 00 83 BD 78 FA FF FF 00 0F 85 8E 00 00 00 B9 04 00 00 00 6B D1 00 8B 45 08 8B 4C 10 04 89 8D FC F9 FF FF 8D 8D 5C FC FF FF E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 85 FC F9 FF FF 33 D2 F7 B5 3C FA FF FF B8 04 00 00 00 6B C8 00 8B 45 08 89 54 08 04 B9 04 00 00 00 6B D1 00 8B 45 08 83 7C 10 04 00 76 0C C7 85 F8 F9 FF FF 01 00 00 00 EB 0A C7 85 F8 F9 FF FF 00 00 00 00 8B 4D 08 8B 95 F8 F9 FF FF 89 11 8B 85 FC F9 FF FF 33 D2 F7 B5 3C FA FF FF 33 D2 E9 F0 08 00 00 C7 85 18 FA FF FF 00 00 00 00 C7 85 1C FA FF FF 00 00 00 00 C7 85 58 FA FF FF 00 00 00 00 C7 85 5C FA FF FF 00 00 00 00 8B 85 78 FA FF FF 89 85 30 FA FF FF EB 0F 8B 8D 30 FA FF FF 83 E9 01 89 8D 30 FA FF FF 83 BD 30 FA FF FF FF 0F 84 A4 00 00 00 8B 85 58 FA FF FF 8B 95 5C FA FF FF B1 20 E8 ?? ?? ?? ?? 8B 8D 30 FA FF FF 8B 75 08 33 FF 0B 44 8E 04 0B D7 89 85 58 FA FF FF 89 95 5C FA FF FF 8B 85 18 FA FF FF 8B 95 1C FA FF FF B1 20 E8 ?? ?? ?? ?? 8B F0 8B FA 8B 95 3C FA FF FF 33 C0 50 52 8B 8D 5C FA FF FF 51 8B 95 58 FA FF FF 52 E8 ?? ?? ?? ?? 33 C9 03 F0 13 F9 89 B5 18 FA FF FF 89 BD 1C FA FF FF 8B 95 3C FA FF FF 33 C0 50 52 8B 8D 5C FA FF FF 51 8B 95 58 FA FF FF 52 E8 ?? ?? ?? ?? 89 85 58 FA FF FF 89 95 5C FA FF FF E9 40 FF FF FF 8D 8D 2C FE FF FF E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 8B 85 58 FA FF FF 8B 95 5C FA FF FF B1 20 E8 ?? ?? ?? ?? B9 04 00 00 00 C1 E1 00 8B 55 08 89 44 0A 04 8B 85 58 FA FF FF B9 04 00 00 00 6B D1 00 8B 4D 08 89 44 11 04 BA 04 00 00 00 C1 E2 00 8B 45 08 83 7C 10 04 00 76 0C C7 85 F4 F9 FF FF 02 00 00 00 EB 0A C7 85 F4 F9 FF FF 01 00 00 00 8B 4D 08 8B 95 F4 F9 FF FF 89 11 8B 85 18 FA FF FF 8B 95 1C FA FF FF E9 6B 07 00 00 8B 85 2C FA FF FF 3B 85 78 FA FF FF 76 09 33 C0 33 D2 E9 54 07 00 00 8B 8D 2C FA FF FF 83 C1 01 89 8D 84 FA FF FF 8B 95 78 FA FF FF 2B 95 2C FA FF FF 89 95 28 FA FF FF 8B 85 28 FA FF FF 89 85 54 FA FF FF 8B 8D 78 FA FF FF 89 8D 6C FA FF FF EB 0F 8B 95 6C FA FF FF 83 EA 01 89 95 6C FA FF FF 8B 85 6C FA FF FF 3B 85 28 FA FF FF 7D 11 8B 8D 54 FA FF FF 83 C1 01 89 8D 54 FA FF FF EB 5A 8B 95 6C FA FF FF 2B 95 28 FA FF FF 8B 45 0C 8B 8D 6C FA FF FF 8B 75 08 8B 54 90 04 3B 54 8E 04 74 33 8B 85 6C FA FF FF 2B 85 28 FA FF FF 8B 4D 0C 8B 95 6C FA FF FF 8B 75 08 8B 44 81 04 3B 44 96 04 73 0F 8B 8D 54 FA FF FF 83 C1 01 89 8D 54 FA FF FF EB 05 E9 78 FF FF FF 83 BD 54 FA FF FF 00 75 09 33 C0 33 D2 E9 7F 06 00 00 8B 95 84 FA FF FF 8B 45 0C 8B 0C 90 89 8D 64 FA FF FF 8B 95 84 FA FF FF 8B 45 0C 8B 4C 90 FC 89 8D 50 FA FF FF 8B 95 64 FA FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 89 85 68 FA FF FF B8 20 00 00 00 2B 85 68 FA FF FF 89 85 24 FA FF FF 83 BD 68 FA FF FF 00 76 62 8B 95 64 FA FF FF 8B 8D 68 FA FF FF D3 E2 8B 85 50 FA FF FF 8B 8D 24 FA FF FF D3 E8 0B D0 89 95 64 FA FF FF 8B 95 50 FA FF FF 8B 8D 68 FA FF FF D3 E2 89 95 50 FA FF FF 83 BD 84 FA FF FF 02 76 21 8B 85 84 FA FF FF 8B 4D 0C 8B 54 81 F8 8B 8D 24 FA FF FF D3 EA 0B 95 50 FA FF FF 89 95 50 FA FF FF C7 85 10 FA FF FF 00 00 00 00 C7 85 14 FA FF FF 00 00 00 00 8B 85 54 FA FF FF 89 85 88 FA FF FF 8B 8D 88 FA FF FF 83 E9 01 89 8D 88 FA FF FF 0F 88 15 05 00 00 8B 95 88 FA FF FF 03 95 84 FA FF FF 3B 95 78 FA FF FF 77 1B 8B 85 88 FA FF FF 03 85 84 FA FF FF 8B 4D 08 8B 54 81 04 89 95 08 FA FF FF EB 0A C7 85 08 FA FF FF 00 00 00 00 8B 85 08 FA FF FF 89 85 00 FA FF FF 8B 8D 88 FA FF FF 03 8D 84 FA FF FF 8B 55 08 8B 04 8A 33 C9 89 85 34 FA FF FF 89 8D 38 FA FF FF BA 04 00 00 00 C1 E2 00 8B 85 00 FA FF FF 89 84 15 34 FA FF FF 8B 8D 88 FA FF FF 03 8D 84 FA FF FF 8B 55 08 8B 44 8A FC 89 85 4C FA FF FF 83 BD 68 FA FF FF 00 0F 86 83 00 00 00 8B 85 34 FA FF FF 8B 95 38 FA FF FF 8B 8D 68 FA FF FF E8 ?? ?? ?? ?? 8B B5 4C FA FF FF 8B 8D 24 FA FF FF D3 EE 33 C9 0B C6 0B D1 89 85 34 FA FF FF 89 95 38 FA FF FF 8B 95 4C FA FF FF 8B 8D 68 FA FF FF D3 E2 89 95 4C FA FF FF 8B 85 88 FA FF FF 03 85 84 FA FF FF 83 F8 03 72 27 8B 8D 88 FA FF FF 03 8D 84 FA FF FF 8B 55 08 8B 44 8A F8 8B 8D 24 FA FF FF D3 E8 0B 85 4C FA FF FF 89 85 4C FA FF FF 8B 8D 64 FA FF FF 33 D2 52 51 8B 85 38 FA FF FF 50 8B 8D 34 FA FF FF 51 E8 ?? ?? ?? ?? 89 85 7C FA FF FF 89 95 80 FA FF FF 8B 95 64 FA FF FF 33 C0 50 52 8B 8D 38 FA FF FF 51 8B 95 34 FA FF FF 52 E8 ?? ?? ?? ?? 33 C9 89 85 40 FA FF FF 89 8D 44 FA FF FF 83 BD 80 FA FF FF 00 77 09 83 BD 7C FA FF FF FF 76 4F 8B 95 64 FA FF FF 33 C0 8B 8D 7C FA FF FF 83 E9 FF 8B B5 80 FA FF FF 83 DE 00 56 51 50 52 E8 ?? ?? ?? ?? 03 85 40 FA FF FF 13 95 44 FA FF FF 89 85 40 FA FF FF 89 95 44 FA FF FF C7 85 7C FA FF FF FF FF FF FF C7 85 80 FA FF FF 00 00 00 00 83 BD 44 FA FF FF 00 0F 87 C6 00 00 00 72 0D 83 BD 40 FA FF FF FF 0F 87 B7 00 00 00 8B 95 50 FA FF FF 33 C0 50 52 8B 8D 80 FA FF FF 51 8B 95 7C FA FF FF 52 E8 ?? ?? ?? ?? 8B F0 8B FA 8B 85 40 FA FF FF 8B 95 44 FA FF FF B1 20 E8 ?? ?? ?? ?? 33 C9 0B 85 4C FA FF FF 0B D1 89 B5 D0 F9 FF FF 89 BD D4 F9 FF FF 89 85 E4 F9 FF FF 89 95 E8 F9 FF FF 8B 95 D4 F9 FF FF 3B 95 E8 F9 FF FF 72 53 77 0E 8B 85 D0 F9 FF FF 3B 85 E4 F9 FF FF 76 43 8B 8D 7C FA FF FF 83 E9 01 8B 95 80 FA FF FF 83 DA 00 89 8D 7C FA FF FF 89 95 80 FA FF FF 8B 85 64 FA FF FF 33 C9 03 85 40 FA FF FF 13 8D 44 FA FF FF 89 85 40 FA FF FF 89 8D 44 FA FF FF E9 2D FF FF FF 83 BD 80 FA FF FF 00 77 0D 83 BD 7C FA FF FF 00 0F 86 26 02 00 00 C7 85 70 FA FF FF 00 00 00 00 C7 85 74 FA FF FF 00 00 00 00 C7 85 60 FA FF FF 00 00 00 00 EB 0F 8B 95 60 FA FF FF 83 C2 01 89 95 60 FA FF FF 8B 85 60 FA FF FF 3B 85 84 FA FF FF 0F 83 D1 00 00 00 8B 8D 60 FA FF FF 8B 55 0C 8B 44 8A 04 50 8B 8D 80 FA FF FF 51 8B 95 7C FA FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 03 85 70 FA FF FF 13 95 74 FA FF FF 89 85 70 FA FF FF 89 95 74 FA FF FF 8B 85 70 FA FF FF 89 85 04 FA FF FF 8B 85 70 FA FF FF 8B 95 74 FA FF FF B1 20 E8 ?? ?? ?? ?? 89 85 70 FA FF FF 89 95 74 FA FF FF 8B 8D 88 FA FF FF 03 8D 60 FA FF FF 8B 55 08 8B 44 8A 04 3B 85 04 FA FF FF 73 1E 8B 8D 70 FA FF FF 83 C1 01 8B 95 74 FA FF FF 83 D2 00 89 8D 70 FA FF FF 89 95 74 FA FF FF 8B 85 88 FA FF FF 03 85 60 FA FF FF 8B 4D 08 8B 54 81 04 2B 95 04 FA FF FF 8B 85 88 FA FF FF 03 85 60 FA FF FF 8B 4D 08 89 54 81 04 E9 0E FF FF FF 8B 95 00 FA FF FF 33 C0 89 95 DC F9 FF FF 89 85 E0 F9 FF FF 8B 8D E0 F9 FF FF 3B 8D 74 FA FF FF 0F 87 D8 00 00 00 72 12 8B 95 DC F9 FF FF 3B 95 70 FA FF FF 0F 83 C4 00 00 00 C7 85 0C FA FF FF 00 00 00 00 C7 85 48 FA FF FF 00 00 00 00 EB 0F 8B 85 48 FA FF FF 83 C0 01 89 85 48 FA FF FF 8B 8D 48 FA FF FF 3B 8D 84 FA FF FF 73 73 8B 95 88 FA FF FF 03 95 48 FA FF FF 8B 45 08 8B 4C 90 04 33 D2 8B 85 48 FA FF FF 8B 75 0C 33 FF 03 4C 86 04 13 D7 33 C0 03 8D 0C FA FF FF 13 D0 89 8D EC F9 FF FF 89 95 F0 F9 FF FF 8B 8D EC F9 FF FF 8B 95 88 FA FF FF 03 95 48 FA FF FF 8B 45 08 89 4C 90 04 8B 85 EC F9 FF FF 8B 95 F0 F9 FF FF B1 20 E8 ?? ?? ?? ?? 89 85 0C FA FF FF E9 70 FF FF FF 8B 8D 7C FA FF FF 83 E9 01 8B 95 80 FA FF FF 83 DA 00 89 8D 7C FA FF FF 89 95 80 FA FF FF 8B 85 84 FA FF FF 8B 8D 88 FA FF FF 8D 54 01 FF 89 95 78 FA FF FF 8B 85 10 FA FF FF 8B 95 14 FA FF FF B1 20 E8 ?? ?? ?? ?? 33 C9 03 85 7C FA FF FF 13 D1 89 85 10 FA FF FF 89 95 14 FA FF FF E9 D6 FA FF FF 8B 95 78 FA FF FF 83 C2 01 89 95 20 FA FF FF EB 0F 8B 85 20 FA FF FF 83 C0 01 89 85 20 FA FF FF 8B 4D 08 8B 95 20 FA FF FF 3B 11 73 13 8B 85 20 FA FF FF 8B 4D 08 C7 44 81 04 00 00 00 00 EB D1 8B 95 78 FA FF FF 83 C2 01 8B 45 08 89 10 8B 4D 08 83 39 00 74 1D 8B 55 08 8B 02 8B 4D 08 83 3C 81 00 75 0F 8B 55 08 8B 02 83 E8 01 8B 4D 08 89 01 EB DB 8B 85 10 FA FF FF 8B 95 14 FA FF FF 5F 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_14_0 {
	meta:
		name = "?is_zero@__crt_strtox@@YA_NABUbig_integer@1@@Z"
		size = 37
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 83 38 00 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_15_0 {
	meta:
		name = "?make_big_integer@__crt_strtox@@YA?AUbig_integer@1@_K@Z"
		size = 168
		refs = "000c ___security_cookie 001c ??0big_integer@__crt_strtox@@QAE@XZ 0041 __aullshr 0093 ??0big_integer@__crt_strtox@@QAE@ABU01@@Z 00a0 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC D8 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8D 8D 2C FE FF FF E8 ?? ?? ?? ?? 8B 45 0C 8B 4D 10 83 E1 00 BA 04 00 00 00 6B CA 00 89 84 0D 30 FE FF FF 8B 45 0C 8B 55 10 B1 20 E8 ?? ?? ?? ?? BA 04 00 00 00 C1 E2 00 89 84 15 30 FE FF FF B8 04 00 00 00 C1 E0 00 83 BC 05 30 FE FF FF 00 75 0C C7 85 28 FE FF FF 01 00 00 00 EB 0A C7 85 28 FE FF FF 02 00 00 00 8B 8D 28 FE FF FF 89 8D 2C FE FF FF 8D 95 2C FE FF FF 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_16_0 {
	meta:
		name = "?make_big_integer_power_of_two@__crt_strtox@@YA?AUbig_integer@1@I@Z"
		size = 172
		refs = "000c ___security_cookie 0026 ??0big_integer@__crt_strtox@@QAE@XZ 005c _memset 0097 ??0big_integer@__crt_strtox@@QAE@ABU01@@Z 00a4 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC E0 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC C7 85 20 FE FF FF 01 00 00 00 8D 8D 2C FE FF FF E8 ?? ?? ?? ?? 8B 45 0C C1 E8 05 89 85 28 FE FF FF 8B 45 0C 33 D2 B9 20 00 00 00 F7 F1 89 95 24 FE FF FF 8B 95 28 FE FF FF C1 E2 02 52 6A 00 8D 85 30 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C BA 01 00 00 00 8B 8D 24 FE FF FF D3 E2 8B 85 28 FE FF FF 89 94 85 30 FE FF FF 8B 8D 28 FE FF FF 83 C1 01 89 8D 2C FE FF FF 8D 95 2C FE FF FF 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_17_0 {
	meta:
		name = "?multiply@__crt_strtox@@YA_NAAUbig_integer@1@ABU21@@Z"
		size = 891
		refs = "000c ___security_cookie 0032 ?multiply@__crt_strtox@@YA_NAAUbig_integer@1@I@Z 0063 ??4big_integer@__crt_strtox@@QAEAAU01@ABU01@@Z 016e ??0big_integer@__crt_strtox@@QAE@XZ 029f ?add_multiply_carry@__crt_strtox@@YAIAAIIII@Z 0315 ?add_carry@__crt_strtox@@YAIAAIII@Z 0373 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC E8 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 83 38 01 77 21 B9 04 00 00 00 6B D1 00 8B 45 0C 8B 4C 10 04 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 E9 2F 03 00 00 8B 45 08 83 38 01 77 39 B9 04 00 00 00 6B D1 00 8B 45 08 8B 4C 10 04 89 8D 2C FC FF FF 8B 55 0C 52 8B 4D 08 E8 ?? ?? ?? ?? 8B 85 2C FC FF FF 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 E9 EE 02 00 00 8B 55 0C 8B 45 08 8B 0A 3B 08 73 09 C6 85 53 FC FF FF 01 EB 07 C6 85 53 FC FF FF 00 8A 95 53 FC FF FF 88 95 5B FC FF FF 0F B6 85 5B FC FF FF 85 C0 74 0E 8B 4D 0C 83 C1 04 89 8D 40 FC FF FF EB 0C 8B 55 08 83 C2 04 89 95 40 FC FF FF 8B 85 40 FC FF FF 89 85 24 FC FF FF 0F B6 8D 5B FC FF FF 85 C9 74 0E 8B 55 08 83 C2 04 89 95 3C FC FF FF EB 0C 8B 45 0C 83 C0 04 89 85 3C FC FF FF 8B 8D 3C FC FF FF 89 8D 1C FC FF FF 0F B6 95 5B FC FF FF 85 D2 74 0D 8B 45 0C 8B 08 89 8D 38 FC FF FF EB 0B 8B 55 08 8B 02 89 85 38 FC FF FF 8B 8D 38 FC FF FF 89 8D 28 FC FF FF 0F B6 95 5B FC FF FF 85 D2 74 0D 8B 45 08 8B 08 89 8D 34 FC FF FF EB 0B 8B 55 0C 8B 02 89 85 34 FC FF FF 8B 8D 34 FC FF FF 89 8D 20 FC FF FF 8D 8D 2C FE FF FF E8 ?? ?? ?? ?? C7 85 4C FC FF FF 00 00 00 00 EB 0F 8B 95 4C FC FF FF 83 C2 01 89 95 4C FC FF FF 8B 85 4C FC FF FF 3B 85 28 FC FF FF 0F 84 BD 01 00 00 8B 8D 4C FC FF FF 8B 95 24 FC FF FF 8B 04 8A 89 85 30 FC FF FF 83 BD 30 FC FF FF 00 75 30 8B 8D 4C FC FF FF 3B 8D 2C FE FF FF 75 20 8B 95 4C FC FF FF C7 84 95 30 FE FF FF 00 00 00 00 8B 85 4C FC FF FF 83 C0 01 89 85 2C FE FF FF EB 91 C7 85 48 FC FF FF 00 00 00 00 8B 8D 4C FC FF FF 89 8D 54 FC FF FF C7 85 44 FC FF FF 00 00 00 00 EB 1E 8B 95 44 FC FF FF 83 C2 01 89 95 44 FC FF FF 8B 85 54 FC FF FF 83 C0 01 89 85 54 FC FF FF 8B 8D 44 FC FF FF 3B 8D 20 FC FF FF 74 76 83 BD 54 FC FF FF 73 74 6D 8B 95 54 FC FF FF 3B 95 2C FE FF FF 75 20 8B 85 54 FC FF FF C7 84 85 30 FE FF FF 00 00 00 00 8B 8D 54 FC FF FF 83 C1 01 89 8D 2C FE FF FF 8B 95 48 FC FF FF 52 8B 85 44 FC FF FF 8B 8D 1C FC FF FF 8B 14 81 52 8B 85 30 FC FF FF 50 8B 8D 54 FC FF FF 8D 94 8D 30 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 89 85 48 FC FF FF E9 5E FF FF FF 83 BD 48 FC FF FF 00 74 7C 83 BD 54 FC FF FF 73 74 73 8B 85 54 FC FF FF 3B 85 2C FE FF FF 75 20 8B 8D 54 FC FF FF C7 84 8D 30 FE FF FF 00 00 00 00 8B 95 54 FC FF FF 83 C2 01 89 95 2C FE FF FF 8B 85 54 FC FF FF 8D 8C 85 30 FE FF FF 89 8D 18 FC FF FF 8B 95 48 FC FF FF 52 6A 00 8B 85 18 FC FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 89 85 48 FC FF FF 8B 8D 54 FC FF FF 83 C1 01 89 8D 54 FC FF FF E9 7B FF FF FF 83 BD 54 FC FF FF 73 75 18 8D 8D 5C FC FF FF E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 32 C0 EB 16 E9 22 FE FF FF 8D 95 2C FE FF FF 52 8B 4D 08 E8 ?? ?? ?? ?? B0 01 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_18_0 {
	meta:
		name = "?multiply@__crt_strtox@@YA_NAAUbig_integer@1@I@Z"
		size = 197
		refs = "000c ___security_cookie 0022 ??0big_integer@__crt_strtox@@QAE@XZ 002b ??4big_integer@__crt_strtox@@QAEAAU01@ABU01@@Z 005e ?multiply_core@__crt_strtox@@YAIQAIII@Z 00bd @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC A8 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 0C 00 75 1B 8D 8D 2C FE FF FF E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? B0 01 E9 81 00 00 00 83 7D 0C 01 75 04 B0 01 EB 77 8B 45 08 83 38 00 75 04 B0 01 EB 6B 8B 4D 0C 51 8B 55 08 8B 02 50 8B 4D 08 83 C1 04 51 E8 ?? ?? ?? ?? 83 C4 0C 89 85 58 FC FF FF 83 BD 58 FC FF FF 00 74 41 8B 55 08 83 3A 73 73 21 8B 45 08 8B 08 8B 55 08 8B 85 58 FC FF FF 89 44 8A 04 8B 4D 08 8B 11 83 C2 01 8B 45 08 89 10 EB 18 8D 8D 5C FC FF FF E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 32 C0 EB 02 B0 01 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_19_0 {
	meta:
		name = "?multiply_64_32@__crt_strtox@@YA_K_KI@Z"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C F7 65 10 8B C8 8B 45 08 F7 65 10 03 D1 5D C3 }
	condition:
		$1
}

rule file_17_20_0 {
	meta:
		name = "?multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@1@I@Z"
		size = 408
		refs = "000c ___security_cookie 006a ?large_power_indices@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBUunpack_index@?1??12@YA_N0I@Z@B 007b ??0big_integer@__crt_strtox@@QAE@XZ 00a7 ?large_power_data@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBIB 00c9 _memset 00f8 _memcpy 010b ?multiply@__crt_strtox@@YA_NAAUbig_integer@1@ABU21@@Z 0129 ??4big_integer@__crt_strtox@@QAEAAU01@ABU01@@Z 016c ?small_powers_of_ten@?1??multiply_by_power_of_ten@__crt_strtox@@YA_NAAUbig_integer@2@I@Z@4QBIB 0176 ?multiply@__crt_strtox@@YA_NAAUbig_integer@1@I@Z 0190 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC BC 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 33 D2 B9 0A 00 00 00 F7 F1 89 85 54 FC FF FF 83 BD 54 FC FF FF 00 0F 84 14 01 00 00 83 BD 54 FC FF FF 26 76 0C C7 85 50 FC FF FF 26 00 00 00 EB 0C 8B 95 54 FC FF FF 89 95 50 FC FF FF 8B 85 50 FC FF FF 89 85 4C FC FF FF 8B 8D 4C FC FF FF 8D 14 8D ?? ?? ?? ?? 89 95 58 FC FF FF 8D 8D 2C FE FF FF E8 ?? ?? ?? ?? 8B 85 58 FC FF FF 0F B6 48 03 8B 95 58 FC FF FF 0F B6 42 02 03 C8 89 8D 2C FE FF FF 8B 8D 58 FC FF FF 0F B7 11 8D 04 95 ?? ?? ?? ?? 89 85 44 FC FF FF 8B 8D 58 FC FF FF 0F B6 51 02 C1 E2 02 52 6A 00 8D 85 30 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 8D 58 FC FF FF 0F B6 51 03 C1 E2 02 52 8B 85 44 FC FF FF 50 8B 8D 58 FC FF FF 0F B6 51 02 8D 84 95 30 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 8D 2C FE FF FF 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C0 85 C0 75 18 8D 8D 5C FC FF FF E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 32 C0 EB 59 8B 8D 54 FC FF FF 2B 8D 4C FC FF FF 89 8D 54 FC FF FF E9 DF FE FF FF 8B 45 0C 33 D2 B9 0A 00 00 00 F7 F1 89 95 48 FC FF FF 83 BD 48 FC FF FF 00 74 25 8B 95 48 FC FF FF 8B 04 95 ?? ?? ?? ?? 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 0F B6 D0 85 D2 75 04 32 C0 EB 02 B0 01 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_21_0 {
	meta:
		name = "?multiply_core@__crt_strtox@@YAIQAIII@Z"
		size = 103
		refs = "0057 __aullshr"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 3B 4D 0C 74 37 8B 55 FC 8B 45 08 8B 04 90 F7 65 10 33 C9 03 45 F8 13 D1 89 45 F0 89 55 F4 8B 55 F0 8B 45 FC 8B 4D 08 89 14 81 8B 45 F0 8B 55 F4 B1 20 E8 ?? ?? ?? ?? 89 45 F8 EB B8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_22_0 {
	meta:
		name = "?shift_left@__crt_strtox@@YA_NAAUbig_integer@1@I@Z"
		size = 844
		refs = "000c ___security_cookie 0072 __allshl 009d ?bit_scan_reverse@__crt_strtox@@YAII@Z 014f ??0big_integer@__crt_strtox@@QAE@XZ 0158 ??4big_integer@__crt_strtox@@QAEAAU01@ABU01@@Z 0344 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 34 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C C1 E8 05 89 85 24 FE FF FF 8B 45 0C 33 D2 B9 20 00 00 00 F7 F1 89 95 10 FE FF FF C7 85 CC FD FF FF 01 00 00 00 C7 85 D0 FD FF FF 00 00 00 00 8B 95 10 FE FF FF 89 95 F4 FD FF FF B8 20 00 00 00 2B 85 F4 FD FF FF 89 85 F0 FD FF FF B8 01 00 00 00 33 D2 8B 8D F0 FD FF FF E8 ?? ?? ?? ?? 83 E8 01 83 DA 00 89 85 F8 FD FF FF 8B 8D F8 FD FF FF F7 D1 89 8D E0 FD FF FF 8B 55 08 8B 02 8B 4D 08 8B 14 81 52 E8 ?? ?? ?? ?? 83 C4 04 B9 20 00 00 00 2B C8 39 8D 10 FE FF FF 76 09 C6 85 2B FE FF FF 01 EB 07 C6 85 2B FE FF FF 00 8A 95 2B FE FF FF 88 95 28 FE FF FF 8B 45 08 8B 08 03 8D 24 FE FF FF 83 F9 73 76 09 C6 85 2A FE FF FF 01 EB 07 C6 85 2A FE FF FF 00 8A 95 2A FE FF FF 88 95 23 FE FF FF 8B 45 08 8B 08 03 8D 24 FE FF FF 83 F9 73 75 14 0F B6 95 28 FE FF FF 85 D2 74 09 C6 85 29 FE FF FF 01 EB 07 C6 85 29 FE FF FF 00 8A 85 29 FE FF FF 88 85 22 FE FF FF 0F B6 8D 23 FE FF FF 85 C9 75 0B 0F B6 95 22 FE FF FF 85 D2 74 1B 8D 8D 2C FE FF FF E8 ?? ?? ?? ?? 50 8B 4D 08 E8 ?? ?? ?? ?? 32 C0 E9 DB 01 00 00 8B 45 08 8B 08 03 8D 24 FE FF FF 83 F9 72 73 13 8B 55 08 8B 02 03 85 24 FE FF FF 89 85 0C FE FF FF EB 0A C7 85 0C FE FF FF 72 00 00 00 8B 8D 0C FE FF FF 89 8D 14 FE FF FF 8B 95 14 FE FF FF 89 95 1C FE FF FF EB 0F 8B 85 1C FE FF FF 83 E8 01 89 85 1C FE FF FF 83 BD 1C FE FF FF FF 0F 84 07 01 00 00 8B 8D 1C FE FF FF 3B 8D 24 FE FF FF 0F 82 F5 00 00 00 8B 95 1C FE FF FF 2B 95 24 FE FF FF 89 95 08 FE FF FF 8B 85 1C FE FF FF 2B 85 24 FE FF FF 83 E8 01 89 85 00 FE FF FF 8B 4D 08 8B 95 08 FE FF FF 3B 11 73 15 8B 85 08 FE FF FF 8B 4D 08 8B 54 81 04 89 95 04 FE FF FF EB 0A C7 85 04 FE FF FF 00 00 00 00 8B 85 04 FE FF FF 89 85 E8 FD FF FF 8B 4D 08 8B 95 00 FE FF FF 3B 11 73 15 8B 85 00 FE FF FF 8B 4D 08 8B 54 81 04 89 95 FC FD FF FF EB 0A C7 85 FC FD FF FF 00 00 00 00 8B 85 FC FD FF FF 89 85 E4 FD FF FF 8B 95 E8 FD FF FF 23 95 F8 FD FF FF 8B 8D F4 FD FF FF D3 E2 89 95 DC FD FF FF 8B 85 E4 FD FF FF 23 85 E0 FD FF FF 8B 8D F0 FD FF FF D3 E8 89 85 D8 FD FF FF 8B 8D DC FD FF FF 0B 8D D8 FD FF FF 89 8D D4 FD FF FF 8B 95 1C FE FF FF 8B 45 08 8B 8D D4 FD FF FF 89 4C 90 04 E9 DD FE FF FF C7 85 18 FE FF FF 00 00 00 00 EB 0F 8B 95 18 FE FF FF 83 C2 01 89 95 18 FE FF FF 8B 85 18 FE FF FF 3B 85 24 FE FF FF 74 13 8B 8D 18 FE FF FF 8B 55 08 C7 44 8A 04 00 00 00 00 EB D0 0F B6 85 28 FE FF FF 85 C0 74 11 8B 8D 14 FE FF FF 83 C1 01 89 8D EC FD FF FF EB 0C 8B 95 14 FE FF FF 89 95 EC FD FF FF 8B 45 08 8B 8D EC FD FF FF 89 08 B0 01 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_17_23_0 {
	meta:
		name = "___acrt_fltout"
		size = 664
		refs = "000c ??0scoped_fp_state_reset@?A0x71ca7cfb@@QAE@XZ 0021 __aullshr 00c4 ??_C@_1GC@DDAKNBNC@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 00c9 ??_C@_1BM@FAAOAKKO@?$AA_?$AA_?$AAa?$AAc?$AAr?$AAt?$AA_?$AAf?$AAl?$AAt?$AAo?$AAu?$AAt?$AA?$AA@ 00ce ??_C@_1EI@OACEJKEP@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?0?$AA?5?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?0?$AA?5?$AA?$CC@ 00d3 ??_C@_01GBGANLPD@0?$AA@ 00e0 _strcpy_s 00e9 __invoke_watson_if_error 00f4 ??1scoped_fp_state_reset@?A0x71ca7cfb@@QAE@XZ 0102 ?__acrt_fp_classify@@YA?AW4__acrt_fp_class@@ABN@Z 013b $LN15 0151 ??_C@_1FC@KIECGFMP@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?0?$AA?5?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?0?$AA?5?$AA?$CC@ 0156 ??_C@_05DNEBIAHO@1?$CDINF?$AA@ 0192 ??_C@_1FC@NFPJEIBD@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?0?$AA?5?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?0?$AA?5?$AA?$CC@ 0197 ??_C@_06IMKFLFPG@1?$CDQNAN?$AA@ 01d3 ??_C@_1FC@DEJHIMLO@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?0?$AA?5?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?0?$AA?5?$AA?$CC@ 01d8 ??_C@_06PGGFOGJG@1?$CDSNAN?$AA@ 0214 ??_C@_1FC@KMLHLFPC@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?0?$AA?5?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?0?$AA?5?$AA?$CC@ 0219 ??_C@_05PHHOCPM@1?$CDIND?$AA@ 0275 ??$convert_to_fos_high_precision@N@@YAXNIQAHQADI@Z 0288 $LN6 028c $LN7 0290 $LN8 0294 $LN9"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 8D 4D CC E8 ?? ?? ?? ?? 8D 45 08 89 45 F8 8B 4D F8 8B 01 8B 51 04 B1 3F E8 ?? ?? ?? ?? 83 E0 01 83 E2 00 89 45 E8 89 55 EC 83 7D E8 01 75 0C 83 7D EC 00 75 06 C6 45 FF 2D EB 04 C6 45 FF 20 0F BE 55 FF 8B 45 14 89 10 8B 4D 14 8B 55 18 89 51 08 8B 4D F8 8B 01 8B 51 04 B1 34 E8 ?? ?? ?? ?? 25 FF 07 00 00 83 E2 00 89 45 E0 89 55 E4 8B 55 E0 0B 55 E4 75 22 8B 45 F8 8B 08 8B 50 04 81 E2 FF FF 0F 00 89 4D D8 89 55 DC 8B 45 D8 0B 45 DC 75 06 C6 45 FE 01 EB 04 C6 45 FE 00 8A 4D FE 88 4D FD 0F B6 55 FD 85 D2 74 4B 8B 45 14 C7 40 04 00 00 00 00 6A 00 68 1A 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 1C 51 8B 55 18 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8D 4D CC E8 ?? ?? ?? ?? E9 87 01 00 00 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 83 7D F0 00 74 0A 8B 4D 14 C7 41 04 01 00 00 00 8B 55 F0 89 55 F4 8B 45 F4 83 E8 01 89 45 F4 83 7D F4 03 0F 87 0B 01 00 00 8B 4D F4 FF 24 8D ?? ?? ?? ?? 6A 00 68 27 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 1C 52 8B 45 18 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8D 4D CC E8 ?? ?? ?? ?? E9 04 01 00 00 6A 00 68 28 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 1C 51 8B 55 18 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8D 4D CC E8 ?? ?? ?? ?? E9 C3 00 00 00 6A 00 68 29 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 1C 50 8B 4D 18 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8D 4D CC E8 ?? ?? ?? ?? E9 82 00 00 00 6A 00 68 2A 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 1C 52 8B 45 18 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8D 4D CC E8 ?? ?? ?? ?? EB 44 8B 4D F8 8B 11 8B 41 04 25 FF FF FF 7F 8B 4D F8 89 11 89 41 04 8B 55 1C 52 8B 45 18 50 8B 4D 14 83 C1 04 51 8B 55 10 83 C2 01 52 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 8D 4D CC E8 ?? ?? ?? ?? 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_17_24_0 {
	meta:
		name = "__invoke_watson_if_error"
		size = 40
		refs = "0022 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 02 EB 19 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_17_25_0 {
	meta:
		name = "_memcpy_s"
		size = 266
		refs = "0038 __errno 0043 __invalid_parameter_noinfo 006e _memset 00fd _memcpy"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 83 7D 14 00 75 07 33 C0 E9 F1 00 00 00 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F0 83 7D F0 00 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 E9 B5 00 00 00 83 7D 10 00 74 0C 8B 4D 0C 3B 4D 14 0F 83 8D 00 00 00 8B 55 0C 52 6A 00 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 10 00 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8B 4D F8 89 4D EC 83 7D EC 00 75 17 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? B8 16 00 00 00 EB 58 8B 55 0C 3B 55 14 72 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 E8 83 7D E8 00 75 17 E8 ?? ?? ?? ?? C7 00 22 00 00 00 E8 ?? ?? ?? ?? B8 22 00 00 00 EB 1D B8 16 00 00 00 EB 16 8B 4D 14 51 8B 55 10 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "__getsystime"
		size = 199
		refs = "0009 ___security_cookie 0023 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0028 ??_C@_1GI@KABKGELF@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 002e ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0039 __CrtDbgReportW 0047 __errno 0051 ??_C@_1BI@GOANMKLL@?$AA_?$AAg?$AAe?$AAt?$AAs?$AAy?$AAs?$AAt?$AAi?$AAm?$AAe?$AA?$AA@ 005d __invalid_parameter 006f __imp__GetLocalTime@4 00af __mktime32 00bf @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 33 C0 56 8B 75 08 85 F6 0F 95 C0 85 C0 75 48 57 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 50 6A 10 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 6A 10 57 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5F EB 4F 8D 45 EC 50 FF 15 ?? ?? ?? ?? 0F B7 45 F8 83 4E 20 FF 89 06 0F B7 45 F6 89 46 04 0F B7 45 F4 89 46 08 0F B7 45 F2 89 46 0C 0F B7 45 EE 48 89 46 10 0F B7 45 EC 2D 6C 07 00 00 89 46 14 0F B7 45 F0 56 89 46 18 E8 ?? ?? ?? ?? 0F B7 45 FA 59 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_18_1_0 {
	meta:
		name = "__setsystime"
		size = 173
		refs = "0009 ___security_cookie 001b ??_C@_1CE@HMDIBIP@?$AAs?$AAo?$AAu?$AAr?$AAc?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0020 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0028 ??_C@_1GI@KABKGELF@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 002f __CrtDbgReportW 0043 __mktime32 008c __imp__SetLocalTime@4 0096 __imp__GetLastError@0 00a5 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 75 08 85 F6 75 27 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 6A 2B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 6A 57 58 EB 5D 56 E8 ?? ?? ?? ?? B8 6C 07 00 00 66 03 46 14 66 89 45 EC 66 8B 46 10 66 40 66 89 45 EE 66 8B 46 0C 66 89 45 F2 66 8B 46 08 66 89 45 F4 66 8B 46 04 66 89 45 F6 66 8B 06 66 89 45 F8 66 8B 45 0C 66 89 45 FA 8D 45 EC 59 50 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_0_0 {
	meta:
		name = "??0?$__crt_scoped_stack_ptr@_W@@QAE@U?$__crt_scoped_stack_ptr_tag@_W@@@Z"
		size = 26
		altNames = "??0?$__crt_scoped_stack_ptr@D@@QAE@U?$__crt_scoped_stack_ptr_tag@D@@@Z ??0?$__crt_scoped_stack_ptr_tag@D@@QAE@QAD@Z ??0?$__crt_scoped_stack_ptr_tag@_W@@QAE@QA_W@Z ??0?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QAE@QAX@Z ??0?$__crt_unique_handle_t@U__crt_handle_traits@@@@QAE@QAX@Z ??0?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QAE@QAUHINSTANCE__@@@Z ??0?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QAE@QBD@Z ??0?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QAE@QB_W@Z ??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@QAD@Z ??0?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAE@QAD@Z ??0?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAE@QAE@Z ??0?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QAE@QAG@Z ??0?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QAE@QAJ@Z ??0?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QAE@QAP6AXXZ@Z ??0?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAE@QAPAD@Z ??0?$__crt_unique_heap_ptr@PAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAE@QAPAU__crt_stdio_stream_data@@@Z ??0?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAE@QAPA_W@Z ??0?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QAE@QAU?$__crt_report_hook_node@D@@@Z ??0?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QAE@QAU?$__crt_report_hook_node@_W@@@Z ??0?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QAE@QAU__acrt_ptd@@@Z ??0?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QAE@QAU__acrt_thread_parameter@@@Z ??0?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QAE@QAU__acrt_thread_parameter@@@Z ??0?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QAE@QAU__crt_lc_time_data@@@Z ??0?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QAE@QAU__crt_locale_data@@@Z ??0?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QAE@QAU__crt_locale_pointers@@@Z ??0?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QAE@QAU__crt_lowio_handle_data@@@Z ??0?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QAE@QAU__crt_multibyte_data@@@Z ??0?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAE@QAU__crt_stdio_stream_data@@@Z ??0?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QAE@QAUlconv@@@Z ??0?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QAE@QAUtm@@@Z ??0?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAE@QA_W@Z ??0?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAE@QA_W@Z ??0?$string_output_adapter@D@__crt_stdio_output@@QAE@QAU?$string_output_adapter_context@D@1@@Z ??0?$string_output_adapter@_W@__crt_stdio_output@@QAE@QAU?$string_output_adapter_context@_W@1@@Z ??0__crt_stdio_stream@@QAE@QAU__crt_stdio_stream_data@@@Z ??0__crt_stdio_stream@@QAE@QAU_iobuf@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 4D 08 89 08 8B 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_19_3_0 {
	meta:
		name = "??1?$__crt_scoped_stack_ptr@_W@@QAE@XZ"
		size = 27
		refs = "0010 __freea_crt"
		altNames = "??1?$__crt_scoped_stack_ptr@D@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_5_0 {
	meta:
		name = "??B?$__crt_scoped_stack_ptr@_W@@QBE_NXZ"
		size = 42
		altNames = "??B?$__crt_scoped_stack_ptr@D@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QBE_NXZ ?is_valid@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QBE_NXZ ?valid@__crt_stdio_stream@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 83 38 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_7_0 {
	meta:
		name = "?_wcslwr_s_l_stat@@YAHPA_WIPAU__crt_locale_pointers@@@Z"
		size = 1193
		refs = "002b ??_C@_1CA@CHADEKIG@?$AAw?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0030 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0039 ??_C@_1GC@LGHAKKND@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0040 __CrtDbgReportW 0054 __errno 0068 ??_C@_1CC@EJPJEJKL@?$AA_?$AAw?$AAc?$AAs?$AAl?$AAw?$AAr?$AA_?$AAs?$AA_?$AAl?$AA_?$AAs?$AAt?$AAa?$AAt?$AA?$AA@ 0072 __invalid_parameter 008c _wcsnlen 00c0 __CrtGetDebugFillThreshold 00f6 _memset 00fe ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 0127 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 026b ___acrt_LCMapStringW 02fa ??_C@_1CI@HCPHDDLE@?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$AA@ 0323 ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0388 __MallocaComputeSize 039e ??_C@_0DB@NINDGFFI@minkernel?2crts?2ucrt?2src?2appcrt?2s@ 03b4 __malloc_dbg 03bd __MarkAllocaS 03d8 ??0?$__crt_scoped_stack_ptr_tag@_W@@QAE@QA_W@Z 03e3 ??0?$__crt_scoped_stack_ptr@_W@@QAE@U?$__crt_scoped_stack_ptr_tag@_W@@@Z 03eb ??B?$__crt_scoped_stack_ptr@_W@@QBE_NXZ 040f ??1?$__crt_scoped_stack_ptr@_W@@QAE@XZ 0423 ?get@?$__crt_scoped_stack_ptr@_W@@QBEPA_WXZ 0465 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 54 83 7D 08 00 74 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 45 EC 89 45 E8 83 7D E8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 69 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 69 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 22 04 00 00 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 8B 4D F4 3B 4D 0C 0F 82 DD 00 00 00 33 D2 8B 45 08 66 89 10 83 7D 0C FF 74 4D 81 7D 0C FF FF FF 7F 74 44 83 7D 0C 01 76 3E E8 ?? ?? ?? ?? 89 45 E4 8B 4D 0C 83 E9 01 39 4D E4 73 08 8B 55 E4 89 55 E0 EB 09 8B 45 0C 83 E8 01 89 45 E0 8B 4D E0 D1 E1 51 68 FE 00 00 00 8B 55 08 83 C2 02 52 E8 ?? ?? ?? ?? 83 C4 0C B8 ?? ?? ?? ?? 85 C0 74 0D 33 C9 74 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 55 DC 89 55 D8 83 7D D8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 6E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 26 03 00 00 83 7D 0C FF 74 60 81 7D 0C FF FF FF 7F 74 57 8B 4D F4 83 C1 01 3B 4D 0C 73 4C E8 ?? ?? ?? ?? 89 45 D4 8B 55 F4 83 C2 01 8B 45 0C 2B C2 39 45 D4 73 08 8B 4D D4 89 4D D0 EB 0E 8B 55 F4 83 C2 01 8B 45 0C 2B C2 89 45 D0 8B 4D D0 D1 E1 51 68 FE 00 00 00 8B 55 F4 8B 45 08 8D 4C 50 02 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 10 8B 02 B9 04 00 00 00 D1 E1 83 BC 08 A0 00 00 00 00 75 4C 8B 55 08 89 55 FC EB 09 8B 45 FC 83 C0 02 89 45 FC 8B 4D FC 0F B7 11 85 D2 74 2A 8B 45 FC 0F B7 08 83 F9 41 7C 1D 8B 55 FC 0F B7 02 83 F8 5A 7F 12 8B 4D FC 0F B7 11 81 EA E0 FF 00 00 8B 45 FC 66 89 10 EB C3 33 C0 E9 5E 02 00 00 6A 00 6A 00 6A FF 8B 4D 08 51 68 00 01 00 00 8B 55 10 8B 02 B9 04 00 00 00 D1 E1 8B 94 08 A0 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 F0 83 7D F0 00 75 17 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 13 02 00 00 8B 45 0C 3B 45 F0 0F 83 E3 00 00 00 33 C9 8B 55 08 66 89 0A 83 7D 0C FF 74 4D 81 7D 0C FF FF FF 7F 74 44 83 7D 0C 01 76 3E E8 ?? ?? ?? ?? 89 45 CC 8B 45 0C 83 E8 01 39 45 CC 73 08 8B 4D CC 89 4D C8 EB 09 8B 55 0C 83 EA 01 89 55 C8 8B 45 C8 D1 E0 50 68 FE 00 00 00 8B 4D 08 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C BA ?? ?? ?? ?? 85 D2 74 0D 33 C0 74 09 C7 45 C4 01 00 00 00 EB 07 C7 45 C4 00 00 00 00 8B 4D C4 89 4D C0 83 7D C0 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 90 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D C0 00 75 33 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 90 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 E9 24 01 00 00 8B 45 F0 D1 E0 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 36 68 DD DD 00 00 68 94 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D F0 D1 E1 51 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 BC EB 07 C7 45 BC 00 00 00 00 8B 55 BC 52 8D 4D AC E8 ?? ?? ?? ?? 8B 00 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 25 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 10 89 55 B8 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 B8 E9 8A 00 00 00 8B 45 F0 50 8D 4D F8 E8 ?? ?? ?? ?? 50 6A FF 8B 4D 08 51 68 00 01 00 00 8B 55 10 8B 02 B9 04 00 00 00 D1 E1 8B 94 08 A0 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 2B 8D 4D F8 E8 ?? ?? ?? ?? 50 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 B4 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 B4 EB 29 EB 1F E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 B0 2A 00 00 00 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 B0 EB 08 8D 4D F8 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_8_0 {
	meta:
		name = "?get@?$__crt_scoped_stack_ptr@_W@@QBEPA_WXZ"
		size = 18
		altNames = "??C__crt_stdio_stream@@QBEPAU__crt_stdio_stream_data@@XZ ?begin@?$argument_list@D@?A0x5f5c8891@@QBEPAPADXZ ?begin@?$argument_list@_W@?A0x5f5c8891@@QBEPAPA_WXZ ?get@?$__crt_scoped_stack_ptr@D@@QBEPADXZ ?get@?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QBEPAXXZ ?get@?$__crt_unique_handle_t@U__crt_handle_traits@@@@QBEPAXXZ ?get@?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QBEPAUHINSTANCE__@@XZ ?get@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QBEPBDXZ ?get@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QBEPB_WXZ ?get@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBEPADXZ ?get@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QBEPADXZ ?get@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QBEPAEXZ ?get@?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QBEPAPADXZ ?get@?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QBEPAPA_WXZ ?get@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QBEPAU?$__crt_report_hook_node@D@@XZ ?get@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QBEPAU?$__crt_report_hook_node@_W@@XZ ?get@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QBEPAU__acrt_ptd@@XZ ?get@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QBEPAU__acrt_thread_parameter@@XZ ?get@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QBEPAU__crt_lc_time_data@@XZ ?get@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QBEPAU__crt_locale_data@@XZ ?get@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QBEPAU__crt_locale_pointers@@XZ ?get@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QBEPAU__crt_lowio_handle_data@@XZ ?get@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QBEPAU__crt_multibyte_data@@XZ ?get@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QBEPA_WXZ ?get@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QBEPA_WXZ ?public_stream@__crt_stdio_stream@@QBEPAU_iobuf@@XZ ?save_state@?$c_string_character_source@D@__crt_strtox@@QBEPBDXZ ?save_state@?$c_string_character_source@_W@__crt_strtox@@QBEPB_WXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_9_0 {
	meta:
		name = "__MallocaComputeSize"
		size = 47
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 08 83 C0 08 89 45 FC 8B 4D FC 3B 4D 08 76 08 8B 55 FC 89 55 F8 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_10_0 {
	meta:
		name = "__MarkAllocaS"
		size = 33
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 11 8B 45 08 8B 4D 0C 89 08 8B 55 08 83 C2 08 89 55 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_19_12_0 {
	meta:
		name = "__freea_crt"
		size = 109
		refs = "002d __free_dbg 0044 ??_C@_1FE@KNPCCODH@?$AA?$CI?$AA?$CC?$AAC?$AAo?$AAr?$AAr?$AAu?$AAp?$AAt?$AAe?$AAd?$AA?5?$AAp?$AAo?$AAi?$AAn?$AAt?$AAe?$AAr?$AA?5?$AAp?$AAa?$AAs?$AAs?$AAe?$AAd?$AA?5?$AAt?$AAo?$AA?5?$AA_?$AAf@ 0049 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0055 ??_C@_1HG@NGPLHMCI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAd?$AAe?$AAv?$AAd?$AAi?$AAv?$AA?2?$AAv?$AAc?$AAr?$AAu?$AAn@ 005c __CrtDbgReportW"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 74 5D 8B 45 08 83 E8 08 89 45 08 8B 4D 08 8B 11 89 55 FC 81 7D FC DD DD 00 00 75 10 6A 02 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 EB 33 81 7D FC CC CC 00 00 74 2A 33 C9 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 30 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_13_0 {
	meta:
		name = "__wcslwr"
		size = 237
		refs = "0009 ___acrt_locale_changed 003b ??_C@_1CA@CHADEKIG@?$AAw?$AAs?$AAr?$AAc?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0040 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0049 ??_C@_1GC@LGHAKKND@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0050 __CrtDbgReportW 0064 __errno 0078 ??_C@_1BA@MILCGCII@?$AA_?$AAw?$AAc?$AAs?$AAl?$AAw?$AAr?$AA?$AA@ 0082 __invalid_parameter 00da __wcslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 0F 85 B9 00 00 00 83 7D 08 00 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8B 4D F8 89 4D F4 83 7D F4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F4 00 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 5C 8B 45 08 89 45 FC EB 09 8B 4D FC 83 C1 02 89 4D FC 8B 55 FC 0F B7 02 85 C0 74 27 8B 4D FC 0F B7 11 83 FA 41 7C 1A 8B 45 FC 0F B7 08 83 F9 5A 7F 0F 8B 55 FC 0F B7 02 83 C0 20 8B 4D FC 66 89 01 EB C6 EB 15 6A 00 6A FF 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 EB 03 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_19_14_0 {
	meta:
		name = "__wcslwr_l"
		size = 28
		refs = "0010 __wcslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_317_14_0 {
	meta:
		name = "__strlwr_l"
		size = 28
		refs = "0010 __strlwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_667_14_0 {
	meta:
		name = "__strupr_l"
		size = 28
		refs = "0010 __strupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_679_13_0 {
	meta:
		name = "__wcsupr_l"
		size = 28
		refs = "0010 __wcsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 50 6A FF 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_19_15_0 {
	meta:
		name = "__wcslwr_s"
		size = 25
		refs = "0010 __wcslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_240_3_0 {
	meta:
		name = "__aligned_malloc_base"
		size = 25
		refs = "0010 __aligned_offset_malloc_base"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_511_115_2 {
	meta:
		name = "__atodbl"
		size = 25
		refs = "0010 ??$common_atodbl_l@ND@@YAHQANQBDQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_511_118_3 {
	meta:
		name = "__atoflt"
		size = 25
		refs = "0010 ??$common_atodbl_l@MD@@YAHQAMQBDQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_375_56_4 {
	meta:
		name = "__atoldbl"
		size = 25
		refs = "0010 __atoldbl_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_606_13_3 {
	meta:
		name = "__getws_s"
		size = 25
		refs = "0010 ??$common_gets@_W@@YAPA_WQA_WI_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_367_4_0 {
	meta:
		name = "__ismbstrail"
		size = 25
		refs = "0010 __ismbstrail_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_436_7_0 {
	meta:
		name = "__mbstrnlen"
		size = 25
		refs = "0010 __mbstrnlen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_317_15_4 {
	meta:
		name = "__strlwr_s"
		size = 25
		refs = "0010 __strlwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_667_15_4 {
	meta:
		name = "__strupr_s"
		size = 25
		refs = "0010 __strupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_679_14_4 {
	meta:
		name = "__wcsupr_s"
		size = 25
		refs = "0010 __wcsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_606_15_2 {
	meta:
		name = "_gets_s"
		size = 25
		refs = "0010 ??$common_gets@D@@YAPADQADI_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_677_5_4 {
	meta:
		name = "_strcoll"
		size = 25
		refs = "0010 __strcoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_125_2 {
	meta:
		name = "_strtod"
		size = 25
		refs = "0010 ??$common_strtod_l@ND@@YANQBDQAPADQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_126_2 {
	meta:
		name = "_strtof"
		size = 25
		refs = "0010 ??$common_strtod_l@MD@@YAMQBDQAPADQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_127_2 {
	meta:
		name = "_strtold"
		size = 25
		refs = "0010 ??$common_strtod_l@ND@@YANQBDQAPADQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_128_2 {
	meta:
		name = "_wcstod"
		size = 25
		refs = "0010 ??$common_strtod_l@N_W@@YANQB_WQAPA_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_129_4 {
	meta:
		name = "_wcstof"
		size = 25
		refs = "0010 ??$common_strtod_l@M_W@@YAMQB_WQAPA_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_130_4 {
	meta:
		name = "_wcstold"
		size = 25
		refs = "0010 ??$common_strtod_l@N_W@@YANQB_WQAPA_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_19_16_0 {
	meta:
		name = "__wcslwr_s_l"
		size = 63
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0026 ?_wcslwr_s_l_stat@@YAHPA_WIPAU__crt_locale_pointers@@@Z 0034 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 10 50 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_317_16_0 {
	meta:
		name = "__strlwr_s_l"
		size = 63
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0026 ?_strlwr_s_l_stat@@YAHQADIQAU__crt_locale_pointers@@@Z 0034 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 10 50 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_667_16_0 {
	meta:
		name = "__strupr_s_l"
		size = 63
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0026 ?_strupr_s_l_stat@@YAHQADIQAU__crt_locale_pointers@@@Z 0034 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 10 50 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_679_15_0 {
	meta:
		name = "__wcsupr_s_l"
		size = 63
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0026 ?_wcsupr_s_l_stat@@YAHQA_WIQAU__crt_locale_pointers@@@Z 0034 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 10 50 8D 4D EC E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "__LHypot"
		size = 570
		refs = "0011 __ldunscale 004d __LInf_C 0165 __ldscale 01bd __real@3ff0000000000000 01c8 _sqrtl 01eb __real@4000000000000000 020e ?root2@?6??_LHypot@@9@9 0217 ?oneplusroot2low@?6??_LHypot@@9@9 0220 ?oneplusroot2high@?6??_LHypot@@9@9"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 44 8D 45 08 50 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 F4 8D 55 10 52 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 F0 8B 4D 18 C7 01 00 00 00 00 0F BF 55 F4 83 FA 01 74 09 0F BF 45 F0 83 F8 01 75 10 DD 05 ?? ?? ?? ?? E9 E0 01 00 00 E9 DB 01 00 00 0F BF 4D F4 83 F9 02 75 0D DD 45 08 E9 CA 01 00 00 E9 C5 01 00 00 0F BF 55 F0 83 FA 02 75 0D DD 45 10 E9 B4 01 00 00 E9 AF 01 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 08 DD 45 08 D9 E0 DD 5D 08 D9 EE DC 5D 10 DF E0 F6 C4 41 75 08 DD 45 10 D9 E0 DD 5D 10 DD 45 10 D9 EE DA E9 DF E0 F6 C4 44 7A 17 DD 45 08 D9 EE DA E9 DF E0 F6 C4 44 7A 07 D9 EE E9 64 01 00 00 EB 5D DD 45 08 D9 EE DA E9 DF E0 F6 C4 44 7B 25 0F BF 45 FC 0F BF 4D F8 3B C1 7C 19 0F BF 55 FC 0F BF 45 F8 3B D0 75 37 DD 45 10 DC 5D 08 DF E0 F6 C4 41 75 2A 66 8B 4D FC 66 89 4D EC DD 45 08 DD 5D C4 66 8B 55 F8 66 89 55 FC 66 8B 45 EC 66 89 45 F8 DD 45 10 DD 5D 08 DD 45 C4 DD 5D 10 0F BF 45 FC 99 83 E2 03 03 C2 C1 F8 02 D1 E0 8B 4D 18 89 01 8B 55 18 83 3A 00 75 09 8B 45 18 C7 00 02 00 00 00 0F BF 4D FC 8B 55 18 2B 0A 51 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF 4D F8 8B 55 18 2B 0A 51 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 DC 65 10 DD 5D E4 DD 45 E4 DD 45 08 DA E9 DF E0 F6 C4 44 7A 05 E9 94 00 00 00 DD 45 E4 DC 5D 10 DF E0 F6 C4 41 75 31 DD 45 08 DC 75 10 DD 5D DC DD 45 DC DC 4D DC DC 05 ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 45 DC DC 7D 10 DC 45 08 DD 5D E4 EB 56 DD 45 E4 DC 75 10 DD 5D D4 DD 45 D4 DC 05 ?? ?? ?? ?? DC 4D D4 DD 5D CC DD 45 CC DC 05 ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 05 ?? ?? ?? ?? DC 7D CC DC 05 ?? ?? ?? ?? DC 45 D4 DC 05 ?? ?? ?? ?? DD 5D BC DD 45 10 DC 75 BC DC 45 08 DD 5D E4 DD 45 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_520_0_0 {
	meta:
		name = "__Hypot"
		size = 570
		refs = "0011 __dunscale 004d __Inf_C 0165 __dscale 01bd __real@3ff0000000000000 01c8 _sqrt 01eb __real@4000000000000000 020e ?root2@?6??_Hypot@@9@9 0217 ?oneplusroot2low@?6??_Hypot@@9@9 0220 ?oneplusroot2high@?6??_Hypot@@9@9"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 44 8D 45 08 50 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 F4 8D 55 10 52 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 F0 8B 4D 18 C7 01 00 00 00 00 0F BF 55 F4 83 FA 01 74 09 0F BF 45 F0 83 F8 01 75 10 DD 05 ?? ?? ?? ?? E9 E0 01 00 00 E9 DB 01 00 00 0F BF 4D F4 83 F9 02 75 0D DD 45 08 E9 CA 01 00 00 E9 C5 01 00 00 0F BF 55 F0 83 FA 02 75 0D DD 45 10 E9 B4 01 00 00 E9 AF 01 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 08 DD 45 08 D9 E0 DD 5D 08 D9 EE DC 5D 10 DF E0 F6 C4 41 75 08 DD 45 10 D9 E0 DD 5D 10 DD 45 10 D9 EE DA E9 DF E0 F6 C4 44 7A 17 DD 45 08 D9 EE DA E9 DF E0 F6 C4 44 7A 07 D9 EE E9 64 01 00 00 EB 5D DD 45 08 D9 EE DA E9 DF E0 F6 C4 44 7B 25 0F BF 45 FC 0F BF 4D F8 3B C1 7C 19 0F BF 55 FC 0F BF 45 F8 3B D0 75 37 DD 45 10 DC 5D 08 DF E0 F6 C4 41 75 2A 66 8B 4D FC 66 89 4D EC DD 45 08 DD 5D C4 66 8B 55 F8 66 89 55 FC 66 8B 45 EC 66 89 45 F8 DD 45 10 DD 5D 08 DD 45 C4 DD 5D 10 0F BF 45 FC 99 83 E2 03 03 C2 C1 F8 02 D1 E0 8B 4D 18 89 01 8B 55 18 83 3A 00 75 09 8B 45 18 C7 00 02 00 00 00 0F BF 4D FC 8B 55 18 2B 0A 51 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF 4D F8 8B 55 18 2B 0A 51 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 DC 65 10 DD 5D E4 DD 45 E4 DD 45 08 DA E9 DF E0 F6 C4 44 7A 05 E9 94 00 00 00 DD 45 E4 DC 5D 10 DF E0 F6 C4 41 75 31 DD 45 08 DC 75 10 DD 5D DC DD 45 DC DC 4D DC DC 05 ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 45 DC DC 7D 10 DC 45 08 DD 5D E4 EB 56 DD 45 E4 DC 75 10 DD 5D D4 DD 45 D4 DC 05 ?? ?? ?? ?? DC 4D D4 DD 5D CC DD 45 CC DC 05 ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 05 ?? ?? ?? ?? DC 7D CC DC 05 ?? ?? ?? ?? DC 45 D4 DC 05 ?? ?? ?? ?? DD 5D BC DD 45 10 DC 75 BC DC 45 08 DD 5D E4 DD 45 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_1_0 {
	meta:
		name = "_csqrtl"
		size = 1127
		refs = "0028 _creall 004f _cimagl 005e __ldtest 0080 __LInf_C 008c __LCbuild 01db __LZero_C 0244 __LHypot 02ca _ldexpl 02e8 __real@4000000000000000 02f3 _sqrtl 030a __real@0000000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC D0 00 00 00 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D E4 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F8 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F4 0F BF 4D F4 83 F9 01 75 47 83 EC 08 DD 45 F8 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 55 B0 52 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 AF 03 00 00 E9 74 01 00 00 8D 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 0F BF D0 83 FA 01 74 05 E9 5B 01 00 00 0F BF 45 F4 83 F8 02 75 74 D9 EE DC 5D E4 DF E0 F6 C4 41 75 41 83 EC 08 DD 45 E4 DD 1C 24 83 EC 08 DD 45 F8 DD 1C 24 8D 4D A0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 3D 03 00 00 EB 22 8B 4D 08 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C 8B 45 08 E9 19 03 00 00 E9 DE 00 00 00 D9 EE DC 5D E4 DF E0 F6 C4 41 75 6A B9 02 00 00 00 6B D1 03 0F B7 44 15 F8 25 00 80 00 00 74 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D D8 EB 09 DD 05 ?? ?? ?? ?? DD 5D D8 83 EC 08 DD 45 D8 DD 1C 24 83 EC 08 D9 EE DD 1C 24 8D 4D 90 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 A0 02 00 00 EB 68 B9 02 00 00 00 6B D1 03 0F B7 44 15 F8 25 00 80 00 00 74 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D D0 EB 05 D9 EE DD 5D D0 83 EC 08 DD 45 D0 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 4D 80 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 36 02 00 00 8D 4D E0 51 83 EC 08 DD 45 F8 DD 1C 24 83 EC 08 DD 45 E4 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 14 DD 5D EC 83 7D E0 00 75 4A DD 45 F8 DC 4D EC 83 EC 08 DD 1C 24 83 EC 08 DD 45 EC DD 1C 24 8D 95 70 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 CA 01 00 00 E9 C5 01 00 00 D9 EE DC 5D E4 DF E0 F6 C4 41 75 0A DD 45 E4 D9 E0 DD 5D C8 EB 06 DD 45 E4 DD 5D C8 8B 4D E0 F7 D9 51 83 EC 08 DD 45 C8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D C0 8B 45 E0 99 2B C2 D1 F8 83 E8 01 50 DD 45 C0 DC 45 EC DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D EC DD 45 E4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 50 DD 05 ?? ?? ?? ?? DC 4D EC DC 7D F8 83 EC 08 DD 1C 24 83 EC 08 DD 45 EC DD 1C 24 8D 95 60 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 03 01 00 00 E9 FE 00 00 00 B9 02 00 00 00 6B D1 03 0F B7 44 15 F8 25 00 80 00 00 74 56 DD 45 EC D9 E0 83 EC 08 DD 1C 24 DD 45 F8 D9 E0 DD 05 ?? ?? ?? ?? DC 4D EC DE F9 83 EC 08 DD 1C 24 8D 8D 50 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 99 00 00 00 E9 94 00 00 00 DD 45 F8 D9 EE DA E9 DF E0 F6 C4 44 7A 40 83 EC 08 DD 45 EC DD 1C 24 83 EC 08 D9 EE DD 1C 24 8D 8D 40 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 EB 48 EB 46 83 EC 08 DD 45 EC DD 1C 24 DD 05 ?? ?? ?? ?? DC 4D EC DC 7D F8 83 EC 08 DD 1C 24 8D 8D 30 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_520_1_0 {
	meta:
		name = "_csqrt"
		size = 1127
		refs = "0028 _creal 004f _cimag 005e __dtest 0080 __Inf_C 008c __Cbuild 01db __Zero_C 0244 __Hypot 02ca _ldexp 02e8 __real@4000000000000000 02f3 _sqrt 030a __real@0000000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC D0 00 00 00 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D E4 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F8 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F4 0F BF 4D F4 83 F9 01 75 47 83 EC 08 DD 45 F8 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 55 B0 52 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 AF 03 00 00 E9 74 01 00 00 8D 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 0F BF D0 83 FA 01 74 05 E9 5B 01 00 00 0F BF 45 F4 83 F8 02 75 74 D9 EE DC 5D E4 DF E0 F6 C4 41 75 41 83 EC 08 DD 45 E4 DD 1C 24 83 EC 08 DD 45 F8 DD 1C 24 8D 4D A0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 3D 03 00 00 EB 22 8B 4D 08 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C 8B 45 08 E9 19 03 00 00 E9 DE 00 00 00 D9 EE DC 5D E4 DF E0 F6 C4 41 75 6A B9 02 00 00 00 6B D1 03 0F B7 44 15 F8 25 00 80 00 00 74 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D D8 EB 09 DD 05 ?? ?? ?? ?? DD 5D D8 83 EC 08 DD 45 D8 DD 1C 24 83 EC 08 D9 EE DD 1C 24 8D 4D 90 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 A0 02 00 00 EB 68 B9 02 00 00 00 6B D1 03 0F B7 44 15 F8 25 00 80 00 00 74 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D D0 EB 05 D9 EE DD 5D D0 83 EC 08 DD 45 D0 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 4D 80 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 36 02 00 00 8D 4D E0 51 83 EC 08 DD 45 F8 DD 1C 24 83 EC 08 DD 45 E4 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 14 DD 5D EC 83 7D E0 00 75 4A DD 45 F8 DC 4D EC 83 EC 08 DD 1C 24 83 EC 08 DD 45 EC DD 1C 24 8D 95 70 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 CA 01 00 00 E9 C5 01 00 00 D9 EE DC 5D E4 DF E0 F6 C4 41 75 0A DD 45 E4 D9 E0 DD 5D C8 EB 06 DD 45 E4 DD 5D C8 8B 4D E0 F7 D9 51 83 EC 08 DD 45 C8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D C0 8B 45 E0 99 2B C2 D1 F8 83 E8 01 50 DD 45 C0 DC 45 EC DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D EC DD 45 E4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 50 DD 05 ?? ?? ?? ?? DC 4D EC DC 7D F8 83 EC 08 DD 1C 24 83 EC 08 DD 45 EC DD 1C 24 8D 95 60 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 03 01 00 00 E9 FE 00 00 00 B9 02 00 00 00 6B D1 03 0F B7 44 15 F8 25 00 80 00 00 74 56 DD 45 EC D9 E0 83 EC 08 DD 1C 24 DD 45 F8 D9 E0 DD 05 ?? ?? ?? ?? DC 4D EC DE F9 83 EC 08 DD 1C 24 8D 8D 50 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 99 00 00 00 E9 94 00 00 00 DD 45 F8 D9 EE DA E9 DF E0 F6 C4 44 7A 40 83 EC 08 DD 45 EC DD 1C 24 83 EC 08 D9 EE DD 1C 24 8D 8D 40 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 EB 48 EB 46 83 EC 08 DD 45 EC DD 1C 24 DD 05 ?? ?? ?? ?? DC 4D EC DC 7D F8 83 EC 08 DD 1C 24 8D 8D 30 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_20_2_0 {
	meta:
		name = "_ldexpl"
		size = 28
		refs = "0013 _ldexp"
		altNames = "__scalb"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_21_4_0 {
	meta:
		name = "__mbsnbcnt"
		size = 23
		refs = "000e __mbsnbcnt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_276_4_3 {
	meta:
		name = "__ismbslead"
		size = 23
		refs = "000e __ismbslead_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_698_4_2 {
	meta:
		name = "__mbbtype"
		size = 23
		refs = "000e __mbbtype_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_115_4_3 {
	meta:
		name = "__mbsbtype"
		size = 23
		refs = "000e __mbsbtype_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_726_4_4 {
	meta:
		name = "__mbschr"
		size = 23
		refs = "000e __mbschr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_266_4_3 {
	meta:
		name = "__mbscmp"
		size = 23
		refs = "000e __mbscmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_336_4_0 {
	meta:
		name = "__mbscoll"
		size = 23
		refs = "000e __mbscoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_312_4_4 {
	meta:
		name = "__mbscspn"
		size = 23
		refs = "000e __mbscspn_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_641_4_0 {
	meta:
		name = "__mbsdec"
		size = 23
		refs = "000e __mbsdec_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_701_4_3 {
	meta:
		name = "__mbsicmp"
		size = 23
		refs = "000e __mbsicmp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_716_4_2 {
	meta:
		name = "__mbsicoll"
		size = 23
		refs = "000e __mbsicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_497_6_4 {
	meta:
		name = "__mbslwr_s"
		size = 23
		refs = "000e __mbslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_67_4_4 {
	meta:
		name = "__mbsnccnt"
		size = 23
		refs = "000e __mbsnccnt_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_329_0_2 {
	meta:
		name = "__mbsninc"
		size = 23
		refs = "000e __mbsninc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_130_4_0 {
	meta:
		name = "__mbsnlen"
		size = 23
		refs = "000e __mbsnlen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_544_4_0 {
	meta:
		name = "__mbspbrk"
		size = 23
		refs = "000e __mbspbrk_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_47_4_2 {
	meta:
		name = "__mbsrchr"
		size = 23
		refs = "000e __mbsrchr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_526_4_3 {
	meta:
		name = "__mbsset"
		size = 23
		refs = "000e __mbsset_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_543_4_3 {
	meta:
		name = "__mbsspn"
		size = 23
		refs = "000e __mbsspn_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_157_4_2 {
	meta:
		name = "__mbsspnp"
		size = 23
		refs = "000e __mbsspnp_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_103_4_2 {
	meta:
		name = "__mbsstr"
		size = 23
		refs = "000e __mbsstr_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "__mbstok"
		size = 23
		refs = "000e __mbstok_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_94_6_4 {
	meta:
		name = "__mbsupr_s"
		size = 23
		refs = "000e __mbsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_21_5_0 {
	meta:
		name = "__mbsnbcnt_l"
		size = 172
		refs = "0011 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0025 ??_C@_1DO@OEOOHFAH@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAc?$AAc?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 002d ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0035 ??_C@_1HC@JPHBBDJC@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 003d __CrtDbgReportW 004b __errno 0054 ??_C@_1BI@NAADMDIB@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAc?$AAn?$AAt?$AA_?$AAl?$AA?$AA@ 0060 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 4D F0 56 57 FF 75 10 E8 ?? ?? ?? ?? 8B 55 08 8B 4D 0C 85 D2 75 4B 85 C9 74 47 53 BF ?? ?? ?? ?? 33 F6 57 68 ?? ?? ?? ?? 56 6A 33 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 6A 33 53 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 5B EB 2A 8B F2 85 C9 74 22 8B 7D F8 8A 06 49 84 C0 74 18 0F B6 C0 F6 44 38 19 04 74 06 46 80 3E 00 74 07 46 85 C9 75 E4 EB 01 4E 2B F2 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 5F 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "__derfc"
		size = 100
		refs = "0018 __s 0026 __dpoly 0030 __c 0056 __dexp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 DD 45 08 D9 E0 DC 4D 08 DD 5D F8 6A 00 6A 06 68 ?? ?? ?? ?? 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 6A 06 68 ?? ?? ?? ?? 83 EC 08 DD 45 08 DD 1C 24 DD 5D F0 E8 ?? ?? ?? ?? 83 C4 10 DC 7D F0 83 EC 08 DD 1C 24 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "__lderfc"
		size = 100
		refs = "0018 __s 0026 __ldpoly 0030 __c 0056 __ldexp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 DD 45 08 D9 E0 DC 4D 08 DD 5D F8 6A 00 6A 06 68 ?? ?? ?? ?? 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 6A 06 68 ?? ?? ?? ?? 83 EC 08 DD 45 08 DD 1C 24 DD 5D F0 E8 ?? ?? ?? ?? 83 C4 10 DC 7D F0 83 EC 08 DD 1C 24 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_22_1_0 {
	meta:
		name = "_erf"
		size = 483
		refs = "000d __dtest 004d __real@bff0000000000000 0087 __derf_small 00ac _s 011f _c 0193 __derf_one 01ab __derfc"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 74 0E 83 7D FC 01 74 10 83 7D FC 02 74 02 EB 35 DD 45 08 E9 A9 01 00 00 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 74 0B DD 05 ?? ?? ?? ?? DD 5D EC EB 05 D9 E8 DD 5D EC DD 45 EC E9 7C 01 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 0A DD 45 08 D9 E0 DD 5D E4 EB 06 DD 45 08 DD 5D E4 DD 45 E4 DD 5D F4 DD 05 ?? ?? ?? ?? DC 5D F4 DF E0 F6 C4 41 0F 85 F8 00 00 00 DD 45 08 DC 4D 08 DD 5D F4 BA 08 00 00 00 6B C2 00 DD 80 ?? ?? ?? ?? DC 4D F4 B9 08 00 00 00 C1 E1 00 DC 81 ?? ?? ?? ?? DC 4D F4 BA 08 00 00 00 D1 E2 DC 82 ?? ?? ?? ?? DC 4D F4 B8 08 00 00 00 6B C8 03 DC 81 ?? ?? ?? ?? DC 4D F4 BA 08 00 00 00 C1 E2 02 DC 82 ?? ?? ?? ?? DC 4D F4 B8 08 00 00 00 6B C8 05 DC 81 ?? ?? ?? ?? DC 4D F4 BA 08 00 00 00 6B C2 06 DC 80 ?? ?? ?? ?? B9 08 00 00 00 6B D1 00 DD 82 ?? ?? ?? ?? DC 4D F4 B8 08 00 00 00 C1 E0 00 DC 80 ?? ?? ?? ?? DC 4D F4 B9 08 00 00 00 D1 E1 DC 81 ?? ?? ?? ?? DC 4D F4 BA 08 00 00 00 6B C2 03 DC 80 ?? ?? ?? ?? DC 4D F4 B9 08 00 00 00 C1 E1 02 DC 81 ?? ?? ?? ?? DC 4D F4 BA 08 00 00 00 6B C2 05 DC 80 ?? ?? ?? ?? DC 4D F4 B9 08 00 00 00 6B D1 06 DC 82 ?? ?? ?? ?? DE F9 DC 4D 08 EB 50 EB 2F DD 05 ?? ?? ?? ?? DC 5D F4 DF E0 F6 C4 41 75 1A 83 EC 08 DD 45 F4 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 E8 DE E1 DD 5D F4 EB 05 D9 E8 DD 5D F4 D9 EE DC 5D 08 DF E0 F6 C4 41 75 0A DD 45 F4 D9 E0 DD 5D DC EB 06 DD 45 F4 DD 5D DC DD 45 DC 8B E5 5D C3 }
	condition:
		$1
}

rule file_146_1_0 {
	meta:
		name = "_erfl"
		size = 483
		refs = "000d __ldtest 004d __real@bff0000000000000 0087 __lderf_small 00ac _s 011f _c 0193 __lderf_one 01ab __lderfc"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 74 0E 83 7D FC 01 74 10 83 7D FC 02 74 02 EB 35 DD 45 08 E9 A9 01 00 00 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 74 0B DD 05 ?? ?? ?? ?? DD 5D EC EB 05 D9 E8 DD 5D EC DD 45 EC E9 7C 01 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 0A DD 45 08 D9 E0 DD 5D E4 EB 06 DD 45 08 DD 5D E4 DD 45 E4 DD 5D F4 DD 05 ?? ?? ?? ?? DC 5D F4 DF E0 F6 C4 41 0F 85 F8 00 00 00 DD 45 08 DC 4D 08 DD 5D F4 BA 08 00 00 00 6B C2 00 DD 80 ?? ?? ?? ?? DC 4D F4 B9 08 00 00 00 C1 E1 00 DC 81 ?? ?? ?? ?? DC 4D F4 BA 08 00 00 00 D1 E2 DC 82 ?? ?? ?? ?? DC 4D F4 B8 08 00 00 00 6B C8 03 DC 81 ?? ?? ?? ?? DC 4D F4 BA 08 00 00 00 C1 E2 02 DC 82 ?? ?? ?? ?? DC 4D F4 B8 08 00 00 00 6B C8 05 DC 81 ?? ?? ?? ?? DC 4D F4 BA 08 00 00 00 6B C2 06 DC 80 ?? ?? ?? ?? B9 08 00 00 00 6B D1 00 DD 82 ?? ?? ?? ?? DC 4D F4 B8 08 00 00 00 C1 E0 00 DC 80 ?? ?? ?? ?? DC 4D F4 B9 08 00 00 00 D1 E1 DC 81 ?? ?? ?? ?? DC 4D F4 BA 08 00 00 00 6B C2 03 DC 80 ?? ?? ?? ?? DC 4D F4 B9 08 00 00 00 C1 E1 02 DC 81 ?? ?? ?? ?? DC 4D F4 BA 08 00 00 00 6B C2 05 DC 80 ?? ?? ?? ?? DC 4D F4 B9 08 00 00 00 6B D1 06 DC 82 ?? ?? ?? ?? DE F9 DC 4D 08 EB 50 EB 2F DD 05 ?? ?? ?? ?? DC 5D F4 DF E0 F6 C4 41 75 1A 83 EC 08 DD 45 F4 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 E8 DE E1 DD 5D F4 EB 05 D9 E8 DD 5D F4 D9 EE DC 5D 08 DF E0 F6 C4 41 75 0A DD 45 F4 D9 E0 DD 5D DC EB 06 DD 45 F4 DD 5D DC DD 45 DC 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "___acrt_initialize_command_line"
		size = 31
		refs = "0007 __imp__GetCommandLineA@0 000c __acmdln 0012 __imp__GetCommandLineW@0 0017 __wcmdln"
	strings:
		$1 = { 8B FF 55 8B EC FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? B0 01 5D C3 }
	condition:
		$1
}

rule file_23_9_0 {
	meta:
		name = "__get_pgmptr"
		size = 271
		refs = "002b ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0030 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0039 ??_C@_1GK@EMNILMBI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0040 __CrtDbgReportW 0054 __errno 0068 ??_C@_1BI@COAAPHJK@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?$AA@ 0072 __invalid_parameter 0085 __pgmptr 00a9 ??_C@_1CG@CKJHPBDG@?$AA_?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 88 00 00 00 83 3D ?? ?? ?? ?? 00 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 55 F4 89 55 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0D 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_23_10_0 {
	meta:
		name = "__get_wpgmptr"
		size = 271
		refs = "002b ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0030 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0039 ??_C@_1GK@EMNILMBI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0040 __CrtDbgReportW 0054 __errno 0068 ??_C@_1BK@PNLDCCDP@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAw?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?$AA@ 0072 __invalid_parameter 0085 __wpgmptr 00a9 ??_C@_1CI@ENCADPBF@?$AA_?$AAw?$AAp?$AAg?$AAm?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 2A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 88 00 00 00 83 3D ?? ?? ?? ?? 00 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 55 F4 89 55 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 2B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 0D 8B 4D 08 8B 15 ?? ?? ?? ?? 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_24_8_0 {
	meta:
		name = "?close_os_handle_nolock@@YAKH@Z"
		size = 192
		refs = "000e __get_osfhandle 0031 ___pioinfo 00a9 __imp__CloseHandle@4 00b7 __imp__GetLastError@0"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 56 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 75 07 33 C0 E9 9A 00 00 00 83 7D 08 01 75 1A B9 04 00 00 00 6B D1 00 8B 82 ?? ?? ?? ?? 0F B6 88 88 00 00 00 83 E1 01 75 26 83 7D 08 02 75 17 BA 04 00 00 00 6B C2 00 8B 88 ?? ?? ?? ?? 0F B6 51 58 83 E2 01 75 09 C7 45 F8 00 00 00 00 EB 07 C7 45 F8 01 00 00 00 8A 45 F8 88 45 FF 0F B6 4D FF 85 C9 74 1E 6A 01 E8 ?? ?? ?? ?? 83 C4 04 8B F0 6A 02 E8 ?? ?? ?? ?? 83 C4 04 3B F0 75 04 33 C0 EB 21 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 06 FF 15 ?? ?? ?? ?? 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_24_9_0 {
	meta:
		name = "__close"
		size = 371
		refs = "000f ___doserrno 001a __errno 0037 __nhandle 005a ??_C@_1FO@LPCLHKGE@?$AA?$CI?$AAf?$AAh?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAh?$AA?5?$AA?$DM?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi@ 005f ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0068 ??_C@_1FO@IPDGALOE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAl@ 006f __CrtDbgReportW 00a2 ??_C@_1O@EDEJGJBM@?$AA_?$AAc?$AAl?$AAo?$AAs?$AAe?$AA?$AA@ 00ac __invalid_parameter 00cd ___pioinfo 00f8 ??_C@_1CM@OKGMMMDH@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 015e ??0<lambda_4e7105787b7b0e0227fbf2b2d883fa65>@@QAE@ABH@Z 0168 ??$__acrt_lowio_lock_fh_and_call@V<lambda_4e7105787b7b0e0227fbf2b2d883fa65>@@@@YAHH$$QAV<lambda_4e7105787b7b0e0227fbf2b2d883fa65>@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 43 01 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 4D FC 89 4D F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 30 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B4 00 00 00 8B 45 08 C1 F8 06 8B 4D 08 83 E1 3F 6B D1 30 8B 04 85 ?? ?? ?? ?? 0F B6 4C 10 28 83 E1 01 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 55 F4 89 55 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 36 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 19 8D 4D 08 51 8D 4D EC E8 ?? ?? ?? ?? 50 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_24_10_0 {
	meta:
		name = "__close_nolock"
		size = 89
		refs = "000b ?close_os_handle_nolock@@YAKH@Z 001a __free_osfhnd 0033 ___pioinfo 0047 ___acrt_errno_map_os_error"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 C1 FA 06 8B 45 08 83 E0 3F 6B C8 30 8B 14 95 ?? ?? ?? ?? C6 44 0A 28 00 83 7D FC 00 74 11 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "_log1pf"
		size = 207
		refs = "000d __fdtest 0054 __real@bff0000000000000 0062 __fperrraise 006b __FNan_C 0091 __FInf_C 00ad _logf 00b9 __real@3ff0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 74 0E 83 7D FC 01 74 10 83 7D FC 02 74 02 EB 21 D9 45 08 E9 95 00 00 00 BA 02 00 00 00 C1 E2 00 0F B7 44 15 08 25 00 80 00 00 75 05 D9 45 08 EB 7C D9 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 14 6A 01 E8 ?? ?? ?? ?? 83 C4 04 D9 05 ?? ?? ?? ?? EB 5A EB 58 D9 45 08 DD 05 ?? ?? ?? ?? DA E9 DF E0 F6 C4 44 7A 16 6A 04 E8 ?? ?? ?? ?? 83 C4 04 D9 05 ?? ?? ?? ?? D9 E0 EB 32 EB 30 D9 45 08 D9 E8 DE C1 D9 5D F8 51 D9 45 F8 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D9 45 F8 DC 25 ?? ?? ?? ?? D8 65 08 D8 75 F8 DE E9 D9 5D F4 D9 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "??$?RD@__crt_internal_free_policy@@QBEXQBD@Z"
		size = 29
		refs = "0010 __free_dbg"
		altNames = "??$?RE@__crt_internal_free_policy@@QBEXQBE@Z ??$?RG@__crt_internal_free_policy@@QBEXQBG@Z ??$?RJ@__crt_internal_free_policy@@QBEXQBJ@Z ??$?RP6AXXZ@__crt_internal_free_policy@@QBEXQBQ6AXXZ@Z ??$?RPAD@__crt_internal_free_policy@@QBEXQBQAD@Z ??$?RPAU__crt_stdio_stream_data@@@__crt_internal_free_policy@@QBEXQBQAU__crt_stdio_stream_data@@@Z ??$?RPA_W@__crt_internal_free_policy@@QBEXQBQA_W@Z ??$?RU?$__crt_report_hook_node@D@@@__crt_internal_free_policy@@QBEXQBU?$__crt_report_hook_node@D@@@Z ??$?RU?$__crt_report_hook_node@_W@@@__crt_internal_free_policy@@QBEXQBU?$__crt_report_hook_node@_W@@@Z ??$?RU__acrt_ptd@@@__crt_internal_free_policy@@QBEXQBU__acrt_ptd@@@Z ??$?RU__acrt_thread_parameter@@@__crt_internal_free_policy@@QBEXQBU__acrt_thread_parameter@@@Z ??$?RU__crt_lc_time_data@@@__crt_internal_free_policy@@QBEXQBU__crt_lc_time_data@@@Z ??$?RU__crt_locale_data@@@__crt_internal_free_policy@@QBEXQBU__crt_locale_data@@@Z ??$?RU__crt_locale_pointers@@@__crt_internal_free_policy@@QBEXQBU__crt_locale_pointers@@@Z ??$?RU__crt_lowio_handle_data@@@__crt_internal_free_policy@@QBEXQBU__crt_lowio_handle_data@@@Z ??$?RU__crt_multibyte_data@@@__crt_internal_free_policy@@QBEXQBU__crt_multibyte_data@@@Z ??$?RU__crt_stdio_stream_data@@@__crt_internal_free_policy@@QBEXQBU__crt_stdio_stream_data@@@Z ??$?RUlconv@@@__crt_internal_free_policy@@QBEXQBUlconv@@@Z ??$?RUtm@@@__crt_internal_free_policy@@QBEXQBUtm@@@Z ??$?R_W@__crt_internal_free_policy@@QBEXQB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 6A 02 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_26_8_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_235_3 {
	meta:
		name = "??$scratch_count@D@formatting_buffer@__crt_stdio_output@@QBEIXZ"
		size = 21
		refs = "000d ??$count@D@formatting_buffer@__crt_stdio_output@@QBEIXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_424_37_3 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QAE@XZ"
		size = 21
		refs = "000d ?close@?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_571_51_2 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_handle_traits@@@@QAE@XZ"
		size = 21
		refs = "000d ?close@?$__crt_unique_handle_t@U__crt_handle_traits@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_413_11_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QAE@XZ"
		size = 21
		refs = "000d ?close@?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_465_42_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_465_43_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_465_45_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_613_6_2 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_613_7_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_613_8_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_542_19_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_210_17_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_208_13_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@PAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@PAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_424_41_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_643_28_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_643_29_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_624_23_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_5_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_6_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_441_8_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_178_32_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_178_33_2 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_311_2_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_178_34_2 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_5_3 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_176_5_2 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_550_8_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_465_46_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_465_47_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000d ?release@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_319_3 {
	meta:
		name = "??1?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_320_2 {
	meta:
		name = "??1?$format_validation_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$standard_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_321_4 {
	meta:
		name = "??1?$format_validation_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$standard_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_322_0 {
	meta:
		name = "??1?$format_validation_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$standard_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_323_4 {
	meta:
		name = "??1?$output_adapter_data@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$common_data@D@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_324_4 {
	meta:
		name = "??1?$output_adapter_data@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$common_data@D@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_325_4 {
	meta:
		name = "??1?$output_adapter_data@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$common_data@_W@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_326_3 {
	meta:
		name = "??1?$output_adapter_data@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$common_data@_W@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_327_3 {
	meta:
		name = "??1?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_328_3 {
	meta:
		name = "??1?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$positional_parameter_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_329_0 {
	meta:
		name = "??1?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_330_2 {
	meta:
		name = "??1?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$format_validation_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_331_2 {
	meta:
		name = "??1?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$positional_parameter_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_332_2 {
	meta:
		name = "??1?$output_processor@DV?$string_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$string_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$standard_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_333_0 {
	meta:
		name = "??1?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$format_validation_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_334_3 {
	meta:
		name = "??1?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$positional_parameter_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_335_3 {
	meta:
		name = "??1?$output_processor@_WV?$stream_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$standard_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_336_3 {
	meta:
		name = "??1?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$format_validation_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_337_3 {
	meta:
		name = "??1?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$positional_parameter_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_338_4 {
	meta:
		name = "??1?$output_processor@_WV?$string_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$standard_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_339_4 {
	meta:
		name = "??1?$positional_parameter_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_340_3 {
	meta:
		name = "??1?$positional_parameter_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$format_validation_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_341_0 {
	meta:
		name = "??1?$positional_parameter_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$format_validation_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_342_2 {
	meta:
		name = "??1?$positional_parameter_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$format_validation_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_224_174_3 {
	meta:
		name = "??1?$scanset_buffer@_W@__crt_stdio_input@@QAE@XZ"
		size = 21
		refs = "000d ??1?$scanset_storage@$01@__crt_stdio_input@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_224_175_3 {
	meta:
		name = "??1?$scanset_storage@$01@__crt_stdio_input@@QAE@XZ"
		size = 21
		refs = "000d ??1?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_343_3 {
	meta:
		name = "??1?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$output_adapter_data@DV?$stream_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_344_4 {
	meta:
		name = "??1?$standard_base@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$output_adapter_data@DV?$string_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_345_3 {
	meta:
		name = "??1?$standard_base@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$output_adapter_data@_WV?$stream_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_346_0 {
	meta:
		name = "??1?$standard_base@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
		size = 21
		refs = "000d ??1?$output_adapter_data@_WV?$string_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_571_54_2 {
	meta:
		name = "??B?$__crt_unique_handle_t@U__crt_handle_traits@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_handle_t@U__crt_handle_traits@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_584_352_2 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_465_48_0 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_224_179_0 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_424_48_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_424_49_3 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_643_30_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_643_31_0 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_624_25_0 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_7_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_441_9_3 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_178_35_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_178_36_0 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_311_3_4 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_178_37_0 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_368_15_2 {
	meta:
		name = "??B?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QBE_NXZ"
		size = 21
		refs = "000d ?is_valid@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_26_13_0 {
	meta:
		name = "?detach@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEPADXZ"
		size = 35
		altNames = "?detach@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QAEPBDXZ ?detach@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QAEPB_WXZ ?detach@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAEPADXZ ?detach@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAEPAEXZ ?detach@?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QAEPAGXZ ?detach@?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QAEPAJXZ ?detach@?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QAEPAP6AXXZXZ ?detach@?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAEPAPADXZ ?detach@?$__crt_unique_heap_ptr@PAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAEPAPAU__crt_stdio_stream_data@@XZ ?detach@?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAEPAPA_WXZ ?detach@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QAEPAU?$__crt_report_hook_node@D@@XZ ?detach@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QAEPAU?$__crt_report_hook_node@_W@@XZ ?detach@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QAEPAU__acrt_ptd@@XZ ?detach@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QAEPAU__acrt_thread_parameter@@XZ ?detach@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QAEPAU__acrt_thread_parameter@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QAEPAU__crt_lc_time_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QAEPAU__crt_locale_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QAEPAU__crt_locale_pointers@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QAEPAU__crt_lowio_handle_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QAEPAU__crt_multibyte_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAEPAU__crt_stdio_stream_data@@XZ ?detach@?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QAEPAUlconv@@XZ ?detach@?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QAEPAUtm@@XZ ?detach@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAEPA_WXZ ?detach@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAEPA_WXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D FC 8B 45 FC 8B 08 89 4D F8 8B 55 FC C7 02 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_26_15_0 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RD@__crt_internal_free_policy@@QBEXQBD@Z"
		altNames = "?release@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_465_67_0 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?R_W@__crt_internal_free_policy@@QBEXQB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_465_69_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RD@__crt_public_free_policy@@QBEXQBD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_224_319_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RE@__crt_internal_free_policy@@QBEXQBE@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_613_13_2 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RG@__crt_internal_free_policy@@QBEXQBG@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_528_4_2 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RJ@__crt_internal_free_policy@@QBEXQBJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_542_33_0 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RP6AXXZ@__crt_internal_free_policy@@QBEXQBQ6AXXZ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_210_40_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RPAD@__crt_internal_free_policy@@QBEXQBQAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_208_24_2 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@PAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RPAU__crt_stdio_stream_data@@@__crt_internal_free_policy@@QBEXQBQAU__crt_stdio_stream_data@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_424_82_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RPA_W@__crt_internal_free_policy@@QBEXQBQA_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_643_50_2 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@D@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RU?$__crt_report_hook_node@D@@@__crt_internal_free_policy@@QBEXQBU?$__crt_report_hook_node@D@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_643_51_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U?$__crt_report_hook_node@_W@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RU?$__crt_report_hook_node@_W@@@__crt_internal_free_policy@@QBEXQBU?$__crt_report_hook_node@_W@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_624_50_2 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RU__acrt_ptd@@@__crt_internal_free_policy@@QBEXQBU__acrt_ptd@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_17_2 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RU__acrt_thread_parameter@@@__crt_internal_free_policy@@QBEXQBU__acrt_thread_parameter@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_186_18_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QAEXXZ"
		size = 38
		refs = "0015 ??Rthread_parameter_free_policy@?A0x4e93fcdd@@QAEXQAU__acrt_thread_parameter@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_441_16_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RU__crt_lc_time_data@@@__crt_internal_free_policy@@QBEXQBU__crt_lc_time_data@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_178_64_2 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RU__crt_locale_data@@@__crt_internal_free_policy@@QBEXQBU__crt_locale_data@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_178_65_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RU__crt_locale_pointers@@@__crt_internal_free_policy@@QBEXQBU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_311_7_2 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RU__crt_lowio_handle_data@@@__crt_internal_free_policy@@QBEXQBU__crt_lowio_handle_data@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_178_66_0 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RU__crt_multibyte_data@@@__crt_internal_free_policy@@QBEXQBU__crt_multibyte_data@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_17_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RU__crt_stdio_stream_data@@@__crt_internal_free_policy@@QBEXQBU__crt_stdio_stream_data@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_176_9_0 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RUlconv@@@__crt_internal_free_policy@@QBEXQBUlconv@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_550_12_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?RUtm@@@__crt_internal_free_policy@@QBEXQBUtm@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_631_21_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?R_W@__crt_internal_free_policy@@QBEXQB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_368_25_3 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAEXXZ"
		size = 38
		refs = "0015 ??$?R_W@__crt_public_free_policy@@QBEXQB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 8B 08 51 8D 4D FF E8 ?? ?? ?? ?? 8B 55 F8 C7 02 00 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_26_16_0 {
	meta:
		name = "?set_buffer@@YAHV__crt_stdio_stream@@QADIH@Z"
		size = 77
		refs = "000d ?set_flags@__crt_stdio_stream@@QBE_NJ@Z 0015 ??C__crt_stdio_stream@@QBEPAU__crt_stdio_stream_data@@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 50 8D 4D 08 E8 ?? ?? ?? ?? 8D 4D 08 E8 ?? ?? ?? ?? 8B 4D 10 89 48 18 8D 4D 08 E8 ?? ?? ?? ?? 8B 55 0C 89 10 8D 4D 08 E8 ?? ?? ?? ?? 8B 4D 0C 89 48 04 8D 4D 08 E8 ?? ?? ?? ?? C7 40 08 00 00 00 00 33 C0 5D C3 }
	condition:
		$1
}

rule file_26_17_0 {
	meta:
		name = "?set_flags@__crt_stdio_stream@@QBE_NJ@Z"
		size = 72
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 89 4D F8 8B 4D 08 8B 55 F8 8B 02 83 C0 0C 89 45 F4 8B 55 F4 8B 02 8B F0 0B F1 F0 0F B1 32 75 F6 23 45 08 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_26_18_0 {
	meta:
		name = "?unset_flags@__crt_stdio_stream@@QBE_NJ@Z"
		size = 76
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 89 4D F8 8B 45 08 F7 D0 8B C8 8B 55 F8 8B 02 83 C0 0C 89 45 F4 8B 55 F4 8B 02 8B F0 23 F1 F0 0F B1 32 75 F6 23 45 08 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_26_20_0 {
	meta:
		name = "_setvbuf"
		size = 468
		refs = "0010 ??0__crt_stdio_stream@@QAE@QAU_iobuf@@@Z 0018 ?valid@__crt_stdio_stream@@QBE_NXZ 0040 ??_C@_1BO@MHPFFFJJ@?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?4?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?$CI?$AA?$CJ?$AA?$AA@ 0045 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004e ??_C@_1GC@NAMEPLDD@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0055 __CrtDbgReportW 0069 __errno 007d ??_C@_1BA@OGODIODK@?$AAs?$AAe?$AAt?$AAv?$AAb?$AAu?$AAf?$AA?$AA@ 0087 __invalid_parameter 00c5 ??_C@_1GG@CBGCKJPC@?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAI?$AAO?$AAN?$AAB?$AAF?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAt?$AAy?$AAp?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAI?$AAO?$AAF?$AAB?$AAF@ 0153 ??_C@_1HK@PBPJKDDM@?$AA2?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAs?$AAi?$AAz?$AAe?$AA_?$AAi?$AAn?$AA_?$AAb?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAb?$AAu?$AAf@ 01ba ??0<lambda_3aae883670d60947a98255ae2090162b>@@QAE@ABIABV__crt_stdio_stream@@ABHABQAD@Z 01c3 ?public_stream@__crt_stdio_stream@@QBEPAU_iobuf@@XZ 01c9 ??$__acrt_lock_stream_and_call@V<lambda_3aae883670d60947a98255ae2090162b>@@@@YAHQAU_iobuf@@$$QAV<lambda_3aae883670d60947a98255ae2090162b>@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 8B 45 08 50 8D 4D FC E8 ?? ?? ?? ?? 8D 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8B 55 F8 89 55 F4 83 7D F4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 2F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F4 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 3A 01 00 00 83 7D 10 04 74 15 83 7D 10 00 74 0F 83 7D 10 40 74 09 C7 45 F0 00 00 00 00 EB 07 C7 45 F0 01 00 00 00 8B 4D F0 89 4D EC 83 7D EC 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 33 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D EC 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 33 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B5 00 00 00 83 7D 10 00 74 06 83 7D 10 40 75 7F 83 7D 14 02 72 12 81 7D 14 FF FF FF 7F 77 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 45 E8 89 45 E4 83 7D E4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2A 8D 55 0C 52 8D 45 10 50 8D 4D FC 51 8D 55 14 52 8D 4D D4 E8 ?? ?? ?? ?? 50 8D 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_27_1_0 {
	meta:
		name = "__strdup"
		size = 25
		refs = "0010 __strdup_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_418_1_0 {
	meta:
		name = "__wcsdup"
		size = 25
		refs = "0010 __wcsdup_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_232_0_0 {
	meta:
		name = "_malloc"
		size = 25
		refs = "0010 __malloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "__strdup_dbg"
		size = 128
		refs = "0017 _strlen 0035 __malloc_dbg 004e ??_C@_1GC@HKEHEHPJ@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0053 ??_C@_1BI@CBNECNIC@?$AA_?$AAs?$AAt?$AAr?$AAd?$AAu?$AAp?$AA_?$AAd?$AAb?$AAg?$AA?$AA@ 0058 ??_C@_1DO@MOGEFOMO@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAm?$AAe?$AAm?$AAo?$AAr?$AAy?$AA?0?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA?0?$AA?5?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?$CJ?$AA?$AA@ 0069 _strcpy_s 0072 __invoke_watson_if_error"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 83 7D 08 00 75 04 33 C0 EB 6A 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 89 45 F8 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 75 04 33 C0 EB 33 6A 00 6A 3B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 08 52 8B 45 F8 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "_atanhf"
		size = 263
		refs = "000d __fdtest 0035 __real@0000000000000000 005d __real@3ff0000000000000 006b __fperrraise 0074 __FNan_C 00a2 __FInf_C 00c2 __real@4000000000000000 00da _log1pf 00e3 __real@3fe0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D F8 83 7D F8 00 74 08 83 7D F8 02 74 02 EB 08 D9 45 08 E9 D3 00 00 00 D9 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 11 C7 45 FC 01 00 00 00 D9 45 08 D9 E0 D9 5D 08 EB 07 C7 45 FC 00 00 00 00 D9 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 1A 6A 01 E8 ?? ?? ?? ?? 83 C4 04 D9 05 ?? ?? ?? ?? E9 86 00 00 00 E9 81 00 00 00 D9 45 08 D9 E8 DA E9 DF E0 F6 C4 44 7A 2D 6A 04 E8 ?? ?? ?? ?? 83 C4 04 83 7D FC 00 74 0D D9 05 ?? ?? ?? ?? D9 E0 D9 5D F4 EB 09 D9 05 ?? ?? ?? ?? D9 5D F4 D9 45 F4 EB 48 EB 46 D9 45 08 DC 0D ?? ?? ?? ?? D9 45 08 D9 E8 DE E1 DE F9 D9 5D E8 D9 45 E8 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 DC 0D ?? ?? ?? ?? D9 5D F0 83 7D FC 00 74 0A D9 45 F0 D9 E0 D9 5D EC EB 06 D9 45 F0 D9 5D EC D9 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "__getwch"
		size = 75
		refs = "0003 __sehtable$__getwch 0008 __SEH_prolog4 000f ___acrt_lock 001e __getwch_nolock 0039 __SEH_epilog4 0045 ___acrt_unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 09 E8 ?? ?? ?? ?? 59 33 C0 66 89 45 E4 21 45 FC E8 ?? ?? ?? ?? 66 8B F0 66 89 75 E4 C7 45 FC FE FF FF FF E8 0D 00 00 00 66 8B C6 E8 ?? ?? ?? ?? C3 66 8B 75 E4 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_29_2_0 {
	meta:
		name = "__getwche"
		size = 75
		refs = "0003 __sehtable$__getwche 0008 __SEH_prolog4 000f ___acrt_lock 001e __getwche_nolock 0039 __SEH_epilog4 0045 ___acrt_unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 09 E8 ?? ?? ?? ?? 59 33 C0 66 89 45 E4 21 45 FC E8 ?? ?? ?? ?? 66 8B F0 66 89 75 E4 C7 45 FC FE FF FF FF E8 0D 00 00 00 66 8B C6 E8 ?? ?? ?? ?? C3 66 8B 75 E4 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_29_1_0 {
	meta:
		name = "__getwch_nolock"
		size = 228
		refs = "0003 __sehtable$__getwch_nolock 0008 __SEH_prolog4_GS 0013 ?wchbuf@@3GA 002a ___dcrt_lowio_console_input_handle 0034 ___dcrt_lowio_initialize_console_input 0051 __imp__GetConsoleMode@8 005a __imp__SetConsoleMode@8 0076 __imp__ReadConsoleInputW@16 00a2 __getextendedkeycode 00cd __SEH_epilog4_GS"
	strings:
		$1 = { 6A 30 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE FF FF 00 00 66 A1 ?? ?? ?? ?? 66 3B C6 74 0C 66 89 35 ?? ?? ?? ?? E9 A4 00 00 00 8B 3D ?? ?? ?? ?? 83 FF FE 75 0B E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 83 FF FF 0F 84 82 00 00 00 89 7D C4 8D 45 C0 50 57 FF 15 ?? ?? ?? ?? 6A 00 57 FF 15 ?? ?? ?? ?? 33 C0 66 89 45 CC 21 45 FC 33 DB 43 8D 45 C8 50 53 8D 45 D0 50 57 FF 15 ?? ?? ?? ?? 85 C0 74 3B 83 7D C8 00 74 35 66 39 5D D0 75 E0 83 7D D4 00 74 DA 66 83 7D DE 00 74 06 66 8B 75 DE EB 1C 8D 45 D4 50 E8 ?? ?? ?? ?? 59 85 C0 74 BF 0F B6 48 01 66 89 0D ?? ?? ?? ?? 0F B6 30 66 89 75 CC C7 45 FC FE FF FF FF E8 10 00 00 00 66 8B C6 E8 ?? ?? ?? ?? C3 8B 7D C4 66 8B 75 CC FF 75 C0 57 FF 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_29_3_0 {
	meta:
		name = "__getwche_nolock"
		size = 69
		refs = "0002 ?wchbuf@@3GA 001f __getwch_nolock 0032 __putwch_nolock"
	strings:
		$1 = { 66 A1 ?? ?? ?? ?? 57 BF FF FF 00 00 66 3B C7 74 0C 66 89 3D ?? ?? ?? ?? 0F B7 C0 5F C3 56 E8 ?? ?? ?? ?? 0F B7 F0 66 3B F7 75 05 66 8B C7 EB 12 56 E8 ?? ?? ?? ?? 66 3B C7 66 8B C7 59 74 03 66 8B C6 5E 5F C3 }
	condition:
		$1
}

rule file_29_4_0 {
	meta:
		name = "__ungetwch"
		size = 79
		refs = "0003 __sehtable$__ungetwch 0008 __SEH_prolog4 000f ___acrt_lock 0021 __ungetwch_nolock 003d __SEH_epilog4 0049 ___acrt_unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 09 E8 ?? ?? ?? ?? 59 33 C0 66 89 45 E4 21 45 FC FF 75 08 E8 ?? ?? ?? ?? 59 66 8B F0 66 89 75 E4 C7 45 FC FE FF FF FF E8 0D 00 00 00 66 8B C6 E8 ?? ?? ?? ?? C3 66 8B 75 E4 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_29_5_0 {
	meta:
		name = "__ungetwch_nolock"
		size = 43
		refs = "0015 ?wchbuf@@3GA"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 B9 FF FF 00 00 66 3B C1 74 14 66 39 0D ?? ?? ?? ?? 75 0B 0F B6 C0 66 A3 ?? ?? ?? ?? 5D C3 66 8B C1 5D C3 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "??$?RD@__crt_internal_free_policy@@QBEXQBD@Z"
		size = 21
		refs = "000b __free_dbg"
		altNames = "??$?RE@__crt_internal_free_policy@@QBEXQBE@Z ??$?RPAD@__crt_internal_free_policy@@QBEXQBQAD@Z ??$?RPA_W@__crt_internal_free_policy@@QBEXQBQA_W@Z ??$?RUprocess_handle_pair@?A0xe43b7539@@@__crt_internal_free_policy@@QBEXQBUprocess_handle_pair@?A0xe43b7539@@@Z ??$?R_W@__crt_internal_free_policy@@QBEXQB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 02 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C2 04 00 }
	condition:
		$1
}

rule file_30_2_0 {
	meta:
		name = "??$common_chdir@D@@YAHQBD@Z"
		size = 329
		refs = "000c ___security_cookie 0027 ??_C@_1CA@DFHJGMAL@?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 002f ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0037 ??_C@_1GE@HFGGHBCA@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 003f __CrtDbgReportW 004d ___doserrno 0054 __errno 005d ??_C@_1BK@KFGCOIBC@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAc?$AAh?$AAd?$AAi?$AAr?$AA?$AA@ 0069 __invalid_parameter 007b __imp__SetCurrentDirectoryA@4 0085 __imp__GetLastError@0 008b ___acrt_errno_map_os_error 00b9 ??_C@_0DC@MIGIBIJP@minkernel?2crts?2ucrt?2src?2desktopc@ 00c3 __calloc_dbg 00de ??4?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z 00eb __free_dbg 0101 __imp__GetCurrentDirectoryA@8 0130 @__security_check_cookie@4 0140 ??$set_cwd_environment_variable@D@@YAHQBD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 14 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 08 33 C0 85 C9 53 0F 95 C0 56 57 85 C0 75 52 BF ?? ?? ?? ?? 33 F6 57 68 ?? ?? ?? ?? 56 6A 3D BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 56 6A 3D 53 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 AF 00 00 00 51 FF 15 ?? ?? ?? ?? 85 C0 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C8 FF E9 8F 00 00 00 8D 85 F4 FE FF FF 33 F6 BB 05 01 00 00 89 B5 EC FE FF FF 50 53 EB 51 3B FB 0F 82 82 00 00 00 6A 6C 68 ?? ?? ?? ?? 6A 02 6A 01 57 E8 ?? ?? ?? ?? 83 C4 14 89 85 F0 FE FF FF 8D 85 F0 FE FF FF 8D 8D EC FE FF FF 50 E8 ?? ?? ?? ?? 6A 02 FF B5 F0 FE FF FF E8 ?? ?? ?? ?? 8B B5 EC FE FF FF 59 59 85 F6 74 1D 56 8B DF 57 FF 15 ?? ?? ?? ?? 8B F8 85 FF 75 A3 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 CF FF 6A 02 56 E8 ?? ?? ?? ?? 59 8B C7 59 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 8D 85 F4 FE FF FF 50 E8 ?? ?? ?? ?? 59 8B F8 EB D2 }
	condition:
		$1
}

rule file_30_3_0 {
	meta:
		name = "??$common_chdir@_W@@YAHQB_W@Z"
		size = 329
		refs = "000c ___security_cookie 0027 ??_C@_1CA@DFHJGMAL@?$AAp?$AAa?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 002f ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0037 ??_C@_1GE@HFGGHBCA@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 003f __CrtDbgReportW 004d ___doserrno 0054 __errno 005d ??_C@_1BK@KFGCOIBC@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAc?$AAh?$AAd?$AAi?$AAr?$AA?$AA@ 0069 __invalid_parameter 007b __imp__SetCurrentDirectoryW@4 0085 __imp__GetLastError@0 008b ___acrt_errno_map_os_error 00b9 ??_C@_0DC@MIGIBIJP@minkernel?2crts?2ucrt?2src?2desktopc@ 00c3 __calloc_dbg 00de ??4?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z 00eb __free_dbg 0101 __imp__GetCurrentDirectoryW@8 0130 @__security_check_cookie@4 0140 ??$set_cwd_environment_variable@_W@@YAHQB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 18 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 08 33 C0 85 C9 53 0F 95 C0 56 57 85 C0 75 52 BF ?? ?? ?? ?? 33 F6 57 68 ?? ?? ?? ?? 56 6A 3D BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 56 6A 3D 53 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 AF 00 00 00 51 FF 15 ?? ?? ?? ?? 85 C0 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C8 FF E9 8F 00 00 00 8D 85 F0 FD FF FF 33 F6 BB 05 01 00 00 89 B5 E8 FD FF FF 50 53 EB 51 3B FB 0F 82 82 00 00 00 6A 6C 68 ?? ?? ?? ?? 6A 02 6A 02 57 E8 ?? ?? ?? ?? 83 C4 14 89 85 EC FD FF FF 8D 85 EC FD FF FF 8D 8D E8 FD FF FF 50 E8 ?? ?? ?? ?? 6A 02 FF B5 EC FD FF FF E8 ?? ?? ?? ?? 8B B5 E8 FD FF FF 59 59 85 F6 74 1D 56 8B DF 57 FF 15 ?? ?? ?? ?? 8B F8 85 FF 75 A3 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 CF FF 6A 02 56 E8 ?? ?? ?? ?? 59 8B C7 59 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 8D 85 F0 FD FF FF 50 E8 ?? ?? ?? ?? 59 8B F8 EB D2 }
	condition:
		$1
}

rule file_30_4_0 {
	meta:
		name = "??$get_current_directory@AAKAAPAD@?$__crt_char_traits@D@@SAKAAKAAPAD@Z"
		size = 23
		refs = "0011 __imp__GetCurrentDirectoryA@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_30_5_0 {
	meta:
		name = "??$get_current_directory@AAKAAPA_W@?$__crt_char_traits@_W@@SAKAAKAAPA_W@Z"
		size = 23
		refs = "0011 __imp__GetCurrentDirectoryW@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_664_14_0 {
	meta:
		name = "??$set_environment_variable@ABQADQAD@?$__crt_char_traits@D@@SAHABQAD$$QBQAD@Z"
		size = 23
		refs = "0011 __imp__SetEnvironmentVariableA@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_664_15_0 {
	meta:
		name = "??$set_environment_variable@ABQA_WQA_W@?$__crt_char_traits@_W@@SAHABQA_W$$QBQA_W@Z"
		size = 23
		refs = "0011 __imp__SetEnvironmentVariableW@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_30_6_0 {
	meta:
		name = "??$set_current_directory@ABQBD@?$__crt_char_traits@D@@SAHABQBD@Z"
		size = 18
		refs = "000c __imp__SetCurrentDirectoryA@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_30_7_0 {
	meta:
		name = "??$set_current_directory@ABQB_W@?$__crt_char_traits@_W@@SAHABQB_W@Z"
		size = 18
		refs = "000c __imp__SetCurrentDirectoryW@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 30 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_30_8_0 {
	meta:
		name = "??$set_cwd_environment_variable@D@@YAHQBD@Z"
		size = 88
		refs = "0022 _toupper 003b __imp__SetEnvironmentVariableA@8 0045 __imp__GetLastError@0 004b ___acrt_errno_map_os_error"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 8B 75 08 8A 06 3C 5C 74 04 3C 2F 75 09 3A 46 01 75 04 33 C0 EB 36 0F BE C0 50 E8 ?? ?? ?? ?? 59 88 45 FD 8D 45 FC 56 50 C6 45 FC 3D 66 C7 45 FE 3A 00 FF 15 ?? ?? ?? ?? 85 C0 75 D6 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 C8 FF 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_9_0 {
	meta:
		name = "??$set_cwd_environment_variable@_W@@YAHQB_W@Z"
		size = 128
		refs = "0009 ___security_cookie 0032 _toupper 0059 __imp__SetEnvironmentVariableW@8 0063 __imp__GetLastError@0 0069 ___acrt_errno_map_os_error 0078 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 75 08 0F B7 06 83 F8 5C 74 05 83 F8 2F 75 0A 66 3B 46 02 75 04 33 C0 EB 44 0F BE 06 50 E8 ?? ?? ?? ?? 59 6A 3D 59 0F B7 C0 6A 3A 66 89 45 F6 58 66 89 45 F8 33 C0 66 89 45 FA 8D 45 F4 56 50 66 89 4D F4 FF 15 ?? ?? ?? ?? 85 C0 75 C8 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 C8 FF 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_30_10_0 {
	meta:
		name = "??$set_environment_variable@AAY03$$CBDABQBD@?$__crt_char_traits@D@@SAHAAY03$$CBDABQBD@Z"
		size = 21
		refs = "000f __imp__SetEnvironmentVariableA@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_30_11_0 {
	meta:
		name = "??$set_environment_variable@AAY03$$CB_WABQB_W@?$__crt_char_traits@_W@@SAHAAY03$$CB_WABQB_W@Z"
		size = 21
		refs = "000f __imp__SetEnvironmentVariableW@8"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_30_12_0 {
	meta:
		name = "??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@QAD@Z"
		size = 16
		altNames = "??0?$__crt_scoped_stack_ptr@U_INPUT_RECORD@@@@QAE@U?$__crt_scoped_stack_ptr_tag@U_INPUT_RECORD@@@@@Z ??0?$__crt_scoped_stack_ptr_tag@U_INPUT_RECORD@@@@QAE@QAU_INPUT_RECORD@@@Z ??0?$__crt_unique_handle_t@U__crt_handle_traits@@@@QAE@QAX@Z ??0?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QAE@QA_W@Z ??0?$__crt_unique_handle_t@Uprocess_handle_pair_traits@?A0xe43b7539@@@@QAE@QAUprocess_handle_pair@?A0xe43b7539@@@Z ??0?$__crt_unique_handle_t@Ustream_traits@?A0xe43b7539@@@@QAE@QAU_iobuf@@@Z ??0?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QAE@QBD@Z ??0?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QAE@QB_W@Z ??0?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAE@QAD@Z ??0?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAE@QAE@Z ??0?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAE@QAPAD@Z ??0?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAE@QAPA_W@Z ??0?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QAE@QAUprocess_handle_pair@?A0xe43b7539@@@Z ??0?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAE@QA_W@Z ??0?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAE@QA_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 89 01 8B C1 5D C2 04 00 }
	condition:
		$1
}

rule file_30_14_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@XZ"
		size = 21
		refs = "000a __free_dbg"
		altNames = "??1?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QAE@XZ ??1?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAE@XZ ??1?$scanset_buffer@_W@__crt_stdio_input@@QAE@XZ ??1?$scanset_storage@$01@__crt_stdio_input@@QAE@XZ ?release@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 6A 02 FF 36 E8 ?? ?? ?? ?? 83 26 00 59 59 5E C3 }
	condition:
		$1
}

rule file_30_16_0 {
	meta:
		name = "??4?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z"
		size = 39
		refs = "000d __free_dbg"
		altNames = "??4?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z ??4?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z ??4?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z ??4?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 6A 02 FF 36 E8 ?? ?? ?? ?? 8B 55 08 83 26 00 59 59 8B 02 89 06 8B C6 83 22 00 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__cputws"
		size = 282
		refs = "0003 __sehtable$__cputws 0008 __SEH_prolog4 001b ??_C@_1CI@JGFDABK@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$CJ?$AA?$AA@ 0020 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0028 ??_C@_1GI@EKEHDKHC@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 002f __CrtDbgReportW 0041 ___doserrno 0048 __errno 005b ??_C@_1BA@NGNGNDEP@?$AA_?$AAc?$AAp?$AAu?$AAt?$AAw?$AAs?$AA?$AA@ 0065 __invalid_parameter 0075 ___dcrt_lowio_console_output_handle 007f ___dcrt_lowio_initialize_console_output 00a7 ___acrt_lock 00dc __imp__WriteConsoleW@20 00f9 __SEH_epilog4 0114 ___acrt_unlock"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 39 5D 08 0F 95 C3 33 F6 85 DB 75 5A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 6A 19 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 85 DB 75 34 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 6A 19 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 84 00 00 00 A1 ?? ?? ?? ?? 83 F8 FE 75 0A E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 FF 74 DF 8B 5D 08 8B FB 8D 4F 02 66 8B 07 83 C7 02 66 3B C6 75 F5 2B F9 D1 FF 6A 09 E8 ?? ?? ?? ?? 59 89 75 E0 89 75 FC 85 FF 7E 34 81 FF FF 7F 00 00 76 0A B8 FF 7F 00 00 89 45 E4 EB 05 8B C7 89 7D E4 56 8D 4D DC 51 50 53 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 1A 83 CE FF 89 75 E0 C7 45 FC FE FF FF FF E8 1B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 45 E4 8D 1C 43 89 5D 08 2B F8 89 7D E4 EB A4 8B 75 E0 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "??$__crt_interlocked_read@J@@YAJPDJ@Z"
		size = 19
		refs = "000a ?__crt_interlocked_read_32@@YAHPDH@Z"
		altNames = "??$__crt_interlocked_read@H@@YAHPDH@Z ??$__crt_interlocked_read_pointer@UHINSTANCE__@@@@YAPAUHINSTANCE__@@PDSAU0@@Z ??$__crt_interlocked_read_pointer@X@@YAPAXPDSAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_375_4_2 {
	meta:
		name = "??$multiply_ld12_by@$0BA@@@YAXQAU_LDBL12@@@Z"
		size = 19
		refs = "000a ??$shl_ld12@$03@@YAXQAU_LDBL12@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_484_29_0 {
	meta:
		name = "??$tcslen@AAY0BAF@D@?$__crt_char_traits@D@@SAIAAY0BAF@D@Z"
		size = 19
		refs = "000a _strlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_484_30_4 {
	meta:
		name = "??$tcslen@AAY0BAF@_W@?$__crt_char_traits@_W@@SAIAAY0BAF@_W@Z"
		size = 19
		refs = "000a _wcslen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_337_34_3 {
	meta:
		name = "___wcserror"
		size = 19
		refs = "000a ??$common_strerror@_W@@YAPA_WQB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_240_0_3 {
	meta:
		name = "__aligned_free"
		size = 19
		refs = "000a __aligned_free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_210_45_4 {
	meta:
		name = "__configure_narrow_argv"
		size = 19
		refs = "000a ??$common_configure_argv@D@@YAHW4_crt_argv_mode@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_210_46_2 {
	meta:
		name = "__configure_wide_argv"
		size = 19
		refs = "000a ??$common_configure_argv@_W@@YAHW4_crt_argv_mode@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_659_14_3 {
	meta:
		name = "__ctime32"
		size = 19
		refs = "000a ??$common_ctime@JD@@YAPADQBJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_659_16_3 {
	meta:
		name = "__ctime64"
		size = 19
		refs = "000a ??$common_ctime@_JD@@YAPADQB_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_186_22_0 {
	meta:
		name = "__endthreadex"
		size = 19
		refs = "000a ?common_end_thread@@YAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_299_6_3 {
	meta:
		name = "__filelength"
		size = 19
		refs = "000a ??$common_filelength@J@@YAJH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_299_7_3 {
	meta:
		name = "__filelengthi64"
		size = 19
		refs = "000a ??$common_filelength@_J@@YA_JH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_68_2_3 {
	meta:
		name = "__ftime32"
		size = 19
		refs = "000a __ftime32_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_68_3_3 {
	meta:
		name = "__ftime32_s"
		size = 19
		refs = "000a ??$common_ftime_s@JU__timeb32@@@@YAHQAU__timeb32@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_68_4_0 {
	meta:
		name = "__ftime64"
		size = 19
		refs = "000a __ftime64_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_68_5_0 {
	meta:
		name = "__ftime64_s"
		size = 19
		refs = "000a ??$common_ftime_s@_JU__timeb64@@@@YAHQAU__timeb64@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_421_10_2 {
	meta:
		name = "__getc_nolock"
		size = 19
		refs = "000a __fgetc_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_381_9_0 {
	meta:
		name = "__getwc_nolock"
		size = 19
		refs = "000a __fgetwc_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_550_14_4 {
	meta:
		name = "__gmtime32"
		size = 19
		refs = "000a ??$common_gmtime@J@@YAPAUtm@@QBJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_550_16_2 {
	meta:
		name = "__gmtime64"
		size = 19
		refs = "000a ??$common_gmtime@_J@@YAPAUtm@@QB_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_287_6_3 {
	meta:
		name = "__ldtest"
		size = 19
		refs = "000a __dtest"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_323_11_0 {
	meta:
		name = "__localtime32"
		size = 19
		refs = "000a ??$common_localtime@J@@YAPAUtm@@QBJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_323_13_0 {
	meta:
		name = "__localtime64"
		size = 19
		refs = "000a ??$common_localtime@_J@@YAPAUtm@@QB_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_469_12_2 {
	meta:
		name = "__mktemp"
		size = 19
		refs = "000a ??$common_mktemp@D@@YAPADQAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_252_4_3 {
	meta:
		name = "__strdate"
		size = 19
		refs = "000a ??$common_strdate@D@@YAPADQAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_337_38_3 {
	meta:
		name = "__strerror"
		size = 19
		refs = "000a ??$common_strerror@D@@YAPADQBD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_569_4_4 {
	meta:
		name = "__strtime"
		size = 19
		refs = "000a ??$common_strtime@D@@YAPADQAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_490_4_4 {
	meta:
		name = "__time32"
		size = 19
		refs = "000a ??$common_time@J@@YAJQAJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_490_5_3 {
	meta:
		name = "__time64"
		size = 19
		refs = "000a ??$common_time@_J@@YA_JQA_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_581_6_4 {
	meta:
		name = "__unlink"
		size = 19
		refs = "000a _remove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_631_22_4 {
	meta:
		name = "__wasctime"
		size = 19
		refs = "000a ??$common_asctime@_W@@YAPA_WQBUtm@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_661_23_4 {
	meta:
		name = "__wcserror"
		size = 19
		refs = "000a ??$common_strerror@_W@@YAPA_WH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_659_18_0 {
	meta:
		name = "__wctime32"
		size = 19
		refs = "000a ??$common_ctime@J_W@@YAPA_WQBJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_659_20_0 {
	meta:
		name = "__wctime64"
		size = 19
		refs = "000a ??$common_ctime@_J_W@@YAPA_WQB_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_469_14_0 {
	meta:
		name = "__wmktemp"
		size = 19
		refs = "000a ??$common_mktemp@_W@@YAPA_WQA_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_252_6_0 {
	meta:
		name = "__wstrdate"
		size = 19
		refs = "000a ??$common_strdate@_W@@YAPA_WQA_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_569_6_0 {
	meta:
		name = "__wstrtime"
		size = 19
		refs = "000a ??$common_strtime@_W@@YAPA_WQA_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_495_1_2 {
	meta:
		name = "__wunlink"
		size = 19
		refs = "000a __wremove"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_631_24_2 {
	meta:
		name = "_asctime"
		size = 19
		refs = "000a ??$common_asctime@D@@YAPADQBUtm@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_188_4_0 {
	meta:
		name = "_clearerr"
		size = 19
		refs = "000a _clearerr_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_421_12_3 {
	meta:
		name = "_getc"
		size = 19
		refs = "000a _fgetc"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_381_11_2 {
	meta:
		name = "_getwc"
		size = 19
		refs = "000a _fgetwc"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_460_12_0 {
	meta:
		name = "_putchar"
		size = 19
		refs = "000a __fputchar"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_661_25_3 {
	meta:
		name = "_strerror"
		size = 19
		refs = "000a ??$common_strerror@D@@YAPADH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_32_2_0 {
	meta:
		name = "?__crt_interlocked_read_32@@YAHPDH@Z"
		size = 21
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 8B 08 89 4D FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_32_3_0 {
	meta:
		name = "?get_flags@__crt_stdio_stream@@QBEJXZ"
		size = 30
		refs = "0013 ??$__crt_interlocked_read@J@@YAJPDJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B 08 83 C1 0C 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_32_4_0 {
	meta:
		name = "?is_in_use@__crt_stdio_stream@@QBE_NXZ"
		size = 49
		refs = "000f ?get_flags@__crt_stdio_stream@@QBEJXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 25 00 20 00 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_32_5_0 {
	meta:
		name = "__fcloseall"
		size = 304
		refs = "0008 __sehtable$__fcloseall 000d __except_handler4 001f ___security_cookie 003c ___acrt_lock 0061 __nstream 006f ___piob 008c ??0__crt_stdio_stream@@QAE@QAU__crt_stdio_stream_data@@@Z 0093 ?is_in_use@__crt_stdio_stream@@QBE_NXZ 00ab _fclose 00d2 __imp__DeleteCriticalSection@4 00e6 __free_dbg 0113 ___acrt_unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 6A 08 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 C7 45 E4 03 00 00 00 EB 09 8B 45 E4 83 C0 01 89 45 E4 8B 4D E4 3B 0D ?? ?? ?? ?? 0F 84 97 00 00 00 8B 55 E4 A1 ?? ?? ?? ?? 83 3C 90 00 75 02 EB D8 8B 4D E4 8B 15 ?? ?? ?? ?? 8B 04 8A 50 8D 4D DC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 22 8B 55 E4 A1 ?? ?? ?? ?? 8B 0C 90 51 E8 ?? ?? ?? ?? 83 C4 04 83 F8 FF 74 09 8B 55 E0 83 C2 01 89 55 E0 8B 45 E4 8B 0D ?? ?? ?? ?? 8B 14 81 83 C2 20 52 FF 15 ?? ?? ?? ?? 6A 02 8B 45 E4 8B 0D ?? ?? ?? ?? 8B 14 81 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 E4 8B 0D ?? ?? ?? ?? C7 04 81 00 00 00 00 E9 51 FF FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 08 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_0_0 {
	meta:
		name = "__Sinh"
		size = 543
		refs = "000d __dtest 0086 __fperrraise 008f __Nan_C 0106 __Rteps_C 0124 _ln3by2 0145 _c 0174 _s 01b1 __Xbig_C 01ce __dexp 01d7 __real@3fd0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 0F BF 55 FC 85 D2 7D 0C 0F BF 45 F8 85 C0 0F 8C A3 00 00 00 0F BF 4D FC 83 F9 02 75 0D DD 45 08 E9 CE 01 00 00 E9 88 00 00 00 0F BF 55 F8 83 FA 02 75 0A DD 45 10 E9 B8 01 00 00 EB 75 0F BF 45 FC 83 F8 01 75 2C 0F BF 4D F8 85 C9 74 0D DD 45 08 DC 4D 10 E9 9A 01 00 00 EB 15 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? E9 83 01 00 00 EB 40 0F BF 55 FC 85 D2 75 2D 0F BF 45 F8 83 F8 01 74 0D DD 45 08 DC 4D 10 E9 65 01 00 00 EB 15 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? E9 4E 01 00 00 EB 0B DD 45 08 DC 4D 10 E9 41 01 00 00 E9 3C 01 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 13 DD 45 08 D9 E0 DD 5D 08 B9 01 00 00 00 66 89 4D F4 EB 06 33 D2 66 89 55 F4 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 0E DD 45 08 DC 4D 10 DD 5D 08 E9 DE 00 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 7D DD 45 08 DC 4D 08 DD 5D EC B8 08 00 00 00 6B C8 00 DD 81 ?? ?? ?? ?? DC 4D EC BA 08 00 00 00 C1 E2 00 DC 82 ?? ?? ?? ?? DC 4D EC D9 E8 DE C1 DD 5D DC DD 45 08 DC 4D EC B8 08 00 00 00 6B C8 00 DD 81 ?? ?? ?? ?? DC 4D EC BA 08 00 00 00 C1 E2 00 DC 82 ?? ?? ?? ?? DC 4D EC B8 08 00 00 00 D1 E0 DC 80 ?? ?? ?? ?? DE C9 DC 45 08 DD 5D 08 DD 45 08 DC 75 DC DC 4D 10 DD 5D 08 EB 51 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 2A 6A FF 83 EC 08 D9 E8 DD 1C 24 8D 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 DD 05 ?? ?? ?? ?? DC 75 08 DC 6D 08 DC 4D 10 DD 5D 08 EB 17 6A FF 83 EC 08 DD 45 10 DD 1C 24 8D 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 0F BF 45 F4 85 C0 74 0A DD 45 08 D9 E0 DD 5D E4 EB 06 DD 45 08 DD 5D E4 DD 45 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_123_0_0 {
	meta:
		name = "__LSinh"
		size = 543
		refs = "000d __ldtest 0086 __fperrraise 008f __LNan_C 0106 __LRteps_C 0124 _ln3by2 0145 _c 0174 _s 01b1 __LXbig_C 01ce __ldexp 01d7 __real@3fd0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 24 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 0F BF 55 FC 85 D2 7D 0C 0F BF 45 F8 85 C0 0F 8C A3 00 00 00 0F BF 4D FC 83 F9 02 75 0D DD 45 08 E9 CE 01 00 00 E9 88 00 00 00 0F BF 55 F8 83 FA 02 75 0A DD 45 10 E9 B8 01 00 00 EB 75 0F BF 45 FC 83 F8 01 75 2C 0F BF 4D F8 85 C9 74 0D DD 45 08 DC 4D 10 E9 9A 01 00 00 EB 15 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? E9 83 01 00 00 EB 40 0F BF 55 FC 85 D2 75 2D 0F BF 45 F8 83 F8 01 74 0D DD 45 08 DC 4D 10 E9 65 01 00 00 EB 15 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? E9 4E 01 00 00 EB 0B DD 45 08 DC 4D 10 E9 41 01 00 00 E9 3C 01 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 13 DD 45 08 D9 E0 DD 5D 08 B9 01 00 00 00 66 89 4D F4 EB 06 33 D2 66 89 55 F4 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 0E DD 45 08 DC 4D 10 DD 5D 08 E9 DE 00 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 7D DD 45 08 DC 4D 08 DD 5D EC B8 08 00 00 00 6B C8 00 DD 81 ?? ?? ?? ?? DC 4D EC BA 08 00 00 00 C1 E2 00 DC 82 ?? ?? ?? ?? DC 4D EC D9 E8 DE C1 DD 5D DC DD 45 08 DC 4D EC B8 08 00 00 00 6B C8 00 DD 81 ?? ?? ?? ?? DC 4D EC BA 08 00 00 00 C1 E2 00 DC 82 ?? ?? ?? ?? DC 4D EC B8 08 00 00 00 D1 E0 DC 80 ?? ?? ?? ?? DE C9 DC 45 08 DD 5D 08 DD 45 08 DC 75 DC DC 4D 10 DD 5D 08 EB 51 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 2A 6A FF 83 EC 08 D9 E8 DD 1C 24 8D 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 DD 05 ?? ?? ?? ?? DC 75 08 DC 6D 08 DC 4D 10 DD 5D 08 EB 17 6A FF 83 EC 08 DD 45 10 DD 1C 24 8D 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 0F BF 45 F4 85 C0 74 0A DD 45 08 D9 E0 DD 5D E4 EB 06 DD 45 08 DD 5D E4 DD 45 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "_csinh"
		size = 950
		refs = "0028 _creal 004f _cimag 005e __dtest 009c __Nan_C 00a8 __Cbuild 012c __fperrraise 02e1 _sin 02ea __Inf_C 02fe _cos 0358 __Cosh 037d __Sinh"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC A8 00 00 00 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F0 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 0F BF 55 FC 83 FA 02 0F 85 96 00 00 00 0F BF 45 F8 85 C0 75 44 83 EC 08 DD 45 F0 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 4D D8 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 E2 02 00 00 EB 45 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 4D C8 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 9B 02 00 00 E9 96 02 00 00 0F BF 4D F8 83 F9 01 0F 85 A9 00 00 00 6A 01 E8 ?? ?? ?? ?? 83 C4 04 0F BF 55 FC 85 D2 74 09 0F BF 45 FC 83 F8 01 75 44 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 E8 DD 1C 24 8D 4D B8 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 2C 02 00 00 EB 45 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 4D A8 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 E5 01 00 00 E9 E0 01 00 00 0F BF 4D F8 83 F9 02 0F 85 9F 00 00 00 0F BF 55 FC 85 D2 74 09 0F BF 45 FC 83 F8 01 75 44 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 E8 DD 1C 24 8D 4D 98 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 80 01 00 00 EB 45 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 4D 88 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 39 01 00 00 E9 34 01 00 00 0F BF 4D FC 83 F9 01 0F 85 B2 00 00 00 0F BF 55 F8 85 D2 75 44 83 EC 08 DD 45 F0 DD 1C 24 83 EC 08 DD 45 E8 DD 1C 24 8D 85 78 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 DD 00 00 00 EB 64 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 4D E8 83 EC 08 DD 1C 24 8D 8D 68 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 EB 77 EB 75 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 8D 8D 58 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_123_2_0 {
	meta:
		name = "_csinhl"
		size = 950
		refs = "0028 _creall 004f _cimagl 005e __ldtest 009c __LNan_C 00a8 __LCbuild 012c __fperrraise 02e1 _sinl 02ea __LInf_C 02fe _cosl 0358 __LCosh 037d __LSinh"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC A8 00 00 00 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F0 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 0F BF 55 FC 83 FA 02 0F 85 96 00 00 00 0F BF 45 F8 85 C0 75 44 83 EC 08 DD 45 F0 DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 4D D8 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 E2 02 00 00 EB 45 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 4D C8 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 9B 02 00 00 E9 96 02 00 00 0F BF 4D F8 83 F9 01 0F 85 A9 00 00 00 6A 01 E8 ?? ?? ?? ?? 83 C4 04 0F BF 55 FC 85 D2 74 09 0F BF 45 FC 83 F8 01 75 44 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 E8 DD 1C 24 8D 4D B8 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 2C 02 00 00 EB 45 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 4D A8 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 E5 01 00 00 E9 E0 01 00 00 0F BF 4D F8 83 F9 02 0F 85 9F 00 00 00 0F BF 55 FC 85 D2 74 09 0F BF 45 FC 83 F8 01 75 44 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 E8 DD 1C 24 8D 4D 98 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 80 01 00 00 EB 45 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 8D 4D 88 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 E9 39 01 00 00 E9 34 01 00 00 0F BF 4D FC 83 F9 01 0F 85 B2 00 00 00 0F BF 55 F8 85 D2 75 44 83 EC 08 DD 45 F0 DD 1C 24 83 EC 08 DD 45 E8 DD 1C 24 8D 85 78 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 DD 00 00 00 EB 64 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 4D E8 83 EC 08 DD 1C 24 8D 8D 68 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 EB 77 EB 75 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 8D 8D 58 FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "?dangerous_get_state_array@?$dual_state_global@PAPAD@__crt_state_management@@QAEPAPAPADXZ"
		size = 16
		altNames = "?dangerous_get_state_array@?$dual_state_global@P6AXPB_W00II@Z@__crt_state_management@@QAEPAP6AXPB_W00II@ZXZ ?dangerous_get_state_array@?$dual_state_global@PAE@__crt_state_management@@QAEPAPAEXZ ?dangerous_get_state_array@?$dual_state_global@PAU__crt_locale_data@@@__crt_state_management@@QAEPAPAU__crt_locale_data@@XZ ?dangerous_get_state_array@?$dual_state_global@PAU__crt_multibyte_data@@@__crt_state_management@@QAEPAPAU__crt_multibyte_data@@XZ ?data@?$scanset_storage@$00@__crt_stdio_input@@QBEPAEXZ ?get_address_of@?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QAEPAPAUHINSTANCE__@@XZ ?get_address_of@?$__crt_unique_heap_ptr@PADU__crt_internal_free_policy@@@@QAEPAPAPADXZ ?get_address_of@?$__crt_unique_heap_ptr@PA_WU__crt_internal_free_policy@@@@QAEPAPAPA_WXZ ?get_address_of@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAEPAPA_WXZ ?get_address_of@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAEPAPA_WXZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_2_0 {
	meta:
		name = "?initialize@?$dual_state_global@H@__crt_state_management@@QAEXH@Z"
		size = 55
		altNames = "?initialize@?$dual_state_global@J@__crt_state_management@@QAEXJ@Z ?initialize@?$dual_state_global@P6AHI@Z@__crt_state_management@@QAEXQ6AHI@Z@Z ?initialize@?$dual_state_global@P6AHPAU_exception@@@Z@__crt_state_management@@QAEXQ6AHPAU_exception@@@Z@Z ?initialize@?$dual_state_global@P6AXH@Z@__crt_state_management@@QAEXQ6AXH@Z@Z ?initialize@?$dual_state_global@PAU__crt_locale_data@@@__crt_state_management@@QAEXQAU__crt_locale_data@@@Z ?initialize@?$dual_state_global@PAU__crt_multibyte_data@@@__crt_state_management@@QAEXQAU__crt_multibyte_data@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 45 F8 89 45 FC EB 09 8B 4D FC 83 C1 04 89 4D FC 8B 55 F8 83 C2 04 39 55 FC 74 0A 8B 45 FC 8B 4D 08 89 08 EB E2 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_34_4_0 {
	meta:
		name = "?value@?$dual_state_global@H@__crt_state_management@@QAEAAHXZ"
		size = 24
		refs = "000a ?get_current_state_index@__crt_state_management@@YAIXZ"
		altNames = "?value@?$dual_state_global@J@__crt_state_management@@QAEAAJXZ ?value@?$dual_state_global@P6AHI@Z@__crt_state_management@@QAEAAP6AHI@ZXZ ?value@?$dual_state_global@P6AHPAU_exception@@@Z@__crt_state_management@@QAEAAP6AHPAU_exception@@@ZXZ ?value@?$dual_state_global@P6AXH@Z@__crt_state_management@@QAEAAP6AXH@ZXZ ?value@?$dual_state_global@P6AXPB_W00II@Z@__crt_state_management@@QAEAAP6AXPB_W00II@ZXZ ?value@?$dual_state_global@PAE@__crt_state_management@@QAEAAPAEXZ ?value@?$dual_state_global@PAPAD@__crt_state_management@@QAEAAPAPADXZ ?value@?$dual_state_global@PAU__crt_locale_data@@@__crt_state_management@@QAEAAPAU__crt_locale_data@@XZ ?value@?$dual_state_global@PAU__crt_multibyte_data@@@__crt_state_management@@QAEAAPAU__crt_multibyte_data@@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC E8 ?? ?? ?? ?? 8B 4D FC 8D 04 81 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_7_0 {
	meta:
		name = "___acrt_initialize_timeset"
		size = 114
		refs = "000e ?_timezone@@3V?$dual_state_global@J@__crt_state_management@@A 0013 ?initialize@?$dual_state_global@J@__crt_state_management@@QAEXJ@Z 001a ?_daylight@@3V?$dual_state_global@H@__crt_state_management@@A 001f ?initialize@?$dual_state_global@H@__crt_state_management@@QAEXH@Z 0029 ?_dstbias@@3V?$dual_state_global@J@__crt_state_management@@A 0033 ?_tzname@@3V?$dual_state_global@PAPAD@__crt_state_management@@A 0038 ?dangerous_get_state_array@?$dual_state_global@PAPAD@__crt_state_management@@QAEPAPAPADXZ 005d ?tzname_states@@3PAY01PADA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 68 80 70 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 01 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 F0 F1 FF FF B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 F8 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 01 74 15 8B 4D FC 8D 14 CD ?? ?? ?? ?? 8B 45 FC 8B 4D F8 89 14 81 EB DC 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_8_0 {
	meta:
		name = "___daylight"
		size = 17
		refs = "0006 ?_daylight@@3V?$dual_state_global@H@__crt_state_management@@A 000b ?value@?$dual_state_global@H@__crt_state_management@@QAEAAHXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_34_9_0 {
	meta:
		name = "___dstbias"
		size = 17
		refs = "0006 ?_dstbias@@3V?$dual_state_global@J@__crt_state_management@@A 000b ?value@?$dual_state_global@J@__crt_state_management@@QAEAAJXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_152_2_0 {
	meta:
		name = "___p__fmode"
		size = 17
		refs = "0006 __fmode 000b ?value@?$dual_state_global@H@__crt_state_management@@QAEAAHXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_34_10_0 {
	meta:
		name = "___timezone"
		size = 17
		refs = "0006 ?_timezone@@3V?$dual_state_global@J@__crt_state_management@@A 000b ?value@?$dual_state_global@J@__crt_state_management@@QAEAAJXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_34_11_0 {
	meta:
		name = "___tzname"
		size = 19
		refs = "0006 ?_tzname@@3V?$dual_state_global@PAPAD@__crt_state_management@@A 000b ?value@?$dual_state_global@PAPAD@__crt_state_management@@QAEAAPAPADXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 00 5D C3 }
	condition:
		$1
}

rule file_622_36_0 {
	meta:
		name = "___p__mbcasemap"
		size = 19
		refs = "0006 __mbcasemap 000b ?value@?$dual_state_global@PAE@__crt_state_management@@QAEAAPAEXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 00 5D C3 }
	condition:
		$1
}

rule file_622_37_0 {
	meta:
		name = "___p__mbctype"
		size = 19
		refs = "0006 __mbctype 000b ?value@?$dual_state_global@PAE@__crt_state_management@@QAEAAPAEXZ"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 00 5D C3 }
	condition:
		$1
}

rule file_34_12_0 {
	meta:
		name = "__get_daylight"
		size = 151
		refs = "002b ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0030 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0039 ??_C@_1GA@DKIAGECB@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 0040 __CrtDbgReportW 0054 __errno 0068 ??_C@_1BM@FIMHBHEB@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAd?$AAa?$AAy?$AAl?$AAi?$AAg?$AAh?$AAt?$AA?$AA@ 0072 __invalid_parameter 0081 ?_daylight@@3V?$dual_state_global@H@__crt_state_management@@A 0086 ?value@?$dual_state_global@H@__crt_state_management@@QAEAAHXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 3F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 13 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 08 8B 00 89 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_13_0 {
	meta:
		name = "__get_dstbias"
		size = 151
		refs = "002b ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0030 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0039 ??_C@_1GA@DKIAGECB@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 0040 __CrtDbgReportW 0054 __errno 0068 ??_C@_1BK@EMODDHEE@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAd?$AAs?$AAt?$AAb?$AAi?$AAa?$AAs?$AA?$AA@ 0072 __invalid_parameter 0081 ?_dstbias@@3V?$dual_state_global@J@__crt_state_management@@A 0086 ?value@?$dual_state_global@J@__crt_state_management@@QAEAAJXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 49 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 49 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 13 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 08 8B 00 89 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_14_0 {
	meta:
		name = "__get_timezone"
		size = 151
		refs = "002b ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0030 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0039 ??_C@_1GA@DKIAGECB@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 0040 __CrtDbgReportW 0054 __errno 0068 ??_C@_1BM@MGEAKPEJ@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$AA@ 0072 __invalid_parameter 0081 ?_timezone@@3V?$dual_state_global@J@__crt_state_management@@A 0086 ?value@?$dual_state_global@J@__crt_state_management@@QAEAAJXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 53 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 53 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 13 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 08 8B 00 89 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_34_15_0 {
	meta:
		name = "__get_tzname"
		size = 520
		refs = "003d ??_C@_1KM@BFLODGGL@?$AA?$CI?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AA_?$AAi?$AAn?$AA_?$AAb?$AAy@ 0042 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004b ??_C@_1GA@DKIAGECB@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 0052 __CrtDbgReportW 0066 __errno 007a ??_C@_1BI@BHCKCCFA@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAt?$AAz?$AAn?$AAa?$AAm?$AAe?$AA?$AA@ 0084 __invalid_parameter 00cd ??_C@_1CE@HBFOGCFH@?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 014e ??_C@_1DC@BDANNIGD@?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA1?$AA?$AA@ 01a4 ?_tzname@@3V?$dual_state_global@PAPAD@__crt_state_management@@A 01a9 ?value@?$dual_state_global@PAPAD@__crt_state_management@@QAEAAPAPADXZ 01b7 _strlen 01fd _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 83 7D 0C 00 74 06 83 7D 10 00 77 15 83 7D 0C 00 75 06 83 7D 10 00 74 09 C7 45 FC 00 00 00 00 EB 07 C7 45 FC 01 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 64 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 64 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 6F 01 00 00 83 7D 0C 00 74 0F BA 01 00 00 00 6B C2 00 8B 4D 0C C6 04 01 00 83 7D 08 00 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 55 F4 89 55 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 69 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 69 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 DF 00 00 00 83 7D 14 00 74 0F 83 7D 14 01 74 09 C7 45 EC 00 00 00 00 EB 07 C7 45 EC 01 00 00 00 8B 4D EC 89 4D E8 83 7D E8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 6A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 61 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 00 8B 4D 14 8B 14 88 52 E8 ?? ?? ?? ?? 83 C4 04 83 C0 01 8B 4D 08 89 01 83 7D 0C 00 75 04 33 C0 EB 34 8B 55 08 8B 02 3B 45 10 76 07 B8 22 00 00 00 EB 23 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 08 8B 55 14 8B 04 91 50 8B 4D 10 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "_ax0"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 4D 0C 8B 91 B0 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_35_1_0 {
	meta:
		name = "_ax8"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 0F B6 08 8B 55 0C 03 8A B0 00 00 00 8B 45 08 89 08 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_2_0 {
	meta:
		name = "_ax32"
		size = 31
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 88 B0 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_3_0 {
	meta:
		name = "_cx0"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 4D 0C 8B 91 AC 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_35_4_0 {
	meta:
		name = "_cx8"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 0F B6 08 8B 55 0C 03 8A AC 00 00 00 8B 45 08 89 08 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_5_0 {
	meta:
		name = "_cx32"
		size = 31
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 88 AC 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_6_0 {
	meta:
		name = "_dx0"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 4D 0C 8B 91 A8 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_35_7_0 {
	meta:
		name = "_dx8"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 0F B6 08 8B 55 0C 03 8A A8 00 00 00 8B 45 08 89 08 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_8_0 {
	meta:
		name = "_dx32"
		size = 31
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 88 A8 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_9_0 {
	meta:
		name = "_bx0"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 4D 0C 8B 91 A4 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_35_10_0 {
	meta:
		name = "_bx8"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 0F B6 08 8B 55 0C 03 8A A4 00 00 00 8B 45 08 89 08 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_11_0 {
	meta:
		name = "_bx32"
		size = 31
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 88 A4 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_12_0 {
	meta:
		name = "_sib0"
		size = 540
		refs = "0054 $LN30 0133 $LN31 01dc $LN8 01e0 $LN9 01e4 $LN10 01e8 $LN11 01ec $LN12 01f0 $LN13 01f4 $LN14 01f8 $LN15 01fc $LN20 0200 $LN21 0204 $LN22 0208 $LN23 020c $LN24 0210 $LN25 0214 $LN26 0218 $LN27"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 10 0F B6 08 89 4D F8 8B 4D F8 C1 E9 06 BA 01 00 00 00 D3 E2 89 55 F4 8B 45 F8 C1 E8 03 83 E0 07 89 45 FC 83 7D FC 04 75 0C C7 45 FC 00 00 00 00 E9 90 00 00 00 8B 4D FC 83 E1 07 89 4D F0 83 7D F0 07 77 7A 8B 55 F0 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 88 B0 00 00 00 89 4D FC EB 69 8B 55 0C 8B 82 AC 00 00 00 89 45 FC EB 5B 8B 4D 0C 8B 91 A8 00 00 00 89 55 FC EB 4D 8B 45 0C 8B 88 A4 00 00 00 89 4D FC EB 3F 8B 55 0C 8B 82 C4 00 00 00 89 45 FC EB 31 8B 4D 0C 8B 91 B4 00 00 00 89 55 FC EB 23 8B 45 0C 8B 88 A0 00 00 00 89 4D FC EB 15 8B 55 0C 8B 82 9C 00 00 00 89 45 FC EB 07 C7 45 FC 00 00 00 00 8B 4D F8 83 E1 07 89 4D F8 83 7D F8 05 75 1C 8B 55 FC 0F AF 55 F4 8B 45 10 03 50 01 8B 4D 08 89 11 B8 05 00 00 00 E9 DC 00 00 00 83 7D F8 04 75 1A 8B 55 FC 0F AF 55 F4 8B 45 0C 03 90 C4 00 00 00 8B 4D 08 89 11 E9 B7 00 00 00 8B 55 F8 83 E2 07 89 55 EC 83 7D EC 07 0F 87 8A 00 00 00 8B 45 EC FF 24 85 ?? ?? ?? ?? 8B 4D 08 8B 55 0C 8B 82 B0 00 00 00 89 01 EB 79 8B 4D 08 8B 55 0C 8B 82 AC 00 00 00 89 01 EB 69 8B 4D 08 8B 55 0C 8B 82 A8 00 00 00 89 01 EB 59 8B 4D 08 8B 55 0C 8B 82 A4 00 00 00 89 01 EB 49 8B 4D 08 8B 55 0C 8B 82 C4 00 00 00 89 01 EB 39 8B 4D 08 8B 55 0C 8B 82 B4 00 00 00 89 01 EB 29 8B 4D 08 8B 55 0C 8B 82 A0 00 00 00 89 01 EB 19 8B 4D 08 8B 55 0C 8B 82 9C 00 00 00 89 01 EB 09 8B 4D 08 C7 01 00 00 00 00 8B 55 FC 0F AF 55 F4 8B 45 08 03 10 8B 4D 08 89 11 B8 01 00 00 00 8B E5 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_13_0 {
	meta:
		name = "_sib8"
		size = 524
		refs = "0054 $LN29 011a $LN30 01cc $LN8 01d0 $LN9 01d4 $LN10 01d8 $LN11 01dc $LN12 01e0 $LN13 01e4 $LN14 01e8 $LN15 01ec $LN19 01f0 $LN20 01f4 $LN21 01f8 $LN22 01fc $LN23 0200 $LN24 0204 $LN25 0208 $LN26"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 10 0F B6 08 89 4D F8 8B 4D F8 C1 E9 06 BA 01 00 00 00 D3 E2 89 55 EC 8B 45 F8 C1 E8 03 83 E0 07 89 45 FC 83 7D FC 04 75 0C C7 45 FC 00 00 00 00 E9 90 00 00 00 8B 4D FC 83 E1 07 89 4D F4 83 7D F4 07 77 7A 8B 55 F4 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 88 B0 00 00 00 89 4D FC EB 69 8B 55 0C 8B 82 AC 00 00 00 89 45 FC EB 5B 8B 4D 0C 8B 91 A8 00 00 00 89 55 FC EB 4D 8B 45 0C 8B 88 A4 00 00 00 89 4D FC EB 3F 8B 55 0C 8B 82 C4 00 00 00 89 45 FC EB 31 8B 4D 0C 8B 91 B4 00 00 00 89 55 FC EB 23 8B 45 0C 8B 88 A0 00 00 00 89 4D FC EB 15 8B 55 0C 8B 82 9C 00 00 00 89 45 FC EB 07 C7 45 FC 00 00 00 00 8B 4D F8 83 E1 07 89 4D F8 83 7D F8 04 75 23 8B 55 10 0F B6 42 01 8B 4D 0C 03 81 C4 00 00 00 8B 55 FC 0F AF 55 EC 03 C2 8B 4D 08 89 01 E9 C0 00 00 00 8B 55 F8 83 E2 07 89 55 F0 83 7D F0 07 0F 87 8A 00 00 00 8B 45 F0 FF 24 85 ?? ?? ?? ?? 8B 4D 08 8B 55 0C 8B 82 B0 00 00 00 89 01 EB 79 8B 4D 08 8B 55 0C 8B 82 AC 00 00 00 89 01 EB 69 8B 4D 08 8B 55 0C 8B 82 A8 00 00 00 89 01 EB 59 8B 4D 08 8B 55 0C 8B 82 A4 00 00 00 89 01 EB 49 8B 4D 08 8B 55 0C 8B 82 C4 00 00 00 89 01 EB 39 8B 4D 08 8B 55 0C 8B 82 B4 00 00 00 89 01 EB 29 8B 4D 08 8B 55 0C 8B 82 A0 00 00 00 89 01 EB 19 8B 4D 08 8B 55 0C 8B 82 9C 00 00 00 89 01 EB 09 8B 4D 08 C7 01 00 00 00 00 8B 55 10 0F B6 42 01 8B 4D FC 0F AF 4D EC 03 C1 8B 55 08 03 02 8B 4D 08 89 01 B8 02 00 00 00 8B E5 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_14_0 {
	meta:
		name = "_sib32"
		size = 520
		refs = "0054 $LN29 0119 $LN30 01c8 $LN8 01cc $LN9 01d0 $LN10 01d4 $LN11 01d8 $LN12 01dc $LN13 01e0 $LN14 01e4 $LN15 01e8 $LN19 01ec $LN20 01f0 $LN21 01f4 $LN22 01f8 $LN23 01fc $LN24 0200 $LN25 0204 $LN26"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 10 0F B6 08 89 4D F8 8B 4D F8 C1 E9 06 BA 01 00 00 00 D3 E2 89 55 EC 8B 45 F8 C1 E8 03 83 E0 07 89 45 FC 83 7D FC 04 75 0C C7 45 FC 00 00 00 00 E9 90 00 00 00 8B 4D FC 83 E1 07 89 4D F4 83 7D F4 07 77 7A 8B 55 F4 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 88 B0 00 00 00 89 4D FC EB 69 8B 55 0C 8B 82 AC 00 00 00 89 45 FC EB 5B 8B 4D 0C 8B 91 A8 00 00 00 89 55 FC EB 4D 8B 45 0C 8B 88 A4 00 00 00 89 4D FC EB 3F 8B 55 0C 8B 82 C4 00 00 00 89 45 FC EB 31 8B 4D 0C 8B 91 B4 00 00 00 89 55 FC EB 23 8B 45 0C 8B 88 A0 00 00 00 89 4D FC EB 15 8B 55 0C 8B 82 9C 00 00 00 89 45 FC EB 07 C7 45 FC 00 00 00 00 8B 4D F8 83 E1 07 89 4D F8 83 7D F8 04 75 22 8B 55 10 8B 42 01 8B 4D 0C 03 81 C4 00 00 00 8B 55 FC 0F AF 55 EC 03 C2 8B 4D 08 89 01 E9 BF 00 00 00 8B 55 F8 83 E2 07 89 55 F0 83 7D F0 07 0F 87 8A 00 00 00 8B 45 F0 FF 24 85 ?? ?? ?? ?? 8B 4D 08 8B 55 0C 8B 82 B0 00 00 00 89 01 EB 79 8B 4D 08 8B 55 0C 8B 82 AC 00 00 00 89 01 EB 69 8B 4D 08 8B 55 0C 8B 82 A8 00 00 00 89 01 EB 59 8B 4D 08 8B 55 0C 8B 82 A4 00 00 00 89 01 EB 49 8B 4D 08 8B 55 0C 8B 82 C4 00 00 00 89 01 EB 39 8B 4D 08 8B 55 0C 8B 82 B4 00 00 00 89 01 EB 29 8B 4D 08 8B 55 0C 8B 82 A0 00 00 00 89 01 EB 19 8B 4D 08 8B 55 0C 8B 82 9C 00 00 00 89 01 EB 09 8B 4D 08 C7 01 00 00 00 00 8B 55 FC 0F AF 55 EC 8B 45 10 8B 48 01 03 CA 8B 55 08 03 0A 8B 45 08 89 08 B8 05 00 00 00 8B E5 5D C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_15_0 {
	meta:
		name = "_d32"
		size = 22
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 4D 10 8B 11 89 10 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_16_0 {
	meta:
		name = "_bp8"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 0F B6 08 8B 55 0C 03 8A B4 00 00 00 8B 45 08 89 08 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_17_0 {
	meta:
		name = "_bp32"
		size = 31
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 88 B4 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_18_0 {
	meta:
		name = "_si0"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 4D 0C 8B 91 A0 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_35_19_0 {
	meta:
		name = "_si8"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 0F B6 08 8B 55 0C 03 8A A0 00 00 00 8B 45 08 89 08 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_20_0 {
	meta:
		name = "_si32"
		size = 31
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 88 A0 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_21_0 {
	meta:
		name = "_di0"
		size = 23
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 4D 0C 8B 91 9C 00 00 00 89 10 33 C0 5D C3 }
	condition:
		$1
}

rule file_35_22_0 {
	meta:
		name = "_di8"
		size = 32
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 0F B6 08 8B 55 0C 03 8A 9C 00 00 00 8B 45 08 89 08 B8 01 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_23_0 {
	meta:
		name = "_di32"
		size = 31
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 88 9C 00 00 00 8B 55 10 03 0A 8B 45 08 89 08 B8 04 00 00 00 5D C3 }
	condition:
		$1
}

rule file_35_25_0 {
	meta:
		name = "_AdjustExceptionResult"
		size = 1064
		refs = "0052 $LN60 0059 $LN69 0075 $LN70 00ed $LN71 0106 $LN61 010d $LN72 0147 $LN62 014e $LN73 0185 $LN63 018c $LN74 01c3 $LN64 01ca $LN75 0206 $LN76 021f $LN65 0226 $LN77 026e $LN66 0275 $LN78 02bd $LN67 02c4 $LN79 0309 $LN68 0310 $LN80 0344 $LN33 0348 $LN28 034c $LN46 0350 $LN1 0378 $LN29 037c $LN30 0380 $LN31 0384 $LN32 0388 $LN34 038c $LN37 0390 $LN40 0394 $LN43 0398 $LN35 039c $LN36 03a8 $LN39 03ac $LN38 03b8 $LN42 03bc $LN41 03c8 $LN44 03cc $LN45 03d8 $LN47 03dc $LN50 03e0 $LN53 03e4 $LN56 03e8 $LN48 03ec $LN49 03f8 $LN52 03fc $LN51 0408 $LN55 040c $LN54 0418 $LN57 041c $LN58"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 8B 45 0C 8B 48 20 8B 51 60 83 E2 01 75 05 E9 23 03 00 00 8B 45 0C 8B 48 20 8B 51 60 D1 EA 83 E2 0F 83 FA 07 74 05 E9 0B 03 00 00 8B 45 08 89 45 FC 8B 4D FC 83 E9 39 89 4D FC 83 7D FC 21 0F 87 F2 02 00 00 8B 55 FC 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 0C 8B 51 20 8B 42 50 89 45 F8 83 7D F8 03 77 5D 8B 4D F8 FF 24 8D ?? ?? ?? ?? 8B 55 0C 8B 42 1C 25 6A F7 FF FF 83 C8 40 8B 4D 0C 89 41 1C EB 3D 8B 55 0C 8B 42 1C 25 2A F7 FF FF 8B 4D 0C 89 41 1C EB 2A 8B 55 0C 8B 42 1C 25 2B F7 FF FF 83 C8 01 8B 4D 0C 89 41 1C EB 14 8B 55 0C 8B 42 1C 25 6F F7 FF FF 83 C8 45 8B 4D 0C 89 41 1C E9 6D 02 00 00 8B 55 0C 8B 42 20 8B 48 50 89 4D F4 83 7D F4 03 0F 87 03 01 00 00 8B 55 F4 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 48 18 89 4D F0 83 7D F0 07 77 2D 8B 55 F0 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 0C 8B 51 20 C7 42 50 FF FF FF FF EB 0D 8B 45 0C 8B 48 20 C7 41 50 00 00 00 00 E9 B8 00 00 00 8B 55 0C 8B 42 18 89 45 EC 83 7D EC 07 77 2D 8B 4D EC 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 48 20 C7 41 50 FF FF FF FF EB 0D 8B 55 0C 8B 42 20 C7 40 50 00 00 00 00 EB 7A 8B 4D 0C 8B 51 18 89 55 E8 83 7D E8 07 77 2D 8B 45 E8 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 0C 8B 42 20 C7 40 50 FF FF FF FF EB 0D 8B 4D 0C 8B 51 20 C7 42 50 00 00 00 00 EB 3C 8B 45 0C 8B 48 18 89 4D E4 83 7D E4 07 77 2D 8B 55 E4 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 0C 8B 51 20 C7 42 50 00 00 00 00 EB 0D 8B 45 0C 8B 48 20 C7 41 50 FF FF FF FF 8B 55 0C 8B 42 20 8B 48 50 89 4D E0 83 7D E0 03 0F 87 3E 01 00 00 8B 55 E0 FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 48 18 89 4D DC 83 7D DC 07 77 3B 8B 55 DC 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 0C 8B 51 20 C7 42 50 FF FF FF FF C7 42 54 FF FF FF FF EB 14 8B 45 0C 8B 48 20 C7 41 50 00 00 00 00 C7 41 54 00 00 00 00 E9 E5 00 00 00 8B 55 0C 8B 42 18 89 45 D8 83 7D D8 07 77 3B 8B 4D D8 0F B6 91 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 45 0C 8B 48 20 C7 41 50 FF FF FF FF C7 41 54 FF FF FF FF EB 14 8B 55 0C 8B 42 20 C7 40 50 00 00 00 00 C7 40 54 00 00 00 00 E9 96 00 00 00 8B 4D 0C 8B 51 18 89 55 D4 83 7D D4 07 77 3B 8B 45 D4 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 55 0C 8B 42 20 C7 40 50 FF FF FF FF C7 40 54 FF FF FF FF EB 14 8B 4D 0C 8B 51 20 C7 42 50 00 00 00 00 C7 42 54 00 00 00 00 EB 4A 8B 45 0C 8B 48 18 89 4D D0 83 7D D0 07 77 3B 8B 55 D0 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 0C 8B 51 20 C7 42 50 00 00 00 00 C7 42 54 00 00 00 00 EB 14 8B 45 0C 8B 48 20 C7 41 50 FF FF FF FF C7 41 54 FF FF FF FF 8B E5 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 01 01 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 03 02 02 01 01 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 01 01 01 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 01 01 01 01 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 01 01 01 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 01 01 01 01 00 }
	condition:
		$1
}

rule file_35_26_0 {
	meta:
		name = "_DppxEmulationWrapper"
		size = 1211
		refs = "00d8 _LoopDppxSimdValue"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 56 57 C7 45 F4 00 00 00 00 C7 45 D0 00 00 00 00 8B 45 1C 8B 08 C1 E9 1E 83 E1 03 83 C1 01 89 4D F0 8B 55 0C 83 7A 28 6D 75 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 02 00 00 00 8B 45 EC 89 45 CC C7 45 F8 00 00 00 00 EB 09 8B 4D F8 83 C1 01 89 4D F8 8B 55 F8 3B 55 CC 0F 87 AE 03 00 00 8B 45 0C 8B 48 28 89 4D E8 83 7D E8 48 74 26 83 7D E8 6D 74 02 EB 3A 83 7D F8 00 75 09 C7 45 E4 4D 00 00 00 EB 07 C7 45 E4 49 00 00 00 8B 55 E4 89 55 F4 EB 1C 83 7D F8 00 75 09 C7 45 E0 2F 00 00 00 EB 07 C7 45 E0 2B 00 00 00 8B 45 E0 89 45 F4 8B 4D F4 51 8B 55 F8 52 8B 45 F0 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 20 89 45 D0 8B 45 08 89 45 DC 83 7D DC 00 0F 84 DD 00 00 00 83 7D DC 01 74 05 E9 12 03 00 00 8B 4D F8 89 4D C8 83 7D C8 00 74 05 E9 BC 00 00 00 BA 08 00 00 00 6B C2 00 B9 08 00 00 00 6B D1 00 8B 4D 0C 8B 75 0C 8B BC 06 B0 00 00 00 89 7C 11 50 8B 84 06 B4 00 00 00 89 44 11 54 B9 08 00 00 00 C1 E1 00 BA 08 00 00 00 C1 E2 00 8B 45 0C 8B 75 0C 8B BC 0E B0 00 00 00 89 7C 10 50 8B 8C 0E B4 00 00 00 89 4C 10 54 BA 08 00 00 00 C1 E2 00 B8 08 00 00 00 6B C8 00 8B 45 0C 8B 75 0C 8B BC 16 B0 00 00 00 89 BC 08 80 00 00 00 8B 94 16 B4 00 00 00 89 94 08 84 00 00 00 B8 08 00 00 00 6B C8 00 BA 08 00 00 00 C1 E2 00 8B 45 0C 8B 75 0C 8B BC 0E B0 00 00 00 89 BC 10 80 00 00 00 8B 8C 0E B4 00 00 00 89 8C 10 84 00 00 00 E9 40 02 00 00 8B 55 F8 89 55 D8 83 7D D8 00 74 0F 83 7D D8 01 0F 84 1A 01 00 00 E9 25 02 00 00 B8 04 00 00 00 6B C8 00 BA 04 00 00 00 6B C2 00 8B 55 0C 8B 75 0C 8B 8C 0E B0 00 00 00 89 4C 02 50 BA 04 00 00 00 C1 E2 00 B8 04 00 00 00 C1 E0 00 8B 4D 0C 8B 75 0C 8B 94 16 B0 00 00 00 89 54 01 50 B8 04 00 00 00 D1 E0 B9 04 00 00 00 D1 E1 8B 55 0C 8B 75 0C 8B 84 06 B0 00 00 00 89 44 0A 50 B9 04 00 00 00 6B D1 03 B8 04 00 00 00 6B C8 03 8B 45 0C 8B 75 0C 8B 94 16 B0 00 00 00 89 54 08 50 B8 04 00 00 00 C1 E0 00 B9 04 00 00 00 6B D1 00 8B 4D 0C 8B 75 0C 8B 84 06 B0 00 00 00 89 84 11 80 00 00 00 B9 04 00 00 00 6B D1 00 B8 04 00 00 00 C1 E0 00 8B 4D 0C 8B 75 0C 8B 94 16 B0 00 00 00 89 94 01 80 00 00 00 B8 04 00 00 00 6B C8 03 BA 04 00 00 00 D1 E2 8B 45 0C 8B 75 0C 8B 8C 0E B0 00 00 00 89 8C 10 80 00 00 00 BA 04 00 00 00 D1 E2 B8 04 00 00 00 6B C8 03 8B 45 0C 8B 75 0C 8B 94 16 B0 00 00 00 89 94 08 80 00 00 00 E9 10 01 00 00 B8 04 00 00 00 D1 E0 B9 04 00 00 00 6B D1 00 8B 4D 0C 8B 75 0C 8B 84 06 B0 00 00 00 89 44 11 50 B9 04 00 00 00 6B D1 03 B8 04 00 00 00 C1 E0 00 8B 4D 0C 8B 75 0C 8B 94 16 B0 00 00 00 89 54 01 50 B8 04 00 00 00 6B C8 00 BA 04 00 00 00 D1 E2 8B 45 0C 8B 75 0C 8B 8C 0E B0 00 00 00 89 4C 10 50 BA 04 00 00 00 C1 E2 00 B8 04 00 00 00 6B C8 03 8B 45 0C 8B 75 0C 8B 94 16 B0 00 00 00 89 54 08 50 B8 04 00 00 00 C1 E0 00 B9 04 00 00 00 6B D1 00 8B 4D 0C 8B 75 0C 8B 84 06 B0 00 00 00 89 84 11 80 00 00 00 B9 04 00 00 00 6B D1 00 B8 04 00 00 00 C1 E0 00 8B 4D 0C 8B 75 0C 8B 94 16 B0 00 00 00 89 94 01 80 00 00 00 B8 04 00 00 00 6B C8 03 BA 04 00 00 00 D1 E2 8B 45 0C 8B 75 0C 8B 8C 0E B0 00 00 00 89 8C 10 80 00 00 00 BA 04 00 00 00 D1 E2 B8 04 00 00 00 6B C8 03 8B 45 0C 8B 75 0C 8B 94 16 B0 00 00 00 89 94 08 80 00 00 00 E9 3D FC FF FF 8B 45 08 89 45 D4 83 7D D4 00 74 55 83 7D D4 01 74 05 E9 87 00 00 00 C7 45 FC 00 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 3B 55 F0 73 2E 8B 45 10 8B 50 18 8B 4D FC D3 EA 83 E2 01 75 1C 8B 45 FC 8B 4D 0C C7 84 C1 B0 00 00 00 00 00 00 00 C7 84 C1 B4 00 00 00 00 00 00 00 EB C1 EB 3D C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 3B 45 F0 73 23 8B 4D 10 8B 51 18 8B 4D FC D3 EA 83 E2 01 75 11 8B 45 FC 8B 4D 0C C7 84 81 B0 00 00 00 00 00 00 00 EB CC 8B 45 D0 5F 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_27_0 {
	meta:
		name = "_LoadOperand"
		size = 1252
		refs = "011d $LN42 03f3 $LN43 0474 $LN32 0478 $LN1 0480 $LN27 0484 $LN26 0488 $LN25 048c $LN23 049c $LN21 04a0 $LN22 04a4 $LN31 04a8 $LN28 04b0 $LN29 04b8 $LN24 04bc $LN20 04c0 $LN30 04c4 $LN33 04c8 $LN34 04cc $LN35 04d0 $LN36 04d8 $LN38 04dc $LN39 04e0 $LN40"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 8B 45 14 8B 4D 0C 89 08 8B 55 14 83 3A 1F 75 14 8B 45 14 8B 48 20 83 E1 FE 8B 55 14 89 4A 20 E9 42 04 00 00 83 7D 0C 15 74 12 83 7D 0C 14 74 0C 83 7D 0C 17 74 06 83 7D 0C 1B 75 22 0F B6 45 08 85 C0 74 0F 83 7D 0C 14 75 09 8B 4D 14 C7 01 08 00 00 00 8B 55 14 8B 45 1C 89 42 04 EB 4A 0F B6 4D 08 85 C9 74 42 83 7D 0C 1F 74 3C 83 7D 0C 12 75 09 8B 55 14 C7 02 0D 00 00 00 83 7D 0C 13 75 09 8B 45 14 C7 00 19 00 00 00 83 7D 0C 0E 75 09 8B 4D 14 C7 01 0D 00 00 00 83 7D 0C 0C 75 09 8B 55 14 C7 02 0B 00 00 00 B8 01 00 00 00 6B C8 00 8B 55 18 8D 84 0A CC 00 00 00 89 45 FC C7 45 F0 00 00 00 00 EB 09 8B 4D F0 83 C1 01 89 4D F0 83 7D F0 04 73 10 8B 55 F0 8B 45 14 C7 44 90 10 00 00 00 00 EB E1 8B 4D 14 8B 51 20 83 CA 01 8B 45 14 89 50 20 8B 4D 14 8B 11 89 55 EC 8B 45 EC 83 E8 08 89 45 EC 83 7D EC 13 0F 87 57 03 00 00 8B 4D EC FF 24 8D ?? ?? ?? ?? 8B 55 14 8B 42 20 83 E0 E1 83 C8 0A 8B 4D 14 89 41 20 8B 55 FC 8B 45 14 83 C0 10 8B 4A 10 8B 11 89 10 8B 51 04 89 50 04 8B 51 08 89 50 08 8B 49 0C 89 48 0C E9 14 03 00 00 8B 55 14 8B 42 20 83 E0 E1 8B 4D 14 89 41 20 8B 55 FC 8B 45 14 83 C0 10 8B 4A 10 8B 11 89 10 8B 51 04 89 50 04 8B 51 08 89 50 08 8B 49 0C 89 48 0C E9 DE 02 00 00 8B 55 14 8B 42 20 83 E0 E1 83 C8 02 8B 4D 14 89 41 20 8B 55 FC 8B 45 14 83 C0 10 8B 4A 10 8B 11 89 10 8B 51 04 89 50 04 8B 51 08 89 50 08 8B 49 0C 89 48 0C E9 A5 02 00 00 8B 55 14 8B 42 20 83 E0 E1 8B 4D 14 89 41 20 8B 55 FC 8B 42 10 8B 08 8B 50 04 8B 45 14 89 48 10 89 50 14 E9 7D 02 00 00 8B 4D 14 8B 51 20 83 E2 E1 83 CA 02 8B 45 14 89 50 20 8B 4D FC 8B 51 10 8B 02 8B 4A 04 8B 55 14 89 42 10 89 4A 14 E9 52 02 00 00 8B 45 14 8B 48 20 83 E1 E1 8B 55 14 89 4A 20 8B 45 FC 8B 48 10 8B 55 14 8B 01 89 42 10 E9 30 02 00 00 8B 4D 14 8B 51 20 83 E2 E1 83 CA 0A 8B 45 14 89 50 20 8B 4D FC 8B 51 10 8B 02 8B 4A 04 8B 55 14 89 42 10 89 4A 14 E9 05 02 00 00 8B 45 14 8B 48 20 83 E1 E1 83 C9 0A 8B 55 14 89 4A 20 8B 45 FC 8B 48 10 8B 55 14 8B 01 89 42 10 E9 E0 01 00 00 B9 10 00 00 00 6B D1 00 8B 45 FC 8D 8C 10 A0 00 00 00 89 4D F8 8B 55 14 8B 42 20 83 E0 E1 8B 4D 14 89 41 20 8B 55 10 C1 E2 04 03 55 F8 89 55 F4 8B 45 14 83 C0 10 8B 4D F4 8B 11 89 10 8B 51 04 89 50 04 8B 51 08 89 50 08 8B 49 0C 89 48 0C E9 8C 01 00 00 BA 10 00 00 00 6B C2 00 8B 4D FC 8D 94 01 A0 00 00 00 89 55 F8 8B 45 14 8B 48 20 83 E1 E1 83 C9 02 8B 55 14 89 4A 20 8B 45 10 C1 E0 04 03 45 F8 89 45 F4 8B 4D 14 83 C1 10 8B 55 F4 8B 02 89 01 8B 42 04 89 41 04 8B 42 08 89 41 08 8B 52 0C 89 51 0C E9 35 01 00 00 B8 10 00 00 00 6B C8 00 8B 55 FC 8D 84 0A A0 00 00 00 89 45 F8 8B 4D 14 8B 51 20 83 E2 E1 83 CA 0A 8B 45 14 89 50 20 8B 4D 10 C1 E1 04 03 4D F8 89 4D F4 BA 04 00 00 00 6B C2 00 8B 4D 14 8B 55 F4 8B 04 02 89 41 10 E9 E9 00 00 00 B9 10 00 00 00 6B D1 00 8B 45 FC 8D 4C 10 20 89 4D E4 8B 55 14 8B 42 20 83 E0 E1 83 C8 0A 8B 4D 14 89 41 20 8B 55 10 C1 E2 04 03 55 E4 89 55 E0 8B 45 E0 8B 08 8B 50 04 8B 45 14 89 48 10 89 50 14 E9 A3 00 00 00 8B 4D 14 8B 51 20 83 E2 E1 83 CA 0A 8B 45 14 89 50 20 8B 4D 10 89 4D E8 83 7D E8 07 0F 87 81 00 00 00 8B 55 E8 FF 24 95 ?? ?? ?? ?? 8B 45 14 8B 4D 18 8B 91 B0 00 00 00 89 50 10 EB 66 8B 45 14 8B 4D 18 8B 91 AC 00 00 00 89 50 10 EB 55 8B 45 14 8B 4D 18 8B 91 A8 00 00 00 89 50 10 EB 44 8B 45 14 8B 4D 18 8B 91 A4 00 00 00 89 50 10 EB 33 EB 31 8B 45 14 8B 4D 18 8B 91 B4 00 00 00 89 50 10 EB 20 8B 45 14 8B 4D 18 8B 91 A0 00 00 00 89 50 10 EB 0F 8B 45 14 8B 4D 18 8B 91 9C 00 00 00 89 50 10 8B E5 5D C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_28_0 {
	meta:
		name = "_LoopDppxSimdValue"
		size = 1388
		refs = "0009 ___security_cookie 03c6 __XMMI2_FP_Emulation 03de __XMMI_FP_Emulation 04b7 ___guard_check_icall_fptr 0564 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 C7 45 EC FF FF FF FF 8B 45 10 83 C0 04 89 45 F0 8B 4D 0C 83 C1 04 89 4D F4 C7 45 D0 04 00 00 00 C7 45 F8 00 00 00 00 EB 09 8B 55 F8 83 C2 01 89 55 F8 8B 45 F8 3B 45 1C 0F 83 09 05 00 00 83 7D 20 00 75 7C 8B 4D F8 03 4D D0 8B 55 10 8B 42 18 D3 E8 83 E0 01 75 69 8B 4D 08 89 4D E8 83 7D E8 00 74 26 83 7D E8 01 74 02 EB 2F 8B 55 F8 8B 45 0C C7 84 D0 B0 00 00 00 00 00 00 00 C7 84 D0 B4 00 00 00 00 00 00 00 EB 11 8B 4D F8 8B 55 0C C7 84 8A B0 00 00 00 00 00 00 00 8B 45 0C 8B 88 C0 00 00 00 83 C9 01 8B 55 0C 89 8A C0 00 00 00 8B 45 0C 8B 4D 10 8B 51 1C 89 50 30 E9 69 FF FF FF 8B 45 10 C7 40 04 00 00 00 00 8B 4D 14 8B 51 04 83 E2 FE 8B 45 14 89 50 04 8B 4D 14 8B 51 04 83 E2 FD 8B 45 14 89 50 04 8B 4D 14 8B 51 04 83 E2 FB 8B 45 14 89 50 04 8B 4D 14 8B 51 04 83 E2 F7 8B 45 14 89 50 04 8B 4D 14 8B 51 04 83 E2 EF 8B 45 14 89 50 04 8B 4D 14 8B 51 08 83 E2 FE 8B 45 14 89 50 08 8B 4D 14 8B 51 08 83 E2 FD 8B 45 14 89 50 08 8B 4D 14 8B 51 08 83 E2 FB 8B 45 14 89 50 08 8B 4D 14 8B 51 08 83 E2 F7 8B 45 14 89 50 08 8B 4D 14 8B 51 08 83 E2 EF 8B 45 14 89 50 08 8B 4D 14 8B 51 0C 83 E2 FE 8B 45 14 89 50 0C 8B 4D 14 8B 51 0C 83 E2 FD 8B 45 14 89 50 0C 8B 4D 14 8B 51 0C 83 E2 FB 8B 45 14 89 50 0C 8B 4D 14 8B 51 0C 83 E2 F7 8B 45 14 89 50 0C 8B 4D 14 8B 51 0C 83 E2 EF 8B 45 14 89 50 0C 8B 4D 10 8B 51 10 83 E2 03 8B 45 14 8B 08 83 E1 FC 0B CA 8B 55 14 89 0A 8B 45 10 8B 48 14 83 E1 07 C1 E1 02 8B 55 14 8B 02 83 E0 E3 0B C1 8B 4D 14 89 01 8B 55 24 81 E2 FF 0F 00 00 C1 E2 05 8B 45 14 8B 08 81 E1 1F 00 FE FF 0B CA 8B 55 14 89 0A 8B 45 0C 8B 48 60 83 E1 01 83 E1 01 8B 55 14 8B 42 20 83 E0 FE 0B C1 8B 4D 14 89 41 20 8B 55 0C 8B 42 60 D1 E8 83 E0 0F 83 E0 0F D1 E0 8B 4D 14 8B 51 20 83 E2 E1 0B D0 8B 45 14 89 50 20 8B 4D 08 89 4D E4 83 7D E4 00 74 21 83 7D E4 01 74 02 EB 29 8B 55 14 8B 45 F8 8B 4D 0C 8B 74 C1 50 89 72 10 8B 44 C1 54 89 42 14 EB 10 8B 4D 14 8B 55 F8 8B 45 0C 8B 54 90 50 89 51 10 8B 45 0C 8B 88 90 00 00 00 83 E1 01 74 46 8B 55 0C 8B 82 90 00 00 00 83 E0 01 83 E0 01 8B 4D 14 8B 51 40 83 E2 FE 0B D0 8B 45 14 89 50 40 8B 4D 0C 8B 91 90 00 00 00 D1 EA 83 E2 0F 83 E2 0F D1 E2 8B 45 14 8B 48 40 83 E1 E1 0B CA 8B 55 14 89 4A 40 EB 0F 8B 45 14 8B 48 40 83 E1 FE 8B 55 14 89 4A 40 8B 45 08 89 45 E0 83 7D E0 00 74 27 83 7D E0 01 74 02 EB 32 8B 4D 14 8B 55 F8 8B 45 0C 8B B4 D0 80 00 00 00 89 71 30 8B 94 D0 84 00 00 00 89 51 34 EB 13 8B 45 14 8B 4D F8 8B 55 0C 8B 8C 8A 80 00 00 00 89 48 30 8B 55 14 8B 42 60 83 E0 FE 8B 4D 14 89 41 60 8B 55 08 89 55 DC 83 7D DC 00 74 27 83 7D DC 01 74 02 EB 32 8B 45 14 8B 4D F8 8B 55 0C 8B B4 CA B0 00 00 00 89 70 50 8B 8C CA B4 00 00 00 89 48 54 EB 13 8B 55 14 8B 45 F8 8B 4D 0C 8B 84 81 B0 00 00 00 89 42 50 8B 4D 0C 8B 91 C0 00 00 00 D1 EA 83 E2 0F 83 E2 0F D1 E2 8B 45 14 8B 48 60 83 E1 E1 0B CA 8B 55 14 89 4A 60 8B 45 10 8B 4D 14 89 48 20 83 7D 08 01 74 06 83 7D 08 02 75 18 8B 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F8 8B 55 0C 89 44 8A 08 EB 16 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D F8 8B 55 0C 89 44 8A 08 8B 45 F8 8B 4D 0C 8B 55 10 8B 52 04 89 54 81 18 8B 45 F8 8B 4D 0C 83 7C 81 08 01 0F 85 C2 00 00 00 8B 55 F0 8B 02 C1 E8 05 83 E0 01 74 0D 8B 4D F4 8B 11 83 CA 20 8B 45 F4 89 10 8B 4D F0 8B 11 C1 EA 04 83 E2 01 74 0D 8B 45 F4 8B 08 83 C9 10 8B 55 F4 89 0A 8B 45 F0 8B 08 C1 E9 03 83 E1 01 74 0D 8B 55 F4 8B 02 83 C8 08 8B 4D F4 89 01 8B 55 F0 8B 02 C1 E8 02 83 E0 01 74 0D 8B 4D F4 8B 11 83 CA 04 8B 45 F4 89 10 8B 4D F0 8B 11 D1 EA 83 E2 01 74 0D 8B 45 F4 8B 08 83 C9 02 8B 55 F4 89 0A 8B 45 F0 8B 08 83 E1 01 74 0D 8B 55 F4 8B 02 83 C8 01 8B 4D F4 89 01 8B 55 14 52 8B 45 18 89 45 D8 8B 4D D8 FF 15 ?? ?? ?? ?? FF 55 D8 83 C4 04 89 45 EC 83 7D EC FF 74 08 8B 45 EC E9 8B 00 00 00 8B 4D 14 8B 51 60 83 E2 01 83 E2 01 8B 45 0C 8B 88 C0 00 00 00 83 E1 FE 0B CA 8B 55 0C 89 8A C0 00 00 00 8B 45 0C 8B 4D 10 8B 51 1C 89 50 30 8B 45 0C 8B 88 C0 00 00 00 83 E1 01 74 46 8B 55 08 89 55 D4 83 7D D4 00 74 27 83 7D D4 01 74 02 EB 32 8B 45 F8 8B 4D 0C 8B 55 14 8B 72 50 89 B4 C1 B0 00 00 00 8B 52 54 89 94 C1 B4 00 00 00 EB 13 8B 45 F8 8B 4D 0C 8B 55 14 8B 52 50 89 94 81 B0 00 00 00 E9 E2 FA FF FF 8B 45 EC 5E 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_35_29_0 {
	meta:
		name = "_SetPniOperation"
		size = 264
		refs = "002b $LN17 0032 $LN18 00c4 $LN7 00c8 $LN12 00cc $LN14 00d0 $LN4 00d4 $LN11 00d8 $LN13 00dc $LN15"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 C6 45 FF 00 8B 45 08 89 45 F8 8B 4D F8 83 E9 43 89 4D F8 83 7D F8 27 0F 87 93 00 00 00 8B 55 F8 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 83 7D 10 00 75 0B 8B 4D 0C C7 01 4B 00 00 00 EB 09 8B 55 0C C7 02 49 00 00 00 C6 45 FF 01 EB 66 83 7D 10 00 74 06 83 7D 10 02 75 0B 8B 45 0C C7 00 2D 00 00 00 EB 09 8B 4D 0C C7 01 2B 00 00 00 C6 45 FF 01 EB 40 8B 55 0C C7 02 49 00 00 00 C6 45 FF 01 EB 31 8B 45 0C C7 00 2B 00 00 00 C6 45 FF 01 EB 22 8B 4D 0C C7 01 4B 00 00 00 C6 45 FF 01 EB 13 8B 55 0C C7 02 2D 00 00 00 C6 45 FF 01 EB 04 C6 45 FF 00 8A 45 FF 8B E5 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 02 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 06 03 04 05 }
	condition:
		$1
}

rule file_35_30_0 {
	meta:
		name = "_UpdateResult"
		size = 580
		refs = "006e $LN24 0075 $LN25 015a $LN26 01e8 $LN13 01ec $LN22 01f0 $LN10 01f4 $LN9 01f8 $LN8 01fc $LN7 0200 $LN6 0204 $LN12 0208 $LN11 020c $LN1 0224 $LN14 0228 $LN15 022c $LN16 0230 $LN17 0238 $LN19 023c $LN20 0240 $LN21"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 8B 45 08 8B 48 04 89 4D F4 BA 01 00 00 00 6B C2 00 8B 4D 0C 8D 94 01 CC 00 00 00 89 55 FC B8 10 00 00 00 6B C8 00 8B 55 FC 8D 84 0A A0 00 00 00 89 45 EC B9 10 00 00 00 6B D1 00 8B 45 FC 8D 4C 10 20 89 4D E8 8B 55 08 8B 02 89 45 F8 8B 4D F8 83 E9 08 89 4D F8 83 7D F8 13 0F 87 79 01 00 00 8B 55 F8 0F B6 82 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 4D 08 83 C1 10 8B 55 FC 8B 42 10 8B 11 89 10 8B 51 04 89 50 04 8B 51 08 89 50 08 8B 49 0C 89 48 0C E9 41 01 00 00 8B 55 08 8B 42 10 8B 4A 14 8B 55 FC 8B 52 10 89 02 89 4A 04 E9 28 01 00 00 8B 45 FC 8B 48 10 8B 55 08 8B 42 10 89 01 E9 15 01 00 00 8B 4D 08 8B 51 10 8B 41 14 8B 4D FC 8B 49 10 89 11 89 41 04 E9 FC 00 00 00 8B 55 FC 8B 42 10 8B 4D 08 8B 51 10 89 10 E9 E9 00 00 00 8B 45 08 83 C0 10 8B 4D F4 C1 E1 04 03 4D EC 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C E9 BF 00 00 00 8B 4D F4 C1 E1 04 03 4D E8 89 4D E4 8B 55 08 8B 42 10 8B 4A 14 8B 55 E4 89 02 89 4A 04 E9 9D 00 00 00 8B 45 F4 89 45 F0 83 7D F0 07 0F 87 81 00 00 00 8B 4D F0 FF 24 8D ?? ?? ?? ?? 8B 55 0C 8B 45 08 8B 48 10 89 8A B0 00 00 00 EB 66 8B 55 0C 8B 45 08 8B 48 10 89 8A AC 00 00 00 EB 55 8B 55 0C 8B 45 08 8B 48 10 89 8A A8 00 00 00 EB 44 8B 55 0C 8B 45 08 8B 48 10 89 8A A4 00 00 00 EB 33 EB 31 8B 55 0C 8B 45 08 8B 48 10 89 8A B4 00 00 00 EB 20 8B 55 0C 8B 45 08 8B 48 10 89 8A A0 00 00 00 EB 0F 8B 55 0C 8B 45 08 8B 48 10 89 8A 9C 00 00 00 8B 55 0C 8B 45 10 89 82 C0 00 00 00 8B E5 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 09 02 03 04 05 09 09 09 06 06 07 08 09 08 09 05 06 08 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_35_31_0 {
	meta:
		name = "__fpieee_flt_simd"
		size = 9025
		refs = "001b __sehtable$__fpieee_flt_simd 0020 __except_handler4 0037 ___security_cookie 0126 ___guard_check_icall_fptr 0161 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 016d ??_C@_1GO@PNDLPLPE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 0174 __CrtDbgReportW 0285 $LN242 028c $LN250 0728 $LN251 0732 _InstInfoTable5X 0741 _InstInfoTableCX 0750 _InstInfoTable2X 075f _InstInfoTableEX 076e _InstInfoTableDX 0792 _InstInfoTable7X 084e _InstInfoTable0X 085a _InstInfoTable4X 0a99 _InstInfoTableX 0bd7 $LN243 0bde $LN252 0c39 ___acrt_can_use_xstate_apis 0c88 ___acrt_GetEnabledXStateFeatures@0 0d16 ___acrt_GetXStateFeaturesMask@8 0d72 ___acrt_LocateXStateFeature@12 0e16 _modrm32 1098 _LoadOperand 125e $LN253 138c _DppxEmulationWrapper 1503 _SetPniOperation 17c2 $LN244 17c9 $LN254 1ac3 $LN245 1aca $LN255 1bb9 $LN246 1bc0 $LN256 1c5d __XMMI2_FP_Emulation 1c7b __XMMI_FP_Emulation 1ec5 _AdjustExceptionResult 1f8e $LN247 1f95 $LN257 2007 _UpdateResult 2160 @__security_check_cookie@4 216c $LN62 2170 $LN60 2174 $LN75 2178 $LN63 217c $LN71 2180 $LN61 2184 $LN59 2188 $LN76 225c $LN86 2260 $LN92 2264 $LN99 2268 $LN84 2270 $LN90 2284 $LN85 2288 $LN88 228c $LN87 2290 $LN128 2294 $LN126 22d4 $LN145 22d8 $LN146 22dc $LN147 22e0 $LN148 22e4 $LN166 22e8 $LN168 22ec $LN167 22fc $LN183 2300 $LN185 2304 $LN184 2314 $LN189 2318 $LN191 231c $LN190 232c $LN209 2330 $LN210 2334 $LN211"
	strings:
		$1 = { 8B FF 53 8B DC 83 EC 08 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 53 51 81 EC 34 03 00 00 A1 ?? ?? ?? ?? 31 45 F8 33 C5 89 45 DC 56 57 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 85 84 FD FF FF 00 00 00 00 C7 85 B0 FD FF FF FF FF FF FF C6 85 F4 FD FF FF 00 C6 85 F6 FD FF FF 00 C6 85 E3 FD FF FF 00 C7 85 6C FD FF FF 00 00 00 00 C7 85 04 FE FF FF 00 00 00 00 C7 85 E8 FD FF FF 00 00 00 00 C7 85 68 FD FF FF 00 00 00 00 C7 85 8C FD FF FF 00 00 00 00 C7 85 C0 FD FF FF 00 00 00 00 C7 85 88 FD FF FF 00 00 00 00 C7 85 C8 FD FF FF 00 00 00 00 C7 85 D8 FD FF FF 00 00 00 00 8B 43 0C 8B 08 89 8D E0 FC FF FF 8B 95 E0 FC FF FF 83 C2 14 89 95 2C FD FF FF B8 04 00 00 00 6B C8 00 8B 95 2C FD FF FF 83 3C 0A 00 74 35 B8 04 00 00 00 6B C8 00 8B 95 2C FD FF FF 8B 04 0A 50 8B 4B 10 89 8D 28 FD FF FF 8B 8D 28 FD FF FF FF 15 ?? ?? ?? ?? FF 95 28 FD FF FF 83 C4 04 E9 15 20 00 00 8B 53 0C 8B 42 04 89 85 E4 FD FF FF 8B 8D E4 FD FF FF 8B 11 81 E2 20 00 01 00 81 FA 20 00 01 00 74 30 33 C0 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 B0 03 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 E9 C5 1F 00 00 EB 36 BA 01 00 00 00 6B C2 00 8B 8D E4 FD FF FF 8D 94 01 CC 00 00 00 89 95 C4 FD FF FF B8 10 00 00 00 6B C8 00 8B 95 C4 FD FF FF 8D 84 0A A0 00 00 00 89 85 E8 FC FF FF 8B 8D C4 FD FF FF 8B 51 10 89 95 BC FC FF FF C7 85 F0 FD FF FF 00 00 00 00 C7 85 8C FD FF FF 00 00 00 00 C6 85 0E FE FF FF 00 C7 45 FC 00 00 00 00 C6 85 EF FD FF FF 01 C6 85 0F FE FF FF 00 C6 85 F5 FD FF FF 00 8A 85 F5 FD FF FF 88 85 EE FD FF FF 8B 8D E4 FD FF FF 8B 91 B8 00 00 00 89 95 F8 FD FF FF 0F B6 85 EF FD FF FF 85 C0 0F 84 48 03 00 00 8B 8D F8 FD FF FF 8A 11 88 95 F4 FD FF FF 8B 85 F8 FD FF FF 83 C0 01 89 85 F8 FD FF FF 0F B6 8D F4 FD FF FF 89 8D AC FD FF FF 8B 95 AC FD FF FF 83 EA 26 89 95 AC FD FF FF 81 BD AC FD FF FF CD 00 00 00 0F 87 F3 02 00 00 8B 85 AC FD FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? C6 85 0F FE FF FF 01 8B 95 E8 FD FF FF 83 C2 01 89 95 E8 FD FF FF E9 CB 02 00 00 C7 85 F0 FD FF FF 01 00 00 00 8B 85 E8 FD FF FF 83 C0 01 89 85 E8 FD FF FF E9 AD 02 00 00 C6 85 0F FE FF FF 01 C7 85 F0 FD FF FF 01 00 00 00 8B 8D E8 FD FF FF 83 C1 01 89 8D E8 FD FF FF E9 88 02 00 00 C6 85 0E FE FF FF 01 E9 7C 02 00 00 C6 85 F5 FD FF FF 01 8B 95 F8 FD FF FF 8A 02 88 85 FF FD FF FF 8B 8D F8 FD FF FF 83 C1 01 89 8D F8 FD FF FF 8B 95 F8 FD FF FF 8A 02 88 85 F7 FD FF FF 8B 8D F8 FD FF FF 83 C1 01 89 8D F8 FD FF FF 0F B6 95 F7 FD FF FF 83 E2 03 83 FA 01 75 0A C7 85 F0 FD FF FF 01 00 00 00 0F B6 85 F7 FD FF FF 83 E0 03 83 F8 02 75 07 C6 85 0F FE FF FF 01 0F B6 8D F7 FD FF FF 83 E1 03 83 F9 03 75 11 C6 85 0F FE FF FF 01 C7 85 F0 FD FF FF 01 00 00 00 0F B6 95 F7 FD FF FF 83 E2 04 74 0C C7 85 24 FD FF FF 01 00 00 00 EB 0A C7 85 24 FD FF FF 00 00 00 00 8A 85 24 FD FF FF 88 85 E3 FD FF FF 0F B6 8D F7 FD FF FF C1 F9 03 83 E1 0F 83 F1 0F 89 8D 6C FD FF FF 0F B6 95 F7 FD FF FF C1 FA 07 89 95 B8 FC FF FF 0F B6 85 FF FD FF FF 83 E0 0F 89 85 D8 FC FF FF 8B 8D D8 FC FF FF 89 8D 70 FD FF FF 83 BD 70 FD FF FF 01 74 14 83 BD 70 FD FF FF 02 74 14 83 BD 70 FD FF FF 03 74 14 EB 1B C6 85 F6 FD FF FF 0F EB 55 C6 85 F6 FD FF FF 38 EB 4C C6 85 F6 FD FF FF 3A EB 43 33 D2 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 2C 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 85 CC FC FF FF 00 00 00 00 C7 45 FC FE FF FF FF 8B 85 CC FC FF FF E9 D8 1C 00 00 8B 8D E8 FD FF FF 83 C1 02 89 8D E8 FD FF FF C6 85 EF FD FF FF 00 E9 E6 00 00 00 C6 85 EE FD FF FF 01 8B 95 F8 FD FF FF 8A 02 88 85 FF FD FF FF 8B 8D F8 FD FF FF 83 C1 01 89 8D F8 FD FF FF 0F B6 95 FF FD FF FF 83 E2 03 83 FA 01 75 0A C7 85 F0 FD FF FF 01 00 00 00 0F B6 85 FF FD FF FF 83 E0 03 83 F8 02 75 07 C6 85 0F FE FF FF 01 0F B6 8D FF FD FF FF 83 E1 03 83 F9 03 75 11 C6 85 0F FE FF FF 01 C7 85 F0 FD FF FF 01 00 00 00 0F B6 95 FF FD FF FF 83 E2 04 74 0C C7 85 64 FD FF FF 01 00 00 00 EB 0A C7 85 64 FD FF FF 00 00 00 00 8A 85 64 FD FF FF 88 85 E3 FD FF FF 0F B6 8D FF FD FF FF C1 F9 03 83 E1 0F 83 F1 0F 89 8D 6C FD FF FF C6 85 F6 FD FF FF 0F 8B 95 E8 FD FF FF 83 C2 01 89 95 E8 FD FF FF C6 85 EF FD FF FF 00 EB 10 C6 85 0E FE FF FF 01 EB 07 C6 85 EF FD FF FF 00 E9 A9 FC FF FF C7 45 FC FE FF FF FF E9 89 00 00 00 8B 5D E4 8B 45 EC 8B 08 8B 11 89 95 C8 FC FF FF 81 BD C8 FC FF FF 05 00 00 C0 75 0C C7 85 60 FD FF FF 01 00 00 00 EB 0A C7 85 60 FD FF FF 00 00 00 00 8B 85 60 FD FF FF C3 8B 5D E4 8B 65 E8 33 C0 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 5F 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 85 C4 FC FF FF 00 00 00 00 C7 45 FC FE FF FF FF 8B 85 C4 FC FF FF E9 44 1B 00 00 C7 45 FC FE FF FF FF 0F B6 95 0E FE FF FF 85 D2 74 2E 33 C0 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 6A 04 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 33 C0 E9 04 1B 00 00 C7 45 FC 01 00 00 00 8B 95 F8 FD FF FF 89 95 DC FD FF FF 8B 85 DC FD FF FF 8B 08 83 E1 0F 89 8D A0 FD FF FF 8B 95 DC FD FF FF 8B 02 C1 E8 04 83 E0 0F 89 85 A4 FD FF FF 0F B6 8D EE FD FF FF 85 C9 75 0B 0F B6 95 F5 FD FF FF 85 D2 74 34 0F B6 85 F6 FD FF FF 83 F8 0F 74 1A C7 85 A4 FD FF FF 03 00 00 00 0F B6 8D F6 FD FF FF 83 E1 0F 89 8D A0 FD FF FF 8B 95 6C FD FF FF 89 95 C0 FD FF FF EB 2C 8B 85 DC FD FF FF 8B 08 C1 E9 0B 83 E1 07 89 8D C0 FD FF FF 0F B6 95 F4 FD FF FF 83 FA 0F 74 0C C6 85 0E FE FF FF 01 E9 99 07 00 00 8B 85 A4 FD FF FF 89 85 A8 FD FF FF 8B 8D A8 FD FF FF 83 E9 02 89 8D A8 FD FF FF 83 BD A8 FD FF FF 0C 0F 87 5D 01 00 00 8B 95 A8 FD FF FF FF 24 95 ?? ?? ?? ?? C7 85 CC FD FF FF ?? ?? ?? ?? E9 4D 01 00 00 C7 85 CC FD FF FF ?? ?? ?? ?? E9 3E 01 00 00 C7 85 CC FD FF FF ?? ?? ?? ?? E9 2F 01 00 00 C7 85 CC FD FF FF ?? ?? ?? ?? E9 20 01 00 00 C7 85 CC FD FF FF ?? ?? ?? ?? 0F B6 85 0F FE FF FF 85 C0 74 0A C7 85 F0 FD FF FF 00 00 00 00 E9 FC 00 00 00 C7 85 CC FD FF FF ?? ?? ?? ?? 0F B6 8D 0F FE FF FF 85 C9 74 0A C7 85 F0 FD FF FF 00 00 00 00 E9 D8 00 00 00 83 BD A0 FD FF FF 0A 0F 85 B1 00 00 00 C7 85 8C FD FF FF 01 00 00 00 0F B6 95 EE FD FF FF 0F B6 85 F5 FD FF FF 0B D0 75 1E 8B 8D F8 FD FF FF 83 C1 01 89 8D F8 FD FF FF 8B 95 E8 FD FF FF 83 C2 01 89 95 E8 FD FF FF 8B 85 F8 FD FF FF 89 85 DC FD FF FF 8B 8D DC FD FF FF 8B 11 83 E2 0F 89 95 A0 FD FF FF 8B 85 DC FD FF FF 8B 08 C1 E9 04 83 E1 0F 89 8D A4 FD FF FF 8B 95 A4 FD FF FF 89 95 5C FD FF FF 83 BD 5C FD FF FF 00 74 0B 83 BD 5C FD FF FF 04 74 0E EB 18 C7 85 CC FD FF FF ?? ?? ?? ?? EB 18 C7 85 CC FD FF FF ?? ?? ?? ?? EB 0C C6 85 0E FE FF FF 01 E9 24 06 00 00 EB 0C C6 85 0E FE FF FF 01 E9 16 06 00 00 EB 0C C6 85 0E FE FF FF 01 E9 08 06 00 00 8B 85 DC FD FF FF 8B 08 C1 E9 0E 83 E1 03 83 F9 03 75 0C C7 85 58 FD FF FF 00 00 00 00 EB 0A C7 85 58 FD FF FF 01 00 00 00 8A 95 58 FD FF FF 88 95 D3 FD FF FF 0F B6 85 D3 FD FF FF C1 E0 04 0B 85 A0 FD FF FF 89 85 08 FE FF FF 83 BD 08 FE FF FF 20 76 0C C6 85 0E FE FF FF 01 E9 A8 05 00 00 83 BD 8C FD FF FF 01 0F 85 39 01 00 00 8B 8D 08 FE FF FF 8B 95 CC FD FF FF 8D 04 8A 89 85 04 FE FF FF 8B 8D 04 FE FF FF 8B 11 81 E2 FF 0F 00 00 83 FA 6B 74 25 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 83 F9 6C 74 12 8B 95 04 FE FF FF 8B 02 25 FF 0F 00 00 83 F8 6D 75 0C C7 85 F0 FD FF FF 01 00 00 00 EB 50 8B 8D 04 FE FF FF 8B 11 81 E2 FF 0F 00 00 83 FA 46 74 25 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 83 F9 47 74 12 8B 95 04 FE FF FF 8B 02 25 FF 0F 00 00 83 F8 48 75 0C C7 85 F0 FD FF FF 00 00 00 00 EB 0C C6 85 0E FE FF FF 01 E9 F2 04 00 00 8B 8D 04 FE FF FF 8B 11 81 E2 FF 0F 00 00 83 FA 6B 74 38 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 83 F9 46 74 25 8B 95 04 FE FF FF 8B 02 25 FF 0F 00 00 83 F8 6D 74 13 8B 8D 04 FE FF FF 8B 11 81 E2 FF 0F 00 00 83 FA 48 75 09 C6 85 0F FE FF FF 00 EB 3A 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 83 F9 6C 74 12 8B 95 04 FE FF FF 8B 02 25 FF 0F 00 00 83 F8 47 75 09 C6 85 0F FE FF FF 01 EB 0C C6 85 0E FE FF FF 01 E9 64 04 00 00 EB 1E 8B 8D 08 FE FF FF 8B 95 F0 FD FF FF 8D 04 4A 8B 8D CC FD FF FF 8D 14 81 89 95 04 FE FF FF 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 75 0E C6 85 0E FE FF FF 01 E9 28 04 00 00 EB 67 8B 95 04 FE FF FF 8B 02 C1 E8 0C 83 E0 1F 83 F8 1E 75 54 0F B6 8D 0F FE FF FF 85 C9 74 1D 8B 95 04 FE FF FF 8B 02 C1 E8 11 83 E0 1F 8D 0C 85 ?? ?? ?? ?? 89 8D 04 FE FF FF EB 1B 8B 95 04 FE FF FF 8B 02 C1 E8 11 83 E0 1F 8D 0C 85 ?? ?? ?? ?? 89 8D 04 FE FF FF C6 85 0F FE FF FF 00 C7 85 F0 FD FF FF 02 00 00 00 8B 95 04 FE FF FF 8B 02 25 FF 0F 00 00 83 F8 43 74 26 8B 8D 04 FE FF FF 8B 11 81 E2 FF 0F 00 00 83 FA 44 74 13 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 83 F9 45 75 07 C6 85 0F FE FF FF 00 8B 95 04 FE FF FF 8B 02 25 FF 0F 00 00 83 F8 68 74 26 8B 8D 04 FE FF FF 8B 11 81 E2 FF 0F 00 00 83 FA 69 74 13 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 83 F9 6A 75 0A C7 85 F0 FD FF FF 01 00 00 00 83 BD 8C FD FF FF 00 75 1E 8B 95 04 FE FF FF 8B 02 25 FF 0F 00 00 0F B6 8D 0F FE FF FF 03 C1 89 85 38 FE FF FF EB 13 8B 95 04 FE FF FF 8B 02 25 FF 0F 00 00 89 85 38 FE FF FF 0F B6 8D EE FD FF FF 85 C9 75 0B 0F B6 95 F5 FD FF FF 85 D2 74 54 8B 85 04 FE FF FF 8B 08 81 E1 FF 0F 00 00 89 8D 9C FD FF FF 8B 95 9C FD FF FF 83 EA 33 89 95 9C FD FF FF 83 BD 9C FD FF FF 38 77 28 8B 85 9C FD FF FF 0F B6 88 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 95 DC FD FF FF 8B 02 C1 E8 0B 83 E0 07 89 85 C0 FD FF FF 8B 8D E8 FD FF FF 83 C1 03 89 8D E8 FD FF FF C7 85 C8 FD FF FF 00 00 00 00 0F B6 95 E3 FD FF FF 85 D2 0F 84 80 01 00 00 8B 85 E4 FD FF FF 8B 08 81 E1 40 00 01 00 81 F9 40 00 01 00 0F 85 66 01 00 00 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 43 33 C0 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 C4 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 85 F4 FC FF FF 00 00 00 00 C7 45 FC FE FF FF FF 8B 85 F4 FC FF FF E9 C6 14 00 00 E8 ?? ?? ?? ?? 89 85 F8 FC FF FF 89 95 FC FC FF FF 8B 95 F8 FC FF FF 83 E2 04 8B 85 FC FC FF FF 83 E0 00 89 95 D0 FC FF FF 89 85 D4 FC FF FF 8B 8D D0 FC FF FF 0B 8D D4 FC FF FF 75 43 33 D2 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 CF 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 85 F0 FC FF FF 00 00 00 00 C7 45 FC FE FF FF FF 8B 85 F0 FC FF FF E9 46 14 00 00 8D 8D F8 FC FF FF 51 8B 95 E4 FD FF FF 52 E8 ?? ?? ?? ?? 85 C0 75 43 33 C0 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 D9 05 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 85 EC FC FF FF 00 00 00 00 C7 45 FC FE FF FF FF 8B 85 EC FC FF FF E9 EC 13 00 00 8D 95 B4 FC FF FF 52 6A 01 8B 85 E4 FD FF FF 50 E8 ?? ?? ?? ?? 89 85 D8 FD FF FF 6A 00 6A 02 8B 8D E4 FD FF FF 51 E8 ?? ?? ?? ?? 89 85 C8 FD FF FF C7 85 88 FD FF FF 02 00 00 00 EB 16 8B 95 E8 FC FF FF 89 95 D8 FD FF FF C7 85 88 FD FF FF 01 00 00 00 0F B6 85 D3 FD FF FF 85 C0 74 7C 8B 8D DC FD FF FF 89 8D F8 FD FF FF 8B 95 F8 FD FF FF 83 C2 01 89 95 F8 FD FF FF 8B 85 F8 FD FF FF 8A 08 88 8D F4 FD FF FF 8B 95 F8 FD FF FF 83 C2 01 89 95 F8 FD FF FF 8B 85 F8 FD FF FF 50 8B 8D E4 FD FF FF 51 8D 95 84 FD FF FF 52 0F B6 85 F4 FD FF FF 8B 0C 85 ?? ?? ?? ?? 89 8D 54 FD FF FF 8B 8D 54 FD FF FF FF 15 ?? ?? ?? ?? FF 95 54 FD FF FF 83 C4 0C 89 85 68 FD FF FF 8B 95 E8 FD FF FF 03 95 68 FD FF FF 89 95 E8 FD FF FF 8B 85 04 FE FF FF 8B 08 C1 E9 16 83 E1 07 83 F9 01 75 30 8B 95 F8 FD FF FF 03 95 68 FD FF FF 89 95 F8 FD FF FF 8B 85 F8 FD FF FF 0F B6 08 89 8D 3C FE FF FF 8B 95 E8 FD FF FF 83 C2 01 89 95 E8 FD FF FF C7 45 FC FE FF FF FF E9 89 00 00 00 8B 5D E4 8B 45 EC 8B 08 8B 11 89 95 E4 FC FF FF 81 BD E4 FC FF FF 05 00 00 C0 75 0C C7 85 50 FD FF FF 01 00 00 00 EB 0A C7 85 50 FD FF FF 00 00 00 00 8B 85 50 FD FF FF C3 8B 5D E4 8B 65 E8 33 C0 75 23 6A 00 68 ?? ?? ?? ?? 6A 00 68 19 06 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 85 C0 FC FF FF 00 00 00 00 C7 45 FC FE FF FF FF 8B 85 C0 FC FF FF E9 2F 12 00 00 C7 45 FC FE FF FF FF C7 85 B4 FD FF FF 00 00 00 00 EB 0F 8B 95 B4 FD FF FF 83 C2 01 89 95 B4 FD FF FF 8B 85 B4 FD FF FF 3B 85 88 FD FF FF 0F 8D C1 10 00 00 83 BD B4 FD FF FF 00 0F 84 F6 00 00 00 C7 85 00 FE FF FF 00 00 00 00 EB 0F 8B 8D 00 FE FF FF 83 C1 01 89 8D 00 FE FF FF 83 BD 00 FE FF FF 08 0F 8D BA 00 00 00 8B 95 00 FE FF FF C1 E2 04 8B 85 00 FE FF FF C1 E0 04 8B 8D D8 FD FF FF 8B 34 11 89 B4 05 50 FF FF FF 8B 54 11 04 89 94 05 54 FF FF FF 8B 85 00 FE FF FF C1 E0 04 8B 8D 00 FE FF FF C1 E1 04 8B 95 D8 FD FF FF 8B 74 02 08 89 B4 0D 58 FF FF FF 8B 44 02 0C 89 84 0D 5C FF FF FF 8B 8D 00 FE FF FF C1 E1 04 8B 95 00 FE FF FF C1 E2 04 8B 85 D8 FD FF FF 8B B5 C8 FD FF FF }
	condition:
		$1
}

rule file_36_3_0 {
	meta:
		name = "__CrtSetReportFile"
		size = 243
		refs = "0031 ??_C@_1FA@IFFFOLDJ@?$AAn?$AAR?$AAp?$AAt?$AAT?$AAy?$AAp?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAn?$AAR?$AAp?$AAt?$AAT?$AAy?$AAp?$AAe?$AA?5?$AA?$DM?$AA?5?$AA_?$AAC?$AAR?$AAT@ 0036 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0042 ??_C@_1GA@LFAOKOOP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAm@ 0049 __CrtDbgReportW 005d __errno 0074 ??_C@_1CE@IKKEDCME@?$AA_?$AAC?$AAr?$AAt?$AAS?$AAe?$AAt?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AAF?$AAi?$AAl?$AAe?$AA?$AA@ 007e __invalid_parameter 0098 __CrtDbgFile 00b5 __imp__GetStdHandle@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 83 7D 08 00 7C 0F 83 7D 08 03 7D 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FE FF FF FF EB 63 83 7D 0C FA 75 0C 8B 55 08 8B 04 95 ?? ?? ?? ?? EB 51 8B 45 08 8B 0C 85 ?? ?? ?? ?? 89 4D F4 83 7D 0C FC 75 14 6A F5 FF 15 ?? ?? ?? ?? 8B 55 08 89 04 95 ?? ?? ?? ?? EB 27 83 7D 0C FB 75 14 6A F4 FF 15 ?? ?? ?? ?? 8B 4D 08 89 04 8D ?? ?? ?? ?? EB 0D 8B 55 08 8B 45 0C 89 04 95 ?? ?? ?? ?? 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_4_0 {
	meta:
		name = "__CrtSetReportHook"
		size = 30
		refs = "0007 __pfnReportHook"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_185_31_0 {
	meta:
		name = "__CrtSetAllocHook"
		size = 30
		refs = "0007 __pfnAllocHook"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_185_32_0 {
	meta:
		name = "__CrtSetBreakAlloc"
		size = 30
		refs = "0007 __crtBreakAlloc"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_64_1_3 {
	meta:
		name = "__CrtSetDebugFillThreshold"
		size = 30
		refs = "0007 ?__acrt_debug_fill_threshold@@3IA"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_185_35_2 {
	meta:
		name = "__CrtSetDumpClient"
		size = 30
		refs = "0007 __pfnDumpClient"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_388_0_2 {
	meta:
		name = "___setfflag"
		size = 30
		refs = "0007 ___fastflag"
	strings:
		$1 = { 8B FF 55 8B EC 51 A1 ?? ?? ?? ?? 89 45 FC 8B 4D 08 89 0D ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_5_0 {
	meta:
		name = "__CrtSetReportMode"
		size = 312
		refs = "0031 ??_C@_1FA@IFFFOLDJ@?$AAn?$AAR?$AAp?$AAt?$AAT?$AAy?$AAp?$AAe?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAn?$AAR?$AAp?$AAt?$AAT?$AAy?$AAp?$AAe?$AA?5?$AA?$DM?$AA?5?$AA_?$AAC?$AAR?$AAT@ 0036 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 003f ??_C@_1GA@LFAOKOOP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAm@ 0046 __CrtDbgReportW 005a __errno 006e ??_C@_1CE@FIHIECNJ@?$AA_?$AAC?$AAr?$AAt?$AAS?$AAe?$AAt?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AAM?$AAo?$AAd?$AAe?$AA?$AA@ 0078 __invalid_parameter 00b2 ??_C@_1NK@LOFHIHFC@?$AAf?$AAM?$AAo?$AAd?$AAe?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA_?$AAC?$AAR?$AAT?$AAD?$AAB?$AAG?$AA_?$AAR?$AAE?$AAP?$AAO?$AAR?$AAT?$AA_?$AAM?$AAO?$AAD?$AAE?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 0111 __CrtDbgMode"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 83 7D 08 00 7C 0F 83 7D 08 03 7D 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 5A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 AD 00 00 00 83 7D 0C FF 74 11 8B 55 0C 83 E2 F8 74 09 C7 45 F4 00 00 00 00 EB 07 C7 45 F4 01 00 00 00 8B 45 F4 89 45 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 5F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2F 83 7D 0C FF 75 0C 8B 55 08 8B 04 95 ?? ?? ?? ?? EB 1D 8B 45 08 8B 0C 85 ?? ?? ?? ?? 89 4D EC 8B 55 08 8B 45 0C 89 04 95 ?? ?? ?? ?? 8B 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_6_0 {
	meta:
		name = "__VCrtDbgReportA"
		size = 2202
		refs = "0008 __sehtable$__VCrtDbgReportA 000d __except_handler4 0021 __chkstk 0026 ___security_cookie 0069 _memset 00f7 __crtAssertBusy 010c ??_C@_1GA@LFAOKOOP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAm@ 0111 ??_C@_1CA@KHJHLKA@?$AA_?$AAV?$AAC?$AAr?$AAt?$AAD?$AAb?$AAg?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AAA?$AA?$AA@ 0116 ??_C@_1FA@JPHJBHEM@?$AA_?$AAi?$AAt?$AAo?$AAa?$AA_?$AAs?$AA?$CI?$AAn?$AAL?$AAi?$AAn?$AAe?$AA?0?$AA?5?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0@ 012d __itoa_s 0136 __invoke_watson_if_error 013e ??_C@_0CG@BNGLOCEO@Second?5Chance?5Assertion?5Failed?3?5@ 0144 __imp__OutputDebugStringA@4 015f ??_C@_0P@DFJNDPOP@?$DMfile?5unknown?$DO?$AA@ 0171 ??_C@_07BHGABMGB@?0?5Line?5?$AA@ 0189 ??_C@_01EEMJAFIK@?6?$AA@ 01b8 __errno 01e9 __vsnprintf_s 0211 ??_C@_1BI@KALLJECN@?$AA?$CI?$AA?$CK?$AA_?$AAe?$AAr?$AAr?$AAn?$AAo?$AA?$CI?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0222 __invoke_watson_if_oneof 0251 ??_C@_1JI@GAALPGBM@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAU?$AAs?$AAe?$AAr?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AA?$CC?$AA_@ 0256 ??_C@_0CL@EACFGMNB@_CrtDbgReport?3?5String?5too?5long?5o@ 0267 _strcpy_s 0289 ??_C@_0BD@CAENFOHP@Assertion?5failed?3?5?$AA@ 0295 ??_C@_0BC@LAIDCHCH@Assertion?5failed?$CB?$AA@ 02ab ??_C@_1KK@GIGAEDMO@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAs?$AAz@ 02e5 ??_C@_1FK@NPGBPOFO@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAs?$AAz@ 02fd _strcat_s 0319 __CrtDbgMode 0334 ??_C@_1EI@CACDLAFK@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AA?$CC?$AA?2@ 0339 ??_C@_01LIIJDEN@?$AN?$AA@ 036c ??_C@_1EI@LDHJEDO@?$AAs?$AAt?$AAr?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AA?$CC?$AA?2@ 03ce ??_C@_0M@IPILFDFN@?$CFs?$CI?$CFd?$CJ?5?3?5?$CFs?$AA@ 03e4 __snprintf_s 044c ??_C@_1JG@CPKCIOEE@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AA?$CC?$AA_?$AAC@ 0486 ??_C@_1FI@IBIOIHEG@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAs?$AAz?$AAL@ 04df _mbstowcs_s 04fe ??_C@_1IM@OOKIFKOH@?$AAe?$AA?5?$AA?$DN?$AA?5?$AAm?$AAb?$AAs?$AAt?$AAo?$AAw?$AAc?$AAs?$AA_?$AAs?$AA?$CI?$AA?$CG?$AAr?$AAe?$AAt?$AA?0?$AA?5?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg@ 0530 ??_C@_1MC@IGEECMDB@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA2?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAL?$AA?$CC@ 0535 ??_C@_1HO@PJOFIKFE@?$AA_?$AAC?$AAr?$AAt?$AAD?$AAb?$AAg?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AA?3?$AA?5?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAl?$AAo?$AAn?$AAg?$AA?5?$AAo@ 0546 _wcscpy_s 0558 __pReportHookList 0561 __pReportHookListW 0583 ___acrt_lock 05ea ___guard_check_icall_fptr 06ad ___acrt_unlock 06c5 __pfnReportHook 0733 __CrtDbgFile 0755 _strlen 0771 __imp__WriteFile@20 07c1 ___report_rangecheckfailure 084f ___acrt_MessageWindowA 0892 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 B8 58 50 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 31 45 F8 33 C5 89 45 E4 53 56 57 50 8D 45 F0 64 A3 00 00 00 00 C7 85 E0 AF FF FF 00 00 00 00 C7 85 C8 AF FF FF 00 00 00 00 C6 85 E4 EF FF FF 00 68 FF 0F 00 00 6A 00 8D 85 E5 EF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C C6 85 E4 DF FF FF 00 68 FF 0F 00 00 6A 00 8D 8D E5 DF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 66 89 95 E4 AF FF FF 68 FE 1F 00 00 6A 00 8D 85 E6 AF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C C6 85 E4 CF FF FF 00 68 FF 0F 00 00 6A 00 8D 8D E5 CF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 08 00 7C 06 83 7D 08 03 7C 08 83 C8 FF E9 A1 07 00 00 C7 45 FC 00 00 00 00 83 7D 08 02 0F 85 B5 00 00 00 BA 01 00 00 00 F0 0F C1 15 ?? ?? ?? ?? 42 85 D2 0F 8E 9F 00 00 00 6A 00 68 FF 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 0A 68 00 10 00 00 8D 85 E4 EF FF FF 50 8B 4D 14 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 7D 10 00 74 0B 8B 55 10 89 95 C4 AF FF FF EB 0A C7 85 C4 AF FF FF ?? ?? ?? ?? 8B 85 C4 AF FF FF 50 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8D 8D E4 EF FF FF 51 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? CC C7 85 E0 AF FF FF FF FF FF FF E9 B9 06 00 00 83 7D 1C 00 0F 84 CA 00 00 00 C7 85 D4 AF FF FF 00 00 00 00 E8 ?? ?? ?? ?? 8B 10 89 95 9C AF FF FF E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 45 20 50 8B 4D 1C 51 68 EB 0F 00 00 68 00 10 00 00 8D 95 E4 CF FF FF 52 E8 ?? ?? ?? ?? 83 C4 14 89 85 D4 AF FF FF 83 BD D4 AF FF FF 00 7D 2A 6A 00 68 12 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 E8 ?? ?? ?? ?? 8B 00 50 E8 ?? ?? ?? ?? 83 C4 20 E8 ?? ?? ?? ?? 8B 8D 9C AF FF FF 89 08 83 BD D4 AF FF FF 00 7D 38 6A 00 68 15 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 95 E4 CF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 08 02 75 56 83 7D 1C 00 74 0C C7 85 C0 AF FF FF ?? ?? ?? ?? EB 0A C7 85 C0 AF FF FF ?? ?? ?? ?? 6A 00 68 1B 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 85 C0 AF FF FF 50 68 00 10 00 00 8D 8D E4 EF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 1E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 E4 CF FF FF 52 68 00 10 00 00 8D 85 E4 EF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 08 02 75 7F 8B 4D 08 8B 14 8D ?? ?? ?? ?? 83 E2 01 74 38 6A 00 68 24 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 85 E4 EF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 27 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 8D E4 EF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 10 00 0F 84 D8 00 00 00 C7 85 D0 AF FF FF 00 00 00 00 E8 ?? ?? ?? ?? 8B 10 89 95 98 AF FF FF E8 ?? ?? ?? ?? C7 00 00 00 00 00 8D 85 E4 EF FF FF 50 8B 4D 14 51 8B 55 10 52 68 ?? ?? ?? ?? 68 FF 0F 00 00 68 00 10 00 00 8D 85 E4 DF FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 85 D0 AF FF FF 83 BD D0 AF FF FF 00 7D 2A 6A 00 68 2E 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 E8 ?? ?? ?? ?? 8B 08 51 E8 ?? ?? ?? ?? 83 C4 20 E8 ?? ?? ?? ?? 8B 95 98 AF FF FF 89 10 83 BD D0 AF FF FF 00 7D 38 6A 00 68 31 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 85 E4 DF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 3A 6A 00 68 36 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D E4 EF FF FF 51 68 00 10 00 00 8D 95 E4 DF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 C7 85 94 AF FF FF 00 00 00 00 C7 85 CC AF FF FF 00 00 00 00 6A FF 8D 85 E4 DF FF FF 50 68 00 10 00 00 8D 8D E4 AF FF FF 51 8D 95 94 AF FF FF 52 E8 ?? ?? ?? ?? 83 C4 14 89 85 CC AF FF FF 6A 00 68 3C 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 8B 85 CC AF FF FF 50 E8 ?? ?? ?? ?? 83 C4 20 83 BD CC AF FF FF 00 74 38 6A 00 68 3F 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 8D E4 AF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 3D ?? ?? ?? ?? 00 75 0D 83 3D ?? ?? ?? ?? 00 0F 84 49 01 00 00 C7 85 DC AF FF FF 00 00 00 00 C7 85 D8 AF FF FF 00 00 00 00 6A 01 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 01 00 00 00 8B 15 ?? ?? ?? ?? 89 95 DC AF FF FF EB 0F 8B 85 DC AF FF FF 8B 48 04 89 8D DC AF FF FF 83 BD DC AF FF FF 00 74 61 C7 85 B8 AF FF FF 00 00 00 00 8D 95 B8 AF FF FF 52 8D 85 E4 DF FF FF 50 8B 4D 08 51 8B 95 DC AF FF FF 8B 42 0C 89 85 BC AF FF FF 8B 8D BC AF FF FF FF 15 ?? ?? ?? ?? FF 95 BC AF FF FF 83 C4 0C 85 C0 74 1B C7 85 C8 AF FF FF 01 00 00 00 8B 8D B8 AF FF FF 89 8D E0 AF FF FF E9 86 00 00 00 EB 87 8B 15 ?? ?? ?? ?? 89 95 D8 AF FF FF EB 0F 8B 85 D8 AF FF FF 8B 48 04 89 8D D8 AF FF FF 83 BD D8 AF FF FF 00 74 5E C7 85 B0 AF FF FF 00 00 00 00 8D 95 B0 AF FF FF 52 8D 85 E4 AF FF FF 50 8B 4D 08 51 8B 95 D8 AF FF FF 8B 42 0C 89 85 B4 AF FF FF 8B 8D B4 AF FF FF FF 15 ?? ?? ?? ?? FF 95 B4 AF FF FF 83 C4 0C 85 C0 74 18 C7 85 C8 AF FF FF 01 00 00 00 8B 8D B0 AF FF FF 89 8D E0 AF FF FF EB 02 EB 8A C7 45 FC 00 00 00 00 E8 02 00 00 00 EB 0B 6A 01 E8 ?? ?? ?? ?? 83 C4 04 C3 83 BD C8 AF FF FF 00 74 05 E9 99 01 00 00 83 3D ?? ?? ?? ?? 00 74 52 C7 85 A8 AF FF FF 00 00 00 00 8D 95 A8 AF FF FF 52 8D 85 E4 DF FF FF 50 8B 4D 08 51 8B 15 ?? ?? ?? ?? 89 95 AC AF FF FF 8B 8D AC AF FF FF FF 15 ?? ?? ?? ?? FF 95 AC AF FF FF 83 C4 0C 85 C0 74 11 8B 85 A8 AF FF FF 89 85 E0 AF FF FF E9 3E 01 00 00 8B 4D 08 8B 14 8D ?? ?? ?? ?? 83 E2 01 74 48 8B 45 08 83 3C 85 ?? ?? ?? ?? FF 74 3B C7 85 90 AF FF FF 00 00 00 00 6A 00 8D 8D 90 AF FF FF 51 8D 95 E4 DF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 85 E4 DF FF FF 50 8B 4D 08 8B 14 8D ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B 45 08 8B 0C 85 ?? ?? ?? ?? 83 E1 02 74 0D 8D 95 E4 DF FF FF 52 FF 15 ?? ?? ?? ?? 8B 45 08 8B 0C 85 ?? ?? ?? ?? 83 E1 04 0F 84 B8 00 00 00 BA 01 00 00 00 6B C2 00 89 85 A4 AF FF FF 81 BD A4 AF FF FF 00 10 00 00 73 02 EB 05 E8 ?? ?? ?? ?? 8B 8D A4 AF FF FF C6 84 0D E4 EF FF FF 00 83 7D 14 00 74 39 6A 00 68 8C 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 0A 68 00 10 00 00 8D 95 E4 EF FF FF 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 14 00 74 0E 8D 8D E4 EF FF FF 89 8D A0 AF FF FF EB 0A C7 85 A0 AF FF FF 00 00 00 00 8D 95 E4 CF FF FF 52 8B 45 18 50 8B 8D A0 AF FF FF 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 89 85 E0 AF FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0E 83 7D 08 02 75 07 F0 FF 0D ?? ?? ?? ?? C3 8B 85 E0 AF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B 4D E4 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_7_0 {
	meta:
		name = "__VCrtDbgReportW"
		size = 2509
		refs = "0008 __sehtable$__VCrtDbgReportW 000d __except_handler4 0021 __chkstk 0026 ___security_cookie 006b _memset 00fb __crtAssertBusy 0110 ??_C@_1GA@LFAOKOOP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAm@ 0115 ??_C@_1CA@HPALHDOD@?$AA_?$AAV?$AAC?$AAr?$AAt?$AAD?$AAb?$AAg?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AAW?$AA?$AA@ 011a ??_C@_1FA@CNLLOMHI@?$AA_?$AAi?$AAt?$AAo?$AAw?$AA_?$AAs?$AA?$CI?$AAn?$AAL?$AAi?$AAn?$AAe?$AA?0?$AA?5?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0@ 0131 __itow_s 013a __invoke_watson_if_error 0142 ??_C@_1EM@MJFLEDMB@?$AAS?$AAe?$AAc?$AAo?$AAn?$AAd?$AA?5?$AAC?$AAh?$AAa?$AAn?$AAc?$AAe?$AA?5?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAF?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?3?$AA?5@ 0148 __imp__OutputDebugStringW@4 0163 ??_C@_1BO@OCHMLCAG@?$AA?$DM?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAu?$AAn?$AAk?$AAn?$AAo?$AAw?$AAn?$AA?$DO?$AA?$AA@ 0175 ??_C@_1BA@ELMMDCFC@?$AA?0?$AA?5?$AAL?$AAi?$AAn?$AAe?$AA?5?$AA?$AA@ 018d ??_C@_13LBAGMAIH@?$AA?6?$AA?$AA@ 01d0 __errno 0207 ___stdio_common_vsnwprintf_s 022f ??_C@_1BI@KALLJECN@?$AA?$CI?$AA?$CK?$AA_?$AAe?$AAr?$AAr?$AAn?$AAo?$AA?$CI?$AA?$CJ?$AA?$CJ?$AA?$AA@ 0240 __invoke_watson_if_oneof 026f ??_C@_1JK@KHFABAEO@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAU?$AAs?$AAe?$AAr?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAL?$AA?$CC@ 0274 ??_C@_1FG@BBOLDHGF@?$AA_?$AAC?$AAr?$AAt?$AAD?$AAb?$AAg?$AAR?$AAe?$AAp?$AAo?$AAr?$AAt?$AA?3?$AA?5?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAl?$AAo?$AAn?$AAg?$AA?5?$AAo@ 0285 _wcscpy_s 02a7 ??_C@_1CG@FFFGGODN@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?3?$AA?5?$AA?$AA@ 02b3 ??_C@_1CE@OJBNHDMO@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?$CB?$AA?$AA@ 02c9 ??_C@_1KO@DGAHENCH@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAs?$AAz@ 0303 ??_C@_1FK@HPADHBBD@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAs?$AAz@ 031b _wcscat_s 0337 __CrtDbgMode 0352 ??_C@_1EK@NMDFGHMF@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAL?$AA?$CC@ 0357 ??_C@_13CMNBPIDO@?$AA?$AN?$AA?$AA@ 038a ??_C@_1EK@PHCBEDKB@?$AAw?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAL?$AAi?$AAn?$AAe?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAL?$AA?$CC@ 03ec ??_C@_1BM@GIBPMLNL@?$AA?$CF?$AAl?$AAs?$AA?$CI?$AA?$CF?$AAd?$AA?$CJ?$AA?5?$AA?3?$AA?5?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0402 __snwprintf_s 046a ??_C@_1JI@EACPGHID@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAL?$AA?$CC?$AA_@ 04a4 ??_C@_1FI@DBAIJPJE@?$AAw?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AAs?$AAz?$AAL@ 04de ??_C@_1IK@LEBMBAP@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAs?$AA?$CI?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?0?$AA?5?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe@ 04fe _wcstombs_s 052f ??_C@_1MA@LBAMNNOB@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAs?$AAz?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA2?$AA?0?$AA?5?$AA4?$AA0?$AA9?$AA6?$AA?0?$AA?5?$AA?$CC?$AA_@ 0534 ??_C@_0DP@GNPEPHJD@_CrtDbgReport?3?5String?5too?5long?5o@ 0545 _strcpy_s 0557 __pReportHookList 0560 __pReportHookListW 0582 ___acrt_lock 05e8 ___guard_check_icall_fptr 06aa ___acrt_unlock 06c2 __pfnReportHook 0733 __CrtDbgFile 074b __imp__GetFileType@4 077b _wcslen 0797 __imp__WriteConsoleW@20 07a6 __imp__GetLastError@0 07d0 ??_C@_1IE@CPGKIAGP@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAs?$AA?$CI?$AA?$CG?$AAr?$AAe?$AAt?$AA?0?$AA?5?$AAs?$AAz?$AAa?$AAO?$AAu?$AAt?$AAM?$AAe?$AAs?$AAs?$AAa?$AAg?$AAe?$AA?0?$AA?5@ 0856 __imp__WriteFile@20 08f2 ___report_rangecheckfailure 0982 ___acrt_MessageWindowW 09c5 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 08 B8 70 80 00 00 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 31 45 F8 33 C5 89 45 E4 53 56 57 50 8D 45 F0 64 A3 00 00 00 00 C7 85 E0 7F FF FF 00 00 00 00 C7 85 C8 7F FF FF 00 00 00 00 33 C0 66 89 85 E4 AF FF FF 68 FE 1F 00 00 6A 00 8D 8D E6 AF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 66 89 95 E4 CF FF FF 68 FE 1F 00 00 6A 00 8D 85 E6 CF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C C6 85 E4 EF FF FF 00 68 FF 0F 00 00 6A 00 8D 8D E5 EF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 33 D2 66 89 95 E4 7F FF FF 68 FE 1F 00 00 6A 00 8D 85 E6 7F FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 08 00 7C 06 83 7D 08 03 7C 08 83 C8 FF E9 D0 08 00 00 C7 45 FC 00 00 00 00 83 7D 08 02 0F 85 B5 00 00 00 B9 01 00 00 00 F0 0F C1 0D ?? ?? ?? ?? 41 85 C9 0F 8E 9F 00 00 00 6A 00 68 D9 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 0A 68 00 10 00 00 8D 95 E4 AF FF FF 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 7D 10 00 74 0B 8B 4D 10 89 8D C4 7F FF FF EB 0A C7 85 C4 7F FF FF ?? ?? ?? ?? 8B 95 C4 7F FF FF 52 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8D 85 E4 AF FF FF 50 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? CC C7 85 E0 7F FF FF FF FF FF FF E9 E8 07 00 00 83 7D 1C 00 0F 84 E4 00 00 00 C7 85 7C 7F FF FF 13 00 00 00 C7 85 78 7F FF FF EB 0F 00 00 C7 85 D0 7F FF FF 00 00 00 00 E8 ?? ?? ?? ?? 8B 08 89 8D 98 7F FF FF E8 ?? ?? ?? ?? C7 00 00 00 00 00 8B 55 20 52 6A 00 8B 45 1C 50 68 EB 0F 00 00 68 00 10 00 00 8D 8D E4 7F FF FF 51 6A 00 6A 04 E8 ?? ?? ?? ?? 83 C4 20 89 85 D0 7F FF FF 83 BD D0 7F FF FF 00 7D 2A 6A 00 68 F8 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 E8 ?? ?? ?? ?? 8B 10 52 E8 ?? ?? ?? ?? 83 C4 20 E8 ?? ?? ?? ?? 8B 8D 98 7F FF FF 89 08 83 BD D0 7F FF FF 00 7D 38 6A 00 68 FB 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 95 E4 7F FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 08 02 75 56 83 7D 1C 00 74 0C C7 85 C0 7F FF FF ?? ?? ?? ?? EB 0A C7 85 C0 7F FF FF ?? ?? ?? ?? 6A 00 68 00 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 85 C0 7F FF FF 50 68 00 10 00 00 8D 8D E4 AF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 02 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 E4 7F FF FF 52 68 00 10 00 00 8D 85 E4 AF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 08 02 75 7F 8B 4D 08 8B 14 8D ?? ?? ?? ?? 83 E2 01 74 38 6A 00 68 07 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 85 E4 AF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 09 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 8D E4 AF FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 10 00 0F 84 D8 00 00 00 C7 85 CC 7F FF FF 00 00 00 00 E8 ?? ?? ?? ?? 8B 10 89 95 94 7F FF FF E8 ?? ?? ?? ?? C7 00 00 00 00 00 8D 85 E4 AF FF FF 50 8B 4D 14 51 8B 55 10 52 68 ?? ?? ?? ?? 68 00 10 00 00 68 00 10 00 00 8D 85 E4 CF FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 85 CC 7F FF FF 83 BD CC 7F FF FF 00 7D 2A 6A 00 68 11 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 E8 ?? ?? ?? ?? 8B 08 51 E8 ?? ?? ?? ?? 83 C4 20 E8 ?? ?? ?? ?? 8B 95 94 7F FF FF 89 10 83 BD CC 7F FF FF 00 7D 38 6A 00 68 13 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 85 E4 CF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 EB 3A 6A 00 68 17 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D E4 AF FF FF 51 68 00 10 00 00 8D 95 E4 CF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 6A 00 68 1C 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 6A FF 8D 85 E4 CF FF FF 50 68 00 10 00 00 8D 8D E4 EF FF FF 51 6A 00 E8 ?? ?? ?? ?? 83 C4 14 50 E8 ?? ?? ?? ?? 83 C4 20 89 85 90 7F FF FF 83 BD 90 7F FF FF 00 74 38 6A 00 68 1E 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 00 10 00 00 8D 95 E4 EF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 83 3D ?? ?? ?? ?? 00 75 0D 83 3D ?? ?? ?? ?? 00 0F 84 47 01 00 00 C7 85 DC 7F FF FF 00 00 00 00 C7 85 D8 7F FF FF 00 00 00 00 6A 01 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 01 00 00 00 A1 ?? ?? ?? ?? 89 85 DC 7F FF FF EB 0F 8B 8D DC 7F FF FF 8B 51 04 89 95 DC 7F FF FF 83 BD DC 7F FF FF 00 74 61 C7 85 B8 7F FF FF 00 00 00 00 8D 85 B8 7F FF FF 50 8D 8D E4 EF FF FF 51 8B 55 08 52 8B 85 DC 7F FF FF 8B 48 0C 89 8D BC 7F FF FF 8B 8D BC 7F FF FF FF 15 ?? ?? ?? ?? FF 95 BC 7F FF FF 83 C4 0C 85 C0 74 1B 8B 95 B8 7F FF FF 89 95 E0 7F FF FF C7 85 C8 7F FF FF 01 00 00 00 E9 85 00 00 00 EB 87 A1 ?? ?? ?? ?? 89 85 D8 7F FF FF EB 0F 8B 8D D8 7F FF FF 8B 51 04 89 95 D8 7F FF FF 83 BD D8 7F FF FF 00 74 5E C7 85 B0 7F FF FF 00 00 00 00 8D 85 B0 7F FF FF 50 8D 8D E4 CF FF FF 51 8B 55 08 52 8B 85 D8 7F FF FF 8B 48 0C 89 8D B4 7F FF FF 8B 8D B4 7F FF FF FF 15 ?? ?? ?? ?? FF 95 B4 7F FF FF 83 C4 0C 85 C0 74 18 8B 95 B0 7F FF FF 89 95 E0 7F FF FF C7 85 C8 7F FF FF 01 00 00 00 EB 02 EB 8A C7 45 FC 00 00 00 00 E8 02 00 00 00 EB 0B 6A 01 E8 ?? ?? ?? ?? 83 C4 04 C3 83 BD C8 7F FF FF 00 74 05 E9 CF 02 00 00 83 3D ?? ?? ?? ?? 00 74 51 C7 85 A8 7F FF FF 00 00 00 00 8D 85 A8 7F FF FF 50 8D 8D E4 EF FF FF 51 8B 55 08 52 A1 ?? ?? ?? ?? 89 85 AC 7F FF FF 8B 8D AC 7F FF FF FF 15 ?? ?? ?? ?? FF 95 AC 7F FF FF 83 C4 0C 85 C0 74 11 8B 8D A8 7F FF FF 89 8D E0 7F FF FF E9 75 02 00 00 8B 55 08 8B 04 95 ?? ?? ?? ?? 83 E0 01 0F 84 79 01 00 00 8B 4D 08 83 3C 8D ?? ?? ?? ?? FF 0F 84 68 01 00 00 8B 55 08 8B 04 95 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 85 8C 7F FF FF 83 BD 8C 7F FF FF 02 74 02 EB 54 C7 85 88 7F FF FF 00 00 00 00 6A 00 8D 8D 88 7F FF FF 51 8D 95 E4 CF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 8D 85 E4 CF FF FF 50 8B 4D 08 8B 14 8D ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 85 C0 74 05 E9 02 01 00 00 FF 15 ?? ?? ?? ?? 83 F8 06 74 05 E9 F2 00 00 00 C7 85 D4 7F FF FF 00 00 00 00 6A 00 68 6A 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 6A FF 8D 85 E4 CF FF FF 50 68 00 10 00 00 8D 8D E4 9F FF FF 51 8D 95 D4 7F FF FF 52 E8 ?? ?? ?? ?? 83 C4 14 50 E8 ?? ?? ?? ?? 83 C4 20 89 85 A4 7F FF FF 83 BD A4 7F FF FF 00 74 48 83 BD A4 7F FF FF 50 74 3F C7 85 84 7F FF FF 00 00 00 00 6A 00 8D 85 84 7F FF FF 50 8D 8D E4 CF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 D1 E0 50 8D 95 E4 CF FF FF 52 8B 45 08 8B 0C 85 ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? EB 4A 83 BD D4 7F FF FF 00 76 0F 8B 95 D4 7F FF FF 83 EA 01 89 95 D4 7F FF FF C7 85 80 7F FF FF 00 00 00 00 6A 00 8D 85 80 7F FF FF 50 8B 8D D4 7F FF FF 51 8D 95 E4 9F FF FF 52 8B 45 08 8B 0C 85 ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B 55 08 8B 04 95 ?? ?? ?? ?? 83 E0 02 74 0D 8D 8D E4 CF FF FF 51 FF 15 ?? ?? ?? ?? 8B 55 08 8B 04 95 ?? ?? ?? ?? 83 E0 04 0F 84 BA 00 00 00 B9 02 00 00 00 6B D1 00 89 95 A0 7F FF FF 81 BD A0 7F FF FF 00 20 00 00 73 02 EB 05 E8 ?? ?? ?? ?? 33 C0 8B 8D A0 7F FF FF 66 89 84 0D E4 AF FF FF 83 7D 14 00 74 39 6A 00 68 8A 02 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 0A 68 00 10 00 00 8D 95 E4 AF FF FF 52 8B 45 14 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 83 7D 14 00 74 0E 8D 8D E4 AF FF FF 89 8D 9C 7F FF FF EB 0A C7 85 9C 7F FF FF 00 00 00 00 8D 95 E4 7F FF FF 52 8B 45 18 50 8B 8D 9C 7F FF FF 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 89 85 E0 7F FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0E 83 7D 08 02 75 07 F0 FF 0D ?? ?? ?? ?? C3 8B 85 E0 7F FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B 4D E4 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_10_0 {
	meta:
		name = "__invoke_watson_if_oneof"
		size = 59
		refs = "0035 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 10 8B 45 08 3B 45 0C 74 0D 8B 4D 08 3B 4D 10 74 05 8B 45 08 EB 19 8B 55 24 52 8B 45 20 50 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_36_11_0 {
	meta:
		name = "__snprintf_s"
		size = 66
		refs = "0009 ??$__vcrt_va_start_verify_argument_type@QBD@@YAXXZ 002a __vsnprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 8D 45 18 89 45 FC 8B 4D FC 51 6A 00 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 F8 C7 45 FC 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_12_0 {
	meta:
		name = "__snwprintf_s"
		size = 66
		refs = "0009 ??$__vcrt_va_start_verify_argument_type@QB_W@@YAXXZ 002a __vsnwprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 8D 45 18 89 45 FC 8B 4D FC 51 6A 00 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 F8 C7 45 FC 00 00 00 00 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_13_0 {
	meta:
		name = "__vsnprintf_s"
		size = 37
		refs = "001c __vsnprintf_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 50 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_149_23_0 {
	meta:
		name = "__strftime_l"
		size = 37
		refs = "001c __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 50 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_300_36_0 {
	meta:
		name = "__wcsftime_l"
		size = 37
		refs = "001c __Wcsftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 50 6A 00 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_36_14_0 {
	meta:
		name = "__vsnprintf_s_l"
		size = 83
		refs = "0021 ___local_stdio_printf_options 002d ___stdio_common_vsnprintf_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 8B 48 04 51 8B 10 52 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 83 7D FC 00 7D 09 C7 45 F8 FF FF FF FF EB 06 8B 45 FC 89 45 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_36_15_0 {
	meta:
		name = "__vsnwprintf_s_l"
		size = 83
		refs = "0021 ___local_stdio_printf_options 002d ___stdio_common_vsnwprintf_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 8B 48 04 51 8B 10 52 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 83 7D FC 00 7D 09 C7 45 F8 FF FF FF FF EB 06 8B 45 FC 89 45 F8 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_3_0 {
	meta:
		name = "?_wcrtomb_s_l@@YAHQAHQADI_WQAU_Mbstatet@@QAU__crt_locale_pointers@@@Z"
		size = 429
		refs = "0015 ??_C@_1GA@KCKCPAEB@?$AAd?$AAe?$AAs?$AAt?$AAi?$AAn?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAd?$AAe?$AAs?$AAt?$AAi?$AAn@ 001a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0023 ??_C@_1GG@IOHNAMEK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 002a __CrtDbgReportW 003f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0047 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0064 ??_C@_1BBK@OJOCBOE@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA_?$AAu?$AAp?$AAd?$AAa?$AAt?$AAe?$AA?4?$AAG?$AAe?$AAt?$AAL?$AAo?$AAc?$AAa?$AAl?$AAe?$AAT?$AA?$CI?$AA?$CJ?$AA?9?$AA?$DO?$AAl?$AAo?$AAc?$AAi@ 00cc __errno 00e1 ??1_LocaleUpdate@@QAE@XZ 0148 __imp__WideCharToMultiByte@32"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 83 7D 0C 00 74 06 83 7D 10 00 77 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B 4D 1C 51 8D 4D D8 E8 ?? ?? ?? ?? 8D 4D D8 E8 ?? ?? ?? ?? 8B 10 83 7A 04 01 74 33 8D 4D D8 E8 ?? ?? ?? ?? 8B 00 83 78 04 02 74 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 3D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D 18 00 74 09 8B 55 18 C7 02 00 00 00 00 8D 4D D8 E8 ?? ?? ?? ?? 8B 00 B9 04 00 00 00 D1 E1 83 BC 08 A0 00 00 00 00 75 6B 0F B7 55 14 81 FA FF 00 00 00 7E 31 83 7D 08 00 74 09 8B 45 08 C7 00 FF FF FF FF E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 F4 2A 00 00 00 8D 4D D8 E8 ?? ?? ?? ?? 8B 45 F4 E9 BC 00 00 00 8B 4D 0C 8A 55 14 88 11 83 7D 08 00 74 09 8B 45 08 C7 00 01 00 00 00 C7 45 F0 00 00 00 00 8D 4D D8 E8 ?? ?? ?? ?? 8B 45 F0 E9 8E 00 00 00 C7 45 FC 00 00 00 00 8D 4D FC 51 6A 00 8B 55 10 52 8B 45 0C 50 6A 01 8D 4D 14 51 6A 00 8D 4D D8 E8 ?? ?? ?? ?? 8B 10 8B 42 08 50 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 06 83 7D FC 00 74 2E 83 7D 08 00 74 09 8B 4D 08 C7 01 FF FF FF FF E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 EC 2A 00 00 00 8D 4D D8 E8 ?? ?? ?? ?? 8B 45 EC EB 20 83 7D 08 00 74 08 8B 55 08 8B 45 F8 89 02 C7 45 E8 00 00 00 00 8D 4D D8 E8 ?? ?? ?? ?? 8B 45 E8 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_5_0 {
	meta:
		name = "_internal_wcsrtombs"
		size = 601
		refs = "0009 ___security_cookie 0035 ??_C@_1CE@HMDIBIP@?$AAs?$AAo?$AAu?$AAr?$AAc?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 003a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0046 ??_C@_1GG@IOHNAMEK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 004d __CrtDbgReportW 0061 __errno 0078 ??_C@_1CG@BMBAINBL@?$AAi?$AAn?$AAt?$AAe?$AAr?$AAn?$AAa?$AAl?$AA_?$AAw?$AAc?$AAs?$AAr?$AAt?$AAo?$AAm?$AAb?$AAs?$AA?$AA@ 0082 __invalid_parameter 00ad ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 00d3 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 00ee ?_wcrtomb_s_l@@YAHQAHQADI_WQAU_Mbstatet@@QAU__crt_locale_pointers@@@Z 0106 ??1_LocaleUpdate@@QAE@XZ 01f5 _memcpy_s 0251 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 0C 00 74 09 C7 45 E0 01 00 00 00 EB 07 C7 45 E0 00 00 00 00 8B 45 E0 89 45 DC 83 7D DC 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 BB 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D DC 00 75 31 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 BB 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 BA 01 00 00 C7 45 F0 00 00 00 00 C7 45 EC 00 00 00 00 8B 55 0C 8B 02 89 45 E8 6A 00 8D 4D BC E8 ?? ?? ?? ?? 83 7D 08 00 0F 85 87 00 00 00 EB 12 8B 4D EC 03 4D F0 89 4D EC 8B 55 E8 83 C2 02 89 55 E8 8D 4D BC E8 ?? ?? ?? ?? 50 8B 45 14 50 8B 4D E8 0F B7 11 52 6A 05 8D 45 F4 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 18 83 7D F0 00 7F 19 C7 45 D8 FF FF FF FF 8D 4D BC E8 ?? ?? ?? ?? 8B 45 D8 E9 39 01 00 00 EB 29 8B 55 F0 0F BE 44 15 F3 85 C0 75 1D 8B 4D F0 8B 55 EC 8D 44 0A FF 89 45 D4 8D 4D BC E8 ?? ?? ?? ?? 8B 45 D4 E9 0E 01 00 00 E9 7B FF FF FF EB 24 8B 4D EC 03 4D F0 89 4D EC 8B 55 E8 83 C2 02 89 55 E8 8B 45 08 03 45 F0 89 45 08 8B 4D 10 2B 4D F0 89 4D 10 83 7D 10 00 0F 86 C0 00 00 00 C7 45 E4 00 00 00 00 8D 4D BC E8 ?? ?? ?? ?? 8B 10 8B 45 10 3B 42 04 73 08 8D 4D F4 89 4D E4 EB 06 8B 55 08 89 55 E4 8D 4D BC E8 ?? ?? ?? ?? 50 8B 45 14 50 8B 4D E8 0F B7 11 52 6A 05 8B 45 E4 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 18 83 7D F0 00 7F 09 C7 45 EC FF FF FF FF EB 64 8B 55 08 3B 55 E4 75 02 EB 24 8B 45 10 3B 45 F0 73 04 EB 50 EB 18 8B 4D F0 51 8D 55 F4 52 8B 45 10 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B 55 08 03 55 F0 0F BE 42 FF 85 C0 75 23 8B 4D 0C C7 01 00 00 00 00 8B 55 F0 8B 45 EC 8D 4C 10 FF 89 4D D0 8D 4D BC E8 ?? ?? ?? ?? 8B 45 D0 EB 1E E9 12 FF FF FF 8B 55 0C 8B 45 E8 89 02 8B 4D EC 89 4D CC 8D 4D BC E8 ?? ?? ?? ?? 8B 45 CC 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_7_0 {
	meta:
		name = "_wcrtomb"
		size = 73
		refs = "003b _wcrtomb_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 C7 45 F8 FF FF FF FF 83 7D 08 00 75 09 C7 45 FC 00 00 00 00 EB 07 C7 45 FC 05 00 00 00 8B 45 10 50 0F B7 4D 0C 51 8B 55 FC 52 8B 45 08 50 8D 4D F8 51 E8 ?? ?? ?? ?? 83 C4 14 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_8_0 {
	meta:
		name = "_wcrtomb_s"
		size = 275
		refs = "0009 ___security_cookie 0041 ??_C@_1JO@PEAMJHLL@?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AAi?$AAn?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAd?$AAe?$AAs?$AAt?$AAi@ 0046 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0052 ??_C@_1GG@IOHNAMEK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0059 __CrtDbgReportW 006d __errno 0084 ??_C@_1BE@BAKHEIOA@?$AAw?$AAc?$AAr?$AAt?$AAo?$AAm?$AAb?$AA_?$AAs?$AA?$AA@ 008e __invalid_parameter 00c6 ?_wcrtomb_s_l@@YAHQAHQADI_WQAU_Mbstatet@@QAU__crt_locale_pointers@@@Z 010b @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 0C 00 75 06 83 7D 10 00 74 0F 83 7D 0C 00 75 09 C7 45 E8 00 00 00 00 EB 07 C7 45 E8 01 00 00 00 8B 45 E8 89 45 E4 83 7D E4 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E4 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 84 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 69 C7 45 EC 00 00 00 00 C7 45 F0 FF FF FF FF 83 7D 0C 00 75 22 6A 00 8B 55 18 52 0F B7 45 14 50 6A 05 8D 4D F4 51 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 EC EB 22 6A 00 8B 45 18 50 0F B7 4D 14 51 8B 55 10 52 8B 45 0C 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 EC 83 7D 08 00 74 08 8B 55 08 8B 45 F0 89 02 8B 45 EC 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_10_0 {
	meta:
		name = "_wcsrtombs_s"
		size = 834
		refs = "004c ??_C@_1NA@NLPIAHDO@?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AAi?$AAn?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAd?$AAe?$AAs?$AAt?$AAi@ 0051 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 005d ??_C@_1GG@IOHNAMEK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0064 __CrtDbgReportW 0078 __errno 008f ??_C@_1BI@JEFNCOO@?$AAw?$AAc?$AAs?$AAr?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAs?$AA?$AA@ 0099 __invalid_parameter 00cc __CrtGetDebugFillThreshold 0100 _memset 012a ??_C@_1CE@HMDIBIP@?$AAs?$AAo?$AAu?$AAr?$AAc?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01af _internal_wcsrtombs 02c9 ??_C@_1DK@PNOJMGLM@?$AAr?$AAe?$AAt?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAd?$AAe?$AAs?$AAt?$AAi?$AAn?$AAa?$AAt?$AAi?$AAo?$AAn?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 3C 83 7D 08 00 74 09 8B 45 08 C7 00 FF FF FF FF 83 7D 0C 00 75 06 83 7D 10 00 74 15 83 7D 0C 00 74 06 83 7D 10 00 77 09 C7 45 F8 00 00 00 00 EB 07 C7 45 F8 01 00 00 00 8B 4D F8 89 4D F4 83 7D F4 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 36 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F4 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 36 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 94 02 00 00 83 7D 0C 00 74 57 8B 45 0C C6 00 00 83 7D 10 FF 74 4B 81 7D 10 FF FF FF 7F 74 42 83 7D 10 01 76 3C E8 ?? ?? ?? ?? 89 45 F0 8B 4D 10 83 E9 01 39 4D F0 73 08 8B 55 F0 89 55 EC EB 09 8B 45 10 83 E8 01 89 45 EC 8B 4D EC 51 68 FE 00 00 00 8B 55 0C 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 14 00 74 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 45 E8 89 45 E4 83 7D E4 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3D 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E4 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 3D 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 B6 01 00 00 8B 55 18 3B 55 10 76 08 8B 45 10 89 45 E0 EB 06 8B 4D 18 89 4D E0 8B 55 1C 52 8B 45 E0 50 8B 4D 14 51 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC FF 75 6F 83 7D 0C 00 74 57 8B 45 0C C6 00 00 83 7D 10 FF 74 4B 81 7D 10 FF FF FF 7F 74 42 83 7D 10 01 76 3C E8 ?? ?? ?? ?? 89 45 DC 8B 4D 10 83 E9 01 39 4D DC 73 08 8B 55 DC 89 55 D8 EB 09 8B 45 10 83 E8 01 89 45 D8 8B 4D D8 51 68 FE 00 00 00 8B 55 0C 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 8B 00 89 45 C4 8B 45 C4 E9 10 01 00 00 8B 4D FC 83 C1 01 89 4D FC 83 7D 0C 00 0F 84 ED 00 00 00 8B 55 FC 3B 55 10 0F 86 D7 00 00 00 8B 45 0C C6 00 00 83 7D 10 FF 74 4B 81 7D 10 FF FF FF 7F 74 42 83 7D 10 01 76 3C E8 ?? ?? ?? ?? 89 45 D4 8B 4D 10 83 E9 01 39 4D D4 73 08 8B 55 D4 89 55 D0 EB 09 8B 45 10 83 E8 01 89 45 D0 8B 4D D0 51 68 FE 00 00 00 8B 55 0C 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 FC 3B 45 10 77 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 4D CC 89 4D C8 83 7D C8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 54 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D C8 00 75 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 68 54 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 1A 8B 45 0C 03 45 FC C6 40 FF 00 83 7D 08 00 74 08 8B 4D 08 8B 55 FC 89 11 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_37_11_0 {
	meta:
		name = "_wctob"
		size = 115
		refs = "0009 ___security_cookie 003d ?_wcrtomb_s_l@@YAHQAHQADI_WQAU_Mbstatet@@QAU__crt_locale_pointers@@@Z 006b @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 0F B7 45 08 3D FF FF 00 00 75 05 83 C8 FF EB 43 C7 45 F0 FF FF FF FF 6A 00 6A 00 0F B7 4D 08 51 6A 05 8D 55 F4 52 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 EC 83 7D EC 00 75 15 83 7D F0 01 75 0F B9 01 00 00 00 6B D1 00 0F BE 44 15 F4 EB 03 83 C8 FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "_nearbyint"
		size = 64
		refs = "000b __dtest 0035 __drint"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 7C 0D 83 7D FC 02 7E 02 EB 05 DD 45 08 EB 11 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_145_0_0 {
	meta:
		name = "_nearbyintl"
		size = 64
		refs = "000b __ldtest 0035 __ldrint"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 7C 0D 83 7D FC 02 7E 02 EB 05 DD 45 08 EB 11 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "??$?RD@__crt_public_free_policy@@QBEXQBD@Z"
		size = 18
		refs = "0009 _free"
		altNames = "??$?R_W@__crt_public_free_policy@@QBEXQB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 E8 ?? ?? ?? ?? 59 5D C2 04 00 }
	condition:
		$1
}

rule file_39_2_0 {
	meta:
		name = "??$common_getdcwd@D@@YAPADHQADHHQBDH@Z"
		size = 350
		refs = "0018 ??_C@_1BO@MPDAPECJ@?$AAm?$AAa?$AAx?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0020 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002b ??_C@_1GG@CONOEIEP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0033 __CrtDbgReportW 0041 __errno 0053 ??_C@_1BO@CEMJHGEG@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAg?$AAe?$AAt?$AAd?$AAc?$AAw?$AAd?$AA?$AA@ 0059 __invalid_parameter 0070 ?is_valid_drive@@YAHI@Z 007a ___doserrno 007f ??_C@_1CK@HNGDBNII@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAD?$AAr?$AAi?$AAv?$AAe?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 00c1 __getdrive 00f9 ??_C@_1BM@DEGOKKDC@?$AAm?$AAa?$AAx?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0138 ??$common_getdcwd_user_buffer@D@@YAPADQAD0I@Z 0150 ??$common_getdcwd_dynamic_buffer@D@@YAPADQADIHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B 75 10 33 C0 85 F6 57 0F 99 C0 85 C0 75 50 BF ?? ?? ?? ?? 33 DB 57 68 ?? ?? ?? ?? 53 68 D8 00 00 00 BE ?? ?? ?? ?? 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 D8 00 00 00 C7 00 16 00 00 00 56 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 F0 00 00 00 8B 5D 08 85 DB 74 52 53 E8 ?? ?? ?? ?? 59 85 C0 75 4E E8 ?? ?? ?? ?? BF ?? ?? ?? ?? 33 DB 57 68 ?? ?? ?? ?? 53 68 E1 00 00 00 BE ?? ?? ?? ?? C7 00 0F 00 00 00 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 E1 00 00 00 C7 00 0D 00 00 00 EB 91 E8 ?? ?? ?? ?? 8B D8 85 DB 74 13 80 C3 40 66 C7 45 FD 3A 2E 88 5D FC 33 DB 88 5D FF EB 08 66 C7 45 FC 2E 00 33 DB 8B 4D 0C 85 C9 74 54 33 C0 85 F6 0F 9F C0 85 C0 75 37 BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 53 68 FA 00 00 00 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 FA 00 00 00 E9 1C FF FF FF 56 51 8D 45 FC 88 19 50 E8 ?? ?? ?? ?? 83 C4 0C EB 16 FF 75 1C 8D 45 FC FF 75 18 FF 75 14 56 50 E8 ?? ?? ?? ?? 83 C4 14 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_3_0 {
	meta:
		name = "??$common_getdcwd@_W@@YAPA_WHQA_WHHQBDH@Z"
		size = 359
		refs = "0009 ___security_cookie 0039 ??_C@_1BO@MPDAPECJ@?$AAm?$AAa?$AAx?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0044 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004c ??_C@_1GG@CONOEIEP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0054 __CrtDbgReportW 0062 __errno 0071 ??_C@_1BO@CEMJHGEG@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAg?$AAe?$AAt?$AAd?$AAc?$AAw?$AAd?$AA?$AA@ 0077 __invalid_parameter 008e ?is_valid_drive@@YAHI@Z 0098 ___doserrno 009d ??_C@_1CK@HNGDBNII@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAD?$AAr?$AAi?$AAv?$AAe?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 00d9 __getdrive 011d ??_C@_1BM@DEGOKKDC@?$AAm?$AAa?$AAx?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0137 ??$common_getdcwd_user_buffer@_W@@YAPA_WQA_W0I@Z 014f ??$common_getdcwd_dynamic_buffer@_W@@YAPA_WQA_WIHQBDH@Z 015f @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 14 89 45 E8 8B 45 18 53 8B 5D 0C 89 45 EC 8B 45 1C 56 89 45 F0 33 C0 57 8B 7D 10 85 FF 0F 99 C0 85 C0 75 4D BF ?? ?? ?? ?? BB D8 00 00 00 57 68 ?? ?? ?? ?? 6A 00 53 BE ?? ?? ?? ?? 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 53 56 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 D1 00 00 00 8B 75 08 85 F6 74 4C 56 E8 ?? ?? ?? ?? 59 85 C0 75 48 E8 ?? ?? ?? ?? BF ?? ?? ?? ?? BB E1 00 00 00 57 68 ?? ?? ?? ?? 6A 00 53 BE ?? ?? ?? ?? C7 00 0F 00 00 00 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB 94 E8 ?? ?? ?? ?? 8B F0 85 F6 74 1D 8D 46 40 6A 3A 66 89 45 F4 58 66 89 45 F6 6A 2E 58 66 89 45 F8 33 C0 66 89 45 FA EB 0D 6A 2E 58 66 89 45 F4 33 C0 66 89 45 F6 85 DB 74 2F 33 C0 85 FF 0F 9F C0 85 C0 75 0F BF ?? ?? ?? ?? BB FA 00 00 00 E9 17 FF FF FF 33 C0 57 66 89 03 8D 45 F4 53 50 E8 ?? ?? ?? ?? 83 C4 0C EB 16 FF 75 F0 8D 45 F4 FF 75 EC FF 75 E8 57 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_4_0 {
	meta:
		name = "??$common_getdcwd_dynamic_buffer@D@@YAPADQADIHQBDH@Z"
		size = 139
		refs = "0010 __imp__GetFullPathNameA@16 001a __imp__GetLastError@0 0020 ___acrt_errno_map_os_error 0041 __calloc_dbg 004f ___doserrno 005a __errno 006c ??$common_getdcwd_user_buffer@D@@YAPADQAD0I@Z 007f _free"
	strings:
		$1 = { 8B FF 55 8B EC 57 33 FF 57 57 57 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 11 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 33 C0 EB 5F 53 8B 5D 0C 56 3B D8 77 02 8B D8 FF 75 18 FF 75 14 FF 75 10 6A 01 53 E8 ?? ?? ?? ?? 8B F0 83 C4 14 85 F6 75 18 E8 ?? ?? ?? ?? C7 00 08 00 00 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 17 53 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 06 8B CE 8B F7 8B F9 56 E8 ?? ?? ?? ?? 59 5E 8B C7 5B 5F 5D C3 }
	condition:
		$1
}

rule file_39_5_0 {
	meta:
		name = "??$common_getdcwd_dynamic_buffer@_W@@YAPA_WQA_WIHQBDH@Z"
		size = 139
		refs = "0010 __imp__GetFullPathNameW@16 001a __imp__GetLastError@0 0020 ___acrt_errno_map_os_error 0041 __calloc_dbg 004f ___doserrno 005a __errno 006c ??$common_getdcwd_user_buffer@_W@@YAPA_WQA_W0I@Z 007f _free"
	strings:
		$1 = { 8B FF 55 8B EC 57 33 FF 57 57 57 FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 75 11 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 33 C0 EB 5F 53 8B 5D 0C 56 3B D8 77 02 8B D8 FF 75 18 FF 75 14 FF 75 10 6A 02 53 E8 ?? ?? ?? ?? 8B F0 83 C4 14 85 F6 75 18 E8 ?? ?? ?? ?? C7 00 08 00 00 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 17 53 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 06 8B CE 8B F7 8B F9 56 E8 ?? ?? ?? ?? 59 5E 8B C7 5B 5F 5D C3 }
	condition:
		$1
}

rule file_39_6_0 {
	meta:
		name = "??$common_getdcwd_user_buffer@D@@YAPADQAD0I@Z"
		size = 159
		refs = "0017 ??_C@_1CC@ONIJBMJF@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0022 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002a ??_C@_1GG@CONOEIEP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0032 __CrtDbgReportW 0040 __errno 0049 ??_C@_1DG@KBFIBCJM@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAg?$AAe?$AAt?$AAd?$AAc?$AAw?$AAd?$AA_?$AAu?$AAs?$AAe?$AAr?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?$AA@ 0055 __invalid_parameter 006d __imp__GetFullPathNameA@16 008a __imp__GetLastError@0 0090 ___acrt_errno_map_os_error"
	strings:
		$1 = { 8B FF 55 8B EC 51 33 C0 56 8B 75 10 3B C6 1B C0 F7 D8 75 4E 53 57 BE ?? ?? ?? ?? BF 8A 00 00 00 56 68 ?? ?? ?? ?? 6A 00 57 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5F 5B EB 38 6A 00 FF 75 0C 56 FF 75 08 FF 15 ?? ?? ?? ?? 3B C6 72 0F E8 ?? ?? ?? ?? C7 00 22 00 00 00 33 C0 EB 16 85 C0 75 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB E9 8B 45 0C 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_7_0 {
	meta:
		name = "??$common_getdcwd_user_buffer@_W@@YAPA_WQA_W0I@Z"
		size = 159
		refs = "0017 ??_C@_1CC@ONIJBMJF@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0022 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002a ??_C@_1GG@CONOEIEP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0032 __CrtDbgReportW 0040 __errno 0049 ??_C@_1DG@KBFIBCJM@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAg?$AAe?$AAt?$AAd?$AAc?$AAw?$AAd?$AA_?$AAu?$AAs?$AAe?$AAr?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?$AA@ 0055 __invalid_parameter 006d __imp__GetFullPathNameW@16 008a __imp__GetLastError@0 0090 ___acrt_errno_map_os_error"
	strings:
		$1 = { 8B FF 55 8B EC 51 33 C0 56 8B 75 10 3B C6 1B C0 F7 D8 75 4E 53 57 BE ?? ?? ?? ?? BF 8A 00 00 00 56 68 ?? ?? ?? ?? 6A 00 57 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5F 5B EB 38 6A 00 FF 75 0C 56 FF 75 08 FF 15 ?? ?? ?? ?? 3B C6 72 0F E8 ?? ?? ?? ?? C7 00 22 00 00 00 33 C0 EB 16 85 C0 75 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB E9 8B 45 0C 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_10_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAE@XZ"
		size = 18
		refs = "0008 _free"
		altNames = "??1?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAE@XZ ?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QAEXXZ ?release@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 FF 36 E8 ?? ?? ?? ?? 83 26 00 59 5E C3 }
	condition:
		$1
}

rule file_39_16_0 {
	meta:
		name = "?get_full_path_name@@YAIQADQBDI@Z"
		size = 24
		refs = "0012 __imp__GetFullPathNameA@16"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 FF 75 10 FF 75 0C FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_39_17_0 {
	meta:
		name = "?get_full_path_name@@YAIQA_WQB_WI@Z"
		size = 24
		refs = "0012 __imp__GetFullPathNameW@16"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 FF 75 10 FF 75 0C FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_39_18_0 {
	meta:
		name = "?is_valid_drive@@YAHI@Z"
		size = 181
		refs = "0009 ___security_cookie 001d ___doserrno 0022 ??_C@_1DG@MHNEMPBB@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAD?$AAr?$AAi?$AAv?$AAe?$AA?5?$AAI?$AAn?$AAd?$AAe?$AAx?$AA?$CC?$AA?5?$AA?0?$AA0?$AA?$CJ?$AA?$AA@ 0027 ??_C@_1GG@CONOEIEP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 002d ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 003f __CrtDbgReportW 004d __errno 0057 ??_C@_1BO@FJKIOFDB@?$AAi?$AAs?$AA_?$AAv?$AAa?$AAl?$AAi?$AAd?$AA_?$AAd?$AAr?$AAi?$AAv?$AAe?$AA?$AA@ 0063 __invalid_parameter 0098 __imp__GetDriveTypeW@4 00ad @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 83 F8 1A 76 54 56 57 E8 ?? ?? ?? ?? BE ?? ?? ?? ?? BF ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 6A 00 6A 1E 57 6A 02 C7 00 0F 00 00 00 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 6A 1E 57 68 ?? ?? ?? ?? 56 C7 00 0D 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 5F 5E EB 37 85 C0 75 05 33 C0 40 EB 30 83 C0 40 6A 3A 66 89 45 F4 58 66 89 45 F6 6A 5C 58 66 89 45 F8 33 C0 66 89 45 FA 8D 45 F4 50 FF 15 ?? ?? ?? ?? 85 C0 74 05 83 F8 01 75 CD 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_39_21_0 {
	meta:
		name = "__getcwd"
		size = 28
		refs = "0013 ??$common_getdcwd@D@@YAPADHQADHHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 50 50 6A 01 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_39_25_0 {
	meta:
		name = "__wgetcwd"
		size = 28
		refs = "0013 ??$common_getdcwd@_W@@YAPA_WHQA_WHHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 50 50 6A 01 FF 75 0C FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_39_22_0 {
	meta:
		name = "__getcwd_dbg"
		size = 32
		refs = "0017 ??$common_getdcwd@D@@YAPADHQADHHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_39_26_0 {
	meta:
		name = "__wgetcwd_dbg"
		size = 32
		refs = "0017 ??$common_getdcwd@_W@@YAPA_WHQA_WHHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 6A 00 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_39_23_0 {
	meta:
		name = "__getdcwd"
		size = 30
		refs = "0015 ??$common_getdcwd@D@@YAPADHQADHHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_583_28_0 {
	meta:
		name = "__dupenv_s"
		size = 30
		refs = "0015 ??$common_dupenv_s@D@@YAHQAPADQAIQBDH2H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_583_31_0 {
	meta:
		name = "__wdupenv_s"
		size = 30
		refs = "0015 ??$common_dupenv_s@_W@@YAHQAPA_WQAIQB_WHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_39_27_0 {
	meta:
		name = "__wgetdcwd"
		size = 30
		refs = "0015 ??$common_getdcwd@_W@@YAPA_WHQA_WHHQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "?dup_nolock@@YAHH@Z"
		size = 552
		refs = "0008 __sehtable$?dup_nolock@@YAHH@Z 000d __except_handler4 001f ___security_cookie 0044 ___pioinfo 005b __alloc_osfhnd 0069 __errno 0074 ___doserrno 009d __imp__GetCurrentProcess@0 00a7 __get_osfhandle 00b8 __imp__DuplicateHandle@28 00c7 __imp__GetLastError@0 00cd ___acrt_errno_map_os_error 00e9 ___acrt_lowio_set_os_handle 020b ___acrt_lowio_unlock_fh"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 8B 45 08 C1 F8 06 8B 4D 08 83 E1 3F 6B D1 30 8B 04 85 ?? ?? ?? ?? 0F B6 4C 10 28 83 E1 01 75 08 83 C8 FF E9 BC 01 00 00 E8 ?? ?? ?? ?? 89 45 E0 83 7D E0 FF 75 1E E8 ?? ?? ?? ?? C7 00 18 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 83 C8 FF E9 90 01 00 00 C6 45 E7 00 C7 45 FC 00 00 00 00 6A 02 6A 01 6A 00 8D 55 D8 52 FF 15 ?? ?? ?? ?? 50 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 DC 83 7D DC 00 75 1B FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 E0 FF FF FF FF E9 D8 00 00 00 8B 4D D8 51 8B 55 E0 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 C1 F8 06 8B 4D 08 83 E1 3F 6B D1 30 8B 04 85 ?? ?? ?? ?? 0F B6 4C 10 28 83 E1 EF 8B 55 E0 C1 FA 06 8B 45 E0 83 E0 3F 6B C0 30 8B 14 95 ?? ?? ?? ?? 88 4C 02 28 8B 45 08 C1 F8 06 8B 4D 08 83 E1 3F 6B D1 30 8B 04 85 ?? ?? ?? ?? 8B 4D E0 C1 F9 06 8B 75 E0 83 E6 3F 6B F6 30 8B 0C 8D ?? ?? ?? ?? 8A 54 10 29 88 54 31 29 8B 45 08 C1 F8 06 8B 4D 08 83 E1 3F 6B D1 30 8B 04 85 ?? ?? ?? ?? 8A 4C 10 2D 80 E1 01 8B 55 E0 C1 FA 06 8B 45 E0 83 E0 3F 6B C0 30 8B 14 95 ?? ?? ?? ?? 80 E1 01 8A 44 02 2D 24 FE 0A C1 8B 4D E0 C1 F9 06 8B 55 E0 83 E2 3F 6B D2 30 8B 0C 8D ?? ?? ?? ?? 88 44 11 2D C6 45 E7 01 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 4D 0F B6 55 E7 85 D2 75 38 8B 45 E0 C1 F8 06 8B 4D E0 83 E1 3F 6B D1 30 8B 04 85 ?? ?? ?? ?? 0F B6 4C 10 28 83 E1 FE 8B 55 E0 C1 FA 06 8B 45 E0 83 E0 3F 6B C0 30 8B 14 95 ?? ?? ?? ?? 88 4C 02 28 8B 45 E0 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_40_1_0 {
	meta:
		name = "__dup"
		size = 571
		refs = "0008 __sehtable$__dup 000d __except_handler4 001f ___security_cookie 0039 ___doserrno 0044 __errno 0061 __nhandle 0084 ??_C@_1FO@LPCLHKGE@?$AA?$CI?$AAf?$AAh?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAf?$AAh?$AA?5?$AA?$DM?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi@ 0089 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0092 ??_C@_1FK@JIFNKPOK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAl@ 0099 __CrtDbgReportW 00cc ??_C@_19DABLNIOD@?$AA_?$AAd?$AAu?$AAp?$AA?$AA@ 00d6 __invalid_parameter 00f7 ___pioinfo 0122 ??_C@_1CM@OKGMMMDH@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAf?$AAh?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 0188 ___acrt_lowio_lock_fh 01c2 ?dup_nolock@@YAHH@Z 01e9 ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 021e ___acrt_lowio_unlock_fh"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 D3 01 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D E0 83 7D E0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 44 01 00 00 8B 45 08 C1 F8 06 8B 4D 08 83 E1 3F 6B D1 30 8B 04 85 ?? ?? ?? ?? 0F B6 4C 10 28 83 E1 01 74 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 55 DC 89 55 D8 83 7D D8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 4F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D8 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 4F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A6 00 00 00 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C7 45 D4 FF FF FF FF C7 45 FC 00 00 00 00 8B 55 08 C1 FA 06 8B 45 08 83 E0 3F 6B C8 30 8B 14 95 ?? ?? ?? ?? 0F B6 44 0A 28 83 E0 01 74 11 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 D4 EB 3D E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 33 D2 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 5D 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0D 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 D4 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "_remainderl"
		size = 35
		refs = "001a _remquol"
		altNames = "_remainder"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 83 EC 08 DD 45 10 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_42_4_0 {
	meta:
		name = "__mbslen"
		size = 19
		refs = "000b __mbslen_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_328_15_3 {
	meta:
		name = "__ismbbkana"
		size = 19
		refs = "000b __ismbbkana_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_118_5_3 {
	meta:
		name = "__ismbcalnum"
		size = 19
		refs = "000b __ismbcalnum_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_468_5_4 {
	meta:
		name = "__ismbcalpha"
		size = 19
		refs = "000b __ismbcalpha_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_568_5_4 {
	meta:
		name = "__ismbcblank"
		size = 19
		refs = "000b __ismbcblank_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_711_8_2 {
	meta:
		name = "__ismbcdigit"
		size = 19
		refs = "000b __ismbcdigit_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_439_5_0 {
	meta:
		name = "__ismbcgraph"
		size = 19
		refs = "000b __ismbcgraph_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_72_4_0 {
	meta:
		name = "__ismbchira"
		size = 19
		refs = "000b __ismbchira_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_72_6_0 {
	meta:
		name = "__ismbckata"
		size = 19
		refs = "000b __ismbckata_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_665_4_4 {
	meta:
		name = "__ismbcl0"
		size = 19
		refs = "000b __ismbcl0_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_665_6_0 {
	meta:
		name = "__ismbcl1"
		size = 19
		refs = "000b __ismbcl1_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_665_8_0 {
	meta:
		name = "__ismbcl2"
		size = 19
		refs = "000b __ismbcl2_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_593_4_3 {
	meta:
		name = "__ismbclegal"
		size = 19
		refs = "000b __ismbclegal_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_603_5_3 {
	meta:
		name = "__ismbclower"
		size = 19
		refs = "000b __ismbclower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_87_5_2 {
	meta:
		name = "__ismbcprint"
		size = 19
		refs = "000b __ismbcprint_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_568_7_2 {
	meta:
		name = "__ismbcpunct"
		size = 19
		refs = "000b __ismbcpunct_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_372_8_0 {
	meta:
		name = "__ismbcspace"
		size = 19
		refs = "000b __ismbcspace_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_72_8_0 {
	meta:
		name = "__ismbcsymbol"
		size = 19
		refs = "000b __ismbcsymbol_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_669_5_3 {
	meta:
		name = "__ismbcupper"
		size = 19
		refs = "000b __ismbcupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_363_4_3 {
	meta:
		name = "__mbbtombc"
		size = 19
		refs = "000b __mbbtombc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_164_4_4 {
	meta:
		name = "__mbcjistojms"
		size = 19
		refs = "000b __mbcjistojms_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_164_6_4 {
	meta:
		name = "__mbcjmstojis"
		size = 19
		refs = "000b __mbcjmstojis_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_401_0_2 {
	meta:
		name = "__mbctohira"
		size = 19
		refs = "000b __mbctohira_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "__mbctokata"
		size = 19
		refs = "000b __mbctokata_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_125_4_4 {
	meta:
		name = "__mbctolower"
		size = 19
		refs = "000b __mbctolower_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_363_6_2 {
	meta:
		name = "__mbctombb"
		size = 19
		refs = "000b __mbctombb_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_564_4_3 {
	meta:
		name = "__mbctoupper"
		size = 19
		refs = "000b __mbctoupper_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_565_4_0 {
	meta:
		name = "__mbsnextc"
		size = 19
		refs = "000b __mbsnextc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_362_4_4 {
	meta:
		name = "__mbsrev"
		size = 19
		refs = "000b __mbsrev_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_625_49_2 {
	meta:
		name = "__putenv"
		size = 19
		refs = "000b ??$common_putenv@D@@YAHQBD0@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_625_51_0 {
	meta:
		name = "__wputenv"
		size = 19
		refs = "000b ??$common_putenv@_W@@YAHQB_W0@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_42_5_0 {
	meta:
		name = "__mbslen_l"
		size = 99
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 F8 33 D2 39 56 08 75 11 8B 55 08 8D 4A 01 8A 02 42 84 C0 75 F9 2B D1 EB 1D 8B 4D 08 EB 12 0F B6 C0 F6 44 30 19 04 74 06 41 80 39 00 74 08 42 41 8A 01 84 C0 75 E8 80 7D FC 00 5E 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "__ldpoly"
		size = 59
		altNames = "__dpoly"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 10 DD 00 DD 5D F8 8B 4D 14 83 E9 01 89 4D 14 78 19 8B 55 10 83 C2 08 89 55 10 DD 45 F8 DC 4D 08 8B 45 10 DC 00 DD 5D F8 EB DC DD 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_43_1_0 {
	meta:
		name = "_erfcl"
		size = 621
		refs = "000d __ldtest 0054 __real@4000000000000000 006c _erfc_half 0084 _erfl 009b __real@3ff85e353f7ced91 00af _mid0 00c2 _mid00 00cc _s00 00da __ldpoly 00e4 _c00 010b _mid01 0115 _s01 012d _c01 0176 _approx 0208 __ld_int 0224 _expl 024c __ldexp 0260 __fperrraise"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D F8 83 7D F8 00 74 16 83 7D F8 01 74 17 83 7D F8 02 74 02 EB 3C DD 45 08 E9 33 02 00 00 D9 E8 E9 2C 02 00 00 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 74 0B DD 05 ?? ?? ?? ?? DD 5D E0 EB 05 D9 EE DD 5D E0 DD 45 E0 E9 FF 01 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 1F 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 E8 DE E1 E9 D5 01 00 00 E9 D0 01 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 0F 85 A5 00 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 49 DD 45 08 DC 25 ?? ?? ?? ?? DD 5D 08 6A 08 68 ?? ?? ?? ?? 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 6A 09 68 ?? ?? ?? ?? 83 EC 08 DD 45 08 DD 1C 24 DD 5D D8 E8 ?? ?? ?? ?? 83 C4 10 DC 7D D8 E9 65 01 00 00 EB 47 DD 45 08 DC 25 ?? ?? ?? ?? DD 5D 08 6A 08 68 ?? ?? ?? ?? 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 6A 09 68 ?? ?? ?? ?? 83 EC 08 DD 45 08 DD 1C 24 DD 5D D0 E8 ?? ?? ?? ?? 83 C4 10 DC 7D D0 E9 1C 01 00 00 E9 17 01 00 00 C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 83 7D FC 06 0F 83 EF 00 00 00 8B 45 FC C1 E0 05 DD 80 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 0F 85 D0 00 00 00 D9 E8 DC 75 08 8B 4D FC C1 E1 05 DC A1 ?? ?? ?? ?? DD 5D F0 8B 55 FC C1 E2 05 8B 82 ?? ?? ?? ?? 50 8B 4D FC C1 E1 05 8B 91 ?? ?? ?? ?? 52 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 8B 45 FC C1 E0 05 8B 88 ?? ?? ?? ?? 51 8B 55 FC C1 E2 05 8B 82 ?? ?? ?? ?? 50 83 EC 08 DD 45 F0 DD 1C 24 DD 5D C8 E8 ?? ?? ?? ?? 83 C4 10 DC 7D C8 DD 5D E8 DD 45 08 DD 5D F0 6A 11 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F0 DC 65 08 DD 45 F0 DC 45 08 DE C9 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 4D E8 DD 5D E8 DD 45 F0 D9 E0 DC 4D F0 DD 5D F0 6A 00 83 EC 08 DD 45 E8 DD 1C 24 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 10 DD 45 F0 EB 11 E9 FE FE FF FF 6A 10 E8 ?? ?? ?? ?? 83 C4 04 D9 EE 8B E5 5D C3 }
	condition:
		$1
}

rule file_378_1_0 {
	meta:
		name = "_erfc"
		size = 621
		refs = "000d __dtest 0054 __real@4000000000000000 006c _erfc_half 0084 _erf 009b __real@3ff85e353f7ced91 00af _mid0 00c2 _mid00 00cc _s00 00da __dpoly 00e4 _c00 010b _mid01 0115 _s01 012d _c01 0176 _approx 0208 __d_int 0224 _exp 024c __dexp 0260 __fperrraise"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D F8 83 7D F8 00 74 16 83 7D F8 01 74 17 83 7D F8 02 74 02 EB 3C DD 45 08 E9 33 02 00 00 D9 E8 E9 2C 02 00 00 BA 02 00 00 00 6B C2 03 0F B7 4C 05 08 81 E1 00 80 00 00 74 0B DD 05 ?? ?? ?? ?? DD 5D E0 EB 05 D9 EE DD 5D E0 DD 45 E0 E9 FF 01 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 1F 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 E8 DE E1 E9 D5 01 00 00 E9 D0 01 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 0F 85 A5 00 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 75 49 DD 45 08 DC 25 ?? ?? ?? ?? DD 5D 08 6A 08 68 ?? ?? ?? ?? 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 6A 09 68 ?? ?? ?? ?? 83 EC 08 DD 45 08 DD 1C 24 DD 5D D8 E8 ?? ?? ?? ?? 83 C4 10 DC 7D D8 E9 65 01 00 00 EB 47 DD 45 08 DC 25 ?? ?? ?? ?? DD 5D 08 6A 08 68 ?? ?? ?? ?? 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 6A 09 68 ?? ?? ?? ?? 83 EC 08 DD 45 08 DD 1C 24 DD 5D D0 E8 ?? ?? ?? ?? 83 C4 10 DC 7D D0 E9 1C 01 00 00 E9 17 01 00 00 C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 83 7D FC 06 0F 83 EF 00 00 00 8B 45 FC C1 E0 05 DD 80 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 41 0F 85 D0 00 00 00 D9 E8 DC 75 08 8B 4D FC C1 E1 05 DC A1 ?? ?? ?? ?? DD 5D F0 8B 55 FC C1 E2 05 8B 82 ?? ?? ?? ?? 50 8B 4D FC C1 E1 05 8B 91 ?? ?? ?? ?? 52 83 EC 08 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 8B 45 FC C1 E0 05 8B 88 ?? ?? ?? ?? 51 8B 55 FC C1 E2 05 8B 82 ?? ?? ?? ?? 50 83 EC 08 DD 45 F0 DD 1C 24 DD 5D C8 E8 ?? ?? ?? ?? 83 C4 10 DC 7D C8 DD 5D E8 DD 45 08 DD 5D F0 6A 11 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F0 DC 65 08 DD 45 F0 DC 45 08 DE C9 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 4D E8 DD 5D E8 DD 45 F0 D9 E0 DC 4D F0 DD 5D F0 6A 00 83 EC 08 DD 45 E8 DD 1C 24 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 10 DD 45 F0 EB 11 E9 FE FE FF FF 6A 10 E8 ?? ?? ?? ?? 83 C4 04 D9 EE 8B E5 5D C3 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "_cexpl"
		size = 647
		refs = "0025 _creall 004c _cimagl 005b __ldtest 0124 __LZero_C 0146 _cosl 015e _sinl 017a __fperrraise 0189 __LNan_C 0223 __ldexp 0260 __LCbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F0 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 8D 4D E8 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 0F BF 55 F8 83 FA 02 75 27 0F BF 45 FC 85 C0 75 0E DD 45 F0 DD 5D D8 DD 45 E8 DD 5D E0 EB 0C DD 45 F0 DD 5D D8 DD 45 F0 DD 5D E0 E9 A3 01 00 00 0F BF 4D FC 83 F9 02 75 40 0F BF 55 F8 83 FA 01 75 26 D9 EE DC 5D F0 DF E0 F6 C4 41 75 0C D9 EE DD 5D D8 D9 EE DD 5D E0 EB 0C DD 45 F0 DD 5D D8 DD 45 E8 DD 5D E0 EB 0C DD 45 E8 DD 5D D8 DD 45 E8 DD 5D E0 E9 5A 01 00 00 0F BF 45 F8 83 F8 01 0F 85 DC 00 00 00 D9 EE DC 5D F0 DF E0 F6 C4 41 75 66 0F BF 4D FC 83 F9 01 75 2B D9 EE DD 5D D8 D9 EE DC 5D E8 DF E0 F6 C4 41 75 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D D0 EB 05 D9 EE DD 5D D0 DD 45 D0 DD 5D E0 EB 30 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 EE DE C9 DD 5D D8 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 EE DE C9 DD 5D E0 EB 68 0F BF 55 FC 83 FA 01 75 1B 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 45 F0 DD 5D D8 DD 05 ?? ?? ?? ?? DD 5D E0 EB 44 0F BF 45 FC 85 C0 75 0E DD 45 F0 DD 5D D8 DD 45 E8 DD 5D E0 EB 2E 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 4D F0 DD 5D D8 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 4D F0 DD 5D E0 EB 71 0F BF 4D FC 83 F9 01 75 1E 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? DD 5D D8 DD 05 ?? ?? ?? ?? DD 5D E0 EB 4A DD 45 F0 DD 5D D8 DD 45 F0 DD 5D E0 6A 00 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 8D 55 D8 52 E8 ?? ?? ?? ?? 83 C4 10 6A 00 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 10 83 EC 08 DD 45 E0 DD 1C 24 83 EC 08 DD 45 D8 DD 1C 24 8D 4D C0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "_cexp"
		size = 647
		refs = "0025 _creal 004c _cimag 005b __dtest 0124 __Zero_C 0146 _cos 015e _sin 017a __fperrraise 0189 __Nan_C 0223 __dexp 0260 __Cbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F0 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 8D 4D E8 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 0F BF 55 F8 83 FA 02 75 27 0F BF 45 FC 85 C0 75 0E DD 45 F0 DD 5D D8 DD 45 E8 DD 5D E0 EB 0C DD 45 F0 DD 5D D8 DD 45 F0 DD 5D E0 E9 A3 01 00 00 0F BF 4D FC 83 F9 02 75 40 0F BF 55 F8 83 FA 01 75 26 D9 EE DC 5D F0 DF E0 F6 C4 41 75 0C D9 EE DD 5D D8 D9 EE DD 5D E0 EB 0C DD 45 F0 DD 5D D8 DD 45 E8 DD 5D E0 EB 0C DD 45 E8 DD 5D D8 DD 45 E8 DD 5D E0 E9 5A 01 00 00 0F BF 45 F8 83 F8 01 0F 85 DC 00 00 00 D9 EE DC 5D F0 DF E0 F6 C4 41 75 66 0F BF 4D FC 83 F9 01 75 2B D9 EE DD 5D D8 D9 EE DC 5D E8 DF E0 F6 C4 41 75 0D DD 05 ?? ?? ?? ?? D9 E0 DD 5D D0 EB 05 D9 EE DD 5D D0 DD 45 D0 DD 5D E0 EB 30 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 EE DE C9 DD 5D D8 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 EE DE C9 DD 5D E0 EB 68 0F BF 55 FC 83 FA 01 75 1B 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 45 F0 DD 5D D8 DD 05 ?? ?? ?? ?? DD 5D E0 EB 44 0F BF 45 FC 85 C0 75 0E DD 45 F0 DD 5D D8 DD 45 E8 DD 5D E0 EB 2E 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 4D F0 DD 5D D8 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 4D F0 DD 5D E0 EB 71 0F BF 4D FC 83 F9 01 75 1E 6A 01 E8 ?? ?? ?? ?? 83 C4 04 DD 05 ?? ?? ?? ?? DD 5D D8 DD 05 ?? ?? ?? ?? DD 5D E0 EB 4A DD 45 F0 DD 5D D8 DD 45 F0 DD 5D E0 6A 00 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 8D 55 D8 52 E8 ?? ?? ?? ?? 83 C4 10 6A 00 83 EC 08 DD 45 E8 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 10 83 EC 08 DD 45 E0 DD 1C 24 83 EC 08 DD 45 D8 DD 1C 24 8D 4D C0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "___libm_sse2_acos"
		size = 1187
		refs = "0007 _ABSVALMASK 000f _ONEMASK 0021 _TMASK 007f ___acrt_acos_asin_t_table 008c ___acrt_acos_asin_tbl_addr 00b8 _cv 00fb _PI_BY_2 01ba _NEG_PI 026a _cv2 0303 _ONE_BY_2 034a _HALFMASK 0463 _PI"
	strings:
		$1 = { 83 EC 0C 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 13 44 24 04 66 0F 57 ED 66 0F 12 15 ?? ?? ?? ?? F2 0F 10 C8 66 0F 73 D0 2C 66 0F 7E C2 F2 0F 10 F9 B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C1 B8 FF FF 07 00 23 C2 2D 00 FB 03 00 3D BB 03 00 00 0F 83 C9 00 00 00 F2 0F 59 C9 81 E2 FF FF 00 00 F2 0F 5C D9 F2 0F 51 DB 66 0F 54 D7 83 E2 FC 81 EA 00 FB 00 00 66 0F 12 0C 55 ?? ?? ?? ?? 66 0F 56 D5 66 0F 28 24 95 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 58 FA F2 0F 5C C2 F2 0F 59 F8 F2 0F 59 F1 F2 0F 59 DA F2 0F 10 CE F2 0F 58 F3 F2 0F 5E FE 66 0F 12 05 ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C CB 66 0F 73 D2 3F F2 0F 10 D9 66 0F 73 F2 3F F2 0F 59 C9 66 0F 70 D2 44 66 0F 12 35 ?? ?? ?? ?? F2 0F 59 D9 F2 0F 59 C1 66 0F 57 E2 F2 0F 59 EB 66 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D9 F2 0F 58 C6 F2 0F 59 C3 F2 0F 5C EC 66 0F 70 E4 EE F2 0F 58 C5 F2 0F 5C C7 83 C4 0C F2 0F 5C C4 C3 2D BB 03 00 00 83 F8 41 0F 83 20 01 00 00 66 0F 73 D7 26 66 0F 73 F7 26 66 0F D7 C0 66 0F 55 E0 F2 0F 5C CF F2 0F 10 F7 F2 0F 59 FF F2 0F 58 C6 66 0F 56 EC F2 0F 5C DF F2 0F 59 C1 F2 0F 10 E3 F2 0F 5C D8 F2 0F 51 DB 25 80 00 00 00 C1 E8 07 F7 D8 F2 0F 10 FB 66 0F 54 D3 66 0F 73 F3 02 66 0F C5 D3 03 66 0F 56 D5 66 0F 6E D8 66 0F 70 DB 00 81 EA C0 FE 00 00 03 D2 F2 0F 59 3C 95 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 59 CA F2 0F 59 D2 F2 0F 5C F7 66 0F 54 1D ?? ?? ?? ?? F2 0F 58 F1 F2 0F 5C E2 F2 0F 58 FF 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C E0 F2 0F 58 FE 66 0F 12 05 ?? ?? ?? ?? F2 0F 5E E7 66 0F 12 15 ?? ?? ?? ?? 66 0F 58 1C D5 ?? ?? ?? ?? F2 0F 10 CE F2 0F 59 F6 F2 0F 59 C6 F2 0F 59 CE F2 0F 59 E9 F2 0F 59 CE F2 0F 58 C2 66 0F EF F6 F2 0F 59 C1 F2 0F 58 EB F2 0F 58 C5 25 00 80 00 00 66 0F C4 F0 03 F2 0F 10 EC 66 0F 70 DB EE F2 0F 58 E3 F2 0F 5C DC F2 0F 58 EB F2 0F 58 C5 F2 0F 58 C4 83 C4 0C 66 0F 57 C6 C3 05 BB 3B 00 00 3D 00 38 00 00 0F 83 83 00 00 00 66 0F 14 C0 66 0F 28 35 ?? ?? ?? ?? 66 0F 14 C8 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 C0 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 F0 66 0F 59 C0 F2 0F 10 D9 F2 0F 59 C9 66 0F 58 F2 66 0F 59 E0 F2 0F 59 CB 66 0F 58 F4 66 0F 70 C5 EE 66 0F 59 CE 66 0F 70 F5 EE F2 0F 5C C7 66 0F 70 D1 EE F2 0F 5C E9 F2 0F 5C F0 F2 0F 5C EA F2 0F 5C FE 83 C4 0C F2 0F 5C EF F2 0F 58 C5 C3 2D FC 3B 00 00 83 F8 04 0F 83 E7 00 00 00 66 0F 57 F6 66 0F 54 3D ?? ?? ?? ?? 66 0F 12 25 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? F2 0F 59 FC 66 0F 28 15 ?? ?? ?? ?? F2 0F 5C E7 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 FC 44 F2 0F 51 E4 66 0F 59 CF 66 0F 70 EF 44 66 0F C5 C0 03 66 0F 59 FF 66 0F 58 D1 66 0F 12 0D ?? ?? ?? ?? 66 0F 59 DF F2 0F C2 C6 01 F2 0F 59 FD 66 0F 58 D3 66 0F 70 C0 44 F2 0F 59 D7 66 0F 54 05 ?? ?? ?? ?? 66 0F 59 D5 66 0F 54 CC 66 0F 70 DC 44 F2 0F 5C E1 F2 0F 58 DB F2 0F 59 C9 F2 0F 5C DC F2 0F 5C E9 F2 0F 59 E3 66 0F 70 DB EE F2 0F 5C EC F2 0F 5E EB 66 0F 58 DB 66 0F 59 D3 66 0F 70 E2 EE F2 0F 58 D0 25 00 80 00 00 66 0F C4 F0 03 66 0F 70 C0 EE F2 0F 58 D4 F2 0F 58 D5 F2 0F 58 D3 F2 0F 58 C2 83 C4 0C 66 0F 57 C6 C3 05 FC FE 03 00 3D 00 FF 03 00 0F 82 95 00 00 00 66 0F 7E F9 66 0F 73 D7 20 66 0F 7E FA 81 E2 FF FF FF 7F B8 00 00 F0 3F 2B C2 0B C1 83 F8 00 74 41 66 0F 12 54 24 04 66 0F 7E D2 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF FF 7F 83 EA 01 81 D9 00 00 F0 7F 83 F9 00 7D 65 66 0F 57 C9 66 0F 57 C0 BA F0 7F 00 00 66 0F C4 CA 03 83 C4 0C F2 0F 59 C1 C3 66 0F C5 D7 01 C1 EA 0F F7 DA 66 0F 6E FA 66 0F 70 FF 00 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? 66 0F 54 D7 66 0F 54 C7 83 C4 0C F2 0F 58 C2 C3 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? 83 C4 0C F2 0F 58 C2 C3 66 0F 57 F6 83 C4 0C F2 0F 58 C6 C3 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "__fdxp_addh"
		size = 1227
		refs = "0023 __fdunscale 0050 __fdtest 00b7 __fperrraise 00cb __FNan_C 033a __fd_int 034b __fdscale"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 3C 56 D9 45 10 D9 5D DC 83 7D 0C 00 75 05 E9 A9 04 00 00 8D 45 DC 50 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 FC 0F BF 55 FC 85 D2 0F 8E B3 00 00 00 0F BF 45 FC 83 F8 02 74 20 B9 04 00 00 00 6B D1 00 03 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 0F BF 45 FC 85 C0 7F 13 B9 04 00 00 00 6B D1 00 8B 45 08 D9 45 10 D9 1C 10 EB 72 0F BF 4D FC 83 F9 02 74 33 BA 02 00 00 00 C1 E2 00 0F B7 44 15 10 25 00 80 00 00 B9 04 00 00 00 6B D1 00 03 55 08 B9 02 00 00 00 C1 E1 00 0F B7 14 0A 81 E2 00 80 00 00 3B C2 75 02 EB 34 6A 01 E8 ?? ?? ?? ?? 83 C4 04 B8 04 00 00 00 6B C8 00 8B 55 08 D9 05 ?? ?? ?? ?? D9 1C 0A 83 7D 0C 01 7E 10 B8 04 00 00 00 C1 E0 00 8B 4D 08 D9 EE D9 1C 01 E9 D6 03 00 00 0F BF 55 FC 85 D2 0F 8D CA 03 00 00 C7 45 E0 00 01 00 00 C7 45 F0 00 00 00 00 8B 45 F0 3B 45 0C 0F 8D B0 03 00 00 8B 4D F0 8B 55 08 D9 04 8A D9 5D C4 C7 45 D8 0C 00 00 00 8D 45 C4 50 8D 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 FC 0F BF 55 FC 85 D2 7E 0A E9 7C 03 00 00 E9 72 03 00 00 0F BF 45 FC 85 C0 75 2D 8B 4D F0 8B 55 08 D9 45 10 D9 1C 8A 8B 45 F0 83 C0 01 3B 45 0C 7D 0C 8B 4D F0 8B 55 08 D9 EE D9 5C 8A 04 E9 47 03 00 00 E9 3D 03 00 00 0F BF 45 F8 0F BF 4D F4 2B C1 89 45 D4 8B 55 D8 F7 DA 39 55 D4 0F 8F A4 00 00 00 D9 45 10 D9 EE DA E9 DF E0 F6 C4 44 0F 8B 92 00 00 00 8B 45 F0 89 45 EC 8B 4D EC 83 C1 01 89 4D EC 8B 55 EC 3B 55 0C 7D 16 8B 45 EC 8B 4D 08 D9 04 81 D9 EE DA E9 DF E0 F6 C4 44 7B 02 EB D9 8B 55 0C 83 EA 01 39 55 EC 7D 0B 8B 45 EC 83 C0 01 89 45 EC EB 11 8B 4D EC 3B 4D 0C 75 09 8B 55 EC 83 EA 01 89 55 EC EB 09 8B 45 EC 83 E8 01 89 45 EC 8B 4D F0 3B 4D EC 7D 15 8B 55 EC 8B 45 08 8B 4D EC 8B 75 08 D9 44 8E FC D9 1C 90 EB DA 8B 55 F0 8B 45 08 D9 45 10 D9 1C 90 D9 EE D9 5D 10 E9 7E 02 00 00 8B 4D D8 3B 4D D4 7F 23 D9 45 10 D9 EE DA E9 DF E0 F6 C4 44 7B 15 0F BF 55 F8 89 55 E0 8B 45 F0 83 C0 01 89 45 F0 E9 53 02 00 00 8B 4D F0 8B 55 08 D9 04 8A D8 45 10 D9 5D D0 8B 45 F0 8B 4D 08 D9 45 D0 D9 1C 81 D9 45 D0 D9 EE DA E9 DF E0 F6 C4 44 7A 66 8B 55 F0 89 55 E8 8B 45 E8 83 C0 01 89 45 E8 8B 4D E8 3B 4D 0C 7D 2A 8B 55 E8 8B 45 08 8B 4D E8 8B 75 08 D9 04 8E D9 5C 90 FC 8B 55 E8 8B 45 08 D9 44 90 FC D9 EE DA E9 DF E0 F6 C4 44 7B 02 EB C5 8B 4D 0C 8B 55 08 D9 EE D9 5C 8A FC 8B 45 F0 8B 4D 08 D9 04 81 D9 EE DA E9 DF E0 F6 C4 44 7A 05 E9 C9 01 00 00 8B 55 F0 8B 45 08 D9 04 90 D9 5D 10 8D 4D 10 51 8D 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 E0 2B 45 D8 0F BF 4D F4 3B C1 0F 8D DD 00 00 00 0F BF 55 F4 8B 45 E0 2B 45 D8 2B D0 52 8D 4D 10 51 E8 ?? ?? ?? ?? 83 C4 08 0F BF 55 F4 52 8D 45 10 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D F0 8B 55 08 D9 04 8A D8 65 10 D9 5D CC 8B 45 F0 8B 4D 08 D9 45 CC D9 1C 81 D9 45 CC D9 EE DA E9 DF E0 F6 C4 44 7A 4D 8B 55 F0 89 55 E4 8B 45 E4 83 C0 01 89 45 E4 8B 4D E4 3B 4D 0C 7D 2A 8B 55 E4 8B 45 08 8B 4D E4 8B 75 08 D9 04 8E D9 5C 90 FC 8B 55 E4 8B 45 08 D9 44 90 FC D9 EE DA E9 DF E0 F6 C4 44 7B 02 EB C5 8B 4D 0C 8B 55 08 D9 EE D9 5C 8A FC 8B 45 F0 83 E8 01 89 45 F0 75 09 C7 45 E0 00 01 00 00 EB 24 8B 4D F0 8B 55 08 D9 44 8A FC D9 5D DC 8D 45 DC 50 8D 4D F8 51 E8 ?? ?? ?? ?? 83 C4 08 0F BF 55 F8 89 55 E0 E9 B9 00 00 00 8B 45 F0 83 C0 01 3B 45 0C 75 0A E9 AE 00 00 00 E9 A4 00 00 00 8B 4D F0 8B 55 08 D9 04 8A D9 5D 10 8B 45 F0 8B 4D 08 8D 14 81 52 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 08 6A 0C 8B 4D F0 8B 55 08 8D 04 8A 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF 4D F8 51 8B 55 F0 8B 45 08 8D 0C 90 51 E8 ?? ?? ?? ?? 83 C4 08 D9 45 10 8B 55 F0 8B 45 08 D8 24 90 D9 5D 10 0F BF 4D F8 89 4D E0 D9 45 10 D9 EE DA E9 DF E0 F6 C4 44 7B 08 D9 45 10 D9 5D C8 EB 0C 8B 55 F0 8B 45 08 D9 04 90 D9 5D C8 D9 45 C8 D9 5D DC 8D 4D DC 51 8D 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 8B 45 F0 83 C0 01 89 45 F0 E9 44 FC FF FF 8B 45 08 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_1_0 {
	meta:
		name = "__fdxp_addx"
		size = 90
		refs = "004a __fdxp_addh"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 3B 4D 14 7D 33 8B 55 FC 8B 45 10 D9 04 90 D9 EE DA E9 DF E0 F6 C4 44 7B 1F 8B 4D FC 8B 55 10 51 D9 04 8A D9 1C 24 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C EB BC 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_2_0 {
	meta:
		name = "__fdxp_getw"
		size = 203
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 56 83 7D 0C 00 75 0C D9 EE E9 B0 00 00 00 E9 AB 00 00 00 83 7D 0C 01 74 38 B8 04 00 00 00 6B C8 00 8B 55 08 D9 04 0A D9 EE DA E9 DF E0 F6 C4 44 7B 1F 83 7D 0C 01 7E 2B B8 04 00 00 00 C1 E0 00 8B 4D 08 D9 04 01 D9 EE DA E9 DF E0 F6 C4 44 7A 12 BA 04 00 00 00 6B C2 00 8B 4D 08 D9 04 01 EB 5D EB 5B 83 7D 0C 02 75 26 BA 04 00 00 00 6B C2 00 B9 04 00 00 00 C1 E1 00 8B 55 08 D9 04 02 8B 45 08 D8 04 08 D9 5D FC D9 45 FC EB 31 EB 2F B9 04 00 00 00 6B D1 00 B8 04 00 00 00 C1 E0 00 B9 04 00 00 00 D1 E1 8B 75 08 D9 04 06 8B 45 08 D8 04 08 8B 4D 08 D8 04 11 D9 5D F8 D9 45 F8 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_3_0 {
	meta:
		name = "__fdxp_invx"
		size = 420
		refs = "0020 __fdtest 0063 __FInf_C 00ab __fdxp_movx 00b4 __real@bf800000 00c4 __fdxp_mulh 00ff __fdxp_setw 0148 __fdxp_mulx 015d __fdxp_addh 0191 __fdxp_addx"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 83 7D 0C 00 75 05 E9 8A 01 00 00 B8 04 00 00 00 6B C8 00 03 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 0F BF 55 FC 85 D2 7C 3C 0F BF 45 FC 83 F8 01 75 12 B9 04 00 00 00 6B D1 00 8B 45 08 D9 EE D9 1C 10 EB 1C 0F BF 4D FC 85 C9 75 14 BA 04 00 00 00 6B C2 00 8B 4D 08 D9 05 ?? ?? ?? ?? D9 1C 01 E9 2E 01 00 00 8B 55 10 89 55 F8 8B 45 0C 8B 4D 10 8D 14 81 89 55 F4 8B 45 0C 8B 4D F4 8D 14 81 89 55 E8 B8 04 00 00 00 6B C8 00 8B 55 08 D9 04 0A D9 5D F0 8B 45 08 50 8B 4D 0C 51 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 D9 05 ?? ?? ?? ?? D9 1C 24 8B 45 0C 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 0C 01 7E 14 BA 04 00 00 00 C1 E2 00 D9 45 F0 8B 45 08 D8 04 10 D9 5D F0 D9 45 F0 D9 E8 DE F1 D9 5D E4 D9 45 E4 51 D9 1C 24 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C C7 45 EC 01 00 00 00 EB 08 8B 45 EC D1 E0 89 45 EC 8B 4D EC 3B 4D 0C 7D 7E 8B 55 08 52 8B 45 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 E8 52 8B 45 0C 50 8B 4D F4 51 8B 55 0C 52 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 10 D9 E8 D9 1C 24 8B 4D 0C 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 E8 50 8B 4D 0C 51 8B 55 08 52 8B 45 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 0C 52 8B 45 F8 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 E9 72 FF FF FF 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_4_0 {
	meta:
		name = "__fdxp_ldexpx"
		size = 97
		refs = "0032 _ldexpf"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 3B 4D 0C 7D 3A 8B 55 10 52 8B 45 FC 8B 4D 08 51 D9 04 81 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 8B 55 FC 8B 45 08 D9 1C 90 8B 4D FC 8B 55 08 D9 04 8A D9 EE DA E9 DF E0 F6 C4 44 7A 02 EB 02 EB B5 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_5_0 {
	meta:
		name = "__fdxp_movx"
		size = 33
		refs = "0015 _memcpy"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C C1 E0 02 50 8B 4D 10 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_46_6_0 {
	meta:
		name = "__fdxp_mulh"
		size = 584
		refs = "0009 ___security_cookie 0047 __fdtest 0066 __fperrraise 0198 __fdunscale 01a6 __fd_int 01b7 __fdscale 01cd __fdxp_addh 0240 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 0C 00 0F 8E A1 00 00 00 B8 04 00 00 00 6B C8 00 8B 55 08 D9 04 0A D8 4D 10 B8 04 00 00 00 6B C8 00 D9 5C 0D EC BA 04 00 00 00 6B C2 00 8D 4C 05 EC 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 E4 0F BF 55 E4 85 D2 7C 53 0F BF 45 E4 83 F8 02 75 0A 6A 01 E8 ?? ?? ?? ?? 83 C4 04 B9 04 00 00 00 6B D1 00 B8 04 00 00 00 6B C8 00 8B 45 08 D9 44 15 EC D9 1C 08 0F BF 4D E4 85 C9 7E 16 83 7D 0C 01 7E 10 BA 04 00 00 00 C1 E2 00 8B 45 08 D9 EE D9 1C 10 8B 45 08 E9 8D 01 00 00 B9 04 00 00 00 6B D1 00 8B 45 08 D9 EE D9 1C 10 C7 45 E8 01 00 00 00 C7 45 E0 00 00 00 00 EB 12 8B 4D E0 83 C1 01 89 4D E0 8B 55 E8 83 EA 01 89 55 E8 8B 45 E0 3B 45 0C 0F 8D 4C 01 00 00 EB 09 8B 4D E8 83 C1 01 89 4D E8 83 7D E8 04 7D 5C 8B 55 E0 03 55 E8 3B 55 0C 7D 3D 8B 45 E0 03 45 E8 8B 4D 08 D9 04 81 D9 EE DA E9 DF E0 F6 C4 44 7B 26 8B 55 E0 03 55 E8 8B 45 08 D9 04 90 D8 4D 10 8B 4D E8 D9 5C 8D EC 8B 55 E0 03 55 E8 8B 45 08 D9 EE D9 1C 90 EB 12 8B 4D E8 D9 EE D9 5C 8D EC C7 45 E8 08 00 00 00 EB 02 EB 95 BA 04 00 00 00 6B C2 00 D9 44 05 EC D9 EE DA E9 DF E0 F6 C4 44 7A 0A E9 C3 00 00 00 E9 B9 00 00 00 C7 45 DC 00 00 00 00 B9 04 00 00 00 6B D1 00 D9 44 15 EC D9 5D D8 8D 45 D8 50 8D 4D D4 51 E8 ?? ?? ?? ?? 83 C4 08 6A 0C 8D 55 D8 52 E8 ?? ?? ?? ?? 83 C4 08 0F BF 45 D4 50 8D 4D D8 51 E8 ?? ?? ?? ?? 83 C4 04 D9 45 D8 D9 1C 24 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C B9 04 00 00 00 6B D1 00 D9 44 15 EC D8 65 D8 D9 5D D0 D9 45 D0 51 D9 1C 24 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 DC 83 C2 01 89 55 DC 8B 45 DC 3B 45 E8 7D 24 8B 4D DC 8B 55 DC D9 44 95 EC D9 5C 8D E8 8B 45 DC D9 44 85 E8 D9 EE DA E9 DF E0 F6 C4 44 7A 02 EB 02 EB CB E9 96 FE FF FF 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_7_0 {
	meta:
		name = "__fdxp_mulx"
		size = 314
		refs = "0066 __fdxp_mulh 0091 __fdxp_movx 012a __fdxp_addx"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 83 7D 0C 00 74 06 83 7D 14 00 75 05 E9 1A 01 00 00 B8 04 00 00 00 6B C8 00 8B 55 10 D9 04 0A D9 EE DA E9 DF E0 F6 C4 44 7B 19 B8 04 00 00 00 C1 E0 00 8B 4D 10 D9 04 01 D9 EE DA E9 DF E0 F6 C4 44 7A 27 BA 04 00 00 00 6B C2 00 8B 4D 10 51 D9 04 01 D9 1C 24 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C E9 C1 00 00 00 8B 4D 18 89 4D F4 8B 55 0C 8B 45 18 8D 0C 90 89 4D F8 8B 55 08 52 8B 45 0C 50 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 0C BA 04 00 00 00 6B C2 00 8B 4D 10 51 D9 04 01 D9 1C 24 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C C7 45 FC 01 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 8B 55 FC 3B 55 14 7D 5F 8B 45 FC 8B 4D 10 D9 04 81 D9 EE DA E9 DF E0 F6 C4 44 7B 4B 8B 55 F4 52 8B 45 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 FC 8B 45 10 51 D9 04 90 D9 1C 24 8B 4D 0C 51 8B 55 F8 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 50 8B 4D F8 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 EB 90 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_8_0 {
	meta:
		name = "__fdxp_setw"
		size = 397
		refs = "0028 __fdunscale 0086 __fd_int 0097 __fdscale"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C D9 45 10 D9 5D F4 83 7D 0C 00 7F 05 E9 6D 01 00 00 83 7D 0C 01 74 1C 8D 45 F4 50 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 F8 0F BF 55 F8 85 D2 75 16 B8 04 00 00 00 6B C8 00 8B 55 08 D9 45 F4 D9 1C 0A E9 35 01 00 00 0F BF 45 F8 85 C0 7E 26 B9 04 00 00 00 6B D1 00 8B 45 08 D9 45 F4 D9 1C 10 B9 04 00 00 00 C1 E1 00 8B 55 08 D9 EE D9 1C 0A E9 07 01 00 00 6A 0C 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF 4D FC 51 8D 55 F4 52 E8 ?? ?? ?? ?? 83 C4 08 B8 04 00 00 00 6B C8 00 8B 55 08 D9 45 F4 D9 1C 0A D9 45 10 D8 65 F4 B8 04 00 00 00 C1 E0 00 8B 4D 08 D9 1C 01 33 D2 0F 84 A6 00 00 00 B8 04 00 00 00 C1 E0 00 8B 4D 08 D9 04 01 D9 5D 10 BA 04 00 00 00 C1 E2 00 03 55 08 52 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 6A 0C B9 04 00 00 00 C1 E1 00 03 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 0F BF 55 FC 52 B8 04 00 00 00 C1 E0 00 03 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 B9 04 00 00 00 C1 E1 00 D9 45 10 8B 55 08 D8 24 0A B8 04 00 00 00 D1 E0 8B 4D 08 D9 1C 01 83 7D 0C 03 7E 28 BA 04 00 00 00 D1 E2 8B 45 08 D9 04 10 D9 EE DA E9 DF E0 F6 C4 44 7B 10 B9 04 00 00 00 6B D1 03 8B 45 08 D9 EE D9 1C 10 EB 15 83 7D 0C 02 7E 0F B9 04 00 00 00 D1 E1 8B 55 08 D9 EE D9 1C 0A 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_9_0 {
	meta:
		name = "__fdxp_sqrtx"
		size = 476
		refs = "0020 __fdtest 003e __real@0000000000000000 0067 __fperrraise 007b __FNan_C 00d8 _sqrtf 00f6 __fdxp_setw 0127 __fdxp_movx 0130 __real@bf000000 0140 __fdxp_mulh 015c __fdxp_mulx 0181 __real@3fc00000 0191 __fdxp_addh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 83 7D 0C 00 75 05 E9 C2 01 00 00 B8 04 00 00 00 6B C8 00 03 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 0F BF D0 85 D2 7D 1B B8 04 00 00 00 6B C8 00 8B 55 08 D9 04 0A DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 3E B8 04 00 00 00 6B C8 00 8B 55 08 D9 04 0A DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 1E 6A 01 E8 ?? ?? ?? ?? 83 C4 04 B8 04 00 00 00 6B C8 00 8B 55 08 D9 05 ?? ?? ?? ?? D9 1C 0A E9 4E 01 00 00 8B 45 10 89 45 FC 8B 4D 0C 8B 55 10 8D 04 8A 89 45 F8 8B 4D 0C 8B 55 F8 8D 04 8A 89 45 F4 B9 04 00 00 00 6B D1 00 8B 45 08 D9 04 10 D9 5D F0 83 7D 0C 01 7E 14 B9 04 00 00 00 C1 E1 00 D9 45 F0 8B 55 08 D8 04 0A D9 5D F0 51 D9 45 F0 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D9 E8 DE F1 D9 5D E8 D9 45 E8 51 D9 1C 24 8B 45 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 0C C7 45 EC 02 00 00 00 EB 08 8B 55 EC D1 E2 89 55 EC 8B 45 EC 3B 45 0C 0F 8D 9F 00 00 00 8B 4D F8 51 8B 55 0C 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 D9 05 ?? ?? ?? ?? D9 1C 24 8B 4D 0C 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F4 50 8B 4D 0C 51 8B 55 08 52 8B 45 0C 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 F4 52 8B 45 0C 50 8B 4D F8 51 8B 55 0C 52 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 10 D9 05 ?? ?? ?? ?? D9 1C 24 8B 4D 0C 51 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 F4 50 8B 4D 0C 51 8B 55 FC 52 8B 45 0C 50 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 14 E9 4D FF FF FF 8B 55 F4 52 8B 45 0C 50 8B 4D F8 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_10_0 {
	meta:
		name = "__fdxp_subx"
		size = 92
		refs = "004c __fdxp_addh"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 8B 4D FC 3B 4D 14 7D 35 8B 55 FC 8B 45 10 D9 04 90 D9 EE DA E9 DF E0 F6 C4 44 7B 21 8B 4D FC 8B 55 10 D9 04 8A D9 E0 51 D9 1C 24 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C EB BA 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_11_0 {
	meta:
		name = "_fmaf"
		size = 836
		refs = "0009 ___security_cookie 0014 ___fma3_is_available 0031 _intrinsic_fma 0058 __fdunscale 0153 __fperrraise 015c __FNan_C 023f __fdscale 0253 __fdxp_setw 0299 __fdxp_mulh 02f7 __fdxp_addx 0319 __fdxp_getw 033c @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 68 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 3D ?? ?? ?? ?? 00 74 22 51 D9 45 10 D9 1C 24 51 D9 45 0C D9 1C 24 51 D9 45 08 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 0C E9 F9 02 00 00 D9 45 08 D9 5D BC D9 45 0C D9 5D B8 D9 45 10 D9 5D C8 8D 45 BC 50 8D 4D C4 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 D4 0F BF 55 D4 83 FA 02 75 0D D9 45 08 E9 C2 02 00 00 E9 BD 02 00 00 8D 45 B8 50 8D 4D C0 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 D0 0F BF 55 D0 83 FA 02 75 0D D9 45 0C E9 98 02 00 00 E9 93 02 00 00 8D 45 C8 50 8D 4D D8 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 CC 0F BF 55 CC 83 FA 02 75 0D D9 45 10 E9 6E 02 00 00 E9 69 02 00 00 0F BF 45 D4 83 F8 01 74 0D 0F BF 4D D0 83 F9 01 0F 85 87 00 00 00 0F BF 55 D4 85 D2 74 65 0F BF 45 D0 85 C0 74 5D 0F BF 4D CC 83 F9 01 75 3E BA 02 00 00 00 C1 E2 00 0F B7 44 15 08 25 00 80 00 00 B9 02 00 00 00 C1 E1 00 0F B7 54 0D 0C 81 E2 00 80 00 00 33 C2 B9 02 00 00 00 C1 E1 00 0F B7 54 0D 10 81 E2 00 80 00 00 3B C2 75 16 D9 45 08 D8 4D 0C D8 45 10 D9 5D B0 D9 45 B0 E9 E8 01 00 00 EB 15 6A 01 E8 ?? ?? ?? ?? 83 C4 04 D9 05 ?? ?? ?? ?? E9 D1 01 00 00 E9 CC 01 00 00 0F BF 45 CC 83 F8 01 75 0D D9 45 10 E9 BB 01 00 00 E9 B6 01 00 00 0F BF 4D D4 85 C9 74 10 0F BF 55 D0 85 D2 74 08 0F BF 45 CC 85 C0 75 19 D9 45 08 D8 4D 0C D8 45 10 D9 5D AC D9 45 AC E9 8A 01 00 00 E9 85 01 00 00 0F BF 4D C4 0F BF 55 C0 03 CA 89 4D B4 0F BF 45 B4 0F BF 4D D8 2B C8 66 89 4D D8 BA 02 00 00 00 C1 E2 00 0F B7 44 15 08 25 00 80 00 00 B9 02 00 00 00 C1 E1 00 0F B7 54 0D 0C 81 E2 00 80 00 00 33 C2 B9 02 00 00 00 C1 E1 00 0F B7 54 0D 10 81 E2 00 80 00 00 33 C2 74 12 0F BF 45 D8 83 F8 FE 7C 09 0F BF 4D D8 83 F9 02 7E 19 D9 45 08 D8 4D 0C D8 45 10 D9 5D A8 D9 45 A8 E9 06 01 00 00 E9 01 01 00 00 0F BF 55 D8 52 8D 45 C8 50 E8 ?? ?? ?? ?? 83 C4 04 D9 45 BC D9 1C 24 6A 04 8D 4D EC 51 E8 ?? ?? ?? ?? 83 C4 08 D9 45 B8 D9 1C 24 6A 02 8D 55 A0 52 E8 ?? ?? ?? ?? 83 C4 08 D9 45 C8 D9 1C 24 6A 02 8D 45 98 50 E8 ?? ?? ?? ?? 83 C4 0C B9 04 00 00 00 6B D1 00 51 D9 44 15 A0 D9 1C 24 6A 04 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C B9 04 00 00 00 C1 E1 00 D9 44 0D A0 D9 EE DA E9 DF E0 F6 C4 44 7B 47 51 D9 45 BC D9 1C 24 6A 04 8D 55 DC 52 E8 ?? ?? ?? ?? 83 C4 0C B8 04 00 00 00 C1 E0 00 51 D9 44 05 A0 D9 1C 24 6A 04 8D 4D DC 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 8D 55 DC 52 6A 04 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 10 6A 02 8D 4D 98 51 6A 04 8D 55 EC 52 E8 ?? ?? ?? ?? 83 C4 10 6A 04 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 08 D9 5D C8 8B 4D B4 51 8D 55 C8 52 E8 ?? ?? ?? ?? 83 C4 08 D9 45 C8 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_46_12_0 {
	meta:
		name = "_intrinsic_fma"
		size = 115
	strings:
		$1 = { 8B FF 53 8B DC 83 EC 08 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 83 EC 40 F3 0F 10 43 08 0F 57 C9 F3 0F 10 C8 0F 29 4D D0 F3 0F 10 43 0C 0F 57 C9 F3 0F 10 C8 0F 29 4D E0 F3 0F 10 43 10 0F 57 C9 F3 0F 10 C8 0F 29 4D F0 0F 28 45 F0 0F 28 4D E0 0F 28 55 D0 C4 E2 71 A9 D0 0F 29 55 C0 B8 04 00 00 00 6B C8 00 D9 44 0D C0 8B E5 5D 8B E3 5B C3 }
	condition:
		$1
}

rule file_46_13_0 {
	meta:
		name = "_ldexpf"
		size = 37
		refs = "0014 _ldexp"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 50 D9 45 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_5_0 {
	meta:
		name = "__mbsrchr_l"
		size = 206
		refs = "0014 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0027 ??_C@_1BO@JMOFMIDF@?$AAs?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 002c ??_C@_1HA@PKBIDOBK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0032 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 003d __CrtDbgReportW 004b __errno 0054 ??_C@_1BG@JBLBIELB@?$AA_?$AAm?$AAb?$AAs?$AAr?$AAc?$AAh?$AAr?$AA_?$AAl?$AA?$AA@ 0060 __invalid_parameter 0076 _strrchr"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 4D F0 53 56 57 FF 75 10 33 F6 E8 ?? ?? ?? ?? 8B 4D 08 33 C0 85 C9 0F 95 C0 85 C0 75 43 BF ?? ?? ?? ?? BB ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 56 6A 35 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 6A 35 53 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 4C 8B 7D F8 39 77 08 75 0F FF 75 0C 51 E8 ?? ?? ?? ?? 59 59 8B F0 EB 35 8A 19 0F B6 D3 F6 44 3A 19 04 74 1D 41 8A 19 84 DB 74 12 C1 E2 08 0F B6 C3 0B D0 39 55 0C 75 10 8D 71 FF EB 0B 85 F6 EB 03 39 55 0C 75 02 8B F1 41 84 DB 75 CB 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_48_4_0 {
	meta:
		name = "__wcsnicoll"
		size = 595
		refs = "0009 ___acrt_locale_changed 003b ??_C@_1CI@CCKDLILB@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0040 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0049 ??_C@_1GG@MDOKJCAE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0050 __CrtDbgReportW 0064 __errno 0078 ??_C@_1BG@PCPANGGF@?$AA_?$AAw?$AAc?$AAs?$AAn?$AAi?$AAc?$AAo?$AAl?$AAl?$AA?$AA@ 0082 __invalid_parameter 00b6 ??_C@_1CI@NAPEFFEJ@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0134 ??_C@_1CC@JLPHKJPH@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 0248 __wcsnicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 0F 85 21 02 00 00 83 7D 08 00 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 4D F4 89 4D F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 6A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 BC 01 00 00 83 7D 0C 00 74 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 45 EC 89 45 E8 83 7D E8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 6B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 41 01 00 00 81 7D 10 FF FF FF 7F 77 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 55 E4 89 55 E0 83 7D E0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 6C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 6C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 C3 00 00 00 8B 4D 08 0F B7 11 83 FA 41 7C 19 8B 45 08 0F B7 08 83 F9 5A 7F 0E 8B 55 08 0F B7 02 83 C0 20 89 45 DC EB 09 8B 4D 08 0F B7 11 89 55 DC 66 8B 45 DC 66 89 45 FC 8B 4D 0C 0F B7 11 83 FA 41 7C 19 8B 45 0C 0F B7 08 83 F9 5A 7F 0E 8B 55 0C 0F B7 02 83 C0 20 89 45 D8 EB 09 8B 4D 0C 0F B7 11 89 55 D8 66 8B 45 D8 66 89 45 F8 8B 4D 08 83 C1 02 89 4D 08 8B 55 0C 83 C2 02 89 55 0C 8B 45 10 83 E8 01 89 45 10 74 18 0F B7 4D FC 85 C9 74 10 0F B7 55 FC 0F B7 45 F8 3B D0 0F 84 61 FF FF FF 0F B7 45 FC 0F B7 4D F8 2B C1 EB 18 EB 16 6A 00 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_48_5_0 {
	meta:
		name = "__wcsnicoll_l"
		size = 741
		refs = "0038 ??_C@_1CI@CCKDLILB@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 003d ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0046 ??_C@_1GG@MDOKJCAE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 004d __CrtDbgReportW 0061 __errno 0075 ??_C@_1BK@EONLMOKH@?$AA_?$AAw?$AAc?$AAs?$AAn?$AAi?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 007f __invalid_parameter 00b3 ??_C@_1CI@NAPEFFEJ@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0131 ??_C@_1CC@JLPHKJPH@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 0191 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0199 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0265 ??1_LocaleUpdate@@QAE@XZ 029e ___acrt_CompareStringW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 48 83 7D 10 00 75 07 33 C0 E9 CC 02 00 00 83 7D 08 00 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 3A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 51 02 00 00 83 7D 0C 00 74 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 55 EC 89 55 E8 83 7D E8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 3B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 D6 01 00 00 81 7D 10 FF FF FF 7F 77 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D E0 83 7D E0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 3C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 3C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 58 01 00 00 8B 45 14 50 8D 4D B8 E8 ?? ?? ?? ?? 8D 4D B8 E8 ?? ?? ?? ?? 8B 08 BA 04 00 00 00 C1 E2 00 83 BC 11 A0 00 00 00 00 0F 85 B9 00 00 00 8B 45 08 0F B7 08 83 F9 41 7C 19 8B 55 08 0F B7 02 83 F8 5A 7F 0E 8B 4D 08 0F B7 11 83 C2 20 89 55 DC EB 09 8B 45 08 0F B7 08 89 4D DC 66 8B 55 DC 66 89 55 FC 8B 45 0C 0F B7 08 83 F9 41 7C 19 8B 55 0C 0F B7 02 83 F8 5A 7F 0E 8B 4D 0C 0F B7 11 83 C2 20 89 55 D8 EB 09 8B 45 0C 0F B7 08 89 4D D8 66 8B 55 D8 66 89 55 F8 8B 45 08 83 C0 02 89 45 08 8B 4D 0C 83 C1 02 89 4D 0C 8B 55 10 83 EA 01 89 55 10 74 18 0F B7 45 FC 85 C0 74 10 0F B7 4D FC 0F B7 55 F8 3B CA 0F 84 61 FF FF FF 0F B7 45 FC 0F B7 4D F8 2B C1 89 45 D0 8D 4D B8 E8 ?? ?? ?? ?? 8B 45 D0 EB 73 8B 55 10 52 8B 45 0C 50 8B 4D 10 51 8B 55 08 52 68 01 10 00 00 8D 4D B8 E8 ?? ?? ?? ?? 8B 00 B9 04 00 00 00 C1 E1 00 8B 94 08 A0 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 18 89 45 D4 83 7D D4 00 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 CC FF FF FF 7F 8D 4D B8 E8 ?? ?? ?? ?? 8B 45 CC EB 14 8B 45 D4 83 E8 02 89 45 C8 8D 4D B8 E8 ?? ?? ?? ?? 8B 45 C8 8B E5 5D C3 }
	condition:
		$1
}

rule file_49_4_0 {
	meta:
		name = "__strnicoll"
		size = 65
		refs = "0006 ___acrt_locale_changed 001e __strnicmp 0038 __strnicoll_l"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 18 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C EB 18 EB 16 6A 00 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_49_5_0 {
	meta:
		name = "__strnicoll_l"
		size = 678
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0025 ??1_LocaleUpdate@@QAE@XZ 0054 ??_C@_1CI@CCKDLILB@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0059 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0062 ??_C@_1GG@LACFCIFA@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0069 __CrtDbgReportW 007d __errno 0091 ??_C@_1BK@IOJEBPLP@?$AA_?$AAs?$AAt?$AAr?$AAn?$AAi?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 009b __invalid_parameter 00dc ??_C@_1CI@NAPEFFEJ@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0167 ??_C@_1CC@JLPHKJPH@?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 01d0 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 01fe __strnicmp_l 025f ___acrt_CompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 48 8B 45 14 50 8D 4D B8 E8 ?? ?? ?? ?? 83 7D 10 00 75 17 C7 45 E0 00 00 00 00 8D 4D B8 E8 ?? ?? ?? ?? 8B 45 E0 E9 71 02 00 00 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 4D FC 89 4D F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 37 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 37 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 DC FF FF FF 7F 8D 4D B8 E8 ?? ?? ?? ?? 8B 45 DC E9 E9 01 00 00 83 7D 0C 00 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 38 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 38 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D8 FF FF FF 7F 8D 4D B8 E8 ?? ?? ?? ?? 8B 45 D8 E9 61 01 00 00 81 7D 10 FF FF FF 7F 77 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 55 EC 89 55 E8 83 7D E8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 39 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E8 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 39 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 D4 FF FF FF 7F 8D 4D B8 E8 ?? ?? ?? ?? 8B 45 D4 E9 D6 00 00 00 8D 4D B8 E8 ?? ?? ?? ?? 8B 08 BA 04 00 00 00 C1 E2 00 83 BC 11 A0 00 00 00 00 75 30 8D 4D B8 E8 ?? ?? ?? ?? 50 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 89 45 D0 8D 4D B8 E8 ?? ?? ?? ?? 8B 45 D0 E9 8A 00 00 00 8D 4D B8 E8 ?? ?? ?? ?? 8B 00 8B 48 10 51 8B 55 10 52 8B 45 0C 50 8B 4D 10 51 8B 55 08 52 68 01 10 00 00 8D 4D B8 E8 ?? ?? ?? ?? 8B 00 B9 04 00 00 00 C1 E1 00 8B 94 08 A0 00 00 00 52 8D 4D B8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 E4 83 7D E4 00 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 CC FF FF FF 7F 8D 4D B8 E8 ?? ?? ?? ?? 8B 45 CC EB 14 8B 45 E4 83 E8 02 89 45 C8 8D 4D B8 E8 ?? ?? ?? ?? 8B 45 C8 8B E5 5D C3 }
	condition:
		$1
}

rule file_51_5_0 {
	meta:
		name = "__mbsnbset_l"
		size = 283
		refs = "0018 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 002e __strnset 0048 ??_C@_1EA@MFKLBHOB@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 004d ??_C@_1HC@DGGOBGOB@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0053 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 005e __CrtDbgReportW 006c __errno 0075 ??_C@_1BI@CEPLNFIK@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAb?$AAs?$AAe?$AAt?$AA_?$AAl?$AA?$AA@ 0081 __invalid_parameter 009b ??_C@_1FG@HBOFIKMC@?$AA?$CI?$AA?$CC?$AAi?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAM?$AAB?$AAC?$AAS?$AA?5?$AAp?$AAa?$AAi?$AAr?$AA?5?$AAp?$AAa?$AAs?$AAs?$AAe?$AAd?$AA?5?$AAt?$AAo?$AA?5?$AAm?$AAb@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 53 56 8B 75 08 8D 4D EC 57 FF 75 14 89 75 FC E8 ?? ?? ?? ?? 8B 45 F4 33 DB 39 58 08 75 16 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 8B D8 E9 C6 00 00 00 8B 7D 10 85 F6 75 47 85 FF 74 43 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 53 6A 49 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 6A 49 57 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 78 8B 4D 0C 8B D1 C1 EA 08 84 D2 74 65 84 C9 75 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 6A 59 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? B2 20 8A CA C7 00 16 00 00 00 EB 1B 38 1E 74 2E 8D 47 FF 83 EF 02 85 C0 74 13 38 5E 01 74 0E 88 16 88 4E 01 83 C6 02 85 FF 75 E1 EB 11 C6 06 20 EB 0C 4F 38 1E 74 07 88 0E 46 85 FF 75 F4 8B 5D FC 80 7D F8 00 74 0A 8B 4D EC 83 A1 50 03 00 00 FD 5F 5E 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_1_0 {
	meta:
		name = "?shortsort@@YAXPAD0IP6AHPBX1@Z@Z"
		size = 203
		refs = "0008 __ehhandler$?shortsort@@YAXPAD0IP6AHPBX1@Z@Z 0017 ___security_cookie 006e ___guard_check_icall_fptr 0091 ?swap@@YAXPAD0I@Z 00ae ??1scoped_global_state_reset@__crt_state_management@@QAE@XZ 00c3 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 F0 50 8D 45 F4 64 A3 00 00 00 00 C7 45 FC 00 00 00 00 8B 45 0C 3B 45 08 76 6A 8B 4D 08 89 4D E4 8B 55 08 03 55 10 89 55 EC EB 09 8B 45 EC 03 45 10 89 45 EC 8B 4D EC 3B 4D 0C 77 29 8B 55 E4 52 8B 45 EC 50 8B 4D 14 89 4D E0 8B 4D E0 FF 15 ?? ?? ?? ?? FF 55 E0 83 C4 08 85 C0 7E 06 8B 55 EC 89 55 E4 EB C6 8B 45 10 50 8B 4D 0C 51 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 0C 2B 45 10 89 45 0C EB 8E C7 45 FC FF FF FF FF 8D 4D EB E8 ?? ?? ?? ?? 8B 4D F4 64 89 0D 00 00 00 00 59 8B 4D F0 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_3_0 {
	meta:
		name = "__ehhandler$?shortsort@@YAXPAD0IP6AHPBX1@Z@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?shortsort@@YAXPAD0IP6AHPBX1@Z@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_734_3_0 {
	meta:
		name = "__ehhandler$?shortsort_s@@YAXPAD0IP6AHPAXPBX2@ZQAX@Z"
		size = 37
		refs = "000d @__security_check_cookie@4 001c __ehfuncinfo$?shortsort_s@@YAXPAD0IP6AHPAXPBX2@ZQAX@Z 0021 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A E8 33 C8 E8 ?? ?? ?? ?? 8B 4A FC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_52_4_0 {
	meta:
		name = "?swap@@YAXPAD0I@Z"
		size = 87
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 08 3B 45 0C 74 43 8B 4D 10 89 4D F8 8B 55 10 83 EA 01 89 55 10 83 7D F8 00 74 2E 8B 45 08 8A 08 88 4D FF 8B 55 08 8B 45 0C 8A 08 88 0A 8B 55 08 83 C2 01 89 55 08 8B 45 0C 8A 4D FF 88 08 8B 55 0C 83 C2 01 89 55 0C EB BD 8B E5 5D C3 }
	condition:
		$1
}

rule file_52_5_0 {
	meta:
		name = "_qsort"
		size = 1662
		refs = "000c ___security_cookie 004d ??_C@_1DI@OOEEHOBJ@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAn?$AAu?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0052 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 005e ??_C@_1GA@KPPCKKGE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0065 __CrtDbgReportW 007c __errno 0093 ??_C@_1M@INMHODIG@?$AAq?$AAs?$AAo?$AAr?$AAt?$AA?$AA@ 009d __invalid_parameter 00db ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0169 ??_C@_1CA@LIDFOMIN@?$AAc?$AAo?$AAm?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0230 ?shortsort@@YAXPAD0IP6AHPBX1@Z@Z 0273 ___guard_check_icall_fptr 0297 ?swap@@YAXPAD0I@Z 0676 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 48 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 08 00 75 12 83 7D 0C 00 74 0C C7 85 F0 FE FF FF 00 00 00 00 EB 0A C7 85 F0 FE FF FF 01 00 00 00 8B 85 F0 FE FF FF 89 85 EC FE FF FF 83 BD EC FE FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AC 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD EC FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 AC 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 C7 05 00 00 83 7D 10 00 76 0C C7 85 E8 FE FF FF 01 00 00 00 EB 0A C7 85 E8 FE FF FF 00 00 00 00 8B 95 E8 FE FF FF 89 95 E4 FE FF FF 83 BD E4 FE FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AD 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD E4 FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 AD 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 39 05 00 00 83 7D 14 00 74 0C C7 85 E0 FE FF FF 01 00 00 00 EB 0A C7 85 E0 FE FF FF 00 00 00 00 8B 8D E0 FE FF FF 89 8D DC FE FF FF 83 BD DC FE FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AE 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD DC FE FF FF 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 AE 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 E9 AB 04 00 00 C7 85 F4 FE FF FF 00 00 00 00 83 7D 0C 02 73 05 E9 96 04 00 00 8B 45 08 89 85 FC FE FF FF 8B 4D 0C 83 E9 01 0F AF 4D 10 03 4D 08 89 8D F8 FE FF FF 8B 85 F8 FE FF FF 2B 85 FC FE FF FF 33 D2 F7 75 10 83 C0 01 89 85 D8 FE FF FF 83 BD D8 FE FF FF 08 77 23 8B 55 14 52 8B 45 10 50 8B 8D F8 FE FF FF 51 8B 95 FC FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 10 E9 FB 03 00 00 8B 85 D8 FE FF FF D1 E8 0F AF 45 10 03 85 FC FE FF FF 89 85 04 FF FF FF 8B 8D 04 FF FF FF 51 8B 95 FC FE FF FF 52 8B 45 14 89 85 D4 FE FF FF 8B 8D D4 FE FF FF FF 15 ?? ?? ?? ?? FF 95 D4 FE FF FF 83 C4 08 85 C0 7E 1A 8B 4D 10 51 8B 95 04 FF FF FF 52 8B 85 FC FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 8D F8 FE FF FF 51 8B 95 FC FE FF FF 52 8B 45 14 89 85 D0 FE FF FF 8B 8D D0 FE FF FF FF 15 ?? ?? ?? ?? FF 95 D0 FE FF FF 83 C4 08 85 C0 7E 1A 8B 4D 10 51 8B 95 F8 FE FF FF 52 8B 85 FC FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 8D F8 FE FF FF 51 8B 95 04 FF FF FF 52 8B 45 14 89 85 CC FE FF FF 8B 8D CC FE FF FF FF 15 ?? ?? ?? ?? FF 95 CC FE FF FF 83 C4 08 85 C0 7E 1A 8B 4D 10 51 8B 95 F8 FE FF FF 52 8B 85 04 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 8D FC FE FF FF 89 8D 00 FF FF FF 8B 95 F8 FE FF FF 89 95 08 FF FF FF 8B 85 04 FF FF FF 3B 85 00 FF FF FF 76 4D 8B 8D 00 FF FF FF 03 4D 10 89 8D 00 FF FF FF 8B 95 00 FF FF FF 3B 95 04 FF FF FF 73 30 8B 85 04 FF FF FF 50 8B 8D 00 FF FF FF 51 8B 55 14 89 95 C8 FE FF FF 8B 8D C8 FE FF FF FF 15 ?? ?? ?? ?? FF 95 C8 FE FF FF 83 C4 08 85 C0 7E B3 8B 85 04 FF FF FF 3B 85 00 FF FF FF 77 4D 8B 8D 00 FF FF FF 03 4D 10 89 8D 00 FF FF FF 8B 95 00 FF FF FF 3B 95 F8 FE FF FF 77 30 8B 85 04 FF FF FF 50 8B 8D 00 FF FF FF 51 8B 55 14 89 95 C4 FE FF FF 8B 8D C4 FE FF FF FF 15 ?? ?? ?? ?? FF 95 C4 FE FF FF 83 C4 08 85 C0 7E B3 8B 85 08 FF FF FF 2B 45 10 89 85 08 FF FF FF 8B 8D 08 FF FF FF 3B 8D 04 FF FF FF 76 30 8B 95 04 FF FF FF 52 8B 85 08 FF FF FF 50 8B 4D 14 89 8D C0 FE FF FF 8B 8D C0 FE FF FF FF 15 ?? ?? ?? ?? FF 95 C0 FE FF FF 83 C4 08 85 C0 7F B3 8B 95 08 FF FF FF 3B 95 00 FF FF FF 73 02 EB 39 8B 45 10 50 8B 8D 08 FF FF FF 51 8B 95 00 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 8B 85 04 FF FF FF 3B 85 08 FF FF FF 75 0C 8B 8D 00 FF FF FF 89 8D 04 FF FF FF E9 B4 FE FF FF 8B 95 08 FF FF FF 03 55 10 89 95 08 FF FF FF 8B 85 04 FF FF FF 3B 85 08 FF FF FF 73 4D 8B 8D 08 FF FF FF 2B 4D 10 89 8D 08 FF FF FF 8B 95 08 FF FF FF 3B 95 04 FF FF FF 76 30 8B 85 04 FF FF FF 50 8B 8D 08 FF FF FF 51 8B 55 14 89 95 BC FE FF FF 8B 8D BC FE FF FF FF 15 ?? ?? ?? ?? FF 95 BC FE FF FF 83 C4 08 85 C0 74 B3 8B 85 04 FF FF FF 3B 85 08 FF FF FF 72 4D 8B 8D 08 FF FF FF 2B 4D 10 89 8D 08 FF FF FF 8B 95 08 FF FF FF 3B 95 FC FE FF FF 76 30 8B 85 04 FF FF FF 50 8B 8D 08 FF FF FF 51 8B 55 14 89 95 B8 FE FF FF 8B 8D B8 FE FF FF FF 15 ?? ?? ?? ?? FF 95 B8 FE FF FF 83 C4 08 85 C0 74 B3 8B 85 08 FF FF FF 2B 85 FC FE FF FF 8B 8D F8 FE FF FF 2B 8D 00 FF FF FF 3B C1 7C 61 8B 95 FC FE FF FF 3B 95 08 FF FF FF 73 32 8B 85 F4 FE FF FF 8B 8D FC FE FF FF 89 4C 85 84 8B 95 F4 FE FF FF 8B 85 08 FF FF FF 89 84 95 0C FF FF FF 8B 8D F4 FE FF FF 83 C1 01 89 8D F4 FE FF FF 8B 95 00 FF FF FF 3B 95 F8 FE FF FF 73 11 8B 85 00 FF FF FF 89 85 FC FE FF FF E9 20 FC FF FF EB 5F 8B 8D 00 FF FF FF 3B 8D F8 FE FF FF 73 32 8B 95 F4 FE FF FF 8B 85 00 FF FF FF 89 44 95 84 8B 8D F4 FE FF FF 8B 95 F8 FE FF FF 89 94 8D 0C FF FF FF 8B 85 F4 FE FF FF 83 C0 01 89 85 F4 FE FF FF 8B 8D FC FE FF FF 3B 8D 08 FF FF FF 73 11 8B 95 08 FF FF FF 89 95 F8 FE FF FF E9 BF FB FF FF 8B 85 F4 FE FF FF 83 E8 01 89 85 F4 FE FF FF 78 28 8B 8D F4 FE FF FF 8B 54 8D 84 89 95 FC FE FF FF 8B 85 F4 FE FF FF 8B 8C 85 0C FF FF FF 89 8D F8 FE FF FF E9 86 FB FF FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_54_2_0 {
	meta:
		name = "??$common_spawnvp@D@@YAHHQBDQBQBD1@Z"
		size = 1035
		refs = "0009 ___security_cookie 0033 ??_C@_1CK@LLOEFJJG@?$AAf?$AAi?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 003b ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0043 ??_C@_1GI@GEHJNBCG@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 004b __CrtDbgReportW 0059 __errno 0062 ??_C@_1BO@CDMOPAOF@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAs?$AAp?$AAa?$AAw?$AAn?$AAv?$AAp?$AA?$AA@ 006e __invalid_parameter 0089 ??_C@_1CK@EAMJNHLM@?$AAf?$AAi?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA?$FL?$AA0?$AA?$FN?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 00c4 ??_C@_1CK@NHACCAAN@?$AAa?$AAr?$AAg?$AAu?$AAm?$AAe?$AAn?$AAt?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0104 ??_C@_1DA@COHBDGKD@?$AAa?$AAr?$AAg?$AAu?$AAm?$AAe?$AAn?$AAt?$AAs?$AA?$FL?$AA0?$AA?$FN?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0142 ??_C@_1DA@NFFMLIIJ@?$AAa?$AAr?$AAg?$AAu?$AAm?$AAe?$AAn?$AAt?$AAs?$AA?$FL?$AA0?$AA?$FN?$AA?$FL?$AA0?$AA?$FN?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 018e __spawnve 01ae _strchr 01d7 ??_C@_0DC@GGIGALME@minkernel?2crts?2ucrt?2inc?2corecrt_@ 01f4 __dupenv_s_dbg 021b ??_C@_0DE@LHFJJMOO@minkernel?2crts?2ucrt?2src?2desktopc@ 0229 __calloc_dbg 0267 _strrchr 0290 _strcat_s 0314 ___doserrno 0379 ___acrt_getpath 0392 __free_dbg 03c3 @__security_check_cookie@4 03d9 ??_C@_1GK@DAAANMIF@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?0?$AA?5?$AA2?$AA6@ 03ed ??_C@_1FM@KAJIDENI@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?0?$AA?5?$AA2?$AA6@ 0401 ??_C@_1IO@HPGIPPPF@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAc?$AAr?$AAt?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA_?$AAv?$AAa?$AAl?$AAu?$AAe@ 0406 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 14 53 56 8B 75 0C 89 45 E4 33 C0 85 F6 89 75 DC 57 8B 7D 10 0F 95 C0 89 7D D4 85 C0 75 4B BF ?? ?? ?? ?? 33 DB 57 68 ?? ?? ?? ?? 53 6A 1F BE ?? ?? ?? ?? 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 6A 1F 56 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 3D 03 00 00 33 C0 38 06 0F 95 C0 85 C0 75 30 BF ?? ?? ?? ?? 33 DB 57 68 ?? ?? ?? ?? 53 6A 20 BE ?? ?? ?? ?? 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 6A 20 EB A8 33 C0 85 FF 0F 95 C0 85 C0 75 33 BF ?? ?? ?? ?? 33 DB 57 68 ?? ?? ?? ?? 53 6A 21 BE ?? ?? ?? ?? 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 6A 21 E9 6A FF FF FF 8B 0F 33 C0 85 C9 0F 95 C0 85 C0 75 33 BF ?? ?? ?? ?? 33 DB 57 68 ?? ?? ?? ?? 53 6A 22 BE ?? ?? ?? ?? 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 6A 22 E9 2A FF FF FF 33 C0 38 01 0F 95 C0 85 C0 75 33 BF ?? ?? ?? ?? 33 DB 57 68 ?? ?? ?? ?? 53 6A 23 BE ?? ?? ?? ?? 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 6A 23 E9 EC FE FF FF E8 ?? ?? ?? ?? FF 75 E4 33 DB 89 45 D0 57 8B 08 56 FF 75 08 89 4D CC 89 18 E8 ?? ?? ?? ?? 8B F8 83 C4 10 83 FF FF 0F 85 08 02 00 00 E8 ?? ?? ?? ?? 83 38 02 75 22 6A 5C 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 14 6A 2F 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 06 80 7E 01 3A 75 08 83 CF FF E9 D4 01 00 00 6A 6A 68 ?? ?? ?? ?? 6A 02 8D 45 F4 C7 45 F4 50 41 54 48 50 8D 45 E8 88 5D F8 53 50 89 5D E8 E8 ?? ?? ?? ?? 8B 4D E8 83 C4 18 85 C0 74 0A 83 F8 16 75 09 E9 E7 01 00 00 85 C9 75 08 83 CF FF E9 83 01 00 00 6A 4B 68 ?? ?? ?? ?? 6A 02 6A 01 68 04 01 00 00 E8 ?? ?? ?? ?? 8B F0 83 C4 14 85 F6 0F 84 51 01 00 00 68 03 01 00 00 56 FF 75 E8 E9 30 01 00 00 38 1E 0F 84 3B 01 00 00 8B CE 8D 51 01 8A 01 41 84 C0 75 F9 2B CA 8D 7E FF 6A 5C 56 03 F9 E8 ?? ?? ?? ?? 59 59 3B F8 74 2E 6A 2F 56 E8 ?? ?? ?? ?? 59 59 3B F8 74 20 8D 45 EC 66 C7 45 EC 5C 00 50 68 04 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 2C 01 00 00 8B FE 8D 4F 01 8A 07 47 84 C0 75 F9 2B F9 8B 4D DC 8B D1 8D 42 01 89 45 D8 8A 02 42 84 C0 75 F9 2B 55 D8 8D 04 3A BA 04 01 00 00 3B C2 0F 83 B9 00 00 00 51 52 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 FA 00 00 00 E8 ?? ?? ?? ?? FF 75 E4 FF 75 D4 89 18 56 FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 C4 10 83 FF FF 0F 85 85 00 00 00 E8 ?? ?? ?? ?? 83 38 02 74 5C E8 ?? ?? ?? ?? 83 38 15 74 52 6A 2F 56 E8 ?? ?? ?? ?? 59 59 3B C6 75 15 8D 7E 01 6A 2F 57 E8 ?? ?? ?? ?? C6 45 F3 01 59 59 3B C7 74 03 88 5D F3 6A 5C 56 E8 ?? ?? ?? ?? 59 59 3B C6 75 13 8D 7E 01 6A 5C 57 E8 ?? ?? ?? ?? 59 3B C7 B0 01 59 74 02 8A C3 38 5D F3 75 04 84 C0 74 1C 68 03 01 00 00 56 FF 75 E0 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E0 85 C0 0F 85 BD FE FF FF 83 CF FF 6A 02 56 E8 ?? ?? ?? ?? 59 59 8B 4D E8 6A 02 51 E8 ?? ?? ?? ?? 59 59 89 5D E8 8B 45 D0 39 18 75 09 8B 4D CC 85 C9 74 02 89 08 8B C7 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 53 6A 5C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 26 53 6A 66 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 12 53 6A 44 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_54_3_0 {
	meta:
		name = "??$common_spawnvp@_W@@YAHHQB_WQBQB_W1@Z"
		size = 1084
		refs = "0009 ___security_cookie 0035 ??_C@_1CK@LLOEFJJG@?$AAf?$AAi?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 003a ??_C@_1GI@GEHJNBCG@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0040 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004b __CrtDbgReportW 0059 __errno 0062 ??_C@_1BO@CDMOPAOF@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAs?$AAp?$AAa?$AAw?$AAn?$AAv?$AAp?$AA?$AA@ 006e __invalid_parameter 008a ??_C@_1CK@EAMJNHLM@?$AAf?$AAi?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA?$FL?$AA0?$AA?$FN?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 00c3 ??_C@_1CK@NHACCAAN@?$AAa?$AAr?$AAg?$AAu?$AAm?$AAe?$AAn?$AAt?$AAs?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0101 ??_C@_1DA@COHBDGKD@?$AAa?$AAr?$AAg?$AAu?$AAm?$AAe?$AAn?$AAt?$AAs?$AA?$FL?$AA0?$AA?$FN?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 013e ??_C@_1DA@NFFMLIIJ@?$AAa?$AAr?$AAg?$AAu?$AAm?$AAe?$AAn?$AAt?$AAs?$AA?$FL?$AA0?$AA?$FN?$AA?$FL?$AA0?$AA?$FN?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 0186 __wspawnve 01a8 _wcschr 01f0 ??_C@_0DC@GGIGALME@minkernel?2crts?2ucrt?2inc?2corecrt_@ 0207 __wdupenv_s_dbg 022e ??_C@_0DE@LHFJJMOO@minkernel?2crts?2ucrt?2src?2desktopc@ 023c __calloc_dbg 0282 _wcsrchr 02b2 _wcscat_s 0342 ___doserrno 03ab ___acrt_wgetpath 03c4 __free_dbg 03f5 @__security_check_cookie@4 040a ??_C@_1GK@DAAANMIF@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?0?$AA?5?$AA2?$AA6@ 041e ??_C@_1FM@KAJIDENI@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAc?$AAs?$AAc?$AAa?$AAt?$AA_?$AAs?$AA?$CI?$AAf?$AAi?$AAl?$AAe?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?0?$AA?5?$AA2?$AA6@ 0432 ??_C@_1IO@HPGIPPPF@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAc?$AAr?$AAt?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA_?$AAv?$AAa?$AAl?$AAu?$AAe@ 0437 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 14 53 56 8B 75 0C 89 45 E0 33 C0 85 F6 89 75 D8 57 8B 7D 10 0F 95 C0 33 DB 89 7D D0 85 C0 75 49 BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 53 6A 1F 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 6A 1F 56 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 6F 03 00 00 33 C0 66 39 1E 0F 95 C0 85 C0 75 2E BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 53 6A 20 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 6A 20 EB A9 33 C0 85 FF 0F 95 C0 85 C0 75 31 BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 53 6A 21 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 6A 21 E9 6D FF FF FF 8B 0F 33 C0 85 C9 0F 95 C0 85 C0 75 31 BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 53 6A 22 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 6A 22 E9 2F FF FF FF 33 C0 66 39 19 0F 95 C0 85 C0 75 31 BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 53 6A 23 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 6A 23 E9 F2 FE FF FF E8 ?? ?? ?? ?? FF 75 E0 89 45 CC 57 8B 08 56 FF 75 08 89 4D C8 89 18 E8 ?? ?? ?? ?? 8B F8 83 C4 10 83 FF FF 0F 85 42 02 00 00 E8 ?? ?? ?? ?? 83 38 02 75 25 6A 5C 58 50 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 15 6A 2F 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 07 66 83 7E 02 3A 75 08 83 CF FF E9 0B 02 00 00 6A 50 58 6A 41 66 89 45 F0 58 6A 54 66 89 45 F2 58 6A 48 66 89 45 F4 58 6A 79 66 89 45 F6 33 C0 68 ?? ?? ?? ?? 66 89 45 F8 8D 45 F0 6A 02 50 8D 45 E8 89 5D E8 53 50 E8 ?? ?? ?? ?? 8B 4D E8 83 C4 18 85 C0 74 0A 83 F8 16 75 09 E9 05 02 00 00 85 C9 75 08 83 CF FF E9 A2 01 00 00 6A 4B 68 ?? ?? ?? ?? 6A 02 6A 02 68 04 01 00 00 E8 ?? ?? ?? ?? 8B F0 83 C4 14 85 F6 0F 84 70 01 00 00 68 03 01 00 00 56 FF 75 E8 E9 4F 01 00 00 66 39 1E 0F 84 59 01 00 00 8B CE 8D 51 02 66 8B 01 83 C1 02 66 3B C3 75 F5 2B CA 6A 5C D1 F9 58 49 50 56 8D 3C 4E E8 ?? ?? ?? ?? 59 59 3B F8 74 35 6A 2F 56 E8 ?? ?? ?? ?? 59 59 3B F8 74 27 6A 5C 33 C0 5F 66 89 45 E6 8D 45 E4 50 68 04 01 00 00 56 66 89 7D E4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 3C 01 00 00 8B FE 8D 4F 02 66 8B 07 83 C7 02 66 3B C3 75 F5 2B F9 8B 4D D8 8B D1 D1 FF 8D 42 02 89 45 D4 66 8B 02 83 C2 02 66 3B C3 75 F5 2B 55 D4 D1 FA 8D 04 3A BA 04 01 00 00 3B C2 0F 83 BD 00 00 00 51 52 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 FD 00 00 00 E8 ?? ?? ?? ?? FF 75 E0 FF 75 D0 89 18 56 FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 C4 10 83 FF FF 0F 85 89 00 00 00 E8 ?? ?? ?? ?? 83 38 02 74 60 E8 ?? ?? ?? ?? 83 38 15 74 56 6A 2F 56 E8 ?? ?? ?? ?? 59 59 3B C6 75 15 8D 7E 02 6A 2F 57 E8 ?? ?? ?? ?? C6 45 EF 01 59 59 3B C7 74 03 88 5D EF 6A 5C 58 50 56 E8 ?? ?? ?? ?? 59 59 3B C6 75 15 6A 5C 58 50 8D 7E 02 57 E8 ?? ?? ?? ?? 59 3B C7 B0 01 59 74 02 8A C3 38 5D EF 75 04 84 C0 74 1C 68 03 01 00 00 56 FF 75 DC E8 ?? ?? ?? ?? 83 C4 0C 89 45 DC 85 C0 0F 85 9E FE FF FF 83 CF FF 6A 02 56 E8 ?? ?? ?? ?? 59 59 8B 4D E8 6A 02 51 E8 ?? ?? ?? ?? 59 59 89 5D E8 8B 45 CC 39 18 75 09 8B 4D C8 85 C9 74 02 89 08 8B C7 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 53 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 26 53 6A 66 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 12 53 6A 44 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_54_4_0 {
	meta:
		name = "??$tcscat_s@AAPADHAAY01$$CBD@?$__crt_char_traits@D@@SAHAAPAD$$QAHAAY01$$CBD@Z"
		size = 28
		refs = "0013 _strcat_s"
		altNames = "??$tcscat_s@AAPADABIAAY01$$CBD@?$__crt_char_traits@D@@SAHAAPADABIAAY01$$CBD@Z ??$tcscat_s@PADABIAAY04$$CBD@?$__crt_char_traits@D@@SAH$$QAPADABIAAY04$$CBD@Z ??$tcscat_s@PADHAAY01$$CBD@?$__crt_char_traits@D@@SAH$$QAPAD$$QAHAAY01$$CBD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_243_16_0 {
	meta:
		name = "??$tcscat_s@AAPA_WABIAAY01$$CB_W@?$__crt_char_traits@_W@@SAHAAPA_WABIAAY01$$CB_W@Z"
		size = 28
		refs = "0013 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_54_6_3 {
	meta:
		name = "??$tcscat_s@AAPA_WHAAY01$$CB_W@?$__crt_char_traits@_W@@SAHAAPA_W$$QAHAAY01$$CB_W@Z"
		size = 28
		refs = "0013 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_262_25_4 {
	meta:
		name = "??$tcscat_s@PA_WABIAAY04$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAY04$$CB_W@Z"
		size = 28
		refs = "0013 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_262_27_4 {
	meta:
		name = "??$tcscat_s@PA_WHAAY01$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAHAAY01$$CB_W@Z"
		size = 28
		refs = "0013 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_243_19_4 {
	meta:
		name = "??$tcscpy_s@AAPADABIAAY0L@$$CBD@?$__crt_char_traits@D@@SAHAAPADABIAAY0L@$$CBD@Z"
		size = 28
		refs = "0013 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_678_19_4 {
	meta:
		name = "??$tcscpy_s@AAPADHAAY04$$CBD@?$__crt_char_traits@D@@SAHAAPAD$$QAHAAY04$$CBD@Z"
		size = 28
		refs = "0013 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_243_22_3 {
	meta:
		name = "??$tcscpy_s@AAPA_WABIAAY0L@$$CB_W@?$__crt_char_traits@_W@@SAHAAPA_WABIAAY0L@$$CB_W@Z"
		size = 28
		refs = "0013 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_678_20_2 {
	meta:
		name = "??$tcscpy_s@AAPA_WHAAY04$$CB_W@?$__crt_char_traits@_W@@SAHAAPA_W$$QAHAAY04$$CB_W@Z"
		size = 28
		refs = "0013 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_678_22_4 {
	meta:
		name = "??$tcscpy_s@PADABIAAY02$$CBD@?$__crt_char_traits@D@@SAH$$QAPADABIAAY02$$CBD@Z"
		size = 28
		refs = "0013 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_678_24_4 {
	meta:
		name = "??$tcscpy_s@PA_WABIAAY02$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAY02$$CB_W@Z"
		size = 28
		refs = "0013 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_54_5_0 {
	meta:
		name = "??$tcscat_s@AAPADHABQBD@?$__crt_char_traits@D@@SAHAAPAD$$QAHABQBD@Z"
		size = 30
		refs = "0015 _strcat_s"
		altNames = "??$tcscat_s@AAPADABIPAD@?$__crt_char_traits@D@@SAHAAPADABI$$QAPAD@Z ??$tcscat_s@PADABIABQBD@?$__crt_char_traits@D@@SAH$$QAPADABIABQBD@Z ??$tcscat_s@PADHABQBD@?$__crt_char_traits@D@@SAH$$QAPAD$$QAHABQBD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_243_17_3 {
	meta:
		name = "??$tcscat_s@AAPA_WABIPA_W@?$__crt_char_traits@_W@@SAHAAPA_WABI$$QAPA_W@Z"
		size = 30
		refs = "0015 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_54_7_0 {
	meta:
		name = "??$tcscat_s@AAPA_WHABQB_W@?$__crt_char_traits@_W@@SAHAAPA_W$$QAHABQB_W@Z"
		size = 30
		refs = "0015 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_262_26_3 {
	meta:
		name = "??$tcscat_s@PA_WABIABQB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIABQB_W@Z"
		size = 30
		refs = "0015 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_262_28_4 {
	meta:
		name = "??$tcscat_s@PA_WHABQB_W@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAHABQB_W@Z"
		size = 30
		refs = "0015 _wcscat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_243_18_2 {
	meta:
		name = "??$tcscpy_s@AAPADAAIABQBD@?$__crt_char_traits@D@@SAHAAPADAAIABQBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_664_18_2 {
	meta:
		name = "??$tcscpy_s@AAPADABIAAPAD@?$__crt_char_traits@D@@SAHAAPADABI0@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_583_14_0 {
	meta:
		name = "??$tcscpy_s@AAPADABIABQBD@?$__crt_char_traits@D@@SAHAAPADABIABQBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_8_0 {
	meta:
		name = "??$tcscpy_s@AAPADIABQBD@?$__crt_char_traits@D@@SAHAAPAD$$QAIABQBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_243_21_3 {
	meta:
		name = "??$tcscpy_s@AAPA_WAAIABQB_W@?$__crt_char_traits@_W@@SAHAAPA_WAAIABQB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_664_19_2 {
	meta:
		name = "??$tcscpy_s@AAPA_WABIAAPA_W@?$__crt_char_traits@_W@@SAHAAPA_WABI0@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_583_15_3 {
	meta:
		name = "??$tcscpy_s@AAPA_WABIABQB_W@?$__crt_char_traits@_W@@SAHAAPA_WABIABQB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_243_23_4 {
	meta:
		name = "??$tcscpy_s@AAPA_WIABQB_W@?$__crt_char_traits@_W@@SAHAAPA_W$$QAIABQB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_10_2 {
	meta:
		name = "??$tcscpy_s@ABQADABIAAPAD@?$__crt_char_traits@D@@SAHABQADABIAAPAD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_664_20_4 {
	meta:
		name = "??$tcscpy_s@ABQADABIABQAD@?$__crt_char_traits@D@@SAHABQADABI0@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_583_16_0 {
	meta:
		name = "??$tcscpy_s@ABQADABIABQBD@?$__crt_char_traits@D@@SAHABQADABIABQBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_11_3 {
	meta:
		name = "??$tcscpy_s@ABQA_WABIAAPA_W@?$__crt_char_traits@_W@@SAHABQA_WABIAAPA_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_664_21_2 {
	meta:
		name = "??$tcscpy_s@ABQA_WABIABQA_W@?$__crt_char_traits@_W@@SAHABQA_WABI0@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_583_17_2 {
	meta:
		name = "??$tcscpy_s@ABQA_WABIABQB_W@?$__crt_char_traits@_W@@SAHABQA_WABIABQB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_491_22_0 {
	meta:
		name = "??$tcscpy_s@PADABIAAPAD@?$__crt_char_traits@D@@SAH$$QAPADABIAAPAD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_678_21_4 {
	meta:
		name = "??$tcscpy_s@PADABIAAPBD@?$__crt_char_traits@D@@SAH$$QAPADABIAAPBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_262_29_4 {
	meta:
		name = "??$tcscpy_s@PADABIABQBD@?$__crt_char_traits@D@@SAH$$QAPADABIABQBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_625_17_4 {
	meta:
		name = "??$tcscpy_s@PADIABQBD@?$__crt_char_traits@D@@SAH$$QAPAD$$QAIABQBD@Z"
		size = 30
		refs = "0015 _strcpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_491_23_4 {
	meta:
		name = "??$tcscpy_s@PA_WABIAAPA_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAPA_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_678_23_3 {
	meta:
		name = "??$tcscpy_s@PA_WABIAAPB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIAAPB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_625_18_2 {
	meta:
		name = "??$tcscpy_s@PA_WABIABQB_W@?$__crt_char_traits@_W@@SAH$$QAPA_WABIABQB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_625_19_0 {
	meta:
		name = "??$tcscpy_s@PA_WIABQB_W@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAIABQB_W@Z"
		size = 30
		refs = "0015 _wcscpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_583_22_0 {
	meta:
		name = "??$tcsnicoll@AAPADABQBDABI@?$__crt_char_traits@D@@SAHAAPADABQBDABI@Z"
		size = 30
		refs = "0015 __strnicoll"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_583_23_2 {
	meta:
		name = "??$tcsnicoll@AAPA_WABQB_WABI@?$__crt_char_traits@_W@@SAHAAPA_WABQB_WABI@Z"
		size = 30
		refs = "0015 __wcsnicoll"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_664_26_3 {
	meta:
		name = "??$tcsnicoll@ABQBDAAPADABI@?$__crt_char_traits@D@@SAHABQBDAAPADABI@Z"
		size = 30
		refs = "0015 __strnicoll"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_664_27_0 {
	meta:
		name = "??$tcsnicoll@ABQB_WAAPA_WABI@?$__crt_char_traits@_W@@SAHABQB_WAAPA_WABI@Z"
		size = 30
		refs = "0015 __wcsnicoll"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_175_128_4 {
	meta:
		name = "??$tcstol@AAPBDPAPADH@?$__crt_char_traits@D@@SAJAAPBD$$QAPAPAD$$QAH@Z"
		size = 30
		refs = "0015 _strtol"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_175_129_2 {
	meta:
		name = "??$tcstol@AAPB_WPAPA_WH@?$__crt_char_traits@_W@@SAJAAPB_W$$QAPAPA_W$$QAH@Z"
		size = 30
		refs = "0015 _wcstol"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_175_130_2 {
	meta:
		name = "??$tcstol@PBDPAPADH@?$__crt_char_traits@D@@SAJ$$QAPBD$$QAPAPAD$$QAH@Z"
		size = 30
		refs = "0015 _strtol"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_175_131_2 {
	meta:
		name = "??$tcstol@PB_WPAPA_WH@?$__crt_char_traits@_W@@SAJ$$QAPB_W$$QAPAPA_W$$QAH@Z"
		size = 30
		refs = "0015 _wcstol"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_463_64_0 {
	meta:
		name = "??$tcstoull@AAPB_WPAPA_WH@?$__crt_char_traits@_W@@SA_KAAPB_W$$QAPAPA_W$$QAH@Z"
		size = 30
		refs = "0015 _wcstoull"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_463_65_0 {
	meta:
		name = "??$tcstoull@PBDPAPADH@?$__crt_char_traits@D@@SA_K$$QAPBD$$QAPAPAD$$QAH@Z"
		size = 30
		refs = "0015 _strtoull"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_20_2 {
	meta:
		name = "??$tfullpath@ABQADABQBDABI@?$__crt_char_traits@D@@SAPADABQADABQBDABI@Z"
		size = 30
		refs = "0015 __fullpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_21_2 {
	meta:
		name = "??$tfullpath@ABQA_WABQB_WABI@?$__crt_char_traits@_W@@SAPA_WABQA_WABQB_WABI@Z"
		size = 30
		refs = "0015 __wfullpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_54_22_4 {
	meta:
		name = "??$tgetpath@AAPADAAPADH@?$__crt_char_traits@D@@SAPADAAPAD0$$QAH@Z"
		size = 30
		refs = "0015 ___acrt_getpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_22_0 {
	meta:
		name = "??$tgetpath@AAPADAAPADI@?$__crt_char_traits@D@@SAPADAAPAD0$$QAI@Z"
		size = 30
		refs = "0015 ___acrt_getpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_54_23_0 {
	meta:
		name = "??$tgetpath@AAPA_WAAPA_WH@?$__crt_char_traits@_W@@SAPA_WAAPA_W0$$QAH@Z"
		size = 30
		refs = "0015 ___acrt_wgetpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_23_3 {
	meta:
		name = "??$tgetpath@AAPA_WAAPA_WI@?$__crt_char_traits@_W@@SAPA_WAAPA_W0$$QAI@Z"
		size = 30
		refs = "0015 ___acrt_wgetpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_262_43_4 {
	meta:
		name = "??$tgetpath@AAPBDPADH@?$__crt_char_traits@D@@SAPADAAPBD$$QAPAD$$QAH@Z"
		size = 30
		refs = "0015 ___acrt_getpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_262_44_2 {
	meta:
		name = "??$tgetpath@AAPB_WPA_WH@?$__crt_char_traits@_W@@SAPA_WAAPB_W$$QAPA_W$$QAH@Z"
		size = 30
		refs = "0015 ___acrt_wgetpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_24_2 {
	meta:
		name = "??$tgetpath@ABQADAAPADI@?$__crt_char_traits@D@@SAPADABQADAAPAD$$QAI@Z"
		size = 30
		refs = "0015 ___acrt_getpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_139_25_2 {
	meta:
		name = "??$tgetpath@ABQA_WAAPA_WI@?$__crt_char_traits@_W@@SAPA_WABQA_WAAPA_W$$QAI@Z"
		size = 30
		refs = "0015 ___acrt_wgetpath"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_54_8_0 {
	meta:
		name = "??$tcschr@AAPADD@?$__crt_char_traits@D@@SAPADAAPAD$$QAD@Z"
		size = 26
		refs = "0012 _strchr"
		altNames = "??$tcschr@ABQADD@?$__crt_char_traits@D@@SAPADABQAD$$QAD@Z ??$tcschr@PADD@?$__crt_char_traits@D@@SAPAD$$QAPAD$$QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 0F BE 08 8B 45 08 51 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_54_18_0 {
	meta:
		name = "??$tcsrchr@AAPADD@?$__crt_char_traits@D@@SAPADAAPAD$$QAD@Z"
		size = 26
		refs = "0012 _strrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 0F BE 08 8B 45 08 51 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_54_9_0 {
	meta:
		name = "??$tcschr@AAPA_WD@?$__crt_char_traits@_W@@SAPA_WAAPA_W$$QAD@Z"
		size = 30
		refs = "0016 _wcschr"
		altNames = "??$tcschr@ABQA_WD@?$__crt_char_traits@_W@@SAPA_WABQA_W$$QAD@Z ??$tcschr@PA_WD@?$__crt_char_traits@_W@@SAPA_W$$QAPA_W$$QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 66 0F BE 00 0F B7 C8 8B 45 08 51 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_54_19_0 {
	meta:
		name = "??$tcsrchr@AAPA_WD@?$__crt_char_traits@_W@@SAPA_WAAPA_W$$QAD@Z"
		size = 30
		refs = "0016 _wcsrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 66 0F BE 00 0F B7 C8 8B 45 08 51 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_54_10_0 {
	meta:
		name = "??$tcschr@ABQBDD@?$__crt_char_traits@D@@SAPBDABQBD$$QAD@Z"
		size = 26
		refs = "0012 _strchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 0F BE 00 50 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_678_29_0 {
	meta:
		name = "??$tcsrchr@AAPBDD@?$__crt_char_traits@D@@SAPBDAAPBD$$QAD@Z"
		size = 26
		refs = "0012 _strrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 0F BE 00 50 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_678_31_0 {
	meta:
		name = "??$tcsrchr@ABQBDD@?$__crt_char_traits@D@@SAPBDABQBD$$QAD@Z"
		size = 26
		refs = "0012 _strrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 0F BE 00 50 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_54_11_0 {
	meta:
		name = "??$tcschr@ABQB_WD@?$__crt_char_traits@_W@@SAPB_WABQB_W$$QAD@Z"
		size = 30
		refs = "0016 _wcschr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 66 0F BE 00 0F B7 C0 50 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_678_30_0 {
	meta:
		name = "??$tcsrchr@AAPB_WD@?$__crt_char_traits@_W@@SAPB_WAAPB_W$$QAD@Z"
		size = 30
		refs = "0016 _wcsrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 66 0F BE 00 0F B7 C0 50 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_678_32_0 {
	meta:
		name = "??$tcsrchr@ABQB_WD@?$__crt_char_traits@_W@@SAPB_WABQB_W$$QAD@Z"
		size = 30
		refs = "0016 _wcsrchr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 66 0F BE 00 0F B7 C0 50 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_54_14_0 {
	meta:
		name = "??$tcslen@AAPAD@?$__crt_char_traits@D@@SAIAAPAD@Z"
		size = 24
		altNames = "??$tcslen@AAPBD@?$__crt_char_traits@D@@SAIAAPBD@Z ??$tcslen@ABQAD@?$__crt_char_traits@D@@SAIABQAD@Z ??$tcslen@ABQBD@?$__crt_char_traits@D@@SAIABQBD@Z ??$tcslen@PAD@?$__crt_char_traits@D@@SAI$$QAPAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 00 8D 50 01 8A 08 40 84 C9 75 F9 2B C2 5D C3 }
	condition:
		$1
}

rule file_54_15_0 {
	meta:
		name = "??$tcslen@AAPA_W@?$__crt_char_traits@_W@@SAIAAPA_W@Z"
		size = 30
		altNames = "??$tcslen@AAPB_W@?$__crt_char_traits@_W@@SAIAAPB_W@Z ??$tcslen@ABQA_W@?$__crt_char_traits@_W@@SAIABQA_W@Z ??$tcslen@ABQB_W@?$__crt_char_traits@_W@@SAIABQB_W@Z ??$tcslen@PA_W@?$__crt_char_traits@_W@@SAI$$QAPA_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 00 8D 50 02 66 8B 08 83 C0 02 66 85 C9 75 F5 2B C2 D1 F8 5D C3 }
	condition:
		$1
}

rule file_54_20_0 {
	meta:
		name = "??$tdupenv_s_crt@PAPAD$$TAAY04$$CBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TAAY04$$CBD@Z"
		size = 37
		refs = "000b ??_C@_0DC@GGIGALME@minkernel?2crts?2ucrt?2inc?2corecrt_@ 001c __dupenv_s_dbg"
		altNames = "??$tdupenv_s_crt@PAPAD$$TAAY07$$CBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TAAY07$$CBD@Z ??$tdupenv_s_crt@PAPAD$$TAAY0L@$$CBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TAAY0L@$$CBD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 6A 6A 68 ?? ?? ?? ?? 6A 02 FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_54_21_0 {
	meta:
		name = "??$tdupenv_s_crt@PAPA_W$$TAAY04$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TAAY04$$CB_W@Z"
		size = 37
		refs = "000b ??_C@_0DC@GGIGALME@minkernel?2crts?2ucrt?2inc?2corecrt_@ 001c __wdupenv_s_dbg"
		altNames = "??$tdupenv_s_crt@PAPA_W$$TAAY07$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TAAY07$$CB_W@Z ??$tdupenv_s_crt@PAPA_W$$TAAY0L@$$CB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TAAY0L@$$CB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 6A 79 68 ?? ?? ?? ?? 6A 02 FF 75 10 FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_54_24_0 {
	meta:
		name = "??$tspawnve@ABHAAPADABQBQBDABQBQBD@?$__crt_char_traits@D@@SAHABHAAPADABQBQBD2@Z"
		size = 35
		refs = "001a __spawnve"
		altNames = "??$tspawnve@ABHABQBDABQAPADABQBQBD@?$__crt_char_traits@D@@SAHABHABQBDABQAPADABQBQBD@Z ??$tspawnve@ABHABQBDABQBQBDABQBQBD@?$__crt_char_traits@D@@SAHABHABQBDABQBQBD2@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_600_4_4 {
	meta:
		name = "??$capture_argv@PAPADABQBDPAPADH@?$__crt_char_traits@D@@SAPAPAD$$QAPAPADABQBD0$$QAH@Z"
		size = 35
		refs = "001a ___acrt_capture_narrow_argv"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_742_5_0 {
	meta:
		name = "??$capture_argv@PAPADABQB_WPAPA_WH@?$__crt_char_traits@_W@@SAPAPA_W$$QAPAPADABQB_W$$QAPAPA_W$$QAH@Z"
		size = 35
		refs = "001a ___acrt_capture_wide_argv"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_678_11_2 {
	meta:
		name = "??$pack_command_line_and_environment@ABQBQBDABQBQBDPAPADPAPAD@?$__crt_char_traits@D@@SAHABQBQBD0$$QAPAPAD1@Z"
		size = 35
		refs = "001a ___acrt_pack_narrow_command_line_and_environment"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_678_12_2 {
	meta:
		name = "??$pack_command_line_and_environment@ABQBQB_WABQBQB_WPAPA_WPAPA_W@?$__crt_char_traits@_W@@SAHABQBQB_W0$$QAPAPA_W1@Z"
		size = 35
		refs = "001a ___acrt_pack_wide_command_line_and_environment"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_54_25_4 {
	meta:
		name = "??$tspawnve@ABHAAPA_WABQBQB_WABQBQB_W@?$__crt_char_traits@_W@@SAHABHAAPA_WABQBQB_W2@Z"
		size = 35
		refs = "001a __wspawnve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_600_9_3 {
	meta:
		name = "??$tspawnve@ABHABQB_WABQAPA_WABQBQB_W@?$__crt_char_traits@_W@@SAHABHABQB_WABQAPA_WABQBQB_W@Z"
		size = 35
		refs = "001a __wspawnve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_54_27_4 {
	meta:
		name = "??$tspawnve@ABHABQB_WABQBQB_WABQBQB_W@?$__crt_char_traits@_W@@SAHABHABQB_WABQBQB_W2@Z"
		size = 35
		refs = "001a __wspawnve"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_742_8_3 {
	meta:
		name = "??$tspawnvpe@ABHABQBDABQAPADABQBQBD@?$__crt_char_traits@D@@SAHABHABQBDABQAPADABQBQBD@Z"
		size = 35
		refs = "001a __spawnvpe"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_742_9_3 {
	meta:
		name = "??$tspawnvpe@ABHABQB_WABQAPA_WABQBQB_W@?$__crt_char_traits@_W@@SAHABHABQB_WABQAPA_WABQBQB_W@Z"
		size = 35
		refs = "001a __wspawnvpe"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_54_30_0 {
	meta:
		name = "??0__crt_errno_guard@@QAE@QAH@Z"
		size = 24
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 89 11 8B 02 89 41 04 8B C1 83 22 00 5D C2 04 00 }
	condition:
		$1
}

rule file_54_33_0 {
	meta:
		name = "??1__crt_errno_guard@@QAE@XZ"
		size = 17
	strings:
		$1 = { 8B 11 83 3A 00 75 09 8B 41 04 85 C0 74 02 89 02 C3 }
	condition:
		$1
}

rule file_54_48_0 {
	meta:
		name = "__execvp"
		size = 25
		refs = "0010 ??$common_spawnvp@D@@YAHHQBDQBQBD1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_678_76_0 {
	meta:
		name = "__execv"
		size = 25
		refs = "0010 ??$common_spawnv@D@@YAHHQBDQBQBD1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_678_81_0 {
	meta:
		name = "__wexecv"
		size = 25
		refs = "0010 ??$common_spawnv@_W@@YAHHQB_WQBQB_W1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_54_54_0 {
	meta:
		name = "__wexecvp"
		size = 25
		refs = "0010 ??$common_spawnvp@_W@@YAHHQB_WQBQB_W1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_54_49_0 {
	meta:
		name = "__execvpe"
		size = 26
		refs = "0011 ??$common_spawnvp@D@@YAHHQBDQBQBD1@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_678_77_0 {
	meta:
		name = "__execve"
		size = 26
		refs = "0011 ??$common_spawnv@D@@YAHHQBDQBQBD1@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_678_82_0 {
	meta:
		name = "__wexecve"
		size = 26
		refs = "0011 ??$common_spawnv@_W@@YAHHQB_WQBQB_W1@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_54_55_0 {
	meta:
		name = "__wexecvpe"
		size = 26
		refs = "0011 ??$common_spawnvp@_W@@YAHHQB_WQBQB_W1@Z"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 10 FF 75 0C FF 75 08 6A 02 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_54_50_0 {
	meta:
		name = "__invoke_watson_if_error"
		size = 34
		refs = "001d __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 75 02 5D C3 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_54_51_0 {
	meta:
		name = "__invoke_watson_if_oneof"
		size = 45
		refs = "0028 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 85 C0 74 0A 3B 45 0C 74 07 3B 45 10 74 02 5D C3 FF 75 24 FF 75 20 FF 75 1C FF 75 18 FF 75 14 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_55_0_0 {
	meta:
		name = "__strrev"
		size = 53
	strings:
		$1 = { 55 8B EC 57 56 8B 7D 08 8B D7 8B F7 33 C0 83 C9 FF F2 AE 83 F9 FE 74 17 83 EF 02 3B F7 73 10 8A 26 8A 07 88 06 88 27 83 C6 01 83 EF 01 EB EC 8B C2 5E 5F C9 C3 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "__fdrint"
		size = 398
		refs = "000f _fegetround 0059 __fd_int 0080 __real@3ff0000000000000 00e5 __real@4000000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 D9 45 08 D9 5D FC E8 ?? ?? ?? ?? 89 45 F8 81 7D F8 00 02 00 00 7F 21 81 7D F8 00 02 00 00 0F 84 27 01 00 00 83 7D F8 00 74 5A 81 7D F8 00 01 00 00 74 17 E9 47 01 00 00 81 7D F8 00 03 00 00 0F 84 F6 00 00 00 E9 35 01 00 00 6A 00 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 85 C9 74 20 BA 02 00 00 00 C1 E2 00 0F B7 44 15 FC 25 00 80 00 00 74 0C D9 45 FC DC 25 ?? ?? ?? ?? D9 5D FC E9 FB 00 00 00 6A 01 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 0F BF D0 85 D2 75 5B 6A 00 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 85 C9 74 13 6A FF 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 98 85 C0 75 02 EB 2F B9 02 00 00 00 C1 E1 00 0F B7 54 0D FC 81 E2 00 80 00 00 74 0E D9 45 FC DC 25 ?? ?? ?? ?? D9 5D FC EB 0C D9 45 FC DC 05 ?? ?? ?? ?? D9 5D FC EB 45 6A 00 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 85 C9 75 02 EB 2E BA 02 00 00 00 C1 E2 00 0F B7 44 15 FC 25 00 80 00 00 74 0E D9 45 FC DC 25 ?? ?? ?? ?? D9 5D FC EB 0C D9 45 FC DC 05 ?? ?? ?? ?? D9 5D FC EB 44 6A 00 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 EB 34 6A 00 8D 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 98 85 C0 74 21 B9 02 00 00 00 C1 E1 00 0F B7 54 0D FC 81 E2 00 80 00 00 75 0C D9 45 FC DC 05 ?? ?? ?? ?? D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_56_1_0 {
	meta:
		name = "_rintf"
		size = 95
		refs = "000d __fdtest 0035 __fdrint 0051 __fperrraise"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 7C 0D 83 7D FC 02 7E 02 EB 05 D9 45 08 EB 2E 51 D9 45 08 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D9 5D F8 D9 45 F8 D9 45 08 DA E9 DF E0 F6 C4 44 7B 0A 6A 20 E8 ?? ?? ?? ?? 83 C4 04 D9 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_57_0_0 {
	meta:
		name = "__ceil_default"
		size = 278
		refs = "000e _newcw 0014 __ctrlfp 003a __sptype 0074 __real@3ff0000000000000 008c __except1 009f __frnd"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 68 FF FF 00 00 A1 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 0F B7 4D 0E 81 E1 F0 7F 00 00 81 F9 F0 7F 00 00 75 65 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 89 45 F8 83 7D F8 00 7E 21 83 7D F8 03 7E 02 EB 19 68 FF FF 00 00 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 E9 A7 00 00 00 8B 45 FC 50 DD 45 08 DC 05 ?? ?? ?? ?? 83 EC 08 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 0C 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 7D 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F0 DD 45 F0 DD 45 08 DA E9 DF E0 F6 C4 44 7A 18 68 FF FF 00 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F0 EB 44 EB 42 8B 55 FC 83 E2 20 74 18 68 FF FF 00 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 08 DD 45 F0 EB 24 EB 22 8B 4D FC 51 83 EC 08 DD 45 F0 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 0C 6A 10 E8 ?? ?? ?? ?? 83 C4 1C 8B E5 5D C3 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "__lrotr"
		size = 45
		altNames = "__rotr"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 83 E0 1F 89 45 0C B9 20 00 00 00 2B 4D 0C 8B 55 08 D3 E2 8B 45 08 8B 4D 0C D3 E8 0B D0 89 55 08 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_59_2_0 {
	meta:
		name = "__rotr64"
		size = 73
		refs = "001f __allshl 0031 __aullshr"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 45 10 83 E0 3F 89 45 10 B9 40 00 00 00 2B 4D 10 8B 45 08 8B 55 0C E8 ?? ?? ?? ?? 8B F0 8B FA 8B 45 08 8B 55 0C 8B 4D 10 E8 ?? ?? ?? ?? 0B F0 0B FA 89 75 08 89 7D 0C 8B 45 08 8B 55 0C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_595_2_0 {
	meta:
		name = "__rotl64"
		size = 73
		refs = "001f __aullshr 0031 __allshl"
	strings:
		$1 = { 8B FF 55 8B EC 56 57 8B 45 10 83 E0 3F 89 45 10 B9 40 00 00 00 2B 4D 10 8B 45 08 8B 55 0C E8 ?? ?? ?? ?? 8B F0 8B FA 8B 45 08 8B 55 0C 8B 4D 10 E8 ?? ?? ?? ?? 0B F0 0B FA 89 75 08 89 7D 0C 8B 45 08 8B 55 0C 5F 5E 5D C3 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "___libm_sse2_sin"
		size = 430
		refs = "001b _PI32INV 0027 _SHIFTER 0037 _P_1 0043 _P_2 0060 _SC_4 0066 ___acrt_cos_sin_ctable 007b _P_3 00a0 _SC_2 00e5 _SC_3 00f1 _SC_1 015d _ALL_ONES 0166 _TWO_POW_55 0176 _TWO_POW_M55 0195 _sin 01a9 _NEG_ZERO"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 36 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 2D D1 F2 0F 58 CA F2 0F 10 1D ?? ?? ?? ?? F2 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 D9 66 0F 14 C9 81 C2 00 76 1C 00 F2 0F 10 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 05 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C E3 F2 0F 10 78 08 66 0F 14 C0 F2 0F 10 DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F2 0F 10 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 F2 0F 10 C3 F2 0F 58 58 08 66 0F 59 CF F2 0F 10 FC F2 0F 58 E3 66 0F 58 F5 F2 0F 10 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F2 0F 58 CE F2 0F 58 E1 66 0F 28 C4 C3 7F 2C 66 C1 E8 04 66 3D FD 0C 75 09 F2 0F 59 05 ?? ?? ?? ?? C3 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C D8 F2 0F 59 1D ?? ?? ?? ?? C3 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 74 19 83 EC 08 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 83 C4 08 C3 F2 0F 59 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_61_1_0 {
	meta:
		name = "_expm1f"
		size = 296
		refs = "000d __fdtest 004c __real@bf800000 0065 _lnhalf 007e _lnone_half 0095 _s 00d5 _c 0111 _expf 011a __real@3ff0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 74 0E 83 7D FC 01 74 10 83 7D FC 02 74 02 EB 35 D9 45 08 E9 EE 00 00 00 BA 02 00 00 00 C1 E2 00 0F B7 44 15 08 25 00 80 00 00 74 0B D9 05 ?? ?? ?? ?? D9 5D F8 EB 06 D9 45 08 D9 5D F8 D9 45 F8 E9 C1 00 00 00 D9 05 ?? ?? ?? ?? D9 45 08 DE D9 DF E0 F6 C4 41 0F 85 90 00 00 00 D9 45 08 D9 05 ?? ?? ?? ?? DE D9 DF E0 F6 C4 41 75 7E B9 04 00 00 00 6B D1 00 D9 82 ?? ?? ?? ?? D8 4D 08 B8 04 00 00 00 C1 E0 00 D8 80 ?? ?? ?? ?? D8 4D 08 B9 04 00 00 00 D1 E1 D8 81 ?? ?? ?? ?? D8 4D 08 BA 04 00 00 00 6B C2 03 D8 80 ?? ?? ?? ?? B9 04 00 00 00 6B D1 00 D9 82 ?? ?? ?? ?? D8 4D 08 B8 04 00 00 00 C1 E0 00 D8 80 ?? ?? ?? ?? D8 4D 08 B9 04 00 00 00 D1 E1 D8 81 ?? ?? ?? ?? DE F9 D8 4D 08 D9 5D F4 D9 45 F4 EB 1D EB 1B 51 D9 45 08 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 DC 25 ?? ?? ?? ?? D9 5D F0 D9 45 F0 8B E5 5D C3 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "__abs64"
		size = 65
		altNames = "_llabs"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 83 7D 0C 00 7C 16 7F 06 83 7D 08 00 72 0E 8B 45 08 89 45 F8 8B 4D 0C 89 4D FC EB 13 8B 55 08 F7 DA 8B 45 0C 83 D0 00 F7 D8 89 55 F8 89 45 FC 8B 45 F8 8B 55 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_62_1_0 {
	meta:
		name = "_abs"
		size = 35
		altNames = "_labs"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 7C 08 8B 45 08 89 45 FC EB 08 8B 4D 08 F7 D9 89 4D FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_4_0 {
	meta:
		name = "??0__crt_stdio_stream@@QAE@XZ"
		size = 25
		altNames = "??0__crt_deferred_errno_cache@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 45 FC C7 00 00 00 00 00 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_7_0 {
	meta:
		name = "?__acrt_stdio_allocate_stream@@YA?AV__crt_stdio_stream@@XZ"
		size = 237
		refs = "0008 __sehtable$?__acrt_stdio_allocate_stream@@YA?AV__crt_stdio_stream@@XZ 000d __except_handler4 001f ___security_cookie 0036 ??0__crt_stdio_stream@@QAE@XZ 003d ___acrt_lock 0050 ?find_or_allocate_unused_stream_nolock@@YA?AV__crt_stdio_stream@@XZ 0060 ?valid@__crt_stdio_stream@@QBE_NXZ 0071 ??C__crt_stdio_stream@@QBEPAU__crt_stdio_stream_data@@XZ 00c8 ___acrt_unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 04 8B 08 89 4D E4 8D 4D E4 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 02 EB 4A 8D 4D E4 E8 ?? ?? ?? ?? C7 40 08 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? C7 40 1C 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? C7 00 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? C7 40 04 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? C7 40 10 FF FF FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 08 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 08 8B 4D E4 89 08 8B 45 08 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_8_0 {
	meta:
		name = "?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z"
		size = 119
		refs = "0009 ??C__crt_stdio_stream@@QBEPAU__crt_stdio_stream_data@@XZ 0071 ?deallocate@__crt_stdio_stream@@QAEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 8D 4D 08 E8 ?? ?? ?? ?? C7 00 00 00 00 00 8D 4D 08 E8 ?? ?? ?? ?? C7 40 04 00 00 00 00 8D 4D 08 E8 ?? ?? ?? ?? C7 40 08 00 00 00 00 8D 4D 08 E8 ?? ?? ?? ?? C7 40 10 FF FF FF FF 8D 4D 08 E8 ?? ?? ?? ?? C7 40 14 00 00 00 00 8D 4D 08 E8 ?? ?? ?? ?? C7 40 18 00 00 00 00 8D 4D 08 E8 ?? ?? ?? ?? C7 40 1C 00 00 00 00 8D 4D 08 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_63_10_0 {
	meta:
		name = "?deallocate@__crt_stdio_stream@@QAEXXZ"
		size = 25
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 33 C0 8B 4D FC 8B 11 83 C2 0C 87 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_12_0 {
	meta:
		name = "?find_or_allocate_unused_stream_nolock@@YA?AV__crt_stdio_stream@@XZ"
		size = 315
		refs = "0009 ___piob 0015 __nstream 004a ??0__crt_stdio_stream@@QAE@QAU__crt_stdio_stream_data@@@Z 0052 ?valid@__crt_stdio_stream@@QBE_NXZ 0061 ?is_in_use@__crt_stdio_stream@@QBE_NXZ 0072 ?lock@__crt_stdio_stream@@QBEXXZ 007a ?try_allocate@__crt_stdio_stream@@QAE_NXZ 0089 ?unlock@__crt_stdio_stream@@QBEXXZ 00a2 ??_C@_0DA@OGKFKCBE@minkernel?2crts?2ucrt?2src?2appcrt?2s@ 00ad __calloc_dbg 00b9 ??0?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAE@QAU__crt_stdio_stream_data@@@Z 00c0 ?detach@?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAEPAU__crt_stdio_stream_data@@XZ 00cd ??1?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QAE@XZ 00f8 ___acrt_InitializeCriticalSectionEx@12 0130 ??0__crt_stdio_stream@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 83 C0 0C 89 45 F0 8B 0D ?? ?? ?? ?? 8B 55 F0 8D 44 8A F4 89 45 EC 8B 4D F0 89 4D FC EB 09 8B 55 FC 83 C2 04 89 55 FC 8B 45 FC 3B 45 EC 0F 84 EC 00 00 00 8B 4D FC 8B 11 52 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 42 8D 4D F8 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 02 EB BD 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 0A 8D 4D F8 E8 ?? ?? ?? ?? EB 9C 8B 45 08 8B 4D F8 89 08 8B 45 08 E9 98 00 00 00 6A 29 68 ?? ?? ?? ?? 6A 02 6A 38 6A 01 E8 ?? ?? ?? ?? 83 C4 14 50 8D 4D E8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 55 FC 89 02 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 FC 83 38 00 75 02 EB 51 8B 4D FC 8B 11 C7 42 10 FF FF FF FF 6A 00 68 A0 0F 00 00 8B 45 FC 8B 08 83 C1 20 51 E8 ?? ?? ?? ?? 8B 55 FC 8B 02 50 8D 4D F4 E8 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 8B 4D 08 8B 55 F4 89 11 8B 45 08 EB 10 E9 FF FE FF FF 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_15_0 {
	meta:
		name = "?lock@__crt_stdio_stream@@QBEXXZ"
		size = 30
		refs = "000d ?public_stream@__crt_stdio_stream@@QBEPAU_iobuf@@XZ 0013 __lock_file"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_19_0 {
	meta:
		name = "?unlock@__crt_stdio_stream@@QBEXXZ"
		size = 30
		refs = "000d ?public_stream@__crt_stdio_stream@@QBEPAU_iobuf@@XZ 0013 __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 8B 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_63_18_0 {
	meta:
		name = "?try_allocate@__crt_stdio_stream@@QAE_NXZ"
		size = 74
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 56 89 4D F8 B9 00 20 00 00 8B 55 F8 8B 02 83 C0 0C 89 45 F4 8B 55 F4 8B 02 8B F0 0B F1 F0 0F B1 32 75 F6 25 00 20 00 00 75 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "??$common_show_message_box@D@@YAHQBD0I@Z"
		size = 223
		refs = "0009 ___acrt_get_developer_information_policy 0024 __imp__IsDebuggerPresent@0 0037 ??$output_debug_string@ABQBD@?$__crt_char_traits@D@@SAXABQBD@Z 0059 ___acrt_can_show_message_box 0084 ___acrt_is_interactive 00b2 ??$message_box@$$TABQBDABQBDK@?$__crt_char_traits@D@@SAH$$QA$$TABQBD1$$QAK@Z 00bc ___acrt_get_parent_window 00d4 ??$message_box@PAUHWND__@@ABQBDABQBDABI@?$__crt_char_traits@D@@SAH$$QAPAUHWND__@@ABQBD1ABI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 E8 ?? ?? ?? ?? 83 F8 02 75 06 C6 45 FF 01 EB 04 C6 45 FF 00 8A 45 FF 88 45 FE FF 15 ?? ?? ?? ?? 85 C0 74 24 83 7D 08 00 74 0C 8D 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 0F B6 55 FE 85 D2 74 0A B8 04 00 00 00 E9 8B 00 00 00 0F B6 45 FE 85 C0 74 0C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 1F FF 15 ?? ?? ?? ?? 85 C0 74 09 C7 45 F8 04 00 00 00 EB 07 C7 45 F8 03 00 00 00 8B 45 F8 EB 58 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 2C 8B 45 10 0D 00 00 20 00 89 45 F4 C7 45 F0 00 00 00 00 8D 4D F4 51 8D 55 0C 52 8D 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 10 EB 20 E8 ?? ?? ?? ?? 89 45 EC 8D 55 10 52 8D 45 0C 50 8D 4D 08 51 8D 55 EC 52 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_65_1_0 {
	meta:
		name = "??$common_show_message_box@_W@@YAHQB_W0I@Z"
		size = 223
		refs = "0009 ___acrt_get_developer_information_policy 0024 __imp__IsDebuggerPresent@0 0037 ??$output_debug_string@ABQB_W@?$__crt_char_traits@_W@@SAXABQB_W@Z 0059 ___acrt_can_show_message_box 0084 ___acrt_is_interactive 00b2 ??$message_box@$$TABQB_WABQB_WK@?$__crt_char_traits@_W@@SAH$$QA$$TABQB_W1$$QAK@Z 00bc ___acrt_get_parent_window 00d4 ??$message_box@PAUHWND__@@ABQB_WABQB_WABI@?$__crt_char_traits@_W@@SAH$$QAPAUHWND__@@ABQB_W1ABI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 E8 ?? ?? ?? ?? 83 F8 02 75 06 C6 45 FF 01 EB 04 C6 45 FF 00 8A 45 FF 88 45 FE FF 15 ?? ?? ?? ?? 85 C0 74 24 83 7D 08 00 74 0C 8D 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 0F B6 55 FE 85 D2 74 0A B8 04 00 00 00 E9 8B 00 00 00 0F B6 45 FE 85 C0 74 0C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 75 1F FF 15 ?? ?? ?? ?? 85 C0 74 09 C7 45 F8 04 00 00 00 EB 07 C7 45 F8 03 00 00 00 8B 45 F8 EB 58 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 2C 8B 45 10 0D 00 00 20 00 89 45 F4 C7 45 F0 00 00 00 00 8D 4D F4 51 8D 55 0C 52 8D 45 08 50 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 10 EB 20 E8 ?? ?? ?? ?? 89 45 EC 8D 55 10 52 8D 45 0C 50 8D 4D 08 51 8D 55 EC 52 E8 ?? ?? ?? ?? 83 C4 10 8B E5 5D C3 }
	condition:
		$1
}

rule file_65_2_0 {
	meta:
		name = "??$message_box@$$TABQBDABQBDK@?$__crt_char_traits@D@@SAH$$QA$$TABQBD1$$QAK@Z"
		size = 36
		refs = "001e ___acrt_MessageBoxA@16"
		altNames = "??$message_box@PAUHWND__@@ABQBDABQBDABI@?$__crt_char_traits@D@@SAH$$QAPAUHWND__@@ABQBD1ABI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_65_3_0 {
	meta:
		name = "??$message_box@$$TABQB_WABQB_WK@?$__crt_char_traits@_W@@SAH$$QA$$TABQB_W1$$QAK@Z"
		size = 36
		refs = "001e ___acrt_MessageBoxW@16"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_65_5_0 {
	meta:
		name = "??$message_box@PAUHWND__@@ABQB_WABQB_WABI@?$__crt_char_traits@_W@@SAH$$QAPAUHWND__@@ABQB_W1ABI@Z"
		size = 36
		refs = "001e ___acrt_MessageBoxW@16"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_65_6_0 {
	meta:
		name = "??$output_debug_string@ABQBD@?$__crt_char_traits@D@@SAXABQBD@Z"
		size = 19
		refs = "000d __imp__OutputDebugStringA@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 08 51 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_65_7_0 {
	meta:
		name = "??$output_debug_string@ABQB_W@?$__crt_char_traits@_W@@SAXABQB_W@Z"
		size = 19
		refs = "000d __imp__OutputDebugStringW@4"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 8B 08 51 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_65_8_0 {
	meta:
		name = "___acrt_show_narrow_message_box"
		size = 27
		refs = "0012 ??$common_show_message_box@D@@YAHQBD0I@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_65_9_0 {
	meta:
		name = "___acrt_show_wide_message_box"
		size = 27
		refs = "0012 ??$common_show_message_box@_W@@YAHQB_W0I@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_337_35_0 {
	meta:
		name = "___wcserror_s"
		size = 27
		refs = "0012 ??$common_strerror_s@_W@@YAHQA_WIQB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_240_4_2 {
	meta:
		name = "__aligned_msize"
		size = 27
		refs = "0012 __aligned_msize_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_511_116_4 {
	meta:
		name = "__atodbl_l"
		size = 27
		refs = "0012 ??$common_atodbl_l@ND@@YAHQANQBDQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_511_119_3 {
	meta:
		name = "__atoflt_l"
		size = 27
		refs = "0012 ??$common_atodbl_l@MD@@YAHQAMQBDQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_659_15_3 {
	meta:
		name = "__ctime32_s"
		size = 27
		refs = "0012 ??$common_ctime_s@JD@@YAHQADIQBJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_659_17_3 {
	meta:
		name = "__ctime64_s"
		size = 27
		refs = "0012 ??$common_ctime_s@_JD@@YAHQADIQB_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_81_9_3 {
	meta:
		name = "__fsopen"
		size = 27
		refs = "0012 ??$common_fsopen@D@@YAPAU_iobuf@@QBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_632_6_3 {
	meta:
		name = "__lseek"
		size = 27
		refs = "0012 ??$common_lseek@J@@YAJHJH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_632_7_3 {
	meta:
		name = "__lseek_nolock"
		size = 27
		refs = "0012 ??$common_lseek_nolock@J@@YAJHJH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_337_39_3 {
	meta:
		name = "__strerror_s"
		size = 27
		refs = "0012 ??$common_strerror_s@D@@YAHQADIQBD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_118_0 {
	meta:
		name = "__strtod_l"
		size = 27
		refs = "0012 ??$common_strtod_l@ND@@YANQBDQAPADQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_119_4 {
	meta:
		name = "__strtof_l"
		size = 27
		refs = "0012 ??$common_strtod_l@MD@@YAMQBDQAPADQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_120_4 {
	meta:
		name = "__strtold_l"
		size = 27
		refs = "0012 ??$common_strtod_l@ND@@YANQBDQAPADQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_631_23_0 {
	meta:
		name = "__wasctime_s"
		size = 27
		refs = "0012 ??$common_asctime_s@_W@@YAHQA_WIQBUtm@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_661_24_3 {
	meta:
		name = "__wcserror_s"
		size = 27
		refs = "0012 ??$common_strerror_s@_W@@YAHQA_WIH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_121_0 {
	meta:
		name = "__wcstod_l"
		size = 27
		refs = "0012 ??$common_strtod_l@N_W@@YANQB_WQAPA_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_122_0 {
	meta:
		name = "__wcstof_l"
		size = 27
		refs = "0012 ??$common_strtod_l@M_W@@YAMQB_WQAPA_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_444_123_3 {
	meta:
		name = "__wcstold_l"
		size = 27
		refs = "0012 ??$common_strtod_l@N_W@@YANQB_WQAPA_WQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_659_19_4 {
	meta:
		name = "__wctime32_s"
		size = 27
		refs = "0012 ??$common_ctime_s@J_W@@YAHQA_WIQBJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_659_21_4 {
	meta:
		name = "__wctime64_s"
		size = 27
		refs = "0012 ??$common_ctime_s@_J_W@@YAHQA_WIQB_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_81_11_4 {
	meta:
		name = "__wfopen_s"
		size = 27
		refs = "0012 ??$common_fopen_s@_W@@YAHQAPAU_iobuf@@QB_W1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_81_12_0 {
	meta:
		name = "__wfsopen"
		size = 27
		refs = "0012 ??$common_fsopen@_W@@YAPAU_iobuf@@QB_W0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_631_25_3 {
	meta:
		name = "_asctime_s"
		size = 27
		refs = "0012 ??$common_asctime_s@D@@YAHQADIQBUtm@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_81_14_0 {
	meta:
		name = "_fopen_s"
		size = 27
		refs = "0012 ??$common_fopen_s@D@@YAHQAPAU_iobuf@@QBD1@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_552_1_2 {
	meta:
		name = "_strcat_s"
		size = 27
		refs = "0012 ??$common_tcscat_s@D@@YAHQADIQBD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_229_1_4 {
	meta:
		name = "_strcpy_s"
		size = 27
		refs = "0012 ??$common_tcscpy_s@D@@YAHQADIQBD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_661_26_4 {
	meta:
		name = "_strerror_s"
		size = 27
		refs = "0012 ??$common_strerror_s@D@@YAHQADIH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_453_1_4 {
	meta:
		name = "_wcscat_s"
		size = 27
		refs = "0012 ??$common_tcscat_s@_W@@YAHQA_WIQB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_451_1_4 {
	meta:
		name = "_wcscpy_s"
		size = 27
		refs = "0012 ??$common_tcscpy_s@_W@@YAHQA_WIQB_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_66_0_0 {
	meta:
		name = "__libm_sse2_sqrt_precise"
		size = 256
		refs = "00da ___libm_error_support 00ee _sqrt"
	strings:
		$1 = { 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 0F 85 CC 00 00 00 D9 3C 24 0F B7 04 24 83 E0 7F 83 F8 7F 0F 85 B9 00 00 00 66 0F C5 C0 03 8B C8 25 F0 7F 00 00 3D F0 7F 00 00 74 30 8B C1 25 00 80 00 00 75 08 F2 0F 51 C0 83 C4 08 C3 66 0F D6 04 24 83 3C 24 00 75 50 81 F9 00 80 00 00 75 48 66 0F C5 C0 02 83 F8 00 75 3E EB D9 8B C1 83 E0 0F 75 24 66 0F C5 C0 02 25 FF FF 00 00 75 18 66 0F C5 C0 01 25 FF FF 00 00 75 0C 66 0F C5 C0 00 25 FF FF 00 00 74 A5 66 0F D6 04 24 80 4C 24 06 08 BA F5 03 00 00 EB 14 C7 04 24 00 00 00 00 C7 44 24 04 00 00 F8 FF BA 31 00 00 00 83 EC 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 66 0F 12 44 24 10 83 C4 18 C3 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 83 C4 08 C3 8B FF }
	condition:
		$1
}

rule file_67_5_0 {
	meta:
		name = "__mbsnccnt_l"
		size = 175
		refs = "0011 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0025 ??_C@_1DO@IBIJEOEB@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAb?$AAc?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 002d ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0035 ??_C@_1HC@HACDKFHD@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 003d __CrtDbgReportW 004b __errno 0054 ??_C@_1BI@ENAMCCPH@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAc?$AAc?$AAn?$AAt?$AA_?$AAl?$AA?$AA@ 0060 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 4D F0 56 57 FF 75 10 E8 ?? ?? ?? ?? 8B 55 08 8B 4D 0C 85 D2 75 4B 85 C9 74 47 53 BF ?? ?? ?? ?? 33 F6 57 68 ?? ?? ?? ?? 56 6A 32 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 6A 32 53 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 5B EB 2D 33 F6 85 C9 74 27 8B 7D F8 8A 02 49 84 C0 74 1D 0F B6 C0 F6 44 38 19 04 74 0D 8B C1 49 85 C0 74 0C 42 80 3A 00 74 06 46 42 85 C9 75 DC 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 5F 8B C6 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "??$common_ftime_s@JU__timeb32@@@@YAHQAU__timeb32@@@Z"
		size = 514
		refs = "000c ___security_cookie 0047 ??_C@_1BM@MEIPFNFB@?$AAt?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 004c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0055 ??_C@_1FM@EGILFEFE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 005c __CrtDbgReportW 0073 __errno 0087 ??_C@_1BO@PPOABMOP@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAf?$AAt?$AAi?$AAm?$AAe?$AA_?$AAs?$AA?$AA@ 0091 __invalid_parameter 00a3 ___tzset 00c0 ??_C@_1DC@CMKCHHFC@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CI?$AA?$CG?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CJ?$AA?$AA@ 00cc __get_timezone 00d5 __invoke_watson_if_error 00f9 ___acrt_GetSystemTimePreciseAsFileTime@4 0113 __aulldiv 0125 ?elapsed_minutes_cache@@3JA 0134 __imp__GetTimeZoneInformation@4 0149 ?dstflag_cache@@3HA 01bd __aullrem 01fa @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC CC 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 08 00 74 0C C7 85 44 FF FF FF 01 00 00 00 EB 0A C7 85 44 FF FF FF 00 00 00 00 8B 85 44 FF FF FF 89 85 40 FF FF FF 83 BD 40 FF FF FF 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 26 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 40 FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 52 01 00 00 E8 ?? ?? ?? ?? C7 85 3C FF FF FF 00 00 00 00 6A 00 6A 2B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 3C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 18 8B 85 3C FF FF FF 99 B9 3C 00 00 00 F7 F9 8B 55 08 66 89 42 06 8D 85 48 FF FF FF 50 E8 ?? ?? ?? ?? 6A 00 68 00 46 C3 23 8B 8D 4C FF FF FF 51 8B 95 48 FF FF FF 52 E8 ?? ?? ?? ?? 89 85 34 FF FF FF 8B 85 34 FF FF FF 3B 05 ?? ?? ?? ?? 74 60 8D 8D 50 FF FF FF 51 FF 15 ?? ?? ?? ?? 89 85 38 FF FF FF 83 BD 38 FF FF FF FF 75 0C C7 05 ?? ?? ?? ?? FF FF FF FF EB 2D 83 BD 38 FF FF FF 02 75 1A 0F B7 55 EA 85 D2 74 12 83 7D F8 00 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 00 00 00 00 8B 85 34 FF FF FF A3 ?? ?? ?? ?? 8B 4D 08 66 8B 15 ?? ?? ?? ?? 66 89 51 08 6A 00 68 10 27 00 00 8B 85 4C FF FF FF 50 8B 8D 48 FF FF FF 51 E8 ?? ?? ?? ?? 6A 00 68 E8 03 00 00 52 50 E8 ?? ?? ?? ?? 8B 55 08 66 89 42 04 8B 85 48 FF FF FF 2D 00 80 3E D5 8B 8D 4C FF FF FF 81 D9 DE B1 9D 01 6A 00 68 80 96 98 00 51 50 E8 ?? ?? ?? ?? 8B 55 08 89 02 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_68_1_0 {
	meta:
		name = "??$common_ftime_s@_JU__timeb64@@@@YAHQAU__timeb64@@@Z"
		size = 518
		refs = "000c ___security_cookie 0047 ??_C@_1BM@MEIPFNFB@?$AAt?$AAp?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 004c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0055 ??_C@_1FM@EGILFEFE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 005c __CrtDbgReportW 0073 __errno 0087 ??_C@_1BO@PPOABMOP@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAf?$AAt?$AAi?$AAm?$AAe?$AA_?$AAs?$AA?$AA@ 0091 __invalid_parameter 00a3 ___tzset 00c0 ??_C@_1DC@CMKCHHFC@?$AA_?$AAg?$AAe?$AAt?$AA_?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CI?$AA?$CG?$AAt?$AAi?$AAm?$AAe?$AAz?$AAo?$AAn?$AAe?$AA?$CJ?$AA?$AA@ 00cc __get_timezone 00d5 __invoke_watson_if_error 00f9 ___acrt_GetSystemTimePreciseAsFileTime@4 0113 __aulldiv 0125 ?elapsed_minutes_cache@@3JA 0134 __imp__GetTimeZoneInformation@4 0149 ?dstflag_cache@@3HA 01bd __aullrem 01fe @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC CC 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 08 00 74 0C C7 85 44 FF FF FF 01 00 00 00 EB 0A C7 85 44 FF FF FF 00 00 00 00 8B 85 44 FF FF FF 89 85 40 FF FF FF 83 BD 40 FF FF FF 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 26 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 40 FF FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 56 01 00 00 E8 ?? ?? ?? ?? C7 85 3C FF FF FF 00 00 00 00 6A 00 6A 2B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 3C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 18 8B 85 3C FF FF FF 99 B9 3C 00 00 00 F7 F9 8B 55 08 66 89 42 0A 8D 85 48 FF FF FF 50 E8 ?? ?? ?? ?? 6A 00 68 00 46 C3 23 8B 8D 4C FF FF FF 51 8B 95 48 FF FF FF 52 E8 ?? ?? ?? ?? 89 85 34 FF FF FF 8B 85 34 FF FF FF 3B 05 ?? ?? ?? ?? 74 60 8D 8D 50 FF FF FF 51 FF 15 ?? ?? ?? ?? 89 85 38 FF FF FF 83 BD 38 FF FF FF FF 75 0C C7 05 ?? ?? ?? ?? FF FF FF FF EB 2D 83 BD 38 FF FF FF 02 75 1A 0F B7 55 EA 85 D2 74 12 83 7D F8 00 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 0A C7 05 ?? ?? ?? ?? 00 00 00 00 8B 85 34 FF FF FF A3 ?? ?? ?? ?? 8B 4D 08 66 8B 15 ?? ?? ?? ?? 66 89 51 0C 6A 00 68 10 27 00 00 8B 85 4C FF FF FF 50 8B 8D 48 FF FF FF 51 E8 ?? ?? ?? ?? 6A 00 68 E8 03 00 00 52 50 E8 ?? ?? ?? ?? 8B 55 08 66 89 42 08 8B 85 48 FF FF FF 2D 00 80 3E D5 8B 8D 4C FF FF FF 81 D9 DE B1 9D 01 6A 00 68 80 96 98 00 51 50 E8 ?? ?? ?? ?? 99 8B 4D 08 89 01 89 51 04 33 C0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_70_0_0 {
	meta:
		name = "_copysignf"
		size = 58
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8D 45 0A 89 45 FC 8D 4D 0E 89 4D F8 8B 55 FC 0F B7 02 25 FF 7F FF FF 8B 4D F8 0F B7 11 81 E2 00 80 00 00 0B C2 8B 4D FC 66 89 01 D9 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "__Cmulcc"
		size = 248
		refs = "0025 _creal 004c _cimag 00d1 __Cbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F8 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 83 EC 10 8B C4 8B 4D 1C 89 08 8B 55 20 89 50 04 8B 4D 24 89 48 08 8B 55 28 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F0 83 EC 10 8B C4 8B 4D 1C 89 08 8B 55 20 89 50 04 8B 4D 24 89 48 08 8B 55 28 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D E0 DD 45 F8 DC 4D E0 DD 45 E8 DC 4D F0 DE C1 83 EC 08 DD 1C 24 DD 45 F8 DC 4D F0 DD 45 E8 DC 4D E0 DE E9 83 EC 08 DD 1C 24 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_434_0_0 {
	meta:
		name = "__LCmulcc"
		size = 248
		refs = "0025 _creall 004c _cimagl 00d1 __LCbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F8 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D E8 83 EC 10 8B C4 8B 4D 1C 89 08 8B 55 20 89 50 04 8B 4D 24 89 48 08 8B 55 28 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D F0 83 EC 10 8B C4 8B 4D 1C 89 08 8B 55 20 89 50 04 8B 4D 24 89 48 08 8B 55 28 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D E0 DD 45 F8 DC 4D E0 DD 45 E8 DC 4D F0 DE C1 83 EC 08 DD 1C 24 DD 45 F8 DC 4D F0 DD 45 E8 DC 4D E0 DE E9 83 EC 08 DD 1C 24 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_71_1_0 {
	meta:
		name = "__Cmulcr"
		size = 142
		refs = "0025 _cimag 0052 _creal 0067 __Cbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DC 4D 1C 83 EC 08 DD 1C 24 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DC 4D 1C 83 EC 08 DD 1C 24 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_434_1_0 {
	meta:
		name = "__LCmulcr"
		size = 142
		refs = "0025 _cimagl 0052 _creall 0067 __LCbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DC 4D 1C 83 EC 08 DD 1C 24 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DC 4D 1C 83 EC 08 DD 1C 24 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_71_2_0 {
	meta:
		name = "_cpow"
		size = 482
		refs = "0025 _cimag 0058 _creal 0061 __real@0000000000000000 00fa _pow 0109 __Cbuild 0157 _clog 0197 __Cmulcc 01bb _cexp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 D9 EE DA E9 DF E0 F6 C4 44 0F 8A FB 00 00 00 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 0F 85 C6 00 00 00 83 EC 10 8B C4 8B 4D 1C 89 08 8B 55 20 89 50 04 8B 4D 24 89 48 08 8B 55 28 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 D9 EE DA E9 DF E0 F6 C4 44 0F 8A 93 00 00 00 83 EC 08 D9 EE DD 1C 24 83 EC 10 8B C4 8B 4D 1C 89 08 8B 55 20 89 50 04 8B 4D 24 89 48 08 8B 55 28 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 AD 00 00 00 E9 A8 00 00 00 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 04 8B D4 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 83 EC 10 8B CC 8B 55 1C 89 11 8B 45 20 89 41 04 8B 55 24 89 51 08 8B 45 28 89 41 0C 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 14 8B D4 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8D 4D C0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_434_2_0 {
	meta:
		name = "_cpowl"
		size = 482
		refs = "0025 _cimagl 0058 _creall 0061 __real@0000000000000000 00fa _powl 0109 __LCbuild 0157 _clogl 0197 __LCmulcc 01bb _cexpl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 D9 EE DA E9 DF E0 F6 C4 44 0F 8A FB 00 00 00 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 0F 85 C6 00 00 00 83 EC 10 8B C4 8B 4D 1C 89 08 8B 55 20 89 50 04 8B 4D 24 89 48 08 8B 55 28 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 D9 EE DA E9 DF E0 F6 C4 44 0F 8A 93 00 00 00 83 EC 08 D9 EE DD 1C 24 83 EC 10 8B C4 8B 4D 1C 89 08 8B 55 20 89 50 04 8B 4D 24 89 48 08 8B 55 28 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 08 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8B 45 08 E9 AD 00 00 00 E9 A8 00 00 00 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 04 8B D4 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 83 EC 10 8B CC 8B 55 1C 89 11 8B 45 20 89 41 04 8B 55 24 89 51 08 8B 45 28 89 41 0C 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 14 8B D4 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8D 4D C0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_72_5_0 {
	meta:
		name = "__ismbchira_l"
		size = 71
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F8 81 78 04 A4 03 00 00 75 12 8B 45 08 05 61 7D FF FF 83 F8 52 77 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_72_7_0 {
	meta:
		name = "__ismbckata_l"
		size = 80
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F8 81 78 04 A4 03 00 00 75 1B 8B 4D 08 8D 81 C0 7C FF FF 83 F8 56 77 0D 81 F9 7F 83 00 00 74 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_72_9_0 {
	meta:
		name = "__ismbcsymbol_l"
		size = 80
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F8 81 78 04 A4 03 00 00 75 1B 8B 4D 08 8D 81 BF 7E FF FF 83 F8 6B 77 0D 81 F9 7F 81 00 00 74 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "_nextafter"
		size = 33
		refs = "0018 _nexttoward"
		altNames = "_nextafterl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 10 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_502_8_2 {
	meta:
		name = "__nextafter"
		size = 33
		refs = "0018 _nextafter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 10 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_714_0_3 {
	meta:
		name = "_atan2l"
		size = 33
		refs = "0018 _atan2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 10 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_458_3_3 {
	meta:
		name = "_fmodl"
		size = 33
		refs = "0018 _fmod"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 10 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_216_1_2 {
	meta:
		name = "_hypotl"
		size = 33
		refs = "0018 __hypot"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 10 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_434_3_3 {
	meta:
		name = "_powl"
		size = 33
		refs = "0018 _pow"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 DD 45 10 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_74_1_0 {
	meta:
		name = "_clogf"
		size = 728
		refs = "0011 _crealf 0024 _cimagf 0033 __fdtest 006a __FInf_C 0072 __FCbuild 00f9 _atan2f 013d __real@0000000000000000 019a __fperrraise 01c7 __real@3fecccccc0000000 01db __real@3fd99999a0000000 01fd __fd_int 021a __real@3ff0000000000000 025c _log1pf 0265 __real@3fe0000000000000 0297 _logf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 3C 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 D9 5D F4 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 D9 5D F0 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 8D 55 F0 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 0F BF 45 FC 83 F8 02 75 46 0F BF 4D F8 83 F9 01 75 20 51 D9 45 F4 D9 1C 24 51 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 56 02 00 00 EB 1B 51 D9 45 F4 D9 1C 24 51 D9 45 F4 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 39 02 00 00 EB 4D 0F BF 55 F8 83 FA 02 75 44 0F BF 45 FC 83 F8 01 75 20 51 D9 45 F0 D9 1C 24 51 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 07 02 00 00 EB 1B 51 D9 45 F0 D9 1C 24 51 D9 45 F0 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 EA 01 00 00 51 D9 45 F4 D9 1C 24 51 D9 45 F0 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 D9 5D E4 0F BF 4D FC 83 F9 01 74 09 0F BF 55 F8 83 FA 01 75 23 51 D9 45 E4 D9 1C 24 51 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 A1 01 00 00 E9 9C 01 00 00 D9 45 F4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 08 D9 45 F4 D9 E0 D9 5D F4 D9 45 F0 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 08 D9 45 F0 D9 E0 D9 5D F0 D9 45 F4 D9 45 F0 DE D9 DF E0 F6 C4 41 75 12 D9 45 F4 D9 5D D8 D9 45 F0 D9 5D F4 D9 45 D8 D9 5D F0 D9 45 F4 D9 EE DA E9 DF E0 F6 C4 44 7A 2B 6A 04 E8 ?? ?? ?? ?? D9 45 E4 D9 1C 24 D9 05 ?? ?? ?? ?? D9 E0 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 17 01 00 00 E9 12 01 00 00 D9 45 F4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 0F 8A A9 00 00 00 D9 45 F0 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 0F 85 95 00 00 00 D9 45 F4 D9 5D EC D9 45 F0 D9 5D E8 6A 0B 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 08 6A 0B 8D 4D E8 51 E8 ?? ?? ?? ?? 83 C4 08 D9 45 EC D8 4D EC DC 25 ?? ?? ?? ?? D9 45 E8 D8 4D E8 DE C1 D9 5D E0 D9 45 F4 D8 65 EC D9 45 F4 D8 45 EC DE C9 D9 45 F0 D8 65 E8 D9 45 F0 D8 45 E8 DE C9 DE C1 D8 45 E0 D9 5D E0 51 D9 45 E4 D9 1C 24 51 D9 45 E0 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 DC 0D ?? ?? ?? ?? D9 5D D4 D9 45 D4 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 EB 57 EB 55 D9 45 F0 D8 75 F4 D9 5D DC 51 D9 45 E4 D9 1C 24 51 D9 45 F4 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D9 45 DC D8 4D DC D9 5D D0 D9 45 D0 51 D9 1C 24 DD 5D C4 E8 ?? ?? ?? ?? 83 C4 04 DC 0D ?? ?? ?? ?? DC 45 C4 D9 5D CC D9 45 CC 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_75_0_0 {
	meta:
		name = "_modf"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __modf_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_415_0_0 {
	meta:
		name = "_ceil"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __ceil_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "_floor"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __floor_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_75_1_0 {
	meta:
		name = "__modf_pentium4"
		size = 264
		refs = "000a _Bns 0031 _Sign 00a9 _Mantissa 00b1 _Zero 00fc ___libm_error_support"
	strings:
		$1 = { F3 0F 7E 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 C8 66 0F 28 E0 66 0F 28 F0 66 0F 73 F0 01 66 0F 73 D0 35 66 0F 73 D3 34 66 0F 54 25 ?? ?? ?? ?? 66 0F 7E C0 66 0F FA D0 8B 4C 24 0C 66 0F D3 CA 66 0F F3 CA 66 0F 7E DA 3D FF 03 00 00 7C 1E 3D 32 04 00 00 7F 20 66 0F D6 09 F2 0F 5C F1 66 0F 56 F4 66 0F D6 74 24 04 DD 44 24 04 C3 66 0F D6 21 DD 44 24 04 C3 3D FF 07 00 00 F3 0F 7E 44 24 04 74 11 66 0F D6 01 81 FA 00 08 00 00 D9 EE 7C 02 D9 E0 C3 66 0F 28 C8 F2 0F 58 C0 66 0F D6 01 66 0F 54 05 ?? ?? ?? ?? 66 0F C2 05 ?? ?? ?? ?? 04 66 0F C5 C0 00 66 0F 54 C1 66 0F 56 C4 BA EF 03 00 00 83 F8 00 75 0B 66 0F D6 44 24 04 DD 44 24 04 C3 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 18 89 54 24 04 83 EA 08 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "_lround"
		size = 120
		refs = "000b __dtest 0034 _round 0043 __real@c1e0000000000000 0050 __real@41dfffffffc00000 0062 __ftol2_sse 006b __fperrraise"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 74 54 83 7D FC 00 7E 06 83 7D FC 02 7E 3E 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D 08 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 1A DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 01 75 0A DD 45 08 E8 ?? ?? ?? ?? EB 0C 6A 01 E8 ?? ?? ?? ?? 83 C4 04 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_493_0_0 {
	meta:
		name = "_lroundl"
		size = 120
		refs = "000b __ldtest 0034 _roundl 0043 __real@c1e0000000000000 0050 __real@41dfffffffc00000 0062 __ftol2_sse 006b __fperrraise"
	strings:
		$1 = { 8B FF 55 8B EC 51 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 74 54 83 7D FC 00 7E 06 83 7D FC 02 7E 3E 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D 08 DD 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 1A DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 01 75 0A DD 45 08 E8 ?? ?? ?? ?? EB 0C 6A 01 E8 ?? ?? ?? ?? 83 C4 04 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "__calloc_base"
		size = 160
		refs = "001e __errno 0059 ___acrt_heap 0060 __imp__HeapAlloc@12 0073 __query_new_mode 0080 __callnewh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 7D 08 00 74 1E B8 E0 FF FF FF 33 D2 F7 75 08 3B 45 0C 73 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 70 8B 45 08 0F AF 45 0C 89 45 FC 83 7D FC 00 75 09 C7 45 F8 01 00 00 00 EB 06 8B 4D FC 89 4D F8 8B 55 F8 89 55 F0 8B 45 F0 50 6A 08 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 74 05 8B 45 F4 EB 2A E8 ?? ?? ?? ?? 85 C0 74 10 8B 55 F0 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 02 EB B5 8B E5 5D C3 }
	condition:
		$1
}

rule file_78_0_0 {
	meta:
		name = "_cabs"
		size = 93
		refs = "0022 _cimag 0049 _creal 0054 _hypot"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_216_0_0 {
	meta:
		name = "_cabsl"
		size = 93
		refs = "0022 _cimagl 0049 _creall 0054 _hypotl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_712_0_0 {
	meta:
		name = "_carg"
		size = 93
		refs = "0022 _creal 0049 _cimag 0054 _atan2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_180_1_0 {
	meta:
		name = "_cargl"
		size = 93
		refs = "0022 _creall 0049 _cimagl 0054 _atan2l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 08 89 08 8B 55 0C 89 50 04 8B 4D 10 89 48 08 8B 55 14 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_79_1_0 {
	meta:
		name = "_casinhl"
		size = 1293
		refs = "000c ___security_cookie 0032 _creall 0059 _cimagl 0068 __ldtest 012e _piby4 016f __LZero_C 01b0 _piby2 01f4 __LCbuild 021b _csqrtl 0356 _big 03ea _asinhl 0409 __real@0000000000000000 041e _logl 0484 __LCmulcc 04b8 _atan2l 0505 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC F4 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D BC 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D C4 8D 45 BC 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 D4 8D 4D C4 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 D8 0F BF 55 D4 83 FA 02 75 47 0F BF 45 D8 83 F8 02 74 08 0F BF 4D D8 85 C9 75 0E DD 45 BC DD 5D CC DD 45 C4 DD 5D AC EB 23 0F BF 55 D8 83 FA 01 75 0E DD 45 C4 DD 5D CC DD 45 BC DD 5D AC EB 0C DD 45 BC DD 5D CC DD 45 BC DD 5D AC E9 EF 03 00 00 0F BF 45 D8 83 F8 02 75 28 0F BF 4D D4 83 F9 01 75 0E DD 45 BC DD 5D CC DD 45 C4 DD 5D AC EB 0C DD 45 C4 DD 5D CC DD 45 C4 DD 5D AC E9 BE 03 00 00 0F BF 55 D4 83 FA 01 0F 85 82 00 00 00 0F BF 45 D8 83 F8 01 75 39 DD 45 BC DD 5D CC D9 EE DC 5D C4 DF E0 F6 C4 41 75 10 DD 05 ?? ?? ?? ?? D9 E0 DD 9D 7C FF FF FF EB 0C DD 05 ?? ?? ?? ?? DD 9D 7C FF FF FF DD 85 7C FF FF FF DD 5D AC EB 3B DD 45 BC DD 5D CC B9 02 00 00 00 6B D1 03 0F B7 44 15 C4 25 00 80 00 00 74 10 DD 05 ?? ?? ?? ?? D9 E0 DD 9D 74 FF FF FF EB 08 D9 EE DD 9D 74 FF FF FF DD 85 74 FF FF FF DD 5D AC E9 2F 03 00 00 0F BF 4D D8 83 F9 01 75 3C DD 45 C4 DD 5D CC D9 EE DC 5D C4 DF E0 F6 C4 41 75 10 DD 05 ?? ?? ?? ?? D9 E0 DD 9D 6C FF FF FF EB 0C DD 05 ?? ?? ?? ?? DD 9D 6C FF FF FF DD 85 6C FF FF FF DD 5D AC E9 EA 02 00 00 83 EC 08 DD 45 BC DD 1C 24 D9 E8 DC 65 C4 83 EC 08 DD 1C 24 8D 95 5C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B CC 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8D 8D 4C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 10 89 55 DC 8B 48 04 89 4D E0 8B 50 08 89 55 E4 8B 40 0C 89 45 E8 DD 45 BC D9 E0 83 EC 08 DD 1C 24 D9 E8 DC 45 C4 83 EC 08 DD 1C 24 8D 8D 3C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B D4 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8D 8D 2C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 10 89 55 EC 8B 48 04 89 4D F0 8B 50 08 89 55 F4 8B 40 0C 89 45 F8 DD 45 BC D9 EE DA E9 DF E0 F6 C4 44 7A 0B DD 45 BC DD 5D CC E9 8F 01 00 00 83 EC 10 8B CC 8B 55 DC 89 11 8B 45 E0 89 41 04 8B 55 E4 89 51 08 8B 45 E8 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D 9C 83 EC 10 8B CC 8B 55 DC 89 11 8B 45 E0 89 41 04 8B 55 E4 89 51 08 8B 45 E8 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D A4 83 EC 10 8B CC 8B 55 EC 89 11 8B 45 F0 89 41 04 8B 55 F4 89 51 08 8B 45 F8 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D 94 83 EC 10 8B CC 8B 55 EC 89 11 8B 45 F0 89 41 04 8B 55 F4 89 51 08 8B 45 F8 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D 8C DD 45 9C DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 17 DD 45 9C DD 5D B4 DD 45 94 DC 75 B4 DC 4D A4 DC 65 8C DD 5D 84 EB 68 DD 45 A4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 17 DD 45 A4 DD 5D B4 DD 45 8C DC 75 B4 DC 4D 9C DC 6D 94 DD 5D 84 EB 41 DD 45 A4 D9 E0 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 19 DD 45 A4 D9 E0 DD 5D B4 DD 45 8C DC 75 B4 DC 4D 9C DC 6D 94 DD 5D 84 EB 16 D9 EE DD 5D B4 DD 45 A4 DC 4D 94 DD 45 9C DC 4D 8C DE E9 DD 5D 84 83 EC 08 DD 45 84 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D CC DD 45 B4 D9 EE DA E9 DF E0 F6 C4 44 7A 02 EB 40 DD 45 CC DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 19 83 EC 08 DD 45 B4 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 45 CC DD 5D CC EB 17 83 EC 08 DD 45 B4 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 6D CC DD 5D CC 83 EC 10 8B CC 8B 55 EC 89 11 8B 45 F0 89 41 04 8B 55 F4 89 51 08 8B 45 F8 89 41 0C 83 EC 10 8B CC 8B 55 DC 89 11 8B 45 E0 89 41 04 8B 55 E4 89 51 08 8B 45 E8 89 41 0C 8D 8D 1C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B D4 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 08 DD 45 C4 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D AC 83 EC 08 DD 45 AC DD 1C 24 83 EC 08 DD 45 CC DD 1C 24 8D 8D 0C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_150_0_0 {
	meta:
		name = "_casinh"
		size = 1293
		refs = "000c ___security_cookie 0032 _creal 0059 _cimag 0068 __dtest 012e _piby4 016f __Zero_C 01b0 _piby2 01f4 __Cbuild 021b _csqrt 0356 _big 03ea _asinh 0409 __real@0000000000000000 041e _log 0484 __Cmulcc 04b8 _atan2 0505 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC F4 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D BC 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D C4 8D 45 BC 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 D4 8D 4D C4 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 D8 0F BF 55 D4 83 FA 02 75 47 0F BF 45 D8 83 F8 02 74 08 0F BF 4D D8 85 C9 75 0E DD 45 BC DD 5D CC DD 45 C4 DD 5D AC EB 23 0F BF 55 D8 83 FA 01 75 0E DD 45 C4 DD 5D CC DD 45 BC DD 5D AC EB 0C DD 45 BC DD 5D CC DD 45 BC DD 5D AC E9 EF 03 00 00 0F BF 45 D8 83 F8 02 75 28 0F BF 4D D4 83 F9 01 75 0E DD 45 BC DD 5D CC DD 45 C4 DD 5D AC EB 0C DD 45 C4 DD 5D CC DD 45 C4 DD 5D AC E9 BE 03 00 00 0F BF 55 D4 83 FA 01 0F 85 82 00 00 00 0F BF 45 D8 83 F8 01 75 39 DD 45 BC DD 5D CC D9 EE DC 5D C4 DF E0 F6 C4 41 75 10 DD 05 ?? ?? ?? ?? D9 E0 DD 9D 7C FF FF FF EB 0C DD 05 ?? ?? ?? ?? DD 9D 7C FF FF FF DD 85 7C FF FF FF DD 5D AC EB 3B DD 45 BC DD 5D CC B9 02 00 00 00 6B D1 03 0F B7 44 15 C4 25 00 80 00 00 74 10 DD 05 ?? ?? ?? ?? D9 E0 DD 9D 74 FF FF FF EB 08 D9 EE DD 9D 74 FF FF FF DD 85 74 FF FF FF DD 5D AC E9 2F 03 00 00 0F BF 4D D8 83 F9 01 75 3C DD 45 C4 DD 5D CC D9 EE DC 5D C4 DF E0 F6 C4 41 75 10 DD 05 ?? ?? ?? ?? D9 E0 DD 9D 6C FF FF FF EB 0C DD 05 ?? ?? ?? ?? DD 9D 6C FF FF FF DD 85 6C FF FF FF DD 5D AC E9 EA 02 00 00 83 EC 08 DD 45 BC DD 1C 24 D9 E8 DC 65 C4 83 EC 08 DD 1C 24 8D 95 5C FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 04 8B CC 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8D 8D 4C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 10 89 55 DC 8B 48 04 89 4D E0 8B 50 08 89 55 E4 8B 40 0C 89 45 E8 DD 45 BC D9 E0 83 EC 08 DD 1C 24 D9 E8 DC 45 C4 83 EC 08 DD 1C 24 8D 8D 3C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 04 8B D4 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8D 8D 2C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 10 89 55 EC 8B 48 04 89 4D F0 8B 50 08 89 55 F4 8B 40 0C 89 45 F8 DD 45 BC D9 EE DA E9 DF E0 F6 C4 44 7A 0B DD 45 BC DD 5D CC E9 8F 01 00 00 83 EC 10 8B CC 8B 55 DC 89 11 8B 45 E0 89 41 04 8B 55 E4 89 51 08 8B 45 E8 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D 9C 83 EC 10 8B CC 8B 55 DC 89 11 8B 45 E0 89 41 04 8B 55 E4 89 51 08 8B 45 E8 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D A4 83 EC 10 8B CC 8B 55 EC 89 11 8B 45 F0 89 41 04 8B 55 F4 89 51 08 8B 45 F8 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D 94 83 EC 10 8B CC 8B 55 EC 89 11 8B 45 F0 89 41 04 8B 55 F4 89 51 08 8B 45 F8 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 DD 5D 8C DD 45 9C DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 17 DD 45 9C DD 5D B4 DD 45 94 DC 75 B4 DC 4D A4 DC 65 8C DD 5D 84 EB 68 DD 45 A4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 17 DD 45 A4 DD 5D B4 DD 45 8C DC 75 B4 DC 4D 9C DC 6D 94 DD 5D 84 EB 41 DD 45 A4 D9 E0 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 19 DD 45 A4 D9 E0 DD 5D B4 DD 45 8C DC 75 B4 DC 4D 9C DC 6D 94 DD 5D 84 EB 16 D9 EE DD 5D B4 DD 45 A4 DC 4D 94 DD 45 9C DC 4D 8C DE E9 DD 5D 84 83 EC 08 DD 45 84 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D CC DD 45 B4 D9 EE DA E9 DF E0 F6 C4 44 7A 02 EB 40 DD 45 CC DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 19 83 EC 08 DD 45 B4 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 45 CC DD 5D CC EB 17 83 EC 08 DD 45 B4 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 6D CC DD 5D CC 83 EC 10 8B CC 8B 55 EC 89 11 8B 45 F0 89 41 04 8B 55 F4 89 51 08 8B 45 F8 89 41 0C 83 EC 10 8B CC 8B 55 DC 89 11 8B 45 E0 89 41 04 8B 55 E4 89 51 08 8B 45 E8 89 41 0C 8D 8D 1C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B D4 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 08 DD 45 C4 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 5D AC 83 EC 08 DD 45 AC DD 1C 24 83 EC 08 DD 45 CC DD 1C 24 8D 8D 0C FF FF FF 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "_conjl"
		size = 150
		refs = "0025 _creall 0055 _cimagl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 B8 08 00 00 00 6B C8 00 DD 5C 0D F0 83 EC 10 8B D4 8B 45 0C 89 02 8B 4D 10 89 4A 04 8B 45 14 89 42 08 8B 4D 18 89 4A 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 BA 08 00 00 00 C1 E2 00 DD 5C 15 F0 B8 08 00 00 00 6B C8 00 8D 54 0D F0 8B 45 08 8B 0A 89 08 8B 4A 04 89 48 04 8B 4A 08 89 48 08 8B 52 0C 89 50 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_128_0_0 {
	meta:
		name = "_conj"
		size = 150
		refs = "0025 _creal 0055 _cimag"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 B8 08 00 00 00 6B C8 00 DD 5C 0D F0 83 EC 10 8B D4 8B 45 0C 89 02 8B 4D 10 89 4A 04 8B 45 14 89 42 08 8B 4D 18 89 4A 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 BA 08 00 00 00 C1 E2 00 DD 5C 15 F0 B8 08 00 00 00 6B C8 00 8D 54 0D F0 8B 45 08 8B 0A 89 08 8B 4A 04 89 48 04 8B 4A 08 89 48 08 8B 52 0C 89 50 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "??$common_fopen_s@D@@YAHQAPAU_iobuf@@QBD1@Z"
		size = 177
		refs = "002b ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0030 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0039 ??_C@_1FO@JKHHBFCN@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0040 __CrtDbgReportW 0054 __errno 0068 ??_C@_1BO@JGGJAKB@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAf?$AAo?$AAp?$AAe?$AAn?$AA_?$AAs?$AA?$AA@ 0072 __invalid_parameter 008e ??$common_fsopen@D@@YAPAU_iobuf@@QBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 2D 68 80 00 00 00 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 89 01 8B 55 08 83 3A 00 75 09 E8 ?? ?? ?? ?? 8B 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_1_0 {
	meta:
		name = "??$common_fopen_s@_W@@YAHQAPAU_iobuf@@QB_W1@Z"
		size = 177
		refs = "002b ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0030 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0039 ??_C@_1FO@JKHHBFCN@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0040 __CrtDbgReportW 0054 __errno 0068 ??_C@_1BO@JGGJAKB@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAf?$AAo?$AAp?$AAe?$AAn?$AA_?$AAs?$AA?$AA@ 0072 __invalid_parameter 008e ??$common_fsopen@_W@@YAPAU_iobuf@@QB_W0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 2D 68 80 00 00 00 8B 55 10 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 89 01 8B 55 08 83 3A 00 75 09 E8 ?? ?? ?? ?? 8B 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_2_0 {
	meta:
		name = "??$common_fsopen@D@@YAPAU_iobuf@@QBD0H@Z"
		size = 598
		refs = "0008 __sehtable$??$common_fsopen@D@@YAPAU_iobuf@@QBD0H@Z 000d __except_handler4 001f ___security_cookie 0055 ??_C@_1CK@LLOEFJJG@?$AAf?$AAi?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 005a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0063 ??_C@_1FO@JKHHBFCN@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 006a __CrtDbgReportW 007e __errno 0092 ??_C@_1BM@HBDCPLIA@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAf?$AAs?$AAo?$AAp?$AAe?$AAn?$AA?$AA@ 009c __invalid_parameter 00cd ??_C@_1CA@HJKPLBCC@?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0149 ??_C@_1BG@HEFEIBLN@?$AA?$CK?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 01bf ?__acrt_stdio_allocate_stream@@YA?AV__crt_stdio_stream@@XZ 01ca ?valid@__crt_stdio_stream@@QBE_NXZ 01f6 ?public_stream@__crt_stdio_stream@@QBEPAU_iobuf@@XZ 020e ??$open_file@ABQBDABQBDABHPAU_iobuf@@@?$__crt_char_traits@D@@SAPAU_iobuf@@ABQBD0ABH$$QAPAU1@@Z 0231 ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z 023c ?unlock@__crt_stdio_stream@@QBEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 00 74 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 45 DC 89 45 D8 83 7D D8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 1E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 1E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 9A 01 00 00 83 7D 0C 00 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 D0 83 7D D0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 1F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 1F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 22 01 00 00 8B 4D 0C 0F BE 11 85 D2 74 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 45 CC 89 45 C8 83 7D C8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 20 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D C8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 20 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 A6 00 00 00 8B 55 08 0F BE 02 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 8A 00 00 00 8D 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 8D 4D E4 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 0F E8 ?? ?? ?? ?? C7 00 18 00 00 00 33 C0 EB 60 C7 45 E0 00 00 00 00 C7 45 FC 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 89 45 C4 8D 45 C4 50 8D 4D 10 51 8D 55 0C 52 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 1B 83 7D E0 00 75 0C 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 8D 4D E4 E8 ?? ?? ?? ?? C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_3_0 {
	meta:
		name = "??$common_fsopen@_W@@YAPAU_iobuf@@QB_W0H@Z"
		size = 598
		refs = "0008 __sehtable$??$common_fsopen@_W@@YAPAU_iobuf@@QB_W0H@Z 000d __except_handler4 001f ___security_cookie 0055 ??_C@_1CK@LLOEFJJG@?$AAf?$AAi?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 005a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0063 ??_C@_1FO@JKHHBFCN@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 006a __CrtDbgReportW 007e __errno 0092 ??_C@_1BM@HBDCPLIA@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAf?$AAs?$AAo?$AAp?$AAe?$AAn?$AA?$AA@ 009c __invalid_parameter 00cd ??_C@_1CA@HJKPLBCC@?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0149 ??_C@_1BG@HEFEIBLN@?$AA?$CK?$AAm?$AAo?$AAd?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 01bf ?__acrt_stdio_allocate_stream@@YA?AV__crt_stdio_stream@@XZ 01ca ?valid@__crt_stdio_stream@@QBE_NXZ 01f6 ?public_stream@__crt_stdio_stream@@QBEPAU_iobuf@@XZ 020e ??$open_file@ABQB_WABQB_WABHPAU_iobuf@@@?$__crt_char_traits@_W@@SAPAU_iobuf@@ABQB_W0ABH$$QAPAU1@@Z 0231 ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z 023c ?unlock@__crt_stdio_stream@@QBEXXZ"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 D4 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 00 74 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 45 DC 89 45 D8 83 7D D8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 1E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 1E 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 9A 01 00 00 83 7D 0C 00 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 55 D4 89 55 D0 83 7D D0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 1F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 1F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 22 01 00 00 8B 4D 0C 0F B7 11 85 D2 74 09 C7 45 CC 01 00 00 00 EB 07 C7 45 CC 00 00 00 00 8B 45 CC 89 45 C8 83 7D C8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 20 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D C8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 20 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 A6 00 00 00 8B 55 08 0F B7 02 85 C0 75 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 8A 00 00 00 8D 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 8D 4D E4 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 0F E8 ?? ?? ?? ?? C7 00 18 00 00 00 33 C0 EB 60 C7 45 E0 00 00 00 00 C7 45 FC 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 89 45 C4 8D 45 C4 50 8D 4D 10 51 8D 55 0C 52 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 1B 83 7D E0 00 75 0C 8B 4D E4 51 E8 ?? ?? ?? ?? 83 C4 04 8D 4D E4 E8 ?? ?? ?? ?? C3 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_81_4_0 {
	meta:
		name = "??$open_file@ABQBDABQBDABHPAU_iobuf@@@?$__crt_char_traits@D@@SAPAU_iobuf@@ABQBD0ABH$$QAPAU1@@Z"
		size = 39
		refs = "001e __openfile"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_484_15_4 {
	meta:
		name = "??$itot_s@ABIPADIH@?$__crt_char_traits@D@@SAHABI$$QAPAD$$QAI$$QAH@Z"
		size = 39
		refs = "001e __itoa_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_484_16_4 {
	meta:
		name = "??$itot_s@ABIPA_WIH@?$__crt_char_traits@_W@@SAHABI$$QAPA_W$$QAI$$QAH@Z"
		size = 39
		refs = "001e __itow_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_226_4_0 {
	meta:
		name = "??$open_file@ABQB_WABQB_WABHPAU_iobuf@@@?$__crt_char_traits@_W@@SAPAU_iobuf@@ABQB_W0ABH$$QAPAU1@@Z"
		size = 39
		refs = "001e __wopenfile"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_337_20_0 {
	meta:
		name = "??$tcsncat_s@AAPADABIABQBDI@?$__crt_char_traits@D@@SAHAAPADABIABQBD$$QAI@Z"
		size = 39
		refs = "001e _strncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_337_21_3 {
	meta:
		name = "??$tcsncat_s@AAPA_WABIABQB_WI@?$__crt_char_traits@_W@@SAHAAPA_WABIABQB_W$$QAI@Z"
		size = 39
		refs = "001e _wcsncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_484_35_0 {
	meta:
		name = "??$tcsncat_s@ABQADABIAAPBDI@?$__crt_char_traits@D@@SAHABQADABIAAPBD$$QAI@Z"
		size = 39
		refs = "001e _strncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_484_36_0 {
	meta:
		name = "??$tcsncat_s@ABQADABIABQBDABI@?$__crt_char_traits@D@@SAHABQADABIABQBD1@Z"
		size = 39
		refs = "001e _strncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_484_37_4 {
	meta:
		name = "??$tcsncat_s@ABQADABIPBDI@?$__crt_char_traits@D@@SAHABQADABI$$QAPBD$$QAI@Z"
		size = 39
		refs = "001e _strncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_484_38_4 {
	meta:
		name = "??$tcsncat_s@ABQA_WABIAAPB_WI@?$__crt_char_traits@_W@@SAHABQA_WABIAAPB_W$$QAI@Z"
		size = 39
		refs = "001e _wcsncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_484_39_3 {
	meta:
		name = "??$tcsncat_s@ABQA_WABIABQB_WABI@?$__crt_char_traits@_W@@SAHABQA_WABIABQB_W1@Z"
		size = 39
		refs = "001e _wcsncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_484_40_2 {
	meta:
		name = "??$tcsncat_s@ABQA_WABIPB_WI@?$__crt_char_traits@_W@@SAHABQA_WABI$$QAPB_W$$QAI@Z"
		size = 39
		refs = "001e _wcsncat_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_424_21_2 {
	meta:
		name = "??$tcsncpy_s@AAPADIAAPADABI@?$__crt_char_traits@D@@SAHAAPAD$$QAI0ABI@Z"
		size = 39
		refs = "001e _strncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_693_12_4 {
	meta:
		name = "??$tcsncpy_s@AAPADIAAPBDABI@?$__crt_char_traits@D@@SAHAAPAD$$QAIAAPBDABI@Z"
		size = 39
		refs = "001e _strncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_693_13_3 {
	meta:
		name = "??$tcsncpy_s@AAPADIAAPBDH@?$__crt_char_traits@D@@SAHAAPAD$$QAIAAPBD$$QAH@Z"
		size = 39
		refs = "001e _strncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_424_22_0 {
	meta:
		name = "??$tcsncpy_s@AAPA_WIAAPA_WABI@?$__crt_char_traits@_W@@SAHAAPA_W$$QAI0ABI@Z"
		size = 39
		refs = "001e _wcsncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_693_14_3 {
	meta:
		name = "??$tcsncpy_s@AAPA_WIAAPB_WABI@?$__crt_char_traits@_W@@SAHAAPA_W$$QAIAAPB_WABI@Z"
		size = 39
		refs = "001e _wcsncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_693_15_3 {
	meta:
		name = "??$tcsncpy_s@AAPA_WIAAPB_WH@?$__crt_char_traits@_W@@SAHAAPA_W$$QAIAAPB_W$$QAH@Z"
		size = 39
		refs = "001e _wcsncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_424_23_2 {
	meta:
		name = "??$tcsncpy_s@PADABIABQBDABI@?$__crt_char_traits@D@@SAH$$QAPADABIABQBD1@Z"
		size = 39
		refs = "001e _strncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_424_24_0 {
	meta:
		name = "??$tcsncpy_s@PADIABQBDABI@?$__crt_char_traits@D@@SAH$$QAPAD$$QAIABQBDABI@Z"
		size = 39
		refs = "001e _strncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_424_25_3 {
	meta:
		name = "??$tcsncpy_s@PA_WABIABQB_WABI@?$__crt_char_traits@_W@@SAH$$QAPA_WABIABQB_W1@Z"
		size = 39
		refs = "001e _wcsncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_424_26_4 {
	meta:
		name = "??$tcsncpy_s@PA_WIABQB_WABI@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAIABQB_WABI@Z"
		size = 39
		refs = "001e _wcsncpy_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_465_34_3 {
	meta:
		name = "??$ultot_s@AAIABQADABIH@?$__crt_char_traits@D@@SAHAAIABQADABI$$QAH@Z"
		size = 39
		refs = "001e __ultoa_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_465_35_0 {
	meta:
		name = "??$ultot_s@AAIABQA_WABIH@?$__crt_char_traits@_W@@SAHAAIABQA_WABI$$QAH@Z"
		size = 39
		refs = "001e __ultow_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 8B 08 51 8B 55 10 8B 02 50 8B 4D 0C 8B 11 52 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_81_10_0 {
	meta:
		name = "__wfopen"
		size = 25
		refs = "0010 ??$common_fsopen@_W@@YAPAU_iobuf@@QB_W0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 40 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_81_13_0 {
	meta:
		name = "_fopen"
		size = 25
		refs = "0010 ??$common_fsopen@D@@YAPAU_iobuf@@QBD0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 40 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "_exp"
		size = 60
		refs = "0002 ___use_sse2_mathfcns 0037 __exp_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 6E 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 41 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_82_1_0 {
	meta:
		name = "__CIexp"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIexp_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 3C 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 0F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "___abstract_cw_sse2"
		size = 324
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C C7 45 FC 00 00 00 00 8B 45 08 25 80 00 00 00 74 09 8B 4D FC 83 C9 10 89 4D FC 8B 55 08 81 E2 00 02 00 00 74 09 8B 45 FC 83 C8 08 89 45 FC 8B 4D 08 81 E1 00 04 00 00 74 09 8B 55 FC 83 CA 04 89 55 FC 8B 45 08 25 00 08 00 00 74 09 8B 4D FC 83 C9 02 89 4D FC 8B 55 08 81 E2 00 10 00 00 74 09 8B 45 FC 83 C8 01 89 45 FC 8B 4D 08 81 E1 00 01 00 00 74 0C 8B 55 FC 81 CA 00 00 08 00 89 55 FC 8B 45 08 25 00 60 00 00 89 45 F8 81 7D F8 00 40 00 00 77 1A 81 7D F8 00 40 00 00 74 24 83 7D F8 00 74 16 81 7D F8 00 20 00 00 74 23 EB 3A 81 7D F8 00 60 00 00 74 25 EB 2F 8B 4D FC 89 4D FC EB 27 8B 55 FC 81 CA 00 02 00 00 89 55 FC EB 19 8B 45 FC 0D 00 01 00 00 89 45 FC EB 0C 8B 4D FC 81 C9 00 03 00 00 89 4D FC 8B 55 08 81 E2 40 80 00 00 89 55 F4 83 7D F4 40 74 21 81 7D F4 00 80 00 00 74 26 81 7D F4 40 80 00 00 74 02 EB 27 8B 45 FC 0D 00 00 00 01 89 45 FC EB 1A 8B 4D FC 81 C9 00 00 00 02 89 4D FC EB 0C 8B 55 FC 81 CA 00 00 00 03 89 55 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_1_0 {
	meta:
		name = "___abstract_sw_sse2"
		size = 132
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 8B 45 08 83 E0 3F 74 68 8B 4D 08 83 E1 01 74 09 8B 55 FC 83 CA 10 89 55 FC 8B 45 08 83 E0 04 74 09 8B 4D FC 83 C9 08 89 4D FC 8B 55 08 83 E2 08 74 09 8B 45 FC 83 C8 04 89 45 FC 8B 4D 08 83 E1 10 74 09 8B 55 FC 83 CA 02 89 55 FC 8B 45 08 83 E0 20 74 09 8B 4D FC 83 C9 01 89 4D FC 8B 55 08 83 E2 02 74 0B 8B 45 FC 0D 00 00 08 00 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_2_0 {
	meta:
		name = "___clearfp_sse2"
		size = 41
		refs = "001e ___abstract_sw_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 0F AE 5D FC 8B 45 FC 83 E0 C0 89 45 F8 0F AE 55 F8 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_3_0 {
	meta:
		name = "___control87_2"
		size = 164
		refs = "0018 __abstract_cw 0042 __hw_cw 0074 ___isa_available 0084 ___control87_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 83 7D 10 00 74 5E 9B D9 7D F8 0F B7 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 8B 4D 08 23 4D 0C 8B 55 0C F7 D2 23 55 F0 0B CA 89 4D F4 8B 45 F4 3B 45 F0 74 27 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC D9 6D FC 9B D9 7D FC 0F B7 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 8B 45 10 8B 4D F4 89 08 83 7D 14 00 74 29 83 3D ?? ?? ?? ?? 01 7C 17 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 14 89 01 EB 09 8B 55 14 C7 02 00 00 00 00 B8 01 00 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_4_0 {
	meta:
		name = "___control87_sse2"
		size = 117
		refs = "001c ___abstract_cw_sse2 004b ___hw_cw_sse2 005a ___set_fpsr_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 45 0C 25 1F 03 08 03 89 45 0C 0F AE 5D F0 8B 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8B 55 08 23 55 0C 8B 45 0C F7 D0 23 45 FC 0B D0 89 55 F4 8B 4D F4 3B 4D FC 75 05 8B 45 FC EB 2B 8B 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 0F AE 5D F8 8B 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_5_0 {
	meta:
		name = "___fpreset_sse2"
		size = 29
		refs = "0012 ___set_fpsr_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 80 1F 00 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_6_0 {
	meta:
		name = "___hw_cw_sse2"
		size = 324
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C C7 45 FC 00 00 00 00 8B 45 08 83 E0 10 74 0C 8B 4D FC 81 C9 80 00 00 00 89 4D FC 8B 55 08 83 E2 08 74 0B 8B 45 FC 0D 00 02 00 00 89 45 FC 8B 4D 08 83 E1 04 74 0C 8B 55 FC 81 CA 00 04 00 00 89 55 FC 8B 45 08 83 E0 02 74 0C 8B 4D FC 81 C9 00 08 00 00 89 4D FC 8B 55 08 83 E2 01 74 0B 8B 45 FC 0D 00 10 00 00 89 45 FC 8B 4D 08 81 E1 00 00 08 00 74 0C 8B 55 FC 81 CA 00 01 00 00 89 55 FC 8B 45 08 25 00 03 00 00 89 45 F8 81 7D F8 00 02 00 00 77 1A 81 7D F8 00 02 00 00 74 24 83 7D F8 00 74 16 81 7D F8 00 01 00 00 74 23 EB 3A 81 7D F8 00 03 00 00 74 25 EB 2F 8B 4D FC 89 4D FC EB 27 8B 55 FC 81 CA 00 40 00 00 89 55 FC EB 19 8B 45 FC 0D 00 20 00 00 89 45 FC EB 0C 8B 4D FC 81 C9 00 60 00 00 89 4D FC 8B 55 08 81 E2 00 00 00 03 89 55 F4 81 7D F4 00 00 00 01 74 14 81 7D F4 00 00 00 02 74 18 81 7D F4 00 00 00 03 74 1A EB 24 8B 45 FC 0D 40 80 00 00 89 45 FC EB 17 8B 4D FC 83 C9 40 89 4D FC EB 0C 8B 55 FC 81 CA 00 80 00 00 89 55 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_7_0 {
	meta:
		name = "___statusfp_sse2"
		size = 30
		refs = "0007 ___get_fpsr_sse2 0013 ___abstract_sw_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 51 E8 ?? ?? ?? ?? 89 45 FC 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_8_0 {
	meta:
		name = "__abstract_cw"
		size = 330
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C C7 45 FC 00 00 00 00 0F B7 45 08 83 E0 01 74 09 8B 4D FC 83 C9 10 89 4D FC 0F B7 55 08 83 E2 04 74 09 8B 45 FC 83 C8 08 89 45 FC 0F B7 4D 08 83 E1 08 74 09 8B 55 FC 83 CA 04 89 55 FC 0F B7 45 08 83 E0 10 74 09 8B 4D FC 83 C9 02 89 4D FC 0F B7 55 08 83 E2 20 74 09 8B 45 FC 83 C8 01 89 45 FC 0F B7 4D 08 83 E1 02 74 0C 8B 55 FC 81 CA 00 00 08 00 89 55 FC 0F B7 45 08 25 00 0C 00 00 89 45 F8 81 7D F8 00 08 00 00 7F 1A 81 7D F8 00 08 00 00 74 24 83 7D F8 00 74 16 81 7D F8 00 04 00 00 74 23 EB 3A 81 7D F8 00 0C 00 00 74 25 EB 2F 8B 4D FC 89 4D FC EB 27 8B 55 FC 81 CA 00 02 00 00 89 55 FC EB 19 8B 45 FC 0D 00 01 00 00 89 45 FC EB 0C 8B 4D FC 81 C9 00 03 00 00 89 4D FC 0F B7 55 08 81 E2 00 03 00 00 89 55 F4 74 2A 81 7D F4 00 02 00 00 74 13 81 7D F4 00 03 00 00 74 02 EB 22 8B 45 FC 89 45 FC EB 1A 8B 4D FC 81 C9 00 00 01 00 89 4D FC EB 0C 8B 55 FC 81 CA 00 00 02 00 89 55 FC 0F B7 45 08 25 00 10 00 00 74 0C 8B 4D FC 81 C9 00 00 04 00 89 4D FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_9_0 {
	meta:
		name = "__abstract_sw"
		size = 139
	strings:
		$1 = { 8B FF 55 8B EC 51 C7 45 FC 00 00 00 00 0F B7 45 08 83 E0 3F 74 6E 0F B7 4D 08 83 E1 01 74 09 8B 55 FC 83 CA 10 89 55 FC 0F B7 45 08 83 E0 04 74 09 8B 4D FC 83 C9 08 89 4D FC 0F B7 55 08 83 E2 08 74 09 8B 45 FC 83 C8 04 89 45 FC 0F B7 4D 08 83 E1 10 74 09 8B 55 FC 83 CA 02 89 55 FC 0F B7 45 08 83 E0 20 74 09 8B 4D FC 83 C9 01 89 4D FC 0F B7 55 08 83 E2 02 74 0B 8B 45 FC 0D 00 00 08 00 89 45 FC 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_10_0 {
	meta:
		name = "__clearfp"
		size = 65
		refs = "000e ___isa_available 001b __abstract_sw 0025 ___clearfp_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 51 56 DD 7D FC DB E2 83 3D ?? ?? ?? ?? 01 7C 1A 0F B7 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 E8 ?? ?? ?? ?? 0B C6 EB 0F EB 0D 0F B7 4D FC 51 E8 ?? ?? ?? ?? 83 C4 04 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_11_0 {
	meta:
		name = "__control87"
		size = 176
		refs = "0012 __abstract_cw 003c __hw_cw 0060 ___isa_available 0070 ___control87_sse2 007f ?commonFlags@?1??_control87@@9@9"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 9B D9 7D F8 0F B7 45 F8 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 EC 8B 4D 08 23 4D 0C 8B 55 0C F7 D2 23 55 EC 0B CA 89 4D F4 8B 45 F4 3B 45 EC 74 27 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC D9 6D FC 9B D9 7D FC 0F B7 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 3D ?? ?? ?? ?? 01 7C 42 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 F0 8B 55 F0 23 15 ?? ?? ?? ?? 8B 45 F4 23 05 ?? ?? ?? ?? 3B D0 74 0F 8B 45 F4 0B 45 F0 0D 00 00 00 80 EB 0F EB 08 8B 45 F0 0B 45 F4 EB 05 EB 03 8B 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_12_0 {
	meta:
		name = "__controlfp"
		size = 28
		refs = "0013 __control87"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 25 FF FF F7 FF 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_83_13_0 {
	meta:
		name = "__fpreset"
		size = 87
		refs = "0009 ___pxcptinfoptrs 0015 __initialize_default_precision 001a ___fpreset_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 E8 ?? ?? ?? ?? 8B 00 89 45 FC DB E3 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D FC 00 74 2F 8B 4D FC 8B 51 04 8B 02 25 08 00 01 00 74 20 8B 4D FC 8B 51 04 83 C2 1C 89 55 F8 8B 45 F8 C7 40 04 00 00 00 00 8B 4D F8 C7 41 08 FF FF 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_14_0 {
	meta:
		name = "__hw_cw"
		size = 350
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 33 C0 66 89 45 FC 8B 4D 08 83 E1 10 74 0B 0F B7 55 FC 83 CA 01 66 89 55 FC 8B 45 08 83 E0 08 74 0B 0F B7 4D FC 83 C9 04 66 89 4D FC 8B 55 08 83 E2 04 74 0B 0F B7 45 FC 83 C8 08 66 89 45 FC 8B 4D 08 83 E1 02 74 0B 0F B7 55 FC 83 CA 10 66 89 55 FC 8B 45 08 83 E0 01 74 0B 0F B7 4D FC 83 C9 20 66 89 4D FC 8B 55 08 81 E2 00 00 08 00 74 0B 0F B7 45 FC 83 C8 02 66 89 45 FC 8B 4D 08 81 E1 00 03 00 00 89 4D F8 81 7D F8 00 02 00 00 77 1A 81 7D F8 00 02 00 00 74 26 83 7D F8 00 74 16 81 7D F8 00 01 00 00 74 26 EB 42 81 7D F8 00 03 00 00 74 2B EB 37 66 8B 55 FC 66 89 55 FC EB 2D 0F B7 45 FC 0D 00 08 00 00 66 89 45 FC EB 1E 0F B7 4D FC 81 C9 00 04 00 00 66 89 4D FC EB 0E 0F B7 55 FC 81 CA 00 0C 00 00 66 89 55 FC 8B 45 08 25 00 00 03 00 89 45 F4 74 14 81 7D F4 00 00 01 00 74 1B 81 7D F4 00 00 02 00 74 22 EB 28 0F B7 4D FC 81 C9 00 03 00 00 66 89 4D FC EB 18 0F B7 55 FC 81 CA 00 02 00 00 66 89 55 FC EB 08 66 8B 45 FC 66 89 45 FC 8B 4D 08 81 E1 00 00 04 00 74 0E 0F B7 55 FC 81 CA 00 10 00 00 66 89 55 FC 66 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_16_0 {
	meta:
		name = "__set_controlfp"
		size = 138
		refs = "002d ___isa_available 0057 ??_C@_1GE@KFPKEKCH@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 005c ??_C@_1BO@OFDNCLL@?$AA_?$AAs?$AAe?$AAt?$AA_?$AAc?$AAo?$AAn?$AAt?$AAr?$AAo?$AAl?$AAf?$AAp?$AA?$AA@ 0061 ??_C@_1GO@OKJGOMCB@?$AA_?$AAc?$AAo?$AAn?$AAt?$AAr?$AAo?$AAl?$AAf?$AAp?$AA_?$AAs?$AA?$CI?$AA?$CI?$AA?$CI?$AAv?$AAo?$AAi?$AAd?$AA?5?$AA?$CK?$AA?$CJ?$AA0?$AA?$CJ?$AA?0?$AA?5?$AAn?$AAe?$AAw?$AAc?$AAt?$AAr@ 0076 __controlfp_s 007f __invoke_watson_if_error"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 81 7D 08 1F 00 09 00 75 3E 83 7D 0C FF 75 38 9B D9 7D FC 0F BF 45 FC 25 3D 1F 00 00 3D 3D 02 00 00 75 24 83 3D ?? ?? ?? ?? 01 7C 19 0F AE 5D F8 8B 4D F8 81 E1 C0 FE 00 00 81 F9 80 1E 00 00 75 02 EB 3B EB 02 EB 37 6A 00 68 4D 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 55 0C 81 E2 FF FF F7 FF 52 8B 45 08 50 6A 00 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_17_0 {
	meta:
		name = "__statusfp"
		size = 65
		refs = "0012 __abstract_sw 001e ___isa_available 002e ___abstract_sw_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 9B DD 7D FC 0F B7 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 83 3D ?? ?? ?? ?? 01 7C 15 0F AE 5D F4 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 0B 45 F8 EB 03 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_83_18_0 {
	meta:
		name = "__statusfp2"
		size = 54
		refs = "0016 __abstract_sw 0029 ___statusfp_sse2"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 74 16 9B DD 7D FC 0F B7 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D 08 89 01 83 7D 0C 00 74 0A E8 ?? ?? ?? ?? 8B 55 0C 89 02 8B E5 5D C3 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "?try_walk@@YAHQAU_PROCESS_HEAP_ENTRY@@@Z"
		size = 249
		refs = "0008 __sehtable$?try_walk@@YAHQAU_PROCESS_HEAP_ENTRY@@@Z 000d __except_handler4 001f ___security_cookie 0042 ___acrt_heap 0049 __imp__HeapWalk@8 0069 __imp__GetLastError@0"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 C7 45 FC 00 00 00 00 8B 45 08 50 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 74 16 C7 45 E0 FE FF FF FF C7 45 FC FE FF FF FF 8B 45 E0 E9 80 00 00 00 FF 15 ?? ?? ?? ?? 3D 03 01 00 00 75 13 C7 45 DC FB FF FF FF C7 45 FC FE FF FF FF 8B 45 DC EB 60 C7 45 D8 FC FF FF FF C7 45 FC FE FF FF FF 8B 45 D8 EB 4D C7 45 FC FE FF FF FF EB 44 8B 55 EC 8B 02 8B 08 89 4D D4 81 7D D4 05 00 00 C0 75 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 45 E4 C3 8B 65 E8 C7 45 D0 FC FF FF FF C7 45 FC FE FF FF FF 8B 45 D0 EB 07 C7 45 FC FE FF FF FF 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_84_1_0 {
	meta:
		name = "__heapwalk"
		size = 366
		refs = "002b ??_C@_1CC@EEMDPIKB@?$AAe?$AAn?$AAt?$AAr?$AAy?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0030 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0039 ??_C@_1GC@LNLNFIAE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAh@ 0040 __CrtDbgReportW 0054 __errno 0068 ??_C@_1BE@EEFEEHOB@?$AA_?$AAh?$AAe?$AAa?$AAp?$AAw?$AAa?$AAl?$AAk?$AA?$AA@ 0072 __invalid_parameter 00bc ___acrt_heap 00c3 __imp__HeapWalk@8 00f1 __imp__HeapValidate@12 010e ?try_walk@@YAHQAU_PROCESS_HEAP_ENTRY@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 30 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 30 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FA FF FF FF E9 E7 00 00 00 C7 45 D4 00 00 00 00 33 D2 89 55 D8 89 55 DC 89 55 E0 89 55 E4 89 55 E8 89 55 EC 33 C0 66 89 45 DE C6 45 DD 00 8B 4D 08 8B 11 89 55 D4 83 7D D4 00 75 21 8D 45 D4 50 8B 0D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 85 C0 75 0A B8 FD FF FF FF E9 95 00 00 00 EB 4C 8B 55 08 83 7A 08 01 75 29 8B 45 08 8B 08 51 6A 00 8B 15 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 85 C0 75 07 B8 FC FF FF FF EB 6A B8 04 00 00 00 66 89 45 DE 8D 4D D4 51 E8 ?? ?? ?? ?? 83 C4 04 89 45 F4 83 7D F4 FE 74 05 8B 45 F4 EB 47 0F B7 55 DE 83 E2 04 74 22 8B 45 08 8B 4D D4 89 08 8B 55 08 8B 45 D8 89 42 04 8B 4D 08 C7 41 08 01 00 00 00 B8 FE FF FF FF EB 1C 8D 55 D4 52 E8 ?? ?? ?? ?? 83 C4 04 89 45 F0 83 7D F0 FE 74 05 8B 45 F0 EB 02 EB B9 8B E5 5D C3 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "__seterrormode"
		size = 16
		refs = "000a __imp__SetErrorMode@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_86_5_0 {
	meta:
		name = "__mbsnicoll_l"
		size = 404
		refs = "0012 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0033 ??_C@_1BM@ODEBGPLG@?$AAs?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0038 ??_C@_1HC@PFLNBKII@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 003e ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0049 __CrtDbgReportW 0057 __errno 006e ??_C@_1BM@BBBGICEO@?$AAs?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 009c ??_C@_1BK@CNKOCFOL@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAi?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 00a8 __invalid_parameter 00c8 ??_C@_1BK@CMPKHPEC@?$AAn?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AAI?$AAN?$AAT?$AA_?$AAM?$AAA?$AAX?$AA?$AA@ 011d __strnicoll_l 012f __mbsnbcnt_l 0160 ___acrt_CompareStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8D 4D EC 53 56 57 FF 75 14 E8 ?? ?? ?? ?? 8B 5D 10 85 DB 75 07 33 FF E9 57 01 00 00 8B 4D 08 33 C0 85 C9 0F 95 C0 85 C0 75 2F BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 50 6A 3A 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 6A 3A EB 39 33 C0 39 45 0C 0F 95 C0 85 C0 75 4C BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 50 6A 3B 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 6A 3B 56 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 BF FF FF FF 7F E9 C2 00 00 00 BF FF FF FF 7F 3B FB 1B C0 83 C0 01 75 44 BB ?? ?? ?? ?? BE ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 50 6A 3C 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 6A 3C 56 68 ?? ?? ?? ?? 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 70 8B 45 F4 83 78 08 00 75 14 FF 75 14 53 FF 75 0C 51 E8 ?? ?? ?? ?? 83 C4 10 8B F8 EB 53 8D 45 F0 50 53 51 E8 ?? ?? ?? ?? 8B F0 8D 45 F0 50 53 FF 75 0C E8 ?? ?? ?? ?? 8B 4D F4 FF 71 04 50 FF 75 0C 8D 45 F0 56 FF 75 08 68 01 10 00 00 FF B1 1C 02 00 00 50 E8 ?? ?? ?? ?? 83 C4 38 85 C0 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 03 8D 78 FE 80 7D F8 00 74 0A 8B 4D EC 83 A1 50 03 00 00 FD 8B C7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_87_4_0 {
	meta:
		name = "___dcrt_multibyte_check_type"
		size = 105
		refs = "003e ___acrt_GetStringTypeA"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 56 8B 75 0C 8B 56 04 83 7A 08 00 75 04 33 C0 EB 4C 8B 4D 08 8B C1 8B 52 04 83 65 F8 00 6A 01 C1 E8 08 52 88 45 FC 8D 45 F8 50 6A 02 8D 45 FC 88 4D FD 50 6A 01 56 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 74 CB 66 83 7D FA 00 75 C4 8B 45 F8 23 45 10 66 85 C0 0F 95 C1 33 C0 3A 4D 14 0F 94 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_87_6_0 {
	meta:
		name = "__ismbcprint_l"
		size = 104
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 004d ___dcrt_multibyte_check_type"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 4D F0 FF 75 0C E8 ?? ?? ?? ?? 8B 45 08 3D FF 00 00 00 77 26 0F B6 C8 BA 57 01 00 00 8B 45 F4 8B 00 66 85 14 48 75 0E 8B 45 F8 F6 44 01 19 03 75 04 33 C0 EB 16 33 C0 40 EB 11 6A 00 6A 20 8D 4D F4 51 50 E8 ?? ?? ?? ?? 83 C4 10 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "__FCosh"
		size = 305
		refs = "000d __fdtest 0078 __real@0000000000000000 0085 __FInf_C 00a6 __fperrraise 00af __FNan_C 00db __FXbig_C 00f5 __fdexp 0101 __real@3fd0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 8D 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 0F BF 55 FC 85 D2 7D 0C 0F BF 45 F8 85 C0 0F 8C 82 00 00 00 0F BF 4D FC 83 F9 02 75 0A D9 45 08 E9 E0 00 00 00 EB 6D 0F BF 55 F8 83 FA 02 75 0A D9 45 0C E9 CD 00 00 00 EB 5A 0F BF 45 FC 83 F8 01 75 4C 0F BF 4D F8 85 C9 74 30 D9 45 0C DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 0D D9 05 ?? ?? ?? ?? D9 E0 D9 5D F4 EB 09 D9 05 ?? ?? ?? ?? D9 5D F4 D9 45 F4 E9 8C 00 00 00 EB 12 6A 01 E8 ?? ?? ?? ?? 83 C4 04 D9 05 ?? ?? ?? ?? EB 78 EB 05 D9 45 0C EB 71 EB 6F D9 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 08 D9 45 08 D9 E0 D9 5D 08 D9 45 08 D9 05 ?? ?? ?? ?? DE D9 DF E0 F6 C4 41 75 2D 6A FF 51 D9 E8 D9 1C 24 8D 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C D9 45 08 DC 3D ?? ?? ?? ?? D8 45 08 D8 4D 0C D9 5D F0 D9 45 F0 EB 1A EB 18 6A FF 51 D9 45 0C D9 1C 24 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C D9 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_88_1_0 {
	meta:
		name = "_ccoshf"
		size = 712
		refs = "0011 _crealf 0024 _cimagf 0033 __fdtest 0069 __FNan_C 0071 __FCbuild 00b5 __fperrraise 00c9 __real@0000000000000000 00d6 __FZero_C 011c __FInf_C 0238 _sinf 0257 _cosf 0291 __FSinh 02b2 __FCosh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 D9 5D F0 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 D9 5D F4 8D 4D F0 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 8D 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 0F BF 45 FC 83 F8 02 75 4E 0F BF 4D F8 85 C9 75 20 51 D9 45 F4 D9 1C 24 51 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 47 02 00 00 EB 21 51 D9 05 ?? ?? ?? ?? D9 1C 24 51 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 24 02 00 00 E9 1F 02 00 00 0F BF 55 F8 83 FA 01 0F 85 A6 00 00 00 6A 01 E8 ?? ?? ?? ?? 83 C4 04 0F BF 45 FC 85 C0 75 42 D9 45 F4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 0D D9 05 ?? ?? ?? ?? D9 E0 D9 5D EC EB 05 D9 EE D9 5D EC 51 D9 45 EC D9 1C 24 51 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 C0 01 00 00 EB 4D 0F BF 4D FC 83 F9 01 75 23 51 D9 05 ?? ?? ?? ?? D9 1C 24 51 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 94 01 00 00 EB 21 51 D9 05 ?? ?? ?? ?? D9 1C 24 51 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 71 01 00 00 E9 6C 01 00 00 0F BF 55 F8 83 FA 02 75 7A 0F BF 45 FC 85 C0 75 20 51 D9 45 F0 D9 1C 24 51 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 3D 01 00 00 EB 4D 0F BF 4D FC 83 F9 01 75 23 51 D9 05 ?? ?? ?? ?? D9 1C 24 51 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 11 01 00 00 EB 21 51 D9 05 ?? ?? ?? ?? D9 1C 24 51 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 EE 00 00 00 E9 E9 00 00 00 0F BF 55 FC 83 FA 01 0F 85 92 00 00 00 0F BF 45 F8 85 C0 75 40 D9 45 F0 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 0A D9 45 F4 D9 E0 D9 5D E8 EB 06 D9 45 F4 D9 5D E8 51 D9 45 E8 D9 1C 24 51 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 96 00 00 00 EB 48 51 D9 45 F4 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D8 0D ?? ?? ?? ?? D9 5D E4 D9 45 E4 51 D9 1C 24 51 D9 45 F4 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D8 0D ?? ?? ?? ?? D9 5D E0 D9 45 E0 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 EB 4C EB 4A 51 D9 45 F4 D9 1C 24 E8 ?? ?? ?? ?? D9 1C 24 51 D9 45 F0 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D9 1C 24 51 D9 45 F4 D9 1C 24 E8 ?? ?? ?? ?? D9 1C 24 51 D9 45 F0 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "__cgetws"
		size = 229
		refs = "0018 ??_C@_1CE@BLLJFLOH@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0020 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002b ??_C@_1GI@GFGGGLNM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0033 __CrtDbgReportW 0041 ___doserrno 0048 __errno 0054 ??_C@_1BA@IJPIFGNE@?$AA_?$AAc?$AAg?$AAe?$AAt?$AAw?$AAs?$AA?$AA@ 0060 __invalid_parameter 007b ??_C@_1BM@OHODNOMF@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?$FL?$AA0?$AA?$FN?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 00c7 __cgetws_s"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 33 C0 57 8B 7D 08 85 FF 0F 95 C0 85 C0 75 54 BB ?? ?? ?? ?? 33 F6 53 68 ?? ?? ?? ?? 56 68 98 00 00 00 BF ?? ?? ?? ?? 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 56 68 98 00 00 00 57 68 ?? ?? ?? ?? 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 73 0F B7 0F 66 33 C0 66 3B C1 1B C0 F7 D8 75 3D BB ?? ?? ?? ?? 33 F6 53 68 ?? ?? ?? ?? 56 68 99 00 00 00 BF ?? ?? ?? ?? 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 56 68 99 00 00 00 EB 9B 83 65 FC 00 8D 77 04 8B C1 8D 4D FC 51 50 56 E8 ?? ?? ?? ?? 66 8B 4D FC 83 C4 0C F7 D8 66 89 4F 02 1B C0 F7 D0 23 C6 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_89_1_0 {
	meta:
		name = "__cgetws_s"
		size = 694
		refs = "0003 __sehtable$__cgetws_s 0008 __SEH_prolog4 001d ??_C@_1DC@MHMMOEHO@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0022 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002a ??_C@_1GI@GFGGGLNM@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0031 __CrtDbgReportW 0043 ___doserrno 004a __errno 005a ??_C@_1BE@NFEJJKN@?$AA_?$AAc?$AAg?$AAe?$AAt?$AAw?$AAs?$AA_?$AAs?$AA?$AA@ 0066 __invalid_parameter 0085 ??_C@_1CE@ILGEGJJH@?$AAs?$AAi?$AAz?$AAe?$AA_?$AAi?$AAn?$AA_?$AAw?$AAo?$AAr?$AAd?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 00e8 __CrtGetDebugFillThreshold 0100 _memset 0119 ??_C@_1CK@FMNNCIHC@?$AAs?$AAi?$AAz?$AAe?$AA_?$AAr?$AAe?$AAa?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 016a ___acrt_lock 018b ___console_wchar_buffer_used 0194 ___console_wchar_buffer 01c8 ___dcrt_lowio_console_input_handle 01d2 ___dcrt_lowio_initialize_console_input 01e2 __imp__GetLastError@0 01e8 ___acrt_errno_map_os_error 0203 __imp__GetConsoleMode@8 0211 __imp__SetConsoleMode@8 0226 __imp__ReadConsoleW@20 02a5 __SEH_epilog4 02b0 ___acrt_unlock"
	strings:
		$1 = { 6A 1C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 8B 7D 08 85 FF 0F 95 C3 33 F6 85 DB 75 58 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 6A 21 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 85 DB 75 32 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 6A 16 5F 56 6A 21 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 E9 30 02 00 00 33 C0 8B 5D 0C 3B C3 1B C0 F7 D8 89 45 E0 75 25 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 6A 22 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B 45 E0 85 C0 75 23 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 6A 16 5F 56 6A 22 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 93 33 C0 66 89 07 83 FB FF 74 2D 81 FB FF FF FF 7F 74 25 83 FB 01 76 20 E8 ?? ?? ?? ?? 4B 3B C3 72 02 8B C3 03 C0 50 68 FE 00 00 00 8D 47 02 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 8B 5D 10 85 DB 0F 95 C0 89 45 E0 85 C0 75 4F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 6A 25 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B 45 E0 85 C0 75 26 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 6A 16 5F 56 6A 25 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 FC FE FF FF 6A 09 E8 ?? ?? ?? ?? 59 89 75 E0 89 75 FC 89 7D D8 8B 4D 0C 83 E9 01 89 4D E4 89 33 0F 84 0D 01 00 00 83 3D ?? ?? ?? ?? 00 74 2D 66 A1 ?? ?? ?? ?? 66 89 07 83 C7 02 89 7D D8 49 89 4D E4 FF 03 0F B7 05 ?? ?? ?? ?? F7 D8 1B C0 23 C8 89 4D E4 33 C0 66 A3 ?? ?? ?? ?? 85 C9 0F 84 CF 00 00 00 A1 ?? ?? ?? ?? 83 F8 FE 75 0A E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 FF 75 1C FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 30 89 75 E0 E9 9A 00 00 00 8D 4D D4 51 50 FF 15 ?? ?? ?? ?? 6A 07 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 56 8D 45 DC 50 FF 75 E4 57 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 B2 8B 4D DC 6A 0D 58 83 F9 02 72 15 66 39 44 4F FC 75 0E 8D 41 FE 01 03 33 C0 66 89 44 4F FC EB 39 3B 4D E4 75 16 66 39 44 4F FE 75 0F 33 C0 66 89 44 4F FE 8B 45 DC 48 01 03 EB 1E 83 F9 01 75 11 66 83 3F 0A 75 0B 33 C0 66 89 07 8B 03 89 03 EB 08 01 0B 33 C0 66 89 04 4F FF 75 D4 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E0 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_90_0_0 {
	meta:
		name = "___libm_sse2_sincos"
		size = 489
		refs = "001f _PI32INV 002b _SHIFTER 003b _P_1 0047 _P_2 0060 _SC_4 0066 ___acrt_sincos_ctable 007b _P_3 009c _SC_2 00ee _SC_3 00fa _SC_1 017a _ONE 0188 _ALL_ONES 0191 _TWO_POW_55 01a1 _TWO_POW_M55 01be _cos 01d2 _sin"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 4B 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 15 ?? ?? ?? ?? F2 0F 2D D1 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D9 81 C2 00 76 1C 00 66 0F 28 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 06 03 C2 66 0F 59 D1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 66 0F 5C E3 66 0F 28 78 10 66 0F 28 DC 66 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 FC 66 0F 5C DC 66 0F 59 E8 66 0F 59 C0 66 0F 5C DA 66 0F 28 10 66 0F 5C CB 66 0F 28 58 30 66 0F 58 D3 66 0F 5C FA 66 0F 59 CF 66 0F 28 78 10 66 0F 59 D4 66 0F 59 F0 66 0F 59 DC 66 0F 59 D0 66 0F 59 F8 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 C3 66 0F 58 58 10 66 0F 58 F5 F2 0F 10 EE 66 0F 15 F6 66 0F 14 ED 66 0F 59 F7 66 0F 59 D5 66 0F 28 FC 66 0F 58 E3 66 0F 28 68 10 66 0F 5C EB 66 0F 5C DC 66 0F 58 48 20 66 0F 58 E8 66 0F 58 DF 66 0F 58 CD 66 0F 58 CB 66 0F 58 CA 66 0F 58 CE 66 0F 58 CC F2 0F 10 C1 66 0F 15 C9 C3 7F 42 F2 0F 10 C8 66 0F C5 C0 03 66 0D 00 80 66 0F C4 C8 03 F2 0F 58 0D ?? ?? ?? ?? 66 3D 10 80 7D 09 F2 0F 59 05 ?? ?? ?? ?? C3 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C C3 F2 0F 59 05 ?? ?? ?? ?? C3 8B C4 83 EC 20 83 E4 F0 89 44 24 08 66 0F D6 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 5C 24 18 F3 0F 7E 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 F3 0F 7E 4C 24 18 8B 64 24 08 C3 }
	condition:
		$1
}

rule file_91_6_0 {
	meta:
		name = "?InternalCompareStringA@@YAHPAU__crt_locale_pointers@@PB_WKPBDH2HH@Z"
		size = 1160
		refs = "0009 ___security_cookie 0021 ___strncnt 00bf __imp__GetCPInfo@8 00e7 ??_C@_1HK@ELDMAMK@?$AAc?$AAc?$AAh?$AAC?$AAo?$AAu?$AAn?$AAt?$AA1?$AA?$DN?$AA?$DN?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAc?$AAc?$AAh?$AAC?$AAo?$AAu?$AAn?$AAt?$AA2?$AA?$DN?$AA?$DN?$AA1?$AA?5?$AA?$HM?$AA?$HM?$AA?5@ 00ec ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 00f5 ??_C@_1HC@NLKDIKED@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAl@ 00fc __CrtDbgReportW 024f __imp__MultiByteToWideChar@24 026a __MallocaComputeSize 0280 ??_C@_0DJ@MBLHFEOE@minkernel?2crts?2ucrt?2src?2appcrt?2l@ 0296 __malloc_dbg 029f __MarkAllocaS 02ba ??0?$__crt_scoped_stack_ptr_tag@_W@@QAE@QA_W@Z 02c5 ??0?$__crt_scoped_stack_ptr@_W@@QAE@U?$__crt_scoped_stack_ptr_tag@_W@@@Z 02cd ?get@?$__crt_scoped_stack_ptr@_W@@QBEPA_WXZ 02e0 ??1?$__crt_scoped_stack_ptr@_W@@QAE@XZ 0460 ___acrt_CompareStringEx@36 0480 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 58 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 18 00 7E 15 8B 45 18 50 8B 4D 14 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 18 EB 0D 83 7D 18 FF 7D 07 33 C0 E9 40 04 00 00 83 7D 20 00 7E 15 8B 55 20 52 8B 45 1C 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 20 EB 0D 83 7D 20 FF 7D 07 33 C0 E9 18 04 00 00 83 7D 24 00 75 0B 8B 4D 08 8B 11 8B 42 08 89 45 24 83 7D 18 00 74 0A 83 7D 20 00 0F 85 B8 01 00 00 8B 4D 18 3B 4D 20 75 0A B8 02 00 00 00 E9 E5 03 00 00 83 7D 20 01 7E 0A B8 01 00 00 00 E9 D5 03 00 00 83 7D 18 01 7E 0A B8 03 00 00 00 E9 C5 03 00 00 8D 55 E8 52 8B 45 24 50 FF 15 ?? ?? ?? ?? 85 C0 75 07 33 C0 E9 AC 03 00 00 83 7D 18 00 75 06 83 7D 20 01 74 2F 83 7D 18 01 75 06 83 7D 20 00 74 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 6C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D 18 00 0F 8E 8F 00 00 00 83 7D E8 02 73 0A B8 03 00 00 00 E9 57 03 00 00 8D 55 EE 89 55 E4 EB 09 8B 45 E4 83 C0 02 89 45 E4 B9 01 00 00 00 6B D1 00 8B 45 E4 0F B6 0C 10 85 C9 74 51 BA 01 00 00 00 C1 E2 00 8B 45 E4 0F B6 0C 10 85 C9 74 3E 8B 55 14 0F B6 02 B9 01 00 00 00 6B D1 00 8B 4D E4 0F B6 14 11 3B C2 7C 23 8B 45 14 0F B6 08 BA 01 00 00 00 C1 E2 00 8B 45 E4 0F B6 14 10 3B CA 7F 0A B8 02 00 00 00 E9 E4 02 00 00 EB 93 B8 03 00 00 00 E9 D8 02 00 00 83 7D 20 00 0F 8E 8F 00 00 00 83 7D E8 02 73 0A B8 01 00 00 00 E9 BE 02 00 00 8D 45 EE 89 45 E4 EB 09 8B 4D E4 83 C1 02 89 4D E4 BA 01 00 00 00 6B C2 00 8B 4D E4 0F B6 14 01 85 D2 74 51 B8 01 00 00 00 C1 E0 00 8B 4D E4 0F B6 14 01 85 D2 74 3E 8B 45 1C 0F B6 08 BA 01 00 00 00 6B C2 00 8B 55 E4 0F B6 04 02 3B C8 7C 23 8B 4D 1C 0F B6 11 B8 01 00 00 00 C1 E0 00 8B 4D E4 0F B6 04 01 3B D0 7F 0A B8 02 00 00 00 E9 4B 02 00 00 EB 93 B8 01 00 00 00 E9 3F 02 00 00 6A 00 6A 00 8B 4D 18 51 8B 55 14 52 6A 09 8B 45 24 50 FF 15 ?? ?? ?? ?? 89 45 D4 83 7D D4 00 75 07 33 C0 E9 17 02 00 00 8B 4D D4 D1 E1 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 36 68 DD DD 00 00 68 9E 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 D4 D1 E2 52 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 D0 EB 07 C7 45 D0 00 00 00 00 8B 45 D0 50 8D 4D AC E8 ?? ?? ?? ?? 8B 08 51 8D 4D E0 E8 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 85 C0 75 17 C7 45 C8 00 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 C8 E9 8E 01 00 00 8B 55 D4 52 8D 4D E0 E8 ?? ?? ?? ?? 50 8B 45 18 50 8B 4D 14 51 6A 01 8B 55 24 52 FF 15 ?? ?? ?? ?? 85 C0 75 17 C7 45 C4 00 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 C4 E9 52 01 00 00 6A 00 6A 00 8B 45 20 50 8B 4D 1C 51 6A 09 8B 55 24 52 FF 15 ?? ?? ?? ?? 89 45 D8 83 7D D8 00 75 17 C7 45 C0 00 00 00 00 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 C0 E9 1A 01 00 00 8B 45 D8 D1 E0 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 36 68 DD DD 00 00 68 B6 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 4D D8 D1 E1 51 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 CC EB 07 C7 45 CC 00 00 00 00 8B 55 CC 52 8D 4D A8 E8 ?? ?? ?? ?? 8B 00 50 8D 4D DC E8 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 85 C0 75 1F C7 45 BC 00 00 00 00 8D 4D DC E8 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 BC E9 89 00 00 00 8B 4D D8 51 8D 4D DC E8 ?? ?? ?? ?? 50 8B 55 20 52 8B 45 1C 50 6A 01 8B 4D 24 51 FF 15 ?? ?? ?? ?? 89 45 B8 83 7D B8 00 75 1C C7 45 B4 00 00 00 00 8D 4D DC E8 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 B4 EB 43 6A 00 6A 00 6A 00 8B 55 D8 52 8D 4D DC E8 ?? ?? ?? ?? 50 8B 45 D4 50 8D 4D E0 E8 ?? ?? ?? ?? 50 8B 4D 10 51 8B 55 0C 52 E8 ?? ?? ?? ?? 89 45 B0 8D 4D DC E8 ?? ?? ?? ?? 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 B0 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_91_10_0 {
	meta:
		name = "___acrt_CompareStringA"
		size = 83
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0034 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 003a ?InternalCompareStringA@@YAHPAU__crt_locale_pointers@@PB_WKPBDH2HH@Z 0048 ??1_LocaleUpdate@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 8B 45 08 50 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 24 51 8B 55 20 52 8B 45 1C 50 8B 4D 18 51 8B 55 14 52 8B 45 10 50 8B 4D 0C 51 8D 4D EC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 FC 8D 4D EC E8 ?? ?? ?? ?? 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "__mbsncat_s"
		size = 29
		refs = "0014 __mbsncat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_445_0_4 {
	meta:
		name = "__mbccpy_s"
		size = 29
		refs = "0014 __mbccpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "__mbsnbcat_s"
		size = 29
		refs = "0014 __mbsnbcat_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "__mbsnbcpy_s"
		size = 29
		refs = "0014 __mbsnbcpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_412_0_2 {
	meta:
		name = "__mbsnbset_s"
		size = 29
		refs = "0014 __mbsnbset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_524_0_2 {
	meta:
		name = "__mbsncpy_s"
		size = 29
		refs = "0014 __mbsncpy_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_358_0_2 {
	meta:
		name = "__mbsnset_s"
		size = 29
		refs = "0014 __mbsnset_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_93_1_0 {
	meta:
		name = "_bsearch_s"
		size = 719
		refs = "0009 ___security_cookie 003b ??_C@_1DI@OOEEHOBJ@?$AAb?$AAa?$AAs?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAn?$AAu?$AAm?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0040 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0049 ??_C@_1GE@FFLJBFNL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0050 __CrtDbgReportW 0064 __errno 0078 ??_C@_1BE@BBDJDLEB@?$AAb?$AAs?$AAe?$AAa?$AAr?$AAc?$AAh?$AA_?$AAs?$AA?$AA@ 0082 __invalid_parameter 00b3 ??_C@_1BE@NJBEBBME@?$AAw?$AAi?$AAd?$AAt?$AAh?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 012b ??_C@_1CG@PNGKIMLM@?$AAc?$AAo?$AAm?$AAp?$AAa?$AAr?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01ed ___guard_check_icall_fptr 020a ??1scoped_global_state_reset@__crt_state_management@@QAE@XZ 02c7 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 54 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 0C 00 75 0F 83 7D 10 00 74 09 C7 45 E8 00 00 00 00 EB 07 C7 45 E8 01 00 00 00 8B 45 E8 89 45 E4 83 7D E4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 4A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 31 02 00 00 83 7D 14 00 76 09 C7 45 E0 01 00 00 00 EB 07 C7 45 E0 00 00 00 00 8B 55 E0 89 55 DC 83 7D DC 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 4B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D DC 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 B9 01 00 00 83 7D 18 00 74 09 C7 45 D8 01 00 00 00 EB 07 C7 45 D8 00 00 00 00 8B 4D D8 89 4D D4 83 7D D4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 4C 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D4 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 41 01 00 00 8B 45 0C 89 45 F0 8B 4D 10 83 E9 01 0F AF 4D 14 03 4D 0C 89 4D C4 8B 55 F0 3B 55 C4 0F 87 0D 01 00 00 8B 45 10 D1 E8 89 45 F4 0F 84 A9 00 00 00 8B 4D 10 83 E1 01 74 08 8B 55 F4 89 55 D0 EB 09 8B 45 F4 83 E8 01 89 45 D0 8B 4D D0 0F AF 4D 14 03 4D F0 89 4D EC 8B 55 EC 52 8B 45 08 50 8B 4D 1C 51 8B 55 18 89 55 CC 8B 4D CC FF 15 ?? ?? ?? ?? FF 55 CC 83 C4 0C 89 45 C8 83 7D C8 00 75 18 8B 45 EC 89 45 B4 8D 4D FB E8 ?? ?? ?? ?? 8B 45 B4 E9 AB 00 00 00 EB 3F 83 7D C8 00 7D 2A 8B 4D EC 2B 4D 14 89 4D C4 8B 55 10 83 E2 01 74 08 8B 45 F4 89 45 C0 EB 09 8B 4D F4 83 E9 01 89 4D C0 8B 55 C0 89 55 10 EB 0F 8B 45 EC 03 45 14 89 45 F0 8B 4D F4 89 4D 10 EB 51 83 7D 10 00 74 49 8B 55 F0 52 8B 45 08 50 8B 4D 1C 51 8B 55 18 89 55 BC 8B 4D BC FF 15 ?? ?? ?? ?? FF 55 BC 83 C4 0C 85 C0 74 09 C7 45 B8 00 00 00 00 EB 06 8B 45 F0 89 45 B8 8B 4D B8 89 4D B0 8D 4D FB E8 ?? ?? ?? ?? 8B 45 B0 EB 1B EB 02 EB 05 E9 E7 FE FF FF C7 45 AC 00 00 00 00 8D 4D FB E8 ?? ?? ?? ?? 8B 45 AC 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_94_4_0 {
	meta:
		name = "__mbsupr"
		size = 37
		refs = "0013 __mbsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 F7 D8 6A 00 1B C0 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_497_4_0 {
	meta:
		name = "__mbslwr"
		size = 37
		refs = "0013 __mbslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 F7 D8 6A 00 1B C0 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_94_5_0 {
	meta:
		name = "__mbsupr_l"
		size = 38
		refs = "0014 __mbsupr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 75 0C F7 D8 1B C0 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_497_5_0 {
	meta:
		name = "__mbslwr_l"
		size = 38
		refs = "0014 __mbslwr_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 FF 75 0C F7 D8 1B C0 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 45 08 5D C3 }
	condition:
		$1
}

rule file_94_7_0 {
	meta:
		name = "__mbsupr_s_l"
		size = 547
		refs = "0029 ??_C@_1KE@KOBLPBMH@?$AA?$CI?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAs?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt?$AAe@ 002e ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0035 ??_C@_1GO@OAPABPI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0040 __CrtDbgReportW 004e __errno 005a ??_C@_1BI@PBGKGPOP@?$AA_?$AAm?$AAb?$AAs?$AAu?$AAp?$AAr?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 0066 __invalid_parameter 0077 _strnlen 009a __CrtGetDebugFillThreshold 00b0 _memset 00b8 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 0134 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0179 ___acrt_LCMapStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 53 56 8B 75 0C 57 8B 7D 08 85 FF 74 0F 85 F6 74 0F 85 FF 75 57 33 C0 E9 B1 01 00 00 85 F6 74 F1 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 33 DB BE ?? ?? ?? ?? 53 6A 31 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 16 5F 53 6A 31 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 E9 61 01 00 00 56 57 E8 ?? ?? ?? ?? 8B D8 59 59 3B DE 72 72 33 DB 88 1F 83 FE FF 74 2B 81 FE FF FF FF 7F 74 23 83 FE 01 76 1E E8 ?? ?? ?? ?? 4E 3B C6 72 02 8B C6 50 8D 47 01 68 FE 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 6A 3D BE ?? ?? ?? ?? 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 16 5F 53 6A 3D 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 6E FF FF FF 83 FE FF 74 33 81 FE FF FF FF 7F 74 2B 8D 43 01 3B C6 73 24 E8 ?? ?? ?? ?? 8B CE 2B CB 49 3B C1 72 02 8B C1 50 8D 47 01 03 C3 68 FE 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 10 8D 4D E4 E8 ?? ?? ?? ?? 80 3F 00 8B C7 8B DF 89 45 FC 74 7B 8B 4D EC 8A 13 0F B6 F2 89 75 F4 8A 74 0E 19 8B 75 0C F6 C6 04 74 49 6A 01 FF 71 04 8D 45 F8 6A 02 50 6A 02 53 68 00 02 00 00 FF B1 1C 02 00 00 8D 45 E8 50 E8 ?? ?? ?? ?? 8B D0 83 C4 24 85 D2 74 56 8B 45 FC 8B 4D F8 88 08 40 43 89 45 FC 83 FA 01 7E 07 88 28 8B 4D EC EB 16 8B 4D EC EB 15 F6 C6 20 74 0A 8B 55 F4 8A 94 0A 19 01 00 00 88 10 40 89 45 FC 43 80 3B 00 75 88 33 DB 88 18 80 7D F0 00 74 0A 8B 4D E4 83 A1 50 03 00 00 FD 8B C3 5F 5E 5B 8B E5 5D C3 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C6 07 00 83 FE FF 74 2B 81 FE FF FF FF 7F 74 23 83 FE 01 76 1E E8 ?? ?? ?? ?? 4E 3B C6 72 02 8B C6 50 8D 47 01 68 FE 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 8B 18 EB A0 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "_fesetenv"
		size = 97
		refs = "001d __setfpcontrolword 002c __setfpstatusword 0038 _fegetenv"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 C7 45 F8 00 00 00 00 C7 45 FC 00 00 00 00 8B 45 08 8B 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 8B 42 04 50 E8 ?? ?? ?? ?? 83 C4 04 8D 4D F8 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 8B 02 3B 45 F8 75 0B 8B 4D 08 8B 51 04 3B 55 FC 74 07 B8 01 00 00 00 EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_98_0_0 {
	meta:
		name = "_scalblnf"
		size = 96
		refs = "0011 __fdtest 0028 __fdscale 0046 __fperrraise"
		altNames = "_scalbnf"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 0C 00 74 4D 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 85 C9 7D 3A 8B 55 0C 52 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 89 4D FC 83 7D FC 00 74 08 83 7D FC 01 74 0E EB 16 6A 10 E8 ?? ?? ?? ?? 83 C4 04 EB 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 D9 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_99_0_0 {
	meta:
		name = "__iswctype_l"
		size = 25
		refs = "0010 _iswctype"
	strings:
		$1 = { 8B FF 55 8B EC 0F B7 45 0C 50 0F B7 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_99_1_0 {
	meta:
		name = "_iswctype"
		size = 110
		refs = "0028 __pwctype 0054 __imp__GetStringTypeW@16"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 0F B7 45 08 3D FF FF 00 00 75 04 33 C0 EB 53 0F B7 4D 08 81 F9 00 01 00 00 7D 15 0F B7 55 08 A1 ?? ?? ?? ?? 0F B7 04 50 0F B7 4D 0C 23 C1 EB 32 66 8B 55 08 66 89 55 F8 33 C0 66 89 45 FC 8D 4D FC 51 6A 01 8D 55 F8 52 6A 01 FF 15 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 0A 0F B7 45 FC 0F B7 4D 0C 23 C1 8B E5 5D C3 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "_wcsncpy"
		size = 131
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 45 10 89 45 FC 8B 4D 08 89 4D F8 8B 55 0C 89 55 F4 83 7D FC 00 74 38 8B 45 F8 8B 4D F4 66 8B 11 66 89 10 8B 45 F8 0F B7 08 89 4D F0 8B 55 F8 83 C2 02 89 55 F8 8B 45 F4 83 C0 02 89 45 F4 83 7D F0 00 74 0B 8B 4D FC 83 E9 01 89 4D FC EB C2 83 7D FC 00 74 1E 8B 55 FC 83 EA 01 89 55 FC 74 13 33 C0 8B 4D F8 66 89 01 8B 55 F8 83 C2 02 89 55 F8 EB E2 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "__malloc_base"
		size = 134
		refs = "000f __errno 003f ___acrt_heap 0046 __imp__HeapAlloc@12 0059 __query_new_mode 0066 __callnewh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 83 7D 08 E0 76 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 65 83 7D 08 00 75 09 C7 45 FC 01 00 00 00 EB 06 8B 45 08 89 45 FC 8B 4D FC 89 4D F4 8B 55 F4 52 6A 00 A1 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 74 05 8B 45 F8 EB 2A E8 ?? ?? ?? ?? 85 C0 74 10 8B 4D F4 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 02 EB B6 8B E5 5D C3 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "_catan"
		size = 289
		refs = "0025 _creal 004c _cimag 0060 __Cbuild 0084 _catanh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 8B CC 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 10 89 55 0C 8B 48 04 89 4D 10 8B 50 08 89 55 14 8B 40 0C 89 45 18 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_450_0_3 {
	meta:
		name = "_casin"
		size = 289
		refs = "0025 _creal 004c _cimag 0060 __Cbuild 0084 _casinh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 8B CC 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 10 89 55 0C 8B 48 04 89 4D 10 8B 50 08 89 55 14 8B 40 0C 89 45 18 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "_casinl"
		size = 289
		refs = "0025 _creall 004c _cimagl 0060 __LCbuild 0084 _casinhl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 8B CC 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 10 89 55 0C 8B 48 04 89 4D 10 8B 50 08 89 55 14 8B 40 0C 89 45 18 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_273_0_3 {
	meta:
		name = "_catanl"
		size = 289
		refs = "0025 _creall 004c _cimagl 0060 __LCbuild 0084 _catanhl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 8B CC 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 10 89 55 0C 8B 48 04 89 4D 10 8B 50 08 89 55 14 8B 40 0C 89 45 18 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_168_0_2 {
	meta:
		name = "_csin"
		size = 289
		refs = "0025 _creal 004c _cimag 0060 __Cbuild 0084 _csinh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 8B CC 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 10 89 55 0C 8B 48 04 89 4D 10 8B 50 08 89 55 14 8B 40 0C 89 45 18 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_141_0_4 {
	meta:
		name = "_csinl"
		size = 289
		refs = "0025 _creall 004c _cimagl 0060 __LCbuild 0084 _csinhl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 8B CC 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 10 89 55 0C 8B 48 04 89 4D 10 8B 50 08 89 55 14 8B 40 0C 89 45 18 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_668_0_3 {
	meta:
		name = "_ctan"
		size = 289
		refs = "0025 _creal 004c _cimag 0060 __Cbuild 0084 _ctanh"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 8B CC 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 10 89 55 0C 8B 48 04 89 4D 10 8B 50 08 89 55 14 8B 40 0C 89 45 18 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_688_0_3 {
	meta:
		name = "_ctanl"
		size = 289
		refs = "0025 _creall 004c _cimagl 0060 __LCbuild 0084 _ctanhl"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 83 EC 10 8B C4 8B 4D 0C 89 08 8B 55 10 89 50 04 8B 4D 14 89 48 08 8B 55 18 89 50 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 04 8B CC 8B 10 89 11 8B 50 04 89 51 04 8B 50 08 89 51 08 8B 40 0C 89 41 0C 8D 4D E0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 10 89 55 0C 8B 48 04 89 4D 10 8B 50 08 89 55 14 8B 40 0C 89 45 18 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 10 D9 E0 83 EC 08 DD 1C 24 83 EC 10 8B CC 8B 55 0C 89 11 8B 45 10 89 41 04 8B 55 14 89 51 08 8B 45 18 89 41 0C E8 ?? ?? ?? ?? 83 C4 08 DD 1C 24 8D 4D D0 51 E8 ?? ?? ?? ?? 83 C4 14 8B 55 08 8B 08 89 0A 8B 48 04 89 4A 04 8B 48 08 89 4A 08 8B 40 0C 89 42 0C 8B 45 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_103_5_0 {
	meta:
		name = "__mbsstr_l"
		size = 349
		refs = "0012 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0027 _strstr 0043 ??_C@_1CA@GKDOGDFI@?$AAs?$AAt?$AAr?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0048 ??_C@_1GO@EEDCOHAH@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 004e ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0059 __CrtDbgReportW 0067 __errno 008c ??_C@_1CA@JIGJIOKA@?$AAs?$AAt?$AAr?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 00b9 ??_C@_1BE@KLCPDEDD@?$AA_?$AAm?$AAb?$AAs?$AAs?$AAt?$AAr?$AA_?$AAl?$AA?$AA@ 00c5 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 56 57 FF 75 10 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 F0 33 F6 39 70 08 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 8B F0 E9 10 01 00 00 8B 5D 0C 33 C0 85 DB 0F 95 C0 85 C0 75 2E BB ?? ?? ?? ?? BF ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 56 6A 34 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 6A 34 EB 47 80 3B 00 75 08 8B 75 08 E9 C7 00 00 00 8B 4D 08 33 C0 85 C9 0F 95 C0 85 C0 75 43 BB ?? ?? ?? ?? BF ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 56 6A 37 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 6A 37 57 68 ?? ?? ?? ?? 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 76 8B F9 8D 57 01 8A 07 47 84 C0 75 F9 2B FA 8B D3 8D 42 01 89 45 F8 8A 02 42 84 C0 75 F9 2B 55 F8 2B FA 03 F9 38 01 74 4E 8B D1 2B D3 3B CF 77 46 8B C3 8A 19 88 5D FE 84 DB 74 12 8A 18 84 DB 74 33 38 1C 02 75 07 40 80 3C 02 00 75 EE 80 38 00 74 22 8B 5D F0 41 0F B6 45 FE 42 8A 44 18 19 8B 5D 0C 24 04 74 07 80 39 00 74 0B 41 42 80 39 00 75 BA EB 02 8B F1 80 7D F4 00 74 0A 8B 4D E8 83 A1 50 03 00 00 FD 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_104_4_0 {
	meta:
		name = "___acrt_add_locale_ref"
		size = 252
		refs = "008e ___acrt_wide_c_locale_string 00f1 ___acrt_locale_add_lc_time_reference"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 83 C0 0C F0 FF 00 8B 4D 08 83 79 7C 00 74 09 8B 55 08 8B 42 7C F0 FF 00 8B 4D 08 83 B9 84 00 00 00 00 74 0C 8B 55 08 8B 82 84 00 00 00 F0 FF 00 8B 4D 08 83 B9 80 00 00 00 00 74 0C 8B 55 08 8B 82 80 00 00 00 F0 FF 00 8B 4D 08 83 B9 8C 00 00 00 00 74 0C 8B 55 08 8B 82 8C 00 00 00 F0 FF 00 C7 45 FC 00 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 83 7D FC 05 7F 65 8B 55 FC C1 E2 04 8B 45 08 81 7C 10 20 ?? ?? ?? ?? 74 20 8B 4D FC C1 E1 04 8B 55 08 83 7C 0A 28 00 74 10 8B 45 FC C1 E0 04 8B 4D 08 8B 54 01 28 F0 FF 02 8B 45 FC C1 E0 04 8B 4D 08 83 7C 01 1C 00 74 20 8B 55 FC C1 E2 04 8B 45 08 83 7C 10 24 00 74 10 8B 4D FC C1 E1 04 8B 55 08 8B 44 0A 24 F0 FF 00 EB 8C 8B 4D 08 8B 91 9C 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_104_5_0 {
	meta:
		name = "___acrt_free_locale"
		size = 703
		refs = "001f ___acrt_lconv_c 006c __free_dbg 007e ___acrt_locale_free_monetary 00be ___acrt_locale_free_numeric 0170 ___acrt_locale_free_lc_time_if_unreferenced 01a0 ___acrt_wide_c_locale_string 0239 ??_C@_1BKC@NBNHJIDM@?$AA?$CI?$AAp?$AAt?$AAl?$AAo?$AAc?$AAi?$AA?9?$AA?$DO?$AAl?$AAc?$AA_?$AAc?$AAa?$AAt?$AAe?$AAg?$AAo?$AAr?$AAy?$AA?$FL?$AAc?$AAa?$AAt?$AAe?$AAg?$AAo?$AAr?$AAy?$AA?$FN?$AA?4?$AAl@ 023e ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 024a ??_C@_1HK@HCNMEOLA@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAl@ 0251 __CrtDbgReportW"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 08 83 B8 88 00 00 00 00 0F 84 D4 00 00 00 8B 4D 08 81 B9 88 00 00 00 ?? ?? ?? ?? 0F 84 C1 00 00 00 8B 55 08 83 7A 7C 00 0F 84 B4 00 00 00 8B 45 08 8B 48 7C 83 39 00 0F 85 A5 00 00 00 8B 55 08 83 BA 84 00 00 00 00 74 34 8B 45 08 8B 88 84 00 00 00 83 39 00 75 26 6A 02 8B 55 08 8B 82 84 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 8B 91 88 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 08 83 B8 80 00 00 00 00 74 34 8B 4D 08 8B 91 80 00 00 00 83 3A 00 75 26 6A 02 8B 45 08 8B 88 80 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 8B 82 88 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 04 6A 02 8B 4D 08 8B 51 7C 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 88 88 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 83 BA 8C 00 00 00 00 74 6F 8B 45 08 8B 88 8C 00 00 00 83 39 00 75 61 6A 02 8B 55 08 8B 82 90 00 00 00 2D FE 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 4D 08 8B 91 94 00 00 00 81 EA 80 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 45 08 8B 88 98 00 00 00 81 E9 80 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 08 8B 82 8C 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 8B 91 9C 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 EB 09 8B 45 FC 83 C0 01 89 45 FC 83 7D FC 05 0F 8F 1A 01 00 00 8B 4D FC C1 E1 04 8B 55 08 81 7C 0A 20 ?? ?? ?? ?? 74 52 8B 45 FC C1 E0 04 8B 4D 08 83 7C 01 28 00 74 42 8B 55 FC C1 E2 04 8B 45 08 8B 4C 10 28 83 39 00 75 30 6A 02 8B 55 FC C1 E2 04 8B 45 08 8B 4C 10 28 51 E8 ?? ?? ?? ?? 83 C4 08 6A 02 8B 55 FC 8B 45 08 8B 8C 90 A0 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 FC C1 E2 04 8B 45 08 83 7C 10 1C 00 74 10 8B 4D FC C1 E1 04 8B 55 08 83 7C 0A 24 00 75 46 8B 45 FC C1 E0 04 8B 4D 08 83 7C 01 1C 00 75 10 8B 55 FC C1 E2 04 8B 45 08 83 7C 10 24 00 74 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AF 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B 55 FC C1 E2 04 8B 45 08 83 7C 10 1C 00 74 3A 8B 4D FC C1 E1 04 8B 55 08 83 7C 0A 24 00 74 2A 8B 45 FC C1 E0 04 8B 4D 08 8B 54 01 24 83 3A 00 75 18 6A 02 8B 45 FC C1 E0 04 8B 4D 08 8B 54 01 24 52 E8 ?? ?? ?? ?? 83 C4 08 E9 D3 FE FF FF 6A 02 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_104_6_0 {
	meta:
		name = "___acrt_locale_add_lc_time_reference"
		size = 49
		refs = "000e ___lc_time_c"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 09 81 7D 08 ?? ?? ?? ?? 75 07 B8 FF FF FF 7F EB 14 8B 45 08 05 B0 00 00 00 B9 01 00 00 00 F0 0F C1 08 41 8B C1 5D C3 }
	condition:
		$1
}

rule file_104_7_0 {
	meta:
		name = "___acrt_locale_free_lc_time_if_unreferenced"
		size = 73
		refs = "000e ___lc_time_c 0020 ??$__crt_interlocked_read@J@@YAJPDJ@Z 0032 ___acrt_locale_free_time 0040 __free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 09 81 7D 08 ?? ?? ?? ?? 75 02 EB 31 8B 45 08 05 B0 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 02 EB 1A 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 6A 02 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_104_8_0 {
	meta:
		name = "___acrt_locale_release_lc_time_reference"
		size = 47
		refs = "000e ___lc_time_c"
	strings:
		$1 = { 8B FF 55 8B EC 83 7D 08 00 74 09 81 7D 08 ?? ?? ?? ?? 75 07 B8 FF FF FF 7F EB 12 8B 45 08 05 B0 00 00 00 83 C9 FF F0 0F C1 08 49 8B C1 5D C3 }
	condition:
		$1
}

rule file_104_9_0 {
	meta:
		name = "___acrt_release_locale_ref"
		size = 263
		refs = "0099 ___acrt_wide_c_locale_string 00fc ___acrt_locale_release_lc_time_reference"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 08 00 75 05 E9 F2 00 00 00 8B 45 08 83 C0 0C F0 FF 08 8B 4D 08 83 79 7C 00 74 09 8B 55 08 8B 42 7C F0 FF 08 8B 4D 08 83 B9 84 00 00 00 00 74 0C 8B 55 08 8B 82 84 00 00 00 F0 FF 08 8B 4D 08 83 B9 80 00 00 00 00 74 0C 8B 55 08 8B 82 80 00 00 00 F0 FF 08 8B 4D 08 83 B9 8C 00 00 00 00 74 0C 8B 55 08 8B 82 8C 00 00 00 F0 FF 08 C7 45 FC 00 00 00 00 EB 09 8B 4D FC 83 C1 01 89 4D FC 83 7D FC 05 7F 65 8B 55 FC C1 E2 04 8B 45 08 81 7C 10 20 ?? ?? ?? ?? 74 20 8B 4D FC C1 E1 04 8B 55 08 83 7C 0A 28 00 74 10 8B 45 FC C1 E0 04 8B 4D 08 8B 54 01 28 F0 FF 0A 8B 45 FC C1 E0 04 8B 4D 08 83 7C 01 1C 00 74 20 8B 55 FC C1 E2 04 8B 45 08 83 7C 10 24 00 74 10 8B 4D FC C1 E1 04 8B 55 08 8B 44 0A 24 F0 FF 08 EB 8C 8B 4D 08 8B 91 9C 00 00 00 52 E8 ?? ?? ?? ?? 83 C4 04 8B E5 5D C3 }
	condition:
		$1
}

rule file_104_10_0 {
	meta:
		name = "___acrt_update_thread_locale_data"
		size = 207
		refs = "0008 __sehtable$___acrt_update_thread_locale_data 000d __except_handler4 001f ___security_cookie 003a ___acrt_getptd 004c ___globallocalestatus 005e ___acrt_lock 006d ___acrt_current_locale_data 0072 ?value@?$dual_state_global@PAU__crt_locale_data@@@__crt_state_management@@QAEAAPAU__crt_locale_data@@XZ 0081 __updatetlocinfoEx_nolock 009c ___acrt_unlock 00b6 _abort"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 F0 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 E0 00 00 00 00 E8 ?? ?? ?? ?? 89 45 E4 8B 45 E4 8B 88 50 03 00 00 23 0D ?? ?? ?? ?? 74 09 8B 55 E4 83 7A 4C 00 75 4B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 00 50 8B 4D E4 83 C1 4C 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 E0 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 04 E8 ?? ?? ?? ?? 83 C4 04 C3 EB 09 8B 55 E4 8B 42 4C 89 45 E0 83 7D E0 00 75 05 E8 ?? ?? ?? ?? 8B 45 E0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_104_11_0 {
	meta:
		name = "__updatetlocinfoEx_nolock"
		size = 124
		refs = "0038 ___acrt_add_locale_ref 004a ___acrt_release_locale_ref 0063 ___acrt_initial_locale_data 006e ___acrt_free_locale"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 7D 0C 00 74 06 83 7D 08 00 75 04 33 C0 EB 62 8B 45 08 8B 08 89 4D FC 8B 55 FC 3B 55 0C 75 05 8B 45 0C EB 4D 8B 45 08 8B 4D 0C 89 08 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 83 7D FC 00 74 0C 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 83 7D FC 00 74 1E 8B 4D FC 83 79 0C 00 75 15 81 7D FC ?? ?? ?? ?? 74 0C 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_105_4_0 {
	meta:
		name = "__mblen_l"
		size = 434
		refs = "002d ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0035 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0052 ??_C@_1BBK@OJOCBOE@?$AAl?$AAo?$AAc?$AAa?$AAl?$AAe?$AA_?$AAu?$AAp?$AAd?$AAa?$AAt?$AAe?$AA?4?$AAG?$AAe?$AAt?$AAL?$AAo?$AAc?$AAa?$AAl?$AAe?$AAT?$AA?$CI?$AA?$CJ?$AA?9?$AA?$DO?$AAl?$AAo?$AAc?$AAi@ 0057 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0060 ??_C@_1GC@IIAPMALA@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0067 __CrtDbgReportW 0085 __isleadbyte_l 00af ??1_LocaleUpdate@@QAE@XZ 0115 __imp__MultiByteToWideChar@24"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 83 7D 08 00 74 10 8B 45 08 0F BE 08 85 C9 74 06 83 7D 0C 00 75 07 33 C0 E9 89 01 00 00 8B 55 10 52 8D 4D D0 E8 ?? ?? ?? ?? 8D 4D D0 E8 ?? ?? ?? ?? 8B 00 83 78 04 01 74 33 8D 4D D0 E8 ?? ?? ?? ?? 8B 08 83 79 04 02 74 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 1F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8D 4D D0 E8 ?? ?? ?? ?? 50 8B 45 08 0F B6 08 51 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 C1 00 00 00 8D 4D D0 E8 ?? ?? ?? ?? 8B 10 83 7A 04 01 7F 17 C7 45 FC FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 FC E9 F3 00 00 00 81 7D 0C FF FF FF 7F 77 12 8D 4D D0 E8 ?? ?? ?? ?? 8B 00 8B 4D 0C 3B 48 04 7D 17 C7 45 F8 FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 F8 E9 C1 00 00 00 6A 00 6A 00 8D 4D D0 E8 ?? ?? ?? ?? 8B 10 8B 42 04 50 8B 4D 08 51 6A 09 8D 4D D0 E8 ?? ?? ?? ?? 8B 10 8B 42 08 50 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 75 14 C7 45 F0 FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 F0 EB 78 8D 4D D0 E8 ?? ?? ?? ?? 8B 08 8B 51 04 89 55 EC 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 EC EB 5B EB 51 6A 00 6A 00 6A 01 8B 45 08 50 6A 09 8D 4D D0 E8 ?? ?? ?? ?? 8B 08 8B 51 08 52 FF 15 ?? ?? ?? ?? 89 45 E8 83 7D E8 00 75 14 C7 45 E4 FF FF FF FF 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 E4 EB 1C C7 45 E0 01 00 00 00 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 E0 EB 08 8D 4D D0 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_105_5_0 {
	meta:
		name = "_mblen"
		size = 62
		refs = "0006 ___acrt_locale_changed 0012 ___acrt_initial_locale_pointers 001f __mblen_l"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 19 68 ?? ?? ?? ?? 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C EB 14 EB 12 6A 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "_strlen"
		size = 139
	strings:
		$1 = { 8B 4C 24 04 F7 C1 03 00 00 00 74 24 8A 01 83 C1 01 84 C0 74 4E F7 C1 03 00 00 00 75 EF 05 00 00 00 00 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 8B 01 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C1 04 A9 00 01 01 81 74 E8 8B 41 FC 84 C0 74 32 84 E4 74 24 A9 00 00 FF 00 74 13 A9 00 00 00 FF 74 02 EB CD 8D 41 FF 8B 4C 24 04 2B C1 C3 8D 41 FE 8B 4C 24 04 2B C1 C3 8D 41 FD 8B 4C 24 04 2B C1 C3 8D 41 FC 8B 4C 24 04 2B C1 C3 }
	condition:
		$1
}

rule file_107_1_0 {
	meta:
		name = "__mbctokata_l"
		size = 44
		refs = "000e __ismbchira_l"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 0C 8B 75 08 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 0F 81 C6 A1 00 00 00 81 FE 7F 83 00 00 72 01 46 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_108_1_0 {
	meta:
		name = "??$common_flush_and_write_nolock@D@@YAHHV__crt_stdio_stream@@@Z"
		size = 480
		refs = "0014 ?valid@__crt_stdio_stream@@QBE_NXZ 0020 ??_C@_1BO@MHPFFFJJ@?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?4?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?$CI?$AA?$CJ?$AA?$AA@ 0025 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002e ??_C@_1GC@DFIGBGJI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0035 __CrtDbgReportW 0046 ?public_stream@__crt_stdio_stream@@QBEPAU_iobuf@@XZ 004c __fileno 005c ?has_any_of@__crt_stdio_stream@@QBE_NJ@Z 0068 __errno 0078 ?set_flags@__crt_stdio_stream@@QBE_NJ@Z 008a ?is_string_backed@__crt_stdio_stream@@QBE_NXZ 00c7 ??C__crt_stdio_stream@@QBEPAU__crt_stdio_stream_data@@XZ 0100 ?unset_flags@__crt_stdio_stream@@QBE_NJ@Z 013f ?has_any_buffer@__crt_stdio_stream@@QBE_NXZ 0157 ___acrt_iob_func 017f __isatty 0194 ___acrt_stdio_allocate_buffer_nolock 01b6 ??$write_buffer_nolock@D@@YA_NDV__crt_stdio_stream@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 C7 45 F4 FF 00 00 00 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8D 4D 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 6A 06 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 1F E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 10 8D 4D 0C E8 ?? ?? ?? ?? 83 C8 FF E9 57 01 00 00 EB 2C 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 1D E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 10 8D 4D 0C E8 ?? ?? ?? ?? 83 C8 FF E9 29 01 00 00 6A 01 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 55 8D 4D 0C E8 ?? ?? ?? ?? C7 40 08 00 00 00 00 6A 08 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 23 8D 4D 0C E8 ?? ?? ?? ?? 8B F0 8D 4D 0C E8 ?? ?? ?? ?? 8B 4E 04 89 08 6A 01 8D 4D 0C E8 ?? ?? ?? ?? EB 12 6A 10 8D 4D 0C E8 ?? ?? ?? ?? 83 C8 FF E9 C3 00 00 00 6A 02 8D 4D 0C E8 ?? ?? ?? ?? 6A 08 8D 4D 0C E8 ?? ?? ?? ?? 8D 4D 0C E8 ?? ?? ?? ?? C7 40 08 00 00 00 00 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 51 8D 4D 0C E8 ?? ?? ?? ?? 8B F0 6A 01 E8 ?? ?? ?? ?? 83 C4 04 3B F0 74 18 8D 4D 0C E8 ?? ?? ?? ?? 8B F0 6A 02 E8 ?? ?? ?? ?? 83 C4 04 3B F0 75 10 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 11 8D 4D 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 F8 00 00 00 00 8B 4D F8 89 4D F0 8B 55 0C 52 8B 45 08 25 FF 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 75 0F 6A 10 8D 4D 0C E8 ?? ?? ?? ?? 83 C8 FF EB 08 8B 45 08 25 FF 00 00 00 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_2_0 {
	meta:
		name = "??$common_flush_and_write_nolock@_W@@YAHHV__crt_stdio_stream@@@Z"
		size = 488
		refs = "0014 ?valid@__crt_stdio_stream@@QBE_NXZ 0020 ??_C@_1BO@MHPFFFJJ@?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?4?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?$CI?$AA?$CJ?$AA?$AA@ 0025 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002e ??_C@_1GC@DFIGBGJI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0035 __CrtDbgReportW 0046 ?public_stream@__crt_stdio_stream@@QBEPAU_iobuf@@XZ 004c __fileno 005c ?has_any_of@__crt_stdio_stream@@QBE_NJ@Z 0068 __errno 0078 ?set_flags@__crt_stdio_stream@@QBE_NJ@Z 008c ?is_string_backed@__crt_stdio_stream@@QBE_NXZ 00cb ??C__crt_stdio_stream@@QBEPAU__crt_stdio_stream_data@@XZ 0104 ?unset_flags@__crt_stdio_stream@@QBE_NJ@Z 0145 ?has_any_buffer@__crt_stdio_stream@@QBE_NXZ 015d ___acrt_iob_func 0185 __isatty 019a ___acrt_stdio_allocate_buffer_nolock 01bc ??$write_buffer_nolock@_W@@YA_N_WV__crt_stdio_stream@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 C7 45 F4 FF FF 00 00 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 4E 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8D 4D 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 6A 06 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 21 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 10 8D 4D 0C E8 ?? ?? ?? ?? B8 FF FF 00 00 E9 5D 01 00 00 EB 2E 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 74 1F E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 10 8D 4D 0C E8 ?? ?? ?? ?? B8 FF FF 00 00 E9 2D 01 00 00 6A 01 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 57 8D 4D 0C E8 ?? ?? ?? ?? C7 40 08 00 00 00 00 6A 08 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 74 23 8D 4D 0C E8 ?? ?? ?? ?? 8B F0 8D 4D 0C E8 ?? ?? ?? ?? 8B 4E 04 89 08 6A 01 8D 4D 0C E8 ?? ?? ?? ?? EB 14 6A 10 8D 4D 0C E8 ?? ?? ?? ?? B8 FF FF 00 00 E9 C5 00 00 00 6A 02 8D 4D 0C E8 ?? ?? ?? ?? 6A 08 8D 4D 0C E8 ?? ?? ?? ?? 8D 4D 0C E8 ?? ?? ?? ?? C7 40 08 00 00 00 00 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 51 8D 4D 0C E8 ?? ?? ?? ?? 8B F0 6A 01 E8 ?? ?? ?? ?? 83 C4 04 3B F0 74 18 8D 4D 0C E8 ?? ?? ?? ?? 8B F0 6A 02 E8 ?? ?? ?? ?? 83 C4 04 3B F0 75 10 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 11 8D 4D 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 F8 00 00 00 00 8B 4D F8 89 4D F0 8B 55 0C 52 8B 45 08 25 FF FF 00 00 50 E8 ?? ?? ?? ?? 83 C4 08 0F B6 C8 85 C9 75 11 6A 10 8D 4D 0C E8 ?? ?? ?? ?? B8 FF FF 00 00 EB 08 8B 45 08 25 FF FF 00 00 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_3_0 {
	meta:
		name = "??$write_buffer_nolock@D@@YA_NDV__crt_stdio_stream@@@Z"
		size = 430
		refs = "000d ?public_stream@__crt_stdio_stream@@QBEPAU_iobuf@@XZ 0013 __fileno 0021 ?has_big_buffer@__crt_stdio_stream@@QBE_NXZ 0034 ??C__crt_stdio_stream@@QBEPAU__crt_stdio_stream_data@@XZ 004a ??_C@_1HO@MLMGPAFH@?$AA?$CI?$AA?$CC?$AAi?$AAn?$AAc?$AAo?$AAn?$AAs?$AAi?$AAs?$AAt?$AAe?$AAn?$AAt?$AA?5?$AAI?$AAO?$AAB?$AA?5?$AAf?$AAi?$AAe?$AAl?$AAd?$AAs?$AA?$CC?$AA?0?$AA?5?$AAs?$AAt?$AAr?$AAe@ 004f ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0058 ??_C@_1GC@DFIGBGJI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 005f __CrtDbgReportW 00d9 __write 0103 ___pioinfo 010f ___badioinfo 012a __lseeki64 0148 ?set_flags@__crt_stdio_stream@@QBE_NJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 8D 4D 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 0F 84 4F 01 00 00 8D 4D 0C E8 ?? ?? ?? ?? 8B F0 8D 4D 0C E8 ?? ?? ?? ?? 8B 0E 2B 48 04 79 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 1A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8D 4D 0C E8 ?? ?? ?? ?? 8B F0 8D 4D 0C E8 ?? ?? ?? ?? 8B 0E 2B 48 04 89 4D F8 8D 4D 0C E8 ?? ?? ?? ?? 8B 70 04 83 C6 01 8D 4D 0C E8 ?? ?? ?? ?? 89 30 8D 4D 0C E8 ?? ?? ?? ?? 8B 70 18 83 EE 01 8D 4D 0C E8 ?? ?? ?? ?? 89 70 08 C7 45 F0 00 00 00 00 83 7D F8 00 7E 21 8B 55 F8 52 8D 4D 0C E8 ?? ?? ?? ?? 8B 40 04 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F0 EB 6B 83 7D FC FF 74 21 83 7D FC FE 74 1B 8B 55 FC C1 FA 06 8B 45 FC 83 E0 3F 6B C8 30 03 0C 95 ?? ?? ?? ?? 89 4D F4 EB 07 C7 45 F4 ?? ?? ?? ?? 8B 55 F4 0F B6 42 28 83 E0 20 74 31 6A 02 6A 00 6A 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 89 55 E4 8B 55 E0 23 55 E4 83 FA FF 75 0E 6A 10 8D 4D 0C E8 ?? ?? ?? ?? B0 01 EB 59 8D 4D 0C E8 ?? ?? ?? ?? 8B 40 04 8A 4D 08 88 08 8B 55 F0 3B 55 F8 75 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8A 45 EC EB 2C EB 2A 6A 01 8D 45 08 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 01 75 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8A 45 E8 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_4_0 {
	meta:
		name = "??$write_buffer_nolock@_W@@YA_N_WV__crt_stdio_stream@@@Z"
		size = 432
		refs = "000d ?public_stream@__crt_stdio_stream@@QBEPAU_iobuf@@XZ 0013 __fileno 0021 ?has_big_buffer@__crt_stdio_stream@@QBE_NXZ 0034 ??C__crt_stdio_stream@@QBEPAU__crt_stdio_stream_data@@XZ 004a ??_C@_1HO@MLMGPAFH@?$AA?$CI?$AA?$CC?$AAi?$AAn?$AAc?$AAo?$AAn?$AAs?$AAi?$AAs?$AAt?$AAe?$AAn?$AAt?$AA?5?$AAI?$AAO?$AAB?$AA?5?$AAf?$AAi?$AAe?$AAl?$AAd?$AAs?$AA?$CC?$AA?0?$AA?5?$AAs?$AAt?$AAr?$AAe@ 004f ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0058 ??_C@_1GC@DFIGBGJI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 005f __CrtDbgReportW 00d9 __write 0103 ___pioinfo 010f ___badioinfo 012a __lseeki64 0148 ?set_flags@__crt_stdio_stream@@QBE_NJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 56 8D 4D 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 FC 8D 4D 0C E8 ?? ?? ?? ?? 0F B6 C0 85 C0 0F 84 51 01 00 00 8D 4D 0C E8 ?? ?? ?? ?? 8B F0 8D 4D 0C E8 ?? ?? ?? ?? 8B 0E 2B 48 04 79 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 1A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8D 4D 0C E8 ?? ?? ?? ?? 8B F0 8D 4D 0C E8 ?? ?? ?? ?? 8B 0E 2B 48 04 89 4D F8 8D 4D 0C E8 ?? ?? ?? ?? 8B 70 04 83 C6 02 8D 4D 0C E8 ?? ?? ?? ?? 89 30 8D 4D 0C E8 ?? ?? ?? ?? 8B 70 18 83 EE 02 8D 4D 0C E8 ?? ?? ?? ?? 89 70 08 C7 45 F0 00 00 00 00 83 7D F8 00 7E 21 8B 55 F8 52 8D 4D 0C E8 ?? ?? ?? ?? 8B 40 04 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 89 45 F0 EB 6B 83 7D FC FF 74 21 83 7D FC FE 74 1B 8B 55 FC C1 FA 06 8B 45 FC 83 E0 3F 6B C8 30 03 0C 95 ?? ?? ?? ?? 89 4D F4 EB 07 C7 45 F4 ?? ?? ?? ?? 8B 55 F4 0F B6 42 28 83 E0 20 74 31 6A 02 6A 00 6A 00 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 89 55 E4 8B 55 E0 23 55 E4 83 FA FF 75 0E 6A 10 8D 4D 0C E8 ?? ?? ?? ?? B0 01 EB 5B 8D 4D 0C E8 ?? ?? ?? ?? 8B 40 04 66 8B 4D 08 66 89 08 8B 55 F0 3B 55 F8 75 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8A 45 EC EB 2C EB 2A 6A 02 8D 45 08 50 8B 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 02 75 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8A 45 E8 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_9_0 {
	meta:
		name = "?has_any_buffer@__crt_stdio_stream@@QBE_NXZ"
		size = 26
		refs = "0012 ?has_any_of@__crt_stdio_stream@@QBE_NJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 68 C0 04 00 00 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_10_0 {
	meta:
		name = "?has_any_of@__crt_stdio_stream@@QBE_NJ@Z"
		size = 49
		refs = "000f ?get_flags@__crt_stdio_stream@@QBEJXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 23 45 08 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_108_11_0 {
	meta:
		name = "?has_big_buffer@__crt_stdio_stream@@QBE_NXZ"
		size = 26
		refs = "0012 ?has_any_of@__crt_stdio_stream@@QBE_NJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 68 C0 00 00 00 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_12_0 {
	meta:
		name = "?is_string_backed@__crt_stdio_stream@@QBE_NXZ"
		size = 49
		refs = "000f ?get_flags@__crt_stdio_stream@@QBEJXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 89 4D F8 8B 4D F8 E8 ?? ?? ?? ?? 25 00 10 00 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8A 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_17_0 {
	meta:
		name = "___acrt_stdio_flush_and_write_narrow_nolock"
		size = 37
		refs = "000e ??0__crt_stdio_stream@@QAE@QAU_iobuf@@@Z 001a ??$common_flush_and_write_nolock@D@@YAHHV__crt_stdio_stream@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 50 8D 4D FC E8 ?? ?? ?? ?? 8B 08 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_108_18_0 {
	meta:
		name = "___acrt_stdio_flush_and_write_wide_nolock"
		size = 37
		refs = "000e ??0__crt_stdio_stream@@QAE@QAU_iobuf@@@Z 001a ??$common_flush_and_write_nolock@_W@@YAHHV__crt_stdio_stream@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 8B 45 0C 50 8D 4D FC E8 ?? ?? ?? ?? 8B 08 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 8B E5 5D C3 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "_lrint"
		size = 147
		refs = "000d __dtest 0036 _nearbyint 0052 __fperrraise 005e __real@c1e0000000000000 006b __real@41dfffffffc00000 007d __ftol2_sse"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 74 6D 83 7D FC 00 7E 06 83 7D FC 02 7E 57 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F4 DD 45 F4 DD 45 08 DA E9 DF E0 F6 C4 44 7B 0A 6A 20 E8 ?? ?? ?? ?? 83 C4 04 DD 45 F4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 1A DD 05 ?? ?? ?? ?? DC 5D F4 DF E0 F6 C4 01 75 0A DD 45 F4 E8 ?? ?? ?? ?? EB 0C 6A 01 E8 ?? ?? ?? ?? 83 C4 04 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_727_0_0 {
	meta:
		name = "_lrintl"
		size = 147
		refs = "000d __ldtest 0036 _nearbyintl 0052 __fperrraise 005e __real@c1e0000000000000 006b __real@41dfffffffc00000 007d __ftol2_sse"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D FC 83 7D FC 00 74 6D 83 7D FC 00 7E 06 83 7D FC 02 7E 57 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F4 DD 45 F4 DD 45 08 DA E9 DF E0 F6 C4 44 7B 0A 6A 20 E8 ?? ?? ?? ?? 83 C4 04 DD 45 F4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 1A DD 05 ?? ?? ?? ?? DC 5D F4 DF E0 F6 C4 01 75 0A DD 45 F4 E8 ?? ?? ?? ?? EB 0C 6A 01 E8 ?? ?? ?? ?? 83 C4 04 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_110_0_0 {
	meta:
		name = "__wrmdir"
		size = 43
		refs = "000b __imp__RemoveDirectoryW@4 0015 __imp__GetLastError@0 001b ___acrt_errno_map_os_error"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_495_0_0 {
	meta:
		name = "__wremove"
		size = 43
		refs = "000b __imp__DeleteFileW@4 0015 __imp__GetLastError@0 001b ___acrt_errno_map_os_error"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 14 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 02 33 C0 5D C3 }
	condition:
		$1
}

rule file_111_8_0 {
	meta:
		name = "___acrt_stdio_allocate_buffer_nolock"
		size = 272
		refs = "0010 ??_C@_1DC@OGOLMDEL@?$AAp?$AAu?$AAb?$AAl?$AAi?$AAc?$AA_?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0015 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 001e ??_C@_1GC@DLDMJFMI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0025 __CrtDbgReportW 003a ??0__crt_stdio_stream@@QAE@QAU_iobuf@@@Z 0040 __cflush 0050 ??_C@_0DB@LKJPMJPL@minkernel?2crts?2ucrt?2src?2appcrt?2s@ 005c __malloc_dbg 0068 ??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@QAD@Z 006f ?detach@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEPADXZ 0079 ??C__crt_stdio_stream@@QBEPAU__crt_stdio_stream_data@@XZ 0084 ??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@XZ 009c ?set_flags@__crt_stdio_stream@@QBE_NJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 56 83 7D 08 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 12 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B 4D 08 51 8D 4D FC E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 83 C2 01 89 15 ?? ?? ?? ?? 6A 1B 68 ?? ?? ?? ?? 6A 02 68 00 10 00 00 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B F0 8D 4D FC E8 ?? ?? ?? ?? 89 70 04 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D FC E8 ?? ?? ?? ?? 83 78 04 00 74 1B 6A 40 8D 4D FC E8 ?? ?? ?? ?? 8D 4D FC E8 ?? ?? ?? ?? C7 40 18 00 10 00 00 EB 34 68 00 04 00 00 8D 4D FC E8 ?? ?? ?? ?? 8D 4D FC E8 ?? ?? ?? ?? 8B F0 83 C6 14 8D 4D FC E8 ?? ?? ?? ?? 89 70 04 8D 4D FC E8 ?? ?? ?? ?? C7 40 18 02 00 00 00 8D 4D FC E8 ?? ?? ?? ?? 8B F0 8D 4D FC E8 ?? ?? ?? ?? 8B 4E 04 89 08 8D 4D FC E8 ?? ?? ?? ?? C7 40 08 00 00 00 00 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "??$common_tcsset_s@D@@YAHQADID@Z"
		size = 543
		refs = "0031 ??_C@_1GI@BBAEIKL@?$AA?$CI?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AAi?$AAn?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AAs?$AAi?$AAz@ 0036 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0042 ??_C@_1HI@PBJPCEBC@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0049 __CrtDbgReportW 005d __errno 0074 ??_C@_1CA@BBKNBNG@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAt?$AAc?$AAs?$AAs?$AAe?$AAt?$AA_?$AAs?$AA?$AA@ 007e __invalid_parameter 00e9 __CrtGetDebugFillThreshold 011d _memset 0125 ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 014e ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 F0 83 7D F0 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 1A 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 1A 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 8C 01 00 00 8B 55 08 89 55 F8 8B 45 0C 89 45 FC 8B 4D F8 0F BE 11 85 D2 74 1E 8B 45 FC 83 E8 01 89 45 FC 74 13 8B 4D F8 8A 55 10 88 11 8B 45 F8 83 C0 01 89 45 F8 EB D8 83 7D FC 00 0F 85 DC 00 00 00 8B 4D 08 C6 01 00 83 7D 0C FF 74 4B 81 7D 0C FF FF FF 7F 74 42 83 7D 0C 01 76 3C E8 ?? ?? ?? ?? 89 45 EC 8B 55 0C 83 EA 01 39 55 EC 73 08 8B 45 EC 89 45 E8 EB 09 8B 4D 0C 83 E9 01 89 4D E8 8B 55 E8 52 68 FE 00 00 00 8B 45 08 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C B9 ?? ?? ?? ?? 85 C9 74 0D 33 D2 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 45 E4 89 45 E0 83 7D E0 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 27 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 27 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 72 83 7D 0C FF 74 6A 81 7D 0C FF FF FF 7F 74 61 8B 55 0C 2B 55 FC 83 C2 01 3B 55 0C 73 53 E8 ?? ?? ?? ?? 89 45 DC 8B 45 0C 2B 45 FC 83 C0 01 8B 4D 0C 2B C8 39 4D DC 73 08 8B 55 DC 89 55 D8 EB 11 8B 45 0C 2B 45 FC 83 C0 01 8B 4D 0C 2B C8 89 4D D8 8B 55 D8 52 68 FE 00 00 00 8B 45 0C 2B 45 FC 8B 4D 08 8D 54 01 01 52 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_112_1_0 {
	meta:
		name = "__strset_s"
		size = 28
		refs = "0013 ??$common_tcsset_s@D@@YAHQADID@Z"
	strings:
		$1 = { 8B FF 55 8B EC 0F B6 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_113_0_0 {
	meta:
		name = "__j0"
		size = 274
		refs = "001e __real@401e000000000000 002f _J0q 0036 _J0p 0047 _evaluate 005a __real@4020000000000000 0067 _P0q 006e _P0p 008c _Q0q 0093 _Q0p 00b3 __real@400921fb54442d18 00bc __real@4000000000000000 00c7 _sqrt 00d3 __real@3fe921fb54442d18 00e1 _cos 00fe _sin"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 D9 EE DC 5D 08 DF E0 F6 C4 41 75 08 DD 45 08 D9 E0 DD 5D 08 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 01 75 2C 6A 04 68 ?? ?? ?? ?? 6A 0B 68 ?? ?? ?? ?? DD 45 08 DC 4D 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 E9 BB 00 00 00 E9 B6 00 00 00 DD 05 ?? ?? ?? ?? DC 75 08 DD 5D F8 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 F8 DC 4D F8 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DD 5D F0 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 F8 DC 4D F8 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DC 4D F8 DD 5D E8 DD 05 ?? ?? ?? ?? DC 4D 08 DC 3D ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D D8 E8 ?? ?? ?? ?? 83 C4 08 DC 4D F0 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D E0 E8 ?? ?? ?? ?? 83 C4 08 DC 4D E8 DC 6D E0 DC 4D D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_1_0 {
	meta:
		name = "__j1"
		size = 321
		refs = "002c __real@401e000000000000 0049 _J1q 0050 _J1p 0064 _evaluate 007a __real@4020000000000000 0087 _P1q 008e _P1p 00ac _Q1q 00b3 _Q1p 00dc __real@400921fb54442d18 00e5 __real@4000000000000000 00f3 _sqrt 0102 __real@4002d97c7f3321d2 0110 _cos 012d _sin"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 4C C7 45 FC 01 00 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 0F DD 45 08 D9 E0 DD 5D 08 C7 45 FC FF FF FF FF DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 01 75 3E DB 45 FC DD 5D EC DD 45 EC DC 4D 08 6A 04 68 ?? ?? ?? ?? 6A 0A 68 ?? ?? ?? ?? DD 45 08 DC 4D 08 83 EC 08 DD 1C 24 DD 5D E4 E8 ?? ?? ?? ?? 83 C4 18 DC 4D E4 E9 CA 00 00 00 E9 C5 00 00 00 DD 05 ?? ?? ?? ?? DC 75 08 DD 5D F4 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 F4 DC 4D F4 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DD 5D CC 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 F4 DC 4D F4 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DC 4D F4 DD 5D C4 DB 45 FC DD 5D DC DD 45 DC DD 05 ?? ?? ?? ?? DC 4D 08 DC 3D ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D D4 E8 ?? ?? ?? ?? 83 C4 08 DC 4D D4 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D B4 E8 ?? ?? ?? ?? 83 C4 08 DC 4D CC DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D BC E8 ?? ?? ?? ?? 83 C4 08 DC 4D C4 DC 6D BC DC 4D B4 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_2_0 {
	meta:
		name = "__jn"
		size = 449
		refs = "002e __j0 004a __j1 0081 _fabs"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 5C 83 7D 08 00 7D 10 8B 45 08 F7 D8 89 45 08 DD 45 0C D9 E0 DD 5D 0C 83 7D 08 00 75 16 83 EC 08 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 83 01 00 00 83 7D 08 01 75 16 83 EC 08 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 E9 67 01 00 00 DD 45 0C D9 EE DA E9 DF E0 F6 C4 44 7A 07 D9 EE E9 52 01 00 00 DB 45 08 DD 5D DC DD 45 DC 83 EC 08 DD 45 0C DD 1C 24 DD 5D D4 E8 ?? ?? ?? ?? 83 C4 08 DC 5D D4 DF E0 F6 C4 41 75 78 8B 4D 08 D1 E1 89 4D 08 83 EC 08 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D E4 83 EC 08 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F4 C7 45 FC 02 00 00 00 DD 45 F4 DD 5D EC DB 45 FC DD 5D CC DD 45 CC DC 4D F4 DC 75 0C DC 65 E4 DD 5D F4 8B 55 FC 83 C2 02 89 55 FC 8B 45 FC 3B 45 08 75 08 DD 45 F4 E9 C0 00 00 00 DD 45 EC DD 5D E4 EB C4 E9 B3 00 00 00 8B 4D 08 D1 E1 89 4D 08 DD 45 0C DC 4D 0C DD 5D BC D9 EE DD 5D EC 8B 55 08 83 C2 24 89 55 FC EB 09 8B 45 FC 83 E8 02 89 45 FC 8B 4D FC 3B 4D 08 7E 14 DB 45 FC DD 5D C4 DD 45 C4 DC 65 EC DC 7D BC DD 5D EC EB DB DB 45 08 DD 5D B4 DD 45 B4 DC 65 EC DC 7D 0C DD 5D F4 DD 45 F4 DD 5D A4 D9 E8 DD 5D E4 8B 55 08 83 EA 02 89 55 FC DD 45 E4 DD 5D EC DB 45 FC DD 5D AC DD 45 AC DC 4D E4 DC 75 0C DC 65 F4 DD 5D E4 8B 45 FC 83 E8 02 89 45 FC 75 02 EB 08 DD 45 EC DD 5D F4 EB D0 83 EC 08 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DC 4D A4 DC 75 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_3_0 {
	meta:
		name = "__y0"
		size = 405
		refs = "0012 __dclass 0032 __handle_qnan2 004f __d_ind 0062 _domain_err 0070 __real@401e000000000000 0081 _Y0q 0088 _Y0p 0099 _evaluate 00aa __j0 00b3 __real@3fe45f306dc9c883 00c4 _log 00dd __real@4020000000000000 00ea _P0q 00f1 _P0p 010f _Q0q 0116 _Q0p 0136 __real@400921fb54442d18 013f __real@4000000000000000 014a _sqrt 0156 __real@3fe921fb54442d18 0164 _sin 0181 _cos"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 98 83 F8 02 75 1F 83 EC 08 DD 45 08 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 E9 53 01 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 22 E8 ?? ?? ?? ?? 83 C4 14 E9 23 01 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 01 75 5D 6A 08 68 ?? ?? ?? ?? 6A 08 68 ?? ?? ?? ?? DD 45 08 DC 4D 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 DD 45 08 DD 1C 24 DD 5D E8 E8 ?? ?? ?? ?? 83 C4 08 DC 0D ?? ?? ?? ?? 83 EC 08 DD 45 08 DD 1C 24 DD 5D F0 E8 ?? ?? ?? ?? 83 C4 08 DC 4D F0 DC 45 E8 E9 BB 00 00 00 E9 B6 00 00 00 DD 05 ?? ?? ?? ?? DC 75 08 DD 5D F8 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 F8 DC 4D F8 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DD 5D E0 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 F8 DC 4D F8 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DC 4D F8 DD 5D D8 DD 05 ?? ?? ?? ?? DC 4D 08 DC 3D ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D C8 E8 ?? ?? ?? ?? 83 C4 08 DC 4D E0 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D D0 E8 ?? ?? ?? ?? 83 C4 08 DC 4D D8 DC 45 D0 DC 4D C8 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_4_0 {
	meta:
		name = "__y1"
		size = 412
		refs = "0012 __dclass 0032 __handle_qnan2 004f __d_ind 0062 _domain_err 0070 __real@401e000000000000 0081 _Y1q 0088 _Y1p 0099 _evaluate 00b0 __j1 00be _log 00d1 __real@3fe45f306dc9c883 00e4 __real@4020000000000000 00f1 _P1q 00f8 _P1p 0116 _Q1q 011d _Q1p 013d __real@400921fb54442d18 0146 __real@4000000000000000 0151 _sqrt 015d __real@4002d97c7f3321d2 016b _sin 0188 _cos"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 98 83 F8 02 75 1F 83 EC 08 DD 45 08 DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 10 E9 5A 01 00 00 D9 EE DC 5D 08 DF E0 F6 C4 41 75 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 08 DD 1C 24 6A 23 E8 ?? ?? ?? ?? 83 C4 14 E9 2A 01 00 00 DD 05 ?? ?? ?? ?? DC 5D 08 DF E0 F6 C4 01 75 64 6A 08 68 ?? ?? ?? ?? 6A 07 68 ?? ?? ?? ?? DD 45 08 DC 4D 08 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DC 4D 08 83 EC 08 DD 45 08 DD 1C 24 DD 5D E8 E8 ?? ?? ?? ?? DD 45 08 DD 1C 24 DD 5D F0 E8 ?? ?? ?? ?? 83 C4 08 DC 4D F0 D9 E8 DC 75 08 DE E9 DC 0D ?? ?? ?? ?? DC 45 E8 E9 BB 00 00 00 E9 B6 00 00 00 DD 05 ?? ?? ?? ?? DC 75 08 DD 5D F8 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 F8 DC 4D F8 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DD 5D E0 6A 05 68 ?? ?? ?? ?? 6A 05 68 ?? ?? ?? ?? DD 45 F8 DC 4D F8 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 18 DC 4D F8 DD 5D D8 DD 05 ?? ?? ?? ?? DC 4D 08 DC 3D ?? ?? ?? ?? 83 EC 08 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D C8 E8 ?? ?? ?? ?? 83 C4 08 DC 4D E0 DD 45 08 DC 25 ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 5D D0 E8 ?? ?? ?? ?? 83 C4 08 DC 4D D8 DC 45 D0 DC 4D C8 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_5_0 {
	meta:
		name = "__yn"
		size = 312
		refs = "0019 __d_ind 002c _domain_err 0078 __y0 00a3 __y1 00e1 __real@4000000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 58 D9 EE DC 5D 0C DF E0 F6 C4 41 75 24 83 EC 08 DD 05 ?? ?? ?? ?? DD 1C 24 83 EC 08 DD 45 0C DD 1C 24 6A 24 E8 ?? ?? ?? ?? 83 C4 14 E9 FC 00 00 00 C7 45 F8 01 00 00 00 83 7D 08 00 7D 17 8B 45 08 F7 D8 89 45 08 8B 4D 08 83 E1 01 74 07 C7 45 F8 FF FF FF FF 83 7D 08 00 75 25 DB 45 F8 DD 5D D8 DD 45 D8 83 EC 08 DD 45 0C DD 1C 24 DD 5D D0 E8 ?? ?? ?? ?? 83 C4 08 DC 4D D0 E9 AD 00 00 00 83 7D 08 01 75 25 DB 45 F8 DD 5D C8 DD 45 C8 83 EC 08 DD 45 0C DD 1C 24 DD 5D C0 E8 ?? ?? ?? ?? 83 C4 08 DC 4D C0 E9 82 00 00 00 83 EC 08 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D E0 83 EC 08 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? 83 C4 08 DD 5D F0 D9 EE DD 5D E8 DD 05 ?? ?? ?? ?? DC 75 0C DD 5D B0 C7 45 FC 01 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 8B 45 FC 3B 45 08 7D 23 DB 45 FC DD 5D B8 DD 45 B8 DC 4D B0 DC 4D F0 DC 65 E0 DD 5D E8 DD 45 F0 DD 5D E0 DD 45 E8 DD 5D F0 EB CC DB 45 F8 DD 5D A8 DD 45 A8 DC 4D E8 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_6_0 {
	meta:
		name = "_domain_err"
		size = 67
		refs = "0011 __ctrlfp 0038 __except1"
	strings:
		$1 = { 8B FF 55 8B EC 51 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? 83 C4 08 89 45 FC 8B 45 FC 50 83 EC 08 DD 45 14 DD 1C 24 83 EC 08 DD 45 0C DD 1C 24 8B 4D 08 51 6A 08 E8 ?? ?? ?? ?? 83 C4 1C 8B E5 5D C3 }
	condition:
		$1
}

rule file_113_7_0 {
	meta:
		name = "_evaluate"
		size = 305
		refs = "0031 ??_C@_1CC@JOKKCJAA@?$AAn?$AA1?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AAn?$AA2?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0036 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0042 ??_C@_1FK@MDONPEON@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 0049 __CrtDbgReportW 0069 ??_C@_1BC@LLMCKKDB@?$AAe?$AAv?$AAa?$AAl?$AAu?$AAa?$AAt?$AAe?$AA?$AA@ 0073 __invalid_parameter 007c __real@bff0000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 83 7D 14 00 7E 0F 83 7D 1C 00 7E 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8B 45 F8 89 45 F4 83 7D F4 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 3A 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F4 00 75 29 6A 00 68 3A 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 DD 05 ?? ?? ?? ?? E9 A8 00 00 00 8B 55 14 8B 45 10 DD 45 08 DC 0C D0 DD 5D EC 8B 4D 14 83 E9 01 89 4D FC EB 09 8B 55 FC 83 EA 01 89 55 FC 83 7D FC 00 7E 14 8B 45 FC 8B 4D 10 DD 04 C1 DC 45 EC DC 4D 08 DD 5D EC EB DD BA 08 00 00 00 6B C2 00 8B 4D 10 DD 45 EC DC 04 01 DD 5D EC 8B 55 1C 8B 45 18 DD 45 08 DC 0C D0 DD 5D E4 8B 4D 1C 83 E9 01 89 4D FC EB 09 8B 55 FC 83 EA 01 89 55 FC 83 7D FC 00 7E 14 8B 45 FC 8B 4D 18 DD 04 C1 DC 45 E4 DC 4D 08 DD 5D E4 EB DD BA 08 00 00 00 6B C2 00 8B 4D 18 DD 45 E4 DC 04 01 DD 5D E4 DD 45 EC DC 75 E4 8B E5 5D C3 }
	condition:
		$1
}

rule file_115_5_0 {
	meta:
		name = "__mbsbtype_l"
		size = 271
		refs = "001a ??_C@_1CE@BLLJFLOH@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0022 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002a ??_C@_1HC@EEJIICCJ@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0032 __CrtDbgReportW 0040 __errno 0049 ??_C@_1BI@IGAIOCOA@?$AA_?$AAm?$AAb?$AAs?$AAb?$AAt?$AAy?$AAp?$AAe?$AA_?$AAl?$AA?$AA@ 0055 __invalid_parameter 006b ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 009d __mbbtype_l 00b1 ??_C@_1CA@MCAHMKMK@?$AA?$CK?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 33 C0 53 56 57 8B 7D 08 85 FF 0F 95 C0 85 C0 75 4B BB ?? ?? ?? ?? 33 F6 53 68 ?? ?? ?? ?? 56 6A 31 BF ?? ?? ?? ?? 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 6A 31 57 68 ?? ?? ?? ?? 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A4 00 00 00 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F8 33 F6 39 70 08 74 7B 8B 5D 0C 83 CA FF 85 DB 75 04 38 1F 74 6A 8A 0F 33 C0 84 C9 0F 95 C0 85 C0 74 1C 8A C1 8D 4D F4 51 52 50 E8 ?? ?? ?? ?? 83 C4 0C 8B D0 47 8B C3 4B 85 C0 75 D1 EB 46 BB ?? ?? ?? ?? BF ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 56 6A 43 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 6A 43 57 68 ?? ?? ?? ?? 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 CE FF 8B D6 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B C2 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_3_0 {
	meta:
		name = "?eof@__crt_stdio_stream@@QBE_NXZ"
		size = 23
		refs = "000f ?has_any_of@__crt_stdio_stream@@QBE_NJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 6A 08 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_4_0 {
	meta:
		name = "?error@__crt_stdio_stream@@QBE_NXZ"
		size = 23
		refs = "000f ?has_any_of@__crt_stdio_stream@@QBE_NJ@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 89 4D FC 6A 10 8B 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_7_0 {
	meta:
		name = "_feof"
		size = 151
		refs = "002b ??_C@_1DC@OGOLMDEL@?$AAp?$AAu?$AAb?$AAl?$AAi?$AAc?$AA_?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0030 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0039 ??_C@_1GC@CMLBJHAF@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0040 __CrtDbgReportW 0054 __errno 0068 ??_C@_19LPGIFIDB@?$AAf?$AAe?$AAo?$AAf?$AA?$AA@ 0072 __invalid_parameter 0085 ??0__crt_stdio_stream@@QAE@QAU_iobuf@@@Z 008c ?eof@__crt_stdio_stream@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 11 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 11 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 16 8B 55 08 52 8D 4D F4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_116_8_0 {
	meta:
		name = "_ferror"
		size = 151
		refs = "002b ??_C@_1DC@OGOLMDEL@?$AAp?$AAu?$AAb?$AAl?$AAi?$AAc?$AA_?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0030 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0039 ??_C@_1GC@CMLBJHAF@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0040 __CrtDbgReportW 0054 __errno 0068 ??_C@_1O@MOPHEPGP@?$AAf?$AAe?$AAr?$AAr?$AAo?$AAr?$AA?$AA@ 0072 __invalid_parameter 0085 ??0__crt_stdio_stream@@QAE@QAU_iobuf@@@Z 008c ?error@__crt_stdio_stream@@QBE_NXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 89 45 F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 1B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 2A E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 1B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 16 8B 55 08 52 8D 4D F4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 0F B6 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "__CIatan_pentium4"
		size = 712
		refs = "002a _mabs 0032 _in 0046 _in1 0050 _in0 006e _p01 007a _p23 0086 _p45 0092 _p60 00be _in2 00dc _d01 00e8 _d23 00f4 _d45 0100 _d67 010c _d89 0118 _d1011 0124 _d1213 0130 _d1400 0164 _in3 016e _cnst8 0176 _cntshf 0197 __atan_table 01ab _one 01c6 _onen 0254 _zero 0263 _minval 026b libm_small 029f _mexp 02bd _pi_2d"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 3C 24 E8 08 00 00 00 C9 C3 F3 0F 7E 7C 24 04 66 0F 14 FF 66 0F 28 D7 66 0F 54 15 ?? ?? ?? ?? 66 0F 2E 15 ?? ?? ?? ?? 0F 8A 86 02 00 00 0F 83 55 02 00 00 66 0F 2F 15 ?? ?? ?? ?? 73 6E 66 0F 2F 15 ?? ?? ?? ?? 0F 82 F6 01 00 00 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EF F2 0F 5C FD 66 0F D6 7C 24 04 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 0F 83 90 00 00 00 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EF F2 0F 5C FD 66 0F D6 7C 24 04 DD 44 24 04 C3 F3 0F 7E F7 66 0F 57 F2 66 0F 2F 15 ?? ?? ?? ?? 73 4F F3 0F 7E 05 ?? ?? ?? ?? F3 0F 7E 2D ?? ?? ?? ?? F3 0F 7E DA F2 0F 58 D8 66 0F 73 D3 2C 66 0F FA DD 66 0F 7E D8 8D 04 40 F3 0F 7E 2C C5 ?? ?? ?? ?? F3 0F 7E DA F2 0F 5C D5 F2 0F 59 DD F2 0F 58 1D ?? ?? ?? ?? F2 0F 5E D3 66 0F 14 D2 EB 19 B8 00 03 00 00 F3 0F 7E C2 F3 0F 7E 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 14 D2 F3 0F 7E 04 C5 ?? ?? ?? ?? F3 0F 7E 24 C5 ?? ?? ?? ?? 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EA F2 0F 5C EC F2 0F 5C EA F2 0F 5C C5 66 0F 56 C6 66 0F D6 44 24 04 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 75 05 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 73 1D DD 05 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 04 24 83 C4 08 DC 44 24 04 C3 DD 05 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DC 44 24 04 C3 F3 0F 7E C2 F3 0F 7E 1D ?? ?? ?? ?? 66 0F 54 C3 66 0F 2E C3 7A 15 8B 44 24 08 C1 E8 1F DD 05 ?? ?? ?? ?? DC 04 C5 ?? ?? ?? ?? C3 DD 44 24 04 C3 90 }
	condition:
		$1
}

rule file_118_6_0 {
	meta:
		name = "__ismbcalnum_l"
		size = 107
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0050 ___dcrt_multibyte_check_type"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8D 4D F0 FF 75 0C E8 ?? ?? ?? ?? 8B 45 08 3D FF 00 00 00 77 26 0F B6 C8 BA 07 01 00 00 8B 45 F4 8B 00 66 85 14 48 75 0E 8B 45 F8 F6 44 01 19 01 75 04 33 C0 EB 19 33 C0 40 EB 14 6A 01 68 07 01 00 00 8D 4D F4 51 50 E8 ?? ?? ?? ?? 83 C4 10 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_119_0_0 {
	meta:
		name = "?dup2_nolock@@YAHHH@Z"
		size = 447
		refs = "001b ___pioinfo 002a __errno 0035 ___doserrno 0044 ??_C@_1JE@ECKHFIFP@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AAd?$AAe?$AAs?$AAc?$AAr?$AAi?$AAp?$AAt?$AAo?$AAr?$AA?4?$AA?5?$AAF?$AAi?$AAl?$AAe?$AA?5@ 0049 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0052 ??_C@_1FM@BJKFIHHL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAl@ 0059 __CrtDbgReportW 0093 __close_nolock 00a6 __imp__GetCurrentProcess@0 00b0 __get_osfhandle 00c1 __imp__DuplicateHandle@28 00d0 __imp__GetLastError@0 00d6 ___acrt_errno_map_os_error 00ee ___acrt_lowio_set_os_handle"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 56 8B 45 08 C1 F8 06 8B 4D 08 83 E1 3F 6B D1 30 8B 04 85 ?? ?? ?? ?? 0F B6 4C 10 28 83 E1 01 75 45 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? C7 00 00 00 00 00 33 D2 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 16 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 C8 FF E9 4C 01 00 00 8B 4D 0C C1 F9 06 8B 55 0C 83 E2 3F 6B C2 30 8B 0C 8D ?? ?? ?? ?? 0F B6 54 01 28 83 E2 01 74 0C 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 6A 02 6A 01 6A 00 8D 4D F8 51 FF 15 ?? ?? ?? ?? 50 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 50 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 17 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF E9 D5 00 00 00 8B 45 F8 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 C1 FA 06 8B 45 08 83 E0 3F 6B C8 30 8B 14 95 ?? ?? ?? ?? 0F B6 44 0A 28 83 E0 EF 8B 4D 0C C1 F9 06 8B 55 0C 83 E2 3F 6B D2 30 8B 0C 8D ?? ?? ?? ?? 88 44 11 28 8B 55 08 C1 FA 06 8B 45 08 83 E0 3F 6B C8 30 8B 14 95 ?? ?? ?? ?? 8B 45 0C C1 F8 06 8B 75 0C 83 E6 3F 6B F6 30 8B 04 85 ?? ?? ?? ?? 8A 4C 0A 29 88 4C 30 29 8B 55 08 C1 FA 06 8B 45 08 83 E0 3F 6B C8 30 8B 14 95 ?? ?? ?? ?? 8A 44 0A 2D 24 01 8B 4D 0C C1 F9 06 8B 55 0C 83 E2 3F 6B D2 30 8B 0C 8D ?? ?? ?? ?? 24 01 8A 54 11 2D 80 E2 FE 0A D0 8B 45 0C C1 F8 06 8B 4D 0C 83 E1 3F 6B C9 30 8B 04 85 ?? ?? ?? ?? 88 54 08 2D 33 C0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_119_1_0 {
	meta:
		name = "__dup2"
		size = 767
		refs = "0008 __sehtable$__dup2 000d __except_handler4 001f ___security_cookie 0039 ___doserrno 0044 __errno 0061 __nhandle 0084 ??_C@_1HK@KIBKPCDA@?$AA?$CI?$AAs?$AAo?$AAu?$AAr?$AAc?$AAe?$AA_?$AAf?$AAh?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAs?$AAo?$AAu@ 0089 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0092 ??_C@_1FM@BJKFIHHL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAl@ 0099 __CrtDbgReportW 00cc ??_C@_1M@KHHJPKPI@?$AA_?$AAd?$AAu?$AAp?$AA2?$AA?$AA@ 00d6 __invalid_parameter 00f7 ___pioinfo 0122 ??_C@_1DK@LOMDIPEA@?$AA?$CI?$AA_?$AAo?$AAs?$AAf?$AAi?$AAl?$AAe?$AA?$CI?$AAs?$AAo?$AAu?$AAr?$AAc?$AAe?$AA_?$AAf?$AAh?$AA?$CJ?$AA?5?$AA?$CG?$AA?5?$AAF?$AAO?$AAP?$AAE?$AAN?$AA?$CJ?$AA?$AA@ 01cd ??_C@_1EE@NANLJLAK@?$AA?$CI?$AA?$CI?$AAu?$AAn?$AAs?$AAi?$AAg?$AAn?$AAe?$AAd?$AA?$CJ?$AAt?$AAa?$AAr?$AAg?$AAe?$AAt?$AA_?$AAf?$AAh?$AA?5?$AA?$DM?$AA?5?$AA_?$AAN?$AAH?$AAA?$AAN?$AAD?$AAL?$AAE?$AA_@ 023e ___acrt_lowio_ensure_fh_exists 026d ___acrt_lowio_lock_fh 02b9 ?dup2_nolock@@YAHHH@Z 02d6 ___acrt_lowio_unlock_fh"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 DC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 83 7D 08 FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 97 02 00 00 83 7D 08 00 7C 14 8B 45 08 3B 05 ?? ?? ?? ?? 73 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D E0 83 7D E0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 48 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 48 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 08 02 00 00 8B 45 08 C1 F8 06 8B 4D 08 83 E1 3F 6B D1 30 8B 04 85 ?? ?? ?? ?? 0F B6 4C 10 28 83 E1 01 74 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 55 DC 89 55 D8 83 7D D8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 49 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D8 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 49 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 6A 01 00 00 83 7D 0C FE 75 1E E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 46 01 00 00 81 7D 0C 00 20 00 00 73 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 4D D4 89 4D D0 83 7D D0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 4B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D0 00 75 39 E8 ?? ?? ?? ?? C7 00 00 00 00 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 6A 00 6A 4B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 BF 00 00 00 8B 45 0C 3B 05 ?? ?? ?? ?? 7C 18 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 83 C8 FF E9 9C 00 00 00 8B 55 08 3B 55 0C 75 07 33 C0 E9 8D 00 00 00 8B 45 08 3B 45 0C 7D 1A 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 0C 52 E8 ?? ?? ?? ?? 83 C4 04 EB 20 8B 45 08 3B 45 0C 7E 18 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 04 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 C7 45 CC 00 00 00 00 C7 45 FC 00 00 00 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 89 45 CC C7 45 FC FE FF FF FF E8 02 00 00 00 EB 19 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 04 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 CC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_120_5_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QAE@XZ"
		size = 23
		refs = "000e __imp__FreeEnvironmentStringsW@4"
		altNames = "?close@?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 83 3E 00 74 0B FF 36 FF 15 ?? ?? ?? ?? 83 26 00 5E C3 }
	condition:
		$1
}

rule file_120_12_0 {
	meta:
		name = "?close@environment_strings_traits@?A0x1bf47908@@SA_NPA_W@Z"
		size = 18
		refs = "000a __imp__FreeEnvironmentStringsW@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? B0 01 5D C3 }
	condition:
		$1
}

rule file_120_15_0 {
	meta:
		name = "?find_end_of_double_null_terminated_sequence@@YAPB_WQB_W@Z"
		size = 55
	strings:
		$1 = { 8B FF 55 8B EC 8B 55 08 57 33 FF 66 39 3A 74 21 56 8B CA 8D 71 02 66 8B 01 83 C1 02 66 3B C7 75 F5 2B CE D1 F9 8D 14 4A 83 C2 02 66 39 3A 75 E1 5E 8D 42 02 5F 5D C3 }
	condition:
		$1
}

rule file_120_25_0 {
	meta:
		name = "___dcrt_get_narrow_environment_from_os"
		size = 145
		refs = "000b __imp__GetEnvironmentStringsW@0 0019 ?find_end_of_double_null_terminated_sequence@@YAPB_WQB_W@Z 002e __imp__WideCharToMultiByte@32 003c ??_C@_0ED@BLPEHJAI@minkernel?2crts?2ucrt?2src?2desktopc@ 0044 __malloc_dbg 0073 __free_dbg 0084 __imp__FreeEnvironmentStringsW@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 57 FF 15 ?? ?? ?? ?? 8B F0 33 FF 85 F6 74 64 56 E8 ?? ?? ?? ?? 59 57 57 57 8B D8 57 2B DE D1 FB 53 56 57 57 FF 15 ?? ?? ?? ?? 89 45 FC 85 C0 74 42 6A 66 68 ?? ?? ?? ?? 6A 02 50 E8 ?? ?? ?? ?? 8B F8 83 C4 10 85 FF 74 1C 33 C0 50 50 FF 75 FC 57 53 56 50 50 FF 15 ?? ?? ?? ?? 85 C0 74 06 8B DF 33 FF EB 02 33 DB 6A 02 57 E8 ?? ?? ?? ?? 59 59 EB 02 8B DF 85 F6 74 07 56 FF 15 ?? ?? ?? ?? 5F 5E 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_120_26_0 {
	meta:
		name = "___dcrt_get_wide_environment_from_os"
		size = 93
		refs = "0006 __imp__GetEnvironmentStringsW@0 0017 ?find_end_of_double_null_terminated_sequence@@YAPB_WQB_W@Z 0022 ??_C@_0ED@BLPEHJAI@minkernel?2crts?2ucrt?2src?2desktopc@ 002d __malloc_dbg 003e _memcpy 004a __free_dbg 0053 __imp__FreeEnvironmentStringsW@4"
	strings:
		$1 = { 8B FF 56 57 FF 15 ?? ?? ?? ?? 8B F0 85 F6 75 04 33 FF EB 44 53 56 E8 ?? ?? ?? ?? 2B C6 D1 F8 6A 40 68 ?? ?? ?? ?? 6A 02 8D 1C 00 53 E8 ?? ?? ?? ?? 8B F8 83 C4 14 85 FF 74 0B 53 56 57 E8 ?? ?? ?? ?? 83 C4 0C 6A 02 6A 00 E8 ?? ?? ?? ?? 59 59 56 FF 15 ?? ?? ?? ?? 5B 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "___libm_sse2_sincosf"
		size = 517
		refs = "0023 _PI32INV 002f _SHIFTER 003f _P_1 004b _P_2 0064 _SC_4 006a ___acrt_sincos_ctable 007f _P_3 00a0 _SC_2 00f2 _SC_3 00fe _SC_1 0186 _ONE 0194 _ALL_ONES 01a5 _TWO_POW_55 01b5 _TWO_POW_M55 01da _cos 01ee _sin"
	strings:
		$1 = { F3 0F 5A C0 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 53 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 15 ?? ?? ?? ?? F2 0F 2D D1 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D9 81 C2 00 76 1C 00 66 0F 28 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 06 03 C2 66 0F 59 D1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 66 0F 5C E3 66 0F 28 78 10 66 0F 28 DC 66 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 FC 66 0F 5C DC 66 0F 59 E8 66 0F 59 C0 66 0F 5C DA 66 0F 28 10 66 0F 5C CB 66 0F 28 58 30 66 0F 58 D3 66 0F 5C FA 66 0F 59 CF 66 0F 28 78 10 66 0F 59 D4 66 0F 59 F0 66 0F 59 DC 66 0F 59 D0 66 0F 59 F8 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 C3 66 0F 58 58 10 66 0F 58 F5 F2 0F 10 EE 66 0F 15 F6 66 0F 14 ED 66 0F 59 F7 66 0F 59 D5 66 0F 28 FC 66 0F 58 E3 66 0F 28 68 10 66 0F 5C EB 66 0F 5C DC 66 0F 58 48 20 66 0F 58 E8 66 0F 58 DF 66 0F 58 CD 66 0F 58 CB 66 0F 58 CA 66 0F 58 CE 66 0F 58 CC F2 0F 10 C1 66 0F 15 C9 F2 0F 5A C0 F2 0F 5A C9 C3 7F 52 F2 0F 10 C8 66 0F C5 C0 03 66 0D 00 80 66 0F C4 C8 03 F2 0F 58 0D ?? ?? ?? ?? 66 3D 10 80 7D 11 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5A C0 F2 0F 5A C9 C3 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C C3 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5A C0 F2 0F 5A C9 C3 8B C4 83 EC 20 83 E4 F0 89 44 24 08 66 0F D6 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 5C 24 18 F3 0F 7E 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 1C 24 66 0F 6E 04 24 66 0F 6E 4C 24 18 8B 64 24 08 C3 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "__fderfc"
		size = 163
		refs = "001f __s 005f __c 0095 __fdexp"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 D9 45 08 D9 E0 D8 4D 08 D9 5D FC 6A 00 B8 04 00 00 00 6B C8 00 D9 81 ?? ?? ?? ?? D8 4D 08 BA 04 00 00 00 C1 E2 00 D8 82 ?? ?? ?? ?? D8 4D 08 B8 04 00 00 00 D1 E0 D8 80 ?? ?? ?? ?? D8 4D 08 B9 04 00 00 00 6B D1 03 D8 82 ?? ?? ?? ?? B8 04 00 00 00 6B C8 00 D9 81 ?? ?? ?? ?? D8 4D 08 BA 04 00 00 00 C1 E2 00 D8 82 ?? ?? ?? ?? D8 4D 08 B8 04 00 00 00 D1 E0 D8 80 ?? ?? ?? ?? DE F9 D9 5D F8 D9 45 F8 51 D9 1C 24 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 0C D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_122_1_0 {
	meta:
		name = "_erff"
		size = 396
		refs = "000d __fdtest 004c __real@bf800000 0067 __real@0000000000000000 008d __fderf_small 00b1 _s 00f1 _c 013b __fderf_one 0150 __fderfc"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 89 4D F8 83 7D F8 00 74 0E 83 7D F8 01 74 10 83 7D F8 02 74 02 EB 34 D9 45 08 E9 52 01 00 00 BA 02 00 00 00 C1 E2 00 0F B7 44 15 08 25 00 80 00 00 74 0B D9 05 ?? ?? ?? ?? D9 5D F4 EB 05 D9 E8 D9 5D F4 D9 45 F4 E9 26 01 00 00 D9 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 0A D9 45 08 D9 E0 D9 5D F0 EB 06 D9 45 08 D9 5D F0 D9 45 F0 D9 5D FC D9 45 FC D9 05 ?? ?? ?? ?? DE D9 DF E0 F6 C4 41 0F 85 98 00 00 00 D9 45 08 D8 4D 08 D9 5D FC B9 04 00 00 00 6B D1 00 D9 82 ?? ?? ?? ?? D8 4D FC B8 04 00 00 00 C1 E0 00 D8 80 ?? ?? ?? ?? D8 4D FC B9 04 00 00 00 D1 E1 D8 81 ?? ?? ?? ?? D8 4D FC BA 04 00 00 00 6B C2 03 D8 80 ?? ?? ?? ?? B9 04 00 00 00 6B D1 00 D9 82 ?? ?? ?? ?? D8 4D FC B8 04 00 00 00 C1 E0 00 D8 80 ?? ?? ?? ?? D8 4D FC B9 04 00 00 00 D1 E1 D8 81 ?? ?? ?? ?? D8 4D FC BA 04 00 00 00 6B C2 03 D8 80 ?? ?? ?? ?? DE F9 D8 4D 08 D9 5D E8 D9 45 E8 EB 54 EB 2F D9 45 FC D9 05 ?? ?? ?? ?? DE D9 DF E0 F6 C4 41 75 18 51 D9 45 FC D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D9 E8 DE E1 D9 5D FC EB 05 D9 E8 D9 5D FC D9 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 0A D9 45 FC D9 E0 D9 5D EC EB 06 D9 45 FC D9 5D EC D9 45 EC 8B E5 5D C3 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "__set_error_mode"
		size = 186
		refs = "0024 ___acrt_error_mode 0061 ??_C@_1DE@BCNCAIK@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAe?$AAr?$AAr?$AAo?$AAr?$AA_?$AAm?$AAo?$AAd?$AAe?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0066 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 006f ??_C@_1GO@EBFPMMIJ@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAm@ 0076 __CrtDbgReportW 008a __errno 009e ??_C@_1CA@LFDHAMEM@?$AA_?$AAs?$AAe?$AAt?$AA_?$AAe?$AAr?$AAr?$AAo?$AAr?$AA_?$AAm?$AAo?$AAd?$AAe?$AA?$AA@ 00a8 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 45 08 89 45 FC 83 7D FC 00 7C 2C 83 7D FC 02 7E 08 83 7D FC 03 74 19 EB 1E 8B 0D ?? ?? ?? ?? 89 4D F0 8B 55 08 89 15 ?? ?? ?? ?? 8B 45 F0 EB 7D A1 ?? ?? ?? ?? EB 76 33 C0 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8B 4D F8 89 4D F4 83 7D F4 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 45 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F4 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 45 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 02 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_125_5_0 {
	meta:
		name = "__mbctolower_l"
		size = 156
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0058 ___acrt_LCMapStringA"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8D 4D E8 53 FF 75 0C E8 ?? ?? ?? ?? 8B 5D 08 81 FB FF 00 00 00 76 54 8B 4D F0 8B C3 C1 E8 08 88 45 FC 0F B6 C0 88 5D FD F6 44 08 19 04 74 4E 6A 01 FF 71 04 8D 45 F8 6A 02 50 6A 02 8D 45 FC 50 68 00 01 00 00 FF B1 1C 02 00 00 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 22 8B 45 F8 0F B6 D8 C1 E3 08 0F B6 C4 03 D8 EB 12 8B 45 F0 F6 44 18 19 10 74 08 0F B6 9C 18 19 01 00 00 80 7D F4 00 74 0A 8B 4D E8 83 A1 50 03 00 00 FD 8B C3 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_126_4_0 {
	meta:
		name = "__mbtowc_l"
		size = 565
		refs = "0042 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 004a ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0067 ??_C@_1BBC@DECGKMGJ@?$AA_?$AAl?$AAo?$AAc?$AA_?$AAu?$AAp?$AAd?$AAa?$AAt?$AAe?$AA?4?$AAG?$AAe?$AAt?$AAL?$AAo?$AAc?$AAa?$AAl?$AAe?$AAT?$AA?$CI?$AA?$CJ?$AA?9?$AA?$DO?$AAl?$AAo?$AAc?$AAi?$AAn?$AAf@ 006c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0075 ??_C@_1GE@CGIHMDEJ@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 007c __CrtDbgReportW 00c2 ??1_LocaleUpdate@@QAE@XZ 00df __isleadbyte_l 0152 __imp__MultiByteToWideChar@24 0178 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 2C 83 7D 0C 00 74 06 83 7D 10 00 75 07 33 C0 E9 16 02 00 00 8B 45 0C 0F BE 08 85 C9 75 15 83 7D 08 00 74 08 33 D2 8B 45 08 66 89 10 33 C0 E9 F7 01 00 00 8B 4D 14 51 8D 4D D4 E8 ?? ?? ?? ?? 8D 4D D4 E8 ?? ?? ?? ?? 8B 10 83 7A 04 01 74 33 8D 4D D4 E8 ?? ?? ?? ?? 8B 00 83 78 04 02 74 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 3F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8D 4D D4 E8 ?? ?? ?? ?? 8B 10 B8 04 00 00 00 D1 E0 83 BC 02 A0 00 00 00 00 75 2A 83 7D 08 00 74 0D 8B 4D 0C 66 0F B6 11 8B 45 08 66 89 10 C7 45 F4 01 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 F4 E9 63 01 00 00 8D 4D D4 E8 ?? ?? ?? ?? 50 8B 4D 0C 0F B6 11 52 E8 ?? ?? ?? ?? 83 C4 08 85 C0 0F 84 CA 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 00 83 78 04 01 7E 5C 8D 4D D4 E8 ?? ?? ?? ?? 8B 08 8B 55 10 3B 51 04 7C 4A 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 45 FC 50 8B 4D 08 51 8D 4D D4 E8 ?? ?? ?? ?? 8B 10 8B 42 04 50 8B 4D 0C 51 6A 09 8D 4D D4 E8 ?? ?? ?? ?? 8B 10 8B 42 08 50 FF 15 ?? ?? ?? ?? 85 C0 75 3F 8D 4D D4 E8 ?? ?? ?? ?? 8B 08 8B 55 10 3B 51 04 72 0B 8B 45 0C 0F BE 48 01 85 C9 75 22 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 F0 FF FF FF FF 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 F0 E9 98 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 10 8B 42 04 89 45 EC 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 EC EB 7B EB 71 83 7D 08 00 74 09 C7 45 F8 01 00 00 00 EB 07 C7 45 F8 00 00 00 00 8B 4D F8 51 8B 55 08 52 6A 01 8B 45 0C 50 6A 09 8D 4D D4 E8 ?? ?? ?? ?? 8B 08 8B 51 08 52 FF 15 ?? ?? ?? ?? 85 C0 75 1F E8 ?? ?? ?? ?? C7 00 2A 00 00 00 C7 45 E8 FF FF FF FF 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 E8 EB 1C C7 45 E4 01 00 00 00 8D 4D D4 E8 ?? ?? ?? ?? 8B 45 E4 EB 08 8D 4D D4 E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_126_5_0 {
	meta:
		name = "_mbtowc"
		size = 29
		refs = "0014 __mbtowc_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_240_13_0 {
	meta:
		name = "__aligned_realloc_base"
		size = 29
		refs = "0014 __aligned_offset_realloc_base"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_46_0 {
	meta:
		name = "__strtoi64"
		size = 29
		refs = "0014 ??$parse_integer_from_string@_JDPAPAD@__crt_strtox@@YA_JQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_51_2 {
	meta:
		name = "__strtoui64"
		size = 29
		refs = "0014 ??$parse_integer_from_string@_KDPAPAD@__crt_strtox@@YA_KQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_56_2 {
	meta:
		name = "__wcstoi64"
		size = 29
		refs = "0014 ??$parse_integer_from_string@_J_WPAPA_W@__crt_strtox@@YA_JQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_61_2 {
	meta:
		name = "__wcstoui64"
		size = 29
		refs = "0014 ??$parse_integer_from_string@_K_WPAPA_W@__crt_strtox@@YA_KQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_66_3 {
	meta:
		name = "_strtoimax"
		size = 29
		refs = "0014 ??$parse_integer_from_string@_JDPAPAD@__crt_strtox@@YA_JQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_67_3 {
	meta:
		name = "_strtol"
		size = 29
		refs = "0014 ??$parse_integer_from_string@JDPAPAD@__crt_strtox@@YAJQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_68_3 {
	meta:
		name = "_strtoll"
		size = 29
		refs = "0014 ??$parse_integer_from_string@_JDPAPAD@__crt_strtox@@YA_JQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_69_3 {
	meta:
		name = "_strtoul"
		size = 29
		refs = "0014 ??$parse_integer_from_string@KDPAPAD@__crt_strtox@@YAKQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_70_3 {
	meta:
		name = "_strtoull"
		size = 29
		refs = "0014 ??$parse_integer_from_string@_KDPAPAD@__crt_strtox@@YA_KQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_71_4 {
	meta:
		name = "_strtoumax"
		size = 29
		refs = "0014 ??$parse_integer_from_string@_KDPAPAD@__crt_strtox@@YA_KQBDQAPADHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_425_5_0 {
	meta:
		name = "_strxfrm"
		size = 29
		refs = "0014 __strxfrm_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_72_2 {
	meta:
		name = "_wcstoimax"
		size = 29
		refs = "0014 ??$parse_integer_from_string@_J_WPAPA_W@__crt_strtox@@YA_JQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_73_2 {
	meta:
		name = "_wcstol"
		size = 29
		refs = "0014 ??$parse_integer_from_string@J_WPAPA_W@__crt_strtox@@YAJQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_74_0 {
	meta:
		name = "_wcstoll"
		size = 29
		refs = "0014 ??$parse_integer_from_string@_J_WPAPA_W@__crt_strtox@@YA_JQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_332_10_4 {
	meta:
		name = "_wcstombs"
		size = 29
		refs = "0014 ?_wcstombs_l_helper@@YAIPADPB_WIPAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_75_3 {
	meta:
		name = "_wcstoul"
		size = 29
		refs = "0014 ??$parse_integer_from_string@K_WPAPA_W@__crt_strtox@@YAKQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_76_3 {
	meta:
		name = "_wcstoull"
		size = 29
		refs = "0014 ??$parse_integer_from_string@_K_WPAPA_W@__crt_strtox@@YA_KQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_541_77_4 {
	meta:
		name = "_wcstoumax"
		size = 29
		refs = "0014 ??$parse_integer_from_string@_K_WPAPA_W@__crt_strtox@@YA_KQB_WQAPA_WHQAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_249_5_4 {
	meta:
		name = "_wcsxfrm"
		size = 29
		refs = "0014 __wcsxfrm_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_127_4_0 {
	meta:
		name = "?internal_to_string@@YAHQADIQAU_strflt@@HQAH2@Z"
		size = 291
		refs = "004b ??_C@_1EK@MLDBCLCM@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AAm?$AAi?$AAn?$AAi?$AAm?$AAu?$AAm?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc@ 0050 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0059 ??_C@_1GA@BEKLNMA@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 0060 __CrtDbgReportW 0074 __errno 0088 ??_C@_1CG@HMPBPEAJ@?$AAi?$AAn?$AAt?$AAe?$AAr?$AAn?$AAa?$AAl?$AA_?$AAt?$AAo?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?$AA@ 0092 __invalid_parameter 00d3 ___acrt_fp_strflt_to_string"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 20 83 7D 14 00 7E 08 8B 45 14 89 45 F8 EB 07 C7 45 F8 00 00 00 00 8B 4D F8 83 C1 02 89 4D E4 8B 55 0C 3B 55 E4 72 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 22 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 22 00 00 00 EB 7F 8B 55 0C 83 EA 02 39 55 14 7D 08 8B 45 14 89 45 EC EB 09 8B 4D 0C 83 E9 02 89 4D EC 8B 55 EC 89 55 E0 8B 45 10 50 8B 4D E0 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 83 7D FC 00 74 0F E8 ?? ?? ?? ?? 8B 4D FC 89 08 8B 45 FC EB 2D 8B 55 10 83 3A 2D 75 09 C7 45 E8 01 00 00 00 EB 07 C7 45 E8 00 00 00 00 8B 45 1C 8B 4D E8 89 08 8B 55 18 8B 45 10 8B 48 04 89 0A 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_127_6_0 {
	meta:
		name = "?try_get_ptd_buffer@@YAPADXZ"
		size = 109
		refs = "0009 ___acrt_getptd_noexit 002e ??_C@_0DA@BFCMAIEI@minkernel?2crts?2ucrt?2src?2appcrt?2c@ 003a __malloc_dbg 0046 ??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@QAD@Z 0051 ?detach@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEPADXZ 005f ??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 04 33 C0 EB 4F 8B 45 FC 83 78 3C 00 74 08 8B 4D FC 8B 41 3C EB 3E 6A 1A 68 ?? ?? ?? ?? 6A 02 68 5D 01 00 00 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D F4 E8 ?? ?? ?? ?? 89 45 F8 8B 4D F8 E8 ?? ?? ?? ?? 8B 55 FC 89 42 3C 8D 4D F4 E8 ?? ?? ?? ?? 8B 45 FC 8B 40 3C 8B E5 5D C3 }
	condition:
		$1
}

rule file_127_7_0 {
	meta:
		name = "__ecvt"
		size = 114
		refs = "0009 ?try_get_ptd_buffer@@YAPADXZ 0057 __ecvt_s"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 E8 ?? ?? ?? ?? 89 45 FC 83 7D FC 00 75 04 33 C0 EB 54 81 7D 10 5B 01 00 00 7D 08 8B 45 10 89 45 F8 EB 07 C7 45 F8 5B 01 00 00 8B 4D F8 89 4D F4 8B 55 18 52 8B 45 14 50 8B 4D F4 51 83 EC 08 DD 45 08 DD 1C 24 68 5D 01 00 00 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 1C 89 45 F0 83 7D F0 00 74 04 33 C0 EB 03 8B 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_127_8_0 {
	meta:
		name = "__ecvt_s"
		size = 918
		refs = "000c ___security_cookie 0047 ??_C@_1CE@MCCHPLBM@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 004c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0058 ??_C@_1GA@BEKLNMA@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 005f __CrtDbgReportW 0076 __errno 008d ??_C@_1BA@FFFKJLKN@?$AA_?$AAe?$AAc?$AAv?$AAt?$AA_?$AAs?$AA?$AA@ 0097 __invalid_parameter 00da ??_C@_1CC@ONIJBMJF@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 0157 __CrtGetDebugFillThreshold 019d _memset 01d6 ??_C@_1DC@GEMMMEGD@?$AAd?$AAe?$AAc?$AAi?$AAm?$AAa?$AAl?$AA_?$AAp?$AAo?$AAi?$AAn?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0269 ??_C@_1CA@OCEPHBPD@?$AAs?$AAi?$AAg?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 02ff ___acrt_fltout 0322 ?internal_to_string@@YAHQADIQAU_strflt@@HQAH2@Z 038e @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC A4 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 08 00 74 0C C7 85 94 FE FF FF 01 00 00 00 EB 0A C7 85 94 FE FF FF 00 00 00 00 8B 85 94 FE FF FF 89 85 90 FE FF FF 83 BD 90 FE FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AB 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 90 FE FF FF 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 AB 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 E0 02 00 00 83 7D 0C 00 76 0C C7 85 8C FE FF FF 01 00 00 00 EB 0A C7 85 8C FE FF FF 00 00 00 00 8B 95 8C FE FF FF 89 95 88 FE FF FF 83 BD 88 FE FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AC 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 88 FE FF FF 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 AC 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 4D 02 00 00 8B 4D 08 C6 01 00 83 7D 0C FF 74 5D 81 7D 0C FF FF FF 7F 74 54 83 7D 0C 01 76 4E E8 ?? ?? ?? ?? 89 85 84 FE FF FF 8B 55 0C 83 EA 01 39 95 84 FE FF FF 73 0E 8B 85 84 FE FF FF 89 85 80 FE FF FF EB 0C 8B 4D 0C 83 E9 01 89 8D 80 FE FF FF 8B 95 80 FE FF FF 52 68 FE 00 00 00 8B 45 08 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 1C 00 74 0C C7 85 7C FE FF FF 01 00 00 00 EB 0A C7 85 7C FE FF FF 00 00 00 00 8B 8D 7C FE FF FF 89 8D 78 FE FF FF 83 BD 78 FE FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AE 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 78 FE FF FF 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 AE 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 51 01 00 00 83 7D 20 00 74 0C C7 85 74 FE FF FF 01 00 00 00 EB 0A C7 85 74 FE FF FF 00 00 00 00 8B 85 74 FE FF FF 89 85 70 FE FF FF 83 BD 70 FE FF FF 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 AF 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 70 FE FF FF 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 AF 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 BE 00 00 00 33 D2 89 95 5C FE FF FF 89 95 60 FE FF FF 89 95 64 FE FF FF 68 5E 01 00 00 8D 85 9C FE FF FF 50 8D 8D 5C FE FF FF 51 68 5E 01 00 00 8B 55 14 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D 20 51 8B 55 1C 52 8B 45 18 50 8D 8D 5C FE FF FF 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 89 85 68 FE FF FF 8B 4D 0C 83 E9 02 39 4D 18 7D 0B 8B 55 18 89 95 6C FE FF FF EB 0C 8B 45 0C 83 E8 02 89 85 6C FE FF FF 8B 8D 6C FE FF FF 89 8D 98 FE FF FF 83 BD 98 FE FF FF 00 7C 1C 8B 55 08 03 95 98 FE FF FF 0F BE 02 85 C0 74 0C 8B 4D 08 03 8D 98 FE FF FF C6 01 00 8B 85 68 FE FF FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_127_9_0 {
	meta:
		name = "__fcvt"
		size = 247
		refs = "000c ___security_cookie 0016 ?try_get_ptd_buffer@@YAPADXZ 0065 ___acrt_fltout 00c9 __fcvt_s 00ef @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 80 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC E8 ?? ?? ?? ?? 89 85 98 FE FF FF 83 BD 98 FE FF FF 00 75 07 33 C0 E9 B9 00 00 00 33 C0 89 85 80 FE FF FF 89 85 84 FE FF FF 89 85 88 FE FF FF 68 5E 01 00 00 8D 8D 9C FE FF FF 51 8D 95 80 FE FF FF 52 68 5E 01 00 00 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 BA 5B 01 00 00 2B 95 84 FE FF FF 39 55 10 7D 0B 8B 45 10 89 85 94 FE FF FF EB 11 B9 5B 01 00 00 2B 8D 84 FE FF FF 89 8D 94 FE FF FF 8B 95 94 FE FF FF 89 95 90 FE FF FF 8B 45 18 50 8B 4D 14 51 8B 95 90 FE FF FF 52 83 EC 08 DD 45 08 DD 1C 24 68 5D 01 00 00 8B 85 98 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 1C 89 85 8C FE FF FF 83 BD 8C FE FF FF 00 74 04 33 C0 EB 06 8B 85 98 FE FF FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_127_10_0 {
	meta:
		name = "__fcvt_s"
		size = 918
		refs = "000c ___security_cookie 0047 ??_C@_1CE@MCCHPLBM@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 004c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0055 ??_C@_1GA@BEKLNMA@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAc@ 005c __CrtDbgReportW 0073 __errno 0087 ??_C@_1BA@CJDLLOHG@?$AA_?$AAf?$AAc?$AAv?$AAt?$AA_?$AAs?$AA?$AA@ 0091 __invalid_parameter 00d4 ??_C@_1CC@ONIJBMJF@?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 014b __CrtGetDebugFillThreshold 0191 _memset 01ca ??_C@_1DC@GEMMMEGD@?$AAd?$AAe?$AAc?$AAi?$AAm?$AAa?$AAl?$AA_?$AAp?$AAo?$AAi?$AAn?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0257 ??_C@_1CA@OCEPHBPD@?$AAs?$AAi?$AAg?$AAn?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 02e7 ___acrt_fltout 0381 ?internal_to_string@@YAHQADIQAU_strflt@@HQAH2@Z 038e @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC A8 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 08 00 74 0C C7 85 94 FE FF FF 01 00 00 00 EB 0A C7 85 94 FE FF FF 00 00 00 00 8B 85 94 FE FF FF 89 85 90 FE FF FF 83 BD 90 FE FF FF 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 90 FE FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 E6 02 00 00 83 7D 0C 00 76 0C C7 85 8C FE FF FF 01 00 00 00 EB 0A C7 85 8C FE FF FF 00 00 00 00 8B 95 8C FE FF FF 89 95 88 FE FF FF 83 BD 88 FE FF FF 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 58 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 88 FE FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 58 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 59 02 00 00 8B 4D 08 C6 01 00 83 7D 0C FF 74 5D 81 7D 0C FF FF FF 7F 74 54 83 7D 0C 01 76 4E E8 ?? ?? ?? ?? 89 85 84 FE FF FF 8B 55 0C 83 EA 01 39 95 84 FE FF FF 73 0E 8B 85 84 FE FF FF 89 85 80 FE FF FF EB 0C 8B 4D 0C 83 E9 01 89 8D 80 FE FF FF 8B 95 80 FE FF FF 52 68 FE 00 00 00 8B 45 08 83 C0 01 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 1C 00 74 0C C7 85 7C FE FF FF 01 00 00 00 EB 0A C7 85 7C FE FF FF 00 00 00 00 8B 8D 7C FE FF FF 89 8D 78 FE FF FF 83 BD 78 FE FF FF 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 5A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 78 FE FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 63 01 00 00 83 7D 20 00 74 0C C7 85 74 FE FF FF 01 00 00 00 EB 0A C7 85 74 FE FF FF 00 00 00 00 8B 85 74 FE FF FF 89 85 70 FE FF FF 83 BD 70 FE FF FF 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 5B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 BD 70 FE FF FF 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 5B 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 D6 00 00 00 33 D2 89 95 5C FE FF FF 89 95 60 FE FF FF 89 95 64 FE FF FF 68 5E 01 00 00 8D 85 9C FE FF FF 50 8D 8D 5C FE FF FF 51 68 5E 01 00 00 8B 55 14 52 8B 45 10 50 E8 ?? ?? ?? ?? 83 C4 18 8B 8D 60 FE FF FF 03 4D 18 89 8D 6C FE FF FF 83 7D 18 00 7E 1D 83 BD 60 FE FF FF 00 7E 14 8B 95 6C FE FF FF 3B 55 18 7D 09 C6 85 9B FE FF FF 01 EB 07 C6 85 9B FE FF FF 00 8A 85 9B FE FF FF 88 85 9A FE FF FF 0F B6 8D 9A FE FF FF 85 C9 74 0C C7 85 68 FE FF FF FF FF FF 7F EB 0C 8B 95 6C FE FF FF 89 95 68 FE FF FF 8B 85 68 FE FF FF 89 85 58 FE FF FF 8B 4D 20 51 8B 55 1C 52 8B 85 58 FE FF FF 50 8D 8D 5C FE FF FF 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_129_3_0 {
	meta:
		name = "___acrt_update_locale_info"
		size = 53
		refs = "0006 ___acrt_current_locale_data 000b ?value@?$dual_state_global@PAU__crt_locale_data@@@__crt_state_management@@QAEAAPAU__crt_locale_data@@XZ 0023 ___globallocalestatus 002a ___acrt_update_thread_locale_data"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D 0C 8B 11 3B 10 74 1B 8B 45 08 8B 88 50 03 00 00 23 0D ?? ?? ?? ?? 75 0A E8 ?? ?? ?? ?? 8B 55 0C 89 02 5D C3 }
	condition:
		$1
}

rule file_129_4_0 {
	meta:
		name = "___acrt_update_multibyte_info"
		size = 53
		refs = "0006 ___acrt_current_multibyte_data 000b ?value@?$dual_state_global@PAU__crt_multibyte_data@@@__crt_state_management@@QAEAAPAU__crt_multibyte_data@@XZ 0023 ___globallocalestatus 002a ___acrt_update_thread_multibyte_data"
	strings:
		$1 = { 8B FF 55 8B EC B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D 0C 8B 11 3B 10 74 1B 8B 45 08 8B 88 50 03 00 00 23 0D ?? ?? ?? ?? 75 0A E8 ?? ?? ?? ?? 8B 55 0C 89 02 5D C3 }
	condition:
		$1
}

rule file_130_5_0 {
	meta:
		name = "__mbsnlen_l"
		size = 126
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0025 _strnlen"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 5D F8 33 C9 39 4B 08 75 11 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 8B C8 EB 38 56 57 8B 7D 0C 8B D1 85 FF 74 29 8B 75 08 8A 06 84 C0 74 1C 0F B6 C0 F6 44 18 19 04 74 0B 42 3B D7 73 11 46 80 3E 00 74 07 41 46 42 3B D7 72 DE 3B D7 72 02 8B CF 5F 5E 80 7D FC 00 5B 74 0A 8B 45 F0 83 A0 50 03 00 00 FD 8B C1 8B E5 5D C3 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "__cputs"
		size = 193
		refs = "0003 __sehtable$__cputs 0008 __SEH_prolog4 001d ??_C@_1CE@BLLJFLOH@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0022 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002a ??_C@_1GG@BKBKDADK@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0031 __CrtDbgReportW 0043 ___doserrno 004a __errno 005d ??_C@_1O@PLNHBNGC@?$AA_?$AAc?$AAp?$AAu?$AAt?$AAs?$AA?$AA@ 0067 __invalid_parameter 0076 ___acrt_lock 008f __putch_nolock 00ad __SEH_epilog4 00bb ___acrt_unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 8B 7D 08 85 FF 0F 95 C3 33 F6 85 DB 75 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 6A 16 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 85 DB 75 31 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 6A 16 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 39 6A 09 E8 ?? ?? ?? ?? 59 89 75 E4 89 75 FC 89 7D E0 8A 07 84 C0 74 14 0F BE C0 50 E8 ?? ?? ?? ?? 59 83 F8 FF 75 19 0B F0 89 75 E4 C7 45 FC FE FF FF FF E8 0E 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 47 EB CC 8B 75 E4 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_132_9_0 {
	meta:
		name = "__fclose_nolock"
		size = 318
		refs = "0010 ??0__crt_stdio_stream@@QAE@QAU_iobuf@@@Z 0018 ?valid@__crt_stdio_stream@@QBE_NXZ 0040 ??_C@_1BO@MHPFFFJJ@?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?4?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?$CI?$AA?$CJ?$AA?$AA@ 0045 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004e ??_C@_1GA@DKNOMDCL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0055 __CrtDbgReportW 0069 __errno 007d ??_C@_1BO@JINCABEC@?$AA_?$AAf?$AAc?$AAl?$AAo?$AAs?$AAe?$AA_?$AAn?$AAo?$AAl?$AAo?$AAc?$AAk?$AA?$AA@ 0087 __invalid_parameter 00a1 ?is_in_use@__crt_stdio_stream@@QBE_NXZ 00b0 ?public_stream@__crt_stdio_stream@@QBEPAU_iobuf@@XZ 00b6 ___acrt_stdio_flush_nolock 00ca ___acrt_stdio_free_buffer_nolock 00db __fileno 00e4 __close 00fc ??C__crt_stdio_stream@@QBEPAU__crt_stdio_stream_data@@XZ 0115 __free_dbg 0130 ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 8B 45 08 50 8D 4D FC E8 ?? ?? ?? ?? 8D 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 55 F4 89 55 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 34 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 2E E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 34 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A4 00 00 00 C7 45 F8 FF FF FF FF 8D 4D FC E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 7F 8D 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 F8 8D 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8D 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 7D 09 C7 45 F8 FF FF FF FF EB 33 8D 4D FC E8 ?? ?? ?? ?? 83 78 1C 00 74 25 6A 02 8D 4D FC E8 ?? ?? ?? ?? 8B 50 1C 52 E8 ?? ?? ?? ?? 83 C4 08 8D 4D FC E8 ?? ?? ?? ?? C7 40 1C 00 00 00 00 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_132_10_0 {
	meta:
		name = "_fclose"
		size = 325
		refs = "0008 __sehtable$_fclose 000d __except_handler4 001f ___security_cookie 003a ??0__crt_stdio_stream@@QAE@QAU_iobuf@@@Z 0042 ?valid@__crt_stdio_stream@@QBE_NXZ 006a ??_C@_1BO@MHPFFFJJ@?$AAs?$AAt?$AAr?$AAe?$AAa?$AAm?$AA?4?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?$CI?$AA?$CJ?$AA?$AA@ 006f ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0078 ??_C@_1GA@DKNOMDCL@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 007f __CrtDbgReportW 0093 __errno 00a7 ??_C@_1O@EGMJNCOI@?$AAf?$AAc?$AAl?$AAo?$AAs?$AAe?$AA?$AA@ 00b1 __invalid_parameter 00c1 ?is_string_backed@__crt_stdio_stream@@QBE_NXZ 00d1 ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z 00e8 ?public_stream@__crt_stdio_stream@@QBEPAU_iobuf@@XZ 00ee __lock_file 0106 __fclose_nolock 0128 __unlock_file"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 E8 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 8B 45 08 50 8D 4D E4 E8 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 09 C7 45 E0 01 00 00 00 EB 07 C7 45 E0 00 00 00 00 8B 55 E0 89 55 DC 83 7D DC 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 14 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D DC 00 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 14 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 76 8D 4D E4 E8 ?? ?? ?? ?? 0F B6 C8 85 C9 74 11 8B 55 E4 52 E8 ?? ?? ?? ?? 83 C4 04 83 C8 FF EB 56 C7 45 D8 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 89 45 D8 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 12 8D 4D E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 D8 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_133_0_0 {
	meta:
		name = "__libm_sse2_pow_precise"
		size = 2896
		refs = "0040 SIGMASK 0048 ONEMASK 0079 ___acrt_pow_rcp_t1 008d ___acrt_pow_log2_t1 00c8 HALFSIG 00f4 ___acrt_pow_rcp_t2 0108 ___acrt_pow_log2_t2 013a LHN 0150 ___acrt_pow_rcp_t3 0162 ___acrt_pow_log2_t3 024b ___acrt_pow_clv 02a6 Shifter 02ca ___acrt_pow_exp2_tbl 02d2 cev 0381 ABSVALMASK 043d NEG_ZERO 0656 NEG_INF 06de sNaN 06e6 QIND 07b4 INF 0844 ___libm_error_support 0a65 EMIN 0a92 NEG_BIG 0a9a POS_BIG 0b37 __pow_default"
	strings:
		$1 = { 83 EC 10 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 0F 85 0F 0B 00 00 D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 0F 85 FA 0A 00 00 66 0F 13 04 24 66 0F 13 4C 24 08 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 54 F8 F2 0F 10 E0 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 66 0F C5 CC 03 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA EF 7F 00 00 2B D1 83 E9 10 0B CA 81 F9 00 00 00 80 0F 83 CE 02 00 00 B9 00 00 00 00 BA 7F FE 03 00 66 0F 6E CA 66 0F FB C1 66 0F 73 D0 08 F3 0F E6 C0 66 0F 12 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 26 66 0F C5 C7 00 66 0F 54 25 ?? ?? ?? ?? 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 1C 85 ?? ?? ?? ?? F2 0F 59 2C 85 ?? ?? ?? ?? 03 C0 66 0F 58 34 85 ?? ?? ?? ?? 66 0F 56 25 ?? ?? ?? ?? F2 0F 58 F0 66 0F 54 CC F2 0F 10 D3 66 0F 73 D3 1F 66 0F C5 C3 00 66 0F 12 05 ?? ?? ?? ?? F2 0F 5C E1 66 0F 12 3D ?? ?? ?? ?? 25 FF 01 00 00 83 C0 01 25 FE 03 00 00 F2 0F 59 2C 85 ?? ?? ?? ?? F2 0F 59 14 85 ?? ?? ?? ?? 66 0F 58 34 C5 ?? ?? ?? ?? 66 0F 54 C5 F2 0F 5C E8 F2 0F 58 FA F2 0F 10 D8 F2 0F 59 C1 F2 0F 59 CD F2 0F 59 DC F2 0F 5C D0 F2 0F 59 E5 F2 0F 10 C6 F2 0F 5C D1 F2 0F 58 F7 66 0F 12 4C 24 08 66 0F C5 C1 03 F2 0F 5C D3 F2 0F 5C C6 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 D6 03 F2 0F 5C D4 F2 0F 10 E6 F2 0F 58 C7 F2 0F 5C FA F2 0F 5C F2 66 0F 14 FF 25 F0 7F 00 00 3D F0 7F 00 00 0F 83 1A 05 00 00 81 E2 F0 7F 00 00 2D F0 3F 00 00 03 C2 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 AF 08 00 00 F2 0F 5C E6 F2 0F 5C D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 54 D9 66 0F 54 E6 F2 0F 5C C2 66 0F 57 D2 BA 60 40 00 00 66 0F C4 D2 03 F2 0F 10 EB F2 0F 59 DC F2 0F 5C F4 F2 0F 5C CD F2 0F 59 DA F2 0F 59 EE 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 E1 F2 0F 2D C3 F2 0F 59 F1 66 0F 28 0D ?? ?? ?? ?? F2 0F 58 EC 66 0F 70 E6 EE F2 0F 58 EE BA 7F FF 01 00 2B D0 05 FF E1 01 00 0B D0 2D FF E1 01 00 83 FA 00 0F 8E C6 05 00 00 03 C8 83 E0 7F 83 E1 80 81 C1 80 FF 01 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 66 0F 57 FF BA 80 3F 00 00 F2 0F 58 D1 66 0F C4 FA 03 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 54 24 08 F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 F2 0F 58 C5 F2 0F 58 C6 F2 0F 58 C4 F2 0F 58 C3 83 C4 10 C3 66 0F 12 4C 24 08 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C8 F2 0F 10 D1 66 0F 54 CB 66 0F 73 D1 20 66 0F 7E C9 81 F9 00 00 F0 7F 0F 83 D8 00 00 00 0B C1 83 F8 00 0F 84 1A 04 00 00 83 FA 00 0F 8D 00 01 00 00 F7 DA 81 C2 EF 7F 00 00 66 0F 73 F3 34 66 0F 56 D3 B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D1 14 66 0F FA CB 66 0F EF DB 66 0F EE CB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 8B CA 81 E2 FF 7F 00 00 81 FA F0 7F 00 00 0F 83 A2 01 00 00 25 FF 00 00 00 3D FF 00 00 00 0F 85 9D 02 00 00 66 0F 12 4C 24 08 66 0F 28 D1 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 B9 01 FF 03 00 03 C8 81 E1 00 00 04 00 83 FA 10 72 5B BA 7F FE 0B 00 66 0F 12 1D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? E9 35 FC FF FF 66 0F 12 3C 24 66 0F 28 E7 66 0F 7E FA 66 0F 73 D7 20 66 0F 7E F8 8B C8 25 FF FF FF 7F 3D 00 00 F0 7F 0F 82 8F 02 00 00 0F 87 F4 01 00 00 83 FA 00 0F 87 EB 01 00 00 E9 7B 02 00 00 B9 00 00 00 00 66 0F 57 C0 B8 F0 43 00 00 66 0F C4 C0 03 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? F2 0F 59 C4 66 0F 7E E2 66 0F 73 D4 20 66 0F 7E E0 83 FA 00 74 52 66 0F 54 F8 F2 0F 10 E0 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 2C 66 0F C5 C0 00 66 0F 56 FA 25 FF 00 00 00 83 C0 01 25 FE 01 00 00 F2 0F 59 3C 85 ?? ?? ?? ?? 66 0F 12 2C 85 ?? ?? ?? ?? 03 C0 66 0F 28 34 85 ?? ?? ?? ?? BA 7F 3E 04 00 E9 6E FB FF FF 8B D0 81 E2 FF FF FF 7F 83 FA 00 75 A1 8B 54 24 0C 81 E2 00 00 00 80 83 FA 00 74 30 C1 E1 0D 23 C1 BA 00 00 F0 7F 0B D0 66 0F 6E C2 66 0F 73 F0 20 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 14 24 F2 0F 5E CA BA 1B 00 00 00 E9 8F 02 00 00 C1 E1 0D 23 C1 83 F8 00 0F 85 A7 00 00 00 66 0F 57 C0 83 C4 10 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DC 66 0F 76 CB 66 0F D7 C9 81 E1 FF 00 00 00 81 F9 FF 00 00 00 0F 85 CF 00 00 00 66 0F C5 CC 03 81 E1 00 80 00 00 83 F9 00 0F 84 9A 00 00 00 25 FF 00 00 00 3D FF 00 00 00 75 6D 66 0F 12 4C 24 08 66 0F 28 D1 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 0D ?? ?? ?? ?? 66 0F 73 D1 34 66 0F FA CB 66 0F EF DB 66 0F F3 D1 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 2D 66 0F 12 4C 24 08 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 0C 66 0F 12 05 ?? ?? ?? ?? 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? 83 C4 10 C3 66 0F 12 4C 24 08 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 39 01 00 00 66 0F 57 C0 83 C4 10 C3 66 0F 12 4C 24 08 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 18 01 00 00 66 0F 57 C0 83 C4 10 C3 F2 0F 58 E4 F2 0F 10 C4 BA EE 03 00 00 E9 6E 01 00 00 66 0F 12 14 24 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D2 81 E2 FF FF FF 7F 0B C2 B9 00 00 00 00 83 F8 00 0F 84 6B FE FF FF 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C9 BA 1C 00 00 00 E9 28 01 00 00 66 0F 12 24 24 66 0F 12 54 24 08 66 0F 7E E0 83 F8 00 75 29 66 0F 73 D4 20 66 0F 7E E2 81 FA 00 00 F0 3F 0F 84 F3 00 00 00 81 FA 00 00 F0 BF 75 0C 66 0F 12 05 ?? ?? ?? ?? 83 C4 10 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 C9 66 0F 54 DA 66 0F 76 CB 66 0F D7 C1 25 FF 00 00 00 3D FF 00 00 00 75 63 66 0F C5 C2 03 66 0F 12 24 24 25 00 80 00 00 81 F1 00 00 F0 BF 0B D1 83 FA 00 0F 84 9B 00 00 00 83 F8 00 74 19 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 72 21 66 0F 57 C0 83 C4 10 C3 66 0F C5 C4 03 25 F0 7F 00 00 3D F0 3F 00 00 73 08 66 0F 57 C0 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? 83 C4 10 C3 F2 0F 58 D2 F2 0F 10 C2 BA EE 03 00 00 EB 55 66 0F 7E E0 66 0F 73 D4 20 66 0F 7E E2 81 E2 FF FF FF 7F 8B C8 0B C2 66 0F 12 05 ?? ?? ?? ?? BA 1A 00 00 00 83 F8 00 74 2C 66 0F 7E E0 BA 1D 00 00 00 25 FF FF FF 7F 3D 00 00 F0 7F 77 17 72 05 83 F9 00 77 10 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? 83 C4 10 C3 83 EC 18 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 10 89 54 24 04 83 EA 08 89 14 24 E8 ?? ?? ?? ?? 66 0F 12 44 24 10 83 C4 28 C3 83 F8 00 7E 28 3D 00 00 04 00 0F 83 22 02 00 00 56 8B D0 83 E0 7F 81 C1 00 FF 03 00 81 EA 80 00 00 00 83 E2 80 57 BF F0 3F 00 00 EB 26 3D 00 02 FC FF 0F 8E D7 01 00 00 56 8B D0 83 E0 7F 81 C1 80 00 00 00 83 E2 80 81 C2 80 FE 03 00 57 BF 00 00 00 00 F2 0F 58 E0 F2 0F 10 C3 F2 0F 58 1D ?? ?? ?? ?? 8B F2 81 EE 80 FF 01 00 66 0F 59 D7 F2 0F 5C 1D ?? ?? ?? ?? 66 0F 59 FF F2 0F 5C C3 03 C0 03 C0 03 C0 03 C0 66 0F 28 98 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 CF 66 0F 58 D1 66 0F 70 CA EE F2 0F 59 D7 F2 0F 58 D1 F2 0F 58 D4 66 0F 12 25 ?? ?? ?? ?? 66 0F 6E CA 81 EA 80 FF 01 00 F7 DA C1 FA 07 83 C2 02 8B C2 83 E0 20 03 D0 66 0F 57 FF B8 80 3F 00 00 66 0F C4 F8 03 F2 0F 59 54 24 10 F2 0F 59 C7 66 0F 73 F1 2D 66 0F 70 C9 44 66 0F 28 3D ?? ?? ?? ?? F2 0F 58 EA 66 0F 59 D9 F2 0F 58 C5 66 0F 14 C0 66 0F 59 F0 F2 0F 59 E0 66 0F 59 C0 66 0F 58 FE 66 0F 59 F8 F2 0F 59 C3 66 0F 70 F7 EE F2 0F 59 C7 66 0F 70 EB EE F2 0F 59 F3 F2 0F 59 E3 66 0F 6E F9 66 0F 73 F7 2D 66 0F 6E D2 66 0F 76 C9 66 0F F3 CA F2 0F 58 C5 F2 0F 58 C6 66 0F 54 CB F2 0F 58 C4 66 0F 57 F6 66 0F 76 E4 66 0F F3 E2 F2 0F 5C D9 F2 0F 10 D1 F2 0F 58 C8 66 0F 54 CC 66 0F C4 F7 03 5F F2 0F 5C D1 F2 0F 58 C2 F2 0F 58 C3 83 FE 00 7F 41 5E F2 0F 59 C7 F2 0F 59 CF F2 0F 58 C1 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 0E FE FF FF BA 19 00 00 00 83 F8 00 0F 84 00 FE FF FF 83 C4 10 C3 5E F2 0F 58 C1 F2 0F 59 C7 F2 0F 59 F0 F2 0F 58 C6 66 0F C5 C0 03 25 F0 7F 00 00 BA 18 00 00 00 3D F0 7F 00 00 0F 84 D1 FD FF FF BA 19 00 00 00 83 F8 00 0F 84 C3 FD FF FF 83 C4 10 C3 66 0F 12 05 ?? ?? ?? ?? 66 0F 6E C9 F2 0F 59 C0 66 0F 73 F1 2D 66 0F 56 C1 BA 19 00 00 00 E9 9C FD FF FF BA 18 00 00 00 83 F9 00 74 15 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 05 ?? ?? ?? ?? E9 7D FD FF FF 66 0F 12 05 ?? ?? ?? ?? F2 0F 59 C0 E9 6C FD FF FF 66 0F 70 E1 44 66 0F 59 E6 66 0F C5 C4 03 25 F0 7F 00 00 BA A0 40 00 00 2B D0 2D 70 3C 00 00 0B D0 81 FA 00 00 00 80 0F 82 24 F7 FF FF 3D 00 00 00 80 72 13 81 C9 80 FF 01 00 66 0F 6E C1 66 0F 73 F0 2D 83 C4 10 C3 66 0F 12 24 24 66 0F C5 D4 03 81 E2 F0 7F 00 00 81 EA F0 3F 00 00 66 0F C5 C1 03 33 C2 25 00 80 00 00 83 F8 00 0F 85 3B FF FF FF E9 59 FF FF FF 66 0F D6 04 24 66 0F D6 4C 24 08 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 83 C4 10 C3 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_134_9_0 {
	meta:
		name = "___acrt_GetStringTypeA"
		size = 426
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0026 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0064 __imp__MultiByteToWideChar@24 007c ??1_LocaleUpdate@@QAE@XZ 008f __MallocaComputeSize 00a2 ??_C@_0DJ@HCPJODDK@minkernel?2crts?2ucrt?2src?2appcrt?2l@ 00b8 __malloc_dbg 00c1 __MarkAllocaS 00dc ??0?$__crt_scoped_stack_ptr_tag@_W@@QAE@QA_W@Z 00e7 ??0?$__crt_scoped_stack_ptr@_W@@QAE@U?$__crt_scoped_stack_ptr_tag@_W@@@Z 00ef ?get@?$__crt_scoped_stack_ptr@_W@@QBEPA_WXZ 0102 ??1?$__crt_scoped_stack_ptr@_W@@QAE@XZ 0128 _memset 018c __imp__GetStringTypeW@16"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 40 8B 45 08 50 8D 4D C0 E8 ?? ?? ?? ?? 83 7D 1C 00 74 08 8B 4D 1C 89 4D F4 EB 10 8D 4D C0 E8 ?? ?? ?? ?? 8B 10 8B 42 08 89 45 F4 8B 4D F4 89 4D E8 83 7D 20 00 74 09 C7 45 F0 09 00 00 00 EB 07 C7 45 F0 01 00 00 00 6A 00 6A 00 8B 55 14 52 8B 45 10 50 8B 4D F0 51 8B 55 E8 52 FF 15 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 75 17 C7 45 E0 00 00 00 00 8D 4D C0 E8 ?? ?? ?? ?? 8B 45 E0 E9 1E 01 00 00 8B 45 F8 D1 E0 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 33 68 DD DD 00 00 6A 51 68 ?? ?? ?? ?? 6A 02 8B 4D F8 D1 E1 51 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 EC EB 07 C7 45 EC 00 00 00 00 8B 55 EC 52 8D 4D D0 E8 ?? ?? ?? ?? 8B 00 50 8D 4D FC E8 ?? ?? ?? ?? 8D 4D FC E8 ?? ?? ?? ?? 85 C0 75 1F C7 45 DC 00 00 00 00 8D 4D FC E8 ?? ?? ?? ?? 8D 4D C0 E8 ?? ?? ?? ?? 8B 45 DC E9 90 00 00 00 8B 4D F8 D1 E1 51 6A 00 8D 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 55 F8 52 8D 4D FC E8 ?? ?? ?? ?? 50 8B 45 14 50 8B 4D 10 51 6A 01 8B 55 E8 52 FF 15 ?? ?? ?? ?? 89 45 E4 83 7D E4 00 75 1C C7 45 D8 00 00 00 00 8D 4D FC E8 ?? ?? ?? ?? 8D 4D C0 E8 ?? ?? ?? ?? 8B 45 D8 EB 31 8B 45 18 50 8B 4D E4 51 8D 4D FC E8 ?? ?? ?? ?? 50 8B 55 0C 52 FF 15 ?? ?? ?? ?? 89 45 D4 8D 4D FC E8 ?? ?? ?? ?? 8D 4D C0 E8 ?? ?? ?? ?? 8B 45 D4 8B E5 5D C3 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "__controlfp_s"
		size = 229
		refs = "0030 __control87 005d ??_C@_1DG@JNDMIEJL@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAi?$AAn?$AAp?$AAu?$AAt?$AA?5?$AAv?$AAa?$AAl?$AAu?$AAe?$AA?$CC?$AA?0?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0062 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 006b ??_C@_1FO@HHLKCIKB@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 0072 __CrtDbgReportW 0086 __errno 009a ??_C@_1BK@CDOALEA@?$AA_?$AAc?$AAo?$AAn?$AAt?$AAr?$AAo?$AAl?$AAf?$AAp?$AA_?$AAs?$AA?$AA@ 00a4 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 8B 45 10 25 FF FF F7 FF 89 45 10 8B 4D 0C 23 4D 10 81 E1 E0 FC F0 FC 0F 84 8D 00 00 00 83 7D 08 00 74 11 6A 00 6A 00 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 89 02 33 C0 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 4D FC 89 4D F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 2A 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 2A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 2F 83 7D 08 00 74 17 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 8B 55 08 89 02 EB 10 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "___libm_sse2_cos"
		size = 417
		refs = "001b _PI32INV 0027 _SHIFTER 0037 _P_1 0043 _P_2 0060 _SC_4 0066 ___acrt_cos_sin_ctable 007b _P_3 00a0 _SC_2 00e5 _SC_3 00f1 _SC_1 0161 _ONE 0188 _cos 019c _NEG_ZERO"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 36 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 2D D1 F2 0F 58 CA F2 0F 10 1D ?? ?? ?? ?? F2 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 D9 66 0F 14 C9 81 C2 10 76 1C 00 F2 0F 10 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 05 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C E3 F2 0F 10 78 08 66 0F 14 C0 F2 0F 10 DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F2 0F 10 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 F2 0F 10 C3 F2 0F 58 58 08 66 0F 59 CF F2 0F 10 FC F2 0F 58 E3 66 0F 58 F5 F2 0F 10 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F2 0F 58 CE F2 0F 58 E1 66 0F 28 C4 C3 7F 1F 66 0F C5 C0 03 66 25 FF 7F 66 0F C4 C0 03 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C C8 66 0F 28 C1 C3 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 74 19 83 EC 08 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 83 C4 08 C3 F2 0F 59 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_137_0_0 {
	meta:
		name = "??$common_tcsset_s@_W@@YAHQA_WI_W@Z"
		size = 551
		refs = "0031 ??_C@_1GI@BBAEIKL@?$AA?$CI?$AA?$CI?$AAd?$AAe?$AAs?$AAt?$AAi?$AAn?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AAs?$AAi?$AAz@ 0036 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0042 ??_C@_1HI@PBJPCEBC@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0049 __CrtDbgReportW 005d __errno 0074 ??_C@_1CA@BBKNBNG@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAt?$AAc?$AAs?$AAs?$AAe?$AAt?$AA_?$AAs?$AA?$AA@ 007e __invalid_parameter 00ed __CrtGetDebugFillThreshold 0123 _memset 012b ??_C@_1DM@FHLMIEG@?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd?$AA?$AA@ 0154 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 28 83 7D 08 00 74 0F 83 7D 0C 00 76 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 F0 83 7D F0 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 1A 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 1A 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 E9 94 01 00 00 8B 55 08 89 55 F8 8B 45 0C 89 45 FC 8B 4D F8 0F B7 11 85 D2 74 20 8B 45 FC 83 E8 01 89 45 FC 74 15 8B 4D F8 66 8B 55 10 66 89 11 8B 45 F8 83 C0 02 89 45 F8 EB D6 83 7D FC 00 0F 85 E0 00 00 00 33 C9 8B 55 08 66 89 0A 83 7D 0C FF 74 4D 81 7D 0C FF FF FF 7F 74 44 83 7D 0C 01 76 3E E8 ?? ?? ?? ?? 89 45 EC 8B 45 0C 83 E8 01 39 45 EC 73 08 8B 4D EC 89 4D E8 EB 09 8B 55 0C 83 EA 01 89 55 E8 8B 45 E8 D1 E0 50 68 FE 00 00 00 8B 4D 08 83 C1 02 51 E8 ?? ?? ?? ?? 83 C4 0C BA ?? ?? ?? ?? 85 D2 74 0D 33 C0 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 4D E4 89 4D E0 83 7D E0 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 27 01 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 27 01 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 16 00 00 00 EB 74 83 7D 0C FF 74 6C 81 7D 0C FF FF FF 7F 74 63 8B 45 0C 2B 45 FC 83 C0 01 3B 45 0C 73 55 E8 ?? ?? ?? ?? 89 45 DC 8B 4D 0C 2B 4D FC 83 C1 01 8B 55 0C 2B D1 39 55 DC 73 08 8B 45 DC 89 45 D8 EB 11 8B 4D 0C 2B 4D FC 83 C1 01 8B 55 0C 2B D1 89 55 D8 8B 45 D8 D1 E0 50 68 FE 00 00 00 8B 4D 0C 2B 4D FC 8B 55 08 8D 44 4A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 8B E5 5D C3 }
	condition:
		$1
}

rule file_137_1_0 {
	meta:
		name = "__wcsset_s"
		size = 28
		refs = "0013 ??$common_tcsset_s@_W@@YAHQA_WI_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 0F B7 45 10 50 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 5D C3 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__mbsinc"
		size = 118
		refs = "0016 ??_C@_1CG@CMGPGAOD@?$AAc?$AAu?$AAr?$AAr?$AAe?$AAn?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 001b ??_C@_1GO@HFJOCENB@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0021 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002c __CrtDbgReportW 003a __errno 0044 ??_C@_1BA@GDAOKFNN@?$AA_?$AAm?$AAb?$AAs?$AAi?$AAn?$AAc?$AA?$AA@ 0050 __invalid_parameter 0061 __ismbblead"
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 56 8B 75 08 85 F6 0F 95 C0 85 C0 75 48 57 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 50 6A 3E 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 6A 3E 57 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5F EB 17 0F B6 06 50 E8 ?? ?? ?? ?? 46 59 85 C0 74 06 80 3E 00 74 01 46 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_138_1_0 {
	meta:
		name = "__mbsinc_l"
		size = 39
		refs = "0011 __ismbblead_l"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 FF 75 0C 0F B6 06 50 E8 ?? ?? ?? ?? 59 46 59 85 C0 74 06 80 3E 00 74 01 46 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_139_2_0 {
	meta:
		name = "??$common_searchenv_s@D@@YAHQBD0QADI@Z"
		size = 1295
		refs = "000c ___security_cookie 003f ??_C@_1DC@MGKAFPFD@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0044 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004b ??_C@_1GK@MKGKIFGH@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0056 __CrtDbgReportW 0064 __errno 0070 ??_C@_1CG@BFNCEPHH@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAs?$AAe?$AAa?$AAr?$AAc?$AAh?$AAe?$AAn?$AAv?$AA_?$AAs?$AA?$AA@ 007c __invalid_parameter 0096 ??_C@_1CC@HDOBDHHJ@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 00d7 ??_C@_1CK@LLOEFJJG@?$AAf?$AAi?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0131 __access_s 0155 __fullpath 01a3 ??$tdupenv_s_crt@PAPAD$$TABQBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TABQBD@Z 020c ??_C@_0DF@DKLMPIGA@minkernel?2crts?2ucrt?2src?2desktopc@ 0223 __calloc_dbg 0233 __free_dbg 02a4 ___acrt_getpath 0324 ??4?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z 03d6 _strcpy_s 046f ??_C@_1HG@MHOEBCGA@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?0?$AA?5@ 0488 ??_C@_1HO@KLEHDNFH@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA_?$AAi?$AAt?$AA?0?$AA?5?$AAp?$AAa?$AAt?$AAh?$AA_?$AAc@ 04ef @__security_check_cookie@4 0505 ??_C@_1IG@EBGIJLIJ@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAc?$AAr?$AAt?$AA?$CI?$AA?$CG?$AAp?$AAa?$AAt?$AAh?$AA_?$AAs?$AAt?$AAr?$AAi@ 050a __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 30 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 8B 4D 10 89 85 EC FE FF FF 33 C0 85 C9 89 8D E8 FE FF FF 53 56 8B 75 08 0F 95 C0 89 B5 D4 FE FF FF 57 85 C0 75 4C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 33 DB BE ?? ?? ?? ?? 53 6A 24 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 16 5F 53 6A 24 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 E9 5C 04 00 00 33 C0 3B 45 14 1B C0 F7 D8 75 3D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 33 DB BE ?? ?? ?? ?? 53 6A 25 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 16 5F 53 6A 25 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB A7 85 F6 75 42 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 33 DB BE ?? ?? ?? ?? 53 6A 29 56 6A 02 88 19 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 16 5F 53 6A 29 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 61 FF FF FF 80 3E 00 75 08 C6 01 00 E9 B5 03 00 00 E8 ?? ?? ?? ?? 33 DB 53 56 8B 38 E8 ?? ?? ?? ?? 59 59 8B F0 E8 ?? ?? ?? ?? 89 38 85 F6 75 31 FF 75 14 8B B5 E8 FE FF FF FF B5 D4 FE FF FF 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0E 88 1E E8 ?? ?? ?? ?? 8B 00 E9 78 03 00 00 33 C0 E9 71 03 00 00 8D 85 E4 FE FF FF 89 9D E4 FE FF FF 89 85 E0 FE FF FF 8D 85 EC FE FF FF 50 8D 85 D8 FE FF FF 89 9D D8 FE FF FF 50 8D 85 E0 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0E 83 F8 16 0F 85 1B 03 00 00 E9 3B 03 00 00 8B BD E4 FE FF FF 85 FF 0F 84 08 03 00 00 8B 8D D4 FE FF FF 8D 51 01 8A 01 41 84 C0 75 F9 2B CA C7 85 DC FE FF FF 08 01 00 00 8D B5 F4 FE FF FF 89 8D E0 FE FF FF 89 B5 F0 FE FF FF 3B 4D 14 72 58 8B D7 8D 72 01 8A 02 42 84 C0 75 F9 6A 5A 68 ?? ?? ?? ?? 2B D6 8D 41 02 6A 02 03 C2 6A 01 50 89 85 DC FE FF FF E8 ?? ?? ?? ?? 8B F0 6A 02 53 89 B5 F0 FE FF FF E8 ?? ?? ?? ?? 83 C4 1C 85 F6 75 17 8B 85 E8 FE FF FF 88 18 E8 ?? ?? ?? ?? 6A 0C 5B 89 18 E9 6F 02 00 00 8D 85 F4 FE FF FF 2B F0 F7 DE 1B F6 23 B5 F0 FE FF FF 89 B5 D8 FE FF FF E8 ?? ?? ?? ?? 8B 00 89 85 D0 FE FF FF 8B 8D E4 FE FF FF 89 8D EC FE FF FF 85 C9 0F 84 16 02 00 00 8B 85 DC FE FF FF 2B 85 E0 FE FF FF 48 50 FF B5 F0 FE FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 89 85 E4 FE FF FF 85 C0 0F 85 C4 00 00 00 8D 85 F4 FE FF FF 39 85 F0 FE FF FF 0F 85 C3 01 00 00 E8 ?? ?? ?? ?? 83 38 22 0F 85 96 00 00 00 8B 8D EC FE FF FF 8D 51 01 8A 01 41 84 C0 75 F9 8B 85 E0 FE FF FF 2B CA 6A 71 68 ?? ?? ?? ?? 83 C0 02 6A 02 03 C1 6A 01 50 89 85 DC FE FF FF E8 ?? ?? ?? ?? 83 C4 14 89 85 F0 FE FF FF 8D 85 F0 FE FF FF 8D 8D D8 FE FF FF 50 E8 ?? ?? ?? ?? 6A 02 FF B5 F0 FE FF FF E8 ?? ?? ?? ?? 8B B5 D8 FE FF FF 59 59 85 F6 0F 84 D9 00 00 00 8B 85 DC FE FF FF 2B 85 E0 FE FF FF 50 56 FF B5 EC FE FF FF 89 B5 F0 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 89 85 E4 FE FF FF EB 06 8B 85 E4 FE FF FF 85 C0 0F 84 11 01 00 00 8B 8D F0 FE FF FF 38 19 0F 84 03 01 00 00 8B D1 8D 42 01 89 85 EC FE FF FF 8A 02 42 84 C0 75 F9 2B 95 EC FE FF FF 03 CA 89 95 EC FE FF FF 8A 41 FF 3C 2F 74 13 3C 5C 74 0F 3C 3A 74 0B C6 01 5C 41 42 89 95 EC FE FF FF FF B5 D4 FE FF FF 8B 85 DC FE FF FF 2B C2 50 51 E8 ?? ?? ?? ?? 83 C4 0C 53 85 C0 0F 85 92 00 00 00 FF B5 F0 FE FF FF E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 7F FE FF FF 8B 85 E0 FE FF FF 40 03 85 EC FE FF FF 3B 45 14 76 28 8B 85 E8 FE FF FF 88 18 E8 ?? ?? ?? ?? 6A 22 EB 7F 8B 85 E8 FE FF FF 88 18 E8 ?? ?? ?? ?? 6A 0C 5B 89 18 E9 85 00 00 00 E8 ?? ?? ?? ?? FF B5 F0 FE FF FF 8B 8D D0 FE FF FF FF 75 14 89 08 8B 85 E8 FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 5C 53 68 A5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 91 00 00 00 68 95 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 7B 8B 85 E8 FE FF FF 88 18 E8 ?? ?? ?? ?? 6A 02 59 89 08 8B D9 EB 16 8B 85 E8 FE FF FF 88 18 E8 ?? ?? ?? ?? 6A 02 5B C7 00 02 00 00 00 6A 02 56 E8 ?? ?? ?? ?? 59 59 6A 02 57 E8 ?? ?? ?? ?? 59 59 8B C3 EB 14 8B 85 E8 FE FF FF 88 18 E8 ?? ?? ?? ?? 6A 02 59 89 08 8B C1 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 53 6A 45 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_139_3_0 {
	meta:
		name = "??$common_searchenv_s@_W@@YAHQB_W0QA_WI@Z"
		size = 1371
		refs = "000c ___security_cookie 003f ??_C@_1DC@MGKAFPFD@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0044 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 004b ??_C@_1GK@MKGKIFGH@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0056 __CrtDbgReportW 0064 __errno 0070 ??_C@_1CG@BFNCEPHH@?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA_?$AAs?$AAe?$AAa?$AAr?$AAc?$AAh?$AAe?$AAn?$AAv?$AA_?$AAs?$AA?$AA@ 007c __invalid_parameter 0096 ??_C@_1CC@HDOBDHHJ@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 00d9 ??_C@_1CK@LLOEFJJG@?$AAf?$AAi?$AAl?$AAe?$AA_?$AAn?$AAa?$AAm?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0134 __waccess_s 0158 __wfullpath 01a7 ??$tdupenv_s_crt@PAPA_W$$TABQB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TABQB_W@Z 021a ??_C@_0DF@DKLMPIGA@minkernel?2crts?2ucrt?2src?2desktopc@ 0233 __calloc_dbg 0243 __free_dbg 02c1 ___acrt_wgetpath 0347 ??4?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z 040d _wcscpy_s 04af ??_C@_1HG@MHOEBCGA@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA_?$AAb?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?0?$AA?5@ 04c8 ??_C@_1HO@KLEHDNFH@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAc?$AAs?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAp?$AAa?$AAt?$AAh?$AA_?$AAi?$AAt?$AA?0?$AA?5?$AAp?$AAa?$AAt?$AAh?$AA_?$AAc@ 053b @__security_check_cookie@4 0551 ??_C@_1IG@EBGIJLIJ@?$AAt?$AAr?$AAa?$AAi?$AAt?$AAs?$AA?3?$AA?3?$AAt?$AAd?$AAu?$AAp?$AAe?$AAn?$AAv?$AA_?$AAs?$AA_?$AAc?$AAr?$AAt?$AA?$CI?$AA?$CG?$AAp?$AAa?$AAt?$AAh?$AA_?$AAs?$AAt?$AAr?$AAi@ 0556 __invoke_watson"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 3C 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 8B 4D 10 89 85 E4 FD FF FF 33 C0 85 C9 89 8D E0 FD FF FF 53 56 8B 75 08 0F 95 C0 89 B5 CC FD FF FF 57 85 C0 75 4C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 33 DB BE ?? ?? ?? ?? 53 6A 24 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 16 5F 53 6A 24 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 E9 A8 04 00 00 33 C0 3B 45 14 1B C0 F7 D8 75 3D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 33 DB BE ?? ?? ?? ?? 53 6A 25 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 16 5F 53 6A 25 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB A7 33 DB 85 F6 75 43 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 6A 29 BE ?? ?? ?? ?? 33 C0 56 6A 02 66 89 01 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 16 5F 53 6A 29 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 5E FF FF FF 66 39 1E 75 0A 33 C0 66 89 01 E9 FC 03 00 00 E8 ?? ?? ?? ?? 53 56 8B 38 E8 ?? ?? ?? ?? 59 59 8B F0 E8 ?? ?? ?? ?? 89 38 85 F6 75 32 FF 75 14 8B 9D E0 FD FF FF FF B5 CC FD FF FF 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0F 66 89 03 E8 ?? ?? ?? ?? 8B 00 E9 C0 03 00 00 33 C0 E9 B9 03 00 00 8D 85 DC FD FF FF 89 9D DC FD FF FF 89 85 D8 FD FF FF 8D 85 E4 FD FF FF 50 8D 85 D0 FD FF FF 89 9D D0 FD FF FF 50 8D 85 D8 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0E 83 F8 16 0F 85 60 03 00 00 E9 83 03 00 00 8B BD DC FD FF FF 85 FF 0F 84 4D 03 00 00 8B 8D CC FD FF FF 8D 51 02 66 8B 01 83 C1 02 66 3B C3 75 F5 2B CA C7 85 D4 FD FF FF 08 01 00 00 D1 F9 8D B5 EC FD FF FF 89 8D D8 FD FF FF 89 B5 E8 FD FF FF 3B 4D 14 72 61 8B D7 8D 72 02 66 8B 02 83 C2 02 66 3B C3 75 F5 6A 5A 68 ?? ?? ?? ?? 2B D6 8D 41 02 D1 FA 6A 02 03 C2 6A 02 50 89 85 D4 FD FF FF E8 ?? ?? ?? ?? 8B F0 6A 02 53 89 B5 E8 FD FF FF E8 ?? ?? ?? ?? 83 C4 1C 85 F6 75 1A 8B 85 E0 FD FF FF 33 C9 66 89 08 E8 ?? ?? ?? ?? 6A 0C 5B 89 18 E9 A5 02 00 00 8D 85 EC FD FF FF 2B F0 F7 DE 1B F6 23 B5 E8 FD FF FF 89 B5 D0 FD FF FF E8 ?? ?? ?? ?? C7 85 C4 FD FF FF 5C 00 00 00 8B 00 89 85 C8 FD FF FF 8B 8D DC FD FF FF 89 8D E4 FD FF FF 85 C9 0F 84 3F 02 00 00 8B 85 D4 FD FF FF 2B 85 D8 FD FF FF 48 50 FF B5 E8 FD FF FF 51 E8 ?? ?? ?? ?? 83 C4 0C 89 85 DC FD FF FF 85 C0 0F 85 C9 00 00 00 8D 85 EC FD FF FF 39 85 E8 FD FF FF 0F 85 E9 01 00 00 E8 ?? ?? ?? ?? 83 38 22 0F 85 9B 00 00 00 8B 8D E4 FD FF FF 6A 02 5E 8D 51 02 66 8B 01 03 CE 66 3B C3 75 F6 8B 85 D8 FD FF FF 2B CA 6A 71 68 ?? ?? ?? ?? D1 F9 83 C0 02 56 03 C1 56 50 89 85 D4 FD FF FF E8 ?? ?? ?? ?? 83 C4 14 89 85 E8 FD FF FF 8D 85 E8 FD FF FF 8D 8D D0 FD FF FF 50 E8 ?? ?? ?? ?? 56 FF B5 E8 FD FF FF E8 ?? ?? ?? ?? 8B B5 D0 FD FF FF 59 59 85 F6 0F 84 F4 00 00 00 8B 85 D4 FD FF FF 2B 85 D8 FD FF FF 50 56 FF B5 E4 FD FF FF 89 B5 E8 FD FF FF E8 ?? ?? ?? ?? 83 C4 0C 89 85 DC FD FF FF EB 06 8B 85 DC FD FF FF 85 C0 0F 84 32 01 00 00 8B 8D E8 FD FF FF 66 39 19 0F 84 23 01 00 00 8B D1 8D 42 02 89 85 E4 FD FF FF 66 8B 02 83 C2 02 66 3B C3 75 F5 2B 95 E4 FD FF FF D1 FA 89 95 E4 FD FF FF 8D 0C 51 0F B7 41 FE 83 F8 2F 74 1E 66 3B 85 C4 FD FF FF 74 15 83 F8 3A 74 10 6A 5C 58 66 89 01 83 C1 02 42 89 95 E4 FD FF FF FF B5 CC FD FF FF 8B 85 D4 FD FF FF 2B C2 50 51 E8 ?? ?? ?? ?? 83 C4 0C 53 85 C0 0F 85 9B 00 00 00 FF B5 E8 FD FF FF E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 65 FE FF FF 8B 85 D8 FD FF FF 40 03 85 E4 FD FF FF 3B 45 14 76 31 8B 85 E0 FD FF FF 33 C9 66 89 08 E8 ?? ?? ?? ?? 6A 22 E9 88 00 00 00 8B 85 E0 FD FF FF 33 C9 66 89 08 E8 ?? ?? ?? ?? 6A 0C 5B 89 18 E9 8E 00 00 00 E8 ?? ?? ?? ?? FF B5 E8 FD FF FF 8B 8D C8 FD FF FF FF 75 14 89 08 8B 85 E0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 65 53 68 A5 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 9D 00 00 00 68 95 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 84 00 00 00 8B 85 E0 FD FF FF 33 C9 66 89 08 E8 ?? ?? ?? ?? 6A 02 59 89 08 8B D9 EB 19 8B 85 E0 FD FF FF 33 C9 66 89 08 E8 ?? ?? ?? ?? 6A 02 5B C7 00 02 00 00 00 6A 02 56 E8 ?? ?? ?? ?? 59 59 6A 02 57 E8 ?? ?? ?? ?? 59 59 8B C3 EB 17 8B 85 E0 FD FF FF 33 C9 66 89 08 E8 ?? ?? ?? ?? 6A 02 59 89 08 8B C1 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 53 6A 45 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_139_4_0 {
	meta:
		name = "??$taccess_s@AAPADH@?$__crt_char_traits@D@@SAHAAPAD$$QAH@Z"
		size = 24
		refs = "0010 __access_s"
		altNames = "??$taccess_s@AAPBDH@?$__crt_char_traits@D@@SAHAAPBD$$QAH@Z ??$taccess_s@ABQBDH@?$__crt_char_traits@D@@SAHABQBD$$QAH@Z ??$taccess_s@PADH@?$__crt_char_traits@D@@SAH$$QAPAD$$QAH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_491_20_2 {
	meta:
		name = "??$set_variable_in_environment_nolock@PADH@?$__crt_char_traits@D@@SAH$$QAPAD$$QAH@Z"
		size = 24
		refs = "0010 ___dcrt_set_variable_in_narrow_environment_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_625_11_0 {
	meta:
		name = "??$set_variable_in_environment_nolock@PA_WH@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAH@Z"
		size = 24
		refs = "0010 ___dcrt_set_variable_in_wide_environment_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_139_5_4 {
	meta:
		name = "??$taccess_s@AAPA_WH@?$__crt_char_traits@_W@@SAHAAPA_W$$QAH@Z"
		size = 24
		refs = "0010 __waccess_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_678_14_3 {
	meta:
		name = "??$taccess_s@AAPB_WH@?$__crt_char_traits@_W@@SAHAAPB_W$$QAH@Z"
		size = 24
		refs = "0010 __waccess_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_139_7_0 {
	meta:
		name = "??$taccess_s@ABQB_WH@?$__crt_char_traits@_W@@SAHABQB_W$$QAH@Z"
		size = 24
		refs = "0010 __waccess_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_262_20_4 {
	meta:
		name = "??$taccess_s@PA_WH@?$__crt_char_traits@_W@@SAH$$QAPA_W$$QAH@Z"
		size = 24
		refs = "0010 __waccess_s"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_625_22_0 {
	meta:
		name = "??$tcsnlen@ABQBDH@?$__crt_char_traits@D@@SAIABQBD$$QAH@Z"
		size = 24
		refs = "0010 _strnlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_625_23_4 {
	meta:
		name = "??$tcsnlen@ABQB_WH@?$__crt_char_traits@_W@@SAIABQB_W$$QAH@Z"
		size = 24
		refs = "0010 _wcsnlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_583_26_0 {
	meta:
		name = "??$tcsnlen@PADH@?$__crt_char_traits@D@@SAI$$QAPAD$$QAH@Z"
		size = 24
		refs = "0010 _strnlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_664_29_3 {
	meta:
		name = "??$tcsnlen@PA_WH@?$__crt_char_traits@_W@@SAI$$QAPA_W$$QAH@Z"
		size = 24
		refs = "0010 _wcsnlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_625_24_2 {
	meta:
		name = "??$tcsnlen@PBDH@?$__crt_char_traits@D@@SAI$$QAPBD$$QAH@Z"
		size = 24
		refs = "0010 _strnlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_625_25_2 {
	meta:
		name = "??$tcsnlen@PB_WH@?$__crt_char_traits@_W@@SAI$$QAPB_W$$QAH@Z"
		size = 24
		refs = "0010 _wcsnlen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_262_41_2 {
	meta:
		name = "??$tfdopen@AAHABQBD@?$__crt_char_traits@D@@SAPAU_iobuf@@AAHABQBD@Z"
		size = 24
		refs = "0010 __fdopen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_262_42_2 {
	meta:
		name = "??$tfdopen@AAHABQB_W@?$__crt_char_traits@_W@@SAPAU_iobuf@@AAHABQB_W@Z"
		size = 24
		refs = "0010 __wfdopen"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 59 59 5D C3 }
	condition:
		$1
}

rule file_139_18_0 {
	meta:
		name = "??$tdupenv_s_crt@PAPAD$$TABQBD@?$__crt_char_traits@D@@SAH$$QAPAPAD$$QA$$TABQBD@Z"
		size = 39
		refs = "000b ??_C@_0DC@GGIGALME@minkernel?2crts?2ucrt?2inc?2corecrt_@ 001e __dupenv_s_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 6A 6A 68 ?? ?? ?? ?? 6A 02 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_139_19_0 {
	meta:
		name = "??$tdupenv_s_crt@PAPA_W$$TABQB_W@?$__crt_char_traits@_W@@SAH$$QAPAPA_W$$QA$$TABQB_W@Z"
		size = 39
		refs = "000b ??_C@_0DC@GGIGALME@minkernel?2crts?2ucrt?2inc?2corecrt_@ 001e __wdupenv_s_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 10 6A 79 68 ?? ?? ?? ?? 6A 02 FF 30 8B 45 0C FF 30 8B 45 08 FF 30 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_139_44_0 {
	meta:
		name = "__searchenv"
		size = 29
		refs = "0014 ??$common_searchenv_s@D@@YAHQBD0QADI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 68 04 01 00 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_139_46_0 {
	meta:
		name = "__wsearchenv"
		size = 29
		refs = "0014 ??$common_searchenv_s@_W@@YAHQB_W0QA_WI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 68 04 01 00 00 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_140_0_0 {
	meta:
		name = "__CIcos_pentium4"
		size = 428
		refs = "0039 PI32INV 0045 SHIFTER 0055 P_1 0061 P_2 007e SC_4 0084 ___acrt_cos_sin_ctable 0099 P_3 00be SC_2 0103 SC_3 010f SC_1 018e ONE 01a5 __cos_default"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 04 24 E8 08 00 00 00 C9 C3 66 0F 12 44 24 04 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 42 01 00 00 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C8 66 0F 12 15 ?? ?? ?? ?? F2 0F 2D D1 F2 0F 58 CA 66 0F 12 1D ?? ?? ?? ?? F2 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 D9 66 0F 14 C9 81 C2 10 76 1C 00 F2 0F 10 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 05 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C E3 66 0F 12 78 08 66 0F 14 C0 F2 0F 10 DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB 66 0F 12 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 F2 0F 10 C3 F2 0F 58 58 08 F2 0F 59 CF F2 0F 10 FC F2 0F 58 E3 66 0F 58 F5 66 0F 12 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F2 0F 58 CE 83 EC 10 F2 0F 58 E1 66 0F 13 64 24 04 DD 44 24 04 83 C4 10 C3 7F 2B 66 0F C5 C0 03 66 25 FF 7F 66 0F C4 C0 03 83 EC 10 66 0F 12 0D ?? ?? ?? ?? F2 0F 5C C8 66 0F 13 4C 24 04 DD 44 24 04 83 C4 10 C3 E9 ?? ?? ?? ?? 8D 49 00 }
	condition:
		$1
}

rule file_143_1_0 {
	meta:
		name = "__CIfmod"
		size = 24
		refs = "0001 __OP_FMODjmptab 0006 __cintrindisp2"
	strings:
		$1 = { BA ?? ?? ?? ?? E9 ?? ?? ?? ?? D9 C9 D9 F8 9B DF E0 9B 9E 7A F7 DD D9 C3 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "___ascii_memicmp"
		size = 89
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 74 45 8B 75 08 8B 7D 0C B7 41 B3 5A B6 20 8D 49 00 8A 26 83 C6 01 8A 07 83 C7 01 3A E0 74 18 3A E7 72 06 3A E3 77 02 02 E6 3A C7 72 06 3A C3 77 02 02 C6 3A E0 75 07 83 E9 01 75 D5 EB 09 B9 FF FF FF FF 72 02 F7 D9 8B C1 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "__getdiskfree"
		size = 307
		refs = "0009 ___security_cookie 0026 ??_C@_1CE@JMFACANE@?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 002b ??_C@_1GK@PCMJMNFF@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0031 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 003c __CrtDbgReportW 004a __errno 0054 ??_C@_1BK@HDMOFHIE@?$AA_?$AAg?$AAe?$AAt?$AAd?$AAi?$AAs?$AAk?$AAf?$AAr?$AAe?$AAe?$AA?$AA@ 0060 __invalid_parameter 007c ??_C@_1CG@BPIFNLOB@?$AAd?$AAr?$AAi?$AAv?$AAe?$AA_?$AAn?$AAu?$AAm?$AAb?$AAe?$AAr?$AA?5?$AA?$DM?$AA?$DN?$AA?5?$AA2?$AA6?$AA?$AA@ 00fd __imp__GetDiskFreeSpaceW@20 0107 __imp__GetLastError@0 0116 ___acrt_errno_from_os_error 012b @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 0C 33 C0 8B 55 08 85 C9 56 0F 95 C0 57 85 C0 75 4A BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 50 6A 18 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 6A 18 56 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 57 58 E9 B4 00 00 00 6A 1A 58 3B C2 1B C0 83 C0 01 75 2F BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 50 6A 19 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 6A 19 EB A8 33 C0 8D 7D EC AB 8D 75 EC 6A 5F AB AB AB 8B F9 58 6A 3A A5 A5 A5 A5 66 89 45 F4 8B F2 58 66 89 45 F6 6A 5C 58 66 89 45 F8 33 C0 F7 DE 66 89 45 FA 8D 45 F4 1B F6 23 F0 85 D2 74 07 8D 42 40 66 89 45 F4 51 8D 41 04 50 8D 41 0C 50 8D 41 08 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 1C FF 15 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? 57 8B F0 E8 ?? ?? ?? ?? 89 06 8B C7 59 EB 02 33 C0 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "_c16rtomb"
		size = 542
		refs = "0009 ___security_cookie 001b ?internal_pst@?1??c16rtomb@@9@4U_Mbstatet@@A 0216 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 7D 10 00 75 07 C7 45 10 ?? ?? ?? ?? 8B 45 10 8A 48 06 88 4D E7 8B 55 10 8B 02 89 45 EC 83 7D 08 00 75 15 B9 01 00 00 00 6B D1 00 8D 44 15 F4 89 45 08 33 C9 66 89 4D 0C 8B 55 08 89 55 F0 0F BE 45 E7 85 C0 74 3B 0F B7 4D 0C 81 F9 00 DC 00 00 7C 0C 0F B7 55 0C 81 FA 00 E0 00 00 7C 08 83 C8 FF E9 97 01 00 00 33 C0 8B 4D 10 66 89 41 06 0F B7 55 0C 81 EA 00 DC 00 00 0B 55 EC 89 55 EC EB 45 0F B7 45 0C 3D 00 D8 00 00 7C 0C 0F B7 4D 0C 81 F9 00 DC 00 00 7C 09 0F B7 55 0C 89 55 EC EB 25 B8 01 00 00 00 8B 4D 10 66 89 41 06 0F B7 55 0C 81 EA C0 D7 00 00 C1 E2 0A 8B 45 10 89 10 33 C0 E9 37 01 00 00 8B 4D EC 83 E1 80 75 1D 8B 55 F0 8A 45 EC 88 02 8B 4D F0 83 C1 01 89 4D F0 C7 45 E8 00 00 00 00 E9 DB 00 00 00 8B 55 EC 81 E2 00 F8 FF FF 75 25 8B 45 EC C1 E8 06 0D C0 00 00 00 8B 4D F0 88 01 8B 55 F0 83 C2 01 89 55 F0 C7 45 E8 01 00 00 00 E9 AB 00 00 00 8B 45 EC 25 00 00 FF FF 75 23 8B 4D EC C1 E9 0C 81 C9 E0 00 00 00 8B 55 F0 88 0A 8B 45 F0 83 C0 01 89 45 F0 C7 45 E8 02 00 00 00 EB 7E 8B 4D EC 81 E1 00 00 E0 FF 75 23 8B 55 EC C1 EA 12 81 CA F0 00 00 00 8B 45 F0 88 10 8B 4D F0 83 C1 01 89 4D F0 C7 45 E8 03 00 00 00 EB 50 8B 55 EC 81 E2 00 00 00 FC 75 22 8B 45 EC C1 E8 18 0D F8 00 00 00 8B 4D F0 88 01 8B 55 F0 83 C2 01 89 55 F0 C7 45 E8 04 00 00 00 EB 23 8B 45 EC C1 E8 1E 83 E0 03 0D FC 00 00 00 8B 4D F0 88 01 8B 55 F0 83 C2 01 89 55 F0 C7 45 E8 05 00 00 00 83 7D E8 00 7E 2B 8B 45 E8 83 E8 01 89 45 E8 6B 4D E8 06 8B 55 EC D3 EA 83 E2 3F 81 CA 80 00 00 00 8B 45 F0 88 10 8B 4D F0 83 C1 01 89 4D F0 EB CF 8B 45 F0 2B 45 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_149_14_0 {
	meta:
		name = "__Getdays"
		size = 17
		refs = "0008 __Getdays_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_149_16_0 {
	meta:
		name = "__Getmonths"
		size = 17
		refs = "0008 __Getmonths_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_699_14_0 {
	meta:
		name = "___acrt_get_begin_thread_init_policy"
		size = 17
		refs = "0008 ??$get_cached_win_policy@Ubegin_thread_init_policy_properties@?1??__acrt_get_begin_thread_init_policy@@YA?AW4begin_thread_init_policy@@XZ@@@YA?AW4begin_thread_init_policy@@W4AppPolicyThreadInitializationType@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_699_15_4 {
	meta:
		name = "___acrt_get_developer_information_policy"
		size = 17
		refs = "0008 ??$get_cached_win_policy@Udeveloper_information_policy_properties@?1??__acrt_get_developer_information_policy@@YA?AW4developer_information_policy@@XZ@@@YA?AW4developer_information_policy@@W4AppPolicyShowDeveloperDiagnostic@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_699_16_4 {
	meta:
		name = "___acrt_get_process_end_policy"
		size = 17
		refs = "0008 ??$get_win_policy@Uprocess_end_policy_properties@?1??__acrt_get_process_end_policy@@YA?AW4process_end_policy@@XZ@@@YA?AW4process_end_policy@@W4AppPolicyProcessTerminationMethod@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_186_21_3 {
	meta:
		name = "__endthread"
		size = 17
		refs = "0008 ?common_end_thread@@YAXI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_432_8_3 {
	meta:
		name = "_uninitialize_vcruntime"
		size = 17
		refs = "0008 ___vcrt_uninitialize"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 E8 ?? ?? ?? ?? 83 C4 04 5D C3 }
	condition:
		$1
}

rule file_149_15_0 {
	meta:
		name = "__Getdays_l"
		size = 503
		refs = "0011 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0019 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0052 _strlen 007d ??_C@_0DB@FHJDLBEI@minkernel?2crts?2ucrt?2src?2appcrt?2t@ 008b __malloc_dbg 0097 ??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@QAD@Z 009f ?get@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBEPADXZ 00b2 ??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@XZ 00ba ??1_LocaleUpdate@@QAE@XZ 0101 ??_C@_1GC@LMFEEFAO@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 0106 ??_C@_1BG@LGACIFJI@?$AA_?$AAG?$AAe?$AAt?$AAd?$AAa?$AAy?$AAs?$AA_?$AAl?$AA?$AA@ 010b ??_C@_1JE@EOABCHAL@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAi?$AAt?$AA?0?$AA?5?$AA?$CI?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAi?$AAt?$AA?5@ 0134 _strcpy_s 013d __invoke_watson_if_error 0174 ??_C@_1IK@PMFBCNAB@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAi?$AAt?$AA?0?$AA?5?$AA?$CI?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAi?$AAt?$AA?5@ 01d8 ?detach@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEPADXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 56 8B 45 08 50 8D 4D D0 E8 ?? ?? ?? ?? 8D 4D D0 E8 ?? ?? ?? ?? 8B 08 8B 91 9C 00 00 00 89 55 E8 C7 45 EC 00 00 00 00 C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 83 7D F4 07 73 33 8B 4D F4 8B 55 E8 8B 04 8A 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 4D F4 8B 55 E8 8B 44 8A 1C 50 E8 ?? ?? ?? ?? 83 C4 04 03 45 EC 8D 4C 30 02 89 4D EC EB BE 6A 1C 68 ?? ?? ?? ?? 6A 02 8B 55 EC 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 1F C7 45 E4 00 00 00 00 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 E4 E9 2C 01 00 00 8D 4D F8 E8 ?? ?? ?? ?? 89 45 FC C7 45 F0 00 00 00 00 EB 09 8B 45 F0 83 C0 01 89 45 F0 83 7D F0 07 0F 83 D8 00 00 00 8B 4D FC C6 01 3A 8B 55 FC 83 C2 01 89 55 FC 6A 00 6A 25 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F0 8B 4D E8 8B 14 81 52 8B 75 EC 83 C6 01 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D FC 2B C8 2B F1 56 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 03 45 FC 89 45 FC 8B 4D FC C6 01 3A 8B 55 FC 83 C2 01 89 55 FC 6A 00 6A 28 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F0 8B 4D E8 8B 54 81 1C 52 8B 75 EC 83 C6 01 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D FC 2B C8 2B F1 56 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 03 45 FC 89 45 FC E9 15 FF FF FF 8B 4D FC C6 01 00 8B 55 FC 83 C2 01 89 55 FC 8D 4D F8 E8 ?? ?? ?? ?? 89 45 E0 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 E0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_149_17_0 {
	meta:
		name = "__Getmonths_l"
		size = 505
		refs = "0011 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0019 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0053 _strlen 007e ??_C@_0DB@FHJDLBEI@minkernel?2crts?2ucrt?2src?2appcrt?2t@ 008c __malloc_dbg 0098 ??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@QAD@Z 00a0 ?get@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBEPADXZ 00b3 ??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@XZ 00bb ??1_LocaleUpdate@@QAE@XZ 0102 ??_C@_1GC@LMFEEFAO@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 0107 ??_C@_1BK@IDMELNCB@?$AA_?$AAG?$AAe?$AAt?$AAm?$AAo?$AAn?$AAt?$AAh?$AAs?$AA_?$AAl?$AA?$AA@ 010c ??_C@_1JG@KINOFMEM@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAi?$AAt?$AA?0?$AA?5?$AA?$CI?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAi?$AAt?$AA?5@ 0136 _strcpy_s 013f __invoke_watson_if_error 0176 ??_C@_1IM@IEHGKIAE@?$AAs?$AAt?$AAr?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AAi?$AAt?$AA?0?$AA?5?$AA?$CI?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$CL?$AA?5?$AA1?$AA?$CJ?$AA?5?$AA?9?$AA?5?$AA?$CI?$AAi?$AAt?$AA?5@ 01da ?detach@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEPADXZ"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 56 8B 45 08 50 8D 4D D0 E8 ?? ?? ?? ?? 8D 4D D0 E8 ?? ?? ?? ?? 8B 08 8B 91 9C 00 00 00 89 55 E8 C7 45 EC 00 00 00 00 C7 45 F4 00 00 00 00 EB 09 8B 45 F4 83 C0 01 89 45 F4 83 7D F4 0C 73 34 8B 4D F4 8B 55 E8 8B 44 8A 38 50 E8 ?? ?? ?? ?? 83 C4 04 8B F0 8B 4D F4 8B 55 E8 8B 44 8A 68 50 E8 ?? ?? ?? ?? 83 C4 04 03 45 EC 8D 4C 30 02 89 4D EC EB BD 6A 42 68 ?? ?? ?? ?? 6A 02 8B 55 EC 83 C2 01 52 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 1F C7 45 E4 00 00 00 00 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 E4 E9 2D 01 00 00 8D 4D F8 E8 ?? ?? ?? ?? 89 45 FC C7 45 F0 00 00 00 00 EB 09 8B 45 F0 83 C0 01 89 45 F0 83 7D F0 0C 0F 83 D9 00 00 00 8B 4D FC C6 01 3A 8B 55 FC 83 C2 01 89 55 FC 6A 00 6A 4A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F0 8B 4D E8 8B 54 81 38 52 8B 75 EC 83 C6 01 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D FC 2B C8 2B F1 56 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 03 45 FC 89 45 FC 8B 4D FC C6 01 3A 8B 55 FC 83 C2 01 89 55 FC 6A 00 6A 4D 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 F0 8B 4D E8 8B 54 81 68 52 8B 75 EC 83 C6 01 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D FC 2B C8 2B F1 56 8B 55 FC 52 E8 ?? ?? ?? ?? 83 C4 0C 50 E8 ?? ?? ?? ?? 83 C4 18 8B 45 FC 50 E8 ?? ?? ?? ?? 83 C4 04 03 45 FC 89 45 FC E9 14 FF FF FF 8B 4D FC C6 01 00 8B 55 FC 83 C2 01 89 55 FC 8D 4D F8 E8 ?? ?? ?? ?? 89 45 E0 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D D0 E8 ?? ?? ?? ?? 8B 45 E0 5E 8B E5 5D C3 }
	condition:
		$1
}

rule file_149_19_0 {
	meta:
		name = "__Strftime"
		size = 37
		refs = "001c __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_300_30_0 {
	meta:
		name = "__Wcsftime"
		size = 37
		refs = "001c __Wcsftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_725_21_4 {
	meta:
		name = "__ui64toa_s"
		size = 37
		refs = "001c ??$common_xtox_s@_KD@@YAH_KQADII_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_725_23_4 {
	meta:
		name = "__ui64tow_s"
		size = 37
		refs = "001c ??$common_xtox_s@_K_W@@YAH_KQA_WII_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_536_8_3 {
	meta:
		name = "_mbstowcs_s"
		size = 37
		refs = "001c __mbstowcs_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_332_11_3 {
	meta:
		name = "_wcstombs_s"
		size = 37
		refs = "001c __wcstombs_s_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 8B 45 18 50 8B 4D 14 51 8B 55 10 52 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_149_20_0 {
	meta:
		name = "__Strftime_l"
		size = 1149
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0047 ??_C@_1CE@BLLJFLOH@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 004c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0058 ??_C@_1GC@LMFEEFAO@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAt@ 005f __CrtDbgReportW 0073 __errno 008a ??_C@_1BI@ONBMGNNA@?$AA_?$AAS?$AAt?$AAr?$AAf?$AAt?$AAi?$AAm?$AAe?$AA_?$AAl?$AA?$AA@ 0094 __invalid_parameter 00a6 ??1_LocaleUpdate@@QAE@XZ 00d5 ??_C@_1BK@IFBPBBBE@?$AAm?$AAa?$AAx?$AAs?$AAi?$AAz?$AAe?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0169 ??_C@_1CE@EAKLPBKK@?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 01f7 ??_C@_1CG@DBOIPFHC@?$AAt?$AAi?$AAm?$AAe?$AAp?$AAt?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0274 __imp__MultiByteToWideChar@24 0283 __imp__GetLastError@0 0289 ___acrt_errno_map_os_error 02ad ??_C@_0DB@FHJDLBEI@minkernel?2crts?2ucrt?2src?2appcrt?2t@ 02ba __malloc_dbg 02c6 ??0?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAE@QA_W@Z 02ce ?get@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QBEPA_WXZ 02e1 ??1?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAE@XZ 03bf __Wcsftime_l 0415 __imp__WideCharToMultiByte@32"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 74 8B 45 1C 50 8D 4D 8C E8 ?? ?? ?? ?? 8D 4D 8C E8 ?? ?? ?? ?? 8B 08 8B 51 14 89 55 F0 83 7D 08 00 74 09 C7 45 EC 01 00 00 00 EB 07 C7 45 EC 00 00 00 00 8B 45 EC 89 45 E8 83 7D E8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 82 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E8 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 82 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 C8 00 00 00 00 8D 4D 8C E8 ?? ?? ?? ?? 8B 45 C8 E9 C7 03 00 00 83 7D 0C 00 74 09 C7 45 E4 01 00 00 00 EB 07 C7 45 E4 00 00 00 00 8B 55 E4 89 55 E0 83 7D E0 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 83 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D E0 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 83 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 C4 00 00 00 00 8D 4D 8C E8 ?? ?? ?? ?? 8B 45 C4 E9 39 03 00 00 8B 4D 08 C6 01 00 83 7D 10 00 74 09 C7 45 DC 01 00 00 00 EB 07 C7 45 DC 00 00 00 00 8B 55 DC 89 55 D8 83 7D D8 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 86 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D8 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 86 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 C0 00 00 00 00 8D 4D 8C E8 ?? ?? ?? ?? 8B 45 C0 E9 A5 02 00 00 83 7D 14 00 74 09 C7 45 D4 01 00 00 00 EB 07 C7 45 D4 00 00 00 00 8B 4D D4 89 4D D0 83 7D D0 00 75 26 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 68 87 00 00 00 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D D0 00 75 40 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 68 87 00 00 00 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 BC 00 00 00 00 8D 4D 8C E8 ?? ?? ?? ?? 8B 45 BC E9 17 02 00 00 6A 00 6A 00 6A FF 8B 45 10 50 6A 00 8B 4D F0 51 FF 15 ?? ?? ?? ?? 89 45 F4 83 7D F4 00 75 26 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 B8 00 00 00 00 8D 4D 8C E8 ?? ?? ?? ?? 8B 45 B8 E9 D2 01 00 00 68 92 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 55 F4 D1 E2 52 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D FC E8 ?? ?? ?? ?? 8D 4D FC E8 ?? ?? ?? ?? 85 C0 75 1F C7 45 B4 00 00 00 00 8D 4D FC E8 ?? ?? ?? ?? 8D 4D 8C E8 ?? ?? ?? ?? 8B 45 B4 E9 84 01 00 00 8B 45 F4 50 8D 4D FC E8 ?? ?? ?? ?? 50 6A FF 8B 4D 10 51 6A 00 8B 55 F0 52 FF 15 ?? ?? ?? ?? 85 C0 75 2E FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 B0 00 00 00 00 8D 4D FC E8 ?? ?? ?? ?? 8D 4D 8C E8 ?? ?? ?? ?? 8B 45 B0 E9 33 01 00 00 68 A2 00 00 00 68 ?? ?? ?? ?? 6A 02 8B 45 0C D1 E0 50 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 27 C7 45 AC 00 00 00 00 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D FC E8 ?? ?? ?? ?? 8D 4D 8C E8 ?? ?? ?? ?? 8B 45 AC E9 DD 00 00 00 8B 4D 1C 51 8B 55 18 52 8B 45 14 50 8D 4D FC E8 ?? ?? ?? ?? 50 8B 4D 0C 51 8D 4D F8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 18 89 45 A8 83 7D A8 00 75 27 C7 45 A4 00 00 00 00 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D FC E8 ?? ?? ?? ?? 8D 4D 8C E8 ?? ?? ?? ?? 8B 45 A4 E9 83 00 00 00 6A 00 6A 00 8B 55 0C 52 8B 45 08 50 6A FF 8D 4D F8 E8 ?? ?? ?? ?? 50 6A 00 8B 4D F0 51 FF 15 ?? ?? ?? ?? 89 45 CC 83 7D CC 00 75 33 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 A0 00 00 00 00 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D FC E8 ?? ?? ?? ?? 8D 4D 8C E8 ?? ?? ?? ?? 8B 45 A0 EB 24 8B 55 CC 83 EA 01 89 55 9C 8D 4D F8 E8 ?? ?? ?? ?? 8D 4D FC E8 ?? ?? ?? ?? 8D 4D 8C E8 ?? ?? ?? ?? 8B 45 9C 8B E5 5D C3 }
	condition:
		$1
}

rule file_149_24_0 {
	meta:
		name = "_strftime"
		size = 35
		refs = "001a __Strftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_240_8_0 {
	meta:
		name = "__aligned_offset_realloc"
		size = 35
		refs = "001a __aligned_offset_realloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_300_37_0 {
	meta:
		name = "_wcsftime"
		size = 35
		refs = "001a __Wcsftime_l"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 8B 45 14 50 8B 4D 10 51 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_151_6_0 {
	meta:
		name = "__wperror"
		size = 286
		refs = "0024 _perror 003c ??_C@_1GA@JOAFAKLF@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAm@ 0041 ??_C@_1BC@KGOJENED@?$AA_?$AAw?$AAp?$AAe?$AAr?$AAr?$AAo?$AAr?$AA?$AA@ 0046 ??_C@_1IM@LFGMMMGG@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAs?$AA?$CI?$AA?$CG?$AAr?$AAe?$AAq?$AAu?$AAi?$AAr?$AAe?$AAd?$AA_?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?0?$AA?5?$AAn?$AAu?$AAl?$AAl@ 0060 _wcstombs_s 0069 __invoke_watson_if_oneof 007e ??_C@_0DA@ELGHEBH@minkernel?2crts?2ucrt?2src?2appcrt?2m@ 008b __calloc_dbg 0097 ??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@QAD@Z 009f ?get@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBEPADXZ 00ab ??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@XZ 00c0 ??_C@_1LO@KEGGEIEG@?$AAw?$AAc?$AAs?$AAt?$AAo?$AAm?$AAb?$AAs?$AA_?$AAs?$AA?$CI?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?0?$AA?5?$AAn?$AAa?$AAr?$AAr?$AAo?$AAw?$AA_?$AAu?$AAs?$AAe?$AAr@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 83 7D 08 00 74 13 B8 02 00 00 00 6B C8 00 8B 55 08 0F B7 04 0A 85 C0 75 0F 6A 00 E8 ?? ?? ?? ?? 83 C4 04 E9 EA 00 00 00 C7 45 F8 00 00 00 00 6A 00 6A 2F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 68 FF FF FF 7F 8B 4D 08 51 6A 00 6A 00 8D 55 F8 52 E8 ?? ?? ?? ?? 83 C4 14 50 E8 ?? ?? ?? ?? 83 C4 20 83 7D F8 00 75 05 E9 9F 00 00 00 6A 33 68 ?? ?? ?? ?? 6A 02 6A 01 8B 45 F8 50 E8 ?? ?? ?? ?? 83 C4 14 50 8D 4D FC E8 ?? ?? ?? ?? 8D 4D FC E8 ?? ?? ?? ?? 85 C0 75 0A 8D 4D FC E8 ?? ?? ?? ?? EB 69 6A 00 6A 3C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 22 6A 16 6A FF 8B 4D 08 51 8B 55 F8 52 8D 4D FC E8 ?? ?? ?? ?? 50 6A 00 E8 ?? ?? ?? ?? 83 C4 14 50 E8 ?? ?? ?? ?? 83 C4 20 89 45 F4 83 7D F4 00 74 0A 8D 4D FC E8 ?? ?? ?? ?? EB 19 8D 4D FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8D 4D FC E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_153_1_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_handle_traits@@@@QAE@XZ"
		size = 23
		refs = "000e __imp__CloseHandle@4"
		altNames = "?close@?$__crt_unique_handle_t@U__crt_handle_traits@@@@QAEXXZ"
	strings:
		$1 = { 8B FF 56 8B F1 83 3E FF 74 0B FF 36 FF 15 ?? ?? ?? ?? 83 0E FF 5E C3 }
	condition:
		$1
}

rule file_153_3_0 {
	meta:
		name = "?close@__crt_handle_traits@@SA_NPAX@Z"
		size = 22
		refs = "000a __imp__CloseHandle@4"
	strings:
		$1 = { 8B FF 55 8B EC FF 75 08 FF 15 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 5D C3 }
	condition:
		$1
}

rule file_153_6_0 {
	meta:
		name = "__cwait"
		size = 158
		refs = "0025 __imp__WaitForSingleObject@8 0034 __imp__GetExitCodeProcess@8 004b __imp__GetLastError@0 0055 __errno 0060 ___doserrno 006e ___acrt_errno_map_os_error 0082 __imp__CloseHandle@4"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 57 8B 7D 08 83 CB FF 85 FF 74 02 89 1F 8B 75 0C 3B F3 74 6E 83 FE FE 74 69 53 56 FF 15 ?? ?? ?? ?? 85 C0 75 1C 8D 45 FC 50 56 FF 15 ?? ?? ?? ?? 85 C0 74 0D 85 FF 74 05 8B 45 FC 89 07 8B FE EB 32 FF 15 ?? ?? ?? ?? 83 F8 06 75 18 E8 ?? ?? ?? ?? C7 00 0A 00 00 00 E8 ?? ?? ?? ?? C7 00 06 00 00 00 EB 07 50 E8 ?? ?? ?? ?? 59 85 FF 74 02 89 1F 8B FB 3B F3 74 07 56 FF 15 ?? ?? ?? ?? 8B C7 EB 0D E8 ?? ?? ?? ?? C7 00 0A 00 00 00 8B C3 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "__libm_sse2_log_precise"
		size = 656
		refs = "0051 emask 0059 One 0061 Magic 0069 hi_mask 0087 ___acrt_log_table_b 008f ___acrt_log_table_t 00f1 coeff 011d LOG_2 0129 place_L 01c1 Infs 01ec Two52 023d ___libm_error_support 027b __log_default"
	strings:
		$1 = { 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 7F 00 00 3D 80 1F 00 00 0F 85 59 02 00 00 D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 0F 85 44 02 00 00 66 0F 13 04 24 BA 00 00 00 00 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F3 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 A1 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 66 0F 28 C1 66 0F 15 C9 83 C4 08 F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 C3 66 0F 12 04 24 66 0F 57 C9 F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 4C 83 F9 FF 74 62 81 F9 FE 07 00 00 77 70 66 0F 12 04 24 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 0C 83 C4 08 66 0F 12 05 ?? ?? ?? ?? C3 BA E8 03 00 00 EB 4F 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 0D ?? ?? ?? ?? BA 02 00 00 00 EB 34 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 3D FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 3C 66 0F 57 C9 F2 0F 5E C9 BA 03 00 00 00 83 EC 18 66 0F 13 4C 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 08 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 66 0F 12 44 24 10 83 C4 20 C3 66 0F 12 14 24 66 0F 28 C2 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 A1 BA E8 03 00 00 EB A7 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 83 C4 08 C3 EB 03 CC CC CC }
	condition:
		$1
}

rule file_156_5_0 {
	meta:
		name = "__mbsnset_l"
		size = 390
		refs = "001c ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 002c ??_C@_1EA@MFKLBHOB@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?5?$AA?$HM?$AA?$HM?$AA?5?$AAc?$AAo?$AAu?$AAn?$AAt?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0031 ??_C@_1HA@HGKCPACN@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0037 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0042 __CrtDbgReportW 0050 __errno 0059 ??_C@_1BG@OCHPEGDL@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAs?$AAe?$AAt?$AA_?$AAl?$AA?$AA@ 0065 __invalid_parameter 007f __strnset 00a5 ??_C@_1FE@CMFNLFJD@?$AA?$CI?$AA?$CC?$AAi?$AAn?$AAv?$AAa?$AAl?$AAi?$AAd?$AA?5?$AAM?$AAB?$AAC?$AAS?$AA?5?$AAp?$AAa?$AAi?$AAr?$AA?5?$AAp?$AAa?$AAs?$AAs?$AAe?$AAd?$AA?5?$AAt?$AAo?$AA?5?$AAm?$AAb@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 53 56 8B 75 08 8D 4D E8 57 FF 75 14 33 FF 89 75 F8 8B DF E8 ?? ?? ?? ?? 8B 4D 10 85 F6 75 4A 85 C9 74 46 BE ?? ?? ?? ?? BB ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 57 6A 46 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 57 6A 46 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 FC 00 00 00 8B 45 F0 39 78 08 75 14 51 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 8B F8 E9 E0 00 00 00 8B 45 0C 8B D0 C1 EA 08 89 45 FC 84 D2 0F 84 93 00 00 00 84 C0 75 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 6A 5B 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? B2 20 88 55 FC C7 00 16 00 00 00 8B 4D 10 85 C9 0F 84 89 00 00 00 8A 06 49 84 C0 74 76 85 DB 75 12 8B 5D F0 0F B6 C0 F6 44 18 19 04 74 05 33 DB 43 EB 02 8B DF 88 16 46 8A 06 84 C0 74 20 85 DB 75 12 8B 5D F0 0F B6 C0 F6 44 18 19 04 74 05 33 DB 43 EB 02 8B DF 8B 45 FC 88 06 46 EB 04 C6 46 FF 20 85 C9 75 B0 EB 2B 85 C9 74 33 8A 06 49 84 C0 74 20 85 DB 75 10 8B 55 F0 0F B6 C0 F6 44 10 19 04 74 03 43 EB 02 8B DF 8B 45 0C 88 06 46 85 C9 75 D9 85 DB 74 08 80 3E 00 74 03 C6 06 20 8B 7D F8 80 7D F4 00 74 0A 8B 4D E8 83 A1 50 03 00 00 FD 8B C7 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_157_5_0 {
	meta:
		name = "__mbsspnp_l"
		size = 321
		refs = "0012 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0028 _strspn 004d ??_C@_1CE@BLLJFLOH@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0052 ??_C@_1GO@FEIMMIGB@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0063 __CrtDbgReportW 0071 __errno 0089 ??_C@_1CG@KOEBEMJH@?$AAc?$AAh?$AAa?$AAr?$AAs?$AAe?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 00b6 ??_C@_1BG@DIADCNPB@?$AA_?$AAm?$AAb?$AAs?$AAs?$AAp?$AAn?$AAp?$AA_?$AAl?$AA?$AA@ 00c2 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 53 56 57 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 7D F8 33 F6 39 77 08 75 1E FF 75 0C 8B 75 08 56 E8 ?? ?? ?? ?? 03 C6 59 59 0F B6 30 F7 DE 1B F6 23 F0 E9 EA 00 00 00 8B 4D 08 33 C0 85 C9 0F 95 C0 85 C0 75 2E BB ?? ?? ?? ?? BF ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 56 6A 50 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 6A 50 EB 3A 8B 55 0C 33 C0 85 D2 0F 95 C0 85 C0 75 43 BB ?? ?? ?? ?? BF ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 56 6A 51 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 6A 51 57 68 ?? ?? ?? ?? 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 5D 80 39 00 74 4F 8A 3A 84 FF 74 2B 8A 1A 0F B6 C3 F6 44 38 19 04 74 15 3A 19 75 08 8A 42 01 3A 41 01 74 13 80 7A 01 00 74 0D 42 EB 04 3A 19 74 06 42 80 3A 00 75 D5 80 3A 00 74 19 0F B6 01 F6 44 38 19 04 74 06 41 80 39 00 74 09 8B 55 0C 41 80 39 00 75 B3 0F B6 31 F7 DE 1B F6 23 F1 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 5F 8B C6 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_158_12_0 {
	meta:
		name = "?InternalGetLocaleInfoA@@YAHQAU__crt_locale_pointers@@QB_WKQADH@Z"
		size = 367
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0018 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0031 ___acrt_GetLocaleInfoEx@16 0049 ??1_LocaleUpdate@@QAE@XZ 005c __MallocaComputeSize 006f ??_C@_0DJ@JBBOOIAE@minkernel?2crts?2ucrt?2src?2appcrt?2l@ 0085 __malloc_dbg 008e __MarkAllocaS 00a9 ??0?$__crt_scoped_stack_ptr_tag@_W@@QAE@QA_W@Z 00b4 ??0?$__crt_scoped_stack_ptr@_W@@QAE@U?$__crt_scoped_stack_ptr_tag@_W@@@Z 00bc ?get@?$__crt_scoped_stack_ptr@_W@@QBEPA_WXZ 00cf ??1?$__crt_scoped_stack_ptr@_W@@QAE@XZ 0151 __imp__WideCharToMultiByte@32"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 8B 45 08 50 8D 4D C8 E8 ?? ?? ?? ?? 8D 4D C8 E8 ?? ?? ?? ?? 8B 08 8B 51 08 89 55 E0 6A 00 6A 00 8B 45 10 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 89 45 F8 83 7D F8 00 75 17 C7 45 EC 00 00 00 00 8D 4D C8 E8 ?? ?? ?? ?? 8B 45 EC E9 16 01 00 00 8B 55 F8 D1 E2 52 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 33 68 DD DD 00 00 6A 1E 68 ?? ?? ?? ?? 6A 02 8B 45 F8 D1 E0 50 E8 ?? ?? ?? ?? 83 C4 04 50 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 08 89 45 F4 EB 07 C7 45 F4 00 00 00 00 8B 4D F4 51 8D 4D D8 E8 ?? ?? ?? ?? 8B 10 52 8D 4D FC E8 ?? ?? ?? ?? 8D 4D FC E8 ?? ?? ?? ?? 85 C0 75 1F C7 45 E8 00 00 00 00 8D 4D FC E8 ?? ?? ?? ?? 8D 4D C8 E8 ?? ?? ?? ?? 8B 45 E8 E9 88 00 00 00 8B 45 F8 50 8D 4D FC E8 ?? ?? ?? ?? 50 8B 4D 10 51 8B 55 0C 52 E8 ?? ?? ?? ?? 85 C0 75 1C C7 45 E4 00 00 00 00 8D 4D FC E8 ?? ?? ?? ?? 8D 4D C8 E8 ?? ?? ?? ?? 8B 45 E4 EB 4E 83 7D 18 00 74 08 8B 45 14 89 45 F0 EB 07 C7 45 F0 00 00 00 00 6A 00 6A 00 8B 4D 18 51 8B 55 F0 52 6A FF 8D 4D FC E8 ?? ?? ?? ?? 50 6A 00 8B 45 E0 50 FF 15 ?? ?? ?? ?? 89 45 DC 8D 4D FC E8 ?? ?? ?? ?? 8D 4D C8 E8 ?? ?? ?? ?? 8B 45 DC 8B E5 5D C3 }
	condition:
		$1
}

rule file_158_22_0 {
	meta:
		name = "___acrt_GetLocaleInfoA"
		size = 946
		refs = "000c ___security_cookie 0054 ?InternalGetLocaleInfoA@@YAHQAU__crt_locale_pointers@@QB_WKQADH@Z 0071 ??_C@_0DJ@JBBOOIAE@minkernel?2crts?2ucrt?2src?2appcrt?2l@ 0081 __calloc_dbg 0090 ??0?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@QAD@Z 0097 ?detach@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEPADXZ 00aa ??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAE@XZ 00c6 ??_C@_1HC@KAIIOBKJ@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAl@ 00cb ??_C@_1CM@LGLMFNOK@?$AA_?$AA_?$AAa?$AAc?$AAr?$AAt?$AA_?$AAG?$AAe?$AAt?$AAL?$AAo?$AAc?$AAa?$AAl?$AAe?$AAI?$AAn?$AAf?$AAo?$AAA?$AA?$AA@ 00d0 ??_C@_1IM@HJPPDDKJ@?$AAs?$AAt?$AAr?$AAn?$AAc?$AAp?$AAy?$AA_?$AAs?$AA?$CI?$AA?$CK?$AAc?$AAh?$AAa?$AAr?$AA_?$AAr?$AAe?$AAs?$AAu?$AAl?$AAt?$AA?0?$AA?5?$AAl?$AAo?$AAc?$AAa?$AAl?$AA_?$AAl?$AAe@ 00f6 _strncpy_s 00ff __invoke_watson_if_error 010f __imp__GetLastError@0 017c ?get@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QBEPADXZ 0252 ___acrt_GetLocaleInfoEx@16 0292 ??0?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAE@QA_W@Z 029d ?get@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QBEPA_WXZ 02b6 ??1?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAE@XZ 031b ?detach@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QAEPA_WXZ 03aa @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC D4 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 18 C7 00 00 00 00 00 83 7D 0C 01 0F 85 0A 02 00 00 8B 4D 18 89 8D 6C FF FF FF C7 85 2C FF FF FF 80 00 00 00 68 80 00 00 00 8D 95 7C FF FF FF 52 8B 45 14 50 8B 4D 10 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 14 89 85 70 FF FF FF 83 BD 70 FF FF FF 00 0F 84 9F 00 00 00 6A 5D 68 ?? ?? ?? ?? 6A 02 6A 01 8B 85 70 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 14 50 8D 8D 5C FF FF FF E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 8D 6C FF FF FF 89 01 8D 8D 5C FF FF FF E8 ?? ?? ?? ?? 8B 95 6C FF FF FF 83 3A 00 75 08 83 C8 FF E9 E3 02 00 00 6A 00 6A 61 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 85 70 FF FF FF 83 E8 01 50 8D 8D 7C FF FF FF 51 8B 95 70 FF FF FF 52 8B 85 6C FF FF FF 8B 08 51 E8 ?? ?? ?? ?? 83 C4 10 50 E8 ?? ?? ?? ?? 83 C4 18 33 C0 E9 97 02 00 00 FF 15 ?? ?? ?? ?? 83 F8 7A 74 08 83 C8 FF E9 84 02 00 00 6A 00 6A 00 8B 55 14 52 8B 45 10 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 89 85 68 FF FF FF 83 BD 68 FF FF FF 00 75 08 83 C8 FF E9 55 02 00 00 6A 70 68 ?? ?? ?? ?? 6A 02 6A 01 8B 95 68 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 14 50 8D 8D 78 FF FF FF E8 ?? ?? ?? ?? 8D 8D 78 FF FF FF E8 ?? ?? ?? ?? 85 C0 75 20 C7 85 58 FF FF FF FF FF FF FF 8D 8D 78 FF FF FF E8 ?? ?? ?? ?? 8B 85 58 FF FF FF E9 00 02 00 00 8B 85 68 FF FF FF 50 8D 8D 78 FF FF FF E8 ?? ?? ?? ?? 50 8B 4D 14 51 8B 55 10 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 89 85 54 FF FF FF 83 BD 54 FF FF FF 00 75 20 C7 85 50 FF FF FF FF FF FF FF 8D 8D 78 FF FF FF E8 ?? ?? ?? ?? 8B 85 50 FF FF FF E9 AA 01 00 00 8D 8D 78 FF FF FF E8 ?? ?? ?? ?? 8B 8D 6C FF FF FF 89 01 C7 85 4C FF FF FF 00 00 00 00 8D 8D 78 FF FF FF E8 ?? ?? ?? ?? 8B 85 4C FF FF FF E9 77 01 00 00 E9 6F 01 00 00 83 7D 0C 02 0F 85 0A 01 00 00 8B 55 18 89 95 3C FF FF FF 6A 00 6A 00 8B 45 14 50 8B 4D 10 51 E8 ?? ?? ?? ?? 89 85 64 FF FF FF 83 BD 64 FF FF FF 00 75 08 83 C8 FF E9 37 01 00 00 68 85 00 00 00 68 ?? ?? ?? ?? 6A 02 6A 02 8B 95 64 FF FF FF 52 E8 ?? ?? ?? ?? 83 C4 14 50 8D 8D 74 FF FF FF E8 ?? ?? ?? ?? 8D 8D 74 FF FF FF E8 ?? ?? ?? ?? 85 C0 75 20 C7 85 48 FF FF FF FF FF FF FF 8D 8D 74 FF FF FF E8 ?? ?? ?? ?? 8B 85 48 FF FF FF E9 DF 00 00 00 8B 85 64 FF FF FF 50 8D 8D 74 FF FF FF E8 ?? ?? ?? ?? 50 8B 4D 14 51 8B 55 10 52 E8 ?? ?? ?? ?? 89 85 44 FF FF FF 83 BD 44 FF FF FF 00 75 20 C7 85 40 FF FF FF FF FF FF FF 8D 8D 74 FF FF FF E8 ?? ?? ?? ?? 8B 85 40 FF FF FF E9 90 00 00 00 8D 8D 74 FF FF FF E8 ?? ?? ?? ?? 8B 8D 3C FF FF FF 89 01 C7 85 38 FF FF FF 00 00 00 00 8D 8D 74 FF FF FF E8 ?? ?? ?? ?? 8B 85 38 FF FF FF EB 60 EB 5B 83 7D 0C 00 75 55 8B 55 18 89 95 30 FF FF FF C7 85 60 FF FF FF 00 00 00 00 6A 02 8D 85 60 FF FF FF 50 8B 4D 14 81 C9 00 00 00 20 51 8B 55 10 52 E8 ?? ?? ?? ?? 89 85 34 FF FF FF 83 BD 34 FF FF FF 00 75 05 83 C8 FF EB 15 8B 85 30 FF FF FF 8A 8D 60 FF FF FF 88 08 33 C0 EB 03 83 C8 FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_159_4_0 {
	meta:
		name = "__mbsncat_s_l"
		size = 948
		refs = "005e __CrtGetDebugFillThreshold 0074 _memset 007c ??_C@_1CG@OFBJMIGJ@?$AA?$CI?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAr?$AAc?$AA?$CJ?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?$AA@ 0081 ??_C@_1HE@NFPKHHNH@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0087 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0093 __CrtDbgReportW 00a1 __errno 00b8 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 00cc _strncat_s 0120 ??_C@_1FA@MJKDNFFB@?$AA?$CI?$AAL?$AA?$CC?$AAS?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AAi?$AAs?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAn?$AAu?$AAl?$AAl?$AA?5?$AAt?$AAe?$AAr?$AAm?$AAi?$AAn?$AAa?$AAt?$AAe?$AAd@ 014f ??_C@_1BK@GDKGAICE@?$AA_?$AAm?$AAb?$AAs?$AAn?$AAc?$AAa?$AAt?$AA_?$AAs?$AA_?$AAl?$AA?$AA@ 02bf ??_C@_1DM@MADKGDLO@?$AA?$CI?$AAL?$AA?$CC?$AAB?$AAu?$AAf?$AAf?$AAe?$AAr?$AA?5?$AAi?$AAs?$AA?5?$AAt?$AAo?$AAo?$AA?5?$AAs?$AAm?$AAa?$AAl?$AAl?$AA?$CC?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA0?$AA?$CJ?$AA?$AA@ 0300 __invalid_parameter 036a ??_C@_1FC@NCPEPIBI@?$AA?$CI?$AA?$CI?$AA_?$AAD?$AAs?$AAt?$AA?$CJ?$AA?$CJ?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAN?$AAU?$AAL?$AAL?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA?$CI?$AA?$CI?$AA_?$AAS?$AAi?$AAz?$AAe?$AAI?$AAn?$AAB?$AAy?$AAt@"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 83 65 F8 00 8B 45 14 53 56 57 8B 7D 08 85 C0 75 12 85 FF 75 16 39 7D 0C 0F 85 43 03 00 00 E9 82 03 00 00 85 FF 0F 84 36 03 00 00 8B 75 0C 85 F6 0F 84 2B 03 00 00 8B 5D 10 85 C0 74 6C 85 DB 75 68 88 1F 83 FE FF 74 2B 81 FE FF FF FF 7F 74 23 83 FE 01 76 1E E8 ?? ?? ?? ?? 4E 3B C6 72 02 8B C6 50 8D 47 01 68 FE 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C BB ?? ?? ?? ?? BF ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 6A 00 6A 1E 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 16 5E 6A 00 6A 1E E9 E9 02 00 00 FF 75 18 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 EC 83 78 08 00 75 15 FF 75 14 53 56 57 E8 ?? ?? ?? ?? 83 C4 10 8B F0 E9 7D 02 00 00 8B CF 8B DE 80 39 00 74 06 41 83 EB 01 75 F5 85 DB 75 70 88 1F 83 FE FF 74 2B 81 FE FF FF FF 7F 74 23 83 FE 01 76 1E E8 ?? ?? ?? ?? 4E 3B C6 72 02 8B C6 50 8D 47 01 68 FE 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 6A 39 BF ?? ?? ?? ?? 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 16 5E 53 6A 39 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 A0 01 00 00 3B DE 73 38 8D 41 FF 89 45 F4 8B D0 3B C7 72 18 8B 75 EC 0F B6 02 F6 44 30 19 04 74 05 4A 3B D7 73 F1 8B 75 0C 8B 45 F4 2B C2 A8 01 74 0E 8B 4D F4 43 C7 45 F8 01 00 00 00 C6 01 00 8B 45 14 83 F8 FF 75 16 8B 55 10 2B CA 8A 02 88 04 11 42 84 C0 74 72 83 EB 01 75 F1 EB 6B 85 C0 74 64 8B 55 10 8B 75 EC 0F B6 02 F6 44 30 19 04 8B 75 0C 74 20 80 7A 01 00 74 3A 83 FB 02 76 31 8A 02 88 01 8A 42 01 83 C2 02 88 41 01 83 C1 02 83 EB 02 EB 0F 8A 02 88 01 41 42 84 C0 74 20 83 EB 01 74 1B 8B 45 14 83 E8 01 89 45 14 75 B6 EB 11 33 DB EB 0A C6 01 00 C7 45 F8 01 00 00 00 8B 45 14 85 C0 75 03 C6 01 00 85 DB 0F 85 DF 00 00 00 83 7D 14 FF 75 5A 39 5D F8 74 0B E8 ?? ?? ?? ?? C7 00 2A 00 00 00 83 FE 01 76 38 8D 56 FE 03 D7 8B CA 3B D7 72 12 8B 5D EC 0F B6 01 F6 44 18 19 04 74 05 49 3B CF 73 F1 8B C2 2B C1 A8 01 74 13 C6 02 00 E8 ?? ?? ?? ?? 85 C0 74 0C C6 44 37 FF FE EB 05 C6 44 37 FF 00 6A 50 5E E9 CD 00 00 00 33 DB 88 1F 83 FE FF 74 2B 81 FE FF FF FF 7F 74 23 83 FE 01 76 1E E8 ?? ?? ?? ?? 4E 3B C6 72 02 8B C6 50 8D 47 01 68 FE 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 68 B3 00 00 00 BF ?? ?? ?? ?? 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 22 5E 53 68 B3 00 00 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 83 C4 14 EB 4E 83 FE FF 74 35 81 FE FF FF FF 7F 74 2D 8B C6 2B C3 40 3B C6 73 24 E8 ?? ?? ?? ?? 8D 4B FF 3B C1 72 02 8B C1 50 2B FB 8D 46 01 03 C7 68 FE 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C 83 7D F8 00 74 0C E8 ?? ?? ?? ?? 6A 2A 5E 89 30 EB 02 33 F6 80 7D F0 00 74 4E 8B 4D E4 83 A1 50 03 00 00 FD EB 42 BB ?? ?? ?? ?? BF ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 6A 00 6A 1B 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 16 5E 6A 00 6A 1B 57 68 ?? ?? ?? ?? 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "_realloc"
		size = 29
		refs = "0014 __realloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_291_1_0 {
	meta:
		name = "__expand"
		size = 29
		refs = "0014 __expand_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_465_74_0 {
	meta:
		name = "__tempnam"
		size = 29
		refs = "0014 ??$common_tempnam@D@@YAPADQBD0H0H@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_465_76_0 {
	meta:
		name = "__wtempnam"
		size = 29
		refs = "0014 ??$common_tempnam@_W@@YAPA_WQB_W0HQBDH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_532_0_0 {
	meta:
		name = "_calloc"
		size = 29
		refs = "0014 __calloc_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 6A 00 6A 00 6A 01 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__FCbuild"
		size = 58
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 08 B8 04 00 00 00 6B C8 00 D9 45 08 D9 5C 0D F8 BA 04 00 00 00 C1 E2 00 D9 45 0C D9 5C 15 F8 B8 04 00 00 00 6B C8 00 8B 44 0D F8 8B 54 0D FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_161_1_0 {
	meta:
		name = "_cprojf"
		size = 190
		refs = "0011 _crealf 0024 _cimagf 0033 __fdtest 0085 __FZero_C 009f __FInf_C 00a7 __FCbuild"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 D9 5D EC 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 D9 5D F4 8D 4D EC 51 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 FC 8D 55 F4 52 E8 ?? ?? ?? ?? 83 C4 04 66 89 45 F8 0F BF 45 FC 83 F8 01 74 17 0F BF 4D F8 83 F9 01 74 0E 8B 55 08 89 55 E4 8B 45 0C 89 45 E8 EB 46 B9 02 00 00 00 C1 E1 00 0F B7 54 0D F4 81 E2 00 80 00 00 74 0D D9 05 ?? ?? ?? ?? D9 E0 D9 5D F0 EB 05 D9 EE D9 5D F0 51 D9 45 F0 D9 1C 24 51 D9 05 ?? ?? ?? ?? D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 89 45 E4 89 55 E8 8B 45 E4 8B 55 E8 8B E5 5D C3 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "___libm_sse2_atan2"
		size = 1302
		refs = "013d _a2 0145 _b2 0155 _P_TBL 015e _SGN_TBL 0176 _ATAN_TBL 0223 _P_TBL2 023c _SELECT_B 02d2 _SGNMASK 02da _pi_table 02f2 _pi2_table 032b _POW55 0338 _INVEXPMASK 0344 _EXPMASK 043a _pi4_table"
	strings:
		$1 = { 83 EC 14 66 0F C5 C0 03 25 F0 7F 00 00 66 0F 13 44 24 04 2D 70 38 00 00 3D 00 0F 00 00 66 0F 13 4C 24 0C 0F 87 D2 02 00 00 66 0F C5 C1 03 25 F0 7F 00 00 2D 70 38 00 00 3D 00 0F 00 00 0F 87 B8 02 00 00 66 0F 14 C1 66 0F 57 ED 66 0F 57 DB B8 00 08 00 00 66 0F C4 E8 03 66 0F FD E9 66 0F 73 D5 1D F3 0F 53 DD 66 0F 57 E4 B9 00 38 00 00 66 0F C4 E1 03 66 0F 73 F3 1D 66 0F FD DC F2 0F 59 D8 66 0F 57 D2 66 0F 57 F6 66 0F 57 FF B8 00 80 00 00 66 0F C4 F0 02 B9 FF 7F 00 00 66 0F C4 F9 03 66 0F FE DE 66 0F 54 DF F2 0F 10 EB 66 0F C5 C3 03 B9 40 40 00 00 66 0F C4 D1 03 F2 0F 5D DA 66 0F 50 D0 66 0F 73 F0 01 66 0F 73 D0 01 F2 0F C2 EA 02 66 0F 73 F1 01 66 0F 73 D1 01 F2 0F 10 F1 F2 0F 10 F9 F2 0F 10 D0 B9 00 00 00 00 66 0F C4 F1 00 F2 0F 5C FE F2 0F 10 E0 F2 0F 59 F3 F2 0F 59 E3 F2 0F 59 FB 66 0F 54 C5 F2 0F 5C C6 66 0F 54 CD F2 0F 58 E1 F2 0F 5C C7 25 F0 7F 00 00 2D 9E 3F 00 00 3D 61 04 00 00 0F 87 AE 00 00 00 F2 0F 5E C4 66 0F C5 CB 03 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F C5 C5 00 03 D2 66 0F 28 34 D5 ?? ?? ?? ?? 66 0F 28 0C D5 ?? ?? ?? ?? 81 E9 9E 3F 00 00 F7 D0 83 E0 01 03 C8 03 C9 66 0F 28 2C CD ?? ?? ?? ?? 66 0F 57 E9 66 0F 58 EE F2 0F 10 F5 66 0F 15 ED 83 C4 14 66 0F 57 C8 F2 0F 10 E1 F2 0F 59 C0 F2 0F 59 D0 F2 0F 58 D8 F2 0F 58 CE F2 0F 5C F1 F2 0F 58 F4 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 D8 F2 0F 59 E0 F2 0F 58 F5 F2 0F 59 D4 F2 0F 58 1D ?? ?? ?? ?? F2 0F 59 D3 F2 0F 58 D6 F2 0F 58 CA 66 0F 28 C1 C3 05 AE 03 00 00 3D AE 03 00 00 0F 87 A3 00 00 00 66 0F 57 E4 B9 F0 3F 00 00 66 0F C4 E1 03 F2 0F 5E E1 83 C4 14 03 D2 66 0F 28 34 D5 ?? ?? ?? ?? 66 0F 14 DB 66 0F 57 C6 66 0F 57 D6 66 0F 57 DE 66 0F 28 3C D5 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? 66 0F 54 1C D5 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 59 C4 F2 0F 10 F2 F2 0F 59 D2 F2 0F 59 CA F2 0F 58 EA F2 0F 59 F2 F2 0F 58 0D ?? ?? ?? ?? F2 0F 59 EA F2 0F 58 F8 66 0F 58 FB F2 0F 59 CE F2 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 F2 0F 58 EF 66 0F 15 FF F2 0F 58 EF 66 0F 28 C5 C3 66 0F 12 4C 24 0C 66 0F 12 44 24 04 66 0F C5 C1 03 25 F0 7F 00 00 66 0F C5 C8 03 81 E1 F0 7F 00 00 3B C8 7F 2D 66 0F C5 C9 03 81 F9 FF 7F 00 00 7F 08 83 C4 14 F2 0F 5E C1 C3 83 C4 14 66 0F 54 05 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 57 C2 C3 83 C4 14 66 0F 54 05 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 57 C2 C3 66 0F C5 C8 03 81 E1 F0 7F 00 00 66 0F C5 C1 03 25 F0 7F 00 00 81 F9 F0 7F 00 00 0F 84 A5 00 00 00 3D F0 7F 00 00 0F 84 52 01 00 00 66 0F 12 1D ?? ?? ?? ?? BA 00 04 00 00 66 0F 12 25 ?? ?? ?? ?? 66 0F 57 F6 66 0F 12 3D ?? ?? ?? ?? 83 F9 00 74 35 83 F8 00 74 50 03 D1 2B D0 81 FA 00 08 00 00 0F 87 2F FF FF FF 81 C2 F0 3B 00 00 66 0F C4 F2 03 66 0F 54 C4 66 0F 54 CC 66 0F 56 C6 66 0F 56 CF E9 C1 FC FF FF 81 EA 70 03 00 00 F2 0F 59 C3 66 0F C5 C8 03 81 E1 F0 7F 00 00 83 F9 00 0F 84 2A 01 00 00 EB AB 81 C2 70 03 00 00 F2 0F 59 CB 66 0F C5 C1 03 25 F0 7F 00 00 83 F8 00 0F 84 34 01 00 00 EB 91 66 0F 7E C2 F2 0F 10 D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B CA 83 F9 00 75 26 66 0F 73 D0 3F 66 0F 73 F0 3F 3D F0 7F 00 00 73 19 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 83 C4 14 C3 66 0F 7E C8 F2 0F 10 D1 66 0F 73 D2 20 66 0F 7E D1 BA 00 00 00 80 23 D1 81 E1 FF FF 0F 00 0B C8 83 F9 00 75 1E 83 FA 00 75 21 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 C3 83 C4 14 F2 0F 10 C1 C3 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 58 EE 66 0F 70 F5 EE 66 0F 58 EE 66 0F 56 C5 C3 66 0F 7E C8 F2 0F 10 D1 66 0F 73 D2 20 66 0F 7E D1 BA 00 00 00 80 23 D1 81 E1 FF FF 0F 00 0B C8 83 F9 00 75 AE 66 0F 73 D0 3F 66 0F 73 F0 3F 83 FA 00 75 04 83 C4 14 C3 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 C3 66 0F C5 D1 03 81 E2 00 80 00 00 83 FA 00 74 15 66 0F 28 2D ?? ?? ?? ?? 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 83 C4 14 C3 83 C4 14 66 0F 28 2D ?? ?? ?? ?? 66 0F 73 D0 3F 66 0F 73 F0 3F 66 0F 70 E5 EE F2 0F 58 EC 66 0F 56 C5 C3 }
	condition:
		$1
}

rule file_164_5_0 {
	meta:
		name = "__mbcjistojms_l"
		size = 149
		refs = "000f ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0075 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F8 81 78 04 A4 03 00 00 74 05 8B 45 08 EB 5D 8B 4D 08 8B C1 C1 E8 08 0F B6 D0 0F B6 C9 8D 42 DF 83 F8 5D 77 3A 8D 41 DF 83 F8 5D 77 32 F6 C2 01 74 0F 83 F9 5F 77 05 83 C1 1F EB 08 83 C1 20 EB 03 83 C1 7E 8D 42 DF D1 E8 05 81 00 00 00 3D 9F 00 00 00 76 03 83 C0 40 C1 E0 08 0B C1 EB 0D E8 ?? ?? ?? ?? C7 00 2A 00 00 00 33 C0 80 7D FC 00 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B E5 5D C3 }
	condition:
		$1
}

rule file_164_7_0 {
	meta:
		name = "__mbcjmstojis_l"
		size = 197
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 00a1 __errno"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 56 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 55 F8 81 7A 04 A4 03 00 00 74 08 8B 55 08 E9 86 00 00 00 8B 4D 08 8B C1 C1 E8 08 53 0F B6 D8 0F B6 C9 F6 44 13 19 04 74 62 F6 44 11 19 08 74 5B 81 FB A0 00 00 00 6A 7E 1B C0 83 E0 C0 05 C1 00 00 00 2B D8 5E 81 F9 9F 00 00 00 72 0D 8D 53 11 C1 E2 09 8D 41 82 0B D0 EB 18 3B F1 8B D1 1B C0 C1 E3 09 F7 D8 81 C3 00 21 00 00 83 C0 1F 2B D0 0B D3 8D 82 DF DE FF FF 3D 5D 5D 00 00 77 0C 0F B6 C2 3B C6 77 05 83 F8 21 73 0D E8 ?? ?? ?? ?? 33 D2 C7 00 2A 00 00 00 5B 80 7D FC 00 5E 74 0A 8B 4D F0 83 A1 50 03 00 00 FD 8B C2 8B E5 5D C3 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "__fdlog"
		size = 448
		refs = "0011 __fdunscale 003d __fperrraise 0046 __FInf_C 008e __FNan_C 00a1 _rthalf 00c8 __real@3ff0000000000000 00f1 _p 0137 _loge2lo 0146 _loge2hi 015c _logxehi 0165 _logxelo 016e _logxe 0177 _logx2lo 0186 _logx2hi 0196 _log2ehi 019f _log2elo 01a8 _log2e"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 18 8D 45 08 50 8D 4D FC 51 E8 ?? ?? ?? ?? 83 C4 08 0F BF D0 89 55 EC 83 7D EC 00 74 16 83 7D EC 01 74 27 83 7D EC 02 74 02 EB 3C D9 45 08 E9 82 01 00 00 6A 04 E8 ?? ?? ?? ?? 83 C4 04 D9 05 ?? ?? ?? ?? D9 E0 E9 6B 01 00 00 B8 02 00 00 00 C1 E0 00 0F B7 4C 05 08 81 E1 00 80 00 00 75 08 D9 45 08 E9 4E 01 00 00 BA 02 00 00 00 C1 E2 00 0F B7 44 15 08 25 00 80 00 00 74 1A 6A 01 E8 ?? ?? ?? ?? 83 C4 04 D9 05 ?? ?? ?? ?? E9 25 01 00 00 E9 20 01 00 00 D9 45 08 D9 05 ?? ?? ?? ?? DE D9 DF E0 F6 C4 41 75 15 D9 45 08 D8 45 08 D9 5D 08 66 8B 4D FC 66 83 E9 01 66 89 4D FC D9 45 08 DC 25 ?? ?? ?? ?? D9 5D F0 D9 45 08 DC 05 ?? ?? ?? ?? D8 7D F0 D9 5D F8 D9 45 F8 D8 4D F8 D9 5D F4 BA 04 00 00 00 6B C2 00 D9 80 ?? ?? ?? ?? D8 4D F4 B9 04 00 00 00 C1 E1 00 D8 81 ?? ?? ?? ?? D8 4D F4 BA 04 00 00 00 D1 E2 D8 82 ?? ?? ?? ?? D8 4D F4 D8 6D F0 D8 4D F8 D9 5D F8 0F BF 45 FC 89 45 E8 DB 45 E8 D9 5D F4 83 7D 0C 00 75 1F D9 05 ?? ?? ?? ?? D8 4D F4 D8 6D F8 D8 6D F0 D9 05 ?? ?? ?? ?? D8 4D F4 DE C1 D9 5D F8 EB 65 83 7D 0C 00 7E 3A D9 05 ?? ?? ?? ?? D8 4D F0 D9 05 ?? ?? ?? ?? D8 4D F0 D9 05 ?? ?? ?? ?? D8 4D F8 D9 05 ?? ?? ?? ?? D8 4D F4 DE E9 DE E9 DE C1 D9 05 ?? ?? ?? ?? D8 4D F4 DE C1 D9 5D F8 EB 25 D9 05 ?? ?? ?? ?? D8 4D F0 D9 05 ?? ?? ?? ?? D8 4D F0 D9 05 ?? ?? ?? ?? D8 4D F8 DE E9 DE C1 D8 45 F4 D9 5D F8 D9 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_166_1_0 {
	meta:
		name = "__fdlogpoly"
		size = 63
		refs = "0010 _p"
	strings:
		$1 = { 8B FF 55 8B EC 51 B8 04 00 00 00 6B C8 00 D9 81 ?? ?? ?? ?? D8 4D 08 BA 04 00 00 00 C1 E2 00 D8 82 ?? ?? ?? ?? D8 4D 08 B8 04 00 00 00 D1 E0 D8 80 ?? ?? ?? ?? D9 5D FC D9 45 FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_166_2_0 {
	meta:
		name = "_log2f"
		size = 24
		refs = "000f __fdlog"
	strings:
		$1 = { 8B FF 55 8B EC 6A FF 51 D9 45 08 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 08 5D C3 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "_fminl"
		size = 117
		refs = "000a __ldtest"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 83 F9 02 75 07 DD 45 10 EB 55 EB 53 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 98 83 F8 02 75 07 DD 45 08 EB 3C EB 3A DD 45 10 DC 5D 08 DF E0 F6 C4 41 74 23 DD 45 08 DD 45 10 DA E9 DF E0 F6 C4 44 7A 1B B9 02 00 00 00 6B D1 03 0F B7 44 15 08 25 00 80 00 00 74 07 DD 45 08 EB 05 EB 03 DD 45 10 5D C3 }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "_fmin"
		size = 117
		refs = "000a __dtest"
	strings:
		$1 = { 8B FF 55 8B EC 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 04 0F BF C8 83 F9 02 75 07 DD 45 10 EB 55 EB 53 8D 55 10 52 E8 ?? ?? ?? ?? 83 C4 04 98 83 F8 02 75 07 DD 45 08 EB 3C EB 3A DD 45 10 DC 5D 08 DF E0 F6 C4 41 74 23 DD 45 08 DD 45 10 DA E9 DF E0 F6 C4 44 7A 1B B9 02 00 00 00 6B D1 03 0F B7 44 15 08 25 00 80 00 00 74 07 DD 45 08 EB 05 EB 03 DD 45 10 5D C3 }
	condition:
		$1
}

rule file_169_0_0 {
	meta:
		name = "__cgets"
		size = 214
		refs = "0018 ??_C@_1CE@BLLJFLOH@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0020 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0028 ??_C@_1GG@DDLAFINI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0030 __CrtDbgReportW 003e ___doserrno 0045 __errno 004e ??_C@_1O@ECBOLGNI@?$AA_?$AAc?$AAg?$AAe?$AAt?$AAs?$AA?$AA@ 005a __invalid_parameter 0073 ??_C@_1BM@OHODNOMF@?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?$FL?$AA0?$AA?$FN?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 00ba __cgets_s"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 33 C0 57 8B 7D 08 85 FF 0F 95 C0 85 C0 75 4E BB ?? ?? ?? ?? 33 F6 53 68 ?? ?? ?? ?? 56 6A 6F BF ?? ?? ?? ?? 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 56 6A 6F 57 68 ?? ?? ?? ?? 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 6A 8A 0F 33 C0 84 C9 0F 9F C0 85 C0 75 37 BB ?? ?? ?? ?? 33 F6 53 68 ?? ?? ?? ?? 56 6A 70 BF ?? ?? ?? ?? 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 56 6A 70 EB A3 83 65 FC 00 8D 77 02 0F BE C1 8D 4D FC 51 50 56 E8 ?? ?? ?? ?? 8A 4D FC 83 C4 0C F7 D8 88 4F 01 1B C0 F7 D0 23 C6 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_169_1_0 {
	meta:
		name = "__cgets_s"
		size = 541
		refs = "0003 __sehtable$__cgets_s 0008 __SEH_prolog4 001e ??_C@_1DC@FIPIJOED@?$AAs?$AAo?$AAu?$AAr?$AAc?$AAe?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0023 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002b ??_C@_1GG@DDLAFINI@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAd?$AAe?$AAs?$AAk?$AAt?$AAo?$AAp?$AAc@ 0032 __CrtDbgReportW 004a ___doserrno 0051 __errno 0061 ??_C@_1BC@OKPCLJOH@?$AA_?$AAc?$AAg?$AAe?$AAt?$AAs?$AA_?$AAs?$AA?$AA@ 006d __invalid_parameter 008c ??_C@_1CE@KOGJHKKC@?$AAs?$AAi?$AAz?$AAe?$AA_?$AAi?$AAn?$AA_?$AAb?$AAy?$AAt?$AAe?$AAs?$AA?5?$AA?$DO?$AA?5?$AA0?$AA?$AA@ 00ec __CrtGetDebugFillThreshold 0104 _memset 011b ??_C@_1CK@FMNNCIHC@?$AAs?$AAi?$AAz?$AAe?$AA_?$AAr?$AAe?$AAa?$AAd?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0172 ___acrt_lock 0193 __cgetws_s 01b8 _wctomb_s 01dd ___console_wchar_buffer 01e3 ___console_wchar_buffer_used 0207 __SEH_epilog4 0217 ___acrt_unlock"
	strings:
		$1 = { 6A 20 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 8B 75 08 85 F6 0F 95 C3 89 5D D4 85 DB 75 24 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 6A 20 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 05 CC EB 02 33 DB 83 7D D4 00 75 32 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 6A 16 5E 53 6A 20 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 8B 01 00 00 33 C0 8B 7D 0C 3B C7 1B C0 F7 D8 89 45 E0 75 25 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 6A 21 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B 45 E0 85 C0 75 23 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 6A 16 5E 53 6A 21 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 93 88 1E 83 FF FF 74 2D 81 FF FF FF FF 7F 74 25 83 FF 01 76 20 E8 ?? ?? ?? ?? 8D 4F FF 3B C1 72 02 8B C1 50 68 FE 00 00 00 8D 46 01 50 E8 ?? ?? ?? ?? 83 C4 0C 33 C0 39 45 10 0F 95 C0 89 45 E0 85 C0 75 4F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 6A 24 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 8B 45 E0 85 C0 75 26 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 6A 16 5E 53 6A 24 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 01 FF FF FF 89 5D D8 89 75 D4 6A 09 E8 ?? ?? ?? ?? 59 89 5D FC 8B 45 10 89 18 8D 47 FF 89 45 E4 89 5D D0 8D 45 D0 50 6A 02 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 0C 8B F8 89 7D D8 85 FF 75 48 66 39 45 E0 74 42 89 5D DC FF 75 E0 FF 75 E4 56 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 14 8B 45 DC 03 F0 89 75 D4 8B 4D 10 01 01 29 45 E4 75 B0 EB 14 66 8B 45 E0 66 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 C7 45 FC FE FF FF FF E8 1D 00 00 00 88 1E 85 FF 74 07 E8 ?? ?? ?? ?? 89 38 8B C7 E8 ?? ?? ?? ?? C3 33 DB 8B 7D D8 8B 75 D4 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "__fdpow"
		size = 2363
		refs = "000c ___security_cookie 0032 __fdunscale 0044 __fd_int 0089 __real@3fe0000000000000 00a4 __real@bfe0000000000000 013f __FInf_C 01d3 __FZero_C 02df __fperrraise 0369 __FNan_C 0377 __real@0000000000000000 03a9 ?rthalf@?1??_fdpow@@9@9 03cf __real@3ff0000000000000 0404 __fdlogpoly 043e ?ln2@?1??_fdpow@@9@9 0452 ?maxexp@?1??_fdpow@@9@9 0474 __real@c028000000000000 0488 __real@4028000000000000 049c __real@c044000000000000 04b0 __real@4044000000000000 04f6 __ftol2_sse 05f7 __fdxp_setw 0625 __fdxp_addx 065f _log2e 0668 _memcpy 0686 __fdxp_mulh 073a __fdxp_addh 0866 __fdxp_getw 08bc __fdexp 0933 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC E0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC D9 45 0C D9 5D 98 C7 45 90 00 00 00 00 C7 45 94 00 00 00 00 8D 45 08 50 8D 4D 9C 51 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 A8 6A 00 8D 55 98 52 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 A0 83 7D 10 00 74 08 33 C0 8B 4D 10 66 89 01 0F BF 55 A0 85 D2 75 0E D9 45 0C D9 EE DA E9 DF E0 F6 C4 44 7B 3E 0F BF 45 A8 85 C0 7D 42 0F BF 4D 9C 83 F9 01 75 39 D9 45 08 DD 05 ?? ?? ?? ?? DA E9 DF E0 F6 C4 44 7B 1B 0F BF 55 A0 83 FA 01 75 1E D9 45 08 DD 05 ?? ?? ?? ?? DA E9 DF E0 F6 C4 44 7A 0C D9 E8 E9 75 08 00 00 E9 B5 02 00 00 0F BF 45 A8 85 C0 7D 0C 0F BF 4D A0 85 C9 0F 8E 6F 02 00 00 0F BF 55 A8 83 FA 02 75 0D D9 45 08 E9 4B 08 00 00 E9 57 02 00 00 0F BF 45 A0 83 F8 02 75 0D D9 45 0C E9 35 08 00 00 E9 41 02 00 00 0F BF 4D A8 83 F9 01 0F 85 EF 00 00 00 BA 02 00 00 00 C1 E2 00 0F B7 44 15 08 25 00 80 00 00 75 3B B9 02 00 00 00 C1 E1 00 0F B7 54 0D 0C 81 E2 00 80 00 00 74 0A D9 EE D9 9D 7C FF FF FF EB 0C D9 05 ?? ?? ?? ?? D9 9D 7C FF FF FF D9 85 7C FF FF FF E9 D9 07 00 00 E9 9B 00 00 00 B8 02 00 00 00 C1 E0 00 0F B7 4C 05 0C 81 E1 00 80 00 00 75 46 0F BF 55 A0 85 D2 75 25 6A FF 8D 45 98 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 85 C9 7D 10 D9 05 ?? ?? ?? ?? D9 E0 D9 9D 78 FF FF FF EB 0C D9 05 ?? ?? ?? ?? D9 9D 78 FF FF FF D9 85 78 FF FF FF E9 7B 07 00 00 EB 40 0F BF 55 A0 85 D2 75 25 6A FF 8D 45 98 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 85 C9 7D 10 D9 05 ?? ?? ?? ?? D9 E0 D9 9D 74 FF FF FF EB 08 D9 EE D9 9D 74 FF FF FF D9 85 74 FF FF FF E9 39 07 00 00 E9 45 01 00 00 0F BF 55 A0 83 FA 01 75 6E B8 02 00 00 00 C1 E0 00 0F B7 4C 05 0C 81 E1 00 80 00 00 75 2B 0F BF 55 9C 85 D2 7F 0A D9 EE D9 9D 70 FF FF FF EB 0C D9 05 ?? ?? ?? ?? D9 9D 70 FF FF FF D9 85 70 FF FF FF E9 ED 06 00 00 EB 29 0F BF 45 9C 85 C0 7F 0E D9 05 ?? ?? ?? ?? D9 9D 5C FF FF FF EB 08 D9 EE D9 9D 5C FF FF FF D9 85 5C FF FF FF E9 C2 06 00 00 E9 CE 00 00 00 B9 02 00 00 00 C1 E1 00 0F B7 54 0D 0C 81 E2 00 80 00 00 75 57 0F BF 45 A0 85 C0 75 3A 6A FF 8D 4D 98 51 E8 ?? ?? ?? ?? 83 C4 08 0F BF D0 85 D2 7D 25 B8 02 00 00 00 C1 E0 00 0F B7 4C 05 08 81 E1 00 80 00 00 74 10 D9 05 ?? ?? ?? ?? D9 E0 D9 9D 60 FF FF FF EB 08 D9 EE D9 9D 60 FF FF FF D9 85 60 FF FF FF E9 53 06 00 00 EB 62 6A 04 E8 ?? ?? ?? ?? 83 C4 04 0F BF 55 A0 85 D2 75 39 6A FF 8D 45 98 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 85 C9 7D 24 BA 02 00 00 00 C1 E2 00 0F B7 44 15 08 25 00 80 00 00 74 10 D9 05 ?? ?? ?? ?? D9 E0 D9 9D 64 FF FF FF EB 0C D9 05 ?? ?? ?? ?? D9 9D 64 FF FF FF D9 85 64 FF FF FF E9 EF 05 00 00 EB 32 B9 02 00 00 00 C1 E1 00 0F B7 54 0D 08 81 E2 00 80 00 00 74 1D 0F BF 45 A0 85 C0 7D 15 6A 01 E8 ?? ?? ?? ?? 83 C4 04 D9 05 ?? ?? ?? ?? E9 BB 05 00 00 D9 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 08 33 C9 66 89 4D 8C EB 1A D9 45 08 D9 E0 D9 5D 08 6A FF 8D 55 98 52 E8 ?? ?? ?? ?? 83 C4 08 66 89 45 8C D9 45 08 D9 05 ?? ?? ?? ?? DE D9 DF E0 F6 C4 41 75 14 D9 45 08 DC C0 D9 5D 08 66 8B 45 9C 66 83 E8 01 66 89 45 9C D9 45 08 DC 25 ?? ?? ?? ?? D9 45 08 DC 05 ?? ?? ?? ?? DE F9 D9 5D 84 D9 45 84 D8 4D 84 D9 9D 68 FF FF FF D9 45 08 DC 25 ?? ?? ?? ?? D9 5D 08 51 D9 85 68 FF FF FF D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D8 8D 68 FF FF FF D8 65 08 D8 4D 84 D9 5D 80 0F BF 4D 9C 89 8D 54 FF FF FF DB 85 54 FF FF FF D9 9D 50 FF FF FF D9 85 50 FF FF FF D9 45 08 D8 45 80 D8 35 ?? ?? ?? ?? DE C1 D9 5D 98 D9 45 0C D8 4D 98 D9 5D A4 D9 05 ?? ?? ?? ?? D9 E0 D9 45 A4 DE D9 DF E0 F6 C4 05 7A 0B 33 D2 66 89 55 A8 E9 1F 04 00 00 D9 45 A4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 0F 85 46 01 00 00 D9 45 A4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 0F 8A 32 01 00 00 D9 45 0C DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 0F 85 1E 01 00 00 D9 45 0C DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 0F 8A 0A 01 00 00 D9 45 A4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 11 D9 45 A4 DC 25 ?? ?? ?? ?? DD 9D 28 FF FF FF EB 0F D9 45 A4 DC 05 ?? ?? ?? ?? DD 9D 28 FF FF FF DD 85 28 FF FF FF E8 ?? ?? ?? ?? 89 45 94 D9 45 08 D8 45 80 D8 4D 0C D9 5D A4 83 7D 90 00 75 3C 0F BF 45 9C 89 85 4C FF FF FF DB 85 4C FF FF FF D9 9D 48 FF FF FF D9 85 48 FF FF FF D8 4D 0C DB 45 94 D9 9D 44 FF FF FF D8 A5 44 FF FF FF D8 0D ?? ?? ?? ?? D8 45 A4 D9 5D A4 EB 72 B9 04 00 00 00 C1 E1 00 BA 04 00 00 00 D1 E2 8B 45 90 D9 04 08 8B 4D 90 D8 04 11 D8 4D 0C D8 0D ?? ?? ?? ?? D8 45 A4 D9 5D A4 0F BF 55 9C 89 95 40 FF FF FF DB 85 40 FF FF FF D9 9D 3C FF FF FF D9 85 3C FF FF FF B8 04 00 00 00 6B C8 00 8B 55 90 D8 04 0A D8 4D 0C DB 45 94 D9 9D 38 FF FF FF D8 A5 38 FF FF FF D8 0D ?? ?? ?? ?? D8 45 A4 D9 5D A4 83 C8 FF 66 89 45 A8 E9 C5 02 00 00 D9 05 ?? ?? ?? ?? D9 45 A4 DE D9 DF E0 F6 C4 41 75 0E B9 01 00 00 00 66 89 4D A8 E9 A5 02 00 00 51 D9 45 08 D9 1C 24 6A 04 8D 55 DC 52 E8 ?? ?? ?? ?? 83 C4 08 D9 45 80 D9 1C 24 6A 02 8D 85 20 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 02 8D 8D 20 FF FF FF 51 6A 04 8D 55 DC 52 E8 ?? ?? ?? ?? 83 C4 10 B8 04 00 00 00 6B C8 00 D9 44 0D DC D9 EE DA E9 DF E0 F6 C4 44 7A 19 51 D9 EE D9 1C 24 6A 04 8D 55 CC 52 E8 ?? ?? ?? ?? 83 C4 0C E9 9D 00 00 00 6A 10 68 ?? ?? ?? ?? 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 0C B9 04 00 00 00 6B D1 00 51 D9 44 15 DC D9 1C 24 6A 04 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 0C C7 45 88 01 00 00 00 EB 09 8B 4D 88 83 C1 01 89 4D 88 83 7D 88 04 7D 54 8B 55 88 D9 44 95 DC D9 EE DA E9 DF E0 F6 C4 44 7B 42 6A 10 68 ?? ?? ?? ?? 8D 45 AC 50 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 88 51 D9 44 8D DC D9 1C 24 6A 04 8D 55 AC 52 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 8D 45 AC 50 6A 04 8D 4D CC 51 E8 ?? ?? ?? ?? 83 C4 10 EB 9D 83 7D 90 00 74 14 6A 03 8B 55 90 52 6A 04 8D 45 CC 50 E8 ?? ?? ?? ?? 83 C4 10 0F BF 4D 9C 89 8D 34 FF FF FF DB 85 34 FF FF FF D9 9D 30 FF FF FF D9 85 30 FF FF FF 51 D9 1C 24 6A 04 8D 55 CC 52 E8 ?? ?? ?? ?? 83 C4 08 D9 45 0C D9 1C 24 6A 02 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 10 8D 4D CC 51 8D 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C B8 04 00 00 00 6B C8 00 51 D9 44 0D DC D9 1C 24 6A 04 8D 55 EC 52 E8 ?? ?? ?? ?? 83 C4 0C B8 04 00 00 00 C1 E0 00 D9 44 05 DC D9 EE DA E9 DF E0 F6 C4 44 7B 44 6A 10 8D 4D CC 51 8D 55 BC 52 E8 ?? ?? ?? ?? 83 C4 0C B8 04 00 00 00 C1 E0 00 51 D9 44 05 DC D9 1C 24 6A 04 8D 4D BC 51 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 8D 55 BC 52 6A 04 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 10 B9 04 00 00 00 6B D1 00 D9 44 15 EC D9 5D 08 B8 04 00 00 00 6B C8 00 D9 44 0D EC D9 EE DA E9 DF E0 F6 C4 44 7B 34 BA 04 00 00 00 C1 E2 00 D9 44 15 EC D9 EE DA E9 DF E0 F6 C4 44 7B 1D B8 04 00 00 00 C1 E0 00 B9 04 00 00 00 D1 E1 D9 44 05 EC D8 44 0D EC D8 45 08 D9 5D 08 6A 00 8D 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 D9 45 08 D9 E0 51 D9 1C 24 6A 04 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 04 8D 4D EC 51 E8 ?? ?? ?? ?? 83 C4 08 D9 5D A4 D9 45 A4 D8 0D ?? ?? ?? ?? D9 5D A4 D9 45 08 E8 ?? ?? ?? ?? 89 45 94 83 CA FF 66 89 55 A8 0F BF 45 A8 85 C0 7D 31 83 7D 10 00 74 11 8B 4D 10 66 8B 55 94 66 89 11 C7 45 94 00 00 00 00 8B 45 94 50 51 D9 E8 D9 1C 24 8D 4D A4 51 E8 ?? ?? ?? ?? 83 C4 0C 66 89 45 A8 0F BF 55 A8 89 95 58 FF FF FF 83 BD 58 FF FF FF 00 74 0B 83 BD 58 FF FF FF 01 74 13 EB 24 D9 EE D9 5D A4 6A 10 E8 ?? ?? ?? ?? 83 C4 04 EB 13 D9 05 ?? ?? ?? ?? D9 5D A4 6A 08 E8 ?? ?? ?? ?? 83 C4 04 0F BF 45 8C 85 C0 74 0D D9 45 A4 D9 E0 D9 9D 6C FF FF FF EB 09 D9 45 A4 D9 9D 6C FF FF FF D9 85 6C FF FF FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_170_1_0 {
	meta:
		name = "__fdtgamma"
		size = 517
		refs = "0015 __real@403f000000000000 0029 _stirling 003f __real@bfe0000000000000 0056 __real@3ff0000000000000 006b __real@3fe0000000000000 008f __fdunscale 00d2 __real@3ff8000000000000 00fe __real@4004000000000000 0113 __real@4000000000000000 0180 _s 01c0 _c"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8B 45 08 D9 00 D9 5D FC D9 45 FC DC 1D ?? ?? ?? ?? DF E0 F6 C4 01 75 1A 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 E9 CC 01 00 00 E9 C7 01 00 00 D9 45 FC DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 51 D9 E8 D9 5D F8 EB 0C D9 45 FC DC 05 ?? ?? ?? ?? D9 5D FC D9 45 F8 D8 4D FC D9 5D F8 D9 45 FC DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 02 EB 02 EB D7 D9 45 FC DC 25 ?? ?? ?? ?? D9 5D FC 8D 45 F8 50 8B 4D 0C 51 E8 ?? ?? ?? ?? 83 C4 08 E9 D3 00 00 00 D9 45 FC DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 22 D9 45 FC D9 E8 DE C1 D8 4D FC D9 5D F8 8D 55 F8 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 E9 A1 00 00 00 D9 45 FC DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 1C D9 45 FC D9 5D F8 D9 45 FC DC 25 ?? ?? ?? ?? D9 5D FC 33 C9 8B 55 0C 66 89 0A EB 75 D9 45 FC DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 1B D9 E8 D9 5D F8 D9 45 FC DC 25 ?? ?? ?? ?? D9 5D FC 33 C0 8B 4D 0C 66 89 01 EB 4A D9 E8 D9 5D F8 EB 09 D9 45 F8 D8 75 FC D9 5D F8 D9 45 FC DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 75 0E D9 45 FC DC 25 ?? ?? ?? ?? D9 5D FC EB D9 D9 45 FC DC 25 ?? ?? ?? ?? D9 5D FC 8D 55 F8 52 8B 45 0C 50 E8 ?? ?? ?? ?? 83 C4 08 8B 4D 08 D9 45 F8 D9 19 BA 04 00 00 00 6B C2 00 D9 80 ?? ?? ?? ?? D8 4D FC B9 04 00 00 00 C1 E1 00 D8 81 ?? ?? ?? ?? D8 4D FC BA 04 00 00 00 D1 E2 D8 82 ?? ?? ?? ?? D8 4D FC B8 04 00 00 00 6B C8 03 D8 81 ?? ?? ?? ?? BA 04 00 00 00 6B C2 00 D9 80 ?? ?? ?? ?? D8 4D FC B9 04 00 00 00 C1 E1 00 D8 81 ?? ?? ?? ?? D8 4D FC BA 04 00 00 00 D1 E2 D8 82 ?? ?? ?? ?? D8 4D FC B8 04 00 00 00 6B C8 03 D8 81 ?? ?? ?? ?? DE F9 D8 4D FC D9 5D F4 D9 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_170_3_0 {
	meta:
		name = "_stirling"
		size = 262
		refs = "0019 __real@3fe0000000000000 002f __fdpow 0068 _approx0 00ab __fdpoly 00ec _expf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 1C 8B 45 08 D9 00 D9 5D F8 8B 4D 0C 51 D9 45 F8 DC 25 ?? ?? ?? ?? D9 5D F0 D9 45 F0 51 D9 1C 24 51 D9 45 F8 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 0C D9 5D EC 8B 55 0C 0F BF 02 F7 D8 8B 4D 0C 66 89 01 C7 45 FC 00 00 00 00 EB 09 8B 55 FC 83 C2 01 89 55 FC 83 7D FC 00 73 1A 6B 45 FC 18 D9 45 F8 D9 80 ?? ?? ?? ?? DE D9 DF E0 F6 C4 41 75 02 EB 02 EB D7 D9 45 F8 D9 E8 DE F1 6B 4D FC 18 D8 A1 ?? ?? ?? ?? D9 5D F4 6B 55 FC 18 8B 82 ?? ?? ?? ?? 50 6B 4D FC 18 8B 91 ?? ?? ?? ?? 52 51 D9 45 F4 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 6B 45 FC 18 8B 88 ?? ?? ?? ?? 51 6B 55 FC 18 8B 82 ?? ?? ?? ?? 50 51 D9 45 F4 D9 1C 24 DD 5D E4 E8 ?? ?? ?? ?? 83 C4 0C DC 7D E4 8B 4D 08 D9 19 D9 45 F8 D9 E0 51 D9 1C 24 E8 ?? ?? ?? ?? 83 C4 04 D8 4D EC 8B 55 08 D8 3A 8B 45 08 D9 18 D9 EE 8B E5 5D C3 }
	condition:
		$1
}

rule file_170_4_0 {
	meta:
		name = "_tgammaf"
		size = 667
		refs = "0015 __fd_int 0062 __fperrraise 006b __FNan_C 00a3 __FInf_C 00c6 __real@0000000000000000 00eb __real@c043000000000000 010e __fdgamma_big 0131 __real@3ff0000000000000 0157 __real@bff0000000000000 0173 _pi 0188 __fdsin 01b1 __fdtgamma 01d5 __fdscale 0218 __real@4043000000000000"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 30 D9 45 08 D9 5D F0 6A 00 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 89 4D EC 83 7D EC 00 74 4C 83 7D EC 01 74 13 83 7D EC 02 74 05 E9 AD 00 00 00 D9 45 08 E9 56 02 00 00 BA 02 00 00 00 C1 E2 00 0F B7 44 15 08 25 00 80 00 00 75 0A D9 45 08 E9 3A 02 00 00 EB 15 6A 01 E8 ?? ?? ?? ?? 83 C4 04 D9 05 ?? ?? ?? ?? E9 23 02 00 00 D9 45 08 D9 EE DA E9 DF E0 F6 C4 44 7A 3F 6A 04 E8 ?? ?? ?? ?? 83 C4 04 B9 02 00 00 00 C1 E1 00 0F B7 54 0D 08 81 E2 00 80 00 00 74 0D D9 05 ?? ?? ?? ?? D9 E0 D9 5D E8 EB 09 D9 05 ?? ?? ?? ?? D9 5D E8 D9 45 E8 E9 D8 01 00 00 EB 25 D9 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 15 6A 01 E8 ?? ?? ?? ?? 83 C4 04 D9 05 ?? ?? ?? ?? E9 B1 01 00 00 D9 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 7A 16 6A 10 E8 ?? ?? ?? ?? 83 C4 04 D9 EE E9 90 01 00 00 E9 8B 01 00 00 D9 05 ?? ?? ?? ?? D9 E0 D9 45 08 DE D9 DF E0 F6 C4 05 0F 8A EF 00 00 00 D9 45 08 D9 5D F4 D9 45 08 D9 E0 DC 25 ?? ?? ?? ?? D9 5D E4 D9 45 08 D8 65 F0 D9 5D F0 6A FF 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 08 D9 45 08 D8 65 F4 DC 1D ?? ?? ?? ?? DF E0 F6 C4 05 7A 08 D9 45 F0 D9 E0 D9 5D F0 D9 45 08 D9 E0 6A 00 D9 05 ?? ?? ?? ?? D8 4D F0 D9 5D D8 D9 45 D8 51 D9 1C 24 DD 5D D0 E8 ?? ?? ?? ?? 83 C4 08 DC 4D D0 D9 45 08 D9 E0 DC 25 ?? ?? ?? ?? DE C9 D8 3D ?? ?? ?? ?? D9 5D F4 8D 4D FC 51 8D 55 E4 52 E8 ?? ?? ?? ?? 83 C4 08 D9 E8 DE C1 D8 7D F4 D9 5D F4 D9 45 F4 D8 4D E4 D9 5D F4 0F BF 45 FC 50 8D 4D F4 51 E8 ?? ?? ?? ?? 83 C4 08 0F BF D0 89 55 E0 83 7D E0 00 74 08 83 7D E0 01 74 0E EB 16 6A 10 E8 ?? ?? ?? ?? 83 C4 04 EB 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 D9 45 F4 E9 89 00 00 00 E9 84 00 00 00 D9 45 08 DC 1D ?? ?? ?? ?? DF E0 F6 C4 41 7A 64 8D 45 F8 50 8D 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 D9 5D F0 D9 45 F0 D9 E8 DE C1 D8 75 08 D9 5D 08 0F BF 55 F8 F7 DA 52 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 0F BF C8 89 4D DC 83 7D DC 00 74 08 83 7D DC 01 74 0E EB 16 6A 10 E8 ?? ?? ?? ?? 83 C4 04 EB 0A 6A 08 E8 ?? ?? ?? ?? 83 C4 04 D9 45 08 EB 12 EB 10 6A 08 E8 ?? ?? ?? ?? 83 C4 04 D9 05 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_4_0 {
	meta:
		name = "__wcscoll_l"
		size = 467
		refs = "0010 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0037 ??_C@_1CI@CCKDLILB@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 003c ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0045 ??_C@_1GE@HMGDDFCE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 004c __CrtDbgReportW 0060 __errno 0074 ??_C@_1BG@FHFNCKLD@?$AA_?$AAw?$AAc?$AAs?$AAc?$AAo?$AAl?$AAl?$AA_?$AAl?$AA?$AA@ 007e __invalid_parameter 0090 ??1_LocaleUpdate@@QAE@XZ 00bf ??_C@_1CI@NAPEFFEJ@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0128 ?GetLocaleT@_LocaleUpdate@@QAEPAU__crt_locale_pointers@@XZ 0149 _wcscmp 018c ___acrt_CompareStringW"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 38 8B 45 10 50 8D 4D C8 E8 ?? ?? ?? ?? 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 4D FC 89 4D F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 31 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 31 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E8 FF FF FF 7F 8D 4D C8 E8 ?? ?? ?? ?? 8B 45 E8 E9 33 01 00 00 83 7D 0C 00 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 32 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 3D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 32 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C7 45 E4 FF FF FF 7F 8D 4D C8 E8 ?? ?? ?? ?? 8B 45 E4 E9 AB 00 00 00 8D 4D C8 E8 ?? ?? ?? ?? 8B 10 B8 04 00 00 00 C1 E0 00 83 BC 02 A0 00 00 00 00 75 20 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 08 89 45 E0 8D 4D C8 E8 ?? ?? ?? ?? 8B 45 E0 EB 6F 6A FF 8B 45 0C 50 6A FF 8B 4D 08 51 68 00 10 00 00 8D 4D C8 E8 ?? ?? ?? ?? 8B 10 B8 04 00 00 00 C1 E0 00 8B 8C 02 A0 00 00 00 51 E8 ?? ?? ?? ?? 83 C4 18 89 45 EC 83 7D EC 00 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 C7 45 DC FF FF FF 7F 8D 4D C8 E8 ?? ?? ?? ?? 8B 45 DC EB 14 8B 55 EC 83 EA 02 89 55 D8 8D 4D C8 E8 ?? ?? ?? ?? 8B 45 D8 8B E5 5D C3 }
	condition:
		$1
}

rule file_171_5_0 {
	meta:
		name = "_wcscoll"
		size = 309
		refs = "0009 ___acrt_locale_changed 003b ??_C@_1CI@CCKDLILB@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA1?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0040 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0049 ??_C@_1GE@HMGDDFCE@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAs?$AAr?$AAc?$AA?2?$AAa?$AAp?$AAp?$AAc?$AAr?$AAt?$AA?2?$AAs@ 0050 __CrtDbgReportW 0064 __errno 0078 ??_C@_1BA@KPGOIMMO@?$AAw?$AAc?$AAs?$AAc?$AAo?$AAl?$AAl?$AA?$AA@ 0082 __invalid_parameter 00b6 ??_C@_1CI@NAPEFFEJ@?$AA_?$AAs?$AAt?$AAr?$AAi?$AAn?$AAg?$AA2?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 0114 _wcscmp 012a __wcscoll_l"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 10 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 0F 85 07 01 00 00 83 7D 08 00 74 09 C7 45 FC 01 00 00 00 EB 07 C7 45 FC 00 00 00 00 8B 4D FC 89 4D F8 83 7D F8 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 4F 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F8 00 75 30 E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 4F 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F E9 9E 00 00 00 83 7D 0C 00 74 09 C7 45 F4 01 00 00 00 EB 07 C7 45 F4 00 00 00 00 8B 45 F4 89 45 F0 83 7D F0 00 75 23 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 00 6A 50 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC 83 7D F0 00 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 6A 00 6A 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 26 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 EB 14 EB 12 6A 00 8B 4D 0C 51 8B 55 08 52 E8 ?? ?? ?? ?? 83 C4 0C 8B E5 5D C3 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "_cimagl"
		size = 19
		altNames = "_cimag"
	strings:
		$1 = { 8B FF 55 8B EC B8 08 00 00 00 C1 E0 00 DD 44 05 08 5D C3 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "_normf"
		size = 70
		refs = "0011 _crealf 0024 _cimagf"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C 8B 45 0C 50 8B 4D 08 51 E8 ?? ?? ?? ?? 83 C4 08 D9 5D FC 8B 55 0C 52 8B 45 08 50 E8 ?? ?? ?? ?? 83 C4 08 D9 5D F8 D9 45 FC D8 4D FC D9 45 F8 D8 4D F8 DE C1 D9 5D F4 D9 45 F4 8B E5 5D C3 }
	condition:
		$1
}

rule file_174_8_0 {
	meta:
		name = "___acrt_uninitialize_tmpfile"
		size = 17
		refs = "0006 ___acrt_stdio_free_tmpfile_name_buffers_nolock 000b __rmtmp"
	strings:
		$1 = { 8B FF 55 8B EC E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_174_9_0 {
	meta:
		name = "__rmtmp"
		size = 310
		refs = "0008 __sehtable$__rmtmp 000d __except_handler4 001f ___security_cookie 003c ___acrt_lock 0061 __nstream 006f ___piob 007b ??0__crt_stdio_stream@@QAE@QAU__crt_stdio_stream_data@@@Z 0083 ?valid@__crt_stdio_stream@@QBE_NXZ 0094 ?public_stream@__crt_stdio_stream@@QBEPAU_iobuf@@XZ 009a __lock_file 00ac ?is_in_use@__crt_stdio_stream@@QBE_NXZ 00bd ??C__crt_stdio_stream@@QBEPAU__crt_stdio_stream_data@@XZ 00d3 __fclose_nolock 00fb __unlock_file 0119 ___acrt_unlock"
	strings:
		$1 = { 8B FF 55 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 83 C4 EC 53 56 57 A1 ?? ?? ?? ?? 31 45 F8 33 C5 50 8D 45 F0 64 A3 00 00 00 00 C7 45 DC 00 00 00 00 6A 08 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 00 00 00 00 C7 45 E0 00 00 00 00 EB 09 8B 45 E0 83 C0 01 89 45 E0 8B 4D E0 3B 0D ?? ?? ?? ?? 0F 84 9D 00 00 00 8B 55 E0 A1 ?? ?? ?? ?? 8B 0C 90 51 8D 4D E4 E8 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 0F B6 D0 85 D2 75 02 EB C3 8D 4D E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C7 45 FC 01 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 0F B6 C0 85 C0 75 02 EB 2A 8D 4D E4 E8 ?? ?? ?? ?? 83 78 1C 00 75 02 EB 1A 8D 4D E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 8B 4D DC 83 C1 01 89 4D DC C7 45 FC 00 00 00 00 E8 02 00 00 00 EB 12 8D 4D E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 04 C3 E9 4B FF FF FF C7 45 FC FE FF FF FF E8 02 00 00 00 EB 0B 6A 08 E8 ?? ?? ?? ?? 83 C4 04 C3 8B 45 DC 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_0_0 {
	meta:
		name = "??$?0ABV?$console_output_adapter@D@__crt_stdio_output@@AB_KABQBDABQAU__crt_locale_pointers@@ABQAD@?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@D@1@AB_KABQBDABQAU__crt_locale_pointers@@ABQAD@Z"
		size = 35
		refs = "0018 ??$?0ABV?$console_output_adapter@D@__crt_stdio_output@@AB_KABQBDABQAU__crt_locale_pointers@@ABQAD@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@D@1@AB_KABQBDABQAU__crt_locale_pointers@@ABQAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 18 8B F1 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 14 00 }
	condition:
		$1
}

rule file_175_3_0 {
	meta:
		name = "??$?0ABV?$console_output_adapter@_W@__crt_stdio_output@@AB_KABQB_WABQAU__crt_locale_pointers@@ABQAD@?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@AB_KABQB_WABQAU__crt_locale_pointers@@ABQAD@Z"
		size = 35
		refs = "0018 ??$?0ABV?$console_output_adapter@_W@__crt_stdio_output@@AB_KABQB_WABQAU__crt_locale_pointers@@ABQAD@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@AB_KABQB_WABQAU__crt_locale_pointers@@ABQAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 18 8B F1 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 14 00 }
	condition:
		$1
}

rule file_175_1_0 {
	meta:
		name = "??$?0ABV?$console_output_adapter@D@__crt_stdio_output@@AB_KABQBDABQAU__crt_locale_pointers@@ABQAD@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@D@1@AB_KABQBDABQAU__crt_locale_pointers@@ABQAD@Z"
		size = 72
		refs = "0018 ??$?0ABV?$console_output_adapter@D@__crt_stdio_output@@AB_KABQBDABQAU__crt_locale_pointers@@ABQAD@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@D@1@AB_KABQBDABQAU__crt_locale_pointers@@ABQAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 18 8B F1 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 46 10 83 A6 58 04 00 00 00 83 A6 5C 04 00 00 00 83 8E A4 0A 00 00 FF 83 8E A8 0A 00 00 FF 89 86 60 04 00 00 8B C6 5E 5D C2 14 00 }
	condition:
		$1
}

rule file_175_4_0 {
	meta:
		name = "??$?0ABV?$console_output_adapter@_W@__crt_stdio_output@@AB_KABQB_WABQAU__crt_locale_pointers@@ABQAD@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@AB_KABQB_WABQAU__crt_locale_pointers@@ABQAD@Z"
		size = 72
		refs = "0018 ??$?0ABV?$console_output_adapter@_W@__crt_stdio_output@@AB_KABQB_WABQAU__crt_locale_pointers@@ABQAD@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@AB_KABQB_WABQAU__crt_locale_pointers@@ABQAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 18 8B F1 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 46 10 83 A6 58 04 00 00 00 83 A6 5C 04 00 00 00 83 8E A4 0A 00 00 FF 83 8E A8 0A 00 00 FF 89 86 60 04 00 00 8B C6 5E 5D C2 14 00 }
	condition:
		$1
}

rule file_175_2_0 {
	meta:
		name = "??$?0ABV?$console_output_adapter@D@__crt_stdio_output@@AB_KABQBDABQAU__crt_locale_pointers@@ABQAD@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@D@1@AB_KABQBDABQAU__crt_locale_pointers@@ABQAD@Z"
		size = 53
		refs = "0023 ??0?$output_adapter_data@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@D@1@_KQBDQAU__crt_locale_pointers@@QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 56 8B F1 FF 30 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 70 04 FF 30 FF 75 08 E8 ?? ?? ?? ?? 83 A6 50 04 00 00 00 8B C6 5E 5D C2 14 00 }
	condition:
		$1
}

rule file_175_5_0 {
	meta:
		name = "??$?0ABV?$console_output_adapter@_W@__crt_stdio_output@@AB_KABQB_WABQAU__crt_locale_pointers@@ABQAD@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@AB_KABQB_WABQAU__crt_locale_pointers@@ABQAD@Z"
		size = 53
		refs = "0023 ??0?$output_adapter_data@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@_KQB_WQAU__crt_locale_pointers@@QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 18 56 8B F1 FF 30 8B 45 14 FF 30 8B 45 10 FF 30 8B 45 0C FF 70 04 FF 30 FF 75 08 E8 ?? ?? ?? ?? 83 A6 50 04 00 00 00 8B C6 5E 5D C2 14 00 }
	condition:
		$1
}

rule file_175_7_0 {
	meta:
		name = "??$common_vcprintf@Vformat_validation_base@__crt_stdio_output@@D@@YAH_KQBDQAU__crt_locale_pointers@@QAD@Z"
		size = 140
		refs = "000c ___security_cookie 0020 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0045 ??0?$output_adapter_data@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@D@1@_KQBDQAU__crt_locale_pointers@@QAD@Z 0054 ?process@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ 0061 ??1formatting_buffer@__crt_stdio_output@@QAE@XZ 0084 @__security_check_cookie@4"
		altNames = "___conio_common_vcprintf_s"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 70 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 FF 75 14 8D 8D 90 FB FF FF E8 ?? ?? ?? ?? FF 75 18 8D 85 94 FB FF FF 50 FF 75 10 8D 85 A3 FB FF FF FF 75 0C 8D 8D A4 FB FF FF FF 75 08 50 E8 ?? ?? ?? ?? 83 65 F4 00 8D 8D A4 FB FF FF E8 ?? ?? ?? ?? 8D 8D E4 FB FF FF 8B F0 E8 ?? ?? ?? ?? 80 BD 9C FB FF FF 00 74 0D 8B 8D 90 FB FF FF 83 A1 50 03 00 00 FD 8B 4D FC 8B C6 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_8_0 {
	meta:
		name = "??$common_vcprintf@Vformat_validation_base@__crt_stdio_output@@_W@@YAH_KQB_WQAU__crt_locale_pointers@@QAD@Z"
		size = 140
		refs = "000c ___security_cookie 0020 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0045 ??0?$output_adapter_data@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@_KQB_WQAU__crt_locale_pointers@@QAD@Z 0054 ?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ 0061 ??1formatting_buffer@__crt_stdio_output@@QAE@XZ 0084 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 70 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 FF 75 14 8D 8D 90 FB FF FF E8 ?? ?? ?? ?? FF 75 18 8D 85 94 FB FF FF 50 FF 75 10 8D 85 A3 FB FF FF FF 75 0C 8D 8D A4 FB FF FF FF 75 08 50 E8 ?? ?? ?? ?? 83 65 F4 00 8D 8D A4 FB FF FF E8 ?? ?? ?? ?? 8D 8D E4 FB FF FF 8B F0 E8 ?? ?? ?? ?? 80 BD 9C FB FF FF 00 74 0D 8B 8D 90 FB FF FF 83 A1 50 03 00 00 FD 8B 4D FC 8B C6 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_11_0 {
	meta:
		name = "??$common_vcprintf@Vstandard_base@__crt_stdio_output@@D@@YAH_KQBDQAU__crt_locale_pointers@@QAD@Z"
		size = 140
		refs = "000c ___security_cookie 0020 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0045 ??0?$output_adapter_data@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@D@1@_KQBDQAU__crt_locale_pointers@@QAD@Z 0054 ?process@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ 0061 ??1formatting_buffer@__crt_stdio_output@@QAE@XZ 0084 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 70 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 FF 75 14 8D 8D 90 FB FF FF E8 ?? ?? ?? ?? FF 75 18 8D 85 94 FB FF FF 50 FF 75 10 8D 85 A3 FB FF FF FF 75 0C 8D 8D A4 FB FF FF FF 75 08 50 E8 ?? ?? ?? ?? 83 65 F4 00 8D 8D A4 FB FF FF E8 ?? ?? ?? ?? 8D 8D E4 FB FF FF 8B F0 E8 ?? ?? ?? ?? 80 BD 9C FB FF FF 00 74 0D 8B 8D 90 FB FF FF 83 A1 50 03 00 00 FD 8B 4D FC 8B C6 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_12_2 {
	meta:
		name = "??$common_vcprintf@Vstandard_base@__crt_stdio_output@@_W@@YAH_KQB_WQAU__crt_locale_pointers@@QAD@Z"
		size = 140
		refs = "000c ___security_cookie 0020 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0045 ??0?$output_adapter_data@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@_KQB_WQAU__crt_locale_pointers@@QAD@Z 0054 ?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ 0061 ??1formatting_buffer@__crt_stdio_output@@QAE@XZ 0084 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 70 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 FF 75 14 8D 8D 90 FB FF FF E8 ?? ?? ?? ?? FF 75 18 8D 85 94 FB FF FF 50 FF 75 10 8D 85 A3 FB FF FF FF 75 0C 8D 8D A4 FB FF FF FF 75 08 50 E8 ?? ?? ?? ?? 83 65 F4 00 8D 8D A4 FB FF FF E8 ?? ?? ?? ?? 8D 8D E4 FB FF FF 8B F0 E8 ?? ?? ?? ?? 80 BD 9C FB FF FF 00 74 0D 8B 8D 90 FB FF FF 83 A1 50 03 00 00 FD 8B 4D FC 8B C6 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_473_3 {
	meta:
		name = "___conio_common_vcprintf"
		size = 140
		refs = "000c ___security_cookie 0020 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0045 ??0?$output_adapter_data@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@D@1@_KQBDQAU__crt_locale_pointers@@QAD@Z 0054 ?process@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ 0061 ??1formatting_buffer@__crt_stdio_output@@QAE@XZ 0084 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 70 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 FF 75 14 8D 8D 90 FB FF FF E8 ?? ?? ?? ?? FF 75 18 8D 85 94 FB FF FF 50 FF 75 10 8D 85 A3 FB FF FF FF 75 0C 8D 8D A4 FB FF FF FF 75 08 50 E8 ?? ?? ?? ?? 83 65 F4 00 8D 8D A4 FB FF FF E8 ?? ?? ?? ?? 8D 8D E4 FB FF FF 8B F0 E8 ?? ?? ?? ?? 80 BD 9C FB FF FF 00 74 0D 8B 8D 90 FB FF FF 83 A1 50 03 00 00 FD 8B 4D FC 8B C6 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_476_0 {
	meta:
		name = "___conio_common_vcwprintf"
		size = 140
		refs = "000c ___security_cookie 0020 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0045 ??0?$output_adapter_data@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@_KQB_WQAU__crt_locale_pointers@@QAD@Z 0054 ?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ 0061 ??1formatting_buffer@__crt_stdio_output@@QAE@XZ 0084 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 70 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 FF 75 14 8D 8D 90 FB FF FF E8 ?? ?? ?? ?? FF 75 18 8D 85 94 FB FF FF 50 FF 75 10 8D 85 A3 FB FF FF FF 75 0C 8D 8D A4 FB FF FF FF 75 08 50 E8 ?? ?? ?? ?? 83 65 F4 00 8D 8D A4 FB FF FF E8 ?? ?? ?? ?? 8D 8D E4 FB FF FF 8B F0 E8 ?? ?? ?? ?? 80 BD 9C FB FF FF 00 74 0D 8B 8D 90 FB FF FF 83 A1 50 03 00 00 FD 8B 4D FC 8B C6 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_478_3 {
	meta:
		name = "___conio_common_vcwprintf_s"
		size = 140
		refs = "000c ___security_cookie 0020 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 0045 ??0?$output_adapter_data@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@_KQB_WQAU__crt_locale_pointers@@QAD@Z 0054 ?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ 0061 ??1formatting_buffer@__crt_stdio_output@@QAE@XZ 0084 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC 70 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 FF 75 14 8D 8D 90 FB FF FF E8 ?? ?? ?? ?? FF 75 18 8D 85 94 FB FF FF 50 FF 75 10 8D 85 A3 FB FF FF FF 75 0C 8D 8D A4 FB FF FF FF 75 08 50 E8 ?? ?? ?? ?? 83 65 F4 00 8D 8D A4 FB FF FF E8 ?? ?? ?? ?? 8D 8D E4 FB FF FF 8B F0 E8 ?? ?? ?? ?? 80 BD 9C FB FF FF 00 74 0D 8B 8D 90 FB FF FF 83 A1 50 03 00 00 FD 8B 4D FC 8B C6 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_9_0 {
	meta:
		name = "??$common_vcprintf@Vpositional_parameter_base@__crt_stdio_output@@D@@YAH_KQBDQAU__crt_locale_pointers@@QAD@Z"
		size = 193
		refs = "000c ___security_cookie 0020 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 007e ??$?0ABV?$console_output_adapter@D@__crt_stdio_output@@AB_KABQBDABQAU__crt_locale_pointers@@ABQAD@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@D@1@AB_KABQBDABQAU__crt_locale_pointers@@ABQAD@Z 0089 ?process@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ 0096 ??1formatting_buffer@__crt_stdio_output@@QAE@XZ 00b9 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC DC 0A 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 FF 75 14 8D 8D 24 F5 FF FF E8 ?? ?? ?? ?? 8B 45 18 8D 8D 4C F5 FF FF 89 85 44 F5 FF FF 8D 85 28 F5 FF FF 89 85 40 F5 FF FF 8B 45 10 89 85 3C F5 FF FF 8B 45 08 89 85 34 F5 FF FF 8B 45 0C 89 85 38 F5 FF FF 8D 85 44 F5 FF FF 50 8D 85 40 F5 FF FF 50 8D 85 3C F5 FF FF 50 8D 85 34 F5 FF FF 50 8D 85 4B F5 FF FF 50 E8 ?? ?? ?? ?? 8D 8D 4C F5 FF FF E8 ?? ?? ?? ?? 8D 8D 8C F5 FF FF 8B F0 E8 ?? ?? ?? ?? 80 BD 30 F5 FF FF 00 74 0D 8B 8D 24 F5 FF FF 83 A1 50 03 00 00 FD 8B 4D FC 8B C6 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_10_0 {
	meta:
		name = "??$common_vcprintf@Vpositional_parameter_base@__crt_stdio_output@@_W@@YAH_KQB_WQAU__crt_locale_pointers@@QAD@Z"
		size = 193
		refs = "000c ___security_cookie 0020 ??0_LocaleUpdate@@QAE@QAU__crt_locale_pointers@@@Z 007e ??$?0ABV?$console_output_adapter@_W@__crt_stdio_output@@AB_KABQB_WABQAU__crt_locale_pointers@@ABQAD@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@AB_KABQB_WABQAU__crt_locale_pointers@@ABQAD@Z 0089 ?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ 0096 ??1formatting_buffer@__crt_stdio_output@@QAE@XZ 00b9 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 81 EC DC 0A 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 FF 75 14 8D 8D 24 F5 FF FF E8 ?? ?? ?? ?? 8B 45 18 8D 8D 4C F5 FF FF 89 85 44 F5 FF FF 8D 85 28 F5 FF FF 89 85 40 F5 FF FF 8B 45 10 89 85 3C F5 FF FF 8B 45 08 89 85 34 F5 FF FF 8B 45 0C 89 85 38 F5 FF FF 8D 85 44 F5 FF FF 50 8D 85 40 F5 FF FF 50 8D 85 3C F5 FF FF 50 8D 85 34 F5 FF FF 50 8D 85 4B F5 FF FF 50 E8 ?? ?? ?? ?? 8D 8D 4C F5 FF FF E8 ?? ?? ?? ?? 8D 8D 8C F5 FF FF 8B F0 E8 ?? ?? ?? ?? 80 BD 30 F5 FF FF 00 74 0D 8B 8D 24 F5 FF FF 83 A1 50 03 00 00 FD 8B 4D FC 8B C6 33 CD 5E E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_13_0 {
	meta:
		name = "??$count@D@formatting_buffer@__crt_stdio_output@@QBEIXZ"
		size = 24
	strings:
		$1 = { 83 B9 04 04 00 00 00 75 06 B8 00 02 00 00 C3 8B 81 00 04 00 00 D1 E8 C3 }
	condition:
		$1
}

rule file_175_14_0 {
	meta:
		name = "??$count@_W@formatting_buffer@__crt_stdio_output@@QBEIXZ"
		size = 25
	strings:
		$1 = { 83 B9 04 04 00 00 00 75 06 B8 00 01 00 00 C3 8B 81 00 04 00 00 C1 E8 02 C3 }
	condition:
		$1
}

rule file_175_17_0 {
	meta:
		name = "??$ensure_buffer_is_big_enough@D@formatting_buffer@__crt_stdio_output@@QAE_NI@Z"
		size = 151
		refs = "001d __errno 0052 ??_C@_0DI@KIFBHMNO@minkernel?2crts?2ucrt?2inc?2corecrt_@ 005a __malloc_dbg 0073 ??4?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QAEAAV0@$$QAV0@@Z 0086 __free_dbg"
	strings:
		$1 = { 8B FF 55 8B EC 51 83 C8 FF 33 D2 56 8B 75 08 F7 F6 57 83 E0 FE 8B F9 83 F8 02 73 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 32 C0 EB 64 53 33 DB 03 F6 39 9F 04 04 00 00 75 08 81 FE 00 04 00 00 76 08 3B B7 00 04 00 00 77 04 B0 01 EB 42 68 64 01 00 00 68 ?? ?? ?? ?? 6A 02 56 E8 ?? ?? ?? ?? 83 C4 10 89 45 FC 85 C0 74 1A 8D 45 FC 50 8D 8F 04 04 00 00 E8 ?? ?? ?? ?? 8B 45 FC B3 01 89 B7 00 04 00 00 6A 02 50 E8 ?? ?? ?? ?? 59 59 8A C3 5B 5F 5E 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_175_18_0 {
	meta:
		name = "??$extract_argument_from_va_list@C_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 191
		refs = "0058 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z 006f ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 007a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0082 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0089 __CrtDbgReportW 0097 __errno 00a4 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b0 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 1B 83 41 14 04 8B 49 14 0F BE 41 FC 8B 4D 08 99 89 01 B0 01 89 51 04 E9 92 00 00 00 8B 91 A8 0A 00 00 85 D2 78 39 83 FA 64 7D 34 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B6 41 31 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 5D 03 D2 8B 84 D1 6C 04 00 00 0F BE 00 EB AD 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_19_0 {
	meta:
		name = "??$extract_argument_from_va_list@C_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 191
		refs = "0058 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z 006f ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 007a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0082 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0089 __CrtDbgReportW 0097 __errno 00a4 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b0 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 1B 83 41 14 04 8B 49 14 0F BE 41 FC 8B 4D 08 99 89 01 B0 01 89 51 04 E9 92 00 00 00 8B 91 A8 0A 00 00 85 D2 78 39 83 FA 64 7D 34 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B7 41 32 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 5D 03 D2 8B 84 D1 6C 04 00 00 0F BE 00 EB AD 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_20_0 {
	meta:
		name = "??$extract_argument_from_va_list@C_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 31
		altNames = "??$extract_argument_from_va_list@C_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 14 04 8B 41 14 8B 4D 08 0F BE 40 FC 99 89 01 B0 01 89 51 04 5D C2 04 00 }
	condition:
		$1
}

rule file_175_22_0 {
	meta:
		name = "??$extract_argument_from_va_list@E_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 191
		refs = "0058 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z 006f ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 007a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0082 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0089 __CrtDbgReportW 0097 __errno 00a4 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b0 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 1B 83 41 14 04 8B 49 14 0F B6 41 FC 8B 4D 08 99 89 01 B0 01 89 51 04 E9 92 00 00 00 8B 91 A8 0A 00 00 85 D2 78 39 83 FA 64 7D 34 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B6 41 31 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 5D 03 D2 8B 84 D1 6C 04 00 00 0F B6 00 EB AD 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_23_0 {
	meta:
		name = "??$extract_argument_from_va_list@E_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 191
		refs = "0058 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z 006f ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 007a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0082 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0089 __CrtDbgReportW 0097 __errno 00a4 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b0 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 1B 83 41 14 04 8B 49 14 0F B6 41 FC 8B 4D 08 99 89 01 B0 01 89 51 04 E9 92 00 00 00 8B 91 A8 0A 00 00 85 D2 78 39 83 FA 64 7D 34 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B7 41 32 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 5D 03 D2 8B 84 D1 6C 04 00 00 0F B6 00 EB AD 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_24_0 {
	meta:
		name = "??$extract_argument_from_va_list@E_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 31
		altNames = "??$extract_argument_from_va_list@E_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 14 04 8B 41 14 8B 4D 08 0F B6 40 FC 99 89 01 B0 01 89 51 04 5D C2 04 00 }
	condition:
		$1
}

rule file_175_26_0 {
	meta:
		name = "??$extract_argument_from_va_list@F_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 191
		refs = "0058 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z 006f ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 007a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0082 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0089 __CrtDbgReportW 0097 __errno 00a4 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b0 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 1B 83 41 14 04 8B 49 14 0F BF 41 FC 8B 4D 08 99 89 01 B0 01 89 51 04 E9 92 00 00 00 8B 91 A8 0A 00 00 85 D2 78 39 83 FA 64 7D 34 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B6 41 31 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 5D 03 D2 8B 84 D1 6C 04 00 00 0F BF 00 EB AD 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_27_0 {
	meta:
		name = "??$extract_argument_from_va_list@F_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 191
		refs = "0058 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z 006f ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 007a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0082 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0089 __CrtDbgReportW 0097 __errno 00a4 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b0 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 1B 83 41 14 04 8B 49 14 0F BF 41 FC 8B 4D 08 99 89 01 B0 01 89 51 04 E9 92 00 00 00 8B 91 A8 0A 00 00 85 D2 78 39 83 FA 64 7D 34 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B7 41 32 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 5D 03 D2 8B 84 D1 6C 04 00 00 0F BF 00 EB AD 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_28_0 {
	meta:
		name = "??$extract_argument_from_va_list@F_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 31
		altNames = "??$extract_argument_from_va_list@F_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 14 04 8B 41 14 8B 4D 08 0F BF 40 FC 99 89 01 B0 01 89 51 04 5D C2 04 00 }
	condition:
		$1
}

rule file_175_30_0 {
	meta:
		name = "??$extract_argument_from_va_list@GD@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAD@Z"
		size = 190
		refs = "0053 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z 006e ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0079 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0081 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0088 __CrtDbgReportW 0096 __errno 00a3 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00af __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 16 83 41 14 04 8B 49 14 8A 51 FC 8B 4D 08 88 11 B0 01 E9 96 00 00 00 8B 91 A8 0A 00 00 85 D2 78 3D 83 FA 64 7D 38 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B6 41 31 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 61 03 D2 8B 84 D1 6C 04 00 00 8A 08 8B 45 08 88 08 EB B2 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_31_0 {
	meta:
		name = "??$extract_argument_from_va_list@GD@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAD@Z"
		size = 26
	strings:
		$1 = { 8B FF 55 8B EC 83 41 14 04 8B 41 14 8A 48 FC 8B 45 08 88 08 B0 01 5D C2 04 00 }
	condition:
		$1
}

rule file_175_32_0 {
	meta:
		name = "??$extract_argument_from_va_list@G_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 191
		refs = "0058 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z 006f ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 007a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0082 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0089 __CrtDbgReportW 0097 __errno 00a4 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b0 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 1B 83 41 14 04 8B 49 14 0F B7 41 FC 8B 4D 08 99 89 01 B0 01 89 51 04 E9 92 00 00 00 8B 91 A8 0A 00 00 85 D2 78 39 83 FA 64 7D 34 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B6 41 31 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 5D 03 D2 8B 84 D1 6C 04 00 00 0F B7 00 EB AD 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_33_0 {
	meta:
		name = "??$extract_argument_from_va_list@G_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 191
		refs = "0058 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z 006f ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 007a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0082 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0089 __CrtDbgReportW 0097 __errno 00a4 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b0 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 1B 83 41 14 04 8B 49 14 0F B7 41 FC 8B 4D 08 99 89 01 B0 01 89 51 04 E9 92 00 00 00 8B 91 A8 0A 00 00 85 D2 78 39 83 FA 64 7D 34 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B7 41 32 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 5D 03 D2 8B 84 D1 6C 04 00 00 0F B7 00 EB AD 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_34_0 {
	meta:
		name = "??$extract_argument_from_va_list@G_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 31
		altNames = "??$extract_argument_from_va_list@G_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 14 04 8B 41 14 8B 4D 08 0F B7 40 FC 99 89 01 B0 01 89 51 04 5D C2 04 00 }
	condition:
		$1
}

rule file_175_36_0 {
	meta:
		name = "??$extract_argument_from_va_list@H_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 189
		refs = "0057 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z 006d ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0078 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0080 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0087 __CrtDbgReportW 0095 __errno 00a2 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00ae __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 1A 83 41 14 04 8B 41 14 8B 40 FC 8B 4D 08 99 89 01 B0 01 89 51 04 E9 91 00 00 00 8B 91 A8 0A 00 00 85 D2 78 38 83 FA 64 7D 33 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B6 41 31 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 5C 03 D2 8B 84 D1 6C 04 00 00 8B 00 EB AE 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_37_0 {
	meta:
		name = "??$extract_argument_from_va_list@H_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 189
		refs = "0057 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z 006d ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0078 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0080 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0087 __CrtDbgReportW 0095 __errno 00a2 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00ae __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 1A 83 41 14 04 8B 41 14 8B 40 FC 8B 4D 08 99 89 01 B0 01 89 51 04 E9 91 00 00 00 8B 91 A8 0A 00 00 85 D2 78 38 83 FA 64 7D 33 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B7 41 32 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 5C 03 D2 8B 84 D1 6C 04 00 00 8B 00 EB AE 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_38_0 {
	meta:
		name = "??$extract_argument_from_va_list@H_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 30
		altNames = "??$extract_argument_from_va_list@H_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 14 04 8B 41 14 8B 4D 08 8B 40 FC 99 89 01 B0 01 89 51 04 5D C2 04 00 }
	condition:
		$1
}

rule file_175_40_0 {
	meta:
		name = "??$extract_argument_from_va_list@I_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 198
		refs = "0057 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z 0076 ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0081 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0089 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0090 __CrtDbgReportW 009e __errno 00ab ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b7 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 1A 83 41 14 04 8B 49 14 8B 55 08 8B 49 FC 83 62 04 00 89 0A B0 01 E9 9A 00 00 00 8B 91 A8 0A 00 00 85 D2 78 41 83 FA 64 7D 3C 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B6 41 31 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 65 03 D2 8B 84 D1 6C 04 00 00 8B 4D 08 8B 00 83 61 04 00 89 01 EB AE 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_41_0 {
	meta:
		name = "??$extract_argument_from_va_list@I_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 198
		refs = "0057 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z 0076 ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0081 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0089 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0090 __CrtDbgReportW 009e __errno 00ab ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b7 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 1A 83 41 14 04 8B 49 14 8B 55 08 8B 49 FC 83 62 04 00 89 0A B0 01 E9 9A 00 00 00 8B 91 A8 0A 00 00 85 D2 78 41 83 FA 64 7D 3C 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B7 41 32 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 65 03 D2 8B 84 D1 6C 04 00 00 8B 4D 08 8B 00 83 61 04 00 89 01 EB AE 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_42_0 {
	meta:
		name = "??$extract_argument_from_va_list@I_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 30
		altNames = "??$extract_argument_from_va_list@I_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 14 04 8B 41 14 8B 4D 08 8B 40 FC 83 61 04 00 89 01 B0 01 5D C2 04 00 }
	condition:
		$1
}

rule file_175_44_0 {
	meta:
		name = "??$extract_argument_from_va_list@PADPAD@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAD@Z"
		size = 189
		refs = "0053 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z 006f ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 007a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0082 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 008a __CrtDbgReportW 0098 __errno 00a1 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00ad __invalid_parameter"
		altNames = "??$extract_argument_from_va_list@PAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ@PAU1?1??234@AAE_NXZ@@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@1@AAE_NXZ@@Z ??$extract_argument_from_va_list@PAXPAX@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 16 83 41 14 04 8B 49 14 8B 51 FC 8B 4D 08 89 11 B0 01 E9 95 00 00 00 8B 91 A8 0A 00 00 85 D2 78 3D 83 FA 64 7D 38 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B6 41 31 50 C1 E2 04 8D 81 64 04 00 00 6A 03 03 C2 50 E8 ?? ?? ?? ?? EB 60 03 D2 8B 84 D1 6C 04 00 00 8B 08 8B 45 08 89 08 EB B2 53 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_175_45_0 {
	meta:
		name = "??$extract_argument_from_va_list@PADPAD@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAD@Z"
		size = 189
		refs = "0053 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z 006f ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 007a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0082 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 008a __CrtDbgReportW 0098 __errno 00a1 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00ad __invalid_parameter"
		altNames = "??$extract_argument_from_va_list@PAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ@PAU1?1??234@AAE_NXZ@@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@1@AAE_NXZ@@Z ??$extract_argument_from_va_list@PAXPAX@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 16 83 41 14 04 8B 49 14 8B 51 FC 8B 4D 08 89 11 B0 01 E9 95 00 00 00 8B 91 A8 0A 00 00 85 D2 78 3D 83 FA 64 7D 38 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B7 41 32 50 C1 E2 04 8D 81 64 04 00 00 6A 03 03 C2 50 E8 ?? ?? ?? ?? EB 60 03 D2 8B 84 D1 6C 04 00 00 8B 08 8B 45 08 89 08 EB B2 53 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5B 5D C2 04 00 }
	condition:
		$1
}

rule file_175_46_0 {
	meta:
		name = "??$extract_argument_from_va_list@PADPAD@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAD@Z"
		size = 26
		altNames = "??$extract_argument_from_va_list@PADPAD@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAD@Z ??$extract_argument_from_va_list@PAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ@PAU1?1??234@AAE_NXZ@@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@1@AAE_NXZ@@Z ??$extract_argument_from_va_list@PAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ@PAU1?1??234@AAE_NXZ@@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@1@AAE_NXZ@@Z ??$extract_argument_from_va_list@PAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ@PAU1?1??234@AAE_NXZ@@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@1@AAE_NXZ@@Z ??$extract_argument_from_va_list@PAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ@PAU1?1??234@AAE_NXZ@@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@1@AAE_NXZ@@Z ??$extract_argument_from_va_list@PAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ@PAU1?1??234@AAE_NXZ@@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@1@AAE_NXZ@@Z ??$extract_argument_from_va_list@PAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ@PAU1?1??234@AAE_NXZ@@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@1@AAE_NXZ@@Z ??$extract_argument_from_va_list@PAXPAX@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAX@Z ??$extract_argument_from_va_list@PAXPAX@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAPAX@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 14 04 8B 41 14 8B 48 FC 8B 45 08 89 08 B0 01 5D C2 04 00 }
	condition:
		$1
}

rule file_175_60_0 {
	meta:
		name = "??$extract_argument_from_va_list@U_CRT_DOUBLE@@U1@@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAU_CRT_DOUBLE@@@Z"
		size = 201
		refs = "005a ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z 007b ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0086 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 008e ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0096 __CrtDbgReportW 00a4 __errno 00ad ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b9 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 56 75 1C 83 41 14 08 8B 49 14 8B 51 F8 8B 71 FC 8B 4D 08 89 11 89 71 04 B0 01 E9 99 00 00 00 8B 91 A8 0A 00 00 85 D2 78 43 83 FA 64 7D 3E 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B6 41 31 50 C1 E2 04 8D 81 64 04 00 00 6A 04 03 C2 50 E8 ?? ?? ?? ?? EB 64 03 D2 8B 84 D1 6C 04 00 00 8B 08 8B 50 04 8B 45 08 89 08 89 50 04 EB AC 53 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5B 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_61_0 {
	meta:
		name = "??$extract_argument_from_va_list@U_CRT_DOUBLE@@U1@@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAU_CRT_DOUBLE@@@Z"
		size = 201
		refs = "005a ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z 007b ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0086 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 008e ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0096 __CrtDbgReportW 00a4 __errno 00ad ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b9 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 56 75 1C 83 41 14 08 8B 49 14 8B 51 F8 8B 71 FC 8B 4D 08 89 11 89 71 04 B0 01 E9 99 00 00 00 8B 91 A8 0A 00 00 85 D2 78 43 83 FA 64 7D 3E 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B7 41 32 50 C1 E2 04 8D 81 64 04 00 00 6A 04 03 C2 50 E8 ?? ?? ?? ?? EB 64 03 D2 8B 84 D1 6C 04 00 00 8B 08 8B 50 04 8B 45 08 89 08 89 50 04 EB AC 53 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5B 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_62_0 {
	meta:
		name = "??$extract_argument_from_va_list@U_CRT_DOUBLE@@U1@@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAU_CRT_DOUBLE@@@Z"
		size = 32
		altNames = "??$extract_argument_from_va_list@U_CRT_DOUBLE@@U1@@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAAU_CRT_DOUBLE@@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 14 08 8B 41 14 8B 48 F8 8B 50 FC 8B 45 08 89 08 89 50 04 B0 01 5D C2 04 00 }
	condition:
		$1
}

rule file_175_64_0 {
	meta:
		name = "??$extract_argument_from_va_list@_J_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 201
		refs = "005a ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z 007b ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0086 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 008e ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0096 __CrtDbgReportW 00a4 __errno 00ad ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b9 __invalid_parameter"
		altNames = "??$extract_argument_from_va_list@_K_J@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 56 75 1C 83 41 14 08 8B 71 14 8B 55 08 8B 4E F8 89 0A 8B 4E FC 89 4A 04 B0 01 E9 99 00 00 00 8B 91 A8 0A 00 00 85 D2 78 43 83 FA 64 7D 3E 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B6 41 31 50 C1 E2 04 8D 81 64 04 00 00 6A 02 03 C2 50 E8 ?? ?? ?? ?? EB 64 03 D2 8B 94 D1 6C 04 00 00 8B 4D 08 8B 02 89 01 8B 42 04 89 41 04 EB AC 53 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5B 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_65_0 {
	meta:
		name = "??$extract_argument_from_va_list@_J_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 201
		refs = "005a ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z 007b ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 0086 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 008e ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0096 __CrtDbgReportW 00a4 __errno 00ad ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b9 __invalid_parameter"
		altNames = "??$extract_argument_from_va_list@_K_J@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 56 75 1C 83 41 14 08 8B 71 14 8B 55 08 8B 4E F8 89 0A 8B 4E FC 89 4A 04 B0 01 E9 99 00 00 00 8B 91 A8 0A 00 00 85 D2 78 43 83 FA 64 7D 3E 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B7 41 32 50 C1 E2 04 8D 81 64 04 00 00 6A 02 03 C2 50 E8 ?? ?? ?? ?? EB 64 03 D2 8B 94 D1 6C 04 00 00 8B 4D 08 8B 02 89 01 8B 42 04 89 41 04 EB AC 53 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5B 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_66_0 {
	meta:
		name = "??$extract_argument_from_va_list@_J_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
		size = 32
		altNames = "??$extract_argument_from_va_list@_J_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z ??$extract_argument_from_va_list@_K_J@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z ??$extract_argument_from_va_list@_K_J@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_J@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 14 08 8B 51 14 8B 4D 08 8B 42 F8 89 01 8B 42 FC 89 41 04 B0 01 5D C2 04 00 }
	condition:
		$1
}

rule file_175_72_0 {
	meta:
		name = "??$extract_argument_from_va_list@_W_W@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_W@Z"
		size = 194
		refs = "0055 ?validate_and_store_parameter_data@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z 0072 ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 007d ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0085 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 008c __CrtDbgReportW 009a __errno 00a7 ??_C@_1BBG@NFKFEGFE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b3 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 18 83 41 14 04 8B 49 14 66 8B 51 FC 8B 4D 08 66 89 11 B0 01 E9 98 00 00 00 8B 91 A8 0A 00 00 85 D2 78 3F 83 FA 64 7D 3A 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B6 41 31 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 63 03 D2 8B 84 D1 6C 04 00 00 66 8B 08 8B 45 08 66 89 08 EB B0 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_73_0 {
	meta:
		name = "??$extract_argument_from_va_list@_W_W@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_W@Z"
		size = 194
		refs = "0055 ?validate_and_store_parameter_data@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AAE_NAAUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z 0072 ??_C@_1FE@IAFJEKN@?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5?$AA?$DO?$AA?$DN?$AA?5?$AA0?$AA?5?$AA?$CG?$AA?$CG?$AA?5?$AA_?$AAt?$AAy?$AAp?$AAe?$AA_?$AAi?$AAn?$AAd?$AAe?$AAx?$AA?5@ 007d ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0085 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 008c __CrtDbgReportW 009a __errno 00a7 ??_C@_1BCC@LGLLAAKP@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAp?$AAo?$AAs?$AAi?$AAt?$AAi?$AAo?$AAn?$AAa?$AAl?$AA_?$AAp@ 00b3 __invalid_parameter"
	strings:
		$1 = { 8B FF 55 8B EC 83 B9 5C 04 00 00 01 75 18 83 41 14 04 8B 49 14 66 8B 51 FC 8B 4D 08 66 89 11 B0 01 E9 98 00 00 00 8B 91 A8 0A 00 00 85 D2 78 3F 83 FA 64 7D 3A 83 B9 58 04 00 00 01 75 1D FF 71 2C 0F B7 41 32 50 C1 E2 04 8D 81 64 04 00 00 6A 01 03 C2 50 E8 ?? ?? ?? ?? EB 63 03 D2 8B 84 D1 6C 04 00 00 66 8B 08 8B 45 08 66 89 08 EB B0 56 57 BE ?? ?? ?? ?? BF B7 04 00 00 56 68 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5D C2 04 00 }
	condition:
		$1
}

rule file_175_74_0 {
	meta:
		name = "??$extract_argument_from_va_list@_W_W@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_W@Z"
		size = 28
		altNames = "??$extract_argument_from_va_list@_W_W@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NAA_W@Z"
	strings:
		$1 = { 8B FF 55 8B EC 83 41 14 04 8B 41 14 66 8B 48 FC 8B 45 08 66 89 08 B0 01 5D C2 04 00 }
	condition:
		$1
}

rule file_175_82_0 {
	meta:
		name = "??$is_character_specifier@D@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@CA_ND@Z"
		size = 25
	strings:
		$1 = { 8B FF 55 8B EC 8A 45 08 3C 63 74 08 3C 43 74 04 33 C0 5D C3 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_175_83_0 {
	meta:
		name = "??$is_character_specifier@_W@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@CA_N_W@Z"
		size = 28
	strings:
		$1 = { 8B FF 55 8B EC 66 83 7D 08 63 74 0B 66 83 7D 08 43 74 04 33 C0 5D C3 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_175_84_0 {
	meta:
		name = "??$is_integral_specifier@D@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@CA_ND@Z"
		size = 45
	strings:
		$1 = { 8B FF 55 8B EC 8A 45 08 3C 64 74 1C 3C 69 74 18 3C 6F 74 14 3C 75 74 10 3C 78 74 0C 3C 58 74 08 3C 2A 74 04 33 C0 5D C3 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_175_85_0 {
	meta:
		name = "??$is_integral_specifier@_W@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@CA_N_W@Z"
		size = 60
	strings:
		$1 = { 8B FF 55 8B EC 66 8B 45 08 66 83 F8 64 74 28 66 83 F8 69 74 22 66 83 F8 6F 74 1C 66 83 F8 75 74 16 66 83 F8 78 74 10 66 83 F8 58 74 0A 66 83 F8 2A 74 04 33 C0 5D C3 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_175_86_0 {
	meta:
		name = "??$is_pointer_specifier@D@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@CA_ND@Z"
		size = 16
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 80 7D 08 70 0F 94 C0 5D C3 }
	condition:
		$1
}

rule file_175_87_0 {
	meta:
		name = "??$is_pointer_specifier@_W@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@CA_N_W@Z"
		size = 17
	strings:
		$1 = { 8B FF 55 8B EC 33 C0 66 83 7D 08 70 0F 94 C0 5D C3 }
	condition:
		$1
}

rule file_175_88_0 {
	meta:
		name = "??$is_string_specifier@D@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@CA_ND@Z"
		size = 25
	strings:
		$1 = { 8B FF 55 8B EC 8A 45 08 3C 73 74 08 3C 53 74 04 33 C0 5D C3 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_175_89_0 {
	meta:
		name = "??$is_string_specifier@_W@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@CA_N_W@Z"
		size = 28
	strings:
		$1 = { 8B FF 55 8B EC 66 83 7D 08 73 74 0B 66 83 7D 08 53 74 04 33 C0 5D C3 33 C0 40 5D C3 }
	condition:
		$1
}

rule file_175_90_0 {
	meta:
		name = "??$is_wide_character_specifier@D@__crt_stdio_output@@YA_N_KDW4length_modifier@0@@Z"
		size = 64
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 48 83 E8 01 74 2E 83 E8 01 74 25 83 E8 09 74 20 83 7D 14 0D 74 1E 8A 45 10 3C 63 74 08 3C 73 74 04 32 C9 EB 02 B1 01 33 C0 84 C9 0F 94 C0 5D C3 B0 01 5D C3 32 C0 5D C3 }
	condition:
		$1
}

rule file_175_91_0 {
	meta:
		name = "??$is_wide_character_specifier@_W@__crt_stdio_output@@YA_N_K_WW4length_modifier@0@@Z"
		size = 79
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 14 48 83 E8 01 74 3D 83 E8 01 74 34 83 E8 09 74 2F 83 7D 14 0D 74 29 8B 45 08 33 C9 83 E0 04 B2 01 0B C1 75 02 8A D1 66 83 7D 10 63 74 07 66 83 7D 10 73 75 02 B1 01 33 C0 3A D1 0F 94 C0 5D C3 B0 01 5D C3 32 C0 5D C3 }
	condition:
		$1
}

rule file_175_106_0 {
	meta:
		name = "??$puttch_nolock@ABD@?$__crt_char_traits@D@@SAHABD@Z"
		size = 20
		refs = "000d __putch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 0F BE 00 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_175_107_0 {
	meta:
		name = "??$puttch_nolock@AB_W@?$__crt_char_traits@_W@@SAGAB_W@Z"
		size = 20
		refs = "000d __putwch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 0F B7 00 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_463_66_0 {
	meta:
		name = "??$ungettch_nolock@ABG@?$__crt_char_traits@_W@@SAGABG@Z"
		size = 20
		refs = "000d __ungetwch_nolock"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 0F B7 00 50 E8 ?? ?? ?? ?? 59 5D C3 }
	condition:
		$1
}

rule file_175_108_0 {
	meta:
		name = "??$read_va_arg@C@__crt_stdio_output@@YACAAPAD@Z"
		size = 18
		altNames = "??$read_va_arg@E@__crt_stdio_output@@YAEAAPAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 00 04 8B 00 8A 40 FC 5D C3 }
	condition:
		$1
}

rule file_175_110_0 {
	meta:
		name = "??$read_va_arg@F@__crt_stdio_output@@YAFAAPAD@Z"
		size = 19
		altNames = "??$read_va_arg@G@__crt_stdio_output@@YAGAAPAD@Z ??$read_va_arg@_W@__crt_stdio_output@@YA_WAAPAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 00 04 8B 00 66 8B 40 FC 5D C3 }
	condition:
		$1
}

rule file_175_112_0 {
	meta:
		name = "??$read_va_arg@H@__crt_stdio_output@@YAHAAPAD@Z"
		size = 18
		altNames = "??$read_va_arg@I@__crt_stdio_output@@YAIAAPAD@Z ??$read_va_arg@PAD@__crt_stdio_output@@YAPADAAPAD@Z ??$read_va_arg@PAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ@@__crt_stdio_output@@YAPAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@0@AAE_NXZ@AAPAD@Z ??$read_va_arg@PAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ@@__crt_stdio_output@@YAPAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@0@AAE_NXZ@AAPAD@Z ??$read_va_arg@PAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ@@__crt_stdio_output@@YAPAUansi_string@?1??type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@0@AAE_NXZ@AAPAD@Z ??$read_va_arg@PAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ@@__crt_stdio_output@@YAPAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@0@AAE_NXZ@AAPAD@Z ??$read_va_arg@PAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ@@__crt_stdio_output@@YAPAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@0@AAE_NXZ@AAPAD@Z ??$read_va_arg@PAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ@@__crt_stdio_output@@YAPAUansi_string@?1??type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@0@AAE_NXZ@AAPAD@Z ??$read_va_arg@PAX@__crt_stdio_output@@YAPAXAAPAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 00 04 8B 00 8B 40 FC 5D C3 }
	condition:
		$1
}

rule file_175_122_0 {
	meta:
		name = "??$read_va_arg@U_CRT_DOUBLE@@@__crt_stdio_output@@YA?AU_CRT_DOUBLE@@AAPAD@Z"
		size = 21
		altNames = "??$read_va_arg@_J@__crt_stdio_output@@YA_JAAPAD@Z ??$read_va_arg@_K@__crt_stdio_output@@YA_KAAPAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 83 00 08 8B 10 8B 42 F8 8B 52 FC 5D C3 }
	condition:
		$1
}

rule file_175_127_0 {
	meta:
		name = "??$scratch_data@D@formatting_buffer@__crt_stdio_output@@QAEPADXZ"
		size = 30
		refs = "000d ??$count@D@formatting_buffer@__crt_stdio_output@@QBEIXZ"
	strings:
		$1 = { 8B FF 56 8B F1 57 8B BE 04 04 00 00 E8 ?? ?? ?? ?? 85 FF 75 04 03 C6 EB 02 03 C7 5F 5E C3 }
	condition:
		$1
}

rule file_175_132_0 {
	meta:
		name = "??$type_case_integer_parse_into_buffer@I@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAEXII_N@Z"
		size = 114
		refs = "001a ??$count@D@formatting_buffer@__crt_stdio_output@@QBEIXZ"
		altNames = "??$type_case_integer_parse_into_buffer@I@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAEXII_N@Z ??$type_case_integer_parse_into_buffer@I@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAEXII_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B F1 57 8D 4E 40 8B B9 04 04 00 00 85 FF 75 02 8B F9 E8 ?? ?? ?? ?? 8B 5D 08 48 03 F8 89 7E 34 8B 4E 28 85 C9 7F 04 85 DB 74 30 33 D2 8B C3 F7 75 0C 49 80 C2 30 89 4E 28 8B D8 80 FA 39 7E 11 80 7D 10 00 0F 94 C0 FE C8 24 E0 04 61 2C 3A 02 D0 8B 46 34 88 10 FF 4E 34 EB C5 2B 7E 34 89 7E 38 FF 46 34 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule file_175_135_0 {
	meta:
		name = "??$type_case_integer_parse_into_buffer@I@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAEXII_N@Z"
		size = 134
		refs = "001a ??$count@_W@formatting_buffer@__crt_stdio_output@@QBEIXZ"
		altNames = "??$type_case_integer_parse_into_buffer@I@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAEXII_N@Z ??$type_case_integer_parse_into_buffer@I@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAEXII_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 53 56 8B F1 57 8D 4E 40 8B B9 04 04 00 00 85 FF 75 02 8B F9 E8 ?? ?? ?? ?? 8B 5D 08 8D 3C 47 83 C7 FE 89 7E 34 8B 4E 28 85 C9 7F 04 85 DB 74 3E 8B C3 33 D2 F7 75 0C 49 8B D8 89 4E 28 8D 42 30 0F B7 C8 83 F9 39 76 16 80 7D 10 00 0F 94 C0 FE C8 24 E0 04 61 2C 3A 02 C1 66 98 0F B7 C8 8B 46 34 66 0F BE C9 66 89 08 83 46 34 FE EB B7 2B 7E 34 D1 FF 89 7E 38 83 46 34 02 5F 5E 5B 5D C2 0C 00 }
	condition:
		$1
}

rule file_175_138_0 {
	meta:
		name = "??$type_case_integer_parse_into_buffer@_K@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAEX_KI_N@Z"
		size = 135
		refs = "001c ??$count@D@formatting_buffer@__crt_stdio_output@@QBEIXZ 0048 __aulldvrm"
		altNames = "??$type_case_integer_parse_into_buffer@_K@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAEX_KI_N@Z ??$type_case_integer_parse_into_buffer@_K@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAEX_KI_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 56 8B F1 57 8D 4E 40 8B B9 04 04 00 00 85 FF 75 02 8B F9 E8 ?? ?? ?? ?? 8B 55 0C 48 8B 5D 08 03 F8 89 7E 34 8B 4E 28 85 C9 7F 06 8B C3 0B C2 74 3C 53 6A 00 FF 75 10 8D 41 FF 52 53 89 46 28 E8 ?? ?? ?? ?? 89 5D FC 5B 80 C1 30 8B D8 80 F9 39 7E 11 80 7D 14 00 0F 94 C0 FE C8 24 E0 04 61 2C 3A 02 C8 8B 46 34 88 08 FF 4E 34 EB B7 2B 7E 34 89 7E 38 FF 46 34 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_175_141_0 {
	meta:
		name = "??$type_case_integer_parse_into_buffer@_K@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAEX_KI_N@Z"
		size = 155
		refs = "001c ??$count@_W@formatting_buffer@__crt_stdio_output@@QBEIXZ 004b __aulldvrm"
		altNames = "??$type_case_integer_parse_into_buffer@_K@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAEX_KI_N@Z ??$type_case_integer_parse_into_buffer@_K@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAEX_KI_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 56 8B F1 57 8D 4E 40 8B B9 04 04 00 00 85 FF 75 02 8B F9 E8 ?? ?? ?? ?? 8B 55 0C 8B 5D 08 8D 3C 47 83 C7 FE 89 7E 34 8B 4E 28 85 C9 7F 06 8B C3 0B C2 74 4A 53 6A 00 FF 75 10 8D 41 FF 52 53 89 46 28 E8 ?? ?? ?? ?? 89 5D FC 5B 83 C1 30 8B D8 0F B7 C9 83 F9 39 76 16 80 7D 14 00 0F 94 C0 FE C8 24 E0 04 61 2C 3A 02 C1 66 98 0F B7 C8 8B 46 34 66 0F BE C9 66 89 08 83 46 34 FE EB A9 2B 7E 34 D1 FF 89 7E 38 83 46 34 02 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_175_144_0 {
	meta:
		name = "??$write_multiple_characters@V?$console_output_adapter@D@__crt_stdio_output@@D@__crt_stdio_output@@YAXABV?$console_output_adapter@D@0@DHQAH@Z"
		size = 44
		refs = "0019 ?write_character@?$console_output_adapter@D@__crt_stdio_output@@QBEXDQAH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 10 7E 1C 57 8B 7D 14 8B 4D 08 57 FF 75 0C E8 ?? ?? ?? ?? 83 3F FF 74 06 46 3B 75 10 7C E9 5F 5E 5D C3 }
	condition:
		$1
}

rule file_175_145_0 {
	meta:
		name = "??$write_multiple_characters@V?$console_output_adapter@_W@__crt_stdio_output@@D@__crt_stdio_output@@YAXABV?$console_output_adapter@_W@0@DHQAH@Z"
		size = 49
		refs = "001d ?write_character@?$console_output_adapter@_W@__crt_stdio_output@@QBEX_WQAH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 33 F6 39 75 10 7E 21 53 66 0F BE 5D 0C 57 8B 7D 14 8B 4D 08 57 53 E8 ?? ?? ?? ?? 83 3F FF 74 06 46 3B 75 10 7C EB 5F 5B 5E 5D C3 }
	condition:
		$1
}

rule file_175_147_0 {
	meta:
		name = "??0?$common_data@D@__crt_stdio_output@@IAE@XZ"
		size = 71
	strings:
		$1 = { 8B FF 55 8B EC 51 33 C0 89 4D FC 89 01 89 41 04 89 41 08 89 41 0C 89 41 10 89 41 14 89 41 18 89 41 1C 89 41 20 89 41 24 89 41 28 66 89 41 30 89 41 38 88 41 3C 89 81 40 04 00 00 89 81 44 04 00 00 8B C1 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_148_0 {
	meta:
		name = "??0?$common_data@_W@__crt_stdio_output@@IAE@XZ"
		size = 76
	strings:
		$1 = { 8B FF 55 8B EC 51 33 D2 89 4D FC 89 11 33 C0 89 51 04 89 51 08 89 51 0C 66 89 41 32 8B C1 89 51 10 89 51 14 89 51 18 89 51 1C 89 51 20 89 51 24 89 51 28 88 51 30 89 51 38 88 51 3C 89 91 40 04 00 00 89 91 44 04 00 00 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_149_0 {
	meta:
		name = "??0?$output_adapter_data@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@D@1@_KQBDQAU__crt_locale_pointers@@QAD@Z"
		size = 49
		refs = "0009 ??0?$common_data@D@__crt_stdio_output@@IAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? 8B 45 0C 89 06 8B 45 10 89 46 04 8B 45 18 89 46 08 8B 45 14 89 46 10 8B 45 1C 89 46 14 8B C6 5E 5D C2 18 00 }
	condition:
		$1
}

rule file_175_150_0 {
	meta:
		name = "??0?$output_adapter_data@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@_KQB_WQAU__crt_locale_pointers@@QAD@Z"
		size = 49
		refs = "0009 ??0?$common_data@_W@__crt_stdio_output@@IAE@XZ"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B F1 E8 ?? ?? ?? ?? 8B 45 0C 89 06 8B 45 10 89 46 04 8B 45 18 89 46 08 8B 45 14 89 46 10 8B 45 1C 89 46 14 8B C6 5E 5D C2 18 00 }
	condition:
		$1
}

rule file_175_151_0 {
	meta:
		name = "??0?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@ABV?$console_output_adapter@D@1@_KQBDQAU__crt_locale_pointers@@QAD@Z"
		size = 45
		refs = "001b ??0?$output_adapter_data@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@D@1@_KQBDQAU__crt_locale_pointers@@QAD@Z"
		altNames = "??0?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@ABV?$console_output_adapter@D@1@_KQBDQAU__crt_locale_pointers@@QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 1C 8B F1 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 A6 50 04 00 00 00 8B C6 5E 5D C2 18 00 }
	condition:
		$1
}

rule file_175_154_0 {
	meta:
		name = "??0?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@ABV?$console_output_adapter@_W@1@_KQB_WQAU__crt_locale_pointers@@QAD@Z"
		size = 45
		refs = "001b ??0?$output_adapter_data@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@_KQB_WQAU__crt_locale_pointers@@QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 1C 8B F1 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 A6 50 04 00 00 00 8B C6 5E 5D C2 18 00 }
	condition:
		$1
}

rule file_175_156_0 {
	meta:
		name = "??0?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@ABV?$console_output_adapter@_W@1@_KQB_WQAU__crt_locale_pointers@@QAD@Z"
		size = 45
		refs = "001b ??0?$output_adapter_data@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@_KQB_WQAU__crt_locale_pointers@@QAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 FF 75 1C 8B F1 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 A6 50 04 00 00 00 8B C6 5E 5D C2 18 00 }
	condition:
		$1
}

rule file_175_152_0 {
	meta:
		name = "??0?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@ABV?$console_output_adapter@D@1@_KQBDQAU__crt_locale_pointers@@QAD@Z"
		size = 39
		refs = "001c ??$?0ABV?$console_output_adapter@D@__crt_stdio_output@@AB_KABQBDABQAU__crt_locale_pointers@@ABQAD@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@D@1@AB_KABQBDABQAU__crt_locale_pointers@@ABQAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 1C 8B F1 50 8D 45 18 50 8D 45 14 50 8D 45 0C 50 FF 75 08 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 18 00 }
	condition:
		$1
}

rule file_175_155_0 {
	meta:
		name = "??0?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAE@ABV?$console_output_adapter@_W@1@_KQB_WQAU__crt_locale_pointers@@QAD@Z"
		size = 39
		refs = "001c ??$?0ABV?$console_output_adapter@_W@__crt_stdio_output@@AB_KABQB_WABQAU__crt_locale_pointers@@ABQAD@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE@ABV?$console_output_adapter@_W@1@AB_KABQB_WABQAU__crt_locale_pointers@@ABQAD@Z"
	strings:
		$1 = { 8B FF 55 8B EC 56 8D 45 1C 8B F1 50 8D 45 18 50 8D 45 14 50 8D 45 0C 50 FF 75 08 E8 ?? ?? ?? ?? 8B C6 5E 5D C2 18 00 }
	condition:
		$1
}

rule file_175_160_0 {
	meta:
		name = "??0formatting_buffer@__crt_stdio_output@@QAE@XZ"
		size = 17
	strings:
		$1 = { 83 A1 00 04 00 00 00 8B C1 83 A1 04 04 00 00 00 C3 }
	condition:
		$1
}

rule file_175_180_0 {
	meta:
		name = "??1formatting_buffer@__crt_stdio_output@@QAE@XZ"
		size = 29
		refs = "000e __free_dbg"
	strings:
		$1 = { 8B FF 56 8B F1 6A 02 FF B6 04 04 00 00 E8 ?? ?? ?? ?? 83 A6 04 04 00 00 00 59 59 5E C3 }
	condition:
		$1
}

rule file_175_184_0 {
	meta:
		name = "?adjust_hexit@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CADH_N@Z"
		size = 30
		altNames = "?adjust_hexit@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CADH_N@Z ?adjust_hexit@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@CADH_N@Z ?adjust_hexit@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CADH_N@Z ?adjust_hexit@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CADH_N@Z ?adjust_hexit@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@CADH_N@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 08 33 C9 38 4D 0C 0F 94 C1 83 C0 C6 49 83 E1 E0 83 C1 61 03 C1 5D C3 }
	condition:
		$1
}

rule file_175_190_0 {
	meta:
		name = "?advance_to_next_pass@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ"
		size = 76
		altNames = "?advance_to_next_pass@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ"
	strings:
		$1 = { 8B C1 FF 80 58 04 00 00 8B 88 58 04 00 00 83 F9 03 75 03 32 C0 C3 83 F9 02 75 09 83 B8 5C 04 00 00 01 74 EF 83 88 A4 0A 00 00 FF 33 C9 83 88 A8 0A 00 00 FF 89 88 5C 04 00 00 89 48 24 89 48 28 8B 88 60 04 00 00 89 48 10 B0 01 C3 }
	condition:
		$1
}

rule file_175_192_0 {
	meta:
		name = "?advance_to_next_pass@?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ"
		size = 19
		altNames = "?advance_to_next_pass@?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ"
	strings:
		$1 = { FF 81 50 04 00 00 33 C0 83 B9 50 04 00 00 02 0F 95 C0 C3 }
	condition:
		$1
}

rule file_175_194_0 {
	meta:
		name = "?crop_zeroes@__crt_stdio_output@@YAXPADQAU__crt_locale_pointers@@@Z"
		size = 87
	strings:
		$1 = { 8B FF 55 8B EC 8B 45 0C 8B 4D 08 53 8B 00 8B 80 88 00 00 00 8B 00 8A 18 EB 05 3A C3 74 07 41 8A 01 84 C0 75 F5 8A 01 41 84 C0 74 28 EB 09 3C 65 74 0B 3C 45 74 07 41 8A 01 84 C0 75 F1 8B D1 49 80 39 30 74 FA 38 19 75 01 49 8A 02 41 42 88 01 84 C0 75 F6 5B 5D C3 }
	condition:
		$1
}

rule file_175_195_0 {
	meta:
		name = "?find_next_state@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE?AW4state@2@DW432@@Z"
		size = 53
		refs = "0015 _format_validation_lookup_table"
		altNames = "?find_next_state@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE?AW4state@2@DW432@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8A 4D 08 8D 41 E0 3C 5A 77 0F 0F BE C1 0F B6 80 ?? ?? ?? ?? 83 E0 0F EB 02 33 C0 6B C8 09 8B 45 0C 0F B6 84 01 ?? ?? ?? ?? C1 E8 04 5D C2 08 00 }
	condition:
		$1
}

rule file_175_197_0 {
	meta:
		name = "?find_next_state@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE?AW4state@2@DW432@@Z"
		size = 50
		refs = "0015 _standard_lookup_table"
	strings:
		$1 = { 8B FF 55 8B EC 8A 4D 08 8D 41 E0 3C 5A 77 0F 0F BE C1 0F B6 88 ?? ?? ?? ?? 83 E1 0F EB 02 33 C9 8B 45 0C 0F B6 84 C8 ?? ?? ?? ?? C1 E8 04 5D C2 08 00 }
	condition:
		$1
}

rule file_175_198_0 {
	meta:
		name = "?find_next_state@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE?AW4state@2@_WW432@@Z"
		size = 55
		refs = "0017 _format_validation_lookup_table"
		altNames = "?find_next_state@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE?AW4state@2@_WW432@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 41 E0 66 83 F8 5A 77 0F 0F B7 C1 0F B6 80 ?? ?? ?? ?? 83 E0 0F EB 02 33 C0 6B C8 09 8B 45 0C 0F B6 84 01 ?? ?? ?? ?? C1 E8 04 5D C2 08 00 }
	condition:
		$1
}

rule file_175_200_0 {
	meta:
		name = "?find_next_state@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE?AW4state@2@_WW432@@Z"
		size = 52
		refs = "0017 _standard_lookup_table"
	strings:
		$1 = { 8B FF 55 8B EC 8B 4D 08 8D 41 E0 66 83 F8 5A 77 0F 0F B7 C1 0F B6 88 ?? ?? ?? ?? 83 E1 0F EB 02 33 C9 8B 45 0C 0F B6 84 C8 ?? ?? ?? ?? C1 E8 04 5D C2 08 00 }
	condition:
		$1
}

rule file_175_201_0 {
	meta:
		name = "?force_decimal_point@__crt_stdio_output@@YAXPADQAU__crt_locale_pointers@@@Z"
		size = 92
		refs = "000e _tolower 001d _isdigit"
	strings:
		$1 = { 8B FF 55 8B EC 56 8B 75 08 0F BE 06 50 E8 ?? ?? ?? ?? 83 F8 65 EB 0C 46 0F B6 06 50 E8 ?? ?? ?? ?? 85 C0 59 75 F1 0F BE 06 50 E8 ?? ?? ?? ?? 59 83 F8 78 75 03 83 C6 02 8B 45 0C 8A 0E 8B 00 8B 80 88 00 00 00 8B 00 8A 00 88 06 46 8A 06 88 0E 8A C8 8A 06 46 84 C0 75 F3 5E 5D C3 }
	condition:
		$1
}

rule file_175_203_0 {
	meta:
		name = "?get@__crt_deferred_errno_cache@@QAEAAHXZ"
		size = 21
		refs = "000b __errno"
	strings:
		$1 = { 8B FF 56 8B F1 83 3E 00 75 07 E8 ?? ?? ?? ?? 89 06 8B 06 5E C3 }
	condition:
		$1
}

rule file_175_220_0 {
	meta:
		name = "?has_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE_NI@Z"
		size = 21
		altNames = "?has_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE_NI@Z ?has_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE_NI@Z ?has_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE_NI@Z ?has_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE_NI@Z ?has_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE_NI@Z"
	strings:
		$1 = { 8B FF 55 8B EC 8B 41 20 23 45 08 F7 D8 1B C0 F7 D8 5D C2 04 00 }
	condition:
		$1
}

rule file_175_226_0 {
	meta:
		name = "?is_positional_parameter_reappearance_consistent@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@AAE_NABUparameter_data@12@W4parameter_type@12@DW4length_modifier@2@@Z"
		size = 302
		refs = "008b ??$is_integral_specifier@D@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@CA_ND@Z 00cc ?to_integer_size@__crt_stdio_output@@YAIW4length_modifier@1@@Z 00fa ??$is_wide_character_specifier@D@__crt_stdio_output@@YA_N_KDW4length_modifier@0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 8B 5D 10 56 8B 75 08 57 8B F9 8A 4E 04 80 F9 70 89 4D F8 0F 94 C6 80 FB 70 0F 94 C2 84 F6 0F 85 F2 00 00 00 84 D2 0F 85 EA 00 00 00 33 C0 80 F9 73 74 08 88 45 FF 80 F9 53 75 04 C6 45 FF 01 80 FB 73 74 07 8A F0 80 FB 53 75 02 B6 01 80 F9 63 74 07 8A D0 80 F9 43 75 02 B2 01 80 FB 63 74 05 80 FB 43 75 02 B0 01 80 7D FF 00 75 72 84 F6 0F 85 9D 00 00 00 84 D2 75 6B 84 C0 0F 85 91 00 00 00 51 E8 ?? ?? ?? ?? 53 88 45 FF E8 ?? ?? ?? ?? 59 59 8A 4D FF 84 C9 75 0D 84 C0 75 75 8B 0E 33 C0 3B 4D 0C EB 74 3A C8 75 68 33 C9 83 7E 0C 09 0F 94 C1 33 C0 83 7D 14 09 0F 94 C0 3B C8 75 52 FF 76 0C E8 ?? ?? ?? ?? FF 75 14 8B D8 E8 ?? ?? ?? ?? 2B D8 F7 DB 59 1B DB 43 59 8A C3 EB 3E 38 75 FF 75 2E 3A D0 75 2A FF 75 14 53 FF 77 04 FF 37 E8 ?? ?? ?? ?? FF 76 0C 8A D8 FF 75 F8 FF 77 04 FF 37 E8 ?? ?? ?? ?? 83 C4 20 3A C3 0F 94 C0 EB 0B 32 C0 EB 07 33 C0 3A F2 0F 94 C0 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_175_227_0 {
	meta:
		name = "?is_positional_parameter_reappearance_consistent@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@AAE_NABUparameter_data@12@W4parameter_type@12@_WW4length_modifier@2@@Z"
		size = 291
		refs = "0038 ??$is_string_specifier@_W@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@CA_N_W@Z 004a ??$is_character_specifier@_W@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@CA_N_W@Z 007b ??$is_integral_specifier@_W@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@CA_N_W@Z 00ba ?to_integer_size@__crt_stdio_output@@YAIW4length_modifier@1@@Z 00ee ??$is_wide_character_specifier@_W@__crt_stdio_output@@YA_N_K_WW4length_modifier@0@@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 51 53 8B 5D 10 56 8B 75 08 57 6A 70 58 0F B7 7E 04 66 3B F8 89 4D F8 0F 94 C2 66 3B D8 0F 94 C1 84 D2 0F 85 E5 00 00 00 84 C9 0F 85 DD 00 00 00 57 E8 ?? ?? ?? ?? 53 88 45 FD E8 ?? ?? ?? ?? 57 88 45 FF E8 ?? ?? ?? ?? 53 88 45 FE E8 ?? ?? ?? ?? 8A 4D FD 83 C4 10 84 C9 75 74 38 4D FF 0F 85 A5 00 00 00 8A 4D FE 84 C9 75 6C 84 C0 0F 85 96 00 00 00 57 E8 ?? ?? ?? ?? FF 75 10 8A D8 E8 ?? ?? ?? ?? 59 59 84 DB 75 0D 84 C0 75 7C 8B 0E 33 C0 3B 4D 0C EB 7B 3A D8 75 6F 33 C9 83 7E 0C 09 0F 94 C1 33 C0 83 7D 14 09 0F 94 C0 3B C8 75 59 FF 76 0C E8 ?? ?? ?? ?? FF 75 14 8B D8 E8 ?? ?? ?? ?? 2B D8 F7 DB 59 1B DB 43 59 8A C3 EB 45 3A 4D FF 75 35 8A 4D FE 3A C8 75 2E FF 75 14 8B 45 F8 53 FF 70 04 FF 30 E8 ?? ?? ?? ?? FF 76 0C 8A D8 8B 45 F8 57 FF 70 04 FF 30 E8 ?? ?? ?? ?? 83 C4 20 3A C3 0F 94 C0 EB 0B 32 C0 EB 07 33 C0 3A D1 0F 94 C0 5F 5E 5B 8B E5 5D C2 10 00 }
	condition:
		$1
}

rule file_175_235_0 {
	meta:
		name = "?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NQAH@Z"
		size = 120
		refs = "0012 __errno 0031 _strtol"
		altNames = "?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NQAH@Z ?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NQAH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B F1 57 83 7E 0C 00 75 08 E8 ?? ?? ?? ?? 89 46 0C 8B 7E 0C 8D 4D FC 6A 0A 51 8B 1F 83 27 00 8B 46 10 83 65 FC 00 48 50 E8 ?? ?? ?? ?? 8B 4D 08 83 C4 0C 89 01 83 7E 0C 00 75 08 E8 ?? ?? ?? ?? 89 46 0C 8B 46 0C 83 38 22 74 0F 8B 45 FC 3B 46 10 72 07 89 46 10 B0 01 EB 02 32 C0 83 3F 00 75 06 85 DB 74 02 89 1F 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_175_238_0 {
	meta:
		name = "?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NQAH@Z"
		size = 122
		refs = "0012 __errno 0033 _wcstol"
		altNames = "?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NQAH@Z ?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NQAH@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B F1 57 83 7E 0C 00 75 08 E8 ?? ?? ?? ?? 89 46 0C 8B 7E 0C 8D 4D FC 6A 0A 51 8B 1F 83 27 00 8B 46 10 83 65 FC 00 83 E8 02 50 E8 ?? ?? ?? ?? 8B 4D 08 83 C4 0C 89 01 83 7E 0C 00 75 08 E8 ?? ?? ?? ?? 89 46 0C 8B 46 0C 83 38 22 74 0F 8B 45 FC 3B 46 10 72 07 89 46 10 B0 01 EB 02 32 C0 83 3F 00 75 06 85 DB 74 02 89 1F 5F 5E 5B 8B E5 5D C2 04 00 }
	condition:
		$1
}

rule file_175_241_0 {
	meta:
		name = "?process@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ"
		size = 400
		refs = "001a ??_C@_1CM@JOIJBMEM@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAi?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 001f ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0025 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0033 __CrtDbgReportW 0041 __errno 004d ??_C@_1BLG@HKIOHBGE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0059 __invalid_parameter 008a ?find_next_state@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE?AW4state@2@DW432@@Z 00a2 $LN58 00a9 ?state_case_normal@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00c7 ?state_case_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00d0 ?state_case_width@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00de ?state_case_precision@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00e7 ?state_case_size@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00f0 ?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0112 ?validate_and_update_state_at_end_of_format_string@?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IBE_NXZ 0139 ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@ 0170 $LN13 0174 $LN14 0178 $LN15 017c $LN16 0180 $LN17 0184 $LN18 0188 $LN19 018c $LN20"
	strings:
		$1 = { 8B FF 53 56 8B F1 33 C0 33 DB 57 39 5E 10 0F 95 C0 85 C0 0F 85 05 01 00 00 BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 53 68 58 06 00 00 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 58 06 00 00 56 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 CC 00 00 00 89 5E 38 89 5E 1C E9 89 00 00 00 FF 46 10 39 5E 18 0F 8C 90 00 00 00 FF 76 1C 0F B6 46 31 8B CE 50 E8 ?? ?? ?? ?? 89 46 1C 83 F8 08 0F 84 9E 00 00 00 83 F8 07 77 C1 FF 24 85 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? EB 45 83 4E 28 FF 89 5E 24 88 5E 30 89 5E 20 89 5E 2C 88 5E 3C EB 38 8B CE E8 ?? ?? ?? ?? EB 27 8B CE E8 ?? ?? ?? ?? EB 1E 89 5E 28 EB 21 8B CE E8 ?? ?? ?? ?? EB 10 8B CE E8 ?? ?? ?? ?? EB 07 8B CE E8 ?? ?? ?? ?? 84 C0 0F 84 64 FF FF FF 8B 46 10 8A 00 88 46 31 84 C0 0F 85 67 FF FF FF FF 46 10 8B CE E8 ?? ?? ?? ?? 84 C0 0F 84 42 FF FF FF FF 86 50 04 00 00 83 BE 50 04 00 00 02 0F 85 37 FF FF FF 8B 46 18 5F 5E 5B C3 BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 53 68 6C 06 00 00 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 6C 06 00 00 E9 DC FE FF FF 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_242_0 {
	meta:
		name = "?process@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ"
		size = 444
		refs = "0016 ??_C@_1CM@JOIJBMEM@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAi?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 001b ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0021 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002f __CrtDbgReportW 003d __errno 0049 ??_C@_1BLM@CNOJLNJD@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0055 __invalid_parameter 0065 ?advance_to_next_pass@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ 0096 ?find_next_state@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE?AW4state@2@DW432@@Z 00a0 ?validate_and_update_state_at_beginning_of_format_character@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ 00c4 $LN51 00cb ?state_case_normal@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00e8 ?state_case_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00f1 ?state_case_width@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00ff ?state_case_precision@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0108 ?state_case_size@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0111 ?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 012f ?validate_and_update_state_at_end_of_format_string@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ 014e ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@ 019c $LN13 01a0 $LN14 01a4 $LN15 01a8 $LN16 01ac $LN17 01b0 $LN18 01b4 $LN19 01b8 $LN20"
	strings:
		$1 = { 8B FF 53 56 8B F1 33 C0 33 DB 57 39 5E 10 0F 95 C0 85 C0 75 4F BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 53 68 58 06 00 00 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 58 06 00 00 56 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E5 00 00 00 E8 ?? ?? ?? ?? 84 C0 0F 84 D5 00 00 00 83 CF FF 89 5E 38 89 5E 1C E9 9A 00 00 00 FF 46 10 39 5E 18 0F 8C A1 00 00 00 FF 76 1C 0F B6 46 31 8B CE 50 E8 ?? ?? ?? ?? 8B CE 89 46 1C E8 ?? ?? ?? ?? 84 C0 0F 84 EB 00 00 00 8B 46 1C 83 F8 08 0F 84 95 00 00 00 83 F8 07 0F 87 D6 00 00 00 FF 24 85 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? EB 44 89 5E 24 88 5E 30 89 5E 20 89 7E 28 89 5E 2C 88 5E 3C EB 34 8B CE E8 ?? ?? ?? ?? EB 27 8B CE E8 ?? ?? ?? ?? EB 1E 89 5E 28 EB 1D 8B CE E8 ?? ?? ?? ?? EB 10 8B CE E8 ?? ?? ?? ?? EB 07 8B CE E8 ?? ?? ?? ?? 84 C0 74 7E 8B 46 10 8A 00 88 46 31 84 C0 0F 85 56 FF FF FF FF 46 10 8B CE E8 ?? ?? ?? ?? 84 C0 74 60 8B CE E8 ?? ?? ?? ?? 84 C0 0F 85 2E FF FF FF 8B 46 18 5F 5E 5B C3 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 68 6C 06 00 00 BE ?? ?? ?? ?? 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 6C 06 00 00 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB AE 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_243_0 {
	meta:
		name = "?process@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ"
		size = 384
		refs = "001a ??_C@_1CM@JOIJBMEM@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAi?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 001f ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0025 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0033 __CrtDbgReportW 0041 __errno 004d ??_C@_1BKE@EJAONHIE@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0059 __invalid_parameter 008a ?find_next_state@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE?AW4state@2@DW432@@Z 00a2 $LN60 00a9 ?state_case_normal@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00c7 ?state_case_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00d0 ?state_case_width@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00de ?state_case_precision@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00e7 ?state_case_size@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00f0 ?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 012a ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@ 0160 $LN13 0164 $LN14 0168 $LN15 016c $LN16 0170 $LN17 0174 $LN18 0178 $LN19 017c $LN20"
	strings:
		$1 = { 8B FF 53 56 8B F1 33 C0 33 DB 57 39 5E 10 0F 95 C0 85 C0 0F 85 F6 00 00 00 BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 53 68 58 06 00 00 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 58 06 00 00 56 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 BD 00 00 00 89 5E 38 89 5E 1C E9 89 00 00 00 FF 46 10 39 5E 18 0F 8C 90 00 00 00 FF 76 1C 0F B6 46 31 8B CE 50 E8 ?? ?? ?? ?? 89 46 1C 83 F8 08 0F 84 8F 00 00 00 83 F8 07 77 C1 FF 24 85 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? EB 45 83 4E 28 FF 89 5E 24 88 5E 30 89 5E 20 89 5E 2C 88 5E 3C EB 38 8B CE E8 ?? ?? ?? ?? EB 27 8B CE E8 ?? ?? ?? ?? EB 1E 89 5E 28 EB 21 8B CE E8 ?? ?? ?? ?? EB 10 8B CE E8 ?? ?? ?? ?? EB 07 8B CE E8 ?? ?? ?? ?? 84 C0 0F 84 64 FF FF FF 8B 46 10 8A 00 88 46 31 84 C0 0F 85 67 FF FF FF FF 46 10 FF 86 50 04 00 00 83 BE 50 04 00 00 02 0F 85 46 FF FF FF 8B 46 18 5F 5E 5B C3 BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 53 68 6C 06 00 00 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 6C 06 00 00 E9 EB FE FF FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_244_0 {
	meta:
		name = "?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ"
		size = 416
		refs = "0016 ??_C@_1CM@JOIJBMEM@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAi?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 001b ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0021 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002f __CrtDbgReportW 003d __errno 0049 ??_C@_1BMO@BFJMLNMJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0055 __invalid_parameter 008e ?find_next_state@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE?AW4state@2@_WW432@@Z 00a6 $LN59 00ad ?state_case_normal@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00cb ?state_case_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00d4 ?state_case_width@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00e2 ?state_case_precision@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00eb ?state_case_size@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00f4 ?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0119 ?validate_and_update_state_at_end_of_format_string@?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IBE_NXZ 013f ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@ 0180 $LN13 0184 $LN14 0188 $LN15 018c $LN16 0190 $LN17 0194 $LN18 0198 $LN19 019c $LN20"
	strings:
		$1 = { 8B FF 53 56 8B F1 33 C0 33 DB 57 39 5E 10 0F 95 C0 85 C0 75 4F BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 53 68 58 06 00 00 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 58 06 00 00 56 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D6 00 00 00 6A 02 5F E9 B9 00 00 00 89 5E 38 89 5E 1C E9 89 00 00 00 01 7E 10 39 5E 18 0F 8C 93 00 00 00 FF 76 1C 0F B7 46 32 8B CE 50 E8 ?? ?? ?? ?? 89 46 1C 83 F8 08 0F 84 A0 00 00 00 83 F8 07 77 B9 FF 24 85 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? EB 45 83 4E 28 FF 89 5E 24 88 5E 30 89 5E 20 89 5E 2C 88 5E 3C EB 38 8B CE E8 ?? ?? ?? ?? EB 27 8B CE E8 ?? ?? ?? ?? EB 1E 89 5E 28 EB 21 8B CE E8 ?? ?? ?? ?? EB 10 8B CE E8 ?? ?? ?? ?? EB 07 8B CE E8 ?? ?? ?? ?? 84 C0 0F 84 5C FF FF FF 8B 46 10 0F B7 00 66 89 46 32 66 85 C0 0F 85 64 FF FF FF 01 7E 10 8B CE E8 ?? ?? ?? ?? 84 C0 0F 84 37 FF FF FF FF 86 50 04 00 00 39 BE 50 04 00 00 0F 85 35 FF FF FF 8B 46 18 5F 5E 5B C3 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 68 6C 06 00 00 BE ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 6C 06 00 00 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 D0 FE FF FF 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_245_0 {
	meta:
		name = "?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ"
		size = 452
		refs = "0016 ??_C@_1CM@JOIJBMEM@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAi?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 001b ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0021 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002f __CrtDbgReportW 003d __errno 0049 ??_C@_1BNE@IJFKJKMM@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0055 __invalid_parameter 0065 ?advance_to_next_pass@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ 0097 ?find_next_state@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE?AW4state@2@_WW432@@Z 00a1 ?validate_and_update_state_at_beginning_of_format_character@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ 00c5 $LN51 00cc ?state_case_normal@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00e9 ?state_case_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00f2 ?state_case_width@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0100 ?state_case_precision@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0109 ?state_case_size@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0112 ?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0138 ?validate_and_update_state_at_end_of_format_string@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ 0157 ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@ 01a4 $LN13 01a8 $LN14 01ac $LN15 01b0 $LN16 01b4 $LN17 01b8 $LN18 01bc $LN19 01c0 $LN20"
	strings:
		$1 = { 8B FF 53 56 8B F1 33 C0 33 DB 57 39 5E 10 0F 95 C0 85 C0 75 4F BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 53 68 58 06 00 00 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 58 06 00 00 56 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 EE 00 00 00 E8 ?? ?? ?? ?? 84 C0 0F 84 DE 00 00 00 83 CF FF 89 5E 38 89 5E 1C E9 9F 00 00 00 83 46 10 02 39 5E 18 0F 8C A9 00 00 00 FF 76 1C 0F B7 46 32 8B CE 50 E8 ?? ?? ?? ?? 8B CE 89 46 1C E8 ?? ?? ?? ?? 84 C0 0F 84 F3 00 00 00 8B 46 1C 83 F8 08 0F 84 9D 00 00 00 83 F8 07 0F 87 DE 00 00 00 FF 24 85 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? EB 44 89 5E 24 88 5E 30 89 5E 20 89 7E 28 89 5E 2C 88 5E 3C EB 38 8B CE E8 ?? ?? ?? ?? EB 27 8B CE E8 ?? ?? ?? ?? EB 1E 89 5E 28 EB 21 8B CE E8 ?? ?? ?? ?? EB 10 8B CE E8 ?? ?? ?? ?? EB 07 8B CE E8 ?? ?? ?? ?? 84 C0 0F 84 82 00 00 00 8B 46 10 0F B7 00 66 89 46 32 66 85 C0 0F 85 4E FF FF FF 83 46 10 02 8B CE E8 ?? ?? ?? ?? 84 C0 74 60 8B CE E8 ?? ?? ?? ?? 84 C0 0F 85 25 FF FF FF 8B 46 18 5F 5E 5B C3 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 68 6C 06 00 00 BE ?? ?? ?? ?? 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 6C 06 00 00 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB AE ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_246_0 {
	meta:
		name = "?process@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@QAEHXZ"
		size = 400
		refs = "0016 ??_C@_1CM@JOIJBMEM@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAi?$AAt?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AAn?$AAu?$AAl?$AAl?$AAp?$AAt?$AAr?$AA?$AA@ 001b ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0021 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 002f __CrtDbgReportW 003d __errno 0049 ??_C@_1BLM@MEMPCIGD@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0055 __invalid_parameter 008e ?find_next_state@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@ABE?AW4state@2@_WW432@@Z 00a6 $LN60 00ad ?state_case_normal@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00cb ?state_case_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00d4 ?state_case_width@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00e2 ?state_case_precision@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00eb ?state_case_size@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00f4 ?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0130 ??_C@_1EE@DMAIGNBG@?$AA?$CI?$AA?$CC?$AAI?$AAn?$AAc?$AAo?$AAr?$AAr?$AAe?$AAc?$AAt?$AA?5?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?$CC?$AA?0?$AA?5?$AA0@ 0170 $LN13 0174 $LN14 0178 $LN15 017c $LN16 0180 $LN17 0184 $LN18 0188 $LN19 018c $LN20"
	strings:
		$1 = { 8B FF 53 56 8B F1 33 C0 33 DB 57 39 5E 10 0F 95 C0 85 C0 75 4F BF ?? ?? ?? ?? BE ?? ?? ?? ?? 57 68 ?? ?? ?? ?? 53 68 58 06 00 00 56 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 58 06 00 00 56 68 ?? ?? ?? ?? 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 C7 00 00 00 6A 02 5F E9 AA 00 00 00 89 5E 38 89 5E 1C E9 89 00 00 00 01 7E 10 39 5E 18 0F 8C 93 00 00 00 FF 76 1C 0F B7 46 32 8B CE 50 E8 ?? ?? ?? ?? 89 46 1C 83 F8 08 0F 84 91 00 00 00 83 F8 07 77 B9 FF 24 85 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? EB 45 83 4E 28 FF 89 5E 24 88 5E 30 89 5E 20 89 5E 2C 88 5E 3C EB 38 8B CE E8 ?? ?? ?? ?? EB 27 8B CE E8 ?? ?? ?? ?? EB 1E 89 5E 28 EB 21 8B CE E8 ?? ?? ?? ?? EB 10 8B CE E8 ?? ?? ?? ?? EB 07 8B CE E8 ?? ?? ?? ?? 84 C0 0F 84 5C FF FF FF 8B 46 10 0F B7 00 66 89 46 32 66 85 C0 0F 85 64 FF FF FF 01 7E 10 FF 86 50 04 00 00 39 BE 50 04 00 00 0F 85 44 FF FF FF 8B 46 18 5F 5E 5B C3 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 68 6C 06 00 00 BE ?? ?? ?? ?? 56 57 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 53 68 6C 06 00 00 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 DF FE FF FF 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_254_0 {
	meta:
		name = "?should_format@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ"
		size = 22
		altNames = "?should_format@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ"
	strings:
		$1 = { 33 C0 40 39 81 58 04 00 00 75 0A 39 81 5C 04 00 00 74 02 33 C0 C3 }
	condition:
		$1
}

rule file_175_258_0 {
	meta:
		name = "?should_skip_normal_state_processing@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ"
		size = 40
		altNames = "?should_skip_normal_state_processing@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ"
	strings:
		$1 = { 8B 91 58 04 00 00 83 FA 01 75 0C 83 B9 5C 04 00 00 02 75 03 B0 01 C3 83 FA 02 75 09 83 B9 5C 04 00 00 00 74 EF 32 C0 C3 }
	condition:
		$1
}

rule file_175_262_0 {
	meta:
		name = "?should_skip_type_state_output@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IBE_NXZ"
		size = 23
		altNames = "?should_skip_type_state_output@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IBE_NXZ"
	strings:
		$1 = { 83 B9 5C 04 00 00 02 75 0B 33 C0 40 39 81 58 04 00 00 74 02 33 C0 C3 }
	condition:
		$1
}

rule file_175_272_0 {
	meta:
		name = "?state_case_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 61
		altNames = "?state_case_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ ?state_case_flag@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
	strings:
		$1 = { 0F BE 41 31 83 E8 20 74 2D 83 E8 03 74 22 83 E8 08 74 17 48 83 E8 01 74 0B 83 E8 03 75 1C 83 49 20 08 EB 16 83 49 20 04 EB 10 83 49 20 01 EB 0A 83 49 20 20 EB 04 83 49 20 02 B0 01 C3 }
	condition:
		$1
}

rule file_175_275_0 {
	meta:
		name = "?state_case_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 61
		altNames = "?state_case_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ ?state_case_flag@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
	strings:
		$1 = { 0F B7 41 32 83 E8 20 74 2D 83 E8 03 74 22 83 E8 08 74 17 48 83 E8 01 74 0B 83 E8 03 75 1C 83 49 20 08 EB 16 83 49 20 04 EB 10 83 49 20 01 EB 0A 83 49 20 20 EB 04 83 49 20 02 B0 01 C3 }
	condition:
		$1
}

rule file_175_278_0 {
	meta:
		name = "?state_case_normal@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 97
		refs = "0001 ?state_case_normal_common@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0014 ??_C@_1DG@CEJKFDMO@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA_?$AAc?$AAa?$AAs?$AAe?$AA_?$AAn?$AAo?$AAr?$AAm?$AAa?$AAl?$AA_?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA?$CI?$AA?$CJ?$AA?$AA@ 001f ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0026 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 002e __CrtDbgReportW 003c __errno 0045 ??_C@_1BMK@BGPKBIHJ@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0051 __invalid_parameter"
	strings:
		$1 = { E8 ?? ?? ?? ?? 33 C9 84 C0 0F 95 C1 85 C9 75 4E 53 56 57 BE ?? ?? ?? ?? BF 99 06 00 00 56 68 ?? ?? ?? ?? 51 57 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5B C3 B0 01 C3 }
	condition:
		$1
}

rule file_175_280_0 {
	meta:
		name = "?state_case_normal@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 97
		refs = "0001 ?state_case_normal_common@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0014 ??_C@_1DG@CEJKFDMO@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA_?$AAc?$AAa?$AAs?$AAe?$AA_?$AAn?$AAo?$AAr?$AAm?$AAa?$AAl?$AA_?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA?$CI?$AA?$CJ?$AA?$AA@ 001f ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0026 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 002e __CrtDbgReportW 003c __errno 0045 ??_C@_1BLI@LHEFBLJN@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0051 __invalid_parameter"
	strings:
		$1 = { E8 ?? ?? ?? ?? 33 C9 84 C0 0F 95 C1 85 C9 75 4E 53 56 57 BE ?? ?? ?? ?? BF 99 06 00 00 56 68 ?? ?? ?? ?? 51 57 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5B C3 B0 01 C3 }
	condition:
		$1
}

rule file_175_281_0 {
	meta:
		name = "?state_case_normal@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 97
		refs = "0001 ?state_case_normal_common@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0014 ??_C@_1DG@CEJKFDMO@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA_?$AAc?$AAa?$AAs?$AAe?$AA_?$AAn?$AAo?$AAr?$AAm?$AAa?$AAl?$AA_?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA?$CI?$AA?$CJ?$AA?$AA@ 001f ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0026 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 002e __CrtDbgReportW 003c __errno 0045 ??_C@_1BOC@HIGGHJKM@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0051 __invalid_parameter"
	strings:
		$1 = { E8 ?? ?? ?? ?? 33 C9 84 C0 0F 95 C1 85 C9 75 4E 53 56 57 BE ?? ?? ?? ?? BF 99 06 00 00 56 68 ?? ?? ?? ?? 51 57 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5B C3 B0 01 C3 }
	condition:
		$1
}

rule file_175_283_0 {
	meta:
		name = "?state_case_normal@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 97
		refs = "0001 ?state_case_normal_common@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0014 ??_C@_1DG@CEJKFDMO@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA_?$AAc?$AAa?$AAs?$AAe?$AA_?$AAn?$AAo?$AAr?$AAm?$AAa?$AAl?$AA_?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA?$CI?$AA?$CJ?$AA?$AA@ 001f ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0026 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 002e __CrtDbgReportW 003c __errno 0045 ??_C@_1BNA@OADCKKGN@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0051 __invalid_parameter"
	strings:
		$1 = { E8 ?? ?? ?? ?? 33 C9 84 C0 0F 95 C1 85 C9 75 4E 53 56 57 BE ?? ?? ?? ?? BF 99 06 00 00 56 68 ?? ?? ?? ?? 51 57 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5E 5B C3 B0 01 C3 }
	condition:
		$1
}

rule file_175_279_0 {
	meta:
		name = "?state_case_normal@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 113
		refs = "0006 ?should_skip_normal_state_processing@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ 0011 ?state_case_normal_common@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0023 ??_C@_1DG@CEJKFDMO@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA_?$AAc?$AAa?$AAs?$AAe?$AA_?$AAn?$AAo?$AAr?$AAm?$AAa?$AAl?$AA_?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA?$CI?$AA?$CJ?$AA?$AA@ 002e ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0035 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 003d __CrtDbgReportW 004b __errno 0054 ??_C@_1BNA@IDNMDBH@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0060 __invalid_parameter"
	strings:
		$1 = { 8B FF 56 8B F1 E8 ?? ?? ?? ?? 84 C0 75 5F 8B CE E8 ?? ?? ?? ?? 33 C9 84 C0 0F 95 C1 85 C9 75 4D 53 57 BE ?? ?? ?? ?? BF 99 06 00 00 56 68 ?? ?? ?? ?? 51 57 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5B 5E C3 B0 01 5E C3 }
	condition:
		$1
}

rule file_175_282_0 {
	meta:
		name = "?state_case_normal@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 113
		refs = "0006 ?should_skip_normal_state_processing@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ 0011 ?state_case_normal_common@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0023 ??_C@_1DG@CEJKFDMO@?$AAs?$AAt?$AAa?$AAt?$AAe?$AA_?$AAc?$AAa?$AAs?$AAe?$AA_?$AAn?$AAo?$AAr?$AAm?$AAa?$AAl?$AA_?$AAc?$AAo?$AAm?$AAm?$AAo?$AAn?$AA?$CI?$AA?$CJ?$AA?$AA@ 002e ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0035 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 003d __CrtDbgReportW 004b __errno 0054 ??_C@_1BOI@BNAJEEEM@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 0060 __invalid_parameter"
	strings:
		$1 = { 8B FF 56 8B F1 E8 ?? ?? ?? ?? 84 C0 75 5F 8B CE E8 ?? ?? ?? ?? 33 C9 84 C0 0F 95 C1 85 C9 75 4D 53 57 BE ?? ?? ?? ?? BF 99 06 00 00 56 68 ?? ?? ?? ?? 51 57 BB ?? ?? ?? ?? 53 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 53 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 5F 5B 5E C3 B0 01 5E C3 }
	condition:
		$1
}

rule file_175_284_0 {
	meta:
		name = "?state_case_normal_common@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 42
		refs = "0008 ?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_ND@Z 0022 ?write_character@?$console_output_adapter@D@__crt_stdio_output@@QBEXDQAH@Z"
	strings:
		$1 = { 8B FF 56 6A 00 8B F1 E8 ?? ?? ?? ?? 84 C0 75 02 5E C3 8D 46 18 50 0F B6 46 31 8D 8E 48 04 00 00 50 E8 ?? ?? ?? ?? B0 01 5E C3 }
	condition:
		$1
}

rule file_175_285_0 {
	meta:
		name = "?state_case_normal_common@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 42
		refs = "0008 ?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_ND@Z 0022 ?write_character@?$console_output_adapter@D@__crt_stdio_output@@QBEXDQAH@Z"
	strings:
		$1 = { 8B FF 56 6A 00 8B F1 E8 ?? ?? ?? ?? 84 C0 75 02 5E C3 8D 46 18 50 0F B6 46 31 8D 8E 48 04 00 00 50 E8 ?? ?? ?? ?? B0 01 5E C3 }
	condition:
		$1
}

rule file_175_286_0 {
	meta:
		name = "?state_case_normal_common@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 42
		refs = "0008 ?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_ND@Z 0022 ?write_character@?$console_output_adapter@D@__crt_stdio_output@@QBEXDQAH@Z"
	strings:
		$1 = { 8B FF 56 6A 00 8B F1 E8 ?? ?? ?? ?? 84 C0 75 02 5E C3 8D 46 18 50 0F B6 46 31 8D 8E 48 04 00 00 50 E8 ?? ?? ?? ?? B0 01 5E C3 }
	condition:
		$1
}

rule file_175_287_0 {
	meta:
		name = "?state_case_normal_common@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 27
		refs = "0014 ?write_character@?$console_output_adapter@_W@__crt_stdio_output@@QBEX_WQAH@Z"
		altNames = "?state_case_normal_common@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ ?state_case_normal_common@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
	strings:
		$1 = { 8D 51 18 C6 41 3C 01 52 0F B7 51 32 81 C1 48 04 00 00 52 E8 ?? ?? ?? ?? B0 01 C3 }
	condition:
		$1
}

rule file_175_290_0 {
	meta:
		name = "?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_ND@Z"
		size = 159
		refs = "002e ?write_character@?$console_output_adapter@D@__crt_stdio_output@@QBEXDQAH@Z 004d ??_C@_1CK@LGDCECDH@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAc?$AAh?$AAa?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 005f ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0066 __CrtDbgReportW 0074 __errno 0081 ??_C@_1BNG@BIPBMMDF@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 008d __invalid_parameter"
	strings:
		$1 = { 8B FF 56 8B F1 57 BF 00 80 00 00 8B 46 08 8A 4E 31 C6 46 3C 00 0F B6 D1 8B 00 8B 00 66 85 3C 50 74 76 8D 46 18 50 51 8D 8E 48 04 00 00 E8 ?? ?? ?? ?? 8B 4E 10 8A 01 88 46 31 8D 41 01 89 46 10 33 C0 38 46 31 0F 95 C0 85 C0 75 4C BE ?? ?? ?? ?? BF B1 06 00 00 56 68 ?? ?? ?? ?? 50 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 EB 02 B0 01 5F 5E C2 04 00 }
	condition:
		$1
}

rule file_175_291_0 {
	meta:
		name = "?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_ND@Z"
		size = 159
		refs = "002e ?write_character@?$console_output_adapter@D@__crt_stdio_output@@QBEXDQAH@Z 004d ??_C@_1CK@LGDCECDH@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAc?$AAh?$AAa?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 005f ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0066 __CrtDbgReportW 0074 __errno 0081 ??_C@_1BNM@LINJAOH@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 008d __invalid_parameter"
	strings:
		$1 = { 8B FF 56 8B F1 57 BF 00 80 00 00 8B 46 08 8A 4E 31 C6 46 3C 00 0F B6 D1 8B 00 8B 00 66 85 3C 50 74 76 8D 46 18 50 51 8D 8E 48 04 00 00 E8 ?? ?? ?? ?? 8B 4E 10 8A 01 88 46 31 8D 41 01 89 46 10 33 C0 38 46 31 0F 95 C0 85 C0 75 4C BE ?? ?? ?? ?? BF B1 06 00 00 56 68 ?? ?? ?? ?? 50 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 EB 02 B0 01 5F 5E C2 04 00 }
	condition:
		$1
}

rule file_175_292_0 {
	meta:
		name = "?state_case_normal_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_ND@Z"
		size = 159
		refs = "002e ?write_character@?$console_output_adapter@D@__crt_stdio_output@@QBEXDQAH@Z 004d ??_C@_1CK@LGDCECDH@?$AA_?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AA_?$AAc?$AAh?$AAa?$AAr?$AA?5?$AA?$CB?$AA?$DN?$AA?5?$AA?8?$AA?2?$AA0?$AA?8?$AA?$AA@ 0058 ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 005f ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 0066 __CrtDbgReportW 0074 __errno 0081 ??_C@_1BME@EGKCNELI@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 008d __invalid_parameter"
	strings:
		$1 = { 8B FF 56 8B F1 57 BF 00 80 00 00 8B 46 08 8A 4E 31 C6 46 3C 00 0F B6 D1 8B 00 8B 00 66 85 3C 50 74 76 8D 46 18 50 51 8D 8E 48 04 00 00 E8 ?? ?? ?? ?? 8B 4E 10 8A 01 88 46 31 8D 41 01 89 46 10 33 C0 38 46 31 0F 95 C0 85 C0 75 4C BE ?? ?? ?? ?? BF B1 06 00 00 56 68 ?? ?? ?? ?? 50 57 68 ?? ?? ?? ?? 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 6A 00 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 EB 02 B0 01 5F 5E C2 04 00 }
	condition:
		$1
}

rule file_175_296_0 {
	meta:
		name = "?state_case_percent@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 24
		altNames = "?state_case_percent@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ ?state_case_percent@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ ?state_case_percent@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ ?state_case_percent@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ ?state_case_percent@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
	strings:
		$1 = { 83 49 28 FF 33 C0 89 41 24 88 41 30 89 41 20 89 41 2C 88 41 3C B0 01 C3 }
	condition:
		$1
}

rule file_175_302_0 {
	meta:
		name = "?state_case_precision@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 40
		refs = "000b ?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NQAH@Z"
	strings:
		$1 = { 80 79 31 2A 74 0A 8D 41 28 50 E8 ?? ?? ?? ?? C3 83 41 14 04 8B 41 14 8B 40 FC 89 41 28 85 C0 79 04 83 49 28 FF B0 01 C3 }
	condition:
		$1
}

rule file_175_304_0 {
	meta:
		name = "?state_case_precision@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 40
		refs = "000b ?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NQAH@Z"
	strings:
		$1 = { 80 79 31 2A 74 0A 8D 41 28 50 E8 ?? ?? ?? ?? C3 83 41 14 04 8B 41 14 8B 40 FC 89 41 28 85 C0 79 04 83 49 28 FF B0 01 C3 }
	condition:
		$1
}

rule file_175_303_0 {
	meta:
		name = "?state_case_precision@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 58
		refs = "0010 ?parse_int_from_format_string@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NQAH@Z 0017 ?update_precision@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ 0024 ?should_format@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ"
	strings:
		$1 = { 8B FF 56 8B F1 80 7E 31 2A 74 0B 8D 46 28 50 E8 ?? ?? ?? ?? 5E C3 E8 ?? ?? ?? ?? 84 C0 75 02 5E C3 8B CE E8 ?? ?? ?? ?? 84 C0 74 0A 83 7E 28 00 7D 04 83 4E 28 FF B0 01 5E C3 }
	condition:
		$1
}

rule file_175_305_0 {
	meta:
		name = "?state_case_precision@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 41
		refs = "000c ?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NQAH@Z"
	strings:
		$1 = { 66 83 79 32 2A 74 0A 8D 41 28 50 E8 ?? ?? ?? ?? C3 83 41 14 04 8B 41 14 8B 40 FC 89 41 28 85 C0 79 04 83 49 28 FF B0 01 C3 }
	condition:
		$1
}

rule file_175_307_0 {
	meta:
		name = "?state_case_precision@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 41
		refs = "000c ?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NQAH@Z"
	strings:
		$1 = { 66 83 79 32 2A 74 0A 8D 41 28 50 E8 ?? ?? ?? ?? C3 83 41 14 04 8B 41 14 8B 40 FC 89 41 28 85 C0 79 04 83 49 28 FF B0 01 C3 }
	condition:
		$1
}

rule file_175_306_0 {
	meta:
		name = "?state_case_precision@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 59
		refs = "0011 ?parse_int_from_format_string@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NQAH@Z 0018 ?update_precision@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ 0025 ?should_format@?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@__crt_stdio_output@@IAE_NXZ"
	strings:
		$1 = { 8B FF 56 8B F1 66 83 7E 32 2A 74 0B 8D 46 28 50 E8 ?? ?? ?? ?? 5E C3 E8 ?? ?? ?? ?? 84 C0 75 02 5E C3 8B CE E8 ?? ?? ?? ?? 84 C0 74 0A 83 7E 28 00 7D 04 83 4E 28 FF B0 01 5E C3 }
	condition:
		$1
}

rule file_175_308_0 {
	meta:
		name = "?state_case_size@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 492
		refs = "001e ?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0041 ??_C@_1FG@OBJBDPAC@?$AA?$CI?$AA?$CC?$AAN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe@ 004a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0055 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 005d __CrtDbgReportW 006b __errno 0084 ??_C@_1EC@GJPNJDCN@?$AA_?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA_?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?3?$AA?3?$AAn?$AAo?$AAn?$AAe@ 00b7 ??_C@_1BMG@OBMNJJOL@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00c3 __invalid_parameter"
	strings:
		$1 = { 8A 51 31 53 57 80 FA 46 75 1F 8B 01 83 E0 08 83 C8 00 75 0E 5F C7 41 1C 07 00 00 00 5B E9 ?? ?? ?? ?? B0 01 E9 C0 01 00 00 56 33 F6 80 FA 4E 75 46 8B 01 6A 08 5A 23 C2 0B C6 0F 85 A6 01 00 00 BB ?? ?? ?? ?? 89 51 1C 53 68 ?? ?? ?? ?? 56 68 56 07 00 00 BF ?? ?? ?? ?? 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 68 56 07 00 00 EB 3E 33 C0 39 71 2C 0F 94 C0 85 C0 75 4E BB ?? ?? ?? ?? BF ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 56 68 5D 07 00 00 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 68 5D 07 00 00 57 68 ?? ?? ?? ?? 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 E9 17 01 00 00 0F BE C2 83 F8 6A 0F 8F BE 00 00 00 0F 84 AF 00 00 00 83 F8 49 74 4F 83 F8 4C 74 3E 83 F8 54 74 2D 83 F8 68 0F 85 EB 00 00 00 8B 41 10 80 38 68 75 10 40 C7 41 2C 01 00 00 00 89 41 10 E9 D3 00 00 00 C7 41 2C 02 00 00 00 E9 C7 00 00 00 C7 41 2C 0D 00 00 00 E9 BB 00 00 00 C7 41 2C 08 00 00 00 E9 AF 00 00 00 8B 51 10 8A 02 3C 33 75 18 80 7A 01 32 75 12 8D 42 02 C7 41 2C 0A 00 00 00 89 41 10 E9 8E 00 00 00 3C 36 75 15 80 7A 01 34 75 0F 8D 42 02 C7 41 2C 0B 00 00 00 89 41 10 EB 75 3C 64 74 14 3C 69 74 10 3C 6F 74 0C 3C 75 74 08 3C 78 74 04 3C 58 75 5D C7 41 2C 09 00 00 00 EB 54 C7 41 2C 05 00 00 00 EB 4B 83 F8 6C 74 2A 83 F8 74 74 1C 83 F8 77 74 0E 83 F8 7A 75 37 C7 41 2C 06 00 00 00 EB 2E C7 41 2C 0C 00 00 00 EB 25 C7 41 2C 07 00 00 00 EB 1C 8B 41 10 80 38 6C 75 0D 40 C7 41 2C 04 00 00 00 89 41 10 EB 07 C7 41 2C 03 00 00 00 B0 01 5E 5F 5B C3 }
	condition:
		$1
}

rule file_175_309_0 {
	meta:
		name = "?state_case_size@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 492
		refs = "001e ?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0041 ??_C@_1FG@OBJBDPAC@?$AA?$CI?$AA?$CC?$AAN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe@ 004a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0055 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 005d __CrtDbgReportW 006b __errno 0084 ??_C@_1EC@GJPNJDCN@?$AA_?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA_?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?3?$AA?3?$AAn?$AAo?$AAn?$AAe@ 00b7 ??_C@_1BMM@MDMPAJJB@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00c3 __invalid_parameter"
	strings:
		$1 = { 8A 51 31 53 57 80 FA 46 75 1F 8B 01 83 E0 08 83 C8 00 75 0E 5F C7 41 1C 07 00 00 00 5B E9 ?? ?? ?? ?? B0 01 E9 C0 01 00 00 56 33 F6 80 FA 4E 75 46 8B 01 6A 08 5A 23 C2 0B C6 0F 85 A6 01 00 00 BB ?? ?? ?? ?? 89 51 1C 53 68 ?? ?? ?? ?? 56 68 56 07 00 00 BF ?? ?? ?? ?? 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 68 56 07 00 00 EB 3E 33 C0 39 71 2C 0F 94 C0 85 C0 75 4E BB ?? ?? ?? ?? BF ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 56 68 5D 07 00 00 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 68 5D 07 00 00 57 68 ?? ?? ?? ?? 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 E9 17 01 00 00 0F BE C2 83 F8 6A 0F 8F BE 00 00 00 0F 84 AF 00 00 00 83 F8 49 74 4F 83 F8 4C 74 3E 83 F8 54 74 2D 83 F8 68 0F 85 EB 00 00 00 8B 41 10 80 38 68 75 10 40 C7 41 2C 01 00 00 00 89 41 10 E9 D3 00 00 00 C7 41 2C 02 00 00 00 E9 C7 00 00 00 C7 41 2C 0D 00 00 00 E9 BB 00 00 00 C7 41 2C 08 00 00 00 E9 AF 00 00 00 8B 51 10 8A 02 3C 33 75 18 80 7A 01 32 75 12 8D 42 02 C7 41 2C 0A 00 00 00 89 41 10 E9 8E 00 00 00 3C 36 75 15 80 7A 01 34 75 0F 8D 42 02 C7 41 2C 0B 00 00 00 89 41 10 EB 75 3C 64 74 14 3C 69 74 10 3C 6F 74 0C 3C 75 74 08 3C 78 74 04 3C 58 75 5D C7 41 2C 09 00 00 00 EB 54 C7 41 2C 05 00 00 00 EB 4B 83 F8 6C 74 2A 83 F8 74 74 1C 83 F8 77 74 0E 83 F8 7A 75 37 C7 41 2C 06 00 00 00 EB 2E C7 41 2C 0C 00 00 00 EB 25 C7 41 2C 07 00 00 00 EB 1C 8B 41 10 80 38 6C 75 0D 40 C7 41 2C 04 00 00 00 89 41 10 EB 07 C7 41 2C 03 00 00 00 B0 01 5E 5F 5B C3 }
	condition:
		$1
}

rule file_175_310_0 {
	meta:
		name = "?state_case_size@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 492
		refs = "001e ?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0041 ??_C@_1FG@OBJBDPAC@?$AA?$CI?$AA?$CC?$AAN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe@ 004a ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0055 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 005d __CrtDbgReportW 006b __errno 0084 ??_C@_1EC@GJPNJDCN@?$AA_?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA_?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?3?$AA?3?$AAn?$AAo?$AAn?$AAe@ 00b7 ??_C@_1BLE@FJAJINEM@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00c3 __invalid_parameter"
	strings:
		$1 = { 8A 51 31 53 57 80 FA 46 75 1F 8B 01 83 E0 08 83 C8 00 75 0E 5F C7 41 1C 07 00 00 00 5B E9 ?? ?? ?? ?? B0 01 E9 C0 01 00 00 56 33 F6 80 FA 4E 75 46 8B 01 6A 08 5A 23 C2 0B C6 0F 85 A6 01 00 00 BB ?? ?? ?? ?? 89 51 1C 53 68 ?? ?? ?? ?? 56 68 56 07 00 00 BF ?? ?? ?? ?? 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 68 56 07 00 00 EB 3E 33 C0 39 71 2C 0F 94 C0 85 C0 75 4E BB ?? ?? ?? ?? BF ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 56 68 5D 07 00 00 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 68 5D 07 00 00 57 68 ?? ?? ?? ?? 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 E9 17 01 00 00 0F BE C2 83 F8 6A 0F 8F BE 00 00 00 0F 84 AF 00 00 00 83 F8 49 74 4F 83 F8 4C 74 3E 83 F8 54 74 2D 83 F8 68 0F 85 EB 00 00 00 8B 41 10 80 38 68 75 10 40 C7 41 2C 01 00 00 00 89 41 10 E9 D3 00 00 00 C7 41 2C 02 00 00 00 E9 C7 00 00 00 C7 41 2C 0D 00 00 00 E9 BB 00 00 00 C7 41 2C 08 00 00 00 E9 AF 00 00 00 8B 51 10 8A 02 3C 33 75 18 80 7A 01 32 75 12 8D 42 02 C7 41 2C 0A 00 00 00 89 41 10 E9 8E 00 00 00 3C 36 75 15 80 7A 01 34 75 0F 8D 42 02 C7 41 2C 0B 00 00 00 89 41 10 EB 75 3C 64 74 14 3C 69 74 10 3C 6F 74 0C 3C 75 74 08 3C 78 74 04 3C 58 75 5D C7 41 2C 09 00 00 00 EB 54 C7 41 2C 05 00 00 00 EB 4B 83 F8 6C 74 2A 83 F8 74 74 1C 83 F8 77 74 0E 83 F8 7A 75 37 C7 41 2C 06 00 00 00 EB 2E C7 41 2C 0C 00 00 00 EB 25 C7 41 2C 07 00 00 00 EB 1C 8B 41 10 80 38 6C 75 0D 40 C7 41 2C 04 00 00 00 89 41 10 EB 07 C7 41 2C 03 00 00 00 B0 01 5E 5F 5B C3 }
	condition:
		$1
}

rule file_175_311_0 {
	meta:
		name = "?state_case_size@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 511
		refs = "001f ?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0042 ??_C@_1FG@OBJBDPAC@?$AA?$CI?$AA?$CC?$AAN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe@ 004b ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0056 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 005e __CrtDbgReportW 006c __errno 0085 ??_C@_1EC@GJPNJDCN@?$AA_?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA_?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?3?$AA?3?$AAn?$AAo?$AAn?$AAe@ 00b8 ??_C@_1BNO@MMJDJILD@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00c4 __invalid_parameter"
	strings:
		$1 = { 0F B7 51 32 53 57 83 FA 46 75 1F 8B 01 83 E0 08 83 C8 00 75 0E 5F C7 41 1C 07 00 00 00 5B E9 ?? ?? ?? ?? B0 01 E9 D2 01 00 00 56 33 F6 83 FA 4E 75 46 8B 01 6A 08 5A 23 C2 0B C6 0F 85 B8 01 00 00 BB ?? ?? ?? ?? 89 51 1C 53 68 ?? ?? ?? ?? 56 68 56 07 00 00 BF ?? ?? ?? ?? 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 68 56 07 00 00 EB 3E 33 C0 39 71 2C 0F 94 C0 85 C0 75 4E BB ?? ?? ?? ?? BF ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 56 68 5D 07 00 00 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 68 5D 07 00 00 57 68 ?? ?? ?? ?? 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 E9 29 01 00 00 8B C2 83 F8 6A 0F 8F CD 00 00 00 0F 84 BE 00 00 00 83 F8 49 74 53 83 F8 4C 74 42 83 F8 54 74 31 6A 68 5A 3B C2 0F 85 FC 00 00 00 8B 41 10 66 39 10 75 12 83 C0 02 C7 41 2C 01 00 00 00 89 41 10 E9 E2 00 00 00 C7 41 2C 02 00 00 00 E9 D6 00 00 00 C7 41 2C 0D 00 00 00 E9 CA 00 00 00 C7 41 2C 08 00 00 00 E9 BE 00 00 00 8B 51 10 0F B7 02 83 F8 33 75 19 66 83 7A 02 32 75 12 8D 42 04 C7 41 2C 0A 00 00 00 89 41 10 E9 9A 00 00 00 83 F8 36 75 16 66 83 7A 02 34 75 0F 8D 42 04 C7 41 2C 0B 00 00 00 89 41 10 EB 7F 83 F8 64 74 19 83 F8 69 74 14 83 F8 6F 74 0F 83 F8 75 74 0A 83 F8 78 74 05 83 F8 58 75 61 C7 41 2C 09 00 00 00 EB 58 C7 41 2C 05 00 00 00 EB 4F 6A 6C 5A 3B C2 74 2A 83 F8 74 74 1C 83 F8 77 74 0E 83 F8 7A 75 39 C7 41 2C 06 00 00 00 EB 30 C7 41 2C 0C 00 00 00 EB 27 C7 41 2C 07 00 00 00 EB 1E 8B 41 10 66 39 10 75 0F 83 C0 02 C7 41 2C 04 00 00 00 89 41 10 EB 07 C7 41 2C 03 00 00 00 B0 01 5E 5F 5B C3 }
	condition:
		$1
}

rule file_175_312_0 {
	meta:
		name = "?state_case_size@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 511
		refs = "001f ?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$positional_parameter_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0042 ??_C@_1FG@OBJBDPAC@?$AA?$CI?$AA?$CC?$AAN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe@ 004b ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0056 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 005e __CrtDbgReportW 006c __errno 0085 ??_C@_1EC@GJPNJDCN@?$AA_?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA_?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?3?$AA?3?$AAn?$AAo?$AAn?$AAe@ 00b8 ??_C@_1BOE@BBNBBNLC@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00c4 __invalid_parameter"
	strings:
		$1 = { 0F B7 51 32 53 57 83 FA 46 75 1F 8B 01 83 E0 08 83 C8 00 75 0E 5F C7 41 1C 07 00 00 00 5B E9 ?? ?? ?? ?? B0 01 E9 D2 01 00 00 56 33 F6 83 FA 4E 75 46 8B 01 6A 08 5A 23 C2 0B C6 0F 85 B8 01 00 00 BB ?? ?? ?? ?? 89 51 1C 53 68 ?? ?? ?? ?? 56 68 56 07 00 00 BF ?? ?? ?? ?? 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 68 56 07 00 00 EB 3E 33 C0 39 71 2C 0F 94 C0 85 C0 75 4E BB ?? ?? ?? ?? BF ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 56 68 5D 07 00 00 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 68 5D 07 00 00 57 68 ?? ?? ?? ?? 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 E9 29 01 00 00 8B C2 83 F8 6A 0F 8F CD 00 00 00 0F 84 BE 00 00 00 83 F8 49 74 53 83 F8 4C 74 42 83 F8 54 74 31 6A 68 5A 3B C2 0F 85 FC 00 00 00 8B 41 10 66 39 10 75 12 83 C0 02 C7 41 2C 01 00 00 00 89 41 10 E9 E2 00 00 00 C7 41 2C 02 00 00 00 E9 D6 00 00 00 C7 41 2C 0D 00 00 00 E9 CA 00 00 00 C7 41 2C 08 00 00 00 E9 BE 00 00 00 8B 51 10 0F B7 02 83 F8 33 75 19 66 83 7A 02 32 75 12 8D 42 04 C7 41 2C 0A 00 00 00 89 41 10 E9 9A 00 00 00 83 F8 36 75 16 66 83 7A 02 34 75 0F 8D 42 04 C7 41 2C 0B 00 00 00 89 41 10 EB 7F 83 F8 64 74 19 83 F8 69 74 14 83 F8 6F 74 0F 83 F8 75 74 0A 83 F8 78 74 05 83 F8 58 75 61 C7 41 2C 09 00 00 00 EB 58 C7 41 2C 05 00 00 00 EB 4F 6A 6C 5A 3B C2 74 2A 83 F8 74 74 1C 83 F8 77 74 0E 83 F8 7A 75 39 C7 41 2C 06 00 00 00 EB 30 C7 41 2C 0C 00 00 00 EB 27 C7 41 2C 07 00 00 00 EB 1E 8B 41 10 66 39 10 75 0F 83 C0 02 C7 41 2C 04 00 00 00 89 41 10 EB 07 C7 41 2C 03 00 00 00 B0 01 5E 5F 5B C3 }
	condition:
		$1
}

rule file_175_313_0 {
	meta:
		name = "?state_case_size@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 511
		refs = "001f ?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0042 ??_C@_1FG@OBJBDPAC@?$AA?$CI?$AA?$CC?$AAN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?5?$AAn?$AAo?$AAt?$AA?5?$AAs?$AAp?$AAe?$AAc?$AAi?$AAf?$AAi?$AAe@ 004b ??_C@_17CNPHIMPH@?$AA?$CF?$AAl?$AAs?$AA?$AA@ 0056 ??_C@_1HA@DMAAKIJP@?$AAm?$AAi?$AAn?$AAk?$AAe?$AAr?$AAn?$AAe?$AAl?$AA?2?$AAc?$AAr?$AAt?$AAs?$AA?2?$AAu?$AAc?$AAr?$AAt?$AA?2?$AAi?$AAn?$AAc?$AA?2?$AAc?$AAo?$AAr?$AAe?$AAc?$AAr?$AAt?$AA_@ 005e __CrtDbgReportW 006c __errno 0085 ??_C@_1EC@GJPNJDCN@?$AA_?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AAl?$AAe?$AAn?$AAg?$AAt?$AAh?$AA_?$AAm?$AAo?$AAd?$AAi?$AAf?$AAi?$AAe?$AAr?$AA?3?$AA?3?$AAn?$AAo?$AAn?$AAe@ 00b8 ??_C@_1BMM@GFJMEAMM@?$AA_?$AA_?$AAc?$AAr?$AAt?$AA_?$AAs?$AAt?$AAd?$AAi?$AAo?$AA_?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA?3?$AA?3?$AAo?$AAu?$AAt?$AAp?$AAu?$AAt?$AA_?$AAp?$AAr?$AAo?$AAc?$AAe@ 00c4 __invalid_parameter"
	strings:
		$1 = { 0F B7 51 32 53 57 83 FA 46 75 1F 8B 01 83 E0 08 83 C8 00 75 0E 5F C7 41 1C 07 00 00 00 5B E9 ?? ?? ?? ?? B0 01 E9 D2 01 00 00 56 33 F6 83 FA 4E 75 46 8B 01 6A 08 5A 23 C2 0B C6 0F 85 B8 01 00 00 BB ?? ?? ?? ?? 89 51 1C 53 68 ?? ?? ?? ?? 56 68 56 07 00 00 BF ?? ?? ?? ?? 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 68 56 07 00 00 EB 3E 33 C0 39 71 2C 0F 94 C0 85 C0 75 4E BB ?? ?? ?? ?? BF ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 56 68 5D 07 00 00 57 6A 02 E8 ?? ?? ?? ?? 83 C4 18 83 F8 01 75 01 CC E8 ?? ?? ?? ?? 56 68 5D 07 00 00 57 68 ?? ?? ?? ?? 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 32 C0 E9 29 01 00 00 8B C2 83 F8 6A 0F 8F CD 00 00 00 0F 84 BE 00 00 00 83 F8 49 74 53 83 F8 4C 74 42 83 F8 54 74 31 6A 68 5A 3B C2 0F 85 FC 00 00 00 8B 41 10 66 39 10 75 12 83 C0 02 C7 41 2C 01 00 00 00 89 41 10 E9 E2 00 00 00 C7 41 2C 02 00 00 00 E9 D6 00 00 00 C7 41 2C 0D 00 00 00 E9 CA 00 00 00 C7 41 2C 08 00 00 00 E9 BE 00 00 00 8B 51 10 0F B7 02 83 F8 33 75 19 66 83 7A 02 32 75 12 8D 42 04 C7 41 2C 0A 00 00 00 89 41 10 E9 9A 00 00 00 83 F8 36 75 16 66 83 7A 02 34 75 0F 8D 42 04 C7 41 2C 0B 00 00 00 89 41 10 EB 7F 83 F8 64 74 19 83 F8 69 74 14 83 F8 6F 74 0F 83 F8 75 74 0A 83 F8 78 74 05 83 F8 58 75 61 C7 41 2C 09 00 00 00 EB 58 C7 41 2C 05 00 00 00 EB 4F 6A 6C 5A 3B C2 74 2A 83 F8 74 74 1C 83 F8 77 74 0E 83 F8 7A 75 39 C7 41 2C 06 00 00 00 EB 30 C7 41 2C 0C 00 00 00 EB 27 C7 41 2C 07 00 00 00 EB 1E 8B 41 10 66 39 10 75 0F 83 C0 02 C7 41 2C 04 00 00 00 89 41 10 EB 07 C7 41 2C 03 00 00 00 B0 01 5E 5F 5B C3 }
	condition:
		$1
}

rule file_175_314_0 {
	meta:
		name = "?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 560
		refs = "0049 ?type_case_s@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0075 ?type_case_c_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_ND@Z 007e ?type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00a2 ?type_case_o@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00ab ?type_case_n@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00bb ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NI_N@Z 00c4 ?type_case_a@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00cd ?type_case_p@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 01b3 ??$write_multiple_characters@V?$console_output_adapter@D@__crt_stdio_output@@D@__crt_stdio_output@@YAXABV?$console_output_adapter@D@0@DHQAH@Z 01ce ?write_string@?$console_output_adapter@D@__crt_stdio_output@@QBEXQBDHQAHAAV__crt_deferred_errno_cache@@@Z 0201 ?write_stored_string_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_ND@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B F1 33 DB 43 33 C9 0F BE 46 31 83 F8 64 7F 6C 0F 84 93 00 00 00 83 F8 58 7F 3E 74 37 83 F8 41 0F 84 93 00 00 00 83 F8 43 74 3E 83 F8 44 7E 1D 83 F8 47 0F 8E 80 00 00 00 83 F8 53 75 0F 8B CE E8 ?? ?? ?? ?? 84 C0 0F 85 9F 00 00 00 32 C0 E9 CE 01 00 00 53 6A 10 EB 57 83 E8 5A 74 15 83 E8 07 74 56 48 83 E8 01 75 E4 51 8B CE E8 ?? ?? ?? ?? EB D2 8B CE E8 ?? ?? ?? ?? EB C9 83 F8 70 7F 4D 74 3F 83 F8 67 7E 31 83 F8 69 74 1C 83 F8 6E 74 0E 83 F8 6F 75 B6 8B CE E8 ?? ?? ?? ?? EB A5 8B CE E8 ?? ?? ?? ?? EB 9C 83 4E 20 10 51 6A 0A 8B CE E8 ?? ?? ?? ?? EB 8C 8B CE E8 ?? ?? ?? ?? EB 83 8B CE E8 ?? ?? ?? ?? E9 77 FF FF FF 83 E8 73 0F 84 67 FF FF FF 48 83 E8 01 74 D0 83 E8 03 0F 85 67 FF FF FF 51 E9 69 FF FF FF 80 7E 30 00 74 07 8A C3 E9 29 01 00 00 8B 56 20 33 C0 57 66 89 45 FC 8B F8 88 45 FE 8B C2 C1 E8 04 84 C3 74 27 8B C2 C1 E8 06 84 C3 74 06 C6 45 FC 2D EB 16 84 D3 74 06 C6 45 FC 2B EB 0C 8B C2 D1 E8 84 C3 74 06 C6 45 FC 20 8B FB 8A 4E 31 80 F9 78 74 05 80 F9 58 75 09 8B C2 C1 E8 05 84 C3 75 02 32 DB 80 F9 61 74 09 80 F9 41 74 04 32 C0 EB 02 B0 01 84 DB 75 04 84 C0 74 27 C6 44 3D FC 30 80 F9 58 74 09 80 F9 41 74 04 32 C0 EB 02 B0 01 84 C0 0F 94 C0 FE C8 24 E0 04 78 88 44 3D FD 83 C7 02 8B 5E 24 2B 5E 38 2B DF F6 C2 0C 75 16 8D 46 18 50 53 8D 86 48 04 00 00 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 8D 46 0C 50 8D 4E 18 51 57 8D 45 FC 50 8D 8E 48 04 00 00 E8 ?? ?? ?? ?? 8B 4E 20 8D 7E 18 8B C1 C1 E8 03 A8 01 74 1B C1 E9 02 F6 C1 01 75 13 57 53 8D 86 48 04 00 00 6A 30 50 E8 ?? ?? ?? ?? 83 C4 10 6A 00 8B CE E8 ?? ?? ?? ?? 83 3F 00 7C 1D 8B 46 20 C1 E8 02 A8 01 74 13 57 53 8D 86 48 04 00 00 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 B0 01 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_316_0 {
	meta:
		name = "?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 560
		refs = "0049 ?type_case_s@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0075 ?type_case_c_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_ND@Z 007e ?type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00a2 ?type_case_o@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00ab ?type_case_n@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00bb ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NI_N@Z 00c4 ?type_case_a@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00cd ?type_case_p@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 01b3 ??$write_multiple_characters@V?$console_output_adapter@D@__crt_stdio_output@@D@__crt_stdio_output@@YAXABV?$console_output_adapter@D@0@DHQAH@Z 01ce ?write_string@?$console_output_adapter@D@__crt_stdio_output@@QBEXQBDHQAHAAV__crt_deferred_errno_cache@@@Z 0201 ?write_stored_string_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_ND@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B F1 33 DB 43 33 C9 0F BE 46 31 83 F8 64 7F 6C 0F 84 93 00 00 00 83 F8 58 7F 3E 74 37 83 F8 41 0F 84 93 00 00 00 83 F8 43 74 3E 83 F8 44 7E 1D 83 F8 47 0F 8E 80 00 00 00 83 F8 53 75 0F 8B CE E8 ?? ?? ?? ?? 84 C0 0F 85 9F 00 00 00 32 C0 E9 CE 01 00 00 53 6A 10 EB 57 83 E8 5A 74 15 83 E8 07 74 56 48 83 E8 01 75 E4 51 8B CE E8 ?? ?? ?? ?? EB D2 8B CE E8 ?? ?? ?? ?? EB C9 83 F8 70 7F 4D 74 3F 83 F8 67 7E 31 83 F8 69 74 1C 83 F8 6E 74 0E 83 F8 6F 75 B6 8B CE E8 ?? ?? ?? ?? EB A5 8B CE E8 ?? ?? ?? ?? EB 9C 83 4E 20 10 51 6A 0A 8B CE E8 ?? ?? ?? ?? EB 8C 8B CE E8 ?? ?? ?? ?? EB 83 8B CE E8 ?? ?? ?? ?? E9 77 FF FF FF 83 E8 73 0F 84 67 FF FF FF 48 83 E8 01 74 D0 83 E8 03 0F 85 67 FF FF FF 51 E9 69 FF FF FF 80 7E 30 00 74 07 8A C3 E9 29 01 00 00 8B 56 20 33 C0 57 66 89 45 FC 8B F8 88 45 FE 8B C2 C1 E8 04 84 C3 74 27 8B C2 C1 E8 06 84 C3 74 06 C6 45 FC 2D EB 16 84 D3 74 06 C6 45 FC 2B EB 0C 8B C2 D1 E8 84 C3 74 06 C6 45 FC 20 8B FB 8A 4E 31 80 F9 78 74 05 80 F9 58 75 09 8B C2 C1 E8 05 84 C3 75 02 32 DB 80 F9 61 74 09 80 F9 41 74 04 32 C0 EB 02 B0 01 84 DB 75 04 84 C0 74 27 C6 44 3D FC 30 80 F9 58 74 09 80 F9 41 74 04 32 C0 EB 02 B0 01 84 C0 0F 94 C0 FE C8 24 E0 04 78 88 44 3D FD 83 C7 02 8B 5E 24 2B 5E 38 2B DF F6 C2 0C 75 16 8D 46 18 50 53 8D 86 48 04 00 00 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 8D 46 0C 50 8D 4E 18 51 57 8D 45 FC 50 8D 8E 48 04 00 00 E8 ?? ?? ?? ?? 8B 4E 20 8D 7E 18 8B C1 C1 E8 03 A8 01 74 1B C1 E9 02 F6 C1 01 75 13 57 53 8D 86 48 04 00 00 6A 30 50 E8 ?? ?? ?? ?? 83 C4 10 6A 00 8B CE E8 ?? ?? ?? ?? 83 3F 00 7C 1D 8B 46 20 C1 E8 02 A8 01 74 13 57 53 8D 86 48 04 00 00 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 B0 01 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_315_0 {
	meta:
		name = "?state_case_type@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 571
		refs = "0049 ?type_case_s@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0075 ?type_case_c_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_ND@Z 007e ?type_case_Z@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00a2 ?type_case_o@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00ab ?type_case_n@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00bb ?type_case_integer@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NI_N@Z 00c4 ?type_case_a@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00cd ?type_case_p@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00f7 ?should_skip_type_state_output@?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@__crt_stdio_output@@IBE_NXZ 01be ??$write_multiple_characters@V?$console_output_adapter@D@__crt_stdio_output@@D@__crt_stdio_output@@YAXABV?$console_output_adapter@D@0@DHQAH@Z 01d9 ?write_string@?$console_output_adapter@D@__crt_stdio_output@@QBEXQBDHQAHAAV__crt_deferred_errno_cache@@@Z 020c ?write_stored_string_tchar@?$output_processor@DV?$console_output_adapter@D@__crt_stdio_output@@V?$positional_parameter_base@DV?$console_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_ND@Z"
	strings:
		$1 = { 8B FF 55 8B EC 51 53 56 8B F1 33 DB 43 33 C9 0F BE 46 31 83 F8 64 7F 6C 0F 84 93 00 00 00 83 F8 58 7F 3E 74 37 83 F8 41 0F 84 93 00 00 00 83 F8 43 74 3E 83 F8 44 7E 1D 83 F8 47 0F 8E 80 00 00 00 83 F8 53 75 0F 8B CE E8 ?? ?? ?? ?? 84 C0 0F 85 9F 00 00 00 32 C0 E9 D9 01 00 00 53 6A 10 EB 57 83 E8 5A 74 15 83 E8 07 74 56 48 83 E8 01 75 E4 51 8B CE E8 ?? ?? ?? ?? EB D2 8B CE E8 ?? ?? ?? ?? EB C9 83 F8 70 7F 4D 74 3F 83 F8 67 7E 31 83 F8 69 74 1C 83 F8 6E 74 0E 83 F8 6F 75 B6 8B CE E8 ?? ?? ?? ?? EB A5 8B CE E8 ?? ?? ?? ?? EB 9C 83 4E 20 10 51 6A 0A 8B CE E8 ?? ?? ?? ?? EB 8C 8B CE E8 ?? ?? ?? ?? EB 83 8B CE E8 ?? ?? ?? ?? E9 77 FF FF FF 83 E8 73 0F 84 67 FF FF FF 48 83 E8 01 74 D0 83 E8 03 0F 85 67 FF FF FF 51 E9 69 FF FF FF 8B CE E8 ?? ?? ?? ?? 84 C0 74 07 8A C3 E9 2F 01 00 00 80 7E 30 00 75 F3 8B 56 20 33 C0 57 66 89 45 FC 8B F8 88 45 FE 8B C2 C1 E8 04 84 C3 74 27 8B C2 C1 E8 06 84 C3 74 06 C6 45 FC 2D EB 16 84 D3 74 06 C6 45 FC 2B EB 0C 8B C2 D1 E8 84 C3 74 06 C6 45 FC 20 8B FB 8A 4E 31 80 F9 78 74 05 80 F9 58 75 09 8B C2 C1 E8 05 84 C3 75 02 32 DB 80 F9 61 74 09 80 F9 41 74 04 32 C0 EB 02 B0 01 84 DB 75 04 84 C0 74 27 C6 44 3D FC 30 80 F9 58 74 09 80 F9 41 74 04 32 C0 EB 02 B0 01 84 C0 0F 94 C0 FE C8 24 E0 04 78 88 44 3D FD 83 C7 02 8B 5E 24 2B 5E 38 2B DF F6 C2 0C 75 16 8D 46 18 50 53 8D 86 48 04 00 00 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 8D 46 0C 50 8D 4E 18 51 57 8D 45 FC 50 8D 8E 48 04 00 00 E8 ?? ?? ?? ?? 8B 4E 20 8D 7E 18 8B C1 C1 E8 03 A8 01 74 1B C1 E9 02 F6 C1 01 75 13 57 53 8D 86 48 04 00 00 6A 30 50 E8 ?? ?? ?? ?? 83 C4 10 6A 00 8B CE E8 ?? ?? ?? ?? 83 3F 00 7C 1D 8B 46 20 C1 E8 02 A8 01 74 13 57 53 8D 86 48 04 00 00 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 B0 01 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_317_0 {
	meta:
		name = "?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 606
		refs = "0009 ___security_cookie 0056 ?type_case_s@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0083 ?type_case_c_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_N_W@Z 008c ?type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00b0 ?type_case_o@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00b9 ?type_case_n@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00c9 ?type_case_integer@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NI_N@Z 00d2 ?type_case_a@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 00db ?type_case_p@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 01d7 ??$write_multiple_characters@V?$console_output_adapter@_W@__crt_stdio_output@@D@__crt_stdio_output@@YAXABV?$console_output_adapter@_W@0@DHQAH@Z 01f2 ?write_string@?$console_output_adapter@_W@__crt_stdio_output@@QBEXQB_WHQAHAAV__crt_deferred_errno_cache@@@Z 0225 ?write_stored_string_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$format_validation_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_N_W@Z 0256 @__security_check_cookie@4"
	strings:
		$1 = { 8B FF 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B F1 33 DB 6A 41 5A 6A 58 0F B7 46 32 59 83 F8 64 7F 6B 0F 84 92 00 00 00 3B C1 7F 3E 74 36 3B C2 0F 84 94 00 00 00 83 F8 43 74 3F 83 F8 44 7E 1D 83 F8 47 0F 8E 81 00 00 00 83 F8 53 75 0F 8B CE E8 ?? ?? ?? ?? 84 C0 0F 85 A0 00 00 00 32 C0 E9 E5 01 00 00 6A 01 6A 10 EB 57 83 E8 5A 74 15 83 E8 07 74 56 48 83 E8 01 75 E3 53 8B CE E8 ?? ?? ?? ?? EB D1 8B CE E8 ?? ?? ?? ?? EB C8 83 F8 70 7F 4D 74 3F 83 F8 67 7E 31 83 F8 69 74 1C 83 F8 6E 74 0E 83 F8 6F 75 B5 8B CE E8 ?? ?? ?? ?? EB A4 8B CE E8 ?? ?? ?? ?? EB 9B 83 4E 20 10 53 6A 0A 8B CE E8 ?? ?? ?? ?? EB 8B 8B CE E8 ?? ?? ?? ?? EB 82 8B CE E8 ?? ?? ?? ?? E9 76 FF FF FF 83 E8 73 0F 84 66 FF FF FF 48 83 E8 01 74 D0 83 E8 03 0F 85 66 FF FF FF 53 E9 69 FF FF FF 38 5E 30 0F 85 41 01 00 00 8B 56 20 33 C9 57 8B C2 89 5D F4 C1 E8 04 41 66 89 5D F8 6A 20 5F 84 C1 74 28 8B C2 C1 E8 06 84 C1 74 09 6A 2D 58 66 89 45 F4 EB 14 84 D1 74 04 6A 2B EB F1 8B C2 D1 E8 84 C1 74 06 66 89 7D F4 8B D9 0F B7 4E 32 83 F9 78 74 08 6A 58 58 66 3B C8 75 0D 8B C2 C1 E8 05 A8 01 74 04 B4 01 EB 02 32 E4 83 F9 61 74 0C 6A 41 5F 66 3B CF 74 04 32 C0 EB 02 B0 01 6A 30 5F 84 E4 75 04 84 C0 74 30 6A 58 58 66 89 7C 5D F4 66 3B C8 74 0C 6A 41 58 66 3B C8 74 04 32 C0 EB 02 B0 01 84 C0 0F 94 C0 FE C8 24 E0 04 78 66 98 66 89 44 5D F6 83 C3 02 8B 7E 24 2B 7E 38 2B FB F6 C2 0C 75 16 8D 46 18 50 57 8D 86 48 04 00 00 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 8D 46 0C 50 8D 4E 18 51 53 8D 45 F4 50 8D 8E 48 04 00 00 E8 ?? ?? ?? ?? 8B 4E 20 8D 5E 18 8B C1 C1 E8 03 A8 01 74 1B C1 E9 02 F6 C1 01 75 13 53 57 8D 86 48 04 00 00 6A 30 50 E8 ?? ?? ?? ?? 83 C4 10 6A 00 8B CE E8 ?? ?? ?? ?? 83 3B 00 7C 1D 8B 46 20 C1 E8 02 A8 01 74 13 53 57 8D 86 48 04 00 00 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 5F B0 01 8B 4D FC 5E 33 CD 5B E8 ?? ?? ?? ?? 8B E5 5D C3 }
	condition:
		$1
}

rule file_175_319_0 {
	meta:
		name = "?state_case_type@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ"
		size = 606
		refs = "0009 ___security_cookie 0056 ?type_case_s@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_NXZ 0083 ?type_case_c_tchar@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_W@__crt_stdio_output@@@2@@__crt_stdio_output@@AAE_N_W@Z 008c ?type_case_Z@?$output_processor@_WV?$console_output_adapter@_W@__crt_stdio_output@@V?$standard_base@_WV?$console_output_adapter@_