import re
from _typeshed import Incomplete, StrPath, Unused
from collections.abc import Callable, Iterable
from io import TextIOWrapper
from pathlib import Path
from typing import ClassVar, Final, Literal, NoReturn, TypeVar
from typing_extensions import deprecated

from docutils import nodes
from docutils.frontend import Values
from docutils.languages import _LanguageModule
from docutils.utils import Reporter
from docutils.writers import Writer as _Writer

_K = TypeVar("_K")
_V = TypeVar("_V")

__docformat__: Final = "reStructuredText"

LATEX_WRITER_DIR: Final[Path]

class Writer(_Writer[str]):
    default_template: ClassVar[str]
    default_template_path: ClassVar[Path]
    default_preamble: ClassVar[str]
    table_style_values: ClassVar[list[str]]
    relative_path_settings: ClassVar[tuple[str, ...]]
    settings_defaults: ClassVar[dict[str, int]]
    config_section: ClassVar[str]
    config_section_dependencies: ClassVar[tuple[str, ...]]
    head_parts: ClassVar[tuple[str, ...]]
    visitor_attributes: ClassVar[tuple[str, ...]]
    translator_class: type[LaTeXTranslator]

class Babel:
    language_codes: ClassVar[dict[str, str]]
    warn_msg: ClassVar[str]
    active_chars: ClassVar[dict[str, str]]

    reporter: Reporter | None
    language: str
    otherlanguages: dict[str, str | bool]
    setup: list[str]

    def __init__(self, language_code: str, reporter: Reporter | None = None) -> None: ...
    def __call__(self) -> str: ...
    def language_name(self, language_code: str) -> str: ...
    def get_language(self) -> str: ...

class SortableDict(dict[_K, _V]):
    def sortedkeys(self) -> list[_K]: ...
    def sortedvalues(self) -> list[_V]: ...

class PreambleCmds:
    color: ClassVar[str]
    float: ClassVar[str]
    linking: ClassVar[str]
    minitoc: ClassVar[str]
    table: ClassVar[str]
    table_columnwidth: ClassVar[str]
    textcomp: ClassVar[str]
    abstract_legacy: ClassVar[str]
    admonition_legacy: ClassVar[str]
    error_legacy: ClassVar[str]
    title_legacy: ClassVar[str]
    toc_list: ClassVar[str]
    ttem: ClassVar[str]
    duclass: ClassVar[str]
    providelength: ClassVar[str]
    abstract: ClassVar[str]
    dedication: ClassVar[str]
    docinfo: ClassVar[str]
    error: ClassVar[str]
    highlight_rules: ClassVar[str]
    admonition: ClassVar[str]
    fieldlist: ClassVar[str]
    footnotes: ClassVar[str]
    inline: ClassVar[str]
    legend: ClassVar[str]
    lineblock: ClassVar[str]
    optionlist: ClassVar[str]
    rubric: ClassVar[str]
    sidebar: ClassVar[str]
    title: ClassVar[str]
    subtitle: ClassVar[str]
    documentsubtitle: ClassVar[str]
    titlereference: ClassVar[str]
    transition: ClassVar[str]
    secnumdepth: ClassVar[str]

fp: TextIOWrapper
line: str
block_name: str
definitions: str

class CharMaps:
    alltt: ClassVar[dict[int, str]]
    special: ClassVar[dict[int, str]]
    unsupported_unicode: ClassVar[dict[int, str]]
    utf8_supported_unicode: ClassVar[dict[int, str]]
    textcomp: ClassVar[dict[int, str]]
    pifont: ClassVar[dict[int, str]]

class DocumentClass:
    document_class: str
    sections: list[str]
    def __init__(self, document_class: str, with_part: bool = False) -> None: ...
    def section(self, level: int) -> str: ...
    def latex_section_depth(self, depth: int) -> int: ...

class Table:
    legacy_column_widths: bool
    caption: list[str]
    stubs: list[Incomplete]
    colwidths_auto: bool
    borders: str
    def __init__(self, translator: LaTeXTranslator, latex_type: str) -> None: ...
    def open(self) -> None: ...
    def close(self) -> None: ...
    def is_open(self) -> bool: ...
    def set_table_style(self, node, settings) -> None: ...
    def get_latex_type(self) -> str: ...
    def set(self, attr, value) -> None: ...
    def get(self, attr): ...
    def get_vertical_bar(self) -> Literal["|", ""]: ...
    def get_opening(self, width: str = r"\linewidth") -> str: ...
    def get_closing(self) -> str: ...
    def visit_colspec(self, node: nodes.colspec) -> None: ...
    def get_colspecs(self, node: nodes.Element) -> str: ...
    def get_column_width(self) -> str: ...
    def get_multicolumn_width(self, start: int, len_: int) -> str: ...
    @deprecated("`writers.latex2e.Table.get_caption()` is obsolete and will be removed in Docutils 0.22.")
    def get_caption(self) -> str: ...
    def need_recurse(self) -> bool | Literal[0]: ...
    def visit_thead(self) -> list[str]: ...
    def depart_thead(self) -> list[str]: ...
    def visit_row(self) -> None: ...
    def depart_row(self) -> list[str]: ...
    def set_rowspan(self, cell, value) -> None: ...
    def get_rowspan(self, cell): ...
    def get_entry_number(self) -> int: ...
    def visit_entry(self) -> None: ...
    def is_stub_column(self): ...

class LaTeXTranslator(nodes.NodeVisitor):
    is_xetex: ClassVar[bool]
    compound_enumerators: ClassVar[bool]
    section_prefix_for_enumerators: ClassVar[bool]
    section_enumerator_separator: ClassVar[str]
    has_latex_toc: ClassVar[bool]
    section_level: ClassVar[int]
    inside_citation_reference_label: ClassVar[bool]
    verbatim: ClassVar[bool]
    insert_non_breaking_blanks: ClassVar[bool]
    insert_newline: ClassVar[bool]
    literal: ClassVar[bool]
    alltt: ClassVar[bool]

    warn: Callable[..., nodes.system_message]
    error: Callable[..., nodes.system_message]
    settings: Values
    latex_encoding: str
    use_latex_toc: Incomplete
    use_latex_docinfo: Incomplete
    use_latex_citations: Incomplete
    reference_label: Incomplete
    hyperlink_color: Incomplete
    font_encoding: str
    literal_block_env: str
    literal_block_options: str
    bibtex: Incomplete
    language_module: _LanguageModule
    babel: Babel
    author_separator: str
    documentoptions: str
    d_class: DocumentClass
    graphicx_package: str
    docutils_footnotes: Incomplete
    head_prefix: list[str]
    requirements: SortableDict[str, str] | list[str]
    latex_preamble: list[Incomplete]
    fallbacks: SortableDict[str, str] | list[str]
    pdfsetup: list[str]
    title: list[Incomplete]
    subtitle: list[Incomplete]
    titledata: list[Incomplete]
    body_pre_docinfo: list[Incomplete]
    docinfo: list[Incomplete]
    dedication: list[Incomplete]
    abstract: list[Incomplete]
    body: list[Incomplete]
    context: list[Incomplete]
    title_labels: list[Incomplete]
    subtitle_labels: list[Incomplete]
    author_stack: list[Incomplete]
    date: list[Incomplete]
    pdfauthor: list[Incomplete]
    pdfinfo: list[Incomplete]
    table_stack: list[Incomplete]
    active_table: Table
    out: list[Incomplete]
    out_stack: list[Incomplete]
    fallback_stylesheet: bool
    stylesheet: list[str]
    hyperref_options: str

    def __init__(self, document: nodes.document, babel_class: type = ...) -> None: ...
    def stylesheet_call(self, path: StrPath) -> str: ...
    def to_latex_encoding(self, docutils_encoding: str) -> str: ...
    def language_label(self, docutil_label: str) -> str: ...
    def encode(self, text: str) -> str: ...
    def attval(self, text: str, whitespace: re.Pattern[str] = ...) -> str: ...
    def is_inline(self, node: nodes.Node) -> bool: ...
    def ids_to_labels(
        self, node: nodes.Element, set_anchor: bool = True, protect: bool = False, newline: bool = False
    ) -> list[Incomplete]: ...
    def append_hypertargets(self, node: nodes.Element) -> None: ...
    def set_align_from_classes(self, node) -> None: ...
    def insert_align_declaration(self, node: nodes.Element, default: str | None = None) -> None: ...
    def duclass_open(self, node) -> None: ...
    def duclass_close(self, node) -> None: ...
    def push_output_collector(self, new_out) -> None: ...
    def pop_output_collector(self) -> None: ...
    def term_postfix(self, node: nodes.Element) -> str: ...
    def visit_Text(self, node: nodes.Text) -> None: ...
    def depart_Text(self, node: nodes.Text) -> None: ...
    def visit_abbreviation(self, node: nodes.abbreviation) -> None: ...
    def depart_abbreviation(self, node: nodes.abbreviation) -> None: ...
    def visit_acronym(self, node: nodes.acronym) -> None: ...
    def depart_acronym(self, node: nodes.acronym) -> None: ...
    def visit_address(self, node: nodes.address) -> None: ...
    def depart_address(self, node: nodes.address) -> None: ...
    def visit_admonition(self, node: nodes.admonition) -> None: ...
    def depart_admonition(self, node: nodes.admonition) -> None: ...
    def visit_author(self, node: nodes.author) -> None: ...
    def depart_author(self, node: nodes.author) -> None: ...
    def visit_authors(self, node: nodes.authors) -> None: ...
    def depart_authors(self, node: nodes.authors) -> None: ...
    def visit_block_quote(self, node: nodes.block_quote) -> None: ...
    def depart_block_quote(self, node: nodes.block_quote) -> None: ...
    def visit_bullet_list(self, node: nodes.bullet_list) -> None: ...
    def depart_bullet_list(self, node: nodes.bullet_list) -> None: ...
    def visit_superscript(self, node: nodes.superscript) -> None: ...
    def depart_superscript(self, node: nodes.superscript) -> None: ...
    def visit_subscript(self, node: nodes.subscript) -> None: ...
    def depart_subscript(self, node: nodes.subscript) -> None: ...
    def visit_caption(self, node: nodes.caption) -> None: ...
    def depart_caption(self, node: nodes.caption) -> None: ...
    def visit_title_reference(self, node: nodes.title_reference) -> None: ...
    def depart_title_reference(self, node: nodes.title_reference) -> None: ...
    def visit_citation(self, node: nodes.citation) -> None: ...
    def depart_citation(self, node: nodes.citation) -> None: ...
    def visit_citation_reference(self, node: nodes.citation_reference) -> None: ...
    def depart_citation_reference(self, node: nodes.citation_reference) -> None: ...
    def visit_classifier(self, node: nodes.classifier) -> None: ...
    def depart_classifier(self, node: nodes.classifier) -> None: ...
    def visit_colspec(self, node: nodes.colspec) -> None: ...
    def depart_colspec(self, node: nodes.colspec) -> None: ...
    def visit_comment(self, node: nodes.comment) -> None: ...
    def depart_comment(self, node: nodes.comment) -> None: ...
    def visit_compound(self, node: nodes.compound) -> None: ...
    def depart_compound(self, node: nodes.compound) -> None: ...
    def visit_contact(self, node: nodes.contact) -> None: ...
    def depart_contact(self, node: nodes.contact) -> None: ...
    def visit_container(self, node: nodes.container) -> None: ...
    def depart_container(self, node: nodes.container) -> None: ...
    def visit_copyright(self, node: nodes.copyright) -> None: ...
    def depart_copyright(self, node: nodes.copyright) -> None: ...
    def visit_date(self, node: nodes.date) -> None: ...
    def depart_date(self, node: nodes.date) -> None: ...
    def visit_decoration(self, node: nodes.decoration) -> None: ...
    def depart_decoration(self, node: nodes.decoration) -> None: ...
    def visit_definition(self, node: nodes.definition) -> None: ...
    def depart_definition(self, node: nodes.definition) -> None: ...
    def visit_definition_list(self, node: nodes.definition_list) -> None: ...
    def depart_definition_list(self, node: nodes.definition_list) -> None: ...
    def visit_definition_list_item(self, node: nodes.definition_list_item) -> None: ...
    def depart_definition_list_item(self, node: nodes.definition_list_item) -> None: ...
    def visit_description(self, node: nodes.description) -> None: ...
    def depart_description(self, node: nodes.description) -> None: ...
    def visit_docinfo(self, node: nodes.docinfo) -> None: ...
    def depart_docinfo(self, node: nodes.docinfo) -> None: ...
    def visit_docinfo_item(self, node, name: str) -> None: ...
    def depart_docinfo_item(self, node) -> None: ...
    def visit_doctest_block(self, node: nodes.doctest_block) -> None: ...
    def depart_doctest_block(self, node: nodes.doctest_block) -> None: ...
    def visit_document(self, node: nodes.document) -> None: ...
    def depart_document(self, node: nodes.document) -> None: ...
    def make_title(self) -> None: ...
    def append_bibliogaphy(self) -> None: ...
    def visit_emphasis(self, node: nodes.emphasis) -> None: ...
    def depart_emphasis(self, node: nodes.emphasis) -> None: ...
    def insert_additional_table_colum_delimiters(self) -> None: ...
    def visit_entry(self, node: nodes.entry) -> None: ...
    def depart_entry(self, node: nodes.entry) -> None: ...
    def visit_row(self, node: nodes.row) -> None: ...
    def depart_row(self, node: nodes.row) -> None: ...
    def visit_enumerated_list(self, node: nodes.enumerated_list) -> None: ...
    def depart_enumerated_list(self, node: nodes.enumerated_list) -> None: ...
    def visit_field(self, node: nodes.field) -> None: ...
    def depart_field(self, node: nodes.field) -> None: ...
    def visit_field_body(self, node: nodes.field_body) -> None: ...
    def depart_field_body(self, node: nodes.field_body) -> None: ...
    def visit_field_list(self, node: nodes.field_list) -> None: ...
    def depart_field_list(self, node: nodes.field_list) -> None: ...
    def visit_field_name(self, node: nodes.field_name) -> None: ...
    def depart_field_name(self, node: nodes.field_name) -> None: ...
    def visit_figure(self, node: nodes.figure) -> None: ...
    def depart_figure(self, node: nodes.figure) -> None: ...
    def visit_footer(self, node: nodes.footer) -> None: ...
    def depart_footer(self, node: nodes.footer) -> None: ...
    def visit_footnote(self, node: nodes.footnote) -> None: ...
    def depart_footnote(self, node: nodes.footnote) -> None: ...
    def visit_footnote_reference(self, node: nodes.footnote_reference) -> None: ...
    def depart_footnote_reference(self, node: nodes.footnote_reference) -> None: ...
    def label_delim(self, node, bracket, superscript) -> None: ...
    def visit_label(self, node: nodes.label) -> None: ...
    def depart_label(self, node: nodes.label) -> None: ...
    def visit_generated(self, node: nodes.generated) -> None: ...
    def depart_generated(self, node: nodes.generated) -> None: ...
    def visit_header(self, node: nodes.header) -> None: ...
    def depart_header(self, node: nodes.header) -> None: ...
    def to_latex_length(self, length_str: str, pxunit: Unused = None) -> str: ...
    def visit_image(self, node: nodes.image) -> None: ...
    def depart_image(self, node: nodes.image) -> None: ...
    def visit_inline(self, node: nodes.inline) -> None: ...
    def depart_inline(self, node: nodes.inline) -> None: ...
    def visit_legend(self, node: nodes.legend) -> None: ...
    def depart_legend(self, node: nodes.legend) -> None: ...
    def visit_line(self, node: nodes.line) -> None: ...
    def depart_line(self, node: nodes.line) -> None: ...
    def visit_line_block(self, node: nodes.line_block) -> None: ...
    def depart_line_block(self, node: nodes.line_block) -> None: ...
    def visit_list_item(self, node: nodes.list_item) -> None: ...
    def depart_list_item(self, node: nodes.list_item) -> None: ...
    def visit_literal(self, node: nodes.literal) -> None: ...
    def depart_literal(self, node: nodes.literal) -> None: ...
    def is_plaintext(self, node) -> bool: ...
    def visit_literal_block(self, node: nodes.literal_block) -> None: ...
    def depart_literal_block(self, node: nodes.literal_block) -> None: ...
    def visit_meta(self, node: nodes.meta) -> None: ...
    def depart_meta(self, node: nodes.meta) -> None: ...
    def visit_math(self, node: nodes.math, math_env: str = "$") -> None: ...
    def depart_math(self, node: nodes.math) -> None: ...
    def visit_math_block(self, node: nodes.math_block) -> None: ...
    def depart_math_block(self, node: nodes.math_block) -> None: ...
    def visit_option(self, node: nodes.option) -> None: ...
    def depart_option(self, node: nodes.option) -> None: ...
    def visit_option_argument(self, node: nodes.option_argument) -> None: ...
    def depart_option_argument(self, node: nodes.option_argument) -> None: ...
    def visit_option_group(self, node: nodes.option_group) -> None: ...
    def depart_option_group(self, node: nodes.option_group) -> None: ...
    def visit_option_list(self, node: nodes.option_list) -> None: ...
    def depart_option_list(self, node: nodes.option_list) -> None: ...
    def visit_option_list_item(self, node: nodes.option_list_item) -> None: ...
    def depart_option_list_item(self, node: nodes.option_list_item) -> None: ...
    def visit_option_string(self, node: nodes.option_string) -> None: ...
    def depart_option_string(self, node: nodes.option_string) -> None: ...
    def visit_organization(self, node: nodes.organization) -> None: ...
    def depart_organization(self, node: nodes.organization) -> None: ...
    def visit_paragraph(self, node: nodes.paragraph) -> None: ...
    def depart_paragraph(self, node: nodes.paragraph) -> None: ...
    def visit_problematic(self, node: nodes.problematic) -> None: ...
    def depart_problematic(self, node: nodes.problematic) -> None: ...
    def visit_raw(self, node: nodes.raw) -> None: ...
    def depart_raw(self, node: nodes.raw) -> None: ...
    def has_unbalanced_braces(self, string: Iterable[str]) -> bool: ...
    def visit_reference(self, node: nodes.reference) -> None: ...
    def depart_reference(self, node: nodes.reference) -> None: ...
    def visit_revision(self, node: nodes.revision) -> None: ...
    def depart_revision(self, node: nodes.revision) -> None: ...
    def visit_rubric(self, node: nodes.rubric) -> None: ...
    def depart_rubric(self, node: nodes.rubric) -> None: ...
    def visit_section(self, node: nodes.section) -> None: ...
    def depart_section(self, node: nodes.section) -> None: ...
    def visit_sidebar(self, node: nodes.sidebar) -> None: ...
    def depart_sidebar(self, node: nodes.sidebar) -> None: ...
    attribution_formats: dict[str, tuple[str, str]]
    def visit_attribution(self, node: nodes.attribution) -> None: ...
    def depart_attribution(self, node: nodes.attribution) -> None: ...
    def visit_status(self, node: nodes.status) -> None: ...
    def depart_status(self, node: nodes.status) -> None: ...
    def visit_strong(self, node: nodes.strong) -> None: ...
    def depart_strong(self, node: nodes.strong) -> None: ...
    def visit_substitution_definition(self, node: nodes.substitution_definition) -> None: ...
    def visit_substitution_reference(self, node: nodes.substitution_reference) -> None: ...
    def visit_subtitle(self, node: nodes.subtitle) -> None: ...
    def depart_subtitle(self, node: nodes.subtitle) -> None: ...
    def visit_system_message(self, node: nodes.system_message) -> None: ...
    def depart_system_message(self, node: nodes.system_message) -> None: ...
    def visit_table(self, node: nodes.table) -> None: ...
    def depart_table(self, node: nodes.table) -> None: ...
    def visit_target(self, node: nodes.target) -> None: ...
    def depart_target(self, node: nodes.target) -> None: ...
    def visit_tbody(self, node: nodes.tbody) -> None: ...
    def depart_tbody(self, node: nodes.tbody) -> None: ...
    def visit_term(self, node: nodes.term) -> None: ...
    def depart_term(self, node: nodes.term) -> None: ...
    def visit_tgroup(self, node: nodes.tgroup) -> None: ...
    def depart_tgroup(self, node: nodes.tgroup) -> None: ...
    def thead_depth(self) -> int: ...
    def visit_thead(self, node: nodes.thead) -> None: ...
    def visit_title(self, node: nodes.title) -> None: ...
    def depart_title(self, node: nodes.title) -> None: ...
    def visit_contents(self, node) -> None: ...
    def visit_topic(self, node: nodes.topic) -> None: ...
    def depart_topic(self, node: nodes.topic) -> None: ...
    def visit_transition(self, node: nodes.transition) -> None: ...
    def depart_transition(self, node: nodes.transition) -> None: ...
    def visit_version(self, node: nodes.version) -> None: ...
    def depart_version(self, node: nodes.version) -> None: ...
    def unimplemented_visit(self, node: nodes.Node) -> NoReturn: ...
