
"""
this file contains data from running various examples that the tests compare the current package with
"""
import numpy
# define data generated by having the examples from the BVP_SOLVER website output various things to files

# for test_example 5
# this is the solution of the swave example taken at 100 equaly spaced points

xEval =numpy.array([    0.00000000000000      ,
  2.141383922461308E-002 ,
  4.282767844922615E-002 ,
  6.424151767383922E-002 ,
  8.565535689845230E-002 ,
  0.107069196123065      ,
  0.128483035347678      ,
  0.149896874572292      ,
  0.171310713796905      ,
  0.192724553021518      ,
  0.214138392246131      ,
  0.235552231470744      ,
  0.256966070695357      ,
  0.278379909919970      ,
  0.299793749144583      ,
  0.321207588369196      ,
  0.342621427593809      ,
  0.364035266818422      ,
  0.385449106043035      ,
  0.406862945267648      ,
  0.428276784492261      ,
  0.449690623716875      ,
  0.471104462941488      ,
  0.492518302166101      ,
  0.513932141390714      ,
  0.535345980615327      ,
  0.556759819839940      ,
  0.578173659064553      ,
  0.599587498289166      ,
  0.621001337513779      ,
  0.642415176738392      ,
  0.663829015963005      ,
  0.685242855187618      ,
  0.706656694412231      ,
  0.728070533636844      ,
  0.749484372861458      ,
  0.770898212086071      ,
  0.792312051310684      ,
  0.813725890535297      ,
  0.835139729759910      ,
  0.856553568984523      ,
  0.877967408209136      ,
  0.899381247433749      ,
  0.920795086658362      ,
  0.942208925882975      ,
  0.963622765107588      ,
  0.985036604332201      ,
   1.00645044355681      ,
   1.02786428278143      ,
   1.04927812200604      ,
   1.07069196123065      ,
   1.09210580045527      ,
   1.11351963967988      ,
   1.13493347890449      ,
   1.15634731812911      ,
   1.17776115735372      ,
   1.19917499657833      ,
   1.22058883580295      ,
   1.24200267502756      ,
   1.26341651425217      ,
   1.28483035347678      ,
   1.30624419270140      ,
   1.32765803192601      ,
   1.34907187115062      ,
   1.37048571037524      ,
   1.39189954959985      ,
   1.41331338882446      ,
   1.43472722804908      ,
   1.45614106727369      ,
   1.47755490649830      ,
   1.49896874572292      ,
   1.52038258494753      ,
   1.54179642417214      ,
   1.56321026339675      ,
   1.58462410262137      ,
   1.60603794184598      ,
   1.62745178107059      ,
   1.64886562029521      ,
   1.67027945951982      ,
   1.69169329874443      ,
   1.71310713796905      ,
   1.73452097719366      ,
   1.75593481641827      ,
   1.77734865564289      ,
   1.79876249486750      ,
   1.82017633409211      ,
   1.84159017331672      ,
   1.86300401254134      ,
   1.88441785176595      ,
   1.90583169099056      ,
   1.92724553021518      ,
   1.94865936943979      ,
   1.97007320866440      ,
   1.99148704788902      ,
   2.01290088711363      ,
   2.03431472633824      ,
   2.05572856556285      ,
   2.07714240478747      ,
   2.09855624401208      ,
   2.11997008323669      ])

yEval = numpy.transpose(numpy.array([ [   2.11997032923574      ,   0.00000000000000      ],
 [   2.12006509075594      ,  8.736130730393863E-003 ],
 [   2.12033958403440      ,  1.678668567126194E-002 ],
 [   2.12077913768731      ,  2.415244227987208E-002 ],
 [   2.12136909050888      ,  3.083357797676201E-002 ],
 [   2.12209477923872      ,  3.682973916753012E-002 ],
 [   2.12294152779642      ,  4.214009933501029E-002 ],
 [   2.12389463812603      ,  4.676341719614460E-002 ],
 [   2.12493938141547      ,  5.069811613671773E-002 ],
 [   2.12606099244181      ,  5.394232195865238E-002 ],
 [   2.12724466291442      ,  5.649395453074673E-002 ],
 [   2.12847553817143      ,  5.835077627979148E-002 ],
 [   2.12973871495453      ,  5.951044762365600E-002 ],
 [   2.13101923940175      ,  5.997061212641221E-002 ],
 [   2.13230210727462      ,  5.972894979892567E-002 ],
 [   2.13357226589477      ,  5.878324847503705E-002 ],
 [   2.13481461700258      ,  5.713146481840536E-002 ],
 [   2.13601402063052      ,  5.477180074182671E-002 ],
 [   2.13715530207951      ,  5.170275797280842E-002 ],
 [   2.13822325768108      ,  4.792321967162801E-002 ],
 [   2.13920266535984      ,  4.343250329836607E-002 ],
 [   2.14007829275573      ,  3.823044385560796E-002 ],
 [   2.14083491113034      ,  3.231744498947085E-002 ],
 [   2.14145730598394      ,  2.569456292133874E-002 ],
 [   2.14193029417547      ,  1.836355514879096E-002 ],
 [   2.14223873707023      ,  1.032696404561087E-002 ],
 [   2.14236756072336      ,  1.588162339034307E-003 ],
 [   2.14230177155865      , -7.848564916554416E-003 ],
 [   2.14202647940417      , -1.797797894377010E-002 ],
 [   2.14152691566559      , -2.879380847149142E-002 ],
 [   2.14078845894933      , -4.028871334298909E-002 ],
 [   2.13979665562005      , -5.245421066245769E-002 ],
 [   2.13853724773562      , -6.528064457724142E-002 ],
 [   2.13699619573854      , -7.875711886697120E-002 ],
 [   2.13515970846484      , -9.287147452001610E-002 ],
 [   2.13301426754328      , -0.107610229945672      ],
 [   2.13054665930131      , -0.122958568465955      ],
 [   2.12774400024063      , -0.138900286810235      ],
 [   2.12459377074575      , -0.155417795173135      ],
 [   2.12108384079446      , -0.172492074087071      ],
 [   2.11720250543720      , -0.190102690022871      ],
 [   2.11293850975886      , -0.208227760419993      ],
 [   2.10828108603928      , -0.226843987566230      ],
 [   2.10321997705709      , -0.245926631923265      ],
 [   2.09774547446697      , -0.265449565632523      ],
 [   2.09184844008497      , -0.285385256135555      ],
 [   2.08552034403732      , -0.305704836938343      ],
 [   2.07875328496772      , -0.326378108483661      ],
 [   2.07154002478396      , -0.347373615906884      ],
 [   2.06387401060906      , -0.368658683724322      ],
 [   2.05574940133805      , -0.390199479527250      ],
 [   2.04716109446401      , -0.411961103196776      ],
 [   2.03810474175576      , -0.433907623136989      ],
 [   2.02857677895062      , -0.456002215933770      ],
 [   2.01857443588157      , -0.478207203576260      ],
 [   2.00809575831654      , -0.500484184001033      ],
 [   1.99713962303727      , -0.522794143475529      ],
 [   1.98570574476210      , -0.545097515924115      ],
 [   1.97379469225288      , -0.567354365864177      ],
 [   1.96140789271867      , -0.589524473919797      ],
 [   1.94854763584790      , -0.611567428941443      ],
 [   1.93521707675717      , -0.633442829535931      ],
 [   1.92142023447955      , -0.655110382148767      ],
 [   1.90716199291968      , -0.676529988645123      ],
 [   1.89244808968993      , -0.697661919372615      ],
 [   1.87728509920684      , -0.718467004243965      ],
 [   1.86168043120373      , -0.738906672822669      ],
 [   1.84564232414939      , -0.758943101953520      ],
 [   1.82917980990422      , -0.778539397920938      ],
 [   1.81230269336657      , -0.797659698361633      ],
 [   1.79502154617328      , -0.816269277639921      ],
 [   1.77734766600970      , -0.834334695507805      ],
 [   1.75929304619794      , -0.851823896331154      ],
 [   1.74087036139181      , -0.868706320857840      ],
 [   1.72209291519916      , -0.884953011552555      ],
 [   1.70297461491359      , -0.900536698908224      ],
 [   1.68352993835861      , -0.915431903652640      ],
 [   1.66377387961934      , -0.929614997940123      ],
 [   1.64372192797675      , -0.943064290393612      ],
 [   1.62339000920284      , -0.955760077200254      ],
 [   1.60279445117213      , -0.967684694223322      ],
 [   1.58195194078614      , -0.978822568821399      ],
 [   1.56087946899145      , -0.989160231835635      ],
 [   1.53959430118087      , -0.998686363805569      ],
 [   1.51811391321821      ,  -1.00739178075536      ],
 [   1.49645596192423      ,  -1.01526945851040      ],
 [   1.47463822701083      ,  -1.02231450855684      ],
 [   1.45267857136619      ,  -1.02852416601169      ],
 [   1.43059489656189      ,  -1.03389776843521      ],
 [   1.40840509151879      ,  -1.03843670265278      ],
 [   1.38612700036849      ,  -1.04214438551859      ],
 [   1.36377836558777      ,  -1.04502618020046      ],
 [   1.34137680143249      ,  -1.04708936797998      ],
 [   1.31893974059425      ,  -1.04834305087849      ],
 [   1.29648440577972      ,  -1.04879810074007      ],
 [   1.27402776732467      ,  -1.04846706632058      ],
 [   1.25158650826903      ,  -1.04736408752277      ],
 [   1.22917699656824      ,  -1.04550482136541      ],
 [   1.20681524370405      ,  -1.04290631784115      ],
 [   1.18451688818764      ,  -1.03958696254687      ]]))

yDerivativeEval = numpy.transpose(numpy.array([ [   0.00000000000000      ,  0.423994065929990      ],
 [  8.736132260822545E-003 ,  0.391950221463000      ],
 [  1.678668906253549E-002 ,  0.359957661312652      ],
 [  2.415244530243155E-002 ,  0.327987038978693      ],
 [  3.083357827225783E-002 ,  0.296011978877751      ],
 [  3.682974750968357E-002 ,  0.264008341942200      ],
 [  4.214010183627644E-002 ,  0.231956421651772      ],
 [  4.676342745002304E-002 ,  0.199837887137326      ],
 [  5.069811932516274E-002 ,  0.167638591680079      ],
 [  5.394234222457053E-002 ,  0.135346084680804      ],
 [  5.649395854546362E-002 ,  0.102952680308388      ],
 [  5.835077544786505E-002 ,  7.045163500986824E-002 ],
 [  5.951044634737511E-002 ,  3.784047444773020E-002 ],
 [  5.997061211997200E-002 ,  5.119520557702682E-003 ],
 [  5.972893741476247E-002 , -2.770754356949366E-002 ],
 [  5.878324611988228E-002 , -6.063462032246947E-002 ],
 [  5.713145141545643E-002 , -9.365188505214872E-002 ],
 [  5.477179477631428E-002 , -0.126746668140409      ],
 [  5.170274341311042E-002 , -0.159903034073894      ],
 [  4.792321096627247E-002 , -0.193101939593530      ],
 [  4.343248648429286E-002 , -0.226321167294737      ],
 [  3.823043352175397E-002 , -0.259535340507522      ],
 [  3.231742471277251E-002 , -0.292715945429559      ],
 [  2.569455202552400E-002 , -0.325831376774593      ],
 [  1.836353036044059E-002 , -0.358846886199456      ],
 [  1.032695348002234E-002 , -0.391724824944690      ],
 [  1.588132293518051E-003 , -0.424424369200330      ],
 [ -7.848574560301776E-003 , -0.456902105287144      ],
 [ -1.797801463004948E-002 , -0.489111408654556      ],
 [ -2.879381699610636E-002 , -0.521003484254860      ],
 [ -4.028875478141877E-002 , -0.552526313901075      ],
 [ -5.245421836426062E-002 , -0.583626218599131      ],
 [ -6.528069148302623E-002 , -0.614246343448154      ],
 [ -7.875712644635260E-002 , -0.644328737181942      ],
 [ -9.287152629179263E-002 , -0.673812427083971      ],
 [ -0.107610238572109      , -0.702635921548618      ],
 [ -0.122958624079257      , -0.730735012904644      ],
 [ -0.138900298411720      , -0.758045522718042      ],
 [ -0.155417852747478      , -0.784501052969409      ],
 [ -0.172492091827824      , -0.810035708648577      ],
 [ -0.190102746129509      , -0.834582101504502      ],
 [ -0.208227789072526      , -0.858073693402621      ],
 [ -0.226844036472136      , -0.880443455216538      ],
 [ -0.245926677302365      , -0.901625353376728      ],
 [ -0.265449599449585      , -0.921554213856753      ],
 [ -0.285385322291632      , -0.940165687648719      ],
 [ -0.305704849454166      , -0.957398082626798      ],
 [ -0.326378191693061      , -0.973189932230391      ],
 [ -0.347373616301334      , -0.987484639878141      ],
 [ -0.368658765134401      ,  -1.00022508987443      ],
 [ -0.390199506339761      ,  -1.01136072864602      ],
 [ -0.411961150332885      ,  -1.02084156989279      ],
 [ -0.433907695525187      ,  -1.02862290640826      ],
 [ -0.456002218441667      ,  -1.03466444742633      ],
 [ -0.478207278880348      ,  -1.03892794083021      ],
 [ -0.500484217431972      ,  -1.04138367135779      ],
 [ -0.522794158520652      ,  -1.04200358061620      ],
 [ -0.545097568943559      ,  -1.04076579653532      ],
 [ -0.567354380280791      ,  -1.03765625753290      ],
 [ -0.589524462176065      ,  -1.03266269826789      ],
 [ -0.611567392961868      ,  -1.02578069337064      ],
 [ -0.633442811379829      ,  -1.01701438195180      ],
 [ -0.655110367226855      ,  -1.00636968536885      ],
 [ -0.676529713820544      , -0.993859457766621      ],
 [ -0.697661547015082      , -0.979506115023032      ],
 [ -0.718466859249631      , -0.963337497454688      ],
 [ -0.738906651038162      , -0.945382864209460      ],
 [ -0.758942862694036      , -0.925683047477205      ],
 [ -0.778539230015709      , -0.904283749649010      ],
 [ -0.797659691645104      , -0.881234852564049      ],
 [ -0.816269075568512      , -0.856593671473973      ],
 [ -0.834334586028744      , -0.830422473662952      ],
 [ -0.851823851554831      , -0.802788103654394      ],
 [ -0.868706122411823      , -0.773763425283956      ],
 [ -0.884952989403061      , -0.743425210512992      ],
 [ -0.900536564445006      , -0.711854659086019      ],
 [ -0.915431776744399      , -0.679136967694720      ],
 [ -0.929614968708730      , -0.645360388387143      ],
 [ -0.943064114311457      , -0.610617070075341      ],
 [ -0.955760070140479      , -0.575000633319041      ],
 [ -0.967684547406157      , -0.538608122112171      ],
 [ -0.978822496916795      , -0.501537150664093      ],
 [ -0.989160154911775      , -0.463887213712975      ],
 [ -0.998686232512728      , -0.425758615961223      ],
 [  -1.00739176561156      , -0.387251315292555      ],
 [  -1.01526930727692      , -0.348466359021180      ],
 [  -1.02231450533743      , -0.309502447489985      ],
 [  -1.02852403445326      , -0.270459200724144      ],
 [  -1.03389772680159      , -0.231432848015057      ],
 [  -1.03843661640824      , -0.192519216652533      ],
 [  -1.04214429837897      , -0.153810992552349      ],
 [  -1.04502614491472      , -0.115398377731890      ],
 [  -1.04708925313805      , -7.736913620866509E-002 ],
 [  -1.04834304880139      , -3.980645255889535E-002 ],
 [  -1.04879798194857      , -2.791794343177129E-003 ],
 [  -1.04846705048026      ,  3.359952329135771E-002 ],
 [  -1.04736399750233      ,  6.929397450882031E-002 ],
 [  -1.04550474713655      ,  0.104224213720758      ],
 [  -1.04290629053458      ,  0.138326368777929      ],
 [  -1.03958684378358      ,  0.171540825599208      ]]))

xSol = numpy.array([   0.00000000000000      ,
  1.218275476945953E-002 ,
  3.162448696507220E-002 ,
  5.704175474904181E-002 ,
  8.745494679210150E-002 ,
  0.122967953896534      ,
  0.165027796187343      ,
  0.221299146121058      ,
  0.278091436116882      ,
  0.327225684252765      ,
  0.372303944612381      ,
  0.415754629753098      ,
  0.458366751381133      ,
  0.500529719077154      ,
  0.542482337831980      ,
  0.584391837939613      ,
  0.626388470544703      ,
  0.668606551467036      ,
  0.711148295873766      ,
  0.754111180580029      ,
  0.797605055274252      ,
  0.841753624082704      ,
  0.886702286353773      ,
  0.932629242553904      ,
  0.979762719943066      ,
   1.02841158243426      ,
   1.07902165293294      ,
   1.13229158780012      ,
   1.18922685383987      ,
   1.25128772144861      ,
   1.32323659795364      ,
   1.40808447681890      ,
   1.47480488366147      ,
   1.53418643390964      ,
   1.58982884448278      ,
   1.64298811273062      ,
   1.69453500089100      ,
   1.74494383413026      ,
   1.79454583270052      ,
   1.84360559045121      ,
   1.89234913485088      ,
   1.94098375231836      ,
   1.98975331738206      ,
   2.03945804047636      ,
   2.09108874852811      ,
   2.14529216566421      ,
   2.20255299168853      ,
   2.26357906568621      ,
   2.32945640411408      ,
   2.40205923346077      ,
   2.48515550952734      ,
   2.58448786303858      ,
   2.67676977504560      ,
   2.76555089969101      ,
   2.85315246005522      ,
   2.94090290441655      ,
   3.02982937126218      ,
   3.12090860367268      ,
   3.21519932249758      ,
   3.31398978138836      ,
   3.41904217630298      ,
   3.53307875637649      ,
   3.65826542009189      ,
   3.78789682226708      ,
   3.91335879526485      ,
   4.03738206022416      ,
   4.16196643977709      ,
   4.28849775873212      ,
   4.41809376632494      ,
   4.55176085126834      ,
   4.69057781543875      ,
   4.83587413273894      ,
   4.98896659300574      ,
   5.15630079499204      ,
   5.33307961457754      ,
   5.52167127746840      ,
   5.72328859105179      ,
   5.93884931057167      ,
   6.17420605460594      ,
   6.43304995050337      ,
   6.71748846634336      ,
   7.03399263907683      ,
   7.39153388957441      ,
   7.80035404890858      ,
   8.42528565055628      ,
   9.21264282527815      ,
   10.0000000000000      ])

ySol = numpy.transpose(numpy.array([ [   2.11997032923574      ,   0.00000000000000      ],
 [   2.12000134242674      ,  5.054294212590118E-003 ],
 [   2.12017445897011      ,  1.266028522423761E-002 ],
 [   2.12061383954691      ,  2.175231944408974E-002 ],
 [   2.12142505617429      ,  3.136385944166149E-002 ],
 [   2.12271269120099      ,  4.083805942548820E-002 ],
 [   2.12462422032344      ,  4.961514459853941E-002 ],
 [   2.12765174899844      ,  5.719231159812355E-002 ],
 [   2.13100193967033      ,  5.996907159704010E-002 ],
 [   2.13392487514999      ,  5.839045135324557E-002 ],
 [   2.13646243228899      ,  5.367087343066951E-002 ],
 [   2.13864156054585      ,  4.614489994781880E-002 ],
 [   2.14040004789208      ,  3.592033254563609E-002 ],
 [   2.14165256710592      ,  2.303464860610504E-002 ],
 [   2.14230236641917      ,  7.492500800643974E-003 ],
 [   2.14224407402345      , -1.071884831438084E-002 ],
 [   2.14136420093542      , -3.162199462189908E-002 ],
 [   2.13953936698923      , -5.525893869215703E-002 ],
 [   2.13663592964898      , -8.166520173710162E-002 ],
 [   2.13250883298456      , -0.110875397087471      ],
 [   2.12699815081469      , -0.142930171766526      ],
 [   2.11992522322889      , -0.177875048314507      ],
 [   2.11108681245371      , -0.215763528296539      ],
 [   2.10024624462594      , -0.256663099967084      ],
 [   2.08711930052506      , -0.300666436372496      ],
 [   2.07134975942252      , -0.347914160405850      ],
 [   2.05246402820980      , -0.398640167668826      ],
 [   2.02977787713307      , -0.453269597636233      ],
 [   2.00228889193409      , -0.512428099578921      ],
 [   1.96848207784398      , -0.576980351042965      ],
 [   1.92430691723210      , -0.650655558339455      ],
 [   1.86553116419702      , -0.733951416540169      ],
 [   1.81449293966964      , -0.795232082223735      ],
 [   1.76575207533008      , -0.845676586836565      ],
 [   1.71747692788981      , -0.888802696444253      ],
 [   1.66922649766467      , -0.925794312755915      ],
 [   1.62067170855829      , -0.957387259352000      ],
 [   1.57172290101064      , -0.983954974490748      ],
 [   1.52235827874256      ,  -1.00574282948263      ],
 [   1.47257721075209      ,  -1.02293458406183      ],
 [   1.42238763298805      ,  -1.03567608721961      ],
 [   1.37179605228611      ,  -1.04408776755655      ],
 [   1.32075722358340      ,  -1.04827141820151      ],
 [   1.26863565443199      ,  -1.04827201784733      ],
 [   1.21460688926399      ,  -1.04389529919619      ],
 [   1.15825148304968      ,  -1.03475846749794      ],
 [   1.09938915956447      ,  -1.02040739201875      ],
 [   1.03770793720650      ,  -1.00027639551446      ],
 [  0.972665208754662      , -0.973586000601983      ],
 [  0.903203186291897      , -0.939084735183061      ],
 [  0.826994259105630      , -0.894325299807662      ],
 [  0.741043985913159      , -0.835439967734865      ],
 [  0.666606540548635      , -0.777450763678284      ],
 [  0.600115644266675      , -0.720306162513344      ],
 [  0.539490186159801      , -0.663901374394047      ],
 [  0.483677608076361      , -0.608417209237461      ],
 [  0.432006500627670      , -0.554064402296131      ],
 [  0.383980686705174      , -0.501016407023667      ],
 [  0.339200988462636      , -0.449396656703505      ],
 [  0.297315433755999      , -0.399263731688968      ],
 [  0.257971119894019      , -0.350578127048293      ],
 [  0.220750464843351      , -0.303134017577079      ],
 [  0.185736801434063      , -0.257311161132506      ],
 [  0.155106242615602      , -0.216315473008658      ],
 [  0.130154389175829      , -0.182326166720913      ],
 [  0.109368427070689      , -0.153631953387082      ],
 [  9.179661477243990E-002 , -0.129128888686100      ],
 [  7.682641389317379E-002 , -0.108096361850218      ],
 [  6.402420122982103E-002 , -9.001320217941093E-002 ],
 [  5.306311232267677E-002 , -7.447634209895418E-002 ],
 [  4.367965034939882E-002 , -6.115087014294996E-002 ],
 [  3.565174558006464E-002 , -4.974595155905658E-002 ],
 [  2.880679188836546E-002 , -4.003094168521960E-002 ],
 [  2.284307285555959E-002 , -3.158585563415946E-002 ],
 [  1.790171438408633E-002 , -2.461324578220334E-002 ],
 [  1.382418044205136E-002 , -1.888651454501421E-002 ],
 [  1.050584747405351E-002 , -1.425291764931714E-002 ],
 [  7.850646961941255E-003 , -1.057032201078031E-002 ],
 [  5.725998226570465E-003 , -7.646265651826337E-003 ],
 [  4.058943040476307E-003 , -5.371875674159643E-003 ],
 [  2.790716603638021E-003 , -3.658185191224750E-003 ],
 [  1.847032253553970E-003 , -2.396296557935189E-003 ],
 [  1.164594217988214E-003 , -1.493958555344066E-003 ],
 [  6.916493826840713E-004 , -8.760215789796440E-004 ],
 [  3.161604823604585E-004 , -3.918927343792224E-004 ],
 [  1.217006409058102E-004 , -1.437156653425675E-004 ],
 [  5.090568160762456E-005 , -5.090568160762956E-005 ]]))

workSol = numpy.array([   0.00000000000000      ,
  0.423994065929990      ,
  5.054294213555919E-003 ,
  0.405755693381900      ,
  2.554921309296387E-003 ,
  0.414871837819105      ,
  5.054294213555919E-003 ,
  0.405755693381900      ,
  1.266028522656482E-002 ,
  0.376691095662552      ,
  8.927922985714470E-003 ,
  0.391218036052873      ,
  1.266028522656482E-002 ,
  0.376691095662552      ,
  2.175231944786334E-002 ,
  0.338735723906270      ,
  1.732689256818527E-002 ,
  0.357709673833560      ,
  2.175231944786334E-002 ,
  0.338735723906270      ,
  3.136385944666877E-002 ,
  0.293323887589932      ,
  2.673072930963065E-002 ,
  0.316033002975344      ,
  3.136385944666877E-002 ,
  0.293323887589932      ,
  4.083805943124928E-002 ,
  0.240217185698331      ,
  3.633670677415520E-002 ,
  0.266786419056576      ,
  4.083805943124928E-002 ,
  0.240217185698331      ,
  4.961514460423270E-002 ,
  0.177095320733254      ,
  4.555846397843260E-002 ,
  0.208693203059610      ,
  4.961514460423270E-002 ,
  0.177095320733254      ,
  5.719231160208822E-002 ,
  9.209654257525868E-002 ,
  5.400160260186881E-002 ,
  0.134683157962696      ,
  5.719231160208822E-002 ,
  9.209654257525868E-002 ,
  5.996907159734841E-002 ,
  5.561025704254208E-003 ,
  5.919501037085290E-002 ,
  4.892549250239808E-002 ,
  5.996907159734841E-002 ,
  5.561025704254208E-003 ,
  5.839045134883533E-002 ,
 -6.990524597069647E-002 ,
  5.964325878788775E-002 ,
 -3.210701723241716E-002 ,
  5.839045134883533E-002 ,
 -6.990524597069647E-002 ,
  5.367087342066207E-002 ,
 -0.139543419138371      ,
  5.642305834737626E-002 ,
 -0.104683976049102      ,
  5.367087342066207E-002 ,
 -0.139543419138371      ,
  4.614489993127426E-002 ,
 -0.206894686245186      ,
  5.027369401357898E-002 ,
 -0.173201341941312      ,
  4.614489993127426E-002 ,
 -0.206894686245186      ,
  3.592033252160436E-002 ,
 -0.272984901394139      ,
  4.138464676223309E-002 ,
 -0.239947669466778      ,
  3.592033252160436E-002 ,
 -0.272984901394139      ,
  2.303464857363507E-002 ,
 -0.338197107010051      ,
  2.982118306246596E-002 ,
 -0.305628726034576      ,
  2.303464857363507E-002 ,
 -0.338197107010051      ,
  7.492500758787476E-003 ,
 -0.402644358514376      ,
  1.560154103773094E-002 ,
 -0.370493244364084      ,
  7.492500758787476E-003 ,
 -0.402644358514376      ,
 -1.071884836656563E-002 ,
 -0.466285058617544      ,
 -1.279780062911131E-003 ,
 -0.434577464919723      ,
 -1.071884836656563E-002 ,
 -0.466285058617544      ,
 -3.162199468534302E-002 ,
 -0.528970786658115      ,
 -2.084134783969152E-002 ,
 -0.497786838154905      ,
 -3.162199468534302E-002 ,
 -0.528970786658115      ,
 -5.525893876778148E-002 ,
 -0.590501506722826      ,
 -4.311575311169957E-002 ,
 -0.559947838441142      ,
 -5.525893876778148E-002 ,
 -0.590501506722826      ,
 -8.166520182580637E-002 ,
 -0.650564843847163      ,
 -6.814267040477408E-002 ,
 -0.620804649313497      ,
 -8.166520182580637E-002 ,
 -0.650564843847163      ,
 -0.110875397190125      ,
 -0.708770915824746      ,
 -9.595771191301872E-002 ,
 -0.680006635174817      ,
 -0.110875397190125      ,
 -0.708770915824746      ,
 -0.142930171883962      ,
 -0.764667016853747      ,
 -0.126598892285288      ,
 -0.737133241467895      ,
 -0.142930171883962      ,
 -0.764667016853747      ,
 -0.177875048447514      ,
 -0.817725953311358      ,
 -0.160109800652350      ,
 -0.791695394830141      ,
 -0.177875048447514      ,
 -0.817725953311358      ,
 -0.215763528445849      ,
 -0.867338010675378      ,
 -0.196540538995303      ,
 -0.843125809025489      ,
 -0.215763528445849      ,
 -0.867338010675378      ,
 -0.256663100133365      ,
 -0.912798172347618      ,
 -0.235952333432861      ,
 -0.890768772613977      ,
 -0.256663100133365      ,
 -0.912798172347618      ,
 -0.300666436556344      ,
 -0.953285575673386      ,
 -0.278426229331204      ,
 -0.933863848727692      ,
 -0.300666436556344      ,
 -0.953285575673386      ,
 -0.347914160607778      ,
 -0.987829862609590      ,
 -0.324080231048934      ,
 -0.971519561769060      ,
 -0.347914160607778      ,
 -0.987829862609590      ,
 -0.398640167889261      ,
  -1.01524809733005      ,
 -0.373103709399501      ,
  -1.00266668729176      ,
 -0.398640167889261      ,
  -1.01524809733005      ,
 -0.453269597875530      ,
  -1.03401456517023      ,
 -0.425829921817454      ,
  -1.02596564040082      ,
 -0.453269597875530      ,
  -1.03401456517023      ,
 -0.512428099837328      ,
  -1.04194560142506      ,
 -0.482792404399036      ,
  -1.03958268690850      ,
 -0.512428099837328      ,
  -1.04194560142506      ,
 -0.576980351320539      ,
  -1.03572282927078      ,
 -0.544752499408787      ,
  -1.04079919215720      ,
 -0.576980351320539      ,
  -1.03572282927078      ,
 -0.650655558636496      ,
  -1.00872062386355      ,
 -0.614060802271294      ,
  -1.02487991714518      ,
 -0.650655558636496      ,
  -1.00872062386355      ,
 -0.733951416855553      ,
 -0.949929460990380      ,
 -0.692927025929251      ,
 -0.982899774975472      ,
 -0.733951416855553      ,
 -0.949929460990380      ,
 -0.795232082549525      ,
 -0.884285097387596      ,
 -0.765139227033351      ,
 -0.919150767362434      ,
 -0.795232082549525      ,
 -0.884285097387596      ,
 -0.845676587168386      ,
 -0.812771621112419      ,
 -0.820985157494562      ,
 -0.849982730603071      ,
 -0.845676587168386      ,
 -0.812771621112419      ,
 -0.888802696778856      ,
 -0.735861792257825      ,
 -0.867774573007900      ,
 -0.775429028285699      ,
 -0.888802696778856      ,
 -0.735861792257825      ,
 -0.925794313090557      ,
 -0.654731169756909      ,
 -0.907837610500287      ,
 -0.696147626077120      ,
 -0.925794313090557      ,
 -0.654731169756909      ,
 -0.957387259684267      ,
 -0.570213640704306      ,
 -0.942135363339620      ,
 -0.613109689674511      ,
 -0.957387259684267      ,
 -0.570213640704306      ,
 -0.983954974818462      ,
 -0.483277541706755      ,
 -0.971218910665969      ,
 -0.527194455024533      ,
 -0.983954974818462      ,
 -0.483277541706755      ,
  -1.00574282980382      ,
 -0.394858934990937      ,
 -0.995397119761627      ,
 -0.439346236860913      ,
  -1.00574282980382      ,
 -0.394858934990937      ,
  -1.02293458437471      ,
 -0.305829608784045      ,
  -1.01488467673631      ,
 -0.350465026542486      ,
  -1.02293458437471      ,
 -0.305829608784045      ,
  -1.03567608752256      ,
 -0.217001677047969      ,
  -1.02984655947795      ,
 -0.261390351893206      ,
  -1.03567608752256      ,
 -0.217001677047969      ,
  -1.04408776784809      ,
 -0.129127352948914      ,
  -1.04041614445255      ,
 -0.172902711774356      ,
  -1.04408776784809      ,
 -0.129127352948914      ,
  -1.04827141848033      ,
 -4.282829824354550E-002 ,
  -1.04670568908464      ,
 -8.568715679902317E-002 ,
  -1.04827141848033      ,
 -4.282829824354550E-002 ,
  -1.04827201811205      ,
  4.223913417622738E-002 ,
  -1.04880024994279      ,
  1.291951997406393E-004 ,
  -1.04827201811205      ,
  4.223913417622738E-002 ,
  -1.04389529944532      ,
  0.126532128900873      ,
  -1.04662767215386      ,
  8.496170617766063E-002 ,
  -1.04389529944532      ,
  0.126532128900873      ,
  -1.03475846772991      ,
  0.209599017801319      ,
  -1.03988969724127      ,
  0.168815618411264      ,
  -1.03475846772991      ,
  0.209599017801319      ,
  -1.02040739223203      ,
  0.290394811232033      ,
  -1.02816123421486      ,
  0.250941163970223      ,
  -1.02040739223203      ,
  0.290394811232033      ,
  -1.00027639570753      ,
  0.367801945181803      ,
  -1.01093237565532      ,
  0.330263811449328      ,
  -1.00027639570753      ,
  0.367801945181803      ,
 -0.973586000773317      ,
  0.440600973052530      ,
 -0.987530674014956      ,
  0.405628625584506      ,
 -0.973586000773317      ,
  0.440600973052530      ,
 -0.939084735330991      ,
  0.507460387197447      ,
 -0.956942140881577      ,
  0.475792943432453      ,
 -0.939084735330991      ,
  0.507460387197447      ,
 -0.894325299930059      ,
  0.566815680276067      ,
 -0.917321543107984      ,
  0.539399237299977      ,
 -0.894325299930059      ,
  0.566815680276067      ,
 -0.835439967829172      ,
  0.614788928006620      ,
 -0.865478295829947      ,
  0.593815654227355      ,
 -0.835439967829172      ,
  0.614788928006620      ,
 -0.777450763749341      ,
  0.638920237352219      ,
 -0.806723726209962      ,
  0.629160527095726      ,
 -0.777450763749341      ,
  0.638920237352219      ,
 -0.720306162564852      ,
  0.645960156999652      ,
 -0.748956589655061      ,
  0.644265550744430      ,
 -0.720306162564852      ,
  0.645960156999652      ,
 -0.663901374429027      ,
  0.639842992609398      ,
 -0.692036784353741      ,
  0.644367422364468      ,
 -0.663901374429027      ,
  0.639842992609398      ,
 -0.608417209258563      ,
  0.623195309845503      ,
 -0.635976686648780      ,
  0.632682889395192      ,
 -0.608417209258563      ,
  0.623195309845503      ,
 -0.554064402305741      ,
  0.598029953594595      ,
 -0.580961072504864      ,
  0.611509715645690      ,
 -0.554064402305741      ,
  0.598029953594595      ,
 -0.501016407023956      ,
  0.565972000791256      ,
 -0.527175427948101      ,
  0.582656335431572      ,
 -0.501016407023956      ,
  0.565972000791256      ,
 -0.449396656696461      ,
  0.528359062035259      ,
 -0.474763212981156      ,
  0.547596948015028      ,
 -0.449396656696461      ,
  0.528359062035259      ,
 -0.399263731676418      ,
  0.486283496024951      ,
 -0.423810611127159      ,
  0.507540273755312      ,
 -0.399263731676418      ,
  0.486283496024951      ,
 -0.350578127031930      ,
  0.440584710007384      ,
 -0.374320833489694      ,
  0.463444701120948      ,
 -0.350578127031930      ,
  0.440584710007384      ,
 -0.303134017558494      ,
  0.391776137798527      ,
 -0.326160326963591      ,
  0.415974137963899      ,
 -0.303134017558494      ,
  0.391776137798527      ,
 -0.257311161113249      ,
  0.340881100396432      ,
 -0.279426166844367      ,
  0.365890059566172      ,
 -0.257311161113249      ,
  0.340881100396432      ,
 -0.216315472990132      ,
  0.292405275447491      ,
 -0.236027818406724      ,
  0.316050596363425      ,
 -0.216315472990132      ,
  0.292405275447491      ,
 -0.182326166704060      ,
  0.250224287386816      ,
 -0.198659306098960      ,
  0.270712429651331      ,
 -0.182326166704060      ,
  0.250224287386816      ,
 -0.153631953372510      ,
  0.213284949364448      ,
 -0.167406392874914      ,
  0.231164997845788      ,
 -0.153631953372510      ,
  0.213284949364448      ,
 -0.129128888674224      ,
  0.180829040322468      ,
 -0.140874983612014      ,
  0.196489202062887      ,
 -0.129128888674224      ,
  0.180829040322468      ,
 -0.108096361841332      ,
  0.152338877233551      ,
 -0.118162013018667      ,
  0.166043841259048      ,
 -0.108096361841332      ,
  0.152338877233551      ,
 -9.001320217373721E-002 ,
  0.127409058589537      ,
 -9.865093138674995E-002 ,
  0.139365293214773      ,
 -9.001320217373721E-002 ,
  0.127409058589537      ,
 -7.447634209667353E-002 ,
  0.105695125881210      ,
 -8.188196737423298E-002 ,
  0.116077199675468      ,
 -7.447634209667353E-002 ,
  0.105695125881210      ,
 -6.115087014423337E-002 ,
  8.687827685819935E-002 ,
 -6.748709388837502E-002 ,
  9.584631259663726E-002 ,
 -6.115087014423337E-002 ,
  8.687827685819935E-002 ,
 -4.974595156409672E-002 ,
  7.065255529294277E-002 ,
 -5.515371865554380E-002 ,
  7.835859599579993E-002 ,
 -4.974595156409672E-002 ,
  7.065255529294277E-002 ,
 -4.003094169425575E-002 ,
  5.676236949685672E-002 ,
 -4.462263628954052E-002 ,
  6.333394022256632E-002 ,
 -4.003094169425575E-002 ,
  5.676236949685672E-002 ,
 -3.158585564764547E-002 ,
  4.465520966702283E-002 ,
 -3.555515592989487E-002 ,
  5.034817479459647E-002 ,
 -3.158585564764547E-002 ,
  4.465520966702283E-002 ,
 -2.461324580055030E-002 ,
  3.465342754283630E-002 ,
 -2.787853781938976E-002 ,
  3.933668620326539E-002 ,
 -2.461324580055030E-002 ,
  3.465342754283630E-002 ,
 -1.888651456882873E-002 ,
  2.645068276882595E-002 ,
 -2.155650902503953E-002 ,
  3.027262879377596E-002 ,
 -1.888651456882873E-002 ,
  2.645068276882595E-002 ,
 -1.425291767944089E-002 ,
  1.983550009222253E-002 ,
 -1.640299920411979E-002 ,
  2.290166102750156E-002 ,
 -1.425291767944089E-002 ,
  1.983550009222253E-002 ,
 -1.057032204837469E-002 ,
  1.460406098780040E-002 ,
 -1.227065826672358E-002 ,
  1.701580563090446E-002 ,
 -1.057032204837469E-002 ,
  1.460406098780040E-002 ,
 -7.646265698710126E-003 ,
  1.047724763810174E-002 ,
 -8.986884704389634E-003 ,
  1.236557190174968E-002 ,
 -7.646265698710126E-003 ,
  1.047724763810174E-002 ,
 -5.371875733037621E-003 ,
  7.293131829941487E-003 ,
 -6.406047098277273E-003 ,
  8.737491673863413E-003 ,
 -5.371875733037621E-003 ,
  7.293131829941487E-003 ,
 -3.658185266066842E-003 ,
  4.916705380476529E-003 ,
 -4.430537098016144E-003 ,
  5.984768629953385E-003 ,
 -3.658185266066842E-003 ,
  4.916705380476529E-003 ,
 -2.396296655010749E-003 ,
  3.185730458210538E-003 ,
 -2.958758362314524E-003 ,
  3.954826938531161E-003 ,
 -2.396296655010749E-003 ,
  3.185730458210538E-003 ,
 -1.493958685048222E-003 ,
  1.963039236278057E-003 ,
 -1.890482351471715E-003 ,
  2.498404211591916E-003 ,
 -1.493958685048222E-003 ,
  1.963039236278057E-003 ,
 -8.760217593110674E-004 ,
  1.137139156938460E-003 ,
 -1.142784646925931E-003 ,
  1.492224681682120E-003 ,
 -8.760217593110674E-004 ,
  1.137139156938460E-003 ,
 -3.918930314013089E-004 ,
  5.013735920630347E-004 ,
 -5.842936462649314E-004 ,
  7.524079234693998E-004 ,
 -3.918930314013089E-004 ,
  5.013735920630347E-004 ,
 -1.437157290022284E-004 ,
  1.839629497372237E-004 ,
 -2.365649368807305E-004 ,
  3.014691959258341E-004 ,
 -1.437157290022284E-004 ,
  1.839629497372237E-004 ,
 -5.090525633262661E-005 ,
  7.124144553760859E-005 ,
 -8.621648203280172E-005 ,
  1.130109680671306E-004 ,
  2.048382105308210E-003 ,
  0.416695747886738      ,
  8.164501885970685E-003 ,
  0.394124588680655      ,
  1.641286857255603E-002 ,
  0.361505149667818      ,
  2.576266659937610E-002 ,
  0.320573766040205      ,
  3.537983882794927E-002 ,
  0.272096085453772      ,
  4.466743124562531E-002 ,
  0.215003470984800      ,
  5.321981385018507E-002 ,
  0.143178993416498      ,
  5.889258586471932E-002 ,
  5.757521560612466E-002 ,
  5.978247857642265E-002 ,
 -2.456259584799858E-002 ,
  5.687926209390371E-002 ,
 -9.772120838425946E-002 ,
  5.101163445621987E-002 ,
 -0.166466200569460      ,
  4.239303304044480E-002 ,
 -0.233337452254366      ,
  3.109605467893701E-002 ,
 -0.299104956813199      ,
  1.714233454623033E-002 ,
 -0.364044417370452      ,
  5.281703639703237E-004 ,
 -0.428207519299225      ,
 -1.876398253324510E-002 ,
 -0.491510377792171      ,
 -4.076476118871136E-002 ,
 -0.553784599168704      ,
 -6.551445044647633E-002 ,
 -0.614785589585833      ,
 -9.304873006108991E-002 ,
 -0.674170447668919      ,
 -0.123404993807630      ,
 -0.731524874137439      ,
 -0.156626320416024      ,
 -0.786367213333633      ,
 -0.192761986698614      ,
 -0.838138389586876      ,
 -0.231871785577471      ,
 -0.886192162388429      ,
 -0.274034197315288      ,
 -0.929779588819214      ,
 -0.319362363792444      ,
 -0.968023990871572      ,
 -0.368036220308876      ,
 -0.999877125949934      ,
 -0.420369702519475      ,
  -1.02403313511481      ,
 -0.476875891904997      ,
  -1.03872334762938      ,
 -0.538291440699898      ,
  -1.04134156453837      ,
 -0.606677447240206      ,
  -1.02747458906623      ,
 -0.684562792404462      ,
 -0.988642829412725      ,
 -0.758984898095581      ,
 -0.925639447519774      ,
 -0.815916710188631      ,
 -0.857081512775261      ,
 -0.863438583920383      ,
 -0.783081028175216      ,
 -0.904115436431904      ,
 -0.704232038615191      ,
 -0.938953234067510      ,
 -0.621541247808080      ,
 -0.968539503031075      ,
 -0.535875271256121      ,
 -0.993195963982950      ,
 -0.448181960789002      ,
  -1.01314347260127      ,
 -0.359367895458517      ,
  -1.02855079936185      ,
 -0.270278670387903      ,
  -1.03955385926653      ,
 -0.181700844190057      ,
  -1.04626673352345      ,
 -9.433261038775642E-002 ,
  -1.04877972247993      ,
 -8.398210545854212E-003 ,
  -1.04704453500757      ,
  7.650577691471905E-002 ,
  -1.04078216858457      ,
  0.160475523550016      ,
  -1.02957493956292      ,
  0.242820759258271      ,
  -1.01292413173325      ,
  0.322474004979145      ,
 -0.990178742866727      ,
  0.398290093260317      ,
 -0.960372090600330      ,
  0.469036524335789      ,
 -0.921778838214319      ,
  0.533376242569525      ,
 -0.871352580791853      ,
  0.588907399705429      ,
 -0.812518321618821      ,
  0.626665345664779      ,
 -0.754673110472520      ,
  0.643498668043662      ,
 -0.697684051625227      ,
  0.644930436759126      ,
 -0.641535675137521      ,
  0.634310710077542      ,
 -0.586410095298860      ,
  0.613999531788782      ,
 -0.532496736603878      ,
  0.585844564824145      ,
 -0.479944222486320      ,
  0.551349059551423      ,
 -0.428845379267641      ,
  0.511746522555440      ,
 -0.379213433430199      ,
  0.468020941638704      ,
 -0.330931814968875      ,
  0.420869313641878      ,
 -0.284038552549659      ,
  0.371002051209443      ,
 -0.240156348992610      ,
  0.320924603264825      ,
 -0.202082278983638      ,
  0.274955303299078      ,
 -0.170296380857322      ,
  0.234882050813931      ,
 -0.143343243972230      ,
  0.199756331276703      ,
 -0.120281103265175      ,
  0.168912827869727      ,
 -0.100473291875226      ,
  0.141876683089269      ,
 -8.344813429656212E-002 ,
  0.118265452227004      ,
 -6.883074530391618E-002 ,
  9.774335193241232E-002 ,
 -5.630410669601559E-002 ,
  7.999509884377255E-002 ,
 -4.560293981376504E-002 ,
  6.473551440426106E-002 ,
 -3.640786325137677E-002 ,
  5.157069795354739E-002 ,
 -2.858284248306430E-002 ,
  4.034706178226630E-002 ,
 -2.213523065463089E-002 ,
  3.110167687094206E-002 ,
 -1.687146989394418E-002 ,
  2.357058477195925E-002 ,
 -1.264314925330409E-002 ,
  1.754505719580535E-002 ,
 -9.282828046372437E-003 ,
  1.278332684968064E-002 ,
 -6.636383604145072E-003 ,
  9.060021631607060E-003 ,
 -4.604192206530564E-003 ,
  6.225624257254382E-003 ,
 -3.086710182889113E-003 ,
  4.130368719867784E-003 ,
 -1.982032532315768E-003 ,
  2.622469190829880E-003 ,
 -1.205509414787951E-003 ,
  1.576061272245771E-003 ,
 -6.333560193056069E-004 ,
  8.168070999860330E-004 ,
 -2.615940127836305E-004 ,
  3.334596881334345E-004 ,
 -9.557378934206586E-005 ,
  1.243914593022896E-004 ,
   0.00000000000000      ,
  1.218275476945953E-002 ,
  3.162448696507220E-002 ,
  5.704175474904181E-002 ,
  8.745494679210150E-002 ,
  0.122967953896534      ,
  0.165027796187343      ,
  0.221299146121058      ,
  0.278091436116882      ,
  0.327225684252765      ,
  0.372303944612381      ,
  0.415754629753098      ,
  0.458366751381133      ,
  0.500529719077154      ,
  0.542482337831980      ,
  0.584391837939613      ,
  0.626388470544703      ,
  0.668606551467036      ,
  0.711148295873766      ,
  0.754111180580029      ,
  0.797605055274252      ,
  0.841753624082704      ,
  0.886702286353773      ,
  0.932629242553904      ,
  0.979762719943066      ,
   1.02841158243426      ,
   1.07902165293294      ,
   1.13229158780012      ,
   1.18922685383987      ,
   1.25128772144861      ,
   1.32323659795364      ,
   1.40808447681890      ,
   1.47480488366147      ,
   1.53418643390964      ,
   1.58982884448278      ,
   1.64298811273062      ,
   1.69453500089100      ,
   1.74494383413026      ,
   1.79454583270052      ,
   1.84360559045121      ,
   1.89234913485088      ,
   1.94098375231836      ,
   1.98975331738206      ,
   2.03945804047636      ,
   2.09108874852811      ,
   2.14529216566421      ,
   2.20255299168853      ,
   2.26357906568621      ,
   2.32945640411408      ,
   2.40205923346077      ,
   2.48515550952734      ,
   2.58448786303858      ,
   2.67676977504560      ,
   2.76555089969101      ,
   2.85315246005522      ,
   2.94090290441655      ,
   3.02982937126218      ,
   3.12090860367268      ,
   3.21519932249758      ,
   3.31398978138836      ,
   3.41904217630298      ,
   3.53307875637649      ,
   3.65826542009189      ,
   3.78789682226708      ,
   3.91335879526485      ,
   4.03738206022416      ,
   4.16196643977709      ,
   4.28849775873212      ,
   4.41809376632494      ,
   4.55176085126834      ,
   4.69057781543875      ,
   4.83587413273894      ,
   4.98896659300574      ,
   5.15630079499204      ,
   5.33307961457754      ,
   5.52167127746840      ,
   5.72328859105179      ,
   5.93884931057167      ,
   6.17420605460594      ,
   6.43304995050337      ,
   6.71748846634336      ,
   7.03399263907683      ,
   7.39153388957441      ,
   7.80035404890858      ,
   8.42528565055628      ,
   9.21264282527815      ,
   10.0000000000000      ,
   2.11997032923574      ,
   0.00000000000000      ,
   2.12000134242674      ,
  5.054294212590118E-003 ,
   2.12017445897011      ,
  1.266028522423761E-002 ,
   2.12061383954691      ,
  2.175231944408974E-002 ,
   2.12142505617429      ,
  3.136385944166149E-002 ,
   2.12271269120099      ,
  4.083805942548820E-002 ,
   2.12462422032344      ,
  4.961514459853941E-002 ,
   2.12765174899844      ,
  5.719231159812355E-002 ,
   2.13100193967033      ,
  5.996907159704010E-002 ,
   2.13392487514999      ,
  5.839045135324557E-002 ,
   2.13646243228899      ,
  5.367087343066951E-002 ,
   2.13864156054585      ,
  4.614489994781880E-002 ,
   2.14040004789208      ,
  3.592033254563609E-002 ,
   2.14165256710592      ,
  2.303464860610504E-002 ,
   2.14230236641917      ,
  7.492500800643974E-003 ,
   2.14224407402345      ,
 -1.071884831438084E-002 ,
   2.14136420093542      ,
 -3.162199462189908E-002 ,
   2.13953936698923      ,
 -5.525893869215703E-002 ,
   2.13663592964898      ,
 -8.166520173710162E-002 ,
   2.13250883298456      ,
 -0.110875397087471      ,
   2.12699815081469      ,
 -0.142930171766526      ,
   2.11992522322889      ,
 -0.177875048314507      ,
   2.11108681245371      ,
 -0.215763528296539      ,
   2.10024624462594      ,
 -0.256663099967084      ,
   2.08711930052506      ,
 -0.300666436372496      ,
   2.07134975942252      ,
 -0.347914160405850      ,
   2.05246402820980      ,
 -0.398640167668826      ,
   2.02977787713307      ,
 -0.453269597636233      ,
   2.00228889193409      ,
 -0.512428099578921      ,
   1.96848207784398      ,
 -0.576980351042965      ,
   1.92430691723210      ,
 -0.650655558339455      ,
   1.86553116419702      ,
 -0.733951416540169      ,
   1.81449293966964      ,
 -0.795232082223735      ,
   1.76575207533008      ,
 -0.845676586836565      ,
   1.71747692788981      ,
 -0.888802696444253      ,
   1.66922649766467      ,
 -0.925794312755915      ,
   1.62067170855829      ,
 -0.957387259352000      ,
   1.57172290101064      ,
 -0.983954974490748      ,
   1.52235827874256      ,
  -1.00574282948263      ,
   1.47257721075209      ,
  -1.02293458406183      ,
   1.42238763298805      ,
  -1.03567608721961      ,
   1.37179605228611      ,
  -1.04408776755655      ,
   1.32075722358340      ,
  -1.04827141820151      ,
   1.26863565443199      ,
  -1.04827201784733      ,
   1.21460688926399      ,
  -1.04389529919619      ,
   1.15825148304968      ,
  -1.03475846749794      ,
   1.09938915956447      ,
  -1.02040739201875      ,
   1.03770793720650      ,
  -1.00027639551446      ,
  0.972665208754662      ,
 -0.973586000601983      ,
  0.903203186291897      ,
 -0.939084735183061      ,
  0.826994259105630      ,
 -0.894325299807662      ,
  0.741043985913159      ,
 -0.835439967734865      ,
  0.666606540548635      ,
 -0.777450763678284      ,
  0.600115644266675      ,
 -0.720306162513344      ,
  0.539490186159801      ,
 -0.663901374394047      ,
  0.483677608076361      ,
 -0.608417209237461      ,
  0.432006500627670      ,
 -0.554064402296131      ,
  0.383980686705174      ,
 -0.501016407023667      ,
  0.339200988462636      ,
 -0.449396656703505      ,
  0.297315433755999      ,
 -0.399263731688968      ,
  0.257971119894019      ,
 -0.350578127048293      ,
  0.220750464843351      ,
 -0.303134017577079      ,
  0.185736801434063      ,
 -0.257311161132506      ,
  0.155106242615602      ,
 -0.216315473008658      ,
  0.130154389175829      ,
 -0.182326166720913      ,
  0.109368427070689      ,
 -0.153631953387082      ,
  9.179661477243990E-002 ,
 -0.129128888686100      ,
  7.682641389317379E-002 ,
 -0.108096361850218      ,
  6.402420122982103E-002 ,
 -9.001320217941093E-002 ,
  5.306311232267677E-002 ,
 -7.447634209895418E-002 ,
  4.367965034939882E-002 ,
 -6.115087014294996E-002 ,
  3.565174558006464E-002 ,
 -4.974595155905658E-002 ,
  2.880679188836546E-002 ,
 -4.003094168521960E-002 ,
  2.284307285555959E-002 ,
 -3.158585563415946E-002 ,
  1.790171438408633E-002 ,
 -2.461324578220334E-002 ,
  1.382418044205136E-002 ,
 -1.888651454501421E-002 ,
  1.050584747405351E-002 ,
 -1.425291764931714E-002 ,
  7.850646961941255E-003 ,
 -1.057032201078031E-002 ,
  5.725998226570465E-003 ,
 -7.646265651826337E-003 ,
  4.058943040476307E-003 ,
 -5.371875674159643E-003 ,
  2.790716603638021E-003 ,
 -3.658185191224750E-003 ,
  1.847032253553970E-003 ,
 -2.396296557935189E-003 ,
  1.164594217988214E-003 ,
 -1.493958555344066E-003 ,
  6.916493826840713E-004 ,
 -8.760215789796440E-004 ,
  3.161604823604585E-004 ,
 -3.918927343792224E-004 ,
  1.217006409058102E-004 ,
 -1.437156653425675E-004 ,
  5.090568160762456E-005 ,
 -5.090568160762956E-005 ])

iworkSol = numpy.array([           3 ,
           4 ,
           4 ])


