/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;

public abstract class WithLinkType {
    protected LinkType type;
    protected boolean hidden = false;
    private boolean single = false;
    private Colors colors = Colors.empty();
    private List<Colors> supplementary = new ArrayList<Colors>();

    public final HColor getSpecificColor() {
        return this.colors.getColor(ColorType.LINE);
    }

    public final void setSpecificColor(HColor specificColor) {
        this.setSpecificColor(specificColor, 0);
    }

    public final void setSpecificColor(HColor specificColor, int i) {
        if (i == 0) {
            this.colors = this.colors.add(ColorType.LINE, specificColor);
        } else {
            this.supplementary.add(this.colors.add(ColorType.LINE, specificColor));
        }
    }

    public List<Colors> getSupplementaryColors() {
        return Collections.unmodifiableList(this.supplementary);
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public final Colors getColors() {
        return this.colors;
    }

    public final void goDashed() {
        this.type = this.type.goDashed();
    }

    public final void goDotted() {
        this.type = this.type.goDotted();
    }

    public final void goThickness(double thickness) {
        this.type = this.type.goThickness(thickness);
    }

    public final void goHidden() {
        this.hidden = true;
    }

    public abstract void goNorank();

    public final void goBold() {
        this.type = this.type.goBold();
    }

    public final void goSingle() {
        this.single = true;
    }

    public boolean isSingle() {
        return this.single;
    }

    public void applyStyle(String arrowStyle) {
        if (arrowStyle == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(arrowStyle, ";");
        int i = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            this.applyOneStyle(s, i);
            ++i;
        }
    }

    private void applyOneStyle(String arrowStyle, int i) {
        StringTokenizer st = new StringTokenizer(arrowStyle, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equalsIgnoreCase("dashed")) {
                this.goDashed();
                continue;
            }
            if (s.equalsIgnoreCase("bold")) {
                this.goBold();
                continue;
            }
            if (s.equalsIgnoreCase("dotted")) {
                this.goDotted();
                continue;
            }
            if (s.equalsIgnoreCase("hidden")) {
                this.goHidden();
                continue;
            }
            if (s.equalsIgnoreCase("single")) {
                this.goSingle();
                continue;
            }
            if (s.equalsIgnoreCase("plain")) continue;
            if (s.equalsIgnoreCase("norank")) {
                this.goNorank();
                continue;
            }
            if (s.startsWith("thickness=")) {
                this.goThickness(Double.parseDouble(s.substring("thickness=".length())));
                continue;
            }
            HColor tmp = HColorSet.instance().getColorOrWhite(s);
            this.setSpecificColor(tmp, i);
        }
    }

    public LinkType getType() {
        return this.type;
    }

    public UStroke getUStroke() {
        throw new UnsupportedOperationException();
    }
}

