import { AsyncLocalStorage } from "node:async_hooks";
class PostHogContext {
    constructor(){
        this.storage = new AsyncLocalStorage();
    }
    get() {
        return this.storage.getStore();
    }
    run(context, fn, options) {
        const fresh = options?.fresh === true;
        if (fresh) return this.storage.run(context, fn);
        {
            const currentContext = this.get() || {};
            const mergedContext = {
                distinctId: context.distinctId ?? currentContext.distinctId,
                sessionId: context.sessionId ?? currentContext.sessionId,
                properties: {
                    ...currentContext.properties || {},
                    ...context.properties || {}
                }
            };
            return this.storage.run(mergedContext, fn);
        }
    }
}
export { PostHogContext };
