/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sc extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u00e0rabu";
        final String metaValue_bn = "bengalesu";
        final String metaValue_bo = "tibetanu";
        final String metaValue_el = "grecu";
        final String metaValue_gu = "gujarati";
        final String metaValue_hy = "armenu";
        final String metaValue_ja = "giaponesu";
        final String metaValue_jv = "giavanesu";
        final String metaValue_ka = "georgianu";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "coreanu";
        final String metaValue_kw = "c\u00f2rnicu";
        final String metaValue_la = "latinu";
        final String metaValue_lo = "laotianu";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "m\u00f2ngolu";
        final String metaValue_or = "odia";
        final String metaValue_si = "singalesu";
        final String metaValue_su = "sundanesu";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailandesu";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cherokee";
        final String metaValue_vai = "vai";
        final String metaValue_Hans = "semplificadu";
        final Object[][] data = new Object[][] {
            { "ksh", "coloniesu" },
            { "Ogam", "ogham" },
            { "Zsym", "s\u00ecmbulos" },
            { "type.nu.lanatham", "tzifras tai tham tham" },
            { "Tagb", "tagbanwa" },
            { "Zsye", "emoji" },
            { "%%NJIVA", "dialetu de Gniva/Njiva" },
            { "ccp", metaValue_ccp },
            { "Phag", "phags-pa" },
            { "Medf", "medefaidrin" },
            { "type.nu.sind", "tzifras khudawadi" },
            { "teo", "teso" },
            { "AC", "\u00ccsula de s\u2019Ascensione" },
            { "%%BARLA", "grupu dialetale barlavento de su cabubirdianu" },
            { "type.nu.sinh", "tzifras lith singalesas" },
            { "AD", "Andorra" },
            { "AE", "Emirados \u00c0rabos Unidos" },
            { "nl_BE", "fiammingu" },
            { "AF", "Afgh\u00e0nistan" },
            { "AG", "Antigua e Barbuda" },
            { "type.nu.mroo", "tzifras mro" },
            { "type.ca.ethiopic", "calend\u00e0riu et\u00ecope" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Arm\u00e8nia" },
            { "AO", "Angola" },
            { "AQ", "Ant\u00e0rticu" },
            { "AR", "Argentina" },
            { "Prti", "p\u00e0rticu de sas iscritziones" },
            { "AS", "Samoa americanas" },
            { "AT", "\u00c0ustria" },
            { "AU", "Austr\u00e0lia" },
            { "AW", "Aruba" },
            { "en_US", "inglesu americanu" },
            { "AX", "\u00ccsulas \u00c5land" },
            { "AZ", "Azerbaigi\u00e0n" },
            { "BA", "B\u00f2snia e Erzeg\u00f2vina" },
            { "BB", "Barbados" },
            { "ceb", "cebuanu" },
            { "BD", "Banglad\u00e8sh" },
            { "BE", "B\u00e8lgiu" },
            { "Sogo", "sogdianu antigu" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Santu Bartolomeu" },
            { "BM", "Bermudas" },
            { "BN", "Brunei" },
            { "BO", "Bol\u00ecvia" },
            { "BQ", "Car\u00e0ibes olandesas" },
            { "BR", "Brasile" },
            { "BS", "Bahamas" },
            { "xog", "soga" },
            { "BT", "Bhut\u00e0n" },
            { "BV", "\u00ccsula Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Bielor\u00f9ssia" },
            { "BZ", "Belize" },
            { "type.ca.persian", "calend\u00e0riu persianu" },
            { "%%CREISS", "creschente" },
            { "type.nu.hebr", "n\u00f9meros ebr\u00e0icos" },
            { "CA", "C\u00e0nada" },
            { "Kits", "iscritura khitan minore" },
            { "CC", "\u00ccsulas Cocos (Keeling)" },
            { "mzn", "mazandarani" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Rep\u00f9blica Tzentrafricana" },
            { "CG", "Congo - Bratzaville" },
            { "CH", "Isv\u00ectzera" },
            { "CI", "Costa de Av\u00f2riu" },
            { "CK", "\u00ccsulas Cook" },
            { "CL", "Tzile" },
            { "Kthi", "kaithi" },
            { "CM", "Camer\u00f9n" },
            { "CN", "Tzina" },
            { "CO", "Col\u00f2mbia" },
            { "CP", "\u00ccsula de Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabu birde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "\u00ccsula de sa Natividade" },
            { "CY", "Tzipru" },
            { "type.nu.bali", "tzifras balinesas" },
            { "CZ", "Tz\u00e8chia" },
            { "Ahom", "ahom" },
            { "Pauc", "pau cin hau" },
            { "%%RIGIK", "volap\u00fck cl\u00e0ssicu" },
            { "Sogd", "sogdianu" },
            { "DE", "Germ\u00e0nia" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "tzifras devanagari" },
            { "DJ", "Gibuti" },
            { "DK", "Danimarca" },
            { "Brai", "braille" },
            { "Brah", "brahmi" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "n\u00f9meros armenos min\u00f9scolos" },
            { "DO", "Rep\u00f9blica Dominicana" },
            { "Mtei", "meitei mayek" },
            { "Takr", "takri" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta e Melilla" },
            { "EC", "\u00c8cuador" },
            { "EE", "Est\u00f2nia" },
            { "EG", "Egitu" },
            { "EH", "Sahara otzidentale" },
            { "type.nu.mathbold", "tzifras matem\u00e0ticas in grussitu" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Ispagna" },
            { "ET", "Eti\u00f2pia" },
            { "Vith", "vithkuqi" },
            { "EU", "Unione Europea" },
            { "type.ca.gregorian", "calend\u00e0riu gregorianu" },
            { "EZ", "Eurozona" },
            { "type.nu.gujr", "tzifras gujarati" },
            { "FI", "Finl\u00e0ndia" },
            { "FJ", "Fiji" },
            { "FK", "\u00ccsulas Falkland" },
            { "FM", "Micron\u00e8sia" },
            { "FO", "\u00ccsulas F\u00f8royar" },
            { "Taml", metaValue_ta },
            { "FR", "Frantza" },
            { "%%SIMPLE", metaValue_Hans },
            { "%%DAJNKO", "alfabetu Dajnko" },
            { "type.ca.indian", "calend\u00e0riu natzionale indianu" },
            { "GA", "Gab\u00f2n" },
            { "GB", "Regnu Unidu" },
            { "pcm", "pidgin nigerianu" },
            { "GD", "Grenada" },
            { "GE", "Ge\u00f2rgia" },
            { "GF", "Guiana frantzesa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibilterra" },
            { "GL", "Groenl\u00e0ndia" },
            { "GM", "G\u00e0mbia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupa" },
            { "GQ", "Guinea Ecuadoriale" },
            { "GR", "Gr\u00e8tzia" },
            { "GS", "Ge\u00f2rgia de su Sud e \u00ccsulas Sandwich Australes" },
            { "GT", "Guatemala" },
            { "GU", "Gu\u00e0m" },
            { "type.nu.mathmono", "tzifras matem\u00e0ticas a isp\u00e0tziu s\u00ecngulu" },
            { "GW", "Guinea-Bissau" },
            { "rhg", "rohingya" },
            { "Talu", "tai lue nou" },
            { "GY", "Guyana" },
            { "ckb", "curdu tzentrale" },
            { "zxx", "perunu cuntenutu lingu\u00ecsticu" },
            { "%%VIVARAUP", "vivaro-alpinu" },
            { "de_AT", "tedescu austr\u00ecacu" },
            { "Vaii", metaValue_vai },
            { "HK", "RAS tzinesa de Hong Kong" },
            { "HM", "\u00ccsulas Heard e McDonald" },
            { "HN", "Honduras" },
            { "HR", "Cro\u00e0tzia" },
            { "agq", "aghem" },
            { "gsw", "tedescu isv\u00ectzeru" },
            { "type.ca.islamic-umalqura", "calend\u00e0riu isl\u00e0micu (Umm al-Qura)" },
            { "HT", "Haiti" },
            { "HU", "Ungheria" },
            { "IC", "\u00ccsulas Can\u00e0rias" },
            { "ID", "Indon\u00e8sia" },
            { "Adlm", "adlam" },
            { "type.nu.kali", "tzifras kayah li" },
            { "IE", "Irlanda" },
            { "%%NDYUKA", "dialetu ndyuka" },
            { "naq", "nama" },
            { "type.nu.sora", "tzifras sora sompeng" },
            { "Tang", "tangut" },
            { "IL", "Israele" },
            { "Nbat", "nabateu" },
            { "IM", "\u00ccsula de Man" },
            { "IN", "\u00ccndia" },
            { "type.co.eor", "r\u00e8gulas de ordinamentu europeas" },
            { "IO", "Territ\u00f2riu Brit\u00e0nnicu de s\u2019Otz\u00e8anu Indianu" },
            { "IQ", "Iraq" },
            { "IR", "Ir\u00e0n" },
            { "IS", "Islanda" },
            { "IT", "It\u00e0lia" },
            { "Zmth", "notatzione matem\u00e0tica" },
            { "type.nu.thai", "tzifras tailandesas" },
            { "%%POSIX", "inform\u00e0ticu" },
            { "type.nu.beng", "tzifras bengalesas" },
            { "type.nu.cyrl", "tzifras tzir\u00ecllicas" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "calend\u00e0riu isl\u00e0micu" },
            { "Beng", metaValue_bn },
            { "JM", "Giam\u00e0ica" },
            { "%%EKAVSK", "serbu cun pron\u00f9ntzia ekaviana" },
            { "JO", "Giord\u00e0nia" },
            { "JP", "Giapone" },
            { "%%1606NICT", "frantzesu m\u00e8diu-tardu finas a su 1606" },
            { "%%KOCIEWIE", "variante kochieviana" },
            { "Mend", "mende" },
            { "guz", "gusii" },
            { "type.nu.knda", "tzifras kannada" },
            { "Kali", "kayah li" },
            { "Sidd", "siddham" },
            { "de_CH", "tedescu artu isv\u00ectzeru" },
            { "type.ca.buddhist", "calend\u00e0riu buddhista" },
            { "KE", "K\u00e8nya" },
            { "419", "Am\u00e8rica latina" },
            { "KG", "Kirgh\u00eczistan" },
            { "KH", "Camb\u00f2dia" },
            { "KI", "Kiribati" },
            { "KM", "Comoras" },
            { "Knda", metaValue_kn },
            { "KN", "Santu Cristolu e Nevis" },
            { "Zinh", "eredadu" },
            { "fr_CA", "frantzesu canadesu" },
            { "KP", "Corea de su Nord" },
            { "KR", "Corea de su Sud" },
            { "Plrd", "pollard miao" },
            { "fr_CH", "frantzesu isv\u00ectzeru" },
            { "KW", "Kuwait" },
            { "KY", "\u00ccsulas Cayman" },
            { "KZ", "Kaz\u00e0kistan" },
            { "Cyrl", "tzir\u00ecllicu" },
            { "LA", "Laos" },
            { "LB", "L\u00e8banu" },
            { "LC", "Santa Lughia" },
            { "%%LUNA1918", "ortografia russa riformada de su 1918" },
            { "nds", "bassu-tedescu" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "Hmnp", "nyiakeng puachue hmong" },
            { "LR", "Lib\u00e8ria" },
            { "LS", "Lesotho" },
            { "LT", "Litu\u00e0nia" },
            { "LU", "Lussemburgu" },
            { "LV", "Let\u00f2nia" },
            { "Kana", "katakana" },
            { "Sora", "sora sompeng" },
            { "LY", "L\u00ecbia" },
            { "vun", "vunjo" },
            { "%%LAUKIKA", "variante cl\u00e0ssica" },
            { "Mahj", "mahajani" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marocu" },
            { "MC", "M\u00f2nacu" },
            { "MD", "Mold\u00e0via" },
            { "Nshu", "n\u00fcshu" },
            { "ME", "Montenegro" },
            { "MF", "Santu Martine" },
            { "MG", "Madagasc\u00e0r" },
            { "Thai", metaValue_th },
            { "MH", "\u00ccsulas Marshall" },
            { "type.nu.vaii", "tzifras vai" },
            { "MK", "Matzed\u00f2nia de su Nord" },
            { "type.nu.mathdbl", "tzifras matem\u00e0ticas a tr\u00e0tu d\u00f2piu" },
            { "ML", "Mali" },
            { "MM", "Myanm\u00e0r (Birm\u00e0nia)" },
            { "MN", "Mong\u00f2lia" },
            { "MO", "RAS tzinesa de Macao" },
            { "MP", "\u00ccsulas Mariannas setentrionales" },
            { "MQ", "Martinica" },
            { "MR", "Maurit\u00e0nia" },
            { "MS", "Montserrat" },
            { "Chrs", "cor\u00e0smiu" },
            { "MT", "Malta" },
            { "MU", "Maur\u00ectzius" },
            { "MV", "Maldivas" },
            { "MW", "Malawi" },
            { "MX", "M\u00e8ssicu" },
            { "type.ca.japanese", "calend\u00e0riu giaponesu" },
            { "MY", "Mal\u00e8sia" },
            { "MZ", "Mozambicu" },
            { "Phli", "pahlavi de sas iscritziones" },
            { "NA", "Nam\u00ecbia" },
            { "%%ARANES", "aranesu" },
            { "202", "\u00c0frica sub-sahariana" },
            { "type.ca.hebrew", "calend\u00e0riu ebr\u00e0icu" },
            { "type.co.dictionary", "ordinamentu de su ditzion\u00e0riu" },
            { "NC", "Caled\u00f2nia Noa" },
            { "%%WADEGILE", "romanizatzione Wale-Giles" },
            { "%%UCRCOR", "ortografia revisionada unificada" },
            { "NE", "Niger" },
            { "NF", "\u00ccsula Norfolk" },
            { "NG", "Nig\u00e8ria" },
            { "Phlp", "psalter pahlavi" },
            { "NI", "Nicar\u00e0gua" },
            { "Hmng", "pahawn hmong" },
            { "NL", "Paisos Bassos" },
            { "NO", "Norv\u00e8gia" },
            { "NP", "N\u00e8pal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "Phnx", "fen\u00ectziu" },
            { "rof", "rombo" },
            { "NZ", "Zelanda Noa" },
            { "Merc", "corsivu mero\u00ecticu" },
            { "%%COLB1945", "cunventzione ortogr\u00e0fica portoghesa-brasiliana de su 1945" },
            { "Mero", "mero\u00ecticu" },
            { "%%GRMISTR", "ortografia otzitana mistraliana" },
            { "OM", "Om\u00e0n" },
            { "%%PETR1708", "ortografia de Perdu I de su 1708" },
            { "type.nu.hmnp", "tzifras nyiakeng puachue hmong" },
            { "Xpeo", "persianu antigu" },
            { "type.nu.hmng", "tzifras pahawh hmong" },
            { "PA", "P\u00e0nama" },
            { "type.ca.islamic-civil", "calend\u00e0riu isl\u00e0micu (tabulare, \u00e8poca tzivile)" },
            { "en_GB", "inglesu brit\u00e0nnicu" },
            { "PE", "Per\u00f9" },
            { "PF", "Polin\u00e8sia frantzesa" },
            { "PG", "P\u00e0pua Guinea Noa" },
            { "PH", "Filipinas" },
            { "PK", "P\u00e0kistan" },
            { "%%NICARD", "nitzardu" },
            { "PL", "Pol\u00f2nia" },
            { "ewo", "ewondo" },
            { "PM", "Santu Predu e Miquelon" },
            { "PN", "\u00ccsulas P\u00ectcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Territ\u00f2rios palestinesos" },
            { "Bali", "balinesu" },
            { "PT", "Portogallu" },
            { "PW", "Palau" },
            { "type.nu.greklow", "n\u00f9meros grecos min\u00f9scolos" },
            { "PY", "Paragu\u00e0y" },
            { "Hebr", "ebr\u00e0icu" },
            { "QA", "Catar" },
            { "%%SCOTLAND", "inglesu istandard iscotzesu" },
            { "QO", "Otze\u00e0nia perif\u00e8rica" },
            { "type.nu.ahom", "tzifras ahom" },
            { "%%FONUPA", "alfabetu fon\u00e8ticu ur\u00e0licu UPA" },
            { "type.nu.takr", "tzifras takri" },
            { "Tavt", "tai viet" },
            { "%%SOTAV", "grupu dialetale sotavento de su cabubirdianu" },
            { "Maka", "makasar" },
            { "001", "Mundu" },
            { "002", "\u00c0frica" },
            { "003", "Am\u00e8rica de su Nord" },
            { "RE", "Riunione" },
            { "005", "Am\u00e8rica de su Sud" },
            { "Rjng", "rejang" },
            { "009", "Otze\u00e0nia" },
            { "Elym", "elim\u00e0icu" },
            { "%%SURSILV", "sursilvanu" },
            { "RO", "Romania" },
            { "RS", "S\u00e8rbia" },
            { "Mroo", "mro" },
            { "RU", "R\u00f9ssia" },
            { "RW", "Ruanda" },
            { "type.nu.talu", "tzifras tai lue noas" },
            { "%%METELKO", "alfabetu Metelko" },
            { "Mani", "manicheu" },
            { "Ugar", "ugar\u00ecticu" },
            { "Khar", "kharoshthi" },
            { "SA", "Ar\u00e0bia Saudita" },
            { "Mand", "mand\u00e0icu" },
            { "SB", "\u00ccsulas Salomone" },
            { "twq", "tasawaq" },
            { "Tnsa", "tangsa" },
            { "011", "\u00c0frica otzidentale" },
            { "SC", "Seychelles" },
            { "SD", "Sud\u00e0n" },
            { "013", "Am\u00e8rica tzentrale" },
            { "SE", "Isv\u00e8tzia" },
            { "014", "\u00c0frica orientale" },
            { "015", "\u00c0frica setentrionale" },
            { "SG", "Singapore" },
            { "SH", "Santa Elene" },
            { "type.lb.strict", "truncadura de l\u00ecnia fortzada" },
            { "017", "\u00c0frica tzentrale" },
            { "SI", "Islov\u00e8nia" },
            { "type.nu.mymrtlng", "tzifras tai lang birmanas" },
            { "018", "\u00c0frica meridionale" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "019", "Am\u00e8ricas" },
            { "SK", "Islov\u00e0chia" },
            { "Bamu", "bamum" },
            { "SL", "Sierra Leone" },
            { "SM", "Santu Marinu" },
            { "SN", "Senegal" },
            { "SO", "Som\u00e0lia" },
            { "type.nu.taml", "n\u00f9meros tamil traditzionales" },
            { "SR", "Suriname" },
            { "SS", "Sudan de su Sud" },
            { "ST", "S\u00e3o Tom\u00e9 e Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "S\u00ecria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "sistema consuetudin\u00e0riu americanu" },
            { "021", "Am\u00e8rica setentrionale" },
            { "TC", "\u00ccsulas Turks e Caicos" },
            { "yav", "yangben" },
            { "TD", "Chad" },
            { "Qaag", "zawgyi" },
            { "TF", "Terras australes frantzesas" },
            { "TG", "Togo" },
            { "TH", "Tail\u00e0ndia" },
            { "TJ", "Tag\u00eckistan" },
            { "029", "Car\u00e0ibes" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Est" },
            { "type.co.searchjl", "chirca pro consonante hangul initziale" },
            { "TM", "Turkm\u00e8nistan" },
            { "%%BOONT", "boontling" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "%%NULIK", "volap\u00fck modernu" },
            { "TR", "Turchia" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiw\u00e0n" },
            { "ast", "asturianu" },
            { "Orkh", "orkhon" },
            { "TZ", "Tanz\u00e0nia" },
            { "nmg", "kwasio" },
            { "Zzzz", "iscritura disconnota" },
            { "Sind", "khudawadi" },
            { "UA", "Ucraina" },
            { "lij", "l\u00ecgure" },
            { "030", "\u00c0sia orientale" },
            { "sw_CD", "swahili de su Congo" },
            { "034", "\u00c0sia meridionale" },
            { "035", "Sud-est asi\u00e0ticu" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "ordinamentu pinyin" },
            { "039", "Europa meridionale" },
            { "Sinh", metaValue_si },
            { "UM", "\u00ccsulas perif\u00e8ricas de sos Istados Unidos" },
            { "UN", "Natziones Unidas" },
            { "US", "Istados Unidos" },
            { "haw", "hawaianu" },
            { "%%1959ACAD", "acad\u00e8micu" },
            { "%%IVANCHOV", "ortografia b\u00f9lgara de Ivanchov de su 1899" },
            { "type.co.gb2312han", "ordinamentu de su tzinesu semplificadu - GB2312" },
            { "UY", "Urugu\u00e0y" },
            { "prg", "prussianu" },
            { "UZ", "Uzb\u00e8kistan" },
            { "tzm", "tamazight de s\u2019Atl\u00e0nte tzentrale" },
            { "type.co.stroke", "\u00f2rdine de sos tratos" },
            { "nnh", "ngiemboon" },
            { "VA", "Tzitade de su Vaticanu" },
            { "VC", "Santu Vissente e sas Grenadinas" },
            { "%%HSISTEMO", "sistema ortogr\u00e0ficu H de s\u2019esperanto" },
            { "VE", "Venetzuela" },
            { "VG", "\u00ccsulas V\u00e8rgines Brit\u00e0nnicas" },
            { "VI", "\u00ccsulas V\u00e8rgines de sos Istados Unidos" },
            { "%%LEMOSIN", "limosinu" },
            { "Soyo", "soyombo" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "Marc", "marchen" },
            { "rwk", "rwa" },
            { "053", "Austral\u00e0sia" },
            { "054", "Melan\u00e8sia" },
            { "WF", "Wallis e Futuna" },
            { "type.co.traditional", "ordinamentu traditzionale" },
            { "057", "Regione micronesiana" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "%%HEPBURN", "romanizatzione Hepburn" },
            { "type.co.compat", "ordinamentu antepostu, pro cumpatibilitade" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "Bass", "bassa vah" },
            { "type.nu.mtei", "tzifras meitei mayek" },
            { "XA", "ps\u00e8udo-atzentos" },
            { "XB", "ps\u00e8udo-bidi" },
            { "061", "Polin\u00e8sia" },
            { "%%KSCOR", "ortografia istandard" },
            { "XK", "K\u00f2ssovo" },
            { "type.nu.brah", "tzifras brahmi" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "no iscritu" },
            { "Olck", "ol chiki" },
            { "Batk", "batak" },
            { "YE", "Yemen" },
            { "type.co.standard", "ordinamentu istandard" },
            { "Zanb", "zanabar cuadradu" },
            { "%%BALANKA", "dialetu balanka de s\u2019anii" },
            { "%%ROZAJ", "resianu" },
            { "%%SUTSILV", "sutsilvanu" },
            { "Sgnw", "limba de sos sinnos" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "tzifras cham" },
            { "%%NEWFOUND", "inglesu de Terranova" },
            { "ZA", "Sud\u00e0frica" },
            { "type.nu.sund", "tzifras sundanesas" },
            { "type.lb.loose", "truncadura de l\u00ecnia facoltativa" },
            { "Deva", "devanagari" },
            { "type.nu.geor", "n\u00f9meros georgianos" },
            { "type.co.zhuyin", "ordinamentu zhuyin" },
            { "Hira", "hiragana" },
            { "ZM", "Z\u00e0mbia" },
            { "%%PINYIN", "romanizatzione pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "regione disconnota" },
            { "Runr", "r\u00f9nicu" },
            { "type.ms.metric", "sistema m\u00e8tricu" },
            { "type.ca.iso8601", "calend\u00e0riu ISO-8601" },
            { "type.nu.telu", "tzifras telugu" },
            { "lou", "cr\u00e8olu de sa Louisiana" },
            { "%%FONKIRSH", "alfabetu fon\u00e8ticu de Kirshenbaum" },
            { "%%ASANTE", "asante" },
            { "%%AUVERN", "auvernesu" },
            { "jmc", "machame" },
            { "type.nu.hansfin", "n\u00f9meros finantzi\u00e0rios in tzinesu semplificadu" },
            { "type.nu.arabext", "tzifras indo-\u00e0rabas est\u00e8ndidas" },
            { "nus", "nuer" },
            { "type.nu.fullwide", "tzifras a larg\u00e0ria intrea" },
            { "dav", "taita" },
            { "lrc", "fr\u00ecsonu setentrionale" },
            { "type.co.emoji", "ordinamentu de sas emoji" },
            { "Copt", "coptu" },
            { "Khmr", metaValue_km },
            { "%%FONNAPA", "alfabetu fon\u00e8ticu de s\u2019Am\u00e8rica setentrionale" },
            { "type.ca.islamic-rgsa", "calend\u00e0riu isl\u00e0micu (Ar\u00e0bia Saudita, osservatzione)" },
            { "Limb", "limbu" },
            { "type.nu.roman", "n\u00f9meros romanos" },
            { "sah", "yakut" },
            { "type.nu.shrd", "tzifras sharada" },
            { "Aghb", "albanesu cauc\u00e0sicu" },
            { "%%SCOUSE", "scouse" },
            { "saq", "samburu" },
            { "sat", "santali" },
            { "Tfng", "tifinagh" },
            { "Guru", "gurmukhi" },
            { "%%ALUKU", "dialetu aluku" },
            { "type.nu.diak", "tzifras dhives akuru" },
            { "%%BISCAYAN", "bizcaianu" },
            { "type.nu.tirh", "tzifras tirhuta" },
            { "sbp", "sangu" },
            { "%%GRITAL", "ortografia otzitana italianizada" },
            { "nyn", "nyankole" },
            { "luo", "luo" },
            { "fil", "filipinu" },
            { "hmn", "hmong" },
            { "type.nu.wara", "tzifras warang citi" },
            { "luy", "luyia" },
            { "bas", "basaa" },
            { "%%ABL1943", "formulatzione ortogr\u00e0fica de su 1943" },
            { "es_ES", "ispagnolu europeu" },
            { "Aran", "nasta\u02bfl\u012bq" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "type.nu.cakm", "tzifras chakma" },
            { "am", "am\u00e0ricu" },
            { "Arab", metaValue_ar },
            { "%%SOLBA", "dialetu de Stolvizza/Solbica" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "sillab\u00e0rios giaponesos" },
            { "as", "assamesu" },
            { "Lina", "lineare A" },
            { "Linb", "lineare B" },
            { "az", "azerbaigianu" },
            { "Rohg", "hanifi rohingya" },
            { "Khoj", "khojki" },
            { "%%CISAUP", "cisalpinu" },
            { "%%OSOJS", "dialetu de Oseacco/Osojane" },
            { "%%UNIFON", "alfabetu fon\u00e8ticu Unifon" },
            { "type.co.unihan", "ordinamentu in base a sos radicales" },
            { "be", "bielorussu" },
            { "bg", "b\u00f9lgaru" },
            { "type.nu.java", "tzifras giavanesas" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "br\u00e8tonu" },
            { "bs", "bosn\u00ecacu" },
            { "Bhks", "bhaiksuki" },
            { "Mymr", "birmanu" },
            { "type.nu.laoo", "tzifras laotianas" },
            { "seh", "sena" },
            { "Nkoo", "n\u2019ko" },
            { "ca", "catalanu" },
            { "ses", "koyraboro senni" },
            { "ce", "cecenu" },
            { "%%REVISED", "ortografia revisionada" },
            { "co", "corsicanu" },
            { "Orya", metaValue_or },
            { "cs", "tzecu" },
            { "cu", "islavu eclesi\u00e0sticu" },
            { "cy", "gallesu" },
            { "type.nu.ethi", "n\u00f9meros et\u00ecopes" },
            { "Yiii", "yi" },
            { "da", "danesu" },
            { "pt_PT", "portoghesu europeu" },
            { "de", "tedescu" },
            { "type.cf.standard", "formadu de valuta istandard" },
            { "Bugi", "buginesu" },
            { "bem", "bemba" },
            { "type.nu.mong", "tzifras m\u00f2ngolas" },
            { "es_419", "ispagnolu latinoamericanu" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "type.ca.chinese", "calend\u00e0riu tzinesu" },
            { "Lisu", "lisu" },
            { "dje", "zarma" },
            { "type.nu.grek", "n\u00f9meros grecos" },
            { "ee", "ewe" },
            { "type.lb.normal", "truncadura de l\u00ecnia normale" },
            { "ro_MD", "moldavu" },
            { "el", metaValue_el },
            { "en", "inglesu" },
            { "eo", "esperanto" },
            { "type.co.big5han", "ordinamentu de su tzinesu traditzionale - Big5" },
            { "es", "ispagnolu" },
            { "et", "\u00e8stone" },
            { "Hanb", "han cun bopomofo" },
            { "eu", "bascu" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", "samaritanu" },
            { "shi", "tashelhit" },
            { "hsb", "s\u00f2rabu artu" },
            { "Hani", "han" },
            { "%%ULSTER", "ortografia de s\u2019Ulster" },
            { "Hano", "hanunoo" },
            { "fa", "persianu" },
            { "Hans", metaValue_Hans },
            { "type.nu.latn", "tzifras otzidentales" },
            { "Hant", "traditzionale" },
            { "ff", "fulah" },
            { "fi", "finlandesu" },
            { "yue", "cantonesu" },
            { "fo", "faroesu" },
            { "fr", "frantzesu" },
            { "%%AKUAPEM", "akuapem" },
            { "fy", "fr\u00ecsonu otzidentale" },
            { "ga", "irlandesu" },
            { "Wcho", "wancho" },
            { "gd", "ga\u00e8licu iscotzesu" },
            { "Gong", "gunjala gondi" },
            { "gl", "galitzianu" },
            { "Gonm", "gondi de Masaram" },
            { "und", "limba disconnota" },
            { "type.ca.ethiopic-amete-alem", "calend\u00e0riu et\u00ecope Amete Alem" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "calend\u00e0riu isl\u00e0micu (tabulare, \u00e8poca astron\u00f2mica)" },
            { "gv", "mannesu" },
            { "type.nu.osma", "tzifras osmanya" },
            { "ha", "hausa" },
            { "he", "ebreu" },
            { "hi", "hindi" },
            { "hr", "croatu" },
            { "ht", "cr\u00e8olu haitianu" },
            { "hu", "ungheresu" },
            { "hy", metaValue_hy },
            { "frc", "frantzesu cajun" },
            { "%%FONIPA", "alfabetu fon\u00e8ticu internatzionale IPA" },
            { "ia", "interl\u00ecngua" },
            { "Jamo", "jamo" },
            { "id", "indonesianu" },
            { "type.nu.tibt", "tzifras tibetanas" },
            { "%%GASCON", "gasconu" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "%%RUMGR", "istandard de sos Grisones" },
            { "%%AO1990", "acordu ortogr\u00e0ficu de sa limba portoghesa de su 1990" },
            { "is", "islandesu" },
            { "it", "italianu" },
            { "%%CORNU", metaValue_kw },
            { "%%HOGNORSK", "variante de norvegesu artu (h\u00f8gnorsk)" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "\u00e0rabu meridionale antigu" },
            { "doi", "dogri" },
            { "type.nu.lepc", "tzifras lepcha" },
            { "jv", metaValue_jv },
            { "Shaw", "shavianu" },
            { "%%BAUDDHA", "variante \u00ecbrida buddhista" },
            { "mai", "maithili" },
            { "Ougr", "uiguru antigu" },
            { "smn", "sami de sos inari" },
            { "ka", metaValue_ka },
            { "Goth", "g\u00f2ticu" },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kk", "kazaku" },
            { "kl", "groenlandesu" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "ks", "kashmiri" },
            { "Lepc", "lepcha" },
            { "Avst", "av\u00e8sticu" },
            { "ku", "curdu" },
            { "kw", metaValue_kw },
            { "ky", "kirghisu" },
            { "Mult", "multani" },
            { "la", metaValue_la },
            { "Hatr", "hatran" },
            { "lb", "lussemburghesu" },
            { "type.nu.mlym", "tzifras malayam" },
            { "lg", "ganda" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friulanu" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "sistema imperiale brit\u00e0nnicu" },
            { "type.nu.lana", "tzifras tai tham hora" },
            { "lt", "lituanu" },
            { "lu", "luba-katanga" },
            { "lv", "l\u00e8tone" },
            { "mg", "malg\u00e0sciu" },
            { "type.co.ducet", "ordinamentu Unicode predefinidu" },
            { "mi", "maori" },
            { "mk", "matz\u00e8done" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malesu" },
            { "mt", "maltesu" },
            { "my", "burmesu" },
            { "Saur", "saurashtra" },
            { "Armn", metaValue_hy },
            { "dsb", "s\u00f2rabu bassu" },
            { "Armi", "aram\u00e0icu imperiale" },
            { "type.co.search", "chirca gen\u00e8rica" },
            { "nb", "norvegesu bokm\u00e5l" },
            { "nd", "ndebele de su nord" },
            { "ne", "nepalesu" },
            { "nl", "olandesu" },
            { "nn", "norvegesu nynorsk" },
            { "no", "norvegesu" },
            { "%%PROVENC", "proventzale" },
            { "type.nu.modi", "tzifras modi" },
            { "Osge", "osage" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "kab", "cabilu" },
            { "%%POLYTON", "polit\u00f2nicu" },
            { "kam", "kamba" },
            { "%%EMODENG", "primu inglesu modernu" },
            { "mer", "meru" },
            { "type.nu.armn", "n\u00f9meros armenos" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "Modi", "modi" },
            { "os", "oss\u00e8ticu" },
            { "%%ALALC97", "romanizatzione de ALA-LC, versione de su 1997" },
            { "mfe", "cr\u00e8olu mauritzianu" },
            { "pa", "punjabi" },
            { "dua", "duala" },
            { "%%LIPAW", "su dialetu lipovaz de su resianu" },
            { "pl", "polacu" },
            { "type.nu.saur", "tzifras saurashtra" },
            { "type.ca.dangi", "calend\u00e0riu dangi" },
            { "%%VALLADER", "vallader" },
            { "ps", "pashto" },
            { "pt", "portoghesu" },
            { "key.co", "ordinamentu" },
            { "pt_BR", "portoghesu brasilianu" },
            { "%%BOHORIC", "alfabetu Bohori\u010d" },
            { "mgh", "makhuwa-meetto" },
            { "key.cf", "formadu de valuta" },
            { "type.nu.nkoo", "tzifras n\u2019ko" },
            { "key.ca", "calend\u00e0riu" },
            { "%%JAUER", "dialetu jauer" },
            { "Laoo", metaValue_lo },
            { "%%SURMIRAN", "surmiranu" },
            { "mgo", "meta\u2019" },
            { "type.hc.h23", "sistema or\u00e0riu a 24 oras (0\u201323)" },
            { "type.hc.h24", "sistema or\u00e0riu a 24 oras (1\u201324)" },
            { "type.nu.mymr", "tzifras birmanas" },
            { "qu", "quechua" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "%%VAIDIKA", "variante v\u00e8dica" },
            { "Ethi", "et\u00ecope" },
            { "%%JYUTPING", "romanizatzione jyutping" },
            { "type.hc.h12", "sistema or\u00e0riu a 12 oras (1\u201312)" },
            { "type.hc.h11", "sistema or\u00e0riu a 12 oras (0\u201311)" },
            { "rm", "rom\u00e0nciu" },
            { "rn", "rundi" },
            { "key.cu", "valuta" },
            { "ro", "rumenu" },
            { "%%SAAHO", "saho" },
            { "type.nu.orya", "tzifras odia" },
            { "type.nu.hanidec", "n\u00f9meros detzimales tzinesos" },
            { "ru", "russu" },
            { "rw", "kinyarwanda" },
            { "kea", "cabubirdianu" },
            { "en_AU", "inglesu australianu" },
            { "Dupl", "istenografia duployan" },
            { "sa", "s\u00e0nscritu" },
            { "%%UCCOR", "ortografia unificada" },
            { "sc", "sardu" },
            { "sd", "sindhi" },
            { "se", "sami setentrionale" },
            { "sg", "sango" },
            { "si", metaValue_si },
            { "sk", "islovacu" },
            { "sl", "islovenu" },
            { "Gran", "grantha" },
            { "sm", "samoanu" },
            { "%%BASICENG", "inglesu b\u00e0sicu" },
            { "sn", "shona" },
            { "so", "s\u00f2malu" },
            { "type.nu.arab", "tzifras indo-\u00e0rabas" },
            { "sq", "albanesu" },
            { "sr", "serbu" },
            { "type.cf.account", "formadu de valuta cont\u00e0bile" },
            { "Java", metaValue_jv },
            { "st", "sotho meridionale" },
            { "su", metaValue_su },
            { "%%NEDIS", "dialetu de Natisone" },
            { "sv", "isvedesu" },
            { "sw", "swahili" },
            { "type.nu.wcho", "tzifras wancho" },
            { "type.nu.hantfin", "n\u00f9meros finantzi\u00e0rios in tzinesu traditzionale" },
            { "ta", metaValue_ta },
            { "142", "\u00c0sia" },
            { "143", "\u00c0sia tzentrale" },
            { "te", metaValue_te },
            { "Toto", "toto" },
            { "145", "\u00c0sia otzidentale" },
            { "tg", "tagicu" },
            { "th", metaValue_th },
            { "%%SPANGLIS", "spanglish" },
            { "ti", "tigrignu" },
            { "en_CA", "inglesu canadesu" },
            { "tk", "turcmenu" },
            { "to", "tonganu" },
            { "dyo", "jola-fonyi" },
            { "type.nu.jpan", "n\u00f9meros giaponesos" },
            { "tr", "turcu" },
            { "Cakm", metaValue_ccp },
            { "tt", "t\u00e0taru" },
            { "%%XSISTEMO", "sistema ortogr\u00e0ficu X de s\u2019esperanto" },
            { "%%BISKE", "dialetu de Santu Giorghi/Bila" },
            { "150", "Europa" },
            { "151", "Europa orientale" },
            { "type.nu.rohg", "tzifras rohingya hanifi" },
            { "type.nu.mathsanb", "tzifras matem\u00e0ticas in grussitu chene gr\u00e0tzias" },
            { "154", "Europa setentrionale" },
            { "155", "Europa otzidentale" },
            { "ug", "uiguru" },
            { "Kore", metaValue_ko },
            { "Ital", "it\u00e0licu antigu" },
            { "kgp", "kaingang" },
            { "Zyyy", "comune" },
            { "uk", "ucrainu" },
            { "type.ca.coptic", "calend\u00e0riu coptu" },
            { "ur", "urdu" },
            { "%%1994", "ortografia resiana istandardizada" },
            { "uz", "uzbecu" },
            { "%%1996", "ortografia tedesca de su 1996" },
            { "nds_NL", "bassu-s\u00e0ssone" },
            { "Sylo", "syloti nagri" },
            { "Wara", "varang kshiti" },
            { "type.ca.roc", "calend\u00e0riu minguo" },
            { "vi", "vietnamita" },
            { "khq", "koyra chiini" },
            { "key.hc", "sistema or\u00e0riu (12 o 24 oras)" },
            { "%%TARASK", "ortografia tara\u0161kievica" },
            { "vo", "volap\u00fck" },
            { "type.nu.mathsans", "tzifras matem\u00e0ticas chene gr\u00e0tzias" },
            { "Osma", "osmanya" },
            { "type.nu.gonm", "tzifras gondi masaram" },
            { "Newa", "newa" },
            { "Cpmn", "tzipro-min\u00f2icu" },
            { "type.nu.gong", "tzifras gondi gunjala" },
            { "Grek", metaValue_el },
            { "Lydi", "l\u00ecdiu" },
            { "Xsux", "cuneiforme sumero-ac\u00e0dicu" },
            { "wo", "wolof" },
            { "zgh", "tamazight istandard marochinu" },
            { "ar_001", "\u00e0rabu modernu istandard" },
            { "Cans", "sillab\u00e0riu abor\u00ecgenu canadesu unificadu" },
            { "%%FONXSAMP", "alfabetu fon\u00e8ticu X-SAMPA" },
            { "Mong", metaValue_mn },
            { "Hluw", "gerogl\u00ecficos anat\u00f2licos" },
            { "mni", "manipuri" },
            { "Latn", metaValue_la },
            { "Nand", "nandinagari" },
            { "type.nu.hans", "n\u00f9meros in tzinesu semplificadu" },
            { "type.nu.hant", "n\u00f9meros in tzinesu traditzionale" },
            { "xh", "xhosa" },
            { "type.nu.romanlow", "n\u00f9meros romanos min\u00f9scolos" },
            { "Dogr", "dogra" },
            { "%%PAMAKA", "dialetu pamaka" },
            { "Lyci", "l\u00ectziu" },
            { "kkj", "kako" },
            { "%%1694ACAD", "primu frantzesu modernu" },
            { "yi", "yiddish" },
            { "Syrc", "sir\u00ecacu" },
            { "Dsrt", "deseret" },
            { "yo", "yoruba" },
            { "es_MX", "ispagnolu messicanu" },
            { "vai", metaValue_vai },
            { "Cari", "carian" },
            { "kln", "kalenjin" },
            { "zh", "tzinesu" },
            { "Bopo", "bopomofo" },
            { "Perm", "p\u00e8rmicu antigu" },
            { "key.lb", "casta de truncadura de l\u00ecnia" },
            { "zu", "zulu" },
            { "type.co.phonebook", "ordinamentu de s\u2019elencu telef\u00f2nicu" },
            { "%%MONOTON", "monot\u00f2nicu" },
            { "Geor", metaValue_ka },
            { "Shrd", "sharada" },
            { "%%LENGADOC", "languedocianu" },
            { "type.nu.jpanfin", "n\u00f9meros finantzi\u00e0rios giaponesos" },
            { "Cham", "cham" },
            { "type.nu.mymrshan", "tzifras shan birmanas" },
            { "Elba", "elbasan" },
            { "Narb", "\u00e0rabu setentrionale antigu" },
            { "type.nu.olck", "tzifras ol chiki" },
            { "type.co.reformed", "ordinamentu riformadu" },
            { "Tglg", "tagalog" },
            { "Yezi", "yezidi" },
            { "%%ITIHASA", "variante \u00e8pica induista" },
            { "Palm", "palmirenu" },
            { "ebu", "embu" },
            { "Egyp", "gerogl\u00ecficos egitzianos" },
            { "zh_Hans", "tzinesu semplificadu" },
            { "Hung", "ungheresu antigu" },
            { "kok", "konkani" },
            { "%%1901", "ortografia traditzionale tedesca" },
            { "%%PAHAWH2", "ortografia reduida pahawh hmong fase 2" },
            { "%%PAHAWH3", "ortografia reduida pahawh hmong fase 3" },
            { "%%PAHAWH4", "ortografia reduida pahawh hmong fase 4" },
            { "type.nu.limb", "tzifras limbu" },
            { "zh_Hant", "tzinesu traditzionale" },
            { "Sund", metaValue_su },
            { "%%GRCLASS", "ortografia otzitana cl\u00e0ssica" },
            { "type.nu.khmr", "tzifras khmer" },
            { "Tirh", "tirhuta" },
            { "%%VALENCIA", "valentzianu" },
            { "Cprt", "tzipriotu" },
            { "Diak", "dives akuru" },
            { "%%BAKU1926", "alfabetu latinu turcu unificadu" },
            { "%%IJEKAVSK", "serbu cun pron\u00f9ntzia ijekaviana" },
            { "mua", "mundang" },
            { "type.nu.guru", "tzifras gurmukhi" },
            { "%%BORNHOLM", "bornholmesu" },
            { "mul", "limbas m\u00f9ltiplas" },
            { "%%PUTER", "puter" },
            { "key.ms", "sistema de medida" },
            { "Glag", "glagol\u00ecticu" },
            { "%%KKCOR", "ortografia comuna" },
            { "Cher", metaValue_chr },
            { "type.nu.tamldec", "tzifras tamil" },
            { "fa_AF", "dari" },
            { "%%OXENDICT", "ortografia inglesa de su ditzion\u00e0riu de Oxford" },
            { "key.nu", "n\u00f9meros" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
