/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mt extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ar = "G\u0127arbi";
        final String metaValue_el = "Grieg";
        final String metaValue_la = "Latin";
        final String metaValue_peo = "Persjan Antik";
        final String metaValue_Hant = "Tradizzjonali";
        final Object[][] data = new Object[][] {
            { "ksh", "Kolonjan" },
            { "mwl", "Mirandi\u017c" },
            { "cch", "Atsam" },
            { "mwr", "Marwari" },
            { "egy", "E\u0121izzjan (Antik)" },
            { "raj", "Ra\u0121astani" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "rap", "Rapanwi" },
            { "ter", "Tereno" },
            { "AC", "Ascension Island" },
            { "rar", "Rarotongani" },
            { "tet", "Tetum" },
            { "AD", "Andorra" },
            { "AE", "l-Emirati G\u0127arab Mag\u0127quda" },
            { "nl_BE", "Fjamming" },
            { "AF", "l-Afganistan" },
            { "AG", "Antigua u Barbuda" },
            { "type.ca.ethiopic", "Kalendarju Etjopiku" },
            { "AI", "Anguilla" },
            { "AL", "l-Albanija" },
            { "AM", "l-Armenja" },
            { "AO", "l-Angola" },
            { "AQ", "l-Antartika" },
            { "AR", "l-Ar\u0121entina" },
            { "AS", "is-Samoa Amerikana" },
            { "AT", "l-Awstrija" },
            { "AU", "l-Awstralja" },
            { "AW", "Aruba" },
            { "en_US", "Ingli\u017c Amerikan" },
            { "AX", "il-G\u017cejjer Aland" },
            { "AZ", "l-A\u017cerbaj\u0121an" },
            { "BA", "il-Bo\u017cnija-\u0126erzegovina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "il-Bangladesh" },
            { "kum", "Kumyk" },
            { "BE", "il-Bel\u0121ju" },
            { "gmh", "\u0120ermani\u017c Medjevali Pulit" },
            { "BF", "il-Burkina Faso" },
            { "BG", "il-Bulgarija" },
            { "BH", "il-Bahrain" },
            { "BI", "il-Burundi" },
            { "BJ", "il-Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "Kutenaj" },
            { "myv", "Erzya" },
            { "BN", "il-Brunei" },
            { "BO", "il-Bolivja" },
            { "BQ", "in-Netherlands tal-Karibew" },
            { "BR", "Il-Bra\u017cil" },
            { "BS", "il-Bahamas" },
            { "xog", "Soga" },
            { "BT", "il-Bhutan" },
            { "BV", "G\u017cira Bouvet" },
            { "BW", "il-Botswana" },
            { "BY", "il-Belarussja" },
            { "BZ", "il-Belize" },
            { "CA", "il-Kanada" },
            { "CC", "G\u017cejjer Cocos (Keeling)" },
            { "mzn", "Mazanderani" },
            { "CD", "ir-Repubblika Demokratika tal-Kongo" },
            { "CF", "ir-Repubblika \u010aentru-Afrikana" },
            { "CG", "il-Kongo - Brazzaville" },
            { "CH", "l-I\u017cvizzera" },
            { "CI", "il-Kosta tal-Avorju" },
            { "CK", "G\u017cejjer Cook" },
            { "CL", "i\u010b-\u010aili" },
            { "CM", "il-Kamerun" },
            { "CN", "i\u010b-\u010aina" },
            { "CO", "il-Kolombja" },
            { "CP", "il-G\u017cira Clipperton" },
            { "CR", "il-Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Cape Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "il-G\u017cira Christmas" },
            { "CY", "\u010aipru" },
            { "CZ", "ir-Repubblika \u010aeka" },
            { "eka", "Ekajuk" },
            { "DE", "il-\u0120ermanja" },
            { "goh", "\u0120ermani\u017c Antik, Pulit" },
            { "ace", "A\u010bini\u017c" },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "DJ", "il-Djibouti" },
            { "DK", "id-Danimarka" },
            { "ach", "Akoli" },
            { "gon", "Gondi" },
            { "DM", "Dominica" },
            { "DO", "ir-Repubblika Dominicana" },
            { "gor", "Gorontalo" },
            { "got", "Gotiku" },
            { "zun", "Zuni" },
            { "tig", "Tigre" },
            { "DZ", "l-Al\u0121erija" },
            { "pag", "Pangasinjan" },
            { "pal", "Pahlavi" },
            { "EA", "Ceuta u Melilla" },
            { "chb", "Chibcha" },
            { "pam", "Pampanga" },
            { "EC", "l-Ekwador" },
            { "pap", "Papiamento" },
            { "ada", "Adangme" },
            { "EE", "l-Estonja" },
            { "tiv", "Tiv" },
            { "EG", "l-E\u0121ittu" },
            { "EH", "is-Sa\u0127ara tal-Punent" },
            { "chg", "Chagatai" },
            { "pau", "Palawjan" },
            { "chk", "\u010auki\u017c" },
            { "chn", "Chinook Jargon" },
            { "chm", "Mari" },
            { "chp", "\u010aipewjan" },
            { "cho", "Choctaw" },
            { "chr", "Cherokee" },
            { "ER", "l-Eritrea" },
            { "ES", "Spanja" },
            { "ET", "l-Etjopja" },
            { "EU", "Unjoni Ewropea" },
            { "elx", "Elamit" },
            { "type.ca.gregorian", "Kalendarju Gregorjan" },
            { "chy", "Cheyenne" },
            { "ady", "Adyghe" },
            { "FI", "il-Finlandja" },
            { "FJ", "Fi\u0121i" },
            { "FK", "il-G\u017cejjer Falkland" },
            { "FM", "il-Mikrone\u017cja" },
            { "FO", "il-G\u017cejjer Faeroe" },
            { "FR", "Franza" },
            { "tkl", "Tokelau" },
            { "grb", "Grebo" },
            { "grc", "Grieg, Antik" },
            { "GA", "il-Gabon" },
            { "vot", "Votik" },
            { "GB", "ir-Renju Unit" },
            { "pcm", "Pidgin Ni\u0121erjan" },
            { "GD", "Grenada" },
            { "GE", "il-Georgia" },
            { "GF", "il-Guyana Fran\u010bi\u017ca" },
            { "GG", "Guernsey" },
            { "GH", "il-Ghana" },
            { "GI", "\u0120ibilt\u00e0" },
            { "afh", "Afri\u0127ili" },
            { "GL", "Greenland" },
            { "enm", "Ingli\u017c Medjevali" },
            { "GM", "il-Gambja" },
            { "GN", "il-Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "il-Guinea Ekwatorjali" },
            { "GR", "il-Gre\u010bja" },
            { "GS", "il-Georgia tan-Nofsinhar u l-G\u017cejjer Sandwich tan-Nofsinhar" },
            { "GT", "il-Gwatemala" },
            { "GU", "Guam" },
            { "GW", "il-Guinea-Bissau" },
            { "tli", "Tlingit" },
            { "tlh", "Klingon" },
            { "GY", "il-Guyana" },
            { "ckb", "Kurd \u010aentrali" },
            { "zxx", "Bla kontenut lingwistiku" },
            { "de_AT", "\u0120ermani\u017c Awstrijak" },
            { "HK", "ir-Re\u0121jun Amministrattiv Spe\u010bjali ta\u2019 Hong Kong tar-Repubblika tal-Poplu ta\u010b-\u010aina" },
            { "HM", "il-G\u017cejjer Heard u l-G\u017cejjer McDonald" },
            { "HN", "il-Honduras" },
            { "HR", "il-Kroazja" },
            { "agq", "Aghem" },
            { "gsw", "\u0120ermani\u017c tal-I\u017cvizzera" },
            { "HT", "il-Haiti" },
            { "HU", "l-Ungerija" },
            { "tmh", "Tamashek" },
            { "IC", "il-G\u017cejjer Canary" },
            { "peo", metaValue_peo },
            { "ID", "l-Indone\u017cja" },
            { "IE", "l-Irlanda" },
            { "nap", "Naplitan" },
            { "naq", "Nama" },
            { "zza", "Zaza" },
            { "IL", "I\u017crael" },
            { "IM", "Isle of Man" },
            { "IN", "l-Indja" },
            { "IO", "Territorju Brittaniku tal-O\u010bean Indjan" },
            { "IQ", "l-Iraq" },
            { "IR", "l-Iran" },
            { "IS", "l-I\u017clanda" },
            { "IT", "l-Italja" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Kalendarju I\u017clamiku" },
            { "JM", "il-\u0120amajka" },
            { "JO", "il-\u0120ordan" },
            { "JP", "il-\u0120appun" },
            { "ain", "Ajnu" },
            { "guz", "Gusii" },
            { "tog", "Nyasa Tonga" },
            { "de_CH", "\u0120ermani\u017c \u017bvizzeru" },
            { "type.ca.buddhist", "Kalendarju Buddist" },
            { "KE", "il-Kenja" },
            { "419", "Amerika Latina" },
            { "KG", "il-Kirgi\u017cistan" },
            { "KH", "il-Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "KN", "Saint Kitts u Nevis" },
            { "fr_CA", "Fran\u010bi\u017c Kanadi\u017c" },
            { "KP", "il-Korea ta\u2019 Fuq" },
            { "KR", "il-Korea t\u2019Isfel" },
            { "fr_CH", "Fran\u010bi\u017c \u017bvizzeru" },
            { "KW", "il-Kuwajt" },
            { "tpi", "Tok Pisin" },
            { "KY", "il-G\u017cejjer Cayman" },
            { "KZ", "il-Ka\u017cakistan" },
            { "Cyrl", "\u010airilliku" },
            { "LA", "il-Laos" },
            { "LB", "il-Libanu" },
            { "LC", "Saint Lucia" },
            { "phn", "Feni\u010bju" },
            { "gwi", "Gwi\u010bin" },
            { "nds", "\u0120ermani\u017c Komuni" },
            { "LI", "il-Liechtenstein" },
            { "LK", "is-Sri Lanka" },
            { "akk", "Akkadjen" },
            { "cop", "Koptiku" },
            { "LR", "il-Liberja" },
            { "LS", "il-Lesoto" },
            { "LT", "il-Litwanja" },
            { "LU", "il-Lussemburgu" },
            { "LV", "il-Latvja" },
            { "LY", "il-Libja" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "lah", "Lahnda" },
            { "lag", "Langi" },
            { "MA", "il-Marokk" },
            { "MC", "Monaco" },
            { "MD", "il-Moldova" },
            { "ME", "il-Montenegro" },
            { "MF", "Saint Martin" },
            { "lam", "Lamba" },
            { "MG", "Madagascar" },
            { "MH", "G\u017cejjer Marshall" },
            { "ale", "Aleut" },
            { "MK", "il-Ma\u010bedonja ta\u2019 Fuq" },
            { "ML", "il-Mali" },
            { "MM", "il-Myanmar/Burma" },
            { "MN", "il-Mongolja" },
            { "new", "Newari" },
            { "MO", "ir-Re\u0121jun Amministrattiv Spe\u010bjali tal-Macao tar-Repubblika tal-Poplu ta\u010b-\u010aina" },
            { "MP", "\u0120\u017cejjer Mariana tat-Tramuntana" },
            { "MQ", "Martinique" },
            { "MR", "il-Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "alt", "Altai tan-Nofsinhar" },
            { "MV", "il-Maldivi" },
            { "MW", "il-Malawi" },
            { "MX", "il-Messiku" },
            { "type.ca.japanese", "Kalendarju \u0120appuni\u017c" },
            { "MY", "il-Malasja" },
            { "MZ", "il-Mozambique" },
            { "NA", "in-Namibja" },
            { "type.ca.hebrew", "Kalendarju Ebrajk" },
            { "NC", "New Caledonia" },
            { "NE", "in-Ni\u0121er" },
            { "NF", "G\u017cira Norfolk" },
            { "NG", "in-Ni\u0121erja" },
            { "trv", "Taroko" },
            { "NI", "in-Nikaragwa" },
            { "NL", "in-Netherlands" },
            { "NO", "in-Norve\u0121ja" },
            { "NP", "in-Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "tsi", "Tsimshian" },
            { "NZ", "New Zealand" },
            { "rom", "Romanesk" },
            { "crh", "Tork tal-Krimea" },
            { "ang", "Ingli\u017c Antik" },
            { "OM", "l-Oman" },
            { "anp", "Angika" },
            { "crs", "Fran\u010bi\u017c tas-Seselwa Creole" },
            { "Xpeo", metaValue_peo },
            { "PA", "il-Panama" },
            { "type.ca.islamic-civil", "Kalendarju Islamiku-\u010aivili" },
            { "csb", "Kashubian" },
            { "en_GB", "Ingli\u017c Brittaniku" },
            { "PE", "il-Per\u00f9" },
            { "PF", "Poline\u017cja Fran\u010bi\u017ca" },
            { "PG", "Papua New Guinea" },
            { "PH", "il-Filippini" },
            { "PK", "il-Pakistan" },
            { "PL", "il-Polonja" },
            { "ewo", "Ewondo" },
            { "PM", "Saint Pierre u Miquelon" },
            { "PN", "G\u017cejjer Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "it-Territorji Palestinjani" },
            { "PT", "il-Portugall" },
            { "PW", "Palau" },
            { "nia", "Nijas" },
            { "PY", "il-Paragwaj" },
            { "tum", "Tumbuka" },
            { "QA", "il-Qatar" },
            { "niu", "Niuean" },
            { "lez", "Le\u017cgjan" },
            { "tvl", metaValue_TV },
            { "001", "Dinja" },
            { "002", "Affrika" },
            { "RE", "R\u00e9union" },
            { "005", "Amerika t\u2019Isfel" },
            { "jbo", "Lojban" },
            { "009", "O\u010bejanja" },
            { "RO", "ir-Rumanija" },
            { "RS", "is-Serbja" },
            { "RU", "ir-Russja" },
            { "RW", "ir-Rwanda" },
            { "SA", "l-Arabja Sawdija" },
            { "pon", "Ponpejan" },
            { "SB", "il-G\u017cejjer Solomon" },
            { "twq", "Tasawaq" },
            { "011", "Affrika tal-Punent" },
            { "SC", "is-Seychelles" },
            { "SD", "is-Sudan" },
            { "013", "Amerika \u010aentrali" },
            { "SE", "l-I\u017cvezja" },
            { "014", "Affrika tal-Lvant" },
            { "arc", "Aramajk" },
            { "015", "Affrika ta\u2019 Fuq" },
            { "SG", "Singapore" },
            { "SH", "Saint Helena" },
            { "017", "Affrika Nofsani" },
            { "SI", "is-Slovenja" },
            { "018", "Affrika t\u2019Isfel" },
            { "SJ", "Svalbard u Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "is-Slovakkja" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "is-Senegal" },
            { "SO", "is-Somalja" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "SR", "is-Suriname" },
            { "SS", "is-Sudan t\u2019Isfel" },
            { "ST", "S\u00e3o Tom\u00e9 u Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "is-Sirja" },
            { "yao", "Yao" },
            { "SZ", "l-Eswatini" },
            { "arw", "Arawak" },
            { "yap", "Yapese" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "TC", "il-G\u017cejjer Turks u Caicos" },
            { "yav", "Yangben" },
            { "TD", "i\u010b-Chad" },
            { "TF", "It-Territorji Fran\u010bi\u017ci tan-Nofsinhar" },
            { "TG", "it-Togo" },
            { "TH", "it-Tajlandja" },
            { "TJ", "it-Ta\u0121ikistan" },
            { "029", "Karibew" },
            { "TK", "it-Tokelau" },
            { "TL", "Timor Leste" },
            { "ybb", "Yemba" },
            { "TM", "it-Turkmenistan" },
            { "TN", "it-Tune\u017cija" },
            { "TO", "Tonga" },
            { "TR", "it-Turkija" },
            { "TT", "Trinidad u Tobago" },
            { "TV", metaValue_TV },
            { "TW", "it-Tajwan" },
            { "ast", "Asturian" },
            { "TZ", "it-Tanzanija" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Kitba Mhux Mag\u0127rufa" },
            { "UA", "l-Ukrajna" },
            { "rup", "Aromanjan" },
            { "030", "Asja tal-Lvant" },
            { "tyv", "Tuvinjan" },
            { "sw_CD", "Swahili tar-Repubblika Demokratika tal-Kongo" },
            { "034", "Asja t\u2019Isfel \u010aentrali" },
            { "hai", "Haida" },
            { "035", "Asja tax-Xlokk" },
            { "UG", "l-Uganda" },
            { "type.co.pinyin", "Ordni tal-Pinjin" },
            { "039", "Ewropa t\u2019Isfel" },
            { "UM", "Il-G\u017cejjer Minuri Mbieg\u0127da tal-Istati Uniti" },
            { "US", "l-Istati Uniti" },
            { "haw", "\u0126awajjan" },
            { "type.co.gb2312han", "Ordni \u010aini\u017c Sempli\u010bi (GB2312)" },
            { "UY", "l-Urugwaj" },
            { "prg", "Prussu" },
            { "UZ", "l-U\u017cbekistan" },
            { "tzm", "Tamazight tal-Atlas \u010aentrali" },
            { "type.co.stroke", "Ordni Ma\u0127\u017cu\u017ca" },
            { "nnh", "Ngiemboon" },
            { "VA", "l-Istat tal-Belt tal-Vatikan" },
            { "pro", "Provenzal Antik" },
            { "VC", "Saint Vincent u l-Grenadini" },
            { "VE", "il-Venezwela" },
            { "VG", "il-G\u017cejjer Ver\u0121ni Brittani\u010bi" },
            { "VI", "il-G\u017cejjer Ver\u0121ni tal-Istati Uniti" },
            { "VN", "il-Vjetnam" },
            { "VU", "Vanuatu" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "non", "Nors Antik" },
            { "053", "Awstralja u New Zealand" },
            { "054", "Melanesja" },
            { "WF", "Wallis u Futuna" },
            { "type.co.traditional", metaValue_Hant },
            { "057", "Re\u0121jun ta\u2019 Mikrone\u017cja" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "wae", "Walser" },
            { "WS", "Samoa" },
            { "wal", "Walamo" },
            { "was", "Washo" },
            { "war", "Waray" },
            { "awa", "Awadhi" },
            { "061", "Polinesja" },
            { "XK", "il-Kosovo" },
            { "Zxxx", "Mhux Miktub" },
            { "YE", "il-Jemen" },
            { "nqo", "N\u2019Ko" },
            { "type.co.standard", "Ordni Standard" },
            { "fan", "Fang" },
            { "fat", "Fanti" },
            { "YT", "Mayotte" },
            { "ZA", "l-Afrika t\u2019Isfel" },
            { "ZM", "i\u017c-\u017bambja" },
            { "ZW", "i\u017c-\u017bimbabwe" },
            { "ZZ", "Re\u0121jun Mhux Mag\u0127ruf" },
            { "type.ca.iso8601", "Kalendarju ISO-8601" },
            { "lol", "Mongo" },
            { "nso", "Soto tat-Tramuntana" },
            { "loz", "Lo\u017ci" },
            { "jmc", "Machame" },
            { "hil", "Hiligaynon" },
            { "nus", "Nuer" },
            { "dak", "Dakota" },
            { "hit", "Hittite" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "lrc", "Luri tat-Tramuntana" },
            { "nwc", "Newari Klassiku" },
            { "udm", "Udmurt" },
            { "sad", "Sandawe" },
            { "sah", "Sakha" },
            { "sam", "Samaritan Aramajk" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "jpr", "Lhudi-Persjan" },
            { "sba", "Ngambay" },
            { "lua", "Luba-Luluwa" },
            { "sbp", "Sangu" },
            { "lui", "Luiseno" },
            { "nyn", "Nyankole" },
            { "nym", "Njamwe\u017ci" },
            { "lun", "Lunda" },
            { "nyo", "Nyoro" },
            { "luo", "Luo" },
            { "fil", "Filippin" },
            { "hmn", "Hmong" },
            { "del", "Delawerjan" },
            { "lus", "Mizo" },
            { "bal", "Balu\u010bi" },
            { "den", "Slav" },
            { "ban", "Balini\u017c" },
            { "uga", "Ugaritiku" },
            { "luy", "Luyia" },
            { "bas", "Basa" },
            { "jrb", "Lhudi-G\u0127arbi" },
            { "es_ES", "Spanjol Ewropew" },
            { "nzi", "Nzima" },
            { "sco", "Sko\u010b\u010bi\u017c" },
            { "scn", "Sqalli" },
            { "aa", "Afar" },
            { "ab", "Abka\u017cjan" },
            { "ae", "Avestan" },
            { "af", "Afrikans" },
            { "ak", "Akan" },
            { "am", "Amhariku" },
            { "Arab", metaValue_ar },
            { "an", "Aragoni\u017c" },
            { "ar", metaValue_ar },
            { "as", "Assami\u017c" },
            { "av", "Avarik" },
            { "ay", "Aymara" },
            { "az", "A\u017cerbaj\u0121ani" },
            { "ba", "Bashkir" },
            { "be", "Belarussu" },
            { "bg", "Bulgaru" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bengali" },
            { "bo", "Tibetjan" },
            { "dgr", "Dogrib" },
            { "br", "Breton" },
            { "bs", "Bo\u017cnijaku" },
            { "seh", "Sena" },
            { "sel", "Selkup" },
            { "ca", "Katalan" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "%%REVISED", "Ortografija Irriveda" },
            { "co", "Korsiku" },
            { "cr", "Cree" },
            { "cs", "\u010aek" },
            { "cu", "Slaviku tal-Knisja" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "da", "Dani\u017c" },
            { "pt_PT", "Portugi\u017c Ewropew" },
            { "de", "\u0120ermani\u017c" },
            { "bej", "Beja" },
            { "din", "Dinka" },
            { "bem", "Bemba" },
            { "sga", "Irlandi\u017c Antik" },
            { "dv", "Divehi" },
            { "es_419", "Spanjol Latin Amerikan" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Kalendarju \u010aini\u017c" },
            { "dje", "Zarma" },
            { "ee", "Ewe" },
            { "ro_MD", "Moldovan" },
            { "el", metaValue_el },
            { "en", "Ingli\u017c" },
            { "eo", "Esperanto" },
            { "type.co.big5han", "Ordni \u010aini\u017c Tradizzjonali (Big5)" },
            { "es", "Spanjol" },
            { "et", "Estonjan" },
            { "eu", "Bask" },
            { "shi", "Tachelhit" },
            { "hsb", "Sorbjan ta\u2019 Fuq" },
            { "shn", "Shan" },
            { "fa", "Persjan" },
            { "Hans", "Simplifikat" },
            { "type.nu.latn", "Numri tal-Punent" },
            { "Hant", metaValue_Hant },
            { "ff", "Fulah" },
            { "fi", "Finlandi\u017c" },
            { "fj", "Fi\u0121jan" },
            { "fon", "Fon" },
            { "yue", "Kantoni\u017c" },
            { "fo", "Faroese" },
            { "umb", "Umbundu" },
            { "fr", "Fran\u010bi\u017c" },
            { "sid", "Sidamo" },
            { "fy", "Frisian tal-Punent" },
            { "ga", "Irlandi\u017c" },
            { "gd", "Galliku Sko\u010b\u010bi\u017c" },
            { "gl", "Gali\u010bjan" },
            { "gn", "Guarani" },
            { "bho", "Bhojpuri" },
            { "und", "Lingwa Mhix Mag\u0127rufa" },
            { "gu", "Gujarati" },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", "Ebrajk" },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "ho", "Hiri Motu" },
            { "hr", "Kroat" },
            { "ht", "Creole ta\u2019 Haiti" },
            { "hu", "Ungeri\u017c" },
            { "hy", "Armen" },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indone\u017cjan" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "frm", "Fran\u010bi\u017c Medjevali" },
            { "ik", "Inupjak" },
            { "fro", "Fran\u010bi\u017c Antik" },
            { "io", "Ido" },
            { "is", "I\u017clandi\u017c" },
            { "it", "Taljan" },
            { "iu", "Inuktitut" },
            { "ja", "\u0120appuni\u017c" },
            { "doi", "Dogri" },
            { "sma", "Sami tan-Nofsinhar" },
            { "jv", "\u0120avani\u017c" },
            { "mad", "Maduri\u017c" },
            { "smj", "Lule Sami" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "smn", "Inari Sami" },
            { "ka", "\u0120or\u0121jan" },
            { "bla", "Siksika" },
            { "mak", "Makasar" },
            { "sms", "Skolt Sami" },
            { "man", "Mandingo" },
            { "kg", "Kongo" },
            { "ki", "Kikuju" },
            { "mas", "Masai" },
            { "kj", "Kuanyama" },
            { "kk", "Ka\u017cak" },
            { "kl", "Kalallisut" },
            { "km", "Khmer" },
            { "kn", "Kannada" },
            { "ko", "Korean" },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "ku", "Kurd" },
            { "kv", "Komi" },
            { "kw", "Korniku" },
            { "ky", "Kirgi\u017c" },
            { "snk", "Soninke" },
            { "la", metaValue_la },
            { "lb", "Lussemburgi\u017c" },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "ln", "Lingaljan" },
            { "fur", "Frijuljan" },
            { "lo", "Laosjan" },
            { "lt", "Litwan" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latvjan" },
            { "sog", "Sogdien" },
            { "mg", "Malagasy" },
            { "mh", "Marshalljani\u017c" },
            { "mi", "Maori" },
            { "mk", "Ma\u010bedonjan" },
            { "ml", "Malayalam" },
            { "mn", "Mongoljan" },
            { "mr", "Marathi" },
            { "ms", "Malay" },
            { "mt", "Malti" },
            { "my", "Burmi\u017c" },
            { "mdf", "Moksha" },
            { "dsb", "Sorbjan Komuni" },
            { "na", "Naurujan" },
            { "nb", "Bokmal Norve\u0121i\u017c" },
            { "nd", "Ndebeli tat-Tramuntana" },
            { "ne", "Nepali\u017c" },
            { "ng", "Ndonga" },
            { "mdr", "Mandar" },
            { "nl", "Olandi\u017c" },
            { "nn", "Ninorsk Norve\u0121i\u017c" },
            { "no", "Norve\u0121i\u017c" },
            { "nr", "Ndebele tan-Nofsinhar" },
            { "nv", "Navajo" },
            { "kaa", "Kara-Kalpak" },
            { "ny", "Nyanja" },
            { "kac", "Kachin" },
            { "kab", "Kabuljan" },
            { "oc", "O\u010b\u010bitan" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", "Mende" },
            { "oj", "O\u0121ibwa" },
            { "mer", "Meru" },
            { "om", "Oromo" },
            { "kaw", "Kawi" },
            { "or", "Odia" },
            { "os", "Ossettiku" },
            { "kbd", "Kabardian" },
            { "mfe", "Morisyen" },
            { "srn", "Sranan Tongo" },
            { "pa", "Punjabi" },
            { "dua", "Dwala" },
            { "srr", "Serer" },
            { "pi", "Pali" },
            { "pl", "Pollakk" },
            { "dum", "Olandi\u017c Medjevali" },
            { "type.ca.dangi", "Kalendarju Dangi" },
            { "ps", "Pashto" },
            { "pt", "Portugi\u017c" },
            { "mga", "Irlandi\u017c Medjevali" },
            { "key.co", "Kollazjoni" },
            { "pt_BR", "Portugi\u017c tal-Bra\u017cil" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "bra", "Braj" },
            { "key.ca", "Kalendarju" },
            { "mgo", "Met\u00e0" },
            { "ssy", "Saho" },
            { "qu", "Quechua" },
            { "zap", "Zapotec" },
            { "brx", "Bodo" },
            { "kde", "Makonde" },
            { "rm", "Romanz" },
            { "rn", "Rundi" },
            { "key.cu", "Munita" },
            { "ro", "Rumen" },
            { "ru", "Russu" },
            { "rw", "Kinjarwanda" },
            { "kea", "Cape Verdjan" },
            { "mic", "Micmac" },
            { "suk", "Sukuma" },
            { "en_AU", "Ingli\u017c Awstraljan" },
            { "sa", "Sanskrit" },
            { "sc", "Sardinjan" },
            { "sus", "Susu" },
            { "sd", "Sindhi" },
            { "se", "Sami tat-Tramuntana" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "Serbo-Kroat" },
            { "si", "Sinhala" },
            { "sux", "Sumerjan" },
            { "sk", "Slovakk" },
            { "sl", "Sloven" },
            { "sm", "Samoan" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "sq", "Albani\u017c" },
            { "sr", "Serb" },
            { "ss", "Swati" },
            { "st", "Soto tan-Nofsinhar" },
            { "su", "Sundani\u017c" },
            { "sv", "\u017bvedi\u017c" },
            { "sw", "Swahili" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "ta", "Tamil" },
            { "142", "Asja" },
            { "bua", "Burjat" },
            { "143", "Asja \u010aentrali" },
            { "te", "Telugu" },
            { "145", "Asja tal-Punent" },
            { "tg", "Ta\u0121ik" },
            { "th", "Tajlandi\u017c" },
            { "ti", "Tigrinya" },
            { "bug", "Buginese" },
            { "kfo", "Koro" },
            { "en_CA", "Ingli\u017c Kanadi\u017c" },
            { "tk", "Turkmeni" },
            { "tl", "Tagalog" },
            { "tn", "Tswana" },
            { "to", "Tongan" },
            { "dyo", "Jola-Fonyi" },
            { "tr", "Tork" },
            { "ts", "Tsonga" },
            { "swb", "Komorjan" },
            { "tt", "Tatar" },
            { "dyu", "Dyula" },
            { "tw", "Twi" },
            { "ty", "Ta\u0127itjan" },
            { "150", "Ewropa" },
            { "151", "Ewropa tal-Lvant" },
            { "154", "Ewropa ta\u2019 Fuq" },
            { "dzg", "Dazaga" },
            { "155", "Ewropa tal-Punent" },
            { "ug", "Uyghur" },
            { "Zyyy", "Komuni" },
            { "uk", "Ukren" },
            { "ur", "Urdu" },
            { "xal", "Kalmyk" },
            { "zen", "Zenaga" },
            { "uz", "Uzbek" },
            { "kha", "Khasi" },
            { "nds_NL", "Sassonu Komuni" },
            { "ve", "Venda" },
            { "vi", "Vjetnami\u017c" },
            { "kho", "Kotani\u017c" },
            { "khq", "Koyra Chiini" },
            { "vo", "Volapuk" },
            { "quc", "K\u2019iche\u2019" },
            { "gaa", "Ga" },
            { "wa", "Walloon" },
            { "syr", "Sirjan" },
            { "Grek", metaValue_el },
            { "wo", "Wolof" },
            { "zgh", "Tamazight Standard tal-Marokk" },
            { "ar_001", "G\u0127arbi Standard Modern" },
            { "gay", "Gayo" },
            { "mnc", "Manchu" },
            { "gba", "Gbaya" },
            { "mni", "Manipuri" },
            { "Latn", metaValue_la },
            { "xh", "Xhosa" },
            { "byn", "Blin" },
            { "osa", "Osa\u0121jan" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "yi", "Yiddish" },
            { "mos", "Mossi" },
            { "yo", "Yoruba" },
            { "es_MX", "Spanjol tal-Messiku" },
            { "ota", "Tork Ottoman" },
            { "vai", "Vai" },
            { "za", "Zhuang" },
            { "kln", "Kalenjin" },
            { "zh", "\u010aini\u017c" },
            { "zu", "Zulu" },
            { "type.co.phonebook", "Ordni Telefonika" },
            { "kmb", "Kimbundu" },
            { "gez", "Geez" },
            { "ebu", "Embu" },
            { "zh_Hans", "\u010aini\u017c Simplifikat" },
            { "kok", "Konkani" },
            { "kos", "Kosrejan" },
            { "zh_Hant", "\u010aini\u017c Tradizzjonali" },
            { "kpe", "Kpelle" },
            { "ilo", "Iloko" },
            { "mua", "Mundang" },
            { "mul", "Lingwi Diversi" },
            { "cad", "Kaddo" },
            { "mus", "Kriek" },
            { "gil", "Gilbertjan" },
            { "car", "Karib" },
            { "krc", "Karachay-Balkar" },
            { "inh", "Ingush" },
            { "krl", "Kareljan" },
            { "efi", "Efik" },
            { "kru", "Kurux" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
