/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kgp extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arame";
        final String metaValue_bn = "megari";
        final String metaValue_bo = "timet\u1ef9n\u0169";
        final String metaValue_el = "gregu";
        final String metaValue_jv = "javan\u1ebdj";
        final String metaValue_km = "kym\u1ebdr";
        final String metaValue_ko = "korej\u1ef9n\u0169";
        final String metaValue_la = "rat\u0129nh";
        final String metaValue_mn = "m\u00e3g\u00f3r";
        final String metaValue_my = "mirm\u1ef9n\u1ebdj";
        final String metaValue_or = "orija";
        final String metaValue_th = "tajr\u1ef9nej";
        final String metaValue_ban = "marin\u1ebdj";
        final String metaValue_bax = "mam\u0169m";
        final String metaValue_chr = "seroki";
        final String metaValue_got = "g\u00f3tiko";
        final String metaValue_nqo = "nyko";
        final String metaValue_phn = "fen\u0129so";
        final String metaValue_ssy = "saho";
        final String metaValue_vai = "vaj";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00e1rysi" },
            { "Ogam", "og\u1ef9miku" },
            { "mwl", "m\u0129r\u1ef9nej" },
            { "Zsym", "zsym" },
            { "cch", "ans\u1ef9m" },
            { "mwr", "m\u1ef9rvari" },
            { "Tagb", "tagm\u00e1nva" },
            { "Zsye", "Em\u00e3ji" },
            { "%%NJIVA", "giva/niva v\u0129 p\u1ebd" },
            { "ccp", "sakim\u1ef9" },
            { "egy", "ejimso arkajku" },
            { "raj", "hajanht\u1ef9n\u0129" },
            { "Phag", "fagpa" },
            { "tem", "timn\u1ebd" },
            { "teo", "teso" },
            { "rap", "hapan\u0169j" },
            { "ter", "ter\u1ebdn\u0169" },
            { "AC", "As\u1ebdns\u1ef9v Goj-v\u1ebdso" },
            { "rar", "harot\u00e3gan\u0169" },
            { "tet", "t\u00e9t\u0169m" },
            { "AD", "\u1ef8nora" },
            { "AE", "Em\u0129rano Arame Un\u0129no" },
            { "nl_BE", "fram\u1ebdgo" },
            { "AF", "Afegan\u0129t\u00e3" },
            { "AG", "\u1ef8ntiguva kar Marmuna" },
            { "type.ca.ethiopic", "Etij\u00f3pi Pr\u1ef9g-kur\u00e3-kar" },
            { "AI", "\u1ef8ngira" },
            { "key.tz", "\u00d3ra t\u1ef9\u2019\u0169n" },
            { "AL", "Arm\u00e1n\u0129ja" },
            { "AM", "Arm\u1ebdn\u0129ja" },
            { "Teng", "t\u1ebdgvar" },
            { "AO", "\u1ef8g\u00f3ra" },
            { "AQ", "\u1ef8ntartina" },
            { "AR", "Arj\u1ebdtin\u1ef9" },
            { "Prti", "priti" },
            { "AS", "Sam\u00e3va Am\u1ebdrikyn\u1ef9" },
            { "AT", "Agtirija" },
            { "AU", "Avotyraria" },
            { "AW", "Aruma" },
            { "AX", "Gojga Goj-v\u1ebdso" },
            { "mye", "myene" },
            { "AZ", "Ajermajj\u00e1v" },
            { "%%AREVELA", "arm\u1ebdn\u0129ju r\u00e3jur" },
            { "BA", "M\u00f3sin\u0129ja" },
            { "BB", "Juv\u00e3-m\u00e1g" },
            { "ceb", "semuj\u1ef9n\u0169" },
            { "BD", "M\u00e1gran\u00e9si" },
            { "kum", "kumyg" },
            { "BE", "M\u00e9rjika" },
            { "gmh", "arim\u1ef9v-t\u00e9j kuju" },
            { "BF", "Murkin\u1ef9 Faso" },
            { "BG", "Murgarjia" },
            { "BH", "Mar\u1ebdj" },
            { "BI", "Mur\u0169ni" },
            { "BJ", "Men\u0129nh" },
            { "BL", "S\u1ef9 Martoromeu" },
            { "BM", "Merm\u0169na" },
            { "kut", "kutenaj" },
            { "myv", "\u00e9rsija" },
            { "BN", "Mrun\u1ebdj" },
            { "BO", "Morivija" },
            { "BQ", "Pajisi Rur Karimej\u00e3" },
            { "BR", "Mrasir" },
            { "BS", "Mah\u00e1m\u1ef9" },
            { "xog", "rusoga" },
            { "BT", "Mut\u1ef9v" },
            { "BV", "Muve Goj-v\u1ebdso" },
            { "BW", "Monsuv\u1ef9n\u1ef9" },
            { "BY", "Miero-Husija" },
            { "BZ", "Merije" },
            { "Visp", "v\u0129-ve-h\u00e1" },
            { "type.ca.persian", "P\u00e9rsa Pr\u1ef9g-kur\u00e3-kar" },
            { "type.nu.hebr", "Emrajko r\u00e1 pipir" },
            { "CA", "Kan\u1ef9na" },
            { "CC", "Kokonh Goj-v\u1ebdso (Killing)" },
            { "mzn", "m\u1ef9s\u00e1nar\u1ef9ni" },
            { "CD", "K\u00e3go - K\u0129saja" },
            { "CF", "Afrikan\u1ef9-kuju Repumrika" },
            { "CG", "K\u00e3go Repumrika" },
            { "CH", "Suvisa" },
            { "CI", "J\u00e3n-m\u00e1g-kupri Fyr" },
            { "CK", "Kuki Goj-v\u1ebdso" },
            { "CL", "Sire" },
            { "Kthi", "kanhi" },
            { "CM", "Kam\u1ef9r\u00e3j" },
            { "CN", "S\u0129n\u1ef9" },
            { "CO", "Kor\u00e3mija" },
            { "CP", "Kripert\u00e3n Goj-v\u1ebdso" },
            { "CR", "Konhta Rika" },
            { "CU", "Kuma" },
            { "CV", "Pu T\u00e1nh" },
            { "CW", "Kurasavo" },
            { "CX", "Kr\u0129tim\u1ef9nh Goj-v\u1ebdso" },
            { "CY", "Sipre" },
            { "CZ", "S\u00e9kija" },
            { "eka", "ekajuki" },
            { "DE", "Arem\u1ef9ija" },
            { "goh", "arim\u1ef9v-t\u00e9j arkajku" },
            { "ace", "ags\u1ebdm" },
            { "cgg", "siga" },
            { "DG", "Niego Garsija" },
            { "type.nu.deva", "Nevan\u1ef9gari r\u00e1 pipir" },
            { "DJ", "Nhimuti" },
            { "DK", "Nin\u1ef9m\u1ef9rka" },
            { "ach", "akori" },
            { "gon", "g\u00e3nni" },
            { "Brai", "mrajiri" },
            { "Brah", "mram\u0129" },
            { "DM", "Nom\u0129n\u0129ka" },
            { "type.nu.armnlow", "Arm\u1ebdn\u0129jo r\u00e1 pipir k\u1ebdsir" },
            { "DO", "Repumrika Nom\u0129n\u0129k\u1ef9n\u1ef9" },
            { "gor", "gor\u00e3ntar" },
            { "got", metaValue_got },
            { "Mtei", "m\u1ebdjtej m\u1ef9j\u00e9ki" },
            { "zun", "sunhi" },
            { "tig", "tigr\u00e9" },
            { "DZ", "Arj\u00e9rija" },
            { "pag", "pangasin\u1ef9" },
            { "type.d0.hwidth", "T\u00e3p\u00e9r kuju" },
            { "pal", "paravi" },
            { "EA", "Sevuta kar M\u1ebdrira" },
            { "chb", "simsa" },
            { "pam", "pamp\u1ef9ga" },
            { "EC", "Ekuvanor" },
            { "pap", "papijam\u1ebdto" },
            { "ada", "an\u00e1gme" },
            { "EE", "Enhton\u0129ja" },
            { "tiv", "tivi" },
            { "EG", "Ejito" },
            { "EH", "Sahara R\u00e3pur" },
            { "chg", "sagataj" },
            { "pau", "parav\u1ef9n\u0169" },
            { "chk", "sukese" },
            { "chn", "jarg\u1ef9 sin\u0169ki" },
            { "chm", "m\u1ef9ri" },
            { "chp", "sipevyj\u1ef9" },
            { "cho", "sogtavo" },
            { "chr", metaValue_chr },
            { "ER", "Erytir\u00e9ja" },
            { "ES", "Enhp\u1ef9nija" },
            { "ET", "Eti\u00f3pija" },
            { "EU", "Un\u0129j\u00e1v Orop\u00e9ja" },
            { "elx", "eram\u0129te" },
            { "type.ca.gregorian", "Papa Gregorju Pr\u1ef9g-kur\u00e3-kar" },
            { "EZ", "Evoro Ga" },
            { "chy", "sej\u1ebdn\u1ebd" },
            { "type.nu.gujr", "Guserate r\u00e1 pipir" },
            { "Inds", "\u0129nu" },
            { "ady", "anhige" },
            { "FI", "F\u0129r\u1ef9nija" },
            { "FJ", "Fiji" },
            { "FK", "M\u1ef9rv\u0129n\u1ef9 Goj-v\u1ebdso" },
            { "FM", "Goj-v\u1ebdso-s\u0129 K\u1ebdsir" },
            { "key.va", "v\u1ebdnhm\u1ef9 t\u00e1 n\u0129n\u0129 ke" },
            { "FO", "Far\u00f3ve Goj-v\u1ebdso" },
            { "Taml", "t\u1ef9m\u0129r" },
            { "FR", "Fr\u1ef9sa" },
            { "tkl", "tokerav\u00e1n\u0169" },
            { "grb", "gremo" },
            { "root", "haji" },
            { "type.ca.indian", "\u0128nija Pr\u1ef9g-kur\u00e3-kar p\u1ebd" },
            { "grc", "gregu arkajku" },
            { "GA", "Gab\u00e3" },
            { "vot", "v\u00f3tiko" },
            { "GB", "Rejn\u0169 Un\u0129nu" },
            { "pcm", "ping\u0129n n\u0129jerij\u1ef9n\u0169" },
            { "GD", "Gran\u1ef9na" },
            { "GE", "Ji\u00f3rja" },
            { "GF", "Fr\u1ef9sa Gijan\u1ef9" },
            { "GG", "G\u00e9rnesej" },
            { "GH", "Gan\u1ef9" },
            { "Tale", "taj-re" },
            { "GI", "Gimrar-tar" },
            { "afh", "afrihiri" },
            { "GL", "Gro\u1ebdr\u1ef9nija" },
            { "enm", "\u0129nhgrej kuju" },
            { "GM", "G\u1ef9mija" },
            { "GN", "Gin\u1ebd" },
            { "GP", "Guvanarupe" },
            { "GQ", "Gin\u1ebd Ekuvatoriar" },
            { "GR", "Gr\u00e9sa" },
            { "GS", "Ji\u00f3rja-Sur kar S\u1ef9nvisi-Sur Goj-v\u1ebdso Ag" },
            { "GT", "Guvatim\u1ef9ra" },
            { "GU", "Guv\u1ef9m" },
            { "GW", "Gin\u1ebd-Misav" },
            { "tli", "tiringite" },
            { "tlh", "kr\u0129ng\u00e3g" },
            { "Talu", "taj-re t\u00e3g" },
            { "GY", "Gij\u1ef9n\u1ef9" },
            { "ckb", "kurno kuju" },
            { "zxx", "n\u00e9n \u0169 v\u1ebdnhv\u0129 ki t\u0169" },
            { "Vaii", metaValue_vai },
            { "HK", "H\u00e3g K\u00e3g, Sin\u1ef9 ERA" },
            { "HM", "H\u00e1rni kar Magtonarni Goj-v\u1ebdso Ag" },
            { "HN", "H\u00e3nura" },
            { "HR", "Kroasa" },
            { "agq", "agh\u1ebdm" },
            { "gsw", "arim\u1ef9v (Suvisa)" },
            { "type.ca.islamic-umalqura", "Isir\u1ef9 Pr\u1ef9g-kur\u00e3-kar (Umm al-Qura)" },
            { "HT", "Ajti" },
            { "HU", "\u0168grija" },
            { "tmh", "tam\u1ef9s\u00e9ke" },
            { "IC", "Kan\u1ef9rija Goj-v\u1ebdso" },
            { "nan", "m\u0129n n\u1ef9n" },
            { "ID", "\u0128non\u1ebdja" },
            { "peo", "p\u00e9rsa arkajku" },
            { "IE", "Ir\u1ef9na" },
            { "nap", "n\u1ef9porit\u1ef9n\u0169" },
            { "%%NDYUKA", "nyjuka v\u0129 p\u1ebd" },
            { "naq", "n\u1ef9m\u1ef9" },
            { "zza", "sasaki" },
            { "IL", "Isiha\u00e9" },
            { "IM", "M\u1ef9n Goj-v\u1ebdso" },
            { "IN", "\u0128nija" },
            { "type.co.eor", "Or\u00f3pa t\u00e1 v\u1ebdnhvin han to ke" },
            { "IO", "Osi\u1ef9no \u0128niko t\u1ef9 Tehit\u00f3rijo Mrit\u1ef9n\u0129ku" },
            { "IQ", "Iraki" },
            { "IR", "Ir\u1ef9" },
            { "IS", "Inhr\u1ef9nija" },
            { "IT", "Itarija" },
            { "Zmth", "v\u1ebdnhn\u0129kr\u00e9n r\u00e1" },
            { "type.nu.thai", "Tajr\u1ef9nej r\u00e1 pipir" },
            { "%%POSIX", "k\u00e3putanor" },
            { "type.nu.beng", "Meggari r\u00e1 pipir" },
            { "JE", "J\u00e9rsej" },
            { "type.ca.islamic", "Isir\u1ef9 Pr\u1ef9g-kur\u00e3-kar" },
            { "Beng", metaValue_bn },
            { "JM", "Jam\u1ef9jka" },
            { "JO", "Jorn\u00e1n\u0129ja" },
            { "JP", "Jap\u00e3" },
            { "%%1606NICT", "1606 k\u00e3 fr\u1ef9sej si" },
            { "ain", "ajin\u0169" },
            { "guz", "gusij" },
            { "tog", "t\u00e3ngan\u1ebdj Nyjasa t\u00e1" },
            { "type.nu.knda", "Kan\u1ef9r\u1ebdse r\u00e1 pipir" },
            { "Kali", "kaja-ri" },
            { "de_CH", "suvisa arim\u1ef9v-t\u00e9j" },
            { "type.co.phonetic", "Fon\u1ebdtika to ke kupr\u00e3g" },
            { "type.ca.buddhist", "Munisita Pr\u1ef9g-kur\u00e3-kar" },
            { "KE", "Ken\u0129ja" },
            { "419", "Am\u1ebdrika Ratin\u1ef9" },
            { "KG", "Kirginht\u1ef9v" },
            { "KH", "K\u1ef9m\u00f3ja" },
            { "KI", "Kirimati" },
            { "KM", "Kom\u00e3re" },
            { "KN", "S\u1ef9 Krinht\u00f3v\u1ef9v kar N\u1ebdvinh" },
            { "Knda", "kan-n\u1ef9na" },
            { "Zinh", "ernanu" },
            { "KP", "N\u00e3rti-Kor\u00e9ja" },
            { "KR", "Sur-Kor\u00e9ja" },
            { "Plrd", "fon\u1ebdtiko porarne" },
            { "KW", "Kuvajti" },
            { "tpi", "t\u00f3g-pis\u0129n" },
            { "KY", "Kajm\u1ef9m Goj-v\u1ebdso" },
            { "KZ", "Kajakinht\u1ef9v" },
            { "Cyrl", "siririko" },
            { "LA", "Raosi" },
            { "LB", "Riman\u00e3" },
            { "phn", metaValue_phn },
            { "LC", "S\u1ef9ta Rusija" },
            { "Cyrs", "siririko esiravo ekresijatiko" },
            { "gwi", "guvis\u0129n" },
            { "nds", "arim\u1ef9v rur" },
            { "LI", "Rinhsit\u00e9nh-tajin" },
            { "LK", "Siri R\u1ef9nka" },
            { "akk", "akaj\u1ef9n\u0169" },
            { "cop", "komta" },
            { "LR", "Rim\u00e9rija" },
            { "LS", "Resotu" },
            { "Phlv", "pahiravi si" },
            { "LT", "Ritu\u1ef9n\u0129ja" },
            { "LU", "Rus\u1ebdmurgu" },
            { "LV", "Ret\u00e3n\u0129ja" },
            { "Kana", "katak\u1ef9n\u1ef9" },
            { "LY", "Rimija" },
            { "lad", "ranin\u0169" },
            { "vun", "v\u0169jo" },
            { "lah", "rahina" },
            { "lag", "r\u1ef9ngi" },
            { "Thaa", "ta\u2019an\u1ef9" },
            { "MA", "M\u1ef9h\u00f3konh" },
            { "MC", "M\u00e3n\u1ef9ko" },
            { "MD", "M\u00e3rnova" },
            { "ME", "Kr\u0129s\u00e1" },
            { "MF", "S\u1ef9 M\u1ef9rt\u0129j\u0169" },
            { "lam", "r\u1ef9ma" },
            { "MG", "M\u1ef9naganhtar" },
            { "Thai", metaValue_th },
            { "MH", "M\u1ef9rSar Goj-v\u1ebdso" },
            { "ale", "arevute" },
            { "type.nu.vaii", "Vaj n\u0129kr\u00e9n pipir" },
            { "MK", "N\u00e3rti-M\u1ef9senon\u0129ja" },
            { "ML", "M\u1ef9ri" },
            { "MM", "M\u0129j\u1ef9m\u1ef9r" },
            { "MN", "M\u00e3ng\u00f3rija" },
            { "new", "n\u1ebdvari" },
            { "MO", "M\u1ef9kav, S\u0129n\u1ef9 ERA" },
            { "MP", "N\u00e3rti-M\u1ef9rij\u1ef9n\u1ef9 Goj-v\u1ebdso" },
            { "MQ", "M\u1ef9rtin\u0129ka" },
            { "MR", "M\u00e3rit\u1ef9n\u0129ja" },
            { "MS", "M\u00e3tisehati" },
            { "MT", "M\u1ef9rta" },
            { "type.m0.ungegn", "V\u1ebdnhr\u00e1 \u0169 ra t\u0129n UN GEGN" },
            { "MU", "M\u00e3riso" },
            { "alt", "artaj sur" },
            { "MV", "M\u1ef9rniva" },
            { "MW", "M\u1ef9ravi" },
            { "MX", "M\u1ebdsiku" },
            { "type.ca.japanese", "Japon\u1ebdj Pr\u1ef9g-kur\u00e3-kar" },
            { "MY", "M\u1ef9raja" },
            { "MZ", "M\u00e3s\u1ef9miki" },
            { "Phli", "pahir" },
            { "NA", "N\u1ef9m\u0129mija" },
            { "202", "Afrika Sahara-J\u1ebdgu" },
            { "type.ca.hebrew", "Emrajko Pr\u1ef9g-kur\u00e3-kar" },
            { "type.co.dictionary", "V\u1ebdnhr\u00e1 N\u1ef9t\u0129j-f\u1ebd n\u1ef9t\u0129 h\u00e1" },
            { "NC", "Karenon\u0129ja T\u00e3g" },
            { "%%WADEGILE", "Wade-Giles v\u1ebdnhr\u00e1 ratin\u0169 to" },
            { "%%UCRCOR", "v\u1ebdnhr\u00e1 j\u1ebdnf\u0129n t\u1ef9 pir ke" },
            { "NE", "N\u0129jer" },
            { "NF", "N\u00e3rforki Goj-v\u1ebdso" },
            { "NG", "N\u0129j\u00e9rija" },
            { "trv", "taroko" },
            { "Phlp", "pahin" },
            { "NI", "N\u0129karagva" },
            { "Hmng", "pahav hom\u00e3g" },
            { "NL", "Pajisi Rur" },
            { "NO", "N\u00e3rov\u00e9ga" },
            { "NP", "N\u1ebdpar" },
            { "NR", "N\u1ef9uru" },
            { "Phnx", metaValue_phn },
            { "NU", "N\u0129vue" },
            { "rof", "h\u00e3mo" },
            { "tsi", "simsij\u1ef9n\u0169" },
            { "NZ", "Jer\u1ef9nija T\u00e3g" },
            { "Merc", "m\u1ebdrojitiku n\u0129g\u00e9-t\u1ef9" },
            { "%%COLB1945", "Ruso-Mrasirera ki v\u1ebdnhr\u00e1 to 1945 V\u1ebdnhkr\u00e9n ja" },
            { "rom", "hom\u1ef9n\u0129" },
            { "Mero", "m\u1ebdrojitiku" },
            { "crh", "krim\u1ebdja t\u00e1 turko" },
            { "ang", "\u0129nhgrej arkajiku" },
            { "OM", "Om\u1ef9" },
            { "anp", "\u1ef9gika" },
            { "crs", "sejs\u00e9ri krijoro-fr\u1ef9sej" },
            { "Xpeo", "p\u00e9rsa si" },
            { "PA", "Pan\u1ef9m\u1ef9" },
            { "type.ca.islamic-civil", "Isir\u1ef9 Pr\u1ef9g-kur\u00e3-kar Siviv" },
            { "csb", "kasumij\u1ef9" },
            { "PE", "Piru" },
            { "PF", "Fr\u1ef9sa Porin\u1ebdja" },
            { "PG", "Papuva-Gin\u1ebd T\u00e3g" },
            { "PH", "Firipin\u1ef9" },
            { "PK", "Pakinht\u1ef9v" },
            { "PL", "Por\u00e3nija" },
            { "ewo", "ev\u00e3nu" },
            { "PM", "S\u1ef9 Penru kar M\u0129ker\u1ef9v" },
            { "PN", "Pinkajir Goj-v\u1ebdso" },
            { "PR", "Portu Hiku" },
            { "Bali", metaValue_ban },
            { "PS", "Tehit\u00f3rijo Parenhtin\u0169" },
            { "PT", "Portugar" },
            { "PW", "Paravu" },
            { "nia", "n\u0129ja" },
            { "type.nu.greklow", "Grego k\u1ebdsir r\u00e1 pipir" },
            { "PY", "Paraguvaj" },
            { "tum", "t\u0169muka" },
            { "Hebr", "hemraiko" },
            { "QA", "Katar" },
            { "%%SCOTLAND", "\u0129nhgrej Enhk\u00f3sija t\u00e1" },
            { "niu", "nivuvej\u1ef9n\u0169" },
            { "QO", "Osi\u1ef9n\u0129ja Kuvar-gy" },
            { "lez", "resgi" },
            { "%%FONUPA", "Arfam\u00e9to Fon\u1ebdtiku Urariko" },
            { "tvl", "tuvaruv\u1ef9n\u0169" },
            { "Tavt", "tavuti" },
            { "001", "T\u00e3 m\u0129 ke kar" },
            { "002", "Afrika" },
            { "003", "N\u00e3rti-Am\u1ebdrika" },
            { "RE", "Huj\u00e1v" },
            { "005", "Sur-Am\u1ebdrika" },
            { "jbo", "rojm\u00e1n" },
            { "Rjng", "rej\u1ef9g" },
            { "009", "Osean\u0129ja" },
            { "RO", "Hom\u1ebdn\u0129ja" },
            { "RS", "S\u00e9rvija" },
            { "RU", "Husija" },
            { "RW", "Hu\u1ef9na" },
            { "Mani", "m\u1ef9n\u0129kej\u1ef9n\u0169" },
            { "Ugar", "ugaritiku" },
            { "Khar", "karositi" },
            { "SA", "Aramija Savnita" },
            { "pon", "p\u00e3nhpej\u1ef9n\u0169" },
            { "Mand", "m\u1ef9najku" },
            { "SB", "Sarom\u1ef9v Goj-v\u1ebdso" },
            { "twq", "tasavag" },
            { "011", "Afrika R\u00e3pur" },
            { "SC", "Sejserenh" },
            { "SD", "Sun\u00e1" },
            { "013", "Am\u1ebdrika-Kuju" },
            { "SE", "Su\u00e9sa" },
            { "014", "Afrika R\u00e3jur" },
            { "arc", "aramajiko" },
            { "015", "N\u00e3rti-Afrika" },
            { "SG", "S\u0129gapura" },
            { "SH", "S\u1ef9nta Eren\u1ef9" },
            { "type.lb.strict", "V\u1ebdfe mranh han f\u00e3 r\u00e1 ki" },
            { "017", "Afrika-Kuju" },
            { "SI", "Enhroven\u0129ja" },
            { "018", "Afrika M\u1ebdrinhon\u1ef9r" },
            { "SJ", "Inhvarmarni kar Jan M\u1ef9j\u1ebdn" },
            { "Bamu", metaValue_bax },
            { "019", "Am\u1ebdrika ag" },
            { "SK", "Enhrovakija" },
            { "SL", "Kr\u0129 M\u0129gkus\u0169g-fi" },
            { "SM", "S\u1ef9 M\u1ef9r\u0129n\u0169" },
            { "SN", "Sen\u1ebdgar" },
            { "SO", "Som\u1ef9rija" },
            { "arn", "m\u1ef9punug\u0169n" },
            { "arp", "arapaho" },
            { "type.nu.taml", "T\u1ef9m\u0129r p\u1ebd r\u00e1 pipir" },
            { "SR", "Surin\u1ef9m\u0129" },
            { "SS", "Sur-Sun\u00e1v" },
            { "ST", "S\u1ef9 Tom\u1ebd kar Pr\u0129sipi" },
            { "SV", "Er Sarvanor" },
            { "ars", "arame n\u1ebdgene" },
            { "SX", "S\u0129ti M\u1ef9\u2019art\u1ebdn" },
            { "SY", "Sirija" },
            { "yao", "javo" },
            { "SZ", "Esuatin\u0129" },
            { "arw", "aruvaki" },
            { "yap", "japese" },
            { "TA", "Trinht\u1ef9v Nak\u0169ja" },
            { "asa", "asu" },
            { "type.ms.ussystem", "Am\u1ebdrik\u1ef9n\u0169 v\u1ebdnhk\u00e3mur to h\u00e1r" },
            { "021", "Am\u1ebdrika Set\u1ebdntrion\u1ef9r" },
            { "TC", "Turka kar Kajko Goj-v\u1ebdso Ag" },
            { "yav", "j\u1ef9gmen" },
            { "TD", "Sane" },
            { "TF", "Sur Fr\u1ef9sa Tehit\u00f3rijo" },
            { "TG", "Togo" },
            { "TH", "Taj-Ga" },
            { "TJ", "Tanijikinht\u1ef9v" },
            { "029", "Karime" },
            { "TK", "Tokeravu" },
            { "TL", "Tim\u00e3r-R\u00e3jur" },
            { "ybb", "j\u1ebdma" },
            { "type.co.searchjl", "Hangul k\u00e3son\u1ef9te ve j\u00e3nf\u0129n" },
            { "TM", "Turkom\u1ebdn\u0129nht\u1ef9v" },
            { "%%BOONT", "mutr\u0129g - jam\u00e3 v\u0129 p\u1ebd" },
            { "TN", "Tun\u0129ja" },
            { "TO", "T\u00e3ga" },
            { "TR", "Turkija" },
            { "TT", "Tr\u0129nane kar Tomagu" },
            { "TV", "Tuvaru" },
            { "TW", "Tajuv\u1ef9" },
            { "ast", "anhturij\u1ef9n\u0169" },
            { "Orkh", "orkih\u00e3n" },
            { "TZ", "T\u1ef9nj\u1ef9n\u0129ja" },
            { "nmg", "kivasijo" },
            { "Zzzz", "v\u1ebdnhr\u00e1 ki kagt\u0129g" },
            { "UA", "Ukr\u1ef9n\u0129ja" },
            { "rup", "arom\u1ebdn\u0169" },
            { "030", "Ajia R\u00e3jur" },
            { "tyv", "tuvinij\u1ef9n\u0169" },
            { "sw_CD", "suvahiri K\u00e3go t\u00e1" },
            { "034", "Ajia M\u1ebdrinhon\u1ef9r" },
            { "hai", "hajna" },
            { "035", "Ajia Sur-R\u00e3jur" },
            { "UG", "Ug\u1ef9na" },
            { "hak", "haka" },
            { "type.co.pinyin", "Pin-yin to n\u1ef9t\u0129" },
            { "039", "Or\u00f3pa M\u1ebdrinhon\u1ef9r" },
            { "Sinh", "s\u0129gar\u1ebdj" },
            { "UM", "EUA Goj-v\u1ebdso K\u00e3sir" },
            { "UN", "N\u1ef9s\u00e3n Un\u0129na" },
            { "US", "Enhtano Un\u0129no" },
            { "haw", "havaj\u1ef9n\u0169" },
            { "%%1959ACAD", "kan\u1ebdm\u0129ku" },
            { "type.co.gb2312han", "S\u0129n\u1ebdj ke to ke (s\u0129mpri h\u00e1) - GB2312" },
            { "UY", "Urugvaj" },
            { "prg", "prusij\u1ef9n\u0169" },
            { "UZ", "Unhmekinht\u1ef9v" },
            { "tzm", "tam\u1ef9jirte Atara Kuju t\u00e1" },
            { "type.co.stroke", "Junhjoj to ke" },
            { "nnh", "gij\u1ebdmun" },
            { "VA", "Vatik\u1ef9n\u0169 Em\u00e3-m\u00e1g" },
            { "pro", "prov\u1ebdsar arkajku" },
            { "VC", "S\u1ef9 Visenti kar Gran\u1ef9nin\u1ef9" },
            { "VE", "Ven\u1ebdjuv\u00e9ra" },
            { "VG", "Mrit\u1ef9n\u0129ja Goj-v\u1ebdso" },
            { "VI", "Virj\u0129g Goj-v\u1ebdso t\u1ef9 Am\u1ebdrik\u1ef9n\u1ef9" },
            { "VN", "Vij\u00e9tin\u1ef9" },
            { "VU", "Van\u0169vatu" },
            { "nog", "n\u00e3gaj" },
            { "rwk", "hywa" },
            { "non", "n\u00e3rniko arkajku" },
            { "053", "Ausitrarajia" },
            { "%%AREVMDA", "arm\u1ebdn\u0129ju r\u00e3pur" },
            { "054", "M\u1ebdran\u1ebdjia" },
            { "WF", "Varinh kar Futun\u1ef9" },
            { "type.co.traditional", "To ke n\u1ef9t\u0129 p\u1ebd" },
            { "057", "M\u0129kron\u1ebdjia P\u00e9n\u0129n" },
            { "jgo", "g\u1ebdma" },
            { "lkt", "rak\u00f3ta" },
            { "type.nu.finance", "J\u00e3nkamu vin h\u00e1r n\u0129krer" },
            { "%%HEPBURN", "japonej v\u1ebdnhr\u00e1 ratin\u0169 to h\u00e9pymur" },
            { "type.co.compat", "\u1ebcgno t\u00e1 j\u1ebdn\u1ebd j\u00e1 k\u1ef9 ta ki j\u00e1" },
            { "wae", "varser" },
            { "WS", "Sam\u00e3va" },
            { "wal", "vorajta" },
            { "was", "vaso" },
            { "XA", "\u00d3n v\u0129 ag" },
            { "war", "varaj" },
            { "XB", "\u00d3n r\u00e9gre m\u0129." },
            { "awa", "avanhi" },
            { "061", "Porin\u1ebdjia" },
            { "XK", "Kosovo" },
            { "Gujr", "guserate" },
            { "Zxxx", "v\u1ebdnhr\u00e1-t\u0169" },
            { "Olck", "or siki" },
            { "wbp", "varpiri" },
            { "Batk", "mataki" },
            { "Blis", "s\u0129muru mrij" },
            { "YE", "Jem\u1ebdn" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "to ke p\u1ebd" },
            { "fan", "f\u1ef9nge" },
            { "%%ROZAJ", "resij\u1ef9n\u0169" },
            { "fat", "f\u1ef9ti" },
            { "Sgnw", "v\u1ebdnh-mu v\u1ebdnhr\u00e1d" },
            { "YT", "M\u1ef9j\u00f3te" },
            { "ZA", "Sur-Afrika" },
            { "type.lb.loose", "V\u1ebdfe mranh han f\u00e3 p\u00e3 tovan ka" },
            { "Deva", "nevan\u1ef9gari" },
            { "type.nu.geor", "Jejorj\u1ef9n\u0169 r\u00e1 pipir" },
            { "Hira", "hirag\u1ef9n\u1ef9" },
            { "ZM", "J\u1ef9mija" },
            { "%%PINYIN", "Piny\u2019in v\u1ebdnhr\u00e1 ratin\u0169 to" },
            { "ZW", "J\u0129mamuje" },
            { "ZZ", "Reji\u2019\u1ef9v Veja t\u0169" },
            { "Runr", "run\u0129ku" },
            { "type.ms.metric", "K\u00e3mur to ke p\u1ebd" },
            { "type.ca.iso8601", "Pr\u1ef9g-kur\u00e3-kar ISO-8601" },
            { "lol", "m\u00e3go" },
            { "nso", "soto n\u00e3rti" },
            { "type.nu.telu", "Terugo r\u00e1 pipir" },
            { "lou", "rovusij\u1ef9n\u1ef9 t\u00e1 ke p\u1ebd" },
            { "loz", "roji" },
            { "jmc", "m\u1ef9same" },
            { "type.nu.hansfin", "S\u0129n\u1ebdj r\u00e1 pipir j\u1ebdnkamu s\u0129mpri h\u00e1" },
            { "hil", "hirigajn\u00e3n" },
            { "type.nu.arabext", "\u0128no-aramiko kugjer r\u00e1 pipir" },
            { "nus", "n\u0169ver" },
            { "dak", "nakota" },
            { "type.nu.fullwide", "ti t\u00e9j kar r\u00e1 pipir" },
            { "hit", "hitita" },
            { "dar", "narguva" },
            { "dav", "tajta" },
            { "Maya", "hijer\u00f3grifu maja" },
            { "lrc", "ruri n\u00e3rti" },
            { "Copt", "k\u00f3mtiko" },
            { "nwc", "n\u1ebdvari h\u00e1 t\u1ef9v\u0129" },
            { "udm", "unm\u0169rte" },
            { "Khmr", metaValue_km },
            { "Limb", "r\u0129mu" },
            { "sad", "s\u1ef9nave" },
            { "type.nu.roman", "Rom\u1ef9n\u0169 r\u00e1 pipir" },
            { "sah", "saka" },
            { "sam", "aram\u1ef9jko samarit\u1ef9n\u0169" },
            { "%%SCOUSE", "enhkose v\u0129 p\u1ebd" },
            { "saq", "s\u1ef9muru" },
            { "sas", "sasag" },
            { "sat", "s\u1ef9tari" },
            { "Tfng", "tifin\u1ef9g" },
            { "jpr", "junajko-p\u00e9rsa" },
            { "type.d0.npinyin", "N\u0129krer" },
            { "type.nu.native", "N\u0129krer \u0169 vep\u00e3 r\u00e1 pipir" },
            { "sba", "g\u1ef9maji" },
            { "Guru", "gurm\u0169ki" },
            { "lua", "ruma-ruruva" },
            { "%%BISCAYAN", "misikajo" },
            { "type.d0.fwidth", "T\u00e3p\u00e9r kar" },
            { "sbp", "s\u1ef9gu" },
            { "lui", "rujs\u1ebdn\u0169" },
            { "nyn", "nyj\u1ef9mkore" },
            { "nym", "nyj\u1ef9m-vesi" },
            { "lun", "r\u0169na" },
            { "nyo", "nyjor" },
            { "luo", "ruvo" },
            { "fil", "firip\u0129n\u0169" },
            { "hmn", "hym\u00e3g" },
            { "del", "neravare" },
            { "lus", "rusaj" },
            { "bal", "marusi" },
            { "den", "sirave" },
            { "ban", metaValue_ban },
            { "uga", "ugaritiko" },
            { "luy", "ruja" },
            { "bas", "masa" },
            { "bax", metaValue_bax },
            { "%%ABL1943", "1943 k\u00e3 F\u00f3g V\u0129 V\u1ebdnhr\u00e1n Form\u0169rariv j\u00e9 h\u00e1r" },
            { "jrb", "junajko-aramiko" },
            { "nzi", "n\u0129sim\u1ef9" },
            { "sco", "isikoti" },
            { "scn", "sisirij\u1ef9n\u0169" },
            { "aa", "afar" },
            { "ab", "amekaso" },
            { "ae", "av\u00e9tiko" },
            { "af", "afrik\u1ef9n\u1ebd" },
            { "ak", "ak\u1ef9n" },
            { "bbj", "gum\u1ef9ra" },
            { "am", "am\u1ef9riko" },
            { "Arab", metaValue_ar },
            { "an", "aragon\u1ebd" },
            { "%%SOLBA", "setorvisa/ sormika v\u0129 p\u1ebd" },
            { "Jpan", "japun\u1ebdj" },
            { "ar", metaValue_ar },
            { "Hrkt", "sirama-v\u1ebdnhr\u00e1 japun\u1ebdj" },
            { "as", "ajam\u1ebd" },
            { "Lina", "r\u0129n\u1ebdjar A" },
            { "av", "avariko" },
            { "Linb", "r\u0129n\u1ebdjar B" },
            { "sdh", "kurno sur" },
            { "ay", "ajim\u1ef9ra" },
            { "az", "ajermaj\u1ef9n\u0169" },
            { "%%OSOJS", "osejako/osoj\u1ef9n\u1ebd v\u0129 p\u1ebd" },
            { "ba", "majkir" },
            { "type.co.unihan", "Ranikar-jonhjoj to n\u1ef9t\u0129 p\u1ebd" },
            { "be", "huso-kupri" },
            { "bg", "mugaru" },
            { "bi", "miram\u00e1" },
            { "bm", "m\u00e1mara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "nogrim" },
            { "br", "mret\u1ef9" },
            { "bs", "mojnia" },
            { "see", "sen\u1ebdka" },
            { "Mymr", metaValue_my },
            { "type.nu.laoo", "Ravosij\u1ef9n\u0169 r\u00e1 pipir" },
            { "seh", "sen\u1ef9" },
            { "Nkoo", metaValue_nqo },
            { "sel", "serkum" },
            { "ca", "katar\u0169g" },
            { "ses", "kojyramoro sen\u0129" },
            { "ce", "ses\u1ebdn\u0169" },
            { "ch", "sam\u00e3hu" },
            { "%%REVISED", "v\u1ebdnhr\u00e1 j\u00e3f\u0129" },
            { "co", "korso" },
            { "Orya", metaValue_or },
            { "cr", "kri" },
            { "cs", "s\u00e9ko" },
            { "cu", "eravu ekresijatiko" },
            { "yrl", "nh\u1ebdgatu" },
            { "cv", "suvase" },
            { "cy", "garej" },
            { "type.nu.ethi", "Etij\u00f3pij\u00e1n\u0169 r\u00e1 pipir" },
            { "Yiii", "yji" },
            { "da", "nhin\u1ef9m\u1ef9rkej" },
            { "de", "arim\u1ef9v" },
            { "type.cf.standard", "N\u0129kri han ka n\u0129 p\u1ebd" },
            { "bej", "meja" },
            { "din", "ninka" },
            { "Bugi", "mugn\u1ebdj" },
            { "bem", "mema" },
            { "sga", "ir\u1ef9nej arkajku" },
            { "type.nu.mong", "M\u00e3g\u00f3r r\u00e1 pipir" },
            { "dv", "nivehi" },
            { "dz", "j\u00e3nga" },
            { "bez", "men\u1ef9" },
            { "type.ca.chinese", "S\u0129n\u1ebdj Pr\u1ef9g-kur\u00e3-kar" },
            { "Lisu", "risu" },
            { "dje", "jarma" },
            { "type.nu.grek", "Grego r\u00e1 pipir" },
            { "ee", "eve" },
            { "bfd", "mafun" },
            { "type.lb.normal", "V\u1ebdfe mranh han f\u00e3 p\u1ebd ki" },
            { "ro_MD", "m\u00e3rnavijo" },
            { "el", metaValue_el },
            { "en", "\u0129nhgrej" },
            { "eo", "enhper\u1ef9tu" },
            { "type.co.big5han", "S\u0129n\u1ebdj V\u1ef9sa ke to ke p\u1ebd - Big5" },
            { "es", "enhp\u1ef9j\u00f3r" },
            { "et", "enhton\u0129j\u1ef9n\u0169" },
            { "Hanb", "h\u1ef9nme" },
            { "eu", "manhku" },
            { "Buhd", "muhin" },
            { "Hang", "h\u1ef9ngur" },
            { "Samr", "sam\u1ef9rit\u1ef9n\u0169" },
            { "shi", "tasehiti" },
            { "hsb", "soramiv t\u00e9j" },
            { "Hani", "h\u1ef9n" },
            { "shn", "s\u1ef9n" },
            { "Hano", "h\u1ef9n\u0169n\u0169" },
            { "fa", "p\u00e9rsa" },
            { "Hans", "s\u0129pri-h\u00e1" },
            { "type.nu.latn", "R\u00e3pur r\u00e1 pipir" },
            { "Hant", "si-p\u1ebd" },
            { "az_Arab", "aseri sur" },
            { "ff", "fura" },
            { "shu", "arame sanij\u1ef9n\u0169" },
            { "hsn", "sij\u1ef9g" },
            { "fi", "f\u0129ran\u1ebdj" },
            { "fj", "fij\u1ef9n\u0169" },
            { "fon", "f\u00e3m" },
            { "bgn", "marusi-r\u00e3purja" },
            { "yue", "k\u1ef9ton\u1ebdj" },
            { "fo", "fervej" },
            { "type.m0.bgn", "V\u1ebdnhr\u00e1 \u0169 ra t\u0129n BGN EUA (V\u1ebdnhv\u0129 \u0169ra t\u0129n)" },
            { "umb", "\u0169munu" },
            { "fr", "fr\u1ef9sej" },
            { "sid", "sinam\u0169" },
            { "fy", "friso r\u00e3pur" },
            { "ga", "ir\u1ef9nej" },
            { "gd", "gaj\u00e9riko enhkosej" },
            { "gl", "garego" },
            { "gn", "g\u00f3ran\u0129" },
            { "bho", "mojpuri" },
            { "und", "v\u1ebdnhv\u0129 ki kagt\u0129g" },
            { "type.ca.ethiopic-amete-alem", "Amete Alem Etij\u00f3pi Pr\u1ef9g-kur\u00e3-kar" },
            { "gu", "gujerati" },
            { "gv", "m\u1ef9nsi" },
            { "ha", "havusa" },
            { "he", "emrajko" },
            { "hi", "h\u0129ni" },
            { "hup", "hupa" },
            { "bik", "mikor" },
            { "bin", "min\u0129" },
            { "ho", "hiri motu" },
            { "hr", "krovata" },
            { "ht", "hajtij\u1ef9n\u0169" },
            { "hu", "\u0169garu" },
            { "hy", "arm\u1ebdn\u0129ju" },
            { "hz", "herero" },
            { "frc", "fr\u1ef9sej kaj\u0169n" },
            { "%%FONIPA", "Arfam\u00e9to Fon\u1ebdtiku \u0128nhtern\u1ef9son\u1ef9v to Fon\u1ebdtika" },
            { "ia", "v\u0129-j\u00e3gja" },
            { "Jamo", "j\u1ef9mo" },
            { "id", "\u0129non\u1ebdsijo" },
            { "type.nu.tibt", "Timet\u1ef9n\u0169 r\u00e1 pipir" },
            { "ie", "v\u0129-ag kuju ki" },
            { "ig", "igmo" },
            { "ii", "sisuv\u1ef9 ji" },
            { "frm", "fr\u1ef9sej kuju" },
            { "%%AO1990", "1990 F\u00f3g V\u0129 v\u1ebdnhr\u00e1 to V\u1ebdnhkr\u00e9n ja" },
            { "ik", "\u0129n\u0169pijake" },
            { "fro", "fr\u1ef9sej arkajku" },
            { "io", "ino" },
            { "frs", "fris\u1ef9 r\u00e3jur" },
            { "frr", "friso t\u1ef9 n\u00e3rti" },
            { "is", "kukryr" },
            { "it", "itarij\u1ef9n\u0169" },
            { "iu", "inugtituti" },
            { "%%HOGNORSK", "n\u00e3rovegej kynhm\u1ef9" },
            { "ja", "japon\u1ebdj" },
            { "Mlym", "marajara" },
            { "Sara", "sarati" },
            { "doi", "nogri" },
            { "bkm", "k\u00e3m" },
            { "sma", "sam\u0129 sur" },
            { "jv", metaValue_jv },
            { "Shaw", "savij\u1ef9n\u0169" },
            { "mad", "m\u1ef9nurej" },
            { "smj", "sam\u0129 Rure t\u00e1" },
            { "mag", "m\u1ef9gahi" },
            { "maf", "mafa" },
            { "mai", "m\u1ef9jtiri" },
            { "smn", "sam\u0129 Inari t\u00e1" },
            { "ka", "ji\u00f3rjij\u1ef9n\u0169" },
            { "bla", "sigsika" },
            { "mak", "m\u1ef9kasar" },
            { "wuu", "vu" },
            { "sms", "sam\u0129 Isik\u00f3rti t\u00e1" },
            { "man", "m\u1ef9nh\u0129ga" },
            { "kg", "k\u00e3gorej" },
            { "Goth", metaValue_got },
            { "ki", "kikuju" },
            { "mas", "m\u1ef9saj" },
            { "kj", "kuvanh\u1ef9m\u1ef9" },
            { "kk", "kajake" },
            { "kl", "groh\u1ebdr\u1ef9nej" },
            { "km", metaValue_km },
            { "kn", "kan\u1ef9rim" },
            { "ko", metaValue_ko },
            { "kr", "kan\u0169ri" },
            { "ks", "kasem\u0129ra" },
            { "Cirt", "sirti" },
            { "Lepc", "r\u00e9msa" },
            { "Avst", "av\u00e9nhko" },
            { "ku", "kurno" },
            { "kv", "kom\u0129" },
            { "kw", "k\u00f3rn\u0129ko" },
            { "ky", "kirginh" },
            { "snk", "s\u00e3n\u0129ke" },
            { "la", metaValue_la },
            { "lb", "rus\u1ebdmurgej" },
            { "type.nu.mlym", "Marajaro r\u00e1 pipir" },
            { "lg", "rug\u1ef9na" },
            { "Roro", "r\u00e3gor\u00e3go" },
            { "li", "r\u0129murgej" },
            { "Tibt", metaValue_bo },
            { "ln", "r\u0129gara" },
            { "fur", "frijur\u1ef9n\u0169" },
            { "lo", "raosij\u1ef9n\u0169" },
            { "type.ms.uksystem", "V\u1ebdnhk\u00e3mur \u0129perijar ki" },
            { "lt", "rituv\u1ef9n\u0169" },
            { "lu", "ruma-kat\u1ef9ga" },
            { "lv", "ret\u1ef9v" },
            { "sog", "sognij\u1ef9n\u0169" },
            { "mg", "m\u1ef9rgase" },
            { "mh", "m\u1ef9rsarej" },
            { "type.co.ducet", "Unicode to ke p\u1ebd" },
            { "mi", "m\u1ef9v\u00f3ri" },
            { "mk", "m\u1ef9senoj\u0169" },
            { "ml", "m\u1ef9rajara" },
            { "mn", metaValue_mn },
            { "mr", "marati" },
            { "ms", "m\u1ef9rajo" },
            { "mt", "m\u1ef9rtej" },
            { "my", metaValue_my },
            { "Saur", "savurajtera" },
            { "Armn", "arm\u1ebdnjo" },
            { "mdf", "mogsa" },
            { "mde", "mama" },
            { "dsb", "soramiv rur" },
            { "Armi", "arm\u0129" },
            { "na", "n\u1ef9vuruv\u00e1n\u0169" },
            { "type.co.search", "J\u1ebdnf\u0129n to ke Kar" },
            { "nb", "m\u00f3gm\u1ef9r n\u00e3rovegej" },
            { "nd", "nemere n\u00e3rti" },
            { "ne", "n\u1ebdparej" },
            { "ng", "nog\u00e3" },
            { "mdr", "m\u1ef9nar" },
            { "nl", "or\u1ef9nej" },
            { "nn", "n\u0129n\u00e3rsig n\u00e3rovegej" },
            { "no", "n\u00e3rovegej" },
            { "nr", "nemere sur" },
            { "nv", "n\u1ef9vaho" },
            { "kaa", "kara-karkag" },
            { "ny", "n\u0129j\u1ef9nja" },
            { "kac", "kas\u0129n" },
            { "kab", "kamyre" },
            { "%%POLYTON", "\u0169 ag t\u00e9j" },
            { "oc", "ogsit\u1ef9n\u0169" },
            { "kaj", "ju" },
            { "kam", "k\u1ef9ma" },
            { "men", "m\u1ebdne" },
            { "oj", "ojimva" },
            { "mer", "m\u1ebdru" },
            { "type.nu.armn", "Arm\u1ebdn\u0129jo r\u00e1 pipir" },
            { "om", "or\u00e3m\u0169" },
            { "kaw", "kavi" },
            { "or", metaValue_or },
            { "os", "oseto" },
            { "kbd", "kamarnhij\u1ef9n\u0169" },
            { "mfe", "m\u00e3risij\u1ebdn" },
            { "srn", "surin\u1ef9m\u1ebdj" },
            { "pa", "p\u1ef9jami" },
            { "dua", "nuvara" },
            { "srr", "serere" },
            { "%%LIPAW", "Resij\u1ef9n t\u1ef9 ripovasi v\u0129 p\u1ebd" },
            { "kbl", "kan\u1ebdnmu" },
            { "pi", "pari" },
            { "pl", "poron\u1ebdj" },
            { "dum", "or\u1ef9nej kuju" },
            { "type.ca.dangi", "N\u00e1gi Pr\u1ef9g-kur\u00e3-kar" },
            { "ps", "pasito" },
            { "pt", "f\u00f3g-v\u0129" },
            { "mga", "ir\u1ef9nej kuju" },
            { "key.co", "jagn\u1ebd n\u00f3n f\u1ebdgf\u1ebdg h\u00e1 han" },
            { "kcg", "tyjam" },
            { "mgh", "m\u1ef9kuva" },
            { "key.cf", "t\u1ef9 n\u0129kri ve" },
            { "bra", "mraj" },
            { "key.ca", "Kur\u00e3-kar" },
            { "Laoo", "ra\u2019o" },
            { "mgo", "m\u1ebdta" },
            { "type.hc.h23", "24 \u00f3ra tuke (0\u201323)" },
            { "type.hc.h24", "24 \u00f3ra tuke (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "type.nu.mymr", "M\u1ef9j\u1ef9m\u1ef9r r\u00e1 pipir" },
            { "qu", "kinsuva" },
            { "zap", "japoteko" },
            { "brx", "mono" },
            { "Lana", "r\u1ef9n\u1ef9" },
            { "kde", "m\u1ef9k\u00e3ne" },
            { "Ethi", "etij\u00f3piko" },
            { "type.hc.h12", "12 \u00f3ra tuke (1\u201312)" },
            { "type.hc.h11", "12 \u00f3ra tuke (0\u201311)" },
            { "rm", "hom\u1ef9se" },
            { "rn", "h\u0169ni" },
            { "key.cu", "J\u1ebdnkamu" },
            { "ro", "hom\u1ebdn\u0169" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "Orija r\u00e1 pipir" },
            { "type.nu.hanidec", "S\u0129n\u1ebdj n\u00e9j ki r\u00e1 pipir" },
            { "ru", "huso" },
            { "bss", "akuse" },
            { "rw", "kin\u0129jarv\u1ef9na" },
            { "zbl", "s\u0129moru mrij" },
            { "kea", "pu-t\u00e1nh-v\u0129" },
            { "mic", "m\u0129kem\u1ef9ke" },
            { "suk", "sukum\u1ef9" },
            { "sa", "s\u1ef9nhkrito" },
            { "%%UCCOR", "v\u1ebdnhr\u00e1 to ke pir" },
            { "sc", "sarno" },
            { "sus", "susu" },
            { "sd", "s\u0129ni" },
            { "se", "sam\u0129 n\u00e3rti" },
            { "min", "m\u0129n\u1ef9gkamavu" },
            { "sg", "s\u1ef9go" },
            { "sh", "servo-krovata" },
            { "si", "s\u0129garej" },
            { "sux", "sum\u1ebdrijo" },
            { "sk", "erovako" },
            { "sl", "eroven\u0169" },
            { "sm", "samov\u1ef9n\u0169" },
            { "sn", "s\u00e3n\u1ef9" },
            { "so", "som\u1ef9ri" },
            { "type.nu.arab", "\u0128no-aramiko r\u00e1 pipir" },
            { "sq", "arm\u00e1n\u1ebdj" },
            { "sr", "s\u00e9rvijo" },
            { "ss", "suvaji" },
            { "type.cf.account", "Kaj\u1ebdm j\u00e9 n\u0129kri h\u00e1r" },
            { "Java", metaValue_jv },
            { "st", "soto sur" },
            { "su", "sunan\u1ebdj" },
            { "%%NEDIS", "natison\u1ebd v\u0129 p\u1ebd" },
            { "sv", "suv\u00e9ko" },
            { "sw", "suvahiri" },
            { "type.nu.hantfin", "S\u0129n\u1ebdj r\u00e1 pipir j\u1ebdnkamu p\u1ebd" },
            { "ibb", "imimijo" },
            { "iba", "iman" },
            { "ta", "t\u00e1m\u0129r" },
            { "142", "Ajia" },
            { "bua", "murijato" },
            { "143", "Ajia-Kuju" },
            { "te", "t\u00e9rugo" },
            { "145", "Ajia-R\u00e3pur" },
            { "tg", "tanhike" },
            { "th", metaValue_th },
            { "ti", "tigrin\u0129ja" },
            { "bug", "mugin\u1ebdj" },
            { "kfo", "koro" },
            { "tk", "turkom\u1ebdn\u0169" },
            { "tl", "tagaro" },
            { "tn", "tisuvan\u1ef9" },
            { "to", "t\u00e3ngan\u1ebdj" },
            { "bum", "muru" },
            { "dyo", "jora-fonyj" },
            { "type.nu.jpan", "Japon\u1ebdj r\u00e1 pipir" },
            { "tr", "turko" },
            { "ts", "tes\u00e3ga" },
            { "swb", "komorij\u1ef9n\u0169" },
            { "Cakm", "kagme" },
            { "tt", "tartaru" },
            { "dyu", "nhivura" },
            { "tw", "tuvi" },
            { "ty", "tajtij\u1ef9n\u0169" },
            { "%%BISKE", "s\u1ef9n j\u00f3rjo/ mira v\u0129 p\u1ebd" },
            { "150", "Or\u00f3pa" },
            { "151", "Or\u00f3pa-R\u00e3jur" },
            { "154", "Or\u00f3pa Set\u1ebdntrion\u1ef9r" },
            { "dzg", "najaga" },
            { "155", "Or\u00f3pa R\u00e3pur" },
            { "ug", "ujgur" },
            { "Kore", metaValue_ko },
            { "Ital", "itariko si" },
            { "kgp", "kanhg\u00e1g" },
            { "Zyyy", "k\u00e3m\u0169" },
            { "uk", "ukran\u0129j\u1ef9n\u0169" },
            { "type.ca.coptic", "Komtike Pr\u1ef9g-kur\u00e3-kar" },
            { "ur", "urnu" },
            { "%%1994", "resij\u1ef9n\u1ef9 v\u1ebdnhr\u00e1 h\u00e1r-p\u1ebd" },
            { "xal", "karm\u0129g" },
            { "zen", "sen\u1ef9ga" },
            { "uz", "unhmeke" },
            { "kha", "kasi" },
            { "%%1996", "pr\u1ef9g t\u1ef9 1996 k\u00e3 v\u1ebdnhr\u00e1 arim\u1ef9" },
            { "nds_NL", "sags\u1ef9v rur" },
            { "Sylo", "syroti n\u1ef9gri" },
            { "ve", "v\u1ebdna" },
            { "type.ca.roc", "S\u0129n\u1ef9 Kar-m\u1ef9 Pr\u1ef9g-kur\u00e3-kar" },
            { "vi", "vij\u00e9tin\u1ef9m\u0169" },
            { "kho", "kotan\u1ebdj" },
            { "khq", "kujra s\u0129n\u0129" },
            { "key.hc", "\u00d3ra t\u0129g t\u1ef9 (12 vs. 24)" },
            { "%%TARASK", "tarasikevika v\u1ebdnhr\u00e1-p\u1ebd" },
            { "vo", "vorapuke" },
            { "syc", "sirijako h\u00e1 t\u1ef9v\u0129" },
            { "Osma", "ojm\u1ef9nja" },
            { "quc", "kis\u00e9" },
            { "gaa", "ga" },
            { "wa", "var\u1ef9v" },
            { "gag", "gagavuj" },
            { "syr", "sirijako" },
            { "Grek", metaValue_el },
            { "gan", "g\u1ef9n" },
            { "Lydi", "rinh-jo" },
            { "Xsux", "sum\u1ebdrijo-akanh\u1ef9n\u0169 kaf\u00e9n ja" },
            { "wo", "vorofe" },
            { "zgh", "tam\u1ef9jirte m\u1ef9h\u00f3kin\u0169 p\u00e3" },
            { "ar_001", "arame ta\u2019\u0169n" },
            { "Cans", "sirama-v\u1ebdnhr\u00e1 pir kan\u1ef9na t\u00e1 kanhg\u00e1g" },
            { "gay", "gajo" },
            { "Mong", metaValue_mn },
            { "mnc", "m\u1ef9su" },
            { "Latf", "rat\u0129nh fragtur" },
            { "gba", "gemaja" },
            { "mni", "m\u1ef9n\u0129puri" },
            { "Latn", metaValue_la },
            { "Latg", "rat\u0129nh gaj\u00e9riko" },
            { "type.nu.hans", "S\u0129n\u1ebdj r\u00e1 pipir s\u0129mpri h\u00e1" },
            { "type.nu.hant", "S\u0129n\u1ebdj r\u00e1 pipir p\u1ebd" },
            { "xh", "sosa" },
            { "type.nu.romanlow", "Rom\u1ef9n\u0169 r\u00e1 k\u1ebdsir r\u00e1 pipir" },
            { "byn", "mr\u0129n" },
            { "%%PAMAKA", "pam\u1ef9ka v\u0129 p\u1ebd" },
            { "Lyci", "risijo" },
            { "osa", "osage" },
            { "byv", "menuma" },
            { "Moon", "m\u0169n" },
            { "moh", "m\u00e3jk\u1ef9n\u0169" },
            { "kkj", "kako" },
            { "%%1694ACAD", "fr\u1ef9sej t\u1ef9 uri" },
            { "yi", "jinhise" },
            { "mos", "mosi" },
            { "Syrc", "sirijaku" },
            { "Dsrt", "nesereti" },
            { "yo", "joruma" },
            { "type.nu.traditional", "N\u0129krer p\u1ebd" },
            { "Syrj", "sirijaku r\u00e3pur" },
            { "ota", "turko otom\u1ef9n\u0169" },
            { "Syre", "sirijaku esitarageru" },
            { "vai", metaValue_vai },
            { "za", "juv\u1ef9g" },
            { "Cari", "karij\u1ef9n\u0169" },
            { "kln", "kar\u1ebdnj\u0129n" },
            { "zh", "s\u0129n\u1ebdj" },
            { "Bopo", "mopom\u00e3fo" },
            { "Perm", "p\u00e9rm\u0129ku si" },
            { "key.lb", "v\u1ebdfe mranh to ke" },
            { "zu", "suru" },
            { "type.co.phonebook", "Terefon\u0129 Risita to ke" },
            { "%%MONOTON", "kyr m\u00e1g ve" },
            { "Geor", "ge\u00f3rgij\u1ef9n\u0169" },
            { "kmb", "k\u0129muno" },
            { "type.nu.jpanfin", "Japon\u1ebdj vin h\u00e1r" },
            { "Cham", "s\u1ef9m" },
            { "gez", "gij" },
            { "Syrn", "sirijaku r\u00e3jur" },
            { "type.co.reformed", "H\u00e1r t\u00e3g n\u1ef9t\u0129" },
            { "Tglg", "tagaru" },
            { "Egyd", "nem\u00e3tiko ejimso" },
            { "Egyh", "jeratiko ejimso" },
            { "ebu", "\u1ebdmu" },
            { "Egyp", "jer\u00f3grifo ejimso" },
            { "Geok", "kehunsuri ge\u00f3rgij\u1ef9n\u0169" },
            { "zh_Hans", "s\u0129n\u1ebdj m\u1ebd" },
            { "koi", "kom\u0129-permyjag" },
            { "Hung", "h\u0169garu si" },
            { "kok", "k\u00e3kani" },
            { "%%1901", "arim\u1ef9v v\u1ebdnhr\u00e1 si-p\u1ebd" },
            { "kos", "kosiraj\u1ef9n" },
            { "zh_Hant", "s\u0129n\u1ebdj p\u1ebd" },
            { "Sund", "s\u0169nan\u1ebdj" },
            { "kpe", "kepere" },
            { "type.nu.khmr", "Khm\u1ebdr r\u00e1 pipir" },
            { "ilo", "iruk\u1ef9n\u0169" },
            { "%%VALENCIA", "varensijan\u0169" },
            { "Cprt", "siprijota" },
            { "%%BAKU1926", "arfam\u00e9to turko ratin\u0169 t\u1ef9 \u0169n pir" },
            { "mua", "m\u0169n\u00e1g" },
            { "type.nu.guru", "Gurm\u0169r\u00e1 pipir r\u00e1 pipir" },
            { "mul", "v\u1ebdnhv\u0129\u2019e" },
            { "cad", "kano" },
            { "key.ms", "v\u1ebdnhk\u00e3mun to ke" },
            { "mus", "krig" },
            { "Glag", "gragoritiko" },
            { "gil", "gimertej" },
            { "%%KKCOR", "v\u1ebdnhr\u00e1 to ke v\u1ebdnhm\u1ef9 ke kar" },
            { "Cher", metaValue_chr },
            { "car", "karime" },
            { "cay", "kajuga" },
            { "type.nu.tamldec", "T\u1ef9m\u0129r r\u00e1 pipir" },
            { "krc", "karasaj-markar" },
            { "inh", "\u0129nguse" },
            { "krl", "kar\u00e9rijo" },
            { "efi", "efike" },
            { "key.nu", "V\u1ebdnh n\u0129krer" },
            { "kru", "kurug" },
            { "ksb", "s\u1ef9mara" },
            { "Telu", "t\u00e9rugu" },
            { "ksf", "mafija" },
        };
        return data;
    }
}
