/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ja extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "ADP", "ADP" },
            { "AED", "AED" },
            { "AFA", "AFA" },
            { "AFN", "AFN" },
            { "ALK", "ALK" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "AOK", "AOK" },
            { "AON", "AON" },
            { "AOR", "AOR" },
            { "ARA", "ARA" },
            { "ARL", "ARL" },
            { "ARM", "ARM" },
            { "ARP", "ARP" },
            { "ARS", "ARS" },
            { "ATS", "ATS" },
            { "AWG", "AWG" },
            { "AZM", "AZM" },
            { "AZN", "AZN" },
            { "BAD", "BAD" },
            { "BAM", "BAM" },
            { "BAN", "BAN" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BEC", "BEC" },
            { "BEF", "BEF" },
            { "BEL", "BEL" },
            { "BGL", "BGL" },
            { "BGM", "BGM" },
            { "BGN", "BGN" },
            { "BGO", "BGO" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BOL", "BOL" },
            { "BOP", "BOP" },
            { "BOV", "BOV" },
            { "BRB", "BRB" },
            { "BRC", "BRC" },
            { "BRE", "BRE" },
            { "BRN", "BRN" },
            { "BRR", "BRR" },
            { "BRZ", "BRZ" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BUK", "BUK" },
            { "BWP", "BWP" },
            { "BYB", "BYB" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHE", "CHE" },
            { "CHF", "CHF" },
            { "CHW", "CHW" },
            { "CLE", "CLE" },
            { "CLF", "CLF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "CNX", "CNX" },
            { "CNY", "\u5143" },
            { "COP", "COP" },
            { "COU", "COU" },
            { "CRC", "CRC" },
            { "CSD", "CSD" },
            { "CSK", "CSK" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CYP", "CYP" },
            { "CZK", "CZK" },
            { "DDM", "DDM" },
            { "DEM", "DEM" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "ECS", "ECS" },
            { "ECV", "ECV" },
            { "EEK", "EEK" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ESA", "ESA" },
            { "ESB", "ESB" },
            { "ESP", "ESP" },
            { "ETB", "ETB" },
            { "FIM", "FIM" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "FRF", "FRF" },
            { "GEK", "GEK" },
            { "GEL", "GEL" },
            { "GHC", "GHC" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GNS", "GNS" },
            { "GQE", "GQE" },
            { "GRD", "GRD" },
            { "GTQ", "GTQ" },
            { "GWE", "GWE" },
            { "GWP", "GWP" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRD", "HRD" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IEP", "IEP" },
            { "ILP", "ILP" },
            { "ILR", "ILR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISJ", "ISJ" },
            { "ISK", "ISK" },
            { "ITL", "ITL" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "JPY", "\uffe5" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KRH", "KRH" },
            { "KRO", "KRO" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LSL", "LSL" },
            { "LTL", "LTL" },
            { "LTT", "LTT" },
            { "LUC", "LUC" },
            { "LUF", "LUF" },
            { "LUL", "LUL" },
            { "LVL", "LVL" },
            { "LVR", "LVR" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MAF", "MAF" },
            { "MCF", "MCF" },
            { "MDC", "MDC" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MGF", "MGF" },
            { "MKD", "MKD" },
            { "MKN", "MKN" },
            { "MLF", "MLF" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MRU", "MRU" },
            { "MTL", "MTL" },
            { "MTP", "MTP" },
            { "MUR", "MUR" },
            { "MVP", "MVP" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MXP", "MXP" },
            { "MXV", "MXV" },
            { "MYR", "MYR" },
            { "MZE", "MZE" },
            { "MZM", "MZM" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIC", "NIC" },
            { "NIO", "NIO" },
            { "NLG", "NLG" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEI", "PEI" },
            { "PEN", "PEN" },
            { "PES", "PES" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PLZ", "PLZ" },
            { "PTE", "PTE" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RHD", "RHD" },
            { "ROL", "ROL" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RUR", "RUR" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDD", "SDD" },
            { "SDG", "SDG" },
            { "SDP", "SDP" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SIT", "SIT" },
            { "SKK", "SKK" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SRG", "SRG" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SUR", "SUR" },
            { "SVC", "SVC" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "THB" },
            { "TJR", "TJR" },
            { "TJS", "TJS" },
            { "TMM", "TMM" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TPE", "TPE" },
            { "TRL", "TRL" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UAK", "UAK" },
            { "UGS", "UGS" },
            { "UGX", "UGX" },
            { "USD", "$" },
            { "USN", "USN" },
            { "USS", "USS" },
            { "UYI", "UYI" },
            { "UYP", "UYP" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEB", "VEB" },
            { "VEF", "VEF" },
            { "VES", "VES" },
            { "VNN", "VNN" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "XAG", "XAG" },
            { "XAU", "XAU" },
            { "XBA", "XBA" },
            { "XBB", "XBB" },
            { "XBC", "XBC" },
            { "XBD", "XBD" },
            { "XDR", "XDR" },
            { "XEU", "XEU" },
            { "XFO", "XFO" },
            { "XFU", "XFU" },
            { "XPD", "XPD" },
            { "XPT", "XPT" },
            { "XRE", "XRE" },
            { "XSU", "XSU" },
            { "XTS", "XTS" },
            { "XUA", "XUA" },
            { "XXX", "XXX" },
            { "YDD", "YDD" },
            { "YER", "YER" },
            { "YUD", "YUD" },
            { "YUM", "YUM" },
            { "YUN", "YUN" },
            { "YUR", "YUR" },
            { "ZAL", "ZAL" },
            { "ZAR", "ZAR" },
            { "ZMK", "ZMK" },
            { "ZMW", "ZMW" },
            { "ZRN", "ZRN" },
            { "ZRZ", "ZRZ" },
            { "ZWD", "ZWD" },
            { "ZWL", "ZWL" },
            { "ZWR", "ZWR" },
            { "adp", "\u30a2\u30f3\u30c9\u30e9 \u30da\u30bb\u30bf" },
            { "aed", "\u30a2\u30e9\u30d6\u9996\u9577\u56fd\u9023\u90a6\u30c7\u30a3\u30eb\u30cf\u30e0" },
            { "afa", "\u30a2\u30d5\u30ac\u30cb\u30b9\u30bf\u30f3 \u30a2\u30d5\u30ac\u30cb\u30fc (1927\u20132002)" },
            { "afn", "\u30a2\u30d5\u30ac\u30cb\u30b9\u30bf\u30f3 \u30a2\u30d5\u30ac\u30cb\u30fc" },
            { "alk", "\u30a2\u30eb\u30d0\u30cb\u30a2 \u30ec\u30af (1946\u20131965)" },
            { "all", "\u30a2\u30eb\u30d0\u30cb\u30a2 \u30ec\u30af" },
            { "amd", "\u30a2\u30eb\u30e1\u30cb\u30a2 \u30c9\u30e9\u30e0" },
            { "ang", "\u30aa\u30e9\u30f3\u30c0\u9818\u30a2\u30f3\u30c6\u30a3\u30eb \u30ae\u30eb\u30c0\u30fc" },
            { "aoa", "\u30a2\u30f3\u30b4\u30e9 \u30af\u30ef\u30f3\u30b6" },
            { "aok", "\u30a2\u30f3\u30b4\u30e9 \u30af\u30ef\u30f3\u30b6 (1977\u20131991)" },
            { "aon", "\u30a2\u30f3\u30b4\u30e9 \u65b0\u30af\u30ef\u30f3\u30b6 (1990\u20132000)" },
            { "aor", "\u30a2\u30f3\u30b4\u30e9 \u65e7\u30af\u30ef\u30f3\u30b6 (1995\u20131999)" },
            { "ara", "\u30a2\u30eb\u30bc\u30f3\u30c1\u30f3 \u30a2\u30a5\u30b9\u30c8\u30e9\u30fc\u30eb" },
            { "arl", "\u30a2\u30eb\u30bc\u30f3\u30c1\u30f3\u30fb\u30da\u30bd\u30fb\u30ec\u30a4\uff081970\u20131983\uff09" },
            { "arm", "\u30a2\u30eb\u30bc\u30f3\u30c1\u30f3\u30fb\u30da\u30bd\uff081881\u20131970\uff09" },
            { "arp", "\u30a2\u30eb\u30bc\u30f3\u30c1\u30f3 \u30da\u30bd (1983\u20131985)" },
            { "ars", "\u30a2\u30eb\u30bc\u30f3\u30c1\u30f3 \u30da\u30bd" },
            { "ats", "\u30aa\u30fc\u30b9\u30c8\u30ea\u30a2 \u30b7\u30ea\u30f3\u30b0" },
            { "aud", "\u30aa\u30fc\u30b9\u30c8\u30e9\u30ea\u30a2 \u30c9\u30eb" },
            { "awg", "\u30a2\u30eb\u30d0 \u30d5\u30ed\u30ea\u30f3" },
            { "azm", "\u30a2\u30bc\u30eb\u30d0\u30a4\u30b8\u30e3\u30f3 \u30de\u30ca\u30c8 (1993\u20132006)" },
            { "azn", "\u30a2\u30bc\u30eb\u30d0\u30a4\u30b8\u30e3\u30f3 \u30de\u30ca\u30c8" },
            { "bad", "\u30dc\u30b9\u30cb\u30a2\u30fb\u30d8\u30eb\u30c4\u30a7\u30b4\u30d3\u30ca \u30c7\u30a3\u30ca\u30fc\u30eb (1992\u20131994)" },
            { "bam", "\u30dc\u30b9\u30cb\u30a2\u30fb\u30d8\u30eb\u30c4\u30a7\u30b4\u30d3\u30ca \u514c\u63db\u30de\u30eb\u30af (BAM)" },
            { "ban", "\u30dc\u30b9\u30cb\u30a2\u30fb\u30d8\u30eb\u30c4\u30a7\u30b4\u30d3\u30ca \u65b0\u30c7\u30a3\u30ca\u30fc\u30eb\uff081994\u20131997\uff09" },
            { "bbd", "\u30d0\u30eb\u30d0\u30c9\u30b9 \u30c9\u30eb" },
            { "bdt", "\u30d0\u30f3\u30b0\u30e9\u30c7\u30b7\u30e5 \u30bf\u30ab" },
            { "bec", "\u30d9\u30eb\u30ae\u30fc \u30d5\u30e9\u30f3 (BEC)" },
            { "bef", "\u30d9\u30eb\u30ae\u30fc \u30d5\u30e9\u30f3" },
            { "bel", "\u30d9\u30eb\u30ae\u30fc \u30d5\u30e9\u30f3 (BEL)" },
            { "bgl", "\u30d6\u30eb\u30ac\u30ea\u30a2 \u30ec\u30d5" },
            { "bgm", "\u30d6\u30eb\u30ac\u30ea\u30a2\u793e\u4f1a\u4e3b\u7fa9 \u30ec\u30d5" },
            { "bgn", "\u30d6\u30eb\u30ac\u30ea\u30a2 \u65b0\u30ec\u30d5" },
            { "bgo", "\u30d6\u30eb\u30ac\u30ea\u30a2 \u30ec\u30d5\uff081879\u20131952\uff09" },
            { "bhd", "\u30d0\u30fc\u30ec\u30fc\u30f3 \u30c7\u30a3\u30ca\u30fc\u30eb" },
            { "bif", "\u30d6\u30eb\u30f3\u30b8 \u30d5\u30e9\u30f3" },
            { "bmd", "\u30d0\u30df\u30e5\u30fc\u30c0 \u30c9\u30eb" },
            { "bnd", "\u30d6\u30eb\u30cd\u30a4 \u30c9\u30eb" },
            { "bob", "\u30dc\u30ea\u30d3\u30a2 \u30dc\u30ea\u30d3\u30a2\u30fc\u30ce" },
            { "bol", "\u30dc\u30ea\u30d3\u30a2 \u30dc\u30ea\u30d3\u30a2\u30fc\u30ce (1863\u20131963)" },
            { "bop", "\u30dc\u30ea\u30d3\u30a2 \u30da\u30bd" },
            { "bov", "\u30dc\u30ea\u30d3\u30a2 (Mvdol)" },
            { "brb", "\u30d6\u30e9\u30b8\u30eb \u65b0\u30af\u30eb\u30bc\u30a4\u30ed (1967\u20131986)" },
            { "brc", "\u30d6\u30e9\u30b8\u30eb \u30af\u30eb\u30b6\u30fc\u30c9 (1986\u20131989)" },
            { "bre", "\u30d6\u30e9\u30b8\u30eb \u30af\u30eb\u30bc\u30a4\u30ed (1990\u20131993)" },
            { "brl", "\u30d6\u30e9\u30b8\u30eb \u30ec\u30a2\u30eb" },
            { "brn", "\u30d6\u30e9\u30b8\u30eb \u65b0\u30af\u30eb\u30b6\u30fc\u30c9 (1989\u20131990)" },
            { "brr", "\u30d6\u30e9\u30b8\u30eb \u30af\u30eb\u30bc\u30a4\u30ed (1993\u20131994)" },
            { "brz", "\u30d6\u30e9\u30b8\u30eb \u30af\u30eb\u30bc\u30a4\u30ed\uff081942\u20131967\uff09" },
            { "bsd", "\u30d0\u30cf\u30de \u30c9\u30eb" },
            { "btn", "\u30d6\u30fc\u30bf\u30f3 \u30cb\u30e5\u30eb\u30bf\u30e0" },
            { "buk", "\u30d3\u30eb\u30de \u30c1\u30e3\u30c3\u30c8" },
            { "bwp", "\u30dc\u30c4\u30ef\u30ca \u30d7\u30e9" },
            { "byb", "\u30d9\u30e9\u30eb\u30fc\u30b7 \u65b0\u30eb\u30fc\u30d6\u30eb (1994\u20131999)" },
            { "byn", "\u30d9\u30e9\u30eb\u30fc\u30b7 \u30eb\u30fc\u30d6\u30eb" },
            { "byr", "\u30d9\u30e9\u30eb\u30fc\u30b7 \u30eb\u30fc\u30d6\u30eb (2000\u20132016)" },
            { "bzd", "\u30d9\u30ea\u30fc\u30ba \u30c9\u30eb" },
            { "cad", "\u30ab\u30ca\u30c0 \u30c9\u30eb" },
            { "cdf", "\u30b3\u30f3\u30b4 \u30d5\u30e9\u30f3" },
            { "che", "\u30e6\u30fc\u30ed (WIR)" },
            { "chf", "\u30b9\u30a4\u30b9 \u30d5\u30e9\u30f3" },
            { "chw", "\u30d5\u30e9\u30f3 (WIR)" },
            { "cle", "\u30c1\u30ea \u30a8\u30b9\u30af\u30fc\u30c9" },
            { "clf", "\u30c1\u30ea \u30a6\u30cb\u30c0\u30fb\u30c7\u30fb\u30d5\u30a9\u30e1\u30f3\u30c8 (UF)" },
            { "clp", "\u30c1\u30ea \u30da\u30bd" },
            { "cnh", "\u4e2d\u56fd\u4eba\u6c11\u5143(\u30aa\u30d5\u30b7\u30e7\u30a2)" },
            { "cnx", "\u4e2d\u56fd\u4eba\u6c11\u9280\u884c\u30c9\u30eb" },
            { "cny", "\u4e2d\u56fd\u4eba\u6c11\u5143" },
            { "cop", "\u30b3\u30ed\u30f3\u30d3\u30a2 \u30da\u30bd" },
            { "cou", "\u30b3\u30ed\u30f3\u30d3\u30a2 \u30ec\u30a2\u30eb \uff08UVR)" },
            { "crc", "\u30b3\u30b9\u30bf\u30ea\u30ab \u30b3\u30ed\u30f3" },
            { "csd", "\u30bb\u30eb\u30d3\u30a2 \u30c7\u30a3\u30ca\u30fc\u30eb (2002\u20132006)" },
            { "csk", "\u30c1\u30a7\u30b3\u30b9\u30ed\u30d0\u30ad\u30a2 \u30b3\u30eb\u30ca" },
            { "cuc", "\u30ad\u30e5\u30fc\u30d0 \u514c\u63db\u30da\u30bd" },
            { "cup", "\u30ad\u30e5\u30fc\u30d0 \u30da\u30bd" },
            { "cve", "\u30ab\u30fc\u30dc\u30d9\u30eb\u30c7 \u30a8\u30b9\u30af\u30fc\u30c9" },
            { "cyp", "\u30ad\u30d7\u30ed\u30b9 \u30dd\u30f3\u30c9" },
            { "czk", "\u30c1\u30a7\u30b3 \u30b3\u30eb\u30ca" },
            { "ddm", "\u6771\u30c9\u30a4\u30c4 \u30de\u30eb\u30af" },
            { "dem", "\u30c9\u30a4\u30c4 \u30de\u30eb\u30af" },
            { "djf", "\u30b8\u30d6\u30c1 \u30d5\u30e9\u30f3" },
            { "dkk", "\u30c7\u30f3\u30de\u30fc\u30af \u30af\u30ed\u30fc\u30cd" },
            { "dop", "\u30c9\u30df\u30cb\u30ab \u30da\u30bd" },
            { "dzd", "\u30a2\u30eb\u30b8\u30a7\u30ea\u30a2 \u30c7\u30a3\u30ca\u30fc\u30eb" },
            { "ecs", "\u30a8\u30af\u30a2\u30c9\u30eb \u30b9\u30af\u30ec" },
            { "ecv", "\u30a8\u30af\u30a2\u30c9\u30eb (UVC)" },
            { "eek", "\u30a8\u30b9\u30c8\u30cb\u30a2 \u30af\u30eb\u30fc\u30f3" },
            { "egp", "\u30a8\u30b8\u30d7\u30c8 \u30dd\u30f3\u30c9" },
            { "ern", "\u30a8\u30ea\u30c8\u30ea\u30a2 \u30ca\u30af\u30d5\u30a1" },
            { "esa", "\u30b9\u30da\u30a4\u30f3\u30da\u30bb\u30bf\uff08\u52d8\u5b9aA\uff09" },
            { "esb", "\u30b9\u30da\u30a4\u30f3 \u514c\u63db\u30da\u30bb\u30bf" },
            { "esp", "\u30b9\u30da\u30a4\u30f3 \u30da\u30bb\u30bf" },
            { "etb", "\u30a8\u30c1\u30aa\u30d4\u30a2 \u30d6\u30eb" },
            { "eur", "\u30e6\u30fc\u30ed" },
            { "fim", "\u30d5\u30a3\u30f3\u30e9\u30f3\u30c9 \u30de\u30eb\u30ab" },
            { "fjd", "\u30d5\u30a3\u30b8\u30fc \u30c9\u30eb" },
            { "fkp", "\u30d5\u30a9\u30fc\u30af\u30e9\u30f3\u30c9\uff08\u30de\u30eb\u30d3\u30ca\u30b9\uff09\u8af8\u5cf6 \u30dd\u30f3\u30c9" },
            { "frf", "\u30d5\u30e9\u30f3\u30b9 \u30d5\u30e9\u30f3" },
            { "gbp", "\u82f1\u56fd\u30dd\u30f3\u30c9" },
            { "gek", "\u30b8\u30e7\u30fc\u30b8\u30a2 \u30af\u30fc\u30dd\u30f3 \u30e9\u30ea" },
            { "gel", "\u30b8\u30e7\u30fc\u30b8\u30a2 \u30e9\u30ea" },
            { "ghc", "\u30ac\u30fc\u30ca \u30bb\u30c7\u30a3 (1979\u20132007)" },
            { "ghs", "\u30ac\u30fc\u30ca \u30bb\u30c7\u30a3" },
            { "gip", "\u30b8\u30d6\u30e9\u30eb\u30bf\u30eb \u30dd\u30f3\u30c9" },
            { "gmd", "\u30ac\u30f3\u30d3\u30a2 \u30c0\u30e9\u30b7" },
            { "gnf", "\u30ae\u30cb\u30a2 \u30d5\u30e9\u30f3" },
            { "gns", "\u30ae\u30cb\u30a2 \u30b7\u30ea\u30fc" },
            { "gqe", "\u8d64\u9053\u30ae\u30cb\u30a2 \u30a8\u30af\u30a6\u30a7\u30ec" },
            { "grd", "\u30ae\u30ea\u30b7\u30e3 \u30c9\u30e9\u30af\u30de" },
            { "gtq", "\u30b0\u30a2\u30c6\u30de\u30e9 \u30b1\u30c4\u30a1\u30eb" },
            { "gwe", "\u30dd\u30eb\u30c8\u30ac\u30eb\u9818\u30ae\u30cb\u30a2 \u30a8\u30b9\u30af\u30fc\u30c9" },
            { "gwp", "\u30ae\u30cb\u30a2\u30d3\u30b5\u30a6 \u30da\u30bd" },
            { "gyd", "\u30ac\u30a4\u30a2\u30ca \u30c9\u30eb" },
            { "hkd", "\u9999\u6e2f\u30c9\u30eb" },
            { "hnl", "\u30db\u30f3\u30b8\u30e5\u30e9\u30b9 \u30ec\u30f3\u30d4\u30e9" },
            { "hrd", "\u30af\u30ed\u30a2\u30c1\u30a2 \u30c7\u30a3\u30ca\u30fc\u30eb" },
            { "hrk", "\u30af\u30ed\u30a2\u30c1\u30a2 \u30af\u30fc\u30ca" },
            { "htg", "\u30cf\u30a4\u30c1 \u30b0\u30fc\u30eb\u30c9" },
            { "huf", "\u30cf\u30f3\u30ac\u30ea\u30fc \u30d5\u30a9\u30ea\u30f3\u30c8" },
            { "idr", "\u30a4\u30f3\u30c9\u30cd\u30b7\u30a2 \u30eb\u30d4\u30a2" },
            { "iep", "\u30a2\u30a4\u30ea\u30c3\u30b7\u30e5 \u30dd\u30f3\u30c9" },
            { "ilp", "\u30a4\u30b9\u30e9\u30a8\u30eb \u30dd\u30f3\u30c9" },
            { "ilr", "\u30a4\u30b9\u30e9\u30a8\u30eb \u30b7\u30a7\u30b1\u30eb (1980\u20131985)" },
            { "ils", "\u30a4\u30b9\u30e9\u30a8\u30eb\u65b0\u30b7\u30a7\u30b1\u30eb" },
            { "inr", "\u30a4\u30f3\u30c9 \u30eb\u30d4\u30fc" },
            { "iqd", "\u30a4\u30e9\u30af \u30c7\u30a3\u30ca\u30fc\u30eb" },
            { "irr", "\u30a4\u30e9\u30f3 \u30ea\u30a2\u30eb" },
            { "isj", "\u30a2\u30a4\u30b9\u30e9\u30f3\u30c9 \u30af\u30ed\u30fc\u30ca (1918\u20131981)" },
            { "isk", "\u30a2\u30a4\u30b9\u30e9\u30f3\u30c9 \u30af\u30ed\u30fc\u30ca" },
            { "itl", "\u30a4\u30bf\u30ea\u30a2 \u30ea\u30e9" },
            { "jmd", "\u30b8\u30e3\u30de\u30a4\u30ab \u30c9\u30eb" },
            { "jod", "\u30e8\u30eb\u30c0\u30f3 \u30c7\u30a3\u30ca\u30fc\u30eb" },
            { "jpy", "\u65e5\u672c\u5186" },
            { "kes", "\u30b1\u30cb\u30a2 \u30b7\u30ea\u30f3\u30b0" },
            { "kgs", "\u30ad\u30eb\u30ae\u30b9 \u30bd\u30e0" },
            { "khr", "\u30ab\u30f3\u30dc\u30b8\u30a2 \u30ea\u30a8\u30eb" },
            { "kmf", "\u30b3\u30e2\u30ed \u30d5\u30e9\u30f3" },
            { "kpw", "\u5317\u671d\u9bae\u30a6\u30a9\u30f3" },
            { "krh", "\u97d3\u56fd \u30d5\u30a1\u30f3\uff081953\u20131962\uff09" },
            { "kro", "\u97d3\u56fd \u30a6\u30a9\u30f3\uff081945\u20131953\uff09" },
            { "krw", "\u97d3\u56fd\u30a6\u30a9\u30f3" },
            { "kwd", "\u30af\u30a6\u30a7\u30fc\u30c8 \u30c7\u30a3\u30ca\u30fc\u30eb" },
            { "kyd", "\u30b1\u30a4\u30de\u30f3\u8af8\u5cf6 \u30c9\u30eb" },
            { "kzt", "\u30ab\u30b6\u30d5\u30b9\u30bf\u30f3 \u30c6\u30f3\u30b2" },
            { "lak", "\u30e9\u30aa\u30b9 \u30ad\u30fc\u30d7" },
            { "lbp", "\u30ec\u30d0\u30ce\u30f3 \u30dd\u30f3\u30c9" },
            { "lkr", "\u30b9\u30ea\u30e9\u30f3\u30ab \u30eb\u30d4\u30fc" },
            { "lrd", "\u30ea\u30d9\u30ea\u30a2 \u30c9\u30eb" },
            { "lsl", "\u30ec\u30bd\u30c8 \u30ed\u30c6\u30a3" },
            { "ltl", "\u30ea\u30c8\u30a2\u30cb\u30a2 \u30ea\u30bf\u30b9" },
            { "ltt", "\u30ea\u30c8\u30a2\u30cb\u30a2 \u30bf\u30ed\u30ca" },
            { "luc", "\u30eb\u30af\u30bb\u30f3\u30d6\u30eb\u30af \u514c\u63db\u30d5\u30e9\u30f3" },
            { "luf", "\u30eb\u30af\u30bb\u30f3\u30d6\u30eb\u30b0 \u30d5\u30e9\u30f3" },
            { "lul", "\u30eb\u30af\u30bb\u30f3\u30d6\u30eb\u30af \u91d1\u878d\u30d5\u30e9\u30f3" },
            { "lvl", "\u30e9\u30c8\u30d3\u30a2 \u30e9\u30c3\u30c4" },
            { "lvr", "\u30e9\u30c8\u30d3\u30a2 \u30eb\u30fc\u30d6\u30eb" },
            { "lyd", "\u30ea\u30d3\u30a2 \u30c7\u30a3\u30ca\u30fc\u30eb" },
            { "mad", "\u30e2\u30ed\u30c3\u30b3 \u30c7\u30a3\u30eb\u30cf\u30e0" },
            { "maf", "\u30e2\u30ed\u30c3\u30b3 \u30d5\u30e9\u30f3" },
            { "mcf", "\u30e2\u30cd\u30ac\u30b9\u30af \u30d5\u30e9\u30f3" },
            { "mdc", "\u30e2\u30eb\u30c9\u30d0 \u30af\u30fc\u30dd\u30f3" },
            { "mdl", "\u30e2\u30eb\u30c9\u30d0 \u30ec\u30a4" },
            { "mga", "\u30de\u30c0\u30ac\u30b9\u30ab\u30eb \u30a2\u30ea\u30a2\u30ea" },
            { "mgf", "\u30de\u30e9\u30ac\u30b7 \u30d5\u30e9\u30f3" },
            { "mkd", "\u30de\u30b1\u30c9\u30cb\u30a2 \u30c7\u30ca\u30eb" },
            { "mkn", "\u30de\u30b1\u30c9\u30cb\u30a2 \u30c7\u30a3\u30ca\u30fc\u30eb\uff081992\u20131993\uff09" },
            { "mlf", "\u30de\u30ea \u30d5\u30e9\u30f3" },
            { "mmk", "\u30df\u30e3\u30f3\u30de\u30fc \u30c1\u30e3\u30c3\u30c8" },
            { "mnt", "\u30e2\u30f3\u30b4\u30eb \u30c8\u30b0\u30ed\u30b0" },
            { "mop", "\u30de\u30ab\u30aa \u30d1\u30bf\u30ab" },
            { "mro", "\u30e2\u30fc\u30ea\u30bf\u30cb\u30a2 \u30a6\u30ae\u30a2 (1973\u20132017)" },
            { "mru", "\u30e2\u30fc\u30ea\u30bf\u30cb\u30a2 \u30a6\u30ae\u30a2" },
            { "mtl", "\u30de\u30eb\u30bf \u30ea\u30e9" },
            { "mtp", "\u30de\u30eb\u30bf \u30dd\u30f3\u30c9" },
            { "mur", "\u30e2\u30fc\u30ea\u30b7\u30e3\u30b9 \u30eb\u30d4\u30fc" },
            { "mvp", "\u30e2\u30eb\u30c7\u30a3\u30d6\u8af8\u5cf6 \u30eb\u30d4\u30fc" },
            { "mvr", "\u30e2\u30eb\u30c7\u30a3\u30d6 \u30eb\u30d5\u30a3\u30a2" },
            { "mwk", "\u30de\u30e9\u30a6\u30a3 \u30af\u30ef\u30c1\u30e3" },
            { "mxn", "\u30e1\u30ad\u30b7\u30b3 \u30da\u30bd" },
            { "mxp", "\u30e1\u30ad\u30b7\u30b3 \u30da\u30bd (1861\u20131992)" },
            { "mxv", "\u30e1\u30ad\u30b7\u30b3 (UDI)" },
            { "myr", "\u30de\u30ec\u30fc\u30b7\u30a2 \u30ea\u30f3\u30ae\u30c3\u30c8" },
            { "mze", "\u30e2\u30b6\u30f3\u30d4\u30fc\u30af \u30a8\u30b9\u30af\u30fc\u30c9" },
            { "mzm", "\u30e2\u30b6\u30f3\u30d3\u30fc\u30af \u30e1\u30c6\u30a3\u30ab\u30eb (1980\u20132006)" },
            { "mzn", "\u30e2\u30b6\u30f3\u30d3\u30fc\u30af \u30e1\u30c6\u30a3\u30ab\u30eb" },
            { "nad", "\u30ca\u30df\u30d3\u30a2 \u30c9\u30eb" },
            { "ngn", "\u30ca\u30a4\u30b8\u30a7\u30ea\u30a2 \u30ca\u30a4\u30e9" },
            { "nic", "\u30cb\u30ab\u30e9\u30b0\u30a2 \u30b3\u30eb\u30c9\u30d0 (1988\u20131991)" },
            { "nio", "\u30cb\u30ab\u30e9\u30b0\u30a2 \u30b3\u30eb\u30c9\u30d0 \u30aa\u30ed" },
            { "nlg", "\u30aa\u30e9\u30f3\u30c0 \u30ae\u30eb\u30c0\u30fc" },
            { "nok", "\u30ce\u30eb\u30a6\u30a7\u30fc \u30af\u30ed\u30fc\u30cd" },
            { "npr", "\u30cd\u30d1\u30fc\u30eb \u30eb\u30d4\u30fc" },
            { "nzd", "\u30cb\u30e5\u30fc\u30b8\u30fc\u30e9\u30f3\u30c9 \u30c9\u30eb" },
            { "omr", "\u30aa\u30de\u30fc\u30f3 \u30ea\u30a2\u30eb" },
            { "pab", "\u30d1\u30ca\u30de \u30d0\u30eb\u30dc\u30a2" },
            { "pei", "\u30da\u30eb\u30fc \u30a4\u30f3\u30c6\u30a3" },
            { "pen", "\u30da\u30eb\u30fc \u30bd\u30eb" },
            { "pes", "\u30da\u30eb\u30fc \u30bd\u30eb (1863\u20131965)" },
            { "pgk", "\u30d1\u30d7\u30a2\u30cb\u30e5\u30fc\u30ae\u30cb\u30a2 \u30ad\u30ca" },
            { "php", "\u30d5\u30a3\u30ea\u30d4\u30f3 \u30da\u30bd" },
            { "pkr", "\u30d1\u30ad\u30b9\u30bf\u30f3 \u30eb\u30d4\u30fc" },
            { "pln", "\u30dd\u30fc\u30e9\u30f3\u30c9 \u30ba\u30a6\u30a9\u30c6\u30a3" },
            { "plz", "\u30dd\u30fc\u30e9\u30f3\u30c9 \u30ba\u30a6\u30a9\u30c6\u30a3 (1950\u20131995)" },
            { "pte", "\u30dd\u30eb\u30c8\u30ac\u30eb \u30a8\u30b9\u30af\u30fc\u30c9" },
            { "pyg", "\u30d1\u30e9\u30b0\u30a2\u30a4 \u30b0\u30a2\u30e9\u30cb" },
            { "qar", "\u30ab\u30bf\u30fc\u30eb \u30ea\u30a2\u30eb" },
            { "rhd", "\u30ed\u30fc\u30c7\u30b7\u30a2 \u30c9\u30eb" },
            { "rol", "\u30eb\u30fc\u30de\u30cb\u30a2 \u30ec\u30a4 (1952\u20132006)" },
            { "ron", "\u30eb\u30fc\u30de\u30cb\u30a2 \u30ec\u30a4" },
            { "rsd", "\u30c7\u30a3\u30ca\u30fc\u30eb (\u30bb\u30eb\u30d3\u30a2)" },
            { "rub", "\u30ed\u30b7\u30a2 \u30eb\u30fc\u30d6\u30eb" },
            { "rur", "\u30ed\u30b7\u30a2 \u30eb\u30fc\u30d6\u30eb (1991\u20131998)" },
            { "rwf", "\u30eb\u30ef\u30f3\u30c0 \u30d5\u30e9\u30f3" },
            { "sar", "\u30b5\u30a6\u30b8 \u30ea\u30e4\u30eb" },
            { "sbd", "\u30bd\u30ed\u30e2\u30f3\u8af8\u5cf6 \u30c9\u30eb" },
            { "scr", "\u30bb\u30fc\u30b7\u30a7\u30eb \u30eb\u30d4\u30fc" },
            { "sdd", "\u30b9\u30fc\u30c0\u30f3 \u30c7\u30a3\u30ca\u30fc\u30eb (1992\u20132007)" },
            { "sdg", "\u30b9\u30fc\u30c0\u30f3 \u30dd\u30f3\u30c9" },
            { "sdp", "\u30b9\u30fc\u30c0\u30f3 \u30dd\u30f3\u30c9 (1957\u20131998)" },
            { "sek", "\u30b9\u30a6\u30a7\u30fc\u30c7\u30f3 \u30af\u30ed\u30fc\u30ca" },
            { "sgd", "\u30b7\u30f3\u30ac\u30dd\u30fc\u30eb \u30c9\u30eb" },
            { "shp", "\u30bb\u30f3\u30c8\u30d8\u30ec\u30ca \u30dd\u30f3\u30c9" },
            { "sit", "\u30b9\u30ed\u30d9\u30cb\u30a2 \u30c8\u30e9\u30fc\u30eb" },
            { "skk", "\u30b9\u30ed\u30d0\u30ad\u30a2 \u30b3\u30eb\u30ca" },
            { "sll", "\u30b7\u30a8\u30e9\u30ec\u30aa\u30cd \u30ec\u30aa\u30f3" },
            { "sos", "\u30bd\u30de\u30ea\u30a2 \u30b7\u30ea\u30f3\u30b0" },
            { "srd", "\u30b9\u30ea\u30ca\u30e0 \u30c9\u30eb" },
            { "srg", "\u30b9\u30ea\u30ca\u30e0 \u30ae\u30eb\u30c0\u30fc" },
            { "ssp", "\u5357\u30b9\u30fc\u30c0\u30f3 \u30dd\u30f3\u30c9" },
            { "std", "\u30b5\u30f3\u30c8\u30e1\u30fb\u30d7\u30ea\u30f3\u30b7\u30da \u30c9\u30d6\u30e9 (1977\u20132017)" },
            { "stn", "\u30b5\u30f3\u30c8\u30e1\u30fb\u30d7\u30ea\u30f3\u30b7\u30da \u30c9\u30d6\u30e9" },
            { "sur", "\u30bd\u9023 \u30eb\u30fc\u30d6\u30eb" },
            { "svc", "\u30a8\u30eb\u30b5\u30eb\u30d0\u30c9\u30eb \u30b3\u30ed\u30f3" },
            { "syp", "\u30b7\u30ea\u30a2 \u30dd\u30f3\u30c9" },
            { "szl", "\u30b9\u30ef\u30b8\u30e9\u30f3\u30c9 \u30ea\u30e9\u30f3\u30b2\u30cb" },
            { "thb", "\u30bf\u30a4 \u30d0\u30fc\u30c4" },
            { "tjr", "\u30bf\u30b8\u30ad\u30b9\u30bf\u30f3 \u30eb\u30fc\u30d6\u30eb" },
            { "tjs", "\u30bf\u30b8\u30ad\u30b9\u30bf\u30f3 \u30bd\u30e2\u30cb" },
            { "tmm", "\u30c8\u30eb\u30af\u30e1\u30cb\u30b9\u30bf\u30f3 \u30de\u30ca\u30c8 (1993\u20132009)" },
            { "tmt", "\u30c8\u30eb\u30af\u30e1\u30cb\u30b9\u30bf\u30f3 \u30de\u30ca\u30c8" },
            { "tnd", "\u30c1\u30e5\u30cb\u30b8\u30a2 \u30c7\u30a3\u30ca\u30fc\u30eb" },
            { "top", "\u30c8\u30f3\u30ac \u30d1\u30fb\u30a2\u30f3\u30ac" },
            { "tpe", "\u30c6\u30a3\u30e2\u30fc\u30eb \u30a8\u30b9\u30af\u30fc\u30c9" },
            { "trl", "\u30c8\u30eb\u30b3 \u30ea\u30e9 (1922\u20132005)" },
            { "try", "\u65b0\u30c8\u30eb\u30b3\u30ea\u30e9" },
            { "ttd", "\u30c8\u30ea\u30cb\u30c0\u30fc\u30c9\u30fb\u30c8\u30d0\u30b4 \u30c9\u30eb" },
            { "twd", "\u65b0\u53f0\u6e7e\u30c9\u30eb" },
            { "tzs", "\u30bf\u30f3\u30b6\u30cb\u30a2 \u30b7\u30ea\u30f3\u30b0" },
            { "uah", "\u30a6\u30af\u30e9\u30a4\u30ca \u30b0\u30ea\u30d6\u30ca" },
            { "uak", "\u30a6\u30af\u30e9\u30a4\u30ca \u30ab\u30eb\u30dc\u30d0\u30cd\u30c4" },
            { "ugs", "\u30a6\u30ac\u30f3\u30c0 \u30b7\u30ea\u30f3\u30b0 (1966\u20131987)" },
            { "ugx", "\u30a6\u30ac\u30f3\u30c0 \u30b7\u30ea\u30f3\u30b0" },
            { "usd", "\u7c73\u30c9\u30eb" },
            { "usn", "\u7c73\u30c9\u30eb (\u7fcc\u65e5)" },
            { "uss", "\u7c73\u30c9\u30eb (\u5f53\u65e5)" },
            { "uyi", "\u30a6\u30eb\u30b0\u30a2\u30a4 \u30da\u30bd\u30a8\u30f3" },
            { "uyp", "\u30a6\u30eb\u30b0\u30a2\u30a4 \u30da\u30bd (1975\u20131993)" },
            { "uyu", "\u30a6\u30eb\u30b0\u30a2\u30a4 \u30da\u30bd" },
            { "uzs", "\u30a6\u30ba\u30d9\u30ad\u30b9\u30bf\u30f3 \u30b9\u30e0" },
            { "veb", "\u30d9\u30cd\u30ba\u30a8\u30e9 \u30dc\u30ea\u30d0\u30eb (1871\u20132008)" },
            { "vef", "\u30d9\u30cd\u30ba\u30a8\u30e9 \u30dc\u30ea\u30d0\u30eb (2008\u20132018)" },
            { "ves", "\u30d9\u30cd\u30ba\u30a8\u30e9 \u30dc\u30ea\u30d0\u30eb" },
            { "vnd", "\u30d9\u30c8\u30ca\u30e0 \u30c9\u30f3" },
            { "vnn", "\u30d9\u30c8\u30ca\u30e0 \u30c9\u30f3\uff081978\u20131985\uff09" },
            { "vuv", "\u30d0\u30cc\u30a2\u30c4 \u30d0\u30c4" },
            { "wst", "\u30b5\u30e2\u30a2 \u30bf\u30e9" },
            { "xaf", "\u4e2d\u592e\u30a2\u30d5\u30ea\u30ab CFA \u30d5\u30e9\u30f3" },
            { "xag", "\u9280" },
            { "xau", "\u91d1" },
            { "xba", "\u30e8\u30fc\u30ed\u30c3\u30d1\u6df7\u5408\u5358\u4f4d (EURCO)" },
            { "xbb", "\u30e8\u30fc\u30ed\u30c3\u30d1\u901a\u8ca8\u5358\u4f4d (EMU\u20136)" },
            { "xbc", "\u30e8\u30fc\u30ed\u30c3\u30d1\u52d8\u5b9a\u5358\u4f4d (EUA\u20139)" },
            { "xbd", "\u30e8\u30fc\u30ed\u30c3\u30d1\u52d8\u5b9a\u5358\u4f4d (EUA\u201317)" },
            { "xcd", "\u6771\u30ab\u30ea\u30d6 \u30c9\u30eb" },
            { "xdr", "\u7279\u5225\u5f15\u304d\u51fa\u3057\u6a29" },
            { "xeu", "\u30e8\u30fc\u30ed\u30c3\u30d1\u901a\u8ca8\u5358\u4f4d" },
            { "xfo", "\u30d5\u30e9\u30f3\u30b9\u91d1\u30d5\u30e9\u30f3" },
            { "xfu", "\u30d5\u30e9\u30f3\u30b9 \u30d5\u30e9\u30f3 (UIC)" },
            { "xof", "\u897f\u30a2\u30d5\u30ea\u30ab CFA \u30d5\u30e9\u30f3" },
            { "xpd", "\u30d1\u30e9\u30b8\u30a6\u30e0" },
            { "xpf", "CFP \u30d5\u30e9\u30f3" },
            { "xpt", "\u30d7\u30e9\u30c1\u30ca" },
            { "xre", "RINET\u57fa\u91d1" },
            { "xsu", "\u30b9\u30af\u30ec" },
            { "xts", "\u30c6\u30b9\u30c8\u7528\u901a\u8ca8\u30b3\u30fc\u30c9" },
            { "xua", "UA (\u30a2\u30d5\u30ea\u30ab\u958b\u767a\u9280\u884c)" },
            { "xxx", "\u4e0d\u660e\u307e\u305f\u306f\u7121\u52b9\u306a\u901a\u8ca8" },
            { "ydd", "\u30a4\u30a8\u30e1\u30f3 \u30c7\u30a3\u30ca\u30fc\u30eb" },
            { "yer", "\u30a4\u30a8\u30e1\u30f3 \u30ea\u30a2\u30eb" },
            { "yud", "\u30e6\u30fc\u30b4\u30b9\u30e9\u30d3\u30a2 \u30cf\u30fc\u30c9\u30fb\u30c7\u30a3\u30ca\u30fc\u30eb (1966\u20131990)" },
            { "yum", "\u30e6\u30fc\u30b4\u30b9\u30e9\u30d3\u30a2 \u30ce\u30d3\u30fb\u30c7\u30a3\u30ca\u30fc\u30eb (1994\u20132002)" },
            { "yun", "\u30e6\u30fc\u30b4\u30b9\u30e9\u30d3\u30a2 \u514c\u63db\u30c7\u30a3\u30ca\u30fc\u30eb (1990\u20131992)" },
            { "yur", "\u30e6\u30fc\u30b4\u30b9\u30e9\u30d3\u30a2 \u6539\u9769\u30c7\u30a3\u30ca\u30fc\u30eb\uff081992\u20131993\uff09" },
            { "zal", "\u5357\u30a2\u30d5\u30ea\u30ab \u30e9\u30f3\u30c9 (ZAL)" },
            { "zar", "\u5357\u30a2\u30d5\u30ea\u30ab \u30e9\u30f3\u30c9" },
            { "zmk", "\u30b6\u30f3\u30d3\u30a2 \u30af\u30ef\u30c1\u30e3 (1968\u20132012)" },
            { "zmw", "\u30b6\u30f3\u30d3\u30a2 \u30af\u30ef\u30c1\u30e3" },
            { "zrn", "\u30b6\u30a4\u30fc\u30eb \u65b0\u30b6\u30a4\u30fc\u30eb (1993\u20131998)" },
            { "zrz", "\u30b6\u30a4\u30fc\u30eb \u30b6\u30a4\u30fc\u30eb (1971\u20131993)" },
            { "zwd", "\u30b8\u30f3\u30d0\u30d6\u30a8 \u30c9\u30eb (1980\u20132008)" },
            { "zwl", "\u30b8\u30f3\u30d0\u30d6\u30a8 \u30c9\u30eb (2009)" },
            { "zwr", "\u30b7\u30f3\u30d0\u30d6\u30a8 \u30c9\u30eb\uff082008\uff09" },
        };
        return data;
    }
}
