/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_ff_Adlm extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_generic_DayNames = new String[] {
            "\ud83a\udd08\ud83a\udd2b\ud83a\udd2c\ud83a\udd26\ud83a\udd2d\ud83a\udd2a\ud83a\udd46\ud83a\udd2b",
            "\ud83a\udd00\ud83a\udd44\ud83a\udd29\ud83a\udd35\ud83a\udd32\ud83a\udd4b\ud83a\udd23\ud83a\udd2b",
            "\ud83a\udd03\ud83a\udd22\ud83a\udd31\ud83a\udd26\ud83a\udd22\ud83a\udd44\ud83a\udd2a\ud83a\udd2b",
            "\ud83a\udd10\ud83a\udd36\ud83a\udd2b\ud83a\udd27\ud83a\udd24\ud83a\udd22\ud83a\udd44\ud83a\udd2a\ud83a\udd2b",
            "\ud83a\udd10\ud83a\udd22\ud83a\udd44\ud83a\udd27\ud83a\udd22\ud83a\udd44\ud83a\udd32\ud83a\udd23\ud83a\udd2b",
            "\ud83a\udd03\ud83a\udd22\ud83a\udd31\ud83a\udd32\ud83a\udd23\ud83a\udd2b",
            "\ud83a\udd16\ud83a\udd2e\ud83a\udd2a\ud83a\udd26\ud83a\udd2d\ud83a\udd2a\ud83a\udd46\ud83a\udd2b",
        };
        final String[] metaValue_generic_DayAbbreviations = new String[] {
            "\ud83a\udd08\ud83a\udd2b\ud83a\udd2c",
            "\ud83a\udd00\ud83a\udd44\ud83a\udd29\ud83a\udd35",
            "\ud83a\udd03\ud83a\udd22\ud83a\udd26",
            "\ud83a\udd14\ud83a\udd2b\ud83a\udd27",
            "\ud83a\udd10\ud83a\udd22\ud83a\udd44\ud83a\udd27",
            "\ud83a\udd03\ud83a\udd22\ud83a\udd23",
            "\ud83a\udd16\ud83a\udd2e\ud83a\udd2a",
        };
        final String[] metaValue_generic_DayNarrows = new String[] {
            "\ud83a\udd08",
            "\ud83a\udd00\ud83a\udd44",
            "\ud83a\udd03",
            "\ud83a\udd14",
            "\ud83a\udd10",
            "\ud83a\udd03",
            "\ud83a\udd16",
        };
        final String[] metaValue_generic_QuarterNames = new String[] {
            "\ud83a\udd10\ud83a\udd51",
            "\ud83a\udd10\ud83a\udd52",
            "\ud83a\udd10\ud83a\udd53",
            "\ud83a\udd10\ud83a\udd54",
        };
        final String[] metaValue_generic_QuarterNarrows = new String[] {
            "\ud83a\udd51",
            "\ud83a\udd52",
            "\ud83a\udd53",
            "\ud83a\udd54",
        };
        final String[] metaValue_generic_AmPmMarkers = new String[] {
            "\ud83a\udd00\ud83a\udd0e",
            "\ud83a\udd07\ud83a\udd0e",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
        };
        final String[] metaValue_generic_narrow_AmPmMarkers = new String[] {
            "\ud83a\udd22",
            "\ud83a\udd29",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
        };
        final String[] metaValue_generic_TimePatterns = new String[] {
            "HH:mm:ss zzzz",
            "HH:mm:ss z",
            "HH:mm:ss",
            "HH:mm",
        };
        final String[] metaValue_java_time_generic_DatePatterns = new String[] {
            "EEEE d MMMM\u2e41 y G",
            "d MMMM\u2e41 y G",
            "d MMM\u2e41 y G",
            "d-M-y GGGGG",
        };
        final String[] metaValue_generic_DatePatterns = new String[] {
            "EEEE d MMMM\u2e41 y GGGG",
            "d MMMM\u2e41 y GGGG",
            "d MMM\u2e41 y GGGG",
            "d-M-y G",
        };
        final String metaValue_generic_DateFormatItem_yMMMEd = "E\u2e41 d MMM\u2e41 y";
        final String metaValue_generic_DateFormatItem_yMEd = "E\u2e41 d-M-y";
        final String metaValue_generic_DateFormatItem_yyyyMMMd = "d MMM\u2e41 y G";
        final String metaValue_generic_DateFormatItem_Gy = "y G";
        final String metaValue_generic_DateFormatItem_yyyyMMMEd = "E\u2e41 d MMM\u2e41 y G";
        final String metaValue_generic_DateFormatItem_yMMMd = "d MMM\u2e41 y";
        final String metaValue_generic_DateFormatItem_yw = "\ud83a\udd34\ud83a\udd2e\ud83a\udd32\ud83a\udd3c\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b w \ud83a\udd32\ud83a\udd23\ud83a\udd2b\ud83a\udd2a Y";
        final String metaValue_generic_DateFormatItem_yQQQ = "QQQ y";
        final String metaValue_generic_DateFormatItem_yyyyMd = "d-M-y GGGGG";
        final String metaValue_generic_DateFormatItem_yMMM = "MMM y";
        final String metaValue_generic_DateFormatItem_Md = "d-M";
        final String metaValue_generic_DateFormatItem_Ed = "E d";
        final String metaValue_generic_DateFormatItem_yyyyMMM = "MMM y G";
        final String metaValue_generic_DateFormatItem_MMMMd = "d MMMM";
        final String metaValue_generic_DateFormatItem_MEd = "E d-M";
        final String metaValue_generic_DateFormatItem_MMMEd = "E d MMM";
        final String metaValue_generic_DateFormatItem_yMd = "d-M-y";
        final String metaValue_generic_DateFormatItem_MMMd = "d MMM";
        final String metaValue_generic_DateFormatItem_yM = "M-y";
        final String metaValue_generic_DateFormatItem_yMMMM = "MMMM y";
        final String metaValue_generic_DateFormatItem_MMMMW = "\ud83a\udd34\ud83a\udd2e\ud83a\udd32\ud83a\udd3c\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b W \ud83a\udd32\ud83a\udd23\ud83a\udd2b\ud83a\udd2a MMMM";
        final String metaValue_generic_DateFormatItem_yQQQQ = "QQQQ y";
        final String[] metaValue_MonthNames = new String[] {
            "\ud83a\udd05\ud83a\udd2d\ud83a\udd45\ud83a\udd24\ud83a\udd2e",
            "\ud83a\udd15\ud83a\udd2e\ud83a\udd24\ud83a\udd3c\ud83a\udd2e",
            "\ud83a\udd10\ud83a\udd26\ud83a\udd2e\ud83a\udd45\ud83a\udd34\ud83a\udd2e",
            "\ud83a\udd05\ud83a\udd2b\ud83a\udd45\ud83a\udd3c\ud83a\udd2e",
            "\ud83a\udd01\ud83a\udd35\ud83a\udd45\ud83a\udd36\ud83a\udd2e",
            "\ud83a\udd11\ud83a\udd2e\ud83a\udd2a\ud83a\udd27\ud83a\udd2e",
            "\ud83a\udd03\ud83a\udd2e\ud83a\udd2a\ud83a\udd27\ud83a\udd2e",
            "\ud83a\udd14\ud83a\udd35\ud83a\udd33\ud83a\udd2e",
            "\ud83a\udd05\ud83a\udd2d\ud83a\udd24\ud83a\udd3c\ud83a\udd2e",
            "\ud83a\udd12\ud83a\udd22\ud83a\udd2a\ud83a\udd33\ud83a\udd2e",
            "\ud83a\udd14\ud83a\udd2e\ud83a\udd24\ud83a\udd2e",
            "\ud83a\udd04\ud83a\udd2e\ud83a\udd31\ud83a\udd3c\ud83a\udd2e",
            "",
        };
        final String[] metaValue_MonthNarrows = new String[] {
            "\ud83a\udd05",
            "\ud83a\udd15",
            "\ud83a\udd04",
            "\ud83a\udd05",
            "\ud83a\udd01",
            "\ud83a\udd11",
            "\ud83a\udd03",
            "\ud83a\udd14",
            "\ud83a\udd05",
            "\ud83a\udd12",
            "\ud83a\udd14",
            "\ud83a\udd04",
            "",
        };
        final String[] metaValue_Eras = new String[] {
            "\ud83a\udd00\ud83a\udd00\ud83a\udd0b",
            "\ud83a\udd07\ud83a\udd00\ud83a\udd0b",
        };
        final String[] metaValue_java_time_buddhist_long_Eras = new String[] {
            "BC",
            "\ud83a\udd18\ud83a\udd2d\ud83a\udd2a\ud83a\udd22\ud83a\udd24 \ud83a\udd04\ud83a\udd35\ud83a\udd45\ud83a\udd23\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e\ud83a\udd31\ud83a\udd22\ud83a\udd24",
        };
        final String[] metaValue_java_time_buddhist_Eras = new String[] {
            "BC",
            "\ud83a\udd18\ud83a\udd04",
        };
        final String[] metaValue_java_time_islamic_long_Eras = new String[] {
            "",
            "\ud83a\udd07\ud83a\udd0a",
        };
        final String metaValue_calendarname_gregorian = "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd2f\ud83a\udd2d\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd18\ud83a\udd2b\ud83a\udd2a\ud83a\udd3a\ud83a\udd2e\ud83a\udd2a\ud83a\udd2d\ud83a\udd34\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e";
        final Object[][] data = new Object[][] {
            { "islamic.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "MonthNames", metaValue_MonthNames },
            { "generic.DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "japanese.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "buddhist.narrow.Eras", metaValue_java_time_buddhist_Eras },
            { "roc.QuarterNames", metaValue_generic_QuarterNames },
            { "buddhist.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "islamic.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "islamic.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "generic.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "roc.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "islamic-civil.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "calendarname.islamic-civil", "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd2f\ud83a\udd2d\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd02\ud83a\udd2d\ud83a\udd27\ud83a\udd24\ud83a\udd22\ud83a\udd44\ud83a\udd25\ud83a\udd34\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e (\ud83a\udd22\ud83a\udd24\ud83a\udd46\ud83a\udd35\ud83a\udd31\ud83a\udd22\ud83a\udd24, \ud83a\udd2c\ud83a\udd2b\ud83a\udd31\ud83a\udd32\ud83a\udd4b\ud83a\udd23\ud83a\udd2e \ud83a\udd32\ud83a\udd4b\ud83a\udd26\ud83a\udd2b\ud83a\udd2f\ud83a\udd46\ud83a\udd22\ud83a\udd44\ud83a\udd33\ud83a\udd35)" },
            { "islamic-umalqura.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "japanese.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "islamic-umalqura.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "generic.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "islamic-civil.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "japanese.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "islamic.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "timezone.gmtZeroFormat", "\ud83a\udd11\ud83a\udd16\ud83a\udd18" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "islamic-umalqura.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "roc.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "islamic.DayNames", metaValue_generic_DayNames },
            { "islamic-umalqura.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "buddhist.MonthAbbreviations", metaValue_MonthNames },
            { "generic.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "DateTimePatterns",
                new String[] {
                    "{1} \ud83a\udd09 {0}",
                    "{1} \ud83a\udd09 {0}",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    "\u2e41",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "\ud83a\udd0f\ud83a\udd2e\ud83a\udd08",
                    "",
                    "",
                }
            },
            { "japanese.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "japanese.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "islamic-umalqura.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "field.minute", "\ud83a\udd38\ud83a\udd2e\ud83a\udd36\ud83a\udd2e\ud83a\udd25\ud83a\udd22\ud83a\udd44\ud83a\udd2a\ud83a\udd2b" },
            { "japanese.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "buddhist.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "roc.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "islamic-civil.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.MonthNames",
                new String[] {
                    "\ud83a\udd14\ud83a\udd2e\ud83a\udd25\ud83a\udd26\ud83a\udd2b\ud83a\udd32\ud83a\udd3c\ud83a\udd2b",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd26\ud83a\udd46\ud83a\udd2e\ud83a\udd2a\ud83a\udd23\ud83a\udd35-\ud83a\udd06\ud83a\udd22\ud83a\udd2a\ud83a\udd22\ud83a\udd32",
                    "\ud83a\udd06\ud83a\udd22\ud83a\udd2a\ud83a\udd22\ud83a\udd32",
                    "\ud83a\udd03\ud83a\udd2d\ud83a\udd25\ud83a\udd28\ud83a\udd22\ud83a\udd2a\ud83a\udd22\ud83a\udd32",
                    "\ud83a\udd04\ud83a\udd22\ud83a\udd28\ud83a\udd46\ud83a\udd22\ud83a\udd2a\ud83a\udd22\ud83a\udd32",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd26\ud83a\udd46\ud83a\udd2e\ud83a\udd2a\ud83a\udd23\ud83a\udd35-\ud83a\udd08\ud83a\udd22\ud83a\udd44\ud83a\udd36\ud83a\udd2d\ud83a\udd26\ud83a\udd2d",
                    "\ud83a\udd08\ud83a\udd22\ud83a\udd44\ud83a\udd36\ud83a\udd2d\ud83a\udd26\ud83a\udd2d",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd26\ud83a\udd46\ud83a\udd2e\ud83a\udd2a\ud83a\udd23\ud83a\udd35-\ud83a\udd05\ud83a\udd35\ud83a\udd45\ud83a\udd25\ud83a\udd22\ud83a\udd34\ud83a\udd2b\ud83a\udd45",
                    "\ud83a\udd05\ud83a\udd35\ud83a\udd45\ud83a\udd25\ud83a\udd22\ud83a\udd34\ud83a\udd2b\ud83a\udd45",
                    "\ud83a\udd14\ud83a\udd35\ud83a\udd45\ud83a\udd24\ud83a\udd23\ud83a\udd22\ud83a\udd44\ud83a\udd32\ud83a\udd4b\ud83a\udd23\ud83a\udd35",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd26\ud83a\udd46\ud83a\udd2e\ud83a\udd2a\ud83a\udd23\ud83a\udd35-\ud83a\udd01\ud83a\udd2e\ud83a\udd32\ud83a\udd33\ud83a\udd2d\ud83a\udd32",
                    "\ud83a\udd01\ud83a\udd35\ud83a\udd32\ud83a\udd33\ud83a\udd2d\ud83a\udd32",
                    "",
                }
            },
            { "islamic-civil.DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "japanese.QuarterNarrows", metaValue_generic_QuarterNarrows },
            { "japanese.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "buddhist.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "islamic.DatePatterns", metaValue_generic_DatePatterns },
            { "generic.DateFormatItem.yyyyQQQQ", "QQQQ y G" },
            { "roc.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "field.second", "\ud83a\udd33\ud83a\udd2d\ud83a\udd32\ud83a\udd30\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b" },
            { "islamic.MonthNarrows",
                new String[] {
                    "\ud83a\udd51",
                    "\ud83a\udd52",
                    "\ud83a\udd53",
                    "\ud83a\udd54",
                    "\ud83a\udd55",
                    "\ud83a\udd56",
                    "\ud83a\udd57",
                    "\ud83a\udd58",
                    "\ud83a\udd59",
                    "\ud83a\udd51\ud83a\udd50",
                    "\ud83a\udd51\ud83a\udd51",
                    "\ud83a\udd51\ud83a\udd52",
                    "",
                }
            },
            { "roc.DatePatterns", metaValue_generic_DatePatterns },
            { "buddhist.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "islamic-civil.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "japanese.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "calendarname.islamic", "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd02\ud83a\udd2d\ud83a\udd27\ud83a\udd24\ud83a\udd22\ud83a\udd44\ud83a\udd25\ud83a\udd34\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e" },
            { "islamic-civil.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "generic.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "roc.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "buddhist.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "islamic.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "buddhist.TimePatterns", metaValue_generic_TimePatterns },
            { "islamic-civil.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "buddhist.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "generic.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "standalone.MonthAbbreviations",
                new String[] {
                    "\ud83a\udd05\ud83a\udd2d\ud83a\udd45\ud83a\udd24",
                    "\ud83a\udd15\ud83a\udd2e\ud83a\udd24",
                    "\ud83a\udd10\ud83a\udd26\ud83a\udd2e\ud83a\udd45\ud83a\udd34",
                    "\ud83a\udd05\ud83a\udd2b\ud83a\udd45\ud83a\udd3c",
                    "\ud83a\udd01\ud83a\udd35\ud83a\udd45\ud83a\udd36",
                    "\ud83a\udd11\ud83a\udd2e\ud83a\udd2a",
                    "\ud83a\udd03\ud83a\udd2e\ud83a\udd2a",
                    "\ud83a\udd14\ud83a\udd35\ud83a\udd33",
                    "\ud83a\udd05\ud83a\udd2d\ud83a\udd24",
                    "\ud83a\udd12\ud83a\udd22\ud83a\udd2a",
                    "\ud83a\udd14\ud83a\udd2e\ud83a\udd24",
                    "\ud83a\udd04\ud83a\udd2e\ud83a\udd31",
                    "",
                }
            },
            { "timezone.regionFormat", "{0} \ud83a\udd11\ud83a\udd2d\ud83a\udd36\ud83a\udd2e\ud83a\udd45\ud83a\udd2a\ud83a\udd2b" },
            { "islamic-civil.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "roc.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "java.time.buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "islamic-umalqura.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "islamic.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "TimePatterns", metaValue_generic_TimePatterns },
            { "islamic.DayNarrows", metaValue_generic_DayNarrows },
            { "islamic-civil.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "islamic-umalqura.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "generic.DayNarrows", metaValue_generic_DayNarrows },
            { "roc.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "generic.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "buddhist.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "islamic.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "islamic-civil.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "roc.DayNames", metaValue_generic_DayNames },
            { "generic.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "QuarterNarrows", metaValue_generic_QuarterNarrows },
            { "standalone.QuarterNarrows", metaValue_generic_QuarterNarrows },
            { "islamic.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "roc.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "roc.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "japanese.MonthAbbreviations", metaValue_MonthNames },
            { "DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "generic.DayNames", metaValue_generic_DayNames },
            { "islamic.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "java.time.islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "generic.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "generic.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "japanese.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "roc.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "buddhist.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "japanese.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "java.time.buddhist.Eras", metaValue_java_time_buddhist_Eras },
            { "generic.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "islamic.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "generic.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "islamic-umalqura.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "islamic-civil.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "islamic-umalqura.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "japanese.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "DayNames", metaValue_generic_DayNames },
            { "islamic-umalqura.DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "buddhist.DatePatterns", metaValue_generic_DatePatterns },
            { "buddhist.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "islamic-umalqura.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "roc.MonthNames", metaValue_MonthNames },
            { "roc.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "generic.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "islamic-civil.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "islamic.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "roc.DayNarrows", metaValue_generic_DayNarrows },
            { "generic.DateFormatItem.yyyyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "islamic-umalqura.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "buddhist.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "japanese.DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "generic.DateFormatItem.yyyyMEd", "E\u2e41 d-M-y GGGGG" },
            { "generic.QuarterNames", metaValue_generic_QuarterNames },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "buddhist.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "islamic.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "java.time.buddhist.narrow.Eras", metaValue_java_time_buddhist_Eras },
            { "timezone.regionFormat.daylight", "{0} \ud83a\udd10\ud83a\udd36\ud83a\udd22\ud83a\udd25\ud83a\udd32\ud83a\udd23\ud83a\udd2d \ud83a\udd15\ud83a\udd2b\ud83a\udd45\ud83a\udd2f\ud83a\udd35" },
            { "DatePatterns",
                new String[] {
                    "EEEE d MMMM\u2e41 y",
                    "d MMMM\u2e41 y",
                    "d MMM\u2e41 y",
                    "d-M-y",
                }
            },
            { "islamic.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "islamic.TimePatterns", metaValue_generic_TimePatterns },
            { "DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "standalone.DayNames", metaValue_generic_DayNames },
            { "MonthAbbreviations", metaValue_MonthNames },
            { "generic.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "islamic-umalqura.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "buddhist.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "islamic-civil.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "islamic-umalqura.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "islamic-umalqura.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "japanese.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
            { "field.year", "\ud83a\udd38\ud83a\udd2d\ud83a\udd3c\ud83a\udd22\ud83a\udd44\ud83a\udd32\ud83a\udd23\ud83a\udd2b" },
            { "generic.DatePatterns", metaValue_generic_DatePatterns },
            { "islamic-civil.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "islamic.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "japanese.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "timezone.gmtFormat", "\ud83a\udd11\ud83a\udd16\ud83a\udd18{0}" },
            { "java.time.japanese.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "generic.QuarterNarrows", metaValue_generic_QuarterNarrows },
            { "generic.DateFormatItem.y", metaValue_generic_DateFormatItem_Gy },
            { "roc.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "islamic-civil.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "japanese.TimePatterns", metaValue_generic_TimePatterns },
            { "narrow.Eras", metaValue_Eras },
            { "buddhist.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "timezone.regionFormat.standard", "{0} \ud83a\udd11\ud83a\udd2d\ud83a\udd36\ud83a\udd2e\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd16\ud83a\udd22\ud83a\udd31\ud83a\udd2a\ud83a\udd2d\ud83a\udd3c\ud83a\udd35\ud83a\udd32\ud83a\udd4b\ud83a\udd23\ud83a\udd2b" },
            { "DefaultNumberingSystem", "adlm" },
            { "japanese.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "calendarname.japanese", "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd2f\ud83a\udd2d\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd14\ud83a\udd22\ud83a\udd44\ud83a\udd28\ud83a\udd2e\ud83a\udd32\ud83a\udd2d\ud83a\udd32\ud83a\udd33\ud83a\udd2e" },
            { "japanese.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "japanese.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "islamic-civil.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "islamic-umalqura.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "roc.MonthAbbreviations", metaValue_MonthNames },
            { "generic.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "java.time.islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "long.Eras",
                new String[] {
                    "\ud83a\udd00\ud83a\udd23\ud83a\udd2e \ud83a\udd00\ud83a\udd32\ud83a\udd46\ud83a\udd22\ud83a\udd26\ud83a\udd2d \ud83a\udd0b\ud83a\udd45\ud83a\udd27\ud83a\udd22\ud83a\udd44",
                    "\ud83a\udd07\ud83a\udd22\ud83a\udd44\ud83a\udd31\ud83a\udd2e \ud83a\udd00\ud83a\udd32\ud83a\udd46\ud83a\udd22\ud83a\udd26\ud83a\udd2d \ud83a\udd0b\ud83a\udd45\ud83a\udd27\ud83a\udd22\ud83a\udd44",
                }
            },
            { "roc.QuarterNarrows", metaValue_generic_QuarterNarrows },
            { "DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "japanese.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "generic.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "islamic-umalqura.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "japanese.DatePatterns", metaValue_generic_DatePatterns },
            { "roc.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.DayNames", metaValue_generic_DayNames },
            { "field.era", "\ud83a\udd3a\ud83a\udd2d\ud83a\udd2a\ud83a\udd22\ud83a\udd24" },
            { "generic.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "field.dayperiod", "\ud83a\udd00\ud83a\udd0e/\ud83a\udd07\ud83a\udd0e" },
            { "buddhist.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "islamic.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "japanese.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "roc.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "japanese.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "calendarname.roc", "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd2f\ud83a\udd2d\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd18\ud83a\udd2b\ud83a\udd32\ud83a\udd23\ud83a\udd2d\ud83a\udd34\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e \ud83a\udd05\ud83a\udd2d\ud83a\udd45\ud83a\udd32" },
            { "generic.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "islamic.DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "generic.DateFormatItem.yyyyM", "M-y GGGGG" },
            { "generic.DateFormatItem.yyyyMMMM", "MMMM y G" },
            { "field.month", "\ud83a\udd24\ud83a\udd2b\ud83a\udd31\ud83a\udd2a\ud83a\udd35" },
            { "buddhist.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "generic.DateFormatItem.yyyyQQQ", "QQQ y G" },
            { "DayNarrows", metaValue_generic_DayNarrows },
            { "islamic.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "islamic.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "java.time.generic.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "generic.TimePatterns", metaValue_generic_TimePatterns },
            { "roc.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "japanese.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "islamic-umalqura.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "generic.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "buddhist.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "buddhist.QuarterNarrows", metaValue_generic_QuarterNarrows },
            { "roc.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "roc.DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "islamic.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "standalone.QuarterNames",
                new String[] {
                    "\ud83a\udd10\ud83a\udd22\ud83a\udd34\ud83a\udd29\ud83a\udd2d\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd51\ud83a\udd2a\ud83a\udd2b",
                    "\ud83a\udd10\ud83a\udd22\ud83a\udd34\ud83a\udd29\ud83a\udd2d\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd52\ud83a\udd2a\ud83a\udd2b",
                    "\ud83a\udd10\ud83a\udd22\ud83a\udd34\ud83a\udd29\ud83a\udd2d\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd53\ud83a\udd2a\ud83a\udd2b",
                    "\ud83a\udd10\ud83a\udd22\ud83a\udd34\ud83a\udd29\ud83a\udd2d\ud83a\udd45\ud83a\udd2a\ud83a\udd2b \ud83a\udd54\ud83a\udd2a\ud83a\udd2b",
                }
            },
            { "standalone.DayNarrows", metaValue_generic_DayNarrows },
            { "roc.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "generic.DateTimePatterns",
                new String[] {
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "roc.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "islamic-civil.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "generic.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "japanese.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "roc.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "field.zone", "\ud83a\udd32\ud83a\udd36\ud83a\udd22\ud83a\udd25\ud83a\udd23\ud83a\udd2d \ud83a\udd32\ud83a\udd2e\ud83a\udd33\ud83a\udd46\ud83a\udd35\ud83a\udd45\ud83a\udd2a\ud83a\udd2b" },
            { "japanese.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "generic.DateFormatItem.yyyy", metaValue_generic_DateFormatItem_Gy },
            { "islamic-civil.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "japanese.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "buddhist.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "buddhist.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "roc.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "Eras", metaValue_Eras },
            { "DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "islamic-civil.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "islamic.QuarterNames", metaValue_generic_QuarterNames },
            { "islamic.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "generic.DateFormatItem.yyyyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "buddhist.DateFormatItem.Gy", metaValue_generic_DateFormatItem_Gy },
            { "islamic.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "islamic-umalqura.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "japanese.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "java.time.islamic.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "field.weekday", "\ud83a\udd3b\ud83a\udd22\ud83a\udd24\ud83a\udd22\ud83a\udd44\ud83a\udd32\ud83a\udd23\ud83a\udd2b \ud83a\udd32\ud83a\udd23\ud83a\udd2b\ud83a\udd2a \ud83a\udd34\ud83a\udd2e\ud83a\udd32\ud83a\udd3c\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b" },
            { "generic.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "generic.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "islamic.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "buddhist.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "roc.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "roc.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "islamic-umalqura.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "japanese.QuarterNames", metaValue_generic_QuarterNames },
            { "islamic-umalqura.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "buddhist.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "generic.DateFormatItem.yyyyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "generic.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "islamic-civil.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "islamic-civil.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "islamic.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "buddhist.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "japanese.DayNames", metaValue_generic_DayNames },
            { "generic.DateFormatItem.yyyyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "islamic-umalqura.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "japanese.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "roc.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "generic.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "japanese.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "buddhist.Eras", metaValue_java_time_buddhist_Eras },
            { "field.week", "\ud83a\udd34\ud83a\udd2e\ud83a\udd32\ud83a\udd3c\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b" },
            { "generic.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "roc.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "generic.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "islamic-civil.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "buddhist.QuarterNames", metaValue_generic_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_generic_QuarterNarrows },
            { "roc.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "buddhist.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "java.time.roc.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "islamic.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "buddhist.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "islamic.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "field.hour", "\ud83a\udd32\ud83a\udd36\ud83a\udd22\ud83a\udd25\ud83a\udd23\ud83a\udd2d" },
            { "islamic.MonthAbbreviations",
                new String[] {
                    "\ud83a\udd14\ud83a\udd2e\ud83a\udd26.",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd28.",
                    "\ud83a\udd06\ud83a\udd22\ud83a\udd2a.",
                    "\ud83a\udd03\ud83a\udd2d\ud83a\udd28.",
                    "\ud83a\udd04\ud83a\udd22\ud83a\udd28.",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd2a.",
                    "\ud83a\udd08\ud83a\udd22\ud83a\udd36.",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd27.",
                    "\ud83a\udd05\ud83a\udd35\ud83a\udd25.",
                    "\ud83a\udd14\ud83a\udd35\ud83a\udd24.",
                    "\ud83a\udd05\ud83a\udd22\ud83a\udd23.",
                    "\ud83a\udd01\ud83a\udd2e\ud83a\udd32.",
                    "",
                }
            },
            { "islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "calendarname.buddhist", "\ud83a\udd19\ud83a\udd22\ud83a\udd24\ud83a\udd2f\ud83a\udd2d\ud83a\udd25\ud83a\udd2b\ud83a\udd2a\ud83a\udd2b \ud83a\udd04\ud83a\udd35\ud83a\udd45\ud83a\udd23\ud83a\udd22\ud83a\udd34\ud83a\udd22\ud83a\udd32\ud83a\udd33\ud83a\udd2e" },
            { "buddhist.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "generic.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "latn.NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "\u00a4\u00a0#,##0.00",
                    "#,##0%",
                    "",
                }
            },
            { "buddhist.DayNarrows", metaValue_generic_DayNarrows },
            { "java.time.islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.DayNarrows", metaValue_generic_DayNarrows },
            { "QuarterNames", metaValue_generic_QuarterNames },
            { "roc.TimePatterns", metaValue_generic_TimePatterns },
            { "buddhist.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "roc.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
        };
        return data;
    }
}
