/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pa extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "\u0a28\u0a3e\u0a09\u0a30\u0a42";
        final String metaValue_TR = "\u0a24\u0a41\u0a30\u0a15\u0a40";
        final String metaValue_ar = "\u0a05\u0a30\u0a2c\u0a40";
        final String metaValue_bn = "\u0a2c\u0a70\u0a17\u0a3e\u0a32\u0a40";
        final String metaValue_bo = "\u0a24\u0a3f\u0a71\u0a2c\u0a24\u0a40";
        final String metaValue_el = "\u0a2f\u0a42\u0a28\u0a3e\u0a28\u0a40";
        final String metaValue_gu = "\u0a17\u0a41\u0a1c\u0a30\u0a3e\u0a24\u0a40";
        final String metaValue_he = "\u0a39\u0a3f\u0a2c\u0a30\u0a42";
        final String metaValue_hy = "\u0a05\u0a30\u0a2e\u0a40\u0a28\u0a40\u0a06\u0a08";
        final String metaValue_ja = "\u0a1c\u0a2a\u0a3e\u0a28\u0a40";
        final String metaValue_ka = "\u0a1c\u0a3e\u0a30\u0a1c\u0a40\u0a06\u0a08";
        final String metaValue_km = "\u0a16\u0a2e\u0a47\u0a30";
        final String metaValue_kn = "\u0a15\u0a70\u0a28\u0a5c";
        final String metaValue_ko = "\u0a15\u0a4b\u0a30\u0a40\u0a06\u0a08";
        final String metaValue_la = "\u0a32\u0a3e\u0a24\u0a40\u0a28\u0a40";
        final String metaValue_lo = "\u0a32\u0a3e\u0a13";
        final String metaValue_ml = "\u0a2e\u0a32\u0a3f\u0a06\u0a32\u0a2e";
        final String metaValue_or = "\u0a09\u0a5c\u0a40\u0a06";
        final String metaValue_si = "\u0a38\u0a3f\u0a70\u0a39\u0a3e\u0a32\u0a3e";
        final String metaValue_ta = "\u0a24\u0a2e\u0a3f\u0a32";
        final String metaValue_te = "\u0a24\u0a47\u0a32\u0a17\u0a42";
        final String metaValue_th = "\u0a25\u0a3e\u0a08";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0a15\u0a32\u0a4b\u0a17\u0a28\u0a40\u0a05\u0a28" },
            { "mwl", "\u0a2e\u0a3f\u0a30\u0a3e\u0a02\u0a21\u0a40" },
            { "Zsym", "\u0a1a\u0a3f\u0a70\u0a28\u0a4d\u0a39" },
            { "Zsye", "\u0a07\u0a2e\u0a4b\u0a1c\u0a40" },
            { "ccp", "\u0a1a\u0a15\u0a2e\u0a3e" },
            { "egy", "\u0a2a\u0a41\u0a30\u0a3e\u0a24\u0a28 \u0a2e\u0a3f\u0a38\u0a30\u0a40" },
            { "raj", "\u0a30\u0a3e\u0a1c\u0a38\u0a25\u0a3e\u0a28\u0a40" },
            { "tem", "\u0a1f\u0a3f\u0a2e\u0a28\u0a47" },
            { "teo", "\u0a1f\u0a47\u0a38\u0a4b" },
            { "rap", "\u0a30\u0a3e\u0a2a\u0a3e\u0a28\u0a41\u0a08" },
            { "AC", "\u0a05\u0a38\u0a48\u0a02\u0a38\u0a3c\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "rar", "\u0a30\u0a3e\u0a30\u0a4b\u0a24\u0a4b\u0a02\u0a17\u0a28" },
            { "tet", "\u0a1f\u0a47\u0a1f\u0a2e" },
            { "AD", "\u0a05\u0a70\u0a21\u0a4b\u0a30\u0a3e" },
            { "AE", "\u0a38\u0a70\u0a2f\u0a41\u0a15\u0a24 \u0a05\u0a30\u0a2c \u0a05\u0a2e\u0a40\u0a30\u0a3e\u0a24" },
            { "nl_BE", "\u0a2b\u0a32\u0a48\u0a2e\u0a3f\u0a38\u0a3c" },
            { "AF", "\u0a05\u0a2b\u0a3c\u0a17\u0a3e\u0a28\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "AG", "\u0a10\u0a02\u0a1f\u0a40\u0a17\u0a41\u0a06 \u0a05\u0a24\u0a47 \u0a2c\u0a3e\u0a30\u0a2c\u0a41\u0a21\u0a3e" },
            { "type.ca.ethiopic", "\u0a07\u0a25\u0a40\u0a13\u0a2a\u0a3f\u0a15 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "AI", "\u0a05\u0a70\u0a17\u0a41\u0a07\u0a32\u0a3e" },
            { "AL", "\u0a05\u0a32\u0a2c\u0a3e\u0a28\u0a40\u0a06" },
            { "AM", "\u0a05\u0a30\u0a2e\u0a40\u0a28\u0a40\u0a06" },
            { "AO", "\u0a05\u0a70\u0a17\u0a4b\u0a32\u0a3e" },
            { "AQ", "\u0a05\u0a70\u0a1f\u0a3e\u0a30\u0a15\u0a1f\u0a3f\u0a15\u0a3e" },
            { "AR", "\u0a05\u0a30\u0a1c\u0a28\u0a1f\u0a40\u0a28\u0a3e" },
            { "AS", "\u0a05\u0a2e\u0a48\u0a30\u0a40\u0a15\u0a28 \u0a38\u0a2e\u0a4b\u0a06" },
            { "AT", "\u0a06\u0a38\u0a1f\u0a30\u0a40\u0a06" },
            { "AU", "\u0a06\u0a38\u0a1f\u0a4d\u0a30\u0a47\u0a32\u0a40\u0a06" },
            { "AW", "\u0a05\u0a30\u0a42\u0a2c\u0a3e" },
            { "en_US", "\u0a05\u0a70\u0a17\u0a30\u0a47\u0a1c\u0a3c\u0a40 (\u0a05\u0a2e\u0a30\u0a40\u0a15\u0a40)" },
            { "AX", "\u0a05\u0a32\u0a48\u0a02\u0a21 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "AZ", "\u0a05\u0a1c\u0a3c\u0a30\u0a2c\u0a3e\u0a08\u0a1c\u0a3e\u0a28" },
            { "BA", "\u0a2c\u0a4b\u0a38\u0a28\u0a40\u0a06 \u0a05\u0a24\u0a47 \u0a39\u0a30\u0a1c\u0a3c\u0a47\u0a17\u0a4b\u0a35\u0a40\u0a28\u0a3e" },
            { "BB", "\u0a2c\u0a3e\u0a30\u0a2c\u0a3e\u0a21\u0a4b\u0a38" },
            { "ceb", "\u0a38\u0a40\u0a2c\u0a42\u0a06\u0a28\u0a4b" },
            { "BD", "\u0a2c\u0a70\u0a17\u0a32\u0a3e\u0a26\u0a47\u0a38\u0a3c" },
            { "kum", "\u0a15\u0a41\u0a2e\u0a40\u0a15" },
            { "BE", "\u0a2c\u0a48\u0a32\u0a1c\u0a40\u0a05\u0a2e" },
            { "BF", "\u0a2c\u0a41\u0a30\u0a15\u0a40\u0a28\u0a3e \u0a2b\u0a3c\u0a3e\u0a38\u0a4b" },
            { "BG", "\u0a2c\u0a41\u0a32\u0a17\u0a3e\u0a30\u0a40\u0a06" },
            { "BH", "\u0a2c\u0a39\u0a3f\u0a30\u0a40\u0a28" },
            { "BI", "\u0a2c\u0a41\u0a30\u0a41\u0a70\u0a21\u0a40" },
            { "BJ", "\u0a2c\u0a47\u0a28\u0a3f\u0a28" },
            { "BL", "\u0a38\u0a47\u0a02\u0a1f \u0a2c\u0a3e\u0a30\u0a25\u0a47\u0a32\u0a47\u0a2e\u0a40" },
            { "BM", "\u0a2c\u0a30\u0a2e\u0a42\u0a21\u0a3e" },
            { "myv", "\u0a07\u0a30\u0a1c\u0a3c\u0a40\u0a06" },
            { "BN", "\u0a2c\u0a30\u0a42\u0a28\u0a47\u0a08" },
            { "BO", "\u0a2c\u0a4b\u0a32\u0a40\u0a35\u0a40\u0a06" },
            { "BQ", "\u0a15\u0a48\u0a30\u0a47\u0a2c\u0a40\u0a06\u0a08 \u0a28\u0a40\u0a26\u0a30\u0a32\u0a48\u0a02\u0a21" },
            { "BR", "\u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a40\u0a32" },
            { "BS", "\u0a2c\u0a39\u0a3e\u0a2e\u0a3e\u0a38" },
            { "xog", "\u0a38\u0a4b\u0a17\u0a3e" },
            { "BT", "\u0a2d\u0a42\u0a1f\u0a3e\u0a28" },
            { "BV", "\u0a2c\u0a4c\u0a35\u0a47\u0a1f \u0a1f\u0a3e\u0a2a\u0a42" },
            { "BW", "\u0a2c\u0a4b\u0a24\u0a38\u0a35\u0a3e\u0a28\u0a3e" },
            { "BY", "\u0a2c\u0a47\u0a32\u0a3e\u0a30\u0a42\u0a38" },
            { "BZ", "\u0a2c\u0a47\u0a32\u0a40\u0a1c\u0a3c" },
            { "type.ca.persian", "\u0a2b\u0a3c\u0a3e\u0a30\u0a38\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.nu.hebr", "\u0a39\u0a3f\u0a2c\u0a30\u0a42 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "CA", "\u0a15\u0a48\u0a28\u0a47\u0a21\u0a3e" },
            { "CC", "\u0a15\u0a4b\u0a15\u0a4b\u0a38 (\u0a15\u0a40\u0a32\u0a3f\u0a70\u0a17) \u0a1f\u0a3e\u0a2a\u0a42" },
            { "mzn", "\u0a2e\u0a47\u0a1c\u0a3c\u0a48\u0a02\u0a21\u0a30\u0a3e\u0a28\u0a40" },
            { "CD", "\u0a15\u0a3e\u0a02\u0a17\u0a4b - \u0a15\u0a3f\u0a70\u0a38\u0a3c\u0a3e\u0a38\u0a3e" },
            { "CF", "\u0a15\u0a47\u0a02\u0a26\u0a30\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a40 \u0a17\u0a23\u0a30\u0a3e\u0a1c" },
            { "CG", "\u0a15\u0a3e\u0a02\u0a17\u0a4b - \u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a3e\u0a35\u0a3f\u0a32\u0a47" },
            { "CH", "\u0a38\u0a35\u0a3f\u0a1f\u0a1c\u0a3c\u0a30\u0a32\u0a48\u0a02\u0a21" },
            { "CI", "\u0a15\u0a4b\u0a1f \u0a21\u0a40\u0a35\u0a4b\u0a06\u0a30" },
            { "CK", "\u0a15\u0a41\u0a71\u0a15 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "CL", "\u0a1a\u0a3f\u0a32\u0a40" },
            { "CM", "\u0a15\u0a48\u0a2e\u0a30\u0a42\u0a28" },
            { "CN", "\u0a1a\u0a40\u0a28" },
            { "CO", "\u0a15\u0a4b\u0a32\u0a70\u0a2c\u0a40\u0a06" },
            { "CP", "\u0a15\u0a32\u0a3f\u0a71\u0a2a\u0a30\u0a1f\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "CR", "\u0a15\u0a4b\u0a38\u0a1f\u0a3e \u0a30\u0a40\u0a15\u0a3e" },
            { "CU", "\u0a15\u0a3f\u0a0a\u0a2c\u0a3e" },
            { "CV", "\u0a15\u0a47\u0a2a \u0a35\u0a30\u0a21\u0a47" },
            { "CW", "\u0a15\u0a41\u0a30\u0a3e\u0a15\u0a3e\u0a13" },
            { "CX", "\u0a15\u0a4d\u0a30\u0a3f\u0a38\u0a2e\u0a3f\u0a38 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "CY", "\u0a38\u0a3e\u0a07\u0a2a\u0a4d\u0a30\u0a38" },
            { "CZ", "\u0a1a\u0a48\u0a15\u0a40\u0a06" },
            { "eka", "\u0a0f\u0a15\u0a3e\u0a1c\u0a41\u0a15" },
            { "DE", "\u0a1c\u0a30\u0a2e\u0a28\u0a40" },
            { "ace", "\u0a05\u0a1a\u0a40\u0a28\u0a40" },
            { "cgg", "\u0a1a\u0a40\u0a17\u0a3e" },
            { "DG", "\u0a21\u0a40\u0a07\u0a17\u0a4b \u0a17\u0a3e\u0a30\u0a38\u0a40\u0a06" },
            { "type.nu.deva", "\u0a26\u0a47\u0a35\u0a28\u0a3e\u0a17\u0a30\u0a40 \u0a05\u0a70\u0a15" },
            { "DJ", "\u0a1c\u0a3c\u0a40\u0a2c\u0a42\u0a24\u0a40" },
            { "DK", "\u0a21\u0a48\u0a28\u0a2e\u0a3e\u0a30\u0a15" },
            { "ach", "\u0a05\u0a15\u0a4b\u0a32\u0a40" },
            { "Brai", "\u0a2c\u0a30\u0a47\u0a32" },
            { "DM", "\u0a21\u0a4b\u0a2e\u0a40\u0a28\u0a3f\u0a15\u0a3e" },
            { "type.nu.armnlow", "\u0a06\u0a30\u0a2e\u0a40\u0a28\u0a40\u0a05\u0a28 \u0a32\u0a4b\u0a05\u0a30\u0a15\u0a47\u0a38 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "DO", "\u0a21\u0a4b\u0a2e\u0a40\u0a28\u0a3f\u0a15\u0a3e\u0a08 \u0a17\u0a23\u0a30\u0a3e\u0a1c" },
            { "gor", "\u0a17\u0a4b\u0a30\u0a4b\u0a02\u0a24\u0a3e\u0a32\u0a4b" },
            { "zun", "\u0a1c\u0a3c\u0a42\u0a28\u0a40" },
            { "tig", "\u0a1f\u0a3f\u0a17\u0a30\u0a3e" },
            { "DZ", "\u0a05\u0a32\u0a1c\u0a40\u0a30\u0a40\u0a06" },
            { "pag", "\u0a2a\u0a70\u0a17\u0a3e\u0a38\u0a40\u0a28\u0a3e\u0a28" },
            { "EA", "\u0a38\u0a3f\u0a13\u0a1f\u0a3e \u0a05\u0a24\u0a47 \u0a2e\u0a47\u0a32\u0a3f\u0a71\u0a32\u0a3e" },
            { "pam", "\u0a2a\u0a48\u0a02\u0a2a\u0a3e\u0a02\u0a17\u0a3e" },
            { "EC", "\u0a07\u0a15\u0a35\u0a47\u0a21\u0a4b\u0a30" },
            { "pap", "\u0a2a\u0a3e\u0a2a\u0a3f\u0a06\u0a2e\u0a48\u0a02\u0a1f\u0a4b" },
            { "ada", "\u0a05\u0a21\u0a3e\u0a02\u0a17\u0a2e\u0a47" },
            { "EE", "\u0a07\u0a38\u0a1f\u0a4b\u0a28\u0a40\u0a06" },
            { "EG", "\u0a2e\u0a3f\u0a38\u0a30" },
            { "EH", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a38\u0a39\u0a3e\u0a30\u0a3e" },
            { "pau", "\u0a2a\u0a32\u0a3e\u0a0a\u0a35\u0a40" },
            { "chk", "\u0a1a\u0a42\u0a15\u0a40\u0a38" },
            { "chm", "\u0a2e\u0a3e\u0a30\u0a40" },
            { "cho", "\u0a1a\u0a4c\u0a15\u0a1f\u0a4b" },
            { "chr", "\u0a1a\u0a47\u0a30\u0a4b\u0a15\u0a40" },
            { "ER", "\u0a07\u0a30\u0a40\u0a1f\u0a4d\u0a30\u0a3f\u0a06" },
            { "ES", "\u0a38\u0a2a\u0a47\u0a28" },
            { "ET", "\u0a07\u0a25\u0a4b\u0a2a\u0a40\u0a06" },
            { "EU", "\u0a2f\u0a42\u0a30\u0a2a\u0a40 \u0a38\u0a70\u0a18" },
            { "type.ca.gregorian", "\u0a17\u0a30\u0a47\u0a17\u0a4b\u0a30\u0a40\u0a05\u0a28 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "EZ", "\u0a2f\u0a42\u0a30\u0a4b\u0a1c\u0a3c\u0a4b\u0a28" },
            { "chy", "\u0a1b\u0a3e\u0a07\u0a06\u0a28" },
            { "type.nu.gujr", "\u0a17\u0a41\u0a1c\u0a30\u0a3e\u0a24\u0a40 \u0a05\u0a70\u0a15" },
            { "ady", "\u0a05\u0a21\u0a3f\u0a17\u0a47" },
            { "FI", "\u0a2b\u0a3f\u0a28\u0a32\u0a48\u0a02\u0a21" },
            { "FJ", "\u0a2b\u0a3c\u0a3f\u0a1c\u0a40" },
            { "FK", "\u0a2b\u0a3c\u0a3e\u0a15\u0a32\u0a48\u0a02\u0a21 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "FM", "\u0a2e\u0a3e\u0a07\u0a15\u0a4d\u0a30\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "FO", "\u0a2b\u0a48\u0a30\u0a4b \u0a1f\u0a3e\u0a2a\u0a42" },
            { "Taml", metaValue_ta },
            { "FR", "\u0a2b\u0a3c\u0a30\u0a3e\u0a02\u0a38" },
            { "root", "\u0a30\u0a42\u0a1f" },
            { "type.ca.indian", "\u0a2d\u0a3e\u0a30\u0a24\u0a40 \u0a15\u0a4c\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "grc", "\u0a2a\u0a41\u0a30\u0a3e\u0a24\u0a28 \u0a2f\u0a42\u0a28\u0a3e\u0a28\u0a40" },
            { "GA", "\u0a17\u0a2c\u0a4b\u0a28" },
            { "GB", "\u0a2f\u0a42\u0a28\u0a3e\u0a08\u0a1f\u0a21 \u0a15\u0a3f\u0a70\u0a17\u0a21\u0a2e" },
            { "pcm", "\u0a28\u0a3e\u0a07\u0a1c\u0a40\u0a30\u0a40\u0a06\u0a08 \u0a2a\u0a3f\u0a21\u0a17\u0a3f\u0a28" },
            { "GD", "\u0a17\u0a4d\u0a30\u0a47\u0a28\u0a3e\u0a21\u0a3e" },
            { "GE", "\u0a1c\u0a3e\u0a30\u0a1c\u0a40\u0a06" },
            { "GF", "\u0a2b\u0a30\u0a48\u0a02\u0a1a \u0a17\u0a41\u0a07\u0a06\u0a28\u0a3e" },
            { "GG", "\u0a17\u0a30\u0a28\u0a1c\u0a40" },
            { "GH", "\u0a18\u0a3e\u0a28\u0a3e" },
            { "GI", "\u0a1c\u0a3f\u0a2c\u0a30\u0a3e\u0a32\u0a1f\u0a30" },
            { "GL", "\u0a17\u0a4d\u0a30\u0a40\u0a28\u0a32\u0a48\u0a02\u0a21" },
            { "GM", "\u0a17\u0a48\u0a02\u0a2c\u0a40\u0a06" },
            { "GN", "\u0a17\u0a3f\u0a28\u0a40" },
            { "GP", "\u0a17\u0a41\u0a06\u0a21\u0a47\u0a32\u0a4b\u0a2a" },
            { "GQ", "\u0a2d\u0a42-\u0a16\u0a70\u0a21\u0a40 \u0a17\u0a3f\u0a28\u0a40" },
            { "GR", "\u0a17\u0a4d\u0a30\u0a40\u0a38" },
            { "GS", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a1c\u0a3e\u0a30\u0a1c\u0a40\u0a06 \u0a05\u0a24\u0a47 \u0a26\u0a71\u0a16\u0a23\u0a40 \u0a38\u0a48\u0a02\u0a21\u0a35\u0a3f\u0a1a \u0a1f\u0a3e\u0a2a\u0a42" },
            { "GT", "\u0a17\u0a41\u0a06\u0a1f\u0a47\u0a2e\u0a3e\u0a32\u0a3e" },
            { "GU", "\u0a17\u0a41\u0a06\u0a2e" },
            { "GW", "\u0a17\u0a3f\u0a28\u0a40-\u0a2c\u0a3f\u0a38\u0a3e\u0a09" },
            { "tlh", "\u0a15\u0a32\u0a3f\u0a70\u0a17\u0a28" },
            { "GY", "\u0a17\u0a41\u0a2f\u0a3e\u0a28\u0a3e" },
            { "ckb", "\u0a15\u0a47\u0a02\u0a26\u0a30\u0a40 \u0a15\u0a41\u0a30\u0a26\u0a3f\u0a38\u0a3c" },
            { "zxx", "\u0a2c\u0a4b\u0a32\u0a40 \u0a38\u0a70\u0a2c\u0a70\u0a27\u0a40 \u0a15\u0a4b\u0a08 \u0a38\u0a2e\u0a71\u0a17\u0a30\u0a40 \u0a28\u0a39\u0a40\u0a02" },
            { "de_AT", "\u0a1c\u0a30\u0a2e\u0a28 (\u0a06\u0a38\u0a1f\u0a30\u0a40\u0a06\u0a08)" },
            { "HK", "\u0a39\u0a3e\u0a02\u0a17 \u0a15\u0a3e\u0a02\u0a17 \u0a10\u0a38\u0a0f\u0a06\u0a30 \u0a1a\u0a40\u0a28" },
            { "HM", "\u0a39\u0a30\u0a21 \u0a24\u0a47 \u0a2e\u0a48\u0a15\u0a21\u0a4b\u0a28\u0a3e\u0a32\u0a21 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "HN", "\u0a39\u0a4b\u0a02\u0a21\u0a41\u0a30\u0a38" },
            { "HR", "\u0a15\u0a30\u0a4b\u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "agq", "\u0a05\u0a17\u0a47\u0a2e" },
            { "gsw", "\u0a1c\u0a30\u0a2e\u0a28 (\u0a38\u0a35\u0a3f\u0a38)" },
            { "type.ca.islamic-umalqura", "\u0a07\u0a38\u0a32\u0a3e\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30 (\u0a05\u0a2e \u0a05\u0a32-\u0a15\u0a41\u0a30\u0a3e)" },
            { "HT", "\u0a39\u0a48\u0a24\u0a40" },
            { "HU", "\u0a39\u0a70\u0a17\u0a30\u0a40" },
            { "IC", "\u0a15\u0a47\u0a28\u0a3e\u0a30\u0a40 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "nan", "\u0a1a\u0a40\u0a28\u0a40 \u0a2e\u0a3f\u0a28 \u0a28\u0a3e\u0a28" },
            { "ID", "\u0a07\u0a70\u0a21\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "IE", "\u0a06\u0a07\u0a30\u0a32\u0a48\u0a02\u0a21" },
            { "nap", "\u0a28\u0a3f\u0a06\u0a2a\u0a4b\u0a32\u0a40\u0a1f\u0a28" },
            { "naq", "\u0a28\u0a3e\u0a2e\u0a3e" },
            { "zza", "\u0a1c\u0a3c\u0a3e\u0a1c\u0a3c\u0a3e" },
            { "IL", "\u0a07\u0a1c\u0a3c\u0a30\u0a3e\u0a08\u0a32" },
            { "IM", "\u0a06\u0a07\u0a32 \u0a06\u0a2b \u0a2e\u0a48\u0a28" },
            { "IN", "\u0a2d\u0a3e\u0a30\u0a24" },
            { "IO", "\u0a2c\u0a30\u0a24\u0a3e\u0a28\u0a35\u0a40 \u0a39\u0a3f\u0a70\u0a26 \u0a2e\u0a39\u0a3e\u0a02\u0a38\u0a3e\u0a17\u0a30 \u0a16\u0a3f\u0a71\u0a24\u0a3e" },
            { "IQ", "\u0a07\u0a30\u0a3e\u0a15" },
            { "IR", "\u0a08\u0a30\u0a3e\u0a28" },
            { "IS", "\u0a06\u0a08\u0a38\u0a32\u0a48\u0a02\u0a21" },
            { "IT", "\u0a07\u0a1f\u0a32\u0a40" },
            { "Zmth", "\u0a17\u0a23\u0a3f\u0a24 \u0a1a\u0a3f\u0a70\u0a28\u0a4d\u0a39-\u0a32\u0a3f\u0a2a\u0a40" },
            { "type.nu.thai", "\u0a25\u0a3e\u0a08 \u0a05\u0a70\u0a15" },
            { "type.nu.beng", "\u0a2c\u0a70\u0a17\u0a3e\u0a32\u0a40 \u0a05\u0a70\u0a15" },
            { "JE", "\u0a1c\u0a30\u0a38\u0a40" },
            { "type.ca.islamic", "\u0a07\u0a38\u0a32\u0a3e\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "Beng", metaValue_bn },
            { "JM", "\u0a1c\u0a2e\u0a3e\u0a07\u0a15\u0a3e" },
            { "JO", "\u0a1c\u0a3e\u0a30\u0a21\u0a28" },
            { "JP", "\u0a1c\u0a2a\u0a3e\u0a28" },
            { "ain", "\u0a06\u0a07\u0a28\u0a42" },
            { "guz", "\u0a17\u0a41\u0a38\u0a40" },
            { "type.nu.knda", "\u0a15\u0a70\u0a28\u0a5c \u0a05\u0a70\u0a15" },
            { "de_CH", "\u0a39\u0a3e\u0a08 \u0a1c\u0a30\u0a2e\u0a28 (\u0a38\u0a35\u0a3f\u0a1f\u0a1c\u0a3c\u0a30\u0a32\u0a48\u0a02\u0a21)" },
            { "type.ca.buddhist", "\u0a2c\u0a4b\u0a27\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "KE", "\u0a15\u0a40\u0a28\u0a40\u0a06" },
            { "419", "\u0a32\u0a3e\u0a24\u0a40\u0a28\u0a40 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "KG", "\u0a15\u0a3f\u0a30\u0a17\u0a3f\u0a1c\u0a3c\u0a38\u0a24\u0a3e\u0a28" },
            { "KH", "\u0a15\u0a70\u0a2c\u0a4b\u0a21\u0a40\u0a06" },
            { "KI", "\u0a15\u0a3f\u0a30\u0a2c\u0a3e\u0a24\u0a40" },
            { "KM", "\u0a15\u0a4b\u0a2e\u0a4b\u0a30\u0a4b\u0a38" },
            { "Knda", metaValue_kn },
            { "KN", "\u0a38\u0a47\u0a02\u0a1f \u0a15\u0a3f\u0a1f\u0a38 \u0a10\u0a02\u0a21 \u0a28\u0a47\u0a35\u0a3f\u0a38" },
            { "fr_CA", "\u0a2b\u0a30\u0a3e\u0a02\u0a38\u0a40\u0a38\u0a40 (\u0a15\u0a48\u0a28\u0a47\u0a21\u0a40\u0a05\u0a28)" },
            { "KP", "\u0a09\u0a71\u0a24\u0a30 \u0a15\u0a4b\u0a30\u0a40\u0a06" },
            { "KR", "\u0a26\u0a71\u0a16\u0a23 \u0a15\u0a4b\u0a30\u0a40\u0a06" },
            { "KW", "\u0a15\u0a41\u0a35\u0a48\u0a24" },
            { "tpi", "\u0a1f\u0a4b\u0a15 \u0a2a\u0a3f\u0a38\u0a3f\u0a28" },
            { "KY", "\u0a15\u0a47\u0a2e\u0a48\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "KZ", "\u0a15\u0a1c\u0a3c\u0a3e\u0a16\u0a38\u0a24\u0a3e\u0a28" },
            { "Cyrl", "\u0a38\u0a3f\u0a30\u0a40\u0a32\u0a3f\u0a15" },
            { "LA", "\u0a32\u0a3e\u0a13\u0a38" },
            { "LB", "\u0a32\u0a48\u0a2c\u0a28\u0a3e\u0a28" },
            { "LC", "\u0a38\u0a47\u0a02\u0a1f \u0a32\u0a42\u0a38\u0a40\u0a06" },
            { "gwi", "\u0a17\u0a35\u0a3f\u0a1a\u2019\u0a07\u0a28" },
            { "nds", "\u0a32\u0a4b \u0a1c\u0a30\u0a2e\u0a28" },
            { "LI", "\u0a32\u0a3f\u0a1a\u0a47\u0a02\u0a38\u0a1f\u0a3e\u0a07\u0a28" },
            { "LK", "\u0a38\u0a4d\u0a30\u0a40 \u0a32\u0a70\u0a15\u0a3e" },
            { "LR", "\u0a32\u0a3e\u0a08\u0a2c\u0a40\u0a30\u0a40\u0a06" },
            { "LS", "\u0a32\u0a47\u0a38\u0a4b\u0a25\u0a4b" },
            { "LT", "\u0a32\u0a3f\u0a25\u0a41\u0a06\u0a28\u0a40\u0a06" },
            { "LU", "\u0a32\u0a15\u0a1c\u0a3c\u0a2e\u0a2c\u0a30\u0a17" },
            { "LV", "\u0a32\u0a3e\u0a24\u0a35\u0a40\u0a06" },
            { "Kana", "\u0a15\u0a3e\u0a1f\u0a3e\u0a15\u0a3e\u0a28\u0a3e" },
            { "LY", "\u0a32\u0a40\u0a2c\u0a40\u0a06" },
            { "lad", "\u0a32\u0a48\u0a21\u0a40\u0a28\u0a4b" },
            { "vun", "\u0a35\u0a42\u0a70\u0a1c\u0a4b" },
            { "lag", "\u0a32\u0a70\u0a17\u0a3e\u0a08" },
            { "Thaa", "\u0a25\u0a3e\u0a28\u0a3e" },
            { "MA", "\u0a2e\u0a4b\u0a30\u0a71\u0a15\u0a4b" },
            { "MC", "\u0a2e\u0a4b\u0a28\u0a3e\u0a15\u0a4b" },
            { "MD", "\u0a2e\u0a4b\u0a32\u0a21\u0a4b\u0a35\u0a3e" },
            { "ME", "\u0a2e\u0a4b\u0a02\u0a1f\u0a47\u0a28\u0a47\u0a17\u0a30\u0a4b" },
            { "MF", "\u0a38\u0a47\u0a02\u0a1f \u0a2e\u0a3e\u0a30\u0a1f\u0a3f\u0a28" },
            { "MG", "\u0a2e\u0a48\u0a21\u0a3e\u0a17\u0a3e\u0a38\u0a15\u0a30" },
            { "Thai", metaValue_th },
            { "MH", "\u0a2e\u0a3e\u0a30\u0a38\u0a3c\u0a32 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "ale", "\u0a05\u0a32\u0a47\u0a09\u0a1f" },
            { "MK", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a2e\u0a48\u0a15\u0a21\u0a4b\u0a28\u0a40\u0a06" },
            { "ML", "\u0a2e\u0a3e\u0a32\u0a40" },
            { "MM", "\u0a2e\u0a3f\u0a06\u0a02\u0a2e\u0a3e\u0a30 (\u0a2c\u0a30\u0a2e\u0a3e)" },
            { "MN", "\u0a2e\u0a70\u0a17\u0a4b\u0a32\u0a40\u0a06" },
            { "new", "\u0a28\u0a47\u0a35\u0a3e\u0a30\u0a40" },
            { "MO", "\u0a2e\u0a15\u0a3e\u0a09 \u0a10\u0a38\u0a0f\u0a06\u0a30 \u0a1a\u0a40\u0a28" },
            { "MP", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a2e\u0a3e\u0a30\u0a40\u0a06\u0a28\u0a3e \u0a1f\u0a3e\u0a2a\u0a42" },
            { "MQ", "\u0a2e\u0a3e\u0a30\u0a1f\u0a40\u0a28\u0a3f\u0a15" },
            { "MR", "\u0a2e\u0a4b\u0a30\u0a3f\u0a1f\u0a3e\u0a28\u0a40\u0a06" },
            { "MS", "\u0a2e\u0a4b\u0a02\u0a1f\u0a38\u0a47\u0a30\u0a3e\u0a24" },
            { "MT", "\u0a2e\u0a3e\u0a32\u0a1f\u0a3e" },
            { "MU", "\u0a2e\u0a4c\u0a30\u0a40\u0a38\u0a3c\u0a38" },
            { "alt", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a05\u0a32\u0a24\u0a3e\u0a08" },
            { "MV", "\u0a2e\u0a3e\u0a32\u0a26\u0a40\u0a35" },
            { "MW", "\u0a2e\u0a32\u0a3e\u0a35\u0a40" },
            { "MX", "\u0a2e\u0a48\u0a15\u0a38\u0a40\u0a15\u0a4b" },
            { "type.ca.japanese", "\u0a1c\u0a2a\u0a3e\u0a28\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "MY", "\u0a2e\u0a32\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "MZ", "\u0a2e\u0a4b\u0a1c\u0a3c\u0a3e\u0a2e\u0a2c\u0a40\u0a15" },
            { "NA", "\u0a28\u0a3e\u0a2e\u0a40\u0a2c\u0a40\u0a06" },
            { "202", "\u0a09\u0a2a-\u0a38\u0a39\u0a3e\u0a30\u0a3e \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "type.ca.hebrew", "\u0a39\u0a3f\u0a2c\u0a30\u0a42 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "type.co.dictionary", "\u0a38\u0a3c\u0a2c\u0a26-\u0a15\u0a4b\u0a38\u0a3c \u0a32\u0a5c\u0a40\u0a2c\u0a71\u0a27 \u0a15\u0a4d\u0a30\u0a2e" },
            { "NC", "\u0a28\u0a3f\u0a0a \u0a15\u0a48\u0a32\u0a47\u0a21\u0a4b\u0a28\u0a40\u0a06" },
            { "NE", "\u0a28\u0a3e\u0a08\u0a1c\u0a30" },
            { "NF", "\u0a28\u0a4b\u0a30\u0a2b\u0a4c\u0a15 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "NG", "\u0a28\u0a3e\u0a08\u0a1c\u0a40\u0a30\u0a40\u0a06" },
            { "trv", "\u0a1f\u0a3e\u0a30\u0a4b\u0a15\u0a4b" },
            { "NI", "\u0a28\u0a3f\u0a15\u0a3e\u0a30\u0a3e\u0a17\u0a41\u0a06" },
            { "NL", "\u0a28\u0a40\u0a26\u0a30\u0a32\u0a48\u0a02\u0a21" },
            { "NO", "\u0a28\u0a3e\u0a30\u0a35\u0a47" },
            { "NP", "\u0a28\u0a47\u0a2a\u0a3e\u0a32" },
            { "NR", metaValue_NR },
            { "NU", "\u0a28\u0a3f\u0a2f\u0a42" },
            { "rof", "\u0a30\u0a4b\u0a2e\u0a2c\u0a4b" },
            { "NZ", "\u0a28\u0a3f\u0a0a\u0a1c\u0a3c\u0a40\u0a32\u0a48\u0a02\u0a21" },
            { "ang", "\u0a2a\u0a41\u0a30\u0a3e\u0a23\u0a40 \u0a05\u0a70\u0a17\u0a30\u0a47\u0a1c\u0a3c\u0a40" },
            { "OM", "\u0a13\u0a2e\u0a3e\u0a28" },
            { "anp", "\u0a05\u0a70\u0a17\u0a3f\u0a15\u0a3e" },
            { "crs", "\u0a38\u0a47\u0a38\u0a47\u0a32\u0a35\u0a3e \u0a15\u0a4d\u0a30\u0a3f\u0a13\u0a32 \u0a2b\u0a4d\u0a30\u0a48\u0a02\u0a1a" },
            { "PA", "\u0a2a\u0a28\u0a3e\u0a2e\u0a3e" },
            { "type.ca.islamic-civil", "\u0a07\u0a38\u0a32\u0a3e\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30 (\u0a38\u0a3e\u0a30\u0a28\u0a40\u0a2c\u0a71\u0a27, \u0a38\u0a2e\u0a3e\u0a1c\u0a3f\u0a15 \u0a2f\u0a41\u0a71\u0a17)" },
            { "en_GB", "\u0a05\u0a70\u0a17\u0a30\u0a47\u0a1c\u0a3c\u0a40 (\u0a2c\u0a30\u0a24\u0a3e\u0a28\u0a35\u0a40)" },
            { "PE", "\u0a2a\u0a47\u0a30\u0a42" },
            { "PF", "\u0a2b\u0a30\u0a48\u0a02\u0a1a \u0a2a\u0a4b\u0a32\u0a40\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "PG", "\u0a2a\u0a3e\u0a2a\u0a42\u0a06 \u0a28\u0a3f\u0a0a \u0a17\u0a3f\u0a28\u0a40" },
            { "PH", "\u0a2b\u0a3f\u0a32\u0a40\u0a2a\u0a40\u0a28\u0a1c" },
            { "PK", "\u0a2a\u0a3e\u0a15\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "PL", "\u0a2a\u0a4b\u0a32\u0a48\u0a02\u0a21" },
            { "ewo", "\u0a07\u0a35\u0a4b\u0a02\u0a21\u0a4b" },
            { "PM", "\u0a38\u0a47\u0a02\u0a1f \u0a2a\u0a40\u0a05\u0a30\u0a47 \u0a10\u0a02\u0a21 \u0a2e\u0a3f\u0a15\u0a47\u0a32\u0a28" },
            { "PN", "\u0a2a\u0a3f\u0a1f\u0a15\u0a47\u0a30\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "PR", "\u0a2a\u0a3f\u0a0a\u0a30\u0a1f\u0a4b \u0a30\u0a3f\u0a15\u0a4b" },
            { "PS", "\u0a2b\u0a3f\u0a32\u0a40\u0a38\u0a24\u0a40\u0a28\u0a40 \u0a07\u0a32\u0a3e\u0a15\u0a3e" },
            { "PT", "\u0a2a\u0a41\u0a30\u0a24\u0a17\u0a3e\u0a32" },
            { "PW", "\u0a2a\u0a32\u0a3e\u0a09" },
            { "nia", "\u0a28\u0a3f\u0a06\u0a38" },
            { "type.nu.greklow", "\u0a2f\u0a42\u0a28\u0a3e\u0a28\u0a40 \u0a32\u0a4b\u0a05\u0a30\u0a15\u0a47\u0a38 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "PY", "\u0a2a\u0a48\u0a30\u0a3e\u0a17\u0a35\u0a47" },
            { "tum", "\u0a24\u0a41\u0a70\u0a2c\u0a41\u0a15\u0a3e" },
            { "Hebr", metaValue_he },
            { "QA", "\u0a15\u0a24\u0a30" },
            { "niu", "\u0a28\u0a3f\u0a0a\u0a0f\u0a08" },
            { "QO", "\u0a06\u0a0a\u0a1f\u0a32\u0a3e\u0a07\u0a70\u0a17 \u0a13\u0a38\u0a3c\u0a40\u0a28\u0a40\u0a06" },
            { "lez", "\u0a32\u0a48\u0a1c\u0a3c\u0a17\u0a40" },
            { "tvl", "\u0a1f\u0a3f\u0a0a\u0a35\u0a3e\u0a32\u0a42" },
            { "001", "\u0a38\u0a70\u0a38\u0a3e\u0a30" },
            { "002", "\u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "003", "\u0a09\u0a71\u0a24\u0a30 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "RE", "\u0a30\u0a3f\u0a2f\u0a42\u0a28\u0a40\u0a05\u0a28" },
            { "005", "\u0a26\u0a71\u0a16\u0a23 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "jbo", "\u0a32\u0a4b\u0a1c\u0a2c\u0a3e\u0a28" },
            { "009", "\u0a13\u0a38\u0a3c\u0a47\u0a28\u0a40\u0a06" },
            { "RO", "\u0a30\u0a4b\u0a2e\u0a3e\u0a28\u0a40\u0a06" },
            { "RS", "\u0a38\u0a30\u0a2c\u0a40\u0a06" },
            { "RU", "\u0a30\u0a42\u0a38" },
            { "RW", "\u0a30\u0a35\u0a3e\u0a02\u0a21\u0a3e" },
            { "SA", "\u0a38\u0a3e\u0a0a\u0a26\u0a40 \u0a05\u0a30\u0a2c" },
            { "SB", "\u0a38\u0a4b\u0a32\u0a4b\u0a2e\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "twq", "\u0a24\u0a3e\u0a38\u0a3e\u0a35\u0a3f\u0a15" },
            { "011", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "SC", "\u0a38\u0a47\u0a38\u0a3c\u0a32\u0a38" },
            { "SD", "\u0a38\u0a42\u0a21\u0a3e\u0a28" },
            { "013", "\u0a15\u0a47\u0a02\u0a26\u0a30\u0a40 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "SE", "\u0a38\u0a35\u0a40\u0a21\u0a28" },
            { "014", "\u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "015", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "SG", "\u0a38\u0a3f\u0a70\u0a17\u0a3e\u0a2a\u0a41\u0a30" },
            { "SH", "\u0a38\u0a47\u0a02\u0a1f \u0a39\u0a47\u0a32\u0a47\u0a28\u0a3e" },
            { "type.lb.strict", "\u0a2a\u0a71\u0a15\u0a40 \u0a30\u0a47\u0a16\u0a3e \u0a35\u0a3f\u0a71\u0a25 \u0a38\u0a3c\u0a48\u0a32\u0a40" },
            { "017", "\u0a2e\u0a71\u0a27 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "SI", "\u0a38\u0a32\u0a4b\u0a35\u0a47\u0a28\u0a40\u0a06" },
            { "018", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a3e" },
            { "SJ", "\u0a38\u0a35\u0a3e\u0a32\u0a2c\u0a30\u0a21 \u0a05\u0a24\u0a47 \u0a1c\u0a3e\u0a28 \u0a2e\u0a3e\u0a2f\u0a47\u0a28" },
            { "019", "\u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "SK", "\u0a38\u0a32\u0a4b\u0a35\u0a3e\u0a15\u0a40\u0a06" },
            { "SL", "\u0a38\u0a3f\u0a0f\u0a30\u0a3e \u0a32\u0a3f\u0a13\u0a28" },
            { "SM", "\u0a38\u0a48\u0a28 \u0a2e\u0a30\u0a40\u0a28\u0a4b" },
            { "SN", "\u0a38\u0a47\u0a28\u0a47\u0a17\u0a32" },
            { "SO", "\u0a38\u0a4b\u0a2e\u0a3e\u0a32\u0a40\u0a06" },
            { "arn", "\u0a2e\u0a3e\u0a2a\u0a41\u0a1a\u0a47" },
            { "arp", "\u0a05\u0a30\u0a3e\u0a2b\u0a3e\u0a13" },
            { "type.nu.taml", "\u0a30\u0a35\u0a3e\u0a07\u0a24\u0a40 \u0a24\u0a2e\u0a3f\u0a32 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "SR", "\u0a38\u0a42\u0a30\u0a40\u0a28\u0a3e\u0a2e" },
            { "SS", "\u0a26\u0a71\u0a16\u0a23 \u0a38\u0a41\u0a21\u0a3e\u0a28" },
            { "ST", "\u0a38\u0a3e\u0a13 \u0a1f\u0a4b\u0a2e \u0a05\u0a24\u0a47 \u0a2a\u0a4d\u0a30\u0a3f\u0a70\u0a38\u0a40\u0a2a\u0a47" },
            { "SV", "\u0a05\u0a32 \u0a38\u0a32\u0a35\u0a3e\u0a21\u0a4b\u0a30" },
            { "SX", "\u0a38\u0a3f\u0a70\u0a1f \u0a2e\u0a3e\u0a30\u0a1f\u0a40\u0a28" },
            { "SY", "\u0a38\u0a40\u0a30\u0a40\u0a06" },
            { "SZ", "\u0a07\u0a38\u0a35\u0a3e\u0a24\u0a40\u0a28\u0a40" },
            { "TA", "\u0a1f\u0a4d\u0a30\u0a3f\u0a38\u0a1f\u0a3e\u0a28 \u0a26\u0a3e \u0a15\u0a41\u0a70\u0a39\u0a3e" },
            { "asa", "\u0a05\u0a38\u0a42" },
            { "type.ms.ussystem", "\u0a05\u0a2e\u0a30\u0a40\u0a15\u0a40 \u0a2e\u0a3e\u0a2a \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40" },
            { "021", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a3e" },
            { "TC", "\u0a1f\u0a41\u0a30\u0a15\u0a38 \u0a05\u0a24\u0a47 \u0a15\u0a48\u0a15\u0a4b\u0a38 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "yav", "\u0a2f\u0a3e\u0a02\u0a17\u0a2c\u0a47\u0a28" },
            { "TD", "\u0a1a\u0a3e\u0a21" },
            { "TF", "\u0a2b\u0a30\u0a48\u0a02\u0a1a \u0a26\u0a71\u0a16\u0a23\u0a40 \u0a2a\u0a4d\u0a30\u0a26\u0a47\u0a38\u0a3c" },
            { "TG", "\u0a1f\u0a4b\u0a17\u0a4b" },
            { "TH", "\u0a25\u0a3e\u0a08\u0a32\u0a48\u0a02\u0a21" },
            { "TJ", "\u0a24\u0a3e\u0a1c\u0a3f\u0a15\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "029", "\u0a15\u0a48\u0a30\u0a47\u0a2c\u0a40\u0a06\u0a08" },
            { "TK", "\u0a1f\u0a4b\u0a15\u0a47\u0a32\u0a3e\u0a09" },
            { "TL", "\u0a24\u0a3f\u0a2e\u0a4b\u0a30-\u0a32\u0a47\u0a38\u0a24\u0a47" },
            { "ybb", "\u0a2f\u0a47\u0a02\u0a2c\u0a3e" },
            { "TM", "\u0a24\u0a41\u0a30\u0a15\u0a2e\u0a47\u0a28\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "TN", "\u0a1f\u0a3f\u0a0a\u0a28\u0a40\u0a38\u0a3c\u0a40\u0a06" },
            { "TO", "\u0a1f\u0a4c\u0a02\u0a17\u0a3e" },
            { "TR", metaValue_TR },
            { "TT", "\u0a1f\u0a4d\u0a30\u0a3f\u0a28\u0a40\u0a21\u0a3e\u0a21 \u0a05\u0a24\u0a47 \u0a1f\u0a4b\u0a2c\u0a3e\u0a17\u0a4b" },
            { "TV", "\u0a1f\u0a41\u0a35\u0a3e\u0a32\u0a42" },
            { "TW", "\u0a24\u0a3e\u0a07\u0a35\u0a3e\u0a28" },
            { "ast", "\u0a05\u0a38\u0a24\u0a42\u0a30\u0a40" },
            { "TZ", "\u0a24\u0a28\u0a1c\u0a3c\u0a3e\u0a28\u0a40\u0a06" },
            { "nmg", "\u0a15\u0a35\u0a3e\u0a38\u0a3f\u0a13" },
            { "Zzzz", "\u0a05\u0a23\u0a2a\u0a1b\u0a3e\u0a24\u0a40 \u0a32\u0a3f\u0a2a\u0a40" },
            { "UA", "\u0a2f\u0a42\u0a15\u0a30\u0a47\u0a28" },
            { "rup", "\u0a05\u0a30\u0a4b\u0a2e\u0a40\u0a28\u0a40\u0a06\u0a08" },
            { "030", "\u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "tyv", "\u0a24\u0a41\u0a35\u0a40\u0a28\u0a40\u0a05\u0a28" },
            { "sw_CD", "\u0a15\u0a3e\u0a02\u0a17\u0a4b \u0a38\u0a35\u0a3e\u0a07\u0a32\u0a40" },
            { "034", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "035", "\u0a26\u0a71\u0a16\u0a23-\u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "UG", "\u0a2f\u0a42\u0a17\u0a3e\u0a02\u0a21\u0a3e" },
            { "hak", "\u0a1a\u0a40\u0a28\u0a40 \u0a39\u0a3e\u0a15\u0a3e" },
            { "039", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a2f\u0a42\u0a30\u0a2a" },
            { "Sinh", metaValue_si },
            { "UM", "\u0a2f\u0a42.\u0a10\u0a71\u0a38. \u0a26\u0a42\u0a30-\u0a26\u0a41\u0a30\u0a3e\u0a21\u0a47 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "UN", "\u0a38\u0a70\u0a2f\u0a41\u0a15\u0a24 \u0a30\u0a3e\u0a38\u0a3c\u0a1f\u0a30" },
            { "US", "\u0a38\u0a70\u0a2f\u0a41\u0a15\u0a24 \u0a30\u0a3e\u0a1c" },
            { "haw", "\u0a39\u0a35\u0a3e\u0a08" },
            { "UY", "\u0a09\u0a30\u0a42\u0a17\u0a35\u0a47" },
            { "prg", "\u0a2a\u0a30\u0a42\u0a38\u0a3c\u0a40\u0a06" },
            { "UZ", "\u0a09\u0a1c\u0a3c\u0a2c\u0a47\u0a15\u0a3f\u0a38\u0a24\u0a3e\u0a28" },
            { "tzm", "\u0a2e\u0a71\u0a27 \u0a10\u0a1f\u0a32\u0a38 \u0a24\u0a2e\u0a3e\u0a1c\u0a3c\u0a3f\u0a24" },
            { "nnh", "\u0a28\u0a3f\u0a13\u0a2e\u0a2c\u0a42\u0a28" },
            { "VA", "\u0a35\u0a48\u0a1f\u0a40\u0a15\u0a28 \u0a38\u0a3f\u0a1f\u0a40" },
            { "VC", "\u0a38\u0a47\u0a02\u0a1f \u0a35\u0a3f\u0a28\u0a38\u0a48\u0a02\u0a1f \u0a10\u0a02\u0a21 \u0a17\u0a4d\u0a30\u0a47\u0a28\u0a3e\u0a21\u0a40\u0a28\u0a38" },
            { "VE", "\u0a35\u0a47\u0a28\u0a47\u0a1c\u0a3c\u0a42\u0a0f\u0a32\u0a3e" },
            { "VG", "\u0a2c\u0a4d\u0a30\u0a3f\u0a1f\u0a3f\u0a38\u0a3c \u0a35\u0a30\u0a1c\u0a3f\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "VI", "\u0a2f\u0a42 \u0a10\u0a71\u0a38 \u0a35\u0a30\u0a1c\u0a3f\u0a28 \u0a1f\u0a3e\u0a2a\u0a42" },
            { "VN", "\u0a35\u0a40\u0a05\u0a24\u0a28\u0a3e\u0a2e" },
            { "VU", "\u0a35\u0a3e\u0a28\u0a42\u0a06\u0a1f\u0a42" },
            { "nog", "\u0a28\u0a4b\u0a17\u0a3e\u0a08" },
            { "rwk", "\u0a30\u0a35\u0a3e" },
            { "053", "\u0a06\u0a38\u0a1f\u0a30\u0a47\u0a32\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "054", "\u0a2e\u0a47\u0a32\u0a3e\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "WF", "\u0a35\u0a3e\u0a32\u0a3f\u0a38 \u0a05\u0a24\u0a47 \u0a2b\u0a42\u0a1f\u0a42\u0a28\u0a3e" },
            { "type.co.traditional", "\u0a30\u0a35\u0a3e\u0a07\u0a24\u0a40 \u0a32\u0a5c\u0a40\u0a2c\u0a71\u0a27 \u0a15\u0a4d\u0a30\u0a2e" },
            { "057", "\u0a2e\u0a3e\u0a07\u0a15\u0a4d\u0a30\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06\u0a08 \u0a07\u0a32\u0a3e\u0a15\u0a3e" },
            { "jgo", "\u0a28\u0a17\u0a4b\u0a02\u0a2c\u0a3e" },
            { "lkt", "\u0a32\u0a15\u0a4b\u0a1f\u0a3e" },
            { "type.co.compat", "\u0a2a\u0a3f\u0a1b\u0a32\u0a3e \u0a24\u0a30\u0a24\u0a40\u0a2c \u0a35\u0a3e\u0a30 \u0a15\u0a4d\u0a30\u0a2e, \u0a05\u0a28\u0a41\u0a30\u0a42\u0a2a\u0a24\u0a3e \u0a32\u0a08" },
            { "wae", "\u0a35\u0a3e\u0a32\u0a38\u0a30" },
            { "WS", "\u0a38\u0a3e\u0a2e\u0a4b\u0a06" },
            { "wal", "\u0a35\u0a4b\u0a32\u0a3e\u0a0f\u0a1f\u0a3e" },
            { "XA", "\u0a17\u0a32\u0a24-\u0a09\u0a1a\u0a3e\u0a30\u0a28" },
            { "war", "\u0a35\u0a48\u0a30\u0a47" },
            { "XB", "\u0a32\u0a3f\u0a16\u0a24 \u0a26\u0a40 \u0a17\u0a32\u0a24 \u0a26\u0a3f\u0a38\u0a3c\u0a3e" },
            { "awa", "\u0a05\u0a35\u0a27\u0a40" },
            { "061", "\u0a2a\u0a4b\u0a32\u0a40\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06" },
            { "XK", "\u0a15\u0a4b\u0a38\u0a4b\u0a35\u0a4b" },
            { "type.nu.brah", "\u0a2c\u0a30\u0a3e\u0a39\u0a2e\u0a40 \u0a05\u0a70\u0a15" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0a05\u0a32\u0a3f\u0a16\u0a24" },
            { "wbp", "\u0a35\u0a3e\u0a32\u0a2a\u0a41\u0a30\u0a40" },
            { "YE", "\u0a2f\u0a2e\u0a28" },
            { "nqo", "\u0a10\u0a02\u0a15\u0a4b" },
            { "type.co.standard", "\u0a38\u0a27\u0a3e\u0a30\u0a28 \u0a32\u0a5c\u0a40\u0a2c\u0a71\u0a27 \u0a15\u0a4d\u0a30\u0a2e" },
            { "YT", "\u0a2e\u0a3e\u0a2f\u0a4b\u0a1f\u0a40" },
            { "ZA", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a05\u0a2b\u0a30\u0a40\u0a15\u0a3e" },
            { "type.lb.loose", "\u0a16\u0a41\u0a71\u0a32\u0a4d\u0a39\u0a40 \u0a30\u0a47\u0a16\u0a3e \u0a35\u0a3f\u0a71\u0a25 \u0a38\u0a3c\u0a48\u0a32\u0a40" },
            { "Deva", "\u0a26\u0a47\u0a35\u0a28\u0a3e\u0a17\u0a30\u0a40" },
            { "type.nu.geor", "\u0a1c\u0a3e\u0a30\u0a1c\u0a40\u0a05\u0a28 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "Hira", "\u0a39\u0a3f\u0a30\u0a3e\u0a17\u0a3e\u0a28\u0a3e" },
            { "ZM", "\u0a1c\u0a3c\u0a3e\u0a2e\u0a2c\u0a40\u0a06" },
            { "ZW", "\u0a1c\u0a3c\u0a3f\u0a70\u0a2c\u0a3e\u0a2c\u0a35\u0a47" },
            { "ZZ", "\u0a05\u0a23\u0a2a\u0a1b\u0a3e\u0a24\u0a3e \u0a07\u0a32\u0a3e\u0a15\u0a3e" },
            { "type.ms.metric", "\u0a2e\u0a40\u0a1f\u0a30\u0a3f\u0a15 \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40" },
            { "type.ca.iso8601", "(ISO-8601) \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "nso", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a38\u0a4b\u0a25\u0a4b" },
            { "type.nu.telu", "\u0a24\u0a47\u0a32\u0a17\u0a42 \u0a05\u0a70\u0a15" },
            { "lou", "\u0a32\u0a47\u0a09" },
            { "loz", "\u0a32\u0a4b\u0a1c\u0a3c\u0a40" },
            { "jmc", "\u0a2e\u0a1a\u0a3e\u0a2e\u0a47" },
            { "hif", "\u0a2b\u0a3f\u0a1c\u0a40 \u0a39\u0a3f\u0a70\u0a26\u0a40" },
            { "type.nu.hansfin", "\u0a38\u0a30\u0a32 \u0a1a\u0a40\u0a28\u0a40 \u0a35\u0a3f\u0a71\u0a24\u0a40 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "hil", "\u0a39\u0a3f\u0a32\u0a40\u0a17\u0a47\u0a28\u0a28" },
            { "type.nu.arabext", "\u0a35\u0a3f\u0a38\u0a24\u0a3e\u0a30\u0a3f\u0a24 \u0a05\u0a30\u0a2c\u0a40-\u0a2d\u0a3e\u0a30\u0a24\u0a40 \u0a05\u0a70\u0a15" },
            { "nus", "\u0a28\u0a41\u0a0f\u0a30" },
            { "dak", "\u0a21\u0a15\u0a4b\u0a1f\u0a3e" },
            { "type.nu.fullwide", "\u0a2a\u0a42\u0a30\u0a28 \u0a35\u0a3f\u0a38\u0a24\u0a3e\u0a30 \u0a05\u0a70\u0a15" },
            { "dar", "\u0a26\u0a3e\u0a30\u0a17\u0a35\u0a3e" },
            { "dav", "\u0a1f\u0a47\u0a1f\u0a3e" },
            { "lrc", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a32\u0a41\u0a30\u0a40" },
            { "udm", "\u0a09\u0a26\u0a2e\u0a41\u0a30\u0a24" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "\u0a07\u0a38\u0a32\u0a3e\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30 (\u0a38\u0a3e\u0a0a\u0a26\u0a40 \u0a05\u0a30\u0a2c, \u0a1a\u0a70\u0a28 \u0a26\u0a3f\u0a16\u0a23\u0a3e)" },
            { "sad", "\u0a38\u0a3e\u0a02\u0a21\u0a4b" },
            { "type.nu.roman", "\u0a30\u0a4b\u0a2e\u0a28 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "sah", "\u0a38\u0a3e\u0a16\u0a3e" },
            { "saq", "\u0a38\u0a2e\u0a2c\u0a41\u0a30\u0a42" },
            { "sat", "\u0a38\u0a70\u0a25\u0a3e\u0a32\u0a40" },
            { "sba", "\u0a28\u0a17\u0a3e\u0a02\u0a2c\u0a47" },
            { "Guru", "\u0a17\u0a41\u0a30\u0a2e\u0a41\u0a16\u0a40" },
            { "lua", "\u0a32\u0a3f\u0a0a\u0a2c\u0a3e-\u0a32\u0a3f\u0a0a\u0a32\u0a3f\u0a06" },
            { "sbp", "\u0a38\u0a47\u0a02\u0a17\u0a4b" },
            { "nyn", "\u0a28\u0a3f\u0a06\u0a02\u0a15\u0a4b\u0a32\u0a47" },
            { "lun", "\u0a32\u0a41\u0a70\u0a21\u0a3e" },
            { "luo", "\u0a32\u0a42\u0a13" },
            { "fil", "\u0a2b\u0a3f\u0a32\u0a40\u0a2a\u0a3f\u0a28\u0a4b" },
            { "hmn", "\u0a39\u0a2e\u0a4b\u0a02\u0a17" },
            { "lus", "\u0a2e\u0a3f\u0a1c\u0a3c\u0a4b" },
            { "ban", "\u0a2c\u0a3e\u0a32\u0a40\u0a28\u0a40\u0a1c\u0a3c" },
            { "luy", "\u0a32\u0a42\u0a08\u0a06" },
            { "bas", "\u0a2c\u0a3e\u0a38\u0a3e" },
            { "es_ES", "\u0a38\u0a2a\u0a47\u0a28\u0a40 (\u0a2f\u0a42\u0a30\u0a2a\u0a40)" },
            { "sco", "\u0a38\u0a15\u0a3e\u0a1f\u0a38" },
            { "scn", "\u0a38\u0a3f\u0a38\u0a40\u0a32\u0a40\u0a05\u0a28" },
            { "aa", "\u0a05\u0a2b\u0a3c\u0a3e\u0a30" },
            { "ab", "\u0a05\u0a2c\u0a16\u0a3e\u0a1c\u0a3c\u0a40\u0a05\u0a28" },
            { "Aran", "\u0a28\u0a38\u0a24\u0a3e\u0a32\u0a40\u0a15" },
            { "af", "\u0a05\u0a2b\u0a3c\u0a30\u0a40\u0a15\u0a40" },
            { "ak", "\u0a05\u0a15\u0a3e\u0a28" },
            { "am", "\u0a05\u0a2e\u0a39\u0a3e\u0a30\u0a3f\u0a15" },
            { "Arab", metaValue_ar },
            { "an", "\u0a05\u0a30\u0a3e\u0a17\u0a4b\u0a28\u0a40" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u0a1c\u0a3e\u0a2a\u0a3e\u0a28\u0a40 \u0a38\u0a3f\u0a32\u0a47\u0a2c\u0a30\u0a40\u0a1c\u0a3c" },
            { "as", "\u0a05\u0a38\u0a3e\u0a2e\u0a40" },
            { "av", "\u0a05\u0a35\u0a3e\u0a30\u0a3f\u0a15" },
            { "sdh", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a15\u0a41\u0a30\u0a26\u0a3f\u0a38\u0a3c" },
            { "ay", "\u0a05\u0a08\u0a2e\u0a3e\u0a30\u0a3e" },
            { "az", "\u0a05\u0a1c\u0a3c\u0a30\u0a2c\u0a3e\u0a08\u0a1c\u0a3e\u0a28\u0a40" },
            { "ba", "\u0a2c\u0a38\u0a3c\u0a15\u0a40\u0a30" },
            { "be", "\u0a2c\u0a47\u0a32\u0a3e\u0a30\u0a42\u0a38\u0a40" },
            { "bg", "\u0a2c\u0a41\u0a32\u0a17\u0a3e\u0a30\u0a40\u0a06\u0a08" },
            { "bi", "\u0a2c\u0a3f\u0a38\u0a32\u0a3e\u0a2e\u0a3e" },
            { "bm", "\u0a2c\u0a70\u0a2c\u0a3e\u0a30\u0a3e" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "\u0a21\u0a4b\u0a17\u0a30\u0a3f\u0a71\u0a2c" },
            { "br", "\u0a2c\u0a30\u0a47\u0a1f\u0a28" },
            { "bs", "\u0a2c\u0a4b\u0a38\u0a28\u0a40\u0a06\u0a08" },
            { "Mymr", "\u0a2e\u0a3f\u0a06\u0a02\u0a2e\u0a3e\u0a30" },
            { "type.nu.laoo", "\u0a32\u0a3e\u0a13 \u0a05\u0a70\u0a15" },
            { "seh", "\u0a38\u0a47\u0a28\u0a3e" },
            { "ca", "\u0a15\u0a48\u0a1f\u0a3e\u0a32\u0a3e\u0a28" },
            { "ses", "\u0a15\u0a4b\u0a07\u0a30\u0a3e\u0a2c\u0a4b\u0a30\u0a4b \u0a38\u0a47\u0a02\u0a28\u0a40" },
            { "ce", "\u0a1a\u0a47\u0a1a\u0a28" },
            { "ch", "\u0a1a\u0a2e\u0a4b\u0a30\u0a4b" },
            { "co", "\u0a15\u0a4b\u0a30\u0a38\u0a40\u0a15\u0a28" },
            { "Orya", metaValue_or },
            { "cs", "\u0a1a\u0a48\u0a71\u0a15" },
            { "cu", "\u0a1a\u0a30\u0a1a \u0a38\u0a32\u0a3e\u0a35\u0a40" },
            { "cv", "\u0a1a\u0a41\u0a35\u0a3e\u0a38\u0a3c" },
            { "cy", "\u0a35\u0a48\u0a32\u0a38\u0a3c" },
            { "type.nu.ethi", "\u0a10\u0a25\u0a3f\u0a13\u0a2a\u0a3f\u0a15 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "da", "\u0a21\u0a48\u0a28\u0a3f\u0a38\u0a3c" },
            { "pt_PT", "\u0a2a\u0a41\u0a30\u0a24\u0a17\u0a3e\u0a32\u0a40 (\u0a2f\u0a42\u0a30\u0a2a\u0a40)" },
            { "de", "\u0a1c\u0a30\u0a2e\u0a28" },
            { "type.cf.standard", "\u0a2e\u0a3f\u0a06\u0a30\u0a40 \u0a2e\u0a41\u0a26\u0a30\u0a3e \u0a2c\u0a23\u0a24\u0a30" },
            { "bem", "\u0a2c\u0a47\u0a2e\u0a2c\u0a3e" },
            { "type.nu.mong", "\u0a2e\u0a70\u0a17\u0a4b\u0a32 \u0a05\u0a70\u0a15" },
            { "dv", "\u0a26\u0a3f\u0a35\u0a47\u0a39\u0a40" },
            { "es_419", "\u0a38\u0a2a\u0a47\u0a28\u0a40 (\u0a32\u0a3e\u0a24\u0a40\u0a28\u0a40 \u0a05\u0a2e\u0a30\u0a40\u0a15\u0a40)" },
            { "dz", "\u0a1c\u0a3c\u0a4b\u0a02\u0a17\u0a16\u0a3e" },
            { "bez", "\u0a2c\u0a47\u0a28\u0a3e" },
            { "type.ca.chinese", "\u0a1a\u0a40\u0a28\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "dje", "\u0a1c\u0a3c\u0a3e\u0a30\u0a2e\u0a3e" },
            { "type.nu.grek", "\u0a2f\u0a42\u0a28\u0a3e\u0a28\u0a40 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "ee", "\u0a08\u0a35\u0a08" },
            { "type.lb.normal", "\u0a38\u0a27\u0a3e\u0a30\u0a28 \u0a30\u0a47\u0a16\u0a3e \u0a35\u0a3f\u0a71\u0a25 \u0a38\u0a3c\u0a48\u0a32\u0a40" },
            { "ro_MD", "\u0a2e\u0a4b\u0a32\u0a21\u0a3e\u0a35\u0a40\u0a06\u0a08" },
            { "el", metaValue_el },
            { "en", "\u0a05\u0a70\u0a17\u0a30\u0a47\u0a1c\u0a3c\u0a40" },
            { "eo", "\u0a07\u0a38\u0a2a\u0a47\u0a30\u0a3e\u0a02\u0a1f\u0a4b" },
            { "es", "\u0a38\u0a2a\u0a47\u0a28\u0a40" },
            { "et", "\u0a07\u0a38\u0a1f\u0a4b\u0a28\u0a40\u0a06\u0a08" },
            { "Hanb", "\u0a39\u0a3e\u0a02\u0a2c" },
            { "eu", "\u0a2c\u0a3e\u0a38\u0a15" },
            { "Hang", "\u0a39\u0a70\u0a17\u0a41\u0a32" },
            { "shi", "\u0a1f\u0a1a\u0a47\u0a32\u0a39\u0a3f\u0a1f" },
            { "hsb", "\u0a05\u0a71\u0a2a\u0a30 \u0a38\u0a4b\u0a30\u0a2c\u0a40\u0a05\u0a28" },
            { "Hani", "\u0a39\u0a3e\u0a28" },
            { "shn", "\u0a38\u0a3c\u0a3e\u0a28" },
            { "fa", "\u0a2b\u0a3c\u0a3e\u0a30\u0a38\u0a40" },
            { "Hans", "\u0a38\u0a30\u0a32" },
            { "type.nu.latn", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a05\u0a70\u0a15" },
            { "Hant", "\u0a30\u0a35\u0a3e\u0a07\u0a24\u0a40" },
            { "ff", "\u0a2b\u0a41\u0a32\u0a3e\u0a39" },
            { "hsn", "\u0a1a\u0a40\u0a28\u0a40 \u0a1c\u0a3c\u0a3f\u0a06\u0a02\u0a17" },
            { "fi", "\u0a2b\u0a3f\u0a28\u0a3f\u0a38\u0a3c" },
            { "fj", "\u0a2b\u0a3c\u0a3f\u0a1c\u0a3c\u0a40" },
            { "fon", "\u0a2b\u0a4c\u0a28" },
            { "bgn", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a2c\u0a32\u0a42\u0a1a\u0a40" },
            { "yue", "\u0a15\u0a48\u0a02\u0a1f\u0a4b\u0a28\u0a40\u0a1c\u0a3c" },
            { "fo", "\u0a2b\u0a3c\u0a47\u0a30\u0a4b\u0a38\u0a47" },
            { "umb", "\u0a09\u0a2e\u0a2c\u0a41\u0a70\u0a21\u0a42" },
            { "fr", "\u0a2b\u0a30\u0a3e\u0a02\u0a38\u0a40\u0a38\u0a40" },
            { "fy", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a2b\u0a4d\u0a30\u0a3f\u0a38\u0a40\u0a05\u0a28" },
            { "ga", "\u0a06\u0a07\u0a30\u0a38\u0a3c" },
            { "gd", "\u0a38\u0a15\u0a3e\u0a1f\u0a3f\u0a38\u0a3c \u0a17\u0a47\u0a32\u0a3f\u0a15" },
            { "gl", "\u0a17\u0a48\u0a32\u0a3f\u0a38\u0a3c\u0a3f\u0a05\u0a28" },
            { "gn", "\u0a17\u0a41\u0a06\u0a30\u0a3e\u0a28\u0a40" },
            { "bho", "\u0a2d\u0a4b\u0a1c\u0a2a\u0a41\u0a30\u0a40" },
            { "und", "\u0a05\u0a23\u0a2a\u0a1b\u0a3e\u0a24\u0a40 \u0a2c\u0a4b\u0a32\u0a40" },
            { "type.ca.ethiopic-amete-alem", "\u0a07\u0a25\u0a40\u0a13\u0a2a\u0a3f\u0a15-\u0a05\u0a2e\u0a40\u0a1f-\u0a06\u0a32\u0a2e" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "\u0a07\u0a38\u0a32\u0a3e\u0a2e\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30 (\u0a1f\u0a47\u0a2c\u0a32\u0a30, \u0a16\u0a17\u0a4b\u0a32\u0a40 \u0a2f\u0a41\u0a71\u0a17)" },
            { "gv", "\u0a2e\u0a48\u0a02\u0a15\u0a38" },
            { "ha", "\u0a39\u0a4c\u0a38\u0a3e" },
            { "he", metaValue_he },
            { "hi", "\u0a39\u0a3f\u0a70\u0a26\u0a40" },
            { "hup", "\u0a39\u0a42\u0a2a\u0a3e" },
            { "bin", "\u0a2c\u0a3f\u0a28\u0a40" },
            { "hr", "\u0a15\u0a4d\u0a30\u0a4b\u0a0f\u0a38\u0a3c\u0a3f\u0a06\u0a08" },
            { "ht", "\u0a39\u0a48\u0a24\u0a40\u0a06\u0a08" },
            { "hu", "\u0a39\u0a70\u0a17\u0a30\u0a40\u0a06\u0a08" },
            { "hy", metaValue_hy },
            { "hz", "\u0a39\u0a30\u0a47\u0a30\u0a4b" },
            { "frc", "\u0a15\u0a47\u0a1c\u0a41\u0a28 \u0a2b\u0a4d\u0a30\u0a47\u0a70\u0a1a" },
            { "ia", "\u0a07\u0a70\u0a1f\u0a30\u0a32\u0a3f\u0a70\u0a17\u0a41\u0a06" },
            { "Jamo", "\u0a1c\u0a3e\u0a2e\u0a4b" },
            { "id", "\u0a07\u0a70\u0a21\u0a4b\u0a28\u0a47\u0a38\u0a3c\u0a40\u0a06\u0a08" },
            { "type.nu.tibt", "\u0a24\u0a3f\u0a71\u0a2c\u0a24\u0a40 \u0a05\u0a70\u0a15" },
            { "ig", "\u0a07\u0a17\u0a2c\u0a4b" },
            { "ii", "\u0a38\u0a3f\u0a1a\u0a41\u0a06\u0a28 \u0a2f\u0a40" },
            { "io", "\u0a07\u0a21\u0a42" },
            { "is", "\u0a06\u0a08\u0a38\u0a32\u0a48\u0a02\u0a21\u0a3f\u0a15" },
            { "it", "\u0a07\u0a24\u0a3e\u0a32\u0a35\u0a40" },
            { "iu", "\u0a07\u0a70\u0a15\u0a1f\u0a40\u0a1f\u0a42\u0a24" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "sma", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a38\u0a3e\u0a2e\u0a40" },
            { "jv", "\u0a1c\u0a3e\u0a35\u0a3e\u0a28\u0a40\u0a1c\u0a3c" },
            { "mad", "\u0a2e\u0a3e\u0a21\u0a42\u0a30\u0a40\u0a38" },
            { "smj", "\u0a32\u0a3f\u0a0a\u0a32 \u0a38\u0a3e\u0a2e\u0a40" },
            { "mag", "\u0a2e\u0a17\u0a3e\u0a39\u0a40" },
            { "mai", "\u0a2e\u0a48\u0a25\u0a32\u0a40" },
            { "smn", "\u0a07\u0a28\u0a3e\u0a30\u0a40 \u0a38\u0a3e\u0a2e\u0a40" },
            { "ka", metaValue_ka },
            { "bla", "\u0a38\u0a3f\u0a15\u0a38\u0a3f\u0a15\u0a3e" },
            { "mak", "\u0a2e\u0a15\u0a3e\u0a38\u0a30" },
            { "wuu", "\u0a1a\u0a40\u0a28\u0a40 \u0a35\u0a42" },
            { "sms", "\u0a38\u0a15\u0a4c\u0a32\u0a1f \u0a38\u0a3e\u0a2e\u0a40" },
            { "ki", "\u0a15\u0a3f\u0a15\u0a42\u0a2f\u0a42" },
            { "mas", "\u0a2e\u0a38\u0a3e\u0a08" },
            { "kj", "\u0a15\u0a41\u0a06\u0a28\u0a2f\u0a3e\u0a2e\u0a3e" },
            { "kk", "\u0a15\u0a1c\u0a3c\u0a3e\u0a16\u0a3c" },
            { "kl", "\u0a15\u0a32\u0a3e\u0a05\u0a71\u0a32\u0a40\u0a38\u0a41\u0a1f" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0a15\u0a28\u0a42\u0a30\u0a40" },
            { "ks", "\u0a15\u0a38\u0a3c\u0a2e\u0a40\u0a30\u0a40" },
            { "ku", "\u0a15\u0a41\u0a30\u0a26\u0a3f\u0a38\u0a3c" },
            { "kv", "\u0a15\u0a4b\u0a2e\u0a40" },
            { "kw", "\u0a15\u0a4b\u0a30\u0a28\u0a3f\u0a38\u0a3c" },
            { "ky", "\u0a15\u0a3f\u0a30\u0a17\u0a40\u0a1c\u0a3c" },
            { "snk", "\u0a38\u0a4b\u0a28\u0a3f\u0a70\u0a15\u0a47" },
            { "la", metaValue_la },
            { "lb", "\u0a32\u0a15\u0a1c\u0a3c\u0a2e\u0a2c\u0a30\u0a17\u0a3f\u0a38\u0a3c" },
            { "type.nu.mlym", "\u0a2e\u0a32\u0a3f\u0a06\u0a32\u0a2e \u0a05\u0a70\u0a15" },
            { "lg", "\u0a17\u0a3e\u0a02\u0a21\u0a3e" },
            { "li", "\u0a32\u0a3f\u0a2e\u0a2c\u0a41\u0a30\u0a17\u0a40" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0a32\u0a3f\u0a70\u0a17\u0a3e\u0a32\u0a3e" },
            { "fur", "\u0a2b\u0a30\u0a40\u0a09\u0a32\u0a40\u0a05\u0a28" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0a07\u0a70\u0a2a\u0a40\u0a30\u0a40\u0a05\u0a32 \u0a2e\u0a3e\u0a2a \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40" },
            { "lt", "\u0a32\u0a3f\u0a25\u0a41\u0a06\u0a28\u0a40\u0a05\u0a28" },
            { "lu", "\u0a32\u0a42\u0a2c\u0a3e-\u0a15\u0a3e\u0a1f\u0a3e\u0a02\u0a17\u0a3e" },
            { "lv", "\u0a32\u0a3e\u0a24\u0a40\u0a35\u0a40" },
            { "mg", "\u0a2e\u0a3e\u0a32\u0a3e\u0a17\u0a48\u0a38\u0a40" },
            { "mh", "\u0a2e\u0a3e\u0a30\u0a38\u0a3c\u0a32\u0a40\u0a1c\u0a3c" },
            { "type.co.ducet", "\u0a2e\u0a42\u0a32 \u0a2f\u0a42\u0a28\u0a40\u0a15\u0a4b\u0a21 \u0a32\u0a5c\u0a40\u0a2c\u0a71\u0a27 \u0a15\u0a4d\u0a30\u0a2e" },
            { "mi", "\u0a2e\u0a3e\u0a09\u0a30\u0a40" },
            { "mk", "\u0a2e\u0a48\u0a15\u0a21\u0a4b\u0a28\u0a40\u0a06\u0a08" },
            { "ml", metaValue_ml },
            { "mn", "\u0a2e\u0a70\u0a17\u0a4b\u0a32\u0a40" },
            { "mr", "\u0a2e\u0a30\u0a3e\u0a20\u0a40" },
            { "ms", "\u0a2e\u0a32\u0a2f" },
            { "mt", "\u0a2e\u0a3e\u0a32\u0a1f\u0a40\u0a1c\u0a3c" },
            { "my", "\u0a2c\u0a30\u0a2e\u0a40" },
            { "Armn", metaValue_hy },
            { "mdf", "\u0a2e\u0a4b\u0a15\u0a38\u0a3c\u0a3e" },
            { "dsb", "\u0a32\u0a4b\u0a05\u0a30 \u0a38\u0a4b\u0a30\u0a2c\u0a40\u0a05\u0a28" },
            { "na", metaValue_NR },
            { "type.co.search", "\u0a06\u0a2e-\u0a2e\u0a70\u0a24\u0a35 \u0a16\u0a4b\u0a1c" },
            { "nb", "\u0a28\u0a3e\u0a30\u0a35\u0a47\u0a1c\u0a3f\u0a06\u0a08 \u0a2c\u0a4b\u0a15\u0a2e\u0a32" },
            { "nd", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a28\u0a21\u0a47\u0a2c\u0a47\u0a32\u0a47" },
            { "ne", "\u0a28\u0a47\u0a2a\u0a3e\u0a32\u0a40" },
            { "ng", "\u0a10\u0a02\u0a21\u0a4b\u0a02\u0a17\u0a3e" },
            { "nl", "\u0a21\u0a71\u0a1a" },
            { "nn", "\u0a28\u0a3e\u0a30\u0a35\u0a47\u0a1c\u0a3f\u0a06\u0a08 \u0a28\u0a3f\u0a13\u0a28\u0a4c\u0a30\u0a38\u0a15" },
            { "no", "\u0a28\u0a3e\u0a30\u0a35\u0a47\u0a1c\u0a3f\u0a06\u0a08" },
            { "nr", "\u0a38\u0a3e\u0a0a\u0a25 \u0a28\u0a21\u0a47\u0a2c\u0a47\u0a32\u0a47" },
            { "nv", "\u0a28\u0a35\u0a3e\u0a1c\u0a4b" },
            { "ny", "\u0a28\u0a2f\u0a3e\u0a02\u0a1c\u0a3e" },
            { "kac", "\u0a15\u0a3e\u0a1a\u0a3f\u0a28" },
            { "kab", "\u0a15\u0a2c\u0a3e\u0a07\u0a32" },
            { "oc", "\u0a13\u0a15\u0a38\u0a40\u0a1f\u0a3e\u0a28" },
            { "kaj", "\u0a1c\u0a1c\u0a42" },
            { "kam", "\u0a15\u0a70\u0a2c\u0a3e" },
            { "men", "\u0a2e\u0a47\u0a02\u0a21\u0a47" },
            { "mer", "\u0a2e\u0a47\u0a30\u0a42" },
            { "type.nu.armn", "\u0a06\u0a30\u0a2e\u0a40\u0a28\u0a40\u0a05\u0a28 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "om", "\u0a13\u0a30\u0a4b\u0a2e\u0a4b" },
            { "or", metaValue_or },
            { "os", "\u0a13\u0a38\u0a48\u0a1f\u0a3f\u0a15" },
            { "kbd", "\u0a15\u0a2c\u0a3e\u0a30\u0a26\u0a40" },
            { "mfe", "\u0a2e\u0a4b\u0a30\u0a40\u0a38\u0a3f\u0a05\u0a28" },
            { "srn", "\u0a38\u0a4d\u0a30\u0a3e\u0a28\u0a3e\u0a28 \u0a1f\u0a4b\u0a02\u0a17\u0a4b" },
            { "pa", "\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40" },
            { "dua", "\u0a21\u0a42\u0a06\u0a32\u0a3e" },
            { "pi", "\u0a2a\u0a3e\u0a32\u0a40" },
            { "pl", "\u0a2a\u0a4b\u0a32\u0a48\u0a02\u0a21\u0a40" },
            { "type.ca.dangi", "\u0a21\u0a3e\u0a02\u0a17\u0a40 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "ps", "\u0a2a\u0a38\u0a3c\u0a24\u0a4b" },
            { "pt", "\u0a2a\u0a41\u0a30\u0a24\u0a17\u0a3e\u0a32\u0a40" },
            { "key.co", "\u0a32\u0a5c\u0a40\u0a2c\u0a71\u0a27 \u0a15\u0a4d\u0a30\u0a2e" },
            { "pt_BR", "\u0a2a\u0a41\u0a30\u0a24\u0a17\u0a3e\u0a32\u0a40 (\u0a2c\u0a4d\u0a30\u0a3e\u0a1c\u0a3c\u0a40\u0a32\u0a40)" },
            { "kcg", "\u0a1f\u0a3e\u0a07\u0a2a" },
            { "mgh", "\u0a2e\u0a16\u0a4b\u0a35\u0a3e-\u0a2e\u0a3f\u0a71\u0a1f\u0a4b" },
            { "key.cf", "\u0a2e\u0a41\u0a26\u0a30\u0a3e \u0a2c\u0a23\u0a24\u0a30" },
            { "key.ca", "\u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u0a2e\u0a47\u0a1f\u0a3e" },
            { "type.hc.h23", "24 \u0a18\u0a70\u0a1f\u0a47 \u0a26\u0a40 \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40 (0\u201323)" },
            { "type.hc.h24", "24 \u0a18\u0a70\u0a1f\u0a47 \u0a26\u0a40 \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40 (1\u201324)" },
            { "ssy", "\u0a38\u0a3e\u0a39\u0a4b" },
            { "type.nu.mymr", "\u0a2e\u0a3f\u0a06\u0a02\u0a2e\u0a3e\u0a30 \u0a05\u0a70\u0a15" },
            { "qu", "\u0a15\u0a15\u0a47\u0a38\u0a3c\u0a41\u0a06" },
            { "brx", "\u0a2c\u0a4b\u0a21\u0a4b" },
            { "kde", "\u0a2e\u0a15\u0a4b\u0a02\u0a21" },
            { "Ethi", "\u0a07\u0a25\u0a40\u0a13\u0a2a\u0a3f\u0a15" },
            { "type.hc.h12", "12 \u0a18\u0a70\u0a1f\u0a47 \u0a26\u0a40 \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40 (1\u201312)" },
            { "type.hc.h11", "12 \u0a18\u0a70\u0a1f\u0a47 \u0a26\u0a40 \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40 (0\u201311)" },
            { "rm", "\u0a30\u0a4b\u0a2e\u0a3e\u0a02\u0a38\u0a3c" },
            { "rn", "\u0a30\u0a41\u0a70\u0a21\u0a40" },
            { "key.cu", "\u0a2e\u0a41\u0a26\u0a30\u0a3e" },
            { "ro", "\u0a30\u0a4b\u0a2e\u0a3e\u0a28\u0a40\u0a06\u0a08" },
            { "type.nu.orya", "\u0a09\u0a5c\u0a40\u0a06 \u0a05\u0a70\u0a15" },
            { "type.nu.hanidec", "\u0a1a\u0a40\u0a28\u0a40 \u0a26\u0a38\u0a3c\u0a2e\u0a32\u0a35 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "ru", "\u0a30\u0a42\u0a38\u0a40" },
            { "rw", "\u0a15\u0a3f\u0a28\u0a3f\u0a06\u0a30\u0a35\u0a3e\u0a02\u0a21\u0a3e" },
            { "kea", "\u0a15\u0a3e\u0a2c\u0a41\u0a35\u0a47\u0a30\u0a26\u0a3f\u0a06\u0a28\u0a42" },
            { "mic", "\u0a2e\u0a3e\u0a07\u0a2e\u0a48\u0a15" },
            { "suk", "\u0a38\u0a41\u0a15\u0a41\u0a2e\u0a3e" },
            { "sa", "\u0a38\u0a70\u0a38\u0a15\u0a4d\u0a30\u0a3f\u0a24" },
            { "sc", "\u0a38\u0a3e\u0a30\u0a21\u0a40\u0a28\u0a40\u0a06\u0a08" },
            { "sd", "\u0a38\u0a3f\u0a70\u0a27\u0a40" },
            { "se", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a38\u0a3e\u0a2e\u0a40" },
            { "min", "\u0a2e\u0a3f\u0a28\u0a3e\u0a02\u0a17\u0a15\u0a3e\u0a2c\u0a3e\u0a13" },
            { "sg", "\u0a38\u0a3e\u0a02\u0a17\u0a4b" },
            { "si", metaValue_si },
            { "sk", "\u0a38\u0a32\u0a4b\u0a35\u0a3e\u0a15" },
            { "sl", "\u0a38\u0a32\u0a4b\u0a35\u0a47\u0a28\u0a40\u0a06\u0a08" },
            { "sm", "\u0a38\u0a3e\u0a2e\u0a4b\u0a28" },
            { "sn", "\u0a38\u0a3c\u0a4b\u0a28\u0a3e" },
            { "so", "\u0a38\u0a4b\u0a2e\u0a3e\u0a32\u0a40" },
            { "type.nu.arab", "\u0a05\u0a30\u0a2c\u0a40-\u0a2d\u0a3e\u0a30\u0a24\u0a40 \u0a05\u0a70\u0a15" },
            { "sq", "\u0a05\u0a32\u0a2c\u0a3e\u0a28\u0a40\u0a06\u0a08" },
            { "sr", "\u0a38\u0a30\u0a2c\u0a40\u0a06\u0a08" },
            { "ss", "\u0a38\u0a35\u0a3e\u0a24\u0a40" },
            { "type.cf.account", "\u0a32\u0a47\u0a16\u0a3e \u0a2e\u0a41\u0a26\u0a30\u0a3e \u0a2c\u0a23\u0a24\u0a30" },
            { "st", "\u0a26\u0a71\u0a16\u0a23\u0a40 \u0a38\u0a4b\u0a25\u0a4b" },
            { "su", "\u0a38\u0a42\u0a70\u0a21\u0a3e\u0a28\u0a40" },
            { "sv", "\u0a38\u0a35\u0a40\u0a21\u0a3f\u0a38\u0a3c" },
            { "sw", "\u0a38\u0a35\u0a3e\u0a39\u0a3f\u0a32\u0a40" },
            { "type.nu.hantfin", "\u0a30\u0a35\u0a3e\u0a07\u0a24\u0a40 \u0a1a\u0a40\u0a28\u0a40 \u0a35\u0a3f\u0a71\u0a24\u0a40 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "ibb", "\u0a07\u0a2c\u0a40\u0a2c\u0a40\u0a13" },
            { "iba", "\u0a07\u0a2c\u0a3e\u0a28" },
            { "ta", metaValue_ta },
            { "142", "\u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "143", "\u0a15\u0a47\u0a02\u0a26\u0a30\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "te", metaValue_te },
            { "145", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a0f\u0a38\u0a3c\u0a40\u0a06" },
            { "tg", "\u0a24\u0a3e\u0a1c\u0a3f\u0a15" },
            { "th", metaValue_th },
            { "ti", "\u0a24\u0a3f\u0a17\u0a4d\u0a30\u0a40\u0a28\u0a3f\u0a06" },
            { "bug", "\u0a2c\u0a17\u0a28\u0a40\u0a1c\u0a3c" },
            { "kfo", "\u0a15\u0a4b\u0a30\u0a4b" },
            { "tk", "\u0a24\u0a41\u0a30\u0a15\u0a2e\u0a47\u0a28" },
            { "tn", "\u0a24\u0a38\u0a35\u0a3e\u0a28\u0a3e" },
            { "to", "\u0a1f\u0a4c\u0a02\u0a17\u0a28" },
            { "dyo", "\u0a1c\u0a4b\u0a32\u0a3e-\u0a2b\u0a4b\u0a07\u0a28\u0a40" },
            { "type.nu.jpan", "\u0a1c\u0a2a\u0a3e\u0a28\u0a40 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "tr", metaValue_TR },
            { "ts", "\u0a38\u0a4b\u0a02\u0a17\u0a3e" },
            { "swb", "\u0a15\u0a4b\u0a2e\u0a4b\u0a30\u0a40\u0a05\u0a28" },
            { "tt", "\u0a24\u0a24\u0a3e\u0a30" },
            { "tw", "\u0a24\u0a4d\u0a35\u0a3f" },
            { "ty", "\u0a24\u0a3e\u0a39\u0a40\u0a1f\u0a40" },
            { "150", "\u0a2f\u0a42\u0a30\u0a2a" },
            { "151", "\u0a2a\u0a42\u0a30\u0a2c\u0a40 \u0a2f\u0a42\u0a30\u0a2a" },
            { "154", "\u0a09\u0a71\u0a24\u0a30\u0a40 \u0a2f\u0a42\u0a30\u0a2a" },
            { "dzg", "\u0a21\u0a1c\u0a3c\u0a3e\u0a17\u0a3e" },
            { "155", "\u0a2a\u0a71\u0a1b\u0a2e\u0a40 \u0a2f\u0a42\u0a30\u0a2a" },
            { "ug", "\u0a09\u0a07\u0a17\u0a41\u0a30" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u0a38\u0a27\u0a3e\u0a30\u0a28" },
            { "uk", "\u0a2f\u0a42\u0a15\u0a30\u0a47\u0a28\u0a40\u0a06\u0a08" },
            { "type.ca.coptic", "\u0a15\u0a4b\u0a2a\u0a1f\u0a3f\u0a15 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "ur", "\u0a09\u0a30\u0a26\u0a42" },
            { "xal", "\u0a15\u0a3e\u0a32\u0a2e\u0a3f\u0a15" },
            { "uz", "\u0a09\u0a1c\u0a3c\u0a2c\u0a47\u0a15" },
            { "kha", "\u0a16\u0a3e\u0a38\u0a40" },
            { "nds_NL", "\u0a32\u0a4b \u0a38\u0a48\u0a15\u0a38\u0a28" },
            { "ve", "\u0a35\u0a47\u0a02\u0a21\u0a3e" },
            { "type.ca.roc", "\u0a2e\u0a3f\u0a70\u0a17\u0a42\u0a13 \u0a15\u0a48\u0a32\u0a70\u0a21\u0a30" },
            { "vi", "\u0a35\u0a40\u0a05\u0a24\u0a28\u0a3e\u0a2e\u0a40" },
            { "khq", "\u0a15\u0a4b\u0a2f\u0a30\u0a3e \u0a1a\u0a40\u0a28\u0a40" },
            { "key.hc", "\u0a18\u0a70\u0a1f\u0a47 \u0a26\u0a3e \u0a1a\u0a71\u0a15\u0a30 (12 \u0a2c\u0a28\u0a3e\u0a2e 24)" },
            { "vo", "\u0a35\u0a4b\u0a32\u0a3e\u0a2a\u0a42\u0a15" },
            { "quc", "\u0a15\u0a47\u0a38\u0a3c" },
            { "gaa", "\u0a17\u0a3e" },
            { "wa", "\u0a35\u0a32\u0a42\u0a28" },
            { "gag", "\u0a17\u0a3e\u0a17\u0a4c\u0a1c\u0a3c" },
            { "syr", "\u0a38\u0a40\u0a30\u0a40\u0a06\u0a08" },
            { "Grek", metaValue_el },
            { "gan", "\u0a1a\u0a40\u0a28\u0a40 \u0a17\u0a3e\u0a28" },
            { "wo", "\u0a35\u0a4b\u0a32\u0a4b\u0a2b" },
            { "zgh", "\u0a2e\u0a3f\u0a06\u0a30\u0a40 \u0a2e\u0a4b\u0a30\u0a4b\u0a15\u0a47\u0a28 \u0a1f\u0a3e\u0a2e\u0a3e\u0a1c\u0a3c\u0a3f\u0a15" },
            { "ar_001", "\u0a06\u0a27\u0a41\u0a28\u0a3f\u0a15 \u0a2e\u0a3f\u0a06\u0a30\u0a40 \u0a05\u0a30\u0a2c\u0a40" },
            { "Mong", "\u0a2e\u0a70\u0a17\u0a4b\u0a32\u0a40\u0a05\u0a28" },
            { "mni", "\u0a2e\u0a28\u0a40\u0a2a\u0a41\u0a30\u0a40" },
            { "Latn", metaValue_la },
            { "type.nu.hans", "\u0a38\u0a30\u0a32 \u0a1a\u0a40\u0a28\u0a40 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "type.nu.hant", "\u0a30\u0a35\u0a3e\u0a07\u0a24\u0a40 \u0a1a\u0a40\u0a28\u0a40 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "xh", "\u0a16\u0a4b\u0a38\u0a3e" },
            { "type.nu.romanlow", "\u0a30\u0a4b\u0a2e\u0a28 \u0a32\u0a4b\u0a05\u0a30\u0a15\u0a47\u0a38 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "byn", "\u0a2c\u0a32\u0a3f\u0a28" },
            { "moh", "\u0a2e\u0a4b\u0a39\u0a06\u0a15" },
            { "kkj", "\u0a15\u0a3e\u0a15\u0a4b" },
            { "yi", "\u0a2f\u0a3f\u0a26\u0a3f\u0a38\u0a3c" },
            { "mos", "\u0a2e\u0a4b\u0a38\u0a40" },
            { "yo", "\u0a2f\u0a4b\u0a30\u0a42\u0a2c\u0a3e" },
            { "es_MX", "\u0a38\u0a2a\u0a47\u0a28\u0a40 (\u0a2e\u0a48\u0a15\u0a38\u0a40\u0a15\u0a40)" },
            { "vai", "\u0a35\u0a3e\u0a08" },
            { "kln", "\u0a15\u0a32\u0a47\u0a1c\u0a3f\u0a28" },
            { "zh", "\u0a1a\u0a40\u0a28\u0a40 (\u0a2e\u0a48\u0a02\u0a21\u0a30\u0a3f\u0a28)" },
            { "Bopo", "\u0a2c\u0a4b\u0a2a\u0a4b\u0a2e\u0a4b\u0a2b\u0a4b" },
            { "key.lb", "\u0a30\u0a47\u0a16\u0a3e \u0a35\u0a3f\u0a71\u0a25 \u0a38\u0a3c\u0a48\u0a32\u0a40" },
            { "zu", "\u0a1c\u0a3c\u0a41\u0a32\u0a42" },
            { "Geor", metaValue_ka },
            { "kmb", "\u0a15\u0a3f\u0a2e\u0a2c\u0a41\u0a70\u0a26\u0a42" },
            { "type.nu.jpanfin", "\u0a1c\u0a2a\u0a3e\u0a28\u0a40 \u0a35\u0a3f\u0a71\u0a24\u0a40 \u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "gez", "\u0a1c\u0a40\u0a1c\u0a3c" },
            { "ebu", "\u0a07\u0a70\u0a2c\u0a42" },
            { "zh_Hans", "\u0a1a\u0a40\u0a28\u0a40 (\u0a38\u0a30\u0a32)" },
            { "koi", "\u0a15\u0a4b\u0a2e\u0a40-\u0a2a\u0a47\u0a30\u0a2e\u0a3f\u0a06\u0a15" },
            { "kok", "\u0a15\u0a4b\u0a02\u0a15\u0a23\u0a40" },
            { "zh_Hant", "\u0a1a\u0a40\u0a28\u0a40 (\u0a30\u0a35\u0a3e\u0a07\u0a24\u0a40)" },
            { "kpe", "\u0a15\u0a2a\u0a47\u0a32" },
            { "type.nu.khmr", "\u0a16\u0a2e\u0a47\u0a30 \u0a05\u0a70\u0a15" },
            { "ilo", "\u0a07\u0a32\u0a4b\u0a15\u0a4b" },
            { "mua", "\u0a2e\u0a41\u0a70\u0a21\u0a47\u0a02\u0a17" },
            { "type.nu.guru", "\u0a17\u0a41\u0a30\u0a2e\u0a41\u0a16\u0a40 \u0a05\u0a70\u0a15" },
            { "mul", "\u0a2c\u0a39\u0a41\u0a24\u0a40\u0a06\u0a02 \u0a2c\u0a4b\u0a32\u0a40\u0a06\u0a02" },
            { "key.ms", "\u0a2e\u0a3e\u0a2a \u0a2a\u0a4d\u0a30\u0a23\u0a3e\u0a32\u0a40" },
            { "mus", "\u0a15\u0a4d\u0a30\u0a40\u0a15" },
            { "gil", "\u0a17\u0a3f\u0a32\u0a2c\u0a30\u0a24\u0a40\u0a1c\u0a3c" },
            { "type.nu.tamldec", "\u0a24\u0a2e\u0a3f\u0a32 \u0a05\u0a70\u0a15" },
            { "krc", "\u0a15\u0a30\u0a3e\u0a1a\u0a47 \u0a2c\u0a32\u0a15\u0a3e\u0a30" },
            { "inh", "\u0a07\u0a70\u0a17\u0a41\u0a38\u0a3c" },
            { "fa_AF", "\u0a26\u0a3e\u0a30\u0a40" },
            { "krl", "\u0a15\u0a30\u0a40\u0a32\u0a40\u0a05\u0a28" },
            { "efi", "\u0a10\u0a2b\u0a3f\u0a15" },
            { "key.nu", "\u0a38\u0a70\u0a16\u0a3f\u0a06\u0a35\u0a3e\u0a02" },
            { "kru", "\u0a15\u0a41\u0a30\u0a41\u0a16" },
            { "ksb", "\u0a38\u0a3c\u0a70\u0a2c\u0a3e\u0a32\u0a3e" },
            { "Telu", metaValue_te },
            { "ksf", "\u0a2c\u0a2b\u0a3c\u0a40\u0a06" },
        };
        return data;
    }
}
