/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ha extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_GR = "Girka";
        final String metaValue_ar = "Larabci";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Ibrananci";
        final Object[][] data = new Object[][] {
            { "sbp", "Sangu" },
            { "ksh", "Colognian" },
            { "nyn", "Nyankole" },
            { "luo", "Luo" },
            { "Zsym", "Alamomi" },
            { "fil", "Dan Filifin" },
            { "hmn", "Hmong" },
            { "Zsye", "Alama ta hoto" },
            { "ccp", "Chakma" },
            { "luy", "Luyia" },
            { "bas", "Basaa" },
            { "es_ES", "Sifaniyanci Turai" },
            { "teo", "Teso" },
            { "AC", "Tsibirin Ascension" },
            { "AD", "Andora" },
            { "AE", "Ha\u0257a\u0257\u0257iyar Daular Larabawa" },
            { "AF", "Afaganistan" },
            { "af", "Afirkanci" },
            { "AG", "Antigwa da Barbuba" },
            { "type.ca.ethiopic", "Kalanda Etiofic" },
            { "AI", "Angila" },
            { "ak", "Akan" },
            { "AL", "Albaniya" },
            { "AM", "Armeniya" },
            { "am", "Amharik" },
            { "Arab", metaValue_ar },
            { "AO", "Angola" },
            { "AQ", "Antatika" },
            { "Jpan", "Jafanis" },
            { "ar", metaValue_ar },
            { "AR", "Arjantiniya" },
            { "Hrkt", "kalaman Jafananci" },
            { "AS", "Samowa Ta Amurka" },
            { "as", "Asamisanci" },
            { "AT", "Ostiriya" },
            { "AU", "Ostareliya" },
            { "AW", "Aruba" },
            { "en_US", "Turanci Amirka" },
            { "AX", "Tsibirai na \u00c5land" },
            { "AZ", "Azarbaijan" },
            { "az", "Azerbaijanci" },
            { "BA", "Bosniya Harzagobina" },
            { "BB", "Barbadas" },
            { "ceb", "Cebuano" },
            { "BD", "Bangiladas" },
            { "BE", "Belgiyom" },
            { "be", "Belarusanci" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgariya" },
            { "bg", "Bulgaranci" },
            { "BH", "Baharan" },
            { "BI", "Burundi" },
            { "BJ", "Binin" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Barmuda" },
            { "bm", "Bambara" },
            { "BN", "Burune" },
            { "bn", "Bengali" },
            { "BO", "Bolibiya" },
            { "bo", "Tibetan" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Birazil" },
            { "br", "Buretananci" },
            { "BS", "Bahamas" },
            { "bs", "Bosniyanci" },
            { "xog", "Soga" },
            { "BT", "Butan" },
            { "BV", "Tsibirin Bouvet" },
            { "BW", "Baswana" },
            { "Mymr", "\u0198asar Myanmar" },
            { "type.nu.laoo", "Lambobin Yaren Lao" },
            { "BY", "Belarus" },
            { "seh", "Sena" },
            { "BZ", "Beliz" },
            { "type.ca.persian", "Kalanda Farisa" },
            { "type.nu.hebr", "Lambobin \u0199irga na Hebrew" },
            { "CA", "Kanada" },
            { "ca", "Kataloniyanci" },
            { "CC", "Tsibirai Cocos (Keeling)" },
            { "mzn", "Mazanderani" },
            { "ses", "Koyraboro Senni" },
            { "CD", "Jamhuriyar Dimokura\u0257iyyar Kongo" },
            { "ce", "Chechen" },
            { "CF", "Jamhuriyar Afirka Ta Tsakiya" },
            { "CG", "Kongo" },
            { "CH", "Suwizalan" },
            { "CI", "Aibari Kwas" },
            { "CK", "Tsibiran Kuku" },
            { "CL", "Cayile" },
            { "CM", "Kamaru" },
            { "CN", "Sin" },
            { "CO", "Kolambiya" },
            { "co", "Corsican" },
            { "CP", "Tsibirin Clipperton" },
            { "Orya", "Yaren Odia" },
            { "CR", "Kwasta Rika" },
            { "cs", "Harshen Cak" },
            { "CU", "Kyuba" },
            { "cu", "Church Slavic" },
            { "CV", "Tsibiran Kap Barde" },
            { "CW", "Kasar Cura\u00e7ao" },
            { "CX", "Tsibirin Kirsmati" },
            { "CY", "Sifurus" },
            { "cy", "Kabilar Welsh" },
            { "CZ", "Jamhuriyar Cak" },
            { "type.nu.ethi", "Lambobin \u0199irga na Ethiopia" },
            { "da", "Danish" },
            { "pt_PT", "Fotugis kasashen Turai" },
            { "DE", "Jamus" },
            { "de", "Jamusanci" },
            { "cgg", "Chiga" },
            { "DG", "Tsibirn Diego Garcia" },
            { "type.cf.standard", "Tsarin Kudi Nagartacce" },
            { "type.nu.deva", "Lambobin Tsarin Rubutu na Devangari" },
            { "DJ", "Jibuti" },
            { "DK", "Danmark" },
            { "Brai", "Rubutun Makafi" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "Kananan Haruffan Armenia" },
            { "DO", "Jamhuriyar Dominika" },
            { "bem", "Bemba" },
            { "es_419", "Sifaniyancin Latin Amirka" },
            { "DZ", "Aljeriya" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Kalanda Sin" },
            { "EA", "Ceuta & Melilla" },
            { "EC", "Ekwador" },
            { "dje", "Zarma" },
            { "type.nu.grek", "Lambobin \u0199irga na Girka" },
            { "EE", "Estoniya" },
            { "ee", "Ewe" },
            { "type.lb.normal", "Salo na Raba Layi na Kodayaushe" },
            { "EG", "Misira" },
            { "EH", "Yammacin Sahara" },
            { "el", "Girkanci" },
            { "en", "Turanci" },
            { "eo", "D\u02bcan/\u02bcYar Kabilar Andalus" },
            { "chr", "Cherokee" },
            { "ER", "Eritireya" },
            { "ES", "Sipen" },
            { "es", "Sifaniyanci" },
            { "ET", "Habasha" },
            { "et", "Istoniyanci" },
            { "Hanb", "Han with Bopomofo" },
            { "EU", "Tarayyar Turai" },
            { "eu", "Basque" },
            { "Hang", "Yaren Hangul" },
            { "type.ca.gregorian", "Gregorian Kalanda" },
            { "EZ", "Sashin Turai" },
            { "shi", "Tachelhit" },
            { "type.nu.gujr", "Lambobin Yaren Gujarati" },
            { "hsb", "Sorbianci ta Sama" },
            { "Hani", "Mutanen Han na \u0199asar Sin" },
            { "fa", "Parisanci" },
            { "Hans", "Sau\u0199a\u0199a\u0199\u0199en" },
            { "type.nu.latn", "Lambobi na yammacin" },
            { "Hant", "Na gargajiya" },
            { "ff", "Fulah" },
            { "FI", "Finlan" },
            { "fi", "Yaren mutanen Finland" },
            { "FJ", "Fiji" },
            { "FK", "Tsibiran Falkilan" },
            { "FM", "Mikuronesiya" },
            { "yue", "Cantonese" },
            { "FO", "Tsibirai na Faroe" },
            { "fo", "Faroese" },
            { "Taml", "Yaren Tamil" },
            { "FR", "Faransa" },
            { "fr", "Faransanci" },
            { "fy", "K\u02bcabilan Firsi" },
            { "GA", "Gabon" },
            { "ga", "Dan Ailan" },
            { "GB", "Biritaniya" },
            { "GD", "Girnada" },
            { "gd", "K\u02bcabilan Scots Gaelic" },
            { "GE", "Jiwarjiya" },
            { "GF", "Gini Ta Faransa" },
            { "GG", "Yankin Guernsey" },
            { "GH", "Gana" },
            { "GI", "Jibaraltar" },
            { "GL", "Grinlan" },
            { "gl", "Bagalike" },
            { "GM", "Gambiya" },
            { "GN", "Gini" },
            { "GP", "Gwadaluf" },
            { "GQ", "Gini Ta Ikwaita" },
            { "und", "Harshen da ba a sani ba" },
            { "GR", metaValue_GR },
            { "GS", "Kudancin Geogia da Kudancin Tsibirin Sandiwic" },
            { "GT", "Gwatamala" },
            { "gu", metaValue_gu },
            { "GU", "Gwam" },
            { "gv", "Manx" },
            { "GW", "Gini Bisau" },
            { "GY", "Guyana" },
            { "ha", "Hausa" },
            { "ckb", "Kurdish na Tsaka" },
            { "zxx", "Babu abun-ciki na yare" },
            { "he", metaValue_he },
            { "hi", "Harshen Hindi" },
            { "de_AT", "Jamusanci Ostiriya" },
            { "HK", "Hong Kong Babban Birnin Kasar Chana" },
            { "HM", "Tsibirin Heard da McDonald" },
            { "HN", "Honduras" },
            { "HR", "Kurowaishiya" },
            { "hr", "Kuroshiyan" },
            { "agq", "Aghem" },
            { "gsw", "Jamusanci Swiss" },
            { "HT", "Haiti" },
            { "ht", "Haitian Creole" },
            { "HU", "Hungari" },
            { "hu", "Harshen Hungari" },
            { "hy", "Armeniyanci" },
            { "ia", "Yare Tsakanin Kasashe" },
            { "IC", "Canary Islands" },
            { "ID", "Indunusiya" },
            { "id", "Harshen Indunusiya" },
            { "type.nu.tibt", "Lambobin yaren Tibet" },
            { "IE", "Ayalan" },
            { "ig", "Inyamuranci" },
            { "naq", "Nama" },
            { "ii", "Sichuan Yi" },
            { "IL", "Izira\u02bcila" },
            { "IM", "Isle na Mutum" },
            { "IN", "Indiya" },
            { "IO", "Yankin Birtaniya Na Tekun Indiya" },
            { "IQ", "Ira\u0199i" },
            { "IR", "Iran" },
            { "IS", "Aisalan" },
            { "is", "Yaren mutanen Iceland" },
            { "IT", "Italiya" },
            { "it", "Italiyanci" },
            { "Zmth", "Alamar Lissafi" },
            { "type.nu.thai", "Lambobin yaren Thai" },
            { "type.nu.beng", "Lambobin Yaren Bangla" },
            { "ja", "Japananci" },
            { "Mlym", "Yaren Malayalam" },
            { "JE", "Kasar Jersey" },
            { "type.ca.islamic", "Kalandar Musulunci" },
            { "JM", "Jamaika" },
            { "Beng", "Bangla" },
            { "JO", "Jordan" },
            { "JP", "J\u00e0p\u00e2n" },
            { "jv", "Jabananci" },
            { "guz", "Gusii" },
            { "type.nu.knda", "Lambobin Yaren Kannada" },
            { "de_CH", "Jamusanci Suwizalan" },
            { "smn", "Inari Sami" },
            { "ka", "Jojiyanci" },
            { "type.ca.buddhist", "Kalanda Buddist" },
            { "KE", "Kenya" },
            { "419", "Latin America" },
            { "KG", "Kirgizistan" },
            { "KH", "Kambodiya" },
            { "KI", "Kiribati" },
            { "ki", "Kikuyu" },
            { "mas", "Harshen Masai" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "KM", "Kwamoras" },
            { "km", "Harshen Kimar" },
            { "KN", "San Kiti Da Nebis" },
            { "kn", "Kannada" },
            { "Knda", "Yaren Kannada" },
            { "fr_CA", "Farasanci Kanada" },
            { "ko", "Harshen Koreya" },
            { "KP", "Koriya Ta Arewa" },
            { "KR", "Koriya Ta Kudu" },
            { "ks", "Kashmiri" },
            { "ku", "Kurdanci" },
            { "fr_CH", "Farasanci Suwizalan" },
            { "KW", "Kwiyat" },
            { "kw", "Cornish" },
            { "KY", "Tsibiran Kaiman" },
            { "ky", "Kirgizanci" },
            { "KZ", "Kazakistan" },
            { "Cyrl", "Cyrillic" },
            { "LA", "Lawas" },
            { "la", "Dan Kabilar Latin" },
            { "LB", "Labanan" },
            { "lb", "Luxembourgish" },
            { "LC", "San Lusiya" },
            { "type.nu.mlym", "Lambobin Yaren Malayalam" },
            { "lg", "Ganda" },
            { "nds", "Low German" },
            { "LI", "Licansitan" },
            { "LK", "Siri Lanka" },
            { "Tibt", "Yaren Tibet" },
            { "ln", "Lingala" },
            { "fur", "Friulian" },
            { "lo", "Laothian" },
            { "type.ms.uksystem", "Tsarin Awo na Imperial" },
            { "LR", "Laberiya" },
            { "LS", "Lesoto" },
            { "LT", "Lituweniya" },
            { "lt", "Lituweniyanci" },
            { "LU", "Lukusambur" },
            { "lu", "Luba-Katanga" },
            { "LV", "latibiya" },
            { "lv", "Latbiyanci" },
            { "Kana", "Tsarin Rubutun Katakana" },
            { "LY", "Libiya" },
            { "vun", "Vunjo" },
            { "lag", "Langi" },
            { "Thaa", "Yaren Thaana" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Maldoba" },
            { "ME", "Mantanegara" },
            { "MF", "St. Martin" },
            { "MG", "Madagaskar" },
            { "mg", "Malagasy" },
            { "MH", "Tsibiran Marshal" },
            { "type.co.ducet", "Tsarin Rabewa na Dan-ma\u0199alu na Asali" },
            { "mi", "Maori" },
            { "MK", "Macedonia ta Arewa" },
            { "mk", "Dan Masedoniya" },
            { "ML", "Mali" },
            { "ml", "Kabilar Maleyalam" },
            { "MM", "Burma, Miyamar" },
            { "MN", "Mangoliya" },
            { "mn", "Mongolian" },
            { "MO", "Babban Birnin Mulki na Chana" },
            { "MP", "Tsibiran Mariyana Na Arewa" },
            { "MQ", "Martinik" },
            { "MR", "Moritaniya" },
            { "mr", "K\u02bcabilan Marathi" },
            { "MS", "Manserati" },
            { "ms", "Harshen Malai" },
            { "MT", "Malta" },
            { "mt", "Harshen Maltis" },
            { "MU", "Moritus" },
            { "MV", "Maldibi" },
            { "MW", "Malawi" },
            { "MX", "Makasiko" },
            { "type.ca.japanese", "Kalanda Jafan" },
            { "MY", "Malaisiya" },
            { "my", "Burmanci" },
            { "MZ", "Mozambik" },
            { "Armn", "Armeniyawa" },
            { "dsb", "Lower Sorbian" },
            { "NA", "Namibiya" },
            { "type.co.search", "Bincike na Dalilai-Gamagari" },
            { "202", "Sub-Saharan Africa" },
            { "nb", "Norwegian Bokm\u00e5l" },
            { "type.ca.hebrew", "Kalanda Ibrananci" },
            { "NC", "Kaledoniya Sabuwa" },
            { "nd", "North Ndebele" },
            { "NE", "Nijar" },
            { "ne", "Nepali" },
            { "NF", "Tsibirin Narfalk" },
            { "NG", "Najeriya" },
            { "NI", "Nikaraguwa" },
            { "NL", "Holan" },
            { "nl", "Holanci" },
            { "nn", "Norwegian Nynorsk" },
            { "NO", "Norwe" },
            { "NP", "Nefal" },
            { "NR", "Nauru" },
            { "NU", "Niyu" },
            { "rof", "Rombo" },
            { "ny", "Nyanja" },
            { "NZ", "Nuzilan" },
            { "kab", "Kabyle" },
            { "kam", "Kamba" },
            { "mer", "Meru" },
            { "type.nu.armn", "Lambobin \u0199irga na Armenia" },
            { "OM", "Oman" },
            { "om", "Oromo" },
            { "or", "Oriyanci" },
            { "os", "Ossetic" },
            { "mfe", "Morisyen" },
            { "PA", "Panama" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "en_GB", "Turanci Biritaniya" },
            { "PE", "Feru" },
            { "PF", "Folinesiya Ta Faransa" },
            { "PG", "Papuwa Nugini" },
            { "PH", "Filipin" },
            { "PK", "Pakistan" },
            { "PL", "Polan" },
            { "pl", "Harshen Polan" },
            { "ewo", "Ewondo" },
            { "PM", "San Piyar Da Mikelan" },
            { "PN", "Pitakarin" },
            { "type.ca.dangi", "Kalanda Dangi" },
            { "PR", "Porto Riko" },
            { "PS", "Palas\u0257inu" },
            { "ps", "Pashtanci" },
            { "PT", "Portugal" },
            { "pt", "Harshen Fotugis" },
            { "key.co", "Tsarin Rabewa" },
            { "PW", "Palau" },
            { "type.nu.greklow", "Kananan Haruffa na Girka" },
            { "PY", "Faragwai" },
            { "Hebr", metaValue_he },
            { "mgh", "Makhuwa-Meetto" },
            { "key.cf", "Yanayin Kudi" },
            { "QA", "Katar" },
            { "key.ca", "Kalanda" },
            { "Laoo", "Mutanen Laos" },
            { "mgo", "Meta\u02bc" },
            { "type.hc.h23", "Tsarin Awowi 24(0\u201323)" },
            { "type.hc.h24", "Tsarin Awowi 24(1\u201324)" },
            { "type.nu.mymr", "Lambobin Myanmar" },
            { "QO", "Bakin Teku" },
            { "qu", "Quechua" },
            { "brx", "Bodo" },
            { "kde", "Makonde" },
            { "001", "Duniya" },
            { "Ethi", "Ethiopic" },
            { "002", "Afirka" },
            { "003", "North America" },
            { "RE", "Rawuniyan" },
            { "type.hc.h12", "Tsarin Awowi 12(1\u201312)" },
            { "005", "South America" },
            { "type.hc.h11", "Tsarin Awowi 12(0\u201311)" },
            { "009", "Oceania" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "key.cu", "Kudin Kasa" },
            { "RO", "Romaniya" },
            { "ro", "Romaniyanci" },
            { "RS", "Sabiya" },
            { "type.nu.orya", "Lambobin Yaren Odia" },
            { "type.nu.hanidec", "Lambobin Gomiya na Yaren \u0199asar Sin" },
            { "RU", "Rasha" },
            { "ru", "Rashanci" },
            { "RW", "Ruwanda" },
            { "rw", "Kiniyaruwanda" },
            { "kea", "Kabuverdianu" },
            { "en_AU", "Turanci Ostareliya" },
            { "SA", "Saudiyya" },
            { "sa", "Sanskrit" },
            { "SB", "Tsibiran Salaman" },
            { "twq", "Tasawaq" },
            { "011", "Afirka ta Yamma" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "sd", "Sindiyanci" },
            { "013", "Central America" },
            { "SE", "Suwedan" },
            { "se", "Northern Sami" },
            { "014", "Afirka ta Gabas" },
            { "015", "Arewacin Africa" },
            { "SG", "Singapur" },
            { "sg", "Sango" },
            { "SH", "San Helena" },
            { "type.lb.strict", "Salo na Raba Layi mai Tsauri" },
            { "017", "Afirka ta Tsakiya" },
            { "SI", "Sulobeniya" },
            { "si", "Sinhalanci" },
            { "018", "Kudancin Afirka" },
            { "SJ", "Svalbard da Jan Mayen" },
            { "019", "nahiyoyin Amurka" },
            { "SK", "Sulobakiya" },
            { "sk", "Basulke" },
            { "SL", "Salewo" },
            { "sl", "Basulabe" },
            { "SM", "San Marino" },
            { "sm", "Samoan" },
            { "SN", "Sanigal" },
            { "sn", "Shona" },
            { "SO", "Somaliya" },
            { "so", "Somalianci" },
            { "type.nu.arab", "Lambobi na larabawan a gabas" },
            { "sq", "Albanian" },
            { "type.nu.taml", "Lambobin \u0199irga na Tamil na Al\u02bcada" },
            { "SR", "Suriname" },
            { "sr", "Sabiyan" },
            { "SS", "Sudan ta kudu" },
            { "type.cf.account", "Tsarin Kudi na Kididdiga" },
            { "ST", "Sawo Tome Da Paransip" },
            { "st", "Sesotanci" },
            { "su", "Sudananci" },
            { "SV", "El Salbador" },
            { "sv", "Harshen Suwedan" },
            { "sw", "Harshen Suwahili" },
            { "SX", "Sint Maarten" },
            { "SY", "Sham, Siriya" },
            { "type.nu.hantfin", "Lambobin \u0198irgan Kudi na Yaren \u0199asar Sin na Al\u02bcada" },
            { "SZ", "Eswatini" },
            { "TA", "Tritan da Kunha" },
            { "ta", "Tamil" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "Tsarin Awo na Amurka" },
            { "021", "Arewacin Amurka" },
            { "142", "Asiya" },
            { "TC", "Turkis Da Tsibiran Kaikwas" },
            { "yav", "Yangben" },
            { "143", "Asiya ta Tsakiya" },
            { "TD", "Cadi" },
            { "te", "D\u02bcan/\u02bcYar Kabilar Telug" },
            { "145", "Yammacin Asiya" },
            { "TF", "Yankin Faransi ta Kudu" },
            { "TG", "Togo" },
            { "tg", "Tajik" },
            { "TH", "Tailan" },
            { "th", "Thai" },
            { "ti", "Tigriyanci" },
            { "TJ", "Tajikistan" },
            { "en_CA", "Turanci Kanada" },
            { "029", "Caribbean" },
            { "TK", "Takelau" },
            { "tk", "Tukmenistanci" },
            { "TL", "Timor Ta Gabas" },
            { "TM", "Turkumenistan" },
            { "TN", "Tunisiya" },
            { "TO", "Tonga" },
            { "to", "Tongan" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Lambobin \u0199irga na Jafananci" },
            { "TR", "Turkiyya" },
            { "tr", "Harshen Turkiyya" },
            { "TT", "Tirinidad Da Tobago" },
            { "tt", "Tatar" },
            { "TV", "Tubalu" },
            { "TW", "Taiwan" },
            { "ast", "Asturian" },
            { "TZ", "Tanzaniya" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Rubutun da ba sani ba" },
            { "150", "Turai" },
            { "UA", "Yukaran" },
            { "030", "Gabashin Asiya" },
            { "151", "Gabashin Turai" },
            { "154", "Arewacin Turai" },
            { "034", "kudancin Asiya" },
            { "155", "Yammacin Turai" },
            { "035", "Kudu Maso Gabashin Asiya" },
            { "UG", "Yuganda" },
            { "ug", "Ugiranci" },
            { "Kore", "Koriya" },
            { "Zyyy", "Gama-gari" },
            { "039", "Kudancin Turai" },
            { "uk", "Harshen Yukuren" },
            { "Sinh", "Yaren Sinhala" },
            { "UM", "Rukunin Tsibirin U.S" },
            { "UN", "Majalisar Dinkin Duniya" },
            { "ur", "Urdawa" },
            { "US", "Amurka" },
            { "haw", "Hawaiian" },
            { "UY", "Yurigwai" },
            { "prg", "Ferusawa" },
            { "UZ", "Uzubekistan" },
            { "uz", "Uzbek" },
            { "tzm", "Tamazight na Atlas Tsaka" },
            { "nnh", "Ngiemboon" },
            { "VA", "Batikan" },
            { "VC", "San Binsan Da Girnadin" },
            { "VE", "Benezuwela" },
            { "type.ca.roc", "Kalandar kasar Sin" },
            { "VG", "Tsibirin Birjin Na Birtaniya" },
            { "VI", "Tsibiran Birjin Ta Amurka" },
            { "vi", "Harshen Biyetinam" },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Zagayen Awowi" },
            { "VN", "Biyetinam" },
            { "vo", "Volap\u00fck" },
            { "VU", "Banuwatu" },
            { "rwk", "yaren Rwa" },
            { "053", "Tsibarai na Austraila da New Zealand da ma\u0199ota" },
            { "054", "Tsibirai na New Guinea da Fiji da ma\u0199ota" },
            { "WF", "Walis Da Futuna" },
            { "Grek", metaValue_GR },
            { "057", "Yankin Micronesia" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "wo", "Wolof" },
            { "wae", "Walser" },
            { "zgh", "Standard Moroccan Tamazight" },
            { "ar_001", "Larabci Asali Na Zamani" },
            { "WS", "Samoa" },
            { "Mong", "Na kasar Mongolia" },
            { "XA", "Gogewar Kwalwa" },
            { "XB", "Gano wani abu ta hanyar amfani da fasaha" },
            { "061", "tsibiri" },
            { "Latn", "Latin" },
            { "type.nu.hans", "Lambobin \u0199irga na Yaren \u0199asar Sin wanda aka Sau\u0199a\u0199a" },
            { "type.nu.hant", "Lambobin \u0198irga na Yaren \u0199asar Sin na Al\u02bcada" },
            { "xh", "Bazosa" },
            { "XK", "Kasar Kosovo" },
            { "type.nu.romanlow", "Lambobin Kirga Kanana na Rumawa" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Ba rubutacce ba" },
            { "kkj", "Kako" },
            { "YE", "Yamal" },
            { "type.co.standard", "Daidai ta ce Kas\u00e0" },
            { "yi", "Yiddish" },
            { "yo", "Yarbanci" },
            { "es_MX", "Sifaniyanci Mesiko" },
            { "YT", "Mayoti" },
            { "vai", "Vai" },
            { "ZA", "Afirka Ta Kudu" },
            { "type.lb.loose", "Salo na Raba Layi Sakakke" },
            { "kln", "Kalenjin" },
            { "Deva", "Devanagari" },
            { "zh", "Harshen Sinanci" },
            { "type.nu.geor", "Lambobin \u0199irga na Georgia" },
            { "Hira", "Tsarin Rubutun Hiragana" },
            { "ZM", "Zambiya" },
            { "Bopo", "Bopomofo" },
            { "key.lb", "Salo na Raba Layi" },
            { "zu", "Harshen Zulu" },
            { "ZW", "Zimbabuwe" },
            { "ZZ", "Yanki da ba a sani ba" },
            { "Geor", "Georgian" },
            { "type.ms.metric", "Tsarin Awo na Metric" },
            { "type.ca.iso8601", "Kalanda ISO-8601" },
            { "type.nu.telu", "Lambobin yaren Telugu" },
            { "type.nu.jpanfin", "Lambobin \u0199irgan Kudi na Jafananci" },
            { "ebu", "Embu" },
            { "jmc", "Machame" },
            { "zh_Hans", "Sau\u0199a\u0199a\u0199\u0199en Sinanci" },
            { "type.nu.hansfin", "Lambobin \u0198irgan Kudi na Yaren \u0199asar Sin wanda aka Sau\u0199a\u0199a" },
            { "kok", "Konkani" },
            { "type.nu.arabext", "Fitattun lambobin lissafi na Larabci" },
            { "nus", "Nuer" },
            { "type.nu.fullwide", "Lambobi masu Cikakken-Fa\u0257i" },
            { "dav", "Taita" },
            { "lrc", "Northern Luri" },
            { "zh_Hant", "Sinanci na gargajiya" },
            { "type.nu.khmr", "Lambobin Yaren Khmer" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Lambobi na Tsarin Rubutun Gurmukhi" },
            { "Khmr", "Yaren Khmer" },
            { "mul", "Harsuna masu yawa" },
            { "key.ms", "Tsarin Awo" },
            { "type.nu.roman", "Lambobin Rumawa" },
            { "sah", "Sakha" },
            { "type.nu.tamldec", "Lambobin Tamil" },
            { "saq", "Samburu" },
            { "key.nu", "Lambobi" },
            { "Guru", "Gurmukhi" },
            { "ksb", "Shambala" },
            { "Telu", "Yaren Telugu" },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
