/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_hi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MRU", "MRU" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "USD", "$" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VES", "VES" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "aed", "\u0938\u0902\u092f\u0941\u0915\u094d\u0924 \u0905\u0930\u092c \u0905\u092e\u0940\u0930\u093e\u0924 \u0926\u093f\u0930\u0939\u093e\u092e" },
            { "afa", "\u0905\u092b\u0917\u093e\u0928\u0940 (1927\u20132002)" },
            { "afn", "\u0905\u092b\u093c\u0917\u093e\u0928 \u0905\u092b\u093c\u0917\u093e\u0928\u0940" },
            { "all", "\u0905\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e\u0908 \u0932\u0947\u0915" },
            { "amd", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0908 \u0926\u094d\u0930\u093e\u092e" },
            { "ang", "\u0928\u0940\u0926\u0930\u0932\u0948\u0902\u0921 \u090f\u0902\u091f\u0940\u0932\u093f\u092f\u0928 \u0917\u093f\u0932\u094d\u0921\u0930" },
            { "aoa", "\u0905\u0902\u0917\u094b\u0932\u093e \u0915\u094d\u0935\u093e\u0902\u091c\u093c\u093e" },
            { "ars", "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u0940 \u092a\u0947\u0938\u094b" },
            { "aud", "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0921\u0949\u0932\u0930" },
            { "awg", "\u0905\u0930\u0942\u092c\u093e\u0908 \u092b\u093c\u094d\u0932\u094b\u0930\u093f\u0928" },
            { "azn", "\u0905\u091c\u093c\u0930\u092c\u0948\u091c\u093e\u0928\u0940 \u092e\u0948\u0928\u0947\u091f" },
            { "bam", "\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e \u0939\u0930\u094d\u091c\u093c\u0947\u0917\u094b\u0935\u093f\u0928\u093e \u092a\u0930\u093f\u0935\u0930\u094d\u0924\u0928\u0940\u092f \u092e\u093e\u0930\u094d\u0915" },
            { "bbd", "\u092c\u093e\u0930\u094d\u092c\u0947\u0921\u093f\u092f\u0928 \u0921\u0949\u0932\u0930" },
            { "bdt", "\u092c\u093e\u0902\u0917\u094d\u0932\u093e\u0926\u0947\u0936\u0940 \u091f\u0915\u093e" },
            { "bgn", "\u092c\u0941\u0932\u094d\u0917\u093e\u0930\u093f\u092f\u093e\u0908 \u0932\u0947\u0935" },
            { "bhd", "\u092c\u0939\u0930\u0940\u0928\u0940 \u0926\u093f\u0928\u093e\u0930" },
            { "bif", "\u092c\u0941\u0930\u0942\u0902\u0921\u0940 \u092b\u093c\u094d\u0930\u0948\u0902\u0915" },
            { "bmd", "\u092c\u0930\u092e\u0942\u0921\u093e \u0921\u0949\u0932\u0930" },
            { "bnd", "\u092c\u094d\u0930\u0942\u0928\u0947\u0908 \u0921\u0949\u0932\u0930" },
            { "bob", "\u092c\u094b\u0932\u093f\u0935\u093f\u092f\u093e\u0908 \u092c\u094b\u0932\u093f\u0935\u093f\u092f\u093e\u0928\u094b" },
            { "brl", "\u092c\u094d\u0930\u093e\u091c\u093c\u0940\u0932\u0940 \u0930\u093f\u092f\u093e\u0932" },
            { "bsd", "\u092c\u0939\u093e\u092e\u093e\u0908 \u0921\u0949\u0932\u0930" },
            { "btn", "\u092d\u0942\u091f\u093e\u0928\u0940 \u0928\u0902\u0917\u0932\u091f\u094d\u0930\u092e" },
            { "bwp", "\u092c\u094b\u0924\u094d\u0938\u0935\u093e\u0928\u093f\u092f\u093e\u0908 \u092a\u0941\u0932\u093e" },
            { "byn", "\u092c\u0947\u0932\u093e\u0930\u0942\u0938\u0940 \u0930\u0942\u092c\u0932" },
            { "byr", "\u092c\u0947\u0932\u093e\u0930\u0942\u0938\u0940 \u0930\u0942\u092c\u0932 (2000\u20132016)" },
            { "bzd", "\u092c\u0947\u0932\u0940\u091c\u093c \u0921\u0949\u0932\u0930" },
            { "cad", "\u0915\u0928\u093e\u0921\u093e\u0908 \u0921\u0949\u0932\u0930" },
            { "cdf", "\u0915\u094b\u0902\u0917\u094b\u0932\u0940 \u092b\u093c\u094d\u0930\u0948\u0902\u0915" },
            { "chf", "\u0938\u094d\u0935\u093f\u0938 \u092b\u093c\u094d\u0930\u0948\u0902\u0915" },
            { "clp", "\u091a\u093f\u0932\u0940 \u092a\u0947\u0938\u094b" },
            { "cnh", "\u091a\u0940\u0928\u0940 \u092f\u0941\u0906\u0928 (\u0911\u092b\u093c\u0936\u094b\u0930)" },
            { "cny", "\u091a\u0940\u0928\u0940 \u092f\u0941\u0906\u0928" },
            { "cop", "\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e\u0908 \u092a\u0947\u0938\u094b" },
            { "crc", "\u0915\u094b\u0938\u094d\u091f\u093e \u0930\u093f\u0915\u093e \u0915\u094b\u0932\u094b\u0928" },
            { "csd", "\u0938\u0930\u094d\u092c\u093f\u092f \u0915\u093e \u0922\u0940\u0928\u093e\u0930" },
            { "cuc", "\u0915\u094d\u092f\u0942\u092c\u093e\u0908 \u092a\u0930\u093f\u0935\u0930\u094d\u0924\u0928\u0940\u092f \u092a\u0947\u0938\u094b" },
            { "cup", "\u0915\u094d\u092f\u0942\u092c\u093e\u0908 \u092a\u0947\u0938\u094b" },
            { "cve", "\u0915\u0947\u092a \u0935\u0930\u094d\u0921 \u090f\u0938\u094d\u0915\u0942\u0921\u094b" },
            { "cyp", "\u0938\u093e\u0908\u092a\u094d\u0930\u0938 \u092a\u093e\u090a\u0902\u0921" },
            { "czk", "\u091a\u0947\u0915 \u0917\u0923\u0930\u093e\u091c\u094d\u092f \u0915\u094b\u0930\u0941\u0928\u093e" },
            { "dem", "\u0921\u091a \u092e\u093e\u0930\u094d\u0915" },
            { "djf", "\u091c\u093f\u092c\u0942\u0924\u0940 \u092b\u093c\u094d\u0930\u0948\u0902\u0915" },
            { "dkk", "\u0921\u0948\u0928\u093f\u0936 \u0915\u094d\u0930\u094b\u0928" },
            { "dop", "\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u0928 \u092a\u0947\u0938\u094b" },
            { "dzd", "\u0905\u0932\u094d\u091c\u0940\u0930\u093f\u092f\u093e\u0908 \u0926\u093f\u0928\u093e\u0930" },
            { "eek", "\u090f\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u093e\u0908 \u0915\u094d\u0930\u0942\u0928\u094d" },
            { "egp", "\u092e\u093f\u0938\u094d\u0930 \u092a\u093e\u0909\u0902\u0921" },
            { "ern", "\u0907\u0930\u0940\u091f\u094d\u0930\u093f\u092f\u0928 \u0928\u093e\u0915\u094d\u092b\u093c\u093e" },
            { "etb", "\u0907\u0925\u093f\u092f\u094b\u092a\u093f\u092f\u0928 \u092c\u093f\u0930" },
            { "eur", "\u092f\u0942\u0930\u094b" },
            { "fjd", "\u092b\u093c\u093f\u091c\u0940 \u0921\u0949\u0932\u0930" },
            { "fkp", "\u092b\u093c\u0949\u0915\u0932\u0948\u0902\u0921 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939 \u092a\u093e\u0909\u0902\u0921" },
            { "frf", "\u092b\u093c\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940 \u092b\u093c\u094d\u0930\u0948\u0902\u0915" },
            { "gbp", "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u092a\u093e\u0909\u0902\u0921 \u0938\u094d\u091f\u0930\u094d\u0932\u093f\u0902\u0917" },
            { "gel", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u0928 \u0932\u093e\u0930\u0940" },
            { "ghs", "\u0918\u093e\u0928\u093f\u092f\u0928 \u0938\u0947\u0921\u0940" },
            { "gip", "\u091c\u093f\u092c\u094d\u0930\u093e\u0932\u094d\u091f\u0930 \u092a\u093e\u0909\u0902\u0921" },
            { "gmd", "\u0917\u0948\u0902\u092c\u093f\u092f\u0928 \u0921\u0932\u093e\u0938\u0940" },
            { "gnf", "\u0917\u093f\u0928\u0940\u092f\u0928 \u092b\u093c\u094d\u0930\u0948\u0902\u0915" },
            { "gtq", "\u0917\u094d\u0935\u093e\u091f\u0947\u092e\u093e\u0932\u093e \u0915\u094d\u0935\u0947\u091f\u091c\u093c\u0932" },
            { "gyd", "\u0917\u092f\u093e\u0928\u0940\u091c\u093c \u0921\u0949\u0932\u0930" },
            { "hkd", "\u0939\u093e\u0901\u0917\u0915\u093e\u0901\u0917 \u0921\u0949\u0932\u0930" },
            { "hnl", "\u0939\u094b\u0902\u0921\u0941\u0930\u0928 \u0932\u0947\u092e\u094d\u092a\u093f\u0930\u093e" },
            { "hrd", "\u0915\u094d\u0930\u094b\u090f\u0936\u093f\u092f\u0928 \u0926\u093f\u0928\u093e\u0930" },
            { "hrk", "\u0915\u094d\u0930\u094b\u090f\u0936\u093f\u092f\u093e\u0908 \u0915\u0941\u0928\u093e" },
            { "htg", "\u0939\u0948\u0924\u093f\u092f\u093e\u0908 \u0917\u0930\u094d\u0921" },
            { "huf", "\u0939\u0902\u0917\u0947\u0930\u093f\u092f\u0928 \u092b\u093c\u094b\u0930\u093f\u0902\u091f" },
            { "idr", "\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e\u0908 \u0930\u0941\u092a\u093f\u092f\u093e" },
            { "ils", "\u0907\u091c\u093c\u0930\u093e\u0907\u0932\u0940 \u0928\u094d\u092f\u0942 \u0936\u0947\u0915\u0947\u0932" },
            { "inr", "\u092d\u093e\u0930\u0924\u0940\u092f \u0930\u0941\u092a\u092f\u093e" },
            { "iqd", "\u0907\u0930\u093e\u0915\u0940 \u0926\u093f\u0928\u093e\u0930" },
            { "irr", "\u0908\u0930\u093e\u0928\u0940 \u0930\u093f\u092f\u093e\u0932" },
            { "isk", "\u0906\u0907\u0938\u0932\u0948\u0902\u0921\u093f\u0915 \u0915\u094d\u0930\u094b\u0928\u093e" },
            { "itl", "\u0907\u0924\u0932\u0940 \u0915\u093e \u0932\u0940\u0930\u093e" },
            { "jmd", "\u091c\u092e\u0948\u0915\u0928 \u0921\u0949\u0932\u0930" },
            { "jod", "\u091c\u0949\u0930\u094d\u0921\u0928\u093f\u092f\u0928 \u0926\u093f\u0928\u093e\u0930" },
            { "jpy", "\u091c\u093e\u092a\u093e\u0928\u0940 \u092f\u0947\u0928" },
            { "kes", "\u0915\u0947\u0928\u094d\u092f\u093e\u0908 \u0936\u093f\u0932\u093f\u0902\u0917" },
            { "kgs", "\u0915\u093f\u0930\u094d\u0917\u093f\u0938\u094d\u0924\u093e\u0928\u0940 \u0938\u094b\u092e" },
            { "khr", "\u0915\u0902\u092c\u094b\u0921\u093f\u092f\u093e\u0908 \u0930\u093f\u092f\u093e\u0932" },
            { "kmf", "\u0915\u094b\u092e\u094b\u0930\u093f\u092f\u0928 \u092b\u093c\u094d\u0930\u0948\u0902\u0915" },
            { "kpw", "\u0909\u0924\u094d\u0924\u0930 \u0915\u094b\u0930\u093f\u092f\u093e\u0908 \u0935\u0949\u0928" },
            { "krw", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0915\u094b\u0930\u093f\u092f\u093e\u0908 \u0935\u0949\u0928" },
            { "kwd", "\u0915\u0941\u0935\u0948\u0924\u0940 \u0926\u093f\u0928\u093e\u0930" },
            { "kyd", "\u0915\u0948\u092e\u0947\u0928 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939 \u0921\u0949\u0932\u0930" },
            { "kzt", "\u0915\u091c\u093c\u093e\u0916\u093f\u0938\u094d\u0924\u093e\u0928\u0940 \u091f\u0947\u0902\u091c\u093c" },
            { "lak", "\u0932\u093e\u0913\u0936\u093f\u092f\u0928 \u0915\u093f\u092a" },
            { "lbp", "\u0932\u0947\u092c\u0928\u093e\u0928\u0940 \u092a\u093e\u0909\u0902\u0921" },
            { "lkr", "\u0936\u094d\u0930\u0940\u0932\u0902\u0915\u093e\u0908 \u0930\u0941\u092a\u092f\u093e" },
            { "lrd", "\u0932\u093e\u0907\u092c\u0947\u0930\u093f\u092f\u093e\u0908 \u0921\u0949\u0932\u0930" },
            { "lsl", "\u0932\u0947\u0938\u094b\u0925\u094b \u0932\u094b\u091f\u0940" },
            { "ltl", "\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u093e\u0908 \u0932\u093f\u0924\u093e\u0938" },
            { "lvl", "\u0932\u093e\u0924\u094d\u0935\u093f\u092f\u0928 \u0932\u0948\u0924\u094d\u0938" },
            { "lyd", "\u0932\u0940\u092c\u093f\u092f\u093e\u0908 \u0926\u093f\u0928\u093e\u0930" },
            { "mad", "\u092e\u094b\u0930\u0915\u094d\u0915\u094b \u0926\u093f\u0930\u0939\u092e" },
            { "maf", "\u092e\u094b\u0930\u0915\u094d\u0915\u094b \u092b\u094d\u0930\u0948\u0902\u0915" },
            { "mdl", "\u092e\u094b\u0932\u094d\u0921\u094b\u0935\u0928 \u0932\u093f\u092f\u0942" },
            { "mga", "\u092e\u093e\u0932\u093e\u0917\u093e\u0938\u0940 \u0906\u0930\u093f\u092f\u0930\u0940" },
            { "mkd", "\u092e\u0948\u0938\u0940\u0921\u094b\u0928\u093f\u092f\u0928 \u0926\u093f\u0928\u093e\u0930" },
            { "mmk", "\u092e\u094d\u092f\u093e\u0902\u092e\u093e\u0930 \u0915\u094d\u092f\u093e\u091f" },
            { "mnt", "\u092e\u0902\u0917\u094b\u0932\u093f\u092f\u093e\u0908 \u091f\u0917\u0930\u093f\u0915" },
            { "mop", "\u092e\u0947\u0915\u093e\u0928\u0940\u091c\u093c \u092a\u093e\u091f\u093e\u0915\u093e" },
            { "mro", "\u092e\u0949\u0930\u0940\u091f\u0947\u0928\u093f\u092f\u0928 \u0913\u0917\u0941\u0907\u092f\u093e (1973\u20132017)" },
            { "mru", "\u092e\u0949\u0930\u0940\u091f\u0947\u0928\u093f\u092f\u0928 \u0913\u0917\u0941\u0907\u092f\u093e" },
            { "mur", "\u092e\u0949\u0930\u093f\u0936\u093f\u092f\u0928 \u0930\u0941\u092a\u092f\u093e" },
            { "mvr", "\u092e\u093e\u0932\u0926\u0940\u0935\u0940 \u0930\u0941\u092b\u093c\u093f\u092f\u093e" },
            { "mwk", "\u092e\u093e\u0932\u093e\u0935\u093f\u092f\u0928 \u0915\u094d\u0935\u093e\u091a\u093e" },
            { "mxn", "\u092e\u0948\u0915\u094d\u0938\u093f\u0915\u0928 \u092a\u0947\u0938\u094b" },
            { "myr", "\u092e\u0932\u0947\u0936\u093f\u092f\u093e\u0908 \u0930\u093f\u0902\u0917\u093f\u0924" },
            { "mzn", "\u092e\u094b\u091c\u093c\u093e\u092e\u094d\u092c\u093f\u0915\u0928 \u092e\u0947\u091f\u093f\u0915\u0932" },
            { "nad", "\u0928\u093e\u092e\u0940\u092c\u093f\u092f\u093e\u0908 \u0921\u0949\u0932\u0930" },
            { "ngn", "\u0928\u093e\u0907\u091c\u0940\u0930\u093f\u092f\u093e\u0908 \u0928\u093e\u0907\u0930\u093e" },
            { "nio", "\u0928\u093f\u0915\u093e\u0930\u093e\u0917\u0941\u0905\u0928 \u0915\u094b\u0930\u0921\u094b\u092c\u093e" },
            { "nok", "\u0928\u0949\u0930\u094d\u0935\u0947\u091c\u093f\u092f\u0928 \u0915\u094d\u0930\u094b\u0928" },
            { "npr", "\u0928\u0947\u092a\u093e\u0932\u0940 \u0930\u0941\u092a\u092f\u093e" },
            { "nzd", "\u0928\u094d\u092f\u0942\u091c\u093c\u0940\u0932\u0948\u0902\u0921 \u0921\u0949\u0932\u0930" },
            { "omr", "\u0913\u092e\u093e\u0928\u0940 \u0930\u093f\u092f\u093e\u0932" },
            { "pab", "\u092a\u0928\u093e\u092e\u0947\u0928\u093f\u092f\u0928 \u092c\u0948\u0932\u094d\u092c\u094b\u0906" },
            { "pen", "\u092a\u0947\u0930\u0942\u0935\u093f\u092f\u0928 \u0938\u094b\u0932" },
            { "pgk", "\u092a\u093e\u092a\u0941\u0906 \u0928\u094d\u092f\u0942 \u0917\u093f\u0928\u0940\u092f\u0928 \u0915\u093f\u0928\u093e" },
            { "php", "\u092b\u093c\u093f\u0932\u093f\u092a\u0940\u0928\u0940 \u092a\u0947\u0938\u094b" },
            { "pkr", "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928\u0940 \u0930\u0941\u092a\u092f\u093e" },
            { "pln", "\u092a\u094b\u0932\u093f\u0936 \u091c\u093c\u094d\u0932\u0949\u091f\u0940" },
            { "pyg", "\u092a\u0948\u0930\u093e\u0917\u094d\u0935\u093f\u092f\u0928 \u0917\u0941\u0906\u0930\u093e\u0928\u0940" },
            { "qar", "\u0915\u093c\u0924\u0930\u0940 \u0930\u093f\u092f\u093e\u0932" },
            { "rhd", "\u0930\u094b\u0921\u0947\u0936\u093f\u092f\u093e\u0908 \u0921\u093e\u0932\u0930" },
            { "ron", "\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u093e\u0908 \u0932\u094d\u092f\u0942" },
            { "rsd", "\u0938\u0930\u094d\u092c\u093f\u092f\u0928 \u0926\u093f\u0928\u093e\u0930" },
            { "rub", "\u0930\u0942\u0938\u0940 \u0930\u0942\u092c\u0932" },
            { "rwf", "\u0930\u0935\u093e\u0902\u0921\u093e\u0908 \u092b\u093c\u094d\u0930\u0948\u0902\u0915" },
            { "sar", "\u0938\u0909\u0926\u0940 \u0930\u093f\u092f\u093e\u0932" },
            { "sbd", "\u0938\u094b\u0932\u094b\u092e\u0928 \u0926\u094d\u0935\u0940\u092a\u0938\u092e\u0942\u0939 \u0921\u0949\u0932\u0930" },
            { "scr", "\u0938\u0947\u0936\u0947\u0932\u094d\u0938\u093f\u092f\u093e\u0908 \u0930\u0941\u092a\u092f\u093e" },
            { "sdd", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0938\u0942\u0921\u093e\u0928\u0940 \u0926\u093f\u0928\u093e\u0930" },
            { "sdg", "\u0938\u0942\u0921\u093e\u0928\u0940 \u092a\u093e\u0909\u0902\u0921" },
            { "sdp", "\u092a\u0941\u0930\u093e\u0928\u093e \u0938\u0942\u0921\u093e\u0928\u0940 \u092a\u093e\u0909\u0902\u0921" },
            { "sek", "\u0938\u094d\u0935\u0940\u0921\u0940\u0936 \u0915\u094d\u0930\u094b\u0928\u093e" },
            { "sgd", "\u0938\u093f\u0902\u0917\u093e\u092a\u0941\u0930 \u0921\u0949\u0932\u0930" },
            { "shp", "\u0938\u0947\u0902\u091f \u0939\u0947\u0932\u0947\u0928\u093e \u092a\u093e\u0909\u0902\u0921" },
            { "sit", "\u0938\u094d\u0932\u094b\u0935\u0947\u0928\u093f\u092f\u093e\u0908 \u0924\u094b\u0932\u093e\u0930" },
            { "skk", "\u0938\u094d\u0932\u094b\u0935\u093e\u0915 \u0915\u094b\u0930\u0941\u0928\u093e" },
            { "sll", "\u0938\u093f\u090f\u0930\u093e \u0932\u093f\u092f\u094b\u0928\u093f\u092f\u0928 \u0932\u093f\u092f\u094b\u0928" },
            { "sos", "\u0938\u094b\u092e\u093e\u0932\u0940 \u0936\u093f\u0932\u093f\u0902\u0917" },
            { "srd", "\u0938\u0942\u0930\u0940\u0928\u093e\u092e\u0940 \u0921\u0949\u0932\u0930" },
            { "srg", "\u0938\u0942\u0930\u0940\u0928\u093e\u092e\u0940 \u0917\u093f\u0932\u094d\u0921\u0930" },
            { "ssp", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0938\u0942\u0921\u093e\u0928\u0940 \u092a\u093e\u0909\u0902\u0921" },
            { "std", "\u0938\u093e\u0913 \u0924\u094b\u092e \u0914\u0930 \u092a\u094d\u0930\u093f\u0902\u0938\u093f\u092a\u0947 \u0921\u094b\u092c\u0930\u093e (1977\u20132017)" },
            { "stn", "\u0938\u093e\u0913 \u091f\u094b\u092e \u0914\u0930 \u092a\u094d\u0930\u093f\u0902\u0938\u093f\u092a\u0947 \u0921\u094b\u092c\u0930\u093e" },
            { "sur", "\u0938\u094b\u0935\u093f\u092f\u0924 \u0930\u0942\u092c\u0932" },
            { "syp", "\u0938\u0940\u0930\u093f\u092f\u093e\u0908 \u092a\u093e\u0909\u0902\u0921" },
            { "szl", "\u0938\u094d\u0935\u093e\u091c\u093c\u0940 \u0932\u093f\u0932\u093e\u0902\u091c\u0947\u0928\u0940" },
            { "thb", "\u0925\u093e\u0908 \u092c\u0939\u0924" },
            { "tjr", "\u0924\u091c\u093e\u0916\u0940 \u0930\u0942\u092c\u0932" },
            { "tjs", "\u0924\u093e\u091c\u093f\u0915\u093f\u0938\u094d\u0924\u093e\u0928\u0940 \u0938\u094b\u092e\u094b\u0928\u0940" },
            { "tmt", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u093f\u0938\u094d\u0924\u093e\u0928\u0940 \u092e\u0948\u0928\u0924" },
            { "tnd", "\u091f\u094d\u092f\u0942\u0928\u0940\u0936\u093f\u092f\u093e\u0908 \u0926\u093f\u0928\u093e\u0930" },
            { "top", "\u091f\u094b\u0902\u0917\u0928 \u092a\u093e\u0902\u0917\u093e" },
            { "trl", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0924\u0941\u0930\u094d\u0915\u0940 \u0932\u0940\u0930\u093e" },
            { "try", "\u0924\u0941\u0930\u094d\u0915\u0940 \u0932\u0940\u0930\u093e" },
            { "ttd", "\u0924\u094d\u0930\u093f\u0928\u093f\u0926\u093e\u0926 \u0914\u0930 \u091f\u094b\u092c\u0948\u0917\u094b \u0921\u0949\u0932\u0930" },
            { "twd", "\u0928\u092f\u093e \u0924\u093e\u0908\u0935\u093e\u0928\u0940 \u0921\u0949\u0932\u0930" },
            { "tzs", "\u0924\u0902\u091c\u093c\u093e\u0928\u093f\u092f\u093e\u0908 \u0936\u093f\u0932\u093f\u0902\u0917" },
            { "uah", "\u092f\u0942\u0915\u094d\u0930\u0947\u0928\u093f\u092f\u0928 \u0930\u093f\u0935\u094d\u0928\u093f\u092f\u093e" },
            { "ugx", "\u092f\u0941\u0917\u093e\u0902\u0921\u093e\u0908 \u0936\u093f\u0932\u093f\u0902\u0917" },
            { "usd", "\u092f\u0942\u090f\u0938 \u0921\u0949\u0932\u0930" },
            { "usn", "\u0905\u092e\u0947\u0930\u0940\u0915\u0940 \u0921\u093e\u0932\u0930 (\u0915\u0932)" },
            { "uss", "\u0905\u092e\u0947\u0930\u0940\u0915\u0940 \u0921\u093e\u0932\u0930 (\u0906\u091c)" },
            { "uyu", "\u0909\u0930\u0941\u0917\u094d\u0935\u093f\u092f\u0928 \u092a\u0947\u0938\u094b" },
            { "uzs", "\u0909\u091c\u093c\u094d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928\u0940 \u0938\u094b\u092e" },
            { "veb", "\u0935\u0947\u0928\u0947\u091c\u093c\u0941\u090f\u0932\u093e \u092c\u094b\u0932\u093f\u0935\u0930 (1871\u20132008)" },
            { "vef", "\u0935\u0947\u0928\u0947\u091c\u093c\u0941\u090f\u0932\u093e \u092c\u094b\u0932\u093f\u0935\u0930 (2008\u20132018)" },
            { "ves", "\u0935\u0947\u0928\u0947\u091c\u093c\u0941\u090f\u0932\u093e \u092c\u094b\u0932\u093f\u0935\u0930" },
            { "vnd", "\u0935\u093f\u092f\u0924\u0928\u093e\u092e\u0940 \u0921\u094b\u0902\u0917" },
            { "vuv", "\u0935\u0928\u0941\u0906\u0924\u0942 \u0935\u093e\u0924\u0942" },
            { "wst", "\u0938\u092e\u094b\u0906\u0908 \u0924\u093e\u0932\u093e" },
            { "xaf", "\u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u0940 CFA \u092b\u093c\u094d\u0930\u0948\u0902\u0915" },
            { "xcd", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0915\u0948\u0930\u093f\u092c\u093f\u092f\u093e\u0908 \u0921\u0949\u0932\u0930" },
            { "xof", "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u0940 CFA \u092b\u093c\u094d\u0930\u0948\u0902\u0915" },
            { "xpf", "[CFP] \u092b\u093c\u094d\u0930\u0948\u0902\u0915" },
            { "xxx", "\u0905\u091c\u094d\u091e\u093e\u0924 \u092e\u0941\u0926\u094d\u0930\u093e" },
            { "yer", "\u092f\u092e\u0928\u0940 \u0930\u093f\u092f\u093e\u0932" },
            { "zar", "\u0926\u0915\u094d\u0937\u093f\u0923 \u0905\u092b\u093c\u094d\u0930\u0940\u0915\u0940 \u0930\u0948\u0902\u0921" },
            { "zmk", "\u091c\u093c\u093e\u092e\u094d\u092c\u093f\u092f\u0928 \u0915\u094d\u0935\u093e\u091a\u093e (1968\u20132012)" },
            { "zmw", "\u091c\u093c\u093e\u092e\u094d\u092c\u093f\u092f\u0928 \u0915\u094d\u0935\u093e\u091a\u093e" },
        };
        return data;
    }
}
