/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ms extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AL = "Albania";
        final String metaValue_AM = "Armenia";
        final String metaValue_AZ = "Azerbaijan";
        final String metaValue_BG = "Bulgaria";
        final String metaValue_BY = "Belarus";
        final String metaValue_DE = "Jerman";
        final String metaValue_DK = "Denmark";
        final String metaValue_EE = "Estonia";
        final String metaValue_ES = "Sepanyol";
        final String metaValue_ET = "Ethiopia";
        final String metaValue_FI = "Finland";
        final String metaValue_FJ = "Fiji";
        final String metaValue_FR = "Perancis";
        final String metaValue_GE = "Georgia";
        final String metaValue_HR = "Croatia";
        final String metaValue_HT = "Haiti";
        final String metaValue_HU = "Hungary";
        final String metaValue_ID = "Indonesia";
        final String metaValue_IE = "Ireland";
        final String metaValue_IS = "Iceland";
        final String metaValue_IT = "Itali";
        final String metaValue_JP = "Jepun";
        final String metaValue_KI = "Kiribati";
        final String metaValue_KZ = "Kazakhstan";
        final String metaValue_LA = "Laos";
        final String metaValue_LT = "Lithuania";
        final String metaValue_LU = "Luxembourg";
        final String metaValue_LV = "Latvia";
        final String metaValue_MN = "Mongolia";
        final String metaValue_MT = "Malta";
        final String metaValue_NL = "Belanda";
        final String metaValue_NO = "Norway";
        final String metaValue_NP = "Nepal";
        final String metaValue_NR = "Nauru";
        final String metaValue_PH = "Filipina";
        final String metaValue_PL = "Poland";
        final String metaValue_RO = "Romania";
        final String metaValue_RS = "Serbia";
        final String metaValue_RU = "Rusia";
        final String metaValue_SE = "Sweden";
        final String metaValue_SI = "Slovenia";
        final String metaValue_SY = "Syria";
        final String metaValue_TO = "Tonga";
        final String metaValue_TR = "Turki";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_UA = "Ukraine";
        final String metaValue_UZ = "Uzbekistan";
        final String metaValue_VN = "Vietnam";
        final String metaValue_WS = "Samoa";
        final String metaValue_ae = "Avestan";
        final String metaValue_ar = "Arab";
        final String metaValue_bn = "Benggala";
        final String metaValue_bo = "Tibet";
        final String metaValue_el = "Greek";
        final String metaValue_he = "Ibrani";
        final String metaValue_jv = "Jawa";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korea";
        final String metaValue_la = "Latin";
        final String metaValue_ml = "Malayalam";
        final String metaValue_si = "Sinhala";
        final String metaValue_su = "Sunda";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thai";
        final String metaValue_ban = "Bali";
        final String metaValue_bug = "Bugis";
        final String metaValue_ccp = "Chakma";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Coptic";
        final String metaValue_mak = "Makasar";
        final String metaValue_men = "Mende";
        final String metaValue_nqo = "N\u2019ko";
        final String metaValue_ssy = "Saho";
        final String metaValue_vai = "Vai";
        final Object[][] data = new Object[][] {
            { "ksh", "Colognian" },
            { "Ogam", "Ogham" },
            { "mwl", "Mirandese" },
            { "Zsym", "Simbol" },
            { "type.nu.lanatham", "Digit Tai Tham Tham" },
            { "Tagb", "Tagbanwa" },
            { "Zsye", "Emoji" },
            { "%%NJIVA", "Dialek Gniva/Njiva" },
            { "ccp", metaValue_ccp },
            { "Phag", "Phags-pa" },
            { "tem", "Timne" },
            { "Medf", "Medefaidrin" },
            { "type.nu.sind", "Digit Khudawadi" },
            { "teo", "Teso" },
            { "rap", "Rapanui" },
            { "AC", "Pulau Ascension" },
            { "rar", "Rarotonga" },
            { "tet", "Tetum" },
            { "%%BARLA", "Kumpulan dialek Barlavento Kabuverdianu" },
            { "type.nu.sinh", "Digit Sinhala Lith" },
            { "AD", "Andorra" },
            { "AE", "Emiriah Arab Bersatu" },
            { "nl_BE", "Flemish" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua dan Barbuda" },
            { "type.nu.mroo", "Digit Mro" },
            { "type.ca.ethiopic", "Kalendar Ethiopia" },
            { "glk", "Gilaki" },
            { "AI", "Anguilla" },
            { "key.tz", "Zon Waktu" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "AO", "Angola" },
            { "AQ", "Antartika" },
            { "AR", "Argentina" },
            { "Prti", "Inskripsi Parthian" },
            { "AS", "Samoa Amerika" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "Inggeris AS" },
            { "AX", "Kepulauan Aland" },
            { "mye", "Myene" },
            { "AZ", metaValue_AZ },
            { "BA", "Bosnia dan Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "Kumyk" },
            { "BE", "Belgium" },
            { "Sogo", "Sogdia Lama" },
            { "BF", "Burkina Faso" },
            { "BG", metaValue_BG },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barthelemy" },
            { "BM", "Bermuda" },
            { "myv", "Erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Belanda Caribbean" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Pulau Bouvet" },
            { "BW", "Botswana" },
            { "BY", metaValue_BY },
            { "BZ", "Belize" },
            { "type.ca.persian", "Kalendar Parsi" },
            { "type.nu.hebr", "Angka Ibrani" },
            { "CA", "Kanada" },
            { "CC", "Kepulauan Cocos (Keeling)" },
            { "mzn", "Mazanderani" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Republik Afrika Tengah" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Switzerland" },
            { "CI", "Cote d\u2019Ivoire" },
            { "CK", "Kepulauan Cook" },
            { "CL", "Chile" },
            { "Kthi", "Kaithi" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Pulau Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "CW", "Curacao" },
            { "CX", "Pulau Krismas" },
            { "CY", "Cyprus" },
            { "type.nu.bali", "Digit Bali" },
            { "CZ", "Czechia" },
            { "eka", "Ekajuk" },
            { "Pauc", "Pau Cin Hau" },
            { "%%RIGIK", "Vopaluk Klasik" },
            { "Sogd", "Sogdia" },
            { "DE", metaValue_DE },
            { "ace", "Aceh" },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "Digit Devanagari" },
            { "DJ", "Djibouti" },
            { "DK", metaValue_DK },
            { "ach", "Akoli" },
            { "Brai", "Braille" },
            { "Brah", "Brahmi" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "Angka Kecil Armenia" },
            { "DO", "Republik Dominica" },
            { "gor", "Gorontalo" },
            { "Mtei", "Meitei Mayek" },
            { "zun", "Zuni" },
            { "tig", "Tigre" },
            { "Takr", "Takri" },
            { "DZ", "Algeria" },
            { "pag", "Pangasinan" },
            { "type.d0.hwidth", "Ke Kelebaran Separa" },
            { "EA", "Ceuta dan Melilla" },
            { "pam", "Pampanga" },
            { "EC", "Ecuador" },
            { "pap", "Papiamento" },
            { "ada", "Adangme" },
            { "EE", metaValue_EE },
            { "EG", "Mesir" },
            { "EH", "Sahara Barat" },
            { "pau", "Palauan" },
            { "chk", "Chukese" },
            { "chm", "Mari" },
            { "cho", "Choctaw" },
            { "type.nu.mathbold", "Digit Matematik Tebal" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", metaValue_ES },
            { "ET", metaValue_ET },
            { "EU", "Kesatuan Eropah" },
            { "type.ca.gregorian", "Kalendar Gregory" },
            { "EZ", "Zon Euro" },
            { "chy", "Cheyenne" },
            { "type.nu.gujr", "Digit Gujarat" },
            { "ady", "Adyghe" },
            { "aeb", "Arab Tunisia" },
            { "FI", metaValue_FI },
            { "FJ", metaValue_FJ },
            { "FK", "Kepulauan Falkland" },
            { "FM", "Micronesia" },
            { "key.va", "Varian Tempat" },
            { "FO", "Kepulauan Faroe" },
            { "Taml", metaValue_ta },
            { "FR", metaValue_FR },
            { "root", "Root" },
            { "%%DAJNKO", "Abjad Dajnko" },
            { "type.ca.indian", "Kalendar Kebangsaan India" },
            { "grc", "Greek Purba" },
            { "GA", "Gabon" },
            { "GB", "United Kingdom" },
            { "pcm", "Nigerian Pidgin" },
            { "GD", "Grenada" },
            { "GE", metaValue_GE },
            { "GF", "Guiana Perancis" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "Tai Le" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea Khatulistiwa" },
            { "GR", "Greece" },
            { "GS", "Kepulauan Georgia Selatan & Sandwich Selatan" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "type.nu.mathmono", "Digit Matematik Monospace" },
            { "GW", "Guinea Bissau" },
            { "tlh", "Klingon" },
            { "Talu", "Tai Lue Baharu" },
            { "GY", "Guyana" },
            { "ckb", "Kurdi Sorani" },
            { "zxx", "Tiada kandungan linguistik" },
            { "tly", "Talysh" },
            { "de_AT", "Jerman Austria" },
            { "Vaii", metaValue_vai },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Kepulauan Heard & McDonald" },
            { "HN", "Honduras" },
            { "HR", metaValue_HR },
            { "agq", "Aghem" },
            { "gsw", "Jerman Switzerland" },
            { "type.ca.islamic-umalqura", "Kalendar Islam (Umm Al-Quran)" },
            { "HT", metaValue_HT },
            { "HU", metaValue_HU },
            { "IC", "Kepulauan Canary" },
            { "nan", "Cina Min Nan" },
            { "ID", metaValue_ID },
            { "Adlm", "Adlam" },
            { "type.nu.kali", "Digit Kayah Li" },
            { "IE", metaValue_IE },
            { "nap", "Neapolitan" },
            { "%%NDYUKA", "Dialek Ndyuka" },
            { "naq", "Nama" },
            { "type.nu.sora", "Digit Sora Sompeng" },
            { "zza", "Zaza" },
            { "Tang", "Tangut" },
            { "IL", "Israel" },
            { "Nbat", "Nabataean" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "type.co.eor", "Peraturan Isihan Eropah" },
            { "IO", "Wilayah Lautan Hindi British" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", metaValue_IS },
            { "IT", metaValue_IT },
            { "Zmth", "Tatatanda matematik" },
            { "type.nu.thai", "Digit Thai" },
            { "%%POSIX", "Komputer" },
            { "type.nu.beng", "Digit Benggali" },
            { "type.nu.cyrl", "Digit Cyril" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Kalendar Islam" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "%%EKAVSK", "Serbia dengan sebutan Ekavia" },
            { "JO", "Jordan" },
            { "JP", metaValue_JP },
            { "%%1606NICT", "Lewat Pertengahan Era Perancis hingga 1606" },
            { "ain", "Ainu" },
            { "Mend", metaValue_men },
            { "guz", "Gusii" },
            { "type.nu.knda", "Digit Kannada" },
            { "Kali", "Kayah Li" },
            { "Sidd", "Siddham" },
            { "de_CH", "Jerman Halus Switzerland" },
            { "type.co.phonetic", "Urutan Isih Fonetik" },
            { "type.ca.buddhist", "Kalendar Buddha" },
            { "KE", "Kenya" },
            { "419", "Amerika Latin" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Kemboja" },
            { "KI", metaValue_KI },
            { "KM", "Comoros" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts dan Nevis" },
            { "Zinh", "Diwarisi" },
            { "fr_CA", "Perancis Kanada" },
            { "KP", "Korea Utara" },
            { "KR", "Korea Selatan" },
            { "Plrd", "Fonetik Pollard" },
            { "fr_CH", "Perancis Switzerland" },
            { "KW", "Kuwait" },
            { "tpi", "Tok Pisin" },
            { "KY", "Kepulauan Cayman" },
            { "KZ", metaValue_KZ },
            { "Cyrl", "Cyril" },
            { "LA", metaValue_LA },
            { "LB", "Lubnan" },
            { "LC", "Saint Lucia" },
            { "gwi", "Gwich\u02bcin" },
            { "nds", "Jerman Rendah" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "cop", metaValue_cop },
            { "Hmnp", "Nyiakeng Puachue Hmong" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", metaValue_LV },
            { "Kana", "Katakana" },
            { "Sora", "Sora Sompeng" },
            { "LY", "Libya" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "lah", "Lahnda" },
            { "Mahj", "Mahajani" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Maghribi" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "Nshu", "Nushu" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Kepulauan Marshall" },
            { "ale", "Aleut" },
            { "type.nu.vaii", "Digit Vai" },
            { "MK", "Macedonia Utara" },
            { "type.nu.mathdbl", "Digit Matematik Dwilejang" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", metaValue_MN },
            { "new", "Newari" },
            { "MO", "Macau SAR China" },
            { "MP", "Kepulauan Mariana Utara" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", metaValue_MT },
            { "type.m0.ungegn", "Transliterasi UN GEGN" },
            { "MU", "Mauritius" },
            { "alt", "Altai Selatan" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "Kalendar Jepun" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "Phli", "Inskripsi Pahlavi" },
            { "NA", "Namibia" },
            { "202", "Afrika Sub-Sahara" },
            { "type.ca.hebrew", "Kalendar Ibrani" },
            { "type.co.dictionary", "Aturan Isih Kamus" },
            { "NC", "New Caledonia" },
            { "%%WADEGILE", "Perumian Wade-Giles" },
            { "%%UCRCOR", "Sistem Ejaan Semakan Bersatu" },
            { "NE", "Niger" },
            { "NF", "Pulau Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "Taroko" },
            { "Phlp", "Pslater Pahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "Pahawh Hmong" },
            { "NL", metaValue_NL },
            { "NO", metaValue_NO },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "Phnx", "Phoenicia" },
            { "rof", "Rombo" },
            { "NZ", "New Zealand" },
            { "Merc", "Kursif Meroitic" },
            { "%%COLB1945", "Konvensyen Sistem Ejaan Portugis-Brazil 1945" },
            { "Mero", "Meroitic" },
            { "crh", "Turki Krimea" },
            { "OM", "Oman" },
            { "anp", "Angika" },
            { "crs", "Perancis Seselwa Creole" },
            { "type.nu.hmnp", "Digit Nyiakeng Puachue Hmong" },
            { "Xpeo", "Parsi Lama" },
            { "type.nu.hmng", "Digit Pahawh Hmong" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Kalendar Sivil Islam" },
            { "en_GB", "Inggeris British" },
            { "PE", "Peru" },
            { "PF", "Polinesia Perancis" },
            { "PG", "Papua New Guinea" },
            { "PH", metaValue_PH },
            { "PK", "Pakistan" },
            { "PL", metaValue_PL },
            { "ewo", "Ewondo" },
            { "PM", "Saint Pierre dan Miquelon" },
            { "PN", "Kepulauan Pitcairn" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Wilayah Palestin" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "Nias" },
            { "type.nu.greklow", "Angka Huruf Kecil Greek" },
            { "PY", "Paraguay" },
            { "tum", "Tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "Inggeris Standard Scotland" },
            { "niu", "Niu" },
            { "QO", "Oceania Terpencil" },
            { "lez", "Lezghian" },
            { "type.nu.ahom", "Digit Ahom" },
            { "%%FONUPA", "Fonetik UPA" },
            { "type.nu.takr", "Digit Takri" },
            { "tvl", metaValue_TV },
            { "Tavt", "Tai Viet" },
            { "%%SOTAV", "Kumpulan dialek Sotavento Kabuverdianu" },
            { "Maka", metaValue_mak },
            { "001", "Dunia" },
            { "002", "Afrika" },
            { "003", "Amerika Utara" },
            { "RE", "Reunion" },
            { "005", "Amerika Selatan" },
            { "jbo", "Lojban" },
            { "Rjng", "Rejang" },
            { "009", "Oceania" },
            { "Elym", "Elymaic" },
            { "RO", metaValue_RO },
            { "RS", metaValue_RS },
            { "Mroo", "Mro" },
            { "RU", metaValue_RU },
            { "RW", "Rwanda" },
            { "type.nu.talu", "Digit Tai Lue Baru" },
            { "%%METELKO", "Abjad Metelko" },
            { "Mani", "Manichaean" },
            { "Ugar", "Ugaritic" },
            { "Khar", "Kharoshthi" },
            { "SA", "Arab Saudi" },
            { "Mand", "Mandaean" },
            { "SB", "Kepulauan Solomon" },
            { "twq", "Tasawaq" },
            { "011", "Afrika Barat" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", metaValue_SE },
            { "013", "Amerika Tengah" },
            { "014", "Afrika Timur" },
            { "015", "Afrika Utara" },
            { "SG", "Singapura" },
            { "SH", "Saint Helena" },
            { "type.lb.strict", "Gaya Pemisah Baris Ketat" },
            { "SI", metaValue_SI },
            { "017", "Afrika Tengah" },
            { "type.nu.mymrtlng", "Digit Myanmar Tai Laing" },
            { "018", "Selatan Afrika" },
            { "SJ", "Svalbard dan Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "type.nu.taml", "Angka Tamil Tradisional" },
            { "SR", "Surinam" },
            { "SS", "Sudan Selatan" },
            { "ST", "Sao Tome dan Principe" },
            { "arq", "Arab Algeria" },
            { "SV", "El Salvador" },
            { "ars", "Arab Najdi" },
            { "SX", "Sint Maarten" },
            { "SY", metaValue_SY },
            { "SZ", "Swaziland" },
            { "arz", "Arab Mesir" },
            { "ary", "Arab Maghribi" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "Sistem Ukuran AS" },
            { "021", "Utara Amerika" },
            { "TC", "Kepulauan Turks dan Caicos" },
            { "yav", "Yangben" },
            { "TD", "Chad" },
            { "Qaag", "Zawgyi" },
            { "TF", "Wilayah Selatan Perancis" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tajikistan" },
            { "029", "Caribbean" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "ybb", "Yemba" },
            { "type.co.searchjl", "Cari Mengikut Konsonan Awal Hangul" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tunisia" },
            { "TO", metaValue_TO },
            { "%%NULIK", "Volapuk Moden" },
            { "TR", metaValue_TR },
            { "TT", "Trinidad dan Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "ast", "Asturia" },
            { "Orkh", "Orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Tulisan Tidak Diketahui" },
            { "Sind", "Khudawadi" },
            { "UA", metaValue_UA },
            { "rup", "Aromanian" },
            { "030", "Asia Timur" },
            { "tyv", "Tuvinian" },
            { "sw_CD", "Congo Swahili" },
            { "034", "Asia Selatan" },
            { "035", "Asia Tenggara" },
            { "UG", "Uganda" },
            { "hak", "Cina Hakka" },
            { "type.co.pinyin", "Aturan Isih Pinyin" },
            { "039", "Eropah Selatan" },
            { "Sinh", metaValue_si },
            { "UM", "Kepulauan Terpencil A.S." },
            { "UN", "Bangsa-bangsa Bersatu" },
            { "US", "Amerika Syarikat" },
            { "haw", "Hawaii" },
            { "%%1959ACAD", "Akademik" },
            { "type.co.gb2312han", "Aturan Isih Bahasa Cina Ringkas - GB2312" },
            { "UY", "Uruguay" },
            { "prg", "Prusia" },
            { "UZ", metaValue_UZ },
            { "tzm", "Tamazight Atlas Tengah" },
            { "type.co.stroke", "Aturan Isih Coretan" },
            { "nnh", "Ngiemboon" },
            { "VA", "Kota Vatican" },
            { "VC", "Saint Vincent dan Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Kepulauan Virgin British" },
            { "VI", "Kepulauan Virgin A.S." },
            { "Soyo", "Soyombo" },
            { "VN", metaValue_VN },
            { "VU", "Vanuatu" },
            { "Marc", "Marchen" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis dan Futuna" },
            { "type.co.traditional", "Aturan Isih Tradisional" },
            { "057", "Wilayah Mikronesia" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "type.nu.finance", "Angka Kewangan" },
            { "%%HEPBURN", "Perumian Hepburn" },
            { "type.co.compat", "Tertib Isihan Sebelumnya" },
            { "wae", "Walser" },
            { "WS", metaValue_WS },
            { "Bass", "Bassa Vah" },
            { "type.nu.mtei", "Digit Meetei Mayek" },
            { "wal", "Wolaytta" },
            { "XA", "Aksen Pseudo" },
            { "war", "Waray" },
            { "XB", "Bidi Pseudo" },
            { "awa", "Awadhi" },
            { "061", "Polinesia" },
            { "%%KSCOR", "Sistem Ejaan Standard" },
            { "XK", "Kosovo" },
            { "type.nu.brah", "Digit Brahmi" },
            { "Gujr", "Gujarat" },
            { "Zxxx", "Tidak ditulis" },
            { "Olck", "Ol Chiki" },
            { "wbp", "Warlpiri" },
            { "Batk", "Batak" },
            { "YE", "Yaman" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "Tertib Isih Standard" },
            { "Zanb", "Segi Empat Zanabazar" },
            { "%%BALANKA", "Dialek Balanka Anii" },
            { "%%ROZAJ", "Resia" },
            { "Sgnw", "Tulisan Isyarat" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "Digit Cham" },
            { "ZA", "Afrika Selatan" },
            { "type.nu.sund", "Digit Sunda" },
            { "type.lb.loose", "Gaya Pemisah Baris Bebas" },
            { "Deva", "Devanagari" },
            { "type.nu.geor", "Angka Georgia" },
            { "type.co.zhuyin", "Aturan Isih Zhuyin" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "Perumian Pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Wilayah Tidak Diketahui" },
            { "Runr", "Runic" },
            { "type.ms.metric", "Sistem Metrik" },
            { "type.ca.iso8601", "Kalendar ISO-8601" },
            { "nso", "Sotho Utara" },
            { "type.nu.telu", "Digit Telugu" },
            { "lou", "Kreol Louisiana" },
            { "loz", "Lozi" },
            { "jmc", "Machame" },
            { "type.nu.hansfin", "Angka Kewangan Cina Ringkas" },
            { "hil", "Hiligaynon" },
            { "type.nu.arabext", "Digit Indi Arab Lanjutan" },
            { "nus", "Nuer" },
            { "dak", "Dakota" },
            { "type.nu.fullwide", "Digit Lebar Penuh" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "lrc", "Luri Utara" },
            { "type.co.emoji", "Aturan Isih Emoji" },
            { "Copt", metaValue_cop },
            { "udm", "Udmurt" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "Kalendar Islam (Arab Saudi, cerapan)" },
            { "Limb", "Limbu" },
            { "sad", "Sandawe" },
            { "type.nu.roman", "Angka Roman" },
            { "sah", "Sakha" },
            { "type.nu.shrd", "Digit Sharada" },
            { "Aghb", "Kaukasia Albania" },
            { "saq", "Samburu" },
            { "sat", "Santali" },
            { "Tfng", "Tifinagh" },
            { "type.d0.npinyin", "Bernombor" },
            { "type.nu.native", "Digit Asal" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "%%ALUKU", "Dialek Aluku" },
            { "lua", "Luba-Lulua" },
            { "type.nu.tirh", "Digit Tirhuta" },
            { "type.d0.fwidth", "Ke Kelebaran Penuh" },
            { "sbp", "Sangu" },
            { "nyn", "Nyankole" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "fil", metaValue_PH },
            { "hmn", "Hmong" },
            { "lus", "Mizo" },
            { "bal", "Baluchi" },
            { "ban", metaValue_ban },
            { "type.nu.wara", "Digit Warang Citi" },
            { "luy", "Luyia" },
            { "bas", "Basaa" },
            { "bax", "Bamun" },
            { "%%ABL1943", "Perumusan sistem ejaan 1943" },
            { "es_ES", "Sepanyol Eropah" },
            { "sco", "Scots" },
            { "scn", "Sicili" },
            { "aa", "Afar" },
            { "ab", "Abkhazia" },
            { "Aran", "Nastaliq" },
            { "ae", metaValue_ae },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "type.nu.cakm", "Digit Chakma" },
            { "bbj", "Ghomala" },
            { "am", "Amharic" },
            { "Arab", metaValue_ar },
            { "an", "Aragon" },
            { "%%SOLBA", "Dialek Stolvizza/Solbica" },
            { "Jpan", metaValue_JP },
            { "ar", metaValue_ar },
            { "Hrkt", "Ejaan sukuan Jepun" },
            { "as", "Assam" },
            { "Lina", "Linear A" },
            { "av", "Avaric" },
            { "Linb", "Linear B" },
            { "sdh", "Kurdish Selatan" },
            { "ay", "Aymara" },
            { "az", metaValue_AZ },
            { "Rohg", "Hanifi Rohingya" },
            { "Khoj", "Khojki" },
            { "%%OSOJS", "Dialek Oseacco/Osojane" },
            { "%%UNIFON", "Abjad fonetik Unifon" },
            { "ba", "Bashkir" },
            { "type.co.unihan", "Aturan Isih Coretan Radikal" },
            { "be", metaValue_BY },
            { "bg", metaValue_BG },
            { "bi", "Bislama" },
            { "type.nu.java", "Digit Jawa" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "Dogrib" },
            { "br", "Breton" },
            { "bs", "Bosnia" },
            { "Bhks", "Bhaisuki" },
            { "see", "Seneca" },
            { "Mymr", "Myammar" },
            { "type.nu.laoo", "Digit Lao" },
            { "seh", "Sena" },
            { "Nkoo", metaValue_nqo },
            { "ca", "Catalonia" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "%%REVISED", "Sistem Ejaan Semakan" },
            { "co", "Corsica" },
            { "Orya", "Oriya" },
            { "cs", "Czech" },
            { "cu", "Slavik Gereja" },
            { "cv", "Chuvash" },
            { "cy", "Wales" },
            { "type.nu.ethi", "Angka Ethiopia" },
            { "Yiii", "Yi" },
            { "da", metaValue_DK },
            { "pt_PT", "Portugis Eropah" },
            { "de", metaValue_DE },
            { "type.cf.standard", "Format Mata Wang Standard" },
            { "bej", "Beja" },
            { "Bugi", metaValue_bug },
            { "bem", "Bemba" },
            { "type.nu.mong", "Digit Mongolia" },
            { "dv", "Divehi" },
            { "es_419", "Sepanyol Amerika Latin" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Kalendar Cina" },
            { "Lisu", "Fraser" },
            { "dje", "Zarma" },
            { "type.nu.grek", "Angka Greek" },
            { "ee", "Ewe" },
            { "bfd", "Bafut" },
            { "type.lb.normal", "Gaya Pemisah Baris Biasa" },
            { "ro_MD", "Moldavia" },
            { "el", metaValue_el },
            { "en", "Inggeris" },
            { "eo", "Esperanto" },
            { "type.co.big5han", "Aturan Isih Cina Tradisional - Big5" },
            { "es", metaValue_ES },
            { "et", metaValue_EE },
            { "Hanb", "Han dengan Bopomofo" },
            { "eu", "Basque" },
            { "Buhd", "Buhid" },
            { "Hang", "Hangul" },
            { "Samr", "Samaritan" },
            { "shi", "Tachelhit" },
            { "hsb", "Sorbian Atas" },
            { "Hani", "Han" },
            { "shn", "Shan" },
            { "Hano", "Hanunoo" },
            { "fa", "Parsi" },
            { "Hans", "Ringkas" },
            { "type.nu.latn", "Digit Barat" },
            { "Hant", "Tradisional" },
            { "ff", "Fulah" },
            { "shu", "Arab Chadian" },
            { "hsn", "Cina Xiang" },
            { "fi", metaValue_FI },
            { "fj", metaValue_FJ },
            { "fon", "Fon" },
            { "bgn", "Balochi Barat" },
            { "yue", "Kantonis" },
            { "fo", "Faroe" },
            { "type.m0.bgn", "Transliterasi BGN AS" },
            { "umb", "Umbundu" },
            { "fr", metaValue_FR },
            { "fy", "Frisian Barat" },
            { "ga", metaValue_IE },
            { "Wcho", "Wancho" },
            { "gd", "Scots Gaelic" },
            { "Gong", "Gunjala Gondi" },
            { "gl", "Galicia" },
            { "Gonm", "Masaram Gonti" },
            { "gn", "Guarani" },
            { "bho", "Bhojpuri" },
            { "und", "Bahasa Tidak Diketahui" },
            { "type.ca.ethiopic-amete-alem", "Kalendar Amete Alem Ethiopia" },
            { "gu", "Gujerat" },
            { "type.ca.islamic-tbla", "Kalendar Islam (jadual, zaman astronomi)" },
            { "gv", "Manx" },
            { "type.nu.osma", "Digit Osmanya" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bin", "Bini" },
            { "hr", metaValue_HR },
            { "ht", metaValue_HT },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "hz", "Herero" },
            { "frc", "Perancis Cajun" },
            { "%%FONIPA", "Fonetik IPA" },
            { "ia", "Interlingua" },
            { "Jamo", "Jamo" },
            { "id", metaValue_ID },
            { "type.nu.tibt", "Digit Tibet" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "%%AO1990", "Perjanjian Sistem Ejaan Bahasa Portugis 1990" },
            { "io", "Ido" },
            { "is", metaValue_IS },
            { "it", metaValue_IT },
            { "iu", "Inuktitut" },
            { "ja", metaValue_JP },
            { "Mlym", metaValue_ml },
            { "Sarb", "Arab Selatan Lama" },
            { "doi", "Dogri" },
            { "type.nu.lepc", "Digit Lepcha" },
            { "bkm", "Kom" },
            { "sma", "Sami Selatan" },
            { "jv", metaValue_jv },
            { "Shaw", "Shavia" },
            { "mad", "Madura" },
            { "smj", "Lule Sami" },
            { "mag", "Magahi" },
            { "maf", "Mafa" },
            { "mai", "Maithili" },
            { "smn", "Inari Sami" },
            { "ka", metaValue_GE },
            { "mak", metaValue_mak },
            { "bla", "Siksika" },
            { "wuu", "Cina Wu" },
            { "sms", "Skolt Sami" },
            { "kg", "Kongo" },
            { "Goth", "Gothic" },
            { "ki", "Kikuya" },
            { "mas", "Masai" },
            { "kj", "Kuanyama" },
            { "kk", metaValue_KZ },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kashmir" },
            { "Lepc", "Lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "Kurdish" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kirghiz" },
            { "snk", "Soninke" },
            { "Mult", "Multani" },
            { "la", metaValue_la },
            { "Hatr", "Hatran" },
            { "lb", metaValue_LU },
            { "type.nu.mlym", "Digit Malayalam" },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "fur", "Friulian" },
            { "lo", metaValue_LA },
            { "type.ms.uksystem", "Sistem Ukuran Imperial" },
            { "type.nu.lana", "Digit Tai Tham Hora" },
            { "lt", metaValue_LT },
            { "lu", "Luba-Katanga" },
            { "lv", metaValue_LV },
            { "mg", "Malagasy" },
            { "mh", "Marshall" },
            { "type.co.ducet", "Tertib Isih Unikod Lalai" },
            { "mi", "Maori" },
            { "mk", "Macedonia" },
            { "ml", metaValue_ml },
            { "mn", metaValue_MN },
            { "mr", "Marathi" },
            { "ms", "Melayu" },
            { "mt", metaValue_MT },
            { "my", "Burma" },
            { "Saur", "Saurashtra" },
            { "Armn", metaValue_AM },
            { "mdf", "Moksha" },
            { "mde", "Maba" },
            { "dsb", "Sorbian Rendah" },
            { "Armi", "Aramia Imperial" },
            { "na", metaValue_NR },
            { "type.co.search", "Carian Tujuan Umum" },
            { "nb", "Bokm\u00e5l Norway" },
            { "nd", "Ndebele Utara" },
            { "ne", metaValue_NP },
            { "ng", "Ndonga" },
            { "nl", metaValue_NL },
            { "nn", "Nynorsk Norway" },
            { "no", metaValue_NO },
            { "nr", "Ndebele Selatan" },
            { "type.nu.modi", "Digit Modi" },
            { "Osge", "Osage" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "kac", "Kachin" },
            { "kab", "Kabyle" },
            { "%%POLYTON", "Banyak Nada" },
            { "oc", "Occitania" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "Inggeris Moden Awal" },
            { "mer", "Meru" },
            { "type.nu.armn", "Angka Armenia" },
            { "om", "Oromo" },
            { "or", "Odia" },
            { "Modi", "Modi" },
            { "os", "Ossete" },
            { "%%ALALC97", "Perumian ALA-LC, edisi 1997" },
            { "bpy", "Bishnupriya" },
            { "kbd", "Kabardia" },
            { "mfe", "Morisyen" },
            { "srn", "Sranan Tongo" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "%%LIPAW", "Dialek Lipovaz Resia" },
            { "kbl", "Kanembu" },
            { "pl", metaValue_PL },
            { "type.nu.saur", "Digit Saurashtra" },
            { "type.ca.dangi", "Kalendar Dangi" },
            { "ps", "Pashto" },
            { "pt", "Portugis" },
            { "key.co", "Tertib Isihan" },
            { "pt_BR", "Portugis Brazil" },
            { "%%BOHORIC", "Abjad Bohoric" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "key.cf", "Format Mata wang" },
            { "type.nu.nkoo", "Digit N\u2019Ko" },
            { "key.ca", "Kalendar" },
            { "Laoo", "Lao" },
            { "mgo", "Meta\u2019" },
            { "type.hc.h23", "Sistem 24 Jam (0\u201323)" },
            { "type.hc.h24", "Sistem 24 Jam (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "brh", "Brahui" },
            { "type.nu.mymr", "Digit Myammar" },
            { "qu", "Quechua" },
            { "brx", "Bodo" },
            { "Lana", "Lanna" },
            { "kde", "Makonde" },
            { "Ethi", metaValue_ET },
            { "type.hc.h12", "Sistem 12 Jam (1\u201312)" },
            { "type.hc.h11", "Sistem 12 Jam (0\u201311)" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "key.cu", "Mata wang" },
            { "ro", metaValue_RO },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "Digit Oriya" },
            { "type.nu.hanidec", "Angka Perpuluhan Cina" },
            { "ru", metaValue_RU },
            { "bss", "Akoose" },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "mic", "Micmac" },
            { "suk", "Sukuma" },
            { "en_AU", "Inggeris Australia" },
            { "Dupl", "Trengkas Duployan" },
            { "sa", "Sanskrit" },
            { "%%UCCOR", "Sistem Ejaan Bersatu" },
            { "sc", "Sardinia" },
            { "sd", "Sindhi" },
            { "se", "Sami Utara" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "SerboCroatia" },
            { "si", metaValue_si },
            { "sk", "Slovak" },
            { "sl", metaValue_SI },
            { "Gran", "Grantha" },
            { "sm", metaValue_WS },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "type.nu.arab", "Digit Indi-Arab" },
            { "sq", metaValue_AL },
            { "sr", metaValue_RS },
            { "ss", "Swati" },
            { "type.cf.account", "Format Mata Wang Perakaunan" },
            { "Java", metaValue_jv },
            { "st", "Sotho Selatan" },
            { "su", metaValue_su },
            { "%%NEDIS", "Dialek Natisone" },
            { "sv", metaValue_SE },
            { "sw", "Swahili" },
            { "type.nu.wcho", "Digit Wancho" },
            { "type.nu.hantfin", "Angka Kewangan Cina Tradisional" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "ta", metaValue_ta },
            { "142", "Asia" },
            { "bua", "Buriat" },
            { "143", "Asia Tengah" },
            { "te", metaValue_te },
            { "145", "Asia Barat" },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "Tigrinya" },
            { "kfo", "Koro" },
            { "en_CA", "Inggeris Kanada" },
            { "tk", "Turkmen" },
            { "tn", "Tswana" },
            { "to", metaValue_TO },
            { "bum", "Bulu" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Angka Jepun" },
            { "tr", metaValue_TR },
            { "Cakm", metaValue_ccp },
            { "ts", "Tsonga" },
            { "swb", "Comoria" },
            { "tt", "Tatar" },
            { "tw", "Twi" },
            { "ty", "Tahiti" },
            { "%%BISKE", "Dialek San Giorgio/Bila" },
            { "150", "Eropah" },
            { "151", "Eropah Timur" },
            { "type.nu.rohg", "Digit Hanifi Rohingya" },
            { "type.nu.mathsanb", "Digit Matematik San Serif Tebal" },
            { "154", "Eropah Utara" },
            { "dzg", "Dazaga" },
            { "155", "Eropah Barat" },
            { "ug", "Uyghur" },
            { "Kore", metaValue_ko },
            { "Ital", "Italik Lama" },
            { "Zyyy", "Lazim" },
            { "uk", metaValue_UA },
            { "type.ca.coptic", "Kalendar Qibti" },
            { "ur", "Urdu" },
            { "%%1994", "Sistem ejaan Resia standard" },
            { "xal", "Kalmyk" },
            { "uz", metaValue_UZ },
            { "kha", "Khasi" },
            { "%%1996", "Sistem ejaan Jerman 1996" },
            { "nds_NL", "Saxon Rendah" },
            { "Sylo", "Syloti Nagri" },
            { "ve", "Venda" },
            { "Wara", "Varang Kshiti" },
            { "type.ca.roc", "Kalendar Minguo" },
            { "vi", metaValue_VN },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Kitaran Jam (12 berbanding 24)" },
            { "%%TARASK", "Sistem ejaan Taraskievica" },
            { "vo", "Volap\u00fck" },
            { "khw", "Khowar" },
            { "type.nu.mathsans", "Digit Matematik San Serif" },
            { "Osma", "Osmanya" },
            { "quc", "K\u02bciche\u02bc" },
            { "type.nu.gonm", "Digit Masaram Gondi" },
            { "Newa", "Newa" },
            { "gaa", "Ga" },
            { "wa", "Walloon" },
            { "gag", "Gagauz" },
            { "syr", "Syriac" },
            { "type.nu.gong", "Digit Gunjala Gondi" },
            { "Grek", metaValue_el },
            { "gan", "Cina Gan" },
            { "Lydi", "Lydia" },
            { "Xsux", "Aksara Paku Sumero-Akkadia" },
            { "wo", "Wolof" },
            { "zgh", "Tamazight Maghribi Standard" },
            { "ar_001", "Arab Standard Moden" },
            { "Cans", "Suku Kata Orang Asli Kanada Bersatu" },
            { "Mong", metaValue_MN },
            { "Hluw", "Hiroglif Anatoli" },
            { "gba", "Gbaya" },
            { "mni", "Manipuri" },
            { "Latn", metaValue_la },
            { "Nand", "Nandinagari" },
            { "type.nu.hans", "Angka Cina Ringkas" },
            { "type.nu.hant", "Angka Cina Tradisional" },
            { "xh", "Xhosa" },
            { "type.nu.romanlow", "Angka Huruf Kecil Roman" },
            { "byn", "Blin" },
            { "Dogr", "Dogra" },
            { "%%PAMAKA", "Dialek Pamaka" },
            { "Lyci", "Lycia" },
            { "byv", "Medumba" },
            { "gbz", "Zoroastrian Dari" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "%%1694ACAD", "Awal Pertengahan Era Perancis" },
            { "Syrc", metaValue_SY },
            { "yi", "Yiddish" },
            { "mos", "Mossi" },
            { "Dsrt", "Deseret" },
            { "yo", "Yoruba" },
            { "type.nu.traditional", "Angka Tradisional" },
            { "es_MX", "Sepanyol Mexico" },
            { "vai", metaValue_vai },
            { "Cari", "Carian" },
            { "kln", "Kalenjin" },
            { "zh", "Cina" },
            { "Bopo", "Bopomofo" },
            { "Perm", "Permic Lama" },
            { "key.lb", "Gaya Pemisah Baris" },
            { "zu", "Zulu" },
            { "type.co.phonebook", "Aturan Isih Buku Telefon" },
            { "%%MONOTON", "Ekanada" },
            { "Geor", metaValue_GE },
            { "Shrd", "Sharada" },
            { "kmb", "Kimbundu" },
            { "type.nu.jpanfin", "Angka Kewangan Jepun" },
            { "Cham", "Cham" },
            { "gez", "Geez" },
            { "type.nu.mymrshan", "Digit Myanmar Shan" },
            { "Elba", "Elbasan" },
            { "Narb", "Arab Utara Lama" },
            { "type.nu.olck", "Digit Ol Chiki" },
            { "type.co.reformed", "Aturan Isih Pembaharuan" },
            { "Tglg", "Tagalog" },
            { "Palm", "Palmyrene" },
            { "ebu", "Embu" },
            { "Egyp", "Hiroglif Mesir" },
            { "zh_Hans", "Cina Ringkas" },
            { "koi", "Komi-Permyak" },
            { "Hung", "Hungary Lama" },
            { "kok", "Konkani" },
            { "%%1901", "Sistem ejaan Jerman Tradisional" },
            { "type.nu.limb", "Digit Limbu" },
            { "zh_Hant", "Cina Tradisional" },
            { "Sund", metaValue_su },
            { "kpe", "Kpelle" },
            { "type.nu.khmr", "Digit Khmer" },
            { "Tirh", "Tirhuta" },
            { "ilo", "Iloko" },
            { "%%VALENCIA", "Valencia" },
            { "Cprt", "Cypriot" },
            { "%%BAKU1926", "Abjad Latin Turki Disatukan" },
            { "%%IJEKAVSK", "Fon Serbia dengan sebutan Ijekavia" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Digit Gurmukhi" },
            { "mul", "Pelbagai Bahasa" },
            { "key.ms", "Sistem Ukuran" },
            { "mus", "Creek" },
            { "Glag", "Glagolitik" },
            { "gil", metaValue_KI },
            { "%%KKCOR", "Sistem Ejaan Lazim" },
            { "Cher", metaValue_chr },
            { "cay", "Cayuga" },
            { "type.nu.tamldec", "Digit Tamil" },
            { "krc", "Karachay-Balkar" },
            { "inh", "Ingush" },
            { "fa_AF", "Dari" },
            { "krl", "Karelian" },
            { "%%OXENDICT", "Ejaan Kamus Inggeris Oxford" },
            { "efi", "Efik" },
            { "key.nu", "Nombor" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
