/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup.goals;

import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.cli.mvnup.UpgradeOptions;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Priority;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.cling.invoker.mvnup.UpgradeContext;
import org.apache.maven.cling.invoker.mvnup.goals.AbstractUpgradeStrategy;
import org.apache.maven.cling.invoker.mvnup.goals.GAV;
import org.apache.maven.cling.invoker.mvnup.goals.GAVUtils;
import org.apache.maven.cling.invoker.mvnup.goals.UpgradeResult;
import org.jdom2.Attribute;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;

@Named
@Singleton
@Priority(value=20)
public class CompatibilityFixStrategy
extends AbstractUpgradeStrategy {
    @Override
    public boolean isApplicable(UpgradeContext context) {
        boolean allOptionsDisabled;
        UpgradeOptions options = this.getOptions(context);
        boolean useAll = options.all().orElse(false);
        if (useAll) {
            return true;
        }
        boolean noOptionsSpecified = options.all().isEmpty() && options.infer().isEmpty() && options.model().isEmpty() && options.plugins().isEmpty() && options.modelVersion().isEmpty();
        boolean bl = allOptionsDisabled = options.all().map(v -> v == false).orElse(false) != false && options.infer().map(v -> v == false).orElse(false) != false && options.model().map(v -> v == false).orElse(false) != false && options.plugins().map(v -> v == false).orElse(false) != false && options.modelVersion().isEmpty();
        if (noOptionsSpecified || allOptionsDisabled) {
            return true;
        }
        if (options.model().isPresent()) {
            return (Boolean)options.model().get();
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Applying Maven 4 compatibility fixes";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeResult doApply(UpgradeContext context, Map<Path, Document> pomMap) {
        HashSet<Path> processedPoms = new HashSet<Path>();
        HashSet<Path> modifiedPoms = new HashSet<Path>();
        HashSet<Path> errorPoms = new HashSet<Path>();
        for (Map.Entry<Path, Document> entry : pomMap.entrySet()) {
            Path pomPath = entry.getKey();
            Document pomDocument = entry.getValue();
            processedPoms.add(pomPath);
            context.info(String.valueOf(pomPath) + " (checking for Maven 4 compatibility issues)");
            context.indent();
            try {
                boolean hasIssues = false;
                hasIssues |= this.fixUnsupportedCombineChildrenAttributes(pomDocument, context);
                hasIssues |= this.fixUnsupportedCombineSelfAttributes(pomDocument, context);
                hasIssues |= this.fixDuplicateDependencies(pomDocument, context);
                hasIssues |= this.fixDuplicatePlugins(pomDocument, context);
                hasIssues |= this.fixUnsupportedRepositoryExpressions(pomDocument, context);
                if (hasIssues |= this.fixIncorrectParentRelativePaths(pomDocument, pomPath, pomMap, context)) {
                    context.success("Maven 4 compatibility issues fixed");
                    modifiedPoms.add(pomPath);
                    continue;
                }
                context.success("No Maven 4 compatibility issues found");
            }
            catch (Exception e) {
                context.failure("Failed to fix Maven 4 compatibility issues: " + e.getMessage());
                errorPoms.add(pomPath);
            }
            finally {
                context.unindent();
            }
        }
        return new UpgradeResult(processedPoms, modifiedPoms, errorPoms);
    }

    private boolean fixUnsupportedCombineChildrenAttributes(Document pomDocument, UpgradeContext context) {
        boolean fixed = false;
        Element root = pomDocument.getRootElement();
        List<Element> elementsWithCombineChildren = this.findElementsWithAttribute(root, "combine.children", "override");
        for (Element element : elementsWithCombineChildren) {
            element.getAttribute("combine.children").setValue("merge");
            context.detail("Fixed: combine.children='override' \u2192 'merge' in " + element.getName());
            fixed = true;
        }
        return fixed;
    }

    private boolean fixUnsupportedCombineSelfAttributes(Document pomDocument, UpgradeContext context) {
        boolean fixed = false;
        Element root = pomDocument.getRootElement();
        List<Element> elementsWithCombineSelf = this.findElementsWithAttribute(root, "combine.self", "append");
        for (Element element : elementsWithCombineSelf) {
            element.getAttribute("combine.self").setValue("merge");
            context.detail("Fixed: combine.self='append' \u2192 'merge' in " + element.getName());
            fixed = true;
        }
        return fixed;
    }

    private boolean fixDuplicateDependencies(Document pomDocument, UpgradeContext context) {
        Element profilesElement;
        Element managedDependenciesElement;
        Element dependencyManagementElement;
        Element root = pomDocument.getRootElement();
        Namespace namespace = root.getNamespace();
        boolean fixed = false;
        Element dependenciesElement = root.getChild("dependencies", namespace);
        if (dependenciesElement != null) {
            fixed |= this.fixDuplicateDependenciesInSection(dependenciesElement, namespace, context, "dependencies");
        }
        if ((dependencyManagementElement = root.getChild("dependencyManagement", namespace)) != null && (managedDependenciesElement = dependencyManagementElement.getChild("dependencies", namespace)) != null) {
            fixed |= this.fixDuplicateDependenciesInSection(managedDependenciesElement, namespace, context, "dependencyManagement");
        }
        if ((profilesElement = root.getChild("profiles", namespace)) != null) {
            List profileElements = profilesElement.getChildren("profile", namespace);
            for (Element profileElement : profileElements) {
                Element profileManagedDeps;
                Element profileDepMgmt;
                Element profileDependencies = profileElement.getChild("dependencies", namespace);
                if (profileDependencies != null) {
                    fixed |= this.fixDuplicateDependenciesInSection(profileDependencies, namespace, context, "profile dependencies");
                }
                if ((profileDepMgmt = profileElement.getChild("dependencyManagement", namespace)) == null || (profileManagedDeps = profileDepMgmt.getChild("dependencies", namespace)) == null) continue;
                fixed |= this.fixDuplicateDependenciesInSection(profileManagedDeps, namespace, context, "profile dependencyManagement");
            }
        }
        return fixed;
    }

    private boolean fixDuplicatePlugins(Document pomDocument, UpgradeContext context) {
        Element profilesElement;
        Element root = pomDocument.getRootElement();
        Namespace namespace = root.getNamespace();
        boolean fixed = false;
        Element buildElement = root.getChild("build", namespace);
        if (buildElement != null) {
            fixed |= this.fixPluginsInBuildElement(buildElement, namespace, context, "build");
        }
        if ((profilesElement = root.getChild("profiles", namespace)) != null) {
            for (Element profileElement : profilesElement.getChildren("profile", namespace)) {
                Element profileBuildElement = profileElement.getChild("build", namespace);
                if (profileBuildElement == null) continue;
                fixed |= this.fixPluginsInBuildElement(profileBuildElement, namespace, context, "profile build");
            }
        }
        return fixed;
    }

    private boolean fixUnsupportedRepositoryExpressions(Document pomDocument, UpgradeContext context) {
        Element root = pomDocument.getRootElement();
        Namespace namespace = root.getNamespace();
        boolean fixed = false;
        fixed |= this.fixRepositoryExpressions(root.getChild("repositories", namespace), namespace, context);
        fixed |= this.fixRepositoryExpressions(root.getChild("pluginRepositories", namespace), namespace, context);
        Element profilesElement = root.getChild("profiles", namespace);
        if (profilesElement != null) {
            List profileElements = profilesElement.getChildren("profile", namespace);
            for (Element profileElement : profileElements) {
                fixed |= this.fixRepositoryExpressions(profileElement.getChild("repositories", namespace), namespace, context);
                fixed |= this.fixRepositoryExpressions(profileElement.getChild("pluginRepositories", namespace), namespace, context);
            }
        }
        return fixed;
    }

    private boolean fixIncorrectParentRelativePaths(Document pomDocument, Path pomPath, Map<Path, Document> pomMap, UpgradeContext context) {
        String parentVersion;
        String parentArtifactId;
        Namespace namespace;
        Element root = pomDocument.getRootElement();
        Element parentElement = root.getChild("parent", namespace = root.getNamespace());
        if (parentElement == null) {
            return false;
        }
        Element relativePathElement = parentElement.getChild("relativePath", namespace);
        String currentRelativePath = relativePathElement != null ? relativePathElement.getTextTrim() : "../pom.xml";
        String parentGroupId = this.getChildText(parentElement, "groupId", namespace);
        Path correctParentPath = this.findParentPomInMap(context, parentGroupId, parentArtifactId = this.getChildText(parentElement, "artifactId", namespace), parentVersion = this.getChildText(parentElement, "version", namespace), pomMap);
        if (correctParentPath != null) {
            try {
                Path correctRelativePath = pomPath.getParent().relativize(correctParentPath);
                String correctRelativePathStr = correctRelativePath.toString().replace('\\', '/');
                if (!correctRelativePathStr.equals(currentRelativePath)) {
                    if (relativePathElement == null) {
                        relativePathElement = new Element("relativePath", namespace);
                        Element insertAfter = parentElement.getChild("version", namespace);
                        if (insertAfter == null) {
                            insertAfter = parentElement.getChild("artifactId", namespace);
                        }
                        if (insertAfter != null) {
                            parentElement.addContent(parentElement.indexOf((Content)insertAfter) + 1, (Content)relativePathElement);
                        } else {
                            parentElement.addContent((Content)relativePathElement);
                        }
                    }
                    relativePathElement.setText(correctRelativePathStr);
                    context.detail("Fixed: relativePath corrected from '" + currentRelativePath + "' to '" + correctRelativePathStr + "'");
                    return true;
                }
            }
            catch (Exception e) {
                context.failure("Failed to compute correct relativePath: " + e.getMessage());
            }
        }
        return false;
    }

    private List<Element> findElementsWithAttribute(Element element, String attributeName, String attributeValue) {
        ArrayList<Element> result = new ArrayList<Element>();
        Attribute attr = element.getAttribute(attributeName);
        if (attr != null && attributeValue.equals(attr.getValue())) {
            result.add(element);
        }
        for (Element child : element.getChildren()) {
            result.addAll(this.findElementsWithAttribute(child, attributeName, attributeValue));
        }
        return result;
    }

    private boolean fixDuplicateDependenciesInSection(Element dependenciesElement, Namespace namespace, UpgradeContext context, String sectionName) {
        boolean fixed = false;
        List dependencies = dependenciesElement.getChildren("dependency", namespace);
        HashMap<CallSite, Element> seenDependencies = new HashMap<CallSite, Element>();
        ArrayList<Element> toRemove = new ArrayList<Element>();
        for (Element dependency : dependencies) {
            String classifier;
            String type;
            String artifactId;
            String groupId = this.getChildText(dependency, "groupId", namespace);
            String key = groupId + ":" + (artifactId = this.getChildText(dependency, "artifactId", namespace)) + ":" + ((type = this.getChildText(dependency, "type", namespace)) != null ? type : "jar") + ":" + ((classifier = this.getChildText(dependency, "classifier", namespace)) != null ? classifier : "");
            if (seenDependencies.containsKey(key)) {
                toRemove.add(dependency);
                context.detail("Fixed: Removed duplicate dependency: " + key + " in " + sectionName);
                fixed = true;
                continue;
            }
            seenDependencies.put((CallSite)((Object)key), dependency);
        }
        for (Element duplicate : toRemove) {
            this.removeElementWithFormatting(duplicate);
        }
        return fixed;
    }

    private boolean fixPluginsInBuildElement(Element buildElement, Namespace namespace, UpgradeContext context, String sectionName) {
        Element managedPluginsElement;
        Element pluginManagementElement;
        boolean fixed = false;
        Element pluginsElement = buildElement.getChild("plugins", namespace);
        if (pluginsElement != null) {
            fixed |= this.fixDuplicatePluginsInSection(pluginsElement, namespace, context, sectionName + "/plugins");
        }
        if ((pluginManagementElement = buildElement.getChild("pluginManagement", namespace)) != null && (managedPluginsElement = pluginManagementElement.getChild("plugins", namespace)) != null) {
            fixed |= this.fixDuplicatePluginsInSection(managedPluginsElement, namespace, context, sectionName + "/pluginManagement/plugins");
        }
        return fixed;
    }

    private boolean fixDuplicatePluginsInSection(Element pluginsElement, Namespace namespace, UpgradeContext context, String sectionName) {
        boolean fixed = false;
        List plugins = pluginsElement.getChildren("plugin", namespace);
        HashMap<CallSite, Element> seenPlugins = new HashMap<CallSite, Element>();
        ArrayList<Element> toRemove = new ArrayList<Element>();
        for (Element plugin : plugins) {
            String groupId = this.getChildText(plugin, "groupId", namespace);
            String artifactId = this.getChildText(plugin, "artifactId", namespace);
            if (groupId == null && artifactId != null && artifactId.startsWith("maven-")) {
                groupId = "org.apache.maven.plugins";
            }
            if (groupId == null || artifactId == null) continue;
            String key = groupId + ":" + artifactId;
            if (seenPlugins.containsKey(key)) {
                toRemove.add(plugin);
                context.detail("Fixed: Removed duplicate plugin: " + key + " in " + sectionName);
                fixed = true;
                continue;
            }
            seenPlugins.put((CallSite)((Object)key), plugin);
        }
        for (Element duplicate : toRemove) {
            this.removeElementWithFormatting(duplicate);
        }
        return fixed;
    }

    private boolean fixRepositoryExpressions(Element repositoriesElement, Namespace namespace, UpgradeContext context) {
        if (repositoriesElement == null) {
            return false;
        }
        boolean fixed = false;
        String elementType = repositoriesElement.getName().equals("repositories") ? "repository" : "pluginRepository";
        List repositories = repositoriesElement.getChildren(elementType, namespace);
        for (Element repository : repositories) {
            String url;
            Element urlElement = repository.getChild("url", namespace);
            if (urlElement == null || !(url = urlElement.getTextTrim()).contains("${") || url.contains("${project.basedir}") || url.contains("${project.rootDirectory}")) continue;
            String repositoryId = this.getChildText(repository, "id", namespace);
            context.warning("Found unsupported expression in " + elementType + " URL (id: " + repositoryId + "): " + url);
            context.warning("Maven 4 only supports ${project.basedir} and ${project.rootDirectory} expressions in repository URLs");
            Comment comment = new Comment(" Repository disabled due to unsupported expression in URL: " + url + " ");
            Element parent = repository.getParentElement();
            parent.addContent(parent.indexOf((Content)repository), (Content)comment);
            this.removeElementWithFormatting(repository);
            context.detail("Fixed: Commented out " + elementType + " with unsupported URL expression (id: " + repositoryId + ")");
            fixed = true;
        }
        return fixed;
    }

    private Path findParentPomInMap(UpgradeContext context, String groupId, String artifactId, String version, Map<Path, Document> pomMap) {
        return pomMap.entrySet().stream().filter(entry -> {
            GAV gav = GAVUtils.extractGAVWithParentResolution(context, (Document)entry.getValue());
            return gav != null && Objects.equals(gav.groupId(), groupId) && Objects.equals(gav.artifactId(), artifactId) && (version == null || Objects.equals(gav.version(), version));
        }).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    private String getChildText(Element parent, String elementName, Namespace namespace) {
        Element element = parent.getChild(elementName, namespace);
        return element != null ? element.getTextTrim() : null;
    }

    private void removeElementWithFormatting(Element element) {
        Element parent = element.getParentElement();
        if (parent != null) {
            Text textContent;
            String text;
            Content prevContent;
            int index = parent.indexOf((Content)element);
            parent.removeContent((Content)element);
            if (index > 0 && (prevContent = parent.getContent(index - 1)) instanceof Text && (text = (textContent = (Text)prevContent).getText()).trim().isEmpty() && text.contains("\n")) {
                parent.removeContent(prevContent);
            }
        }
    }
}

