/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvn;

import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.InternalErrorException;
import org.apache.maven.Maven;
import org.apache.maven.api.MonotonicClock;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.cli.Logger;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.Sources;
import org.apache.maven.api.services.ToolchainsBuilder;
import org.apache.maven.api.services.ToolchainsBuilderRequest;
import org.apache.maven.api.services.ToolchainsBuilderResult;
import org.apache.maven.api.services.model.ModelProcessor;
import org.apache.maven.api.toolchain.PersistedToolchains;
import org.apache.maven.cling.event.ExecutionEventLogger;
import org.apache.maven.cling.invoker.CliUtils;
import org.apache.maven.cling.invoker.LookupContext;
import org.apache.maven.cling.invoker.LookupInvoker;
import org.apache.maven.cling.invoker.mvn.MavenContext;
import org.apache.maven.cling.transfer.ConsoleMavenTransferListener;
import org.apache.maven.cling.transfer.QuietMavenTransferListener;
import org.apache.maven.cling.transfer.SimplexTransferListener;
import org.apache.maven.cling.transfer.Slf4jMavenTransferListener;
import org.apache.maven.exception.DefaultExceptionHandler;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.ProfileActivation;
import org.apache.maven.execution.ProjectActivation;
import org.apache.maven.jline.MessageUtils;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.logging.LoggingExecutionListener;
import org.apache.maven.logging.MavenTransferListener;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferListener;

public class MavenInvoker
extends LookupInvoker<MavenContext> {
    protected static final Pattern NEXT_LINE = Pattern.compile("\r?\n");
    protected static final Pattern LAST_ANSI_SEQUENCE = Pattern.compile("(\u001b\\[[;\\d]*[ -/]*[@-~])[^\u001b]*$");
    protected static final String ANSI_RESET = "\u001b[m";

    public MavenInvoker(Lookup protoLookup, @Nullable Consumer<LookupContext> contextConsumer) {
        super(protoLookup, contextConsumer);
    }

    @Override
    protected MavenContext createContext(InvokerRequest invokerRequest) {
        return new MavenContext(invokerRequest, true, invokerRequest.options().orElse(null));
    }

    @Override
    protected int execute(MavenContext context) throws Exception {
        MavenExecutionRequest request = this.prepareMavenExecutionRequest();
        this.toolchains(context, request);
        this.populateRequest(context, context.lookup, request);
        return this.doExecute(context, request);
    }

    protected MavenExecutionRequest prepareMavenExecutionRequest() throws Exception {
        DefaultMavenExecutionRequest mavenExecutionRequest = new DefaultMavenExecutionRequest();
        mavenExecutionRequest.setRepositoryCache((RepositoryCache)new DefaultRepositoryCache());
        mavenExecutionRequest.setInteractiveMode(true);
        mavenExecutionRequest.setCacheTransferError(false);
        mavenExecutionRequest.setIgnoreInvalidArtifactDescriptor(true);
        mavenExecutionRequest.setIgnoreMissingArtifactDescriptor(true);
        mavenExecutionRequest.setRecursive(true);
        mavenExecutionRequest.setReactorFailureBehavior("FAIL_FAST");
        mavenExecutionRequest.setStartInstant(MonotonicClock.now());
        mavenExecutionRequest.setLoggingLevel(1);
        mavenExecutionRequest.setDegreeOfConcurrency(1);
        mavenExecutionRequest.setBuilderId("singlethreaded");
        return mavenExecutionRequest;
    }

    @Override
    protected void lookup(MavenContext context) throws Exception {
        if (context.maven == null) {
            super.lookup(context);
            context.maven = (Maven)context.lookup.lookup(Maven.class);
        }
    }

    @Override
    protected void postCommands(MavenContext context) throws Exception {
        super.postCommands(context);
        Logger logger = context.logger;
        if (context.options().relaxedChecksums().orElse(false).booleanValue()) {
            logger.info("Disabling strict checksum verification on all artifact downloads.");
        } else if (context.options().strictChecksums().orElse(false).booleanValue()) {
            logger.info("Enabling strict checksum verification on all artifact downloads.");
        }
    }

    protected void toolchains(MavenContext context, MavenExecutionRequest request) throws Exception {
        Path userToolchainsFile = null;
        if (context.options().altUserToolchains().isPresent()) {
            userToolchainsFile = context.cwd.resolve((String)context.options().altUserToolchains().get());
            if (!Files.isRegularFile(userToolchainsFile, new LinkOption[0])) {
                throw new FileNotFoundException("The specified user toolchains file does not exist: " + String.valueOf(userToolchainsFile));
            }
        } else {
            String userToolchainsFileStr = (String)context.protoSession.getUserProperties().get("maven.user.toolchains");
            if (userToolchainsFileStr != null) {
                userToolchainsFile = context.cwd.resolve(userToolchainsFileStr);
            }
        }
        Path installationToolchainsFile = null;
        if (context.options().altInstallationToolchains().isPresent()) {
            installationToolchainsFile = context.cwd.resolve((String)context.options().altInstallationToolchains().get());
            if (!Files.isRegularFile(installationToolchainsFile, new LinkOption[0])) {
                throw new FileNotFoundException("The specified installation toolchains file does not exist: " + String.valueOf(installationToolchainsFile));
            }
        } else {
            String installationToolchainsFileStr = (String)context.protoSession.getUserProperties().get("maven.installation.toolchains");
            if (installationToolchainsFileStr != null) {
                installationToolchainsFile = context.installationDirectory.resolve(installationToolchainsFileStr).normalize();
            }
        }
        request.setInstallationToolchainsFile(installationToolchainsFile != null ? installationToolchainsFile.toFile() : null);
        request.setUserToolchainsFile(userToolchainsFile != null ? userToolchainsFile.toFile() : null);
        ToolchainsBuilderRequest toolchainsRequest = ToolchainsBuilderRequest.builder().session(context.protoSession).installationToolchainsSource(installationToolchainsFile != null && Files.isRegularFile(installationToolchainsFile, new LinkOption[0]) ? Sources.fromPath((Path)installationToolchainsFile) : null).userToolchainsSource(userToolchainsFile != null && Files.isRegularFile(userToolchainsFile, new LinkOption[0]) ? Sources.fromPath((Path)userToolchainsFile) : null).build();
        context.eventSpyDispatcher.onEvent((Object)toolchainsRequest);
        context.logger.debug("Reading installation toolchains from '" + String.valueOf(installationToolchainsFile) + "'");
        context.logger.debug("Reading user toolchains from '" + String.valueOf(userToolchainsFile) + "'");
        ToolchainsBuilderResult toolchainsResult = ((ToolchainsBuilder)context.lookup.lookup(ToolchainsBuilder.class)).build(toolchainsRequest);
        context.eventSpyDispatcher.onEvent((Object)toolchainsResult);
        context.effectiveToolchains = toolchainsResult.getEffectiveToolchains();
        if (toolchainsResult.getProblems().hasWarningProblems()) {
            int totalProblems = toolchainsResult.getProblems().totalProblemsReported();
            context.logger.info("");
            context.logger.info(String.format("%s %s encountered while building the effective toolchains (use -e to see details)", totalProblems, totalProblems == 1 ? "problem was" : "problems were"));
            if (context.options().showErrors().orElse(false).booleanValue()) {
                for (BuilderProblem problem : toolchainsResult.getProblems().problems().toList()) {
                    context.logger.warn(problem.getMessage() + " @ " + problem.getLocation());
                }
            }
            context.logger.info("");
        }
    }

    @Override
    protected void populateRequest(MavenContext context, Lookup lookup, MavenExecutionRequest request) throws Exception {
        int degreeOfConcurrency;
        super.populateRequest(context, lookup, request);
        if (context.invokerRequest.rootDirectory().isEmpty()) {
            request.setMultiModuleProjectDirectory(context.invokerRequest.topDirectory().toFile());
            request.setRootDirectory(context.invokerRequest.topDirectory());
        }
        request.setToolchains(Optional.ofNullable(context.effectiveToolchains).map(PersistedToolchains::getToolchains).stream().flatMap(Collection::stream).map(ToolchainModel::new).collect(Collectors.groupingBy(ToolchainModel::getType)));
        request.setNoSnapshotUpdates(context.options().suppressSnapshotUpdates().orElse(false).booleanValue());
        request.setGoals(context.options().goals().orElse(List.of()));
        request.setReactorFailureBehavior(this.determineReactorFailureBehaviour(context));
        request.setRecursive(context.options().nonRecursive().orElse(!request.isRecursive()) == false);
        request.setOffline(context.options().offline().orElse(request.isOffline()).booleanValue());
        request.setUpdateSnapshots(context.options().updateSnapshots().orElse(false).booleanValue());
        request.setGlobalChecksumPolicy(this.determineGlobalChecksumPolicy(context));
        Path pom = this.determinePom(context, lookup);
        if (pom != null) {
            request.setPom(pom.toFile());
            if (pom.getParent() != null) {
                request.setBaseDirectory(pom.getParent().toFile());
            }
            if (context.invokerRequest.rootDirectory().isEmpty()) {
                Path rootDirectory = CliUtils.findMandatoryRoot(context.invokerRequest.topDirectory());
                request.setMultiModuleProjectDirectory(rootDirectory.toFile());
                request.setRootDirectory(rootDirectory);
            }
        }
        request.setTransferListener(this.determineTransferListener(context, context.options().noTransferProgress().orElse(false)));
        request.setExecutionListener(this.determineExecutionListener(context));
        request.setResumeFrom((String)context.options().resumeFrom().orElse(null));
        request.setResume(context.options().resume().orElse(false).booleanValue());
        request.setMakeBehavior(this.determineMakeBehavior(context));
        request.setCacheNotFound(context.options().cacheArtifactNotFound().orElse(true).booleanValue());
        request.setCacheTransferError(false);
        if (context.options().strictArtifactDescriptorPolicy().orElse(false).booleanValue()) {
            request.setIgnoreMissingArtifactDescriptor(false);
            request.setIgnoreInvalidArtifactDescriptor(false);
        } else {
            request.setIgnoreMissingArtifactDescriptor(true);
            request.setIgnoreInvalidArtifactDescriptor(true);
        }
        request.setIgnoreTransitiveRepositories(context.options().ignoreTransitiveRepositories().orElse(false).booleanValue());
        this.performProjectActivation(context, request.getProjectActivation());
        this.performProfileActivation(context, request.getProfileActivation());
        if (context.options().threads().isPresent() && (degreeOfConcurrency = this.calculateDegreeOfConcurrency((String)context.options().threads().get())) > 1) {
            request.setBuilderId("multithreaded");
            request.setDegreeOfConcurrency(degreeOfConcurrency);
        }
        if (context.options().builder().isPresent()) {
            request.setBuilderId((String)context.options().builder().get());
        }
    }

    protected Path determinePom(MavenContext context, Lookup lookup) {
        ModelProcessor modelProcessor;
        Path current = context.cwd.get();
        if (context.options().alternatePomFile().isPresent()) {
            current = context.cwd.resolve((String)context.options().alternatePomFile().get());
        }
        if ((modelProcessor = (ModelProcessor)lookup.lookupOptional(ModelProcessor.class).orElse(null)) != null) {
            return modelProcessor.locateExistingPom(current);
        }
        return Files.isRegularFile(current, new LinkOption[0]) ? current : null;
    }

    protected String determineReactorFailureBehaviour(MavenContext context) {
        if (context.options().failFast().isPresent()) {
            return "FAIL_FAST";
        }
        if (context.options().failAtEnd().isPresent()) {
            return "FAIL_AT_END";
        }
        if (context.options().failNever().isPresent()) {
            return "FAIL_NEVER";
        }
        return "FAIL_FAST";
    }

    protected String determineGlobalChecksumPolicy(MavenContext context) {
        if (context.options().strictChecksums().orElse(false).booleanValue()) {
            return "fail";
        }
        if (context.options().relaxedChecksums().orElse(false).booleanValue()) {
            return "warn";
        }
        return null;
    }

    protected ExecutionListener determineExecutionListener(MavenContext context) {
        ExecutionEventLogger listener = new ExecutionEventLogger(context.invokerRequest.messageBuilderFactory());
        if (context.eventSpyDispatcher != null) {
            listener = context.eventSpyDispatcher.chainListener((ExecutionListener)listener);
        }
        return new LoggingExecutionListener((ExecutionListener)listener, this.determineBuildEventListener(context));
    }

    protected TransferListener determineTransferListener(MavenContext context, boolean noTransferProgress) {
        AbstractTransferListener delegate;
        boolean quietCI;
        boolean quiet = context.options().quiet().orElse(false);
        boolean logFile = context.options().logFile().isPresent();
        boolean bl = quietCI = context.invokerRequest.ciInfo().isPresent() && context.options().forceInteractive().orElse(false) == false;
        if (quiet || noTransferProgress || quietCI) {
            delegate = new QuietMavenTransferListener();
        } else if (context.interactive && !logFile) {
            SimplexTransferListener simplex = new SimplexTransferListener((TransferListener)new ConsoleMavenTransferListener(context.invokerRequest.messageBuilderFactory(), context.terminal.writer(), context.invokerRequest.effectiveVerbose()));
            context.closeables.add(simplex);
            delegate = simplex;
        } else {
            delegate = new Slf4jMavenTransferListener();
        }
        return new MavenTransferListener((TransferListener)delegate, this.determineBuildEventListener(context));
    }

    protected String determineMakeBehavior(MavenContext context) {
        if (context.options().alsoMake().isPresent() && context.options().alsoMakeDependents().isEmpty()) {
            return "make-upstream";
        }
        if (context.options().alsoMake().isEmpty() && context.options().alsoMakeDependents().isPresent()) {
            return "make-downstream";
        }
        if (context.options().alsoMake().isPresent() && context.options().alsoMakeDependents().isPresent()) {
            return "make-both";
        }
        return null;
    }

    protected void performProjectActivation(MavenContext context, ProjectActivation projectActivation) {
        if (context.options().projects().isPresent() && !((List)context.options().projects().get()).isEmpty()) {
            List optionValues = (List)context.options().projects().get();
            for (String optionValue : optionValues) {
                for (String token : optionValue.split(",")) {
                    String selector = token.trim();
                    boolean active = true;
                    if (!selector.isEmpty()) {
                        if (selector.charAt(0) == '-' || selector.charAt(0) == '!') {
                            active = false;
                            selector = selector.substring(1);
                        } else if (token.charAt(0) == '+') {
                            selector = selector.substring(1);
                        }
                    }
                    boolean optional = false;
                    if (!selector.isEmpty() && selector.charAt(0) == '?') {
                        optional = true;
                        selector = selector.substring(1);
                    }
                    projectActivation.addProjectActivation(selector, active, optional);
                }
            }
        }
    }

    protected void performProfileActivation(MavenContext context, ProfileActivation profileActivation) {
        if (context.options().activatedProfiles().isPresent() && !((List)context.options().activatedProfiles().get()).isEmpty()) {
            List optionValues = (List)context.options().activatedProfiles().get();
            for (String optionValue : optionValues) {
                for (String token : optionValue.split(",")) {
                    String profileId = token.trim();
                    boolean active = true;
                    if (!profileId.isEmpty()) {
                        if (profileId.charAt(0) == '-' || profileId.charAt(0) == '!') {
                            active = false;
                            profileId = profileId.substring(1);
                        } else if (token.charAt(0) == '+') {
                            profileId = profileId.substring(1);
                        }
                    }
                    boolean optional = false;
                    if (!profileId.isEmpty() && profileId.charAt(0) == '?') {
                        optional = true;
                        profileId = profileId.substring(1);
                    }
                    profileActivation.addProfileActivation(profileId, active, optional);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doExecute(MavenContext context, MavenExecutionRequest request) throws Exception {
        MavenExecutionResult result;
        context.eventSpyDispatcher.onEvent((Object)request);
        try {
            result = context.maven.execute(request);
            context.eventSpyDispatcher.onEvent((Object)result);
        }
        finally {
            context.eventSpyDispatcher.close();
        }
        if (result.hasExceptions()) {
            DefaultExceptionHandler handler = new DefaultExceptionHandler();
            LinkedHashMap<String, String> references = new LinkedHashMap<String, String>();
            ArrayList<MavenProject> failedProjects = new ArrayList<MavenProject>();
            for (Throwable throwable : result.getExceptions()) {
                ExceptionSummary summary = handler.handleException(throwable);
                this.logSummary(context, summary, references, "");
                if (!(throwable instanceof LifecycleExecutionException)) continue;
                LifecycleExecutionException lifecycleExecutionException = (LifecycleExecutionException)throwable;
                failedProjects.add(lifecycleExecutionException.getProject());
            }
            context.logger.error("");
            if (!context.options().showErrors().orElse(false).booleanValue()) {
                context.logger.error("To see the full stack trace of the errors, re-run Maven with the '" + String.valueOf(MessageUtils.builder().strong((Object)"-e")) + "' switch");
            }
            if (!context.invokerRequest.effectiveVerbose()) {
                context.logger.error("Re-run Maven using the '" + String.valueOf(MessageUtils.builder().strong((Object)"-X")) + "' switch to enable verbose output");
            }
            if (!references.isEmpty()) {
                context.logger.error("");
                context.logger.error("For more information about the errors and possible solutions, please read the following articles:");
                for (Map.Entry entry : references.entrySet()) {
                    context.logger.error(String.valueOf(MessageUtils.builder().strong(entry.getValue())) + " " + (String)entry.getKey());
                }
            }
            if (result.canResume()) {
                this.logBuildResumeHint(context, "mvn [args] -r");
            } else if (!failedProjects.isEmpty()) {
                List sortedProjects = result.getTopologicallySortedProjects();
                failedProjects.sort(Comparator.comparing(sortedProjects::indexOf));
                MavenProject mavenProject = (MavenProject)failedProjects.get(0);
                if (!mavenProject.equals(sortedProjects.get(0))) {
                    String resumeFromSelector = this.getResumeFromSelector(sortedProjects, mavenProject);
                    this.logBuildResumeHint(context, "mvn [args] -rf " + resumeFromSelector);
                }
            }
            if (context.options().failNever().orElse(false).booleanValue()) {
                context.logger.info("Build failures were ignored.");
                return 0;
            }
            return 1;
        }
        return 0;
    }

    protected void logBuildResumeHint(MavenContext context, String resumeBuildHint) {
        context.logger.error("");
        context.logger.error("After correcting the problems, you can resume the build with the command");
        context.logger.error(MessageUtils.builder().a((CharSequence)"  ").strong((Object)resumeBuildHint).toString());
    }

    protected String getResumeFromSelector(List<MavenProject> mavenProjects, MavenProject firstFailedProject) {
        boolean hasOverlappingArtifactId;
        boolean bl = hasOverlappingArtifactId = mavenProjects.stream().filter(project -> firstFailedProject.getArtifactId().equals(project.getArtifactId())).count() > 1L;
        if (hasOverlappingArtifactId) {
            return firstFailedProject.getGroupId() + ":" + firstFailedProject.getArtifactId();
        }
        return ":" + firstFailedProject.getArtifactId();
    }

    protected void logSummary(MavenContext context, ExceptionSummary summary, Map<String, String> references, String indent) {
        String referenceKey = "";
        if (summary.getReference() != null && !summary.getReference().isEmpty()) {
            referenceKey = references.computeIfAbsent(summary.getReference(), k -> "[Help " + (references.size() + 1) + "]");
        }
        Object msg = summary.getMessage();
        if (!referenceKey.isEmpty()) {
            msg = ((String)msg).indexOf(10) < 0 ? (String)msg + " -> " + String.valueOf(MessageUtils.builder().strong((Object)referenceKey)) : (String)msg + "\n-> " + String.valueOf(MessageUtils.builder().strong((Object)referenceKey));
        }
        String[] lines = NEXT_LINE.split((CharSequence)msg);
        String currentColor = "";
        for (int i = 0; i < lines.length; ++i) {
            String line = currentColor + lines[i];
            Matcher matcher = LAST_ANSI_SEQUENCE.matcher(line);
            String nextColor = "";
            if (matcher.find() && ANSI_RESET.equals(nextColor = matcher.group(1))) {
                nextColor = "";
            }
            line = (String)indent + line + ("".equals(nextColor) ? "" : ANSI_RESET);
            if (i == lines.length - 1 && (context.options().showErrors().orElse(false).booleanValue() || summary.getException() instanceof InternalErrorException)) {
                context.logger.error(line, summary.getException());
            } else {
                context.logger.error(line);
            }
            currentColor = nextColor;
        }
        indent = (String)indent + "  ";
        for (ExceptionSummary child : summary.getChildren()) {
            this.logSummary(context, child, references, (String)indent);
        }
    }
}

