
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileBaseDriverAttributes.h
    \brief Definition of BaseDriver Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef BaseDriverAttributes_H
#define BaseDriverAttributes_H

#include "magics.h"
namespace magics {

class XmlNode;
class BaseDriverAttributes 
{
public:
//  --  constructor
    BaseDriverAttributes();
    
//  --  destructor
    virtual ~BaseDriverAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const BaseDriverAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string title_;
	string file_;
	string name_;
	bool firstnumber_;
	int firstvalue_;
	string fullname_;
	string legacyname_;
	int numberingwidth_;
	string separator_;
	string output_creator_;
	string mgb_template_;
	bool debug_;
	int width_;
	bool filelist_;
	string filelist_name_;
	bool filelist_reset_;
	intarray frame_list_;
	 

private:
	friend ostream& operator<<(ostream& s,const BaseDriverAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

