/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.api;

import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.api.Access;
import org.jruby.api.Error;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;

public class Check {
    public static RubyString checkEmbeddedNulls(ThreadContext context, IRubyObject obj) {
        Object[] checked = StringSupport.strNullCheck(obj);
        if (checked[0] == null) {
            throw Error.argumentError(context, (Boolean)checked[1] != false ? "string contains null char" : "string contains null byte");
        }
        return (RubyString)checked[0];
    }

    public static RubySymbol checkID(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubySymbol || obj instanceof RubyString) {
            return RubySymbol.newHardSymbol(context.runtime, obj);
        }
        IRubyObject str = TypeConverter.convertToTypeWithCheck(obj, Access.stringClass(context), "to_str");
        if (!str.isNil()) {
            return RubySymbol.newHardSymbol(context.runtime, str);
        }
        throw Error.typeError(context, String.valueOf(obj.callMethod(context, "inspect")) + " is not a symbol nor a string");
    }
}

