/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.AbstractLoggingCommand;
import org.jreleaser.cli.Template;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.templates.TemplateGenerationException;
import org.jreleaser.templates.TemplateGenerator;
import picocli.CommandLine;

@CommandLine.Command(name="generate")
public class TemplateGenerate
extends AbstractLoggingCommand<Template> {
    @CommandLine.ArgGroup(multiplicity="1")
    Composite composite;
    @CommandLine.Option(names={"-o", "--overwrite"})
    boolean overwrite;
    @CommandLine.Option(names={"-sn", "--snapshot"})
    boolean snapshot;

    @Override
    protected void collectCandidateDeprecatedArgs(Set<AbstractCommand.DeprecatedArg> args) {
        super.collectCandidateDeprecatedArgs(args);
        args.add(new AbstractCommand.DeprecatedArg("-sn", "--snapshot", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-d", "--distribution", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xd", "--exclude-distribution", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-p", "--packager", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-xp", "--exclude-packager", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-a", "--announcer", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-s", "--assembler", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-st", "--assembler-type", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-dt", "--distribution-type", "1.5.0"));
    }

    @Override
    protected void execute() {
        try {
            this.basedir = null != this.basedir ? this.basedir : Paths.get(".", new String[0]).normalize();
            this.initLogger();
            Path outputDirectory = this.basedir.resolve("src").resolve("jreleaser");
            Path output = TemplateGenerator.builder().logger(this.logger).distributionName(this.composite.distributionName()).distributionType(this.composite.distributionType()).packagerName(this.composite.packagerName()).announcerName(this.composite.announcerName()).assemblerType(this.composite.assemblerType()).assemblerName(this.composite.assemblerName()).outputDirectory(outputDirectory).overwrite(this.overwrite).snapshot(this.snapshot).build().generate();
            if (null != output && !this.quiet) {
                this.logger.info(this.$("jreleaser.template.generate.TEXT_success", new Object[0]), new Object[]{output.toAbsolutePath()});
            }
        }
        catch (TemplateGenerationException e) {
            throw new JReleaserException(this.$("ERROR_unexpected_error", new Object[0]), (Throwable)e);
        }
        finally {
            if (null != this.logger) {
                this.logger.close();
            }
        }
    }

    @Override
    protected Path getOutputDirectory() {
        if (null != this.outputdir) {
            return this.outputdir.resolve("jreleaser");
        }
        return this.basedir.resolve("out").resolve("jreleaser");
    }

    static class Composite {
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="announcer.header")
        Announcers announcers;
        @CommandLine.ArgGroup(exclusive=false, order=1, headingKey="assembler.header")
        Assemblers assemblers;
        @CommandLine.ArgGroup(exclusive=false, order=2, headingKey="packager.header")
        Packagers packagers;

        Composite() {
        }

        String announcerName() {
            return null != this.announcers ? this.announcers.announcerName : null;
        }

        String assemblerType() {
            return null != this.assemblers ? this.assemblers.assemblerType : null;
        }

        String assemblerName() {
            return null != this.assemblers ? this.assemblers.assemblerName : null;
        }

        String packagerName() {
            return null != this.packagers ? this.packagers.packagerName : null;
        }

        String distributionName() {
            return null != this.packagers ? this.packagers.distributionName : null;
        }

        Distribution.DistributionType distributionType() {
            return null != this.packagers ? this.packagers.distributionType : null;
        }
    }

    static class Packagers {
        @CommandLine.Option(names={"-d", "--distribution"}, paramLabel="<distribution>", required=true)
        String distributionName;
        @CommandLine.Option(names={"-p", "--packager"}, paramLabel="<packager>", required=true)
        String packagerName;
        @CommandLine.Option(names={"-dt", "--distribution-type"}, paramLabel="<type>", required=true, defaultValue="JAVA_BINARY")
        Distribution.DistributionType distributionType;

        Packagers() {
        }
    }

    static class Assemblers {
        @CommandLine.Option(names={"-st", "--assembler-type"}, paramLabel="<type>", descriptionKey="assembler.type", required=true)
        String assemblerType;
        @CommandLine.Option(names={"-s", "--assembler-name"}, paramLabel="<name>", descriptionKey="assembler.name", required=true)
        String assemblerName;

        Assemblers() {
        }
    }

    static class Announcers {
        @CommandLine.Option(names={"-a", "--announcer"}, paramLabel="<announcer>", descriptionKey="announcer.name", required=true)
        String announcerName;

        Announcers() {
        }
    }
}

