/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.InternalTransformer;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.internal.OperationDescriptorWrapper;
import org.gradle.tooling.events.test.TestOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.test.InternalDebugOptions;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.tooling.internal.protocol.test.InternalTaskSpec;
import org.gradle.tooling.internal.protocol.test.InternalTestExecutionRequest;
import org.gradle.util.internal.CollectionUtils;

public class TestExecutionRequest
implements InternalTestExecutionRequest {
    private final Collection<InternalTestDescriptor> testDescriptors;
    private final Collection<String> testClassNames;
    private final Collection<InternalJvmTestRequest> internalJvmTestRequests;
    private final InternalDebugOptions debugOptions;
    private final Map<String, List<InternalJvmTestRequest>> taskAndTests;
    private final boolean isRunDefaultTasks;
    private final List<InternalTaskSpec> taskSpecs;

    public TestExecutionRequest(Iterable<TestOperationDescriptor> operationDescriptors, Collection<String> testClassNames, Set<InternalJvmTestRequest> internalJvmTestRequests, InternalDebugOptions debugOptions, Map<String, List<InternalJvmTestRequest>> testTasks, boolean isRunDefaultTasks, List<InternalTaskSpec> taskSpecs) {
        this.testDescriptors = this.adaptDescriptors(operationDescriptors);
        this.testClassNames = testClassNames;
        this.internalJvmTestRequests = internalJvmTestRequests;
        this.debugOptions = debugOptions;
        this.taskAndTests = testTasks;
        this.isRunDefaultTasks = isRunDefaultTasks;
        this.taskSpecs = taskSpecs;
    }

    public InternalDebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public Map<String, List<InternalJvmTestRequest>> getTaskAndTests() {
        return this.taskAndTests;
    }

    @Override
    public Collection<InternalTestDescriptor> getTestExecutionDescriptors() {
        return this.testDescriptors;
    }

    @Override
    public Collection<String> getTestClassNames() {
        return this.testClassNames;
    }

    public Collection<InternalJvmTestRequest> getInternalJvmTestRequests() {
        return this.internalJvmTestRequests;
    }

    public List<InternalTaskSpec> getTaskSpecs() {
        return this.taskSpecs;
    }

    private Collection<InternalTestDescriptor> adaptDescriptors(Iterable<TestOperationDescriptor> operationDescriptors) {
        return CollectionUtils.collect(operationDescriptors, (InternalTransformer)new InternalTransformer<InternalTestDescriptor, OperationDescriptor>(){

            public InternalTestDescriptor transform(OperationDescriptor operationDescriptor) {
                return (InternalTestDescriptor)((OperationDescriptorWrapper)((Object)operationDescriptor)).getInternalOperationDescriptor();
            }
        });
    }

    @Override
    public boolean isRunDefaultTasks() {
        return this.isRunDefaultTasks;
    }
}

