/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EscapedIdentifiersLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "transformer", "Lorg/jetbrains/kotlin/ir/backend/js/lower/EscapedIdentifiersLowering$ReferenceTransformer;", "moduleKind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "isEscapedIdentifiersResolved", "", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ReferenceTransformer", "backend.js"})
public final class EscapedIdentifiersLowering
implements BodyLoweringPass {
    @NotNull
    private final ReferenceTransformer transformer;
    @NotNull
    private final ModuleKind moduleKind;
    private final boolean isEscapedIdentifiersResolved;

    public EscapedIdentifiersLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.transformer = new ReferenceTransformer(context2);
        ModuleKind moduleKind = context2.getConfiguration().get(JSConfigurationKeys.MODULE_KIND);
        Intrinsics.checkNotNull((Object)((Object)moduleKind));
        this.moduleKind = moduleKind;
        this.isEscapedIdentifiersResolved = CommonConfigurationKeysKt.getLanguageVersionSettings(context2.getConfiguration()).supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (!this.isEscapedIdentifiersResolved || this.moduleKind != ModuleKind.PLAIN) {
            return;
        }
        LowerKt.runOnFilePostfix(this, irFile, true);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!this.isEscapedIdentifiersResolved || this.moduleKind != ModuleKind.PLAIN) {
            return;
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, this.transformer);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001aH\u0016J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002J\u0014\u0010\u001e\u001a\u00020\u001f*\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\f\u0010 \u001a\u00020\u001c*\u00020!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EscapedIdentifiersLowering$ReferenceTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "globalThisReceiver", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "getGlobalThisReceiver", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "dummyDispatchReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getDummyDispatchReceiverParameter", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "needToBeWrappedWithGlobalThis", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "wrapInGlobalThis", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicMemberExpression;", "isThisReceiver", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "backend.js"})
    @SourceDebugExtension(value={"SMAP\nEscapedIdentifiersLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EscapedIdentifiersLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/EscapedIdentifiersLowering$ReferenceTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1#2:168\n*E\n"})
    private static final class ReferenceTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final JsIrBackendContext context;

        public ReferenceTransformer(@NotNull JsIrBackendContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.context = context2;
        }

        @NotNull
        public final JsIrBackendContext getContext() {
            return this.context;
        }

        private final IrCallImpl getGlobalThisReceiver() {
            IrType irType = this.context.getDynamicType();
            IrSimpleFunction irSimpleFunction = ((IrProperty)this.context.getIntrinsics().getGlobalThis().getOwner()).getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            return BuildersKt.IrCallImpl$default(-1, -1, irType, irSimpleFunction.getSymbol(), 0, null, null, 96, null);
        }

        private final IrValueParameter getDummyDispatchReceiverParameter(IrFunction $this$dummyDispatchReceiverParameter) {
            Object object = this.context.getIrFactory();
            int n2 = $this$dummyDispatchReceiverParameter.getStartOffset();
            int n3 = $this$dummyDispatchReceiverParameter.getEndOffset();
            IrDeclarationOrigin irDeclarationOrigin = $this$dummyDispatchReceiverParameter.getOrigin();
            Name name2 = SpecialNames.THIS;
            IrType irType = this.context.getIrBuiltIns().getAnyType();
            IrValueParameterSymbolImpl irValueParameterSymbolImpl = new IrValueParameterSymbolImpl(null, null, 3, null);
            IrParameterKind irParameterKind = IrParameterKind.DispatchReceiver;
            Object it = object = ((IrFactory)object).createValueParameter(n2, n3, irDeclarationOrigin, irParameterKind, name2, irType, false, irValueParameterSymbolImpl, null, false, false, false);
            boolean bl = false;
            ((IrDeclarationBase)it).setParent($this$dummyDispatchReceiverParameter);
            return object;
        }

        @Override
        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrValueDeclaration owner = expression2.getSymbol().getOwner();
            return !IrUtilsKt.isEffectivelyExternal(owner) || this.isThisReceiver(owner) || !this.needToBeWrappedWithGlobalThis(owner) ? super.visitGetValue(expression2) : (IrExpression)this.wrapInGlobalThis(owner, expression2);
        }

        @Override
        @NotNull
        public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
            IrExpression irExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrValueDeclaration field = expression2.getSymbol().getOwner();
            if (!IrUtilsKt.isEffectivelyExternal(field) || !this.needToBeWrappedWithGlobalThis(field)) {
                irExpression = super.visitSetValue(expression2);
            } else {
                int n2 = expression2.getStartOffset();
                int n3 = expression2.getEndOffset();
                IrDynamicMemberExpression irDynamicMemberExpression = this.wrapInGlobalThis(field, expression2);
                IrExpression irExpression2 = expression2.getValue();
                IrType irType = expression2.getType();
                IrFieldSymbolImpl irFieldSymbolImpl = new IrFieldSymbolImpl(null, null, 3, null);
                irExpression = BuildersKt.IrSetFieldImpl(n2, n3, irFieldSymbolImpl, irDynamicMemberExpression, irExpression2, irType, null, null);
            }
            return irExpression;
        }

        @Override
        @NotNull
        public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrClass owner = (IrClass)expression2.getSymbol().getOwner();
            return !IrUtilsKt.isEffectivelyExternal(owner) || !this.needToBeWrappedWithGlobalThis(owner) ? super.visitGetObjectValue(expression2) : (IrExpression)this.wrapInGlobalThis(owner, expression2);
        }

        @Override
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            IrCall irCall;
            IrElement property2;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrSimpleFunction function2 = IrResolveUtilsKt.getRealOverrideTarget((IrSimpleFunction)expression2.getSymbol().getOwner());
            Object object = function2.getCorrespondingPropertySymbol();
            IrElement irElement = object != null && (object = (IrProperty)object.getOwner()) != null ? (IrElement)object : (property2 = (IrElement)function2);
            if (expression2.getDispatchReceiver() != null || !IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)property2) || !this.needToBeWrappedWithGlobalThis((IrDeclarationWithName)property2)) {
                irCall = expression2;
            } else {
                IrCall irCall2;
                IrCall $this$visitCall_u24lambda_u241 = irCall2 = expression2;
                boolean bl = false;
                $this$visitCall_u24lambda_u241.insertDispatchReceiver(this.getGlobalThisReceiver());
                IrCall it = irCall2;
                boolean bl2 = false;
                if (function2.getDispatchReceiverParameter() == null) {
                    function2.setParameters(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.getDummyDispatchReceiverParameter(function2)), (Iterable)function2.getParameters()));
                }
                irCall = irCall2;
            }
            IrCall updatedCall = irCall;
            return super.visitCall(updatedCall);
        }

        private final boolean needToBeWrappedWithGlobalThis(IrDeclarationWithName $this$needToBeWrappedWithGlobalThis) {
            String string = AnnotationUtilsKt.getJsNameOrKotlinName($this$needToBeWrappedWithGlobalThis).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return !IdentifierPolicyKt.isValidES5Identifier(string);
        }

        private final IrDynamicMemberExpression wrapInGlobalThis(IrDeclarationWithName $this$wrapInGlobalThis, IrExpression expression2) {
            int n2 = expression2.getStartOffset();
            int n3 = expression2.getEndOffset();
            IrType irType = expression2.getType();
            String string = AnnotationUtilsKt.getJsNameOrKotlinName($this$wrapInGlobalThis).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            return BuildersKt.IrDynamicMemberExpressionImpl(n2, n3, irType, string, this.getGlobalThisReceiver());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isThisReceiver(IrValueDeclaration $this$isThisReceiver) {
            if ($this$isThisReceiver instanceof IrVariable) return false;
            IrDeclarationParent p2 = $this$isThisReceiver.getParent();
            if (p2 instanceof IrSimpleFunction) {
                if ($this$isThisReceiver != ((IrSimpleFunction)p2).getDispatchReceiverParameter()) return false;
                return true;
            }
            if (!(p2 instanceof IrClass)) return false;
            if ($this$isThisReceiver != ((IrClass)p2).getThisReceiver()) return false;
            return true;
        }
    }
}

